from machine import Pin,SPI,PWM

import framebuf
import time

DC = 8
CS = 9
SCK = 10
MOSI = 11
RST = 12
BL = 13

def color_swap(color):
    r = (color >> 11) & 0x3F
    g = (color >> 5)  & 0x1F   
    b = color & 0x1F          

    b = b * 2
    g = int(g / 2)

    new_color = (r << 11) | (b << 5) | (g << 0)

    return new_color

class LCD_1inch83(framebuf.FrameBuffer):
    def __init__(self):
        self.width = 240
        self.height = 284
        
        self.cs = Pin(CS,Pin.OUT)
        self.rst = Pin(RST,Pin.OUT)
        
        self.cs(1)
        self.spi = SPI(1,40_000_000,polarity=0, phase=0,sck=Pin(SCK),mosi=Pin(MOSI),miso=None)
        self.dc = Pin(DC,Pin.OUT)
        self.dc(1)
        self.buffer = bytearray(self.width *  self.height * 2)
        super().__init__(self.buffer, self.width, self.height, framebuf.RGB565)
        self.init_display()
        
        self.red   =   color_swap(0x001F)
        self.green =   color_swap(0x07E0)
        self.blue  =   color_swap(0xF800)
        self.custom=   color_swap(0x2e86)# 3d9b
        self.white =   0xffff
        
        self.fill(self.white)
        self.show()

        self.pwm = PWM(Pin(BL))
        self.pwm.freq(5000)
        
    def write_cmd(self, cmd):
        self.cs(1)
        self.dc(0)
        self.cs(0)
        self.spi.write(bytearray([cmd]))
        self.cs(1)

    def write_data(self, buf):
        self.cs(1)
        self.dc(1)
        self.cs(0)
        self.spi.write(bytearray([buf]))
        self.cs(1)
    def set_bl_pwm(self,duty):
        self.pwm.duty_u16(duty)#max 65535
    def init_display(self):
        """Initialize dispaly"""  
        self.rst(1)
        time.sleep(0.01)
        self.rst(0)
        time.sleep(0.01)
        self.rst(1)
        time.sleep(0.05)
        
        self.write_cmd(0x36)
        self.write_data(0x00)

        self.write_cmd(0x3A) 
        self.write_data(0x05)

        self.write_cmd(0xB2)
        self.write_data(0x0C)
        self.write_data(0x0C)
        self.write_data(0x00)
        self.write_data(0x33)
        self.write_data(0x33)

        self.write_cmd(0xB7) 
        self.write_data(0x35)  

        self.write_cmd(0xBB)
        self.write_data(0x19)

        self.write_cmd(0xC0)
        self.write_data(0x2C)

        self.write_cmd(0xC2)
        self.write_data(0x01)

        self.write_cmd(0xC3)
        self.write_data(0x12)  

        self.write_cmd(0xC4)
        self.write_data(0x20)  

        self.write_cmd(0xC6)
        self.write_data(0x0F)   

        self.write_cmd(0xD0);
        self.write_data(0xA4)
        self.write_data(0xA1)

        self.write_cmd(0xE0);
        self.write_data(0xD0)
        self.write_data(0x04)
        self.write_data(0x0D)
        self.write_data(0x11)
        self.write_data(0x13)
        self.write_data(0x2B)
        self.write_data(0x3F)
        self.write_data(0x54)
        self.write_data(0x4C)
        self.write_data(0x18)
        self.write_data(0x0D)
        self.write_data(0x0B)
        self.write_data(0x1F)
        self.write_data(0x23)

        self.write_cmd(0xE1)
        self.write_data(0xD0)
        self.write_data(0x04)
        self.write_data(0x0C)
        self.write_data(0x11)
        self.write_data(0x13)
        self.write_data(0x2C)
        self.write_data(0x3F)
        self.write_data(0x44)
        self.write_data(0x51)
        self.write_data(0x2F)
        self.write_data(0x1F)
        self.write_data(0x1F)
        self.write_data(0x20)
        self.write_data(0x23)

        self.write_cmd(0x21)

        self.write_cmd(0x11)
        time.sleep(0.2)
        self.write_cmd(0x29)
        time.sleep(0.01)

    def show(self):
        self.write_cmd(0x2A)
        self.write_data(0x00)
        self.write_data(0x00)
        self.write_data(0x00)
        self.write_data(0xef)
        
        self.write_cmd(0x2B)
        self.write_data(0x00)
        self.write_data(0x00)
        self.write_data(0x01)
        self.write_data(0x1c)
        
        self.write_cmd(0x2C)
        
        self.cs(1)
        self.dc(1)
        self.cs(0)
        self.spi.write(self.buffer)
        self.cs(1)


if __name__=='__main__':
  
    LCD = LCD_1inch83()
    LCD.set_bl_pwm(65535)
    
    LCD.fill(LCD.white)
    LCD.text("RP2040-LCD-1.83",60,125,LCD.green)
    LCD.fill_rect(0,40,240,40,LCD.blue)
    LCD.text("Waveshare",80,57,LCD.white)


    LCD.show()



