#include "pin_config.h"
#include <LovyanGFX.hpp>
#include "lvgl.h"
#include "Arduino.h"
#include <xpt2046.h>
#include "data.h"



SPIClass SPI2 = SPIClass(SPI2_HOST);
XPT2046 touch = XPT2046(SPI2, TOUCHSCREEN_CS_PIN, TOUCHSCREEN_IRQ_PIN);
touch_calibration_t calibration_data[4];

class LGFX : public lgfx::LGFX_Device {
    lgfx::Panel_ST7796 _panel_instance;
    lgfx::Bus_SPI _bus_instance;

public:
    LGFX(void) {
        {
            auto cfg = _bus_instance.config();
            cfg.spi_host = SPI3_HOST; // 使用的SPI
            cfg.spi_mode = 3;         // SPI模式
            cfg.freq_write = 80000000; // SPI写频率
            cfg.freq_read = 80000000;  // SPI读频率
            cfg.spi_3wire = true;      // 3线模式
            cfg.use_lock = true;       // 使用事务锁
            cfg.dma_channel = SPI_DMA_CH_AUTO; // 自动DMA
            cfg.pin_sclk = PIN_LCD_SCK; // SCK引脚
            cfg.pin_mosi = PIN_LCD_SDA; // MOSI引脚
            cfg.pin_miso = -1;          // 不使用MISO
            cfg.pin_dc = PIN_LCD_RS;    // DC引脚
            _bus_instance.config(cfg);
            _panel_instance.setBus(&_bus_instance);
        }

        {
            auto cfg = _panel_instance.config();
            cfg.pin_cs = PIN_LCD_CS;         // Chip Select (CS) pin
            cfg.pin_rst = PIN_LCD_RES;       // Reset (RST) pin
            cfg.pin_busy = -1;               // Not used
            cfg.memory_width = 320;          // Width of the display's internal memory
            cfg.memory_height = 480;         // Height of the display's internal memory
            cfg.panel_width = 320;           // Actual display panel width
            cfg.panel_height = 480;          // Actual display panel height
            cfg.offset_x = 0;                // Horizontal offset
            cfg.offset_y = 0;                // Vertical offset
            cfg.offset_rotation = 0;         // Rotation offset
            cfg.dummy_read_pixel = 8;        // Dummy bits before reading pixel data
            cfg.dummy_read_bits = 1;         // Dummy bits before reading raw data
            cfg.readable = true;             // Enable reading from the panel
            cfg.invert = true;               // Invert display colors (true = inverted)
            cfg.rgb_order = false;           // RGB color order (false = RGB, true = BGR)
            cfg.dlen_16bit = false;          // Set data length mode (false = 8-bit)
            cfg.bus_shared = false;          // Bus is not shared with other devices
            _panel_instance.config(cfg);

        }

        setPanel(&_panel_instance);
    }
};





LGFX tft;
LGFX_Sprite sprite(&tft);

void setup() {
  
    tft.init();
    Serial.begin(115200);

    tft.fillScreen(TFT_RED); 
    // Configure backlight PWM
    ledcSetup(0, 5000, 8);  // Set up PWM channel 0, 5000 Hz frequency, 8-bit resolution (values from 0 to 255)
    ledcAttachPin(LCD_BL, 0); // Attach backlight pin (e.g., GPIO5) to PWM channel 0

    // Demonstrate backlight fade-in effect
    tft.fillScreen(TFT_RED);
    delay(1000);
    // Gradually increase brightness from low to high
    for (int brightness = 0; brightness <= 255; brightness++) {
        ledcWrite(0, brightness); // Set PWM duty cycle to control brightness
        delay(10);
    }

    // Maintain medium brightness
    ledcWrite(0, 128);  // Set backlight to 50% brightness
    // delay(1000);
    delay(1000);
    tft.fillScreen(TFT_BLUE);
    delay(1000);
    tft.fillScreen(TFT_GREEN);
    delay(1000);
    tft.fillScreen(TFT_WHITE);

    // Display "Touch Test" centered at the top
    tft.setTextSize(3);
    tft.setTextColor(TFT_BLACK, TFT_WHITE);
    tft.drawCenterString("Touch Test", tft.width() / 2, 10, 1);  // Third parameter is font (1 = built-in font)

    SPI2.begin(TOUCHSCREEN_SCLK_PIN, TOUCHSCREEN_MISO_PIN, TOUCHSCREEN_MOSI_PIN);
    touch.begin(320, 480); // Set touch panel resolution

    // Please adjust the calibration data below based on your actual screen
    touch.setCal(calibration_data[0].rawX, calibration_data[2].rawX, calibration_data[0].rawY, calibration_data[2].rawY, 320, 480);


}

void loop() {
    static int lastX = -1, lastY = -1;
    static bool isDrawing = false;
    
    if (touch.pressed()) {
        // Get raw touch coordinates
        int x = touch.RawX();
        int y = touch.RawY();

        // Manually map touch coordinates to screen size
        // Touch panel typically outputs 0–4095, but may vary by hardware
        int mappedX = map(x, 100, 1850, 0, 320);  // Map X to 0–320 screen range
        int mappedY = map(y, 100, 1860, 0, 480);  // Map Y to 0–480 screen range

        // Debug output (optional)
        // Serial.print("Touched at: ");
        // Serial.print(mappedX);
        // Serial.print(", ");
        // Serial.println(mappedY);
        
        // tft.drawLine(10, 10, 200, 200, TFT_WHITE);  // 绘制一条简单的线
    // delay(1000); 
        if (!isDrawing) {
            lastX = mappedX;
            lastY = mappedY;
            isDrawing = true; // Start drawing
        } else {
            // Draw line from last touch to current touch
            drawThickLine(lastX, lastY, mappedX, mappedY, TFT_BLACK, 4);   // 4 = line thickness
            lastX = mappedX; // Update last coordinates
            lastY = mappedY;
        }
    } else {
        isDrawing = false; // Touch Release
    }

    delay(30);
}

void drawThickLine(int x1, int y1, int x2, int y2, uint16_t color, int thickness) {
    for (int i = -thickness / 2; i <= thickness / 2; i++) {
        tft.drawLine(x1 + i, y1, x2 + i, y2, color);  // Draw multiple lines with horizontal offset
        tft.drawLine(x1, y1 + i, x2, y2 + i, color);  // Draw multiple lines with vertical offset
    }
}

