#pragma once

#include "../Arduino_DataBus.h"

#if defined(ESP32) && (CONFIG_IDF_TARGET_ESP32P4)

#include "../Arduino_GFX.h"
#include "../databus/Arduino_ESP32DSIPanel.h"

#include <esp_cache.h>

/* HX83xx User Define command set 用户自定义命令集 */
#define UD_SETADDRESSMODE                       0x36    /* Set address mode */
#define UD_SETSEQUENCE                          0xB0    /* Set sequence */
#define UD_SETPOWER                             0xB1    /* Set power */
#define UD_SETDISP                              0xB2    /* Set display related register */
#define UD_SETCYC                               0xB4    /* Set display waveform cycles */
#define UD_SETVCOM                              0xB6    /* Set VCOM voltage */
#define UD_SETTE                                0xB7    /* Set internal TE function */
#define UD_SETSENSOR                            0xB8    /* Set temperature sensor */
#define UD_SETEXTC                              0xB9    /* Set extension command */
#define UD_SETMIPI                              0xBA    /* Set MIPI control */
#define UD_SETOTP                               0xBB    /* Set OTP */
#define UD_SETREGBANK                           0xBD    /* Set register bank */
#define UD_SETDGCLUT                            0xC1    /* Set DGC LUT */
#define UD_SETID                                0xC3    /* Set ID */
#define UD_SETDDB                               0xC4    /* Set DDB */
#define UD_SETCABC                              0xC9    /* Set CABC control */
#define UD_SETCABCGAIN                          0xCA
#define UD_SETPANEL                             0xCC
#define UD_SETOFFSET                            0xD2
#define UD_SETGIP0                              0xD3    /* Set GIP Option0 */
#define UD_SETGIP1                              0xD5    /* Set GIP Option1 */
#define UD_SETGIP2                              0xD6    /* Set GIP Option2 */
#define UD_SETGIP3                              0xD8    /* Set GIP Option2 */
#define UD_SETGPO                               0xD9
#define UD_SETSCALING                           0xDD
#define UD_SETIDLE                              0xDF
#define UD_SETGAMMA                             0xE0    /* Set gamma curve related setting */
#define UD_SETCHEMODE_DYN                       0xE4
#define UD_SETCHE                               0xE5
#define UD_SETCESEL                             0xE6    /* Enable color enhance */
#define UD_SET_SP_CMD                           0xE9
#define UD_SETREADINDEX                         0xFE    /* Set SPI Read Index */
#define UD_GETSPIREAD                           0xFF    /* SPI Read Command Data */


static const lcd_init_cmd_t hx8394_init_operations[] = {
    //  {cmd, { data }, data_size, delay_ms}
    /* 720 * 1280 */
    {UD_SETADDRESSMODE, (uint8_t []){0x01}, 1,0},
    {UD_SETEXTC,        (uint8_t []){0xFF, 0x83, 0x94}, 3,0},
    {UD_SETMIPI,        (uint8_t []){0x61, 0x03, 0x68, 0x6B, 0xB2, 0xC0}, 6,0}, //0x61
    {UD_SETPOWER,       (uint8_t []){0x48, 0x12, 0x72, 0x09, 0x32, 0x54, 0x71, 0x71, 0x57, 0x47}, 10,0},
    {UD_SETDISP,        (uint8_t []){0x00, 0x80, 0x64, 0x0C, 0x0D, 0x2F}, 6,0},
    {UD_SETCYC,         (uint8_t []){0x73, 0x74, 0x73, 0x74, 0x73, 0x74, 0x01, 0x0C, 0x86, 0x75, 0x00, 0x3F, 0x73, 0x74, 0x73, 0x74, 0x73, 0x74, 0x01, 0x0C, 0x86}, 21,0},
    {UD_SETGIP0,        (uint8_t []){0x00, 0x00, 0x07, 0x07, 0x40, 0x07, 0x0C, 0x00, 0x08, 0x10, 0x08, 0x00, 0x08, 0x54, 0x15, 0x0A, 0x05, 0x0A, 0x02, 0x15, 0x06, 0x05, 0x06, 0x47, 0x44, 0x0A, 0x0A, 0x4B, 0x10, 0x07, 0x07, 0x0C, 0x40}, 33,0},
    {UD_SETGIP1,        (uint8_t []){0x1C, 0x1C, 0x1D, 0x1D, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x24, 0x25, 0x18, 0x18, 0x26, 0x27, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x20, 0x21, 0x18, 0x18, 0x18, 0x18}, 44,0},
    {UD_SETGIP2,        (uint8_t []){0x1C, 0x1C, 0x1D, 0x1D, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x0B, 0x0A, 0x09, 0x08, 0x21, 0x20, 0x18, 0x18, 0x27, 0x26, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x25, 0x24, 0x18, 0x18, 0x18, 0x18}, 44,0},
    {UD_SETVCOM,        (uint8_t []){0x6E, 0x6E}, 2,0}, //caiji
    {UD_SETGAMMA,       (uint8_t []){0x00, 0x0A, 0x15, 0x1B, 0x1E, 0x21, 0x24, 0x22, 0x47, 0x56, 0x65, 0x66, 0x6E, 0x82, 0x88, 0x8B, 0x9A, 0x9D, 0x98, 0xA8, 0xB9, 0x5D, 0x5C, 0x61, 0x66, 0x6A, 0x6F, 0x7F, 0x7F, 0x00, 0x0A, 0x15, 0x1B, 0x1E, 0x21, 0x24, 0x22, 0x47, 0x56, 0x65, 0x65, 0x6E, 0x81, 0x87, 0x8B, 0x98, 0x9D, 0x99, 0xA8, 0xBA, 0x5D, 0x5D, 0x62, 0x67, 0x6B, 0x72, 0x7F, 0x7F}, 58,0},
    {0xC0,              (uint8_t []){0x1F, 0x31}, 2,0},
    {UD_SETPANEL,       (uint8_t []){0x03}, 1,0},
    {0xD4,              (uint8_t []){0x02}, 1,0},
    {UD_SETREGBANK,     (uint8_t []){0x02}, 1,0},
    {UD_SETGIP3,        (uint8_t []){0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}, 12,0},
    {UD_SETREGBANK,     (uint8_t []){0x00}, 1,0},
    {UD_SETREGBANK,     (uint8_t []){0x01}, 1,0},
    {UD_SETPOWER,       (uint8_t []){0x00}, 1,0},
    {UD_SETREGBANK,     (uint8_t []){0x00}, 1,0},
    {0xBF,              (uint8_t []){0x40, 0x81, 0x50, 0x00, 0x1A, 0xFC, 0x01}, 7,0},
    {0xC6,              (uint8_t []){0xED}, 1,0},
	{0x11, (uint8_t[]){0x00}, 0, 120},
    {0x29, (uint8_t[]){0x00}, 0, 0},
};


static const lcd_init_cmd_t jd9165_init_operations[] = {
    //  {cmd, { data }, data_size, delay_ms}
    //{0x11, (uint8_t []){0x00}, 1, 120},
    //{0x29, (uint8_t []){0x00}, 1, 20},

    {0x30, (uint8_t[]){0x00}, 1, 0},
    {0xF7, (uint8_t[]){0x49, 0x61, 0x02, 0x00}, 4, 0},
    {0x30, (uint8_t[]){0x01}, 1, 0},
    {0x04, (uint8_t[]){0x0C}, 1, 0},
    {0x05, (uint8_t[]){0x00}, 1, 0},
    {0x06, (uint8_t[]){0x00}, 1, 0},
    {0x0B, (uint8_t[]){0x11}, 1, 0},
    {0x17, (uint8_t[]){0x00}, 1, 0},
    {0x20, (uint8_t[]){0x04}, 1, 0},
    {0x1F, (uint8_t[]){0x05}, 1, 0},
    {0x23, (uint8_t[]){0x00}, 1, 0},
    {0x25, (uint8_t[]){0x19}, 1, 0},
    {0x28, (uint8_t[]){0x18}, 1, 0},
    {0x29, (uint8_t[]){0x04}, 1, 0},
    {0x2A, (uint8_t[]){0x01}, 1, 0},
    {0x2B, (uint8_t[]){0x04}, 1, 0},
    {0x2C, (uint8_t[]){0x01}, 1, 0},
    {0x30, (uint8_t[]){0x02}, 1, 0},
    {0x01, (uint8_t[]){0x22}, 1, 0},
    {0x03, (uint8_t[]){0x12}, 1, 0},
    {0x04, (uint8_t[]){0x00}, 1, 0},
    {0x05, (uint8_t[]){0x64}, 1, 0},
    {0x0A, (uint8_t[]){0x08}, 1, 0},
    {0x0B, (uint8_t[]){0x0A, 0x1A, 0x0B, 0x0D, 0x0D, 0x11, 0x10, 0x06, 0x08, 0x1F, 0x1D}, 11, 0},
    {0x0C, (uint8_t[]){0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D}, 11, 0},
    {0x0D, (uint8_t[]){0x16, 0x1B, 0x0B, 0x0D, 0x0D, 0x11, 0x10, 0x07, 0x09, 0x1E, 0x1C}, 11, 0},
    {0x0E, (uint8_t[]){0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D}, 11, 0},
    {0x0F, (uint8_t[]){0x16, 0x1B, 0x0D, 0x0B, 0x0D, 0x11, 0x10, 0x1C, 0x1E, 0x09, 0x07}, 11, 0},
    {0x10, (uint8_t[]){0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D}, 11, 0},
    {0x11, (uint8_t[]){0x0A, 0x1A, 0x0D, 0x0B, 0x0D, 0x11, 0x10, 0x1D, 0x1F, 0x08, 0x06}, 11, 0},
    {0x12, (uint8_t[]){0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D}, 11, 0},
    {0x14, (uint8_t[]){0x00, 0x00, 0x11, 0x11}, 4, 0},
    {0x18, (uint8_t[]){0x99}, 1, 0},
    {0x30, (uint8_t[]){0x06}, 1, 0},
    {0x12, (uint8_t[]){0x36, 0x2C, 0x2E, 0x3C, 0x38, 0x35, 0x35, 0x32, 0x2E, 0x1D, 0x2B, 0x21, 0x16, 0x29}, 14, 0},
    {0x13, (uint8_t[]){0x36, 0x2C, 0x2E, 0x3C, 0x38, 0x35, 0x35, 0x32, 0x2E, 0x1D, 0x2B, 0x21, 0x16, 0x29}, 14, 0},

    // {0x30, (uint8_t[]){0x08}, 1, 0},
    // {0x05, (uint8_t[]){0x01}, 1, 0},
    // {0x0C, (uint8_t[]){0x1A}, 1, 0},
    // {0x0D, (uint8_t[]){0x0E}, 1, 0},

    // {0x30, (uint8_t[]){0x07}, 1, 0},
    // {0x01, (uint8_t[]){0x04}, 1, 0},

    {0x30, (uint8_t[]){0x0A}, 1, 0},
    {0x02, (uint8_t[]){0x4F}, 1, 0},
    {0x0B, (uint8_t[]){0x40}, 1, 0},
    {0x12, (uint8_t[]){0x3E}, 1, 0},
    {0x13, (uint8_t[]){0x78}, 1, 0},
    {0x30, (uint8_t[]){0x0D}, 1, 0},
    {0x0D, (uint8_t[]){0x04}, 1, 0},
    {0x10, (uint8_t[]){0x0C}, 1, 0},
    {0x11, (uint8_t[]){0x0C}, 1, 0},
    {0x12, (uint8_t[]){0x0C}, 1, 0},
    {0x13, (uint8_t[]){0x0C}, 1, 0},
    {0x30, (uint8_t[]){0x00}, 1, 0},

    {0X3A, (uint8_t[]){0x55}, 1, 0},
    {0x11, (uint8_t[]){0x00}, 1, 120},
    {0x29, (uint8_t[]){0x00}, 1, 50},
};

class Arduino_DSI_Display : public Arduino_GFX
{
public:
  Arduino_DSI_Display(
      int16_t w, int16_t h, Arduino_ESP32DSIPanel *dsipanel, uint8_t r = 0, bool auto_flush = true,
      int8_t rst = GFX_NOT_DEFINED, const lcd_init_cmd_t *init_operations = NULL, size_t init_operations_len = GFX_NOT_DEFINED,
      uint8_t col_offset1 = 0, uint8_t row_offset1 = 0, uint8_t col_offset2 = 0, uint8_t row_offset2 = 0);

  bool begin(int32_t speed = GFX_NOT_DEFINED) override;
  void writePixelPreclipped(int16_t x, int16_t y, uint16_t color) override;
  void writeFastVLine(int16_t x, int16_t y, int16_t h, uint16_t color) override;
  void writeFastVLineCore(int16_t x, int16_t y, int16_t h, uint16_t color);
  void writeFastHLine(int16_t x, int16_t y, int16_t w, uint16_t color) override;
  void writeFastHLineCore(int16_t x, int16_t y, int16_t w, uint16_t color);
  void writeFillRectPreclipped(int16_t x, int16_t y, int16_t w, int16_t h, uint16_t color) override;
  void drawIndexedBitmap(int16_t x, int16_t y, uint8_t *bitmap, uint16_t *color_index, int16_t w, int16_t h, int16_t x_skip = 0) override;
  void draw16bitRGBBitmap(int16_t x, int16_t y, uint16_t *bitmap, int16_t w, int16_t h) override;
  void draw16bitBeRGBBitmap(int16_t x, int16_t y, uint16_t *bitmap, int16_t w, int16_t h) override;
  void flush(bool force_flush = false) override;

  void drawYCbCrBitmap(int16_t x, int16_t y, uint8_t *yData, uint8_t *cbData, uint8_t *crData, int16_t w, int16_t h);
  uint16_t *getFramebuffer();

protected:
  uint16_t *_framebuffer;
  size_t _framebuffer_size;
  Arduino_ESP32DSIPanel *_dsipanel;
  bool _auto_flush;
  int8_t _rst;
  const lcd_init_cmd_t *_init_operations;
  size_t _init_operations_len;
  int16_t MAX_X, MAX_Y;
  uint8_t COL_OFFSET1, ROW_OFFSET1;
  uint8_t COL_OFFSET2, ROW_OFFSET2;
  uint8_t _xStart, _yStart;
  uint16_t _fb_width, _fb_height, _fb_max_x, _fb_max_y;

private:
};

#endif // #if defined(ESP32) && (CONFIG_IDF_TARGET_ESP32P4)
