/*
 *  This sketch demonstrates how to scan WiFi networks.
 *  The API is based on the Arduino WiFi Shield library, but has significant changes as newer WiFi functions are supported.
 *  E.g. the return value of `encryptionType()` different because more modern encryption is supported.
 */
#include "WiFi.h"
#include <BLEDevice.h>

#define GPIO_NUM (28)
#define GPIO_C_NUM (12)

void rgb_test();
void wifi_scan();
void gpio_test();
void adc_test();
void ram_test();

uint8_t gpio_map[GPIO_NUM] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 21, 35, 36, 37, 39, 40, 41, 42, 45, 46};   //0 is boot, 19,20 is usb, 38 is rgb, and 43,44 is usb to uart
uint8_t gpio_map1[GPIO_NUM] = {11, 12, 13, 14, 15, 16, 17, 18, 33, 34, 35, 36};
uint8_t gpio_map2[GPIO_NUM] = {7, 6, 5, 4, 2, 1, 41, 42, 40, 39, 38, 37};
uint8_t gpio_map4[GPIO_NUM] = {};

void setup()
{
    Serial.begin(115200);
    // Serial.println("Setup done");

    ram_test();
    rgb_test();
    //gpio_test();
    adc_test();
    wifi_scan();
    //ble_scan();
    pinMode(28, INPUT_PULLUP);
    
}

void loop()
{
    // adc_test();
    // Wait a bit before scanning again.
    if(digitalRead(28)==0)
    {
      rgb_test();
    }
    delay(10);
}
void rgb_test()
{
  digitalWrite(RGB_BUILTIN, HIGH);  // Turn the RGB LED white
  delay(1000);
  digitalWrite(RGB_BUILTIN, LOW);  // Turn the RGB LED off

}
void ram_test()
{
    Serial.println("/********** RAM Test**********/");
    Serial.println("ESP32-C5 Flash and PSRAM size detection");

    // Get Flash size
    uint32_t flashSize = ESP.getFlashChipSize();
    Serial.printf("Flash size: %.2f MB\n", flashSize / 1024 / 1024.0);

    // Get PSRAM size
    //uint32_t psramSize = ESP.getPsramSize();
    uint32_t freepsramSize = ESP.getFreePsram();
    //Serial.printf("PSRAM size: %d bytes\n", psramSize);
    Serial.printf("Free PSRAM size: %.2f MB\n", freepsramSize / 1024 / 1024.0);

    // Check if both Flash and PSRAM sizes are 8MB
    if (flashSize == 16 * 1024 * 1024 && freepsramSize > 4 * 1000 * 1000) {
        Serial.println("Flash and PSRAM is OK!");
      } else {
        Serial.println("Flash and PSRAM is Fail!");
    }

    Serial.println("/******* RAM Test Over********/");
}
void adc_test()
{
    int ADC_Value = 0;
    float Voltage = 0;
    Serial.println("/********** ADC Test**********/");
    analogReadResolution(12);
    ADC_Value = analogReadMilliVolts(6);

    Voltage = ADC_Value * 3 / 1000.0;
    Serial.printf("BAT=%.2f V\r\n", Voltage);
    if ((Voltage > 4.2) || (Voltage < 1.0))
    {
        Serial.printf("GPIO6 adc Error!!!!!!\r\n");
    }
    // ADC_Value = analogRead(9);
    // Voltage = ADC_Value * (3.3 / 4095.0);
    // Serial.printf("GPIO9=%.2f V\r\n", Voltage);
    // if ((Voltage > 1.7) || (Voltage < 1.6))
    // {
    //     Serial.printf("GPIO9 adc Error!!!!!!\r\n");
    // }
    // ADC_Value = analogRead(3);
    // Voltage = ADC_Value * (3.3 / 4095.0);
    // Serial.printf("GPIO3=%.2f V\r\n", Voltage);
    // if ((Voltage > 2.7) || (Voltage < 2.4))
    // {
    //     Serial.printf("GPIO9 adc Error!!!!!!\r\n");
    // }
    Serial.println("/******* ADC Test Over********/");
}
void gpio_test()
{

    uint8_t num = 0;
    uint8_t loss_cnt = 0;
  
      for (uint8_t num = 0; num < GPIO_NUM; num++)
    {
        pinMode(gpio_map[num], OUTPUT);
        digitalWrite(gpio_map[num], 0);
    }

    Serial.println("/**********GPIO Test**********/");

    Serial.print("GPIO Connet to GND:");
    for (num = 0; num < GPIO_NUM; num++)
    {
        pinMode(gpio_map[num], INPUT_PULLUP);
    }
    for (num = 0; num < GPIO_NUM; num++)
    {
        if (digitalRead(gpio_map[num]) == 0)
        {
            Serial.printf("io%d ,", gpio_map[num]);
        }
    }
    Serial.println("");

    Serial.print("GPIO Connet to VCC:");

    for (num = 0; num < GPIO_NUM; num++)
    {
        pinMode(gpio_map[num], INPUT_PULLDOWN);
    }
    for (num = 0; num < GPIO_NUM; num++)
    {
        if (digitalRead(gpio_map[num]) == 1)
        {
            Serial.printf("io%d ,", gpio_map[num]);
        }
    }
    Serial.println("");
    Serial.println("/*******GPIO Test Over********/");
}
void wifi_scan()
{
    Serial.println("/**********WiFi Test**********/");
    // Set WiFi to station mode and disconnect from an AP if it was previously connected.
    WiFi.STA.begin();
    WiFi.setBandMode(WIFI_BAND_MODE_AUTO);
    // WiFi.scanNetworks will return the number of networks found.
    int n = WiFi.scanNetworks();
    // Serial.println("Scan done");
    if (n == 0)
    {
        Serial.println("no networks found");
    }
    else
    {
        Serial.print(n);
        Serial.println(" networks found");
        Serial.println("Nr | SSID                             | RSSI | CH | Encryption");
        for (int i = 0; i < 4; ++i) {
          // Print SSID and RSSI for each network found
          Serial.printf("%2d", i + 1);
          Serial.print(" | ");
          Serial.printf("%-32.32s", WiFi.SSID(i).c_str());
          Serial.print(" | ");
          Serial.printf("%4ld", WiFi.RSSI(i));
          Serial.print(" | ");
          Serial.printf("%2ld", WiFi.channel(i));
          Serial.print(" | ");
          switch (WiFi.encryptionType(i)) {
            case WIFI_AUTH_OPEN:            Serial.print("open"); break;
            case WIFI_AUTH_WEP:             Serial.print("WEP"); break;
            case WIFI_AUTH_WPA_PSK:         Serial.print("WPA"); break;
            case WIFI_AUTH_WPA2_PSK:        Serial.print("WPA2"); break;
            case WIFI_AUTH_WPA_WPA2_PSK:    Serial.print("WPA+WPA2"); break;
            case WIFI_AUTH_WPA2_ENTERPRISE: Serial.print("WPA2-EAP"); break;
            case WIFI_AUTH_WPA3_PSK:        Serial.print("WPA3"); break;
            case WIFI_AUTH_WPA2_WPA3_PSK:   Serial.print("WPA2+WPA3"); break;
            case WIFI_AUTH_WAPI_PSK:        Serial.print("WAPI"); break;
            default:                        Serial.print("unknown");
          }
          Serial.println();
          delay(10);
        }
    }
    Serial.println("");

    // Delete the scan result to free memory for code below.
    WiFi.scanDelete();
    Serial.println("/*******WiFi Test Over********/");
}

void ble_scan()
{
  BLEDevice::init("");
  Serial.println("/**********BLE Test**********/");
  BLEScan* pBLEScan = BLEDevice::getScan();
  pBLEScan->setActiveScan(true);
  BLEScanResults* foundDevices = pBLEScan->start(5);
  int count = foundDevices->getCount();
  Serial.println("Found " + String(count) + " devices");
  for (int i = 0; i < count; i++) {
    BLEAdvertisedDevice device = foundDevices->getDevice(i);
    Serial.println("Device " + String(i) + ": " + device.getAddress().toString().c_str());
  }
  pBLEScan->clearResults();
  delay(5000);
  Serial.println("/**********BLE Test**********/");
}