#pragma once

#include "../Arduino_GFX.h"
#include "../Arduino_TFT.h"

#define SPD2010_TFTWIDTH 412  ///< SPD2010 max TFT width
#define SPD2010_TFTHEIGHT 412 ///< SPD2010 max TFT height

#define SPD2010_RST_DELAY 120    ///< delay ms wait for reset finish
#define SPD2010_SLPIN_DELAY 120  ///< delay ms wait for sleep in finish
#define SPD2010_SLPOUT_DELAY 120 ///< delay ms wait for sleep out finish

#define SPD2010_SWRESET 0x01 ///< Software reset register

#define SPD2010_SLPIN 0x10  ///< Enter Sleep Mode
#define SPD2010_SLPOUT 0x11 ///< Sleep Out

#define SPD2010_INVOFF 0x20 ///< Display Inversion OFF
#define SPD2010_INVON 0x21  ///< Display Inversion ON

#define SPD2010_DISPOFF 0x28 ///< Display OFF
#define SPD2010_DISPON 0x29  ///< Display ON

#define SPD2010_CASET 0x2A ///< Column Address Set
#define SPD2010_PASET 0x2B ///< Page Address Set
#define SPD2010_RAMWR 0x2C ///< Memory Write

#define SPD2010_MADCTL 0x36
#define SPD2010_PIXFMT 0x3A // Interface Pixel Format

#define SPD2010_MADCTL_MY 0x80
#define SPD2010_MADCTL_MX 0x40
#define SPD2010_MADCTL_MV 0x20
#define SPD2010_MADCTL_ML 0x10
#define SPD2010_MADCTL_RGB 0x00
#define SPD2010_MADCTL_MH 0x04
#define SPD2010_MADCTL_BGR 0x08

static const uint8_t spd2010_init_operations[] = {
    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_COMMAND_8, SPD2010_SWRESET,
    END_WRITE,

    DELAY, SPD2010_RST_DELAY,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x10,
    WRITE_C8_D8, 0x0C, 0x11,
    WRITE_C8_D8, 0x10, 0x02,
    WRITE_C8_D8, 0x11, 0x11,
    WRITE_C8_D8, 0x15, 0x42,
    WRITE_C8_D8, 0x16, 0x11,
    WRITE_C8_D8, 0x1A, 0x02,
    WRITE_C8_D8, 0x1B, 0x11,
    WRITE_C8_D8, 0x61, 0x80,
    WRITE_C8_D8, 0x62, 0x80,
    WRITE_C8_D8, 0x54, 0x44,
    WRITE_C8_D8, 0x58, 0x88,
    WRITE_C8_D8, 0x5C, 0xcc,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x10,
    WRITE_C8_D8, 0x20, 0x80,
    WRITE_C8_D8, 0x21, 0x81,
    WRITE_C8_D8, 0x22, 0x31,
    WRITE_C8_D8, 0x23, 0x20,
    WRITE_C8_D8, 0x24, 0x11,
    WRITE_C8_D8, 0x25, 0x11,
    WRITE_C8_D8, 0x26, 0x12,
    WRITE_C8_D8, 0x27, 0x12,
    WRITE_C8_D8, 0x30, 0x80,
    WRITE_C8_D8, 0x31, 0x81,
    WRITE_C8_D8, 0x32, 0x31,
    WRITE_C8_D8, 0x33, 0x20,
    WRITE_C8_D8, 0x34, 0x11,
    WRITE_C8_D8, 0x35, 0x11,
    WRITE_C8_D8, 0x36, 0x12,
    WRITE_C8_D8, 0x37, 0x12,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x10,
    WRITE_C8_D8, 0x41, 0x11,
    WRITE_C8_D8, 0x42, 0x22,
    WRITE_C8_D8, 0x43, 0x33,
    WRITE_C8_D8, 0x49, 0x11,
    WRITE_C8_D8, 0x4A, 0x22,
    WRITE_C8_D8, 0x4B, 0x33,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x15,
    WRITE_C8_D8, 0x00, 0x00,
    WRITE_C8_D8, 0x01, 0x00,
    WRITE_C8_D8, 0x02, 0x00,
    WRITE_C8_D8, 0x03, 0x00,
    WRITE_C8_D8, 0x04, 0x10,
    WRITE_C8_D8, 0x05, 0x0C,
    WRITE_C8_D8, 0x06, 0x23,
    WRITE_C8_D8, 0x07, 0x22,
    WRITE_C8_D8, 0x08, 0x21,
    WRITE_C8_D8, 0x09, 0x20,
    WRITE_C8_D8, 0x0A, 0x33,
    WRITE_C8_D8, 0x0B, 0x32,
    WRITE_C8_D8, 0x0C, 0x34,
    WRITE_C8_D8, 0x0D, 0x35,
    WRITE_C8_D8, 0x0E, 0x01,
    WRITE_C8_D8, 0x0F, 0x01,
    WRITE_C8_D8, 0x20, 0x00,
    WRITE_C8_D8, 0x21, 0x00,
    WRITE_C8_D8, 0x22, 0x00,
    WRITE_C8_D8, 0x23, 0x00,
    WRITE_C8_D8, 0x24, 0x0C,
    WRITE_C8_D8, 0x25, 0x10,
    WRITE_C8_D8, 0x26, 0x20,
    WRITE_C8_D8, 0x27, 0x21,
    WRITE_C8_D8, 0x28, 0x22,
    WRITE_C8_D8, 0x29, 0x23,
    WRITE_C8_D8, 0x2A, 0x33,
    WRITE_C8_D8, 0x2B, 0x32,
    WRITE_C8_D8, 0x2C, 0x34,
    WRITE_C8_D8, 0x2D, 0x35,
    WRITE_C8_D8, 0x2E, 0x01,
    WRITE_C8_D8, 0x2F, 0x01,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x16,
    WRITE_C8_D8, 0x00, 0x00,
    WRITE_C8_D8, 0x01, 0x00,
    WRITE_C8_D8, 0x02, 0x00,
    WRITE_C8_D8, 0x03, 0x00,
    WRITE_C8_D8, 0x04, 0x08,
    WRITE_C8_D8, 0x05, 0x04,
    WRITE_C8_D8, 0x06, 0x19,
    WRITE_C8_D8, 0x07, 0x18,
    WRITE_C8_D8, 0x08, 0x17,
    WRITE_C8_D8, 0x09, 0x16,
    WRITE_C8_D8, 0x0A, 0x33,
    WRITE_C8_D8, 0x0B, 0x32,
    WRITE_C8_D8, 0x0C, 0x34,
    WRITE_C8_D8, 0x0D, 0x35,
    WRITE_C8_D8, 0x0E, 0x01,
    WRITE_C8_D8, 0x0F, 0x01,
    WRITE_C8_D8, 0x20, 0x00,
    WRITE_C8_D8, 0x21, 0x00,
    WRITE_C8_D8, 0x22, 0x00,
    WRITE_C8_D8, 0x23, 0x00,
    WRITE_C8_D8, 0x24, 0x04,
    WRITE_C8_D8, 0x25, 0x08,
    WRITE_C8_D8, 0x26, 0x16,
    WRITE_C8_D8, 0x27, 0x17,
    WRITE_C8_D8, 0x28, 0x18,
    WRITE_C8_D8, 0x29, 0x19,
    WRITE_C8_D8, 0x2A, 0x33,
    WRITE_C8_D8, 0x2B, 0x32,
    WRITE_C8_D8, 0x2C, 0x34,
    WRITE_C8_D8, 0x2D, 0x35,
    WRITE_C8_D8, 0x2E, 0x01,
    WRITE_C8_D8, 0x2F, 0x01,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x00, 0x99,
    WRITE_C8_D8, 0x2A, 0x28,
    WRITE_C8_D8, 0x2B, 0x0f,
    WRITE_C8_D8, 0x2C, 0x16,
    WRITE_C8_D8, 0x2D, 0x28,
    WRITE_C8_D8, 0x2E, 0x0f,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0xA0,
    WRITE_C8_D8, 0x08, 0xdc,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x45,
    WRITE_C8_D8, 0x01, 0x9C,
    WRITE_C8_D8, 0x03, 0x9C,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x42,
    WRITE_C8_D8, 0x05, 0x2c,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x11,
    WRITE_C8_D8, 0x50, 0x01,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0x2A, 4, 0x00, 0x00, 0x01, 0x9B,
    WRITE_C8_BYTES, 0x2B, 4, 0x00, 0x00, 0x01, 0x9B,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x40,
    WRITE_C8_D8, 0x86, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x0D, 0x66,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x17,
    WRITE_C8_D8, 0x39, 0x3c,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x31,
    WRITE_C8_D8, 0x38, 0x03,
    WRITE_C8_D8, 0x39, 0xf0,
    WRITE_C8_D8, 0x36, 0x03,
    WRITE_C8_D8, 0x37, 0xe8,
    WRITE_C8_D8, 0x34, 0x03,
    WRITE_C8_D8, 0x35, 0xCF,
    WRITE_C8_D8, 0x32, 0x03,
    WRITE_C8_D8, 0x33, 0xBA,
    WRITE_C8_D8, 0x30, 0x03,
    WRITE_C8_D8, 0x31, 0xA2,
    WRITE_C8_D8, 0x2e, 0x03,
    WRITE_C8_D8, 0x2f, 0x95,
    WRITE_C8_D8, 0x2c, 0x03,
    WRITE_C8_D8, 0x2d, 0x7e,
    WRITE_C8_D8, 0x2a, 0x03,
    WRITE_C8_D8, 0x2b, 0x62,
    WRITE_C8_D8, 0x28, 0x03,
    WRITE_C8_D8, 0x29, 0x44,
    WRITE_C8_D8, 0x26, 0x02,
    WRITE_C8_D8, 0x27, 0xfc,
    WRITE_C8_D8, 0x24, 0x02,
    WRITE_C8_D8, 0x25, 0xd0,
    WRITE_C8_D8, 0x22, 0x02,
    WRITE_C8_D8, 0x23, 0x98,
    WRITE_C8_D8, 0x20, 0x02,
    WRITE_C8_D8, 0x21, 0x6f,
    WRITE_C8_D8, 0x1e, 0x02,
    WRITE_C8_D8, 0x1f, 0x32,
    WRITE_C8_D8, 0x1c, 0x01,
    WRITE_C8_D8, 0x1d, 0xf6,
    WRITE_C8_D8, 0x1a, 0x01,
    WRITE_C8_D8, 0x1b, 0xb8,
    WRITE_C8_D8, 0x18, 0x01,
    WRITE_C8_D8, 0x19, 0x6E,
    WRITE_C8_D8, 0x16, 0x01,
    WRITE_C8_D8, 0x17, 0x41,
    WRITE_C8_D8, 0x14, 0x00,
    WRITE_C8_D8, 0x15, 0xfd,
    WRITE_C8_D8, 0x12, 0x00,
    WRITE_C8_D8, 0x13, 0xCf,
    WRITE_C8_D8, 0x10, 0x00,
    WRITE_C8_D8, 0x11, 0x98,
    WRITE_C8_D8, 0x0e, 0x00,
    WRITE_C8_D8, 0x0f, 0x89,
    WRITE_C8_D8, 0x0c, 0x00,
    WRITE_C8_D8, 0x0d, 0x79,
    WRITE_C8_D8, 0x0a, 0x00,
    WRITE_C8_D8, 0x0b, 0x67,
    WRITE_C8_D8, 0x08, 0x00,
    WRITE_C8_D8, 0x09, 0x55,
    WRITE_C8_D8, 0x06, 0x00,
    WRITE_C8_D8, 0x07, 0x3F,
    WRITE_C8_D8, 0x04, 0x00,
    WRITE_C8_D8, 0x05, 0x28,
    WRITE_C8_D8, 0x02, 0x00,
    WRITE_C8_D8, 0x03, 0x0E,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x32,
    WRITE_C8_D8, 0x38, 0x03,
    WRITE_C8_D8, 0x39, 0xf0,
    WRITE_C8_D8, 0x36, 0x03,
    WRITE_C8_D8, 0x37, 0xe8,
    WRITE_C8_D8, 0x34, 0x03,
    WRITE_C8_D8, 0x35, 0xCF,
    WRITE_C8_D8, 0x32, 0x03,
    WRITE_C8_D8, 0x33, 0xBA,
    WRITE_C8_D8, 0x30, 0x03,
    WRITE_C8_D8, 0x31, 0xA2,
    WRITE_C8_D8, 0x2e, 0x03,
    WRITE_C8_D8, 0x2f, 0x95,
    WRITE_C8_D8, 0x2c, 0x03,
    WRITE_C8_D8, 0x2d, 0x7e,
    WRITE_C8_D8, 0x2a, 0x03,
    WRITE_C8_D8, 0x2b, 0x62,
    WRITE_C8_D8, 0x28, 0x03,
    WRITE_C8_D8, 0x29, 0x44,
    WRITE_C8_D8, 0x26, 0x02,
    WRITE_C8_D8, 0x27, 0xfc,
    WRITE_C8_D8, 0x24, 0x02,
    WRITE_C8_D8, 0x25, 0xd0,
    WRITE_C8_D8, 0x22, 0x02,
    WRITE_C8_D8, 0x23, 0x98,
    WRITE_C8_D8, 0x20, 0x02,
    WRITE_C8_D8, 0x21, 0x6f,
    WRITE_C8_D8, 0x1e, 0x02,
    WRITE_C8_D8, 0x1f, 0x32,
    WRITE_C8_D8, 0x1c, 0x01,
    WRITE_C8_D8, 0x1d, 0xf6,
    WRITE_C8_D8, 0x1a, 0x01,
    WRITE_C8_D8, 0x1b, 0xb8,
    WRITE_C8_D8, 0x18, 0x01,
    WRITE_C8_D8, 0x19, 0x6E,
    WRITE_C8_D8, 0x16, 0x01,
    WRITE_C8_D8, 0x17, 0x41,
    WRITE_C8_D8, 0x14, 0x00,
    WRITE_C8_D8, 0x15, 0xfd,
    WRITE_C8_D8, 0x12, 0x00,
    WRITE_C8_D8, 0x13, 0xCf,
    WRITE_C8_D8, 0x10, 0x00,
    WRITE_C8_D8, 0x11, 0x98,
    WRITE_C8_D8, 0x0e, 0x00,
    WRITE_C8_D8, 0x0f, 0x89,
    WRITE_C8_D8, 0x0c, 0x00,
    WRITE_C8_D8, 0x0d, 0x79,
    WRITE_C8_D8, 0x0a, 0x00,
    WRITE_C8_D8, 0x0b, 0x67,
    WRITE_C8_D8, 0x08, 0x00,
    WRITE_C8_D8, 0x09, 0x55,
    WRITE_C8_D8, 0x06, 0x00,
    WRITE_C8_D8, 0x07, 0x3F,
    WRITE_C8_D8, 0x04, 0x00,
    WRITE_C8_D8, 0x05, 0x28,
    WRITE_C8_D8, 0x02, 0x00,
    WRITE_C8_D8, 0x03, 0x0E,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x11,
    WRITE_C8_D8, 0x60, 0x01,
    WRITE_C8_D8, 0x65, 0x03,
    WRITE_C8_D8, 0x66, 0x38,
    WRITE_C8_D8, 0x67, 0x04,
    WRITE_C8_D8, 0x68, 0x34,
    WRITE_C8_D8, 0x69, 0x03,
    WRITE_C8_D8, 0x61, 0x03,
    WRITE_C8_D8, 0x62, 0x38,
    WRITE_C8_D8, 0x63, 0x04,
    WRITE_C8_D8, 0x64, 0x34,
    WRITE_C8_D8, 0x0A, 0x11,
    WRITE_C8_D8, 0x0B, 0x20,
    WRITE_C8_D8, 0x0c, 0x20,
    WRITE_C8_D8, 0x55, 0x06,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x42,
    WRITE_C8_D8, 0x05, 0x3D,
    WRITE_C8_D8, 0x06, 0x03,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x1F, 0xDC,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x17,
    WRITE_C8_D8, 0x11, 0xAA,
    WRITE_C8_D8, 0x16, 0x12,
    WRITE_C8_D8, 0x0B, 0xC3,
    WRITE_C8_D8, 0x10, 0x0E,
    WRITE_C8_D8, 0x14, 0xAA,
    WRITE_C8_D8, 0x18, 0xA0,
    WRITE_C8_D8, 0x1A, 0x80,
    WRITE_C8_D8, 0x1F, 0x80,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x11,
    WRITE_C8_D8, 0x30, 0xEE,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x15, 0x0F,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x2D,
    WRITE_C8_D8, 0x01, 0x3E,
    WRITE_C8_BYTES, 0xff, 3, 0x20, 0x10, 0x40,
    WRITE_C8_D8, 0x83, 0xC4,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x00, 0xCC,
    WRITE_C8_D8, 0x36, 0xA0,
    WRITE_C8_D8, 0x2A, 0x2D,
    WRITE_C8_D8, 0x2B, 0x1e,
    WRITE_C8_D8, 0x2C, 0x26,
    WRITE_C8_D8, 0x2D, 0x2D,
    WRITE_C8_D8, 0x2E, 0x1e,
    WRITE_C8_D8, 0x1F, 0xE6,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0xA0,
    WRITE_C8_D8, 0x08, 0xE6,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x10, 0x0F,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x18,
    WRITE_C8_D8, 0x01, 0x01,
    WRITE_C8_D8, 0x00, 0x1E,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x43,
    WRITE_C8_D8, 0x03, 0x04,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x18,
    WRITE_C8_D8, 0x3A, 0x01,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x50,
    WRITE_C8_D8, 0x05, 0x08,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x50,
    WRITE_C8_D8, 0x00, 0xA6,
    WRITE_C8_D8, 0x01, 0xA6,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x50,
    WRITE_C8_D8, 0x08, 0x55,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x10,
    WRITE_C8_D8, 0x0B, 0x43,
    WRITE_C8_D8, 0x0C, 0x12,
    WRITE_C8_D8, 0x10, 0x01,
    WRITE_C8_D8, 0x11, 0x12,
    WRITE_C8_D8, 0x15, 0x00,
    WRITE_C8_D8, 0x16, 0x00,
    WRITE_C8_D8, 0x1A, 0x00,
    WRITE_C8_D8, 0x1B, 0x00,
    WRITE_C8_D8, 0x61, 0x00,
    WRITE_C8_D8, 0x62, 0x00,
    WRITE_C8_D8, 0x51, 0x11,
    WRITE_C8_D8, 0x55, 0x55,
    WRITE_C8_D8, 0x58, 0x00,
    WRITE_C8_D8, 0x5C, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x10,
    WRITE_C8_D8, 0x20, 0x81,
    WRITE_C8_D8, 0x21, 0x82,
    WRITE_C8_D8, 0x22, 0x72,
    WRITE_C8_D8, 0x30, 0x00,
    WRITE_C8_D8, 0x31, 0x00,
    WRITE_C8_D8, 0x32, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x10,
    WRITE_C8_D8, 0x44, 0x44,
    WRITE_C8_D8, 0x45, 0x55,
    WRITE_C8_D8, 0x46, 0x66,
    WRITE_C8_D8, 0x47, 0x77,
    WRITE_C8_D8, 0x49, 0x00,
    WRITE_C8_D8, 0x4A, 0x00,
    WRITE_C8_D8, 0x4B, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x17,
    WRITE_C8_D8, 0x37, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x15,
    WRITE_C8_D8, 0x04, 0x08,
    WRITE_C8_D8, 0x05, 0x04,
    WRITE_C8_D8, 0x06, 0x1C,
    WRITE_C8_D8, 0x07, 0x1A,
    WRITE_C8_D8, 0x08, 0x18,
    WRITE_C8_D8, 0x09, 0x16,
    WRITE_C8_D8, 0x24, 0x05,
    WRITE_C8_D8, 0x25, 0x09,
    WRITE_C8_D8, 0x26, 0x17,
    WRITE_C8_D8, 0x27, 0x19,
    WRITE_C8_D8, 0x28, 0x1B,
    WRITE_C8_D8, 0x29, 0x1D,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x16,
    WRITE_C8_D8, 0x04, 0x09,
    WRITE_C8_D8, 0x05, 0x05,
    WRITE_C8_D8, 0x06, 0x1D,
    WRITE_C8_D8, 0x07, 0x1B,
    WRITE_C8_D8, 0x08, 0x19,
    WRITE_C8_D8, 0x09, 0x17,
    WRITE_C8_D8, 0x24, 0x04,
    WRITE_C8_D8, 0x25, 0x08,
    WRITE_C8_D8, 0x26, 0x16,
    WRITE_C8_D8, 0x27, 0x18,
    WRITE_C8_D8, 0x28, 0x1A,
    WRITE_C8_D8, 0x29, 0x1C,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x18,
    WRITE_C8_D8, 0x1F, 0x02,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x11,
    WRITE_C8_D8, 0x15, 0x99,
    WRITE_C8_D8, 0x16, 0x99,
    WRITE_C8_D8, 0x1C, 0x88,
    WRITE_C8_D8, 0x1D, 0x88,
    WRITE_C8_D8, 0x1E, 0x88,
    WRITE_C8_D8, 0x13, 0xf0,
    WRITE_C8_D8, 0x14, 0x34,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x12, 0x89,
    WRITE_C8_D8, 0x06, 0x06,
    WRITE_C8_D8, 0x18, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x11,
    WRITE_C8_D8, 0x0A, 0x00,
    WRITE_C8_D8, 0x0B, 0xF0,
    WRITE_C8_D8, 0x0c, 0xF0,
    WRITE_C8_D8, 0x6A, 0x10,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x11,
    WRITE_C8_D8, 0x08, 0x70,
    WRITE_C8_D8, 0x09, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_C8_D8, 0x35, 0x00,
    WRITE_C8_D8, SPD2010_PIXFMT, 0x55,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x12,
    WRITE_C8_D8, 0x21, 0x70,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x2D,
    WRITE_C8_D8, 0x02, 0x00,
    WRITE_C8_BYTES, 0xFF, 3, 0x20, 0x10, 0x00,
    WRITE_COMMAND_8, SPD2010_SLPOUT,
    WRITE_COMMAND_8, SPD2010_DISPON,
    END_WRITE,
    DELAY, SPD2010_SLPOUT_DELAY};

class Arduino_SPD2010 : public Arduino_TFT
{
public:
  Arduino_SPD2010(Arduino_DataBus *bus, int8_t rst = GFX_NOT_DEFINED);

  bool begin(int32_t speed = GFX_NOT_DEFINED) override;

  void setRotation(uint8_t r) override;

  void writeAddrWindow(int16_t x, int16_t y, uint16_t w, uint16_t h);

  void invertDisplay(bool) override;
  void displayOn() override;
  void displayOff() override;

protected:
  void tftInit() override;

private:
};
