# BSP: Waveshare ESP32-P4-WIFI6-Touch-LCD-4B && ESP32-P4-86-Panel-ETH-2RO

[![Component Registry](https://components.espressif.com/components/waveshare/esp32_p4_wifi6_touch_lcd_4b/badge.svg)](https://components.espressif.com/components/waveshare/esp32_p4_wifi6_touch_lcd_4b)

This series of products is based on ESP32-P4 chip high-performance development board. It uses dual-core plus single-core RISC-V architecture design, and a 4-inch 720 × 720 resolution IPS touch display is mounted on the board
| HW version | BSP Version |
| :--------: | :---------: |
|    [V1.0](http://www.waveshare.com/wiki/ESP32-P4-WIFI6-Touch-LCD-4B)    |      ^1     |


## BackLight
```c
bsp_display_brightness_init();

bsp_display_backlight_on();

bsp_display_backlight_off();

bsp_display_brightness_set(100);
```

<!-- Autogenerated start: Dependencies -->
### Capabilities and dependencies
|  Capability |     Available    | Component                                                                                                  | Version |
|-------------|------------------|------------------------------------------------------------------------------------------------------------|---------|
|   DISPLAY   |:heavy_check_mark:| [waveshare/esp_lcd_st7703](https://components.espressif.com/components/waveshare/esp_lcd_st7703)           | 1.0.1   |
|  LVGL_PORT  |:heavy_check_mark:| [espressif/esp_lvgl_port](https://components.espressif.com/components/espressif/esp_lvgl_port)             | ^2      |
|    TOUCH    |:heavy_check_mark:| [espressif/esp_lcd_touch_gt911](https://components.espressif.com/components/espressif/esp_lcd_touch_gt911) | ^1      |
|   BUTTONS   |        :x:       |                                                                                                            |         |
|    AUDIO    |:heavy_check_mark:| [espressif/esp_codec_dev](https://components.espressif.com/components/espressif/esp_codec_dev)             | 1.2.*   |
|AUDIO_SPEAKER|:heavy_check_mark:|                                                                                                            |         |
|  AUDIO_MIC  |:heavy_check_mark:|                                                                                                            |         |
|    SDCARD   |:heavy_check_mark:| idf                                                                                                        | >=5.3   |
|     IMU     |        :x:       |                                                                                                            |         |
<!-- Autogenerated end: Dependencies -->
