/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#include <stdint.h>

/* From bq27220 Technical Reference Manual Table 3-2 */
typedef enum {
    BQ_DM_BOARD_OFFSET,
    BQ_DM_INT_TEMP_OFFSET,
    BQ_DM_EXT_TEMP_OFFSET,
    BQ_DM_PACK_V_OFFSET,
    BQ_DM_INTERNAL_MODEL_COEFFICIENT_1,
    BQ_DM_INTERNAL_MODEL_COEFFICIENT_2,
    BQ_DM_INTERNAL_MODEL_COEFFICIENT_3,
    BQ_DM_INTERNAL_MODEL_COEFFICIENT_4,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_1,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_2,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_3,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_4,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_5,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_1,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_2,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_3,
    BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_4,
    BQ_DM_RC0,
    BQ_DM_VOLTAGE_COMP_COEFFICIENT_1,
    BQ_DM_VOLTAGE_COMP_COEFFICIENT_2,
    BQ_DM_VOLTAGE_COMP_COEFFICIENT_3,
    BQ_DM_VOLTAGE_COMP_INPUT_MULTIPLIER,
    BQ_DM_VOLTAGE_COMP_OUTPUT_DIVISOR,
    BQ_DM_CC_OFFSET,
    BQ_DM_CC_GAIN,
    BQ_DM_CC_DELTA,
    BQ_DM_FILTER,
    BQ_DM_DEADBAND,
    BQ_DM_CC_DEADBAND,
    BQ_DM_CHG_INHIBIT_TEMP_LOW,
    BQ_DM_CHG_INHIBIT_TEMP_HIGH,
    BQ_DM_TEMP_HYS,
    BQ_DM_CHARGING_CURRENT,
    BQ_DM_CHARGING_VOLTAGE,
    BQ_DM_TAPER_CURRENT,
    BQ_DM_OT_CHG,
    BQ_DM_OT_CHG_TIME,
    BQ_DM_OT_CHG_RECOVERY,
    BQ_DM_OT_DSG,
    BQ_DM_OT_DSG_TIME,
    BQ_DM_OT_DSG_RECOVERY,
    BQ_DM_OPERATION_CONFIG_A,
    BQ_DM_OPERATION_CONFIG_B,
    BQ_DM_SOC_DELTA,
    BQ_DM_CLK_CTL_REG,
    BQ_DM_DEVICE_TYPE,
    BQ_DM_IO_CONFIG,
    BQ_DM_INIT_DISCHARGE_SET,
    BQ_DM_INIT_CHARGE_SET,
    BQ_DM_SLEEP_CURRENT,
    BQ_DM_BUS_LOW_TIME,
    BQ_DM_OFFSET_CAL_INHIBIT_TEMP_LOW,
    BQ_DM_OFFSET_CAL_INHIBIT_TEMP_HIGH,
    BQ_DM_SLEEP_VOLTAGE_TIME,
    BQ_DM_SLEEP_CURRENT_TIME,
    BQ_DM_DISCHARGE_DETECTION_THRESHOLD,
    BQ_DM_CHARGE_DETECTION_THRESHOLD,
    BQ_DM_QUIT_CURRENT,
    BQ_DM_DISCHARGE_RELAX_TIME,
    BQ_DM_CHARGE_RELAX_TIME,
    BQ_DM_QUIT_RELAX_TIME,
    BQ_DM_INITIAL_STANDBY,
    BQ_DM_SYSDOWN_SET_VOLT_THRESHOLD,
    BQ_DM_SYSDOWN_SET_VOLT_TIME,
    BQ_DM_SYSDOWN_CLEAR_VOLT_THRESHOLD,
    BQ_DM_FLAG_CONFIG_A,
    BQ_DM_FLAG_CONFIG_B,
    BQ_DM_BATTERY_ID,
    BQ_DM_CYCLE_COUNT_PERCENTAGE,
    BQ_DM_SET_VOLTAGE_THRESHOLD_FD,
    BQ_DM_CLEAR_VOLTAGE_THRESHOLD_FD,
    BQ_DM_SET_RSOC_THRESHOLD_FD,
    BQ_DM_CLEAR_RSOC_THRESHOLD_FD,
    BQ_DM_SET_VOLTAGE_THRESHOLD_FC,
    BQ_DM_CLEAR_VOLTAGE_THRESHOLD_FC,
    BQ_DM_SET_RSOC_THRESHOLD_FC,
    BQ_DM_CLEAR_RSOC_THRESHOLD_FC,
    BQ_DM_SET_VOLTAGE_THRESHOLD_TD,
    BQ_DM_CLEAR_VOLTAGE_THRESHOLD_TD,
    BQ_DM_SET_RSOC_THRESHOLD_TD,
    BQ_DM_CLEAR_RSOC_THRESHOLD_TD,
    BQ_DM_SET_VOLTAGE_THRESHOLD_TC,
    BQ_DM_CLEAR_VOLTAGE_THRESHOLD_TC,
    BQ_DM_SET_RSOC_THRESHOLD_TC,
    BQ_DM_CLEAR_RSOC_THRESHOLD_TC,
    BQ_DM_BATTERY_LOW_PERCENT,
    BQ_DM_LEARNING_LOW_TEMP,
    BQ_DM_OVERLOAD_CURRENT,
    BQ_DM_SELF_DISCHARGE_RATE,
    BQ_DM_ELECTRONICS_LOAD,
    BQ_DM_NEAR_FULL,
    BQ_DM_RESERVE_CAPACITY,
    BQ_DM_CHG_EFF,
    BQ_DM_DSG_EFF,
    BQ_DM_GAUGING_CONFIGURATION,
    BQ_DM_FULL_CHARGE_CAPACITY,
    BQ_DM_DESIGN_CAPACITY,
    BQ_DM_DESIGN_VOLTAGE,
    BQ_DM_CHARGE_TERMINATION_VOLTAGE,
    BQ_DM_EMF,
    BQ_DM_C0,
    BQ_DM_R0,
    BQ_DM_T0,
    BQ_DM_R1,
    BQ_DM_TC,
    BQ_DM_C1,
    BQ_DM_AGE_FACTOR,
    BQ_DM_FIXED_EDV_0,
    BQ_DM_EDV_0_HOLD_TIME,
    BQ_DM_FIXED_EDV_1,
    BQ_DM_EDV_1_HOLD_TIME,
    BQ_DM_FIXED_EDV_2,
    BQ_DM_EDV_2_HOLD_TIME,
    BQ_DM_VOLTAGE_0_DOD,
    BQ_DM_VOLTAGE_10_DOD,
    BQ_DM_VOLTAGE_20_DOD,
    BQ_DM_VOLTAGE_30_DOD,
    BQ_DM_VOLTAGE_40_DOD,
    BQ_DM_VOLTAGE_50_DOD,
    BQ_DM_VOLTAGE_60_DOD,
    BQ_DM_VOLTAGE_70_DOD,
    BQ_DM_VOLTAGE_80_DOD,
    BQ_DM_VOLTAGE_90_DOD,
    BQ_DM_VOLTAGE_100_DOD,
    BQ_DM_SMOOTHING_CONFIG,
    BQ_DM_SMOOTHING_START_VOLTAGE,
    BQ_DM_SMOOTHING_DELTA_VOLTAGE,
    BQ_DM_MAX_SMOOTHING_CURRENT,
    BQ_DM_EOC_SMOOTH_CURRENT,
    BQ_DM_EOC_SMOOTH_CURRENT_TIME,
} bq27220_data_memory_name_t;

typedef struct {
    const char *class;
    const char *subclass;
    uint16_t    address;
    bq27220_data_memory_name_t name;
    const char *type;
} bq27220_data_memory_entry_t;

/*
Type, Min Value, Max Value
F4, ±9.8603 × 10–39, ±5.707267 × 1037
H1, 0x00, 0xFF
H2, 0x00, 0xFFFF
H4, 0x00, 0xFFFF FFFF
I1, –128, 127
I2, –32768, 32767
I4, −2147483648, 2147483647
Sx, 1-byte string, x-byte string
U1, 0, 255
U2, 0, 65535
U4, 0, 4,294,967,295
*/

const bq27220_data_memory_entry_t dm_table[] = {
    {"Calibration", "Offset", 0x91B4, BQ_DM_BOARD_OFFSET, "I1"},
    {"Calibration", "Offset", 0x91B5, BQ_DM_INT_TEMP_OFFSET, "I1"},
    {"Calibration", "Offset", 0x91B6, BQ_DM_EXT_TEMP_OFFSET, "I1"},
    {"Calibration", "Offset", 0x91B7, BQ_DM_PACK_V_OFFSET, "I1"},
    {"Calibration", "Temperature", 0x91B8, BQ_DM_INTERNAL_MODEL_COEFFICIENT_1, "I2"},
    {"Calibration", "Temperature", 0x91BA, BQ_DM_INTERNAL_MODEL_COEFFICIENT_2, "I2"},
    {"Calibration", "Temperature", 0x91BC, BQ_DM_INTERNAL_MODEL_COEFFICIENT_3, "I2"},
    {"Calibration", "Temperature", 0x91BE, BQ_DM_INTERNAL_MODEL_COEFFICIENT_4, "I2"},
    {"Calibration", "Temperature", 0x91C0, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_1, "I2"},
    {"Calibration", "Temperature", 0x91C2, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_2, "I2"},
    {"Calibration", "Temperature", 0x91C4, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_3, "I2"},
    {"Calibration", "Temperature", 0x91C6, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_4, "I2"},
    {"Calibration", "Temperature", 0x91C8, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_5, "I2"},
    {"Calibration", "Temperature", 0x91CA, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_1, "I2"},
    {"Calibration", "Temperature", 0x91CC, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_2, "I2"},
    {"Calibration", "Temperature", 0x91CE, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_3, "I2"},
    {"Calibration", "Temperature", 0x91D0, BQ_DM_EXTERNAL_MODEL_COEFFICIENT_B_4, "I2"},
    {"Calibration", "Temperature", 0x91D2, BQ_DM_RC0, "I2"},
    {"Calibration", "Temperature", 0x91D4, BQ_DM_VOLTAGE_COMP_COEFFICIENT_1, "I2"},
    {"Calibration", "Temperature", 0x91D6, BQ_DM_VOLTAGE_COMP_COEFFICIENT_2, "I2"},
    {"Calibration", "Temperature", 0x91D8, BQ_DM_VOLTAGE_COMP_COEFFICIENT_3, "I2"},
    {"Calibration", "Temperature", 0x91DA, BQ_DM_VOLTAGE_COMP_INPUT_MULTIPLIER, "U1"},
    {"Calibration", "Temperature", 0x91DB, BQ_DM_VOLTAGE_COMP_OUTPUT_DIVISOR, "I2"},
    {"Calibration", "Current", 0x9180, BQ_DM_CC_OFFSET, "I2"},
    {"Calibration", "Current", 0x9184, BQ_DM_CC_GAIN, "F4"},
    {"Calibration", "Current", 0x9188, BQ_DM_CC_DELTA, "F4"},
    {"Calibration", "Current", 0x91DD, BQ_DM_FILTER, "U1"},
    {"Calibration", "Current", 0x91DE, BQ_DM_DEADBAND, "U1"},
    {"Calibration", "Current", 0x91DF, BQ_DM_CC_DEADBAND, "U1"},
    {"Configuration", "Charge Inhibit Cfg", 0x91F5, BQ_DM_CHG_INHIBIT_TEMP_LOW, "I2"},
    {"Configuration", "Charge Inhibit Cfg", 0x91F7, BQ_DM_CHG_INHIBIT_TEMP_HIGH, "I2"},
    {"Configuration", "Charge Inhibit Cfg", 0x91F9, BQ_DM_TEMP_HYS, "I2"},
    {"Configuration", "Charge", 0x91FB, BQ_DM_CHARGING_CURRENT, "I2"},
    {"Configuration", "Charge", 0x91FD, BQ_DM_CHARGING_VOLTAGE, "I2"},
    {"Configuration", "Charge Termination", 0x9201, BQ_DM_TAPER_CURRENT, "I2"},
    {"Configuration", "Safety", 0x9232, BQ_DM_OT_CHG, "I2"},
    {"Configuration", "Safety", 0x9234, BQ_DM_OT_CHG_TIME, "U1"},
    {"Configuration", "Safety", 0x9235, BQ_DM_OT_CHG_RECOVERY, "I2"},
    {"Configuration", "Safety", 0x9237, BQ_DM_OT_DSG, "I2"},
    {"Configuration", "Safety", 0x9239, BQ_DM_OT_DSG_TIME, "U1"},
    {"Configuration", "Safety", 0x923A, BQ_DM_OT_DSG_RECOVERY, "I2"},
    {"Configuration", "Registers", 0x9206, BQ_DM_OPERATION_CONFIG_A, "H2"},
    {"Configuration", "Registers", 0x9208, BQ_DM_OPERATION_CONFIG_B, "H2"},
    {"Configuration", "Registers", 0x920B, BQ_DM_SOC_DELTA, "U1"},
    {"Configuration", "Registers", 0x920C, BQ_DM_CLK_CTL_REG, "H1"},
    {"Configuration", "Registers", 0x9212, BQ_DM_DEVICE_TYPE, "H2"},
    {"Configuration", "BTP", 0x920D, BQ_DM_IO_CONFIG, "H1"},
    {"Configuration", "BTP", 0x920E, BQ_DM_INIT_DISCHARGE_SET, "I2"},
    {"Configuration", "BTP", 0x9210, BQ_DM_INIT_CHARGE_SET, "I2"},
    {"Configuration", "Power", 0x9217, BQ_DM_SLEEP_CURRENT, "I2"},
    {"Configuration", "Power", 0x9219, BQ_DM_BUS_LOW_TIME, "U1"},
    {"Configuration", "Power", 0x921A, BQ_DM_OFFSET_CAL_INHIBIT_TEMP_LOW, "I2"},
    {"Configuration", "Power", 0x921C, BQ_DM_OFFSET_CAL_INHIBIT_TEMP_HIGH, "I2"},
    {"Configuration", "Power", 0x921E, BQ_DM_SLEEP_VOLTAGE_TIME, "U1"},
    {"Configuration", "Power", 0x921F, BQ_DM_SLEEP_CURRENT_TIME, "U1"},
    {"Configuration", "Current Thresholds", 0x9228, BQ_DM_DISCHARGE_DETECTION_THRESHOLD, "I2"},
    {"Configuration", "Current Thresholds", 0x922A, BQ_DM_CHARGE_DETECTION_THRESHOLD, "I2"},
    {"Configuration", "Current Thresholds", 0x922C, BQ_DM_QUIT_CURRENT, "I2"},
    {"Configuration", "Current Thresholds", 0x922E, BQ_DM_DISCHARGE_RELAX_TIME, "U2"},
    {"Configuration", "Current Thresholds", 0x9230, BQ_DM_CHARGE_RELAX_TIME, "U1"},
    {"Configuration", "Current Thresholds", 0x9231, BQ_DM_QUIT_RELAX_TIME, "U1"},
    {"Configuration", "Data", 0x923C, BQ_DM_INITIAL_STANDBY, "I1"},
    {"Configuration", "Discharge", 0x9240, BQ_DM_SYSDOWN_SET_VOLT_THRESHOLD, "I2"},
    {"Configuration", "Discharge", 0x9242, BQ_DM_SYSDOWN_SET_VOLT_TIME, "U1"},
    {"Configuration", "Discharge", 0x9243, BQ_DM_SYSDOWN_CLEAR_VOLT_THRESHOLD, "I2"},
    {"Configuration", "SOC", 0x927F, BQ_DM_FLAG_CONFIG_A, "H2"},
    {"Configuration", "SOC", 0x9281, BQ_DM_FLAG_CONFIG_B, "H1"},
    {"Configuration", "CEDV Profile Select", 0x929A, BQ_DM_BATTERY_ID, "H1"},
    {"Gas Gauging", "Cycle", 0x927D, BQ_DM_CYCLE_COUNT_PERCENTAGE, "U1"},
    {"Gas Gauging", "FD", 0x9282, BQ_DM_SET_VOLTAGE_THRESHOLD_FD, "I2"},
    {"Gas Gauging", "FD", 0x9284, BQ_DM_CLEAR_VOLTAGE_THRESHOLD_FD, "I2"},
    {"Gas Gauging", "FD", 0x9286, BQ_DM_SET_RSOC_THRESHOLD_FD, "U1"},
    {"Gas Gauging", "FD", 0x9287, BQ_DM_CLEAR_RSOC_THRESHOLD_FD, "U1"},
    {"Gas Gauging", "FC", 0x9288, BQ_DM_SET_VOLTAGE_THRESHOLD_FC, "I2"},
    {"Gas Gauging", "FC", 0x928A, BQ_DM_CLEAR_VOLTAGE_THRESHOLD_FC, "I2"},
    {"Gas Gauging", "FC", 0x928C, BQ_DM_SET_RSOC_THRESHOLD_FC, "U1"},
    {"Gas Gauging", "FC", 0x928D, BQ_DM_CLEAR_RSOC_THRESHOLD_FC, "U1"},
    {"Gas Gauging", "TD", 0x928E, BQ_DM_SET_VOLTAGE_THRESHOLD_TD, "I2"},
    {"Gas Gauging", "TD", 0x9290, BQ_DM_CLEAR_VOLTAGE_THRESHOLD_TD, "I2"},
    {"Gas Gauging", "TD", 0x9292, BQ_DM_SET_RSOC_THRESHOLD_TD, "U1"},
    {"Gas Gauging", "TD", 0x9293, BQ_DM_CLEAR_RSOC_THRESHOLD_TD, "U1"},
    {"Gas Gauging", "TC", 0x9294, BQ_DM_SET_VOLTAGE_THRESHOLD_TC, "I2"},
    {"Gas Gauging", "TC", 0x9296, BQ_DM_CLEAR_VOLTAGE_THRESHOLD_TC, "I2"},
    {"Gas Gauging", "TC", 0x9298, BQ_DM_SET_RSOC_THRESHOLD_TC, "U1"},
    {"Gas Gauging", "TC", 0x9299, BQ_DM_CLEAR_RSOC_THRESHOLD_TC, "U1"},
    {"Gas Gauging", "CEDV Configuration", 0x9251, BQ_DM_BATTERY_LOW_PERCENT, "U2"},
    {"Gas Gauging", "CEDV Configuration", 0x925B, BQ_DM_LEARNING_LOW_TEMP, "U1"},
    {"Gas Gauging", "CEDV Configuration", 0x9264, BQ_DM_OVERLOAD_CURRENT, "I2"},
    {"Gas Gauging", "CEDV Configuration", 0x9268, BQ_DM_SELF_DISCHARGE_RATE, "U1"},
    {"Gas Gauging", "CEDV Configuration", 0x9269, BQ_DM_ELECTRONICS_LOAD, "I2"},
    {"Gas Gauging", "CEDV Configuration", 0x926B, BQ_DM_NEAR_FULL, "I2"},
    {"Gas Gauging", "CEDV Configuration", 0x926D, BQ_DM_RESERVE_CAPACITY, "I2"},
    {"Gas Gauging", "CEDV Configuration", 0x926F, BQ_DM_CHG_EFF, "U1"},
    {"Gas Gauging", "CEDV Configuration", 0x9270, BQ_DM_DSG_EFF, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x929B, BQ_DM_GAUGING_CONFIGURATION, "H2"},
    {"Gas Gauging", "CEDV Profile 1", 0x929D, BQ_DM_FULL_CHARGE_CAPACITY, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x929F, BQ_DM_DESIGN_CAPACITY, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92A3, BQ_DM_DESIGN_VOLTAGE, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92A5, BQ_DM_CHARGE_TERMINATION_VOLTAGE, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92A7, BQ_DM_EMF, "U2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92A9, BQ_DM_C0, "U2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92AB, BQ_DM_R0, "U2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92AD, BQ_DM_T0, "U2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92AF, BQ_DM_R1, "U2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B1, BQ_DM_TC, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B2, BQ_DM_C1, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B3, BQ_DM_AGE_FACTOR, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B4, BQ_DM_FIXED_EDV_0, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B6, BQ_DM_EDV_0_HOLD_TIME, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B7, BQ_DM_FIXED_EDV_1, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92B9, BQ_DM_EDV_1_HOLD_TIME, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x92BA, BQ_DM_FIXED_EDV_2, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92BC, BQ_DM_EDV_2_HOLD_TIME, "U1"},
    {"Gas Gauging", "CEDV Profile 1", 0x92BD, BQ_DM_VOLTAGE_0_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92BF, BQ_DM_VOLTAGE_10_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92C1, BQ_DM_VOLTAGE_20_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92C3, BQ_DM_VOLTAGE_30_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92C5, BQ_DM_VOLTAGE_40_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92C7, BQ_DM_VOLTAGE_50_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92C9, BQ_DM_VOLTAGE_60_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92CB, BQ_DM_VOLTAGE_70_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92CD, BQ_DM_VOLTAGE_80_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92CF, BQ_DM_VOLTAGE_90_DOD, "I2"},
    {"Gas Gauging", "CEDV Profile 1", 0x92D1, BQ_DM_VOLTAGE_100_DOD, "I2"},
    {"Gas Gauging", "CEDV Smoothing Config", 0x9271, BQ_DM_SMOOTHING_CONFIG, "H1"},
    {"Gas Gauging", "CEDV Smoothing Config", 0x9272, BQ_DM_SMOOTHING_START_VOLTAGE, "I2"},
    {"Gas Gauging", "CEDV Smoothing Config", 0x9274, BQ_DM_SMOOTHING_DELTA_VOLTAGE, "I2"},
    {"Gas Gauging", "CEDV Smoothing Config", 0x9276, BQ_DM_MAX_SMOOTHING_CURRENT, "I2"},
    {"Gas Gauging", "CEDV Smoothing Config", 0x927B, BQ_DM_EOC_SMOOTH_CURRENT, "U1"},
    {"Gas Gauging", "CEDV Smoothing Config", 0x927C, BQ_DM_EOC_SMOOTH_CURRENT_TIME, "U1"},
};
