/*
 * SPDX-FileCopyrightText: 2022-2023 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#if CONFIG_APPTRACE_SV_ENABLE && (ESP_IDF_VERSION >= ESP_IDF_VERSION_VAL(5, 0, 0))
#include "SEGGER_SYSVIEW.h"

#define SYSVIEW_MARKER_DFT_PIPE_HANDLE_ID         10
#define SYSVIEW_MARKER_UVC_PIPE_HANDLE_ID         11
#define SYSVIEW_MARKER_UAC_MIC_PIPE_HANDLE_ID     12
#define SYSVIEW_MARKER_UAC_SPK_PIPE_HANDLE_ID     13
#define SYSVIEW_DFLT_PIPE_XFER_START()      SEGGER_SYSVIEW_OnUserStart(SYSVIEW_MARKER_DFT_PIPE_HANDLE_ID)
#define SYSVIEW_DFLT_PIPE_XFER_STOP()       SEGGER_SYSVIEW_OnUserStop(SYSVIEW_MARKER_DFT_PIPE_HANDLE_ID)
#define SYSVIEW_UVC_PIPE_HANDLE_START()     SEGGER_SYSVIEW_OnUserStart(SYSVIEW_MARKER_UVC_PIPE_HANDLE_ID)
#define SYSVIEW_UVC_PIPE_HANDLE_STOP()      SEGGER_SYSVIEW_OnUserStop(SYSVIEW_MARKER_UVC_PIPE_HANDLE_ID)
#define SYSVIEW_UAC_MIC_PIPE_HANDLE_START() SEGGER_SYSVIEW_OnUserStart(SYSVIEW_MARKER_UAC_MIC_PIPE_HANDLE_ID)
#define SYSVIEW_UAC_MIC_PIPE_HANDLE_STOP()  SEGGER_SYSVIEW_OnUserStop(SYSVIEW_MARKER_UAC_MIC_PIPE_HANDLE_ID)
#define SYSVIEW_UAC_SPK_PIPE_HANDLE_START() SEGGER_SYSVIEW_OnUserStart(SYSVIEW_MARKER_UAC_SPK_PIPE_HANDLE_ID)
#define SYSVIEW_UAC_SPK_PIPE_HANDLE_STOP()  SEGGER_SYSVIEW_OnUserStop(SYSVIEW_MARKER_UAC_SPK_PIPE_HANDLE_ID)

#else
#define SYSVIEW_DFLT_PIPE_XFER_START()
#define SYSVIEW_DFLT_PIPE_XFER_STOP()
#define SYSVIEW_UVC_PIPE_HANDLE_START()
#define SYSVIEW_UVC_PIPE_HANDLE_STOP()
#define SYSVIEW_UAC_MIC_PIPE_HANDLE_START()
#define SYSVIEW_UAC_MIC_PIPE_HANDLE_STOP()
#define SYSVIEW_UAC_SPK_PIPE_HANDLE_START()
#define SYSVIEW_UAC_SPK_PIPE_HANDLE_STOP()

#endif
