/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include "stdint.h"
#include "lamp_array_matrix.h"
#include "rgb_matrix_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LIGHTMAP_GPIO            0
#define LIGHTMAP_NUM             82
#define LIGHTMAP_WIDTH           310000   /*!< 31 cm */
#define LIGHTMAP_HEIGHT          120000   /*!< 12 cm */
#define LIGHTMAP_DEPTH           25000    /*!< 2.5 cm */
#define LIGHTMAP_UPDATE_INTERVAL 10000    /*!< 10ms */

static Position LampPositions[LIGHTMAP_NUM] = {
    {303000, 12300, 0}, {274000, 12000, 0}, {255000, 12000, 0}, {236000, 12000, 0}, {217000, 12000, 0}, {188000, 12000, 0},
    {169000, 12000, 0}, {150000, 12000, 0}, {131000, 12000, 0}, {102000, 12000, 0}, {83000, 12000, 0}, {67000, 12000, 0},
    {45000, 12000, 0}, {7000, 12000, 0}, {7600, 36000, 0}, {26600, 36000, 0}, {45700, 36000, 0}, {64700, 36000, 0},
    {83000, 36000, 0}, {102000, 36000, 0}, {122000, 36000, 0}, {140000, 36000, 0}, {160000, 36000, 0}, {179000, 36000, 0},
    {198000, 36000, 0}, {217000, 36000, 0}, {236000, 36000, 0}, {264000, 36000, 0}, {303000, 36000, 0}, {303000, 55500, 0},
    {269000, 55500, 0}, {245000, 55500, 0}, {226000, 55500, 0}, {207000, 55500, 0}, {188000, 55500, 0}, {169000, 55500, 0},
    {150000, 55500, 0}, {131000, 55500, 0}, {112000, 55500, 0}, {93000, 55500, 0}, {74000, 55500, 0}, {55000, 55500, 0},
    {36000, 55000, 0}, {12000, 55500, 0}, {14000, 74500, 0}, {41000, 74500, 0}, {60000, 74500, 0}, {79000, 74500, 0},
    {98000, 74500, 0}, {117000, 74500, 0}, {136000, 74500, 0}, {155000, 74500, 0}, {174000, 74500, 0}, {193000, 74500, 0},
    {212000, 74500, 0}, {231000, 74500, 0}, {262000, 74500, 0}, {303000, 74500, 0}, {303000, 93600, 0}, {279000, 98600, 0},
    {248000, 93600, 0}, {221000, 93600, 0}, {202000, 93600, 0}, {183000, 93600, 0}, {164000, 93600, 0}, {145000, 93600, 0},
    {126000, 93600, 0}, {107000, 93600, 0}, {88000, 93600, 0}, {69000, 93600, 0}, {50000, 93600, 0}, {19000, 93600, 0},
    {10000, 112000, 0}, {33000, 112000, 0}, {57600, 112000, 0}, {129000, 112000, 0}, {198000, 112000, 0}, {217000, 112000, 0},
    {236000, 112000, 0}, {260000, 117000, 0}, {279000, 117000, 0}, {298000, 117000, 0}
};

led_config_t g_led_config = {{
        // Key Matrix to LED Index
        {13, NO_LED, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
        {14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28},
        {43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29},
        {44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, NO_LED, 57},
        {71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, NO_LED, 58},
        {72, 73, 74, NO_LED, NO_LED, 75, NO_LED, NO_LED, 76, 77, 78, 79, 80, NO_LED, 81}
    }, {
        // LED Index to Physical Position
        {224, 0}, {208, 0}, {192, 0}, {176, 0}, {160, 0}, {144, 0}, {128, 0}, {112, 0}, {96, 0}, {80, 0}, {64, 0}, {48, 0}, {32, 0}, {0, 0},
        {0, 12}, {16, 12}, {32, 12}, {48, 12}, {64, 12}, {80, 12}, {96, 12}, {112, 12}, {128, 12}, {144, 12}, {160, 12}, {176, 12}, {192, 12}, {208, 12}, {224, 12},
        {224, 25}, {208, 25}, {192, 25}, {176, 25}, {160, 25}, {144, 25}, {128, 25}, {112, 25}, {96, 25}, {80, 25}, {64, 25}, {48, 25}, {32, 25}, {16, 25}, {0, 25},
        {0, 38}, {16, 38}, {32, 38}, {48, 38}, {64, 38}, {80, 38}, {96, 38}, {112, 38}, {128, 38}, {144, 38}, {160, 38}, {176, 38}, {192, 38}, {224, 38},
        {224, 51}, {192, 51}, {176, 51}, {160, 51}, {144, 51}, {128, 51}, {112, 51}, {96, 51}, {80, 51}, {64, 51}, {48, 51}, {32, 51}, {16, 51}, {0, 51},
        {0, 64}, {16, 64}, {32, 64}, {80, 64}, {128, 64}, {144, 64}, {160, 64}, {176, 64}, {192, 64}, {224, 64}
    }, {
        // LED Index to Flag
        4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
        4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
        4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
        4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
        4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
        4, 4, 4, 4, 4, 4, 4
    }
};

#ifdef __cplusplus
}
#endif
