# GMSL Driver Deployment for Raspberry Pi 5

This repository contains kernel modules, device tree overlays, and utility scripts for testing GMSL cameras on Raspberry Pi 5.

---

## Table of Contents

1. [Requirements](#requirements)  
2. [Installation](#installation)  
3. [Usage](#usage)  
4. [Reference Images](#reference-images)  
5. [Notes](#notes)  
6. [Author](#author)  

---

## Requirements

- Raspberry Pi 5 with Raspberry Pi OS (64-bit).  
- `sudo` privileges.  
- Enough free space in `/boot` for kernel image and overlays.  
- The Raspberry Pi must be running the official Raspberry Pi OS image: `2025-05-13-raspios-bookworm-arm64.img.xz`.

---

## Installation

1. Place folder "ws-rpi5-gmsl" in Raspberry Pi 5.

2. Add executable permissions to scripts:
   ```bash
   chmod a+x rpi5_gmsl_driver_install.sh
   ```

3. Run the deployment script:
   ```bash
   ./rpi5_gmsl_driver_install.sh
   ```

4. Install the GStreamer tools package:
   ```bash
   sudo apt update
   sudo apt install gstreamer1.0-tools
   ```
---

## Usage

### 1. Using ISX031-GMSL-Camera-A / ISX031-GMSL-Camera-B Camera

The Camera supports both single-link and dual-link operation.

1. Add the appropriate `dtoverlay` to `/boot/firmware/config.txt`:

- For single-link (either Link A or Link B, automatically detected):
```
dtoverlay=isx031-gmsl-camera-a,sensor-type=ISX031C_GMSL2F_1CH
```
- For dual-link:
```
dtoverlay=isx031-gmsl-camera-a,sensor-type=ISX031C_GMSL2F_2CH
```

2. If using the Raspberry Pi 5 `CAM0` interface, add the `cam0` parameter:
```
dtoverlay=isx031-gmsl-camera-a,sensor-type=ISX031C_GMSL2F_1CH,cam0
dtoverlay=isx031-gmsl-camera-a,sensor-type=ISX031C_GMSL2F_2CH,cam0
```

3. The default i2c address of the deserializer is 0x48(0x90>>1). If you need to modify the address of the deserializer, add the `dser-addr` parameter:
```
dtoverlay=isx031-gmsl-camera-a,sensor-type=ISX031C_GMSL2F_1CH,dser-addr=0x4a
dtoverlay=isx031-gmsl-camera-a,sensor-type=ISX031C_GMSL2F_2CH,dser-addr=0x4a
```

4. Reboot the Raspberry Pi 5.

5. Use the script `ws_camera_preview.sh` to preview the camera:

- Connected to `CAM1`, dual-camera:
```bash
ws_camera_preview.sh ISX031-GMSL-Camera-A csi1 2ch
```
- Connected to `CAM1`, single-camera:
```bash
ws_camera_preview.sh ISX031-GMSL-Camera-A csi1 1ch
```
- Connected to `CAM0`, dual-camera:
```bash
ws_camera_preview.sh ISX031-GMSL-Camera-A csi0 2ch
```
- Connected to `CAM0`, single-camera:
```bash
ws_camera_preview.sh ISX031-GMSL-Camera-A csi0 1ch
```

---

## Reference Images

**Dip Switch Example**  
<img src="images/dip_switch_1.jpg" alt="Dip Switch Example" style="width:500px; box-shadow: 4px 4px 10px rgba(0,0,0,0.3);">

**GMSL Connection Diagram**  
<img src="images/gmsl_connection_1.jpg" alt="GMSL Connection" style="width:500px; box-shadow: 4px 4px 10px rgba(0,0,0,0.3);">

---

## Notes
1. When connecting the deserializer to the Raspberry Pi 5 CSI interface, use the shortest cable possible, preferably a shielded one.

---

## Author
English：<https://www.waveshare.com/>  
Chinese：<https://www.waveshare.net/>


