#!/bin/bash

#csi device path
csi0_device_path="/sys/devices/platform/axi/1000120000.pcie/1f00110000.csi"
csi1_device_path="/sys/devices/platform/axi/1000120000.pcie/1f00128000.csi"
csi0_i2c_num="10"
csi1_i2c_num="11"

csi_channle=$1
channel_flag=$2
sensor_width=$3
sensor_hight=$4
sensor_media_fmt=$5

get_media_num() {
	find "$1" -maxdepth 1 -type d | while read dir; do
		#echo "dir:$dir"
		media_num=`echo $dir | grep -o 'media[0-9]\+' | sed 's/media//'`
		#echo "num $meida_num"
		if [ "$media_num" ];then
			echo "$media_num"
			break
		fi
	done
	#echo "$media_num"
}

get_sensor_entity()
{
    local media_dev="$1"

    media-ctl -d "$media_dev" -p |
    awk '
        /^- entity/      { ent=$0 }
        /subtype Sensor/ { print ent; exit }
    ' |
    sed -n 's/.*entity [0-9]\+: \(.*\) (.*/\1/p'
}

#check param
# if [ $# != 4 ]; then
#         echo "Error: Invalid number of arguments, you provided $# argument(s)"
# 	exit 1
# fi

if [ "$csi_channle" == "csi0" ]; then
	csi0_media_num=$(get_media_num "$csi0_device_path")
	sensor_entity=$(get_sensor_entity "$csi0_media_num")
	echo "csi0_media_num $csi0_media_num"
	set_csi2_0_ch0_cfe_link="media-ctl -d $csi0_media_num -l ''\''csi2'\'':4 -> '\''rp1-cfe-csi2_ch0'\'':0 [1]'"
	set_csi2_0_ch0_pad0_fmt="media-ctl -d $csi0_media_num -V ''\''csi2'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_0_ch0_pad0_fmt="media-ctl -d $csi0_media_num -V ''\''${sensor_entity}'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_0_ch2_cfe_link="media-ctl -d $csi0_media_num -l ''\''csi2'\'':6 -> '\''rp1-cfe-csi2_ch2'\'':0 [1]'"
	set_csi2_0_ch2_pad2_fmt="media-ctl -d $csi0_media_num -V ''\''csi2'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_0_ch2_pad2_fmt="media-ctl -d $csi0_media_num -V ''\''${sensor_entity}'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_0_ch1_pad1_fmt="media-ctl -d $csi0_media_num -V ''\''csi2'\'':1 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_video_0_ch0_fmt="v4l2-ctl --device=/dev/video0 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_video_0_ch2_fmt="v4l2-ctl --device=/dev/video2 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_media_ctl_0_reset="media-ctl -r -d $csi0_media_num"
	echo $set_csi2_0_ch0_cfe_link
	echo $set_csi2_0_ch0_pad0_fmt
	echo $set_csi2_0_ch2_cfe_link
	echo $set_gmsl_0_ch0_pad0_fmt
	echo $set_csi2_0_ch2_pad2_fmt
	echo $set_gmsl_0_ch2_pad2_fmt
	echo $set_csi2_0_ch1_pad1_fmt
	echo $set_video_0_ch0_fmt
	echo $set_video_0_ch2_fmt
	echo $set_media_ctl_0_reset
elif [ "$csi_channle" == "csi1" ]; then
	csi1_media_num=$(get_media_num "$csi1_device_path")
	sensor_entity=$(get_sensor_entity "$csi1_media_num")
	echo "csi1_media_num $csi1_media_num"
	set_csi2_1_ch0_cfe_link="media-ctl -d $csi1_media_num -l ''\''csi2'\'':4 -> '\''rp1-cfe-csi2_ch0'\'':0 [1]'"
	set_csi2_1_ch0_pad0_fmt="media-ctl -d $csi1_media_num -V ''\''csi2'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_1_ch0_pad0_fmt="media-ctl -d $csi1_media_num -V ''\''${sensor_entity}'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_1_ch2_cfe_link="media-ctl -d $csi1_media_num -l ''\''csi2'\'':6 -> '\''rp1-cfe-csi2_ch2'\'':0 [1]'"
	set_csi2_1_ch2_pad2_fmt="media-ctl -d $csi1_media_num -V ''\''csi2'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_1_ch2_pad2_fmt="media-ctl -d $csi1_media_num -V ''\''${sensor_entity}'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_1_ch1_pad1_fmt="media-ctl -d $csi1_media_num -V ''\''csi2'\'':1 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_video_1_ch0_fmt="v4l2-ctl --device=/dev/video0 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_video_1_ch2_fmt="v4l2-ctl --device=/dev/video2 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_media_ctl_1_reset="media-ctl -r -d $csi1_media_num"
	echo $set_csi2_1_ch0_cfe_link
	echo $set_csi2_1_ch0_pad0_fmt
	echo $set_csi2_1_ch2_cfe_link
	echo $set_gmsl_1_ch0_pad0_fmt
	echo $set_csi2_1_ch2_pad2_fmt
	echo $set_gmsl_1_ch2_pad2_fmt
	echo $set_csi2_1_ch1_pad1_fmt
	echo $set_video_1_ch0_fmt
	echo $set_video_1_ch2_fmt
	echo $set_media_ctl_1_reset
elif [ "$csi_channle" == "all" ]; then
	csi0_media_num=$(get_media_num "$csi0_device_path")
	sensor_entity=$(get_sensor_entity "$csi0_media_num")
	echo "csi0_media_num $csi0_media_num"
	set_csi2_0_ch0_cfe_link="media-ctl -d $csi0_media_num -l ''\''csi2'\'':4 -> '\''rp1-cfe-csi2_ch0'\'':0 [1]'"
	set_csi2_0_ch0_pad0_fmt="media-ctl -d $csi0_media_num -V ''\''csi2'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_0_ch0_pad0_fmt="media-ctl -d $csi0_media_num -V ''\''${sensor_entity}'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_0_ch2_cfe_link="media-ctl -d $csi0_media_num -l ''\''csi2'\'':6 -> '\''rp1-cfe-csi2_ch2'\'':0 [1]'"
	set_csi2_0_ch2_pad2_fmt="media-ctl -d $csi0_media_num -V ''\''csi2'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_0_ch2_pad2_fmt="media-ctl -d $csi0_media_num -V ''\''${sensor_entity}'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_0_ch1_pad1_fmt="media-ctl -d $csi0_media_num -V ''\''csi2'\'':1 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_video_0_ch0_fmt="v4l2-ctl --device=/dev/video8 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_video_0_ch2_fmt="v4l2-ctl --device=/dev/video10 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_media_ctl_0_reset="media-ctl -r -d $csi0_media_num"
	echo $set_csi2_0_ch0_cfe_link
	echo $set_csi2_0_ch0_pad0_fmt
	echo $set_csi2_0_ch2_cfe_link
	echo $set_gmsl_0_ch0_pad0_fmt
	echo $set_csi2_0_ch2_pad2_fmt
	echo $set_gmsl_0_ch2_pad2_fmt
	echo $set_csi2_0_ch1_pad1_fmt
	echo $set_video_0_ch0_fmt
	echo $set_video_0_ch2_fmt
	echo $set_media_ctl_0_reset

	csi1_media_num=$(get_media_num "$csi1_device_path")
	sensor_entity=$(get_sensor_entity "$csi1_media_num")
	echo "csi1_media_num $csi1_media_num"
	set_csi2_1_ch0_cfe_link="media-ctl -d $csi1_media_num -l ''\''csi2'\'':4 -> '\''rp1-cfe-csi2_ch0'\'':0 [1]'"
	set_csi2_1_ch0_pad0_fmt="media-ctl -d $csi1_media_num -V ''\''csi2'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_1_ch0_pad0_fmt="media-ctl -d $csi1_media_num -V ''\''${sensor_entity}'\'':0 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_1_ch2_cfe_link="media-ctl -d $csi1_media_num -l ''\''csi2'\'':6 -> '\''rp1-cfe-csi2_ch2'\'':0 [1]'"
	set_csi2_1_ch2_pad2_fmt="media-ctl -d $csi1_media_num -V ''\''csi2'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_gmsl_1_ch2_pad2_fmt="media-ctl -d $csi1_media_num -V ''\''${sensor_entity}'\'':2 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_csi2_1_ch1_pad1_fmt="media-ctl -d $csi1_media_num -V ''\''csi2'\'':1 [fmt:${sensor_media_fmt}/${sensor_width}x${sensor_hight} field:none colorspace:smpte170m]'"
	set_video_1_ch0_fmt="v4l2-ctl --device=/dev/video0 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_video_1_ch2_fmt="v4l2-ctl --device=/dev/video2 --set-fmt-video=width=${sensor_width},height=${sensor_hight},pixelformat=UYVY"
	set_media_ctl_1_reset="media-ctl -r -d $csi1_media_num"
	echo $set_csi2_1_ch0_cfe_link
	echo $set_csi2_1_ch0_pad0_fmt
	echo $set_csi2_1_ch2_cfe_link
	echo $set_gmsl_1_ch0_pad0_fmt
	echo $set_csi2_1_ch2_pad2_fmt
	echo $set_gmsl_1_ch2_pad2_fmt
	echo $set_csi2_1_ch1_pad1_fmt
	echo $set_video_1_ch0_fmt
	echo $set_video_1_ch2_fmt
	echo $set_media_ctl_1_reset
else
	echo "not suppot current deivce $1"

fi

if [ "$csi_channle" == "csi0" ]; then
	if [ "$channel_flag" == "1ch" ]; then
		eval $set_media_ctl_0_reset
		eval $set_csi2_0_ch0_cfe_link
		eval $set_csi2_0_ch0_pad0_fmt
		eval $set_csi2_0_ch1_pad1_fmt
		eval $set_csi2_0_ch2_pad2_fmt
		eval $set_gmsl_0_ch0_pad0_fmt
		eval $set_video_0_ch0_fmt
	elif [ "$channel_flag" == "2ch" ]; then
		eval $set_media_ctl_0_reset
		eval $set_csi2_0_ch0_cfe_link
		eval $set_csi2_0_ch2_cfe_link
		eval $set_csi2_0_ch0_pad0_fmt
		eval $set_csi2_0_ch1_pad1_fmt
		eval $set_csi2_0_ch2_pad2_fmt
		eval $set_gmsl_0_ch0_pad0_fmt
		eval $set_gmsl_0_ch2_pad2_fmt
		eval $set_video_0_ch0_fmt
		eval $set_video_0_ch2_fmt
	else
		echo "not support current channel $channel_flag"
		exit 1
	fi
elif [ "$csi_channle" == "csi1" ]; then
	if [ "$channel_flag" == "1ch" ]; then
		eval $set_media_ctl_1_reset
		eval $set_csi2_1_ch0_cfe_link
		eval $set_csi2_1_ch0_pad0_fmt
		eval $set_csi2_1_ch1_pad1_fmt
		eval $set_csi2_1_ch2_pad2_fmt
		eval $set_gmsl_1_ch0_pad0_fmt
		eval $set_video_1_ch0_fmt
	elif [ "$channel_flag" == "2ch" ]; then
		eval $set_media_ctl_1_reset
		eval $set_csi2_1_ch0_cfe_link
		eval $set_csi2_1_ch2_cfe_link
		eval $set_csi2_1_ch0_pad0_fmt
		eval $set_csi2_1_ch1_pad1_fmt
		eval $set_csi2_1_ch2_pad2_fmt
		eval $set_gmsl_1_ch0_pad0_fmt
		eval $set_gmsl_1_ch2_pad2_fmt
		eval $set_video_1_ch0_fmt
		eval $set_video_1_ch2_fmt
	else
		echo "not support current channel $channel_flag"
		exit 1
	fi
elif [ "$csi_channle" == "all" ]; then
	if [ "$channel_flag" == "1ch" ]; then
		eval $set_media_ctl_0_reset
		eval $set_csi2_0_ch0_cfe_link
		eval $set_csi2_0_ch0_pad0_fmt
		eval $set_csi2_0_ch1_pad1_fmt
		eval $set_csi2_0_ch2_pad2_fmt
		eval $set_gmsl_0_ch0_pad0_fmt
		eval $set_video_0_ch0_fmt

		eval $set_media_ctl_1_reset
		eval $set_csi2_1_ch0_cfe_link
		eval $set_csi2_1_ch0_pad0_fmt
		eval $set_csi2_1_ch1_pad1_fmt
		eval $set_csi2_1_ch2_pad2_fmt
		eval $set_gmsl_1_ch0_pad0_fmt
		eval $set_video_1_ch0_fmt
	elif [ "$channel_flag" == "2ch" ]; then
		eval $set_media_ctl_0_reset
		eval $set_csi2_0_ch0_cfe_link
		eval $set_csi2_0_ch2_cfe_link
		eval $set_csi2_0_ch0_pad0_fmt
		eval $set_csi2_0_ch1_pad1_fmt
		eval $set_csi2_0_ch2_pad2_fmt
		eval $set_gmsl_0_ch0_pad0_fmt
		eval $set_gmsl_0_ch2_pad2_fmt
		eval $set_video_0_ch0_fmt
		eval $set_video_0_ch2_fmt

		eval $set_media_ctl_1_reset
		eval $set_csi2_1_ch0_cfe_link
		eval $set_csi2_1_ch2_cfe_link
		eval $set_csi2_1_ch0_pad0_fmt
		eval $set_csi2_1_ch1_pad1_fmt
		eval $set_csi2_1_ch2_pad2_fmt
		eval $set_gmsl_1_ch0_pad0_fmt
		eval $set_gmsl_1_ch2_pad2_fmt
		eval $set_video_1_ch0_fmt
		eval $set_video_1_ch2_fmt
	else
		echo "not support current channel $channel_flag"
		exit 1
	fi

else
	echo "not suppot current deivce $1"

fi

