#!/bin/bash

# ws_camera_preview.sh ISX031-GMSL-Camera-A csi1 2ch

csi_channle=$2
channel_flag=$3

set_sensor_params()
{
    local sensor_name="$1"

    case "$sensor_name" in
        ISX031-GMSL-Camera-A)
            sensor_width=1920
            sensor_hight=1536
            sensor_media_fmt=UYVY8_1X16
            gst_video_fmt=UYVY
            ;;
        ISX031-GMSL-Camera-B)
            sensor_width=1920
            sensor_hight=1536
            sensor_media_fmt=UYVY8_1X16
            gst_video_fmt=UYVY
            ;;
        *)
            echo "WARNING: Unsupported sensor type: '$sensor_name'" >&2
            echo "         Please check the sensor model or update the script." >&2
            return 1
            ;;
    esac

    return 0
}

set_sensor_params "$1" || {
    echo "Camera initialization aborted." >&2
    exit 1
}

ws_camera_ctrl.sh "$csi_channle" "$channel_flag" "$sensor_width" "$sensor_hight" "$sensor_media_fmt"

#check param
# if [ $# != 4 ]; then
# 	echo "Error: Invalid number of arguments, you provided $# argument(s)"
# 	exit 1
# fi

# Function to clean up on exit
cleanup() {
    echo "Cleaning up gst-launch processes..."
    for pid in "${gst_pids[@]}"; do
        if kill -0 "$pid" 2>/dev/null; then
            echo "Killing process $pid"
            kill "$pid"
        fi
    done
    exit 0
}

# Trap Ctrl+C (SIGINT) and other signals
trap cleanup SIGINT SIGTERM

# Function to launch gst and record PID
launch_gst() {
    eval "$1" &
    pid=$!
    gst_pids+=("$pid")
}

if [ "$csi_channle" == "csi0" ]; then
	if [ "$channel_flag" == "1ch" ]; then
		run_gstream_csi0_1ch="gst-launch-1.0 v4l2src device=/dev/video0 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi0_1ch"
	elif [ "$channel_flag" == "2ch" ]; then
		run_gstream_csi0_1ch="gst-launch-1.0 v4l2src device=/dev/video0 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi0_1ch"
		run_gstream_csi0_2ch="gst-launch-1.0 v4l2src device=/dev/video2 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi0_2ch"
	else
		echo "not support current channel $channel_flag"
		exit 1
	fi
elif [ "$csi_channle" == "csi1" ]; then
	if [ "$channel_flag" == "1ch" ]; then
		run_gstream_csi1_1ch="gst-launch-1.0 v4l2src device=/dev/video0 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi1_1ch"
	elif [ "$channel_flag" == "2ch" ]; then
		run_gstream_csi1_1ch="gst-launch-1.0 v4l2src device=/dev/video0 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi1_1ch"
		run_gstream_csi1_2ch="gst-launch-1.0 v4l2src device=/dev/video2 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi1_2ch"
	else
		echo "not support current channel $channel_flag"
		exit 1
	fi
elif [ "$csi_channle" == "all" ]; then
	if [ "$channel_flag" == "1ch" ]; then
		run_gstream_csi0_1ch="gst-launch-1.0 v4l2src device=/dev/video8 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi0_1ch"
		run_gstream_csi1_1ch="gst-launch-1.0 v4l2src device=/dev/video0 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi1_1ch"
	elif [ "$channel_flag" == "2ch" ]; then
		run_gstream_csi0_1ch="gst-launch-1.0 v4l2src device=/dev/video8 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi0_1ch"
		run_gstream_csi0_2ch="gst-launch-1.0 v4l2src device=/dev/video10 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi0_2ch"
		run_gstream_csi1_1ch="gst-launch-1.0 v4l2src device=/dev/video0 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi1_1ch"
		run_gstream_csi1_2ch="gst-launch-1.0 v4l2src device=/dev/video2 ! 'video/x-raw,format=${gst_video_fmt},width=${sensor_width},height=${sensor_hight},framerate=30/1' ! videoconvert ! videoscale ! video/x-raw,width=640,height=480 ! fpsdisplaysink video-sink=xvimagesink sync=false"
		launch_gst "$run_gstream_csi1_2ch"
	else
		echo "not support current channel $channel_flag"
		exit 1
	fi

else
	echo "not suppot current deivce $1"

fi

# Wait for all gst-launch processes to finish (or be killed)
wait

