/*****************************************************************************
* | File      	:   audio_data.c
* | Author      :   Waveshare Team
* | Function    :   Audio Data
* | Info        :
*----------------
* |	This version:   V1.0
* | Date        :   2025-02-26
* | Info        :   
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documnetation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to  whom the Software is
# furished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
******************************************************************************/
#include "audio_data.h"

const int16_t Sine_wave_table[] = 
{
	0x0000, 0x0324, 0x0648, 0x096A, 0x0C8C, 0x0FAB, 0x12C8, 0x15E2, 0x18F9, 0x1C0B, 0x1F1A, 0x2223, 0x2528, 0x2826, 0x2B1F, 0x2E11, 
	0x30FB, 0x33DF, 0x36BA, 0x398C, 0x3C56, 0x3F17, 0x41CE, 0x447A, 0x471C, 0x49B4, 0x4C3F, 0x4EBF, 0x5133, 0x539B, 0x55F5, 0x5842, 
	0x5A82, 0x5CB3, 0x5ED7, 0x60EB, 0x62F1, 0x64E8, 0x66CF, 0x68A6, 0x6A6D, 0x6C23, 0x6DC9, 0x6F5E, 0x70E2, 0x7254, 0x73B5, 0x7504, 
	0x7641, 0x776B, 0x7884, 0x7989, 0x7A7C, 0x7B5C, 0x7C29, 0x7CE3, 0x7D89, 0x7E1D, 0x7E9C, 0x7F09, 0x7F61, 0x7FA6, 0x7FD8, 0x7FF5, 
	0x7FFF, 0x7FF5, 0x7FD8, 0x7FA6, 0x7F61, 0x7F09, 0x7E9C, 0x7E1D, 0x7D89, 0x7CE3, 0x7C29, 0x7B5C, 0x7A7C, 0x7989, 0x7884, 0x776B, 
	0x7641, 0x7504, 0x73B5, 0x7254, 0x70E2, 0x6F5E, 0x6DC9, 0x6C23, 0x6A6D, 0x68A6, 0x66CF, 0x64E8, 0x62F1, 0x60EB, 0x5ED7, 0x5CB3, 
	0x5A82, 0x5842, 0x55F5, 0x539B, 0x5133, 0x4EBF, 0x4C3F, 0x49B4, 0x471C, 0x447A, 0x41CE, 0x3F17, 0x3C56, 0x398C, 0x36BA, 0x33DF, 
	0x30FB, 0x2E11, 0x2B1F, 0x2826, 0x2528, 0x2223, 0x1F1A, 0x1C0B, 0x18F9, 0x15E2, 0x12C8, 0x0FAB, 0x0C8C, 0x096A, 0x0648, 0x0324, 
	0x0000, 0xFCDC, 0xF9B8, 0xF696, 0xF374, 0xF055, 0xED38, 0xEA1E, 0xE707, 0xE3F5, 0xE0E6, 0xDDDD, 0xDAD8, 0xD7DA, 0xD4E1, 0xD1EF,
	0xCF05, 0xCC21, 0xC946, 0xC674, 0xC3AA, 0xC0E9, 0xBE32, 0xBB86, 0xB8E4, 0xB64C, 0xB3C1, 0xB141, 0xAECD, 0xAC65, 0xAA0B, 0xA7BE, 
	0xA57E, 0xA34D, 0xA129, 0x9F15, 0x9D0F, 0x9B18, 0x9931, 0x975A, 0x9593, 0x93DD, 0x9237, 0x90A2, 0x8F1E, 0x8DAC, 0x8C4B, 0x8AFC, 
	0x89BF, 0x8895, 0x877C, 0x8677, 0x8584, 0x84A4, 0x83D7, 0x831D, 0x8277, 0x81E3, 0x8164, 0x80F7, 0x809F, 0x805A, 0x8028, 0x800B, 
	0x8001, 0x800B, 0x8028, 0x805A, 0x809F, 0x80F7, 0x8164, 0x81E3, 0x8277, 0x831D, 0x83D7, 0x84A4, 0x8584, 0x8677, 0x877C, 0x8895, 
	0x89BF, 0x8AFC, 0x8C4B, 0x8DAC, 0x8F1E, 0x90A2, 0x9237, 0x93DD, 0x9593, 0x975A, 0x9931, 0x9B18, 0x9D0F, 0x9F15, 0xA129, 0xA34D, 
	0xA57E, 0xA7BE, 0xAA0B, 0xAC65, 0xAECD, 0xB141, 0xB3C1, 0xB64C, 0xB8E4, 0xBB86, 0xBE32, 0xC0E9, 0xC3AA, 0xC674, 0xC946, 0xCC21, 
	0xCF05, 0xD1EF, 0xD4E1, 0xD7DA, 0xDAD8, 0xDDDD, 0xE0E6, 0xE3F5, 0xE707, 0xEA1E, 0xED38, 0xF055, 0xF374, 0xF696, 0xF9B8, 0xFCDC
};

const int16_t Happy_birsday[]= 
{
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0003, 0x0004, 0x0006, 0x0008, 0x000A, 0x000C, 0x000F,
        0x0012, 0x0016, 0x0019, 0x001D, 0x0022, 0x0026, 0x002B, 0x0030, 0x0036, 0x003B, 0x0041, 0x0047, 0x004D, 0x0053, 0x0059, 0x0060,
        0x0066, 0x006C, 0x0071, 0x0077, 0x007C, 0x0081, 0x0086, 0x008A, 0x008D, 0x0090, 0x0093, 0x0094, 0x0095, 0x0095, 0x0094, 0x0093,
        0x0090, 0x008C, 0x0088, 0x0082, 0x007B, 0x0073, 0x0069, 0x005E, 0x0053, 0x0045, 0x0037, 0x0027, 0x0016, 0x0004, 0xFFF1, 0xFFDC,
        0xFFC6, 0xFFAF, 0xFF97, 0xFF7D, 0xFF63, 0xFF48, 0xFF2B, 0xFF0E, 0xFEF0, 0xFED2, 0xFEB3, 0xFE93, 0xFE73, 0xFE53, 0xFE33, 0xFE13,
        0xFDF3, 0xFDD3, 0xFDB4, 0xFD95, 0xFD77, 0xFD5A, 0xFD3E, 0xFD23, 0xFD09, 0xFCF1, 0xFCDA, 0xFCC5, 0xFCB2, 0xFCA1, 0xFC93, 0xFC86,
        0xFC7C, 0xFC75, 0xFC70, 0xFC6E, 0xFC6F, 0xFC73, 0xFC7B, 0xFC85, 0xFC93, 0xFCA4, 0xFCB9, 0xFCD1, 0xFCED, 0xFD0C, 0xFD2F, 0xFD56,
        0xFD80, 0xFDAE, 0xFDDF, 0xFE13, 0xFE4B, 0xFE87, 0xFEC5, 0xFF07, 0xFF4C, 0xFF94, 0xFFDE, 0x002A, 0x007A, 0x00CB, 0x011F, 0x0175,
        0x01CC, 0x0224, 0x027E, 0x02D8, 0x0333, 0x038F, 0x03EA, 0x0445, 0x04A0, 0x04FA, 0x0553, 0x05AA, 0x05FF, 0x0652, 0x06A3, 0x06F1,
        0x073C, 0x0784, 0x07C8, 0x0808, 0x0844, 0x087B, 0x08AD, 0x08DA, 0x0902, 0x0924, 0x0940, 0x0955, 0x0965, 0x096D, 0x096F, 0x096A,
        0x095E, 0x094B, 0x0930, 0x090E, 0x08E4, 0x08B2, 0x0879, 0x0838, 0x07F0, 0x07A0, 0x0748, 0x06E9, 0x0683, 0x0615, 0x05A1, 0x0526,
        0x04A4, 0x041B, 0x038D, 0x02F8, 0x025E, 0x01BF, 0x011B, 0x0073, 0xFFC8, 0xFF18, 0xFE65, 0xFDAF, 0xFCF7, 0xFC3D, 0xFB81, 0xFAC6,
        0xFA09, 0xF94E, 0xF893, 0xF7D9, 0xF722, 0xF66D, 0xF5BC, 0xF50E, 0xF465, 0xF3C0, 0xF321, 0xF289, 0xF1F6, 0xF16B, 0xF0E8, 0xF06D,
        0xEFFA, 0xEF91, 0xEF32, 0xEEDD, 0xEE92, 0xEE53, 0xEE1F, 0xEDF7, 0xEDDA, 0xEDCB, 0xEDC8, 0xEDD2, 0xEDE9, 0xEE0D, 0xEE3F, 0xEE7E,
        0xEECB, 0xEF25, 0xEF8D, 0xF003, 0xF086, 0xF117, 0xF1B4, 0xF25F, 0xF316, 0xF3D9, 0xF4A9, 0xF584, 0xF66A, 0xF75B, 0xF856, 0xF95B,
        0xFA68, 0xFB7F, 0xFC9D, 0xFDC3, 0xFEEE, 0x001F, 0x0155, 0x0290, 0x03CE, 0x050F, 0x0651, 0x0793, 0x08D6, 0x0A18, 0x0B57, 0x0C94,
        0x0DCD, 0x0F01, 0x1030, 0x1158, 0x1278, 0x138F, 0x149E, 0x15A2, 0x169B, 0x1787, 0x1867, 0x1939, 0x19FD, 0x1AB1, 0x1B56, 0x1BEA,
        0x1C6C, 0x1CDC, 0x1D3A, 0x1D85, 0x1DBC, 0x1DE0, 0x1DEF, 0x1DE9, 0x1DCE, 0x1D9E, 0x1D59, 0x1CFE, 0x1C8D, 0x1C08, 0x1B6C, 0x1ABC,
        0x19F6, 0x191B, 0x182C, 0x1729, 0x1612, 0x14E7, 0x13AA, 0x125B, 0x10FB, 0x0F8A, 0x0E09, 0x0C7A, 0x0ADC, 0x0931, 0x077A, 0x05B8,
        0x03EC, 0x0217, 0x003A, 0xFE58, 0xFC70, 0xFA84, 0xF896, 0xF6A6, 0xF4B6, 0xF2C8, 0xF0DC, 0xEEF5, 0xED13, 0xEB38, 0xE966, 0xE79D,
        0xE5E0, 0xE42F, 0xE28C, 0xE0F8, 0xDF74, 0xDE02, 0xDCA4, 0xDB59, 0xDA24, 0xD905, 0xD7FE, 0xD70F, 0xD639, 0xD57E, 0xD4DE, 0xD45A,
        0xD3F2, 0xD3A8, 0xD37C, 0xD36E, 0xD37E, 0xD3AD, 0xD3FC, 0xD46A, 0xD4F7, 0xD5A4, 0xD670, 0xD75B, 0xD865, 0xD98D, 0xDAD3, 0xDC37,
        0xDDB8, 0xDF54, 0xE10C, 0xE2DE, 0xE4CA, 0xE6CD, 0xE8E8, 0xEB19, 0xED5F, 0xEFB8, 0xF223, 0xF49F, 0xF729, 0xF9C0, 0xFC64, 0xFF11,
        0x01C5, 0x0481, 0x0741, 0x0A04, 0x0CC7, 0x0F8A, 0x1249, 0x1503, 0x17B7, 0x1A61, 0x1D01, 0x1F93, 0x2217, 0x248A, 0x26EB, 0x2938,
        0x2B6E, 0x2D8C, 0x2F91, 0x317A, 0x3346, 0x34F4, 0x3682, 0x37EF, 0x3938, 0x3A5E, 0x3B5F, 0x3C3A, 0x3CED, 0x3D78, 0x3DDB, 0x3E14,
        0x3E23, 0x3E07, 0x3DC1, 0x3D4F, 0x3CB2, 0x3BEA, 0x3AF7, 0x39D9, 0x3890, 0x371E, 0x3581, 0x33BD, 0x31D0, 0x2FBC, 0x2D82, 0x2B23,
        0x28A1, 0x25FD, 0x2339, 0x2055, 0x1D54, 0x1A37, 0x1701, 0x13B4, 0x1051, 0x0CDA, 0x0952, 0x05BC, 0x0218, 0xFE6C, 0xFAB7, 0xF6FC,
        0xF33F, 0xEF82, 0xEBC7, 0xE811, 0xE463, 0xE0BF, 0xDD28, 0xD9A0, 0xD62A, 0xD2C9, 0xCF7F, 0xCC4E, 0xC93A, 0xC644, 0xC36E, 0xC0BC,
        0xBE2E, 0xBBC8, 0xB98B, 0xB779, 0xB594, 0xB3DE, 0xB258, 0xB104, 0xAFE2, 0xAEF5, 0xAE3D, 0xADBC, 0xAD72, 0xAD5F, 0xAD85, 0xADE4,
        0xAE7C, 0xAF4C, 0xB056, 0xB199, 0xB314, 0xB4C6, 0xB6B0, 0xB8D1, 0xBB26, 0xBDB0, 0xC06C, 0xC35A, 0xC678, 0xC9C4, 0xCD3C, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC619, 0xC9AF, 0xCD69, 0xD144, 0xD540, 0xD958, 0xDD8B, 0xE1D4, 0xE632, 0xEAA1, 0xEF1F, 0xF3A8, 0xF839, 0xFCD0, 0x0168,
        0x0600, 0x0A93, 0x0F20, 0x13A2, 0x1818, 0x1C7D, 0x20CE, 0x250A, 0x292D, 0x2D34, 0x311C, 0x34E4, 0x3887, 0x3C05, 0x3F5A, 0x4285,
        0x4583, 0x4851, 0x4AF0, 0x4D5B, 0x4F93, 0x5194, 0x535F, 0x54F2, 0x564B, 0x576B, 0x584F, 0x58F8, 0x5965, 0x5996, 0x598A, 0x5942,
        0x58BE, 0x57FE, 0x5702, 0x55CC, 0x545D, 0x52B4, 0x50D4, 0x4EBD, 0x4C71, 0x49F2, 0x4740, 0x445F, 0x4150, 0x3E14, 0x3AAF, 0x3723,
        0x3371, 0x2F9C, 0x2BA8, 0x2795, 0x2369, 0x1F24, 0x1ACB, 0x165F, 0x11E4, 0x0D5D, 0x08CE, 0x0438, 0xFFA0, 0xFB08, 0xF673, 0xF1E5,
        0xED60, 0xE8E7, 0xE47E, 0xE028, 0xDBE7, 0xD7BF, 0xD3B1, 0xCFC2, 0xCBF2, 0xC846, 0xC4C0, 0xC162, 0xBE2D, 0xBB25, 0xB84C, 0xB5A3,
        0xB32B, 0xB0E8, 0xAEDA, 0xAD03, 0xAB63, 0xA9FD, 0xA8D1, 0xA7DF, 0xA729, 0xA6AE, 0xA670, 0xA66E, 0xA6A9, 0xA71F, 0xA7D2, 0xA8C0,
        0xA9E9, 0xAB4C, 0xACE8, 0xAEBC, 0xB0C6, 0xB307, 0xB57A, 0xB821, 0xBAF7, 0xBDFC, 0xC12E, 0xC48A, 0xC80E, 0xCBB8, 0xCF85, 0xD373,
        0xD77E, 0xDBA5, 0xDFE5, 0xE43A, 0xE8A2, 0xED19, 0xF19E, 0xF62C, 0xFAC0, 0xFF58, 0x03F0, 0x0886, 0x0D16, 0x119E, 0x1619, 0x1A86,
        0x1EE1, 0x2326, 0x2755, 0x2B69, 0x2F5F, 0x3336, 0x36EA, 0x3A79, 0x3DE0, 0x411E, 0x4430, 0x4715, 0x49C9, 0x4C4B, 0x4E9A, 0x50B4,
        0x5298, 0x5444, 0x55B8, 0x56F1, 0x57F0, 0x58B4, 0x593B, 0x5987, 0x5997, 0x596A, 0x5900, 0x585B, 0x577A, 0x565F, 0x5509, 0x537A,
        0x51B2, 0x4FB4, 0x4D7F, 0x4B17, 0x487C, 0x45B0, 0x42B5, 0x3F8D, 0x3C3B, 0x38BF, 0x351E, 0x3159, 0x2D72, 0x296D, 0x254C, 0x2111,
        0x1CC1, 0x185D, 0x13E9, 0x0F67, 0x0ADB, 0x0647, 0x01B0, 0xFD18, 0xF881, 0xF3EF, 0xEF66, 0xEAE7, 0xE677, 0xE218, 0xDDCD, 0xD999,
        0xD57F, 0xD182, 0xCDA4, 0xC9E8, 0xC650, 0xC2E0, 0xBF98, 0xBC7C, 0xB98D, 0xB6CE, 0xB441, 0xB1E6, 0xAFC0, 0xADD0, 0xAC17, 0xAA97,
        0xA950, 0xA844, 0xA773, 0xA6DE, 0xA685, 0xA668, 0xA687, 0xA6E3, 0xA77B, 0xA84E, 0xA95C, 0xAAA5, 0xAC28, 0xADE3, 0xAFD5, 0xB1FD,
        0xB45A, 0xB6EA, 0xB9AB, 0xBC9C, 0xBFBA, 0xC303, 0xC675, 0xCA0E, 0xCDCC, 0xD1AB, 0xD5AA, 0xD9C5, 0xDDFA, 0xE245, 0xE6A5, 0xEB16,
        0xEF95, 0xF41F, 0xF8B1, 0xFD48, 0x01E0, 0x0677, 0x0B0B, 0x0F96, 0x1418, 0x188B, 0x1CEE, 0x213E, 0x2577, 0x2997, 0x2D9B, 0x3181,
        0x3544, 0x38E4, 0x3C5E, 0x3FAF, 0x42D5, 0x45CE, 0x4898, 0x4B31, 0x4D97, 0x4FCA, 0x51C6, 0x538B, 0x5518, 0x566B, 0x5785, 0x5863,
        0x5906, 0x596D, 0x5997, 0x5985, 0x5937, 0x58AD, 0x57E7, 0x56E5, 0x55A9, 0x5434, 0x5286, 0x50A0, 0x4E83, 0x4C32, 0x49AD, 0x46F7,
        0x4411, 0x40FD, 0x3DBE, 0x3A54, 0x36C4, 0x330E, 0x2F36, 0x2B3E, 0x272A, 0x22FA, 0x1EB3, 0x1A58, 0x15EB, 0x116E, 0x0CE7, 0x0856,
        0x03C0, 0xFF28, 0xFA90, 0xF5FC, 0xF16E, 0xECEA, 0xE873, 0xE40C, 0xDFB8, 0xDB79, 0xD753, 0xD349, 0xCF5C, 0xCB91, 0xC7E9, 0xC466,
        0xC10C, 0xBDDC, 0xBAD9, 0xB804, 0xB560, 0xB2EE, 0xB0B0, 0xAEA8, 0xACD6, 0xAB3C, 0xA9DC, 0xA8B5, 0xA7CA, 0xA719, 0xA6A5, 0xA66D,
        0xA671, 0xA6B2, 0xA72F, 0xA7E8, 0xA8DC, 0xAA0B, 0xAB73, 0xAD15, 0xAEEF, 0xB0FF, 0xB344, 0xB5BD, 0xB869, 0xBB44, 0xBE4E, 0xC184,
        0xC4E4, 0xC86C, 0xCC1A, 0xCFEA, 0xD3DB, 0xD7E9, 0xDC13, 0xE055, 0xE4AC, 0xE916, 0xED8F, 0xF214, 0xF6A3, 0xFB38, 0xFFD0, 0x0468,
        0x08FD, 0x0D8D, 0x1213, 0x168D, 0x1AF8, 0x1F51, 0x2395, 0x27C1, 0x2BD1, 0x2FC5, 0x3398, 0x3748, 0x3AD4, 0x3E37, 0x4171, 0x447E,
        0x475D, 0x4A0D, 0x4C8A, 0x4ED4, 0x50E8, 0x52C6, 0x546D, 0x55DA, 0x570E, 0x5807, 0x58C4, 0x5946, 0x598C, 0x5995, 0x5962, 0x58F2,
        0x5847, 0x5760, 0x563E, 0x54E3, 0x534E, 0x5181, 0x4F7C, 0x4D43, 0x4AD5, 0x4835, 0x4564, 0x4265, 0x3F38, 0x3BE1, 0x3862, 0x34BD,
        0x30F4, 0x2D0A, 0x2902, 0x24DE, 0x20A2, 0x1C4F, 0x17E9, 0x1374, 0x0EF1, 0x0A64, 0x05D0, 0x0138, 0xFCA0, 0xF80A, 0xF378, 0xEEF0,
        0xEA73, 0xE604, 0xE1A7, 0xDD5E, 0xD92D, 0xD516, 0xD11C, 0xCD41, 0xC988, 0xC5F5, 0xC288, 0xBF45, 0xBC2D, 0xB944, 0xB689, 0xB401,
        0xB1AB, 0xAF8B, 0xADA0, 0xABED, 0xAA73, 0xA932, 0xA82C, 0xA761, 0xA6D2, 0xA67F, 0xA668, 0xA68E, 0xA6EF, 0xA78D, 0xA867, 0xA97B,
        0xAACA, 0xAC52, 0xAE13, 0xB00B, 0xB239, 0xB49B, 0xB730, 0xB9F6, 0xBCEB, 0xC00E, 0xC35B, 0xC6D1, 0xCA6E, 0xCE2F, 0xD212, 0xD614,
        0xDA31, 0xDE69, 0xE2B7, 0xE718, 0xEB8B, 0xF00B, 0xF496, 0xF929, 0xFDC0, 0x0258, 0x06EF, 0x0B82, 0x100D, 0x148D, 0x18FF, 0x1D60,
        0x21AD, 0x25E4, 0x2A02, 0x2E03, 0x31E5, 0x35A5, 0x3941, 0x3CB7, 0x4003, 0x4325, 0x4619, 0x48DE, 0x4B72, 0x4DD3, 0x5000, 0x51F7,
        0x53B6, 0x553D, 0x568B, 0x579E, 0x5876, 0x5913, 0x5974, 0x5998, 0x5980, 0x592C, 0x589B, 0x57CF, 0x56C8, 0x5586, 0x540B, 0x5256,
        0x506B, 0x4E49, 0x4BF3, 0x4969, 0x46AE, 0x43C3, 0x40AA, 0x3D66, 0x39F9, 0x3664, 0x32AB, 0x2ED0, 0x2AD5, 0x26BD, 0x228C, 0x1E42,
        0x19E5, 0x1576, 0x10F9, 0x0C70, 0x07DF, 0x0348, 0xFEB0, 0xFA18, 0xF584, 0xF0F8, 0xEC75, 0xE7FF, 0xE39A, 0xDF48, 0xDB0C, 0xD6E9,
        0xD2E1, 0xCEF8, 0xCB30, 0xC78B, 0xC40D, 0xC0B7, 0xBD8B, 0xBA8D, 0xB7BD, 0xB51E, 0xB2B1, 0xB078, 0xAE75, 0xACA9, 0xAB16, 0xA9BB,
        0xA89B, 0xA7B5, 0xA70B, 0xA69D, 0xA66B, 0xA675, 0xA6BC, 0xA73F, 0xA7FE, 0xA8F8, 0xAA2D, 0xAB9B, 0xAD43, 0xAF22, 0xB138, 0xB383,
        0xB601, 0xB8B1, 0xBB91, 0xBEA0, 0xC1DA, 0xC53F, 0xC8CB, 0xCC7C, 0xD050, 0xD444, 0xD855, 0xDC81, 0xE0C5, 0xE51F, 0xE98A, 0xEE04,
        0xF28B, 0xF71A, 0xFBB0, 0x0048, 0x04E0, 0x0975, 0x0E04, 0x1289, 0x1702, 0x1B6B, 0x1FC2, 0x2403, 0x282C, 0x2C3A, 0x302A, 0x33FA,
        0x37A7, 0x3B2E, 0x3E8D, 0x41C2, 0x44CB, 0x47A6, 0x4A50, 0x4CC8, 0x4F0D, 0x511C, 0x52F4, 0x5495, 0x55FC, 0x572A, 0x581D, 0x58D4,
        0x5950, 0x598F, 0x5992, 0x5959, 0x58E4, 0x5832, 0x5745, 0x561E, 0x54BC, 0x5321, 0x514E, 0x4F45, 0x4D06, 0x4A93, 0x47EE, 0x4518,
        0x4214, 0x3EE3, 0x3B88, 0x3805, 0x345C, 0x308F, 0x2CA2, 0x2897, 0x2471, 0x2032, 0x1BDD, 0x1776, 0x12FE, 0x0E7A, 0x09EC, 0x0558,
        0x00C0, 0xFC28, 0xF792, 0xF302, 0xEE7A, 0xE9FE, 0xE591, 0xE136, 0xDCF0, 0xD8C1, 0xD4AC, 0xD0B5, 0xCCDE, 0xC929, 0xC599, 0xC231,
        0xBEF2, 0xBBDF, 0xB8FA, 0xB645, 0xB3C1, 0xB171, 0xAF56, 0xAD71, 0xABC4, 0xAA4F, 0xA915, 0xA815, 0xA750, 0xA6C7, 0xA67A, 0xA669,
        0xA695, 0xA6FD, 0xA7A1, 0xA880, 0xA99B, 0xAAF0, 0xAC7E, 0xAE44, 0xB041, 0xB275, 0xB4DC, 0xB776, 0xBA41, 0xBD3B, 0xC062, 0xC3B4,
        0xC72E, 0xCACF, 0xCE93, 0xD279, 0xD67E, 0xDA9E, 0xDED8, 0xE328, 0xE78C, 0xEC00, 0xF081, 0xF50D, 0xF9A1, 0xFE38, 0x02D0, 0x0767,
        0x0BF9, 0x1083, 0x1501, 0x1972, 0x1DD1, 0x221D, 0x2651, 0x2A6C, 0x2E69, 0x3248, 0x3605, 0x399D, 0x3D0F, 0x4057, 0x4374, 0x4664,
        0x4924, 0x4BB3, 0x4E0E, 0x5036, 0x5227, 0x53E1, 0x5562, 0x56AA, 0x57B7, 0x5889, 0x5920, 0x597A, 0x5998, 0x597A, 0x5920, 0x5889,
        0x57B7, 0x56AA, 0x5562, 0x53E1, 0x5227, 0x5036, 0x4E0E, 0x4BB3, 0x4924, 0x4664, 0x4374, 0x4057, 0x3D0F, 0x399D, 0x3605, 0x3248,
        0x2E69, 0x2A6C, 0x2651, 0x221D, 0x1DD1, 0x1972, 0x1501, 0x1083, 0x0BF9, 0x0767, 0x02D0, 0xFE38, 0xF9A1, 0xF50D, 0xF081, 0xEC00,
        0xE78C, 0xE328, 0xDED8, 0xDA9E, 0xD67E, 0xD279, 0xCE93, 0xCACF, 0xC72E, 0xC3B4, 0xC062, 0xBD3B, 0xBA41, 0xB776, 0xB4DC, 0xB275,
        0xB041, 0xAE44, 0xAC7E, 0xAAF0, 0xA99B, 0xA880, 0xA7A1, 0xA6FD, 0xA695, 0xA669, 0xA67A, 0xA6C7, 0xA750, 0xA815, 0xA915, 0xAA4F,
        0xABC4, 0xAD71, 0xAF56, 0xB171, 0xB3C1, 0xB645, 0xB8FA, 0xBBDF, 0xBEF2, 0xC231, 0xC599, 0xC929, 0xCCDE, 0xD0B5, 0xD4AC, 0xD8C1,
        0xDCF0, 0xE136, 0xE591, 0xE9FE, 0xEE7A, 0xF302, 0xF792, 0xFC28, 0x00C0, 0x0558, 0x09EC, 0x0E7A, 0x12FE, 0x1776, 0x1BDD, 0x2032,
        0x2471, 0x2897, 0x2CA2, 0x308F, 0x345C, 0x3805, 0x3B88, 0x3EE3, 0x4214, 0x4518, 0x47EE, 0x4A93, 0x4D06, 0x4F45, 0x514E, 0x5321,
        0x54BC, 0x561E, 0x5745, 0x5832, 0x58E4, 0x5959, 0x5992, 0x598F, 0x5950, 0x58D4, 0x581D, 0x572A, 0x55FC, 0x5495, 0x52F4, 0x511C,
        0x4F0D, 0x4CC8, 0x4A50, 0x47A6, 0x44CB, 0x41C2, 0x3E8D, 0x3B2E, 0x37A7, 0x33FA, 0x302A, 0x2C3A, 0x282C, 0x2403, 0x1FC2, 0x1B6B,
        0x1702, 0x1289, 0x0E04, 0x0975, 0x04E0, 0x0048, 0xFBB0, 0xF71A, 0xF28B, 0xEE04, 0xE98A, 0xE51F, 0xE0C5, 0xDC81, 0xD855, 0xD444,
        0xD050, 0xCC7C, 0xC8CB, 0xC53F, 0xC1DA, 0xBEA0, 0xBB91, 0xB8B1, 0xB601, 0xB383, 0xB138, 0xAF22, 0xAD43, 0xAB9B, 0xAA2D, 0xA8F8,
        0xA7FE, 0xA73F, 0xA6BC, 0xA675, 0xA66B, 0xA69D, 0xA70B, 0xA7B5, 0xA89B, 0xA9BB, 0xAB16, 0xACA9, 0xAE75, 0xB078, 0xB2B1, 0xB51E,
        0xB7BD, 0xBA8D, 0xBD8B, 0xC0B7, 0xC40D, 0xC78B, 0xCB30, 0xCEF8, 0xD2E1, 0xD6E9, 0xDB0C, 0xDF48, 0xE39A, 0xE7FF, 0xEC75, 0xF0F8,
        0xF584, 0xFA18, 0xFEB0, 0x0348, 0x07DF, 0x0C70, 0x10F9, 0x1576, 0x19E5, 0x1E42, 0x228C, 0x26BD, 0x2AD5, 0x2ED0, 0x32AB, 0x3664,
        0x39F9, 0x3D66, 0x40AA, 0x43C3, 0x46AE, 0x4969, 0x4BF3, 0x4E49, 0x506B, 0x5256, 0x540B, 0x5586, 0x56C8, 0x57CF, 0x589B, 0x592C,
        0x5980, 0x5998, 0x5974, 0x5913, 0x5876, 0x579E, 0x568B, 0x553D, 0x53B6, 0x51F7, 0x5000, 0x4DD3, 0x4B72, 0x48DE, 0x4619, 0x4325,
        0x4003, 0x3CB7, 0x3941, 0x35A5, 0x31E5, 0x2E03, 0x2A02, 0x25E4, 0x21AD, 0x1D60, 0x18FF, 0x148D, 0x100D, 0x0B82, 0x06EF, 0x0258,
        0xFDC0, 0xF929, 0xF496, 0xF00B, 0xEB8B, 0xE718, 0xE2B7, 0xDE69, 0xDA31, 0xD614, 0xD212, 0xCE2F, 0xCA6E, 0xC6D1, 0xC35B, 0xC00E,
        0xBCEB, 0xB9F6, 0xB730, 0xB49B, 0xB239, 0xB00B, 0xAE13, 0xAC52, 0xAACA, 0xA97B, 0xA867, 0xA78D, 0xA6EF, 0xA68E, 0xA668, 0xA67F,
        0xA6D2, 0xA761, 0xA82C, 0xA932, 0xAA73, 0xABED, 0xADA0, 0xAF8B, 0xB1AB, 0xB401, 0xB689, 0xB944, 0xBC2D, 0xBF45, 0xC288, 0xC5F5,
        0xC988, 0xCD41, 0xD11C, 0xD516, 0xD92D, 0xDD5E, 0xE1A7, 0xE604, 0xEA73, 0xEEF0, 0xF378, 0xF80A, 0xFCA0, 0x0138, 0x05D0, 0x0A64,
        0x0EF1, 0x1374, 0x17E9, 0x1C4F, 0x20A2, 0x24DE, 0x2902, 0x2D0A, 0x30F4, 0x34BD, 0x3862, 0x3BE1, 0x3F38, 0x4265, 0x4564, 0x4835,
        0x4AD5, 0x4D43, 0x4F7C, 0x5181, 0x534E, 0x54E3, 0x563E, 0x5760, 0x5847, 0x58F2, 0x5962, 0x5995, 0x598C, 0x5946, 0x58C4, 0x5807,
        0x570E, 0x55DA, 0x546D, 0x52C6, 0x50E8, 0x4ED4, 0x4C8A, 0x4A0D, 0x475D, 0x447E, 0x4171, 0x3E37, 0x3AD4, 0x3748, 0x3398, 0x2FC5,
        0x2BD1, 0x27C1, 0x2395, 0x1F51, 0x1AF8, 0x168D, 0x1213, 0x0D8D, 0x08FD, 0x0468, 0xFFD0, 0xFB38, 0xF6A3, 0xF214, 0xED8F, 0xE916,
        0xE4AC, 0xE055, 0xDC13, 0xD7E9, 0xD3DB, 0xCFEA, 0xCC1A, 0xC86C, 0xC4E4, 0xC184, 0xBE4E, 0xBB44, 0xB869, 0xB5BD, 0xB344, 0xB0FF,
        0xAEEF, 0xAD15, 0xAB73, 0xAA0B, 0xA8DC, 0xA7E8, 0xA72F, 0xA6B2, 0xA671, 0xA66D, 0xA6A5, 0xA719, 0xA7CA, 0xA8B5, 0xA9DC, 0xAB3C,
        0xACD6, 0xAEA8, 0xB0B0, 0xB2EE, 0xB560, 0xB804, 0xBAD9, 0xBDDC, 0xC10C, 0xC466, 0xC7E9, 0xCB91, 0xCF5C, 0xD349, 0xD753, 0xDB79,
        0xDFB8, 0xE40C, 0xE873, 0xECEA, 0xF16E, 0xF5FC, 0xFA90, 0xFF28, 0x03C0, 0x0856, 0x0CE7, 0x116E, 0x15EB, 0x1A58, 0x1EB3, 0x22FA,
        0x272A, 0x2B3E, 0x2F36, 0x330E, 0x36C4, 0x3A54, 0x3DBE, 0x40FD, 0x4411, 0x46F7, 0x49AD, 0x4C32, 0x4E83, 0x50A0, 0x5286, 0x5434,
        0x55A9, 0x56E5, 0x57E7, 0x58AD, 0x5937, 0x5985, 0x5997, 0x596D, 0x5906, 0x5863, 0x5785, 0x566B, 0x5518, 0x538B, 0x51C6, 0x4FCA,
        0x4D97, 0x4B31, 0x4898, 0x45CE, 0x42D5, 0x3FAF, 0x3C5E, 0x38E4, 0x3544, 0x3181, 0x2D9B, 0x2997, 0x2577, 0x213E, 0x1CEE, 0x188B,
        0x1418, 0x0F96, 0x0B0B, 0x0677, 0x01E0, 0xFD48, 0xF8B1, 0xF41F, 0xEF95, 0xEB16, 0xE6A5, 0xE245, 0xDDFA, 0xD9C5, 0xD5AA, 0xD1AB,
        0xCDCC, 0xCA0E, 0xC675, 0xC303, 0xBFBA, 0xBC9C, 0xB9AB, 0xB6EA, 0xB45A, 0xB1FD, 0xAFD5, 0xADE3, 0xAC28, 0xAAA5, 0xA95C, 0xA84E,
        0xA77B, 0xA6E3, 0xA687, 0xA668, 0xA685, 0xA6DE, 0xA773, 0xA844, 0xA950, 0xAA97, 0xAC17, 0xADD0, 0xAFC0, 0xB1E6, 0xB441, 0xB6CE,
        0xB98D, 0xBC7C, 0xBF98, 0xC2E0, 0xC650, 0xC9E8, 0xCDA4, 0xD182, 0xD57F, 0xD999, 0xDDCD, 0xE218, 0xE677, 0xEAE7, 0xEF66, 0xF3EF,
        0xF881, 0xFD18, 0x01B0, 0x0647, 0x0ADB, 0x0F67, 0x13E9, 0x185D, 0x1CC1, 0x2111, 0x254C, 0x296D, 0x2D72, 0x3159, 0x351E, 0x38BF,
        0x3C3B, 0x3F8D, 0x42B5, 0x45B0, 0x487C, 0x4B17, 0x4D7F, 0x4FB4, 0x51B2, 0x537A, 0x5509, 0x565F, 0x577A, 0x585B, 0x5900, 0x596A,
        0x5997, 0x5987, 0x593B, 0x58B4, 0x57F0, 0x56F1, 0x55B8, 0x5444, 0x5298, 0x50B4, 0x4E9A, 0x4C4B, 0x49C9, 0x4715, 0x4430, 0x411E,
        0x3DE0, 0x3A79, 0x36EA, 0x3336, 0x2F5F, 0x2B69, 0x2755, 0x2326, 0x1EE1, 0x1A86, 0x1619, 0x119E, 0x0D16, 0x0886, 0x03F0, 0xFF58,
        0xFAC0, 0xF62C, 0xF19E, 0xED19, 0xE8A2, 0xE43A, 0xDFE5, 0xDBA5, 0xD77E, 0xD373, 0xCF85, 0xCBB8, 0xC80E, 0xC48A, 0xC12E, 0xBDFC,
        0xBAF7, 0xB821, 0xB57A, 0xB307, 0xB0C6, 0xAEBC, 0xACE8, 0xAB4C, 0xA9E9, 0xA8C0, 0xA7D2, 0xA71F, 0xA6A9, 0xA66E, 0xA670, 0xA6AE,
        0xA729, 0xA7DF, 0xA8D1, 0xA9FD, 0xAB63, 0xAD03, 0xAEDA, 0xB0E8, 0xB32B, 0xB5A3, 0xB84C, 0xBB25, 0xBE2D, 0xC162, 0xC4C0, 0xC846,
        0xCBF2, 0xCFC2, 0xD3B1, 0xD7BF, 0xDBE7, 0xE028, 0xE47E, 0xE8E7, 0xED60, 0xF1E5, 0xF673, 0xFB08, 0xFFA0, 0x0438, 0x08CE, 0x0D5D,
        0x11E4, 0x165F, 0x1ACB, 0x1F24, 0x2369, 0x2795, 0x2BA8, 0x2F9C, 0x3371, 0x3723, 0x3AAF, 0x3E14, 0x4150, 0x445F, 0x4740, 0x49F2,
        0x4C71, 0x4EBD, 0x50D4, 0x52B4, 0x545D, 0x55CC, 0x5702, 0x57FE, 0x58BE, 0x5942, 0x598A, 0x5996, 0x5965, 0x58F8, 0x584F, 0x576B,
        0x564B, 0x54F2, 0x535F, 0x5194, 0x4F93, 0x4D5B, 0x4AF0, 0x4851, 0x4583, 0x4285, 0x3F5A, 0x3C05, 0x3887, 0x34E4, 0x311C, 0x2D34,
        0x292D, 0x250A, 0x20CE, 0x1C7D, 0x1818, 0x13A2, 0x0F20, 0x0A93, 0x0600, 0x0168, 0xFCD0, 0xF839, 0xF3A8, 0xEF1F, 0xEAA1, 0xE632,
        0xE1D4, 0xDD8B, 0xD958, 0xD540, 0xD144, 0xCD69, 0xC9AF, 0xC619, 0xC2AB, 0xBF66, 0xBC4D, 0xB961, 0xB6A5, 0xB41A, 0xB1C3, 0xAFA0,
        0xADB3, 0xABFE, 0xAA81, 0xA93E, 0xA836, 0xA768, 0xA6D7, 0xA681, 0xA668, 0xA68B, 0xA6EA, 0xA786, 0xA85D, 0xA96F, 0xAABB, 0xAC41,
        0xAE00, 0xAFF5, 0xB221, 0xB481, 0xB714, 0xB9D8, 0xBCCB, 0xBFEC, 0xC338, 0xC6AD, 0xCA48, 0xCE08, 0xD1E9, 0xD5E9, 0xDA06, 0xDE3C,
        0xE289, 0xE6EA, 0xEB5C, 0xEFDC, 0xF466, 0xF8F9, 0xFD90, 0x0228, 0x06BF, 0x0B52, 0x0FDD, 0x145E, 0x18D1, 0x1D33, 0x2181, 0x25B9,
        0x29D7, 0x2DD9, 0x31BD, 0x357E, 0x391C, 0x3C93, 0x3FE2, 0x4305, 0x45FB, 0x48C2, 0x4B58, 0x4DBB, 0x4FEA, 0x51E3, 0x53A5, 0x552E,
        0x567E, 0x5794, 0x586F, 0x590E, 0x5971, 0x5998, 0x5982, 0x5930, 0x58A2, 0x57D9, 0x56D4, 0x5594, 0x541B, 0x5269, 0x5080, 0x4E60,
        0x4C0C, 0x4984, 0x46CB, 0x43E2, 0x40CC, 0x3D89, 0x3A1E, 0x368B, 0x32D3, 0x2EF9, 0x2AFF, 0x26E9, 0x22B8, 0x1E70, 0x1A13, 0x15A5,
        0x1128, 0x0C9F, 0x080E, 0x0378, 0xFEE0, 0xFA48, 0xF5B4, 0xF127, 0xECA4, 0xE82E, 0xE3C8, 0xDF75, 0xDB38, 0xD713, 0xD30A, 0xCF20,
        0xCB57, 0xC7B1, 0xC430, 0xC0D9, 0xBDAB, 0xBAAB, 0xB7D9, 0xB538, 0xB2C9, 0xB08F, 0xAE89, 0xACBB, 0xAB25, 0xA9C8, 0xA8A5, 0xA7BD,
        0xA711, 0xA6A0, 0xA66C, 0xA674, 0xA6B8, 0xA739, 0xA7F5, 0xA8ED, 0xAA1F, 0xAB8B, 0xAD30, 0xAF0D, 0xB121, 0xB36A, 0xB5E6, 0xB894,
        0xBB72, 0xBE7F, 0xC1B8, 0xC51A, 0xC8A5, 0xCC54, 0xD027, 0xD41A, 0xD82A, 0xDC55, 0xE098, 0xE4F1, 0xE95B, 0xEDD5, 0xF25B, 0xF6EB,
        0xFB80, 0x0018, 0x04B0, 0x0945, 0x0DD4, 0x125A, 0x16D3, 0x1B3D, 0x1F95, 0x23D7, 0x2801, 0x2C10, 0x3002, 0x33D3, 0x3781, 0x3B0A,
        0x3E6B, 0x41A2, 0x44AC, 0x4789, 0x4A35, 0x4CAF, 0x4EF6, 0x5107, 0x52E2, 0x5485, 0x55EF, 0x571F, 0x5814, 0x58CE, 0x594C, 0x598E,
        0x5993, 0x595D, 0x58EA, 0x583B, 0x5750, 0x562B, 0x54CC, 0x5333, 0x5163, 0x4F5B, 0x4D1E, 0x4AAD, 0x480A, 0x4537, 0x4234, 0x3F05,
        0x3BAC, 0x382A, 0x3483, 0x30B8, 0x2CCC, 0x28C2, 0x249D, 0x205F, 0x1C0B, 0x17A4, 0x132D, 0x0EAA, 0x0A1C, 0x0588, 0x00F0, 0xFC58,
        0xF7C2, 0xF331, 0xEEA9, 0xEA2D, 0xE5BF, 0xE163, 0xDD1C, 0xD8EC, 0xD4D7, 0xD0DE, 0xCD06, 0xC94F, 0xC5BE, 0xC254, 0xBF13, 0xBBFE,
        0xB917, 0xB660, 0xB3DB, 0xB188, 0xAF6B, 0xAD84, 0xABD4, 0xAA5E, 0xA921, 0xA81E, 0xA757, 0xA6CB, 0xA67C, 0xA669, 0xA692, 0xA6F7,
        0xA799, 0xA876, 0xA98E, 0xAAE1, 0xAC6C, 0xAE30, 0xB02C, 0xB25D, 0xB4C2, 0xB75A, 0xBA23, 0xBD1B, 0xC040, 0xC390, 0xC709, 0xCAA8,
        0xCE6B, 0xD250, 0xD653, 0xDA73, 0xDEAC, 0xE2FB, 0xE75E, 0xEBD1, 0xF052, 0xF4DE, 0xF971, 0xFE08, 0x02A0, 0x0737, 0x0BC9, 0x1053,
        0x14D3, 0x1944, 0x1DA4, 0x21F0, 0x2626, 0x2A41, 0x2E40, 0x3220, 0x35DE, 0x3978, 0x3CEC, 0x4036, 0x4354, 0x4646, 0x4908, 0x4B99,
        0x4DF7, 0x5020, 0x5214, 0x53D0, 0x5553, 0x569D, 0x57AD, 0x5882, 0x591B, 0x5978, 0x5998, 0x597D, 0x5925, 0x5890, 0x57C1, 0x56B6,
        0x5570, 0x53F1, 0x523A, 0x504B, 0x4E26, 0x4BCC, 0x493F, 0x4681, 0x4394, 0x4078, 0x3D32, 0x39C2, 0x362B, 0x3270, 0x2E92, 0x2A96,
        0x267C, 0x2249, 0x1DFF, 0x19A0, 0x1530, 0x10B2, 0x0C28, 0x0797, 0x0300, 0xFE68, 0xF9D0, 0xF53D, 0xF0B1, 0xEC2F, 0xE7BA, 0xE356,
        0xDF05, 0xDACA, 0xD6A9, 0xD2A3, 0xCEBC, 0xCAF6, 0xC753, 0xC3D7, 0xC084, 0xBD5B, 0xBA5F, 0xB792, 0xB4F6, 0xB28D, 0xB057, 0xAE58,
        0xAC8F, 0xAAFF, 0xA9A8, 0xA88B, 0xA7A9, 0xA702, 0xA698, 0xA66A, 0xA678, 0xA6C2, 0xA749, 0xA80B, 0xA909, 0xAA42, 0xABB4, 0xAD5F,
        0xAF41, 0xB15A, 0xB3A8, 0xB62A, 0xB8DD, 0xBBC0, 0xBED1, 0xC20E, 0xC575, 0xC903, 0xCCB7, 0xD08D, 0xD482, 0xD896, 0xDCC3, 0xE109,
        0xE563, 0xE9D0, 0xEE4B, 0xF2D2, 0xF762, 0xFBF8, 0x0090, 0x0528, 0x09BD, 0x0E4B, 0x12CF, 0x1747, 0x1BAF, 0x2005, 0x2445, 0x286C,
        0x2C79, 0x3067, 0x3435, 0x37DF, 0x3B64, 0x3EC1, 0x41F3, 0x44F9, 0x47D1, 0x4A78, 0x4CED, 0x4F2E, 0x513A, 0x530F, 0x54AC, 0x5610,
        0x573A, 0x582A, 0x58DD, 0x5955, 0x5991, 0x5991, 0x5954, 0x58DA, 0x5825, 0x5735, 0x560A, 0x54A4, 0x5306, 0x5130, 0x4F23, 0x4CE1,
        0x4A6B, 0x47C3, 0x44EA, 0x41E3, 0x3EB0, 0x3B52, 0x37CC, 0x3421, 0x3053, 0x2C64, 0x2857, 0x242F, 0x1FEE, 0x1B99, 0x1730, 0x12B8,
        0x0E33, 0x09A5, 0x0510, 0x0078, 0xFBE0, 0xF74A, 0xF2BA, 0xEE33, 0xE9B8, 0xE54C, 0xE0F2, 0xDCAD, 0xD880, 0xD46D, 0xD078, 0xCCA3,
        0xC8F0, 0xC563, 0xC1FD, 0xBEC1, 0xBBB0, 0xB8CE, 0xB61C, 0xB39C, 0xB14F, 0xAF37, 0xAD55, 0xABAB, 0xAA3B, 0xA903, 0xA807, 0xA746,
        0xA6C0, 0xA677, 0xA66A, 0xA699, 0xA705, 0xA7AD, 0xA890, 0xA9AE, 0xAB06, 0xAC98, 0xAE62, 0xB062, 0xB299, 0xB503, 0xB7A0, 0xBA6E,
        0xBD6B, 0xC095, 0xC3E9, 0xC766, 0xCB09, 0xCED0, 0xD2B7, 0xD6BE, 0xDAE0, 0xDF1B, 0xE36D, 0xE7D1, 0xEC46, 0xF0C8, 0xF555, 0xF9E8,
        0xFE80, 0x0318, 0x07AF, 0x0C40, 0x10C9, 0x1547, 0x19B7, 0x1E15, 0x225F, 0x2692, 0x2AAB, 0x2EA7, 0x3284, 0x363E, 0x39D4, 0x3D43,
        0x4089, 0x43A3, 0x4690, 0x494D, 0x4BD9, 0x4E32, 0x5056, 0x5243, 0x53FA, 0x5578, 0x56BC, 0x57C6, 0x5894, 0x5927, 0x597E, 0x5998,
        0x5976, 0x5918, 0x587E, 0x57A8, 0x5697, 0x554C, 0x53C7, 0x520A, 0x5015, 0x4DEB, 0x4B8C, 0x48FA, 0x4637, 0x4345, 0x4025, 0x3CDA,
        0x3966, 0x35CB, 0x320C, 0x2E2C, 0x2A2C, 0x2610, 0x21DA, 0x1D8D, 0x192D, 0x14BB, 0x103C, 0x0BB1, 0x071F, 0x0288, 0xFDF0, 0xF959,
        0xF4C6, 0xF03A, 0xEBBA, 0xE747, 0xE2E4, 0xDE95, 0xDA5D, 0xD63E, 0xD23B, 0xCE57, 0xCA95, 0xC6F6, 0xC37E, 0xC02F, 0xBD0B, 0xBA14,
        0xB74C, 0xB4B5, 0xB251, 0xB021, 0xAE27, 0xAC64, 0xAAD9, 0xA988, 0xA871, 0xA795, 0xA6F5, 0xA690, 0xA668, 0xA67D, 0xA6CD, 0xA75A,
        0xA823, 0xA926, 0xAA65, 0xABDD, 0xAD8D, 0xAF75, 0xB194, 0xB3E7, 0xB66E, 0xB926, 0xBC0E, 0xBF24, 0xC265, 0xC5D0, 0xC962, 0xCD19,
        0xD0F3, 0xD4EC, 0xD902, 0xDD32, 0xE17A, 0xE5D6, 0xEA44, 0xEEC1, 0xF349, 0xF7DA, 0xFC70, 0x0108, 0x05A0, 0x0A34, 0x0EC1, 0x1345,
        0x17BB, 0x1C22, 0x2075, 0x24B3, 0x28D7, 0x2CE1, 0x30CC, 0x3496, 0x383D, 0x3BBE, 0x3F16, 0x4244, 0x4546, 0x4819, 0x4ABB, 0x4D2A,
        0x4F66, 0x516D, 0x533C, 0x54D3, 0x5631, 0x5756, 0x583F, 0x58EC, 0x595E, 0x5994, 0x598D, 0x594A, 0x58CB, 0x5810, 0x5719, 0x55E8,
        0x547D, 0x52D9, 0x50FD, 0x4EEB, 0x4CA3, 0x4A28, 0x477A, 0x449D, 0x4191, 0x3E5A, 0x3AF8, 0x376E, 0x33BF, 0x2FED, 0x2BFB, 0x27EC,
        0x23C1, 0x1F7E, 0x1B26, 0x16BC, 0x1242, 0x0DBC, 0x092D, 0x0498, 0x0000, 0xFB68, 0xF6D3, 0xF244, 0xEDBE, 0xE944, 0xE4DA, 0xE082,
        0xDC3F, 0xD814, 0xD405, 0xD013, 0xCC41, 0xC892, 0xC508, 0xC1A6, 0xBE6F, 0xBB63, 0xB886, 0xB5D8, 0xB35D, 0xB115, 0xAF03, 0xAD27,
        0xAB83, 0xAA18, 0xA8E7, 0xA7F0, 0xA735, 0xA6B6, 0xA673, 0xA66C, 0xA6A2, 0xA714, 0xA7C1, 0xA8AA, 0xA9CF, 0xAB2D, 0xACC4, 0xAE93,
        0xB09A, 0xB2D6, 0xB545, 0xB7E7, 0xBABA, 0xBDBC, 0xC0EA, 0xC442, 0xC7C3, 0xCB6A, 0xCF34, 0xD31F, 0xD729, 0xDB4D, 0xDF8B, 0xE3DE,
        0xE845, 0xECBB, 0xF13F, 0xF5CC, 0xFA60, 0xFEF8, 0x0390, 0x0826, 0x0CB7, 0x113F, 0x15BC, 0x1A2A, 0x1E86, 0x22CE, 0x26FE, 0x2B14,
        0x2F0D, 0x32E7, 0x369E, 0x3A30, 0x3D9B, 0x40DC, 0x43F2, 0x46DA, 0x4992, 0x4C19, 0x4E6C, 0x508B, 0x5273, 0x5423, 0x559B, 0x56DA,
        0x57DD, 0x58A6, 0x5933, 0x5983, 0x5998, 0x5970, 0x590B, 0x586B, 0x578F, 0x5678, 0x5527, 0x539C, 0x51D9, 0x4FDF, 0x4DAF, 0x4B4B,
        0x48B4, 0x45EC, 0x42F5, 0x3FD1, 0x3C82, 0x390A, 0x356B, 0x31A9, 0x2DC5, 0x29C2, 0x25A3, 0x216B, 0x1D1C, 0x18B9, 0x1446, 0x0FC6,
        0x0B3A, 0x06A7, 0x0210, 0xFD78, 0xF8E1, 0xF44F, 0xEFC4, 0xEB45, 0xE6D3, 0xE273, 0xDE26, 0xD9F0, 0xD5D4, 0xD1D4, 0xCDF4, 0xCA35,
        0xC69A, 0xC326, 0xBFDB, 0xBCBB, 0xB9C9, 0xB706, 0xB474, 0xB215, 0xAFEB, 0xADF6, 0xAC39, 0xAAB4, 0xA969, 0xA858, 0xA782, 0xA6E8,
        0xA68A, 0xA668, 0xA682, 0xA6D9, 0xA76C, 0xA83A, 0xA944, 0xAA88, 0xAC06, 0xADBD, 0xAFAA, 0xB1CE, 0xB427, 0xB6B3, 0xB970, 0xBC5D,
        0xBF77, 0xC2BD, 0xC62C, 0xC9C2, 0xCD7C, 0xD159, 0xD555, 0xD96E, 0xDDA1, 0xE1EB, 0xE649, 0xEAB9, 0xEF37, 0xF3C0, 0xF851, 0xFCE8,
        0x0180, 0x0618, 0x0AAB, 0x0F38, 0x13BA, 0x182F, 0x1C93, 0x20E5, 0x2520, 0x2942, 0x2D49, 0x3130, 0x34F7, 0x389A, 0x3C17, 0x3F6B,
        0x4295, 0x4592, 0x4860, 0x4AFD, 0x4D67, 0x4F9E, 0x519E, 0x5368, 0x54FA, 0x5652, 0x5770, 0x5853, 0x58FB, 0x5967, 0x5996, 0x5989,
        0x5940, 0x58BA, 0x57F9, 0x56FD, 0x55C5, 0x5455, 0x52AB, 0x50C9, 0x4EB1, 0x4C64, 0x49E4, 0x4732, 0x4450, 0x413F, 0x3E03, 0x3A9D,
        0x3710, 0x335D, 0x2F88, 0x2B93, 0x2780, 0x2353, 0x1F0E, 0x1AB4, 0x1648, 0x11CD, 0x0D46, 0x08B6, 0x0420, 0xFF88, 0xFAF0, 0xF65B,
        0xF1CD, 0xED48, 0xE8D0, 0xE467, 0xE012, 0xDBD1, 0xD7A9, 0xD39C, 0xCFAD, 0xCBDF, 0xC834, 0xC4AE, 0xC150, 0xBE1D, 0xBB16, 0xB83D,
        0xB595, 0xB31F, 0xB0DD, 0xAED0, 0xACFA, 0xAB5C, 0xA9F6, 0xA8CB, 0xA7DB, 0xA726, 0xA6AC, 0xA66F, 0xA66F, 0xA6AB, 0xA723, 0xA7D6,
        0xA8C6, 0xA9F0, 0xAB54, 0xACF1, 0xAEC6, 0xB0D2, 0xB313, 0xB588, 0xB82F, 0xBB07, 0xBE0D, 0xC13F, 0xC49C, 0xC821, 0xCBCB, 0xCF99,
        0xD387, 0xD794, 0xDBBB, 0xDFFB, 0xE451, 0xE8B9, 0xED31, 0xF1B5, 0xF643, 0xFAD8, 0xFF70, 0x0408, 0x089E, 0x0D2E, 0x11B5, 0x1630,
        0x1A9D, 0x1EF7, 0x233D, 0x276A, 0x2B7E, 0x2F73, 0x3349, 0x36FD, 0x3A8B, 0x3DF2, 0x412F, 0x4440, 0x4723, 0x49D6, 0x4C58, 0x4EA6,
        0x50BF, 0x52A1, 0x544C, 0x55BE, 0x56F7, 0x57F5, 0x58B7, 0x593E, 0x5988, 0x5996, 0x5968, 0x58FE, 0x5857, 0x5775, 0x5658, 0x5501,
        0x5371, 0x51A8, 0x4FA9, 0x4D73, 0x4B0A, 0x486E, 0x45A1, 0x42A5, 0x3F7C, 0x3C29, 0x38AD, 0x350A, 0x3144, 0x2D5D, 0x2957, 0x2536,
        0x20FB, 0x1CAA, 0x1846, 0x13D1, 0x0F4F, 0x0AC3, 0x0630, 0x0198, 0xFD00, 0xF869, 0xF3D8, 0xEF4E, 0xEAD0, 0xE660, 0xE201, 0xDDB7,
        0xD984, 0xD56A, 0xD16E, 0xCD90, 0xC9D5, 0xC63E, 0xC2CE, 0xBF88, 0xBC6C, 0xB97F, 0xB6C1, 0xB434, 0xB1DA, 0xAFB5, 0xADC6, 0xAC0F,
        0xAA90, 0xA94A, 0xA83F, 0xA770, 0xA6DB, 0xA683, 0xA668, 0xA688, 0xA6E5, 0xA77E, 0xA853, 0xA963, 0xAAAD, 0xAC30, 0xADEC, 0xAFE0,
        0xB209, 0xB467, 0xB6F8, 0xB9BA, 0xBCAC, 0xBFCA, 0xC314, 0xC688, 0xCA22, 0xCDE0, 0xD1C0, 0xD5BF, 0xD9DA, 0xDE10, 0xE25C, 0xE6BC,
        0xEB2D, 0xEFAD, 0xF437, 0xF8C9, 0xFD60, 0x01F8, 0x068F, 0x0B22, 0x0FAE, 0x142F, 0x18A2, 0x1D05, 0x2154, 0x258D, 0x29AD, 0x2DB0,
        0x3195, 0x3558, 0x38F7, 0x3C70, 0x3FC0, 0x42E5, 0x45DD, 0x48A6, 0x4B3E, 0x4DA3, 0x4FD4, 0x51D0, 0x5394, 0x551F, 0x5672, 0x578A,
        0x5867, 0x5909, 0x596E, 0x5997, 0x5984, 0x5935, 0x58A9, 0x57E2, 0x56DF, 0x55A2, 0x542C, 0x527C, 0x5095, 0x4E78, 0x4C25, 0x49A0,
        0x46E9, 0x4402, 0x40ED, 0x3DAC, 0x3A42, 0x36B1, 0x32FA, 0x2F22, 0x2B29, 0x2714, 0x22E4, 0x1E9D, 0x1A41, 0x15D3, 0x1157, 0x0CCF,
        0x083E, 0x03A8, 0xFF10, 0xFA78, 0xF5E4, 0xF156, 0xECD3, 0xE85C, 0xE3F5, 0xDFA1, 0xDB63, 0xD73E, 0xD334, 0xCF48, 0xCB7D, 0xC7D6,
        0xC454, 0xC0FB, 0xBDCC, 0xBAC9, 0xB7F6, 0xB553, 0xB2E2, 0xB0A5, 0xAE9D, 0xACCD, 0xAB34, 0xA9D5, 0xA8B0, 0xA7C5, 0xA716, 0xA6A3,
        0xA66D, 0xA672, 0xA6B4, 0xA732, 0xA7EC, 0xA8E1, 0xAA11, 0xAB7B, 0xAD1E, 0xAEF9, 0xB10A, 0xB351, 0xB5CB, 0xB877, 0xBB54, 0xBE5E,
        0xC195, 0xC4F6, 0xC87F, 0xCC2D, 0xCFFE, 0xD3F0, 0xD7FF, 0xDC29, 0xE06B, 0xE4C3, 0xE92D, 0xEDA6, 0xF22C, 0xF6BB, 0xFB50, 0xFFE8,
        0x0480, 0x0915, 0x0DA5, 0x122B, 0x16A5, 0x1B0F, 0x1F68, 0x23AB, 0x27D6, 0x2BE6, 0x2FD9, 0x33AC, 0x375B, 0x3AE6, 0x3E48, 0x4181,
        0x448E, 0x476C, 0x4A1A, 0x4C96, 0x4EDF, 0x50F3, 0x52D0, 0x5475, 0x55E1, 0x5713, 0x580B, 0x58C7, 0x5948, 0x598C, 0x5994, 0x5960,
        0x58EF, 0x5843, 0x575B, 0x5638, 0x54DB, 0x5345, 0x5177, 0x4F71, 0x4D37, 0x4AC8, 0x4827, 0x4555, 0x4255, 0x3F27, 0x3BD0, 0x384F,
        0x34A9, 0x30E0, 0x2CF6, 0x28ED, 0x24C8, 0x208B, 0x1C38, 0x17D2, 0x135C, 0x0ED9, 0x0A4C, 0x05B8, 0x0120, 0xFC88, 0xF7F2, 0xF361,
        0xEED8, 0xEA5B, 0xE5ED, 0xE190, 0xDD48, 0xD917, 0xD501, 0xD107, 0xCD2D, 0xC975, 0xC5E2, 0xC277, 0xBF34, 0xBC1E, 0xB935, 0xB67C,
        0xB3F4, 0xB1A0, 0xAF80, 0xAD97, 0xABE5, 0xAA6C, 0xA92C, 0xA827, 0xA75E, 0xA6D0, 0xA67E, 0xA668, 0xA68F, 0xA6F2, 0xA791, 0xA86C,
        0xA982, 0xAAD2, 0xAC5B, 0xAE1D, 0xB016, 0xB245, 0xB4A8, 0xB73E, 0xBA05, 0xBCFB, 0xC01E, 0xC36D, 0xC6E4, 0xCA82, 0xCE43, 0xD227,
        0xD629, 0xDA47, 0xDE7F, 0xE2CD, 0xE72F, 0xEBA2, 0xF023, 0xF4AE, 0xF941, 0xFDD8, 0x0270, 0x0707, 0x0B9A, 0x1024, 0x14A4, 0x1916,
        0x1D77, 0x21C4, 0x25FA, 0x2A17, 0x2E17, 0x31F8, 0x35B8, 0x3953, 0x3CC8, 0x4014, 0x4335, 0x4628, 0x48EC, 0x4B7F, 0x4DDF, 0x500B,
        0x5200, 0x53BF, 0x5545, 0x5691, 0x57A3, 0x587A, 0x5916, 0x5975, 0x5998, 0x597F, 0x5929, 0x5898, 0x57CA, 0x56C2, 0x557F, 0x5402,
        0x524D, 0x5060, 0x4E3D, 0x4BE6, 0x495B, 0x469F, 0x43B3, 0x409A, 0x3D55, 0x39E7, 0x3651, 0x3297, 0x2EBC, 0x2AC0, 0x26A8, 0x2275,
        0x1E2C, 0x19CE, 0x155F, 0x10E1, 0x0C58, 0x07C7, 0x0330, 0xFE98, 0xFA00, 0xF56D, 0xF0E0, 0xEC5E, 0xE7E8, 0xE383, 0xDF32, 0xDAF6,
        0xD6D3, 0xD2CC, 0xCEE4, 0xCB1C, 0xC779, 0xC3FB, 0xC0A6, 0xBD7B, 0xBA7D, 0xB7AF, 0xB510, 0xB2A5, 0xB06D, 0xAE6C, 0xACA1, 0xAB0E,
        0xA9B5, 0xA895, 0xA7B1, 0xA708, 0xA69B, 0xA66A, 0xA676, 0xA6BE, 0xA742, 0xA802, 0xA8FE, 0xAA34, 0xABA3, 0xAD4C, 0xAF2C, 0xB143,
        0xB38F, 0xB60E, 0xB8C0, 0xBBA1, 0xBEB0, 0xC1EC, 0xC551, 0xC8DD, 0xCC8F, 0xD064, 0xD458, 0xD86B, 0xDC97, 0xE0DC, 0xE535, 0xE9A1,
        0xEE1C, 0xF2A3, 0xF732, 0xFBC8, 0x0060, 0x04F8, 0x098D, 0x0E1B, 0x12A0, 0x1719, 0x1B82, 0x1FD8, 0x2419, 0x2841, 0x2C4F, 0x303E,
        0x340E, 0x37BA, 0x3B40, 0x3E9E, 0x41D3, 0x44DB, 0x47B4, 0x4A5D, 0x4CD5, 0x4F18, 0x5126, 0x52FD, 0x549D, 0x5603, 0x572F, 0x5821,
        0x58D7, 0x5952, 0x5990, 0x5992, 0x5957, 0x58E1, 0x582E, 0x5740, 0x5617, 0x54B4, 0x5318, 0x5144, 0x4F3A, 0x4CF9, 0x4A86, 0x47DF,
        0x4509, 0x4204, 0x3ED2, 0x3B76, 0x37F2, 0x3448, 0x307B, 0x2C8D, 0x2882, 0x245B, 0x201B, 0x1BC6, 0x175E, 0x12E7, 0x0E62, 0x09D4,
        0x0540, 0x00A8, 0xFC10, 0xF77A, 0xF2EA, 0xEE62, 0xE9E7, 0xE57A, 0xE11F, 0xDCDA, 0xD8AB, 0xD497, 0xD0A1, 0xCCCA, 0xC916, 0xC587,
        0xC220, 0xBEE2, 0xBBD0, 0xB8EB, 0xB637, 0xB3B5, 0xB166, 0xAF4C, 0xAD68, 0xABBC, 0xAA48, 0xA90F, 0xA810, 0xA74C, 0xA6C5, 0xA679,
        0xA669, 0xA696, 0xA700, 0xA7A5, 0xA886, 0xA9A1, 0xAAF7, 0xAC86, 0xAE4E, 0xB04C, 0xB281, 0xB4E9, 0xB784, 0xBA50, 0xBD4B, 0xC073,
        0xC3C5, 0xC741, 0xCAE2, 0xCEA7, 0xD28E, 0xD693, 0xDAB4, 0xDEEF, 0xE33F, 0xE7A3, 0xEC17, 0xF099, 0xF525, 0xF9B9, 0xFE50, 0x02E8,
        0x077F, 0x0C11, 0x109A, 0x1519, 0x1989, 0x1DE8, 0x2233, 0x2667, 0x2A81, 0x2E7E, 0x325C, 0x3618, 0x39B0, 0x3D20, 0x4068, 0x4384,
        0x4673, 0x4932, 0x4BBF, 0x4E1A, 0x5040, 0x5230, 0x53E9, 0x5569, 0x56B0, 0x57BC, 0x588D, 0x5922, 0x597B, 0x5998, 0x5979, 0x591D,
        0x5885, 0x57B2, 0x56A4, 0x555B, 0x53D8, 0x521D, 0x502B, 0x4E03, 0x4BA6, 0x4916, 0x4655, 0x4364, 0x4046, 0x3CFD, 0x398B, 0x35F2,
        0x3234, 0x2E55, 0x2A56, 0x263B, 0x2206, 0x1DBB, 0x195B, 0x14EA, 0x106B, 0x0BE1, 0x074F, 0x02B8, 0xFE20, 0xF989, 0xF4F5, 0xF06A,
        0xEBE8, 0xE775, 0xE312, 0xDEC2, 0xDA89, 0xD669, 0xD265, 0xCE7F, 0xCABC, 0xC71C, 0xC3A2, 0xC051, 0xBD2B, 0xBA32, 0xB768, 0xB4CF,
        0xB269, 0xB036, 0xAE3A, 0xAC75, 0xAAE8, 0xA995, 0xA87B, 0xA79D, 0xA6FA, 0xA693, 0xA669, 0xA67B, 0xA6C9, 0xA753, 0xA819, 0xA91B,
        0xAA57, 0xABCC, 0xAD7A, 0xAF60, 0xB17D, 0xB3CE, 0xB653, 0xB909, 0xBBEF, 0xBF03, 0xC242, 0xC5AC, 0xC93C, 0xCCF2, 0xD0CA, 0xD4C2,
        0xD8D6, 0xDD06, 0xE14D, 0xE5A8, 0xEA15, 0xEE92, 0xF319, 0xF7AA, 0xFC40, 0x00D8, 0x0570, 0x0A04, 0x0E92, 0x1316, 0x178D, 0x1BF4,
        0x2048, 0x2487, 0x28AD, 0x2CB7, 0x30A4, 0x346F, 0x3817, 0x3B9A, 0x3EF4, 0x4224, 0x4527, 0x47FC, 0x4AA0, 0x4D12, 0x4F50, 0x5158,
        0x532A, 0x54C4, 0x5624, 0x574B, 0x5836, 0x58E7, 0x595B, 0x5993, 0x598F, 0x594E, 0x58D1, 0x5818, 0x5724, 0x55F5, 0x548D, 0x52EB,
        0x5111, 0x4F01, 0x4CBC, 0x4A43, 0x4797, 0x44BC, 0x41B2, 0x3E7C, 0x3B1C, 0x3794, 0x33E6, 0x3016, 0x2C25, 0x2817, 0x23ED, 0x1FAB,
        0x1B54, 0x16EA, 0x1271, 0x0DEC, 0x095D, 0x04C8, 0x0030, 0xFB98, 0xF703, 0xF273, 0xEDED, 0xE973, 0xE508, 0xE0AF, 0xDC6B, 0xD83F,
        0xD42F, 0xD03B, 0xCC68, 0xC8B8, 0xC52C, 0xC1C9, 0xBE8F, 0xBB82, 0xB8A3, 0xB5F3, 0xB376, 0xB12C, 0xAF18, 0xAD3A, 0xAB93, 0xAA26,
        0xA8F2, 0xA7F9, 0xA73C, 0xA6BA, 0xA674, 0xA66B, 0xA69E, 0xA70E, 0xA7B9, 0xA8A0, 0xA9C2, 0xAB1D, 0xACB2, 0xAE7F, 0xB084, 0xB2BD,
        0xB52B, 0xB7CB, 0xBA9C, 0xBD9B, 0xC0C8, 0xC41F, 0xC79E, 0xCB43, 0xCF0C, 0xD2F6, 0xD6FE, 0xDB22, 0xDF5E, 0xE3B1, 0xE817, 0xEC8C,
        0xF10F, 0xF59C, 0xFA30, 0xFEC8, 0x0360, 0x07F6, 0x0C88, 0x1110, 0x158D, 0x19FC, 0x1E59, 0x22A2, 0x26D3, 0x2AEA, 0x2EE4, 0x32BF,
        0x3678, 0x3A0B, 0x3D78, 0x40BB, 0x43D3, 0x46BC, 0x4977, 0x4BFF, 0x4E55, 0x5075, 0x5260, 0x5413, 0x558D, 0x56CE, 0x57D4, 0x589F,
        0x592E, 0x5981, 0x5998, 0x5972, 0x5911, 0x5873, 0x5799, 0x5685, 0x5536, 0x53AE, 0x51ED, 0x4FF5, 0x4DC7, 0x4B65, 0x48D0, 0x460A,
        0x4315, 0x3FF2, 0x3CA5, 0x392F, 0x3592, 0x31D1, 0x2DEE, 0x29EC, 0x25CF, 0x2197, 0x1D49, 0x18E8, 0x1475, 0x0FF5, 0x0B6A, 0x06D7,
        0x0240, 0xFDA8, 0xF911, 0xF47E, 0xEFF3, 0xEB73, 0xE701, 0xE2A0, 0xDE53, 0xDA1C, 0xD5FE, 0xD1FD, 0xCE1B, 0xCA5B, 0xC6BF, 0xC349,
        0xBFFD, 0xBCDB, 0xB9E7, 0xB722, 0xB48E, 0xB22D, 0xB000, 0xAE09, 0xAC4A, 0xAAC3, 0xA975, 0xA862, 0xA78A, 0xA6ED, 0xA68C, 0xA668,
        0xA680, 0xA6D4, 0xA765, 0xA831, 0xA938, 0xAA7A, 0xABF5, 0xADAA, 0xAF95, 0xB1B7, 0xB40D, 0xB697, 0xB952, 0xBC3D, 0xBF56, 0xC29A,
        0xC607, 0xC99C, 0xCD55, 0xD130, 0xD52B, 0xD943, 0xDD74, 0xE1BE, 0xE61B, 0xEA8A, 0xEF07, 0xF390, 0xF821, 0xFCB8, 0x0150, 0x05E8,
        0x0A7C, 0x0F08, 0x138B, 0x1801, 0x1C66, 0x20B8, 0x24F4, 0x2917, 0x2D1F, 0x3108, 0x34D0, 0x3875, 0x3BF3, 0x3F49, 0x4275, 0x4573,
        0x4843, 0x4AE2, 0x4D4F, 0x4F88, 0x518B, 0x5357, 0x54EA, 0x5645, 0x5765, 0x584B, 0x58F5, 0x5963, 0x5995, 0x598B, 0x5944, 0x58C1,
        0x5802, 0x56C2, 0x554A, 0x539A, 0x51B4, 0x4F9B, 0x4D4F, 0x4AD2, 0x4827, 0x454F, 0x424D, 0x3F23, 0x3BD4, 0x3861, 0x34CE, 0x311E,
        0x2D52, 0x296E, 0x2574, 0x2168, 0x1D4B, 0x1922, 0x14EF, 0x10B4, 0x0C76, 0x0836, 0x03F7, 0xFFBE, 0xFB8C, 0xF764, 0xF348, 0xEF3C,
        0xEB43, 0xE75E, 0xE390, 0xDFDD, 0xDC45, 0xD8CC, 0xD574, 0xD23E, 0xCF2C, 0xCC41, 0xC97E, 0xC6E5, 0xC477, 0xC235, 0xC022, 0xBE3D,
        0xBC88, 0xBB04, 0xB9B1, 0xB890, 0xB7A1, 0xB6E5, 0xB65C, 0xB606, 0xB5E2, 0xB5F1, 0xB632, 0xB6A4, 0xB747, 0xB81B, 0xB91D, 0xBA4D,
        0xBBAB, 0xBD34, 0xBEE8, 0xC0C4, 0xC2C8, 0xC4F2, 0xC740, 0xC9AF, 0xCC3F, 0xCEED, 0xD1B8, 0xD49C, 0xD798, 0xDAAA, 0xDDD0, 0xE106,
        0xE44C, 0xE79E, 0xEAFA, 0xEE5E, 0xF1C7, 0xF533, 0xF8A0, 0xFC0C, 0xFF73, 0x02D3, 0x062B, 0x0979, 0x0CBA, 0x0FEB, 0x130C, 0x1619,
        0x1912, 0x1BF3, 0x1EBC, 0x216A, 0x23FD, 0x2671, 0x28C7, 0x2AFC, 0x2D10, 0x2F01, 0x30CE, 0x3276, 0x33F9, 0x3555, 0x368A, 0x3798,
        0x387E, 0x393B, 0x39D1, 0x3A3E, 0x3A82, 0x3A9E, 0x3A93, 0x3A5F, 0x3A05, 0x3983, 0x38DC, 0x3810, 0x371F, 0x360B, 0x34D5, 0x337D,
        0x3205, 0x306F, 0x2EBB, 0x2CEB, 0x2B01, 0x28FE, 0x26E3, 0x24B2, 0x226E, 0x2017, 0x1DB0, 0x1B3A, 0x18B6, 0x1628, 0x1391, 0x10F2,
        0x0E4D, 0x0BA5, 0x08FB, 0x0651, 0x03A9, 0x0104, 0xFE66, 0xFBCF, 0xF940, 0xF6BB, 0xF443, 0xF1D8, 0xEF7D, 0xED33, 0xEAFB, 0xE8D7,
        0xE6C7, 0xE4CD, 0xE2EB, 0xE121, 0xDF71, 0xDDDA, 0xDC5F, 0xDB00, 0xD9BD, 0xD897, 0xD78F, 0xD6A5, 0xD5D9, 0xD52C, 0xD49E, 0xD42F,
        0xD3DF, 0xD3AE, 0xD39B, 0xD3A7, 0xD3D1, 0xD418, 0xD47D, 0xD4FE, 0xD59B, 0xD654, 0xD727, 0xD814, 0xD91A, 0xDA37, 0xDB6C, 0xDCB6,
        0xDE14, 0xDF87, 0xE10B, 0xE2A1, 0xE446, 0xE5FA, 0xE7BB, 0xE987, 0xEB5F, 0xED3F, 0xEF27, 0xF115, 0xF308, 0xF4FE, 0xF6F7, 0xF8F0,
        0xFAE8, 0xFCDE, 0xFED1, 0x00BE, 0x02A7, 0x0488, 0x0660, 0x082F, 0x09F3, 0x0BAB, 0x0D56, 0x0EF3, 0x1081, 0x11FF, 0x136C, 0x14C8,
        0x1612, 0x1748, 0x186B, 0x197A, 0x1A74, 0x1B5A, 0x1C29, 0x1CE3, 0x1D87, 0x1E15, 0x1E8C, 0x1EED, 0x1F37, 0x1F6B, 0x1F89, 0x1F91,
        0x1F84, 0x1F60, 0x1F28, 0x1EDB, 0x1E7A, 0x1E05, 0x1D7D, 0x1CE2, 0x1C35, 0x1B78, 0x1AAA, 0x19CC, 0x18DF, 0x17E5, 0x16DD, 0x15C9,
        0x14AA, 0x1380, 0x124D, 0x1111, 0x0FCE, 0x0E85, 0x0D36, 0x0BE2, 0x0A8B, 0x0931, 0x07D6, 0x067A, 0x051F, 0x03C5, 0x026E, 0x0119,
        0xFFCA, 0xFE7F, 0xFD39, 0xFBFA, 0xFAC3, 0xF994, 0xF86D, 0xF751, 0xF63E, 0xF537, 0xF43B, 0xF34B, 0xF267, 0xF190, 0xF0C7, 0xF00B,
        0xEF5D, 0xEEBE, 0xEE2D, 0xEDAA, 0xED37, 0xECD2, 0xEC7C, 0xEC36, 0xEBFE, 0xEBD5, 0xEBBB, 0xEBAF, 0xEBB2, 0xEBC3, 0xEBE2, 0xEC0E,
        0xEC47, 0xEC8E, 0xECE0, 0xED3F, 0xEDA9, 0xEE1E, 0xEE9E, 0xEF28, 0xEFBB, 0xF056, 0xF0FA, 0xF1A6, 0xF258, 0xF311, 0xF3D0, 0xF494,
        0xF55C, 0xF628, 0xF6F7, 0xF7C8, 0xF89B, 0xF970, 0xFA45, 0xFB1A, 0xFBEE, 0xFCC1, 0xFD92, 0xFE61, 0xFF2C, 0xFFF4, 0x00B7, 0x0177,
        0x0232, 0x02E7, 0x0396, 0x043F, 0x04E1, 0x057D, 0x0611, 0x069D, 0x0722, 0x079F, 0x0813, 0x0880, 0x08E3, 0x093E, 0x0990, 0x09D9,
        0x0A1A, 0x0A51, 0x0A80, 0x0AA6, 0x0AC4, 0x0AD9, 0x0AE5, 0x0AE9, 0x0AE5, 0x0ADA, 0x0AC6, 0x0AAB, 0x0A89, 0x0A60, 0x0A31, 0x09FB,
        0x09BF, 0x097E, 0x0937, 0x08EC, 0x089B, 0x0847, 0x07EF, 0x0793, 0x0734, 0x06D3, 0x066F, 0x0609, 0x05A2, 0x0539, 0x04D0, 0x0466,
        0x03FC, 0x0392, 0x0329, 0x02C1, 0x025A, 0x01F4, 0x0190, 0x012F, 0x00CF, 0x0073, 0x0019, 0xFFC3, 0xFF6F, 0xFF1F, 0xFED2, 0xFE89,
        0xFE44, 0xFE03, 0xFDC6, 0xFD8E, 0xFD59, 0xFD29, 0xFCFD, 0xFCD5, 0xFCB2, 0xFC92, 0xFC77, 0xFC61, 0xFC4E, 0xFC3F, 0xFC35, 0xFC2E,
        0xFC2B, 0xFC2B, 0xFC2F, 0xFC36, 0xFC40, 0xFC4D, 0xFC5D, 0xFC70, 0xFC85, 0xFC9C, 0xFCB6, 0xFCD1, 0xFCEE, 0xFD0C, 0xFD2C, 0xFD4C,
        0xFD6E, 0xFD90, 0xFDB3, 0xFDD6, 0xFDF9, 0xFE1C, 0xFE3F, 0xFE62, 0xFE84, 0xFEA5, 0xFEC6, 0xFEE6, 0xFF04, 0xFF22, 0xFF3E, 0xFF59,
        0xFF73, 0xFF8B, 0xFFA1, 0xFFB6, 0xFFCA, 0xFFDB, 0xFFEB, 0xFFFA, 0x0006, 0x0011, 0x001A, 0x0022, 0x0029, 0x002E, 0x0032, 0x0034,
        0x0035, 0x0035, 0x0034, 0x0032, 0x002F, 0x002C, 0x0027, 0x0023, 0x001E, 0x0019, 0x0013, 0x000E, 0x0009, 0x0005, 0x0002, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0006, 0x0008, 0x0009, 0x000B, 0x000D, 0x000F, 0x0012, 0x0014,
        0x0016, 0x0018, 0x001A, 0x001C, 0x001E, 0x001F, 0x0021, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0021, 0x0020, 0x001E, 0x001B,
        0x0018, 0x0014, 0x0010, 0x000A, 0x0004, 0xFFFF, 0xFFF7, 0xFFEF, 0xFFE6, 0xFFDC, 0xFFD1, 0xFFC6, 0xFFBA, 0xFFAD, 0xFFA0, 0xFF91,
        0xFF83, 0xFF73, 0xFF63, 0xFF53, 0xFF42, 0xFF30, 0xFF1F, 0xFF0D, 0xFEFB, 0xFEE8, 0xFED6, 0xFEC4, 0xFEB2, 0xFEA0, 0xFE8F, 0xFE7E,
        0xFE6D, 0xFE5D, 0xFE4E, 0xFE40, 0xFE33, 0xFE26, 0xFE1B, 0xFE11, 0xFE09, 0xFE02, 0xFDFD, 0xFDF9, 0xFDF7, 0xFDF7, 0xFDF9, 0xFDFD,
        0xFE03, 0xFE0B, 0xFE16, 0xFE22, 0xFE31, 0xFE43, 0xFE57, 0xFE6D, 0xFE86, 0xFEA1, 0xFEBF, 0xFEDF, 0xFF02, 0xFF27, 0xFF4E, 0xFF78,
        0xFFA4, 0xFFD2, 0x0002, 0x0034, 0x0068, 0x009E, 0x00D6, 0x010F, 0x0149, 0x0185, 0x01C2, 0x0200, 0x023E, 0x027D, 0x02BC, 0x02FC,
        0x033B, 0x037A, 0x03B8, 0x03F6, 0x0432, 0x046E, 0x04A8, 0x04E0, 0x0516, 0x054A, 0x057C, 0x05AB, 0x05D7, 0x05FF, 0x0625, 0x0647,
        0x0665, 0x067F, 0x0694, 0x06A6, 0x06B2, 0x06BA, 0x06BD, 0x06BB, 0x06B4, 0x06A7, 0x0695, 0x067D, 0x0660, 0x063C, 0x0613, 0x05E5,
        0x05B0, 0x0576, 0x0536, 0x04F0, 0x04A4, 0x0453, 0x03FD, 0x03A1, 0x0340, 0x02DA, 0x026F, 0x01FF, 0x018B, 0x0113, 0x0097, 0x0017,
        0xFF95, 0xFF0F, 0xFE87, 0xFDFC, 0xFD6F, 0xFCE0, 0xFC51, 0xFBC0, 0xFB2F, 0xFA9E, 0xFA0E, 0xF97F, 0xF8F1, 0xF865, 0xF7DB, 0xF754,
        0xF6D0, 0xF650, 0xF5D4, 0xF55C, 0xF4EA, 0xF47D, 0xF417, 0xF3B6, 0xF35D, 0xF30A, 0xF2BF, 0xF27D, 0xF242, 0xF210, 0xF1E8, 0xF1C9,
        0xF1B3, 0xF1A7, 0xF1A5, 0xF1AE, 0xF1C1, 0xF1DF, 0xF208, 0xF23B, 0xF279, 0xF2C3, 0xF317, 0xF377, 0xF3E1, 0xF456, 0xF4D6, 0xF560,
        0xF5F5, 0xF694, 0xF73C, 0xF7EE, 0xF8AA, 0xF96E, 0xFA3A, 0xFB0F, 0xFBEA, 0xFCCD, 0xFDB7, 0xFEA6, 0xFF9B, 0x0094, 0x0191, 0x0293,
        0x0397, 0x049D, 0x05A5, 0x06AD, 0x07B5, 0x08BD, 0x09C3, 0x0AC6, 0x0BC7, 0x0CC3, 0x0DBB, 0x0EAE, 0x0F9A, 0x107F, 0x115D, 0x1232,
        0x12FD, 0x13BF, 0x1476, 0x1522, 0x15C1, 0x1654, 0x16DA, 0x1751, 0x17BA, 0x1814, 0x185F, 0x189A, 0x18C4, 0x18DD, 0x18E6, 0x18DD,
        0x18C2, 0x1896, 0x1858, 0x1807, 0x17A5, 0x1730, 0x16A9, 0x1610, 0x1566, 0x14AA, 0x13DC, 0x12FE, 0x120E, 0x110F, 0x1000, 0x0EE1,
        0x0DB4, 0x0C79, 0x0B30, 0x09DB, 0x087A, 0x070E, 0x0597, 0x0418, 0x028F, 0x0100, 0xFF6B, 0xFDCF, 0xFC2F, 0xFA8C, 0xF8E7, 0xF741,
        0xF59B, 0xF3F7, 0xF255, 0xF0B6, 0xEF1D, 0xED8A, 0xEBFE, 0xEA7A, 0xE900, 0xE792, 0xE62F, 0xE4D9, 0xE392, 0xE25A, 0xE132, 0xE01C,
        0xDF18, 0xDE28, 0xDD4C, 0xDC86, 0xDBD5, 0xDB3B, 0xDAB9, 0xDA4F, 0xD9FE, 0xD9C6, 0xD9A8, 0xD9A4, 0xD9BB, 0xD9EC, 0xDA39, 0xDAA1,
        0xDB24, 0xDBC2, 0xDC7B, 0xDD4F, 0xDE3E, 0xDF47, 0xE06B, 0xE1A7, 0xE2FD, 0xE46B, 0xE5F0, 0xE78C, 0xE93E, 0xEB06, 0xECE1, 0xEECF,
        0xF0CF, 0xF2DF, 0xF4FF, 0xF72E, 0xF968, 0xFBAE, 0xFDFE, 0x0056, 0x02B5, 0x0519, 0x0781, 0x09EB, 0x0C55, 0x0EBE, 0x1124, 0x1385,
        0x15E0, 0x1832, 0x1A7A, 0x1CB7, 0x1EE7, 0x2107, 0x2317, 0x2515, 0x26FE, 0x28D2, 0x2A90, 0x2C35, 0x2DC0, 0x2F30, 0x3083, 0x31B9,
        0x32D0, 0x33C7, 0x349D, 0x3551, 0x35E2, 0x3650, 0x369A, 0x36BE, 0x36BE, 0x3697, 0x364B, 0x35D9, 0x3540, 0x3481, 0x339C, 0x3291,
        0x3160, 0x300A, 0x2E90, 0x2CF2, 0x2B30, 0x294C, 0x2747, 0x2521, 0x22DC, 0x207A, 0x1DFA, 0x1B60, 0x18AC, 0x15E0, 0x12FD, 0x1007,
        0x0CFD, 0x09E3, 0x06BA, 0x0384, 0x0044, 0xFCFC, 0xF9AD, 0xF65A, 0xF305, 0xEFB1, 0xEC5F, 0xE913, 0xE5CE, 0xE293, 0xDF64, 0xDC43,
        0xD934, 0xD637, 0xD350, 0xD080, 0xCDCA, 0xCB2F, 0xC8B3, 0xC656, 0xC41B, 0xC204, 0xC012, 0xBE47, 0xBCA6, 0xBB2E, 0xB9E2, 0xB8C3,
        0xB7D2, 0xB710, 0xB67F, 0xB61E, 0xB5F0, 0xB5F3, 0xB629, 0xB693, 0xB730, 0xB800, 0xB903, 0xBA39, 0xBBA2, 0xBD3C, 0xBF09, 0xC106,
        0xC332, 0xC58D, 0xC816, 0xCACB, 0xCDAA, 0xD0B2, 0xD3E2, 0xD737, 0xDAAF, 0xDE49, 0xE202, 0xE5D8, 0xE9C8, 0xEDD0, 0xF1EE, 0xF61F,
        0xFA5F, 0xFEAD, 0x0304, 0x0764, 0x0BC8, 0x102E, 0x1493, 0x18F3, 0x1D4C, 0x219A, 0x25DA, 0x2A0A, 0x2E26, 0x322C, 0x3617, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2F22, 0x32FA, 0x36B1, 0x3A42, 0x3DAC, 0x40ED, 0x4402, 0x46E9, 0x49A0, 0x4C25, 0x4E78, 0x5095, 0x527C, 0x542C, 0x55A2,
        0x56DF, 0x57E2, 0x58A9, 0x5935, 0x5984, 0x5997, 0x596E, 0x5909, 0x5867, 0x578A, 0x5672, 0x551F, 0x5394, 0x51D0, 0x4FD4, 0x4DA3,
        0x4B3E, 0x48A6, 0x45DD, 0x42E5, 0x3FC0, 0x3C70, 0x38F7, 0x3558, 0x3195, 0x2DB0, 0x29AD, 0x258D, 0x2154, 0x1D05, 0x18A2, 0x142F,
        0x0FAE, 0x0B22, 0x068F, 0x01F8, 0xFD60, 0xF8C9, 0xF437, 0xEFAD, 0xEB2D, 0xE6BC, 0xE25C, 0xDE10, 0xD9DA, 0xD5BF, 0xD1C0, 0xCDE0,
        0xCA22, 0xC688, 0xC314, 0xBFCA, 0xBCAC, 0xB9BA, 0xB6F8, 0xB467, 0xB209, 0xAFE0, 0xADEC, 0xAC30, 0xAAAD, 0xA963, 0xA853, 0xA77E,
        0xA6E5, 0xA688, 0xA668, 0xA683, 0xA6DB, 0xA770, 0xA83F, 0xA94A, 0xAA90, 0xAC0F, 0xADC6, 0xAFB5, 0xB1DA, 0xB434, 0xB6C1, 0xB97F,
        0xBC6C, 0xBF88, 0xC2CE, 0xC63E, 0xC9D5, 0xCD90, 0xD16E, 0xD56A, 0xD984, 0xDDB7, 0xE201, 0xE660, 0xEAD0, 0xEF4E, 0xF3D8, 0xF869,
        0xFD00, 0x0198, 0x0630, 0x0AC3, 0x0F4F, 0x13D1, 0x1846, 0x1CAA, 0x20FB, 0x2536, 0x2957, 0x2D5D, 0x3144, 0x350A, 0x38AD, 0x3C29,
        0x3F7C, 0x42A5, 0x45A1, 0x486E, 0x4B0A, 0x4D73, 0x4FA9, 0x51A8, 0x5371, 0x5501, 0x5658, 0x5775, 0x5857, 0x58FE, 0x5968, 0x5996,
        0x5988, 0x593E, 0x58B7, 0x57F5, 0x56F7, 0x55BE, 0x544C, 0x52A1, 0x50BF, 0x4EA6, 0x4C58, 0x49D6, 0x4723, 0x4440, 0x412F, 0x3DF2,
        0x3A8B, 0x36FD, 0x3349, 0x2F73, 0x2B7E, 0x276A, 0x233D, 0x1EF7, 0x1A9D, 0x1630, 0x11B5, 0x0D2E, 0x089E, 0x0408, 0xFF70, 0xFAD8,
        0xF643, 0xF1B5, 0xED31, 0xE8B9, 0xE451, 0xDFFB, 0xDBBB, 0xD794, 0xD387, 0xCF99, 0xCBCB, 0xC821, 0xC49C, 0xC13F, 0xBE0D, 0xBB07,
        0xB82F, 0xB588, 0xB313, 0xB0D2, 0xAEC6, 0xACF1, 0xAB54, 0xA9F0, 0xA8C6, 0xA7D6, 0xA723, 0xA6AB, 0xA66F, 0xA66F, 0xA6AC, 0xA726,
        0xA7DB, 0xA8CB, 0xA9F6, 0xAB5C, 0xACFA, 0xAED0, 0xB0DD, 0xB31F, 0xB595, 0xB83D, 0xBB16, 0xBE1D, 0xC150, 0xC4AE, 0xC834, 0xCBDF,
        0xCFAD, 0xD39C, 0xD7A9, 0xDBD1, 0xE012, 0xE467, 0xE8D0, 0xED48, 0xF1CD, 0xF65B, 0xFAF0, 0xFF88, 0x0420, 0x08B6, 0x0D46, 0x11CD,
        0x1648, 0x1AB4, 0x1F0E, 0x2353, 0x2780, 0x2B93, 0x2F88, 0x335D, 0x3710, 0x3A9D, 0x3E03, 0x413F, 0x4450, 0x4732, 0x49E4, 0x4C64,
        0x4EB1, 0x50C9, 0x52AB, 0x5455, 0x55C5, 0x56FD, 0x57F9, 0x58BA, 0x5940, 0x5989, 0x5996, 0x5967, 0x58FB, 0x5853, 0x5770, 0x5652,
        0x54FA, 0x5368, 0x519E, 0x4F9E, 0x4D67, 0x4AFD, 0x4860, 0x4592, 0x4295, 0x3F6B, 0x3C17, 0x389A, 0x34F7, 0x3130, 0x2D49, 0x2942,
        0x2520, 0x20E5, 0x1C93, 0x182F, 0x13BA, 0x0F38, 0x0AAB, 0x0618, 0x0180, 0xFCE8, 0xF851, 0xF3C0, 0xEF37, 0xEAB9, 0xE649, 0xE1EB,
        0xDDA1, 0xD96E, 0xD555, 0xD159, 0xCD7C, 0xC9C2, 0xC62C, 0xC2BD, 0xBF77, 0xBC5D, 0xB970, 0xB6B3, 0xB427, 0xB1CE, 0xAFAA, 0xADBD,
        0xAC06, 0xAA88, 0xA944, 0xA83A, 0xA76C, 0xA6D9, 0xA682, 0xA668, 0xA68A, 0xA6E8, 0xA782, 0xA858, 0xA969, 0xAAB4, 0xAC39, 0xADF6,
        0xAFEB, 0xB215, 0xB474, 0xB706, 0xB9C9, 0xBCBB, 0xBFDB, 0xC326, 0xC69A, 0xCA35, 0xCDF4, 0xD1D4, 0xD5D4, 0xD9F0, 0xDE26, 0xE273,
        0xE6D3, 0xEB45, 0xEFC4, 0xF44F, 0xF8E1, 0xFD78, 0x0210, 0x06A7, 0x0B3A, 0x0FC6, 0x1446, 0x18B9, 0x1D1C, 0x216B, 0x25A3, 0x29C2,
        0x2DC5, 0x31A9, 0x356B, 0x390A, 0x3C82, 0x3FD1, 0x42F5, 0x45EC, 0x48B4, 0x4B4B, 0x4DAF, 0x4FDF, 0x51D9, 0x539C, 0x5527, 0x5678,
        0x578F, 0x586B, 0x590B, 0x5970, 0x5998, 0x5983, 0x5933, 0x58A6, 0x57DD, 0x56DA, 0x559B, 0x5423, 0x5273, 0x508B, 0x4E6C, 0x4C19,
        0x4992, 0x46DA, 0x43F2, 0x40DC, 0x3D9B, 0x3A30, 0x369E, 0x32E7, 0x2F0D, 0x2B14, 0x26FE, 0x22CE, 0x1E86, 0x1A2A, 0x15BC, 0x113F,
        0x0CB7, 0x0826, 0x0390, 0xFEF8, 0xFA60, 0xF5CC, 0xF13F, 0xECBB, 0xE845, 0xE3DE, 0xDF8B, 0xDB4D, 0xD729, 0xD31F, 0xCF34, 0xCB6A,
        0xC7C3, 0xC442, 0xC0EA, 0xBDBC, 0xBABA, 0xB7E7, 0xB545, 0xB2D6, 0xB09A, 0xAE93, 0xACC4, 0xAB2D, 0xA9CF, 0xA8AA, 0xA7C1, 0xA714,
        0xA6A2, 0xA66C, 0xA673, 0xA6B6, 0xA735, 0xA7F0, 0xA8E7, 0xAA18, 0xAB83, 0xAD27, 0xAF03, 0xB115, 0xB35D, 0xB5D8, 0xB886, 0xBB63,
        0xBE6F, 0xC1A6, 0xC508, 0xC892, 0xCC41, 0xD013, 0xD405, 0xD814, 0xDC3F, 0xE082, 0xE4DA, 0xE944, 0xEDBE, 0xF244, 0xF6D3, 0xFB68,
        0x0000, 0x0498, 0x092D, 0x0DBC, 0x1242, 0x16BC, 0x1B26, 0x1F7E, 0x23C1, 0x27EC, 0x2BFB, 0x2FED, 0x33BF, 0x376E, 0x3AF8, 0x3E5A,
        0x4191, 0x449D, 0x477A, 0x4A28, 0x4CA3, 0x4EEB, 0x50FD, 0x52D9, 0x547D, 0x55E8, 0x5719, 0x5810, 0x58CB, 0x594A, 0x598D, 0x5994,
        0x595E, 0x58EC, 0x583F, 0x5756, 0x5631, 0x54D3, 0x533C, 0x516D, 0x4F66, 0x4D2A, 0x4ABB, 0x4819, 0x4546, 0x4244, 0x3F16, 0x3BBE,
        0x383D, 0x3496, 0x30CC, 0x2CE1, 0x28D7, 0x24B3, 0x2075, 0x1C22, 0x17BB, 0x1345, 0x0EC1, 0x0A34, 0x05A0, 0x0108, 0xFC70, 0xF7DA,
        0xF349, 0xEEC1, 0xEA44, 0xE5D6, 0xE17A, 0xDD32, 0xD902, 0xD4EC, 0xD0F3, 0xCD19, 0xC962, 0xC5D0, 0xC265, 0xBF24, 0xBC0E, 0xB926,
        0xB66E, 0xB3E7, 0xB194, 0xAF75, 0xAD8D, 0xABDD, 0xAA65, 0xA926, 0xA823, 0xA75A, 0xA6CD, 0xA67D, 0xA668, 0xA690, 0xA6F5, 0xA795,
        0xA871, 0xA988, 0xAAD9, 0xAC64, 0xAE27, 0xB021, 0xB251, 0xB4B5, 0xB74C, 0xBA14, 0xBD0B, 0xC02F, 0xC37E, 0xC6F6, 0xCA95, 0xCE57,
        0xD23B, 0xD63E, 0xDA5D, 0xDE95, 0xE2E4, 0xE747, 0xEBBA, 0xF03A, 0xF4C6, 0xF959, 0xFDF0, 0x0288, 0x071F, 0x0BB1, 0x103C, 0x14BB,
        0x192D, 0x1D8D, 0x21DA, 0x2610, 0x2A2C, 0x2E2C, 0x320C, 0x35CB, 0x3966, 0x3CDA, 0x4025, 0x4345, 0x4637, 0x48FA, 0x4B8C, 0x4DEB,
        0x5015, 0x520A, 0x53C7, 0x554C, 0x5697, 0x57A8, 0x587E, 0x5918, 0x5976, 0x5998, 0x597E, 0x5927, 0x5894, 0x57C6, 0x56BC, 0x5578,
        0x53FA, 0x5243, 0x5056, 0x4E32, 0x4BD9, 0x494D, 0x4690, 0x43A3, 0x4089, 0x3D43, 0x39D4, 0x363E, 0x3284, 0x2EA7, 0x2AAB, 0x2692,
        0x225F, 0x1E15, 0x19B7, 0x1547, 0x10C9, 0x0C40, 0x07AF, 0x0318, 0xFE80, 0xF9E8, 0xF555, 0xF0C8, 0xEC46, 0xE7D1, 0xE36D, 0xDF1B,
        0xDAE0, 0xD6BE, 0xD2B7, 0xCED0, 0xCB09, 0xC766, 0xC3E9, 0xC095, 0xBD6B, 0xBA6E, 0xB7A0, 0xB503, 0xB299, 0xB062, 0xAE62, 0xAC98,
        0xAB06, 0xA9AE, 0xA890, 0xA7AD, 0xA705, 0xA699, 0xA66A, 0xA677, 0xA6C0, 0xA746, 0xA807, 0xA903, 0xAA3B, 0xABAB, 0xAD55, 0xAF37,
        0xB14F, 0xB39C, 0xB61C, 0xB8CE, 0xBBB0, 0xBEC1, 0xC1FD, 0xC563, 0xC8F0, 0xCCA3, 0xD078, 0xD46D, 0xD880, 0xDCAD, 0xE0F2, 0xE54C,
        0xE9B8, 0xEE33, 0xF2BA, 0xF74A, 0xFBE0, 0x0078, 0x0510, 0x09A5, 0x0E33, 0x12B8, 0x1730, 0x1B99, 0x1FEE, 0x242F, 0x2857, 0x2C64,
        0x3053, 0x3421, 0x37CC, 0x3B52, 0x3EB0, 0x41E3, 0x44EA, 0x47C3, 0x4A6B, 0x4CE1, 0x4F23, 0x5130, 0x5306, 0x54A4, 0x560A, 0x5735,
        0x5825, 0x58DA, 0x5954, 0x5991, 0x5991, 0x5955, 0x58DD, 0x582A, 0x573A, 0x5610, 0x54AC, 0x530F, 0x513A, 0x4F2E, 0x4CED, 0x4A78,
        0x47D1, 0x44F9, 0x41F3, 0x3EC1, 0x3B64, 0x37DF, 0x3435, 0x3067, 0x2C79, 0x286C, 0x2445, 0x2005, 0x1BAF, 0x1747, 0x12CF, 0x0E4B,
        0x09BD, 0x0528, 0x0090, 0xFBF8, 0xF762, 0xF2D2, 0xEE4B, 0xE9D0, 0xE563, 0xE109, 0xDCC3, 0xD896, 0xD482, 0xD08D, 0xCCB7, 0xC903,
        0xC575, 0xC20E, 0xBED1, 0xBBC0, 0xB8DD, 0xB62A, 0xB3A8, 0xB15A, 0xAF41, 0xAD5F, 0xABB4, 0xAA42, 0xA909, 0xA80B, 0xA749, 0xA6C2,
        0xA678, 0xA66A, 0xA698, 0xA702, 0xA7A9, 0xA88B, 0xA9A8, 0xAAFF, 0xAC8F, 0xAE58, 0xB057, 0xB28D, 0xB4F6, 0xB792, 0xBA5F, 0xBD5B,
        0xC084, 0xC3D7, 0xC753, 0xCAF6, 0xCEBC, 0xD2A3, 0xD6A9, 0xDACA, 0xDF05, 0xE356, 0xE7BA, 0xEC2F, 0xF0B1, 0xF53D, 0xF9D0, 0xFE68,
        0x0300, 0x0797, 0x0C28, 0x10B2, 0x1530, 0x19A0, 0x1DFF, 0x2249, 0x267C, 0x2A96, 0x2E92, 0x3270, 0x362B, 0x39C2, 0x3D32, 0x4078,
        0x4394, 0x4681, 0x493F, 0x4BCC, 0x4E26, 0x504B, 0x523A, 0x53F1, 0x5570, 0x56B6, 0x57C1, 0x5890, 0x5925, 0x597D, 0x5998, 0x5978,
        0x591B, 0x5882, 0x57AD, 0x569D, 0x5553, 0x53D0, 0x5214, 0x5020, 0x4DF7, 0x4B99, 0x4908, 0x4646, 0x4354, 0x4036, 0x3CEC, 0x3978,
        0x35DE, 0x3220, 0x2E40, 0x2A41, 0x2626, 0x21F0, 0x1DA4, 0x1944, 0x14D3, 0x1053, 0x0BC9, 0x0737, 0x02A0, 0xFE08, 0xF971, 0xF4DE,
        0xF052, 0xEBD1, 0xE75E, 0xE2FB, 0xDEAC, 0xDA73, 0xD653, 0xD250, 0xCE6B, 0xCAA8, 0xC709, 0xC390, 0xC040, 0xBD1B, 0xBA23, 0xB75A,
        0xB4C2, 0xB25D, 0xB02C, 0xAE30, 0xAC6C, 0xAAE1, 0xA98E, 0xA876, 0xA799, 0xA6F7, 0xA692, 0xA669, 0xA67C, 0xA6CB, 0xA757, 0xA81E,
        0xA921, 0xAA5E, 0xABD4, 0xAD84, 0xAF6B, 0xB188, 0xB3DB, 0xB660, 0xB917, 0xBBFE, 0xBF13, 0xC254, 0xC5BE, 0xC94F, 0xCD06, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC619, 0xC9AF, 0xCD69, 0xD144, 0xD540, 0xD958, 0xDD8B, 0xE1D4, 0xE632, 0xEAA1, 0xEF1F, 0xF3A8, 0xF839, 0xFCD0, 0x0168,
        0x0600, 0x0A93, 0x0F20, 0x13A2, 0x1818, 0x1C7D, 0x20CE, 0x250A, 0x292D, 0x2D34, 0x311C, 0x34E4, 0x3887, 0x3C05, 0x3F5A, 0x4285,
        0x4583, 0x4851, 0x4AF0, 0x4D5B, 0x4F93, 0x5194, 0x535F, 0x54F2, 0x564B, 0x576B, 0x584F, 0x58F8, 0x5965, 0x5996, 0x598A, 0x5942,
        0x58BE, 0x57FE, 0x5702, 0x55CC, 0x545D, 0x52B4, 0x50D4, 0x4EBD, 0x4C71, 0x49F2, 0x4740, 0x445F, 0x4150, 0x3E14, 0x3AAF, 0x3723,
        0x3371, 0x2F9C, 0x2BA8, 0x2795, 0x2369, 0x1F24, 0x1ACB, 0x165F, 0x11E4, 0x0D5D, 0x08CE, 0x0438, 0xFFA0, 0xFB08, 0xF673, 0xF1E5,
        0xED60, 0xE8E7, 0xE47E, 0xE028, 0xDBE7, 0xD7BF, 0xD3B1, 0xCFC2, 0xCBF2, 0xC846, 0xC4C0, 0xC162, 0xBE2D, 0xBB25, 0xB84C, 0xB5A3,
        0xB32B, 0xB0E8, 0xAEDA, 0xAD03, 0xAB63, 0xA9FD, 0xA8D1, 0xA7DF, 0xA729, 0xA6AE, 0xA670, 0xA66E, 0xA6A9, 0xA71F, 0xA7D2, 0xA8C0,
        0xA9E9, 0xAB4C, 0xACE8, 0xAEBC, 0xB0C6, 0xB307, 0xB57A, 0xB821, 0xBAF7, 0xBDFC, 0xC12E, 0xC48A, 0xC80E, 0xCBB8, 0xCF85, 0xD373,
        0xD77E, 0xDBA5, 0xDFE5, 0xE43A, 0xE8A2, 0xED19, 0xF19E, 0xF62C, 0xFAC0, 0xFF58, 0x03F0, 0x0886, 0x0D16, 0x119E, 0x1619, 0x1A86,
        0x1EE1, 0x2326, 0x2755, 0x2B69, 0x2F5F, 0x3336, 0x36EA, 0x3A79, 0x3DE0, 0x411E, 0x4430, 0x4715, 0x49C9, 0x4C4B, 0x4E9A, 0x50B4,
        0x5298, 0x5444, 0x55B8, 0x56F1, 0x57F0, 0x58B4, 0x593B, 0x5987, 0x5997, 0x596A, 0x5900, 0x585B, 0x577A, 0x565F, 0x5509, 0x537A,
        0x51B2, 0x4FB4, 0x4D7F, 0x4B17, 0x487C, 0x45B0, 0x42B5, 0x3F8D, 0x3C3B, 0x38BF, 0x351E, 0x3159, 0x2D72, 0x296D, 0x254C, 0x2111,
        0x1CC1, 0x185D, 0x13E9, 0x0F67, 0x0ADB, 0x0647, 0x01B0, 0xFD18, 0xF881, 0xF3EF, 0xEF66, 0xEAE7, 0xE677, 0xE218, 0xDDCD, 0xD999,
        0xD57F, 0xD182, 0xCDA4, 0xC9E8, 0xC650, 0xC2E0, 0xBF98, 0xBC7C, 0xB98D, 0xB6CE, 0xB441, 0xB1E6, 0xAFC0, 0xADD0, 0xAC17, 0xAA97,
        0xA950, 0xA844, 0xA773, 0xA6DE, 0xA685, 0xA668, 0xA687, 0xA6E3, 0xA77B, 0xA84E, 0xA95C, 0xAAA5, 0xAC28, 0xADE3, 0xAFD5, 0xB1FD,
        0xB45A, 0xB6EA, 0xB9AB, 0xBC9C, 0xBFBA, 0xC303, 0xC675, 0xCA0E, 0xCDCC, 0xD1AB, 0xD5AA, 0xD9C5, 0xDDFA, 0xE245, 0xE6A5, 0xEB16,
        0xEF95, 0xF41F, 0xF8B1, 0xFD48, 0x01E0, 0x0677, 0x0B0B, 0x0F96, 0x1418, 0x188B, 0x1CEE, 0x213E, 0x2577, 0x2997, 0x2D9B, 0x3181,
        0x3544, 0x38E4, 0x3C5E, 0x3FAF, 0x42D5, 0x45CE, 0x4898, 0x4B31, 0x4D97, 0x4FCA, 0x51C6, 0x538B, 0x5518, 0x566B, 0x5785, 0x5863,
        0x5906, 0x596D, 0x5997, 0x5985, 0x5937, 0x58AD, 0x57E7, 0x56E5, 0x55A9, 0x5434, 0x5286, 0x50A0, 0x4E83, 0x4C32, 0x49AD, 0x46F7,
        0x4411, 0x40FD, 0x3DBE, 0x3A54, 0x36C4, 0x330E, 0x2F36, 0x2B3E, 0x272A, 0x22FA, 0x1EB3, 0x1A58, 0x15EB, 0x116E, 0x0CE7, 0x0856,
        0x03C0, 0xFF28, 0xFA90, 0xF5FC, 0xF16E, 0xECEA, 0xE873, 0xE40C, 0xDFB8, 0xDB79, 0xD753, 0xD349, 0xCF5C, 0xCB91, 0xC7E9, 0xC466,
        0xC10C, 0xBDDC, 0xBAD9, 0xB804, 0xB560, 0xB2EE, 0xB0B0, 0xAEA8, 0xACD6, 0xAB3C, 0xA9DC, 0xA8B5, 0xA7CA, 0xA719, 0xA6A5, 0xA66D,
        0xA671, 0xA6B2, 0xA72F, 0xA7E8, 0xA8DC, 0xAA0B, 0xAB73, 0xAD15, 0xAEEF, 0xB0FF, 0xB344, 0xB5BD, 0xB869, 0xBB44, 0xBE4E, 0xC184,
        0xC4E4, 0xC86C, 0xCC1A, 0xCFEA, 0xD3DB, 0xD7E9, 0xDC13, 0xE055, 0xE4AC, 0xE916, 0xED8F, 0xF214, 0xF6A3, 0xFB38, 0xFFD0, 0x0468,
        0x08FD, 0x0D8D, 0x1213, 0x168D, 0x1AF8, 0x1F51, 0x2395, 0x27C1, 0x2BD1, 0x2FC5, 0x3398, 0x3748, 0x3AD4, 0x3E37, 0x4171, 0x447E,
        0x475D, 0x4A0D, 0x4C8A, 0x4ED4, 0x50E8, 0x52C6, 0x546D, 0x55DA, 0x570E, 0x5807, 0x58C4, 0x5946, 0x598C, 0x5995, 0x5962, 0x58F2,
        0x5847, 0x5760, 0x563E, 0x54E3, 0x534E, 0x5181, 0x4F7C, 0x4D43, 0x4AD5, 0x4835, 0x4564, 0x4265, 0x3F38, 0x3BE1, 0x3862, 0x34BD,
        0x30F4, 0x2D0A, 0x2902, 0x24DE, 0x20A2, 0x1C4F, 0x17E9, 0x1374, 0x0EF1, 0x0A64, 0x05D0, 0x0138, 0xFCA0, 0xF80A, 0xF378, 0xEEF0,
        0xEA73, 0xE604, 0xE1A7, 0xDD5E, 0xD92D, 0xD516, 0xD11C, 0xCD41, 0xC988, 0xC5F5, 0xC288, 0xBF45, 0xBC2D, 0xB944, 0xB689, 0xB401,
        0xB1AB, 0xAF8B, 0xADA0, 0xABED, 0xAA73, 0xA932, 0xA82C, 0xA761, 0xA6D2, 0xA67F, 0xA668, 0xA68E, 0xA6EF, 0xA78D, 0xA867, 0xA97B,
        0xAACA, 0xAC52, 0xAE13, 0xB00B, 0xB239, 0xB49B, 0xB730, 0xB9F6, 0xBCEB, 0xC00E, 0xC35B, 0xC6D1, 0xCA6E, 0xCE2F, 0xD212, 0xD614,
        0xDA31, 0xDE69, 0xE2B7, 0xE718, 0xEB8B, 0xF00B, 0xF496, 0xF929, 0xFDC0, 0x0258, 0x06EF, 0x0B82, 0x100D, 0x148D, 0x18FF, 0x1D60,
        0x21AD, 0x25E4, 0x2A02, 0x2E03, 0x31E5, 0x35A5, 0x3941, 0x3CB7, 0x4003, 0x4325, 0x4619, 0x48DE, 0x4B72, 0x4DD3, 0x5000, 0x51F7,
        0x53B6, 0x553D, 0x568B, 0x579E, 0x5876, 0x5913, 0x5974, 0x5998, 0x5980, 0x592C, 0x589B, 0x57CF, 0x56C8, 0x5586, 0x540B, 0x5256,
        0x506B, 0x4E49, 0x4BF3, 0x4969, 0x46AE, 0x43C3, 0x40AA, 0x3D66, 0x39F9, 0x3664, 0x32AB, 0x2ED0, 0x2AD5, 0x26BD, 0x228C, 0x1E42,
        0x19E5, 0x1576, 0x10F9, 0x0C70, 0x07DF, 0x0348, 0xFEB0, 0xFA18, 0xF584, 0xF0F8, 0xEC75, 0xE7FF, 0xE39A, 0xDF48, 0xDB0C, 0xD6E9,
        0xD2E1, 0xCEF8, 0xCB30, 0xC78B, 0xC40D, 0xC0B7, 0xBD8B, 0xBA8D, 0xB7BD, 0xB51E, 0xB2B1, 0xB078, 0xAE75, 0xACA9, 0xAB16, 0xA9BB,
        0xA89B, 0xA7B5, 0xA70B, 0xA69D, 0xA66B, 0xA675, 0xA6BC, 0xA73F, 0xA7FE, 0xA8F8, 0xAA2D, 0xAB9B, 0xAD43, 0xAF22, 0xB138, 0xB383,
        0xB601, 0xB8B1, 0xBB91, 0xBEA0, 0xC1DA, 0xC53F, 0xC8CB, 0xCC7C, 0xD050, 0xD444, 0xD855, 0xDC81, 0xE0C5, 0xE51F, 0xE98A, 0xEE04,
        0xF28B, 0xF71A, 0xFBB0, 0x0048, 0x04E0, 0x0975, 0x0E04, 0x1289, 0x1702, 0x1B6B, 0x1FC2, 0x2403, 0x282C, 0x2C3A, 0x302A, 0x33FA,
        0x37A7, 0x3B2E, 0x3E8D, 0x41C2, 0x44CB, 0x47A6, 0x4A50, 0x4CC8, 0x4F0D, 0x511C, 0x52F4, 0x5495, 0x55FC, 0x572A, 0x581D, 0x58D4,
        0x5950, 0x598F, 0x5992, 0x5959, 0x58E4, 0x5832, 0x5745, 0x561E, 0x54BC, 0x5321, 0x514E, 0x4F45, 0x4D06, 0x4A93, 0x47EE, 0x4518,
        0x4214, 0x3EE3, 0x3B88, 0x3805, 0x345C, 0x308F, 0x2CA2, 0x2897, 0x2471, 0x2032, 0x1BDD, 0x1776, 0x12FE, 0x0E7A, 0x09EC, 0x0558,
        0x00C0, 0xFC28, 0xF792, 0xF302, 0xEE7A, 0xE9FE, 0xE591, 0xE136, 0xDCF0, 0xD8C1, 0xD4AC, 0xD0B5, 0xCCDE, 0xC929, 0xC599, 0xC231,
        0xBEF2, 0xBBDF, 0xB8FA, 0xB645, 0xB3C1, 0xB171, 0xAF56, 0xAD71, 0xABC4, 0xAA4F, 0xA915, 0xA815, 0xA750, 0xA6C7, 0xA67A, 0xA669,
        0xA695, 0xA6FD, 0xA7A1, 0xA880, 0xA99B, 0xAAF0, 0xAC7E, 0xAE44, 0xB041, 0xB275, 0xB4DC, 0xB776, 0xBA41, 0xBD3B, 0xC062, 0xC3B4,
        0xC72E, 0xCACF, 0xCE93, 0xD279, 0xD67E, 0xDA9E, 0xDED8, 0xE328, 0xE78C, 0xEC00, 0xF081, 0xF50D, 0xF9A1, 0xFE38, 0x02D0, 0x0767,
        0x0BF9, 0x1083, 0x1501, 0x1972, 0x1DD1, 0x221D, 0x2651, 0x2A6C, 0x2E69, 0x3248, 0x3605, 0x399D, 0x3D0F, 0x4057, 0x4374, 0x4664,
        0x4924, 0x4BB3, 0x4E0E, 0x5036, 0x5227, 0x53E1, 0x5562, 0x56AA, 0x57B7, 0x5889, 0x5920, 0x597A, 0x5998, 0x597A, 0x5920, 0x5889,
        0x57B7, 0x56AA, 0x5562, 0x53E1, 0x5227, 0x5036, 0x4E0E, 0x4BB3, 0x4924, 0x4664, 0x4374, 0x4057, 0x3D0F, 0x399D, 0x3605, 0x3248,
        0x2E69, 0x2A6C, 0x2651, 0x221D, 0x1DD1, 0x1972, 0x1501, 0x1083, 0x0BF9, 0x0767, 0x02D0, 0xFE38, 0xF9A1, 0xF50D, 0xF081, 0xEC00,
        0xE78C, 0xE328, 0xDED8, 0xDA9E, 0xD67E, 0xD279, 0xCE93, 0xCACF, 0xC72E, 0xC3B4, 0xC062, 0xBD3B, 0xBA41, 0xB776, 0xB4DC, 0xB275,
        0xB041, 0xAE44, 0xAC7E, 0xAAF0, 0xA99B, 0xA880, 0xA7A1, 0xA6FD, 0xA695, 0xA669, 0xA67A, 0xA6C7, 0xA750, 0xA815, 0xA915, 0xAA4F,
        0xABC4, 0xAD71, 0xAF56, 0xB171, 0xB3C1, 0xB645, 0xB8FA, 0xBBDF, 0xBEF2, 0xC231, 0xC599, 0xC929, 0xCCDE, 0xD0B5, 0xD4AC, 0xD8C1,
        0xDCF0, 0xE136, 0xE591, 0xE9FE, 0xEE7A, 0xF302, 0xF792, 0xFC28, 0x00C0, 0x0558, 0x09EC, 0x0E7A, 0x12FE, 0x1776, 0x1BDD, 0x2032,
        0x2471, 0x2897, 0x2CA2, 0x308F, 0x345C, 0x3805, 0x3B88, 0x3EE3, 0x4214, 0x4518, 0x47EE, 0x4A93, 0x4D06, 0x4F45, 0x514E, 0x5321,
        0x54BC, 0x561E, 0x5745, 0x5832, 0x58E4, 0x5959, 0x5992, 0x598F, 0x5950, 0x58D4, 0x581D, 0x572A, 0x55FC, 0x5495, 0x52F4, 0x511C,
        0x4F0D, 0x4CC8, 0x4A50, 0x47A6, 0x44CB, 0x41C2, 0x3E8D, 0x3B2E, 0x37A7, 0x33FA, 0x302A, 0x2C3A, 0x282C, 0x2403, 0x1FC2, 0x1B6B,
        0x1702, 0x1289, 0x0E04, 0x0975, 0x04E0, 0x0048, 0xFBB0, 0xF71A, 0xF28B, 0xEE04, 0xE98A, 0xE51F, 0xE0C5, 0xDC81, 0xD855, 0xD444,
        0xD050, 0xCC7C, 0xC8CB, 0xC53F, 0xC1DA, 0xBEA0, 0xBB91, 0xB8B1, 0xB601, 0xB383, 0xB138, 0xAF22, 0xAD43, 0xAB9B, 0xAA2D, 0xA8F8,
        0xA7FE, 0xA73F, 0xA6BC, 0xA675, 0xA66B, 0xA69D, 0xA70B, 0xA7B5, 0xA89B, 0xA9BB, 0xAB16, 0xACA9, 0xAE75, 0xB078, 0xB2B1, 0xB51E,
        0xB7BD, 0xBA8D, 0xBD8B, 0xC0B7, 0xC40D, 0xC78B, 0xCB30, 0xCEF8, 0xD2E1, 0xD6E9, 0xDB0C, 0xDF48, 0xE39A, 0xE7FF, 0xEC75, 0xF0F8,
        0xF584, 0xFA18, 0xFEB0, 0x0348, 0x07DF, 0x0C70, 0x10F9, 0x1576, 0x19E5, 0x1E42, 0x228C, 0x26BD, 0x2AD5, 0x2ED0, 0x32AB, 0x3664,
        0x39F9, 0x3D66, 0x40AA, 0x43C3, 0x46AE, 0x4969, 0x4BF3, 0x4E49, 0x506B, 0x5256, 0x540B, 0x5586, 0x56C8, 0x57CF, 0x589B, 0x592C,
        0x5980, 0x5998, 0x5974, 0x5913, 0x5876, 0x579E, 0x568B, 0x553D, 0x53B6, 0x51F7, 0x5000, 0x4DD3, 0x4B72, 0x48DE, 0x4619, 0x4325,
        0x4003, 0x3CB7, 0x3941, 0x35A5, 0x31E5, 0x2E03, 0x2A02, 0x25E4, 0x21AD, 0x1D60, 0x18FF, 0x148D, 0x100D, 0x0B82, 0x06EF, 0x0258,
        0xFDC0, 0xF929, 0xF496, 0xF00B, 0xEB8B, 0xE718, 0xE2B7, 0xDE69, 0xDA31, 0xD614, 0xD212, 0xCE2F, 0xCA6E, 0xC6D1, 0xC35B, 0xC00E,
        0xBCEB, 0xB9F6, 0xB730, 0xB49B, 0xB239, 0xB00B, 0xAE13, 0xAC52, 0xAACA, 0xA97B, 0xA867, 0xA78D, 0xA6EF, 0xA68E, 0xA668, 0xA67F,
        0xA6D2, 0xA761, 0xA82C, 0xA932, 0xAA73, 0xABED, 0xADA0, 0xAF8B, 0xB1AB, 0xB401, 0xB689, 0xB944, 0xBC2D, 0xBF45, 0xC288, 0xC5F5,
        0xC988, 0xCD41, 0xD11C, 0xD516, 0xD92D, 0xDD5E, 0xE1A7, 0xE604, 0xEA73, 0xEEF0, 0xF378, 0xF80A, 0xFCA0, 0x0138, 0x05D0, 0x0A64,
        0x0EF1, 0x1374, 0x17E9, 0x1C4F, 0x20A2, 0x24DE, 0x2902, 0x2D0A, 0x30F4, 0x34BD, 0x3862, 0x3BE1, 0x3F38, 0x4265, 0x4564, 0x4835,
        0x4AD5, 0x4D43, 0x4F7C, 0x5181, 0x534E, 0x54E3, 0x563E, 0x5760, 0x5847, 0x58F2, 0x5962, 0x5995, 0x598C, 0x5946, 0x58C4, 0x5807,
        0x570E, 0x55DA, 0x546D, 0x52C6, 0x50E8, 0x4ED4, 0x4C8A, 0x4A0D, 0x475D, 0x447E, 0x4171, 0x3E37, 0x3AD4, 0x3748, 0x3398, 0x2FC5,
        0x2BD1, 0x27C1, 0x2395, 0x1F51, 0x1AF8, 0x168D, 0x1213, 0x0D8D, 0x08FD, 0x0468, 0xFFD0, 0xFB38, 0xF6A3, 0xF214, 0xED8F, 0xE916,
        0xE4AC, 0xE055, 0xDC13, 0xD7E9, 0xD3DB, 0xCFEA, 0xCC1A, 0xC86C, 0xC4E4, 0xC184, 0xBE4E, 0xBB44, 0xB869, 0xB5BD, 0xB344, 0xB0FF,
        0xAEEF, 0xAD15, 0xAB73, 0xAA0B, 0xA8DC, 0xA7E8, 0xA72F, 0xA6B2, 0xA671, 0xA66D, 0xA6A5, 0xA719, 0xA7CA, 0xA8B5, 0xA9DC, 0xAB3C,
        0xACD6, 0xAEA8, 0xB0B0, 0xB2EE, 0xB560, 0xB804, 0xBAD9, 0xBDDC, 0xC10C, 0xC466, 0xC7E9, 0xCB91, 0xCF5C, 0xD349, 0xD753, 0xDB79,
        0xDFB8, 0xE40C, 0xE873, 0xECEA, 0xF16E, 0xF5FC, 0xFA90, 0xFF28, 0x03C0, 0x0856, 0x0CE7, 0x116E, 0x15EB, 0x1A58, 0x1EB3, 0x22FA,
        0x272A, 0x2B3E, 0x2F36, 0x330E, 0x36C4, 0x3A54, 0x3DBE, 0x40FD, 0x4411, 0x46F7, 0x49AD, 0x4C32, 0x4E83, 0x50A0, 0x5286, 0x5434,
        0x55A9, 0x56E5, 0x57E7, 0x58AD, 0x5937, 0x5985, 0x5997, 0x596D, 0x5906, 0x5863, 0x5785, 0x566B, 0x5518, 0x538B, 0x51C6, 0x4FCA,
        0x4D97, 0x4B31, 0x4898, 0x45CE, 0x42D5, 0x3FAF, 0x3C5E, 0x38E4, 0x3544, 0x3181, 0x2D9B, 0x2997, 0x2577, 0x213E, 0x1CEE, 0x188B,
        0x1418, 0x0F96, 0x0B0B, 0x0677, 0x01E0, 0xFD48, 0xF8B1, 0xF41F, 0xEF95, 0xEB16, 0xE6A5, 0xE245, 0xDDFA, 0xD9C5, 0xD5AA, 0xD1AB,
        0xCDCC, 0xCA0E, 0xC675, 0xC303, 0xBFBA, 0xBC9C, 0xB9AB, 0xB6EA, 0xB45A, 0xB1FD, 0xAFD5, 0xADE3, 0xAC28, 0xAAA5, 0xA95C, 0xA84E,
        0xA77B, 0xA6E3, 0xA687, 0xA668, 0xA685, 0xA6DE, 0xA773, 0xA844, 0xA950, 0xAA97, 0xAC17, 0xADD0, 0xAFC0, 0xB1E6, 0xB441, 0xB6CE,
        0xB98D, 0xBC7C, 0xBF98, 0xC2E0, 0xC650, 0xC9E8, 0xCDA4, 0xD182, 0xD57F, 0xD999, 0xDDCD, 0xE218, 0xE677, 0xEAE7, 0xEF66, 0xF3EF,
        0xF881, 0xFD18, 0x01B0, 0x0647, 0x0ADB, 0x0F67, 0x13E9, 0x185D, 0x1CC1, 0x2111, 0x254C, 0x296D, 0x2D72, 0x3159, 0x351E, 0x38BF,
        0x3C3B, 0x3F8D, 0x42B5, 0x45B0, 0x487C, 0x4B17, 0x4D7F, 0x4FB4, 0x51B2, 0x537A, 0x5509, 0x565F, 0x577A, 0x585B, 0x5900, 0x596A,
        0x5997, 0x5987, 0x593B, 0x58B4, 0x57F0, 0x56F1, 0x55B8, 0x5444, 0x5298, 0x50B4, 0x4E9A, 0x4C4B, 0x49C9, 0x4715, 0x4430, 0x411E,
        0x3DE0, 0x3A79, 0x36EA, 0x3336, 0x2F5F, 0x2B69, 0x2755, 0x2326, 0x1EE1, 0x1A86, 0x1619, 0x119E, 0x0D16, 0x0886, 0x03F0, 0xFF58,
        0xFAC0, 0xF62C, 0xF19E, 0xED19, 0xE8A2, 0xE43A, 0xDFE5, 0xDBA5, 0xD77E, 0xD373, 0xCF85, 0xCBB8, 0xC80E, 0xC48A, 0xC12E, 0xBDFC,
        0xBAF7, 0xB821, 0xB57A, 0xB307, 0xB0C6, 0xAEBC, 0xACE8, 0xAB4C, 0xA9E9, 0xA8C0, 0xA7D2, 0xA71F, 0xA6A9, 0xA66E, 0xA670, 0xA6AE,
        0xA729, 0xA7DF, 0xA8D1, 0xA9FD, 0xAB63, 0xAD03, 0xAEDA, 0xB0E8, 0xB32B, 0xB5A3, 0xB84C, 0xBB25, 0xBE2D, 0xC162, 0xC4C0, 0xC846,
        0xCBF2, 0xCFC2, 0xD3B1, 0xD7BF, 0xDBE7, 0xE028, 0xE47E, 0xE8E7, 0xED60, 0xF1E5, 0xF673, 0xFB08, 0xFFA0, 0x0438, 0x08CE, 0x0D5D,
        0x11E4, 0x165F, 0x1ACB, 0x1F24, 0x2369, 0x2795, 0x2BA8, 0x2F9C, 0x3371, 0x3723, 0x3AAF, 0x3E14, 0x4150, 0x445F, 0x4740, 0x49F2,
        0x4C71, 0x4EBD, 0x50D4, 0x52B4, 0x545D, 0x55CC, 0x5702, 0x57FE, 0x58BE, 0x5942, 0x598A, 0x5996, 0x5965, 0x58F8, 0x584F, 0x576B,
        0x564B, 0x54F2, 0x535F, 0x5194, 0x4F93, 0x4D5B, 0x4AF0, 0x4851, 0x4583, 0x4285, 0x3F5A, 0x3C05, 0x3887, 0x34E4, 0x311C, 0x2D34,
        0x292D, 0x250A, 0x20CE, 0x1C7D, 0x1818, 0x13A2, 0x0F20, 0x0A93, 0x0600, 0x0168, 0xFCD0, 0xF839, 0xF3A8, 0xEF1F, 0xEAA1, 0xE632,
        0xE1D4, 0xDD8B, 0xD958, 0xD540, 0xD144, 0xCD69, 0xC9AF, 0xC619, 0xC2AB, 0xBF66, 0xBC4D, 0xB961, 0xB6A5, 0xB41A, 0xB1C3, 0xAFA0,
        0xADB3, 0xABFE, 0xAA81, 0xA93E, 0xA836, 0xA768, 0xA6D7, 0xA681, 0xA668, 0xA68B, 0xA6EA, 0xA786, 0xA85D, 0xA96F, 0xAABB, 0xAC41,
        0xAE00, 0xAFF5, 0xB221, 0xB481, 0xB714, 0xB9D8, 0xBCCB, 0xBFEC, 0xC338, 0xC6AD, 0xCA48, 0xCE08, 0xD1E9, 0xD5E9, 0xDA06, 0xDE3C,
        0xE289, 0xE6EA, 0xEB5C, 0xEFDC, 0xF466, 0xF8F9, 0xFD90, 0x0228, 0x06BF, 0x0B52, 0x0FDD, 0x145E, 0x18D1, 0x1D33, 0x2181, 0x25B9,
        0x29D7, 0x2DD9, 0x31BD, 0x357E, 0x391C, 0x3C93, 0x3FE2, 0x4305, 0x45FB, 0x48C2, 0x4B58, 0x4DBB, 0x4FEA, 0x51E3, 0x53A5, 0x552E,
        0x567E, 0x5794, 0x586F, 0x590E, 0x5971, 0x5998, 0x5982, 0x5930, 0x58A2, 0x57D9, 0x56D4, 0x5594, 0x541B, 0x5269, 0x5080, 0x4E60,
        0x4C0C, 0x4984, 0x46CB, 0x43E2, 0x40CC, 0x3D89, 0x3A1E, 0x368B, 0x32D3, 0x2EF9, 0x2AFF, 0x26E9, 0x22B8, 0x1E70, 0x1A13, 0x15A5,
        0x1128, 0x0C9F, 0x080E, 0x0378, 0xFEE0, 0xFA48, 0xF5B4, 0xF127, 0xECA4, 0xE82E, 0xE3C8, 0xDF75, 0xDB38, 0xD713, 0xD30A, 0xCF20,
        0xCB57, 0xC7B1, 0xC430, 0xC0D9, 0xBDAB, 0xBAAB, 0xB7D9, 0xB538, 0xB2C9, 0xB08F, 0xAE89, 0xACBB, 0xAB25, 0xA9C8, 0xA8A5, 0xA7BD,
        0xA711, 0xA6A0, 0xA66C, 0xA674, 0xA6B8, 0xA739, 0xA7F5, 0xA8ED, 0xAA1F, 0xAB8B, 0xAD30, 0xAF0D, 0xB121, 0xB36A, 0xB5E6, 0xB894,
        0xBB72, 0xBE7F, 0xC1B8, 0xC51A, 0xC8A5, 0xCC54, 0xD027, 0xD41A, 0xD82A, 0xDC55, 0xE098, 0xE4F1, 0xE95B, 0xEDD5, 0xF25B, 0xF6EB,
        0xFB80, 0x0018, 0x04B0, 0x0945, 0x0DD4, 0x125A, 0x16D3, 0x1B3D, 0x1F95, 0x23D7, 0x2801, 0x2C10, 0x3002, 0x33D3, 0x3781, 0x3B0A,
        0x3E6B, 0x41A2, 0x44AC, 0x4789, 0x4A35, 0x4CAF, 0x4EF6, 0x5107, 0x52E2, 0x5485, 0x55EF, 0x571F, 0x5814, 0x58CE, 0x594C, 0x598E,
        0x5993, 0x595D, 0x58EA, 0x583B, 0x5750, 0x562B, 0x54CC, 0x5333, 0x5163, 0x4F5B, 0x4D1E, 0x4AAD, 0x480A, 0x4537, 0x4234, 0x3F05,
        0x3BAC, 0x382A, 0x3483, 0x30B8, 0x2CCC, 0x28C2, 0x249D, 0x205F, 0x1C0B, 0x17A4, 0x132D, 0x0EAA, 0x0A1C, 0x0588, 0x00F0, 0xFC58,
        0xF7C2, 0xF331, 0xEEA9, 0xEA2D, 0xE5BF, 0xE163, 0xDD1C, 0xD8EC, 0xD4D7, 0xD0DE, 0xCD06, 0xC94F, 0xC5BE, 0xC254, 0xBF13, 0xBBFE,
        0xB917, 0xB660, 0xB3DB, 0xB188, 0xAF6B, 0xAD84, 0xABD4, 0xAA5E, 0xA921, 0xA81E, 0xA757, 0xA6CB, 0xA67C, 0xA669, 0xA692, 0xA6F7,
        0xA799, 0xA876, 0xA98E, 0xAAE1, 0xAC6C, 0xAE30, 0xB02C, 0xB25D, 0xB4C2, 0xB75A, 0xBA23, 0xBD1B, 0xC040, 0xC390, 0xC709, 0xCAA8,
        0xCE6B, 0xD250, 0xD653, 0xDA73, 0xDEAC, 0xE2FB, 0xE75E, 0xEBD1, 0xF052, 0xF4DE, 0xF971, 0xFE08, 0x02A0, 0x0737, 0x0BC9, 0x1053,
        0x14D3, 0x1944, 0x1DA4, 0x21F0, 0x2626, 0x2A41, 0x2E40, 0x3220, 0x35DE, 0x3978, 0x3CEC, 0x4036, 0x4354, 0x4646, 0x4908, 0x4B99,
        0x4DF7, 0x5020, 0x5214, 0x53D0, 0x5553, 0x569D, 0x57AD, 0x5882, 0x591B, 0x5978, 0x5998, 0x597D, 0x5925, 0x5890, 0x57C1, 0x56B6,
        0x5570, 0x53F1, 0x523A, 0x504B, 0x4E26, 0x4BCC, 0x493F, 0x4681, 0x4394, 0x4078, 0x3D32, 0x39C2, 0x362B, 0x3270, 0x2E92, 0x2A96,
        0x267C, 0x2249, 0x1DFF, 0x19A0, 0x1530, 0x10B2, 0x0C28, 0x0797, 0x0300, 0xFE68, 0xF9D0, 0xF53D, 0xF0B1, 0xEC2F, 0xE7BA, 0xE356,
        0xDF05, 0xDACA, 0xD6A9, 0xD2A3, 0xCEBC, 0xCAF6, 0xC753, 0xC3D7, 0xC084, 0xBD5B, 0xBA5F, 0xB792, 0xB4F6, 0xB28D, 0xB057, 0xAE58,
        0xAC8F, 0xAAFF, 0xA9A8, 0xA88B, 0xA7A9, 0xA702, 0xA698, 0xA66A, 0xA678, 0xA6C2, 0xA749, 0xA80B, 0xA909, 0xAA42, 0xABB4, 0xAD5F,
        0xAF41, 0xB15A, 0xB3A8, 0xB62A, 0xB8DD, 0xBBC0, 0xBED1, 0xC20E, 0xC575, 0xC903, 0xCCB7, 0xD08D, 0xD482, 0xD896, 0xDCC3, 0xE109,
        0xE563, 0xE9D0, 0xEE4B, 0xF2D2, 0xF762, 0xFBF8, 0x0090, 0x0528, 0x09BD, 0x0E4B, 0x12CF, 0x1747, 0x1BAF, 0x2005, 0x2445, 0x286C,
        0x2C79, 0x3067, 0x3435, 0x37DF, 0x3B64, 0x3EC1, 0x41F3, 0x44F9, 0x47D1, 0x4A78, 0x4CED, 0x4F2E, 0x513A, 0x530F, 0x54AC, 0x5610,
        0x573A, 0x582A, 0x58DD, 0x5955, 0x5991, 0x5991, 0x5954, 0x58DA, 0x5825, 0x5735, 0x560A, 0x54A4, 0x5306, 0x5130, 0x4F23, 0x4CE1,
        0x4A6B, 0x47C3, 0x44EA, 0x41E3, 0x3EB0, 0x3B52, 0x37CC, 0x3421, 0x3053, 0x2C64, 0x2857, 0x242F, 0x1FEE, 0x1B99, 0x1730, 0x12B8,
        0x0E33, 0x09A5, 0x0510, 0x0078, 0xFBE0, 0xF74A, 0xF2BA, 0xEE33, 0xE9B8, 0xE54C, 0xE0F2, 0xDCAD, 0xD880, 0xD46D, 0xD078, 0xCCA3,
        0xC8F0, 0xC563, 0xC1FD, 0xBEC1, 0xBBB0, 0xB8CE, 0xB61C, 0xB39C, 0xB14F, 0xAF37, 0xAD55, 0xABAB, 0xAA3B, 0xA903, 0xA807, 0xA746,
        0xA6C0, 0xA677, 0xA66A, 0xA699, 0xA705, 0xA7AD, 0xA890, 0xA9AE, 0xAB06, 0xAC98, 0xAE62, 0xB062, 0xB299, 0xB503, 0xB7A0, 0xBA6E,
        0xBD6B, 0xC095, 0xC3E9, 0xC766, 0xCB09, 0xCED0, 0xD2B7, 0xD6BE, 0xDAE0, 0xDF1B, 0xE36D, 0xE7D1, 0xEC46, 0xF0C8, 0xF555, 0xF9E8,
        0xFE80, 0x0318, 0x07AF, 0x0C40, 0x10C9, 0x1547, 0x19B7, 0x1E15, 0x225F, 0x2692, 0x2AAB, 0x2EA7, 0x3284, 0x363E, 0x39D4, 0x3D43,
        0x4089, 0x43A3, 0x4690, 0x494D, 0x4BD9, 0x4E32, 0x5056, 0x5243, 0x53FA, 0x5578, 0x56BC, 0x57C6, 0x5894, 0x5927, 0x597E, 0x5998,
        0x5976, 0x5918, 0x587E, 0x57A8, 0x5697, 0x554C, 0x53C7, 0x520A, 0x5015, 0x4DEB, 0x4B8C, 0x48FA, 0x4637, 0x4345, 0x4025, 0x3CDA,
        0x3966, 0x35CB, 0x320C, 0x2E2C, 0x2A2C, 0x2610, 0x21DA, 0x1D8D, 0x192D, 0x14BB, 0x103C, 0x0BB1, 0x071F, 0x0288, 0xFDF0, 0xF959,
        0xF4C6, 0xF03A, 0xEBBA, 0xE747, 0xE2E4, 0xDE95, 0xDA5D, 0xD63E, 0xD23B, 0xCE57, 0xCA95, 0xC6F6, 0xC37E, 0xC02F, 0xBD0B, 0xBA14,
        0xB74C, 0xB4B5, 0xB251, 0xB021, 0xAE27, 0xAC64, 0xAAD9, 0xA988, 0xA871, 0xA795, 0xA6F5, 0xA690, 0xA668, 0xA67D, 0xA6CD, 0xA75A,
        0xA823, 0xA926, 0xAA65, 0xABDD, 0xAD8D, 0xAF75, 0xB194, 0xB3E7, 0xB66E, 0xB926, 0xBC0E, 0xBF24, 0xC265, 0xC5D0, 0xC962, 0xCD19,
        0xD0F3, 0xD4EC, 0xD902, 0xDD32, 0xE17A, 0xE5D6, 0xEA44, 0xEEC1, 0xF349, 0xF7DA, 0xFC70, 0x0108, 0x05A0, 0x0A34, 0x0EC1, 0x1345,
        0x17BB, 0x1C22, 0x2075, 0x24B3, 0x28D7, 0x2CE1, 0x30CC, 0x3496, 0x383D, 0x3BBE, 0x3F16, 0x4244, 0x4546, 0x4819, 0x4ABB, 0x4D2A,
        0x4F66, 0x516D, 0x533C, 0x54D3, 0x5631, 0x5756, 0x583F, 0x58EC, 0x595E, 0x5994, 0x598D, 0x594A, 0x58CB, 0x5810, 0x5719, 0x55E8,
        0x547D, 0x52D9, 0x50FD, 0x4EEB, 0x4CA3, 0x4A28, 0x477A, 0x449D, 0x4191, 0x3E5A, 0x3AF8, 0x376E, 0x33BF, 0x2FED, 0x2BFB, 0x27EC,
        0x23C1, 0x1F7E, 0x1B26, 0x16BC, 0x1242, 0x0DBC, 0x092D, 0x0498, 0x0000, 0xFB68, 0xF6D3, 0xF244, 0xEDBE, 0xE944, 0xE4DA, 0xE082,
        0xDC3F, 0xD814, 0xD405, 0xD013, 0xCC41, 0xC892, 0xC508, 0xC1A6, 0xBE6F, 0xBB63, 0xB886, 0xB5D8, 0xB35D, 0xB115, 0xAF03, 0xAD27,
        0xAB83, 0xAA18, 0xA8E7, 0xA7F0, 0xA735, 0xA6B6, 0xA673, 0xA66C, 0xA6A2, 0xA714, 0xA7C1, 0xA8AA, 0xA9CF, 0xAB2D, 0xACC4, 0xAE93,
        0xB09A, 0xB2D6, 0xB545, 0xB7E7, 0xBABA, 0xBDBC, 0xC0EA, 0xC442, 0xC7C3, 0xCB6A, 0xCF34, 0xD31F, 0xD729, 0xDB4D, 0xDF8B, 0xE3DE,
        0xE845, 0xECBB, 0xF13F, 0xF5CC, 0xFA60, 0xFEF8, 0x0390, 0x0826, 0x0CB7, 0x113F, 0x15BC, 0x1A2A, 0x1E86, 0x22CE, 0x26FE, 0x2B14,
        0x2F0D, 0x32E7, 0x369E, 0x3A30, 0x3D9B, 0x40DC, 0x43F2, 0x46DA, 0x4992, 0x4C19, 0x4E6C, 0x508B, 0x5273, 0x5423, 0x559B, 0x56DA,
        0x57DD, 0x58A6, 0x5933, 0x5983, 0x5998, 0x5970, 0x590B, 0x586B, 0x578F, 0x5678, 0x5527, 0x539C, 0x51D9, 0x4FDF, 0x4DAF, 0x4B4B,
        0x48B4, 0x45EC, 0x42F5, 0x3FD1, 0x3C82, 0x390A, 0x356B, 0x31A9, 0x2DC5, 0x29C2, 0x25A3, 0x216B, 0x1D1C, 0x18B9, 0x1446, 0x0FC6,
        0x0B3A, 0x06A2, 0x020D, 0xFD7E, 0xF8F8, 0xF47D, 0xF012, 0xEBB9, 0xE774, 0xE347, 0xDF34, 0xDB3E, 0xD767, 0xD3B2, 0xD021, 0xCCB7,
        0xC974, 0xC65C, 0xC370, 0xC0B2, 0xBE23, 0xBBC5, 0xB999, 0xB7A0, 0xB5DC, 0xB44D, 0xB2F3, 0xB1D0, 0xB0E4, 0xB02F, 0xAFB1, 0xAF6A,
        0xAF5A, 0xAF81, 0xAFDE, 0xB070, 0xB138, 0xB233, 0xB361, 0xB4C1, 0xB652, 0xB812, 0xB9FF, 0xBC18, 0xBE5C, 0xC0C8, 0xC35B, 0xC612,
        0xC8EB, 0xCBE5, 0xCEFC, 0xD22F, 0xD57C, 0xD8DF, 0xDC57, 0xDFE1, 0xE37A, 0xE720, 0xEAD0, 0xEE87, 0xF244, 0xF603, 0xF9C3, 0xFD7F,
        0x0135, 0x04E5, 0x088B, 0x0C24, 0x0FAE, 0x1326, 0x168C, 0x19DC, 0x1D14, 0x2032, 0x2335, 0x261A, 0x28E0, 0x2B84, 0x2E07, 0x3065,
        0x329E, 0x34B1, 0x369C, 0x385E, 0x39F6, 0x3B65, 0x3CA8, 0x3DBF, 0x3EAB, 0x3F6B, 0x3FFE, 0x4064, 0x409E, 0x40AC, 0x408E, 0x4044,
        0x3FD0, 0x3F31, 0x3E68, 0x3D77, 0x3C5E, 0x3B1E, 0x39B9, 0x382F, 0x3682, 0x34B4, 0x32C6, 0x30BA, 0x2E90, 0x2C4C, 0x29EE, 0x2778,
        0x24ED, 0x224E, 0x1F9E, 0x1CDD, 0x1A0F, 0x1735, 0x1451, 0x1166, 0x0E75, 0x0B80, 0x088A, 0x0594, 0x02A2, 0xFFB4, 0xFCCC, 0xF9ED,
        0xF718, 0xF44F, 0xF194, 0xEEE9, 0xEC50, 0xE9CA, 0xE758, 0xE4FC, 0xE2B8, 0xE08D, 0xDE7C, 0xDC87, 0xDAAE, 0xD8F2, 0xD755, 0xD5D8,
        0xD47A, 0xD33D, 0xD221, 0xD127, 0xD04F, 0xCF9A, 0xCF06, 0xCE96, 0xCE48, 0xCE1D, 0xCE14, 0xCE2D, 0xCE68, 0xCEC3, 0xCF40, 0xCFDC,
        0xD098, 0xD172, 0xD26A, 0xD37F, 0xD4AF, 0xD5FA, 0xD75E, 0xD8DA, 0xDA6E, 0xDC17, 0xDDD5, 0xDFA5, 0xE187, 0xE379, 0xE57A, 0xE787,
        0xE9A1, 0xEBC4, 0xEDEF, 0xF021, 0xF259, 0xF494, 0xF6D1, 0xF90F, 0xFB4C, 0xFD86, 0xFFBC, 0x01EB, 0x0414, 0x0635, 0x084C, 0x0A58,
        0x0C57, 0x0E49, 0x102C, 0x11FE, 0x13C0, 0x156F, 0x170B, 0x1893, 0x1A06, 0x1B63, 0x1CAA, 0x1DDA, 0x1EF2, 0x1FF2, 0x20D9, 0x21A7,
        0x225C, 0x22F8, 0x237A, 0x23E2, 0x2431, 0x2466, 0x2481, 0x2483, 0x246D, 0x243D, 0x23F6, 0x2396, 0x231F, 0x2292, 0x21EF, 0x2136,
        0x2069, 0x1F88, 0x1E94, 0x1D8E, 0x1C76, 0x1B4F, 0x1A18, 0x18D4, 0x1782, 0x1624, 0x14BB, 0x1348, 0x11CD, 0x104A, 0x0EC1, 0x0D32,
        0x0B9F, 0x0A0A, 0x0872, 0x06DA, 0x0543, 0x03AC, 0x0219, 0x0089, 0xFEFF, 0xFD7A, 0xFBFC, 0xFA85, 0xF917, 0xF7B2, 0xF658, 0xF509,
        0xF3C7, 0xF291, 0xF168, 0xF04D, 0xEF41, 0xEE45, 0xED58, 0xEC7B, 0xEBAE, 0xEAF2, 0xEA48, 0xE9AF, 0xE927, 0xE8B2, 0xE84D, 0xE7FB,
        0xE7BB, 0xE78C, 0xE76F, 0xE763, 0xE768, 0xE77F, 0xE7A6, 0xE7DD, 0xE824, 0xE87B, 0xE8E0, 0xE955, 0xE9D7, 0xEA66, 0xEB02, 0xEBAB,
        0xEC5F, 0xED1E, 0xEDE7, 0xEEB9, 0xEF94, 0xF077, 0xF161, 0xF252, 0xF348, 0xF443, 0xF542, 0xF645, 0xF74A, 0xF850, 0xF958, 0xFA60,
        0xFB67, 0xFC6D, 0xFD72, 0xFE73, 0xFF71, 0x006A, 0x0160, 0x0250, 0x033A, 0x041E, 0x04FB, 0x05D0, 0x069D, 0x0762, 0x081F, 0x08D2,
        0x097B, 0x0A1B, 0x0AB0, 0x0B3B, 0x0BBC, 0x0C31, 0x0C9C, 0x0CFC, 0x0D51, 0x0D9B, 0x0DD9, 0x0E0D, 0x0E35, 0x0E53, 0x0E65, 0x0E6D,
        0x0E6B, 0x0E5F, 0x0E48, 0x0E28, 0x0DFE, 0x0DCB, 0x0D8F, 0x0D4B, 0x0CFF, 0x0CAB, 0x0C50, 0x0BEE, 0x0B86, 0x0B18, 0x0AA4, 0x0A2B,
        0x09AE, 0x092C, 0x08A7, 0x081F, 0x0794, 0x0707, 0x0678, 0x05E9, 0x0558, 0x04C7, 0x0436, 0x03A6, 0x0316, 0x0288, 0x01FC, 0x0172,
        0x00EB, 0x0067, 0xFFE6, 0xFF69, 0xFEEF, 0xFE7A, 0xFE09, 0xFD9C, 0xFD35, 0xFCD2, 0xFC75, 0xFC1D, 0xFBCB, 0xFB7E, 0xFB37, 0xFAF6,
        0xFABB, 0xFA86, 0xFA57, 0xFA2D, 0xFA09, 0xF9EB, 0xF9D3, 0xF9C1, 0xF9B4, 0xF9AC, 0xF9AA, 0xF9AD, 0xF9B4, 0xF9C1, 0xF9D2, 0xF9E7,
        0xFA01, 0xFA1E, 0xFA3F, 0xFA64, 0xFA8B, 0xFAB6, 0xFAE4, 0xFB14, 0xFB46, 0xFB7A, 0xFBAF, 0xFBE6, 0xFC1F, 0xFC58, 0xFC92, 0xFCCC,
        0xFD06, 0xFD41, 0xFD7B, 0xFDB4, 0xFDED, 0xFE25, 0xFE5C, 0xFE92, 0xFEC6, 0xFEF9, 0xFF29, 0xFF58, 0xFF85, 0xFFB0, 0xFFD9, 0x0000,
        0x0023, 0x0045, 0x0064, 0x0081, 0x009B, 0x00B3, 0x00C9, 0x00DC, 0x00EC, 0x00FB, 0x0106, 0x0110, 0x0117, 0x011D, 0x0120, 0x0121,
        0x0120, 0x011E, 0x011A, 0x0115, 0x010E, 0x0106, 0x00FC, 0x00F2, 0x00E7, 0x00DB, 0x00CE, 0x00C1, 0x00B4, 0x00A6, 0x0099, 0x008B,
        0x007E, 0x0070, 0x0063, 0x0057, 0x004B, 0x0040, 0x0035, 0x002B, 0x0022, 0x001A, 0x0013, 0x000D, 0x0008, 0x0004, 0x0001, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0004, 0x0005, 0x0007, 0x0009, 0x000B, 0x000E, 0x0011,
        0x0014, 0x0017, 0x001B, 0x0020, 0x0024, 0x0029, 0x002E, 0x0033, 0x0038, 0x003D, 0x0043, 0x0048, 0x004E, 0x0053, 0x0058, 0x005D,
        0x0062, 0x0066, 0x006A, 0x006E, 0x0071, 0x0073, 0x0075, 0x0076, 0x0076, 0x0076, 0x0074, 0x0072, 0x006E, 0x0069, 0x0063, 0x005C,
        0x0054, 0x004B, 0x0040, 0x0034, 0x0027, 0x0018, 0x0009, 0xFFF9, 0xFFE6, 0xFFD3, 0xFFBE, 0xFFA8, 0xFF91, 0xFF79, 0xFF61, 0xFF47,
        0xFF2C, 0xFF11, 0xFEF6, 0xFED9, 0xFEBD, 0xFEA0, 0xFE84, 0xFE67, 0xFE4B, 0xFE2F, 0xFE14, 0xFDF9, 0xFDDF, 0xFDC6, 0xFDAF, 0xFD99,
        0xFD84, 0xFD71, 0xFD60, 0xFD51, 0xFD45, 0xFD3A, 0xFD32, 0xFD2D, 0xFD2B, 0xFD2B, 0xFD2F, 0xFD36, 0xFD40, 0xFD4D, 0xFD5E, 0xFD72,
        0xFD8A, 0xFDA5, 0xFDC4, 0xFDE7, 0xFE0D, 0xFE36, 0xFE63, 0xFE94, 0xFEC8, 0xFEFF, 0xFF3A, 0xFF77, 0xFFB7, 0xFFFA, 0x003F, 0x0087,
        0x00D1, 0x011C, 0x016A, 0x01B9, 0x0209, 0x025A, 0x02AB, 0x02FC, 0x034E, 0x039F, 0x03EF, 0x043E, 0x048B, 0x04D7, 0x0520, 0x0567,
        0x05AB, 0x05EC, 0x0629, 0x0662, 0x0697, 0x06C7, 0x06F2, 0x0718, 0x0738, 0x0753, 0x0767, 0x0775, 0x077C, 0x077D, 0x0776, 0x0768,
        0x0753, 0x0737, 0x0713, 0x06E7, 0x06B4, 0x0679, 0x0636, 0x05EC, 0x059A, 0x0541, 0x04E1, 0x047A, 0x040B, 0x0397, 0x031C, 0x029A,
        0x0214, 0x0187, 0x00F6, 0x0061, 0xFFC8, 0xFF2B, 0xFE8B, 0xFDE8, 0xFD43, 0xFC9C, 0xFBF5, 0xFB4E, 0xFAA6, 0xFA00, 0xF95B, 0xF8B9,
        0xF819, 0xF77D, 0xF6E5, 0xF652, 0xF5C4, 0xF53C, 0xF4BC, 0xF442, 0xF3D0, 0xF367, 0xF307, 0xF2B1, 0xF265, 0xF223, 0xF1ED, 0xF1C2,
        0xF1A3, 0xF190, 0xF18A, 0xF190, 0xF1A4, 0xF1C5, 0xF1F4, 0xF230, 0xF279, 0xF2D1, 0xF336, 0xF3A8, 0xF428, 0xF4B5, 0xF54E, 0xF5F5,
        0xF6A7, 0xF765, 0xF82F, 0xF904, 0xF9E2, 0xFACB, 0xFBBC, 0xFCB6, 0xFDB8, 0xFEC0, 0xFFCF, 0x00E1, 0x01F9, 0x0315, 0x0432, 0x0551,
        0x0671, 0x0790, 0x08AE, 0x09C9, 0x0AE0, 0x0BF3, 0x0D00, 0x0E06, 0x0F04, 0x0FF9, 0x10E5, 0x11C5, 0x129A, 0x1362, 0x141C, 0x14C8,
        0x1564, 0x15F0, 0x166B, 0x16D4, 0x172A, 0x176E, 0x179E, 0x17BA, 0x17C2, 0x17B5, 0x1793, 0x175B, 0x170E, 0x16AC, 0x1634, 0x15A6,
        0x1503, 0x144B, 0x137F, 0x129E, 0x11A9, 0x10A1, 0x0F87, 0x0E5A, 0x0D1C, 0x0BCE, 0x0A70, 0x0904, 0x078A, 0x0605, 0x0474, 0x02D9,
        0x0135, 0xFF8B, 0xFDDB, 0xFC26, 0xFA6E, 0xF8B4, 0xF6FA, 0xF542, 0xF38D, 0xF1DC, 0xF032, 0xEE8F, 0xECF6, 0xEB67, 0xE9E5, 0xE871,
        0xE70C, 0xE5B7, 0xE475, 0xE347, 0xE22E, 0xE12A, 0xE03E, 0xDF6B, 0xDEB1, 0xDE12, 0xDD8E, 0xDD26, 0xDCDB, 0xDCAE, 0xDC9F, 0xDCAF,
        0xDCDE, 0xDD2C, 0xDD99, 0xDE26, 0xDED2, 0xDF9D, 0xE087, 0xE190, 0xE2B6, 0xE3FA, 0xE55A, 0xE6D6, 0xE86D, 0xEA1E, 0xEBE6, 0xEDC7,
        0xEFBD, 0xF1C7, 0xF3E5, 0xF614, 0xF852, 0xFA9E, 0xFCF6, 0xFF59, 0x01C2, 0x0432, 0x06A7, 0x091D, 0x0B93, 0x0E06, 0x1075, 0x12DD,
        0x153D, 0x1791, 0x19D7, 0x1C0F, 0x1E34, 0x2046, 0x2242, 0x2427, 0x25F2, 0x27A1, 0x2933, 0x2AA6, 0x2BF8, 0x2D28, 0x2E34, 0x2F1C,
        0x2FDD, 0x3077, 0x30E9, 0x3132, 0x3151, 0x3145, 0x310F, 0x30AE, 0x3021, 0x2F6A, 0x2E87, 0x2D79, 0x2C41, 0x2ADF, 0x2955, 0x27A2,
        0x25C8, 0x23C8, 0x21A4, 0x1F5D, 0x1CF4, 0x1A6C, 0x17C5, 0x1503, 0x1227, 0x0F34, 0x0C2B, 0x0910, 0x05E4, 0x02AB, 0xFF68, 0xFC1B,
        0xF8C9, 0xF574, 0xF220, 0xEECE, 0xEB83, 0xE840, 0xE509, 0xE1E2, 0xDECC, 0xDBCA, 0xD8E0, 0xD610, 0xD35D, 0xD0C9, 0xCE58, 0xCC0B,
        0xC9E4, 0xC7E8, 0xC616, 0xC472, 0xC2FC, 0xC1B8, 0xC0A7, 0xBFC9, 0xBF20, 0xBEAE, 0xBE73, 0xBE70, 0xBEA5, 0xBF13, 0xBFBB, 0xC09B,
        0xC1B4, 0xC306, 0xC48F, 0xC64F, 0xC846, 0xCA71, 0xCCD0, 0xCF61, 0xD221, 0xD510, 0xD82B, 0xDB70, 0xDEDC, 0xE26D, 0xE620, 0xE9F3,
        0xEDE1, 0xF1E8, 0xF605, 0xFA34, 0xFE73, 0x02BB, 0x070C, 0x0B62, 0x0FB7, 0x140A, 0x1855, 0x1C95, 0x20C7, 0x24E5, 0x28EE, 0x2CDD,
        0x30AE, 0x345E, 0x37EA, 0x3B4D, 0x3E86, 0x418F, 0x4468, 0x470C, 0x4978, 0x4BAB, 0x4DA2, 0x4F5B, 0x50D3, 0x5208, 0x52FB, 0x53A7,
        0x540E, 0x542D, 0x5403, 0x5392, 0x52D7, 0x51D4, 0x5088, 0x4EF4, 0x4D19, 0x4AF7, 0x4890, 0x45E6, 0x42FA, 0x3FCE, 0x3C64, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC76E, 0xC3BC, 0xC043, 0xBD06, 0xBA08, 0xB749, 0xB4CD, 0xB295, 0xB0A2, 0xAEF6, 0xAD92, 0xAC76, 0xABA3, 0xAB19, 0xAAD8,
        0xAAE0, 0xAB30, 0xABC8, 0xACA7, 0xADCB, 0xAF33, 0xB0DE, 0xB2C9, 0xB4F3, 0xB758, 0xB9F8, 0xBCCF, 0xBFDA, 0xC316, 0xC681, 0xCA17,
        0xCDD5, 0xD1B7, 0xD5BA, 0xD9D9, 0xDE12, 0xE261, 0xE6C2, 0xEB30, 0xEFA8, 0xF427, 0xF8A8, 0xFD27, 0x019F, 0x0610, 0x0A73, 0x0EC6,
        0x1304, 0x172B, 0x1B37, 0x1F24, 0x22F0, 0x2697, 0x2A16, 0x2D6C, 0x3095, 0x338F, 0x3658, 0x38ED, 0x3B4D, 0x3D76, 0x3F67, 0x411E,
        0x429B, 0x43DD, 0x44E2, 0x45AB, 0x4637, 0x4686, 0x4698, 0x466E, 0x4609, 0x4569, 0x448E, 0x437B, 0x4231, 0x40B0, 0x3EFC, 0x3D15,
        0x3AFD, 0x38B7, 0x3646, 0x33AB, 0x30E8, 0x2E02, 0x2AFA, 0x27D3, 0x2491, 0x2135, 0x1DC4, 0x1A41, 0x16AE, 0x130E, 0x0F66, 0x0BB8,
        0x0807, 0x0457, 0x00AA, 0xFD05, 0xF969, 0xF5DA, 0xF25B, 0xEEEE, 0xEB97, 0xE859, 0xE535, 0xE22E, 0xDF47, 0xDC82, 0xD9E1, 0xD765,
        0xD512, 0xD2E8, 0xD0E9, 0xCF16, 0xCD71, 0xCBFB, 0xCAB4, 0xC99D, 0xC8B6, 0xC801, 0xC77D, 0xC72B, 0xC709, 0xC719, 0xC759, 0xC7C8,
        0xC867, 0xC934, 0xCA2E, 0xCB53, 0xCCA3, 0xCE1C, 0xCFBC, 0xD182, 0xD36C, 0xD577, 0xD7A2, 0xD9EB, 0xDC4F, 0xDECC, 0xE160, 0xE408,
        0xE6C2, 0xE98B, 0xEC61, 0xEF41, 0xF229, 0xF516, 0xF806, 0xFAF6, 0xFDE3, 0x00CA, 0x03AA, 0x0681, 0x094B, 0x0C07, 0x0EB2, 0x114B,
        0x13CE, 0x163A, 0x188D, 0x1AC6, 0x1CE3, 0x1EE2, 0x20C1, 0x2280, 0x241D, 0x2598, 0x26EE, 0x2820, 0x292D, 0x2A14, 0x2AD5, 0x2B6F,
        0x2BE2, 0x2C2F, 0x2C55, 0x2C55, 0x2C2F, 0x2BE4, 0x2B74, 0x2AE0, 0x2A28, 0x294F, 0x2854, 0x2739, 0x2600, 0x24A9, 0x2337, 0x21AA,
        0x2004, 0x1E47, 0x1C76, 0x1A90, 0x1899, 0x1692, 0x147E, 0x125D, 0x1033, 0x0E00, 0x0BC8, 0x098B, 0x074D, 0x050F, 0x02D2, 0x009A,
        0xFE68, 0xFC3C, 0xFA1A, 0xF804, 0xF5FA, 0xF3FE, 0xF212, 0xF038, 0xEE71, 0xECBE, 0xEB20, 0xE999, 0xE82A, 0xE6D4, 0xE597, 0xE474,
        0xE36D, 0xE281, 0xE1B1, 0xE0FE, 0xE067, 0xDFED, 0xDF91, 0xDF51, 0xDF2E, 0xDF28, 0xDF3E, 0xDF70, 0xDFBE, 0xE026, 0xE0A8, 0xE144,
        0xE1F8, 0xE2C4, 0xE3A6, 0xE49E, 0xE5AB, 0xE6CA, 0xE7FC, 0xE93E, 0xEA90, 0xEBF0, 0xED5D, 0xEED5, 0xF057, 0xF1E1, 0xF373, 0xF509,
        0xF6A4, 0xF842, 0xF9E0, 0xFB7F, 0xFD1B, 0xFEB5, 0x0049, 0x01D8, 0x0360, 0x04E0, 0x0656, 0x07C1, 0x0921, 0x0A74, 0x0BB9, 0x0CEF,
        0x0E15, 0x0F2C, 0x1031, 0x1124, 0x1205, 0x12D2, 0x138D, 0x1434, 0x14C7, 0x1545, 0x15B0, 0x1605, 0x1647, 0x1674, 0x168D, 0x1692,
        0x1683, 0x1662, 0x162D, 0x15E5, 0x158C, 0x1522, 0x14A6, 0x141B, 0x1381, 0x12D8, 0x1221, 0x115E, 0x108F, 0x0FB4, 0x0ED0, 0x0DE3,
        0x0CED, 0x0BF1, 0x0AEE, 0x09E6, 0x08DA, 0x07CB, 0x06BA, 0x05A8, 0x0496, 0x0384, 0x0275, 0x0168, 0x005F, 0xFF5B, 0xFE5C, 0xFD63,
        0xFC70, 0xFB86, 0xFAA4, 0xF9CA, 0xF8FB, 0xF835, 0xF77B, 0xF6CB, 0xF627, 0xF58F, 0xF503, 0xF483, 0xF410, 0xF3AB, 0xF352, 0xF306,
        0xF2C7, 0xF295, 0xF271, 0xF259, 0xF24D, 0xF24E, 0xF25C, 0xF275, 0xF299, 0xF2C9, 0xF304, 0xF348, 0xF397, 0xF3EF, 0xF450, 0xF4B9,
        0xF529, 0xF5A1, 0xF620, 0xF6A4, 0xF72D, 0xF7BB, 0xF84D, 0xF8E3, 0xF97B, 0xFA15, 0xFAB1, 0xFB4E, 0xFBEB, 0xFC88, 0xFD23, 0xFDBE,
        0xFE56, 0xFEEC, 0xFF7E, 0x000C, 0x0098, 0x011E, 0x01A0, 0x021D, 0x0295, 0x0306, 0x0371, 0x03D7, 0x0435, 0x048D, 0x04DE, 0x0528,
        0x056A, 0x05A6, 0x05DA, 0x0607, 0x062D, 0x064C, 0x0664, 0x0675, 0x0680, 0x0683, 0x0681, 0x0678, 0x0669, 0x0654, 0x063A, 0x061B,
        0x05F7, 0x05CF, 0x05A2, 0x0572, 0x053E, 0x0506, 0x04CC, 0x048F, 0x0451, 0x0410, 0x03CE, 0x038B, 0x0347, 0x0303, 0x02BE, 0x027A,
        0x0236, 0x01F3, 0x01B1, 0x0171, 0x0132, 0x00F5, 0x00BA, 0x0081, 0x004A, 0x0016, 0xFFE6, 0xFFB8, 0xFF8C, 0xFF64, 0xFF3E, 0xFF1C,
        0xFEFD, 0xFEE1, 0xFEC8, 0xFEB3, 0xFEA0, 0xFE91, 0xFE85, 0xFE7B, 0xFE74, 0xFE71, 0xFE6F, 0xFE70, 0xFE74, 0xFE79, 0xFE80, 0xFE8A,
        0xFE95, 0xFEA1, 0xFEAF, 0xFEBE, 0xFECE, 0xFEDE, 0xFEF0, 0xFF01, 0xFF13, 0xFF26, 0xFF38, 0xFF49, 0xFF5B, 0xFF6C, 0xFF7C, 0xFF8C,
        0xFF9B, 0xFFA9, 0xFFB6, 0xFFC3, 0xFFCE, 0xFFD8, 0xFFE0, 0xFFE8, 0xFFEE, 0xFFF4, 0xFFF8, 0xFFFC, 0xFFFE, 0xFFFF, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFC, 0xFFFB, 0xFFF9, 0xFFF7, 0xFFF5, 0xFFF3, 0xFFF0, 0xFFED, 0xFFEA,
        0xFFE7, 0xFFE4, 0xFFE0, 0xFFDC, 0xFFD9, 0xFFD5, 0xFFD1, 0xFFCD, 0xFFC9, 0xFFC6, 0xFFC2, 0xFFBF, 0xFFBC, 0xFFB9, 0xFFB6, 0xFFB4,
        0xFFB2, 0xFFB1, 0xFFB0, 0xFFB0, 0xFFB0, 0xFFB2, 0xFFB3, 0xFFB6, 0xFFB9, 0xFFBE, 0xFFC3, 0xFFC9, 0xFFD0, 0xFFD7, 0xFFE0, 0xFFEA,
        0xFFF5, 0x0000, 0x000D, 0x001A, 0x0029, 0x0039, 0x004A, 0x005B, 0x006E, 0x0081, 0x0096, 0x00AB, 0x00C0, 0x00D7, 0x00EE, 0x0105,
        0x011D, 0x0135, 0x014D, 0x0166, 0x017E, 0x0197, 0x01AF, 0x01C7, 0x01DF, 0x01F6, 0x020D, 0x0222, 0x0237, 0x024B, 0x025E, 0x026F,
        0x027F, 0x028E, 0x029B, 0x02A6, 0x02AF, 0x02B6, 0x02BB, 0x02BE, 0x02BF, 0x02BD, 0x02B8, 0x02B2, 0x02A8, 0x029B, 0x028C, 0x027A,
        0x0265, 0x024D, 0x0232, 0x0214, 0x01F3, 0x01CF, 0x01A9, 0x017F, 0x0152, 0x0122, 0x00F0, 0x00BB, 0x0083, 0x0049, 0x000C, 0xFFCE,
        0xFF8D, 0xFF4A, 0xFF05, 0xFEBE, 0xFE76, 0xFE2D, 0xFDE2, 0xFD97, 0xFD4B, 0xFCFF, 0xFCB2, 0xFC65, 0xFC19, 0xFBCD, 0xFB82, 0xFB39,
        0xFAF0, 0xFAA9, 0xFA65, 0xFA22, 0xF9E2, 0xF9A4, 0xF96A, 0xF933, 0xF900, 0xF8D0, 0xF8A5, 0xF87D, 0xF85B, 0xF83D, 0xF824, 0xF811,
        0xF803, 0xF7FB, 0xF7F9, 0xF7FC, 0xF806, 0xF816, 0xF82C, 0xF849, 0xF86D, 0xF897, 0xF8C8, 0xF8FF, 0xF93D, 0xF982, 0xF9CE, 0xFA20,
        0xFA78, 0xFAD7, 0xFB3C, 0xFBA7, 0xFC18, 0xFC8F, 0xFD0B, 0xFD8C, 0xFE13, 0xFE9E, 0xFF2D, 0xFFC0, 0x0056, 0x00F0, 0x018E, 0x022D,
        0x02CF, 0x0373, 0x0417, 0x04BD, 0x0563, 0x0608, 0x06AD, 0x0751, 0x07F2, 0x0892, 0x092F, 0x09C9, 0x0A5F, 0x0AF0, 0x0B7D, 0x0C05,
        0x0C86, 0x0D02, 0x0D76, 0x0DE3, 0x0E49, 0x0EA6, 0x0EFB, 0x0F46, 0x0F88, 0x0FC1, 0x0FEF, 0x1012, 0x102B, 0x1038, 0x103B, 0x1031,
        0x101C, 0x0FFB, 0x0FCE, 0x0F94, 0x0F4E, 0x0EFD, 0x0E9E, 0x0E34, 0x0DBD, 0x0D3B, 0x0CAC, 0x0C12, 0x0B6D, 0x0ABC, 0x0A01, 0x093A,
        0x086A, 0x0790, 0x06AD, 0x05C1, 0x04CD, 0x03D0, 0x02CD, 0x01C3, 0x00B4, 0xFFA0, 0xFE86, 0xFD69, 0xFC49, 0xFB26, 0xFA02, 0xF8DD,
        0xF7B9, 0xF695, 0xF573, 0xF454, 0xF338, 0xF220, 0xF10E, 0xF001, 0xEEFC, 0xEDFE, 0xED09, 0xEC1D, 0xEB3C, 0xEA65, 0xE99A, 0xE8DC,
        0xE82B, 0xE788, 0xE6F4, 0xE66E, 0xE5F9, 0xE594, 0xE541, 0xE4FE, 0xE4CE, 0xE4B0, 0xE4A5, 0xE4AC, 0xE4C7, 0xE4F6, 0xE538, 0xE58D,
        0xE5F7, 0xE674, 0xE705, 0xE7AA, 0xE862, 0xE92D, 0xEA0C, 0xEAFC, 0xEBFF, 0xED14, 0xEE3A, 0xEF70, 0xF0B7, 0xF20C, 0xF370, 0xF4E3,
        0xF661, 0xF7ED, 0xF983, 0xFB23, 0xFCCD, 0xFE7E, 0x0036, 0x01F4, 0x03B8, 0x057E, 0x0747, 0x0912, 0x0ADC, 0x0CA4, 0x0E6A, 0x102D,
        0x11E9, 0x13A0, 0x154E, 0x16F3, 0x188E, 0x1A1D, 0x1B9F, 0x1D13, 0x1E78, 0x1FCC, 0x210E, 0x223E, 0x235A, 0x2460, 0x2551, 0x262B,
        0x26EE, 0x2798, 0x2828, 0x289F, 0x28FA, 0x293B, 0x2960, 0x2968, 0x2955, 0x2924, 0x28D6, 0x286B, 0x27E2, 0x273D, 0x267A, 0x259A,
        0x249E, 0x2385, 0x2250, 0x2100, 0x1F95, 0x1E10, 0x1C72, 0x1ABB, 0x18EC, 0x1707, 0x150C, 0x12FD, 0x10DA, 0x0EA6, 0x0C61, 0x0A0D,
        0x07AB, 0x053D, 0x02C4, 0x0041, 0xFDB9, 0xFB2A, 0xF896, 0xF601, 0xF36A, 0xF0D6, 0xEE44, 0xEBB7, 0xE931, 0xE6B3, 0xE440, 0xE1D9,
        0xDF80, 0xDD37, 0xDB00, 0xD8DC, 0xD6CD, 0xD4D4, 0xD2F4, 0xD12E, 0xCF83, 0xCDF5, 0xCC85, 0xCB35, 0xCA05, 0xC8F7, 0xC80D, 0xC746,
        0xC6A5, 0xC629, 0xC5D3, 0xC5A5, 0xC59E, 0xC5C0, 0xC609, 0xC67C, 0xC717, 0xC7DB, 0xC8C7, 0xC9DC, 0xCB19, 0xCC7D, 0xCE09, 0xCFBB,
        0xD192, 0xD38E, 0xD5AD, 0xD7EF, 0xDA53, 0xDCD6, 0xDF78, 0xE237, 0xE511, 0xE805, 0xEB10, 0xEE32, 0xF168, 0xF4B0, 0xF808, 0xFB6D,
        0xFEDF, 0x0258, 0x05DA, 0x0960, 0x0CE8, 0x1070, 0x13F5, 0x1776, 0x1AEE, 0x1E5D, 0x21BF, 0x2513, 0x2854, 0x2B82, 0x2E9A, 0x319A,
        0x347E, 0x3745, 0x39ED, 0x3C74, 0x3ED7, 0x4115, 0x432C, 0x4519, 0x46DC, 0x4872, 0x49DA, 0x4B13, 0x4C1B, 0x4CF2, 0x4D96, 0x4E06,
        0x4E42, 0x4E49, 0x4E1A, 0x4DB5, 0x4D1B, 0x4C4A, 0x4B43, 0x4A06, 0x4894, 0x46ED, 0x4511, 0x4303, 0x40C1, 0x3E4F, 0x3BAC, 0x38DB,
        0x35DC, 0x32B2, 0x2F5E, 0x2BE3, 0x2842, 0x247D, 0x2097, 0x1C93, 0x1872, 0x1437, 0x0FE5, 0x0B80, 0x0708, 0x0283, 0xFDF2, 0xF959,
        0xF4C6, 0xF03A, 0xEBBA, 0xE747, 0xE2E4, 0xDE95, 0xDA5D, 0xD63E, 0xD23B, 0xCE57, 0xCA95, 0xC6F6, 0xC37E, 0xC02F, 0xBD0B, 0xBA14,
        0xB74C, 0xB4B5, 0xB251, 0xB021, 0xAE27, 0xAC64, 0xAAD9, 0xA988, 0xA871, 0xA795, 0xA6F5, 0xA690, 0xA668, 0xA67D, 0xA6CD, 0xA75A,
        0xA823, 0xA926, 0xAA65, 0xABDD, 0xAD8D, 0xAF75, 0xB194, 0xB3E7, 0xB66E, 0xB926, 0xBC0E, 0xBF24, 0xC265, 0xC5D0, 0xC962, 0xCD19,
        0xD0F3, 0xD4EC, 0xD902, 0xDD32, 0xE17A, 0xE5D6, 0xEA44, 0xEEC1, 0xF349, 0xF7DA, 0xFC70, 0x0108, 0x05A0, 0x0A34, 0x0EC1, 0x1345,
        0x17BB, 0x1C22, 0x2075, 0x24B3, 0x28D7, 0x2CE1, 0x30CC, 0x3496, 0x383D, 0x3BBE, 0x3F16, 0x4244, 0x4546, 0x4819, 0x4ABB, 0x4D2A,
        0x4F66, 0x516D, 0x533C, 0x54D3, 0x5631, 0x5756, 0x583F, 0x58EC, 0x595E, 0x5994, 0x598D, 0x594A, 0x58CB, 0x5810, 0x5719, 0x55E8,
        0x547D, 0x52D9, 0x50FD, 0x4EEB, 0x4CA3, 0x4A28, 0x477A, 0x449D, 0x4191, 0x3E5A, 0x3AF8, 0x376E, 0x33BF, 0x2FED, 0x2BFB, 0x27EC,
        0x23C1, 0x1F7E, 0x1B26, 0x16BC, 0x1242, 0x0DBC, 0x092D, 0x0498, 0x0000, 0xFB68, 0xF6D3, 0xF244, 0xEDBE, 0xE944, 0xE4DA, 0xE082,
        0xDC3F, 0xD814, 0xD405, 0xD013, 0xCC41, 0xC892, 0xC508, 0xC1A6, 0xBE6F, 0xBB63, 0xB886, 0xB5D8, 0xB35D, 0xB115, 0xAF03, 0xAD27,
        0xAB83, 0xAA18, 0xA8E7, 0xA7F0, 0xA735, 0xA6B6, 0xA673, 0xA66C, 0xA6A2, 0xA714, 0xA7C1, 0xA8AA, 0xA9CF, 0xAB2D, 0xACC4, 0xAE93,
        0xB09A, 0xB2D6, 0xB545, 0xB7E7, 0xBABA, 0xBDBC, 0xC0EA, 0xC442, 0xC7C3, 0xCB6A, 0xCF34, 0xD31F, 0xD729, 0xDB4D, 0xDF8B, 0xE3DE,
        0xE845, 0xECBB, 0xF13F, 0xF5CC, 0xFA60, 0xFEF8, 0x0390, 0x0826, 0x0CB7, 0x113F, 0x15BC, 0x1A2A, 0x1E86, 0x22CE, 0x26FE, 0x2B14,
        0x2F0D, 0x32E7, 0x369E, 0x3A30, 0x3D9B, 0x40DC, 0x43F2, 0x46DA, 0x4992, 0x4C19, 0x4E6C, 0x508B, 0x5273, 0x5423, 0x559B, 0x56DA,
        0x57DD, 0x58A6, 0x5933, 0x5983, 0x5998, 0x5970, 0x590B, 0x586B, 0x578F, 0x5678, 0x5527, 0x539C, 0x51D9, 0x4FDF, 0x4DAF, 0x4B4B,
        0x48B4, 0x45EC, 0x42F5, 0x3FD1, 0x3C82, 0x390A, 0x356B, 0x31A9, 0x2DC5, 0x29C2, 0x25A3, 0x216B, 0x1D1C, 0x18B9, 0x1446, 0x0FC6,
        0x0B3A, 0x06A7, 0x0210, 0xFD78, 0xF8E1, 0xF44F, 0xEFC4, 0xEB45, 0xE6D3, 0xE273, 0xDE26, 0xD9F0, 0xD5D4, 0xD1D4, 0xCDF4, 0xCA35,
        0xC69A, 0xC326, 0xBFDB, 0xBCBB, 0xB9C9, 0xB706, 0xB474, 0xB215, 0xAFEB, 0xADF6, 0xAC39, 0xAAB4, 0xA969, 0xA858, 0xA782, 0xA6E8,
        0xA68A, 0xA668, 0xA682, 0xA6D9, 0xA76C, 0xA83A, 0xA944, 0xAA88, 0xAC06, 0xADBD, 0xAFAA, 0xB1CE, 0xB427, 0xB6B3, 0xB970, 0xBC5D,
        0xBF77, 0xC2BD, 0xC62C, 0xC9C2, 0xCD7C, 0xD159, 0xD555, 0xD96E, 0xDDA1, 0xE1EB, 0xE649, 0xEAB9, 0xEF37, 0xF3C0, 0xF851, 0xFCE8,
        0x0180, 0x0618, 0x0AAB, 0x0F38, 0x13BA, 0x182F, 0x1C93, 0x20E5, 0x2520, 0x2942, 0x2D49, 0x3130, 0x34F7, 0x389A, 0x3C17, 0x3F6B,
        0x4295, 0x4592, 0x4860, 0x4AFD, 0x4D67, 0x4F9E, 0x519E, 0x5368, 0x54FA, 0x5652, 0x5770, 0x5853, 0x58FB, 0x5967, 0x5996, 0x5989,
        0x5940, 0x58BA, 0x57F9, 0x56FD, 0x55C5, 0x5455, 0x52AB, 0x50C9, 0x4EB1, 0x4C64, 0x49E4, 0x4732, 0x4450, 0x413F, 0x3E03, 0x3A9D,
        0x3710, 0x335D, 0x2F88, 0x2B93, 0x2780, 0x2353, 0x1F0E, 0x1AB4, 0x1648, 0x11CD, 0x0D46, 0x08B6, 0x0420, 0xFF88, 0xFAF0, 0xF65B,
        0xF1CD, 0xED48, 0xE8D0, 0xE467, 0xE012, 0xDBD1, 0xD7A9, 0xD39C, 0xCFAD, 0xCBDF, 0xC834, 0xC4AE, 0xC150, 0xBE1D, 0xBB16, 0xB83D,
        0xB595, 0xB31F, 0xB0DD, 0xAED0, 0xACFA, 0xAB5C, 0xA9F6, 0xA8CB, 0xA7DB, 0xA726, 0xA6AC, 0xA66F, 0xA66F, 0xA6AB, 0xA723, 0xA7D6,
        0xA8C6, 0xA9F0, 0xAB54, 0xACF1, 0xAEC6, 0xB0D2, 0xB313, 0xB588, 0xB82F, 0xBB07, 0xBE0D, 0xC13F, 0xC49C, 0xC821, 0xCBCB, 0xCF99,
        0xD387, 0xD794, 0xDBBB, 0xDFFB, 0xE451, 0xE8B9, 0xED31, 0xF1B5, 0xF643, 0xFAD8, 0xFF70, 0x0408, 0x089E, 0x0D2E, 0x11B5, 0x1630,
        0x1A9D, 0x1EF7, 0x233D, 0x276A, 0x2B7E, 0x2F73, 0x3349, 0x36FD, 0x3A8B, 0x3DF2, 0x412F, 0x4440, 0x4723, 0x49D6, 0x4C58, 0x4EA6,
        0x50BF, 0x52A1, 0x544C, 0x55BE, 0x56F7, 0x57F5, 0x58B7, 0x593E, 0x5988, 0x5996, 0x5968, 0x58FE, 0x5857, 0x5775, 0x5658, 0x5501,
        0x5371, 0x51A8, 0x4FA9, 0x4D73, 0x4B0A, 0x486E, 0x45A1, 0x42A5, 0x3F7C, 0x3C29, 0x38AD, 0x350A, 0x3144, 0x2D5D, 0x2957, 0x2536,
        0x20FB, 0x1CAA, 0x1846, 0x13D1, 0x0F4F, 0x0AC3, 0x0630, 0x0198, 0xFD00, 0xF869, 0xF3D8, 0xEF4E, 0xEAD0, 0xE660, 0xE201, 0xDDB7,
        0xD984, 0xD56A, 0xD16E, 0xCD90, 0xC9D5, 0xC63E, 0xC2CE, 0xBF88, 0xBC6C, 0xB97F, 0xB6C1, 0xB434, 0xB1DA, 0xAFB5, 0xADC6, 0xAC0F,
        0xAA90, 0xA94A, 0xA83F, 0xA770, 0xA6DB, 0xA683, 0xA668, 0xA688, 0xA6E5, 0xA77E, 0xA853, 0xA963, 0xAAAD, 0xAC30, 0xADEC, 0xAFE0,
        0xB209, 0xB467, 0xB6F8, 0xB9BA, 0xBCAC, 0xBFCA, 0xC314, 0xC688, 0xCA22, 0xCDE0, 0xD1C0, 0xD5BF, 0xD9DA, 0xDE10, 0xE25C, 0xE6BC,
        0xEB2D, 0xEFAD, 0xF437, 0xF8C9, 0xFD60, 0x01F8, 0x068F, 0x0B22, 0x0FAE, 0x142F, 0x18A2, 0x1D05, 0x2154, 0x258D, 0x29AD, 0x2DB0,
        0x3195, 0x3558, 0x38F7, 0x3C70, 0x3FC0, 0x42E5, 0x45DD, 0x48A6, 0x4B3E, 0x4DA3, 0x4FD4, 0x51D0, 0x5394, 0x551F, 0x5672, 0x578A,
        0x5867, 0x5909, 0x596E, 0x5997, 0x5984, 0x5935, 0x58A9, 0x57E2, 0x56DF, 0x55A2, 0x542C, 0x527C, 0x5095, 0x4E78, 0x4C25, 0x49A0,
        0x46E9, 0x4402, 0x40ED, 0x3DAC, 0x3A42, 0x36B1, 0x32FA, 0x2F22, 0x2B29, 0x2714, 0x22E4, 0x1E9D, 0x1A41, 0x15D3, 0x1157, 0x0CCF,
        0x083E, 0x03A8, 0xFF10, 0xFA78, 0xF5E4, 0xF156, 0xECD3, 0xE85C, 0xE3F5, 0xDFA1, 0xDB63, 0xD73E, 0xD334, 0xCF48, 0xCB7D, 0xC7D6,
        0xC454, 0xC0FB, 0xBDCC, 0xBAC9, 0xB7F6, 0xB553, 0xB2E2, 0xB0A5, 0xAE9D, 0xACCD, 0xAB34, 0xA9D5, 0xA8B0, 0xA7C5, 0xA716, 0xA6A3,
        0xA66D, 0xA672, 0xA6B4, 0xA732, 0xA7EC, 0xA8E1, 0xAA11, 0xAB7B, 0xAD1E, 0xAEF9, 0xB10A, 0xB351, 0xB5CB, 0xB877, 0xBB54, 0xBE5E,
        0xC195, 0xC4F6, 0xC87F, 0xCC2D, 0xCFFE, 0xD3F0, 0xD7FF, 0xDC29, 0xE06B, 0xE4C3, 0xE92D, 0xEDA6, 0xF22C, 0xF6BB, 0xFB50, 0xFFE8,
        0x0480, 0x0915, 0x0DA5, 0x122B, 0x16A5, 0x1B0F, 0x1F68, 0x23AB, 0x27D6, 0x2BE6, 0x2FD9, 0x33AC, 0x375B, 0x3AE6, 0x3E48, 0x4181,
        0x448E, 0x476C, 0x4A1A, 0x4C96, 0x4EDF, 0x50F3, 0x52D0, 0x5475, 0x55E1, 0x5713, 0x580B, 0x58C7, 0x5948, 0x598C, 0x5994, 0x5960,
        0x58EF, 0x5843, 0x575B, 0x5638, 0x54DB, 0x5345, 0x5177, 0x4F71, 0x4D37, 0x4AC8, 0x4827, 0x4555, 0x4255, 0x3F27, 0x3BD0, 0x384F,
        0x34A9, 0x30E0, 0x2CF6, 0x28ED, 0x24C8, 0x208B, 0x1C38, 0x17D2, 0x135C, 0x0ED9, 0x0A4C, 0x05B8, 0x0120, 0xFC88, 0xF7F2, 0xF361,
        0xEED8, 0xEA5B, 0xE5ED, 0xE190, 0xDD48, 0xD917, 0xD501, 0xD107, 0xCD2D, 0xC975, 0xC5E2, 0xC277, 0xBF34, 0xBC1E, 0xB935, 0xB67C,
        0xB3F4, 0xB1A0, 0xAF80, 0xAD97, 0xABE5, 0xAA6C, 0xA92C, 0xA827, 0xA75E, 0xA6D0, 0xA67E, 0xA668, 0xA68F, 0xA6F2, 0xA791, 0xA86C,
        0xA982, 0xAAD2, 0xAC5B, 0xAE1D, 0xB016, 0xB245, 0xB4A8, 0xB73E, 0xBA05, 0xBCFB, 0xC01E, 0xC36D, 0xC6E4, 0xCA82, 0xCE43, 0xD227,
        0xD629, 0xDA47, 0xDE7F, 0xE2CD, 0xE72F, 0xEBA2, 0xF023, 0xF4AE, 0xF941, 0xFDD8, 0x0270, 0x0707, 0x0B9A, 0x1024, 0x14A4, 0x1916,
        0x1D77, 0x21C4, 0x25FA, 0x2A17, 0x2E17, 0x31F8, 0x35B8, 0x3953, 0x3CC8, 0x4014, 0x4335, 0x4628, 0x48EC, 0x4B7F, 0x4DDF, 0x500B,
        0x5200, 0x53BF, 0x5545, 0x5691, 0x57A3, 0x587A, 0x5916, 0x5975, 0x5998, 0x597F, 0x5929, 0x5898, 0x57CA, 0x56C2, 0x557F, 0x5402,
        0x524D, 0x5060, 0x4E3D, 0x4BE6, 0x495B, 0x469F, 0x43B3, 0x409A, 0x3D55, 0x39E7, 0x3651, 0x3297, 0x2EBC, 0x2AC0, 0x26A8, 0x2275,
        0x1E2C, 0x19CE, 0x155F, 0x10E1, 0x0C58, 0x07C7, 0x0330, 0xFE98, 0xFA00, 0xF56D, 0xF0E0, 0xEC5E, 0xE7E8, 0xE383, 0xDF32, 0xDAF6,
        0xD6D3, 0xD2CC, 0xCEE4, 0xCB1C, 0xC779, 0xC3FB, 0xC0A6, 0xBD7B, 0xBA7D, 0xB7AF, 0xB510, 0xB2A5, 0xB06D, 0xAE6C, 0xACA1, 0xAB0E,
        0xA9B5, 0xA895, 0xA7B1, 0xA708, 0xA69B, 0xA66A, 0xA676, 0xA6BE, 0xA742, 0xA802, 0xA8FE, 0xAA34, 0xABA3, 0xAD4C, 0xAF2C, 0xB143,
        0xB38F, 0xB60E, 0xB8C0, 0xBBA1, 0xBEB0, 0xC1EC, 0xC551, 0xC8DD, 0xCC8F, 0xD064, 0xD458, 0xD86B, 0xDC97, 0xE0DC, 0xE535, 0xE9A1,
        0xEE1C, 0xF2A3, 0xF732, 0xFBC8, 0x0060, 0x04F8, 0x098D, 0x0E1B, 0x12A0, 0x1719, 0x1B82, 0x1FD8, 0x2419, 0x2841, 0x2C4F, 0x303E,
        0x340E, 0x37BA, 0x3B40, 0x3E9E, 0x41D3, 0x44DB, 0x47B4, 0x4A5D, 0x4CD5, 0x4F18, 0x5126, 0x52FD, 0x549D, 0x5603, 0x572F, 0x5821,
        0x58D7, 0x5952, 0x5990, 0x5992, 0x5957, 0x58E1, 0x582E, 0x5740, 0x5617, 0x54B4, 0x5318, 0x5144, 0x4F3A, 0x4CF9, 0x4A86, 0x47DF,
        0x4509, 0x4204, 0x3ED2, 0x3B76, 0x37F2, 0x3448, 0x307B, 0x2C8D, 0x2882, 0x245B, 0x201B, 0x1BC6, 0x175E, 0x12E7, 0x0E62, 0x09D4,
        0x0540, 0x00A8, 0xFC10, 0xF77A, 0xF2EA, 0xEE62, 0xE9E7, 0xE57A, 0xE11F, 0xDCDA, 0xD8AB, 0xD497, 0xD0A1, 0xCCCA, 0xC916, 0xC587,
        0xC220, 0xBEE2, 0xBBD0, 0xB8EB, 0xB637, 0xB3B5, 0xB166, 0xAF4C, 0xAD68, 0xABBC, 0xAA48, 0xA90F, 0xA810, 0xA74C, 0xA6C5, 0xA679,
        0xA669, 0xA696, 0xA700, 0xA7A5, 0xA886, 0xA9A1, 0xAAF7, 0xAC86, 0xAE4E, 0xB04C, 0xB281, 0xB4E9, 0xB784, 0xBA50, 0xBD4B, 0xC073,
        0xC3C5, 0xC741, 0xCAE2, 0xCEA7, 0xD28E, 0xD693, 0xDAB4, 0xDEEF, 0xE33F, 0xE7A3, 0xEC17, 0xF099, 0xF525, 0xF9B9, 0xFE50, 0x02E8,
        0x077F, 0x0C11, 0x109A, 0x1519, 0x1989, 0x1DE8, 0x2233, 0x2667, 0x2A81, 0x2E7E, 0x325C, 0x3618, 0x39B0, 0x3D20, 0x4068, 0x4384,
        0x4673, 0x4932, 0x4BBF, 0x4E1A, 0x5040, 0x5230, 0x53E9, 0x5569, 0x56B0, 0x57BC, 0x588D, 0x5922, 0x597B, 0x5998, 0x5979, 0x591D,
        0x5885, 0x57B2, 0x56A4, 0x555B, 0x53D8, 0x521D, 0x502B, 0x4E03, 0x4BA6, 0x4916, 0x4655, 0x4364, 0x4046, 0x3CFD, 0x398B, 0x35F2,
        0x3234, 0x2E55, 0x2A56, 0x263B, 0x2206, 0x1DBB, 0x195B, 0x14EA, 0x106B, 0x0BE1, 0x074F, 0x02B8, 0xFE20, 0xF989, 0xF4F5, 0xF06A,
        0xEBE8, 0xE775, 0xE312, 0xDEC2, 0xDA89, 0xD669, 0xD265, 0xCE7F, 0xCABC, 0xC71C, 0xC3A2, 0xC051, 0xBD2B, 0xBA32, 0xB768, 0xB4CF,
        0xB269, 0xB036, 0xAE3A, 0xAC75, 0xAAE8, 0xA995, 0xA87B, 0xA79D, 0xA6FA, 0xA693, 0xA669, 0xA67B, 0xA6C9, 0xA753, 0xA819, 0xA91B,
        0xAA57, 0xABCC, 0xAD7A, 0xAF60, 0xB17D, 0xB3CE, 0xB653, 0xB909, 0xBBEF, 0xBF03, 0xC242, 0xC5AC, 0xC93C, 0xCCF2, 0xD0CA, 0xD4C2,
        0xD8D6, 0xDD06, 0xE14D, 0xE5A8, 0xEA15, 0xEE92, 0xF319, 0xF7AA, 0xFC40, 0x00D8, 0x0570, 0x0A04, 0x0E92, 0x1316, 0x178D, 0x1BF4,
        0x2048, 0x2487, 0x28AD, 0x2CB7, 0x30A4, 0x346F, 0x3817, 0x3B9A, 0x3EF4, 0x4224, 0x4527, 0x47FC, 0x4AA0, 0x4D12, 0x4F50, 0x5158,
        0x532A, 0x54C4, 0x5624, 0x574B, 0x5836, 0x58E7, 0x595B, 0x5993, 0x598F, 0x594E, 0x58D1, 0x5818, 0x5724, 0x55F5, 0x548D, 0x52EB,
        0x5111, 0x4F01, 0x4CBC, 0x4A43, 0x4797, 0x44BC, 0x41B2, 0x3E7C, 0x3B1C, 0x3794, 0x33E6, 0x3016, 0x2C25, 0x2817, 0x23ED, 0x1FAB,
        0x1B54, 0x16EA, 0x1271, 0x0DEC, 0x095D, 0x04C8, 0x0030, 0xFB98, 0xF703, 0xF273, 0xEDED, 0xE973, 0xE508, 0xE0AF, 0xDC6B, 0xD83F,
        0xD42F, 0xD03B, 0xCC68, 0xC8B8, 0xC52C, 0xC1C9, 0xBE8F, 0xBB82, 0xB8A3, 0xB5F3, 0xB376, 0xB12C, 0xAF18, 0xAD3A, 0xAB93, 0xAA26,
        0xA8F2, 0xA7F9, 0xA73C, 0xA6BA, 0xA674, 0xA66B, 0xA69E, 0xA70E, 0xA7B9, 0xA8A0, 0xA9C2, 0xAB1D, 0xACB2, 0xAE7F, 0xB084, 0xB2BD,
        0xB52B, 0xB7CB, 0xBA9C, 0xBD9B, 0xC0C8, 0xC41F, 0xC79E, 0xCB43, 0xCF0C, 0xD2F6, 0xD6FE, 0xDB22, 0xDF5E, 0xE3B1, 0xE817, 0xEC8C,
        0xF10F, 0xF59C, 0xFA30, 0xFEC8, 0x0360, 0x07F6, 0x0C88, 0x1110, 0x158D, 0x19FC, 0x1E59, 0x22A2, 0x26D3, 0x2AEA, 0x2EE4, 0x32BF,
        0x3678, 0x3A0B, 0x3D78, 0x40BB, 0x43D3, 0x46BC, 0x4977, 0x4BFF, 0x4E55, 0x5075, 0x5260, 0x5413, 0x558D, 0x56CE, 0x57D4, 0x589F,
        0x592E, 0x5981, 0x5998, 0x5972, 0x5911, 0x5873, 0x5799, 0x5685, 0x5536, 0x53AE, 0x51ED, 0x4FF5, 0x4DC7, 0x4B65, 0x48D0, 0x460A,
        0x4315, 0x3FF2, 0x3CA5, 0x392F, 0x3592, 0x31D1, 0x2DEE, 0x29EC, 0x25CF, 0x2197, 0x1D49, 0x18E8, 0x1475, 0x0FF5, 0x0B6A, 0x06D7,
        0x0240, 0xFDA8, 0xF911, 0xF47E, 0xEFF3, 0xEB73, 0xE701, 0xE2A0, 0xDE53, 0xDA1C, 0xD5FE, 0xD1FD, 0xCE1B, 0xCA5B, 0xC6BF, 0xC349,
        0xBFFD, 0xBCDB, 0xB9E7, 0xB722, 0xB48E, 0xB22D, 0xB000, 0xAE09, 0xAC4A, 0xAAC3, 0xA975, 0xA862, 0xA78A, 0xA6ED, 0xA68C, 0xA668,
        0xA680, 0xA6D4, 0xA765, 0xA831, 0xA938, 0xAA7A, 0xABF5, 0xADAA, 0xAF95, 0xB1B7, 0xB40D, 0xB697, 0xB952, 0xBC3D, 0xBF56, 0xC29A,
        0xC607, 0xC99C, 0xCD55, 0xD130, 0xD52B, 0xD943, 0xDD74, 0xE1BE, 0xE61B, 0xEA8A, 0xEF07, 0xF390, 0xF821, 0xFCB8, 0x0150, 0x05E8,
        0x0A7C, 0x0F08, 0x138B, 0x1801, 0x1C66, 0x20B8, 0x24F4, 0x2917, 0x2D1F, 0x3108, 0x34D0, 0x3875, 0x3BF3, 0x3F49, 0x4275, 0x4573,
        0x4843, 0x4AE2, 0x4D4F, 0x4F88, 0x518B, 0x5357, 0x54EA, 0x5645, 0x5765, 0x584B, 0x58F5, 0x5963, 0x5995, 0x598B, 0x5944, 0x58C1,
        0x5802, 0x5708, 0x55D3, 0x5465, 0x52BD, 0x50DE, 0x4EC8, 0x4C7D, 0x49FF, 0x474F, 0x446F, 0x4160, 0x3E26, 0x3AC1, 0x3735, 0x3384,
        0x2FB0, 0x2BBC, 0x27AB, 0x237F, 0x1F3B, 0x1AE1, 0x1676, 0x11FC, 0x0D75, 0x08E6, 0x0450, 0xFFB8, 0xFB20, 0xF68B, 0xF1FC, 0xED77,
        0xE8FE, 0xE495, 0xE03E, 0xDBFD, 0xD7D4, 0xD3C6, 0xCFD6, 0xCC06, 0xC859, 0xC4D2, 0xC173, 0xBE3E, 0xBB35, 0xB85A, 0xB5B0, 0xB338,
        0xB0F3, 0xAEE4, 0xAD0C, 0xAB6B, 0xAA04, 0xA8D6, 0xA7E3, 0xA72C, 0xA6B0, 0xA671, 0xA66E, 0xA6A7, 0xA71C, 0xA7CE, 0xA8BB, 0xA9E2,
        0xAB44, 0xACDF, 0xAEB2, 0xB0BB, 0xB2FA, 0xB56D, 0xB812, 0xBAE8, 0xBDEC, 0xC11D, 0xC478, 0xC7FB, 0xCBA4, 0xCF71, 0xD35E, 0xD769,
        0xDB8F, 0xDFCE, 0xE423, 0xE88A, 0xED02, 0xF186, 0xF614, 0xFAA8, 0xFF40, 0x03D8, 0x086E, 0x0CFE, 0x1186, 0x1602, 0x1A6F, 0x1ECA,
        0x2310, 0x273F, 0x2B54, 0x2F4B, 0x3322, 0x36D7, 0x3A67, 0x3DCF, 0x410E, 0x4421, 0x4706, 0x49BB, 0x4C3F, 0x4E8F, 0x50AA, 0x528F,
        0x543C, 0x55B1, 0x56EB, 0x57EB, 0x58B0, 0x5939, 0x5986, 0x5997, 0x596B, 0x5903, 0x585F, 0x5780, 0x5665, 0x5510, 0x5382, 0x51BC,
        0x4FBF, 0x4D8B, 0x4B24, 0x488A, 0x45BF, 0x42C5, 0x3F9E, 0x3C4C, 0x38D2, 0x3531, 0x316D, 0x2D87, 0x2982, 0x2562, 0x2128, 0x1CD8,
        0x1874, 0x1400, 0x0F7F, 0x0AF3, 0x065F, 0x01C8, 0xFD30, 0xF899, 0xF407, 0xEF7D, 0xEAFF, 0xE68E, 0xE22F, 0xDDE3, 0xD9AF, 0xD594,
        0xD197, 0xCDB8, 0xC9FB, 0xC663, 0xC2F1, 0xBFA9, 0xBC8C, 0xB99C, 0xB6DC, 0xB44D, 0xB1F2, 0xAFCA, 0xADD9, 0xAC1F, 0xAA9E, 0xA956,
        0xA849, 0xA777, 0xA6E0, 0xA686, 0xA668, 0xA686, 0xA6E0, 0xA777, 0xA849, 0xA956, 0xAA9E, 0xAC1F, 0xADD9, 0xAFCA, 0xB1F2, 0xB44D,
        0xB6DC, 0xB99C, 0xBC8C, 0xBFA9, 0xC2F1, 0xC663, 0xC9FB, 0xCDB8, 0xD197, 0xD594, 0xD9AF, 0xDDE3, 0xE22F, 0xE68E, 0xEAFF, 0xEF7D,
        0xF407, 0xF899, 0xFD30, 0x01C8, 0x065F, 0x0AF3, 0x0F7F, 0x1400, 0x1874, 0x1CD8, 0x2128, 0x2562, 0x2982, 0x2D87, 0x316D, 0x3531,
        0x38D2, 0x3C4C, 0x3F9E, 0x42C5, 0x45BF, 0x488A, 0x4B24, 0x4D8B, 0x4FBF, 0x51BC, 0x5382, 0x5510, 0x5665, 0x5780, 0x585F, 0x5903,
        0x596B, 0x5997, 0x5986, 0x5939, 0x58B0, 0x57EB, 0x56EB, 0x55B1, 0x543C, 0x528F, 0x50AA, 0x4E8F, 0x4C3F, 0x49BB, 0x4706, 0x4421,
        0x410E, 0x3DCF, 0x3A67, 0x36D7, 0x3322, 0x2F4B, 0x2B54, 0x273F, 0x2310, 0x1ECA, 0x1A6F, 0x1602, 0x1186, 0x0CFE, 0x086E, 0x03D8,
        0xFF40, 0xFAA8, 0xF614, 0xF186, 0xED02, 0xE88A, 0xE423, 0xDFCE, 0xDB8F, 0xD769, 0xD35E, 0xCF71, 0xCBA4, 0xC7FB, 0xC478, 0xC11D,
        0xBDEC, 0xBAE8, 0xB812, 0xB56D, 0xB2FA, 0xB0BB, 0xAEB2, 0xACDF, 0xAB44, 0xA9E2, 0xA8BB, 0xA7CE, 0xA71C, 0xA6A7, 0xA66E, 0xA671,
        0xA6B0, 0xA72C, 0xA7E3, 0xA8D6, 0xAA04, 0xAB6B, 0xAD0C, 0xAEE4, 0xB0F3, 0xB338, 0xB5B0, 0xB85A, 0xBB35, 0xBE3E, 0xC173, 0xC4D2,
        0xC859, 0xCC06, 0xCFD6, 0xD3C6, 0xD7D4, 0xDBFD, 0xE03E, 0xE495, 0xE8FE, 0xED77, 0xF1FC, 0xF68B, 0xFB20, 0xFFB8, 0x0450, 0x08E6,
        0x0D75, 0x11FC, 0x1676, 0x1AE1, 0x1F3B, 0x237F, 0x27AB, 0x2BBC, 0x2FB0, 0x3384, 0x3735, 0x3AC1, 0x3E26, 0x4160, 0x446F, 0x474F,
        0x49FF, 0x4C7D, 0x4EC8, 0x50DE, 0x52BD, 0x5465, 0x55D3, 0x5708, 0x5802, 0x58C1, 0x5944, 0x598B, 0x5995, 0x5963, 0x58F5, 0x584B,
        0x5765, 0x5645, 0x54EA, 0x5357, 0x518B, 0x4F88, 0x4D4F, 0x4AE2, 0x4843, 0x4573, 0x4275, 0x3F49, 0x3BF3, 0x3875, 0x34D0, 0x3108,
        0x2D1F, 0x2917, 0x24F4, 0x20B8, 0x1C66, 0x1801, 0x138B, 0x0F08, 0x0A7C, 0x05E8, 0x0150, 0xFCB8, 0xF821, 0xF390, 0xEF07, 0xEA8A,
        0xE61B, 0xE1BE, 0xDD74, 0xD943, 0xD52B, 0xD130, 0xCD55, 0xC99C, 0xC607, 0xC29A, 0xBF56, 0xBC3D, 0xB952, 0xB697, 0xB40D, 0xB1B7,
        0xAF95, 0xADAA, 0xABF5, 0xAA7A, 0xA938, 0xA831, 0xA765, 0xA6D4, 0xA680, 0xA668, 0xA68C, 0xA6ED, 0xA78A, 0xA862, 0xA975, 0xAAC3,
        0xAC4A, 0xAE09, 0xB000, 0xB22D, 0xB48E, 0xB722, 0xB9E7, 0xBCDB, 0xBFFD, 0xC349, 0xC6BF, 0xCA5B, 0xCE1B, 0xD1FD, 0xD5FE, 0xDA1C,
        0xDE53, 0xE2A0, 0xE701, 0xEB73, 0xEFF3, 0xF47E, 0xF911, 0xFDA8, 0x0240, 0x06D7, 0x0B6A, 0x0FF5, 0x1475, 0x18E8, 0x1D49, 0x2197,
        0x25CF, 0x29EC, 0x2DEE, 0x31D1, 0x3592, 0x392F, 0x3CA5, 0x3FF2, 0x4315, 0x460A, 0x48D0, 0x4B65, 0x4DC7, 0x4FF5, 0x51ED, 0x53AE,
        0x5536, 0x5685, 0x5799, 0x5873, 0x5911, 0x5972, 0x5998, 0x5981, 0x592E, 0x589F, 0x57D4, 0x56CE, 0x558D, 0x5413, 0x5260, 0x5075,
        0x4E55, 0x4BFF, 0x4977, 0x46BC, 0x43D3, 0x40BB, 0x3D78, 0x3A0B, 0x3678, 0x32BF, 0x2EE4, 0x2AEA, 0x26D3, 0x22A2, 0x1E59, 0x19FC,
        0x158D, 0x1110, 0x0C88, 0x07F6, 0x0360, 0xFEC8, 0xFA30, 0xF59C, 0xF10F, 0xEC8C, 0xE817, 0xE3B1, 0xDF5E, 0xDB22, 0xD6FE, 0xD2F6,
        0xCF0C, 0xCB43, 0xC79E, 0xC41F, 0xC0C8, 0xBD9B, 0xBA9C, 0xB7CB, 0xB52B, 0xB2BD, 0xB084, 0xAE7F, 0xACB2, 0xAB1D, 0xA9C2, 0xA8A0,
        0xA7B9, 0xA70E, 0xA69E, 0xA66B, 0xA674, 0xA6BA, 0xA73C, 0xA7F9, 0xA8F2, 0xAA26, 0xAB93, 0xAD3A, 0xAF18, 0xB12C, 0xB376, 0xB5F3,
        0xB8A3, 0xBB82, 0xBE8F, 0xC1C9, 0xC52C, 0xC8B8, 0xCC68, 0xD03B, 0xD42F, 0xD83F, 0xDC6B, 0xE0AF, 0xE508, 0xE973, 0xEDED, 0xF273,
        0xF703, 0xFB98, 0x0030, 0x04C8, 0x095D, 0x0DEC, 0x1271, 0x16EA, 0x1B54, 0x1FAB, 0x23ED, 0x2817, 0x2C25, 0x3016, 0x33E6, 0x3794,
        0x3B1C, 0x3E7C, 0x41B2, 0x44BC, 0x4797, 0x4A43, 0x4CBC, 0x4F01, 0x5111, 0x52EB, 0x548D, 0x55F5, 0x5724, 0x5818, 0x58D1, 0x594E,
        0x598F, 0x5993, 0x595B, 0x58E7, 0x5836, 0x574B, 0x5624, 0x54C4, 0x532A, 0x5158, 0x4F50, 0x4D12, 0x4AA0, 0x47FC, 0x4527, 0x4224,
        0x3EF4, 0x3B9A, 0x3817, 0x346F, 0x30A4, 0x2CB7, 0x28AD, 0x2487, 0x2048, 0x1BF4, 0x178D, 0x1316, 0x0E92, 0x0A04, 0x0570, 0x00D8,
        0xFC40, 0xF7AA, 0xF319, 0xEE92, 0xEA15, 0xE5A8, 0xE14D, 0xDD06, 0xD8D6, 0xD4C2, 0xD0CA, 0xCCF2, 0xC93C, 0xC5AC, 0xC242, 0xBF03,
        0xBBEF, 0xB909, 0xB653, 0xB3CE, 0xB17D, 0xAF60, 0xAD7A, 0xABCC, 0xAA57, 0xA91B, 0xA819, 0xA753, 0xA6C9, 0xA67B, 0xA669, 0xA693,
        0xA6FA, 0xA79D, 0xA87B, 0xA995, 0xAAE8, 0xAC75, 0xAE3A, 0xB036, 0xB269, 0xB4CF, 0xB768, 0xBA32, 0xBD2B, 0xC051, 0xC3A2, 0xC71C,
        0xCABC, 0xCE7F, 0xD265, 0xD669, 0xDA89, 0xDEC2, 0xE312, 0xE775, 0xEBE8, 0xF06A, 0xF4F5, 0xF989, 0xFE20, 0x02B8, 0x074F, 0x0BE1,
        0x106B, 0x14EA, 0x195B, 0x1DBB, 0x2206, 0x263B, 0x2A56, 0x2E55, 0x3234, 0x35F2, 0x398B, 0x3CFD, 0x4046, 0x4364, 0x4655, 0x4916,
        0x4BA6, 0x4E03, 0x502B, 0x521D, 0x53D8, 0x555B, 0x56A4, 0x57B2, 0x5885, 0x591D, 0x5979, 0x5998, 0x597B, 0x5922, 0x588D, 0x57BC,
        0x56B0, 0x5569, 0x53E9, 0x5230, 0x5040, 0x4E1A, 0x4BBF, 0x4932, 0x4673, 0x4384, 0x4068, 0x3D20, 0x39B0, 0x3618, 0x325C, 0x2E7E,
        0x2A81, 0x2667, 0x2233, 0x1DE8, 0x1989, 0x1519, 0x109A, 0x0C11, 0x077F, 0x02E8, 0xFE50, 0xF9B9, 0xF525, 0xF099, 0xEC17, 0xE7A3,
        0xE33F, 0xDEEF, 0xDAB4, 0xD693, 0xD28E, 0xCEA7, 0xCAE2, 0xC741, 0xC3C5, 0xC073, 0xBD4B, 0xBA50, 0xB784, 0xB4E9, 0xB281, 0xB04C,
        0xAE4E, 0xAC86, 0xAAF7, 0xA9A1, 0xA886, 0xA7A5, 0xA700, 0xA696, 0xA669, 0xA679, 0xA6C5, 0xA74C, 0xA810, 0xA90F, 0xAA48, 0xABBC,
        0xAD68, 0xAF4C, 0xB166, 0xB3B5, 0xB637, 0xB8EB, 0xBBD0, 0xBEE2, 0xC220, 0xC587, 0xC916, 0xCCCA, 0xD0A1, 0xD497, 0xD8AB, 0xDCDA,
        0xE11F, 0xE57A, 0xE9E7, 0xEE62, 0xF2EA, 0xF77A, 0xFC10, 0x00A8, 0x0540, 0x09D4, 0x0E62, 0x12E7, 0x175E, 0x1BC6, 0x201B, 0x245B,
        0x2882, 0x2C8D, 0x307B, 0x3448, 0x37F2, 0x3B76, 0x3ED2, 0x4204, 0x4509, 0x47DF, 0x4A86, 0x4CF9, 0x4F3A, 0x5144, 0x5318, 0x54B4,
        0x5617, 0x5740, 0x582E, 0x58E1, 0x5957, 0x5992, 0x5990, 0x5952, 0x58D7, 0x5821, 0x572F, 0x5603, 0x549D, 0x52FD, 0x5126, 0x4F18,
        0x4CD5, 0x4A5D, 0x47B4, 0x44DB, 0x41D3, 0x3E9E, 0x3B40, 0x37BA, 0x340E, 0x303E, 0x2C4F, 0x2841, 0x2419, 0x1FD8, 0x1B82, 0x1719,
        0x12A0, 0x0E1B, 0x098D, 0x04F8, 0x0060, 0xFBC8, 0xF732, 0xF2A3, 0xEE1C, 0xE9A1, 0xE535, 0xE0DC, 0xDC97, 0xD86B, 0xD458, 0xD064,
        0xCC8F, 0xC8DD, 0xC551, 0xC1EC, 0xBEB0, 0xBBA1, 0xB8C0, 0xB60E, 0xB38F, 0xB143, 0xAF2C, 0xAD4C, 0xABA3, 0xAA34, 0xA8FE, 0xA802,
        0xA742, 0xA6BE, 0xA676, 0xA66A, 0xA69B, 0xA708, 0xA7B1, 0xA895, 0xA9B5, 0xAB0E, 0xACA1, 0xAE6C, 0xB06D, 0xB2A5, 0xB510, 0xB7AF,
        0xBA7D, 0xBD7B, 0xC0A6, 0xC3FB, 0xC779, 0xCB1C, 0xCEE4, 0xD2CC, 0xD6D3, 0xDAF6, 0xDF32, 0xE383, 0xE7E8, 0xEC5E, 0xF0E0, 0xF56D,
        0xFA00, 0xFE98, 0x0330, 0x07C7, 0x0C58, 0x10E1, 0x155F, 0x19CE, 0x1E2C, 0x2275, 0x26A8, 0x2AC0, 0x2EBC, 0x3297, 0x3651, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2F22, 0x32FA, 0x36B1, 0x3A42, 0x3DAC, 0x40ED, 0x4402, 0x46E9, 0x49A0, 0x4C25, 0x4E78, 0x5095, 0x527C, 0x542C, 0x55A2,
        0x56DF, 0x57E2, 0x58A9, 0x5935, 0x5984, 0x5997, 0x596E, 0x5909, 0x5867, 0x578A, 0x5672, 0x551F, 0x5394, 0x51D0, 0x4FD4, 0x4DA3,
        0x4B3E, 0x48A6, 0x45DD, 0x42E5, 0x3FC0, 0x3C70, 0x38F7, 0x3558, 0x3195, 0x2DB0, 0x29AD, 0x258D, 0x2154, 0x1D05, 0x18A2, 0x142F,
        0x0FAE, 0x0B22, 0x068F, 0x01F8, 0xFD60, 0xF8C9, 0xF437, 0xEFAD, 0xEB2D, 0xE6BC, 0xE25C, 0xDE10, 0xD9DA, 0xD5BF, 0xD1C0, 0xCDE0,
        0xCA22, 0xC688, 0xC314, 0xBFCA, 0xBCAC, 0xB9BA, 0xB6F8, 0xB467, 0xB209, 0xAFE0, 0xADEC, 0xAC30, 0xAAAD, 0xA963, 0xA853, 0xA77E,
        0xA6E5, 0xA688, 0xA668, 0xA683, 0xA6DB, 0xA770, 0xA83F, 0xA94A, 0xAA90, 0xAC0F, 0xADC6, 0xAFB5, 0xB1DA, 0xB434, 0xB6C1, 0xB97F,
        0xBC6C, 0xBF88, 0xC2CE, 0xC63E, 0xC9D5, 0xCD90, 0xD16E, 0xD56A, 0xD984, 0xDDB7, 0xE201, 0xE660, 0xEAD0, 0xEF4E, 0xF3D8, 0xF869,
        0xFD00, 0x0198, 0x0630, 0x0AC3, 0x0F4F, 0x13D1, 0x1846, 0x1CAA, 0x20FB, 0x2536, 0x2957, 0x2D5D, 0x3144, 0x350A, 0x38AD, 0x3C29,
        0x3F7C, 0x42A5, 0x45A1, 0x486E, 0x4B0A, 0x4D73, 0x4FA9, 0x51A8, 0x5371, 0x5501, 0x5658, 0x5775, 0x5857, 0x58FE, 0x5968, 0x5996,
        0x5988, 0x593E, 0x58B7, 0x57F5, 0x56F7, 0x55BE, 0x544C, 0x52A1, 0x50BF, 0x4EA6, 0x4C58, 0x49D6, 0x4723, 0x4440, 0x412F, 0x3DF2,
        0x3A8B, 0x36FD, 0x3349, 0x2F73, 0x2B7E, 0x276A, 0x233D, 0x1EF7, 0x1A9D, 0x1630, 0x11B5, 0x0D2E, 0x089E, 0x0408, 0xFF70, 0xFAD8,
        0xF643, 0xF1B5, 0xED31, 0xE8B9, 0xE451, 0xDFFB, 0xDBBB, 0xD794, 0xD387, 0xCF99, 0xCBCB, 0xC821, 0xC49C, 0xC13F, 0xBE0D, 0xBB07,
        0xB82F, 0xB588, 0xB313, 0xB0D2, 0xAEC6, 0xACF1, 0xAB54, 0xA9F0, 0xA8C6, 0xA7D6, 0xA723, 0xA6AB, 0xA66F, 0xA66F, 0xA6AC, 0xA726,
        0xA7DB, 0xA8CB, 0xA9F6, 0xAB5C, 0xACFA, 0xAED0, 0xB0DD, 0xB31F, 0xB595, 0xB83D, 0xBB16, 0xBE1D, 0xC150, 0xC4AE, 0xC834, 0xCBDF,
        0xCFAD, 0xD39C, 0xD7A9, 0xDBD1, 0xE012, 0xE467, 0xE8D0, 0xED48, 0xF1CD, 0xF65B, 0xFAF0, 0xFF88, 0x0420, 0x08B6, 0x0D46, 0x11CD,
        0x1648, 0x1AB4, 0x1F0E, 0x2353, 0x2780, 0x2B93, 0x2F88, 0x335D, 0x3710, 0x3A9D, 0x3E03, 0x413F, 0x4450, 0x4732, 0x49E4, 0x4C64,
        0x4EB1, 0x50C9, 0x52AB, 0x5455, 0x55C5, 0x56FD, 0x57F9, 0x58BA, 0x5940, 0x5989, 0x5996, 0x5967, 0x58FB, 0x5853, 0x5770, 0x5652,
        0x54FA, 0x5368, 0x519E, 0x4F9E, 0x4D67, 0x4AFD, 0x4860, 0x4592, 0x4295, 0x3F6B, 0x3C17, 0x389A, 0x34F7, 0x3130, 0x2D49, 0x2942,
        0x2520, 0x20E5, 0x1C93, 0x182F, 0x13BA, 0x0F38, 0x0AAB, 0x0618, 0x0180, 0xFCE8, 0xF851, 0xF3C0, 0xEF37, 0xEAB9, 0xE649, 0xE1EB,
        0xDDA1, 0xD96E, 0xD555, 0xD159, 0xCD7C, 0xC9C2, 0xC62C, 0xC2BD, 0xBF77, 0xBC5D, 0xB970, 0xB6B3, 0xB427, 0xB1CE, 0xAFAA, 0xADBD,
        0xAC06, 0xAA88, 0xA944, 0xA83A, 0xA76C, 0xA6D9, 0xA682, 0xA668, 0xA68A, 0xA6E8, 0xA782, 0xA858, 0xA969, 0xAAB4, 0xAC39, 0xADF6,
        0xAFEB, 0xB215, 0xB474, 0xB706, 0xB9C9, 0xBCBB, 0xBFDB, 0xC326, 0xC69A, 0xCA35, 0xCDF4, 0xD1D4, 0xD5D4, 0xD9F0, 0xDE26, 0xE273,
        0xE6D3, 0xEB45, 0xEFC4, 0xF44F, 0xF8E1, 0xFD78, 0x0210, 0x06A7, 0x0B3A, 0x0FC6, 0x1446, 0x18B9, 0x1D1C, 0x216B, 0x25A3, 0x29C2,
        0x2DC5, 0x31A9, 0x356B, 0x390A, 0x3C82, 0x3FD1, 0x42F5, 0x45EC, 0x48B4, 0x4B4B, 0x4DAF, 0x4FDF, 0x51D9, 0x539C, 0x5527, 0x5678,
        0x578F, 0x586B, 0x590B, 0x5970, 0x5998, 0x5983, 0x5933, 0x58A6, 0x57DD, 0x56DA, 0x559B, 0x5423, 0x5273, 0x508B, 0x4E6C, 0x4C19,
        0x4992, 0x46DA, 0x43F2, 0x40DC, 0x3D9B, 0x3A30, 0x369E, 0x32E7, 0x2F0D, 0x2B14, 0x26FE, 0x22CE, 0x1E86, 0x1A2A, 0x15BC, 0x113F,
        0x0CB7, 0x0826, 0x0390, 0xFEF8, 0xFA60, 0xF5CC, 0xF13F, 0xECBB, 0xE845, 0xE3DE, 0xDF8B, 0xDB4D, 0xD729, 0xD31F, 0xCF34, 0xCB6A,
        0xC7C3, 0xC442, 0xC0EA, 0xBDBC, 0xBABA, 0xB7E7, 0xB545, 0xB2D6, 0xB09A, 0xAE93, 0xACC4, 0xAB2D, 0xA9CF, 0xA8AA, 0xA7C1, 0xA714,
        0xA6A2, 0xA66C, 0xA673, 0xA6B6, 0xA735, 0xA7F0, 0xA8E7, 0xAA18, 0xAB83, 0xAD27, 0xAF03, 0xB115, 0xB35D, 0xB5D8, 0xB886, 0xBB63,
        0xBE6F, 0xC1A6, 0xC508, 0xC892, 0xCC41, 0xD013, 0xD405, 0xD814, 0xDC3F, 0xE082, 0xE4DA, 0xE944, 0xEDBE, 0xF244, 0xF6D3, 0xFB68,
        0x0000, 0x0498, 0x092D, 0x0DBC, 0x1242, 0x16BC, 0x1B26, 0x1F7E, 0x23C1, 0x27EC, 0x2BFB, 0x2FED, 0x33BF, 0x376E, 0x3AF8, 0x3E5A,
        0x4191, 0x449D, 0x477A, 0x4A28, 0x4CA3, 0x4EEB, 0x50FD, 0x52D9, 0x547D, 0x55E8, 0x5719, 0x5810, 0x58CB, 0x594A, 0x598D, 0x5994,
        0x595E, 0x58EC, 0x583F, 0x5756, 0x5631, 0x54D3, 0x533C, 0x516D, 0x4F66, 0x4D2A, 0x4ABB, 0x4819, 0x4546, 0x4244, 0x3F16, 0x3BBE,
        0x383D, 0x3496, 0x30CC, 0x2CE1, 0x28D7, 0x24B3, 0x2075, 0x1C22, 0x17BB, 0x1345, 0x0EC1, 0x0A34, 0x05A0, 0x0108, 0xFC70, 0xF7DA,
        0xF349, 0xEEC1, 0xEA44, 0xE5D6, 0xE17A, 0xDD32, 0xD902, 0xD4EC, 0xD0F3, 0xCD19, 0xC962, 0xC5D0, 0xC265, 0xBF24, 0xBC0E, 0xB926,
        0xB66E, 0xB3E7, 0xB194, 0xAF75, 0xAD8D, 0xABDD, 0xAA65, 0xA926, 0xA823, 0xA75A, 0xA6CD, 0xA67D, 0xA668, 0xA690, 0xA6F5, 0xA795,
        0xA871, 0xA988, 0xAAD9, 0xAC64, 0xAE27, 0xB021, 0xB251, 0xB4B5, 0xB74C, 0xBA14, 0xBD0B, 0xC02F, 0xC37E, 0xC6F6, 0xCA95, 0xCE57,
        0xD23B, 0xD63E, 0xDA5D, 0xDE95, 0xE2E4, 0xE747, 0xEBBA, 0xF03A, 0xF4C6, 0xF959, 0xFDF0, 0x0288, 0x071F, 0x0BB1, 0x103C, 0x14BB,
        0x192D, 0x1D8D, 0x21DA, 0x2610, 0x2A2C, 0x2E2C, 0x320C, 0x35CB, 0x3966, 0x3CDA, 0x4025, 0x4345, 0x4637, 0x48FA, 0x4B8C, 0x4DEB,
        0x5015, 0x520A, 0x53C7, 0x554C, 0x5697, 0x57A8, 0x587E, 0x5918, 0x5976, 0x5998, 0x597E, 0x5927, 0x5894, 0x57C6, 0x56BC, 0x5578,
        0x53FA, 0x5243, 0x5056, 0x4E32, 0x4BD9, 0x494D, 0x4690, 0x43A3, 0x4089, 0x3D43, 0x39D4, 0x363E, 0x3284, 0x2EA7, 0x2AAB, 0x2692,
        0x225F, 0x1E15, 0x19B7, 0x1547, 0x10C9, 0x0C40, 0x07AF, 0x0318, 0xFE80, 0xF9E8, 0xF555, 0xF0C8, 0xEC46, 0xE7D1, 0xE36D, 0xDF1B,
        0xDAE0, 0xD6BE, 0xD2B7, 0xCED0, 0xCB09, 0xC766, 0xC3E9, 0xC095, 0xBD6B, 0xBA6E, 0xB7A0, 0xB503, 0xB299, 0xB062, 0xAE62, 0xAC98,
        0xAB06, 0xA9AE, 0xA890, 0xA7AD, 0xA705, 0xA699, 0xA66A, 0xA677, 0xA6C0, 0xA746, 0xA807, 0xA903, 0xAA3B, 0xABAB, 0xAD55, 0xAF37,
        0xB14F, 0xB39C, 0xB61C, 0xB8CE, 0xBBB0, 0xBEC1, 0xC1FD, 0xC563, 0xC8F0, 0xCCA3, 0xD078, 0xD46D, 0xD880, 0xDCAD, 0xE0F2, 0xE54C,
        0xE9B8, 0xEE33, 0xF2BA, 0xF74A, 0xFBE0, 0x0078, 0x0510, 0x09A5, 0x0E33, 0x12B8, 0x1730, 0x1B99, 0x1FEE, 0x242F, 0x2857, 0x2C64,
        0x3053, 0x3421, 0x37CC, 0x3B52, 0x3EB0, 0x41E3, 0x44EA, 0x47C3, 0x4A6B, 0x4CE1, 0x4F23, 0x5130, 0x5306, 0x54A4, 0x560A, 0x5735,
        0x5825, 0x58DA, 0x5954, 0x5991, 0x5991, 0x5955, 0x58DD, 0x582A, 0x573A, 0x5610, 0x54AC, 0x530F, 0x513A, 0x4F2E, 0x4CED, 0x4A78,
        0x47D1, 0x44F9, 0x41F3, 0x3EC1, 0x3B64, 0x37DF, 0x3435, 0x3067, 0x2C79, 0x286C, 0x2445, 0x2005, 0x1BAF, 0x1747, 0x12CF, 0x0E4B,
        0x09BD, 0x0528, 0x0090, 0xFBF8, 0xF762, 0xF2D2, 0xEE4B, 0xE9D0, 0xE563, 0xE109, 0xDCC3, 0xD896, 0xD482, 0xD08D, 0xCCB7, 0xC903,
        0xC575, 0xC20E, 0xBED1, 0xBBC0, 0xB8DD, 0xB62A, 0xB3A8, 0xB15A, 0xAF41, 0xAD5F, 0xABB4, 0xAA42, 0xA909, 0xA80B, 0xA749, 0xA6C2,
        0xA678, 0xA66A, 0xA698, 0xA702, 0xA7A9, 0xA88B, 0xA9A8, 0xAAFF, 0xAC8F, 0xAE58, 0xB057, 0xB28D, 0xB4F6, 0xB792, 0xBA5F, 0xBD5B,
        0xC084, 0xC3D7, 0xC753, 0xCAF6, 0xCEBC, 0xD2A3, 0xD6A9, 0xDACA, 0xDF05, 0xE356, 0xE7BA, 0xEC2F, 0xF0B1, 0xF53D, 0xF9D0, 0xFE68,
        0x0300, 0x0797, 0x0C28, 0x10B2, 0x1530, 0x19A0, 0x1DFF, 0x2249, 0x267C, 0x2A96, 0x2E92, 0x3270, 0x362B, 0x39C2, 0x3D32, 0x4078,
        0x4394, 0x4681, 0x493F, 0x4BCC, 0x4E26, 0x504B, 0x523A, 0x53F1, 0x5570, 0x56B6, 0x57C1, 0x5890, 0x5925, 0x597D, 0x5998, 0x5978,
        0x591B, 0x5882, 0x57AD, 0x569D, 0x5553, 0x53D0, 0x5214, 0x5020, 0x4DF7, 0x4B99, 0x4908, 0x4646, 0x4354, 0x4036, 0x3CEC, 0x3978,
        0x35DE, 0x3220, 0x2E40, 0x2A41, 0x2626, 0x21F0, 0x1DA4, 0x1944, 0x14D3, 0x1053, 0x0BC9, 0x0737, 0x02A0, 0xFE08, 0xF971, 0xF4DE,
        0xF052, 0xEBD1, 0xE75E, 0xE2FB, 0xDEAC, 0xDA73, 0xD653, 0xD250, 0xCE6B, 0xCAA8, 0xC709, 0xC390, 0xC040, 0xBD1B, 0xBA23, 0xB75A,
        0xB4C2, 0xB25D, 0xB02C, 0xAE30, 0xAC6C, 0xAAE1, 0xA98E, 0xA876, 0xA799, 0xA6F7, 0xA692, 0xA669, 0xA67C, 0xA6CB, 0xA757, 0xA81E,
        0xA921, 0xAA5E, 0xABD4, 0xAD84, 0xAF6B, 0xB188, 0xB3DB, 0xB660, 0xB917, 0xBBFE, 0xBF13, 0xC254, 0xC5BE, 0xC94F, 0xCD06, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC648, 0xCA06, 0xCDE2, 0xD1DA, 0xD5EB, 0xDA12, 0xDE4B, 0xE295, 0xE6EB, 0xEB4C, 0xEFB3, 0xF41E, 0xF88A, 0xFCF4, 0x0157,
        0x05B3, 0x0A05, 0x0E48, 0x127A, 0x1699, 0x1AA2, 0x1E93, 0x2267, 0x261F, 0x29B6, 0x2D2B, 0x307B, 0x33A5, 0x36A7, 0x397F, 0x3C2B,
        0x3EA9, 0x40FA, 0x431A, 0x4509, 0x46C6, 0x4850, 0x49A7, 0x4AC9, 0x4BB7, 0x4C70, 0x4CF4, 0x4D43, 0x4D5D, 0x4D43, 0x4CF4, 0x4C73,
        0x4BBE, 0x4AD7, 0x49BF, 0x4878, 0x4701, 0x455D, 0x438D, 0x4193, 0x3F70, 0x3D25, 0x3AB6, 0x3823, 0x356F, 0x329B, 0x2FAB, 0x2CA0,
        0x297C, 0x2641, 0x22F3, 0x1F93, 0x1C25, 0x18A9, 0x1523, 0x1196, 0x0E03, 0x0A6E, 0x06D8, 0x0344, 0xFFB6, 0xFC2E, 0xF8AF, 0xF53C,
        0xF1D7, 0xEE82, 0xEB3F, 0xE810, 0xE4F8, 0xE1F8, 0xDF12, 0xDC49, 0xD99D, 0xD710, 0xD4A3, 0xD259, 0xD033, 0xCE31, 0xCC55, 0xCA9F,
        0xC912, 0xC7AC, 0xC66F, 0xC55C, 0xC473, 0xC3B4, 0xC320, 0xC2B6, 0xC276, 0xC260, 0xC275, 0xC2B3, 0xC31A, 0xC3AA, 0xC461, 0xC53F,
        0xC644, 0xC76D, 0xC8BA, 0xCA2B, 0xCBBC, 0xCD6E, 0xCF3E, 0xD12C, 0xD335, 0xD559, 0xD795, 0xD9E7, 0xDC4E, 0xDEC9, 0xE154, 0xE3EF,
        0xE697, 0xE94B, 0xEC08, 0xEECD, 0xF198, 0xF466, 0xF735, 0xFA05, 0xFCD2, 0xFF9B, 0x025D, 0x0519, 0x07CA, 0x0A71, 0x0D0A, 0x0F95,
        0x120F, 0x1477, 0x16CC, 0x190C, 0x1B36, 0x1D48, 0x1F42, 0x2122, 0x22E7, 0x2490, 0x261C, 0x278B, 0x28DB, 0x2A0D, 0x2B1F, 0x2C11,
        0x2CE3, 0x2D95, 0x2E26, 0x2E96, 0x2EE5, 0x2F14, 0x2F22, 0x2F10, 0x2EDE, 0x2E8D, 0x2E1D, 0x2D8E, 0x2CE2, 0x2C19, 0x2B34, 0x2A34,
        0x291A, 0x27E6, 0x269A, 0x2538, 0x23BF, 0x2232, 0x2091, 0x1EDF, 0x1D1C, 0x1B49, 0x1969, 0x177C, 0x1585, 0x1383, 0x117A, 0x0F6A,
        0x0D56, 0x0B3D, 0x0923, 0x0708, 0x04EE, 0x02D6, 0x00C2, 0xFEB4, 0xFCAB, 0xFAAB, 0xF8B3, 0xF6C6, 0xF4E5, 0xF310, 0xF149, 0xEF92,
        0xEDEA, 0xEC53, 0xEACF, 0xE95D, 0xE7FF, 0xE6B5, 0xE580, 0xE460, 0xE357, 0xE264, 0xE189, 0xE0C5, 0xE018, 0xDF83, 0xDF06, 0xDEA1,
        0xDE54, 0xDE20, 0xDE03, 0xDDFD, 0xDE0F, 0xDE38, 0xDE78, 0xDECD, 0xDF39, 0xDFBA, 0xE04F, 0xE0F8, 0xE1B5, 0xE284, 0xE364, 0xE456,
        0xE557, 0xE667, 0xE786, 0xE8B2, 0xE9EA, 0xEB2D, 0xEC7B, 0xEDD1, 0xEF30, 0xF096, 0xF202, 0xF372, 0xF4E7, 0xF65E, 0xF7D7, 0xF950,
        0xFAC9, 0xFC41, 0xFDB6, 0xFF28, 0x0094, 0x01FC, 0x035E, 0x04B8, 0x060A, 0x0754, 0x0894, 0x09C9, 0x0AF4, 0x0C12, 0x0D25, 0x0E2A,
        0x0F22, 0x100B, 0x10E6, 0x11B3, 0x1270, 0x131D, 0x13BB, 0x1449, 0x14C7, 0x1534, 0x1591, 0x15DE, 0x161A, 0x1646, 0x1662, 0x166E,
        0x166A, 0x1657, 0x1634, 0x1603, 0x15C3, 0x1575, 0x1519, 0x14B0, 0x143A, 0x13B8, 0x132B, 0x1292, 0x11EF, 0x1142, 0x108C, 0x0FCE,
        0x0F08, 0x0E3A, 0x0D66, 0x0C8D, 0x0BAE, 0x0ACB, 0x09E5, 0x08FB, 0x080F, 0x0722, 0x0635, 0x0547, 0x0459, 0x036D, 0x0283, 0x019C,
        0x00B7, 0xFFD8, 0xFEFB, 0xFE24, 0xFD52, 0xFC86, 0xFBC0, 0xFB01, 0xFA4A, 0xF99A, 0xF8F2, 0xF852, 0xF7BC, 0xF72E, 0xF6A9, 0xF62D,
        0xF5BC, 0xF553, 0xF4F5, 0xF4A1, 0xF456, 0xF415, 0xF3DF, 0xF3B2, 0xF38F, 0xF376, 0xF366, 0xF360, 0xF363, 0xF36F, 0xF383, 0xF3A1,
        0xF3C6, 0xF3F4, 0xF429, 0xF466, 0xF4AA, 0xF4F4, 0xF544, 0xF59B, 0xF5F7, 0xF658, 0xF6BD, 0xF727, 0xF794, 0xF805, 0xF879, 0xF8F0,
        0xF968, 0xF9E3, 0xFA5E, 0xFADB, 0xFB57, 0xFBD4, 0xFC51, 0xFCCC, 0xFD47, 0xFDC0, 0xFE37, 0xFEAC, 0xFF1F, 0xFF8F, 0xFFFC, 0x0065,
        0x00CB, 0x012D, 0x018B, 0x01E6, 0x023B, 0x028C, 0x02D9, 0x0321, 0x0364, 0x03A2, 0x03DB, 0x040F, 0x043E, 0x0468, 0x048C, 0x04AC,
        0x04C7, 0x04DD, 0x04EE, 0x04FB, 0x0503, 0x0506, 0x0505, 0x0500, 0x04F7, 0x04EA, 0x04DA, 0x04C6, 0x04AF, 0x0494, 0x0477, 0x0458,
        0x0435, 0x0411, 0x03EB, 0x03C3, 0x0399, 0x036F, 0x0343, 0x0316, 0x02E9, 0x02BB, 0x028D, 0x025F, 0x0232, 0x0205, 0x01D8, 0x01AC,
        0x0181, 0x0157, 0x012E, 0x0106, 0x00E0, 0x00BC, 0x0099, 0x0078, 0x0058, 0x003B, 0x001F, 0x0006, 0xFFEF, 0xFFDA, 0xFFC6, 0xFFB5,
        0xFFA6, 0xFF98, 0xFF8D, 0xFF83, 0xFF7B, 0xFF76, 0xFF71, 0xFF6F, 0xFF6E, 0xFF6E, 0xFF70, 0xFF73, 0xFF77, 0xFF7D, 0xFF83, 0xFF8A,
        0xFF91, 0xFF9A, 0xFFA2, 0xFFAB, 0xFFB4, 0xFFBD, 0xFFC7, 0xFFD0, 0xFFD8, 0xFFE0, 0xFFE8, 0xFFEF, 0xFFF5, 0xFFFA, 0xFFFE, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0003, 0x0004, 0x0004, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0004,
        0x0003, 0x0001, 0x0000, 0xFFFE, 0xFFFB, 0xFFF7, 0xFFF3, 0xFFEF, 0xFFE9, 0xFFE4, 0xFFDD, 0xFFD6, 0xFFCF, 0xFFC7, 0xFFBF, 0xFFB6,
        0xFFAD, 0xFFA3, 0xFF9A, 0xFF90, 0xFF86, 0xFF7D, 0xFF73, 0xFF6A, 0xFF61, 0xFF58, 0xFF51, 0xFF4A, 0xFF43, 0xFF3E, 0xFF3A, 0xFF37,
        0xFF35, 0xFF34, 0xFF35, 0xFF38, 0xFF3C, 0xFF43, 0xFF4A, 0xFF54, 0xFF60, 0xFF6E, 0xFF7D, 0xFF8F, 0xFFA3, 0xFFB8, 0xFFD0, 0xFFEA,
        0x0004, 0x0021, 0x0040, 0x0060, 0x0081, 0x00A4, 0x00C8, 0x00ED, 0x0112, 0x0138, 0x015E, 0x0185, 0x01AB, 0x01D0, 0x01F5, 0x0219,
        0x023C, 0x025D, 0x027C, 0x0299, 0x02B4, 0x02CC, 0x02E2, 0x02F4, 0x0303, 0x030E, 0x0316, 0x0319, 0x0318, 0x0313, 0x0309, 0x02FA,
        0x02E7, 0x02CF, 0x02B2, 0x0290, 0x0269, 0x023D, 0x020C, 0x01D6, 0x019C, 0x015D, 0x011A, 0x00D3, 0x0088, 0x0039, 0xFFE9, 0xFF94,
        0xFF3D, 0xFEE3, 0xFE88, 0xFE2C, 0xFDCF, 0xFD71, 0xFD14, 0xFCB7, 0xFC5C, 0xFC02, 0xFBAB, 0xFB56, 0xFB05, 0xFAB8, 0xFA6F, 0xFA2B,
        0xF9ED, 0xF9B5, 0xF983, 0xF958, 0xF934, 0xF919, 0xF905, 0xF8FA, 0xF8F8, 0xF8FF, 0xF90F, 0xF929, 0xF94D, 0xF97A, 0xF9B1, 0xF9F1,
        0xFA3C, 0xFA8F, 0xFAED, 0xFB53, 0xFBC2, 0xFC3A, 0xFCBA, 0xFD41, 0xFDD0, 0xFE65, 0xFF01, 0xFFA1, 0x0046, 0x00EF, 0x019C, 0x024A,
        0x02FB, 0x03AC, 0x045D, 0x050C, 0x05BA, 0x0664, 0x070B, 0x07AD, 0x0849, 0x08DE, 0x096B, 0x09F0, 0x0A6C, 0x0ADD, 0x0B43, 0x0B9D,
        0x0BEA, 0x0C2B, 0x0C5D, 0x0C81, 0x0C96, 0x0C9B, 0x0C91, 0x0C76, 0x0C4C, 0x0C11, 0x0BC5, 0x0B69, 0x0AFD, 0x0A80, 0x09F4, 0x0958,
        0x08AD, 0x07F3, 0x072C, 0x0658, 0x0577, 0x048A, 0x0394, 0x0293, 0x018B, 0x007B, 0xFF65, 0xFE4A, 0xFD2C, 0xFC0C, 0xFAEA, 0xF9CA,
        0xF8AB, 0xF790, 0xF67A, 0xF56B, 0xF464, 0xF366, 0xF273, 0xF18C, 0xF0B3, 0xEFE9, 0xEF30, 0xEE88, 0xEDF2, 0xED70, 0xED03, 0xECAB,
        0xEC6A, 0xEC40, 0xEC2E, 0xEC34, 0xEC53, 0xEC8B, 0xECDB, 0xED45, 0xEDC9, 0xEE65, 0xEF19, 0xEFE6, 0xF0CA, 0xF1C4, 0xF2D5, 0xF3FB,
        0xF534, 0xF680, 0xF7DD, 0xF94B, 0xFAC6, 0xFC4F, 0xFDE2, 0xFF7F, 0x0122, 0x02CB, 0x0478, 0x0626, 0x07D4, 0x097E, 0x0B24, 0x0CC3,
        0x0E58, 0x0FE3, 0x1160, 0x12CD, 0x1429, 0x1571, 0x16A4, 0x17C0, 0x18C3, 0x19AC, 0x1A78, 0x1B27, 0x1BB7, 0x1C27, 0x1C76, 0x1CA3,
        0x1CAE, 0x1C96, 0x1C5A, 0x1BFA, 0x1B77, 0x1ACF, 0x1A05, 0x1917, 0x1807, 0x16D6, 0x1584, 0x1414, 0x1285, 0x10D9, 0x0F13, 0x0D35,
        0x0B3F, 0x0934, 0x0717, 0x04E9, 0x02AE, 0x0068, 0xFE1A, 0xFBC5, 0xF96E, 0xF716, 0xF4C1, 0xF272, 0xF02B, 0xEDF0, 0xEBC4, 0xE9A9,
        0xE7A2, 0xE5B2, 0xE3DC, 0xE222, 0xE087, 0xDF0D, 0xDDB7, 0xDC86, 0xDB7C, 0xDA9C, 0xD9E7, 0xD95E, 0xD902, 0xD8D5, 0xD8D8, 0xD90A,
        0xD96D, 0xDA00, 0xDAC3, 0xDBB7, 0xDCDA, 0xDE2B, 0xDFAA, 0xE155, 0xE32B, 0xE52A, 0xE750, 0xE99B, 0xEC08, 0xEE96, 0xF140, 0xF405,
        0xF6E1, 0xF9D0, 0xFCD1, 0xFFDE, 0x02F4, 0x0610, 0x092F, 0x0C4C, 0x0F63, 0x1270, 0x1570, 0x185F, 0x1B39, 0x1DFA, 0x209F, 0x2324,
        0x2585, 0x27BF, 0x29CF, 0x2BB3, 0x2D66, 0x2EE7, 0x3033, 0x3149, 0x3225, 0x32C6, 0x332C, 0x3354, 0x333E, 0x32E9, 0x3256, 0x3183,
        0x3072, 0x2F23, 0x2D96, 0x2BCE, 0x29CB, 0x2790, 0x251F, 0x227A, 0x1FA3, 0x1C9E, 0x196E, 0x1617, 0x129B, 0x0F00, 0x0B48, 0x0778,
        0x0396, 0xFFA5, 0xFBA9, 0xF7A8, 0xF3A7, 0xEFAA, 0xEBB6, 0xE7D1, 0xE3FE, 0xE044, 0xDCA7, 0xD92B, 0xD5D5, 0xD2AA, 0xCFAE, 0xCCE5,
        0xCA53, 0xC7FB, 0xC5E2, 0xC40A, 0xC276, 0xC129, 0xC025, 0xBF6C, 0xBF00, 0xBEE2, 0xBF13, 0xBF93, 0xC063, 0xC182, 0xC2EF, 0xC4AB,
        0xC6B3, 0xC906, 0xCBA1, 0xCE82, 0xD1A6, 0xD50B, 0xD8AC, 0xDC85, 0xE093, 0xE4D1, 0xE93B, 0xEDCA, 0xF27B, 0xF748, 0xFC2A, 0x011C,
        0x0619, 0x0B1B, 0x101C, 0x1514, 0x19FF, 0x1ED6, 0x2392, 0x282F, 0x2CA5, 0x30F0, 0x350A, 0x38ED, 0x3C93, 0x3FF9, 0x4318, 0x45EE,
        0x4875, 0x4AAA, 0x4C89, 0x4E10, 0x4F3C, 0x500A, 0x5079, 0x5087, 0x5033, 0x4F7E, 0x4E66, 0x4CED, 0x4B14, 0x48DB, 0x4644, 0x4353,
        0x400A, 0x3C6B, 0x387C, 0x343F, 0x2FB9, 0x2AF0, 0x25E8, 0x20A7, 0x1B33, 0x1592, 0x0FCB, 0x09E4, 0x03E4, 0xFDD4, 0xF7B8, 0xF199,
        0xEB94, 0xE5A8, 0xDFDB, 0xDA35, 0xD4BD, 0xCF78, 0xCA6E, 0xC5A3, 0xC11F, 0xBCE7, 0xB8FF, 0xB56C, 0xB233, 0xAF57, 0xACDC, 0xAAC5,
        0xA914, 0xA7CC, 0xA6ED, 0xA679, 0xA671, 0xA6D5, 0xA7A3, 0xA8DC, 0xAA7D, 0xAC85, 0xAEF1, 0xB1BE, 0xB4E9, 0xB86F, 0xBC4A, 0xC077,
        0xC4F0, 0xC9B0, 0xCEB1, 0xD3ED, 0xD95E, 0xDEFE, 0xE4C5, 0xEAAD, 0xF0AE, 0xF6C2, 0xFCE1, 0x0303, 0x0922, 0x0F36, 0x1538, 0x1B21,
        0x20E8, 0x2689, 0x2BFB, 0x3138, 0x363A, 0x3AFB, 0x3F76, 0x43A4, 0x4781, 0x4B08, 0x4E34, 0x5104, 0x5371, 0x557B, 0x571E, 0x5858,
        0x5929, 0x598E, 0x5988, 0x5916, 0x5839, 0x56F3, 0x5544, 0x532E, 0x50B5, 0x4DDB, 0x4AA3, 0x4712, 0x432C, 0x3EF4, 0x3A72, 0x35A9,
        0x309F, 0x2B5C, 0x25E4, 0x203F, 0x1A73, 0x1487, 0x0E83, 0x086D, 0x024D, 0xFC2B, 0xF60D, 0xEFFB, 0xE9FC, 0xE418, 0xDE55, 0xD8BA,
        0xD34F, 0xCE19, 0xC91F, 0xC467, 0xBFF7, 0xBBD3, 0xB802, 0xB486, 0xB166, 0xAEA4, 0xAC43, 0xAA47, 0xA8B2, 0xA786, 0xA6C4, 0xA66D,
        0xA681, 0xA701, 0xA7EC, 0xA941, 0xAAFE, 0xAD21, 0xAFA7, 0xB28E, 0xB5D2, 0xB96E, 0xBD60, 0xC1A2, 0xC62E, 0xCB00, 0xD011, 0xD55D,
        0xDADB, 0xE086, 0xE656, 0xEC46, 0xF24D, 0xF864, 0xFE85, 0x04A7, 0x0AC4, 0x10D4, 0x16CF, 0x1CB0, 0x226E, 0x2802, 0x2D67, 0x3295,
        0x3786, 0x3C35, 0x409B, 0x44B4, 0x487B, 0x4BEA, 0x4EFE, 0x51B3, 0x5407, 0x55F5, 0x577C, 0x589A, 0x594E, 0x5997, 0x5974, 0x58E5,
        0x57EC, 0x568A, 0x54BF, 0x528F, 0x4FFB, 0x4D08, 0x49B8, 0x460F, 0x4213, 0x3DC7, 0x3931, 0x3456, 0x2F3D, 0x29EA, 0x2466, 0x1EB5,
        0x18E0, 0x12ED, 0x0CE3, 0x06CA, 0x00A9, 0xFA88, 0xF46C, 0xEE5E, 0xE866, 0xE28A, 0xDCD1, 0xD742, 0xD1E5, 0xCCBE, 0xC7D5, 0xC330,
        0xBED4, 0xBAC6, 0xB70B, 0xB3A7, 0xB0A0, 0xADF7, 0xABB1, 0xA9D1, 0xA857, 0xA747, 0xA6A2, 0xA668, 0xA699, 0xA736, 0xA83D, 0xA9AE,
        0xAB86, 0xADC4, 0xB064, 0xB364, 0xB6C0, 0xBA74, 0xBE7C, 0xC2D2, 0xC771, 0xCC55, 0xD176, 0xD6D0, 0xDC5B, 0xE210, 0xE7EA, 0xEDE0,
        0xF3ED, 0xFA07, 0x0028, 0x064A, 0x0C64, 0x126F, 0x1865, 0x1E3C, 0x23F0, 0x2978, 0x2ECF, 0x33EE, 0x38CE, 0x3D69, 0x41BC, 0x45BF,
        0x496E, 0x4CC6, 0x4FC1, 0x525C, 0x5495, 0x5668, 0x57D3, 0x58D5, 0x596C, 0x5998, 0x5958, 0x58AD, 0x5798, 0x5619, 0x5433, 0x51E8,
        0x4F3A, 0x4C2E, 0x48C6, 0x4507, 0x40F4, 0x3C94, 0x37EB, 0x32FF, 0x2DD6, 0x2875, 0x22E4, 0x1D29, 0x174C, 0x1152, 0x0B43, 0x0527,
        0xFF06, 0xF8E5, 0xF2CC, 0xECC3, 0xE6D2, 0xE0FE, 0xDB50, 0xD5CE, 0xD07E, 0xCB68, 0xC691, 0xC1FE, 0xBDB6, 0xB9BE, 0xB61A, 0xB2CF,
        0xAFE0, 0xAD52, 0xAB27, 0xA961, 0xA804, 0xA711, 0xA688, 0xA66A, 0xA6B8, 0xA772, 0xA895, 0xAA22, 0xAC16, 0xAE6E, 0xB128, 0xB441,
        0xB7B5, 0xBB80, 0xBF9D, 0xC407, 0xC8BA, 0xCDAE, 0xD2DF, 0xD847, 0xDDDE, 0xE39D, 0xE97F, 0xEF7C, 0xF58D, 0xFBAB, 0x01CC, 0x07ED,
        0x0E04, 0x140A, 0x19F8, 0x1FC7, 0x256F, 0x2AEB, 0x3033, 0x3542, 0x3A10, 0x3E99, 0x42D6, 0x46C4, 0x4A5C, 0x4D9B, 0x507D, 0x52FE,
        0x551C, 0x56D3, 0x5822, 0x5908, 0x5982, 0x5991, 0x5935, 0x586D, 0x573C, 0x55A1, 0x53A0, 0x513A, 0x4E73, 0x4B4E, 0x47CE, 0x43F8,
        0x3FD0, 0x3B5C, 0x36A0, 0x31A3, 0x2C6B, 0x26FD, 0x2160, 0x1B9B, 0x15B5, 0x0FB5, 0x09A2, 0x0383, 0xFD62, 0xF742, 0xF12D, 0xEB2A,
        0xE540, 0xDF75, 0xD9D2, 0xD45D, 0xCF1C, 0xCA16, 0xC551, 0xC0D2, 0xBC9F, 0xB8BC, 0xB530, 0xB1FD, 0xAF28, 0xACB4, 0xAAA3, 0xA8FA,
        0xA7B9, 0xA6E2, 0xA675, 0xA675, 0xA6E0, 0xA7B5, 0xA8F5, 0xAA9E, 0xACAC, 0xAF1F, 0xB1F3, 0xB525, 0xB8B1, 0xBC92, 0xC0C4, 0xC542,
        0xCA07, 0xCF0C, 0xD44C, 0xD9C1, 0xDF63, 0xE52D, 0xEB17, 0xF11A, 0xF72F, 0xFD4E, 0x0370, 0x098F, 0x0FA2, 0x15A2, 0x1B89, 0x214E,
        0x26EB, 0x2C5A, 0x3193, 0x3691, 0x3B4D, 0x3FC3, 0x43EB, 0x47C2, 0x4B43, 0x4E6A, 0x5132, 0x5399, 0x559B, 0x5737, 0x586A, 0x5933,
        0x5991, 0x5983, 0x590A, 0x5826, 0x56D8, 0x5522, 0x5305, 0x5085, 0x4DA5, 0x4A67, 0x46CF, 0x42E3, 0x3EA7, 0x3A1F, 0x3551, 0x3043,
        0x2AFC, 0x2581, 0x1FD9, 0x1A0A, 0x141C, 0x0E17, 0x0800, 0x01E0, 0xFBBE, 0xF5A0, 0xEF8F, 0xE992, 0xE3B0, 0xDDEF, 0xD858, 0xD2F0,
        0xCDBE, 0xC8C9, 0xC416, 0xBFAB, 0xBB8D, 0xB7C1, 0xB44C, 0xB132, 0xAE76, 0xAC1C, 0xAA28, 0xA89A, 0xA775, 0xA6BA, 0xA66B, 0xA687,
        0xA70E, 0xA801, 0xA95D, 0xAB21, 0xAD4A, 0xAFD8, 0xB2C5, 0xB60F, 0xB9B2, 0xBDA9, 0xC1F0, 0xC682, 0xCB58, 0xD06E, 0xD5BD, 0xDB3E,
        0xE0EC, 0xE6BF, 0xECB0, 0xF2B9, 0xF8D1, 0xFEF2, 0x0514, 0x0B30, 0x113F, 0x1739, 0x1D17, 0x22D3, 0x2864, 0x2DC5, 0x32EF, 0x37DC,
        0x3C86, 0x40E7, 0x44FA, 0x48BB, 0x4C24, 0x4F31, 0x51E0, 0x542C, 0x5614, 0x5794, 0x58AA, 0x5957, 0x5998, 0x596D, 0x58D7, 0x57D7,
        0x566D, 0x549B, 0x5264, 0x4FCA, 0x4CD0, 0x4979, 0x45CB, 0x41C9, 0x3D78, 0x38DD, 0x33FD, 0x2EE0, 0x298A, 0x2402, 0x1E4F, 0x1877,
        0x1282, 0x0C77, 0x065D, 0x003B, 0xFA1B, 0xF400, 0xEDF3, 0xE7FC, 0xE222, 0xDC6C, 0xD6E1, 0xD187, 0xCC65, 0xC780, 0xC2E0, 0xBE89,
        0xBA80, 0xB6CB, 0xB36E, 0xB06D, 0xADCB, 0xAB8D, 0xA9B3, 0xA841, 0xA738, 0xA69A, 0xA668, 0xA6A1, 0xA745, 0xA853, 0xA9CB, 0xABAB,
        0xADEF, 0xB097, 0xB39D, 0xB700, 0xBAB9, 0xBEC7, 0xC322, 0xC7C6, 0xCCAE, 0xD1D4, 0xD731, 0xDCBF, 0xE277, 0xE853, 0xEE4B, 0xF459,
        0xFA74, 0x0096, 0x06B7, 0x0CD0, 0x12DA, 0x18CE, 0x1EA3, 0x2454, 0x29D9, 0x2F2C, 0x3446, 0x3922, 0x3DB9, 0x4206, 0x4603, 0x49AD,
        0x4CFE, 0x4FF3, 0x5287, 0x54B9, 0x5685, 0x57E9, 0x58E3, 0x5973, 0x5997, 0x5950, 0x589D, 0x5780, 0x55FB, 0x540D, 0x51BB, 0x4F07,
        0x4BF4, 0x4886, 0x44C1, 0x40A9, 0x3C43, 0x3795, 0x32A5, 0x2D77, 0x2814, 0x227F, 0x1CC2, 0x16E2, 0x10E6, 0x0AD7, 0x04BA, 0xFE98,
        0xF878, 0xF260, 0xEC58, 0xE669, 0xE098, 0xDAEC, 0xD56D, 0xD022, 0xCB10, 0xC63D, 0xC1AF, 0xBD6D, 0xB97A, 0xB5DC, 0xB298, 0xAFB0,
        0xAD28, 0xAB04, 0xA946, 0xA7F0, 0xA704, 0xA682, 0xA66C, 0xA6C2, 0xA783, 0xA8AE, 0xAA41, 0xAC3C, 0xAE9C, 0xB15D, 0xB47C, 0xB7F6,
        0xBBC7, 0xBFE9, 0xC459, 0xC910, 0xCE09, 0xD33E, 0xD8A9, 0xDE43, 0xE405, 0xE9E9, 0xEFE8, 0xF5FA, 0xFC18, 0x023A, 0x085A, 0x0E70,
        0x1474, 0x1A60, 0x202D, 0x25D3, 0x2B4B, 0x308F, 0x3599, 0x3A63, 0x3EE7, 0x431F, 0x4706, 0x4A99, 0x4DD1, 0x50AD, 0x5327, 0x553E,
        0x56EE, 0x5836, 0x5914, 0x5987, 0x598E, 0x592A, 0x585B, 0x5722, 0x5581, 0x5378, 0x510C, 0x4E3E, 0x4B12, 0x478C, 0x43B0, 0x3F83,
        0x3B0A, 0x364A, 0x3148, 0x2C0C, 0x269A, 0x20FA, 0x1B33, 0x154B, 0x0F49, 0x0935, 0x0316, 0xFCF4, 0xF6D5, 0xF0C1, 0xEABF, 0xE4D7,
        0xDF10, 0xD96F, 0xD3FE, 0xCEC1, 0xC9BF, 0xC4FE, 0xC084, 0xBC57, 0xB87A, 0xB4F4, 0xB1C7, 0xAEF9, 0xAC8C, 0xAA82, 0xA8E0, 0xA7A6,
        0xA6D7, 0xA672, 0xA679, 0xA6EB, 0xA7C8, 0xA90F, 0xAABF, 0xACD5, 0xAF4F, 0xB229, 0xB561, 0xB8F3, 0xBCDA, 0xC112, 0xC595, 0xCA5E,
        0xCF68, 0xD4AC, 0xDA24, 0xDFC9, 0xE596, 0xEB81, 0xF186, 0xF79C, 0xFDBC, 0x03DD, 0x09FB, 0x100E, 0x160C, 0x1BF1, 0x21B3, 0x274E,
        0x2CB9, 0x31EE, 0x36E8, 0x3B9F, 0x400F, 0x4432, 0x4803, 0x4B7E, 0x4E9E, 0x5160, 0x53C0, 0x55BB, 0x5750, 0x587C, 0x593D, 0x5993,
        0x597E, 0x58FE, 0x5812, 0x56BD, 0x54FF, 0x52DC, 0x5055, 0x4D6E, 0x4A2A, 0x468C, 0x429A, 0x3E58, 0x39CB, 0x34F9, 0x2FE7, 0x2A9C,
        0x251D, 0x1F72, 0x19A1, 0x13B2, 0x0DAB, 0x0793, 0x0172, 0xFB51, 0xF534, 0xEF24, 0xE928, 0xE348, 0xDD8A, 0xD7F6, 0xD292, 0xCD64,
        0xC873, 0xC3C5, 0xBF5F, 0xBB46, 0xB780, 0xB412, 0xB0FE, 0xAE49, 0xABF6, 0xAA08, 0xA882, 0xA764, 0xA6B1, 0xA669, 0xA68D, 0xA71C,
        0xA815, 0xA979, 0xAB44, 0xAD75, 0xB009, 0xB2FD, 0xB64D, 0xB9F6, 0xBDF3, 0xC23F, 0xC6D6, 0xCBB1, 0xD0CB, 0xD61D, 0xDBA2, 0xE153,
        0xE728, 0xED1B, 0xF325, 0xF93E, 0xFF60, 0x0581, 0x0B9D, 0x11AA, 0x17A3, 0x1D7F, 0x2337, 0x28C6, 0x2E23, 0x3349, 0x3831, 0x3CD6,
        0x4132, 0x4540, 0x48FA, 0x4C5D, 0x4F64, 0x520C, 0x5452, 0x5632, 0x57AA, 0x58BA, 0x595F, 0x5998, 0x5966, 0x58C9, 0x57C1, 0x5650,
        0x5477, 0x5239, 0x4F98, 0x4C97, 0x493B, 0x4586, 0x417E, 0x3D28, 0x3888, 0x33A4, 0x2E82, 0x2929, 0x239D, 0x1DE8, 0x180E, 0x1217,
        0x0C0B, 0x05F0, 0xFFCF, 0xF9AD, 0xF393, 0xED88, 0xE793, 0xE1BB, 0xDC08, 0xD680, 0xD12A, 0xCC0B, 0xC72C, 0xC290, 0xBE3E, 0xBA3C,
        0xB68D, 0xB336, 0xB03B, 0xADA0, 0xAB68, 0xA996, 0xA82B, 0xA72A, 0xA693, 0xA668, 0xA6A8, 0xA754, 0xA86A, 0xA9E9, 0xABD0, 0xAE1C,
        0xB0CA, 0xB3D7, 0xB73F, 0xBAFF, 0xBF12, 0xC372, 0xC81C, 0xCD08, 0xD232, 0xD792, 0xDD24, 0xE2DF, 0xE8BD, 0xEEB7, 0xF4C5, 0xFAE2,
        0x0103, 0x0724, 0x0D3D, 0x1345, 0x1937, 0x1F0A, 0x24B8, 0x2A3A, 0x2F89, 0x349F, 0x3976, 0x3E08, 0x424F, 0x4647, 0x49EB, 0x4D36,
        0x5024, 0x52B1, 0x54DC, 0x56A1, 0x57FD, 0x58F0, 0x5979, 0x5996, 0x5947, 0x588D, 0x5769, 0x55DC, 0x53E7, 0x518E, 0x4ED3, 0x4BBA,
        0x4845, 0x447A, 0x405D, 0x3BF2, 0x3740, 0x324B, 0x2D19, 0x27B2, 0x221A, 0x1C5A, 0x1678, 0x107B, 0x0A6A, 0x044D, 0xFE2B, 0xF80B,
        0xF1F4, 0xEBEE, 0xE600, 0xE031, 0xDA89, 0xD50D, 0xCFC5, 0xCAB7, 0xC5E9, 0xC161, 0xBD24, 0xB937, 0xB59F, 0xB261, 0xAF7F, 0xACFF,
        0xAAE1, 0xA92B, 0xA7DC, 0xA6F7, 0xA67D, 0xA66F, 0xA6CC, 0xA794, 0xA8C6, 0xAA61, 0xAC63, 0xAECA, 0xB191, 0xB4B7, 0xB837, 0xBC0E,
        0xC036, 0xC4AB, 0xC966, 0xCE64, 0xD39D, 0xD90B, 0xDEA8, 0xE46D, 0xEA53, 0xF054, 0xF667, 0xFC85, 0x02A7, 0x08C6, 0x0EDB, 0x14DF,
        0x1AC9, 0x2093, 0x2636, 0x2BAA, 0x30EB, 0x35F1, 0x3AB6, 0x3F34, 0x4367, 0x4749, 0x4AD5, 0x4E07, 0x50DC, 0x5350, 0x555F, 0x5708,
        0x5849, 0x591F, 0x598B, 0x598B, 0x5920, 0x5849, 0x5709, 0x5560, 0x5350, 0x50DD, 0x4E08, 0x4AD6, 0x474A, 0x4368, 0x3F36, 0x3AB7,
        0x35F2, 0x30ED, 0x2BAC, 0x2637, 0x2095, 0x1ACB, 0x14E1, 0x0EDD, 0x08C8, 0x02A9, 0xFC87, 0xF669, 0xF056, 0xEA55, 0xE46F, 0xDEAA,
        0xD90D, 0xD39F, 0xCE66, 0xC968, 0xC4AC, 0xC037, 0xBC0F, 0xB839, 0xB4B8, 0xB192, 0xAECA, 0xAC64, 0xAA62, 0xA8C7, 0xA794, 0xA6CC,
        0xA66F, 0xA67D, 0xA6F7, 0xA7DC, 0xA92A, 0xAAE1, 0xACFE, 0xAF7E, 0xB260, 0xB59E, 0xB936, 0xBD23, 0xC160, 0xC5E8, 0xCAB6, 0xCFC4,
        0xD50C, 0xDA87, 0xE02F, 0xE5FE, 0xEBEC, 0xF1F2, 0xF809, 0xFE29, 0x044B, 0x0A68, 0x1079, 0x1676, 0x1C58, 0x2219, 0x27B0, 0x2D17,
        0x3249, 0x373E, 0x3BF1, 0x405B, 0x4479, 0x4844, 0x4BB9, 0x4ED2, 0x518D, 0x53E7, 0x55DB, 0x5768, 0x588D, 0x5947, 0x5995, 0x5979,
        0x58F1, 0x57FE, 0x56A1, 0x54DD, 0x52B2, 0x5025, 0x4D37, 0x49EC, 0x4649, 0x4251, 0x3E09, 0x3978, 0x34A1, 0x2F8B, 0x2A3C, 0x24BA,
        0x1F0C, 0x1939, 0x1347, 0x0D3F, 0x0726, 0x0105, 0xFAE4, 0xF4C7, 0xEEB9, 0xE8BF, 0xE2E1, 0xDD26, 0xD794, 0xD234, 0xCD0A, 0xC81D,
        0xC374, 0xBF13, 0xBB00, 0xB740, 0xB3D8, 0xB0CA, 0xAE1C, 0xABD1, 0xA9EA, 0xA86B, 0xA754, 0xA6A9, 0xA668, 0xA693, 0xA72A, 0xA82B,
        0xA995, 0xAB68, 0xAD9F, 0xB03A, 0xB335, 0xB68C, 0xBA3A, 0xBE3D, 0xC28F, 0xC72A, 0xCC0A, 0xD128, 0xD67E, 0xDC06, 0xE1BA, 0xE791,
        0xED86, 0xF391, 0xF9AB, 0xFFCD, 0x05EE, 0x0C09, 0x1215, 0x180C, 0x1DE6, 0x239C, 0x2927, 0x2E80, 0x33A2, 0x3886, 0x3D26, 0x417D,
        0x4585, 0x493A, 0x4C96, 0x4F97, 0x5238, 0x5476, 0x564F, 0x57C1, 0x58C9, 0x5966, 0x5998, 0x595F, 0x58BA, 0x57AB, 0x5632, 0x5452,
        0x520D, 0x4F65, 0x4C5E, 0x48FB, 0x4541, 0x4134, 0x3CD8, 0x3833, 0x334B, 0x2E25, 0x28C7, 0x2339, 0x1D80, 0x17A4, 0x11AC, 0x0B9E,
        0x0583, 0xFF62, 0xF940, 0xF327, 0xED1D, 0xE72A, 0xE155, 0xDBA4, 0xD61F, 0xD0CC, 0xCBB3, 0xC6D7, 0xC241, 0xBDF4, 0xB9F7, 0xB64E,
        0xB2FE, 0xB00A, 0xAD75, 0xAB44, 0xA979, 0xA816, 0xA71C, 0xA68D, 0xA669, 0xA6B1, 0xA764, 0xA881, 0xAA08, 0xABF6, 0xAE48, 0xB0FD,
        0xB410, 0xB77F, 0xBB45, 0xBF5D, 0xC3C3, 0xC871, 0xCD62, 0xD290, 0xD7F4, 0xDD89, 0xE346, 0xE926, 0xEF22, 0xF532, 0xFB4F, 0x0170,
        0x0791, 0x0DA9, 0x13B0, 0x19A0, 0x1F70, 0x251C, 0x2A9A, 0x2FE6, 0x34F7, 0x39CA, 0x3E57, 0x4299, 0x468B, 0x4A28, 0x4D6D, 0x5054,
        0x52DB, 0x54FF, 0x56BC, 0x5812, 0x58FD, 0x597E, 0x5994, 0x593D, 0x587C, 0x5750, 0x55BC, 0x53C1, 0x5161, 0x4E9F, 0x4B7F, 0x4805,
        0x4434, 0x4011, 0x3BA1, 0x36E9, 0x31F0, 0x2CBB, 0x274F, 0x21B5, 0x1BF3, 0x160E, 0x100F, 0x09FD, 0x03DF, 0xFDBE, 0xF79E, 0xF188,
        0xEB83, 0xE597, 0xDFCB, 0xDA26, 0xD4AE, 0xCF69, 0xCA60, 0xC596, 0xC113, 0xBCDB, 0xB8F4, 0xB562, 0xB22A, 0xAF50, 0xACD6, 0xAAC0,
        0xA910, 0xA7C9, 0xA6EB, 0xA679, 0xA672, 0xA6D6, 0xA7A6, 0xA8E0, 0xAA82, 0xAC8B, 0xAEF8, 0xB1C6, 0xB4F3, 0xB879, 0xBC55, 0xC083,
        0xC4FD, 0xC9BD, 0xCEBF, 0xD3FC, 0xD96E, 0xDF0E, 0xE4D5, 0xEABE, 0xF0BF, 0xF6D3, 0xFCF2, 0x0314, 0x0933, 0x0F47, 0x1549, 0x1B31,
        0x20F8, 0x2698, 0x2C0A, 0x3147, 0x3648, 0x3B08, 0x3F82, 0x43AF, 0x478B, 0x4B11, 0x4E3D, 0x510B, 0x5378, 0x5580, 0x5722, 0x585B,
        0x592A, 0x598E, 0x5987, 0x5914, 0x5836, 0x56EE, 0x553E, 0x5328, 0x50AE, 0x4DD2, 0x4A9A, 0x4708, 0x4320, 0x3EE8, 0x3A65, 0x359B,
        0x3091, 0x2B4D, 0x25D4, 0x202F, 0x1A62, 0x1476, 0x0E72, 0x085C, 0x023C, 0xFC1A, 0xF5FC, 0xEFEA, 0xE9EB, 0xE407, 0xDE45, 0xD8AB,
        0xD340, 0xCE0B, 0xC911, 0xC45A, 0xBFEB, 0xBBC8, 0xB7F7, 0xB47D, 0xB15E, 0xAE9C, 0xAC3D, 0xAA42, 0xA8AE, 0xA783, 0xA6C2, 0xA66C,
        0xA682, 0xA703, 0xA7EF, 0xA945, 0xAB03, 0xAD27, 0xAFAF, 0xB297, 0xB5DB, 0xB979, 0xBD6C, 0xC1AE, 0xC63B, 0xCB0E, 0xD020, 0xD56C,
        0xDAEB, 0xE096, 0xE667, 0xEC57, 0xF25E, 0xF876, 0xFE96, 0x04B8, 0x0AD5, 0x10E5, 0x16E0, 0x1CC0, 0x227E, 0x2812, 0x2D76, 0x32A3,
        0x3794, 0x3C42, 0x40A7, 0x44BF, 0x4885, 0x4BF3, 0x4F06, 0x51BB, 0x540D, 0x55FA, 0x5780, 0x589D, 0x5950, 0x5997, 0x5973, 0x58E3,
        0x57E9, 0x5685, 0x54B9, 0x5288, 0x4FF3, 0x4CFF, 0x49AE, 0x4605, 0x4207, 0x3DBA, 0x3924, 0x3448, 0x2F2E, 0x29DB, 0x2456, 0x1EA5,
        0x18D0, 0x12DC, 0x0CD2, 0x06B9, 0x0098, 0xFA76, 0xF45B, 0xEE4D, 0xE855, 0xE279, 0xDCC1, 0xD733, 0xD1D6, 0xCCB0, 0xC7C8, 0xC323,
        0xBEC8, 0xBABB, 0xB701, 0xB39E, 0xB098, 0xADF0, 0xABAB, 0xA9CC, 0xA854, 0xA745, 0xA6A1, 0xA668, 0xA69A, 0xA738, 0xA841, 0xA9B2,
        0xAB8C, 0xADCB, 0xB06C, 0xB36D, 0xB6CA, 0xBA7F, 0xBE88, 0xC2DF, 0xC77F, 0xCC63, 0xD185, 0xD6DF, 0xDC6A, 0xE221, 0xE7FA, 0xEDF1,
        0xF3FE, 0xFA19, 0x003A, 0x065B, 0x0C75, 0x1280, 0x1875, 0x1E4D, 0x2400, 0x2988, 0x2EDE, 0x33FC, 0x38DB, 0x3D76, 0x41C7, 0x45CA,
        0x4978, 0x4CCF, 0x4FC9, 0x5263, 0x549B, 0x566C, 0x57D7, 0x58D7, 0x596D, 0x5998, 0x5957, 0x58AB, 0x5794, 0x5614, 0x542D, 0x51E1,
        0x4F32, 0x4C25, 0x48BC, 0x44FB, 0x40E8, 0x3C87, 0x37DE, 0x32F1, 0x2DC7, 0x2866, 0x22D4, 0x1D19, 0x173B, 0x1141, 0x0B32, 0x0516,
        0xFEF4, 0xF8D3, 0xF2BB, 0xECB2, 0xE6C1, 0xE0EE, 0xDB40, 0xD5BF, 0xD070, 0xCB5A, 0xC683, 0xC1F2, 0xBDAB, 0xB9B3, 0xB610, 0xB2C6,
        0xAFD8, 0xAD4B, 0xAB21, 0xA95D, 0xA801, 0xA70F, 0xA687, 0xA66B, 0xA6BA, 0xA774, 0xA899, 0xAA27, 0xAC1C, 0xAE75, 0xB131, 0xB44B,
        0xB7C0, 0xBB8B, 0xBFA9, 0xC414, 0xC8C7, 0xCDBD, 0xD2EE, 0xD856, 0xDDEE, 0xE3AE, 0xE990, 0xEF8D, 0xF59E, 0xFBBC, 0x01DE, 0x07FE,
        0x0E15, 0x141B, 0x1A08, 0x1FD7, 0x257F, 0x2AFA, 0x3042, 0x3550, 0x3A1D, 0x3EA5, 0x42E2, 0x46CE, 0x4A66, 0x4DA4, 0x5085, 0x5305,
        0x5521, 0x56D8, 0x5826, 0x590A, 0x5983, 0x5991, 0x5933, 0x586B, 0x5738, 0x559C, 0x539A, 0x5133, 0x4E6B, 0x4B44, 0x47C3, 0x43EC,
        0x3FC4, 0x3B4F, 0x3693, 0x3195, 0x2C5C, 0x26ED, 0x2150, 0x1B8B, 0x15A4, 0x0FA4, 0x0991, 0x0372, 0xFD50, 0xF731, 0xF11C, 0xEB19,
        0xE52F, 0xDF65, 0xD9C3, 0xD44E, 0xCF0E, 0xCA08, 0xC544, 0xC0C5, 0xBC93, 0xB8B2, 0xB526, 0xB1F4, 0xAF20, 0xACAD, 0xAA9E, 0xA8F6,
        0xA7B6, 0xA6E0, 0xA675, 0xA675, 0xA6E1, 0xA7B8, 0xA8F9, 0xAAA3, 0xACB3, 0xAF27, 0xB1FC, 0xB52F, 0xB8BB, 0xBC9D, 0xC0D0, 0xC54F,
        0xCA14, 0xCF1B, 0xD45B, 0xD9D1, 0xDF74, 0xE53E, 0xEB28, 0xF12B, 0xF740, 0xFD60, 0x0381, 0x09A0, 0x0FB3, 0x15B3, 0x1B99, 0x215E,
        0x26FB, 0x2C69, 0x31A2, 0x369F, 0x3B5A, 0x3FCF, 0x43F6, 0x47CD, 0x4B4C, 0x4E72, 0x5139, 0x539F, 0x55A1, 0x573B, 0x586D, 0x5935,
        0x5991, 0x5982, 0x5908, 0x5823, 0x56D4, 0x551C, 0x52FF, 0x507E, 0x4D9C, 0x4A5D, 0x46C5, 0x42D8, 0x3E9A, 0x3A12, 0x3543, 0x3035,
        0x2AED, 0x2571, 0x1FC8, 0x19FA, 0x140C, 0x0E06, 0x07EF, 0x01CE, 0xFBAD, 0xF58F, 0xEF7E, 0xE981, 0xE39F, 0xDDDF, 0xD848, 0xD2E1,
        0xCDB0, 0xC8BB, 0xC409, 0xBF9F, 0xBB81, 0xB7B7, 0xB443, 0xB129, 0xAE6F, 0xAC16, 0xAA23, 0xA896, 0xA772, 0xA6B9, 0xA66A, 0xA688,
        0xA710, 0xA804, 0xA961, 0xAB26, 0xAD51, 0xAFDF, 0xB2CE, 0xB619, 0xB9BD, 0xBDB5, 0xC1FD, 0xC68F, 0xCB66, 0xD07D, 0xD5CC, 0xDB4E,
        0xE0FC, 0xE6D0, 0xECC1, 0xF2CA, 0xF8E3, 0xFF04, 0x0525, 0x0B41, 0x1150, 0x174A, 0x1D28, 0x22E2, 0x2873, 0x2DD4, 0x32FD, 0x37E9,
        0x3C93, 0x40F3, 0x4505, 0x48C5, 0x4C2D, 0x4F3A, 0x51E7, 0x5432, 0x5618, 0x5797, 0x58AD, 0x5958, 0x5998, 0x596C, 0x58D5, 0x57D4,
        0x5668, 0x5496, 0x525D, 0x4FC2, 0x4CC7, 0x4970, 0x45C0, 0x41BD, 0x3D6B, 0x38CF, 0x33EF, 0x2ED1, 0x297A, 0x23F2, 0x1E3E, 0x1866,
        0x1271, 0x0C66, 0x064C, 0x002A, 0xFA09, 0xF3EF, 0xEDE2, 0xE7EC, 0xE212, 0xDC5C, 0xD6D2, 0xD178, 0xCC57, 0xC773, 0xC2D3, 0xBE7D,
        0xBA76, 0xB6C2, 0xB365, 0xB065, 0xADC5, 0xAB87, 0xA9AE, 0xA83E, 0xA736, 0xA699, 0xA668, 0xA6A2, 0xA747, 0xA857, 0xA9D0, 0xABB1,
        0xADF6, 0xB09F, 0xB3A6, 0xB70A, 0xBAC4, 0xBED2, 0xC32F, 0xC7D4, 0xCCBD, 0xD1E3, 0xD740, 0xDCCF, 0xE288, 0xE864, 0xEE5C, 0xF46A,
        0xFA86, 0x00A7, 0x06C8, 0x0CE1, 0x12EB, 0x18DE, 0x1EB4, 0x2464, 0x29E9, 0x2F3B, 0x3455, 0x392F, 0x3DC5, 0x4211, 0x460E, 0x49B7,
        0x4D07, 0x4FFA, 0x528E, 0x54BE, 0x5689, 0x57EC, 0x58E5, 0x5974, 0x5997, 0x594E, 0x589B, 0x577D, 0x55F6, 0x5407, 0x51B4, 0x4EFF,
        0x4BEB, 0x487C, 0x44B5, 0x409D, 0x3C36, 0x3788, 0x3297, 0x2D69, 0x2804, 0x2270, 0x1CB2, 0x16D1, 0x10D5, 0x0AC6, 0x04A9, 0xFE87,
        0xF866, 0xF24F, 0xEC48, 0xE658, 0xE087, 0xDADD, 0xD55E, 0xD013, 0xCB02, 0xC630, 0xC1A3, 0xBD61, 0xB970, 0xB5D3, 0xB28F, 0xAFA8,
        0xAD21, 0xAAFE, 0xA941, 0xA7ED, 0xA702, 0xA681, 0xA66D, 0xA6C3, 0xA785, 0xA8B2, 0xAA47, 0xAC42, 0xAEA3, 0xB165, 0xB485, 0xB801,
        0xBBD2, 0xBFF5, 0xC466, 0xC91E, 0xCE17, 0xD34D, 0xD8B8, 0xDE53, 0xE416, 0xE9FA, 0xEFF9, 0xF60B, 0xFC29, 0x024B, 0x086B, 0x0E81,
        0x1485, 0x1A71, 0x203D, 0x25E2, 0x2B5A, 0x309E, 0x35A7, 0x3A70, 0x3EF3, 0x432A, 0x4711, 0x4AA2, 0x4DDA, 0x50B4, 0x532E, 0x5543,
        0x56F2, 0x5839, 0x5916, 0x5988, 0x598E, 0x5929, 0x5859, 0x571E, 0x557C, 0x5372, 0x5104, 0x4E35, 0x4B09, 0x4782, 0x43A5, 0x3F77,
        0x3AFD, 0x363C, 0x313A, 0x2BFD, 0x268B, 0x20EA, 0x1B22, 0x153A, 0x0F38, 0x0924, 0x0305, 0xFCE3, 0xF6C4, 0xF0B0, 0xEAAF, 0xE4C7,
        0xDF00, 0xD960, 0xD3EF, 0xCEB2, 0xC9B1, 0xC4F1, 0xC078, 0xBC4B, 0xB870, 0xB4EA, 0xB1BF, 0xAEF1, 0xAC85, 0xAA7D, 0xA8DC, 0xA7A3,
        0xA6D5, 0xA671, 0xA679, 0xA6ED, 0xA7CB, 0xA914, 0xAAC4, 0xACDB, 0xAF56, 0xB232, 0xB56B, 0xB8FE, 0xBCE6, 0xC11E, 0xC5A2, 0xCA6C,
        0xCF76, 0xD4BB, 0xDA34, 0xDFD9, 0xE5A6, 0xEB92, 0xF197, 0xF7AD, 0xFDCD, 0x03EF, 0x0A0D, 0x101F, 0x161D, 0x1C01, 0x21C3, 0x275D,
        0x2CC8, 0x31FD, 0x36F5, 0x3BAC, 0x401B, 0x443D, 0x480E, 0x4B87, 0x4EA7, 0x5167, 0x53C6, 0x55C0, 0x5754, 0x587E, 0x593F, 0x5994,
        0x597D, 0x58FC, 0x580F, 0x56B9, 0x54FA, 0x52D5, 0x504E, 0x4D65, 0x4A20, 0x4682, 0x428F, 0x3E4C, 0x39BE, 0x34EB, 0x2FD9, 0x2A8D,
        0x250E, 0x1F62, 0x1991, 0x13A1, 0x0D9A, 0x0782, 0x0161, 0xFB3F, 0xF523, 0xEF13, 0xE918, 0xE338, 0xDD7A, 0xD7E7, 0xD283, 0xCD56,
        0xC865, 0xC3B8, 0xBF53, 0xBB3B, 0xB776, 0xB408, 0xB0F6, 0xAE42, 0xABF0, 0xAA04, 0xA87E, 0xA762, 0xA6B0, 0xA669, 0xA68E, 0xA71E,
        0xA819, 0xA97D, 0xAB49, 0xAD7B, 0xB010, 0xB306, 0xB657, 0xBA01, 0xBDFF, 0xC24C, 0xC6E3, 0xCBBF, 0xD0D9, 0xD62D, 0xDBB2, 0xE163,
        0xE739, 0xED2C, 0xF336, 0xF950, 0xFF71, 0x0592, 0x0BAE, 0x11BB, 0x17B3, 0x1D8F, 0x2347, 0x28D5, 0x2E32, 0x3357, 0x383F, 0x3CE3,
        0x413E, 0x454B, 0x4904, 0x4C66, 0x4F6C, 0x5213, 0x5457, 0x5636, 0x57AE, 0x58BC, 0x5960, 0x5998, 0x5965, 0x58C7, 0x57BE, 0x564B,
        0x5471, 0x5232, 0x4F90, 0x4C8E, 0x4931, 0x457B, 0x4173, 0x3D1B, 0x387A, 0x3396, 0x2E73, 0x2919, 0x238E, 0x1DD7, 0x17FD, 0x1206,
        0x0BFA, 0x05DF, 0xFFBE, 0xF99C, 0xF382, 0xED77, 0xE782, 0xE1AB, 0xDBF8, 0xD671, 0xD11B, 0xCBFD, 0xC71E, 0xC284, 0xBE33, 0xBA31,
        0xB683, 0xB32D, 0xB033, 0xAD99, 0xAB63, 0xA991, 0xA828, 0xA728, 0xA692, 0xA668, 0xA6AA, 0xA757, 0xA86E, 0xA9EE, 0xABD6, 0xAE23,
        0xB0D2, 0xB3E0, 0xB749, 0xBB0A, 0xBF1E, 0xC37F, 0xC829, 0xCD16, 0xD241, 0xD7A2, 0xDD34, 0xE2EF, 0xE8CD, 0xEEC8, 0xF4D7, 0xFAF3,
        0x0114, 0x0735, 0x0D4E, 0x1356, 0x1947, 0x1F1A, 0x24C8, 0x2A49, 0x2F98, 0x34AD, 0x3983, 0x3E14, 0x425B, 0x4652, 0x49F5, 0x4D3E,
        0x502B, 0x52B8, 0x54E2, 0x56A5, 0x5801, 0x58F2, 0x597A, 0x5995, 0x5945, 0x588A, 0x5765, 0x55D7, 0x53E1, 0x5187, 0x4ECB, 0x4BB1,
        0x483B, 0x446F, 0x4051, 0x3BE5, 0x3732, 0x323C, 0x2D0A, 0x27A2, 0x220A, 0x1C4A, 0x1667, 0x106A, 0x0A59, 0x043B, 0xFE1A, 0xF7F9,
        0xF1E3, 0xEBDD, 0xE5EF, 0xE021, 0xDA79, 0xD4FE, 0xCFB7, 0xCAAA, 0xC5DC, 0xC155, 0xBD18, 0xB92D, 0xB596, 0xB258, 0xAF78, 0xACF8,
        0xAADC, 0xA926, 0xA7D9, 0xA6F5, 0xA67D, 0xA66F, 0xA6CD, 0xA797, 0xA8CA, 0xAA67, 0xAC6A, 0xAED1, 0xB19A, 0xB4C1, 0xB842, 0xBC19,
        0xC042, 0xC4B8, 0xC974, 0xCE72, 0xD3AC, 0xD91B, 0xDEB8, 0xE47E, 0xEA64, 0xF065, 0xF678, 0xFC96, 0x02B8, 0x08D8, 0x0EED, 0x14EF,
        0x1AD9, 0x20A3, 0x2645, 0x2BBA, 0x30FA, 0x35FF, 0x3AC3, 0x3F41, 0x4373, 0x4753, 0x4ADF, 0x4E10, 0x50E3, 0x5356, 0x5564, 0x570C,
        0x584C, 0x5921, 0x598C, 0x598A, 0x591E, 0x5846, 0x5705, 0x555B, 0x534A, 0x50D5, 0x4E00, 0x4ACD, 0x4740, 0x435D, 0x3F2A, 0x3AAA,
        0x35E5, 0x30DE, 0x2B9D, 0x2628, 0x2084, 0x1ABA, 0x14D0, 0x0ECC, 0x08B7, 0x0298, 0xFC76, 0xF657, 0xF045, 0xEA45, 0xE45F, 0xDE9A,
        0xD8FD, 0xD390, 0xCE57, 0xC95A, 0xC49F, 0xC02B, 0xBC04, 0xB82E, 0xB4AF, 0xB18A, 0xAEC3, 0xAC5E, 0xAA5D, 0xA8C3, 0xA792, 0xA6CA,
        0xA66E, 0xA67E, 0xA6F9, 0xA7DF, 0xA92E, 0xAAE6, 0xAD04, 0xAF86, 0xB268, 0xB5A8, 0xB941, 0xBD2E, 0xC16C, 0xC5F5, 0xCAC4, 0xCFD2,
        0xD51B, 0xDA97, 0xE040, 0xE60F, 0xEBFD, 0xF203, 0xF81A, 0xFE3A, 0x045C, 0x0A79, 0x108A, 0x1687, 0x1C69, 0x2229, 0x27BF, 0x2D26,
        0x3257, 0x374C, 0x3BFE, 0x4068, 0x4484, 0x484F, 0x4BC2, 0x4EDB, 0x5195, 0x53ED, 0x55E0, 0x576C, 0x588F, 0x5948, 0x5996, 0x5978,
        0x58EF, 0x57FA, 0x569D, 0x54D7, 0x52AC, 0x501D, 0x4D2E, 0x49E2, 0x463E, 0x4245, 0x3DFD, 0x396A, 0x3493, 0x2F7C, 0x2A2C, 0x24AA,
        0x1EFC, 0x1928, 0x1336, 0x0D2D, 0x0715, 0x00F4, 0xFAD2, 0xF4B6, 0xEEA8, 0xE8AE, 0xE2D0, 0xDD16, 0xD785, 0xD225, 0xCCFC, 0xC810,
        0xC367, 0xBF07, 0xBAF5, 0xB736, 0xB3CF, 0xB0C2, 0xAE15, 0xABCB, 0xA9E5, 0xA867, 0xA752, 0xA6A7, 0xA668, 0xA694, 0xA72C, 0xA82E,
        0xA99A, 0xAB6D, 0xADA6, 0xB042, 0xB33E, 0xB695, 0xBA45, 0xBE49, 0xC29B, 0xC738, 0xCC18, 0xD137, 0xD68D, 0xDC16, 0xE1CA, 0xE7A2,
        0xED97, 0xF3A2, 0xF9BD, 0xFFDE, 0x05FF, 0x0C1A, 0x1226, 0x181D, 0x1DF6, 0x23AB, 0x2936, 0x2E8F, 0x33B1, 0x3894, 0x3D33, 0x4189,
        0x4590, 0x4943, 0x4C9F, 0x4F9F, 0x523F, 0x547C, 0x5654, 0x57C4, 0x58CB, 0x5967, 0x5998, 0x595E, 0x58B8, 0x57A7, 0x562E, 0x544C,
        0x5206, 0x4F5D, 0x4C55, 0x48F1, 0x4536, 0x4128, 0x3CCB, 0x3825, 0x333C, 0x2E16, 0x28B8, 0x2329, 0x1D70, 0x1794, 0x119B, 0x0B8D,
        0x0572, 0xFF50, 0xF92F, 0xF316, 0xED0C, 0xE719, 0xE144, 0xDB94, 0xD610, 0xD0BE, 0xCBA4, 0xC6CA, 0xC234, 0xBDE9, 0xB9EC, 0xB644,
        0xB2F5, 0xB002, 0xAD6F, 0xAB3F, 0xA975, 0xA812, 0xA71A, 0xA68C, 0xA669, 0xA6B2, 0xA767, 0xA885, 0xAA0D, 0xABFC, 0xAE4F, 0xB105,
        0xB41A, 0xB789, 0xBB50, 0xBF69, 0xC3D0, 0xC87F, 0xCD71, 0xD29F, 0xD804, 0xDD98, 0xE357, 0xE937, 0xEF33, 0xF543, 0xFB60, 0x0182,
        0x07A2, 0x0DBA, 0x13C1, 0x19B0, 0x1F81, 0x252B, 0x2AA9, 0x2FF4, 0x3505, 0x39D7, 0x3E63, 0x42A4, 0x4696, 0x4A32, 0x4D76, 0x505C,
        0x52E2, 0x5504, 0x56C1, 0x5815, 0x58FF, 0x597F, 0x5993, 0x593C, 0x5879, 0x574D, 0x55B7, 0x53BB, 0x515A, 0x4E97, 0x4B76, 0x47FA,
        0x4428, 0x4005, 0x3B94, 0x36DC, 0x31E2, 0x2CAC, 0x2740, 0x21A5, 0x1BE2, 0x15FD, 0x0FFE, 0x09EC, 0x03CE, 0xFDAC, 0xF78D, 0xF177,
        0xEB73, 0xE587, 0xDFBB, 0xDA16, 0xD49E, 0xCF5B, 0xCA52, 0xC589, 0xC107, 0xBCD0, 0xB8EA, 0xB559, 0xB222, 0xAF48, 0xACCF, 0xAABA,
        0xA90C, 0xA7C6, 0xA6E9, 0xA678, 0xA672, 0xA6D8, 0xA7A9, 0xA8E4, 0xAA87, 0xAC91, 0xAEFF, 0xB1CF, 0xB4FC, 0xB884, 0xBC61, 0xC08F,
        0xC50A, 0xC9CB, 0xCECE, 0xD40B, 0xD97D, 0xDF1E, 0xE4E6, 0xEACE, 0xF0D0, 0xF6E5, 0xFD04, 0x0325, 0x0944, 0x0F58, 0x155A, 0x1B41,
        0x2109, 0x26A8, 0x2C19, 0x3155, 0x3656, 0x3B15, 0x3F8E, 0x43BA, 0x4795, 0x4B1A, 0x4E45, 0x5112, 0x537E, 0x5585, 0x5726, 0x585E,
        0x592C, 0x598F, 0x5986, 0x5912, 0x5833, 0x56EA, 0x5539, 0x5321, 0x50A6, 0x4DCA, 0x4A90, 0x46FD, 0x4315, 0x3EDC, 0x3A58, 0x358D,
        0x3082, 0x2B3D, 0x25C5, 0x201E, 0x1A52, 0x1465, 0x0E60, 0x084A, 0x022A, 0xFC09, 0xF5EB, 0xEFD9, 0xE9DB, 0xE3F7, 0xDE35, 0xD89B,
        0xD331, 0xCDFC, 0xC904, 0xC44D, 0xBFDF, 0xBBBD, 0xB7ED, 0xB474, 0xB155, 0xAE95, 0xAC37, 0xAA3D, 0xA8AA, 0xA780, 0xA6C1, 0xA66C,
        0xA683, 0xA705, 0xA7F3, 0xA94A, 0xAB09, 0xAD2E, 0xAFB6, 0xB29F, 0xB5E5, 0xB984, 0xBD77, 0xC1BA, 0xC649, 0xCB1C, 0xD02F, 0xD57B,
        0xDAFA, 0xE0A6, 0xE677, 0xEC67, 0xF26F, 0xF887, 0xFEA8, 0x04C9, 0x0AE6, 0x10F6, 0x16F1, 0x1CD0, 0x228E, 0x2821, 0x2D85, 0x32B1,
        0x37A1, 0x3C4F, 0x40B3, 0x44CA, 0x488F, 0x4BFC, 0x4F0E, 0x51C2, 0x5413, 0x55FF, 0x5784, 0x58A0, 0x5951, 0x5997, 0x5972, 0x58E1,
        0x57E6, 0x5681, 0x54B4, 0x5281, 0x4FEC, 0x4CF6, 0x49A4, 0x45FA, 0x41FB, 0x3DAE, 0x3916, 0x343A, 0x2F1F, 0x29CC, 0x2446, 0x1E95,
        0x18BF, 0x12CB, 0x0CC1, 0x06A8, 0x0086, 0xFA65, 0xF44A, 0xEE3C, 0xE844, 0xE269, 0xDCB1, 0xD723, 0xD1C7, 0xCCA2, 0xC7BB, 0xC317,
        0xBEBC, 0xBAB0, 0xB6F7, 0xB395, 0xB090, 0xADE9, 0xABA6, 0xA9C7, 0xA850, 0xA743, 0xA69F, 0xA668, 0xA69B, 0xA73A, 0xA844, 0xA9B7,
        0xAB92, 0xADD2, 0xB074, 0xB376, 0xB6D4, 0xBA8A, 0xBE93, 0xC2EB, 0xC78C, 0xCC71, 0xD194, 0xD6EF, 0xDC7A, 0xE231, 0xE80B, 0xEE02,
        0xF40F, 0xFA2A, 0x004B, 0x066C, 0x0C86, 0x1291, 0x1886, 0x1E5D, 0x2410, 0x2997, 0x2EED, 0x340A, 0x38E8, 0x3D83, 0x41D3, 0x45D5,
        0x4982, 0x4CD8, 0x4FD1, 0x526A, 0x54A0, 0x5671, 0x57DA, 0x58D9, 0x596E, 0x5998, 0x5956, 0x58A8, 0x5790, 0x560F, 0x5427, 0x51DA,
        0x4F2A, 0x4C1C, 0x48B2, 0x44F0, 0x40DC, 0x3C7A, 0x37D0, 0x32E2, 0x2DB8, 0x2856, 0x22C4, 0x1D09, 0x172A, 0x1130, 0x0B21, 0x0505,
        0xFEE3, 0xF8C2, 0xF2AA, 0xECA1, 0xE6B0, 0xE0DE, 0xDB30, 0xD5AF, 0xD061, 0xCB4C, 0xC676, 0xC1E5, 0xBD9F, 0xB9A9, 0xB607, 0xB2BD,
        0xAFD1, 0xAD45, 0xAB1C, 0xA959, 0xA7FE, 0xA70C, 0xA686, 0xA66B, 0xA6BB, 0xA777, 0xA89D, 0xAA2C, 0xAC22, 0xAE7C, 0xB139, 0xB454,
        0xB7CA, 0xBB96, 0xBFB5, 0xC421, 0xC8D5, 0xCDCB, 0xD2FD, 0xD866, 0xDDFE, 0xE3BE, 0xE9A1, 0xEF9E, 0xF5B0, 0xFBCD, 0x01EF, 0x080F,
        0x0E26, 0x142B, 0x1A19, 0x1FE7, 0x258F, 0x2B09, 0x3050, 0x355D, 0x3A2A, 0x3EB1, 0x42ED, 0x46D9, 0x4A6F, 0x4DAC, 0x508C, 0x530B,
        0x5527, 0x56DC, 0x5829, 0x590C, 0x5984, 0x5991, 0x5932, 0x5868, 0x5734, 0x5597, 0x5393, 0x512C, 0x4E62, 0x4B3B, 0x47B9, 0x43E1,
        0x3FB8, 0x3B42, 0x3685, 0x3187, 0x2C4D, 0x26DE, 0x2140, 0x1B7A, 0x1593, 0x0F93, 0x0980, 0x0361, 0xFD3F, 0xF720, 0xF10B, 0xEB08,
        0xE51F, 0xDF55, 0xD9B3, 0xD43F, 0xCEFF, 0xC9FA, 0xC537, 0xC0B9, 0xBC88, 0xB8A7, 0xB51D, 0xB1EC, 0xAF19, 0xACA7, 0xAA99, 0xA8F2,
        0xA7B3, 0xA6DE, 0xA674, 0xA676, 0xA6E3, 0xA7BB, 0xA8FD, 0xAAA8, 0xACB9, 0xAF2E, 0xB204, 0xB538, 0xB8C6, 0xBCA9, 0xC0DD, 0xC55C,
        0xCA22, 0xCF29, 0xD46A, 0xD9E0, 0xDF84, 0xE54E, 0xEB39, 0xF13C, 0xF751, 0xFD71, 0x0393, 0x09B1, 0x0FC4, 0x15C4, 0x1BAA, 0x216E,
        0x270A, 0x2C78, 0x31B0, 0x36AD, 0x3B67, 0x3FDB, 0x4402, 0x47D7, 0x4B56, 0x4E7A, 0x5141, 0x53A5, 0x55A6, 0x573F, 0x5870, 0x5936,
        0x5992, 0x5982, 0x5906, 0x5820, 0x56CF, 0x5517, 0x52F8, 0x5076, 0x4D93, 0x4A53, 0x46BA, 0x42CC, 0x3E8E, 0x3A04, 0x3535, 0x3026,
        0x2ADE, 0x2561, 0x1FB8, 0x19E9, 0x13FB, 0x0DF4, 0x07DD, 0x01BD, 0xFB9B, 0xF57E, 0xEF6D, 0xE971, 0xE38F, 0xDDCF, 0xD839, 0xD2D2,
        0xCDA2, 0xC8AE, 0xC3FC, 0xBF92, 0xBB76, 0xB7AC, 0xB439, 0xB121, 0xAE68, 0xAC10, 0xAA1E, 0xA892, 0xA76F, 0xA6B7, 0xA66A, 0xA689,
        0xA712, 0xA807, 0xA965, 0xAB2C, 0xAD58, 0xAFE7, 0xB2D7, 0xB623, 0xB9C8, 0xBDC1, 0xC209, 0xC69C, 0xCB74, 0xD08B, 0xD5DB, 0xDB5E,
        0xE10D, 0xE6E0, 0xECD2, 0xF2DB, 0xF8F4, 0xFF15, 0x0536, 0x0B52, 0x1161, 0x175A, 0x1D38, 0x22F2, 0x2883, 0x2DE3, 0x330C, 0x37F7,
        0x3C9F, 0x40FF, 0x4510, 0x48CF, 0x4C36, 0x4F42, 0x51EE, 0x5438, 0x561D, 0x579B, 0x58AF, 0x5959, 0x5998, 0x596B, 0x58D3, 0x57D0,
        0x5664, 0x5490, 0x5256, 0x4FBA, 0x4CBE, 0x4966, 0x45B5, 0x41B1, 0x3D5E, 0x38C2, 0x33E1, 0x2EC2, 0x296B, 0x23E2, 0x1E2E, 0x1856,
        0x1260, 0x0C55, 0x063B, 0x0019, 0xF9F8, 0xF3DD, 0xEDD1, 0xE7DB, 0xE202, 0xDC4D, 0xD6C2, 0xD169, 0xCC48, 0xC766, 0xC2C7, 0xBE71,
        0xBA6B, 0xB6B8, 0xB35C, 0xB05D, 0xADBE, 0xAB81, 0xA9AA, 0xA83A, 0xA734, 0xA698, 0xA668, 0xA6A3, 0xA749, 0xA85B, 0xA9D5, 0xABB6,
        0xADFD, 0xB0A7, 0xB3AF, 0xB714, 0xBACF, 0xBEDE, 0xC33B, 0xC7E1, 0xCCCB, 0xD1F2, 0xD750, 0xDCDF, 0xE298, 0xE875, 0xEE6D, 0xF47B,
        0xFA97, 0x00B8, 0x06D9, 0x0CF3, 0x12FC, 0x18EF, 0x1EC4, 0x2474, 0x29F8, 0x2F4A, 0x3463, 0x393D, 0x3DD2, 0x421D, 0x4619, 0x49C1,
        0x4D10, 0x5002, 0x5295, 0x54C4, 0x568E, 0x57EF, 0x58E7, 0x5975, 0x5997, 0x594D, 0x5898, 0x5779, 0x55F1, 0x5401, 0x51AD, 0x4EF7,
        0x4BE2, 0x4872, 0x44AA, 0x4091, 0x3C2A, 0x377A, 0x3288, 0x2D5A, 0x27F5, 0x2260, 0x1CA1, 0x16C1, 0x10C4, 0x0AB4, 0x0497, 0xFE76,
        0xF855, 0xF23E, 0xEC37, 0xE648, 0xE077, 0xDACD, 0xD54F, 0xD005, 0xCAF4, 0xC622, 0xC197, 0xBD56, 0xB965, 0xB5C9, 0xB286, 0xAFA0,
        0xAD1B, 0xAAF9, 0xA93D, 0xA7EA, 0xA700, 0xA681, 0xA66D, 0xA6C5, 0xA788, 0xA8B5, 0xAA4C, 0xAC49, 0xAEAA, 0xB16D, 0xB48F, 0xB80B,
        0xBBDD, 0xC002, 0xC473, 0xC92B, 0xCE26, 0xD35C, 0xD8C8, 0xDE63, 0xE426, 0xEA0B, 0xF00A, 0xF61C, 0xFC3A, 0x025C, 0x087C, 0x0E92,
        0x1496, 0x1A81, 0x204D, 0x25F2, 0x2B69, 0x30AC, 0x35B5, 0x3A7D, 0x3EFF, 0x4336, 0x471C, 0x4AAC, 0x4DE3, 0x50BC, 0x5334, 0x5548,
        0x56F6, 0x583C, 0x5918, 0x5988, 0x598D, 0x5927, 0x5856, 0x571A, 0x5576, 0x536C, 0x50FD, 0x4E2D, 0x4AFF, 0x4777, 0x439A, 0x3F6B,
        0x3AF0, 0x362E, 0x312B, 0x2BED, 0x267B, 0x20DA, 0x1B12, 0x1529, 0x0F27, 0x0913, 0x02F4, 0xFCD2, 0xF6B3, 0xF09F, 0xEA9E, 0xE4B6,
        0xDEEF, 0xD950, 0xD3E0, 0xCEA4, 0xC9A3, 0xC4E4, 0xC06C, 0xBC40, 0xB865, 0xB4E1, 0xB1B6, 0xAEEA, 0xAC7F, 0xAA78, 0xA8D8, 0xA7A1,
        0xA6D3, 0xA671, 0xA67A, 0xA6EF, 0xA7CE, 0xA918, 0xAACA, 0xACE2, 0xAF5E, 0xB23A, 0xB575, 0xB908, 0xBCF1, 0xC12A, 0xC5AF, 0xCA7A,
        0xCF85, 0xD4CA, 0xDA43, 0xDFEA, 0xE5B7, 0xEBA3, 0xF1A8, 0xF7BE, 0xFDDE, 0x0400, 0x0A1E, 0x1030, 0x162E, 0x1C11, 0x21D3, 0x276D,
        0x2CD7, 0x320B, 0x3703, 0x3BB9, 0x4027, 0x4449, 0x4818, 0x4B91, 0x4EAF, 0x516E, 0x53CC, 0x55C5, 0x5758, 0x5881, 0x5940, 0x5994,
        0x597D, 0x58FA, 0x580C, 0x56B4, 0x54F5, 0x52CF, 0x5046, 0x4D5C, 0x4A16, 0x4677, 0x4283, 0x3E3F, 0x39B1, 0x34DD, 0x2FCA, 0x2A7D,
        0x24FE, 0x1F52, 0x1980, 0x1390, 0x0D88, 0x0771, 0x0150, 0xFB2E, 0xF512, 0xEF02, 0xE907, 0xE327, 0xDD6A, 0xD7D7, 0xD274, 0xCD47,
        0xC858, 0xC3AB, 0xBF47, 0xBB30, 0xB76C, 0xB3FF, 0xB0EE, 0xAE3B, 0xABEA, 0xA9FF, 0xA87A, 0xA75F, 0xA6AE, 0xA669, 0xA68F, 0xA720,
        0xA81C, 0xA982, 0xAB4F, 0xAD82, 0xB018, 0xB30E, 0xB661, 0xBA0C, 0xBE0A, 0xC258, 0xC6F0, 0xCBCD, 0xD0E8, 0xD63C, 0xDBC2, 0xE173,
        0xE749, 0xED3D, 0xF347, 0xF961, 0xFF82, 0x05A3, 0x0BBF, 0x11CC, 0x17C4, 0x1D9F, 0x2357, 0x28E4, 0x2E41, 0x3365, 0x384C, 0x3CF0,
        0x414A, 0x4556, 0x490E, 0x4C6F, 0x4F74, 0x521A, 0x545D, 0x563B, 0x57B2, 0x58BF, 0x5961, 0x5998, 0x5964, 0x58C4, 0x57BA, 0x5647,
        0x546B, 0x522B, 0x4F88, 0x4C85, 0x4927, 0x4570, 0x4167, 0x3D0E, 0x386D, 0x3388, 0x2E65, 0x290A, 0x237E, 0x1DC7, 0x17ED, 0x11F5,
        0x0BE9, 0x05CE, 0xFFAD, 0xF98B, 0xF371, 0xED66, 0xE772, 0xE19B, 0xDBE8, 0xD661, 0xD10C, 0xCBEF, 0xC711, 0xC277, 0xBE27, 0xBA26,
        0xB679, 0xB324, 0xB02B, 0xAD93, 0xAB5D, 0xA98D, 0xA824, 0xA725, 0xA691, 0xA668, 0xA6AB, 0xA759, 0xA871, 0xA9F3, 0xABDC, 0xAE2A,
        0xB0DA, 0xB3E9, 0xB753, 0xBB15, 0xBF2A, 0xC38C, 0xC837, 0xCD25, 0xD250, 0xD7B1, 0xDD44, 0xE2FF, 0xE8DE, 0xEED9, 0xF4E8, 0xFB04,
        0x0125, 0x0746, 0x0D5F, 0x1367, 0x1958, 0x1F2A, 0x24D7, 0x2A58, 0x2FA6, 0x34BB, 0x3991, 0x3E21, 0x4267, 0x465D, 0x49FE, 0x4D47,
        0x5033, 0x52BF, 0x54E7, 0x56AA, 0x5804, 0x58F5, 0x597A, 0x5995, 0x5944, 0x5888, 0x5761, 0x55D2, 0x53DB, 0x5180, 0x4EC3, 0x4BA7,
        0x4831, 0x4464, 0x4045, 0x3BD8, 0x3724, 0x322E, 0x2CFB, 0x2793, 0x21FA, 0x1C3A, 0x1657, 0x1059, 0x0A48, 0x042A, 0xFE08, 0xF7E8,
        0xF1D2, 0xEBCC, 0xE5DF, 0xE011, 0xDA69, 0xD4EF, 0xCFA8, 0xCA9C, 0xC5CF, 0xC148, 0xBD0D, 0xB922, 0xB58C, 0xB24F, 0xAF70, 0xACF2,
        0xAAD7, 0xA922, 0xA7D6, 0xA6F3, 0xA67C, 0xA670, 0xA6CF, 0xA79A, 0xA8CE, 0xAA6C, 0xAC70, 0xAED8, 0xB1A2, 0xB4CA, 0xB84C, 0xBC24,
        0xC04E, 0xC4C5, 0xC982, 0xCE81, 0xD3BB, 0xD92A, 0xDEC8, 0xE48E, 0xEA75, 0xF076, 0xF689, 0xFCA8, 0x02C9, 0x08E9, 0x0EFE, 0x1500,
        0x1AEA, 0x20B3, 0x2655, 0x2BC9, 0x3108, 0x360C, 0x3AD0, 0x3F4D, 0x437E, 0x475E, 0x4AE8, 0x4E18, 0x50EB, 0x535C, 0x556A, 0x5710,
        0x584F, 0x5923, 0x598C, 0x598A, 0x591C, 0x5843, 0x5700, 0x5555, 0x5344, 0x50CE, 0x4DF7, 0x4AC3, 0x4735, 0x4352, 0x3F1D, 0x3A9D,
        0x35D7, 0x30A9, 0x2B48, 0x25BD, 0x200C, 0x1A3F, 0x145B, 0x0E69, 0x086F, 0x0274, 0xFC81, 0xF69C, 0xF0CB, 0xEB15, 0xE583, 0xE019,
        0xDADF, 0xD5DA, 0xD10F, 0xCC86, 0xC841, 0xC447, 0xC09B, 0xBD41, 0xBA3D, 0xB792, 0xB542, 0xB351, 0xB1BE, 0xB08D, 0xAFBC, 0xAF4E,
        0xAF41, 0xAF95, 0xB04A, 0xB15D, 0xB2CC, 0xB496, 0xB6B7, 0xB92D, 0xBBF3, 0xBF07, 0xC263, 0xC603, 0xC9E3, 0xCDFC, 0xD24B, 0xD6C9,
        0xDB70, 0xE03C, 0xE524, 0xEA25, 0xEF36, 0xF453, 0xF975, 0xFE95, 0x03AC, 0x08B7, 0x0DAF, 0x128D, 0x174B, 0x1BE5, 0x2056, 0x2497,
        0x28A4, 0x2C79, 0x3012, 0x336A, 0x367E, 0x394B, 0x3BCD, 0x3E03, 0x3FEB, 0x4182, 0x42C7, 0x43BA, 0x445A, 0x44A6, 0x449F, 0x4445,
        0x439B, 0x42A0, 0x4157, 0x3FC2, 0x3DE3, 0x3BBE, 0x3955, 0x36AB, 0x33C6, 0x30A7, 0x2D54, 0x29D2, 0x2624, 0x224F, 0x1E59, 0x1A46,
        0x161B, 0x11DF, 0x0D95, 0x0943, 0x04F0, 0x009E, 0xFC56, 0xF81A, 0xF3F1, 0xEFDE, 0xEBE7, 0xE810, 0xE45E, 0xE0D4, 0xDD78, 0xDA4C,
        0xD754, 0xD493, 0xD20C, 0xCFC2, 0xCDB6, 0xCBEB, 0xCA63, 0xC91F, 0xC81F, 0xC764, 0xC6EF, 0xC6C0, 0xC6D6, 0xC731, 0xC7CF, 0xC8B0,
        0xC9D1, 0xCB31, 0xCCCD, 0xCEA4, 0xD0B2, 0xD2F4, 0xD567, 0xD809, 0xDAD4, 0xDDC6, 0xE0DB, 0xE40E, 0xE75C, 0xEAC0, 0xEE36, 0xF1B9,
        0xF546, 0xF8D7, 0xFC69, 0xFFF7, 0x037C, 0x06F5, 0x0A5E, 0x0DB3, 0x10EF, 0x1410, 0x1711, 0x19EF, 0x1CA7, 0x1F36, 0x219A, 0x23CF,
        0x25D4, 0x27A6, 0x2945, 0x2AAE, 0x2BE0, 0x2CDA, 0x2D9C, 0x2E25, 0x2E75, 0x2E8C, 0x2E6C, 0x2E13, 0x2D84, 0x2CBF, 0x2BC7, 0x2A9C,
        0x2941, 0x27B7, 0x2601, 0x2422, 0x221C, 0x1FF3, 0x1DA8, 0x1B3F, 0x18BC, 0x1622, 0x1373, 0x10B4, 0x0DE8, 0x0B13, 0x0838, 0x055A,
        0x027E, 0xFFA7, 0xFCD8, 0xFA13, 0xF75D, 0xF4B9, 0xF22A, 0xEFB2, 0xED55, 0xEB15, 0xE8F4, 0xE6F5, 0xE519, 0xE363, 0xE1D5, 0xE06F,
        0xDF33, 0xDE23, 0xDD3E, 0xDC86, 0xDBFA, 0xDB9C, 0xDB6B, 0xDB66, 0xDB8D, 0xDBE1, 0xDC5F, 0xDD06, 0xDDD6, 0xDECC, 0xDFE8, 0xE128,
        0xE289, 0xE409, 0xE5A7, 0xE75F, 0xE931, 0xEB18, 0xED13, 0xEF1E, 0xF138, 0xF35D, 0xF58A, 0xF7BE, 0xF9F4, 0xFC2B, 0xFE60, 0x008F,
        0x02B7, 0x04D4, 0x06E5, 0x08E8, 0x0AD9, 0x0CB6, 0x0E7E, 0x102F, 0x11C6, 0x1343, 0x14A3, 0x15E6, 0x170A, 0x180F, 0x18F2, 0x19B5,
        0x1A56, 0x1AD4, 0x1B31, 0x1B6B, 0x1B84, 0x1B7A, 0x1B50, 0x1B05, 0x1A9A, 0x1A10, 0x1969, 0x18A5, 0x17C6, 0x16CD, 0x15BD, 0x1495,
        0x1359, 0x120A, 0x10AA, 0x0F3B, 0x0DBF, 0x0C37, 0x0AA7, 0x090F, 0x0773, 0x05D3, 0x0433, 0x0294, 0x00F8, 0xFF62, 0xFDD3, 0xFC4C,
        0xFACF, 0xF95F, 0xF7FD, 0xF6AA, 0xF568, 0xF438, 0xF31B, 0xF212, 0xF11F, 0xF041, 0xEF7B, 0xEECC, 0xEE35, 0xEDB6, 0xED4F, 0xED01,
        0xECCC, 0xECAF, 0xECAA, 0xECBC, 0xECE6, 0xED27, 0xED7E, 0xEDE9, 0xEE69, 0xEEFC, 0xEFA2, 0xF058, 0xF11E, 0xF1F3, 0xF2D5, 0xF3C3,
        0xF4BC, 0xF5BE, 0xF6C8, 0xF7D8, 0xF8ED, 0xFA05, 0xFB1F, 0xFC3A, 0xFD53, 0xFE6B, 0xFF7F, 0x008D, 0x0196, 0x0297, 0x0391, 0x0480,
        0x0566, 0x063F, 0x070D, 0x07CD, 0x0880, 0x0925, 0x09BA, 0x0A40, 0x0AB7, 0x0B1E, 0x0B74, 0x0BBB, 0x0BF1, 0x0C18, 0x0C2E, 0x0C35,
        0x0C2C, 0x0C15, 0x0BEF, 0x0BBB, 0x0B79, 0x0B2B, 0x0AD1, 0x0A6B, 0x09FB, 0x0981, 0x08FF, 0x0874, 0x07E2, 0x074A, 0x06AD, 0x060C,
        0x0567, 0x04C0, 0x0417, 0x036E, 0x02C5, 0x021D, 0x0178, 0x00D5, 0x0035, 0xFF9B, 0xFF05, 0xFE74, 0xFDEA, 0xFD67, 0xFCEB, 0xFC76,
        0xFC0A, 0xFBA6, 0xFB4B, 0xFAF9, 0xFAB0, 0xFA70, 0xFA3A, 0xFA0D, 0xF9E9, 0xF9CE, 0xF9BD, 0xF9B4, 0xF9B4, 0xF9BC, 0xF9CC, 0xF9E3,
        0xFA02, 0xFA28, 0xFA54, 0xFA86, 0xFABD, 0xFAF9, 0xFB3A, 0xFB7F, 0xFBC6, 0xFC11, 0xFC5E, 0xFCAC, 0xFCFC, 0xFD4D, 0xFD9D, 0xFDEE,
        0xFE3D, 0xFE8B, 0xFED8, 0xFF23, 0xFF6B, 0xFFB1, 0xFFF3, 0x0031, 0x006D, 0x00A4, 0x00D8, 0x0108, 0x0133, 0x015B, 0x017D, 0x019C,
        0x01B6, 0x01CB, 0x01DD, 0x01EA, 0x01F3, 0x01F9, 0x01FB, 0x01F9, 0x01F4, 0x01EC, 0x01E1, 0x01D3, 0x01C3, 0x01B1, 0x019E, 0x0188,
        0x0172, 0x015B, 0x0142, 0x012A, 0x0111, 0x00F9, 0x00E0, 0x00C8, 0x00B1, 0x009B, 0x0086, 0x0071, 0x005F, 0x004D, 0x003D, 0x002F,
        0x0023, 0x0017, 0x000E, 0x0006, 0x0000, 0xFFFC, 0xFFF9, 0xFFF7, 0xFFF6, 0xFFF6, 0xFFF7, 0xFFF9, 0xFFFB, 0xFFFD, 0xFFFF, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0005, 0x0007, 0x0009, 0x000C,
        0x000F, 0x0013, 0x0016, 0x001B, 0x001F, 0x0024, 0x0029, 0x002F, 0x0035, 0x003B, 0x0041, 0x0047, 0x004D, 0x0053, 0x0059, 0x005F,
        0x0065, 0x006A, 0x006F, 0x0074, 0x0078, 0x007B, 0x007E, 0x007F, 0x0080, 0x0080, 0x007E, 0x007C, 0x0078, 0x0073, 0x006D, 0x0065,
        0x005C, 0x0052, 0x0046, 0x0039, 0x002A, 0x0019, 0x0008, 0xFFF5, 0xFFE1, 0xFFCB, 0xFFB3, 0xFF9B, 0xFF82, 0xFF67, 0xFF4C, 0xFF30,
        0xFF13, 0xFEF6, 0xFED8, 0xFEBB, 0xFE9D, 0xFE80, 0xFE63, 0xFE46, 0xFE2A, 0xFE10, 0xFDF6, 0xFDDE, 0xFDC8, 0xFDB3, 0xFDA1, 0xFD91,
        0xFD83, 0xFD78, 0xFD6F, 0xFD6A, 0xFD68, 0xFD69, 0xFD6D, 0xFD76, 0xFD81, 0xFD91, 0xFDA5, 0xFDBC, 0xFDD7, 0xFDF7, 0xFE1A, 0xFE41,
        0xFE6D, 0xFE9C, 0xFECE, 0xFF05, 0xFF3E, 0xFF7C, 0xFFBC, 0xFFFF, 0x0044, 0x008C, 0x00D6, 0x0123, 0x0170, 0x01BF, 0x020F, 0x025F,
        0x02AF, 0x02FF, 0x034E, 0x039C, 0x03E8, 0x0433, 0x047A, 0x04BF, 0x0501, 0x053F, 0x0578, 0x05AD, 0x05DD, 0x0608, 0x062D, 0x064C,
        0x0664, 0x0675, 0x0680, 0x0683, 0x067E, 0x0672, 0x065E, 0x0641, 0x061D, 0x05F0, 0x05BB, 0x057E, 0x0538, 0x04EB, 0x0495, 0x0438,
        0x03D3, 0x0367, 0x02F4, 0x027B, 0x01FB, 0x0175, 0x00EA, 0x005A, 0xFFC7, 0xFF2F, 0xFE95, 0xFDF7, 0xFD58, 0xFCB8, 0xFC17, 0xFB77,
        0xFAD8, 0xFA3B, 0xF9A1, 0xF909, 0xF877, 0xF7E9, 0xF760, 0xF6DF, 0xF664, 0xF5F2, 0xF588, 0xF528, 0xF4D1, 0xF485, 0xF445, 0xF410,
        0xF3E8, 0xF3CC, 0xF3BE, 0xF3BD, 0xF3CA, 0xF3E5, 0xF40E, 0xF446, 0xF48C, 0xF4E1, 0xF544, 0xF5B5, 0xF634, 0xF6C1, 0xF75C, 0xF803,
        0xF8B7, 0xF977, 0xFA42, 0xFB18, 0xFBF8, 0xFCE1, 0xFDD2, 0xFECB, 0xFFCA, 0x00CE, 0x01D6, 0x02E2, 0x03F1, 0x0500, 0x060E, 0x071C,
        0x0827, 0x092D, 0x0A2F, 0x0B2A, 0x0C1E, 0x0D09, 0x0DE9, 0x0EBF, 0x0F88, 0x1043, 0x10F0, 0x118D, 0x121A, 0x1295, 0x12FE, 0x1353,
        0x1395, 0x13C2, 0x13DA, 0x13DC, 0x13C8, 0x139E, 0x135E, 0x1307, 0x1299, 0x1215, 0x117B, 0x10CA, 0x1004, 0x0F29, 0x0E39, 0x0D36,
        0x0C1F, 0x0AF7, 0x09BD, 0x0873, 0x071B, 0x05B5, 0x0443, 0x02C6, 0x013F, 0xFFB3, 0xFE1E, 0xFC86, 0xFAEB, 0xF94E, 0xF7B3, 0xF61A,
        0xF486, 0xF2F8, 0xF172, 0xEFF6, 0xEE86, 0xED23, 0xEBCF, 0xEA8D, 0xE95D, 0xE842, 0xE73C, 0xE64D, 0xE578, 0xE4BC, 0xE41B, 0xE396,
        0xE32F, 0xE2E6, 0xE2BC, 0xE2B1, 0xE2C6, 0xE2FC, 0xE353, 0xE3CA, 0xE461, 0xE519, 0xE5F2, 0xE6EA, 0xE801, 0xE936, 0xEA89, 0xEBF8,
        0xED82, 0xEF26, 0xF0E2, 0xF2B5, 0xF49D, 0xF698, 0xF8A4, 0xFAC0, 0xFCE9, 0xFF1C, 0x0158, 0x039A, 0x05E1, 0x0828, 0x0A6F, 0x0CB2,
        0x0EEF, 0x1123, 0x134C, 0x1567, 0x1771, 0x1969, 0x1B4C, 0x1D17, 0x1EC8, 0x205D, 0x21D5, 0x232B, 0x2460, 0x2572, 0x265D, 0x2722,
        0x27BF, 0x2832, 0x287B, 0x2898, 0x288A, 0x284F, 0x27E7, 0x2753, 0x2692, 0x25A5, 0x248B, 0x2347, 0x21D7, 0x203F, 0x1E7E, 0x1C97,
        0x1A8B, 0x185C, 0x160B, 0x139C, 0x110F, 0x0E68, 0x0BAA, 0x08D7, 0x05F1, 0x02FC, 0xFFFD, 0xFCF3, 0xF9E4, 0xF6D2, 0xF3C1, 0xF0B5,
        0xEDB0, 0xEAB6, 0xE7CB, 0xE4F1, 0xE22D, 0xDF81, 0xDCF1, 0xDA80, 0xD830, 0xD605, 0xD402, 0xD229, 0xD07C, 0xCEFE, 0xCDB1, 0xCC98,
        0xCBB3, 0xCB04, 0xCA8D, 0xCA4F, 0xCA4B, 0xCA81, 0xCAF1, 0xCB9C, 0xCC83, 0xCDA3, 0xCEFD, 0xD091, 0xD25C, 0xD45D, 0xD693, 0xD8FD,
        0xDB97, 0xDE5F, 0xE154, 0xE471, 0xE7B5, 0xEB1C, 0xEEA3, 0xF245, 0xF601, 0xF9D0, 0xFDB1, 0x019D, 0x0593, 0x098D, 0x0D86, 0x117C,
        0x1569, 0x1948, 0x1D16, 0x20CF, 0x246D, 0x27ED, 0x2B4A, 0x2E81, 0x318E, 0x346D, 0x371A, 0x3992, 0x3BD2, 0x3DD7, 0x3F9E, 0x4124,
        0x4267, 0x4366, 0x441E, 0x448E, 0x44B4, 0x4491, 0x4423, 0x436A, 0x4267, 0x4119, 0x3F81, 0x3DA1, 0x3B79, 0x390C, 0x365B, 0x3369,
        0x3038, 0x2CCC, 0x2927, 0x254C, 0x2140, 0x1D07, 0x18A4, 0x141C, 0x0F74, 0x0AB0, 0x05D6, 0x00EA, 0xFBF2, 0xF6F2, 0xF1F1, 0xECF3,
        0xE7FF, 0xE319, 0xDE47, 0xD98E, 0xD4F5, 0xD07F, 0xCC33, 0xC815, 0xC42A, 0xC077, 0xBD01, 0xB9CB, 0xB6DA, 0xB431, 0xB1D5, 0xAFC8,
        0xAE0D, 0xACA6, 0xAB97, 0xAAE1, 0xAA85, 0xAA85, 0xAAE1, 0xAB9A, 0xACB0, 0xAE23, 0xAFF1, 0xB219, 0xB49A, 0xB773, 0xBA9F, 0xBE1E,
        0xC22D, 0xC67F, 0xCB0E, 0xCFD6, 0xD4D1, 0xD9FB, 0xDF4D, 0xE4C2, 0xEA54, 0xEFFD, 0xF5B8, 0xFB7D, 0x0147, 0x0710, 0x0CD1, 0x1285,
        0x1825, 0x1DAB, 0x2311, 0x2852, 0x2D68, 0x324D, 0x36FC, 0x3B71, 0x3FA6, 0x4396, 0x473F, 0x4A9B, 0x4DA8, 0x5062, 0x52C5, 0x54D0,
        0x5680, 0x57D4, 0x58CA, 0x5961, 0x5998, 0x5970, 0x58E7, 0x5800, 0x56BB, 0x5518, 0x531B, 0x50C5, 0x4E19, 0x4B19, 0x47C8, 0x442B,
        0x4045, 0x3C1A, 0x37AF, 0x3309, 0x2E2B, 0x291D, 0x23E2, 0x1E81, 0x1900, 0x1363, 0x0DB2, 0x07F3, 0x022A, 0xFC61, 0xF69A, 0xF0DD,
        0xEB31, 0xE59B, 0xE021, 0xDAC9, 0xD599, 0xD096, 0xCBC7, 0xC72E, 0xC2D3, 0xBEB9, 0xBAE5, 0xB75B, 0xB41E, 0xB133, 0xAE9C, 0xAC5C,
        0xAA76, 0xA8EB, 0xA7BD, 0xA6ED, 0xA67D, 0xA66D, 0xA6BC, 0xA76B, 0xA879, 0xA9E4, 0xABAB, 0xADCD, 0xB046, 0xB315, 0xB636, 0xB9A6,
        0xBD61, 0xC163, 0xC5A9, 0xCA2C, 0xCEEA, 0xD3DC, 0xD8FD, 0xDE47, 0xE3B6, 0xE943, 0xEEE9, 0xF4A1, 0xFA65, 0x002D, 0x05F7, 0x0BBB,
        0x1171, 0x1715, 0x1CA1, 0x220E, 0x2756, 0x2C74, 0x3163, 0x361D, 0x3A9D, 0x3EDE, 0x42DD, 0x4693, 0x49FE, 0x4D1A, 0x4FE4, 0x5258,
        0x5474, 0x5635, 0x579B, 0x58A3, 0x594C, 0x5995, 0x597F, 0x5908, 0x5833, 0x56FF, 0x556F, 0x5383, 0x513D, 0x4EA1, 0x4BB0, 0x486F,
        0x44E0, 0x4108, 0x3CEA, 0x388A, 0x33EF, 0x2F1B, 0x2A16, 0x24E3, 0x1F89, 0x1A0D, 0x1475, 0x0EC8, 0x090A, 0x0343, 0xFD7A, 0xF7B2,
        0xF1F3, 0xEC43, 0xE6A8, 0xE128, 0xDBCA, 0xD692, 0xD186, 0xCCAC, 0xC809, 0xC3A2, 0xBF7B, 0xBB99, 0xB801, 0xB4B5, 0xB1BA, 0xAF13,
        0xACC3, 0xAACB, 0xA92F, 0xA7EF, 0xA70D, 0xA68B, 0xA669, 0xA6A6, 0xA743, 0xA83E, 0xA998, 0xAB4E, 0xAD5E, 0xAFC7, 0xB286, 0xB598,
        0xB8F9, 0xBCA6, 0xC09B, 0xC4D4, 0xC94D, 0xCDFF, 0xD2E8, 0xD800, 0xDD44, 0xE2AC, 0xE834, 0xEDD5, 0xF38A, 0xF94C, 0xFF15, 0x04DF,
        0x0AA4, 0x105D, 0x1605, 0x1B96, 0x2109, 0x2659, 0x2B7F, 0x3078, 0x353C, 0x39C7, 0x3E15, 0x4220, 0x45E5, 0x495E, 0x4C8A, 0x4F63,
        0x51E7, 0x5414, 0x55E7, 0x575E, 0x5878, 0x5933, 0x598E, 0x598A, 0x5926, 0x5863, 0x5741, 0x55C2, 0x53E7, 0x51B2, 0x4F26, 0x4C45,
        0x4913, 0x4593, 0x41C8, 0x3DB7, 0x3963, 0x34D3, 0x300A, 0x2B0D, 0x25E3, 0x208F, 0x1B1A, 0x1587, 0x0FDD, 0x0A22, 0x045C, 0xFE93,
        0xF8CA, 0xF309, 0xED56, 0xE7B6, 0xE231, 0xDCCB, 0xD78C, 0xD277, 0xCD93, 0xC8E5, 0xC473, 0xC03F, 0xBC50, 0xB8AA, 0xB54F, 0xB245,
        0xAF8D, 0xAD2C, 0xAB24, 0xA976, 0xA824, 0xA731, 0xA69D, 0xA668, 0xA693, 0xA71D, 0xA807, 0xA94F, 0xAAF4, 0xACF3, 0xAF4C, 0xB1FA,
        0xB4FD, 0xB84F, 0xBBEE, 0xBFD6, 0xC402, 0xC86F, 0xCD17, 0xD1F6, 0xD706, 0xDC41, 0xE1A3, 0xE725, 0xECC2, 0xF274, 0xF834, 0xFDFC,
        0x03C6, 0x098C, 0x0F48, 0x14F4, 0x1A8A, 0x2003, 0x255A, 0x2A89, 0x2F8A, 0x3459, 0x38EF, 0x3D49, 0x4161, 0x4533, 0x48BC, 0x4BF6,
        0x4EDF, 0x5174, 0x53B2, 0x5596, 0x571E, 0x584A, 0x5917, 0x5984, 0x5992, 0x5941, 0x588F, 0x577F, 0x5612, 0x5448, 0x5224, 0x4FA8,
        0x4CD7, 0x49B4, 0x4642, 0x4285, 0x3E81, 0x3A3A, 0x35B5, 0x30F6, 0x2C03, 0x26E1, 0x2195, 0x1C25, 0x1697, 0x10F1, 0x0B39, 0x0575,
        0xFFAC, 0xF9E2, 0xF41F, 0xEE69, 0xE8C5, 0xE33B, 0xDDCF, 0xD887, 0xD36A, 0xCE7D, 0xC9C4, 0xC546, 0xC106, 0xBD0A, 0xB955, 0xB5EC,
        0xB2D2, 0xB00B, 0xAD99, 0xAB7F, 0xA9C0, 0xA85D, 0xA758, 0xA6B1, 0xA66A, 0xA683, 0xA6FC, 0xA7D4, 0xA90A, 0xAA9D, 0xAC8B, 0xAED3,
        0xB172, 0xB464, 0xB7A8, 0xBB38, 0xBF13, 0xC333, 0xC794, 0xCC31, 0xD105, 0xD60C, 0xDB40, 0xE09B, 0xE618, 0xEBB0, 0xF15E, 0xF71C,
        0xFCE3, 0x02AD, 0x0875, 0x0E33, 0x13E3, 0x197D, 0x1EFC, 0x245A, 0x2991, 0x2E9B, 0x3374, 0x3815, 0x3C7B, 0x40A0, 0x4480, 0x4816,
        0x4B5F, 0x4E58, 0x50FD, 0x534C, 0x5541, 0x56DB, 0x5818, 0x58F7, 0x5977, 0x5997, 0x5957, 0x58B8, 0x57BA, 0x565E, 0x54A6, 0x5293,
        0x5028, 0x4D67, 0x4A53, 0x46F0, 0x4340, 0x3F49, 0x3B0F, 0x3695, 0x31E1, 0x2CF7, 0x27DD, 0x2299, 0x1D2F, 0x17A7, 0x1205, 0x0C50,
        0x068D, 0x00C4, 0xFAFB, 0xF536, 0xEF7D, 0xE9D5, 0xE445, 0xDED3, 0xD984, 0xD45F, 0xCF68, 0xCAA5, 0xC61B, 0xC1CF, 0xBDC6, 0xBA03,
        0xB68C, 0xB362, 0xB08B, 0xAE09, 0xABDE, 0xAA0E, 0xA899, 0xA782, 0xA6CA, 0xA670, 0xA677, 0xA6DE, 0xA7A3, 0xA8C8, 0xAA49, 0xAC27,
        0xAE5E, 0xB0EC, 0xB3CF, 0xB703, 0xBA86, 0xBE52, 0xC265, 0xC6BA, 0xCB4C, 0xD017, 0xD515, 0xDA40, 0xDF94, 0xE50B, 0xEA9F, 0xF049,
        0xF604, 0xFBCA, 0x0194, 0x075C, 0x0D1D, 0x12D0, 0x186F, 0x1DF3, 0x2358, 0x2897, 0x2DAA, 0x328C, 0x3739, 0x3BAA, 0x3FDC, 0x43C9,
        0x476E, 0x4AC6, 0x4DCE, 0x5083, 0x52E2, 0x54E9, 0x5694, 0x57E3, 0x58D4, 0x5966, 0x5998, 0x596B, 0x58DE, 0x57F1, 0x56A7, 0x5500,
        0x52FE, 0x50A4, 0x4DF3, 0x4AEE, 0x479A, 0x43F9, 0x400F, 0x3BE1, 0x3773, 0x32C9, 0x2DE9, 0x28D8, 0x239B, 0x1E39, 0x18B6, 0x1318,
        0x0D66, 0x07A6, 0x01DD, 0xFC14, 0xF64D, 0xF092, 0xEAE6, 0xE551, 0xDFD9, 0xDA83, 0xD555, 0xD055, 0xCB88, 0xC6F3, 0xC29B, 0xBE84,
        0xBAB4, 0xB72E, 0xB3F6, 0xB10F, 0xAE7C, 0xAC41, 0xAA5F, 0xA8D9, 0xA7B0, 0xA6E5, 0xA67A, 0xA66F, 0xA6C3, 0xA777, 0xA889, 0xA9F9,
        0xABC5, 0xADEB, 0xB069, 0xB33C, 0xB662, 0xB9D5, 0xBD94, 0xC19A, 0xC5E3, 0xCA6A, 0xCF2A, 0xD41F, 0xD942, 0xDE8F, 0xE400, 0xE98E,
        0xEF35, 0xF4ED, 0xFAB2, 0x007B, 0x0644, 0x0C07, 0x11BD, 0x1760, 0x1CEA, 0x2255, 0x279B, 0x2CB7, 0x31A3, 0x365A, 0x3AD7, 0x3F15,
        0x4310, 0x46C3, 0x4A2A, 0x4D41, 0x5007, 0x5276, 0x548D, 0x564A, 0x57AB, 0x58AE, 0x5952, 0x5996, 0x597B, 0x5900, 0x5825, 0x56ED,
        0x5557, 0x5367, 0x511D, 0x4E7C, 0x4B87, 0x4842, 0x44AF, 0x40D3, 0x3CB1, 0x384E, 0x33B0, 0x2EDA, 0x29D2, 0x249D, 0x1F41, 0x19C3,
        0x142A, 0x0E7C, 0x08BE, 0x02F6, 0xFD2D, 0xF765, 0xF1A7, 0xEBF8, 0xE65E, 0xE0E0, 0xDB83, 0xD64D, 0xD144, 0xCC6D, 0xC7CD, 0xC369,
        0xBF46, 0xBB68, 0xB7D3, 0xB48C, 0xB195, 0xAEF2, 0xACA6, 0xAAB3, 0xA91C, 0xA7E1, 0xA704, 0xA687, 0xA669, 0xA6AC, 0xA74D, 0xA84E,
        0xA9AC, 0xAB67, 0xAD7C, 0xAFEA, 0xB2AD, 0xB5C3, 0xB928, 0xBCD9, 0xC0D2, 0xC50E, 0xC98A, 0xCE40, 0xD32A, 0xD845, 0xDD8B, 0xE2F5,
        0xE87E, 0xEE21, 0xF3D6, 0xF999, 0xFF62, 0x052C, 0x0AF0, 0x10A9, 0x1650, 0x1BDF, 0x2151, 0x269E, 0x2BC3, 0x30B8, 0x357A, 0x3A02,
        0x3E4C, 0x4254, 0x4615, 0x498B, 0x4CB2, 0x4F87, 0x5207, 0x542F, 0x55FD, 0x576F, 0x5884, 0x593A, 0x5991, 0x5987, 0x591E, 0x5856,
        0x572F, 0x55AB, 0x53CC, 0x5192, 0x4F02, 0x4C1D, 0x48E6, 0x4562, 0x4193, 0x3D7F, 0x3928, 0x3494, 0x2FC8, 0x2AC9, 0x259D, 0x2048,
        0x1AD0, 0x153C, 0x0F91, 0x09D5, 0x040F, 0xFE46, 0xF87D, 0xF2BD, 0xED0A, 0xE76C, 0xE1E8, 0xDC85, 0xD747, 0xD235, 0xCD54, 0xC8A9,
        0xC439, 0xC009, 0xBC1E, 0xB87B, 0xB525, 0xB21F, 0xAF6C, 0xAD0F, 0xAB0B, 0xA962, 0xA815, 0xA727, 0xA697, 0xA668, 0xA698, 0xA727,
        0xA816, 0xA963, 0xAB0C, 0xAD10, 0xAF6D, 0xB220, 0xB527, 0xB87D, 0xBC20, 0xC00C, 0xC43C, 0xC8AC, 0xCD57, 0xD238, 0xD74A, 0xDC88,
        0xE1EC, 0xE770, 0xED0E, 0xF2C0, 0xF881, 0xFE49, 0x0413, 0x09D9, 0x0F94, 0x153F, 0x1AD4, 0x204B, 0x25A0, 0x2ACD, 0x2FCC, 0x3497,
        0x392B, 0x3D81, 0x4196, 0x4564, 0x48E9, 0x4C1F, 0x4F04, 0x5194, 0x53CD, 0x55AC, 0x5730, 0x5857, 0x591F, 0x5988, 0x5990, 0x593A,
        0x5883, 0x576E, 0x55FC, 0x542E, 0x5205, 0x4F85, 0x4CB0, 0x4988, 0x4613, 0x4252, 0x3E4A, 0x39FF, 0x3577, 0x30B5, 0x2BC0, 0x269B,
        0x214D, 0x1BDC, 0x164D, 0x10A5, 0x0AED, 0x0528, 0xFF5F, 0xF995, 0xF3D3, 0xEE1D, 0xE87B, 0xE2F2, 0xDD87, 0xD842, 0xD327, 0xCE3D,
        0xC987, 0xC50C, 0xC0CF, 0xBCD7, 0xB926, 0xB5C1, 0xB2AB, 0xAFE8, 0xAD7B, 0xAB66, 0xA9AB, 0xA84D, 0xA74D, 0xA6AB, 0xA669, 0xA687,
        0xA705, 0xA7E1, 0xA91C, 0xAAB4, 0xACA8, 0xAEF4, 0xB197, 0xB48E, 0xB7D5, 0xBB6A, 0xBF48, 0xC36B, 0xC7D0, 0xCC70, 0xD147, 0xD651,
        0xDB86, 0xE0E3, 0xE662, 0xEBFB, 0xF1AA, 0xF769, 0xFD30, 0x02FA, 0x08C1, 0x0E7F, 0x142E, 0x19C7, 0x1F44, 0x24A0, 0x29D5, 0x2EDD,
        0x33B3, 0x3851, 0x3CB4, 0x40D5, 0x44B1, 0x4844, 0x4B89, 0x4E7E, 0x511E, 0x5368, 0x5558, 0x56EE, 0x5826, 0x5900, 0x597B, 0x5996,
        0x5951, 0x58AD, 0x57AA, 0x5649, 0x548C, 0x5275, 0x5005, 0x4D40, 0x4A28, 0x46C0, 0x430D, 0x3F13, 0x3AD5, 0x3658, 0x31A0, 0x2CB4,
        0x2798, 0x2252, 0x1CE6, 0x175C, 0x11B9, 0x0C03, 0x0641, 0x0077, 0xFAAE, 0xF4EA, 0xEF31, 0xE98B, 0xE3FC, 0xDE8C, 0xD93F, 0xD41C,
        0xCF27, 0xCA67, 0xC5E0, 0xC198, 0xBD92, 0xB9D3, 0xB660, 0xB33B, 0xB068, 0xADEA, 0xABC4, 0xA9F8, 0xA888, 0xA776, 0xA6C3, 0xA66E,
        0xA67A, 0xA6E6, 0xA7B0, 0xA8DA, 0xAA60, 0xAC42, 0xAE7E, 0xB110, 0xB3F8, 0xB730, 0xBAB6, 0xBE87, 0xC29D, 0xC6F6, 0xCB8B, 0xD058,
        0xD558, 0xDA86, 0xDFDC, 0xE555, 0xEAEA, 0xF095, 0xF651, 0xFC17, 0x01E1, 0x07A9, 0x0D6A, 0x131C, 0x18B9, 0x1E3C, 0x239F, 0x28DB,
        0x2DEC, 0x32CC, 0x3776, 0x3BE4, 0x4012, 0x43FB, 0x479C, 0x4AF0, 0x4DF4, 0x50A5, 0x5300, 0x5501, 0x56A8, 0x57F2, 0x58DE, 0x596B,
        0x5998, 0x5966, 0x58D4, 0x57E3, 0x5693, 0x54E8, 0x52E1, 0x5082, 0x4DCD, 0x4AC4, 0x476C, 0x43C7, 0x3FD9, 0x3BA8, 0x3736, 0x328A,
        0x2DA7, 0x2893, 0x2355, 0x1DF0, 0x186B, 0x12CD, 0x0D1A, 0x0759, 0x0190, 0xFBC7, 0xF601, 0xF046, 0xEA9B, 0xE508, 0xDF91, 0xDA3D,
        0xD512, 0xD014, 0xCB4A, 0xC6B8, 0xC263, 0xBE50, 0xBA83, 0xB701, 0xB3CD, 0xB0EA, 0xAE5C, 0xAC25, 0xAA48, 0xA8C7, 0xA7A3, 0xA6DD,
        0xA677, 0xA671, 0xA6CA, 0xA783, 0xA89A, 0xAA0F, 0xABE0, 0xAE0A, 0xB08D, 0xB364, 0xB68E, 0xBA06, 0xBDC8, 0xC1D2, 0xC61E, 0xCAA8,
        0xCF6B, 0xD462, 0xD988, 0xDED7, 0xE449, 0xE9D9, 0xEF80, 0xF53A, 0xFAFF, 0x00C8, 0x0691, 0x0C53, 0x1208, 0x17AA, 0x1D33, 0x229C,
        0x27E0, 0x2CFA, 0x31E4, 0x3698, 0x3B11, 0x3F4C, 0x4343, 0x46F2, 0x4A55, 0x4D68, 0x5029, 0x5294, 0x54A7, 0x565F, 0x57BB, 0x58B9,
        0x5958, 0x5997, 0x5977, 0x58F7, 0x5818, 0x56DA, 0x5540, 0x534A, 0x50FC, 0x4E56, 0x4B5D, 0x4814, 0x447D, 0x409D, 0x3C78, 0x3812,
        0x3371, 0x2E98, 0x298D, 0x2456, 0x1EF8, 0x1979, 0x13DF, 0x0E30, 0x0871, 0x02A9, 0xFCE0, 0xF718, 0xF15B, 0xEBAD, 0xE614, 0xE098,
        0xDB3D, 0xD609, 0xD102, 0xCC2E, 0xC791, 0xC330, 0xBF10, 0xBB36, 0xB7A6, 0xB462, 0xB170, 0xAED2, 0xAC8A, 0xAA9C, 0xA909, 0xA7D3,
        0xA6FB, 0xA683, 0xA66A, 0xA6B2, 0xA758, 0xA85E, 0xA9C1, 0xAB81, 0xAD9A, 0xB00C, 0xB2D4, 0xB5EE, 0xB957, 0xBD0C, 0xC109, 0xC548,
        0xC9C7, 0xCE80, 0xD36D, 0xD88B, 0xDDD2, 0xE33E, 0xE8C9, 0xEE6C, 0xF423, 0xF9E6, 0xFFB0, 0x0579, 0x0B3D, 0x10F5, 0x169B, 0x1C28,
        0x2198, 0x26E4, 0x2C06, 0x30F9, 0x35B8, 0x3A3D, 0x3E84, 0x4288, 0x4645, 0x49B6, 0x4CD9, 0x4FAA, 0x5225, 0x5449, 0x5613, 0x5780,
        0x5890, 0x5941, 0x5992, 0x5984, 0x5916, 0x5849, 0x571D, 0x5595, 0x53B0, 0x5172, 0x4EDD, 0x4BF4, 0x48B9, 0x4531, 0x415F, 0x3D46,
        0x38ED, 0x3456, 0x2F87, 0x2A86, 0x2557, 0x2000, 0x1A86, 0x14F1, 0x0F45, 0x0989, 0x03C2, 0xFDF9, 0xF830, 0xF270, 0xECBF, 0xE722,
        0xE1A0, 0xDC3E, 0xD702, 0xD1F3, 0xCD14, 0xC86C, 0xC400, 0xBFD3, 0xBBEC, 0xB84D, 0xB4FB, 0xB1F9, 0xAF4A, 0xACF2, 0xAAF3, 0xA94E,
        0xA807, 0xA71D, 0xA693, 0xA668, 0xA69D, 0xA731, 0xA825, 0xA977, 0xAB25, 0xAD2E, 0xAF8F, 0xB247, 0xB551, 0xB8AC, 0xBC53, 0xC042,
        0xC475, 0xC8E8, 0xCD96, 0xD27A, 0xD78F, 0xDCCF, 0xE234, 0xE7BA, 0xED59, 0xF30C, 0xF8CE, 0xFE96, 0x0460, 0x0A26, 0x0FE0, 0x158A,
        0x1B1D, 0x2093, 0x25E6, 0x2B10, 0x300D, 0x34D6, 0x3966, 0x3DB9, 0x41CA, 0x4595, 0x4915, 0x4C47, 0x4F28, 0x51B4, 0x53E8, 0x55C3,
        0x5742, 0x5863, 0x5927, 0x598A, 0x598E, 0x5933, 0x5877, 0x575D, 0x55E6, 0x5413, 0x51E6, 0x4F61, 0x4C88, 0x495C, 0x45E2, 0x421E,
        0x3E12, 0x39C5, 0x3539, 0x3075, 0x2B7C, 0x2655, 0x2106, 0x1B92, 0x1602, 0x105A, 0x0AA0, 0x04DB, 0xFF12, 0xF949, 0xF386, 0xEDD2,
        0xE831, 0xE2A9, 0xDD40, 0xD7FD, 0xD2E5, 0xCDFC, 0xC94A, 0xC4D2, 0xC099, 0xBCA4, 0xB8F7, 0xB596, 0xB284, 0xAFC6, 0xAD5D, 0xAB4D,
        0xA997, 0xA83D, 0xA742, 0xA6A5, 0xA668, 0xA68B, 0xA70E, 0xA7F0, 0xA92F, 0xAACC, 0xACC4, 0xAF15, 0xB1BC, 0xB4B7, 0xB803, 0xBB9C,
        0xBF7E, 0xC3A4, 0xC80C, 0xCCAF, 0xD189, 0xD695, 0xDBCD, 0xE12C, 0xE6AC, 0xEC46, 0xF1F6, 0xF7B5, 0xFD7D, 0x0347, 0x090E, 0x0ECB,
        0x1479, 0x1A11, 0x1F8C, 0x24E6, 0x2A19, 0x2F1E, 0x33F2, 0x388D, 0x3CEC, 0x410A, 0x44E3, 0x4871, 0x4BB2, 0x4EA3, 0x513F, 0x5384,
        0x5570, 0x5700, 0x5834, 0x5909, 0x597F, 0x5995, 0x594B, 0x58A2, 0x579A, 0x5634, 0x5473, 0x5256, 0x4FE2, 0x4D18, 0x49FC, 0x4691,
        0x42DA, 0x3EDC, 0x3A9A, 0x361A, 0x3160, 0x2C71, 0x2753, 0x220A, 0x1C9D, 0x1712, 0x116E, 0x0BB7, 0x05F4, 0x002A, 0xFA61, 0xF49D,
        0xEEE5, 0xE940, 0xE3B3, 0xDE44, 0xD8F9, 0xD3D8, 0xCEE7, 0xCA29, 0xC5A6, 0xC161, 0xBD5E, 0xB9A3, 0xB634, 0xB313, 0xB044, 0xADCB,
        0xABAA, 0xA9E3, 0xA878, 0xA76A, 0xA6BC, 0xA66D, 0xA67D, 0xA6EE, 0xA7BD, 0xA8EC, 0xAA77, 0xAC5E, 0xAE9E, 0xB135, 0xB420, 0xB75D,
        0xBAE7, 0xBEBC, 0xC2D6, 0xC731, 0xCBC9, 0xD09A, 0xD59C, 0xDACC, 0xE024, 0xE59E, 0xEB35, 0xF0E1, 0xF69E, 0xFC64, 0x022E, 0x07F6,
        0x0DB6, 0x1367, 0x1903, 0x1E85, 0x23E5, 0x2920, 0x2E2E, 0x330C, 0x37B2, 0x3C1D, 0x4048, 0x442D, 0x47CA, 0x4B1B, 0x4E1A, 0x50C7,
        0x531D, 0x551A, 0x56BB, 0x5801, 0x58E8, 0x5970, 0x5998, 0x5961, 0x58C9, 0x57D3, 0x567F, 0x54CF, 0x52C4, 0x5060, 0x4DA6, 0x4A99,
        0x473D, 0x4394, 0x3FA3, 0x3B6E, 0x36F9, 0x324A, 0x2D64, 0x284F, 0x230E, 0x1DA7, 0x1821, 0x1281, 0x0CCD, 0x070C, 0x0143, 0xFB7A,
        0xF5B4, 0xEFFA, 0xEA50, 0xE4BE, 0xDF49, 0xD9F7, 0xD4CE, 0xCFD3, 0xCB0B, 0xC67C, 0xC22B, 0xBE1C, 0xBA53, 0xB6D5, 0xB3A4, 0xB0C6,
        0xAE3D, 0xAC0A, 0xAA32, 0xA8B5, 0xA796, 0xA6D6, 0xA674, 0xA673, 0xA6D1, 0xA78F, 0xA8AB, 0xAA25, 0xABFA, 0xAE2A, 0xB0B1, 0xB38C,
        0xB6BA, 0xBA36, 0xBDFC, 0xC209, 0xC659, 0xCAE6, 0xCFAC, 0xD4A5, 0xD9CD, 0xDF1E, 0xE492, 0xEA24, 0xEFCC, 0xF586, 0xFB4C, 0x0115,
        0x06DE, 0x0CA0, 0x1254, 0x17F5, 0x1D7C, 0x22E3, 0x2825, 0x2D3D, 0x3223, 0x36D5, 0x3B4B, 0x3F82, 0x4376, 0x4721, 0x4A80, 0x4D8F,
        0x504B, 0x52B2, 0x54C0, 0x5673, 0x57CA, 0x58C3, 0x595D, 0x5998, 0x5972, 0x58ED, 0x5809, 0x56C7, 0x5528, 0x532E, 0x50DB, 0x4E31,
        0x4B34, 0x47E6, 0x444B, 0x4068, 0x3C3F, 0x37D6, 0x3331, 0x2E56, 0x2949, 0x2410, 0x1EB0, 0x192F, 0x1394, 0x0DE3, 0x0824, 0x025C,
        0xFC93, 0xF6CC, 0xF10F, 0xEB62, 0xE5CB, 0xE050, 0xDAF7, 0xD5C5, 0xD0C1, 0xCBEF, 0xC755, 0xC2F8, 0xBEDB, 0xBB05, 0xB778, 0xB439,
        0xB14B, 0xAEB1, 0xAC6E, 0xAA85, 0xA8F6, 0xA7C5, 0xA6F3, 0xA67F, 0xA66C, 0xA6B8, 0xA764, 0xA86E, 0xA9D6, 0xAB9A, 0xADB9, 0xB02F,
        0xB2FB, 0xB619, 0xB987, 0xBD3F, 0xC140, 0xC583, 0xCA05, 0xCEC0, 0xD3B0, 0xD8D0, 0xDE19, 0xE387, 0xE913, 0xEEB8, 0xF46F, 0xFA33,
        0xFFFD, 0x05C5, 0x0B89, 0x1140, 0x16E5, 0x1C72, 0x21E0, 0x2729, 0x2C49, 0x313A, 0x35F5, 0x3A77, 0x3EBB, 0x42BB, 0x4674, 0x49E2,
        0x4D01, 0x4FCD, 0x5244, 0x5463, 0x5628, 0x5790, 0x589B, 0x5947, 0x5994, 0x5981, 0x590E, 0x583C, 0x570B, 0x557E, 0x5395, 0x5152,
        0x4EB9, 0x4BCB, 0x488C, 0x4500, 0x412A, 0x3D0E, 0x38B1, 0x3417, 0x2F46, 0x2A42, 0x2510, 0x1FB8, 0x1A3D, 0x14A6, 0x0EF9, 0x093C,
        0x0375, 0xFDAC, 0xF7E4, 0xF224, 0xEC74, 0xE6D8, 0xE157, 0xDBF7, 0xD6BE, 0xD1B1, 0xCCD5, 0xC830, 0xC3C7, 0xBF9E, 0xBBBA, 0xB81F,
        0xB4D0, 0xB1D3, 0xAF29, 0xACD5, 0xAADA, 0xA93B, 0xA7F8, 0xA713, 0xA68E, 0xA668, 0xA6A2, 0xA73C, 0xA834, 0xA98B, 0xAB3E, 0xAD4B,
        0xAFB1, 0xB26D, 0xB57C, 0xB8DB, 0xBC85, 0xC078, 0xC4AF, 0xC925, 0xCDD6, 0xD2BD, 0xD7D4, 0xDD16, 0xE27D, 0xE804, 0xEDA5, 0xF359,
        0xF91A, 0xFEE4, 0x04AD, 0x0A72, 0x102C, 0x15D5, 0x1B66, 0x20DB, 0x262C, 0x2B54, 0x304E, 0x3514, 0x39A1, 0x3DF1, 0x41FE, 0x45C5,
        0x4942, 0x4C70, 0x4F4C, 0x51D3, 0x5403, 0x55D9, 0x5753, 0x5870, 0x592E, 0x598D, 0x598C, 0x592B, 0x586B, 0x574C, 0x55D0, 0x53F8,
        0x51C7, 0x4F3D, 0x4C60, 0x4930, 0x45B2, 0x41EA, 0x3DDB, 0x398A, 0x34FB, 0x3034, 0x2B39, 0x2610, 0x20BE, 0x1B49, 0x15B7, 0x100E,
        0x0A53, 0x048E, 0xFEC5, 0xF8FC, 0xF33A, 0xED86, 0xE7E6, 0xE260, 0xDCF9, 0xD7B8, 0xD2A2, 0xCDBD, 0xC90D, 0xC498, 0xC062, 0xBC71,
        0xB8C8, 0xB56B, 0xB25E, 0xAFA3, 0xAD3F, 0xAB34, 0xA983, 0xA82E, 0xA738, 0xA6A0, 0xA668, 0xA690, 0xA717, 0xA7FE, 0xA943, 0xAAE4,
        0xACE1, 0xAF36, 0xB1E2, 0xB4E1, 0xB831, 0xBBCE, 0xBFB3, 0xC3DD, 0xC848, 0xCCEE, 0xD1CB, 0xD6D9, 0xDC14, 0xE174, 0xE6F6, 0xEC92,
        0xF243, 0xF802, 0xFDCA, 0x0394, 0x095B, 0x0F17, 0x14C4, 0x1A5A, 0x1FD4, 0x252D, 0x2A5D, 0x2F60, 0x3430, 0x38C9, 0x3D25, 0x413F,
        0x4514, 0x489E, 0x4BDC, 0x4EC7, 0x515F, 0x53A0, 0x5587, 0x5713, 0x5841, 0x5911, 0x5982, 0x5993, 0x5945, 0x5897, 0x578A, 0x561F,
        0x5459, 0x5238, 0x4FBF, 0x4CF1, 0x49D1, 0x4661, 0x42A7, 0x3EA5, 0x3A60, 0x35DD, 0x3120, 0x2C2E, 0x270D, 0x21C3, 0x1C54, 0x16C7,
        0x1122, 0x0B6B, 0x05A7, 0xFFDE, 0xFA14, 0xF451, 0xEE9A, 0xE8F5, 0xE36A, 0xDDFD, 0xD8B4, 0xD395, 0xCEA6, 0xC9EC, 0xC56B, 0xC12A,
        0xBD2B, 0xB974, 0xB608, 0xB2EB, 0xB021, 0xADAD, 0xAB90, 0xA9CE, 0xA867, 0xA75F, 0xA6B5, 0xA66B, 0xA681, 0xA6F6, 0xA7CB, 0xA8FE,
        0xAA8E, 0xAC79, 0xAEBE, 0xB15A, 0xB44A, 0xB78A, 0xBB19, 0xBEF1, 0xC30E, 0xC76D, 0xCC08, 0xD0DB, 0xD5E0, 0xDB13, 0xE06C, 0xE5E8,
        0xEB80, 0xF12D, 0xF6EA, 0xFCB1, 0x027B, 0x0843, 0x0E02, 0x13B2, 0x194D, 0x1ECD, 0x242C, 0x2964, 0x2E70, 0x334B, 0x37EE, 0x3C56,
        0x407D, 0x445F, 0x47F8, 0x4B44, 0x4E40, 0x50E8, 0x5339, 0x5532, 0x56CF, 0x580F, 0x58F1, 0x5974, 0x5998, 0x595B, 0x58BF, 0x57C4,
        0x566B, 0x54B6, 0x52A6, 0x503E, 0x4D80, 0x4A6F, 0x470E, 0x4361, 0x3F6D, 0x3B34, 0x36BC, 0x320A, 0x2D22, 0x280A, 0x22C7, 0x1D5F,
        0x17D7, 0x1236, 0x0C81, 0x06BF, 0x00F6, 0xFB2D, 0xF568, 0xEFAE, 0xEA06, 0xE475, 0xDF02, 0xD9B1, 0xD48A, 0xCF92, 0xCACD, 0xC641,
        0xC1F3, 0xBDE7, 0xBA22, 0xB6A8, 0xB37C, 0xB0A2, 0xAE1D, 0xABF0, 0xAA1C, 0xA8A4, 0xA78A, 0xA6CE, 0xA672, 0xA675, 0xA6D9, 0xA79B,
        0xA8BC, 0xAA3B, 0xAC15, 0xAE49, 0xB0D5, 0xB3B5, 0xB6E6, 0xBA66, 0xBE31, 0xC241, 0xC694, 0xCB24, 0xCFED, 0xD4E9, 0xDA13, 0xDF66,
        0xE4DC, 0xEA6E, 0xF018, 0xF5D3, 0xFB99, 0x0162, 0x072B, 0x0CEC, 0x129F, 0x183F, 0x1DC4, 0x232A, 0x286A, 0x2D7F, 0x3263, 0x3712,
        0x3B85, 0x3FB9, 0x43A8, 0x4750, 0x4AAA, 0x4DB6, 0x506E, 0x52CF, 0x54D9, 0x5687, 0x57DA, 0x58CE, 0x5963, 0x5998, 0x596E, 0x58E4,
        0x57FB, 0x56B4, 0x5510, 0x5311, 0x50B9, 0x4E0B, 0x4B0A, 0x47B8, 0x4419, 0x4032, 0x3C06, 0x379A, 0x32F2, 0x2E14, 0x2904, 0x23C9,
        0x1E68, 0x18E5, 0x1349, 0x0D97, 0x07D7, 0x020F, 0xFC46, 0xF67F, 0xF0C3, 0xEB17, 0xE581, 0xE008, 0xDAB0, 0xD581, 0xD07F, 0xCBB0,
        0xC719, 0xC2BF, 0xBEA7, 0xBAD4, 0xB74B, 0xB410, 0xB126, 0xAE91, 0xAC52, 0xAA6E, 0xA8E4, 0xA7B8, 0xA6EA, 0xA67C, 0xA66D, 0xA6BE,
        0xA76F, 0xA87E, 0xA9EB, 0xABB4, 0xADD7, 0xB052, 0xB323, 0xB645, 0xB9B7, 0xBD73, 0xC177, 0xC5BD, 0xCA42, 0xCF01, 0xD3F3, 0xD915,
        0xDE61, 0xE3D0, 0xE95E, 0xEF04, 0xF4BC, 0xFA80, 0x0049, 0x0612, 0x0BD6, 0x118C, 0x1730, 0x1CBB, 0x2227, 0x276F, 0x2C8C, 0x317A,
        0x3633, 0x3AB2, 0x3EF2, 0x42EF, 0x46A4, 0x4A0E, 0x4D28, 0x4FF0, 0x5263, 0x547D, 0x563D, 0x57A1, 0x58A7, 0x594E, 0x5995, 0x597D,
        0x5905, 0x582E, 0x56F9, 0x5567, 0x5379, 0x5132, 0x4E94, 0x4BA2, 0x485F, 0x44CF, 0x40F5, 0x3CD6, 0x3875, 0x33D8, 0x2F04, 0x29FE,
        0x24CA, 0x1F6F, 0x19F3, 0x145B, 0x0EAD, 0x08EF, 0x0328, 0xFD5E, 0xF797, 0xF1D8, 0xEC28, 0xE68E, 0xE10F, 0xDBB1, 0xD679, 0xD16F,
        0xCC96, 0xC7F4, 0xC38E, 0xBF68, 0xBB88, 0xB7F1, 0xB4A7, 0xB1AD, 0xAF08, 0xACB9, 0xAAC3, 0xA928, 0xA7EA, 0xA70A, 0xA68A, 0xA669,
        0xA6A8, 0xA746, 0xA844, 0xA99F, 0xAB57, 0xAD69, 0xAFD3, 0xB294, 0xB5A7, 0xB90A, 0xBCB8, 0xC0AF, 0xC4E9, 0xC962, 0xCE16, 0xD2FF,
        0xD819, 0xDD5D, 0xE2C6, 0xE84E, 0xEDF0, 0xF3A5, 0xF967, 0xFF31, 0x04FA, 0x0ABF, 0x1078, 0x1620, 0x1BB0, 0x2122, 0x2671, 0x2B97,
        0x308F, 0x3552, 0x39DC, 0x3E29, 0x4233, 0x45F6, 0x496E, 0x4C98, 0x4F70, 0x51F2, 0x541E, 0x55EF, 0x5764, 0x587C, 0x5935, 0x598F,
        0x5989, 0x5923, 0x585E, 0x573B, 0x55BA, 0x53DD, 0x51A7, 0x4F19, 0x4C37, 0x4903, 0x4581, 0x41B5, 0x3DA3, 0x394E, 0x34BD, 0x2FF3,
        0x2AF5, 0x25CA, 0x2076, 0x1B00, 0x156C, 0x0FC2, 0x0A07, 0x0441, 0xFE78, 0xF8AF, 0xF2EE, 0xED3B, 0xE79C, 0xE217, 0xDCB2, 0xD773,
        0xD260, 0xCD7D, 0xC8D0, 0xC45E, 0xC02C, 0xBC3E, 0xB899, 0xB540, 0xB237, 0xAF82, 0xAD22, 0xAB1B, 0xA96F, 0xA81F, 0xA72D, 0xA69B,
        0xA668, 0xA694, 0xA721, 0xA80C, 0xA956, 0xAAFC, 0xACFD, 0xAF57, 0xB208, 0xB50B, 0xB85F, 0xBC00, 0xBFE9, 0xC417, 0xC884, 0xCD2E,
        0xD20D, 0xD71E, 0xDC5A, 0xE1BD, 0xE740, 0xECDD, 0xF28F, 0xF84F, 0xFE18, 0x03E1, 0x09A7, 0x0F63, 0x150F, 0x1AA4, 0x201C, 0x2573,
        0x2AA1, 0x2FA1, 0x346F, 0x3904, 0x3D5D, 0x4174, 0x4545, 0x48CB, 0x4C04, 0x4EEC, 0x517F, 0x53BB, 0x559E, 0x5725, 0x584E, 0x591A,
        0x5986, 0x5992, 0x593E, 0x588B, 0x5779, 0x560A, 0x543F, 0x5219, 0x4F9C, 0x4CC9, 0x49A5, 0x4632, 0x4273, 0x3E6E, 0x3A25, 0x359F,
        0x30DF, 0x2BEB, 0x26C8, 0x217C, 0x1C0B, 0x167D, 0x10D6, 0x0B1E, 0x055A, 0xFF91, 0xF9C7, 0xF404, 0xEE4E, 0xE8AB, 0xE321, 0xDDB5,
        0xD86F, 0xD353, 0xCE66, 0xC9AF, 0xC531, 0xC0F3, 0xBCF8, 0xB944, 0xB5DD, 0xB2C4, 0xAFFF, 0xAD8E, 0xAB76, 0xA9B9, 0xA857, 0xA754,
        0xA6AF, 0xA66A, 0xA685, 0xA6FF, 0xA7D9, 0xA910, 0xAAA5, 0xAC95, 0xAEDF, 0xB17F, 0xB473, 0xB7B8, 0xBB4A, 0xBF26, 0xC347, 0xC7A9,
        0xCC47, 0xD11D, 0xD624, 0xDB59, 0xE0B5, 0xE632, 0xEBCB, 0xF179, 0xF737, 0xFCFE, 0x02C8, 0x0890, 0x0E4E, 0x13FD, 0x1997, 0x1F15,
        0x2473, 0x29A9, 0x2EB2, 0x338A, 0x382A, 0x3C8F, 0x40B3, 0x4491, 0x4826, 0x4B6E, 0x4E65, 0x5109, 0x5356, 0x5549, 0x56E2, 0x581D,
        0x58FA, 0x5978, 0x5997, 0x5955, 0x58B4, 0x57B4, 0x5657, 0x549D, 0x5288, 0x501B, 0x4D59, 0x4A44, 0x46DF, 0x432E, 0x3F36, 0x3AFA,
        0x367F, 0x31CA, 0x2CDF, 0x27C5, 0x2280, 0x1D16, 0x178D, 0x11EA, 0x0C35, 0x0672, 0x00A9, 0xFAE0, 0xF51B, 0xEF62, 0xE9BB, 0xE42B,
        0xDEBA, 0xD96C, 0xD447, 0xCF51, 0xCA8F, 0xC606, 0xC1BC, 0xBDB3, 0xB9F2, 0xB67C, 0xB354, 0xB07F, 0xADFE, 0xABD5, 0xAA06, 0xA893,
        0xA77E, 0xA6C7, 0xA670, 0xA678, 0xA6E0, 0xA7A8, 0xA8CE, 0xAA51, 0xAC30, 0xAE69, 0xB0F9, 0xB3DD, 0xB713, 0xBA97, 0xBE65, 0xC279,
        0xC6CF, 0xCB62, 0xD02E, 0xD52D, 0xDA59, 0xDFAE, 0xE525, 0xEAB9, 0xF064, 0xF61F, 0xFBE6, 0x01AF, 0x0778, 0x0D38, 0x12EB, 0x1889,
        0x1E0D, 0x2371, 0x28AF, 0x2DC1, 0x32A3, 0x374E, 0x3BBF, 0x3FEF, 0x43DB, 0x477E, 0x4AD5, 0x4DDC, 0x508F, 0x52ED, 0x54F1, 0x569B,
        0x57E9, 0x58D8, 0x5968, 0x5998, 0x5969, 0x58DA, 0x57EC, 0x56A0, 0x54F8, 0x52F4, 0x5098, 0x4DE5, 0x4ADF, 0x478A, 0x43E7, 0x3FFC,
        0x3BCD, 0x375D, 0x32B3, 0x2DD2, 0x28C0, 0x2382, 0x1E1F, 0x189B, 0x12FD, 0x0D4B, 0x078B, 0x01C2, 0xFBF8, 0xF632, 0xF077, 0xEACC,
        0xE537, 0xDFC0, 0xDA6A, 0xD53D, 0xD03E, 0xCB72, 0xC6DE, 0xC287, 0xBE72, 0xBAA3, 0xB71E, 0xB3E7, 0xB102, 0xAE71, 0xAC37, 0xAA57,
        0xA8D2, 0xA7AB, 0xA6E2, 0xA679, 0xA66F, 0xA6C5, 0xA77B, 0xA88F, 0xAA01, 0xABCF, 0xADF6, 0xB076, 0xB34A, 0xB671, 0xB9E6, 0xBDA7,
        0xC1AE, 0xC5F8, 0xCA80, 0xCF41, 0xD437, 0xD95B, 0xDEA8, 0xE419, 0xE9A9, 0xEF4F, 0xF508, 0xFACD, 0x0096, 0x065F, 0x0C22, 0x11D8,
        0x177A, 0x1D04, 0x226E, 0x27B4, 0x2CCF, 0x31BA, 0x3670, 0x3AEC, 0x3F29, 0x4322, 0x46D3, 0x4A39, 0x4D4F, 0x5013, 0x5281, 0x5496,
        0x5652, 0x57B1, 0x58B2, 0x5954, 0x5997, 0x5979, 0x58FD, 0x5821, 0x56E6, 0x554F, 0x535D, 0x5111, 0x4E6F, 0x4B78, 0x4831, 0x449D,
        0x40C0, 0x3C9D, 0x3839, 0x3399, 0x2EC2, 0x29B9, 0x2484, 0x1F27, 0x19A9, 0x1410, 0x0E61, 0x08A3, 0x02DB, 0xFD11, 0xF74A, 0xF18C,
        0xEBDD, 0xE644, 0xE0C6, 0xDB6A, 0xD635, 0xD12D, 0xCC57, 0xC7B8, 0xC355, 0xBF33, 0xBB56, 0xB7C3, 0xB47D, 0xB188, 0xAEE7, 0xAC9C,
        0xAAAB, 0xA915, 0xA7DC, 0xA701, 0xA686, 0xA66A, 0xA6AE, 0xA751, 0xA853, 0xA9B4, 0xAB70, 0xAD87, 0xAFF6, 0xB2BB, 0xB5D2, 0xB939,
        0xBCEB, 0xC0E5, 0xC523, 0xC99F, 0xCE56, 0xD342, 0xD85E, 0xDDA4, 0xE30F, 0xE899, 0xEE3C, 0xF3F1, 0xF9B4, 0xFF7E, 0x0547, 0x0B0B,
        0x10C4, 0x166A, 0x1BF9, 0x216A, 0x26B7, 0x2BDB, 0x30CF, 0x3590, 0x3A17, 0x3E60, 0x4266, 0x4626, 0x499A, 0x4CC0, 0x4F93, 0x5212,
        0x5438, 0x5605, 0x5775, 0x5888, 0x593C, 0x5991, 0x5986, 0x591C, 0x5852, 0x5729, 0x55A3, 0x53C2, 0x5187, 0x4EF5, 0x4C0E, 0x48D7,
        0x4551, 0x4181, 0x3D6B, 0x3913, 0x347E, 0x2FB1, 0x2AB1, 0x2584, 0x202E, 0x1AB6, 0x1521, 0x0F76, 0x09BA, 0x03F4, 0xFE2A, 0xF862,
        0xF2A2, 0xECF0, 0xE752, 0xE1CF, 0xDC6C, 0xD72F, 0xD21D, 0xCD3D, 0xC893, 0xC425, 0xBFF6, 0xBC0C, 0xB86B, 0xB516, 0xB211, 0xAF60,
        0xAD05, 0xAB02, 0xA95B, 0xA810, 0xA723, 0xA696, 0xA668, 0xA699, 0xA72B, 0xA81B, 0xA96A, 0xAB15, 0xAD1B, 0xAF79, 0xB22E, 0xB536,
        0xB88E, 0xBC32, 0xC01F, 0xC450, 0xC8C1, 0xCD6D, 0xD24F, 0xD762, 0xDCA1, 0xE205, 0xE78A, 0xED28, 0xF2DB, 0xF89C, 0xFE65, 0x042E,
        0x09F4, 0x0FAF, 0x155A, 0x1AEE, 0x2064, 0x25B9, 0x2AE5, 0x2FE3, 0x34AD, 0x3940, 0x3D95, 0x41A8, 0x4576, 0x48F8, 0x4C2D, 0x4F10,
        0x519F, 0x53D7, 0x55B4, 0x5736, 0x585B, 0x5922, 0x5989, 0x5990, 0x5937, 0x587F, 0x5768, 0x55F4, 0x5424, 0x51FA, 0x4F78, 0x4CA2,
        0x4979, 0x4602, 0x423F, 0x3E36, 0x39EB, 0x3561, 0x309E, 0x2BA8, 0x2682, 0x2134, 0x1BC2, 0x1632, 0x108B, 0x0AD1, 0x050D, 0xFF44,
        0xF97A, 0xF3B8, 0xEE03, 0xE861, 0xE2D8, 0xDD6E, 0xD82A, 0xD310, 0xCE26, 0xC971, 0xC4F7, 0xC0BC, 0xBCC5, 0xB915, 0xB5B1, 0xB29D,
        0xAFDC, 0xAD70, 0xAB5D, 0xA9A4, 0xA848, 0xA749, 0xA6A9, 0xA669, 0xA689, 0xA708, 0xA7E6, 0xA923, 0xAABD, 0xACB2, 0xAEFF, 0xB1A4,
        0xB49C, 0xB7E5, 0xBB7C, 0xBF5B, 0xC380, 0xC7E5, 0xCC86, 0xD15E, 0xD669, 0xDB9F, 0xE0FD, 0xE67C, 0xEC16, 0xF1C5, 0xF784, 0xFD4C,
        0x0315, 0x08DC, 0x0E9A, 0x1448, 0x19E1, 0x1F5E, 0x24B9, 0x29ED, 0x2EF4, 0x33C9, 0x3866, 0x3CC8, 0x40E8, 0x44C3, 0x4854, 0x4B98,
        0x4E8B, 0x512A, 0x5372, 0x5561, 0x56F4, 0x582B, 0x5903, 0x597C, 0x5996, 0x594F, 0x58A9, 0x57A5, 0x5642, 0x5483, 0x526A, 0x4FF9,
        0x4D32, 0x4A18, 0x46B0, 0x42FB, 0x3EFF, 0x3AC0, 0x3642, 0x318A, 0x2C9C, 0x2780, 0x2238, 0x1CCD, 0x1742, 0x119F, 0x0BE8, 0x0625,
        0x005C, 0xFA93, 0xF4CF, 0xEF16, 0xE970, 0xE3E2, 0xDE72, 0xD926, 0xD404, 0xCF10, 0xCA51, 0xC5CC, 0xC184, 0xBD80, 0xB9C2, 0xB650,
        0xB32C, 0xB05B, 0xADDF, 0xABBB, 0xA9F1, 0xA882, 0xA772, 0xA6C0, 0xA66E, 0xA67B, 0xA6E8, 0xA7B5, 0xA8E0, 0xAA68, 0xAC4C, 0xAE89,
        0xB11D, 0xB406, 0xB740, 0xBAC8, 0xBE9A, 0xC2B1, 0xC70B, 0xCBA1, 0xD06F, 0xD570, 0xDA9F, 0xDFF6, 0xE56F, 0xEB04, 0xF0B0, 0xF66C,
        0xFC33, 0x01FC, 0x07C4, 0x0D85, 0x1336, 0x18D3, 0x1E56, 0x23B8, 0x28F4, 0x2E04, 0x32E3, 0x378B, 0x3BF8, 0x4025, 0x440D, 0x47AC,
        0x4AFF, 0x4E02, 0x50B1, 0x530A, 0x550A, 0x56AF, 0x57F7, 0x58E2, 0x596D, 0x5998, 0x5964, 0x58D0, 0x57DD, 0x568C, 0x54DF, 0x52D7,
        0x5076, 0x4DBF, 0x4AB5, 0x475B, 0x43B5, 0x3FC6, 0x3B93, 0x3721, 0x3273, 0x2D8F, 0x287B, 0x233C, 0x1DD6, 0x1851, 0x12B2, 0x0CFF,
        0x073E, 0x0175, 0xFBAB, 0xF5E6, 0xF02B, 0xEA81, 0xE4EE, 0xDF78, 0xDA24, 0xD4FA, 0xCFFD, 0xCB33, 0xC6A3, 0xC24F, 0xBE3D, 0xBA72,
        0xB6F1, 0xB3BF, 0xB0DD, 0xAE51, 0xAC1C, 0xAA40, 0xA8C1, 0xA79E, 0xA6DB, 0xA676, 0xA671, 0xA6CC, 0xA787, 0xA8A0, 0xAA17, 0xABE9,
        0xAE15, 0xB099, 0xB372, 0xB69D, 0xBA17, 0xBDDB, 0xC1E5, 0xC633, 0xCABE, 0xCF82, 0xD47A, 0xD9A0, 0xDEF0, 0xE463, 0xE9F3, 0xEF9B,
        0xF555, 0xFB1A, 0x00E3, 0x06AC, 0x0C6E, 0x1223, 0x17C5, 0x1D4D, 0x22B5, 0x27F9, 0x2D12, 0x31FA, 0x36AD, 0x3B26, 0x3F5F, 0x4355,
        0x4702, 0x4A64, 0x4D76, 0x5035, 0x529F, 0x54B0, 0x5666, 0x57C0, 0x58BC, 0x595A, 0x5997, 0x5975, 0x58F3, 0x5813, 0x56D3, 0x5537,
        0x5340, 0x50F0, 0x4E49, 0x4B4F, 0x4804, 0x446C, 0x408A, 0x3C64, 0x37FD, 0x335A, 0x2E81, 0x2975, 0x243D, 0x1EDF, 0x195F, 0x13C5,
        0x0E15, 0x0856, 0x028E, 0xFCC4, 0xF6FD, 0xF140, 0xEB92, 0xE5FA, 0xE07E, 0xDB24, 0xD5F1, 0xD0EB, 0xCC18, 0xC77C, 0xC31C, 0xBEFE,
        0xBB25, 0xB795, 0xB454, 0xB163, 0xAEC6, 0xAC80, 0xAA94, 0xA902, 0xA7CE, 0xA6F8, 0xA682, 0xA66B, 0xA6B4, 0xA75C, 0xA863, 0xA9C8,
        0xAB8A, 0xADA5, 0xB019, 0xB2E2, 0xB5FD, 0xB968, 0xBD1E, 0xC11C, 0xC55D, 0xC9DD, 0xCE96, 0xD385, 0xD8A3, 0xDDEB, 0xE358, 0xE8E3,
        0xEE87, 0xF43E, 0xFA01, 0xFFCB, 0x0594, 0x0B58, 0x110F, 0x16B5, 0x1C42, 0x21B1, 0x26FC, 0x2C1E, 0x3110, 0x35CD, 0x3A52, 0x3E97,
        0x429A, 0x4656, 0x49C6, 0x4CE7, 0x4FB6, 0x5230, 0x5452, 0x561A, 0x5786, 0x5894, 0x5943, 0x5993, 0x5983, 0x5913, 0x5844, 0x5717,
        0x558D, 0x53A7, 0x5167, 0x4ED0, 0x4BE6, 0x48AA, 0x4520, 0x414C, 0x3D33, 0x38D8, 0x3440, 0x2F70, 0x2A6E, 0x253E, 0x1FE6, 0x1A6C,
        0x14D6, 0x0F2A, 0x096E, 0x03A7, 0xFDDD, 0xF815, 0xF255, 0xECA4, 0xE708, 0xE186, 0xDC25, 0xD6EA, 0xD1DB, 0xCCFE, 0xC857, 0xC3EB,
        0xBFC0, 0xBBDA, 0xB83C, 0xB4EC, 0xB1EB, 0xAF3E, 0xACE8, 0xAAEA, 0xA947, 0xA801, 0xA71A, 0xA691, 0xA668, 0xA69F, 0xA735, 0xA82A,
        0xA97E, 0xAB2D, 0xAD38, 0xAF9B, 0xB254, 0xB560, 0xB8BC, 0xBC65, 0xC055, 0xC48A, 0xC8FE, 0xCDAD, 0xD292, 0xD7A7, 0xDCE8, 0xE24E,
        0xE7D4, 0xED74, 0xF327, 0xF8E9, 0xFEB2, 0x047B, 0x0A41, 0x0FFB, 0x15A5, 0x1B37, 0x20AC, 0x25FF, 0x2B28, 0x3024, 0x34EC, 0x397B,
        0x3DCD, 0x41DD, 0x45A6, 0x4925, 0x4C56, 0x4F35, 0x51BF, 0x53F2, 0x55CB, 0x5748, 0x5868, 0x5929, 0x598B, 0x598E, 0x5930, 0x5873,
        0x5757, 0x55DE, 0x540A, 0x51DB, 0x4F55, 0x4C7A, 0x494D, 0x45D1, 0x420B, 0x3DFF, 0x39B0, 0x3523, 0x305E, 0x2B64, 0x263D, 0x20EC,
        0x1B79, 0x15E7, 0x103F, 0x0A85, 0x04C0, 0xFEF6, 0xF92D, 0xF36B, 0xEDB7, 0xE816, 0xE28F, 0xDD27, 0xD7E5, 0xD2CD, 0xCDE6, 0xC934,
        0xC4BD, 0xC086, 0xBC92, 0xB8E6, 0xB587, 0xB277, 0xAFBA, 0xAD52, 0xAB44, 0xA990, 0xA838, 0xA73E, 0xA6A3, 0xA668, 0xA68D, 0xA711,
        0xA7F5, 0xA936, 0xAAD5, 0xACCE, 0xAF21, 0xB1CA, 0xB4C6, 0xB813, 0xBBAD, 0xBF90, 0xC3B8, 0xC821, 0xCCC5, 0xD1A0, 0xD6AD, 0xDBE6,
        0xE145, 0xE6C6, 0xEC61, 0xF211, 0xF7D1, 0xFD99, 0x0362, 0x0929, 0x0EE6, 0x1493, 0x1A2B, 0x1FA6, 0x24FF, 0x2A31, 0x2F36, 0x3408,
        0x38A2, 0x3D00, 0x411D, 0x44F4, 0x4881, 0x4BC1, 0x4EB0, 0x514A, 0x538E, 0x5578, 0x5707, 0x5839, 0x590C, 0x5980, 0x5994, 0x5949,
        0x589E, 0x5794, 0x562D, 0x5469, 0x524C, 0x4FD6, 0x4D0B, 0x49ED, 0x4680, 0x42C8, 0x3EC8, 0x3A86, 0x3604, 0x3149, 0x2C5A, 0x273A,
        0x21F1, 0x1C84, 0x16F8, 0x1153, 0x0B9C, 0x05D8, 0x000F, 0xFA46, 0xF482, 0xEECB, 0xE926, 0xE399, 0xDE2B, 0xD8E1, 0xD3C1, 0xCED0,
        0xCA14, 0xC591, 0xC14D, 0xBD4C, 0xB993, 0xB624, 0xB305, 0xB038, 0xADC0, 0xABA1, 0xA9DB, 0xA872, 0xA766, 0xA6BA, 0xA66C, 0xA67F,
        0xA6F1, 0xA7C2, 0xA8F2, 0xAA7F, 0xAC67, 0xAEA9, 0xB142, 0xB42F, 0xB76D, 0xBAF9, 0xBECE, 0xC2EA, 0xC746, 0xCBE0, 0xD0B1, 0xD5B4,
        0xDAE5, 0xE03E, 0xE5B8, 0xEB4F, 0xF0FC, 0xF6B9, 0xFC80, 0x0249, 0x0811, 0x0DD1, 0x1381, 0x191D, 0x1E9E, 0x23FE, 0x2938, 0x2E46,
        0x3322, 0x37C7, 0x3C31, 0x405B, 0x443F, 0x47DB, 0x4B29, 0x4E28, 0x50D2, 0x5327, 0x5522, 0x56C2, 0x5806, 0x58EB, 0x5971, 0x5998,
        0x595F, 0x58C6, 0x57CE, 0x5678, 0x54C6, 0x52B9, 0x5054, 0x4D99, 0x4A8A, 0x472C, 0x4382, 0x3F90, 0x3B5A, 0x36E4, 0x3233, 0x2D4D,
        0x2836, 0x22F5, 0x1D8E, 0x1807, 0x1267, 0x0CB2, 0x06F1, 0x0128, 0xFB5E, 0xF599, 0xEFDF, 0xEA36, 0xE4A4, 0xDF30, 0xD9DF, 0xD4B6,
        0xCFBC, 0xCAF5, 0xC667, 0xC217, 0xBE09, 0xBA42, 0xB6C5, 0xB396, 0xB0B9, 0xAE31, 0xAC01, 0xAA2A, 0xA8AF, 0xA792, 0xA6D3, 0xA673,
        0xA674, 0xA6D4, 0xA793, 0xA8B1, 0xAA2D, 0xAC04, 0xAE35, 0xB0BD, 0xB39B, 0xB6CA, 0xBA47, 0xBE0F, 0xC21D, 0xC66E, 0xCAFC, 0xCFC3,
        0xD4BD, 0xD9E6, 0xDF38, 0xE4AC, 0xEA3E, 0xEFE7, 0xF5A1, 0xFB67, 0x0130, 0x06F9, 0x0CBB, 0x126F, 0x180F, 0x1D95, 0x22FC, 0x283E,
        0x2D54, 0x323A, 0x36EA, 0x3B60, 0x3F96, 0x4388, 0x4731, 0x4A8F, 0x4D9D, 0x5058, 0x52BC, 0x54C9, 0x567A, 0x57D0, 0x58C7, 0x595F,
        0x5998, 0x5971, 0x58EA, 0x5804, 0x56C0, 0x551F, 0x5324, 0x50CF, 0x4E24, 0x4B25, 0x47D6, 0x443A, 0x4055, 0x3C2B, 0x37C1, 0x331B,
        0x2E3F, 0x2931, 0x23F7, 0x1E96, 0x1915, 0x1379, 0x0DC9, 0x0809, 0x0241, 0xFC77, 0xF6B1, 0xF0F4, 0xEB47, 0xE5B1, 0xE036, 0xDADE,
        0xD5AD, 0xD0AA, 0xCBD9, 0xC740, 0xC2E4, 0xBEC9, 0xBAF3, 0xB768, 0xB42B, 0xB13E, 0xAEA6, 0xAC64, 0xAA7C, 0xA8F0, 0xA7C1, 0xA6F0,
        0xA67E, 0xA66C, 0xA6BA, 0xA768, 0xA874, 0xA9DE, 0xABA3, 0xADC4, 0xB03C, 0xB309, 0xB629, 0xB998, 0xBD52, 0xC153, 0xC597, 0xCA1A,
        0xCED7, 0xD3C8, 0xD8E8, 0xDE33, 0xE3A1, 0xE92E, 0xEED3, 0xF48A, 0xFA4E, 0x0017, 0x05E1, 0x0BA4, 0x115B, 0x1700, 0x1C8B, 0x21F9,
        0x2742, 0x2C61, 0x3150, 0x360B, 0x3A8C, 0x3ECE, 0x42CE, 0x4685, 0x49F2, 0x4D0F, 0x4FDA, 0x524F, 0x546C, 0x562F, 0x5796, 0x589F,
        0x594A, 0x5995, 0x5980, 0x590B, 0x5837, 0x5705, 0x5576, 0x538B, 0x5147, 0x4EAC, 0x4BBD, 0x487C, 0x44EF, 0x4117, 0x3CFA, 0x389C,
        0x3401, 0x2F2F, 0x2A2A, 0x24F8, 0x1F9E, 0x1A23, 0x148B, 0x0EDE, 0x0921, 0x035A, 0xFD90, 0xF7C8, 0xF209, 0xEC59, 0xE6BE, 0xE13E,
        0xDBDE, 0xD6A6, 0xD199, 0xCCBE, 0xC81B, 0xC3B2, 0xBF8B, 0xBBA8, 0xB80E, 0xB4C2, 0xB1C5, 0xAF1D, 0xACCB, 0xAAD2, 0xA934, 0xA7F3,
        0xA710, 0xA68C, 0xA668, 0xA6A4, 0xA73F, 0xA83A, 0xA992, 0xAB46, 0xAD56, 0xAFBD, 0xB27B, 0xB58B, 0xB8EB, 0xBC97, 0xC08B, 0xC4C3,
        0xC93B, 0xCDED, 0xD2D4, 0xD7EC, 0xDD2F, 0xE297, 0xE81E, 0xEDBF, 0xF374, 0xF936, 0xFEFF, 0x04C8, 0x0A8D, 0x1047, 0x15EF, 0x1B80,
        0x20F4, 0x2644, 0x2B6C, 0x3065, 0x352A, 0x39B6, 0x3E05, 0x4211, 0x45D7, 0x4951, 0x4C7E, 0x4F59, 0x51DE, 0x540C, 0x55E1, 0x5759,
        0x5874, 0x5931, 0x598E, 0x598B, 0x5928, 0x5867, 0x5746, 0x55C8, 0x53EF, 0x51BB, 0x4F31, 0x4C51, 0x4920, 0x45A1, 0x41D7, 0x3DC7,
        0x3975, 0x34BB, 0x2FD0, 0x2AB9, 0x257E, 0x2022, 0x1AAD, 0x1524, 0x0F8D, 0x09EF, 0x044F, 0xFEB5, 0xF925, 0xF3A4, 0xEE3B, 0xE8ED,
        0xE3C0, 0xDEBB, 0xD9E1, 0xD538, 0xD0C5, 0xCC8C, 0xC890, 0xC4D7, 0xC164, 0xBE39, 0xBB5A, 0xB8CA, 0xB68A, 0xB49C, 0xB303, 0xB1BE,
        0xB0D0, 0xB038, 0xAFF7, 0xB00B, 0xB075, 0xB134, 0xB246, 0xB3A9, 0xB55B, 0xB75A, 0xB9A4, 0xBC35, 0xBF0A, 0xC220, 0xC572, 0xC8FE,
        0xCCBE, 0xD0AE, 0xD4CA, 0xD90D, 0xDD72, 0xE1F4, 0xE68E, 0xEB3B, 0xEFF6, 0xF4BA, 0xF981, 0xFE46, 0x0304, 0x07B6, 0x0C58, 0x10E4,
        0x1555, 0x19A8, 0x1DD7, 0x21DE, 0x25BA, 0x2966, 0x2CDE, 0x3020, 0x3329, 0x35F5, 0x3882, 0x3ACD, 0x3CD5, 0x3E98, 0x4015, 0x414A,
        0x4237, 0x42DB, 0x4337, 0x4349, 0x4314, 0x4296, 0x41D3, 0x40CA, 0x3F7E, 0x3DF1, 0x3C24, 0x3A1A, 0x37D6, 0x355B, 0x32AB, 0x2FCA,
        0x2CBC, 0x2984, 0x2626, 0x22A6, 0x1F07, 0x1B4F, 0x1781, 0x13A2, 0x0FB5, 0x0BBF, 0x07C5, 0x03CB, 0xFFD6, 0xFBE9, 0xF807, 0xF437,
        0xF07B, 0xECD7, 0xE950, 0xE5E8, 0xE2A3, 0xDF85, 0xDC90, 0xD9C8, 0xD72E, 0xD4C6, 0xD291, 0xD092, 0xCEC9, 0xCD3A, 0xCBE4, 0xCAC9,
        0xC9EA, 0xC946, 0xC8DF, 0xC8B4, 0xC8C4, 0xC90F, 0xC995, 0xCA54, 0xCB4B, 0xCC78, 0xCDDA, 0xCF6F, 0xD134, 0xD328, 0xD547, 0xD78F,
        0xD9FE, 0xDC90, 0xDF41, 0xE210, 0xE4F9, 0xE7F8, 0xEB09, 0xEE2A, 0xF157, 0xF48C, 0xF7C6, 0xFB02, 0xFE3B, 0x016D, 0x0497, 0x07B5,
        0x0AC2, 0x0DBE, 0x10A3, 0x136F, 0x1620, 0x18B2, 0x1B23, 0x1D72, 0x1F9B, 0x219D, 0x2376, 0x2524, 0x26A6, 0x27FB, 0x2921, 0x2A19,
        0x2AE1, 0x2B78, 0x2BE0, 0x2C17, 0x2C1E, 0x2BF6, 0x2B9F, 0x2B1A, 0x2A68, 0x298A, 0x2882, 0x2751, 0x25F9, 0x247B, 0x22DA, 0x2118,
        0x1F37, 0x1D3A, 0x1B22, 0x18F3, 0x16AF, 0x1458, 0x11F2, 0x0F7F, 0x0D02, 0x0A7E, 0x07F6, 0x056C, 0x02E3, 0x005E, 0xFDE1, 0xFB6C,
        0xF903, 0xF6A8, 0xF45E, 0xF227, 0xF005, 0xEDFA, 0xEC09, 0xEA33, 0xE87A, 0xE6DE, 0xE563, 0xE409, 0xE2D1, 0xE1BC, 0xE0CA, 0xDFFE,
        0xDF56, 0xDED3, 0xDE75, 0xDE3D, 0xDE2A, 0xDE3C, 0xDE71, 0xDECB, 0xDF47, 0xDFE5, 0xE0A3, 0xE181, 0xE27E, 0xE397, 0xE4CB, 0xE619,
        0xE77F, 0xE8FA, 0xEA8A, 0xEC2C, 0xEDDE, 0xEF9E, 0xF16A, 0xF340, 0xF51E, 0xF701, 0xF8E8, 0xFAD0, 0xFCB7, 0xFE9C, 0x007A, 0x0253,
        0x0423, 0x05E8, 0x07A1, 0x094C, 0x0AE6, 0x0C70, 0x0DE6, 0x0F49, 0x1095, 0x11CC, 0x12EB, 0x13F1, 0x14DE, 0x15B1, 0x1669, 0x1707,
        0x1789, 0x17F0, 0x183C, 0x186C, 0x1881, 0x187B, 0x185A, 0x1820, 0x17CC, 0x1760, 0x16DC, 0x1641, 0x1590, 0x14CB, 0x13F2, 0x1307,
        0x120A, 0x10FE, 0x0FE4, 0x0EBD, 0x0D8A, 0x0C4E, 0x0B09, 0x09BE, 0x086D, 0x0719, 0x05C2, 0x046B, 0x0314, 0x01C0, 0x0070, 0xFF26,
        0xFDE1, 0xFCA4, 0xFB71, 0xFA47, 0xF929, 0xF818, 0xF713, 0xF61E, 0xF537, 0xF460, 0xF39A, 0xF2E5, 0xF242, 0xF1B0, 0xF131, 0xF0C5,
        0xF06B, 0xF024, 0xEFF0, 0xEFCF, 0xEFBF, 0xEFC3, 0xEFD7, 0xEFFE, 0xF035, 0xF07C, 0xF0D3, 0xF139, 0xF1AD, 0xF22F, 0xF2BD, 0xF357,
        0xF3FC, 0xF4AB, 0xF562, 0xF622, 0xF6E8, 0xF7B4, 0xF885, 0xF95A, 0xFA31, 0xFB0B, 0xFBE4, 0xFCBE, 0xFD96, 0xFE6C, 0xFF3F, 0x000D,
        0x00D7, 0x019C, 0x025A, 0x0311, 0x03C0, 0x0467, 0x0504, 0x0598, 0x0623, 0x06A3, 0x0718, 0x0782, 0x07E1, 0x0835, 0x087E, 0x08BA,
        0x08EC, 0x0912, 0x092C, 0x093C, 0x0941, 0x093A, 0x092A, 0x0910, 0x08EC, 0x08BF, 0x0889, 0x084B, 0x0805, 0x07B8, 0x0765, 0x070B,
        0x06AC, 0x0649, 0x05E1, 0x0576, 0x0507, 0x0497, 0x0425, 0x03B1, 0x033E, 0x02CA, 0x0257, 0x01E5, 0x0175, 0x0108, 0x009D, 0x0035,
        0xFFD2, 0xFF71, 0xFF15, 0xFEBE, 0xFE6B, 0xFE1E, 0xFDD6, 0xFD94, 0xFD57, 0xFD20, 0xFCEF, 0xFCC4, 0xFC9E, 0xFC7F, 0xFC66, 0xFC52,
        0xFC43, 0xFC3B, 0xFC37, 0xFC39, 0xFC3F, 0xFC4A, 0xFC59, 0xFC6D, 0xFC84, 0xFC9F, 0xFCBD, 0xFCDD, 0xFD00, 0xFD26, 0xFD4D, 0xFD76,
        0xFDA0, 0xFDCB, 0xFDF6, 0xFE21, 0xFE4D, 0xFE78, 0xFEA3, 0xFECD, 0xFEF5, 0xFF1D, 0xFF43, 0xFF67, 0xFF89, 0xFFAA, 0xFFC8, 0xFFE4,
        0xFFFE, 0x0014, 0x0029, 0x003B, 0x004C, 0x0059, 0x0065, 0x006E, 0x0075, 0x007A, 0x007D, 0x007E, 0x007D, 0x007B, 0x0077, 0x0072,
        0x006C, 0x0065, 0x005D, 0x0055, 0x004C, 0x0043, 0x003A, 0x0031, 0x0028, 0x0020, 0x0018, 0x0011, 0x000B, 0x0005, 0x0002, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0006, 0x0008, 0x0009, 0x000B, 0x000D, 0x000F, 0x0012, 0x0014,
        0x0016, 0x0018, 0x001A, 0x001C, 0x001E, 0x001F, 0x0021, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0021, 0x0020, 0x001E, 0x001B,
        0x0018, 0x0014, 0x0010, 0x000A, 0x0004, 0xFFFF, 0xFFF7, 0xFFEF, 0xFFE6, 0xFFDC, 0xFFD1, 0xFFC6, 0xFFBA, 0xFFAD, 0xFFA0, 0xFF91,
        0xFF83, 0xFF73, 0xFF63, 0xFF53, 0xFF42, 0xFF30, 0xFF1F, 0xFF0D, 0xFEFB, 0xFEE8, 0xFED6, 0xFEC4, 0xFEB2, 0xFEA0, 0xFE8F, 0xFE7E,
        0xFE6D, 0xFE5D, 0xFE4E, 0xFE40, 0xFE33, 0xFE26, 0xFE1B, 0xFE11, 0xFE09, 0xFE02, 0xFDFD, 0xFDF9, 0xFDF7, 0xFDF7, 0xFDF9, 0xFDFD,
        0xFE03, 0xFE0B, 0xFE16, 0xFE22, 0xFE31, 0xFE43, 0xFE57, 0xFE6D, 0xFE86, 0xFEA1, 0xFEBF, 0xFEDF, 0xFF02, 0xFF27, 0xFF4E, 0xFF78,
        0xFFA4, 0xFFD2, 0x0002, 0x0034, 0x0068, 0x009E, 0x00D6, 0x010F, 0x0149, 0x0185, 0x01C2, 0x0200, 0x023E, 0x027D, 0x02BC, 0x02FC,
        0x033B, 0x037A, 0x03B8, 0x03F6, 0x0432, 0x046E, 0x04A8, 0x04E0, 0x0516, 0x054A, 0x057C, 0x05AB, 0x05D7, 0x05FF, 0x0625, 0x0647,
        0x0665, 0x067F, 0x0694, 0x06A6, 0x06B2, 0x06BA, 0x06BD, 0x06BB, 0x06B4, 0x06A7, 0x0695, 0x067D, 0x0660, 0x063C, 0x0613, 0x05E5,
        0x05B0, 0x0576, 0x0536, 0x04F0, 0x04A4, 0x0453, 0x03FD, 0x03A1, 0x0340, 0x02DA, 0x026F, 0x01FF, 0x018B, 0x0113, 0x0097, 0x0017,
        0xFF95, 0xFF0F, 0xFE87, 0xFDFC, 0xFD6F, 0xFCE0, 0xFC51, 0xFBC0, 0xFB2F, 0xFA9E, 0xFA0E, 0xF97F, 0xF8F1, 0xF865, 0xF7DB, 0xF754,
        0xF6D0, 0xF650, 0xF5D4, 0xF55C, 0xF4EA, 0xF47D, 0xF417, 0xF3B6, 0xF35D, 0xF30A, 0xF2BF, 0xF27D, 0xF242, 0xF210, 0xF1E8, 0xF1C9,
        0xF1B3, 0xF1A7, 0xF1A5, 0xF1AE, 0xF1C1, 0xF1DF, 0xF208, 0xF23B, 0xF279, 0xF2C3, 0xF317, 0xF377, 0xF3E1, 0xF456, 0xF4D6, 0xF560,
        0xF5F5, 0xF694, 0xF73C, 0xF7EE, 0xF8AA, 0xF96E, 0xFA3A, 0xFB0F, 0xFBEA, 0xFCCD, 0xFDB7, 0xFEA6, 0xFF9B, 0x0094, 0x0191, 0x0293,
        0x0397, 0x049D, 0x05A5, 0x06AD, 0x07B5, 0x08BD, 0x09C3, 0x0AC6, 0x0BC7, 0x0CC3, 0x0DBB, 0x0EAE, 0x0F9A, 0x107F, 0x115D, 0x1232,
        0x12FD, 0x13BF, 0x1476, 0x1522, 0x15C1, 0x1654, 0x16DA, 0x1751, 0x17BA, 0x1814, 0x185F, 0x189A, 0x18C4, 0x18DD, 0x18E6, 0x18DD,
        0x18C2, 0x1896, 0x1858, 0x1807, 0x17A5, 0x1730, 0x16A9, 0x1610, 0x1566, 0x14AA, 0x13DC, 0x12FE, 0x120E, 0x110F, 0x1000, 0x0EE1,
        0x0DB4, 0x0C79, 0x0B30, 0x09DB, 0x087A, 0x070E, 0x0597, 0x0418, 0x028F, 0x0100, 0xFF6B, 0xFDCF, 0xFC2F, 0xFA8C, 0xF8E7, 0xF741,
        0xF59B, 0xF3F7, 0xF255, 0xF0B6, 0xEF1D, 0xED8A, 0xEBFE, 0xEA7A, 0xE900, 0xE792, 0xE62F, 0xE4D9, 0xE392, 0xE25A, 0xE132, 0xE01C,
        0xDF18, 0xDE28, 0xDD4C, 0xDC86, 0xDBD5, 0xDB3B, 0xDAB9, 0xDA4F, 0xD9FE, 0xD9C6, 0xD9A8, 0xD9A4, 0xD9BB, 0xD9EC, 0xDA39, 0xDAA1,
        0xDB24, 0xDBC2, 0xDC7B, 0xDD4F, 0xDE3E, 0xDF47, 0xE06B, 0xE1A7, 0xE2FD, 0xE46B, 0xE5F0, 0xE78C, 0xE93E, 0xEB06, 0xECE1, 0xEECF,
        0xF0CF, 0xF2DF, 0xF4FF, 0xF72E, 0xF968, 0xFBAE, 0xFDFE, 0x0056, 0x02B5, 0x0519, 0x0781, 0x09EB, 0x0C55, 0x0EBE, 0x1124, 0x1385,
        0x15E0, 0x1832, 0x1A7A, 0x1CB7, 0x1EE7, 0x2107, 0x2317, 0x2515, 0x26FE, 0x28D2, 0x2A90, 0x2C35, 0x2DC0, 0x2F30, 0x3083, 0x31B9,
        0x32D0, 0x33C7, 0x349D, 0x3551, 0x35E2, 0x3650, 0x369A, 0x36BE, 0x36BE, 0x3697, 0x364B, 0x35D9, 0x3540, 0x3481, 0x339C, 0x3291,
        0x3160, 0x300A, 0x2E90, 0x2CF2, 0x2B30, 0x294C, 0x2747, 0x2521, 0x22DC, 0x207A, 0x1DFA, 0x1B60, 0x18AC, 0x15E0, 0x12FD, 0x1007,
        0x0CFD, 0x09E3, 0x06BA, 0x0384, 0x0044, 0xFCFC, 0xF9AD, 0xF65A, 0xF305, 0xEFB1, 0xEC5F, 0xE913, 0xE5CE, 0xE293, 0xDF64, 0xDC43,
        0xD934, 0xD637, 0xD350, 0xD080, 0xCDCA, 0xCB2F, 0xC8B3, 0xC656, 0xC41B, 0xC204, 0xC012, 0xBE47, 0xBCA6, 0xBB2E, 0xB9E2, 0xB8C3,
        0xB7D2, 0xB710, 0xB67F, 0xB61E, 0xB5F0, 0xB5F3, 0xB629, 0xB693, 0xB730, 0xB800, 0xB903, 0xBA39, 0xBBA2, 0xBD3C, 0xBF09, 0xC106,
        0xC332, 0xC58D, 0xC816, 0xCACB, 0xCDAA, 0xD0B2, 0xD3E2, 0xD737, 0xDAAF, 0xDE49, 0xE202, 0xE5D8, 0xE9C8, 0xEDD0, 0xF1EE, 0xF61F,
        0xFA5F, 0xFEAD, 0x0304, 0x0764, 0x0BC8, 0x102E, 0x1493, 0x18F3, 0x1D4C, 0x219A, 0x25DA, 0x2A0A, 0x2E26, 0x322C, 0x3617, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2F22, 0x32FA, 0x36B1, 0x3A42, 0x3DAC, 0x40ED, 0x4402, 0x46E9, 0x49A0, 0x4C25, 0x4E78, 0x5095, 0x527C, 0x542C, 0x55A2,
        0x56DF, 0x57E2, 0x58A9, 0x5935, 0x5984, 0x5997, 0x596E, 0x5909, 0x5867, 0x578A, 0x5672, 0x551F, 0x5394, 0x51D0, 0x4FD4, 0x4DA3,
        0x4B3E, 0x48A6, 0x45DD, 0x42E5, 0x3FC0, 0x3C70, 0x38F7, 0x3558, 0x3195, 0x2DB0, 0x29AD, 0x258D, 0x2154, 0x1D05, 0x18A2, 0x142F,
        0x0FAE, 0x0B22, 0x068F, 0x01F8, 0xFD60, 0xF8C9, 0xF437, 0xEFAD, 0xEB2D, 0xE6BC, 0xE25C, 0xDE10, 0xD9DA, 0xD5BF, 0xD1C0, 0xCDE0,
        0xCA22, 0xC688, 0xC314, 0xBFCA, 0xBCAC, 0xB9BA, 0xB6F8, 0xB467, 0xB209, 0xAFE0, 0xADEC, 0xAC30, 0xAAAD, 0xA963, 0xA853, 0xA77E,
        0xA6E5, 0xA688, 0xA668, 0xA683, 0xA6DB, 0xA770, 0xA83F, 0xA94A, 0xAA90, 0xAC0F, 0xADC6, 0xAFB5, 0xB1DA, 0xB434, 0xB6C1, 0xB97F,
        0xBC6C, 0xBF88, 0xC2CE, 0xC63E, 0xC9D5, 0xCD90, 0xD16E, 0xD56A, 0xD984, 0xDDB7, 0xE201, 0xE660, 0xEAD0, 0xEF4E, 0xF3D8, 0xF869,
        0xFD00, 0x0198, 0x0630, 0x0AC3, 0x0F4F, 0x13D1, 0x1846, 0x1CAA, 0x20FB, 0x2536, 0x2957, 0x2D5D, 0x3144, 0x350A, 0x38AD, 0x3C29,
        0x3F7C, 0x42A5, 0x45A1, 0x486E, 0x4B0A, 0x4D73, 0x4FA9, 0x51A8, 0x5371, 0x5501, 0x5658, 0x5775, 0x5857, 0x58FE, 0x5968, 0x5996,
        0x5988, 0x593E, 0x58B7, 0x57F5, 0x56F7, 0x55BE, 0x544C, 0x52A1, 0x50BF, 0x4EA6, 0x4C58, 0x49D6, 0x4723, 0x4440, 0x412F, 0x3DF2,
        0x3A8B, 0x36FD, 0x3349, 0x2F73, 0x2B7E, 0x276A, 0x233D, 0x1EF7, 0x1A9D, 0x1630, 0x11B5, 0x0D2E, 0x089E, 0x0408, 0xFF70, 0xFAD8,
        0xF643, 0xF1B5, 0xED31, 0xE8B9, 0xE451, 0xDFFB, 0xDBBB, 0xD794, 0xD387, 0xCF99, 0xCBCB, 0xC821, 0xC49C, 0xC13F, 0xBE0D, 0xBB07,
        0xB82F, 0xB588, 0xB313, 0xB0D2, 0xAEC6, 0xACF1, 0xAB54, 0xA9F0, 0xA8C6, 0xA7D6, 0xA723, 0xA6AB, 0xA66F, 0xA66F, 0xA6AC, 0xA726,
        0xA7DB, 0xA8CB, 0xA9F6, 0xAB5C, 0xACFA, 0xAED0, 0xB0DD, 0xB31F, 0xB595, 0xB83D, 0xBB16, 0xBE1D, 0xC150, 0xC4AE, 0xC834, 0xCBDF,
        0xCFAD, 0xD39C, 0xD7A9, 0xDBD1, 0xE012, 0xE467, 0xE8D0, 0xED48, 0xF1CD, 0xF65B, 0xFAF0, 0xFF88, 0x0420, 0x08B6, 0x0D46, 0x11CD,
        0x1648, 0x1AB4, 0x1F0E, 0x2353, 0x2780, 0x2B93, 0x2F88, 0x335D, 0x3710, 0x3A9D, 0x3E03, 0x413F, 0x4450, 0x4732, 0x49E4, 0x4C64,
        0x4EB1, 0x50C9, 0x52AB, 0x5455, 0x55C5, 0x56FD, 0x57F9, 0x58BA, 0x5940, 0x5989, 0x5996, 0x5967, 0x58FB, 0x5853, 0x5770, 0x5652,
        0x54FA, 0x5368, 0x519E, 0x4F9E, 0x4D67, 0x4AFD, 0x4860, 0x4592, 0x4295, 0x3F6B, 0x3C17, 0x389A, 0x34F7, 0x3130, 0x2D49, 0x2942,
        0x2520, 0x20E5, 0x1C93, 0x182F, 0x13BA, 0x0F38, 0x0AAB, 0x0618, 0x0180, 0xFCE8, 0xF851, 0xF3C0, 0xEF37, 0xEAB9, 0xE649, 0xE1EB,
        0xDDA1, 0xD96E, 0xD555, 0xD159, 0xCD7C, 0xC9C2, 0xC62C, 0xC2BD, 0xBF77, 0xBC5D, 0xB970, 0xB6B3, 0xB427, 0xB1CE, 0xAFAA, 0xADBD,
        0xAC06, 0xAA88, 0xA944, 0xA83A, 0xA76C, 0xA6D9, 0xA682, 0xA668, 0xA68A, 0xA6E8, 0xA782, 0xA858, 0xA969, 0xAAB4, 0xAC39, 0xADF6,
        0xAFEB, 0xB215, 0xB474, 0xB706, 0xB9C9, 0xBCBB, 0xBFDB, 0xC326, 0xC69A, 0xCA35, 0xCDF4, 0xD1D4, 0xD5D4, 0xD9F0, 0xDE26, 0xE273,
        0xE6D3, 0xEB45, 0xEFC4, 0xF44F, 0xF8E1, 0xFD78, 0x0210, 0x06A7, 0x0B3A, 0x0FC6, 0x1446, 0x18B9, 0x1D1C, 0x216B, 0x25A3, 0x29C2,
        0x2DC5, 0x31A9, 0x356B, 0x390A, 0x3C82, 0x3FD1, 0x42F5, 0x45EC, 0x48B4, 0x4B4B, 0x4DAF, 0x4FDF, 0x51D9, 0x539C, 0x5527, 0x5678,
        0x578F, 0x586B, 0x590B, 0x5970, 0x5998, 0x5983, 0x5933, 0x58A6, 0x57DD, 0x56DA, 0x559B, 0x5423, 0x5273, 0x508B, 0x4E6C, 0x4C19,
        0x4992, 0x46DA, 0x43F2, 0x40DC, 0x3D9B, 0x3A30, 0x369E, 0x32E7, 0x2F0D, 0x2B14, 0x26FE, 0x22CE, 0x1E86, 0x1A2A, 0x15BC, 0x113F,
        0x0CB7, 0x0826, 0x0390, 0xFEF8, 0xFA60, 0xF5CC, 0xF13F, 0xECBB, 0xE845, 0xE3DE, 0xDF8B, 0xDB4D, 0xD729, 0xD31F, 0xCF34, 0xCB6A,
        0xC7C3, 0xC442, 0xC0EA, 0xBDBC, 0xBABA, 0xB7E7, 0xB545, 0xB2D6, 0xB09A, 0xAE93, 0xACC4, 0xAB2D, 0xA9CF, 0xA8AA, 0xA7C1, 0xA714,
        0xA6A2, 0xA66C, 0xA673, 0xA6B6, 0xA735, 0xA7F0, 0xA8E7, 0xAA18, 0xAB83, 0xAD27, 0xAF03, 0xB115, 0xB35D, 0xB5D8, 0xB886, 0xBB63,
        0xBE6F, 0xC1A6, 0xC508, 0xC892, 0xCC41, 0xD013, 0xD405, 0xD814, 0xDC3F, 0xE082, 0xE4DA, 0xE944, 0xEDBE, 0xF244, 0xF6D3, 0xFB68,
        0x0000, 0x0498, 0x092D, 0x0DBC, 0x1242, 0x16BC, 0x1B26, 0x1F7E, 0x23C1, 0x27EC, 0x2BFB, 0x2FED, 0x33BF, 0x376E, 0x3AF8, 0x3E5A,
        0x4191, 0x449D, 0x477A, 0x4A28, 0x4CA3, 0x4EEB, 0x50FD, 0x52D9, 0x547D, 0x55E8, 0x5719, 0x5810, 0x58CB, 0x594A, 0x598D, 0x5994,
        0x595E, 0x58EC, 0x583F, 0x5756, 0x5631, 0x54D3, 0x533C, 0x516D, 0x4F66, 0x4D2A, 0x4ABB, 0x4819, 0x4546, 0x4244, 0x3F16, 0x3BBE,
        0x383D, 0x3496, 0x30CC, 0x2CE1, 0x28D7, 0x24B3, 0x2075, 0x1C22, 0x17BB, 0x1345, 0x0EC1, 0x0A34, 0x05A0, 0x0108, 0xFC70, 0xF7DA,
        0xF349, 0xEEC1, 0xEA44, 0xE5D6, 0xE17A, 0xDD32, 0xD902, 0xD4EC, 0xD0F3, 0xCD19, 0xC962, 0xC5D0, 0xC265, 0xBF24, 0xBC0E, 0xB926,
        0xB66E, 0xB3E7, 0xB194, 0xAF75, 0xAD8D, 0xABDD, 0xAA65, 0xA926, 0xA823, 0xA75A, 0xA6CD, 0xA67D, 0xA668, 0xA690, 0xA6F5, 0xA795,
        0xA871, 0xA988, 0xAAD9, 0xAC64, 0xAE27, 0xB021, 0xB251, 0xB4B5, 0xB74C, 0xBA14, 0xBD0B, 0xC02F, 0xC37E, 0xC6F6, 0xCA95, 0xCE57,
        0xD23B, 0xD63E, 0xDA5D, 0xDE95, 0xE2E4, 0xE747, 0xEBBA, 0xF03A, 0xF4C6, 0xF959, 0xFDF0, 0x0288, 0x071F, 0x0BB1, 0x103C, 0x14BB,
        0x192D, 0x1D8D, 0x21DA, 0x2610, 0x2A2C, 0x2E2C, 0x320C, 0x35CB, 0x3966, 0x3CDA, 0x4025, 0x4345, 0x4637, 0x48FA, 0x4B8C, 0x4DEB,
        0x5015, 0x520A, 0x53C7, 0x554C, 0x5697, 0x57A8, 0x587E, 0x5918, 0x5976, 0x5998, 0x597E, 0x5927, 0x5894, 0x57C6, 0x56BC, 0x5578,
        0x53FA, 0x5243, 0x5056, 0x4E32, 0x4BD9, 0x494D, 0x4690, 0x43A3, 0x4089, 0x3D43, 0x39D4, 0x363E, 0x3284, 0x2EA7, 0x2AAB, 0x2692,
        0x225F, 0x1E15, 0x19B7, 0x1547, 0x10C9, 0x0C40, 0x07AF, 0x0318, 0xFE80, 0xF9E8, 0xF555, 0xF0C8, 0xEC46, 0xE7D1, 0xE36D, 0xDF1B,
        0xDAE0, 0xD6BE, 0xD2B7, 0xCED0, 0xCB09, 0xC766, 0xC3E9, 0xC095, 0xBD6B, 0xBA6E, 0xB7A0, 0xB503, 0xB299, 0xB062, 0xAE62, 0xAC98,
        0xAB06, 0xA9AE, 0xA890, 0xA7AD, 0xA705, 0xA699, 0xA66A, 0xA677, 0xA6C0, 0xA746, 0xA807, 0xA903, 0xAA3B, 0xABAB, 0xAD55, 0xAF37,
        0xB14F, 0xB39C, 0xB61C, 0xB8CE, 0xBBB0, 0xBEC1, 0xC1FD, 0xC563, 0xC8F0, 0xCCA3, 0xD078, 0xD46D, 0xD880, 0xDCAD, 0xE0F2, 0xE54C,
        0xE9B8, 0xEE33, 0xF2BA, 0xF74A, 0xFBE0, 0x0078, 0x0510, 0x09A5, 0x0E33, 0x12B8, 0x1730, 0x1B99, 0x1FEE, 0x242F, 0x2857, 0x2C64,
        0x3053, 0x3421, 0x37CC, 0x3B52, 0x3EB0, 0x41E3, 0x44EA, 0x47C3, 0x4A6B, 0x4CE1, 0x4F23, 0x5130, 0x5306, 0x54A4, 0x560A, 0x5735,
        0x5825, 0x58DA, 0x5954, 0x5991, 0x5991, 0x5955, 0x58DD, 0x582A, 0x573A, 0x5610, 0x54AC, 0x530F, 0x513A, 0x4F2E, 0x4CED, 0x4A78,
        0x47D1, 0x44F9, 0x41F3, 0x3EC1, 0x3B64, 0x37DF, 0x3435, 0x3067, 0x2C79, 0x286C, 0x2445, 0x2005, 0x1BAF, 0x1747, 0x12CF, 0x0E4B,
        0x09BD, 0x0528, 0x0090, 0xFBF8, 0xF762, 0xF2D2, 0xEE4B, 0xE9D0, 0xE563, 0xE109, 0xDCC3, 0xD896, 0xD482, 0xD08D, 0xCCB7, 0xC903,
        0xC575, 0xC20E, 0xBED1, 0xBBC0, 0xB8DD, 0xB62A, 0xB3A8, 0xB15A, 0xAF41, 0xAD5F, 0xABB4, 0xAA42, 0xA909, 0xA80B, 0xA749, 0xA6C2,
        0xA678, 0xA66A, 0xA698, 0xA702, 0xA7A9, 0xA88B, 0xA9A8, 0xAAFF, 0xAC8F, 0xAE58, 0xB057, 0xB28D, 0xB4F6, 0xB792, 0xBA5F, 0xBD5B,
        0xC084, 0xC3D7, 0xC753, 0xCAF6, 0xCEBC, 0xD2A3, 0xD6A9, 0xDACA, 0xDF05, 0xE356, 0xE7BA, 0xEC2F, 0xF0B1, 0xF53D, 0xF9D0, 0xFE68,
        0x0300, 0x0797, 0x0C28, 0x10B2, 0x1530, 0x19A0, 0x1DFF, 0x2249, 0x267C, 0x2A96, 0x2E92, 0x3270, 0x362B, 0x39C2, 0x3D32, 0x4078,
        0x4394, 0x4681, 0x493F, 0x4BCC, 0x4E26, 0x504B, 0x523A, 0x53F1, 0x5570, 0x56B6, 0x57C1, 0x5890, 0x5925, 0x597D, 0x5998, 0x5978,
        0x591B, 0x5882, 0x57AD, 0x569D, 0x5553, 0x53D0, 0x5214, 0x5020, 0x4DF7, 0x4B99, 0x4908, 0x4646, 0x4354, 0x4036, 0x3CEC, 0x3978,
        0x35DE, 0x3220, 0x2E40, 0x2A41, 0x2626, 0x21F0, 0x1DA4, 0x1944, 0x14D3, 0x1053, 0x0BC9, 0x0737, 0x02A0, 0xFE08, 0xF971, 0xF4DE,
        0xF052, 0xEBD1, 0xE75E, 0xE2FB, 0xDEAC, 0xDA73, 0xD653, 0xD250, 0xCE6B, 0xCAA8, 0xC709, 0xC390, 0xC040, 0xBD1B, 0xBA23, 0xB75A,
        0xB4C2, 0xB25D, 0xB02C, 0xAE30, 0xAC6C, 0xAAE1, 0xA98E, 0xA876, 0xA799, 0xA6F7, 0xA692, 0xA669, 0xA67C, 0xA6CB, 0xA757, 0xA81E,
        0xA921, 0xAA5E, 0xABD4, 0xAD84, 0xAF6B, 0xB188, 0xB3DB, 0xB660, 0xB917, 0xBBFE, 0xBF13, 0xC254, 0xC5BE, 0xC94F, 0xCD06, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC619, 0xC9AF, 0xCD69, 0xD144, 0xD540, 0xD958, 0xDD8B, 0xE1D4, 0xE632, 0xEAA1, 0xEF1F, 0xF3A8, 0xF839, 0xFCD0, 0x0168,
        0x0600, 0x0A93, 0x0F20, 0x13A2, 0x1818, 0x1C7D, 0x20CE, 0x250A, 0x292D, 0x2D34, 0x311C, 0x34E4, 0x3887, 0x3C05, 0x3F5A, 0x4285,
        0x4583, 0x4851, 0x4AF0, 0x4D5B, 0x4F93, 0x5194, 0x535F, 0x54F2, 0x564B, 0x576B, 0x584F, 0x58F8, 0x5965, 0x5996, 0x598A, 0x5942,
        0x58BE, 0x57FE, 0x5702, 0x55CC, 0x545D, 0x52B4, 0x50D4, 0x4EBD, 0x4C71, 0x49F2, 0x4740, 0x445F, 0x4150, 0x3E14, 0x3AAF, 0x3723,
        0x3371, 0x2F9C, 0x2BA8, 0x2795, 0x2369, 0x1F24, 0x1ACB, 0x165F, 0x11E4, 0x0D5D, 0x08CE, 0x0438, 0xFFA0, 0xFB08, 0xF673, 0xF1E5,
        0xED60, 0xE8E7, 0xE47E, 0xE028, 0xDBE7, 0xD7BF, 0xD3B1, 0xCFC2, 0xCBF2, 0xC846, 0xC4C0, 0xC162, 0xBE2D, 0xBB25, 0xB84C, 0xB5A3,
        0xB32B, 0xB0E8, 0xAEDA, 0xAD03, 0xAB63, 0xA9FD, 0xA8D1, 0xA7DF, 0xA729, 0xA6AE, 0xA670, 0xA66E, 0xA6A9, 0xA71F, 0xA7D2, 0xA8C0,
        0xA9E9, 0xAB4C, 0xACE8, 0xAEBC, 0xB0C6, 0xB307, 0xB57A, 0xB821, 0xBAF7, 0xBDFC, 0xC12E, 0xC48A, 0xC80E, 0xCBB8, 0xCF85, 0xD373,
        0xD77E, 0xDBA5, 0xDFE5, 0xE43A, 0xE8A2, 0xED19, 0xF19E, 0xF62C, 0xFAC0, 0xFF58, 0x03F0, 0x0886, 0x0D16, 0x119E, 0x1619, 0x1A86,
        0x1EE1, 0x2326, 0x2755, 0x2B69, 0x2F5F, 0x3336, 0x36EA, 0x3A79, 0x3DE0, 0x411E, 0x4430, 0x4715, 0x49C9, 0x4C4B, 0x4E9A, 0x50B4,
        0x5298, 0x5444, 0x55B8, 0x56F1, 0x57F0, 0x58B4, 0x593B, 0x5987, 0x5997, 0x596A, 0x5900, 0x585B, 0x577A, 0x565F, 0x5509, 0x537A,
        0x51B2, 0x4FB4, 0x4D7F, 0x4B17, 0x487C, 0x45B0, 0x42B5, 0x3F8D, 0x3C3B, 0x38BF, 0x351E, 0x3159, 0x2D72, 0x296D, 0x254C, 0x2111,
        0x1CC1, 0x185D, 0x13E9, 0x0F67, 0x0ADB, 0x0647, 0x01B0, 0xFD18, 0xF881, 0xF3EF, 0xEF66, 0xEAE7, 0xE677, 0xE218, 0xDDCD, 0xD999,
        0xD57F, 0xD182, 0xCDA4, 0xC9E8, 0xC650, 0xC2E0, 0xBF98, 0xBC7C, 0xB98D, 0xB6CE, 0xB441, 0xB1E6, 0xAFC0, 0xADD0, 0xAC17, 0xAA97,
        0xA950, 0xA844, 0xA773, 0xA6DE, 0xA685, 0xA668, 0xA687, 0xA6E3, 0xA77B, 0xA84E, 0xA95C, 0xAAA5, 0xAC28, 0xADE3, 0xAFD5, 0xB1FD,
        0xB45A, 0xB6EA, 0xB9AB, 0xBC9C, 0xBFBA, 0xC303, 0xC675, 0xCA0E, 0xCDCC, 0xD1AB, 0xD5AA, 0xD9C5, 0xDDFA, 0xE245, 0xE6A5, 0xEB16,
        0xEF95, 0xF41F, 0xF8B1, 0xFD48, 0x01E0, 0x0677, 0x0B0B, 0x0F96, 0x1418, 0x188B, 0x1CEE, 0x213E, 0x2577, 0x2997, 0x2D9B, 0x3181,
        0x3544, 0x38E4, 0x3C5E, 0x3FAF, 0x42D5, 0x45CE, 0x4898, 0x4B31, 0x4D97, 0x4FCA, 0x51C6, 0x538B, 0x5518, 0x566B, 0x5785, 0x5863,
        0x5906, 0x596D, 0x5997, 0x5985, 0x5937, 0x58AD, 0x57E7, 0x56E5, 0x55A9, 0x5434, 0x5286, 0x50A0, 0x4E83, 0x4C32, 0x49AD, 0x46F7,
        0x4411, 0x40FD, 0x3DBE, 0x3A54, 0x36C4, 0x330E, 0x2F36, 0x2B3E, 0x272A, 0x22FA, 0x1EB3, 0x1A58, 0x15EB, 0x116E, 0x0CE7, 0x0856,
        0x03C0, 0xFF28, 0xFA90, 0xF5FC, 0xF16E, 0xECEA, 0xE873, 0xE40C, 0xDFB8, 0xDB79, 0xD753, 0xD349, 0xCF5C, 0xCB91, 0xC7E9, 0xC466,
        0xC10C, 0xBDDC, 0xBAD9, 0xB804, 0xB560, 0xB2EE, 0xB0B0, 0xAEA8, 0xACD6, 0xAB3C, 0xA9DC, 0xA8B5, 0xA7CA, 0xA719, 0xA6A5, 0xA66D,
        0xA671, 0xA6B2, 0xA72F, 0xA7E8, 0xA8DC, 0xAA0B, 0xAB73, 0xAD15, 0xAEEF, 0xB0FF, 0xB344, 0xB5BD, 0xB869, 0xBB44, 0xBE4E, 0xC184,
        0xC4E4, 0xC86C, 0xCC1A, 0xCFEA, 0xD3DB, 0xD7E9, 0xDC13, 0xE055, 0xE4AC, 0xE916, 0xED8F, 0xF214, 0xF6A3, 0xFB38, 0xFFD0, 0x0468,
        0x08FD, 0x0D8D, 0x1213, 0x168D, 0x1AF8, 0x1F51, 0x2395, 0x27C1, 0x2BD1, 0x2FC5, 0x3398, 0x3748, 0x3AD4, 0x3E37, 0x4171, 0x447E,
        0x475D, 0x4A0D, 0x4C8A, 0x4ED4, 0x50E8, 0x52C6, 0x546D, 0x55DA, 0x570E, 0x5807, 0x58C4, 0x5946, 0x598C, 0x5995, 0x5962, 0x58F2,
        0x5847, 0x5760, 0x563E, 0x54E3, 0x534E, 0x5181, 0x4F7C, 0x4D43, 0x4AD5, 0x4835, 0x4564, 0x4265, 0x3F38, 0x3BE1, 0x3862, 0x34BD,
        0x30F4, 0x2D0A, 0x2902, 0x24DE, 0x20A2, 0x1C4F, 0x17E9, 0x1374, 0x0EF1, 0x0A64, 0x05D0, 0x0138, 0xFCA0, 0xF80A, 0xF378, 0xEEF0,
        0xEA73, 0xE604, 0xE1A7, 0xDD5E, 0xD92D, 0xD516, 0xD11C, 0xCD41, 0xC988, 0xC5F5, 0xC288, 0xBF45, 0xBC2D, 0xB944, 0xB689, 0xB401,
        0xB1AB, 0xAF8B, 0xADA0, 0xABED, 0xAA73, 0xA932, 0xA82C, 0xA761, 0xA6D2, 0xA67F, 0xA668, 0xA68E, 0xA6EF, 0xA78D, 0xA867, 0xA97B,
        0xAACA, 0xAC52, 0xAE13, 0xB00B, 0xB239, 0xB49B, 0xB730, 0xB9F6, 0xBCEB, 0xC00E, 0xC35B, 0xC6D1, 0xCA6E, 0xCE2F, 0xD212, 0xD614,
        0xDA31, 0xDE69, 0xE2B7, 0xE718, 0xEB8B, 0xF00B, 0xF496, 0xF929, 0xFDC0, 0x0258, 0x06EF, 0x0B82, 0x100D, 0x148D, 0x18FF, 0x1D60,
        0x21AD, 0x25E4, 0x2A02, 0x2E03, 0x31E5, 0x35A5, 0x3941, 0x3CB7, 0x4003, 0x4325, 0x4619, 0x48DE, 0x4B72, 0x4DD3, 0x5000, 0x51F7,
        0x53B6, 0x553D, 0x568B, 0x579E, 0x5876, 0x5913, 0x5974, 0x5998, 0x5980, 0x592C, 0x589B, 0x57CF, 0x56C8, 0x5586, 0x540B, 0x5256,
        0x506B, 0x4E49, 0x4BF3, 0x4969, 0x46AE, 0x43C3, 0x40AA, 0x3D66, 0x39F9, 0x3664, 0x32AB, 0x2ED0, 0x2AD5, 0x26BD, 0x228C, 0x1E42,
        0x19E5, 0x1576, 0x10F9, 0x0C70, 0x07DF, 0x0348, 0xFEB0, 0xFA18, 0xF584, 0xF0F8, 0xEC75, 0xE7FF, 0xE39A, 0xDF48, 0xDB0C, 0xD6E9,
        0xD2E1, 0xCEF8, 0xCB30, 0xC78B, 0xC40D, 0xC0B7, 0xBD8B, 0xBA8D, 0xB7BD, 0xB51E, 0xB2B1, 0xB078, 0xAE75, 0xACA9, 0xAB16, 0xA9BB,
        0xA89B, 0xA7B5, 0xA70B, 0xA69D, 0xA66B, 0xA675, 0xA6BC, 0xA73F, 0xA7FE, 0xA8F8, 0xAA2D, 0xAB9B, 0xAD43, 0xAF22, 0xB138, 0xB383,
        0xB601, 0xB8B1, 0xBB91, 0xBEA0, 0xC1DA, 0xC53F, 0xC8CB, 0xCC7C, 0xD050, 0xD444, 0xD855, 0xDC81, 0xE0C5, 0xE51F, 0xE98A, 0xEE04,
        0xF28B, 0xF71A, 0xFBB0, 0x0048, 0x04E0, 0x0975, 0x0E04, 0x1289, 0x1702, 0x1B6B, 0x1FC2, 0x2403, 0x282C, 0x2C3A, 0x302A, 0x33FA,
        0x37A7, 0x3B2E, 0x3E8D, 0x41C2, 0x44CB, 0x47A6, 0x4A50, 0x4CC8, 0x4F0D, 0x511C, 0x52F4, 0x5495, 0x55FC, 0x572A, 0x581D, 0x58D4,
        0x5950, 0x598F, 0x5992, 0x5959, 0x58E4, 0x5832, 0x5745, 0x561E, 0x54BC, 0x5321, 0x514E, 0x4F45, 0x4D06, 0x4A93, 0x47EE, 0x4518,
        0x4214, 0x3EE3, 0x3B88, 0x3805, 0x345C, 0x308F, 0x2CA2, 0x2897, 0x2471, 0x2032, 0x1BDD, 0x1776, 0x12FE, 0x0E7A, 0x09EC, 0x0558,
        0x00C0, 0xFC28, 0xF792, 0xF302, 0xEE7A, 0xE9FE, 0xE591, 0xE136, 0xDCF0, 0xD8C1, 0xD4AC, 0xD0B5, 0xCCDE, 0xC929, 0xC599, 0xC231,
        0xBEF2, 0xBBDF, 0xB8FA, 0xB645, 0xB3C1, 0xB171, 0xAF56, 0xAD71, 0xABC4, 0xAA4F, 0xA915, 0xA815, 0xA750, 0xA6C7, 0xA67A, 0xA669,
        0xA695, 0xA6FD, 0xA7A1, 0xA880, 0xA99B, 0xAAF0, 0xAC7E, 0xAE44, 0xB041, 0xB275, 0xB4DC, 0xB776, 0xBA41, 0xBD3B, 0xC062, 0xC3B4,
        0xC72E, 0xCACF, 0xCE93, 0xD279, 0xD67E, 0xDA9E, 0xDED8, 0xE328, 0xE78C, 0xEC00, 0xF081, 0xF50D, 0xF9A1, 0xFE38, 0x02D0, 0x0767,
        0x0BF9, 0x1083, 0x1501, 0x1972, 0x1DD1, 0x221D, 0x2651, 0x2A6C, 0x2E69, 0x3248, 0x3605, 0x399D, 0x3D0F, 0x4057, 0x4374, 0x4664,
        0x4924, 0x4BB3, 0x4E0E, 0x5036, 0x5227, 0x53E1, 0x5562, 0x56AA, 0x57B7, 0x5889, 0x5920, 0x597A, 0x5998, 0x597A, 0x5920, 0x5889,
        0x57B7, 0x56AA, 0x5562, 0x53E1, 0x5227, 0x5036, 0x4E0E, 0x4BB3, 0x4924, 0x4664, 0x4374, 0x4057, 0x3D0F, 0x399D, 0x3605, 0x3248,
        0x2E69, 0x2A6C, 0x2651, 0x221D, 0x1DD1, 0x1972, 0x1501, 0x1083, 0x0BF9, 0x0767, 0x02D0, 0xFE38, 0xF9A1, 0xF50D, 0xF081, 0xEC00,
        0xE78C, 0xE328, 0xDED8, 0xDA9E, 0xD67E, 0xD279, 0xCE93, 0xCACF, 0xC72E, 0xC3B4, 0xC062, 0xBD3B, 0xBA41, 0xB776, 0xB4DC, 0xB275,
        0xB041, 0xAE44, 0xAC7E, 0xAAF0, 0xA99B, 0xA880, 0xA7A1, 0xA6FD, 0xA695, 0xA669, 0xA67A, 0xA6C7, 0xA750, 0xA815, 0xA915, 0xAA4F,
        0xABC4, 0xAD71, 0xAF56, 0xB171, 0xB3C1, 0xB645, 0xB8FA, 0xBBDF, 0xBEF2, 0xC231, 0xC599, 0xC929, 0xCCDE, 0xD0B5, 0xD4AC, 0xD8C1,
        0xDCF0, 0xE136, 0xE591, 0xE9FE, 0xEE7A, 0xF302, 0xF792, 0xFC28, 0x00C0, 0x0558, 0x09EC, 0x0E7A, 0x12FE, 0x1776, 0x1BDD, 0x2032,
        0x2471, 0x2897, 0x2CA2, 0x308F, 0x345C, 0x3805, 0x3B88, 0x3EE3, 0x4214, 0x4518, 0x47EE, 0x4A93, 0x4D06, 0x4F45, 0x514E, 0x5321,
        0x54BC, 0x561E, 0x5745, 0x5832, 0x58E4, 0x5959, 0x5992, 0x598F, 0x5950, 0x58D4, 0x581D, 0x572A, 0x55FC, 0x5495, 0x52F4, 0x511C,
        0x4F0D, 0x4CC8, 0x4A50, 0x47A6, 0x44CB, 0x41C2, 0x3E8D, 0x3B2E, 0x37A7, 0x33FA, 0x302A, 0x2C3A, 0x282C, 0x2403, 0x1FC2, 0x1B6B,
        0x1702, 0x1289, 0x0E04, 0x0975, 0x04E0, 0x0048, 0xFBB0, 0xF71A, 0xF28B, 0xEE04, 0xE98A, 0xE51F, 0xE0C5, 0xDC81, 0xD855, 0xD444,
        0xD050, 0xCC7C, 0xC8CB, 0xC53F, 0xC1DA, 0xBEA0, 0xBB91, 0xB8B1, 0xB601, 0xB383, 0xB138, 0xAF22, 0xAD43, 0xAB9B, 0xAA2D, 0xA8F8,
        0xA7FE, 0xA73F, 0xA6BC, 0xA675, 0xA66B, 0xA69D, 0xA70B, 0xA7B5, 0xA89B, 0xA9BB, 0xAB16, 0xACA9, 0xAE75, 0xB078, 0xB2B1, 0xB51E,
        0xB7BD, 0xBA8D, 0xBD8B, 0xC0B7, 0xC40D, 0xC78B, 0xCB30, 0xCEF8, 0xD2E1, 0xD6E9, 0xDB0C, 0xDF48, 0xE39A, 0xE7FF, 0xEC75, 0xF0F8,
        0xF584, 0xFA18, 0xFEB0, 0x0348, 0x07DF, 0x0C70, 0x10F9, 0x1576, 0x19E5, 0x1E42, 0x228C, 0x26BD, 0x2AD5, 0x2ED0, 0x32AB, 0x3664,
        0x39F9, 0x3D66, 0x40AA, 0x43C3, 0x46AE, 0x4969, 0x4BF3, 0x4E49, 0x506B, 0x5256, 0x540B, 0x5586, 0x56C8, 0x57CF, 0x589B, 0x592C,
        0x5980, 0x5998, 0x5974, 0x5913, 0x5876, 0x579E, 0x568B, 0x553D, 0x53B6, 0x51F7, 0x5000, 0x4DD3, 0x4B72, 0x48DE, 0x4619, 0x4325,
        0x4003, 0x3CB7, 0x3941, 0x35A5, 0x31E5, 0x2E03, 0x2A02, 0x25E4, 0x21AD, 0x1D60, 0x18FF, 0x148D, 0x100D, 0x0B82, 0x06EF, 0x0258,
        0xFDC0, 0xF929, 0xF496, 0xF00B, 0xEB8B, 0xE718, 0xE2B7, 0xDE69, 0xDA31, 0xD614, 0xD212, 0xCE2F, 0xCA6E, 0xC6D1, 0xC35B, 0xC00E,
        0xBCEB, 0xB9F6, 0xB730, 0xB49B, 0xB239, 0xB00B, 0xAE13, 0xAC52, 0xAACA, 0xA97B, 0xA867, 0xA78D, 0xA6EF, 0xA68E, 0xA668, 0xA67F,
        0xA6D2, 0xA761, 0xA82C, 0xA932, 0xAA73, 0xABED, 0xADA0, 0xAF8B, 0xB1AB, 0xB401, 0xB689, 0xB944, 0xBC2D, 0xBF45, 0xC288, 0xC5F5,
        0xC988, 0xCD41, 0xD11C, 0xD516, 0xD92D, 0xDD5E, 0xE1A7, 0xE604, 0xEA73, 0xEEF0, 0xF378, 0xF80A, 0xFCA0, 0x0138, 0x05D0, 0x0A64,
        0x0EF1, 0x1374, 0x17E9, 0x1C4F, 0x20A2, 0x24DE, 0x2902, 0x2D0A, 0x30F4, 0x34BD, 0x3862, 0x3BE1, 0x3F38, 0x4265, 0x4564, 0x4835,
        0x4AD5, 0x4D43, 0x4F7C, 0x5181, 0x534E, 0x54E3, 0x563E, 0x5760, 0x5847, 0x58F2, 0x5962, 0x5995, 0x598C, 0x5946, 0x58C4, 0x5807,
        0x570E, 0x55DA, 0x546D, 0x52C6, 0x50E8, 0x4ED4, 0x4C8A, 0x4A0D, 0x475D, 0x447E, 0x4171, 0x3E37, 0x3AD4, 0x3748, 0x3398, 0x2FC5,
        0x2BD1, 0x27C1, 0x2395, 0x1F51, 0x1AF8, 0x168D, 0x1213, 0x0D8D, 0x08FD, 0x0468, 0xFFD0, 0xFB38, 0xF6A3, 0xF214, 0xED8F, 0xE916,
        0xE4AC, 0xE055, 0xDC13, 0xD7E9, 0xD3DB, 0xCFEA, 0xCC1A, 0xC86C, 0xC4E4, 0xC184, 0xBE4E, 0xBB44, 0xB869, 0xB5BD, 0xB344, 0xB0FF,
        0xAEEF, 0xAD15, 0xAB73, 0xAA0B, 0xA8DC, 0xA7E8, 0xA72F, 0xA6B2, 0xA671, 0xA66D, 0xA6A5, 0xA719, 0xA7CA, 0xA8B5, 0xA9DC, 0xAB3C,
        0xACD6, 0xAEA8, 0xB0B0, 0xB2EE, 0xB560, 0xB804, 0xBAD9, 0xBDDC, 0xC10C, 0xC466, 0xC7E9, 0xCB91, 0xCF5C, 0xD349, 0xD753, 0xDB79,
        0xDFB8, 0xE40C, 0xE873, 0xECEA, 0xF16E, 0xF5FC, 0xFA90, 0xFF28, 0x03C0, 0x0856, 0x0CE7, 0x116E, 0x15EB, 0x1A58, 0x1EB3, 0x22FA,
        0x272A, 0x2B3E, 0x2F36, 0x330E, 0x36C4, 0x3A54, 0x3DBE, 0x40FD, 0x4411, 0x46F7, 0x49AD, 0x4C32, 0x4E83, 0x50A0, 0x5286, 0x5434,
        0x55A9, 0x56E5, 0x57E7, 0x58AD, 0x5937, 0x5985, 0x5997, 0x596D, 0x5906, 0x5863, 0x5785, 0x566B, 0x5518, 0x538B, 0x51C6, 0x4FCA,
        0x4D97, 0x4B31, 0x4898, 0x45CE, 0x42D5, 0x3FAF, 0x3C5E, 0x38E4, 0x3544, 0x3181, 0x2D9B, 0x2997, 0x2577, 0x213E, 0x1CEE, 0x188B,
        0x1418, 0x0F96, 0x0B0B, 0x0677, 0x01E0, 0xFD48, 0xF8B1, 0xF41F, 0xEF95, 0xEB16, 0xE6A5, 0xE245, 0xDDFA, 0xD9C5, 0xD5AA, 0xD1AB,
        0xCDCC, 0xCA0E, 0xC675, 0xC303, 0xBFBA, 0xBC9C, 0xB9AB, 0xB6EA, 0xB45A, 0xB1FD, 0xAFD5, 0xADE3, 0xAC28, 0xAAA5, 0xA95C, 0xA84E,
        0xA77B, 0xA6E3, 0xA687, 0xA668, 0xA685, 0xA6DE, 0xA773, 0xA844, 0xA950, 0xAA97, 0xAC17, 0xADD0, 0xAFC0, 0xB1E6, 0xB441, 0xB6CE,
        0xB98D, 0xBC7C, 0xBF98, 0xC2E0, 0xC650, 0xC9E8, 0xCDA4, 0xD182, 0xD57F, 0xD999, 0xDDCD, 0xE218, 0xE677, 0xEAE7, 0xEF66, 0xF3EF,
        0xF881, 0xFD18, 0x01B0, 0x0647, 0x0ADB, 0x0F67, 0x13E9, 0x185D, 0x1CC1, 0x2111, 0x254C, 0x296D, 0x2D72, 0x3159, 0x351E, 0x38BF,
        0x3C3B, 0x3F8D, 0x42B5, 0x45B0, 0x487C, 0x4B17, 0x4D7F, 0x4FB4, 0x51B2, 0x537A, 0x5509, 0x565F, 0x577A, 0x585B, 0x5900, 0x596A,
        0x5997, 0x5987, 0x593B, 0x58B4, 0x57F0, 0x56F1, 0x55B8, 0x5444, 0x5298, 0x50B4, 0x4E9A, 0x4C4B, 0x49C9, 0x4715, 0x4430, 0x411E,
        0x3DE0, 0x3A79, 0x36EA, 0x3336, 0x2F5F, 0x2B69, 0x2755, 0x2326, 0x1EE1, 0x1A86, 0x1619, 0x119E, 0x0D16, 0x0886, 0x03F0, 0xFF58,
        0xFAC0, 0xF62C, 0xF19E, 0xED19, 0xE8A2, 0xE43A, 0xDFE5, 0xDBA5, 0xD77E, 0xD373, 0xCF85, 0xCBB8, 0xC80E, 0xC48A, 0xC12E, 0xBDFC,
        0xBAF7, 0xB821, 0xB57A, 0xB307, 0xB0C6, 0xAEBC, 0xACE8, 0xAB4C, 0xA9E9, 0xA8C0, 0xA7D2, 0xA71F, 0xA6A9, 0xA66E, 0xA670, 0xA6AE,
        0xA729, 0xA7DF, 0xA8D1, 0xA9FD, 0xAB63, 0xAD03, 0xAEDA, 0xB0E8, 0xB32B, 0xB5A3, 0xB84C, 0xBB25, 0xBE2D, 0xC162, 0xC4C0, 0xC846,
        0xCBF2, 0xCFC2, 0xD3B1, 0xD7BF, 0xDBE7, 0xE028, 0xE47E, 0xE8E7, 0xED60, 0xF1E5, 0xF673, 0xFB08, 0xFFA0, 0x0438, 0x08CE, 0x0D5D,
        0x11E4, 0x165F, 0x1ACB, 0x1F24, 0x2369, 0x2795, 0x2BA8, 0x2F9C, 0x3371, 0x3723, 0x3AAF, 0x3E14, 0x4150, 0x445F, 0x4740, 0x49F2,
        0x4C71, 0x4EBD, 0x50D4, 0x52B4, 0x545D, 0x55CC, 0x5702, 0x57FE, 0x58BE, 0x5942, 0x598A, 0x5996, 0x5965, 0x58F8, 0x584F, 0x576B,
        0x564B, 0x54F2, 0x535F, 0x5194, 0x4F93, 0x4D5B, 0x4AF0, 0x4851, 0x4583, 0x4285, 0x3F5A, 0x3C05, 0x3887, 0x34E4, 0x311C, 0x2D34,
        0x292D, 0x250A, 0x20CE, 0x1C7D, 0x1818, 0x13A2, 0x0F20, 0x0A93, 0x0600, 0x0168, 0xFCD0, 0xF839, 0xF3A8, 0xEF1F, 0xEAA1, 0xE632,
        0xE1D4, 0xDD8B, 0xD958, 0xD540, 0xD144, 0xCD69, 0xC9AF, 0xC619, 0xC2AB, 0xBF66, 0xBC4D, 0xB961, 0xB6A5, 0xB41A, 0xB1C3, 0xAFA0,
        0xADB3, 0xABFE, 0xAA81, 0xA93E, 0xA836, 0xA768, 0xA6D7, 0xA681, 0xA668, 0xA68B, 0xA6EA, 0xA786, 0xA85D, 0xA96F, 0xAABB, 0xAC41,
        0xAE00, 0xAFF5, 0xB221, 0xB481, 0xB714, 0xB9D8, 0xBCCB, 0xBFEC, 0xC338, 0xC6AD, 0xCA48, 0xCE08, 0xD1E9, 0xD5E9, 0xDA06, 0xDE3C,
        0xE289, 0xE6EA, 0xEB5C, 0xEFDC, 0xF466, 0xF8F9, 0xFD90, 0x0228, 0x06BF, 0x0B52, 0x0FDD, 0x145E, 0x18D1, 0x1D33, 0x2181, 0x25B9,
        0x29D7, 0x2DD9, 0x31BD, 0x357E, 0x391C, 0x3C93, 0x3FE2, 0x4305, 0x45FB, 0x48C2, 0x4B58, 0x4DBB, 0x4FEA, 0x51E3, 0x53A5, 0x552E,
        0x567E, 0x5794, 0x586F, 0x590E, 0x5971, 0x5998, 0x5982, 0x5930, 0x58A2, 0x57D9, 0x56D4, 0x5594, 0x541B, 0x5269, 0x5080, 0x4E60,
        0x4C0C, 0x4984, 0x46CB, 0x43E2, 0x40CC, 0x3D89, 0x3A1E, 0x368B, 0x32D3, 0x2EF9, 0x2AFF, 0x26E9, 0x22B8, 0x1E70, 0x1A13, 0x15A5,
        0x1128, 0x0C9F, 0x080E, 0x0378, 0xFEE0, 0xFA48, 0xF5B4, 0xF127, 0xECA4, 0xE82E, 0xE3C8, 0xDF75, 0xDB38, 0xD713, 0xD30A, 0xCF20,
        0xCB57, 0xC7B1, 0xC430, 0xC0D9, 0xBDAB, 0xBAAB, 0xB7D9, 0xB538, 0xB2C9, 0xB08F, 0xAE89, 0xACBB, 0xAB25, 0xA9C8, 0xA8A5, 0xA7BD,
        0xA711, 0xA6A0, 0xA66C, 0xA674, 0xA6B8, 0xA739, 0xA7F5, 0xA8ED, 0xAA1F, 0xAB8B, 0xAD30, 0xAF0D, 0xB121, 0xB36A, 0xB5E6, 0xB894,
        0xBB72, 0xBE7F, 0xC1B8, 0xC51A, 0xC8A5, 0xCC54, 0xD027, 0xD41A, 0xD82A, 0xDC55, 0xE098, 0xE4F1, 0xE95B, 0xEDD5, 0xF25B, 0xF6EB,
        0xFB80, 0x0018, 0x04B0, 0x0945, 0x0DD4, 0x125A, 0x16D3, 0x1B3D, 0x1F95, 0x23D7, 0x2801, 0x2C10, 0x3002, 0x33D3, 0x3781, 0x3B0A,
        0x3E6B, 0x41A2, 0x44AC, 0x4789, 0x4A35, 0x4CAF, 0x4EF6, 0x5107, 0x52E2, 0x5485, 0x55EF, 0x571F, 0x5814, 0x58CE, 0x594C, 0x598E,
        0x5993, 0x595D, 0x58EA, 0x583B, 0x5750, 0x562B, 0x54CC, 0x5333, 0x5163, 0x4F5B, 0x4D1E, 0x4AAD, 0x480A, 0x4537, 0x4234, 0x3F05,
        0x3BAC, 0x382A, 0x3483, 0x30B8, 0x2CCC, 0x28C2, 0x249D, 0x205F, 0x1C0B, 0x17A4, 0x132D, 0x0EAA, 0x0A1C, 0x0588, 0x00F0, 0xFC58,
        0xF7C2, 0xF331, 0xEEA9, 0xEA2D, 0xE5BF, 0xE163, 0xDD1C, 0xD8EC, 0xD4D7, 0xD0DE, 0xCD06, 0xC94F, 0xC5BE, 0xC254, 0xBF13, 0xBBFE,
        0xB917, 0xB660, 0xB3DB, 0xB188, 0xAF6B, 0xAD84, 0xABD4, 0xAA5E, 0xA921, 0xA81E, 0xA757, 0xA6CB, 0xA67C, 0xA669, 0xA692, 0xA6F7,
        0xA799, 0xA876, 0xA98E, 0xAAE1, 0xAC6C, 0xAE30, 0xB02C, 0xB25D, 0xB4C2, 0xB75A, 0xBA23, 0xBD1B, 0xC040, 0xC390, 0xC709, 0xCAA8,
        0xCE6B, 0xD250, 0xD653, 0xDA73, 0xDEAC, 0xE2FB, 0xE75E, 0xEBD1, 0xF052, 0xF4DE, 0xF971, 0xFE08, 0x02A0, 0x0737, 0x0BC9, 0x1053,
        0x14D3, 0x1944, 0x1DA4, 0x21F0, 0x2626, 0x2A41, 0x2E40, 0x3220, 0x35DE, 0x3978, 0x3CEC, 0x4036, 0x4354, 0x4646, 0x4908, 0x4B99,
        0x4DF7, 0x5020, 0x5214, 0x53D0, 0x5553, 0x569D, 0x57AD, 0x5882, 0x591B, 0x5978, 0x5998, 0x597D, 0x5925, 0x5890, 0x57C1, 0x56B6,
        0x5570, 0x53F1, 0x523A, 0x504B, 0x4E26, 0x4BCC, 0x493F, 0x4681, 0x4394, 0x4078, 0x3D32, 0x39C2, 0x362B, 0x3270, 0x2E92, 0x2A96,
        0x267C, 0x2249, 0x1DFF, 0x19A0, 0x1530, 0x10B2, 0x0C28, 0x0797, 0x0300, 0xFE68, 0xF9D0, 0xF53D, 0xF0B1, 0xEC2F, 0xE7BA, 0xE356,
        0xDF05, 0xDACA, 0xD6A9, 0xD2A3, 0xCEBC, 0xCAF6, 0xC753, 0xC3D7, 0xC084, 0xBD5B, 0xBA5F, 0xB792, 0xB4F6, 0xB28D, 0xB057, 0xAE58,
        0xAC8F, 0xAAFF, 0xA9A8, 0xA88B, 0xA7A9, 0xA702, 0xA698, 0xA66A, 0xA678, 0xA6C2, 0xA749, 0xA80B, 0xA909, 0xAA42, 0xABB4, 0xAD5F,
        0xAF41, 0xB15A, 0xB3A8, 0xB62A, 0xB8DD, 0xBBC0, 0xBED1, 0xC20E, 0xC575, 0xC903, 0xCCB7, 0xD08D, 0xD482, 0xD896, 0xDCC3, 0xE109,
        0xE563, 0xE9D0, 0xEE4B, 0xF2D2, 0xF762, 0xFBF8, 0x0090, 0x0528, 0x09BD, 0x0E4B, 0x12CF, 0x1747, 0x1BAF, 0x2005, 0x2445, 0x286C,
        0x2C79, 0x3067, 0x3435, 0x37DF, 0x3B64, 0x3EC1, 0x41F3, 0x44F9, 0x47D1, 0x4A78, 0x4CED, 0x4F2E, 0x513A, 0x530F, 0x54AC, 0x5610,
        0x573A, 0x582A, 0x58DD, 0x5955, 0x5991, 0x5991, 0x5954, 0x58DA, 0x5825, 0x5735, 0x560A, 0x54A4, 0x5306, 0x5130, 0x4F23, 0x4CE1,
        0x4A6B, 0x47C3, 0x44EA, 0x41E3, 0x3EB0, 0x3B52, 0x37CC, 0x3421, 0x3053, 0x2C64, 0x2857, 0x242F, 0x1FEE, 0x1B99, 0x1730, 0x12B8,
        0x0E33, 0x09A5, 0x0510, 0x0078, 0xFBE0, 0xF74A, 0xF2BA, 0xEE33, 0xE9B8, 0xE54C, 0xE0F2, 0xDCAD, 0xD880, 0xD46D, 0xD078, 0xCCA3,
        0xC8F0, 0xC563, 0xC1FD, 0xBEC1, 0xBBB0, 0xB8CE, 0xB61C, 0xB39C, 0xB14F, 0xAF37, 0xAD55, 0xABAB, 0xAA3B, 0xA903, 0xA807, 0xA746,
        0xA6C0, 0xA677, 0xA66A, 0xA699, 0xA705, 0xA7AD, 0xA890, 0xA9AE, 0xAB06, 0xAC98, 0xAE62, 0xB062, 0xB299, 0xB503, 0xB7A0, 0xBA6E,
        0xBD6B, 0xC095, 0xC3E9, 0xC766, 0xCB09, 0xCED0, 0xD2B7, 0xD6BE, 0xDAE0, 0xDF1B, 0xE36D, 0xE7D1, 0xEC46, 0xF0C8, 0xF555, 0xF9E8,
        0xFE80, 0x0318, 0x07AF, 0x0C40, 0x10C9, 0x1547, 0x19B7, 0x1E15, 0x225F, 0x2692, 0x2AAB, 0x2EA7, 0x3284, 0x363E, 0x39D4, 0x3D43,
        0x4089, 0x43A3, 0x4690, 0x494D, 0x4BD9, 0x4E32, 0x5056, 0x5243, 0x53FA, 0x5578, 0x56BC, 0x57C6, 0x5894, 0x5927, 0x597E, 0x5998,
        0x5976, 0x5918, 0x587E, 0x57A8, 0x5697, 0x554C, 0x53C7, 0x520A, 0x5015, 0x4DEB, 0x4B8C, 0x48FA, 0x4637, 0x4345, 0x4025, 0x3CDA,
        0x3966, 0x35CB, 0x320C, 0x2E2C, 0x2A2C, 0x2610, 0x21DA, 0x1D8D, 0x192D, 0x14BB, 0x103C, 0x0BB1, 0x071F, 0x0288, 0xFDF0, 0xF959,
        0xF4C6, 0xF03A, 0xEBBA, 0xE747, 0xE2E4, 0xDE95, 0xDA5D, 0xD63E, 0xD23B, 0xCE57, 0xCA95, 0xC6F6, 0xC37E, 0xC02F, 0xBD0B, 0xBA14,
        0xB74C, 0xB4B5, 0xB251, 0xB021, 0xAE27, 0xAC64, 0xAAD9, 0xA988, 0xA871, 0xA795, 0xA6F5, 0xA690, 0xA668, 0xA67D, 0xA6CD, 0xA75A,
        0xA823, 0xA926, 0xAA65, 0xABDD, 0xAD8D, 0xAF75, 0xB194, 0xB3E7, 0xB66E, 0xB926, 0xBC0E, 0xBF24, 0xC265, 0xC5D0, 0xC962, 0xCD19,
        0xD0F3, 0xD4EC, 0xD902, 0xDD32, 0xE17A, 0xE5D6, 0xEA44, 0xEEC1, 0xF349, 0xF7DA, 0xFC70, 0x0108, 0x05A0, 0x0A34, 0x0EC1, 0x1345,
        0x17BB, 0x1C22, 0x2075, 0x24B3, 0x28D7, 0x2CE1, 0x30CC, 0x3496, 0x383D, 0x3BBE, 0x3F16, 0x4244, 0x4546, 0x4819, 0x4ABB, 0x4D2A,
        0x4F66, 0x516D, 0x533C, 0x54D3, 0x5631, 0x5756, 0x583F, 0x58EC, 0x595E, 0x5994, 0x598D, 0x594A, 0x58CB, 0x5810, 0x5719, 0x55E8,
        0x547D, 0x52D9, 0x50FD, 0x4EEB, 0x4CA3, 0x4A28, 0x477A, 0x449D, 0x4191, 0x3E5A, 0x3AF8, 0x376E, 0x33BF, 0x2FED, 0x2BFB, 0x27EC,
        0x23C1, 0x1F7E, 0x1B26, 0x16BC, 0x1242, 0x0DBC, 0x092D, 0x0498, 0x0000, 0xFB68, 0xF6D3, 0xF244, 0xEDBE, 0xE944, 0xE4DA, 0xE082,
        0xDC3F, 0xD814, 0xD405, 0xD013, 0xCC41, 0xC892, 0xC508, 0xC1A6, 0xBE6F, 0xBB63, 0xB886, 0xB5D8, 0xB35D, 0xB115, 0xAF03, 0xAD27,
        0xAB83, 0xAA18, 0xA8E7, 0xA7F0, 0xA735, 0xA6B6, 0xA673, 0xA66C, 0xA6A2, 0xA714, 0xA7C1, 0xA8AA, 0xA9CF, 0xAB2D, 0xACC4, 0xAE93,
        0xB09A, 0xB2D6, 0xB545, 0xB7E7, 0xBABA, 0xBDBC, 0xC0EA, 0xC442, 0xC7C3, 0xCB6A, 0xCF34, 0xD31F, 0xD729, 0xDB4D, 0xDF8B, 0xE3DE,
        0xE845, 0xECBB, 0xF13F, 0xF5CC, 0xFA60, 0xFEF8, 0x0390, 0x0826, 0x0CB7, 0x113F, 0x15BC, 0x1A2A, 0x1E86, 0x22CE, 0x26FE, 0x2B14,
        0x2F0D, 0x32E7, 0x369E, 0x3A30, 0x3D9B, 0x40DC, 0x43F2, 0x46DA, 0x4992, 0x4C19, 0x4E6C, 0x508B, 0x5273, 0x5423, 0x559B, 0x56DA,
        0x57DD, 0x58A6, 0x5933, 0x5983, 0x5998, 0x5970, 0x590B, 0x586B, 0x578F, 0x5678, 0x5527, 0x539C, 0x51D9, 0x4FDF, 0x4DAF, 0x4B4B,
        0x48B4, 0x45EC, 0x42F5, 0x3FD1, 0x3C82, 0x390A, 0x356B, 0x31A9, 0x2DC5, 0x29C2, 0x25A3, 0x216B, 0x1D1C, 0x18B9, 0x1446, 0x0FC6,
        0x0B3A, 0x06A2, 0x020D, 0xFD7E, 0xF8F8, 0xF47D, 0xF012, 0xEBB9, 0xE774, 0xE347, 0xDF34, 0xDB3E, 0xD767, 0xD3B2, 0xD021, 0xCCB7,
        0xC974, 0xC65C, 0xC370, 0xC0B2, 0xBE23, 0xBBC5, 0xB999, 0xB7A0, 0xB5DC, 0xB44D, 0xB2F3, 0xB1D0, 0xB0E4, 0xB02F, 0xAFB1, 0xAF6A,
        0xAF5A, 0xAF81, 0xAFDE, 0xB070, 0xB138, 0xB233, 0xB361, 0xB4C1, 0xB652, 0xB812, 0xB9FF, 0xBC18, 0xBE5C, 0xC0C8, 0xC35B, 0xC612,
        0xC8EB, 0xCBE5, 0xCEFC, 0xD22F, 0xD57C, 0xD8DF, 0xDC57, 0xDFE1, 0xE37A, 0xE720, 0xEAD0, 0xEE87, 0xF244, 0xF603, 0xF9C3, 0xFD7F,
        0x0135, 0x04E5, 0x088B, 0x0C24, 0x0FAE, 0x1326, 0x168C, 0x19DC, 0x1D14, 0x2032, 0x2335, 0x261A, 0x28E0, 0x2B84, 0x2E07, 0x3065,
        0x329E, 0x34B1, 0x369C, 0x385E, 0x39F6, 0x3B65, 0x3CA8, 0x3DBF, 0x3EAB, 0x3F6B, 0x3FFE, 0x4064, 0x409E, 0x40AC, 0x408E, 0x4044,
        0x3FD0, 0x3F31, 0x3E68, 0x3D77, 0x3C5E, 0x3B1E, 0x39B9, 0x382F, 0x3682, 0x34B4, 0x32C6, 0x30BA, 0x2E90, 0x2C4C, 0x29EE, 0x2778,
        0x24ED, 0x224E, 0x1F9E, 0x1CDD, 0x1A0F, 0x1735, 0x1451, 0x1166, 0x0E75, 0x0B80, 0x088A, 0x0594, 0x02A2, 0xFFB4, 0xFCCC, 0xF9ED,
        0xF718, 0xF44F, 0xF194, 0xEEE9, 0xEC50, 0xE9CA, 0xE758, 0xE4FC, 0xE2B8, 0xE08D, 0xDE7C, 0xDC87, 0xDAAE, 0xD8F2, 0xD755, 0xD5D8,
        0xD47A, 0xD33D, 0xD221, 0xD127, 0xD04F, 0xCF9A, 0xCF06, 0xCE96, 0xCE48, 0xCE1D, 0xCE14, 0xCE2D, 0xCE68, 0xCEC3, 0xCF40, 0xCFDC,
        0xD098, 0xD172, 0xD26A, 0xD37F, 0xD4AF, 0xD5FA, 0xD75E, 0xD8DA, 0xDA6E, 0xDC17, 0xDDD5, 0xDFA5, 0xE187, 0xE379, 0xE57A, 0xE787,
        0xE9A1, 0xEBC4, 0xEDEF, 0xF021, 0xF259, 0xF494, 0xF6D1, 0xF90F, 0xFB4C, 0xFD86, 0xFFBC, 0x01EB, 0x0414, 0x0635, 0x084C, 0x0A58,
        0x0C57, 0x0E49, 0x102C, 0x11FE, 0x13C0, 0x156F, 0x170B, 0x1893, 0x1A06, 0x1B63, 0x1CAA, 0x1DDA, 0x1EF2, 0x1FF2, 0x20D9, 0x21A7,
        0x225C, 0x22F8, 0x237A, 0x23E2, 0x2431, 0x2466, 0x2481, 0x2483, 0x246D, 0x243D, 0x23F6, 0x2396, 0x231F, 0x2292, 0x21EF, 0x2136,
        0x2069, 0x1F88, 0x1E94, 0x1D8E, 0x1C76, 0x1B4F, 0x1A18, 0x18D4, 0x1782, 0x1624, 0x14BB, 0x1348, 0x11CD, 0x104A, 0x0EC1, 0x0D32,
        0x0B9F, 0x0A0A, 0x0872, 0x06DA, 0x0543, 0x03AC, 0x0219, 0x0089, 0xFEFF, 0xFD7A, 0xFBFC, 0xFA85, 0xF917, 0xF7B2, 0xF658, 0xF509,
        0xF3C7, 0xF291, 0xF168, 0xF04D, 0xEF41, 0xEE45, 0xED58, 0xEC7B, 0xEBAE, 0xEAF2, 0xEA48, 0xE9AF, 0xE927, 0xE8B2, 0xE84D, 0xE7FB,
        0xE7BB, 0xE78C, 0xE76F, 0xE763, 0xE768, 0xE77F, 0xE7A6, 0xE7DD, 0xE824, 0xE87B, 0xE8E0, 0xE955, 0xE9D7, 0xEA66, 0xEB02, 0xEBAB,
        0xEC5F, 0xED1E, 0xEDE7, 0xEEB9, 0xEF94, 0xF077, 0xF161, 0xF252, 0xF348, 0xF443, 0xF542, 0xF645, 0xF74A, 0xF850, 0xF958, 0xFA60,
        0xFB67, 0xFC6D, 0xFD72, 0xFE73, 0xFF71, 0x006A, 0x0160, 0x0250, 0x033A, 0x041E, 0x04FB, 0x05D0, 0x069D, 0x0762, 0x081F, 0x08D2,
        0x097B, 0x0A1B, 0x0AB0, 0x0B3B, 0x0BBC, 0x0C31, 0x0C9C, 0x0CFC, 0x0D51, 0x0D9B, 0x0DD9, 0x0E0D, 0x0E35, 0x0E53, 0x0E65, 0x0E6D,
        0x0E6B, 0x0E5F, 0x0E48, 0x0E28, 0x0DFE, 0x0DCB, 0x0D8F, 0x0D4B, 0x0CFF, 0x0CAB, 0x0C50, 0x0BEE, 0x0B86, 0x0B18, 0x0AA4, 0x0A2B,
        0x09AE, 0x092C, 0x08A7, 0x081F, 0x0794, 0x0707, 0x0678, 0x05E9, 0x0558, 0x04C7, 0x0436, 0x03A6, 0x0316, 0x0288, 0x01FC, 0x0172,
        0x00EB, 0x0067, 0xFFE6, 0xFF69, 0xFEEF, 0xFE7A, 0xFE09, 0xFD9C, 0xFD35, 0xFCD2, 0xFC75, 0xFC1D, 0xFBCB, 0xFB7E, 0xFB37, 0xFAF6,
        0xFABB, 0xFA86, 0xFA57, 0xFA2D, 0xFA09, 0xF9EB, 0xF9D3, 0xF9C1, 0xF9B4, 0xF9AC, 0xF9AA, 0xF9AD, 0xF9B4, 0xF9C1, 0xF9D2, 0xF9E7,
        0xFA01, 0xFA1E, 0xFA3F, 0xFA64, 0xFA8B, 0xFAB6, 0xFAE4, 0xFB14, 0xFB46, 0xFB7A, 0xFBAF, 0xFBE6, 0xFC1F, 0xFC58, 0xFC92, 0xFCCC,
        0xFD06, 0xFD41, 0xFD7B, 0xFDB4, 0xFDED, 0xFE25, 0xFE5C, 0xFE92, 0xFEC6, 0xFEF9, 0xFF29, 0xFF58, 0xFF85, 0xFFB0, 0xFFD9, 0x0000,
        0x0023, 0x0045, 0x0064, 0x0081, 0x009B, 0x00B3, 0x00C9, 0x00DC, 0x00EC, 0x00FB, 0x0106, 0x0110, 0x0117, 0x011D, 0x0120, 0x0121,
        0x0120, 0x011E, 0x011A, 0x0115, 0x010E, 0x0106, 0x00FC, 0x00F2, 0x00E7, 0x00DB, 0x00CE, 0x00C1, 0x00B4, 0x00A6, 0x0099, 0x008B,
        0x007E, 0x0070, 0x0063, 0x0057, 0x004B, 0x0040, 0x0035, 0x002B, 0x0022, 0x001A, 0x0013, 0x000D, 0x0008, 0x0004, 0x0001, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFD,
        0xFFFC, 0xFFFA, 0xFFF7, 0xFFF4, 0xFFF1, 0xFFED, 0xFFE9, 0xFFE5, 0xFFE0, 0xFFDA, 0xFFD5, 0xFFCE, 0xFFC8, 0xFFC1, 0xFFB9, 0xFFB2,
        0xFFAA, 0xFFA1, 0xFF99, 0xFF90, 0xFF87, 0xFF7E, 0xFF75, 0xFF6B, 0xFF62, 0xFF59, 0xFF50, 0xFF48, 0xFF3F, 0xFF37, 0xFF30, 0xFF29,
        0xFF22, 0xFF1C, 0xFF17, 0xFF13, 0xFF0F, 0xFF0D, 0xFF0B, 0xFF0B, 0xFF0C, 0xFF0E, 0xFF11, 0xFF15, 0xFF1B, 0xFF22, 0xFF2B, 0xFF35,
        0xFF41, 0xFF4F, 0xFF5E, 0xFF6E, 0xFF80, 0xFF94, 0xFFAA, 0xFFC1, 0xFFD9, 0xFFF4, 0x000E, 0x002C, 0x004A, 0x006A, 0x008C, 0x00AE,
        0x00D2, 0x00F7, 0x011C, 0x0143, 0x016A, 0x0192, 0x01BB, 0x01E4, 0x020D, 0x0236, 0x025F, 0x0288, 0x02B0, 0x02D8, 0x02FF, 0x0326,
        0x034B, 0x036F, 0x0391, 0x03B2, 0x03D1, 0x03EF, 0x040A, 0x0422, 0x0439, 0x044C, 0x045D, 0x046B, 0x0476, 0x047E, 0x0482, 0x0482,
        0x047F, 0x0479, 0x046E, 0x045F, 0x044D, 0x0436, 0x041B, 0x03FC, 0x03D9, 0x03B1, 0x0386, 0x0356, 0x0321, 0x02E9, 0x02AC, 0x026C,
        0x0227, 0x01DF, 0x0192, 0x0143, 0x00F0, 0x0099, 0x003F, 0xFFE4, 0xFF85, 0xFF23, 0xFEBF, 0xFE59, 0xFDF2, 0xFD89, 0xFD1E, 0xFCB3,
        0xFC48, 0xFBDC, 0xFB70, 0xFB05, 0xFA9B, 0xFA32, 0xF9CA, 0xF964, 0xF901, 0xF8A0, 0xF842, 0xF7E7, 0xF790, 0xF73D, 0xF6EE, 0xF6A4,
        0xF660, 0xF620, 0xF5E7, 0xF5B3, 0xF586, 0xF55F, 0xF540, 0xF527, 0xF516, 0xF50C, 0xF50B, 0xF511, 0xF520, 0xF537, 0xF556, 0xF57E,
        0xF5AE, 0xF5E8, 0xF62A, 0xF674, 0xF6C7, 0xF723, 0xF788, 0xF7F4, 0xF869, 0xF8E6, 0xF96B, 0xF9F8, 0xFA8C, 0xFB27, 0xFBC9, 0xFC72,
        0xFD21, 0xFDD5, 0xFE8F, 0xFF4D, 0x0010, 0x00D7, 0x01A1, 0x026F, 0x033F, 0x0411, 0x04E4, 0x05B8, 0x068C, 0x075F, 0x0832, 0x0902,
        0x09D0, 0x0A9B, 0x0B63, 0x0C26, 0x0CE4, 0x0D9D, 0x0E4F, 0x0EFB, 0x0F9F, 0x103B, 0x10CE, 0x1159, 0x11D9, 0x124F, 0x12BA, 0x1319,
        0x136D, 0x13B5, 0x13F0, 0x141D, 0x143E, 0x1450, 0x1454, 0x144A, 0x1432, 0x140A, 0x13D4, 0x138F, 0x133B, 0x12D8, 0x1265, 0x11E4,
        0x1154, 0x10B6, 0x1008, 0x0F4D, 0x0E84, 0x0DAD, 0x0CC9, 0x0BD8, 0x0ADB, 0x09D3, 0x08BF, 0x07A0, 0x0677, 0x0546, 0x040B, 0x02C9,
        0x017F, 0x0030, 0xFEDC, 0xFD82, 0xFC25, 0xFAC5, 0xF964, 0xF801, 0xF69F, 0xF53E, 0xF3DF, 0xF284, 0xF12C, 0xEFDA, 0xEE8E, 0xED49,
        0xEC0D, 0xEAD9, 0xE9B0, 0xE893, 0xE781, 0xE67D, 0xE586, 0xE49F, 0xE3C7, 0xE300, 0xE24B, 0xE1A7, 0xE117, 0xE09A, 0xE031, 0xDFDC,
        0xDF9D, 0xDF74, 0xDF61, 0xDF64, 0xDF7E, 0xDFAF, 0xDFF7, 0xE057, 0xE0CE, 0xE15C, 0xE202, 0xE2BE, 0xE392, 0xE47C, 0xE57C, 0xE692,
        0xE7BE, 0xE8FE, 0xEA53, 0xEBBB, 0xED36, 0xEEC3, 0xF061, 0xF210, 0xF3CD, 0xF599, 0xF772, 0xF957, 0xFB47, 0xFD40, 0xFF42, 0x014A,
        0x0358, 0x056B, 0x0780, 0x0997, 0x0BAF, 0x0DC4, 0x0FD7, 0x11E5, 0x13EE, 0x15EF, 0x17E7, 0x19D4, 0x1BB6, 0x1D8B, 0x1F50, 0x2106,
        0x22AA, 0x243B, 0x25B7, 0x271E, 0x286F, 0x29A7, 0x2AC6, 0x2BCB, 0x2CB5, 0x2D83, 0x2E34, 0x2EC7, 0x2F3B, 0x2F90, 0x2FC5, 0x2FDA,
        0x2FCE, 0x2FA0, 0x2F52, 0x2EE2, 0x2E50, 0x2D9D, 0x2CC8, 0x2BD2, 0x2ABB, 0x2983, 0x282B, 0x26B4, 0x251E, 0x236A, 0x2198, 0x1FAA,
        0x1DA2, 0x1B7F, 0x1943, 0x16EF, 0x1485, 0x1207, 0x0F75, 0x0CD1, 0x0A1E, 0x075C, 0x048D, 0x01B4, 0xFED2, 0xFBE9, 0xF8FA, 0xF609,
        0xF317, 0xF025, 0xED37, 0xEA4D, 0xE76B, 0xE492, 0xE1C4, 0xDF04, 0xDC53, 0xD9B4, 0xD728, 0xD4B2, 0xD253, 0xD00D, 0xCDE2, 0xCBD4,
        0xC9E4, 0xC815, 0xC668, 0xC4DD, 0xC378, 0xC238, 0xC120, 0xC030, 0xBF6A, 0xBECE, 0xBE5D, 0xBE18, 0xBDFF, 0xBE14, 0xBE56, 0xBEC6,
        0xBF64, 0xC02F, 0xC129, 0xC24F, 0xC3A3, 0xC524, 0xC6D0, 0xC8A8, 0xCAAB, 0xCCD7, 0xCF2B, 0xD1A6, 0xD447, 0xD70C, 0xD9F4, 0xDCFD,
        0xE025, 0xE36B, 0xE6CC, 0xEA46, 0xEDD8, 0xF17E, 0xF537, 0xF8FF, 0xFCD6, 0x00B7, 0x04A1, 0x0891, 0x0C85, 0x1079, 0x146B, 0x1858,
        0x1C3D, 0x2018, 0x23E6, 0x27A4, 0x2B4F, 0x2EE5, 0x3264, 0x35C7, 0x390E, 0x3C34, 0x3F39, 0x4219, 0x44D3, 0x4763, 0x49C8, 0x4C00,
        0x4E0A, 0x4FE2, 0x5187, 0x52F9, 0x5435, 0x553A, 0x5607, 0x569B, 0x56F5, 0x5715, 0x56F9, 0x56A1, 0x560E, 0x553E, 0x5432, 0x52EB,
        0x5111, 0x4F01, 0x4CBC, 0x4A43, 0x4797, 0x44BC, 0x41B2, 0x3E7C, 0x3B1C, 0x3794, 0x33E6, 0x3016, 0x2C25, 0x2817, 0x23ED, 0x1FAB,
        0x1B54, 0x16EA, 0x1271, 0x0DEC, 0x095D, 0x04C8, 0x0030, 0xFB98, 0xF703, 0xF273, 0xEDED, 0xE973, 0xE508, 0xE0AF, 0xDC6B, 0xD83F,
        0xD42F, 0xD03B, 0xCC68, 0xC8B8, 0xC52C, 0xC1C9, 0xBE8F, 0xBB82, 0xB8A3, 0xB5F3, 0xB376, 0xB12C, 0xAF18, 0xAD3A, 0xAB93, 0xAA26,
        0xA8F2, 0xA7F9, 0xA73C, 0xA6BA, 0xA674, 0xA66B, 0xA69E, 0xA70E, 0xA7B9, 0xA8A0, 0xA9C2, 0xAB1D, 0xACB2, 0xAE7F, 0xB084, 0xB2BD,
        0xB52B, 0xB7CB, 0xBA9C, 0xBD9B, 0xC0C8, 0xC41F, 0xC79E, 0xCB43, 0xCF0C, 0xD2F6, 0xD6FE, 0xDB22, 0xDF5E, 0xE3B1, 0xE817, 0xEC8C,
        0xF10F, 0xF59C, 0xFA30, 0xFEC8, 0x0360, 0x07F6, 0x0C88, 0x1110, 0x158D, 0x19FC, 0x1E59, 0x22A2, 0x26D3, 0x2AEA, 0x2EE4, 0x32BF,
        0x3678, 0x3A0B, 0x3D78, 0x40BB, 0x43D3, 0x46BC, 0x4977, 0x4BFF, 0x4E55, 0x5075, 0x5260, 0x5413, 0x558D, 0x56CE, 0x57D4, 0x589F,
        0x592E, 0x5981, 0x5998, 0x5972, 0x5911, 0x5873, 0x5799, 0x5685, 0x5536, 0x53AE, 0x51ED, 0x4FF5, 0x4DC7, 0x4B65, 0x48D0, 0x460A,
        0x4315, 0x3FF2, 0x3CA5, 0x392F, 0x3592, 0x31D1, 0x2DEE, 0x29EC, 0x25CF, 0x2197, 0x1D49, 0x18E8, 0x1475, 0x0FF5, 0x0B6A, 0x06D7,
        0x0240, 0xFDA8, 0xF911, 0xF47E, 0xEFF3, 0xEB73, 0xE701, 0xE2A0, 0xDE53, 0xDA1C, 0xD5FE, 0xD1FD, 0xCE1B, 0xCA5B, 0xC6BF, 0xC349,
        0xBFFD, 0xBCDB, 0xB9E7, 0xB722, 0xB48E, 0xB22D, 0xB000, 0xAE09, 0xAC4A, 0xAAC3, 0xA975, 0xA862, 0xA78A, 0xA6ED, 0xA68C, 0xA668,
        0xA680, 0xA6D4, 0xA765, 0xA831, 0xA938, 0xAA7A, 0xABF5, 0xADAA, 0xAF95, 0xB1B7, 0xB40D, 0xB697, 0xB952, 0xBC3D, 0xBF56, 0xC29A,
        0xC607, 0xC99C, 0xCD55, 0xD130, 0xD52B, 0xD943, 0xDD74, 0xE1BE, 0xE61B, 0xEA8A, 0xEF07, 0xF390, 0xF821, 0xFCB8, 0x0150, 0x05E8,
        0x0A7C, 0x0F08, 0x138B, 0x1801, 0x1C66, 0x20B8, 0x24F4, 0x2917, 0x2D1F, 0x3108, 0x34D0, 0x3875, 0x3BF3, 0x3F49, 0x4275, 0x4573,
        0x4843, 0x4AE2, 0x4D4F, 0x4F88, 0x518B, 0x5357, 0x54EA, 0x5645, 0x5765, 0x584B, 0x58F5, 0x5963, 0x5995, 0x598B, 0x5944, 0x58C1,
        0x5802, 0x5708, 0x55D3, 0x5465, 0x52BD, 0x50DE, 0x4EC8, 0x4C7D, 0x49FF, 0x474F, 0x446F, 0x4160, 0x3E26, 0x3AC1, 0x3735, 0x3384,
        0x2FB0, 0x2BBC, 0x27AB, 0x237F, 0x1F3B, 0x1AE1, 0x1676, 0x11FC, 0x0D75, 0x08E6, 0x0450, 0xFFB8, 0xFB20, 0xF68B, 0xF1FC, 0xED77,
        0xE8FE, 0xE495, 0xE03E, 0xDBFD, 0xD7D4, 0xD3C6, 0xCFD6, 0xCC06, 0xC859, 0xC4D2, 0xC173, 0xBE3E, 0xBB35, 0xB85A, 0xB5B0, 0xB338,
        0xB0F3, 0xAEE4, 0xAD0C, 0xAB6B, 0xAA04, 0xA8D6, 0xA7E3, 0xA72C, 0xA6B0, 0xA671, 0xA66E, 0xA6A7, 0xA71C, 0xA7CE, 0xA8BB, 0xA9E2,
        0xAB44, 0xACDF, 0xAEB2, 0xB0BB, 0xB2FA, 0xB56D, 0xB812, 0xBAE8, 0xBDEC, 0xC11D, 0xC478, 0xC7FB, 0xCBA4, 0xCF71, 0xD35E, 0xD769,
        0xDB8F, 0xDFCE, 0xE423, 0xE88A, 0xED02, 0xF186, 0xF614, 0xFAA8, 0xFF40, 0x03D8, 0x086E, 0x0CFE, 0x1186, 0x1602, 0x1A6F, 0x1ECA,
        0x2310, 0x273F, 0x2B54, 0x2F4B, 0x3322, 0x36D7, 0x3A67, 0x3DCF, 0x410E, 0x4421, 0x4706, 0x49BB, 0x4C3F, 0x4E8F, 0x50AA, 0x528F,
        0x543C, 0x55B1, 0x56EB, 0x57EB, 0x58B0, 0x5939, 0x5986, 0x5997, 0x596B, 0x5903, 0x585F, 0x5780, 0x5665, 0x5510, 0x5382, 0x51BC,
        0x4FBF, 0x4D8B, 0x4B24, 0x488A, 0x45BF, 0x42C5, 0x3F9E, 0x3C4C, 0x38D2, 0x3531, 0x316D, 0x2D87, 0x2982, 0x2562, 0x2128, 0x1CD8,
        0x1874, 0x1400, 0x0F7F, 0x0AF3, 0x065F, 0x01C8, 0xFD30, 0xF899, 0xF407, 0xEF7D, 0xEAFF, 0xE68E, 0xE22F, 0xDDE3, 0xD9AF, 0xD594,
        0xD197, 0xCDB8, 0xC9FB, 0xC663, 0xC2F1, 0xBFA9, 0xBC8C, 0xB99C, 0xB6DC, 0xB44D, 0xB1F2, 0xAFCA, 0xADD9, 0xAC1F, 0xAA9E, 0xA956,
        0xA849, 0xA777, 0xA6E0, 0xA686, 0xA668, 0xA686, 0xA6E0, 0xA777, 0xA849, 0xA956, 0xAA9E, 0xAC1F, 0xADD9, 0xAFCA, 0xB1F2, 0xB44D,
        0xB6DC, 0xB99C, 0xBC8C, 0xBFA9, 0xC2F1, 0xC663, 0xC9FB, 0xCDB8, 0xD197, 0xD594, 0xD9AF, 0xDDE3, 0xE22F, 0xE68E, 0xEAFF, 0xEF7D,
        0xF407, 0xF899, 0xFD30, 0x01C8, 0x065F, 0x0AF3, 0x0F7F, 0x1400, 0x1874, 0x1CD8, 0x2128, 0x2562, 0x2982, 0x2D87, 0x316D, 0x3531,
        0x38D2, 0x3C4C, 0x3F9E, 0x42C5, 0x45BF, 0x488A, 0x4B24, 0x4D8B, 0x4FBF, 0x51BC, 0x5382, 0x5510, 0x5665, 0x5780, 0x585F, 0x5903,
        0x596B, 0x5997, 0x5986, 0x5939, 0x58B0, 0x57EB, 0x56EB, 0x55B1, 0x543C, 0x528F, 0x50AA, 0x4E8F, 0x4C3F, 0x49BB, 0x4706, 0x4421,
        0x410E, 0x3DCF, 0x3A67, 0x36D7, 0x3322, 0x2F4B, 0x2B54, 0x273F, 0x2310, 0x1ECA, 0x1A6F, 0x1602, 0x1186, 0x0CFE, 0x086E, 0x03D8,
        0xFF40, 0xFAA8, 0xF614, 0xF186, 0xED02, 0xE88A, 0xE423, 0xDFCE, 0xDB8F, 0xD769, 0xD35E, 0xCF71, 0xCBA4, 0xC7FB, 0xC478, 0xC11D,
        0xBDEC, 0xBAE8, 0xB812, 0xB56D, 0xB2FA, 0xB0BB, 0xAEB2, 0xACDF, 0xAB44, 0xA9E2, 0xA8BB, 0xA7CE, 0xA71C, 0xA6A7, 0xA66E, 0xA671,
        0xA6B0, 0xA72C, 0xA7E3, 0xA8D6, 0xAA04, 0xAB6B, 0xAD0C, 0xAEE4, 0xB0F3, 0xB338, 0xB5B0, 0xB85A, 0xBB35, 0xBE3E, 0xC173, 0xC4D2,
        0xC859, 0xCC06, 0xCFD6, 0xD3C6, 0xD7D4, 0xDBFD, 0xE03E, 0xE495, 0xE8FE, 0xED77, 0xF1FC, 0xF68B, 0xFB20, 0xFFB8, 0x0450, 0x08E6,
        0x0D75, 0x11FC, 0x1676, 0x1AE1, 0x1F3B, 0x237F, 0x27AB, 0x2BBC, 0x2FB0, 0x3384, 0x3735, 0x3AC1, 0x3E26, 0x4160, 0x446F, 0x474F,
        0x49FF, 0x4C7D, 0x4EC8, 0x50DE, 0x52BD, 0x5465, 0x55D3, 0x5708, 0x5802, 0x58C1, 0x5944, 0x598B, 0x5995, 0x5963, 0x58F5, 0x584B,
        0x5765, 0x5645, 0x54EA, 0x5357, 0x518B, 0x4F88, 0x4D4F, 0x4AE2, 0x4843, 0x4573, 0x4275, 0x3F49, 0x3BF3, 0x3875, 0x34D0, 0x3108,
        0x2D1F, 0x2917, 0x24F4, 0x20B8, 0x1C66, 0x1801, 0x138B, 0x0F08, 0x0A7C, 0x05E8, 0x0150, 0xFCB8, 0xF821, 0xF390, 0xEF07, 0xEA8A,
        0xE61B, 0xE1BE, 0xDD74, 0xD943, 0xD52B, 0xD130, 0xCD55, 0xC99C, 0xC607, 0xC29A, 0xBF56, 0xBC3D, 0xB952, 0xB697, 0xB40D, 0xB1B7,
        0xAF95, 0xADAA, 0xABF5, 0xAA7A, 0xA938, 0xA831, 0xA765, 0xA6D4, 0xA680, 0xA668, 0xA68C, 0xA6ED, 0xA78A, 0xA862, 0xA975, 0xAAC3,
        0xAC4A, 0xAE09, 0xB000, 0xB22D, 0xB48E, 0xB722, 0xB9E7, 0xBCDB, 0xBFFD, 0xC349, 0xC6BF, 0xCA5B, 0xCE1B, 0xD1FD, 0xD5FE, 0xDA1C,
        0xDE53, 0xE2A0, 0xE701, 0xEB73, 0xEFF3, 0xF47E, 0xF911, 0xFDA8, 0x0240, 0x06D7, 0x0B6A, 0x0FF5, 0x1475, 0x18E8, 0x1D49, 0x2197,
        0x25CF, 0x29EC, 0x2DEE, 0x31D1, 0x3592, 0x392F, 0x3CA5, 0x3FF2, 0x4315, 0x460A, 0x48D0, 0x4B65, 0x4DC7, 0x4FF5, 0x51ED, 0x53AE,
        0x5536, 0x5685, 0x5799, 0x5873, 0x5911, 0x5972, 0x5998, 0x5981, 0x592E, 0x589F, 0x57D4, 0x56CE, 0x558D, 0x5413, 0x5260, 0x5075,
        0x4E55, 0x4BFF, 0x4977, 0x46BC, 0x43D3, 0x40BB, 0x3D78, 0x3A0B, 0x3678, 0x32BF, 0x2EE4, 0x2AEA, 0x26D3, 0x22A2, 0x1E59, 0x19FC,
        0x158D, 0x1110, 0x0C88, 0x07F6, 0x0360, 0xFEC8, 0xFA30, 0xF59C, 0xF10F, 0xEC8C, 0xE817, 0xE3B1, 0xDF5E, 0xDB22, 0xD6FE, 0xD2F6,
        0xCF0C, 0xCB43, 0xC79E, 0xC41F, 0xC0C8, 0xBD9B, 0xBA9C, 0xB7CB, 0xB52B, 0xB2BD, 0xB084, 0xAE7F, 0xACB2, 0xAB1D, 0xA9C2, 0xA8A0,
        0xA7B9, 0xA70E, 0xA69E, 0xA66B, 0xA674, 0xA6BA, 0xA73C, 0xA7F9, 0xA8F2, 0xAA26, 0xAB93, 0xAD3A, 0xAF18, 0xB12C, 0xB376, 0xB5F3,
        0xB8A3, 0xBB82, 0xBE8F, 0xC1C9, 0xC52C, 0xC8B8, 0xCC68, 0xD03B, 0xD42F, 0xD83F, 0xDC6B, 0xE0AF, 0xE508, 0xE973, 0xEDED, 0xF273,
        0xF703, 0xFB98, 0x0030, 0x04C8, 0x095D, 0x0DEC, 0x1271, 0x16EA, 0x1B54, 0x1FAB, 0x23ED, 0x2817, 0x2C25, 0x3016, 0x33E6, 0x3794,
        0x3B1C, 0x3E7C, 0x41B2, 0x44BC, 0x4797, 0x4A43, 0x4CBC, 0x4F01, 0x5111, 0x52EB, 0x548D, 0x55F5, 0x5724, 0x5818, 0x58D1, 0x594E,
        0x598F, 0x5993, 0x595B, 0x58E7, 0x5836, 0x574B, 0x5624, 0x54C4, 0x532A, 0x5158, 0x4F50, 0x4D12, 0x4AA0, 0x47FC, 0x4527, 0x4224,
        0x3EF4, 0x3B9A, 0x3817, 0x346F, 0x30A4, 0x2CB7, 0x28AD, 0x2487, 0x2048, 0x1BF4, 0x178D, 0x1316, 0x0E92, 0x0A04, 0x0570, 0x00D8,
        0xFC40, 0xF7AA, 0xF319, 0xEE92, 0xEA15, 0xE5A8, 0xE14D, 0xDD06, 0xD8D6, 0xD4C2, 0xD0CA, 0xCCF2, 0xC93C, 0xC5AC, 0xC242, 0xBF03,
        0xBBEF, 0xB909, 0xB653, 0xB3CE, 0xB17D, 0xAF60, 0xAD7A, 0xABCC, 0xAA57, 0xA91B, 0xA819, 0xA753, 0xA6C9, 0xA67B, 0xA669, 0xA693,
        0xA6FA, 0xA79D, 0xA87B, 0xA995, 0xAAE8, 0xAC75, 0xAE3A, 0xB036, 0xB269, 0xB4CF, 0xB768, 0xBA32, 0xBD2B, 0xC051, 0xC3A2, 0xC71C,
        0xCABC, 0xCE7F, 0xD265, 0xD669, 0xDA89, 0xDEC2, 0xE312, 0xE775, 0xEBE8, 0xF06A, 0xF4F5, 0xF989, 0xFE20, 0x02B8, 0x074F, 0x0BE1,
        0x106B, 0x14EA, 0x195B, 0x1DBB, 0x2206, 0x263B, 0x2A56, 0x2E55, 0x3234, 0x35F2, 0x398B, 0x3CFD, 0x4046, 0x4364, 0x4655, 0x4916,
        0x4BA6, 0x4E03, 0x502B, 0x521D, 0x53D8, 0x555B, 0x56A4, 0x57B2, 0x5885, 0x591D, 0x5979, 0x5998, 0x597B, 0x5922, 0x588D, 0x57BC,
        0x56B0, 0x5569, 0x53E9, 0x5230, 0x5040, 0x4E1A, 0x4BBF, 0x4932, 0x4673, 0x4384, 0x4068, 0x3D20, 0x39B0, 0x3618, 0x325C, 0x2E7E,
        0x2A81, 0x2667, 0x2233, 0x1DE8, 0x1989, 0x1519, 0x109A, 0x0C11, 0x077F, 0x02E8, 0xFE50, 0xF9B9, 0xF525, 0xF099, 0xEC17, 0xE7A3,
        0xE33F, 0xDEEF, 0xDAB4, 0xD693, 0xD28E, 0xCEA7, 0xCAE2, 0xC741, 0xC3C5, 0xC073, 0xBD4B, 0xBA50, 0xB784, 0xB4E9, 0xB281, 0xB04C,
        0xAE4E, 0xAC86, 0xAAF7, 0xA9A1, 0xA886, 0xA7A5, 0xA700, 0xA696, 0xA669, 0xA679, 0xA6C5, 0xA74C, 0xA810, 0xA90F, 0xAA48, 0xABBC,
        0xAD68, 0xAF4C, 0xB166, 0xB3B5, 0xB637, 0xB8EB, 0xBBD0, 0xBEE2, 0xC220, 0xC587, 0xC916, 0xCCCA, 0xD0A1, 0xD497, 0xD8AB, 0xDCDA,
        0xE11F, 0xE57A, 0xE9E7, 0xEE62, 0xF2EA, 0xF77A, 0xFC10, 0x00A8, 0x0540, 0x09D4, 0x0E62, 0x12E7, 0x175E, 0x1BC6, 0x201B, 0x245B,
        0x2882, 0x2C8D, 0x307B, 0x3448, 0x37F2, 0x3B76, 0x3ED2, 0x4204, 0x4509, 0x47DF, 0x4A86, 0x4CF9, 0x4F3A, 0x5144, 0x5318, 0x54B4,
        0x5617, 0x5740, 0x582E, 0x58E1, 0x5957, 0x5992, 0x5990, 0x5952, 0x58D7, 0x5821, 0x572F, 0x5603, 0x549D, 0x52FD, 0x5126, 0x4F18,
        0x4CD5, 0x4A5D, 0x47B4, 0x44DB, 0x41D3, 0x3E9E, 0x3B40, 0x37BA, 0x340E, 0x303E, 0x2C4F, 0x2841, 0x2419, 0x1FD8, 0x1B82, 0x1719,
        0x12A0, 0x0E1B, 0x098D, 0x04F8, 0x0060, 0xFBC8, 0xF732, 0xF2A3, 0xEE1C, 0xE9A1, 0xE535, 0xE0DC, 0xDC97, 0xD86B, 0xD458, 0xD064,
        0xCC8F, 0xC8DD, 0xC551, 0xC1EC, 0xBEB0, 0xBBA1, 0xB8C0, 0xB60E, 0xB38F, 0xB143, 0xAF2C, 0xAD4C, 0xABA3, 0xAA34, 0xA8FE, 0xA802,
        0xA742, 0xA6BE, 0xA676, 0xA66A, 0xA69B, 0xA708, 0xA7B1, 0xA895, 0xA9B5, 0xAB0E, 0xACA1, 0xAE6C, 0xB06D, 0xB2A5, 0xB510, 0xB7AF,
        0xBA7D, 0xBD7B, 0xC0A6, 0xC3FB, 0xC779, 0xCB1C, 0xCEE4, 0xD2CC, 0xD6D3, 0xDAF6, 0xDF32, 0xE383, 0xE7E8, 0xEC5E, 0xF0E0, 0xF56D,
        0xFA00, 0xFE98, 0x0330, 0x07C7, 0x0C58, 0x10E1, 0x155F, 0x19CE, 0x1E2C, 0x2275, 0x26A8, 0x2AC0, 0x2EBC, 0x3297, 0x3651, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2F22, 0x32FA, 0x36B1, 0x3A42, 0x3DAC, 0x40ED, 0x4402, 0x46E9, 0x49A0, 0x4C25, 0x4E78, 0x5095, 0x527C, 0x542C, 0x55A2,
        0x56DF, 0x57E2, 0x58A9, 0x5935, 0x5984, 0x5997, 0x596E, 0x5909, 0x5867, 0x578A, 0x5672, 0x551F, 0x5394, 0x51D0, 0x4FD4, 0x4DA3,
        0x4B3E, 0x48A6, 0x45DD, 0x42E5, 0x3FC0, 0x3C70, 0x38F7, 0x3558, 0x3195, 0x2DB0, 0x29AD, 0x258D, 0x2154, 0x1D05, 0x18A2, 0x142F,
        0x0FAE, 0x0B22, 0x068F, 0x01F8, 0xFD60, 0xF8C9, 0xF437, 0xEFAD, 0xEB2D, 0xE6BC, 0xE25C, 0xDE10, 0xD9DA, 0xD5BF, 0xD1C0, 0xCDE0,
        0xCA22, 0xC688, 0xC314, 0xBFCA, 0xBCAC, 0xB9BA, 0xB6F8, 0xB467, 0xB209, 0xAFE0, 0xADEC, 0xAC30, 0xAAAD, 0xA963, 0xA853, 0xA77E,
        0xA6E5, 0xA688, 0xA668, 0xA683, 0xA6DB, 0xA770, 0xA83F, 0xA94A, 0xAA90, 0xAC0F, 0xADC6, 0xAFB5, 0xB1DA, 0xB434, 0xB6C1, 0xB97F,
        0xBC6C, 0xBF88, 0xC2CE, 0xC63E, 0xC9D5, 0xCD90, 0xD16E, 0xD56A, 0xD984, 0xDDB7, 0xE201, 0xE660, 0xEAD0, 0xEF4E, 0xF3D8, 0xF869,
        0xFD00, 0x0198, 0x0630, 0x0AC3, 0x0F4F, 0x13D1, 0x1846, 0x1CAA, 0x20FB, 0x2536, 0x2957, 0x2D5D, 0x3144, 0x350A, 0x38AD, 0x3C29,
        0x3F7C, 0x42A5, 0x45A1, 0x486E, 0x4B0A, 0x4D73, 0x4FA9, 0x51A8, 0x5371, 0x5501, 0x5658, 0x5775, 0x5857, 0x58FE, 0x5968, 0x5996,
        0x5988, 0x593E, 0x58B7, 0x57F5, 0x56F7, 0x55BE, 0x544C, 0x52A1, 0x50BF, 0x4EA6, 0x4C58, 0x49D6, 0x4723, 0x4440, 0x412F, 0x3DF2,
        0x3A8B, 0x36FD, 0x3349, 0x2F73, 0x2B7E, 0x276A, 0x233D, 0x1EF7, 0x1A9D, 0x1630, 0x11B5, 0x0D2E, 0x089E, 0x0408, 0xFF70, 0xFAD8,
        0xF643, 0xF1B5, 0xED31, 0xE8B9, 0xE451, 0xDFFB, 0xDBBB, 0xD794, 0xD387, 0xCF99, 0xCBCB, 0xC821, 0xC49C, 0xC13F, 0xBE0D, 0xBB07,
        0xB82F, 0xB588, 0xB313, 0xB0D2, 0xAEC6, 0xACF1, 0xAB54, 0xA9F0, 0xA8C6, 0xA7D6, 0xA723, 0xA6AB, 0xA66F, 0xA66F, 0xA6AC, 0xA726,
        0xA7DB, 0xA8CB, 0xA9F6, 0xAB5C, 0xACFA, 0xAED0, 0xB0DD, 0xB31F, 0xB595, 0xB83D, 0xBB16, 0xBE1D, 0xC150, 0xC4AE, 0xC834, 0xCBDF,
        0xCFAD, 0xD39C, 0xD7A9, 0xDBD1, 0xE012, 0xE467, 0xE8D0, 0xED48, 0xF1CD, 0xF65B, 0xFAF0, 0xFF88, 0x0420, 0x08B6, 0x0D46, 0x11CD,
        0x1648, 0x1AB4, 0x1F0E, 0x2353, 0x2780, 0x2B93, 0x2F88, 0x335D, 0x3710, 0x3A9D, 0x3E03, 0x413F, 0x4450, 0x4732, 0x49E4, 0x4C64,
        0x4EB1, 0x50C9, 0x52AB, 0x5455, 0x55C5, 0x56FD, 0x57F9, 0x58BA, 0x5940, 0x5989, 0x5996, 0x5967, 0x58FB, 0x5853, 0x5770, 0x5652,
        0x54FA, 0x5368, 0x519E, 0x4F9E, 0x4D67, 0x4AFD, 0x4860, 0x4592, 0x4295, 0x3F6B, 0x3C17, 0x389A, 0x34F7, 0x3130, 0x2D49, 0x2942,
        0x2520, 0x20E5, 0x1C93, 0x182F, 0x13BA, 0x0F38, 0x0AAB, 0x0618, 0x0180, 0xFCE8, 0xF851, 0xF3C0, 0xEF37, 0xEAB9, 0xE649, 0xE1EB,
        0xDDA1, 0xD96E, 0xD555, 0xD159, 0xCD7C, 0xC9C2, 0xC62C, 0xC2BD, 0xBF77, 0xBC5D, 0xB970, 0xB6B3, 0xB427, 0xB1CE, 0xAFAA, 0xADBD,
        0xAC06, 0xAA88, 0xA944, 0xA83A, 0xA76C, 0xA6D9, 0xA682, 0xA668, 0xA68A, 0xA6E8, 0xA782, 0xA858, 0xA969, 0xAAB4, 0xAC39, 0xADF6,
        0xAFEB, 0xB215, 0xB474, 0xB706, 0xB9C9, 0xBCBB, 0xBFDB, 0xC326, 0xC69A, 0xCA35, 0xCDF4, 0xD1D4, 0xD5D4, 0xD9F0, 0xDE26, 0xE273,
        0xE6D3, 0xEB45, 0xEFC4, 0xF44F, 0xF8E1, 0xFD78, 0x0210, 0x06A7, 0x0B3A, 0x0FC6, 0x1446, 0x18B9, 0x1D1C, 0x216B, 0x25A3, 0x29C2,
        0x2DC5, 0x31A9, 0x356B, 0x390A, 0x3C82, 0x3FD1, 0x42F5, 0x45EC, 0x48B4, 0x4B4B, 0x4DAF, 0x4FDF, 0x51D9, 0x539C, 0x5527, 0x5678,
        0x578F, 0x586B, 0x590B, 0x5970, 0x5998, 0x5983, 0x5933, 0x58A6, 0x57DD, 0x56DA, 0x559B, 0x5423, 0x5273, 0x508B, 0x4E6C, 0x4C19,
        0x4992, 0x46DA, 0x43F2, 0x40DC, 0x3D9B, 0x3A30, 0x369E, 0x32E7, 0x2F0D, 0x2B14, 0x26FE, 0x22CE, 0x1E86, 0x1A2A, 0x15BC, 0x113F,
        0x0CB7, 0x0826, 0x0390, 0xFEF8, 0xFA60, 0xF5CC, 0xF13F, 0xECBB, 0xE845, 0xE3DE, 0xDF8B, 0xDB4D, 0xD729, 0xD31F, 0xCF34, 0xCB6A,
        0xC7C3, 0xC442, 0xC0EA, 0xBDBC, 0xBABA, 0xB7E7, 0xB545, 0xB2D6, 0xB09A, 0xAE93, 0xACC4, 0xAB2D, 0xA9CF, 0xA8AA, 0xA7C1, 0xA714,
        0xA6A2, 0xA66C, 0xA673, 0xA6B6, 0xA735, 0xA7F0, 0xA8E7, 0xAA18, 0xAB83, 0xAD27, 0xAF03, 0xB115, 0xB35D, 0xB5D8, 0xB886, 0xBB63,
        0xBE6F, 0xC1A6, 0xC508, 0xC892, 0xCC41, 0xD013, 0xD405, 0xD814, 0xDC3F, 0xE082, 0xE4DA, 0xE944, 0xEDBE, 0xF244, 0xF6D3, 0xFB68,
        0x0000, 0x0498, 0x092D, 0x0DBC, 0x1242, 0x16BC, 0x1B26, 0x1F7E, 0x23C1, 0x27EC, 0x2BFB, 0x2FED, 0x33BF, 0x376E, 0x3AF8, 0x3E5A,
        0x4191, 0x449D, 0x477A, 0x4A28, 0x4CA3, 0x4EEB, 0x50FD, 0x52D9, 0x547D, 0x55E8, 0x5719, 0x5810, 0x58CB, 0x594A, 0x598D, 0x5994,
        0x595E, 0x58EC, 0x583F, 0x5756, 0x5631, 0x54D3, 0x533C, 0x516D, 0x4F66, 0x4D2A, 0x4ABB, 0x4819, 0x4546, 0x4244, 0x3F16, 0x3BBE,
        0x383D, 0x3496, 0x30CC, 0x2CE1, 0x28D7, 0x24B3, 0x2075, 0x1C22, 0x17BB, 0x1345, 0x0EC1, 0x0A34, 0x05A0, 0x0108, 0xFC70, 0xF7DA,
        0xF349, 0xEEC1, 0xEA44, 0xE5D6, 0xE17A, 0xDD32, 0xD902, 0xD4EC, 0xD0F3, 0xCD19, 0xC962, 0xC5D0, 0xC265, 0xBF24, 0xBC0E, 0xB926,
        0xB66E, 0xB3E7, 0xB194, 0xAF75, 0xAD8D, 0xABDD, 0xAA65, 0xA926, 0xA823, 0xA75A, 0xA6CD, 0xA67D, 0xA668, 0xA690, 0xA6F5, 0xA795,
        0xA871, 0xA988, 0xAAD9, 0xAC64, 0xAE27, 0xB021, 0xB251, 0xB4B5, 0xB74C, 0xBA14, 0xBD0B, 0xC02F, 0xC37E, 0xC6F6, 0xCA95, 0xCE57,
        0xD23B, 0xD63E, 0xDA5D, 0xDE95, 0xE2E4, 0xE747, 0xEBBA, 0xF03A, 0xF4C6, 0xF959, 0xFDF0, 0x0288, 0x071F, 0x0BB1, 0x103C, 0x14BB,
        0x192D, 0x1D8D, 0x21DA, 0x2610, 0x2A2C, 0x2E2C, 0x320C, 0x35CB, 0x3966, 0x3CDA, 0x4025, 0x4345, 0x4637, 0x48FA, 0x4B8C, 0x4DEB,
        0x5015, 0x520A, 0x53C7, 0x554C, 0x5697, 0x57A8, 0x587E, 0x5918, 0x5976, 0x5998, 0x597E, 0x5927, 0x5894, 0x57C6, 0x56BC, 0x5578,
        0x53FA, 0x5243, 0x5056, 0x4E32, 0x4BD9, 0x494D, 0x4690, 0x43A3, 0x4089, 0x3D43, 0x39D4, 0x363E, 0x3284, 0x2EA7, 0x2AAB, 0x2692,
        0x225F, 0x1E15, 0x19B7, 0x1547, 0x10C9, 0x0C40, 0x07AF, 0x0318, 0xFE80, 0xF9E8, 0xF555, 0xF0C8, 0xEC46, 0xE7D1, 0xE36D, 0xDF1B,
        0xDAE0, 0xD6BE, 0xD2B7, 0xCED0, 0xCB09, 0xC766, 0xC3E9, 0xC095, 0xBD6B, 0xBA6E, 0xB7A0, 0xB503, 0xB299, 0xB062, 0xAE62, 0xAC98,
        0xAB06, 0xA9AE, 0xA890, 0xA7AD, 0xA705, 0xA699, 0xA66A, 0xA677, 0xA6C0, 0xA746, 0xA807, 0xA903, 0xAA3B, 0xABAB, 0xAD55, 0xAF37,
        0xB14F, 0xB39C, 0xB61C, 0xB8CE, 0xBBB0, 0xBEC1, 0xC1FD, 0xC563, 0xC8F0, 0xCCA3, 0xD078, 0xD46D, 0xD880, 0xDCAD, 0xE0F2, 0xE54C,
        0xE9B8, 0xEE33, 0xF2BA, 0xF74A, 0xFBE0, 0x0078, 0x0510, 0x09A5, 0x0E33, 0x12B8, 0x1730, 0x1B99, 0x1FEE, 0x242F, 0x2857, 0x2C64,
        0x3053, 0x3421, 0x37CC, 0x3B52, 0x3EB0, 0x41E3, 0x44EA, 0x47C3, 0x4A6B, 0x4CE1, 0x4F23, 0x5130, 0x5306, 0x54A4, 0x560A, 0x5735,
        0x5825, 0x58DA, 0x5954, 0x5991, 0x5991, 0x5955, 0x58DD, 0x582A, 0x573A, 0x5610, 0x54AC, 0x530F, 0x513A, 0x4F2E, 0x4CED, 0x4A78,
        0x47D1, 0x44F9, 0x41F3, 0x3EC1, 0x3B64, 0x37DF, 0x3435, 0x3067, 0x2C79, 0x286C, 0x2445, 0x2005, 0x1BAF, 0x1747, 0x12CF, 0x0E4B,
        0x09BD, 0x0528, 0x0090, 0xFBF8, 0xF762, 0xF2D2, 0xEE4B, 0xE9D0, 0xE563, 0xE109, 0xDCC3, 0xD896, 0xD482, 0xD08D, 0xCCB7, 0xC903,
        0xC575, 0xC20E, 0xBED1, 0xBBC0, 0xB8DD, 0xB62A, 0xB3A8, 0xB15A, 0xAF41, 0xAD5F, 0xABB4, 0xAA42, 0xA909, 0xA80B, 0xA749, 0xA6C2,
        0xA678, 0xA66A, 0xA698, 0xA702, 0xA7A9, 0xA88B, 0xA9A8, 0xAAFF, 0xAC8F, 0xAE58, 0xB057, 0xB28D, 0xB4F6, 0xB792, 0xBA5F, 0xBD5B,
        0xC084, 0xC3D7, 0xC753, 0xCAF6, 0xCEBC, 0xD2A3, 0xD6A9, 0xDACA, 0xDF05, 0xE356, 0xE7BA, 0xEC2F, 0xF0B1, 0xF53D, 0xF9D0, 0xFE68,
        0x0300, 0x0797, 0x0C28, 0x10B2, 0x1530, 0x19A0, 0x1DFF, 0x2249, 0x267C, 0x2A96, 0x2E92, 0x3270, 0x362B, 0x39C2, 0x3D32, 0x4078,
        0x4394, 0x4681, 0x493F, 0x4BCC, 0x4E26, 0x504B, 0x523A, 0x53F1, 0x5570, 0x56B6, 0x57C1, 0x5890, 0x5925, 0x597D, 0x5998, 0x5978,
        0x591B, 0x5882, 0x57AD, 0x569D, 0x5553, 0x53D0, 0x5214, 0x5020, 0x4DF7, 0x4B99, 0x4908, 0x4646, 0x4354, 0x4036, 0x3CEC, 0x3978,
        0x35DE, 0x3220, 0x2E40, 0x2A41, 0x2626, 0x21F0, 0x1DA4, 0x1944, 0x14D3, 0x1053, 0x0BC9, 0x0737, 0x02A0, 0xFE08, 0xF971, 0xF4DE,
        0xF052, 0xEBD1, 0xE75E, 0xE2FB, 0xDEAC, 0xDA73, 0xD653, 0xD250, 0xCE6B, 0xCAA8, 0xC709, 0xC390, 0xC040, 0xBD1B, 0xBA23, 0xB75A,
        0xB4C2, 0xB25D, 0xB02C, 0xAE30, 0xAC6C, 0xAAE1, 0xA98E, 0xA876, 0xA799, 0xA6F7, 0xA692, 0xA669, 0xA67C, 0xA6CB, 0xA757, 0xA81E,
        0xA921, 0xAA5E, 0xABD4, 0xAD84, 0xAF6B, 0xB188, 0xB3DB, 0xB660, 0xB917, 0xBBFE, 0xBF13, 0xC254, 0xC5BE, 0xC94F, 0xCD06, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC619, 0xC9AF, 0xCD69, 0xD144, 0xD540, 0xD958, 0xDD8B, 0xE1D4, 0xE632, 0xEAA1, 0xEF1F, 0xF3A8, 0xF839, 0xFCD0, 0x0168,
        0x0600, 0x0A93, 0x0F20, 0x13A2, 0x1818, 0x1C7D, 0x20CE, 0x250A, 0x292D, 0x2D34, 0x311C, 0x34E4, 0x3887, 0x3C05, 0x3F5A, 0x4285,
        0x4583, 0x4851, 0x4AF0, 0x4D5B, 0x4F93, 0x5194, 0x535F, 0x54F2, 0x564B, 0x576B, 0x584F, 0x58F8, 0x5965, 0x5996, 0x598A, 0x5942,
        0x58BE, 0x57FE, 0x5702, 0x55CC, 0x545D, 0x52B4, 0x50D4, 0x4EBD, 0x4C71, 0x49F2, 0x4740, 0x445F, 0x4150, 0x3E14, 0x3AAF, 0x3723,
        0x3371, 0x2F9C, 0x2BA8, 0x2795, 0x2369, 0x1F24, 0x1ACB, 0x165F, 0x11E4, 0x0D5D, 0x08CE, 0x0438, 0xFFA0, 0xFB08, 0xF673, 0xF1E5,
        0xED60, 0xE8E7, 0xE47E, 0xE028, 0xDBE7, 0xD7BF, 0xD3B1, 0xCFC2, 0xCBF2, 0xC846, 0xC4C0, 0xC162, 0xBE2D, 0xBB25, 0xB84C, 0xB5A3,
        0xB32B, 0xB0E8, 0xAEDA, 0xAD03, 0xAB63, 0xA9FD, 0xA8D1, 0xA7DF, 0xA729, 0xA6AE, 0xA670, 0xA66E, 0xA6A9, 0xA71F, 0xA7D2, 0xA8C0,
        0xA9E9, 0xAB4C, 0xACE8, 0xAEBC, 0xB0C6, 0xB307, 0xB57A, 0xB821, 0xBAF7, 0xBDFC, 0xC12E, 0xC48A, 0xC80E, 0xCBB8, 0xCF85, 0xD373,
        0xD77E, 0xDBA5, 0xDFE5, 0xE43A, 0xE8A2, 0xED19, 0xF19E, 0xF62C, 0xFAC0, 0xFF58, 0x03F0, 0x0886, 0x0D16, 0x119E, 0x1619, 0x1A86,
        0x1EE1, 0x2326, 0x2755, 0x2B69, 0x2F5F, 0x3336, 0x36EA, 0x3A79, 0x3DE0, 0x411E, 0x4430, 0x4715, 0x49C9, 0x4C4B, 0x4E9A, 0x50B4,
        0x5298, 0x5444, 0x55B8, 0x56F1, 0x57F0, 0x58B4, 0x593B, 0x5987, 0x5997, 0x596A, 0x5900, 0x585B, 0x577A, 0x565F, 0x5509, 0x537A,
        0x51B2, 0x4FB4, 0x4D7F, 0x4B17, 0x487C, 0x45B0, 0x42B5, 0x3F8D, 0x3C3B, 0x38BF, 0x351E, 0x3159, 0x2D72, 0x296D, 0x254C, 0x2111,
        0x1CC1, 0x185D, 0x13E9, 0x0F67, 0x0ADB, 0x0647, 0x01B0, 0xFD18, 0xF881, 0xF3EF, 0xEF66, 0xEAE7, 0xE677, 0xE218, 0xDDCD, 0xD999,
        0xD57F, 0xD182, 0xCDA4, 0xC9E8, 0xC650, 0xC2E0, 0xBF98, 0xBC7C, 0xB98D, 0xB6CE, 0xB441, 0xB1E6, 0xAFC0, 0xADD0, 0xAC17, 0xAA97,
        0xA950, 0xA844, 0xA773, 0xA6DE, 0xA685, 0xA668, 0xA687, 0xA6E3, 0xA77B, 0xA84E, 0xA95C, 0xAAA5, 0xAC28, 0xADE3, 0xAFD5, 0xB1FD,
        0xB45A, 0xB6EA, 0xB9AB, 0xBC9C, 0xBFBA, 0xC303, 0xC675, 0xCA0E, 0xCDCC, 0xD1AB, 0xD5AA, 0xD9C5, 0xDDFA, 0xE245, 0xE6A5, 0xEB16,
        0xEF95, 0xF41F, 0xF8B1, 0xFD48, 0x01E0, 0x0677, 0x0B0B, 0x0F96, 0x1418, 0x188B, 0x1CEE, 0x213E, 0x2577, 0x2997, 0x2D9B, 0x3181,
        0x3544, 0x38E4, 0x3C5E, 0x3FAF, 0x42D5, 0x45CE, 0x4898, 0x4B31, 0x4D97, 0x4FCA, 0x51C6, 0x538B, 0x5518, 0x566B, 0x5785, 0x5863,
        0x5906, 0x596D, 0x5997, 0x5985, 0x5937, 0x58AD, 0x57E7, 0x56E5, 0x55A9, 0x5434, 0x5286, 0x50A0, 0x4E83, 0x4C32, 0x49AD, 0x46F7,
        0x4411, 0x40FD, 0x3DBE, 0x3A54, 0x36C4, 0x330E, 0x2F36, 0x2B3E, 0x272A, 0x22FA, 0x1EB3, 0x1A58, 0x15EB, 0x116E, 0x0CE7, 0x0856,
        0x03C0, 0xFF28, 0xFA90, 0xF5FC, 0xF16E, 0xECEA, 0xE873, 0xE40C, 0xDFB8, 0xDB79, 0xD753, 0xD349, 0xCF5C, 0xCB91, 0xC7E9, 0xC466,
        0xC10C, 0xBDDC, 0xBAD9, 0xB804, 0xB560, 0xB2EE, 0xB0B0, 0xAEA8, 0xACD6, 0xAB3C, 0xA9DC, 0xA8B5, 0xA7CA, 0xA719, 0xA6A5, 0xA66D,
        0xA671, 0xA6B2, 0xA72F, 0xA7E8, 0xA8DC, 0xAA0B, 0xAB73, 0xAD15, 0xAEEF, 0xB0FF, 0xB344, 0xB5BD, 0xB869, 0xBB44, 0xBE4E, 0xC184,
        0xC4E4, 0xC86C, 0xCC1A, 0xCFEA, 0xD3DB, 0xD7E9, 0xDC13, 0xE055, 0xE4AC, 0xE916, 0xED8F, 0xF214, 0xF6A3, 0xFB38, 0xFFD0, 0x0468,
        0x08FD, 0x0D8D, 0x1213, 0x168D, 0x1AF8, 0x1F51, 0x2395, 0x27C1, 0x2BD1, 0x2FC5, 0x3398, 0x3748, 0x3AD4, 0x3E37, 0x4171, 0x447E,
        0x475D, 0x4A0D, 0x4C8A, 0x4ED4, 0x50E8, 0x52C6, 0x546D, 0x55DA, 0x570E, 0x5807, 0x58C4, 0x5946, 0x598C, 0x5995, 0x5962, 0x58F2,
        0x5847, 0x5760, 0x563E, 0x54E3, 0x534E, 0x5181, 0x4F7C, 0x4D43, 0x4AD5, 0x4835, 0x4564, 0x4265, 0x3F38, 0x3BE1, 0x3862, 0x34BD,
        0x30F4, 0x2D0A, 0x2902, 0x24DE, 0x20A2, 0x1C4F, 0x17E9, 0x1374, 0x0EF1, 0x0A64, 0x05D0, 0x0138, 0xFCA0, 0xF80A, 0xF378, 0xEEF0,
        0xEA73, 0xE604, 0xE1A7, 0xDD5E, 0xD92D, 0xD516, 0xD11C, 0xCD41, 0xC988, 0xC5F5, 0xC288, 0xBF45, 0xBC2D, 0xB944, 0xB689, 0xB401,
        0xB1AB, 0xAF8B, 0xADA0, 0xABED, 0xAA73, 0xA932, 0xA82C, 0xA761, 0xA6D2, 0xA67F, 0xA668, 0xA68E, 0xA6EF, 0xA78D, 0xA867, 0xA97B,
        0xAACA, 0xAC52, 0xAE13, 0xB00B, 0xB239, 0xB49B, 0xB730, 0xB9F6, 0xBCEB, 0xC00E, 0xC35B, 0xC6D1, 0xCA6E, 0xCE2F, 0xD212, 0xD614,
        0xDA31, 0xDE69, 0xE2B7, 0xE718, 0xEB8B, 0xF00B, 0xF496, 0xF929, 0xFDC0, 0x0258, 0x06EF, 0x0B82, 0x100D, 0x148D, 0x18FF, 0x1D60,
        0x21AD, 0x25E4, 0x2A02, 0x2E03, 0x31E5, 0x35A5, 0x3941, 0x3CB7, 0x4003, 0x4325, 0x4619, 0x48DE, 0x4B72, 0x4DD3, 0x5000, 0x51F7,
        0x53B6, 0x553D, 0x568B, 0x579E, 0x5876, 0x5913, 0x5974, 0x5998, 0x5980, 0x592C, 0x589B, 0x57CF, 0x56C8, 0x5586, 0x540B, 0x5256,
        0x506B, 0x4E49, 0x4BF3, 0x4969, 0x46AE, 0x43C3, 0x40AA, 0x3D66, 0x39F9, 0x3664, 0x32AB, 0x2ED0, 0x2AD5, 0x26BD, 0x228C, 0x1E42,
        0x19E5, 0x1576, 0x10F9, 0x0C70, 0x07DF, 0x0348, 0xFEB0, 0xFA18, 0xF584, 0xF0F8, 0xEC75, 0xE7FF, 0xE39A, 0xDF48, 0xDB0C, 0xD6E9,
        0xD2E1, 0xCEF8, 0xCB30, 0xC78B, 0xC40D, 0xC0B7, 0xBD8B, 0xBA8D, 0xB7BD, 0xB51E, 0xB2B1, 0xB078, 0xAE75, 0xACA9, 0xAB16, 0xA9BB,
        0xA89B, 0xA7B5, 0xA70B, 0xA69D, 0xA66B, 0xA675, 0xA6BC, 0xA73F, 0xA7FE, 0xA8F8, 0xAA2D, 0xAB9B, 0xAD43, 0xAF22, 0xB138, 0xB383,
        0xB601, 0xB8B1, 0xBB91, 0xBEA0, 0xC1DA, 0xC53F, 0xC8CB, 0xCC7C, 0xD050, 0xD444, 0xD855, 0xDC81, 0xE0C5, 0xE51F, 0xE98A, 0xEE04,
        0xF28B, 0xF71A, 0xFBB0, 0x0048, 0x04E0, 0x0975, 0x0E04, 0x1289, 0x1702, 0x1B6B, 0x1FC2, 0x2403, 0x282C, 0x2C3A, 0x302A, 0x33FA,
        0x37A7, 0x3B2E, 0x3E8D, 0x41C2, 0x44CB, 0x47A6, 0x4A50, 0x4CC8, 0x4F0D, 0x511C, 0x52F4, 0x5495, 0x55FC, 0x572A, 0x581D, 0x58D4,
        0x5950, 0x598F, 0x5992, 0x5959, 0x58E4, 0x5832, 0x5745, 0x561E, 0x54BC, 0x5321, 0x514E, 0x4F45, 0x4D06, 0x4A93, 0x47EE, 0x4518,
        0x4214, 0x3EE3, 0x3B88, 0x3805, 0x345C, 0x308F, 0x2CA2, 0x2897, 0x2471, 0x2032, 0x1BDD, 0x1776, 0x12FE, 0x0E7A, 0x09EC, 0x0558,
        0x00C0, 0xFC28, 0xF792, 0xF302, 0xEE7A, 0xE9FE, 0xE591, 0xE136, 0xDCF0, 0xD8C1, 0xD4AC, 0xD0B5, 0xCCDE, 0xC929, 0xC599, 0xC231,
        0xBEF2, 0xBBDF, 0xB8FA, 0xB645, 0xB3C1, 0xB171, 0xAF56, 0xAD71, 0xABC4, 0xAA4F, 0xA915, 0xA815, 0xA750, 0xA6C7, 0xA67A, 0xA669,
        0xA695, 0xA6FD, 0xA7A1, 0xA880, 0xA99B, 0xAAF0, 0xAC7E, 0xAE44, 0xB041, 0xB275, 0xB4DC, 0xB776, 0xBA41, 0xBD3B, 0xC062, 0xC3B4,
        0xC72E, 0xCACF, 0xCE93, 0xD279, 0xD67E, 0xDA9E, 0xDED8, 0xE328, 0xE78C, 0xEC00, 0xF081, 0xF50D, 0xF9A1, 0xFE38, 0x02D0, 0x0767,
        0x0BF9, 0x1083, 0x1501, 0x1972, 0x1DD1, 0x221D, 0x2651, 0x2A6C, 0x2E69, 0x3248, 0x3605, 0x399D, 0x3D0F, 0x4057, 0x4374, 0x4664,
        0x4924, 0x4BB3, 0x4E0E, 0x5036, 0x5227, 0x53E1, 0x5562, 0x56AA, 0x57B7, 0x5889, 0x5920, 0x597A, 0x5998, 0x597A, 0x5920, 0x5889,
        0x57B7, 0x56AA, 0x5562, 0x53E1, 0x5227, 0x5036, 0x4E0E, 0x4BB3, 0x4924, 0x4664, 0x4374, 0x4057, 0x3D0F, 0x399D, 0x3605, 0x3248,
        0x2E69, 0x2A6C, 0x2651, 0x221D, 0x1DD1, 0x1972, 0x1501, 0x1083, 0x0BF9, 0x0767, 0x02D0, 0xFE38, 0xF9A1, 0xF50D, 0xF081, 0xEC00,
        0xE78C, 0xE328, 0xDED8, 0xDA9E, 0xD67E, 0xD279, 0xCE93, 0xCACF, 0xC72E, 0xC3B4, 0xC062, 0xBD3B, 0xBA41, 0xB776, 0xB4DC, 0xB275,
        0xB041, 0xAE44, 0xAC7E, 0xAAF0, 0xA99B, 0xA880, 0xA7A1, 0xA6FD, 0xA695, 0xA669, 0xA67A, 0xA6C7, 0xA750, 0xA815, 0xA915, 0xAA4F,
        0xABC4, 0xAD71, 0xAF56, 0xB171, 0xB3C1, 0xB645, 0xB8FA, 0xBBDF, 0xBEF2, 0xC231, 0xC599, 0xC929, 0xCCDE, 0xD0B5, 0xD4AC, 0xD8C1,
        0xDCF0, 0xE136, 0xE591, 0xE9FE, 0xEE7A, 0xF302, 0xF792, 0xFC28, 0x00C0, 0x0558, 0x09EC, 0x0E7A, 0x12FE, 0x1776, 0x1BDD, 0x2032,
        0x2471, 0x2897, 0x2CA2, 0x308F, 0x345C, 0x3805, 0x3B88, 0x3EE3, 0x4214, 0x4518, 0x47EE, 0x4A93, 0x4D06, 0x4F45, 0x514E, 0x5321,
        0x54BC, 0x561E, 0x5745, 0x5832, 0x58E4, 0x5959, 0x5992, 0x598F, 0x5950, 0x58D4, 0x581D, 0x572A, 0x55FC, 0x5495, 0x52F4, 0x511C,
        0x4F0D, 0x4CC8, 0x4A50, 0x47A6, 0x44CB, 0x41C2, 0x3E8D, 0x3B2E, 0x37A7, 0x33FA, 0x302A, 0x2C3A, 0x282C, 0x2403, 0x1FC2, 0x1B6B,
        0x1702, 0x1289, 0x0E04, 0x0975, 0x04E0, 0x0048, 0xFBB0, 0xF71A, 0xF28B, 0xEE04, 0xE98A, 0xE51F, 0xE0C5, 0xDC81, 0xD855, 0xD444,
        0xD050, 0xCC7C, 0xC8CB, 0xC53F, 0xC1DA, 0xBEA0, 0xBB91, 0xB8B1, 0xB601, 0xB383, 0xB138, 0xAF22, 0xAD43, 0xAB9B, 0xAA2D, 0xA8F8,
        0xA7FE, 0xA73F, 0xA6BC, 0xA675, 0xA66B, 0xA69D, 0xA70B, 0xA7B5, 0xA89B, 0xA9BB, 0xAB16, 0xACA9, 0xAE75, 0xB078, 0xB2B1, 0xB51E,
        0xB7BD, 0xBA8D, 0xBD8B, 0xC0B7, 0xC40D, 0xC78B, 0xCB30, 0xCEF8, 0xD2E1, 0xD6E9, 0xDB0C, 0xDF48, 0xE39A, 0xE7FF, 0xEC75, 0xF0F8,
        0xF584, 0xFA18, 0xFEB0, 0x0348, 0x07DF, 0x0C70, 0x10F9, 0x1576, 0x19E5, 0x1E42, 0x228C, 0x26BD, 0x2AD5, 0x2ED0, 0x32AB, 0x3664,
        0x39F9, 0x3D66, 0x40AA, 0x43C3, 0x46AE, 0x4969, 0x4BF3, 0x4E49, 0x506B, 0x5256, 0x540B, 0x5586, 0x56C8, 0x57CF, 0x589B, 0x592C,
        0x5980, 0x5998, 0x5974, 0x5913, 0x5876, 0x579E, 0x568B, 0x553D, 0x53B6, 0x51F7, 0x5000, 0x4DD3, 0x4B72, 0x48DE, 0x4619, 0x4325,
        0x4003, 0x3CB7, 0x3941, 0x35A5, 0x31E5, 0x2E03, 0x2A02, 0x25E4, 0x21AD, 0x1D60, 0x18FF, 0x148D, 0x100D, 0x0B82, 0x06EF, 0x0258,
        0xFDC0, 0xF929, 0xF496, 0xF00B, 0xEB8B, 0xE718, 0xE2B7, 0xDE69, 0xDA31, 0xD614, 0xD212, 0xCE2F, 0xCA6E, 0xC6D1, 0xC35B, 0xC00E,
        0xBCEB, 0xB9F6, 0xB730, 0xB49B, 0xB239, 0xB00B, 0xAE13, 0xAC52, 0xAACA, 0xA97B, 0xA867, 0xA78D, 0xA6EF, 0xA68E, 0xA668, 0xA67F,
        0xA6D2, 0xA761, 0xA82C, 0xA932, 0xAA73, 0xABED, 0xADA0, 0xAF8B, 0xB1AB, 0xB401, 0xB689, 0xB944, 0xBC2D, 0xBF45, 0xC288, 0xC5F5,
        0xC988, 0xCD41, 0xD11C, 0xD516, 0xD92D, 0xDD5E, 0xE1A7, 0xE604, 0xEA73, 0xEEF0, 0xF378, 0xF80A, 0xFCA0, 0x0138, 0x05D0, 0x0A64,
        0x0EF1, 0x1374, 0x17E9, 0x1C4F, 0x20A2, 0x24DE, 0x2902, 0x2D0A, 0x30F4, 0x34BD, 0x3862, 0x3BE1, 0x3F38, 0x4265, 0x4564, 0x4835,
        0x4AD5, 0x4D43, 0x4F7C, 0x5181, 0x534E, 0x54E3, 0x563E, 0x5760, 0x5847, 0x58F2, 0x5962, 0x5995, 0x598C, 0x5946, 0x58C4, 0x5807,
        0x570E, 0x55DA, 0x546D, 0x52C6, 0x50E8, 0x4ED4, 0x4C8A, 0x4A0D, 0x475D, 0x447E, 0x4171, 0x3E37, 0x3AD4, 0x3748, 0x3398, 0x2FC5,
        0x2BD1, 0x27C1, 0x2395, 0x1F51, 0x1AF8, 0x168D, 0x1213, 0x0D8D, 0x08FD, 0x0468, 0xFFD0, 0xFB38, 0xF6A3, 0xF214, 0xED8F, 0xE916,
        0xE4AC, 0xE055, 0xDC13, 0xD7E9, 0xD3DB, 0xCFEA, 0xCC1A, 0xC86C, 0xC4E4, 0xC184, 0xBE4E, 0xBB44, 0xB869, 0xB5BD, 0xB344, 0xB0FF,
        0xAEEF, 0xAD57, 0xABFB, 0xAAD9, 0xA9F3, 0xA948, 0xA8D9, 0xA8A5, 0xA8AD, 0xA8F0, 0xA96E, 0xAA25, 0xAB15, 0xAC3D, 0xAD9B, 0xAF30,
        0xB0F8, 0xB2F2, 0xB51E, 0xB778, 0xBA00, 0xBCB3, 0xBF8E, 0xC291, 0xC5B8, 0xC901, 0xCC6A, 0xCFF0, 0xD390, 0xD749, 0xDB16, 0xDEF6,
        0xE2E6, 0xE6E3, 0xEAEA, 0xEEF8, 0xF30B, 0xF71F, 0xFB33, 0xFF42, 0x034A, 0x074A, 0x0B3E, 0x0F23, 0x12F7, 0x16B8, 0x1A63, 0x1DF5,
        0x216D, 0x24C8, 0x2804, 0x2B1F, 0x2E18, 0x30EC, 0x339A, 0x3620, 0x387D, 0x3AAF, 0x3CB6, 0x3E8F, 0x403C, 0x41B9, 0x4308, 0x4426,
        0x4515, 0x45D3, 0x4660, 0x46BC, 0x46E8, 0x46E4, 0x46B0, 0x464C, 0x45BA, 0x44F9, 0x440B, 0x42F0, 0x41AB, 0x403B, 0x3EA3, 0x3CE3,
        0x3AFD, 0x38F3, 0x36C6, 0x3479, 0x320C, 0x2F82, 0x2CDD, 0x2A1E, 0x2749, 0x245E, 0x2160, 0x1E52, 0x1B35, 0x180C, 0x14D9, 0x119E,
        0x0E5D, 0x0B1A, 0x07D5, 0x0492, 0x0152, 0xFE18, 0xFAE6, 0xF7BD, 0xF4A1, 0xF192, 0xEE94, 0xEBA7, 0xE8CF, 0xE60C, 0xE360, 0xE0CD,
        0xDE55, 0xDBF9, 0xD9BA, 0xD799, 0xD599, 0xD3BA, 0xD1FC, 0xD062, 0xCEEB, 0xCD99, 0xCC6B, 0xCB63, 0xCA81, 0xC9C6, 0xC930, 0xC8C2,
        0xC879, 0xC857, 0xC85B, 0xC885, 0xC8D4, 0xC948, 0xC9E0, 0xCA9B, 0xCB79, 0xCC79, 0xCD99, 0xCEDA, 0xD038, 0xD1B5, 0xD34D, 0xD500,
        0xD6CC, 0xD8B0, 0xDAAB, 0xDCBB, 0xDEDD, 0xE112, 0xE356, 0xE5A8, 0xE807, 0xEA71, 0xECE3, 0xEF5D, 0xF1DC, 0xF460, 0xF6E5, 0xF96A,
        0xFBED, 0xFE6E, 0x00E8, 0x035D, 0x05CA, 0x082D, 0x0A84, 0x0CCF, 0x0F0B, 0x1137, 0x1353, 0x155C, 0x1751, 0x1932, 0x1AFD, 0x1CB1,
        0x1E4D, 0x1FD0, 0x213A, 0x228A, 0x23BF, 0x24D9, 0x25D6, 0x26B7, 0x277C, 0x2824, 0x28AE, 0x291C, 0x296C, 0x299F, 0x29B6, 0x29AF,
        0x298D, 0x294E, 0x28F4, 0x287F, 0x27EF, 0x2746, 0x2683, 0x25A9, 0x24B7, 0x23AF, 0x2291, 0x215E, 0x2018, 0x1EC0, 0x1D57, 0x1BDD,
        0x1A55, 0x18BE, 0x171C, 0x156E, 0x13B7, 0x11F6, 0x102F, 0x0E62, 0x0C90, 0x0ABA, 0x08E3, 0x070B, 0x0534, 0x035E, 0x018C, 0xFFBF,
        0xFDF6, 0xFC35, 0xFA7B, 0xF8CA, 0xF723, 0xF587, 0xF3F8, 0xF275, 0xF100, 0xEF9B, 0xEE44, 0xECFE, 0xEBC9, 0xEAA6, 0xE995, 0xE897,
        0xE7AC, 0xE6D4, 0xE611, 0xE562, 0xE4C7, 0xE441, 0xE3D0, 0xE373, 0xE32B, 0xE2F9, 0xE2DA, 0xE2D0, 0xE2DB, 0xE2F9, 0xE32B, 0xE370,
        0xE3C8, 0xE432, 0xE4AE, 0xE53B, 0xE5D8, 0xE685, 0xE742, 0xE80D, 0xE8E6, 0xE9CB, 0xEABD, 0xEBBA, 0xECC2, 0xEDD3, 0xEEED, 0xF00E,
        0xF137, 0xF265, 0xF399, 0xF4D0, 0xF60B, 0xF748, 0xF886, 0xF9C5, 0xFB04, 0xFC41, 0xFD7C, 0xFEB3, 0xFFE8, 0x0116, 0x0240, 0x0364,
        0x0481, 0x0596, 0x06A4, 0x07A8, 0x08A3, 0x0994, 0x0A7A, 0x0B55, 0x0C25, 0x0CE9, 0x0DA1, 0x0E4D, 0x0EEB, 0x0F7D, 0x1001, 0x1078,
        0x10E1, 0x113D, 0x118B, 0x11CB, 0x11FE, 0x1224, 0x123C, 0x1246, 0x1244, 0x1235, 0x121A, 0x11F2, 0x11BE, 0x117F, 0x1135, 0x10E0,
        0x1081, 0x1017, 0x0FA5, 0x0F29, 0x0EA5, 0x0E1A, 0x0D87, 0x0CED, 0x0C4D, 0x0BA8, 0x0AFD, 0x0A4F, 0x099C, 0x08E6, 0x082E, 0x0773,
        0x06B7, 0x05FA, 0x053D, 0x0480, 0x03C4, 0x0309, 0x0250, 0x0199, 0x00E5, 0x0035, 0xFF89, 0xFEE0, 0xFE3C, 0xFD9D, 0xFD04, 0xFC70,
        0xFBE2, 0xFB5A, 0xFAD9, 0xFA5F, 0xF9EC, 0xF980, 0xF91B, 0xF8BE, 0xF868, 0xF81A, 0xF7D4, 0xF796, 0xF75F, 0xF731, 0xF709, 0xF6EA,
        0xF6D2, 0xF6C2, 0xF6B9, 0xF6B7, 0xF6BC, 0xF6C7, 0xF6DA, 0xF6F3, 0xF711, 0xF736, 0xF760, 0xF790, 0xF7C4, 0xF7FE, 0xF83B, 0xF87D,
        0xF8C2, 0xF90B, 0xF957, 0xF9A6, 0xF9F7, 0xFA4A, 0xFA9F, 0xFAF5, 0xFB4C, 0xFBA4, 0xFBFC, 0xFC55, 0xFCAD, 0xFD05, 0xFD5C, 0xFDB2,
        0xFE07, 0xFE5A, 0xFEAC, 0xFEFB, 0xFF48, 0xFF93, 0xFFDB, 0x0020, 0x0062, 0x00A1, 0x00DE, 0x0116, 0x014C, 0x017E, 0x01AC, 0x01D7,
        0x01FE, 0x0222, 0x0242, 0x025F, 0x0278, 0x028D, 0x029F, 0x02AD, 0x02B9, 0x02C1, 0x02C5, 0x02C7, 0x02C6, 0x02C2, 0x02BC, 0x02B3,
        0x02A8, 0x029B, 0x028B, 0x027A, 0x0267, 0x0253, 0x023D, 0x0226, 0x020F, 0x01F6, 0x01DD, 0x01C3, 0x01A9, 0x018E, 0x0174, 0x015A,
        0x0140, 0x0126, 0x010D, 0x00F5, 0x00DD, 0x00C7, 0x00B1, 0x009C, 0x0088, 0x0076, 0x0065, 0x0054, 0x0046, 0x0038, 0x002C, 0x0021,
        0x0018, 0x0010, 0x0009, 0x0003, 0xFFFF, 0xFFFC, 0xFFFA, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFC, 0xFFFE, 0xFFFF, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0004, 0x0005, 0x0007, 0x0009, 0x000B, 0x000E, 0x0011,
        0x0014, 0x0017, 0x001B, 0x0020, 0x0024, 0x0029, 0x002E, 0x0033, 0x0038, 0x003D, 0x0043, 0x0048, 0x004E, 0x0053, 0x0058, 0x005D,
        0x0062, 0x0066, 0x006A, 0x006E, 0x0071, 0x0073, 0x0075, 0x0076, 0x0076, 0x0076, 0x0074, 0x0072, 0x006E, 0x0069, 0x0063, 0x005C,
        0x0054, 0x004B, 0x0040, 0x0034, 0x0027, 0x0018, 0x0009, 0xFFF9, 0xFFE6, 0xFFD3, 0xFFBE, 0xFFA8, 0xFF91, 0xFF79, 0xFF61, 0xFF47,
        0xFF2C, 0xFF11, 0xFEF6, 0xFED9, 0xFEBD, 0xFEA0, 0xFE84, 0xFE67, 0xFE4B, 0xFE2F, 0xFE14, 0xFDF9, 0xFDDF, 0xFDC6, 0xFDAF, 0xFD99,
        0xFD84, 0xFD71, 0xFD60, 0xFD51, 0xFD45, 0xFD3A, 0xFD32, 0xFD2D, 0xFD2B, 0xFD2B, 0xFD2F, 0xFD36, 0xFD40, 0xFD4D, 0xFD5E, 0xFD72,
        0xFD8A, 0xFDA5, 0xFDC4, 0xFDE7, 0xFE0D, 0xFE36, 0xFE63, 0xFE94, 0xFEC8, 0xFEFF, 0xFF3A, 0xFF77, 0xFFB7, 0xFFFA, 0x003F, 0x0087,
        0x00D1, 0x011C, 0x016A, 0x01B9, 0x0209, 0x025A, 0x02AB, 0x02FC, 0x034E, 0x039F, 0x03EF, 0x043E, 0x048B, 0x04D7, 0x0520, 0x0567,
        0x05AB, 0x05EC, 0x0629, 0x0662, 0x0697, 0x06C7, 0x06F2, 0x0718, 0x0738, 0x0753, 0x0767, 0x0775, 0x077C, 0x077D, 0x0776, 0x0768,
        0x0753, 0x0737, 0x0713, 0x06E7, 0x06B4, 0x0679, 0x0636, 0x05EC, 0x059A, 0x0541, 0x04E1, 0x047A, 0x040B, 0x0397, 0x031C, 0x029A,
        0x0214, 0x0187, 0x00F6, 0x0061, 0xFFC8, 0xFF2B, 0xFE8B, 0xFDE8, 0xFD43, 0xFC9C, 0xFBF5, 0xFB4E, 0xFAA6, 0xFA00, 0xF95B, 0xF8B9,
        0xF819, 0xF77D, 0xF6E5, 0xF652, 0xF5C4, 0xF53C, 0xF4BC, 0xF442, 0xF3D0, 0xF367, 0xF307, 0xF2B1, 0xF265, 0xF223, 0xF1ED, 0xF1C2,
        0xF1A3, 0xF190, 0xF18A, 0xF190, 0xF1A4, 0xF1C5, 0xF1F4, 0xF230, 0xF279, 0xF2D1, 0xF336, 0xF3A8, 0xF428, 0xF4B5, 0xF54E, 0xF5F5,
        0xF6A7, 0xF765, 0xF82F, 0xF904, 0xF9E2, 0xFACB, 0xFBBC, 0xFCB6, 0xFDB8, 0xFEC0, 0xFFCF, 0x00E1, 0x01F9, 0x0315, 0x0432, 0x0551,
        0x0671, 0x0790, 0x08AE, 0x09C9, 0x0AE0, 0x0BF3, 0x0D00, 0x0E06, 0x0F04, 0x0FF9, 0x10E5, 0x11C5, 0x129A, 0x1362, 0x141C, 0x14C8,
        0x1564, 0x15F0, 0x166B, 0x16D4, 0x172A, 0x176E, 0x179E, 0x17BA, 0x17C2, 0x17B5, 0x1793, 0x175B, 0x170E, 0x16AC, 0x1634, 0x15A6,
        0x1503, 0x144B, 0x137F, 0x129E, 0x11A9, 0x10A1, 0x0F87, 0x0E5A, 0x0D1C, 0x0BCE, 0x0A70, 0x0904, 0x078A, 0x0605, 0x0474, 0x02D9,
        0x0135, 0xFF8B, 0xFDDB, 0xFC26, 0xFA6E, 0xF8B4, 0xF6FA, 0xF542, 0xF38D, 0xF1DC, 0xF032, 0xEE8F, 0xECF6, 0xEB67, 0xE9E5, 0xE871,
        0xE70C, 0xE5B7, 0xE475, 0xE347, 0xE22E, 0xE12A, 0xE03E, 0xDF6B, 0xDEB1, 0xDE12, 0xDD8E, 0xDD26, 0xDCDB, 0xDCAE, 0xDC9F, 0xDCAF,
        0xDCDE, 0xDD2C, 0xDD99, 0xDE26, 0xDED2, 0xDF9D, 0xE087, 0xE190, 0xE2B6, 0xE3FA, 0xE55A, 0xE6D6, 0xE86D, 0xEA1E, 0xEBE6, 0xEDC7,
        0xEFBD, 0xF1C7, 0xF3E5, 0xF614, 0xF852, 0xFA9E, 0xFCF6, 0xFF59, 0x01C2, 0x0432, 0x06A7, 0x091D, 0x0B93, 0x0E06, 0x1075, 0x12DD,
        0x153D, 0x1791, 0x19D7, 0x1C0F, 0x1E34, 0x2046, 0x2242, 0x2427, 0x25F2, 0x27A1, 0x2933, 0x2AA6, 0x2BF8, 0x2D28, 0x2E34, 0x2F1C,
        0x2FDD, 0x3077, 0x30E9, 0x3132, 0x3151, 0x3145, 0x310F, 0x30AE, 0x3021, 0x2F6A, 0x2E87, 0x2D79, 0x2C41, 0x2ADF, 0x2955, 0x27A2,
        0x25C8, 0x23C8, 0x21A4, 0x1F5D, 0x1CF4, 0x1A6C, 0x17C5, 0x1503, 0x1227, 0x0F34, 0x0C2B, 0x0910, 0x05E4, 0x02AB, 0xFF68, 0xFC1B,
        0xF8C9, 0xF574, 0xF220, 0xEECE, 0xEB83, 0xE840, 0xE509, 0xE1E2, 0xDECC, 0xDBCA, 0xD8E0, 0xD610, 0xD35D, 0xD0C9, 0xCE58, 0xCC0B,
        0xC9E4, 0xC7E8, 0xC616, 0xC472, 0xC2FC, 0xC1B8, 0xC0A7, 0xBFC9, 0xBF20, 0xBEAE, 0xBE73, 0xBE70, 0xBEA5, 0xBF13, 0xBFBB, 0xC09B,
        0xC1B4, 0xC306, 0xC48F, 0xC64F, 0xC846, 0xCA71, 0xCCD0, 0xCF61, 0xD221, 0xD510, 0xD82B, 0xDB70, 0xDEDC, 0xE26D, 0xE620, 0xE9F3,
        0xEDE1, 0xF1E8, 0xF605, 0xFA34, 0xFE73, 0x02BB, 0x070C, 0x0B62, 0x0FB7, 0x140A, 0x1855, 0x1C95, 0x20C7, 0x24E5, 0x28EE, 0x2CDD,
        0x30AE, 0x345E, 0x37EA, 0x3B4D, 0x3E86, 0x418F, 0x4468, 0x470C, 0x4978, 0x4BAB, 0x4DA2, 0x4F5B, 0x50D3, 0x5208, 0x52FB, 0x53A7,
        0x540E, 0x542D, 0x5403, 0x5392, 0x52D7, 0x51D4, 0x5088, 0x4EF4, 0x4D19, 0x4AF7, 0x4890, 0x45E6, 0x42FA, 0x3FCE, 0x3C64, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC76E, 0xC3BC, 0xC043, 0xBD06, 0xBA08, 0xB749, 0xB4CD, 0xB295, 0xB0A2, 0xAEF6, 0xAD92, 0xAC76, 0xABA3, 0xAB19, 0xAAD8,
        0xAAE0, 0xAB30, 0xABC8, 0xACA7, 0xADCB, 0xAF33, 0xB0DE, 0xB2C9, 0xB4F3, 0xB758, 0xB9F8, 0xBCCF, 0xBFDA, 0xC316, 0xC681, 0xCA17,
        0xCDD5, 0xD1B7, 0xD5BA, 0xD9D9, 0xDE12, 0xE261, 0xE6C2, 0xEB30, 0xEFA8, 0xF427, 0xF8A8, 0xFD27, 0x019F, 0x0610, 0x0A73, 0x0EC6,
        0x1304, 0x172B, 0x1B37, 0x1F24, 0x22F0, 0x2697, 0x2A16, 0x2D6C, 0x3095, 0x338F, 0x3658, 0x38ED, 0x3B4D, 0x3D76, 0x3F67, 0x411E,
        0x429B, 0x43DD, 0x44E2, 0x45AB, 0x4637, 0x4686, 0x4698, 0x466E, 0x4609, 0x4569, 0x448E, 0x437B, 0x4231, 0x40B0, 0x3EFC, 0x3D15,
        0x3AFD, 0x38B7, 0x3646, 0x33AB, 0x30E8, 0x2E02, 0x2AFA, 0x27D3, 0x2491, 0x2135, 0x1DC4, 0x1A41, 0x16AE, 0x130E, 0x0F66, 0x0BB8,
        0x0807, 0x0457, 0x00AA, 0xFD05, 0xF969, 0xF5DA, 0xF25B, 0xEEEE, 0xEB97, 0xE859, 0xE535, 0xE22E, 0xDF47, 0xDC82, 0xD9E1, 0xD765,
        0xD512, 0xD2E8, 0xD0E9, 0xCF16, 0xCD71, 0xCBFB, 0xCAB4, 0xC99D, 0xC8B6, 0xC801, 0xC77D, 0xC72B, 0xC709, 0xC719, 0xC759, 0xC7C8,
        0xC867, 0xC934, 0xCA2E, 0xCB53, 0xCCA3, 0xCE1C, 0xCFBC, 0xD182, 0xD36C, 0xD577, 0xD7A2, 0xD9EB, 0xDC4F, 0xDECC, 0xE160, 0xE408,
        0xE6C2, 0xE98B, 0xEC61, 0xEF41, 0xF229, 0xF516, 0xF806, 0xFAF6, 0xFDE3, 0x00CA, 0x03AA, 0x0681, 0x094B, 0x0C07, 0x0EB2, 0x114B,
        0x13CE, 0x163A, 0x188D, 0x1AC6, 0x1CE3, 0x1EE2, 0x20C1, 0x2280, 0x241D, 0x2598, 0x26EE, 0x2820, 0x292D, 0x2A14, 0x2AD5, 0x2B6F,
        0x2BE2, 0x2C2F, 0x2C55, 0x2C55, 0x2C2F, 0x2BE4, 0x2B74, 0x2AE0, 0x2A28, 0x294F, 0x2854, 0x2739, 0x2600, 0x24A9, 0x2337, 0x21AA,
        0x2004, 0x1E47, 0x1C76, 0x1A90, 0x1899, 0x1692, 0x147E, 0x125D, 0x1033, 0x0E00, 0x0BC8, 0x098B, 0x074D, 0x050F, 0x02D2, 0x009A,
        0xFE68, 0xFC3C, 0xFA1A, 0xF804, 0xF5FA, 0xF3FE, 0xF212, 0xF038, 0xEE71, 0xECBE, 0xEB20, 0xE999, 0xE82A, 0xE6D4, 0xE597, 0xE474,
        0xE36D, 0xE281, 0xE1B1, 0xE0FE, 0xE067, 0xDFED, 0xDF91, 0xDF51, 0xDF2E, 0xDF28, 0xDF3E, 0xDF70, 0xDFBE, 0xE026, 0xE0A8, 0xE144,
        0xE1F8, 0xE2C4, 0xE3A6, 0xE49E, 0xE5AB, 0xE6CA, 0xE7FC, 0xE93E, 0xEA90, 0xEBF0, 0xED5D, 0xEED5, 0xF057, 0xF1E1, 0xF373, 0xF509,
        0xF6A4, 0xF842, 0xF9E0, 0xFB7F, 0xFD1B, 0xFEB5, 0x0049, 0x01D8, 0x0360, 0x04E0, 0x0656, 0x07C1, 0x0921, 0x0A74, 0x0BB9, 0x0CEF,
        0x0E15, 0x0F2C, 0x1031, 0x1124, 0x1205, 0x12D2, 0x138D, 0x1434, 0x14C7, 0x1545, 0x15B0, 0x1605, 0x1647, 0x1674, 0x168D, 0x1692,
        0x1683, 0x1662, 0x162D, 0x15E5, 0x158C, 0x1522, 0x14A6, 0x141B, 0x1381, 0x12D8, 0x1221, 0x115E, 0x108F, 0x0FB4, 0x0ED0, 0x0DE3,
        0x0CED, 0x0BF1, 0x0AEE, 0x09E6, 0x08DA, 0x07CB, 0x06BA, 0x05A8, 0x0496, 0x0384, 0x0275, 0x0168, 0x005F, 0xFF5B, 0xFE5C, 0xFD63,
        0xFC70, 0xFB86, 0xFAA4, 0xF9CA, 0xF8FB, 0xF835, 0xF77B, 0xF6CB, 0xF627, 0xF58F, 0xF503, 0xF483, 0xF410, 0xF3AB, 0xF352, 0xF306,
        0xF2C7, 0xF295, 0xF271, 0xF259, 0xF24D, 0xF24E, 0xF25C, 0xF275, 0xF299, 0xF2C9, 0xF304, 0xF348, 0xF397, 0xF3EF, 0xF450, 0xF4B9,
        0xF529, 0xF5A1, 0xF620, 0xF6A4, 0xF72D, 0xF7BB, 0xF84D, 0xF8E3, 0xF97B, 0xFA15, 0xFAB1, 0xFB4E, 0xFBEB, 0xFC88, 0xFD23, 0xFDBE,
        0xFE56, 0xFEEC, 0xFF7E, 0x000C, 0x0098, 0x011E, 0x01A0, 0x021D, 0x0295, 0x0306, 0x0371, 0x03D7, 0x0435, 0x048D, 0x04DE, 0x0528,
        0x056A, 0x05A6, 0x05DA, 0x0607, 0x062D, 0x064C, 0x0664, 0x0675, 0x0680, 0x0683, 0x0681, 0x0678, 0x0669, 0x0654, 0x063A, 0x061B,
        0x05F7, 0x05CF, 0x05A2, 0x0572, 0x053E, 0x0506, 0x04CC, 0x048F, 0x0451, 0x0410, 0x03CE, 0x038B, 0x0347, 0x0303, 0x02BE, 0x027A,
        0x0236, 0x01F3, 0x01B1, 0x0171, 0x0132, 0x00F5, 0x00BA, 0x0081, 0x004A, 0x0016, 0xFFE6, 0xFFB8, 0xFF8C, 0xFF64, 0xFF3E, 0xFF1C,
        0xFEFD, 0xFEE1, 0xFEC8, 0xFEB3, 0xFEA0, 0xFE91, 0xFE85, 0xFE7B, 0xFE74, 0xFE71, 0xFE6F, 0xFE70, 0xFE74, 0xFE79, 0xFE80, 0xFE8A,
        0xFE95, 0xFEA1, 0xFEAF, 0xFEBE, 0xFECE, 0xFEDE, 0xFEF0, 0xFF01, 0xFF13, 0xFF26, 0xFF38, 0xFF49, 0xFF5B, 0xFF6C, 0xFF7C, 0xFF8C,
        0xFF9B, 0xFFA9, 0xFFB6, 0xFFC3, 0xFFCE, 0xFFD8, 0xFFE0, 0xFFE8, 0xFFEE, 0xFFF4, 0xFFF8, 0xFFFC, 0xFFFE, 0xFFFF, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFFA, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFF6, 0xFFF6,
        0xFFF6, 0xFFF6, 0xFFF6, 0xFFF6, 0xFFF7, 0xFFF9, 0xFFFA, 0xFFFC, 0xFFFF, 0x0001, 0x0005, 0x0009, 0x000E, 0x0013, 0x0019, 0x001F,
        0x0026, 0x002E, 0x0036, 0x003E, 0x0048, 0x0051, 0x005C, 0x0067, 0x0072, 0x007D, 0x0089, 0x0096, 0x00A2, 0x00AF, 0x00BC, 0x00CA,
        0x00D7, 0x00E4, 0x00F1, 0x00FE, 0x010A, 0x0117, 0x0123, 0x012E, 0x0139, 0x0143, 0x014C, 0x0155, 0x015C, 0x0163, 0x0168, 0x016C,
        0x016F, 0x0171, 0x0171, 0x016F, 0x016C, 0x0167, 0x0161, 0x0159, 0x014F, 0x0143, 0x0135, 0x0125, 0x0114, 0x0100, 0x00EA, 0x00D2,
        0x00B8, 0x009D, 0x007F, 0x005F, 0x003D, 0x001A, 0xFFF6, 0xFFCF, 0xFFA6, 0xFF7C, 0xFF50, 0xFF23, 0xFEF4, 0xFEC5, 0xFE94, 0xFE63,
        0xFE31, 0xFDFE, 0xFDCB, 0xFD97, 0xFD64, 0xFD30, 0xFCFD, 0xFCCA, 0xFC98, 0xFC67, 0xFC37, 0xFC09, 0xFBDB, 0xFBB0, 0xFB86, 0xFB5F,
        0xFB39, 0xFB17, 0xFAF7, 0xFAD9, 0xFAC0, 0xFAA9, 0xFA96, 0xFA86, 0xFA7A, 0xFA73, 0xFA6F, 0xFA70, 0xFA75, 0xFA7F, 0xFA8D, 0xFAA0,
        0xFAB8, 0xFAD4, 0xFAF6, 0xFB1D, 0xFB48, 0xFB79, 0xFBAE, 0xFBE9, 0xFC28, 0xFC6D, 0xFCB6, 0xFD03, 0xFD56, 0xFDAC, 0xFE07, 0xFE66,
        0xFEC9, 0xFF30, 0xFF9A, 0x0006, 0x0077, 0x00EA, 0x015F, 0x01D7, 0x0251, 0x02CC, 0x0348, 0x03C5, 0x0442, 0x04C0, 0x053D, 0x05BA,
        0x0635, 0x06AF, 0x0727, 0x079D, 0x0810, 0x0880, 0x08EC, 0x0955, 0x09B9, 0x0A18, 0x0A72, 0x0AC7, 0x0B16, 0x0B5E, 0x0BA0, 0x0BDB,
        0x0C0E, 0x0C3A, 0x0C5E, 0x0C7A, 0x0C8D, 0x0C97, 0x0C99, 0x0C91, 0x0C80, 0x0C66, 0x0C42, 0x0C14, 0x0BDD, 0x0B9C, 0x0B51, 0x0AFC,
        0x0A9D, 0x0A35, 0x09C3, 0x0948, 0x08C4, 0x0836, 0x07A0, 0x0701, 0x065A, 0x05AB, 0x04F4, 0x0436, 0x0372, 0x02A6, 0x01D5, 0x00FF,
        0x0024, 0xFF45, 0xFE62, 0xFD7B, 0xFC92, 0xFBA6, 0xFABA, 0xF9CC, 0xF8DF, 0xF7F2, 0xF707, 0xF61E, 0xF537, 0xF454, 0xF375, 0xF29B,
        0xF1C6, 0xF0F8, 0xF031, 0xEF71, 0xEEBA, 0xEE0C, 0xED67, 0xECCD, 0xEC3E, 0xEBBA, 0xEB42, 0xEAD7, 0xEA79, 0xEA29, 0xE9E6, 0xE9B3,
        0xE98E, 0xE978, 0xE972, 0xE97C, 0xE995, 0xE9BF, 0xE9FA, 0xEA45, 0xEAA0, 0xEB0C, 0xEB88, 0xEC15, 0xECB3, 0xED60, 0xEE1D, 0xEEEA,
        0xEFC6, 0xF0B0, 0xF1AA, 0xF2B1, 0xF3C6, 0xF4E7, 0xF615, 0xF74E, 0xF893, 0xF9E1, 0xFB39, 0xFC9A, 0xFE02, 0xFF71, 0x00E4, 0x025E,
        0x03DC, 0x055D, 0x06DF, 0x0863, 0x09E6, 0x0B68, 0x0CE8, 0x0E64, 0x0FDC, 0x114E, 0x12B9, 0x141C, 0x1576, 0x16C7, 0x180C, 0x1945,
        0x1A70, 0x1B8E, 0x1C9C, 0x1D9A, 0x1E87, 0x1F62, 0x202A, 0x20DF, 0x217F, 0x2209, 0x227E, 0x22DD, 0x2325, 0x2355, 0x236D, 0x236D,
        0x2354, 0x2323, 0x22D8, 0x2274, 0x21F7, 0x2161, 0x20B1, 0x1FE9, 0x1F08, 0x1E0E, 0x1CFC, 0x1BD3, 0x1A92, 0x193B, 0x17CF, 0x164D,
        0x14B6, 0x130D, 0x1150, 0x0F83, 0x0DA4, 0x0BB6, 0x09BB, 0x07B2, 0x059D, 0x037E, 0x0155, 0xFF27, 0xFCF1, 0xFAB6, 0xF878, 0xF638,
        0xF3F8, 0xF1B9, 0xEF7E, 0xED47, 0xEB16, 0xE8EE, 0xE6CE, 0xE4BA, 0xE2B2, 0xE0B8, 0xDECF, 0xDCF6, 0xDB30, 0xD97E, 0xD7E2, 0xD65D,
        0xD4F0, 0xD39C, 0xD264, 0xD147, 0xD047, 0xCF66, 0xCEA3, 0xCE00, 0xCD7E, 0xCD1D, 0xCCDF, 0xCCC2, 0xCCC9, 0xCCF3, 0xCD41, 0xCDB3,
        0xCE48, 0xCF02, 0xCFDF, 0xD0E0, 0xD204, 0xD34B, 0xD4B4, 0xD63F, 0xD7EA, 0xD9B6, 0xDBA2, 0xDDAB, 0xDFD2, 0xE215, 0xE472, 0xE6E9,
        0xE977, 0xEC1C, 0xEED6, 0xF1A3, 0xF481, 0xF76E, 0xFA6A, 0xFD71, 0x0080, 0x0399, 0x06B7, 0x09D8, 0x0CFB, 0x101D, 0x133C, 0x1657,
        0x1969, 0x1C72, 0x1F70, 0x225F, 0x253F, 0x280C, 0x2AC5, 0x2D67, 0x2FF1, 0x3260, 0x34B3, 0x36E7, 0x38FB, 0x3AEE, 0x3CBD, 0x3E66,
        0x3FE9, 0x4144, 0x4275, 0x437C, 0x4457, 0x4505, 0x4586, 0x45D8, 0x45FB, 0x45EE, 0x45B1, 0x4544, 0x44A6, 0x43D8, 0x42D9, 0x41AB,
        0x404C, 0x3EBE, 0x3D01, 0x3B17, 0x38FF, 0x36BC, 0x344D, 0x31B5, 0x2EF5, 0x2C0E, 0x2903, 0x25D4, 0x2284, 0x1F15, 0x1B88, 0x17E0,
        0x1420, 0x1049, 0x0C5E, 0x0862, 0x0457, 0x0040, 0xFC20, 0xF7F9, 0xF3CE, 0xEFA1, 0xEB77, 0xE751, 0xE333, 0xDF1F, 0xDB19, 0xD723,
        0xD340, 0xCF73, 0xCBBF, 0xC827, 0xC4AD, 0xC153, 0xBE1E, 0xBB0E, 0xB827, 0xB56A, 0xB2DB, 0xB07A, 0xAE4B, 0xAC4F, 0xAA88, 0xA8F8,
        0xA7FE, 0xA73F, 0xA6BC, 0xA675, 0xA66B, 0xA69D, 0xA70B, 0xA7B5, 0xA89B, 0xA9BB, 0xAB16, 0xACA9, 0xAE75, 0xB078, 0xB2B1, 0xB51E,
        0xB7BD, 0xBA8D, 0xBD8B, 0xC0B7, 0xC40D, 0xC78B, 0xCB30, 0xCEF8, 0xD2E1, 0xD6E9, 0xDB0C, 0xDF48, 0xE39A, 0xE7FF, 0xEC75, 0xF0F8,
        0xF584, 0xFA18, 0xFEB0, 0x0348, 0x07DF, 0x0C70, 0x10F9, 0x1576, 0x19E5, 0x1E42, 0x228C, 0x26BD, 0x2AD5, 0x2ED0, 0x32AB, 0x3664,
        0x39F9, 0x3D66, 0x40AA, 0x43C3, 0x46AE, 0x4969, 0x4BF3, 0x4E49, 0x506B, 0x5256, 0x540B, 0x5586, 0x56C8, 0x57CF, 0x589B, 0x592C,
        0x5980, 0x5998, 0x5974, 0x5913, 0x5876, 0x579E, 0x568B, 0x553D, 0x53B6, 0x51F7, 0x5000, 0x4DD3, 0x4B72, 0x48DE, 0x4619, 0x4325,
        0x4003, 0x3CB7, 0x3941, 0x35A5, 0x31E5, 0x2E03, 0x2A02, 0x25E4, 0x21AD, 0x1D60, 0x18FF, 0x148D, 0x100D, 0x0B82, 0x06EF, 0x0258,
        0xFDC0, 0xF929, 0xF496, 0xF00B, 0xEB8B, 0xE718, 0xE2B7, 0xDE69, 0xDA31, 0xD614, 0xD212, 0xCE2F, 0xCA6E, 0xC6D1, 0xC35B, 0xC00E,
        0xBCEB, 0xB9F6, 0xB730, 0xB49B, 0xB239, 0xB00B, 0xAE13, 0xAC52, 0xAACA, 0xA97B, 0xA867, 0xA78D, 0xA6EF, 0xA68E, 0xA668, 0xA67F,
        0xA6D2, 0xA761, 0xA82C, 0xA932, 0xAA73, 0xABED, 0xADA0, 0xAF8B, 0xB1AB, 0xB401, 0xB689, 0xB944, 0xBC2D, 0xBF45, 0xC288, 0xC5F5,
        0xC988, 0xCD41, 0xD11C, 0xD516, 0xD92D, 0xDD5E, 0xE1A7, 0xE604, 0xEA73, 0xEEF0, 0xF378, 0xF80A, 0xFCA0, 0x0138, 0x05D0, 0x0A64,
        0x0EF1, 0x1374, 0x17E9, 0x1C4F, 0x20A2, 0x24DE, 0x2902, 0x2D0A, 0x30F4, 0x34BD, 0x3862, 0x3BE1, 0x3F38, 0x4265, 0x4564, 0x4835,
        0x4AD5, 0x4D43, 0x4F7C, 0x5181, 0x534E, 0x54E3, 0x563E, 0x5760, 0x5847, 0x58F2, 0x5962, 0x5995, 0x598C, 0x5946, 0x58C4, 0x5807,
        0x570E, 0x55DA, 0x546D, 0x52C6, 0x50E8, 0x4ED4, 0x4C8A, 0x4A0D, 0x475D, 0x447E, 0x4171, 0x3E37, 0x3AD4, 0x3748, 0x3398, 0x2FC5,
        0x2BD1, 0x27C1, 0x2395, 0x1F51, 0x1AF8, 0x168D, 0x1213, 0x0D8D, 0x08FD, 0x0468, 0xFFD0, 0xFB38, 0xF6A3, 0xF214, 0xED8F, 0xE916,
        0xE4AC, 0xE055, 0xDC13, 0xD7E9, 0xD3DB, 0xCFEA, 0xCC1A, 0xC86C, 0xC4E4, 0xC184, 0xBE4E, 0xBB44, 0xB869, 0xB5BD, 0xB344, 0xB0FF,
        0xAEEF, 0xAD15, 0xAB73, 0xAA0B, 0xA8DC, 0xA7E8, 0xA72F, 0xA6B2, 0xA671, 0xA66D, 0xA6A5, 0xA719, 0xA7CA, 0xA8B5, 0xA9DC, 0xAB3C,
        0xACD6, 0xAEA8, 0xB0B0, 0xB2EE, 0xB560, 0xB804, 0xBAD9, 0xBDDC, 0xC10C, 0xC466, 0xC7E9, 0xCB91, 0xCF5C, 0xD349, 0xD753, 0xDB79,
        0xDFB8, 0xE40C, 0xE873, 0xECEA, 0xF16E, 0xF5FC, 0xFA90, 0xFF28, 0x03C0, 0x0856, 0x0CE7, 0x116E, 0x15EB, 0x1A58, 0x1EB3, 0x22FA,
        0x272A, 0x2B3E, 0x2F36, 0x330E, 0x36C4, 0x3A54, 0x3DBE, 0x40FD, 0x4411, 0x46F7, 0x49AD, 0x4C32, 0x4E83, 0x50A0, 0x5286, 0x5434,
        0x55A9, 0x56E5, 0x57E7, 0x58AD, 0x5937, 0x5985, 0x5997, 0x596D, 0x5906, 0x5863, 0x5785, 0x566B, 0x5518, 0x538B, 0x51C6, 0x4FCA,
        0x4D97, 0x4B31, 0x4898, 0x45CE, 0x42D5, 0x3FAF, 0x3C5E, 0x38E4, 0x3544, 0x3181, 0x2D9B, 0x2997, 0x2577, 0x213E, 0x1CEE, 0x188B,
        0x1418, 0x0F96, 0x0B0B, 0x0677, 0x01E0, 0xFD48, 0xF8B1, 0xF41F, 0xEF95, 0xEB16, 0xE6A5, 0xE245, 0xDDFA, 0xD9C5, 0xD5AA, 0xD1AB,
        0xCDCC, 0xCA0E, 0xC675, 0xC303, 0xBFBA, 0xBC9C, 0xB9AB, 0xB6EA, 0xB45A, 0xB1FD, 0xAFD5, 0xADE3, 0xAC28, 0xAAA5, 0xA95C, 0xA84E,
        0xA77B, 0xA6E3, 0xA687, 0xA668, 0xA685, 0xA6DE, 0xA773, 0xA844, 0xA950, 0xAA97, 0xAC17, 0xADD0, 0xAFC0, 0xB1E6, 0xB441, 0xB6CE,
        0xB98D, 0xBC7C, 0xBF98, 0xC2E0, 0xC650, 0xC9E8, 0xCDA4, 0xD182, 0xD57F, 0xD999, 0xDDCD, 0xE218, 0xE677, 0xEAE7, 0xEF66, 0xF3EF,
        0xF881, 0xFD18, 0x01B0, 0x0647, 0x0ADB, 0x0F67, 0x13E9, 0x185D, 0x1CC1, 0x2111, 0x254C, 0x296D, 0x2D72, 0x3159, 0x351E, 0x38BF,
        0x3C3B, 0x3F8D, 0x42B5, 0x45B0, 0x487C, 0x4B17, 0x4D7F, 0x4FB4, 0x51B2, 0x537A, 0x5509, 0x565F, 0x577A, 0x585B, 0x5900, 0x596A,
        0x5997, 0x5987, 0x593B, 0x58B4, 0x57F0, 0x56F1, 0x55B8, 0x5444, 0x5298, 0x50B4, 0x4E9A, 0x4C4B, 0x49C9, 0x4715, 0x4430, 0x411E,
        0x3DE0, 0x3A79, 0x36EA, 0x3336, 0x2F5F, 0x2B69, 0x2755, 0x2326, 0x1EE1, 0x1A86, 0x1619, 0x119E, 0x0D16, 0x0886, 0x03F0, 0xFF58,
        0xFAC0, 0xF62C, 0xF19E, 0xED19, 0xE8A2, 0xE43A, 0xDFE5, 0xDBA5, 0xD77E, 0xD373, 0xCF85, 0xCBB8, 0xC80E, 0xC48A, 0xC12E, 0xBDFC,
        0xBAF7, 0xB821, 0xB57A, 0xB307, 0xB0C6, 0xAEBC, 0xACE8, 0xAB4C, 0xA9E9, 0xA8C0, 0xA7D2, 0xA71F, 0xA6A9, 0xA66E, 0xA670, 0xA6AE,
        0xA729, 0xA7DF, 0xA8D1, 0xA9FD, 0xAB63, 0xAD03, 0xAEDA, 0xB0E8, 0xB32B, 0xB5A3, 0xB84C, 0xBB25, 0xBE2D, 0xC162, 0xC4C0, 0xC846,
        0xCBF2, 0xCFC2, 0xD3B1, 0xD7BF, 0xDBE7, 0xE028, 0xE47E, 0xE8E7, 0xED60, 0xF1E5, 0xF673, 0xFB08, 0xFFA0, 0x0438, 0x08CE, 0x0D5D,
        0x11E4, 0x165F, 0x1ACB, 0x1F24, 0x2369, 0x2795, 0x2BA8, 0x2F9C, 0x3371, 0x3723, 0x3AAF, 0x3E14, 0x4150, 0x445F, 0x4740, 0x49F2,
        0x4C71, 0x4EBD, 0x50D4, 0x52B4, 0x545D, 0x55CC, 0x5702, 0x57FE, 0x58BE, 0x5942, 0x598A, 0x5996, 0x5965, 0x58F8, 0x584F, 0x576B,
        0x564B, 0x54F2, 0x535F, 0x5194, 0x4F93, 0x4D5B, 0x4AF0, 0x4851, 0x4583, 0x4285, 0x3F5A, 0x3C05, 0x3887, 0x34E4, 0x311C, 0x2D34,
        0x292D, 0x250A, 0x20CE, 0x1C7D, 0x1818, 0x13A2, 0x0F20, 0x0A93, 0x0600, 0x0168, 0xFCD0, 0xF839, 0xF3A8, 0xEF1F, 0xEAA1, 0xE632,
        0xE1D4, 0xDD8B, 0xD958, 0xD540, 0xD144, 0xCD69, 0xC9AF, 0xC619, 0xC2AB, 0xBF66, 0xBC4D, 0xB961, 0xB6A5, 0xB41A, 0xB1C3, 0xAFA0,
        0xADB3, 0xABFE, 0xAA81, 0xA93E, 0xA836, 0xA768, 0xA6D7, 0xA681, 0xA668, 0xA68B, 0xA6EA, 0xA786, 0xA85D, 0xA96F, 0xAABB, 0xAC41,
        0xAE00, 0xAFF5, 0xB221, 0xB481, 0xB714, 0xB9D8, 0xBCCB, 0xBFEC, 0xC338, 0xC6AD, 0xCA48, 0xCE08, 0xD1E9, 0xD5E9, 0xDA06, 0xDE3C,
        0xE289, 0xE6EA, 0xEB5C, 0xEFDC, 0xF466, 0xF8F9, 0xFD90, 0x0228, 0x06BF, 0x0B52, 0x0FDD, 0x145E, 0x18D1, 0x1D33, 0x2181, 0x25B9,
        0x29D7, 0x2DD9, 0x31BD, 0x357E, 0x391C, 0x3C93, 0x3FE2, 0x4305, 0x45FB, 0x48C2, 0x4B58, 0x4DBB, 0x4FEA, 0x51E3, 0x53A5, 0x552E,
        0x567E, 0x5794, 0x586F, 0x590E, 0x5971, 0x5998, 0x5982, 0x5930, 0x58A2, 0x57D9, 0x56D4, 0x5594, 0x541B, 0x5269, 0x5080, 0x4E60,
        0x4C0C, 0x4984, 0x46CB, 0x43E2, 0x40CC, 0x3D89, 0x3A1E, 0x368B, 0x32D3, 0x2EF9, 0x2AFF, 0x26E9, 0x22B8, 0x1E70, 0x1A13, 0x15A5,
        0x1128, 0x0C9F, 0x080E, 0x0378, 0xFEE0, 0xFA48, 0xF5B4, 0xF127, 0xECA4, 0xE82E, 0xE3C8, 0xDF75, 0xDB38, 0xD713, 0xD30A, 0xCF20,
        0xCB57, 0xC7B1, 0xC430, 0xC0D9, 0xBDAB, 0xBAAB, 0xB7D9, 0xB538, 0xB2C9, 0xB08F, 0xAE89, 0xACBB, 0xAB25, 0xA9C8, 0xA8A5, 0xA7BD,
        0xA711, 0xA6A0, 0xA66C, 0xA674, 0xA6B8, 0xA739, 0xA7F5, 0xA8ED, 0xAA1F, 0xAB8B, 0xAD30, 0xAF0D, 0xB121, 0xB36A, 0xB5E6, 0xB894,
        0xBB72, 0xBE7F, 0xC1B8, 0xC51A, 0xC8A5, 0xCC54, 0xD027, 0xD41A, 0xD82A, 0xDC55, 0xE098, 0xE4F1, 0xE95B, 0xEDD5, 0xF25B, 0xF6EB,
        0xFB80, 0x0018, 0x04B0, 0x0945, 0x0DD4, 0x125A, 0x16D3, 0x1B3D, 0x1F95, 0x23D7, 0x2801, 0x2C10, 0x3002, 0x33D3, 0x3781, 0x3B0A,
        0x3E6B, 0x41A2, 0x44AC, 0x4789, 0x4A35, 0x4CAF, 0x4EF6, 0x5107, 0x52E2, 0x5485, 0x55EF, 0x571F, 0x5814, 0x58CE, 0x594C, 0x598E,
        0x5993, 0x595D, 0x58EA, 0x583B, 0x5750, 0x562B, 0x54CC, 0x5333, 0x5163, 0x4F5B, 0x4D1E, 0x4AAD, 0x480A, 0x4537, 0x4234, 0x3F05,
        0x3BAC, 0x382A, 0x3483, 0x30B8, 0x2CCC, 0x28C2, 0x249D, 0x205F, 0x1C0B, 0x17A4, 0x132D, 0x0EAA, 0x0A1C, 0x0588, 0x00F0, 0xFC58,
        0xF7C2, 0xF331, 0xEEA9, 0xEA2D, 0xE5BF, 0xE163, 0xDD1C, 0xD8EC, 0xD4D7, 0xD0DE, 0xCD06, 0xC94F, 0xC5BE, 0xC254, 0xBF13, 0xBBFE,
        0xB917, 0xB660, 0xB3DB, 0xB188, 0xAF6B, 0xAD84, 0xABD4, 0xAA5E, 0xA921, 0xA81E, 0xA757, 0xA6CB, 0xA67C, 0xA669, 0xA692, 0xA6F7,
        0xA799, 0xA876, 0xA98E, 0xAAE1, 0xAC6C, 0xAE30, 0xB02C, 0xB25D, 0xB4C2, 0xB75A, 0xBA23, 0xBD1B, 0xC040, 0xC390, 0xC709, 0xCAA8,
        0xCE6B, 0xD250, 0xD653, 0xDA73, 0xDEAC, 0xE2FB, 0xE75E, 0xEBD1, 0xF052, 0xF4DE, 0xF971, 0xFE08, 0x02A0, 0x0737, 0x0BC9, 0x1053,
        0x14D3, 0x1944, 0x1DA4, 0x21F0, 0x2626, 0x2A41, 0x2E40, 0x3220, 0x35DE, 0x3978, 0x3CEC, 0x4036, 0x4354, 0x4646, 0x4908, 0x4B99,
        0x4DF7, 0x5020, 0x5214, 0x53D0, 0x5553, 0x569D, 0x57AD, 0x5882, 0x591B, 0x5978, 0x5998, 0x597D, 0x5925, 0x5890, 0x57C1, 0x56B6,
        0x5570, 0x53F1, 0x523A, 0x504B, 0x4E26, 0x4BCC, 0x493F, 0x4681, 0x4394, 0x4078, 0x3D32, 0x39C2, 0x362B, 0x3270, 0x2E92, 0x2A96,
        0x267C, 0x2249, 0x1DFF, 0x19A0, 0x1530, 0x10B2, 0x0C28, 0x0797, 0x0300, 0xFE68, 0xF9D0, 0xF53D, 0xF0B1, 0xEC2F, 0xE7BA, 0xE356,
        0xDF05, 0xDACA, 0xD6A9, 0xD2A3, 0xCEBC, 0xCAF6, 0xC753, 0xC3D7, 0xC084, 0xBD5B, 0xBA5F, 0xB792, 0xB4F6, 0xB28D, 0xB057, 0xAE58,
        0xAC8F, 0xAAFF, 0xA9A8, 0xA88B, 0xA7A9, 0xA702, 0xA698, 0xA66A, 0xA678, 0xA6C2, 0xA749, 0xA80B, 0xA909, 0xAA42, 0xABB4, 0xAD5F,
        0xAF41, 0xB15A, 0xB3A8, 0xB62A, 0xB8DD, 0xBBC0, 0xBED1, 0xC20E, 0xC575, 0xC903, 0xCCB7, 0xD08D, 0xD482, 0xD896, 0xDCC3, 0xE109,
        0xE563, 0xE9D0, 0xEE4B, 0xF2D2, 0xF762, 0xFBF8, 0x0090, 0x0528, 0x09BD, 0x0E4B, 0x12CF, 0x1747, 0x1BAF, 0x2005, 0x2445, 0x286C,
        0x2C79, 0x3067, 0x3435, 0x37DF, 0x3B64, 0x3EC1, 0x41F3, 0x44F9, 0x47D1, 0x4A78, 0x4CED, 0x4F2E, 0x513A, 0x530F, 0x54AC, 0x5610,
        0x573A, 0x582A, 0x58DD, 0x5955, 0x5991, 0x5991, 0x5954, 0x58DA, 0x5825, 0x5735, 0x560A, 0x54A4, 0x5306, 0x5130, 0x4F23, 0x4CE1,
        0x4A6B, 0x47C3, 0x44EA, 0x41E3, 0x3EB0, 0x3B52, 0x37CC, 0x3421, 0x3053, 0x2C64, 0x2857, 0x242F, 0x1FEE, 0x1B99, 0x1730, 0x12B8,
        0x0E33, 0x09A5, 0x0510, 0x0078, 0xFBE0, 0xF74A, 0xF2BA, 0xEE33, 0xE9B8, 0xE54C, 0xE0F2, 0xDCAD, 0xD880, 0xD46D, 0xD078, 0xCCA3,
        0xC8F0, 0xC563, 0xC1FD, 0xBEC1, 0xBBB0, 0xB8CE, 0xB61C, 0xB39C, 0xB14F, 0xAF37, 0xAD55, 0xABAB, 0xAA3B, 0xA903, 0xA807, 0xA746,
        0xA6C0, 0xA677, 0xA66A, 0xA699, 0xA705, 0xA7AD, 0xA890, 0xA9AE, 0xAB06, 0xAC98, 0xAE62, 0xB062, 0xB299, 0xB503, 0xB7A0, 0xBA6E,
        0xBD6B, 0xC095, 0xC3E9, 0xC766, 0xCB09, 0xCED0, 0xD2B7, 0xD6BE, 0xDAE0, 0xDF1B, 0xE36D, 0xE7D1, 0xEC46, 0xF0C8, 0xF555, 0xF9E8,
        0xFE80, 0x0318, 0x07AF, 0x0C40, 0x10C9, 0x1547, 0x19B7, 0x1E15, 0x225F, 0x2692, 0x2AAB, 0x2EA7, 0x3284, 0x363E, 0x39D4, 0x3D43,
        0x4089, 0x43A3, 0x4690, 0x494D, 0x4BD9, 0x4E32, 0x5056, 0x5243, 0x53FA, 0x5578, 0x56BC, 0x57C6, 0x5894, 0x5927, 0x597E, 0x5998,
        0x5976, 0x5918, 0x587E, 0x57A8, 0x5697, 0x554C, 0x53C7, 0x520A, 0x5015, 0x4DEB, 0x4B8C, 0x48FA, 0x4637, 0x4345, 0x4025, 0x3CDA,
        0x3966, 0x35CB, 0x320C, 0x2E2C, 0x2A2C, 0x2610, 0x21DA, 0x1D8D, 0x192D, 0x14BB, 0x103C, 0x0BB1, 0x071F, 0x0288, 0xFDF0, 0xF959,
        0xF4C6, 0xF03A, 0xEBBA, 0xE747, 0xE2E4, 0xDE95, 0xDA5D, 0xD63E, 0xD23B, 0xCE57, 0xCA95, 0xC6F6, 0xC37E, 0xC02F, 0xBD0B, 0xBA14,
        0xB74C, 0xB4B5, 0xB251, 0xB021, 0xAE27, 0xAC64, 0xAAD9, 0xA988, 0xA871, 0xA795, 0xA6F5, 0xA690, 0xA668, 0xA67D, 0xA6CD, 0xA75A,
        0xA823, 0xA926, 0xAA65, 0xABDD, 0xAD8D, 0xAF75, 0xB194, 0xB3E7, 0xB66E, 0xB926, 0xBC0E, 0xBF24, 0xC265, 0xC5D0, 0xC962, 0xCD19,
        0xD0F3, 0xD4EC, 0xD902, 0xDD32, 0xE17A, 0xE5D6, 0xEA44, 0xEEC1, 0xF349, 0xF7DA, 0xFC70, 0x0108, 0x05A0, 0x0A34, 0x0EC1, 0x1345,
        0x17BB, 0x1C22, 0x2075, 0x24B3, 0x28D7, 0x2CE1, 0x30CC, 0x3496, 0x383D, 0x3BBE, 0x3F16, 0x4244, 0x4546, 0x4819, 0x4ABB, 0x4D2A,
        0x4F66, 0x516D, 0x533C, 0x54D3, 0x5631, 0x5756, 0x583F, 0x58EC, 0x595E, 0x5994, 0x598D, 0x594A, 0x58CB, 0x5810, 0x5719, 0x55E8,
        0x547D, 0x52D9, 0x50FD, 0x4EEB, 0x4CA3, 0x4A28, 0x477A, 0x449D, 0x4191, 0x3E5A, 0x3AF8, 0x376E, 0x33BF, 0x2FED, 0x2BFB, 0x27EC,
        0x23C1, 0x1F7E, 0x1B26, 0x16BC, 0x1242, 0x0DBC, 0x092D, 0x0498, 0x0000, 0xFB68, 0xF6D3, 0xF244, 0xEDBE, 0xE944, 0xE4DA, 0xE082,
        0xDC3F, 0xD814, 0xD405, 0xD013, 0xCC41, 0xC892, 0xC508, 0xC1A6, 0xBE6F, 0xBB63, 0xB886, 0xB5D8, 0xB35D, 0xB115, 0xAF03, 0xAD27,
        0xAB83, 0xAA18, 0xA8E7, 0xA7F0, 0xA735, 0xA6B6, 0xA673, 0xA66C, 0xA6A2, 0xA714, 0xA7C1, 0xA8AA, 0xA9CF, 0xAB2D, 0xACC4, 0xAE93,
        0xB09A, 0xB2D6, 0xB545, 0xB7E7, 0xBABA, 0xBDBC, 0xC0EA, 0xC442, 0xC7C3, 0xCB6A, 0xCF34, 0xD31F, 0xD729, 0xDB4D, 0xDF8B, 0xE3DE,
        0xE845, 0xECBB, 0xF13F, 0xF5CC, 0xFA60, 0xFEF8, 0x0390, 0x0826, 0x0CB7, 0x113F, 0x15BC, 0x1A2A, 0x1E86, 0x22CE, 0x26FE, 0x2B14,
        0x2F0D, 0x32E7, 0x369E, 0x3A30, 0x3D9B, 0x40DC, 0x43F2, 0x46DA, 0x4992, 0x4C19, 0x4E6C, 0x508B, 0x5273, 0x5423, 0x559B, 0x56DA,
        0x57DD, 0x58A6, 0x5933, 0x5983, 0x5998, 0x5970, 0x590B, 0x586B, 0x578F, 0x5678, 0x5527, 0x539C, 0x51D9, 0x4FDF, 0x4DAF, 0x4B4B,
        0x48B4, 0x45EC, 0x42F5, 0x3FD1, 0x3C82, 0x390A, 0x356B, 0x31A9, 0x2DC5, 0x29C2, 0x25A3, 0x216B, 0x1D1C, 0x18B9, 0x1446, 0x0FC6,
        0x0B3A, 0x06A7, 0x0210, 0xFD78, 0xF8E1, 0xF44F, 0xEFC4, 0xEB45, 0xE6D3, 0xE273, 0xDE26, 0xD9F0, 0xD5D4, 0xD1D4, 0xCDF4, 0xCA35,
        0xC69A, 0xC326, 0xBFDB, 0xBCBB, 0xB9C9, 0xB706, 0xB474, 0xB215, 0xAFEB, 0xADF6, 0xAC39, 0xAAB4, 0xA969, 0xA858, 0xA782, 0xA6E8,
        0xA68A, 0xA668, 0xA682, 0xA6D9, 0xA76C, 0xA83A, 0xA944, 0xAA88, 0xAC06, 0xADBD, 0xAFAA, 0xB1CE, 0xB427, 0xB6B3, 0xB970, 0xBC5D,
        0xBF77, 0xC2BD, 0xC62C, 0xC9C2, 0xCD7C, 0xD159, 0xD555, 0xD96E, 0xDDA1, 0xE1EB, 0xE649, 0xEAB9, 0xEF37, 0xF3C0, 0xF851, 0xFCE8,
        0x0180, 0x0618, 0x0AAB, 0x0F38, 0x13BA, 0x182F, 0x1C93, 0x20E5, 0x2520, 0x2942, 0x2D49, 0x3130, 0x34F7, 0x389A, 0x3C17, 0x3F6B,
        0x4295, 0x4592, 0x4860, 0x4AFD, 0x4D67, 0x4F9E, 0x519E, 0x5368, 0x54FA, 0x5652, 0x5770, 0x5853, 0x58FB, 0x5967, 0x5996, 0x5989,
        0x5940, 0x58BA, 0x57F9, 0x56FD, 0x55C5, 0x5455, 0x52AB, 0x50C9, 0x4EB1, 0x4C64, 0x49E4, 0x4732, 0x4450, 0x413F, 0x3E03, 0x3A9D,
        0x3710, 0x335D, 0x2F88, 0x2B93, 0x2780, 0x2353, 0x1F0E, 0x1AB4, 0x1648, 0x11CD, 0x0D46, 0x08B6, 0x0420, 0xFF88, 0xFAF0, 0xF65B,
        0xF1CD, 0xED48, 0xE8D0, 0xE467, 0xE012, 0xDBD1, 0xD7A9, 0xD39C, 0xCFAD, 0xCBDF, 0xC834, 0xC4AE, 0xC150, 0xBE1D, 0xBB16, 0xB83D,
        0xB595, 0xB31F, 0xB0DD, 0xAED0, 0xACFA, 0xAB5C, 0xA9F6, 0xA8CB, 0xA7DB, 0xA726, 0xA6AC, 0xA66F, 0xA66F, 0xA6AB, 0xA723, 0xA7D6,
        0xA8C6, 0xA9F0, 0xAB54, 0xACF1, 0xAEC6, 0xB0D2, 0xB313, 0xB588, 0xB82F, 0xBB07, 0xBE0D, 0xC13F, 0xC49C, 0xC821, 0xCBCB, 0xCF99,
        0xD387, 0xD794, 0xDBBB, 0xDFFB, 0xE451, 0xE8B9, 0xED31, 0xF1B5, 0xF643, 0xFAD8, 0xFF70, 0x0408, 0x089E, 0x0D2E, 0x11B5, 0x1630,
        0x1A9D, 0x1EF7, 0x233D, 0x276A, 0x2B7E, 0x2F73, 0x3349, 0x36FD, 0x3A8B, 0x3DF2, 0x412F, 0x4440, 0x4723, 0x49D6, 0x4C58, 0x4EA6,
        0x50BF, 0x52A1, 0x544C, 0x55BE, 0x56F7, 0x57F5, 0x58B7, 0x593E, 0x5988, 0x5996, 0x5968, 0x58FE, 0x5857, 0x5775, 0x5658, 0x5501,
        0x5371, 0x51A8, 0x4FA9, 0x4D73, 0x4B0A, 0x486E, 0x45A1, 0x42A5, 0x3F7C, 0x3C29, 0x38AD, 0x350A, 0x3144, 0x2D5D, 0x2957, 0x2536,
        0x20FB, 0x1CAA, 0x1846, 0x13D1, 0x0F4F, 0x0AC3, 0x0630, 0x0198, 0xFD00, 0xF869, 0xF3D8, 0xEF4E, 0xEAD0, 0xE660, 0xE201, 0xDDB7,
        0xD984, 0xD56A, 0xD16E, 0xCD90, 0xC9D5, 0xC63E, 0xC2CE, 0xBF88, 0xBC6C, 0xB97F, 0xB6C1, 0xB434, 0xB1DA, 0xAFB5, 0xADC6, 0xAC0F,
        0xAA90, 0xA94A, 0xA83F, 0xA770, 0xA6DB, 0xA683, 0xA668, 0xA688, 0xA6E5, 0xA77E, 0xA853, 0xA963, 0xAAAD, 0xAC30, 0xADEC, 0xAFE0,
        0xB209, 0xB467, 0xB6F8, 0xB9BA, 0xBCAC, 0xBFCA, 0xC314, 0xC688, 0xCA22, 0xCDE0, 0xD1C0, 0xD5BF, 0xD9DA, 0xDE10, 0xE25C, 0xE6BC,
        0xEB2D, 0xEFAD, 0xF437, 0xF8C9, 0xFD60, 0x01F8, 0x068F, 0x0B22, 0x0FAE, 0x142F, 0x18A2, 0x1D05, 0x2154, 0x258D, 0x29AD, 0x2DB0,
        0x3195, 0x3558, 0x38F7, 0x3C70, 0x3FC0, 0x42E5, 0x45DD, 0x48A6, 0x4B3E, 0x4DA3, 0x4FD4, 0x51D0, 0x5394, 0x551F, 0x5672, 0x578A,
        0x5867, 0x5909, 0x596E, 0x5997, 0x5984, 0x5935, 0x58A9, 0x57E2, 0x56DF, 0x55A2, 0x542C, 0x527C, 0x5095, 0x4E78, 0x4C25, 0x49A0,
        0x46E9, 0x4402, 0x40ED, 0x3DAC, 0x3A42, 0x36B1, 0x32FA, 0x2F22, 0x2B29, 0x2714, 0x22E4, 0x1E9D, 0x1A41, 0x15D3, 0x1157, 0x0CCF,
        0x083E, 0x03A8, 0xFF10, 0xFA78, 0xF5E4, 0xF156, 0xECD3, 0xE85C, 0xE3F5, 0xDFA1, 0xDB63, 0xD73E, 0xD334, 0xCF48, 0xCB7D, 0xC7D6,
        0xC454, 0xC0FB, 0xBDCC, 0xBAC9, 0xB7F6, 0xB553, 0xB2E2, 0xB0A5, 0xAE9D, 0xACCD, 0xAB34, 0xA9D5, 0xA8B0, 0xA7C5, 0xA716, 0xA6A3,
        0xA66D, 0xA672, 0xA6B4, 0xA732, 0xA7EC, 0xA8E1, 0xAA11, 0xAB7B, 0xAD1E, 0xAEF9, 0xB10A, 0xB351, 0xB5CB, 0xB877, 0xBB54, 0xBE5E,
        0xC195, 0xC4F6, 0xC87F, 0xCC2D, 0xCFFE, 0xD3F0, 0xD7FF, 0xDC29, 0xE06B, 0xE4C3, 0xE92D, 0xEDA6, 0xF22C, 0xF6BB, 0xFB50, 0xFFE8,
        0x0480, 0x0915, 0x0DA5, 0x122B, 0x16A5, 0x1B0F, 0x1F68, 0x23AB, 0x27D6, 0x2BE6, 0x2FD9, 0x33AC, 0x375B, 0x3AE6, 0x3E48, 0x4181,
        0x448E, 0x476C, 0x4A1A, 0x4C96, 0x4EDF, 0x50F3, 0x52D0, 0x5475, 0x55E1, 0x5713, 0x580B, 0x58C7, 0x5948, 0x598C, 0x5994, 0x5960,
        0x58EF, 0x5843, 0x575B, 0x5638, 0x54DB, 0x5345, 0x5177, 0x4F71, 0x4D37, 0x4AC8, 0x4827, 0x4555, 0x4255, 0x3F27, 0x3BD0, 0x384F,
        0x34A9, 0x30E0, 0x2CF6, 0x28ED, 0x24C8, 0x208B, 0x1C38, 0x17D2, 0x135C, 0x0ED9, 0x0A4C, 0x05B8, 0x0120, 0xFC88, 0xF7F2, 0xF361,
        0xEED8, 0xEA5B, 0xE5ED, 0xE190, 0xDD48, 0xD917, 0xD501, 0xD107, 0xCD2D, 0xC975, 0xC5E2, 0xC277, 0xBF34, 0xBC1E, 0xB935, 0xB67C,
        0xB3F4, 0xB1A0, 0xAF80, 0xAD97, 0xABE5, 0xAA6C, 0xA92C, 0xA827, 0xA75E, 0xA6D0, 0xA67E, 0xA668, 0xA68F, 0xA6F2, 0xA791, 0xA86C,
        0xA982, 0xAAD2, 0xAC5B, 0xAE1D, 0xB016, 0xB245, 0xB4A8, 0xB73E, 0xBA05, 0xBCFB, 0xC01E, 0xC36D, 0xC6E4, 0xCA82, 0xCE43, 0xD227,
        0xD629, 0xDA47, 0xDE7F, 0xE2CD, 0xE72F, 0xEBA2, 0xF023, 0xF4AE, 0xF941, 0xFDD8, 0x0270, 0x0707, 0x0B9A, 0x1024, 0x14A4, 0x1916,
        0x1D77, 0x21C4, 0x25FA, 0x2A17, 0x2E17, 0x31F8, 0x35B8, 0x3953, 0x3CC8, 0x4014, 0x4335, 0x4628, 0x48EC, 0x4B7F, 0x4DDF, 0x500B,
        0x5200, 0x53BF, 0x5545, 0x5691, 0x57A3, 0x587A, 0x5916, 0x5975, 0x5998, 0x597F, 0x5929, 0x5898, 0x57CA, 0x56C2, 0x557F, 0x5402,
        0x524D, 0x5060, 0x4E3D, 0x4BE6, 0x495B, 0x469F, 0x43B3, 0x409A, 0x3D55, 0x39E7, 0x3651, 0x3297, 0x2EBC, 0x2AC0, 0x26A8, 0x2275,
        0x1E2C, 0x19CE, 0x155F, 0x10E1, 0x0C58, 0x07C7, 0x0330, 0xFE98, 0xFA00, 0xF56D, 0xF0E0, 0xEC5E, 0xE7E8, 0xE383, 0xDF32, 0xDAF6,
        0xD6D3, 0xD2CC, 0xCEE4, 0xCB1C, 0xC779, 0xC3FB, 0xC0A6, 0xBD7B, 0xBA7D, 0xB7AF, 0xB510, 0xB2A5, 0xB06D, 0xAE6C, 0xACA1, 0xAB0E,
        0xA9B5, 0xA895, 0xA7B1, 0xA708, 0xA69B, 0xA66A, 0xA676, 0xA6BE, 0xA742, 0xA802, 0xA8FE, 0xAA34, 0xABA3, 0xAD4C, 0xAF2C, 0xB143,
        0xB38F, 0xB60E, 0xB8C0, 0xBBA1, 0xBEB0, 0xC1EC, 0xC551, 0xC8DD, 0xCC8F, 0xD064, 0xD458, 0xD86B, 0xDC97, 0xE0DC, 0xE535, 0xE9A1,
        0xEE1C, 0xF2A3, 0xF732, 0xFBC8, 0x0060, 0x04F8, 0x098D, 0x0E1B, 0x12A0, 0x1719, 0x1B82, 0x1FD8, 0x2419, 0x2841, 0x2C4F, 0x303E,
        0x340E, 0x37BA, 0x3B40, 0x3E9E, 0x41D3, 0x44DB, 0x47B4, 0x4A5D, 0x4CD5, 0x4F18, 0x5126, 0x52FD, 0x549D, 0x5603, 0x572F, 0x5821,
        0x58D7, 0x5952, 0x5990, 0x5992, 0x5957, 0x58E1, 0x582E, 0x5740, 0x5617, 0x54B4, 0x5318, 0x5144, 0x4F3A, 0x4CF9, 0x4A86, 0x47DF,
        0x4509, 0x4204, 0x3ED2, 0x3B76, 0x37F2, 0x3448, 0x307B, 0x2C8D, 0x2882, 0x245B, 0x201B, 0x1BC6, 0x175E, 0x12E7, 0x0E62, 0x09D4,
        0x0540, 0x00A8, 0xFC10, 0xF77A, 0xF2EA, 0xEE62, 0xE9E7, 0xE57A, 0xE11F, 0xDCDA, 0xD8AB, 0xD497, 0xD0A1, 0xCCCA, 0xC916, 0xC587,
        0xC220, 0xBEE2, 0xBBD0, 0xB8EB, 0xB637, 0xB3B5, 0xB166, 0xAF4C, 0xAD68, 0xABBC, 0xAA48, 0xA90F, 0xA810, 0xA74C, 0xA6C5, 0xA679,
        0xA669, 0xA696, 0xA700, 0xA7A5, 0xA886, 0xA9A1, 0xAAF7, 0xAC86, 0xAE4E, 0xB04C, 0xB281, 0xB4E9, 0xB784, 0xBA50, 0xBD4B, 0xC073,
        0xC3C5, 0xC741, 0xCAE2, 0xCEA7, 0xD28E, 0xD693, 0xDAB4, 0xDEEF, 0xE33F, 0xE7A3, 0xEC17, 0xF099, 0xF525, 0xF9B9, 0xFE50, 0x02E8,
        0x077F, 0x0C11, 0x109A, 0x1519, 0x1989, 0x1DE8, 0x2233, 0x2667, 0x2A81, 0x2E7E, 0x325C, 0x3618, 0x39B0, 0x3D20, 0x4068, 0x4384,
        0x4673, 0x4932, 0x4BBF, 0x4E1A, 0x5040, 0x5230, 0x53E9, 0x5569, 0x56B0, 0x57BC, 0x588D, 0x5922, 0x597B, 0x5998, 0x5979, 0x591D,
        0x5885, 0x57B2, 0x56A4, 0x555B, 0x53D8, 0x521D, 0x502B, 0x4E03, 0x4BA6, 0x4916, 0x4655, 0x4364, 0x4046, 0x3CFD, 0x398B, 0x35F2,
        0x3234, 0x2E55, 0x2A56, 0x263B, 0x2206, 0x1DBB, 0x195B, 0x14EA, 0x106B, 0x0BE1, 0x074F, 0x02B8, 0xFE20, 0xF989, 0xF4F5, 0xF06A,
        0xEBE8, 0xE775, 0xE312, 0xDEC2, 0xDA89, 0xD669, 0xD265, 0xCE7F, 0xCABC, 0xC71C, 0xC3A2, 0xC051, 0xBD2B, 0xBA32, 0xB768, 0xB4CF,
        0xB269, 0xB036, 0xAE3A, 0xAC75, 0xAAE8, 0xA995, 0xA87B, 0xA79D, 0xA6FA, 0xA693, 0xA669, 0xA67B, 0xA6C9, 0xA753, 0xA819, 0xA91B,
        0xAA57, 0xABCC, 0xAD7A, 0xAF60, 0xB17D, 0xB3CE, 0xB653, 0xB909, 0xBBEF, 0xBF03, 0xC242, 0xC5AC, 0xC93C, 0xCCF2, 0xD0CA, 0xD4C2,
        0xD8D6, 0xDD06, 0xE14D, 0xE5A8, 0xEA15, 0xEE92, 0xF319, 0xF7AA, 0xFC40, 0x00D8, 0x0570, 0x0A04, 0x0E92, 0x1316, 0x178D, 0x1BF4,
        0x2048, 0x2487, 0x28AD, 0x2CB7, 0x30A4, 0x346F, 0x3817, 0x3B9A, 0x3EF4, 0x4224, 0x4527, 0x47FC, 0x4AA0, 0x4D12, 0x4F50, 0x5158,
        0x532A, 0x54C4, 0x5624, 0x574B, 0x5836, 0x58E7, 0x595B, 0x5993, 0x598F, 0x594E, 0x58D1, 0x5818, 0x5724, 0x55F5, 0x548D, 0x52EB,
        0x5111, 0x4F01, 0x4CBC, 0x4A43, 0x4797, 0x44BC, 0x41B2, 0x3E7C, 0x3B1C, 0x3794, 0x33E6, 0x3016, 0x2C25, 0x2817, 0x23ED, 0x1FAB,
        0x1B54, 0x16EA, 0x1271, 0x0DEC, 0x095D, 0x04C8, 0x0030, 0xFB98, 0xF703, 0xF273, 0xEDED, 0xE973, 0xE508, 0xE0AF, 0xDC6B, 0xD83F,
        0xD42F, 0xD03B, 0xCC68, 0xC8B8, 0xC52C, 0xC1C9, 0xBE8F, 0xBB82, 0xB8A3, 0xB5F3, 0xB376, 0xB12C, 0xAF18, 0xAD3A, 0xAB93, 0xAA26,
        0xA8F2, 0xA7F9, 0xA73C, 0xA6BA, 0xA674, 0xA66B, 0xA69E, 0xA70E, 0xA7B9, 0xA8A0, 0xA9C2, 0xAB1D, 0xACB2, 0xAE7F, 0xB084, 0xB2BD,
        0xB52B, 0xB7CB, 0xBA9C, 0xBD9B, 0xC0C8, 0xC41F, 0xC79E, 0xCB43, 0xCF0C, 0xD2F6, 0xD6FE, 0xDB22, 0xDF5E, 0xE3B1, 0xE817, 0xEC8C,
        0xF10F, 0xF59C, 0xFA30, 0xFEC8, 0x0360, 0x07F6, 0x0C88, 0x1110, 0x158D, 0x19FC, 0x1E59, 0x22A2, 0x26D3, 0x2AEA, 0x2EE4, 0x32BF,
        0x3678, 0x3A0B, 0x3D78, 0x40BB, 0x43D3, 0x46BC, 0x4977, 0x4BFF, 0x4E55, 0x5075, 0x5260, 0x5413, 0x558D, 0x56CE, 0x57D4, 0x589F,
        0x592E, 0x5981, 0x5998, 0x5972, 0x5911, 0x5873, 0x5799, 0x5685, 0x5536, 0x53AE, 0x51ED, 0x4FF5, 0x4DC7, 0x4B65, 0x48D0, 0x460A,
        0x4315, 0x3FF2, 0x3CA5, 0x392F, 0x3592, 0x31D1, 0x2DEE, 0x29EC, 0x25CF, 0x2197, 0x1D49, 0x18E8, 0x1475, 0x0FF5, 0x0B6A, 0x06D7,
        0x0240, 0xFDA8, 0xF911, 0xF47E, 0xEFF3, 0xEB73, 0xE701, 0xE2A0, 0xDE53, 0xDA1C, 0xD5FE, 0xD1FD, 0xCE1B, 0xCA5B, 0xC6BF, 0xC349,
        0xBFFD, 0xBCDB, 0xB9E7, 0xB722, 0xB48E, 0xB22D, 0xB000, 0xAE09, 0xAC4A, 0xAAC3, 0xA975, 0xA862, 0xA78A, 0xA6ED, 0xA68C, 0xA668,
        0xA680, 0xA6D4, 0xA765, 0xA831, 0xA938, 0xAA7A, 0xABF5, 0xADAA, 0xAF95, 0xB1B7, 0xB40D, 0xB697, 0xB952, 0xBC3D, 0xBF56, 0xC29A,
        0xC607, 0xC99C, 0xCD55, 0xD130, 0xD52B, 0xD943, 0xDD74, 0xE1BE, 0xE61B, 0xEA8A, 0xEF07, 0xF390, 0xF821, 0xFCB8, 0x0150, 0x05E8,
        0x0A7C, 0x0F08, 0x138B, 0x1801, 0x1C66, 0x20B8, 0x24F4, 0x2917, 0x2D1F, 0x3108, 0x34D0, 0x3875, 0x3BF3, 0x3F49, 0x4275, 0x4573,
        0x4843, 0x4AE2, 0x4D4F, 0x4F88, 0x518B, 0x5357, 0x54EA, 0x5645, 0x5765, 0x584B, 0x58F5, 0x5963, 0x5995, 0x598B, 0x5944, 0x58C1,
        0x5802, 0x5708, 0x55D3, 0x5465, 0x52BD, 0x50DE, 0x4EC8, 0x4C7D, 0x49FF, 0x474F, 0x446F, 0x4160, 0x3E26, 0x3AC1, 0x3735, 0x3384,
        0x2FB0, 0x2BBC, 0x27AB, 0x237F, 0x1F3B, 0x1AE1, 0x1676, 0x11FC, 0x0D75, 0x08E6, 0x0450, 0xFFB8, 0xFB20, 0xF68B, 0xF1FC, 0xED77,
        0xE8FE, 0xE495, 0xE03E, 0xDBFD, 0xD7D4, 0xD3C6, 0xCFD6, 0xCC06, 0xC859, 0xC4D2, 0xC173, 0xBE3E, 0xBB35, 0xB85A, 0xB5B0, 0xB338,
        0xB0F3, 0xAEE4, 0xAD0C, 0xAB6B, 0xAA04, 0xA8D6, 0xA7E3, 0xA72C, 0xA6B0, 0xA671, 0xA66E, 0xA6A7, 0xA71C, 0xA7CE, 0xA8BB, 0xA9E2,
        0xAB44, 0xACDF, 0xAEB2, 0xB0BB, 0xB2FA, 0xB56D, 0xB812, 0xBAE8, 0xBDEC, 0xC11D, 0xC478, 0xC7FB, 0xCBA4, 0xCF71, 0xD35E, 0xD769,
        0xDB8F, 0xDFCE, 0xE423, 0xE88A, 0xED02, 0xF186, 0xF614, 0xFAA8, 0xFF40, 0x03D8, 0x086E, 0x0CFE, 0x1186, 0x1602, 0x1A6F, 0x1ECA,
        0x2310, 0x273F, 0x2B54, 0x2F4B, 0x3322, 0x36D7, 0x3A67, 0x3DCF, 0x410E, 0x4421, 0x4706, 0x49BB, 0x4C3F, 0x4E8F, 0x50AA, 0x528F,
        0x543C, 0x55B1, 0x56EB, 0x57EB, 0x58B0, 0x5939, 0x5986, 0x5997, 0x596B, 0x5903, 0x585F, 0x5780, 0x5665, 0x5510, 0x5382, 0x51BC,
        0x4FBF, 0x4D8B, 0x4B24, 0x488A, 0x45BF, 0x42C5, 0x3F9E, 0x3C4C, 0x38D2, 0x3531, 0x316D, 0x2D87, 0x2982, 0x2562, 0x2128, 0x1CD8,
        0x1874, 0x1400, 0x0F7F, 0x0AF3, 0x065F, 0x01C8, 0xFD30, 0xF899, 0xF407, 0xEF7D, 0xEAFF, 0xE68E, 0xE22F, 0xDDE3, 0xD9AF, 0xD594,
        0xD197, 0xCDB8, 0xC9FB, 0xC663, 0xC2F1, 0xBFA9, 0xBC8C, 0xB99C, 0xB6DC, 0xB44D, 0xB1F2, 0xAFCA, 0xADD9, 0xAC1F, 0xAA9E, 0xA956,
        0xA849, 0xA777, 0xA6E0, 0xA686, 0xA668, 0xA686, 0xA6E0, 0xA777, 0xA849, 0xA956, 0xAA9E, 0xAC1F, 0xADD9, 0xAFCA, 0xB1F2, 0xB44D,
        0xB6DC, 0xB99C, 0xBC8C, 0xBFA9, 0xC2F1, 0xC663, 0xC9FB, 0xCDB8, 0xD197, 0xD594, 0xD9AF, 0xDDE3, 0xE22F, 0xE68E, 0xEAFF, 0xEF7D,
        0xF407, 0xF899, 0xFD30, 0x01C8, 0x065F, 0x0AF3, 0x0F7F, 0x1400, 0x1874, 0x1CD8, 0x2128, 0x2562, 0x2982, 0x2D87, 0x316D, 0x3531,
        0x38D2, 0x3C4C, 0x3F9E, 0x42C5, 0x45BF, 0x488A, 0x4B24, 0x4D8B, 0x4FBF, 0x51BC, 0x5382, 0x5510, 0x5665, 0x5780, 0x585F, 0x5903,
        0x596B, 0x5997, 0x5986, 0x5939, 0x58B0, 0x57EB, 0x56EB, 0x55B1, 0x543C, 0x528F, 0x50AA, 0x4E8F, 0x4C3F, 0x49BB, 0x4706, 0x4421,
        0x410E, 0x3DCF, 0x3A67, 0x36D7, 0x3322, 0x2F4B, 0x2B54, 0x273F, 0x2310, 0x1ECA, 0x1A6F, 0x1602, 0x1186, 0x0CFE, 0x086E, 0x03D8,
        0xFF40, 0xFAA8, 0xF614, 0xF186, 0xED02, 0xE88A, 0xE423, 0xDFCE, 0xDB8F, 0xD769, 0xD35E, 0xCF71, 0xCBA4, 0xC7FB, 0xC478, 0xC11D,
        0xBDEC, 0xBAE8, 0xB812, 0xB56D, 0xB2FA, 0xB0BB, 0xAEB2, 0xACDF, 0xAB44, 0xA9E2, 0xA8BB, 0xA7CE, 0xA71C, 0xA6A7, 0xA66E, 0xA671,
        0xA6B0, 0xA72C, 0xA7E3, 0xA8D6, 0xAA04, 0xAB6B, 0xAD0C, 0xAEE4, 0xB0F3, 0xB338, 0xB5B0, 0xB85A, 0xBB35, 0xBE3E, 0xC173, 0xC4D2,
        0xC859, 0xCC06, 0xCFD6, 0xD3C6, 0xD7D4, 0xDBFD, 0xE03E, 0xE495, 0xE8FE, 0xED77, 0xF1FC, 0xF68B, 0xFB20, 0xFFB8, 0x0450, 0x08E6,
        0x0D75, 0x11FC, 0x1676, 0x1AE1, 0x1F3B, 0x237F, 0x27AB, 0x2BBC, 0x2FB0, 0x3384, 0x3735, 0x3AC1, 0x3E26, 0x4160, 0x446F, 0x474F,
        0x49FF, 0x4C7D, 0x4EC8, 0x50DE, 0x52BD, 0x5465, 0x55D3, 0x5708, 0x5802, 0x58C1, 0x5944, 0x598B, 0x5995, 0x5963, 0x58F5, 0x584B,
        0x5765, 0x5645, 0x54EA, 0x5357, 0x518B, 0x4F88, 0x4D4F, 0x4AE2, 0x4843, 0x4573, 0x4275, 0x3F49, 0x3BF3, 0x3875, 0x34D0, 0x3108,
        0x2D1F, 0x2917, 0x24F4, 0x20B8, 0x1C66, 0x1801, 0x138B, 0x0F08, 0x0A7C, 0x05E8, 0x0150, 0xFCB8, 0xF821, 0xF390, 0xEF07, 0xEA8A,
        0xE61B, 0xE1BE, 0xDD74, 0xD943, 0xD52B, 0xD130, 0xCD55, 0xC99C, 0xC607, 0xC29A, 0xBF56, 0xBC3D, 0xB952, 0xB697, 0xB40D, 0xB1B7,
        0xAF95, 0xADAA, 0xABF5, 0xAA7A, 0xA938, 0xA831, 0xA765, 0xA6D4, 0xA680, 0xA668, 0xA68C, 0xA6ED, 0xA78A, 0xA862, 0xA975, 0xAAC3,
        0xAC4A, 0xAE09, 0xB000, 0xB22D, 0xB48E, 0xB722, 0xB9E7, 0xBCDB, 0xBFFD, 0xC349, 0xC6BF, 0xCA5B, 0xCE1B, 0xD1FD, 0xD5FE, 0xDA1C,
        0xDE53, 0xE2A0, 0xE701, 0xEB73, 0xEFF3, 0xF47E, 0xF911, 0xFDA8, 0x0240, 0x06D7, 0x0B6A, 0x0FF5, 0x1475, 0x18E8, 0x1D49, 0x2197,
        0x25CF, 0x29EC, 0x2DEE, 0x31D1, 0x3592, 0x392F, 0x3CA5, 0x3FF2, 0x4315, 0x460A, 0x48D0, 0x4B65, 0x4DC7, 0x4FF5, 0x51ED, 0x53AE,
        0x5536, 0x5685, 0x5799, 0x5873, 0x5911, 0x5972, 0x5998, 0x5981, 0x592E, 0x589F, 0x57D4, 0x56CE, 0x558D, 0x5413, 0x5260, 0x5075,
        0x4E55, 0x4BFF, 0x4977, 0x46BC, 0x43D3, 0x40BB, 0x3D78, 0x3A0B, 0x3678, 0x32BF, 0x2EE4, 0x2AEA, 0x26D3, 0x22A2, 0x1E59, 0x19FC,
        0x158D, 0x1110, 0x0C88, 0x07F6, 0x0360, 0xFEC8, 0xFA30, 0xF59C, 0xF10F, 0xEC8C, 0xE817, 0xE3B1, 0xDF5E, 0xDB22, 0xD6FE, 0xD2F6,
        0xCF0C, 0xCB43, 0xC79E, 0xC41F, 0xC0C8, 0xBD9B, 0xBA9C, 0xB7CB, 0xB52B, 0xB2BD, 0xB084, 0xAE7F, 0xACB2, 0xAB1D, 0xA9C2, 0xA8A0,
        0xA7B9, 0xA70E, 0xA69E, 0xA66B, 0xA674, 0xA6BA, 0xA73C, 0xA7F9, 0xA8F2, 0xAA26, 0xAB93, 0xAD3A, 0xAF18, 0xB12C, 0xB376, 0xB5F3,
        0xB8A3, 0xBB82, 0xBE8F, 0xC1C9, 0xC52C, 0xC8B8, 0xCC68, 0xD03B, 0xD42F, 0xD83F, 0xDC6B, 0xE0AF, 0xE508, 0xE973, 0xEDED, 0xF273,
        0xF703, 0xFB98, 0x0030, 0x04C8, 0x095D, 0x0DEC, 0x1271, 0x16EA, 0x1B54, 0x1FAB, 0x23ED, 0x2817, 0x2C25, 0x3016, 0x33E6, 0x3794,
        0x3B1C, 0x3E7C, 0x41B2, 0x44BC, 0x4797, 0x4A43, 0x4CBC, 0x4F01, 0x5111, 0x52EB, 0x548D, 0x55F5, 0x5724, 0x5818, 0x58D1, 0x594E,
        0x598F, 0x5993, 0x595B, 0x58E7, 0x5836, 0x574B, 0x5624, 0x54C4, 0x532A, 0x5158, 0x4F50, 0x4D12, 0x4AA0, 0x47FC, 0x4527, 0x4224,
        0x3EF4, 0x3B9A, 0x3817, 0x346F, 0x30A4, 0x2CB7, 0x28AD, 0x2487, 0x2048, 0x1BF4, 0x178D, 0x1316, 0x0E92, 0x0A04, 0x0570, 0x00D8,
        0xFC40, 0xF7AA, 0xF319, 0xEE92, 0xEA15, 0xE5A8, 0xE14D, 0xDD06, 0xD8D6, 0xD4C2, 0xD0CA, 0xCCF2, 0xC93C, 0xC5AC, 0xC242, 0xBF03,
        0xBBEF, 0xB909, 0xB653, 0xB3CE, 0xB17D, 0xAF60, 0xAD7A, 0xABCC, 0xAA57, 0xA91B, 0xA819, 0xA753, 0xA6C9, 0xA67B, 0xA669, 0xA693,
        0xA6FA, 0xA79D, 0xA87B, 0xA995, 0xAAE8, 0xAC75, 0xAE3A, 0xB036, 0xB269, 0xB4CF, 0xB768, 0xBA32, 0xBD2B, 0xC051, 0xC3A2, 0xC71C,
        0xCABC, 0xCE7F, 0xD265, 0xD669, 0xDA89, 0xDEC2, 0xE312, 0xE775, 0xEBE8, 0xF06A, 0xF4F5, 0xF989, 0xFE20, 0x02B8, 0x074F, 0x0BE1,
        0x106B, 0x14EA, 0x195B, 0x1DBB, 0x2206, 0x263B, 0x2A56, 0x2E55, 0x3234, 0x35F2, 0x398B, 0x3CFD, 0x4046, 0x4364, 0x4655, 0x4916,
        0x4BA6, 0x4E03, 0x502B, 0x521D, 0x53D8, 0x555B, 0x56A4, 0x57B2, 0x5885, 0x591D, 0x5979, 0x5998, 0x597B, 0x5922, 0x588D, 0x57BC,
        0x56B0, 0x5569, 0x53E9, 0x5230, 0x5040, 0x4E1A, 0x4BBF, 0x4932, 0x4673, 0x4384, 0x4068, 0x3D20, 0x39B0, 0x3618, 0x325C, 0x2E7E,
        0x2A81, 0x2667, 0x2233, 0x1DE8, 0x1989, 0x1519, 0x109A, 0x0C11, 0x077F, 0x02E8, 0xFE50, 0xF9B9, 0xF525, 0xF099, 0xEC17, 0xE7A3,
        0xE33F, 0xDEEF, 0xDAB4, 0xD693, 0xD28E, 0xCEA7, 0xCAE2, 0xC741, 0xC3C5, 0xC073, 0xBD4B, 0xBA50, 0xB784, 0xB4E9, 0xB281, 0xB04C,
        0xAE4E, 0xAC86, 0xAAF7, 0xA9A1, 0xA886, 0xA7A5, 0xA700, 0xA696, 0xA669, 0xA679, 0xA6C5, 0xA74C, 0xA810, 0xA90F, 0xAA48, 0xABBC,
        0xAD68, 0xAF4C, 0xB166, 0xB3B5, 0xB637, 0xB8EB, 0xBBD0, 0xBEE2, 0xC220, 0xC587, 0xC916, 0xCCCA, 0xD0A1, 0xD497, 0xD8AB, 0xDCDA,
        0xE11F, 0xE57A, 0xE9E7, 0xEE62, 0xF2EA, 0xF77A, 0xFC10, 0x00A8, 0x0540, 0x09D4, 0x0E62, 0x12E7, 0x175E, 0x1BC6, 0x201B, 0x245B,
        0x2882, 0x2C8D, 0x307B, 0x3448, 0x37F2, 0x3B76, 0x3ED2, 0x4204, 0x4509, 0x47DF, 0x4A86, 0x4CF9, 0x4F3A, 0x5144, 0x5318, 0x54B4,
        0x5617, 0x5740, 0x582E, 0x58E1, 0x5957, 0x5992, 0x5990, 0x5952, 0x58D7, 0x5821, 0x572F, 0x5603, 0x549D, 0x52FD, 0x5126, 0x4F18,
        0x4CD5, 0x4A5D, 0x47B4, 0x44DB, 0x41D3, 0x3E9E, 0x3B40, 0x37BA, 0x340E, 0x303E, 0x2C4F, 0x2841, 0x2419, 0x1FD8, 0x1B82, 0x1719,
        0x12A0, 0x0E1B, 0x098D, 0x04F8, 0x0060, 0xFBC8, 0xF732, 0xF2A3, 0xEE1C, 0xE9A1, 0xE535, 0xE0DC, 0xDC97, 0xD86B, 0xD458, 0xD064,
        0xCC8F, 0xC8DD, 0xC551, 0xC1EC, 0xBEB0, 0xBBA1, 0xB8C0, 0xB60E, 0xB38F, 0xB143, 0xAF2C, 0xAD4C, 0xABA3, 0xAA34, 0xA8FE, 0xA802,
        0xA742, 0xA6BE, 0xA676, 0xA66A, 0xA69B, 0xA708, 0xA7B1, 0xA895, 0xA9B5, 0xAB0E, 0xACA1, 0xAE6C, 0xB06D, 0xB2A5, 0xB510, 0xB7AF,
        0xBA7D, 0xBD7B, 0xC0A6, 0xC3FB, 0xC779, 0xCB1C, 0xCEE4, 0xD2CC, 0xD6D3, 0xDAF6, 0xDF32, 0xE383, 0xE7E8, 0xEC5E, 0xF0E0, 0xF56D,
        0xFA00, 0xFE98, 0x0330, 0x07C7, 0x0C58, 0x10E1, 0x155F, 0x19CE, 0x1E2C, 0x2275, 0x26A8, 0x2AC0, 0x2EBC, 0x3297, 0x3651, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2EFC, 0x32A9, 0x362D, 0x3988, 0x3CB6, 0x3FB5, 0x4285, 0x4524, 0x478F, 0x49C6, 0x4BC8, 0x4D93, 0x4F26, 0x5082, 0x51A5,
        0x528F, 0x533F, 0x53B6, 0x53F4, 0x53F8, 0x53C4, 0x5357, 0x52B3, 0x51D8, 0x50C7, 0x4F81, 0x4E07, 0x4C5B, 0x4A7F, 0x4873, 0x4639,
        0x43D4, 0x4146, 0x3E8F, 0x3BB3, 0x38B3, 0x3592, 0x3252, 0x2EF6, 0x2B80, 0x27F3, 0x2451, 0x209C, 0x1CD8, 0x1907, 0x152C, 0x1149,
        0x0D62, 0x0978, 0x058F, 0x01AA, 0xFDCB, 0xF9F3, 0xF626, 0xF267, 0xEEB8, 0xEB1C, 0xE794, 0xE423, 0xE0CB, 0xDD8E, 0xDA6F, 0xD76E,
        0xD48F, 0xD1D2, 0xCF3A, 0xCCC8, 0xCA7D, 0xC85A, 0xC661, 0xC492, 0xC2F0, 0xC17A, 0xC030, 0xBF15, 0xBE27, 0xBD68, 0xBCD8, 0xBC76,
        0xBC42, 0xBC3D, 0xBC66, 0xBCBC, 0xBD3F, 0xBDEE, 0xBEC9, 0xBFCE, 0xC0FD, 0xC254, 0xC3D3, 0xC577, 0xC740, 0xC92B, 0xCB38, 0xCD65,
        0xCFAF, 0xD216, 0xD497, 0xD730, 0xD9E0, 0xDCA5, 0xDF7B, 0xE262, 0xE557, 0xE859, 0xEB64, 0xEE76, 0xF18F, 0xF4AB, 0xF7C8, 0xFAE4,
        0xFDFD, 0x0110, 0x041D, 0x0721, 0x0A19, 0x0D05, 0x0FE1, 0x12AD, 0x1566, 0x180B, 0x1A9A, 0x1D11, 0x1F6F, 0x21B3, 0x23DB, 0x25E6,
        0x27D2, 0x29A0, 0x2B4D, 0x2CDA, 0x2E44, 0x2F8C, 0x30B1, 0x31B2, 0x328F, 0x3348, 0x33DD, 0x344D, 0x3498, 0x34C0, 0x34C3, 0x34A2,
        0x345D, 0x33F6, 0x336C, 0x32C1, 0x31F4, 0x3108, 0x2FFC, 0x2ED2, 0x2D8B, 0x2C28, 0x2AAB, 0x2913, 0x2764, 0x259E, 0x23C2, 0x21D3,
        0x1FD1, 0x1DBE, 0x1B9C, 0x196D, 0x1731, 0x14EB, 0x129D, 0x1047, 0x0DEC, 0x0B8D, 0x092C, 0x06CB, 0x046C, 0x020F, 0xFFB7, 0xFD65,
        0xFB1A, 0xF8D9, 0xF6A2, 0xF477, 0xF259, 0xF04A, 0xEE4B, 0xEC5D, 0xEA82, 0xE8BA, 0xE707, 0xE569, 0xE3E1, 0xE270, 0xE118, 0xDFD8,
        0xDEB2, 0xDDA5, 0xDCB2, 0xDBDA, 0xDB1D, 0xDA7B, 0xD9F5, 0xD989, 0xD93A, 0xD905, 0xD8EC, 0xD8EE, 0xD90A, 0xD941, 0xD991, 0xD9FB,
        0xDA7E, 0xDB18, 0xDBCB, 0xDC94, 0xDD73, 0xDE67, 0xDF70, 0xE08C, 0xE1BA, 0xE2F9, 0xE448, 0xE5A7, 0xE714, 0xE88D, 0xEA13, 0xEBA2,
        0xED3B, 0xEEDC, 0xF084, 0xF232, 0xF3E4, 0xF599, 0xF750, 0xF907, 0xFABE, 0xFC74, 0xFE26, 0xFFD5, 0x017D, 0x0320, 0x04BC, 0x0650,
        0x07DA, 0x095A, 0x0ACE, 0x0C37, 0x0D92, 0x0EE0, 0x1020, 0x1150, 0x1270, 0x1380, 0x147F, 0x156D, 0x1649, 0x1712, 0x17C9, 0x186E,
        0x18FF, 0x197D, 0x19E8, 0x1A3F, 0x1A84, 0x1AB5, 0x1AD3, 0x1ADE, 0x1AD6, 0x1ABC, 0x1A90, 0x1A52, 0x1A03, 0x19A3, 0x1933, 0x18B3,
        0x1824, 0x1786, 0x16DA, 0x1620, 0x155B, 0x1489, 0x13AC, 0x12C5, 0x11D4, 0x10DA, 0x0FD9, 0x0ED0, 0x0DC2, 0x0CAD, 0x0B95, 0x0A78,
        0x0959, 0x0837, 0x0715, 0x05F2, 0x04CF, 0x03AE, 0x028F, 0x0173, 0x005A, 0xFF47, 0xFE38, 0xFD2E, 0xFC2B, 0xFB2E, 0xFA3A, 0xF94D,
        0xF869, 0xF78F, 0xF6BE, 0xF5F7, 0xF53A, 0xF488, 0xF3E2, 0xF347, 0xF2B7, 0xF234, 0xF1BC, 0xF151, 0xF0F2, 0xF09F, 0xF059, 0xF01F,
        0xEFF1, 0xEFCF, 0xEFBA, 0xEFB0, 0xEFB2, 0xEFC0, 0xEFD9, 0xEFFC, 0xF02B, 0xF063, 0xF0A6, 0xF0F2, 0xF148, 0xF1A6, 0xF20C, 0xF27B,
        0xF2F0, 0xF36D, 0xF3F0, 0xF478, 0xF507, 0xF599, 0xF631, 0xF6CC, 0xF76A, 0xF80B, 0xF8AE, 0xF953, 0xF9F8, 0xFA9F, 0xFB45, 0xFBEB,
        0xFC91, 0xFD34, 0xFDD6, 0xFE76, 0xFF13, 0xFFAD, 0x0043, 0x00D5, 0x0163, 0x01ED, 0x0272, 0x02F2, 0x036C, 0x03E1, 0x0450, 0x04B8,
        0x051B, 0x0577, 0x05CC, 0x061B, 0x0663, 0x06A4, 0x06DF, 0x0712, 0x073F, 0x0766, 0x0785, 0x079E, 0x07B0, 0x07BC, 0x07C2, 0x07C2,
        0x07BB, 0x07AF, 0x079E, 0x0787, 0x076B, 0x074A, 0x0724, 0x06FB, 0x06CD, 0x069B, 0x0666, 0x062D, 0x05F2, 0x05B4, 0x0574, 0x0531,
        0x04ED, 0x04A7, 0x0461, 0x0419, 0x03D1, 0x0388, 0x033F, 0x02F7, 0x02AF, 0x0268, 0x0221, 0x01DC, 0x0198, 0x0156, 0x0116, 0x00D7,
        0x009B, 0x0061, 0x0029, 0xFFF5, 0xFFC2, 0xFF92, 0xFF65, 0xFF3B, 0xFF14, 0xFEF0, 0xFECF, 0xFEB0, 0xFE95, 0xFE7D, 0xFE68, 0xFE55,
        0xFE46, 0xFE39, 0xFE2F, 0xFE28, 0xFE24, 0xFE21, 0xFE21, 0xFE24, 0xFE28, 0xFE2F, 0xFE37, 0xFE41, 0xFE4D, 0xFE5A, 0xFE68, 0xFE77,
        0xFE88, 0xFE99, 0xFEAB, 0xFEBD, 0xFED0, 0xFEE3, 0xFEF7, 0xFF0A, 0xFF1D, 0xFF30, 0xFF42, 0xFF54, 0xFF66, 0xFF76, 0xFF86, 0xFF95,
        0xFFA3, 0xFFB1, 0xFFBD, 0xFFC8, 0xFFD2, 0xFFDB, 0xFFE4, 0xFFEA, 0xFFF0, 0xFFF5, 0xFFF9, 0xFFFC, 0xFFFE, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 0x0001, 0x0000,
        0xFFFE, 0xFFFB, 0xFFF8, 0xFFF5, 0xFFF1, 0xFFEC, 0xFFE7, 0xFFE1, 0xFFDB, 0xFFD4, 0xFFCD, 0xFFC5, 0xFFBE, 0xFFB6, 0xFFAD, 0xFFA5,
        0xFF9D, 0xFF95, 0xFF8D, 0xFF86, 0xFF7F, 0xFF79, 0xFF74, 0xFF6F, 0xFF6C, 0xFF69, 0xFF68, 0xFF68, 0xFF6A, 0xFF6D, 0xFF72, 0xFF79,
        0xFF82, 0xFF8C, 0xFF99, 0xFFA7, 0xFFB7, 0xFFC9, 0xFFDD, 0xFFF3, 0x000A, 0x0023, 0x003E, 0x005A, 0x0078, 0x0096, 0x00B6, 0x00D6,
        0x00F7, 0x0117, 0x0138, 0x0159, 0x0179, 0x0198, 0x01B6, 0x01D3, 0x01ED, 0x0206, 0x021C, 0x0230, 0x0241, 0x024E, 0x0259, 0x025F,
        0x0261, 0x0260, 0x025A, 0x024F, 0x0240, 0x022C, 0x0213, 0x01F6, 0x01D3, 0x01AC, 0x0180, 0x0150, 0x011B, 0x00E1, 0x00A4, 0x0063,
        0x001F, 0xFFD8, 0xFF8D, 0xFF41, 0xFEF2, 0xFEA2, 0xFE51, 0xFE00, 0xFDAF, 0xFD5E, 0xFD0F, 0xFCC2, 0xFC77, 0xFC30, 0xFBEC, 0xFBAC,
        0xFB71, 0xFB3C, 0xFB0D, 0xFAE4, 0xFAC2, 0xFAA8, 0xFA96, 0xFA8C, 0xFA8A, 0xFA92, 0xFAA3, 0xFABD, 0xFAE1, 0xFB0E, 0xFB45, 0xFB85,
        0xFBCF, 0xFC21, 0xFC7D, 0xFCE1, 0xFD4E, 0xFDC2, 0xFE3E, 0xFEC0, 0xFF48, 0xFFD5, 0x0066, 0x00FB, 0x0193, 0x022D, 0x02C8, 0x0363,
        0x03FC, 0x0494, 0x0529, 0x05B9, 0x0644, 0x06C9, 0x0747, 0x07BC, 0x0828, 0x088A, 0x08E1, 0x092C, 0x096B, 0x099C, 0x09BF, 0x09D3,
        0x09D8, 0x09CE, 0x09B3, 0x0989, 0x094E, 0x0903, 0x08A8, 0x083D, 0x07C3, 0x0739, 0x06A0, 0x05FA, 0x0545, 0x0485, 0x03B8, 0x02E1,
        0x0201, 0x0118, 0x0028, 0xFF33, 0xFE39, 0xFD3C, 0xFC3E, 0xFB41, 0xFA45, 0xF94C, 0xF859, 0xF76C, 0xF688, 0xF5AE, 0xF4E0, 0xF41E,
        0xF36B, 0xF2C8, 0xF237, 0xF1B8, 0xF14C, 0xF0F6, 0xF0B5, 0xF08C, 0xF079, 0xF07E, 0xF09C, 0xF0D3, 0xF122, 0xF18A, 0xF20B, 0xF2A4,
        0xF355, 0xF41D, 0xF4FC, 0xF5F0, 0xF6F9, 0xF815, 0xF942, 0xFA80, 0xFBCC, 0xFD25, 0xFE89, 0xFFF6, 0x0168, 0x02E1, 0x045B, 0x05D6,
        0x074E, 0x08C2, 0x0A2F, 0x0B92, 0x0CEA, 0x0E34, 0x0F6E, 0x1095, 0x11A7, 0x12A3, 0x1386, 0x144F, 0x14FB, 0x158A, 0x15FA, 0x164A,
        0x1679, 0x1685, 0x166F, 0x1635, 0x15D8, 0x1558, 0x14B5, 0x13EE, 0x1306, 0x11FC, 0x10D2, 0x0F8A, 0x0E23, 0x0CA2, 0x0B06, 0x0953,
        0x078B, 0x05B0, 0x03C4, 0x01CB, 0xFFC9, 0xFDBD, 0xFBAD, 0xF99C, 0xF78D, 0xF582, 0xF380, 0xF189, 0xEFA1, 0xEDCB, 0xEC0A, 0xEA62,
        0xE8D4, 0xE764, 0xE615, 0xE4E9, 0xE3E2, 0xE303, 0xE24E, 0xE1C3, 0xE165, 0xE136, 0xE134, 0xE163, 0xE1C1, 0xE250, 0xE30E, 0xE3FB,
        0xE517, 0xE660, 0xE7D6, 0xE976, 0xEB3E, 0xED2D, 0xEF40, 0xF173, 0xF3C5, 0xF631, 0xF8B6, 0xFB4E, 0xFDF6, 0x00A9, 0x0366, 0x0627,
        0x08E8, 0x0BA4, 0x0E58, 0x10FF, 0x1394, 0x1614, 0x187B, 0x1AC3, 0x1CEA, 0x1EEC, 0x20C5, 0x2271, 0x23EE, 0x2539, 0x264F, 0x272D,
        0x27D2, 0x283B, 0x2868, 0x2858, 0x2809, 0x277C, 0x26B1, 0x25A7, 0x2461, 0x22DF, 0x2122, 0x1F2D, 0x1D02, 0x1AA4, 0x1815, 0x155A,
        0x1275, 0x0F6B, 0x0C41, 0x08FA, 0x059B, 0x0229, 0xFEAB, 0xFB23, 0xF798, 0xF40F, 0xF08E, 0xED1A, 0xE9B9, 0xE670, 0xE345, 0xE03D,
        0xDD5C, 0xDAA8, 0xD825, 0xD5D8, 0xD3C5, 0xD1F0, 0xD05D, 0xCF0D, 0xCE05, 0xCD47, 0xCCD4, 0xCCAF, 0xCCD7, 0xCD4F, 0xCE15, 0xCF2B,
        0xD08E, 0xD23D, 0xD438, 0xD67B, 0xD903, 0xDBCF, 0xDEDA, 0xE220, 0xE59C, 0xE94B, 0xED26, 0xF129, 0xF54D, 0xF98D, 0xFDE3, 0x0246,
        0x06B3, 0x0B21, 0x0F8A, 0x13E7, 0x1831, 0x1C61, 0x2072, 0x245B, 0x2817, 0x2B9F, 0x2EEE, 0x31FD, 0x34C9, 0x374A, 0x397E, 0x3B5F,
        0x3CEB, 0x3E1D, 0x3EF3, 0x3F6B, 0x3F83, 0x3F3B, 0x3E91, 0x3D85, 0x3C19, 0x3A4E, 0x3824, 0x35A0, 0x32C3, 0x2F91, 0x2C0F, 0x2841,
        0x242C, 0x1FD5, 0x1B43, 0x167C, 0x1187, 0x0C6B, 0x072F, 0x01DC, 0xFC7A, 0xF710, 0xF1A5, 0xEC44, 0xE6F4, 0xE1BE, 0xDCA9, 0xD7BE,
        0xD304, 0xCE85, 0xCA46, 0xC64F, 0xC2A7, 0xBF54, 0xBC5C, 0xB9C4, 0xB791, 0xB5C8, 0xB46D, 0xB381, 0xB308, 0xB303, 0xB374, 0xB45B,
        0xB5B8, 0xB789, 0xB9CD, 0xBC81, 0xBFA2, 0xC32D, 0xC71D, 0xCB6C, 0xD016, 0xD513, 0xDA5D, 0xDFEC, 0xE5B8, 0xEBBA, 0xF1E8, 0xF839,
        0xFEA5, 0x051F, 0x0BA1, 0x1220, 0x1891, 0x1EEB, 0x2524, 0x2B31, 0x310A, 0x36A5, 0x3BF9, 0x40FC, 0x45A8, 0x49F3, 0x4DD7, 0x514C,
        0x53F3, 0x561B, 0x57C1, 0x58E2, 0x597C, 0x5990, 0x591C, 0x5821, 0x56A0, 0x549D, 0x521A, 0x4F1A, 0x4BA3, 0x47BA, 0x4364, 0x3EA8,
        0x398E, 0x341C, 0x2E5C, 0x2855, 0x2212, 0x1B9A, 0x14FA, 0x0E39, 0x0763, 0x0082, 0xF9A1, 0xF2C8, 0xEC04, 0xE55E, 0xDEE0, 0xD894,
        0xD284, 0xCCB9, 0xC73B, 0xC213, 0xBD49, 0xB8E3, 0xB4E9, 0xB161, 0xAE50, 0xABBA, 0xA9A4, 0xA810, 0xA701, 0xA679, 0xA678, 0xA6FF,
        0xA80C, 0xA99E, 0xABB3, 0xAE48, 0xB158, 0xB4DF, 0xB8D7, 0xBD3B, 0xC205, 0xC72B, 0xCCA8, 0xD273, 0xD882, 0xDECD, 0xE54B, 0xEBF0,
        0xF2B5, 0xF98D, 0x006E, 0x074F, 0x0E25, 0x14E6, 0x1B87, 0x21FF, 0x2843, 0x2E4A, 0x340C, 0x397E, 0x3E9A, 0x4357, 0x47AE, 0x4B99,
        0x4F11, 0x5212, 0x5496, 0x569B, 0x581D, 0x5919, 0x598F, 0x597D, 0x58E4, 0x57C5, 0x5621, 0x53FA, 0x5155, 0x4E34, 0x4A9D, 0x4696,
        0x4223, 0x3D4D, 0x381A, 0x3292, 0x2CBD, 0x26A5, 0x2053, 0x19CF, 0x1325, 0x0C5D, 0x0583, 0xFEA2, 0xF7C1, 0xF0ED, 0xEA30, 0xE394,
        0xDD23, 0xD6E6, 0xD0E8, 0xCB31, 0xC5CA, 0xC0BB, 0xBC0B, 0xB7C3, 0xB3E7, 0xB07F, 0xAD8F, 0xAB1B, 0xA928, 0xA7B9, 0xA6CF, 0xA66B,
        0xA68F, 0xA73B, 0xA86D, 0xAA23, 0xAC5B, 0xAF11, 0xB242, 0xB5E9, 0xB9FF, 0xBE80, 0xC363, 0xC8A3, 0xCE35, 0xD414, 0xDA34, 0xE08E,
        0xE717, 0xEDC6, 0xF491, 0xFB6D, 0x024F, 0x092E, 0x1000, 0x16B9, 0x1D50, 0x23BA, 0x29EF, 0x2FE4, 0x3590, 0x3AEC, 0x3FEF, 0x4490,
        0x48CB, 0x4C97, 0x4FEF, 0x52CE, 0x5530, 0x5712, 0x586F, 0x5947, 0x5998, 0x5961, 0x58A3, 0x575F, 0x5597, 0x534E, 0x5086, 0x4D45,
        0x498F, 0x4569, 0x40DB, 0x3BEB, 0x36A0, 0x3102, 0x2B1A, 0x24F1, 0x1E90, 0x1801, 0x114E, 0x0A80, 0x03A3, 0xFCC1, 0xF5E3, 0xEF14,
        0xE85F, 0xE1CD, 0xDB6A, 0xD53D, 0xCF52, 0xC9AF, 0xC460, 0xBF6A, 0xBAD6, 0xB6AA, 0xB2EE, 0xAFA6, 0xACD7, 0xAA86, 0xA8B7, 0xA76C,
        0xA6A6, 0xA668, 0xA6B1, 0xA781, 0xA8D7, 0xAAB1, 0xAD0C, 0xAFE4, 0xB336, 0xB6FC, 0xBB30, 0xBFCC, 0xC4C9, 0xCA20, 0xCFC8, 0xD5B9,
        0xDBEB, 0xE252, 0xE8E7, 0xEF9F, 0xF66F, 0xFD4E, 0x0430, 0x0B0C, 0x11D8, 0x1889, 0x1F15, 0x2571, 0x2B95, 0x3178, 0x370F, 0x3C53,
        0x413C, 0x45C2, 0x49DF, 0x4D8C, 0x50C4, 0x5381, 0x55C1, 0x577E, 0x58B7, 0x596A, 0x5996, 0x593B, 0x5858, 0x56F0, 0x5504, 0x5298,
        0x4FAF, 0x4C4D, 0x4878, 0x4435, 0x3F8C, 0x3A82, 0x351F, 0x2F6C, 0x2972, 0x2339, 0x1CCA, 0x1630, 0x0F75, 0x08A2, 0x01C2, 0xFAE0,
        0xF405, 0xED3D, 0xE690, 0xE00A, 0xD9B5, 0xD399, 0xCDC0, 0xC834, 0xC2FC, 0xBE20, 0xB9A8, 0xB59A, 0xB1FD, 0xAED5, 0xAC29, 0xA9FB,
        0xA84F, 0xA728, 0xA688, 0xA66E, 0xA6DC, 0xA7D1, 0xA94C, 0xAB49, 0xADC6, 0xB0C0, 0xB432, 0xB816, 0xBC68, 0xC11F, 0xC635, 0xCBA3,
        0xD160, 0xD764, 0xDDA5, 0xE41A, 0xEAB9, 0xF178, 0xF84E, 0xFF2F, 0x0610, 0x0CE9, 0x13AE, 0x1A56, 0x20D6, 0x2724, 0x2D37, 0x3306,
        0x3887, 0x3DB3, 0x4282, 0x46EC, 0x4AEB, 0x4E79, 0x518F, 0x542B, 0x5647, 0x57E1, 0x58F6, 0x5984, 0x598B, 0x590A, 0x5803, 0x5677,
        0x5468, 0x51D9, 0x4ECE, 0x4B4D, 0x4759, 0x42FA, 0x3E35, 0x3912, 0x3399, 0x2DD2, 0x27C5, 0x217C, 0x1B01, 0x145D, 0x0D9A, 0x06C2,
        0xFFE2, 0xF900, 0xF229, 0xEB67, 0xE4C4, 0xDE4B, 0xD804, 0xD1FA, 0xCC35, 0xC6BF, 0xC19F, 0xBCDE, 0xB882, 0xB492, 0xB114, 0xAE0E,
        0xAB84, 0xA979, 0xA7F2, 0xA6EF, 0xA673, 0xA67F, 0xA712, 0xA82B, 0xA9CA, 0xABEA, 0xAE8A, 0xB1A5, 0xB537, 0xB939, 0xBDA7, 0xC279,
        0xC7A8, 0xCD2D, 0xD2FE, 0xD913, 0xDF63, 0xE5E5, 0xEC8E, 0xF354, 0xFA2D, 0x010F, 0x07F0, 0x0EC4, 0x1583, 0x1C20, 0x2294, 0x28D3,
        0x2ED4, 0x348F, 0x39FA, 0x3F0D, 0x43C1, 0x480E, 0x4BEF, 0x4F5C, 0x5252, 0x54CB, 0x56C4, 0x583A, 0x592A, 0x5993, 0x5975, 0x58D0,
        0x57A4, 0x55F4, 0x53C1, 0x5111, 0x4DE5, 0x4A44, 0x4632, 0x41B6, 0x3CD7, 0x379C, 0x320D, 0x2C32, 0x2614, 0x1FBC, 0x1935, 0x1287,
        0x0BBE, 0x04E2, 0xFE01, 0xF721, 0xF04F, 0xE994, 0xE2FC, 0xDC8F, 0xD658, 0xD05F, 0xCAAF, 0xC550, 0xC049, 0xBBA3, 0xB764, 0xB393,
        0xB035, 0xAD50, 0xAAE8, 0xA901, 0xA79E, 0xA6C0, 0xA669, 0xA69A, 0xA751, 0xA88F, 0xAA51, 0xAC95, 0xAF57, 0xB293, 0xB644, 0xBA64,
        0xBEEE, 0xC3DA, 0xC922, 0xCEBC, 0xD4A0, 0xDAC7, 0xE125, 0xE7B2, 0xEE64, 0xF531, 0xFC0E, 0x02F0, 0x09CE, 0x109E, 0x1754, 0x1DE8,
        0x244E, 0x2A7D, 0x306C, 0x3611, 0x3B65, 0x405F, 0x44F8, 0x4928, 0x4CEA, 0x5037, 0x530B, 0x5562, 0x5737, 0x5888, 0x5954, 0x5998,
        0x5955, 0x588B, 0x573B, 0x5567, 0x5312, 0x503F, 0x4CF3, 0x4932, 0x4503, 0x406C, 0x3B73, 0x3620, 0x307B, 0x2A8D, 0x245E, 0x1DF9,
        0x1766, 0x10B0, 0x09E0, 0x0302, 0xFC20, 0xF543, 0xEE76, 0xE7C4, 0xE136, 0xDAD7, 0xD4B0, 0xCECB, 0xC930, 0xC3E8, 0xBEFB, 0xBA70,
        0xB64E, 0xB29C, 0xAF5F, 0xAC9C, 0xAA57, 0xA893, 0xA754, 0xA69B, 0xA669, 0xA6BE, 0xA79B, 0xA8FD, 0xAAE3, 0xAD49, 0xB02D, 0xB389,
        0xB759, 0xBB97, 0xC03D, 0xC542, 0xCAA1, 0xD050, 0xD648, 0xDC7E, 0xE2EA, 0xE983, 0xF03D, 0xF70F, 0xFDEF, 0x04D0, 0x0BAC, 0x1276,
        0x1924, 0x1FAB, 0x2603, 0x2C22, 0x31FE, 0x378E, 0x3CCA, 0x41AA, 0x4627, 0x4A3A, 0x4DDC, 0x5109, 0x53BB, 0x55EF, 0x57A0, 0x58CD,
        0x5974, 0x5994, 0x592C, 0x583D, 0x56C8, 0x54D1, 0x5259, 0x4F65, 0x4BF8, 0x4819, 0x43CC, 0x3F1A, 0x3A07, 0x349D, 0x2EE3, 0x28E3,
        0x22A4, 0x1C32, 0x1594, 0x0ED6, 0x0801, 0x0121, 0xFA3F, 0xF366, 0xEC9F, 0xE5F6, 0xDF74, 0xD923, 0xD30D, 0xCD3B, 0xC7B6, 0xC286,
        0xBDB3, 0xB944, 0xB541, 0xB1AE, 0xAE92, 0xABF1, 0xA9CF, 0xA82F, 0xA714, 0xA680, 0xA673, 0xA6ED, 0xA7EE, 0xA975, 0xAB7E, 0xAE07,
        0xB10C, 0xB488, 0xB877, 0xBCD2, 0xC192, 0xC6B1, 0xCC26, 0xD1EA, 0xD7F4, 0xDE3A, 0xE4B3, 0xEB56, 0xF217, 0xF8EE, 0xFFD0, 0x06B1,
        0x0D88, 0x144B, 0x1AF0, 0x216C, 0x27B5, 0x2DC2, 0x338A, 0x3904, 0x3E28, 0x42EE, 0x474E, 0x4B43, 0x4EC6, 0x51D2, 0x5462, 0x5672,
        0x5800, 0x5908, 0x598A, 0x5985, 0x58F8, 0x57E4, 0x564C, 0x5431, 0x5197, 0x4E81, 0x4AF5, 0x46F7, 0x428E, 0x3DC1, 0x3895, 0x3315,
        0x2D47, 0x2734, 0x20E7, 0x1A67, 0x13C0, 0x0CFB, 0x0622, 0xFF41, 0xF860, 0xF18A, 0xEACB, 0xE42B, 0xDDB6, 0xD774, 0xD170, 0xCBB2,
        0xC643, 0xC12C, 0xBC73, 0xB821, 0xB43C, 0xB0C9, 0xADCE, 0xAB4F, 0xA950, 0xA7D4, 0xA6DE, 0xA66F, 0xA687, 0xA726, 0xA84C, 0xA9F6,
        0xAC22, 0xAECE, 0xB1F4, 0xB590, 0xB99D, 0xBE14, 0xC2EF, 0xC826, 0xCDB2, 0xD389, 0xD9A4, 0xDFF9, 0xE67F, 0xED2B, 0xF3F3, 0xFACE,
        0x01B0, 0x0890, 0x0F63, 0x161F, 0x1CB9, 0x2328, 0x2962, 0x2F5D, 0x3511, 0x3A74, 0x3F7F, 0x442A, 0x486D, 0x4C44, 0x4FA7, 0x5291,
        0x54FF, 0x56EC, 0x5855, 0x5939, 0x5996, 0x596C, 0x58BA, 0x5782, 0x55C6, 0x5388, 0x50CB, 0x4D95, 0x49E9, 0x45CE, 0x4148, 0x3C60,
        0x371D, 0x3187, 0x2BA5, 0x2582, 0x1F25, 0x189A, 0x11EA, 0x0B1E, 0x0442, 0xFD60, 0xF681, 0xEFB0, 0xE8F8, 0xE263, 0xDBFB, 0xD5C9,
        0xCFD7, 0xCA2E, 0xC4D7, 0xBFD8, 0xBB3B, 0xB706, 0xB33F, 0xAFEC, 0xAD13, 0xAAB7, 0xA8DB, 0xA784, 0xA6B2, 0xA668, 0xA6A5, 0xA769,
        0xA8B3, 0xAA81, 0xACD0, 0xAF9E, 0xB2E4, 0xB6A0, 0xBACA, 0xBF5D, 0xC452, 0xC9A1, 0xCF42, 0xD52D, 0xDB59, 0xE1BC, 0xE84D, 0xEF02,
        0xF5D1, 0xFCAF, 0x0391, 0x0A6E, 0x113C, 0x17F0, 0x1E7F, 0x24E1, 0x2B0A, 0x30F3, 0x3691, 0x3BDD, 0x40CF, 0x455E, 0x4985, 0x4D3C,
        0x507E, 0x5347, 0x5592, 0x575B, 0x58A1, 0x5960, 0x5998, 0x5948, 0x5872, 0x5716, 0x5536, 0x52D5, 0x4FF7, 0x4CA0, 0x48D5, 0x449C,
        0x3FFB, 0x3AFA, 0x359F, 0x2FF3, 0x29FF, 0x23CB, 0x1D61, 0x16CA, 0x1011, 0x0940, 0x0261, 0xFB7F, 0xF4A3, 0xEDD8, 0xE729, 0xE09F,
        0xDA45, 0xD423, 0xCE44, 0xC8B1, 0xC371, 0xBE8C, 0xBA0B, 0xB5F3, 0xB24B, 0xAF19, 0xAC61, 0xAA28, 0xA870, 0xA73D, 0xA691, 0xA66B,
        0xA6CD, 0xA7B6, 0xA924, 0xAB16, 0xAD88, 0xB077, 0xB3DE, 0xB7B8, 0xBC00, 0xC0AE, 0xC5BC, 0xCB23, 0xD0D9, 0xD6D6, 0xDD12, 0xE383,
        0xEA1F, 0xF0DC, 0xF7AF, 0xFE90, 0x0571, 0x0C4B, 0x1313, 0x19BE, 0x2042, 0x2695, 0x2CAE, 0x3283, 0x380C, 0x3D40, 0x4217, 0x468B,
        0x4A93, 0x4E2B, 0x514D, 0x53F4, 0x561C, 0x57C1, 0x58E2, 0x597D, 0x5990, 0x591B, 0x5820, 0x56A0, 0x549C, 0x5219, 0x4F1A, 0x4BA2,
        0x47B9, 0x4363, 0x3EA7, 0x398C, 0x341A, 0x2E5A, 0x2853, 0x2210, 0x1B99, 0x14F8, 0x0E37, 0x0761, 0x0080, 0xF99F, 0xF2C6, 0xEC02,
        0xE55C, 0xDEDE, 0xD892, 0xD282, 0xCCB7, 0xC739, 0xC212, 0xBD47, 0xB8E2, 0xB4E8, 0xB160, 0xAE4F, 0xABB9, 0xA9A3, 0xA80F, 0xA701,
        0xA679, 0xA678, 0xA6FF, 0xA80C, 0xA99F, 0xABB4, 0xAE48, 0xB159, 0xB4E0, 0xB8D8, 0xBD3D, 0xC206, 0xC72D, 0xCCAA, 0xD275, 0xD884,
        0xDECF, 0xE54D, 0xEBF2, 0xF2B7, 0xF98F, 0x0070, 0x0751, 0x0E27, 0x14E8, 0x1B89, 0x2201, 0x2845, 0x2E4C, 0x340D, 0x3980, 0x3E9B,
        0x4358, 0x47AF, 0x4B9A, 0x4F12, 0x5213, 0x5497, 0x569C, 0x581D, 0x591A, 0x598F, 0x597D, 0x58E4, 0x57C4, 0x5620, 0x53F9, 0x5154,
        0x4E33, 0x4A9C, 0x4694, 0x4222, 0x3D4B, 0x3818, 0x3290, 0x2CBC, 0x26A3, 0x2051, 0x19CD, 0x1323, 0x0C5B, 0x0581, 0xFEA0, 0xF7BF,
        0xF0EB, 0xEA2E, 0xE392, 0xDD21, 0xD6E5, 0xD0E6, 0xCB2F, 0xC5C8, 0xC0B9, 0xBC0A, 0xB7C1, 0xB3E6, 0xB07E, 0xAD8E, 0xAB1B, 0xA928,
        0xA7B8, 0xA6CE, 0xA66B, 0xA690, 0xA73B, 0xA86D, 0xAA23, 0xAC5C, 0xAF12, 0xB243, 0xB5EA, 0xBA01, 0xBE81, 0xC365, 0xC8A4, 0xCE37,
        0xD415, 0xDA36, 0xE090, 0xE719, 0xEDC8, 0xF493, 0xFB6F, 0x0251, 0x0930, 0x1002, 0x16BB, 0x1D52, 0x23BC, 0x29F0, 0x2FE6, 0x3592,
        0x3AEE, 0x3FF0, 0x4492, 0x48CC, 0x4C98, 0x4FF0, 0x52CF, 0x5531, 0x5712, 0x586F, 0x5947, 0x5998, 0x5961, 0x58A3, 0x575F, 0x5597,
        0x534D, 0x5085, 0x4D44, 0x498E, 0x4568, 0x40DA, 0x3BE9, 0x369E, 0x3100, 0x2B18, 0x24EF, 0x1E8E, 0x17FF, 0x114C, 0x0A7E, 0x03A1,
        0xFCBF, 0xF5E1, 0xEF12, 0xE85D, 0xE1CC, 0xDB68, 0xD53C, 0xCF50, 0xC9AE, 0xC45E, 0xBF68, 0xBAD4, 0xB6A9, 0xB2ED, 0xAFA5, 0xACD6,
        0xAA86, 0xA8B6, 0xA76B, 0xA6A6, 0xA668, 0xA6B1, 0xA781, 0xA8D8, 0xAAB2, 0xAD0D, 0xAFE5, 0xB337, 0xB6FD, 0xBB31, 0xBFCD, 0xC4CB,
        0xCA22, 0xCFCA, 0xD5BB, 0xDBEC, 0xE254, 0xE8E9, 0xEFA1, 0xF671, 0xFD50, 0x0432, 0x0B0E, 0x11DA, 0x188B, 0x1F17, 0x2573, 0x2B97,
        0x3179, 0x3711, 0x3C55, 0x413D, 0x45C4, 0x49E0, 0x4D8D, 0x50C5, 0x5382, 0x55C1, 0x577F, 0x58B8, 0x596B, 0x5996, 0x593A, 0x5858,
        0x56EF, 0x5504, 0x5297, 0x4FAE, 0x4C4C, 0x4877, 0x4434, 0x3F8A, 0x3A80, 0x351E, 0x2F6B, 0x2970, 0x2337, 0x1CC8, 0x162E, 0x0F73,
        0x08A0, 0x01C0, 0xFADE, 0xF403, 0xED3B, 0xE68E, 0xE008, 0xD9B3, 0xD397, 0xCDBF, 0xC832, 0xC2FA, 0xBE1F, 0xB9A7, 0xB599, 0xB1FC,
        0xAED4, 0xAC28, 0xA9FA, 0xA84F, 0xA728, 0xA687, 0xA66E, 0xA6DD, 0xA7D2, 0xA94C, 0xAB4A, 0xADC7, 0xB0C1, 0xB433, 0xB818, 0xBC69,
        0xC120, 0xC637, 0xCBA5, 0xD162, 0xD766, 0xDDA7, 0xE41C, 0xEABB, 0xF17A, 0xF850, 0xFF31, 0x0612, 0x0CEB, 0x13B0, 0x1A58, 0x20D8,
        0x2726, 0x2D39, 0x3308, 0x3889, 0x3DB5, 0x4283, 0x46ED, 0x4AEC, 0x4E7A, 0x5190, 0x542C, 0x5648, 0x57E1, 0x58F6, 0x5984, 0x598B,
        0x590A, 0x5803, 0x5676, 0x5467, 0x51D8, 0x4ECD, 0x4B4C, 0x4758, 0x42F8, 0x3E33, 0x3910, 0x3397, 0x2DD0, 0x27C3, 0x217B, 0x1AFF,
        0x145B, 0x0D98, 0x06C0, 0xFFE0, 0xF8FE, 0xF227, 0xEB65, 0xE4C2, 0xDE49, 0xD802, 0xD1F8, 0xCC33, 0xC6BD, 0xC19E, 0xBCDC, 0xB881,
        0xB491, 0xB114, 0xAE0D, 0xAB83, 0xA979, 0xA7F1, 0xA6EF, 0xA673, 0xA67F, 0xA712, 0xA82C, 0xA9CA, 0xABEB, 0xAE8B, 0xB1A6, 0xB538,
        0xB93B, 0xBDA9, 0xC27B, 0xC7AA, 0xCD2E, 0xD300, 0xD915, 0xDF65, 0xE5E7, 0xEC90, 0xF356, 0xFA30, 0x0111, 0x07F2, 0x0EC6, 0x1585,
        0x1C22, 0x2296, 0x28D5, 0x2ED6, 0x3490, 0x39FB, 0x3F0E, 0x43C2, 0x480F, 0x4BF0, 0x4F5D, 0x5253, 0x54CC, 0x56C4, 0x583A, 0x592A,
        0x5993, 0x5975, 0x58CF, 0x57A4, 0x55F3, 0x53C1, 0x5110, 0x4DE4, 0x4A43, 0x4631, 0x41B5, 0x3CD6, 0x379A, 0x320B, 0x2C30, 0x2612,
        0x1FBA, 0x1933, 0x1285, 0x0BBC, 0x04E0, 0xFDFF, 0xF71F, 0xF04D, 0xE992, 0xE2FA, 0xDC8D, 0xD656, 0xD05E, 0xCAAE, 0xC54E, 0xC048,
        0xBBA2, 0xB763, 0xB392, 0xB034, 0xAD50, 0xAAE8, 0xA901, 0xA79D, 0xA6C0, 0xA669, 0xA69A, 0xA752, 0xA890, 0xAA52, 0xAC96, 0xAF58,
        0xB294, 0xB645, 0xBA66, 0xBEF0, 0xC3DC, 0xC923, 0xCEBD, 0xD4A2, 0xDAC8, 0xE127, 0xE7B4, 0xEE66, 0xF533, 0xFC10, 0x02F2, 0x09D0,
        0x10A0, 0x1756, 0x1DEA, 0x2450, 0x2A7F, 0x306D, 0x3613, 0x3B67, 0x4060, 0x44F9, 0x4929, 0x4CEB, 0x5038, 0x530C, 0x5562, 0x5737,
        0x5889, 0x5954, 0x5998, 0x5955, 0x588B, 0x573B, 0x5566, 0x5311, 0x503E, 0x4CF2, 0x4931, 0x4502, 0x406A, 0x3B71, 0x361E, 0x3079,
        0x2A8B, 0x245C, 0x1DF7, 0x1764, 0x10AE, 0x09DE, 0x0300, 0xFC1E, 0xF541, 0xEE74, 0xE7C2, 0xE134, 0xDAD5, 0xD4AE, 0xCEC9, 0xC92E,
        0xC3E6, 0xBEF9, 0xBA6E, 0xB64D, 0xB29B, 0xAF5E, 0xAC9B, 0xAA56, 0xA893, 0xA754, 0xA69B, 0xA669, 0xA6BE, 0xA79B, 0xA8FE, 0xAAE3,
        0xAD4A, 0xB02E, 0xB38A, 0xB75B, 0xBB99, 0xC03E, 0xC544, 0xCAA3, 0xD052, 0xD649, 0xDC80, 0xE2EC, 0xE985, 0xF03F, 0xF711, 0xFDF1,
        0x04D2, 0x0BAE, 0x1278, 0x1926, 0x1FAD, 0x2605, 0x2C24, 0x31FF, 0x378F, 0x3CCB, 0x41AB, 0x4628, 0x4A3B, 0x4DDD, 0x510A, 0x53BC,
        0x55EF, 0x57A1, 0x58CE, 0x5974, 0x5993, 0x592B, 0x583C, 0x56C8, 0x54D0, 0x5258, 0x4F64, 0x4BF7, 0x4818, 0x43CB, 0x3F18, 0x3A06,
        0x349B, 0x2EE2, 0x28E1, 0x22A3, 0x1C30, 0x1592, 0x0ED4, 0x07FF, 0x011F, 0xFA3D, 0xF364, 0xEC9D, 0xE5F4, 0xDF72, 0xD921, 0xD30C,
        0xCD3A, 0xC7B5, 0xC285, 0xBDB2, 0xB943, 0xB540, 0xB1AD, 0xAE91, 0xABF0, 0xA9CE, 0xA82E, 0xA714, 0xA680, 0xA673, 0xA6ED, 0xA7EF,
        0xA975, 0xAB7F, 0xAE08, 0xB10D, 0xB489, 0xB878, 0xBCD3, 0xC194, 0xC6B2, 0xCC28, 0xD1EC, 0xD7F6, 0xDE3C, 0xE4B5, 0xEB58, 0xF219,
        0xF8F0, 0xFFD2, 0x06B3, 0x0D8A, 0x144D, 0x1AF2, 0x216E, 0x27B7, 0x2DC4, 0x338C, 0x3906, 0x3E29, 0x42EF, 0x474F, 0x4B44, 0x4EC7,
        0x51D2, 0x5462, 0x5672, 0x5800, 0x5908, 0x598A, 0x5985, 0x58F7, 0x57E4, 0x564B, 0x5430, 0x5196, 0x4E80, 0x4AF4, 0x46F6, 0x428D,
        0x3DBF, 0x3894, 0x3313, 0x2D45, 0x2733, 0x20E5, 0x1A65, 0x13BE, 0x0CF9, 0x0620, 0xFF3F, 0xF85E, 0xF188, 0xEAC9, 0xE429, 0xDDB4,
        0xD772, 0xD16E, 0xCBB0, 0xC642, 0xC12A, 0xBC72, 0xB820, 0xB43B, 0xB0C8, 0xADCD, 0xAB4E, 0xA950, 0xA7D4, 0xA6DE, 0xA66F, 0xA687,
        0xA726, 0xA84C, 0xA9F7, 0xAC23, 0xAECF, 0xB1F5, 0xB591, 0xB99E, 0xBE15, 0xC2F0, 0xC827, 0xCDB3, 0xD38B, 0xD9A6, 0xDFFB, 0xE681,
        0xED2D, 0xF3F5, 0xFAD0, 0x01B2, 0x0892, 0x0F65, 0x1621, 0x1CBB, 0x232A, 0x2964, 0x2F5F, 0x3512, 0x3A75, 0x3F80, 0x442B, 0x486F,
        0x4C45, 0x4FA7, 0x5292, 0x54FF, 0x56EC, 0x5855, 0x5939, 0x5996, 0x596B, 0x58BA, 0x5782, 0x55C5, 0x5387, 0x50CB, 0x4D94, 0x49E8,
        0x45CC, 0x4147, 0x3C5F, 0x371C, 0x3185, 0x2BA3, 0x2580, 0x1F24, 0x1898, 0x11E8, 0x0B1C, 0x0440, 0xFD5E, 0xF67F, 0xEFAE, 0xE8F6,
        0xE261, 0xDBF9, 0xD5C8, 0xCFD6, 0xCA2D, 0xC4D5, 0xBFD7, 0xBB3A, 0xB705, 0xB33E, 0xAFEC, 0xAD12, 0xAAB6, 0xA8DB, 0xA784, 0xA6B2,
        0xA668, 0xA6A5, 0xA769, 0xA8B3, 0xAA82, 0xACD1, 0xAF9F, 0xB2E5, 0xB6A1, 0xBACC, 0xBF5F, 0xC454, 0xC9A3, 0xCF44, 0xD52F, 0xDB5B,
        0xE1BE, 0xE84F, 0xEF04, 0xF5D3, 0xFCB1, 0x0393, 0x0A70, 0x113E, 0x17F2, 0x1E81, 0x24E3, 0x2B0C, 0x30F4, 0x3693, 0x3BDF, 0x40D0,
        0x455F, 0x4986, 0x4D3D, 0x507F, 0x5348, 0x5593, 0x575C, 0x58A1, 0x5960, 0x5998, 0x5948, 0x5872, 0x5715, 0x5535, 0x52D4, 0x4FF6,
        0x4C9F, 0x48D4, 0x449B, 0x3FFA, 0x3AF8, 0x359D, 0x2FF1, 0x29FD, 0x23C9, 0x1D5F, 0x16C8, 0x100F, 0x093E, 0x025F, 0xFB7D, 0xF4A1,
        0xEDD6, 0xE727, 0xE09D, 0xDA43, 0xD422, 0xCE43, 0xC8AF, 0xC36F, 0xBE8B, 0xBA09, 0xB5F2, 0xB24A, 0xAF18, 0xAC61, 0xAA27, 0xA870,
        0xA73D, 0xA690, 0xA66B, 0xA6CD, 0xA7B6, 0xA924, 0xAB16, 0xAD89, 0xB078, 0xB3DF, 0xB7B9, 0xBC01, 0xC0B0, 0xC5BE, 0xCB24, 0xD0DB,
        0xD6D8, 0xDD14, 0xE385, 0xEA21, 0xF0DE, 0xF7B1, 0xFE92, 0x0573, 0x0C4E, 0x1315, 0x19C0, 0x2044, 0x2697, 0x2CB0, 0x3285, 0x380D,
        0x3D41, 0x4219, 0x468C, 0x4A94, 0x4E2C, 0x514E, 0x53F5, 0x561C, 0x57C2, 0x58E2, 0x597D, 0x5990, 0x591B, 0x5820, 0x569F, 0x549C,
        0x5218, 0x4F19, 0x4BA1, 0x47B8, 0x4361, 0x3EA5, 0x398B, 0x3419, 0x2E58, 0x2851, 0x220E, 0x1B97, 0x14F6, 0x0E35, 0x075F, 0x007E,
        0xF99D, 0xF2C4, 0xEC00, 0xE55A, 0xDEDC, 0xD891, 0xD281, 0xCCB5, 0xC738, 0xC210, 0xBD46, 0xB8E1, 0xB4E7, 0xB15F, 0xAE4E, 0xABB9,
        0xA9A3, 0xA80F, 0xA701, 0xA679, 0xA678, 0xA6FF, 0xA80D, 0xA99F, 0xABB5, 0xAE49, 0xB15A, 0xB4E1, 0xB8DA, 0xBD3E, 0xC207, 0xC72F,
        0xCCAC, 0xD276, 0xD886, 0xDED1, 0xE54F, 0xEBF4, 0xF2B9, 0xF991, 0x0072, 0x0753, 0x0E29, 0x14EA, 0x1B8B, 0x2203, 0x2847, 0x2E4E,
        0x340F, 0x3981, 0x3E9D, 0x435A, 0x47B0, 0x4B9B, 0x4F13, 0x5213, 0x5498, 0x569C, 0x581E, 0x591A, 0x598F, 0x597D, 0x58E4, 0x57C4,
        0x5620, 0x53F9, 0x5153, 0x4E32, 0x4A9B, 0x4693, 0x4221, 0x3D4A, 0x3817, 0x328E, 0x2CBA, 0x26A2, 0x204F, 0x19CB, 0x1321, 0x0C59,
        0x057F, 0xFE9E, 0xF7BD, 0xF0E9, 0xEA2C, 0xE390, 0xDD1F, 0xD6E3, 0xD0E5, 0xCB2E, 0xC5C7, 0xC0B8, 0xBC09, 0xB7C0, 0xB3E5, 0xB07D,
        0xAD8D, 0xAB1A, 0xA927, 0xA7B8, 0xA6CE, 0xA66B, 0xA690, 0xA73C, 0xA86E, 0xAA24, 0xAC5C, 0xAF13, 0xB244, 0xB5EB, 0xBA02, 0xBE83,
        0xC366, 0xC8A6, 0xCE39, 0xD417, 0xDA38, 0xE092, 0xE71B, 0xEDCA, 0xF495, 0xFB71, 0x0253, 0x0932, 0x1004, 0x16BD, 0x1D54, 0x23BE,
        0x29F2, 0x2FE7, 0x3594, 0x3AEF, 0x3FF1, 0x4493, 0x48CD, 0x4C99, 0x4FF1, 0x52D0, 0x5532, 0x5713, 0x5870, 0x5947, 0x5998, 0x5961,
        0x58A3, 0x575E, 0x5596, 0x534C, 0x5084, 0x4D43, 0x498C, 0x4567, 0x40D8, 0x3BE8, 0x369C, 0x30FE, 0x2B16, 0x24ED, 0x1E8C, 0x17FD,
        0x114A, 0x0A7C, 0x039F, 0xFCBD, 0xF5DF, 0xEF10, 0xE85B, 0xE1CA, 0xDB66, 0xD53A, 0xCF4E, 0xC9AC, 0xC45C, 0xBF67, 0xBAD3, 0xB6A8,
        0xB2EC, 0xAFA4, 0xACD6, 0xAA85, 0xA8B6, 0xA76B, 0xA6A6, 0xA668, 0xA6B1, 0xA782, 0xA8D8, 0xAAB2, 0xAD0E, 0xAFE6, 0xB338, 0xB6FE,
        0xBB32, 0xBFCF, 0xC4CC, 0xCA23, 0xCFCC, 0xD5BD, 0xDBEE, 0xE256, 0xE8EB, 0xEFA3, 0xF673, 0xFD52, 0x0434, 0x0B10, 0x11DC, 0x188D,
        0x1F18, 0x2575, 0x2B99, 0x317B, 0x3712, 0x3C56, 0x413F, 0x45C5, 0x49E1, 0x4D8E, 0x50C5, 0x5383, 0x55C2, 0x577F, 0x58B8, 0x596B,
        0x5996, 0x593A, 0x5857, 0x56EF, 0x5503, 0x5296, 0x4FAD, 0x4C4B, 0x4876, 0x4433, 0x3F89, 0x3A7E, 0x351C, 0x2F69, 0x296E, 0x2335,
        0x1CC6, 0x162C, 0x0F71, 0x089E, 0x01BE, 0xFADC, 0xF401, 0xED39, 0xE68C, 0xE006, 0xD9B1, 0xD395, 0xCDBD, 0xC831, 0xC2F9, 0xBE1D,
        0xB9A5, 0xB598, 0xB1FB, 0xAED4, 0xAC27, 0xA9FA, 0xA84E, 0xA728, 0xA687, 0xA66E, 0xA6DD, 0xA7D2, 0xA94D, 0xAB4A, 0xADC8, 0xB0C2,
        0xB434, 0xB819, 0xBC6A, 0xC122, 0xC639, 0xCBA7, 0xD164, 0xD768, 0xDDA9, 0xE41E, 0xEABD, 0xF17C, 0xF852, 0xFF33, 0x0614, 0x0CED,
        0x13B2, 0x1A5A, 0x20DA, 0x2728, 0x2D3B, 0x3309, 0x388B, 0x3DB6, 0x4285, 0x46EF, 0x4AED, 0x4E7B, 0x5191, 0x542C, 0x5648, 0x57E2,
        0x58F6, 0x5984, 0x598B, 0x590A, 0x5802, 0x5676, 0x5466, 0x51D7, 0x4ECC, 0x4B4A, 0x4757, 0x42F7, 0x3E32, 0x390F, 0x3395, 0x2DCE,
        0x27C1, 0x2179, 0x1AFD, 0x1459, 0x0D96, 0x06BE, 0xFFDE, 0xF8FC, 0xF225, 0xEB63, 0xE4C0, 0xDE47, 0xD800, 0xD1F6, 0xCC32, 0xC6BC,
        0xC19C, 0xBCDB, 0xB87F, 0xB490, 0xB113, 0xAE0D, 0xAB83, 0xA978, 0xA7F1, 0xA6EF, 0xA673, 0xA67F, 0xA712, 0xA82C, 0xA9CB, 0xABEC,
        0xAE8C, 0xB1A7, 0xB539, 0xB93C, 0xBDAA, 0xC27C, 0xC7AB, 0xCD30, 0xD301, 0xD917, 0xDF67, 0xE5E9, 0xEC92, 0xF358, 0xFA32, 0x0113,
        0x07F4, 0x0EC8, 0x1587, 0x1C24, 0x2298, 0x28D6, 0x2ED8, 0x3492, 0x39FD, 0x3F10, 0x43C3, 0x4811, 0x4BF1, 0x4F5E, 0x5254, 0x54CC,
        0x56C5, 0x583A, 0x592A, 0x5993, 0x5975, 0x58CF, 0x57A3, 0x55F3, 0x53C0, 0x510F, 0x4DE3, 0x4A41, 0x4630, 0x41B3, 0x3CD4, 0x3799,
        0x3209, 0x2C2E, 0x2610, 0x1FB8, 0x1931, 0x1283, 0x0BBA, 0x04DE, 0xFDFD, 0xF71D, 0xF04B, 0xE990, 0xE2F8, 0xDC8B, 0xD654, 0xD05C,
        0xCAAC, 0xC54D, 0xC046, 0xBBA0, 0xB761, 0xB391, 0xB033, 0xAD4F, 0xAAE7, 0xA900, 0xA79D, 0xA6C0, 0xA669, 0xA69A, 0xA752, 0xA890,
        0xAA53, 0xAC97, 0xAF59, 0xB295, 0xB646, 0xBA67, 0xBEF1, 0xC3DD, 0xC925, 0xCEBF, 0xD4A4, 0xDACA, 0xE129, 0xE7B6, 0xEE68, 0xF535,
        0xFC12, 0x02F4, 0x09D2, 0x10A2, 0x1758, 0x1DEC, 0x2451, 0x2A80, 0x306F, 0x3614, 0x3B68, 0x4062, 0x44FA, 0x492A, 0x4CEC, 0x5039,
        0x530D, 0x5563, 0x5738, 0x5889, 0x5954, 0x5998, 0x5955, 0x588B, 0x573A, 0x5566, 0x5310, 0x503D, 0x4CF1, 0x4930, 0x4501, 0x4069,
        0x3B6F, 0x361C, 0x3077, 0x2A89, 0x245A, 0x1DF5, 0x1762, 0x10AC, 0x09DC, 0x02FE, 0xFC1C, 0xF53F, 0xEE72, 0xE7C0, 0xE132, 0xDAD3,
        0xD4AC, 0xCEC7, 0xC92D, 0xC3E5, 0xBEF8, 0xBA6D, 0xB64C, 0xB29A, 0xAF5D, 0xAC9A, 0xAA55, 0xA892, 0xA753, 0xA69A, 0xA669, 0xA6BF,
        0xA79B, 0xA8FE, 0xAAE4, 0xAD4B, 0xB02F, 0xB38B, 0xB75C, 0xBB9A, 0xC03F, 0xC545, 0xCAA4, 0xD054, 0xD64B, 0xDC82, 0xE2EE, 0xE987,
        0xF041, 0xF713, 0xFDF3, 0x04D5, 0x0BB0, 0x127A, 0x1928, 0x1FAF, 0x2607, 0x2C25, 0x3201, 0x3791, 0x3CCD, 0x41AD, 0x4629, 0x4A3C,
        0x4DDE, 0x510B, 0x53BD, 0x55F0, 0x57A1, 0x58CE, 0x5974, 0x5993, 0x592B, 0x583C, 0x56C7, 0x54D0, 0x5257, 0x4F63, 0x4BF6, 0x4816,
        0x43CA, 0x3F17, 0x3A04, 0x349A, 0x2EE0, 0x28DF, 0x22A1, 0x1C2E, 0x1590, 0x0ED2, 0x07FD, 0x011D, 0xFA3B, 0xF362, 0xEC9B, 0xE5F2,
        0xDF70, 0xD920, 0xD30A, 0xCD38, 0xC7B3, 0xC283, 0xBDB1, 0xB942, 0xB53E, 0xB1AC, 0xAE90, 0xABEF, 0xA9CD, 0xA82E, 0xA714, 0xA67F,
        0xA673, 0xA6EE, 0xA7EF, 0xA976, 0xAB7F, 0xAE09, 0xB10E, 0xB48B, 0xB879, 0xBCD4, 0xC195, 0xC6B4, 0xCC2A, 0xD1EE, 0xD7F7, 0xDE3E,
        0xE4B7, 0xEB5A, 0xF21B, 0xF8F2, 0xFFD4, 0x06B5, 0x0D8C, 0x144F, 0x1AF4, 0x216F, 0x27B9, 0x2DC6, 0x338D, 0x3907, 0x3E2B, 0x42F0,
        0x4751, 0x4B45, 0x4EC8, 0x51D3, 0x5463, 0x5673, 0x5800, 0x5909, 0x598A, 0x5984, 0x58F7, 0x57E3, 0x564B, 0x5430, 0x5195, 0x4E7F,
        0x4AF3, 0x46F5, 0x428B, 0x3DBE, 0x3892, 0x3311, 0x2D43, 0x2731, 0x20E3, 0x1A63, 0x13BC, 0x0CF7, 0x061E, 0xFF3D, 0xF85C, 0xF186,
        0xEAC7, 0xE427, 0xDDB2, 0xD770, 0xD16C, 0xCBAF, 0xC640, 0xC129, 0xBC71, 0xB81F, 0xB439, 0xB0C7, 0xADCC, 0xAB4D, 0xA94F, 0xA7D4,
        0xA6DE, 0xA66F, 0xA687, 0xA726, 0xA84C, 0xA9F7, 0xAC24, 0xAECF, 0xB1F6, 0xB592, 0xB99F, 0xBE17, 0xC2F2, 0xC829, 0xCDB5, 0xD38D,
        0xD9A8, 0xDFFD, 0xE683, 0xED2F, 0xF3F7, 0xFAD2, 0x01B4, 0x0894, 0x0F67, 0x1623, 0x1CBD, 0x232C, 0x2966, 0x2F61, 0x3514, 0x3A77,
        0x3F82, 0x442C, 0x4870, 0x4C46, 0x4FA8, 0x5293, 0x5500, 0x56ED, 0x5856, 0x5939, 0x5996, 0x596B, 0x58B9, 0x5781, 0x55C5, 0x5386,
        0x50CA, 0x4D93, 0x49E7, 0x45CB, 0x4146, 0x3C5D, 0x371A, 0x3183, 0x2BA2, 0x257E, 0x1F22, 0x1896, 0x11E6, 0x0B1A, 0x043D, 0xFD5C,
        0xF67D, 0xEFAC, 0xE8F4, 0xE25F, 0xDBF7, 0xD5C6, 0xCFD4, 0xCA2B, 0xC4D4, 0xBFD6, 0xBB39, 0xB704, 0xB33D, 0xAFEB, 0xAD11, 0xAAB5,
        0xA8DA, 0xA783, 0xA6B2, 0xA668, 0xA6A5, 0xA769, 0xA8B4, 0xAA82, 0xACD2, 0xAF9F, 0xB2E7, 0xB6A2, 0xBACD, 0xBF60, 0xC455, 0xC9A4,
        0xCF46, 0xD531, 0xDB5D, 0xE1C0, 0xE851, 0xEF06, 0xF5D5, 0xFCB3, 0x0395, 0x0A72, 0x1140, 0x17F4, 0x1E83, 0x24E4, 0x2B0E, 0x30F6,
        0x3695, 0x3BE0, 0x40D1, 0x4561, 0x4987, 0x4D3E, 0x5080, 0x5349, 0x5593, 0x575C, 0x58A1, 0x5960, 0x5998, 0x5948, 0x5871, 0x5715,
        0x5535, 0x52D4, 0x4FF5, 0x4C9E, 0x48D3, 0x4499, 0x3FF8, 0x3AF7, 0x359C, 0x2FF0, 0x29FB, 0x23C7, 0x1D5D, 0x16C6, 0x100D, 0x093C,
        0x025D, 0xFB7B, 0xF49F, 0xEDD4, 0xE725, 0xE09B, 0xDA41, 0xD420, 0xCE41, 0xC8AD, 0xC36E, 0xBE89, 0xBA08, 0xB5F1, 0xB249, 0xAF17,
        0xAC60, 0xAA27, 0xA870, 0xA73D, 0xA690, 0xA66B, 0xA6CD, 0xA7B6, 0xA925, 0xAB17, 0xAD89, 0xB079, 0xB3E0, 0xB7BA, 0xBC02, 0xC0B1,
        0xC5BF, 0xCB26, 0xD0DC, 0xD6DA, 0xDD16, 0xE387, 0xEA23, 0xF0E0, 0xF7B3, 0xFE94, 0x0575, 0x0C50, 0x1317, 0x19C2, 0x2046, 0x2699,
        0x2CB1, 0x3286, 0x380F, 0x3D43, 0x421A, 0x468D, 0x4A96, 0x4E2D, 0x514F, 0x53F5, 0x561D, 0x57C2, 0x58E3, 0x597D, 0x5990, 0x591B,
        0x581F, 0x569F, 0x549B, 0x5217, 0x4F18, 0x4BA0, 0x47B6, 0x4360, 0x3EA4, 0x3989, 0x3417, 0x2E56, 0x2850, 0x220C, 0x1B95, 0x14F4,
        0x0E33, 0x075D, 0x007C, 0xF99B, 0xF2C2, 0xEBFE, 0xE558, 0xDEDA, 0xD88F, 0xD27F, 0xCCB4, 0xC736, 0xC20F, 0xBD45, 0xB8E0, 0xB4E6,
        0xB15E, 0xAE4D, 0xABB8, 0xA9A2, 0xA80F, 0xA700, 0xA679, 0xA678, 0xA6FF, 0xA80D, 0xA9A0, 0xABB5, 0xAE4A, 0xB15B, 0xB4E2, 0xB8DB,
        0xBD3F, 0xC209, 0xC730, 0xCCAD, 0xD278, 0xD888, 0xDED3, 0xE551, 0xEBF6, 0xF2BB, 0xF993, 0x0074, 0x0755, 0x0E2B, 0x14EC, 0x1B8D,
        0x2205, 0x2849, 0x2E50, 0x3411, 0x3983, 0x3E9E, 0x435B, 0x47B2, 0x4B9C, 0x4F14, 0x5214, 0x5498, 0x569D, 0x581E, 0x591A, 0x598F,
        0x597D, 0x58E4, 0x57C4, 0x561F, 0x53F8, 0x5152, 0x4E31, 0x4A9A, 0x4692, 0x421F, 0x3D48, 0x3815, 0x328D, 0x2CB8, 0x26A0, 0x204D,
        0x19C9, 0x131F, 0x0C57, 0x057D, 0xFE9C, 0xF7BB, 0xF0E7, 0xEA2A, 0xE38E, 0xDD1D, 0xD6E1, 0xD0E3, 0xCB2C, 0xC5C5, 0xC0B6, 0xBC07,
        0xB7BF, 0xB3E4, 0xB07C, 0xAD8C, 0xAB19, 0xA927, 0xA7B8, 0xA6CE, 0xA66B, 0xA690, 0xA73C, 0xA86E, 0xAA25, 0xAC5D, 0xAF14, 0xB245,
        0xB5EC, 0xBA03, 0xBE84, 0xC368, 0xC8A7, 0xCE3B, 0xD419, 0xDA3A, 0xE094, 0xE71D, 0xEDCC, 0xF497, 0xFB73, 0x0255, 0x0934, 0x1006,
        0x16BF, 0x1D55, 0x23C0, 0x29F4, 0x2FE9, 0x3595, 0x3AF1, 0x3FF3, 0x4494, 0x48CE, 0x4C9A, 0x4FF2, 0x52D1, 0x5532, 0x5713, 0x5870,
        0x5947, 0x5998, 0x5961, 0x58A2, 0x575E, 0x5595, 0x534B, 0x5084, 0x4D42, 0x498B, 0x4566, 0x40D7, 0x3BE6, 0x369B, 0x30FD, 0x2B15,
        0x24EB, 0x1E8A, 0x17FB, 0x1148, 0x0A7A, 0x039D, 0xFCBB, 0xF5DD, 0xEF0E, 0xE859, 0xE1C8, 0xDB64, 0xD538, 0xCF4C, 0xC9AB, 0xC45B,
        0xBF66, 0xBAD2, 0xB6A7, 0xB2EA, 0xAFA3, 0xACD5, 0xAA85, 0xA8B6, 0xA76B, 0xA6A6, 0xA668, 0xA6B1, 0xA782, 0xA8D9, 0xAAB3, 0xAD0E,
        0xAFE7, 0xB339, 0xB6FF, 0xBB34, 0xBFD0, 0xC4CE, 0xCA25, 0xCFCD, 0xD5BF, 0xDBF0, 0xE258, 0xE8ED, 0xEFA5, 0xF675, 0xFD54, 0x0436,
        0x0B12, 0x11DE, 0x188F, 0x1F1A, 0x2577, 0x2B9B, 0x317D, 0x3714, 0x3C58, 0x4140, 0x45C6, 0x49E2, 0x4D8F, 0x50C6, 0x5383, 0x55C2,
        0x577F, 0x58B8, 0x596B, 0x5996, 0x593A, 0x5857, 0x56EE, 0x5502, 0x5296, 0x4FAC, 0x4C4A, 0x4874, 0x4431, 0x3F87, 0x3A7D, 0x351A,
        0x2F67, 0x296C, 0x2333, 0x1CC4, 0x162A, 0x0F6F, 0x089C, 0x01BC, 0xFADA, 0xF3FF, 0xED37, 0xE68A, 0xE005, 0xD9AF, 0xD394, 0xCDBB,
        0xC82F, 0xC2F7, 0xBE1C, 0xB9A4, 0xB597, 0xB1FA, 0xAED3, 0xAC27, 0xA9F9, 0xA84E, 0xA727, 0xA687, 0xA66E, 0xA6DD, 0xA7D2, 0xA94D,
        0xAB4B, 0xADC9, 0xB0C3, 0xB435, 0xB81A, 0xBC6C, 0xC123, 0xC63A, 0xCBA8, 0xD166, 0xD769, 0xDDAB, 0xE420, 0xEABF, 0xF17E, 0xF854,
        0xFF35, 0x0616, 0x0CEF, 0x13B4, 0x1A5C, 0x20DC, 0x272A, 0x2D3D, 0x330B, 0x388C, 0x3DB8, 0x4286, 0x46F0, 0x4AEE, 0x4E7C, 0x5192,
        0x542D, 0x5649, 0x57E2, 0x58F6, 0x5984, 0x598B, 0x590A, 0x5802, 0x5675, 0x5466, 0x51D6, 0x4ECB, 0x4B49, 0x4755, 0x42F6, 0x3E30,
        0x390D, 0x3394, 0x2DCC, 0x27C0, 0x2177, 0x1AFB, 0x1457, 0x0D94, 0x06BC, 0xFFDC, 0xF8FA, 0xF223, 0xEB61, 0xE4BE, 0xDE45, 0xD7FE,
        0xD1F4, 0xCC30, 0xC6BA, 0xC19B, 0xBCDA, 0xB87E, 0xB48F, 0xB112, 0xAE0C, 0xAB82, 0xA978, 0xA7F0, 0xA6EE, 0xA673, 0xA67F, 0xA713,
        0xA82C, 0xA9CB, 0xABEC, 0xAE8D, 0xB1A8, 0xB53A, 0xB93D, 0xBDAB, 0xC27E, 0xC7AD, 0xCD32, 0xD303, 0xD919, 0xDF69, 0xE5EB, 0xEC94,
        0xF35A, 0xFA34, 0x0115, 0x07F6, 0x0ECA, 0x1589, 0x1C26, 0x2299, 0x28D8, 0x2ED9, 0x3494, 0x39FE, 0x3F11, 0x43C5, 0x4812, 0x4BF2,
        0x4F5F, 0x5254, 0x54CD, 0x56C5, 0x583B, 0x592A, 0x5993, 0x5975, 0x58CF, 0x57A3, 0x55F2, 0x53BF, 0x510E, 0x4DE2, 0x4A40, 0x462E,
        0x41B2, 0x3CD3, 0x3797, 0x3207, 0x2C2C, 0x260E, 0x1FB7, 0x192F, 0x1281, 0x0BB8, 0x04DC, 0xFDFB, 0xF71B, 0xF049, 0xE98E, 0xE2F6,
        0xDC89, 0xD652, 0xD05A, 0xCAAA, 0xC54B, 0xC045, 0xBB9F, 0xB760, 0xB390, 0xB032, 0xAD4E, 0xAAE7, 0xA900, 0xA79D, 0xA6BF, 0xA669,
        0xA69A, 0xA752, 0xA891, 0xAA53, 0xAC97, 0xAF5A, 0xB296, 0xB647, 0xBA68, 0xBEF2, 0xC3DF, 0xC926, 0xCEC1, 0xD4A6, 0xDACC, 0xE12B,
        0xE7B8, 0xEE6A, 0xF537, 0xFC14, 0x02F6, 0x09D4, 0x10A4, 0x175A, 0x1DED, 0x2453, 0x2A82, 0x3071, 0x3616, 0x3B6A, 0x4063, 0x44FC,
        0x492C, 0x4CED, 0x503A, 0x530D, 0x5563, 0x5738, 0x5889, 0x5954, 0x5998, 0x5955, 0x588A, 0x573A, 0x5565, 0x5310, 0x503C, 0x4CF0,
        0x492F, 0x44FF, 0x4067, 0x3B6E, 0x361B, 0x3076, 0x2A87, 0x2459, 0x1DF3, 0x1760, 0x10AA, 0x09DA, 0x02FC, 0xFC1A, 0xF53D, 0xEE70,
        0xE7BE, 0xE130, 0xDAD1, 0xD4AB, 0xCEC6, 0xC92B, 0xC3E3, 0xBEF6, 0xBA6C, 0xB64B, 0xB299, 0xAF5C, 0xAC99, 0xAA55, 0xA892, 0xA753,
        0xA69A, 0xA669, 0xA6BF, 0xA79C, 0xA8FE, 0xAAE5, 0xAD4C, 0xB030, 0xB38D, 0xB75D, 0xBB9B, 0xC041, 0xC547, 0xCAA6, 0xD055, 0xD64D,
        0xDC84, 0xE2F0, 0xE989, 0xF043, 0xF715, 0xFDF5, 0x04D7, 0x0BB2, 0x127C, 0x1929, 0x1FB1, 0x2609, 0x2C27, 0x3203, 0x3793, 0x3CCE,
        0x41AE, 0x462B, 0x4A3D, 0x4DDF, 0x510B, 0x53BD, 0x55F0, 0x57A1, 0x58CE, 0x5974, 0x5993, 0x592B, 0x583C, 0x56C7, 0x54CF, 0x5257,
        0x4F62, 0x4BF5, 0x4815, 0x43C8, 0x3F15, 0x3A03, 0x3498, 0x2EDE, 0x28DD, 0x229F, 0x1C2C, 0x158E, 0x0ED0, 0x07FB, 0x011B, 0xFA39,
        0xF360, 0xEC99, 0xE5F0, 0xDF6E, 0xD91E, 0xD308, 0xCD36, 0xC7B2, 0xC282, 0xBDAF, 0xB941, 0xB53D, 0xB1AB, 0xAE8F, 0xABEE, 0xA9CD,
        0xA82E, 0xA713, 0xA67F, 0xA673, 0xA6EE, 0xA7EF, 0xA976, 0xAB80, 0xAE09, 0xB10F, 0xB48C, 0xB87B, 0xBCD6, 0xC196, 0xC6B6, 0xCC2B,
        0xD1EF, 0xD7F9, 0xDE40, 0xE4B9, 0xEB5C, 0xF21D, 0xF8F4, 0xFFD6, 0x06B7, 0x0D8E, 0x1451, 0x1AF6, 0x2171, 0x27BA, 0x2DC7, 0x338F,
        0x3909, 0x3E2C, 0x42F2, 0x4752, 0x4B46, 0x4EC9, 0x51D4, 0x5464, 0x5674, 0x5801, 0x5909, 0x598A, 0x5984, 0x58F7, 0x57E3, 0x564A,
        0x542F, 0x5194, 0x4E7E, 0x4AF2, 0x46F3, 0x428A, 0x3DBC, 0x3891, 0x3310, 0x2D42, 0x272F, 0x20E1, 0x1A62, 0x13BA, 0x0CF5, 0x061C,
        0xFF3B, 0xF85A, 0xF184, 0xEAC5, 0xE425, 0xDDB0, 0xD76F, 0xD16B, 0xCBAD, 0xC63F, 0xC127, 0xBC6F, 0xB81E, 0xB438, 0xB0C6, 0xADCB,
        0xAB4D, 0xA94F, 0xA7D3, 0xA6DE, 0xA66F, 0xA687, 0xA727, 0xA84D, 0xA9F8, 0xAC25, 0xAED0, 0xB1F7, 0xB593, 0xB9A0, 0xBE18, 0xC2F3,
        0xC82B, 0xCDB7, 0xD38F, 0xD9AA, 0xDFFF, 0xE685, 0xED31, 0xF3FA, 0xFAD4, 0x01B6, 0x0896, 0x0F69, 0x1625, 0x1CBF, 0x232E, 0x2967,
        0x2F62, 0x3516, 0x3A79, 0x3F83, 0x442E, 0x4871, 0x4C47, 0x4FA9, 0x5293, 0x5500, 0x56ED, 0x5856, 0x593A, 0x5996, 0x596B, 0x58B9,
        0x5781, 0x55C4, 0x5386, 0x50C9, 0x4D92, 0x49E6, 0x45CA, 0x4144, 0x3C5C, 0x3718, 0x3182, 0x2BA0, 0x257C, 0x1F20, 0x1894, 0x11E4,
        0x0B18, 0x043B, 0xFD5A, 0xF67B, 0xEFAA, 0xE8F2, 0xE25E, 0xDBF5, 0xD5C4, 0xCFD2, 0xCA29, 0xC4D2, 0xBFD4, 0xBB37, 0xB702, 0xB33C,
        0xAFEA, 0xAD10, 0xAAB5, 0xA8DA, 0xA783, 0xA6B2, 0xA668, 0xA6A5, 0xA76A, 0xA8B4, 0xAA83, 0xACD3, 0xAFA0, 0xB2E8, 0xB6A3, 0xBACE,
        0xBF62, 0xC457, 0xC9A6, 0xCF48, 0xD533, 0xDB5F, 0xE1C2, 0xE853, 0xEF08, 0xF5D7, 0xFCB5, 0x0397, 0x0A74, 0x1142, 0x17F6, 0x1E85,
        0x24E6, 0x2B10, 0x30F8, 0x3696, 0x3BE2, 0x40D3, 0x4562, 0x4988, 0x4D3F, 0x5081, 0x5349, 0x5594, 0x575D, 0x58A1, 0x5960, 0x5998,
        0x5948, 0x5871, 0x5714, 0x5534, 0x52D3, 0x4FF4, 0x4C9D, 0x48D2, 0x4498, 0x3FF7, 0x3AF5, 0x359A, 0x2FEE, 0x29F9, 0x23C5, 0x1D5B,
        0x16C4, 0x100B, 0x093A, 0x025B, 0xFB79, 0xF49D, 0xEDD2, 0xE723, 0xE099, 0xDA3F, 0xD41E, 0xCE3F, 0xC8AC, 0xC36C, 0xBE88, 0xBA07,
        0xB5F0, 0xB248, 0xAF17, 0xAC5F, 0xAA26, 0xA86F, 0xA73D, 0xA690, 0xA66B, 0xA6CD, 0xA7B7, 0xA925, 0xAB18, 0xAD8A, 0xB079, 0xB3E1,
        0xB7BC, 0xBC04, 0xC0B2, 0xC5C1, 0xCB28, 0xD0DE, 0xD6DC, 0xDD18, 0xE389, 0xEA25, 0xF0E2, 0xF7B5, 0xFE96, 0x0577, 0x0C52, 0x1319,
        0x19C4, 0x2048, 0x269B, 0x2CB3, 0x3288, 0x3811, 0x3D44, 0x421B, 0x468E, 0x4A97, 0x4E2E, 0x5150, 0x53F6, 0x561D, 0x57C2, 0x58E3,
        0x597D, 0x598F, 0x591B, 0x581F, 0x569E, 0x549A, 0x5217, 0x4F17, 0x4B9F, 0x47B5, 0x435F, 0x3EA2, 0x3987, 0x3415, 0x2E55, 0x284E,
        0x220A, 0x1B93, 0x14F2, 0x0E31, 0x075B, 0x007A, 0xF999, 0xF2C0, 0xEBFC, 0xE556, 0xDED8, 0xD88D, 0xD27D, 0xCCB2, 0xC735, 0xC20D,
        0xBD43, 0xB8DE, 0xB4E5, 0xB15D, 0xAE4C, 0xABB7, 0xA9A1, 0xA80E, 0xA700, 0xA679, 0xA678, 0xA700, 0xA80E, 0xA9A0, 0xABB6, 0xAE4B,
        0xB15C, 0xB4E3, 0xB8DC, 0xBD41, 0xC20A, 0xC732, 0xCCAF, 0xD27A, 0xD88A, 0xDED5, 0xE553, 0xEBF8, 0xF2BD, 0xF995, 0x0076, 0x0757,
        0x0E2D, 0x14EE, 0x1B8F, 0x2207, 0x284A, 0x2E51, 0x3412, 0x3985, 0x3EA0, 0x435C, 0x47B3, 0x4B9D, 0x4F15, 0x5215, 0x5499, 0x569D,
        0x581E, 0x591A, 0x598F, 0x597D, 0x58E3, 0x57C3, 0x561E, 0x53F7, 0x5151, 0x4E30, 0x4A99, 0x4691, 0x421E, 0x3D47, 0x3813, 0x328B,
        0x2CB6, 0x269E, 0x204B, 0x19C7, 0x131D, 0x0C55, 0x057B, 0xFE9A, 0xF7B9, 0xF0E5, 0xEA28, 0xE38C, 0xDD1B, 0xD6DF, 0xD0E1, 0xCB2B,
        0xC5C4, 0xC0B5, 0xBC06, 0xB7BE, 0xB3E3, 0xB07B, 0xAD8C, 0xAB19, 0xA926, 0xA7B7, 0xA6CE, 0xA66B, 0xA690, 0xA73C, 0xA86E, 0xAA25,
        0xAC5E, 0xAF15, 0xB246, 0xB5ED, 0xBA05, 0xBE85, 0xC369, 0xC8A9, 0xCE3C, 0xD41B, 0xDA3C, 0xE096, 0xE71F, 0xEDCE, 0xF499, 0xFB75,
        0x0257, 0x0936, 0x1008, 0x16C1, 0x1D57, 0x23C2, 0x29F6, 0x2FEB, 0x3597, 0x3AF2, 0x3FF4, 0x4496, 0x48CF, 0x4C9B, 0x4FF3, 0x52D1,
        0x5533, 0x5713, 0x5870, 0x5948, 0x5998, 0x5961, 0x58A2, 0x575D, 0x5595, 0x534B, 0x5083, 0x4D41, 0x498A, 0x4564, 0x40D5, 0x3BE5,
        0x3699, 0x30FB, 0x2B13, 0x24EA, 0x1E89, 0x17F9, 0x1146, 0x0A78, 0x039B, 0xFCB9, 0xF5DB, 0xEF0C, 0xE857, 0xE1C6, 0xDB62, 0xD536,
        0xCF4B, 0xC9A9, 0xC459, 0xBF64, 0xBAD0, 0xB6A6, 0xB2E9, 0xAFA2, 0xACD4, 0xAA84, 0xA8B5, 0xA76A, 0xA6A5, 0xA668, 0xA6B2, 0xA782,
        0xA8D9, 0xAAB4, 0xAD0F, 0xAFE8, 0xB33A, 0xB700, 0xBB35, 0xBFD1, 0xC4CF, 0xCA26, 0xCFCF, 0xD5C1, 0xDBF2, 0xE25A, 0xE8EF, 0xEFA7,
        0xF677, 0xFD56, 0x0438, 0x0B14, 0x11E0, 0x1891, 0x1F1C, 0x2579, 0x2B9D, 0x317E, 0x3715, 0x3C59, 0x4142, 0x45C7, 0x49E4, 0x4D90,
        0x50C7, 0x5341, 0x553A, 0x56AE, 0x579D, 0x5805, 0x57E9, 0x5747, 0x5623, 0x547E, 0x525C, 0x4FC1, 0x4CB1, 0x4933, 0x454C, 0x4103,
        0x3C5E, 0x3765, 0x3222, 0x2C9B, 0x26DA, 0x20E7, 0x1ACD, 0x1495, 0x0E48, 0x07F0, 0x0196, 0xFB46, 0xF507, 0xEEE3, 0xE8E3, 0xE311,
        0xDD74, 0xD815, 0xD2FB, 0xCE2F, 0xC9B6, 0xC597, 0xC1D7, 0xBE7C, 0xBB8A, 0xB904, 0xB6EE, 0xB54B, 0xB41B, 0xB360, 0xB31A, 0xB349,
        0xB3EC, 0xB500, 0xB684, 0xB875, 0xBACE, 0xBD8C, 0xC0A9, 0xC420, 0xC7EC, 0xCC06, 0xD067, 0xD508, 0xD9E1, 0xDEEB, 0xE41E, 0xE972,
        0xEEDE, 0xF45A, 0xF9DD, 0xFF60, 0x04D8, 0x0A3F, 0x0F8E, 0x14BA, 0x19BE, 0x1E91, 0x232D, 0x278B, 0x2BA5, 0x2F75, 0x32F6, 0x3623,
        0x38F8, 0x3B72, 0x3D8D, 0x3F47, 0x409D, 0x4190, 0x421D, 0x4245, 0x4209, 0x4169, 0x4068, 0x3F07, 0x3D4A, 0x3B33, 0x38C6, 0x3609,
        0x3300, 0x2FAF, 0x2C1D, 0x284F, 0x244C, 0x201A, 0x1BC0, 0x1744, 0x12AF, 0x0E07, 0x0953, 0x049B, 0xFFE6, 0xFB3A, 0xF69F, 0xF21C,
        0xEDB7, 0xE977, 0xE562, 0xE17E, 0xDDD1, 0xDA5E, 0xD72C, 0xD43F, 0xD19A, 0xCF41, 0xCD36, 0xCB7D, 0xCA17, 0xC906, 0xC84A, 0xC7E4,
        0xC7D4, 0xC819, 0xC8B2, 0xC99E, 0xCAD9, 0xCC63, 0xCE37, 0xD053, 0xD2B2, 0xD550, 0xD829, 0xDB38, 0xDE78, 0xE1E4, 0xE575, 0xE926,
        0xECF2, 0xF0D1, 0xF4BF, 0xF8B5, 0xFCAD, 0x009F, 0x0489, 0x0862, 0x0C26, 0x0FCF, 0x1357, 0x16BA, 0x19F2, 0x1CFB, 0x1FD1, 0x2270,
        0x24D5, 0x26FC, 0x28E3, 0x2A88, 0x2BE8, 0x2D02, 0x2DD6, 0x2E61, 0x2EA6, 0x2EA3, 0x2E59, 0x2DCA, 0x2CF7, 0x2BE2, 0x2A8D, 0x28FA,
        0x272E, 0x252B, 0x22F5, 0x208F, 0x1DFE, 0x1B46, 0x186C, 0x1574, 0x1263, 0x0F3F, 0x0C0B, 0x08CE, 0x058B, 0x0249, 0xFF0D, 0xFBDA,
        0xF8B5, 0xF5A4, 0xF2AB, 0xEFCF, 0xED12, 0xEA7A, 0xE809, 0xE5C3, 0xE3AB, 0xE1C4, 0xE010, 0xDE91, 0xDD49, 0xDC39, 0xDB62, 0xDAC6,
        0xDA63, 0xDA3B, 0xDA4C, 0xDA96, 0xDB19, 0xDBD2, 0xDCBF, 0xDDE0, 0xDF31, 0xE0B0, 0xE25A, 0xE42C, 0xE623, 0xE83C, 0xEA73, 0xECC3,
        0xEF2A, 0xF1A3, 0xF42B, 0xF6BD, 0xF955, 0xFBF0, 0xFE89, 0x011B, 0x03A4, 0x0620, 0x088B, 0x0AE2, 0x0D20, 0x0F44, 0x114A, 0x132F,
        0x14F1, 0x168D, 0x1802, 0x194E, 0x1A6F, 0x1B65, 0x1C2D, 0x1CC8, 0x1D36, 0x1D75, 0x1D87, 0x1D6C, 0x1D24, 0x1CB1, 0x1C14, 0x1B4F,
        0x1A62, 0x1950, 0x181C, 0x16C7, 0x1554, 0x13C5, 0x121E, 0x1061, 0x0E92, 0x0CB2, 0x0AC6, 0x08D1, 0x06D5, 0x04D5, 0x02D6, 0x00DA,
        0xFEE4, 0xFCF7, 0xFB15, 0xF942, 0xF780, 0xF5D1, 0xF438, 0xF2B8, 0xF151, 0xF006, 0xEED9, 0xEDCA, 0xECDB, 0xEC0D, 0xEB60, 0xEAD6,
        0xEA6E, 0xEA29, 0xEA06, 0xEA05, 0xEA26, 0xEA68, 0xEAC9, 0xEB4A, 0xEBE8, 0xECA2, 0xED77, 0xEE64, 0xEF69, 0xF082, 0xF1AF, 0xF2ED,
        0xF439, 0xF591, 0xF6F4, 0xF85E, 0xF9CE, 0xFB41, 0xFCB4, 0xFE27, 0xFF95, 0x00FD, 0x025D, 0x03B4, 0x04FF, 0x063C, 0x0769, 0x0886,
        0x0990, 0x0A87, 0x0B69, 0x0C35, 0x0CEA, 0x0D88, 0x0E0F, 0x0E7C, 0x0ED2, 0x0F0F, 0x0F34, 0x0F40, 0x0F35, 0x0F12, 0x0ED9, 0x0E8B,
        0x0E27, 0x0DB0, 0x0D26, 0x0C8B, 0x0BDF, 0x0B25, 0x0A5E, 0x098B, 0x08AD, 0x07C8, 0x06DB, 0x05E9, 0x04F3, 0x03FB, 0x0303, 0x020B,
        0x0116, 0x0025, 0xFF3B, 0xFE56, 0xFD7A, 0xFCA7, 0xFBDE, 0xFB20, 0xFA6F, 0xF9CB, 0xF934, 0xF8AC, 0xF833, 0xF7C9, 0xF76F, 0xF725,
        0xF6EB, 0xF6C0, 0xF6A5, 0xF699, 0xF69D, 0xF6AF, 0xF6D0, 0xF6FE, 0xF738, 0xF780, 0xF7D2, 0xF82F, 0xF896, 0xF905, 0xF97C, 0xF9FA,
        0xFA7D, 0xFB06, 0xFB91, 0xFC20, 0xFCB0, 0xFD41, 0xFDD1, 0xFE61, 0xFEED, 0xFF77, 0xFFFD, 0x007E, 0x00FA, 0x0170, 0x01E0, 0x0248,
        0x02A9, 0x0302, 0x0352, 0x039A, 0x03DA, 0x0410, 0x043E, 0x0463, 0x047F, 0x0492, 0x049D, 0x049F, 0x049A, 0x048D, 0x0479, 0x045F,
        0x043E, 0x0417, 0x03EB, 0x03BB, 0x0386, 0x034E, 0x0313, 0x02D6, 0x0296, 0x0256, 0x0214, 0x01D3, 0x0192, 0x0152, 0x0113, 0x00D6,
        0x009B, 0x0062, 0x002C, 0xFFFB, 0xFFCC, 0xFFA0, 0xFF78, 0xFF54, 0xFF34, 0xFF18, 0xFF00, 0xFEEC, 0xFEDC, 0xFED0, 0xFEC8, 0xFEC3,
        0xFEC1, 0xFEC3, 0xFEC7, 0xFECE, 0xFED7, 0xFEE3, 0xFEF0, 0xFEFF, 0xFF0F, 0xFF21, 0xFF32, 0xFF45, 0xFF57, 0xFF69, 0xFF7B, 0xFF8C,
        0xFF9D, 0xFFAC, 0xFFBB, 0xFFC8, 0xFFD4, 0xFFDE, 0xFFE7, 0xFFEF, 0xFFF5, 0xFFFA, 0xFFFD, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFC, 0xFFFB, 0xFFF9, 0xFFF7, 0xFFF5, 0xFFF2, 0xFFF0, 0xFFED, 0xFFEA,
        0xFFE7, 0xFFE4, 0xFFE1, 0xFFDE, 0xFFDB, 0xFFD8, 0xFFD6, 0xFFD3, 0xFFD1, 0xFFD0, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFD0, 0xFFD2, 0xFFD4,
        0xFFD8, 0xFFDC, 0xFFE1, 0xFFE8, 0xFFEF, 0xFFF7, 0x0000, 0x000A, 0x0016, 0x0022, 0x002F, 0x003E, 0x004D, 0x005D, 0x006E, 0x007F,
        0x0091, 0x00A4, 0x00B7, 0x00CA, 0x00DD, 0x00F0, 0x0103, 0x0115, 0x0127, 0x0139, 0x0149, 0x0159, 0x0167, 0x0173, 0x017F, 0x0188,
        0x0190, 0x0195, 0x0199, 0x019A, 0x0198, 0x0194, 0x018D, 0x0184, 0x0177, 0x0168, 0x0155, 0x0140, 0x0127, 0x010B, 0x00EC, 0x00CB,
        0x00A6, 0x007E, 0x0054, 0x0027, 0xFFF9, 0xFFC7, 0xFF94, 0xFF5E, 0xFF27, 0xFEEF, 0xFEB5, 0xFE7B, 0xFE40, 0xFE05, 0xFDCA, 0xFD90,
        0xFD57, 0xFD1F, 0xFCE9, 0xFCB4, 0xFC83, 0xFC54, 0xFC28, 0xFBFF, 0xFBDB, 0xFBBA, 0xFB9F, 0xFB88, 0xFB77, 0xFB6B, 0xFB64, 0xFB64,
        0xFB6A, 0xFB76, 0xFB89, 0xFBA3, 0xFBC3, 0xFBEA, 0xFC18, 0xFC4D, 0xFC88, 0xFCCA, 0xFD13, 0xFD62, 0xFDB7, 0xFE11, 0xFE72, 0xFED7,
        0xFF41, 0xFFB0, 0x0021, 0x0097, 0x0110, 0x018B, 0x0207, 0x0285, 0x0304, 0x0382, 0x03FF, 0x047B, 0x04F5, 0x056C, 0x05DF, 0x064E,
        0x06B8, 0x071C, 0x077A, 0x07D0, 0x081F, 0x0866, 0x08A4, 0x08D8, 0x0903, 0x0923, 0x0938, 0x0942, 0x0940, 0x0933, 0x0919, 0x08F3,
        0x08C1, 0x0882, 0x0836, 0x07DF, 0x077B, 0x070B, 0x0690, 0x0609, 0x0577, 0x04DB, 0x0434, 0x0385, 0x02CD, 0x020D, 0x0146, 0x0078,
        0xFFA7, 0xFED0, 0xFDF5, 0xFD18, 0xFC3A, 0xFB5C, 0xFA7E, 0xF9A3, 0xF8CA, 0xF7F6, 0xF728, 0xF660, 0xF5A0, 0xF4E9, 0xF43B, 0xF399,
        0xF304, 0xF27B, 0xF200, 0xF194, 0xF139, 0xF0EE, 0xF0B4, 0xF08C, 0xF077, 0xF074, 0xF085, 0xF0AA, 0xF0E3, 0xF130, 0xF190, 0xF205,
        0xF28E, 0xF329, 0xF3D8, 0xF49A, 0xF56D, 0xF652, 0xF746, 0xF84B, 0xF95E, 0xFA7E, 0xFBAB, 0xFCE2, 0xFE23, 0xFF6D, 0x00BC, 0x0211,
        0x036A, 0x04C5, 0x0620, 0x0779, 0x08D0, 0x0A22, 0x0B6D, 0x0CAF, 0x0DE8, 0x0F15, 0x1034, 0x1144, 0x1244, 0x1331, 0x140B, 0x14CF,
        0x157D, 0x1613, 0x1691, 0x16F4, 0x173D, 0x176B, 0x177C, 0x1770, 0x1747, 0x1701, 0x169E, 0x161C, 0x157E, 0x14C2, 0x13EA, 0x12F5,
        0x11E6, 0x10BC, 0x0F79, 0x0E1D, 0x0CAB, 0x0B23, 0x0988, 0x07DB, 0x061D, 0x0451, 0x0279, 0x0096, 0xFEAD, 0xFCBC, 0xFAC9, 0xF8D4,
        0xF6E1, 0xF4F1, 0xF308, 0xF127, 0xEF52, 0xED8B, 0xEBD3, 0xEA2E, 0xE89E, 0xE724, 0xE5C4, 0xE47F, 0xE357, 0xE24E, 0xE166, 0xE0A0,
        0xDFFE, 0xDF81, 0xDF2A, 0xDEFA, 0xDEF2, 0xDF13, 0xDF5C, 0xDFCF, 0xE06A, 0xE12E, 0xE21B, 0xE330, 0xE46B, 0xE5CD, 0xE753, 0xE8FD,
        0xEAC9, 0xECB5, 0xEEBF, 0xF0E5, 0xF325, 0xF57C, 0xF7E8, 0xFA65, 0xFCF2, 0xFF8B, 0x022C, 0x04D4, 0x077F, 0x0A29, 0x0CD0, 0x0F6F,
        0x1204, 0x148C, 0x1702, 0x1964, 0x1BAF, 0x1DDF, 0x1FF1, 0x21E3, 0x23B2, 0x255B, 0x26DB, 0x2831, 0x2959, 0x2A53, 0x2B1C, 0x2BB2,
        0x2C15, 0x2C44, 0x2C3D, 0x2BFF, 0x2B8C, 0x2AE2, 0x2A01, 0x28EA, 0x279F, 0x261F, 0x246C, 0x2287, 0x2073, 0x1E31, 0x1BC4, 0x192D,
        0x1671, 0x1390, 0x1090, 0x0D73, 0x0A3C, 0x06EF, 0x0391, 0x0024, 0xFCAE, 0xF932, 0xF5B4, 0xF238, 0xEEC4, 0xEB5B, 0xE801, 0xE4BB,
        0xE18D, 0xDE7B, 0xDB8A, 0xD8BD, 0xD617, 0xD39E, 0xD154, 0xCF3C, 0xCD5A, 0xCBB1, 0xCA43, 0xC912, 0xC821, 0xC771, 0xC705, 0xC6DC,
        0xC6F9, 0xC75C, 0xC804, 0xC8F3, 0xCA26, 0xCB9F, 0xCD5B, 0xCF5A, 0xD199, 0xD416, 0xD6CF, 0xD9C2, 0xDCEA, 0xE046, 0xE3D1, 0xE787,
        0xEB64, 0xEF65, 0xF384, 0xF7BD, 0xFC0B, 0x0067, 0x04CF, 0x093D, 0x0DAA, 0x1212, 0x166F, 0x1ABB, 0x1EF2, 0x230E, 0x270A, 0x2AE0,
        0x2E8B, 0x3207, 0x354E, 0x385D, 0x3B2F, 0x3DC0, 0x400D, 0x4210, 0x43C9, 0x4534, 0x464D, 0x4714, 0x4787, 0x47A4, 0x476A, 0x46D9,
        0x45F0, 0x44B0, 0x431A, 0x412F, 0x3EF0, 0x3C5F, 0x397F, 0x3652, 0x32DC, 0x2F21, 0x2B23, 0x26E7, 0x2273, 0x1DCA, 0x18F3, 0x13F2,
        0x0ECD, 0x098A, 0x0430, 0xFEC6, 0xF94F, 0xF3D5, 0xEE5C, 0xE8ED, 0xE38E, 0xDE44, 0xD918, 0xD410, 0xCF31, 0xCA83, 0xC60B, 0xC1D0,
        0xBDD6, 0xBA24, 0xB6BF, 0xB3AB, 0xB0ED, 0xAE88, 0xAC82, 0xAADC, 0xA999, 0xA8BD, 0xA848, 0xA83D, 0xA89D, 0xA967, 0xAA9C, 0xAC3A,
        0xAE99, 0xB15A, 0xB479, 0xB7F3, 0xBBC4, 0xBFE6, 0xC455, 0xC90C, 0xCE05, 0xD33A, 0xD8A4, 0xDE3E, 0xE400, 0xE9E4, 0xEFE3, 0xF5F5,
        0xFC13, 0x0235, 0x0855, 0x0E6B, 0x146F, 0x1A5B, 0x2028, 0x25CE, 0x2B46, 0x308B, 0x3595, 0x3A5F, 0x3EE3, 0x431C, 0x4703, 0x4A96,
        0x4DCF, 0x50AB, 0x5325, 0x553C, 0x56ED, 0x5835, 0x5913, 0x5987, 0x598F, 0x592B, 0x585C, 0x5724, 0x5582, 0x537A, 0x510E, 0x4E40,
        0x4B15, 0x478F, 0x43B4, 0x3F87, 0x3B0E, 0x364E, 0x314C, 0x2C10, 0x269F, 0x20FF, 0x1B38, 0x1550, 0x0F4E, 0x093A, 0x031B, 0xFCF9,
        0xF6DA, 0xF0C6, 0xEAC4, 0xE4DC, 0xDF14, 0xD974, 0xD402, 0xCEC5, 0xC9C3, 0xC502, 0xC088, 0xBC5A, 0xB87D, 0xB4F6, 0xB1CA, 0xAEFB,
        0xAC8D, 0xAA84, 0xA8E1, 0xA7A7, 0xA6D7, 0xA672, 0xA678, 0xA6EA, 0xA7C7, 0xA90E, 0xAABD, 0xACD3, 0xAF4C, 0xB227, 0xB55F, 0xB8F0,
        0xBCD7, 0xC10E, 0xC591, 0xCA5A, 0xCF64, 0xD4A7, 0xDA1F, 0xDFC5, 0xE591, 0xEB7D, 0xF181, 0xF797, 0xFDB7, 0x03D8, 0x09F6, 0x1009,
        0x1607, 0x1BEC, 0x21AF, 0x2749, 0x2CB4, 0x31EA, 0x36E4, 0x3B9B, 0x400C, 0x442F, 0x4800, 0x4B7B, 0x4E9C, 0x515E, 0x53BE, 0x55BA,
        0x574F, 0x587B, 0x593D, 0x5993, 0x597E, 0x58FE, 0x5813, 0x56BE, 0x5501, 0x52DE, 0x5057, 0x4D70, 0x4A2C, 0x468F, 0x429E, 0x3E5C,
        0x39CF, 0x34FD, 0x2FEB, 0x2AA0, 0x2522, 0x1F77, 0x19A6, 0x13B7, 0x0DB0, 0x0798, 0x0177, 0xFB56, 0xF539, 0xEF29, 0xE92D, 0xE34D,
        0xDD8F, 0xD7FA, 0xD296, 0xCD68, 0xC877, 0xC3C8, 0xBF62, 0xBB49, 0xB783, 0xB414, 0xB100, 0xAE4B, 0xABF8, 0xAA0A, 0xA883, 0xA765,
        0xA6B2, 0xA669, 0xA68C, 0xA71B, 0xA814, 0xA977, 0xAB42, 0xAD73, 0xB006, 0xB2FA, 0xB64A, 0xB9F3, 0xBDF0, 0xC23C, 0xC6D2, 0xCBAD,
        0xD0C7, 0xD619, 0xDB9E, 0xE14E, 0xE723, 0xED16, 0xF320, 0xF939, 0xFF5B, 0x057C, 0x0B98, 0x11A5, 0x179E, 0x1D7A, 0x2333, 0x28C1,
        0x2E1F, 0x3345, 0x382D, 0x3CD3, 0x412F, 0x453D, 0x48F7, 0x4C5B, 0x4F62, 0x520A, 0x5450, 0x5630, 0x57A9, 0x58B9, 0x595E, 0x5998,
        0x5967, 0x58CA, 0x57C2, 0x5651, 0x5479, 0x523B, 0x4F9A, 0x4C9A, 0x493E, 0x4589, 0x4182, 0x3D2B, 0x388C, 0x33A8, 0x2E86, 0x292D,
        0x23A2, 0x1DEC, 0x1813, 0x121C, 0x0C10, 0x05F5, 0xFFD4, 0xF9B2, 0xF398, 0xED8D, 0xE798, 0xE1C0, 0xDC0D, 0xD684, 0xD12E, 0xCC10,
        0xC730, 0xC294, 0xBE42, 0xBA3F, 0xB690, 0xB338, 0xB03D, 0xADA2, 0xAB6A, 0xA997, 0xA82C, 0xA72B, 0xA694, 0xA668, 0xA6A8, 0xA753,
        0xA869, 0xA9E8, 0xABCE, 0xAE1A, 0xB0C7, 0xB3D4, 0xB73C, 0xBAFC, 0xBF0E, 0xC36F, 0xC818, 0xCD04, 0xD22E, 0xD78E, 0xDD1F, 0xE2DA,
        0xE8B8, 0xEEB2, 0xF4C0, 0xFADD, 0x00FE, 0x071F, 0x0D38, 0x1340, 0x1932, 0x1F05, 0x24B3, 0x2A35, 0x2F85, 0x349B, 0x3972, 0x3E04,
        0x424C, 0x4644, 0x49E8, 0x4D33, 0x5021, 0x52B0, 0x54DA, 0x569F, 0x57FC, 0x58F0, 0x5978, 0x5996, 0x5947, 0x588E, 0x576A, 0x55DD,
        0x53E9, 0x5190, 0x4ED6, 0x4BBD, 0x4848, 0x447E, 0x4060, 0x3BF6, 0x3743, 0x324F, 0x2D1D, 0x27B6, 0x221F, 0x1C5F, 0x167D, 0x1080,
        0x0A6F, 0x0452, 0xFE30, 0xF810, 0xF1F9, 0xEBF3, 0xE605, 0xE036, 0xDA8D, 0xD512, 0xCFCA, 0xCABB, 0xC5ED, 0xC165, 0xBD27, 0xB93A,
        0xB5A2, 0xB263, 0xAF82, 0xAD00, 0xAAE3, 0xA92C, 0xA7DD, 0xA6F8, 0xA67D, 0xA66F, 0xA6CB, 0xA793, 0xA8C5, 0xAA60, 0xAC61, 0xAEC7,
        0xB18F, 0xB4B4, 0xB834, 0xBC0B, 0xC032, 0xC4A7, 0xC962, 0xCE60, 0xD398, 0xD907, 0xDEA3, 0xE468, 0xEA4F, 0xF04F, 0xF662, 0xFC80,
        0x02A2, 0x08C1, 0x0ED6, 0x14DA, 0x1AC4, 0x208E, 0x2631, 0x2BA6, 0x30E7, 0x35ED, 0x3AB2, 0x3F31, 0x4364, 0x4746, 0x4AD2, 0x4E05,
        0x50DA, 0x534E, 0x555E, 0x5707, 0x5848, 0x591F, 0x598B, 0x598B, 0x5920, 0x584A, 0x570A, 0x5561, 0x5352, 0x50DF, 0x4E0B, 0x4AD9,
        0x474D, 0x436C, 0x3F39, 0x3ABB, 0x35F6, 0x30F1, 0x2BB1, 0x263C, 0x2099, 0x1ACF, 0x14E5, 0x0EE2, 0x08CD, 0x02AE, 0xFC8C, 0xF66E,
        0xF05B, 0xEA5A, 0xE474, 0xDEAF, 0xD911, 0xD3A3, 0xCE6A, 0xC96C, 0xC4B0, 0xC03B, 0xBC12, 0xB83C, 0xB4BB, 0xB195, 0xAECC, 0xAC66,
        0xAA64, 0xA8C8, 0xA795, 0xA6CD, 0xA66F, 0xA67D, 0xA6F6, 0xA7DB, 0xA929, 0xAADF, 0xACFC, 0xAF7C, 0xB25D, 0xB59B, 0xB933, 0xBD1F,
        0xC15C, 0xC5E4, 0xCAB2, 0xCFC0, 0xD507, 0xDA82, 0xE02B, 0xE5F9, 0xEBE7, 0xF1ED, 0xF804, 0xFE24, 0x0446, 0x0A63, 0x1074, 0x1671,
        0x1C54, 0x2214, 0x27AB, 0x2D13, 0x3245, 0x373A, 0x3BED, 0x4058, 0x4476, 0x4841, 0x4BB6, 0x4ED0, 0x518B, 0x53E5, 0x55DA, 0x5767,
        0x588C, 0x5946, 0x5995, 0x5979, 0x58F1, 0x57FF, 0x56A3, 0x54DE, 0x52B4, 0x5027, 0x4D39, 0x49EF, 0x464C, 0x4254, 0x3E0D, 0x397B,
        0x34A5, 0x2F8F, 0x2A40, 0x24BE, 0x1F11, 0x193D, 0x134C, 0x0D44, 0x072B, 0x010A, 0xFAE9, 0xF4CC, 0xEEBE, 0xE8C4, 0xE2E5, 0xDD2A,
        0xD799, 0xD238, 0xCD0E, 0xC821, 0xC378, 0xBF17, 0xBB03, 0xB743, 0xB3DA, 0xB0CD, 0xAE1E, 0xABD2, 0xA9EB, 0xA86C, 0xA755, 0xA6A9,
        0xA668, 0xA693, 0xA729, 0xA82A, 0xA994, 0xAB66, 0xAD9D, 0xB038, 0xB332, 0xB689, 0xBA37, 0xBE3A, 0xC28B, 0xC726, 0xCC06, 0xD124,
        0xD67A, 0xDC02, 0xE1B5, 0xE78C, 0xED81, 0xF38C, 0xF9A6, 0xFFC8, 0x05E9, 0x0C04, 0x1210, 0x1807, 0x1DE1, 0x2397, 0x2922, 0x2E7C,
        0x339E, 0x3882, 0x3D23, 0x417A, 0x4582, 0x4937, 0x4C94, 0x4F95, 0x5236, 0x5475, 0x564E, 0x57C0, 0x58C8, 0x5966, 0x5998, 0x595F,
        0x58BB, 0x57AC, 0x5634, 0x5454, 0x520F, 0x4F68, 0x4C61, 0x48FE, 0x4544, 0x4137, 0x3CDB, 0x3837, 0x334F, 0x2E29, 0x28CC, 0x233E,
        0x1D85, 0x17A9, 0x11B1, 0x0BA3, 0x0588, 0xFF67, 0xF945, 0xF32C, 0xED22, 0xE72F, 0xE159, 0xDBA9, 0xD624, 0xD0D1, 0xCBB7, 0xC6DB,
        0xC244, 0xBDF8, 0xB9FA, 0xB651, 0xB300, 0xB00C, 0xAD77, 0xAB46, 0xA97B, 0xA817, 0xA71D, 0xA68D, 0xA669, 0xA6B1, 0xA763, 0xA880,
        0xAA06, 0xABF4, 0xAE46, 0xB0FB, 0xB40E, 0xB77C, 0xBB42, 0xBF5A, 0xC3BF, 0xC86D, 0xCD5E, 0xD28C, 0xD7F0, 0xDD84, 0xE341, 0xE922,
        0xEF1D, 0xF52D, 0xFB4A, 0x016B, 0x078C, 0x0DA4, 0x13AB, 0x199B, 0x1F6C, 0x2517, 0x2A96, 0x2FE1, 0x34F3, 0x39C6, 0x3E53, 0x4295,
        0x4688, 0x4A26, 0x4D6A, 0x5052, 0x52D9, 0x54FD, 0x56BB, 0x5811, 0x58FD, 0x597E, 0x5994, 0x593E, 0x587D, 0x5752, 0x55BD, 0x53C2,
        0x5163, 0x4EA2, 0x4B82, 0x4808, 0x4437, 0x4014, 0x3BA4, 0x36ED, 0x31F4, 0x2CBF, 0x2754, 0x21BA, 0x1BF7, 0x1613, 0x1014, 0x0A02,
        0x03E4, 0xFDC3, 0xF7A3, 0xF18D, 0xEB88, 0xE59C, 0xDFD0, 0xDA2A, 0xD4B2, 0xCF6E, 0xCA64, 0xC59A, 0xC117, 0xBCDF, 0xB8F7, 0xB565,
        0xB22D, 0xAF52, 0xACD8, 0xAAC1, 0xA911, 0xA7C9, 0xA6EC, 0xA679, 0xA672, 0xA6D6, 0xA7A5, 0xA8DE, 0xAA80, 0xAC89, 0xAEF6, 0xB1C4,
        0xB4F0, 0xB876, 0xBC52, 0xC07F, 0xC4F9, 0xC9B9, 0xCEBB, 0xD3F8, 0xD969, 0xDF09, 0xE4D1, 0xEAB9, 0xF0BA, 0xF6CE, 0xFCED, 0x030F,
        0x092E, 0x0F42, 0x1544, 0x1B2C, 0x20F4, 0x2694, 0x2C05, 0x3142, 0x3644, 0x3B05, 0x3F7E, 0x43AC, 0x4788, 0x4B0E, 0x4E3A, 0x5109,
        0x5376, 0x557F, 0x5721, 0x585A, 0x592A, 0x598E, 0x5987, 0x5915, 0x5837, 0x56F0, 0x5540, 0x532A, 0x50B0, 0x4DD5, 0x4A9D, 0x470B,
        0x4324, 0x3EEC, 0x3A68, 0x359F, 0x3095, 0x2B51, 0x25D9, 0x2033, 0x1A67, 0x147B, 0x0E77, 0x0861, 0x0241, 0xFC1F, 0xF601, 0xEFEF,
        0xE9F0, 0xE40C, 0xDE49, 0xD8AF, 0xD344, 0xCE0F, 0xC915, 0xC45E, 0xBFEE, 0xBBCB, 0xB7FA, 0xB480, 0xB160, 0xAE9F, 0xAC3F, 0xAA44,
        0xA8AF, 0xA784, 0xA6C3, 0xA66C, 0xA682, 0xA703, 0xA7EF, 0xA944, 0xAB02, 0xAD25, 0xAFAC, 0xB294, 0xB5D8, 0xB976, 0xBD68, 0xC1AA,
        0xC637, 0xCB0A, 0xD01C, 0xD567, 0xDAE6, 0xE091, 0xE662, 0xEC52, 0xF259, 0xF871, 0xFE91, 0x04B3, 0x0AD0, 0x10E0, 0x16DB, 0x1CBB,
        0x2279, 0x280D, 0x2D71, 0x329F, 0x3790, 0x3C3E, 0x40A4, 0x44BC, 0x4882, 0x4BF0, 0x4F04, 0x51B8, 0x540B, 0x55F9, 0x577F, 0x589C,
        0x594F, 0x5997, 0x5973, 0x58E4, 0x57EA, 0x5686, 0x54BB, 0x528A, 0x4FF6, 0x4D01, 0x49B1, 0x4608, 0x420B, 0x3DBE, 0x3927, 0x344C,
        0x2F32, 0x29DF, 0x245B, 0x1EAA, 0x18D4, 0x12E1, 0x0CD7, 0x06BE, 0x009D, 0xFA7B, 0xF460, 0xEE52, 0xE85A, 0xE27E, 0xDCC6, 0xD737,
        0xD1DA, 0xCCB4, 0xC7CC, 0xC327, 0xBECB, 0xBABE, 0xB704, 0xB3A1, 0xB09A, 0xADF2, 0xABAD, 0xA9CD, 0xA855, 0xA746, 0xA6A1, 0xA668,
        0xA69A, 0xA737, 0xA840, 0xA9B1, 0xAB8A, 0xADC9, 0xB06A, 0xB36B, 0xB6C7, 0xBA7C, 0xBE84, 0xC2DB, 0xC77B, 0xCC5F, 0xD181, 0xD6DB,
        0xDC66, 0xE21C, 0xE7F6, 0xEDEC, 0xF3F9, 0xFA14, 0x0034, 0x0656, 0x0C70, 0x127B, 0x1870, 0x1E48, 0x23FB, 0x2983, 0x2EDA, 0x33F7,
        0x38D7, 0x3D72, 0x41C4, 0x45C7, 0x4975, 0x4CCC, 0x4FC7, 0x5261, 0x5499, 0x566B, 0x57D6, 0x58D7, 0x596D, 0x5998, 0x5957, 0x58AB,
        0x5795, 0x5616, 0x542F, 0x51E3, 0x4F35, 0x4C27, 0x48BF, 0x44FF, 0x40EC, 0x3C8B, 0x37E1, 0x32F5, 0x2DCB, 0x286A, 0x22D9, 0x1D1E,
        0x1740, 0x1146, 0x0B37, 0x051B, 0xFEF9, 0xF8D8, 0xF2C0, 0xECB7, 0xE6C6, 0xE0F3, 0xDB45, 0xD5C3, 0xD074, 0xCB5E, 0xC687, 0xC1F5,
        0xBDAE, 0xB9B6, 0xB613, 0xB2C9, 0xAFDB, 0xAD4D, 0xAB23, 0xA95E, 0xA802, 0xA70F, 0xA687, 0xA66B, 0xA6BA, 0xA774, 0xA898, 0xAA26,
        0xAC1A, 0xAE73, 0xB12E, 0xB448, 0xB7BD, 0xBB88, 0xBFA6, 0xC411, 0xC8C3, 0xCDB8, 0xD2EA, 0xD852, 0xDDE9, 0xE3A9, 0xE98B, 0xEF89,
        0xF599, 0xFBB7, 0x01D9, 0x07F9, 0x0E10, 0x1416, 0x1A03, 0x1FD2, 0x257A, 0x2AF6, 0x303E, 0x354B, 0x3A19, 0x3EA1, 0x42DE, 0x46CB,
        0x4A63, 0x4DA1, 0x5082, 0x5303, 0x5520, 0x56D6, 0x5825, 0x5909, 0x5983, 0x5991, 0x5934, 0x586B, 0x5739, 0x559D, 0x539B, 0x5135,
        0x4E6D, 0x4B47, 0x47C6, 0x43F0, 0x3FC8, 0x3B53, 0x3697, 0x3199, 0x2C60, 0x26F2, 0x2155, 0x1B8F, 0x15A9, 0x0FA9, 0x0996, 0x0377,
        0xFD55, 0xF736, 0xF121, 0xEB1E, 0xE534, 0xDF6A, 0xD9C7, 0xD452, 0xCF12, 0xCA0C, 0xC547, 0xC0C9, 0xBC96, 0xB8B5, 0xB529, 0xB1F7,
        0xAF22, 0xACAF, 0xAAA0, 0xA8F7, 0xA7B7, 0xA6E0, 0xA675, 0xA675, 0xA6E1, 0xA7B8, 0xA8F8, 0xAAA1, 0xACB1, 0xAF25, 0xB1F9, 0xB52C,
        0xB8B8, 0xBC9A, 0xC0CD, 0xC54B, 0xCA10, 0xCF16, 0xD457, 0xD9CC, 0xDF6F, 0xE539, 0xEB23, 0xF126, 0xF73B, 0xFD5B, 0x037C, 0x099B,
        0x0FAE, 0x15AE, 0x1B94, 0x2159, 0x26F6, 0x2C65, 0x319D, 0x369B, 0x3B57, 0x3FCB, 0x43F3, 0x47CA, 0x4B4A, 0x4E70, 0x5137, 0x539D,
        0x559F, 0x573A, 0x586C, 0x5934, 0x5991, 0x5983, 0x5909, 0x5824, 0x56D5, 0x551E, 0x5301, 0x5080, 0x4D9F, 0x4A60, 0x46C8, 0x42DB,
        0x3E9E, 0x3A15, 0x3547, 0x3039, 0x2AF1, 0x2576, 0x1FCD, 0x19FE, 0x1411, 0x0E0B, 0x07F4, 0x01D3, 0xFBB2, 0xF594, 0xEF83, 0xE986,
        0xE3A4, 0xDDE4, 0xD84D, 0xD2E5, 0xCDB4, 0xC8BF, 0xC40D, 0xBFA2, 0xBB85, 0xB7BA, 0xB445, 0xB12C, 0xAE71, 0xAC18, 0xAA24, 0xA897,
        0xA773, 0xA6B9, 0xA66A, 0xA687, 0xA710, 0xA803, 0xA960, 0xAB24, 0xAD4F, 0xAFDD, 0xB2CB, 0xB616, 0xB9BA, 0xBDB2, 0xC1F9, 0xC68B,
        0xCB62, 0xD078, 0xD5C8, 0xDB4A, 0xE0F8, 0xE6CB, 0xECBC, 0xF2C5, 0xF8DE, 0xFEFF, 0x0520, 0x0B3C, 0x114B, 0x1745, 0x1D23, 0x22DE,
        0x286F, 0x2DD0, 0x32F9, 0x37E6, 0x3C8F, 0x40EF, 0x4502, 0x48C2, 0x4C2A, 0x4F37, 0x51E5, 0x5431, 0x5617, 0x5796, 0x58AC, 0x5958,
        0x5998, 0x596D, 0x58D6, 0x57D5, 0x566A, 0x5497, 0x525F, 0x4FC4, 0x4CC9, 0x4972, 0x45C3, 0x41C0, 0x3D6F, 0x38D3, 0x33F3, 0x2ED5,
        0x297F, 0x23F6, 0x1E43, 0x186B, 0x1276, 0x0C6B, 0x0651, 0x002F, 0xFA0E, 0xF3F4, 0xEDE7, 0xE7F1, 0xE217, 0xDC61, 0xD6D6, 0xD17C,
        0xCC5B, 0xC777, 0xC2D7, 0xBE81, 0xBA79, 0xB6C4, 0xB368, 0xB068, 0xADC7, 0xAB88, 0xA9B0, 0xA83F, 0xA737, 0xA69A, 0xA668, 0xA6A1,
        0xA746, 0xA856, 0xA9CF, 0xABAF, 0xADF4, 0xB09C, 0xB3A4, 0xB707, 0xBAC1, 0xBECF, 0xC32B, 0xC7D0, 0xCCB8, 0xD1DF, 0xD73C, 0xDCCA,
        0xE283, 0xE85F, 0xEE57, 0xF465, 0xFA81, 0x00A2, 0x06C3, 0x0CDC, 0x12E6, 0x18D9, 0x1EAF, 0x245F, 0x29E4, 0x2F37, 0x3450, 0x392B,
        0x3DC2, 0x420E, 0x460B, 0x49B4, 0x4D04, 0x4FF8, 0x528C, 0x54BD, 0x5688, 0x57EB, 0x58E4, 0x5973, 0x5997, 0x594F, 0x589B, 0x577E,
        0x55F7, 0x5409, 0x51B6, 0x4F01, 0x4BEE, 0x487F, 0x44B9, 0x40A0, 0x3C3A, 0x378C, 0x329B, 0x2D6D, 0x2809, 0x2274, 0x1CB6, 0x16D6,
        0x10DA, 0x0ACB, 0x04AE, 0xFE8C, 0xF86B, 0xF254, 0xEC4D, 0xE65D, 0xE08C, 0xDAE1, 0xD563, 0xD017, 0xCB06, 0xC633, 0xC1A7, 0xBD65,
        0xB973, 0xB5D6, 0xB291, 0xAFAA, 0xAD23, 0xAB00, 0xA943, 0xA7EE, 0xA702, 0xA682, 0xA66D, 0xA6C3, 0xA785, 0xA8B0, 0xAA45, 0xAC41,
        0xAEA1, 0xB163, 0xB483, 0xB7FE, 0xBBCF, 0xBFF2, 0xC462, 0xC91A, 0xCE13, 0xD349, 0xD8B4, 0xDE4E, 0xE411, 0xE9F5, 0xEFF4, 0xF606,
        0xFC24, 0x0246, 0x0866, 0x0E7C, 0x1480, 0x1A6C, 0x2038, 0x25DE, 0x2B56, 0x309A, 0x35A3, 0x3A6C, 0x3EEF, 0x4327, 0x470E, 0x4A9F,
        0x4DD7, 0x50B2, 0x532C, 0x5542, 0x56F1, 0x5838, 0x5915, 0x5987, 0x598E, 0x5929, 0x5859, 0x5720, 0x557D, 0x5374, 0x5107, 0x4E38,
        0x4B0B, 0x4785, 0x43A8, 0x3F7B, 0x3B01, 0x3640, 0x313E, 0x2C01, 0x268F, 0x20EF, 0x1B27, 0x153F, 0x0F3D, 0x0929, 0x030A, 0xFCE8,
        0xF6C9, 0xF0B5, 0xEAB4, 0xE4CC, 0xDF04, 0xD964, 0xD3F3, 0xCEB6, 0xC9B5, 0xC4F5, 0xC07C, 0xBC4F, 0xB873, 0xB4ED, 0xB1C1, 0xAEF4,
        0xAC87, 0xAA7F, 0xA8DD, 0xA7A4, 0xA6D5, 0xA671, 0xA679, 0xA6EC, 0xA7CA, 0xA912, 0xAAC3, 0xACD9, 0xAF54, 0xB22F, 0xB568, 0xB8FB,
        0xBCE2, 0xC11A, 0xC59E, 0xCA68, 0xCF72, 0xD4B7, 0xDA2F, 0xDFD5, 0xE5A1, 0xEB8D, 0xF192, 0xF7A8, 0xFDC8, 0x03EA, 0x0A08, 0x101A,
        0x1618, 0x1BFC, 0x21BF, 0x2759, 0x2CC3, 0x31F8, 0x36F1, 0x3BA8, 0x4018, 0x443A, 0x480B, 0x4B85, 0x4EA4, 0x5165, 0x53C4, 0x55BF,
        0x5753, 0x587E, 0x593E, 0x5994, 0x597E, 0x58FC, 0x5810, 0x56BA, 0x54FC, 0x52D7, 0x5050, 0x4D68, 0x4A23, 0x4685, 0x4292, 0x3E4F,
        0x39C2, 0x34EF, 0x2FDD, 0x2A91, 0x2512, 0x1F67, 0x1996, 0x13A6, 0x0D9F, 0x0787, 0x0166, 0xFB45, 0xF528, 0xEF18, 0xE91C, 0xE33C,
        0xDD7F, 0xD7EB, 0xD287, 0xCD5A, 0xC869, 0xC3BC, 0xBF56, 0xBB3E, 0xB779, 0xB40B, 0xB0F8, 0xAE44, 0xABF2, 0xAA05, 0xA87F, 0xA762,
        0xA6B0, 0xA669, 0xA68D, 0xA71D, 0xA818, 0xA97C, 0xAB48, 0xAD79, 0xB00E, 0xB303, 0xB654, 0xB9FE, 0xBDFB, 0xC248, 0xC6DF, 0xCBBB,
        0xD0D5, 0xD628, 0xDBAD, 0xE15E, 0xE734, 0xED27, 0xF331, 0xF94B, 0xFF6C, 0x058D, 0x0BA9, 0x11B6, 0x17AE, 0x1D8A, 0x2342, 0x28D0,
        0x2E2D, 0x3353, 0x383B, 0x3CDF, 0x413B, 0x4548, 0x4901, 0x4C64, 0x4F6A, 0x5211, 0x5456, 0x5635, 0x57AD, 0x58BC, 0x5960, 0x5998,
        0x5966, 0x58C7, 0x57BF, 0x564D, 0x5473, 0x5234, 0x4F92, 0x4C91, 0x4934, 0x457E, 0x4176, 0x3D1F, 0x387E, 0x339A, 0x2E78, 0x291E,
        0x2392, 0x1DDC, 0x1802, 0x120B, 0x0BFF, 0x05E4, 0xFFC3, 0xF9A1, 0xF387, 0xED7C, 0xE787, 0xE1B0, 0xDBFD, 0xD675, 0xD11F, 0xCC01,
        0xC722, 0xC287, 0xBE36, 0xBA34, 0xB686, 0xB32F, 0xB036, 0xAD9B, 0xAB64, 0xA993, 0xA829, 0xA728, 0xA693, 0xA668, 0xA6A9, 0xA756,
        0xA86D, 0xA9ED, 0xABD4, 0xAE21, 0xB0CF, 0xB3DD, 0xB746, 0xBB07, 0xBF1A, 0xC37B, 0xC825, 0xCD12, 0xD23C, 0xD79D, 0xDD2F, 0xE2EA,
        0xE8C9, 0xEEC3, 0xF4D2, 0xFAEE, 0x010F, 0x0730, 0x0D49, 0x1351, 0x1942, 0x1F15, 0x24C3, 0x2A45, 0x2F93, 0x34A9, 0x397F, 0x3E11,
        0x4258, 0x464F, 0x49F2, 0x4D3C, 0x5029, 0x52B6, 0x54E0, 0x56A4, 0x5800, 0x58F2, 0x5979, 0x5995, 0x5946, 0x588B, 0x5766, 0x55D8,
        0x53E3, 0x5189, 0x4ECE, 0x4BB3, 0x483E, 0x4472, 0x4054, 0x3BE9, 0x3736, 0x3240, 0x2D0F, 0x27A7, 0x220F, 0x1C4F, 0x166C, 0x106F,
        0x0A5E, 0x0440, 0xFE1F, 0xF7FE, 0xF1E8, 0xEBE2, 0xE5F4, 0xE026, 0xDA7E, 0xD503, 0xCFBB, 0xCAAE, 0xC5E0, 0xC158, 0xBD1C, 0xB930,
        0xB598, 0xB25B, 0xAF7A, 0xACFA, 0xAADE, 0xA928, 0xA7DA, 0xA6F6, 0xA67D, 0xA66F, 0xA6CD, 0xA796, 0xA8C9, 0xAA65, 0xAC68, 0xAECF,
        0xB197, 0xB4BE, 0xB83F, 0xBC16, 0xC03F, 0xC4B4, 0xC970, 0xCE6E, 0xD3A7, 0xD916, 0xDEB4, 0xE479, 0xEA5F, 0xF060, 0xF673, 0xFC91,
        0x02B3, 0x08D3, 0x0EE8, 0x14EB, 0x1AD4, 0x209E, 0x2641, 0x2BB5, 0x30F5, 0x35FB, 0x3ABF, 0x3F3D, 0x436F, 0x4750, 0x4ADC, 0x4E0D,
        0x50E1, 0x5354, 0x5563, 0x570B, 0x584B, 0x5921, 0x598B, 0x598B, 0x591E, 0x5847, 0x5706, 0x555C, 0x534C, 0x50D8, 0x4E02, 0x4ACF,
        0x4743, 0x4360, 0x3F2D, 0x3AAE, 0x35E9, 0x30E2, 0x2BA2, 0x262C, 0x2089, 0x1ABF, 0x14D5, 0x0ED1, 0x08BC, 0x029D, 0xFC7B, 0xF65C,
        0xF04A, 0xEA49, 0xE463, 0xDE9F, 0xD902, 0xD394, 0xCE5B, 0xC95E, 0xC4A3, 0xC02F, 0xBC07, 0xB831, 0xB4B2, 0xB18C, 0xAEC5, 0xAC60,
        0xAA5E, 0xA8C4, 0xA792, 0xA6CB, 0xA66F, 0xA67E, 0xA6F8, 0xA7DE, 0xA92D, 0xAAE5, 0xAD02, 0xAF84, 0xB266, 0xB5A5, 0xB93D, 0xBD2B,
        0xC168, 0xC5F1, 0xCAC0, 0xCFCE, 0xD516, 0xDA92, 0xE03B, 0xE60A, 0xEBF8, 0xF1FE, 0xF815, 0xFE35, 0x0457, 0x0A74, 0x1085, 0x1682,
        0x1C64, 0x2224, 0x27BB, 0x2D22, 0x3253, 0x3748, 0x3BFA, 0x4064, 0x4481, 0x484C, 0x4BBF, 0x4ED8, 0x5193, 0x53EB, 0x55DE, 0x576B,
        0x588E, 0x5948, 0x5996, 0x5978, 0x58EF, 0x57FB, 0x569E, 0x54D9, 0x52AE, 0x501F, 0x4D30, 0x49E5, 0x4641, 0x4249, 0x3E01, 0x396E,
        0x3497, 0x2F80, 0x2A31, 0x24AF, 0x1F00, 0x192D, 0x133B, 0x0D32, 0x071A, 0x00F9, 0xFAD7, 0xF4BB, 0xEEAD, 0xE8B3, 0xE2D5, 0xDD1A,
        0xD789, 0xD229, 0xCD00, 0xC814, 0xC36B, 0xBF0B, 0xBAF8, 0xB739, 0xB3D1, 0xB0C5, 0xAE17, 0xABCC, 0xA9E7, 0xA868, 0xA753, 0xA6A8,
        0xA668, 0xA694, 0xA72B, 0xA82D, 0xA999, 0xAB6C, 0xADA4, 0xB040, 0xB33B, 0xB693, 0xBA42, 0xBE45, 0xC298, 0xC734, 0xCC14, 0xD132,
        0xD689, 0xDC11, 0xE1C5, 0xE79D, 0xED92, 0xF39D, 0xF9B8, 0xFFD9, 0x05FA, 0x0C15, 0x1221, 0x1818, 0x1DF1, 0x23A7, 0x2932, 0x2E8B,
        0x33AC, 0x3890, 0x3D2F, 0x4185, 0x458D, 0x4941, 0x4C9C, 0x4F9C, 0x523D, 0x547A, 0x5653, 0x57C3, 0x58CA, 0x5967, 0x5998, 0x595E,
        0x58B8, 0x57A8, 0x562F, 0x544E, 0x5208, 0x4F60, 0x4C58, 0x48F4, 0x4539, 0x412B, 0x3CCF, 0x3829, 0x3340, 0x2E1A, 0x28BC, 0x232E,
        0x1D75, 0x1799, 0x11A0, 0x0B92, 0x0577, 0xFF56, 0xF934, 0xF31B, 0xED11, 0xE71E, 0xE149, 0xDB99, 0xD614, 0xD0C2, 0xCBA9, 0xC6CE,
        0xC238, 0xBDEC, 0xB9F0, 0xB647, 0xB2F7, 0xB004, 0xAD71, 0xAB40, 0xA976, 0xA813, 0xA71A, 0xA68C, 0xA669, 0xA6B2, 0xA766, 0xA884,
        0xAA0B, 0xABFA, 0xAE4D, 0xB103, 0xB417, 0xB786, 0xBB4D, 0xBF66, 0xC3CC, 0xC87B, 0xCD6C, 0xD29B, 0xD7FF, 0xDD94, 0xE352, 0xE932,
        0xEF2E, 0xF53E, 0xFB5B, 0x017C, 0x079D, 0x0DB5, 0x13BC, 0x19AB, 0x1F7C, 0x2527, 0x2AA5, 0x2FF0, 0x3501, 0x39D3, 0x3E60, 0x42A1,
        0x4693, 0x4A2F, 0x4D73, 0x505A, 0x52E0, 0x5503, 0x56BF, 0x5814, 0x58FF, 0x597F, 0x5993, 0x593C, 0x587A, 0x574E, 0x55B8, 0x53BC,
        0x515C, 0x4E99, 0x4B79, 0x47FD, 0x442C, 0x4008, 0x3B98, 0x36E0, 0x31E6, 0x2CB0, 0x2744, 0x21AA, 0x1BE7, 0x1602, 0x1003, 0x09F1,
        0x03D3, 0xFDB2, 0xF792, 0xF17C, 0xEB77, 0xE58C, 0xDFC0, 0xDA1B, 0xD4A3, 0xCF5F, 0xCA56, 0xC58D, 0xC10A, 0xBCD3, 0xB8ED, 0xB55C,
        0xB224, 0xAF4A, 0xACD1, 0xAABC, 0xA90D, 0xA7C6, 0xA6EA, 0xA678, 0xA672, 0xA6D8, 0xA7A8, 0xA8E2, 0xAA86, 0xAC8F, 0xAEFD, 0xB1CC,
        0xB4F9, 0xB880, 0xBC5D, 0xC08C, 0xC506, 0xC9C7, 0xCEC9, 0xD407, 0xD979, 0xDF19, 0xE4E1, 0xEAC9, 0xF0CB, 0xF6E0, 0xFCFF, 0x0320,
        0x093F, 0x0F53, 0x1555, 0x1B3D, 0x2104, 0x26A3, 0x2C15, 0x3151, 0x3652, 0x3B12, 0x3F8A, 0x43B7, 0x4792, 0x4B18, 0x4E43, 0x5110,
        0x537C, 0x5584, 0x5725, 0x585D, 0x592C, 0x598F, 0x5987, 0x5913, 0x5834, 0x56EC, 0x553B, 0x5323, 0x50A8, 0x4DCC, 0x4A93, 0x4700,
        0x4318, 0x3EDF, 0x3A5B, 0x3591, 0x3087, 0x2B42, 0x25C9, 0x2023, 0x1A56, 0x146A, 0x0E65, 0x084F, 0x022F, 0xFC0E, 0xF5F0, 0xEFDE,
        0xE9DF, 0xE3FC, 0xDE39, 0xD8A0, 0xD335, 0xCE00, 0xC908, 0xC451, 0xBFE2, 0xBBC0, 0xB7F0, 0xB477, 0xB158, 0xAE97, 0xAC39, 0xAA3F,
        0xA8AB, 0xA781, 0xA6C1, 0xA66C, 0xA683, 0xA705, 0xA7F2, 0xA948, 0xAB07, 0xAD2C, 0xAFB4, 0xB29D, 0xB5E2, 0xB981, 0xBD74, 0xC1B7,
        0xC645, 0xCB18, 0xD02A, 0xD577, 0xDAF6, 0xE0A1, 0xE673, 0xEC63, 0xF26A, 0xF882, 0xFEA3, 0x04C4, 0x0AE1, 0x10F1, 0x16EC, 0x1CCC,
        0x2289, 0x281D, 0x2D80, 0x32AD, 0x379D, 0x3C4B, 0x40B0, 0x44C7, 0x488C, 0x4BFA, 0x4F0C, 0x51C0, 0x5411, 0x55FD, 0x5783, 0x589F,
        0x5951, 0x5997, 0x5972, 0x58E2, 0x57E7, 0x5682, 0x54B5, 0x5283, 0x4FEE, 0x4CF9, 0x49A7, 0x45FD, 0x41FF, 0x3DB1, 0x391A, 0x343E,
        0x2F23, 0x29D0, 0x244B, 0x1E9A, 0x18C4, 0x12D0, 0x0CC6, 0x06AD, 0x008B, 0xFA6A, 0xF44F, 0xEE41, 0xE849, 0xE26E, 0xDCB6, 0xD728,
        0xD1CB, 0xCCA6, 0xC7BE, 0xC31A, 0xBEC0, 0xBAB3, 0xB6FA, 0xB398, 0xB092, 0xADEB, 0xABA7, 0xA9C9, 0xA851, 0xA743, 0xA6A0, 0xA668,
        0xA69B, 0xA73A, 0xA843, 0xA9B6, 0xAB90, 0xADD0, 0xB072, 0xB374, 0xB6D1, 0xBA87, 0xBE90, 0xC2E7, 0xC788, 0xCC6D, 0xD190, 0xD6EA,
        0xDC76, 0xE22C, 0xE806, 0xEDFD, 0xF40A, 0xFA25, 0x0046, 0x0667, 0x0C81, 0x128C, 0x1881, 0x1E58, 0x240B, 0x2993, 0x2EE8, 0x3406,
        0x38E4, 0x3D7F, 0x41D0, 0x45D1, 0x497F, 0x4CD5, 0x4FCE, 0x5268, 0x549F, 0x5670, 0x57D9, 0x58D9, 0x596E, 0x5998, 0x5956, 0x58A9,
        0x5791, 0x5611, 0x5429, 0x51DC, 0x4F2D, 0x4C1E, 0x48B5, 0x44F4, 0x40E0, 0x3C7E, 0x37D4, 0x32E7, 0x2DBC, 0x285B, 0x22C9, 0x1D0E,
        0x172F, 0x1135, 0x0B26, 0x050A, 0xFEE8, 0xF8C7, 0xF2AF, 0xECA6, 0xE6B5, 0xE0E2, 0xDB35, 0xD5B4, 0xD065, 0xCB50, 0xC67A, 0xC1E9,
        0xBDA2, 0xB9AC, 0xB609, 0xB2C0, 0xAFD3, 0xAD46, 0xAB1D, 0xA95A, 0xA7FF, 0xA70D, 0xA686, 0xA66B, 0xA6BB, 0xA776, 0xA89C, 0xAA2A,
        0xAC20, 0xAE7A, 0xB137, 0xB451, 0xB7C7, 0xBB93, 0xBFB2, 0xC41D, 0xC8D1, 0xCDC7, 0xD2F9, 0xD861, 0xDDF9, 0xE3B9, 0xE99C, 0xEF9A,
        0xF5AB, 0xFBC8, 0x01EA, 0x080A, 0x0E21, 0x1426, 0x1A14, 0x1FE2, 0x258A, 0x2B05, 0x304C, 0x3559, 0x3A27, 0x3EAE, 0x42EA, 0x46D6,
        0x4A6C, 0x4DAA, 0x508A, 0x5309, 0x5525, 0x56DB, 0x5828, 0x590B, 0x5984, 0x5991, 0x5932, 0x5869, 0x5735, 0x5598, 0x5395, 0x512E,
        0x4E65, 0x4B3E, 0x47BC, 0x43E4, 0x3FBB, 0x3B46, 0x3689, 0x318B, 0x2C51, 0x26E2, 0x2144, 0x1B7F, 0x1598, 0x0F98, 0x0985, 0x0366,
        0xFD44, 0xF725, 0xF110, 0xEB0D, 0xE523, 0xDF5A, 0xD9B8, 0xD443, 0xCF03, 0xC9FE, 0xC53A, 0xC0BD, 0xBC8B, 0xB8AA, 0xB51F, 0xB1EE,
        0xAF1B, 0xACA9, 0xAA9B, 0xA8F3, 0xA7B4, 0xA6DF, 0xA674, 0xA676, 0xA6E3, 0xA7BA, 0xA8FC, 0xAAA7, 0xACB7, 0xAF2C, 0xB202, 0xB535,
        0xB8C3, 0xBCA5, 0xC0D9, 0xC558, 0xCA1E, 0xCF25, 0xD466, 0xD9DC, 0xDF7F, 0xE549, 0xEB34, 0xF137, 0xF74C, 0xFD6C, 0x038E, 0x09AC,
        0x0FBF, 0x15BF, 0x1BA5, 0x2169, 0x2706, 0x2C74, 0x31AC, 0x36A9, 0x3B64, 0x3FD7, 0x43FE, 0x47D4, 0x4B53, 0x4E78, 0x513E, 0x53A3,
        0x55A4, 0x573E, 0x586F, 0x5936, 0x5992, 0x5982, 0x5907, 0x5821, 0x56D1, 0x5519, 0x52FA, 0x5078, 0x4D96, 0x4A56, 0x46BD, 0x42CF,
        0x3E91, 0x3A08, 0x3539, 0x302B, 0x2AE2, 0x2566, 0x1FBD, 0x19EE, 0x1400, 0x0DF9, 0x07E2, 0x01C2, 0xFBA0, 0xF583, 0xEF72, 0xE976,
        0xE394, 0xDDD4, 0xD83D, 0xD2D7, 0xCDA6, 0xC8B2, 0xC400, 0xBF96, 0xBB7A, 0xB7AF, 0xB43C, 0xB124, 0xAE6A, 0xAC12, 0xAA1F, 0xA893,
        0xA770, 0xA6B8, 0xA66A, 0xA688, 0xA712, 0xA806, 0xA964, 0xAB2A, 0xAD56, 0xAFE5, 0xB2D4, 0xB620, 0xB9C4, 0xBDBD, 0xC206, 0xC698,
        0xCB70, 0xD087, 0xD5D7, 0xDB59, 0xE108, 0xE6DB, 0xECCD, 0xF2D6, 0xF8EF, 0xFF10, 0x0531, 0x0B4D, 0x115C, 0x1756, 0x1D33, 0x22EE,
        0x287E, 0x2DDE, 0x3307, 0x37F3, 0x3C9C, 0x40FB, 0x450D, 0x48CC, 0x4C33, 0x4F3F, 0x51EC, 0x5437, 0x561C, 0x579A, 0x58AF, 0x5959,
        0x5998, 0x596B, 0x58D4, 0x57D1, 0x5665, 0x5492, 0x5258, 0x4FBC, 0x4CC0, 0x4969, 0x45B8, 0x41B5, 0x3D62, 0x38C6, 0x33E5, 0x2EC6,
        0x296F, 0x23E7, 0x1E33, 0x185B, 0x1265, 0x0C5A, 0x0640, 0x001E, 0xF9FD, 0xF3E2, 0xEDD6, 0xE7E0, 0xE207, 0xDC51, 0xD6C7, 0xD16E,
        0xCC4D, 0xC769, 0xC2CA, 0xBE75, 0xBA6E, 0xB6BA, 0xB35F, 0xB060, 0xADC0, 0xAB83, 0xA9AB, 0xA83B, 0xA734, 0xA698, 0xA668, 0xA6A3,
        0xA749, 0xA859, 0xA9D3, 0xABB5, 0xADFB, 0xB0A4, 0xB3AD, 0xB711, 0xBACC, 0xBEDB, 0xC338, 0xC7DD, 0xCCC7, 0xD1ED, 0xD74B, 0xDCDA,
        0xE293, 0xE870, 0xEE68, 0xF476, 0xFA92, 0x00B3, 0x06D4, 0x0CEE, 0x12F7, 0x18EA, 0x1EBF, 0x246F, 0x29F3, 0x2F45, 0x345E, 0x3939,
        0x3DCE, 0x421A, 0x4616, 0x49BE, 0x4D0D, 0x5000, 0x5293, 0x54C2, 0x568C, 0x57EE, 0x58E7, 0x5974, 0x5997, 0x594D, 0x5899, 0x577A,
        0x55F2, 0x5403, 0x51AF, 0x4EF9, 0x4BE4, 0x4875, 0x44AE, 0x4094, 0x3C2D, 0x377E, 0x328C, 0x2D5E, 0x27F9, 0x2264, 0x1CA6, 0x16C5,
        0x10C9, 0x0AB9, 0x049C, 0xFE7B, 0xF85A, 0xF243, 0xEC3C, 0xE64C, 0xE07C, 0xDAD1, 0xD553, 0xD009, 0xCAF8, 0xC626, 0xC19A, 0xBD59,
        0xB968, 0xB5CC, 0xB289, 0xAFA2, 0xAD1D, 0xAAFB, 0xA93E, 0xA7EA, 0xA700, 0xA681, 0xA66D, 0xA6C5, 0xA787, 0xA8B4, 0xAA4A, 0xAC47,
        0xAEA8, 0xB16B, 0xB48C, 0xB808, 0xBBDA, 0xBFFE, 0xC46F, 0xC927, 0xCE21, 0xD358, 0xD8C3, 0xDE5E, 0xE421, 0xEA06, 0xF005, 0xF617,
        0xFC35, 0x0257, 0x0877, 0x0E8D, 0x1491, 0x1A7D, 0x2048, 0x25ED, 0x2B65, 0x30A8, 0x35B1, 0x3A7A, 0x3EFC, 0x4332, 0x4718, 0x4AA9,
        0x4DE0, 0x50BA, 0x5332, 0x5547, 0x56F5, 0x583B, 0x5917, 0x5988, 0x598E, 0x5928, 0x5857, 0x571B, 0x5578, 0x536E, 0x50FF, 0x4E2F,
        0x4B02, 0x477A, 0x439D, 0x3F6E, 0x3AF4, 0x3632, 0x312F, 0x2BF2, 0x267F, 0x20DF, 0x1B17, 0x152E, 0x0F2C, 0x0918, 0x02F9, 0xFCD7,
        0xF6B8, 0xF0A4, 0xEAA3, 0xE4BB, 0xDEF4, 0xD955, 0xD3E4, 0xCEA8, 0xC9A7, 0xC4E8, 0xC06F, 0xBC43, 0xB869, 0xB4E4, 0xB1B9, 0xAEEC,
        0xAC81, 0xAA7A, 0xA8D9, 0xA7A1, 0xA6D4, 0xA671, 0xA67A, 0xA6EE, 0xA7CD, 0xA917, 0xAAC8, 0xACE0, 0xAF5C, 0xB238, 0xB572, 0xB905,
        0xBCEE, 0xC127, 0xC5AB, 0xCA76, 0xCF81, 0xD4C6, 0xDA3F, 0xDFE5, 0xE5B2, 0xEB9E, 0xF1A3, 0xF7B9, 0xFDD9, 0x03FB, 0x0A19, 0x102B,
        0x1629, 0x1C0D, 0x21CF, 0x2768, 0x2CD2, 0x3207, 0x36FF, 0x3BB5, 0x4024, 0x4445, 0x4815, 0x4B8E, 0x4EAC, 0x516C, 0x53CA, 0x55C4,
        0x5757, 0x5880, 0x5940, 0x5994, 0x597D, 0x58FA, 0x580D, 0x56B5, 0x54F6, 0x52D1, 0x5048, 0x4D5F, 0x4A19, 0x467A, 0x4286, 0x3E43,
        0x39B5, 0x34E1, 0x2FCE, 0x2A82, 0x2502, 0x1F57, 0x1985, 0x1395, 0x0D8D, 0x0776, 0x0155, 0xFB33, 0xF517, 0xEF07, 0xE90C, 0xE32C,
        0xDD6F, 0xD7DC, 0xD278, 0xCD4C, 0xC85C, 0xC3AF, 0xBF4A, 0xBB33, 0xB76F, 0xB402, 0xB0F0, 0xAE3D, 0xABEC, 0xAA00, 0xA87C, 0xA760,
        0xA6AF, 0xA669, 0xA68E, 0xA71F, 0xA81B, 0xA980, 0xAB4D, 0xAD80, 0xB016, 0xB30C, 0xB65E, 0xBA08, 0xBE07, 0xC255, 0xC6ED, 0xCBC9,
        0xD0E4, 0xD637, 0xDBBD, 0xE16E, 0xE744, 0xED38, 0xF342, 0xF95C, 0xFF7D, 0x059E, 0x0BBA, 0x11C7, 0x17BF, 0x1D9A, 0x2352, 0x28E0,
        0x2E3C, 0x3361, 0x3848, 0x3CEC, 0x4146, 0x4553, 0x490B, 0x4C6D, 0x4F72, 0x5218, 0x545C, 0x563A, 0x57B1, 0x58BE, 0x5961, 0x5998,
        0x5964, 0x58C5, 0x57BB, 0x5648, 0x546D, 0x522D, 0x4F8A, 0x4C88, 0x492A, 0x4574, 0x416A, 0x3D12, 0x3871, 0x338C, 0x2E69, 0x290E,
        0x2382, 0x1DCC, 0x17F1, 0x11FA, 0x0BEE, 0x05D3, 0xFFB2, 0xF990, 0xF376, 0xED6B, 0xE777, 0xE1A0, 0xDBED, 0xD666, 0xD110, 0xCBF3,
        0xC715, 0xC27B, 0xBE2A, 0xBA29, 0xB67C, 0xB327, 0xB02E, 0xAD95, 0xAB5F, 0xA98E, 0xA825, 0xA726, 0xA692, 0xA668, 0xA6AB, 0xA758,
        0xA870, 0xA9F2, 0xABDA, 0xAE28, 0xB0D7, 0xB3E6, 0xB750, 0xBB12, 0xBF26, 0xC388, 0xC833, 0xCD21, 0xD24B, 0xD7AD, 0xDD3F, 0xE2FB,
        0xE8D9, 0xEED4, 0xF4E3, 0xFAFF, 0x0120, 0x0741, 0x0D5A, 0x1362, 0x1953, 0x1F26, 0x24D3, 0x2A54, 0x2FA2, 0x34B7, 0x398D, 0x3E1D,
        0x4263, 0x465A, 0x49FC, 0x4D45, 0x5031, 0x52BD, 0x54E5, 0x56A8, 0x5803, 0x58F4, 0x597A, 0x5995, 0x5944, 0x5888, 0x5762, 0x55D3,
        0x53DD, 0x5182, 0x4EC5, 0x4BAA, 0x4834, 0x4467, 0x4048, 0x3BDC, 0x3728, 0x3232, 0x2D00, 0x2797, 0x21FF, 0x1C3E, 0x165C, 0x105E,
        0x0A4D, 0x042F, 0xFE0E, 0xF7ED, 0xF1D7, 0xEBD1, 0xE5E4, 0xE016, 0xDA6E, 0xD4F3, 0xCFAD, 0xCAA0, 0xC5D3, 0xC14C, 0xBD10, 0xB925,
        0xB58F, 0xB252, 0xAF72, 0xACF3, 0xAAD8, 0xA923, 0xA7D7, 0xA6F4, 0xA67C, 0xA670, 0xA6CF, 0xA799, 0xA8CD, 0xAA6A, 0xAC6E, 0xAED6,
        0xB1A0, 0xB4C7, 0xB849, 0xBC21, 0xC04B, 0xC4C1, 0xC97E, 0xCE7C, 0xD3B7, 0xD926, 0xDEC4, 0xE489, 0xEA70, 0xF071, 0xF684, 0xFCA3,
        0x02C4, 0x08E4, 0x0EF9, 0x14FB, 0x1AE5, 0x20AE, 0x2650, 0x2BC4, 0x3104, 0x3608, 0x3ACC, 0x3F49, 0x437B, 0x475B, 0x4AE5, 0x4E16,
        0x50E9, 0x535A, 0x5568, 0x570F, 0x584E, 0x5922, 0x598C, 0x598A, 0x591D, 0x5844, 0x5702, 0x5557, 0x5345, 0x50D0, 0x4DFA, 0x4AC6,
        0x4738, 0x4355, 0x3F21, 0x3AA1, 0x35DB, 0x30D4, 0x2B92, 0x261D, 0x2079, 0x1AAE, 0x14C4, 0x0EC0, 0x08AB, 0x028B, 0xFC6A, 0xF64B,
        0xF038, 0xEA39, 0xE453, 0xDE8F, 0xD8F2, 0xD385, 0xCE4D, 0xC951, 0xC496, 0xC023, 0xBBFC, 0xB827, 0xB4A8, 0xB184, 0xAEBE, 0xAC59,
        0xAA59, 0xA8C0, 0xA790, 0xA6C9, 0xA66E, 0xA67E, 0xA6FA, 0xA7E1, 0xA931, 0xAAEA, 0xAD09, 0xAF8B, 0xB26E, 0xB5AF, 0xB948, 0xBD36,
        0xC175, 0xC5FE, 0xCACE, 0xCFDD, 0xD526, 0xDAA2, 0xE04B, 0xE61A, 0xEC09, 0xF20F, 0xF826, 0xFE47, 0x0468, 0x0A85, 0x1096, 0x1693,
        0x1C74, 0x2234, 0x27CA, 0x2D31, 0x3261, 0x3755, 0x3C07, 0x4070, 0x448C, 0x4856, 0x4BC9, 0x4EE1, 0x519A, 0x53F1, 0x55E3, 0x576F,
        0x5891, 0x5949, 0x5996, 0x5977, 0x58ED, 0x57F8, 0x569A, 0x54D3, 0x52A7, 0x5017, 0x4D28, 0x49DB, 0x4636, 0x423D, 0x3DF4, 0x3961,
        0x3489, 0x2F72, 0x2A21, 0x249F, 0x1EF0, 0x191C, 0x132A, 0x0D21, 0x0709, 0x00E7, 0xFAC6, 0xF4AA, 0xEE9C, 0xE8A2, 0xE2C5, 0xDD0A,
        0xD77A, 0xD21A, 0xCCF2, 0xC806, 0xC35E, 0xBEFF, 0xBAED, 0xB72F, 0xB3C8, 0xB0BD, 0xAE10, 0xABC7, 0xA9E2, 0xA864, 0xA750, 0xA6A6,
        0xA668, 0xA695, 0xA72E, 0xA831, 0xA99D, 0xAB71, 0xADAB, 0xB048, 0xB344, 0xB69C, 0xBA4D, 0xBE51, 0xC2A4, 0xC741, 0xCC22, 0xD141,
        0xD698, 0xDC21, 0xE1D5, 0xE7AE, 0xEDA3, 0xF3AF, 0xF9C9, 0xFFEB, 0x060C, 0x0C26, 0x1232, 0x1828, 0x1E02, 0x23B7, 0x2941, 0x2E9A,
        0x33BB, 0x389D, 0x3D3C, 0x4191, 0x4598, 0x494B, 0x4CA5, 0x4FA4, 0x5244, 0x5480, 0x5657, 0x57C7, 0x58CD, 0x5968, 0x5998, 0x595D,
        0x58B6, 0x57A5, 0x562A, 0x5448, 0x5201, 0x4F58, 0x4C4F, 0x48EA, 0x452E, 0x411F, 0x3CC2, 0x381C, 0x3332, 0x2E0B, 0x28AD, 0x231E,
        0x1D65, 0x1788, 0x118F, 0x0B81, 0x0565, 0xFF44, 0xF923, 0xF30A, 0xED00, 0xE70E, 0xE139, 0xDB89, 0xD605, 0xD0B3, 0xCB9B, 0xC6C1,
        0xC22B, 0xBDE0, 0xB9E5, 0xB63D, 0xB2EF, 0xAFFC, 0xAD6A, 0xAB3B, 0xA972, 0xA810, 0xA718, 0xA68B, 0xA669, 0xA6B3, 0xA768, 0xA888,
        0xAA10, 0xAC00, 0xAE54, 0xB10B, 0xB420, 0xB791, 0xBB58, 0xBF72, 0xC3D9, 0xC889, 0xCD7B, 0xD2A9, 0xD80F, 0xDDA4, 0xE362, 0xE943,
        0xEF3F, 0xF54F, 0xFB6C, 0x018E, 0x07AE, 0x0DC6, 0x13CD, 0x19BC, 0x1F8C, 0x2536, 0x2AB4, 0x2FFF, 0x350F, 0x39E0, 0x3E6C, 0x42AD,
        0x469D, 0x4A39, 0x4D7C, 0x5061, 0x52E7, 0x5508, 0x56C4, 0x5817, 0x5901, 0x5980, 0x5993, 0x593B, 0x5877, 0x574A, 0x55B3, 0x53B6,
        0x5154, 0x4E91, 0x4B6F, 0x47F3, 0x4420, 0x3FFC, 0x3B8B, 0x36D2, 0x31D7, 0x2CA1, 0x2735, 0x219A, 0x1BD6, 0x15F2, 0x0FF2, 0x09E0,
        0x03C2, 0xFDA0, 0xF780, 0xF16B, 0xEB67, 0xE57B, 0xDFB0, 0xDA0B, 0xD494, 0xCF51, 0xCA48, 0xC580, 0xC0FE, 0xBCC8, 0xB8E2, 0xB552,
        0xB21C, 0xAF43, 0xACCB, 0xAAB7, 0xA909, 0xA7C3, 0xA6E8, 0xA678, 0xA673, 0xA6D9, 0xA7AB, 0xA8E7, 0xAA8B, 0xAC96, 0xAF05, 0xB1D5,
        0xB503, 0xB88B, 0xBC69, 0xC098, 0xC513, 0xC9D5, 0xCED8, 0xD416, 0xD988, 0xDF29, 0xE4F2, 0xEADA, 0xF0DC, 0xF6F1, 0xFD10, 0x0332,
        0x0951, 0x0F64, 0x1566, 0x1B4D, 0x2114, 0x26B3, 0x2C24, 0x315F, 0x365F, 0x3B1F, 0x3F97, 0x43C2, 0x479D, 0x4B21, 0x4E4B, 0x5117,
        0x5382, 0x5589, 0x5729, 0x5860, 0x592D, 0x598F, 0x5986, 0x5911, 0x5831, 0x56E7, 0x5535, 0x531D, 0x50A1, 0x4DC4, 0x4A89, 0x46F6,
        0x430D, 0x3ED3, 0x3A4E, 0x3583, 0x3078, 0x2B33, 0x25BA, 0x2013, 0x1A46, 0x1459, 0x0E54, 0x083E, 0x021E, 0xFBFC, 0xF5DF, 0xEFCD,
        0xE9CF, 0xE3EB, 0xDE29, 0xD890, 0xD326, 0xCDF2, 0xC8FA, 0xC444, 0xBFD6, 0xBBB5, 0xB7E6, 0xB46D, 0xB14F, 0xAE90, 0xAC32, 0xAA39,
        0xA8A8, 0xA77E, 0xA6BF, 0xA66C, 0xA684, 0xA707, 0xA7F5, 0xA94D, 0xAB0D, 0xAD32, 0xAFBC, 0xB2A5, 0xB5EC, 0xB98B, 0xBD7F, 0xC1C3,
        0xC652, 0xCB26, 0xD039, 0xD586, 0xDB05, 0xE0B1, 0xE683, 0xEC73, 0xF27B, 0xF893, 0xFEB4, 0x04D5, 0x0AF2, 0x1102, 0x16FD, 0x1CDC,
        0x2299, 0x282C, 0x2D8F, 0x32BC, 0x37AB, 0x3C58, 0x40BC, 0x44D2, 0x4896, 0x4C03, 0x4F14, 0x51C7, 0x5417, 0x5602, 0x5786, 0x58A1,
        0x5952, 0x5997, 0x5971, 0x58DF, 0x57E3, 0x567D, 0x54B0, 0x527C, 0x4FE6, 0x4CF0, 0x499D, 0x45F2, 0x41F3, 0x3DA5, 0x390D, 0x3430,
        0x2F15, 0x29C1, 0x243B, 0x1E89, 0x18B3, 0x12BF, 0x0CB5, 0x069C, 0x007A, 0xFA59, 0xF43E, 0xEE30, 0xE839, 0xE25D, 0xDCA6, 0xD719,
        0xD1BC, 0xCC98, 0xC7B1, 0xC30E, 0xBEB4, 0xBAA8, 0xB6F0, 0xB38F, 0xB08A, 0xADE4, 0xABA1, 0xA9C4, 0xA84E, 0xA741, 0xA69F, 0xA668,
        0xA69C, 0xA73C, 0xA847, 0xA9BA, 0xAB96, 0xADD6, 0xB07A, 0xB37D, 0xB6DB, 0xBA92, 0xBE9C, 0xC2F4, 0xC796, 0xCC7B, 0xD19E, 0xD6F9,
        0xDC86, 0xE23C, 0xE817, 0xEE0E, 0xF41B, 0xFA36, 0x0057, 0x0679, 0x0C92, 0x129D, 0x1892, 0x1E69, 0x241B, 0x29A2, 0x2EF7, 0x3414,
        0x38F2, 0x3D8C, 0x41DB, 0x45DC, 0x4989, 0x4CDE, 0x4FD6, 0x526F, 0x54A4, 0x5674, 0x57DC, 0x58DB, 0x596F, 0x5998, 0x5955, 0x58A6,
        0x578E, 0x560C, 0x5423, 0x51D5, 0x4F25, 0x4C15, 0x48AB, 0x44E9, 0x40D4, 0x3C71, 0x37C6, 0x32D8, 0x2DAD, 0x284B, 0x22B9, 0x1CFD,
        0x171E, 0x1124, 0x0B15, 0x04F8, 0xFED7, 0xF8B6, 0xF29E, 0xEC95, 0xE6A5, 0xE0D2, 0xDB25, 0xD5A5, 0xD057, 0xCB42, 0xC66D, 0xC1DC,
        0xBD97, 0xB9A1, 0xB600, 0xB2B7, 0xAFCB, 0xAD40, 0xAB18, 0xA956, 0xA7FB, 0xA70B, 0xA685, 0xA66B, 0xA6BC, 0xA779, 0xA8A0, 0xAA2F,
        0xAC26, 0xAE82, 0xB13F, 0xB45B, 0xB7D1, 0xBB9E, 0xBFBE, 0xC42A, 0xC8DF, 0xCDD5, 0xD308, 0xD871, 0xDE09, 0xE3CA, 0xE9AD, 0xEFAB,
        0xF5BC, 0xFBD9, 0x01FB, 0x081B, 0x0E32, 0x1437, 0x1A25, 0x1FF2, 0x259A, 0x2B14, 0x305B, 0x3567, 0x3A34, 0x3EBA, 0x42F5, 0x46E0,
        0x4A76, 0x4DB2, 0x5091, 0x5310, 0x552A, 0x56DF, 0x582B, 0x590D, 0x5984, 0x5990, 0x5931, 0x5866, 0x5731, 0x5593, 0x538F, 0x5126,
        0x4E5C, 0x4B34, 0x47B2, 0x43D9, 0x3FAF, 0x3B39, 0x367B, 0x317C, 0x2C42, 0x26D2, 0x2134, 0x1B6E, 0x1588, 0x0F87, 0x0973, 0x0355,
        0xFD33, 0xF714, 0xF0FF, 0xEAFC, 0xE513, 0xDF4A, 0xD9A8, 0xD434, 0xCEF5, 0xC9F1, 0xC52D, 0xC0B0, 0xBC80, 0xB8A0, 0xB516, 0xB1E6,
        0xAF14, 0xACE5, 0xAB1E, 0xA9C0, 0xA8CB, 0xA841, 0xA821, 0xA86B, 0xA91D, 0xAA37, 0xABB6, 0xAD98, 0xAFDA, 0xB278, 0xB56F, 0xB8BB,
        0xBC57, 0xC03E, 0xC46B, 0xC8D9, 0xCD82, 0xD260, 0xD76C, 0xDCA1, 0xE1F7, 0xE769, 0xECEF, 0xF282, 0xF81D, 0xFDB7, 0x0349, 0x08CF,
        0x0E41, 0x1399, 0x18D0, 0x1DE0, 0x22C3, 0x2774, 0x2BEE, 0x302B, 0x3427, 0x37DD, 0x3B4A, 0x3E69, 0x4138, 0x43B4, 0x45DA, 0x47A8,
        0x491D, 0x4A37, 0x4AF7, 0x4B5B, 0x4B63, 0x4B11, 0x4A66, 0x4962, 0x4808, 0x465A, 0x445A, 0x420C, 0x3F72, 0x3C91, 0x396D, 0x3609,
        0x326B, 0x2E97, 0x2A91, 0x2660, 0x2209, 0x1D91, 0x18FE, 0x1455, 0x0F9D, 0x0ADA, 0x0614, 0x014F, 0xFC93, 0xF7E3, 0xF345, 0xEEC0,
        0xEA58, 0xE612, 0xE1F4, 0xDE02, 0xDA41, 0xD6B4, 0xD35F, 0xD047, 0xCD6E, 0xCAD8, 0xC886, 0xC67C, 0xC4BB, 0xC345, 0xC21A, 0xC13D,
        0xC0AC, 0xC069, 0xC073, 0xC0C9, 0xC16B, 0xC256, 0xC38A, 0xC504, 0xC6C2, 0xC8C1, 0xCAFF, 0xCD77, 0xD028, 0xD30C, 0xD621, 0xD961,
        0xDCC9, 0xE055, 0xE3FF, 0xE7C3, 0xEB9D, 0xEF86, 0xF37C, 0xF778, 0xFB76, 0xFF70, 0x0362, 0x0749, 0x0B1E, 0x0EDE, 0x1283, 0x160B,
        0x1970, 0x1CAF, 0x1FC5, 0x22AE, 0x2566, 0x27EC, 0x2A3C, 0x2C54, 0x2E32, 0x2FD4, 0x3139, 0x3260, 0x3347, 0x33EF, 0x3457, 0x347E,
        0x3467, 0x3410, 0x337B, 0x32AA, 0x319E, 0x3058, 0x2EDC, 0x2D2A, 0x2B45, 0x2932, 0x26F1, 0x2487, 0x21F6, 0x1F43, 0x1C70, 0x1982,
        0x167C, 0x1363, 0x1039, 0x0D04, 0x09C6, 0x0685, 0x0344, 0x0006, 0xFCD2, 0xF9A8, 0xF68E, 0xF387, 0xF097, 0xEDC0, 0xEB06, 0xE86D,
        0xE5F6, 0xE3A5, 0xE17C, 0xDF7E, 0xDDAB, 0xDC07, 0xDA92, 0xD94E, 0xD83C, 0xD75D, 0xD6B1, 0xD638, 0xD5F3, 0xD5E2, 0xD603, 0xD657,
        0xD6DC, 0xD792, 0xD876, 0xD987, 0xDAC4, 0xDC2B, 0xDDB9, 0xDF6C, 0xE142, 0xE338, 0xE54B, 0xE779, 0xE9BE, 0xEC18, 0xEE83, 0xF0FD,
        0xF382, 0xF60F, 0xF8A0, 0xFB33, 0xFDC5, 0x0051, 0x02D6, 0x0551, 0x07BE, 0x0A1B, 0x0C64, 0x0E98, 0x10B4, 0x12B5, 0x149A, 0x1660,
        0x1806, 0x198A, 0x1AEB, 0x1C27, 0x1D3D, 0x1E2D, 0x1EF5, 0x1F95, 0x200E, 0x205E, 0x2086, 0x2086, 0x205F, 0x2011, 0x1F9D, 0x1F05,
        0x1E49, 0x1D6A, 0x1C6B, 0x1B4D, 0x1A11, 0x18B9, 0x1749, 0x15C0, 0x1423, 0x1272, 0x10B1, 0x0EE1, 0x0D05, 0x0B20, 0x0933, 0x0743,
        0x054F, 0x035C, 0x016C, 0xFF82, 0xFD9E, 0xFBC3, 0xF9F4, 0xF833, 0xF681, 0xF4E1, 0xF354, 0xF1DD, 0xF07B, 0xEF31, 0xEE01, 0xECEB,
        0xEBEF, 0xEB10, 0xEA4E, 0xE9A8, 0xE920, 0xE8B6, 0xE86A, 0xE83C, 0xE82B, 0xE837, 0xE860, 0xE8A6, 0xE906, 0xE981, 0xEA16, 0xEAC3,
        0xEB87, 0xEC61, 0xED4F, 0xEE51, 0xEF64, 0xF086, 0xF1B7, 0xF2F5, 0xF43D, 0xF58E, 0xF6E7, 0xF845, 0xF9A6, 0xFB0A, 0xFC6D, 0xFDCF,
        0xFF2E, 0x0087, 0x01DA, 0x0325, 0x0466, 0x059D, 0x06C7, 0x07E4, 0x08F2, 0x09F0, 0x0ADD, 0x0BB9, 0x0C83, 0x0D39, 0x0DDC, 0x0E6B,
        0x0EE6, 0x0F4C, 0x0F9D, 0x0FDA, 0x1002, 0x1016, 0x1015, 0x1001, 0x0FD9, 0x0F9F, 0x0F53, 0x0EF5, 0x0E86, 0x0E09, 0x0D7C, 0x0CE1,
        0x0C3A, 0x0B87, 0x0ACA, 0x0A03, 0x0935, 0x085F, 0x0783, 0x06A3, 0x05C0, 0x04DA, 0x03F4, 0x030E, 0x0229, 0x0146, 0x0067, 0xFF8E,
        0xFEBA, 0xFDEC, 0xFD25, 0xFC67, 0xFBB2, 0xFB06, 0xFA65, 0xF9CF, 0xF944, 0xF8C5, 0xF853, 0xF7ED, 0xF793, 0xF747, 0xF707, 0xF6D5,
        0xF6AF, 0xF696, 0xF68A, 0xF68A, 0xF696, 0xF6AE, 0xF6D0, 0xF6FE, 0xF735, 0xF777, 0xF7C1, 0xF813, 0xF86D, 0xF8CF, 0xF936, 0xF9A3,
        0xFA15, 0xFA8B, 0xFB04, 0xFB80, 0xFBFE, 0xFC7C, 0xFCFC, 0xFD7B, 0xFDF8, 0xFE75, 0xFEEF, 0xFF66, 0xFFDA, 0x0049, 0x00B4, 0x011B,
        0x017D, 0x01D8, 0x022E, 0x027E, 0x02C7, 0x030A, 0x0346, 0x037B, 0x03A9, 0x03D1, 0x03F1, 0x040B, 0x041E, 0x042A, 0x0430, 0x0430,
        0x042A, 0x041F, 0x040E, 0x03F8, 0x03DE, 0x03BF, 0x039D, 0x0377, 0x034E, 0x0322, 0x02F4, 0x02C4, 0x0292, 0x0260, 0x022C, 0x01F9,
        0x01C5, 0x0192, 0x015F, 0x012E, 0x00FE, 0x00CF, 0x00A3, 0x0078, 0x0050, 0x002A, 0x0006, 0xFFE7, 0xFFC9, 0xFFAE, 0xFF96, 0xFF81,
        0xFF6F, 0xFF5F, 0xFF53, 0xFF49, 0xFF42, 0xFF3D, 0xFF3B, 0xFF3B, 0xFF3D, 0xFF41, 0xFF47, 0xFF4E, 0xFF56, 0xFF60, 0xFF6B, 0xFF76,
        0xFF82, 0xFF8E, 0xFF9A, 0xFFA6, 0xFFB2, 0xFFBE, 0xFFC9, 0xFFD3, 0xFFDC, 0xFFE5, 0xFFEC, 0xFFF3, 0xFFF8, 0xFFFC, 0xFFFF, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFD,
        0xFFFC, 0xFFFA, 0xFFF7, 0xFFF4, 0xFFF1, 0xFFED, 0xFFE9, 0xFFE5, 0xFFE0, 0xFFDA, 0xFFD5, 0xFFCE, 0xFFC8, 0xFFC1, 0xFFB9, 0xFFB2,
        0xFFAA, 0xFFA1, 0xFF99, 0xFF90, 0xFF87, 0xFF7E, 0xFF75, 0xFF6B, 0xFF62, 0xFF59, 0xFF50, 0xFF48, 0xFF3F, 0xFF37, 0xFF30, 0xFF29,
        0xFF22, 0xFF1C, 0xFF17, 0xFF13, 0xFF0F, 0xFF0D, 0xFF0B, 0xFF0B, 0xFF0C, 0xFF0E, 0xFF11, 0xFF15, 0xFF1B, 0xFF22, 0xFF2B, 0xFF35,
        0xFF41, 0xFF4F, 0xFF5E, 0xFF6E, 0xFF80, 0xFF94, 0xFFAA, 0xFFC1, 0xFFD9, 0xFFF4, 0x000E, 0x002C, 0x004A, 0x006A, 0x008C, 0x00AE,
        0x00D2, 0x00F7, 0x011C, 0x0143, 0x016A, 0x0192, 0x01BB, 0x01E4, 0x020D, 0x0236, 0x025F, 0x0288, 0x02B0, 0x02D8, 0x02FF, 0x0326,
        0x034B, 0x036F, 0x0391, 0x03B2, 0x03D1, 0x03EF, 0x040A, 0x0422, 0x0439, 0x044C, 0x045D, 0x046B, 0x0476, 0x047E, 0x0482, 0x0482,
        0x047F, 0x0479, 0x046E, 0x045F, 0x044D, 0x0436, 0x041B, 0x03FC, 0x03D9, 0x03B1, 0x0386, 0x0356, 0x0321, 0x02E9, 0x02AC, 0x026C,
        0x0227, 0x01DF, 0x0192, 0x0143, 0x00F0, 0x0099, 0x003F, 0xFFE4, 0xFF85, 0xFF23, 0xFEBF, 0xFE59, 0xFDF2, 0xFD89, 0xFD1E, 0xFCB3,
        0xFC48, 0xFBDC, 0xFB70, 0xFB05, 0xFA9B, 0xFA32, 0xF9CA, 0xF964, 0xF901, 0xF8A0, 0xF842, 0xF7E7, 0xF790, 0xF73D, 0xF6EE, 0xF6A4,
        0xF660, 0xF620, 0xF5E7, 0xF5B3, 0xF586, 0xF55F, 0xF540, 0xF527, 0xF516, 0xF50C, 0xF50B, 0xF511, 0xF520, 0xF537, 0xF556, 0xF57E,
        0xF5AE, 0xF5E8, 0xF62A, 0xF674, 0xF6C7, 0xF723, 0xF788, 0xF7F4, 0xF869, 0xF8E6, 0xF96B, 0xF9F8, 0xFA8C, 0xFB27, 0xFBC9, 0xFC72,
        0xFD21, 0xFDD5, 0xFE8F, 0xFF4D, 0x0010, 0x00D7, 0x01A1, 0x026F, 0x033F, 0x0411, 0x04E4, 0x05B8, 0x068C, 0x075F, 0x0832, 0x0902,
        0x09D0, 0x0A9B, 0x0B63, 0x0C26, 0x0CE4, 0x0D9D, 0x0E4F, 0x0EFB, 0x0F9F, 0x103B, 0x10CE, 0x1159, 0x11D9, 0x124F, 0x12BA, 0x1319,
        0x136D, 0x13B5, 0x13F0, 0x141D, 0x143E, 0x1450, 0x1454, 0x144A, 0x1432, 0x140A, 0x13D4, 0x138F, 0x133B, 0x12D8, 0x1265, 0x11E4,
        0x1154, 0x10B6, 0x1008, 0x0F4D, 0x0E84, 0x0DAD, 0x0CC9, 0x0BD8, 0x0ADB, 0x09D3, 0x08BF, 0x07A0, 0x0677, 0x0546, 0x040B, 0x02C9,
        0x017F, 0x0030, 0xFEDC, 0xFD82, 0xFC25, 0xFAC5, 0xF964, 0xF801, 0xF69F, 0xF53E, 0xF3DF, 0xF284, 0xF12C, 0xEFDA, 0xEE8E, 0xED49,
        0xEC0D, 0xEAD9, 0xE9B0, 0xE893, 0xE781, 0xE67D, 0xE586, 0xE49F, 0xE3C7, 0xE300, 0xE24B, 0xE1A7, 0xE117, 0xE09A, 0xE031, 0xDFDC,
        0xDF9D, 0xDF74, 0xDF61, 0xDF64, 0xDF7E, 0xDFAF, 0xDFF7, 0xE057, 0xE0CE, 0xE15C, 0xE202, 0xE2BE, 0xE392, 0xE47C, 0xE57C, 0xE692,
        0xE7BE, 0xE8FE, 0xEA53, 0xEBBB, 0xED36, 0xEEC3, 0xF061, 0xF210, 0xF3CD, 0xF599, 0xF772, 0xF957, 0xFB47, 0xFD40, 0xFF42, 0x014A,
        0x0358, 0x056B, 0x0780, 0x0997, 0x0BAF, 0x0DC4, 0x0FD7, 0x11E5, 0x13EE, 0x15EF, 0x17E7, 0x19D4, 0x1BB6, 0x1D8B, 0x1F50, 0x2106,
        0x22AA, 0x243B, 0x25B7, 0x271E, 0x286F, 0x29A7, 0x2AC6, 0x2BCB, 0x2CB5, 0x2D83, 0x2E34, 0x2EC7, 0x2F3B, 0x2F90, 0x2FC5, 0x2FDA,
        0x2FCE, 0x2FA0, 0x2F52, 0x2EE2, 0x2E50, 0x2D9D, 0x2CC8, 0x2BD2, 0x2ABB, 0x2983, 0x282B, 0x26B4, 0x251E, 0x236A, 0x2198, 0x1FAA,
        0x1DA2, 0x1B7F, 0x1943, 0x16EF, 0x1485, 0x1207, 0x0F75, 0x0CD1, 0x0A1E, 0x075C, 0x048D, 0x01B4, 0xFED2, 0xFBE9, 0xF8FA, 0xF609,
        0xF317, 0xF025, 0xED37, 0xEA4D, 0xE76B, 0xE492, 0xE1C4, 0xDF04, 0xDC53, 0xD9B4, 0xD728, 0xD4B2, 0xD253, 0xD00D, 0xCDE2, 0xCBD4,
        0xC9E4, 0xC815, 0xC668, 0xC4DD, 0xC378, 0xC238, 0xC120, 0xC030, 0xBF6A, 0xBECE, 0xBE5D, 0xBE18, 0xBDFF, 0xBE14, 0xBE56, 0xBEC6,
        0xBF64, 0xC02F, 0xC129, 0xC24F, 0xC3A3, 0xC524, 0xC6D0, 0xC8A8, 0xCAAB, 0xCCD7, 0xCF2B, 0xD1A6, 0xD447, 0xD70C, 0xD9F4, 0xDCFD,
        0xE025, 0xE36B, 0xE6CC, 0xEA46, 0xEDD8, 0xF17E, 0xF537, 0xF8FF, 0xFCD6, 0x00B7, 0x04A1, 0x0891, 0x0C85, 0x1079, 0x146B, 0x1858,
        0x1C3D, 0x2018, 0x23E6, 0x27A4, 0x2B4F, 0x2EE5, 0x3264, 0x35C7, 0x390E, 0x3C34, 0x3F39, 0x4219, 0x44D3, 0x4763, 0x49C8, 0x4C00,
        0x4E0A, 0x4FE2, 0x5187, 0x52F9, 0x5435, 0x553A, 0x5607, 0x569B, 0x56F5, 0x5715, 0x56F9, 0x56A1, 0x560E, 0x553E, 0x5432, 0x52EB,
        0x5111, 0x4F01, 0x4CBC, 0x4A43, 0x4797, 0x44BC, 0x41B2, 0x3E7C, 0x3B1C, 0x3794, 0x33E6, 0x3016, 0x2C25, 0x2817, 0x23ED, 0x1FAB,
        0x1B54, 0x16EA, 0x1271, 0x0DEC, 0x095D, 0x04C8, 0x0030, 0xFB98, 0xF703, 0xF273, 0xEDED, 0xE973, 0xE508, 0xE0AF, 0xDC6B, 0xD83F,
        0xD42F, 0xD03B, 0xCC68, 0xC8B8, 0xC52C, 0xC1C9, 0xBE8F, 0xBB82, 0xB8A3, 0xB5F3, 0xB376, 0xB12C, 0xAF18, 0xAD3A, 0xAB93, 0xAA26,
        0xA8F2, 0xA7F9, 0xA73C, 0xA6BA, 0xA674, 0xA66B, 0xA69E, 0xA70E, 0xA7B9, 0xA8A0, 0xA9C2, 0xAB1D, 0xACB2, 0xAE7F, 0xB084, 0xB2BD,
        0xB52B, 0xB7CB, 0xBA9C, 0xBD9B, 0xC0C8, 0xC41F, 0xC79E, 0xCB43, 0xCF0C, 0xD2F6, 0xD6FE, 0xDB22, 0xDF5E, 0xE3B1, 0xE817, 0xEC8C,
        0xF10F, 0xF59C, 0xFA30, 0xFEC8, 0x0360, 0x07F6, 0x0C88, 0x1110, 0x158D, 0x19FC, 0x1E59, 0x22A2, 0x26D3, 0x2AEA, 0x2EE4, 0x32BF,
        0x3678, 0x3A0B, 0x3D78, 0x40BB, 0x43D3, 0x46BC, 0x4977, 0x4BFF, 0x4E55, 0x5075, 0x5260, 0x5413, 0x558D, 0x56CE, 0x57D4, 0x589F,
        0x592E, 0x5981, 0x5998, 0x5972, 0x5911, 0x5873, 0x5799, 0x5685, 0x5536, 0x53AE, 0x51ED, 0x4FF5, 0x4DC7, 0x4B65, 0x48D0, 0x460A,
        0x4315, 0x3FF2, 0x3CA5, 0x392F, 0x3592, 0x31D1, 0x2DEE, 0x29EC, 0x25CF, 0x2197, 0x1D49, 0x18E8, 0x1475, 0x0FF5, 0x0B6A, 0x06D7,
        0x0240, 0xFDA8, 0xF911, 0xF47E, 0xEFF3, 0xEB73, 0xE701, 0xE2A0, 0xDE53, 0xDA1C, 0xD5FE, 0xD1FD, 0xCE1B, 0xCA5B, 0xC6BF, 0xC349,
        0xBFFD, 0xBCDB, 0xB9E7, 0xB722, 0xB48E, 0xB22D, 0xB000, 0xAE09, 0xAC4A, 0xAAC3, 0xA975, 0xA862, 0xA78A, 0xA6ED, 0xA68C, 0xA668,
        0xA680, 0xA6D4, 0xA765, 0xA831, 0xA938, 0xAA7A, 0xABF5, 0xADAA, 0xAF95, 0xB1B7, 0xB40D, 0xB697, 0xB952, 0xBC3D, 0xBF56, 0xC29A,
        0xC607, 0xC99C, 0xCD55, 0xD130, 0xD52B, 0xD943, 0xDD74, 0xE1BE, 0xE61B, 0xEA8A, 0xEF07, 0xF390, 0xF821, 0xFCB8, 0x0150, 0x05E8,
        0x0A7C, 0x0F08, 0x138B, 0x1801, 0x1C66, 0x20B8, 0x24F4, 0x2917, 0x2D1F, 0x3108, 0x34D0, 0x3875, 0x3BF3, 0x3F49, 0x4275, 0x4573,
        0x4843, 0x4AE2, 0x4D4F, 0x4F88, 0x518B, 0x5357, 0x54EA, 0x5645, 0x5765, 0x584B, 0x58F5, 0x5963, 0x5995, 0x598B, 0x5944, 0x58C1,
        0x5802, 0x5708, 0x55D3, 0x5465, 0x52BD, 0x50DE, 0x4EC8, 0x4C7D, 0x49FF, 0x474F, 0x446F, 0x4160, 0x3E26, 0x3AC1, 0x3735, 0x3384,
        0x2FB0, 0x2BBC, 0x27AB, 0x237F, 0x1F3B, 0x1AE1, 0x1676, 0x11FC, 0x0D75, 0x08E6, 0x0450, 0xFFB8, 0xFB20, 0xF68B, 0xF1FC, 0xED77,
        0xE8FE, 0xE495, 0xE03E, 0xDBFD, 0xD7D4, 0xD3C6, 0xCFD6, 0xCC06, 0xC859, 0xC4D2, 0xC173, 0xBE3E, 0xBB35, 0xB85A, 0xB5B0, 0xB338,
        0xB0F3, 0xAEE4, 0xAD0C, 0xAB6B, 0xAA04, 0xA8D6, 0xA7E3, 0xA72C, 0xA6B0, 0xA671, 0xA66E, 0xA6A7, 0xA71C, 0xA7CE, 0xA8BB, 0xA9E2,
        0xAB44, 0xACDF, 0xAEB2, 0xB0BB, 0xB2FA, 0xB56D, 0xB812, 0xBAE8, 0xBDEC, 0xC11D, 0xC478, 0xC7FB, 0xCBA4, 0xCF71, 0xD35E, 0xD769,
        0xDB8F, 0xDFCE, 0xE423, 0xE88A, 0xED02, 0xF186, 0xF614, 0xFAA8, 0xFF40, 0x03D8, 0x086E, 0x0CFE, 0x1186, 0x1602, 0x1A6F, 0x1ECA,
        0x2310, 0x273F, 0x2B54, 0x2F4B, 0x3322, 0x36D7, 0x3A67, 0x3DCF, 0x410E, 0x4421, 0x4706, 0x49BB, 0x4C3F, 0x4E8F, 0x50AA, 0x528F,
        0x543C, 0x55B1, 0x56EB, 0x57EB, 0x58B0, 0x5939, 0x5986, 0x5997, 0x596B, 0x5903, 0x585F, 0x5780, 0x5665, 0x5510, 0x5382, 0x51BC,
        0x4FBF, 0x4D8B, 0x4B24, 0x488A, 0x45BF, 0x42C5, 0x3F9E, 0x3C4C, 0x38D2, 0x3531, 0x316D, 0x2D87, 0x2982, 0x2562, 0x2128, 0x1CD8,
        0x1874, 0x1400, 0x0F7F, 0x0AF3, 0x065F, 0x01C8, 0xFD30, 0xF899, 0xF407, 0xEF7D, 0xEAFF, 0xE68E, 0xE22F, 0xDDE3, 0xD9AF, 0xD594,
        0xD197, 0xCDB8, 0xC9FB, 0xC663, 0xC2F1, 0xBFA9, 0xBC8C, 0xB99C, 0xB6DC, 0xB44D, 0xB1F2, 0xAFCA, 0xADD9, 0xAC1F, 0xAA9E, 0xA956,
        0xA849, 0xA777, 0xA6E0, 0xA686, 0xA668, 0xA686, 0xA6E0, 0xA777, 0xA849, 0xA956, 0xAA9E, 0xAC1F, 0xADD9, 0xAFCA, 0xB1F2, 0xB44D,
        0xB6DC, 0xB99C, 0xBC8C, 0xBFA9, 0xC2F1, 0xC663, 0xC9FB, 0xCDB8, 0xD197, 0xD594, 0xD9AF, 0xDDE3, 0xE22F, 0xE68E, 0xEAFF, 0xEF7D,
        0xF407, 0xF899, 0xFD30, 0x01C8, 0x065F, 0x0AF3, 0x0F7F, 0x1400, 0x1874, 0x1CD8, 0x2128, 0x2562, 0x2982, 0x2D87, 0x316D, 0x3531,
        0x38D2, 0x3C4C, 0x3F9E, 0x42C5, 0x45BF, 0x488A, 0x4B24, 0x4D8B, 0x4FBF, 0x51BC, 0x5382, 0x5510, 0x5665, 0x5780, 0x585F, 0x5903,
        0x596B, 0x5997, 0x5986, 0x5939, 0x58B0, 0x57EB, 0x56EB, 0x55B1, 0x543C, 0x528F, 0x50AA, 0x4E8F, 0x4C3F, 0x49BB, 0x4706, 0x4421,
        0x410E, 0x3DCF, 0x3A67, 0x36D7, 0x3322, 0x2F4B, 0x2B54, 0x273F, 0x2310, 0x1ECA, 0x1A6F, 0x1602, 0x1186, 0x0CFE, 0x086E, 0x03D8,
        0xFF40, 0xFAA8, 0xF614, 0xF186, 0xED02, 0xE88A, 0xE423, 0xDFCE, 0xDB8F, 0xD769, 0xD35E, 0xCF71, 0xCBA4, 0xC7FB, 0xC478, 0xC11D,
        0xBDEC, 0xBAE8, 0xB812, 0xB56D, 0xB2FA, 0xB0BB, 0xAEB2, 0xACDF, 0xAB44, 0xA9E2, 0xA8BB, 0xA7CE, 0xA71C, 0xA6A7, 0xA66E, 0xA671,
        0xA6B0, 0xA72C, 0xA7E3, 0xA8D6, 0xAA04, 0xAB6B, 0xAD0C, 0xAEE4, 0xB0F3, 0xB338, 0xB5B0, 0xB85A, 0xBB35, 0xBE3E, 0xC173, 0xC4D2,
        0xC859, 0xCC06, 0xCFD6, 0xD3C6, 0xD7D4, 0xDBFD, 0xE03E, 0xE495, 0xE8FE, 0xED77, 0xF1FC, 0xF68B, 0xFB20, 0xFFB8, 0x0450, 0x08E6,
        0x0D75, 0x11FC, 0x1676, 0x1AE1, 0x1F3B, 0x237F, 0x27AB, 0x2BBC, 0x2FB0, 0x3384, 0x3735, 0x3AC1, 0x3E26, 0x4160, 0x446F, 0x474F,
        0x49FF, 0x4C7D, 0x4EC8, 0x50DE, 0x52BD, 0x5465, 0x55D3, 0x5708, 0x5802, 0x58C1, 0x5944, 0x598B, 0x5995, 0x5963, 0x58F5, 0x584B,
        0x5765, 0x5645, 0x54EA, 0x5357, 0x518B, 0x4F88, 0x4D4F, 0x4AE2, 0x4843, 0x4573, 0x4275, 0x3F49, 0x3BF3, 0x3875, 0x34D0, 0x3108,
        0x2D1F, 0x2917, 0x24F4, 0x20B8, 0x1C66, 0x1801, 0x138B, 0x0F08, 0x0A7C, 0x05E8, 0x0150, 0xFCB8, 0xF821, 0xF390, 0xEF07, 0xEA8A,
        0xE61B, 0xE1BE, 0xDD74, 0xD943, 0xD52B, 0xD130, 0xCD55, 0xC99C, 0xC607, 0xC29A, 0xBF56, 0xBC3D, 0xB952, 0xB697, 0xB40D, 0xB1B7,
        0xAF95, 0xADAA, 0xABF5, 0xAA7A, 0xA938, 0xA831, 0xA765, 0xA6D4, 0xA680, 0xA668, 0xA68C, 0xA6ED, 0xA78A, 0xA862, 0xA975, 0xAAC3,
        0xAC4A, 0xAE09, 0xB000, 0xB22D, 0xB48E, 0xB722, 0xB9E7, 0xBCDB, 0xBFFD, 0xC349, 0xC6BF, 0xCA5B, 0xCE1B, 0xD1FD, 0xD5FE, 0xDA1C,
        0xDE53, 0xE2A0, 0xE701, 0xEB73, 0xEFF3, 0xF47E, 0xF911, 0xFDA8, 0x0240, 0x06D7, 0x0B6A, 0x0FF5, 0x1475, 0x18E8, 0x1D49, 0x2197,
        0x25CF, 0x29EC, 0x2DEE, 0x31D1, 0x3592, 0x392F, 0x3CA5, 0x3FF2, 0x4315, 0x460A, 0x48D0, 0x4B65, 0x4DC7, 0x4FF5, 0x51ED, 0x53AE,
        0x5536, 0x5685, 0x5799, 0x5873, 0x5911, 0x5972, 0x5998, 0x5981, 0x592E, 0x589F, 0x57D4, 0x56CE, 0x558D, 0x5413, 0x5260, 0x5075,
        0x4E55, 0x4BFF, 0x4977, 0x46BC, 0x43D3, 0x40BB, 0x3D78, 0x3A0B, 0x3678, 0x32BF, 0x2EE4, 0x2AEA, 0x26D3, 0x22A2, 0x1E59, 0x19FC,
        0x158D, 0x1110, 0x0C88, 0x07F6, 0x0360, 0xFEC8, 0xFA30, 0xF59C, 0xF10F, 0xEC8C, 0xE817, 0xE3B1, 0xDF5E, 0xDB22, 0xD6FE, 0xD2F6,
        0xCF0C, 0xCB43, 0xC79E, 0xC41F, 0xC0C8, 0xBD9B, 0xBA9C, 0xB7CB, 0xB52B, 0xB2BD, 0xB084, 0xAE7F, 0xACB2, 0xAB1D, 0xA9C2, 0xA8A0,
        0xA7B9, 0xA70E, 0xA69E, 0xA66B, 0xA674, 0xA6BA, 0xA73C, 0xA7F9, 0xA8F2, 0xAA26, 0xAB93, 0xAD3A, 0xAF18, 0xB12C, 0xB376, 0xB5F3,
        0xB8A3, 0xBB82, 0xBE8F, 0xC1C9, 0xC52C, 0xC8B8, 0xCC68, 0xD03B, 0xD42F, 0xD83F, 0xDC6B, 0xE0AF, 0xE508, 0xE973, 0xEDED, 0xF273,
        0xF703, 0xFB98, 0x0030, 0x04C8, 0x095D, 0x0DEC, 0x1271, 0x16EA, 0x1B54, 0x1FAB, 0x23ED, 0x2817, 0x2C25, 0x3016, 0x33E6, 0x3794,
        0x3B1C, 0x3E7C, 0x41B2, 0x44BC, 0x4797, 0x4A43, 0x4CBC, 0x4F01, 0x5111, 0x52EB, 0x548D, 0x55F5, 0x5724, 0x5818, 0x58D1, 0x594E,
        0x598F, 0x5993, 0x595B, 0x58E7, 0x5836, 0x574B, 0x5624, 0x54C4, 0x532A, 0x5158, 0x4F50, 0x4D12, 0x4AA0, 0x47FC, 0x4527, 0x4224,
        0x3EF4, 0x3B9A, 0x3817, 0x346F, 0x30A4, 0x2CB7, 0x28AD, 0x2487, 0x2048, 0x1BF4, 0x178D, 0x1316, 0x0E92, 0x0A04, 0x0570, 0x00D8,
        0xFC40, 0xF7AA, 0xF319, 0xEE92, 0xEA15, 0xE5A8, 0xE14D, 0xDD06, 0xD8D6, 0xD4C2, 0xD0CA, 0xCCF2, 0xC93C, 0xC5AC, 0xC242, 0xBF03,
        0xBBEF, 0xB909, 0xB653, 0xB3CE, 0xB17D, 0xAF60, 0xAD7A, 0xABCC, 0xAA57, 0xA91B, 0xA819, 0xA753, 0xA6C9, 0xA67B, 0xA669, 0xA693,
        0xA6FA, 0xA79D, 0xA87B, 0xA995, 0xAAE8, 0xAC75, 0xAE3A, 0xB036, 0xB269, 0xB4CF, 0xB768, 0xBA32, 0xBD2B, 0xC051, 0xC3A2, 0xC71C,
        0xCABC, 0xCE7F, 0xD265, 0xD669, 0xDA89, 0xDEC2, 0xE312, 0xE775, 0xEBE8, 0xF06A, 0xF4F5, 0xF989, 0xFE20, 0x02B8, 0x074F, 0x0BE1,
        0x106B, 0x14EA, 0x195B, 0x1DBB, 0x2206, 0x263B, 0x2A56, 0x2E55, 0x3234, 0x35F2, 0x398B, 0x3CFD, 0x4046, 0x4364, 0x4655, 0x4916,
        0x4BA6, 0x4E03, 0x502B, 0x521D, 0x53D8, 0x555B, 0x56A4, 0x57B2, 0x5885, 0x591D, 0x5979, 0x5998, 0x597B, 0x5922, 0x588D, 0x57BC,
        0x56B0, 0x5569, 0x53E9, 0x5230, 0x5040, 0x4E1A, 0x4BBF, 0x4932, 0x4673, 0x4384, 0x4068, 0x3D20, 0x39B0, 0x3618, 0x325C, 0x2E7E,
        0x2A81, 0x2667, 0x2233, 0x1DE8, 0x1989, 0x1519, 0x109A, 0x0C11, 0x077F, 0x02E8, 0xFE50, 0xF9B9, 0xF525, 0xF099, 0xEC17, 0xE7A3,
        0xE33F, 0xDEEF, 0xDAB4, 0xD693, 0xD28E, 0xCEA7, 0xCAE2, 0xC741, 0xC3C5, 0xC073, 0xBD4B, 0xBA50, 0xB784, 0xB4E9, 0xB281, 0xB04C,
        0xAE4E, 0xAC86, 0xAAF7, 0xA9A1, 0xA886, 0xA7A5, 0xA700, 0xA696, 0xA669, 0xA679, 0xA6C5, 0xA74C, 0xA810, 0xA90F, 0xAA48, 0xABBC,
        0xAD68, 0xAF4C, 0xB166, 0xB3B5, 0xB637, 0xB8EB, 0xBBD0, 0xBEE2, 0xC220, 0xC587, 0xC916, 0xCCCA, 0xD0A1, 0xD497, 0xD8AB, 0xDCDA,
        0xE11F, 0xE57A, 0xE9E7, 0xEE62, 0xF2EA, 0xF77A, 0xFC10, 0x00A8, 0x0540, 0x09D4, 0x0E62, 0x12E7, 0x175E, 0x1BC6, 0x201B, 0x245B,
        0x2882, 0x2C8D, 0x307B, 0x3448, 0x37F2, 0x3B76, 0x3ED2, 0x4204, 0x4509, 0x47DF, 0x4A86, 0x4CF9, 0x4F3A, 0x5144, 0x5318, 0x54B4,
        0x5617, 0x5740, 0x582E, 0x58E1, 0x5957, 0x5992, 0x5990, 0x5952, 0x58D7, 0x5821, 0x572F, 0x5603, 0x549D, 0x52FD, 0x5126, 0x4F18,
        0x4CD5, 0x4A5D, 0x47B4, 0x44DB, 0x41D3, 0x3E9E, 0x3B40, 0x37BA, 0x340E, 0x303E, 0x2C4F, 0x2841, 0x2419, 0x1FD8, 0x1B82, 0x1719,
        0x12A0, 0x0E1B, 0x098D, 0x04F8, 0x0060, 0xFBC8, 0xF732, 0xF2A3, 0xEE1C, 0xE9A1, 0xE535, 0xE0DC, 0xDC97, 0xD86B, 0xD458, 0xD064,
        0xCC8F, 0xC8DD, 0xC551, 0xC1EC, 0xBEB0, 0xBBA1, 0xB8C0, 0xB60E, 0xB38F, 0xB143, 0xAF2C, 0xAD4C, 0xABA3, 0xAA34, 0xA8FE, 0xA802,
        0xA742, 0xA6BE, 0xA676, 0xA66A, 0xA69B, 0xA708, 0xA7B1, 0xA895, 0xA9B5, 0xAB0E, 0xACA1, 0xAE6C, 0xB06D, 0xB2A5, 0xB510, 0xB7AF,
        0xBA7D, 0xBD7B, 0xC0A6, 0xC3FB, 0xC779, 0xCB1C, 0xCEE4, 0xD2CC, 0xD6D3, 0xDAF6, 0xDF32, 0xE383, 0xE7E8, 0xEC5E, 0xF0E0, 0xF56D,
        0xFA00, 0xFE98, 0x0330, 0x07C7, 0x0C58, 0x10E1, 0x155F, 0x19CE, 0x1E2C, 0x2275, 0x26A8, 0x2AC0, 0x2EBC, 0x3297, 0x3651, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2F22, 0x32FA, 0x36B1, 0x3A42, 0x3DAC, 0x40ED, 0x4402, 0x46E9, 0x49A0, 0x4C25, 0x4E78, 0x5095, 0x527C, 0x542C, 0x55A2,
        0x56DF, 0x57E2, 0x58A9, 0x5935, 0x5984, 0x5997, 0x596E, 0x5909, 0x5867, 0x578A, 0x5672, 0x551F, 0x5394, 0x51D0, 0x4FD4, 0x4DA3,
        0x4B3E, 0x48A6, 0x45DD, 0x42E5, 0x3FC0, 0x3C70, 0x38F7, 0x3558, 0x3195, 0x2DB0, 0x29AD, 0x258D, 0x2154, 0x1D05, 0x18A2, 0x142F,
        0x0FAE, 0x0B22, 0x068F, 0x01F8, 0xFD60, 0xF8C9, 0xF437, 0xEFAD, 0xEB2D, 0xE6BC, 0xE25C, 0xDE10, 0xD9DA, 0xD5BF, 0xD1C0, 0xCDE0,
        0xCA22, 0xC688, 0xC314, 0xBFCA, 0xBCAC, 0xB9BA, 0xB6F8, 0xB467, 0xB209, 0xAFE0, 0xADEC, 0xAC30, 0xAAAD, 0xA963, 0xA853, 0xA77E,
        0xA6E5, 0xA688, 0xA668, 0xA683, 0xA6DB, 0xA770, 0xA83F, 0xA94A, 0xAA90, 0xAC0F, 0xADC6, 0xAFB5, 0xB1DA, 0xB434, 0xB6C1, 0xB97F,
        0xBC6C, 0xBF88, 0xC2CE, 0xC63E, 0xC9D5, 0xCD90, 0xD16E, 0xD56A, 0xD984, 0xDDB7, 0xE201, 0xE660, 0xEAD0, 0xEF4E, 0xF3D8, 0xF869,
        0xFD00, 0x0198, 0x0630, 0x0AC3, 0x0F4F, 0x13D1, 0x1846, 0x1CAA, 0x20FB, 0x2536, 0x2957, 0x2D5D, 0x3144, 0x350A, 0x38AD, 0x3C29,
        0x3F7C, 0x42A5, 0x45A1, 0x486E, 0x4B0A, 0x4D73, 0x4FA9, 0x51A8, 0x5371, 0x5501, 0x5658, 0x5775, 0x5857, 0x58FE, 0x5968, 0x5996,
        0x5988, 0x593E, 0x58B7, 0x57F5, 0x56F7, 0x55BE, 0x544C, 0x52A1, 0x50BF, 0x4EA6, 0x4C58, 0x49D6, 0x4723, 0x4440, 0x412F, 0x3DF2,
        0x3A8B, 0x36FD, 0x3349, 0x2F73, 0x2B7E, 0x276A, 0x233D, 0x1EF7, 0x1A9D, 0x1630, 0x11B5, 0x0D2E, 0x089E, 0x0408, 0xFF70, 0xFAD8,
        0xF643, 0xF1B5, 0xED31, 0xE8B9, 0xE451, 0xDFFB, 0xDBBB, 0xD794, 0xD387, 0xCF99, 0xCBCB, 0xC821, 0xC49C, 0xC13F, 0xBE0D, 0xBB07,
        0xB82F, 0xB588, 0xB313, 0xB0D2, 0xAEC6, 0xACF1, 0xAB54, 0xA9F0, 0xA8C6, 0xA7D6, 0xA723, 0xA6AB, 0xA66F, 0xA66F, 0xA6AC, 0xA726,
        0xA7DB, 0xA8CB, 0xA9F6, 0xAB5C, 0xACFA, 0xAED0, 0xB0DD, 0xB31F, 0xB595, 0xB83D, 0xBB16, 0xBE1D, 0xC150, 0xC4AE, 0xC834, 0xCBDF,
        0xCFAD, 0xD39C, 0xD7A9, 0xDBD1, 0xE012, 0xE467, 0xE8D0, 0xED48, 0xF1CD, 0xF65B, 0xFAF0, 0xFF88, 0x0420, 0x08B6, 0x0D46, 0x11CD,
        0x1648, 0x1AB4, 0x1F0E, 0x2353, 0x2780, 0x2B93, 0x2F88, 0x335D, 0x3710, 0x3A9D, 0x3E03, 0x413F, 0x4450, 0x4732, 0x49E4, 0x4C64,
        0x4EB1, 0x50C9, 0x52AB, 0x5455, 0x55C5, 0x56FD, 0x57F9, 0x58BA, 0x5940, 0x5989, 0x5996, 0x5967, 0x58FB, 0x5853, 0x5770, 0x5652,
        0x54FA, 0x5368, 0x519E, 0x4F9E, 0x4D67, 0x4AFD, 0x4860, 0x4592, 0x4295, 0x3F6B, 0x3C17, 0x389A, 0x34F7, 0x3130, 0x2D49, 0x2942,
        0x2520, 0x20E5, 0x1C93, 0x182F, 0x13BA, 0x0F38, 0x0AAB, 0x0618, 0x0180, 0xFCE8, 0xF851, 0xF3C0, 0xEF37, 0xEAB9, 0xE649, 0xE1EB,
        0xDDA1, 0xD96E, 0xD555, 0xD159, 0xCD7C, 0xC9C2, 0xC62C, 0xC2BD, 0xBF77, 0xBC5D, 0xB970, 0xB6B3, 0xB427, 0xB1CE, 0xAFAA, 0xADBD,
        0xAC06, 0xAA88, 0xA944, 0xA83A, 0xA76C, 0xA6D9, 0xA682, 0xA668, 0xA68A, 0xA6E8, 0xA782, 0xA858, 0xA969, 0xAAB4, 0xAC39, 0xADF6,
        0xAFEB, 0xB215, 0xB474, 0xB706, 0xB9C9, 0xBCBB, 0xBFDB, 0xC326, 0xC69A, 0xCA35, 0xCDF4, 0xD1D4, 0xD5D4, 0xD9F0, 0xDE26, 0xE273,
        0xE6D3, 0xEB45, 0xEFC4, 0xF44F, 0xF8E1, 0xFD78, 0x0210, 0x06A7, 0x0B3A, 0x0FC6, 0x1446, 0x18B9, 0x1D1C, 0x216B, 0x25A3, 0x29C2,
        0x2DC5, 0x31A9, 0x356B, 0x390A, 0x3C82, 0x3FD1, 0x42F5, 0x45EC, 0x48B4, 0x4B4B, 0x4DAF, 0x4FDF, 0x51D9, 0x539C, 0x5527, 0x5678,
        0x578F, 0x586B, 0x590B, 0x5970, 0x5998, 0x5983, 0x5933, 0x58A6, 0x57DD, 0x56DA, 0x559B, 0x5423, 0x5273, 0x508B, 0x4E6C, 0x4C19,
        0x4992, 0x46DA, 0x43F2, 0x40DC, 0x3D9B, 0x3A30, 0x369E, 0x32E7, 0x2F0D, 0x2B14, 0x26FE, 0x22CE, 0x1E86, 0x1A2A, 0x15BC, 0x113F,
        0x0CB7, 0x0826, 0x0390, 0xFEF8, 0xFA60, 0xF5CC, 0xF13F, 0xECBB, 0xE845, 0xE3DE, 0xDF8B, 0xDB4D, 0xD729, 0xD31F, 0xCF34, 0xCB6A,
        0xC7C3, 0xC442, 0xC0EA, 0xBDBC, 0xBABA, 0xB7E7, 0xB545, 0xB2D6, 0xB09A, 0xAE93, 0xACC4, 0xAB2D, 0xA9CF, 0xA8AA, 0xA7C1, 0xA714,
        0xA6A2, 0xA66C, 0xA673, 0xA6B6, 0xA735, 0xA7F0, 0xA8E7, 0xAA18, 0xAB83, 0xAD27, 0xAF03, 0xB115, 0xB35D, 0xB5D8, 0xB886, 0xBB63,
        0xBE6F, 0xC1A6, 0xC508, 0xC892, 0xCC41, 0xD013, 0xD405, 0xD814, 0xDC3F, 0xE082, 0xE4DA, 0xE944, 0xEDBE, 0xF244, 0xF6D3, 0xFB68,
        0x0000, 0x0498, 0x092D, 0x0DBC, 0x1242, 0x16BC, 0x1B26, 0x1F7E, 0x23C1, 0x27EC, 0x2BFB, 0x2FED, 0x33BF, 0x376E, 0x3AF8, 0x3E5A,
        0x4191, 0x449D, 0x477A, 0x4A28, 0x4CA3, 0x4EEB, 0x50FD, 0x52D9, 0x547D, 0x55E8, 0x5719, 0x5810, 0x58CB, 0x594A, 0x598D, 0x5994,
        0x595E, 0x58EC, 0x583F, 0x5756, 0x5631, 0x54D3, 0x533C, 0x516D, 0x4F66, 0x4D2A, 0x4ABB, 0x4819, 0x4546, 0x4244, 0x3F16, 0x3BBE,
        0x383D, 0x3496, 0x30CC, 0x2CE1, 0x28D7, 0x24B3, 0x2075, 0x1C22, 0x17BB, 0x1345, 0x0EC1, 0x0A34, 0x05A0, 0x0108, 0xFC70, 0xF7DA,
        0xF349, 0xEEC1, 0xEA44, 0xE5D6, 0xE17A, 0xDD32, 0xD902, 0xD4EC, 0xD0F3, 0xCD19, 0xC962, 0xC5D0, 0xC265, 0xBF24, 0xBC0E, 0xB926,
        0xB66E, 0xB3E7, 0xB194, 0xAF75, 0xAD8D, 0xABDD, 0xAA65, 0xA926, 0xA823, 0xA75A, 0xA6CD, 0xA67D, 0xA668, 0xA690, 0xA6F5, 0xA795,
        0xA871, 0xA988, 0xAAD9, 0xAC64, 0xAE27, 0xB021, 0xB251, 0xB4B5, 0xB74C, 0xBA14, 0xBD0B, 0xC02F, 0xC37E, 0xC6F6, 0xCA95, 0xCE57,
        0xD23B, 0xD63E, 0xDA5D, 0xDE95, 0xE2E4, 0xE747, 0xEBBA, 0xF03A, 0xF4C6, 0xF959, 0xFDF0, 0x0288, 0x071F, 0x0BB1, 0x103C, 0x14BB,
        0x192D, 0x1D8D, 0x21DA, 0x2610, 0x2A2C, 0x2E2C, 0x320C, 0x35CB, 0x3966, 0x3CDA, 0x4025, 0x4345, 0x4637, 0x48FA, 0x4B8C, 0x4DEB,
        0x5015, 0x520A, 0x53C7, 0x554C, 0x5697, 0x57A8, 0x587E, 0x5918, 0x5976, 0x5998, 0x597E, 0x5927, 0x5894, 0x57C6, 0x56BC, 0x5578,
        0x53FA, 0x5243, 0x5056, 0x4E32, 0x4BD9, 0x494D, 0x4690, 0x43A3, 0x4089, 0x3D43, 0x39D4, 0x363E, 0x3284, 0x2EA7, 0x2AAB, 0x2692,
        0x225F, 0x1E15, 0x19B7, 0x1547, 0x10C9, 0x0C40, 0x07AF, 0x0318, 0xFE80, 0xF9E8, 0xF555, 0xF0C8, 0xEC46, 0xE7D1, 0xE36D, 0xDF1B,
        0xDAE0, 0xD6BE, 0xD2B7, 0xCED0, 0xCB09, 0xC766, 0xC3E9, 0xC095, 0xBD6B, 0xBA6E, 0xB7A0, 0xB503, 0xB299, 0xB062, 0xAE62, 0xAC98,
        0xAB06, 0xA9AE, 0xA890, 0xA7AD, 0xA705, 0xA699, 0xA66A, 0xA677, 0xA6C0, 0xA746, 0xA807, 0xA903, 0xAA3B, 0xABAB, 0xAD55, 0xAF37,
        0xB14F, 0xB39C, 0xB61C, 0xB8CE, 0xBBB0, 0xBEC1, 0xC1FD, 0xC563, 0xC8F0, 0xCCA3, 0xD078, 0xD46D, 0xD880, 0xDCAD, 0xE0F2, 0xE54C,
        0xE9B8, 0xEE33, 0xF2BA, 0xF74A, 0xFBE0, 0x0078, 0x0510, 0x09A5, 0x0E33, 0x12B8, 0x1730, 0x1B99, 0x1FEE, 0x242F, 0x2857, 0x2C64,
        0x3053, 0x3421, 0x37CC, 0x3B52, 0x3EB0, 0x41E3, 0x44EA, 0x47C3, 0x4A6B, 0x4CE1, 0x4F23, 0x5130, 0x5306, 0x54A4, 0x560A, 0x5735,
        0x5825, 0x58DA, 0x5954, 0x5991, 0x5991, 0x5955, 0x58DD, 0x582A, 0x573A, 0x5610, 0x54AC, 0x530F, 0x513A, 0x4F2E, 0x4CED, 0x4A78,
        0x47D1, 0x44F9, 0x41F3, 0x3EC1, 0x3B64, 0x37DF, 0x3435, 0x3067, 0x2C79, 0x286C, 0x2445, 0x2005, 0x1BAF, 0x1747, 0x12CF, 0x0E4B,
        0x09BD, 0x0528, 0x0090, 0xFBF8, 0xF762, 0xF2D2, 0xEE4B, 0xE9D0, 0xE563, 0xE109, 0xDCC3, 0xD896, 0xD482, 0xD08D, 0xCCB7, 0xC903,
        0xC575, 0xC20E, 0xBED1, 0xBBC0, 0xB8DD, 0xB62A, 0xB3A8, 0xB15A, 0xAF41, 0xAD5F, 0xABB4, 0xAA42, 0xA909, 0xA80B, 0xA749, 0xA6C2,
        0xA678, 0xA66A, 0xA698, 0xA702, 0xA7A9, 0xA88B, 0xA9A8, 0xAAFF, 0xAC8F, 0xAE58, 0xB057, 0xB28D, 0xB4F6, 0xB792, 0xBA5F, 0xBD5B,
        0xC084, 0xC3D7, 0xC753, 0xCAF6, 0xCEBC, 0xD2A3, 0xD6A9, 0xDACA, 0xDF05, 0xE356, 0xE7BA, 0xEC2F, 0xF0B1, 0xF53D, 0xF9D0, 0xFE68,
        0x0300, 0x0797, 0x0C28, 0x10B2, 0x1530, 0x19A0, 0x1DFF, 0x2249, 0x267C, 0x2A96, 0x2E92, 0x3270, 0x362B, 0x39C2, 0x3D32, 0x4078,
        0x4394, 0x4681, 0x493F, 0x4BCC, 0x4E26, 0x504B, 0x523A, 0x53F1, 0x5570, 0x56B6, 0x57C1, 0x5890, 0x5925, 0x597D, 0x5998, 0x5978,
        0x591B, 0x5882, 0x57AD, 0x569D, 0x5553, 0x53D0, 0x5214, 0x5020, 0x4DF7, 0x4B99, 0x4908, 0x4646, 0x4354, 0x4036, 0x3CEC, 0x3978,
        0x35DE, 0x3220, 0x2E40, 0x2A41, 0x2626, 0x21F0, 0x1DA4, 0x1944, 0x14D3, 0x1053, 0x0BC9, 0x0737, 0x02A0, 0xFE08, 0xF971, 0xF4DE,
        0xF052, 0xEBD1, 0xE75E, 0xE2FB, 0xDEAC, 0xDA73, 0xD653, 0xD250, 0xCE6B, 0xCAA8, 0xC709, 0xC390, 0xC040, 0xBD1B, 0xBA23, 0xB75A,
        0xB4C2, 0xB25D, 0xB02C, 0xAE30, 0xAC6C, 0xAAE1, 0xA98E, 0xA876, 0xA799, 0xA6F7, 0xA692, 0xA669, 0xA67C, 0xA6CB, 0xA757, 0xA81E,
        0xA921, 0xAA5E, 0xABD4, 0xAD84, 0xAF6B, 0xB188, 0xB3DB, 0xB660, 0xB917, 0xBBFE, 0xBF13, 0xC254, 0xC5BE, 0xC94F, 0xCD06, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC619, 0xC9AF, 0xCD69, 0xD144, 0xD540, 0xD958, 0xDD8B, 0xE1D4, 0xE632, 0xEAA1, 0xEF1F, 0xF3A8, 0xF839, 0xFCD0, 0x0168,
        0x0600, 0x0A93, 0x0F20, 0x13A2, 0x1818, 0x1C7D, 0x20CE, 0x250A, 0x292D, 0x2D34, 0x311C, 0x34E4, 0x3887, 0x3C05, 0x3F5A, 0x4285,
        0x4583, 0x4851, 0x4AF0, 0x4D5B, 0x4F93, 0x5194, 0x535F, 0x54F2, 0x564B, 0x576B, 0x584F, 0x58F8, 0x5965, 0x5996, 0x598A, 0x5942,
        0x58BE, 0x57FE, 0x5702, 0x55CC, 0x545D, 0x52B4, 0x50D4, 0x4EBD, 0x4C71, 0x49F2, 0x4740, 0x445F, 0x4150, 0x3E14, 0x3AAF, 0x3723,
        0x3371, 0x2F9C, 0x2BA8, 0x2795, 0x2369, 0x1F24, 0x1ACB, 0x165F, 0x11E4, 0x0D5D, 0x08CE, 0x0438, 0xFFA0, 0xFB08, 0xF673, 0xF1E5,
        0xED60, 0xE8E7, 0xE47E, 0xE028, 0xDBE7, 0xD7BF, 0xD3B1, 0xCFC2, 0xCBF2, 0xC846, 0xC4C0, 0xC162, 0xBE2D, 0xBB25, 0xB84C, 0xB5A3,
        0xB32B, 0xB0E8, 0xAEDA, 0xAD03, 0xAB63, 0xA9FD, 0xA8D1, 0xA7DF, 0xA729, 0xA6AE, 0xA670, 0xA66E, 0xA6A9, 0xA71F, 0xA7D2, 0xA8C0,
        0xA9E9, 0xAB4C, 0xACE8, 0xAEBC, 0xB0C6, 0xB307, 0xB57A, 0xB821, 0xBAF7, 0xBDFC, 0xC12E, 0xC48A, 0xC80E, 0xCBB8, 0xCF85, 0xD373,
        0xD77E, 0xDBA5, 0xDFE5, 0xE43A, 0xE8A2, 0xED19, 0xF19E, 0xF62C, 0xFAC0, 0xFF58, 0x03F0, 0x0886, 0x0D16, 0x119E, 0x1619, 0x1A86,
        0x1EE1, 0x2326, 0x2755, 0x2B69, 0x2F5F, 0x3336, 0x36EA, 0x3A79, 0x3DE0, 0x411E, 0x4430, 0x4715, 0x49C9, 0x4C4B, 0x4E9A, 0x50B4,
        0x5298, 0x5444, 0x55B8, 0x56F1, 0x57F0, 0x58B4, 0x593B, 0x5987, 0x5997, 0x596A, 0x5900, 0x585B, 0x577A, 0x565F, 0x5509, 0x537A,
        0x51B2, 0x4FB4, 0x4D7F, 0x4B17, 0x487C, 0x45B0, 0x42B5, 0x3F8D, 0x3C3B, 0x38BF, 0x351E, 0x3159, 0x2D72, 0x296D, 0x254C, 0x2111,
        0x1CC1, 0x185D, 0x13E9, 0x0F67, 0x0ADB, 0x0647, 0x01B0, 0xFD18, 0xF881, 0xF3EF, 0xEF66, 0xEAE7, 0xE677, 0xE218, 0xDDCD, 0xD999,
        0xD57F, 0xD182, 0xCDA4, 0xC9E8, 0xC650, 0xC2E0, 0xBF98, 0xBC7C, 0xB98D, 0xB6CE, 0xB441, 0xB1E6, 0xAFC0, 0xADD0, 0xAC17, 0xAA97,
        0xA950, 0xA844, 0xA773, 0xA6DE, 0xA685, 0xA668, 0xA687, 0xA6E3, 0xA77B, 0xA84E, 0xA95C, 0xAAA5, 0xAC28, 0xADE3, 0xAFD5, 0xB1FD,
        0xB45A, 0xB6EA, 0xB9AB, 0xBC9C, 0xBFBA, 0xC303, 0xC675, 0xCA0E, 0xCDCC, 0xD1AB, 0xD5AA, 0xD9C5, 0xDDFA, 0xE245, 0xE6A5, 0xEB16,
        0xEF95, 0xF41F, 0xF8B1, 0xFD48, 0x01E0, 0x0677, 0x0B0B, 0x0F96, 0x1418, 0x188B, 0x1CEE, 0x213E, 0x2577, 0x2997, 0x2D9B, 0x3181,
        0x3544, 0x38E4, 0x3C5E, 0x3FAF, 0x42D5, 0x45CE, 0x4898, 0x4B31, 0x4D97, 0x4FCA, 0x51C6, 0x538B, 0x5518, 0x566B, 0x5785, 0x5863,
        0x5906, 0x596D, 0x5997, 0x5985, 0x5937, 0x58AD, 0x57E7, 0x56E5, 0x55A9, 0x5434, 0x5286, 0x50A0, 0x4E83, 0x4C32, 0x49AD, 0x46F7,
        0x4411, 0x40FD, 0x3DBE, 0x3A54, 0x36C4, 0x330E, 0x2F36, 0x2B3E, 0x272A, 0x22FA, 0x1EB3, 0x1A58, 0x15EB, 0x116E, 0x0CE7, 0x0856,
        0x03C0, 0xFF28, 0xFA90, 0xF5FC, 0xF16E, 0xECEA, 0xE873, 0xE40C, 0xDFB8, 0xDB79, 0xD753, 0xD349, 0xCF5C, 0xCB91, 0xC7E9, 0xC466,
        0xC10C, 0xBDDC, 0xBAD9, 0xB804, 0xB560, 0xB2EE, 0xB0B0, 0xAEA8, 0xACD6, 0xAB3C, 0xA9DC, 0xA8B5, 0xA7CA, 0xA719, 0xA6A5, 0xA66D,
        0xA671, 0xA6B2, 0xA72F, 0xA7E8, 0xA8DC, 0xAA0B, 0xAB73, 0xAD15, 0xAEEF, 0xB0FF, 0xB344, 0xB5BD, 0xB869, 0xBB44, 0xBE4E, 0xC184,
        0xC4E4, 0xC86C, 0xCC1A, 0xCFEA, 0xD3DB, 0xD7E9, 0xDC13, 0xE055, 0xE4AC, 0xE916, 0xED8F, 0xF214, 0xF6A3, 0xFB38, 0xFFD0, 0x0468,
        0x08FD, 0x0D8D, 0x1213, 0x168D, 0x1AF8, 0x1F51, 0x2395, 0x27C1, 0x2BD1, 0x2FC5, 0x3398, 0x3748, 0x3AD4, 0x3E37, 0x4171, 0x447E,
        0x475D, 0x4A0D, 0x4C8A, 0x4ED4, 0x50E8, 0x52C6, 0x546D, 0x55DA, 0x570E, 0x5807, 0x58C4, 0x5946, 0x598C, 0x5995, 0x5962, 0x58F2,
        0x5847, 0x5760, 0x563E, 0x54E3, 0x534E, 0x5181, 0x4F7C, 0x4D43, 0x4AD5, 0x4835, 0x4564, 0x4265, 0x3F38, 0x3BE1, 0x3862, 0x34BD,
        0x30F4, 0x2D0A, 0x2902, 0x24DE, 0x20A2, 0x1C4F, 0x17E9, 0x1374, 0x0EF1, 0x0A64, 0x05D0, 0x0138, 0xFCA0, 0xF80A, 0xF378, 0xEEF0,
        0xEA73, 0xE604, 0xE1A7, 0xDD5E, 0xD92D, 0xD516, 0xD11C, 0xCD41, 0xC988, 0xC5F5, 0xC288, 0xBF45, 0xBC2D, 0xB944, 0xB689, 0xB401,
        0xB1AB, 0xAF8B, 0xADA0, 0xABED, 0xAA73, 0xA932, 0xA82C, 0xA761, 0xA6D2, 0xA67F, 0xA668, 0xA68E, 0xA6EF, 0xA78D, 0xA867, 0xA97B,
        0xAACA, 0xAC52, 0xAE13, 0xB00B, 0xB239, 0xB49B, 0xB730, 0xB9F6, 0xBCEB, 0xC00E, 0xC35B, 0xC6D1, 0xCA6E, 0xCE2F, 0xD212, 0xD614,
        0xDA31, 0xDE69, 0xE2B7, 0xE718, 0xEB8B, 0xF00B, 0xF496, 0xF929, 0xFDC0, 0x0258, 0x06EF, 0x0B82, 0x100D, 0x148D, 0x18FF, 0x1D60,
        0x21AD, 0x25E4, 0x2A02, 0x2E03, 0x31E5, 0x35A5, 0x3941, 0x3CB7, 0x4003, 0x4325, 0x4619, 0x48DE, 0x4B72, 0x4DD3, 0x5000, 0x51F7,
        0x53B6, 0x553D, 0x568B, 0x579E, 0x5876, 0x5913, 0x5974, 0x5998, 0x5980, 0x592C, 0x589B, 0x57CF, 0x56C8, 0x5586, 0x540B, 0x5256,
        0x506B, 0x4E49, 0x4BF3, 0x4969, 0x46AE, 0x43C3, 0x40AA, 0x3D66, 0x39F9, 0x3664, 0x32AB, 0x2ED0, 0x2AD5, 0x26BD, 0x228C, 0x1E42,
        0x19E5, 0x1576, 0x10F9, 0x0C70, 0x07DF, 0x0348, 0xFEB0, 0xFA18, 0xF584, 0xF0F8, 0xEC75, 0xE7FF, 0xE39A, 0xDF48, 0xDB0C, 0xD6E9,
        0xD2E1, 0xCEF8, 0xCB30, 0xC78B, 0xC40D, 0xC0B7, 0xBD8B, 0xBA8D, 0xB7BD, 0xB51E, 0xB2B1, 0xB078, 0xAE75, 0xACA9, 0xAB16, 0xA9BB,
        0xA89B, 0xA7B5, 0xA70B, 0xA69D, 0xA66B, 0xA675, 0xA6BC, 0xA73F, 0xA7FE, 0xA8F8, 0xAA2D, 0xAB9B, 0xAD43, 0xAF22, 0xB138, 0xB383,
        0xB601, 0xB8B1, 0xBB91, 0xBEA0, 0xC1DA, 0xC53F, 0xC8CB, 0xCC7C, 0xD050, 0xD444, 0xD855, 0xDC81, 0xE0C5, 0xE51F, 0xE98A, 0xEE04,
        0xF28B, 0xF71A, 0xFBB0, 0x0048, 0x04E0, 0x0975, 0x0E04, 0x1289, 0x1702, 0x1B6B, 0x1FC2, 0x2403, 0x282C, 0x2C3A, 0x302A, 0x33FA,
        0x37A7, 0x3B2E, 0x3E8D, 0x41C2, 0x44CB, 0x47A6, 0x4A50, 0x4CC8, 0x4F0D, 0x511C, 0x52F4, 0x5495, 0x55FC, 0x572A, 0x581D, 0x58D4,
        0x5950, 0x598F, 0x5992, 0x5959, 0x58E4, 0x5832, 0x5745, 0x561E, 0x54BC, 0x5321, 0x514E, 0x4F45, 0x4D06, 0x4A93, 0x47EE, 0x4518,
        0x4214, 0x3EE3, 0x3B88, 0x3805, 0x345C, 0x308F, 0x2CA2, 0x2897, 0x2471, 0x2032, 0x1BDD, 0x1776, 0x12FE, 0x0E7A, 0x09EC, 0x0558,
        0x00C0, 0xFC28, 0xF792, 0xF302, 0xEE7A, 0xE9FE, 0xE591, 0xE136, 0xDCF0, 0xD8C1, 0xD4AC, 0xD0B5, 0xCCDE, 0xC929, 0xC599, 0xC231,
        0xBEF2, 0xBBDF, 0xB8FA, 0xB645, 0xB3C1, 0xB171, 0xAF56, 0xAD71, 0xABC4, 0xAA4F, 0xA915, 0xA815, 0xA750, 0xA6C7, 0xA67A, 0xA669,
        0xA695, 0xA6FD, 0xA7A1, 0xA880, 0xA99B, 0xAAF0, 0xAC7E, 0xAE44, 0xB041, 0xB275, 0xB4DC, 0xB776, 0xBA41, 0xBD3B, 0xC062, 0xC3B4,
        0xC72E, 0xCACF, 0xCE93, 0xD279, 0xD67E, 0xDA9E, 0xDED8, 0xE328, 0xE78C, 0xEC00, 0xF081, 0xF50D, 0xF9A1, 0xFE38, 0x02D0, 0x0767,
        0x0BF9, 0x1083, 0x1501, 0x1972, 0x1DD1, 0x221D, 0x2651, 0x2A6C, 0x2E69, 0x3248, 0x3605, 0x399D, 0x3D0F, 0x4057, 0x4374, 0x4664,
        0x4924, 0x4BB3, 0x4E0E, 0x5036, 0x5227, 0x53E1, 0x5562, 0x56AA, 0x57B7, 0x5889, 0x5920, 0x597A, 0x5998, 0x597A, 0x5920, 0x5889,
        0x57B7, 0x56AA, 0x5562, 0x53E1, 0x5227, 0x5036, 0x4E0E, 0x4BB3, 0x4924, 0x4664, 0x4374, 0x4057, 0x3D0F, 0x399D, 0x3605, 0x3248,
        0x2E69, 0x2A6C, 0x2651, 0x221D, 0x1DD1, 0x1972, 0x1501, 0x1083, 0x0BF9, 0x0767, 0x02D0, 0xFE38, 0xF9A1, 0xF50D, 0xF081, 0xEC00,
        0xE78C, 0xE328, 0xDED8, 0xDA9E, 0xD67E, 0xD279, 0xCE93, 0xCACF, 0xC72E, 0xC3B4, 0xC062, 0xBD3B, 0xBA41, 0xB776, 0xB4DC, 0xB275,
        0xB041, 0xAE44, 0xAC7E, 0xAAF0, 0xA99B, 0xA880, 0xA7A1, 0xA6FD, 0xA695, 0xA669, 0xA67A, 0xA6C7, 0xA750, 0xA815, 0xA915, 0xAA4F,
        0xABC4, 0xAD71, 0xAF56, 0xB171, 0xB3C1, 0xB645, 0xB8FA, 0xBBDF, 0xBEF2, 0xC231, 0xC599, 0xC929, 0xCCDE, 0xD0B5, 0xD4AC, 0xD8C1,
        0xDCF0, 0xE136, 0xE591, 0xE9FE, 0xEE7A, 0xF302, 0xF792, 0xFC28, 0x00C0, 0x0558, 0x09EC, 0x0E7A, 0x12FE, 0x1776, 0x1BDD, 0x2032,
        0x2471, 0x2897, 0x2CA2, 0x308F, 0x345C, 0x3805, 0x3B88, 0x3EE3, 0x4214, 0x4518, 0x47EE, 0x4A93, 0x4D06, 0x4F45, 0x514E, 0x5321,
        0x54BC, 0x561E, 0x5745, 0x5832, 0x58E4, 0x5959, 0x5992, 0x598F, 0x5950, 0x58D4, 0x581D, 0x572A, 0x55FC, 0x5495, 0x52F4, 0x511C,
        0x4F0D, 0x4CC8, 0x4A50, 0x47A6, 0x44CB, 0x41C2, 0x3E8D, 0x3B2E, 0x37A7, 0x33FA, 0x302A, 0x2C3A, 0x282C, 0x2403, 0x1FC2, 0x1B6B,
        0x1702, 0x1289, 0x0E04, 0x0975, 0x04E0, 0x0048, 0xFBB0, 0xF71A, 0xF28B, 0xEE04, 0xE98A, 0xE51F, 0xE0C5, 0xDC81, 0xD855, 0xD444,
        0xD050, 0xCC7C, 0xC8CB, 0xC53F, 0xC1DA, 0xBEA0, 0xBB91, 0xB8B1, 0xB601, 0xB383, 0xB138, 0xAF22, 0xAD43, 0xAB9B, 0xAA2D, 0xA8F8,
        0xA7FE, 0xA73F, 0xA6BC, 0xA675, 0xA66B, 0xA69D, 0xA70B, 0xA7B5, 0xA89B, 0xA9BB, 0xAB16, 0xACA9, 0xAE75, 0xB078, 0xB2B1, 0xB51E,
        0xB7BD, 0xBA8D, 0xBD8B, 0xC0B7, 0xC40D, 0xC78B, 0xCB30, 0xCEF8, 0xD2E1, 0xD6E9, 0xDB0C, 0xDF48, 0xE39A, 0xE7FF, 0xEC75, 0xF0F8,
        0xF584, 0xFA18, 0xFEB0, 0x0348, 0x07DF, 0x0C70, 0x10F9, 0x1576, 0x19E5, 0x1E42, 0x228C, 0x26BD, 0x2AD5, 0x2ED0, 0x32AB, 0x3664,
        0x39F9, 0x3D66, 0x40AA, 0x43C3, 0x46AE, 0x4969, 0x4BF3, 0x4E49, 0x506B, 0x5256, 0x540B, 0x5586, 0x56C8, 0x57CF, 0x589B, 0x592C,
        0x5980, 0x5998, 0x5974, 0x5913, 0x5876, 0x579E, 0x568B, 0x553D, 0x53B6, 0x51F7, 0x5000, 0x4DD3, 0x4B72, 0x48DE, 0x4619, 0x4325,
        0x4003, 0x3CB7, 0x3941, 0x35A5, 0x31E5, 0x2E03, 0x2A02, 0x25E4, 0x21AD, 0x1D60, 0x18FF, 0x148D, 0x100D, 0x0B82, 0x06EF, 0x0258,
        0xFDC0, 0xF929, 0xF496, 0xF00B, 0xEB8B, 0xE718, 0xE2B7, 0xDE69, 0xDA31, 0xD614, 0xD212, 0xCE2F, 0xCA6E, 0xC6D1, 0xC35B, 0xC00E,
        0xBCEB, 0xB9F6, 0xB730, 0xB49B, 0xB239, 0xB00B, 0xAE13, 0xAC52, 0xAACA, 0xA97B, 0xA867, 0xA78D, 0xA6EF, 0xA68E, 0xA668, 0xA67F,
        0xA6D2, 0xA761, 0xA82C, 0xA932, 0xAA73, 0xABED, 0xADA0, 0xAF8B, 0xB1AB, 0xB401, 0xB689, 0xB944, 0xBC2D, 0xBF45, 0xC288, 0xC5F5,
        0xC988, 0xCD41, 0xD11C, 0xD516, 0xD92D, 0xDD5E, 0xE1A7, 0xE604, 0xEA73, 0xEEF0, 0xF378, 0xF80A, 0xFCA0, 0x0138, 0x05D0, 0x0A64,
        0x0EF1, 0x1374, 0x17E9, 0x1C4F, 0x20A2, 0x24DE, 0x2902, 0x2D0A, 0x30F4, 0x34BD, 0x3862, 0x3BE1, 0x3F38, 0x4265, 0x4564, 0x4835,
        0x4AD5, 0x4D43, 0x4F7C, 0x5181, 0x534E, 0x54E3, 0x563E, 0x5760, 0x5847, 0x58F2, 0x5962, 0x5995, 0x598C, 0x5946, 0x58C4, 0x5807,
        0x570E, 0x55DA, 0x546D, 0x52C6, 0x50E8, 0x4ED4, 0x4C8A, 0x4A0D, 0x475D, 0x447E, 0x4171, 0x3E37, 0x3AD4, 0x3748, 0x3398, 0x2FC5,
        0x2BD1, 0x27C1, 0x2395, 0x1F51, 0x1AF8, 0x168D, 0x1213, 0x0D8D, 0x08FD, 0x0468, 0xFFD0, 0xFB38, 0xF6A3, 0xF214, 0xED8F, 0xE916,
        0xE4AC, 0xE055, 0xDC13, 0xD7E9, 0xD3DB, 0xCFEA, 0xCC1A, 0xC86C, 0xC4E4, 0xC184, 0xBE4E, 0xBB44, 0xB869, 0xB5BD, 0xB344, 0xB0FF,
        0xAEEF, 0xAD57, 0xABFB, 0xAAD9, 0xA9F3, 0xA948, 0xA8D9, 0xA8A5, 0xA8AD, 0xA8F0, 0xA96E, 0xAA25, 0xAB15, 0xAC3D, 0xAD9B, 0xAF30,
        0xB0F8, 0xB2F2, 0xB51E, 0xB778, 0xBA00, 0xBCB3, 0xBF8E, 0xC291, 0xC5B8, 0xC901, 0xCC6A, 0xCFF0, 0xD390, 0xD749, 0xDB16, 0xDEF6,
        0xE2E6, 0xE6E3, 0xEAEA, 0xEEF8, 0xF30B, 0xF71F, 0xFB33, 0xFF42, 0x034A, 0x074A, 0x0B3E, 0x0F23, 0x12F7, 0x16B8, 0x1A63, 0x1DF5,
        0x216D, 0x24C8, 0x2804, 0x2B1F, 0x2E18, 0x30EC, 0x339A, 0x3620, 0x387D, 0x3AAF, 0x3CB6, 0x3E8F, 0x403C, 0x41B9, 0x4308, 0x4426,
        0x4515, 0x45D3, 0x4660, 0x46BC, 0x46E8, 0x46E4, 0x46B0, 0x464C, 0x45BA, 0x44F9, 0x440B, 0x42F0, 0x41AB, 0x403B, 0x3EA3, 0x3CE3,
        0x3AFD, 0x38F3, 0x36C6, 0x3479, 0x320C, 0x2F82, 0x2CDD, 0x2A1E, 0x2749, 0x245E, 0x2160, 0x1E52, 0x1B35, 0x180C, 0x14D9, 0x119E,
        0x0E5D, 0x0B1A, 0x07D5, 0x0492, 0x0152, 0xFE18, 0xFAE6, 0xF7BD, 0xF4A1, 0xF192, 0xEE94, 0xEBA7, 0xE8CF, 0xE60C, 0xE360, 0xE0CD,
        0xDE55, 0xDBF9, 0xD9BA, 0xD799, 0xD599, 0xD3BA, 0xD1FC, 0xD062, 0xCEEB, 0xCD99, 0xCC6B, 0xCB63, 0xCA81, 0xC9C6, 0xC930, 0xC8C2,
        0xC879, 0xC857, 0xC85B, 0xC885, 0xC8D4, 0xC948, 0xC9E0, 0xCA9B, 0xCB79, 0xCC79, 0xCD99, 0xCEDA, 0xD038, 0xD1B5, 0xD34D, 0xD500,
        0xD6CC, 0xD8B0, 0xDAAB, 0xDCBB, 0xDEDD, 0xE112, 0xE356, 0xE5A8, 0xE807, 0xEA71, 0xECE3, 0xEF5D, 0xF1DC, 0xF460, 0xF6E5, 0xF96A,
        0xFBED, 0xFE6E, 0x00E8, 0x035D, 0x05CA, 0x082D, 0x0A84, 0x0CCF, 0x0F0B, 0x1137, 0x1353, 0x155C, 0x1751, 0x1932, 0x1AFD, 0x1CB1,
        0x1E4D, 0x1FD0, 0x213A, 0x228A, 0x23BF, 0x24D9, 0x25D6, 0x26B7, 0x277C, 0x2824, 0x28AE, 0x291C, 0x296C, 0x299F, 0x29B6, 0x29AF,
        0x298D, 0x294E, 0x28F4, 0x287F, 0x27EF, 0x2746, 0x2683, 0x25A9, 0x24B7, 0x23AF, 0x2291, 0x215E, 0x2018, 0x1EC0, 0x1D57, 0x1BDD,
        0x1A55, 0x18BE, 0x171C, 0x156E, 0x13B7, 0x11F6, 0x102F, 0x0E62, 0x0C90, 0x0ABA, 0x08E3, 0x070B, 0x0534, 0x035E, 0x018C, 0xFFBF,
        0xFDF6, 0xFC35, 0xFA7B, 0xF8CA, 0xF723, 0xF587, 0xF3F8, 0xF275, 0xF100, 0xEF9B, 0xEE44, 0xECFE, 0xEBC9, 0xEAA6, 0xE995, 0xE897,
        0xE7AC, 0xE6D4, 0xE611, 0xE562, 0xE4C7, 0xE441, 0xE3D0, 0xE373, 0xE32B, 0xE2F9, 0xE2DA, 0xE2D0, 0xE2DB, 0xE2F9, 0xE32B, 0xE370,
        0xE3C8, 0xE432, 0xE4AE, 0xE53B, 0xE5D8, 0xE685, 0xE742, 0xE80D, 0xE8E6, 0xE9CB, 0xEABD, 0xEBBA, 0xECC2, 0xEDD3, 0xEEED, 0xF00E,
        0xF137, 0xF265, 0xF399, 0xF4D0, 0xF60B, 0xF748, 0xF886, 0xF9C5, 0xFB04, 0xFC41, 0xFD7C, 0xFEB3, 0xFFE8, 0x0116, 0x0240, 0x0364,
        0x0481, 0x0596, 0x06A4, 0x07A8, 0x08A3, 0x0994, 0x0A7A, 0x0B55, 0x0C25, 0x0CE9, 0x0DA1, 0x0E4D, 0x0EEB, 0x0F7D, 0x1001, 0x1078,
        0x10E1, 0x113D, 0x118B, 0x11CB, 0x11FE, 0x1224, 0x123C, 0x1246, 0x1244, 0x1235, 0x121A, 0x11F2, 0x11BE, 0x117F, 0x1135, 0x10E0,
        0x1081, 0x1017, 0x0FA5, 0x0F29, 0x0EA5, 0x0E1A, 0x0D87, 0x0CED, 0x0C4D, 0x0BA8, 0x0AFD, 0x0A4F, 0x099C, 0x08E6, 0x082E, 0x0773,
        0x06B7, 0x05FA, 0x053D, 0x0480, 0x03C4, 0x0309, 0x0250, 0x0199, 0x00E5, 0x0035, 0xFF89, 0xFEE0, 0xFE3C, 0xFD9D, 0xFD04, 0xFC70,
        0xFBE2, 0xFB5A, 0xFAD9, 0xFA5F, 0xF9EC, 0xF980, 0xF91B, 0xF8BE, 0xF868, 0xF81A, 0xF7D4, 0xF796, 0xF75F, 0xF731, 0xF709, 0xF6EA,
        0xF6D2, 0xF6C2, 0xF6B9, 0xF6B7, 0xF6BC, 0xF6C7, 0xF6DA, 0xF6F3, 0xF711, 0xF736, 0xF760, 0xF790, 0xF7C4, 0xF7FE, 0xF83B, 0xF87D,
        0xF8C2, 0xF90B, 0xF957, 0xF9A6, 0xF9F7, 0xFA4A, 0xFA9F, 0xFAF5, 0xFB4C, 0xFBA4, 0xFBFC, 0xFC55, 0xFCAD, 0xFD05, 0xFD5C, 0xFDB2,
        0xFE07, 0xFE5A, 0xFEAC, 0xFEFB, 0xFF48, 0xFF93, 0xFFDB, 0x0020, 0x0062, 0x00A1, 0x00DE, 0x0116, 0x014C, 0x017E, 0x01AC, 0x01D7,
        0x01FE, 0x0222, 0x0242, 0x025F, 0x0278, 0x028D, 0x029F, 0x02AD, 0x02B9, 0x02C1, 0x02C5, 0x02C7, 0x02C6, 0x02C2, 0x02BC, 0x02B3,
        0x02A8, 0x029B, 0x028B, 0x027A, 0x0267, 0x0253, 0x023D, 0x0226, 0x020F, 0x01F6, 0x01DD, 0x01C3, 0x01A9, 0x018E, 0x0174, 0x015A,
        0x0140, 0x0126, 0x010D, 0x00F5, 0x00DD, 0x00C7, 0x00B1, 0x009C, 0x0088, 0x0076, 0x0065, 0x0054, 0x0046, 0x0038, 0x002C, 0x0021,
        0x0018, 0x0010, 0x0009, 0x0003, 0xFFFF, 0xFFFC, 0xFFFA, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFC, 0xFFFE, 0xFFFF, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFC, 0xFFFB, 0xFFF9, 0xFFF7, 0xFFF5, 0xFFF3, 0xFFF0, 0xFFED, 0xFFEA,
        0xFFE7, 0xFFE4, 0xFFE0, 0xFFDC, 0xFFD9, 0xFFD5, 0xFFD1, 0xFFCD, 0xFFC9, 0xFFC6, 0xFFC2, 0xFFBF, 0xFFBC, 0xFFB9, 0xFFB6, 0xFFB4,
        0xFFB2, 0xFFB1, 0xFFB0, 0xFFB0, 0xFFB0, 0xFFB2, 0xFFB3, 0xFFB6, 0xFFB9, 0xFFBE, 0xFFC3, 0xFFC9, 0xFFD0, 0xFFD7, 0xFFE0, 0xFFEA,
        0xFFF5, 0x0000, 0x000D, 0x001A, 0x0029, 0x0039, 0x004A, 0x005B, 0x006E, 0x0081, 0x0096, 0x00AB, 0x00C0, 0x00D7, 0x00EE, 0x0105,
        0x011D, 0x0135, 0x014D, 0x0166, 0x017E, 0x0197, 0x01AF, 0x01C7, 0x01DF, 0x01F6, 0x020D, 0x0222, 0x0237, 0x024B, 0x025E, 0x026F,
        0x027F, 0x028E, 0x029B, 0x02A6, 0x02AF, 0x02B6, 0x02BB, 0x02BE, 0x02BF, 0x02BD, 0x02B8, 0x02B2, 0x02A8, 0x029B, 0x028C, 0x027A,
        0x0265, 0x024D, 0x0232, 0x0214, 0x01F3, 0x01CF, 0x01A9, 0x017F, 0x0152, 0x0122, 0x00F0, 0x00BB, 0x0083, 0x0049, 0x000C, 0xFFCE,
        0xFF8D, 0xFF4A, 0xFF05, 0xFEBE, 0xFE76, 0xFE2D, 0xFDE2, 0xFD97, 0xFD4B, 0xFCFF, 0xFCB2, 0xFC65, 0xFC19, 0xFBCD, 0xFB82, 0xFB39,
        0xFAF0, 0xFAA9, 0xFA65, 0xFA22, 0xF9E2, 0xF9A4, 0xF96A, 0xF933, 0xF900, 0xF8D0, 0xF8A5, 0xF87D, 0xF85B, 0xF83D, 0xF824, 0xF811,
        0xF803, 0xF7FB, 0xF7F9, 0xF7FC, 0xF806, 0xF816, 0xF82C, 0xF849, 0xF86D, 0xF897, 0xF8C8, 0xF8FF, 0xF93D, 0xF982, 0xF9CE, 0xFA20,
        0xFA78, 0xFAD7, 0xFB3C, 0xFBA7, 0xFC18, 0xFC8F, 0xFD0B, 0xFD8C, 0xFE13, 0xFE9E, 0xFF2D, 0xFFC0, 0x0056, 0x00F0, 0x018E, 0x022D,
        0x02CF, 0x0373, 0x0417, 0x04BD, 0x0563, 0x0608, 0x06AD, 0x0751, 0x07F2, 0x0892, 0x092F, 0x09C9, 0x0A5F, 0x0AF0, 0x0B7D, 0x0C05,
        0x0C86, 0x0D02, 0x0D76, 0x0DE3, 0x0E49, 0x0EA6, 0x0EFB, 0x0F46, 0x0F88, 0x0FC1, 0x0FEF, 0x1012, 0x102B, 0x1038, 0x103B, 0x1031,
        0x101C, 0x0FFB, 0x0FCE, 0x0F94, 0x0F4E, 0x0EFD, 0x0E9E, 0x0E34, 0x0DBD, 0x0D3B, 0x0CAC, 0x0C12, 0x0B6D, 0x0ABC, 0x0A01, 0x093A,
        0x086A, 0x0790, 0x06AD, 0x05C1, 0x04CD, 0x03D0, 0x02CD, 0x01C3, 0x00B4, 0xFFA0, 0xFE86, 0xFD69, 0xFC49, 0xFB26, 0xFA02, 0xF8DD,
        0xF7B9, 0xF695, 0xF573, 0xF454, 0xF338, 0xF220, 0xF10E, 0xF001, 0xEEFC, 0xEDFE, 0xED09, 0xEC1D, 0xEB3C, 0xEA65, 0xE99A, 0xE8DC,
        0xE82B, 0xE788, 0xE6F4, 0xE66E, 0xE5F9, 0xE594, 0xE541, 0xE4FE, 0xE4CE, 0xE4B0, 0xE4A5, 0xE4AC, 0xE4C7, 0xE4F6, 0xE538, 0xE58D,
        0xE5F7, 0xE674, 0xE705, 0xE7AA, 0xE862, 0xE92D, 0xEA0C, 0xEAFC, 0xEBFF, 0xED14, 0xEE3A, 0xEF70, 0xF0B7, 0xF20C, 0xF370, 0xF4E3,
        0xF661, 0xF7ED, 0xF983, 0xFB23, 0xFCCD, 0xFE7E, 0x0036, 0x01F4, 0x03B8, 0x057E, 0x0747, 0x0912, 0x0ADC, 0x0CA4, 0x0E6A, 0x102D,
        0x11E9, 0x13A0, 0x154E, 0x16F3, 0x188E, 0x1A1D, 0x1B9F, 0x1D13, 0x1E78, 0x1FCC, 0x210E, 0x223E, 0x235A, 0x2460, 0x2551, 0x262B,
        0x26EE, 0x2798, 0x2828, 0x289F, 0x28FA, 0x293B, 0x2960, 0x2968, 0x2955, 0x2924, 0x28D6, 0x286B, 0x27E2, 0x273D, 0x267A, 0x259A,
        0x249E, 0x2385, 0x2250, 0x2100, 0x1F95, 0x1E10, 0x1C72, 0x1ABB, 0x18EC, 0x1707, 0x150C, 0x12FD, 0x10DA, 0x0EA6, 0x0C61, 0x0A0D,
        0x07AB, 0x053D, 0x02C4, 0x0041, 0xFDB9, 0xFB2A, 0xF896, 0xF601, 0xF36A, 0xF0D6, 0xEE44, 0xEBB7, 0xE931, 0xE6B3, 0xE440, 0xE1D9,
        0xDF80, 0xDD37, 0xDB00, 0xD8DC, 0xD6CD, 0xD4D4, 0xD2F4, 0xD12E, 0xCF83, 0xCDF5, 0xCC85, 0xCB35, 0xCA05, 0xC8F7, 0xC80D, 0xC746,
        0xC6A5, 0xC629, 0xC5D3, 0xC5A5, 0xC59E, 0xC5C0, 0xC609, 0xC67C, 0xC717, 0xC7DB, 0xC8C7, 0xC9DC, 0xCB19, 0xCC7D, 0xCE09, 0xCFBB,
        0xD192, 0xD38E, 0xD5AD, 0xD7EF, 0xDA53, 0xDCD6, 0xDF78, 0xE237, 0xE511, 0xE805, 0xEB10, 0xEE32, 0xF168, 0xF4B0, 0xF808, 0xFB6D,
        0xFEDF, 0x0258, 0x05DA, 0x0960, 0x0CE8, 0x1070, 0x13F5, 0x1776, 0x1AEE, 0x1E5D, 0x21BF, 0x2513, 0x2854, 0x2B82, 0x2E9A, 0x319A,
        0x347E, 0x3745, 0x39ED, 0x3C74, 0x3ED7, 0x4115, 0x432C, 0x4519, 0x46DC, 0x4872, 0x49DA, 0x4B13, 0x4C1B, 0x4CF2, 0x4D96, 0x4E06,
        0x4E42, 0x4E49, 0x4E1A, 0x4DB5, 0x4D1B, 0x4C4A, 0x4B43, 0x4A06, 0x4894, 0x46ED, 0x4511, 0x4303, 0x40C1, 0x3E4F, 0x3BAC, 0x38DB,
        0x35DC, 0x32B2, 0x2F5E, 0x2BE3, 0x2842, 0x247D, 0x2097, 0x1C93, 0x1872, 0x1437, 0x0FE5, 0x0B80, 0x0708, 0x0283, 0xFDF2, 0xF959,
        0xF4C6, 0xF03A, 0xEBBA, 0xE747, 0xE2E4, 0xDE95, 0xDA5D, 0xD63E, 0xD23B, 0xCE57, 0xCA95, 0xC6F6, 0xC37E, 0xC02F, 0xBD0B, 0xBA14,
        0xB74C, 0xB4B5, 0xB251, 0xB021, 0xAE27, 0xAC64, 0xAAD9, 0xA988, 0xA871, 0xA795, 0xA6F5, 0xA690, 0xA668, 0xA67D, 0xA6CD, 0xA75A,
        0xA823, 0xA926, 0xAA65, 0xABDD, 0xAD8D, 0xAF75, 0xB194, 0xB3E7, 0xB66E, 0xB926, 0xBC0E, 0xBF24, 0xC265, 0xC5D0, 0xC962, 0xCD19,
        0xD0F3, 0xD4EC, 0xD902, 0xDD32, 0xE17A, 0xE5D6, 0xEA44, 0xEEC1, 0xF349, 0xF7DA, 0xFC70, 0x0108, 0x05A0, 0x0A34, 0x0EC1, 0x1345,
        0x17BB, 0x1C22, 0x2075, 0x24B3, 0x28D7, 0x2CE1, 0x30CC, 0x3496, 0x383D, 0x3BBE, 0x3F16, 0x4244, 0x4546, 0x4819, 0x4ABB, 0x4D2A,
        0x4F66, 0x516D, 0x533C, 0x54D3, 0x5631, 0x5756, 0x583F, 0x58EC, 0x595E, 0x5994, 0x598D, 0x594A, 0x58CB, 0x5810, 0x5719, 0x55E8,
        0x547D, 0x52D9, 0x50FD, 0x4EEB, 0x4CA3, 0x4A28, 0x477A, 0x449D, 0x4191, 0x3E5A, 0x3AF8, 0x376E, 0x33BF, 0x2FED, 0x2BFB, 0x27EC,
        0x23C1, 0x1F7E, 0x1B26, 0x16BC, 0x1242, 0x0DBC, 0x092D, 0x0498, 0x0000, 0xFB68, 0xF6D3, 0xF244, 0xEDBE, 0xE944, 0xE4DA, 0xE082,
        0xDC3F, 0xD814, 0xD405, 0xD013, 0xCC41, 0xC892, 0xC508, 0xC1A6, 0xBE6F, 0xBB63, 0xB886, 0xB5D8, 0xB35D, 0xB115, 0xAF03, 0xAD27,
        0xAB83, 0xAA18, 0xA8E7, 0xA7F0, 0xA735, 0xA6B6, 0xA673, 0xA66C, 0xA6A2, 0xA714, 0xA7C1, 0xA8AA, 0xA9CF, 0xAB2D, 0xACC4, 0xAE93,
        0xB09A, 0xB2D6, 0xB545, 0xB7E7, 0xBABA, 0xBDBC, 0xC0EA, 0xC442, 0xC7C3, 0xCB6A, 0xCF34, 0xD31F, 0xD729, 0xDB4D, 0xDF8B, 0xE3DE,
        0xE845, 0xECBB, 0xF13F, 0xF5CC, 0xFA60, 0xFEF8, 0x0390, 0x0826, 0x0CB7, 0x113F, 0x15BC, 0x1A2A, 0x1E86, 0x22CE, 0x26FE, 0x2B14,
        0x2F0D, 0x32E7, 0x369E, 0x3A30, 0x3D9B, 0x40DC, 0x43F2, 0x46DA, 0x4992, 0x4C19, 0x4E6C, 0x508B, 0x5273, 0x5423, 0x559B, 0x56DA,
        0x57DD, 0x58A6, 0x5933, 0x5983, 0x5998, 0x5970, 0x590B, 0x586B, 0x578F, 0x5678, 0x5527, 0x539C, 0x51D9, 0x4FDF, 0x4DAF, 0x4B4B,
        0x48B4, 0x45EC, 0x42F5, 0x3FD1, 0x3C82, 0x390A, 0x356B, 0x31A9, 0x2DC5, 0x29C2, 0x25A3, 0x216B, 0x1D1C, 0x18B9, 0x1446, 0x0FC6,
        0x0B3A, 0x06A7, 0x0210, 0xFD78, 0xF8E1, 0xF44F, 0xEFC4, 0xEB45, 0xE6D3, 0xE273, 0xDE26, 0xD9F0, 0xD5D4, 0xD1D4, 0xCDF4, 0xCA35,
        0xC69A, 0xC326, 0xBFDB, 0xBCBB, 0xB9C9, 0xB706, 0xB474, 0xB215, 0xAFEB, 0xADF6, 0xAC39, 0xAAB4, 0xA969, 0xA858, 0xA782, 0xA6E8,
        0xA68A, 0xA668, 0xA682, 0xA6D9, 0xA76C, 0xA83A, 0xA944, 0xAA88, 0xAC06, 0xADBD, 0xAFAA, 0xB1CE, 0xB427, 0xB6B3, 0xB970, 0xBC5D,
        0xBF77, 0xC2BD, 0xC62C, 0xC9C2, 0xCD7C, 0xD159, 0xD555, 0xD96E, 0xDDA1, 0xE1EB, 0xE649, 0xEAB9, 0xEF37, 0xF3C0, 0xF851, 0xFCE8,
        0x0180, 0x0618, 0x0AAB, 0x0F38, 0x13BA, 0x182F, 0x1C93, 0x20E5, 0x2520, 0x2942, 0x2D49, 0x3130, 0x34F7, 0x389A, 0x3C17, 0x3F6B,
        0x4295, 0x4592, 0x4860, 0x4AFD, 0x4D67, 0x4F9E, 0x519E, 0x5368, 0x54FA, 0x5652, 0x5770, 0x5853, 0x58FB, 0x5967, 0x5996, 0x5989,
        0x5940, 0x58BA, 0x57F9, 0x56FD, 0x55C5, 0x5455, 0x52AB, 0x50C9, 0x4EB1, 0x4C64, 0x49E4, 0x4732, 0x4450, 0x413F, 0x3E03, 0x3A9D,
        0x3710, 0x335D, 0x2F88, 0x2B93, 0x2780, 0x2353, 0x1F0E, 0x1AB4, 0x1648, 0x11CD, 0x0D46, 0x08B6, 0x0420, 0xFF88, 0xFAF0, 0xF65B,
        0xF1CD, 0xED48, 0xE8D0, 0xE467, 0xE012, 0xDBD1, 0xD7A9, 0xD39C, 0xCFAD, 0xCBDF, 0xC834, 0xC4AE, 0xC150, 0xBE1D, 0xBB16, 0xB83D,
        0xB595, 0xB31F, 0xB0DD, 0xAED0, 0xACFA, 0xAB5C, 0xA9F6, 0xA8CB, 0xA7DB, 0xA726, 0xA6AC, 0xA66F, 0xA66F, 0xA6AB, 0xA723, 0xA7D6,
        0xA8C6, 0xA9F0, 0xAB54, 0xACF1, 0xAEC6, 0xB0D2, 0xB313, 0xB588, 0xB82F, 0xBB07, 0xBE0D, 0xC13F, 0xC49C, 0xC821, 0xCBCB, 0xCF99,
        0xD387, 0xD794, 0xDBBB, 0xDFFB, 0xE451, 0xE8B9, 0xED31, 0xF1B5, 0xF643, 0xFAD8, 0xFF70, 0x0408, 0x089E, 0x0D2E, 0x11B5, 0x1630,
        0x1A9D, 0x1EF7, 0x233D, 0x276A, 0x2B7E, 0x2F73, 0x3349, 0x36FD, 0x3A8B, 0x3DF2, 0x412F, 0x4440, 0x4723, 0x49D6, 0x4C58, 0x4EA6,
        0x50BF, 0x52A1, 0x544C, 0x55BE, 0x56F7, 0x57F5, 0x58B7, 0x593E, 0x5988, 0x5996, 0x5968, 0x58FE, 0x5857, 0x5775, 0x5658, 0x5501,
        0x5371, 0x51A8, 0x4FA9, 0x4D73, 0x4B0A, 0x486E, 0x45A1, 0x42A5, 0x3F7C, 0x3C29, 0x38AD, 0x350A, 0x3144, 0x2D5D, 0x2957, 0x2536,
        0x20FB, 0x1CAA, 0x1846, 0x13D1, 0x0F4F, 0x0AC3, 0x0630, 0x0198, 0xFD00, 0xF869, 0xF3D8, 0xEF4E, 0xEAD0, 0xE660, 0xE201, 0xDDB7,
        0xD984, 0xD56A, 0xD16E, 0xCD90, 0xC9D5, 0xC63E, 0xC2CE, 0xBF88, 0xBC6C, 0xB97F, 0xB6C1, 0xB434, 0xB1DA, 0xAFB5, 0xADC6, 0xAC0F,
        0xAA90, 0xA94A, 0xA83F, 0xA770, 0xA6DB, 0xA683, 0xA668, 0xA688, 0xA6E5, 0xA77E, 0xA853, 0xA963, 0xAAAD, 0xAC30, 0xADEC, 0xAFE0,
        0xB209, 0xB467, 0xB6F8, 0xB9BA, 0xBCAC, 0xBFCA, 0xC314, 0xC688, 0xCA22, 0xCDE0, 0xD1C0, 0xD5BF, 0xD9DA, 0xDE10, 0xE25C, 0xE6BC,
        0xEB2D, 0xEFAD, 0xF437, 0xF8C9, 0xFD60, 0x01F8, 0x068F, 0x0B22, 0x0FAE, 0x142F, 0x18A2, 0x1D05, 0x2154, 0x258D, 0x29AD, 0x2DB0,
        0x3195, 0x3558, 0x38F7, 0x3C70, 0x3FC0, 0x42E5, 0x45DD, 0x48A6, 0x4B3E, 0x4DA3, 0x4FD4, 0x51D0, 0x5394, 0x551F, 0x5672, 0x578A,
        0x5867, 0x5909, 0x596E, 0x5997, 0x5984, 0x5935, 0x58A9, 0x57E2, 0x56DF, 0x55A2, 0x542C, 0x527C, 0x5095, 0x4E78, 0x4C25, 0x49A0,
        0x46E9, 0x4402, 0x40ED, 0x3DAC, 0x3A42, 0x36B1, 0x32FA, 0x2F22, 0x2B29, 0x2714, 0x22E4, 0x1E9D, 0x1A41, 0x15D3, 0x1157, 0x0CCF,
        0x083E, 0x03A8, 0xFF10, 0xFA78, 0xF5E4, 0xF156, 0xECD3, 0xE85C, 0xE3F5, 0xDFA1, 0xDB63, 0xD73E, 0xD334, 0xCF48, 0xCB7D, 0xC7D6,
        0xC454, 0xC0FB, 0xBDCC, 0xBAC9, 0xB7F6, 0xB553, 0xB2E2, 0xB0A5, 0xAE9D, 0xACCD, 0xAB34, 0xA9D5, 0xA8B0, 0xA7C5, 0xA716, 0xA6A3,
        0xA66D, 0xA672, 0xA6B4, 0xA732, 0xA7EC, 0xA8E1, 0xAA11, 0xAB7B, 0xAD1E, 0xAEF9, 0xB10A, 0xB351, 0xB5CB, 0xB877, 0xBB54, 0xBE5E,
        0xC195, 0xC4F6, 0xC87F, 0xCC2D, 0xCFFE, 0xD3F0, 0xD7FF, 0xDC29, 0xE06B, 0xE4C3, 0xE92D, 0xEDA6, 0xF22C, 0xF6BB, 0xFB50, 0xFFE8,
        0x0480, 0x0915, 0x0DA5, 0x122B, 0x16A5, 0x1B0F, 0x1F68, 0x23AB, 0x27D6, 0x2BE6, 0x2FD9, 0x33AC, 0x375B, 0x3AE6, 0x3E48, 0x4181,
        0x448E, 0x476C, 0x4A1A, 0x4C96, 0x4EDF, 0x50F3, 0x52D0, 0x5475, 0x55E1, 0x5713, 0x580B, 0x58C7, 0x5948, 0x598C, 0x5994, 0x5960,
        0x58EF, 0x5843, 0x575B, 0x5638, 0x54DB, 0x5345, 0x5177, 0x4F71, 0x4D37, 0x4AC8, 0x4827, 0x4555, 0x4255, 0x3F27, 0x3BD0, 0x384F,
        0x34A9, 0x30E0, 0x2CF6, 0x28ED, 0x24C8, 0x208B, 0x1C38, 0x17D2, 0x135C, 0x0ED9, 0x0A4C, 0x05B8, 0x0120, 0xFC88, 0xF7F2, 0xF361,
        0xEED8, 0xEA5B, 0xE5ED, 0xE190, 0xDD48, 0xD917, 0xD501, 0xD107, 0xCD2D, 0xC975, 0xC5E2, 0xC277, 0xBF34, 0xBC1E, 0xB935, 0xB67C,
        0xB3F4, 0xB1A0, 0xAF80, 0xAD97, 0xABE5, 0xAA6C, 0xA92C, 0xA827, 0xA75E, 0xA6D0, 0xA67E, 0xA668, 0xA68F, 0xA6F2, 0xA791, 0xA86C,
        0xA982, 0xAAD2, 0xAC5B, 0xAE1D, 0xB016, 0xB245, 0xB4A8, 0xB73E, 0xBA05, 0xBCFB, 0xC01E, 0xC36D, 0xC6E4, 0xCA82, 0xCE43, 0xD227,
        0xD629, 0xDA47, 0xDE7F, 0xE2CD, 0xE72F, 0xEBA2, 0xF023, 0xF4AE, 0xF941, 0xFDD8, 0x0270, 0x0707, 0x0B9A, 0x1024, 0x14A4, 0x1916,
        0x1D77, 0x21C4, 0x25FA, 0x2A17, 0x2E17, 0x31F8, 0x35B8, 0x3953, 0x3CC8, 0x4014, 0x4335, 0x4628, 0x48EC, 0x4B7F, 0x4DDF, 0x500B,
        0x5200, 0x53BF, 0x5545, 0x5691, 0x57A3, 0x587A, 0x5916, 0x5975, 0x5998, 0x597F, 0x5929, 0x5898, 0x57CA, 0x56C2, 0x557F, 0x5402,
        0x524D, 0x5060, 0x4E3D, 0x4BE6, 0x495B, 0x469F, 0x43B3, 0x409A, 0x3D55, 0x39E7, 0x3651, 0x3297, 0x2EBC, 0x2AC0, 0x26A8, 0x2275,
        0x1E2C, 0x19CE, 0x155F, 0x10E1, 0x0C58, 0x07C7, 0x0330, 0xFE98, 0xFA00, 0xF56D, 0xF0E0, 0xEC5E, 0xE7E8, 0xE383, 0xDF32, 0xDAF6,
        0xD6D3, 0xD2CC, 0xCEE4, 0xCB1C, 0xC779, 0xC3FB, 0xC0A6, 0xBD7B, 0xBA7D, 0xB7AF, 0xB510, 0xB2A5, 0xB06D, 0xAE6C, 0xACA1, 0xAB0E,
        0xA9B5, 0xA895, 0xA7B1, 0xA708, 0xA69B, 0xA66A, 0xA676, 0xA6BE, 0xA742, 0xA802, 0xA8FE, 0xAA34, 0xABA3, 0xAD4C, 0xAF2C, 0xB143,
        0xB38F, 0xB60E, 0xB8C0, 0xBBA1, 0xBEB0, 0xC1EC, 0xC551, 0xC8DD, 0xCC8F, 0xD064, 0xD458, 0xD86B, 0xDC97, 0xE0DC, 0xE535, 0xE9A1,
        0xEE1C, 0xF2A3, 0xF732, 0xFBC8, 0x0060, 0x04F8, 0x098D, 0x0E1B, 0x12A0, 0x1719, 0x1B82, 0x1FD8, 0x2419, 0x2841, 0x2C4F, 0x303E,
        0x340E, 0x37BA, 0x3B40, 0x3E9E, 0x41D3, 0x44DB, 0x47B4, 0x4A5D, 0x4CD5, 0x4F18, 0x5126, 0x52FD, 0x549D, 0x5603, 0x572F, 0x5821,
        0x58D7, 0x5952, 0x5990, 0x5992, 0x5957, 0x58E1, 0x582E, 0x5740, 0x5617, 0x54B4, 0x5318, 0x5144, 0x4F3A, 0x4CF9, 0x4A86, 0x47DF,
        0x4509, 0x4204, 0x3ED2, 0x3B76, 0x37F2, 0x3448, 0x307B, 0x2C8D, 0x2882, 0x245B, 0x201B, 0x1BC6, 0x175E, 0x12E7, 0x0E62, 0x09D4,
        0x0540, 0x00A8, 0xFC10, 0xF77A, 0xF2EA, 0xEE62, 0xE9E7, 0xE57A, 0xE11F, 0xDCDA, 0xD8AB, 0xD497, 0xD0A1, 0xCCCA, 0xC916, 0xC587,
        0xC220, 0xBEE2, 0xBBD0, 0xB8EB, 0xB637, 0xB3B5, 0xB166, 0xAF4C, 0xAD68, 0xABBC, 0xAA48, 0xA90F, 0xA810, 0xA74C, 0xA6C5, 0xA679,
        0xA669, 0xA696, 0xA700, 0xA7A5, 0xA886, 0xA9A1, 0xAAF7, 0xAC86, 0xAE4E, 0xB04C, 0xB281, 0xB4E9, 0xB784, 0xBA50, 0xBD4B, 0xC073,
        0xC3C5, 0xC741, 0xCAE2, 0xCEA7, 0xD28E, 0xD693, 0xDAB4, 0xDEEF, 0xE33F, 0xE7A3, 0xEC17, 0xF099, 0xF525, 0xF9B9, 0xFE50, 0x02E8,
        0x077F, 0x0C11, 0x109A, 0x1519, 0x1989, 0x1DE8, 0x2233, 0x2667, 0x2A81, 0x2E7E, 0x325C, 0x3618, 0x39B0, 0x3D20, 0x4068, 0x4384,
        0x4673, 0x4932, 0x4BBF, 0x4E1A, 0x5040, 0x5230, 0x53E9, 0x5569, 0x56B0, 0x57BC, 0x588D, 0x5922, 0x597B, 0x5998, 0x5979, 0x591D,
        0x5885, 0x57B2, 0x56A4, 0x555B, 0x53D8, 0x521D, 0x502B, 0x4E03, 0x4BA6, 0x4916, 0x4655, 0x4364, 0x4046, 0x3CFD, 0x398B, 0x35F2,
        0x3234, 0x2E55, 0x2A56, 0x263B, 0x2206, 0x1DBB, 0x195B, 0x14EA, 0x106B, 0x0BE1, 0x074F, 0x02B8, 0xFE20, 0xF989, 0xF4F5, 0xF06A,
        0xEBE8, 0xE775, 0xE312, 0xDEC2, 0xDA89, 0xD669, 0xD265, 0xCE7F, 0xCABC, 0xC71C, 0xC3A2, 0xC051, 0xBD2B, 0xBA32, 0xB768, 0xB4CF,
        0xB269, 0xB036, 0xAE3A, 0xAC75, 0xAAE8, 0xA995, 0xA87B, 0xA79D, 0xA6FA, 0xA693, 0xA669, 0xA67B, 0xA6C9, 0xA753, 0xA819, 0xA91B,
        0xAA57, 0xABCC, 0xAD7A, 0xAF60, 0xB17D, 0xB3CE, 0xB653, 0xB909, 0xBBEF, 0xBF03, 0xC242, 0xC5AC, 0xC93C, 0xCCF2, 0xD0CA, 0xD4C2,
        0xD8D6, 0xDD06, 0xE14D, 0xE5A8, 0xEA15, 0xEE92, 0xF319, 0xF7AA, 0xFC40, 0x00D8, 0x0570, 0x0A04, 0x0E92, 0x1316, 0x178D, 0x1BF4,
        0x2048, 0x2487, 0x28AD, 0x2CB7, 0x30A4, 0x346F, 0x3817, 0x3B9A, 0x3EF4, 0x4224, 0x4527, 0x47FC, 0x4AA0, 0x4D12, 0x4F50, 0x5158,
        0x532A, 0x54C4, 0x5624, 0x574B, 0x5836, 0x58E7, 0x595B, 0x5993, 0x598F, 0x594E, 0x58D1, 0x5818, 0x5724, 0x55F5, 0x548D, 0x52EB,
        0x5111, 0x4F01, 0x4CBC, 0x4A43, 0x4797, 0x44BC, 0x41B2, 0x3E7C, 0x3B1C, 0x3794, 0x33E6, 0x3016, 0x2C25, 0x2817, 0x23ED, 0x1FAB,
        0x1B54, 0x16EA, 0x1271, 0x0DEC, 0x095D, 0x04C8, 0x0030, 0xFB98, 0xF703, 0xF273, 0xEDED, 0xE973, 0xE508, 0xE0AF, 0xDC6B, 0xD83F,
        0xD42F, 0xD03B, 0xCC68, 0xC8B8, 0xC52C, 0xC1C9, 0xBE8F, 0xBB82, 0xB8A3, 0xB5F3, 0xB376, 0xB12C, 0xAF18, 0xAD3A, 0xAB93, 0xAA26,
        0xA8F2, 0xA7F9, 0xA73C, 0xA6BA, 0xA674, 0xA66B, 0xA69E, 0xA70E, 0xA7B9, 0xA8A0, 0xA9C2, 0xAB1D, 0xACB2, 0xAE7F, 0xB084, 0xB2BD,
        0xB52B, 0xB7CB, 0xBA9C, 0xBD9B, 0xC0C8, 0xC41F, 0xC79E, 0xCB43, 0xCF0C, 0xD2F6, 0xD6FE, 0xDB22, 0xDF5E, 0xE3B1, 0xE817, 0xEC8C,
        0xF10F, 0xF59C, 0xFA30, 0xFEC8, 0x0360, 0x07F6, 0x0C88, 0x1110, 0x158D, 0x19FC, 0x1E59, 0x22A2, 0x26D3, 0x2AEA, 0x2EE4, 0x32BF,
        0x3678, 0x3A0B, 0x3D78, 0x40BB, 0x43D3, 0x46BC, 0x4977, 0x4BFF, 0x4E55, 0x5075, 0x5260, 0x5413, 0x558D, 0x56CE, 0x57D4, 0x589F,
        0x592E, 0x5981, 0x5998, 0x5972, 0x5911, 0x5873, 0x5799, 0x5685, 0x5536, 0x53AE, 0x51ED, 0x4FF5, 0x4DC7, 0x4B65, 0x48D0, 0x460A,
        0x4315, 0x3FF2, 0x3CA5, 0x392F, 0x3592, 0x31D1, 0x2DEE, 0x29EC, 0x25CF, 0x2197, 0x1D49, 0x18E8, 0x1475, 0x0FF5, 0x0B6A, 0x06D7,
        0x0240, 0xFDA8, 0xF911, 0xF47E, 0xEFF3, 0xEB73, 0xE701, 0xE2A0, 0xDE53, 0xDA1C, 0xD5FE, 0xD1FD, 0xCE1B, 0xCA5B, 0xC6BF, 0xC349,
        0xBFFD, 0xBCDB, 0xB9E7, 0xB722, 0xB48E, 0xB22D, 0xB000, 0xAE09, 0xAC4A, 0xAAC3, 0xA975, 0xA862, 0xA78A, 0xA6ED, 0xA68C, 0xA668,
        0xA680, 0xA6D4, 0xA765, 0xA831, 0xA938, 0xAA7A, 0xABF5, 0xADAA, 0xAF95, 0xB1B7, 0xB40D, 0xB697, 0xB952, 0xBC3D, 0xBF56, 0xC29A,
        0xC607, 0xC99C, 0xCD55, 0xD130, 0xD52B, 0xD943, 0xDD74, 0xE1BE, 0xE61B, 0xEA8A, 0xEF07, 0xF390, 0xF821, 0xFCB8, 0x0150, 0x05E8,
        0x0A7C, 0x0F08, 0x138B, 0x1801, 0x1C66, 0x20B8, 0x24F4, 0x2917, 0x2D1F, 0x3108, 0x34D0, 0x3875, 0x3BF3, 0x3F49, 0x4275, 0x4573,
        0x4843, 0x4AE2, 0x4D4F, 0x4F88, 0x518B, 0x5357, 0x54EA, 0x5645, 0x5765, 0x584B, 0x58F5, 0x5963, 0x5995, 0x598B, 0x5944, 0x58C1,
        0x5802, 0x5708, 0x55D3, 0x5465, 0x52BD, 0x50DE, 0x4EC8, 0x4C7D, 0x49FF, 0x474F, 0x446F, 0x4160, 0x3E26, 0x3AC1, 0x3735, 0x3384,
        0x2FB0, 0x2BBC, 0x27AB, 0x237F, 0x1F3B, 0x1AE1, 0x1676, 0x11FC, 0x0D75, 0x08E6, 0x0450, 0xFFB8, 0xFB20, 0xF68B, 0xF1FC, 0xED77,
        0xE8FE, 0xE495, 0xE03E, 0xDBFD, 0xD7D4, 0xD3C6, 0xCFD6, 0xCC06, 0xC859, 0xC4D2, 0xC173, 0xBE3E, 0xBB35, 0xB85A, 0xB5B0, 0xB338,
        0xB0F3, 0xAEE4, 0xAD0C, 0xAB6B, 0xAA04, 0xA8D6, 0xA7E3, 0xA72C, 0xA6B0, 0xA671, 0xA66E, 0xA6A7, 0xA71C, 0xA7CE, 0xA8BB, 0xA9E2,
        0xAB44, 0xACDF, 0xAEB2, 0xB0BB, 0xB2FA, 0xB56D, 0xB812, 0xBAE8, 0xBDEC, 0xC11D, 0xC478, 0xC7FB, 0xCBA4, 0xCF71, 0xD35E, 0xD769,
        0xDB8F, 0xDFCE, 0xE423, 0xE88A, 0xED02, 0xF186, 0xF614, 0xFAA8, 0xFF40, 0x03D8, 0x086E, 0x0CFE, 0x1186, 0x1602, 0x1A6F, 0x1ECA,
        0x2310, 0x273F, 0x2B54, 0x2F4B, 0x3322, 0x36D7, 0x3A67, 0x3DCF, 0x410E, 0x4421, 0x4706, 0x49BB, 0x4C3F, 0x4E8F, 0x50AA, 0x528F,
        0x543C, 0x55B1, 0x56EB, 0x57EB, 0x58B0, 0x5939, 0x5986, 0x5997, 0x596B, 0x5903, 0x585F, 0x5780, 0x5665, 0x5510, 0x5382, 0x51BC,
        0x4FBF, 0x4D8B, 0x4B24, 0x488A, 0x45BF, 0x42C5, 0x3F9E, 0x3C4C, 0x38D2, 0x3531, 0x316D, 0x2D87, 0x2982, 0x2562, 0x2128, 0x1CD8,
        0x1874, 0x1400, 0x0F7F, 0x0AF3, 0x065F, 0x01C8, 0xFD30, 0xF899, 0xF407, 0xEF7D, 0xEAFF, 0xE68E, 0xE22F, 0xDDE3, 0xD9AF, 0xD594,
        0xD197, 0xCDB8, 0xC9FB, 0xC663, 0xC2F1, 0xBFA9, 0xBC8C, 0xB99C, 0xB6DC, 0xB44D, 0xB1F2, 0xAFCA, 0xADD9, 0xAC1F, 0xAA9E, 0xA956,
        0xA849, 0xA777, 0xA6E0, 0xA686, 0xA668, 0xA686, 0xA6E0, 0xA777, 0xA849, 0xA956, 0xAA9E, 0xAC1F, 0xADD9, 0xAFCA, 0xB1F2, 0xB44D,
        0xB6DC, 0xB99C, 0xBC8C, 0xBFA9, 0xC2F1, 0xC663, 0xC9FB, 0xCDB8, 0xD197, 0xD594, 0xD9AF, 0xDDE3, 0xE22F, 0xE68E, 0xEAFF, 0xEF7D,
        0xF407, 0xF899, 0xFD30, 0x01C8, 0x065F, 0x0AF3, 0x0F7F, 0x1400, 0x1874, 0x1CD8, 0x2128, 0x2562, 0x2982, 0x2D87, 0x316D, 0x3531,
        0x38D2, 0x3C4C, 0x3F9E, 0x42C5, 0x45BF, 0x488A, 0x4B24, 0x4D8B, 0x4FBF, 0x51BC, 0x5382, 0x5510, 0x5665, 0x5780, 0x585F, 0x5903,
        0x596B, 0x5997, 0x5986, 0x5939, 0x58B0, 0x57EB, 0x56EB, 0x55B1, 0x543C, 0x528F, 0x50AA, 0x4E8F, 0x4C3F, 0x49BB, 0x4706, 0x4421,
        0x410E, 0x3DCF, 0x3A67, 0x36D7, 0x3322, 0x2F4B, 0x2B54, 0x273F, 0x2310, 0x1ECA, 0x1A6F, 0x1602, 0x1186, 0x0CFE, 0x086E, 0x03D8,
        0xFF40, 0xFAA8, 0xF614, 0xF186, 0xED02, 0xE88A, 0xE423, 0xDFCE, 0xDB8F, 0xD769, 0xD35E, 0xCF71, 0xCBA4, 0xC7FB, 0xC478, 0xC11D,
        0xBDEC, 0xBAE8, 0xB812, 0xB56D, 0xB2FA, 0xB0BB, 0xAEB2, 0xACDF, 0xAB44, 0xA9E2, 0xA8BB, 0xA7CE, 0xA71C, 0xA6A7, 0xA66E, 0xA671,
        0xA6B0, 0xA72C, 0xA7E3, 0xA8D6, 0xAA04, 0xAB6B, 0xAD0C, 0xAEE4, 0xB0F3, 0xB338, 0xB5B0, 0xB85A, 0xBB35, 0xBE3E, 0xC173, 0xC4D2,
        0xC859, 0xCC06, 0xCFD6, 0xD3C6, 0xD7D4, 0xDBFD, 0xE03E, 0xE495, 0xE8FE, 0xED77, 0xF1FC, 0xF68B, 0xFB20, 0xFFB8, 0x0450, 0x08E6,
        0x0D75, 0x11FC, 0x1676, 0x1AE1, 0x1F3B, 0x237F, 0x27AB, 0x2BBC, 0x2FB0, 0x3384, 0x3735, 0x3AC1, 0x3E26, 0x4160, 0x446F, 0x474F,
        0x49FF, 0x4C7D, 0x4EC8, 0x50DE, 0x52BD, 0x5465, 0x55D3, 0x5708, 0x5802, 0x58C1, 0x5944, 0x598B, 0x5995, 0x5963, 0x58F5, 0x584B,
        0x5765, 0x5645, 0x54EA, 0x5357, 0x518B, 0x4F88, 0x4D4F, 0x4AE2, 0x4843, 0x4573, 0x4275, 0x3F49, 0x3BF3, 0x3875, 0x34D0, 0x3108,
        0x2D1F, 0x2917, 0x24F4, 0x20B8, 0x1C66, 0x1801, 0x138B, 0x0F08, 0x0A7C, 0x05E8, 0x0150, 0xFCB8, 0xF821, 0xF390, 0xEF07, 0xEA8A,
        0xE61B, 0xE1BE, 0xDD74, 0xD943, 0xD52B, 0xD130, 0xCD55, 0xC99C, 0xC607, 0xC29A, 0xBF56, 0xBC3D, 0xB952, 0xB697, 0xB40D, 0xB1B7,
        0xAF95, 0xADAA, 0xABF5, 0xAA7A, 0xA938, 0xA831, 0xA765, 0xA6D4, 0xA680, 0xA668, 0xA68C, 0xA6ED, 0xA78A, 0xA862, 0xA975, 0xAAC3,
        0xAC4A, 0xAE09, 0xB000, 0xB22D, 0xB48E, 0xB722, 0xB9E7, 0xBCDB, 0xBFFD, 0xC349, 0xC6BF, 0xCA5B, 0xCE1B, 0xD1FD, 0xD5FE, 0xDA1C,
        0xDE53, 0xE2A0, 0xE701, 0xEB73, 0xEFF3, 0xF47E, 0xF911, 0xFDA8, 0x0240, 0x06D7, 0x0B6A, 0x0FF5, 0x1475, 0x18E8, 0x1D49, 0x2197,
        0x25CF, 0x29EC, 0x2DEE, 0x31D1, 0x3592, 0x392F, 0x3CA5, 0x3FF2, 0x4315, 0x460A, 0x48D0, 0x4B65, 0x4DC7, 0x4FF5, 0x51ED, 0x53AE,
        0x5536, 0x5685, 0x5799, 0x5873, 0x5911, 0x5972, 0x5998, 0x5981, 0x592E, 0x589F, 0x57D4, 0x56CE, 0x558D, 0x5413, 0x5260, 0x5075,
        0x4E55, 0x4BFF, 0x4977, 0x46BC, 0x43D3, 0x40BB, 0x3D78, 0x3A0B, 0x3678, 0x32BF, 0x2EE4, 0x2AEA, 0x26D3, 0x22A2, 0x1E59, 0x19FC,
        0x158D, 0x1110, 0x0C88, 0x07F6, 0x0360, 0xFEC8, 0xFA30, 0xF59C, 0xF10F, 0xEC8C, 0xE817, 0xE3B1, 0xDF5E, 0xDB22, 0xD6FE, 0xD2F6,
        0xCF0C, 0xCB43, 0xC79E, 0xC41F, 0xC0C8, 0xBD9B, 0xBA9C, 0xB7CB, 0xB52B, 0xB2BD, 0xB084, 0xAE7F, 0xACB2, 0xAB1D, 0xA9C2, 0xA8A0,
        0xA7B9, 0xA70E, 0xA69E, 0xA66B, 0xA674, 0xA6BA, 0xA73C, 0xA7F9, 0xA8F2, 0xAA26, 0xAB93, 0xAD3A, 0xAF18, 0xB12C, 0xB376, 0xB5F3,
        0xB8A3, 0xBB82, 0xBE8F, 0xC1C9, 0xC52C, 0xC8B8, 0xCC68, 0xD03B, 0xD42F, 0xD83F, 0xDC6B, 0xE0AF, 0xE508, 0xE973, 0xEDED, 0xF273,
        0xF703, 0xFB98, 0x0030, 0x04C8, 0x095D, 0x0DEC, 0x1271, 0x16EA, 0x1B54, 0x1FAB, 0x23ED, 0x2817, 0x2C25, 0x3016, 0x33E6, 0x3794,
        0x3B1C, 0x3E7C, 0x41B2, 0x44BC, 0x4797, 0x4A43, 0x4CBC, 0x4F01, 0x5111, 0x52EB, 0x548D, 0x55F5, 0x5724, 0x5818, 0x58D1, 0x594E,
        0x598F, 0x5993, 0x595B, 0x58E7, 0x5836, 0x574B, 0x5624, 0x54C4, 0x532A, 0x5158, 0x4F50, 0x4D12, 0x4AA0, 0x47FC, 0x4527, 0x4224,
        0x3EF4, 0x3B9A, 0x3817, 0x346F, 0x30A4, 0x2CB7, 0x28AD, 0x2487, 0x2048, 0x1BF4, 0x178D, 0x1316, 0x0E92, 0x0A04, 0x0570, 0x00D8,
        0xFC40, 0xF7AA, 0xF319, 0xEE92, 0xEA15, 0xE5A8, 0xE14D, 0xDD06, 0xD8D6, 0xD4C2, 0xD0CA, 0xCCF2, 0xC93C, 0xC5AC, 0xC242, 0xBF03,
        0xBBEF, 0xB909, 0xB653, 0xB3CE, 0xB17D, 0xAF60, 0xAD7A, 0xABCC, 0xAA57, 0xA91B, 0xA819, 0xA753, 0xA6C9, 0xA67B, 0xA669, 0xA693,
        0xA6FA, 0xA79D, 0xA87B, 0xA995, 0xAAE8, 0xAC75, 0xAE3A, 0xB036, 0xB269, 0xB4CF, 0xB768, 0xBA32, 0xBD2B, 0xC051, 0xC3A2, 0xC71C,
        0xCABC, 0xCE7F, 0xD265, 0xD669, 0xDA89, 0xDEC2, 0xE312, 0xE775, 0xEBE8, 0xF06A, 0xF4F5, 0xF989, 0xFE20, 0x02B8, 0x074F, 0x0BE1,
        0x106B, 0x14EA, 0x195B, 0x1DBB, 0x2206, 0x263B, 0x2A56, 0x2E55, 0x3234, 0x35F2, 0x398B, 0x3CFD, 0x4046, 0x4364, 0x4655, 0x4916,
        0x4BA6, 0x4E03, 0x502B, 0x521D, 0x53D8, 0x555B, 0x56A4, 0x57B2, 0x5885, 0x591D, 0x5979, 0x5998, 0x597B, 0x5922, 0x588D, 0x57BC,
        0x56B0, 0x5569, 0x53E9, 0x5230, 0x5040, 0x4E1A, 0x4BBF, 0x4932, 0x4673, 0x4384, 0x4068, 0x3D20, 0x39B0, 0x3618, 0x325C, 0x2E7E,
        0x2A81, 0x2667, 0x2233, 0x1DE8, 0x1989, 0x1519, 0x109A, 0x0C11, 0x077F, 0x02E8, 0xFE50, 0xF9B9, 0xF525, 0xF099, 0xEC17, 0xE7A3,
        0xE33F, 0xDEEF, 0xDAB4, 0xD693, 0xD28E, 0xCEA7, 0xCAE2, 0xC741, 0xC3C5, 0xC073, 0xBD4B, 0xBA50, 0xB784, 0xB4E9, 0xB281, 0xB04C,
        0xAE4E, 0xAC86, 0xAAF7, 0xA9A1, 0xA886, 0xA7A5, 0xA700, 0xA696, 0xA669, 0xA679, 0xA6C5, 0xA74C, 0xA810, 0xA90F, 0xAA48, 0xABBC,
        0xAD68, 0xAF4C, 0xB166, 0xB3B5, 0xB637, 0xB8EB, 0xBBD0, 0xBEE2, 0xC220, 0xC587, 0xC916, 0xCCCA, 0xD0A1, 0xD497, 0xD8AB, 0xDCDA,
        0xE11F, 0xE57A, 0xE9E7, 0xEE62, 0xF2EA, 0xF77A, 0xFC10, 0x00A8, 0x0540, 0x09D4, 0x0E62, 0x12E7, 0x175E, 0x1BC6, 0x201B, 0x245B,
        0x2882, 0x2C8D, 0x307B, 0x3448, 0x37F2, 0x3B76, 0x3ED2, 0x4204, 0x4509, 0x47DF, 0x4A86, 0x4CF9, 0x4F3A, 0x5144, 0x5318, 0x54B4,
        0x5617, 0x5740, 0x582E, 0x58E1, 0x5957, 0x5992, 0x5990, 0x5952, 0x58D7, 0x5821, 0x572F, 0x5603, 0x549D, 0x52FD, 0x5126, 0x4F18,
        0x4CD5, 0x4A5D, 0x47B4, 0x44DB, 0x41D3, 0x3E9E, 0x3B40, 0x37BA, 0x340E, 0x303E, 0x2C4F, 0x2841, 0x2419, 0x1FD8, 0x1B82, 0x1719,
        0x12A0, 0x0E1B, 0x098D, 0x04F8, 0x0060, 0xFBC8, 0xF732, 0xF2A3, 0xEE1C, 0xE9A1, 0xE535, 0xE0DC, 0xDC97, 0xD86B, 0xD458, 0xD064,
        0xCC8F, 0xC8DD, 0xC551, 0xC1EC, 0xBEB0, 0xBBA1, 0xB8C0, 0xB60E, 0xB38F, 0xB143, 0xAF2C, 0xAD4C, 0xABA3, 0xAA34, 0xA8FE, 0xA802,
        0xA742, 0xA6BE, 0xA676, 0xA66A, 0xA69B, 0xA708, 0xA7B1, 0xA895, 0xA9B5, 0xAB0E, 0xACA1, 0xAE6C, 0xB06D, 0xB2A5, 0xB510, 0xB7AF,
        0xBA7D, 0xBD7B, 0xC0A6, 0xC3FB, 0xC779, 0xCB1C, 0xCEE4, 0xD2CC, 0xD6D3, 0xDAF6, 0xDF32, 0xE383, 0xE7E8, 0xEC5E, 0xF0E0, 0xF56D,
        0xFA00, 0xFE98, 0x0330, 0x07C7, 0x0C58, 0x10E1, 0x155F, 0x19CE, 0x1E2C, 0x2275, 0x26A8, 0x2AC0, 0x2EBC, 0x3297, 0x3651, 0x39E7,
        0x3D55, 0x409A, 0x43B3, 0x469F, 0x495B, 0x4BE6, 0x4E3D, 0x5060, 0x524D, 0x5402, 0x557F, 0x56C2, 0x57CA, 0x5898, 0x5929, 0x597F,
        0x5998, 0x5975, 0x5916, 0x587A, 0x57A3, 0x5691, 0x5545, 0x53BF, 0x5200, 0x500B, 0x4DDF, 0x4B7F, 0x48EC, 0x4628, 0x4335, 0x4014,
        0x3CC8, 0x3953, 0x35B8, 0x31F8, 0x2E17, 0x2A17, 0x25FA, 0x21C4, 0x1D77, 0x1916, 0x14A4, 0x1024, 0x0B9A, 0x0707, 0x0270, 0xFDD8,
        0xF941, 0xF4AE, 0xF023, 0xEBA2, 0xE72F, 0xE2CD, 0xDE7F, 0xDA47, 0xD629, 0xD227, 0xCE43, 0xCA82, 0xC6E4, 0xC36D, 0xC01E, 0xBCFB,
        0xBA05, 0xB73E, 0xB4A8, 0xB245, 0xB016, 0xAE1D, 0xAC5B, 0xAAD2, 0xA982, 0xA86C, 0xA791, 0xA6F2, 0xA68F, 0xA668, 0xA67E, 0xA6D0,
        0xA75E, 0xA827, 0xA92C, 0xAA6C, 0xABE5, 0xAD97, 0xAF80, 0xB1A0, 0xB3F4, 0xB67C, 0xB935, 0xBC1E, 0xBF34, 0xC277, 0xC5E2, 0xC975,
        0xCD2D, 0xD107, 0xD501, 0xD917, 0xDD48, 0xE190, 0xE5ED, 0xEA5B, 0xEED8, 0xF361, 0xF7F2, 0xFC88, 0x0120, 0x05B8, 0x0A4C, 0x0ED9,
        0x135C, 0x17D2, 0x1C38, 0x208B, 0x24C8, 0x28ED, 0x2CF6, 0x30E0, 0x34A9, 0x384F, 0x3BD0, 0x3F27, 0x4255, 0x4555, 0x4827, 0x4AC8,
        0x4D37, 0x4F71, 0x5177, 0x5345, 0x54DB, 0x5638, 0x575B, 0x5843, 0x58EF, 0x5960, 0x5994, 0x598C, 0x5948, 0x58C7, 0x580B, 0x5713,
        0x55E1, 0x5475, 0x52D0, 0x50F3, 0x4EDF, 0x4C96, 0x4A1A, 0x476C, 0x448E, 0x4181, 0x3E48, 0x3AE6, 0x375B, 0x33AC, 0x2FD9, 0x2BE6,
        0x27D6, 0x23AB, 0x1F68, 0x1B0F, 0x16A5, 0x122B, 0x0DA5, 0x0915, 0x0480, 0xFFE8, 0xFB50, 0xF6BB, 0xF22C, 0xEDA6, 0xE92D, 0xE4C3,
        0xE06B, 0xDC29, 0xD7FF, 0xD3F0, 0xCFFE, 0xCC2D, 0xC87F, 0xC4F6, 0xC195, 0xBE5E, 0xBB54, 0xB877, 0xB5CB, 0xB351, 0xB10A, 0xAEF9,
        0xAD1E, 0xAB7B, 0xAA11, 0xA8E1, 0xA7EC, 0xA732, 0xA6B4, 0xA672, 0xA66D, 0xA6A3, 0xA716, 0xA7C5, 0xA8B0, 0xA9D5, 0xAB34, 0xACCD,
        0xAE9D, 0xB0A5, 0xB2E2, 0xB553, 0xB7F6, 0xBAC9, 0xBDCC, 0xC0FB, 0xC454, 0xC7D6, 0xCB7D, 0xCF48, 0xD334, 0xD73E, 0xDB63, 0xDFA1,
        0xE3F5, 0xE85C, 0xECD3, 0xF156, 0xF5E4, 0xFA78, 0xFF10, 0x03A8, 0x083E, 0x0CCF, 0x1157, 0x15D3, 0x1A41, 0x1E9D, 0x22E4, 0x2714,
        0x2B29, 0x2F22, 0x32FA, 0x36B1, 0x3A42, 0x3DAC, 0x40ED, 0x4402, 0x46E9, 0x49A0, 0x4C25, 0x4E78, 0x5095, 0x527C, 0x542C, 0x55A2,
        0x56DF, 0x57E2, 0x58A9, 0x5935, 0x5984, 0x5997, 0x596E, 0x5909, 0x5867, 0x578A, 0x5672, 0x551F, 0x5394, 0x51D0, 0x4FD4, 0x4DA3,
        0x4B3E, 0x48A6, 0x45DD, 0x42E5, 0x3FC0, 0x3C70, 0x38F7, 0x3558, 0x3195, 0x2DB0, 0x29AD, 0x258D, 0x2154, 0x1D05, 0x18A2, 0x142F,
        0x0FAE, 0x0B22, 0x068F, 0x01F8, 0xFD60, 0xF8C9, 0xF437, 0xEFAD, 0xEB2D, 0xE6BC, 0xE25C, 0xDE10, 0xD9DA, 0xD5BF, 0xD1C0, 0xCDE0,
        0xCA22, 0xC688, 0xC314, 0xBFCA, 0xBCAC, 0xB9BA, 0xB6F8, 0xB467, 0xB209, 0xAFE0, 0xADEC, 0xAC30, 0xAAAD, 0xA963, 0xA853, 0xA77E,
        0xA6E5, 0xA688, 0xA668, 0xA683, 0xA6DB, 0xA770, 0xA83F, 0xA94A, 0xAA90, 0xAC0F, 0xADC6, 0xAFB5, 0xB1DA, 0xB434, 0xB6C1, 0xB97F,
        0xBC6C, 0xBF88, 0xC2CE, 0xC63E, 0xC9D5, 0xCD90, 0xD16E, 0xD56A, 0xD984, 0xDDB7, 0xE201, 0xE660, 0xEAD0, 0xEF4E, 0xF3D8, 0xF869,
        0xFD00, 0x0198, 0x0630, 0x0AC3, 0x0F4F, 0x13D1, 0x1846, 0x1CAA, 0x20FB, 0x2536, 0x2957, 0x2D5D, 0x3144, 0x350A, 0x38AD, 0x3C29,
        0x3F7C, 0x42A5, 0x45A1, 0x486E, 0x4B0A, 0x4D73, 0x4FA9, 0x51A8, 0x5371, 0x5501, 0x5658, 0x5775, 0x5857, 0x58FE, 0x5968, 0x5996,
        0x5988, 0x593E, 0x58B7, 0x57F5, 0x56F7, 0x55BE, 0x544C, 0x52A1, 0x50BF, 0x4EA6, 0x4C58, 0x49D6, 0x4723, 0x4440, 0x412F, 0x3DF2,
        0x3A8B, 0x36FD, 0x3349, 0x2F73, 0x2B7E, 0x276A, 0x233D, 0x1EF7, 0x1A9D, 0x1630, 0x11B5, 0x0D2E, 0x089E, 0x0408, 0xFF70, 0xFAD8,
        0xF643, 0xF1B5, 0xED31, 0xE8B9, 0xE451, 0xDFFB, 0xDBBB, 0xD794, 0xD387, 0xCF99, 0xCBCB, 0xC821, 0xC49C, 0xC13F, 0xBE0D, 0xBB07,
        0xB82F, 0xB588, 0xB313, 0xB0D2, 0xAEC6, 0xACF1, 0xAB54, 0xA9F0, 0xA8C6, 0xA7D6, 0xA723, 0xA6AB, 0xA66F, 0xA66F, 0xA6AC, 0xA726,
        0xA7DB, 0xA8CB, 0xA9F6, 0xAB5C, 0xACFA, 0xAED0, 0xB0DD, 0xB31F, 0xB595, 0xB83D, 0xBB16, 0xBE1D, 0xC150, 0xC4AE, 0xC834, 0xCBDF,
        0xCFAD, 0xD39C, 0xD7A9, 0xDBD1, 0xE012, 0xE467, 0xE8D0, 0xED48, 0xF1CD, 0xF65B, 0xFAF0, 0xFF88, 0x0420, 0x08B6, 0x0D46, 0x11CD,
        0x1648, 0x1AB4, 0x1F0E, 0x2353, 0x2780, 0x2B93, 0x2F88, 0x335D, 0x3710, 0x3A9D, 0x3E03, 0x413F, 0x4450, 0x4732, 0x49E4, 0x4C64,
        0x4EB1, 0x50C9, 0x52AB, 0x5455, 0x55C5, 0x56FD, 0x57F9, 0x58BA, 0x5940, 0x5989, 0x5996, 0x5967, 0x58FB, 0x5853, 0x5770, 0x5652,
        0x54FA, 0x5368, 0x519E, 0x4F9E, 0x4D67, 0x4AFD, 0x4860, 0x4592, 0x4295, 0x3F6B, 0x3C17, 0x389A, 0x34F7, 0x3130, 0x2D49, 0x2942,
        0x2520, 0x20E5, 0x1C93, 0x182F, 0x13BA, 0x0F38, 0x0AAB, 0x0618, 0x0180, 0xFCE8, 0xF851, 0xF3C0, 0xEF37, 0xEAB9, 0xE649, 0xE1EB,
        0xDDA1, 0xD96E, 0xD555, 0xD159, 0xCD7C, 0xC9C2, 0xC62C, 0xC2BD, 0xBF77, 0xBC5D, 0xB970, 0xB6B3, 0xB427, 0xB1CE, 0xAFAA, 0xADBD,
        0xAC06, 0xAA88, 0xA944, 0xA83A, 0xA76C, 0xA6D9, 0xA682, 0xA668, 0xA68A, 0xA6E8, 0xA782, 0xA858, 0xA969, 0xAAB4, 0xAC39, 0xADF6,
        0xAFEB, 0xB215, 0xB474, 0xB706, 0xB9C9, 0xBCBB, 0xBFDB, 0xC326, 0xC69A, 0xCA35, 0xCDF4, 0xD1D4, 0xD5D4, 0xD9F0, 0xDE26, 0xE273,
        0xE6D3, 0xEB45, 0xEFC4, 0xF44F, 0xF8E1, 0xFD78, 0x0210, 0x06A7, 0x0B3A, 0x0FC6, 0x1446, 0x18B9, 0x1D1C, 0x216B, 0x25A3, 0x29C2,
        0x2DC5, 0x31A9, 0x356B, 0x390A, 0x3C82, 0x3FD1, 0x42F5, 0x45EC, 0x48B4, 0x4B4B, 0x4DAF, 0x4FDF, 0x51D9, 0x539C, 0x5527, 0x5678,
        0x578F, 0x586B, 0x590B, 0x5970, 0x5998, 0x5983, 0x5933, 0x58A6, 0x57DD, 0x56DA, 0x559B, 0x5423, 0x5273, 0x508B, 0x4E6C, 0x4C19,
        0x4992, 0x46DA, 0x43F2, 0x40DC, 0x3D9B, 0x3A30, 0x369E, 0x32E7, 0x2F0D, 0x2B14, 0x26FE, 0x22CE, 0x1E86, 0x1A2A, 0x15BC, 0x113F,
        0x0CB7, 0x0826, 0x0390, 0xFEF8, 0xFA60, 0xF5CC, 0xF13F, 0xECBB, 0xE845, 0xE3DE, 0xDF8B, 0xDB4D, 0xD729, 0xD31F, 0xCF34, 0xCB6A,
        0xC7C3, 0xC442, 0xC0EA, 0xBDBC, 0xBABA, 0xB7E7, 0xB545, 0xB2D6, 0xB09A, 0xAE93, 0xACC4, 0xAB2D, 0xA9CF, 0xA8AA, 0xA7C1, 0xA714,
        0xA6A2, 0xA66C, 0xA673, 0xA6B6, 0xA735, 0xA7F0, 0xA8E7, 0xAA18, 0xAB83, 0xAD27, 0xAF03, 0xB115, 0xB35D, 0xB5D8, 0xB886, 0xBB63,
        0xBE6F, 0xC1A6, 0xC508, 0xC892, 0xCC41, 0xD013, 0xD405, 0xD814, 0xDC3F, 0xE082, 0xE4DA, 0xE944, 0xEDBE, 0xF244, 0xF6D3, 0xFB68,
        0x0000, 0x0498, 0x092D, 0x0DBC, 0x1242, 0x16BC, 0x1B26, 0x1F7E, 0x23C1, 0x27EC, 0x2BFB, 0x2FED, 0x33BF, 0x376E, 0x3AF8, 0x3E5A,
        0x4191, 0x449D, 0x477A, 0x4A28, 0x4CA3, 0x4EEB, 0x50FD, 0x52D9, 0x547D, 0x55E8, 0x5719, 0x5810, 0x58CB, 0x594A, 0x598D, 0x5994,
        0x595E, 0x58EC, 0x583F, 0x5756, 0x5631, 0x54D3, 0x533C, 0x516D, 0x4F66, 0x4D2A, 0x4ABB, 0x4819, 0x4546, 0x4244, 0x3F16, 0x3BBE,
        0x383D, 0x3496, 0x30CC, 0x2CE1, 0x28D7, 0x24B3, 0x2075, 0x1C22, 0x17BB, 0x1345, 0x0EC1, 0x0A34, 0x05A0, 0x0108, 0xFC70, 0xF7DA,
        0xF349, 0xEEC1, 0xEA44, 0xE5D6, 0xE17A, 0xDD32, 0xD902, 0xD4EC, 0xD0F3, 0xCD19, 0xC962, 0xC5D0, 0xC265, 0xBF24, 0xBC0E, 0xB926,
        0xB66E, 0xB3E7, 0xB194, 0xAF75, 0xAD8D, 0xABDD, 0xAA65, 0xA926, 0xA823, 0xA75A, 0xA6CD, 0xA67D, 0xA668, 0xA690, 0xA6F5, 0xA795,
        0xA871, 0xA988, 0xAAD9, 0xAC64, 0xAE27, 0xB021, 0xB251, 0xB4B5, 0xB74C, 0xBA14, 0xBD0B, 0xC02F, 0xC37E, 0xC6F6, 0xCA95, 0xCE57,
        0xD23B, 0xD63E, 0xDA5D, 0xDE95, 0xE2E4, 0xE747, 0xEBBA, 0xF03A, 0xF4C6, 0xF959, 0xFDF0, 0x0288, 0x071F, 0x0BB1, 0x103C, 0x14BB,
        0x192D, 0x1D8D, 0x21DA, 0x2610, 0x2A2C, 0x2E2C, 0x320C, 0x35CB, 0x3966, 0x3CDA, 0x4025, 0x4345, 0x4637, 0x48FA, 0x4B8C, 0x4DEB,
        0x5015, 0x520A, 0x53C7, 0x554C, 0x5697, 0x57A8, 0x587E, 0x5918, 0x5976, 0x5998, 0x597E, 0x5927, 0x5894, 0x57C6, 0x56BC, 0x5578,
        0x53FA, 0x5243, 0x5056, 0x4E32, 0x4BD9, 0x494D, 0x4690, 0x43A3, 0x4089, 0x3D43, 0x39D4, 0x363E, 0x3284, 0x2EA7, 0x2AAB, 0x2692,
        0x225F, 0x1E15, 0x19B7, 0x1547, 0x10C9, 0x0C40, 0x07AF, 0x0318, 0xFE80, 0xF9E8, 0xF555, 0xF0C8, 0xEC46, 0xE7D1, 0xE36D, 0xDF1B,
        0xDAE0, 0xD6BE, 0xD2B7, 0xCED0, 0xCB09, 0xC766, 0xC3E9, 0xC095, 0xBD6B, 0xBA6E, 0xB7A0, 0xB503, 0xB299, 0xB062, 0xAE62, 0xAC98,
        0xAB06, 0xA9AE, 0xA890, 0xA7AD, 0xA705, 0xA699, 0xA66A, 0xA677, 0xA6C0, 0xA746, 0xA807, 0xA903, 0xAA3B, 0xABAB, 0xAD55, 0xAF37,
        0xB14F, 0xB39C, 0xB61C, 0xB8CE, 0xBBB0, 0xBEC1, 0xC1FD, 0xC563, 0xC8F0, 0xCCA3, 0xD078, 0xD46D, 0xD880, 0xDCAD, 0xE0F2, 0xE54C,
        0xE9B8, 0xEE33, 0xF2BA, 0xF74A, 0xFBE0, 0x0078, 0x0510, 0x09A5, 0x0E33, 0x12B8, 0x1730, 0x1B99, 0x1FEE, 0x242F, 0x2857, 0x2C64,
        0x3053, 0x3421, 0x37CC, 0x3B52, 0x3EB0, 0x41E3, 0x44EA, 0x47C3, 0x4A6B, 0x4CE1, 0x4F23, 0x5130, 0x5306, 0x54A4, 0x560A, 0x5735,
        0x5825, 0x58DA, 0x5954, 0x5991, 0x5991, 0x5955, 0x58DD, 0x582A, 0x573A, 0x5610, 0x54AC, 0x530F, 0x513A, 0x4F2E, 0x4CED, 0x4A78,
        0x47D1, 0x44F9, 0x41F3, 0x3EC1, 0x3B64, 0x37DF, 0x3435, 0x3067, 0x2C79, 0x286C, 0x2445, 0x2005, 0x1BAF, 0x1747, 0x12CF, 0x0E4B,
        0x09BD, 0x0528, 0x0090, 0xFBF8, 0xF762, 0xF2D2, 0xEE4B, 0xE9D0, 0xE563, 0xE109, 0xDCC3, 0xD896, 0xD482, 0xD08D, 0xCCB7, 0xC903,
        0xC575, 0xC20E, 0xBED1, 0xBBC0, 0xB8DD, 0xB62A, 0xB3A8, 0xB15A, 0xAF41, 0xAD5F, 0xABB4, 0xAA42, 0xA909, 0xA80B, 0xA749, 0xA6C2,
        0xA678, 0xA66A, 0xA698, 0xA702, 0xA7A9, 0xA88B, 0xA9A8, 0xAAFF, 0xAC8F, 0xAE58, 0xB057, 0xB28D, 0xB4F6, 0xB792, 0xBA5F, 0xBD5B,
        0xC084, 0xC3D7, 0xC753, 0xCAF6, 0xCEBC, 0xD2A3, 0xD6A9, 0xDACA, 0xDF05, 0xE356, 0xE7BA, 0xEC2F, 0xF0B1, 0xF53D, 0xF9D0, 0xFE68,
        0x0300, 0x0797, 0x0C28, 0x10B2, 0x1530, 0x19A0, 0x1DFF, 0x2249, 0x267C, 0x2A96, 0x2E92, 0x3270, 0x362B, 0x39C2, 0x3D32, 0x4078,
        0x4394, 0x4681, 0x493F, 0x4BCC, 0x4E26, 0x504B, 0x523A, 0x53F1, 0x5570, 0x56B6, 0x57C1, 0x5890, 0x5925, 0x597D, 0x5998, 0x5978,
        0x591B, 0x5882, 0x57AD, 0x569D, 0x5553, 0x53D0, 0x5214, 0x5020, 0x4DF7, 0x4B99, 0x4908, 0x4646, 0x4354, 0x4036, 0x3CEC, 0x3978,
        0x35DE, 0x3220, 0x2E40, 0x2A41, 0x2626, 0x21F0, 0x1DA4, 0x1944, 0x14D3, 0x1053, 0x0BC9, 0x0737, 0x02A0, 0xFE08, 0xF971, 0xF4DE,
        0xF052, 0xEBD1, 0xE75E, 0xE2FB, 0xDEAC, 0xDA73, 0xD653, 0xD250, 0xCE6B, 0xCAA8, 0xC709, 0xC390, 0xC040, 0xBD1B, 0xBA23, 0xB75A,
        0xB4C2, 0xB25D, 0xB02C, 0xAE30, 0xAC6C, 0xAAE1, 0xA98E, 0xA876, 0xA799, 0xA6F7, 0xA692, 0xA669, 0xA67C, 0xA6CB, 0xA757, 0xA81E,
        0xA921, 0xAA5E, 0xABD4, 0xAD84, 0xAF6B, 0xB188, 0xB3DB, 0xB660, 0xB917, 0xBBFE, 0xBF13, 0xC254, 0xC5BE, 0xC94F, 0xCD06, 0xD0DE,
        0xD4D7, 0xD8EC, 0xDD1C, 0xE163, 0xE5BF, 0xEA2D, 0xEEA9, 0xF331, 0xF7C2, 0xFC58, 0x00F0, 0x0588, 0x0A1C, 0x0EAA, 0x132D, 0x17A4,
        0x1C0B, 0x205F, 0x249D, 0x28C2, 0x2CCC, 0x30B8, 0x3483, 0x382A, 0x3BAC, 0x3F05, 0x4234, 0x4537, 0x480A, 0x4AAD, 0x4D1E, 0x4F5B,
        0x5163, 0x5333, 0x54CC, 0x562B, 0x5750, 0x583B, 0x58EA, 0x595D, 0x5993, 0x598E, 0x594C, 0x58CE, 0x5814, 0x571F, 0x55EF, 0x5485,
        0x52E2, 0x5107, 0x4EF6, 0x4CAF, 0x4A35, 0x4789, 0x44AC, 0x41A2, 0x3E6B, 0x3B0A, 0x3781, 0x33D3, 0x3002, 0x2C10, 0x2801, 0x23D7,
        0x1F95, 0x1B3D, 0x16D3, 0x125A, 0x0DD4, 0x0945, 0x04B0, 0x0018, 0xFB80, 0xF6EB, 0xF25B, 0xEDD5, 0xE95B, 0xE4F1, 0xE098, 0xDC55,
        0xD82A, 0xD41A, 0xD027, 0xCC54, 0xC8A5, 0xC51A, 0xC1B8, 0xBE7F, 0xBB72, 0xB894, 0xB5E6, 0xB36A, 0xB121, 0xAF0D, 0xAD30, 0xAB8B,
        0xAA1F, 0xA8ED, 0xA7F5, 0xA739, 0xA6B8, 0xA674, 0xA66C, 0xA6A0, 0xA711, 0xA7BD, 0xA8A5, 0xA9C8, 0xAB25, 0xACBB, 0xAE89, 0xB08F,
        0xB2C9, 0xB538, 0xB7D9, 0xBAAB, 0xBDAB, 0xC0D9, 0xC430, 0xC7B1, 0xCB57, 0xCF20, 0xD30A, 0xD713, 0xDB38, 0xDF75, 0xE3C8, 0xE82E,
        0xECA4, 0xF127, 0xF5B4, 0xFA48, 0xFEE0, 0x0378, 0x080E, 0x0C9F, 0x1128, 0x15A5, 0x1A13, 0x1E70, 0x22B8, 0x26E9, 0x2AFF, 0x2EF9,
        0x32D3, 0x368B, 0x3A1E, 0x3D89, 0x40CC, 0x43E2, 0x46CB, 0x4984, 0x4C0C, 0x4E60, 0x5080, 0x5269, 0x541B, 0x5594, 0x56D4, 0x57D9,
        0x58A2, 0x5930, 0x5982, 0x5998, 0x5971, 0x590E, 0x586F, 0x5794, 0x567E, 0x552E, 0x53A5, 0x51E3, 0x4FEA, 0x4DBB, 0x4B58, 0x48C2,
        0x45FB, 0x4305, 0x3FE2, 0x3C93, 0x391C, 0x357E, 0x31BD, 0x2DD9, 0x29D7, 0x25B9, 0x2181, 0x1D33, 0x18D1, 0x145E, 0x0FDD, 0x0B52,
        0x06BF, 0x0228, 0xFD90, 0xF8F9, 0xF466, 0xEFDC, 0xEB5C, 0xE6EA, 0xE289, 0xDE3C, 0xDA06, 0xD5E9, 0xD1E9, 0xCE08, 0xCA48, 0xC6AD,
        0xC338, 0xBFEC, 0xBCCB, 0xB9D8, 0xB714, 0xB481, 0xB221, 0xAFF5, 0xAE00, 0xAC41, 0xAABB, 0xA96F, 0xA85D, 0xA786, 0xA6EA, 0xA68B,
        0xA668, 0xA681, 0xA6D7, 0xA768, 0xA836, 0xA93E, 0xAA81, 0xABFE, 0xADB3, 0xAFA0, 0xB1C3, 0xB41A, 0xB6A5, 0xB961, 0xBC4D, 0xBF66,
        0xC2AB, 0xC648, 0xCA06, 0xCDE2, 0xD1DA, 0xD5EB, 0xDA12, 0xDE4B, 0xE295, 0xE6EB, 0xEB4C, 0xEFB3, 0xF41E, 0xF88A, 0xFCF4, 0x0157,
        0x05B3, 0x0A05, 0x0E48, 0x127A, 0x1699, 0x1AA2, 0x1E93, 0x2267, 0x261F, 0x29B6, 0x2D2B, 0x307B, 0x33A5, 0x36A7, 0x397F, 0x3C2B,
        0x3EA9, 0x40FA, 0x431A, 0x4509, 0x46C6, 0x4850, 0x49A7, 0x4AC9, 0x4BB7, 0x4C70, 0x4CF4, 0x4D43, 0x4D5D, 0x4D43, 0x4CF4, 0x4C73,
        0x4BBE, 0x4AD7, 0x49BF, 0x4878, 0x4701, 0x455D, 0x438D, 0x4193, 0x3F70, 0x3D25, 0x3AB6, 0x3823, 0x356F, 0x329B, 0x2FAB, 0x2CA0,
        0x297C, 0x2641, 0x22F3, 0x1F93, 0x1C25, 0x18A9, 0x1523, 0x1196, 0x0E03, 0x0A6E, 0x06D8, 0x0344, 0xFFB6, 0xFC2E, 0xF8AF, 0xF53C,
        0xF1D7, 0xEE82, 0xEB3F, 0xE810, 0xE4F8, 0xE1F8, 0xDF12, 0xDC49, 0xD99D, 0xD710, 0xD4A3, 0xD259, 0xD033, 0xCE31, 0xCC55, 0xCA9F,
        0xC912, 0xC7AC, 0xC66F, 0xC55C, 0xC473, 0xC3B4, 0xC320, 0xC2B6, 0xC276, 0xC260, 0xC275, 0xC2B3, 0xC31A, 0xC3AA, 0xC461, 0xC53F,
        0xC644, 0xC76D, 0xC8BA, 0xCA2B, 0xCBBC, 0xCD6E, 0xCF3E, 0xD12C, 0xD335, 0xD559, 0xD795, 0xD9E7, 0xDC4E, 0xDEC9, 0xE154, 0xE3EF,
        0xE697, 0xE94B, 0xEC08, 0xEECD, 0xF198, 0xF466, 0xF735, 0xFA05, 0xFCD2, 0xFF9B, 0x025D, 0x0519, 0x07CA, 0x0A71, 0x0D0A, 0x0F95,
        0x120F, 0x1477, 0x16CC, 0x190C, 0x1B36, 0x1D48, 0x1F42, 0x2122, 0x22E7, 0x2490, 0x261C, 0x278B, 0x28DB, 0x2A0D, 0x2B1F, 0x2C11,
        0x2CE3, 0x2D95, 0x2E26, 0x2E96, 0x2EE5, 0x2F14, 0x2F22, 0x2F10, 0x2EDE, 0x2E8D, 0x2E1D, 0x2D8E, 0x2CE2, 0x2C19, 0x2B34, 0x2A34,
        0x291A, 0x27E6, 0x269A, 0x2538, 0x23BF, 0x2232, 0x2091, 0x1EDF, 0x1D1C, 0x1B49, 0x1969, 0x177C, 0x1585, 0x1383, 0x117A, 0x0F6A,
        0x0D56, 0x0B3D, 0x0923, 0x0708, 0x04EE, 0x02D6, 0x00C2, 0xFEB4, 0xFCAB, 0xFAAB, 0xF8B3, 0xF6C6, 0xF4E5, 0xF310, 0xF149, 0xEF92,
        0xEDEA, 0xEC53, 0xEACF, 0xE95D, 0xE7FF, 0xE6B5, 0xE580, 0xE460, 0xE357, 0xE264, 0xE189, 0xE0C5, 0xE018, 0xDF83, 0xDF06, 0xDEA1,
        0xDE54, 0xDE20, 0xDE03, 0xDDFD, 0xDE0F, 0xDE38, 0xDE78, 0xDECD, 0xDF39, 0xDFBA, 0xE04F, 0xE0F8, 0xE1B5, 0xE284, 0xE364, 0xE456,
        0xE557, 0xE667, 0xE786, 0xE8B2, 0xE9EA, 0xEB2D, 0xEC7B, 0xEDD1, 0xEF30, 0xF096, 0xF202, 0xF372, 0xF4E7, 0xF65E, 0xF7D7, 0xF950,
        0xFAC9, 0xFC41, 0xFDB6, 0xFF28, 0x0094, 0x01FC, 0x035E, 0x04B8, 0x060A, 0x0754, 0x0894, 0x09C9, 0x0AF4, 0x0C12, 0x0D25, 0x0E2A,
        0x0F22, 0x100B, 0x10E6, 0x11B3, 0x1270, 0x131D, 0x13BB, 0x1449, 0x14C7, 0x1534, 0x1591, 0x15DE, 0x161A, 0x1646, 0x1662, 0x166E,
        0x166A, 0x1657, 0x1634, 0x1603, 0x15C3, 0x1575, 0x1519, 0x14B0, 0x143A, 0x13B8, 0x132B, 0x1292, 0x11EF, 0x1142, 0x108C, 0x0FCE,
        0x0F08, 0x0E3A, 0x0D66, 0x0C8D, 0x0BAE, 0x0ACB, 0x09E5, 0x08FB, 0x080F, 0x0722, 0x0635, 0x0547, 0x0459, 0x036D, 0x0283, 0x019C,
        0x00B7, 0xFFD8, 0xFEFB, 0xFE24, 0xFD52, 0xFC86, 0xFBC0, 0xFB01, 0xFA4A, 0xF99A, 0xF8F2, 0xF852, 0xF7BC, 0xF72E, 0xF6A9, 0xF62D,
        0xF5BC, 0xF553, 0xF4F5, 0xF4A1, 0xF456, 0xF415, 0xF3DF, 0xF3B2, 0xF38F, 0xF376, 0xF366, 0xF360, 0xF363, 0xF36F, 0xF383, 0xF3A1,
        0xF3C6, 0xF3F4, 0xF429, 0xF466, 0xF4AA, 0xF4F4, 0xF544, 0xF59B, 0xF5F7, 0xF658, 0xF6BD, 0xF727, 0xF794, 0xF805, 0xF879, 0xF8F0,
        0xF968, 0xF9E3, 0xFA5E, 0xFADB, 0xFB57, 0xFBD4, 0xFC51, 0xFCCC, 0xFD47, 0xFDC0, 0xFE37, 0xFEAC, 0xFF1F, 0xFF8F, 0xFFFC, 0x0065,
        0x00CB, 0x012D, 0x018B, 0x01E6, 0x023B, 0x028C, 0x02D9, 0x0321, 0x0364, 0x03A2, 0x03DB, 0x040F, 0x043E, 0x0468, 0x048C, 0x04AC,
        0x04C7, 0x04DD, 0x04EE, 0x04FB, 0x0503, 0x0506, 0x0505, 0x0500, 0x04F7, 0x04EA, 0x04DA, 0x04C6, 0x04AF, 0x0494, 0x0477, 0x0458,
        0x0435, 0x0411, 0x03EB, 0x03C3, 0x0399, 0x036F, 0x0343, 0x0316, 0x02E9, 0x02BB, 0x028D, 0x025F, 0x0232, 0x0205, 0x01D8, 0x01AC,
        0x0181, 0x0157, 0x012E, 0x0106, 0x00E0, 0x00BC, 0x0099, 0x0078, 0x0058, 0x003B, 0x001F, 0x0006, 0xFFEF, 0xFFDA, 0xFFC6, 0xFFB5,
        0xFFA6, 0xFF98, 0xFF8D, 0xFF83, 0xFF7B, 0xFF76, 0xFF71, 0xFF6F, 0xFF6E, 0xFF6E, 0xFF70, 0xFF73, 0xFF77, 0xFF7D, 0xFF83, 0xFF8A,
        0xFF91, 0xFF9A, 0xFFA2, 0xFFAB, 0xFFB4, 0xFFBD, 0xFFC7, 0xFFD0, 0xFFD8, 0xFFE0, 0xFFE8, 0xFFEF, 0xFFF5, 0xFFFA, 0xFFFE, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFA, 0xFFF8, 0xFFF7, 0xFFF5, 0xFFF3, 0xFFF1, 0xFFEF, 0xFFEE,
        0xFFED, 0xFFEC, 0xFFEC, 0xFFED, 0xFFEF, 0xFFF1, 0xFFF4, 0xFFF8, 0xFFFE, 0x0003, 0x000A, 0x0012, 0x001B, 0x0025, 0x0030, 0x003B,
        0x0047, 0x0053, 0x005F, 0x006B, 0x0077, 0x0083, 0x008D, 0x0097, 0x009F, 0x00A6, 0x00AB, 0x00AE, 0x00AF, 0x00AE, 0x00AA, 0x00A3,
        0x0099, 0x008C, 0x007C, 0x006A, 0x0054, 0x003C, 0x0020, 0x0003, 0xFFE4, 0xFFC2, 0xFF9E, 0xFF79, 0xFF53, 0xFF2D, 0xFF07, 0xFEE1,
        0xFEBC, 0xFE9A, 0xFE79, 0xFE5B, 0xFE40, 0xFE2A, 0xFE17, 0xFE09, 0xFE01, 0xFDFF, 0xFE02, 0xFE0B, 0xFE1C, 0xFE32, 0xFE50, 0xFE74,
        0xFE9E, 0xFECF, 0xFF06, 0xFF43, 0xFF85, 0xFFCC, 0x0015, 0x0063, 0x00B3, 0x0105, 0x0158, 0x01AB, 0x01FC, 0x024B, 0x0297, 0x02DF,
        0x0321, 0x035D, 0x0392, 0x03BE, 0x03E2, 0x03FB, 0x040A, 0x040E, 0x0407, 0x03F3, 0x03D3, 0x03A7, 0x036F, 0x032B, 0x02DB, 0x0280,
        0x021A, 0x01AB, 0x0133, 0x00B3, 0x002D, 0xFFA2, 0xFF13, 0xFE81, 0xFDEF, 0xFD5D, 0xFCCE, 0xFC44, 0xFBBF, 0xFB43, 0xFACF, 0xFA67,
        0xFA0B, 0xF9BD, 0xF97F, 0xF951, 0xF934, 0xF92A, 0xF932, 0xF94E, 0xF97E, 0xF9C2, 0xFA19, 0xFA83, 0xFB00, 0xFB8F, 0xFC2E, 0xFCDC,
        0xFD99, 0xFE61, 0xFF34, 0x000D, 0x00EE, 0x01D1, 0x02B7, 0x039A, 0x047A, 0x0553, 0x0623, 0x06E7, 0x079E, 0x0843, 0x08D6, 0x0954,
        0x09BB, 0x0A0A, 0x0A3E, 0x0A58, 0x0A55, 0x0A35, 0x09F8, 0x099E, 0x0927, 0x0894, 0x07E5, 0x071C, 0x063B, 0x0543, 0x0436, 0x0318,
        0x01EA, 0x00B1, 0xFF6F, 0xFE26, 0xFCDB, 0xFB91, 0xFA4D, 0xF910, 0xF7E0, 0xF6C0, 0xF5B4, 0xF4BD, 0xF3E1, 0xF322, 0xF282, 0xF204,
        0xF1AA, 0xF175, 0xF168, 0xF183, 0xF1C6, 0xF232, 0xF2C7, 0xF383, 0xF465, 0xF56C, 0xF695, 0xF7DE, 0xF945, 0xFAC4, 0xFC5A, 0xFE02,
        0xFFB8, 0x0176, 0x033A, 0x04FD, 0x06BB, 0x086F, 0x0A15, 0x0BA6, 0x0D1F, 0x0E7B, 0x0FB5, 0x10CB, 0x11B7, 0x1276, 0x1306, 0x1365,
        0x1390, 0x1386, 0x1346, 0x12D0, 0x1225, 0x1144, 0x1030, 0x0EEB, 0x0D77, 0x0BD7, 0x0A10, 0x0825, 0x061C, 0x03F9, 0x01C2, 0xFF7D,
        0xFD2F, 0xFADE, 0xF892, 0xF651, 0xF420, 0xF207, 0xF00B, 0xEE33, 0xEC83, 0xEB02, 0xE9B5, 0xE89F, 0xE7C4, 0xE729, 0xE6CF, 0xE6B9,
        0xE6E8, 0xE75C, 0xE815, 0xE913, 0xEA53, 0xEBD4, 0xED92, 0xEF89, 0xF1B5, 0xF411, 0xF697, 0xF940, 0xFC05, 0xFEE1, 0x01C9, 0x04B9,
        0x07A7, 0x0A8B, 0x0D5D, 0x1015, 0x12AC, 0x1519, 0x1755, 0x195A, 0x1B21, 0x1CA5, 0x1DE0, 0x1ECD, 0x1F6A, 0x1FB3, 0x1FA7, 0x1F44,
        0x1E8B, 0x1D7B, 0x1C17, 0x1A61, 0x185D, 0x1610, 0x137E, 0x10AE, 0x0DA7, 0x0A70, 0x0711, 0x0393, 0x0000, 0xFC61, 0xF8BE, 0xF523,
        0xF19A, 0xEE2B, 0xEAE2, 0xE7C7, 0xE4E4, 0xE241, 0xDFE7, 0xDDDC, 0xDC28, 0xDAD0, 0xD9D8, 0xD946, 0xD91B, 0xD95A, 0xDA03, 0xDB16,
        0xDC91, 0xDE71, 0xE0B2, 0xE351, 0xE645, 0xE98A, 0xED15, 0xF0E0, 0xF4E0, 0xF90A, 0xFD55, 0x01B3, 0x061C, 0x0A81, 0x0ED7, 0x1312,
        0x1727, 0x1B08, 0x1EAC, 0x2208, 0x2511, 0x27BE, 0x2A08, 0x2BE5, 0x2D51, 0x2E45, 0x2EBF, 0x2EBB, 0x2E37, 0x2D34, 0x2BB3, 0x29B7,
        0x2743, 0x245D, 0x210C, 0x1D57, 0x1948, 0x14E8, 0x1042, 0x0B63, 0x0657, 0x012C, 0xFBEF, 0xF6AE, 0xF177, 0xEC58, 0xE761, 0xE29F,
        0xDE1F, 0xD9EF, 0xD61B, 0xD2AE, 0xCFB3, 0xCD33, 0xCB36, 0xC9C3, 0xC8E0, 0xC891, 0xC8D7, 0xC9B4, 0xCB26, 0xCD2D, 0xCFC3, 0xD2E3,
        0xD686, 0xDAA4, 0xDF33, 0xE426, 0xE973, 0xEF0B, 0xF4DF, 0xFAE2, 0x0101, 0x072E, 0x0D59, 0x136F, 0x1960, 0x1F1B, 0x2491, 0x29B2,
        0x2E6E, 0x32B9, 0x3684, 0x39C6, 0x3C73, 0x3E82, 0x3FED, 0x40AD, 0x40C0, 0x4024, 0x3ED7, 0x3CDC, 0x3A38, 0x36EE, 0x3307, 0x2E8C,
        0x2988, 0x2406, 0x1E14, 0x17C3, 0x1121, 0x0A41, 0x0334, 0xFC0E, 0xF4E0, 0xEDBF, 0xE6BF, 0xDFF2, 0xD96B, 0xD33E, 0xCD7C, 0xC835,
        0xC378, 0xBF55, 0xBBD8, 0xB90B, 0xB6F8, 0xB5A7, 0xB51C, 0xB55B, 0xB666, 0xB83B, 0xBAD6, 0xBE34, 0xC24C, 0xC715, 0xCC83, 0xD289,
        0xD919, 0xE022, 0xE791, 0xEF53, 0xF755, 0xFF80, 0x07BE, 0x0FFA, 0x181E, 0x2013, 0x27C3, 0x2F18, 0x35FE, 0x3C60, 0x422D, 0x4754,
        0x4BC4, 0x4F71, 0x524F, 0x5453, 0x5577, 0x55B6, 0x550D, 0x537C, 0x5105, 0x4DAD, 0x497B, 0x4478, 0x3EB1, 0x3834, 0x3110, 0x2957,
        0x20FB, 0x1846, 0x0F4F, 0x0630, 0xFD00, 0xF3D8, 0xEAD0, 0xE201, 0xD984, 0xD16E, 0xC9D5, 0xC2CE, 0xBC6C, 0xB6C1, 0xB1DA, 0xADC6,
        0xAA90, 0xA83F, 0xA6DB, 0xA668, 0xA6E5, 0xA853, 0xAAAD, 0xADEC, 0xB209, 0xB6F8, 0xBCAC, 0xC314, 0xCA22, 0xD1C0, 0xD9DA, 0xE25C,
        0xEB2D, 0xF437, 0xFD60, 0x068F, 0x0FAE, 0x18A2, 0x2154, 0x29AD, 0x3195, 0x38F7, 0x3FC0, 0x45DD, 0x4B3E, 0x4FD4, 0x5394, 0x5672,
        0x5867, 0x596E, 0x5984, 0x58A9, 0x56DF, 0x542C, 0x5095, 0x4C25, 0x46E9, 0x40ED, 0x3A42, 0x32FA, 0x2B29, 0x22E4, 0x1A41, 0x1157,
        0x083E, 0xFF10, 0xF5E4, 0xECD3, 0xE3F5, 0xDB63, 0xD334, 0xCB7D, 0xC454, 0xBDCC, 0xB7F6, 0xB2E2, 0xAE9D, 0xAB34, 0xA8B0, 0xA716,
        0xA66D, 0xA6B4, 0xA7EC, 0xAA11, 0xAD1E, 0xB10A, 0xB5CB, 0xBB54, 0xC195, 0xC87F, 0xCFFE, 0xD7FF, 0xE06B, 0xE92D, 0xF22C, 0xFB50,
        0x0480, 0x0DA5, 0x16A5, 0x1F68, 0x27D6, 0x2FD9, 0x375B, 0x3E48, 0x448E, 0x4A1A, 0x4EDF, 0x52D0, 0x55E1, 0x580B, 0x5948, 0x5994,
        0x58EF, 0x575B, 0x54DB, 0x5177, 0x4D37, 0x4827, 0x4255, 0x3BD0, 0x34A9, 0x2CF6, 0x24C8, 0x1C38, 0x135C, 0x0A4C, 0x0120, 0xF7F2,
        0xEED8, 0xE5ED, 0xDD48, 0xD501, 0xCD2D, 0xC5E2, 0xBF34, 0xB935, 0xB3F4, 0xAF80, 0xABE5, 0xA92C, 0xA75E, 0xA67E, 0xA68F, 0xA791,
        0xA982, 0xAC5B, 0xB016, 0xB4A8, 0xBA05, 0xC01E, 0xC6E4, 0xCE43, 0xD629, 0xDE7F, 0xE72F, 0xF023, 0xF941, 0x0270, 0x0B9A, 0x14A4,
        0x1D77, 0x25FA, 0x2E17, 0x35B8, 0x3CC8, 0x4335, 0x48EC, 0x4DDF, 0x5200, 0x5545, 0x57A3, 0x5916, 0x5998, 0x5929, 0x57CA, 0x557F,
        0x524D, 0x4E3D, 0x495B, 0x43B3, 0x3D55, 0x3651, 0x2EBC, 0x26A8, 0x1E2C, 0x155F, 0x0C58, 0x0330, 0xFA00, 0xF0E0, 0xE7E8, 0xDF32,
        0xD6D3, 0xCEE4, 0xC779, 0xC0A6, 0xBA7D, 0xB510, 0xB06D, 0xACA1, 0xA9B5, 0xA7B1, 0xA69B, 0xA676, 0xA742, 0xA8FE, 0xABA3, 0xAF2C,
        0xB38F, 0xB8C0, 0xBEB0, 0xC551, 0xCC8F, 0xD458, 0xDC97, 0xE535, 0xEE1C, 0xF732, 0x0060, 0x098D, 0x12A0, 0x1B82, 0x2419, 0x2C4F,
        0x340E, 0x3B40, 0x41D3, 0x47B4, 0x4CD5, 0x5126, 0x549D, 0x572F, 0x58D7, 0x5990, 0x5957, 0x582E, 0x5617, 0x5318, 0x4F3A, 0x4A86,
        0x4509, 0x3ED2, 0x37F2, 0x307B, 0x2882, 0x201B, 0x175E, 0x0E62, 0x0540, 0xFC10, 0xF2EA, 0xE9E7, 0xE11F, 0xD8AB, 0xD0A1, 0xC916,
        0xC220, 0xBBD0, 0xB637, 0xB166, 0xAD68, 0xAA48, 0xA810, 0xA6C5, 0xA669, 0xA700, 0xA886, 0xAAF7, 0xAE4E, 0xB281, 0xB784, 0xBD4B,
        0xC3C5, 0xCAE2, 0xD28E, 0xDAB4, 0xE33F, 0xEC17, 0xF525, 0xFE50, 0x077F, 0x109A, 0x1989, 0x2233, 0x2A81, 0x325C, 0x39B0, 0x4068,
        0x4673, 0x4BBF, 0x5040, 0x53E9, 0x56B0, 0x588D, 0x597B, 0x5979, 0x5885, 0x56A4, 0x53D8, 0x502B, 0x4BA6, 0x4655, 0x4046, 0x398B,
        0x3234, 0x2A56, 0x2206, 0x195B, 0x106B, 0x074F, 0xFE20, 0xF4F5, 0xEBE8, 0xE312, 0xDA89, 0xD265, 0xCABC, 0xC3A2, 0xBD2B, 0xB768,
        0xB269, 0xAE3A, 0xAAE8, 0xA87B, 0xA6FA, 0xA669, 0xA6C9, 0xA819, 0xAA57, 0xAD7A, 0xB17D, 0xB653, 0xBBEF, 0xC242, 0xC93C, 0xD0CA,
        0xD8D6, 0xE14D, 0xEA15, 0xF319, 0xFC40, 0x0570, 0x0E92, 0x178D, 0x2048, 0x28AD, 0x30A4, 0x3817, 0x3EF4, 0x4527, 0x4AA0, 0x4F50,
        0x532A, 0x5624, 0x5836, 0x595B, 0x598F, 0x58D1, 0x5724, 0x548D, 0x5111, 0x4CBC, 0x4797, 0x41B2, 0x3B1C, 0x33E6, 0x2C25, 0x23ED,
        0x1B54, 0x1271, 0x095D, 0x0030, 0xF703, 0xEDED, 0xE508, 0xDC6B, 0xD42F, 0xCC68, 0xC52C, 0xBE8F, 0xB8A3, 0xB376, 0xAF18, 0xAB93,
        0xA8F2, 0xA73C, 0xA674, 0xA69E, 0xA7B9, 0xA9C2, 0xACB2, 0xB084, 0xB52B, 0xBA9C, 0xC0C8, 0xC79E, 0xCF0C, 0xD6FE, 0xDF5E, 0xE817,
        0xF10F, 0xFA30, 0x0360, 0x0C88, 0x158D, 0x1E59, 0x26D3, 0x2EE4, 0x3678, 0x3D78, 0x43D3, 0x4977, 0x4E55, 0x5260, 0x558D, 0x57D4,
        0x592E, 0x5998, 0x5911, 0x5799, 0x5536, 0x51ED, 0x4DC7, 0x48D0, 0x4315, 0x3CA5, 0x3592, 0x2DEE, 0x25CF, 0x1D49, 0x1475, 0x0B6A,
        0x0240, 0xF911, 0xEFF3, 0xE701, 0xDE53, 0xD5FE, 0xCE1B, 0xC6BF, 0xBFFD, 0xB9E7, 0xB48E, 0xB000, 0xAC4A, 0xA975, 0xA78A, 0xA68C,
        0xA680, 0xA765, 0xA938, 0xABF5, 0xAF95, 0xB40D, 0xB952, 0xBF56, 0xC607, 0xCD55, 0xD52B, 0xDD74, 0xE61B, 0xEF07, 0xF821, 0x0150,
        0x0A7C, 0x138B, 0x1C66, 0x24F4, 0x2D1F, 0x34D0, 0x3BF3, 0x4275, 0x4843, 0x4D4F, 0x518B, 0x54EA, 0x5765, 0x58F5, 0x5995, 0x5944,
        0x5802, 0x55D3, 0x52BD, 0x4EC8, 0x49FF, 0x446F, 0x3E26, 0x3735, 0x2FB0, 0x27AB, 0x1F3B, 0x1676, 0x0D75, 0x0450, 0xFB20, 0xF1FC,
        0xE8FE, 0xE03E, 0xD7D4, 0xCFD6, 0xC859, 0xC173, 0xBB35, 0xB5B0, 0xB0F3, 0xAD0C, 0xAA04, 0xA7E3, 0xA6B0, 0xA66E, 0xA71C, 0xA8BB,
        0xAB44, 0xAEB2, 0xB2FA, 0xB812, 0xBDEC, 0xC478, 0xCBA4, 0xD35E, 0xDB8F, 0xE423, 0xED02, 0xF614, 0xFF40, 0x086E, 0x1186, 0x1A6F,
        0x2310, 0x2B54, 0x3322, 0x3A67, 0x410E, 0x4706, 0x4C3F, 0x50AA, 0x543C, 0x56EB, 0x58B0, 0x5986, 0x596B, 0x585F, 0x5665, 0x5382,
        0x4FBF, 0x4B24, 0x45BF, 0x3F9E, 0x38D2, 0x316D, 0x2982, 0x2128, 0x1874, 0x0F7F, 0x065F, 0xFD30, 0xF407, 0xEAFF, 0xE22F, 0xD9AF,
        0xD197, 0xC9FB, 0xC2F1, 0xBC8C, 0xB6DC, 0xB1F2, 0xADD9, 0xAA9E, 0xA849, 0xA6E0, 0xA668, 0xA6E0, 0xA849, 0xAA9E, 0xADD9, 0xB1F2,
        0xB6DC, 0xBC8C, 0xC2F1, 0xC9FB, 0xD197, 0xD9AF, 0xE22F, 0xEAFF, 0xF407, 0xFD30, 0x065F, 0x0F7F, 0x1874, 0x2128, 0x2982, 0x316D,
        0x38D2, 0x3F9E, 0x45BF, 0x4B24, 0x4FBF, 0x5382, 0x5665, 0x585F, 0x596B, 0x5986, 0x58B0, 0x56EB, 0x543C, 0x50AA, 0x4C3F, 0x4706,
        0x410E, 0x3A67, 0x3322, 0x2B54, 0x2310, 0x1A6F, 0x1186, 0x086E, 0xFF40, 0xF614, 0xED02, 0xE423, 0xDB8F, 0xD35E, 0xCBA4, 0xC478,
        0xBDEC, 0xB812, 0xB2FA, 0xAEB2, 0xAB44, 0xA8BB, 0xA71C, 0xA66E, 0xA6B0, 0xA7E3, 0xAA04, 0xAD0C, 0xB0F3, 0xB5B0, 0xBB35, 0xC173,
        0xC859, 0xCFD6, 0xD7D4, 0xE03E, 0xE8FE, 0xF1FC, 0xFB20, 0x0450, 0x0D75, 0x1676, 0x1F3B, 0x27AB, 0x2FB0, 0x3735, 0x3E26, 0x446F,
        0x49FF, 0x4EC8, 0x52BD, 0x55D3, 0x5802, 0x5944, 0x5995, 0x58F5, 0x5765, 0x54EA, 0x518B, 0x4D4F, 0x4843, 0x4275, 0x3BF3, 0x34D0,
        0x2D1F, 0x24F4, 0x1C66, 0x138B, 0x0A7C, 0x0150, 0xF821, 0xEF07, 0xE61B, 0xDD74, 0xD52B, 0xCD55, 0xC607, 0xBF56, 0xB952, 0xB40D,
        0xAF95, 0xABF5, 0xA938, 0xA765, 0xA680, 0xA68C, 0xA78A, 0xA975, 0xAC4A, 0xB000, 0xB48E, 0xB9E7, 0xBFFD, 0xC6BF, 0xCE1B, 0xD5FE,
        0xDE53, 0xE701, 0xEFF3, 0xF911, 0x0240, 0x0B6A, 0x1475, 0x1D49, 0x25CF, 0x2DEE, 0x3592, 0x3CA5, 0x4315, 0x48D0, 0x4DC7, 0x51ED,
        0x5536, 0x5799, 0x5911, 0x5998, 0x592E, 0x57D4, 0x558D, 0x5260, 0x4E55, 0x4977, 0x43D3, 0x3D78, 0x3678, 0x2EE4, 0x26D3, 0x1E59,
        0x158D, 0x0C88, 0x0360, 0xFA30, 0xF10F, 0xE817, 0xDF5E, 0xD6FE, 0xCF0C, 0xC79E, 0xC0C8, 0xBA9C, 0xB52B, 0xB084, 0xACB2, 0xA9C2,
        0xA7B9, 0xA69E, 0xA674, 0xA73C, 0xA8F2, 0xAB93, 0xAF18, 0xB376, 0xB8A3, 0xBE8F, 0xC52C, 0xCC68, 0xD42F, 0xDC6B, 0xE508, 0xEDED,
        0xF703, 0x0030, 0x095D, 0x1271, 0x1B54, 0x23ED, 0x2C25, 0x33E6, 0x3B1C, 0x41B2, 0x4797, 0x4CBC, 0x5111, 0x548D, 0x5724, 0x58D1,
        0x598F, 0x595B, 0x5836, 0x5624, 0x532A, 0x4F50, 0x4AA0, 0x4527, 0x3EF4, 0x3817, 0x30A4, 0x28AD, 0x2048, 0x178D, 0x0E92, 0x0570,
        0xFC40, 0xF319, 0xEA15, 0xE14D, 0xD8D6, 0xD0CA, 0xC93C, 0xC242, 0xBBEF, 0xB653, 0xB17D, 0xAD7A, 0xAA57, 0xA819, 0xA6C9, 0xA669,
        0xA6FA, 0xA87B, 0xAAE8, 0xAE3A, 0xB269, 0xB768, 0xBD2B, 0xC3A2, 0xCABC, 0xD265, 0xDA89, 0xE312, 0xEBE8, 0xF4F5, 0xFE20, 0x074F,
        0x106B, 0x195B, 0x2206, 0x2A56, 0x3234, 0x398B, 0x4046, 0x4655, 0x4BA6, 0x502B, 0x53D8, 0x56A4, 0x5885, 0x5979, 0x597B, 0x588D,
        0x56B0, 0x53E9, 0x5040, 0x4BBF, 0x4673, 0x4068, 0x39B0, 0x325C, 0x2A81, 0x2233, 0x1989, 0x109A, 0x077F, 0xFE50, 0xF525, 0xEC17,
        0xE33F, 0xDAB4, 0xD28E, 0xCAE2, 0xC3C5, 0xBD4B, 0xB784, 0xB281, 0xAE4E, 0xAAF7, 0xA886, 0xA700, 0xA669, 0xA6C5, 0xA810, 0xAA48,
        0xAD68, 0xB166, 0xB637, 0xBBD0, 0xC220, 0xC916, 0xD0A1, 0xD8AB, 0xE11F, 0xE9E7, 0xF2EA, 0xFC10, 0x0540, 0x0E62, 0x175E, 0x201B,
        0x2882, 0x307B, 0x37F2, 0x3ED2, 0x4509, 0x4A86, 0x4F3A, 0x5318, 0x5617, 0x582E, 0x5957, 0x5990, 0x58D7, 0x572F, 0x549D, 0x5126,
        0x4CD5, 0x47B4, 0x41D3, 0x3B40, 0x340E, 0x2C4F, 0x2419, 0x1B82, 0x12A0, 0x098D, 0x0060, 0xF732, 0xEE1C, 0xE535, 0xDC97, 0xD458,
        0xCC8F, 0xC551, 0xBEB0, 0xB8C0, 0xB38F, 0xAF2C, 0xABA3, 0xA8FE, 0xA742, 0xA676, 0xA69B, 0xA7B1, 0xA9B5, 0xACA1, 0xB06D, 0xB510,
        0xBA7D, 0xC0A6, 0xC779, 0xCEE4, 0xD6D3, 0xDF32, 0xE7E8, 0xF0E0, 0xFA00, 0x0330, 0x0C58, 0x155F, 0x1E2C, 0x26A8, 0x2EBC, 0x3651,
        0x3D55, 0x43B3, 0x495B, 0x4E3D, 0x524D, 0x557F, 0x57CA, 0x5929, 0x5998, 0x5916, 0x57A3, 0x5545, 0x5200, 0x4DDF, 0x48EC, 0x4335,
        0x3CC8, 0x35B8, 0x2E17, 0x25FA, 0x1D77, 0x14A4, 0x0B9A, 0x0270, 0xF941, 0xF023, 0xE72F, 0xDE7F, 0xD629, 0xCE43, 0xC6E4, 0xC01E,
        0xBA05, 0xB4A8, 0xB016, 0xAC5B, 0xA982, 0xA791, 0xA68F, 0xA67E, 0xA75E, 0xA92C, 0xABE5, 0xAF80, 0xB3F4, 0xB935, 0xBF34, 0xC5E2,
        0xCD2D, 0xD501, 0xDD48, 0xE5ED, 0xEED8, 0xF7F2, 0x0120, 0x0A4C, 0x135C, 0x1C38, 0x24C8, 0x2CF6, 0x34A9, 0x3BD0, 0x4255, 0x4827,
        0x4D37, 0x5177, 0x54DB, 0x575B, 0x58EF, 0x5994, 0x5948, 0x580B, 0x55E1, 0x52D0, 0x4EDF, 0x4A1A, 0x448E, 0x3E48, 0x375B, 0x2FD9,
        0x27D6, 0x1F68, 0x16A5, 0x0DA5, 0x0480, 0xFB50, 0xF22C, 0xE92D, 0xE06B, 0xD7FF, 0xCFFE, 0xC87F, 0xC195, 0xBB54, 0xB5CB, 0xB10A,
        0xAD1E, 0xAA11, 0xA7EC, 0xA6B4, 0xA66D, 0xA716, 0xA8B0, 0xAB34, 0xAE9D, 0xB2E2, 0xB7F6, 0xBDCC, 0xC454, 0xCB7D, 0xD334, 0xDB63,
        0xE3F5, 0xECD3, 0xF5E4, 0xFF10, 0x083E, 0x1157, 0x1A41, 0x22E4, 0x2B29, 0x32FA, 0x3A42, 0x40ED, 0x46E9, 0x4C25, 0x5095, 0x542C,
        0x56DF, 0x58A9, 0x5984, 0x596E, 0x5867, 0x5672, 0x5394, 0x4FD4, 0x4B3E, 0x45DD, 0x3FC0, 0x38F7, 0x3195, 0x29AD, 0x2154, 0x18A2,
        0x0FAE, 0x068F, 0xFD60, 0xF437, 0xEB2D, 0xE25C, 0xD9DA, 0xD1C0, 0xCA22, 0xC314, 0xBCAC, 0xB6F8, 0xB209, 0xADEC, 0xAAAD, 0xA853,
        0xA6E5, 0xA668, 0xA6DB, 0xA83F, 0xAA90, 0xADC6, 0xB1DA, 0xB6C1, 0xBC6C, 0xC2CE, 0xC9D5, 0xD16E, 0xD984, 0xE201, 0xEAD0, 0xF3D8,
        0xFD00, 0x0630, 0x0F4F, 0x1846, 0x20FB, 0x2957, 0x3144, 0x38AD, 0x3F7C, 0x45A1, 0x4B0A, 0x4FA9, 0x5371, 0x5658, 0x5857, 0x5968,
        0x5988, 0x58B7, 0x56F7, 0x544C, 0x50BF, 0x4C58, 0x4723, 0x412F, 0x3A8B, 0x3349, 0x2B7E, 0x233D, 0x1A9D, 0x11B5, 0x089E, 0xFF70,
        0xF643, 0xED31, 0xE451, 0xDBBB, 0xD387, 0xCBCB, 0xC49C, 0xBE0D, 0xB82F, 0xB313, 0xAEC6, 0xAB54, 0xA8C6, 0xA723, 0xA66F, 0xA6AC,
        0xA7DB, 0xA9F6, 0xACFA, 0xB0DD, 0xB595, 0xBB16, 0xC150, 0xC834, 0xCFAD, 0xD7A9, 0xE012, 0xE8D0, 0xF1CD, 0xFAF0, 0x0420, 0x0D46,
        0x1648, 0x1F0E, 0x2780, 0x2F88, 0x3710, 0x3E03, 0x4450, 0x49E4, 0x4EB1, 0x52AB, 0x55C5, 0x57F9, 0x5940, 0x5996, 0x58FB, 0x5770,
        0x54FA, 0x519E, 0x4D67, 0x4860, 0x4295, 0x3C17, 0x34F7, 0x2D49, 0x2520, 0x1C93, 0x13BA, 0x0AAB, 0x0180, 0xF851, 0xEF37, 0xE649,
        0xDDA1, 0xD555, 0xCD7C, 0xC62C, 0xBF77, 0xB970, 0xB427, 0xAFAA, 0xAC06, 0xA944, 0xA76C, 0xA682, 0xA68A, 0xA782, 0xA969, 0xAC39,
        0xAFEB, 0xB474, 0xB9C9, 0xBFDB, 0xC69A, 0xCDF4, 0xD5D4, 0xDE26, 0xE6D3, 0xEFC4, 0xF8E1, 0x0210, 0x0B3A, 0x1446, 0x1D1C, 0x25A3,
        0x2DC5, 0x356B, 0x3C82, 0x42F5, 0x48B4, 0x4DAF, 0x51D9, 0x5527, 0x578F, 0x590B, 0x5998, 0x5933, 0x57DD, 0x559B, 0x5273, 0x4E6C,
        0x4992, 0x43F2, 0x3D9B, 0x369E, 0x2F0D, 0x26FE, 0x1E86, 0x15BC, 0x0CB7, 0x0390, 0xFA60, 0xF13F, 0xE845, 0xDF8B, 0xD729, 0xCF34,
        0xC7C3, 0xC0EA, 0xBABA, 0xB545, 0xB09A, 0xACC4, 0xA9CF, 0xA7C1, 0xA6A2, 0xA673, 0xA735, 0xA8E7, 0xAB83, 0xAF03, 0xB35D, 0xB886,
        0xBE6F, 0xC508, 0xCC41, 0xD405, 0xDC3F, 0xE4DA, 0xEDBE, 0xF6D3, 0x0000, 0x092D, 0x1242, 0x1B26, 0x23C1, 0x2BFB, 0x33BF, 0x3AF8,
        0x4191, 0x477A, 0x4CA3, 0x50FD, 0x547D, 0x5719, 0x58CB, 0x598D, 0x595E, 0x583F, 0x5631, 0x533C, 0x4F66, 0x4ABB, 0x4546, 0x3F16,
        0x383D, 0x30CC, 0x28D7, 0x2075, 0x17BB, 0x0EC1, 0x05A0, 0xFC70, 0xF349, 0xEA44, 0xE17A, 0xD902, 0xD0F3, 0xC962, 0xC265, 0xBC0E,
        0xB66E, 0xB194, 0xAD8D, 0xAA65, 0xA823, 0xA6CD, 0xA668, 0xA6F5, 0xA871, 0xAAD9, 0xAE27, 0xB251, 0xB74C, 0xBD0B, 0xC37E, 0xCA95,
        0xD23B, 0xDA5D, 0xE2E4, 0xEBBA, 0xF4C6, 0xFDF0, 0x071F, 0x103C, 0x192D, 0x21DA, 0x2A2C, 0x320C, 0x3966, 0x4025, 0x4637, 0x4B8C,
        0x5015, 0x53C7, 0x5697, 0x587E, 0x5976, 0x597E, 0x5894, 0x56BC, 0x53FA, 0x5056, 0x4BD9, 0x4690, 0x4089, 0x39D4, 0x3284, 0x2AAB,
        0x225F, 0x19B7, 0x10C9, 0x07AF, 0xFE80, 0xF555, 0xEC46, 0xE36D, 0xDAE0, 0xD2B7, 0xCB09, 0xC3E9, 0xBD6B, 0xB7A0, 0xB299, 0xAE62,
        0xAB06, 0xA890, 0xA705, 0xA66A, 0xA6C0, 0xA807, 0xAA3B, 0xAD55, 0xB14F, 0xB61C, 0xBBB0, 0xC1FD, 0xC8F0, 0xD078, 0xD880, 0xE0F2,
        0xE9B8, 0xF2BA, 0xFBE0, 0x0510, 0x0E33, 0x1730, 0x1FEE, 0x2857, 0x3053, 0x37CC, 0x3EB0, 0x44EA, 0x4A6B, 0x4F23, 0x5306, 0x560A,
        0x5825, 0x5954, 0x5991, 0x58DD, 0x573A, 0x54AC, 0x513A, 0x4CED, 0x47D1, 0x41F3, 0x3B64, 0x3435, 0x2C79, 0x2445, 0x1BAF, 0x12CF,
        0x09BD, 0x0090, 0xF762, 0xEE4B, 0xE563, 0xDCC3, 0xD482, 0xCCB7, 0xC575, 0xBED1, 0xB8DD, 0xB3A8, 0xAF41, 0xABB4, 0xA909, 0xA749,
        0xA678, 0xA698, 0xA7A9, 0xA9A8, 0xAC8F, 0xB057, 0xB4F6, 0xBA5F, 0xC084, 0xC753, 0xCEBC, 0xD6A9, 0xDF05, 0xE7BA, 0xF0B1, 0xF9D0,
        0x0300, 0x0C28, 0x1530, 0x1DFF, 0x267C, 0x2E92, 0x362B, 0x3D32, 0x4394, 0x493F, 0x4E26, 0x523A, 0x5570, 0x57C1, 0x5925, 0x5998,
        0x591B, 0x57AD, 0x5553, 0x5214, 0x4DF7, 0x4908, 0x4354, 0x3CEC, 0x35DE, 0x2E40, 0x2626, 0x1DA4, 0x14D3, 0x0BC9, 0x02A0, 0xF971,
        0xF052, 0xE75E, 0xDEAC, 0xD653, 0xCE6B, 0xC709, 0xC040, 0xBA23, 0xB4C2, 0xB02C, 0xAC6C, 0xA98E, 0xA799, 0xA692, 0xA67C, 0xA757,
        0xA921, 0xABD4, 0xAF6B, 0xB3DB, 0xB917, 0xBF13, 0xC5BE, 0xCD06, 0xD4D7, 0xDD1C, 0xE5BF, 0xEEA9, 0xF7C2, 0x00F0, 0x0A1C, 0x132D,
        0x1C0B, 0x249D, 0x2CCC, 0x3483, 0x3BAC, 0x4234, 0x480A, 0x4D1E, 0x5163, 0x54CC, 0x5750, 0x58EA, 0x5993, 0x594C, 0x5814, 0x55EF,
        0x52E2, 0x4EF6, 0x4A35, 0x44AC, 0x3E6B, 0x3781, 0x3002, 0x2801, 0x1F95, 0x16D3, 0x0DD4, 0x04B0, 0xFB80, 0xF25B, 0xE95B, 0xE098,
        0xD82A, 0xD027, 0xC8A5, 0xC1B8, 0xBB72, 0xB5E6, 0xB121, 0xAD30, 0xAA1F, 0xA7F5, 0xA6B8, 0xA66C, 0xA711, 0xA8A5, 0xAB25, 0xAE89,
        0xB2C9, 0xB7D9, 0xBDAB, 0xC430, 0xCB57, 0xD30A, 0xDB38, 0xE3C8, 0xECA4, 0xF5B4, 0xFEE0, 0x080E, 0x1128, 0x1A13, 0x22B8, 0x2AFF,
        0x32D3, 0x3A1E, 0x40CC, 0x46CB, 0x4C0C, 0x5080, 0x541B, 0x56D4, 0x58A2, 0x5982, 0x5971, 0x586F, 0x567E, 0x53A5, 0x4FEA, 0x4B58,
        0x45FB, 0x3FE2, 0x391C, 0x31BD, 0x29D7, 0x2181, 0x18D1, 0x0FDD, 0x06BF, 0xFD90, 0xF466, 0xEB5C, 0xE289, 0xDA06, 0xD1E9, 0xCA48,
        0xC338, 0xBCCB, 0xB714, 0xB221, 0xAE00, 0xAABB, 0xA85D, 0xA6EA, 0xA668, 0xA6D7, 0xA836, 0xAA81, 0xADB3, 0xB1C3, 0xB6A5, 0xBC4D,
        0xC2AB, 0xC9AF, 0xD144, 0xD958, 0xE1D4, 0xEAA1, 0xF3A8, 0xFCD0, 0x0600, 0x0F20, 0x1818, 0x20CE, 0x292D, 0x311C, 0x3887, 0x3F5A,
        0x4583, 0x4AF0, 0x4F93, 0x535F, 0x564B, 0x584F, 0x5965, 0x598A, 0x58BE, 0x5702, 0x545D, 0x50D4, 0x4C71, 0x4740, 0x4150, 0x3AAF,
        0x3371, 0x2BA8, 0x2369, 0x1ACB, 0x11E4, 0x08CE, 0xFFA0, 0xF673, 0xED60, 0xE47E, 0xDBE7, 0xD3B1, 0xCBF2, 0xC4C0, 0xBE2D, 0xB84C,
        0xB32B, 0xAEDA, 0xAB63, 0xA8D1, 0xA729, 0xA670, 0xA6A9, 0xA7D2, 0xA9E9, 0xACE8, 0xB0C6, 0xB57A, 0xBAF7, 0xC12E, 0xC80E, 0xCF85,
        0xD77E, 0xDFE5, 0xE8A2, 0xF19E, 0xFAC0, 0x03F0, 0x0D16, 0x1619, 0x1EE1, 0x2755, 0x2F5F, 0x36EA, 0x3DE0, 0x4430, 0x49C9, 0x4E9A,
        0x5298, 0x55B8, 0x57F0, 0x593B, 0x5997, 0x5900, 0x577A, 0x5509, 0x51B2, 0x4D7F, 0x487C, 0x42B5, 0x3C3B, 0x351E, 0x2D72, 0x254C,
        0x1CC1, 0x13E9, 0x0ADB, 0x01B0, 0xF881, 0xEF66, 0xE677, 0xDDCD, 0xD57F, 0xCDA4, 0xC650, 0xBF98, 0xB98D, 0xB441, 0xAFC0, 0xAC17,
        0xA950, 0xA773, 0xA685, 0xA687, 0xA77B, 0xA95C, 0xAC28, 0xAFD5, 0xB45A, 0xB9AB, 0xBFBA, 0xC675, 0xCDCC, 0xD5AA, 0xDDFA, 0xE6A5,
        0xEF95, 0xF8B1, 0x01E0, 0x0B0B, 0x1418, 0x1CEE, 0x2577, 0x2D9B, 0x3544, 0x3C5E, 0x42D5, 0x4898, 0x4D97, 0x51C6, 0x5518, 0x5785,
        0x5906, 0x5997, 0x5937, 0x57E7, 0x55A9, 0x5286, 0x4E83, 0x49AD, 0x4411, 0x3DBE, 0x36C4, 0x2F36, 0x272A, 0x1EB3, 0x15EB, 0x0CE7,
        0x03C0, 0xFA90, 0xF16E, 0xE873, 0xDFB8, 0xD753, 0xCF5C, 0xC7E9, 0xC10C, 0xBAD9, 0xB560, 0xB0B0, 0xACD6, 0xA9DC, 0xA7CA, 0xA6A5,
        0xA671, 0xA72F, 0xA8DC, 0xAB73, 0xAEEF, 0xB344, 0xB869, 0xBE4E, 0xC4E4, 0xCC1A, 0xD3DB, 0xDC13, 0xE4AC, 0xED8F, 0xF6A3, 0xFFD0,
        0x08FD, 0x1213, 0x1AF8, 0x2395, 0x2BD1, 0x3398, 0x3AD4, 0x4171, 0x475D, 0x4C8A, 0x50E8, 0x546D, 0x570E, 0x58C4, 0x598C, 0x5962,
        0x5847, 0x563E, 0x534E, 0x4F7C, 0x4AD5, 0x4564, 0x3F38, 0x3862, 0x30F4, 0x2902, 0x20A2, 0x17E9, 0x0EF1, 0x05D0, 0xFCA0, 0xF378,
        0xEA73, 0xE1A7, 0xD92D, 0xD11C, 0xC988, 0xC288, 0xBC2D, 0xB689, 0xB1AB, 0xADA0, 0xAA73, 0xA82C, 0xA6D2, 0xA668, 0xA6EF, 0xA867,
        0xAACA, 0xAE13, 0xB239, 0xB730, 0xBCEB, 0xC35B, 0xCA6E, 0xD212, 0xDA31, 0xE2B7, 0xEB8B, 0xF496, 0xFDC0, 0x06EF, 0x100D, 0x18FF,
        0x21AD, 0x2A02, 0x31E5, 0x3941, 0x4003, 0x4619, 0x4B72, 0x5000, 0x53B6, 0x568B, 0x5876, 0x5974, 0x5980, 0x589B, 0x56C8, 0x540B,
        0x506B, 0x4BF3, 0x46AE, 0x40AA, 0x39F9, 0x32AB, 0x2AD5, 0x228C, 0x19E5, 0x10F9, 0x07DF, 0xFEB0, 0xF584, 0xEC75, 0xE39A, 0xDB0C,
        0xD2E1, 0xCB30, 0xC40D, 0xBD8B, 0xB7BD, 0xB2B1, 0xAE75, 0xAB16, 0xA89B, 0xA70B, 0xA66B, 0xA6BC, 0xA7FE, 0xAA2D, 0xAD43, 0xB138,
        0xB601, 0xBB91, 0xC1DA, 0xC8CB, 0xD050, 0xD855, 0xE0C5, 0xE98A, 0xF28B, 0xFBB0, 0x04E0, 0x0E04, 0x1702, 0x1FC2, 0x282C, 0x302A,
        0x37A7, 0x3E8D, 0x44CB, 0x4A50, 0x4F0D, 0x52F4, 0x55FC, 0x581D, 0x5950, 0x5992, 0x58E4, 0x5745, 0x54BC, 0x514E, 0x4D06, 0x47EE,
        0x4214, 0x3B88, 0x345C, 0x2CA2, 0x2471, 0x1BDD, 0x12FE, 0x09EC, 0x00C0, 0xF792, 0xEE7A, 0xE591, 0xDCF0, 0xD4AC, 0xCCDE, 0xC599,
        0xBEF2, 0xB8FA, 0xB3C1, 0xAF56, 0xABC4, 0xA915, 0xA750, 0xA67A, 0xA695, 0xA7A1, 0xA99B, 0xAC7E, 0xB041, 0xB4DC, 0xBA41, 0xC062,
        0xC72E, 0xCE93, 0xD67E, 0xDED8, 0xE78C, 0xF081, 0xF9A1, 0x02D0, 0x0BF9, 0x1501, 0x1DD1, 0x2651, 0x2E69, 0x3605, 0x3D0F, 0x4374,
        0x4924, 0x4E0E, 0x5227, 0x5562, 0x57B7, 0x5920, 0x5998, 0x5920, 0x57B7, 0x5562, 0x5227, 0x4E0E, 0x4924, 0x4374, 0x3D0F, 0x3605,
        0x2E69, 0x2651, 0x1DD1, 0x1501, 0x0BF9, 0x02D0, 0xF9A1, 0xF081, 0xE78C, 0xDED8, 0xD67E, 0xCE93, 0xC72E, 0xC062, 0xBA41, 0xB4DC,
        0xB041, 0xAC7E, 0xA99B, 0xA7A1, 0xA695, 0xA67A, 0xA750, 0xA915, 0xABC4, 0xAF56, 0xB3C1, 0xB8FA, 0xBEF2, 0xC599, 0xCCDE, 0xD4AC,
        0xDCF0, 0xE591, 0xEE7A, 0xF792, 0x00C0, 0x09EC, 0x12FE, 0x1BDD, 0x2471, 0x2CA2, 0x345C, 0x3B88, 0x4214, 0x47EE, 0x4D06, 0x514E,
        0x54BC, 0x5745, 0x58E4, 0x5992, 0x5950, 0x581D, 0x55FC, 0x52F4, 0x4F0D, 0x4A50, 0x44CB, 0x3E8D, 0x37A7, 0x302A, 0x282C, 0x1FC2,
        0x1702, 0x0E04, 0x04E0, 0xFBB0, 0xF28B, 0xE98A, 0xE0C5, 0xD855, 0xD050, 0xC8CB, 0xC1DA, 0xBB91, 0xB601, 0xB138, 0xAD43, 0xAA2D,
        0xA7FE, 0xA6BC, 0xA66B, 0xA70B, 0xA89B, 0xAB16, 0xAE75, 0xB2B1, 0xB7BD, 0xBD8B, 0xC40D, 0xCB30, 0xD2E1, 0xDB0C, 0xE39A, 0xEC75,
        0xF584, 0xFEB0, 0x07DF, 0x10F9, 0x19E5, 0x228C, 0x2AD5, 0x32AB, 0x39F9, 0x40AA, 0x46AE, 0x4BF3, 0x506B, 0x540B, 0x56C8, 0x589B,
        0x5980, 0x5974, 0x5876, 0x568B, 0x53B6, 0x5000, 0x4B72, 0x4619, 0x4003, 0x3941, 0x31E5, 0x2A02, 0x21AD, 0x18FF, 0x100D, 0x06EF,
        0xFDC0, 0xF496, 0xEB8B, 0xE2B7, 0xDA31, 0xD212, 0xCA6E, 0xC35B, 0xBCEB, 0xB730, 0xB239, 0xAE13, 0xAACA, 0xA867, 0xA6EF, 0xA668,
        0xA6D2, 0xA82C, 0xAA73, 0xADA0, 0xB1AB, 0xB689, 0xBC2D, 0xC288, 0xC988, 0xD11C, 0xD92D, 0xE1A7, 0xEA73, 0xF378, 0xFCA0, 0x05D0,
        0x0EF1, 0x17E9, 0x20A2, 0x2902, 0x30F4, 0x3862, 0x3F38, 0x4564, 0x4AD5, 0x4F7C, 0x534E, 0x563E, 0x5847, 0x5962, 0x598C, 0x58C4,
        0x570E, 0x546D, 0x50E8, 0x4C8A, 0x475D, 0x4171, 0x3AD4, 0x3398, 0x2BD1, 0x2395, 0x1AF8, 0x1213, 0x08FD, 0xFFD0, 0xF6A3, 0xED8F,
        0xE4AC, 0xDC13, 0xD3DB, 0xCC1A, 0xC4E4, 0xBE4E, 0xB869, 0xB344, 0xAEEF, 0xAB73, 0xA8DC, 0xA72F, 0xA671, 0xA6A5, 0xA7CA, 0xA9DC,
        0xACD6, 0xB0B0, 0xB560, 0xBAD9, 0xC10C, 0xC7E9, 0xCF5C, 0xD753, 0xDFB8, 0xE873, 0xF16E, 0xFA90, 0x03C0, 0x0CE7, 0x15EB, 0x1EB3,
        0x272A, 0x2F36, 0x36C4, 0x3DBE, 0x4411, 0x49AD, 0x4E83, 0x5286, 0x55A9, 0x57E7, 0x5937, 0x5997, 0x5906, 0x5785, 0x5518, 0x51C6,
        0x4D97, 0x4898, 0x42D5, 0x3C5E, 0x3544, 0x2D9B, 0x2577, 0x1CEE, 0x1418, 0x0B0B, 0x01E0, 0xF8B1, 0xEF95, 0xE6A5, 0xDDFA, 0xD5AA,
        0xCDCC, 0xC675, 0xBFBA, 0xB9AB, 0xB45A, 0xAFD5, 0xAC28, 0xA95C, 0xA77B, 0xA687, 0xA685, 0xA773, 0xA950, 0xAC17, 0xAFC0, 0xB441,
        0xB98D, 0xBF98, 0xC650, 0xCDA4, 0xD57F, 0xDDCD, 0xE677, 0xEF66, 0xF881, 0x01B0, 0x0ADB, 0x13E9, 0x1CC1, 0x254C, 0x2D72, 0x351E,
        0x3C3B, 0x42B5, 0x487C, 0x4D7F, 0x51B2, 0x5509, 0x577A, 0x5900, 0x5997, 0x593B, 0x57F0, 0x55B8, 0x5298, 0x4E9A, 0x49C9, 0x4430,
        0x3DE0, 0x36EA, 0x2F5F, 0x2755, 0x1EE1, 0x1619, 0x0D16, 0x03F0, 0xFAC0, 0xF19E, 0xE8A2, 0xDFE5, 0xD77E, 0xCF85, 0xC80E, 0xC12E,
        0xBAF7, 0xB57A, 0xB0C6, 0xACE8, 0xA9E9, 0xA7D2, 0xA6A9, 0xA670, 0xA729, 0xA8D1, 0xAB63, 0xAEDA, 0xB32B, 0xB84C, 0xBE2D, 0xC4C0,
        0xCBF2, 0xD3B1, 0xDBE7, 0xE47E, 0xED60, 0xF673, 0xFFA0, 0x08CE, 0x11E4, 0x1ACB, 0x2369, 0x2BA8, 0x3371, 0x3AAF, 0x4150, 0x4740,
        0x4C71, 0x50D4, 0x545D, 0x5702, 0x58BE, 0x598A, 0x5965, 0x584F, 0x564B, 0x535F, 0x4F93, 0x4AF0, 0x4583, 0x3F5A, 0x3887, 0x311C,
        0x292D, 0x20CE, 0x1818, 0x0F20, 0x0600, 0xFCD0, 0xF3A8, 0xEAA1, 0xE1D4, 0xD958, 0xD144, 0xC9AF, 0xC2AB, 0xBC4D, 0xB6A5, 0xB1C3,
        0xADB3, 0xAA81, 0xA836, 0xA6D7, 0xA668, 0xA6EA, 0xA85D, 0xAABB, 0xAE00, 0xB221, 0xB714, 0xBCCB, 0xC338, 0xCA48, 0xD1E9, 0xDA06,
        0xE289, 0xEB5C, 0xF466, 0xFD90, 0x06BF, 0x0FDD, 0x18D1, 0x2181, 0x29D7, 0x31BD, 0x391C, 0x3FE2, 0x45FB, 0x4B58, 0x4FEA, 0x53A5,
        0x567E, 0x586F, 0x5971, 0x5982, 0x58A2, 0x56D4, 0x541B, 0x5080, 0x4C0C, 0x46CB, 0x40CC, 0x3A1E, 0x32D3, 0x2AFF, 0x22B8, 0x1A13,
        0x1128, 0x080E, 0xFEE0, 0xF5B4, 0xECA4, 0xE3C8, 0xDB38, 0xD30A, 0xCB57, 0xC430, 0xBDAB, 0xB7D9, 0xB2C9, 0xAE89, 0xAB25, 0xA8A5,
        0xA711, 0xA66C, 0xA6B8, 0xA7F5, 0xAA1F, 0xAD30, 0xB121, 0xB5E6, 0xBB72, 0xC1B8, 0xC8A5, 0xD027, 0xD82A, 0xE098, 0xE95B, 0xF25B,
        0xFB80, 0x04B0, 0x0DD4, 0x16D3, 0x1F95, 0x2801, 0x3002, 0x3781, 0x3E6B, 0x44AC, 0x4A35, 0x4EF6, 0x52E2, 0x55EF, 0x5814, 0x594C,
        0x5993, 0x58EA, 0x5750, 0x54CC, 0x5163, 0x4D1E, 0x480A, 0x4234, 0x3BAC, 0x3483, 0x2CCC, 0x249D, 0x1C0B, 0x132D, 0x0A1C, 0x00F0,
        0xF7C2, 0xEEA9, 0xE5BF, 0xDD1C, 0xD4D7, 0xCD06, 0xC5BE, 0xBF13, 0xB917, 0xB3DB, 0xAF6B, 0xABD4, 0xA921, 0xA757, 0xA67C, 0xA692,
        0xA799, 0xA98E, 0xAC6C, 0xB02C, 0xB4C2, 0xBA23, 0xC040, 0xC709, 0xCE6B, 0xD653, 0xDEAC, 0xE75E, 0xF052, 0xF971, 0x02A0, 0x0BC9,
        0x14D3, 0x1DA4, 0x2626, 0x2E40, 0x35DE, 0x3CEC, 0x4354, 0x4908, 0x4DF7, 0x5214, 0x5553, 0x57AD, 0x591B, 0x5998, 0x5925, 0x57C1,
        0x5570, 0x523A, 0x4E26, 0x493F, 0x4394, 0x3D32, 0x362B, 0x2E92, 0x267C, 0x1DFF, 0x1530, 0x0C28, 0x0300, 0xF9D0, 0xF0B1, 0xE7BA,
        0xDF05, 0xD6A9, 0xCEBC, 0xC753, 0xC084, 0xBA5F, 0xB4F6, 0xB057, 0xAC8F, 0xA9A8, 0xA7A9, 0xA698, 0xA678, 0xA749, 0xA909, 0xABB4,
        0xAF41, 0xB3A8, 0xB8DD, 0xBED1, 0xC575, 0xCCB7, 0xD482, 0xDCC3, 0xE563, 0xEE4B, 0xF762, 0x0090, 0x09BD, 0x12CF, 0x1BAF, 0x2445,
        0x2C79, 0x3435, 0x3B64, 0x41F3, 0x47D1, 0x4CED, 0x513A, 0x54AC, 0x573A, 0x58DD, 0x5991, 0x5954, 0x5825, 0x560A, 0x5306, 0x4F23,
        0x4A6B, 0x44EA, 0x3EB0, 0x37CC, 0x3053, 0x2857, 0x1FEE, 0x1730, 0x0E33, 0x0510, 0xFBE0, 0xF2BA, 0xE9B8, 0xE0F2, 0xD880, 0xD078,
        0xC8F0, 0xC1FD, 0xBBB0, 0xB61C, 0xB14F, 0xAD55, 0xAA3B, 0xA807, 0xA6C0, 0xA66A, 0xA705, 0xA890, 0xAB06, 0xAE62, 0xB299, 0xB7A0,
        0xBD6B, 0xC3E9, 0xCB09, 0xD2B7, 0xDAE0, 0xE36D, 0xEC46, 0xF555, 0xFE80, 0x07AF, 0x10C9, 0x19B7, 0x225F, 0x2AAB, 0x3284, 0x39D4,
        0x4089, 0x4690, 0x4BD9, 0x5056, 0x53FA, 0x56BC, 0x5894, 0x597E, 0x5976, 0x587E, 0x5697, 0x53C7, 0x5015, 0x4B8C, 0x4637, 0x4025,
        0x3966, 0x320C, 0x2A2C, 0x21DA, 0x192D, 0x103C, 0x071F, 0xFDF0, 0xF4C6, 0xEBBA, 0xE2E4, 0xDA5D, 0xD23B, 0xCA95, 0xC37E, 0xBD0B,
        0xB74C, 0xB251, 0xAE27, 0xAAD9, 0xA871, 0xA6F5, 0xA668, 0xA6CD, 0xA823, 0xAA65, 0xAD8D, 0xB194, 0xB66E, 0xBC0E, 0xC265, 0xC962,
        0xD0F3, 0xD902, 0xE17A, 0xEA44, 0xF349, 0xFC70, 0x05A0, 0x0EC1, 0x17BB, 0x2075, 0x28D7, 0x30CC, 0x383D, 0x3F16, 0x4546, 0x4ABB,
        0x4F66, 0x533C, 0x5631, 0x583F, 0x595E, 0x598D, 0x58CB, 0x5719, 0x547D, 0x50FD, 0x4CA3, 0x477A, 0x4191, 0x3AF8, 0x33BF, 0x2BFB,
        0x23C1, 0x1B26, 0x1242, 0x092D, 0x0000, 0xF6D3, 0xEDBE, 0xE4DA, 0xDC3F, 0xD405, 0xCC41, 0xC508, 0xBE6F, 0xB886, 0xB35D, 0xAF03,
        0xAB83, 0xA8E7, 0xA735, 0xA673, 0xA6A2, 0xA7C1, 0xA9CF, 0xACC4, 0xB09A, 0xB545, 0xBABA, 0xC0EA, 0xC7C3, 0xCF34, 0xD729, 0xDF8B,
        0xE845, 0xF13F, 0xFA60, 0x0390, 0x0CB7, 0x15BC, 0x1E86, 0x26FE, 0x2F0D, 0x369E, 0x3D9B, 0x43F2, 0x4992, 0x4E6C, 0x5273, 0x559B,
        0x57DD, 0x5933, 0x5998, 0x590B, 0x578F, 0x5527, 0x51D9, 0x4DAF, 0x48B4, 0x42F5, 0x3C82, 0x356B, 0x2DC5, 0x25A3, 0x1D1C, 0x1446,
        0x0B3A, 0x0210, 0xF8E1, 0xEFC4, 0xE6D3, 0xDE26, 0xD5D4, 0xCDF4, 0xC69A, 0xBFDB, 0xB9C9, 0xB474, 0xAFEB, 0xAC39, 0xA969, 0xA782,
        0xA68A, 0xA682, 0xA76C, 0xA944, 0xAC06, 0xAFAA, 0xB427, 0xB970, 0xBF77, 0xC62C, 0xCD7C, 0xD555, 0xDDA1, 0xE649, 0xEF37, 0xF851,
        0x0180, 0x0AAB, 0x13BA, 0x1C93, 0x2520, 0x2D49, 0x34F7, 0x3C17, 0x4295, 0x4860, 0x4D67, 0x519E, 0x54FA, 0x5770, 0x58FB, 0x5996,
        0x5940, 0x57F9, 0x55C5, 0x52AB, 0x4EB1, 0x49E4, 0x4450, 0x3E03, 0x3710, 0x2F88, 0x2780, 0x1F0E, 0x1648, 0x0D46, 0x0420, 0xFAF0,
        0xF1CD, 0xE8D0, 0xE012, 0xD7A9, 0xCFAD, 0xC834, 0xC150, 0xBB16, 0xB595, 0xB0DD, 0xACFA, 0xA9F6, 0xA7DB, 0xA6AC, 0xA66F, 0xA723,
        0xA8C6, 0xAB54, 0xAEC6, 0xB313, 0xB82F, 0xBE0D, 0xC49C, 0xCBCB, 0xD387, 0xDBBB, 0xE451, 0xED31, 0xF643, 0xFF70, 0x089E, 0x11B5,
        0x1A9D, 0x233D, 0x2B7E, 0x3349, 0x3A8B, 0x412F, 0x4723, 0x4C58, 0x50BF, 0x544C, 0x56F7, 0x58B7, 0x5988, 0x5968, 0x5857, 0x5658,
        0x5371, 0x4FA9, 0x4B0A, 0x45A1, 0x3F7C, 0x38AD, 0x3144, 0x2957, 0x20FB, 0x1846, 0x0F4F, 0x0630, 0xFD00, 0xF3D8, 0xEAD0, 0xE201,
        0xD984, 0xD16E, 0xC9D5, 0xC2CE, 0xBC6C, 0xB6C1, 0xB1DA, 0xADC6, 0xAA90, 0xA83F, 0xA6DB, 0xA668, 0xA6E5, 0xA853, 0xAAAD, 0xADEC,
        0xB209, 0xB6F8, 0xBCAC, 0xC314, 0xCA22, 0xD1C0, 0xD9DA, 0xE25C, 0xEB2D, 0xF437, 0xFD60, 0x068F, 0x0FAE, 0x18A2, 0x2154, 0x29AD,
        0x3195, 0x38F7, 0x3FC0, 0x45DD, 0x4B3E, 0x4FD4, 0x5394, 0x5672, 0x5867, 0x596E, 0x5984, 0x58A9, 0x56DF, 0x542C, 0x5095, 0x4C25,
        0x46E9, 0x40ED, 0x3A42, 0x32FA, 0x2B29, 0x22E4, 0x1A41, 0x1157, 0x083E, 0xFF10, 0xF5E4, 0xECD3, 0xE3F5, 0xDB63, 0xD334, 0xCB7D,
        0xC454, 0xBDCC, 0xB7F6, 0xB2E2, 0xAE9D, 0xAB34, 0xA8B0, 0xA716, 0xA66D, 0xA6B4, 0xA7EC, 0xAA11, 0xAD1E, 0xB10A, 0xB5CB, 0xBB54,
        0xC195, 0xC87F, 0xCFFE, 0xD7FF, 0xE06B, 0xE92D, 0xF22C, 0xFB50, 0x0480, 0x0DA5, 0x16A5, 0x1F68, 0x27D6, 0x2FD9, 0x375B, 0x3E48,
        0x448E, 0x4A1A, 0x4EDF, 0x52D0, 0x55E1, 0x580B, 0x5948, 0x5994, 0x58EF, 0x575B, 0x54DB, 0x5177, 0x4D37, 0x4827, 0x4255, 0x3BD0,
        0x34A9, 0x2CF6, 0x24C8, 0x1C38, 0x135C, 0x0A4C, 0x0120, 0xF7F2, 0xEED8, 0xE5ED, 0xDD48, 0xD501, 0xCD2D, 0xC5E2, 0xBF34, 0xB935,
        0xB3F4, 0xAF80, 0xABE5, 0xA92C, 0xA75E, 0xA67E, 0xA68F, 0xA791, 0xA982, 0xAC5B, 0xB016, 0xB4A8, 0xBA05, 0xC01E, 0xC6E4, 0xCE43,
        0xD629, 0xDE7F, 0xE72F, 0xF023, 0xF941, 0x0270, 0x0B9A, 0x14A4, 0x1D77, 0x25FA, 0x2E17, 0x35B8, 0x3CC8, 0x4335, 0x48EC, 0x4DDF,
        0x5200, 0x5545, 0x57A3, 0x5916, 0x5998, 0x5929, 0x57CA, 0x557F, 0x524D, 0x4E3D, 0x495B, 0x43B3, 0x3D55, 0x3651, 0x2EBC, 0x26A8,
        0x1E2C, 0x155F, 0x0C58, 0x0330, 0xFA00, 0xF0E0, 0xE7E8, 0xDF32, 0xD6D3, 0xCEE4, 0xC779, 0xC0A6, 0xBA7D, 0xB510, 0xB06D, 0xACA1,
        0xA9B5, 0xA7B1, 0xA69B, 0xA676, 0xA742, 0xA8FE, 0xABA3, 0xAF2C, 0xB38F, 0xB8C0, 0xBEB0, 0xC551, 0xCC8F, 0xD458, 0xDC97, 0xE535,
        0xEE1C, 0xF732, 0x0060, 0x098D, 0x12A0, 0x1B82, 0x2419, 0x2C4F, 0x340E, 0x3B40, 0x41D3, 0x47B4, 0x4CD5, 0x5126, 0x549D, 0x572F,
        0x58D7, 0x5990, 0x5957, 0x582E, 0x5617, 0x5318, 0x4F3A, 0x4A86, 0x4509, 0x3ED2, 0x37F2, 0x307B, 0x2882, 0x201B, 0x175E, 0x0E62,
        0x0540, 0xFC10, 0xF2EA, 0xE9E7, 0xE11F, 0xD8AB, 0xD0A1, 0xC916, 0xC220, 0xBBD0, 0xB637, 0xB166, 0xAD68, 0xAA48, 0xA810, 0xA6C5,
        0xA669, 0xA700, 0xA886, 0xAAF7, 0xAE4E, 0xB281, 0xB784, 0xBD4B, 0xC3C5, 0xCAE2, 0xD28E, 0xDAB4, 0xE33F, 0xEC17, 0xF525, 0xFE50,
        0x077F, 0x109A, 0x1989, 0x2233, 0x2A81, 0x325C, 0x39B0, 0x4068, 0x4673, 0x4BBF, 0x5040, 0x53E9, 0x56B0, 0x588D, 0x597B, 0x5979,
        0x5885, 0x56A4, 0x53D8, 0x502B, 0x4BA6, 0x4655, 0x4046, 0x398B, 0x3234, 0x2A56, 0x2206, 0x195B, 0x106B, 0x074F, 0xFE20, 0xF4F5,
        0xEBE8, 0xE312, 0xDA89, 0xD265, 0xCABC, 0xC3A2, 0xBD2B, 0xB768, 0xB269, 0xAE3A, 0xAAE8, 0xA87B, 0xA6FA, 0xA669, 0xA6C9, 0xA819,
        0xAA57, 0xAD7A, 0xB17D, 0xB653, 0xBBEF, 0xC242, 0xC93C, 0xD0CA, 0xD8D6, 0xE14D, 0xEA15, 0xF319, 0xFC40, 0x0570, 0x0E92, 0x178D,
        0x2048, 0x28AD, 0x30A4, 0x3817, 0x3EF4, 0x4527, 0x4AA0, 0x4F50, 0x532A, 0x5624, 0x5836, 0x595B, 0x598F, 0x58D1, 0x5724, 0x548D,
        0x5111, 0x4CBC, 0x4797, 0x41B2, 0x3B1C, 0x33E6, 0x2C25, 0x23ED, 0x1B54, 0x1271, 0x095D, 0x0030, 0xF703, 0xEDED, 0xE508, 0xDC6B,
        0xD42F, 0xCC68, 0xC52C, 0xBE8F, 0xB8A3, 0xB376, 0xAF18, 0xAB93, 0xA8F2, 0xA73C, 0xA674, 0xA69E, 0xA7B9, 0xA9C2, 0xACB2, 0xB084,
        0xB52B, 0xBA9C, 0xC0C8, 0xC79E, 0xCF0C, 0xD6FE, 0xDF5E, 0xE817, 0xF10F, 0xFA30, 0x0360, 0x0C88, 0x158D, 0x1E59, 0x26D3, 0x2EE4,
        0x3678, 0x3D78, 0x43D3, 0x4977, 0x4E55, 0x5260, 0x558D, 0x57D4, 0x592E, 0x5998, 0x5911, 0x5799, 0x5536, 0x51ED, 0x4DC7, 0x48D0,
        0x4315, 0x3CA5, 0x3592, 0x2DEE, 0x25CF, 0x1D49, 0x1475, 0x0B6A, 0x0240, 0xF911, 0xEFF3, 0xE701, 0xDE53, 0xD5FE, 0xCE1B, 0xC6BF,
        0xBFFD, 0xB9E7, 0xB48E, 0xB000, 0xAC4A, 0xA975, 0xA78A, 0xA68C, 0xA680, 0xA765, 0xA938, 0xABF5, 0xAF95, 0xB40D, 0xB952, 0xBF56,
        0xC607, 0xCD55, 0xD52B, 0xDD74, 0xE61B, 0xEF07, 0xF821, 0x0150, 0x0A7C, 0x138B, 0x1C66, 0x24F4, 0x2D1F, 0x34D0, 0x3BF3, 0x4275,
        0x4843, 0x4D4F, 0x518B, 0x54EA, 0x5765, 0x58F5, 0x5995, 0x5944, 0x5802, 0x55D3, 0x52BD, 0x4EC8, 0x49FF, 0x446F, 0x3E26, 0x3735,
        0x2FB0, 0x27AB, 0x1F3B, 0x1676, 0x0D75, 0x0450, 0xFB20, 0xF1FC, 0xE8FE, 0xE03E, 0xD7D4, 0xCFD6, 0xC859, 0xC173, 0xBB35, 0xB5B0,
        0xB0F3, 0xAD0C, 0xAA04, 0xA7E3, 0xA6B0, 0xA66E, 0xA71C, 0xA8BB, 0xAB44, 0xAEB2, 0xB2FA, 0xB812, 0xBDEC, 0xC478, 0xCBA4, 0xD35E,
        0xDB8F, 0xE423, 0xED02, 0xF614, 0xFF40, 0x086E, 0x1186, 0x1A6F, 0x2310, 0x2B54, 0x3322, 0x3A67, 0x410E, 0x4706, 0x4C3F, 0x50AA,
        0x543C, 0x56EB, 0x58B0, 0x5986, 0x596B, 0x585F, 0x5665, 0x5382, 0x4FBF, 0x4B24, 0x45BF, 0x3F9E, 0x38D2, 0x316D, 0x2982, 0x2128,
        0x1874, 0x0F7F, 0x065F, 0xFD30, 0xF407, 0xEAFF, 0xE22F, 0xD9AF, 0xD197, 0xC9FB, 0xC2F1, 0xBC8C, 0xB6DC, 0xB1F2, 0xADD9, 0xAA9E,
        0xA849, 0xA6E0, 0xA668, 0xA6E0, 0xA849, 0xAA9E, 0xADD9, 0xB1F2, 0xB6DC, 0xBC8C, 0xC2F1, 0xC9FB, 0xD197, 0xD9AF, 0xE22F, 0xEAFF,
        0xF407, 0xFD30, 0x065F, 0x0F7F, 0x1874, 0x2128, 0x2982, 0x316D, 0x38D2, 0x3F9E, 0x45BF, 0x4B24, 0x4FBF, 0x5382, 0x5665, 0x585F,
        0x596B, 0x5986, 0x58B0, 0x56EB, 0x543C, 0x50AA, 0x4C3F, 0x4706, 0x410E, 0x3A67, 0x3322, 0x2B54, 0x2310, 0x1A6F, 0x1186, 0x086E,
        0xFF40, 0xF614, 0xED02, 0xE423, 0xDB8F, 0xD35E, 0xCBA4, 0xC478, 0xBDEC, 0xB812, 0xB2FA, 0xAEB2, 0xAB44, 0xA8BB, 0xA71C, 0xA66E,
        0xA6B0, 0xA7E3, 0xAA04, 0xAD0C, 0xB0F3, 0xB5B0, 0xBB35, 0xC173, 0xC859, 0xCFD6, 0xD7D4, 0xE03E, 0xE8FE, 0xF1FC, 0xFB20, 0x0450,
        0x0D75, 0x1676, 0x1F3B, 0x27AB, 0x2FB0, 0x3735, 0x3E26, 0x446F, 0x49FF, 0x4EC8, 0x52BD, 0x55D3, 0x5802, 0x5944, 0x5995, 0x58F5,
        0x5765, 0x54EA, 0x518B, 0x4D4F, 0x4843, 0x4275, 0x3BF3, 0x34D0, 0x2D1F, 0x24F4, 0x1C66, 0x138B, 0x0A7C, 0x0150, 0xF821, 0xEF07,
        0xE61B, 0xDD74, 0xD52B, 0xCD55, 0xC607, 0xBF56, 0xB952, 0xB40D, 0xAF95, 0xABF5, 0xA938, 0xA765, 0xA680, 0xA68C, 0xA78A, 0xA975,
        0xAC4A, 0xB000, 0xB48E, 0xB9E7, 0xBFFD, 0xC6BF, 0xCE1B, 0xD5FE, 0xDE53, 0xE701, 0xEFF3, 0xF911, 0x0240, 0x0B6A, 0x1475, 0x1D49,
        0x25CF, 0x2DEE, 0x3592, 0x3CA5, 0x4315, 0x48D0, 0x4DC7, 0x51ED, 0x5536, 0x5799, 0x5911, 0x5998, 0x592E, 0x57D4, 0x558D, 0x5260,
        0x4E55, 0x4977, 0x43D3, 0x3D78, 0x3678, 0x2EE4, 0x26D3, 0x1E59, 0x158D, 0x0C88, 0x0360, 0xFA30, 0xF10F, 0xE817, 0xDF5E, 0xD6FE,
        0xCF0C, 0xC79E, 0xC0C8, 0xBA9C, 0xB52B, 0xB084, 0xACB2, 0xA9C2, 0xA7B9, 0xA69E, 0xA674, 0xA73C, 0xA8F2, 0xAB93, 0xAF18, 0xB376,
        0xB8A3, 0xBE8F, 0xC52C, 0xCC68, 0xD42F, 0xDC6B, 0xE508, 0xEDED, 0xF703, 0x0030, 0x095D, 0x1271, 0x1B54, 0x23ED, 0x2C25, 0x33E6,
        0x3B1C, 0x41B2, 0x4797, 0x4CBC, 0x5111, 0x548D, 0x5724, 0x58D1, 0x598F, 0x595B, 0x5836, 0x5624, 0x532A, 0x4F50, 0x4AA0, 0x4527,
        0x3EF4, 0x3817, 0x30A4, 0x28AD, 0x2048, 0x178D, 0x0E92, 0x0570, 0xFC40, 0xF319, 0xEA15, 0xE14D, 0xD8D6, 0xD0CA, 0xC93C, 0xC242,
        0xBBEF, 0xB653, 0xB17D, 0xAD7A, 0xAA57, 0xA819, 0xA6C9, 0xA669, 0xA6FA, 0xA87B, 0xAAE8, 0xAE3A, 0xB269, 0xB768, 0xBD2B, 0xC3A2,
        0xCABC, 0xD265, 0xDA89, 0xE312, 0xEBE8, 0xF4F5, 0xFE20, 0x074F, 0x106B, 0x195B, 0x2206, 0x2A56, 0x3234, 0x398B, 0x4046, 0x4655,
        0x4BA6, 0x4FEB, 0x5352, 0x55D3, 0x576A, 0x5813, 0x57CE, 0x569E, 0x5486, 0x518E, 0x4DC0, 0x4927, 0x43D1, 0x3DCD, 0x372D, 0x3003,
        0x2864, 0x2065, 0x181C, 0x0FA0, 0x0708, 0xFE6C, 0xF5E2, 0xED82, 0xE561, 0xDD96, 0xD634, 0xCF50, 0xC8F9, 0xC342, 0xBE38, 0xB9E7,
        0xB65A, 0xB39A, 0xB1AB, 0xB093, 0xB052, 0xB0E8, 0xB251, 0xB489, 0xB788, 0xBB45, 0xBFB4, 0xC4C9, 0xCA73, 0xD0A4, 0xD749, 0xDE50,
        0xE5A5, 0xED34, 0xF4E9, 0xFCAD, 0x046B, 0x0C10, 0x1388, 0x1ABD, 0x219D, 0x2817, 0x2E19, 0x3394, 0x387A, 0x3CC0, 0x405A, 0x4341,
        0x456D, 0x46DB, 0x4787, 0x4772, 0x469C, 0x450B, 0x42C2, 0x3FCB, 0x3C2D, 0x37F4, 0x332D, 0x2DE5, 0x282B, 0x2211, 0x1BA6, 0x14FD,
        0x0E29, 0x073C, 0x0048, 0xF962, 0xF29A, 0xEC04, 0xE5B0, 0xDFAF, 0xDA10, 0xD4E3, 0xD034, 0xCC0E, 0xC87D, 0xC588, 0xC336, 0xC18C,
        0xC08D, 0xC03C, 0xC096, 0xC19A, 0xC344, 0xC58E, 0xC870, 0xCBE3, 0xCFDA, 0xD44B, 0xD928, 0xDE64, 0xE3EF, 0xE9BB, 0xEFB6, 0xF5D1,
        0xFBFA, 0x0221, 0x0836, 0x0E28, 0x13E7, 0x1965, 0x1E93, 0x2364, 0x27CB, 0x2BBE, 0x2F33, 0x3221, 0x3482, 0x3651, 0x378A, 0x382B,
        0x3833, 0x37A4, 0x3681, 0x34CD, 0x328F, 0x2FCE, 0x2C93, 0x28E7, 0x24D5, 0x2068, 0x1BAF, 0x16B6, 0x118B, 0x0C3C, 0x06D8, 0x016E,
        0xFC0E, 0xF6C3, 0xF19E, 0xECAB, 0xE7F7, 0xE38F, 0xDF7E, 0xDBCE, 0xD887, 0xD5B3, 0xD356, 0xD178, 0xD01B, 0xCF43, 0xCEEF, 0xCF20,
        0xCFD5, 0xD109, 0xD2B8, 0xD4DE, 0xD772, 0xDA6D, 0xDDC6, 0xE173, 0xE569, 0xE99D, 0xEE03, 0xF28F, 0xF733, 0xFBE3, 0x0092, 0x0534,
        0x09BD, 0x0E20, 0x1252, 0x1648, 0x19F9, 0x1D59, 0x2062, 0x230C, 0x2551, 0x272C, 0x2898, 0x2994, 0x2A1C, 0x2A33, 0x29D7, 0x290C,
        0x27D4, 0x2635, 0x2432, 0x21D4, 0x1F21, 0x1C22, 0x18DF, 0x1562, 0x11B5, 0x0DE2, 0x09F5, 0x05F7, 0x01F5, 0xFDF9, 0xFA0D, 0xF63C,
        0xF290, 0xEF12, 0xEBCC, 0xE8C6, 0xE606, 0xE395, 0xE177, 0xDFB1, 0xDE48, 0xDD3D, 0xDC93, 0xDC4B, 0xDC63, 0xDCDB, 0xDDB0, 0xDEDF,
        0xE064, 0xE239, 0xE459, 0xE6BD, 0xE95E, 0xEC34, 0xEF36, 0xF25D, 0xF59E, 0xF8F2, 0xFC4E, 0xFFA9, 0x02FA, 0x063A, 0x095E, 0x0C60,
        0x0F36, 0x11DA, 0x1446, 0x1674, 0x185E, 0x1A00, 0x1B56, 0x1C5F, 0x1D18, 0x1D80, 0x1D97, 0x1D5E, 0x1CD7, 0x1C04, 0x1AE8, 0x1987,
        0x17E6, 0x160B, 0x13FA, 0x11BB, 0x0F54, 0x0CCB, 0x0A29, 0x0775, 0x04B7, 0x01F5, 0xFF39, 0xFC88, 0xF9EA, 0xF766, 0xF502, 0xF2C4,
        0xF0B3, 0xEED2, 0xED26, 0xEBB4, 0xEA7E, 0xE986, 0xE8CF, 0xE859, 0xE824, 0xE831, 0xE87D, 0xE908, 0xE9CF, 0xEACF, 0xEC04, 0xED6A,
        0xEEFC, 0xF0B7, 0xF293, 0xF48D, 0xF69D, 0xF8BE, 0xFAEA, 0xFD1B, 0xFF4B, 0x0172, 0x038E, 0x0597, 0x0788, 0x095D, 0x0B11, 0x0C9F,
        0x0E05, 0x0F3E, 0x1049, 0x1124, 0x11CC, 0x1241, 0x1283, 0x1292, 0x126E, 0x1219, 0x1195, 0x10E3, 0x1007, 0x0F04, 0x0DDC, 0x0C95,
        0x0B32, 0x09B7, 0x0829, 0x068C, 0x04E6, 0x033A, 0x018E, 0xFFE7, 0xFE47, 0xFCB5, 0xFB33, 0xF9C6, 0xF871, 0xF737, 0xF61C, 0xF522,
        0xF44A, 0xF396, 0xF307, 0xF29F, 0xF25E, 0xF242, 0xF24D, 0xF27D, 0xF2D0, 0xF345, 0xF3DB, 0xF48E, 0xF55C, 0xF642, 0xF73E, 0xF84B,
        0xF968, 0xFA8F, 0xFBBF, 0xFCF3, 0xFE27, 0xFF5A, 0x0086, 0x01AA, 0x02C2, 0x03CC, 0x04C4, 0x05AA, 0x067A, 0x0733, 0x07D3, 0x085A,
        0x08C7, 0x0918, 0x094F, 0x096B, 0x096C, 0x0953, 0x0921, 0x08D8, 0x0879, 0x0805, 0x077E, 0x06E7, 0x0641, 0x058F, 0x04D3, 0x0410,
        0x0347, 0x027C, 0x01B0, 0x00E5, 0x001F, 0xFF60, 0xFEA8, 0xFDFA, 0xFD57, 0xFCC1, 0xFC3A, 0xFBC1, 0xFB59, 0xFB01, 0xFABA, 0xFA85,
        0xFA61, 0xFA4D, 0xFA4B, 0xFA59, 0xFA76, 0xFAA1, 0xFADA, 0xFB1F, 0xFB6F, 0xFBC8, 0xFC2A, 0xFC92, 0xFD00, 0xFD71, 0xFDE5, 0xFE59,
        0xFECD, 0xFF3F, 0xFFAE, 0x0017, 0x007C, 0x00DA, 0x0131, 0x0181, 0x01C7, 0x0205, 0x023A, 0x0265, 0x0286, 0x029E, 0x02AD, 0x02B3,
        0x02B0, 0x02A6, 0x0294, 0x027B, 0x025D, 0x0239, 0x0210, 0x01E4, 0x01B5, 0x0184, 0x0152, 0x0120, 0x00ED, 0x00BC, 0x008D, 0x0060,
        0x0035, 0x000E, 0xFFEB, 0xFFCB, 0xFFAF, 0xFF97, 0xFF84, 0xFF74, 0xFF69, 0xFF62, 0xFF5E, 0xFF5D, 0xFF60, 0xFF65, 0xFF6D, 0xFF77,
        0xFF82, 0xFF8E, 0xFF9B, 0xFFA8, 0xFFB5, 0xFFC2, 0xFFCE, 0xFFD9, 0xFFE3, 0xFFEB, 0xFFF2, 0xFFF8, 0xFFFC, 0xFFFF, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0003, 0x0004, 0x0007, 0x0009, 0x000C,
        0x0010, 0x0014, 0x0018, 0x001D, 0x0022, 0x0027, 0x002D, 0x0032, 0x0038, 0x003E, 0x0043, 0x0048, 0x004D, 0x0051, 0x0055, 0x0057,
        0x0059, 0x005A, 0x005A, 0x0058, 0x0056, 0x0051, 0x004B, 0x0044, 0x003B, 0x0030, 0x0024, 0x0016, 0x0006, 0xFFF6, 0xFFE4, 0xFFD0,
        0xFFBA, 0xFFA4, 0xFF8D, 0xFF75, 0xFF5C, 0xFF43, 0xFF2A, 0xFF11, 0xFEF9, 0xFEE1, 0xFECB, 0xFEB5, 0xFEA2, 0xFE90, 0xFE81, 0xFE74,
        0xFE6A, 0xFE63, 0xFE5F, 0xFE5F, 0xFE63, 0xFE6B, 0xFE77, 0xFE87, 0xFE9B, 0xFEB4, 0xFED1, 0xFEF2, 0xFF17, 0xFF41, 0xFF6E, 0xFF9F,
        0xFFD3, 0x000A, 0x0044, 0x0080, 0x00BF, 0x00FF, 0x013F, 0x0180, 0x01C1, 0x0201, 0x0240, 0x027D, 0x02B7, 0x02EE, 0x0321, 0x0350,
        0x037A, 0x039E, 0x03BC, 0x03D3, 0x03E4, 0x03EC, 0x03ED, 0x03E6, 0x03D6, 0x03BE, 0x039D, 0x0373, 0x0341, 0x0305, 0x02C2, 0x0276,
        0x0222, 0x01C6, 0x0164, 0x00FB, 0x008D, 0x001A, 0xFFA3, 0xFF28, 0xFEAB, 0xFE2C, 0xFDAC, 0xFD2D, 0xFCB0, 0xFC35, 0xFBBE, 0xFB4C,
        0xFADF, 0xFA7A, 0xFA1D, 0xF9C8, 0xF97E, 0xF93F, 0xF90B, 0xF8E4, 0xF8CA, 0xF8BE, 0xF8C0, 0xF8D0, 0xF8F0, 0xF91F, 0xF95D, 0xF9AA,
        0xFA06, 0xFA70, 0xFAE9, 0xFB6F, 0xFC03, 0xFCA2, 0xFD4C, 0xFE00, 0xFEBD, 0xFF82, 0x004C, 0x011B, 0x01EE, 0x02C3, 0x0397, 0x046A,
        0x0539, 0x0603, 0x06C7, 0x0781, 0x0832, 0x08D6, 0x096D, 0x09F5, 0x0A6C, 0x0AD2, 0x0B25, 0x0B63, 0x0B8D, 0x0BA0, 0x0B9D, 0x0B83,
        0x0B52, 0x0B09, 0x0AA8, 0x0A31, 0x09A2, 0x08FD, 0x0843, 0x0775, 0x0693, 0x059F, 0x049B, 0x0388, 0x0268, 0x013D, 0x0009, 0xFED0,
        0xFD91, 0xFC51, 0xFB11, 0xF9D4, 0xF89D, 0xF76D, 0xF649, 0xF531, 0xF429, 0xF333, 0xF251, 0xF186, 0xF0D3, 0xF03A, 0xEFBD, 0xEF5D,
        0xEF1C, 0xEEFB, 0xEEFB, 0xEF1C, 0xEF5F, 0xEFC3, 0xF04A, 0xF0F1, 0xF1B9, 0xF2A1, 0xF3A7, 0xF4CB, 0xF609, 0xF761, 0xF8D0, 0xFA54,
        0xFBEA, 0xFD8F, 0xFF41, 0x00FA, 0x02BB, 0x047E, 0x0641, 0x07FF, 0x09B5, 0x0B60, 0x0CFC, 0x0E86, 0x0FFB, 0x1156, 0x1296, 0x13B7,
        0x14B7, 0x1592, 0x1647, 0x16D4, 0x1736, 0x176D, 0x1777, 0x1754, 0x1703, 0x1684, 0x15D6, 0x14FC, 0x13F5, 0x12C3, 0x1168, 0x0FE6,
        0x0E3E, 0x0C74, 0x0A8B, 0x0885, 0x0667, 0x0434, 0x01F1, 0xFFA1, 0xFD48, 0xFAEC, 0xF890, 0xF639, 0xF3EC, 0xF1AE, 0xEF83, 0xED6F,
        0xEB78, 0xE9A1, 0xE7EF, 0xE665, 0xE507, 0xE3D8, 0xE2DB, 0xE213, 0xE183, 0xE12B, 0xE10E, 0xE12C, 0xE187, 0xE21E, 0xE2F0, 0xE3FF,
        0xE547, 0xE6C8, 0xE87E, 0xEA69, 0xEC84, 0xEECC, 0xF13E, 0xF3D5, 0xF68C, 0xF95F, 0xFC49, 0xFF44, 0x024A, 0x0556, 0x0863, 0x0B6A,
        0x0E65, 0x114F, 0x1421, 0x16D5, 0x1966, 0x1BCF, 0x1E0A, 0x2012, 0x21E3, 0x2379, 0x24CF, 0x25E3, 0x26B0, 0x2736, 0x2771, 0x2761,
        0x2705, 0x265C, 0x2567, 0x2426, 0x229C, 0x20CA, 0x1EB3, 0x1C5A, 0x19C2, 0x16F1, 0x13EB, 0x10B5, 0x0D54, 0x09D0, 0x062D, 0x0274,
        0xFEAB, 0xFAD8, 0xF703, 0xF334, 0xEF73, 0xEBC5, 0xE834, 0xE4C6, 0xE182, 0xDE6F, 0xDB94, 0xD8F7, 0xD69D, 0xD48C, 0xD2C8, 0xD157,
        0xD03C, 0xCF79, 0xCF12, 0xCF08, 0xCF5C, 0xD00F, 0xD121, 0xD28F, 0xD45A, 0xD67E, 0xD8F8, 0xDBC4, 0xDEDE, 0xE241, 0xE5E7, 0xE9C9,
        0xEDE1, 0xF227, 0xF694, 0xFB1F, 0xFFC1, 0x046E, 0x0921, 0x0DD0, 0x1270, 0x16FA, 0x1B64, 0x1FA5, 0x23B5, 0x278B, 0x2B1F, 0x2E6A,
        0x3164, 0x3407, 0x364D, 0x3831, 0x39AD, 0x3ABE, 0x3B61, 0x3B93, 0x3B53, 0x3AA1, 0x397B, 0x37E4, 0x35DD, 0x3369, 0x308C, 0x2D4A,
        0x29A9, 0x25AE, 0x2160, 0x1CC7, 0x17EB, 0x12D4, 0x0D8D, 0x081E, 0x0291, 0xFCF3, 0xF74B, 0xF1A6, 0xEC0E, 0xE68F, 0xE133, 0xDC05,
        0xD70F, 0xD25C, 0xCDF5, 0xC9E3, 0xC62F, 0xC2E2, 0xC002, 0xBD96, 0xBBA4, 0xBA31, 0xB940, 0xB8D5, 0xB8F2, 0xB998, 0xBAC7, 0xBC7D,
        0xBEBA, 0xC179, 0xC4B7, 0xC86F, 0xCC9B, 0xD133, 0xD62F, 0xDB88, 0xE134, 0xE728, 0xED59, 0xF3BD, 0xFA47, 0x00EB, 0x079D, 0x0E4F,
        0x14F6, 0x1B84, 0x21EC, 0x2821, 0x2E17, 0x33C3, 0x3917, 0x3E0A, 0x4292, 0x46A3, 0x4A36, 0x4D43, 0x4FC1, 0x51AD, 0x52FF, 0x53B5,
        0x53CC, 0x5342, 0x5218, 0x504C, 0x4DE3, 0x4ADF, 0x4744, 0x4319, 0x3E63, 0x392C, 0x337B, 0x2D5C, 0x26D8, 0x1FFB, 0x18D2, 0x116A,
        0x09C6, 0x0210, 0xFA56, 0xF2A7, 0xEB11, 0xE3A2, 0xDC6A, 0xD576, 0xCED2, 0xC88D, 0xC2B1, 0xBD4A, 0xB862, 0xB402, 0xB033, 0xACFC,
        0xAA64, 0xA86E, 0xA720, 0xA67A, 0xA680, 0xA72F, 0xA889, 0xAA88, 0xAD2B, 0xB06B, 0xB443, 0xB8AB, 0xBD9C, 0xC30A, 0xC8ED, 0xCF39,
        0xD5E2, 0xDCDB, 0xE416, 0xEB88, 0xF320, 0xFAD0, 0x028A, 0x0A40, 0x11E2, 0x1962, 0x20B2, 0x27C3, 0x2E89, 0x34F6, 0x3AFE, 0x4096,
        0x45B2, 0x4A4A, 0x4E55, 0x51CA, 0x54A3, 0x56DB, 0x586D, 0x5957, 0x5997, 0x592C, 0x5817, 0x565B, 0x53F9, 0x50F8, 0x4D5D, 0x492E,
        0x4474, 0x3F37, 0x3982, 0x335F, 0x2CDA, 0x2600, 0x1EDE, 0x1780, 0x0FF6, 0x084E, 0x0096, 0xF8DD, 0xF131, 0xE9A2, 0xE23D, 0xDB10,
        0xD42A, 0xCD98, 0xC766, 0xC19F, 0xBC4F, 0xB781, 0xB33C, 0xAF8A, 0xAC71, 0xA9F7, 0xA821, 0xA6F3, 0xA66E, 0xA694, 0xA764, 0xA8DD,
        0xAAFD, 0xADBE, 0xB11C, 0xB510, 0xB993, 0xBE9C, 0xC422, 0xCA19, 0xD078, 0xD731, 0xDE38, 0xE57F, 0xECF9, 0xF497, 0xFC4A, 0x0404,
        0x0BB7, 0x1354, 0x1ACC, 0x2211, 0x2915, 0x2FCA, 0x3625, 0x3C19, 0x419A, 0x469E, 0x4B1B, 0x4F09, 0x5261, 0x551C, 0x5735, 0x58A7,
        0x5971, 0x5990, 0x5904, 0x57CF, 0x55F3, 0x5373, 0x5053, 0x4C9B, 0x4851, 0x437D, 0x3E29, 0x385E, 0x3227, 0x2B91, 0x24A8, 0x1D7A,
        0x1613, 0x0E82, 0x06D5, 0xFF1C, 0xF764, 0xEFBD, 0xE834, 0xE0D9, 0xD9B9, 0xD2E2, 0xCC61, 0xC642, 0xC092, 0xBB5A, 0xB6A5, 0xB27C,
        0xAEE6, 0xABEB, 0xA991, 0xA7DB, 0xA6CC, 0xA668, 0xA6AF, 0xA79F, 0xA939, 0xAB77, 0xAE56, 0xB1D2, 0xB5E2, 0xBA7F, 0xBFA1, 0xC53D,
        0xCB49, 0xD1BA, 0xD883, 0xDF97, 0xE6E9, 0xEE6B, 0xF60E, 0xFDC4, 0x057E, 0x0D2E, 0x14C5, 0x1C34, 0x236D, 0x2A63, 0x3109, 0x3751,
        0x3D2F, 0x4299, 0x4784, 0x4BE7, 0x4FB9, 0x52F3, 0x558F, 0x5788, 0x58DB, 0x5984, 0x5982, 0x58D6, 0x5781, 0x5585, 0x52E6, 0x4FA9,
        0x4BD4, 0x476F, 0x4282, 0x3D16, 0x3736, 0x30EC, 0x2A45, 0x234E, 0x1C13, 0x14A3, 0x0D0C, 0x055C, 0xFDA2, 0xF5EC, 0xEE49, 0xE6C8,
        0xDF77, 0xD864, 0xD19D, 0xCB2E, 0xC523, 0xBF89, 0xBA69, 0xB5CE, 0xB1C1, 0xAE48, 0xAB6C, 0xA930, 0xA79A, 0xA6AC, 0xA669, 0xA6D0,
        0xA7E1, 0xA99A, 0xABF7, 0xAEF5, 0xB28D, 0xB6B9, 0xBB70, 0xC0AA, 0xC65D, 0xCC7D, 0xD300, 0xD9D8, 0xE0F9, 0xE855, 0xEFDE, 0xF786,
        0xFF3E, 0x06F7, 0x0EA3, 0x1634, 0x1D9A, 0x24C8, 0x2BAF, 0x3244, 0x3878, 0x3E41, 0x4394, 0x4865, 0x4CAD, 0x5063, 0x537F, 0x55FC,
        0x57D6, 0x5908, 0x5991, 0x596F, 0x58A2, 0x572D, 0x5511, 0x5254, 0x4EF9, 0x4B08, 0x4689, 0x4182, 0x3BFF, 0x360A, 0x2FAE, 0x28F6,
        0x21F1, 0x1AAB, 0x1333, 0x0B95, 0x03E2, 0xFC28, 0xF475, 0xECD7, 0xE55E, 0xDE18, 0xD712, 0xD05B, 0xC9FE, 0xC408, 0xBE84, 0xB97E,
        0xB4FD, 0xB10B, 0xADB0, 0xAAF2, 0xA8D6, 0xA75F, 0xA692, 0xA66F, 0xA6F7, 0xA828, 0xAA01, 0xAC7D, 0xAF99, 0xB34E, 0xB795, 0xBC66,
        0xC1B8, 0xC780, 0xCDB4, 0xD448, 0xDB2F, 0xE25D, 0xE9C3, 0xF153, 0xF8FF, 0x00B8, 0x0870, 0x1018, 0x17A1, 0x1EFE, 0x261F, 0x2CF8,
        0x337B, 0x399C, 0x3F4F, 0x448A, 0x4942, 0x4D6E, 0x5107, 0x5405, 0x5664, 0x581D, 0x592F, 0x5997, 0x5955, 0x5868, 0x56D2, 0x5498,
        0x51BC, 0x4E44, 0x4A37, 0x459D, 0x407E, 0x3AE4, 0x34DA, 0x2E6C, 0x27A5, 0x2092, 0x1941, 0x11C0, 0x0A1E, 0x0268, 0xFAAE, 0xF2FE,
        0xEB66, 0xE3F6, 0xDCBB, 0xD5C3, 0xCF1C, 0xC8D2, 0xC2F1, 0xBD85, 0xB897, 0xB431, 0xB05B, 0xAD1E, 0xAA7E, 0xA881, 0xA72B, 0xA67E,
        0xA67C, 0xA724, 0xA876, 0xAA6E, 0xAD09, 0xB043, 0xB414, 0xB876, 0xBD60, 0xC2CA, 0xC8A8, 0xCEEF, 0xD594, 0xDC8A, 0xE3C3, 0xEB32,
        0xF2C9, 0xFA78, 0x0232, 0x09E8, 0x118B, 0x190D, 0x2060, 0x2774, 0x2E3D, 0x34AF, 0x3ABC, 0x4058, 0x457B, 0x4A19, 0x4E2A, 0x51A5,
        0x5486, 0x56C5, 0x585F, 0x5950, 0x5998, 0x5935, 0x5827, 0x5672, 0x5418, 0x511E, 0x4D89, 0x4961, 0x44AC, 0x3F75, 0x39C5, 0x33A7,
        0x2D27, 0x2650, 0x1F30, 0x17D5, 0x104D, 0x08A6, 0x00EE, 0xF935, 0xF188, 0xE9F7, 0xE290, 0xDB61, 0xD477, 0xCDE1, 0xC7AA, 0xC1DF,
        0xBC89, 0xB7B5, 0xB36A, 0xAFB1, 0xAC91, 0xAA10, 0xA833, 0xA6FD, 0xA670, 0xA68F, 0xA758, 0xA8C9, 0xAAE1, 0xAD9B, 0xB0F2, 0xB4E0,
        0xB95C, 0xBE60, 0xC3E0, 0xC9D3, 0xD02D, 0xD6E2, 0xDDE6, 0xE52B, 0xECA2, 0xF43F, 0xFBF2, 0x03AC, 0x0B60, 0x12FE, 0x1A78, 0x21BF,
        0x28C6, 0x2F80, 0x35DF, 0x3BD7, 0x415D, 0x4667, 0x4AEB, 0x4EE0, 0x523E, 0x5500, 0x5720, 0x589A, 0x596B, 0x5992, 0x590E, 0x57E1,
        0x560C, 0x5393, 0x507A, 0x4CC9, 0x4885, 0x43B7, 0x3E68, 0x38A2, 0x3270, 0x2BDE, 0x24F9, 0x1DCD, 0x1668, 0x0ED9, 0x072D, 0xFF74,
        0xF7BC, 0xF013, 0xE889, 0xE12C, 0xDA09, 0xD32E, 0xCCA9, 0xC686, 0xC0D0, 0xBB93, 0xB6D8, 0xB2A8, 0xAF0C, 0xAC0A, 0xA9A8, 0xA7EB,
        0xA6D5, 0xA669, 0xA6A8, 0xA791, 0xA923, 0xAB5A, 0xAE32, 0xB1A7, 0xB5B0, 0xBA47, 0xBF63, 0xC4FB, 0xCB02, 0xD16F, 0xD834, 0xDF45,
        0xE695, 0xEE14, 0xF5B6, 0xFD6C, 0x0526, 0x0CD6, 0x146F, 0x1BE0, 0x231C, 0x2A16, 0x30BF, 0x370B, 0x3CEF, 0x425E, 0x474F, 0x4BB8,
        0x4F90, 0x52D2, 0x5575, 0x5775, 0x58CF, 0x5980, 0x5986, 0x58E2, 0x5794, 0x559F, 0x5307, 0x4FD1, 0x4C03, 0x47A4, 0x42BD, 0x3D56,
        0x377B, 0x3136, 0x2A93, 0x239F, 0x1C67, 0x14F9, 0x0D63, 0x05B4, 0xFDFA, 0xF644, 0xEEA0, 0xE71D, 0xDFCA, 0xD8B3, 0xD1E8, 0xCB75,
        0xC566, 0xBFC6, 0xBAA1, 0xB600, 0xB1EC, 0xAE6D, 0xAB89, 0xA946, 0xA7A8, 0xA6B3, 0xA668, 0xA6C7, 0xA7D1, 0xA982, 0xABD9, 0xAED0,
        0xB261, 0xB686, 0xBB37, 0xC06C, 0xC619, 0xCC35, 0xD2B3, 0xD988, 0xE0A6, 0xE800, 0xEF88, 0xF72F, 0xFEE6, 0x069F, 0x0E4C, 0x15DE,
        0x1D47, 0x2477, 0x2B62, 0x31FA, 0x3834, 0x3E02, 0x435A, 0x4831, 0x4C7F, 0x503C, 0x535F, 0x55E3, 0x57C4, 0x58FE, 0x598E, 0x5974,
        0x58AF, 0x5741, 0x552D, 0x5276, 0x4F23, 0x4B38, 0x46BF, 0x41BE, 0x3C41, 0x3650, 0x2FF8, 0x2945, 0x2243, 0x1AFF, 0x1389, 0x0BED,
        0x043A, 0xFC80, 0xF4CC, 0xED2D, 0xE5B2, 0xDE6A, 0xD761, 0xD0A6, 0xCA44, 0xC44A, 0xBEC1, 0xB9B4, 0xB52D, 0xB135, 0xADD3, 0xAB0E,
        0xA8EA, 0xA76C, 0xA698, 0xA66D, 0xA6ED, 0xA817, 0xA9E8, 0xAC5E, 0xAF72, 0xB320, 0xB761, 0xBC2C, 0xC178, 0xC73C, 0xCD6B, 0xD3FB,
        0xDADF, 0xE20A, 0xE96D, 0xF0FC, 0xF8A7, 0x0060, 0x0818, 0x0FC1, 0x174C, 0x1EAB, 0x25CF, 0x2CAC, 0x3333, 0x3958, 0x3F11, 0x4451,
        0x490F, 0x4D41, 0x50E1, 0x53E7, 0x564C, 0x580D, 0x5927, 0x5996, 0x595B, 0x5876, 0x56E8, 0x54B4, 0x51E0, 0x4E6F, 0x4A68, 0x45D4,
        0x40BB, 0x3B27, 0x3521, 0x2EB7, 0x27F4, 0x20E4, 0x1996, 0x1217, 0x0A75, 0x02C0, 0xFB06, 0xF355, 0xEBBC, 0xE44A, 0xDD0C, 0xD611,
        0xCF66, 0xC918, 0xC332, 0xBDC0, 0xB8CC, 0xB460, 0xB084, 0xAD3F, 0xAA98, 0xA894, 0xA737, 0xA682, 0xA678, 0xA719, 0xA863, 0xAA54,
        0xACE8, 0xB01B, 0xB3E5, 0xB841, 0xBD26, 0xC289, 0xC862, 0xCEA5, 0xD546, 0xDC39, 0xE36F, 0xEADC, 0xF271, 0xFA20, 0x01DA, 0x0990,
        0x1135, 0x18B9, 0x200D, 0x2725, 0x2DF2, 0x3467, 0x3A79, 0x401B, 0x4543, 0x49E7, 0x4DFE, 0x5181, 0x5468, 0x56AF, 0x5850, 0x5949,
        0x5998, 0x593D, 0x5837, 0x5689, 0x5436, 0x5143, 0x4DB5, 0x4993, 0x44E5, 0x3FB3, 0x3A08, 0x33EF, 0x2D73, 0x26A0, 0x1F83, 0x182A,
        0x10A4, 0x08FD, 0x0146, 0xF98D, 0xF1DF, 0xEA4C, 0xE2E3, 0xDBB1, 0xD4C4, 0xCE2A, 0xC7EF, 0xC21E, 0xBCC3, 0xB7E9, 0xB398, 0xAFD8,
        0xACB1, 0xAA29, 0xA844, 0xA707, 0xA673, 0xA68A, 0xA74B, 0xA8B5, 0xAAC6, 0xAD78, 0xB0C9, 0xB4B0, 0xB926, 0xBE24, 0xC39F, 0xC98D,
        0xCFE3, 0xD694, 0xDD95, 0xE4D7, 0xEC4C, 0xF3E8, 0xFB9A, 0x0354, 0x0B08, 0x12A8, 0x1A23, 0x216D, 0x2878, 0x2F35, 0x3598, 0x3B95,
        0x4121, 0x4631, 0x4ABA, 0x4EB6, 0x521B, 0x54E4, 0x570B, 0x588D, 0x5966, 0x5994, 0x5918, 0x57F2, 0x5624, 0x53B2, 0x50A1, 0x4CF6,
        0x48B9, 0x43F1, 0x3EA7, 0x38E6, 0x32B9, 0x2C2B, 0x2549, 0x1E20, 0x16BD, 0x0F2F, 0x0785, 0xFFCD, 0xF814, 0xF06A, 0xE8DE, 0xE17E,
        0xDA59, 0xD37B, 0xCCF2, 0xC6CA, 0xC10F, 0xBBCC, 0xB70B, 0xB2D5, 0xAF32, 0xAC29, 0xA9C0, 0xA7FB, 0xA6DE, 0xA66A, 0xA6A2, 0xA783,
        0xA90D, 0xAB3D, 0xAE0F, 0xB17C, 0xB57F, 0xBA10, 0xBF26, 0xC4B8, 0xCABB, 0xD123, 0xD7E5, 0xDEF3, 0xE640, 0xEDBE, 0xF55F, 0xFD14,
        0x04CE, 0x0C7F, 0x1419, 0x1B8C, 0x22CB, 0x29C8, 0x3075, 0x36C5, 0x3CAE, 0x4222, 0x4719, 0x4B88, 0x4F68, 0x52B0, 0x555A, 0x5762,
        0x58C3, 0x597C, 0x5989, 0x58ED, 0x57A6, 0x55B9, 0x5328, 0x4FF9, 0x4C32, 0x47D9, 0x42F8, 0x3D97, 0x37C0, 0x317F, 0x2AE0, 0x23F0,
        0x1CBB, 0x154F, 0x0DBA, 0x060C, 0xFE52, 0xF69B, 0xEEF6, 0xE772, 0xE01C, 0xD903, 0xD234, 0xCBBD, 0xC5A9, 0xC004, 0xBAD9, 0xB632,
        0xB217, 0xAE91, 0xABA7, 0xA95C, 0xA7B7, 0xA6BA, 0xA668, 0xA6C0, 0xA7C2, 0xA96C, 0xABBB, 0xAEAA, 0xB235, 0xB654, 0xBAFF, 0xC02E,
        0xC5D6, 0xCBED, 0xD267, 0xD939, 0xE054, 0xE7AB, 0xEF31, 0xF6D7, 0xFE8E, 0x0647, 0x0DF5, 0x1589, 0x1CF3, 0x2426, 0x2B15, 0x31B1,
        0x37EF, 0x3DC2, 0x431F, 0x47FD, 0x4C51, 0x5014, 0x533E, 0x55CA, 0x57B3, 0x58F4, 0x598B, 0x5979, 0x58BB, 0x5755, 0x5548, 0x5299,
        0x4F4C, 0x4B68, 0x46F5, 0x41FA, 0x3C82, 0x3696, 0x3042, 0x2993, 0x2294, 0x1B53, 0x13DF, 0x0C44, 0x0492, 0xFCD8, 0xF524, 0xED84,
        0xE607, 0xDEBB, 0xD7B0, 0xD0F1, 0xCA8B, 0xC48C, 0xBEFD, 0xB9EB, 0xB55E, 0xB15F, 0xADF6, 0xAB2A, 0xA8FF, 0xA77A, 0xA69D, 0xA66B,
        0xA6E4, 0xA806, 0xA9D0, 0xAC3E, 0xAF4C, 0xB2F3, 0xB72E, 0xBBF3, 0xC139, 0xC6F8, 0xCD23, 0xD3AF, 0xDA8F, 0xE1B7, 0xE918, 0xF0A5,
        0xF84F, 0x0007, 0x07C0, 0x0F6A, 0x16F7, 0x1E58, 0x257F, 0x2C5F, 0x32EA, 0x3914, 0x3ED2, 0x4418, 0x48DC, 0x4D15, 0x50BB, 0x53C7,
        0x5634, 0x57FD, 0x591E, 0x5995, 0x5962, 0x5884, 0x56FD, 0x54D1, 0x5203, 0x4E99, 0x4A99, 0x460B, 0x40F8, 0x3B69, 0x3568, 0x2F02,
        0x2842, 0x2136, 0x19EA, 0x126D, 0x0ACD, 0x0318, 0xFB5E, 0xF3AC, 0xEC12, 0xE49E, 0xDD5D, 0xD65F, 0xCFB0, 0xC95D, 0xC373, 0xBDFB,
        0xB902, 0xB48F, 0xB0AD, 0xAD61, 0xAAB3, 0xA8A8, 0xA743, 0xA687, 0xA675, 0xA70E, 0xA851, 0xAA3A, 0xACC7, 0xAFF3, 0xB3B7, 0xB80D,
        0xBCEB, 0xC249, 0xC81D, 0xCE5C, 0xD4F9, 0xDBE8, 0xE31C, 0xEA87, 0xF21A, 0xF9C9, 0x0182, 0x0939, 0x10DE, 0x1864, 0x1FBB, 0x26D6,
        0x2DA6, 0x3420, 0x3A36, 0x3FDD, 0x450B, 0x49B5, 0x4DD3, 0x515C, 0x544B, 0x5698, 0x5841, 0x5942, 0x5998, 0x5944, 0x5846, 0x56A0,
        0x5454, 0x5168, 0x4DE1, 0x49C5, 0x451D, 0x3FF1, 0x3A4B, 0x3437, 0x2DBE, 0x26EF, 0x1FD5, 0x187F, 0x10FA, 0x0955, 0x019E, 0xF9E5,
        0xF236, 0xEAA2, 0xE337, 0xDC02, 0xD512, 0xCE73, 0xC834, 0xC25E, 0xBCFE, 0xB81D, 0xB3C6, 0xB000, 0xACD2, 0xAA43, 0xA857, 0xA712,
        0xA676, 0xA685, 0xA73F, 0xA8A1, 0xAAAB, 0xAD56, 0xB0A0, 0xB480, 0xB8F0, 0xBDE8, 0xC35E, 0xC947, 0xCF98, 0xD646, 0xDD43, 0xE483,
        0xEBF6, 0xF390, 0xFB42, 0x02FC, 0x0AB1, 0x1251, 0x19CF, 0x211C, 0x2829, 0x2EEA, 0x3551, 0x3B53, 0x40E4, 0x45FA, 0x4A8A, 0x4E8B,
        0x51F8, 0x54C8, 0x56F6, 0x587F, 0x5960, 0x5996, 0x5921, 0x5802, 0x563C, 0x53D1, 0x50C7, 0x4D23, 0x48EC, 0x442A, 0x3EE6, 0x392A,
        0x3302, 0x2C78, 0x2599, 0x1E73, 0x1713, 0x0F86, 0x07DD, 0x0024, 0xF86C, 0xF0C1, 0xE933, 0xE1D1, 0xDAA9, 0xD3C7, 0xCD3A, 0xC70E,
        0xC14E, 0xBC05, 0xB73E, 0xB302, 0xAF58, 0xAC48, 0xA9D8, 0xA80B, 0xA6E7, 0xA66C, 0xA69B, 0xA776, 0xA8F8, 0xAB21, 0xADEB, 0xB152,
        0xB54E, 0xB9D9, 0xBEEA, 0xC476, 0xCA74, 0xD0D8, 0xD796, 0xDEA1, 0xE5EC, 0xED68, 0xF507, 0xFCBC, 0x0476, 0x0C28, 0x13C3, 0x1B38,
        0x227A, 0x297A, 0x302B, 0x3680, 0x3C6D, 0x41E7, 0x46E3, 0x4B59, 0x4F3F, 0x528E, 0x553F, 0x574E, 0x58B7, 0x5977, 0x598C, 0x58F7,
        0x57B8, 0x55D2, 0x5349, 0x5021, 0x4C60, 0x480E, 0x4332, 0x3DD6, 0x3805, 0x31C9, 0x2B2E, 0x2440, 0x1D0E, 0x15A4, 0x0E11, 0x0663,
        0xFEAA, 0xF6F3, 0xEF4D, 0xE7C6, 0xE06E, 0xD952, 0xD280, 0xCC04, 0xC5EC, 0xC042, 0xBB11, 0xB664, 0xB243, 0xAEB6, 0xABC4, 0xA973,
        0xA7C6, 0xA6C2, 0xA668, 0xA6B8, 0xA7B2, 0xA955, 0xAB9D, 0xAE86, 0xB209, 0xB622, 0xBAC7, 0xBFF0, 0xC593, 0xCBA5, 0xD21C, 0xD8E9,
        0xE001, 0xE756, 0xEEDA, 0xF67F, 0xFE36, 0x05EF, 0x0D9E, 0x1533, 0x1CA0, 0x23D6, 0x2AC8, 0x3168, 0x37AA, 0x3D82, 0x42E5, 0x47C8,
        0x4C23, 0x4FEC, 0x531E, 0x55B1, 0x57A0, 0x58E9, 0x5988, 0x597D, 0x58C7, 0x5768, 0x5563, 0x52BB, 0x4F75, 0x4B98, 0x472A, 0x4236,
        0x3CC3, 0x36DC, 0x308D, 0x29E1, 0x22E5, 0x1BA7, 0x1434, 0x0C9B, 0x04EA, 0xFD30, 0xF57B, 0xEDDA, 0xE65B, 0xDF0D, 0xD7FE, 0xD13C,
        0xCAD2, 0xC4CE, 0xBF3A, 0xBA22, 0xB58F, 0xB18A, 0xAE1A, 0xAB46, 0xA914, 0xA788, 0xA6A4, 0xA66A, 0xA6DB, 0xA7F6, 0xA9B8, 0xAC1F,
        0xAF26, 0xB2C7, 0xB6FA, 0xBBB9, 0xC0FB, 0xC6B4, 0xCCDA, 0xD362, 0xDA3F, 0xE164, 0xE8C3, 0xF04E, 0xF7F8, 0xFFB0, 0x0768, 0x0F14,
        0x16A2, 0x1E05, 0x252F, 0x2C12, 0x32A2, 0x38D0, 0x3E93, 0x43DE, 0x48A8, 0x4CE8, 0x5095, 0x53A8, 0x561C, 0x57EC, 0x5915, 0x5993,
        0x5967, 0x5891, 0x5712, 0x54ED, 0x5227, 0x4EC3, 0x4ACA, 0x4642, 0x4134, 0x3BAB, 0x35AF, 0x2F4D, 0x2891, 0x2188, 0x1A3F, 0x12C3,
        0x0B24, 0x0370, 0xFBB6, 0xF404, 0xEC68, 0xE4F2, 0xDDAF, 0xD6AD, 0xCFFB, 0xC9A3, 0xC3B4, 0xBE37, 0xB938, 0xB4BF, 0xB0D6, 0xAD84,
        0xAACE, 0xA8BC, 0xA74F, 0xA68B, 0xA672, 0xA704, 0xA83F, 0xAA21, 0xACA7, 0xAFCB, 0xB389, 0xB7D8, 0xBCB1, 0xC20A, 0xC7D9, 0xCE13,
        0xD4AC, 0xDB97, 0xE2C8, 0xEA31, 0xF1C3, 0xF971, 0x0129, 0x08E1, 0x1088, 0x180F, 0x1F68, 0x2686, 0x2D5A, 0x33D8, 0x39F3, 0x3F9F,
        0x44D3, 0x4983, 0x4DA7, 0x5137, 0x542D, 0x5682, 0x5832, 0x593A, 0x5998, 0x594C, 0x5855, 0x56B6, 0x5472, 0x518D, 0x4E0C, 0x49F7,
        0x4555, 0x402F, 0x3A8E, 0x347E, 0x2E0A, 0x273E, 0x2028, 0x18D4, 0x1151, 0x09AD, 0x01F6, 0xFA3D, 0xF28D, 0xEAF8, 0xE38A, 0xDC53,
        0xD55F, 0xCEBD, 0xC879, 0xC29E, 0xBD39, 0xB852, 0xB3F4, 0xB028, 0xACF3, 0xAA5C, 0xA869, 0xA71C, 0xA679, 0xA681, 0xA733, 0xA88E,
        0xAA90, 0xAD34, 0xB077, 0xB451, 0xB8BB, 0xBDAD, 0xC31D, 0xC901, 0xCF4E, 0xD5F8, 0xDCF2, 0xE42F, 0xEBA1, 0xF339, 0xFAEA, 0x02A4,
        0x0A59, 0x11FB, 0x197B, 0x20CA, 0x27DA, 0x2E9F, 0x350B, 0x3B11, 0x40A7, 0x45C2, 0x4A59, 0x4E61, 0x51D4, 0x54AB, 0x56E1, 0x5871,
        0x5959, 0x5997, 0x592A, 0x5813, 0x5654, 0x53F0, 0x50ED, 0x4D50, 0x491F, 0x4463, 0x3F25, 0x396E, 0x334A, 0x2CC4, 0x25E9, 0x1EC6,
        0x1768, 0x0FDD, 0x0834, 0x007C, 0xF8C3, 0xF118, 0xE989, 0xE224, 0xDAF9, 0xD414, 0xCD83, 0xC752, 0xC18D, 0xBC3F, 0xB772, 0xB32F,
        0xAF7F, 0xAC68, 0xA9F0, 0xA81C, 0xA6F0, 0xA66E, 0xA696, 0xA768, 0xA8E3, 0xAB05, 0xADC8, 0xB128, 0xB51E, 0xB9A3, 0xBEAD, 0xC435,
        0xCA2E, 0xD08E, 0xD748, 0xDE4F, 0xE597, 0xED12, 0xF4B0, 0xFC64, 0x041E, 0x0BD1, 0x136D, 0x1AE4, 0x2228, 0x292C, 0x2FE0, 0x363A,
        0x3C2C, 0x41AB, 0x46AD, 0x4B29, 0x4F15, 0x526B, 0x5524, 0x573A, 0x58AB, 0x5972, 0x598F, 0x5901, 0x57CA, 0x55EC, 0x5369, 0x5048,
        0x4C8E, 0x4842, 0x436C, 0x3E16, 0x384A, 0x3212, 0x2B7B, 0x2491, 0x1D61, 0x15FA, 0x0E68, 0x06BB, 0xFF03, 0xF74B, 0xEFA3, 0xE81B,
        0xE0C1, 0xD9A2, 0xD2CC, 0xCC4C, 0xC62F, 0xC080, 0xBB4A, 0xB696, 0xB26F, 0xAEDC, 0xABE3, 0xA98A, 0xA7D6, 0xA6CA, 0xA668, 0xA6B1,
        0xA7A4, 0xA93F, 0xAB80, 0xAE61, 0xB1DE, 0xB5F0, 0xBA8F, 0xBFB2, 0xC550, 0xCB5E, 0xD1D0, 0xD89A, 0xDFAF, 0xE702, 0xEE84, 0xF628,
        0xFDDE, 0x0597, 0x0D47, 0x14DD, 0x1C4C, 0x2385, 0x2A7A, 0x311E, 0x3765, 0x3D42, 0x42AA, 0x4793, 0x4BF4, 0x4FC4, 0x52FD, 0x5597,
        0x578E, 0x58DE, 0x5985, 0x5981, 0x58D3, 0x577B, 0x557D, 0x52DC, 0x4F9D, 0x4BC7, 0x4760, 0x4271, 0x3D03, 0x3721, 0x30D7, 0x2A2F,
        0x2336, 0x1BFB, 0x148A, 0x0CF2, 0x0542, 0xFD88, 0xF5D3, 0xEE30, 0xE6B0, 0xDF5F, 0xD84D, 0xD187, 0xCB19, 0xC510, 0xBF77, 0xBA59,
        0xB5C0, 0xB1B4, 0xAE3E, 0xAB63, 0xA92A, 0xA796, 0xA6AA, 0xA669, 0xA6D2, 0xA7E5, 0xA9A0, 0xAC00, 0xAF00, 0xB29A, 0xB6C7, 0xBB81,
        0xC0BC, 0xC670, 0xCC92, 0xD316, 0xD9EF, 0xE111, 0xE86E, 0xEFF8, 0xF7A0, 0xFF58, 0x0711, 0x0EBD, 0x164D, 0x1DB2, 0x24DF, 0x2BC6,
        0x3259, 0x388C, 0x3E54, 0x43A4, 0x4874, 0x4CBA, 0x506E, 0x5388, 0x5604, 0x57DB, 0x590B, 0x5991, 0x596D, 0x589E, 0x5727, 0x5509,
        0x524A, 0x4EED, 0x4AFA, 0x4679, 0x4171, 0x3BEC, 0x35F5, 0x2F98, 0x28E0, 0x21D9, 0x1A93, 0x1319, 0x0B7C, 0x03C8, 0xFC0E, 0xF45B,
        0xECBE, 0xE546, 0xDE00, 0xD6FC, 0xD045, 0xC9EA, 0xC3F5, 0xBE73, 0xB96E, 0xB4EF, 0xB0FF, 0xADA6, 0xAAEA, 0xA8D0, 0xA75C, 0xA690,
        0xA670, 0xA6FA, 0xA82D, 0xAA08, 0xAC87, 0xAFA4, 0xB35B, 0xB7A4, 0xBC77, 0xC1CA, 0xC794, 0xCDC9, 0xD45F, 0xDB47, 0xE275, 0xE9DC,
        0xF16C, 0xF919, 0x00D1, 0x0889, 0x1031, 0x17BA, 0x1F16, 0x2636, 0x2D0E, 0x3390, 0x39AF, 0x3F61, 0x449A, 0x4950, 0x4D7B, 0x5112,
        0x540E, 0x566A, 0x5822, 0x5932, 0x5998, 0x5953, 0x5864, 0x56CC, 0x548F, 0x51B1, 0x4E37, 0x4A29, 0x458D, 0x406C, 0x3AD1, 0x34C6,
        0x2E56, 0x278E, 0x207A, 0x1929, 0x11A7, 0x0A04, 0x024E, 0xFA95, 0xF2E5, 0xEB4D, 0xE3DE, 0xDCA4, 0xD5AD, 0xCF07, 0xC8BE, 0xC2DE,
        0xBD73, 0xB887, 0xB423, 0xB050, 0xAD14, 0xAA76, 0xA87C, 0xA728, 0xA67D, 0xA67D, 0xA727, 0xA87B, 0xAA76, 0xAD13, 0xB04E, 0xB422,
        0xB886, 0xBD72, 0xC2DC, 0xC8BC, 0xCF04, 0xD5AA, 0xDCA1, 0xE3DB, 0xEB4B, 0xF2E2, 0xFA92, 0x024B, 0x0A02, 0x11A5, 0x1926, 0x2077,
        0x278B, 0x2E53, 0x34C3, 0x3ACF, 0x406A, 0x458B, 0x4A27, 0x4E36, 0x51B0, 0x548E, 0x56CB, 0x5863, 0x5952, 0x5998, 0x5932, 0x5823,
        0x566B, 0x540F, 0x5113, 0x4D7C, 0x4952, 0x449C, 0x3F63, 0x39B2, 0x3392, 0x2D10, 0x2639, 0x1F18, 0x17BD, 0x1034, 0x088C, 0x00D4,
        0xF91B, 0xF16F, 0xE9DE, 0xE278, 0xDB49, 0xD461, 0xCDCC, 0xC796, 0xC1CC, 0xBC79, 0xB7A6, 0xB35D, 0xAFA6, 0xAC88, 0xAA09, 0xA82E,
        0xA6FA, 0xA670, 0xA690, 0xA75B, 0xA8CF, 0xAAE9, 0xADA5, 0xB0FE, 0xB4EE, 0xB96C, 0xBE71, 0xC3F3, 0xC9E7, 0xD043, 0xD6F9, 0xDDFE,
        0xE543, 0xECBB, 0xF459, 0xFC0C, 0x03C6, 0x0B79, 0x1317, 0x1A90, 0x21D7, 0x28DD, 0x2F96, 0x35F3, 0x3BEA, 0x416F, 0x4677, 0x4AF9,
        0x4EEC, 0x5248, 0x5508, 0x5726, 0x589E, 0x596D, 0x5991, 0x590B, 0x57DC, 0x5604, 0x5389, 0x506F, 0x4CBC, 0x4876, 0x43A6, 0x3E56,
        0x388E, 0x325B, 0x2BC8, 0x24E1, 0x1DB5, 0x164F, 0x0EBF, 0x0713, 0xFF5B, 0xF7A3, 0xEFFA, 0xE870, 0xE114, 0xD9F2, 0xD318, 0xCC94,
        0xC672, 0xC0BE, 0xBB82, 0xB6C9, 0xB29B, 0xAF01, 0xAC01, 0xA9A1, 0xA7E6, 0xA6D2, 0xA669, 0xA6AA, 0xA795, 0xA929, 0xAB62, 0xAE3D,
        0xB1B3, 0xB5BF, 0xBA58, 0xBF75, 0xC50E, 0xCB17, 0xD185, 0xD84B, 0xDF5D, 0xE6AD, 0xEE2E, 0xF5D0, 0xFD86, 0x053F, 0x0CF0, 0x1488,
        0x1BF8, 0x2334, 0x2A2C, 0x30D4, 0x371F, 0x3D01, 0x426F, 0x475E, 0x4BC5, 0x4F9C, 0x52DB, 0x557D, 0x577B, 0x58D3, 0x5981, 0x5985,
        0x58DE, 0x578E, 0x5598, 0x52FE, 0x4FC6, 0x4BF6, 0x4795, 0x42AC, 0x3D44, 0x3767, 0x3120, 0x2A7C, 0x2387, 0x1C4F, 0x14E0, 0x0D4A,
        0x059A, 0xFDE1, 0xF62A, 0xEE87, 0xE704, 0xDFB2, 0xD89C, 0xD1D2, 0xCB60, 0xC552, 0xBFB4, 0xBA91, 0xB5F2, 0xB1DF, 0xAE62, 0xAB80,
        0xA940, 0xA7A4, 0xA6B1, 0xA668, 0xA6CA, 0xA7D6, 0xA989, 0xABE2, 0xAEDA, 0xB26E, 0xB695, 0xBB48, 0xC07E, 0xC62D, 0xCC4A, 0xD2CA,
        0xD99F, 0xE0BE, 0xE819, 0xEFA1, 0xF748, 0xFF00, 0x06B9, 0x0E66, 0x15F7, 0x1D5F, 0x248F, 0x2B79, 0x3210, 0x3848, 0x3E14, 0x436B,
        0x4840, 0x4C8D, 0x5047, 0x5368, 0x55EB, 0x57CA, 0x5901, 0x598F, 0x5972, 0x58AB, 0x573B, 0x5525, 0x526C, 0x4F17, 0x4B2A, 0x46AF,
        0x41AD, 0x3C2E, 0x363C, 0x2FE2, 0x292E, 0x222B, 0x1AE7, 0x1370, 0x0BD3, 0x0420, 0xFC67, 0xF4B3, 0xED14, 0xE59A, 0xDE52, 0xD74A,
        0xD090, 0xCA30, 0xC437, 0xBEAF, 0xB9A4, 0xB51F, 0xB129, 0xADC9, 0xAB06, 0xA8E4, 0xA769, 0xA696, 0xA66E, 0xA6F0, 0xA81C, 0xA9EF,
        0xAC67, 0xAF7E, 0xB32E, 0xB770, 0xBC3D, 0xC18B, 0xC750, 0xCD81, 0xD412, 0xDAF6, 0xE222, 0xE986, 0xF115, 0xF8C1, 0x0079, 0x0832,
        0x0FDA, 0x1765, 0x1EC3, 0x25E7, 0x2CC2, 0x3348, 0x396C, 0x3F23, 0x4461, 0x491E, 0x4D4E, 0x50EC, 0x53F0, 0x5653, 0x5812, 0x5929,
        0x5997, 0x5959, 0x5872, 0x56E2, 0x54AC, 0x51D5, 0x4E62, 0x4A5A, 0x45C4, 0x40A9, 0x3B13, 0x350D, 0x2EA1, 0x27DD, 0x20CC, 0x197D,
        0x11FE, 0x0A5C, 0x02A6, 0xFAED, 0xF33C, 0xEBA3, 0xE431, 0xDCF5, 0xD5FB, 0xCF51, 0xC903, 0xC31F, 0xBDAF, 0xB8BC, 0xB452, 0xB078,
        0xAD36, 0xAA91, 0xA88F, 0xA733, 0xA681, 0xA679, 0xA71C, 0xA868, 0xAA5B, 0xACF2, 0xB026, 0xB3F3, 0xB851, 0xBD37, 0xC29C, 0xC877,
        0xCEBB, 0xD55D, 0xDC50, 0xE387, 0xEAF5, 0xF28B, 0xFA3A, 0x01F3, 0x09AA, 0x114E, 0x18D1, 0x2025, 0x273C, 0x2E08, 0x347C, 0x3A8C,
        0x402D, 0x4553, 0x49F6, 0x4E0B, 0x518C, 0x5471, 0x56B5, 0x5855, 0x594B, 0x5998, 0x593A, 0x5832, 0x5682, 0x542D, 0x5138, 0x4DA8,
        0x4984, 0x44D4, 0x3FA1, 0x39F5, 0x33DA, 0x2D5C, 0x2688, 0x1F6B, 0x1812, 0x108A, 0x08E4, 0x012C, 0xF973, 0xF1C6, 0xEA34, 0xE2CB,
        0xDB9A, 0xD4AE, 0xCE15, 0xC7DB, 0xC20C, 0xBCB3, 0xB7DA, 0xB38A, 0xAFCD, 0xACA8, 0xAA22, 0xA83F, 0xA704, 0xA672, 0xA68B, 0xA74F,
        0xA8BB, 0xAACE, 0xAD82, 0xB0D5, 0xB4BE, 0xB936, 0xBE35, 0xC3B2, 0xC9A1, 0xCFF8, 0xD6AB, 0xDDAC, 0xE4EF, 0xEC65, 0xF401, 0xFBB4,
        0x036D, 0x0B22, 0x12C1, 0x1A3C, 0x2185, 0x288F, 0x2F4B, 0x35AD, 0x3BA9, 0x4133, 0x4640, 0x4AC8, 0x4EC2, 0x5225, 0x54EC, 0x5712,
        0x5891, 0x5967, 0x5993, 0x5915, 0x57ED, 0x561D, 0x53A9, 0x5096, 0x4CE9, 0x48AA, 0x43E0, 0x3E95, 0x38D2, 0x32A4, 0x2C15, 0x2532,
        0x1E08, 0x16A5, 0x0F16, 0x076B, 0xFFB3, 0xF7FA, 0xF051, 0xE8C5, 0xE166, 0xDA41, 0xD364, 0xCCDC, 0xC6B6, 0xC0FD, 0xBBBB, 0xB6FC,
        0xB2C8, 0xAF27, 0xAC20, 0xA9B9, 0xA7F6, 0xA6DB, 0xA66A, 0xA6A3, 0xA787, 0xA914, 0xAB46, 0xAE19, 0xB188, 0xB58D, 0xBA20, 0xBF38,
        0xC4CC, 0xCAD0, 0xD139, 0xD7FC, 0xDF0B, 0xE659, 0xEDD7, 0xF578, 0xFD2E, 0x04E7, 0x0C99, 0x1432, 0x1BA5, 0x22E3, 0x29DE, 0x308A,
        0x36DA, 0x3CC1, 0x4234, 0x4729, 0x4B96, 0x4F74, 0x52BA, 0x5562, 0x5768, 0x58C7, 0x597D, 0x5988, 0x58E9, 0x57A1, 0x55B1, 0x531F,
        0x4FEE, 0x4C24, 0x47CA, 0x42E7, 0x3D84, 0x37AC, 0x316A, 0x2ACA, 0x23D8, 0x1CA2, 0x1536, 0x0DA1, 0x05F2, 0xFE39, 0xF682, 0xEEDD,
        0xE759, 0xE004, 0xD8EC, 0xD21E, 0xCBA8, 0xC595, 0xBFF2, 0xBAC9, 0xB623, 0xB20B, 0xAE87, 0xAB9E, 0xA956, 0xA7B3, 0xA6B8, 0xA668,
        0xA6C2, 0xA7C6, 0xA972, 0xABC3, 0xAEB5, 0xB242, 0xB662, 0xBB0F, 0xC040, 0xC5EA, 0xCC02, 0xD27E, 0xD950, 0xE06C, 0xE7C4, 0xEF4A,
        0xF6F0, 0xFEA8, 0x0661, 0x0E0F, 0x15A2, 0x1D0B, 0x243E, 0x2B2B, 0x31C7, 0x3803, 0x3DD5, 0x4330, 0x480C, 0x4C5F, 0x5020, 0x5348,
        0x55D2, 0x57B8, 0x58F7, 0x598C, 0x5977, 0x58B8, 0x574F, 0x5540, 0x528F, 0x4F40, 0x4B5A, 0x46E5, 0x41E9, 0x3C6F, 0x3682, 0x302D,
        0x297C, 0x227C, 0x1B3B, 0x13C6, 0x0C2B, 0x0478, 0xFCBF, 0xF50A, 0xED6A, 0xE5EE, 0xDEA4, 0xD799, 0xD0DB, 0xCA77, 0xC478, 0xBEEC,
        0xB9DB, 0xB550, 0xB153, 0xADEC, 0xAB22, 0xA8F9, 0xA776, 0xA69C, 0xA66C, 0xA6E6, 0xA80B, 0xA9D7, 0xAC47, 0xAF57, 0xB300, 0xB73D,
        0xBC03, 0xC14C, 0xC70C, 0xCD38, 0xD3C5, 0xDAA6, 0xE1CF, 0xE931, 0xF0BE, 0xF869, 0x0021, 0x07DA, 0x0F84, 0x1710, 0x1E70, 0x2597,
        0x2C75, 0x32FF, 0x3928, 0x3EE4, 0x4428, 0x48EA, 0x4D22, 0x50C6, 0x53D1, 0x563B, 0x5802, 0x5921, 0x5995, 0x5960, 0x5880, 0x56F7,
        0x54C9, 0x51F9, 0x4E8D, 0x4A8B, 0x45FB, 0x40E6, 0x3B55, 0x3554, 0x2EEC, 0x282B, 0x211E, 0x19D2, 0x1254, 0x0AB3, 0x02FE, 0xFB45,
        0xF393, 0xEBF9, 0xE485, 0xDD46, 0xD649, 0xCF9B, 0xC949, 0xC360, 0xBDEA, 0xB8F2, 0xB482, 0xB0A1, 0xAD57, 0xAAAB, 0xA8A2, 0xA73F,
        0xA685, 0xA676, 0xA711, 0xA856, 0xAA42, 0xACD1, 0xAFFE, 0xB3C5, 0xB81C, 0xBCFC, 0xC25C, 0xC831, 0xCE71, 0xD50F, 0xDBFF, 0xE334,
        0xEA9F, 0xF234, 0xF9E2, 0x019B, 0x0952, 0x10F8, 0x187D, 0x1FD3, 0x26ED, 0x2DBC, 0x3435, 0x3A49, 0x3FEF, 0x451B, 0x49C4, 0x4DDF,
        0x5167, 0x5453, 0x569F, 0x5846, 0x5944, 0x5998, 0x5942, 0x5842, 0x5699, 0x544C, 0x515D, 0x4DD4, 0x49B7, 0x450D, 0x3FDF, 0x3A38,
        0x3422, 0x2DA8, 0x26D8, 0x1FBD, 0x1867, 0x10E1, 0x093B, 0x0184, 0xF9CB, 0xF21D, 0xEA89, 0xE31E, 0xDBEA, 0xD4FB, 0xCE5E, 0xC820,
        0xC24B, 0xBCED, 0xB80E, 0xB3B8, 0xAFF4, 0xACC8, 0xAA3B, 0xA851, 0xA70E, 0xA675, 0xA686, 0xA742, 0xA8A7, 0xAAB2, 0xAD60, 0xB0AB,
        0xB48E, 0xB900, 0xBDF9, 0xC371, 0xC95B, 0xCFAE, 0xD65D, 0xDD5B, 0xE49B, 0xEC0F, 0xF3AA, 0xFB5C, 0x0315, 0x0ACA, 0x126A, 0x19E8,
        0x2133, 0x2840, 0x2F00, 0x3566, 0x3B67, 0x40F6, 0x460A, 0x4A98, 0x4E98, 0x5202, 0x54D0, 0x56FD, 0x5883, 0x5961, 0x5995, 0x591E,
        0x57FD, 0x5635, 0x53C8, 0x50BC, 0x4D16, 0x48DD, 0x4419, 0x3ED4, 0x3916, 0x32EC, 0x2C61, 0x2582, 0x1E5B, 0x16FA, 0x0F6D, 0x07C3,
        0x000A, 0xF852, 0xF0A8, 0xE91B, 0xE1B9, 0xDA91, 0xD3B1, 0xCD25, 0xC6FA, 0xC13B, 0xBBF4, 0xB72F, 0xB2F5, 0xAF4D, 0xAC3F, 0xA9D1,
        0xA807, 0xA6E4, 0xA66B, 0xA69D, 0xA779, 0xA8FE, 0xAB29, 0xADF5, 0xB15E, 0xB55D, 0xB9E9, 0xBEFB, 0xC48A, 0xCA89, 0xD0EE, 0xD7AD,
        0xDEB9, 0xE604, 0xED81, 0xF521, 0xFCD6, 0x048F, 0x0C41, 0x13DC, 0x1B51, 0x2292, 0x2990, 0x3040, 0x3694, 0x3C80, 0x41F8, 0x46F3,
        0x4B67, 0x4F4B, 0x5298, 0x5547, 0x5754, 0x58BB, 0x5978, 0x598C, 0x58F4, 0x57B3, 0x55CB, 0x533F, 0x5015, 0x4C53, 0x47FE, 0x4321,
        0x3DC4, 0x37F1, 0x31B3, 0x2B17, 0x2429, 0x1CF6, 0x158B, 0x0DF8, 0x064A, 0xFE91, 0xF6DA, 0xEF34, 0xE7AE, 0xE056, 0xD93B, 0xD26A,
        0xCBEF, 0xC5D8, 0xC030, 0xBB01, 0xB655, 0xB236, 0xAEAC, 0xABBC, 0xA96C, 0xA7C2, 0xA6C0, 0xA668, 0xA6BA, 0xA7B7, 0xA95C, 0xABA6,
        0xAE90, 0xB216, 0xB630, 0xBAD7, 0xC002, 0xC5A7, 0xCBBA, 0xD232, 0xD900, 0xE019, 0xE76F, 0xEEF4, 0xF699, 0xFE50, 0x0609, 0x0DB8,
        0x154C, 0x1CB8, 0x23ED, 0x2ADE, 0x317D, 0x37BE, 0x3D95, 0x42F6, 0x47D8, 0x4C30, 0x4FF8, 0x5327, 0x55B8, 0x57A6, 0x58EC, 0x5989,
        0x597C, 0x58C4, 0x5763, 0x555B, 0x52B1, 0x4F69, 0x4B8A, 0x471B, 0x4224, 0x3CB0, 0x36C8, 0x3077, 0x29CA, 0x22CE, 0x1B8F, 0x141B,
        0x0C82, 0x04D0, 0xFD17, 0xF562, 0xEDC1, 0xE643, 0xDEF6, 0xD7E7, 0xD126, 0xCABD, 0xC4BA, 0xBF28, 0xBA12, 0xB581, 0xB17D, 0xAE10,
        0xAB3E, 0xA90E, 0xA784, 0xA6A2, 0xA66A, 0xA6DD, 0xA7FA, 0xA9BF, 0xAC28, 0xAF31, 0xB2D4, 0xB709, 0xBBCA, 0xC10D, 0xC6C8, 0xCCEF,
        0xD378, 0xDA56, 0xE17C, 0xE8DC, 0xF068, 0xF811, 0xFFCA, 0x0782, 0x0F2D, 0x16BB, 0x1E1D, 0x2547, 0x2C29, 0x32B7, 0x38E4, 0x3EA5,
        0x43EF, 0x48B7, 0x4CF5, 0x50A0, 0x53B1, 0x5623, 0x57F1, 0x5917, 0x5994, 0x5966, 0x588D, 0x570C, 0x54E5, 0x521C, 0x4EB7, 0x4ABC,
        0x4632, 0x4123, 0x3B97, 0x359A, 0x2F37, 0x287A, 0x2170, 0x1A26, 0x12AA, 0x0B0B, 0x0357, 0xFB9D, 0xF3EA, 0xEC4F, 0xE4D9, 0xDD97,
        0xD697, 0xCFE5, 0xC98F, 0xC3A1, 0xBE26, 0xB928, 0xB4B1, 0xB0CA, 0xAD7A, 0xAAC6, 0xA8B6, 0xA74B, 0xA68A, 0xA673, 0xA707, 0xA844,
        0xAA28, 0xACB0, 0xAFD7, 0xB396, 0xB7E7, 0xBCC2, 0xC21C, 0xC7ED, 0xCE28, 0xD4C2, 0xDBAF, 0xE2E1, 0xEA4A, 0xF1DD, 0xF98A, 0x0143,
        0x08FB, 0x10A1, 0x1828, 0x1F80, 0x269D, 0x2D70, 0x33ED, 0x3A06, 0x3FB1, 0x44E3, 0x4992, 0x4DB4, 0x5142, 0x5435, 0x5688, 0x5836,
        0x593C, 0x5998, 0x594A, 0x5851, 0x56B0, 0x5469, 0x5182, 0x4E00, 0x49E9, 0x4545, 0x401D, 0x3A7B, 0x3469, 0x2DF4, 0x2727, 0x2010,
        0x18BB, 0x1138, 0x0993, 0x01DC, 0xFA23, 0xF274, 0xEADF, 0xE372, 0xDC3B, 0xD549, 0xCEA8, 0xC865, 0xC28B, 0xBD27, 0xB843, 0xB3E7,
        0xB01C, 0xACE9, 0xAA55, 0xA864, 0xA719, 0xA678, 0xA682, 0xA736, 0xA894, 0xAA98, 0xAD3E, 0xB083, 0xB45E, 0xB8CA, 0xBDBE, 0xC330,
        0xC916, 0xCF64, 0xD60F, 0xDD0A, 0xE447, 0xEBBA, 0xF353, 0xFB04, 0x02BD, 0x0A73, 0x1214, 0x1993, 0x20E1, 0x27F1, 0x2EB5, 0x351F,
        0x3B25, 0x40B9, 0x45D3, 0x4A67, 0x4E6D, 0x51DE, 0x54B4, 0x56E7, 0x5875, 0x595B, 0x5996, 0x5927, 0x580E, 0x564D, 0x53E7, 0x50E2,
        0x4D43, 0x4910, 0x4452, 0x3F12, 0x395A, 0x3335, 0x2CAE, 0x25D2, 0x1EAE, 0x174F, 0x0FC4, 0x081B, 0x0062, 0xF8AA, 0xF0FF, 0xE970,
        0xE20C, 0xDAE2, 0xD3FE, 0xCD6E, 0xC73E, 0xC17A, 0xBC2E, 0xB763, 0xB322, 0xAF73, 0xAC5F, 0xA9E9, 0xA817, 0xA6ED, 0xA66D, 0xA697,
        0xA76C, 0xA8E9, 0xAB0D, 0xADD2, 0xB134, 0xB52C, 0xB9B2, 0xBEBF, 0xC448, 0xCA42, 0xD0A3, 0xD75F, 0xDE67, 0xE5B0, 0xED2B, 0xF4C9,
        0xFC7D, 0x0437, 0x0BEA, 0x1386, 0x1AFD, 0x2240, 0x2942, 0x2FF6, 0x364E, 0x3C3F, 0x41BC, 0x46BD, 0x4B37, 0x4F21, 0x5275, 0x552C,
        0x5740, 0x58AE, 0x5974, 0x598E, 0x58FE, 0x57C5, 0x55E4, 0x5360, 0x503D, 0x4C81, 0x4833, 0x435B, 0x3E04, 0x3836, 0x31FD, 0x2B64,
        0x247A, 0x1D49, 0x15E1, 0x0E4F, 0x06A2, 0xFEE9, 0xF731, 0xEF8A, 0xE803, 0xE0A9, 0xD98B, 0xD2B6, 0xCC37, 0xC61B, 0xC06E, 0xBB39,
        0xB688, 0xB262, 0xAED1, 0xABDA, 0xA983, 0xA7D1, 0xA6C8, 0xA668, 0xA6B3, 0xA7A8, 0xA945, 0xAB88, 0xAE6C, 0xB1EB, 0xB5FF, 0xBA9F,
        0xBFC4, 0xC564, 0xCB73, 0xD1E6, 0xD8B1, 0xDFC7, 0xE71A, 0xEE9D, 0xF641, 0xFDF8, 0x05B1, 0x0D60, 0x14F6, 0x1C64, 0x239C, 0x2A91,
        0x3134, 0x3779, 0x3D54, 0x42BB, 0x47A3, 0x4C02, 0x4FD0, 0x5306, 0x559E, 0x5793, 0x58E1, 0x5986, 0x5980, 0x58D0, 0x5776, 0x5576,
        0x52D3, 0x4F92, 0x4BB9, 0x4750, 0x4260, 0x3CF0, 0x370D, 0x30C1, 0x2A18, 0x231F, 0x1BE3, 0x1471, 0x0CD9, 0x0528, 0xFD6F, 0xF5B9,
        0xEE17, 0xE697, 0xDF48, 0xD836, 0xD171, 0xCB04, 0xC4FD, 0xBF65, 0xBA49, 0xB5B2, 0xB1A8, 0xAE33, 0xAB5B, 0xA923, 0xA792, 0xA6A8,
        0xA669, 0xA6D5, 0xA7EA, 0xA9A7, 0xAC09, 0xAF0B, 0xB2A7, 0xB6D6, 0xBB91, 0xC0CE, 0xC684, 0xCCA7, 0xD32C, 0xDA06, 0xE129, 0xE887,
        0xF011, 0xF7B9, 0xFF72, 0x072A, 0x0ED6, 0x1665, 0x1DCA, 0x24F6, 0x2BDC, 0x326E, 0x38A0, 0x3E66, 0x43B5, 0x4883, 0x4CC7, 0x5079,
        0x5392, 0x560B, 0x57E0, 0x590E, 0x5992, 0x596B, 0x589B, 0x5721, 0x5501, 0x523F, 0x4EE1, 0x4AEC, 0x4669, 0x415F, 0x3BD9, 0x35E1,
        0x2F82, 0x28C9, 0x21C2, 0x1A7A, 0x1300, 0x0B62, 0x03AF, 0xFBF5, 0xF442, 0xECA5, 0xE52D, 0xDDE9, 0xD6E5, 0xD02F, 0xC9D5, 0xC3E2,
        0xBE62, 0xB95E, 0xB4E1, 0xB0F3, 0xAD9C, 0xAAE2, 0xA8CA, 0xA758, 0xA68F, 0xA670, 0xA6FD, 0xA832, 0xAA0F, 0xAC90, 0xAFB0, 0xB368,
        0xB7B3, 0xBC88, 0xC1DD, 0xC7A8, 0xCDDF, 0xD475, 0xDB5E, 0xE28D, 0xE9F4, 0xF186, 0xF932, 0x00EB, 0x08A3, 0x104A, 0x17D3, 0x1F2E,
        0x264E, 0x2D24, 0x33A5, 0x39C3, 0x3F73, 0x44AB, 0x495F, 0x4D88, 0x511D, 0x5417, 0x5671, 0x5827, 0x5934, 0x5998, 0x5951, 0x585F,
        0x56C6, 0x5487, 0x51A7, 0x4E2B, 0x4A1A, 0x457D, 0x405A, 0x3ABE, 0x34B1, 0x2E40, 0x2777, 0x2062, 0x1910, 0x118E, 0x09EB, 0x0235,
        0xFA7B, 0xF2CB, 0xEB34, 0xE3C5, 0xDC8C, 0xD596, 0xCEF1, 0xC8AA, 0xC2CC, 0xBD62, 0xB878, 0xB416, 0xB044, 0xAD0A, 0xAA6F, 0xA876,
        0xA724, 0xA67C, 0xA67E, 0xA72B, 0xA881, 0xAA7D, 0xAD1D, 0xB05A, 0xB42F, 0xB895, 0xBD83, 0xC2EF, 0xC8D0, 0xCF1A, 0xD5C1, 0xDCB9,
        0xE3F3, 0xEB64, 0xF2FB, 0xFAAC, 0x0265, 0x0A1B, 0x11BE, 0x193F, 0x208F, 0x27A2, 0x2E69, 0x34D8, 0x3AE2, 0x407C, 0x459B, 0x4A36,
        0x4E43, 0x51BA, 0x5497, 0x56D2, 0x5867, 0x5954, 0x5997, 0x5930, 0x581E, 0x5664, 0x5406, 0x5108, 0x4D6F, 0x4943, 0x448B, 0x3F51,
        0x399E, 0x337D, 0x2CFA, 0x2622, 0x1F00, 0x17A4, 0x101B, 0x0873, 0x00BA, 0xF902, 0xF156, 0xE9C5, 0xE25F, 0xDB32, 0xD44B, 0xCDB6,
        0xC782, 0xC1BA, 0xBC68, 0xB796, 0xB34F, 0xAF9A, 0xAC7E, 0xAA02, 0xA829, 0xA6F7, 0xA66F, 0xA692, 0xA75F, 0xA8D5, 0xAAF1, 0xADAF,
        0xB10A, 0xB4FC, 0xB97C, 0xBE83, 0xC406, 0xC9FC, 0xD059, 0xD710, 0xDE16, 0xE55C, 0xECD5, 0xF472, 0xFC25, 0x03DF, 0x0B93, 0x1330,
        0x1AA9, 0x21EF, 0x28F4, 0x2FAB, 0x3608, 0x3BFD, 0x4180, 0x4687, 0x4B07, 0x4EF8, 0x5253, 0x5510, 0x572C, 0x58A2, 0x596E, 0x5991,
        0x5908, 0x57D7, 0x55FD, 0x5380, 0x5064, 0x4CAE, 0x4867, 0x4395, 0x3E43, 0x387A, 0x3246, 0x2BB2, 0x24CA, 0x1D9C, 0x1636, 0x0EA6,
        0x06FA, 0xFF41, 0xF789, 0xEFE1, 0xE858, 0xE0FB, 0xD9DA, 0xD302, 0xCC7F, 0xC65F, 0xC0AC, 0xBB72, 0xB6BA, 0xB28E, 0xAEF6, 0xABF8,
        0xA99A, 0xA7E1, 0xA6D0, 0xA669, 0xA6AC, 0xA799, 0xA92F, 0xAB6B, 0xAE47, 0xB1C0, 0xB5CD, 0xBA68, 0xBF87, 0xC521, 0xCB2C, 0xD19B,
        0xD862, 0xDF75, 0xE6C6, 0xEE47, 0xF5E9, 0xFD9F, 0x0559, 0x0D09, 0x14A1, 0x1C11, 0x234B, 0x2A43, 0x30EA, 0x3734, 0x3D14, 0x4280,
        0x476E, 0x4BD3, 0x4FA8, 0x52E5, 0x5584, 0x5780, 0x58D6, 0x5982, 0x5984, 0x58DB, 0x5789, 0x5590, 0x52F4, 0x4FBA, 0x4BE8, 0x4786,
        0x429B, 0x3D31, 0x3753, 0x310B, 0x2A66, 0x2370, 0x1C36, 0x14C7, 0x0D30, 0x0580, 0xFDC7, 0xF611, 0xEE6D, 0xE6EC, 0xDF9A, 0xD885,
        0xD1BC, 0xCB4C, 0xC53F, 0xBFA3, 0xBA81, 0xB5E3, 0xB1D3, 0xAE58, 0xAB78, 0xA939, 0xA7A0, 0xA6AF, 0xA668, 0xA6CC, 0xA7DA, 0xA990,
        0xABEA, 0xAEE5, 0xB27B, 0xB6A4, 0xBB58, 0xC090, 0xC640, 0xCC5F, 0xD2E0, 0xD9B7, 0xE0D6, 0xE832, 0xEFBA, 0xF762, 0xFF1A, 0x06D2,
        0x0E7F, 0x1610, 0x1D77, 0x24A6, 0x2B8F, 0x3225, 0x385C, 0x3E27, 0x437B, 0x4850, 0x4C9A, 0x5052, 0x5372, 0x55F2, 0x57CF, 0x5904,
        0x5990, 0x5971, 0x58A7, 0x5735, 0x551D, 0x5262, 0x4F0B, 0x4B1D, 0x469F, 0x419B, 0x3C1B, 0x3627, 0x2FCD, 0x2917, 0x2213, 0x1ACE,
        0x1357, 0x0BBA, 0x0407, 0xFC4D, 0xF499, 0xECFB, 0xE581, 0xDE3A, 0xD733, 0xD07A, 0xCA1B, 0xC424, 0xBE9E, 0xB994, 0xB511, 0xB11D,
        0xADBF, 0xAAFD, 0xA8DE, 0xA765, 0xA694, 0xA66E, 0xA6F3, 0xA821, 0xA9F6, 0xAC70, 0xAF89, 0xB33B, 0xB77F, 0xBC4E, 0xC19D, 0xC764,
        0xCD96, 0xD428, 0xDB0E, 0xE23A, 0xE99F, 0xF12F, 0xF8DA, 0x0093, 0x084B, 0x0FF4, 0x177E, 0x1EDB, 0x25FE, 0x2CD8, 0x335D, 0x3980,
        0x3F35, 0x4472, 0x492C, 0x4D5B, 0x50F7, 0x53F8, 0x565A, 0x5817, 0x592C, 0x5997, 0x5957, 0x586E, 0x56DB, 0x54A4, 0x51CB, 0x4E56,
        0x4A4C, 0x45B4, 0x4098, 0x3B00, 0x34F8, 0x2E8B, 0x27C6, 0x20B4, 0x1965, 0x11E5, 0x0A42, 0x028D, 0xFAD3, 0xF322, 0xEB8A, 0xE419,
        0xDCDD, 0xD5E4, 0xCF3B, 0xC8EF, 0xC30C, 0xBD9D, 0xB8AD, 0xB444, 0xB06C, 0xAD2C, 0xAA89, 0xA889, 0xA730, 0xA680, 0xA67A, 0xA71F,
        0xA86E, 0xAA63, 0xACFB, 0xB032, 0xB401, 0xB860, 0xBD48, 0xC2AF, 0xC88B, 0xCED0, 0xD573, 0xDC68, 0xE3A0, 0xEB0E, 0xF2A4, 0xFA54,
        0x020D, 0x09C3, 0x1167, 0x18EA, 0x203D, 0x2753, 0x2E1E, 0x3491, 0x3AA0, 0x403F, 0x4564, 0x4A04, 0x4E18, 0x5196, 0x5479, 0x56BC,
        0x5859, 0x5906, 0x5909, 0x5862, 0x5714, 0x5522, 0x5291, 0x4F68, 0x4BAC, 0x4766, 0x42A0, 0x3D62, 0x37B8, 0x31AD, 0x2B4E, 0x24A7,
        0x1DC5, 0x16B5, 0x0F86, 0x0846, 0x0101, 0xF9C8, 0xF2A6, 0xEBAA, 0xE4DF, 0xDE54, 0xD814, 0xD22A, 0xCCA2, 0xC785, 0xC2DC, 0xBEB0,
        0xBB07, 0xB7E7, 0xB556, 0xB358, 0xB1EF, 0xB11D, 0xB0E3, 0xB140, 0xB232, 0xB3B6, 0xB5C9, 0xB866, 0xBB87, 0xBF24, 0xC336, 0xC7B5,
        0xCC97, 0xD1D3, 0xD75D, 0xDD2A, 0xE330, 0xE961, 0xEFB3, 0xF618, 0xFC84, 0x02EB, 0x0941, 0x0F7A, 0x158A, 0x1B67, 0x2104, 0x2658,
        0x2B59, 0x2FFF, 0x3441, 0x3817, 0x3B7B, 0x3E68, 0x40D8, 0x42C9, 0x4436, 0x451F, 0x4583, 0x4562, 0x44BD, 0x4396, 0x41F0, 0x3FD0,
        0x3D3B, 0x3A36, 0x36C8, 0x32F9, 0x2ECF, 0x2A55, 0x2592, 0x2092, 0x1B5D, 0x15FE, 0x1080, 0x0AED, 0x0550, 0xFFB6, 0xFA26, 0xF4AC,
        0xEF53, 0xEA24, 0xE529, 0xE06B, 0xDBF3, 0xD7C9, 0xD3F4, 0xD07A, 0xCD62, 0xCAB1, 0xC86A, 0xC692, 0xC52C, 0xC438, 0xC3B8, 0xC3AC,
        0xC413, 0xC4EC, 0xC633, 0xC7E5, 0xC9FF, 0xCC7B, 0xCF54, 0xD284, 0xD603, 0xD9CC, 0xDDD4, 0xE216, 0xE687, 0xEB1F, 0xEFD5, 0xF49F,
        0xF975, 0xFE4D, 0x031C, 0x07DC, 0x0C83, 0x1107, 0x1561, 0x1989, 0x1D77, 0x2123, 0x2489, 0x27A1, 0x2A67, 0x2CD6, 0x2EEA, 0x309F,
        0x31F5, 0x32E8, 0x3377, 0x33A4, 0x336D, 0x32D6, 0x31DE, 0x308A, 0x2EDD, 0x2CDA, 0x2A86, 0x27E7, 0x2502, 0x21DD, 0x1E7F, 0x1AEF,
        0x1735, 0x1357, 0x0F5D, 0x0B50, 0x0737, 0x031A, 0xFF02, 0xFAF5, 0xF6FC, 0xF31E, 0xEF61, 0xEBCE, 0xE86A, 0xE53B, 0xE248, 0xDF94,
        0xDD25, 0xDAFF, 0xD925, 0xD799, 0xD65E, 0xD576, 0xD4E1, 0xD4A0, 0xD4B3, 0xD518, 0xD5CD, 0xD6D1, 0xD821, 0xD9BA, 0xDB97, 0xDDB5,
        0xE00F, 0xE29F, 0xE560, 0xE84D, 0xEB60, 0xEE91, 0xF1DB, 0xF537, 0xF89E, 0xFC0A, 0xFF74, 0x02D5, 0x0628, 0x0966, 0x0C89, 0x0F8C,
        0x1268, 0x1519, 0x179B, 0x19E8, 0x1BFD, 0x1DD7, 0x1F72, 0x20CD, 0x21E5, 0x22BA, 0x234A, 0x2395, 0x239B, 0x235D, 0x22DC, 0x221A,
        0x211A, 0x1FDD, 0x1E67, 0x1CBB, 0x1ADE, 0x18D3, 0x169F, 0x1446, 0x11CE, 0x0F3C, 0x0C94, 0x09DD, 0x071C, 0x0455, 0x018F, 0xFED0,
        0xFC1A, 0xF975, 0xF6E5, 0xF46F, 0xF216, 0xEFE0, 0xEDD0, 0xEBE9, 0xEA2F, 0xE8A4, 0xE74B, 0xE626, 0xE536, 0xE47C, 0xE3FA, 0xE3AF,
        0xE39A, 0xE3BD, 0xE415, 0xE4A1, 0xE560, 0xE64F, 0xE76B, 0xE8B3, 0xEA23, 0xEBB8, 0xED6E, 0xEF41, 0xF12E, 0xF330, 0xF543, 0xF764,
        0xF98D, 0xFBBA, 0xFDE7, 0x0010, 0x0231, 0x0446, 0x064B, 0x083C, 0x0A17, 0x0BD6, 0x0D79, 0x0EFB, 0x105A, 0x1195, 0x12AA, 0x1396,
        0x1459, 0x14F2, 0x1561, 0x15A5, 0x15BE, 0x15AD, 0x1573, 0x1511, 0x1487, 0x13D9, 0x1308, 0x1215, 0x1104, 0x0FD6, 0x0E90, 0x0D32,
        0x0BC2, 0x0A41, 0x08B3, 0x071B, 0x057C, 0x03DA, 0x0238, 0x0099, 0xFF02, 0xFD72, 0xFBEF, 0xFA7A, 0xF917, 0xF7C7, 0xF68E, 0xF56C,
        0xF465, 0xF378, 0xF2A8, 0xF1F6, 0xF162, 0xF0ED, 0xF098, 0xF061, 0xF04A, 0xF052, 0xF078, 0xF0BB, 0xF11A, 0xF194, 0xF227, 0xF2D2,
        0xF393, 0xF468, 0xF54F, 0xF646, 0xF74A, 0xF85A, 0xF972, 0xFA92, 0xFBB5, 0xFCDA, 0xFDFF, 0xFF22, 0x003E, 0x0155, 0x0262, 0x0365,
        0x045B, 0x0543, 0x061B, 0x06E3, 0x0798, 0x083A, 0x08C8, 0x0941, 0x09A6, 0x09F5, 0x0A2F, 0x0A53, 0x0A62, 0x0A5D, 0x0A44, 0x0A17,
        0x09D7, 0x0987, 0x0925, 0x08B4, 0x0836, 0x07AA, 0x0714, 0x0674, 0x05CC, 0x051D, 0x0469, 0x03B2, 0x02F9, 0x023F, 0x0187, 0x00D1,
        0x0020, 0xFF74, 0xFECE, 0xFE30, 0xFD9A, 0xFD0E, 0xFC8D, 0xFC16, 0xFBAC, 0xFB4D, 0xFAFC, 0xFAB7, 0xFA7F, 0xFA54, 0xFA36, 0xFA25,
        0xFA21, 0xFA28, 0xFA3B, 0xFA59, 0xFA81, 0xFAB3, 0xFAEE, 0xFB30, 0xFB7A, 0xFBCA, 0xFC20, 0xFC79, 0xFCD6, 0xFD36, 0xFD97, 0xFDF9,
        0xFE5B, 0xFEBB, 0xFF1A, 0xFF76, 0xFFCE, 0x0022, 0x0072, 0x00BD, 0x0102, 0x0142, 0x017C, 0x01AF, 0x01DB, 0x0201, 0x0220, 0x0239,
        0x024B, 0x0257, 0x025C, 0x025C, 0x0257, 0x024C, 0x023D, 0x0229, 0x0211, 0x01F7, 0x01D9, 0x01B9, 0x0198, 0x0174, 0x0151, 0x012C,
        0x0108, 0x00E4, 0x00C1, 0x00A0, 0x0080, 0x0061, 0x0045, 0x002C, 0x0014, 0x0000, 0xFFEE, 0xFFDF, 0xFFD2, 0xFFC8, 0xFFC0, 0xFFBB,
        0xFFB8, 0xFFB7, 0xFFB9, 0xFFBB, 0xFFC0, 0xFFC5, 0xFFCB, 0xFFD2, 0xFFDA, 0xFFE1, 0xFFE8, 0xFFEF, 0xFFF5, 0xFFFA, 0xFFFE, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0006, 0x0007, 0x0008, 0x000A, 0x000B, 0x000D, 0x000E, 0x000F,
        0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x000E, 0x000D, 0x000A, 0x0008, 0x0004, 0x0000, 0xFFFC, 0xFFF6, 0xFFF0, 0xFFE8, 0xFFE1,
        0xFFD8, 0xFFCF, 0xFFC5, 0xFFBA, 0xFFAF, 0xFFA3, 0xFF97, 0xFF8B, 0xFF7E, 0xFF71, 0xFF64, 0xFF57, 0xFF4A, 0xFF3E, 0xFF31, 0xFF26,
        0xFF1B, 0xFF10, 0xFF07, 0xFEFF, 0xFEF8, 0xFEF2, 0xFEEE, 0xFEEB, 0xFEEA, 0xFEEB, 0xFEEE, 0xFEF3, 0xFEFA, 0xFF04, 0xFF0F, 0xFF1D,
        0xFF2D, 0xFF40, 0xFF55, 0xFF6C, 0xFF86, 0xFFA2, 0xFFC0, 0xFFE1, 0x0002, 0x0027, 0x004D, 0x0075, 0x009F, 0x00CA, 0x00F6, 0x0122,
        0x0150, 0x017E, 0x01AC, 0x01D9, 0x0207, 0x0233, 0x025F, 0x0289, 0x02B2, 0x02D9, 0x02FD, 0x031F, 0x033E, 0x0359, 0x0371, 0x0386,
        0x0396, 0x03A2, 0x03A9, 0x03AC, 0x03AA, 0x03A2, 0x0395, 0x0383, 0x036B, 0x034E, 0x032B, 0x0302, 0x02D4, 0x02A0, 0x0266, 0x0228,
        0x01E3, 0x019A, 0x014D, 0x00FA, 0x00A4, 0x0049, 0xFFEC, 0xFF8B, 0xFF27, 0xFEC1, 0xFE59, 0xFDF0, 0xFD86, 0xFD1C, 0xFCB2, 0xFC49,
        0xFBE2, 0xFB7D, 0xFB1A, 0xFABB, 0xFA60, 0xFA0A, 0xF9B8, 0xF96D, 0xF927, 0xF8E9, 0xF8B2, 0xF882, 0xF85B, 0xF83D, 0xF829, 0xF81D,
        0xF81C, 0xF824, 0xF838, 0xF855, 0xF87E, 0xF8B1, 0xF8EF, 0xF937, 0xF98B, 0xF9E9, 0xFA51, 0xFAC3, 0xFB3F, 0xFBC4, 0xFC52, 0xFCE9,
        0xFD87, 0xFE2D, 0xFED8, 0xFF8A, 0x0040, 0x00FB, 0x01B9, 0x0279, 0x033C, 0x03FE, 0x04C1, 0x0582, 0x0640, 0x06FB, 0x07B2, 0x0863,
        0x090D, 0x09B0, 0x0A4B, 0x0ADC, 0x0B63, 0x0BDE, 0x0C4D, 0x0CAF, 0x0D03, 0x0D49, 0x0D7F, 0x0DA6, 0x0DBC, 0x0DC2, 0x0DB6, 0x0D99,
        0x0D6A, 0x0D29, 0x0CD7, 0x0C73, 0x0BFD, 0x0B75, 0x0ADC, 0x0A33, 0x0979, 0x08B0, 0x07D8, 0x06F2, 0x05FF, 0x04FF, 0x03F4, 0x02DE,
        0x01C0, 0x009A, 0xFF6F, 0xFE3D, 0xFD08, 0xFBD1, 0xFA99, 0xF962, 0xF82D, 0xF6FC, 0xF5D1, 0xF4AD, 0xF391, 0xF280, 0xF17B, 0xF083,
        0xEF9A, 0xEEC0, 0xEDF9, 0xED44, 0xECA3, 0xEC18, 0xEBA2, 0xEB44, 0xEAFE, 0xEAD1, 0xEABD, 0xEAC4, 0xEAE4, 0xEB20, 0xEB76, 0xEBE7,
        0xEC73, 0xED1A, 0xEDDA, 0xEEB5, 0xEFA8, 0xF0B4, 0xF1D6, 0xF310, 0xF45E, 0xF5C0, 0xF734, 0xF8BA, 0xFA4E, 0xFBF0, 0xFD9E, 0xFF56,
        0x0114, 0x02D9, 0x04A2, 0x066C, 0x0835, 0x09FB, 0x0BBC, 0x0D75, 0x0F25, 0x10C8, 0x125E, 0x13E2, 0x1554, 0x16B2, 0x17F8, 0x1926,
        0x1A3A, 0x1B31, 0x1C0B, 0x1CC5, 0x1D5F, 0x1DD7, 0x1E2C, 0x1E5D, 0x1E69, 0x1E50, 0x1E12, 0x1DAD, 0x1D23, 0x1C73, 0x1B9E, 0x1AA4,
        0x1985, 0x1844, 0x16E0, 0x155A, 0x13B6, 0x11F3, 0x1014, 0x0E1B, 0x0C0A, 0x09E2, 0x07A7, 0x055B, 0x0301, 0x009A, 0xFE2C, 0xFBB7,
        0xF93E, 0xF6C6, 0xF450, 0xF1E1, 0xEF7A, 0xED20, 0xEAD5, 0xE89D, 0xE679, 0xE46E, 0xE27E, 0xE0AB, 0xDEF9, 0xDD6A, 0xDC00, 0xDABE,
        0xD9A5, 0xD8B7, 0xD7F7, 0xD765, 0xD703, 0xD6D2, 0xD6D2, 0xD705, 0xD76B, 0xD803, 0xD8CF, 0xD9CC, 0xDAFC, 0xDC5C, 0xDDEC, 0xDFAA,
        0xE196, 0xE3AC, 0xE5EC, 0xE852, 0xEADC, 0xED88, 0xF052, 0xF338, 0xF637, 0xF94A, 0xFC6E, 0xFFA1, 0x02DC, 0x061E, 0x0963, 0x0CA5,
        0x0FE2, 0x1315, 0x163A, 0x194D, 0x1C4A, 0x1F2D, 0x21F2, 0x2497, 0x2716, 0x296C, 0x2B97, 0x2D92, 0x2F5C, 0x30F1, 0x324F, 0x3374,
        0x345C, 0x3508, 0x3575, 0x35A2, 0x358E, 0x3539, 0x34A2, 0x33C9, 0x32AF, 0x3154, 0x2FB9, 0x2DE0, 0x2BCA, 0x2979, 0x26EF, 0x242F,
        0x213B, 0x1E18, 0x1AC7, 0x174C, 0x13AC, 0x0FEB, 0x0C0C, 0x0814, 0x0408, 0xFFEE, 0xFBC8, 0xF79C, 0xF36F, 0xEF47, 0xEB29, 0xE719,
        0xE31D, 0xDF3A, 0xDB75, 0xD7D2, 0xD457, 0xD109, 0xCDEB, 0xCB02, 0xC852, 0xC5DF, 0xC3AC, 0xC1BE, 0xC016, 0xBEB8, 0xBDA6, 0xBCE1,
        0xBC6D, 0xBC49, 0xBC77, 0xBCF8, 0xBDCC, 0xBEF2, 0xC069, 0xC232, 0xC44A, 0xC6B0, 0xC961, 0xCC5B, 0xCF9B, 0xD31D, 0xD6DF, 0xDADB,
        0xDF0E, 0xE373, 0xE805, 0xECBF, 0xF19C, 0xF695, 0xFBA6, 0x00C7, 0x05F4, 0x0B26, 0x1056, 0x157F, 0x1A9A, 0x1FA0, 0x248B, 0x2955,
        0x2DF8, 0x326E, 0x36B1, 0x3ABC, 0x3E88, 0x4211, 0x4552, 0x4846, 0x4AEA, 0x4D38, 0x4F2E, 0x50C8, 0x5204, 0x52DE, 0x5357, 0x536B,
        0x531A, 0x5264, 0x5149, 0x4FC8, 0x4DE3, 0x4B9C, 0x48F3, 0x45ED, 0x428B, 0x3ED1, 0x3AC3, 0x3665, 0x31BC, 0x2CCC, 0x279B, 0x222F,
        0x1C6F, 0x168D, 0x1090, 0x0A80, 0x0462, 0xFE41, 0xF820, 0xF209, 0xEC03, 0xE615, 0xE046, 0xDA9D, 0xD521, 0xCFD8, 0xCAC9, 0xC5FA,
        0xC171, 0xBD32, 0xB944, 0xB5AB, 0xB26C, 0xAF89, 0xAD07, 0xAAE8, 0xA930, 0xA7E0, 0xA6FA, 0xA67E, 0xA66E, 0xA6CA, 0xA791, 0xA8C1,
        0xAA5B, 0xAC5B, 0xAEC0, 0xB187, 0xB4AB, 0xB82A, 0xBC00, 0xC027, 0xC49A, 0xC955, 0xCE52, 0xD38A, 0xD8F7, 0xDE94, 0xE458, 0xEA3E,
        0xF03E, 0xF651, 0xFC6F, 0x0291, 0x08B1, 0x0EC6, 0x14C9, 0x1AB4, 0x207E, 0x2622, 0x2B97, 0x30D9, 0x35DF, 0x3AA5, 0x3F25, 0x4359,
        0x473C, 0x4AC9, 0x4DFD, 0x50D3, 0x5348, 0x5559, 0x5703, 0x5845, 0x591D, 0x598A, 0x598C, 0x5922, 0x584D, 0x570E, 0x5566, 0x5358,
        0x50E6, 0x4E13, 0x4AE2, 0x4757, 0x4377, 0x3F45, 0x3AC8, 0x3604, 0x30FF, 0x2BBF, 0x264B, 0x20A9, 0x1ADF, 0x14F6, 0x0EF3, 0x08DE,
        0x02BF, 0xFC9D, 0xF67E, 0xF06B, 0xEA6A, 0xE484, 0xDEBE, 0xD921, 0xD3B2, 0xCE78, 0xC979, 0xC4BC, 0xC047, 0xBC1D, 0xB846, 0xB4C4,
        0xB19D, 0xAED4, 0xAC6C, 0xAA68, 0xA8CC, 0xA798, 0xA6CE, 0xA66F, 0xA67C, 0xA6F5, 0xA7D8, 0xA925, 0xAADA, 0xACF6, 0xAF75, 0xB255,
        0xB592, 0xB929, 0xBD14, 0xC150, 0xC5D7, 0xCAA4, 0xCFB1, 0xD4F9, 0xDA73, 0xE01B, 0xE5E9, 0xEBD7, 0xF1DC, 0xF7F3, 0xFE13, 0x0435,
        0x0A52, 0x1064, 0x1661, 0x1C44, 0x2204, 0x279C, 0x2D05, 0x3237, 0x372D, 0x3BE0, 0x404C, 0x446B, 0x4837, 0x4BAD, 0x4EC8, 0x5184,
        0x53DF, 0x55D5, 0x5763, 0x5889, 0x5945, 0x5995, 0x597A, 0x58F3, 0x5802, 0x56A7, 0x54E4, 0x52BB, 0x502E, 0x4D42, 0x49F8, 0x4656,
        0x425F, 0x3E19, 0x3988, 0x34B2, 0x2F9D, 0x2A4F, 0x24CE, 0x1F20, 0x194E, 0x135C, 0x0D54, 0x073C, 0x011B, 0xFAF9, 0xF4DD, 0xEECE,
        0xE8D4, 0xE2F5, 0xDD3A, 0xD7A8, 0xD246, 0xCD1C, 0xC82E, 0xC384, 0xBF22, 0xBB0E, 0xB74D, 0xB3E3, 0xB0D5, 0xAE25, 0xABD8, 0xA9F0,
        0xA86F, 0xA757, 0xA6AA, 0xA668, 0xA692, 0xA727, 0xA826, 0xA990, 0xAB60, 0xAD97, 0xB030, 0xB32A, 0xB67F, 0xBA2D, 0xBE2E, 0xC27F,
        0xC719, 0xCBF8, 0xD115, 0xD66B, 0xDBF2, 0xE1A5, 0xE77C, 0xED71, 0xF37C, 0xF996, 0xFFB7, 0x05D8, 0x0BF3, 0x1200, 0x17F7, 0x1DD1,
        0x2388, 0x2913, 0x2E6E, 0x3391, 0x3875, 0x3D16, 0x416E, 0x4577, 0x492D, 0x4C8B, 0x4F8D, 0x522F, 0x546F, 0x564A, 0x57BC, 0x58C6,
        0x5965, 0x5998, 0x5960, 0x58BD, 0x57AF, 0x5638, 0x545A, 0x5216, 0x4F6F, 0x4C6A, 0x4908, 0x454F, 0x4142, 0x3CE8, 0x3844, 0x335C,
        0x2E37, 0x28DB, 0x234D, 0x1D95, 0x17B9, 0x11C1, 0x0BB4, 0x0599, 0xFF78, 0xF956, 0xF33D, 0xED32, 0xE73F, 0xE169, 0xDBB8, 0xD632,
        0xD0DF, 0xCBC4, 0xC6E8, 0xC251, 0xBE03, 0xBA05, 0xB65B, 0xB309, 0xB013, 0xAD7E, 0xAB4C, 0xA97F, 0xA81A, 0xA71F, 0xA68E, 0xA669,
        0xA6AF, 0xA761, 0xA87D, 0xAA02, 0xABEE, 0xAE3F, 0xB0F3, 0xB405, 0xB772, 0xBB37, 0xBF4E, 0xC3B3, 0xC860, 0xCD50, 0xD27D, 0xD7E1,
        0xDD74, 0xE332, 0xE911, 0xEF0D, 0xF51C, 0xFB39, 0x015A, 0x077B, 0x0D93, 0x139B, 0x198B, 0x1F5C, 0x2508, 0x2A87, 0x2FD3, 0x34E6,
        0x39B9, 0x3E47, 0x428A, 0x467E, 0x4A1C, 0x4D62, 0x504B, 0x52D3, 0x54F8, 0x56B7, 0x580E, 0x58FB, 0x597D, 0x5994, 0x593F, 0x587F,
        0x5755, 0x55C2, 0x53C8, 0x516A, 0x4EAA, 0x4B8B, 0x4812, 0x4442, 0x4020, 0x3BB1, 0x36FA, 0x3202, 0x2CCD, 0x2763, 0x21C9, 0x1C07,
        0x1623, 0x1025, 0x0A13, 0x03F5, 0xFDD4, 0xF7B3, 0xF19D, 0xEB99, 0xE5AC, 0xDFE0, 0xDA39, 0xD4C1, 0xCF7C, 0xCA71, 0xC5A7, 0xC123,
        0xBCEA, 0xB902, 0xB56F, 0xB235, 0xAF59, 0xACDE, 0xAAC6, 0xA915, 0xA7CC, 0xA6EE, 0xA67A, 0xA671, 0xA6D4, 0xA7A2, 0xA8DB, 0xAA7B,
        0xAC83, 0xAEEF, 0xB1BC, 0xB4E7, 0xB86C, 0xBC47, 0xC074, 0xC4EC, 0xC9AC, 0xCEAD, 0xD3E9, 0xD95A, 0xDEF9, 0xE4C1, 0xEAA8, 0xF0AA,
        0xF6BE, 0xFCDD, 0x02FE, 0x091E, 0x0F32, 0x1534, 0x1B1C, 0x20E4, 0x2685, 0x2BF7, 0x3134, 0x3637, 0x3AF8, 0x3F72, 0x43A1, 0x477E,
        0x4B05, 0x4E32, 0x5102, 0x5370, 0x557A, 0x571D, 0x5858, 0x5928, 0x598E, 0x5988, 0x5916, 0x583A, 0x56F4, 0x5545, 0x5330, 0x50B7,
        0x4DDD, 0x4AA6, 0x4715, 0x432F, 0x3EF8, 0x3A75, 0x35AC, 0x30A3, 0x2B60, 0x25E8, 0x2043, 0x1A77, 0x148B, 0x0E87, 0x0871, 0x0251,
        0xFC30, 0xF612, 0xEFFF, 0xEA00, 0xE41C, 0xDE59, 0xD8BE, 0xD353, 0xCE1D, 0xC923, 0xC46B, 0xBFFA, 0xBBD6, 0xB804, 0xB489, 0xB168,
        0xAEA6, 0xAC45, 0xAA48, 0xA8B3, 0xA786, 0xA6C4, 0xA66D, 0xA681, 0xA701, 0xA7EB, 0xA940, 0xAAFC, 0xAD1F, 0xAFA5, 0xB28C, 0xB5CF,
        0xB96C, 0xBD5D, 0xC19E, 0xC62B, 0xCAFC, 0xD00E, 0xD559, 0xDAD7, 0xE081, 0xE652, 0xEC41, 0xF248, 0xF860, 0xFE81, 0x04A2, 0x0ABF,
        0x10CF, 0x16CB, 0x1CAB, 0x226A, 0x27FE, 0x2D63, 0x3291, 0x3783, 0x3C32, 0x4098, 0x44B1, 0x4878, 0x4BE8, 0x4EFC, 0x51B2, 0x5405,
        0x55F4, 0x577B, 0x589A, 0x594E, 0x5997, 0x5974, 0x58E6, 0x57ED, 0x568B, 0x54C0, 0x5290, 0x4FFD, 0x4D0A, 0x49BA, 0x4612, 0x4216,
        0x3DCA, 0x3934, 0x345A, 0x2F40, 0x29EE, 0x246A, 0x1EBA, 0x18E5, 0x12F2, 0x0CE8, 0x06CF, 0x00AD, 0xFA8C, 0xF471, 0xEE63, 0xE86A,
        0xE28E, 0xDCD5, 0xD746, 0xD1E8, 0xCCC2, 0xC7D9, 0xC333, 0xBED7, 0xBAC9, 0xB70D, 0xB3AA, 0xB0A2, 0xADF9, 0xABB3, 0xA9D2, 0xA858,
        0xA748, 0xA6A2, 0xA668, 0xA699, 0xA735, 0xA83C, 0xA9AD, 0xAB85, 0xADC2, 0xB062, 0xB362, 0xB6BE, 0xBA71, 0xBE79, 0xC2CF, 0xC76E,
        0xCC51, 0xD173, 0xD6CC, 0xDC56, 0xE20C, 0xE7E5, 0xEDDC, 0xF3E8, 0xFA03, 0x0024, 0x0645, 0x0C60, 0x126B, 0x1860, 0x1E38, 0x23EC,
        0x2974, 0x2ECB, 0x33EA, 0x38CA, 0x3D66, 0x41B9, 0x45BC, 0x496C, 0x4CC3, 0x4FBF, 0x525B, 0x5493, 0x5667, 0x57D2, 0x58D4, 0x596C,
        0x5998, 0x5959, 0x58AE, 0x5799, 0x561A, 0x5435, 0x51EA, 0x4F3D, 0x4C30, 0x48C9, 0x4509, 0x40F7, 0x3C97, 0x37EF, 0x3303, 0x2DD9,
        0x2879, 0x22E8, 0x1D2E, 0x1750, 0x1156, 0x0B48, 0x052C, 0xFF0A, 0xF8E9, 0xF2D0, 0xECC8, 0xE6D6, 0xE102, 0xDB54, 0xD5D2, 0xD082,
        0xCB6C, 0xC694, 0xC201, 0xBDB9, 0xB9C1, 0xB61D, 0xB2D1, 0xAFE2, 0xAD54, 0xAB28, 0xA963, 0xA805, 0xA711, 0xA688, 0xA66A, 0xA6B8,
        0xA771, 0xA894, 0xAA21, 0xAC14, 0xAE6C, 0xB126, 0xB43F, 0xB7B3, 0xBB7D, 0xBF9A, 0xC404, 0xC8B6, 0xCDAB, 0xD2DB, 0xD843, 0xDDD9,
        0xE399, 0xE97B, 0xEF78, 0xF589, 0xFBA6, 0x01C8, 0x07E8, 0x0DFF, 0x1405, 0x19F3, 0x1FC2, 0x256B, 0x2AE7, 0x302F, 0x353E, 0x3A0D,
        0x3E96, 0x42D3, 0x46C1, 0x4A59, 0x4D99, 0x507B, 0x52FC, 0x551A, 0x56D2, 0x5822, 0x5907, 0x5982, 0x5992, 0x5935, 0x586E, 0x573D,
        0x55A2, 0x53A1, 0x513C, 0x4E75, 0x4B50, 0x47D0, 0x43FB, 0x3FD3, 0x3B5F, 0x36A4, 0x31A7, 0x2C6F, 0x2701, 0x2164, 0x1B9F, 0x15B9,
        0x0FB9, 0x09A6, 0x0388, 0xFD66, 0xF747, 0xF132, 0xEB2E, 0xE544, 0xDF7A, 0xD9D6, 0xD461, 0xCF20, 0xCA1A, 0xC554, 0xC0D5, 0xBCA2,
        0xB8BF, 0xB532, 0xB1FF, 0xAF2A, 0xACB5, 0xAAA5, 0xA8FB, 0xA7B9, 0xA6E2, 0xA676, 0xA675, 0xA6DF, 0xA7B5, 0xA8F4, 0xAA9C, 0xACAB,
        0xAF1D, 0xB1F1, 0xB523, 0xB8AE, 0xBC8F, 0xC0C1, 0xC53F, 0xCA03, 0xCF08, 0xD448, 0xD9BD, 0xDF5F, 0xE529, 0xEB13, 0xF116, 0xF72A,
        0xFD4A, 0x036C, 0x098A, 0x0F9D, 0x159E, 0x1B84, 0x214A, 0x26E7, 0x2C56, 0x3190, 0x368E, 0x3B4A, 0x3FBF, 0x43E8, 0x47BF, 0x4B41,
        0x4E67, 0x5130, 0x5397, 0x559A, 0x5736, 0x586A, 0x5933, 0x5991, 0x5983, 0x590B, 0x5827, 0x56D9, 0x5523, 0x5307, 0x5087, 0x4DA7,
        0x4A69, 0x46D2, 0x42E6, 0x3EAA, 0x3A22, 0x3555, 0x3047, 0x2B00, 0x2585, 0x1FDD, 0x1A0E, 0x1421, 0x0E1B, 0x0804, 0x01E4, 0xFBC2,
        0xF5A5, 0xEF94, 0xE996, 0xE3B4, 0xDDF4, 0xD85C, 0xD2F4, 0xCDC2, 0xC8CC, 0xC419, 0xBFAE, 0xBB8F, 0xB7C3, 0xB44E, 0xB134, 0xAE78,
        0xAC1E, 0xAA29, 0xA89B, 0xA775, 0xA6BA, 0xA66B, 0xA687, 0xA70E, 0xA800, 0xA95B, 0xAB1F, 0xAD49, 0xAFD6, 0xB2C3, 0xB60D, 0xB9AF,
        0xBDA6, 0xC1ED, 0xC67E, 0xCB55, 0xD06A, 0xD5B9, 0xDB3A, 0xE0E8, 0xE6BB, 0xECAC, 0xF2B4, 0xF8CD, 0xFEEE, 0x050F, 0x0B2C, 0x113A,
        0x1735, 0x1D13, 0x22CE, 0x2860, 0x2DC1, 0x32EB, 0x37D8, 0x3C82, 0x40E4, 0x44F7, 0x48B8, 0x4C21, 0x4F2F, 0x51DE, 0x542B, 0x5612,
        0x5793, 0x58AA, 0x5956, 0x5998, 0x596E, 0x58D8, 0x57D8, 0x566E, 0x549D, 0x5266, 0x4FCC, 0x4CD2, 0x497C, 0x45CE, 0x41CC, 0x3D7B,
        0x38E0, 0x3401, 0x2EE3, 0x298E, 0x2406, 0x1E53, 0x187B, 0x1287, 0x0C7C, 0x0662, 0x0040, 0xFA1F, 0xF404, 0xEDF8, 0xE801, 0xE227,
        0xDC70, 0xD6E5, 0xD18B, 0xCC68, 0xC784, 0xC2E3, 0xBE8C, 0xBA83, 0xB6CE, 0xB371, 0xB06F, 0xADCD, 0xAB8E, 0xA9B4, 0xA842, 0xA739,
        0xA69B, 0xA668, 0xA6A0, 0xA744, 0xA852, 0xA9CA, 0xABA9, 0xADEE, 0xB095, 0xB39B, 0xB6FD, 0xBAB7, 0xBEC3, 0xC31F, 0xC7C3, 0xCCAB,
        0xD1D0, 0xD72D, 0xDCBB, 0xE273, 0xE84F, 0xEE47, 0xF454, 0xFA70, 0x0091, 0x06B3, 0x0CCC, 0x12D6, 0x18C9, 0x1E9F, 0x2450, 0x29D5,
        0x2F28, 0x3443, 0x391F, 0x3DB6, 0x4203, 0x4601, 0x49AA, 0x4CFC, 0x4FF0, 0x5285, 0x54B7, 0x5683, 0x57E8, 0x58E2, 0x5972, 0x5997,
        0x5950, 0x589E, 0x5781, 0x55FC, 0x540F, 0x51BD, 0x4F09, 0x4BF7, 0x4889, 0x44C3, 0x40AC, 0x3C47, 0x3799, 0x32A9, 0x2D7B, 0x2818,
        0x2284, 0x1CC6, 0x16E6, 0x10EB, 0x0ADB, 0x04BE, 0xFE9D, 0xF87C, 0xF264, 0xEC5D, 0xE66D, 0xE09C, 0xDAF0, 0xD571, 0xD026, 0xCB13,
        0xC640, 0xC1B3, 0xBD70, 0xB97D, 0xB5DF, 0xB29A, 0xAFB2, 0xAD2A, 0xAB05, 0xA947, 0xA7F1, 0xA704, 0xA682, 0xA66C, 0xA6C2, 0xA782,
        0xA8AD, 0xAA40, 0xAC3B, 0xAE9A, 0xB15A, 0xB47A, 0xB7F4, 0xBBC4, 0xBFE6, 0xC455, 0xC90C, 0xCE05, 0xD33A, 0xD8A5, 0xDE3F, 0xE401,
        0xE9E5, 0xEFE4, 0xF5F5, 0xFC13, 0x0235, 0x0855, 0x0E6B, 0x1470, 0x1A5C, 0x2029, 0x25CE, 0x2B47, 0x308C, 0x3596, 0x3A60, 0x3EE4,
        0x431C, 0x4704, 0x4A96, 0x4DCF, 0x50AB, 0x5325, 0x553C, 0x56ED, 0x5835, 0x5913, 0x5987, 0x598F, 0x592B, 0x585C, 0x5723, 0x5582,
        0x537A, 0x510E, 0x4E40, 0x4B15, 0x478F, 0x43B3, 0x3F86, 0x3B0D, 0x364D, 0x314C, 0x2C0F, 0x269E, 0x20FE, 0x1B37, 0x154F, 0x0F4E,
        0x093A, 0x031B, 0xFCF9, 0xF6DA, 0xF0C6, 0xEAC4, 0xE4DC, 0xDF14, 0xD974, 0xD402, 0xCEC4, 0xC9C2, 0xC502, 0xC088, 0xBC5A, 0xB87D,
        0xB4F6, 0xB1CA, 0xAEFB, 0xAC8D, 0xAA84, 0xA8E1, 0xA7A7, 0xA6D7, 0xA672, 0xA679, 0xA6EB, 0xA7C7, 0xA90E, 0xAABE, 0xACD3, 0xAF4D,
        0xB227, 0xB55F, 0xB8F0, 0xBCD7, 0xC10E, 0xC591, 0xCA5A, 0xCF64, 0xD4A8, 0xDA20, 0xDFC5, 0xE591, 0xEB7D, 0xF181, 0xF797, 0xFDB7,
        0x03D9, 0x09F7, 0x1009, 0x1608, 0x1BEC, 0x21AF, 0x274A, 0x2CB5, 0x31EA, 0x36E4, 0x3B9C, 0x400C, 0x442F, 0x4801, 0x4B7C, 0x4E9C,
        0x515E, 0x53BE, 0x55BA, 0x574F, 0x587B, 0x593D, 0x5993, 0x597E, 0x58FE, 0x5813, 0x56BE, 0x5501, 0x52DE, 0x5057, 0x4D70, 0x4A2C,
        0x468F, 0x429D, 0x3E5B, 0x39CF, 0x34FD, 0x2FEB, 0x2AA0, 0x2521, 0x1F77, 0x19A6, 0x13B6, 0x0DAF, 0x0797, 0x0177, 0xFB55, 0xF538,
        0xEF28, 0xE92D, 0xE34C, 0xDD8F, 0xD7FA, 0xD296, 0xCD68, 0xC876, 0xC3C8, 0xBF62, 0xBB49, 0xB783, 0xB414, 0xB100, 0xAE4B, 0xABF8,
        0xAA0A, 0xA883, 0xA765, 0xA6B1, 0xA669, 0xA68C, 0xA71B, 0xA815, 0xA978, 0xAB42, 0xAD73, 0xB007, 0xB2FA, 0xB64B, 0xB9F3, 0xBDF0,
        0xC23C, 0xC6D2, 0xCBAD, 0xD0C7, 0xD619, 0xDB9E, 0xE14E, 0xE724, 0xED17, 0xF321, 0xF93A, 0xFF5B, 0x057C, 0x0B98, 0x11A6, 0x179E,
        0x1D7A, 0x2333, 0x28C1, 0x2E1F, 0x3345, 0x382E, 0x3CD3, 0x412F, 0x453D, 0x48F8, 0x4C5B, 0x4F62, 0x520A, 0x5450, 0x5631, 0x57AA,
        0x58B9, 0x595E, 0x5998, 0x5967, 0x58CA, 0x57C2, 0x5651, 0x5479, 0x523B, 0x4F9A, 0x4C9A, 0x493D, 0x4589, 0x4181, 0x3D2B, 0x388B,
        0x33A8, 0x2E86, 0x292D, 0x23A2, 0x1DEC, 0x1812, 0x121C, 0x0C0F, 0x05F5, 0xFFD4, 0xF9B2, 0xF398, 0xED8D, 0xE797, 0xE1C0, 0xDC0C,
        0xD684, 0xD12D, 0xCC0F, 0xC72F, 0xC293, 0xBE42, 0xBA3F, 0xB68F, 0xB338, 0xB03D, 0xADA2, 0xAB6A, 0xA997, 0xA82C, 0xA72A, 0xA694,
        0xA668, 0xA6A8, 0xA753, 0xA869, 0xA9E8, 0xABCE, 0xAE1A, 0xB0C7, 0xB3D4, 0xB73D, 0xBAFC, 0xBF0F, 0xC36F, 0xC818, 0xCD04, 0xD22E,
        0xD78E, 0xDD20, 0xE2DA, 0xE8B8, 0xEEB2, 0xF4C1, 0xFADD, 0x00FE, 0x0720, 0x0D38, 0x1341, 0x1932, 0x1F06, 0x24B4, 0x2A36, 0x2F85,
        0x349B, 0x3973, 0x3E05, 0x424C, 0x4645, 0x49E8, 0x4D33, 0x5022, 0x52B0, 0x54DB, 0x56A0, 0x57FD, 0x58F0, 0x5978, 0x5996, 0x5947,
        0x588E, 0x576A, 0x55DD, 0x53E9, 0x5190, 0x4ED6, 0x4BBC, 0x4848, 0x447D, 0x4060, 0x3BF6, 0x3743, 0x324E, 0x2D1D, 0x27B6, 0x221F,
        0x1C5F, 0x167D, 0x107F, 0x0A6F, 0x0451, 0xFE30, 0xF80F, 0xF1F8, 0xEBF2, 0xE604, 0xE036, 0xDA8D, 0xD511, 0xCFC9, 0xCABB, 0xC5ED,
        0xC164, 0xBD27, 0xB93A, 0xB5A2, 0xB263, 0xAF81, 0xAD00, 0xAAE3, 0xA92C, 0xA7DD, 0xA6F8, 0xA67D, 0xA66F, 0xA6CB, 0xA793, 0xA8C5,
        0xAA60, 0xAC62, 0xAEC8, 0xB18F, 0xB4B5, 0xB835, 0xBC0B, 0xC033, 0xC4A7, 0xC963, 0xCE60, 0xD399, 0xD907, 0xDEA4, 0xE469, 0xEA4F,
        0xF04F, 0xF662, 0xFC81, 0x02A2, 0x08C2, 0x0ED7, 0x14DA, 0x1AC4, 0x208E, 0x2631, 0x2BA7, 0x30E7, 0x35ED, 0x3AB2, 0x3F31, 0x4364,
        0x4746, 0x4AD3, 0x4E05, 0x50DA, 0x534E, 0x555E, 0x5707, 0x5848, 0x591F, 0x598B, 0x598B, 0x5920, 0x584A, 0x570A, 0x5561, 0x5352,
        0x50DF, 0x4E0B, 0x4AD9, 0x474D, 0x436B, 0x3F39, 0x3ABB, 0x35F6, 0x30F0, 0x2BB0, 0x263B, 0x2099, 0x1ACF, 0x14E5, 0x0EE2, 0x08CD,
        0x02AD, 0xFC8C, 0xF66D, 0xF05A, 0xEA5A, 0xE473, 0xDEAE, 0xD911, 0xD3A2, 0xCE69, 0xC96C, 0xC4AF, 0xC03B, 0xBC12, 0xB83B, 0xB4BB,
        0xB194, 0xAECC, 0xAC66, 0xAA63, 0xA8C8, 0xA795, 0xA6CC, 0xA66F, 0xA67D, 0xA6F6, 0xA7DB, 0xA929, 0xAADF, 0xACFC, 0xAF7C, 0xB25D,
        0xB59C, 0xB933, 0xBD20, 0xC15C, 0xC5E4, 0xCAB2, 0xCFC0, 0xD508, 0xDA83, 0xE02B, 0xE5FA, 0xEBE8, 0xF1ED, 0xF804, 0xFE25, 0x0446,
        0x0A64, 0x1075, 0x1672, 0x1C54, 0x2214, 0x27AC, 0x2D14, 0x3245, 0x373A, 0x3BED, 0x4058, 0x4476, 0x4842, 0x4BB6, 0x4ED0, 0x518C,
        0x53E5, 0x55DA, 0x5767, 0x588C, 0x5946, 0x5995, 0x5979, 0x58F1, 0x57FF, 0x56A2, 0x54DE, 0x52B4, 0x5027, 0x4D39, 0x49EF, 0x464B,
        0x4254, 0x3E0D, 0x397B, 0x34A4, 0x2F8F, 0x2A40, 0x24BE, 0x1F10, 0x193D, 0x134C, 0x0D43, 0x072A, 0x0109, 0xFAE8, 0xF4CC, 0xEEBD,
        0xE8C3, 0xE2E5, 0xDD2A, 0xD798, 0xD237, 0xCD0E, 0xC821, 0xC377, 0xBF16, 0xBB03, 0xB743, 0xB3DA, 0xB0CD, 0xAE1E, 0xABD2, 0xA9EB,
        0xA86C, 0xA755, 0xA6A9, 0xA668, 0xA693, 0xA729, 0xA82A, 0xA994, 0xAB66, 0xAD9E, 0xB038, 0xB332, 0xB689, 0xBA38, 0xBE3A, 0xC28B,
        0xC727, 0xCC06, 0xD124, 0xD67A, 0xDC02, 0xE1B5, 0xE78D, 0xED82, 0xF38D, 0xF9A7, 0xFFC9, 0x05EA, 0x0C04, 0x1211, 0x1808, 0x1DE1,
        0x2397, 0x2923, 0x2E7D, 0x339F, 0x3883, 0x3D23, 0x417A, 0x4582, 0x4937, 0x4C94, 0x4F95, 0x5236, 0x5475, 0x564E, 0x57C0, 0x58C8,
        0x5966, 0x5998, 0x595F, 0x58BB, 0x57AC, 0x5634, 0x5454, 0x520F, 0x4F67, 0x4C61, 0x48FE, 0x4544, 0x4137, 0x3CDB, 0x3836, 0x334E,
        0x2E28, 0x28CB, 0x233D, 0x1D85, 0x17A9, 0x11B0, 0x0BA3, 0x0587, 0xFF66, 0xF945, 0xF32C, 0xED22, 0xE72E, 0xE159, 0xDBA8, 0xD623,
        0xD0D0, 0xCBB6, 0xC6DB, 0xC244, 0xBDF7, 0xB9FA, 0xB651, 0xB300, 0xB00C, 0xAD77, 0xAB46, 0xA97A, 0xA817, 0xA71D, 0xA68D, 0xA669,
        0xA6B1, 0xA763, 0xA880, 0xAA07, 0xABF4, 0xAE46, 0xB0FB, 0xB40E, 0xB77D, 0xBB42, 0xBF5A, 0xC3C0, 0xC86E, 0xCD5F, 0xD28C, 0xD7F0,
        0xDD84, 0xE342, 0xE922, 0xEF1E, 0xF52D, 0xFB4A, 0x016C, 0x078D, 0x0DA4, 0x13AC, 0x199B, 0x1F6C, 0x2517, 0x2A96, 0x2FE2, 0x34F4,
        0x39C6, 0x3E54, 0x4296, 0x4688, 0x4A26, 0x4D6B, 0x5052, 0x52DA, 0x54FD, 0x56BB, 0x5811, 0x58FD, 0x597E, 0x5994, 0x593E, 0x587D,
        0x5751, 0x55BD, 0x53C2, 0x5163, 0x4EA1, 0x4B82, 0x4807, 0x4436, 0x4014, 0x3BA4, 0x36ED, 0x31F4, 0x2CBE, 0x2754, 0x21B9, 0x1BF7,
        0x1613, 0x1014, 0x0A02, 0x03E4, 0xFDC2, 0xF7A2, 0xF18C, 0xEB88, 0xE59C, 0xDFCF, 0xDA2A, 0xD4B1, 0xCF6D, 0xCA63, 0xC59A, 0xC116,
        0xBCDE, 0xB8F7, 0xB565, 0xB22D, 0xAF51, 0xACD7, 0xAAC1, 0xA911, 0xA7C9, 0xA6EC, 0xA679, 0xA672, 0xA6D6, 0xA7A5, 0xA8DF, 0xAA81,
        0xAC89, 0xAEF6, 0xB1C4, 0xB4F0, 0xB876, 0xBC52, 0xC080, 0xC4F9, 0xC9BA, 0xCEBB, 0xD3F8, 0xD96A, 0xDF0A, 0xE4D1, 0xEAB9, 0xF0BB,
        0xF6CF, 0xFCEE, 0x0310, 0x092F, 0x0F43, 0x1545, 0x1B2D, 0x20F4, 0x2694, 0x2C06, 0x3143, 0x3644, 0x3B05, 0x3F7F, 0x43AC, 0x4788,
        0x4B0F, 0x4E3B, 0x5109, 0x5376, 0x557F, 0x5721, 0x585A, 0x592A, 0x598E, 0x5987, 0x5915, 0x5837, 0x56F0, 0x5540, 0x532A, 0x50B0,
        0x4DD5, 0x4A9C, 0x470A, 0x4323, 0x3EEB, 0x3A68, 0x359F, 0x3095, 0x2B51, 0x25D8, 0x2033, 0x1A67, 0x147B, 0x0E76, 0x0860, 0x0240,
        0xFC1E, 0xF600, 0xEFEE, 0xE9F0, 0xE40B, 0xDE49, 0xD8AF, 0xD344, 0xCE0E, 0xC915, 0xC45E, 0xBFEE, 0xBBCB, 0xB7FA, 0xB480, 0xB160,
        0xAE9E, 0xAC3F, 0xAA43, 0xA8AF, 0xA784, 0xA6C2, 0xA66C, 0xA682, 0xA703, 0xA7EF, 0xA944, 0xAB02, 0xAD25, 0xAFAD, 0xB294, 0xB5D9,
        0xB976, 0xBD69, 0xC1AB, 0xC638, 0xCB0A, 0xD01C, 0xD568, 0xDAE6, 0xE092, 0xE662, 0xEC52, 0xF259, 0xF871, 0xFE92, 0x04B3, 0x0AD0,
        0x10E0, 0x16DC, 0x1CBC, 0x2279, 0x280E, 0x2D72, 0x32A0, 0x3790, 0x3C3E, 0x40A4, 0x44BC, 0x4882, 0x4BF1, 0x4F04, 0x51B9, 0x540B,
        0x55F9, 0x577F, 0x589C, 0x594F, 0x5997, 0x5973, 0x58E4, 0x57EA, 0x5686, 0x54BB, 0x528A, 0x4FF5, 0x4D01, 0x49B1, 0x4607, 0x420A,
        0x3DBE, 0x3927, 0x344C, 0x2F32, 0x29DF, 0x245A, 0x1EA9, 0x18D4, 0x12E1, 0x0CD7, 0x06BD, 0x009C, 0xFA7B, 0xF45F, 0xEE52, 0xE859,
        0xE27E, 0xDCC5, 0xD737, 0xD1DA, 0xCCB4, 0xC7CB, 0xC327, 0xBECB, 0xBABE, 0xB703, 0xB3A1, 0xB09A, 0xADF2, 0xABAD, 0xA9CD, 0xA855,
        0xA746, 0xA6A1, 0xA668, 0xA69A, 0xA738, 0xA840, 0xA9B1, 0xAB8A, 0xADC9, 0xB06A, 0xB36B, 0xB6C8, 0xBA7C, 0xBE85, 0xC2DB, 0xC77B,
        0xCC5F, 0xD181, 0xD6DB, 0xDC66, 0xE21C, 0xE7F6, 0xEDED, 0xF3F9, 0xFA14, 0x0035, 0x0657, 0x0C71, 0x127C, 0x1871, 0x1E48, 0x23FC,
        0x2984, 0x2EDA, 0x33F8, 0x38D7, 0x3D73, 0x41C4, 0x45C7, 0x4976, 0x4CCC, 0x4FC7, 0x5261, 0x5499, 0x566B, 0x57D6, 0x58D7, 0x596D,
        0x5998, 0x5957, 0x58AB, 0x5795, 0x5615, 0x542F, 0x51E3, 0x4F34, 0x4C27, 0x48BE, 0x44FE, 0x40EB, 0x3C8B, 0x37E1, 0x32F4, 0x2DCB,
        0x286A, 0x22D9, 0x1D1D, 0x173F, 0x1145, 0x0B37, 0x051A, 0xFEF9, 0xF8D8, 0xF2BF, 0xECB7, 0xE6C5, 0xE0F2, 0xDB44, 0xD5C3, 0xD073,
        0xCB5E, 0xC687, 0xC1F5, 0xBDAE, 0xB9B6, 0xB613, 0xB2C8, 0xAFDA, 0xAD4D, 0xAB23, 0xA95E, 0xA802, 0xA70F, 0xA687, 0xA66B, 0xA6BA,
        0xA774, 0xA898, 0xAA26, 0xAC1A, 0xAE73, 0xB12F, 0xB448, 0xB7BD, 0xBB88, 0xBFA6, 0xC411, 0xC8C4, 0xCDB9, 0xD2EA, 0xD852, 0xDDE9,
        0xE3AA, 0xE98C, 0xEF89, 0xF59A, 0xFBB7, 0x01D9, 0x07F9, 0x0E10, 0x1416, 0x1A04, 0x1FD3, 0x257B, 0x2AF6, 0x303E, 0x354C, 0x3A1A,
        0x3EA2, 0x42DF, 0x46CB, 0x4A63, 0x4DA1, 0x5083, 0x5303, 0x5520, 0x56D6, 0x5825, 0x5909, 0x5983, 0x5991, 0x5934, 0x586B, 0x5739,
        0x559D, 0x539B, 0x5135, 0x4E6D, 0x4B47, 0x47C6, 0x43EF, 0x3FC7, 0x3B52, 0x3696, 0x3199, 0x2C60, 0x26F1, 0x2154, 0x1B8F, 0x15A9,
        0x0FA8, 0x0995, 0x0377, 0xFD55, 0xF735, 0xF120, 0xEB1D, 0xE533, 0xDF69, 0xD9C7, 0xD452, 0xCF11, 0xCA0C, 0xC547, 0xC0C9, 0xBC96,
        0xB8B5, 0xB529, 0xB1F7, 0xAF22, 0xACAF, 0xAAA0, 0xA8F7, 0xA7B7, 0xA6E0, 0xA675, 0xA675, 0xA6E1, 0xA7B8, 0xA8F8, 0xAAA1, 0xACB1,
        0xAF25, 0xB1FA, 0xB52C, 0xB8B8, 0xBC9A, 0xC0CD, 0xC54C, 0xCA11, 0xCF17, 0xD457, 0xD9CC, 0xDF6F, 0xE539, 0xEB23, 0xF127, 0xF73C,
        0xFD5B, 0x037D, 0x099C, 0x0FAF, 0x15AF, 0x1B95, 0x215A, 0x26F7, 0x2C65, 0x319E, 0x369B, 0x3B57, 0x3FCC, 0x43F3, 0x47CA, 0x4B4A,
        0x4E70, 0x5137, 0x539D, 0x559F, 0x573A, 0x586C, 0x5934, 0x5991, 0x5983, 0x5909, 0x5824, 0x56D5, 0x551E, 0x5301, 0x5080, 0x4D9E,
        0x4A60, 0x46C8, 0x42DB, 0x3E9D, 0x3A15, 0x3547, 0x3039, 0x2AF1, 0x2575, 0x1FCD, 0x19FE, 0x1410, 0x0E0A, 0x07F3, 0x01D3, 0xFBB1,
        0xF594, 0xEF83, 0xE986, 0xE3A4, 0xDDE4, 0xD84C, 0xD2E5, 0xCDB4, 0xC8BF, 0xC40C, 0xBFA2, 0xBB84, 0xB7B9, 0xB445, 0xB12C, 0xAE71,
        0xAC18, 0xAA24, 0xA897, 0xA773, 0xA6B9, 0xA66A, 0xA687, 0xA710, 0xA803, 0xA960, 0xAB25, 0xAD4F, 0xAFDD, 0xB2CB, 0xB616, 0xB9BA,
        0xBDB2, 0xC1FA, 0xC68C, 0xCB63, 0xD079, 0xD5C8, 0xDB4A, 0xE0F8, 0xE6CB, 0xECBD, 0xF2C6, 0xF8DE, 0xFEFF, 0x0521, 0x0B3D, 0x114B,
        0x1745, 0x1D23, 0x22DE, 0x286F, 0x2DD0, 0x32FA, 0x37E6, 0x3C8F, 0x40F0, 0x4502, 0x48C2, 0x4C2A, 0x4F37, 0x51E5, 0x5431, 0x5617,
        0x5796, 0x58AC, 0x5958, 0x5998, 0x596D, 0x58D6, 0x57D4, 0x566A, 0x5497, 0x525F, 0x4FC4, 0x4CC9, 0x4972, 0x45C3, 0x41C0, 0x3D6E,
        0x38D3, 0x33F3, 0x2ED5, 0x297E, 0x23F6, 0x1E43, 0x186B, 0x1276, 0x0C6B, 0x0650, 0x002F, 0xFA0E, 0xF3F3, 0xEDE7, 0xE7F0, 0xE216,
        0xDC61, 0xD6D6, 0xD17C, 0xCC5A, 0xC776, 0xC2D7, 0xBE80, 0xBA78, 0xB6C4, 0xB368, 0xB067, 0xADC6, 0xAB88, 0xA9B0, 0xA83E, 0xA737,
        0xA699, 0xA668, 0xA6A1, 0xA746, 0xA856, 0xA9CF, 0xABAF, 0xADF5, 0xB09D, 0xB3A4, 0xB707, 0xBAC2, 0xBECF, 0xC32B, 0xC7D0, 0xCCB9,
        0xD1DF, 0xD73C, 0xDCCB, 0xE283, 0xE860, 0xEE58, 0xF466, 0xFA81, 0x00A2, 0x06C4, 0x0CDD, 0x12E7, 0x18DA, 0x1EAF, 0x2460, 0x29E5,
        0x2F37, 0x3451, 0x392C, 0x3DC2, 0x420E, 0x460B, 0x49B4, 0x4D04, 0x4FF8, 0x528C, 0x54BD, 0x5688, 0x57EB, 0x58E5, 0x5973, 0x5997,
        0x594F, 0x589B, 0x577E, 0x55F7, 0x5409, 0x51B6, 0x4F01, 0x4BED, 0x487E, 0x44B8, 0x40A0, 0x3C3A, 0x378B, 0x329A, 0x2D6C, 0x2808,
        0x2274, 0x1CB6, 0x16D6, 0x10DA, 0x0ACA, 0x04AD, 0xFE8C, 0xF86B, 0xF253, 0xEC4C, 0xE65C, 0xE08C, 0xDAE1, 0xD562, 0xD017, 0xCB05,
        0xC633, 0xC1A6, 0xBD64, 0xB972, 0xB5D5, 0xB291, 0xAFAA, 0xAD23, 0xAB00, 0xA943, 0xA7EE, 0xA702, 0xA682, 0xA66D, 0xA6C3, 0xA785,
        0xA8B1, 0xAA45, 0xAC41, 0xAEA1, 0xB163, 0xB483, 0xB7FE, 0xBBCF, 0xBFF2, 0xC462, 0xC91A, 0xCE14, 0xD349, 0xD8B4, 0xDE4F, 0xE411,
        0xE9F6, 0xEFF5, 0xF607, 0xFC25, 0x0246, 0x0866, 0x0E7C, 0x1481, 0x1A6D, 0x2039, 0x25DE, 0x2B56, 0x309A, 0x35A4, 0x3A6D, 0x3EF0,
        0x4327, 0x470E, 0x4AA0, 0x4DD8, 0x50B2, 0x532C, 0x5542, 0x56F1, 0x5838, 0x5915, 0x5987, 0x598E, 0x5929, 0x5859, 0x571F, 0x557D,
        0x5374, 0x5106, 0x4E38, 0x4B0B, 0x4784, 0x43A8, 0x3F7A, 0x3B00, 0x363F, 0x313D, 0x2C00, 0x268F, 0x20EE, 0x1B27, 0x153E, 0x0F3D,
        0x0928, 0x0309, 0xFCE8, 0xF6C9, 0xF0B5, 0xEAB3, 0xE4CB, 0xDF04, 0xD964, 0xD3F3, 0xCEB6, 0xC9B5, 0xC4F5, 0xC07B, 0xBC4E, 0xB873,
        0xB4ED, 0xB1C1, 0xAEF3, 0xAC87, 0xAA7F, 0xA8DD, 0xA7A4, 0xA6D5, 0xA671, 0xA679, 0xA6EC, 0xA7CA, 0xA913, 0xAAC3, 0xACDA, 0xAF54,
        0xB230, 0xB568, 0xB8FB, 0xBCE3, 0xC11B, 0xC59F, 0xCA68, 0xCF73, 0xD4B7, 0xDA2F, 0xDFD5, 0xE5A2, 0xEB8E, 0xF193, 0xF7A9, 0xFDC9,
        0x03EA, 0x0A08, 0x101A, 0x1619, 0x1BFD, 0x21BF, 0x2759, 0x2CC4, 0x31F9, 0x36F2, 0x3BA9, 0x4018, 0x443B, 0x480B, 0x4B85, 0x4EA4,
        0x5165, 0x53C5, 0x55BF, 0x5753, 0x587E, 0x593E, 0x5994, 0x597E, 0x58FC, 0x5810, 0x56BA, 0x54FB, 0x52D7, 0x5050, 0x4D67, 0x4A22,
        0x4684, 0x4292, 0x3E4F, 0x39C2, 0x34EF, 0x2FDC, 0x2A91, 0x2512, 0x1F66, 0x1995, 0x13A5, 0x0D9E, 0x0786, 0x0165, 0xFB44, 0xF527,
        0xEF17, 0xE91C, 0xE33C, 0xDD7F, 0xD7EB, 0xD287, 0xCD59, 0xC869, 0xC3BB, 0xBF56, 0xBB3E, 0xB779, 0xB40B, 0xB0F8, 0xAE44, 0xABF2,
        0xAA05, 0xA87F, 0xA762, 0xA6B0, 0xA669, 0xA68D, 0xA71D, 0xA818, 0xA97C, 0xAB48, 0xAD7A, 0xB00E, 0xB303, 0xB654, 0xB9FE, 0xBDFC,
        0xC249, 0xC6E0, 0xCBBB, 0xD0D6, 0xD629, 0xDBAE, 0xE15F, 0xE734, 0xED28, 0xF332, 0xF94B, 0xFF6D, 0x058E, 0x0BA9, 0x11B7, 0x17AF,
        0x1D8B, 0x2343, 0x28D1, 0x2E2E, 0x3353, 0x383B, 0x3CE0, 0x413B, 0x4548, 0x4902, 0x4C64, 0x4F6A, 0x5211, 0x5456, 0x5635, 0x57AD,
        0x58BC, 0x5960, 0x5998, 0x5966, 0x58C7, 0x57BF, 0x564C, 0x5473, 0x5234, 0x4F92, 0x4C91, 0x4933, 0x457E, 0x4176, 0x3D1E, 0x387E,
        0x339A, 0x2E77, 0x291D, 0x2392, 0x1DDC, 0x1802, 0x120B, 0x0BFE, 0x05E3, 0xFFC2, 0xF9A1, 0xF387, 0xED7C, 0xE787, 0xE1AF, 0xDBFC,
        0xD675, 0xD11F, 0xCC01, 0xC722, 0xC287, 0xBE36, 0xBA34, 0xB685, 0xB32F, 0xB035, 0xAD9B, 0xAB64, 0xA992, 0xA829, 0xA728, 0xA693,
        0xA668, 0xA6A9, 0xA756, 0xA86D, 0xA9ED, 0xABD4, 0xAE21, 0xB0D0, 0xB3DD, 0xB747, 0xBB07, 0xBF1B, 0xC37C, 0xC826, 0xCD13, 0xD23D,
        0xD79E, 0xDD2F, 0xE2EB, 0xE8C9, 0xEEC3, 0xF4D2, 0xFAEE, 0x0110, 0x0731, 0x0D49, 0x1352, 0x1943, 0x1F16, 0x24C4, 0x2A45, 0x2F94,
        0x34A9, 0x3980, 0x3E11, 0x4258, 0x464F, 0x49F2, 0x4D3C, 0x5029, 0x52B6, 0x54E0, 0x56A4, 0x5800, 0x58F2, 0x5979, 0x5995, 0x5946,
        0x588B, 0x5766, 0x55D8, 0x53E3, 0x5189, 0x4ECD, 0x4BB3, 0x483E, 0x4472, 0x4054, 0x3BE9, 0x3735, 0x3240, 0x2D0E, 0x27A6, 0x220F,
        0x1C4E, 0x166C, 0x106E, 0x0A5D, 0x0440, 0xFE1E, 0xF7FE, 0xF1E7, 0xEBE1, 0xE5F4, 0xE025, 0xDA7D, 0xD502, 0xCFBB, 0xCAAD, 0xC5E0,
        0xC158, 0xBD1B, 0xB92F, 0xB598, 0xB25A, 0xAF7A, 0xACFA, 0xAADD, 0xA927, 0xA7DA, 0xA6F6, 0xA67D, 0xA66F, 0xA6CD, 0xA796, 0xA8C9,
        0xAA65, 0xAC68, 0xAECF, 0xB197, 0xB4BE, 0xB83F, 0xBC16, 0xC03F, 0xC4B4, 0xC971, 0xCE6F, 0xD3A8, 0xD917, 0xDEB4, 0xE479, 0xEA60,
        0xF060, 0xF673, 0xFC92, 0x02B4, 0x08D3, 0x0EE8, 0x14EB, 0x1AD5, 0x209F, 0x2641, 0x2BB6, 0x30F6, 0x35FB, 0x3AC0, 0x3F3E, 0x4370,
        0x4751, 0x4ADC, 0x4E0E, 0x50E2, 0x5354, 0x5563, 0x570B, 0x584B, 0x5921, 0x598B, 0x598B, 0x591E, 0x5847, 0x5706, 0x555C, 0x534C,
        0x50D7, 0x4E02, 0x4ACF, 0x4742, 0x4360, 0x3F2D, 0x3AAE, 0x35E8, 0x30E2, 0x2BA1, 0x262C, 0x2089, 0x1ABE, 0x14D4, 0x0ED1, 0x08BC,
        0x029C, 0xFC7A, 0xF65C, 0xF049, 0xEA49, 0xE463, 0xDE9E, 0xD901, 0xD393, 0xCE5B, 0xC95E, 0xC4A2, 0xC02E, 0xBC07, 0xB831, 0xB4B1,
        0xB18C, 0xAEC5, 0xAC5F, 0xAA5E, 0xA8C4, 0xA792, 0xA6CB, 0xA66F, 0xA67E, 0xA6F8, 0xA7DE, 0xA92D, 0xAAE5, 0xAD03, 0xAF84, 0xB266,
        0xB5A5, 0xB93E, 0xBD2B, 0xC169, 0xC5F2, 0xCAC0, 0xCFCF, 0xD517, 0xDA93, 0xE03B, 0xE60A, 0xEBF8, 0xF1FF, 0xF815, 0xFE36, 0x0457,
        0x0A75, 0x1086, 0x1683, 0x1C65, 0x2224, 0x27BB, 0x2D22, 0x3253, 0x3748, 0x3BFA, 0x4064, 0x4481, 0x484C, 0x4BC0, 0x4ED9, 0x5193,
        0x53EB, 0x55DF, 0x576B, 0x588F, 0x5948, 0x5996, 0x5978, 0x58EF, 0x57FB, 0x569E, 0x54D9, 0x52AD, 0x501F, 0x4D30, 0x49E5, 0x4641,
        0x4248, 0x3E00, 0x396E, 0x3496, 0x2F80, 0x2A30, 0x24AE, 0x1F00, 0x192C, 0x133B, 0x0D32, 0x0719, 0x00F8, 0xFAD7, 0xF4BB, 0xEEAC,
        0xE8B2, 0xE2D5, 0xDD1A, 0xD789, 0xD229, 0xCCFF, 0xC813, 0xC36A, 0xBF0A, 0xBAF8, 0xB739, 0xB3D1, 0xB0C5, 0xAE17, 0xABCC, 0xA9E6,
        0xA868, 0xA753, 0xA6A8, 0xA668, 0xA694, 0xA72B, 0xA82D, 0xA999, 0xAB6C, 0xADA5, 0xB040, 0xB33B, 0xB693, 0xBA42, 0xBE46, 0xC298,
        0xC734, 0xCC14, 0xD133, 0xD689, 0xDC12, 0xE1C6, 0xE79E, 0xED93, 0xF39E, 0xF9B8, 0xFFDA, 0x05FB, 0x0C16, 0x1222, 0x1818, 0x1DF2,
        0x23A7, 0x2932, 0x2E8B, 0x33AD, 0x3890, 0x3D30, 0x4186, 0x458D, 0x4941, 0x4C9D, 0x4F9D, 0x523D, 0x547B, 0x5653, 0x57C3, 0x58CB,
        0x5967, 0x5998, 0x595E, 0x58B8, 0x57A8, 0x562F, 0x544E, 0x5208, 0x4F5F, 0x4C58, 0x48F4, 0x4539, 0x412B, 0x3CCE, 0x3829, 0x3340,
        0x2E1A, 0x28BC, 0x232D, 0x1D74, 0x1798, 0x11A0, 0x0B92, 0x0576, 0xFF55, 0xF934, 0xF31A, 0xED11, 0xE71E, 0xE149, 0xDB98, 0xD614,
        0xD0C2, 0xCBA8, 0xC6CD, 0xC238, 0xBDEC, 0xB9EF, 0xB647, 0xB2F7, 0xB004, 0xAD71, 0xAB40, 0xA976, 0xA813, 0xA71A, 0xA68C, 0xA669,
        0xA6B2, 0xA766, 0xA884, 0xAA0C, 0xABFA, 0xAE4D, 0xB103, 0xB417, 0xB787, 0xBB4D, 0xBF66, 0xC3CD, 0xC87B, 0xCD6D, 0xD29B, 0xD800,
        0xDD94, 0xE352, 0xE933, 0xEF2F, 0xF53F, 0xFB5C, 0x017D, 0x079E, 0x0DB5, 0x13BC, 0x19AC, 0x1F7C, 0x2527, 0x2AA5, 0x2FF0, 0x3502,
        0x39D4, 0x3E60, 0x42A1, 0x4693, 0x4A30, 0x4D73, 0x505A, 0x52E0, 0x5503, 0x56C0, 0x5814, 0x58FF, 0x597F, 0x5993, 0x593C, 0x587A,
        0x574E, 0x55B8, 0x53BC, 0x515B, 0x4E99, 0x4B78, 0x47FD, 0x442B, 0x4008, 0x3B97, 0x36DF, 0x31E5, 0x2CAF, 0x2744, 0x21A9, 0x1BE6,
        0x1602, 0x1003, 0x09F1, 0x03D3, 0xFDB1, 0xF791, 0xF17B, 0xEB77, 0xE58B, 0xDFBF, 0xDA1A, 0xD4A2, 0xCF5F, 0xCA55, 0xC58D, 0xC10A,
        0xBCD3, 0xB8EC, 0xB55B, 0xB224, 0xAF4A, 0xACD1, 0xAABC, 0xA90D, 0xA7C6, 0xA6EA, 0xA678, 0xA672, 0xA6D8, 0xA7A8, 0xA8E3, 0xAA86,
        0xAC8F, 0xAEFD, 0xB1CD, 0xB4FA, 0xB881, 0xBC5E, 0xC08C, 0xC506, 0xC9C7, 0xCECA, 0xD407, 0xD979, 0xDF1A, 0xE4E2, 0xEACA, 0xF0CC,
        0xF6E0, 0xFCFF, 0x0321, 0x0940, 0x0F54, 0x1555, 0x1B3D, 0x2104, 0x26A4, 0x2C15, 0x3151, 0x3652, 0x3B12, 0x3F8B, 0x43B7, 0x4793,
        0x4B18, 0x4E43, 0x5110, 0x537C, 0x5584, 0x5725, 0x585D, 0x592C, 0x598F, 0x5986, 0x5913, 0x5834, 0x56EB, 0x553A, 0x5323, 0x50A8,
        0x4DCC, 0x4A93, 0x4700, 0x4318, 0x3EDF, 0x3A5B, 0x3591, 0x3086, 0x2B41, 0x25C9, 0x2023, 0x1A56, 0x146A, 0x0E65, 0x084F, 0x022F,
        0xFC0D, 0xF5EF, 0xEFDD, 0xE9DF, 0xE3FB, 0xDE39, 0xD89F, 0xD335, 0xCE00, 0xC907, 0xC451, 0xBFE2, 0xBBC0, 0xB7F0, 0xB476, 0xB157,
        0xAE97, 0xAC38, 0xAA3E, 0xA8AB, 0xA781, 0xA6C1, 0xA66C, 0xA683, 0xA705, 0xA7F2, 0xA949, 0xAB07, 0xAD2C, 0xAFB4, 0xB29D, 0xB5E2,
        0xB981, 0xBD74, 0xC1B7, 0xC645, 0xCB18, 0xD02B, 0xD577, 0xDAF6, 0xE0A2, 0xE673, 0xEC63, 0xF26B, 0xF882, 0xFEA3, 0x04C5, 0x0AE1,
        0x10F1, 0x16EC, 0x1CCC, 0x2289, 0x281D, 0x2D81, 0x32AE, 0x379E, 0x3C4B, 0x40B0, 0x44C8, 0x488C, 0x4BFA, 0x4F0C, 0x51C0, 0x5411,
        0x55FE, 0x5783, 0x589F, 0x5951, 0x5997, 0x5972, 0x58E2, 0x57E6, 0x5682, 0x54B5, 0x5283, 0x4FEE, 0x4CF8, 0x49A7, 0x45FD, 0x41FE,
        0x3DB1, 0x391A, 0x343E, 0x2F23, 0x29D0, 0x244A, 0x1E99, 0x18C3, 0x12D0, 0x0CC6, 0x06AC, 0x008B, 0xFA6A, 0xF44E, 0xEE41, 0xE849,
        0xE26D, 0xDCB5, 0xD727, 0xD1CB, 0xCCA6, 0xC7BE, 0xC31A, 0xBEBF, 0xBAB3, 0xB6F9, 0xB398, 0xB092, 0xADEB, 0xABA7, 0xA9C8, 0xA851,
        0xA743, 0xA6A0, 0xA668, 0xA69B, 0xA73A, 0xA843, 0xA9B6, 0xAB90, 0xADD0, 0xB072, 0xB374, 0xB6D2, 0xBA87, 0xBE90, 0xC2E8, 0xC789,
        0xCC6E, 0xD190, 0xD6EB, 0xDC76, 0xE22D, 0xE807, 0xEDFE, 0xF40A, 0xFA25, 0x0046, 0x0668, 0x0C82, 0x128D, 0x1882, 0x1E59, 0x240C,
        0x2993, 0x2EE9, 0x3406, 0x38E5, 0x3D7F, 0x41D0, 0x45D2, 0x4980, 0x4CD5, 0x4FCF, 0x5268, 0x549F, 0x5670, 0x57D9, 0x58D9, 0x596E,
        0x5998, 0x5956, 0x58A9, 0x5791, 0x5611, 0x5429, 0x51DC, 0x4F2C, 0x4C1E, 0x48B4, 0x44F3, 0x40E0, 0x3C7E, 0x37D4, 0x32E6, 0x2DBC,
        0x285A, 0x22C9, 0x1D0D, 0x172F, 0x1134, 0x0B25, 0x0509, 0xFEE8, 0xF8C7, 0xF2AE, 0xECA6, 0xE6B5, 0xE0E2, 0xDB35, 0xD5B3, 0xD065,
        0xCB50, 0xC679, 0xC1E9, 0xBDA2, 0xB9AB, 0xB609, 0xB2C0, 0xAFD3, 0xAD46, 0xAB1D, 0xA95A, 0xA7FF, 0xA70D, 0xA686, 0xA66B, 0xA6BB,
        0xA776, 0xA89C, 0xAA2B, 0xAC20, 0xAE7B, 0xB137, 0xB452, 0xB7C7, 0xBB94, 0xBFB2, 0xC41E, 0xC8D1, 0xCDC7, 0xD2F9, 0xD862, 0xDDF9,
        0xE3BA, 0xE99D, 0xEF9A, 0xF5AB, 0xFBC9, 0x01EA, 0x080B, 0x0E21, 0x1427, 0x1A15, 0x1FE3, 0x258B, 0x2B05, 0x304D, 0x355A, 0x3A27,
        0x3EAE, 0x42EA, 0x46D6, 0x4A6D, 0x4DAA, 0x508A, 0x5309, 0x5525, 0x56DB, 0x5828, 0x590B, 0x5984, 0x5991, 0x5932, 0x5868, 0x5735,
        0x5598, 0x5395, 0x512D, 0x4E64, 0x4B3D, 0x47BC, 0x43E4, 0x3FBB, 0x3B45, 0x3689, 0x318A, 0x2C51, 0x26E2, 0x2144, 0x1B7E, 0x1598,
        0x0F97, 0x0984, 0x0365, 0xFD44, 0xF724, 0xF10F, 0xEB0D, 0xE523, 0xDF59, 0xD9B7, 0xD443, 0xCF03, 0xC9FE, 0xC53A, 0xC0BC, 0xBC8B,
        0xB8AA, 0xB51F, 0xB1EE, 0xAF1B, 0xACA9, 0xAA9A, 0xA8F3, 0xA7B4, 0xA6DE, 0xA674, 0xA676, 0xA6E3, 0xA7BB, 0xA8FC, 0xAAA7, 0xACB8,
        0xAF2C, 0xB202, 0xB536, 0xB8C3, 0xBCA6, 0xC0D9, 0xC559, 0xCA1F, 0xCF25, 0xD466, 0xD9DC, 0xDF7F, 0xE54A, 0xEB34, 0xF138, 0xF74D,
        0xFD6D, 0x038E, 0x09AD, 0x0FC0, 0x15BF, 0x1BA5, 0x216A, 0x2706, 0x2C74, 0x31AC, 0x36A9, 0x3B64, 0x3FD8, 0x43FF, 0x47D4, 0x4B53,
        0x4E78, 0x513F, 0x53A4, 0x55A4, 0x573E, 0x586F, 0x5936, 0x5992, 0x5982, 0x5907, 0x5821, 0x56D1, 0x5518, 0x52FA, 0x5078, 0x4D96,
        0x4A56, 0x46BD, 0x42CF, 0x3E91, 0x3A08, 0x3539, 0x302A, 0x2AE2, 0x2565, 0x1FBC, 0x19ED, 0x13FF, 0x0DF9, 0x07E2, 0x01C1, 0xFBA0,
        0xF583, 0xEF72, 0xE975, 0xE393, 0xDDD4, 0xD83D, 0xD2D6, 0xCDA5, 0xC8B1, 0xC3FF, 0xBF96, 0xBB79, 0xB7AF, 0xB43C, 0xB123, 0xAE6A,
        0xAC12, 0xAA1F, 0xA893, 0xA770, 0xA6B8, 0xA66A, 0xA688, 0xA712, 0xA806, 0xA964, 0xAB2A, 0xAD56, 0xAFE5, 0xB2D4, 0xB620, 0xB9C5,
        0xBDBE, 0xC206, 0xC699, 0xCB71, 0xD087, 0xD5D7, 0xDB5A, 0xE108, 0xE6DC, 0xECCE, 0xF2D7, 0xF8EF, 0xFF11, 0x0532, 0x0B4E, 0x115C,
        0x1756, 0x1D34, 0x22EE, 0x287F, 0x2DDF, 0x3308, 0x37F3, 0x3C9C, 0x40FC, 0x450D, 0x48CC, 0x4C34, 0x4F40, 0x51EC, 0x5437, 0x561C,
        0x579A, 0x58AF, 0x5959, 0x5998, 0x596B, 0x58D4, 0x57D1, 0x5665, 0x5491, 0x5258, 0x4FBC, 0x4CC0, 0x4968, 0x45B8, 0x41B4, 0x3D62,
        0x38C5, 0x33E5, 0x2EC6, 0x296F, 0x23E6, 0x1E32, 0x185A, 0x1265, 0x0C59, 0x063F, 0x001D, 0xF9FD, 0xF3E2, 0xEDD6, 0xE7DF, 0xE206,
        0xDC51, 0xD6C6, 0xD16D, 0xCC4C, 0xC769, 0xC2CA, 0xBE74, 0xBA6E, 0xB6BA, 0xB35F, 0xB05F, 0xADC0, 0xAB83, 0xA9AB, 0xA83B, 0xA734,
        0xA698, 0xA668, 0xA6A3, 0xA749, 0xA85A, 0xA9D4, 0xABB5, 0xADFC, 0xB0A5, 0xB3AD, 0xB711, 0xBACD, 0xBEDB, 0xC338, 0xC7DE, 0xCCC7,
        0xD1EE, 0xD74C, 0xDCDB, 0xE294, 0xE870, 0xEE69, 0xF477, 0xFA92, 0x00B4, 0x06D5, 0x0CEE, 0x12F8, 0x18EB, 0x1EC0, 0x2470, 0x29F4,
        0x2F46, 0x345F, 0x3939, 0x3DCF, 0x421A, 0x4616, 0x49BE, 0x4D0D, 0x5000, 0x5293, 0x54C2, 0x568C, 0x57EE, 0x58E7, 0x5974, 0x5997,
        0x594D, 0x5899, 0x577A, 0x55F2, 0x5403, 0x51AF, 0x4EF9, 0x4BE4, 0x4874, 0x44AD, 0x4094, 0x3C2D, 0x377E, 0x328C, 0x2D5E, 0x27F9,
        0x2264, 0x1CA5, 0x16C5, 0x10C9, 0x0AB9, 0x049C, 0xFE7A, 0xF85A, 0xF242, 0xEC3B, 0xE64C, 0xE07B, 0xDAD1, 0xD553, 0xD008, 0xCAF7,
        0xC626, 0xC19A, 0xBD59, 0xB968, 0xB5CC, 0xB288, 0xAFA2, 0xAD1D, 0xAAFA, 0xA93E, 0xA7EA, 0xA700, 0xA681, 0xA66D, 0xA6C5, 0xA787,
        0xA8B4, 0xAA4A, 0xAC47, 0xAEA8, 0xB16B, 0xB48C, 0xB808, 0xBBDA, 0xBFFE, 0xC46F, 0xC928, 0xCE22, 0xD358, 0xD8C4, 0xDE5F, 0xE422,
        0xEA07, 0xF006, 0xF618, 0xFC36, 0x0258, 0x0878, 0x0E8D, 0x1492, 0x1A7D, 0x2049, 0x25EE, 0x2B65, 0x30A9, 0x35B1, 0x3A7A, 0x3EFC,
        0x4333, 0x4719, 0x4AA9, 0x4DE0, 0x50BA, 0x5332, 0x5547, 0x56F5, 0x583B, 0x5917, 0x5988, 0x598E, 0x5928, 0x5856, 0x571B, 0x5578,
        0x536D, 0x50BE, 0x4DB2, 0x4A4E, 0x4695, 0x428E, 0x3E3E, 0x39AA, 0x34D8, 0x2FCE, 0x2A93, 0x252D, 0x1FA4, 0x19FE, 0x1442, 0x0E77,
        0x08A4, 0x02D0, 0xFD04, 0xF743, 0xF197, 0xEC06, 0xE696, 0xE14E, 0xDC33, 0xD74C, 0xD29E, 0xCE2F, 0xCA03, 0xC61E, 0xC286, 0xBF3E,
        0xBC4A, 0xB9AB, 0xB766, 0xB57C, 0xB3EF, 0xB2C0, 0xB1EF, 0xB17E, 0xB16C, 0xB1B9, 0xB263, 0xB369, 0xB4C9, 0xB681, 0xB88F, 0xBAEE,
        0xBD9D, 0xC097, 0xC3D7, 0xC75A, 0xCB1B, 0xCF14, 0xD341, 0xD79D, 0xDC21, 0xE0C8, 0xE58C, 0xEA67, 0xEF54, 0xF44B, 0xF948, 0xFE43,
        0x0336, 0x081D, 0x0CF2, 0x11AE, 0x164C, 0x1AC6, 0x1F18, 0x233C, 0x272F, 0x2AEB, 0x2E6C, 0x31AF, 0x34B0, 0x376C, 0x39E0, 0x3C09,
        0x3DE7, 0x3F76, 0x40B7, 0x41A7, 0x4246, 0x4294, 0x4292, 0x4240, 0x419F, 0x40B0, 0x3F75, 0x3DF0, 0x3C24, 0x3A13, 0x37C0, 0x352F,
        0x3263, 0x2F60, 0x2C2A, 0x28C6, 0x2537, 0x2183, 0x1DAE, 0x19BD, 0x15B5, 0x119B, 0x0D74, 0x0946, 0x0515, 0x00E7, 0xFCC1, 0xF8A7,
        0xF49E, 0xF0AB, 0xECD3, 0xE91A, 0xE584, 0xE216, 0xDED3, 0xDBBF, 0xD8DD, 0xD630, 0xD3BB, 0xD181, 0xCF84, 0xCDC5, 0xCC46, 0xCB09,
        0xCA0E, 0xC956, 0xC8E2, 0xC8B1, 0xC8C3, 0xC917, 0xC9AD, 0xCA82, 0xCB96, 0xCCE7, 0xCE73, 0xD036, 0xD22F, 0xD45B, 0xD6B6, 0xD93E,
        0xDBEF, 0xDEC5, 0xE1BC, 0xE4D1, 0xE800, 0xEB44, 0xEE9A, 0xF1FD, 0xF569, 0xF8D9, 0xFC4A, 0xFFB8, 0x031D, 0x0677, 0x09C1, 0x0CF7,
        0x1017, 0x131B, 0x1601, 0x18C6, 0x1B66, 0x1DDF, 0x202E, 0x2250, 0x2444, 0x2608, 0x2799, 0x28F6, 0x2A1F, 0x2B13, 0x2BCF, 0x2C56,
        0x2CA5, 0x2CBE, 0x2CA1, 0x2C4E, 0x2BC7, 0x2B0D, 0x2A20, 0x2903, 0x27B7, 0x263F, 0x249C, 0x22D2, 0x20E3, 0x1ED0, 0x1C9E, 0x1A50,
        0x17E8, 0x1569, 0x12D7, 0x1036, 0x0D87, 0x0AD0, 0x0813, 0x0554, 0x0296, 0xFFDD, 0xFD2B, 0xFA84, 0xF7EB, 0xF563, 0xF2EE, 0xF090,
        0xEE4C, 0xEC23, 0xEA18, 0xE82E, 0xE666, 0xE4C2, 0xE343, 0xE1EC, 0xE0BC, 0xDFB6, 0xDEDA, 0xDE28, 0xDDA1, 0xDD46, 0xDD15, 0xDD0F,
        0xDD34, 0xDD82, 0xDDF8, 0xDE97, 0xDF5C, 0xE046, 0xE154, 0xE283, 0xE3D3, 0xE540, 0xE6C9, 0xE86D, 0xEA27, 0xEBF7, 0xEDD9, 0xEFCB,
        0xF1CA, 0xF3D4, 0xF5E7, 0xF7FF, 0xFA1A, 0xFC35, 0xFE4E, 0x0061, 0x026E, 0x0471, 0x0668, 0x0851, 0x0A29, 0x0BEF, 0x0DA0, 0x0F3B,
        0x10BF, 0x1228, 0x1377, 0x14AA, 0x15BF, 0x16B7, 0x178F, 0x1848, 0x18E1, 0x195A, 0x19B2, 0x19EA, 0x1A01, 0x19F9, 0x19D1, 0x198B,
        0x1926, 0x18A5, 0x1807, 0x174F, 0x167C, 0x1592, 0x1491, 0x137B, 0x1251, 0x1115, 0x0FC9, 0x0E6F, 0x0D09, 0x0B99, 0x0A20, 0x08A0,
        0x071C, 0x0595, 0x040E, 0x0288, 0x0105, 0xFF88, 0xFE10, 0xFCA1, 0xFB3C, 0xF9E3, 0xF896, 0xF759, 0xF62B, 0xF50E, 0xF403, 0xF30B,
        0xF228, 0xF159, 0xF09F, 0xEFFC, 0xEF6F, 0xEEF8, 0xEE99, 0xEE50, 0xEE1F, 0xEE04, 0xEE00, 0xEE11, 0xEE39, 0xEE75, 0xEEC6, 0xEF2B,
        0xEFA2, 0xF02B, 0xF0C5, 0xF16F, 0xF228, 0xF2EE, 0xF3C0, 0xF49D, 0xF584, 0xF673, 0xF769, 0xF865, 0xF966, 0xFA69, 0xFB6E, 0xFC73,
        0xFD77, 0xFE79, 0xFF77, 0x0070, 0x0163, 0x0250, 0x0335, 0x0411, 0x04E3, 0x05AB, 0x0667, 0x0717, 0x07BA, 0x0850, 0x08D8, 0x0952,
        0x09BD, 0x0A1A, 0x0A68, 0x0AA8, 0x0AD8, 0x0AFA, 0x0B0D, 0x0B12, 0x0B09, 0x0AF2, 0x0ACF, 0x0A9E, 0x0A62, 0x0A1A, 0x09C7, 0x096A,
        0x0903, 0x0894, 0x081D, 0x079F, 0x071B, 0x0692, 0x0604, 0x0572, 0x04DE, 0x0448, 0x03B0, 0x0318, 0x0281, 0x01EB, 0x0158, 0x00C7,
        0x0039, 0xFFB1, 0xFF2C, 0xFEAC, 0xFE33, 0xFDBF, 0xFD53, 0xFCED, 0xFC8F, 0xFC39, 0xFBEA, 0xFBA3, 0xFB65, 0xFB2F, 0xFB01, 0xFADC,
        0xFABF, 0xFAAA, 0xFA9C, 0xFA97, 0xFA99, 0xFAA2, 0xFAB2, 0xFAC8, 0xFAE5, 0xFB07, 0xFB2F, 0xFB5C, 0xFB8D, 0xFBC2, 0xFBFB, 0xFC37,
        0xFC75, 0xFCB5, 0xFCF7, 0xFD3B, 0xFD7F, 0xFDC3, 0xFE07, 0xFE4A, 0xFE8C, 0xFECD, 0xFF0C, 0xFF4A, 0xFF85, 0xFFBD, 0xFFF2, 0x0023,
        0x0052, 0x007E, 0x00A6, 0x00CA, 0x00EB, 0x0108, 0x0121, 0x0137, 0x0149, 0x0157, 0x0162, 0x0169, 0x016D, 0x016E, 0x016D, 0x0168,
        0x0161, 0x0158, 0x014D, 0x0140, 0x0131, 0x0122, 0x0111, 0x00FF, 0x00EC, 0x00DA, 0x00C7, 0x00B4, 0x00A1, 0x008F, 0x007E, 0x006D,
        0x005D, 0x004F, 0x0041, 0x0035, 0x002A, 0x0020, 0x0018, 0x0011, 0x000B, 0x0006, 0x0003, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFF9, 0xFFF7, 0xFFF5, 0xFFF2, 0xFFF0, 0xFFED, 0xFFEA,
        0xFFE7, 0xFFE4, 0xFFE1, 0xFFDE, 0xFFDB, 0xFFD8, 0xFFD5, 0xFFD3, 0xFFD0, 0xFFCF, 0xFFCD, 0xFFCD, 0xFFCC, 0xFFCD, 0xFFCE, 0xFFD0,
        0xFFD2, 0xFFD6, 0xFFDA, 0xFFDF, 0xFFE5, 0xFFED, 0xFFF5, 0xFFFE, 0x0007, 0x0012, 0x001F, 0x002C, 0x003A, 0x0049, 0x0059, 0x0069,
        0x007B, 0x008D, 0x009F, 0x00B2, 0x00C6, 0x00D9, 0x00ED, 0x0101, 0x0114, 0x0128, 0x013A, 0x014C, 0x015E, 0x016E, 0x017E, 0x018C,
        0x0199, 0x01A4, 0x01AE, 0x01B5, 0x01BB, 0x01BE, 0x01C0, 0x01BE, 0x01BB, 0x01B4, 0x01AB, 0x019F, 0x0190, 0x017E, 0x0169, 0x0152,
        0x0137, 0x0119, 0x00F8, 0x00D4, 0x00AE, 0x0084, 0x0058, 0x002A, 0xFFF9, 0xFFC6, 0xFF91, 0xFF5A, 0xFF21, 0xFEE6, 0xFEAB, 0xFE6F,
        0xFE32, 0xFDF4, 0xFDB7, 0xFD7A, 0xFD3E, 0xFD03, 0xFCC9, 0xFC90, 0xFC5A, 0xFC26, 0xFBF5, 0xFBC7, 0xFB9C, 0xFB75, 0xFB53, 0xFB34,
        0xFB1B, 0xFB06, 0xFAF7, 0xFAED, 0xFAE9, 0xFAEB, 0xFAF3, 0xFB01, 0xFB16, 0xFB32, 0xFB54, 0xFB7D, 0xFBAC, 0xFBE3, 0xFC20, 0xFC63,
        0xFCAD, 0xFCFD, 0xFD54, 0xFDB0, 0xFE12, 0xFE79, 0xFEE5, 0xFF55, 0xFFCA, 0x0042, 0x00BD, 0x013C, 0x01BD, 0x023F, 0x02C3, 0x0347,
        0x03CB, 0x044F, 0x04D1, 0x0551, 0x05CE, 0x0649, 0x06BF, 0x0731, 0x079D, 0x0804, 0x0864, 0x08BD, 0x090E, 0x0958, 0x0998, 0x09CF,
        0x09FC, 0x0A1E, 0x0A37, 0x0A44, 0x0A45, 0x0A3B, 0x0A25, 0x0A03, 0x09D5, 0x099A, 0x0953, 0x0900, 0x08A1, 0x0835, 0x07BE, 0x073B,
        0x06AD, 0x0615, 0x0571, 0x04C4, 0x040E, 0x034F, 0x0288, 0x01BA, 0x00E5, 0x000A, 0xFF2C, 0xFE49, 0xFD63, 0xFC7A, 0xFB91, 0xFAA8,
        0xF9C0, 0xF8DA, 0xF7F7, 0xF718, 0xF63F, 0xF56C, 0xF4A1, 0xF3DF, 0xF326, 0xF277, 0xF1D5, 0xF13F, 0xF0B6, 0xF03C, 0xEFD1, 0xEF76,
        0xEF2C, 0xEEF3, 0xEECC, 0xEEB7, 0xEEB5, 0xEEC7, 0xEEEC, 0xEF25, 0xEF71, 0xEFD2, 0xF046, 0xF0CE, 0xF169, 0xF217, 0xF2D8, 0xF3AB,
        0xF490, 0xF585, 0xF68B, 0xF79F, 0xF8C2, 0xF9F2, 0xFB2E, 0xFC75, 0xFDC6, 0xFF1F, 0x007E, 0x01E3, 0x034C, 0x04B8, 0x0625, 0x0792,
        0x08FC, 0x0A62, 0x0BC3, 0x0D1C, 0x0E6D, 0x0FB4, 0x10EE, 0x121B, 0x1339, 0x1447, 0x1542, 0x162A, 0x16FD, 0x17BB, 0x1861, 0x18EF,
        0x1964, 0x19BE, 0x19FE, 0x1A22, 0x1A2A, 0x1A15, 0x19E3, 0x1994, 0x1927, 0x189D, 0x17F6, 0x1733, 0x1652, 0x1556, 0x143F, 0x130D,
        0x11C1, 0x105E, 0x0EE3, 0x0D52, 0x0BAC, 0x09F4, 0x082A, 0x0651, 0x046A, 0x0277, 0x007A, 0xFE77, 0xFC6C, 0xFA5F, 0xF850, 0xF642,
        0xF437, 0xF232, 0xF035, 0xEE42, 0xEC5B, 0xEA84, 0xE8BD, 0xE70A, 0xE56C, 0xE3E6, 0xE279, 0xE127, 0xDFF3, 0xDEDD, 0xDDE8, 0xDD15,
        0xDC66, 0xDBDB, 0xDB75, 0xDB37, 0xDB20, 0xDB30, 0xDB69, 0xDBCB, 0xDC56, 0xDD09, 0xDDE5, 0xDEE9, 0xE015, 0xE167, 0xE2DF, 0xE47B,
        0xE63B, 0xE81C, 0xEA1E, 0xEC3E, 0xEE7A, 0xF0D0, 0xF33E, 0xF5C2, 0xF859, 0xFB01, 0xFDB6, 0x0075, 0x033E, 0x060B, 0x08DB, 0x0BA9,
        0x0E73, 0x1137, 0x13F0, 0x169B, 0x1936, 0x1BBD, 0x1E2E, 0x2086, 0x22C0, 0x24DC, 0x26D6, 0x28AC, 0x2A5A, 0x2BE0, 0x2D3A, 0x2E67,
        0x2F65, 0x3032, 0x30CE, 0x3136, 0x3169, 0x3167, 0x3130, 0x30C3, 0x301F, 0x2F45, 0x2E35, 0x2CF0, 0x2B77, 0x29CA, 0x27EB, 0x25DB,
        0x239C, 0x2131, 0x1E9A, 0x1BDB, 0x18F7, 0x15EF, 0x12C6, 0x0F81, 0x0C22, 0x08AD, 0x0524, 0x018D, 0xFDEB, 0xFA40, 0xF692, 0xF2E4,
        0xEF3B, 0xEB9A, 0xE805, 0xE481, 0xE111, 0xDDBA, 0xDA7F, 0xD764, 0xD46D, 0xD19E, 0xCEFA, 0xCC83, 0xCA3F, 0xC82F, 0xC656, 0xC4B6,
        0xC353, 0xC22E, 0xC14A, 0xC0A7, 0xC047, 0xC02B, 0xC054, 0xC0C2, 0xC177, 0xC270, 0xC3AF, 0xC533, 0xC6FA, 0xC903, 0xCB4D, 0xCDD6,
        0xD09B, 0xD39B, 0xD6D2, 0xDA3E, 0xDDDB, 0xE1A5, 0xE59A, 0xE9B5, 0xEDF3, 0xF24E, 0xF6C3, 0xFB4C, 0xFFE5, 0x0489, 0x0934, 0x0DDF,
        0x1288, 0x1727, 0x1BB8, 0x2036, 0x249B, 0x28E3, 0x2D0A, 0x3109, 0x34DC, 0x387F, 0x3BEE, 0x3F23, 0x421C, 0x44D4, 0x4748, 0x4974,
        0x4B56, 0x4CEB, 0x4E30, 0x4F23, 0x4FC3, 0x500E, 0x5003, 0x4FA2, 0x4EE9, 0x4DDA, 0x4C74, 0x4AB8, 0x48A7, 0x4643, 0x438E, 0x408A,
        0x3D39, 0x399F, 0x35BE, 0x319B, 0x2D39, 0x289C, 0x23CA, 0x1EC6, 0x1996, 0x143F, 0x0EC7, 0x0932, 0x0388, 0xFDCF, 0xF80A, 0xF242,
        0xEC91, 0xE6F5, 0xE174, 0xDC13, 0xD6D9, 0xD1CA, 0xCCEE, 0xC848, 0xC3DD, 0xBFB3, 0xBBCD, 0xB831, 0xB4E1, 0xB1E2, 0xAF36, 0xACE0,
        0xAAE4, 0xA942, 0xA7FE, 0xA717, 0xA690, 0xA668, 0xA6A0, 0xA738, 0xA82E, 0xA983, 0xAB34, 0xAD40, 0xAFA4, 0xB25E, 0xB56B, 0xB8C8,
        0xBC71, 0xC063, 0xC498, 0xC90D, 0xCDBD, 0xD2A3, 0xD7B9, 0xDCFA, 0xE261, 0xE7E7, 0xED87, 0xF33B, 0xF8FC, 0xFEC5, 0x048F, 0x0A54,
        0x100E, 0x15B8, 0x1B4A, 0x20BE, 0x2610, 0x2B39, 0x3034, 0x34FB, 0x398A, 0x3DDB, 0x41EA, 0x45B2, 0x4930, 0x4C60, 0x4F3E, 0x51C7,
        0x53F9, 0x55D0, 0x574C, 0x586B, 0x592B, 0x598C, 0x598D, 0x592E, 0x5870, 0x5753, 0x55D9, 0x5403, 0x51D3, 0x4F4C, 0x4C6F, 0x4941,
        0x45C5, 0x41FE, 0x3DF1, 0x39A1, 0x3513, 0x304D, 0x2B53, 0x262B, 0x20DA, 0x1B66, 0x15D4, 0x102C, 0x0A71, 0x04AC, 0xFEE3, 0xF91A,
        0xF358, 0xEDA4, 0xE803, 0xE27D, 0xDD15, 0xD7D3, 0xD2BC, 0xCDD6, 0xC925, 0xC4AE, 0xC078, 0xBC85, 0xB8DA, 0xB57C, 0xB26D, 0xAFB1,
        0xAD4B, 0xAB3D, 0xA98A, 0xA834, 0xA73C, 0xA6A2, 0xA668, 0xA68E, 0xA714, 0xA7F8, 0xA93B, 0xAADB, 0xACD5, 0xAF29, 0xB1D3, 0xB4D1,
        0xB81F, 0xBBBA, 0xBF9E, 0xC3C7, 0xC830, 0xCCD5, 0xD1B1, 0xD6BE, 0xDBF8, 0xE158, 0xE6D8, 0xEC74, 0xF225, 0xF7E4, 0xFDAC, 0x0376,
        0x093D, 0x0EFA, 0x14A6, 0x1A3D, 0x1FB8, 0x2511, 0x2A42, 0x2F46, 0x3418, 0x38B1, 0x3D0F, 0x412A, 0x4500, 0x488D, 0x4BCB, 0x4EB9,
        0x5152, 0x5395, 0x557E, 0x570B, 0x583C, 0x590E, 0x5981, 0x5994, 0x5947, 0x589B, 0x5790, 0x5628, 0x5463, 0x5244, 0x4FCD, 0x4D01,
        0x49E2, 0x4674, 0x42BB, 0x3EBB, 0x3A77, 0x35F5, 0x3139, 0x2C49, 0x2729, 0x21DF, 0x1C71, 0x16E5, 0x1140, 0x0B89, 0x05C5, 0xFFFC,
        0xFA32, 0xF46F, 0xEEB7, 0xE913, 0xE387, 0xDE19, 0xD8CF, 0xD3B0, 0xCEC0, 0xCA04, 0xC582, 0xC13F, 0xBD3F, 0xB986, 0xB619, 0xB2FB,
        0xB02F, 0xADB9, 0xAB9A, 0xA9D6, 0xA86E, 0xA763, 0xA6B8, 0xA66C, 0xA67F, 0xA6F3, 0xA7C6, 0xA8F7, 0xAA85, 0xAC6E, 0xAEB1, 0xB14B,
        0xB439, 0xB779, 0xBB05, 0xBEDC, 0xC2F8, 0xC755, 0xCBF0, 0xD0C1, 0xD5C6, 0xDAF7, 0xE050, 0xE5CB, 0xEB62, 0xF10F, 0xF6CC, 0xFC93,
        0x025D, 0x0825, 0x0DE4, 0x1395, 0x1930, 0x1EB1, 0x2410, 0x294A, 0x2E57, 0x3332, 0x37D7, 0x3C40, 0x4068, 0x444C, 0x47E6, 0x4B34,
        0x4E31, 0x50DB, 0x532E, 0x5528, 0x56C7, 0x5809, 0x58EE, 0x5973, 0x5998, 0x595D, 0x58C3, 0x57CA, 0x5673, 0x54C0, 0x52B2, 0x504B,
        0x4D8F, 0x4A7F, 0x4720, 0x4375, 0x3F82, 0x3B4B, 0x36D4, 0x3223, 0x2D3C, 0x2825, 0x22E3, 0x1D7B, 0x17F4, 0x1253, 0x0C9F, 0x06DD,
        0x0114, 0xFB4B, 0xF586, 0xEFCC, 0xEA23, 0xE492, 0xDF1E, 0xD9CD, 0xD4A5, 0xCFAB, 0xCAE5, 0xC658, 0xC209, 0xBDFC, 0xBA35, 0xB6BA,
        0xB38C, 0xB0B0, 0xAE29, 0xABFA, 0xAA25, 0xA8AB, 0xA78F, 0xA6D1, 0xA673, 0xA674, 0xA6D6, 0xA796, 0xA8B6, 0xAA32, 0xAC0B, 0xAE3D,
        0xB0C6, 0xB3A5, 0xB6D5, 0xBA53, 0xBE1C, 0xC22B, 0xC67D, 0xCB0C, 0xCFD3, 0xD4CE, 0xD9F8, 0xDF4A, 0xE4BF, 0xEA51, 0xEFFA, 0xF5B5,
        0xFB7A, 0x0144, 0x070D, 0x0CCE, 0x1282, 0x1822, 0x1DA8, 0x230E, 0x284F, 0x2D65, 0x324A, 0x36FA, 0x3B6E, 0x3FA3, 0x4394, 0x473D,
        0x4A9A, 0x4DA6, 0x5060, 0x52C4, 0x54CF, 0x5680, 0x57D4, 0x58CA, 0x5961, 0x5998, 0x5970, 0x58E8, 0x5801, 0x56BB, 0x5519, 0x531C,
        0x50C6, 0x4E1A, 0x4B1A, 0x47CA, 0x442D, 0x4047, 0x3C1C, 0x37B2, 0x330B, 0x2E2E, 0x291F, 0x23E5, 0x1E84, 0x1902, 0x1366, 0x0DB5,
        0x07F6, 0x022D, 0xFC64, 0xF69D, 0xF0E0, 0xEB34, 0xE59E, 0xE024, 0xDACC, 0xD59C, 0xD099, 0xCBC9, 0xC731, 0xC2D5, 0xBEBB, 0xBAE7,
        0xB75D, 0xB420, 0xB135, 0xAE9D, 0xAC5D, 0xAA77, 0xA8EB, 0xA7BD, 0xA6EE, 0xA67D, 0xA66D, 0xA6BC, 0xA76B, 0xA878, 0xA9E3, 0xABAA,
        0xADCB, 0xB045, 0xB313, 0xB634, 0xB9A4, 0xBD5F, 0xC161, 0xC5A6, 0xCA2A, 0xCEE7, 0xD3D9, 0xD8FA, 0xDE45, 0xE3B4, 0xE941, 0xEEE6,
        0xF49E, 0xFA62, 0x002A, 0x05F4, 0x0BB8, 0x116E, 0x1713, 0x1C9E, 0x220B, 0x2753, 0x2C72, 0x3161, 0x361B, 0x3A9B, 0x3EDC, 0x42DB,
        0x4691, 0x49FD, 0x4D19, 0x4FE2, 0x5257, 0x5473, 0x5635, 0x579A, 0x58A2, 0x594B, 0x5995, 0x597F, 0x5909, 0x5834, 0x5700, 0x5570,
        0x5384, 0x513E, 0x4EA2, 0x4BB2, 0x4871, 0x44E2, 0x410A, 0x3CEC, 0x388D, 0x33F1, 0x2F1E, 0x2A18, 0x24E6, 0x1F8C, 0x1A10, 0x1478,
        0x0ECB, 0x090D, 0x0346, 0xFD7D, 0xF7B5, 0xF1F6, 0xEC46, 0xE6AB, 0xE12B, 0xDBCC, 0xD694, 0xD188, 0xCCAE, 0xC80B, 0xC3A4, 0xBF7D,
        0xBB9B, 0xB803, 0xB4B7, 0xB1BC, 0xAF15, 0xACC4, 0xAACC, 0xA92F, 0xA7EF, 0xA70E, 0xA68B, 0xA668, 0xA6A6, 0xA742, 0xA83E, 0xA997,
        0xAB4D, 0xAD5D, 0xAFC6, 0xB285, 0xB596, 0xB8F7, 0xBCA4, 0xC099, 0xC4D2, 0xC94A, 0xCDFD, 0xD2E5, 0xD7FE, 0xDD41, 0xE2A9, 0xE831,
        0xEDD2, 0xF387, 0xF949, 0xFF12, 0x04DC, 0x0AA1, 0x105A, 0x1602, 0x1B93, 0x2106, 0x2656, 0x2B7D, 0x3075, 0x353A, 0x39C5, 0x3E13,
        0x421E, 0x45E3, 0x495D, 0x4C88, 0x4F62, 0x51E6, 0x5413, 0x55E6, 0x575E, 0x5877, 0x5933, 0x598E, 0x598A, 0x5927, 0x5863, 0x5742,
        0x55C3, 0x53E8, 0x51B3, 0x4F28, 0x4C47, 0x4915, 0x4595, 0x41CA, 0x3DB9, 0x3966, 0x34D5, 0x300C, 0x2B10, 0x25E5, 0x2092, 0x1B1C,
        0x158A, 0x0FE0, 0x0A25, 0x045F, 0xFE96, 0xF8CD, 0xF30C, 0xED58, 0xE7B9, 0xE234, 0xDCCE, 0xD78E, 0xD27A, 0xCD96, 0xC8E8, 0xC475,
        0xC041, 0xBC52, 0xB8AB, 0xB551, 0xB246, 0xAF8F, 0xAD2D, 0xAB24, 0xA976, 0xA825, 0xA731, 0xA69D, 0xA668, 0xA693, 0xA71D, 0xA807,
        0xA94E, 0xAAF3, 0xACF2, 0xAF4A, 0xB1F9, 0xB4FB, 0xB84D, 0xBBEC, 0xBFD4, 0xC400, 0xC86D, 0xCD15, 0xD1F3, 0xD703, 0xDC3E, 0xE1A0,
        0xE723, 0xECBF, 0xF271, 0xF831, 0xFDF9, 0x03C3, 0x0989, 0x0F46, 0x14F1, 0x1A87, 0x2000, 0x2557, 0x2A86, 0x2F88, 0x3456, 0x38ED,
        0x3D47, 0x415F, 0x4531, 0x48BA, 0x4BF4, 0x4EDE, 0x5173, 0x53B0, 0x5595, 0x571E, 0x5849, 0x5916, 0x5984, 0x5992, 0x5941, 0x5890,
        0x5780, 0x5612, 0x5449, 0x5225, 0x4FAA, 0x4CD9, 0x49B6, 0x4644, 0x4287, 0x3E83, 0x3A3C, 0x35B7, 0x30F9, 0x2C05, 0x26E3, 0x2198,
        0x1C28, 0x169A, 0x10F4, 0x0B3C, 0x0578, 0xFFAF, 0xF9E5, 0xF422, 0xEE6C, 0xE8C8, 0xE33D, 0xDDD1, 0xD88A, 0xD36D, 0xCE7F, 0xC9C7,
        0xC548, 0xC108, 0xBD0C, 0xB957, 0xB5EE, 0xB2D4, 0xB00C, 0xAD9A, 0xAB80, 0xA9C1, 0xA85E, 0xA758, 0xA6B2, 0xA66A, 0xA683, 0xA6FC,
        0xA7D3, 0xA909, 0xAA9C, 0xAC8A, 0xAED2, 0xB170, 0xB463, 0xB7A6, 0xBB37, 0xBF11, 0xC331, 0xC791, 0xCC2E, 0xD103, 0xD60A, 0xDB3D,
        0xE098, 0xE615, 0xEBAD, 0xF15B, 0xF719, 0xFCE0, 0x02AA, 0x0872, 0x0E30, 0x13E0, 0x197A, 0x1EF9, 0x2457, 0x298E, 0x2E98, 0x3371,
        0x3813, 0x3C79, 0x409E, 0x447E, 0x4814, 0x4B5E, 0x4E57, 0x50FC, 0x534B, 0x5540, 0x56DA, 0x5818, 0x58F7, 0x5977, 0x5997, 0x5958,
        0x58B9, 0x57BB, 0x565F, 0x54A7, 0x5294, 0x5029, 0x4D68, 0x4A54, 0x46F1, 0x4342, 0x3F4C, 0x3B11, 0x3697, 0x31E3, 0x2CF9, 0x27E0,
        0x229C, 0x1D32, 0x17AA, 0x1208, 0x0C53, 0x0690, 0x00C7, 0xFAFE, 0xF539, 0xEF80, 0xE9D8, 0xE448, 0xDED6, 0xD987, 0xD462, 0xCF6B,
        0xCAA7, 0xC61D, 0xC1D1, 0xBDC8, 0xBA05, 0xB68D, 0xB364, 0xB08D, 0xAE0A, 0xABDF, 0xAA0F, 0xA89A, 0xA783, 0xA6CA, 0xA671, 0xA677,
        0xA6DD, 0xA7A3, 0xA8C7, 0xAA49, 0xAC26, 0xAE5C, 0xB0EB, 0xB3CD, 0xB701, 0xBA84, 0xBE50, 0xC263, 0xC6B8, 0xCB4A, 0xD014, 0xD512,
        0xDA3E, 0xDF92, 0xE508, 0xEA9C, 0xF046, 0xF601, 0xFBC7, 0x0191, 0x0759, 0x0D1A, 0x12CD, 0x186C, 0x1DF1, 0x2355, 0x2894, 0x2DA7,
        0x328A, 0x3737, 0x3BA8, 0x3FDA, 0x43C7, 0x476C, 0x4AC4, 0x4DCD, 0x5082, 0x52E1, 0x54E8, 0x5694, 0x57E3, 0x58D4, 0x5966, 0x5998,
        0x596B, 0x58DE, 0x57F2, 0x56A8, 0x5501, 0x52FF, 0x50A5, 0x4DF4, 0x4AF0, 0x479C, 0x43FB, 0x4011, 0x3BE3, 0x3775, 0x32CC, 0x2DEC,
        0x28DB, 0x239E, 0x1E3B, 0x18B8, 0x131B, 0x0D69, 0x07A9, 0x01E0, 0xFC17, 0xF650, 0xF094, 0xEAE9, 0xE554, 0xDFDC, 0xDA86, 0xD558,
        0xD058, 0xCB8A, 0xC6F5, 0xC29D, 0xBE87, 0xBAB6, 0xB730, 0xB3F7, 0xB110, 0xAE7D, 0xAC42, 0xAA60, 0xA8D9, 0xA7B0, 0xA6E6, 0xA67A,
        0xA66E, 0xA6C3, 0xA776, 0xA889, 0xA9F8, 0xABC4, 0xADEA, 0xB068, 0xB33B, 0xB660, 0xB9D4, 0xBD92, 0xC198, 0xC5E1, 0xCA68, 0xCF28,
        0xD41C, 0xD93F, 0xDE8C, 0xE3FD, 0xE98B, 0xEF32, 0xF4EA, 0xFAAF, 0x0078, 0x0641, 0x0C04, 0x11BA, 0x175D, 0x1CE7, 0x2252, 0x2799,
        0x2CB5, 0x31A1, 0x3658, 0x3AD5, 0x3F13, 0x430E, 0x46C1, 0x4A28, 0x4D40, 0x5005, 0x5275, 0x548C, 0x564A, 0x57AA, 0x58AD, 0x5952,
        0x5996, 0x597B, 0x5900, 0x5826, 0x56EE, 0x5558, 0x5368, 0x511E, 0x4E7D, 0x4B89, 0x4843, 0x44B1, 0x40D5, 0x3CB3, 0x3851, 0x33B2,
        0x2EDC, 0x29D4, 0x249F, 0x1F44, 0x19C6, 0x142D, 0x0E7F, 0x08C1, 0x02F9, 0xFD30, 0xF768, 0xF1AA, 0xEBFB, 0xE661, 0xE0E3, 0xDB86,
        0xD650, 0xD147, 0xCC6F, 0xC7CF, 0xC36B, 0xBF48, 0xBB6A, 0xB7D5, 0xB48D, 0xB197, 0xAEF4, 0xACA7, 0xAAB4, 0xA91C, 0xA7E1, 0xA705,
        0xA687, 0xA669, 0xA6AB, 0xA74D, 0xA84D, 0xA9AB, 0xAB66, 0xAD7B, 0xAFE8, 0xB2AB, 0xB5C1, 0xB926, 0xBCD7, 0xC0D0, 0xC50C, 0xC987,
        0xCE3D, 0xD328, 0xD843, 0xDD88, 0xE2F2, 0xE87B, 0xEE1E, 0xF3D3, 0xF996, 0xFF5F, 0x0529, 0x0AED, 0x10A6, 0x164D, 0x1BDC, 0x214E,
        0x269C, 0x2BC0, 0x30B6, 0x3577, 0x3A00, 0x3E4A, 0x4252, 0x4613, 0x4989, 0x4CB0, 0x4F85, 0x5205, 0x542E, 0x55FC, 0x576F, 0x5883,
        0x593A, 0x5990, 0x5987, 0x591F, 0x5857, 0x5730, 0x55AC, 0x53CD, 0x5194, 0x4F03, 0x4C1E, 0x48E8, 0x4564, 0x4195, 0x3D81, 0x392A,
        0x3497, 0x2FCB, 0x2ACC, 0x259F, 0x204A, 0x1AD3, 0x153F, 0x0F94, 0x09D8, 0x0412, 0xFE49, 0xF880, 0xF2C0, 0xED0D, 0xE76F, 0xE1EB,
        0xDC87, 0xD74A, 0xD237, 0xCD56, 0xC8AB, 0xC43B, 0xC00B, 0xBC20, 0xB87D, 0xB526, 0xB220, 0xAF6D, 0xAD10, 0xAB0C, 0xA963, 0xA816,
        0xA727, 0xA698, 0xA668, 0xA697, 0xA727, 0xA815, 0xA962, 0xAB0B, 0xAD0F, 0xAF6C, 0xB21F, 0xB525, 0xB87B, 0xBC1E, 0xC00A, 0xC439,
        0xC8A9, 0xCD54, 0xD235, 0xD747, 0xDC85, 0xE1E9, 0xE76D, 0xED0B, 0xF2BD, 0xF87E, 0xFE46, 0x0410, 0x09D6, 0x0F91, 0x153C, 0x1AD1,
        0x2048, 0x259D, 0x2ACA, 0x2FC9, 0x3495, 0x3929, 0x3D7F, 0x4194, 0x4562, 0x48E7, 0x4C1D, 0x4F02, 0x5193, 0x53CC, 0x55AC, 0x5730,
        0x5856, 0x591E, 0x5987, 0x5991, 0x593A, 0x5884, 0x576F, 0x55FD, 0x542F, 0x5206, 0x4F86, 0x4CB1, 0x498A, 0x4614, 0x4254, 0x3E4C,
        0x3A02, 0x3579, 0x30B8, 0x2BC2, 0x269E, 0x2150, 0x1BDF, 0x164F, 0x10A8, 0x0AF0, 0x052B, 0xFF62, 0xF998, 0xF3D6, 0xEE20, 0xE87E,
        0xE2F4, 0xDD8A, 0xD845, 0xD32A, 0xCE3F, 0xC989, 0xC50E, 0xC0D1, 0xBCD9, 0xB928, 0xB5C2, 0xB2AD, 0xAFE9, 0xAD7C, 0xAB67, 0xA9AC,
        0xA84E, 0xA74D, 0xA6AB, 0xA669, 0xA687, 0xA704, 0xA7E1, 0xA91C, 0xAAB3, 0xACA6, 0xAEF3, 0xB195, 0xB48C, 0xB7D3, 0xBB68, 0xBF46,
        0xC369, 0xC7CD, 0xCC6D, 0xD145, 0xD64E, 0xDB84, 0xE0E1, 0xE65F, 0xEBF8, 0xF1A7, 0xF766, 0xFD2D, 0x02F7, 0x08BE, 0x0E7C, 0x142B,
        0x19C4, 0x1F41, 0x249D, 0x29D2, 0x2EDA, 0x33B0, 0x384F, 0x3CB1, 0x40D3, 0x44AF, 0x4842, 0x4B87, 0x4E7C, 0x511D, 0x5367, 0x5558,
        0x56ED, 0x5826, 0x5900, 0x597B, 0x5996, 0x5952, 0x58AE, 0x57AB, 0x564A, 0x548D, 0x5276, 0x5006, 0x4D41, 0x4A29, 0x46C2, 0x430F,
        0x3F15, 0x3AD7, 0x365A, 0x31A3, 0x2CB7, 0x279B, 0x2254, 0x1CE9, 0x175F, 0x11BC, 0x0C06, 0x0644, 0x007A, 0xFAB1, 0xF4ED, 0xEF34,
        0xE98E, 0xE3FF, 0xDE8E, 0xD942, 0xD41E, 0xCF2A, 0xCA6A, 0xC5E3, 0xC19A, 0xBD94, 0xB9D5, 0xB661, 0xB33C, 0xB069, 0xADEB, 0xABC5,
        0xA9F9, 0xA889, 0xA777, 0xA6C3, 0xA66F, 0xA67A, 0xA6E5, 0xA7B0, 0xA8D9, 0xAA5F, 0xAC41, 0xAE7C, 0xB10F, 0xB3F6, 0xB72E, 0xBAB5,
        0xBE85, 0xC29B, 0xC6F3, 0xCB88, 0xD056, 0xD556, 0xDA84, 0xDFDA, 0xE552, 0xEAE7, 0xF092, 0xF64E, 0xFC14, 0x01DE, 0x07A6, 0x0D67,
        0x1319, 0x18B6, 0x1E39, 0x239C, 0x28D9, 0x2DEA, 0x32CA, 0x3773, 0x3BE1, 0x4010, 0x43F9, 0x479A, 0x4AEF, 0x4DF3, 0x50A4, 0x52FE,
        0x5500, 0x56A7, 0x57F2, 0x58DE, 0x596B, 0x5998, 0x5966, 0x58D4, 0x57E3, 0x5694, 0x54E9, 0x52E2, 0x5083, 0x4DCE, 0x4AC6, 0x476D,
        0x43C9, 0x3FDB, 0x3BAA, 0x3738, 0x328C, 0x2DA9, 0x2896, 0x2357, 0x1DF3, 0x186E, 0x12D0, 0x0D1D, 0x075C, 0x0193, 0xFBCA, 0xF604,
        0xF049, 0xEA9E, 0xE50B, 0xDF94, 0xDA40, 0xD514, 0xD016, 0xCB4C, 0xC6BA, 0xC265, 0xBE52, 0xBA85, 0xB703, 0xB3CF, 0xB0EC, 0xAE5D,
        0xAC26, 0xAA49, 0xA8C8, 0xA7A3, 0xA6DE, 0xA677, 0xA670, 0xA6CA, 0xA782, 0xA899, 0xAA0E, 0xABDF, 0xAE09, 0xB08B, 0xB363, 0xB68C,
        0xBA04, 0xBDC6, 0xC1D0, 0xC61C, 0xCAA6, 0xCF68, 0xD45F, 0xD985, 0xDED4, 0xE446, 0xE9D6, 0xEF7D, 0xF537, 0xFAFC, 0x00C5, 0x068E,
        0x0C50, 0x1206, 0x17A7, 0x1D30, 0x2299, 0x27DE, 0x2CF7, 0x31E1, 0x3695, 0x3B0F, 0x3F4A, 0x4341, 0x46F0, 0x4A53, 0x4D67, 0x5028,
        0x5293, 0x54A6, 0x565E, 0x57BA, 0x58B8, 0x5957, 0x5997, 0x5977, 0x58F7, 0x5818, 0x56DB, 0x5541, 0x534B, 0x50FD, 0x4E58, 0x4B5F,
        0x4816, 0x447F, 0x409F, 0x3C7A, 0x3815, 0x3373, 0x2E9A, 0x2990, 0x2459, 0x1EFB, 0x197C, 0x13E2, 0x0E33, 0x0874, 0x02AC, 0xFCE3,
        0xF71B, 0xF15E, 0xEBB0, 0xE617, 0xE09B, 0xDB40, 0xD60C, 0xD105, 0xCC30, 0xC793, 0xC332, 0xBF12, 0xBB38, 0xB7A7, 0xB464, 0xB171,
        0xAED3, 0xAC8B, 0xAA9D, 0xA90A, 0xA7D4, 0xA6FC, 0xA683, 0xA66A, 0xA6B1, 0xA758, 0xA85D, 0xA9C0, 0xAB80, 0xAD99, 0xB00B, 0xB2D2,
        0xB5EC, 0xB955, 0xBD0A, 0xC107, 0xC546, 0xC9C5, 0xCE7D, 0xD36B, 0xD888, 0xDDCF, 0xE33B, 0xE8C6, 0xEE69, 0xF420, 0xF9E3, 0xFFAD,
        0x0576, 0x0B3A, 0x10F2, 0x1698, 0x1C26, 0x2195, 0x26E1, 0x2C03, 0x30F7, 0x35B5, 0x3A3B, 0x3E82, 0x4286, 0x4643, 0x49B5, 0x4CD8,
        0x4FA9, 0x5224, 0x5448, 0x5612, 0x577F, 0x588F, 0x5941, 0x5992, 0x5984, 0x5917, 0x584A, 0x571E, 0x5596, 0x53B1, 0x5174, 0x4EDF,
        0x4BF6, 0x48BB, 0x4533, 0x4161, 0x3D49, 0x38EF, 0x3458, 0x2F8A, 0x2A88, 0x2559, 0x2002, 0x1A89, 0x14F4, 0x0F48, 0x098C, 0x03C5,
        0xFDFC, 0xF833, 0xF273, 0xECC2, 0xE725, 0xE1A2, 0xDC41, 0xD705, 0xD1F5, 0xCD17, 0xC86F, 0xC402, 0xBFD5, 0xBBEE, 0xB84F, 0xB4FC,
        0xB1FA, 0xAF4B, 0xACF3, 0xAAF4, 0xA94F, 0xA807, 0xA71D, 0xA693, 0xA668, 0xA69D, 0xA731, 0xA824, 0xA976, 0xAB24, 0xAD2C, 0xAF8E,
        0xB245, 0xB550, 0xB8AA, 0xBC51, 0xC040, 0xC473, 0xC8E6, 0xCD94, 0xD278, 0xD78C, 0xDCCC, 0xE231, 0xE7B7, 0xED56, 0xF309, 0xF8CB,
        0xFE93, 0x045D, 0x0A23, 0x0FDD, 0x1587, 0x1B1A, 0x2090, 0x25E3, 0x2B0E, 0x300A, 0x34D3, 0x3964, 0x3DB7, 0x41C8, 0x4593, 0x4913,
        0x4C46, 0x4F26, 0x51B2, 0x53E7, 0x55C2, 0x5741, 0x5863, 0x5926, 0x598A, 0x598E, 0x5933, 0x5878, 0x575E, 0x55E7, 0x5414, 0x51E7,
        0x4F63, 0x4C89, 0x495E, 0x45E4, 0x4220, 0x3E15, 0x39C7, 0x353B, 0x3077, 0x2B7F, 0x2658, 0x2108, 0x1B95, 0x1605, 0x105D, 0x0AA3,
        0x04DE, 0xFF15, 0xF94C, 0xF389, 0xEDD5, 0xE833, 0xE2AC, 0xDD43, 0xD800, 0xD2E7, 0xCDFF, 0xC94C, 0xC4D4, 0xC09B, 0xBCA6, 0xB8F9,
        0xB597, 0xB286, 0xAFC7, 0xAD5E, 0xAB4E, 0xA998, 0xA83E, 0xA742, 0xA6A6, 0xA669, 0xA68B, 0xA70E, 0xA7EF, 0xA92F, 0xAACB, 0xACC3,
        0xAF14, 0xB1BB, 0xB4B6, 0xB801, 0xBB9A, 0xBF7B, 0xC3A2, 0xC809, 0xCCAC, 0xD186, 0xD692, 0xDBCA, 0xE129, 0xE6A9, 0xEC44, 0xF1F3,
        0xF7B2, 0xFD7A, 0x0344, 0x090B, 0x0EC8, 0x1476, 0x1A0E, 0x1F8A, 0x24E4, 0x2A16, 0x2F1C, 0x33EF, 0x388B, 0x3CEA, 0x4108, 0x44E1,
        0x486F, 0x4BB1, 0x4EA1, 0x513D, 0x5383, 0x556F, 0x5700, 0x5833, 0x5909, 0x597F, 0x5995, 0x594C, 0x58A3, 0x579B, 0x5635, 0x5474,
        0x5258, 0x4FE4, 0x4D1A, 0x49FE, 0x4693, 0x42DC, 0x3EDE, 0x3A9D, 0x361D, 0x3163, 0x2C74, 0x2756, 0x220D, 0x1CA0, 0x1715, 0x1171,
        0x0BBA, 0x05F7, 0x002D, 0xFA64, 0xF4A0, 0xEEE8, 0xE943, 0xE3B6, 0xDE47, 0xD8FC, 0xD3DB, 0xCEE9, 0xCA2C, 0xC5A8, 0xC163, 0xBD60,
        0xB9A5, 0xB635, 0xB314, 0xB046, 0xADCC, 0xABAB, 0xA9E4, 0xA878, 0xA76B, 0xA6BC, 0xA66D, 0xA67D, 0xA6ED, 0xA7BD, 0xA8EB, 0xAA76,
        0xAC5C, 0xAE9C, 0xB133, 0xB41F, 0xB75B, 0xBAE5, 0xBEBA, 0xC2D4, 0xC72F, 0xCBC7, 0xD097, 0xD59A, 0xDACA, 0xE022, 0xE59C, 0xEB32,
        0xF0DE, 0xF69B, 0xFC61, 0x022B, 0x07F3, 0x0DB3, 0x1364, 0x1900, 0x1E82, 0x23E3, 0x291D, 0x2E2C, 0x3309, 0x37B0, 0x3C1B, 0x4045,
        0x442B, 0x47C9, 0x4B19, 0x4E19, 0x50C5, 0x531B, 0x5519, 0x56BB, 0x5800, 0x58E7, 0x5970, 0x5998, 0x5961, 0x58CA, 0x57D4, 0x5680,
        0x54D0, 0x52C5, 0x5061, 0x4DA8, 0x4A9B, 0x473F, 0x4396, 0x3FA5, 0x3B70, 0x36FC, 0x324C, 0x2D67, 0x2851, 0x2311, 0x1DAA, 0x1824,
        0x1284, 0x0CD0, 0x070F, 0x0146, 0xFB7D, 0xF5B7, 0xEFFD, 0xEA53, 0xE4C1, 0xDF4C, 0xD9FA, 0xD4D1, 0xCFD5, 0xCB0E, 0xC67F, 0xC22D,
        0xBE1E, 0xBA55, 0xB6D6, 0xB3A6, 0xB0C8, 0xAE3E, 0xAC0B, 0xAA33, 0xA8B6, 0xA797, 0xA6D6, 0xA674, 0xA673, 0xA6D1, 0xA78E, 0xA8AA,
        0xAA24, 0xABF9, 0xAE28, 0xB0AF, 0xB38B, 0xB6B8, 0xBA34, 0xBDFA, 0xC207, 0xC657, 0xCAE4, 0xCFA9, 0xD4A3, 0xD9CB, 0xDF1B, 0xE48F,
        0xEA21, 0xEFC9, 0xF583, 0xFB49, 0x0112, 0x06DB, 0x0C9D, 0x1251, 0x17F2, 0x1D79, 0x22E0, 0x2823, 0x2D3A, 0x3221, 0x36D2, 0x3B49,
        0x3F80, 0x4374, 0x471F, 0x4A7E, 0x4D8E, 0x504A, 0x52B1, 0x54BF, 0x5673, 0x57CA, 0x58C3, 0x595D, 0x5998, 0x5973, 0x58EE, 0x580A,
        0x56C8, 0x5529, 0x532F, 0x50DC, 0x4E32, 0x4B35, 0x47E8, 0x444D, 0x406A, 0x3C41, 0x37D9, 0x3334, 0x2E59, 0x294C, 0x2413, 0x1EB3,
        0x1932, 0x1397, 0x0DE6, 0x0827, 0x025F, 0xFC96, 0xF6CF, 0xF112, 0xEB64, 0xE5CD, 0xE052, 0xDAF9, 0xD5C8, 0xD0C3, 0xCBF1, 0xC757,
        0xC2FA, 0xBEDD, 0xBB07, 0xB77A, 0xB43B, 0xB14C, 0xAEB2, 0xAC6F, 0xAA85, 0xA8F7, 0xA7C6, 0xA6F3, 0xA680, 0xA66C, 0xA6B8, 0xA763,
        0xA86D, 0xA9D5, 0xAB99, 0xADB8, 0xB02E, 0xB2FA, 0xB618, 0xB985, 0xBD3D, 0xC13D, 0xC581, 0xCA02, 0xCEBE, 0xD3AE, 0xD8CD, 0xDE17,
        0xE384, 0xE910, 0xEEB5, 0xF46C, 0xFA30, 0xFFFA, 0x05C2, 0x0B86, 0x113D, 0x16E2, 0x1C6F, 0x21DD, 0x2727, 0x2C46, 0x3137, 0x35F3,
        0x3A75, 0x3EB9, 0x42B9, 0x4673, 0x49E0, 0x4CFF, 0x4FCC, 0x5243, 0x5462, 0x5627, 0x5790, 0x589B, 0x5947, 0x5994, 0x5981, 0x590E,
        0x583C, 0x570C, 0x557F, 0x5396, 0x5153, 0x4EBA, 0x4BCD, 0x488E, 0x4502, 0x412C, 0x3D10, 0x38B3, 0x341A, 0x2F48, 0x2A44, 0x2513,
        0x1FBA, 0x1A40, 0x14A9, 0x0EFC, 0x093F, 0x0378, 0xFDAF, 0xF7E6, 0xF227, 0xEC76, 0xE6DB, 0xE15A, 0xDBFA, 0xD6C1, 0xD1B3, 0xCCD7,
        0xC832, 0xC3C9, 0xBFA0, 0xBBBC, 0xB820, 0xB4D2, 0xB1D4, 0xAF2A, 0xACD6, 0xAADB, 0xA93C, 0xA7F9, 0xA714, 0xA68E, 0xA668, 0xA6A2,
        0xA73B, 0xA834, 0xA98A, 0xAB3D, 0xAD4A, 0xAFB0, 0xB26C, 0xB57A, 0xB8D9, 0xBC83, 0xC076, 0xC4AD, 0xC923, 0xCDD4, 0xD2BA, 0xD7D1,
        0xDD13, 0xE27A, 0xE801, 0xEDA2, 0xF356, 0xF917, 0xFEE1, 0x04AA, 0x0A6F, 0x1029, 0x15D2, 0x1B64, 0x20D8, 0x2629, 0x2B51, 0x304B,
        0x3511, 0x399F, 0x3DEF, 0x41FC, 0x45C4, 0x4940, 0x4C6E, 0x4F4A, 0x51D2, 0x5402, 0x55D8, 0x5753, 0x586F, 0x592E, 0x598D, 0x598C,
        0x592B, 0x586B, 0x574D, 0x55D1, 0x53F9, 0x51C8, 0x4F3F, 0x4C61, 0x4932, 0x45B4, 0x41EC, 0x3DDD, 0x398C, 0x34FD, 0x3036, 0x2B3B,
        0x2612, 0x20C1, 0x1B4C, 0x15BA, 0x1011, 0x0A56, 0x0491, 0xFEC8, 0xF8FF, 0xF33D, 0xED89, 0xE7E9, 0xE263, 0xDCFC, 0xD7BB, 0xD2A5,
        0xCDBF, 0xC90F, 0xC49A, 0xC064, 0xBC73, 0xB8CA, 0xB56D, 0xB25F, 0xAFA5, 0xAD40, 0xAB35, 0xA983, 0xA82F, 0xA738, 0xA6A0, 0xA668,
        0xA690, 0xA717, 0xA7FD, 0xA942, 0xAAE3, 0xACDF, 0xAF35, 0xB1E0, 0xB4E0, 0xB82F, 0xBBCC, 0xBFB1, 0xC3DB, 0xC846, 0xCCEC, 0xD1C8,
        0xD6D7, 0xDC11, 0xE171, 0xE6F3, 0xEC8F, 0xF240, 0xF7FF, 0xFDC7, 0x0391, 0x0958, 0x0F14, 0x14C1, 0x1A57, 0x1FD2, 0x252A, 0x2A5A,
        0x2F5D, 0x342E, 0x38C7, 0x3D22, 0x413D, 0x4512, 0x489D, 0x4BDA, 0x4EC6, 0x515E, 0x539F, 0x5586, 0x5712, 0x5841, 0x5911, 0x5982,
        0x5994, 0x5945, 0x5897, 0x578A, 0x5620, 0x545A, 0x5239, 0x4FC0, 0x4CF3, 0x49D2, 0x4663, 0x42A9, 0x3EA7, 0x3A62, 0x35DF, 0x3122,
        0x2C31, 0x2710, 0x21C6, 0x1C57, 0x16CA, 0x1125, 0x0B6D, 0x05AA, 0xFFE1, 0xFA17, 0xF454, 0xEE9D, 0xE8F8, 0xE36D, 0xDE00, 0xD8B7,
        0xD398, 0xCEA9, 0xC9EE, 0xC56E, 0xC12C, 0xBD2D, 0xB976, 0xB60A, 0xB2ED, 0xB023, 0xADAE, 0xAB91, 0xA9CE, 0xA868, 0xA75F, 0xA6B6,
        0xA66B, 0xA681, 0xA6F6, 0xA7CA, 0xA8FD, 0xAA8D, 0xAC78, 0xAEBD, 0xB158, 0xB448, 0xB789, 0xBB17, 0xBEEF, 0xC30C, 0xC76B, 0xCC06,
        0xD0D8, 0xD5DE, 0xDB10, 0xE06A, 0xE5E5, 0xEB7D, 0xF12A, 0xF6E7, 0xFCAE, 0x0278, 0x0840, 0x0DFF, 0x13AF, 0x194A, 0x1ECA, 0x2429,
        0x2962, 0x2E6E, 0x3348, 0x37EC, 0x3C54, 0x407B, 0x445D, 0x47F7, 0x4B43, 0x4E3F, 0x50E7, 0x5338, 0x5531, 0x56CE, 0x580E, 0x58F1,
        0x5974, 0x5998, 0x595B, 0x58BF, 0x57C5, 0x566C, 0x54B7, 0x52A7, 0x503F, 0x4D81, 0x4A70, 0x4710, 0x4363, 0x3F6F, 0x3B36, 0x36BF,
        0x320C, 0x2D25, 0x280C, 0x22CA, 0x1D61, 0x17DA, 0x1239, 0x0C84, 0x06C2, 0x00F9, 0xFB30, 0xF56B, 0xEFB1, 0xEA09, 0xE478, 0xDF04,
        0xD9B4, 0xD48D, 0xCF94, 0xCAD0, 0xC644, 0xC1F5, 0xBDE9, 0xBA24, 0xB6AA, 0xB37E, 0xB0A4, 0xAE1E, 0xABF1, 0xAA1D, 0xA8A5, 0xA78A,
        0xA6CE, 0xA672, 0xA675, 0xA6D8, 0xA79B, 0xA8BC, 0xAA3A, 0xAC14, 0xAE48, 0xB0D3, 0xB3B3, 0xB6E5, 0xBA64, 0xBE2E, 0xC23F, 0xC692,
        0xCB22, 0xCFEA, 0xD4E6, 0xDA10, 0xDF63, 0xE4D9, 0xEA6B, 0xF015, 0xF5D0, 0xFB96, 0x015F, 0x0728, 0x0CE9, 0x129C, 0x183C, 0x1DC2,
        0x2327, 0x2868, 0x2D7D, 0x3261, 0x370F, 0x3B83, 0x3FB7, 0x43A6, 0x474E, 0x4AA9, 0x4DB4, 0x506C, 0x52CE, 0x54D8, 0x5687, 0x57D9,
        0x58CD, 0x5963, 0x5998, 0x596E, 0x58E4, 0x57FB, 0x56B4, 0x5511, 0x5312, 0x50BB, 0x4E0D, 0x4B0B, 0x47BA, 0x441B, 0x4034, 0x3C08,
        0x379C, 0x32F5, 0x2E17, 0x2907, 0x23CC, 0x1E6A, 0x18E8, 0x134C, 0x0D9A, 0x07DA, 0x0212, 0xFC49, 0xF682, 0xF0C6, 0xEB19, 0xE584,
        0xE00A, 0xDAB3, 0xD584, 0xD082, 0xCBB3, 0xC71C, 0xC2C1, 0xBEA9, 0xBAD6, 0xB74D, 0xB412, 0xB128, 0xAE92, 0xAC54, 0xAA6F, 0xA8E5,
        0xA7B9, 0xA6EB, 0xA67C, 0xA66D, 0xA6BE, 0xA76F, 0xA87E, 0xA9EA, 0xABB3, 0xADD6, 0xB051, 0xB321, 0xB643, 0xB9B5, 0xBD71, 0xC175,
        0xC5BB, 0xCA40, 0xCEFE, 0xD3F1, 0xD913, 0xDE5E, 0xE3CD, 0xE95B, 0xEF01, 0xF4B9, 0xFA7D, 0x0046, 0x060F, 0x0BD3, 0x1189, 0x172D,
        0x1CB8, 0x2224, 0x276C, 0x2C89, 0x3177, 0x3630, 0x3AAF, 0x3EF0, 0x42ED, 0x46A2, 0x4A0C, 0x4D27, 0x4FEF, 0x5261, 0x547C, 0x563C,
        0x57A0, 0x58A6, 0x594E, 0x5995, 0x597D, 0x5906, 0x582F, 0x56FA, 0x5567, 0x537A, 0x5133, 0x4E95, 0x4BA3, 0x4861, 0x44D1, 0x40F7,
        0x3CD8, 0x3878, 0x33DB, 0x2F07, 0x2A00, 0x24CD, 0x1F72, 0x19F6, 0x145E, 0x0EB0, 0x08F2, 0x032B, 0xFD61, 0xF79A, 0xF1DB, 0xEC2B,
        0xE691, 0xE112, 0xDBB3, 0xD67C, 0xD171, 0xCC98, 0xC7F6, 0xC390, 0xBF6A, 0xBB8A, 0xB7F2, 0xB4A8, 0xB1AF, 0xAF09, 0xACBA, 0xAAC4,
        0xA929, 0xA7EA, 0xA70B, 0xA68A, 0xA669, 0xA6A8, 0xA746, 0xA843, 0xA99E, 0xAB56, 0xAD68, 0xAFD2, 0xB292, 0xB5A5, 0xB908, 0xBCB6,
        0xC0AC, 0xC4E7, 0xC960, 0xCE14, 0xD2FD, 0xD816, 0xDD5A, 0xE2C3, 0xE84B, 0xEDED, 0xF3A2, 0xF964, 0xFF2E, 0x04F7, 0x0ABC, 0x1075,
        0x161D, 0x1BAD, 0x2120, 0x266F, 0x2B95, 0x308C, 0x354F, 0x39DA, 0x3E26, 0x4231, 0x45F4, 0x496C, 0x4C96, 0x4F6E, 0x51F1, 0x541D,
        0x55EE, 0x5764, 0x587C, 0x5935, 0x598F, 0x5989, 0x5924, 0x585F, 0x573B, 0x55BB, 0x53DE, 0x51A8, 0x4F1B, 0x4C39, 0x4905, 0x4583,
        0x41B7, 0x3DA5, 0x3951, 0x34BF, 0x2FF5, 0x2AF8, 0x25CD, 0x2079, 0x1B02, 0x156F, 0x0FC5, 0x0A0A, 0x0444, 0xFE7B, 0xF8B2, 0xF2F1,
        0xED3E, 0xE79F, 0xE21A, 0xDCB5, 0xD776, 0xD262, 0xCD7F, 0xC8D2, 0xC460, 0xC02E, 0xBC40, 0xB89B, 0xB542, 0xB239, 0xAF83, 0xAD23,
        0xAB1C, 0xA96F, 0xA820, 0xA72E, 0xA69B, 0xA668, 0xA694, 0xA721, 0xA80C, 0xA955, 0xAAFB, 0xACFC, 0xAF56, 0xB206, 0xB50A, 0xB85D,
        0xBBFE, 0xBFE7, 0xC414, 0xC882, 0xCD2B, 0xD20B, 0xD71B, 0xDC57, 0xE1BA, 0xE73D, 0xECDA, 0xF28C, 0xF84C, 0xFE14, 0x03DE, 0x09A4,
        0x0F60, 0x150C, 0x1AA1, 0x201A, 0x2570, 0x2A9E, 0x2F9F, 0x346C, 0x3902, 0x3D5B, 0x4172, 0x4543, 0x48CA, 0x4C03, 0x4EEB, 0x517E,
        0x53BA, 0x559D, 0x5724, 0x584E, 0x5919, 0x5985, 0x5992, 0x593E, 0x588C, 0x577A, 0x560B, 0x5440, 0x521A, 0x4F9D, 0x4CCB, 0x49A7,
        0x4633, 0x4275, 0x3E70, 0x3A28, 0x35A1, 0x30E2, 0x2BEE, 0x26CB, 0x217E, 0x1C0E, 0x1680, 0x10D9, 0x0B21, 0x055D, 0xFF94, 0xF9CA,
        0xF407, 0xEE51, 0xE8AE, 0xE324, 0xDDB8, 0xD872, 0xD355, 0xCE69, 0xC9B1, 0xC533, 0xC0F5, 0xBCFA, 0xB946, 0xB5DE, 0xB2C6, 0xB000,
        0xAD8F, 0xAB77, 0xA9BA, 0xA858, 0xA754, 0xA6AF, 0xA66A, 0xA684, 0xA6FF, 0xA7D8, 0xA910, 0xAAA4, 0xAC94, 0xAEDD, 0xB17D, 0xB471,
        0xB7B6, 0xBB48, 0xBF24, 0xC345, 0xC7A6, 0xCC45, 0xD11A, 0xD622, 0xDB56, 0xE0B2, 0xE62F, 0xEBC8, 0xF176, 0xF734, 0xFCFB, 0x02C5,
        0x088D, 0x0E4B, 0x13FA, 0x1994, 0x1F13, 0x2470, 0x29A6, 0x2EB0, 0x3387, 0x3828, 0x3C8D, 0x40B1, 0x448F, 0x4824, 0x4B6D, 0x4E64,
        0x5108, 0x5355, 0x5548, 0x56E1, 0x581D, 0x58FA, 0x5978, 0x5997, 0x5956, 0x58B5, 0x57B5, 0x5658, 0x549E, 0x5289, 0x501D, 0x4D5A,
        0x4A45, 0x46E1, 0x4330, 0x3F38, 0x3AFC, 0x3682, 0x31CC, 0x2CE2, 0x27C7, 0x2282, 0x1D18, 0x178F, 0x11ED, 0x0C38, 0x0675, 0x00AC,
        0xFAE3, 0xF51E, 0xEF65, 0xE9BE, 0xE42E, 0xDEBD, 0xD96F, 0xD44A, 0xCF54, 0xCA92, 0xC609, 0xC1BE, 0xBDB6, 0xB9F4, 0xB67E, 0xB356,
        0xB080, 0xADFF, 0xABD6, 0xAA07, 0xA894, 0xA77E, 0xA6C7, 0xA670, 0xA678, 0xA6E0, 0xA7A7, 0xA8CD, 0xAA50, 0xAC2F, 0xAE68, 0xB0F7,
        0xB3DC, 0xB711, 0xBA95, 0xBE63, 0xC277, 0xC6CD, 0xCB60, 0xD02B, 0xD52A, 0xDA56, 0xDFAB, 0xE522, 0xEAB6, 0xF061, 0xF61C, 0xFBE3,
        0x01AC, 0x0775, 0x0D35, 0x12E8, 0x1886, 0x1E0A, 0x236E, 0x28AC, 0x2DBF, 0x32A1, 0x374C, 0x3BBC, 0x3FED, 0x43D9, 0x477C, 0x4AD3,
        0x4DDA, 0x508E, 0x52EC, 0x54F1, 0x569B, 0x57E8, 0x58D7, 0x5968, 0x5998, 0x5969, 0x58DB, 0x57ED, 0x56A1, 0x54F8, 0x52F5, 0x5099,
        0x4DE7, 0x4AE1, 0x478B, 0x43E9, 0x3FFE, 0x3BCF, 0x3760, 0x32B5, 0x2DD4, 0x28C3, 0x2385, 0x1E22, 0x189E, 0x1300, 0x0D4E, 0x078E,
        0x01C5, 0xFBFB, 0xF635, 0xF07A, 0xEACF, 0xE53A, 0xDFC2, 0xDA6D, 0xD540, 0xD041, 0xCB74, 0xC6E0, 0xC289, 0xBE74, 0xBAA5, 0xB720,
        0xB3E9, 0xB103, 0xAE72, 0xAC38, 0xAA58, 0xA8D3, 0xA7AC, 0xA6E3, 0xA679, 0xA66F, 0xA6C5, 0xA77A, 0xA88E, 0xAA00, 0xABCE, 0xADF5,
        0xB074, 0xB349, 0xB66F, 0xB9E5, 0xBDA5, 0xC1AC, 0xC5F6, 0xCA7E, 0xCF3F, 0xD434, 0xD958, 0xDEA5, 0xE417, 0xE9A6, 0xEF4C, 0xF505,
        0xFACA, 0x0093, 0x065C, 0x0C1F, 0x11D5, 0x1777, 0x1D01, 0x226B, 0x27B1, 0x2CCC, 0x31B8, 0x366E, 0x3AEA, 0x3F27, 0x4320, 0x46D1,
        0x4A37, 0x4D4E, 0x5011, 0x5280, 0x5495, 0x5651, 0x57B0, 0x58B1, 0x5954, 0x5997, 0x597A, 0x58FD, 0x5821, 0x56E7, 0x5550, 0x535E,
        0x5112, 0x4E70, 0x4B7A, 0x4833, 0x449F, 0x40C2, 0x3C9F, 0x383C, 0x339C, 0x2EC5, 0x29BC, 0x2487, 0x1F2A, 0x19AC, 0x1413, 0x0E64,
        0x08A6, 0x02DE, 0xFD14, 0xF74D, 0xF18F, 0xEBE0, 0xE647, 0xE0C9, 0xDB6D, 0xD638, 0xD12F, 0xCC59, 0xC7BA, 0xC357, 0xBF35, 0xBB58,
        0xB7C5, 0xB47F, 0xB189, 0xAEE8, 0xAC9D, 0xAAAC, 0xA916, 0xA7DC, 0xA701, 0xA686, 0xA66A, 0xA6AD, 0xA751, 0xA853, 0xA9B3, 0xAB6F,
        0xAD86, 0xAFF5, 0xB2B9, 0xB5D0, 0xB937, 0xBCE9, 0xC0E3, 0xC521, 0xC99D, 0xCE54, 0xD33F, 0xD85B, 0xDDA1, 0xE30C, 0xE896, 0xEE39,
        0xF3EE, 0xF9B1, 0xFF7B, 0x0544, 0x0B08, 0x10C1, 0x1668, 0x1BF6, 0x2167, 0x26B4, 0x2BD8, 0x30CD, 0x358D, 0x3A15, 0x3E5E, 0x4264,
        0x4624, 0x4998, 0x4CBE, 0x4F92, 0x5210, 0x5437, 0x5604, 0x5775, 0x5888, 0x593C, 0x5991, 0x5986, 0x591C, 0x5852, 0x572A, 0x55A4,
        0x53C3, 0x5188, 0x4EF6, 0x4C10, 0x48D8, 0x4553, 0x4183, 0x3D6D, 0x3915, 0x3481, 0x2FB4, 0x2AB4, 0x2587, 0x2031, 0x1AB9, 0x1524,
        0x0F79, 0x09BD, 0x03F7, 0xFE2D, 0xF865, 0xF2A5, 0xECF2, 0xE755, 0xE1D1, 0xDC6E, 0xD731, 0xD220, 0xCD40, 0xC896, 0xC427, 0xBFF8,
        0xBC0E, 0xB86C, 0xB517, 0xB213, 0xAF61, 0xAD06, 0xAB03, 0xA95C, 0xA811, 0xA724, 0xA696, 0xA668, 0xA699, 0xA72A, 0xA81B, 0xA969,
        0xAB14, 0xAD19, 0xAF78, 0xB22C, 0xB534, 0xB88C, 0xBC30, 0xC01D, 0xC44E, 0xC8BF, 0xCD6B, 0xD24D, 0xD760, 0xDC9E, 0xE202, 0xE787,
        0xED25, 0xF2D8, 0xF899, 0xFE62, 0x042B, 0x09F1, 0x0FAC, 0x1557, 0x1AEB, 0x2062, 0x25B6, 0x2AE2, 0x2FE0, 0x34AB, 0x393E, 0x3D93,
        0x41A6, 0x4574, 0x48F7, 0x4C2C, 0x4F0F, 0x519E, 0x53D6, 0x55B3, 0x5736, 0x585B, 0x5921, 0x5988, 0x5990, 0x5937, 0x5880, 0x5769,
        0x55F5, 0x5425, 0x51FB, 0x4F7A, 0x4CA3, 0x497B, 0x4603, 0x4241, 0x3E38, 0x39ED, 0x3564, 0x30A1, 0x2BAA, 0x2685, 0x2137, 0x1BC5,
        0x1635, 0x108E, 0x0AD4, 0x0510, 0xFF47, 0xF97D, 0xF3BB, 0xEE06, 0xE863, 0xE2DB, 0xDD71, 0xD82C, 0xD312, 0xCE28, 0xC974, 0xC4F9,
        0xC0BE, 0xBCC7, 0xB917, 0xB5B3, 0xB29F, 0xAFDD, 0xAD71, 0xAB5E, 0xA9A5, 0xA848, 0xA749, 0xA6A9, 0xA669, 0xA688, 0xA708, 0xA7E6,
        0xA922, 0xAABC, 0xACB0, 0xAEFE, 0xB1A3, 0xB49B, 0xB7E4, 0xBB7A, 0xBF59, 0xC37D, 0xC7E2, 0xCC84, 0xD15C, 0xD666, 0xDB9D, 0xE0FA,
        0xE679, 0xEC13, 0xF1C2, 0xF781, 0xFD49, 0x0312, 0x08D9, 0x0E97, 0x1445, 0x19DE, 0x1F5B, 0x24B6, 0x29EA, 0x2EF1, 0x33C6, 0x3864,
        0x3CC5, 0x40E6, 0x44C1, 0x4852, 0x4B96, 0x4E89, 0x5128, 0x5371, 0x5560, 0x56F4, 0x582A, 0x5903, 0x597C, 0x5996, 0x5950, 0x58AA,
        0x57A5, 0x5643, 0x5484, 0x526B, 0x4FFA, 0x4D33, 0x4A1A, 0x46B1, 0x42FD, 0x3F02, 0x3AC2, 0x3644, 0x318C, 0x2C9F, 0x2782, 0x223B,
        0x1CD0, 0x1745, 0x11A2, 0x0BEB, 0x0628, 0x005F, 0xFA96, 0xF4D2, 0xEF19, 0xE973, 0xE3E5, 0xDE75, 0xD929, 0xD406, 0xCF13, 0xCA54,
        0xC5CE, 0xC186, 0xBD82, 0xB9C4, 0xB652, 0xB32E, 0xB05D, 0xADE0, 0xABBC, 0xA9F1, 0xA883, 0xA772, 0xA6C0, 0xA66E, 0xA67B, 0xA6E8,
        0xA7B4, 0xA8DF, 0xAA67, 0xAC4B, 0xAE88, 0xB11C, 0xB404, 0xB73E, 0xBAC6, 0xBE97, 0xC2AF, 0xC708, 0xCB9F, 0xD06D, 0xD56E, 0xDA9C,
        0xDFF3, 0xE56C, 0xEB01, 0xF0AD, 0xF669, 0xFC30, 0x01F9, 0x07C1, 0x0D82, 0x1333, 0x18D0, 0x1E53, 0x23B5, 0x28F1, 0x2E01, 0x32E0,
        0x3789, 0x3BF6, 0x4023, 0x440B, 0x47AB, 0x4AFE, 0x4E00, 0x50B0, 0x5309, 0x5509, 0x56AE, 0x57F7, 0x58E1, 0x596D, 0x5998, 0x5964,
        0x58D1, 0x57DE, 0x568D, 0x54E0, 0x52D8, 0x5077, 0x4DC1, 0x4AB7, 0x475D, 0x43B7, 0x3FC8, 0x3B95, 0x3723, 0x3275, 0x2D92, 0x287E,
        0x233E, 0x1DD9, 0x1854, 0x12B5, 0x0D02, 0x0741, 0x0178, 0xFBAE, 0xF5E9, 0xF02E, 0xEA84, 0xE4F1, 0xDF7A, 0xDA27, 0xD4FC, 0xCFFF,
        0xCB36, 0xC6A5, 0xC251, 0xBE3F, 0xBA74, 0xB6F3, 0xB3C0, 0xB0DF, 0xAE52, 0xAC1D, 0xAA41, 0xA8C1, 0xA79F, 0xA6DB, 0xA676, 0xA671,
        0xA6CC, 0xA786, 0xA89F, 0xAA16, 0xABE8, 0xAE14, 0xB098, 0xB371, 0xB69C, 0xBA15, 0xBDD9, 0xC1E3, 0xC630, 0xCABB, 0xCF7F, 0xD477,
        0xD99E, 0xDEED, 0xE460, 0xE9F0, 0xEF98, 0xF552, 0xFB17, 0x00E0, 0x06A9, 0x0C6B, 0x1220, 0x17C2, 0x1D4A, 0x22B2, 0x27F6, 0x2D0F,
        0x31F8, 0x36AB, 0x3B24, 0x3F5D, 0x4353, 0x4701, 0x4A62, 0x4D75, 0x5034, 0x529E, 0x54AF, 0x5665, 0x57C0, 0x58BC, 0x5959, 0x5997,
        0x5975, 0x58F4, 0x5813, 0x56D4, 0x5538, 0x5341, 0x50F1, 0x4E4B, 0x4B50, 0x4805, 0x446E, 0x408C, 0x3C66, 0x37FF, 0x335D, 0x2E83,
        0x2978, 0x2440, 0x1EE2, 0x1962, 0x13C7, 0x0E18, 0x0859, 0x0291, 0xFCC7, 0xF700, 0xF143, 0xEB95, 0xE5FD, 0xE081, 0xDB27, 0xD5F4,
        0xD0EE, 0xCC1A, 0xC77E, 0xC31E, 0xBF00, 0xBB27, 0xB797, 0xB455, 0xB164, 0xAEC7, 0xAC81, 0xAA94, 0xA903, 0xA7CF, 0xA6F9, 0xA682,
        0xA66B, 0xA6B4, 0xA75C, 0xA863, 0xA9C8, 0xAB89, 0xADA4, 0xB017, 0xB2E0, 0xB5FC, 0xB966, 0xBD1C, 0xC11A, 0xC55B, 0xC9DA, 0xCE94,
        0xD382, 0xD8A0, 0xDDE8, 0xE355, 0xE8E0, 0xEE84, 0xF43B, 0xF9FE, 0xFFC8, 0x0591, 0x0B55, 0x110D, 0x16B2, 0x1C3F, 0x21AF, 0x26FA,
        0x2C1B, 0x310D, 0x35CB, 0x3A4F, 0x3E95, 0x4298, 0x4654, 0x49C4, 0x4CE6, 0x4FB5, 0x522F, 0x5451, 0x5619, 0x5785, 0x5893, 0x5943,
        0x5993, 0x5983, 0x5914, 0x5845, 0x5718, 0x558D, 0x53A8, 0x5168, 0x4ED2, 0x4BE7, 0x48AB, 0x4522, 0x414E, 0x3D35, 0x38DA, 0x3442,
        0x2F73, 0x2A70, 0x2541, 0x1FE9, 0x1A6F, 0x14D9, 0x0F2D, 0x0971, 0x03AA, 0xFDE0, 0xF818, 0xF258, 0xECA7, 0xE70B, 0xE189, 0xDC28,
        0xD6ED, 0xD1DE, 0xCD00, 0xC859, 0xC3EE, 0xBFC2, 0xBBDC, 0xB83E, 0xB4ED, 0xB1ED, 0xAF40, 0xACE9, 0xAAEB, 0xA948, 0xA802, 0xA71A,
        0xA691, 0xA668, 0xA69E, 0xA735, 0xA82A, 0xA97D, 0xAB2C, 0xAD37, 0xAF9A, 0xB253, 0xB55F, 0xB8BA, 0xBC63, 0xC053, 0xC487, 0xC8FB,
        0xCDAA, 0xD28F, 0xD7A5, 0xDCE5, 0xE24B, 0xE7D1, 0xED71, 0xF324, 0xF8E6, 0xFEAF, 0x0478, 0x0A3E, 0x0FF8, 0x15A2, 0x1B34, 0x20A9,
        0x25FC, 0x2B26, 0x3021, 0x34E9, 0x3979, 0x3DCB, 0x41DB, 0x45A4, 0x4923, 0x4C54, 0x4F33, 0x51BE, 0x53F1, 0x55CA, 0x5747, 0x5867,
        0x5929, 0x598B, 0x598E, 0x5930, 0x5873, 0x5758, 0x55DF, 0x540B, 0x51DC, 0x4F56, 0x4C7B, 0x494E, 0x45D3, 0x420D, 0x3E01, 0x39B2,
        0x3526, 0x3060, 0x2B67, 0x2640, 0x20EF, 0x1B7B, 0x15EA, 0x1042, 0x0A88, 0x04C3, 0xFEF9, 0xF930, 0xF36E, 0xEDBA, 0xE819, 0xE292,
        0xDD2A, 0xD7E7, 0xD2D0, 0xCDE8, 0xC937, 0xC4BF, 0xC088, 0xBC94, 0xB8E8, 0xB588, 0xB278, 0xAFBB, 0xAD54, 0xAB45, 0xA990, 0xA839,
        0xA73F, 0xA6A4, 0xA668, 0xA68D, 0xA711, 0xA7F4, 0xA935, 0xAAD4, 0xACCD, 0xAF1F, 0xB1C8, 0xB4C5, 0xB811, 0xBBAB, 0xBF8E, 0xC3B6,
        0xC81F, 0xCCC3, 0xD19E, 0xD6AA, 0xDBE3, 0xE143, 0xE6C3, 0xEC5E, 0xF20E, 0xF7CE, 0xFD96, 0x035F, 0x0926, 0x0EE3, 0x1491, 0x1A28,
        0x1FA3, 0x24FC, 0x2A2E, 0x2F33, 0x3405, 0x38A0, 0x3CFE, 0x411B, 0x44F2, 0x487F, 0x4BBF, 0x4EAE, 0x5149, 0x538D, 0x5577, 0x5706,
        0x5838, 0x590C, 0x5980, 0x5995, 0x5949, 0x589F, 0x5795, 0x562E, 0x546A, 0x524D, 0x4FD7, 0x4D0C, 0x49EF, 0x4682, 0x42CA, 0x3ECB,
        0x3A88, 0x3607, 0x314C, 0x2C5C, 0x273D, 0x21F4, 0x1C86, 0x16FB, 0x1156, 0x0B9F, 0x05DB, 0x0012, 0xFA49, 0xF485, 0xEECE, 0xE929,
        0xE39C, 0xDE2E, 0xD8E4, 0xD3C3, 0xCED2, 0xCA16, 0xC593, 0xC14F, 0xBD4E, 0xB994, 0xB626, 0xB306, 0xB039, 0xADC2, 0xABA2, 0xA9DC,
        0xA873, 0xA767, 0xA6BA, 0xA66C, 0xA67E, 0xA6F0, 0xA7C2, 0xA8F1, 0xAA7E, 0xAC66, 0xAEA8, 0xB140, 0xB42D, 0xB76B, 0xBAF7, 0xBECC,
        0xC2E7, 0xC744, 0xCBDD, 0xD0AE, 0xD5B2, 0xDAE3, 0xE03B, 0xE5B6, 0xEB4C, 0xF0F9, 0xF6B6, 0xFC7D, 0x0246, 0x080E, 0x0DCE, 0x137E,
        0x191A, 0x1E83, 0x23C2, 0x28D3, 0x2DAF, 0x3253, 0x36BA, 0x3ADE, 0x3EBD, 0x4253, 0x459C, 0x4895, 0x4B3B, 0x4D8D, 0x4F87, 0x5129,
        0x5272, 0x5360, 0x53F4, 0x542C, 0x540B, 0x538F, 0x52BB, 0x518F, 0x500E, 0x4E3A, 0x4C16, 0x49A3, 0x46E6, 0x43E1, 0x4099, 0x3D12,
        0x394F, 0x3555, 0x3129, 0x2CCF, 0x284D, 0x23A7, 0x1EE4, 0x1A07, 0x1517, 0x1019, 0x0B13, 0x060A, 0x0102, 0xFC04, 0xF712, 0xF232,
        0xED6A, 0xE8BD, 0xE433, 0xDFCE, 0xDB93, 0xD787, 0xD3AE, 0xD00B, 0xCCA1, 0xC976, 0xC68A, 0xC3E1, 0xC17D, 0xBF61, 0xBD8E, 0xBC05,
        0xBAC8, 0xB9D8, 0xB934, 0xB8DD, 0xB8D4, 0xB916, 0xB9A4, 0xBA7D, 0xBB9E, 0xBD06, 0xBEB4, 0xC0A4, 0xC2D4, 0xC542, 0xC7EB, 0xCACA,
        0xCDDD, 0xD11F, 0xD48E, 0xD824, 0xDBDF, 0xDFB8, 0xE3AD, 0xE7B9, 0xEBD7, 0xF002, 0xF436, 0xF86F, 0xFCA7, 0x00DA, 0x0504, 0x0921,
        0x0D2C, 0x1120, 0x14FA, 0x18B6, 0x1C50, 0x1FC5, 0x2310, 0x262F, 0x291F, 0x2BDD, 0x2E66, 0x30B8, 0x32D1, 0x34AF, 0x3651, 0x37B6,
        0x38DB, 0x39C2, 0x3A68, 0x3ACF, 0x3AF5, 0x3ADD, 0x3A85, 0x39EF, 0x391C, 0x380E, 0x36C6, 0x3545, 0x338F, 0x31A6, 0x2F8B, 0x2D42,
        0x2ACD, 0x282F, 0x256D, 0x2288, 0x1F84, 0x1C65, 0x192F, 0x15E5, 0x128A, 0x0F24, 0x0BB4, 0x0840, 0x04CA, 0x0158, 0xFDEC, 0xFA8A,
        0xF735, 0xF3F1, 0xF0C2, 0xEDAA, 0xEAAD, 0xE7CE, 0xE50F, 0xE274, 0xDFFF, 0xDDB2, 0xDB8F, 0xD998, 0xD7CF, 0xD635, 0xD4CC, 0xD395,
        0xD290, 0xD1BF, 0xD121, 0xD0B7, 0xD081, 0xD07F, 0xD0AF, 0xD112, 0xD1A6, 0xD26B, 0xD35F, 0xD480, 0xD5CE, 0xD745, 0xD8E5, 0xDAAA,
        0xDC93, 0xDE9E, 0xE0C7, 0xE30C, 0xE56A, 0xE7DF, 0xEA68, 0xED01, 0xEFA9, 0xF25A, 0xF514, 0xF7D2, 0xFA92, 0xFD50, 0x0009, 0x02BC,
        0x0565, 0x0800, 0x0A8D, 0x0D07, 0x0F6C, 0x11BA, 0x13EF, 0x1609, 0x1805, 0x19E2, 0x1B9D, 0x1D37, 0x1EAC, 0x1FFD, 0x2127, 0x222A,
        0x2306, 0x23BA, 0x2445, 0x24A7, 0x24E1, 0x24F3, 0x24DC, 0x249F, 0x243A, 0x23AF, 0x2300, 0x222D, 0x2138, 0x2021, 0x1EEB, 0x1D98,
        0x1C28, 0x1A9F, 0x18FD, 0x1745, 0x157A, 0x139C, 0x11B0, 0x0FB6, 0x0DB1, 0x0BA4, 0x0990, 0x0779, 0x0560, 0x0348, 0x0133, 0xFF24,
        0xFD1C, 0xFB1D, 0xF92A, 0xF745, 0xF56F, 0xF3AB, 0xF1FA, 0xF05D, 0xEED7, 0xED68, 0xEC12, 0xEAD6, 0xE9B5, 0xE8B0, 0xE7C8, 0xE6FC,
        0xE64F, 0xE5C0, 0xE54F, 0xE4FC, 0xE4C8, 0xE4B2, 0xE4BA, 0xE4DF, 0xE521, 0xE57F, 0xE5F9, 0xE68D, 0xE73B, 0xE801, 0xE8DE, 0xE9D1,
        0xEAD9, 0xEBF4, 0xED20, 0xEE5D, 0xEFA8, 0xF100, 0xF263, 0xF3D0, 0xF544, 0xF6BF, 0xF83E, 0xF9BF, 0xFB42, 0xFCC4, 0xFE43, 0xFFBE,
        0x0133, 0x02A2, 0x0408, 0x0564, 0x06B4, 0x07F8, 0x092E, 0x0A55, 0x0B6C, 0x0C73, 0x0D67, 0x0E48, 0x0F17, 0x0FD1, 0x1077, 0x1109,
        0x1185, 0x11EC, 0x123E, 0x127A, 0x12A1, 0x12B3, 0x12B1, 0x129A, 0x126F, 0x1230, 0x11DF, 0x117C, 0x1107, 0x1082, 0x0FED, 0x0F4A,
        0x0E98, 0x0DDA, 0x0D11, 0x0C3D, 0x0B5F, 0x0A79, 0x098C, 0x089A, 0x07A2, 0x06A7, 0x05AA, 0x04AB, 0x03AD, 0x02AF, 0x01B4, 0x00BC,
        0xFFC9, 0xFEDB, 0xFDF2, 0xFD11, 0xFC38, 0xFB68, 0xFAA1, 0xF9E5, 0xF934, 0xF88E, 0xF7F3, 0xF766, 0xF6E5, 0xF671, 0xF60A, 0xF5B1,
        0xF565, 0xF527, 0xF4F7, 0xF4D4, 0xF4BF, 0xF4B6, 0xF4BA, 0xF4CB, 0xF4E8, 0xF511, 0xF545, 0xF584, 0xF5CD, 0xF620, 0xF67B, 0xF6DF,
        0xF74B, 0xF7BE, 0xF837, 0xF8B5, 0xF938, 0xF9C0, 0xFA4A, 0xFAD8, 0xFB67, 0xFBF7, 0xFC88, 0xFD19, 0xFDA8, 0xFE36, 0xFEC2, 0xFF4B,
        0xFFD1, 0x0051, 0x00CE, 0x0147, 0x01BA, 0x0227, 0x028E, 0x02EF, 0x0349, 0x039C, 0x03E8, 0x042C, 0x046A, 0x04A0, 0x04CE, 0x04F5,
        0x0515, 0x052E, 0x053F, 0x0549, 0x054D, 0x0549, 0x0540, 0x0530, 0x051B, 0x0501, 0x04E1, 0x04BC, 0x0494, 0x0467, 0x0436, 0x0403,
        0x03CD, 0x0394, 0x035A, 0x031E, 0x02E0, 0x02A2, 0x0264, 0x0226, 0x01E8, 0x01AB, 0x016F, 0x0134, 0x00FB, 0x00C3, 0x008E, 0x005B,
        0x002B, 0xFFFF, 0xFFD4, 0xFFAD, 0xFF88, 0xFF67, 0xFF49, 0xFF2E, 0xFF16, 0xFF02, 0xFEF1, 0xFEE3, 0xFED8, 0xFED0, 0xFECB, 0xFEC8,
        0xFEC9, 0xFECB, 0xFED0, 0xFED6, 0xFEDF, 0xFEE9, 0xFEF5, 0xFF02, 0xFF10, 0xFF1F, 0xFF2E, 0xFF3E, 0xFF4E, 0xFF5E, 0xFF6E, 0xFF7E,
        0xFF8D, 0xFF9C, 0xFFAA, 0xFFB7, 0xFFC3, 0xFFCE, 0xFFD8, 0xFFE1, 0xFFE9, 0xFFF0, 0xFFF5, 0xFFF9, 0xFFFD, 0xFFFF, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0004, 0x0005, 0x0007, 0x0009, 0x000B, 0x000E, 0x0011,
        0x0014, 0x0017, 0x001B, 0x0020, 0x0024, 0x0029, 0x002E, 0x0033, 0x0038, 0x003D, 0x0043, 0x0048, 0x004E, 0x0053, 0x0058, 0x005D,
        0x0062, 0x0066, 0x006A, 0x006E, 0x0071, 0x0073, 0x0075, 0x0076, 0x0076, 0x0076, 0x0074, 0x0072, 0x006E, 0x0069, 0x0063, 0x005C,
        0x0054, 0x004B, 0x0040, 0x0034, 0x0027, 0x0018, 0x0009, 0xFFF9, 0xFFE6, 0xFFD3, 0xFFBE, 0xFFA8, 0xFF91, 0xFF79, 0xFF61, 0xFF47,
        0xFF2C, 0xFF11, 0xFEF6, 0xFED9, 0xFEBD, 0xFEA0, 0xFE84, 0xFE67, 0xFE4B, 0xFE2F, 0xFE14, 0xFDF9, 0xFDDF, 0xFDC6, 0xFDAF, 0xFD99,
        0xFD84, 0xFD71, 0xFD60, 0xFD51, 0xFD45, 0xFD3A, 0xFD32, 0xFD2D, 0xFD2B, 0xFD2B, 0xFD2F, 0xFD36, 0xFD40, 0xFD4D, 0xFD5E, 0xFD72,
        0xFD8A, 0xFDA5, 0xFDC4, 0xFDE7, 0xFE0D, 0xFE36, 0xFE63, 0xFE94, 0xFEC8, 0xFEFF, 0xFF3A, 0xFF77, 0xFFB7, 0xFFFA, 0x003F, 0x0087,
        0x00D1, 0x011C, 0x016A, 0x01B9, 0x0209, 0x025A, 0x02AB, 0x02FC, 0x034E, 0x039F, 0x03EF, 0x043E, 0x048B, 0x04D7, 0x0520, 0x0567,
        0x05AB, 0x05EC, 0x0629, 0x0662, 0x0697, 0x06C7, 0x06F2, 0x0718, 0x0738, 0x0753, 0x0767, 0x0775, 0x077C, 0x077D, 0x0776, 0x0768,
        0x0753, 0x0737, 0x0713, 0x06E7, 0x06B4, 0x0679, 0x0636, 0x05EC, 0x059A, 0x0541, 0x04E1, 0x047A, 0x040B, 0x0397, 0x031C, 0x029A,
        0x0214, 0x0187, 0x00F6, 0x0061, 0xFFC8, 0xFF2B, 0xFE8B, 0xFDE8, 0xFD43, 0xFC9C, 0xFBF5, 0xFB4E, 0xFAA6, 0xFA00, 0xF95B, 0xF8B9,
        0xF819, 0xF77D, 0xF6E5, 0xF652, 0xF5C4, 0xF53C, 0xF4BC, 0xF442, 0xF3D0, 0xF367, 0xF307, 0xF2B1, 0xF265, 0xF223, 0xF1ED, 0xF1C2,
        0xF1A3, 0xF190, 0xF18A, 0xF190, 0xF1A4, 0xF1C5, 0xF1F4, 0xF230, 0xF279, 0xF2D1, 0xF336, 0xF3A8, 0xF428, 0xF4B5, 0xF54E, 0xF5F5,
        0xF6A7, 0xF765, 0xF82F, 0xF904, 0xF9E2, 0xFACB, 0xFBBC, 0xFCB6, 0xFDB8, 0xFEC0, 0xFFCF, 0x00E1, 0x01F9, 0x0315, 0x0432, 0x0551,
        0x0671, 0x0790, 0x08AE, 0x09C9, 0x0AE0, 0x0BF3, 0x0D00, 0x0E06, 0x0F04, 0x0FF9, 0x10E5, 0x11C5, 0x129A, 0x1362, 0x141C, 0x14C8,
        0x1564, 0x15F0, 0x166B, 0x16D4, 0x172A, 0x176E, 0x179E, 0x17BA, 0x17C2, 0x17B5, 0x1793, 0x175B, 0x170E, 0x16AC, 0x1634, 0x15A6,
        0x1503, 0x144B, 0x137F, 0x129E, 0x11A9, 0x10A1, 0x0F87, 0x0E5A, 0x0D1C, 0x0BCE, 0x0A70, 0x0904, 0x078A, 0x0605, 0x0474, 0x02D9,
        0x0135, 0xFF8B, 0xFDDB, 0xFC26, 0xFA6E, 0xF8B4, 0xF6FA, 0xF542, 0xF38D, 0xF1DC, 0xF032, 0xEE8F, 0xECF6, 0xEB67, 0xE9E5, 0xE871,
        0xE70C, 0xE5B7, 0xE475, 0xE347, 0xE22E, 0xE12A, 0xE03E, 0xDF6B, 0xDEB1, 0xDE12, 0xDD8E, 0xDD26, 0xDCDB, 0xDCAE, 0xDC9F, 0xDCAF,
        0xDCDE, 0xDD2C, 0xDD99, 0xDE26, 0xDED2, 0xDF9D, 0xE087, 0xE190, 0xE2B6, 0xE3FA, 0xE55A, 0xE6D6, 0xE86D, 0xEA1E, 0xEBE6, 0xEDC7,
        0xEFBD, 0xF1C7, 0xF3E5, 0xF614, 0xF852, 0xFA9E, 0xFCF6, 0xFF59, 0x01C2, 0x0432, 0x06A7, 0x091D, 0x0B93, 0x0E06, 0x1075, 0x12DD,
        0x153D, 0x1791, 0x19D7, 0x1C0F, 0x1E34, 0x2046, 0x2242, 0x2427, 0x25F2, 0x27A1, 0x2933, 0x2AA6, 0x2BF8, 0x2D28, 0x2E34, 0x2F1C,
        0x2FDD, 0x3077, 0x30E9, 0x3132, 0x3151, 0x3145, 0x310F, 0x30AE, 0x3021, 0x2F6A, 0x2E87, 0x2D79, 0x2C41, 0x2ADF, 0x2955, 0x27A2,
        0x25C8, 0x23C8, 0x21A4, 0x1F5D, 0x1CF4, 0x1A6C, 0x17C5, 0x1503, 0x1227, 0x0F34, 0x0C2B, 0x0910, 0x05E4, 0x02AB, 0xFF68, 0xFC1B,
        0xF8C9, 0xF574, 0xF220, 0xEECE, 0xEB83, 0xE840, 0xE509, 0xE1E2, 0xDECC, 0xDBCA, 0xD8E0, 0xD610, 0xD35D, 0xD0C9, 0xCE58, 0xCC0B,
        0xC9E4, 0xC7E8, 0xC616, 0xC472, 0xC2FC, 0xC1B8, 0xC0A7, 0xBFC9, 0xBF20, 0xBEAE, 0xBE73, 0xBE70, 0xBEA5, 0xBF13, 0xBFBB, 0xC09B,
        0xC1B4, 0xC306, 0xC48F, 0xC64F, 0xC846, 0xCA71, 0xCCD0, 0xCF61, 0xD221, 0xD510, 0xD82B, 0xDB70, 0xDEDC, 0xE26D, 0xE620, 0xE9F3,
        0xEDE1, 0xF1E8, 0xF605, 0xFA34, 0xFE73, 0x02BB, 0x070C, 0x0B62, 0x0FB7, 0x140A, 0x1855, 0x1C95, 0x20C7, 0x24E5, 0x28EE, 0x2CDD,
        0x30AE, 0x345E, 0x37EA, 0x3B4D, 0x3E86, 0x418F, 0x4468, 0x470C, 0x4978, 0x4BAB, 0x4DA2, 0x4F5B, 0x50D3, 0x5208, 0x52FB, 0x53A7,
        0x540E, 0x542D, 0x5403, 0x5392, 0x52D7, 0x51D4, 0x5088, 0x4EF4, 0x4D19, 0x4AF7, 0x4890, 0x45E6, 0x42FA, 0x3FCE, 0x3C64, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC741, 0xC35B, 0xBFA9, 0xBC2D, 0xB8EB, 0xB5E6, 0xB31F, 0xB09A, 0xAE58, 0xAC5B, 0xAAA5, 0xA938, 0xA815, 0xA73C, 0xA6AE,
        0xA66D, 0xA677, 0xA6CD, 0xA770, 0xA85D, 0xA995, 0xAB16, 0xACDF, 0xAEEF, 0xB143, 0xB3DB, 0xB6B3, 0xB9C9, 0xBD1B, 0xC0A6, 0xC466,
        0xC859, 0xCC7C, 0xD0CA, 0xD540, 0xD9DA, 0xDE95, 0xE36D, 0xE85C, 0xED60, 0xF273, 0xF792, 0xFCB8, 0x01E0, 0x0707, 0x0C28, 0x113F,
        0x1648, 0x1B3D, 0x201B, 0x24DE, 0x2982, 0x2E03, 0x325C, 0x368B, 0x3A8B, 0x3E5A, 0x41F3, 0x4555, 0x487C, 0x4B65, 0x4E0E, 0x5075,
        0x5298, 0x5475, 0x560A, 0x5756, 0x5857, 0x590E, 0x5979, 0x5998, 0x596B, 0x58F2, 0x582E, 0x571F, 0x55C5, 0x5423, 0x523A, 0x500B,
        0x4D97, 0x4AE2, 0x47EE, 0x44BC, 0x4150, 0x3DAC, 0x39D4, 0x35CB, 0x3195, 0x2D34, 0x28AD, 0x2403, 0x1F3B, 0x1A58, 0x155F, 0x1053,
        0x0B3A, 0x0618, 0x00F0, 0xFBC8, 0xF6A3, 0xF186, 0xEC75, 0xE775, 0xE289, 0xDDB7, 0xD902, 0xD46D, 0xCFFE, 0xCBB8, 0xC79E, 0xC3B4,
        0xBFFD, 0xBC7C, 0xB935, 0xB62A, 0xB35D, 0xB0D2, 0xAE89, 0xAC86, 0xAACA, 0xA956, 0xA82C, 0xA74C, 0xA6B8, 0xA66F, 0xA673, 0xA6C2,
        0xA75E, 0xA844, 0xA975, 0xAAF0, 0xACB2, 0xAEBC, 0xB10A, 0xB39C, 0xB66E, 0xB97F, 0xBCCB, 0xC051, 0xC40D, 0xC7FB, 0xCC1A, 0xD064,
        0xD4D7, 0xD96E, 0xDE26, 0xE2FB, 0xE7E8, 0xECEA, 0xF1FC, 0xF71A, 0xFC40, 0x0168, 0x068F, 0x0BB1, 0x10C9, 0x15D3, 0x1ACB, 0x1FAB,
        0x2471, 0x2917, 0x2D9B, 0x31F8, 0x362B, 0x3A30, 0x3E03, 0x41A2, 0x4509, 0x4835, 0x4B24, 0x4DD3, 0x5040, 0x5269, 0x544C, 0x55E8,
        0x573A, 0x5843, 0x5900, 0x5972, 0x5998, 0x5972, 0x5900, 0x5843, 0x573A, 0x55E8, 0x544C, 0x5269, 0x5040, 0x4DD3, 0x4B24, 0x4835,
        0x4509, 0x41A2, 0x3E03, 0x3A30, 0x362B, 0x31F8, 0x2D9B, 0x2917, 0x2471, 0x1FAB, 0x1ACB, 0x15D3, 0x10C9, 0x0BB1, 0x068F, 0x0168,
        0xFC40, 0xF71A, 0xF1FC, 0xECEA, 0xE7E8, 0xE2FB, 0xDE26, 0xD96E, 0xD4D7, 0xD064, 0xCC1A, 0xC7FB, 0xC40D, 0xC051, 0xBCCB, 0xB97F,
        0xB66E, 0xB39C, 0xB10A, 0xAEBC, 0xACB2, 0xAAF0, 0xA975, 0xA844, 0xA75E, 0xA6C2, 0xA673, 0xA66F, 0xA6B8, 0xA74C, 0xA82C, 0xA956,
        0xAACA, 0xAC86, 0xAE89, 0xB0D2, 0xB35D, 0xB62A, 0xB935, 0xBC7C, 0xBFFD, 0xC3B4, 0xC79E, 0xCBB8, 0xCFFE, 0xD46D, 0xD902, 0xDDB7,
        0xE289, 0xE775, 0xEC75, 0xF186, 0xF6A3, 0xFBC8, 0x00F0, 0x0618, 0x0B3A, 0x1053, 0x155F, 0x1A58, 0x1F3B, 0x2403, 0x28AD, 0x2D34,
        0x3195, 0x35CB, 0x39D4, 0x3DAC, 0x4150, 0x44BC, 0x47EE, 0x4AE2, 0x4D97, 0x500B, 0x523A, 0x5423, 0x55C5, 0x571F, 0x582E, 0x58F2,
        0x596B, 0x5998, 0x5979, 0x590E, 0x5857, 0x5756, 0x560A, 0x5475, 0x5298, 0x5075, 0x4E0E, 0x4B65, 0x487C, 0x4555, 0x41F3, 0x3E5A,
        0x3A8B, 0x368B, 0x325C, 0x2E03, 0x2982, 0x24DE, 0x201B, 0x1B3D, 0x1648, 0x113F, 0x0C28, 0x0707, 0x01E0, 0xFCB8, 0xF792, 0xF273,
        0xED60, 0xE85C, 0xE36D, 0xDE95, 0xD9DA, 0xD540, 0xD0CA, 0xCC7C, 0xC859, 0xC466, 0xC0A6, 0xBD1B, 0xB9C9, 0xB6B3, 0xB3DB, 0xB143,
        0xAEEF, 0xACDF, 0xAB16, 0xA995, 0xA85D, 0xA770, 0xA6CD, 0xA677, 0xA66D, 0xA6AE, 0xA73C, 0xA815, 0xA938, 0xAAA5, 0xAC5B, 0xAE58,
        0xB09A, 0xB31F, 0xB5E6, 0xB8EB, 0xBC2D, 0xBFA9, 0xC35B, 0xC741, 0xCB57, 0xCF99, 0xD405, 0xD896, 0xDD48, 0xE218, 0xE701, 0xEC00,
        0xF10F, 0xF62C, 0xFB50, 0x0078, 0x05A0, 0x0AC3, 0x0FDD, 0x14EA, 0x19E5, 0x1ECA, 0x2395, 0x2841, 0x2CCC, 0x3130, 0x356B, 0x3978,
        0x3D55, 0x40FD, 0x446F, 0x47A6, 0x4AA0, 0x4D5B, 0x4FD4, 0x520A, 0x53FA, 0x55A2, 0x5702, 0x5818, 0x58E4, 0x5963, 0x5997, 0x597F,
        0x591B, 0x586B, 0x5770, 0x562B, 0x549D, 0x52C6, 0x50AA, 0x4E49, 0x4BA6, 0x48C2, 0x45A1, 0x4244, 0x3EB0, 0x3AE6, 0x36EA, 0x32BF,
        0x2E69, 0x29EC, 0x254C, 0x208B, 0x1BAF, 0x16BC, 0x11B5, 0x0C9F, 0x077F, 0x0258, 0xFD30, 0xF80A, 0xF2EA, 0xEDD5, 0xE8D0, 0xE3DE,
        0xDF05, 0xDA47, 0xD5AA, 0xD130, 0xCCDE, 0xC8B8, 0xC4C0, 0xC0FB, 0xBD6B, 0xBA14, 0xB6F8, 0xB41A, 0xB17D, 0xAF22, 0xAD0C, 0xAB3C,
        0xA9B5, 0xA876, 0xA782, 0xA6D9, 0xA67C, 0xA66A, 0xA6A5, 0xA72C, 0xA7FE, 0xA91B, 0xAA81, 0xAC30, 0xAE27, 0xB062, 0xB2E2, 0xB5A3,
        0xB8A3, 0xBBDF, 0xBF56, 0xC303, 0xC6E4, 0xCAF6, 0xCF34, 0xD39C, 0xD82A, 0xDCDA, 0xE1A7, 0xE68E, 0xEB8B, 0xF099, 0xF5B4, 0xFAD8,
        0x0000, 0x0528, 0x0A4C, 0x0F67, 0x1475, 0x1972, 0x1E59, 0x2326, 0x27D6, 0x2C64, 0x30CC, 0x350A, 0x391C, 0x3CFD, 0x40AA, 0x4421,
        0x475D, 0x4A5D, 0x4D1E, 0x4F9E, 0x51D9, 0x53D0, 0x557F, 0x56E5, 0x5802, 0x58D4, 0x595B, 0x5996, 0x5984, 0x5927, 0x587E, 0x578A,
        0x564B, 0x54C4, 0x52F4, 0x50DE, 0x4E83, 0x4BE6, 0x4908, 0x45EC, 0x4295, 0x3F05, 0x3B40, 0x3748, 0x3322, 0x2ED0, 0x2A56, 0x25B9,
        0x20FB, 0x1C22, 0x1730, 0x122B, 0x0D16, 0x07F6, 0x02D0, 0xFDA8, 0xF881, 0xF361, 0xEE4B, 0xE944, 0xE451, 0xDF75, 0xDAB4, 0xD614,
        0xD197, 0xCD41, 0xC916, 0xC51A, 0xC150, 0xBDBC, 0xBA5F, 0xB73E, 0xB45A, 0xB1B7, 0xAF56, 0xAD3A, 0xAB63, 0xA9D5, 0xA890, 0xA795,
        0xA6E5, 0xA681, 0xA669, 0xA69D, 0xA71C, 0xA7E8, 0xA8FE, 0xAA5E, 0xAC06, 0xADF6, 0xB02C, 0xB2A5, 0xB560, 0xB85A, 0xBB91, 0xBF03,
        0xC2AB, 0xC688, 0xCA95, 0xCED0, 0xD334, 0xD7BF, 0xDC6B, 0xE136, 0xE61B, 0xEB16, 0xF023, 0xF53D, 0xFA60, 0xFF88, 0x04B0, 0x09D4,
        0x0EF1, 0x1400, 0x18FF, 0x1DE8, 0x22B8, 0x276A, 0x2BFB, 0x3067, 0x34A9, 0x38BF, 0x3CA5, 0x4057, 0x43D3, 0x4715, 0x4A1A, 0x4CE1,
        0x4F66, 0x51A8, 0x53A5, 0x555B, 0x56C8, 0x57EB, 0x58C4, 0x5952, 0x5993, 0x5989, 0x5933, 0x5890, 0x57A3, 0x566B, 0x54EA, 0x5321,
        0x5111, 0x4EBD, 0x4C25, 0x494D, 0x4637, 0x42E5, 0x3F5A, 0x3B9A, 0x37A7, 0x3384, 0x2F36, 0x2AC0, 0x2626, 0x216B, 0x1C93, 0x17A4,
        0x12A0, 0x0D8D, 0x086E, 0x0348, 0xFE20, 0xF8F9, 0xF3D8, 0xEEC1, 0xE9B8, 0xE4C3, 0xDFE5, 0xDB22, 0xD67E, 0xD1FD, 0xCDA4, 0xC975,
        0xC575, 0xC1A6, 0xBE0D, 0xBAAB, 0xB784, 0xB49B, 0xB1F2, 0xAF8B, 0xAD68, 0xAB8B, 0xA9F6, 0xA8AA, 0xA7A9, 0xA6F2, 0xA687, 0xA668,
        0xA695, 0xA70E, 0xA7D2, 0xA8E1, 0xAA3B, 0xABDD, 0xADC6, 0xAFF5, 0xB269, 0xB51E, 0xB812, 0xBB44, 0xBEB0, 0xC254, 0xC62C, 0xCA35,
        0xCE6B, 0xD2CC, 0xD753, 0xDBFD, 0xE0C5, 0xE5A8, 0xEAA1, 0xEFAD, 0xF4C6, 0xF9E8, 0xFF10, 0x0438, 0x095D, 0x0E7A, 0x138B, 0x188B,
        0x1D77, 0x2249, 0x26FE, 0x2B93, 0x3002, 0x3448, 0x3862, 0x3C4C, 0x4003, 0x4384, 0x46CB, 0x49D6, 0x4CA3, 0x4F2E, 0x5177, 0x537A,
        0x5536, 0x56AA, 0x57D4, 0x58B4, 0x5948, 0x5991, 0x598D, 0x593E, 0x58A2, 0x57BC, 0x568B, 0x5510, 0x534E, 0x5144, 0x4EF6, 0x4C64,
        0x4992, 0x4681, 0x4335, 0x3FAF, 0x3BF3, 0x3805, 0x33E6, 0x2F9C, 0x2B29, 0x2692, 0x21DA, 0x1D05, 0x1818, 0x1316, 0x0E04, 0x08E6,
        0x03C0, 0xFE98, 0xF971, 0xF44F, 0xEF37, 0xEA2D, 0xE535, 0xE055, 0xDB8F, 0xD6E9, 0xD265, 0xCE08, 0xC9D5, 0xC5D0, 0xC1FD, 0xBE5E,
        0xBAF7, 0xB7CB, 0xB4DC, 0xB22D, 0xAFC0, 0xAD97, 0xABB4, 0xAA18, 0xA8C6, 0xA7BD, 0xA700, 0xA68E, 0xA668, 0xA68E, 0xA700, 0xA7BD,
        0xA8C6, 0xAA18, 0xABB4, 0xAD97, 0xAFC0, 0xB22D, 0xB4DC, 0xB7CB, 0xBAF7, 0xBE5E, 0xC1FD, 0xC5D0, 0xC9D5, 0xCE08, 0xD265, 0xD6E9,
        0xDB8F, 0xE055, 0xE535, 0xEA2D, 0xEF37, 0xF44F, 0xF971, 0xFE98, 0x03C0, 0x08E6, 0x0E04, 0x1316, 0x1818, 0x1D05, 0x21DA, 0x2692,
        0x2B29, 0x2F9C, 0x33E6, 0x3805, 0x3BF3, 0x3FAF, 0x4335, 0x4681, 0x4992, 0x4C64, 0x4EF6, 0x5144, 0x534E, 0x5510, 0x568B, 0x57BC,
        0x58A2, 0x593E, 0x598D, 0x5991, 0x5948, 0x58B4, 0x57D4, 0x56AA, 0x5536, 0x537A, 0x5177, 0x4F2E, 0x4CA3, 0x49D6, 0x46CB, 0x4384,
        0x4003, 0x3C4C, 0x3862, 0x3448, 0x3002, 0x2B93, 0x26FE, 0x2249, 0x1D77, 0x188B, 0x138B, 0x0E7A, 0x095D, 0x0438, 0xFF10, 0xF9E8,
        0xF4C6, 0xEFAD, 0xEAA1, 0xE5A8, 0xE0C5, 0xDBFD, 0xD753, 0xD2CC, 0xCE6B, 0xCA35, 0xC62C, 0xC254, 0xBEB0, 0xBB44, 0xB812, 0xB51E,
        0xB269, 0xAFF5, 0xADC6, 0xABDD, 0xAA3B, 0xA8E1, 0xA7D2, 0xA70E, 0xA695, 0xA668, 0xA687, 0xA6F2, 0xA7A9, 0xA8AA, 0xA9F6, 0xAB8B,
        0xAD68, 0xAF8B, 0xB1F2, 0xB49B, 0xB784, 0xBAAB, 0xBE0D, 0xC1A6, 0xC575, 0xC975, 0xCDA4, 0xD1FD, 0xD67E, 0xDB22, 0xDFE5, 0xE4C3,
        0xE9B8, 0xEEC1, 0xF3D8, 0xF8F9, 0xFE20, 0x0348, 0x086E, 0x0D8D, 0x12A0, 0x17A4, 0x1C93, 0x216B, 0x2626, 0x2AC0, 0x2F36, 0x3384,
        0x37A7, 0x3B9A, 0x3F5A, 0x42E5, 0x4637, 0x494D, 0x4C25, 0x4EBD, 0x5111, 0x5321, 0x54EA, 0x566B, 0x57A3, 0x5890, 0x5933, 0x5989,
        0x5993, 0x5952, 0x58C4, 0x57EB, 0x56C8, 0x555B, 0x53A5, 0x51A8, 0x4F66, 0x4CE1, 0x4A1A, 0x4715, 0x43D3, 0x4057, 0x3CA5, 0x38BF,
        0x34A9, 0x3067, 0x2BFB, 0x276A, 0x22B8, 0x1DE8, 0x18FF, 0x1400, 0x0EF1, 0x09D4, 0x04B0, 0xFF88, 0xFA60, 0xF53D, 0xF023, 0xEB16,
        0xE61B, 0xE136, 0xDC6B, 0xD7BF, 0xD334, 0xCED0, 0xCA95, 0xC688, 0xC2AB, 0xBF03, 0xBB91, 0xB85A, 0xB560, 0xB2A5, 0xB02C, 0xADF6,
        0xAC06, 0xAA5E, 0xA8FE, 0xA7E8, 0xA71C, 0xA69D, 0xA669, 0xA681, 0xA6E5, 0xA795, 0xA890, 0xA9D5, 0xAB63, 0xAD3A, 0xAF56, 0xB1B7,
        0xB45A, 0xB73E, 0xBA5F, 0xBDBC, 0xC150, 0xC51A, 0xC916, 0xCD41, 0xD197, 0xD614, 0xDAB4, 0xDF75, 0xE451, 0xE944, 0xEE4B, 0xF361,
        0xF881, 0xFDA8, 0x02D0, 0x07F6, 0x0D16, 0x122B, 0x1730, 0x1C22, 0x20FB, 0x25B9, 0x2A56, 0x2ED0, 0x3322, 0x3748, 0x3B40, 0x3F05,
        0x4295, 0x45EC, 0x4908, 0x4BE6, 0x4E83, 0x50DE, 0x52F4, 0x54C4, 0x564B, 0x578A, 0x587E, 0x5927, 0x5984, 0x5996, 0x595B, 0x58D4,
        0x5802, 0x56E5, 0x557F, 0x53D0, 0x51D9, 0x4F9E, 0x4D1E, 0x4A5D, 0x475D, 0x4421, 0x40AA, 0x3CFD, 0x391C, 0x350A, 0x30CC, 0x2C64,
        0x27D6, 0x2326, 0x1E59, 0x1972, 0x1475, 0x0F67, 0x0A4C, 0x0528, 0x0000, 0xFAD8, 0xF5B4, 0xF099, 0xEB8B, 0xE68E, 0xE1A7, 0xDCDA,
        0xD82A, 0xD39C, 0xCF34, 0xCAF6, 0xC6E4, 0xC303, 0xBF56, 0xBBDF, 0xB8A3, 0xB5A3, 0xB2E2, 0xB062, 0xAE27, 0xAC30, 0xAA81, 0xA91B,
        0xA7FE, 0xA72C, 0xA6A5, 0xA66A, 0xA67C, 0xA6D9, 0xA782, 0xA876, 0xA9B5, 0xAB3C, 0xAD0C, 0xAF22, 0xB17D, 0xB41A, 0xB6F8, 0xBA14,
        0xBD6B, 0xC0FB, 0xC4C0, 0xC8B8, 0xCCDE, 0xD130, 0xD5AA, 0xDA47, 0xDF05, 0xE3DE, 0xE8D0, 0xEDD5, 0xF2EA, 0xF80A, 0xFD30, 0x0258,
        0x077F, 0x0C9F, 0x11B5, 0x16BC, 0x1BAF, 0x208B, 0x254C, 0x29EC, 0x2E69, 0x32BF, 0x36EA, 0x3AE6, 0x3EB0, 0x4244, 0x45A1, 0x48C2,
        0x4BA6, 0x4E49, 0x50AA, 0x52C6, 0x549D, 0x562B, 0x5770, 0x586B, 0x591B, 0x597F, 0x5997, 0x5963, 0x58E4, 0x5818, 0x5702, 0x55A2,
        0x53FA, 0x520A, 0x4FD4, 0x4D5B, 0x4AA0, 0x47A6, 0x446F, 0x40FD, 0x3D55, 0x3978, 0x356B, 0x3130, 0x2CCC, 0x2841, 0x2395, 0x1ECA,
        0x19E5, 0x14EA, 0x0FDD, 0x0AC3, 0x05A0, 0x0078, 0xFB50, 0xF62C, 0xF10F, 0xEC00, 0xE701, 0xE218, 0xDD48, 0xD896, 0xD405, 0xCF99,
        0xCB57, 0xC76E, 0xC3BC, 0xC043, 0xBD06, 0xBA08, 0xB749, 0xB4CD, 0xB295, 0xB0A2, 0xAEF6, 0xAD92, 0xAC76, 0xABA3, 0xAB19, 0xAAD8,
        0xAAE0, 0xAB30, 0xABC8, 0xACA7, 0xADCB, 0xAF33, 0xB0DE, 0xB2C9, 0xB4F3, 0xB758, 0xB9F8, 0xBCCF, 0xBFDA, 0xC316, 0xC681, 0xCA17,
        0xCDD5, 0xD1B7, 0xD5BA, 0xD9D9, 0xDE12, 0xE261, 0xE6C2, 0xEB30, 0xEFA8, 0xF427, 0xF8A8, 0xFD27, 0x019F, 0x0610, 0x0A73, 0x0EC6,
        0x1304, 0x172B, 0x1B37, 0x1F24, 0x22F0, 0x2697, 0x2A16, 0x2D6C, 0x3095, 0x338F, 0x3658, 0x38ED, 0x3B4D, 0x3D76, 0x3F67, 0x411E,
        0x429B, 0x43DD, 0x44E2, 0x45AB, 0x4637, 0x4686, 0x4698, 0x466E, 0x4609, 0x4569, 0x448E, 0x437B, 0x4231, 0x40B0, 0x3EFC, 0x3D15,
        0x3AFD, 0x38B7, 0x3646, 0x33AB, 0x30E8, 0x2E02, 0x2AFA, 0x27D3, 0x2491, 0x2135, 0x1DC4, 0x1A41, 0x16AE, 0x130E, 0x0F66, 0x0BB8,
        0x0807, 0x0457, 0x00AA, 0xFD05, 0xF969, 0xF5DA, 0xF25B, 0xEEEE, 0xEB97, 0xE859, 0xE535, 0xE22E, 0xDF47, 0xDC82, 0xD9E1, 0xD765,
        0xD512, 0xD2E8, 0xD0E9, 0xCF16, 0xCD71, 0xCBFB, 0xCAB4, 0xC99D, 0xC8B6, 0xC801, 0xC77D, 0xC72B, 0xC709, 0xC719, 0xC759, 0xC7C8,
        0xC867, 0xC934, 0xCA2E, 0xCB53, 0xCCA3, 0xCE1C, 0xCFBC, 0xD182, 0xD36C, 0xD577, 0xD7A2, 0xD9EB, 0xDC4F, 0xDECC, 0xE160, 0xE408,
        0xE6C2, 0xE98B, 0xEC61, 0xEF41, 0xF229, 0xF516, 0xF806, 0xFAF6, 0xFDE3, 0x00CA, 0x03AA, 0x0681, 0x094B, 0x0C07, 0x0EB2, 0x114B,
        0x13CE, 0x163A, 0x188D, 0x1AC6, 0x1CE3, 0x1EE2, 0x20C1, 0x2280, 0x241D, 0x2598, 0x26EE, 0x2820, 0x292D, 0x2A14, 0x2AD5, 0x2B6F,
        0x2BE2, 0x2C2F, 0x2C55, 0x2C55, 0x2C2F, 0x2BE4, 0x2B74, 0x2AE0, 0x2A28, 0x294F, 0x2854, 0x2739, 0x2600, 0x24A9, 0x2337, 0x21AA,
        0x2004, 0x1E47, 0x1C76, 0x1A90, 0x1899, 0x1692, 0x147E, 0x125D, 0x1033, 0x0E00, 0x0BC8, 0x098B, 0x074D, 0x050F, 0x02D2, 0x009A,
        0xFE68, 0xFC3C, 0xFA1A, 0xF804, 0xF5FA, 0xF3FE, 0xF212, 0xF038, 0xEE71, 0xECBE, 0xEB20, 0xE999, 0xE82A, 0xE6D4, 0xE597, 0xE474,
        0xE36D, 0xE281, 0xE1B1, 0xE0FE, 0xE067, 0xDFED, 0xDF91, 0xDF51, 0xDF2E, 0xDF28, 0xDF3E, 0xDF70, 0xDFBE, 0xE026, 0xE0A8, 0xE144,
        0xE1F8, 0xE2C4, 0xE3A6, 0xE49E, 0xE5AB, 0xE6CA, 0xE7FC, 0xE93E, 0xEA90, 0xEBF0, 0xED5D, 0xEED5, 0xF057, 0xF1E1, 0xF373, 0xF509,
        0xF6A4, 0xF842, 0xF9E0, 0xFB7F, 0xFD1B, 0xFEB5, 0x0049, 0x01D8, 0x0360, 0x04E0, 0x0656, 0x07C1, 0x0921, 0x0A74, 0x0BB9, 0x0CEF,
        0x0E15, 0x0F2C, 0x1031, 0x1124, 0x1205, 0x12D2, 0x138D, 0x1434, 0x14C7, 0x1545, 0x15B0, 0x1605, 0x1647, 0x1674, 0x168D, 0x1692,
        0x1683, 0x1662, 0x162D, 0x15E5, 0x158C, 0x1522, 0x14A6, 0x141B, 0x1381, 0x12D8, 0x1221, 0x115E, 0x108F, 0x0FB4, 0x0ED0, 0x0DE3,
        0x0CED, 0x0BF1, 0x0AEE, 0x09E6, 0x08DA, 0x07CB, 0x06BA, 0x05A8, 0x0496, 0x0384, 0x0275, 0x0168, 0x005F, 0xFF5B, 0xFE5C, 0xFD63,
        0xFC70, 0xFB86, 0xFAA4, 0xF9CA, 0xF8FB, 0xF835, 0xF77B, 0xF6CB, 0xF627, 0xF58F, 0xF503, 0xF483, 0xF410, 0xF3AB, 0xF352, 0xF306,
        0xF2C7, 0xF295, 0xF271, 0xF259, 0xF24D, 0xF24E, 0xF25C, 0xF275, 0xF299, 0xF2C9, 0xF304, 0xF348, 0xF397, 0xF3EF, 0xF450, 0xF4B9,
        0xF529, 0xF5A1, 0xF620, 0xF6A4, 0xF72D, 0xF7BB, 0xF84D, 0xF8E3, 0xF97B, 0xFA15, 0xFAB1, 0xFB4E, 0xFBEB, 0xFC88, 0xFD23, 0xFDBE,
        0xFE56, 0xFEEC, 0xFF7E, 0x000C, 0x0098, 0x011E, 0x01A0, 0x021D, 0x0295, 0x0306, 0x0371, 0x03D7, 0x0435, 0x048D, 0x04DE, 0x0528,
        0x056A, 0x05A6, 0x05DA, 0x0607, 0x062D, 0x064C, 0x0664, 0x0675, 0x0680, 0x0683, 0x0681, 0x0678, 0x0669, 0x0654, 0x063A, 0x061B,
        0x05F7, 0x05CF, 0x05A2, 0x0572, 0x053E, 0x0506, 0x04CC, 0x048F, 0x0451, 0x0410, 0x03CE, 0x038B, 0x0347, 0x0303, 0x02BE, 0x027A,
        0x0236, 0x01F3, 0x01B1, 0x0171, 0x0132, 0x00F5, 0x00BA, 0x0081, 0x004A, 0x0016, 0xFFE6, 0xFFB8, 0xFF8C, 0xFF64, 0xFF3E, 0xFF1C,
        0xFEFD, 0xFEE1, 0xFEC8, 0xFEB3, 0xFEA0, 0xFE91, 0xFE85, 0xFE7B, 0xFE74, 0xFE71, 0xFE6F, 0xFE70, 0xFE74, 0xFE79, 0xFE80, 0xFE8A,
        0xFE95, 0xFEA1, 0xFEAF, 0xFEBE, 0xFECE, 0xFEDE, 0xFEF0, 0xFF01, 0xFF13, 0xFF26, 0xFF38, 0xFF49, 0xFF5B, 0xFF6C, 0xFF7C, 0xFF8C,
        0xFF9B, 0xFFA9, 0xFFB6, 0xFFC3, 0xFFCE, 0xFFD8, 0xFFE0, 0xFFE8, 0xFFEE, 0xFFF4, 0xFFF8, 0xFFFC, 0xFFFE, 0xFFFF, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0003, 0x0004, 0x0005, 0x0007, 0x0009, 0x000C, 0x000E, 0x0010, 0x0013, 0x0015,
        0x0017, 0x001A, 0x001B, 0x001D, 0x001D, 0x001E, 0x001D, 0x001C, 0x001A, 0x0017, 0x0013, 0x000F, 0x0009, 0x0002, 0xFFFB, 0xFFF1,
        0xFFE7, 0xFFDC, 0xFFD0, 0xFFC3, 0xFFB6, 0xFFA8, 0xFF99, 0xFF8A, 0xFF7C, 0xFF6D, 0xFF5F, 0xFF51, 0xFF44, 0xFF38, 0xFF2D, 0xFF24,
        0xFF1C, 0xFF17, 0xFF14, 0xFF13, 0xFF14, 0xFF18, 0xFF20, 0xFF2A, 0xFF37, 0xFF47, 0xFF5B, 0xFF71, 0xFF8B, 0xFFA8, 0xFFC7, 0xFFE9,
        0x000D, 0x0034, 0x005D, 0x0087, 0x00B3, 0x00E0, 0x010D, 0x013A, 0x0166, 0x0192, 0x01BC, 0x01E4, 0x020A, 0x022C, 0x024C, 0x0267,
        0x027E, 0x028F, 0x029C, 0x02A3, 0x02A3, 0x029E, 0x0291, 0x027E, 0x0265, 0x0244, 0x021C, 0x01EE, 0x01B9, 0x017D, 0x013B, 0x00F4,
        0x00A7, 0x0055, 0x0000, 0xFFA7, 0xFF4B, 0xFEEC, 0xFE8C, 0xFE2C, 0xFDCD, 0xFD6E, 0xFD12, 0xFCB9, 0xFC65, 0xFC15, 0xFBCC, 0xFB8A,
        0xFB4F, 0xFB1D, 0xFAF5, 0xFAD7, 0xFAC3, 0xFABB, 0xFABF, 0xFACE, 0xFAEB, 0xFB13, 0xFB49, 0xFB8B, 0xFBD9, 0xFC33, 0xFC99, 0xFD0A,
        0xFD85, 0xFE09, 0xFE97, 0xFF2C, 0xFFC7, 0x0067, 0x010C, 0x01B3, 0x025C, 0x0304, 0x03AA, 0x044D, 0x04EC, 0x0583, 0x0613, 0x0699,
        0x0714, 0x0783, 0x07E4, 0x0836, 0x0878, 0x08A8, 0x08C7, 0x08D3, 0x08CB, 0x08B0, 0x0880, 0x083C, 0x07E4, 0x0778, 0x06F9, 0x0667,
        0x05C3, 0x050E, 0x0449, 0x0376, 0x0296, 0x01AA, 0x00B5, 0xFFB9, 0xFEB7, 0xFDB2, 0xFCAB, 0xFBA6, 0xFAA4, 0xF9A8, 0xF8B4, 0xF7CA,
        0xF6ED, 0xF620, 0xF563, 0xF4BA, 0xF425, 0xF3A8, 0xF343, 0xF2F8, 0xF2C8, 0xF2B4, 0xF2BD, 0xF2E4, 0xF328, 0xF38A, 0xF40A, 0xF4A7,
        0xF560, 0xF635, 0xF723, 0xF82A, 0xF948, 0xFA7A, 0xFBBF, 0xFD13, 0xFE75, 0xFFE2, 0x0155, 0x02CE, 0x0448, 0x05C0, 0x0733, 0x089E,
        0x09FC, 0x0B4C, 0x0C89, 0x0DB0, 0x0EC0, 0x0FB4, 0x108A, 0x1140, 0x11D4, 0x1244, 0x128D, 0x12AF, 0x12A9, 0x127A, 0x1222, 0x11A0,
        0x10F5, 0x1022, 0x0F28, 0x0E09, 0x0CC5, 0x0B60, 0x09DC, 0x083C, 0x0682, 0x04B2, 0x02D0, 0x00DF, 0xFEE5, 0xFCE4, 0xFAE1, 0xF8E0,
        0xF6E7, 0xF4F8, 0xF31A, 0xF14F, 0xEF9D, 0xEE08, 0xEC93, 0xEB42, 0xEA19, 0xE91C, 0xE84B, 0xE7AC, 0xE73E, 0xE705, 0xE702, 0xE735,
        0xE79F, 0xE83F, 0xE916, 0xEA22, 0xEB62, 0xECD4, 0xEE75, 0xF043, 0xF23A, 0xF457, 0xF695, 0xF8F1, 0xFB65, 0xFDED, 0x0081, 0x0320,
        0x05C2, 0x0861, 0x0AF8, 0x0D81, 0x0FF6, 0x1251, 0x148E, 0x16A6, 0x1894, 0x1A54, 0x1BE2, 0x1D38, 0x1E54, 0x1F32, 0x1FCF, 0x202A,
        0x2040, 0x2010, 0x1F9A, 0x1EDD, 0x1DDB, 0x1C95, 0x1B0C, 0x1942, 0x173C, 0x14FD, 0x1288, 0x0FE2, 0x0D10, 0x0A19, 0x0702, 0x03D0,
        0x008C, 0xFD3C, 0xF9E7, 0xF693, 0xF348, 0xF00E, 0xECEC, 0xE9E9, 0xE70B, 0xE45B, 0xE1DD, 0xDF99, 0xDD93, 0xDBD2, 0xDA59, 0xD92D,
        0xD851, 0xD7C9, 0xD796, 0xD7BA, 0xD835, 0xD909, 0xDA33, 0xDBB3, 0xDD87, 0xDFAA, 0xE21B, 0xE4D4, 0xE7D0, 0xEB0A, 0xEE7B, 0xF21D,
        0xF5E7, 0xF9D4, 0xFDDA, 0x01F0, 0x060E, 0x0A2D, 0x0E42, 0x1244, 0x162A, 0x19ED, 0x1D82, 0x20E3, 0x2406, 0x26E5, 0x2977, 0x2BB8,
        0x2DA1, 0x2F2D, 0x3057, 0x311C, 0x3179, 0x316C, 0x30F4, 0x3010, 0x2EC3, 0x2D0C, 0x2AEF, 0x2870, 0x2592, 0x225A, 0x1ECF, 0x1AF8,
        0x16DB, 0x1282, 0x0DF4, 0x093C, 0x0463, 0xFF73, 0xFA76, 0xF578, 0xF082, 0xEBA1, 0xE6DE, 0xE244, 0xDDDF, 0xD9B7, 0xD5D6, 0xD246,
        0xCF10, 0xCC3A, 0xC9CD, 0xC7CE, 0xC643, 0xC531, 0xC49C, 0xC484, 0xC4EE, 0xC5D7, 0xC741, 0xC929, 0xCB8C, 0xCE67, 0xD1B4, 0xD56E,
        0xD98D, 0xDE0A, 0xE2DC, 0xE7F9, 0xED57, 0xF2EB, 0xF8A9, 0xFE86, 0x0473, 0x0A67, 0x1054, 0x162C, 0x1BE3, 0x216C, 0x26BB, 0x2BC3,
        0x307A, 0x34D3, 0x38C5, 0x3C47, 0x3F4F, 0x41D5, 0x43D4, 0x4546, 0x4626, 0x4670, 0x4623, 0x453E, 0x43C2, 0x41B0, 0x3F0B, 0x3BD8,
        0x381C, 0x33DE, 0x2F27, 0x29FE, 0x246F, 0x1E84, 0x184A, 0x11CC, 0x0B19, 0x043E, 0xFD4B, 0xF64D, 0xEF53, 0xE86D, 0xE1AA, 0xDB19,
        0xD4C8, 0xCEC6, 0xC921, 0xC3E4, 0xBF1E, 0xBAD8, 0xB71E, 0xB3F8, 0xB16F, 0xAF8A, 0xAE4E, 0xADBF, 0xADE0, 0xAEB2, 0xB036, 0xB269,
        0xB548, 0xB8CE, 0xBCF5, 0xC1B6, 0xC708, 0xCCE1, 0xD334, 0xD9F5, 0xE118, 0xE88C, 0xF043, 0xF82D, 0x0038, 0x0854, 0x1071, 0x187B,
        0x203F, 0x27BF, 0x2EE9, 0x35AF, 0x3C02, 0x41D5, 0x471B, 0x4BC9, 0x4FD5, 0x5336, 0x55E6, 0x57DD, 0x5919, 0x5996, 0x5954, 0x5852,
        0x5694, 0x541D, 0x50F1, 0x4D19, 0x489C, 0x4383, 0x3DDA, 0x37AD, 0x3109, 0x29FB, 0x2295, 0x1AE4, 0x12F9, 0x0AE6, 0x02BC, 0xFA8D,
        0xF269, 0xEA61, 0xE288, 0xDAEE, 0xD3A3, 0xCCB7, 0xC639, 0xC036, 0xBABC, 0xB5D6, 0xB18E, 0xADEE, 0xAAFE, 0xA8C3, 0xA743, 0xA681,
        0xA67E, 0xA73B, 0xA8B5, 0xAAEA, 0xADD5, 0xB170, 0xB5B3, 0xBA94, 0xC00A, 0xC609, 0xCC84, 0xD36D, 0xDAB5, 0xE24D, 0xEA25, 0xF22B,
        0xFA4F, 0x027E, 0x0AA9, 0x12BD, 0x1AA8, 0x225B, 0x29C5, 0x30D5, 0x377C, 0x3DAD, 0x435A, 0x4877, 0x4CF9, 0x50D7, 0x5407, 0x5684,
        0x5848, 0x594F, 0x5997, 0x591F, 0x57E9, 0x55F7, 0x534D, 0x4FF1, 0x4BEA, 0x4741, 0x41FF, 0x3C30, 0x35E1, 0x2F1E, 0x27F6, 0x2079,
        0x18B7, 0x10BF, 0x08A4, 0x0077, 0xF849, 0xF02B, 0xE82F, 0xE065, 0xD8DF, 0xD1AD, 0xCADE, 0xC481, 0xBEA3, 0xB951, 0xB495, 0xB07B,
        0xAD0C, 0xAA4D, 0xA846, 0xA6FA, 0xA66D, 0xA69F, 0xA791, 0xA93F, 0xABA7, 0xAEC4, 0xB28E, 0xB6FE, 0xBC0A, 0xC1A7, 0xC7CA, 0xCE64,
        0xD569, 0xDCC9, 0xE475, 0xEC5B, 0xF46B, 0xFC94, 0x04C3, 0x0CE9, 0x14F4, 0x1CD1, 0x2472, 0x2BC4, 0x32B8, 0x3940, 0x3F4E, 0x44D4,
        0x49C7, 0x4E1C, 0x51CB, 0x54CA, 0x5714, 0x58A4, 0x5976, 0x5989, 0x58DC, 0x5772, 0x554C, 0x5270, 0x4EE4, 0x4AAF, 0x45DA, 0x4070,
        0x3A7C, 0x340B, 0x2D2B, 0x25EA, 0x1E58, 0x1686, 0x0E83, 0x0661, 0xFE32, 0xF606, 0xEDF0, 0xE600, 0xDE48, 0xD6D7, 0xCFBF, 0xC90E,
        0xC2D3, 0xBD1A, 0xB7F1, 0xB362, 0xAF76, 0xAC37, 0xA9AA, 0xA7D7, 0xA6C0, 0xA668, 0xA6CF, 0xA7F5, 0xA9D8, 0xAC73, 0xAFC0, 0xB3B9,
        0xB855, 0xBD8A, 0xC34E, 0xC993, 0xD04D, 0xD76D, 0xDEE3, 0xE6A0, 0xEE94, 0xF6AD, 0xFED9, 0x0708, 0x0F28, 0x1728, 0x1EF6, 0x2682,
        0x2DBC, 0x3493, 0x3AFB, 0x40E4, 0x4643, 0x4B0B, 0x4F33, 0x52B1, 0x557F, 0x5796, 0x58F1, 0x598F, 0x596C, 0x588B, 0x56EC, 0x5493,
        0x5186, 0x4DCA, 0x4968, 0x4468, 0x3ED7, 0x38BF, 0x322E, 0x2B31, 0x23D8, 0x1C33, 0x1451, 0x0C43, 0x041C, 0xFBED, 0xF3C5, 0xEBB7,
        0xE3D5, 0xDC30, 0xD4D6, 0xCDD9, 0xC748, 0xC12F, 0xBB9D, 0xB69D, 0xB23A, 0xAE7E, 0xAB70, 0xA916, 0xA776, 0xA694, 0xA671, 0xA70E,
        0xA868, 0xAA7F, 0xAD4B, 0xB0C9, 0xB4F0, 0xB9B8, 0xBF16, 0xC4FF, 0xCB66, 0xD23D, 0xD976, 0xE102, 0xE8D0, 0xF0D0, 0xF8F0, 0x011E,
        0x094B, 0x1164, 0x1958, 0x2115, 0x288C, 0x2FAC, 0x3666, 0x3CAC, 0x4270, 0x47A6, 0x4C43, 0x503C, 0x538A, 0x5626, 0x5809, 0x5930,
        0x5998, 0x5941, 0x582B, 0x5658, 0x53CC, 0x508E, 0x4CA3, 0x4814, 0x42EB, 0x3D33, 0x36F8, 0x3048, 0x2930, 0x21C0, 0x1A08, 0x1219,
        0x0A02, 0x01D7, 0xF9A8, 0xF186, 0xE983, 0xE1B0, 0xDA1D, 0xD2DC, 0xCBFB, 0xC58A, 0xBF96, 0xBA2B, 0xB556, 0xB120, 0xAD93, 0xAAB6,
        0xA890, 0xA725, 0xA677, 0xA689, 0xA75B, 0xA8EA, 0xAB33, 0xAE32, 0xB1DF, 0xB634, 0xBB26, 0xC0AC, 0xC6B9, 0xCD41, 0xD435, 0xDB87,
        0xE326, 0xEB04, 0xF30E, 0xFB34, 0x0364, 0x0B8D, 0x139D, 0x1B83, 0x232F, 0x2A8F, 0x3194, 0x3830, 0x3E53, 0x43F1, 0x48FD, 0x4D6E,
        0x5139, 0x5456, 0x56BF, 0x586E, 0x5960, 0x5993, 0x5907, 0x57BC, 0x55B5, 0x52F8, 0x4F88, 0x4B6F, 0x46B5, 0x4163, 0x3B85, 0x3528,
        0x2E5A, 0x2728, 0x1FA3, 0x17DA, 0x0FDE, 0x07BF, 0xFF92, 0xF764, 0xEF49, 0xE751, 0xDF8F, 0xD811, 0xD0E9, 0xCA26, 0xC3D6, 0xBE07,
        0xB8C4, 0xB41A, 0xB013, 0xACB6, 0xAA0B, 0xA818, 0xA6E1, 0xA669, 0xA6B0, 0xA7B7, 0xA97A, 0xABF6, 0xAF26, 0xB303, 0xB784, 0xBCA0,
        0xC24D, 0xC87D, 0xCF24, 0xD634, 0xDD9D, 0xE550, 0xED3B, 0xF54F, 0xFD7A, 0x05A9, 0x0DCC, 0x15D3, 0x1DAB, 0x2543, 0x2C8C, 0x3375,
        0x39F0, 0x3FF0, 0x4566, 0x4A49, 0x4E8C, 0x5227, 0x5513, 0x5749, 0x58C4, 0x5981, 0x597F, 0x58BE, 0x573F, 0x5505, 0x5215, 0x4E76,
        0x4A2F, 0x454A, 0x3FD0, 0x39CE, 0x3350, 0x2C64, 0x251A, 0x1D80, 0x15A7, 0x0DA0, 0x057B, 0xFD4C, 0xF522, 0xED0F, 0xE524, 0xDD73,
        0xD60C, 0xCEFE, 0xC85A, 0xC22C, 0xBC83, 0xB769, 0xB2EB, 0xAF12, 0xABE6, 0xA96E, 0xA7AF, 0xA6AD, 0xA66A, 0xA6E6, 0xA821, 0xAA18,
        0xACC7, 0xB027, 0xB432, 0xB8E0, 0xBE25, 0xC3F8, 0xCA4A, 0xD110, 0xD83A, 0xDFB9, 0xE77D, 0xEF75, 0xF791, 0xFFBF, 0x07ED, 0x100A,
        0x1805, 0x1FCD, 0x2751, 0x2E80, 0x354D, 0x3BA7, 0x4182, 0x46D0, 0x4B88, 0x4F9D, 0x5309, 0x55C3, 0x57C5, 0x590C, 0x5994, 0x595D,
        0x5867, 0x56B3, 0x5446, 0x5125, 0x4D57, 0x48E3, 0x43D3, 0x3E32, 0x380D, 0x316F, 0x2A67, 0x2305, 0x1B58, 0x1371, 0x0B60, 0x0336,
        0xFB07, 0xF2E2, 0xEAD8, 0xE2FC, 0xDB5D, 0xD40E, 0xCD1C, 0xC697, 0xC08C, 0xBB0A, 0xB61A, 0xB1C9, 0xAE1F, 0xAB25, 0xA8DF, 0xA754,
        0xA687, 0xA679, 0xA72A, 0xA89A, 0xAAC4, 0xADA5, 0xB135, 0xB56F, 0xBA47, 0xBFB5, 0xC5AC, 0xCC20, 0xD303, 0xDA46, 0xE1DA, 0xE9AE,
        0xF1B2, 0xF9D5, 0x0204, 0x0A2F, 0x1245, 0x1A34, 0x21EA, 0x2958, 0x306E, 0x371C, 0x3D54, 0x4309, 0x482F, 0x4CBA, 0x50A1, 0x53DC,
        0x5664, 0x5833, 0x5945, 0x5998, 0x592C, 0x5801, 0x5619, 0x537A, 0x5028, 0x4C2B, 0x478B, 0x4252, 0x3C8B, 0x3642, 0x2F86, 0x2864,
        0x20EB, 0x192C, 0x1137, 0x091E, 0x00F1, 0xF8C3, 0xF0A3, 0xE8A5, 0xE0D8, 0xD94E, 0xD216, 0xCB41, 0xC4DD, 0xBEF7, 0xB99C, 0xB4D8,
        0xB0B4, 0xAD3A, 0xAA71, 0xA85F, 0xA708, 0xA670, 0xA697, 0xA77D, 0xA921, 0xAB7E, 0xAE91, 0xB251, 0xB6B7, 0xBBBA, 0xC14F, 0xC76B,
        0xCDFF, 0xD4FE, 0xDC59, 0xE400, 0xEBE4, 0xF3F2, 0xFC1A, 0x0449, 0x0C70, 0x147D, 0x1C5E, 0x2402, 0x2B59, 0x3253, 0x38E2, 0x3EF7,
        0x4486, 0x4981, 0x4DE0, 0x5198, 0x54A2, 0x56F7, 0x5892, 0x596F, 0x598D, 0x58EC, 0x578C, 0x5571, 0x52A0, 0x4F1E, 0x4AF2, 0x4627,
        0x40C5, 0x3AD9, 0x346F, 0x2D95, 0x2659, 0x1ECB, 0x16FC, 0x0EFB, 0x06DB, 0xFEAC, 0xF680, 0xEE68, 0xE675, 0xDEB9, 0xD744, 0xD027,
        0xC96F, 0xC32D, 0xBD6C, 0xB83A, 0xB3A1, 0xAFAC, 0xAC62, 0xA9CB, 0xA7ED, 0xA6CB, 0xA668, 0xA6C4, 0xA7DF, 0xA9B7, 0xAC47, 0xAF8A,
        0xB379, 0xB80C, 0xBD39, 0xC2F4, 0xC932, 0xCFE6, 0xD700, 0xDE72, 0xE62B, 0xEE1C, 0xF633, 0xFE5F, 0x068E, 0x0EAF, 0x16B1, 0x1E83,
        0x2613, 0x2D52, 0x3430, 0x3A9F, 0x4090, 0x45F7, 0x4AC8, 0x4EF9, 0x5282, 0x555A, 0x577C, 0x58E2, 0x598B, 0x5974, 0x589D, 0x5709,
        0x54BB, 0x51B8, 0x4E06, 0x49AD, 0x44B7, 0x3F2E, 0x391D, 0x3293, 0x2B9C, 0x2448, 0x1CA7, 0x14C8, 0x0CBD, 0x0496, 0xFC67, 0xF43E,
        0xEC2F, 0xE44A, 0xDCA0, 0xD542, 0xCE3F, 0xC7A6, 0xC187, 0xBBEC, 0xB6E4, 0xB277, 0xAEB1, 0xAB98, 0xA934, 0xA78A, 0xA69C, 0xA66E,
        0xA6FF, 0xA84F, 0xAA5A, 0xAD1D, 0xB090, 0xB4AE, 0xB96C, 0xBEC2, 0xC4A3, 0xCB03, 0xD1D4, 0xD908, 0xE090, 0xE85A, 0xF057, 0xF876,
        0x00A4, 0x08D1, 0x10EC, 0x18E2, 0x20A3, 0x281F, 0x2F44, 0x3605, 0x3C52, 0x421E, 0x475C, 0x4C02, 0x5006, 0x535E, 0x5604, 0x57F2,
        0x5924, 0x5997, 0x594B, 0x5840, 0x5678, 0x53F7, 0x50C3, 0x4CE2, 0x485C, 0x433C, 0x3D8C, 0x3759, 0x30AF, 0x299D, 0x2231, 0x1A7D,
        0x1290, 0x0A7C, 0x0251, 0xFA22, 0xF1FF, 0xE9F9, 0xE223, 0xDA8C, 0xD346, 0xCC5F, 0xC5E7, 0xBFEB, 0xBA78, 0xB59A, 0xB15A, 0xADC3,
        0xAADC, 0xA8AB, 0xA735, 0xA67C, 0xA683, 0xA74A, 0xA8CE, 0xAB0C, 0xAE00, 0xB1A4, 0xB5EF, 0xBAD8, 0xC056, 0xC65B, 0xCCDC, 0xD3CA,
        0xDB17, 0xE2B3, 0xEA8D, 0xF295, 0xFABA, 0x02E9, 0x0B13, 0x1326, 0x1B0F, 0x22BE, 0x2A23, 0x312E, 0x37D0, 0x3DFB, 0x43A1, 0x48B6,
        0x4D30, 0x5105, 0x542C, 0x56A0, 0x585A, 0x5957, 0x5995, 0x5914, 0x57D4, 0x55D9, 0x5326, 0x4FC1, 0x4BB1, 0x4700, 0x41B6, 0x3BE0,
        0x358B, 0x2EC2, 0x2796, 0x2015, 0x184F, 0x1056, 0x0839, 0x000B, 0xF7DE, 0xEFC1, 0xE7C7, 0xE001, 0xD87F, 0xD152, 0xCA88, 0xC431,
        0xBE5A, 0xB90F, 0xB45C, 0xB04A, 0xACE3, 0xAA2E, 0xA830, 0xA6EE, 0xA66B, 0xA6A7, 0xA7A2, 0xA95A, 0xABCC, 0xAEF1, 0xB2C4, 0xB73C,
        0xBC50, 0xC1F4, 0xC81D, 0xCEBE, 0xD5C8, 0xDD2C, 0xE4DB, 0xECC4, 0xF4D5, 0xFCFF, 0x052E, 0x0D54, 0x155C, 0x1D37, 0x24D4, 0x2C21,
        0x3311, 0x3993, 0x3F9A, 0x4519, 0x4A04, 0x4E51, 0x51F6, 0x54EC, 0x572D, 0x58B3, 0x597C, 0x5985, 0x58CE, 0x575A, 0x552B, 0x5246,
        0x4EB1, 0x4A74, 0x4597, 0x4025, 0x3A2B, 0x33B4, 0x2CCE, 0x2589, 0x1DF3, 0x161E, 0x0E19, 0x05F5, 0xFDC7, 0xF59B, 0xED87, 0xE599,
        0xDDE4, 0xD678, 0xCF65, 0xC8BA, 0xC285, 0xBCD3, 0xB7B1, 0xB32A, 0xAF47, 0xAC11, 0xA98E, 0xA7C4, 0xA6B7, 0xA668, 0xA6DA, 0xA80A,
        0xA9F6, 0xAC9A, 0xAFF0, 0xB3F1, 0xB896, 0xBDD3, 0xC39D, 0xC9E9, 0xD0A8, 0xD7CC, 0xDF47, 0xE707, 0xEEFD, 0xF717, 0xFF45, 0x0773,
        0x0F92, 0x178F, 0x1F5B, 0x26E3, 0x2E18, 0x34EA, 0x3B4C, 0x412E, 0x4685, 0x4B46, 0x4F65, 0x52DA, 0x559F, 0x57AC, 0x58FE, 0x5991,
        0x5965, 0x587A, 0x56D2, 0x5470, 0x5159, 0x4D94, 0x492A, 0x4423, 0x3E8A, 0x386C, 0x31D5, 0x2AD3, 0x2376, 0x1BCD, 0x13E8, 0x0BD9,
        0x03B1, 0xFB81, 0xF35B, 0xEB4F, 0xE370, 0xDBCD, 0xD478, 0xCD80, 0xC6F5, 0xC0E3, 0xBB58, 0xB660, 0xB205, 0xAE51, 0xAB4C, 0xA8FC,
        0xA766, 0xA68E, 0xA675, 0xA71B, 0xA87F, 0xAA9F, 0xAD75, 0xB0FC, 0xB52B, 0xB9FB, 0xBF60, 0xC550, 0xCBBD, 0xD29A, 0xD9D8, 0xE167,
        0xE938, 0xF13A, 0xF95B, 0x0189, 0x09B6, 0x11CD, 0x19BE, 0x2179, 0x28EC, 0x3007, 0x36BB, 0x3CFB, 0x42B8, 0x47E6, 0x4C7B, 0x506C,
        0x53B1, 0x5643, 0x581D, 0x593A, 0x5998, 0x5937, 0x5817, 0x563B, 0x53A6, 0x505F, 0x4C6B, 0x47D4, 0x42A4, 0x3CE5, 0x36A3, 0x2FED,
        0x28D1, 0x215D, 0x19A1, 0x11AF, 0x0998, 0x016B, 0xF93D, 0xF11C, 0xE91B, 0xE14B, 0xD9BC, 0xD280, 0xCBA4, 0xC539, 0xBF4B, 0xB9E8,
        0xB51B, 0xB0ED, 0xAD69, 0xAA96, 0xA879, 0xA717, 0xA674, 0xA690, 0xA76B, 0xA903, 0xAB56, 0xAE5E, 0xB214, 0xB671, 0xBB6B, 0xC0F8,
        0xC70C, 0xCD99, 0xD493, 0xDBE9, 0xE38C, 0xEB6C, 0xF379, 0xFBA0, 0x03CF, 0x0BF7, 0x1406, 0x1BE9, 0x2392, 0x2AEE, 0x31EE, 0x3883,
        0x3EA0, 0x4436, 0x493B, 0x4DA3, 0x5166, 0x547A, 0x56D9, 0x587F, 0x5967, 0x5991, 0x58FA, 0x57A6, 0x5596, 0x52CF, 0x4F57, 0x4B35,
        0x4673, 0x4119, 0x3B35, 0x34D2, 0x2DFE, 0x26C7, 0x1F3E, 0x1772, 0x0F74, 0x0755, 0xFF27, 0xF6F9, 0xEEE0, 0xE6EA, 0xDF2B, 0xD7B1,
        0xD08E, 0xC9D1, 0xC387, 0xBDBE, 0xB883, 0xB3E1, 0xAFE2, 0xAC8E, 0xA9ED, 0xA804, 0xA6D7, 0xA668, 0xA6B9, 0xA7C9, 0xA996, 0xAC1B,
        0xAF54, 0xB33A, 0xB7C3, 0xBCE7, 0xC29B, 0xC8D2, 0xCF7E, 0xD693, 0xDE00, 0xE5B6, 0xEDA4, 0xF5BA, 0xFDE5, 0x0614, 0x0E37, 0x163B,
        0x1E10, 0x25A4, 0x2CE9, 0x33CD, 0x3A42, 0x403B, 0x45AA, 0x4A84, 0x4EBF, 0x5252, 0x5535, 0x5761, 0x58D2, 0x5986, 0x597A, 0x58AF,
        0x5726, 0x54E3, 0x51EA, 0x4E42, 0x49F3, 0x4505, 0x3F84, 0x397B, 0x32F8, 0x2C07, 0x24B8, 0x1D1A, 0x153F, 0x0D36, 0x0510, 0xFCE1,
        0xF4B7, 0xECA6, 0xE4BE, 0xDD10, 0xD5AD, 0xCEA5, 0xC806, 0xC1DF, 0xBC3C, 0xB72B, 0xB2B5, 0xAEE5, 0xABC2, 0xA953, 0xA79D, 0xA6A5,
        0xA66B, 0xA6F2, 0xA836, 0xAA37, 0xACEF, 0xB058, 0xB46C, 0xB921, 0xBE6E, 0xC447, 0xCAA0, 0xD16C, 0xD89A, 0xE01D, 0xE7E4, 0xEFDF,
        0xF7FC, 0x0029, 0x0857, 0x1074, 0x186D, 0x2031, 0x27B1, 0x2EDC, 0x35A3, 0x3BF7, 0x41CB, 0x4712, 0x4BC1, 0x4FCE, 0x5331, 0x55E1,
        0x57DA, 0x5917, 0x5996, 0x5955, 0x5855, 0x5698, 0x5422, 0x50F8, 0x4D20, 0x48A4, 0x438D, 0x3DE5, 0x37B9, 0x3115, 0x2A09, 0x22A2,
        0x1AF2, 0x1308, 0x0AF5, 0x02CB, 0xFA9C, 0xF277, 0xEA70, 0xE296, 0xDAFC, 0xD3B0, 0xCCC3, 0xC644, 0xC041, 0xBAC5, 0xB5DE, 0xB195,
        0xADF4, 0xAB02, 0xA8C7, 0xA745, 0xA682, 0xA67E, 0xA739, 0xA8B2, 0xAAE6, 0xADCF, 0xB169, 0xB5AA, 0xBA8B, 0xC000, 0xC5FE, 0xCC78,
        0xD360, 0xDAA8, 0xE23F, 0xEA16, 0xF21C, 0xFA40, 0x026F, 0x0A9A, 0x12AE, 0x1A9A, 0x224D, 0x29B7, 0x30C8, 0x3770, 0x3DA2, 0x4350,
        0x486E, 0x4CF1, 0x50D0, 0x5402, 0x5680, 0x5845, 0x594E, 0x5997, 0x5921, 0x57EC, 0x55FB, 0x5353, 0x4FF8, 0x4BF2, 0x474A, 0x4209,
        0x3C3B, 0x35ED, 0x2F2A, 0x2804, 0x2087, 0x18C5, 0x10CE, 0x08B3, 0x0086, 0xF858, 0xF03A, 0xE83D, 0xE073, 0xD8ED, 0xD1BA, 0xCAEA,
        0xC48C, 0xBEAD, 0xB95A, 0xB49D, 0xB082, 0xAD11, 0xAA51, 0xA849, 0xA6FC, 0xA66D, 0xA69E, 0xA78E, 0xA93C, 0xABA2, 0xAEBE, 0xB287,
        0xB6F5, 0xBC00, 0xC19C, 0xC7BE, 0xCE58, 0xD55C, 0xDCBC, 0xE466, 0xEC4C, 0xF45C, 0xFC85, 0x04B4, 0x0CDB, 0x14E5, 0x1CC3, 0x2464,
        0x2BB7, 0x32AC, 0x3935, 0x3F43, 0x44CB, 0x49BF, 0x4E15, 0x51C5, 0x54C5, 0x5710, 0x58A2, 0x5975, 0x598A, 0x58DE, 0x5775, 0x5551,
        0x5276, 0x4EEB, 0x4AB7, 0x45E4, 0x407B, 0x3A88, 0x3418, 0x2D38, 0x25F8, 0x1E66, 0x1694, 0x0E91, 0x066F, 0xFE41, 0xF615, 0xEDFE,
        0xE60E, 0xDE55, 0xD6E5, 0xCFCC, 0xC91A, 0xC2DE, 0xBD24, 0xB7FA, 0xB369, 0xAF7D, 0xAC3C, 0xA9AE, 0xA7DA, 0xA6C1, 0xA668, 0xA6CE,
        0xA7F3, 0xA9D4, 0xAC6D, 0xAFB9, 0xB3B1, 0xB84C, 0xBD80, 0xC343, 0xC987, 0xD040, 0xD75F, 0xDED5, 0xE692, 0xEE85, 0xF69E, 0xFECA,
        0x06F9, 0x0F19, 0x1719, 0x1EE8, 0x2674, 0x2DAF, 0x3487, 0x3AF0, 0x40DA, 0x4639, 0x4B03, 0x4F2C, 0x52AC, 0x557A, 0x5793, 0x58EF,
        0x598E, 0x596D, 0x588D, 0x56F0, 0x5498, 0x518C, 0x4DD1, 0x4970, 0x4472, 0x3EE2, 0x38CB, 0x323A, 0x2B3E, 0x23E6, 0x1C41, 0x145F,
        0x0C52, 0x042B, 0xFBFB, 0xF3D4, 0xEBC6, 0xE3E4, 0xDC3D, 0xD4E3, 0xCDE6, 0xC753, 0xC13A, 0xBBA7, 0xB6A6, 0xB242, 0xAE84, 0xAB74,
        0xA91A, 0xA779, 0xA695, 0xA671, 0xA70C, 0xA865, 0xAA7A, 0xAD46, 0xB0C2, 0xB4E8, 0xB9AF, 0xBF0C, 0xC4F3, 0xCB5A, 0xD230, 0xD969,
        0xE0F4, 0xE8C2, 0xF0C1, 0xF8E1, 0x010F, 0x093C, 0x1155, 0x1949, 0x2107, 0x287F, 0x2F9F, 0x365A, 0x3CA1, 0x4266, 0x479D, 0x4C3B,
        0x5036, 0x5385, 0x5622, 0x5806, 0x592F, 0x5998, 0x5942, 0x582D, 0x565C, 0x53D2, 0x5094, 0x4CAB, 0x481D, 0x42F5, 0x3D3E, 0x3704,
        0x3054, 0x293D, 0x21CE, 0x1A17, 0x1227, 0x0A11, 0x01E5, 0xF9B7, 0xF195, 0xE991, 0xE1BE, 0xDA2B, 0xD2E9, 0xCC08, 0xC595, 0xBFA0,
        0xBA34, 0xB55E, 0xB127, 0xAD99, 0xAABB, 0xA893, 0xA727, 0xA678, 0xA689, 0xA759, 0xA8E6, 0xAB2E, 0xAE2C, 0xB1D8, 0xB62C, 0xBB1D,
        0xC0A2, 0xC6AE, 0xCD35, 0xD428, 0xDB79, 0xE318, 0xEAF5, 0xF2FF, 0xFB25, 0x0355, 0x0B7E, 0x138E, 0x1B75, 0x2321, 0x2A82, 0x3188,
        0x3824, 0x3E48, 0x43E7, 0x48F5, 0x4D66, 0x5132, 0x5451, 0x56BB, 0x586B, 0x595F, 0x5993, 0x5908, 0x57BF, 0x55BA, 0x52FD, 0x4F8F,
        0x4B77, 0x46BE, 0x416D, 0x3B90, 0x3534, 0x2E67, 0x2736, 0x1FB1, 0x17E8, 0x0FEC, 0x07CE, 0xFFA1, 0xF773, 0xEF58, 0xE760, 0xDF9D,
        0xD81F, 0xD0F6, 0xCA32, 0xC3E1, 0xBE11, 0xB8CD, 0xB422, 0xB019, 0xACBB, 0xAA0F, 0xA81B, 0xA6E3, 0xA669, 0xA6AF, 0xA7B4, 0xA976,
        0xABF1, 0xAF1F, 0xB2FB, 0xB77B, 0xBC96, 0xC242, 0xC871, 0xCF18, 0xD627, 0xDD8F, 0xE541, 0xED2D, 0xF540, 0xFD6B, 0x059A, 0x0DBE,
        0x15C4, 0x1D9C, 0x2535, 0x2C7F, 0x3369, 0x39E5, 0x3FE5, 0x455D, 0x4A40, 0x4E85, 0x5221, 0x550E, 0x5746, 0x58C2, 0x5981, 0x5980,
        0x58C0, 0x5742, 0x550A, 0x521B, 0x4E7D, 0x4A38, 0x4553, 0x3FDA, 0x39D9, 0x335C, 0x2C71, 0x2527, 0x1D8E, 0x15B6, 0x0DAF, 0x058A,
        0xFD5B, 0xF531, 0xED1E, 0xE533, 0xDD81, 0xD619, 0xCF0B, 0xC865, 0xC237, 0xBC8C, 0xB772, 0xB2F3, 0xAF19, 0xABEC, 0xA972, 0xA7B2,
        0xA6AE, 0xA66A, 0xA6E5, 0xA81E, 0xAA14, 0xACC1, 0xB020, 0xB42A, 0xB8D7, 0xBE1B, 0xC3ED, 0xCA3E, 0xD103, 0xD82C, 0xDFAB, 0xE76F,
        0xEF67, 0xF782, 0xFFB0, 0x07DE, 0x0FFB, 0x17F7, 0x1FBF, 0x2743, 0x2E74, 0x3541, 0x3B9C, 0x4178, 0x46C7, 0x4B80, 0x4F96, 0x5303,
        0x55BE, 0x57C2, 0x590A, 0x5994, 0x595E, 0x5869, 0x56B7, 0x544B, 0x512C, 0x4D5E, 0x48EC, 0x43DD, 0x3E3D, 0x3818, 0x317B, 0x2A75,
        0x2313, 0x1B67, 0x137F, 0x0B6F, 0x0345, 0xFB16, 0xF2F0, 0xEAE7, 0xE30A, 0xDB6B, 0xD41B, 0xCD28, 0xC6A2, 0xC097, 0xBB13, 0xB623,
        0xB1D1, 0xAE26, 0xAB2A, 0xA8E3, 0xA757, 0xA688, 0xA678, 0xA729, 0xA897, 0xAAC0, 0xAD9F, 0xB12E, 0xB566, 0xBA3E, 0xBFAB, 0xC5A1,
        0xCC14, 0xD2F6, 0xDA39, 0xE1CC, 0xE9A0, 0xF1A4, 0xF9C6, 0x01F5, 0x0A20, 0x1236, 0x1A25, 0x21DC, 0x294B, 0x3061, 0x3710, 0x3D49,
        0x42FF, 0x4826, 0x4CB3, 0x509B, 0x53D7, 0x5660, 0x5830, 0x5943, 0x5998, 0x592D, 0x5803, 0x561E, 0x537F, 0x502F, 0x4C33, 0x4794,
        0x425C, 0x3C96, 0x364E, 0x2F92, 0x2871, 0x20F9, 0x193B, 0x1146, 0x092D, 0x0100, 0xF8D2, 0xF0B2, 0xE8B3, 0xE0E6, 0xD95B, 0xD223,
        0xCB4D, 0xC4E8, 0xBF01, 0xB9A5, 0xB4E0, 0xB0BB, 0xAD40, 0xAA75, 0xA862, 0xA70A, 0xA670, 0xA696, 0xA77B, 0xA91D, 0xAB7A, 0xAE8A,
        0xB249, 0xB6AF, 0xBBB1, 0xC145, 0xC75F, 0xCDF2, 0xD4F1, 0xDC4B, 0xE3F2, 0xEBD5, 0xF3E3, 0xFC0B, 0x043A, 0x0C61, 0x146E, 0x1C4F,
        0x23F4, 0x2B4C, 0x3247, 0x38D6, 0x3EEC, 0x447C, 0x4979, 0x4DD9, 0x5192, 0x549D, 0x56F3, 0x588F, 0x596E, 0x598E, 0x58EE, 0x578F,
        0x5576, 0x52A6, 0x4F25, 0x4AFB, 0x4630, 0x40CF, 0x3AE4, 0x347B, 0x2DA2, 0x2667, 0x1ED9, 0x170A, 0x0F0A, 0x06E9, 0xFEBB, 0xF68F,
        0xEE76, 0xE683, 0xDEC7, 0xD752, 0xD033, 0xC97B, 0xC338, 0xBD76, 0xB843, 0xB3A9, 0xAFB2, 0xAC68, 0xA9D0, 0xA7F0, 0xA6CC, 0xA668,
        0xA6C3, 0xA7DC, 0xA9B3, 0xAC41, 0xAF83, 0xB371, 0xB803, 0xBD2F, 0xC2E9, 0xC926, 0xCFD9, 0xD6F2, 0xDE64, 0xE61D, 0xEE0D, 0xF624,
        0xFE50, 0x067F, 0x0EA0, 0x16A3, 0x1E75, 0x2606, 0x2D45, 0x3424, 0x3A93, 0x4085, 0x45ED, 0x4AC0, 0x4EF2, 0x527C, 0x5556, 0x5778,
        0x58E0, 0x598A, 0x5974, 0x589F, 0x570D, 0x54C0, 0x51BE, 0x4E0E, 0x49B6, 0x44C1, 0x3F38, 0x3929, 0x329F, 0x2BA9, 0x2456, 0x1CB5,
        0x14D6, 0x0CCB, 0x04A5, 0xFC76, 0xF44D, 0xEC3D, 0xE458, 0xDCAE, 0xD54F, 0xCE4B, 0xC7B2, 0xC191, 0xBBF6, 0xB6EC, 0xB27F, 0xAEB7,
        0xAB9D, 0xA938, 0xA78C, 0xA69D, 0xA66E, 0xA6FE, 0xA84C, 0xAA56, 0xAD17, 0xB089, 0xB4A6, 0xB963, 0xBEB8, 0xC498, 0xCAF7, 0xD1C7,
        0xD8FB, 0xE082, 0xE84C, 0xF049, 0xF867, 0x0095, 0x08C2, 0x10DD, 0x18D4, 0x2095, 0x2811, 0x2F38, 0x35F9, 0x3C47, 0x4214, 0x4753,
        0x4BFA, 0x4FFF, 0x5358, 0x5600, 0x57EF, 0x5923, 0x5997, 0x594C, 0x5843, 0x567C, 0x53FD, 0x50C9, 0x4CEA, 0x4865, 0x4346, 0x3D97,
        0x3764, 0x30BB, 0x29AA, 0x223F, 0x1A8C, 0x129F, 0x0A8B, 0x0260, 0xFA31, 0xF20D, 0xEA08, 0xE231, 0xDA9A, 0xD353, 0xCC6B, 0xC5F2,
        0xBFF5, 0xBA81, 0xB5A2, 0xB161, 0xADC9, 0xAAE1, 0xA8AE, 0xA737, 0xA67D, 0xA682, 0xA747, 0xA8CA, 0xAB07, 0xADFA, 0xB19D, 0xB5E7,
        0xBACF, 0xC04B, 0xC650, 0xCCD0, 0xD3BD, 0xDB0A, 0xE2A5, 0xEA7F, 0xF287, 0xFAAB, 0x02DA, 0x0B04, 0x1317, 0x1B01, 0x22B0, 0x2A16,
        0x3122, 0x37C5, 0x3DF0, 0x4397, 0x48AD, 0x4D28, 0x50FE, 0x5427, 0x569C, 0x5857, 0x5956, 0x5996, 0x5916, 0x57D7, 0x55DD, 0x532B,
        0x4FC7, 0x4BB9, 0x4709, 0x41C0, 0x3BEC, 0x3597, 0x2ECF, 0x27A3, 0x2023, 0x185E, 0x1065, 0x0848, 0x001A, 0xF7ED, 0xEFD0, 0xE7D6,
        0xE00F, 0xD88C, 0xD15E, 0xCA94, 0xC43C, 0xBE64, 0xB918, 0xB464, 0xB051, 0xACE9, 0xAA32, 0xA833, 0xA6F0, 0xA66B, 0xA6A6, 0xA7A0,
        0xA957, 0xABC7, 0xAEEB, 0xB2BD, 0xB734, 0xBC46, 0xC1EA, 0xC812, 0xCEB2, 0xD5BB, 0xDD1E, 0xE4CD, 0xECB5, 0xF4C7, 0xFCF0, 0x0520,
        0x0D45, 0x154E, 0x1D29, 0x24C6, 0x2C14, 0x3304, 0x3987, 0x3F8F, 0x450F, 0x49FB, 0x4E4A, 0x51F0, 0x54E8, 0x572A, 0x58B1, 0x597B,
        0x5985, 0x58D0, 0x575E, 0x5530, 0x524C, 0x4EB8, 0x4A7C, 0x45A0, 0x4030, 0x3A36, 0x33C0, 0x2CDB, 0x2597, 0x1E01, 0x162C, 0x0E27,
        0x0604, 0xFDD6, 0xF5AA, 0xED95, 0xE5A7, 0xDDF2, 0xD685, 0xCF72, 0xC8C6, 0xC290, 0xBCDD, 0xB7BA, 0xB332, 0xAF4E, 0xAC16, 0xA992,
        0xA7C7, 0xA6B8, 0xA668, 0xA6D8, 0xA807, 0xA9F1, 0xAC94, 0xAFE9, 0xB3EA, 0xB88D, 0xBDC9, 0xC392, 0xC9DD, 0xD09B, 0xD7BF, 0xDF39,
        0xE6F9, 0xEEEF, 0xF709, 0xFF36, 0x0764, 0x0F83, 0x1781, 0x1F4D, 0x26D5, 0x2E0B, 0x34DE, 0x3B40, 0x4124, 0x467C, 0x4B3D, 0x4F5E,
        0x52D5, 0x559A, 0x57A9, 0x58FC, 0x5991, 0x5966, 0x587C, 0x56D5, 0x5475, 0x515F, 0x4D9C, 0x4932, 0x442D, 0x3E95, 0x3877, 0x31E1,
        0x2AE0, 0x2383, 0x1BDB, 0x13F7, 0x0BE8, 0x03C0, 0xFB90, 0xF369, 0xEB5D, 0xE37E, 0xDBDB, 0xD485, 0xCD8D, 0xC700, 0xC0ED, 0xBB62,
        0xB668, 0xB20D, 0xAE58, 0xAB51, 0xA900, 0xA769, 0xA68F, 0xA674, 0xA719, 0xA87C, 0xAA9A, 0xAD6F, 0xB0F4, 0xB523, 0xB9F1, 0xBF56,
        0xC544, 0xCBB1, 0xD28D, 0xD9CA, 0xE159, 0xE92A, 0xF12B, 0xF94C, 0x017B, 0x09A7, 0x11BE, 0x19B0, 0x216B, 0x28DE, 0x2FFA, 0x36AF,
        0x3CF0, 0x42AE, 0x47DD, 0x4C73, 0x5065, 0x53AC, 0x563F, 0x581A, 0x5939, 0x5998, 0x5939, 0x581A, 0x563F, 0x53AB, 0x5065, 0x4C73,
        0x47DD, 0x42AE, 0x3CEF, 0x36AF, 0x2FFA, 0x28DE, 0x216B, 0x19B0, 0x11BE, 0x09A6, 0x017A, 0xF94C, 0xF12B, 0xE929, 0xE159, 0xD9CA,
        0xD28C, 0xCBB0, 0xC544, 0xBF56, 0xB9F1, 0xB523, 0xB0F4, 0xAD6F, 0xAA9A, 0xA87C, 0xA719, 0xA674, 0xA68F, 0xA769, 0xA900, 0xAB51,
        0xAE58, 0xB20D, 0xB669, 0xBB62, 0xC0EE, 0xC700, 0xCD8D, 0xD486, 0xDBDB, 0xE37E, 0xEB5E, 0xF36A, 0xFB91, 0x03C0, 0x0BE8, 0x13F7,
        0x1BDB, 0x2384, 0x2AE0, 0x31E1, 0x3878, 0x3E95, 0x442D, 0x4933, 0x4D9C, 0x515F, 0x5475, 0x56D5, 0x587D, 0x5966, 0x5991, 0x58FC,
        0x57A9, 0x559A, 0x52D5, 0x4F5E, 0x4B3D, 0x467C, 0x4124, 0x3B40, 0x34DE, 0x2E0B, 0x26D5, 0x1F4C, 0x1780, 0x0F83, 0x0763, 0xFF35,
        0xF708, 0xEEEE, 0xE6F9, 0xDF39, 0xD7BF, 0xD09B, 0xC9DC, 0xC392, 0xBDC8, 0xB88C, 0xB3E9, 0xAFE9, 0xAC94, 0xA9F1, 0xA807, 0xA6D8,
        0xA668, 0xA6B8, 0xA7C7, 0xA992, 0xAC16, 0xAF4E, 0xB332, 0xB7BA, 0xBCDD, 0xC290, 0xC8C6, 0xCF72, 0xD686, 0xDDF2, 0xE5A8, 0xED96,
        0xF5AB, 0xFDD6, 0x0605, 0x0E28, 0x162C, 0x1E02, 0x2597, 0x2CDC, 0x33C0, 0x3A37, 0x4030, 0x45A1, 0x4A7C, 0x4EB8, 0x524C, 0x5530,
        0x575E, 0x58D0, 0x5985, 0x597B, 0x58B1, 0x5729, 0x54E8, 0x51F0, 0x4E49, 0x49FB, 0x450F, 0x3F8F, 0x3987, 0x3304, 0x2C14, 0x24C6,
        0x1D29, 0x154D, 0x0D44, 0x051F, 0xFCF0, 0xF4C6, 0xECB5, 0xE4CC, 0xDD1E, 0xD5BA, 0xCEB1, 0xC811, 0xC1E9, 0xBC46, 0xB733, 0xB2BD,
        0xAEEB, 0xABC7, 0xA957, 0xA7A0, 0xA6A6, 0xA66B, 0xA6F0, 0xA833, 0xAA32, 0xACE9, 0xB051, 0xB464, 0xB918, 0xBE64, 0xC43C, 0xCA94,
        0xD15F, 0xD88D, 0xE00F, 0xE7D6, 0xEFD0, 0xF7ED, 0x001B, 0x0849, 0x1065, 0x185E, 0x2023, 0x27A4, 0x2ECF, 0x3597, 0x3BEC, 0x41C1,
        0x4709, 0x4BB9, 0x4FC7, 0x532B, 0x55DD, 0x57D7, 0x5916, 0x5996, 0x5956, 0x5857, 0x569C, 0x5427, 0x50FE, 0x4D28, 0x48AD, 0x4397,
        0x3DF0, 0x37C4, 0x3122, 0x2A16, 0x22B0, 0x1B00, 0x1317, 0x0B04, 0x02DA, 0xFAAB, 0xF286, 0xEA7E, 0xE2A4, 0xDB09, 0xD3BD, 0xCCD0,
        0xC650, 0xC04B, 0xBACF, 0xB5E6, 0xB19C, 0xADFA, 0xAB07, 0xA8CA, 0xA747, 0xA682, 0xA67D, 0xA737, 0xA8AE, 0xAAE1, 0xADC9, 0xB162,
        0xB5A2, 0xBA82, 0xBFF6, 0xC5F3, 0xCC6C, 0xD353, 0xDA9A, 0xE231, 0xEA08, 0xF20E, 0xFA31, 0x0260, 0x0A8B, 0x129F, 0x1A8C, 0x2240,
        0x29AA, 0x30BB, 0x3765, 0x3D97, 0x4346, 0x4865, 0x4CEA, 0x50CA, 0x53FD, 0x567C, 0x5843, 0x594C, 0x5997, 0x5922, 0x57EF, 0x5600,
        0x5358, 0x4FFF, 0x4BFA, 0x4753, 0x4213, 0x3C46, 0x35F8, 0x2F37, 0x2811, 0x2095, 0x18D3, 0x10DD, 0x08C2, 0x0094, 0xF867, 0xF048,
        0xE84B, 0xE081, 0xD8FA, 0xD1C7, 0xCAF7, 0xC497, 0xBEB7, 0xB963, 0xB4A5, 0xB089, 0xAD17, 0xAA56, 0xA84C, 0xA6FE, 0xA66E, 0xA69D,
        0xA78C, 0xA938, 0xAB9D, 0xAEB7, 0xB27F, 0xB6ED, 0xBBF6, 0xC192, 0xC7B2, 0xCE4C, 0xD54F, 0xDCAE, 0xE458, 0xEC3E, 0xF44D, 0xFC76,
        0x04A5, 0x0CCC, 0x14D7, 0x1CB5, 0x2456, 0x2BAA, 0x32A0, 0x3929, 0x3F39, 0x44C1, 0x49B6, 0x4E0E, 0x51BE, 0x54C0, 0x570D, 0x589F,
        0x5974, 0x598A, 0x58E0, 0x5778, 0x5555, 0x527C, 0x4EF2, 0x4AC0, 0x45ED, 0x4085, 0x3A93, 0x3424, 0x2D45, 0x2605, 0x1E75, 0x16A3,
        0x0EA0, 0x067E, 0xFE50, 0xF624, 0xEE0D, 0xE61C, 0xDE63, 0xD6F2, 0xCFD9, 0xC926, 0xC2E9, 0xBD2E, 0xB803, 0xB371, 0xAF83, 0xAC41,
        0xA9B2, 0xA7DC, 0xA6C3, 0xA668, 0xA6CC, 0xA7F0, 0xA9D0, 0xAC68, 0xAFB3, 0xB3A9, 0xB843, 0xBD76, 0xC338, 0xC97B, 0xD034, 0xD752,
        0xDEC7, 0xE684, 0xEE77, 0xF68F, 0xFEBC, 0x06EA, 0x0F0A, 0x170B, 0x1EDA, 0x2667, 0x2DA2, 0x347B, 0x3AE4, 0x40D0, 0x4630, 0x4AFB,
        0x4F25, 0x52A6, 0x5576, 0x578F, 0x58EE, 0x598E, 0x596E, 0x588F, 0x56F3, 0x549D, 0x5192, 0x4DD9, 0x4979, 0x447C, 0x3EEC, 0x38D6,
        0x3246, 0x2B4B, 0x23F4, 0x1C4F, 0x146E, 0x0C61, 0x043A, 0xFC0A, 0xF3E3, 0xEBD5, 0xE3F2, 0xDC4B, 0xD4F0, 0xCDF2, 0xC75F, 0xC145,
        0xBBB0, 0xB6AE, 0xB249, 0xAE8A, 0xAB79, 0xA91D, 0xA77B, 0xA696, 0xA670, 0xA70A, 0xA862, 0xAA76, 0xAD40, 0xB0BB, 0xB4E0, 0xB9A5,
        0xBF01, 0xC4E8, 0xCB4D, 0xD223, 0xD95B, 0xE0E6, 0xE8B3, 0xF0B2, 0xF8D2, 0x0100, 0x092D, 0x1146, 0x193B, 0x20F9, 0x2871, 0x2F93,
        0x364E, 0x3C96, 0x425C, 0x4794, 0x4C33, 0x502F, 0x5380, 0x561E, 0x5803, 0x592D, 0x5998, 0x5943, 0x5830, 0x5660, 0x53D7, 0x509B,
        0x4CB2, 0x4826, 0x42FF, 0x3D49, 0x3710, 0x3061, 0x294B, 0x21DC, 0x1A25, 0x1236, 0x0A20, 0x01F4, 0xF9C6, 0xF1A3, 0xE9A0, 0xE1CC,
        0xDA38, 0xD2F6, 0xCC14, 0xC5A1, 0xBFAA, 0xBA3E, 0xB566, 0xB12E, 0xAD9F, 0xAABF, 0xA897, 0xA729, 0xA678, 0xA688, 0xA757, 0xA8E3,
        0xAB2A, 0xAE26, 0xB1D1, 0xB623, 0xBB13, 0xC097, 0xC6A2, 0xCD28, 0xD41B, 0xDB6B, 0xE30A, 0xEAE7, 0xF2F1, 0xFB16, 0x0346, 0x0B6F,
        0x1380, 0x1B67, 0x2313, 0x2A75, 0x317C, 0x3818, 0x3E3D, 0x43DD, 0x48EC, 0x4D5F, 0x512C, 0x544C, 0x56B7, 0x5869, 0x595E, 0x5994,
        0x590A, 0x57C2, 0x55BE, 0x5303, 0x4F96, 0x4B7F, 0x46C7, 0x4177, 0x3B9C, 0x3540, 0x2E73, 0x2743, 0x1FBF, 0x17F6, 0x0FFB, 0x07DD,
        0xFFB0, 0xF782, 0xEF66, 0xE76E, 0xDFAB, 0xD82C, 0xD103, 0xCA3E, 0xC3EC, 0xBE1B, 0xB8D6, 0xB42A, 0xB020, 0xACC1, 0xAA14, 0xA81E,
        0xA6E5, 0xA66A, 0xA6AE, 0xA7B2, 0xA972, 0xABEC, 0xAF19, 0xB2F3, 0xB772, 0xBC8D, 0xC237, 0xC866, 0xCF0B, 0xD61A, 0xDD81, 0xE533,
        0xED1E, 0xF531, 0xFD5C, 0x058B, 0x0DAF, 0x15B6, 0x1D8E, 0x2528, 0x2C72, 0x335C, 0x39D9, 0x3FDB, 0x4553, 0x4A38, 0x4E7E, 0x521B,
        0x550A, 0x5742, 0x58C0, 0x5980, 0x5981, 0x58C2, 0x5745, 0x550E, 0x5221, 0x4E85, 0x4A40, 0x455D, 0x3FE5, 0x39E4, 0x3368, 0x2C7E,
        0x2535, 0x1D9C, 0x15C4, 0x0DBD, 0x0599, 0xFD6A, 0xF540, 0xED2C, 0xE541, 0xDD8F, 0xD626, 0xCF18, 0xC871, 0xC242, 0xBC96, 0xB77B,
        0xB2FB, 0xAF1F, 0xABF1, 0xA976, 0xA7B4, 0xA6AF, 0xA669, 0xA6E3, 0xA81B, 0xAA0F, 0xACBB, 0xB01A, 0xB422, 0xB8CE, 0xBE11, 0xC3E1,
        0xCA32, 0xD0F6, 0xD81F, 0xDF9D, 0xE760, 0xEF58, 0xF773, 0xFFA1, 0x07CF, 0x0FED, 0x17E8, 0x1FB1, 0x2736, 0x2E67, 0x3535, 0x3B91,
        0x416D, 0x46BE, 0x4B77, 0x4F90, 0x52FD, 0x55BA, 0x57BF, 0x5908, 0x5993, 0x595F, 0x586B, 0x56BB, 0x5451, 0x5132, 0x4D66, 0x48F4,
        0x43E7, 0x3E48, 0x3824, 0x3188, 0x2A82, 0x2321, 0x1B75, 0x138E, 0x0B7D, 0x0354, 0xFB25, 0xF2FF, 0xEAF5, 0xE318, 0xDB79, 0xD428,
        0xCD34, 0xC6AD, 0xC0A1, 0xBB1D, 0xB62B, 0xB1D8, 0xAE2C, 0xAB2E, 0xA8E6, 0xA759, 0xA689, 0xA678, 0xA727, 0xA893, 0xAABB, 0xAD99,
        0xB127, 0xB55E, 0xBA35, 0xBFA0, 0xC596, 0xCC08, 0xD2E9, 0xDA2B, 0xE1BE, 0xE991, 0xF195, 0xF9B7, 0x01E6, 0x0A12, 0x1228, 0x1A17,
        0x21CE, 0x293E, 0x3055, 0x3704, 0x3D3E, 0x42F5, 0x481D, 0x4CAB, 0x5094, 0x53D2, 0x565C, 0x582D, 0x5942, 0x5998, 0x592F, 0x5806,
        0x5622, 0x5385, 0x5035, 0x4C3B, 0x479D, 0x4266, 0x3CA1, 0x365A, 0x2F9F, 0x287E, 0x2107, 0x1949, 0x1155, 0x093C, 0x010F, 0xF8E1,
        0xF0C1, 0xE8C1, 0xE0F4, 0xD969, 0xD230, 0xCB59, 0xC4F3, 0xBF0B, 0xB9AE, 0xB4E8, 0xB0C2, 0xAD46, 0xAA7A, 0xA865, 0xA70C, 0xA671,
        0xA695, 0xA779, 0xA91A, 0xAB75, 0xAE84, 0xB242, 0xB6A6, 0xBBA7, 0xC13A, 0xC753, 0xCDE6, 0xD4E4, 0xDC3E, 0xE3E4, 0xEBC6, 0xF3D4,
        0xFBFC, 0x042B, 0x0C53, 0x1460, 0x1C41, 0x23E6, 0x2B3F, 0x323A, 0x38CB, 0x3EE2, 0x4472, 0x4970, 0x4DD1, 0x518C, 0x5498, 0x56F0,
        0x588D, 0x596D, 0x598E, 0x58EF, 0x5793, 0x557A, 0x52AB, 0x4F2C, 0x4B03, 0x4639, 0x40DA, 0x3AEF, 0x3487, 0x2DAE, 0x2674, 0x1EE7,
        0x1719, 0x0F19, 0x06F8, 0xFECA, 0xF69D, 0xEE85, 0xE692, 0xDED5, 0xD75F, 0xD040, 0xC987, 0xC343, 0xBD80, 0xB84C, 0xB3B1, 0xAFB9,
        0xAC6D, 0xA9D4, 0xA7F3, 0xA6CE, 0xA668, 0xA6C1, 0xA7DA, 0xA9AF, 0xAC3C, 0xAF7D, 0xB369, 0xB7FA, 0xBD25, 0xC2DE, 0xC91B, 0xCFCC,
        0xD6E5, 0xDE56, 0xE60E, 0xEDFF, 0xF615, 0xFE41, 0x0670, 0x0E92, 0x1694, 0x1E67, 0x25F8, 0x2D38, 0x3418, 0x3A88, 0x407B, 0x45E4,
        0x4AB7, 0x4EEB, 0x5276, 0x5551, 0x5775, 0x58DE, 0x598A, 0x5975, 0x58A2, 0x5710, 0x54C5, 0x51C4, 0x4E15, 0x49BE, 0x44CA, 0x3F43,
        0x3934, 0x32AC, 0x2BB6, 0x2464, 0x1CC3, 0x14E5, 0x0CDA, 0x04B4, 0xFC85, 0xF45C, 0xEC4C, 0xE466, 0xDCBB, 0xD55C, 0xCE58, 0xC7BE,
        0xC19C, 0xBC00, 0xB6F5, 0xB286, 0xAEBD, 0xABA2, 0xA93C, 0xA78E, 0xA69E, 0xA66D, 0xA6FC, 0xA849, 0xAA52, 0xAD11, 0xB082, 0xB49E,
        0xB95A, 0xBEAD, 0xC48D, 0xCAEB, 0xD1BB, 0xD8ED, 0xE074, 0xE83D, 0xF03A, 0xF858, 0x0086, 0x08B3, 0x10CE, 0x18C5, 0x2087, 0x2804,
        0x2F2B, 0x35ED, 0x3C3C, 0x4209, 0x474A, 0x4BF2, 0x4FF8, 0x5353, 0x55FC, 0x57EC, 0x5921, 0x5997, 0x594E, 0x5845, 0x5680, 0x5402,
        0x50D0, 0x4CF1, 0x486E, 0x4350, 0x3DA2, 0x3770, 0x30C8, 0x29B7, 0x224D, 0x1A9A, 0x12AE, 0x0A9A, 0x026F, 0xFA40, 0xF21C, 0xEA16,
        0xE23F, 0xDAA7, 0xD360, 0xCC78, 0xC5FE, 0xC000, 0xBA8B, 0xB5AA, 0xB169, 0xADCF, 0xAAE5, 0xA8B2, 0xA739, 0xA67D, 0xA682, 0xA745,
        0xA8C7, 0xAB03, 0xADF4, 0xB195, 0xB5DE, 0xBAC5, 0xC041, 0xC645, 0xCCC4, 0xD3B0, 0xDAFC, 0xE297, 0xEA70, 0xF278, 0xFA9C, 0x02CB,
        0x0AF6, 0x1308, 0x1AF2, 0x22A3, 0x2A09, 0x3115, 0x37B9, 0x3DE5, 0x438D, 0x48A5, 0x4D21, 0x50F8, 0x5422, 0x5698, 0x5855, 0x5955,
        0x5996, 0x5917, 0x57DA, 0x55E1, 0x5331, 0x4FCE, 0x4BC1, 0x4712, 0x41CB, 0x3BF7, 0x35A3, 0x2EDC, 0x27B1, 0x2031, 0x186C, 0x1073,
        0x0857, 0x0029, 0xF7FC, 0xEFDF, 0xE7E4, 0xE01D, 0xD89A, 0xD16B, 0xCAA0, 0xC447, 0xBE6E, 0xB921, 0xB46C, 0xB058, 0xACEE, 0xAA37,
        0xA836, 0xA6F2, 0xA66B, 0xA6A5, 0xA79D, 0xA953, 0xABC2, 0xAEE5, 0xB2B5, 0xB72B, 0xBC3C, 0xC1DF, 0xC806, 0xCEA5, 0xD5AE, 0xDD11,
        0xE4BE, 0xECA6, 0xF4B8, 0xFCE1, 0x0511, 0x0D36, 0x153F, 0x1D1B, 0x24B8, 0x2C07, 0x32F8, 0x397C, 0x3F85, 0x4506, 0x49F3, 0x4E42,
        0x51EA, 0x54E3, 0x5726, 0x58AF, 0x597A, 0x5986, 0x58D2, 0x5761, 0x5534, 0x5252, 0x4EBF, 0x4A84, 0x45AA, 0x403A, 0x3A42, 0x33CC,
        0x2CE8, 0x25A4, 0x1E0F, 0x163B, 0x0E36, 0x0613, 0xFDE4, 0xF5B9, 0xEDA4, 0xE5B6, 0xDE00, 0xD693, 0xCF7E, 0xC8D1, 0xC29B, 0xBCE7,
        0xB7C3, 0xB33A, 0xAF54, 0xAC1B, 0xA996, 0xA7C9, 0xA6B9, 0xA668, 0xA6D7, 0xA804, 0xA9ED, 0xAC8F, 0xAFE2, 0xB3E2, 0xB884, 0xBDBE,
        0xC387, 0xC9D1, 0xD08F, 0xD7B2, 0xDF2B, 0xE6EB, 0xEEE0, 0xF6FA, 0xFF27, 0x0755, 0x0F74, 0x1772, 0x1F3E, 0x26C8, 0x2DFE, 0x34D2,
        0x3B35, 0x411A, 0x4673, 0x4B35, 0x4F57, 0x52CF, 0x5596, 0x57A6, 0x58FA, 0x5991, 0x5967, 0x587F, 0x56D9, 0x547A, 0x5165, 0x4DA3,
        0x493B, 0x4436, 0x3EA0, 0x3883, 0x31ED, 0x2AED, 0x2391, 0x1BE9, 0x1405, 0x0BF7, 0x03CF, 0xFB9F, 0xF378, 0xEB6C, 0xE38C, 0xDBE9,
        0xD492, 0xCD99, 0xC70C, 0xC0F8, 0xBB6B, 0xB671, 0xB214, 0xAE5E, 0xAB56, 0xA903, 0xA76B, 0xA690, 0xA674, 0xA717, 0xA879, 0xAA96,
        0xAD69, 0xB0ED, 0xB51B, 0xB9E8, 0xBF4B, 0xC539, 0xCBA4, 0xD280, 0xD9BC, 0xE14B, 0xE91B, 0xF11C, 0xF93D, 0x016C, 0x0998, 0x11B0,
        0x19A2, 0x215D, 0x28D1, 0x2FED, 0x36A4, 0x3CE5, 0x42A4, 0x47D4, 0x4C6B, 0x505F, 0x53A6, 0x563B, 0x5817, 0x5937, 0x5998, 0x593A,
        0x581D, 0x5643, 0x53B1, 0x506C, 0x4C7B, 0x47E6, 0x42B8, 0x3CFA, 0x36BB, 0x3006, 0x28EB, 0x2178, 0x19BE, 0x11CD, 0x09B5, 0x0189,
        0xF95B, 0xF139, 0xE938, 0xE167, 0xD9D7, 0xD299, 0xCBBC, 0xC54F, 0xBF60, 0xB9FB, 0xB52B, 0xB0FB, 0xAD75, 0xAA9F, 0xA87F, 0xA71B,
        0xA675, 0xA68E, 0xA766, 0xA8FC, 0xAB4C, 0xAE52, 0xB205, 0xB660, 0xBB58, 0xC0E3, 0xC6F5, 0xCD81, 0xD479, 0xDBCE, 0xE370, 0xEB4F,
        0xF35B, 0xFB82, 0x03B1, 0x0BD9, 0x13E9, 0x1BCD, 0x2376, 0x2AD3, 0x31D5, 0x386C, 0x3E8A, 0x4423, 0x492A, 0x4D95, 0x5159, 0x5470,
        0x56D2, 0x587A, 0x5965, 0x5991, 0x58FE, 0x57AC, 0x559F, 0x52DA, 0x4F65, 0x4B45, 0x4685, 0x412E, 0x3B4B, 0x34EA, 0x2E17, 0x26E2,
        0x1F5A, 0x178F, 0x0F91, 0x0772, 0xFF44, 0xF717, 0xEEFD, 0xE707, 0xDF47, 0xD7CC, 0xD0A8, 0xC9E8, 0xC39D, 0xBDD2, 0xB895, 0xB3F1,
        0xAFF0, 0xAC99, 0xA9F5, 0xA809, 0xA6DA, 0xA668, 0xA6B7, 0xA7C4, 0xA98E, 0xAC11, 0xAF47, 0xB32A, 0xB7B2, 0xBCD4, 0xC285, 0xC8BA,
        0xCF65, 0xD679, 0xDDE5, 0xE599, 0xED87, 0xF59C, 0xFDC7, 0x05F6, 0x0E19, 0x161E, 0x1DF4, 0x2589, 0x2CCF, 0x33B4, 0x3A2B, 0x4026,
        0x4597, 0x4A74, 0x4EB1, 0x5246, 0x552B, 0x575A, 0x58CF, 0x5985, 0x597C, 0x58B3, 0x572D, 0x54EC, 0x51F6, 0x4E51, 0x4A04, 0x4518,
        0x3F99, 0x3992, 0x3310, 0x2C21, 0x24D3, 0x1D37, 0x155C, 0x0D53, 0x052E, 0xFCFF, 0xF4D5, 0xECC3, 0xE4DA, 0xDD2C, 0xD5C8, 0xCEBE,
        0xC81D, 0xC1F4, 0xBC50, 0xB73C, 0xB2C4, 0xAEF1, 0xABCC, 0xA95A, 0xA7A2, 0xA6A7, 0xA66B, 0xA6EE, 0xA830, 0xAA2E, 0xACE3, 0xB04A,
        0xB45C, 0xB90F, 0xBE5A, 0xC431, 0xCA88, 0xD152, 0xD87F, 0xE001, 0xE7C7, 0xEFC2, 0xF7DE, 0x000C, 0x083A, 0x1056, 0x1850, 0x2015,
        0x2796, 0x2EC3, 0x358B, 0x3BE1, 0x41B7, 0x4700, 0x4BB1, 0x4FC1, 0x5326, 0x55D9, 0x57D4, 0x5914, 0x5995, 0x5957, 0x585A, 0x56A0,
        0x542C, 0x5104, 0x4D30, 0x48B6, 0x43A0, 0x3DFA, 0x37D0, 0x312E, 0x2A23, 0x22BE, 0x1B0E, 0x1325, 0x0B13, 0x02E9, 0xFABA, 0xF295,
        0xEA8D, 0xE2B2, 0xDB17, 0xD3CA, 0xCCDC, 0xC65B, 0xC056, 0xBAD8, 0xB5EF, 0xB1A4, 0xAE00, 0xAB0C, 0xA8CD, 0xA749, 0xA683, 0xA67C,
        0xA735, 0xA8AB, 0xAADC, 0xADC3, 0xB15A, 0xB59A, 0xBA78, 0xBFEB, 0xC5E7, 0xCC60, 0xD346, 0xDA8D, 0xE223, 0xE9F9, 0xF1FF, 0xFA22,
        0x0251, 0x0A7C, 0x1291, 0x1A7E, 0x2232, 0x299D, 0x30AF, 0x3759, 0x3D8C, 0x433C, 0x485D, 0x4CE2, 0x50C3, 0x53F7, 0x5678, 0x5840,
        0x594B, 0x5997, 0x5924, 0x57F2, 0x5604, 0x535E, 0x5005, 0x4C02, 0x475C, 0x421D, 0x3C51, 0x3604, 0x2F44, 0x281E, 0x20A3, 0x18E2,
        0x10EB, 0x08D1, 0x00A3, 0xF876, 0xF057, 0xE85A, 0xE08F, 0xD908, 0xD1D4, 0xCB03, 0xC4A3, 0xBEC2, 0xB96C, 0xB4AE, 0xB090, 0xAD1D,
        0xAA5A, 0xA84F, 0xA6FF, 0xA66E, 0xA69C, 0xA78A, 0xA934, 0xAB98, 0xAEB1, 0xB278, 0xB6E4, 0xBBED, 0xC187, 0xC7A7, 0xCE3F, 0xD542,
        0xDCA0, 0xE460, 0xEC4F, 0xF45B, 0xFC73, 0x0484, 0x0C80, 0x1454, 0x1BF0, 0x2344, 0x2A41, 0x30D8, 0x36FC, 0x3CA0, 0x41BA, 0x463F,
        0x4A26, 0x4D69, 0x5000, 0x51E9, 0x531F, 0x53A2, 0x5372, 0x528F, 0x50FE, 0x4EC2, 0x4BE2, 0x4864, 0x4452, 0x3FB5, 0x3A97, 0x3505,
        0x2F0C, 0x28B8, 0x2218, 0x1B3A, 0x142F, 0x0D04, 0x05CA, 0xFE91, 0xF766, 0xF05B, 0xE97D, 0xE2DC, 0xDC84, 0xD683, 0xD0E6, 0xCBB7,
        0xC701, 0xC2CD, 0xBF23, 0xBC0A, 0xB988, 0xB7A1, 0xB659, 0xB5AF, 0xB5A6, 0xB63C, 0xB76E, 0xB939, 0xBB98, 0xBE84, 0xC1F8, 0xC5E9,
        0xCA50, 0xCF20, 0xD451, 0xD9D5, 0xDFA0, 0xE5A6, 0xEBD9, 0xF22B, 0xF88F, 0xFEF7, 0x0554, 0x0B9B, 0x11BD, 0x17AD, 0x1D60, 0x22C9,
        0x27DD, 0x2C92, 0x30DF, 0x34BB, 0x3820, 0x3B05, 0x3D67, 0x3F41, 0x4091, 0x4154, 0x418A, 0x4133, 0x4052, 0x3EE9, 0x3CFC, 0x3A91,
        0x37AE, 0x3459, 0x309B, 0x2C7D, 0x2808, 0x2347, 0x1E44, 0x190A, 0x13A6, 0x0E22, 0x088C, 0x02EE, 0xFD57, 0xF7D1, 0xF267, 0xED25,
        0xE817, 0xE346, 0xDEBD, 0xDA84, 0xD6A5, 0xD325, 0xD00D, 0xCD63, 0xCB29, 0xC966, 0xC81B, 0xC74A, 0xC6F4, 0xC719, 0xC7B7, 0xC8CC,
        0xCA55, 0xCC4D, 0xCEAF, 0xD176, 0xD499, 0xD813, 0xDBDA, 0xDFE6, 0xE42E, 0xE8A8, 0xED49, 0xF209, 0xF6DB, 0xFBB6, 0x008E, 0x055B,
        0x0A12, 0x0EA8, 0x1315, 0x174E, 0x1B4C, 0x1F07, 0x2276, 0x2594, 0x285A, 0x2AC4, 0x2CCC, 0x2E70, 0x2FAD, 0x3081, 0x30EB, 0x30EC,
        0x3084, 0x2FB5, 0x2E82, 0x2CEF, 0x2B00, 0x28B9, 0x2621, 0x233D, 0x2015, 0x1CB1, 0x1917, 0x1551, 0x1166, 0x0D60, 0x0948, 0x0526,
        0x0103, 0xFCEA, 0xF8E0, 0xF4F0, 0xF122, 0xED7D, 0xEA09, 0xE6CD, 0xE3CF, 0xE116, 0xDEA5, 0xDC82, 0xDAB1, 0xD934, 0xD80E, 0xD741,
        0xD6CD, 0xD6B2, 0xD6F0, 0xD785, 0xD86F, 0xD9AB, 0xDB36, 0xDD0C, 0xDF27, 0xE183, 0xE419, 0xE6E4, 0xE9DD, 0xECFD, 0xF03D, 0xF396,
        0xF700, 0xFA73, 0xFDE9, 0x0158, 0x04BC, 0x080B, 0x0B40, 0x0E54, 0x1140, 0x13FF, 0x168B, 0x18DF, 0x1AF7, 0x1CD0, 0x1E65, 0x1FB4,
        0x20BC, 0x217A, 0x21EF, 0x2219, 0x21FA, 0x2193, 0x20E5, 0x1FF3, 0x1EBF, 0x1D4D, 0x1BA1, 0x19BE, 0x17AB, 0x156B, 0x1305, 0x107E,
        0x0DDB, 0x0B23, 0x085C, 0x058C, 0x02B9, 0xFFEA, 0xFD24, 0xFA6D, 0xF7CB, 0xF543, 0xF2DA, 0xF096, 0xEE7B, 0xEC8C, 0xEACD, 0xE941,
        0xE7EC, 0xE6CF, 0xE5EB, 0xE543, 0xE4D6, 0xE4A5, 0xE4AF, 0xE4F4, 0xE572, 0xE626, 0xE710, 0xE82C, 0xE977, 0xEAEE, 0xEC8D, 0xEE4F,
        0xF031, 0xF22E, 0xF441, 0xF666, 0xF898, 0xFAD1, 0xFD0C, 0xFF46, 0x0178, 0x039F, 0x05B6, 0x07B8, 0x09A3, 0x0B71, 0x0D1F, 0x0EAB,
        0x1011, 0x114F, 0x1263, 0x134B, 0x1405, 0x1492, 0x14F1, 0x1520, 0x1522, 0x14F6, 0x149E, 0x141B, 0x136F, 0x129C, 0x11A4, 0x108B,
        0x0F53, 0x0DFF, 0x0C93, 0x0B12, 0x0980, 0x07E0, 0x0637, 0x0488, 0x02D7, 0x0127, 0xFF7E, 0xFDDC, 0xFC47, 0xFAC0, 0xF94D, 0xF7EF,
        0xF6A8, 0xF57C, 0xF46C, 0xF37B, 0xF2A9, 0xF1F7, 0xF168, 0xF0FB, 0xF0B0, 0xF088, 0xF082, 0xF09D, 0xF0DA, 0xF136, 0xF1AF, 0xF246,
        0xF2F7, 0xF3C0, 0xF4A0, 0xF594, 0xF699, 0xF7AD, 0xF8CD, 0xF9F6, 0xFB26, 0xFC5A, 0xFD8E, 0xFEC2, 0xFFF1, 0x0118, 0x0237, 0x034B,
        0x0451, 0x0548, 0x062D, 0x0700, 0x07BE, 0x0867, 0x08FA, 0x0975, 0x09D9, 0x0A25, 0x0A58, 0x0A74, 0x0A79, 0x0A66, 0x0A3D, 0x09FF,
        0x09AD, 0x0947, 0x08D1, 0x084A, 0x07B4, 0x0712, 0x0665, 0x05AF, 0x04F1, 0x042E, 0x0368, 0x029F, 0x01D7, 0x0111, 0x004F, 0xFF92,
        0xFEDC, 0xFE2D, 0xFD89, 0xFCEE, 0xFC60, 0xFBDE, 0xFB6A, 0xFB04, 0xFAAC, 0xFA63, 0xFA29, 0xF9FF, 0xF9E3, 0xF9D5, 0xF9D6, 0xF9E5,
        0xFA01, 0xFA2A, 0xFA5E, 0xFA9D, 0xFAE5, 0xFB36, 0xFB8F, 0xFBEF, 0xFC53, 0xFCBC, 0xFD28, 0xFD96, 0xFE05, 0xFE74, 0xFEE1, 0xFF4B,
        0xFFB3, 0x0015, 0x0074, 0x00CD, 0x0120, 0x016C, 0x01B0, 0x01EE, 0x0223, 0x0251, 0x0276, 0x0294, 0x02A9, 0x02B7, 0x02BD, 0x02BD,
        0x02B5, 0x02A7, 0x0294, 0x027B, 0x025E, 0x023C, 0x0217, 0x01EF, 0x01C5, 0x0199, 0x016D, 0x0140, 0x0113, 0x00E6, 0x00BB, 0x0092,
        0x006A, 0x0045, 0x0023, 0x0004, 0xFFE8, 0xFFCF, 0xFFBA, 0xFFA8, 0xFF99, 0xFF8D, 0xFF85, 0xFF80, 0xFF7D, 0xFF7D, 0xFF80, 0xFF85,
        0xFF8B, 0xFF93, 0xFF9C, 0xFFA6, 0xFFB1, 0xFFBB, 0xFFC6, 0xFFD0, 0xFFDA, 0xFFE3, 0xFFEB, 0xFFF2, 0xFFF8, 0xFFFC, 0xFFFF, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0005, 0x0008, 0x000A, 0x000D, 0x0011,
        0x0014, 0x0019, 0x001D, 0x0022, 0x0026, 0x002B, 0x0030, 0x0034, 0x0039, 0x003D, 0x0040, 0x0043, 0x0045, 0x0046, 0x0046, 0x0045,
        0x0043, 0x003F, 0x003A, 0x0034, 0x002C, 0x0023, 0x0018, 0x000B, 0xFFFE, 0xFFEF, 0xFFDE, 0xFFCC, 0xFFB9, 0xFFA5, 0xFF90, 0xFF7A,
        0xFF64, 0xFF4E, 0xFF39, 0xFF23, 0xFF0E, 0xFEFB, 0xFEE8, 0xFED7, 0xFEC8, 0xFEBC, 0xFEB2, 0xFEAA, 0xFEA6, 0xFEA5, 0xFEA7, 0xFEAD,
        0xFEB7, 0xFEC5, 0xFED7, 0xFEED, 0xFF08, 0xFF26, 0xFF48, 0xFF6E, 0xFF98, 0xFFC5, 0xFFF5, 0x0028, 0x005D, 0x0095, 0x00CE, 0x0108,
        0x0142, 0x017D, 0x01B6, 0x01EF, 0x0225, 0x025A, 0x028B, 0x02B8, 0x02E1, 0x0304, 0x0323, 0x033B, 0x034C, 0x0357, 0x035A, 0x0355,
        0x0349, 0x0334, 0x0316, 0x02F0, 0x02C2, 0x028B, 0x024C, 0x0206, 0x01B7, 0x0162, 0x0106, 0x00A4, 0x003D, 0xFFD3, 0xFF64, 0xFEF2,
        0xFE7F, 0xFE0B, 0xFD97, 0xFD24, 0xFCB5, 0xFC48, 0xFBE1, 0xFB7F, 0xFB24, 0xFAD1, 0xFA88, 0xFA48, 0xFA13, 0xF9EA, 0xF9CE, 0xF9BE,
        0xF9BD, 0xF9C9, 0xF9E4, 0xFA0E, 0xFA46, 0xFA8D, 0xFAE3, 0xFB47, 0xFBB8, 0xFC36, 0xFCC1, 0xFD57, 0xFDF8, 0xFEA1, 0xFF53, 0x000A,
        0x00C8, 0x0188, 0x024B, 0x030F, 0x03D0, 0x048F, 0x0548, 0x05FB, 0x06A5, 0x0745, 0x07D8, 0x085F, 0x08D5, 0x093C, 0x0990, 0x09D1,
        0x09FF, 0x0A16, 0x0A19, 0x0A04, 0x09D9, 0x0997, 0x093E, 0x08CE, 0x0849, 0x07AD, 0x06FD, 0x0639, 0x0562, 0x047B, 0x0384, 0x0280,
        0x0170, 0x0057, 0xFF37, 0xFE12, 0xFCEA, 0xFBC3, 0xFA9E, 0xF97F, 0xF868, 0xF75B, 0xF65C, 0xF56C, 0xF48E, 0xF3C5, 0xF313, 0xF279,
        0xF1FA, 0xF197, 0xF152, 0xF12B, 0xF125, 0xF13F, 0xF17A, 0xF1D6, 0xF253, 0xF2F1, 0xF3AF, 0xF48C, 0xF586, 0xF69C, 0xF7CC, 0xF914,
        0xFA72, 0xFBE3, 0xFD64, 0xFEF2, 0x0089, 0x0227, 0x03C9, 0x056B, 0x0708, 0x089D, 0x0A28, 0x0BA3, 0x0D0C, 0x0E5F, 0x0F98, 0x10B5,
        0x11B3, 0x128F, 0x1346, 0x13D6, 0x143D, 0x1479, 0x148A, 0x146F, 0x1426, 0x13B0, 0x130D, 0x123D, 0x1142, 0x101D, 0x0ED0, 0x0D5D,
        0x0BC6, 0x0A0F, 0x083B, 0x064C, 0x0448, 0x0232, 0x000E, 0xFDE3, 0xFBB1, 0xF980, 0xF755, 0xF533, 0xF31F, 0xF120, 0xEF38, 0xED6E,
        0xEBC5, 0xEA41, 0xE8E6, 0xE7B9, 0xE6BB, 0xE5F1, 0xE55C, 0xE4FF, 0xE4DB, 0xE4F2, 0xE544, 0xE5D2, 0xE69B, 0xE79E, 0xE8D9, 0xEA4C,
        0xEBF4, 0xEDCE, 0xEFD6, 0xF209, 0xF462, 0xF6DE, 0xF977, 0xFC27, 0xFEEA, 0x01B9, 0x048F, 0x0765, 0x0A36, 0x0CFB, 0x0FAD, 0x1247,
        0x14C3, 0x171B, 0x1949, 0x1B48, 0x1D12, 0x1EA4, 0x1FF8, 0x210C, 0x21DC, 0x2266, 0x22A6, 0x229C, 0x2247, 0x21A7, 0x20BB, 0x1F85,
        0x1E07, 0x1C42, 0x1A3A, 0x17F3, 0x156F, 0x12B5, 0x0FC9, 0x0CB2, 0x0974, 0x0617, 0x02A2, 0xFF1D, 0xFB8E, 0xF7FC, 0xF470, 0xF0F2,
        0xED89, 0xEA3D, 0xE716, 0xE41A, 0xE152, 0xDEC3, 0xDC74, 0xDA6B, 0xD8AC, 0xD73E, 0xD623, 0xD55F, 0xD4F6, 0xD4E8, 0xD537, 0xD5E4,
        0xD6EF, 0xD855, 0xDA16, 0xDC2E, 0xDE99, 0xE155, 0xE45B, 0xE7A6, 0xEB30, 0xEEF1, 0xF2E2, 0xF6FC, 0xFB35, 0xFF85, 0x03E2, 0x0844,
        0x0CA1, 0x10F0, 0x1527, 0x193C, 0x1D26, 0x20DD, 0x2457, 0x278D, 0x2A76, 0x2D0C, 0x2F48, 0x3124, 0x329B, 0x33A9, 0x344A, 0x347C,
        0x343D, 0x338C, 0x326A, 0x30D8, 0x2ED8, 0x2C6D, 0x299B, 0x2668, 0x22D9, 0x1EF5, 0x1AC4, 0x164D, 0x119A, 0x0CB4, 0x07A5, 0x0278,
        0xFD39, 0xF7F1, 0xF2AD, 0xED77, 0xE85B, 0xE365, 0xDE9F, 0xDA15, 0xD5D1, 0xD1DC, 0xCE41, 0xCB08, 0xC839, 0xC5DB, 0xC3F5, 0xC28B,
        0xC1A2, 0xC13E, 0xC160, 0xC209, 0xC33A, 0xC4F1, 0xC72C, 0xC9E8, 0xCD1F, 0xD0CC, 0xD4E8, 0xD96B, 0xDE4D, 0xE384, 0xE905, 0xEEC6,
        0xF4BA, 0xFAD5, 0x0109, 0x074C, 0x0D8E, 0x13C2, 0x19DA, 0x1FCA, 0x2584, 0x2AFA, 0x3021, 0x34ED, 0x3952, 0x3D46, 0x40BF, 0x43B5,
        0x4620, 0x47FA, 0x493C, 0x49E4, 0x49EE, 0x4959, 0x4824, 0x4650, 0x43E1, 0x40DA, 0x3D40, 0x3919, 0x346E, 0x2F47, 0x29AE, 0x23AE,
        0x1D53, 0x16AB, 0x0FC3, 0x08A8, 0x016B, 0xFA1C, 0xF2C7, 0xEB7F, 0xE452, 0xDD50, 0xD68A, 0xD00E, 0xC9EA, 0xC42E, 0xBEE5, 0xBA1D,
        0xB5E1, 0xB23B, 0xAF35, 0xACD7, 0xAB26, 0xAA28, 0xA9E1, 0xAA54, 0xAB7F, 0xAD63, 0xAFFE, 0xB34A, 0xB743, 0xBBE1, 0xC11C, 0xC6E9,
        0xCD74, 0xD46C, 0xDBC0, 0xE362, 0xEB41, 0xF34C, 0xFB73, 0x03A2, 0x0BCB, 0x13DA, 0x1BBF, 0x2368, 0x2AC6, 0x31C9, 0x3860, 0x3E80,
        0x4419, 0x4921, 0x4D8D, 0x5153, 0x546B, 0x56CE, 0x5878, 0x5964, 0x5992, 0x5900, 0x57AF, 0x55A3, 0x52E0, 0x4F6C, 0x4B4D, 0x468E,
        0x4138, 0x3B56, 0x34F6, 0x2E24, 0x26F0, 0x1F68, 0x179D, 0x0FA0, 0x0781, 0xFF53, 0xF726, 0xEF0C, 0xE715, 0xDF54, 0xD7D9, 0xD0B4,
        0xC9F4, 0xC3A8, 0xBDDC, 0xB89E, 0xB3F9, 0xAFF6, 0xAC9F, 0xA9FA, 0xA80C, 0xA6DB, 0xA669, 0xA6B6, 0xA7C1, 0xA98A, 0xAC0C, 0xAF41,
        0xB323, 0xB7A9, 0xBCCA, 0xC27A, 0xC8AE, 0xCF59, 0xD66B, 0xDDD7, 0xE58B, 0xED78, 0xF58D, 0xFDB8, 0x05E7, 0x0E0A, 0x160F, 0x1DE6,
        0x257C, 0x2CC2, 0x33A8, 0x3A20, 0x401B, 0x458E, 0x4A6B, 0x4EAA, 0x5240, 0x5527, 0x5757, 0x58CD, 0x5984, 0x597C, 0x58B5, 0x5730,
        0x54F1, 0x51FC, 0x4E58, 0x4A0C, 0x4522, 0x3FA4, 0x399E, 0x331D, 0x2C2E, 0x24E1, 0x1D45, 0x156A, 0x0D62, 0x053D, 0xFD0E, 0xF4E4,
        0xECD2, 0xE4E9, 0xDD3A, 0xD5D5, 0xCECA, 0xC829, 0xC1FF, 0xBC5A, 0xB745, 0xB2CC, 0xAEF8, 0xABD1, 0xA95E, 0xA7A5, 0xA6A8, 0xA66B,
        0xA6ED, 0xA82D, 0xAA2A, 0xACDE, 0xB044, 0xB454, 0xB906, 0xBE50, 0xC426, 0xCA7C, 0xD145, 0xD872, 0xDFF3, 0xE7B9, 0xEFB3, 0xF7CF,
        0xFFFE, 0x082B, 0x1047, 0x1841, 0x2007, 0x2789, 0x2EB6, 0x357F, 0x3BD6, 0x41AC, 0x46F7, 0x4BA9, 0x4FBA, 0x5320, 0x55D5, 0x57D1,
        0x5913, 0x5995, 0x5958, 0x585C, 0x56A3, 0x5431, 0x510B, 0x4D37, 0x48BF, 0x43AA, 0x3E05, 0x37DC, 0x313B, 0x2A30, 0x22CC, 0x1B1D,
        0x1334, 0x0B22, 0x02F8, 0xFAC9, 0xF2A4, 0xEA9B, 0xE2C1, 0xDB24, 0xD3D7, 0xCCE8, 0xC667, 0xC060, 0xBAE2, 0xB5F7, 0xB1AB, 0xAE06,
        0xAB11, 0xA8D1, 0xA74C, 0xA684, 0xA67C, 0xA733, 0xA8A8, 0xAAD8, 0xADBD, 0xB153, 0xB591, 0xBA6F, 0xBFE1, 0xC5DC, 0xCC53, 0xD339,
        0xDA7F, 0xE215, 0xE9EB, 0xF1F0, 0xFA13, 0x0242, 0x0A6D, 0x1282, 0x1A6F, 0x2224, 0x2990, 0x30A2, 0x374D, 0x3D82, 0x4333, 0x4854,
        0x4CDA, 0x50BD, 0x53F2, 0x5674, 0x583E, 0x594A, 0x5998, 0x5925, 0x57F5, 0x5608, 0x5363, 0x500C, 0x4C0A, 0x4765, 0x4227, 0x3C5C,
        0x3610, 0x2F51, 0x282C, 0x20B1, 0x18F0, 0x10FA, 0x08E0, 0x00B2, 0xF885, 0xF066, 0xE868, 0xE09D, 0xD915, 0xD1E1, 0xCB0F, 0xC4AE,
        0xBECC, 0xB975, 0xB4B6, 0xB097, 0xAD22, 0xAA5F, 0xA852, 0xA701, 0xA66E, 0xA69B, 0xA787, 0xA930, 0xAB93, 0xAEAB, 0xB270, 0xB6DB,
        0xBBE3, 0xC17C, 0xC79B, 0xCE33, 0xD535, 0xDC92, 0xE43C, 0xEC20, 0xF430, 0xFC58, 0x0488, 0x0CAE, 0x14BA, 0x1C99, 0x243B, 0x2B8F,
        0x3287, 0x3912, 0x3F23, 0x44AE, 0x49A5, 0x4DFF, 0x51B2, 0x54B7, 0x5706, 0x589B, 0x5973, 0x598B, 0x58E4, 0x577F, 0x555F, 0x5288,
        0x4F00, 0x4AD0, 0x4600, 0x409A, 0x3AAA, 0x343C, 0x2D5F, 0x2621, 0x1E91, 0x16BF, 0x0EBE, 0x069C, 0xFE6E, 0xF642, 0xEE2A, 0xE639,
        0xDE7F, 0xD70D, 0xCFF2, 0xC93E, 0xC2FF, 0xBD42, 0xB815, 0xB381, 0xAF90, 0xAC4C, 0xA9BB, 0xA7E2, 0xA6C5, 0xA668, 0xA6CA, 0xA7EA,
        0xA9C8, 0xAC5D, 0xAFA5, 0xB39A, 0xB831, 0xBD62, 0xC322, 0xC964, 0xD01A, 0xD737, 0xDEAB, 0xE667, 0xEE59, 0xF671, 0xFE9E, 0x06CC,
        0x0EED, 0x16EE, 0x1EBE, 0x264C, 0x2D88, 0x3463, 0x3ACE, 0x40BB, 0x461E, 0x4AEA, 0x4F17, 0x529A, 0x556D, 0x5789, 0x58EA, 0x598D,
        0x5970, 0x5894, 0x56FA, 0x54A7, 0x519E, 0x4DE7, 0x498A, 0x448F, 0x3F01, 0x38ED, 0x325F, 0x2B66, 0x240F, 0x1C6B, 0x148B, 0x0C7F,
        0x0458, 0xFC28, 0xF400, 0xEBF2, 0xE40E, 0xDC66, 0xD50B, 0xCE0B, 0xC776, 0xC15A, 0xBBC4, 0xB6C0, 0xB258, 0xAE97, 0xAB83, 0xA925,
        0xA780, 0xA698, 0xA670, 0xA707, 0xA85C, 0xAA6D, 0xAD34, 0xB0AD, 0xB4D0, 0xB993, 0xBEED, 0xC4D2, 0xCB35, 0xD20A, 0xD941, 0xE0CA,
        0xE896, 0xF095, 0xF8B4, 0x00E2, 0x090F, 0x1129, 0x191E, 0x20DD, 0x2857, 0x2F79, 0x3637, 0x3C80, 0x4248, 0x4782, 0x4C23, 0x5022,
        0x5375, 0x5615, 0x57FE, 0x592A, 0x5998, 0x5946, 0x5835, 0x5668, 0x53E1, 0x50A8, 0x4CC2, 0x4838, 0x4313, 0x3D5F, 0x3727, 0x307A,
        0x2965, 0x21F8, 0x1A41, 0x1253, 0x0A3E, 0x0212, 0xF9E4, 0xF1C1, 0xE9BD, 0xE1E8, 0xDA54, 0xD310, 0xCC2C, 0xC5B7, 0xBFBF, 0xBA50,
        0xB577, 0xB13C, 0xADAB, 0xAAC9, 0xA89D, 0xA72C, 0xA67A, 0xA686, 0xA752, 0xA8DC, 0xAB20, 0xAE1A, 0xB1C2, 0xB612, 0xBB00, 0xC082,
        0xC68B, 0xCD10, 0xD401, 0xDB50, 0xE2EE, 0xEACA, 0xF2D3, 0xFAF9, 0x0328, 0x0B51, 0x1363, 0x1B4A, 0x22F8, 0x2A5B, 0x3163, 0x3801,
        0x3E28, 0x43CA, 0x48DA, 0x4D50, 0x511F, 0x5441, 0x56AF, 0x5864, 0x595C, 0x5994, 0x590D, 0x57C8, 0x55C7, 0x530E, 0x4FA4, 0x4B8F,
        0x46D9, 0x418C, 0x3BB2, 0x3558, 0x2E8D, 0x275E, 0x1FDB, 0x1813, 0x1018, 0x07FB, 0xFFCE, 0xF7A0, 0xEF84, 0xE78B, 0xDFC6, 0xD847,
        0xD11C, 0xCA56, 0xC402, 0xBE2F, 0xB8E9, 0xB43A, 0xB02E, 0xACCC, 0xAA1C, 0xA824, 0xA6E8, 0xA66A, 0xA6AC, 0xA7AD, 0xA96A, 0xABE1,
        0xAF0C, 0xB2E4, 0xB761, 0xBC79, 0xC221, 0xC84E, 0xCEF2, 0xD5FF, 0xDD66, 0xE516, 0xED01, 0xF514, 0xFD3E, 0x056D, 0x0D91, 0x1599,
        0x1D72, 0x250C, 0x2C58, 0x3344, 0x39C2, 0x3FC6, 0x4540, 0x4A27, 0x4E6F, 0x520F, 0x5500, 0x573B, 0x58BC, 0x597F, 0x5982, 0x58C6,
        0x574C, 0x5518, 0x522D, 0x4E93, 0x4A51, 0x456F, 0x3FFA, 0x39FB, 0x3381, 0x2C98, 0x2550, 0x1DB8, 0x15E1, 0x0DDB, 0x05B7, 0xFD88,
        0xF55D, 0xED49, 0xE55D, 0xDDAA, 0xD641, 0xCF31, 0xC889, 0xC257, 0xBCAA, 0xB78D, 0xB30A, 0xAF2C, 0xABFB, 0xA97E, 0xA7B9, 0xA6B2,
        0xA669, 0xA6E0, 0xA815, 0xAA07, 0xACB0, 0xB00C, 0xB413, 0xB8BB, 0xBDFD, 0xC3CB, 0xCA1B, 0xD0DD, 0xD804, 0xDF81, 0xE743, 0xEF3B,
        0xF756, 0xFF83, 0x07B1, 0x0FCF, 0x17CC, 0x1F95, 0x271B, 0x2E4D, 0x351D, 0x3B7A, 0x4159, 0x46AC, 0x4B67, 0x4F82, 0x52F2, 0x55B1,
        0x57B9, 0x5905, 0x5993, 0x5961, 0x5870, 0x56C2, 0x545B, 0x513F, 0x4D75, 0x4906, 0x43FA, 0x3E5D, 0x383B, 0x31A1, 0x2A9C, 0x233C,
        0x1B91, 0x13AB, 0x0B9B, 0x0372, 0xFB43, 0xF31D, 0xEB12, 0xE334, 0xDB94, 0xD442, 0xCD4D, 0xC6C4, 0xC0B6, 0xBB30, 0xB63C, 0xB1E7,
        0xAE38, 0xAB38, 0xA8ED, 0xA75D, 0xA68A, 0xA677, 0xA723, 0xA88D, 0xAAB2, 0xAD8D, 0xB119, 0xB54E, 0xBA22, 0xBF8B, 0xC57F, 0xCBF0,
        0xD2D0, 0xDA10, 0xE1A2, 0xE974, 0xF177, 0xF999, 0x01C8, 0x09F4, 0x120A, 0x19FA, 0x21B3, 0x2923, 0x303B, 0x36ED, 0x3D28, 0x42E1,
        0x480B, 0x4C9B, 0x5087, 0x53C7, 0x5654, 0x5828, 0x5940, 0x5998, 0x5931, 0x580C, 0x562A, 0x5390, 0x5043, 0x4C4A, 0x47AF, 0x427A,
        0x3CB7, 0x3672, 0x2FB8, 0x2899, 0x2123, 0x1966, 0x1172, 0x0959, 0x012D, 0xF8FE, 0xF0DE, 0xE8DE, 0xE110, 0xD984, 0xD24A, 0xCB72,
        0xC50A, 0xBF20, 0xB9C1, 0xB4F8, 0xB0D0, 0xAD51, 0xAA83, 0xA86C, 0xA710, 0xA672, 0xA693, 0xA774, 0xA913, 0xAB6B, 0xAE78, 0xB233,
        0xB695, 0xBB94, 0xC125, 0xC73C, 0xCDCD, 0xD4C9, 0xDC22, 0xE3C8, 0xEBA9, 0xF3B6, 0xFBDE, 0x040D, 0x0C35, 0x1443, 0x1C25, 0x23CB,
        0x2B24, 0x3222, 0x38B4, 0x3ECC, 0x445F, 0x495F, 0x4DC3, 0x5180, 0x548E, 0x56E8, 0x5889, 0x596B, 0x598F, 0x58F3, 0x5799, 0x5583,
        0x52B7, 0x4F3A, 0x4B13, 0x464C, 0x40EE, 0x3B06, 0x349F, 0x2DC8, 0x268F, 0x1F04, 0x1736, 0x0F36, 0x0716, 0xFEE8, 0xF6BB, 0xEEA2,
        0xE6AE, 0xDEF1, 0xD77A, 0xD059, 0xC99F, 0xC359, 0xBD94, 0xB85E, 0xB3C1, 0xAFC6, 0xAC78, 0xA9DC, 0xA7F8, 0xA6D1, 0xA668, 0xA6BF,
        0xA7D4, 0xA9A7, 0xAC31, 0xAF70, 0xB35A, 0xB7E8, 0xBD11, 0xC2C8, 0xC903, 0xCFB3, 0xD6CB, 0xDE3A, 0xE5F2, 0xEDE1, 0xF5F8, 0xFE23,
        0x0652, 0x0E74, 0x1677, 0x1E4B, 0x25DD, 0x2D1F, 0x3400, 0x3A71, 0x4066, 0x45D1, 0x4AA7, 0x4EDD, 0x526B, 0x5548, 0x576F, 0x58DB,
        0x5988, 0x5977, 0x58A6, 0x5717, 0x54CF, 0x51D1, 0x4E24, 0x49CF, 0x44DD, 0x3F58, 0x394B, 0x32C4, 0x2BD0, 0x247F, 0x1CDF, 0x1502,
        0x0CF8, 0x04D2, 0xFCA3, 0xF479, 0xEC69, 0xE482, 0xDCD7, 0xD576, 0xCE71, 0xC7D5, 0xC1B2, 0xBC13, 0xB706, 0xB295, 0xAECA, 0xABAC,
        0xA943, 0xA793, 0xA6A0, 0xA66D, 0xA6F9, 0xA843, 0xAA49, 0xAD06, 0xB075, 0xB48D, 0xB948, 0xBE99, 0xC476, 0xCAD3, 0xD1A1, 0xD8D2,
        0xE058, 0xE820, 0xF01C, 0xF83A, 0x0068, 0x0896, 0x10B1, 0x18A9, 0x206C, 0x27E9, 0x2F11, 0x35D5, 0x3C25, 0x41F5, 0x4738, 0x4BE2,
        0x4FEB, 0x5348, 0x55F3, 0x57E7, 0x591E, 0x5997, 0x5950, 0x584A, 0x5688, 0x540C, 0x50DD, 0x4D01, 0x4880, 0x4364, 0x3DB8, 0x3788,
        0x30E1, 0x29D1, 0x2269, 0x1AB6, 0x12CB, 0x0AB7, 0x028D, 0xFA5E, 0xF23A, 0xEA33, 0xE25B, 0xDAC3, 0xD37A, 0xCC90, 0xC615, 0xC015,
        0xBA9E, 0xB5BB, 0xB177, 0xADDB, 0xAAEF, 0xA8B8, 0xA73D, 0xA67F, 0xA680, 0xA741, 0xA8C0, 0xAAF9, 0xADE8, 0xB187, 0xB5CD, 0xBAB2,
        0xC02C, 0xC62E, 0xCCAB, 0xD396, 0xDAE1, 0xE27A, 0xEA53, 0xF25A, 0xFA7E, 0x02AE, 0x0AD8, 0x12EB, 0x1AD6, 0x2287, 0x29EF, 0x30FC,
        0x37A1, 0x3DD0, 0x4379, 0x4893, 0x4D11, 0x50EB, 0x5418, 0x5690, 0x5850, 0x5953, 0x5996, 0x591A, 0x57E0, 0x55EA, 0x533C, 0x4FDC,
        0x4BD1, 0x4724, 0x41DF, 0x3C0D, 0x35BB, 0x2EF5, 0x27CC, 0x204D, 0x1889, 0x1091, 0x0875, 0x0047, 0xF81A, 0xEFFC, 0xE801, 0xE039,
        0xD8B5, 0xD185, 0xCAB8, 0xC45E, 0xBE82, 0xB933, 0xB47C, 0xB066, 0xACFA, 0xAA3F, 0xA83C, 0xA6F5, 0xA66C, 0xA6A3, 0xA798, 0xA94B,
        0xABB8, 0xAED8, 0xB2A6, 0xB719, 0xBC29, 0xC1C9, 0xC7EF, 0xCE8C, 0xD593, 0xDCF5, 0xE4A2, 0xEC89, 0xF49A, 0xFCC3, 0x04F3, 0x0D18,
        0x1522, 0x1CFF, 0x249D, 0x2BED, 0x32DF, 0x3965, 0x3F6F, 0x44F3, 0x49E2, 0x4E34, 0x51DE, 0x54D9, 0x571F, 0x58AB, 0x5979, 0x5987,
        0x58D6, 0x5767, 0x553E, 0x525E, 0x4ECD, 0x4A95, 0x45BD, 0x404F, 0x3A58, 0x33E5, 0x2D02, 0x25BF, 0x1E2C, 0x1658, 0x0E54, 0x0631,
        0xFE02, 0xF5D7, 0xEDC1, 0xE5D2, 0xDE1C, 0xD6AD, 0xCF97, 0xC8E9, 0xC2B0, 0xBCFB, 0xB7D5, 0xB349, 0xAF61, 0xAC26, 0xA99E, 0xA7CE,
        0xA6BC, 0xA668, 0xA6D4, 0xA7FE, 0xA9E5, 0xAC84, 0xAFD5, 0xB3D2, 0xB872, 0xBDAA, 0xC371, 0xC9B9, 0xD075, 0xD797, 0xDF0F, 0xE6CE,
        0xEEC3, 0xF6DC, 0xFF09, 0x0737, 0x0F57, 0x1756, 0x1F22, 0x26AD, 0x2DE4, 0x34BA, 0x3B1F, 0x4105, 0x4660, 0x4B25, 0x4F49, 0x52C4,
        0x558D, 0x57A0, 0x58F7, 0x5990, 0x5969, 0x5883, 0x56E0, 0x5484, 0x5172, 0x4DB2, 0x494C, 0x444A, 0x3EB5, 0x389A, 0x3206, 0x2B07,
        0x23AD, 0x1C06, 0x1422, 0x0C14, 0x03EC, 0xFBBD, 0xF396, 0xEB89, 0xE3A8, 0xDC04, 0xD4AD, 0xCDB2, 0xC723, 0xC10D, 0xBB7E, 0xB682,
        0xB223, 0xAE6A, 0xAB60, 0xA90B, 0xA76F, 0xA691, 0xA673, 0xA714, 0xA873, 0xAA8D, 0xAD5E, 0xB0DF, 0xB50A, 0xB9D6, 0xBF37, 0xC523,
        0xCB8C, 0xD266, 0xD9A1, 0xE12F, 0xE8FE, 0xF0FF, 0xF91F, 0x014E, 0x097A, 0x1192, 0x1985, 0x2141, 0x28B6, 0x2FD4, 0x368C, 0x3CCF,
        0x4290, 0x47C2, 0x4C5C, 0x5051, 0x539C, 0x5633, 0x5812, 0x5934, 0x5998, 0x593D, 0x5822, 0x564B, 0x53BB, 0x5079, 0x4C8A, 0x47F8,
        0x42CB, 0x3D10, 0x36D3, 0x3020, 0x2906, 0x2194, 0x19DB, 0x11EA, 0x09D3, 0x01A7, 0xF978, 0xF157, 0xE955, 0xE183, 0xD9F2, 0xD2B3,
        0xCBD5, 0xC566, 0xBF75, 0xBA0D, 0xB53B, 0xB109, 0xAD80, 0xAAA8, 0xA886, 0xA71F, 0xA676, 0xA68C, 0xA762, 0xA8F5, 0xAB43, 0xAE45,
        0xB1F7, 0xB64F, 0xBB45, 0xC0CE, 0xC6DE, 0xCD68, 0xD45E, 0xDBB2, 0xE354, 0xEB32, 0xF33D, 0xFB64, 0x0393, 0x0BBC, 0x13CB, 0x1BB1,
        0x235B, 0x2AB9, 0x31BC, 0x3855, 0x3E75, 0x4410, 0x4919, 0x4D86, 0x514D, 0x5466, 0x56CA, 0x5875, 0x5963, 0x5992, 0x5901, 0x57B2,
        0x55A8, 0x52E6, 0x4F73, 0x4B56, 0x4697, 0x4142, 0x3B62, 0x3502, 0x2E31, 0x26FD, 0x1F76, 0x17AC, 0x0FAF, 0x0790, 0xFF62, 0xF735,
        0xEF1A, 0xE724, 0xDF62, 0xD7E7, 0xD0C1, 0xCA00, 0xC3B3, 0xBDE7, 0xB8A8, 0xB401, 0xAFFD, 0xACA4, 0xA9FE, 0xA80F, 0xA6DD, 0xA669,
        0xA6B4, 0xA7BF, 0xA986, 0xAC07, 0xAF3A, 0xB31B, 0xB7A0, 0xBCC0, 0xC26F, 0xC8A3, 0xCF4C, 0xD65E, 0xDDC9, 0xE57D, 0xED6A, 0xF57E,
        0xFDA9, 0x05D8, 0x0DFB, 0x1601, 0x1DD7, 0x256E, 0x2CB5, 0x339C, 0x3A14, 0x4011, 0x4584, 0x4A63, 0x4EA3, 0x523A, 0x5522, 0x5754,
        0x58CB, 0x5984, 0x597D, 0x58B7, 0x5734, 0x54F6, 0x5202, 0x4E5F, 0x4A14, 0x452B, 0x3FAE, 0x39A9, 0x3329, 0x2C3B, 0x24EE, 0x1D53,
        0x1579, 0x0D71, 0x054C, 0xFD1D, 0xF4F3, 0xECE0, 0xE4F7, 0xDD47, 0xD5E2, 0xCED7, 0xC835, 0xC20A, 0xBC63, 0xB74E, 0xB2D3, 0xAEFE,
        0xABD6, 0xA962, 0xA7A7, 0xA6A9, 0xA66A, 0xA6EB, 0xA82A, 0xAA26, 0xACD8, 0xB03D, 0xB44C, 0xB8FD, 0xBE46, 0xC41B, 0xCA70, 0xD138,
        0xD865, 0xDFE5, 0xE7AB, 0xEFA4, 0xF7C1, 0xFFEF, 0x081C, 0x1039, 0x1833, 0x1FF9, 0x277B, 0x2EA9, 0x3573, 0x3BCA, 0x41A2, 0x46ED,
        0x4BA1, 0x4FB3, 0x531B, 0x55D0, 0x57CF, 0x5911, 0x5995, 0x5959, 0x585F, 0x56A7, 0x5436, 0x5111, 0x4D3F, 0x48C7, 0x43B4, 0x3E10,
        0x37E7, 0x3147, 0x2A3D, 0x22D9, 0x1B2B, 0x1342, 0x0B31, 0x0307, 0xFAD8, 0xF2B3, 0xEAAA, 0xE2CF, 0xDB32, 0xD3E4, 0xCCF4, 0xC672,
        0xC06B, 0xBAEB, 0xB600, 0xB1B2, 0xAE0C, 0xAB15, 0xA8D4, 0xA74E, 0xA685, 0xA67B, 0xA731, 0xA8A4, 0xAAD3, 0xADB8, 0xB14C, 0xB589,
        0xBA65, 0xBFD6, 0xC5D0, 0xCC47, 0xD32C, 0xDA71, 0xE207, 0xE9DC, 0xF1E1, 0xFA04, 0x0233, 0x0A5E, 0x1273, 0x1A61, 0x2216, 0x2982,
        0x3096, 0x3741, 0x3D77, 0x4329, 0x484B, 0x4CD3, 0x50B6, 0x53ED, 0x5670, 0x583B, 0x5949, 0x5998, 0x5927, 0x57F8, 0x560C, 0x5369,
        0x5013, 0x4C12, 0x476E, 0x4232, 0x3C67, 0x361C, 0x2F5D, 0x2839, 0x20BF, 0x18FF, 0x1109, 0x08EF, 0x00C1, 0xF893, 0xF074, 0xE877,
        0xE0AB, 0xD923, 0xD1ED, 0xCB1B, 0xC4B9, 0xBED6, 0xB97F, 0xB4BE, 0xB09E, 0xAD28, 0xAA63, 0xA855, 0xA703, 0xA66F, 0xA69A, 0xA785,
        0xA92D, 0xAB8E, 0xAEA4, 0xB269, 0xB6D3, 0xBBD9, 0xC171, 0xC790, 0xCE26, 0xD528, 0xDC85, 0xE42D, 0xEC12, 0xF421, 0xFC49, 0x0479,
        0x0C9F, 0x14AB, 0x1C8B, 0x242D, 0x2B82, 0x327A, 0x3907, 0x3F19, 0x44A4, 0x499D, 0x4DF8, 0x51AC, 0x54B2, 0x5702, 0x5899, 0x5972,
        0x598C, 0x58E6, 0x5782, 0x5563, 0x528D, 0x4F07, 0x4AD8, 0x4609, 0x40A4, 0x3AB5, 0x3448, 0x2D6C, 0x262E, 0x1E9F, 0x16CE, 0x0ECC,
        0x06AB, 0xFE7D, 0xF650, 0xEE39, 0xE647, 0xDE8D, 0xD71A, 0xCFFE, 0xC94A, 0xC30A, 0xBD4C, 0xB81D, 0xB388, 0xAF97, 0xAC51, 0xA9BF,
        0xA7E4, 0xA6C7, 0xA668, 0xA6C8, 0xA7E8, 0xA9C3, 0xAC58, 0xAF9F, 0xB392, 0xB828, 0xBD58, 0xC317, 0xC958, 0xD00E, 0xD72A, 0xDE9E,
        0xE659, 0xEE4B, 0xF662, 0xFE8F, 0x06BD, 0x0EDE, 0x16DF, 0x1EB0, 0x263E, 0x2D7B, 0x3457, 0x3AC3, 0x40B1, 0x4614, 0x4AE2, 0x4F10,
        0x5294, 0x5568, 0x5786, 0x58E8, 0x598C, 0x5971, 0x5896, 0x56FE, 0x54AC, 0x51A5, 0x4DEF, 0x4992, 0x4499, 0x3F0C, 0x38F9, 0x326C,
        0x2B73, 0x241D, 0x1C7A, 0x149A, 0x0C8E, 0x0467, 0xFC37, 0xF40F, 0xEC00, 0xE41C, 0xDC74, 0xD518, 0xCE17, 0xC782, 0xC165, 0xBBCD,
        0xB6C8, 0xB260, 0xAE9D, 0xAB88, 0xA928, 0xA782, 0xA699, 0xA66F, 0xA705, 0xA859, 0xAA68, 0xAD2F, 0xB0A6, 0xB4C8, 0xB98A, 0xBEE2,
        0xC4C7, 0xCB29, 0xD1FD, 0xD933, 0xE0BC, 0xE888, 0xF086, 0xF8A5, 0x00D3, 0x0901, 0x111A, 0x1910, 0x20D0, 0x2849, 0x2F6D, 0x362B,
        0x3C75, 0x423E, 0x4779, 0x4C1B, 0x501B, 0x536F, 0x5611, 0x57FB, 0x5929, 0x5998, 0x5947, 0x5838, 0x566C, 0x53E7, 0x50AE, 0x4CC9,
        0x4840, 0x431D, 0x3D6A, 0x3733, 0x3087, 0x2972, 0x2205, 0x1A50, 0x1262, 0x0A4D, 0x0221, 0xF9F2, 0xF1D0, 0xE9CB, 0xE1F6, 0xDA61,
        0xD31D, 0xCC38, 0xC5C3, 0xBFCA, 0xBA5A, 0xB57F, 0xB144, 0xADB0, 0xAACD, 0xA8A0, 0xA72E, 0xA67A, 0xA686, 0xA750, 0xA8D9, 0xAB1B,
        0xAE13, 0xB1BB, 0xB60A, 0xBAF7, 0xC077, 0xC680, 0xCD03, 0xD3F4, 0xDB42, 0xE2E0, 0xEABB, 0xF2C4, 0xFAEA, 0x0319, 0x0B42, 0x1354,
        0x1B3C, 0x22EA, 0x2A4D, 0x3156, 0x37F5, 0x3E1D, 0x43C0, 0x48D2, 0x4D48, 0x5119, 0x543C, 0x56AC, 0x5862, 0x595B, 0x5995, 0x590F,
        0x57CB, 0x55CB, 0x5314, 0x4FAB, 0x4B97, 0x46E2, 0x4196, 0x3BBD, 0x3564, 0x2E9A, 0x276B, 0x1FE9, 0x1822, 0x1027, 0x080A, 0xFFDD,
        0xF7AF, 0xEF92, 0xE799, 0xDFD4, 0xD854, 0xD129, 0xCA62, 0xC40E, 0xBE39, 0xB8F2, 0xB442, 0xB034, 0xACD1, 0xAA20, 0xA827, 0xA6E9,
        0xA66A, 0xA6AB, 0xA7AA, 0xA967, 0xABDC, 0xAF06, 0xB2DC, 0xB758, 0xBC6F, 0xC217, 0xC843, 0xCEE6, 0xD5F2, 0xDD58, 0xE508, 0xECF2,
        0xF505, 0xFD2F, 0x055E, 0x0D83, 0x158A, 0x1D64, 0x24FF, 0x2C4B, 0x3338, 0x39B7, 0x3FBB, 0x4537, 0x4A1F, 0x4E68, 0x5209, 0x54FC,
        0x5738, 0x58BA, 0x597E, 0x5983, 0x58C8, 0x5750, 0x551C, 0x5233, 0x4E9A, 0x4A59, 0x4579, 0x4004, 0x3A07, 0x338D, 0x2CA5, 0x255E,
        0x1DC6, 0x15F0, 0x0DEA, 0x05C6, 0xFD97, 0xF56C, 0xED58, 0xE56C, 0xDDB8, 0xD64E, 0xCF3D, 0xC894, 0xC262, 0xBCB4, 0xB795, 0xB312,
        0xAF33, 0xAC00, 0xA982, 0xA7BC, 0xA6B3, 0xA669, 0xA6DE, 0xA813, 0xAA03, 0xACAB, 0xB005, 0xB40B, 0xB8B2, 0xBDF3, 0xC3C0, 0xCA0F,
        0xD0D0, 0xD7F7, 0xDF73, 0xE735, 0xEF2C, 0xF747, 0xFF74, 0x07A2, 0x0FC0, 0x17BD, 0x1F87, 0x270E, 0x2E41, 0x3511, 0x3B6F, 0x414F,
        0x46A2, 0x4B5F, 0x4F7B, 0x52EC, 0x55AD, 0x57B6, 0x5903, 0x5993, 0x5962, 0x5873, 0x56C6, 0x5460, 0x5145, 0x4D7D, 0x490E, 0x4404,
        0x3E68, 0x3847, 0x31AD, 0x2AA9, 0x234A, 0x1B9F, 0x13BA, 0x0BAA, 0x0381, 0xFB52, 0xF32C, 0xEB21, 0xE342, 0xDBA2, 0xD44F, 0xCD59,
        0xC6D0, 0xC0C1, 0xBB39, 0xB645, 0xB1EE, 0xAE3E, 0xAB3D, 0xA8F1, 0xA75F, 0xA68B, 0xA676, 0xA721, 0xA88A, 0xAAAD, 0xAD87, 0xB112,
        0xB545, 0xBA18, 0xBF81, 0xC574, 0xCBE3, 0xD2C3, 0xDA03, 0xE194, 0xE966, 0xF169, 0xF98A, 0x01B9, 0x09E5, 0x11FC, 0x19EC, 0x21A5,
        0x2916, 0x302F, 0x36E1, 0x3D1E, 0x42D7, 0x4802, 0x4C94, 0x5081, 0x53C2, 0x5650, 0x5825, 0x593E, 0x5998, 0x5933, 0x580F, 0x562E,
        0x5395, 0x5049, 0x4C52, 0x47B8, 0x4284, 0x3CC2, 0x367E, 0x2FC5, 0x28A6, 0x2131, 0x1974, 0x1181, 0x0968, 0x013C, 0xF90D, 0xF0ED,
        0xE8ED, 0xE11E, 0xD991, 0xD257, 0xCB7E, 0xC515, 0xBF2A, 0xB9CA, 0xB500, 0xB0D7, 0xAD57, 0xAA87, 0xA86F, 0xA711, 0xA672, 0xA692,
        0xA772, 0xA90F, 0xAB66, 0xAE72, 0xB22C, 0xB68C, 0xBB8A, 0xC11A, 0xC731, 0xCDC1, 0xD4BC, 0xDC14, 0xE3B9, 0xEB9B, 0xF3A8, 0xFBCF,
        0x03FE, 0x0C26, 0x1434, 0x1C17, 0x23BD, 0x2B17, 0x3215, 0x38A8, 0x3EC2, 0x4455, 0x4957, 0x4DBB, 0x5179, 0x548A, 0x56E5, 0x5886,
        0x596A, 0x598F, 0x58F5, 0x579C, 0x5588, 0x52BD, 0x4F41, 0x4B1B, 0x4655, 0x40F9, 0x3B11, 0x34AB, 0x2DD5, 0x269D, 0x1F12, 0x1744,
        0x0F45, 0x0725, 0xFEF7, 0xF6CA, 0xEEB1, 0xE6BD, 0xDEFE, 0xD787, 0xD066, 0xC9AB, 0xC364, 0xBD9E, 0xB867, 0xB3C8, 0xAFCD, 0xAC7D,
        0xA9E0, 0xA7FB, 0xA6D2, 0xA668, 0xA6BD, 0xA7D2, 0xA9A3, 0xAC2C, 0xAF69, 0xB352, 0xB7DF, 0xBD07, 0xC2BE, 0xC8F7, 0xCFA7, 0xD6BD,
        0xDE2C, 0xE5E4, 0xEDD3, 0xF5E9, 0xFE14, 0x0643, 0x0E65, 0x1669, 0x1E3D, 0x25D0, 0x2D12, 0x33F3, 0x3A66, 0x405C, 0x45C8, 0x4A9F,
        0x4ED6, 0x5265, 0x5543, 0x576B, 0x58D9, 0x5988, 0x5978, 0x58A8, 0x571B, 0x54D4, 0x51D7, 0x4E2B, 0x49D8, 0x44E7, 0x3F63, 0x3957,
        0x32D1, 0x2BDD, 0x248D, 0x1CED, 0x1511, 0x0D07, 0x04E1, 0xFCB1, 0xF488, 0xEC78, 0xE491, 0xDCE4, 0xD583, 0xCE7D, 0xC7E1, 0xC1BC,
        0xBC1D, 0xB70F, 0xB29D, 0xAED0, 0xABB1, 0xA947, 0xA796, 0xA6A1, 0xA66C, 0xA6F7, 0xA840, 0xAA44, 0xAD00, 0xB06E, 0xB485, 0xB93E,
        0xBE8F, 0xC46B, 0xCAC7, 0xD194, 0xD8C5, 0xE04A, 0xE812, 0xF00E, 0xF82C, 0x0059, 0x0887, 0x10A2, 0x189A, 0x205E, 0x27DC, 0x2F05,
        0x35C9, 0x3C1A, 0x41EB, 0x472F, 0x4BDA, 0x4FE4, 0x5342, 0x55EF, 0x57E4, 0x591C, 0x5997, 0x5951, 0x584D, 0x568C, 0x5411, 0x50E3,
        0x4D08, 0x4888, 0x436E, 0x3DC2, 0x3793, 0x30ED, 0x29DF, 0x2276, 0x1AC5, 0x12D9, 0x0AC6, 0x029C, 0xFA6D, 0xF248, 0xEA42, 0xE269,
        0xDAD0, 0xD387, 0xCC9C, 0xC620, 0xC01F, 0xBAA7, 0xB5C3, 0xB17E, 0xADE1, 0xAAF3, 0xA8BC, 0xA73F, 0xA67F, 0xA680, 0xA73F, 0xA8BD,
        0xAAF4, 0xADE2, 0xB180, 0xB5C5, 0xBAA9, 0xC021, 0xC622, 0xCC9F, 0xD389, 0xDAD3, 0xE26C, 0xEA45, 0xF24B, 0xFA70, 0x029F, 0x0AC9,
        0x12DC, 0x1AC8, 0x2279, 0x29E1, 0x30F0, 0x3796, 0x3DC5, 0x4370, 0x488A, 0x4D0A, 0x50E5, 0x5412, 0x568C, 0x584D, 0x5951, 0x5997,
        0x591C, 0x57E3, 0x55EE, 0x5341, 0x4FE2, 0x4BD9, 0x472D, 0x41E9, 0x3C18, 0x35C7, 0x2F02, 0x27D9, 0x205B, 0x1897, 0x109F, 0x0884,
        0x0056, 0xF828, 0xF00B, 0xE80F, 0xE047, 0xD8C2, 0xD192, 0xCAC4, 0xC469, 0xBE8D, 0xB93D, 0xB484, 0xB06C, 0xACFF, 0xAA44, 0xA83F,
        0xA6F7, 0xA66C, 0xA6A2, 0xA796, 0xA948, 0xABB2, 0xAED2, 0xB29E, 0xB711, 0xBC1F, 0xC1BE, 0xC7E3, 0xCE80, 0xD586, 0xDCE7, 0xE494,
        0xEC7B, 0xF48B, 0xFCB5, 0x04E4, 0x0D0A, 0x1514, 0x1CF0, 0x248F, 0x2BE0, 0x32D3, 0x3959, 0x3F65, 0x44E9, 0x49DA, 0x4E2C, 0x51D8,
        0x54D5, 0x571C, 0x58A9, 0x5978, 0x5988, 0x58D8, 0x576B, 0x5542, 0x5264, 0x4ED5, 0x4A9D, 0x45C6, 0x405A, 0x3A64, 0x33F1, 0x2D0F,
        0x25CD, 0x1E3A, 0x1666, 0x0E62, 0x0640, 0xFE11, 0xF5E6, 0xEDD0, 0xE5E1, 0xDE29, 0xD6BB, 0xCFA4, 0xC8F5, 0xC2BB, 0xBD05, 0xB7DE,
        0xB351, 0xAF68, 0xAC2B, 0xA9A2, 0xA7D1, 0xA6BD, 0xA668, 0xA6D2, 0xA7FB, 0xA9E1, 0xAC7E, 0xAFCE, 0xB3CA, 0xB869, 0xBDA0, 0xC366,
        0xC9AD, 0xD068, 0xD78A, 0xDF01, 0xE6C0, 0xEEB4, 0xF6CD, 0xFEFA, 0x0728, 0x0F48, 0x1747, 0x1F14, 0x269F, 0x2DD8, 0x34AE, 0x3B13,
        0x40FB, 0x4657, 0x4B1D, 0x4F42, 0x52BE, 0x5589, 0x579D, 0x58F5, 0x598F, 0x596A, 0x5886, 0x56E4, 0x5489, 0x5178, 0x4DBA, 0x4955,
        0x4453, 0x3EC0, 0x38A6, 0x3213, 0x2B15, 0x23BA, 0x1C14, 0x1431, 0x0C23, 0x03FB, 0xFBCC, 0xF3A5, 0xEB98, 0xE3B6, 0xDC12, 0xD4BA,
        0xCDBE, 0xC72E, 0xC118, 0xBB88, 0xB68B, 0xB22A, 0xAE70, 0xAB65, 0xA90E, 0xA772, 0xA692, 0xA672, 0xA712, 0xA86F, 0xAA88, 0xAD58,
        0xB0D8, 0xB502, 0xB9CC, 0xBF2C, 0xC517, 0xCB80, 0xD259, 0xD994, 0xE121, 0xE8F0, 0xF0F0, 0xF910, 0x013F, 0x096B, 0x1184, 0x1977,
        0x2133, 0x28A9, 0x2FC8, 0x3680, 0x3CC4, 0x4286, 0x47B9, 0x4C54, 0x504B, 0x5396, 0x562F, 0x580F, 0x5933, 0x5998, 0x593E, 0x5825,
        0x564F, 0x53C1, 0x507F, 0x4C92, 0x4801, 0x42D5, 0x3D1B, 0x36DE, 0x302C, 0x2913, 0x21A2, 0x19E9, 0x11F9, 0x09E2, 0x01B6, 0xF987,
        0xF166, 0xE963, 0xE191, 0xDA00, 0xD2C0, 0xCBE1, 0xC571, 0xBF7F, 0xBA17, 0xB544, 0xB111, 0xAD86, 0xAAAC, 0xA889, 0xA721, 0xA676,
        0xA68B, 0xA760, 0xA8F2, 0xAB3E, 0xAE3F, 0xB1EF, 0xB647, 0xBB3B, 0xC0C3, 0xC6D2, 0xCD5C, 0xD451, 0xDBA5, 0xE345, 0xEB24, 0xF32F,
        0xFB55, 0x0384, 0x0BAD, 0x13BD, 0x1BA2, 0x234D, 0x2AAC, 0x31B0, 0x3849, 0x3E6A, 0x4406, 0x4910, 0x4D7E, 0x5146, 0x5461, 0x56C7,
        0x5873, 0x5962, 0x5992, 0x5903, 0x57B5, 0x55AC, 0x52EB, 0x4F79, 0x4B5E, 0x46A1, 0x414D, 0x3B6D, 0x350E, 0x2E3E, 0x270B, 0x1F84,
        0x17BA, 0x0FBD, 0x079F, 0xFF71, 0xF744, 0xEF29, 0xE732, 0xDF70, 0xD7F4, 0xD0CE, 0xCA0C, 0xC3BE, 0xBDF1, 0xB8B1, 0xB409, 0xB004,
        0xACAA, 0xAA02, 0xA812, 0xA6DE, 0xA669, 0xA6B3, 0xA7BC, 0xA982, 0xAC01, 0xAF34, 0xB313, 0xB797, 0xBCB6, 0xC264, 0xC897, 0xCF40,
        0xD651, 0xDDBB, 0xE56F, 0xED5B, 0xF56F, 0xFD9A, 0x05C9, 0x0DED, 0x15F2, 0x1DC9, 0x2561, 0x2CA8, 0x3390, 0x3A09, 0x4006, 0x457B,
        0x4A5B, 0x4E9C, 0x5234, 0x551D, 0x5750, 0x58C9, 0x5983, 0x597E, 0x58B9, 0x5737, 0x54FB, 0x5208, 0x4E66, 0x4A1D, 0x4535, 0x3FB9,
        0x39B5, 0x3335, 0x2C48, 0x24FC, 0x1D61, 0x1587, 0x0D80, 0x055B, 0xFD2C, 0xF502, 0xECEF, 0xE505, 0xDD55, 0xD5EF, 0xCEE3, 0xC840,
        0xC214, 0xBC6D, 0xB756, 0xB2DB, 0xAF04, 0xABDB, 0xA966, 0xA7AA, 0xA6AA, 0xA66A, 0xA6EA, 0xA827, 0xAA21, 0xACD3, 0xB036, 0xB444,
        0xB8F4, 0xBE3B, 0xC410, 0xCA64, 0xD12C, 0xD857, 0xDFD7, 0xE79C, 0xEF95, 0xF7B2, 0xFFE0, 0x080D, 0x102A, 0x1825, 0x1FEB, 0x276E,
        0x2E9C, 0x3567, 0x3BBF, 0x4198, 0x46E4, 0x4B99, 0x4FAC, 0x5315, 0x55CC, 0x57CC, 0x590F, 0x5995, 0x595B, 0x5861, 0x56AB, 0x543B,
        0x5118, 0x4D46, 0x48D0, 0x43BE, 0x3E1B, 0x37F3, 0x3154, 0x2A4B, 0x22E7, 0x1B39, 0x1351, 0x0B3F, 0x0316, 0xFAE7, 0xF2C1, 0xEAB8,
        0xE2DD, 0xDB40, 0xD3F1, 0xCD01, 0xC67E, 0xC075, 0xBAF5, 0xB608, 0xB1B9, 0xAE12, 0xAB1A, 0xA8D8, 0xA750, 0xA685, 0xA67A, 0xA72F,
        0xA8A1, 0xAACE, 0xADB2, 0xB145, 0xB581, 0xBA5C, 0xBFCC, 0xC5C5, 0xCC3B, 0xD31F, 0xDA64, 0xE1F9, 0xE9CE, 0xF1D3, 0xF9F6, 0x0224,
        0x0A50, 0x1265, 0x1A53, 0x2208, 0x2975, 0x3089, 0x3736, 0x3D6C, 0x431F, 0x4842, 0x4CCB, 0x50B0, 0x53E8, 0x566C, 0x5838, 0x5947,
        0x5998, 0x5928, 0x57FA, 0x5610, 0x536E, 0x501A, 0x4C1A, 0x4777, 0x423C, 0x3C73, 0x3628, 0x2F6A, 0x2846, 0x20CD, 0x190D, 0x1117,
        0x08FD, 0x00D0, 0xF8A2, 0xF083, 0xE885, 0xE0B9, 0xD930, 0xD1FA, 0xCB27, 0xC4C4, 0xBEE0, 0xB988, 0xB4C6, 0xB0A5, 0xAD2E, 0xAA67,
        0xA858, 0xA705, 0xA66F, 0xA699, 0xA783, 0xA929, 0xAB89, 0xAE9E, 0xB261, 0xB6CA, 0xBBCF, 0xC167, 0xC784, 0xCE1A, 0xD51B, 0xDC77,
        0xE41F, 0xEC03, 0xF412, 0xFC3A, 0x046A, 0x0C91, 0x149D, 0x1C7C, 0x2420, 0x2B75, 0x326E, 0x38FB, 0x3F0E, 0x449B, 0x4994, 0x4DF0,
        0x51A6, 0x54AD, 0x56FF, 0x5897, 0x5971, 0x598C, 0x58E8, 0x5785, 0x5568, 0x5293, 0x4F0E, 0x4AE0, 0x4612, 0x40AE, 0x3AC0, 0x3454,
        0x2D79, 0x263C, 0x1EAD, 0x16DC, 0x0EDB, 0x06BA, 0xFE8C, 0xF65F, 0xEE48, 0xE656, 0xDE9B, 0xD727, 0xD00B, 0xC955, 0xC315, 0xBD56,
        0xB826, 0xB390, 0xAF9D, 0xAC57, 0xA9C3, 0xA7E7, 0xA6C8, 0xA668, 0xA6C7, 0xA7E5, 0xA9BF, 0xAC52, 0xAF98, 0xB38A, 0xB81F, 0xBD4E,
        0xC30C, 0xC94C, 0xD001, 0xD71D, 0xDE90, 0xE64A, 0xEE3C, 0xF653, 0xFE80, 0x06AE, 0x0ECF, 0x16D1, 0x1EA2, 0x2631, 0x2D6E, 0x344B,
        0x3AB7, 0x40A6, 0x460B, 0x4ADA, 0x4F09, 0x528F, 0x5564, 0x5783, 0x58E6, 0x598C, 0x5972, 0x5898, 0x5702, 0x54B1, 0x51AB, 0x4DF6,
        0x499B, 0x44A2, 0x3F17, 0x3904, 0x3278, 0x2B80, 0x242A, 0x1C88, 0x14A8, 0x0C9C, 0x0476, 0xFC46, 0xF41E, 0xEC0F, 0xE42B, 0xDC82,
        0xD525, 0xCE24, 0xC78D, 0xC16F, 0xBBD7, 0xB6D1, 0xB267, 0xAEA3, 0xAB8D, 0xA92C, 0xA784, 0xA69A, 0xA66F, 0xA703, 0xA856, 0xAA64,
        0xAD29, 0xB09F, 0xB4BF, 0xB980, 0xBED8, 0xC4BB, 0xCB1D, 0xD1F0, 0xD926, 0xE0AE, 0xE87A, 0xF077, 0xF896, 0x00C4, 0x08F2, 0x110C,
        0x1901, 0x20C2, 0x283C, 0x2F60, 0x361F, 0x3C6A, 0x4234, 0x4770, 0x4C13, 0x5014, 0x536A, 0x560D, 0x57F8, 0x5927, 0x5998, 0x5948,
        0x583A, 0x5670, 0x53EC, 0x50B5, 0x4CD1, 0x4849, 0x4327, 0x3D75, 0x373F, 0x3093, 0x2980, 0x2213, 0x1A5E, 0x1270, 0x0A5B, 0x0230,
        0xFA01, 0xF1DE, 0xE9D9, 0xE204, 0xDA6F, 0xD32A, 0xCC45, 0xC5CE, 0xBFD4, 0xBA63, 0xB587, 0xB14B, 0xADB6, 0xAAD2, 0xA8A4, 0xA730,
        0xA67B, 0xA685, 0xA74E, 0xA8D5, 0xAB16, 0xAE0D, 0xB1B4, 0xB601, 0xBAED, 0xC06D, 0xC674, 0xCCF7, 0xD3E7, 0xDB35, 0xE2D2, 0xEAAD,
        0xF2B6, 0xFADB, 0x030A, 0x0B34, 0x1345, 0x1B2E, 0x22DC, 0x2A40, 0x314A, 0x37EA, 0x3E12, 0x43B6, 0x48C9, 0x4D40, 0x5113, 0x5437,
        0x56A8, 0x585F, 0x595A, 0x5995, 0x5911, 0x57CE, 0x55CF, 0x5319, 0x4FB2, 0x4B9F, 0x46EC, 0x41A0, 0x3BC8, 0x3570, 0x2EA6, 0x2779,
        0x1FF7, 0x1830, 0x1036, 0x0819, 0xFFEC, 0xF7BE, 0xEFA1, 0xE7A8, 0xDFE2, 0xD862, 0xD136, 0xCA6E, 0xC419, 0xBE43, 0xB8FB, 0xB44A,
        0xB03B, 0xACD7, 0xAA25, 0xA82A, 0xA6EB, 0xA66A, 0xA6AA, 0xA7A8, 0xA963, 0xABD7, 0xAEFF, 0xB2D5, 0xB74F, 0xBC65, 0xC20C, 0xC837,
        0xCED9, 0xD5E5, 0xDD4A, 0xE4FA, 0xECE3, 0xF4F6, 0xFD20, 0x054F, 0x0D74, 0x157C, 0x1D56, 0x24F1, 0x2C3E, 0x332B, 0x39AC, 0x3FB1,
        0x452D, 0x4A16, 0x4E61, 0x5203, 0x54F7, 0x5735, 0x58B8, 0x597D, 0x5983, 0x58CA, 0x5753, 0x5521, 0x5239, 0x4EA1, 0x4A61, 0x4582,
        0x400F, 0x3A12, 0x3399, 0x2CB2, 0x256B, 0x1DD5, 0x15FE, 0x0DF8, 0x05D5, 0xFDA6, 0xF57B, 0xED67, 0xE57A, 0xDDC6, 0xD65B, 0xCF4A,
        0xC8A0, 0xC26D, 0xBCBE, 0xB79E, 0xB319, 0xAF39, 0xAC05, 0xA985, 0xA7BE, 0xA6B4, 0xA669, 0xA6DD, 0xA810, 0xA9FF, 0xACA5, 0xAFFF,
        0xB403, 0xB8A9, 0xBDE9, 0xC3B5, 0xCA03, 0xD0C4, 0xD7EA, 0xDF65, 0xE727, 0xEF1D, 0xF738, 0xFF65, 0x0793, 0x0FB2, 0x17AF, 0x1F79,
        0x2700, 0x2E34, 0x3505, 0x3B64, 0x4144, 0x4699, 0x4B57, 0x4F74, 0x52E7, 0x55A8, 0x57B3, 0x5902, 0x5992, 0x5963, 0x5875, 0x56CA,
        0x5465, 0x514B, 0x4D84, 0x4917, 0x440E, 0x3E73, 0x3852, 0x31BA, 0x2AB6, 0x2358, 0x1BAE, 0x13C8, 0x0BB9, 0x0390, 0xFB61, 0xF33A,
        0xEB2F, 0xE351, 0xDBAF, 0xD45C, 0xCD66, 0xC6DC, 0xC0CC, 0xBB43, 0xB64D, 0xB1F5, 0xAE44, 0xAB42, 0xA8F4, 0xA761, 0xA68C, 0xA676,
        0xA71F, 0xA886, 0xAAA9, 0xAD82, 0xB10B, 0xB53D, 0xBA0F, 0xBF77, 0xC568, 0xCBD7, 0xD2B6, 0xD9F5, 0xE186, 0xE958, 0xF15A, 0xF97B,
        0x01AA, 0x09D6, 0x11ED, 0x19DE, 0x2197, 0x2909, 0x3022, 0x36D5, 0x3D13, 0x42CE, 0x47FA, 0x4C8C, 0x507A, 0x53BD, 0x564C, 0x5823,
        0x593D, 0x5998, 0x5934, 0x5811, 0x5632, 0x539A, 0x5050, 0x4C5A, 0x47C1, 0x428E, 0x3CCD, 0x3689, 0x2FD2, 0x28B4, 0x213E, 0x1982,
        0x118F, 0x0977, 0x014B, 0xF91C, 0xF0FC, 0xE8FB, 0xE12C, 0xD99F, 0xD263, 0xCB8A, 0xC520, 0xBF35, 0xB9D4, 0xB509, 0xB0DE, 0xAD5D,
        0xAA8C, 0xA872, 0xA713, 0xA673, 0xA692, 0xA770, 0xA90B, 0xAB61, 0xAE6B, 0xB224, 0xB684, 0xBB80, 0xC10F, 0xC725, 0xCDB4, 0xD4AF,
        0xDC07, 0xE3AB, 0xEB8C, 0xF399, 0xFBC0, 0x03EF, 0x0C17, 0x1425, 0x1C08, 0x23AF, 0x2B0A, 0x3209, 0x389D, 0x3EB7, 0x444C, 0x494E,
        0x4DB4, 0x5173, 0x5485, 0x56E1, 0x5884, 0x5969, 0x5990, 0x58F7, 0x579F, 0x558C, 0x52C2, 0x4F48, 0x4B23, 0x465E, 0x4103, 0x3B1C,
        0x34B7, 0x2DE2, 0x26AA, 0x1F20, 0x1753, 0x0F54, 0x0734, 0xFF06, 0xF6D9, 0xEEC0, 0xE6CB, 0xDF0C, 0xD794, 0xD073, 0xC9B7, 0xC36F,
        0xBDA8, 0xB870, 0xB3D0, 0xAFD4, 0xAC83, 0xA9E4, 0xA7FE, 0xA6D3, 0xA668, 0xA6BC, 0xA7CF, 0xA99F, 0xAC27, 0xAF63, 0xB34B, 0xB7D7,
        0xBCFD, 0xC2B3, 0xC8EB, 0xCF9A, 0xD6B0, 0xDE1E, 0xE5D5, 0xEDC4, 0xF5DA, 0xFE05, 0x0634, 0x0E57, 0x165B, 0x1E2F, 0x25C2, 0x2D05,
        0x33E7, 0x3A5B, 0x4051, 0x45BE, 0x4A96, 0x4ECF, 0x525F, 0x553F, 0x5768, 0x58D7, 0x5987, 0x5978, 0x58AA, 0x571E, 0x54D8, 0x51DD,
        0x4E32, 0x49E0, 0x44F1, 0x3F6D, 0x3962, 0x32DD, 0x2BEA, 0x249A, 0x1CFC, 0x151F, 0x0D15, 0x04F0, 0xFCC0, 0xF497, 0xEC86, 0xE49F,
        0xDCF2, 0xD591, 0xCE8A, 0xC7EC, 0xC1C7, 0xBC27, 0xB718, 0xB2A4, 0xAED7, 0xABB6, 0xA94B, 0xA798, 0xA6A2, 0xA66C, 0xA6F5, 0xA83D,
        0xAA40, 0xACFB, 0xB067, 0xB47D, 0xB935, 0xBE85, 0xC460, 0xCABB, 0xD187, 0xD8B7, 0xE03C, 0xE804, 0xEFFF, 0xF81D, 0x004A, 0x0878,
        0x1094, 0x188C, 0x2050, 0x27CE, 0x2EF8, 0x35BD, 0x3C0F, 0x41E1, 0x4726, 0x4BD3, 0x4FDD, 0x533D, 0x55EB, 0x57E1, 0x591B, 0x5996,
        0x5952, 0x584F, 0x568F, 0x5416, 0x50EA, 0x4D10, 0x4891, 0x4377, 0x3DCD, 0x379F, 0x30FA, 0x29EC, 0x2284, 0x1AD3, 0x12E8, 0x0AD5,
        0x02AB, 0xFA7B, 0xF257, 0xEA50, 0xE277, 0xDADE, 0xD394, 0xCCA9, 0xC62B, 0xC02A, 0xBAB1, 0xB5CC, 0xB185, 0xADE7, 0xAAF8, 0xA8BF,
        0xA741, 0xA680, 0xA67F, 0xA73D, 0xA8B9, 0xAAF0, 0xADDC, 0xB178, 0xB5BD, 0xBAA0, 0xC017, 0xC617, 0xCC93, 0xD37C, 0xDAC5, 0xE25E,
        0xEA36, 0xF23D, 0xFA61, 0x0290, 0x0ABA, 0x12CE, 0x1AB9, 0x226C, 0x29D4, 0x30E3, 0x378A, 0x3DBA, 0x4366, 0x4881, 0x4D02, 0x50DE,
        0x540D, 0x5689, 0x584B, 0x5950, 0x5997, 0x591E, 0x57E6, 0x55F2, 0x5347, 0x4FE9, 0x4BE1, 0x4736, 0x41F3, 0x3C23, 0x35D2, 0x2F0F,
        0x27E6, 0x2069, 0x18A6, 0x10AE, 0x0893, 0x0065, 0xF837, 0xF019, 0xE81E, 0xE055, 0xD8D0, 0xD19E, 0xCAD0, 0xC474, 0xBE97, 0xB946,
        0xB48C, 0xB073, 0xAD05, 0xAA48, 0xA842, 0xA6F8, 0xA66D, 0xA6A1, 0xA794, 0xA944, 0xABAD, 0xAECB, 0xB297, 0xB708, 0xBC15, 0xC1B4,
        0xC7D7, 0xCE73, 0xD579, 0xDCDA, 0xE485, 0xEC6C, 0xF47C, 0xFCA6, 0x04D5, 0x0CFB, 0x1505, 0x1CE2, 0x2482, 0x2BD3, 0x32C7, 0x394E,
        0x3F5A, 0x44DF, 0x49D1, 0x4E25, 0x51D2, 0x54D0, 0x5718, 0x58A6, 0x5977, 0x5988, 0x58DA, 0x576E, 0x5547, 0x5269, 0x4EDC, 0x4AA5,
        0x45CF, 0x4064, 0x3A6F, 0x33FD, 0x2D1C, 0x25DA, 0x1E48, 0x1675, 0x0E71, 0x064F, 0xFE20, 0xF5F5, 0xEDDE, 0xE5EF, 0xDE37, 0xD6C8,
        0xCFB1, 0xC901, 0xC2C6, 0xBD0F, 0xB7E6, 0xB358, 0xAF6E, 0xAC30, 0xA9A6, 0xA7D4, 0xA6BE, 0xA668, 0xA6D1, 0xA7F9, 0xA9DD, 0xAC79,
        0xAFC8, 0xB3C2, 0xB860, 0xBD96, 0xC35B, 0xC9A1, 0xD05C, 0xD77C, 0xDEF3, 0xE6B1, 0xEEA5, 0xF6BE, 0xFEEB, 0x0719, 0x0F39, 0x1739,
        0x1F06, 0x2692, 0x2DCB, 0x34A2, 0x3B08, 0x40F0, 0x464E, 0x4B15, 0x4F3B, 0x52B8, 0x5584, 0x5799, 0x58F3, 0x598F, 0x596B, 0x5888,
        0x56E8, 0x548D, 0x517E, 0x4DC1, 0x495D, 0x445D, 0x3ECA, 0x38B1, 0x321F, 0x2B22, 0x23C8, 0x1C22, 0x1440, 0x0C32, 0x040A, 0xFBDB,
        0xF3B3, 0xEBA6, 0xE3C5, 0xDC1F, 0xD4C7, 0xCDCB, 0xC73A, 0xC123, 0xBB92, 0xB693, 0xB232, 0xAE76, 0xAB6A, 0xA912, 0xA774, 0xA693,
        0xA672, 0xA710, 0xA86C, 0xAA84, 0xAD52, 0xB0D1, 0xB4FA, 0xB9C3, 0xBF22, 0xC50C, 0xCB74, 0xD24C, 0xD986, 0xE113, 0xE8E1, 0xF0E1,
        0xF902, 0x0130, 0x095C, 0x1175, 0x1968, 0x2125, 0x289C, 0x2FBB, 0x3674, 0x3CB9, 0x427C, 0x47B0, 0x4C4C, 0x5044, 0x5391, 0x562B,
        0x580C, 0x5932, 0x5998, 0x593F, 0x5827, 0x5653, 0x53C6, 0x5086, 0x4C9A, 0x480A, 0x42DF, 0x3D26, 0x36EA, 0x3039, 0x2920, 0x21B0,
        0x19F7, 0x1207, 0x09F1, 0x01C5, 0xF996, 0xF174, 0xE972, 0xE19F, 0xDA0D, 0xD2CD, 0xCBED, 0xC57D, 0xBF89, 0xBA20, 0xB54C, 0xB118,
        0xAD8C, 0xAAB1, 0xA88C, 0xA722, 0xA677, 0xA68A, 0xA75E, 0xA8EE, 0xAB39, 0xAE39, 0xB1E8, 0xB63E, 0xBB32, 0xC0B9, 0xC6C7, 0xCD4F,
        0xD444, 0xDB97, 0xE337, 0xEB15, 0xF320, 0xFB46, 0x0375, 0x0B9E, 0x13AE, 0x1B94, 0x233F, 0x2A9F, 0x31A3, 0x383D, 0x3E60, 0x43FC,
        0x4907, 0x4D77, 0x5140, 0x545C, 0x56C3, 0x5871, 0x5961, 0x5993, 0x5905, 0x57B8, 0x55B0, 0x52F1, 0x4F80, 0x4B66, 0x46AA, 0x4157,
        0x3B78, 0x351A, 0x2E4B, 0x2718, 0x1F92, 0x17C9, 0x0FCC, 0x07AE, 0xFF80, 0xF753, 0xEF38, 0xE740, 0xDF7E, 0xD802, 0xD0DA, 0xCA18,
        0xC3C9, 0xBDFB, 0xB8BA, 0xB411, 0xB00B, 0xACAF, 0xAA06, 0xA815, 0xA6E0, 0xA669, 0xA6B2, 0xA7BA, 0xA97E, 0xABFC, 0xAF2D, 0xB30C,
        0xB78E, 0xBCAC, 0xC25A, 0xC88B, 0xCF33, 0xD644, 0xDDAD, 0xE560, 0xED4C, 0xF560, 0xFD8B, 0x05BA, 0x0DDE, 0x15E4, 0x1DBB, 0x2553,
        0x2C9B, 0x3383, 0x39FE, 0x3FFC, 0x4571, 0x4A52, 0x4E94, 0x522E, 0x5519, 0x574D, 0x58C7, 0x5982, 0x597F, 0x58BB, 0x573B, 0x54FF,
        0x520E, 0x4E6E, 0x4A25, 0x453E, 0x3FC3, 0x39C0, 0x3341, 0x2C55, 0x250A, 0x1D6F, 0x1596, 0x0D8E, 0x056A, 0xFD3B, 0xF510, 0xECFE,
        0xE514, 0xDD63, 0xD5FC, 0xCEF0, 0xC84C, 0xC21F, 0xBC77, 0xB75F, 0xB2E2, 0xAF0B, 0xABE0, 0xA96A, 0xA7AC, 0xA6AC, 0xA66A, 0xA6E8,
        0xA825, 0xAA62, 0xAD52, 0xB0EF, 0xB52E, 0xBA07, 0xBF6D, 0xC554, 0xCBAF, 0xD270, 0xD986, 0xE0E4, 0xE878, 0xF031, 0xF800, 0xFFD3,
        0x0798, 0x0F42, 0x16BE, 0x1DFD, 0x24F0, 0x2B88, 0x31B9, 0x3775, 0x3CB0, 0x4162, 0x4580, 0x4902, 0x4BE2, 0x4E1C, 0x4FAB, 0x508D,
        0x50C1, 0x5049, 0x4F26, 0x4D5B, 0x4AEF, 0x47E7, 0x444A, 0x4022, 0x3B78, 0x3657, 0x30CB, 0x2AE1, 0x24A5, 0x1E26, 0x1772, 0x1098,
        0x09A6, 0x02AC, 0xFBBA, 0xF4DD, 0xEE23, 0xE79C, 0xE154, 0xDB5A, 0xD5B8, 0xD07B, 0xCBAD, 0xC758, 0xC383, 0xC037, 0xBD79, 0xBB4E,
        0xB9BA, 0xB8BE, 0xB85D, 0xB896, 0xB967, 0xBACD, 0xBCC4, 0xBF48, 0xC251, 0xC5D8, 0xC9D4, 0xCE3D, 0xD308, 0xD829, 0xDD96, 0xE342,
        0xE921, 0xEF26, 0xF542, 0xFB6A, 0x018F, 0x07A6, 0x0DA0, 0x1372, 0x190F, 0x1E6B, 0x237C, 0x2837, 0x2C93, 0x3087, 0x340B, 0x3719,
        0x39AC, 0x3BBE, 0x3D4C, 0x3E54, 0x3ED5, 0x3ECF, 0x3E42, 0x3D32, 0x3BA0, 0x3993, 0x370F, 0x341B, 0x30BD, 0x2CFE, 0x28E6, 0x2480,
        0x1FD5, 0x1AEF, 0x15DA, 0x10A2, 0x0B50, 0x05F2, 0x0092, 0xFB3D, 0xF5FD, 0xF0DE, 0xEBE9, 0xE72B, 0xE2AB, 0xDE74, 0xDA8E, 0xD700,
        0xD3D2, 0xD109, 0xCEAA, 0xCCBA, 0xCB3C, 0xCA32, 0xC99D, 0xC97E, 0xC9D3, 0xCA9C, 0xCBD5, 0xCD7A, 0xCF88, 0xD1F9, 0xD4C7, 0xD7EB,
        0xDB5D, 0xDF16, 0xE30D, 0xE738, 0xEB8F, 0xF007, 0xF497, 0xF935, 0xFDD7, 0x0272, 0x06FD, 0x0B6F, 0x0FBE, 0x13E1, 0x17D0, 0x1B82,
        0x1EF1, 0x2216, 0x24EA, 0x2768, 0x298C, 0x2B52, 0x2CB7, 0x2DB9, 0x2E57, 0x2E90, 0x2E66, 0x2DD8, 0x2CEA, 0x2B9E, 0x29F7, 0x27FC,
        0x25B0, 0x2319, 0x203D, 0x1D24, 0x19D5, 0x1656, 0x12B1, 0x0EED, 0x0B13, 0x072C, 0x033F, 0xFF56, 0xFB78, 0xF7AE, 0xF400, 0xF075,
        0xED15, 0xE9E6, 0xE6EF, 0xE435, 0xE1BF, 0xDF90, 0xDDAC, 0xDC16, 0xDAD2, 0xD9E1, 0xD944, 0xD8FB, 0xD907, 0xD966, 0xDA16, 0xDB16,
        0xDC62, 0xDDF6, 0xDFCF, 0xE1E8, 0xE43B, 0xE6C2, 0xE979, 0xEC58, 0xEF58, 0xF274, 0xF5A3, 0xF8E0, 0xFC22, 0xFF62, 0x029A, 0x05C3,
        0x08D7, 0x0BCE, 0x0EA3, 0x1151, 0x13D1, 0x161F, 0x1837, 0x1A14, 0x1BB4, 0x1D14, 0x1E31, 0x1F0A, 0x1F9D, 0x1FEC, 0x1FF5, 0x1FB9,
        0x1F3A, 0x1E7A, 0x1D7B, 0x1C40, 0x1ACD, 0x1924, 0x174C, 0x1547, 0x131C, 0x10CF, 0x0E65, 0x0BE5, 0x0953, 0x06B6, 0x0414, 0x0171,
        0xFED6, 0xFC45, 0xF9C5, 0xF75B, 0xF50C, 0xF2DC, 0xF0D0, 0xEEEC, 0xED33, 0xEBA9, 0xEA4F, 0xE929, 0xE839, 0xE77E, 0xE6FB, 0xE6AF,
        0xE69B, 0xE6BE, 0xE716, 0xE7A2, 0xE861, 0xE94F, 0xEA6B, 0xEBB1, 0xED1D, 0xEEAD, 0xF05C, 0xF225, 0xF406, 0xF5F9, 0xF7FA, 0xFA04,
        0xFC13, 0xFE23, 0x002D, 0x022F, 0x0424, 0x0609, 0x07D9, 0x0991, 0x0B2D, 0x0CAA, 0x0E05, 0x0F3D, 0x104F, 0x113A, 0x11FB, 0x1292,
        0x12FF, 0x1342, 0x1359, 0x1347, 0x130B, 0x12A8, 0x121E, 0x116F, 0x109E, 0x0FAD, 0x0E9F, 0x0D76, 0x0C35, 0x0AE0, 0x0979, 0x0805,
        0x0687, 0x0501, 0x0378, 0x01EF, 0x0069, 0xFEEB, 0xFD76, 0xFC0D, 0xFAB4, 0xF96D, 0xF83B, 0xF720, 0xF61E, 0xF536, 0xF46A, 0xF3BB,
        0xF32B, 0xF2B9, 0xF267, 0xF233, 0xF21F, 0xF229, 0xF250, 0xF295, 0xF2F5, 0xF36F, 0xF402, 0xF4AC, 0xF56A, 0xF63B, 0xF71C, 0xF80C,
        0xF907, 0xFA0C, 0xFB17, 0xFC27, 0xFD38, 0xFE49, 0xFF57, 0x005F, 0x0161, 0x0259, 0x0346, 0x0425, 0x04F6, 0x05B7, 0x0666, 0x0703,
        0x078C, 0x0801, 0x0861, 0x08AD, 0x08E3, 0x0905, 0x0911, 0x090A, 0x08EE, 0x08C0, 0x0880, 0x082F, 0x07CF, 0x0760, 0x06E4, 0x065D,
        0x05CC, 0x0533, 0x0493, 0x03EE, 0x0345, 0x029B, 0x01F1, 0x0147, 0x00A1, 0x0000, 0xFF64, 0xFECE, 0xFE40, 0xFDBB, 0xFD40, 0xFCD0,
        0xFC6B, 0xFC11, 0xFBC5, 0xFB84, 0xFB50, 0xFB29, 0xFB0E, 0xFB00, 0xFAFD, 0xFB07, 0xFB1B, 0xFB39, 0xFB61, 0xFB92, 0xFBCB, 0xFC0B,
        0xFC52, 0xFC9E, 0xFCEE, 0xFD41, 0xFD97, 0xFDEE, 0xFE45, 0xFE9D, 0xFEF3, 0xFF47, 0xFF98, 0xFFE6, 0x002E, 0x0073, 0x00B3, 0x00ED,
        0x0122, 0x0150, 0x0178, 0x019A, 0x01B6, 0x01CB, 0x01DA, 0x01E4, 0x01E7, 0x01E5, 0x01DF, 0x01D3, 0x01C4, 0x01B1, 0x019B, 0x0182,
        0x0166, 0x014A, 0x012B, 0x010D, 0x00EE, 0x00CF, 0x00B1, 0x0094, 0x0078, 0x005E, 0x0046, 0x0030, 0x001C, 0x000A, 0xFFFD, 0xFFF0,
        0xFFE6, 0xFFDF, 0xFFD9, 0xFFD6, 0xFFD5, 0xFFD6, 0xFFD8, 0xFFDB, 0xFFE0, 0xFFE5, 0xFFEA, 0xFFF0, 0xFFF6, 0xFFFA, 0xFFFE, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFA, 0xFFF7, 0xFFF5, 0xFFF2, 0xFFEE,
        0xFFEA, 0xFFE6, 0xFFE2, 0xFFDE, 0xFFD9, 0xFFD5, 0xFFD0, 0xFFCC, 0xFFC8, 0xFFC4, 0xFFC1, 0xFFBE, 0xFFBC, 0xFFBB, 0xFFBA, 0xFFBB,
        0xFFBD, 0xFFC0, 0xFFC4, 0xFFCA, 0xFFD1, 0xFFDA, 0xFFE4, 0xFFEF, 0xFFFC, 0x0009, 0x0019, 0x002A, 0x003C, 0x004F, 0x0063, 0x0078,
        0x008D, 0x00A3, 0x00B9, 0x00CE, 0x00E4, 0x00F9, 0x010D, 0x0120, 0x0132, 0x0141, 0x014F, 0x015B, 0x0165, 0x016B, 0x016F, 0x016F,
        0x016C, 0x0166, 0x015C, 0x014E, 0x013C, 0x0126, 0x010D, 0x00EF, 0x00CE, 0x00A8, 0x0080, 0x0054, 0x0024, 0xFFF3, 0xFFBF, 0xFF88,
        0xFF4F, 0xFF15, 0xFEDA, 0xFE9E, 0xFE63, 0xFE28, 0xFDEF, 0xFDB7, 0xFD81, 0xFD4F, 0xFD1F, 0xFCF4, 0xFCCE, 0xFCAC, 0xFC90, 0xFC7A,
        0xFC6B, 0xFC63, 0xFC62, 0xFC68, 0xFC77, 0xFC8D, 0xFCAB, 0xFCD2, 0xFD01, 0xFD38, 0xFD77, 0xFDBE, 0xFE0C, 0xFE61, 0xFEBC, 0xFF1E,
        0xFF85, 0xFFF1, 0x005F, 0x00D2, 0x0148, 0x01BE, 0x0236, 0x02AD, 0x0322, 0x0395, 0x0405, 0x0470, 0x04D6, 0x0535, 0x058D, 0x05DC,
        0x0622, 0x065D, 0x068E, 0x06B2, 0x06CB, 0x06D6, 0x06D4, 0x06C4, 0x06A5, 0x0679, 0x063E, 0x05F5, 0x059E, 0x0538, 0x04C6, 0x0446,
        0x03BB, 0x0324, 0x0282, 0x01D7, 0x0123, 0x0069, 0xFFA9, 0xFEE4, 0xFE1C, 0xFD52, 0xFC88, 0xFBC0, 0xFAFB, 0xFA3B, 0xF982, 0xF8D0,
        0xF829, 0xF78D, 0xF6FE, 0xF67D, 0xF60B, 0xF5AB, 0xF55D, 0xF522, 0xF4FC, 0xF4EA, 0xF4EE, 0xF507, 0xF538, 0xF57E, 0xF5DB, 0xF64F,
        0xF6D8, 0xF776, 0xF829, 0xF8F0, 0xF9C9, 0xFAB3, 0xFBAC, 0xFCB4, 0xFDC9, 0xFEE7, 0x000D, 0x013B, 0x026C, 0x039F, 0x04D2, 0x0602,
        0x072C, 0x084F, 0x0967, 0x0A73, 0x0B6F, 0x0C5B, 0x0D32, 0x0DF5, 0x0EA0, 0x0F31, 0x0FA8, 0x1003, 0x103F, 0x105E, 0x105C, 0x103B,
        0x0FF9, 0x0F96, 0x0F13, 0x0E70, 0x0DAE, 0x0CCD, 0x0BCF, 0x0AB5, 0x0980, 0x0834, 0x06D1, 0x055A, 0x03D1, 0x023B, 0x0098, 0xFEED,
        0xFD3C, 0xFB89, 0xF9D6, 0xF828, 0xF681, 0xF4E6, 0xF358, 0xF1DD, 0xF077, 0xEF28, 0xEDF5, 0xECDF, 0xEBEA, 0xEB18, 0xEA6C, 0xE9E6,
        0xE989, 0xE956, 0xE94F, 0xE974, 0xE9C5, 0xEA43, 0xEAED, 0xEBC3, 0xECC4, 0xEDEF, 0xEF41, 0xF0BA, 0xF256, 0xF414, 0xF5F0, 0xF7E7,
        0xF9F5, 0xFC18, 0xFE4B, 0x0089, 0x02D0, 0x051A, 0x0764, 0x09A8, 0x0BE2, 0x0E0E, 0x1027, 0x1229, 0x1410, 0x15D7, 0x177A, 0x18F6,
        0x1A47, 0x1B6A, 0x1C5C, 0x1D1B, 0x1DA4, 0x1DF6, 0x1E0F, 0x1DED, 0x1D92, 0x1CFB, 0x1C2B, 0x1B20, 0x19DE, 0x1864, 0x16B6, 0x14D6,
        0x12C7, 0x108C, 0x0E2A, 0x0BA3, 0x08FC, 0x063B, 0x0364, 0x007D, 0xFD8C, 0xFA94, 0xF79C, 0xF4AA, 0xF1C4, 0xEEF0, 0xEC33, 0xE992,
        0xE715, 0xE4BF, 0xE296, 0xE09E, 0xDEDD, 0xDD56, 0xDC0D, 0xDB05, 0xDA41, 0xD9C4, 0xD98F, 0xD9A3, 0xDA02, 0xDAAC, 0xDBA0, 0xDCDD,
        0xDE62, 0xE02D, 0xE23C, 0xE48A, 0xE715, 0xE9D8, 0xECCF, 0xEFF4, 0xF342, 0xF6B3, 0xFA40, 0xFDE4, 0x0197, 0x0552, 0x090F, 0x0CC6,
        0x1070, 0x1405, 0x177F, 0x1AD6, 0x1E03, 0x2100, 0x23C6, 0x2650, 0x2897, 0x2A97, 0x2C4A, 0x2DAD, 0x2EBD, 0x2F75, 0x2FD3, 0x2FD7,
        0x2F7E, 0x2EC9, 0x2DB7, 0x2C4A, 0x2A84, 0x2866, 0x25F5, 0x2333, 0x2026, 0x1CD1, 0x193C, 0x156C, 0x1168, 0x0D37, 0x08E0, 0x046C,
        0xFFE5, 0xFB4F, 0xF6B6, 0xF223, 0xED9D, 0xE92E, 0xE4DF, 0xE0B8, 0xDCC2, 0xD905, 0xD589, 0xD255, 0xCF71, 0xCCE2, 0xCAAF, 0xC8DC,
        0xC76F, 0xC66B, 0xC5D3, 0xC5AA, 0xC5F0, 0xC6A7, 0xC7CF, 0xC965, 0xCB69, 0xCDD7, 0xD0AD, 0xD3E4, 0xD77A, 0xDB66, 0xDFA3, 0xE429,
        0xE8F1, 0xEDF1, 0xF321, 0xF877, 0xFDE9, 0x036B, 0x08F7, 0x0E7F, 0x13F9, 0x195B, 0x1E99, 0x23AA, 0x2882, 0x2D19, 0x3165, 0x355C,
        0x38F6, 0x3C2C, 0x3EF6, 0x414E, 0x432E, 0x4491, 0x4574, 0x45D3, 0x45AD, 0x4501, 0x43CE, 0x4216, 0x3FDB, 0x3D20, 0x39E9, 0x363A,
        0x321B, 0x2D92, 0x28A6, 0x2360, 0x1DCA, 0x17ED, 0x11D5, 0x0B8C, 0x051E, 0xFE98, 0xF805, 0xF171, 0xEAEB, 0xE47E, 0xDE37, 0xD822,
        0xD24C, 0xCCC0, 0xC78A, 0xC2B5, 0xBE4A, 0xBA54, 0xB6DB, 0xB3E6, 0xB17C, 0xAFA4, 0xAE63, 0xADBB, 0xADB0, 0xAE43, 0xAF74, 0xB142,
        0xB3AC, 0xB6AE, 0xBA43, 0xBE66, 0xC310, 0xC83A, 0xCDDA, 0xD3E6, 0xDA54, 0xE119, 0xE828, 0xEF74, 0xF6EF, 0xFE8C, 0x063C, 0x0DF0,
        0x1584, 0x1CEF, 0x2422, 0x2B11, 0x31AD, 0x37EB, 0x3DBE, 0x431C, 0x47FA, 0x4C4F, 0x5012, 0x533D, 0x55C9, 0x57B2, 0x58F3, 0x598B,
        0x5979, 0x58BC, 0x5756, 0x5549, 0x529B, 0x4F4E, 0x4B6B, 0x46F8, 0x41FD, 0x3C85, 0x369A, 0x3047, 0x2997, 0x2299, 0x1B58, 0x13E3,
        0x0C49, 0x0497, 0xFCDD, 0xF528, 0xED88, 0xE60B, 0xDEC0, 0xD7B4, 0xD0F5, 0xCA8F, 0xC48F, 0xBF01, 0xB9EE, 0xB561, 0xB162, 0xADF8,
        0xAB2B, 0xA900, 0xA77B, 0xA69E, 0xA66B, 0xA6E3, 0xA805, 0xA9CF, 0xAC3C, 0xAF4A, 0xB2F1, 0xB72B, 0xBBF0, 0xC136, 0xC6F4, 0xCD1F,
        0xD3AA, 0xDA8B, 0xE1B2, 0xE913, 0xF0A0, 0xF84B, 0x0003, 0x07BB, 0x0F66, 0x16F2, 0x1E54, 0x257B, 0x2C5B, 0x32E6, 0x3911, 0x3ECE,
        0x4414, 0x48D9, 0x4D12, 0x50B9, 0x53C6, 0x5633, 0x57FC, 0x591D, 0x5995, 0x5962, 0x5884, 0x56FE, 0x54D3, 0x5205, 0x4E9B, 0x4A9C,
        0x460E, 0x40FB, 0x3B6C, 0x356C, 0x2F06, 0x2847, 0x213A, 0x19EF, 0x1272, 0x0AD2, 0x031D, 0xFB63, 0xF3B1, 0xEC17, 0xE4A2, 0xDD62,
        0xD664, 0xCFB4, 0xC961, 0xC376, 0xBDFF, 0xB905, 0xB492, 0xB0AF, 0xAD63, 0xAAB5, 0xA8A9, 0xA743, 0xA687, 0xA675, 0xA70E, 0xA850,
        0xAA39, 0xACC6, 0xAFF1, 0xB3B5, 0xB80A, 0xBCE8, 0xC246, 0xC81A, 0xCE58, 0xD4F5, 0xDBE3, 0xE317, 0xEA82, 0xF215, 0xF9C4, 0x017D,
        0x0934, 0x10DA, 0x185F, 0x1FB6, 0x26D1, 0x2DA2, 0x341C, 0x3A32, 0x3FDA, 0x4508, 0x49B2, 0x4DD0, 0x515A, 0x5449, 0x5697, 0x5840,
        0x5941, 0x5998, 0x5945, 0x5847, 0x56A1, 0x5456, 0x516A, 0x4DE3, 0x49C8, 0x4520, 0x3FF5, 0x3A4F, 0x343B, 0x2DC3, 0x26F3, 0x1FDA,
        0x1884, 0x10FF, 0x095A, 0x01A3, 0xF9EA, 0xF23B, 0xEAA7, 0xE33B, 0xDC06, 0xD516, 0xCE78, 0xC837, 0xC262, 0xBD01, 0xB820, 0xB3C8,
        0xB002, 0xACD4, 0xAA44, 0xA858, 0xA712, 0xA676, 0xA685, 0xA73E, 0xA8A0, 0xAAA9, 0xAD54, 0xB09D, 0xB47D, 0xB8ED, 0xBDE5, 0xC35A,
        0xC943, 0xCF94, 0xD642, 0xDD3F, 0xE47E, 0xEBF2, 0xF38C, 0xFB3D, 0x02F7, 0x0AAC, 0x124D, 0x19CA, 0x2117, 0x2825, 0x2EE6, 0x354E,
        0x3B50, 0x40E1, 0x45F7, 0x4A87, 0x4E89, 0x51F6, 0x54C6, 0x56F5, 0x587F, 0x595F, 0x5996, 0x5921, 0x5803, 0x563D, 0x53D3, 0x50C9,
        0x4D26, 0x48EF, 0x442D, 0x3EE9, 0x392E, 0x3306, 0x2C7C, 0x259D, 0x1E77, 0x1717, 0x0F8B, 0x07E1, 0x0029, 0xF870, 0xF0C6, 0xE938,
        0xE1D6, 0xDAAD, 0xD3CC, 0xCD3E, 0xC711, 0xC151, 0xBC08, 0xB741, 0xB304, 0xAF5A, 0xAC4A, 0xA9D9, 0xA80C, 0xA6E7, 0xA66C, 0xA69B,
        0xA775, 0xA8F7, 0xAB1F, 0xADE9, 0xB14F, 0xB54C, 0xB9D6, 0xBEE6, 0xC473, 0xCA70, 0xD0D4, 0xD792, 0xDE9D, 0xE5E7, 0xED63, 0xF503,
        0xFCB7, 0x0471, 0x0C23, 0x13BE, 0x1B34, 0x2275, 0x2975, 0x3026, 0x367C, 0x3C69, 0x41E4, 0x46E0, 0x4B56, 0x4F3C, 0x528C, 0x553E,
        0x574D, 0x58B7, 0x5977, 0x598D, 0x58F8, 0x57B9, 0x55D4, 0x534B, 0x5023, 0x4C63, 0x4811, 0x4335, 0x3DDA, 0x3809, 0x31CD, 0x2B32,
        0x2445, 0x1D13, 0x15A9, 0x0E16, 0x0668, 0xFEAF, 0xF6F8, 0xEF52, 0xE7CB, 0xE073, 0xD957, 0xD284, 0xCC08, 0xC5EF, 0xC045, 0xBB14,
        0xB667, 0xB245, 0xAEB8, 0xABC6, 0xA974, 0xA7C7, 0xA6C2, 0xA668, 0xA6B8, 0xA7B2, 0xA954, 0xAB9B, 0xAE84, 0xB207, 0xB61F, 0xBAC4,
        0xBFED, 0xC58F, 0xCBA2, 0xD217, 0xD8E5, 0xDFFD, 0xE752, 0xEED6, 0xF67A, 0xFE31, 0x05EA, 0x0D99, 0x152E, 0x1C9B, 0x23D1, 0x2AC3,
        0x3164, 0x37A6, 0x3D7E, 0x42E2, 0x47C5, 0x4C20, 0x4FEA, 0x531C, 0x55AF, 0x579F, 0x58E8, 0x5988, 0x597D, 0x58C8, 0x5769, 0x5564,
        0x52BC, 0x4F77, 0x4B9A, 0x472D, 0x4239, 0x3CC6, 0x36E0, 0x3091, 0x29E5, 0x22EA, 0x1BAC, 0x1439, 0x0CA0, 0x04EF, 0xFD35, 0xF580,
        0xEDDF, 0xE660, 0xDF12, 0xD803, 0xD140, 0xCAD6, 0xC4D1, 0xBF3D, 0xBA25, 0xB592, 0xB18C, 0xAE1C, 0xAB48, 0xA915, 0xA788, 0xA6A4,
        0xA66A, 0xA6DA, 0xA7F5, 0xA9B7, 0xAC1D, 0xAF24, 0xB2C4, 0xB6F8, 0xBBB6, 0xC0F7, 0xC6B0, 0xCCD6, 0xD35E, 0xDA3B, 0xE15F, 0xE8BE,
        0xF04A, 0xF7F3, 0xFFAB, 0x0764, 0x0F0F, 0x169D, 0x1E01, 0x252B, 0x2C0E, 0x329E, 0x38CD, 0x3E8F, 0x43DB, 0x48A5, 0x4CE5, 0x5092,
        0x53A6, 0x561B, 0x57EB, 0x5914, 0x5993, 0x5968, 0x5892, 0x5713, 0x54EF, 0x5228, 0x4EC6, 0x4ACD, 0x4645, 0x4138, 0x3BAE, 0x35B3,
        0x2F51, 0x2895, 0x218C, 0x1A43, 0x12C8, 0x0B29, 0x0375, 0xFBBB, 0xF409, 0xEC6D, 0xE4F6, 0xDDB3, 0xD6B2, 0xCFFF, 0xC9A7, 0xC3B7,
        0xBE3A, 0xB93B, 0xB4C2, 0xB0D8, 0xAD85, 0xAAD0, 0xA8BD, 0xA750, 0xA68C, 0xA672, 0xA703, 0xA83E, 0xAA20, 0xACA5, 0xAFC9, 0xB386,
        0xB7D5, 0xBCAE, 0xC206, 0xC7D5, 0xCE0F, 0xD4A7, 0xDB93, 0xE2C4, 0xEA2C, 0xF1BE, 0xF96C, 0x0125, 0x08DC, 0x1083, 0x180A, 0x1F64,
        0x2682, 0x2D56, 0x33D4, 0x39EF, 0x3F9C, 0x44D0, 0x4980, 0x4DA5, 0x5135, 0x542B, 0x5680, 0x5831, 0x593A, 0x5998, 0x594C, 0x5856,
        0x56B7, 0x5473, 0x518F, 0x4E0F, 0x49FA, 0x4558, 0x4032, 0x3A92, 0x3482, 0x2E0E, 0x2743, 0x202C, 0x18D9, 0x1156, 0x09B1, 0x01FB,
        0xFA42, 0xF292, 0xEAFC, 0xE38F, 0xDC57, 0xD563, 0xCEC1, 0xC87C, 0xC2A2, 0xBD3C, 0xB855, 0xB3F7, 0xB02A, 0xACF5, 0xAA5E, 0xA86A,
        0xA71D, 0xA67A, 0xA681, 0xA732, 0xA88D, 0xAA8E, 0xAD33, 0xB075, 0xB44E, 0xB8B8, 0xBDA9, 0xC319, 0xC8FD, 0xCF4A, 0xD5F4, 0xDCEE,
        0xE42A, 0xEB9C, 0xF334, 0xFAE5, 0x029F, 0x0A54, 0x11F6, 0x1976, 0x20C5, 0x27D6, 0x2E9B, 0x3507, 0x3B0E, 0x40A4, 0x45BF, 0x4A56,
        0x4E5F, 0x51D2, 0x54AA, 0x56E0, 0x5871, 0x5959, 0x5997, 0x592A, 0x5813, 0x5655, 0x53F2, 0x50EF, 0x4D52, 0x4922, 0x4466, 0x3F28,
        0x3972, 0x334E, 0x2CC8, 0x25ED, 0x1ECA, 0x176C, 0x0FE2, 0x0839, 0x0081, 0xF8C8, 0xF11D, 0xE98D, 0xE229, 0xDAFD, 0xD418, 0xCD87,
        0xC756, 0xC190, 0xBC42, 0xB775, 0xB332, 0xAF81, 0xAC6A, 0xA9F1, 0xA81D, 0xA6F1, 0xA66E, 0xA695, 0xA767, 0xA8E2, 0xAB03, 0xADC6,
        0xB125, 0xB51B, 0xB9A0, 0xBEAA, 0xC431, 0xCA2A, 0xD089, 0xD743, 0xDE4B, 0xE593, 0xED0D, 0xF4AB, 0xFC5F, 0x0419, 0x0BCC, 0x1368,
        0x1AE0, 0x2224, 0x2927, 0x2FDC, 0x3636, 0x3C28, 0x41A8, 0x46AA, 0x4B26, 0x4F13, 0x5269, 0x5522, 0x5739, 0x58AA, 0x5972, 0x598F,
        0x5902, 0x57CB, 0x55ED, 0x536B, 0x504A, 0x4C90, 0x4845, 0x436F, 0x3E1A, 0x384D, 0x3216, 0x2B7F, 0x2495, 0x1D66, 0x15FE, 0x0E6D,
        0x06C0, 0xFF07, 0xF750, 0xEFA8, 0xE820, 0xE0C5, 0xD9A6, 0xD2D0, 0xCC50, 0xC633, 0xC083, 0xBB4D, 0xB699, 0xB271, 0xAEDE, 0xABE4,
        0xA98B, 0xA7D7, 0xA6CA, 0xA668, 0xA6B0, 0xA7A3, 0xA93E, 0xAB7E, 0xAE5F, 0xB1DC, 0xB5ED, 0xBA8C, 0xBFAF, 0xC54D, 0xCB5A, 0xD1CC,
        0xD896, 0xDFAB, 0xE6FD, 0xEE7F, 0xF623, 0xFDD9, 0x0592, 0x0D42, 0x14D9, 0x1C48, 0x2380, 0x2A76, 0x311A, 0x3761, 0x3D3E, 0x42A7,
        0x4790, 0x4BF2, 0x4FC2, 0x52FB, 0x5595, 0x578D, 0x58DD, 0x5985, 0x5981, 0x58D4, 0x577D, 0x557F, 0x52DE, 0x4FA0, 0x4BC9, 0x4763,
        0x4274, 0x3D07, 0x3725, 0x30DB, 0x2A33, 0x233B, 0x1C00, 0x148F, 0x0CF7, 0x0547, 0xFD8D, 0xF5D7, 0xEE35, 0xE6B4, 0xDF64, 0xD852,
        0xD18B, 0xCB1D, 0xC514, 0xBF7A, 0xBA5C, 0xB5C3, 0xB1B7, 0xAE40, 0xAB65, 0xA92B, 0xA797, 0xA6AB, 0xA669, 0xA6D2, 0xA7E4, 0xA99F,
        0xABFE, 0xAEFE, 0xB298, 0xB6C5, 0xBB7D, 0xC0B9, 0xC66C, 0xCC8E, 0xD312, 0xD9EB, 0xE10C, 0xE869, 0xEFF3, 0xF79B, 0xFF53, 0x070C,
        0x0EB8, 0x1648, 0x1DAD, 0x24DA, 0x2BC1, 0x3255, 0x3888, 0x3E50, 0x43A1, 0x4871, 0x4CB8, 0x506C, 0x5387, 0x5602, 0x57DA, 0x590A,
        0x5991, 0x596D, 0x589F, 0x5728, 0x550B, 0x524B, 0x4EEF, 0x4AFD, 0x467C, 0x4174, 0x3BF0, 0x35F9, 0x2F9C, 0x28E4, 0x21DE, 0x1A97,
        0x131E, 0x0B81, 0x03CD, 0xFC13, 0xF460, 0xECC3, 0xE54A, 0xDE05, 0xD700, 0xD049, 0xC9ED, 0xC3F9, 0xBE76, 0xB971, 0xB4F2, 0xB102,
        0xADA8, 0xAAEB, 0xA8D1, 0xA75C, 0xA691, 0xA670, 0xA6F9, 0xA82C, 0xAA07, 0xAC85, 0xAFA2, 0xB359, 0xB7A1, 0xBC74, 0xC1C7, 0xC790,
        0xCDC5, 0xD45A, 0xDB42, 0xE270, 0xE9D7, 0xF167, 0xF914, 0x00CC, 0x0885, 0x102C, 0x17B5, 0x1F11, 0x2632, 0x2D0A, 0x338C, 0x39AC,
        0x3F5E, 0x4497, 0x494E, 0x4D78, 0x5110, 0x540D, 0x5669, 0x5821, 0x5931, 0x5998, 0x5953, 0x5864, 0x56CD, 0x5491, 0x51B3, 0x4E3A,
        0x4A2B, 0x4590, 0x4070, 0x3AD5, 0x34CA, 0x2E5A, 0x2792, 0x207F, 0x192D, 0x11AC, 0x0A09, 0x0253, 0xFA9A, 0xF2E9, 0xEB52, 0xE3E2,
        0xDCA8, 0xD5B1, 0xCF0B, 0xC8C2, 0xC2E2, 0xBD77, 0xB88A, 0xB426, 0xB052, 0xAD16, 0xAA78, 0xA87D, 0xA728, 0xA67D, 0xA67D, 0xA727,
        0xA87A, 0xAA74, 0xAD11, 0xB04C, 0xB41F, 0xB883, 0xBD6E, 0xC2D9, 0xC8B8, 0xCF00, 0xD5A6, 0xDC9D, 0xE3D7, 0xEB46, 0xF2DD, 0xFA8D,
        0x0247, 0x09FD, 0x11A0, 0x1921, 0x2073, 0x2787, 0x2E4F, 0x34BF, 0x3ACB, 0x4067, 0x4588, 0x4A24, 0x4E34, 0x51AE, 0x548D, 0x56CA,
        0x5862, 0x5952, 0x5998, 0x5933, 0x5823, 0x566C, 0x5411, 0x5115, 0x4D7F, 0x4955, 0x449F, 0x3F67, 0x39B5, 0x3396, 0x2D15, 0x263D,
        0x1F1D, 0x17C1, 0x1039, 0x0891, 0x00D9, 0xF920, 0xF174, 0xE9E3, 0xE27C, 0xDB4E, 0xD465, 0xCDD0, 0xC79A, 0xC1D0, 0xBC7C, 0xB7A8,
        0xB35F, 0xAFA8, 0xAC89, 0xAA0A, 0xA82F, 0xA6FA, 0xA670, 0xA690, 0xA75B, 0xA8CE, 0xAAE7, 0xADA3, 0xB0FC, 0xB4EB, 0xB969, 0xBE6E,
        0xC3EF, 0xC9E4, 0xD03F, 0xD6F5, 0xDDF9, 0xE53F, 0xECB7, 0xF454, 0xFC07, 0x03C1, 0x0B74, 0x1312, 0x1A8C, 0x21D2, 0x28D9, 0x2F91,
        0x35EF, 0x3BE7, 0x416C, 0x4674, 0x4AF6, 0x4EEA, 0x5247, 0x5507, 0x5725, 0x589D, 0x596D, 0x5992, 0x590C, 0x57DC, 0x5606, 0x538B,
        0x5071, 0x4CBE, 0x4879, 0x43A9, 0x3E59, 0x3892, 0x325F, 0x2BCC, 0x24E6, 0x1DB9, 0x1654, 0x0EC4, 0x0718, 0xFF60, 0xF7A7, 0xEFFF,
        0xE875, 0xE118, 0xD9F6, 0xD31C, 0xCC98, 0xC676, 0xC0C1, 0xBB85, 0xB6CC, 0xB29E, 0xAF03, 0xAC03, 0xA9A2, 0xA7E7, 0xA6D3, 0xA669,
        0xA6AA, 0xA794, 0xA928, 0xAB61, 0xAE3B, 0xB1B1, 0xB5BC, 0xBA54, 0xBF72, 0xC50A, 0xCB13, 0xD180, 0xD847, 0xDF58, 0xE6A8, 0xEE29,
        0xF5CB, 0xFD81, 0x053A, 0x0CEB, 0x1483, 0x1BF4, 0x232F, 0x2A28, 0x30D0, 0x371C, 0x3CFE, 0x426C, 0x475B, 0x4BC3, 0x4F9A, 0x52D9,
        0x557B, 0x577A, 0x58D2, 0x5981, 0x5985, 0x58DF, 0x578F, 0x5599, 0x5300, 0x4FC8, 0x4BF8, 0x4798, 0x42AF, 0x3D47, 0x376B, 0x3124,
        0x2A81, 0x238C, 0x1C53, 0x14E5, 0x0D4E, 0x059F, 0xFDE5, 0xF62F, 0xEE8B, 0xE709, 0xDFB6, 0xD8A1, 0xD1D7, 0xCB64, 0xC556, 0xBFB8,
        0xBA94, 0xB5F4, 0xB1E2, 0xAE64, 0xAB82, 0xA941, 0xA7A5, 0xA6B1, 0xA668, 0xA6C9, 0xA7D5, 0xA988, 0xABE0, 0xAED8, 0xB26B, 0xB692,
        0xBB45, 0xC07A, 0xC629, 0xCC46, 0xD2C5, 0xD99B, 0xE0BA, 0xE814, 0xEF9C, 0xF743, 0xFEFB, 0x06B4, 0x0E61, 0x15F2, 0x1D5A, 0x248A,
        0x2B74, 0x320C, 0x3844, 0x3E11, 0x4367, 0x483D, 0x4C8A, 0x5045, 0x5367, 0x55E9, 0x57C9, 0x5901, 0x598F, 0x5973, 0x58AC, 0x573C,
        0x5526, 0x526E, 0x4F19, 0x4B2D, 0x46B2, 0x41B0, 0x3C31, 0x3640, 0x2FE7, 0x2932, 0x222F, 0x1AEC, 0x1374, 0x0BD8, 0x0425, 0xFC6B,
        0xF4B7, 0xED19, 0xE59F, 0xDE56, 0xD74E, 0xD094, 0xCA34, 0xC43A, 0xBEB3, 0xB9A7, 0xB522, 0xB12B, 0xADCB, 0xAB07, 0xA8E5, 0xA769,
        0xA696, 0xA66D, 0xA6EF, 0xA81B, 0xA9EE, 0xAC65, 0xAF7B, 0xB32B, 0xB76D, 0xBC3A, 0xC187, 0xC74C, 0xCD7D, 0xD40D, 0xDAF2, 0xE21D,
        0xE981, 0xF110, 0xF8BC, 0x0074, 0x082D, 0x0FD6, 0x1760, 0x1EBF, 0x25E2, 0x2CBE, 0x3344, 0x3968, 0x3F1F, 0x445E, 0x491B, 0x4D4C,
        0x50EA, 0x53EE, 0x5652, 0x5811, 0x5929, 0x5997, 0x595A, 0x5873, 0x56E3, 0x54AE, 0x51D7, 0x4E65, 0x4A5D, 0x45C7, 0x40AD, 0x3B17,
        0x3511, 0x2EA5, 0x27E1, 0x20D1, 0x1982, 0x1202, 0x0A61, 0x02AB, 0xFAF2, 0xF341, 0xEBA8, 0xE436, 0xDCF9, 0xD5FF, 0xCF55, 0xC907,
        0xC323, 0xBDB2, 0xB8BF, 0xB455, 0xB07A, 0xAD37, 0xAA92, 0xA890, 0xA734, 0xA681, 0xA679, 0xA71C, 0xA867, 0xAA5A, 0xACF0, 0xB024,
        0xB3F0, 0xB84E, 0xBD33, 0xC299, 0xC873, 0xCEB7, 0xD559, 0xDC4C, 0xE383, 0xEAF0, 0xF286, 0xFA35, 0x01EF, 0x09A5, 0x1149, 0x18CD,
        0x2021, 0x2738, 0x2E04, 0x3478, 0x3A89, 0x402A, 0x4550, 0x49F3, 0x4E09, 0x518A, 0x546F, 0x56B4, 0x5854, 0x594B, 0x5998, 0x593B,
        0x5833, 0x5684, 0x542F, 0x513A, 0x4DAB, 0x4987, 0x44D8, 0x3FA5, 0x39F9, 0x33DE, 0x2D61, 0x268D, 0x1F70, 0x1816, 0x108F, 0x08E9,
        0x0131, 0xF978, 0xF1CB, 0xEA38, 0xE2CF, 0xDB9E, 0xD4B2, 0xCE19, 0xC7DF, 0xC20F, 0xBCB6, 0xB7DD, 0xB38D, 0xAFCF, 0xACAA, 0xAA23,
        0xA840, 0xA705, 0xA672, 0xA68B, 0xA74E, 0xA8BA, 0xAACC, 0xAD81, 0xB0D2, 0xB4BB, 0xB933, 0xBE32, 0xC3AE, 0xC99D, 0xCFF4, 0xD6A7,
        0xDDA8, 0xE4EA, 0xEC61, 0xF3FC, 0xFBAF, 0x0369, 0x0B1D, 0x12BC, 0x1A37, 0x2181, 0x288A, 0x2F47, 0x35A9, 0x3BA5, 0x412F, 0x463D,
        0x4AC6, 0x4EC0, 0x5224, 0x54EB, 0x5710, 0x5890, 0x5967, 0x5994, 0x5915, 0x57EE, 0x561E, 0x53AB, 0x5098, 0x4CEB, 0x48AC, 0x43E3,
        0x3E98, 0x38D6, 0x32A8, 0x2C19, 0x2536, 0x1E0C, 0x16A9, 0x0F1B, 0x0770, 0xFFB8, 0xF7FF, 0xF056, 0xE8CA, 0xE16B, 0xDA46, 0xD369,
        0xCCE0, 0xC6BA, 0xC100, 0xBBBE, 0xB6FF, 0xB2CA, 0xAF29, 0xAC22, 0xA9BA, 0xA7F7, 0xA6DC, 0xA66A, 0xA6A3, 0xA786, 0xA912, 0xAB44,
        0xAE17, 0xB186, 0xB58B, 0xBA1D, 0xBF35, 0xC4C8, 0xCACC, 0xD135, 0xD7F8, 0xDF06, 0xE654, 0xEDD2, 0xF574, 0xFD29, 0x04E2, 0x0C94,
        0x142D, 0x1BA0, 0x22DE, 0x29DA, 0x3086, 0x36D6, 0x3CBD, 0x4230, 0x4726, 0x4B94, 0x4F71, 0x52B8, 0x5561, 0x5767, 0x58C6, 0x597D,
        0x5989, 0x58EA, 0x57A2, 0x55B3, 0x5321, 0x4FF0, 0x4C27, 0x47CD, 0x42EA, 0x3D87, 0x37B0, 0x316E, 0x2ACE, 0x23DD, 0x1CA7, 0x153A,
        0x0DA6, 0x05F7, 0xFE3E, 0xF687, 0xEEE2, 0xE75E, 0xE008, 0xD8F0, 0xD222, 0xCBAC, 0xC599, 0xBFF5, 0xBACC, 0xB626, 0xB20D, 0xAE89,
        0xABA0, 0xA957, 0xA7B4, 0xA6B9, 0xA668, 0xA6C1, 0xA7C5, 0xA971, 0xABC2, 0xAEB3, 0xB23F, 0xB660, 0xBB0C, 0xC03C, 0xC5E6, 0xCBFE,
        0xD279, 0xD94B, 0xE067, 0xE7BF, 0xEF45, 0xF6EC, 0xFEA3, 0x065C, 0x0E0A, 0x159D, 0x1D07, 0x243A, 0x2B27, 0x31C3, 0x37FF, 0x3DD1,
        0x432D, 0x4809, 0x4C5C, 0x501D, 0x5346, 0x55D0, 0x57B7, 0x58F6, 0x598C, 0x5977, 0x58B8, 0x5750, 0x5542, 0x5291, 0x4F42, 0x4B5D,
        0x46E8, 0x41EC, 0x3C72, 0x3686, 0x3031, 0x2980, 0x2281, 0x1B40, 0x13CA, 0x0C2F, 0x047D, 0xFCC3, 0xF50F, 0xED6F, 0xE5F3, 0xDEA8,
        0xD79D, 0xD0DF, 0xCA7A, 0xC47C, 0xBEEF, 0xB9DE, 0xB553, 0xB155, 0xADEE, 0xAB23, 0xA8FA, 0xA777, 0xA69C, 0xA66C, 0xA6E6, 0xA80A,
        0xA9D6, 0xAC46, 0xAF55, 0xB2FE, 0xB73A, 0xBC00, 0xC148, 0xC708, 0xCD34, 0xD3C1, 0xDAA2, 0xE1CA, 0xE92C, 0xF0BA, 0xF864, 0x001C,
        0x07D5, 0x0F7F, 0x170B, 0x1E6C, 0x2592, 0x2C71, 0x32FB, 0x3924, 0x3EE1, 0x4425, 0x48E8, 0x4D1F, 0x50C4, 0x53CF, 0x563A, 0x5801,
        0x5920, 0x5995, 0x5960, 0x5880, 0x56F8, 0x54CA, 0x51FB, 0x4E8F, 0x4A8E, 0x45FE, 0x40EA, 0x3B59, 0x3558, 0x2EF0, 0x2830, 0x2123,
        0x19D6, 0x1259, 0x0AB8, 0x0303, 0xFB4A, 0xF398, 0xEBFE, 0xE48A, 0xDD4A, 0xD64D, 0xCF9F, 0xC94D, 0xC363, 0xBDED, 0xB8F5, 0xB484,
        0xB0A3, 0xAD59, 0xAAAD, 0xA8A3, 0xA740, 0xA686, 0xA676, 0xA711, 0xA855, 0xAA40, 0xACCF, 0xAFFC, 0xB3C2, 0xB819, 0xBCF9, 0xC259,
        0xC82E, 0xCE6D, 0xD50B, 0xDBFB, 0xE32F, 0xEA9B, 0xF22F, 0xF9DD, 0x0196, 0x094D, 0x10F3, 0x1878, 0x1FCE, 0x26E8, 0x2DB8, 0x3431,
        0x3A46, 0x3FEC, 0x4518, 0x49C1, 0x4DDD, 0x5165, 0x5452, 0x569E, 0x5845, 0x5944, 0x5998, 0x5942, 0x5842, 0x569A, 0x544D, 0x515F,
        0x4DD7, 0x49B9, 0x4510, 0x3FE3, 0x3A3C, 0x3426, 0x2DAD, 0x26DC, 0x1FC2, 0x186B, 0x10E6, 0x0940, 0x0189, 0xF9D0, 0xF222, 0xEA8E,
        0xE323, 0xDBEF, 0xD500, 0xCE62, 0xC823, 0xC24F, 0xBCF0, 0xB811, 0xB3BB, 0xAFF6, 0xACCA, 0xAA3C, 0xA852, 0xA70F, 0xA675, 0xA686,
        0xA742, 0xA8A6, 0xAAB1, 0xAD5E, 0xB0A9, 0xB48B, 0xB8FD, 0xBDF6, 0xC36D, 0xC957, 0xCFAA, 0xD659, 0xDD56, 0xE496, 0xEC0B, 0xF3A5,
        0xFB57, 0x0310, 0x0AC5, 0x1266, 0x19E3, 0x212F, 0x283C, 0x2EFC, 0x3562, 0x3B63, 0x40F3, 0x4607, 0x4A95, 0x4E95, 0x5200, 0x54CF,
        0x56FB, 0x5883, 0x5961, 0x5995, 0x591F, 0x57FE, 0x5636, 0x53CA, 0x50BE, 0x4D19, 0x48E0, 0x441C, 0x3ED7, 0x391A, 0x32F0, 0x2C66,
        0x2586, 0x1E5F, 0x16FE, 0x0F72, 0x07C8, 0x000F, 0xF857, 0xF0AD, 0xE91F, 0xE1BE, 0xDA96, 0xD3B5, 0xCD29, 0xC6FE, 0xC13F, 0xBBF8,
        0xB732, 0xB2F7, 0xAF4F, 0xAC41, 0xA9D2, 0xA807, 0xA6E5, 0xA66B, 0xA69D, 0xA779, 0xA8FD, 0xAB27, 0xADF3, 0xB15C, 0xB55A, 0xB9E6,
        0xBEF8, 0xC486, 0xCA85, 0xD0EA, 0xD7A9, 0xDEB4, 0xE600, 0xED7C, 0xF51C, 0xFCD1, 0x048A, 0x0C3C, 0x13D7, 0x1B4C, 0x228D, 0x298C,
        0x303C, 0x3690, 0x3C7C, 0x41F5, 0x46F0, 0x4B64, 0x4F48, 0x5296, 0x5546, 0x5753, 0x58BA, 0x5978, 0x598C, 0x58F5, 0x57B4, 0x55CC,
        0x5341, 0x5018, 0x4C55, 0x4801, 0x4324, 0x3DC7, 0x37F5, 0x31B8, 0x2B1C, 0x242D, 0x1CFA, 0x1590, 0x0DFD, 0x064F, 0xFE96, 0xF6DE,
        0xEF38, 0xE7B2, 0xE05B, 0xD93F, 0xD26E, 0xCBF3, 0xC5DC, 0xC033, 0xBB04, 0xB658, 0xB239, 0xAEAE, 0xABBD, 0xA96E, 0xA7C3, 0xA6C0,
        0xA668, 0xA6BA, 0xA7B6, 0xA95A, 0xABA4, 0xAE8E, 0xB214, 0xB62E, 0xBAD4, 0xBFFF, 0xC5A3, 0xCBB6, 0xD22E, 0xD8FC, 0xE015, 0xE76A,
        0xEEEF, 0xF694, 0xFE4B, 0x0604, 0x0DB3, 0x1547, 0x1CB3, 0x23E9, 0x2ADA, 0x3179, 0x37BA, 0x3D91, 0x42F3, 0x47D5, 0x4C2E, 0x4FF6,
        0x5325, 0x55B7, 0x57A5, 0x58EC, 0x5989, 0x597C, 0x58C4, 0x5764, 0x555C, 0x52B3, 0x4F6B, 0x4B8C, 0x471E, 0x4228, 0x3CB3, 0x36CB,
        0x307B, 0x29CE, 0x22D2, 0x1B93, 0x1420, 0x0C87, 0x04D5, 0xFD1C, 0xF566, 0xEDC5, 0xE647, 0xDEFA, 0xD7EC, 0xD12A, 0xCAC1, 0xC4BE,
        0xBF2C, 0xBA15, 0xB583, 0xB180, 0xAE12, 0xAB40, 0xA90F, 0xA784, 0xA6A2, 0xA66A, 0xA6DD, 0xA7F9, 0xA9BE, 0xAC26, 0xAF2F, 0xB2D1,
        0xB706, 0xBBC7, 0xC109, 0xC6C4, 0xCCEB, 0xD374, 0xDA52, 0xE177, 0xE8D7, 0xF063, 0xF80C, 0xFFC5, 0x077D, 0x0F28, 0x16B6, 0x1E19,
        0x2542, 0x2C24, 0x32B3, 0x38E0, 0x3EA2, 0x43EC, 0x48B4, 0x4CF2, 0x509E, 0x53AF, 0x5622, 0x57F0, 0x5917, 0x5994, 0x5966, 0x588E,
        0x570D, 0x54E7, 0x521E, 0x4EB9, 0x4ABF, 0x4635, 0x4126, 0x3B9B, 0x359E, 0x2F3B, 0x287E, 0x2174, 0x1A2B, 0x12AF, 0x0B10, 0x035B,
        0xFBA2, 0xF3EF, 0xEC54, 0xE4DE, 0xDD9C, 0xD69B, 0xCFE9, 0xC993, 0xC3A4, 0xBE29, 0xB92B, 0xB4B4, 0xB0CC, 0xAD7B, 0xAAC8, 0xA8B7,
        0xA74C, 0xA68A, 0xA673, 0xA706, 0xA843, 0xAA27, 0xACAE, 0xAFD5, 0xB394, 0xB7E4, 0xBCBE, 0xC219, 0xC7E9, 0xCE24, 0xD4BE, 0xDBAA,
        0xE2DC, 0xEA45, 0xF1D8, 0xF985, 0x013E, 0x08F6, 0x109C, 0x1823, 0x1F7C, 0x2699, 0x2D6C, 0x33E9, 0x3A03, 0x3FAE, 0x44E0, 0x498F,
        0x4DB1, 0x5140, 0x5434, 0x5687, 0x5835, 0x593C, 0x5998, 0x594A, 0x5851, 0x56B1, 0x546B, 0x5184, 0x4E02, 0x49EB, 0x4548, 0x4020,
        0x3A7F, 0x346D, 0x2DF8, 0x272C, 0x2014, 0x18C0, 0x113C, 0x0998, 0x01E1, 0xFA28, 0xF279, 0xEAE3, 0xE376, 0xDC40, 0xD54D, 0xCEAC,
        0xC868, 0xC28F, 0xBD2B, 0xB846, 0xB3E9, 0xB01E, 0xACEB, 0xAA56, 0xA865, 0xA71A, 0xA679, 0xA682, 0xA736, 0xA893, 0xAA96, 0xAD3C,
        0xB080, 0xB45C, 0xB8C7, 0xBDBB, 0xC32C, 0xC912, 0xCF60, 0xD60B, 0xDD05, 0xE443, 0xEBB5, 0xF34E, 0xFAFF, 0x02B8, 0x0A6E, 0x120F,
        0x198E, 0x20DD, 0x27ED, 0x2EB0, 0x351B, 0x3B21, 0x40B6, 0x45CF, 0x4A64, 0x4E6B, 0x51DC, 0x54B2, 0x56E6, 0x5875, 0x595B, 0x5996,
        0x5928, 0x580F, 0x564E, 0x53E9, 0x50E4, 0x4D45, 0x4913, 0x4456, 0x3F16, 0x395E, 0x3339, 0x2CB2, 0x25D6, 0x1EB2, 0x1754, 0x0FC9,
        0x0820, 0x0067, 0xF8AF, 0xF103, 0xE975, 0xE211, 0xDAE6, 0xD402, 0xCD72, 0xC742, 0xC17E, 0xBC31, 0xB766, 0xB324, 0xAF76, 0xAC60,
        0xA9EA, 0xA818, 0xA6EE, 0xA66D, 0xA697, 0xA76B, 0xA8E8, 0xAB0B, 0xADD0, 0xB132, 0xB529, 0xB9AF, 0xBEBC, 0xC444, 0xCA3E, 0xD09F,
        0xD75A, 0xDE63, 0xE5AB, 0xED26, 0xF4C5, 0xFC79, 0x0432, 0x0BE5, 0x1381, 0x1AF8, 0x223C, 0x293E, 0x2FF2, 0x364A, 0x3C3B, 0x41B9,
        0x46BA, 0x4B34, 0x4F1F, 0x5273, 0x552A, 0x573F, 0x58AE, 0x5973, 0x598E, 0x58FF, 0x57C6, 0x55E6, 0x5362, 0x503F, 0x4C83, 0x4836,
        0x435F, 0x3E07, 0x383A, 0x3201, 0x2B69, 0x247E, 0x1D4E, 0x15E6, 0x0E54, 0x06A7, 0xFEEE, 0xF736, 0xEF8F, 0xE807, 0xE0AD, 0xD98F,
        0xD2BA, 0xCC3B, 0xC61F, 0xC071, 0xBB3C, 0xB68A, 0xB265, 0xAED3, 0xABDB, 0xA984, 0xA7D2, 0xA6C8, 0xA668, 0xA6B2, 0xA7A7, 0xA944,
        0xAB86, 0xAE6A, 0xB1E8, 0xB5FC, 0xBA9C, 0xBFC1, 0xC560, 0xCB6F, 0xD1E2, 0xD8AD, 0xDFC2, 0xE716, 0xEE98, 0xF63C, 0xFDF3, 0x05AC,
        0x0D5C, 0x14F2, 0x1C60, 0x2398, 0x2A8C, 0x3130, 0x3775, 0x3D51, 0x42B8, 0x47A0, 0x4BFF, 0x4FCE, 0x5304, 0x559D, 0x5792, 0x58E1,
        0x5986, 0x5980, 0x58D0, 0x5777, 0x5577, 0x52D4, 0x4F94, 0x4BBC, 0x4753, 0x4263, 0x3CF4, 0x3711, 0x30C5, 0x2A1C, 0x2323, 0x1BE7,
        0x1476, 0x0CDE, 0x052D, 0xFD74, 0xF5BE, 0xEE1C, 0xE69C, 0xDF4C, 0xD83B, 0xD175, 0xCB08, 0xC500, 0xBF69, 0xBA4C, 0xB5B4, 0xB1AA,
        0xAE35, 0xAB5C, 0xA925, 0xA792, 0xA6A9, 0xA669, 0xA6D4, 0xA7E9, 0xA9A6, 0xAC07, 0xAF09, 0xB2A4, 0xB6D3, 0xBB8E, 0xC0CB, 0xC680,
        0xCCA3, 0xD328, 0xDA02, 0xE124, 0xE882, 0xF00C, 0xF7B5, 0xFF6D, 0x0725, 0x0ED1, 0x1661, 0x1DC6, 0x24F2, 0x2BD8, 0x326A, 0x389C,
        0x3E63, 0x43B2, 0x4881, 0x4CC5, 0x5077, 0x5390, 0x5609, 0x57DF, 0x590D, 0x5992, 0x596C, 0x589B, 0x5722, 0x5503, 0x5241, 0x4EE3,
        0x4AEF, 0x466C, 0x4163, 0x3BDD, 0x35E5, 0x2F86, 0x28CD, 0x21C6, 0x1A7F, 0x1305, 0x0B67, 0x03B3, 0xFBFA, 0xF447, 0xECAA, 0xE532,
        0xDDED, 0xD6E9, 0xD034, 0xC9D9, 0xC3E6, 0xBE65, 0xB961, 0xB4E4, 0xB0F6, 0xAD9E, 0xAAE3, 0xA8CB, 0xA759, 0xA68F, 0xA670, 0xA6FC,
        0xA831, 0xAA0E, 0xAC8E, 0xAFAE, 0xB366, 0xB7B0, 0xBC84, 0xC1D9, 0xC7A4, 0xCDDB, 0xD471, 0xDB5A, 0xE289, 0xE9F0, 0xF181, 0xF92D,
        0x00E6, 0x089E, 0x1046, 0x17CE, 0x1F29, 0x2649, 0x2D20, 0x33A1, 0x39BF, 0x3F70, 0x44A7, 0x495C, 0x4D85, 0x511B, 0x5415, 0x5670,
        0x5826, 0x5934, 0x5998, 0x5951, 0x5860, 0x56C7, 0x5488, 0x51A9, 0x4E2D, 0x4A1D, 0x4580, 0x405E, 0x3AC1, 0x34B5, 0x2E44, 0x277B,
        0x2067, 0x1915, 0x1193, 0x09F0, 0x0239, 0xFA80, 0xF2D0, 0xEB39, 0xE3CA, 0xDC90, 0xD59B, 0xCEF5, 0xC8AE, 0xC2CF, 0xBD66, 0xB87B,
        0xB418, 0xB046, 0xAD0C, 0xAA70, 0xA877, 0xA725, 0xA67C, 0xA67E, 0xA72A, 0xA87F, 0xAA7C, 0xAD1B, 0xB058, 0xB42D, 0xB892, 0xBD80,
        0xC2EC, 0xC8CC, 0xCF16, 0xD5BD, 0xDCB4, 0xE3EF, 0xEB5F, 0xF2F6, 0xFAA7, 0x0260, 0x0A16, 0x11B9, 0x193A, 0x208B, 0x279E, 0x2E65,
        0x34D4, 0x3ADF, 0x4079, 0x4598, 0x4A33, 0x4E40, 0x51B8, 0x5495, 0x56D0, 0x5866, 0x5954, 0x5997, 0x5930, 0x581F, 0x5666, 0x5408,
        0x510A, 0x4D72, 0x4946, 0x448E, 0x3F54, 0x39A2, 0x3381, 0x2CFE, 0x2626, 0x1F05, 0x17A9, 0x101F, 0x0877, 0x00BF, 0xF907, 0xF15A,
        0xE9CA, 0xE264, 0xDB36, 0xD44F, 0xCDBB, 0xC786, 0xC1BD, 0xBC6B, 0xB799, 0xB352, 0xAF9C, 0xAC80, 0xAA03, 0xA82A, 0xA6F8, 0xA66F,
        0xA692, 0xA75E, 0xA8D4, 0xAAEF, 0xADAD, 0xB108, 0xB4F9, 0xB979, 0xBE7F, 0xC403, 0xC9F8, 0xD054, 0xD70C, 0xDE11, 0xE557, 0xECD0,
        0xF46D, 0xFC21, 0x03DA, 0x0B8E, 0x132B, 0x1AA4, 0x21EA, 0x28F0, 0x2FA7, 0x3604, 0x3BFA, 0x417D, 0x4684, 0x4B04, 0x4EF6, 0x5251,
        0x550F, 0x572B, 0x58A1, 0x596E, 0x5991, 0x5909, 0x57D7, 0x55FF, 0x5382, 0x5066, 0x4CB1, 0x486A, 0x4399, 0x3E47, 0x387E, 0x324A,
        0x2BB6, 0x24CE, 0x1DA1, 0x163B, 0x0EAB, 0x06FF, 0xFF46, 0xF78E, 0xEFE6, 0xE85C, 0xE100, 0xD9DF, 0xD306, 0xCC83, 0xC662, 0xC0AF,
        0xBB75, 0xB6BD, 0xB291, 0xAEF8, 0xABFA, 0xA99C, 0xA7E2, 0xA6D0, 0xA669, 0xA6AC, 0xA799, 0xA92E, 0xAB69, 0xAE45, 0xB1BD, 0xB5CA,
        0xBA65, 0xBF84, 0xC51E, 0xCB28, 0xD196, 0xD85E, 0xDF70, 0xE6C1, 0xEE42, 0xF5E5, 0xFD9B, 0x0554, 0x0D04, 0x149C, 0x1C0C, 0x2347,
        0x2A3F, 0x30E6, 0x3730, 0x3D11, 0x427D, 0x476B, 0x4BD0, 0x4FA6, 0x52E3, 0x5583, 0x577F, 0x58D5, 0x5982, 0x5984, 0x58DC, 0x578A,
        0x5591, 0x52F6, 0x4FBC, 0x4BEB, 0x4788, 0x429E, 0x3D35, 0x3757, 0x310F, 0x2A6A, 0x2374, 0x1C3B, 0x14CC, 0x0D35, 0x0585, 0xFDCC,
        0xF616, 0xEE72, 0xE6F0, 0xDF9E, 0xD88A, 0xD1C1, 0xCB4F, 0xC543, 0xBFA6, 0xBA84, 0xB5E6, 0xB1D5, 0xAE5A, 0xAB7A, 0xA93A, 0xA7A1,
        0xA6AF, 0xA668, 0xA6CC, 0xA7D9, 0xA98F, 0xABE9, 0xAEE3, 0xB278, 0xB6A1, 0xBB55, 0xC08C, 0xC63D, 0xCC5B, 0xD2DB, 0xD9B2, 0xE0D2,
        0xE82D, 0xEFB5, 0xF75D, 0xFF15, 0x06CD, 0x0E7A, 0x160B, 0x1D72, 0x24A1, 0x2B8B, 0x3221, 0x3858, 0x3E23, 0x4378, 0x484D, 0x4C97,
        0x5050, 0x5370, 0x55F1, 0x57CE, 0x5903, 0x5990, 0x5971, 0x58A8, 0x5736, 0x551E, 0x5264, 0x4F0D, 0x4B1F, 0x46A2, 0x419F, 0x3C1E,
        0x362B, 0x2FD1, 0x291B, 0x2218, 0x1AD3, 0x135B, 0x0BBF, 0x040C, 0xFC52, 0xF49E, 0xED00, 0xE586, 0xDE3F, 0xD738, 0xD07E, 0xCA1F,
        0xC427, 0xBEA1, 0xB997, 0xB514, 0xB11F, 0xADC1, 0xAAFF, 0xA8DF, 0xA766, 0xA695, 0xA66E, 0xA6F2, 0xA820, 0xA9F5, 0xAC6E, 0xAF87,
        0xB338, 0xB77C, 0xBC4B, 0xC19A, 0xC760, 0xCD92, 0xD424, 0xDB09, 0xE235, 0xE99A, 0xF12A, 0xF8D6, 0x008E, 0x0846, 0x0FEF, 0x1779,
        0x1ED7, 0x25F9, 0x2CD4, 0x3359, 0x397C, 0x3F31, 0x446F, 0x492A, 0x4D59, 0x50F5, 0x53F7, 0x5659, 0x5816, 0x592B, 0x5997, 0x5958,
        0x586E, 0x56DD, 0x54A5, 0x51CD, 0x4E58, 0x4A4E, 0x45B7, 0x409B, 0x3B04, 0x34FC, 0x2E8F, 0x27CA, 0x20B9, 0x1969, 0x11E9, 0x0A47,
        0x0292, 0xFAD8, 0xF327, 0xEB8F, 0xE41E, 0xDCE2, 0xD5E8, 0xCF3F, 0xC8F3, 0xC310, 0xBDA1, 0xB8B0, 0xB447, 0xB06F, 0xAD2E, 0xAA8A,
        0xA88A, 0xA730, 0xA680, 0xA67A, 0xA71F, 0xA86D, 0xAA62, 0xACFA, 0xB030, 0xB3FE, 0xB85D, 0xBD45, 0xC2AB, 0xC887, 0xCECC, 0xD56F,
        0xDC63, 0xE39B, 0xEB09, 0xF29F, 0xFA4F, 0x0208, 0x09BF, 0x1163, 0x18E5, 0x2039, 0x274F, 0x2E1A, 0x348D, 0x3A9C, 0x403B, 0x4560,
        0x4A01, 0x4E15, 0x5194, 0x5478, 0x56BB, 0x5858, 0x594D, 0x5998, 0x5938, 0x582F, 0x567D, 0x5426, 0x512F, 0x4D9E, 0x4979, 0x44C7,
        0x3F93, 0x39E5, 0x33C9, 0x2D4B, 0x2676, 0x1F58, 0x17FE, 0x1076, 0x08CF, 0x0117, 0xF95F, 0xF1B1, 0xEA1F, 0xE2B7, 0xDB87, 0xD49C,
        0xCE04, 0xC7CB, 0xC1FD, 0xBCA5, 0xB7CD, 0xB380, 0xAFC3, 0xACA0, 0xAA1C, 0xA83B, 0xA702, 0xA672, 0xA68C, 0xA752, 0xA8C0, 0xAAD4,
        0xAD8B, 0xB0DE, 0xB4C9, 0xB943, 0xBE43, 0xC3C1, 0xC9B2, 0xD00A, 0xD6BD, 0xDDC0, 0xE503, 0xEC7A, 0xF416, 0xFBC8, 0x0382, 0x0B36,
        0x12D5, 0x1A50, 0x2198, 0x28A1, 0x2F5C, 0x35BD, 0x3BB8, 0x4141, 0x464D, 0x4AD4, 0x4ECC, 0x522E, 0x54F3, 0x5716, 0x5894, 0x5969,
        0x5993, 0x5913, 0x57E9, 0x5617, 0x53A2, 0x508D, 0x4CDE, 0x489D, 0x43D2, 0x3E86, 0x38C2, 0x3293, 0x2C03, 0x251F, 0x1DF4, 0x1690,
        0x0F02, 0x0756, 0xFF9E, 0xF7E6, 0xF03C, 0xE8B1, 0xE153, 0xDA2F, 0xD352, 0xCCCB, 0xC6A6, 0xC0EE, 0xBBAE, 0xB6F0, 0xB2BD, 0xAF1E,
        0xAC19, 0xA9B3, 0xA7F2, 0xA6D9, 0xA66A, 0xA6A5, 0xA78A, 0xA919, 0xAB4C, 0xAE21, 0xB192, 0xB599, 0xBA2D, 0xBF47, 0xC4DB, 0xCAE1,
        0xD14B, 0xD80F, 0xDF1E, 0xE66D, 0xEDEC, 0xF58D, 0xFD42, 0x04FC, 0x0CAD, 0x1446, 0x1BB8, 0x22F6, 0x29F1, 0x309C, 0x36EA, 0x3CD0,
        0x4242, 0x4735, 0x4BA1, 0x4F7D, 0x52C2, 0x5568, 0x576C, 0x58CA, 0x597E, 0x5988, 0x58E7, 0x579D, 0x55AB, 0x5317, 0x4FE4, 0x4C19,
        0x47BD, 0x42D9, 0x3D75, 0x379C, 0x3159, 0x2AB8, 0x23C5, 0x1C8F, 0x1522, 0x0D8C, 0x05DD, 0xFE24, 0xF66D, 0xEEC9, 0xE745, 0xDFF0,
        0xD8D9, 0xD20C, 0xCB97, 0xC585, 0xBFE3, 0xBABB, 0xB618, 0xB201, 0xAE7E, 0xAB97, 0xA951, 0xA7AF, 0xA6B7, 0xA668, 0xA6C4, 0xA7CA,
        0xA978, 0xABCB, 0xAEBE, 0xB24C, 0xB66E, 0xBB1D, 0xC04E, 0xC5F9, 0xCC13, 0xD28F, 0xD963, 0xE07F, 0xE7D8, 0xEF5F, 0xF705, 0xFEBD,
        0x0675, 0x0E23, 0x15B6, 0x1D1F, 0x2451, 0x2B3E, 0x31D8, 0x3813, 0x3DE4, 0x433E, 0x4818, 0x4C69, 0x5029, 0x5350, 0x55D8, 0x57BC,
        0x58F9, 0x598D, 0x5976, 0x58B5, 0x574A, 0x553A, 0x5287, 0x4F36, 0x4B4F, 0x46D8, 0x41DB, 0x3C5F, 0x3671, 0x301B, 0x296A, 0x2269,
        0x1B27, 0x13B1, 0x0C16, 0x0464, 0xFCAA, 0xF4F5, 0xED56, 0xE5DA, 0xDE90, 0xD786, 0xD0C9, 0xCA66, 0xC469, 0xBEDD, 0xB9CE, 0xB544,
        0xB149, 0xADE4, 0xAB1B, 0xA8F4, 0xA773, 0xA69A, 0xA66C, 0xA6E9, 0xA80F, 0xA9DD, 0xAC4F, 0xAF60, 0xB30B, 0xB749, 0xBC11, 0xC15B,
        0xC71C, 0xCD49, 0xD3D7, 0xDAB9, 0xE1E2, 0xE945, 0xF0D3, 0xF87E, 0x0036, 0x07EF, 0x0F98, 0x1724, 0x1E84, 0x25A9, 0x2C87, 0x3310,
        0x3938, 0x3EF3, 0x4436, 0x48F6, 0x4D2C, 0x50CF, 0x53D8, 0x5641, 0x5806, 0x5923, 0x5996, 0x595E, 0x587C, 0x56F2, 0x54C2, 0x51F0,
        0x4E83, 0x4A80, 0x45EE, 0x40D8, 0x3B46, 0x3543, 0x2EDB, 0x2819, 0x210B, 0x19BE, 0x1240, 0x0A9F, 0x02EA, 0xFB30, 0xF37F, 0xEBE5,
        0xE472, 0xDD33, 0xD636, 0xCF89, 0xC939, 0xC351, 0xBDDC, 0xB8E5, 0xB476, 0xB097, 0xAD4F, 0xAAA5, 0xA89D, 0xA73C, 0xA684, 0xA677,
        0xA714, 0xA85A, 0xAA48, 0xACD9, 0xB008, 0xB3CF, 0xB828, 0xBD0A, 0xC26B, 0xC842, 0xCE83, 0xD522, 0xDC12, 0xE348, 0xEAB4, 0xF248,
        0xF9F7, 0x01B0, 0x0967, 0x110C, 0x1891, 0x1FE6, 0x26FF, 0x2DCE, 0x3445, 0x3A59, 0x3FFE, 0x4529, 0x49CF, 0x4DEA, 0x5170, 0x545A,
        0x56A4, 0x5849, 0x5946, 0x5998, 0x5940, 0x583E, 0x5694, 0x5444, 0x5155, 0x4DCA, 0x49AB, 0x44FF, 0x3FD1, 0x3A28, 0x3411, 0x2D97,
        0x26C5, 0x1FAA, 0x1853, 0x10CD, 0x0927, 0x0170, 0xF9B6, 0xF208, 0xEA75, 0xE30B, 0xDBD7, 0xD4E9, 0xCE4D, 0xC80F, 0xC23C, 0xBCDF,
        0xB802, 0xB3AE, 0xAFEB, 0xACC1, 0xAA35, 0xA84D, 0xA70C, 0xA674, 0xA688, 0xA745, 0xA8AC, 0xAAB9, 0xAD68, 0xB0B5, 0xB499, 0xB90D,
        0xBE08, 0xC380, 0xC96C, 0xCFC0, 0xD66F, 0xDD6E, 0xE4AF, 0xEC24, 0xF3BE, 0xFB70, 0x032A, 0x0ADF, 0x127F, 0x19FB, 0x2147, 0x2852,
        0x2F11, 0x3577, 0x3B76, 0x4104, 0x4617, 0x4AA3, 0x4EA2, 0x520A, 0x54D7, 0x5702, 0x5886, 0x5963, 0x5995, 0x591C, 0x57FA, 0x562F,
        0x53C1, 0x50B3, 0x4D0B, 0x48D1, 0x440C, 0x3EC5, 0x3906, 0x32DB, 0x2C4F, 0x256F, 0x1E47, 0x16E6, 0x0F59, 0x07AE, 0xFFF6, 0xF83D,
        0xF093, 0xE907, 0xE1A6, 0xDA7F, 0xD39F, 0xCD14, 0xC6EA, 0xC12D, 0xBBE7, 0xB723, 0xB2EA, 0xAF44, 0xAC38, 0xA9CB, 0xA803, 0xA6E2,
        0xA66B, 0xA69F, 0xA77D, 0xA903, 0xAB30, 0xADFE, 0xB168, 0xB568, 0xB9F6, 0xBF0A, 0xC499, 0xCA9A, 0xD100, 0xD7C0, 0xDECC, 0xE618,
        0xED95, 0xF535, 0xFCEA, 0x04A4, 0x0C56, 0x13F0, 0x1B65, 0x22A5, 0x29A3, 0x3052, 0x36A4, 0x3C8F, 0x4206, 0x4700, 0x4B72, 0x4F54,
        0x52A0, 0x554D, 0x5759, 0x58BE, 0x597A, 0x598B, 0x58F2, 0x57AF, 0x55C5, 0x5338, 0x500C, 0x4C48, 0x47F2, 0x4313, 0x3DB5, 0x37E1,
        0x31A2, 0x2B05, 0x2416, 0x1CE2, 0x1577, 0x0DE3, 0x0635, 0xFE7C, 0xF6C5, 0xEF1F, 0xE79A, 0xE043, 0xD928, 0xD258, 0xCBDE, 0xC5C8,
        0xC021, 0xBAF4, 0xB64A, 0xB22C, 0xAEA3, 0xABB5, 0xA967, 0xA7BE, 0xA6BE, 0xA668, 0xA6BC, 0xA7BA, 0xA961, 0xABAD, 0xAE99, 0xB220,
        0xB63C, 0xBAE4, 0xC010, 0xC5B6, 0xCBCB, 0xD244, 0xD913, 0xE02D, 0xE783, 0xEF08, 0xF6AD, 0xFE64, 0x061E, 0x0DCC, 0x1560, 0x1CCC,
        0x2400, 0x2AF0, 0x318E, 0x37CE, 0x3DA4, 0x4304, 0x47E4, 0x4C3B, 0x5001, 0x532F, 0x55BE, 0x57AA, 0x58EF, 0x598A, 0x597B, 0x58C1,
        0x575E, 0x5555, 0x52A9, 0x4F5F, 0x4B7F, 0x470E, 0x4216, 0x3CA0, 0x36B7, 0x3066, 0x29B8, 0x22BB, 0x1B7B, 0x1407, 0x0C6D, 0x04BC,
        0xFD02, 0xF54D, 0xEDAC, 0xE62F, 0xDEE2, 0xD7D5, 0xD114, 0xCAAD, 0xC4AB, 0xBF1A, 0xBA05, 0xB575, 0xB173, 0xAE07, 0xAB37, 0xA909,
        0xA780, 0xA6A0, 0xA66B, 0xA6DF, 0xA7FE, 0xA9C5, 0xAC2F, 0xAF3A, 0xB2DE, 0xB715, 0xBBD8, 0xC11C, 0xC6D8, 0xCD00, 0xD38A, 0xDA69,
        0xE18F, 0xE8F0, 0xF07C, 0xF826, 0xFFDF, 0x0797, 0x0F41, 0x16CF, 0x1E31, 0x2559, 0x2C3B, 0x32C8, 0x38F4, 0x3EB4, 0x43FC, 0x48C3,
        0x4CFF, 0x50A9, 0x53B9, 0x5629, 0x57F5, 0x591A, 0x5994, 0x5964, 0x588A, 0x5707, 0x54DE, 0x5214, 0x4EAD, 0x4AB0, 0x4625, 0x4115,
        0x3B88, 0x358A, 0x2F26, 0x2868, 0x215D, 0x1A12, 0x1296, 0x0AF6, 0x0342, 0xFB88, 0xF3D6, 0xEC3B, 0xE4C5, 0xDD84, 0xD684, 0xCFD3,
        0xC97F, 0xC391, 0xBE18, 0xB91B, 0xB4A6, 0xB0C0, 0xAD71, 0xAAC0, 0xA8B1, 0xA748, 0xA689, 0xA674, 0xA709, 0xA848, 0xAA2E, 0xACB8,
        0xAFE0, 0xB3A1, 0xB7F4, 0xBCCF, 0xC22B, 0xC7FD, 0xCE39, 0xD4D4, 0xDBC2, 0xE2F4, 0xEA5E, 0xF1F1, 0xF99F, 0x0158, 0x090F, 0x10B5,
        0x183C, 0x1F94, 0x26B0, 0x2D82, 0x33FE, 0x3A16, 0x3FC0, 0x44F0, 0x499D, 0x4DBE, 0x514B, 0x543C, 0x568E, 0x583A, 0x593E, 0x5998,
        0x5948, 0x584D, 0x56AA, 0x5462, 0x5179, 0x4DF5, 0x49DD, 0x4538, 0x400E, 0x3A6B, 0x3459, 0x2DE2, 0x2715, 0x1FFC, 0x18A7, 0x1123,
        0x097E, 0x01C8, 0xFA0E, 0xF260, 0xEACB, 0xE35E, 0xDC28, 0xD536, 0xCE96, 0xC854, 0xC27C, 0xBD1A, 0xB836, 0xB3DC, 0xB012, 0xACE1,
        0xAA4F, 0xA85F, 0xA717, 0xA678, 0xA683, 0xA739, 0xA898, 0xAA9E, 0xAD46, 0xB08C, 0xB46A, 0xB8D7, 0xBDCC, 0xC33F, 0xC926, 0xCF75,
        0xD621, 0xDD1D, 0xE45B, 0xEBCE, 0xF367, 0xFB18, 0x02D2, 0x0A87, 0x1228, 0x19A7, 0x20F5, 0x2804, 0x2EC6, 0x3530, 0x3B34, 0x40C8,
        0x45E0, 0x4A72, 0x4E77, 0x51E7, 0x54BA, 0x56EC, 0x5879, 0x595D, 0x5996, 0x5925, 0x580A, 0x5647, 0x53E0, 0x50D9, 0x4D38, 0x4904,
        0x4445, 0x3F04, 0x394A, 0x3324, 0x2C9C, 0x25BF, 0x1E9A, 0x173B, 0x0FAF, 0x0806, 0x004D, 0xF895, 0xF0EA, 0xE95C, 0xE1F9, 0xDACF,
        0xD3EC, 0xCD5C, 0xC72E, 0xC16B, 0xBC20, 0xB757, 0xB317, 0xAF6A, 0xAC57, 0xA9E3, 0xA813, 0xA6EB, 0xA66D, 0xA699, 0xA76F, 0xA8EE,
        0xAB13, 0xADDA, 0xB13E, 0xB537, 0xB9BF, 0xBECD, 0xC457, 0xCA53, 0xD0B5, 0xD771, 0xDE7A, 0xE5C4, 0xED3F, 0xF4DE, 0xFC92, 0x044C,
        0x0BFF, 0x139A, 0x1B11, 0x2253, 0x2955, 0x3007, 0x365E, 0x3C4E, 0x41CB, 0x46CA, 0x4B42, 0x4F2B, 0x527D, 0x5532, 0x5745, 0x58B1,
        0x5975, 0x598E, 0x58FC, 0x57C1, 0x55DE, 0x5358, 0x5033, 0x4C76, 0x4826, 0x434E, 0x3DF5, 0x3826, 0x31EB, 0x2B52, 0x2467, 0x1D35,
        0x15CD, 0x0E3A, 0x068D, 0xFED4, 0xF71D, 0xEF76, 0xE7EF, 0xE095, 0xD978, 0xD2A4, 0xCC26, 0xC60B, 0xC05F, 0xBB2C, 0xB67C, 0xB258,
        0xAEC8, 0xABD3, 0xA97E, 0xA7CE, 0xA6C6, 0xA668, 0xA6B5, 0xA7AB, 0xA94B, 0xAB8F, 0xAE74, 0xB1F5, 0xB60A, 0xBAAC, 0xBFD3, 0xC573,
        0xCB84, 0xD1F8, 0xD8C4, 0xDFDA, 0xE72E, 0xEEB2, 0xF656, 0xFE0C, 0x05C6, 0x0D75, 0x150B, 0x1C78, 0x23B0, 0x2AA3, 0x3145, 0x3789,
        0x3D64, 0x42C9, 0x47AF, 0x4C0D, 0x4FDA, 0x530E, 0x55A4, 0x5798, 0x58E4, 0x5987, 0x597F, 0x58CD, 0x5771, 0x556F, 0x52CB, 0x4F88,
        0x4BAE, 0x4744, 0x4252, 0x3CE1, 0x36FD, 0x30B0, 0x2A06, 0x230C, 0x1BCF, 0x145D, 0x0CC5, 0x0514, 0xFD5A, 0xF5A5, 0xEE03, 0xE683,
        0xDF34, 0xD824, 0xD15F, 0xCAF4, 0xC4ED, 0xBF57, 0xBA3C, 0xB5A6, 0xB19E, 0xAE2B, 0xAB54, 0xA91E, 0xA78E, 0xA6A7, 0xA669, 0xA6D7,
        0xA7EE, 0xA9F2, 0xAC97, 0xAFD6, 0xB3A9, 0xB807, 0xBCE6, 0xC23E, 0xC803, 0xCE28, 0xD4A3, 0xDB65, 0xE263, 0xE98D, 0xF0D6, 0xF830,
        0xFF8D, 0x06DD, 0x0E15, 0x1527, 0x1C04, 0x22A1, 0x28F0, 0x2EE7, 0x347B, 0x39A2, 0x3E52, 0x4283, 0x462F, 0x494F, 0x4BDE, 0x4DD9,
        0x4F3B, 0x5005, 0x5035, 0x4FCC, 0x4ECB, 0x4D37, 0x4B12, 0x4862, 0x452C, 0x4179, 0x3D50, 0x38B9, 0x33BE, 0x2E69, 0x28C6, 0x22DE,
        0x1CBF, 0x1674, 0x100A, 0x098C, 0x0308, 0xFC8A, 0xF61E, 0xEFD1, 0xE9AD, 0xE3BF, 0xDE12, 0xD8B0, 0xD3A2, 0xCEF2, 0xCAA8, 0xC6CB,
        0xC362, 0xC074, 0xBE03, 0xBC15, 0xBAAB, 0xB9C9, 0xB96D, 0xB999, 0xBA4A, 0xBB7F, 0xBD34, 0xBF65, 0xC20D, 0xC525, 0xC8A8, 0xCC8E,
        0xD0CE, 0xD560, 0xDA3A, 0xDF53, 0xE4A0, 0xEA17, 0xEFAD, 0xF557, 0xFB0B, 0x00BC, 0x0661, 0x0BEF, 0x115B, 0x169C, 0x1BA7, 0x2074,
        0x24F9, 0x292E, 0x2D0D, 0x308E, 0x33AC, 0x3661, 0x38A9, 0x3A80, 0x3BE4, 0x3CD4, 0x3D4D, 0x3D51, 0x3CE0, 0x3BFC, 0x3AA8, 0x38E6,
        0x36BC, 0x342F, 0x3143, 0x2DFF, 0x2A6B, 0x268D, 0x226E, 0x1E16, 0x198F, 0x14E0, 0x1013, 0x0B32, 0x0646, 0x0159, 0xFC75, 0xF7A1,
        0xF2E8, 0xEE52, 0xE9E8, 0xE5B1, 0xE1B6, 0xDDFD, 0xDA8E, 0xD76D, 0xD4A0, 0xD22D, 0xD016, 0xCE5F, 0xCD0B, 0xCC1A, 0xCB8F, 0xCB69,
        0xCBA7, 0xCC48, 0xCD4B, 0xCEAC, 0xD068, 0xD27A, 0xD4DE, 0xD78F, 0xDA87, 0xDDBF, 0xE131, 0xE4D6, 0xE8A6, 0xEC99, 0xF0A8, 0xF4CA,
        0xF8F8, 0xFD29, 0x0155, 0x0575, 0x0981, 0x0D70, 0x113D, 0x14DF, 0x1851, 0x1B8C, 0x1E8A, 0x2147, 0x23BE, 0x25EA, 0x27C8, 0x2956,
        0x2A92, 0x2B79, 0x2C0B, 0x2C47, 0x2C2F, 0x2BC2, 0x2B04, 0x29F5, 0x2898, 0x26F2, 0x2506, 0x22D9, 0x206E, 0x1DCD, 0x1AF9, 0x17F9,
        0x14D4, 0x118F, 0x0E31, 0x0AC2, 0x0747, 0x03C7, 0x004A, 0xFCD7, 0xF972, 0xF623, 0xF2F0, 0xEFDF, 0xECF5, 0xEA37, 0xE7AB, 0xE554,
        0xE337, 0xE156, 0xDFB5, 0xDE57, 0xDD3D, 0xDC68, 0xDBD9, 0xDB91, 0xDB90, 0xDBD3, 0xDC5C, 0xDD26, 0xDE31, 0xDF79, 0xE0FC, 0xE2B5,
        0xE4A1, 0xE6BC, 0xE900, 0xEB6A, 0xEDF3, 0xF098, 0xF351, 0xF61B, 0xF8EF, 0xFBC7, 0xFE9F, 0x0170, 0x0436, 0x06EB, 0x098A, 0x0C0F,
        0x0E75, 0x10B8, 0x12D3, 0x14C4, 0x1687, 0x1819, 0x1978, 0x1AA1, 0x1B94, 0x1C4F, 0x1CD2, 0x1D1C, 0x1D2D, 0x1D06, 0x1CA9, 0x1C15,
        0x1B4E, 0x1A56, 0x192E, 0x17DB, 0x165E, 0x14BC, 0x12F7, 0x1115, 0x0F19, 0x0D06, 0x0AE3, 0x08B2, 0x0678, 0x043A, 0x01FC, 0xFFC4,
        0xFD93, 0xFB6F, 0xF95B, 0xF75C, 0xF575, 0xF3A9, 0xF1FC, 0xF070, 0xEF07, 0xEDC5, 0xECAA, 0xEBB8, 0xEAF1, 0xEA56, 0xE9E6, 0xE9A3,
        0xE98B, 0xE99F, 0xE9DD, 0xEA45, 0xEAD4, 0xEB8B, 0xEC65, 0xED61, 0xEE7E, 0xEFB7, 0xF10A, 0xF274, 0xF3F3, 0xF582, 0xF71E, 0xF8C5,
        0xFA73, 0xFC23, 0xFDD4, 0xFF82, 0x0128, 0x02C6, 0x0457, 0x05D8, 0x0748, 0x08A3, 0x09E7, 0x0B12, 0x0C23, 0x0D17, 0x0DED, 0x0EA5,
        0x0F3D, 0x0FB5, 0x100D, 0x1044, 0x105A, 0x1051, 0x1028, 0x0FE1, 0x0F7D, 0x0EFD, 0x0E62, 0x0DAF, 0x0CE5, 0x0C07, 0x0B15, 0x0A13,
        0x0903, 0x07E7, 0x06C2, 0x0596, 0x0466, 0x0333, 0x0201, 0x00D2, 0xFFA8, 0xFE85, 0xFD6B, 0xFC5D, 0xFB5B, 0xFA69, 0xF987, 0xF8B6,
        0xF7F9, 0xF74F, 0xF6BB, 0xF63C, 0xF5D3, 0xF580, 0xF544, 0xF51E, 0xF50F, 0xF515, 0xF530, 0xF55F, 0xF5A2, 0xF5F8, 0xF65F, 0xF6D6,
        0xF75C, 0xF7EF, 0xF88E, 0xF937, 0xF9E9, 0xFAA2, 0xFB61, 0xFC23, 0xFCE7, 0xFDAC, 0xFE6F, 0xFF30, 0xFFED, 0x00A3, 0x0154, 0x01FC,
        0x029C, 0x0331, 0x03BB, 0x043A, 0x04AC, 0x0511, 0x0568, 0x05B2, 0x05EE, 0x061D, 0x063D, 0x0650, 0x0655, 0x064E, 0x063A, 0x061A,
        0x05EF, 0x05BA, 0x057B, 0x0534, 0x04E5, 0x048E, 0x0432, 0x03D1, 0x036D, 0x0305, 0x029C, 0x0231, 0x01C7, 0x015D, 0x00F6, 0x0091,
        0x0030, 0xFFD3, 0xFF7B, 0xFF28, 0xFEDA, 0xFE93, 0xFE53, 0xFE19, 0xFDE7, 0xFDBC, 0xFD98, 0xFD7B, 0xFD66, 0xFD57, 0xFD4F, 0xFD4E,
        0xFD53, 0xFD5D, 0xFD6D, 0xFD82, 0xFD9B, 0xFDB9, 0xFDD9, 0xFDFC, 0xFE22, 0xFE4A, 0xFE72, 0xFE9C, 0xFEC5, 0xFEEF, 0xFF17, 0xFF3F,
        0xFF65, 0xFF89, 0xFFAB, 0xFFCB, 0xFFE8, 0x0002, 0x0019, 0x002E, 0x003F, 0x004D, 0x0059, 0x0062, 0x0068, 0x006B, 0x006C, 0x006B,
        0x0067, 0x0063, 0x005C, 0x0055, 0x004C, 0x0044, 0x003A, 0x0031, 0x0028, 0x001F, 0x0017, 0x0010, 0x000A, 0x0005, 0x0001, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0006, 0x0008, 0x0009, 0x000B, 0x000D, 0x000F, 0x0011, 0x0013,
        0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x0019, 0x0019, 0x0018, 0x0017, 0x0015, 0x0012, 0x000F, 0x000B, 0x0006, 0x0000, 0xFFFB,
        0xFFF3, 0xFFEB, 0xFFE2, 0xFFD8, 0xFFCD, 0xFFC2, 0xFFB6, 0xFFA9, 0xFF9C, 0xFF8E, 0xFF80, 0xFF72, 0xFF63, 0xFF54, 0xFF45, 0xFF36,
        0xFF28, 0xFF1A, 0xFF0C, 0xFEFF, 0xFEF3, 0xFEE8, 0xFEDE, 0xFED5, 0xFECE, 0xFEC8, 0xFEC4, 0xFEC1, 0xFEC1, 0xFEC3, 0xFEC7, 0xFECD,
        0xFED5, 0xFEE0, 0xFEEE, 0xFEFE, 0xFF11, 0xFF26, 0xFF3E, 0xFF59, 0xFF76, 0xFF95, 0xFFB7, 0xFFDC, 0x0001, 0x002A, 0x0054, 0x0081,
        0x00AF, 0x00DE, 0x010E, 0x013F, 0x0171, 0x01A3, 0x01D5, 0x0207, 0x0238, 0x0269, 0x0298, 0x02C5, 0x02F1, 0x031B, 0x0342, 0x0366,
        0x0387, 0x03A4, 0x03BE, 0x03D3, 0x03E4, 0x03F1, 0x03F8, 0x03FA, 0x03F7, 0x03EE, 0x03E0, 0x03CC, 0x03B2, 0x0392, 0x036B, 0x033F,
        0x030D, 0x02D5, 0x0297, 0x0253, 0x020A, 0x01BB, 0x0168, 0x010F, 0x00B3, 0x0052, 0xFFEE, 0xFF86, 0xFF1C, 0xFEAF, 0xFE40, 0xFDD0,
        0xFD60, 0xFCEF, 0xFC7F, 0xFC10, 0xFBA2, 0xFB37, 0xFACF, 0xFA6A, 0xFA0A, 0xF9AF, 0xF959, 0xF909, 0xF8C0, 0xF87E, 0xF844, 0xF813,
        0xF7EA, 0xF7CB, 0xF7B5, 0xF7AA, 0xF7A9, 0xF7B2, 0xF7C7, 0xF7E7, 0xF811, 0xF848, 0xF889, 0xF8D6, 0xF92E, 0xF992, 0xF9FF, 0xFA78,
        0xFAFA, 0xFB87, 0xFC1C, 0xFCBA, 0xFD61, 0xFE0E, 0xFEC3, 0xFF7D, 0x003C, 0x0100, 0x01C7, 0x0291, 0x035C, 0x0428, 0x04F4, 0x05BE,
        0x0685, 0x0749, 0x0807, 0x08C0, 0x0973, 0x0A1D, 0x0ABE, 0x0B56, 0x0BE2, 0x0C63, 0x0CD6, 0x0D3C, 0x0D94, 0x0DDD, 0x0E15, 0x0E3D,
        0x0E54, 0x0E5A, 0x0E4E, 0x0E2F, 0x0DFE, 0x0DBB, 0x0D65, 0x0CFC, 0x0C81, 0x0BF4, 0x0B55, 0x0AA5, 0x09E4, 0x0912, 0x0832, 0x0742,
        0x0645, 0x053B, 0x0426, 0x0306, 0x01DD, 0x00AB, 0xFF75, 0xFE37, 0xFCF7, 0xFBB4, 0xFA70, 0xF92D, 0xF7ED, 0xF6B1, 0xF57A, 0xF44C,
        0xF326, 0xF20B, 0xF0FC, 0xEFFB, 0xEF09, 0xEE28, 0xED5A, 0xEC9E, 0xEBF8, 0xEB67, 0xEAEE, 0xEA8C, 0xEA44, 0xEA15, 0xEA00, 0xEA07,
        0xEA28, 0xEA65, 0xEABE, 0xEB33, 0xEBC4, 0xEC6F, 0xED36, 0xEE18, 0xEF13, 0xF027, 0xF153, 0xF296, 0xF3EF, 0xF55D, 0xF6DD, 0xF86F,
        0xFA10, 0xFBBF, 0xFD7A, 0xFF40, 0x010C, 0x02DF, 0x04B6, 0x068E, 0x0866, 0x0A3A, 0x0C09, 0x0DD0, 0x0F8D, 0x113D, 0x12DF, 0x146F,
        0x15ED, 0x1755, 0x18A6, 0x19DD, 0x1AF9, 0x1BF8, 0x1CD9, 0x1D99, 0x1E37, 0x1EB3, 0x1F0B, 0x1F3E, 0x1F4B, 0x1F32, 0x1EF3, 0x1E8C,
        0x1DFF, 0x1D4A, 0x1C70, 0x1B6F, 0x1A49, 0x18FF, 0x1792, 0x1602, 0x1452, 0x1284, 0x1098, 0x0E92, 0x0C72, 0x0A3C, 0x07F2, 0x0597,
        0x032C, 0x00B6, 0xFE37, 0xFBB1, 0xF928, 0xF69E, 0xF418, 0xF198, 0xEF21, 0xECB7, 0xEA5D, 0xE815, 0xE5E3, 0xE3CA, 0xE1CC, 0xDFED,
        0xDE30, 0xDC96, 0xDB22, 0xD9D6, 0xD8B5, 0xD7C1, 0xD6FB, 0xD664, 0xD5FF, 0xD5CB, 0xD5CB, 0xD5FE, 0xD665, 0xD700, 0xD7CF, 0xD8D2,
        0xDA08, 0xDB6F, 0xDD08, 0xDED0, 0xE0C7, 0xE2E9, 0xE535, 0xE7A9, 0xEA42, 0xECFD, 0xEFD8, 0xF2CF, 0xF5DF, 0xF904, 0xFC3B, 0xFF80,
        0x02CE, 0x0624, 0x097C, 0x0CD1, 0x1021, 0x1367, 0x169F, 0x19C4, 0x1CD3, 0x1FC8, 0x229E, 0x2552, 0x27E0, 0x2A45, 0x2C7D, 0x2E85,
        0x305A, 0x31FA, 0x3361, 0x348D, 0x357D, 0x362E, 0x369E, 0x36CE, 0x36BB, 0x3666, 0x35CD, 0x34F1, 0x33D3, 0x3272, 0x30D0, 0x2EEE,
        0x2CCE, 0x2A72, 0x27DC, 0x250E, 0x220C, 0x1ED9, 0x1B77, 0x17EB, 0x1439, 0x1064, 0x0C71, 0x0865, 0x0444, 0x0014, 0xFBD9, 0xF797,
        0xF355, 0xEF17, 0xEAE3, 0xE6BD, 0xE2AC, 0xDEB4, 0xDADB, 0xD725, 0xD397, 0xD036, 0xCD07, 0xCA0E, 0xC74F, 0xC4CE, 0xC28E, 0xC094,
        0xBEE2, 0xBD7B, 0xBC61, 0xBB97, 0xBB1E, 0xBAF8, 0xBB25, 0xBBA6, 0xBC7B, 0xBDA4, 0xBF21, 0xC0F0, 0xC311, 0xC580, 0xC83C, 0xCB42,
        0xCE90, 0xD222, 0xD5F4, 0xDA02, 0xDE47, 0xE2C0, 0xE767, 0xEC36, 0xF129, 0xF639, 0xFB61, 0x009A, 0x05DF, 0x0B29, 0x1072, 0x15B3,
        0x1AE6, 0x2004, 0x2507, 0x29E9, 0x2EA2, 0x332E, 0x3786, 0x3BA5, 0x3F85, 0x4320, 0x4672, 0x4976, 0x4C27, 0x4E82, 0x5084, 0x5228,
        0x536C, 0x544D, 0x54CB, 0x54E2, 0x5493, 0x53DD, 0x52BF, 0x513A, 0x4F50, 0x4D01, 0x4A50, 0x473F, 0x43D1, 0x400A, 0x3BEC, 0x377D,
        0x328C, 0x2D5D, 0x27F8, 0x2263, 0x1CA5, 0x16C4, 0x10C8, 0x0AB8, 0x049B, 0xFE7A, 0xF859, 0xF242, 0xEC3B, 0xE64B, 0xE07B, 0xDAD0,
        0xD553, 0xD008, 0xCAF7, 0xC625, 0xC199, 0xBD58, 0xB967, 0xB5CB, 0xB288, 0xAFA2, 0xAD1C, 0xAAFA, 0xA93E, 0xA7EA, 0xA700, 0xA681,
        0xA66D, 0xA6C5, 0xA787, 0xA8B5, 0xAA4A, 0xAC47, 0xAEA8, 0xB16B, 0xB48D, 0xB808, 0xBBDB, 0xBFFF, 0xC470, 0xC928, 0xCE22, 0xD359,
        0xD8C4, 0xDE5F, 0xE422, 0xEA07, 0xF006, 0xF618, 0xFC37, 0x0258, 0x0878, 0x0E8E, 0x1492, 0x1A7E, 0x2049, 0x25EE, 0x2B66, 0x30A9,
        0x35B2, 0x3A7A, 0x3EFD, 0x4333, 0x4719, 0x4AAA, 0x4DE1, 0x50BA, 0x5333, 0x5547, 0x56F5, 0x583B, 0x5917, 0x5988, 0x598E, 0x5927,
        0x5856, 0x571B, 0x5578, 0x536D, 0x50FF, 0x4E2F, 0x4B01, 0x477A, 0x439C, 0x3F6E, 0x3AF3, 0x3631, 0x312F, 0x2BF1, 0x267E, 0x20DE,
        0x1B16, 0x152D, 0x0F2B, 0x0917, 0x02F8, 0xFCD6, 0xF6B7, 0xF0A3, 0xEAA2, 0xE4BA, 0xDEF3, 0xD954, 0xD3E3, 0xCEA7, 0xC9A7, 0xC4E7,
        0xC06F, 0xBC43, 0xB868, 0xB4E3, 0xB1B8, 0xAEEC, 0xAC80, 0xAA79, 0xA8D9, 0xA7A1, 0xA6D4, 0xA671, 0xA67A, 0xA6EE, 0xA7CE, 0xA917,
        0xAAC8, 0xACE0, 0xAF5C, 0xB238, 0xB572, 0xB906, 0xBCEE, 0xC127, 0xC5AC, 0xCA77, 0xCF82, 0xD4C7, 0xDA40, 0xDFE6, 0xE5B3, 0xEB9F,
        0xF1A4, 0xF7BA, 0xFDDA, 0x03FC, 0x0A1A, 0x102C, 0x162A, 0x1C0E, 0x21D0, 0x2769, 0x2CD3, 0x3208, 0x3700, 0x3BB6, 0x4025, 0x4446,
        0x4816, 0x4B8F, 0x4EAD, 0x516D, 0x53CB, 0x55C4, 0x5757, 0x5880, 0x5940, 0x5994, 0x597D, 0x58FA, 0x580C, 0x56B5, 0x54F6, 0x52D0,
        0x5048, 0x4D5E, 0x4A18, 0x4679, 0x4286, 0x3E42, 0x39B4, 0x34E0, 0x2FCD, 0x2A81, 0x2501, 0x1F56, 0x1984, 0x1394, 0x0D8C, 0x0774,
        0x0154, 0xFB32, 0xF515, 0xEF06, 0xE90B, 0xE32B, 0xDD6E, 0xD7DB, 0xD277, 0xCD4B, 0xC85B, 0xC3AE, 0xBF49, 0xBB33, 0xB76E, 0xB401,
        0xB0EF, 0xAE3C, 0xABEC, 0xAA00, 0xA87B, 0xA760, 0xA6AF, 0xA669, 0xA68E, 0xA720, 0xA81B, 0xA981, 0xAB4E, 0xAD81, 0xB017, 0xB30C,
        0xB65F, 0xBA09, 0xBE08, 0xC256, 0xC6ED, 0xCBCA, 0xD0E5, 0xD638, 0xDBBE, 0xE170, 0xE745, 0xED39, 0xF343, 0xF95D, 0xFF7E, 0x05A0,
        0x0BBB, 0x11C8, 0x17C0, 0x1D9B, 0x2353, 0x28E1, 0x2E3D, 0x3362, 0x3849, 0x3CED, 0x4147, 0x4553, 0x490C, 0x4C6D, 0x4F73, 0x5219,
        0x545C, 0x563A, 0x57B1, 0x58BE, 0x5961, 0x5998, 0x5964, 0x58C5, 0x57BB, 0x5648, 0x546D, 0x522D, 0x4F8A, 0x4C87, 0x4929, 0x4573,
        0x4169, 0x3D11, 0x3870, 0x338B, 0x2E68, 0x290D, 0x2381, 0x1DCB, 0x17F0, 0x11F9, 0x0BED, 0x05D2, 0xFFB1, 0xF98F, 0xF375, 0xED6A,
        0xE776, 0xE19F, 0xDBEC, 0xD665, 0xD10F, 0xCBF3, 0xC714, 0xC27A, 0xBE2A, 0xBA28, 0xB67B, 0xB326, 0xB02D, 0xAD94, 0xAB5E, 0xA98E,
        0xA825, 0xA726, 0xA691, 0xA668, 0xA6AB, 0xA758, 0xA871, 0xA9F2, 0xABDA, 0xAE28, 0xB0D8, 0xB3E7, 0xB751, 0xBB13, 0xBF27, 0xC389,
        0xC834, 0xCD21, 0xD24C, 0xD7AE, 0xDD40, 0xE2FC, 0xE8DA, 0xEED5, 0xF4E4, 0xFB00, 0x0122, 0x0743, 0x0D5B, 0x1363, 0x1954, 0x1F27,
        0x24D4, 0x2A55, 0x2FA3, 0x34B8, 0x398E, 0x3E1E, 0x4264, 0x465A, 0x49FC, 0x4D45, 0x5031, 0x52BD, 0x54E6, 0x56A9, 0x5803, 0x58F4,
        0x597A, 0x5995, 0x5944, 0x5888, 0x5762, 0x55D3, 0x53DD, 0x5182, 0x4EC5, 0x4BAA, 0x4833, 0x4467, 0x4048, 0x3BDB, 0x3727, 0x3231,
        0x2CFF, 0x2796, 0x21FE, 0x1C3D, 0x165B, 0x105D, 0x0A4C, 0x042E, 0xFE0C, 0xF7EC, 0xF1D6, 0xEBD0, 0xE5E3, 0xE015, 0xDA6D, 0xD4F3,
        0xCFAC, 0xCA9F, 0xC5D2, 0xC14B, 0xBD10, 0xB924, 0xB58E, 0xB251, 0xAF72, 0xACF3, 0xAAD8, 0xA923, 0xA7D6, 0xA6F4, 0xA67C, 0xA670,
        0xA6CF, 0xA799, 0xA8CD, 0xAA6A, 0xAC6E, 0xAED6, 0xB1A0, 0xB4C8, 0xB84A, 0xBC22, 0xC04B, 0xC4C2, 0xC97F, 0xCE7D, 0xD3B7, 0xD927,
        0xDEC5, 0xE48A, 0xEA71, 0xF072, 0xF685, 0xFCA4, 0x02C6, 0x08E5, 0x0EFA, 0x14FC, 0x1AE6, 0x20AF, 0x2651, 0x2BC5, 0x3105, 0x3609,
        0x3ACD, 0x3F4A, 0x437B, 0x475B, 0x4AE6, 0x4E16, 0x50E9, 0x535B, 0x5568, 0x570F, 0x584E, 0x5922, 0x598C, 0x598A, 0x591C, 0x5844,
        0x5701, 0x5556, 0x5345, 0x50D0, 0x4DF9, 0x4AC5, 0x4738, 0x4354, 0x3F20, 0x3AA0, 0x35DA, 0x30D3, 0x2B91, 0x261C, 0x2078, 0x1AAD,
        0x14C3, 0x0EBF, 0x08AA, 0x028A, 0xFC69, 0xF64A, 0xF037, 0xEA38, 0xE452, 0xDE8E, 0xD8F1, 0xD384, 0xCE4C, 0xC950, 0xC495, 0xC022,
        0xBBFB, 0xB826, 0xB4A8, 0xB183, 0xAEBD, 0xAC59, 0xAA59, 0xA8C0, 0xA78F, 0xA6C9, 0xA66E, 0xA67F, 0xA6FA, 0xA7E1, 0xA932, 0xAAEA,
        0xAD09, 0xAF8C, 0xB26F, 0xB5AF, 0xB949, 0xBD37, 0xC176, 0xC5FF, 0xCACE, 0xCFDE, 0xD527, 0xDAA3, 0xE04C, 0xE61B, 0xEC0A, 0xF210,
        0xF827, 0xFE48, 0x0469, 0x0A87, 0x1097, 0x1694, 0x1C75, 0x2235, 0x27CB, 0x2D32, 0x3262, 0x3756, 0x3C07, 0x4071, 0x448D, 0x4856,
        0x4BC9, 0x4EE1, 0x519A, 0x53F1, 0x55E4, 0x576F, 0x5891, 0x5949, 0x5996, 0x5977, 0x58ED, 0x57F8, 0x5699, 0x54D3, 0x52A6, 0x5017,
        0x4D27, 0x49DB, 0x4636, 0x423C, 0x3DF3, 0x3960, 0x3488, 0x2F71, 0x2A21, 0x249E, 0x1EEF, 0x191B, 0x1329, 0x0D20, 0x0707, 0x00E6,
        0xFAC5, 0xF4A9, 0xEE9B, 0xE8A1, 0xE2C4, 0xDD09, 0xD779, 0xD219, 0xCCF1, 0xC805, 0xC35D, 0xBEFE, 0xBAED, 0xB72E, 0xB3C8, 0xB0BC,
        0xAE10, 0xABC6, 0xA9E1, 0xA864, 0xA750, 0xA6A6, 0xA668, 0xA695, 0xA72E, 0xA831, 0xA99D, 0xAB72, 0xADAC, 0xB048, 0xB345, 0xB69D,
        0xBA4E, 0xBE52, 0xC2A5, 0xC742, 0xCC23, 0xD142, 0xD699, 0xDC22, 0xE1D6, 0xE7AF, 0xEDA4, 0xF3B0, 0xF9CA, 0xFFEC, 0x060D, 0x0C27,
        0x1233, 0x1829, 0x1E03, 0x23B8, 0x2942, 0x2E9B, 0x33BB, 0x389E, 0x3D3D, 0x4192, 0x4598, 0x494B, 0x4CA6, 0x4FA5, 0x5244, 0x5481,
        0x5658, 0x57C7, 0x58CD, 0x5968, 0x5998, 0x595D, 0x58B6, 0x57A5, 0x562A, 0x5448, 0x5201, 0x4F57, 0x4C4E, 0x48EA, 0x452E, 0x411E,
        0x3CC1, 0x381B, 0x3331, 0x2E0A, 0x28AC, 0x231D, 0x1D64, 0x1787, 0x118E, 0x0B80, 0x0564, 0xFF43, 0xF922, 0xF309, 0xECFF, 0xE70D,
        0xE138, 0xDB88, 0xD604, 0xD0B2, 0xCB9A, 0xC6C0, 0xC22B, 0xBDE0, 0xB9E4, 0xB63D, 0xB2EE, 0xAFFC, 0xAD6A, 0xAB3B, 0xA971, 0xA810,
        0xA718, 0xA68B, 0xA669, 0xA6B3, 0xA769, 0xA888, 0xAA11, 0xAC00, 0xAE55, 0xB10B, 0xB421, 0xB791, 0xBB59, 0xBF72, 0xC3DA, 0xC889,
        0xCD7C, 0xD2AA, 0xD810, 0xDDA5, 0xE363, 0xE944, 0xEF40, 0xF550, 0xFB6D, 0x018F, 0x07B0, 0x0DC7, 0x13CE, 0x19BD, 0x1F8D, 0x2537,
        0x2AB5, 0x2FFF, 0x3510, 0x39E1, 0x3E6D, 0x42AD, 0x469E, 0x4A3A, 0x4D7C, 0x5062, 0x52E7, 0x5509, 0x56C4, 0x5817, 0x5901, 0x5980,
        0x5993, 0x593B, 0x5877, 0x574A, 0x55B3, 0x53B6, 0x5154, 0x4E91, 0x4B6F, 0x47F2, 0x4420, 0x3FFB, 0x3B8A, 0x36D1, 0x31D6, 0x2CA0,
        0x2734, 0x2199, 0x1BD5, 0x15F1, 0x0FF1, 0x09DF, 0x03C1, 0xFD9F, 0xF77F, 0xF16A, 0xEB66, 0xE57A, 0xDFAF, 0xDA0A, 0xD493, 0xCF50,
        0xCA47, 0xC57F, 0xC0FD, 0xBCC7, 0xB8E2, 0xB552, 0xB21B, 0xAF42, 0xACCA, 0xAAB6, 0xA909, 0xA7C3, 0xA6E8, 0xA678, 0xA673, 0xA6D9,
        0xA7AB, 0xA8E7, 0xAA8B, 0xAC96, 0xAF05, 0xB1D5, 0xB503, 0xB88C, 0xBC69, 0xC099, 0xC514, 0xC9D6, 0xCED9, 0xD417, 0xD989, 0xDF2A,
        0xE4F3, 0xEADB, 0xF0DD, 0xF6F2, 0xFD11, 0x0333, 0x0952, 0x0F65, 0x1567, 0x1B4E, 0x2115, 0x26B4, 0x2C25, 0x3160, 0x3660, 0x3B1F,
        0x3F97, 0x43C3, 0x479D, 0x4B22, 0x4E4C, 0x5118, 0x5383, 0x5589, 0x5729, 0x5860, 0x592D, 0x598F, 0x5986, 0x5911, 0x5831, 0x56E7,
        0x5535, 0x531C, 0x50A0, 0x4DC3, 0x4A89, 0x46F5, 0x430C, 0x3ED2, 0x3A4D, 0x3582, 0x3077, 0x2B32, 0x25B9, 0x2012, 0x1A45, 0x1458,
        0x0E53, 0x083D, 0x021D, 0xFBFB, 0xF5DD, 0xEFCC, 0xE9CE, 0xE3EA, 0xDE28, 0xD88F, 0xD325, 0xCDF1, 0xC8F9, 0xC443, 0xBFD5, 0xBBB4,
        0xB7E5, 0xB46D, 0xB14F, 0xAE90, 0xAC32, 0xAA39, 0xA8A7, 0xA77E, 0xA6BF, 0xA66C, 0xA684, 0xA707, 0xA7F5, 0xA94D, 0xAB0D, 0xAD33,
        0xAFBC, 0xB2A6, 0xB5ED, 0xB98C, 0xBD80, 0xC1C4, 0xC653, 0xCB27, 0xD03A, 0xD587, 0xDB06, 0xE0B2, 0xE684, 0xEC74, 0xF27C, 0xF894,
        0xFEB5, 0x04D6, 0x0AF3, 0x1103, 0x16FE, 0x1CDD, 0x229A, 0x282D, 0x2D90, 0x32BC, 0x37AC, 0x3C58, 0x40BD, 0x44D3, 0x4897, 0x4C03,
        0x4F15, 0x51C7, 0x5417, 0x5603, 0x5787, 0x58A1, 0x5952, 0x5997, 0x5971, 0x58DF, 0x57E3, 0x567D, 0x54AF, 0x527C, 0x4FE6, 0x4CEF,
        0x499D, 0x45F1, 0x41F2, 0x3DA4, 0x390C, 0x342F, 0x2F14, 0x29C0, 0x243A, 0x1E88, 0x18B2, 0x12BE, 0x0CB4, 0x069A, 0x0079, 0xFA58,
        0xF43D, 0xEE2F, 0xE838, 0xE25C, 0xDCA5, 0xD718, 0xD1BB, 0xCC97, 0xC7B0, 0xC30D, 0xBEB3, 0xBAA7, 0xB6EF, 0xB38E, 0xB089, 0xADE4,
        0xABA1, 0xA9C4, 0xA84D, 0xA741, 0xA69F, 0xA668, 0xA69C, 0xA73C, 0xA847, 0xA9BB, 0xAB96, 0xADD7, 0xB07A, 0xB37D, 0xB6DC, 0xBA93,
        0xBE9D, 0xC2F5, 0xC797, 0xCC7C, 0xD19F, 0xD6FA, 0xDC87, 0xE23D, 0xE818, 0xEE0F, 0xF41C, 0xFA37, 0x0058, 0x067A, 0x0C94, 0x129E,
        0x1893, 0x1E6A, 0x241C, 0x29A3, 0x2EF8, 0x3415, 0x38F3, 0x3D8C, 0x41DC, 0x45DD, 0x498A, 0x4CDE, 0x4FD7, 0x526F, 0x54A5, 0x5675,
        0x57DD, 0x58DB, 0x596F, 0x5998, 0x5955, 0x58A6, 0x578E, 0x560C, 0x5423, 0x51D4, 0x4F24, 0x4C15, 0x48AA, 0x44E8, 0x40D3, 0x3C71,
        0x37C6, 0x32D7, 0x2DAC, 0x284A, 0x22B8, 0x1CFC, 0x171D, 0x1123, 0x0B14, 0x04F7, 0xFED6, 0xF8B5, 0xF29D, 0xEC94, 0xE6A4, 0xE0D1,
        0xDB24, 0xD5A4, 0xD056, 0xCB41, 0xC66C, 0xC1DC, 0xBD96, 0xB9A0, 0xB5FF, 0xB2B7, 0xAFCB, 0xAD3F, 0xAB17, 0xA955, 0xA7FB, 0xA70B,
        0xA685, 0xA66B, 0xA6BD, 0xA779, 0xA8A0, 0xAA30, 0xAC27, 0xAE82, 0xB13F, 0xB45B, 0xB7D2, 0xBB9F, 0xBFBE, 0xC42B, 0xC8DF, 0xCDD6,
        0xD309, 0xD872, 0xDE0A, 0xE3CB, 0xE9AE, 0xEFAC, 0xF5BD, 0xFBDB, 0x01FC, 0x081C, 0x0E33, 0x1438, 0x1A26, 0x1FF3, 0x259B, 0x2B15,
        0x305C, 0x3568, 0x3A34, 0x3EBB, 0x42F6, 0x46E1, 0x4A77, 0x4DB3, 0x5092, 0x5310, 0x552B, 0x56DF, 0x582B, 0x590D, 0x5984, 0x5990,
        0x5930, 0x5866, 0x5731, 0x5593, 0x538F, 0x5126, 0x4E5C, 0x4B34, 0x47B1, 0x43D8, 0x3FAE, 0x3B38, 0x367A, 0x317B, 0x2C41, 0x26D2,
        0x2133, 0x1B6D, 0x1586, 0x0F86, 0x0972, 0x0354, 0xFD32, 0xF712, 0xF0FE, 0xEAFB, 0xE512, 0xDF49, 0xD9A7, 0xD433, 0xCEF4, 0xC9F0,
        0xC52C, 0xC0B0, 0xBC7F, 0xB89F, 0xB515, 0xB1E5, 0xAF13, 0xACA2, 0xAA95, 0xA8EE, 0xA7B1, 0xA6DD, 0xA674, 0xA676, 0xA6E5, 0xA7BE,
        0xA901, 0xAAAC, 0xACBE, 0xAF34, 0xB20B, 0xB53F, 0xB8CE, 0xBCB1, 0xC0E6, 0xC566, 0xCA2D, 0xCF34, 0xD476, 0xD9EC, 0xDF90, 0xE55B,
        0xEB46, 0xF149, 0xF75F, 0xFD7E, 0x03A0, 0x09BE, 0x0FD1, 0x15D1, 0x1BB6, 0x217A, 0x2716, 0x2C84, 0x31BB, 0x36B7, 0x3B71, 0x3FE4,
        0x440A, 0x47DF, 0x4B5D, 0x4E81, 0x5146, 0x53AA, 0x55AA, 0x5742, 0x5872, 0x5938, 0x5992, 0x5981, 0x5905, 0x581D, 0x56CC, 0x5513,
        0x52F3, 0x5070, 0x4D8D, 0x4A4C, 0x46B2, 0x42C3, 0x3E84, 0x39FA, 0x352B, 0x301B, 0x2AD2, 0x2555, 0x1FAC, 0x19DC, 0x13EE, 0x0DE7,
        0x07D0, 0x01B0, 0xFB8E, 0xF571, 0xEF60, 0xE964, 0xE382, 0xDDC3, 0xD82D, 0xD2C7, 0xCD97, 0xC8A3, 0xC3F2, 0xBF89, 0xBB6E, 0xB7A5,
        0xB432, 0xB11B, 0xAE62, 0xAC0C, 0xAA1A, 0xA88F, 0xA76D, 0xA6B6, 0xA66A, 0xA689, 0xA714, 0xA80A, 0xA969, 0xAB30, 0xAD5D, 0xAFED,
        0xB2DD, 0xB62A, 0xB9D0, 0xBDCA, 0xC213, 0xC6A7, 0xCB7F, 0xD097, 0xD5E7, 0xDB6A, 0xE119, 0xE6ED, 0xECDF, 0xF2E8, 0xF901, 0xFF22,
        0x0544, 0x0B60, 0x116E, 0x1767, 0x1D45, 0x22FF, 0x288F, 0x2DEE, 0x3316, 0x3801, 0x3CA9, 0x4108, 0x4519, 0x48D7, 0x4C3D, 0x4F48,
        0x51F4, 0x543D, 0x5621, 0x579E, 0x58B1, 0x595A, 0x5998, 0x596A, 0x58D1, 0x57CD, 0x5660, 0x548B, 0x5251, 0x4FB4, 0x4CB7, 0x495E,
        0x45AD, 0x41A8, 0x3D55, 0x38B7, 0x33D6, 0x2EB7, 0x295F, 0x23D6, 0x1E21, 0x1849, 0x1253, 0x0C48, 0x062D, 0x000C, 0xF9EB, 0xF3D0,
        0xEDC4, 0xE7CE, 0xE1F5, 0xDC40, 0xD6B6, 0xD15E, 0xCC3E, 0xC75B, 0xC2BD, 0xBE68, 0xBA62, 0xB6B0, 0xB356, 0xB057, 0xADB8, 0xAB7D,
        0xA9A6, 0xA837, 0xA732, 0xA697, 0xA668, 0xA6A4, 0xA74B, 0xA85D, 0xA9D8, 0xABBB, 0xAE03, 0xB0AD, 0xB3B6, 0xB71B, 0xBAD8, 0xBEE7,
        0xC345, 0xC7EC, 0xCCD6, 0xD1FD, 0xD75C, 0xDCEB, 0xE2A5, 0xE881, 0xEE7A, 0xF488, 0xFAA4, 0x00C5, 0x06E7, 0x0D00, 0x1309, 0x18FC,
        0x1ED0, 0x2480, 0x2A04, 0x2F55, 0x346D, 0x3947, 0x3DDC, 0x4226, 0x4621, 0x49C8, 0x4D16, 0x5008, 0x529A, 0x54C8, 0x5691, 0x57F2,
        0x58E9, 0x5975, 0x5996, 0x594C, 0x5896, 0x5776, 0x55ED, 0x53FD, 0x51A8, 0x4EF1, 0x4BDB, 0x486A, 0x44A2, 0x4088, 0x3C20, 0x3770,
        0x327D, 0x2D4E, 0x27E9, 0x2253, 0x1C95, 0x16B4, 0x10B7, 0x0AA7, 0x048A, 0xFE68, 0xF848, 0xF231, 0xEC2A, 0xE63B, 0xE06B, 0xDAC1,
        0xD543, 0xCFF9, 0xCAE9, 0xC618, 0xC18D, 0xBD4D, 0xB95D, 0xB5C2, 0xB27F, 0xAF9A, 0xAD16, 0xAAF5, 0xA93A, 0xA7E7, 0xA6FE, 0xA680,
        0xA66D, 0xA6C6, 0xA78A, 0xA8B8, 0xAA4F, 0xAC4D, 0xAEB0, 0xB174, 0xB496, 0xB813, 0xBBE6, 0xC00B, 0xC47D, 0xC936, 0xCE31, 0xD368,
        0xD8D4, 0xDE6F, 0xE433, 0xEA18, 0xF017, 0xF62A, 0xFC48, 0x026A, 0x0889, 0x0E9F, 0x14A3, 0x1A8E, 0x2059, 0x25FE, 0x2B75, 0x30B8,
        0x35C0, 0x3A87, 0x3F09, 0x433F, 0x4724, 0x4AB3, 0x4DE9, 0x50C2, 0x5339, 0x554C, 0x56FA, 0x583E, 0x5919, 0x5989, 0x598D, 0x5926,
        0x5853, 0x5717, 0x5572, 0x5367, 0x50F7, 0x4E26, 0x4AF8, 0x476F, 0x4391, 0x3F61, 0x3AE6, 0x3623, 0x3120, 0x2BE2, 0x266F, 0x20CE,
        0x1B05, 0x151C, 0x0F1A, 0x0906, 0x02E6, 0xFCC5, 0xF6A6, 0xF092, 0xEA91, 0xE4AA, 0xDEE3, 0xD944, 0xD3D4, 0xCE99, 0xC999, 0xC4DA,
        0xC063, 0xBC37, 0xB85D, 0xB4DA, 0xB1B0, 0xAEE4, 0xAC7A, 0xAA74, 0xA8D5, 0xA79E, 0xA6D2, 0xA670, 0xA67B, 0xA6F0, 0xA7D1, 0xA91B,
        0xAACE, 0xACE7, 0xAF64, 0xB241, 0xB57C, 0xB910, 0xBCFA, 0xC134, 0xC5B9, 0xCA85, 0xCF90, 0xD4D6, 0xDA4F, 0xDFF6, 0xE5C3, 0xEBB0,
        0xF1B5, 0xF7CC, 0xFDEC, 0x040D, 0x0A2B, 0x103D, 0x163B, 0x1C1E, 0x21E0, 0x2779, 0x2CE2, 0x3216, 0x370E, 0x3BC3, 0x4031, 0x4451,
        0x4820, 0x4B98, 0x4EB5, 0x5174, 0x53D1, 0x55C9, 0x575B, 0x5883, 0x5941, 0x5994, 0x597C, 0x58F8, 0x5809, 0x56B1, 0x54F0, 0x52CA,
        0x5040, 0x4D56, 0x4A0F, 0x466F, 0x427A, 0x3E36, 0x39A7, 0x34D2, 0x2FBF, 0x2A72, 0x24F2, 0x1F45, 0x1974, 0x1383, 0x0D7B, 0x0763,
        0x0142, 0xFB21, 0xF504, 0xEEF5, 0xE8FA, 0xE31B, 0xDD5E, 0xD7CB, 0xD268, 0xCD3C, 0xC84D, 0xC3A1, 0xBF3D, 0xBB28, 0xB764, 0xB3F8,
        0xB0E7, 0xAE35, 0xABE6, 0xA9FB, 0xA878, 0xA75D, 0xA6AD, 0xA669, 0xA690, 0xA722, 0xA81F, 0xA985, 0xAB53, 0xAD87, 0xB01E, 0xB315,
        0xB668, 0xBA14, 0xBE13, 0xC262, 0xC6FB, 0xCBD8, 0xD0F4, 0xD648, 0xDBCE, 0xE180, 0xE756, 0xED4A, 0xF355, 0xF96E, 0xFF90, 0x05B1,
        0x0BCC, 0x11D9, 0x17D1, 0x1DAC, 0x2363, 0x28F0, 0x2E4C, 0x3370, 0x3857, 0x3CF9, 0x4153, 0x455E, 0x4916, 0x4C76, 0x4F7B, 0x521F,
        0x5462, 0x563F, 0x57B4, 0x58C0, 0x5962, 0x5998, 0x5963, 0x58C3, 0x57B7, 0x5643, 0x5467, 0x5226, 0x4F82, 0x4C7E, 0x491F, 0x4568,
        0x415E, 0x3D05, 0x3863, 0x337D, 0x2E59, 0x28FE, 0x2371, 0x1DBA, 0x17E0, 0x11E8, 0x0BDB, 0x05C0, 0xFF9F, 0xF97E, 0xF364, 0xED59,
        0xE765, 0xE18E, 0xDBDC, 0xD655, 0xD101, 0xCBE4, 0xC707, 0xC26D, 0xBE1E, 0xBA1E, 0xB671, 0xB31D, 0xB025, 0xAD8D, 0xAB59, 0xA989,
        0xA822, 0xA724, 0xA690, 0xA668, 0xA6AC, 0xA75B, 0xA874, 0xA9F7, 0xABE0, 0xAE2F, 0xB0E0, 0xB3F0, 0xB75B, 0xBB1E, 0xBF33, 0xC396,
        0xC841, 0xCD30, 0xD25B, 0xD7BD, 0xDD50, 0xE30C, 0xE8EB, 0xEEE6, 0xF4F5, 0xFB11, 0x0133, 0x0754, 0x0D6C, 0x1374, 0x1965, 0x1F37,
        0x24E4, 0x2A64, 0x2FB2, 0x34C6, 0x399B, 0x3E2B, 0x4270, 0x4665, 0x4A06, 0x4D4E, 0x5039, 0x52C4, 0x54EB, 0x56AD, 0x5806, 0x58F6,
        0x597B, 0x5995, 0x5943, 0x5886, 0x575E, 0x55CE, 0x53D6, 0x517A, 0x4EBD, 0x4BA0, 0x4829, 0x445B, 0x403B, 0x3BCF, 0x371A, 0x3223,
        0x2CF0, 0x2787, 0x21EE, 0x1C2D, 0x164A, 0x104C, 0x0A3B, 0x041D, 0xFDFB, 0xF7DB, 0xF1C5, 0xEBBF, 0xE5D2, 0xE005, 0xDA5D, 0xD4E3,
        0xCF9D, 0xCA91, 0xC5C5, 0xC13F, 0xBD04, 0xB91A, 0xB585, 0xB249, 0xAF6A, 0xACED, 0xAAD3, 0xA91F, 0xA7D3, 0xA6F2, 0xA67B, 0xA670,
        0xA6D0, 0xA79C, 0xA8D1, 0xAA70, 0xAC75, 0xAEDE, 0xB1A8, 0xB4D1, 0xB854, 0xBC2D, 0xC058, 0xC4CF, 0xC98C, 0xCE8C, 0xD3C6, 0xD936,
        0xDED5, 0xE49B, 0xEA82, 0xF083, 0xF696, 0xFCB5, 0x02D7, 0x08F6, 0x0F0B, 0x150D, 0x1AF6, 0x20BF, 0x2661, 0x2BD4, 0x3113, 0x3617,
        0x3ADA, 0x3F56, 0x4387, 0x4766, 0x4AEF, 0x4E1F, 0x50F1, 0x5361, 0x556E, 0x5714, 0x5851, 0x5924, 0x598D, 0x5989, 0x591B, 0x5841,
        0x56FD, 0x5551, 0x533F, 0x50C8, 0x4DF1, 0x4ABC, 0x472D, 0x4349, 0x3F14, 0x3A93, 0x35CC, 0x30C5, 0x2B82, 0x260C, 0x2068, 0x1A9D,
        0x14B2, 0x0EAE, 0x0899, 0x0279, 0xFC57, 0xF639, 0xF026, 0xEA27, 0xE442, 0xDE7E, 0xD8E2, 0xD375, 0xCE3E, 0xC942, 0xC488, 0xC016,
        0xBBF0, 0xB81C, 0xB49E, 0xB17B, 0xAEB6, 0xAC53, 0xAA54, 0xA8BC, 0xA78D, 0xA6C8, 0xA66E, 0xA67F, 0xA6FC, 0xA7E4, 0xA936, 0xAAF0,
        0xAD10, 0xAF93, 0xB278, 0xB5B9, 0xB953, 0xBD43, 0xC182, 0xC60C, 0xCADC, 0xCFEC, 0xD536, 0xDAB3, 0xE05C, 0xE62C, 0xEC1B, 0xF221,
        0xF838, 0xFE59, 0x047B, 0x0A98, 0x10A8, 0x16A5, 0x1C86, 0x2245, 0x27DB, 0x2D41, 0x3271, 0x3764, 0x3C14, 0x407D, 0x4498, 0x4861,
        0x4BD2, 0x4EE9, 0x51A1, 0x53F7, 0x55E9, 0x5773, 0x5894, 0x594B, 0x5996, 0x5976, 0x58EB, 0x57F5, 0x5695, 0x54CD, 0x52A0, 0x500F,
        0x4D1E, 0x49D1, 0x462B, 0x4231, 0x3DE7, 0x3953, 0x347A, 0x2F62, 0x2A11, 0x248E, 0x1EDF, 0x190B, 0x1318, 0x0D0F, 0x06F6, 0x00D5,
        0xFAB4, 0xF498, 0xEE8A, 0xE890, 0xE2B3, 0xDCF9, 0xD76A, 0xD20A, 0xCCE2, 0xC7F8, 0xC351, 0xBEF2, 0xBAE2, 0xB724, 0xB3BE, 0xB0B4,
        0xAE09, 0xABC0, 0xA9DD, 0xA861, 0xA74E, 0xA6A5, 0xA668, 0xA696, 0xA730, 0xA834, 0xA9A2, 0xAB77, 0xADB2, 0xB050, 0xB34D, 0xB6A7,
        0xBA59, 0xBE5E, 0xC2B2, 0xC74F, 0xCC31, 0xD151, 0xD6A9, 0xDC32, 0xE1E7, 0xE7BF, 0xEDB5, 0xF3C1, 0xF9DB, 0xFFFD, 0x061E, 0x0C38,
        0x1244, 0x183A, 0x1E13, 0x23C8, 0x2951, 0x2EA9, 0x33CA, 0x38AB, 0x3D49, 0x419E, 0x45A3, 0x4955, 0x4CAF, 0x4FAD, 0x524B, 0x5486,
        0x565C, 0x57CA, 0x58CF, 0x5969, 0x5998, 0x595B, 0x58B3, 0x57A1, 0x5625, 0x5442, 0x51FA, 0x4F4F, 0x4C45, 0x48E0, 0x4523, 0x4113,
        0x3CB4, 0x380D, 0x3323, 0x2DFB, 0x289D, 0x230D, 0x1D53, 0x1776, 0x117D, 0x0B6F, 0x0553, 0xFF32, 0xF911, 0xF2F8, 0xECEE, 0xE6FC,
        0xE128, 0xDB78, 0xD5F5, 0xD0A4, 0xCB8C, 0xC6B2, 0xC21E, 0xBDD4, 0xB9D9, 0xB633, 0xB2E5, 0xAFF4, 0xAD63, 0xAB35, 0xA96D, 0xA80D,
        0xA716, 0xA68A, 0xA66A, 0xA6B5, 0xA76B, 0xA88C, 0xAA15, 0xAC06, 0xAE5C, 0xB114, 0xB42A, 0xB79B, 0xBB64, 0xBF7E, 0xC3E7, 0xC897,
        0xCD8A, 0xD2B9, 0xD81F, 0xDDB5, 0xE374, 0xE955, 0xEF51, 0xF561, 0xFB7F, 0x01A0, 0x07C1, 0x0DD8, 0x13DF, 0x19CD, 0x1F9D, 0x2547,
        0x2AC4, 0x300E, 0x351E, 0x39EE, 0x3E79, 0x42B9, 0x46A8, 0x4A43, 0x4D85, 0x5069, 0x52EE, 0x550E, 0x56C8, 0x581A, 0x5903, 0x5980,
        0x5992, 0x5939, 0x5874, 0x5746, 0x55AE, 0x53B0, 0x514D, 0x4E88, 0x4B65, 0x47E8, 0x4414, 0x3FEF, 0x3B7D, 0x36C3, 0x31C8, 0x2C91,
        0x2724, 0x2189, 0x1BC5, 0x15E0, 0x0FE0, 0x09CE, 0x03B0, 0xFD8E, 0xF76E, 0xF159, 0xEB55, 0xE56A, 0xDF9F, 0xD9FA, 0xD484, 0xCF41,
        0xCA39, 0xC572, 0xC0F1, 0xBCBC, 0xB8D7, 0xB548, 0xB213, 0xAF3B, 0xACC4, 0xAAB1, 0xA904, 0xA7C0, 0xA6E6, 0xA677, 0xA673, 0xA6DB,
        0xA7AE, 0xA8EB, 0xAA90, 0xAC9C, 0xAF0C, 0xB1DE, 0xB50D, 0xB896, 0xBC75, 0xC0A5, 0xC521, 0xC9E3, 0xCEE7, 0xD426, 0xD999, 0xDF3A,
        0xE503, 0xEAEC, 0xF0EF, 0xF703, 0xFD22, 0x0344, 0x0963, 0x0F76, 0x1577, 0x1B5F, 0x2125, 0x26C4, 0x2C34, 0x316E, 0x366E, 0x3B2C,
        0x3FA4, 0x43CE, 0x47A8, 0x4B2B, 0x4E54, 0x511F, 0x5389, 0x558E, 0x572D, 0x5863, 0x592F, 0x5990, 0x5985, 0x590F, 0x582E, 0x56E3,
        0x5530, 0x5316, 0x5099, 0x4DBB, 0x4A7F, 0x46EA, 0x4300, 0x3EC6, 0x3A40, 0x3575, 0x3069, 0x2B23, 0x25A9, 0x2002, 0x1A34, 0x1447,
        0x0E42, 0x082C, 0x020C, 0xFBEA, 0xF5CC, 0xEFBB, 0xE9BD, 0xE3DA, 0xDE18, 0xD880, 0xD316, 0xCDE3, 0xC8EC, 0xC437, 0xBFC9, 0xBBA9,
        0xB7DB, 0xB463, 0xB147, 0xAE88, 0xAC2C, 0xAA34, 0xA8A3, 0xA77C, 0xA6BE, 0xA66B, 0xA685, 0xA709, 0xA7F8, 0xA951, 0xAB12, 0xAD39,
        0xAFC4, 0xB2AF, 0xB5F6, 0xB997, 0xBD8C, 0xC1D1, 0xC660, 0xCB35, 0xD049, 0xD596, 0xDB16, 0xE0C3, 0xE695, 0xEC85, 0xF28D, 0xF8A5,
        0xFEC6, 0x04E8, 0x0B04, 0x1114, 0x170E, 0x1CED, 0x22AA, 0x283D, 0x2D9F, 0x32CB, 0x37B9, 0x3C65, 0x40C9, 0x44DE, 0x48A1, 0x4C0C,
        0x4F1D, 0x51CE, 0x541D, 0x5607, 0x578A, 0x58A4, 0x5953, 0x5997, 0x5970, 0x58DD, 0x57E0, 0x5679, 0x54AA, 0x5275, 0x4FDE, 0x4CE6,
        0x4993, 0x45E7, 0x41E7, 0x3D98, 0x38FF, 0x3421, 0x2F05, 0x29B1, 0x242A, 0x1E78, 0x18A2, 0x12AD, 0x0CA3, 0x0689, 0x0068, 0xFA47,
        0xF42B, 0xEE1E, 0xE827, 0xE24C, 0xDC95, 0xD708, 0xD1AD, 0xCC89, 0xC7A3, 0xC300, 0xBEA7, 0xBA9C, 0xB6E5, 0xB385, 0xB081, 0xADDD,
        0xAB9B, 0xA9BF, 0xA84A, 0xA73E, 0xA69D, 0xA668, 0xA69D, 0xA73F, 0xA84A, 0xA9BF, 0xAB9C, 0xADDE, 0xB082, 0xB386, 0xB6E6, 0xBA9E,
        0xBEA8, 0xC302, 0xC7A4, 0xCC8A, 0xD1AE, 0xD70A, 0xDC96, 0xE24E, 0xE829, 0xEE20, 0xF42D, 0xFA48, 0x0069, 0x068B, 0x0CA5, 0x12AF,
        0x18A3, 0x1E7A, 0x242C, 0x29B2, 0x2F07, 0x3423, 0x3900, 0x3D99, 0x41E8, 0x45E8, 0x4994, 0x4CE7, 0x4FDF, 0x5276, 0x54AA, 0x5679,
        0x57E0, 0x58DD, 0x5970, 0x5997, 0x5953, 0x58A4, 0x578A, 0x5607, 0x541D, 0x51CD, 0x4F1C, 0x4C0C, 0x48A0, 0x44DD, 0x40C7, 0x3C64,
        0x37B8, 0x32C9, 0x2D9E, 0x283B, 0x22A8, 0x1CEC, 0x170D, 0x1112, 0x0B02, 0x04E6, 0xFEC5, 0xF8A4, 0xF28C, 0xEC84, 0xE693, 0xE0C1,
        0xDB15, 0xD594, 0xD047, 0xCB33, 0xC65F, 0xC1CF, 0xBD8B, 0xB996, 0xB5F5, 0xB2AE, 0xAFC3, 0xAD39, 0xAB12, 0xA951, 0xA7F8, 0xA709,
        0xA684, 0xA66B, 0xA6BE, 0xA77C, 0xA8A4, 0xAA35, 0xAC2D, 0xAE89, 0xB148, 0xB464, 0xB7DC, 0xBBAA, 0xBFCB, 0xC438, 0xC8ED, 0xCDE4,
        0xD318, 0xD881, 0xDE1A, 0xE3DB, 0xE9BF, 0xEFBD, 0xF5CE, 0xFBEC, 0x020D, 0x082E, 0x0E44, 0x1449, 0x1A36, 0x2004, 0x25AA, 0x2B24,
        0x306A, 0x3576, 0x3A42, 0x3EC7, 0x4302, 0x46EC, 0x4A80, 0x4DBC, 0x5099, 0x5317, 0x5530, 0x56E3, 0x582E, 0x590F, 0x5985, 0x5990,
        0x592F, 0x5863, 0x572D, 0x558E, 0x5388, 0x511F, 0x4E53, 0x4B2A, 0x47A7, 0x43CD, 0x3FA2, 0x3B2B, 0x366D, 0x316D, 0x2C32, 0x26C2,
        0x2123, 0x1B5D, 0x1576, 0x0F75, 0x0961, 0x0342, 0xFD21, 0xF701, 0xF0ED, 0xEAEA, 0xE501, 0xDF39, 0xD997, 0xD424, 0xCEE6, 0xC9E2,
        0xC51F, 0xC0A3, 0xBC74, 0xB895, 0xB50C, 0xB1DD, 0xAF0C, 0xAC9C, 0xAA90, 0xA8EA, 0xA7AE, 0xA6DB, 0xA673, 0xA677, 0xA6E6, 0xA7C1,
        0xA905, 0xAAB1, 0xACC5, 0xAF3C, 0xB213, 0xB549, 0xB8D8, 0xBCBD, 0xC0F2, 0xC573, 0xCA3B, 0xCF43, 0xD485, 0xD9FC, 0xDFA0, 0xE56B,
        0xEB56, 0xF15A, 0xF770, 0xFD90, 0x03B1, 0x09D0, 0x0FE2, 0x15E2, 0x1BC7, 0x218A, 0x2726, 0x2C93, 0x31CA, 0x36C5, 0x3B7E, 0x3FF0,
        0x4416, 0x47E9, 0x4B66, 0x4E89, 0x514D, 0x53B0, 0x55AF, 0x5746, 0x5875, 0x5939, 0x5993, 0x5980, 0x5903, 0x581A, 0x56C8, 0x550D,
        0x52ED, 0x5069, 0x4D84, 0x4A42, 0x46A7, 0x42B8, 0x3E78, 0x39ED, 0x351D, 0x300D, 0x2AC3, 0x2546, 0x1F9C, 0x19CC, 0x13DD, 0x0DD6,
        0x07BF, 0x019E, 0xFB7D, 0xF560, 0xEF4F, 0xE953, 0xE372, 0xDDB3, 0xD81D, 0xD2B8, 0xCD88, 0xC896, 0xC3E5, 0xBF7D, 0xBB63, 0xB79A,
        0xB429, 0xB113, 0xAE5B, 0xAC06, 0xAA15, 0xA88B, 0xA76B, 0xA6B5, 0xA66A, 0xA68A, 0xA716, 0xA80D, 0xA96D, 0xAB36, 0xAD64, 0xAFF5,
        0xB2E6, 0xB634, 0xB9DB, 0xBDD5, 0xC21F, 0xC6B4, 0xCB8D, 0xD0A5, 0xD5F6, 0xDB7A, 0xE129, 0xE6FE, 0xECF0, 0xF2F9, 0xF912, 0xFF34,
        0x0555, 0x0B71, 0x117F, 0x1778, 0x1D55, 0x230F, 0x289E, 0x2DFD, 0x3325, 0x380F, 0x3CB6, 0x4114, 0x4524, 0x48E1, 0x4C46, 0x4F50,
        0x51FA, 0x5443, 0x5626, 0x57A1, 0x58B4, 0x595C, 0x5998, 0x5969, 0x58CF, 0x57CA, 0x565C, 0x5486, 0x524A, 0x4FAC, 0x4CAE, 0x4954,
        0x45A2, 0x419C, 0x3D48, 0x38AA, 0x33C8, 0x2EA8, 0x2950, 0x23C6, 0x1E11, 0x1838, 0x1242, 0x0C37, 0x061C, 0xFFFB, 0xF9D9, 0xF3BF,
        0xEDB3, 0xE7BE, 0xE1E5, 0xDC31, 0xD6A7, 0xD14F, 0xCC2F, 0xC74E, 0xC2B0, 0xBE5C, 0xBA57, 0xB6A6, 0xB34D, 0xB04F, 0xADB2, 0xAB77,
        0xA9A2, 0xA834, 0xA730, 0xA696, 0xA668, 0xA6A5, 0xA74E, 0xA861, 0xA9DD, 0xABC1, 0xAE0A, 0xB0B5, 0xB3BF, 0xB725, 0xBAE3, 0xBEF3,
        0xC352, 0xC7F9, 0xCCE4, 0xD20C, 0xD76B, 0xDCFB, 0xE2B5, 0xE892, 0xEE8B, 0xF49A, 0xFAB6, 0x00D7, 0x06F8, 0x0D11, 0x131A, 0x190C,
        0x1EE1, 0x2490, 0x2A13, 0x2F64, 0x347B, 0x3954, 0x3DE8, 0x4232, 0x462C, 0x49D2, 0x4D1F, 0x5010, 0x52A0, 0x54CE, 0x5695, 0x57F5,
        0x58EB, 0x5976, 0x5996, 0x594A, 0x5894, 0x5772, 0x55E8, 0x53F7, 0x51A1, 0x4EE8, 0x4BD1, 0x4860, 0x4497, 0x407C, 0x3C13, 0x3762,
        0x326F, 0x2D3F, 0x27D9, 0x2243, 0x1C84, 0x16A3, 0x10A6, 0x0A96, 0x0479, 0xFE57, 0xF837, 0xF21F, 0xEC19, 0xE62A, 0xE05B, 0xDAB1,
        0xD534, 0xCFEB, 0xCADB, 0xC60B, 0xC181, 0xBD41, 0xB952, 0xB5B8, 0xB277, 0xAF93, 0xAD0F, 0xAAEF, 0xA936, 0xA7E4, 0xA6FC, 0xA67F,
        0xA66E, 0xA6C8, 0xA78D, 0xA8BC, 0xAA54, 0xAC53, 0xAEB7, 0xB17C, 0xB49F, 0xB81D, 0xBBF1, 0xC017, 0xC48A, 0xC943, 0xCE3F, 0xD377,
        0xD8E3, 0xDE7F, 0xE443, 0xEA29, 0xF028, 0xF63B, 0xFC59, 0x027B, 0x089B, 0x0EB0, 0x14B4, 0x1A9F, 0x206A, 0x260E, 0x2B84, 0x30C6,
        0x35CE, 0x3A95, 0x3F15, 0x434A, 0x472E, 0x4ABD, 0x4DF2, 0x50C9, 0x533F, 0x5552, 0x56FE, 0x5841, 0x591B, 0x5989, 0x598C, 0x5924,
        0x5851, 0x5713, 0x556D, 0x5361, 0x50F0, 0x4E1E, 0x4AEE, 0x4765, 0x4385, 0x3F55, 0x3AD9, 0x3616, 0x3112, 0x2BD3, 0x265F, 0x20BE,
        0x1AF5, 0x150B, 0x0F09, 0x08F4, 0x02D5, 0xFCB3, 0xF694, 0xF081, 0xEA80, 0xE499, 0xDED3, 0xD935, 0xD3C5, 0xCE8A, 0xC98B, 0xC4CD,
        0xC056, 0xBC2C, 0xB853, 0xB4D0, 0xB1A8, 0xAEDD, 0xAC74, 0xAA6F, 0xA8D1, 0xA79C, 0xA6D0, 0xA670, 0xA67B, 0xA6F2, 0xA7D4, 0xA91F,
        0xAAD3, 0xACED, 0xAF6B, 0xB24A, 0xB586, 0xB91B, 0xBD05, 0xC140, 0xC5C6, 0xCA92, 0xCF9F, 0xD4E5, 0xDA5F, 0xE006, 0xE5D4, 0xEBC1,
        0xF1C6, 0xF7DD, 0xFDFD, 0x041F, 0x0A3C, 0x104E, 0x164C, 0x1C2F, 0x21F0, 0x2788, 0x2CF1, 0x3224, 0x371B, 0x3BD0, 0x403D, 0x445C,
        0x482A, 0x4BA1, 0x4EBD, 0x517B, 0x53D7, 0x55CE, 0x575F, 0x5886, 0x5943, 0x5995, 0x597B, 0x58F6, 0x5806, 0x56AC, 0x54EB, 0x52C3,
        0x5038, 0x4D4D, 0x4A05, 0x4664, 0x426E, 0x3E29, 0x3999, 0x34C4, 0x2FB0, 0x2A62, 0x24E2, 0x1F35, 0x1963, 0x1372, 0x0D6A, 0x0752,
        0x0131, 0xFB10, 0xF4F3, 0xEEE4, 0xE8E9, 0xE30A, 0xDD4E, 0xD7BC, 0xD25A, 0xCD2E, 0xC840, 0xC394, 0xBF32, 0xBB1C, 0xB75A, 0xB3EF,
        0xB0DF, 0xAE2E, 0xABE0, 0xA9F6, 0xA874, 0xA75B, 0xA6AC, 0xA668, 0xA691, 0xA724, 0xA822, 0xA98A, 0xAB59, 0xAD8E, 0xB026, 0xB31E,
        0xB672, 0xBA1F, 0xBE1F, 0xC26F, 0xC708, 0xCBE6, 0xD102, 0xD657, 0xDBDE, 0xE190, 0xE767, 0xED5B, 0xF366, 0xF97F, 0xFFA1, 0x05C2,
        0x0BDD, 0x11EA, 0x17E1, 0x1DBC, 0x2373, 0x2900, 0x2E5B, 0x337E, 0x3864, 0x3D06, 0x415F, 0x4569, 0x4920, 0x4C7F, 0x4F83, 0x5226,
        0x5468, 0x5643, 0x57B8, 0x58C3, 0x5963, 0x5998, 0x5962, 0x58C0, 0x57B4, 0x563E, 0x5461, 0x521F, 0x4F7A, 0x4C75, 0x4915, 0x455D,
        0x4152, 0x3CF8, 0x3855, 0x336F, 0x2E4A, 0x28EF, 0x2362, 0x1DAA, 0x17CF, 0x11D7, 0x0BCA, 0x05AF, 0xFF8E, 0xF96C, 0xF353, 0xED48,
        0xE754, 0xE17E, 0xDBCC, 0xD646, 0xD0F2, 0xCBD6, 0xC6F9, 0xC261, 0xBE12, 0xBA13, 0xB667, 0xB314, 0xB01E, 0xAD87, 0xAB53, 0xA985,
        0xA81E, 0xA722, 0xA68F, 0xA669, 0xA6AD, 0xA75E, 0xA878, 0xA9FC, 0xABE6, 0xAE36, 0xB0E8, 0xB3F9, 0xB765, 0xBB29, 0xBF3F, 0xC3A2,
        0xC84F, 0xCD3E, 0xD26A, 0xD7CD, 0xDD60, 0xE31C, 0xE8FC, 0xEEF7, 0xF506, 0xFB23, 0x0144, 0x0765, 0x0D7D, 0x1385, 0x1975, 0x1F47,
        0x24F3, 0x2A73, 0x2FC0, 0x34D4, 0x39A8, 0x3E37, 0x427B, 0x4670, 0x4A10, 0x4D57, 0x5041, 0x52CA, 0x54F1, 0x56B1, 0x580A, 0x58F8,
        0x597C, 0x5994, 0x5941, 0x5883, 0x575A, 0x55C9, 0x53D0, 0x5173, 0x4EB4, 0x4B97, 0x481F, 0x4450, 0x402F, 0x3BC2, 0x370C, 0x3214,
        0x2CE1, 0x2777, 0x21DE, 0x1C1C, 0x1639, 0x103B, 0x0A29, 0x040C, 0xFDEA, 0xF7CA, 0xF1B3, 0xEBAE, 0xE5C2, 0xDFF4, 0xDA4E, 0xD4D4,
        0xCF8F, 0xCA83, 0xC5B8, 0xC133, 0xBCF9, 0xB90F, 0xB57B, 0xB240, 0xAF63, 0xACE6, 0xAACD, 0xA91B, 0xA7D0, 0xA6F0, 0xA67B, 0xA671,
        0xA6D2, 0xA79F, 0xA8D5, 0xAA75, 0xAC7B, 0xAEE5, 0xB1B1, 0xB4DB, 0xB85F, 0xBC38, 0xC064, 0xC4DC, 0xC99A, 0xCE9A, 0xD3D6, 0xD946,
        0xDEE5, 0xE4AB, 0xEA93, 0xF094, 0xF6A7, 0xFCC6, 0x02E8, 0x0907, 0x0F1C, 0x151E, 0x1B07, 0x20CF, 0x2670, 0x2BE3, 0x3122, 0x3625,
        0x3AE7, 0x3F63, 0x4392, 0x4770, 0x4AF9, 0x4E27, 0x50F8, 0x5368, 0x5573, 0x5718, 0x5854, 0x5926, 0x598D, 0x5989, 0x5919, 0x583E,
        0x56F9, 0x554C, 0x5338, 0x50C1, 0x4DE8, 0x4AB2, 0x4723, 0x433D, 0x3F08, 0x3A86, 0x35BE, 0x30B6, 0x2B73, 0x25FC, 0x2058, 0x1A8C,
        0x14A1, 0x0E9D, 0x0888, 0x0268, 0xFC46, 0xF628, 0xF015, 0xEA16, 0xE431, 0xDE6D, 0xD8D2, 0xD366, 0xCE2F, 0xC934, 0xC47B, 0xC00A,
        0xBBE5, 0xB812, 0xB495, 0xB173, 0xAEAF, 0xAC4D, 0xAA4F, 0xA8B8, 0xA78A, 0xA6C6, 0xA66D, 0xA680, 0xA6FE, 0xA7E7, 0xA93A, 0xAAF5,
        0xAD16, 0xAF9B, 0xB280, 0xB5C3, 0xB95E, 0xBD4E, 0xC18E, 0xC61A, 0xCAEA, 0xCFFB, 0xD545, 0xDAC2, 0xE06C, 0xE63D, 0xEC2C, 0xF232,
        0xF84A, 0xFE6A, 0x048C, 0x0AA9, 0x10B9, 0x16B5, 0x1C96, 0x2255, 0x27EA, 0x2D50, 0x327F, 0x3771, 0x3C21, 0x4089, 0x44A3, 0x486B,
        0x4BDC, 0x4EF1, 0x51A8, 0x53FD, 0x55EE, 0x5776, 0x5896, 0x594C, 0x5996, 0x5975, 0x58E9, 0x57F1, 0x5690, 0x54C8, 0x5299, 0x5007,
        0x4D15, 0x49C7, 0x4620, 0x4225, 0x3DDA, 0x3945, 0x346C, 0x2F53, 0x2A02, 0x247E, 0x1ECF, 0x18FA, 0x1307, 0x0CFE, 0x06E5, 0x00C4,
        0xFAA2, 0xF487, 0xEE79, 0xE880, 0xE2A3, 0xDCE9, 0xD75A, 0xD1FC, 0xCCD4, 0xC7EA, 0xC344, 0xBEE6, 0xBAD7, 0xB71A, 0xB3B5, 0xB0AC,
        0xAE02, 0xABBA, 0xA9D8, 0xA85D, 0xA74B, 0xA6A4, 0xA668, 0xA697, 0xA732, 0xA838, 0xA9A7, 0xAB7D, 0xADB9, 0xB058, 0xB356, 0xB6B1,
        0xBA63, 0xBE69, 0xC2BE, 0xC75D, 0xCC3F, 0xD160, 0xD6B8, 0xDC42, 0xE1F7, 0xE7D0, 0xEDC6, 0xF3D2, 0xF9ED, 0x000D, 0x062F, 0x0C4A,
        0x1255, 0x184B, 0x1E23, 0x23D7, 0x2961, 0x2EB8, 0x33D8, 0x38B9, 0x3D56, 0x41A9, 0x45AE, 0x495F, 0x4CB8, 0x4FB5, 0x5252, 0x548C,
        0x5661, 0x57CE, 0x58D1, 0x596A, 0x5998, 0x595A, 0x58B1, 0x579D, 0x5620, 0x543C, 0x51F3, 0x4F47, 0x4C3C, 0x48D6, 0x4518, 0x4107,
        0x3CA8, 0x3800, 0x3315, 0x2DED, 0x288D, 0x22FD, 0x1D43, 0x1766, 0x116C, 0x0B5E, 0x0542, 0xFF21, 0xF8FF, 0xF2E7, 0xECDD, 0xE6EB,
        0xE117, 0xDB68, 0xD5E5, 0xD095, 0xCB7E, 0xC6A5, 0xC212, 0xBDC8, 0xB9CF, 0xB629, 0xB2DC, 0xAFEC, 0xAD5C, 0xAB2F, 0xA968, 0xA809,
        0xA714, 0xA689, 0xA66A, 0xA6B6, 0xA76E, 0xA890, 0xAA1A, 0xAC0C, 0xAE63, 0xB11C, 0xB433, 0xB7A6, 0xBB6F, 0xBF8A, 0xC3F3, 0xC8A5,
        0xCD98, 0xD2C8, 0xD82F, 0xDDC5, 0xE384, 0xE965, 0xEF62, 0xF573, 0xFB90, 0x01B1, 0x07D2, 0x0DE9, 0x13F0, 0x19DE, 0x1FAD, 0x2557,
        0x2AD3, 0x301D, 0x352C, 0x39FC, 0x3E86, 0x42C4, 0x46B3, 0x4A4D, 0x4D8E, 0x5071, 0x52F4, 0x5513, 0x56CD, 0x581E, 0x5905, 0x5981,
        0x5992, 0x5937, 0x5872, 0x5742, 0x55A9, 0x53A9, 0x5145, 0x4E80, 0x4B5C, 0x47DE, 0x4409, 0x3FE3, 0x3B70, 0x36B6, 0x31BA, 0x2C82,
        0x2715, 0x2179, 0x1BB5, 0x15CF, 0x0FCF, 0x09BD, 0x039E, 0xFD7D, 0xF75D, 0xF148, 0xEB44, 0xE559, 0xDF8E, 0xD9EB, 0xD475, 0xCF33,
        0xCA2C, 0xC565, 0xC0E5, 0xBCB0, 0xB8CD, 0xB53E, 0xB20A, 0xAF33, 0xACBD, 0xAAAC, 0xA900, 0xA7BD, 0xA6E4, 0xA676, 0xA674, 0xA6DD,
        0xA7B1, 0xA8EF, 0xAA95, 0xACA3, 0xAF14, 0xB1E6, 0xB516, 0xB8A0, 0xBC80, 0xC0B1, 0xC52E, 0xC9F1, 0xCEF6, 0xD435, 0xD9A9, 0xDF4A,
        0xE514, 0xEAFD, 0xF100, 0xF714, 0xFD34, 0x0355, 0x0974, 0x0F87, 0x1588, 0x1B6F, 0x2135, 0x26D3, 0x2C43, 0x317D, 0x367C, 0x3B39,
        0x3FB0, 0x43DA, 0x47B2, 0x4B35, 0x4E5D, 0x5127, 0x538F, 0x5593, 0x5731, 0x5866, 0x5931, 0x5990, 0x5984, 0x590D, 0x582B, 0x56DF,
        0x552A, 0x5310, 0x5091, 0x4DB2, 0x4A76, 0x46E0, 0x42F5, 0x3EBA, 0x3A33, 0x3567, 0x305A, 0x2B13, 0x2599, 0x1FF2, 0x1A24, 0x1437,
        0x0E31, 0x081B, 0x01FA, 0xFBD9, 0xF5BB, 0xEFAA, 0xE9AC, 0xE3C9, 0xDE08, 0xD870, 0xD307, 0xCDD5, 0xC8DE, 0xC42A, 0xBFBD, 0xBB9E,
        0xB7D1, 0xB45A, 0xB13E, 0xAE81, 0xAC26, 0xAA2F, 0xA8A0, 0xA779, 0xA6BC, 0xA66B, 0xA685, 0xA70B, 0xA7FC, 0xA956, 0xAB18, 0xAD40,
        0xAFCC, 0xB2B7, 0xB600, 0xB9A1, 0xBD97, 0xC1DD, 0xC66D, 0xCB43, 0xD057, 0xD5A5, 0xDB26, 0xE0D3, 0xE6A5, 0xEC96, 0xF29E, 0xF8B7,
        0xFED8, 0x04F9, 0x0B15, 0x1125, 0x171F, 0x1CFE, 0x22BA, 0x284C, 0x2DAE, 0x32D9, 0x37C7, 0x3C72, 0x40D4, 0x44E9, 0x48AB, 0x4C16,
        0x4F25, 0x51D5, 0x5423, 0x560C, 0x578E, 0x58A7, 0x5955, 0x5998, 0x596F, 0x58DB, 0x57DC, 0x5674, 0x54A4, 0x526E, 0x4FD6, 0x4CDD,
        0x4989, 0x45DC, 0x41DB, 0x3D8B, 0x38F1, 0x3413, 0x2EF6, 0x29A1, 0x241A, 0x1E68, 0x1891, 0x129D, 0x0C92, 0x0678, 0x0056, 0xFA35,
        0xF41A, 0xEE0D, 0xE816, 0xE23C, 0xDC85, 0xD6F9, 0xD19E, 0xCC7B, 0xC795, 0xC2F4, 0xBE9B, 0xBA91, 0xB6DB, 0xB37C, 0xB07A, 0xADD6,
        0xAB96, 0xA9BA, 0xA846, 0xA73C, 0xA69C, 0xA668, 0xA69F, 0xA741, 0xA84E, 0xA9C4, 0xABA2, 0xADE5, 0xB08A, 0xB38F, 0xB6F0, 0xBAA8,
        0xBEB4, 0xC30E, 0xC7B2, 0xCC98, 0xD1BD, 0xD719, 0xDCA6, 0xE25E, 0xE839, 0xEE31, 0xF43E, 0xFA5A, 0x007B, 0x069C, 0x0CB6, 0x12C0,
        0x18B4, 0x1E8A, 0x243C, 0x29C2, 0x2F15, 0x3431, 0x390D, 0x3DA5, 0x41F4, 0x45F3, 0x499E, 0x4CF0, 0x4FE6, 0x527D, 0x54B0, 0x567E,
        0x57E3, 0x58E0, 0x5971, 0x5997, 0x5952, 0x58A1, 0x5786, 0x5602, 0x5417, 0x51C6, 0x4F14, 0x4C02, 0x4896, 0x44D2, 0x40BB, 0x3C57,
        0x37AA, 0x32BB, 0x2D8F, 0x282C, 0x2298, 0x1CDB, 0x16FC, 0x1101, 0x0AF1, 0x04D5, 0xFEB3, 0xF892, 0xF27A, 0xEC73, 0xE682, 0xE0B1,
        0xDB05, 0xD585, 0xD038, 0xCB25, 0xC651, 0xC1C3, 0xBD7F, 0xB98B, 0xB5EC, 0xB2A5, 0xAFBB, 0xAD32, 0xAB0C, 0xA94D, 0xA7F5, 0xA707,
        0xA684, 0xA66C, 0xA6C0, 0xA77E, 0xA8A8, 0xAA3A, 0xAC33, 0xAE90, 0xB150, 0xB46E, 0xB7E6, 0xBBB5, 0xBFD7, 0xC445, 0xC8FB, 0xCDF3,
        0xD327, 0xD891, 0xDE2A, 0xE3EC, 0xE9CF, 0xEFCE, 0xF5DF, 0xFBFD, 0x021F, 0x083F, 0x0E55, 0x145A, 0x1A47, 0x2014, 0x25BA, 0x2B33,
        0x3079, 0x3584, 0x3A4F, 0x3ED4, 0x430D, 0x46F6, 0x4A8A, 0x4DC4, 0x50A1, 0x531D, 0x5535, 0x56E7, 0x5831, 0x5911, 0x5986, 0x598F,
        0x592D, 0x5819, 0x569D, 0x54BB, 0x5277, 0x4FD3, 0x4CD4, 0x497D, 0x45D3, 0x41DB, 0x3D9B, 0x3918, 0x3457, 0x2F60, 0x2A37, 0x24E5,
        0x1F6F, 0x19DC, 0x1433, 0x0E7C, 0x08BC, 0x02FC, 0xFD43, 0xF795, 0xF1FB, 0xEC7C, 0xE71D, 0xE1E5, 0xDCDB, 0xD803, 0xD363, 0xCF01,
        0xCAE1, 0xC708, 0xC37A, 0xC03A, 0xBD4E, 0xBAB6, 0xB876, 0xB690, 0xB505, 0xB3D7, 0xB307, 0xB294, 0xB280, 0xB2C9, 0xB36D, 0xB46D,
        0xB5C6, 0xB776, 0xB97A, 0xBBCF, 0xBE71, 0xC15E, 0xC491, 0xC805, 0xCBB7, 0xCFA0, 0xD3BD, 0xD808, 0xDC7A, 0xE10F, 0xE5C1, 0xEA8A,
        0xEF64, 0xF449, 0xF933, 0xFE1C, 0x02FD, 0x07D2, 0x0C96, 0x1141, 0x15CE, 0x1A39, 0x1E7C, 0x2292, 0x2677, 0x2A26, 0x2D9C, 0x30D4,
        0x33CB, 0x367F, 0x38EB, 0x3B0F, 0x3CE7, 0x3E73, 0x3FB1, 0x409F, 0x413E, 0x418E, 0x418E, 0x413F, 0x40A2, 0x3FB9, 0x3E85, 0x3D09,
        0x3B45, 0x393E, 0x36F7, 0x3472, 0x31B2, 0x2EBD, 0x2B95, 0x2840, 0x24C1, 0x211C, 0x1D58, 0x1977, 0x1580, 0x1178, 0x0D63, 0x0946,
        0x0526, 0x0109, 0xFCF4, 0xF8EB, 0xF4F2, 0xF10F, 0xED47, 0xE99D, 0xE615, 0xE2B4, 0xDF7E, 0xDC76, 0xD99F, 0xD6FC, 0xD491, 0xD25E,
        0xD068, 0xCEAF, 0xCD35, 0xCBFC, 0xCB03, 0xCA4D, 0xC9D9, 0xC9A7, 0xC9B7, 0xCA08, 0xCA99, 0xCB6A, 0xCC78, 0xCDC1, 0xCF44, 0xD0FE,
        0xD2ED, 0xD50E, 0xD75D, 0xD9D9, 0xDC7C, 0xDF44, 0xE22D, 0xE533, 0xE853, 0xEB87, 0xEECD, 0xF220, 0xF57B, 0xF8DC, 0xFC3D, 0xFF9A,
        0x02EF, 0x0639, 0x0974, 0x0C9C, 0x0FAD, 0x12A3, 0x157C, 0x1835, 0x1AC9, 0x1D36, 0x1F7B, 0x2194, 0x237F, 0x253B, 0x26C5, 0x281D,
        0x2942, 0x2A31, 0x2AEC, 0x2B71, 0x2BC0, 0x2BDA, 0x2BBE, 0x2B6E, 0x2AEB, 0x2A35, 0x294E, 0x2838, 0x26F4, 0x2584, 0x23EB, 0x222B,
        0x2046, 0x1E40, 0x1C1A, 0x19D8, 0x177D, 0x150C, 0x1289, 0x0FF6, 0x0D56, 0x0AAE, 0x0800, 0x0550, 0x02A1, 0xFFF7, 0xFD53, 0xFABB,
        0xF830, 0xF5B5, 0xF34E, 0xF0FD, 0xEEC5, 0xECA8, 0xEAA8, 0xE8C8, 0xE709, 0xE56E, 0xE3F7, 0xE2A7, 0xE17E, 0xE07D, 0xDFA5, 0xDEF7,
        0xDE72, 0xDE18, 0xDDE8, 0xDDE1, 0xDE04, 0xDE50, 0xDEC3, 0xDF5D, 0xE01D, 0xE101, 0xE208, 0xE32F, 0xE476, 0xE5DA, 0xE75A, 0xE8F2,
        0xEAA2, 0xEC66, 0xEE3C, 0xF021, 0xF214, 0xF411, 0xF616, 0xF820, 0xFA2D, 0xFC3B, 0xFE46, 0x004C, 0x024B, 0x0441, 0x062B, 0x0808,
        0x09D4, 0x0B8E, 0x0D34, 0x0EC4, 0x103D, 0x119E, 0x12E4, 0x140F, 0x151D, 0x160E, 0x16E1, 0x1795, 0x182A, 0x189F, 0x18F5, 0x192C,
        0x1943, 0x193B, 0x1915, 0x18D0, 0x186F, 0x17F1, 0x1758, 0x16A5, 0x15D9, 0x14F6, 0x13FC, 0x12EE, 0x11CE, 0x109B, 0x0F5A, 0x0E0A,
        0x0CAF, 0x0B4A, 0x09DC, 0x0868, 0x06F0, 0x0576, 0x03FB, 0x0281, 0x010A, 0xFF99, 0xFE2D, 0xFCCA, 0xFB71, 0xFA22, 0xF8E1, 0xF7AE,
        0xF68A, 0xF576, 0xF474, 0xF385, 0xF2A9, 0xF1E1, 0xF12E, 0xF091, 0xF008, 0xEF96, 0xEF3A, 0xEEF5, 0xEEC5, 0xEEAB, 0xEEA7, 0xEEB9,
        0xEEDF, 0xEF1A, 0xEF68, 0xEFC9, 0xF03C, 0xF0C1, 0xF155, 0xF1F9, 0xF2AB, 0xF369, 0xF434, 0xF509, 0xF5E7, 0xF6CD, 0xF7B9, 0xF8AC,
        0xF9A2, 0xFA9B, 0xFB95, 0xFC90, 0xFD89, 0xFE80, 0xFF74, 0x0062, 0x014C, 0x022E, 0x0309, 0x03DC, 0x04A5, 0x0563, 0x0617, 0x06BE,
        0x075A, 0x07E9, 0x086A, 0x08DE, 0x0944, 0x099C, 0x09E6, 0x0A22, 0x0A4F, 0x0A6F, 0x0A80, 0x0A84, 0x0A7B, 0x0A65, 0x0A42, 0x0A13,
        0x09D9, 0x0994, 0x0945, 0x08EC, 0x088A, 0x0820, 0x07AF, 0x0738, 0x06BA, 0x0638, 0x05B1, 0x0527, 0x049A, 0x040C, 0x037D, 0x02EE,
        0x0260, 0x01D2, 0x0147, 0x00BF, 0x003A, 0xFFBA, 0xFF3E, 0xFEC7, 0xFE55, 0xFDEA, 0xFD84, 0xFD26, 0xFCCF, 0xFC7F, 0xFC36, 0xFBF5,
        0xFBBC, 0xFB8B, 0xFB61, 0xFB3F, 0xFB25, 0xFB13, 0xFB08, 0xFB04, 0xFB07, 0xFB10, 0xFB20, 0xFB36, 0xFB52, 0xFB73, 0xFB98, 0xFBC2,
        0xFBF1, 0xFC22, 0xFC57, 0xFC8F, 0xFCC9, 0xFD04, 0xFD41, 0xFD7F, 0xFDBD, 0xFDFB, 0xFE39, 0xFE76, 0xFEB2, 0xFEED, 0xFF26, 0xFF5D,
        0xFF91, 0xFFC3, 0xFFF2, 0x001D, 0x0046, 0x006C, 0x008F, 0x00AE, 0x00CA, 0x00E2, 0x00F7, 0x0108, 0x0116, 0x0121, 0x0129, 0x012E,
        0x0130, 0x012F, 0x012C, 0x0126, 0x011F, 0x0115, 0x010A, 0x00FE, 0x00F0, 0x00E1, 0x00D2, 0x00C2, 0x00B1, 0x00A1, 0x0091, 0x0081,
        0x0071, 0x0062, 0x0054, 0x0047, 0x003B, 0x002F, 0x0025, 0x001D, 0x0015, 0x000F, 0x000A, 0x0006, 0x0003, 0x0001, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0x0000, 0x0000, 0x0002,
        0x0005, 0x0007, 0x000B, 0x000F, 0x0013, 0x0018, 0x001D, 0x0023, 0x0029, 0x0030, 0x0037, 0x003F, 0x0046, 0x004E, 0x0056, 0x005D,
        0x0065, 0x006C, 0x0073, 0x0079, 0x007F, 0x0084, 0x0089, 0x008C, 0x008E, 0x008F, 0x008E, 0x008C, 0x0089, 0x0084, 0x007D, 0x0075,
        0x006A, 0x005E, 0x0050, 0x0040, 0x002E, 0x001B, 0x0005, 0xFFEF, 0xFFD7, 0xFFBD, 0xFFA1, 0xFF85, 0xFF67, 0xFF48, 0xFF29, 0xFF0A,
        0xFEEA, 0xFECA, 0xFEAB, 0xFE8C, 0xFE6E, 0xFE52, 0xFE36, 0xFE1D, 0xFE05, 0xFDF0, 0xFDDE, 0xFDCE, 0xFDC2, 0xFDB9, 0xFDB4, 0xFDB2,
        0xFDB5, 0xFDBC, 0xFDC7, 0xFDD7, 0xFDEC, 0xFE05, 0xFE23, 0xFE46, 0xFE6D, 0xFE99, 0xFEC9, 0xFEFE, 0xFF37, 0xFF74, 0xFFB4, 0xFFF7,
        0x003D, 0x0086, 0x00D2, 0x011F, 0x016D, 0x01BC, 0x020C, 0x025B, 0x02A9, 0x02F6, 0x0341, 0x0389, 0x03CE, 0x040F, 0x044C, 0x0484,
        0x04B7, 0x04E3, 0x0509, 0x0528, 0x0540, 0x0550, 0x0557, 0x0556, 0x054C, 0x0539, 0x051D, 0x04F7, 0x04C8, 0x0490, 0x044E, 0x0404,
        0x03B0, 0x0354, 0x02EF, 0x0282, 0x020E, 0x0193, 0x0112, 0x008B, 0x0000, 0xFF70, 0xFEDC, 0xFE46, 0xFDAF, 0xFD16, 0xFC7E, 0xFBE8,
        0xFB54, 0xFAC3, 0xFA36, 0xF9AF, 0xF92E, 0xF8B5, 0xF844, 0xF7DD, 0xF77F, 0xF72D, 0xF6E7, 0xF6AD, 0xF681, 0xF663, 0xF653, 0xF653,
        0xF661, 0xF680, 0xF6AE, 0xF6ED, 0xF73B, 0xF799, 0xF807, 0xF884, 0xF910, 0xF9AB, 0xFA53, 0xFB08, 0xFBCA, 0xFC96, 0xFD6D, 0xFE4D,
        0xFF34, 0x0022, 0x0115, 0x020D, 0x0306, 0x0401, 0x04FB, 0x05F2, 0x06E6, 0x07D4, 0x08BB, 0x0999, 0x0A6D, 0x0B36, 0x0BF0, 0x0C9C,
        0x0D38, 0x0DC3, 0x0E3A, 0x0E9E, 0x0EED, 0x0F26, 0x0F49, 0x0F54, 0x0F48, 0x0F23, 0x0EE6, 0x0E90, 0x0E22, 0x0D9C, 0x0CFE, 0x0C48,
        0x0B7B, 0x0A99, 0x09A1, 0x0896, 0x0779, 0x064A, 0x050B, 0x03BF, 0x0267, 0x0104, 0xFF9B, 0xFE2A, 0xFCB5, 0xFB3F, 0xF9C9, 0xF856,
        0xF6E8, 0xF582, 0xF426, 0xF2D6, 0xF194, 0xF063, 0xEF45, 0xEE3D, 0xED4B, 0xEC72, 0xEBB3, 0xEB11, 0xEA8D, 0xEA27, 0xE9E2, 0xE9BE,
        0xE9BC, 0xE9DD, 0xEA20, 0xEA87, 0xEB10, 0xEBBC, 0xEC8B, 0xED7B, 0xEE8B, 0xEFBB, 0xF10A, 0xF275, 0xF3FA, 0xF599, 0xF74E, 0xF918,
        0xFAF3, 0xFCDE, 0xFED5, 0x00D6, 0x02DD, 0x04E9, 0x06F5, 0x08FE, 0x0B01, 0x0CFB, 0x0EE9, 0x10C7, 0x1293, 0x1448, 0x15E5, 0x1767,
        0x18C9, 0x1A0B, 0x1B29, 0x1C22, 0x1CF3, 0x1D9A, 0x1E16, 0x1E65, 0x1E87, 0x1E7A, 0x1E3D, 0x1DD1, 0x1D36, 0x1C6B, 0x1B72, 0x1A4B,
        0x18F7, 0x1778, 0x15CF, 0x13FF, 0x120A, 0x0FF2, 0x0DBA, 0x0B65, 0x08F6, 0x0672, 0x03DA, 0x0133, 0xFE83, 0xFBCB, 0xF90F, 0xF655,
        0xF3A1, 0xF0F7, 0xEE5A, 0xEBD1, 0xE95D, 0xE704, 0xE4CA, 0xE2B3, 0xE0C1, 0xDEF9, 0xDD5E, 0xDBF3, 0xDABB, 0xD9B8, 0xD8ED, 0xD85B,
        0xD804, 0xD7EA, 0xD80D, 0xD86D, 0xD90C, 0xD9E9, 0xDB03, 0xDC59, 0xDDEA, 0xDFB4, 0xE1B6, 0xE3EC, 0xE655, 0xE8EC, 0xEBAF, 0xEE99,
        0xF1A7, 0xF4D5, 0xF81D, 0xFB7C, 0xFEEB, 0x0266, 0x05E9, 0x096D, 0x0CED, 0x1064, 0x13CC, 0x1720, 0x1A5A, 0x1D75, 0x206C, 0x233B,
        0x25DB, 0x2849, 0x2A81, 0x2C7E, 0x2E3C, 0x2FB8, 0x30F0, 0x31E0, 0x3286, 0x32E1, 0x32EF, 0x32AF, 0x3220, 0x3143, 0x3018, 0x2EA0,
        0x2CDD, 0x2AD0, 0x287C, 0x25E3, 0x2309, 0x1FF1, 0x1CA0, 0x191A, 0x1564, 0x1183, 0x0D7C, 0x0956, 0x0516, 0x00C3, 0xFC64, 0xF7FE,
        0xF399, 0xEF3A, 0xEAEA, 0xE6AE, 0xE28E, 0xDE90, 0xDABA, 0xD714, 0xD3A2, 0xD06B, 0xCD75, 0xCAC4, 0xC85E, 0xC647, 0xC482, 0xC314,
        0xC1FF, 0xC147, 0xC0ED, 0xC0F2, 0xC157, 0xC21E, 0xC345, 0xC4CC, 0xC6B1, 0xC8F3, 0xCB8E, 0xCE80, 0xD1C6, 0xD55A, 0xD938, 0xDD5B,
        0xE1BE, 0xE659, 0xEB27, 0xF021, 0xF53F, 0xFA7B, 0xFFCB, 0x0528, 0x0A8B, 0x0FEA, 0x153F, 0x1A80, 0x1FA5, 0x24A6, 0x297B, 0x2E1D,
        0x3283, 0x36A6, 0x3A7F, 0x3E09, 0x413C, 0x4413, 0x4688, 0x4898, 0x4A3D, 0x4B75, 0x4C3D, 0x4C92, 0x4C73, 0x4BDF, 0x4AD5, 0x4957,
        0x4766, 0x4503, 0x4231, 0x3EF4, 0x3B4F, 0x3748, 0x32E3, 0x2E26, 0x2918, 0x23C0, 0x1E26, 0x1850, 0x1249, 0x0C18, 0x05C7, 0xFF60,
        0xF8EB, 0xF272, 0xEC00, 0xE59E, 0xDF56, 0xD932, 0xD33C, 0xCD7D, 0xC7FF, 0xC2CA, 0xBDE8, 0xB95F, 0xB539, 0xB17B, 0xAE2D, 0xAB55,
        0xA955, 0xA7D8, 0xA6E0, 0xA66F, 0xA686, 0xA723, 0xA848, 0xA9F0, 0xAC1B, 0xAEC5, 0xB1EA, 0xB585, 0xB990, 0xBE06, 0xC2E0, 0xC816,
        0xCDA1, 0xD378, 0xD992, 0xDFE7, 0xE66C, 0xED17, 0xF3DF, 0xFABA, 0x019C, 0x087C, 0x0F4F, 0x160B, 0x1CA6, 0x2316, 0x2950, 0x2F4C,
        0x3500, 0x3A65, 0x3F71, 0x441D, 0x4862, 0x4C39, 0x4F9D, 0x5289, 0x54F8, 0x56E7, 0x5852, 0x5937, 0x5996, 0x596D, 0x58BD, 0x5786,
        0x55CC, 0x538F, 0x50D4, 0x4D9F, 0x49F5, 0x45DA, 0x4156, 0x3C6F, 0x372D, 0x3197, 0x2BB7, 0x2594, 0x1F38, 0x18AE, 0x11FD, 0x0B32,
        0x0456, 0xFD74, 0xF695, 0xEFC4, 0xE90C, 0xE276, 0xDC0E, 0xD5DB, 0xCFE8, 0xCA3E, 0xC4E6, 0xBFE6, 0xBB48, 0xB712, 0xB34A, 0xAFF5,
        0xAD1A, 0xAABD, 0xA8E0, 0xA787, 0xA6B4, 0xA668, 0xA6A3, 0xA766, 0xA8AE, 0xAA7B, 0xACC9, 0xAF95, 0xB2DA, 0xB694, 0xBABD, 0xBF4F,
        0xC443, 0xC991, 0xCF32, 0xD51C, 0xDB47, 0xE1AA, 0xE83A, 0xEEEE, 0xF5BD, 0xFC9B, 0x037D, 0x0A5A, 0x1128, 0x17DC, 0x1E6C, 0x24CE,
        0x2AF9, 0x30E2, 0x3681, 0x3BCE, 0x40C1, 0x4551, 0x4979, 0x4D32, 0x5075, 0x5340, 0x558C, 0x5757, 0x589E, 0x595E, 0x5998, 0x594A,
        0x5875, 0x571B, 0x553C, 0x52DD, 0x5000, 0x4CAA, 0x48E1, 0x44A9, 0x4009, 0x3B09, 0x35AF, 0x3004, 0x2A10, 0x23DD, 0x1D74, 0x16DE,
        0x1025, 0x0954, 0x0275, 0xFB93, 0xF4B7, 0xEDEC, 0xE73C, 0xE0B2, 0xDA57, 0xD435, 0xCE55, 0xC8C1, 0xC380, 0xBE9A, 0xBA17, 0xB5FE,
        0xB255, 0xAF22, 0xAC69, 0xAA2E, 0xA875, 0xA740, 0xA692, 0xA66B, 0xA6CB, 0xA7B2, 0xA91F, 0xAB0F, 0xAD80, 0xB06D, 0xB3D3, 0xB7AC,
        0xBBF3, 0xC0A0, 0xC5AD, 0xCB12, 0xD0C8, 0xD6C5, 0xDD00, 0xE370, 0xEA0B, 0xF0C8, 0xF79B, 0xFE7C, 0x055D, 0x0C38, 0x12FF, 0x19AB,
        0x202F, 0x2683, 0x2C9C, 0x3272, 0x37FC, 0x3D31, 0x420A, 0x467E, 0x4A88, 0x4E21, 0x5145, 0x53ED, 0x5616, 0x57BD, 0x58E0, 0x597C,
        0x5990, 0x591D, 0x5824, 0x56A5, 0x54A3, 0x5221, 0x4F23, 0x4BAD, 0x47C5, 0x4370, 0x3EB5, 0x399C, 0x342B, 0x2E6B, 0x2865, 0x2222,
        0x1BAC, 0x150B, 0x0E4B, 0x0775, 0x0094, 0xF9B3, 0xF2DA, 0xEC16, 0xE56F, 0xDEF1, 0xD8A5, 0xD294, 0xCCC8, 0xC749, 0xC220, 0xBD55,
        0xB8EE, 0xB4F3, 0xB16A, 0xAE57, 0xABC0, 0xA9A8, 0xA813, 0xA703, 0xA67A, 0xA677, 0xA6FD, 0xA809, 0xA999, 0xABAD, 0xAE40, 0xB14F,
        0xB4D5, 0xB8CC, 0xBD2F, 0xC1F7, 0xC71D, 0xCC99, 0xD263, 0xD872, 0xDEBD, 0xE539, 0xEBDF, 0xF2A3, 0xF97B, 0x005C, 0x073D, 0x0E13,
        0x14D5, 0x1B76, 0x21EE, 0x2833, 0x2E3B, 0x33FD, 0x3970, 0x3E8D, 0x434B, 0x47A3, 0x4B8F, 0x4F09, 0x520B, 0x5490, 0x5697, 0x581A,
        0x5918, 0x598F, 0x597E, 0x58E7, 0x57C9, 0x5626, 0x5400, 0x515C, 0x4E3D, 0x4AA7, 0x46A1, 0x4230, 0x3D5A, 0x3828, 0x32A1, 0x2CCD,
        0x26B6, 0x2064, 0x19E1, 0x1336, 0x0C6F, 0x0595, 0xFEB4, 0xF7D3, 0xF0FF, 0xEA42, 0xE3A5, 0xDD34, 0xD6F7, 0xD0F8, 0xCB40, 0xC5D8,
        0xC0C8, 0xBC17, 0xB7CD, 0xB3F1, 0xB087, 0xAD96, 0xAB21, 0xA92D, 0xA7BC, 0xA6D0, 0xA66C, 0xA68E, 0xA739, 0xA869, 0xAA1E, 0xAC54,
        0xAF0A, 0xB239, 0xB5DF, 0xB9F4, 0xBE74, 0xC356, 0xC894, 0xCE26, 0xD404, 0xDA24, 0xE07D, 0xE706, 0xEDB5, 0xF47F, 0xFB5B, 0x023D,
        0x091C, 0x0FEE, 0x16A7, 0x1D3F, 0x23AA, 0x29DF, 0x2FD4, 0x3582, 0x3ADE, 0x3FE2, 0x4485, 0x48C0, 0x4C8D, 0x4FE7, 0x52C7, 0x552B,
        0x570D, 0x586C, 0x5945, 0x5998, 0x5962, 0x58A6, 0x5763, 0x559D, 0x5354, 0x508E, 0x4D4E, 0x4999, 0x4575, 0x40E8, 0x3BF8, 0x36AE,
        0x3111, 0x2B2A, 0x2502, 0x1EA1, 0x1813, 0x1160, 0x0A92, 0x03B5, 0xFCD3, 0xF5F5, 0xEF26, 0xE870, 0xE1DF, 0xDB7A, 0xD54D, 0xCF61,
        0xC9BE, 0xC46D, 0xBF76, 0xBAE1, 0xB6B5, 0xB2F7, 0xAFAE, 0xACDE, 0xAA8C, 0xA8BB, 0xA76E, 0xA6A7, 0xA668, 0xA6AF, 0xA77E, 0xA8D3,
        0xAAAC, 0xAD05, 0xAFDC, 0xB32D, 0xB6F1, 0xBB24, 0xBFBF, 0xC4BB, 0xCA11, 0xCFB9, 0xD5A9, 0xDBDA, 0xE241, 0xE8D5, 0xEF8D, 0xF65D,
        0xFD3C, 0x041D, 0x0AFA, 0x11C6, 0x1877, 0x1F04, 0x2561, 0x2B86, 0x3169, 0x3701, 0x3C46, 0x4130, 0x45B7, 0x49D5, 0x4D83, 0x50BC,
        0x537B, 0x55BB, 0x577A, 0x58B5, 0x5969, 0x5997, 0x593C, 0x585B, 0x56F4, 0x550A, 0x529F, 0x4FB7, 0x4C57, 0x4883, 0x4441, 0x3F98,
        0x3A8F, 0x352E, 0x2F7C, 0x2982, 0x2349, 0x1CDB, 0x1642, 0x0F87, 0x08B4, 0x01D4, 0xFAF2, 0xF417, 0xED4E, 0xE6A2, 0xE01B, 0xD9C5,
        0xD3A9, 0xCDCF, 0xC842, 0xC309, 0xBE2C, 0xB9B3, 0xB5A4, 0xB206, 0xAEDD, 0xAC2F, 0xAA00, 0xA853, 0xA72B, 0xA689, 0xA66E, 0xA6DB,
        0xA7CE, 0xA947, 0xAB43, 0xADBF, 0xB0B8, 0xB428, 0xB80C, 0xBC5C, 0xC112, 0xC628, 0xCB95, 0xD151, 0xD754, 0xDD94, 0xE409, 0xEAA7,
        0xF167, 0xF83C, 0xFF1D, 0x05FE, 0x0CD7, 0x139D, 0x1A45, 0x20C5, 0x2714, 0x2D28, 0x32F7, 0x3879, 0x3DA6, 0x4276, 0x46E1, 0x4AE1,
        0x4E70, 0x5188, 0x5425, 0x5642, 0x57DD, 0x58F3, 0x5983, 0x598B, 0x590C, 0x5806, 0x567B, 0x546E, 0x51E0, 0x4ED7, 0x4B56, 0x4764,
        0x4306, 0x3E42, 0x3920, 0x33A8, 0x2DE1, 0x27D5, 0x218D, 0x1B12, 0x146F, 0x0DAC, 0x06D5, 0xFFF4, 0xF912, 0xF23B, 0xEB79, 0xE4D6,
        0xDE5B, 0xD814, 0xD209, 0xCC44, 0xC6CD, 0xC1AC, 0xBCEA, 0xB88D, 0xB49C, 0xB11D, 0xAE16, 0xAB8A, 0xA97E, 0xA7F5, 0xA6F1, 0xA674,
        0xA67E, 0xA710, 0xA828, 0xA9C5, 0xABE4, 0xAE83, 0xB19C, 0xB52D, 0xB92E, 0xBD9B, 0xC26C, 0xC79A, 0xCD1E, 0xD2EE, 0xD903, 0xDF52,
        0xE5D3, 0xEC7C, 0xF342, 0xFA1B, 0x00FD, 0x07DD, 0x0EB2, 0x1571, 0x1C0F, 0x2283, 0x28C3, 0x2EC5, 0x3480, 0x39EC, 0x3F00, 0x43B5,
        0x4803, 0x4BE5, 0x4F54, 0x524B, 0x54C5, 0x56BF, 0x5836, 0x5928, 0x5993, 0x5976, 0x58D2, 0x57A8, 0x55F9, 0x53C8, 0x5118, 0x4DEE,
        0x4A4E, 0x463D, 0x41C3, 0x3CE4, 0x37AA, 0x321C, 0x2C41, 0x2624, 0x1FCD, 0x1946, 0x1299, 0x0BD0, 0x04F5, 0xFE13, 0xF733, 0xF061,
        0xE9A6, 0xE30D, 0xDC9F, 0xD668, 0xD06F, 0xCABE, 0xC55E, 0xC056, 0xBBAF, 0xB76F, 0xB39C, 0xB03D, 0xAD57, 0xAAEE, 0xA906, 0xA7A1,
        0xA6C1, 0xA669, 0xA698, 0xA74F, 0xA88B, 0xAA4C, 0xAC8F, 0xAF4F, 0xB28A, 0xB63A, 0xBA59, 0xBEE2, 0xC3CD, 0xC913, 0xCEAD, 0xD490,
        0xDAB6, 0xE114, 0xE7A1, 0xEE53, 0xF51F, 0xFBFC, 0x02DE, 0x09BC, 0x108C, 0x1743, 0x1DD7, 0x243D, 0x2A6D, 0x305C, 0x3603, 0x3B57,
        0x4052, 0x44EC, 0x491E, 0x4CE0, 0x502F, 0x5304, 0x555C, 0x5733, 0x5886, 0x5953, 0x5998, 0x5957, 0x588E, 0x573F, 0x556D, 0x5319,
        0x5047, 0x4CFC, 0x493D, 0x450F, 0x4078, 0x3B80, 0x362E, 0x308A, 0x2A9D, 0x246F, 0x1E0A, 0x1777, 0x10C1, 0x09F2, 0x0314, 0xFC32,
        0xF555, 0xEE88, 0xE7D5, 0xE147, 0xDAE7, 0xD4C0, 0xCEDA, 0xC93E, 0xC3F5, 0xBF07, 0xBA7B, 0xB658, 0xB2A5, 0xAF67, 0xACA2, 0xAA5C,
        0xA897, 0xA757, 0xA69C, 0xA669, 0xA6BD, 0xA798, 0xA8F9, 0xAADD, 0xAD42, 0xB025, 0xB380, 0xB74F, 0xBB8B, 0xC030, 0xC535, 0xCA92,
        0xD041, 0xD638, 0xDC6E, 0xE2D9, 0xE971, 0xF02B, 0xF6FD, 0xFDDD, 0x04BE, 0x0B9A, 0x1264, 0x1912, 0x1F9A, 0x25F3, 0x2C12, 0x31EF,
        0x3780, 0x3CBD, 0x419E, 0x461C, 0x4A2F, 0x4DD3, 0x5101, 0x53B5, 0x55E9, 0x579C, 0x58CB, 0x5973, 0x5994, 0x592D, 0x5840, 0x56CD,
        0x54D7, 0x5260, 0x4F6D, 0x4C02, 0x4824, 0x43D8, 0x3F26, 0x3A15, 0x34AC, 0x2EF3, 0x28F3, 0x22B5, 0x1C43, 0x15A6, 0x0EE8, 0x0814,
        0x0133, 0xFA52, 0xF378, 0xECB1, 0xE607, 0xDF85, 0xD934, 0xD31D, 0xCD4A, 0xC7C4, 0xC293, 0xBDBF, 0xB950, 0xB54B, 0xB1B7, 0xAE99,
        0xABF7, 0xA9D3, 0xA832, 0xA716, 0xA681, 0xA672, 0xA6EB, 0xA7EB, 0xA970, 0xAB78, 0xAE00, 0xB103, 0xB47F, 0xB86C, 0xBCC6, 0xC185,
        0xC6A3, 0xCC18, 0xD1DB, 0xD7E4, 0xDE29, 0xE4A2, 0xEB44, 0xF206, 0xF8DC, 0xFFBE, 0x069E, 0x0D76, 0x143A, 0x1ADF, 0x215B, 0x27A5,
        0x2DB2, 0x337B, 0x38F6, 0x3E1B, 0x42E2, 0x4743, 0x4B39, 0x4EBD, 0x51CA, 0x545B, 0x566D, 0x57FC, 0x5906, 0x5989, 0x5985, 0x58FA,
        0x57E8, 0x5651, 0x5437, 0x519E, 0x4E8A, 0x4AFF, 0x4702, 0x429A, 0x3DCE, 0x38A3, 0x3324, 0x2D57, 0x2745, 0x20F8, 0x1A79, 0x13D2,
        0x0D0D, 0x0634, 0xFF53, 0xF872, 0xF19C, 0xEADC, 0xE43C, 0xDDC6, 0xD784, 0xD17F, 0xCBC1, 0xC651, 0xC139, 0xBC7F, 0xB82C, 0xB445,
        0xB0D1, 0xADD5, 0xAB55, 0xA955, 0xA7D8, 0xA6E0, 0xA66F, 0xA686, 0xA724, 0xA848, 0xA9F1, 0xAC1C, 0xAEC6, 0xB1EB, 0xB586, 0xB991,
        0xBE08, 0xC2E1, 0xC818, 0xCDA3, 0xD37A, 0xD994, 0xDFE8, 0xE66D, 0xED19, 0xF3E1, 0xFABC, 0x019E, 0x087E, 0x0F51, 0x160D, 0x1CA8,
        0x2317, 0x2952, 0x2F4E, 0x3502, 0x3A66, 0x3F72, 0x441E, 0x4863, 0x4C3A, 0x4F9E, 0x528A, 0x54F9, 0x56E7, 0x5852, 0x5937, 0x5996,
        0x596D, 0x58BC, 0x5786, 0x55CB, 0x538E, 0x50D3, 0x4D9E, 0x49F3, 0x45D9, 0x4155, 0x3C6E, 0x372C, 0x3196, 0x2BB5, 0x2592, 0x1F36,
        0x18AC, 0x11FB, 0x0B30, 0x0454, 0xFD72, 0xF693, 0xEFC2, 0xE90A, 0xE274, 0xDC0C, 0xD5D9, 0xCFE7, 0xCA3D, 0xC4E4, 0xBFE5, 0xBB47,
        0xB711, 0xB349, 0xAFF5, 0xAD1A, 0xAABC, 0xA8E0, 0xA787, 0xA6B4, 0xA668, 0xA6A3, 0xA766, 0xA8AF, 0xAA7C, 0xACCA, 0xAF96, 0xB2DB,
        0xB695, 0xBABF, 0xBF51, 0xC445, 0xC993, 0xCF33, 0xD51E, 0xDB49, 0xE1AB, 0xE83C, 0xEEF1, 0xF5BF, 0xFC9D, 0x037F, 0x0A5C, 0x112A,
        0x17DE, 0x1E6E, 0x24D0, 0x2AFA, 0x30E4, 0x3683, 0x3BD0, 0x40C2, 0x4553, 0x497A, 0x4D33, 0x5076, 0x5340, 0x558D, 0x5757, 0x589E,
        0x595F, 0x5998, 0x594A, 0x5875, 0x571A, 0x553B, 0x52DC, 0x4FFF, 0x4CA9, 0x48E0, 0x44A8, 0x4008, 0x3B07, 0x35AD, 0x3002, 0x2A0F,
        0x23DB, 0x1D72, 0x16DC, 0x1023, 0x0952, 0x0273, 0xFB91, 0xF4B5, 0xEDEA, 0xE73A, 0xE0B0, 0xDA55, 0xD433, 0xCE54, 0xC8BF, 0xC37E,
        0xBE99, 0xBA16, 0xB5FD, 0xB254, 0xAF21, 0xAC68, 0xAA2D, 0xA874, 0xA740, 0xA692, 0xA66B, 0xA6CB, 0xA7B3, 0xA920, 0xAB10, 0xAD81,
        0xB06E, 0xB3D4, 0xB7AD, 0xBBF4, 0xC0A1, 0xC5AF, 0xCB14, 0xD0C9, 0xD6C6, 0xDD02, 0xE372, 0xEA0D, 0xF0CA, 0xF79D, 0xFE7E, 0x055F,
        0x0C3A, 0x1301, 0x19AD, 0x2031, 0x2685, 0x2C9E, 0x3274, 0x37FE, 0x3D33, 0x420B, 0x467F, 0x4A89, 0x4E22, 0x5145, 0x53EE, 0x5617,
        0x57BE, 0x58E0, 0x597C, 0x5990, 0x591D, 0x5823, 0x56A4, 0x54A2, 0x5220, 0x4F22, 0x4BAC, 0x47C4, 0x436F, 0x3EB4, 0x399A, 0x3429,
        0x2E69, 0x2863, 0x2220, 0x1BAA, 0x1509, 0x0E49, 0x0773, 0x0092, 0xF9B1, 0xF2D8, 0xEC14, 0xE56D, 0xDEEF, 0xD8A3, 0xD292, 0xCCC6,
        0xC747, 0xC21F, 0xBD53, 0xB8ED, 0xB4F2, 0xB169, 0xAE56, 0xABBF, 0xA9A8, 0xA813, 0xA703, 0xA67A, 0xA678, 0xA6FD, 0xA809, 0xA99A,
        0xABAE, 0xAE41, 0xB150, 0xB4D6, 0xB8CD, 0xBD31, 0xC1F9, 0xC71F, 0xCC9B, 0xD265, 0xD874, 0xDEBE, 0xE53B, 0xEBE1, 0xF2A5, 0xF97D,
        0x005E, 0x073F, 0x0E15, 0x14D7, 0x1B78, 0x21F0, 0x2835, 0x2E3D, 0x33FF, 0x3972, 0x3E8E, 0x434C, 0x47A4, 0x4B90, 0x4F09, 0x520B,
        0x5491, 0x5697, 0x581A, 0x5918, 0x598F, 0x597E, 0x58E6, 0x57C8, 0x5625, 0x5400, 0x515B, 0x4E3C, 0x4AA6, 0x46A0, 0x422E, 0x3D59,
        0x3826, 0x329F, 0x2CCB, 0x26B4, 0x2062, 0x19DF, 0x1334, 0x0C6D, 0x0593, 0xFEB2, 0xF7D1, 0xF0FD, 0xEA40, 0xE3A3, 0xDD32, 0xD6F5,
        0xD0F6, 0xCB3E, 0xC5D6, 0xC0C6, 0xBC16, 0xB7CC, 0xB3F0, 0xB086, 0xAD95, 0xAB21, 0xA92C, 0xA7BB, 0xA6D0, 0xA66C, 0xA68F, 0xA739,
        0xA869, 0xAA1E, 0xAC55, 0xAF0B, 0xB23A, 0xB5E0, 0xB9F5, 0xBE75, 0xC358, 0xC896, 0xCE28, 0xD406, 0xDA26, 0xE07F, 0xE708, 0xEDB7,
        0xF481, 0xFB5D, 0x023F, 0x091E, 0x0FF0, 0x16A9, 0x1D40, 0x23AB, 0x29E0, 0x2FD6, 0x3584, 0x3AE0, 0x3FE3, 0x4486, 0x48C1, 0x4C8E,
        0x4FE8, 0x52C8, 0x552B, 0x570E, 0x586D, 0x5946, 0x5998, 0x5962, 0x58A6, 0x5763, 0x559C, 0x5354, 0x508D, 0x4D4D, 0x4998, 0x4574,
        0x40E6, 0x3BF7, 0x36AC, 0x310F, 0x2B28, 0x2500, 0x1E9F, 0x1811, 0x115E, 0x0A90, 0x03B3, 0xFCD1, 0xF5F3, 0xEF24, 0xE86E, 0xE1DD,
        0xDB78, 0xD54B, 0xCF5F, 0xC9BC, 0xC46C, 0xBF75, 0xBAE0, 0xB6B3, 0xB2F6, 0xAFAD, 0xACDD, 0xAA8B, 0xA8BB, 0xA76E, 0xA6A7, 0xA668,
        0xA6B0, 0xA77F, 0xA8D3, 0xAAAC, 0xAD06, 0xAFDD, 0xB32E, 0xB6F2, 0xBB25, 0xBFC1, 0xC4BD, 0xCA13, 0xCFBB, 0xD5AB, 0xDBDC, 0xE243,
        0xE8D7, 0xEF8F, 0xF65F, 0xFD3E, 0x0420, 0x0AFC, 0x11C8, 0x1879, 0x1F06, 0x2563, 0x2B87, 0x316A, 0x3702, 0x3C47, 0x4131, 0x45B8,
        0x49D6, 0x4D84, 0x50BD, 0x537B, 0x55BC, 0x577B, 0x58B5, 0x5969, 0x5997, 0x593C, 0x585B, 0x56F4, 0x5509, 0x529E, 0x4FB6, 0x4C56,
        0x4881, 0x4440, 0x3F97, 0x3A8E, 0x352C, 0x2F7A, 0x2980, 0x2348, 0x1CDA, 0x1640, 0x0F85, 0x08B2, 0x01D2, 0xFAF0, 0xF415, 0xED4C,
        0xE6A0, 0xE019, 0xD9C3, 0xD3A7, 0xCDCE, 0xC841, 0xC308, 0xBE2B, 0xB9B2, 0xB5A3, 0xB205, 0xAEDC, 0xAC2E, 0xAA00, 0xA853, 0xA72A,
        0xA688, 0xA66E, 0xA6DB, 0xA7CE, 0xA947, 0xAB44, 0xADC0, 0xB0B9, 0xB429, 0xB80D, 0xBC5D, 0xC113, 0xC629, 0xCB96, 0xD153, 0xD756,
        0xDD96, 0xE40B, 0xEAA9, 0xF169, 0xF83E, 0xFF1F, 0x0600, 0x0CD9, 0x139F, 0x1A47, 0x20C7, 0x2716, 0x2D29, 0x32F9, 0x387B, 0x3DA8,
        0x4277, 0x46E2, 0x4AE2, 0x4E71, 0x5189, 0x5425, 0x5643, 0x57DE, 0x58F4, 0x5983, 0x598B, 0x590C, 0x5806, 0x567B, 0x546D, 0x51DF,
        0x4ED6, 0x4B55, 0x4763, 0x4304, 0x3E40, 0x391E, 0x33A6, 0x2DDF, 0x27D3, 0x218B, 0x1B10, 0x146D, 0x0DAA, 0x06D3, 0xFFF2, 0xF910,
        0xF239, 0xEB77, 0xE4D4, 0xDE5A, 0xD812, 0xD207, 0xCC42, 0xC6CB, 0xC1AB, 0xBCE8, 0xB88C, 0xB49B, 0xB11C, 0xAE15, 0xAB89, 0xA97D,
        0xA7F5, 0xA6F1, 0xA674, 0xA67E, 0xA710, 0xA828, 0xA9C5, 0xABE5, 0xAE83, 0xB19D, 0xB52E, 0xB930, 0xBD9C, 0xC26D, 0xC79C, 0xCD1F,
        0xD2F0, 0xD905, 0xDF54, 0xE5D5, 0xEC7E, 0xF344, 0xFA1D, 0x00FF, 0x07DF, 0x0EB4, 0x1573, 0x1C11, 0x2285, 0x28C4, 0x2EC6, 0x3482,
        0x39ED, 0x3F01, 0x43B6, 0x4805, 0x4BE6, 0x4F55, 0x524C, 0x54C6, 0x56C0, 0x5837, 0x5928, 0x5993, 0x5976, 0x58D2, 0x57A7, 0x55F8,
        0x53C7, 0x5117, 0x4DED, 0x4A4D, 0x463C, 0x41C1, 0x3CE3, 0x37A8, 0x321A, 0x2C40, 0x2622, 0x1FCB, 0x1944, 0x1297, 0x0BCE, 0x04F2,
        0xFE11, 0xF731, 0xF05F, 0xE9A4, 0xE30B, 0xDC9E, 0xD666, 0xD06D, 0xCABC, 0xC55C, 0xC055, 0xBBAD, 0xB76D, 0xB39B, 0xB03D, 0xAD56,
        0xAAEE, 0xA905, 0xA7A0, 0xA6C1, 0xA669, 0xA698, 0xA74F, 0xA88C, 0xAA4D, 0xAC8F, 0xAF50, 0xB28B, 0xB63B, 0xBA5A, 0xBEE3, 0xC3CE,
        0xC915, 0xCEAE, 0xD492, 0xDAB8, 0xE116, 0xE7A3, 0xEE55, 0xF521, 0xFBFE, 0x02E0, 0x09BE, 0x108E, 0x1745, 0x1DD8, 0x243F, 0x2A6F,
        0x305E, 0x3604, 0x3B59, 0x4054, 0x44ED, 0x491F, 0x4CE1, 0x5030, 0x5305, 0x555D, 0x5733, 0x5886, 0x5953, 0x5998, 0x5957, 0x588E,
        0x573F, 0x556C, 0x5318, 0x5046, 0x4CFB, 0x493C, 0x450D, 0x4077, 0x3B7F, 0x362C, 0x3088, 0x2A9B, 0x246D, 0x1E08, 0x1775, 0x10BF,
        0x09F0, 0x0312, 0xFC30, 0xF553, 0xEE86, 0xE7D3, 0xE145, 0xDAE6, 0xD4BE, 0xCED8, 0xC93C, 0xC3F4, 0xBF06, 0xBA7A, 0xB657, 0xB2A4,
        0xAF66, 0xACA2, 0xAA5B, 0xA897, 0xA756, 0xA69C, 0xA669, 0xA6BD, 0xA798, 0xA8F9, 0xAADE, 0xAD43, 0xB026, 0xB381, 0xB750, 0xBB8D,
        0xC031, 0xC536, 0xCA94, 0xD043, 0xD639, 0xDC6F, 0xE2DB, 0xE973, 0xF02D, 0xF6FF, 0xFDDF, 0x04C0, 0x0B9C, 0x1266, 0x1914, 0x1F9C,
        0x25F5, 0x2C14, 0x31F0, 0x3781, 0x3CBE, 0x419F, 0x461D, 0x4A31, 0x4DD4, 0x5102, 0x53B5, 0x55EA, 0x579D, 0x58CB, 0x5973, 0x5994,
        0x592D, 0x583F, 0x56CC, 0x54D6, 0x525F, 0x4F6C, 0x4C01, 0x4822, 0x43D7, 0x3F25, 0x3A13, 0x34AA, 0x2EF1, 0x28F1, 0x22B3, 0x1C41,
        0x15A4, 0x0EE6, 0x0811, 0x0131, 0xFA50, 0xF376, 0xECAF, 0xE605, 0xDF83, 0xD932, 0xD31B, 0xCD49, 0xC7C3, 0xC292, 0xBDBE, 0xB94E,
        0xB54A, 0xB1B6, 0xAE98, 0xABF6, 0xA9D3, 0xA832, 0xA716, 0xA680, 0xA672, 0xA6EB, 0xA7EB, 0xA970, 0xAB79, 0xAE00, 0xB104, 0xB480,
        0xB86D, 0xBCC7, 0xC187, 0xC6A4, 0xCC19, 0xD1DC, 0xD7E5, 0xDE2B, 0xE4A4, 0xEB46, 0xF208, 0xF8DE, 0xFFC0, 0x06A0, 0x0D78, 0x143C,
        0x1AE1, 0x215D, 0x27A6, 0x2DB4, 0x337D, 0x38F8, 0x3E1C, 0x42E3, 0x4744, 0x4B3A, 0x4EBE, 0x51CB, 0x545C, 0x566E, 0x57FD, 0x5906,
        0x598A, 0x5985, 0x58FA, 0x57E7, 0x5650, 0x5437, 0x519D, 0x4E89, 0x4AFE, 0x4701, 0x4299, 0x3DCC, 0x38A2, 0x3322, 0x2D55, 0x2743,
        0x20F6, 0x1A77, 0x13D0, 0x0D0B, 0x0632, 0xFF51, 0xF870, 0xF19A, 0xEADA, 0xE43A, 0xDDC4, 0xD782, 0xD17E, 0xCBBF, 0xC650, 0xC137,
        0xBC7E, 0xB82B, 0xB444, 0xB0D0, 0xADD4, 0xAB54, 0xA954, 0xA7D7, 0xA6E0, 0xA66F, 0xA686, 0xA724, 0xA848, 0xA9F1, 0xAC1D, 0xAEC7,
        0xB1EC, 0xB587, 0xB993, 0xBE09, 0xC2E3, 0xC819, 0xCDA4, 0xD37B, 0xD996, 0xDFEA, 0xE66F, 0xED1B, 0xF3E4, 0xFABE, 0x01A0, 0x0880,
        0x0F53, 0x160F, 0x1CAA, 0x2319, 0x2954, 0x2F4F, 0x3504, 0x3A68, 0x3F73, 0x441F, 0x4864, 0x4C3B, 0x4F9F, 0x528B, 0x54F9, 0x56E8,
        0x5852, 0x5938, 0x5996, 0x596D, 0x58BC, 0x5785, 0x55CA, 0x538E, 0x50D2, 0x4D9D, 0x49F2, 0x45D8, 0x4153, 0x3C6C, 0x372A, 0x3194,
        0x2BB3, 0x2590, 0x1F35, 0x18AA, 0x11F9, 0x0B2E, 0x0452, 0xFD70, 0xF691, 0xEFC0, 0xE908, 0xE273, 0xDC0A, 0xD5D8, 0xCFE5, 0xCA3B,
        0xC4E3, 0xBFE4, 0xBB45, 0xB70F, 0xB347, 0xAFF4, 0xAD19, 0xAABC, 0xA8DF, 0xA786, 0xA6B4, 0xA668, 0xA6A4, 0xA766, 0xA8AF, 0xAA7C,
        0xACCA, 0xAF97, 0xB2DC, 0xB697, 0xBAC0, 0xBF52, 0xC446, 0xC994, 0xCF35, 0xD51F, 0xDB4B, 0xE1AD, 0xE83E, 0xEEF3, 0xF5C1, 0xFC9F,
        0x0381, 0x0A5E, 0x112C, 0x17E0, 0x1E70, 0x24D2, 0x2AFC, 0x30E5, 0x3685, 0x3BD1, 0x40C4, 0x4554, 0x497B, 0x4D34, 0x5077, 0x5341,
        0x558D, 0x5758, 0x589E, 0x595F, 0x5998, 0x594A, 0x5875, 0x571A, 0x553B, 0x52DB, 0x4FFE, 0x4CA8, 0x48DE, 0x44A6, 0x4006, 0x3B06,
        0x35AC, 0x3001, 0x2A0D, 0x23D9, 0x1D70, 0x16DA, 0x1021, 0x0950, 0x0271, 0xFB8F, 0xF4B3, 0xEDE8, 0xE738, 0xE0AE, 0xDA53, 0xD431,
        0xCE52, 0xC8BD, 0xC37D, 0xBE97, 0xBA15, 0xB5FC, 0xB253, 0xAF20, 0xAC67, 0xAA2D, 0xA874, 0xA740, 0xA692, 0xA66B, 0xA6CB, 0xA7B3,
        0xA920, 0xAB11, 0xAD82, 0xB06F, 0xB3D5, 0xB7AF, 0xBBF5, 0xC0A3, 0xC5B0, 0xCB16, 0xD0CB, 0xD6C8, 0xDD03, 0xE374, 0xEA0F, 0xF0CC,
        0xF79F, 0xFE80, 0x0561, 0x0C3C, 0x1303, 0x19AF, 0x2033, 0x2686, 0x2CA0, 0x3276, 0x37FF, 0x3D34, 0x420C, 0x4681, 0x4A8A, 0x4E23,
        0x5146, 0x53EE, 0x5617, 0x57BE, 0x58E0, 0x597C, 0x5990, 0x591D, 0x5823, 0x56A4, 0x54A2, 0x521F, 0x4F21, 0x4BAB, 0x47C2, 0x436D,
        0x3EB2, 0x3998, 0x3428, 0x2E68, 0x2862, 0x221F, 0x1BA8, 0x1507, 0x0E47, 0x0771, 0x0090, 0xF9AF, 0xF2D6, 0xEC12, 0xE56B, 0xDEED,
        0xD8A1, 0xD290, 0xCCC4, 0xC746, 0xC21D, 0xBD52, 0xB8EC, 0xB4F1, 0xB168, 0xAE56, 0xABBF, 0xA9A7, 0xA813, 0xA703, 0xA679, 0xA678,
        0xA6FD, 0xA809, 0xA99B, 0xABAE, 0xAE42, 0xB151, 0xB4D7, 0xB8CF, 0xBD32, 0xC1FA, 0xC721, 0xCC9D, 0xD267, 0xD876, 0xDEC0, 0xE53D,
        0xEBE3, 0xF2A7, 0xF97F, 0x0060, 0x0741, 0x0E17, 0x14D8, 0x1B7A, 0x21F2, 0x2837, 0x2E3E, 0x3400, 0x3974, 0x3E90, 0x434E, 0x47A6,
        0x4B91, 0x4F0A, 0x520C, 0x5492, 0x5698, 0x581A, 0x5918, 0x598F, 0x597E, 0x58E6, 0x57C8, 0x5625, 0x53FF, 0x515B, 0x4E3B, 0x4AA5,
        0x469E, 0x422D, 0x3D57, 0x3825, 0x329D, 0x2CCA, 0x26B2, 0x2060, 0x19DD, 0x1333, 0x0C6B, 0x0591, 0xFEB0, 0xF7CF, 0xF0FB, 0xEA3E,
        0xE3A1, 0xDD30, 0xD6F3, 0xD0F4, 0xCB3D, 0xC5D5, 0xC0C5, 0xBC15, 0xB7CB, 0xB3EF, 0xB085, 0xAD94, 0xAB20, 0xA92C, 0xA7BB, 0xA6D0,
        0xA66C, 0xA68F, 0xA739, 0xA86A, 0xAA1F, 0xAC56, 0xAF0B, 0xB23B, 0xB5E1, 0xB9F7, 0xBE76, 0xC359, 0xC897, 0xCE2A, 0xD407, 0xDA28,
        0xE081, 0xE70A, 0xEDB9, 0xF483, 0xFB5F, 0x0241, 0x0920, 0x0FF2, 0x16AB, 0x1D42, 0x23AD, 0x29E2, 0x2FD8, 0x3585, 0x3AE1, 0x3FE5,
        0x4487, 0x48C2, 0x4C8F, 0x4FE9, 0x52C9, 0x552C, 0x570E, 0x586D, 0x5946, 0x5998, 0x5962, 0x58A5, 0x5762, 0x559B, 0x5353, 0x508C,
        0x4D4C, 0x4997, 0x4572, 0x40E5, 0x3BF5, 0x36AB, 0x310E, 0x2B26, 0x24FE, 0x1E9D, 0x180F, 0x115C, 0x0A8E, 0x03B1, 0xFCCF, 0xF5F1,
        0xEF22, 0xE86C, 0xE1DB, 0xDB77, 0xD54A, 0xCF5D, 0xC9BB, 0xC46A, 0xBF74, 0xBADF, 0xB6B2, 0xB2F5, 0xAFAC, 0xACDC, 0xAA8B, 0xA8BA,
        0xA76E, 0xA6A7, 0xA668, 0xA6B0, 0xA77F, 0xA8D4, 0xAAAD, 0xAD07, 0xAFDE, 0xB32F, 0xB6F3, 0xBB27, 0xBFC2, 0xC4BF, 0xCA15, 0xCFBC,
        0xD5AD, 0xDBDE, 0xE245, 0xE8D9, 0xEF91, 0xF661, 0xFD40, 0x0422, 0x0AFE, 0x11CA, 0x187B, 0x1F07, 0x2565, 0x2B89, 0x316C, 0x3704,
        0x3C49, 0x4132, 0x45B9, 0x49D7, 0x4D85, 0x50BE, 0x537C, 0x55BC, 0x577B, 0x58B5, 0x596A, 0x5996, 0x593C, 0x585A, 0x56F3, 0x5509,
        0x529D, 0x4FB5, 0x4C54, 0x4880, 0x443E, 0x3F95, 0x3A8C, 0x352A, 0x2F78, 0x297E, 0x2346, 0x1CD8, 0x163E, 0x0F83, 0x08B0, 0x01D0,
        0xFAEE, 0xF413, 0xED4A, 0xE69E, 0xE017, 0xD9C1, 0xD3A5, 0xCDCC, 0xC83F, 0xC306, 0xBE2A, 0xB9B0, 0xB5A2, 0xB204, 0xAEDB, 0xAC2E,
        0xA9FF, 0xA852, 0xA72A, 0xA688, 0xA66E, 0xA6DB, 0xA7CF, 0xA948, 0xAB44, 0xADC1, 0xB0BA, 0xB42B, 0xB80E, 0xBC5E, 0xC115, 0xC62B,
        0xCB98, 0xD154, 0xD757, 0xDD98, 0xE40D, 0xEAAB, 0xF16B, 0xF840, 0xFF21, 0x0602, 0x0CDB, 0x13A1, 0x1A49, 0x20C9, 0x2718, 0x2D2B,
        0x32FA, 0x387D, 0x3DA9, 0x4279, 0x46E4, 0x4AE3, 0x4E72, 0x518A, 0x5426, 0x5643, 0x57DE, 0x58F4, 0x5983, 0x598B, 0x590C, 0x5806,
        0x567A, 0x546C, 0x51DF, 0x4ED5, 0x4B54, 0x4762, 0x4303, 0x3E3F, 0x391D, 0x33A4, 0x2DDE, 0x27D2, 0x2189, 0x1B0E, 0x146B, 0x0DA8,
        0x06D1, 0xFFF0, 0xF90E, 0xF237, 0xEB75, 0xE4D2, 0xDE58, 0xD810, 0xD206, 0xCC40, 0xC6CA, 0xC1A9, 0xBCE7, 0xB88A, 0xB49A, 0xB11B,
        0xAE14, 0xAB89, 0xA97D, 0xA7F4, 0xA6F1, 0xA674, 0xA67E, 0xA710, 0xA829, 0xA9C6, 0xABE5, 0xAE84, 0xB19E, 0xB52F, 0xB931, 0xBD9E,
        0xC26F, 0xC79D, 0xCD21, 0xD2F2, 0xD906, 0xDF56, 0xE5D7, 0xEC80, 0xF346, 0xFA1F, 0x0101, 0x07E2, 0x0EB6, 0x1575, 0x1C13, 0x2287,
        0x28C6, 0x2EC8, 0x3483, 0x39EF, 0x3F03, 0x43B8, 0x4806, 0x4BE7, 0x4F56, 0x524C, 0x54C6, 0x56C0, 0x5837, 0x5928, 0x5993, 0x5976,
        0x58D2, 0x57A7, 0x55F8, 0x53C6, 0x5117, 0x4DEC, 0x4A4C, 0x463B, 0x41C0, 0x3CE1, 0x37A7, 0x3218, 0x2C3E, 0x2620, 0x1FC9, 0x1942,
        0x1295, 0x0BCC, 0x04F0, 0xFE0F, 0xF72F, 0xF05D, 0xE9A2, 0xE309, 0xDC9C, 0xD664, 0xD06B, 0xCABB, 0xC55B, 0xC053, 0xBBAC, 0xB76C,
        0xB39A, 0xB03C, 0xAD56, 0xAAED, 0xA905, 0xA7A0, 0xA6C1, 0xA669, 0xA699, 0xA74F, 0xA88C, 0xAA4D, 0xAC90, 0xAF51, 0xB28C, 0xB63C,
        0xBA5C, 0xBEE5, 0xC3D0, 0xC916, 0xCEB0, 0xD494, 0xDABA, 0xE118, 0xE7A5, 0xEE57, 0xF523, 0xFC00, 0x02E2, 0x09C0, 0x1090, 0x1747,
        0x1DDA, 0x2441, 0x2A70, 0x3060, 0x3606, 0x3B5B, 0x4055, 0x44EF, 0x4920, 0x4CE3, 0x5031, 0x5306, 0x555D, 0x5734, 0x5886, 0x5953,
        0x5998, 0x5956, 0x588D, 0x573E, 0x556B, 0x5317, 0x5045, 0x4CFA, 0x493B, 0x450C, 0x4075, 0x3B7D, 0x362B, 0x3087, 0x2A99, 0x246B,
        0x1E06, 0x1773, 0x10BD, 0x09EE, 0x0310, 0xFC2E, 0xF551, 0xEE84, 0xE7D1, 0xE143, 0xDAE4, 0xD4BC, 0xCED6, 0xC93B, 0xC3F2, 0xBF04,
        0xBA79, 0xB656, 0xB2A3, 0xAF65, 0xACA1, 0xAA5B, 0xA896, 0xA756, 0xA69C, 0xA669, 0xA6BD, 0xA799, 0xA8FA, 0xAADE, 0xAD44, 0xB027,
        0xB382, 0xB751, 0xBB8E, 0xC033, 0xC538, 0xCA96, 0xD044, 0xD63B, 0xDC71, 0xE2DD, 0xE975, 0xF02F, 0xF701, 0xFDE1, 0x04C2, 0x0B9E,
        0x1268, 0x1916, 0x1F9E, 0x25F7, 0x2C16, 0x31F2, 0x3783, 0x3CC0, 0x41A0, 0x461E, 0x4A32, 0x4DD5, 0x5103, 0x53B6, 0x55EB, 0x579D,
        0x58CB, 0x5973, 0x5994, 0x592D, 0x583F, 0x56CC, 0x54D5, 0x525F, 0x4F6B, 0x4C00, 0x4821, 0x43D6, 0x3F24, 0x3A12, 0x34A8, 0x2EEF,
        0x28EF, 0x22B1, 0x1C3F, 0x15A2, 0x0EE4, 0x080F, 0x012F, 0xFA4D, 0xF374, 0xECAD, 0xE603, 0xDF81, 0xD930, 0xD31A, 0xCD47, 0xC7C1,
        0xC291, 0xBDBD, 0xB94D, 0xB548, 0xB1B5, 0xAE98, 0xABF5, 0xA9D2, 0xA832, 0xA716, 0xA680, 0xA672, 0xA6EC, 0xA7EC, 0xA971, 0xAB79,
        0xAE01, 0xB105, 0xB481, 0xB86E, 0xBCC8, 0xC188, 0xC6A6, 0xCC1B, 0xD1DE, 0xD7E7, 0xDE2D, 0xE4A6, 0xEB48, 0xF20A, 0xF8E0, 0xFFC2,
        0x06A3, 0x0D7A, 0x143E, 0x1AE3, 0x215F, 0x27A8, 0x2DB6, 0x337F, 0x38F9, 0x3E1E, 0x42E4, 0x4746, 0x4B3B, 0x4EBF, 0x51CC, 0x545D,
        0x566E, 0x57FD, 0x5907, 0x598A, 0x5985, 0x58F9, 0x57E7, 0x5650, 0x5436, 0x519D, 0x4E88, 0x4AFD, 0x4700, 0x4298, 0x3DCB, 0x38A0,
        0x3320, 0x2D53, 0x2741, 0x20F4, 0x1A75, 0x13CE, 0x0D09, 0x0630, 0xFF4F, 0xF86E, 0xF198, 0xEAD8, 0xE438, 0xDDC3, 0xD781, 0xD17C,
        0xCBBD, 0xC64E, 0xC136, 0xBC7D, 0xB82A, 0xB443, 0xB0CF, 0xADD3, 0xAB53, 0xA954, 0xA7D7, 0xA6E0, 0xA66F, 0xA686, 0xA724, 0xA849,
        0xA9F2, 0xAC1D, 0xAEC8, 0xB1ED, 0xB588, 0xB994, 0xBE0A, 0xC2E4, 0xC81B, 0xCDA6, 0xD37D, 0xD998, 0xDFEC, 0xE671, 0xED1D, 0xF3E6,
        0xFAC0, 0x01A2, 0x0882, 0x0F55, 0x1611, 0x1CAC, 0x231B, 0x2955, 0x2F51, 0x3505, 0x3A69, 0x3F75, 0x4421, 0x4865, 0x4C3C, 0x4FA0,
        0x528C, 0x54FA, 0x56E8, 0x5853, 0x5938, 0x5996, 0x596C, 0x58BC, 0x5785, 0x55CA, 0x538D, 0x50D2, 0x4D9C, 0x49F1, 0x45D6, 0x4152,
        0x3C6B, 0x3728, 0x3192, 0x2BB1, 0x258E, 0x1F33, 0x18A8, 0x11F7, 0x0B2C, 0x0450, 0xFD6E, 0xF68F, 0xEFBE, 0xE906, 0xE271, 0xDC08,
        0xD5D6, 0xCFE3, 0xCA3A, 0xC4E1, 0xBFE2, 0xBB44, 0xB70E, 0xB346, 0xAFF3, 0xAD18, 0xAABB, 0xA8DF, 0xA786, 0xA6B3, 0xA668, 0xA6A4,
        0xA767, 0xA8B0, 0xAA7D, 0xACCB, 0xAF97, 0xB2DD, 0xB698, 0xBAC1, 0xBF54, 0xC448, 0xC996, 0xCF37, 0xD521, 0xDB4C, 0xE1AF, 0xE840,
        0xEEF5, 0xF5C3, 0xFCA1, 0x0383, 0x0A60, 0x112E, 0x17E2, 0x1E72, 0x24D4, 0x2AFE, 0x30E7, 0x3686, 0x3BD3, 0x40C5, 0x4555, 0x497D,
        0x4D35, 0x5078, 0x5342, 0x558E, 0x5758, 0x589F, 0x595F, 0x5998, 0x594A, 0x5874, 0x5719, 0x553A, 0x52DA, 0x4FFD, 0x4CA7, 0x48DD,
        0x44A5, 0x4005, 0x3B04, 0x35AA, 0x2FFF, 0x2A0B, 0x23D8, 0x1D6E, 0x16D8, 0x101F, 0x094E, 0x026F, 0xFB8D, 0xF4B1, 0xEDE6, 0xE736,
        0xE0AC, 0xDA51, 0xD430, 0xCE50, 0xC8BC, 0xC37B, 0xBE96, 0xBA13, 0xB5FB, 0xB252, 0xAF1F, 0xAC66, 0xAA2C, 0xA873, 0xA73F, 0xA691,
        0xA66B, 0xA6CC, 0xA7B3, 0xA921, 0xAB11, 0xAD82, 0xB070, 0xB3D6, 0xB7B0, 0xBBF6, 0xC0A4, 0xC5B2, 0xCB17, 0xD0CD, 0xD6CA, 0xDD05,
        0xE376, 0xEA11, 0xF0CE, 0xF7A1, 0xFE82, 0x0563, 0x0C3E, 0x1305, 0x19B1, 0x2035, 0x2688, 0x2CA2, 0x3277, 0x3801, 0x3D36, 0x420E,
        0x4682, 0x4A8C, 0x4E24, 0x5147, 0x53EF, 0x5618, 0x57BE, 0x58E0, 0x597C, 0x5990, 0x591D, 0x5823, 0x56A3, 0x54A1, 0x521F, 0x4F20,
        0x4BAA, 0x47C1, 0x436C, 0x3EB1, 0x3997, 0x3426, 0x2E66, 0x2860, 0x221D, 0x1BA6, 0x1505, 0x0E45, 0x076F, 0x008E, 0xF9AD, 0xF2D4,
        0xEC10, 0xE569, 0xDEEB, 0xD89F, 0xD28E, 0xCCC3, 0xC744, 0xC21C, 0xBD51, 0xB8EB, 0xB4F0, 0xB167, 0xAE55, 0xABBE, 0xA9A7, 0xA812,
        0xA702, 0xA679, 0xA678, 0xA6FD, 0xA80A, 0xA99B, 0xABAF, 0xAE43, 0xB152, 0xB4D8, 0xB8D0, 0xBD33, 0xC1FC, 0xC722, 0xCC9E, 0xD268,
        0xD877, 0xDEC2, 0xE53F, 0xEBE5, 0xF2A9, 0xF981, 0x0062, 0x0743, 0x0E19, 0x14DA, 0x1B7C, 0x21F4, 0x2838, 0x2E40, 0x3402, 0x3975,
        0x3E91, 0x434F, 0x47A7, 0x4B92, 0x4F0B, 0x520D, 0x5493, 0x5698, 0x581B, 0x5918, 0x598F, 0x597E, 0x58E6, 0x57C7, 0x5624, 0x53FE,
        0x515A, 0x4E3A, 0x4AA4, 0x469D, 0x422B, 0x3D56, 0x3823, 0x329C, 0x2CC8, 0x26B0, 0x205E, 0x19DB, 0x1331, 0x0C69, 0x058F, 0xFEAE,
        0xF7CD, 0xF0F9, 0xEA3C, 0xE39F, 0xDD2E, 0xD6F1, 0xD0F2, 0xCB3B, 0xC5D3, 0xC0C3, 0xBC13, 0xB7CA, 0xB3EE, 0xB084, 0xAD94, 0xAB1F,
        0xA92B, 0xA7BB, 0xA6D0, 0xA66B, 0xA68F, 0xA739, 0xA86A, 0xAA1F, 0xAC57, 0xAF0C, 0xB23C, 0xB5E2, 0xB9F8, 0xBE78, 0xC35B, 0xC899,
        0xCE2B, 0xD409, 0xDA29, 0xE083, 0xE70C, 0xEDBB, 0xF485, 0xFB61, 0x0243, 0x0922, 0x0FF4, 0x16AD, 0x1D44, 0x23AF, 0x29E4, 0x2FDA,
        0x3587, 0x3AE3, 0x3FE6, 0x4489, 0x48C4, 0x4C90, 0x4FE9, 0x52CA, 0x552D, 0x570F, 0x586D, 0x5946, 0x5998, 0x5962, 0x58A5, 0x5762,
        0x559B, 0x5352, 0x508C, 0x4D4B, 0x4996, 0x4571, 0x40E3, 0x3BF4, 0x36A9, 0x310C, 0x2B25, 0x24FC, 0x1E9C, 0x180D, 0x115A, 0x0A8C,
        0x03AF, 0xFCCD, 0xF5EF, 0xEF20, 0xE86A, 0xE1D9, 0xDB75, 0xD548, 0xCF5C, 0xC9B9, 0xC469, 0xBF72, 0xBADD, 0xB6B1, 0xB2F4, 0xAFAB,
        0xACDC, 0xAA8A, 0xA8BA, 0xA76D, 0xA6A7, 0xA668, 0xA6B0, 0xA77F, 0xA8D4, 0xAAAD, 0xAD07, 0xAFDF, 0xB330, 0xB6F5, 0xBB28, 0xBFC3,
        0xC4C0, 0xCA16, 0xCFBE, 0xD5AF, 0xDBE0, 0xE247, 0xE8DB, 0xEF93, 0xF663, 0xFD42, 0x0424, 0x0B00, 0x11CC, 0x187D, 0x1F09, 0x2566,
        0x2B8B, 0x316E, 0x3706, 0x3C4A, 0x4134, 0x45BB, 0x49D8, 0x4D86, 0x50BE, 0x537D, 0x55BD, 0x577B, 0x58B6, 0x596A, 0x5996, 0x593C,
        0x585A, 0x56F3, 0x5508, 0x529D, 0x4FB4, 0x4C53, 0x487F, 0x443D, 0x3F94, 0x3A8B, 0x3529, 0x2F77, 0x297D, 0x2344, 0x1CD6, 0x163C,
        0x0F81, 0x08AE, 0x01CE, 0xFAEC, 0xF411, 0xED48, 0xE69C, 0xE015, 0xD9C0, 0xD3A3, 0xCDCA, 0xC83D, 0xC305, 0xBE28, 0xB9AF, 0xB5A1,
        0xB203, 0xAEDA, 0xAC2D, 0xA9FE, 0xA852, 0xA72A, 0xA688, 0xA66E, 0xA6DB, 0xA7CF, 0xA948, 0xAB45, 0xADC2, 0xB0BB, 0xB42C, 0xB80F,
        0xBC60, 0xC116, 0xC62C, 0xCB9A, 0xD156, 0xD759, 0xDD9A, 0xE40F, 0xEAAD, 0xF16D, 0xF842, 0xFF23, 0x0604, 0x0CDD, 0x13A3, 0x1A4B,
        0x20CB, 0x2719, 0x2D2D, 0x32FC, 0x387E, 0x3DAB, 0x427A, 0x46E5, 0x4AE4, 0x4E73, 0x518A, 0x5427, 0x5644, 0x57DE, 0x58F4, 0x5983,
        0x598B, 0x590C, 0x5805, 0x567A, 0x546C, 0x51DE, 0x4ED4, 0x4B53, 0x4760, 0x4302, 0x3E3D, 0x391B, 0x33A3, 0x2DDC, 0x27D0, 0x2188,
        0x1B0D, 0x1469, 0x0DA6, 0x06CE, 0xFFEE, 0xF90C, 0xF235, 0xEB73, 0xE4D0, 0xDE56, 0xD80F, 0xD204, 0xCC3F, 0xC6C8, 0xC1A8, 0xBCE6,
        0xB889, 0xB499, 0xB11A, 0xAE13, 0xAB88, 0xA97C, 0xA7F4, 0xA6F0, 0xA674, 0xA67E, 0xA710, 0xA829, 0xA9C6, 0xABE6, 0xAE85, 0xB19F,
        0xB530, 0xB932, 0xBD9F, 0xC270, 0xC79F, 0xCD23, 0xD2F3, 0xD908, 0xDF58, 0xE5D9, 0xEC82, 0xF348, 0xFA21, 0x0103, 0x07E4, 0x0EB8,
        0x1577, 0x1C15, 0x2289, 0x28C8, 0x2ECA, 0x3485, 0x39F0, 0x3F04, 0x43B9, 0x4807, 0x4BE8, 0x4F57, 0x524D, 0x54C7, 0x56C1, 0x5837,
        0x5929, 0x5993, 0x5976, 0x58D1, 0x57A6, 0x55F7, 0x53C6, 0x5116, 0x4DEB, 0x4A4A, 0x463A, 0x41BE, 0x3CE0, 0x37A5, 0x3217, 0x2C3C,
        0x261F, 0x1FC8, 0x1940, 0x1293, 0x0BCA, 0x04EE, 0xFE0D, 0xF72D, 0xF05B, 0xE9A0, 0xE307, 0xDC9A, 0xD662, 0xD06A, 0xCAB9, 0xC559,
        0xC052, 0xBBAB, 0xB76B, 0xB399, 0xB03B, 0xAD55, 0xAAEC, 0xA904, 0xA7A0, 0xA6C1, 0xA669, 0xA699, 0xA750, 0xA88D, 0xAA4E, 0xAC91,
        0xAF52, 0xB28D, 0xB63D, 0xBA5D, 0xBEE6, 0xC3D1, 0xC918, 0xCEB2, 0xD496, 0xDABC, 0xE11A, 0xE7A7, 0xEE59, 0xF525, 0xFC02, 0x02E4,
        0x09C2, 0x1092, 0x1749, 0x1DDC, 0x2443, 0x2A72, 0x3061, 0x3608, 0x3B5C, 0x4057, 0x44F0, 0x4921, 0x4CE4, 0x5032, 0x5307, 0x555E,
        0x5734, 0x5887, 0x5953, 0x5998, 0x5956, 0x588D, 0x573E, 0x556B, 0x5316, 0x5044, 0x4CF9, 0x4939, 0x450B, 0x4074, 0x3B7B, 0x3629,
        0x3085, 0x2A97, 0x2469, 0x1E04, 0x1771, 0x10BB, 0x09EC, 0x030E, 0xFC2C, 0xF54F, 0xEE82, 0xE7CF, 0xE141, 0xDAE2, 0xD4BB, 0xCED5,
        0xC939, 0xC3F1, 0xBF03, 0xBA77, 0xB655, 0xB2A2, 0xAF64, 0xACA0, 0xAA5A, 0xA896, 0xA756, 0xA69C, 0xA669, 0xA6BD, 0xA799, 0xA8FA,
        0xAADF, 0xAD45, 0xB028, 0xB383, 0xB752, 0xBB8F, 0xC034, 0xC539, 0xCA97, 0xD046, 0xD63D, 0xDC73, 0xE2DF, 0xE977, 0xF031, 0xF703,
        0xFDE3, 0x04C4, 0x0BA0, 0x126A, 0x1918, 0x1FA0, 0x25F9, 0x2C17, 0x31F4, 0x3784, 0x3CC1, 0x41A2, 0x461F, 0x4A33, 0x4DD6, 0x5104,
        0x53B7, 0x55EB, 0x579E, 0x58CC, 0x5973, 0x5994, 0x592D, 0x583F, 0x56CB, 0x54D5, 0x525E, 0x4F6A, 0x4BFF, 0x4820, 0x43D4, 0x3F22,
        0x3A10, 0x34A7, 0x2EEE, 0x28EE, 0x22AF, 0x1C3D, 0x15A0, 0x0EE2, 0x080D, 0x012D, 0xFA4B, 0xF372, 0xECAB, 0xE601, 0xDF7F, 0xD92E,
        0xD318, 0xCD45, 0xC7C0, 0xC28F, 0xBDBB, 0xB94C, 0xB547, 0xB1B4, 0xAE97, 0xABF5, 0xA9D2, 0xA831, 0xA715, 0xA680, 0xA672, 0xA6EC,
        0xA7EC, 0xA972, 0xAB7A, 0xAE02, 0xB106, 0xB482, 0xB870, 0xBCCA, 0xC189, 0xC6A8, 0xCC1D, 0xD1E0, 0xD7E9, 0xDE2F, 0xE4A8, 0xEB4A,
        0xF20C, 0xF8E2, 0xFFC4, 0x06A5, 0x0D7C, 0x1440, 0x1AE4, 0x2161, 0x27AA, 0x2DB8, 0x3380, 0x38FB, 0x3E1F, 0x42E6, 0x4747, 0x4B3C,
        0x4EC0, 0x51CD, 0x545E, 0x566F, 0x57FD, 0x5907, 0x598A, 0x5985, 0x58F9, 0x57E7, 0x564F, 0x5435, 0x519C, 0x4E87, 0x4AFB, 0x46FF,
        0x4296, 0x3DC9, 0x389F, 0x331F, 0x2D51, 0x273F, 0x20F2, 0x1A73, 0x13CC, 0x0D07, 0x062E, 0xFF4D, 0xF86C, 0xF196, 0xEAD6, 0xE436,
        0xDDC1, 0xD77F, 0xD17A, 0xCBBC, 0xC64C, 0xC134, 0xBC7B, 0xB828, 0xB442, 0xB0CE, 0xADD2, 0xAB53, 0xA953, 0xA7D7, 0xA6DF, 0xA66F,
        0xA686, 0xA724, 0xA849, 0xA9F3, 0xAC1E, 0xAEC9, 0xB1EE, 0xB589, 0xB995, 0xBE0C, 0xC2E6, 0xC81C, 0xCDA8, 0xD37F, 0xD99A, 0xDFEE,
        0xE673, 0xED1F, 0xF3E8, 0xFAC2, 0x01A4, 0x0884, 0x0F57, 0x1613, 0x1CAE, 0x231D, 0x2957, 0x2F53, 0x3507, 0x3A6B, 0x3F76, 0x4422,
        0x4866, 0x4C3D, 0x4FA1, 0x528C, 0x54FB, 0x56E9, 0x5853, 0x5938, 0x5996, 0x596C, 0x58BC, 0x5785, 0x55C9, 0x538C, 0x50D1, 0x4D9B,
        0x49F0, 0x45D5, 0x4151, 0x3C69, 0x3727, 0x3191, 0x2BB0, 0x258D, 0x1F31, 0x18A6, 0x11F5, 0x0B2A, 0x044E, 0xFD6C, 0xF68D, 0xEFBC,
        0xE904, 0xE26F, 0xDC06, 0xD5D4, 0xCFE2, 0xCA38, 0xC4E0, 0xBFE1, 0xBB43, 0xB70D, 0xB345, 0xAFF2, 0xAD17, 0xAABA, 0xA8DE, 0xA786,
        0xA6B3, 0xA668, 0xA6A4, 0xA767, 0xA8B0, 0xAA7D, 0xACCC, 0xAF98, 0xB2DE, 0xB699, 0xBAC3, 0xBF55, 0xC449, 0xC998, 0xCF38, 0xD523,
        0xDB4E, 0xE1B1, 0xE842, 0xEEF7, 0xF5C5, 0xFCA3, 0x0385, 0x0A62, 0x1130, 0x17E4, 0x1E74, 0x24D6, 0x2B00, 0x30E9, 0x3688, 0x3BD4,
        0x40C6, 0x4556, 0x497E, 0x4D36, 0x5079, 0x5343, 0x558E, 0x5759, 0x589F, 0x595F, 0x5998, 0x5949, 0x5874, 0x5719, 0x553A, 0x52DA,
        0x4FFC, 0x4CA6, 0x48DC, 0x44A4, 0x4004, 0x3B03, 0x35A8, 0x2FFD, 0x2A09, 0x23D6, 0x1D6C, 0x16D6, 0x101D, 0x094C, 0x026D, 0xFB8B,
        0xF4AF, 0xEDE4, 0xE734, 0xE0AA, 0xDA50, 0xD42E, 0xCE4E, 0xC8BA, 0xC379, 0xBE94, 0xBA12, 0xB5FA, 0xB251, 0xAF1E, 0xAC66, 0xAA2B,
        0xA873, 0xA73F, 0xA691, 0xA66B, 0xA6CC, 0xA7B4, 0xA921, 0xAB12, 0xAD83, 0xB071, 0xB3D7, 0xB7B1, 0xBBF8, 0xC0A6, 0xC5B3, 0xCB19,
        0xD0CF, 0xD6CC, 0xDD07, 0xE378, 0xEA13, 0xF0D0, 0xF7A3, 0xFE84, 0x0565, 0x0C40, 0x1307, 0x19B3, 0x2037, 0x268A, 0x2CA3, 0x3279,
        0x3802, 0x3D37, 0x420F, 0x4683, 0x4A8D, 0x4E25, 0x5148, 0x53F0, 0x5618, 0x57BF, 0x58E1, 0x597C, 0x5990, 0x591D, 0x5822, 0x56A3,
        0x54A0, 0x521E, 0x4F1F, 0x4BA9, 0x47C0, 0x436B, 0x3EAF, 0x3995, 0x3424, 0x2E64, 0x285E, 0x221B, 0x1BA4, 0x1503, 0x0E43, 0x076D,
        0x008C, 0xF9AB, 0xF2D2, 0xEC0E, 0xE567, 0xDEE9, 0xD89D, 0xD28D, 0xCCC1, 0xC743, 0xC21A, 0xBD4F, 0xB8E9, 0xB4EF, 0xB166, 0xAE54,
        0xABBD, 0xA9EB, 0xA89F, 0xA7D8, 0xA798, 0xA7DE, 0xA8A8, 0xA9F6, 0xABC3, 0xAE0D, 0xB0CF, 0xB405, 0xB7A8, 0xBBB2, 0xC01D, 0xC4E1,
        0xC9F7, 0xCF56, 0xD4F6, 0xDACD, 0xE0D3, 0xE6FF, 0xED45, 0xF39E, 0xF9FE, 0x005C, 0x06B0, 0x0CEE, 0x130F, 0x1909, 0x1ED2, 0x2463,
        0x29B3, 0x2EBC, 0x3375, 0x37D8, 0x3BDF, 0x3F84, 0x42C3, 0x4598, 0x47FE, 0x49F4, 0x4B76, 0x4C83, 0x4D1B, 0x4D3D, 0x4CEA, 0x4C24,
        0x4AEB, 0x4944, 0x4730, 0x44B5, 0x41D6, 0x3E99, 0x3B03, 0x371A, 0x32E5, 0x2E6A, 0x29B2, 0x24C3, 0x1FA5, 0x1A61, 0x14FF, 0x0F86,
        0x0A00, 0x0476, 0xFEF0, 0xF974, 0xF40D, 0xEEC2, 0xE99B, 0xE49F, 0xDFD6, 0xDB47, 0xD6F8, 0xD2EF, 0xCF32, 0xCBC6, 0xC8AF, 0xC5F2,
        0xC392, 0xC192, 0xBFF4, 0xBEBB, 0xBDE6, 0xBD77, 0xBD6D, 0xBDC9, 0xBE87, 0xBFA8, 0xC127, 0xC303, 0xC537, 0xC7C0, 0xCA99, 0xCDBD,
        0xD126, 0xD4D0, 0xD8B4, 0xDCCC, 0xE110, 0xE57B, 0xEA05, 0xEEA7, 0xF35A, 0xF816, 0xFCD5, 0x018D, 0x063B, 0x0AD6, 0x0F56, 0x13B6,
        0x17F0, 0x1BFC, 0x1FD5, 0x2376, 0x26DA, 0x29FC, 0x2CD8, 0x2F69, 0x31AE, 0x33A3, 0x3545, 0x3693, 0x378C, 0x382E, 0x387A, 0x3870,
        0x3811, 0x375E, 0x3658, 0x3502, 0x335F, 0x3172, 0x2F3E, 0x2CC8, 0x2A13, 0x2725, 0x2402, 0x20AF, 0x1D32, 0x1991, 0x15D2, 0x11FA,
        0x0E10, 0x0A19, 0x061C, 0x021F, 0xFE28, 0xFA3D, 0xF664, 0xF2A2, 0xEEFD, 0xEB7A, 0xE81F, 0xE4F0, 0xE1F1, 0xDF27, 0xDC95, 0xDA3F,
        0xD828, 0xD652, 0xD4C0, 0xD373, 0xD26D, 0xD1AE, 0xD137, 0xD108, 0xD121, 0xD180, 0xD225, 0xD30E, 0xD439, 0xD5A3, 0xD74A, 0xD92B,
        0xDB41, 0xDD8A, 0xE001, 0xE2A3, 0xE56A, 0xE853, 0xEB58, 0xEE75, 0xF1A4, 0xF4E0, 0xF825, 0xFB6E, 0xFEB5, 0x01F4, 0x0528, 0x084D,
        0x0B5C, 0x0E52, 0x112B, 0x13E2, 0x1673, 0x18DB, 0x1B17, 0x1D24, 0x1F00, 0x20A7, 0x2218, 0x2351, 0x2451, 0x2518, 0x25A4, 0x25F5,
        0x260C, 0x25E9, 0x258D, 0x24F9, 0x242F, 0x2330, 0x21FE, 0x209C, 0x1F0D, 0x1D53, 0x1B72, 0x196C, 0x1746, 0x1503, 0x12A6, 0x1035,
        0x0DB2, 0x0B21, 0x0888, 0x05E9, 0x034A, 0x00AD, 0xFE18, 0xFB8E, 0xF911, 0xF6A7, 0xF453, 0xF217, 0xEFF8, 0xEDF8, 0xEC19, 0xEA5F,
        0xE8CB, 0xE75F, 0xE61E, 0xE507, 0xE41D, 0xE361, 0xE2D2, 0xE272, 0xE240, 0xE23C, 0xE265, 0xE2BA, 0xE33B, 0xE3E6, 0xE4B9, 0xE5B4,
        0xE6D2, 0xE814, 0xE975, 0xEAF4, 0xEC8E, 0xEE40, 0xF007, 0xF1DF, 0xF3C7, 0xF5BB, 0xF7B8, 0xF9BA, 0xFBBE, 0xFDC2, 0xFFC1, 0x01B9,
        0x03A8, 0x058A, 0x075D, 0x091D, 0x0ACA, 0x0C5F, 0x0DDC, 0x0F3E, 0x1083, 0x11AB, 0x12B3, 0x139A, 0x1460, 0x1504, 0x1586, 0x15E4,
        0x1620, 0x1639, 0x162F, 0x1604, 0x15B8, 0x154C, 0x14C1, 0x1419, 0x1354, 0x1276, 0x117E, 0x1071, 0x0F4E, 0x0E19, 0x0CD3, 0x0B7F,
        0x0A20, 0x08B7, 0x0746, 0x05D1, 0x045A, 0x02E2, 0x016C, 0xFFFC, 0xFE92, 0xFD30, 0xFBD8, 0xFA8E, 0xF951, 0xF825, 0xF70A, 0xF602,
        0xF50F, 0xF431, 0xF369, 0xF2B8, 0xF21F, 0xF19E, 0xF136, 0xF0E7, 0xF0B0, 0xF092, 0xF08D, 0xF09F, 0xF0C9, 0xF109, 0xF15F, 0xF1CA,
        0xF249, 0xF2DA, 0xF37C, 0xF42E, 0xF4EF, 0xF5BD, 0xF696, 0xF779, 0xF864, 0xF956, 0xFA4D, 0xFB47, 0xFC43, 0xFD3F, 0xFE3A, 0xFF31,
        0x0023, 0x0110, 0x01F6, 0x02D4, 0x03A7, 0x0470, 0x052D, 0x05DE, 0x0681, 0x0715, 0x079B, 0x0812, 0x0879, 0x08D0, 0x0917, 0x094E,
        0x0975, 0x098C, 0x0993, 0x098B, 0x0975, 0x0950, 0x091D, 0x08DE, 0x0892, 0x083B, 0x07D9, 0x076E, 0x06FA, 0x067F, 0x05FD, 0x0576,
        0x04EA, 0x045A, 0x03C8, 0x0335, 0x02A1, 0x020E, 0x017C, 0x00ED, 0x0061, 0xFFDA, 0xFF57, 0xFEDA, 0xFE63, 0xFDF3, 0xFD8A, 0xFD29,
        0xFCD0, 0xFC80, 0xFC39, 0xFBFA, 0xFBC5, 0xFB98, 0xFB75, 0xFB5A, 0xFB49, 0xFB40, 0xFB3F, 0xFB46, 0xFB55, 0xFB6B, 0xFB88, 0xFBAC,
        0xFBD5, 0xFC03, 0xFC36, 0xFC6D, 0xFCA7, 0xFCE5, 0xFD25, 0xFD66, 0xFDA9, 0xFDEC, 0xFE30, 0xFE73, 0xFEB5, 0xFEF6, 0xFF35, 0xFF71,
        0xFFAB, 0xFFE2, 0x0015, 0x0045, 0x0072, 0x009A, 0x00BF, 0x00E0, 0x00FC, 0x0114, 0x0128, 0x0139, 0x0145, 0x014D, 0x0152, 0x0153,
        0x0152, 0x014D, 0x0145, 0x013B, 0x012F, 0x0121, 0x0111, 0x0100, 0x00EE, 0x00DB, 0x00C8, 0x00B5, 0x00A2, 0x008F, 0x007D, 0x006B,
        0x005B, 0x004C, 0x003D, 0x0031, 0x0025, 0x001C, 0x0013, 0x000C, 0x0007, 0x0003, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF,
        0x0000, 0x0001, 0x0004, 0x0007, 0x000A, 0x000E, 0x0012, 0x0017, 0x001D, 0x0023, 0x002A, 0x0031, 0x0038, 0x0040, 0x0049, 0x0051,
        0x005A, 0x0063, 0x006C, 0x0075, 0x007E, 0x0087, 0x008F, 0x0098, 0x009F, 0x00A6, 0x00AC, 0x00B2, 0x00B6, 0x00BA, 0x00BC, 0x00BD,
        0x00BC, 0x00BA, 0x00B7, 0x00B2, 0x00AB, 0x00A2, 0x0098, 0x008B, 0x007D, 0x006D, 0x005B, 0x0047, 0x0031, 0x0019, 0x0000, 0xFFE6,
        0xFFC9, 0xFFAB, 0xFF8B, 0xFF6A, 0xFF48, 0xFF25, 0xFF02, 0xFEDD, 0xFEB9, 0xFE94, 0xFE70, 0xFE4C, 0xFE28, 0xFE05, 0xFDE4, 0xFDC4,
        0xFDA5, 0xFD88, 0xFD6E, 0xFD56, 0xFD41, 0xFD2E, 0xFD1F, 0xFD13, 0xFD0B, 0xFD07, 0xFD07, 0xFD0B, 0xFD13, 0xFD20, 0xFD32, 0xFD48,
        0xFD63, 0xFD83, 0xFDA7, 0xFDD1, 0xFDFF, 0xFE32, 0xFE69, 0xFEA5, 0xFEE5, 0xFF29, 0xFF70, 0xFFBC, 0x0009, 0x005B, 0x00AF, 0x0105,
        0x015D, 0x01B6, 0x0210, 0x026B, 0x02C6, 0x0320, 0x0379, 0x03D1, 0x0426, 0x0479, 0x04C9, 0x0515, 0x055C, 0x059F, 0x05DD, 0x0615,
        0x0647, 0x0672, 0x0696, 0x06B3, 0x06C8, 0x06D4, 0x06D8, 0x06D3, 0x06C5, 0x06AE, 0x068D, 0x0663, 0x062F, 0x05F2, 0x05AC, 0x055C,
        0x0503, 0x04A0, 0x0436, 0x03C2, 0x0347, 0x02C4, 0x023A, 0x01A9, 0x0113, 0x0077, 0xFFD7, 0xFF32, 0xFE8A, 0xFDDF, 0xFD33, 0xFC86,
        0xFBD9, 0xFB2D, 0xFA83, 0xF9DB, 0xF937, 0xF898, 0xF7FE, 0xF76B, 0xF6DF, 0xF65B, 0xF5E0, 0xF570, 0xF509, 0xF4AF, 0xF461, 0xF41F,
        0xF3EB, 0xF3C5, 0xF3AE, 0xF3A6, 0xF3AD, 0xF3C4, 0xF3EB, 0xF422, 0xF469, 0xF4C0, 0xF528, 0xF59F, 0xF626, 0xF6BC, 0xF761, 0xF814,
        0xF8D5, 0xF9A4, 0xFA7E, 0xFB64, 0xFC55, 0xFD4F, 0xFE51, 0xFF5B, 0x006A, 0x017F, 0x0298, 0x03B3, 0x04D0, 0x05EB, 0x0706, 0x081C,
        0x092E, 0x0A3A, 0x0B3F, 0x0C3A, 0x0D2B, 0x0E10, 0x0EE8, 0x0FB1, 0x106B, 0x1114, 0x11AA, 0x122E, 0x129D, 0x12F7, 0x133B, 0x1368,
        0x137F, 0x137D, 0x1363, 0x1331, 0x12E5, 0x1282, 0x1205, 0x1170, 0x10C2, 0x0FFD, 0x0F21, 0x0E2E, 0x0D25, 0x0C07, 0x0AD6, 0x0992,
        0x083D, 0x06D8, 0x0564, 0x03E4, 0x0258, 0x00C3, 0xFF28, 0xFD85, 0xFBDF, 0xFA37, 0xF88F, 0xF6EA, 0xF549, 0xF3AF, 0xF21D, 0xF097,
        0xEF1D, 0xEDB1, 0xEC57, 0xEB10, 0xE9DD, 0xE8C1, 0xE7BD, 0xE6D3, 0xE604, 0xE553, 0xE4BF, 0xE44B, 0xE3F7, 0xE3C5, 0xE3B4, 0xE3C6,
        0xE3FB, 0xE453, 0xE4CF, 0xE56E, 0xE630, 0xE714, 0xE81A, 0xE942, 0xEA8A, 0xEBF1, 0xED75, 0xEF16, 0xF0D2, 0xF2A7, 0xF492, 0xF693,
        0xF8A7, 0xFACA, 0xFCFC, 0xFF3A, 0x017F, 0x03CC, 0x061C, 0x086C, 0x0ABA, 0x0D04, 0x0F45, 0x117B, 0x13A3, 0x15BB, 0x17BF, 0x19AE,
        0x1B83, 0x1D3C, 0x1ED8, 0x2053, 0x21AC, 0x22E0, 0x23ED, 0x24D2, 0x258D, 0x261C, 0x267E, 0x26B3, 0x26B8, 0x268F, 0x2636, 0x25AC,
        0x24F4, 0x240B, 0x22F4, 0x21AE, 0x203B, 0x1E9C, 0x1CD2, 0x1AE0, 0x18C6, 0x1688, 0x1427, 0x11A6, 0x0F08, 0x0C4F, 0x097F, 0x069B,
        0x03A5, 0x00A2, 0xFD96, 0xFA83, 0xF76D, 0xF458, 0xF148, 0xEE41, 0xEB46, 0xE85C, 0xE586, 0xE2C8, 0xE025, 0xDDA1, 0xDB40, 0xD905,
        0xD6F3, 0xD50D, 0xD355, 0xD1CF, 0xD07D, 0xCF62, 0xCE7E, 0xCDD4, 0xCD65, 0xCD33, 0xCD3E, 0xCD87, 0xCE0F, 0xCED5, 0xCFD9, 0xD11A,
        0xD298, 0xD452, 0xD646, 0xD872, 0xDAD4, 0xDD6A, 0xE031, 0xE327, 0xE648, 0xE991, 0xECFE, 0xF08C, 0xF436, 0xF7F9, 0xFBCF, 0xFFB5,
        0x03A4, 0x079B, 0x0B93, 0x0F88, 0x1374, 0x1753, 0x1B20, 0x1ED6, 0x2270, 0x25EA, 0x293E, 0x2C69, 0x2F67, 0x3232, 0x34C8, 0x3724,
        0x3943, 0x3B22, 0x3CBE, 0x3E14, 0x3F22, 0x3FE6, 0x405E, 0x4089, 0x4066, 0x3FF5, 0x3F34, 0x3E25, 0x3CC8, 0x3B1D, 0x3926, 0x36E5,
        0x345C, 0x318D, 0x2E7B, 0x2B28, 0x2799, 0x23D1, 0x1FD5, 0x1BA8, 0x174F, 0x12CF, 0x0E2E, 0x0970, 0x049C, 0xFFB7, 0xFAC6, 0xF5CF,
        0xF0D9, 0xEBE9, 0xE706, 0xE236, 0xDD7F, 0xD8E6, 0xD472, 0xD029, 0xCC0F, 0xC82B, 0xC482, 0xC118, 0xBDF3, 0xBB17, 0xB887, 0xB649,
        0xB45F, 0xB2CC, 0xB194, 0xB0B7, 0xB039, 0xB01B, 0xB05D, 0xB101, 0xB206, 0xB36B, 0xB531, 0xB756, 0xB9D7, 0xBCB4, 0xBFE8, 0xC371,
        0xC74B, 0xCB73, 0xCFE4, 0xD499, 0xD98C, 0xDEBA, 0xE41B, 0xE9AA, 0xEF5F, 0xF536, 0xFB26, 0x0128, 0x0737, 0x0D4A, 0x135A, 0x195F,
        0x1F32, 0x24DF, 0x2A5F, 0x2FAD, 0x34C1, 0x3997, 0x3E27, 0x426C, 0x4662, 0x4A03, 0x4D4B, 0x5037, 0x52C2, 0x54EA, 0x56AB, 0x5805,
        0x58F5, 0x597B, 0x5995, 0x5943, 0x5886, 0x575F, 0x55CF, 0x53D8, 0x517D, 0x4EBF, 0x4BA3, 0x482C, 0x445F, 0x403F, 0x3BD3, 0x371E,
        0x3227, 0x2CF5, 0x278C, 0x21F3, 0x1C32, 0x164F, 0x1051, 0x0A40, 0x0422, 0xFE01, 0xF7E1, 0xF1CA, 0xEBC5, 0xE5D7, 0xE00A, 0xDA62,
        0xD4E8, 0xCFA2, 0xCA95, 0xC5C9, 0xC143, 0xBD08, 0xB91D, 0xB588, 0xB24C, 0xAF6D, 0xACEF, 0xAAD4, 0xA920, 0xA7D4, 0xA6F2, 0xA67B,
        0xA670, 0xA6D0, 0xA79B, 0xA8D0, 0xAA6E, 0xAC73, 0xAEDB, 0xB1A6, 0xB4CE, 0xB851, 0xBC2A, 0xC054, 0xC4CA, 0xC988, 0xCE87, 0xD3C2,
        0xD931, 0xDECF, 0xE496, 0xEA7C, 0xF07D, 0xF691, 0xFCAF, 0x02D1, 0x08F1, 0x0F05, 0x1508, 0x1AF1, 0x20BA, 0x265C, 0x2BCF, 0x310E,
        0x3613, 0x3AD6, 0x3F52, 0x4383, 0x4763, 0x4AEC, 0x4E1C, 0x50EE, 0x535F, 0x556C, 0x5712, 0x5850, 0x5924, 0x598C, 0x5989, 0x591B,
        0x5842, 0x56FF, 0x5553, 0x5341, 0x50CB, 0x4DF4, 0x4ABF, 0x4730, 0x434D, 0x3F18, 0x3A97, 0x35D1, 0x30C9, 0x2B87, 0x2611, 0x206D,
        0x1AA2, 0x14B7, 0x0EB4, 0x089E, 0x027F, 0xFC5D, 0xF63F, 0xF02C, 0xEA2C, 0xE447, 0xDE83, 0xD8E7, 0xD37A, 0xCE42, 0xC946, 0xC48C,
        0xC01A, 0xBBF4, 0xB81F, 0xB4A1, 0xB17E, 0xAEB9, 0xAC55, 0xAA56, 0xA8BD, 0xA78E, 0xA6C8, 0xA66E, 0xA67F, 0xA6FC, 0xA7E3, 0xA935,
        0xAAEE, 0xAD0E, 0xAF91, 0xB275, 0xB5B6, 0xB950, 0xBD3F, 0xC17E, 0xC608, 0xCAD8, 0xCFE7, 0xD531, 0xDAAE, 0xE057, 0xE627, 0xEC15,
        0xF21C, 0xF833, 0xFE53, 0x0475, 0x0A92, 0x10A3, 0x169F, 0x1C81, 0x2240, 0x27D6, 0x2D3C, 0x326C, 0x375F, 0x3C10, 0x4079, 0x4494,
        0x485D, 0x4BCF, 0x4EE7, 0x519F, 0x53F5, 0x55E7, 0x5771, 0x5893, 0x594A, 0x5996, 0x5977, 0x58EC, 0x57F6, 0x5696, 0x54CF, 0x52A2,
        0x5012, 0x4D21, 0x49D4, 0x462E, 0x4234, 0x3DEB, 0x3957, 0x347E, 0x2F67, 0x2A16, 0x2493, 0x1EE4, 0x1910, 0x131E, 0x0D15, 0x06FC,
        0x00DB, 0xFAB9, 0xF49D, 0xEE8F, 0xE896, 0xE2B9, 0xDCFF, 0xD76F, 0xD20F, 0xCCE7, 0xC7FC, 0xC355, 0xBEF6, 0xBAE5, 0xB728, 0xB3C1,
        0xB0B7, 0xAE0B, 0xABC2, 0xA9DE, 0xA862, 0xA74E, 0xA6A5, 0xA668, 0xA696, 0xA72F, 0xA833, 0xA9A1, 0xAB76, 0xADB0, 0xB04E, 0xB34B,
        0xB6A4, 0xBA55, 0xBE5A, 0xC2AE, 0xC74B, 0xCC2C, 0xD14C, 0xD6A4, 0xDC2D, 0xE1E1, 0xE7BA, 0xEDB0, 0xF3BB, 0xF9D6, 0xFFF7, 0x0618,
        0x0C33, 0x123F, 0x1835, 0x1E0E, 0x23C2, 0x294C, 0x2EA5, 0x33C5, 0x38A7, 0x3D45, 0x419A, 0x45A0, 0x4952, 0x4CAC, 0x4FAA, 0x5249,
        0x5484, 0x565B, 0x57C9, 0x58CE, 0x5969, 0x5998, 0x595C, 0x58B4, 0x57A2, 0x5627, 0x5444, 0x51FC, 0x4F52, 0x4C48, 0x48E3, 0x4526,
        0x4116, 0x3CB9, 0x3812, 0x3328, 0x2E00, 0x28A2, 0x2312, 0x1D58, 0x177C, 0x1183, 0x0B75, 0x0559, 0xFF37, 0xF916, 0xF2FD, 0xECF4,
        0xE701, 0xE12D, 0xDB7D, 0xD5FA, 0xD0A9, 0xCB90, 0xC6B7, 0xC222, 0xBDD8, 0xB9DD, 0xB636, 0xB2E8, 0xAFF7, 0xAD65, 0xAB37, 0xA96E,
        0xA80E, 0xA717, 0xA68A, 0xA66A, 0xA6B4, 0xA76A, 0xA88B, 0xAA14, 0xAC04, 0xAE5A, 0xB111, 0xB427, 0xB798, 0xBB60, 0xBF7B, 0xC3E3,
        0xC893, 0xCD85, 0xD2B4, 0xD81A, 0xDDB0, 0xE36E, 0xE94F, 0xEF4C, 0xF55C, 0xFB79, 0x019B, 0x07BB, 0x0DD3, 0x13D9, 0x19C8, 0x1F98,
        0x2542, 0x2ABF, 0x3009, 0x351A, 0x39EA, 0x3E75, 0x42B5, 0x46A5, 0x4A40, 0x4D82, 0x5067, 0x52EB, 0x550C, 0x56C7, 0x5819, 0x5902,
        0x5980, 0x5993, 0x593A, 0x5875, 0x5747, 0x55B0, 0x53B2, 0x514F, 0x4E8B, 0x4B68, 0x47EB, 0x4418, 0x3FF3, 0x3B81, 0x36C8, 0x31CD,
        0x2C96, 0x2729, 0x218E, 0x1BCA, 0x15E5, 0x0FE6, 0x09D3, 0x03B5, 0xFD93, 0xF774, 0xF15E, 0xEB5A, 0xE56F, 0xDFA4, 0xD9FF, 0xD489,
        0xCF46, 0xCA3E, 0xC576, 0xC0F5, 0xBCBF, 0xB8DB, 0xB54B, 0xB215, 0xAF3D, 0xACC6, 0xAAB3, 0xA906, 0xA7C1, 0xA6E7, 0xA677, 0xA673,
        0xA6DB, 0xA7AD, 0xA8EA, 0xAA8F, 0xAC9A, 0xAF0A, 0xB1DB, 0xB50A, 0xB893, 0xBC71, 0xC0A1, 0xC51D, 0xC9DF, 0xCEE2, 0xD421, 0xD994,
        0xDF35, 0xE4FE, 0xEAE7, 0xF0E9, 0xF6FD, 0xFD1D, 0x033F, 0x095D, 0x0F71, 0x1572, 0x1B59, 0x2120, 0x26BF, 0x2C2F, 0x316A, 0x366A,
        0x3B28, 0x3FA0, 0x43CB, 0x47A4, 0x4B28, 0x4E52, 0x511D, 0x5387, 0x558D, 0x572C, 0x5862, 0x592E, 0x5990, 0x5985, 0x590F, 0x582F,
        0x56E4, 0x5531, 0x5318, 0x509B, 0x4DBD, 0x4A82, 0x46EE, 0x4304, 0x3ECA, 0x3A44, 0x3579, 0x306D, 0x2B28, 0x25AE, 0x2007, 0x1A3A,
        0x144D, 0x0E48, 0x0831, 0x0211, 0xFBF0, 0xF5D2, 0xEFC0, 0xE9C2, 0xE3DF, 0xDE1D, 0xD885, 0xD31B, 0xCDE7, 0xC8F0, 0xC43B, 0xBFCD,
        0xBBAD, 0xB7DE, 0xB466, 0xB149, 0xAE8B, 0xAC2E, 0xAA36, 0xA8A5, 0xA77C, 0xA6BE, 0xA66C, 0xA684, 0xA708, 0xA7F7, 0xA950, 0xAB11,
        0xAD37, 0xAFC1, 0xB2AC, 0xB5F3, 0xB993, 0xBD88, 0xC1CC, 0xC65C, 0xCB30, 0xD044, 0xD591, 0xDB11, 0xE0BD, 0xE68F, 0xEC80, 0xF288,
        0xF8A0, 0xFEC1, 0x04E2, 0x0AFF, 0x110E, 0x1709, 0x1CE8, 0x22A5, 0x2838, 0x2D9A, 0x32C6, 0x37B5, 0x3C61, 0x40C5, 0x44DA, 0x489E,
        0x4C0A, 0x4F1A, 0x51CC, 0x541B, 0x5606, 0x5789, 0x58A3, 0x5953, 0x5997, 0x5970, 0x58DE, 0x57E1, 0x567A, 0x54AC, 0x5277, 0x4FE0,
        0x4CE9, 0x4996, 0x45EA, 0x41EA, 0x3D9C, 0x3903, 0x3426, 0x2F0A, 0x29B6, 0x242F, 0x1E7D, 0x18A7, 0x12B3, 0x0CA8, 0x068F, 0x006D,
        0xFA4C, 0xF431, 0xEE24, 0xE82C, 0xE251, 0xDC9A, 0xD70D, 0xD1B1, 0xCC8D, 0xC7A7, 0xC304, 0xBEAB, 0xBAA0, 0xB6E8, 0xB388, 0xB084,
        0xADDF, 0xAB9D, 0xA9C0, 0xA84B, 0xA73F, 0xA69E, 0xA668, 0xA69D, 0xA73E, 0xA849, 0xA9BE, 0xAB9A, 0xADDC, 0xB080, 0xB383, 0xB6E3,
        0xBA9A, 0xBEA5, 0xC2FE, 0xC7A0, 0xCC86, 0xD1A9, 0xD705, 0xDC91, 0xE248, 0xE823, 0xEE1B, 0xF428, 0xFA43, 0x0064, 0x0685, 0x0C9F,
        0x12AA, 0x189E, 0x1E75, 0x2427, 0x29AD, 0x2F02, 0x341E, 0x38FC, 0x3D95, 0x41E4, 0x45E4, 0x4991, 0x4CE4, 0x4FDC, 0x5274, 0x54A8,
        0x5678, 0x57DF, 0x58DD, 0x5970, 0x5997, 0x5954, 0x58A5, 0x578B, 0x5608, 0x541F, 0x51D0, 0x4F1F, 0x4C0E, 0x48A3, 0x44E0, 0x40CB,
        0x3C68, 0x37BC, 0x32CE, 0x2DA2, 0x2840, 0x22AD, 0x1CF1, 0x1712, 0x1117, 0x0B08, 0x04EC, 0xFECA, 0xF8A9, 0xF291, 0xEC89, 0xE698,
        0xE0C6, 0xDB1A, 0xD599, 0xD04C, 0xCB38, 0xC663, 0xC1D3, 0xBD8E, 0xB999, 0xB5F8, 0xB2B1, 0xAFC6, 0xAD3B, 0xAB14, 0xA952, 0xA7F9,
        0xA709, 0xA685, 0xA66B, 0xA6BE, 0xA77B, 0xA8A3, 0xAA33, 0xAC2B, 0xAE87, 0xB145, 0xB461, 0xB7D9, 0xBBA7, 0xBFC7, 0xC434, 0xC8E9,
        0xCDE0, 0xD313, 0xD87C, 0xDE15, 0xE3D6, 0xE9B9, 0xEFB7, 0xF5C9, 0xFBE6, 0x0208, 0x0828, 0x0E3F, 0x1444, 0x1A31, 0x1FFE, 0x25A5,
        0x2B1F, 0x3065, 0x3572, 0x3A3D, 0x3EC3, 0x42FE, 0x46E8, 0x4A7D, 0x4DB9, 0x5097, 0x5315, 0x552E, 0x56E2, 0x582D, 0x590E, 0x5985,
        0x5990, 0x592F, 0x5864, 0x572E, 0x558F, 0x538A, 0x5121, 0x4E56, 0x4B2D, 0x47AA, 0x43D1, 0x3FA6, 0x3B2F, 0x3671, 0x3172, 0x2C37,
        0x26C7, 0x2129, 0x1B62, 0x157B, 0x0F7A, 0x0967, 0x0348, 0xFD26, 0xF707, 0xF0F2, 0xEAF0, 0xE507, 0xDF3E, 0xD99C, 0xD429, 0xCEEA,
        0xC9E6, 0xC524, 0xC0A7, 0xBC77, 0xB898, 0xB50F, 0xB1E0, 0xAF0E, 0xAC9E, 0xAA91, 0xA8EC, 0xA7AF, 0xA6DB, 0xA673, 0xA677, 0xA6E6,
        0xA7C0, 0xA903, 0xAAB0, 0xACC2, 0xAF39, 0xB211, 0xB546, 0xB8D5, 0xBCB9, 0xC0EE, 0xC56F, 0xCA36, 0xCF3E, 0xD480, 0xD9F7, 0xDF9B,
        0xE566, 0xEB51, 0xF155, 0xF76A, 0xFD8A, 0x03AC, 0x09CA, 0x0FDD, 0x15DC, 0x1BC1, 0x2185, 0x2721, 0x2C8E, 0x31C5, 0x36C0, 0x3B7A,
        0x3FEC, 0x4412, 0x47E6, 0x4B63, 0x4E86, 0x514B, 0x53AE, 0x55AD, 0x5745, 0x5874, 0x5939, 0x5992, 0x5981, 0x5903, 0x581B, 0x56C9,
        0x550F, 0x52EF, 0x506B, 0x4D87, 0x4A45, 0x46AB, 0x42BB, 0x3E7C, 0x39F1, 0x3521, 0x3011, 0x2AC8, 0x254B, 0x1FA1, 0x19D1, 0x13E2,
        0x0DDC, 0x07C5, 0x01A4, 0xFB82, 0xF565, 0xEF55, 0xE958, 0xE377, 0xDDB8, 0xD822, 0xD2BD, 0xCD8D, 0xC89A, 0xC3E9, 0xBF81, 0xBB66,
        0xB79E, 0xB42C, 0xB115, 0xAE5D, 0xAC08, 0xAA17, 0xA88D, 0xA76C, 0xA6B5, 0xA66A, 0xA68A, 0xA716, 0xA80C, 0xA96C, 0xAB34, 0xAD61,
        0xAFF2, 0xB2E3, 0xB631, 0xB9D7, 0xBDD1, 0xC21B, 0xC6B0, 0xCB89, 0xD0A1, 0xD5F1, 0xDB75, 0xE124, 0xE6F8, 0xECEB, 0xF2F4, 0xF90D,
        0xFF2E, 0x054F, 0x0B6B, 0x1179, 0x1773, 0x1D50, 0x2309, 0x2899, 0x2DF8, 0x3320, 0x380B, 0x3CB2, 0x4110, 0x4520, 0x48DD, 0x4C43,
        0x4F4D, 0x51F8, 0x5441, 0x5624, 0x57A0, 0x58B3, 0x595B, 0x5998, 0x596A, 0x58D0, 0x57CB, 0x565D, 0x5488, 0x524C, 0x4FAF, 0x4CB1,
        0x4957, 0x45A6, 0x41A0, 0x3D4C, 0x38AE, 0x33CD, 0x2EAD, 0x2955, 0x23CB, 0x1E16, 0x183E, 0x1248, 0x0C3C, 0x0622, 0x0000, 0xF9DF,
        0xF3C5, 0xEDB9, 0xE7C3, 0xE1EA, 0xDC36, 0xD6AC, 0xD154, 0xCC34, 0xC752, 0xC2B4, 0xBE60, 0xBA5B, 0xB6A9, 0xB34F, 0xB052, 0xADB4,
        0xAB79, 0xA9A3, 0xA835, 0xA730, 0xA696, 0xA668, 0xA6A5, 0xA74D, 0xA860, 0xA9DC, 0xABBF, 0xAE07, 0xB0B2, 0xB3BD, 0xB722, 0xBADF,
        0xBEEF, 0xC34E, 0xC7F5, 0xCCDF, 0xD207, 0xD766, 0xDCF6, 0xE2B0, 0xE88D, 0xEE86, 0xF494, 0xFAB0, 0x00D1, 0x06F2, 0x0D0B, 0x1315,
        0x1907, 0x1EDB, 0x248B, 0x2A0E, 0x2F5F, 0x3477, 0x3950, 0x3DE4, 0x422E, 0x4628, 0x49CF, 0x4D1C, 0x500D, 0x529E, 0x54CC, 0x5694,
        0x57F4, 0x58EA, 0x5976, 0x5996, 0x594B, 0x5894, 0x5774, 0x55EA, 0x53F9, 0x51A3, 0x4EEB, 0x4BD4, 0x4863, 0x449A, 0x407F, 0x3C17,
        0x3767, 0x3274, 0x2D44, 0x27DE, 0x2248, 0x1C89, 0x16A8, 0x10AC, 0x0A9B, 0x047E, 0xFE5D, 0xF83C, 0xF225, 0xEC1E, 0xE630, 0xE060,
        0xDAB6, 0xD539, 0xCFEF, 0xCADF, 0xC60F, 0xC185, 0xBD45, 0xB956, 0xB5BB, 0xB27A, 0xAF95, 0xAD11, 0xAAF1, 0xA937, 0xA7E5, 0xA6FD,
        0xA67F, 0xA66E, 0xA6C7, 0xA78C, 0xA8BB, 0xAA53, 0xAC51, 0xAEB5, 0xB179, 0xB49C, 0xB81A, 0xBBEE, 0xC013, 0xC485, 0xC93F, 0xCE3A,
        0xD372, 0xD8DE, 0xDE7A, 0xE43E, 0xEA23, 0xF023, 0xF635, 0xFC54, 0x0275, 0x0895, 0x0EAA, 0x14AE, 0x1A99, 0x2064, 0x2609, 0x2B7F,
        0x30C1, 0x35C9, 0x3A90, 0x3F11, 0x4346, 0x472B, 0x4ABA, 0x4DEF, 0x50C7, 0x533D, 0x5550, 0x56FC, 0x5840, 0x591A, 0x5989, 0x598D,
        0x5925, 0x5852, 0x5714, 0x556F, 0x5363, 0x50F2, 0x4E21, 0x4AF1, 0x4768, 0x4389, 0x3F59, 0x3ADD, 0x361A, 0x3116, 0x2BD8, 0x2664,
        0x20C3, 0x1AFA, 0x1511, 0x0F0E, 0x08FA, 0x02DB, 0xFCB9, 0xF69A, 0xF087, 0xEA86, 0xE49E, 0xDED8, 0xD93A, 0xD3CA, 0xCE8F, 0xC98F,
        0xC4D1, 0xC05A, 0xBC30, 0xB856, 0xB4D3, 0xB1AA, 0xAEDF, 0xAC76, 0xAA71, 0xA8D2, 0xA79C, 0xA6D1, 0xA670, 0xA67B, 0xA6F1, 0xA7D3,
        0xA91E, 0xAAD1, 0xACEB, 0xAF69, 0xB247, 0xB582, 0xB917, 0xBD02, 0xC13C, 0xC5C2, 0xCA8E, 0xCF9A, 0xD4E0, 0xDA5A, 0xE001, 0xE5CF,
        0xEBBB, 0xF1C1, 0xF7D7, 0xFDF7, 0x0419, 0x0A37, 0x1048, 0x1646, 0x1C29, 0x21EB, 0x2783, 0x2CEC, 0x3220, 0x3717, 0x3BCC, 0x4039,
        0x4459, 0x4827, 0x4B9E, 0x4EBB, 0x5179, 0x53D5, 0x55CD, 0x575D, 0x5885, 0x5942, 0x5995, 0x597B, 0x58F7, 0x5807, 0x56AE, 0x54ED,
        0x52C5, 0x503B, 0x4D50, 0x4A08, 0x4667, 0x4272, 0x3E2D, 0x399E, 0x34C9, 0x2FB5, 0x2A67, 0x24E7, 0x1F3A, 0x1968, 0x1378, 0x0D70,
        0x0758, 0x0137, 0xFB15, 0xF4F9, 0xEEE9, 0xE8EF, 0xE310, 0xDD53, 0xD7C1, 0xD25E, 0xCD33, 0xC844, 0xC399, 0xBF35, 0xBB20, 0xB75D,
        0xB3F2, 0xB0E2, 0xAE31, 0xABE2, 0xA9F8, 0xA875, 0xA75C, 0xA6AC, 0xA669, 0xA690, 0xA723, 0xA821, 0xA988, 0xAB57, 0xAD8C, 0xB024,
        0xB31B, 0xB66F, 0xBA1B, 0xBE1B, 0xC26B, 0xC704, 0xCBE1, 0xD0FE, 0xD652, 0xDBD9, 0xE18B, 0xE761, 0xED56, 0xF360, 0xF97A, 0xFF9B,
        0x05BC, 0x0BD8, 0x11E5, 0x17DC, 0x1DB7, 0x236E, 0x28FB, 0x2E56, 0x337A, 0x3860, 0x3D02, 0x415B, 0x4566, 0x491D, 0x4C7C, 0x4F80,
        0x5224, 0x5466, 0x5642, 0x57B7, 0x58C2, 0x5963, 0x5998, 0x5962, 0x58C1, 0x57B5, 0x5640, 0x5463, 0x5221, 0x4F7C, 0x4C78, 0x4918,
        0x4561, 0x4156, 0x3CFC, 0x385A, 0x3373, 0x2E4F, 0x28F4, 0x2367, 0x1DAF, 0x17D4, 0x11DD, 0x0BD0, 0x05B5, 0xFF94, 0xF972, 0xF358,
        0xED4E, 0xE75A, 0xE183, 0xDBD1, 0xD64B, 0xD0F7, 0xCBDB, 0xC6FE, 0xC265, 0xBE16, 0xBA16, 0xB66B, 0xB317, 0xB020, 0xAD89, 0xAB55,
        0xA986, 0xA81F, 0xA722, 0xA690, 0xA669, 0xA6AD, 0xA75D, 0xA877, 0xA9FA, 0xABE4, 0xAE34, 0xB0E6, 0xB3F6, 0xB762, 0xBB25, 0xBF3B,
        0xC39E, 0xC84A, 0xCD39, 0xD265, 0xD7C8, 0xDD5B, 0xE317, 0xE8F6, 0xEEF1, 0xF501, 0xFB1D, 0x013F, 0x075F, 0x0D78, 0x137F, 0x1970,
        0x1F42, 0x24EE, 0x2A6E, 0x2FBC, 0x34CF, 0x39A4, 0x3E33, 0x4278, 0x466C, 0x4A0C, 0x4D54, 0x503E, 0x52C8, 0x54EF, 0x56B0, 0x5809,
        0x58F8, 0x597C, 0x5994, 0x5942, 0x5884, 0x575C, 0x55CA, 0x53D2, 0x5176, 0x4EB7, 0x4B9A, 0x4822, 0x4454, 0x4033, 0x3BC6, 0x3711,
        0x3219, 0x2CE6, 0x277C, 0x21E3, 0x1C22, 0x163E, 0x1040, 0x0A2F, 0x0411, 0xFDEF, 0xF7CF, 0xF1B9, 0xEBB4, 0xE5C7, 0xDFFA, 0xDA53,
        0xD4D9, 0xCF93, 0xCA88, 0xC5BC, 0xC136, 0xBCFC, 0xB913, 0xB57E, 0xB243, 0xAF65, 0xACE8, 0xAACF, 0xA91C, 0xA7D1, 0xA6F1, 0xA67B,
        0xA670, 0xA6D2, 0xA79E, 0xA8D4, 0xAA73, 0xAC79, 0xAEE3, 0xB1AE, 0xB4D8, 0xB85B, 0xBC35, 0xC060, 0xC4D7, 0xC996, 0xCE96, 0xD3D1,
        0xD941, 0xDEE0, 0xE4A6, 0xEA8D, 0xF08E, 0xF6A2, 0xFCC1, 0x02E3, 0x0902, 0x0F16, 0x1519, 0x1B02, 0x20CA, 0x266B, 0x2BDF, 0x311D,
        0x3620, 0x3AE3, 0x3F5F, 0x438E, 0x476D, 0x4AF6, 0x4E25, 0x50F6, 0x5365, 0x5571, 0x5716, 0x5853, 0x5925, 0x598D, 0x5989, 0x5919,
        0x583F, 0x56FA, 0x554E, 0x533A, 0x50C3, 0x4DEB, 0x4AB5, 0x4726, 0x4341, 0x3F0C, 0x3A8A, 0x35C3, 0x30BB, 0x2B78, 0x2601, 0x205D,
        0x1A92, 0x14A7, 0x0EA3, 0x088D, 0x026D, 0xFC4C, 0xF62D, 0xF01B, 0xEA1B, 0xE436, 0xDE73, 0xD8D7, 0xD36B, 0xCE34, 0xC939, 0xC47F,
        0xC00E, 0xBBE8, 0xB815, 0xB498, 0xB175, 0xAEB1, 0xAC4F, 0xAA51, 0xA8B9, 0xA78B, 0xA6C7, 0xA66D, 0xA680, 0xA6FE, 0xA7E6, 0xA939,
        0xAAF4, 0xAD14, 0xAF99, 0xB27E, 0xB5BF, 0xB95B, 0xBD