// -------------------------------------------------- //
// This file is autogenerated by pioasm; do not edit! //
// -------------------------------------------------- //

#pragma once

#if !PICO_NO_HARDWARE
#include "hardware/pio.h"
#endif

// --------------- //
// qspi_4wire_data //
// --------------- //

#define qspi_4wire_data_wrap_target 0
#define qspi_4wire_data_wrap 3
#define qspi_4wire_data_pio_version 0

static const uint16_t qspi_4wire_data_program_instructions[] = {
            //     .wrap_target
    0xf821, //  0: set    x, 1            side 1
    0x80a0, //  1: pull   block
    0x7004, //  2: out    pins, 4         side 0
    0x1842, //  3: jmp    x--, 2          side 1
            //     .wrap
};

#if !PICO_NO_HARDWARE
static const struct pio_program qspi_4wire_data_program = {
    .instructions = qspi_4wire_data_program_instructions,
    .length = 4,
    .origin = -1,
    .pio_version = qspi_4wire_data_pio_version,
#if PICO_PIO_VERSION > 0
    .used_gpio_ranges = 0x0
#endif
};

static inline pio_sm_config qspi_4wire_data_program_get_default_config(uint offset) {
    pio_sm_config c = pio_get_default_sm_config();
    sm_config_set_wrap(&c, offset + qspi_4wire_data_wrap_target, offset + qspi_4wire_data_wrap);
    sm_config_set_sideset(&c, 2, true, false);
    return c;
}
#endif

// --------------- //
// qspi_1write_cmd //
// --------------- //

#define qspi_1write_cmd_wrap_target 0
#define qspi_1write_cmd_wrap 3
#define qspi_1write_cmd_pio_version 0

static const uint16_t qspi_1write_cmd_program_instructions[] = {
            //     .wrap_target
    0xf827, //  0: set    x, 7            side 1
    0x80a0, //  1: pull   block
    0x7001, //  2: out    pins, 1         side 0
    0x1842, //  3: jmp    x--, 2          side 1
            //     .wrap
};

#if !PICO_NO_HARDWARE
static const struct pio_program qspi_1write_cmd_program = {
    .instructions = qspi_1write_cmd_program_instructions,
    .length = 4,
    .origin = -1,
    .pio_version = qspi_1write_cmd_pio_version,
#if PICO_PIO_VERSION > 0
    .used_gpio_ranges = 0x0
#endif
};

static inline pio_sm_config qspi_1write_cmd_program_get_default_config(uint offset) {
    pio_sm_config c = pio_get_default_sm_config();
    sm_config_set_wrap(&c, offset + qspi_1write_cmd_wrap_target, offset + qspi_1write_cmd_wrap);
    sm_config_set_sideset(&c, 2, true, false);
    return c;
}

#include "hardware/clocks.h"
#include "hardware/gpio.h"
static inline void qspi_4wire_data_program_init(PIO pio, uint sm, uint offset, uint pin_scl, uint out_base, uint out_pin_num) {
    pio_sm_config c = qspi_4wire_data_program_get_default_config( offset );  
    // CLK
    pio_gpio_init(pio, pin_scl);
    pio_sm_set_consecutive_pindirs(pio, sm, pin_scl, 1, true);
    sm_config_set_sideset_pins(&c, pin_scl);
    // DAT
    sm_config_set_out_pins(&c, out_base, out_pin_num);
    sm_config_set_out_shift(&c, false, false, 8);
    for (uint32_t pin_offset = 0; pin_offset < out_pin_num; pin_offset++) {
        pio_gpio_init(pio, out_base + pin_offset);
    }
    pio_sm_set_consecutive_pindirs(pio, sm, out_base, out_pin_num, true);
    // PIO CLK
    sm_config_set_clkdiv( &c, 1.0f);
    // INIT
    pio_sm_init( pio, sm, offset, &c );
    pio_sm_clear_fifos( pio , sm);
    pio_sm_set_enabled( pio, sm, true );
}
static inline void qspi_1write_cmd_program_init(PIO pio, uint sm, uint offset, uint pin_scl, uint out_base, uint out_pin_num) {
    pio_sm_config c = qspi_1write_cmd_program_get_default_config( offset );
    // CLK
    pio_gpio_init(pio, pin_scl);
    pio_sm_set_consecutive_pindirs(pio, sm, pin_scl, 1, true);
    sm_config_set_sideset_pins(&c, pin_scl);
    // DAT
    sm_config_set_out_pins(&c, out_base, out_pin_num);
    sm_config_set_out_shift(&c, false, false, 8);
    for (uint32_t pin_offset = 0; pin_offset < out_pin_num; pin_offset++) {
        pio_gpio_init(pio, out_base + pin_offset);
    }
    pio_sm_set_consecutive_pindirs(pio, sm, out_base, out_pin_num, true);
    // PIO CLK
    sm_config_set_clkdiv( &c, 1.0f);
    // INIT
    pio_sm_init( pio, sm, offset, &c );
    pio_sm_clear_fifos( pio , sm);
    pio_sm_set_enabled( pio, sm, true );
}

#endif

