#ifndef AUDIO_DATA_H
#define AUDIO_DATA_H

#include <stdint.h>

// Sampling rate: 24000Hz
// Bit Depth: 16bit
// Audio duration: 14.51s
const uint32_t AUDIO_SAMPLES = 348299;
const int16_t audio_data[] __attribute__((aligned(4))) = {
    0x0041, 0x0017, 0xFFE1, 0xFFED, 0xFFCB, 0xFFC9, 0xFFD1, 0xFFF5, 0x0048, 0x0065, 0x004F, 0x0033, 0x002C, 0xFFFA, 0xFFD0, 0x0012,
    0x0055, 0x003C, 0xFFFC, 0xFFA5, 0xFF87, 0xFF91, 0xFF79, 0xFF0A, 0xFEDF, 0xFEFB, 0xFEFD, 0xFF04, 0xFF67, 0xFFE2, 0x0020, 0x0031,
    0x0030, 0x0039, 0x005D, 0x0050, 0x0044, 0x004E, 0x002C, 0x001F, 0x001E, 0x001F, 0x0003, 0xFFB4, 0xFFB7, 0xFFF6, 0x001D, 0x002E,
    0x004B, 0x0064, 0x0067, 0x0099, 0x0094, 0x0086, 0x0060, 0x001F, 0x0023, 0x002D, 0x001A, 0x000A, 0x0045, 0x0044, 0x005A, 0x0080,
    0x0091, 0x006C, 0x0040, 0xFFF7, 0xFFC3, 0xFF95, 0xFF3C, 0xFEF7, 0xFEA3, 0xFE15, 0xFD8C, 0xFD40, 0xFDA4, 0xFF54, 0x01B9, 0x02CF,
    0x0270, 0x01E3, 0x016E, 0x0121, 0x00BF, 0x007B, 0x008F, 0x008C, 0x008B, 0x0082, 0x0055, 0x0004, 0xFFCF, 0xFF93, 0xFF64, 0xFF6C,
    0xFF35, 0xFF0F, 0xFF91, 0xFFE4, 0xFFD4, 0xFFB0, 0xFF72, 0xFF2D, 0xFF02, 0xFEF9, 0xFF35, 0xFFEB, 0x003B, 0xFFF8, 0x001E, 0x005F,
    0x007A, 0x00DC, 0x0187, 0x0211, 0x025E, 0x0230, 0x013F, 0x008A, 0x0064, 0x0032, 0xFFEF, 0xFFA5, 0xFFC1, 0xFFCF, 0xFFC1, 0xFFEC,
    0xFFFB, 0xFFFB, 0xFFED, 0xFFC9, 0xFFAE, 0xFF92, 0xFF8A, 0xFFAB, 0xFFCD, 0xFFAD, 0xFF83, 0xFF9B, 0xFFB9, 0xFFD1, 0x000C, 0x0036,
    0xFFD1, 0xFF94, 0xFF98, 0xFF78, 0xFFA9, 0xFFA8, 0xFF89, 0xFF9D, 0xFFD2, 0xFFF0, 0x0034, 0x0090, 0x00C4, 0x00DE, 0x0100, 0x00FE,
    0x0109, 0x0135, 0x00DA, 0x0013, 0xFF96, 0xFF7A, 0xFF40, 0xFF21, 0xFF3A, 0xFF47, 0xFF97, 0xFFE6, 0xFFEC, 0x0007, 0x003E, 0x002D,
    0xFFFB, 0xFFDB, 0xFFC0, 0xFFD4, 0x000E, 0x0019, 0x0003, 0xFFE6, 0xFFE8, 0xFFE7, 0xFFFB, 0x002A, 0x000B, 0xFFEF, 0x0023, 0x0032,
    0x002F, 0x001E, 0xFFEE, 0xFFF3, 0x0049, 0x0095, 0x007C, 0x002C, 0x0031, 0x0045, 0x0043, 0x0052, 0x0059, 0x0012, 0xFFDE, 0xFFBC,
    0xFFBA, 0xFFA0, 0xFF93, 0xFF59, 0xFF49, 0xFF5A, 0xFFA9, 0x0005, 0x0081, 0x00C4, 0x009D, 0x0086, 0x008B, 0x004F, 0x0022, 0x002B,
    0x0045, 0x0065, 0x004D, 0xFFE8, 0xFFAA, 0xFF97, 0xFF83, 0xFF7F, 0xFFA7, 0xFFC0, 0xFFC5, 0xFFEA, 0x0044, 0x0055, 0x0035, 0x0009,
    0x0011, 0x002B, 0x0027, 0x002B, 0x0058, 0x0069, 0x006D, 0x0064, 0x002F, 0x0017, 0x001E, 0x005D, 0x00A3, 0x00A9, 0x0071, 0x0022,
    0xFFF3, 0xFFFC, 0xFFE4, 0x0012, 0x006E, 0x0072, 0x0037, 0x003A, 0x003D, 0x001D, 0x0006, 0x0009, 0x0006, 0x0011, 0x0011, 0xFFE7,
    0x0000, 0x0025, 0xFFCA, 0xFF63, 0xFF71, 0xFF8A, 0xFFA3, 0xFFE2, 0xFFFA, 0xFFFB, 0xFFD7, 0xFF89, 0xFF69, 0xFF98, 0xFFEC, 0x004F,
    0x00B2, 0x0132, 0x011F, 0x0104, 0x00FE, 0x00BD, 0x00BA, 0x00D5, 0x00E3, 0x00A0, 0x0075, 0x007D, 0x0039, 0xFFD9, 0xFF97, 0xFF5A,
    0xFF1B, 0xFF5D, 0xFF89, 0xFF41, 0xFF30, 0xFF8A, 0xFFFF, 0x0053, 0x0045, 0x0034, 0xFFF5, 0xFFC4, 0xFFAF, 0xFFC8, 0x001C, 0x006B,
    0x0076, 0x006F, 0x0083, 0x00B3, 0x0104, 0x0123, 0x012C, 0x0135, 0x0147, 0x0178, 0x016E, 0x012D, 0x00BF, 0x0071, 0x0095, 0x00C9,
    0x00D3, 0x009C, 0x0071, 0x008E, 0x0088, 0x0047, 0xFFE9, 0xFF6D, 0xFF36, 0xFF46, 0xFF7A, 0xFFC3, 0xFFE6, 0x0005, 0x000B, 0xFFF2,
    0xFFE7, 0xFFDE, 0xFF9B, 0xFF95, 0xFF80, 0xFF70, 0xFF68, 0xFF71, 0xFF88, 0xFFA1, 0x001E, 0x0072, 0x006B, 0x000A, 0xFFC7, 0xFFC3,
    0xFFF9, 0x004D, 0x005D, 0x007C, 0x009B, 0x008B, 0x0066, 0x001D, 0xFFD2, 0xFFA5, 0xFF95, 0xFF87, 0xFFC0, 0x003A, 0x0072, 0x0062,
    0x0073, 0x0039, 0xFFDB, 0xFFE8, 0xFFD5, 0xFFD9, 0x0000, 0x002D, 0x0049, 0x0009, 0xFFCF, 0xFFC4, 0xFFE8, 0x004C, 0x006A, 0x004B,
    0x0025, 0x003D, 0x007A, 0x00A3, 0x00B0, 0x0052, 0xFFDE, 0xFFD8, 0x000A, 0x0010, 0x0038, 0x0049, 0x0039, 0xFFEE, 0xFFE3, 0x001C,
    0x001E, 0x0023, 0xFFFE, 0xFFF9, 0x0007, 0xFFF4, 0xFFD2, 0xFFCF, 0xFFE5, 0x0002, 0x0029, 0x0048, 0x0058, 0x0057, 0x0090, 0x0091,
    0x0067, 0x004F, 0x0067, 0x009C, 0x009C, 0x008B, 0x0072, 0x004E, 0x003B, 0x005E, 0x004B, 0x0029, 0xFFF0, 0xFF74, 0xFF46, 0xFF74,
    0xFF93, 0xFFAF, 0xFFE5, 0xFFC8, 0xFFCA, 0xFFF4, 0xFFF7, 0xFFDD, 0xFFC8, 0xFFB3, 0xFFFB, 0x0068, 0x0045, 0xFFEE, 0xFFDC, 0xFFA4,
    0xFFBA, 0x0005, 0x003D, 0x004A, 0x0037, 0x003A, 0x004F, 0x0046, 0x0052, 0x0042, 0x003F, 0x004B, 0x0086, 0x00AC, 0x009C, 0x004C,
    0xFFEF, 0xFFCA, 0xFFD5, 0xFFED, 0xFFDB, 0xFFC9, 0xFFBB, 0xFFB3, 0xFF9F, 0xFF4B, 0xFF33, 0xFF37, 0xFF42, 0xFF72, 0xFFA4, 0xFFD6,
    0x0012, 0x0038, 0x0060, 0x0061, 0x005A, 0x001B, 0xFFF1, 0x0019, 0x0050, 0x004D, 0x0036, 0x001F, 0x002F, 0x003A, 0x000A, 0xFFC5,
    0xFFBB, 0xFFAB, 0xFF67, 0xFF1C, 0xFF17, 0xFF13, 0xFF12, 0xFF4D, 0xFFAB, 0x0011, 0x005B, 0x0064, 0x0067, 0x008F, 0x00AC, 0x00AB,
    0x0090, 0x006E, 0x002B, 0xFFDF, 0xFFC6, 0xFFD0, 0xFFD5, 0xFFC4, 0xFFCB, 0x0009, 0x0077, 0x00C0, 0x00A8, 0x008C, 0x00AB, 0x00A4,
    0x0076, 0x005B, 0x0037, 0x0026, 0x000E, 0xFFE4, 0xFFBB, 0xFFBC, 0xFF9C, 0xFF5B, 0xFF5E, 0xFFA0, 0xFFC7, 0xFFB9, 0xFFC3, 0xFFD2,
    0xFFE9, 0xFFF5, 0xFFE3, 0xFFED, 0xFFF4, 0xFFF7, 0xFFD6, 0xFFAF, 0xFFAA, 0xFFC2, 0xFFFC, 0x001C, 0x0014, 0x0025, 0x0049, 0x0072,
    0x0081, 0x0081, 0x0095, 0x007F, 0x0099, 0x0077, 0x004B, 0x005C, 0x004B, 0x0031, 0x002D, 0x0034, 0x0044, 0x0045, 0x0022, 0xFFCA,
    0xFF53, 0xFF3B, 0xFF5D, 0xFFAA, 0x0021, 0x0018, 0x0010, 0x004C, 0x007C, 0x009E, 0x00A1, 0x0055, 0x0026, 0x003C, 0x0063, 0x004A,
    0x0006, 0xFFB2, 0xFF2E, 0xFE8C, 0xFE84, 0xFF3B, 0xFFD7, 0x0002, 0x006A, 0x009F, 0x006B, 0x0039, 0x001E, 0x0011, 0x0018, 0x0022,
    0x001C, 0x0020, 0x000B, 0xFFE2, 0xFFF8, 0x0039, 0x006B, 0x0076, 0x0062, 0x007A, 0x00BE, 0x00CE, 0x0092, 0x0074, 0x0040, 0x0007,
    0x0001, 0x0017, 0xFFEC, 0xFFC6, 0xFFB2, 0xFFA1, 0xFFC6, 0xFFC9, 0xFFA8, 0xFFA2, 0xFFB8, 0xFFD7, 0xFFF1, 0x0025, 0x0029, 0x000E,
    0x0025, 0x0010, 0xFFF9, 0xFFFD, 0xFFE7, 0xFFC8, 0xFFA7, 0xFFC2, 0xFFEE, 0xFFFD, 0x000A, 0xFFEA, 0xFFB3, 0xFF8D, 0xFF7C, 0xFF7E,
    0xFFC1, 0xFFFE, 0x004E, 0x009C, 0x00D2, 0x00ED, 0x00E7, 0x00C2, 0x005A, 0x0006, 0xFFF6, 0xFFF7, 0xFFCB, 0xFFAF, 0xFFD7, 0xFFD6,
    0xFFEB, 0xFFE4, 0xFFB9, 0xFFE5, 0xFFEC, 0xFFB4, 0xFFC3, 0x0000, 0x002B, 0x003C, 0x0047, 0x001E, 0x001E, 0x0037, 0xFFF1, 0xFFD7,
    0x0034, 0x0034, 0x0002, 0xFFBA, 0xFF92, 0xFF7C, 0xFF8C, 0xFFA6, 0xFF84, 0xFFC8, 0x004A, 0x0053, 0x002F, 0xFFDC, 0xFFE6, 0x004D,
    0x0084, 0x0094, 0x0073, 0x005B, 0x0046, 0x0012, 0xFFFF, 0xFFE8, 0x0005, 0x0044, 0x002F, 0xFFBC, 0xFFAE, 0xFFEB, 0xFFE5, 0xFFD5,
    0x000E, 0x0020, 0x0008, 0x002B, 0x0043, 0x0039, 0x0046, 0x0037, 0x0019, 0x0019, 0x0001, 0xFFC1, 0xFFE8, 0xFFF9, 0xFFDD, 0xFFF1,
    0x0017, 0x0048, 0x004C, 0x0042, 0x004D, 0x003D, 0x002B, 0x0027, 0x002F, 0x0020, 0x001F, 0x0021, 0x0026, 0x0026, 0x0005, 0x001D,
    0xFFF1, 0xFF9C, 0xFF67, 0xFFAA, 0xFFFD, 0xFFEC, 0x0033, 0x0098, 0x00AE, 0x007E, 0x004A, 0x0049, 0x003C, 0xFFD9, 0xFF6E, 0xFF02,
    0xFEE4, 0xFEEE, 0xFF0D, 0xFF87, 0xFFEA, 0x0008, 0x0061, 0x00AA, 0x0087, 0x003E, 0x0015, 0x003C, 0x0071, 0x0089, 0x0048, 0xFFF8,
    0xFFFB, 0x0019, 0x0003, 0xFFEA, 0xFFD5, 0xFFD1, 0xFFDB, 0xFFF5, 0xFFD7, 0xFFC3, 0xFFEA, 0xFFE2, 0xFFBC, 0xFFBA, 0xFFF1, 0xFFC7,
    0xFFA6, 0xFFA2, 0xFFB1, 0xFFD9, 0xFFE1, 0xFF9C, 0xFF90, 0xFF87, 0xFF58, 0xFF58, 0xFF60, 0xFF5B, 0xFF82, 0xFF94, 0xFFCB, 0x0032,
    0x0075, 0x0074, 0x0026, 0x0006, 0x0028, 0x0021, 0x000C, 0x0009, 0x0005, 0xFFE7, 0xFFD2, 0xFFAC, 0xFF66, 0xFF3D, 0xFF23, 0xFF48,
    0xFFB4, 0xFFEF, 0xFFFD, 0x001D, 0x0032, 0x006A, 0x00A8, 0x007D, 0x0036, 0xFFF7, 0xFFD6, 0xFFD5, 0xFFF1, 0xFFDE, 0xFFF4, 0x003D,
    0x0084, 0x0095, 0x00A9, 0x0095, 0x0068, 0x0062, 0x0070, 0x0048, 0x0024, 0x000D, 0xFFF8, 0xFFF1, 0xFFE8, 0xFFC4, 0xFF8A, 0xFF9A,
    0xFFAB, 0xFF82, 0xFF46, 0xFF29, 0xFF42, 0xFFB0, 0x0006, 0x003D, 0x0058, 0x0060, 0x005F, 0x0069, 0x0084, 0x007C, 0x005A, 0x0048,
    0x0039, 0x0027, 0xFFF5, 0xFFBC, 0xFF6C, 0xFF53, 0xFF5D, 0xFF4D, 0xFF58, 0xFF7B, 0xFFBD, 0xFFF7, 0x002C, 0x0045, 0x0014, 0xFFFE,
    0xFFFF, 0xFFEF, 0xFFDF, 0x0002, 0x003C, 0x004A, 0x0060, 0x000B, 0xFEFE, 0xFD53, 0xFBF8, 0xFB10, 0xFA68, 0xFA13, 0xF9CA, 0xF9AF,
    0xF982, 0xF935, 0xF8EE, 0xF81E, 0xF716, 0xF681, 0xF6CD, 0xF7F0, 0xFA9C, 0x001E, 0x069D, 0x09F7, 0x0A9A, 0x0B03, 0x0A06, 0x08A6,
    0x07A8, 0x069D, 0x0602, 0x0548, 0x0494, 0x03D9, 0x033F, 0x02EE, 0x02BF, 0x0280, 0x0243, 0x01CB, 0x0150, 0x0114, 0x00D6, 0x0083,
    0x0097, 0x00A7, 0x0068, 0x004F, 0x0083, 0x00C6, 0x0110, 0x0124, 0x0111, 0x00EA, 0x00DE, 0x00A4, 0x0068, 0x002C, 0xFF84, 0xFF67,
    0x0012, 0x0040, 0xFFF0, 0x002E, 0x008E, 0x0067, 0x004A, 0x0022, 0x0016, 0x0054, 0x0087, 0x00A7, 0x0065, 0x0022, 0x000A, 0xFFE1,
    0xFFA5, 0xFF81, 0xFF95, 0xFFAD, 0xFFAA, 0xFFBD, 0xFFB3, 0xFF89, 0xFFB3, 0xFFEF, 0xFFB8, 0xFFB0, 0xFFC5, 0xFFCF, 0xFFB9, 0xFF77,
    0xFF5B, 0xFF43, 0xFF16, 0xFEAA, 0xFE52, 0xFE96, 0xFF88, 0x0012, 0x0020, 0x0031, 0xFFF2, 0xFFAA, 0xFFCC, 0xFFCC, 0xFFB4, 0xFF82,
    0xFF7D, 0xFF81, 0xFF71, 0xFF71, 0xFF82, 0xFF7B, 0xFFB4, 0xFFB9, 0xFF77, 0xFFA5, 0xFFB5, 0xFF7B, 0xFF43, 0xFF16, 0xFF22, 0xFF37,
    0xFF57, 0xFF73, 0xFF61, 0xFF3F, 0xFF1B, 0xFF4A, 0xFF9D, 0xFF94, 0xFF85, 0xFF9E, 0xFF9E, 0xFF95, 0xFF73, 0xFF52, 0xFF3B, 0xFF15,
    0xFED3, 0xFEB2, 0xFEDE, 0xFF02, 0xFEF6, 0xFF20, 0xFFC2, 0xFFD1, 0xFFB5, 0xFFF6, 0x001D, 0x000F, 0x0023, 0x005F, 0x0097, 0x00AD,
    0x00C5, 0x00D4, 0x00DA, 0x00B4, 0x0047, 0x000F, 0xFFFF, 0xFFF5, 0xFFED, 0x001F, 0x0031, 0x0019, 0x0007, 0xFFEB, 0xFFDD, 0xFFF3,
    0xFFEE, 0xFFC3, 0xFFBF, 0xFFE7, 0xFFE7, 0xFFDE, 0xFFAC, 0xFF85, 0xFF9A, 0xFF99, 0xFFB2, 0xFFC6, 0xFFDC, 0xFFE1, 0xFFCA, 0x0011,
    0x0053, 0x008A, 0x008F, 0x0077, 0x0073, 0x004A, 0x0038, 0x0076, 0x007F, 0x0056, 0x0031, 0x0012, 0x0006, 0x0001, 0xFFB6, 0xFF4A,
    0xFF48, 0xFF97, 0xFFFF, 0x0013, 0x002B, 0x0035, 0x0035, 0x0030, 0x0000, 0xFFDD, 0xFFAD, 0xFF4F, 0xFF56, 0xFF61, 0xFF36, 0xFF1F,
    0xFF46, 0xFFAE, 0xFFE9, 0xFFE9, 0xFFFA, 0xFFE1, 0xFFB0, 0xFF7A, 0xFF72, 0xFF64, 0xFF74, 0xFFB4, 0x000E, 0x006C, 0x0092, 0x0090,
    0x00A7, 0x0085, 0x00A5, 0x00B3, 0x0068, 0x0062, 0x005E, 0x0023, 0x0012, 0x0009, 0xFFDB, 0xFFC6, 0xFFDA, 0xFFE6, 0xFFE5, 0xFFCD,
    0xFFB5, 0xFFC8, 0xFFDF, 0x001D, 0x005C, 0x0060, 0x003E, 0xFFFE, 0xFFDF, 0xFFF4, 0xFFF8, 0x0017, 0x003D, 0x0030, 0x0043, 0x0047,
    0x001D, 0x0021, 0x0028, 0x0031, 0x0013, 0xFFB3, 0xFFA2, 0xFFAC, 0xFFE6, 0x003D, 0x004F, 0x0066, 0x00E7, 0x0191, 0x0248, 0x0366,
    0x046E, 0x04BF, 0x0471, 0x0289, 0xFDE2, 0xF70E, 0xF065, 0xEC81, 0xEB7D, 0xEC21, 0xEEB0, 0xF098, 0xF181, 0xF3DA, 0xF8AC, 0x0191,
    0x0B31, 0x0E41, 0x0D40, 0x0CA8, 0x0B3D, 0x09E8, 0x08A9, 0x078E, 0x06BE, 0x05A8, 0x0508, 0x0473, 0x03D6, 0x032A, 0x025D, 0x01E8,
    0x0145, 0x012C, 0x0130, 0x012B, 0x0111, 0x00FD, 0x0110, 0x00AF, 0x00BB, 0x00D3, 0x011A, 0x0166, 0x015C, 0x013B, 0x00DA, 0x0065,
    0x003F, 0x0049, 0x0019, 0x000D, 0x0048, 0x003C, 0x006A, 0x008A, 0x007B, 0x0055, 0x0026, 0x0013, 0xFFC7, 0xFFD0, 0xFFA8, 0xFF8A,
    0xFFA9, 0xFF6B, 0xFF5E, 0xFF66, 0xFF34, 0xFEF2, 0xFEDF, 0xFECD, 0xFEFC, 0xFF71, 0xFF80, 0xFFB3, 0xFFD6, 0xFF7C, 0xFF90, 0xFFF9,
    0x0035, 0x0031, 0x0048, 0x0035, 0x0013, 0x002F, 0x004B, 0xFFF9, 0xFF98, 0xFF62, 0xFF53, 0xFF67, 0xFF43, 0xFF55, 0xFFAB, 0xFFB8,
    0xFF7B, 0xFF33, 0xFF34, 0xFF42, 0xFF24, 0xFF3E, 0xFF58, 0xFF56, 0xFF6E, 0xFF62, 0xFF2D, 0xFF16, 0xFF38, 0xFF56, 0xFF60, 0xFF8D,
    0xFFB8, 0xFFFE, 0x0000, 0xFFC7, 0xFFB1, 0xFF84, 0xFF50, 0xFF23, 0xFF3E, 0xFF74, 0xFF7C, 0xFF6C, 0xFF7B, 0xFFC1, 0xFFD4, 0xFF98,
    0xFF82, 0xFFBE, 0x0006, 0x0009, 0x003C, 0x004F, 0x0044, 0x003F, 0x002A, 0x002E, 0x003A, 0x005B, 0x0042, 0x0031, 0x0042, 0x003C,
    0x0022, 0xFFD3, 0xFFB6, 0xFFC5, 0xFFAE, 0xFF9A, 0xFF75, 0xFF5E, 0xFFC5, 0x0002, 0xFFF4, 0xFFD2, 0xFFBB, 0xFFB6, 0xFF7E, 0xFF63,
    0xFF8B, 0xFFA9, 0xFFC7, 0xFFA4, 0xFE7C, 0xFC83, 0xFB33, 0xFB99, 0xFDC5, 0x0017, 0x00B9, 0x00D8, 0x013C, 0x0167, 0x0168, 0x0110,
    0x00C3, 0x0105, 0x013F, 0x00F9, 0x00BB, 0x00E3, 0x00E5, 0x00CB, 0x009D, 0x003E, 0x0024, 0x0017, 0x000E, 0xFFF2, 0xFFD4, 0xFFC0,
    0xFFC7, 0xFFDD, 0xFFF0, 0xFFD2, 0xFFE9, 0x0001, 0xFFE3, 0xFFFA, 0x0032, 0x0020, 0xFFF6, 0xFFAF, 0xFF90, 0xFFBE, 0xFFED, 0x0010,
    0x002C, 0x0025, 0xFFEE, 0xFFE1, 0xFFF4, 0xFFC8, 0xFFBB, 0x0008, 0x004A, 0x002B, 0x0017, 0x0018, 0x0012, 0x001C, 0x0016, 0x0006,
    0x000F, 0x0003, 0xFFD5, 0xFFC2, 0xFFF2, 0x001F, 0x0000, 0xFFF7, 0xFFDA, 0xFF96, 0xFF9F, 0xFFB1, 0xFF88, 0xFF64, 0xFF87, 0xFFA8,
    0xFFBD, 0xFFC9, 0x0000, 0x003B, 0x0072, 0x006C, 0x0054, 0x002D, 0x0026, 0x001F, 0xFFF5, 0x0003, 0xFFFE, 0xFFFC, 0xFFD9, 0xFFA1,
    0xFFCD, 0xFFDD, 0xFFAF, 0xFF7F, 0xFF52, 0xFF93, 0xFFFE, 0x000A, 0xFFEC, 0xFFC0, 0xFFE8, 0x0017, 0x0023, 0x0042, 0x0008, 0xFFF9,
    0xFFF9, 0xFFB9, 0xFFA0, 0xFFA3, 0xFFC8, 0xFFC0, 0xFFA9, 0xFFC5, 0xFFC4, 0xFFAF, 0xFFBF, 0x0016, 0x0056, 0x006C, 0x0075, 0x0079,
    0x0094, 0x00A2, 0x006A, 0x0034, 0x004E, 0x005F, 0x001C, 0x0008, 0x0024, 0x0034, 0x001E, 0x0001, 0x0003, 0xFFFE, 0x0001, 0x0030,
    0x005F, 0x0058, 0x003C, 0x0023, 0x0011, 0xFFCB, 0xFF8B, 0xFFA6, 0xFFE2, 0xFFE5, 0xFFEC, 0x000A, 0x0010, 0x0015, 0x0022, 0x0037,
    0x0029, 0x0014, 0xFFFE, 0xFFE1, 0xFFEC, 0x002C, 0x0051, 0x005B, 0x0076, 0x005A, 0x0060, 0x007C, 0x0050, 0x0035, 0x0061, 0x007B,
    0x005A, 0x0077, 0x006D, 0x0046, 0x0062, 0x006B, 0x000B, 0xFFD5, 0xFFE2, 0xFFE2, 0xFFEE, 0x0016, 0x0018, 0x0024, 0x0022, 0x000F,
    0x0046, 0x0038, 0xFFD7, 0xFF57, 0xFE26, 0xFBC0, 0xF942, 0xF7B4, 0xF75C, 0xF8E8, 0xFC84, 0x00B1, 0x03A5, 0x046F, 0x03FE, 0x03D1,
    0x038A, 0x0310, 0x029E, 0x0244, 0x0201, 0x01A6, 0x014F, 0x0118, 0x00E0, 0x00CB, 0x0116, 0x0134, 0x00D3, 0x009D, 0x00C8, 0x00BD,
    0x0094, 0x0070, 0x0055, 0x0078, 0x008D, 0x0052, 0x0032, 0x001F, 0x000D, 0xFFAE, 0xFF9F, 0xFFEB, 0x0027, 0x0054, 0x0073, 0x008D,
    0x007B, 0x0076, 0x0049, 0x0048, 0x0060, 0x0030, 0xFFF1, 0xFFC2, 0xFF9C, 0xFFA3, 0xFFDA, 0xFFE9, 0xFFE7, 0x0009, 0x004B, 0x0043,
    0x0028, 0x0047, 0x0050, 0x002A, 0x0011, 0x002D, 0x002C, 0x001E, 0x000B, 0xFFFC, 0xFFD8, 0xFFC4, 0xFFB8, 0xFFAC, 0xFFC3, 0xFFC7,
    0xFF8A, 0xFF09, 0xFE48, 0xFD88, 0xFDB2, 0xFF33, 0x00BA, 0x00EA, 0x0111, 0x012D, 0x00CD, 0x00AB, 0x0061, 0x0027, 0x0010, 0x0013,
    0x000F, 0x0020, 0x0001, 0xFFD4, 0xFFA8, 0xFFA0, 0xFFCB, 0xFFFE, 0xFFEF, 0xFFC9, 0xFFAD, 0xFFCE, 0xFFF9, 0x0024, 0x0035, 0xFFFB,
    0xFFE6, 0xFFDB, 0xFFB2, 0xFFB0, 0xFFCF, 0xFFF3, 0xFFDD, 0xFFB8, 0xFFAB, 0xFFC1, 0xFFE7, 0xFFF8, 0x0004, 0x0004, 0xFFD8, 0xFFD9,
    0xFFE5, 0xFFFC, 0x000C, 0xFFE8, 0xFFCA, 0xFFE5, 0xFFDB, 0xFFE0, 0xFFDA, 0xFFB4, 0xFFA7, 0xFFAA, 0xFFDC, 0xFFE4, 0xFFF4, 0xFFE7,
    0xFFEB, 0xFFFB, 0xFFD6, 0xFFCF, 0x000C, 0x0017, 0x0002, 0x000A, 0xFFFB, 0xFFEE, 0x0002, 0xFFEB, 0xFFBB, 0xFFB0, 0xFFC6, 0x0011,
    0x0041, 0x003A, 0x0003, 0xFFF9, 0x0006, 0x0001, 0x0012, 0x0037, 0x0094, 0x0125, 0x0206, 0x0263, 0x019C, 0x003C, 0xFF54, 0xFF14,
    0xFEFB, 0xFF24, 0xFF23, 0xFF10, 0xFF2E, 0xFF4B, 0xFF62, 0xFF4C, 0xFF6B, 0xFFA4, 0xFFE0, 0x000D, 0x001E, 0x0015, 0xFFEC, 0xFFED,
    0xFFDF, 0xFFDE, 0xFFC4, 0xFF97, 0xFFA7, 0xFFD9, 0xFFD2, 0xFFBC, 0xFFCB, 0xFFF7, 0x003B, 0x004C, 0x0057, 0x0039, 0x001F, 0xFFF3,
    0xFFDD, 0xFFE2, 0x0007, 0x002B, 0x0032, 0x0000, 0x0001, 0x0040, 0x005F, 0x0039, 0xFFFD, 0xFFE1, 0xFFE3, 0xFFF2, 0x000C, 0x0059,
    0x00EA, 0x0116, 0x0088, 0xFFD5, 0xFFE5, 0x004D, 0x0057, 0x0012, 0xFFCC, 0xFF86, 0xFF71, 0xFF90, 0xFFB0, 0xFFCB, 0xFFFF, 0x002C,
    0x0060, 0x0062, 0x002E, 0x0025, 0x0029, 0xFFBC, 0xFF72, 0xFFA3, 0xFFB3, 0xFFCD, 0xFFF5, 0x0000, 0x0000, 0x0002, 0x0006, 0xFFE9,
    0xFFEC, 0x0029, 0x0035, 0x002C, 0x0024, 0x002E, 0x0015, 0xFFF4, 0x0004, 0x000A, 0x001B, 0xFFFD, 0x0006, 0x0026, 0x0001, 0xFFDC,
    0xFFE7, 0xFFEF, 0xFFD0, 0xFFAF, 0xFFDE, 0xFFEB, 0xFFEC, 0xFFF8, 0x000D, 0xFFF4, 0xFFD6, 0xFFCF, 0xFFD8, 0xFFFE, 0x002E, 0x0031,
    0x0002, 0xFFF2, 0xFFFD, 0x002A, 0x0053, 0x00A0, 0x00FF, 0x00F9, 0x00EC, 0x0198, 0x023B, 0x01BF, 0xFFF3, 0xFDF5, 0xFC9C, 0xFC65,
    0xFC9E, 0xFCAF, 0xFDA9, 0xFE9D, 0xFEA4, 0xFF65, 0x0048, 0x00E0, 0x0137, 0x0153, 0x0168, 0x0112, 0x00D6, 0x00B7, 0x0084, 0x002A,
    0xFFF1, 0xFFAD, 0xFF38, 0xFF30, 0x000D, 0x00FA, 0x015F, 0x0144, 0x00EF, 0x00AA, 0x008C, 0x006A, 0x0078, 0x00B0, 0x00FE, 0x014B,
    0x012B, 0x008E, 0x0017, 0x0008, 0x003A, 0x004A, 0x003A, 0x0041, 0x0036, 0x0038, 0x0055, 0x003E, 0x003D, 0x0059, 0x003D, 0x000A,
    0x0000, 0x0007, 0x001A, 0x001F, 0x000E, 0x0029, 0x0049, 0x0057, 0x0049, 0x002F, 0x0075, 0x00D3, 0x00FA, 0x00E5, 0x00A5, 0x0059,
    0x0062, 0x0079, 0x0099, 0x007C, 0x001E, 0xFFFD, 0x0004, 0x0012, 0xFFD1, 0xFFBD, 0x000C, 0x0025, 0x003B, 0x0052, 0x0027, 0x0019,
    0x000B, 0x0020, 0x0036, 0x0047, 0x0056, 0x0079, 0x0071, 0x003C, 0x0018, 0xFFDA, 0xFF99, 0xFF94, 0xFF92, 0xFF72, 0xFF32, 0xFF3F,
    0xFFB5, 0x0003, 0x0034, 0x005A, 0x002E, 0x0003, 0x0011, 0x002B, 0x0030, 0x002E, 0x0033, 0x0036, 0x0045, 0x006A, 0x009F, 0x00AD,
    0x0078, 0x004C, 0x005F, 0x0072, 0x0033, 0xFFD9, 0xFFE3, 0xFFD7, 0xFFA2, 0xFFF6, 0x0033, 0x0029, 0x0044, 0x005E, 0x002F, 0xFFF2,
    0xFFB5, 0xFF7C, 0xFF4A, 0xFF46, 0xFF60, 0xFFB3, 0x0001, 0xFFE5, 0xFFC5, 0xFFBD, 0xFFC2, 0xFFD4, 0xFFD5, 0xFFD4, 0xFFD3, 0x0021,
    0x0053, 0x0035, 0x0043, 0x0065, 0x004E, 0x0016, 0x0014, 0x0013, 0x0007, 0x0016, 0x0012, 0xFFE8, 0xFFE9, 0xFFE5, 0xFFC9, 0xFFB1,
    0xFFCE, 0xFFD6, 0xFFC2, 0xFFE2, 0xFFF7, 0xFFDF, 0xFFEB, 0xFFFF, 0x000C, 0x001A, 0x0047, 0x005C, 0x0030, 0x0012, 0xFFF6, 0xFFCD,
    0xFF7D, 0xFEC3, 0xFE13, 0xFD18, 0xFC00, 0xFC01, 0xFE63, 0x017C, 0x0224, 0x01D1, 0x01D0, 0x016D, 0x0174, 0x013A, 0x00E6, 0x00FA,
    0x00EF, 0x00C3, 0x0076, 0x004B, 0x005F, 0x0074, 0x0084, 0x0098, 0x00BF, 0x00A5, 0x00C8, 0x00F4, 0x00D5, 0x008F, 0x005D, 0x0021,
    0xFFEA, 0xFFFD, 0x002A, 0x0065, 0x0055, 0x004D, 0x0032, 0xFFDD, 0xFFB4, 0xFFDE, 0xFFBE, 0xFF7C, 0xFF57, 0xFF64, 0xFF73, 0xFFC5,
    0xFFEE, 0x0007, 0x000A, 0x0022, 0x003C, 0x0047, 0x0021, 0x0017, 0x0032, 0x004B, 0x0060, 0x0060, 0x0048, 0x0032, 0x0040, 0x003E,
    0x0025, 0x0011, 0xFFF9, 0x0005, 0xFFF1, 0xFFE5, 0xFFFE, 0xFFE8, 0xFFC6, 0xFFC3, 0xFFCB, 0xFF98, 0xFF95, 0xFF8B, 0xFF6D, 0xFFA6,
    0xFFD5, 0xFFE4, 0x0013, 0x001B, 0x0030, 0x004E, 0x0029, 0x0016, 0x003B, 0x008C, 0x00B1, 0x0070, 0x000A, 0xFFB9, 0xFF72, 0xFF74,
    0xFF96, 0xFF99, 0xFF84, 0xFF74, 0xFF92, 0xFFDC, 0x0014, 0x0014, 0xFFF4, 0xFFE5, 0xFFC1, 0xFFAE, 0x0006, 0x0023, 0xFFB7, 0xFF96,
    0xFFAC, 0xFFC9, 0xFF9F, 0xFF8B, 0xFFA9, 0xFFEC, 0x000D, 0xFFDE, 0xFFC4, 0xFFAD, 0xFFD6, 0xFFF9, 0xFFF2, 0xFFE5, 0x0001, 0x004D,
    0x005C, 0x0057, 0x0037, 0x001A, 0x0005, 0xFFDC, 0xFFC3, 0xFFD7, 0xFFDB, 0xFFBB, 0xFFAA, 0xFF9E, 0xFFC9, 0x000D, 0x001C, 0x000F,
    0x0009, 0x000B, 0x0037, 0x002C, 0x0004, 0xFFFB, 0x0004, 0xFFE5, 0xFFE5, 0x001C, 0x002D, 0x0012, 0x002F, 0x005B, 0x005E, 0x004A,
    0x0039, 0x001F, 0x0017, 0xFFFE, 0xFFE2, 0x0018, 0x0072, 0x008B, 0x0089, 0x0088, 0x0043, 0x0013, 0xFFDA, 0xFFCB, 0x0013, 0x004A,
    0x0034, 0x0015, 0x0022, 0x0026, 0x0036, 0x0037, 0x0019, 0x0007, 0x001E, 0xFFFE, 0xFFE2, 0xFFE1, 0xFFF5, 0xFFF0, 0xFFE5, 0x0008,
    0x001D, 0x001C, 0x0007, 0xFFFC, 0xFFEC, 0xFFE3, 0xFFF8, 0xFFE9, 0xFFC9, 0xFFD8, 0xFFF2, 0xFFFD, 0x003C, 0x0041, 0x000F, 0xFFEF,
    0x002A, 0x0031, 0x0028, 0x0049, 0x002B, 0xFFF5, 0xFFD7, 0xFFA1, 0xFFA8, 0xFFB1, 0xFFC3, 0xFFEF, 0x0007, 0x0006, 0x0007, 0x002A,
    0x0022, 0x001A, 0x0021, 0x001F, 0x000B, 0x000D, 0x002C, 0x005C, 0x0062, 0x004D, 0x001C, 0xFFF7, 0x000F, 0x002E, 0x0017, 0xFFF4,
    0xFFAC, 0xFF9F, 0xFFA6, 0xFF7C, 0xFF3E, 0xFF53, 0xFFC6, 0xFFF3, 0xFFE4, 0x0002, 0x000A, 0x002F, 0x0050, 0x0016, 0xFFFF, 0x0010,
    0xFFF9, 0xFFFE, 0xFFFE, 0xFFEF, 0xFFBE, 0xFFD1, 0xFFDA, 0xFFC5, 0xFFF4, 0x0023, 0x0039, 0x0039, 0x006B, 0x0065, 0x005B, 0x004C,
    0x0012, 0xFFF3, 0x0012, 0x0025, 0x0050, 0x00A3, 0x00A3, 0x001A, 0xFFBA, 0xFFD3, 0xFFD9, 0x000F, 0x003F, 0x004F, 0x0073, 0x0054,
    0x0043, 0x005F, 0x0071, 0x0054, 0x002C, 0x0014, 0x0031, 0x0047, 0x004D, 0x0053, 0x0054, 0x0053, 0x004D, 0x0034, 0x0033, 0x002C,
    0x0024, 0x001B, 0xFFFA, 0xFFCF, 0xFFAB, 0xFF90, 0xFF86, 0xFFAD, 0xFFCD, 0xFFFA, 0xFFE8, 0xFFDF, 0xFFD5, 0xFFB4, 0xFFAD, 0xFFCB,
    0xFFC3, 0xFFDE, 0x000E, 0x001C, 0x0043, 0x00AA, 0x00FF, 0x0121, 0x0134, 0x0113, 0x00A4, 0x001A, 0xFFF9, 0xFFE8, 0xFFE1, 0xFFD8,
    0xFFEE, 0x000C, 0xFFF2, 0xFFE4, 0xFFCD, 0xFFD6, 0xFFE0, 0xFFF8, 0x0012, 0x000B, 0xFFFE, 0xFFF4, 0xFFEF, 0xFFE4, 0xFFFD, 0x000B,
    0x0014, 0x001E, 0x0014, 0xFFFD, 0xFFC9, 0xFFBC, 0xFFAE, 0xFFA7, 0xFFE9, 0xFFF7, 0xFFC2, 0xFFB9, 0x0001, 0x0017, 0x0016, 0x0014,
    0xFFE6, 0xFF98, 0xFF81, 0xFF91, 0xFFA8, 0xFFEE, 0x0001, 0xFFFC, 0xFFEA, 0xFFC1, 0xFFCC, 0x0014, 0x0024, 0x0011, 0x0028, 0x001E,
    0xFFFA, 0x0004, 0x000D, 0xFFFC, 0xFFE0, 0xFFB3, 0xFF88, 0xFFA1, 0xFFC9, 0xFFD3, 0xFFCE, 0xFFC0, 0xFFBF, 0xFFD3, 0xFFEE, 0xFFFE,
    0x000A, 0xFFF7, 0x0003, 0xFFF4, 0xFFC5, 0xFF9C, 0xFF97, 0xFFCA, 0x0005, 0x000D, 0x0024, 0x006B, 0x008F, 0x0065, 0x0042, 0x003E,
    0x002B, 0x0017, 0xFFFE, 0xFFD2, 0xFFC8, 0xFFE1, 0xFFD1, 0xFF8C, 0xFF5C, 0xFF82, 0xFFEC, 0x0067, 0x009A, 0x0063, 0x005B, 0x006D,
    0x006E, 0x005D, 0x003E, 0x002B, 0x003A, 0x0052, 0x0059, 0x006B, 0x0055, 0x0033, 0x0026, 0x0046, 0x0060, 0x006B, 0x0062, 0x0050,
    0x004B, 0x0056, 0x0050, 0x003A, 0x001D, 0x0023, 0x002F, 0x0031, 0x004E, 0x0079, 0x0066, 0x0062, 0x0059, 0x004C, 0x004F, 0x0038,
    0x000D, 0xFFE2, 0xFFE8, 0x0037, 0x0057, 0x0065, 0x0067, 0x004A, 0x0031, 0x0031, 0x0029, 0x0013, 0xFFE5, 0xFFA9, 0x0024, 0x00BE,
    0x008E, 0x0044, 0x0033, 0xFFF7, 0xFFDF, 0xFFDC, 0xFFD3, 0xFFCD, 0xFFE0, 0xFFF5, 0xFFDF, 0xFFAE, 0xFF08, 0xFD75, 0xFB04, 0xF87D,
    0xF6DB, 0xF717, 0xFAC2, 0x0117, 0x049C, 0x04AB, 0x04AD, 0x045B, 0x03B9, 0x037C, 0x030D, 0x029A, 0x01FB, 0x0199, 0x012F, 0x00C8,
    0x00FC, 0x011D, 0x0124, 0x0105, 0x00FD, 0x0139, 0x01AE, 0x016C, 0x00DC, 0x00D5, 0x0074, 0x002F, 0x0038, 0x0004, 0x000E, 0x0024,
    0x001C, 0x0012, 0xFFF8, 0xFFA9, 0xFF47, 0xFEF0, 0xFE8D, 0xFF33, 0x003E, 0x00AB, 0x00A1, 0x009A, 0x00A3, 0x0099, 0x0084, 0x0078,
    0x004B, 0x0054, 0x0052, 0x0040, 0x003B, 0x0047, 0x0047, 0x0025, 0x0002, 0x000D, 0x0014, 0x0016, 0x0029, 0x000E, 0x000A, 0x001E,
    0x0017, 0x0015, 0x000D, 0x000D, 0x0011, 0x0025, 0x002F, 0x001B, 0x0027, 0x0028, 0x0018, 0x001F, 0x0014, 0xFFFC, 0xFFFC, 0x0005,
    0xFFF6, 0xFFF5, 0xFFEF, 0xFFF2, 0x0002, 0x000D, 0x0009, 0xFFFA, 0x000B, 0xFFFF, 0xFFFA, 0x0000, 0xFFEC, 0xFFEC, 0xFFFB, 0x0003,
    0xFFF8, 0x0011, 0x0016, 0xFFFD, 0x0008, 0x0007, 0xFFF4, 0xFFEF, 0xFFF2, 0xFFF0, 0xFFEB, 0xFFF5, 0xFFF6, 0xFFDF, 0xFFE4, 0xFFED,
    0xFFEE, 0xFFE9, 0xFFE8, 0xFFE0, 0xFFEF, 0xFFDA, 0xFFDD, 0xFFDF, 0xFFEB, 0xFFDB, 0xFFDA, 0xFFDE, 0xFFD5, 0xFFC1, 0xFFC3, 0xFFD1,
    0xFFBE, 0xFFDD, 0x000C, 0x00B0, 0x01F6, 0x034C, 0x0430, 0x0477, 0x03FF, 0x0281, 0xFF9E, 0xFCF9, 0xFCD3, 0xFD27, 0xFD5B, 0xFDD3,
    0xFDFA, 0xFE42, 0xFE84, 0xFEA5, 0xFED7, 0xFEE1, 0xFF11, 0xFF3E, 0xFF53, 0xFF63, 0xFF5E, 0xFF70, 0xFF7E, 0xFFAB, 0x000F, 0x006A,
    0xFFD8, 0xFEB8, 0xFE2A, 0xFE2B, 0xFECE, 0xFFAE, 0x0039, 0x0045, 0x0062, 0x0052, 0x003E, 0x0048, 0x0035, 0x0011, 0xFFBA, 0xFF4E,
    0xFF21, 0xFE63, 0xFD85, 0xFDE4, 0xFF90, 0x0131, 0x01ED, 0x01B0, 0x0119, 0x00AE, 0x00A7, 0x0093, 0x0081, 0x0057, 0x005C, 0x0054,
    0x002A, 0x001D, 0x0021, 0x0009, 0x000A, 0x0019, 0x0016, 0x0011, 0x0017, 0x000D, 0x0017, 0x0017, 0x0009, 0xFFFE, 0x0009, 0x0005,
    0xFFEC, 0x0003, 0x0002, 0x0003, 0x0018, 0x000A, 0xFFF5, 0xFFED, 0xFFFF, 0xFFF4, 0xFFFC, 0x0016, 0xFFEC, 0xFFE8, 0xFFEA, 0xFFE1,
    0xFFDD, 0xFFE0, 0xFFCD, 0xFFB9, 0xFF84, 0xFFAE, 0x00BA, 0x01DA, 0x00D2, 0xFE0D, 0xFD07, 0xFE1D, 0xFE72, 0xFF36, 0x0087, 0x003F,
    0x0042, 0x006F, 0x0041, 0x0053, 0x002D, 0x002B, 0x000A, 0x000A, 0x001B, 0xFFF3, 0x0014, 0xFFFE, 0xFFFB, 0xFFF3, 0xFFF0, 0xFFDF,
    0xFFDF, 0xFFE6, 0xFFD6, 0xFFD2, 0xFFD3, 0xFFCD, 0xFFAA, 0xFF88, 0xFF9B, 0xFFC9, 0xFFD9, 0xFFD1, 0xFFB1, 0xFF80, 0xFF97, 0xFFBB,
    0xFFD3, 0xFFD2, 0xFFD9, 0xFFC9, 0xFFD6, 0xFFC0, 0xFFBE, 0xFFB6, 0xFFC2, 0xFFB1, 0xFFAD, 0xFFC9, 0xFFC7, 0xFFBB, 0xFFB7, 0xFFBA,
    0xFFB9, 0xFFB6, 0xFFA3, 0xFFA0, 0xFFB2, 0xFFA6, 0xFF9E, 0xFFA8, 0xFF9B, 0xFF8E, 0xFF93, 0xFFA4, 0xFF9F, 0xFFA0, 0xFFBC, 0xFFAA,
    0xFF82, 0xFF87, 0xFF84, 0xFF74, 0xFF81, 0xFF7F, 0xFF83, 0xFF99, 0xFF97, 0xFF88, 0xFF7F, 0xFF90, 0xFF79, 0xFF80, 0xFF87, 0xFF80,
    0xFF77, 0xFF86, 0xFF8E, 0xFF80, 0xFF8F, 0xFF80, 0xFF89, 0xFF93, 0xFF81, 0xFF7D, 0xFF88, 0xFF84, 0xFF7B, 0xFF8A, 0xFF9E, 0xFFA0,
    0xFFA7, 0xFFB3, 0xFFA1, 0xFFA0, 0xFF9B, 0xFF8E, 0xFF7F, 0xFF9C, 0xFFA2, 0xFF8D, 0xFF98, 0xFFAB, 0xFF89, 0xFF8E, 0xFF99, 0xFF87,
    0xFF80, 0xFF81, 0xFFA1, 0xFF96, 0xFFA9, 0xFFA0, 0xFF92, 0xFFA2, 0xFF9F, 0xFF92, 0xFF8E, 0xFF9B, 0xFF9C, 0xFF60, 0xFEB2, 0xFE1B,
    0xFE6C, 0xFF76, 0xFFE1, 0xFFD0, 0xFFF1, 0xFFDA, 0xFFD4, 0xFFD2, 0xFFA9, 0xFF63, 0xFF22, 0xFF86, 0xFFC8, 0xFFAF, 0xFFD1, 0xFFD9,
    0xFFD3, 0xFFD5, 0xFF92, 0xFF7A, 0xFF85, 0xFF69, 0xFF72, 0xFF7B, 0xFF86, 0xFF7A, 0xFF7B, 0xFF7D, 0xFF7E, 0xFF87, 0xFF98, 0xFF8E,
    0xFF96, 0xFF86, 0xFF6F, 0xFF67, 0xFF82, 0xFF7A, 0xFF79, 0xFF8B, 0xFF79, 0xFF6F, 0xFF80, 0xFF86, 0xFF6B, 0xFF6B, 0xFF70, 0xFF66,
    0xFF67, 0xFF83, 0xFF72, 0xFF5D, 0xFF66, 0xFF72, 0xFF8C, 0xFF8E, 0xFF80, 0xFF7E, 0xFF73, 0xFF81, 0xFF78, 0xFF85, 0xFF83, 0xFF74,
    0xFF84, 0xFF96, 0xFF85, 0xFF80, 0xFF92, 0xFF86, 0xFF84, 0xFF9C, 0xFF92, 0xFF9C, 0xFFA6, 0xFF90, 0xFF7B, 0xFF74, 0xFF77, 0xFF6D,
    0xFF69, 0xFF68, 0xFF6C, 0xFF79, 0xFF8C, 0xFF87, 0xFF7E, 0xFF8E, 0xFF92, 0xFF84, 0xFF85, 0xFF89, 0xFF7C, 0xFF8E, 0xFF95, 0xFF93,
    0xFF9E, 0xFFB2, 0xFF9F, 0xFFA7, 0xFFAC, 0xFF86, 0xFF8E, 0xFF9E, 0xFF8F, 0xFF90, 0xFF90, 0xFF8E, 0xFFEC, 0x00A1, 0x007E, 0xFFC4,
    0xFED9, 0xFAC0, 0xF0DC, 0xE603, 0xDF4C, 0xDD62, 0xE082, 0xE6B7, 0xF1DB, 0x0278, 0x1126, 0x15AE, 0x1370, 0x124E, 0x0FFB, 0x0D79,
    0x0C1F, 0x09EE, 0x08C5, 0x0760, 0x0673, 0x0594, 0x04B7, 0x0445, 0x0375, 0x0344, 0x02D0, 0x0290, 0x022F, 0x01F4, 0x01A1, 0x0144,
    0x0126, 0x0100, 0x00EB, 0x00D1, 0x009E, 0x0083, 0x0059, 0x005E, 0x002E, 0x0024, 0x0017, 0xFFF3, 0xFFE6, 0xFFD1, 0xFFB6, 0xFF91,
    0xFFA4, 0xFF9C, 0xFF67, 0xFF61, 0xFF82, 0xFF80, 0xFF78, 0xFF66, 0xFF5B, 0xFF62, 0xFF3C, 0xFF24, 0xFF35, 0xFF33, 0xFF1A, 0xFF16,
    0xFF16, 0xFF06, 0xFF05, 0xFF0C, 0xFF05, 0xFF0A, 0xFF10, 0xFEFE, 0xFEE1, 0xFED9, 0xFEE1, 0xFEDF, 0xFEE1, 0xFEEE, 0xFED1, 0xFEB3,
    0xFED3, 0xFEE8, 0xFEE2, 0xFEEE, 0xFEEC, 0xFEDE, 0xFEC5, 0xFECB, 0xFEBC, 0xFEB4, 0xFEB8, 0xFEC5, 0xFEC7, 0xFED2, 0xFED8, 0xFED0,
    0xFED8, 0xFECA, 0xFEC6, 0xFEC4, 0xFEC0, 0xFECC, 0xFED9, 0xFECA, 0xFECA, 0xFEC9, 0xFED2, 0xFECF, 0xFECA, 0xFEDC, 0xFEE4, 0xFED3,
    0xFEDB, 0xFEF6, 0xFF00, 0xFF0D, 0xFF22, 0xFF16, 0xFF17, 0xFF08, 0xFF06, 0xFF13, 0xFF11, 0xFF0A, 0xFF19, 0xFF17, 0xFF0A, 0xFEFD,
    0xFF1E, 0xFF0E, 0xFEFA, 0xFF04, 0xFF11, 0xFF09, 0xFF0C, 0xFF15, 0xFF0B, 0xFF22, 0xFF19, 0xFF00, 0xFF0E, 0xFF13, 0xFF31, 0xFF26,
    0xFF2B, 0xFF2C, 0xFF1B, 0xFF1F, 0xFF0D, 0xFEF1, 0xFEFC, 0xFF14, 0xFF01, 0xFEF4, 0xFEF4, 0xFEF0, 0xFEE7, 0xFEFA, 0xFEE1, 0xFEE4,
    0xFEF1, 0xFEDD, 0xFED8, 0xFED1, 0xFEF6, 0xFF02, 0xFF0D, 0xFF20, 0xFF18, 0xFF2F, 0xFF2F, 0xFF2D, 0xFF10, 0xFF28, 0xFF23, 0xFF40,
    0xFF4A, 0xFF39, 0xFF45, 0xFF31, 0xFF41, 0xFF3B, 0xFF3A, 0xFF47, 0xFF31, 0xFF5A, 0xFF78, 0xFF6B, 0xFF5F, 0xFF65, 0xFF61, 0xFF5A,
    0xFF53, 0xFF4F, 0xFF3D, 0xFF38, 0xFF3B, 0xFF28, 0xFF22, 0xFF12, 0xFF14, 0xFF07, 0xFF1E, 0xFF1D, 0xFF27, 0xFF35, 0xFF26, 0xFF38,
    0xFF4F, 0xFF54, 0xFF4A, 0xFF5B, 0xFF66, 0xFF5A, 0xFF58, 0xFF48, 0xFF3D, 0xFF33, 0xFF28, 0xFF1F, 0xFF16, 0xFF16, 0xFF00, 0xFF08,
    0xFF15, 0xFEFE, 0xFEF5, 0xFEFA, 0xFEFA, 0xFEF8, 0xFEE5, 0xFEDF, 0xFED8, 0xFEF2, 0xFEEC, 0xFEDB, 0xFEDC, 0xFEE7, 0xFED2, 0xFED1,
    0xFEE2, 0xFEEA, 0xFEE5, 0xFEEF, 0xFEF9, 0xFF03, 0xFF1B, 0xFF27, 0xFF29, 0xFF24, 0xFF3B, 0xFF45, 0xFF61, 0xFF70, 0xFF7D, 0xFF88,
    0xFFA8, 0xFFB8, 0xFFB0, 0xFFD6, 0xFFCC, 0xFFC4, 0xFFBF, 0xFFB0, 0xFFBE, 0xFFDD, 0xFFF2, 0x0011, 0x0029, 0x0060, 0x006A, 0x007C,
    0x009C, 0x00BC, 0x00BE, 0x00DC, 0x00DD, 0x00DD, 0x0104, 0x0101, 0x0109, 0x012D, 0x013E, 0x0120, 0x0124, 0x0130, 0x0125, 0x0126,
    0x0148, 0x015A, 0x0162, 0x017C, 0x017C, 0x0199, 0x01B1, 0x01AC, 0x01A9, 0x01C9, 0x01D3, 0x01CB, 0x01E9, 0x01F0, 0x01D3, 0x01E3,
    0x01E0, 0x01D9, 0x01E5, 0x0211, 0x023F, 0x0280, 0x027C, 0x0218, 0x01DB, 0x01DA, 0x01CD, 0x01C1, 0x01D3, 0x01EF, 0x01E4, 0x01ED,
    0x01F3, 0x01EA, 0x01FA, 0x0204, 0x020E, 0x021A, 0x0222, 0x0214, 0x0206, 0x0211, 0x0206, 0x020C, 0x0222, 0x0219, 0x020C, 0x021E,
    0x0214, 0x020F, 0x021B, 0x0223, 0x023E, 0x0261, 0x024B, 0x024B, 0x023B, 0x0251, 0x024B, 0x0240, 0x024D, 0x023D, 0x0237, 0x023A,
    0x023A, 0x0242, 0x0231, 0x0246, 0x0252, 0x024C, 0x0279, 0x02B1, 0x030D, 0x0334, 0x02DD, 0x024A, 0x021B, 0x0216, 0x021C, 0x023D,
    0x0242, 0x0236, 0x023F, 0x0246, 0x0249, 0x025A, 0x0268, 0x0257, 0x0243, 0x026A, 0x0269, 0x0261, 0x026B, 0x0263, 0x0268, 0x0275,
    0x027C, 0x027C, 0x0269, 0x0271, 0x0268, 0x0261, 0x0261, 0x027C, 0x0285, 0x0286, 0x0287, 0x0253, 0x0215, 0x01FD, 0x0209, 0x024C,
    0x0290, 0x02C1, 0x02C5, 0x02D5, 0x02BC, 0x02BD, 0x02F2, 0x02E2, 0x02C2, 0x02D4, 0x02C9, 0x02B4, 0x02B8, 0x02A2, 0x02A9, 0x02BA,
    0x02BF, 0x02CA, 0x02C5, 0x02AE, 0x02B7, 0x02AC, 0x02AB, 0x029F, 0x029E, 0x02AD, 0x02AA, 0x0292, 0x0273, 0x029A, 0x029A, 0x029D,
    0x02B4, 0x02AA, 0x02BF, 0x02C1, 0x02C5, 0x02B2, 0x02B2, 0x02AD, 0x02A7, 0x02B9, 0x02A7, 0x028D, 0x028A, 0x0299, 0x0280, 0x0281,
    0x0265, 0x026B, 0x026A, 0x027E, 0x0267, 0x025C, 0x0275, 0x024E, 0x025A, 0x0250, 0x0241, 0x024C, 0x0252, 0x0220, 0x01D9, 0x0166,
    0x0190, 0x0220, 0x0271, 0x02AC, 0x02A2, 0x02A3, 0x028C, 0x02BA, 0x0393, 0x055C, 0x067F, 0x064B, 0x0598, 0x0423, 0x021E, 0x005C,
    0xFF9E, 0xFFCC, 0xFFFF, 0x005F, 0x007D, 0x00AA, 0x00C7, 0x00D9, 0x0102, 0x012E, 0x015F, 0x014B, 0x0160, 0x015F, 0x0142, 0x014B,
    0x0146, 0x0129, 0x0155, 0x0178, 0x0159, 0x0167, 0x0187, 0x0185, 0x0160, 0x013F, 0x0124, 0x0112, 0x010D, 0x0112, 0x00F7, 0x00EF,
    0x00F0, 0x0106, 0x0120, 0x010B, 0x00E3, 0x00D5, 0x00C6, 0x00C0, 0x0092, 0x0056, 0x0030, 0x0042, 0x007F, 0x00AF, 0x00CA, 0x00D4,
    0x00D3, 0x00AD, 0x009C, 0x00A0, 0x0092, 0x0090, 0x008D, 0x006D, 0x004F, 0x004A, 0x003B, 0x0038, 0x0050, 0x0059, 0x003A, 0x0030,
    0x0020, 0x0011, 0x002A, 0x0028, 0x0027, 0x002E, 0x0027, 0x0014, 0x000D, 0x0003, 0xFFDC, 0xFFCE, 0xFFD0, 0xFFD5, 0xFFE7, 0xFFD5,
    0xFFD3, 0xFFAF, 0xFFAF, 0xFFA9, 0xFF85, 0xFF82, 0xFFA4, 0xFF96, 0xFF92, 0xFF9D, 0xFFB4, 0xFFAC, 0xFFA6, 0xFF82, 0xFF6D, 0xFF5D,
    0xFF38, 0xFF25, 0xFF40, 0xFF5D, 0xFF69, 0xFF55, 0xFF55, 0xFF3E, 0xFF2A, 0xFF00, 0xFEED, 0xFF07, 0xFF32, 0xFF37, 0xFF23, 0xFEFF,
    0xFF10, 0xFF29, 0xFF35, 0xFF3B, 0xFF0A, 0xFF0F, 0xFF08, 0xFF11, 0xFF16, 0xFF13, 0xFF15, 0xFF07, 0xFF04, 0xFEDE, 0xFEAB, 0xFE9F,
    0xFEB7, 0xFED8, 0xFF04, 0xFEF4, 0xFED5, 0xFEDE, 0xFEDB, 0xFEC6, 0xFEBF, 0xFEC3, 0xFEB0, 0xFEBD, 0xFED2, 0xFED0, 0xFEE0, 0xFEE3,
    0xFEDA, 0xFEC2, 0xFE8C, 0xFE96, 0xFEB2, 0xFEDE, 0xFEDF, 0xFEE4, 0xFEDB, 0xFECE, 0xFEB1, 0xFEA4, 0xFEB3, 0xFE9B, 0xFE99, 0xFE85,
    0xFE7F, 0xFE76, 0xFE84, 0xFE91, 0xFE94, 0xFEB1, 0xFEBB, 0xFEB5, 0xFE97, 0xFEBB, 0xFEAE, 0xFEAD, 0xFEA9, 0xFEA4, 0xFEAA, 0xFEB2,
    0xFEA3, 0xFE77, 0xFE9B, 0xFEAE, 0xFEBB, 0xFE9E, 0xFEAF, 0xFEDB, 0xFEE6, 0xFEE4, 0xFEC8, 0xFEF5, 0xFF24, 0xFF08, 0xFF00, 0xFF24,
    0xFF1B, 0xFF13, 0xFF21, 0xFF12, 0xFF12, 0xFF10, 0xFEF6, 0xFEF5, 0xFF08, 0xFF00, 0xFEE8, 0xFF04, 0xFF0F, 0xFF02, 0xFEFE, 0xFEF9,
    0xFEEC, 0xFF12, 0xFF15, 0xFF18, 0xFEFA, 0xFF18, 0xFF68, 0xFF61, 0xFF65, 0xFF6D, 0xFF42, 0xFF42, 0xFF55, 0xFF3F, 0xFF4B, 0xFF4E,
    0xFF46, 0xFF57, 0xFF50, 0xFF35, 0xFF2C, 0xFF53, 0xFF6A, 0xFF58, 0xFF3B, 0xFF36, 0xFF28, 0xFF81, 0xFFA0, 0xFF71, 0xFF85, 0xFF98,
    0xFF7C, 0xFF94, 0xFF9D, 0xFF79, 0xFF5F, 0xFF62, 0xFF59, 0xFF66, 0xFF77, 0xFF87, 0xFF8D, 0xFF80, 0xFF7E, 0xFF7C, 0xFF90, 0xFF97,
    0xFF88, 0xFF5C, 0xFF6C, 0xFF6B, 0xFF6A, 0xFF74, 0xFF75, 0xFF6B, 0xFF46, 0xFF4C, 0xFF47, 0xFF4B, 0xFF55, 0xFF46, 0xFF41, 0xFF27,
    0xFF0A, 0xFF43, 0xFF7D, 0xFF6A, 0xFF75, 0xFF86, 0xFF78, 0xFF91, 0xFFA6, 0xFFBB, 0xFFA1, 0xFF8B, 0xFF87, 0xFF77, 0xFF8C, 0xFF77,
    0xFF70, 0xFF9A, 0xFFAC, 0xFF94, 0xFF87, 0xFF98, 0xFF96, 0xFF6B, 0xFF7F, 0xFF9C, 0xFF9B, 0xFFAA, 0xFFAB, 0xFF93, 0xFF95, 0xFFA5,
    0xFF9F, 0xFFA7, 0xFF99, 0xFF88, 0xFF8A, 0xFFA9, 0xFFA5, 0xFFA6, 0xFFC4, 0xFFA5, 0xFF8F, 0xFFA7, 0xFF9B, 0xFFA5, 0xFFCC, 0xFFD9,
    0xFFF3, 0x000C, 0x0005, 0xFFD4, 0xFFD6, 0x001F, 0x0047, 0x005C, 0x0060, 0x0028, 0xFFC4, 0xFFC5, 0x0004, 0x002E, 0x007D, 0x00B2,
    0x0074, 0x0063, 0x0072, 0x0071, 0x0093, 0x008D, 0x0092, 0x0087, 0x00B6, 0x00C9, 0x00D0, 0x00F2, 0x00E1, 0x00D7, 0x00DE, 0x00F7,
    0x00DD, 0x00DD, 0x00C2, 0x00B9, 0x00D2, 0x00BE, 0x00A7, 0x00AC, 0x00BC, 0x00C4, 0x00DA, 0x00E7, 0x00EA, 0x00D5, 0x00F0, 0x00FD,
    0x00FD, 0x0117, 0x0109, 0x00FC, 0x0106, 0x00EF, 0x00D5, 0x00F2, 0x00E9, 0x00D4, 0x00D5, 0x00DF, 0x00B4, 0x009F, 0x00B2, 0x00B4,
    0x00B9, 0x00F0, 0x0109, 0x0115, 0x0122, 0x0128, 0x0135, 0x0147, 0x0151, 0x0150, 0x0109, 0x00BD, 0x00A9, 0x00AC, 0x00ED, 0x0105,
    0x00E5, 0x00F0, 0x0105, 0x00E8, 0x00F0, 0x00EC, 0x00F4, 0x00E0, 0x00CE, 0x00CE, 0x00D3, 0x00CF, 0x00CA, 0x00DB, 0x00DD, 0x00E4,
    0x00C9, 0x00D9, 0x00C2, 0x00E1, 0x0105, 0x0131, 0x0110, 0x0125, 0x012B, 0x0110, 0x010D, 0x00DF, 0x00DE, 0x00D8, 0x00DD, 0x00D9,
    0x00D1, 0x00DB, 0x00D7, 0x00D5, 0x00BD, 0x00B0, 0x00AB, 0x00BA, 0x00B9, 0x00A1, 0x00B8, 0x00BD, 0x00C3, 0x00C1, 0x00CF, 0x00DD,
    0x00B6, 0x0097, 0x009F, 0x00AB, 0x00BF, 0x00B1, 0x00AD, 0x00C1, 0x00BD, 0x00AD, 0x008C, 0x00A9, 0x00AC, 0x00D4, 0x0107, 0x00EE,
    0x00EE, 0x00F0, 0x00F6, 0x0105, 0x0103, 0x00EB, 0x00CD, 0x00D8, 0x00D5, 0x00E9, 0x00E2, 0x00DF, 0x00AE, 0x007A, 0x00AE, 0x00E6,
    0x00EF, 0x0108, 0x013D, 0x0123, 0x013F, 0x013A, 0x0123, 0x0117, 0x013C, 0x0133, 0x011F, 0x0115, 0x00CA, 0x00D5, 0x00C7, 0x00C2,
    0x00B6, 0x00BB, 0x00AD, 0x00A9, 0x00B0, 0x00B6, 0x0098, 0x009C, 0x009C, 0x00A3, 0x00BB, 0x00CE, 0x00E7, 0x00E8, 0x00F4, 0x00CD,
    0x00B8, 0x00C3, 0x00B8, 0x00C7, 0x00D5, 0x00C1, 0x00BF, 0x00C0, 0x00B7, 0x00C4, 0x00BA, 0x00AD, 0x00AD, 0x00AA, 0x00AE, 0x009E,
    0x009F, 0x00A1, 0x00A9, 0x009E, 0x0098, 0x0098, 0x0093, 0x00A2, 0x00A7, 0x0090, 0x009D, 0x0084, 0x0086, 0x0071, 0x0081, 0x0088,
    0x008E, 0x00AB, 0x0074, 0x005E, 0x006C, 0x009E, 0x00AC, 0x0094, 0x0087, 0x0079, 0x0076, 0x006B, 0x0071, 0x005F, 0x0052, 0x0053,
    0x0043, 0x005E, 0x0061, 0x005F, 0x0061, 0x0028, 0xFFF8, 0xFFFE, 0x0009, 0x0002, 0x0005, 0xFFF7, 0xFFE1, 0xFFE4, 0xFFEE, 0xFFDE,
    0xFFC9, 0xFFD2, 0xFFB4, 0xFFD6, 0xFFD8, 0xFFD0, 0xFFD3, 0xFFE4, 0xFFBA, 0xFF78, 0xFF85, 0xFF86, 0xFF7C, 0xFF98, 0xFFA3, 0xFFA0,
    0xFFA2, 0xFFC2, 0xFFBF, 0xFFB4, 0xFFBA, 0xFFD4, 0xFFDA, 0xFFBB, 0xFFBE, 0xFFB8, 0xFFCF, 0xFFD2, 0xFFA3, 0xFF79, 0xFF7B, 0xFF54,
    0xFF41, 0xFF4F, 0xFF5F, 0xFFAA, 0x0043, 0x0160, 0x0288, 0x02F2, 0x01AB, 0xFF87, 0xFE7C, 0xFE45, 0xFE07, 0xFE1B, 0xFE44, 0xFE52,
    0xFE7A, 0xFE91, 0xFEA0, 0xFE83, 0xFE90, 0xFEC3, 0xFEEA, 0xFEF5, 0xFF08, 0xFF0A, 0xFEF5, 0xFEFE, 0xFEFF, 0xFF19, 0xFEFE, 0xFEF8,
    0xFF13, 0xFF20, 0xFF11, 0xFF02, 0xFF04, 0xFEF1, 0xFED4, 0xFEC0, 0xFEC1, 0xFEAD, 0xFEB6, 0xFEA9, 0xFEB7, 0xFEDF, 0xFEE9, 0xFEDC,
    0xFEC8, 0xFECF, 0xFECE, 0xFEAC, 0xFEB8, 0xFE9B, 0xFE92, 0xFEBB, 0xFE99, 0xFEA1, 0xFEAA, 0xFECB, 0xFEB7, 0xFEB7, 0xFEC5, 0xFEA3,
    0xFEC0, 0xFEEA, 0xFEEC, 0xFEE8, 0xFEEB, 0xFED6, 0xFED6, 0xFEEC, 0xFF07, 0xFEF5, 0xFEFB, 0xFEF5, 0xFEE0, 0xFEED, 0xFEE4, 0xFEDD,
    0xFED8, 0xFED4, 0xFEB2, 0xFEBA, 0xFECE, 0xFED9, 0xFEFB, 0xFF30, 0xFF63, 0xFF7D, 0xFF8C, 0xFF73, 0xFF8C, 0xFFA8, 0xFF9D, 0xFF79,
    0xFF9F, 0xFFDE, 0xFFD0, 0xFFE0, 0xFFDD, 0xFFE1, 0xFFF3, 0xFFFB, 0x0005, 0x000D, 0x001B, 0x0044, 0x0062, 0x005E, 0x0062, 0x0069,
    0x008B, 0x006C, 0x0040, 0x0040, 0x006B, 0x0087, 0x0085, 0x0084, 0x007E, 0x0054, 0x0061, 0x0052, 0x0037, 0x006F, 0x007E, 0x00A2,
    0x00B9, 0x00B4, 0x0091, 0x0092, 0x0085, 0x006D, 0x008F, 0x009A, 0x0081, 0x0089, 0x0099, 0x0086, 0x0041, 0x0054, 0x0059, 0x004B,
    0x0044, 0x0054, 0x004D, 0x003B, 0x005B, 0x006E, 0x0076, 0x0074, 0x0070, 0x008D, 0x008B, 0x0085, 0x0081, 0x0090, 0x0082, 0x006B,
    0x0057, 0x0031, 0x0031, 0x0031, 0x0049, 0x0048, 0x004A, 0x0059, 0x004F, 0x0057, 0x005B, 0x0063, 0x0055, 0x0066, 0x0067, 0x0068,
    0x0073, 0x005E, 0x0050, 0x003E, 0x000C, 0xFFE0, 0xFFDE, 0xFFC0, 0xFFB4, 0xFF99, 0xFF8B, 0xFF8B, 0xFF84, 0xFF77, 0xFF69, 0xFF5D,
    0xFF51, 0xFF32, 0xFF2F, 0xFF7A, 0x0042, 0x01B9, 0x02EF, 0x035E, 0x0304, 0x0199, 0xFE9C, 0xFC70, 0xFC6B, 0xFC7E, 0xFC85, 0xFCF6,
    0xFD30, 0xFD72, 0xFD95, 0xFDB7, 0xFE14, 0xFE2F, 0xFE49, 0xFE73, 0xFE8C, 0xFE88, 0xFEB7, 0xFECD, 0xFEA9, 0xFEAA, 0xFEB3, 0xFEBD,
    0xFEC4, 0xFEE2, 0xFEDE, 0xFEFA, 0xFEEB, 0xFEA0, 0xFEA9, 0xFFD4, 0x01D5, 0x039D, 0x0442, 0x045A, 0x0410, 0x0284, 0xFF29, 0xFB9D,
    0xFAE5, 0xFB3D, 0xFB36, 0xFBCE, 0xFC47, 0xFCB6, 0xFD57, 0xFDC3, 0xFE3D, 0xFE77, 0xFED2, 0xFF07, 0xFF39, 0xFF7C, 0xFF71, 0xFF6D,
    0xFF92, 0xFFE3, 0x0042, 0x00A2, 0x00B6, 0x00B9, 0x00E6, 0x0106, 0x010B, 0x0108, 0x0147, 0x0164, 0x0188, 0x01BA, 0x01F6, 0x0217,
    0x024F, 0x025C, 0x023F, 0x022F, 0x023C, 0x0266, 0x028A, 0x029F, 0x0297, 0x02C1, 0x029C, 0x0258, 0x0245, 0x0231, 0x021A, 0x020B,
    0x0219, 0x0211, 0x0203, 0x0224, 0x0207, 0x01FC, 0x0201, 0x01E3, 0x01C4, 0x01DE, 0x01D8, 0x01E5, 0x0209, 0x0215, 0x01EC, 0x01D0,
    0x01A9, 0x0181, 0x0189, 0x0183, 0x018C, 0x0187, 0x0174, 0x0179, 0x0160, 0x013C, 0x0142, 0x0131, 0x00F2, 0x00D3, 0x00F0, 0x011B,
    0x0117, 0x014B, 0x0154, 0x0139, 0x0134, 0x010B, 0x00E2, 0x00CA, 0x00CA, 0x00CC, 0x00CA, 0x00B8, 0x00BB, 0x00B6, 0x009F, 0x009F,
    0x00D6, 0x00DB, 0x00C2, 0x008D, 0x007D, 0x0081, 0x0096, 0x0090, 0x005B, 0x0047, 0x0010, 0xFFA1, 0xFF45, 0xFF2D, 0xFEF9, 0xFEE1,
    0xFF49, 0xFFC0, 0xFFFB, 0xFFF8, 0x002E, 0x0079, 0x0080, 0x004A, 0x003D, 0x007D, 0x013B, 0x02BD, 0x04DA, 0x067B, 0x06E4, 0x05AE,
    0x0249, 0xFDE1, 0xFBCC, 0xFB80, 0xFB29, 0xFB8C, 0xFC0A, 0xFC92, 0xFCFE, 0xFD65, 0xFD9D, 0xFDA8, 0xFDCB, 0xFDCF, 0xFDAF, 0xFD9F,
    0xFDC4, 0xFE00, 0xFE3A, 0xFE57, 0xFE64, 0xFE57, 0xFE5F, 0xFE5C, 0xFE7D, 0xFE9B, 0xFE66, 0xFEAA, 0xFEE7, 0xFEF9, 0xFF2C, 0xFF35,
    0xFF36, 0xFF1B, 0xFF23, 0xFF37, 0xFF20, 0xFF2D, 0xFF56, 0xFF58, 0xFF39, 0xFF32, 0xFF50, 0xFF55, 0xFF56, 0xFF81, 0xFF77, 0xFF8D,
    0xFFB6, 0xFFC0, 0xFFD9, 0x0033, 0x0069, 0x0078, 0x0081, 0x0054, 0x005D, 0x007E, 0x0099, 0x00B5, 0x00DC, 0x00FB, 0x00FF, 0x0109,
    0x0119, 0x011F, 0x013B, 0x0157, 0x0145, 0x0168, 0x018C, 0x01AE, 0x01D6, 0x01FB, 0x021C, 0x01EF, 0x020B, 0x021B, 0x0213, 0x0222,
    0x0211, 0x0214, 0x0201, 0x0220, 0x0227, 0x0243, 0x0260, 0x024A, 0x0240, 0x0252, 0x0278, 0x0274, 0x029B, 0x0286, 0x0279, 0x025A,
    0x0231, 0x01AF, 0x00FF, 0x00E8, 0x01A3, 0x0201, 0x01DD, 0x01CA, 0x01AD, 0x01AB, 0x0197, 0x0161, 0x015B, 0x014B, 0x012D, 0x0143,
    0x0125, 0x011D, 0x0118, 0x0112, 0x0119, 0x012C, 0x0115, 0x00C9, 0x00D1, 0x00EA, 0x00BF, 0x008A, 0x007D, 0x007A, 0x0069, 0x0054,
    0x0056, 0x0055, 0x005A, 0x006D, 0x005D, 0x003F, 0x001E, 0xFFDB, 0xFFF0, 0x0010, 0xFFF4, 0xFFE8, 0xFFE4, 0xFFBD, 0xFF8E, 0xFF87,
    0xFF70, 0xFF3E, 0xFF16, 0xFF27, 0xFF0C, 0xFEEE, 0xFED2, 0xFEB6, 0xFEB2, 0xFEB6, 0xFEBB, 0xFE72, 0xFE65, 0xFE40, 0xFE11, 0xFDF0,
    0xFDE9, 0xFDF0, 0xFDC7, 0xFDC6, 0xFD74, 0xFD1D, 0xFD0C, 0xFCF7, 0xFC97, 0xFB6C, 0xF933, 0xF7A2, 0xF791, 0xFA58, 0xFFB3, 0x0240,
    0x01B2, 0x0106, 0x005E, 0x0009, 0xFFA6, 0xFF7F, 0xFFA6, 0xFF65, 0xFF79, 0xFF4C, 0xFF2B, 0xFF4E, 0xFF28, 0xFE39, 0xFD5C, 0xFDD8,
    0xFE56, 0xFEC1, 0x0041, 0x00D2, 0x001F, 0x0056, 0x0115, 0x0106, 0x0094, 0x0036, 0x0095, 0x00F2, 0x012D, 0x01A7, 0x0194, 0x0182,
    0x011C, 0x00E3, 0x00F4, 0x00AB, 0x0044, 0x000F, 0x0023, 0x0013, 0x0016, 0x0045, 0x0067, 0x007B, 0x0086, 0x0052, 0x0068, 0x00AD,
    0x0098, 0x008D, 0x00A2, 0x0090, 0x0074, 0x0074, 0x007A, 0x005C, 0x0087, 0x007F, 0x0045, 0x0078, 0x00AD, 0x00AD, 0x00AA, 0x00A2,
    0x00A5, 0x0087, 0x0031, 0x0013, 0x0002, 0xFFD4, 0xFFDB, 0xFFCB, 0xFFC2, 0xFFD1, 0xFFAA, 0xFFBC, 0xFFB7, 0xFFBD, 0xFFBF, 0xFFD6,
    0xFFE4, 0xFFE1, 0x0005, 0x0020, 0x0037, 0x0032, 0x0043, 0x002A, 0x0016, 0xFFEE, 0xFFD5, 0xFFF4, 0x001F, 0x0035, 0x0025, 0x001D,
    0xFFEE, 0xFFD4, 0xFFD3, 0xFFD1, 0xFFA6, 0xFFB7, 0x001E, 0x00C4, 0x0109, 0x003F, 0xFF96, 0xFF80, 0xFF78, 0xFF3B, 0xFF29, 0xFF25,
    0xFF12, 0xFEF7, 0xFEE8, 0xFECD, 0xFECF, 0xFEEB, 0xFEDD, 0xFED3, 0xFEB0, 0xFEAE, 0xFE73, 0xFE77, 0xFEA4, 0xFE71, 0xFE72, 0xFE63,
    0xFE60, 0xFE44, 0xFE51, 0xFE3A, 0xFE3F, 0xFE42, 0xFE38, 0xFE38, 0xFE2C, 0xFE37, 0xFE3D, 0xFE46, 0xFE2A, 0xFE19, 0xFE16, 0xFE0F,
    0xFE0C, 0xFE05, 0xFDE3, 0xFDC9, 0xFDBB, 0xFDC5, 0xFDA4, 0xFD63, 0xFD6D, 0xFD3C, 0xFD0E, 0xFD08, 0xFCFE, 0xFCDB, 0xFCE8, 0xFD1C,
    0xFD18, 0xFCFF, 0xFD07, 0xFD09, 0xFCFC, 0xFD0D, 0xFCEC, 0xFCE8, 0xFCDF, 0xFCF5, 0xFD1E, 0xFD1D, 0xFD2C, 0xFD10, 0xFD05, 0xFCDD,
    0xFCB8, 0xFC87, 0xFC81, 0xFCA8, 0xFC9A, 0xFCC0, 0xFCF1, 0xFCEA, 0xFCF4, 0xFD19, 0xFD46, 0xFD51, 0xFD55, 0xFD6A, 0xFD64, 0xFD83,
    0xFD6A, 0xFD7A, 0xFDBF, 0xFDCD, 0xFDBF, 0xFDC0, 0xFDA8, 0xFDC3, 0xFDE6, 0xFE12, 0xFE2B, 0xFE34, 0xFE71, 0xFE6D, 0xFEAF, 0xFEF6,
    0xFF06, 0xFF1B, 0xFF3A, 0xFF40, 0xFF3B, 0xFF6F, 0xFF9D, 0xFFBA, 0xFFC5, 0xFF96, 0xFF67, 0xFF67, 0xFF57, 0xFF54, 0xFF5F, 0xFF57,
    0xFF46, 0xFF47, 0xFF77, 0xFF7F, 0xFF76, 0xFFAD, 0xFFB6, 0xFFD9, 0xFFDA, 0x0074, 0x0203, 0x040D, 0x053C, 0x05C9, 0x069A, 0x080A,
    0x09BC, 0x09ED, 0x08F0, 0x07BD, 0x06F6, 0x060B, 0x0485, 0x01F6, 0xFE10, 0xFC1C, 0xFCD4, 0xFDED, 0xFF0F, 0xFF56, 0x0033, 0x011D,
    0xFF22, 0xFADB, 0xF655, 0xF2A4, 0xED57, 0xE565, 0xE083, 0xE173, 0xE2F2, 0xE4EF, 0xE849, 0xED03, 0xF4E4, 0xFEA5, 0x06C2, 0x085E,
    0x0745, 0x06EF, 0x05A8, 0x04AF, 0x036B, 0x0258, 0x0195, 0x00A5, 0x0054, 0xFFEB, 0xFFC0, 0xFF63, 0xFF21, 0xFEFE, 0xFEAD, 0xFEC2,
    0xFE9D, 0xFE9C, 0xFE7C, 0xFE7E, 0xFE9A, 0xFE9B, 0xFEAA, 0xFE9C, 0xFED4, 0xFEA4, 0xFEA8, 0xFEC7, 0xFEEA, 0xFF04, 0xFF24, 0xFF53,
    0xFF32, 0xFF2D, 0xFF2A, 0xFF34, 0xFF4C, 0xFF76, 0xFF4C, 0xFF44, 0xFF67, 0xFF8B, 0xFF89, 0xFF7E, 0xFF6B, 0xFF51, 0xFF40, 0xFF5A,
    0xFF54, 0xFF5C, 0xFF6D, 0xFF53, 0xFF4B, 0xFF43, 0xFF4C, 0xFF47, 0xFF70, 0xFF64, 0xFF43, 0xFF3E, 0xFF47, 0xFF5A, 0xFF54, 0xFF46,
    0xFF1D, 0xFF39, 0xFF3F, 0xFF4B, 0xFF49, 0xFF61, 0xFF68, 0xFF5D, 0xFF57, 0xFF3F, 0xFF2C, 0xFF3E, 0xFF2C, 0xFF1F, 0xFF31, 0xFF35,
    0xFF46, 0xFF6E, 0xFF6E, 0xFF4E, 0xFF47, 0xFF47, 0xFF09, 0xFEE1, 0xFEF2, 0xFF1F, 0xFF62, 0xFF7F, 0xFF8F, 0xFF8B, 0xFF9B, 0xFFA5,
    0xFFB6, 0x0002, 0x0088, 0x0150, 0x01B7, 0x00B4, 0xFF42, 0xFF25, 0xFF33, 0xFF46, 0xFF5F, 0xFEFC, 0xFEF1, 0xFF16, 0xFF2A, 0xFF4B,
    0xFF41, 0xFF53, 0xFF54, 0xFF45, 0xFF8E, 0xFF9C, 0xFF9E, 0xFFA8, 0xFFB5, 0xFFA7, 0xFF95, 0xFF99, 0xFF68, 0xFF62, 0xFF3E, 0xFF06,
    0xFEB6, 0xFED9, 0xFEFB, 0xFF09, 0xFEE8, 0xFEDC, 0xFED5, 0xFEC2, 0xFED1, 0xFEC1, 0xFED6, 0xFE75, 0xFE66, 0xFE3D, 0xFE37, 0xFE6A,
    0xFE42, 0xFE43, 0xFE84, 0xFF0C, 0xFF1B, 0xFF27, 0xFF1E, 0xFF2B, 0xFF43, 0xFF48, 0xFF50, 0xFF7A, 0xFF9B, 0xFF80, 0xFFB1, 0xFF95,
    0xFF79, 0xFF75, 0xFF6D, 0xFF70, 0xFF79, 0xFFAB, 0xFFA6, 0xFF9A, 0xFF96, 0xFFAC, 0x001C, 0x0137, 0x0200, 0x018B, 0x0037, 0xFDBB,
    0xFB80, 0xFB3D, 0xFCEF, 0xFE9F, 0xFFAC, 0x0054, 0x009D, 0x00C7, 0x00B9, 0x0090, 0x00A0, 0x008C, 0x005F, 0x005E, 0x0043, 0x0018,
    0xFFEB, 0x0001, 0x001F, 0x0036, 0x004C, 0x0053, 0x004D, 0x0065, 0x0080, 0x006E, 0x0075, 0x0098, 0x0083, 0x008F, 0x00A4, 0x00AF,
    0x00D1, 0x00DE, 0x00D6, 0x00C0, 0x00A5, 0x00BB, 0x00C4, 0x00F5, 0x0115, 0x00FB, 0x0101, 0x0115, 0x010E, 0x0114, 0x0148, 0x0147,
    0x0130, 0x0127, 0x00FB, 0x00DB, 0x0127, 0x013A, 0x0121, 0x0104, 0x00CF, 0x00C0, 0x009E, 0x0088, 0x0073, 0x0066, 0x0063, 0x0052,
    0x0064, 0x0050, 0x0039, 0x000A, 0xFFEB, 0xFFD2, 0xFF80, 0xFF54, 0xFF61, 0xFF63, 0xFF67, 0xFF51, 0xFF2F, 0xFF1F, 0xFEF8, 0xFEC2,
    0xFEA5, 0xFE8D, 0xFE85, 0xFE9C, 0xFEB3, 0xFEC6, 0xFEAB, 0xFEB7, 0xFEF2, 0xFEF6, 0xFF17, 0xFF1A, 0xFF01, 0xFF0A, 0xFF2A, 0xFF4D,
    0xFF6F, 0xFF95, 0xFF84, 0xFF96, 0xFF9D, 0xFF89, 0xFF7F, 0xFF9D, 0xFF91, 0xFFA7, 0xFFBC, 0xFFD3, 0xFFDF, 0x0000, 0x0021, 0x0045,
    0x005A, 0x0067, 0x0083, 0x008F, 0x00A4, 0x00B7, 0x0099, 0x00A5, 0x0099, 0x0086, 0x007D, 0x0064, 0x006B, 0x0044, 0x002A, 0x001A,
    0x0020, 0x002D, 0x0027, 0x003D, 0x0061, 0x006A, 0x0060, 0x005B, 0x004E, 0x0053, 0x0056, 0x0061, 0x0049, 0x0046, 0x005A, 0x004E,
    0x0019, 0x0001, 0xFFEB, 0xFFC4, 0xFFD8, 0xFFBA, 0xFFC0, 0xFFE1, 0xFFD1, 0xFFCC, 0xFFE0, 0xFFE3, 0xFFE1, 0xFFC5, 0xFFE3, 0xFFC7,
    0xFFCB, 0x0009, 0xFFF6, 0xFFDF, 0xFFBC, 0xFFB9, 0xFFA4, 0xFF9D, 0xFF98, 0xFF93, 0xFFCC, 0xFFB9, 0xFFDB, 0xFFE2, 0xFFEE, 0xFFC2,
    0xFF81, 0xFF37, 0xFED0, 0xFF6B, 0x0034, 0x0012, 0x0022, 0x0043, 0x0051, 0x0048, 0x0021, 0x002C, 0x000E, 0x0017, 0x0030, 0x003B,
    0x005B, 0x0065, 0x0060, 0x0071, 0x00B9, 0x00B6, 0x00AF, 0x0091, 0x0084, 0x007D, 0x0080, 0x0088, 0x0064, 0x0075, 0x0076, 0x006F,
    0x0057, 0x0069, 0x0056, 0x0033, 0x002D, 0x0030, 0x0043, 0x0050, 0x0050, 0x0069, 0x0084, 0x0064, 0x006D, 0x006E, 0x0032, 0x0022,
    0x0018, 0x0045, 0xFFFD, 0xFFFF, 0x0014, 0xFFE1, 0xFFF6, 0x0026, 0x0023, 0xFFF2, 0x001D, 0x001A, 0x0011, 0x002D, 0x0045, 0x0055,
    0x0066, 0x0071, 0x003A, 0x003C, 0x0035, 0x0015, 0x002C, 0x0020, 0xFFFD, 0xFFEA, 0x0015, 0x001E, 0xFFFB, 0x001E, 0x0016, 0xFFF7,
    0xFFEF, 0x0003, 0x0014, 0x003E, 0x004A, 0x0048, 0x003B, 0x003C, 0x001C, 0xFFFC, 0x0015, 0xFFFD, 0x0005, 0x0034, 0x003D, 0x003B,
    0x002F, 0x000D, 0x0005, 0x0009, 0xFFEF, 0x001E, 0x0032, 0x005B, 0x0053, 0x004D, 0x0054, 0x002D, 0x0032, 0x0012, 0xFFF9, 0xFFE5,
    0xFFBE, 0xFFDE, 0xFFD1, 0xFFA4, 0xFFAC, 0xFF85, 0xFF52, 0xFF1B, 0xFF13, 0xFF6C, 0xFFAF, 0xFF6E, 0xFF78, 0xFF91, 0xFFAA, 0xFFAE,
    0xFFB4, 0xFF9D, 0xFF53, 0xFF6E, 0xFF78, 0xFF9F, 0xFFA0, 0xFFB7, 0xFF8D, 0xFF8E, 0xFF5E, 0xFF1A, 0xFF49, 0xFF4A, 0xFF71, 0xFF9D,
    0xFF9B, 0xFF92, 0xFF9E, 0xFFCC, 0xFFD0, 0xFFA8, 0xFF99, 0xFFBD, 0xFF97, 0xFFA7, 0xFFED, 0x0002, 0x0032, 0x0045, 0x0031, 0x0007,
    0xFFE6, 0xFFF9, 0x0031, 0x0064, 0x006D, 0x0055, 0x007D, 0x009C, 0x00AC, 0x00CB, 0x00CB, 0x00A5, 0x0090, 0x0091, 0x0095, 0x008B,
    0x00BC, 0x00E9, 0x00D7, 0x00BF, 0x009B, 0x007E, 0x004C, 0x0041, 0x002F, 0x0030, 0x0032, 0x0038, 0xFFFA, 0xFF83, 0xFF3F, 0xFF33,
    0xFF9A, 0xFFFE, 0x002E, 0x006C, 0x0084, 0x0070, 0x006D, 0x005C, 0x0038, 0x002B, 0x0031, 0x0016, 0xFFE7, 0x0007, 0x0001, 0x0004,
    0x0010, 0x0012, 0x0026, 0x0023, 0x001A, 0x0011, 0x001F, 0x004F, 0x0058, 0x0050, 0x0043, 0x0036, 0x0011, 0x001B, 0x0021, 0x0011,
    0x0001, 0x001E, 0x0038, 0x0033, 0x0044, 0x0056, 0x008E, 0x00D7, 0x00D9, 0x00B1, 0x0098, 0x00A3, 0x00A0, 0x00B2, 0x008C, 0x0075,
    0x005B, 0x002B, 0x004D, 0x0057, 0x0064, 0x0073, 0x0074, 0x0073, 0x0059, 0x0043, 0x004A, 0x005D, 0x005F, 0x006C, 0x005F, 0x0055,
    0x0055, 0x0058, 0x005D, 0x0055, 0x0045, 0x0045, 0x003F, 0x0059, 0x0051, 0x004A, 0x0061, 0x0048, 0x004D, 0x006E, 0x0069, 0x0072,
    0x0069, 0x0063, 0x007F, 0x0085, 0x008D, 0x004E, 0x000A, 0xFFA5, 0xFF92, 0xFFF8, 0x004E, 0x0053, 0x0045, 0x0056, 0x002F, 0x001B,
    0x000F, 0x000E, 0xFFF2, 0xFFF2, 0xFFE5, 0xFFEA, 0xFFED, 0xFFFC, 0x000B, 0x001C, 0x0040, 0x0034, 0x003F, 0x0034, 0x0026, 0x0001,
    0xFFEB, 0x0013, 0x0021, 0x003D, 0x0033, 0x0029, 0x0019, 0x0028, 0x0046, 0x006A, 0x00E0, 0x01D3, 0x02D6, 0x0355, 0x0304, 0x01AA,
    0xFFAD, 0xFE83, 0xFE77, 0xFEB0, 0xFEE1, 0xFF0B, 0xFF42, 0xFF93, 0xFFBF, 0xFFDE, 0xFFE3, 0xFFE5, 0x0002, 0x0018, 0x001B, 0x002D,
    0x002F, 0x0043, 0x0049, 0x003F, 0x003E, 0x002F, 0x003D, 0x0044, 0x0020, 0x0011, 0x0028, 0x0023, 0x0030, 0x0046, 0x0026, 0x001C,
    0x0028, 0x0026, 0x0037, 0x0037, 0x003B, 0x0029, 0x0028, 0x001C, 0x0013, 0x003A, 0x002B, 0xFFFC, 0x0013, 0x000E, 0xFFFA, 0x000F,
    0xFFF3, 0xFFEC, 0x0002, 0xFFFC, 0xFFF9, 0xFFF0, 0xFFEF, 0x002E, 0x0036, 0x002B, 0x0037, 0x0012, 0x0019, 0x0029, 0x0016, 0x0021,
    0x0011, 0x0011, 0x0022, 0x002C, 0x0005, 0x0008, 0x0011, 0x000D, 0x0007, 0x0013, 0x000F, 0xFFFB, 0x0007, 0x0025, 0x003B, 0x003A,
    0x002C, 0x000C, 0x001A, 0x0011, 0xFFEB, 0xFFE1, 0xFFFA, 0x0009, 0xFFFF, 0x000B, 0xFFF2, 0xFFF1, 0x0016, 0xFFFF, 0xFFEF, 0xFFF7,
    0x0000, 0xFFED, 0xFFF3, 0xFFFB, 0xFFEE, 0xFFDD, 0xFFDA, 0xFFE3, 0xFFAC, 0xFFD0, 0xFFE2, 0xFFEC, 0xFFCF, 0xFFD5, 0xFFCF, 0xFFDA,
    0xFFD4, 0xFFB0, 0xFFBA, 0xFFB7, 0xFFD0, 0xFFE9, 0x0009, 0xFFF8, 0xFFFA, 0x0005, 0x0008, 0xFFFA, 0xFFF6, 0xFFF4, 0xFFDA, 0xFFDD,
    0xFFCE, 0xFFB8, 0xFFA9, 0xFFC3, 0xFFA1, 0xFFB4, 0xFFB8, 0xFFAF, 0xFFCB, 0xFFB2, 0xFFC1, 0xFFBE, 0xFFB6, 0xFFBD, 0xFF98, 0xFFA0,
    0xFF9D, 0xFF99, 0xFF9C, 0xFF8E, 0xFF90, 0xFF89, 0xFFA3, 0xFFA4, 0xFF9F, 0xFFA1, 0xFF7E, 0xFF77, 0xFF47, 0xFF49, 0xFF55, 0xFF69,
    0xFF6B, 0xFF62, 0xFF62, 0xFF57, 0xFF3B, 0xFF53, 0xFF79, 0xFF5C, 0xFF46, 0xFF4B, 0xFF55, 0xFF53, 0xFF5B, 0xFF57, 0xFF46, 0xFF4F,
    0xFF55, 0xFF4F, 0xFF40, 0xFF34, 0xFF2F, 0xFF37, 0xFF4A, 0xFF57, 0xFF32, 0xFF26, 0xFF3C, 0xFF3D, 0xFF41, 0xFF41, 0xFF29, 0xFF3A,
    0xFF32, 0xFF29, 0xFF49, 0xFF44, 0xFF31, 0xFF3D, 0xFF2C, 0xFF25, 0xFF2A, 0xFF31, 0xFF28, 0xFF38, 0xFF4B, 0xFF50, 0xFF56, 0xFF60,
    0xFF4F, 0xFF47, 0xFF3E, 0xFF4F, 0xFF3B, 0xFF44, 0xFF49, 0xFF32, 0xFF30, 0xFF40, 0xFF3B, 0xFF1C, 0xFF44, 0xFF47, 0xFF44, 0xFF71,
    0xFF5E, 0xFF74, 0xFF71, 0xFF76, 0xFF7D, 0xFF6E, 0xFF94, 0xFFAC, 0xFF9B, 0xFFA8, 0xFF8D, 0xFF90, 0xFF9B, 0xFF87, 0xFF7E, 0xFF6F,
    0xFF82, 0xFF75, 0xFF6B, 0xFF8C, 0xFF72, 0xFF78, 0xFF79, 0xFF69, 0xFF7A, 0xFF9D, 0xFF84, 0xFF7C, 0xFF79, 0xFF56, 0xFF59, 0xFF63,
    0xFF35, 0xFF45, 0xFF56, 0xFF4B, 0xFF59, 0xFF6E, 0xFF65, 0xFF52, 0xFF68, 0xFF72, 0xFF5B, 0xFF5D, 0xFF6D, 0xFF59, 0xFF6B, 0xFF7E,
    0xFF6A, 0xFF5E, 0xFF68, 0xFF6C, 0xFF59, 0xFF58, 0xFF5C, 0xFF65, 0xFF52, 0xFF52, 0xFF42, 0xFF30, 0xFF40, 0xFF4D, 0xFF36, 0xFF52,
    0xFF65, 0xFF46, 0xFF6A, 0xFFDA, 0x0132, 0x0356, 0x0527, 0x062C, 0x05B2, 0x030B, 0xFF05, 0xFC38, 0xFBCB, 0xFBD7, 0xFC06, 0xFC6A,
    0xFCAE, 0xFCF7, 0xFD42, 0xFD7E, 0xFDAB, 0xFDFC, 0xFE09, 0xFE21, 0xFE4E, 0xFE73, 0xFE83, 0xFEB6, 0xFEBD, 0xFEC1, 0xFED1, 0xFEE5,
    0xFEED, 0xFEE6, 0xFEFD, 0xFF08, 0xFEF6, 0xFEFC, 0xFF10, 0xFF01, 0xFF0D, 0xFF11, 0xFF0C, 0xFF22, 0xFF1A, 0xFF16, 0xFF17, 0xFF21,
    0xFF23, 0xFF28, 0xFF13, 0xFECD, 0xFE80, 0xFEB5, 0xFF2C, 0xFF77, 0xFF82, 0xFF9A, 0xFF88, 0xFF89, 0xFF78, 0xFF77, 0xFF78, 0xFF63,
    0xFF6E, 0xFF62, 0xFF5D, 0xFF69, 0xFF5F, 0xFF6B, 0xFF59, 0xFF51, 0xFF66, 0xFF73, 0xFF64, 0xFF5B, 0xFF67, 0xFF52, 0xFF52, 0xFF6E,
    0xFF72, 0xFF7F, 0xFF97, 0xFF91, 0xFFA8, 0xFFA8, 0xFFB2, 0xFFA8, 0xFFA9, 0xFFBF, 0xFFA1, 0xFFA0, 0xFFCD, 0xFFDC, 0x001C, 0x006C,
    0x00D7, 0x00B7, 0xFFF4, 0xFF8A, 0xFF9F, 0xFFAF, 0xFFA5, 0xFFAF, 0xFFB4, 0xFFE1, 0xFFDC, 0xFFEA, 0x000D, 0xFFF6, 0xFFF7, 0xFFF7,
    0x0007, 0x0000, 0x000C, 0x0017, 0x0039, 0x0078, 0x0056, 0x0019, 0x0011, 0x002D, 0x0024, 0x0023, 0x0031, 0x0023, 0x001C, 0x0016,
    0xFFFE, 0xFFF3, 0x001F, 0x0034, 0x004D, 0x0052, 0x0040, 0x0046, 0x0058, 0x0042, 0x0032, 0x0040, 0x0056, 0x0050, 0x004E, 0x0064,
    0x005E, 0x0092, 0x0086, 0x0074, 0x0077, 0x0078, 0x0083, 0x0089, 0x0090, 0x0095, 0x0098, 0x008F, 0x0097, 0x00A0, 0x00BE, 0x00C3,
    0x00C9, 0x00D3, 0x00E3, 0x00E7, 0x00E6, 0x0101, 0x0103, 0x00F6, 0x00F4, 0x00ED, 0x00F6, 0x011D, 0x011B, 0x00FE, 0x00FF, 0x0108,
    0x00EA, 0x00CC, 0x00C4, 0x0109, 0x011C, 0x011B, 0x0146, 0x017D, 0x01C6, 0x024A, 0x0276, 0x0211, 0x0175, 0x00BC, 0x0071, 0x006A,
    0x0070, 0x007B, 0x00AE, 0x00BF, 0x00AD, 0x00C2, 0x00C2, 0x00DC, 0x00E1, 0x00F2, 0x00FA, 0x0114, 0x011D, 0x0114, 0x0106, 0x011F,
    0x011C, 0x012C, 0x0145, 0x0141, 0x0152, 0x015A, 0x0144, 0x013F, 0x015E, 0x016A, 0x017B, 0x01A9, 0x019B, 0x0182, 0x0195, 0x01BD,
    0x01C9, 0x01CE, 0x01D8, 0x01D4, 0x01DF, 0x01F2, 0x01F3, 0x01D3, 0x01E1, 0x01D2, 0x01CD, 0x01DE, 0x01DE, 0x01C4, 0x01CA, 0x01D1,
    0x01D6, 0x01E6, 0x01D8, 0x01C9, 0x01DD, 0x020B, 0x0212, 0x021A, 0x0232, 0x0224, 0x0222, 0x0240, 0x023F, 0x0250, 0x024E, 0x0266,
    0x025D, 0x0259, 0x026F, 0x0260, 0x0263, 0x0234, 0x020D, 0x021C, 0x026F, 0x026C, 0x027C, 0x0296, 0x02B1, 0x02C3, 0x02B7, 0x02D1,
    0x02C6, 0x02CC, 0x02CD, 0x02E3, 0x02F4, 0x02F7, 0x02EF, 0x02F7, 0x0308, 0x02EA, 0x02E8, 0x02DC, 0x02E7, 0x02D8, 0x02E7, 0x02EF,
    0x02D5, 0x02F9, 0x02DD, 0x02EB, 0x02F2, 0x02CE, 0x02E3, 0x02C3, 0x02D8, 0x02E1, 0x02C4, 0x02D8, 0x02D6, 0x02D8, 0x0307, 0x0301,
    0x02FE, 0x0306, 0x02F5, 0x02F5, 0x0304, 0x02FC, 0x0300, 0x02EB, 0x0309, 0x0322, 0x030B, 0x033F, 0x032C, 0x032E, 0x035C, 0x034A,
    0x0332, 0x032E, 0x0340, 0x0359, 0x0382, 0x0360, 0x0355, 0x034E, 0x0346, 0x0346, 0x0337, 0x0367, 0x0371, 0x036D, 0x0390, 0x0366,
    0x0377, 0x037C, 0x0371, 0x038F, 0x0389, 0x0389, 0x0366, 0x0344, 0x0376, 0x0369, 0x0368, 0x0381, 0x0370, 0x0366, 0x0361, 0x036D,
    0x037D, 0x037D, 0x038C, 0x0384, 0x0378, 0x0385, 0x0385, 0x0375, 0x034E, 0x0334, 0x0353, 0x036B, 0x035E, 0x037C, 0x0392, 0x035B,
    0x0395, 0x0389, 0x038F, 0x039C, 0x0394, 0x03B9, 0x037A, 0x03A3, 0x03B6, 0x03A8, 0x038E, 0x0394, 0x0399, 0x038B, 0x03BD, 0x0389,
    0x0399, 0x03A0, 0x038A, 0x0384, 0x0379, 0x0394, 0x038E, 0x03A4, 0x03A2, 0x03B1, 0x03B9, 0x03B9, 0x03E4, 0x03EC, 0x03E1, 0x03C5,
    0x03E5, 0x03DF, 0x03D7, 0x03F5, 0x03FB, 0x03FD, 0x040C, 0x03F3, 0x040A, 0x0424, 0x03F4, 0x03FA, 0x0418, 0x0406, 0x03FD, 0x03F0,
    0x0387, 0x031B, 0x0308, 0x02DB, 0x0301, 0x03D5, 0x04A2, 0x04A4, 0x04D1, 0x04D2, 0x048F, 0x04C3, 0x04B0, 0x047C, 0x0487, 0x047F,
    0x047C, 0x0498, 0x0467, 0x0466, 0x0467, 0x0466, 0x047F, 0x0458, 0x0463, 0x0440, 0x0446, 0x0448, 0x0422, 0x0437, 0x0416, 0x0410,
    0x0412, 0x0427, 0x0400, 0x03E1, 0x03D4, 0x03B1, 0x03D7, 0x03F0, 0x040B, 0x03DA, 0x03CD, 0x03FC, 0x03D0, 0x03E4, 0x03FC, 0x03E4,
    0x03EA, 0x0411, 0x03FF, 0x0408, 0x040E, 0x0404, 0x0417, 0x03D5, 0x03FA, 0x03E0, 0x03DC, 0x0404, 0x03F8, 0x03C9, 0x03DD, 0x03FD,
    0x03CF, 0x03F7, 0x040A, 0x03F3, 0x03EF, 0x0421, 0x0416, 0x0419, 0x0432, 0x03FF, 0x03F9, 0x042C, 0x0407, 0x0427, 0x044A, 0x041B,
    0x0413, 0x0428, 0x0403, 0x03EA, 0x0405, 0x041D, 0x0451, 0x04A3, 0x04B2, 0x0486, 0x0425, 0x042D, 0x0457, 0x0433, 0x0431, 0x040A,
    0x040C, 0x040F, 0x03DD, 0x03F3, 0x03F5, 0x03D7, 0x03E8, 0x0407, 0x03DA, 0x0427, 0x0421, 0x0422, 0x0459, 0x0450, 0x047D, 0x0491,
    0x0498, 0x048B, 0x04AB, 0x04A2, 0x048C, 0x048B, 0x0494, 0x04CC, 0x04B1, 0x04BE, 0x04AC, 0x04B5, 0x04A2, 0x049F, 0x0487, 0x0463,
    0x0468, 0x0469, 0x0471, 0x0464, 0x0473, 0x0469, 0x0460, 0x0473, 0x0465, 0x046C, 0x0453, 0x044E, 0x042A, 0x0401, 0x041F, 0x0416,
    0x043A, 0x0431, 0x041D, 0x0438, 0x040F, 0x03F6, 0x0409, 0x0406, 0x03DD, 0x03EB, 0x03DB, 0x03E0, 0x03DF, 0x03E1, 0x03EA, 0x040A,
    0x041E, 0x041C, 0x042E, 0x0457, 0x0481, 0x0498, 0x04E3, 0x04E0, 0x04F8, 0x0531, 0x051F, 0x0574, 0x058E, 0x0597, 0x05FA, 0x064A,
    0x067D, 0x06B2, 0x06F0, 0x0707, 0x0789, 0x07A1, 0x0776, 0x0787, 0x080C, 0x0829, 0x08C7, 0x0952, 0x098D, 0x0969, 0x09D4, 0x0A67,
    0x0BAC, 0x0C89, 0x0CB4, 0x0CDA, 0x0D30, 0x0D0E, 0x0D2E, 0x0DDD, 0x0DD3, 0x0E0B, 0x0E40, 0x0F40, 0x0F88, 0x10BA, 0x1171, 0x133C,
    0x14CE, 0x1880, 0x1ABA, 0x1E00, 0x2002, 0x2448, 0x2ACF, 0x2DA9, 0x2EBA, 0x337A, 0x3A03, 0x3F39, 0x401F, 0x3F19, 0x419C, 0x43D5,
    0x45E8, 0x3F73, 0x3D30, 0x3629, 0x3255, 0x20A1, 0x2216, 0x07C5, 0xF4BD, 0x14FE, 0x0CA8, 0xDC40, 0x9F15, 0x9C30, 0xA035, 0xA5A4,
    0xAF62, 0xB40A, 0xB53C, 0xB590, 0xBAEE, 0xBDA1, 0xC2F4, 0xC362, 0xC6AF, 0xC58B, 0xCF93, 0xD5E1, 0xD89F, 0xD856, 0xE27A, 0xEC76,
    0xE7F0, 0xD9EA, 0xD034, 0xCDA5, 0xCE10, 0xD493, 0xD34F, 0xD7AF, 0xD57E, 0xD6CD, 0xD244, 0xD904, 0xDE97, 0xD67A, 0xE1CE, 0xE679,
    0xECA1, 0xE869, 0xF8AB, 0x134C, 0x1696, 0x097A, 0x011A, 0x13D9, 0x33EA, 0x50B2, 0x5A8C, 0x6077, 0x5709, 0x5A8B, 0x540A, 0x4BA5,
    0x5253, 0x4B95, 0x4AE2, 0x4B7C, 0x4D8F, 0x4585, 0x4348, 0x4A02, 0x44E8, 0x2866, 0x136F, 0x1458, 0x1D26, 0x1CC1, 0x08AA, 0xEA8A,
    0xCBC8, 0xBE85, 0xB9BB, 0xBA63, 0xBB4D, 0xBEAE, 0xBE30, 0xBE5F, 0xBF9F, 0xC086, 0xBE9A, 0xBBDE, 0xBF94, 0xBE79, 0xBFFC, 0xBEE3,
    0xC718, 0xCAA2, 0xCC68, 0xCB1C, 0xC6C9, 0xD09E, 0xD5F7, 0xD991, 0xDB7D, 0xE2BE, 0xE402, 0xE20A, 0xE5C5, 0xECB0, 0xE8D2, 0xE299,
    0xE7AD, 0xEBF6, 0xEC4C, 0xDFE7, 0xE372, 0xF2CE, 0x0326, 0x0D3C, 0x0343, 0xF63F, 0xF8CD, 0x0947, 0x1C51, 0x329A, 0x4394, 0x49FD,
    0x48C7, 0x4B5D, 0x493D, 0x4260, 0x40F5, 0x4728, 0x47B2, 0x3D66, 0x3A2E, 0x40A8, 0x4A0F, 0x46A9, 0x3654, 0x2259, 0x1BED, 0x1FB5,
    0x243B, 0x1F4A, 0x1023, 0xFB26, 0xE02B, 0xCFD3, 0xC6D5, 0xC3FC, 0xBF27, 0xBF56, 0xC301, 0xC269, 0xC2CF, 0xC2E6, 0xC496, 0xC49D,
    0xC37B, 0xBE91, 0xBF07, 0xC56A, 0xCB24, 0xCA58, 0xCB5B, 0xCD8A, 0xCAA1, 0xCCFE, 0xD255, 0xDA02, 0xDAD8, 0xDA5F, 0xE28F, 0xE9FD,
    0xE851, 0xE46E, 0xE396, 0xE842, 0xEFCA, 0xEDA7, 0xE2D6, 0xDD50, 0xE8DE, 0xF7EE, 0x00D2, 0x024F, 0xFD23, 0xF46D, 0xF3E7, 0x018E,
    0x1212, 0x1FC8, 0x2E8C, 0x3ED4, 0x43F7, 0x40CC, 0x3D5A, 0x425C, 0x475D, 0x43E0, 0x3AE2, 0x34DB, 0x3C9C, 0x4673, 0x49E3, 0x41B9,
    0x34F0, 0x28F6, 0x21FE, 0x2525, 0x29FC, 0x259F, 0x1801, 0x070D, 0xF324, 0xE188, 0xD2F3, 0xCA39, 0xC51D, 0xC4EC, 0xC50D, 0xC174,
    0xC37D, 0xC821, 0xC8E0, 0xC508, 0xC1A5, 0xC1A5, 0xC274, 0xC34D, 0xC9B4, 0xCE88, 0xCBC4, 0xC96A, 0xCCDE, 0xD1D5, 0xD365, 0xD377,
    0xD561, 0xDE0E, 0xE6F0, 0xE758, 0xE296, 0xE467, 0xED4C, 0xF38D, 0xF20F, 0xEC85, 0xE65A, 0xE3AF, 0xEDFD, 0xFC6B, 0x0397, 0x0021,
    0xFB17, 0xFA18, 0xF996, 0xFCA9, 0x0668, 0x18A1, 0x2B86, 0x35ED, 0x3733, 0x396B, 0x418C, 0x48E2, 0x467E, 0x3DEA, 0x383D, 0x3806,
    0x3F04, 0x477E, 0x4A41, 0x42F0, 0x372F, 0x2E11, 0x2A8C, 0x2D0A, 0x2E78, 0x29BF, 0x221B, 0x1710, 0x050E, 0xF0D7, 0xE1BE, 0xD979,
    0xD138, 0xC979, 0xC76F, 0xC950, 0xC9F7, 0xCA8A, 0xCCFD, 0xCBAD, 0xC659, 0xC3C0, 0xC663, 0xCAE3, 0xCE49, 0xCDC7, 0xCD49, 0xD10E,
    0xD558, 0xD3DF, 0xCFDC, 0xD3BD, 0xDD11, 0xE401, 0xE529, 0xE3DD, 0xE372, 0xE6EB, 0xEF71, 0xF560, 0xF20F, 0xE892, 0xE34F, 0xE786,
    0xF0B3, 0xF81B, 0xFC84, 0xFF4A, 0x0079, 0xFCAD, 0xF648, 0xF8CF, 0x065B, 0x1604, 0x1F24, 0x2369, 0x293C, 0x3209, 0x3BEF, 0x41F7,
    0x3F13, 0x374B, 0x3205, 0x33E0, 0x3CBB, 0x446F, 0x448B, 0x3D73, 0x3583, 0x3033, 0x2C6E, 0x2A9D, 0x2CA2, 0x2DF9, 0x27B3, 0x1B4E,
    0x0DC8, 0xFF67, 0xEF64, 0xE1DB, 0xD79B, 0xCFF1, 0xCAF9, 0xC917, 0xCA44, 0xCD0B, 0xCDDB, 0xC8ED, 0xC489, 0xC603, 0xC983, 0xC934,
    0xC7DE, 0xCB45, 0xD128, 0xD309, 0xD0C3, 0xCE9E, 0xCF1A, 0xD407, 0xDBA5, 0xE104, 0xDFD1, 0xDC62, 0xDF0E, 0xE842, 0xF05B, 0xF02A,
    0xEA16, 0xE54E, 0xE427, 0xE4A5, 0xE763, 0xEF15, 0xF940, 0xFCEE, 0xF81F, 0xF036, 0xEC6D, 0xF150, 0xFB8B, 0x0528, 0x0BE2, 0x1341,
    0x1DCC, 0x2B5D, 0x37F3, 0x3D9C, 0x39A0, 0x3187, 0x2F3A, 0x34B0, 0x3B4A, 0x3EF1, 0x40DC, 0x3E94, 0x3702, 0x2F74, 0x2CFE, 0x2E67,
    0x2F2E, 0x2E98, 0x2B5C, 0x23B3, 0x1830, 0x0A57, 0xFC59, 0xEF59, 0xE191, 0xD3C5, 0xCC27, 0xCCB5, 0xCF4B, 0xCE81, 0xCBCF, 0xCAA8,
    0xCAF9, 0xC9CC, 0xC803, 0xC7DB, 0xCA46, 0xCF95, 0xD487, 0xD502, 0xD09C, 0xCC24, 0xCDAC, 0xD4F1, 0xDA71, 0xDA0A, 0xD6E1, 0xD847,
    0xDF71, 0xE639, 0xE9DB, 0xEB6E, 0xEABE, 0xE6F2, 0xE171, 0xDF1C, 0xE441, 0xEE9D, 0xF73A, 0xF88B, 0xF3E9, 0xEEF6, 0xEDEB, 0xF198,
    0xF811, 0xFDA9, 0x00F8, 0x0783, 0x1664, 0x2856, 0x33AB, 0x36AB, 0x3585, 0x328A, 0x3054, 0x3335, 0x3A64, 0x4061, 0x41AE, 0x3EA7,
    0x3956, 0x3429, 0x315E, 0x30D7, 0x320A, 0x33D8, 0x31D7, 0x2A8E, 0x21FD, 0x1A0E, 0x0F1C, 0xFE51, 0xEC57, 0xE036, 0xDA38, 0xD6DC,
    0xD41E, 0xD217, 0xD199, 0xD1C2, 0xD0CB, 0xCE08, 0xCAC0, 0xC9F1, 0xCD7E, 0xD3AF, 0xD6CB, 0xD362, 0xCEBC, 0xD022, 0xD66A, 0xDAF0,
    0xDB94, 0xDAFE, 0xDC0B, 0xDE9C, 0xE247, 0xE7E0, 0xEEA5, 0xF34D, 0xF2E3, 0xED07, 0xE6D2, 0xE696, 0xEC96, 0xF57D, 0xFC87, 0xFDB5,
    0xF99B, 0xF61B, 0xF7BD, 0xFB20, 0xFBF3, 0xFC20, 0xFF6E, 0x086F, 0x16B2, 0x2645, 0x325C, 0x37E5, 0x3777, 0x348D, 0x33A4, 0x37C3,
    0x3E11, 0x4267, 0x4434, 0x436B, 0x3EFF, 0x38A5, 0x356D, 0x36D7, 0x3898, 0x370F, 0x33CB, 0x31B9, 0x2EEF, 0x2796, 0x1AEF, 0x0AD7,
    0xFB2F, 0xEEDA, 0xE5B8, 0xDEBF, 0xD96E, 0xD6C5, 0xD733, 0xD831, 0xD5C5, 0xCFB3, 0xCBA8, 0xCDE5, 0xD3D7, 0xD795, 0xD695, 0xD424,
    0xD42B, 0xD71B, 0xDA7B, 0xDC84, 0xDDD4, 0xDF34, 0xDF4D, 0xDF1F, 0xE29A, 0xEA97, 0xF2A2, 0xF6AE, 0xF5C1, 0xF028, 0xE9ED, 0xE9D7,
    0xF12F, 0xF95F, 0xFC80, 0xFBB2, 0xFB4E, 0xFD0C, 0xFF63, 0xFFF2, 0xFE10, 0xFBC2, 0xFC85, 0x0366, 0x10DF, 0x211C, 0x2D9A, 0x3337,
    0x3479, 0x3473, 0x34BB, 0x36DD, 0x3C2C, 0x431C, 0x4691, 0x4447, 0x3F58, 0x3BFF, 0x3AE9, 0x3A3A, 0x3897, 0x36FE, 0x3765, 0x3896,
    0x36E1, 0x308A, 0x2592, 0x17BF, 0x0A2F, 0xFE0F, 0xF22E, 0xE6B6, 0xDF79, 0xDEC0, 0xE032, 0xDDC7, 0xD722, 0xD190, 0xD115, 0xD43F,
    0xD6EB, 0xD750, 0xD6DA, 0xD6BB, 0xD6E2, 0xD7E9, 0xDADE, 0xDE67, 0xDFEC, 0xDF7A, 0xDE68, 0xDE57, 0xE1D1, 0xEA55, 0xF452, 0xF8DA,
    0xF59B, 0xEF30, 0xEC25, 0xEEA1, 0xF3F0, 0xF801, 0xF971, 0xFA2F, 0xFBD3, 0xFE87, 0x012E, 0x01B5, 0xFE34, 0xF8D2, 0xF79C, 0xFE5B,
    0x0A8F, 0x182D, 0x2466, 0x2D7A, 0x315E, 0x30C5, 0x309B, 0x34B9, 0x3C18, 0x41ED, 0x43A3, 0x42C1, 0x41A8, 0x401A, 0x3DF1, 0x3B3A,
    0x388B, 0x378A, 0x39A4, 0x3C8F, 0x3BDC, 0x35DC, 0x2D43, 0x2437, 0x1933, 0x0AE6, 0xFC92, 0xF321, 0xF047, 0xF0AF, 0xEE9C, 0xE86D,
    0xE199, 0xDD9C, 0xDC33, 0xDBE3, 0xDBEE, 0xDA7C, 0xD53F, 0xCE0A, 0xCAA8, 0xCD61, 0xD156, 0xD58B, 0xD897, 0xD767, 0xD4B8, 0xD470,
    0xDA53, 0xE4E0, 0xEDDE, 0xF07E, 0xEDE2, 0xEB2A, 0xEA9B, 0xECA6, 0xF03E, 0xF32B, 0xF425, 0xF4A7, 0xF81F, 0xFDC3, 0x0157, 0x0034,
    0xFBA6, 0xF751, 0xF5A7, 0xF8B6, 0x0186, 0x0EF2, 0x1C78, 0x2538, 0x288A, 0x29E8, 0x2CFB, 0x3238, 0x380D, 0x3C73, 0x3EE7, 0x4062,
    0x418A, 0x4180, 0x3EEE, 0x3A4D, 0x371A, 0x3812, 0x3B15, 0x3C69, 0x3B07, 0x3890, 0x35E3, 0x300B, 0x2393, 0x12C9, 0x03FE, 0xFA44,
    0xF3D7, 0xEECC, 0xE9A2, 0xE36F, 0xDD3D, 0xD935, 0xD7CC, 0xD7E3, 0xD84E, 0xD8A4, 0xD80F, 0xD670, 0xD553, 0xD70F, 0xDBB1, 0xDFFB,
    0xDFDE, 0xDB93, 0xD78B, 0xD84B, 0xDE70, 0xE6C0, 0xED4F, 0xEF96, 0xEE13, 0xEC4C, 0xECF0, 0xEF7A, 0xF16B, 0xF157, 0xF109, 0xF365,
    0xF84B, 0xFD4A, 0x003C, 0x0053, 0xFD2E, 0xF77D, 0xF2FE, 0xF46A, 0xFCBA, 0x0893, 0x13BC, 0x1B8B, 0x1FF0, 0x235A, 0x2813, 0x2DE8,
    0x32D1, 0x3620, 0x39AB, 0x3E26, 0x4139, 0x40C1, 0x3D0D, 0x38EC, 0x37BA, 0x3911, 0x399E, 0x3924, 0x3A04, 0x3BBE, 0x3AF8, 0x34D1,
    0x2991, 0x1B90, 0x0EAC, 0x0468, 0xFC03, 0xF4C5, 0xEDC7, 0xE6EC, 0xE100, 0xDC3F, 0xD912, 0xD835, 0xD8DD, 0xD8F6, 0xD6C7, 0xD383,
    0xD2ED, 0xD6EF, 0xDC6A, 0xDF24, 0xDD7A, 0xD966, 0xD608, 0xD6A0, 0xDC3C, 0xE3D1, 0xE92E, 0xEA94, 0xEA4D, 0xEB3B, 0xED4B, 0xEE8E,
    0xEE4B, 0xEDE7, 0xEE84, 0xF078, 0xF4BD, 0xFAA6, 0xFFBB, 0x00D8, 0xFD14, 0xF6C0, 0xF23A, 0xF380, 0xFA80, 0x0453, 0x0D2D, 0x13DC,
    0x19D3, 0x203B, 0x262E, 0x2A4E, 0x2D02, 0x310B, 0x3767, 0x3D0F, 0x3EE3, 0x3D5A, 0x3B99, 0x3A8C, 0x3905, 0x36AC, 0x352B, 0x3620,
    0x3986, 0x3D2B, 0x3DD3, 0x395A, 0x2FFA, 0x242A, 0x18BB, 0x0ECE, 0x05FF, 0xFE15, 0xF6D5, 0xEF64, 0xE757, 0xE084, 0xDD9C, 0xDDC2,
    0xDDCF, 0xDB68, 0xD727, 0xD3E8, 0xD456, 0xD85E, 0xDD56, 0xDF5E, 0xDC93, 0xD77C, 0xD4E3, 0xD74F, 0xDC15, 0xDFAD, 0xE11C, 0xE1E6,
    0xE354, 0xE549, 0xE886, 0xED56, 0xEFF7, 0xEF1F, 0xEE67, 0xEFA1, 0xF424, 0xFB24, 0x00A3, 0x01F8, 0xFDF7, 0xF78E, 0xF369, 0xF40A,
    0xF8E5, 0xFF07, 0x050B, 0x0C30, 0x14BF, 0x1C23, 0x205B, 0x236A, 0x27C2, 0x2E14, 0x34CD, 0x3979, 0x3BF9, 0x3D50, 0x3E0E, 0x3D41,
    0x3AAE, 0x374C, 0x3541, 0x3683, 0x3A89, 0x3EC3, 0x4017, 0x3D08, 0x363C, 0x2CDB, 0x2210, 0x17E6, 0x0F4B, 0x0792, 0xFEC3, 0xF438,
    0xEA56, 0xE3DC, 0xE19A, 0xE0E1, 0xDF3F, 0xDB5C, 0xD643, 0xD2D3, 0xD38F, 0xD826, 0xDCE2, 0xDD84, 0xDA49, 0xD68E, 0xD4FC, 0xD5E8,
    0xD897, 0xDC42, 0xDFAB, 0xE26E, 0xE4EA, 0xE7A7, 0xEA3E, 0xEBF8, 0xEBBE, 0xE9CA, 0xE805, 0xE91B, 0xEE7D, 0xF67B, 0xFD13, 0xFE16,
    0xFA61, 0xF5FE, 0xF399, 0xF353, 0xF472, 0xF7BF, 0xFDEE, 0x0665, 0x0E5F, 0x145A, 0x190D, 0x1E1F, 0x2430, 0x2A73, 0x3016, 0x34C5,
    0x38CE, 0x3C2E, 0x3E47, 0x3DE3, 0x3A7E, 0x362F, 0x340F, 0x3585, 0x392C, 0x3D2F, 0x3FF9, 0x3F7C, 0x3A78, 0x31E0, 0x287B, 0x2020,
    0x1882, 0x1017, 0x05BC, 0xFA2C, 0xEFC0, 0xE8AD, 0xE5B4, 0xE496, 0xE18F, 0xDB9C, 0xD57F, 0xD2A3, 0xD40F, 0xD7B7, 0xDAA8, 0xDABD,
    0xD88D, 0xD5F8, 0xD464, 0xD48E, 0xD64F, 0xD8CF, 0xDB4C, 0xDDD7, 0xE101, 0xE4D7, 0xE8C8, 0xEB4A, 0xEAFA, 0xE7D2, 0xE50F, 0xE69D,
    0xED3B, 0xF522, 0xFA0D, 0xFB50, 0xFA86, 0xF8A7, 0xF5D8, 0xF343, 0xF295, 0xF52B, 0xFACC, 0x01C2, 0x0837, 0x0DEB, 0x1347, 0x193D,
    0x1F77, 0x2511, 0x299C, 0x2E82, 0x3492, 0x39DD, 0x3C60, 0x3B3F, 0x37E5, 0x33F2, 0x311E, 0x30B1, 0x3386, 0x38EC, 0x3D96, 0x3E4D,
    0x3AA0, 0x3440, 0x2D17, 0x2648, 0x1F5D, 0x1734, 0x0C65, 0xFFCF, 0xF4C7, 0xEE47, 0xEB77, 0xE88B, 0xE320, 0xDC1D, 0xD633, 0xD379,
    0xD42A, 0xD6B3, 0xD8CF, 0xD8FE, 0xD77B, 0xD57D, 0xD461, 0xD461, 0xD533, 0xD6E1, 0xD89A, 0xDA3C, 0xDD40, 0xE2C4, 0xE8CD, 0xEB60,
    0xE949, 0xE561, 0xE3C5, 0xE60D, 0xEBC0, 0xF1E9, 0xF673, 0xF90E, 0xF9B1, 0xF814, 0xF4A2, 0xF14F, 0xEFF6, 0xF19D, 0xF5AA, 0xFAD0,
    0xFFDB, 0x0555, 0x0BBF, 0x1263, 0x17E6, 0x1C4B, 0x2135, 0x27C2, 0x2ECE, 0x34CB, 0x38C9, 0x39B6, 0x3778, 0x3319, 0x2F58, 0x2E8F,
    0x317C, 0x3641, 0x3A91, 0x3C32, 0x39F5, 0x34FE, 0x2FE6, 0x2B8B, 0x25F7, 0x1D4C, 0x1160, 0x04EE, 0xFAD3, 0xF4A4, 0xF09B, 0xEBE5,
    0xE538, 0xDDCE, 0xD7EC, 0xD550, 0xD5D2, 0xD793, 0xD8FE, 0xD94F, 0xD844, 0xD687, 0xD551, 0xD5A5, 0xD689, 0xD68C, 0xD5BF, 0xD69F,
    0xDB19, 0xE1F9, 0xE7A3, 0xE94A, 0xE74D, 0xE46D, 0xE355, 0xE4A1, 0xE85A, 0xED74, 0xF2D9, 0xF71D, 0xF968, 0xF89B, 0xF541, 0xF1E3,
    0xF08C, 0xF155, 0xF313, 0xF5E1, 0xFA31, 0x0019, 0x0655, 0x0BFE, 0x10D1, 0x155E, 0x1A99, 0x20EE, 0x284D, 0x2FAA, 0x354C, 0x377E,
    0x3647, 0x32B2, 0x2F0A, 0x2DC5, 0x3028, 0x34EE, 0x394C, 0x3AF8, 0x397E, 0x36E4, 0x34E2, 0x32A6, 0x2D9B, 0x24E3, 0x195A, 0x0DAC,
    0x044F, 0xFDDC, 0xF8B1, 0xF251, 0xEA53, 0xE266, 0xDC51, 0xD8AD, 0xD79B, 0xD89A, 0xD9E5, 0xD992, 0xD7DC, 0xD6B3, 0xD70E, 0xD817,
    0xD7AE, 0xD5A2, 0xD3F4, 0xD553, 0xDA3D, 0xE081, 0xE57E, 0xE77A, 0xE6B5, 0xE506, 0xE3D7, 0xE3E7, 0xE5E0, 0xEA43, 0xF02F, 0xF574,
    0xF829, 0xF7E6, 0xF5ED, 0xF3D2, 0xF225, 0xF109, 0xF10D, 0xF311, 0xF703, 0xFC00, 0x017C, 0x06C6, 0x0B60, 0x0F76, 0x1439, 0x1A96,
    0x2262, 0x2A8D, 0x3160, 0x3537, 0x3513, 0x31B8, 0x2DB1, 0x2C56, 0x2ED6, 0x32D7, 0x35AE, 0x3652, 0x35FA, 0x35C4, 0x361F, 0x35A3,
    0x3204, 0x2A00, 0x1F7A, 0x155B, 0x0D19, 0x0641, 0xFFDD, 0xF8C9, 0xF076, 0xE7D7, 0xE05E, 0xDBD5, 0xDA7F, 0xDACA, 0xDA65, 0xD892,
    0xD71C, 0xD759, 0xD874, 0xD89F, 0xD6D7, 0xD408, 0xD271, 0xD3C9, 0xD803, 0xDD6C, 0xE216, 0xE4E6, 0xE5BB, 0xE4FA, 0xE330, 0xE203,
    0xE376, 0xE7F2, 0xEDB1, 0xF2A9, 0xF5C3, 0xF6F7, 0xF6B1, 0xF556, 0xF376, 0xF1E8, 0xF126, 0xF1CD, 0xF47C, 0xF8A3, 0xFD50, 0x01D4,
    0x05D9, 0x097B, 0x0DD1, 0x139B, 0x1B6A, 0x2489, 0x2D48, 0x3263, 0x32B0, 0x2FD7, 0x2D0F, 0x2C8E, 0x2E72, 0x3150, 0x3306, 0x337E,
    0x341D, 0x3603, 0x3850, 0x38C3, 0x358C, 0x2ECC, 0x2636, 0x1D3D, 0x1519, 0x0E39, 0x0818, 0x00B6, 0xF75A, 0xED56, 0xE55F, 0xE0D8,
    0xDEAC, 0xDCC9, 0xDA61, 0xD838, 0xD7A4, 0xD8B1, 0xD9FA, 0xD9AB, 0xD731, 0xD425, 0xD268, 0xD2FC, 0xD5C1, 0xDA14, 0xDEDC, 0xE2DE,
    0xE4B3, 0xE3D3, 0xE1B9, 0xE095, 0xE1B7, 0xE4EC, 0xE9A2, 0xEE7D, 0xF270, 0xF510, 0xF61E, 0xF5A0, 0xF40F, 0xF214, 0xF08E, 0xF0A8,
    0xF2AD, 0xF5FE, 0xF9E8, 0xFE23, 0x01E4, 0x04C4, 0x07C0, 0x0CCA, 0x1512, 0x1F41, 0x2892, 0x2E4A, 0x2FA5, 0x2E50, 0x2CD9, 0x2D47,
    0x2EDE, 0x3000, 0x3037, 0x30A2, 0x326C, 0x3583, 0x38A2, 0x39E8, 0x382E, 0x3330, 0x2B95, 0x2357, 0x1C68, 0x16BF, 0x10A5, 0x084C,
    0xFDE8, 0xF3BA, 0xEBF5, 0xE6F2, 0xE32F, 0xDF66, 0xDBAB, 0xD931, 0xD8D9, 0xDA2D, 0xDB0F, 0xDA2B, 0xD7F1, 0xD55F, 0xD32A, 0xD251,
    0xD3EC, 0xD7E1, 0xDCE3, 0xE128, 0xE33B, 0xE305, 0xE19B, 0xE06D, 0xE0BD, 0xE301, 0xE6C7, 0xEB26, 0xEF7D, 0xF34F, 0xF5BC, 0xF62B,
    0xF502, 0xF2F4, 0xF13F, 0xF092, 0xF15C, 0xF402, 0xF80D, 0xFC00, 0xFED9, 0x007A, 0x0288, 0x0706, 0x0F44, 0x19DE, 0x237F, 0x299C,
    0x2BDF, 0x2C34, 0x2CCB, 0x2DE1, 0x2E7F, 0x2E5A, 0x2E15, 0x2E7E, 0x302A, 0x3366, 0x376C, 0x3A2F, 0x39BC, 0x357C, 0x2EEC, 0x2860,
    0x2321, 0x1E31, 0x17B4, 0x0EE2, 0x048D, 0xFAD5, 0xF347, 0xED42, 0xE771, 0xE1C1, 0xDD33, 0xDAD7, 0xDA5B, 0xDAF4, 0xDB48, 0xDABB,
    0xD904, 0xD61F, 0xD32C, 0xD187, 0xD25B, 0xD5AB, 0xDA3C, 0xDE68, 0xE0FE, 0xE196, 0xE0C9, 0xDFD8, 0xDFE8, 0xE11A, 0xE398, 0xE789,
    0xEC67, 0xF0D8, 0xF3F8, 0xF57F, 0xF55E, 0xF3E7, 0xF1DF, 0xF05F, 0xF0A6, 0xF337, 0xF724, 0xFAD0, 0xFCAE, 0xFCFC, 0xFDED, 0x023F,
    0x0A9B, 0x14BD, 0x1DBE, 0x2412, 0x27F9, 0x2AA7, 0x2CA1, 0x2E2B, 0x2ED7, 0x2E9B, 0x2DA8, 0x2D1B, 0x2E86, 0x3236, 0x3722, 0x3AAE,
    0x3AE2, 0x37AC, 0x32E1, 0x2E43, 0x2A4F, 0x25C2, 0x1F11, 0x1623, 0x0C86, 0x03C9, 0xFBDD, 0xF446, 0xECE1, 0xE635, 0xE0D4, 0xDD5A,
    0xDBBB, 0xDBB4, 0xDC4F, 0xDC3C, 0xDAA7, 0xD7C8, 0xD491, 0xD24C, 0xD240, 0xD4DD, 0xD8DF, 0xDCC8, 0xDF90, 0xE116, 0xE13E, 0xE08C,
    0xDFC2, 0xDFE4, 0xE152, 0xE47E, 0xE911, 0xED95, 0xF106, 0xF2D0, 0xF370, 0xF250, 0xEFF3, 0xEE0F, 0xEE79, 0xF177, 0xF59D, 0xF8D4,
    0xF98C, 0xF8EC, 0xF9B7, 0xFDF3, 0x0551, 0x0E56, 0x16F3, 0x1E14, 0x237D, 0x27C4, 0x2B42, 0x2DF2, 0x2F2B, 0x2E87, 0x2CA9, 0x2B7B,
    0x2CAF, 0x30A1, 0x35F9, 0x39C5, 0x3A59, 0x384A, 0x35A9, 0x3319, 0x301C, 0x2BCA, 0x2579, 0x1DAC, 0x1536, 0x0D2D, 0x0533, 0xFD1A,
    0xF4FD, 0xED34, 0xE6AA, 0xE218, 0xDF9E, 0xDF10, 0xDF80, 0xDF36, 0xDDA1, 0xDA37, 0xD652, 0xD381, 0xD2CD, 0xD420, 0xD6EB, 0xDA72,
    0xDD98, 0xDFE1, 0xE0D5, 0xE08B, 0xDF7D, 0xDF00, 0xDFEA, 0xE26B, 0xE641, 0xEA98, 0xEEFC, 0xF2B5, 0xF486, 0xF392, 0xF0C6, 0xEEAC,
    0xEF23, 0xF225, 0xF5CA, 0xF7DA, 0xF7CC, 0xF6EA, 0xF748, 0xFA73, 0x0089, 0x0848, 0x105B, 0x17C5, 0x1DFA, 0x236B, 0x287A, 0x2CB6,
    0x2F04, 0x2E94, 0x2C5B, 0x2AD1, 0x2C78, 0x30D5, 0x3591, 0x38C4, 0x39C5, 0x3961, 0x3877, 0x373E, 0x34E7, 0x30EA, 0x2B3F, 0x24B3,
    0x1D96, 0x161F, 0x0E48, 0x05A8, 0xFC8F, 0xF3E4, 0xEC28, 0xE615, 0xE26A, 0xE144, 0xE15B, 0xE0F9, 0xDF2A, 0xDBF1, 0xD824, 0xD503,
    0xD363, 0xD367, 0xD51B, 0xD7F7, 0xDB4A, 0xDDFC, 0xDF58, 0xDF4A, 0xDEA0, 0xDE31, 0xDE68, 0xDF83, 0xE216, 0xE64D, 0xEBB3, 0xF0A2,
    0xF311, 0xF241, 0xEFC1, 0xEE26, 0xEEF6, 0xF1C3, 0xF4D7, 0xF6A9, 0xF69A, 0xF5BE, 0xF593, 0xF7BE, 0xFCA6, 0x037A, 0x0AC4, 0x1197,
    0x17F8, 0x1E7B, 0x2550, 0x2AE6, 0x2D5F, 0x2CDE, 0x2B0A, 0x2A03, 0x2B66, 0x2EB1, 0x3259, 0x3535, 0x3724, 0x3843, 0x38C4, 0x388C,
    0x36E5, 0x33A5, 0x2F2A, 0x29D1, 0x23C4, 0x1D27, 0x15DE, 0x0DB2, 0x04AA, 0xFB0F, 0xF203, 0xEAC7, 0xE62D, 0xE40D, 0xE368, 0xE288,
    0xE083, 0xDD27, 0xD952, 0xD5E9, 0xD3AE, 0xD329, 0xD434, 0xD67D, 0xD9B3, 0xDC88, 0xDE62, 0xDF70, 0xDFB0, 0xDF54, 0xDE68, 0xDE2F,
    0xDFEE, 0xE45C, 0xEA8A, 0xEFFE, 0xF2B8, 0xF291, 0xF0C3, 0xEF6B, 0xF00F, 0xF258, 0xF4D5, 0xF65E, 0xF663, 0xF557, 0xF4BC, 0xF63E,
    0xFA23, 0xFF67, 0x04F2, 0x0AA6, 0x1154, 0x192C, 0x2144, 0x2797, 0x2AB5, 0x2AE4, 0x29D9, 0x299A, 0x2AF7, 0x2D6B, 0x3032, 0x32C0,
    0x34EA, 0x36F7, 0x3886, 0x3934, 0x389E, 0x3696, 0x3312, 0x2E69, 0x292B, 0x2373, 0x1D25, 0x15C1, 0x0CDB, 0x02CC, 0xF8D0, 0xF087,
    0xEAE0, 0xE7AC, 0xE62D, 0xE4FB, 0xE34C, 0xE0B7, 0xDD4F, 0xD97A, 0xD60C, 0xD417, 0xD42E, 0xD5C3, 0xD7EB, 0xDA16, 0xDC47, 0xDE23,
    0xDEE4, 0xDE37, 0xDC96, 0xDB8C, 0xDCAA, 0xE0C2, 0xE68D, 0xEBCD, 0xEF04, 0xEFCC, 0xEF00, 0xEE85, 0xEF72, 0xF1AF, 0xF464, 0xF5E1,
    0xF591, 0xF457, 0xF3BD, 0xF4DE, 0xF7A7, 0xFB22, 0xFEC1, 0x037A, 0x0A63, 0x12FF, 0x1B9D, 0x2275, 0x264C, 0x2793, 0x27B4, 0x2814,
    0x2920, 0x2ACD, 0x2CDC, 0x2F04, 0x315D, 0x33F4, 0x362E, 0x37E7, 0x387A, 0x378A, 0x34ED, 0x3141, 0x2CFE, 0x287B, 0x2378, 0x1D2E,
    0x14D4, 0x0AE1, 0x00CA, 0xF7CE, 0xF0ED, 0xEC71, 0xE9BE, 0xE7F3, 0xE64C, 0xE3C7, 0xE023, 0xDC05, 0xD85E, 0xD601, 0xD517, 0xD50F,
    0xD5EF, 0xD7F5, 0xDABE, 0xDD44, 0xDE97, 0xDDF5, 0xDBFB, 0xDA7D, 0xDB27, 0xDE7A, 0xE3A7, 0xE8CA, 0xEC56, 0xED8E, 0xED64, 0xED69,
    0xEEB6, 0xF14B, 0xF3D8, 0xF4DE, 0xF46B, 0xF390, 0xF366, 0xF439, 0xF5B2, 0xF739, 0xF97B, 0xFD97, 0x0452, 0x0D3A, 0x1635, 0x1D69,
    0x2237, 0x24C1, 0x2627, 0x2732, 0x285C, 0x29CA, 0x2B75, 0x2D6D, 0x2FB8, 0x321F, 0x34BC, 0x371D, 0x3879, 0x3837, 0x367F, 0x33AD,
    0x3097, 0x2D58, 0x2952, 0x23D4, 0x1C48, 0x12FF, 0x08E8, 0xFF58, 0xF733, 0xF111, 0xED24, 0xEAE2, 0xE8F1, 0xE617, 0xE24B, 0xDE27,
    0xDA72, 0xD7AE, 0xD5AE, 0xD473, 0xD4A9, 0xD68F, 0xD999, 0xDC8A, 0xDE00, 0xDD6F, 0xDB9B, 0xD9FE, 0xDA3B, 0xDCE9, 0xE179, 0xE667,
    0xE9F1, 0xEB89, 0xEBEA, 0xEC8A, 0xEE73, 0xF0FD, 0xF2F5, 0xF3C2, 0xF3C0, 0xF3BC, 0xF41A, 0xF497, 0xF484, 0xF441, 0xF4EC, 0xF7E1,
    0xFDD0, 0x060F, 0x0ED6, 0x1671, 0x1C4F, 0x2043, 0x22B6, 0x2483, 0x2621, 0x27B4, 0x2921, 0x2ABA, 0x2C82, 0x2EFC, 0x3216, 0x3531,
    0x3751, 0x37D9, 0x36D0, 0x34F5, 0x32FC, 0x30E2, 0x2DC9, 0x2919, 0x2299, 0x1A3C, 0x1080, 0x0638, 0xFCE5, 0xF5A0, 0xF0BC, 0xED42,
    0xEA21, 0xE6CB, 0xE30C, 0xDF42, 0xDB94, 0xD7FF, 0xD4CF, 0xD2A5, 0xD241, 0xD3C9, 0xD6B3, 0xD9B7, 0xDB59, 0xDB20, 0xD962, 0xD77B,
    0xD74B, 0xD9B4, 0xDDD1, 0xE22B, 0xE548, 0xE6B4, 0xE795, 0xE95F, 0xEC27, 0xEEB0, 0xF06A, 0xF135, 0xF1C2, 0xF290, 0xF389, 0xF3DD,
    0xF306, 0xF1BF, 0xF170, 0xF353, 0xF81C, 0xFF3B, 0x075A, 0x0F1B, 0x1586, 0x1A59, 0x1DE6, 0x20BC, 0x2315, 0x24FE, 0x2687, 0x27D0,
    0x296F, 0x2BFA, 0x2F4A, 0x32A7, 0x351A, 0x3638, 0x3657, 0x35C6, 0x34D5, 0x3378, 0x317D, 0x2E66, 0x2968, 0x2246, 0x1936, 0x0EF5,
    0x0531, 0xFD38, 0xF735, 0xF27F, 0xEE6F, 0xEAA6, 0xE6E3, 0xE340, 0xDF75, 0xDB2D, 0xD6E6, 0xD3D8, 0xD266, 0xD328, 0xD5A3, 0xD897,
    0xDA7F, 0xDA78, 0xD8CB, 0xD6DF, 0xD695, 0xD87E, 0xDBF0, 0xDF64, 0xE1E5, 0xE38A, 0xE542, 0xE7C2, 0xEA6E, 0xEC8D, 0xEDE9, 0xEED7,
    0xF011, 0xF198, 0xF2D8, 0xF32B, 0xF248, 0xF040, 0xEE6E, 0xEF0C, 0xF2BC, 0xF983, 0x033A, 0x0BE6, 0x0FE2, 0x136A, 0x183C, 0x1C1B,
    0x1FA2, 0x223B, 0x23C5, 0x2507, 0x269C, 0x294C, 0x2CA3, 0x301B, 0x32ED, 0x3466, 0x34CF, 0x34C0, 0x3478, 0x33C9, 0x32FF, 0x3134,
    0x2DC1, 0x27D5, 0x1F85, 0x15C1, 0x0C2B, 0x03C3, 0xFCA6, 0xF6C2, 0xF1CF, 0xEDC4, 0xEA5B, 0xE6C6, 0xE2A7, 0xDDF9, 0xD91C, 0xD4FB,
    0xD27D, 0xD26D, 0xD46A, 0xD73B, 0xD921, 0xD90B, 0xD766, 0xD5B8, 0xD555, 0xD6CC, 0xD952, 0xDBC4, 0xDDC1, 0xDFBF, 0xE24E, 0xE540,
    0xE80E, 0xEA24, 0xEB7E, 0xECC4, 0xEE5A, 0xF062, 0xF24D, 0xF354, 0xF2B5, 0xF0D9, 0xEF0F, 0xEEBE, 0xF07A, 0xF48A, 0xFAD3, 0x0209,
    0x08E5, 0x0F20, 0x149E, 0x195D, 0x1D51, 0x2005, 0x21B4, 0x231B, 0x24F7, 0x278C, 0x2A9F, 0x2D97, 0x306B, 0x32E1, 0x3446, 0x34BC,
    0x34BA, 0x350D, 0x3553, 0x34C6, 0x32A9, 0x2E55, 0x27D7, 0x1FD0, 0x173D, 0x0EE4, 0x0766, 0x00C8, 0xFAA5, 0xF51D, 0xF069, 0xEBE3,
    0xE711, 0xE18A, 0xDB68, 0xD58F, 0xD19E, 0xD090, 0xD1F3, 0xD477, 0xD6AE, 0xD7A8, 0xD766, 0xD6BC, 0xD6ED, 0xD898, 0xDB2C, 0xDD7B,
    0xDEDE, 0xE073, 0xE2A6, 0xE558, 0xE7F3, 0xE9AE, 0xEB1C, 0xEC7B, 0xEDD0, 0xEF3A, 0xF03D, 0xF046, 0xEF89, 0xEE3B, 0xEC92, 0xEB83,
    0xEC39, 0xEF45, 0xF42A, 0xFA68, 0x0159, 0x0888, 0x0FB0, 0x161F, 0x1AFF, 0x1E8A, 0x20FF, 0x22E9, 0x24E7, 0x2731, 0x29C1, 0x2CC5,
    0x2FD2, 0x326D, 0x3428, 0x350C, 0x35BA, 0x36A7, 0x37B0, 0x3811, 0x36BE, 0x3362, 0x2E1C, 0x26F5, 0x1EAB, 0x15DC, 0x0D42, 0x0554,
    0xFE7B, 0xF917, 0xF4DC, 0xF138, 0xED41, 0xE832, 0xE1F7, 0xDBC1, 0xD741, 0xD5AC, 0xD63D, 0xD82F, 0xD994, 0xD947, 0xD81B, 0xD70C,
    0xD6DA, 0xD750, 0xD81F, 0xD93C, 0xDAA1, 0xDC7F, 0xDF12, 0xE1C7, 0xE42F, 0xE614, 0xE7B0, 0xE95B, 0xEB8A, 0xEE79, 0xF194, 0xF3CB,
    0xF40F, 0xF298, 0xF047, 0xEE4D, 0xEE1E, 0xEFCB, 0xF2B9, 0xF71C, 0xFCC0, 0x0338, 0x09D8, 0x0FFA, 0x14E9, 0x18B3, 0x1BAA, 0x1DF0,
    0x1FEE, 0x21ED, 0x24AF, 0x27B9, 0x2B88, 0x2EFF, 0x30C3, 0x32A2, 0x3451, 0x35E5, 0x37B2, 0x38C9, 0x38B5, 0x36F6, 0x3373, 0x2E20,
    0x2708, 0x1EE2, 0x168A, 0x0E3F, 0x06A9, 0x00D5, 0xFCAD, 0xF964, 0xF5D1, 0xF08A, 0xE995, 0xE252, 0xDCD0, 0xDA4F, 0xDA1B, 0xDAAD,
    0xDAEF, 0xDA4D, 0xD94D, 0xD878, 0xD804, 0xD7E6, 0xD82C, 0xD8BA, 0xDA0A, 0xDBBD, 0xDDF4, 0xE07B, 0xE2DE, 0xE4E5, 0xE675, 0xE809,
    0xEA66, 0xEDB1, 0xF149, 0xF405, 0xF4CC, 0xF3C3, 0xF1C0, 0xEFE6, 0xEEA8, 0xEEC5, 0xF046, 0xF396, 0xF8A4, 0xFEF7, 0x05B0, 0x0C1C,
    0x11D7, 0x1686, 0x1A0F, 0x1CCB, 0x1F02, 0x2168, 0x247B, 0x27E8, 0x2B09, 0x2D91, 0x2F9B, 0x3163, 0x333C, 0x3588, 0x37C6, 0x39B3,
    0x3ABF, 0x3A5B, 0x3835, 0x3475, 0x2F01, 0x2815, 0x1FFC, 0x1712, 0x0E73, 0x0767, 0x02B1, 0xFF44, 0xFB82, 0xF608, 0xEEEE, 0xE7A4,
    0xE1DE, 0xDE62, 0xDCCE, 0xDC41, 0xDBEF, 0xDB53, 0xDAA5, 0xDA07, 0xD98A, 0xD92F, 0xD904, 0xD912, 0xD98B, 0xDACF, 0xDCF6, 0xDF8D,
    0xE1ED, 0xE3A3, 0xE4DD, 0xE667, 0xE8E7, 0xEC78, 0xF058, 0xF387, 0xF521, 0xF54A, 0xF445, 0xF276, 0xF0DE, 0xEFE2, 0xF030, 0xF219,
    0xF5F3, 0xFB2C, 0x0142, 0x07CC, 0x0E16, 0x135C, 0x175A, 0x1A3F, 0x1C94, 0x1F3B, 0x2234, 0x2552, 0x2819, 0x2A7F, 0x2C40, 0x2DC7,
    0x2F92, 0x31BE, 0x3461, 0x36F6, 0x38CC, 0x394C, 0x387B, 0x365B, 0x32BC, 0x2D47, 0x25E8, 0x1CFF, 0x1435, 0x0D35, 0x0852, 0x04B9,
    0x00B5, 0xFB0C, 0xF3F5, 0xEC8B, 0xE630, 0xE1AD, 0xDEFC, 0xDD95, 0xDCA1, 0xDBE7, 0xDB44, 0xDAC1, 0xDA5B, 0xD9FD, 0xD971, 0xD8F5,
    0xD921, 0xDA31, 0xDC4D, 0xDECA, 0xE0E7, 0xE25F, 0xE376, 0xE4E7, 0xE777, 0xEB15, 0xEF1A, 0xF2A0, 0xF501, 0xF62C, 0xF5DF, 0xF464,
    0xF284, 0xF0BD, 0xEFEC, 0xF084, 0xF2A4, 0xF65F, 0xFB97, 0x01BC, 0x07EE, 0x0D70, 0x11C9, 0x1507, 0x17D4, 0x1ABF, 0x1DC4, 0x20C7,
    0x23D0, 0x264B, 0x281E, 0x29C0, 0x2B83, 0x2DC0, 0x309C, 0x3370, 0x3597, 0x36E4, 0x3752, 0x36C7, 0x34C7, 0x30AD, 0x29E5, 0x2158,
    0x18C5, 0x119D, 0x0C63, 0x0882, 0x047D, 0xFF0E, 0xF82C, 0xF0CE, 0xEA1E, 0xE4DC, 0xE127, 0xDEB4, 0xDCF1, 0xDBCA, 0xDAE6, 0xDA43,
    0xD9CE, 0xD90B, 0xD7F9, 0xD6ED, 0xD69A, 0xD781, 0xD966, 0xDB90, 0xDD4F, 0xDE93, 0xDF98, 0xE105, 0xE37C, 0xE6CF, 0xEA94, 0xEE65,
    0xF193, 0xF3C0, 0xF469, 0xF3A5, 0xF1FC, 0xEFFF, 0xEE7E, 0xEDC4, 0xEE74, 0xF11B, 0xF594, 0xFB2F, 0x0112, 0x068A, 0x0B1B, 0x0EB8,
    0x11C5, 0x14E7, 0x1828, 0x1BA2, 0x1EE4, 0x2174, 0x233E, 0x249D, 0x262A, 0x2862, 0x2B1B, 0x2DD0, 0x3033, 0x3248, 0x3420, 0x3599,
    0x3593, 0x32FF, 0x2DAD, 0x2617, 0x1DEF, 0x16B9, 0x113C, 0x0CDB, 0x0873, 0x0332, 0xFCA9, 0xF565, 0xEE92, 0xE88F, 0xE394, 0xDFA3,
    0xDCBA, 0xDAD1, 0xD9A8, 0xD920, 0xD882, 0xD766, 0xD5DA, 0xD479, 0xD3D1, 0xD480, 0xD5F6, 0xD7B7, 0xD935, 0xDA12, 0xDAE1, 0xDC26,
    0xDE1A, 0xE0D3, 0xE46F, 0xE854, 0xEBC9, 0xEE8F, 0xF049, 0xF0E5, 0xF059, 0xEED4, 0xED00, 0xEB54, 0xEB2A, 0xECBB, 0xEFFB, 0xF4BF,
    0xFA33, 0xFFC2, 0x04C6, 0x08BA, 0x0C08, 0x0F6B, 0x1328, 0x1701, 0x1A67, 0x1D00, 0x1ED2, 0x2039, 0x2218, 0x24AC, 0x275C, 0x29C9,
    0x2C03, 0x2E49, 0x3105, 0x339E, 0x34AE, 0x3339, 0x2F00, 0x289B, 0x213F, 0x1A74, 0x14E7, 0x104C, 0x0B9E, 0x0633, 0xFFBB, 0xF8D9,
    0xF212, 0xEB8B, 0xE5C3, 0xE0B9, 0xDCB5, 0xD9FD, 0xD889, 0xD7DC, 0xD724, 0xD601, 0xD445, 0xD294, 0xD1B3, 0xD1DC, 0xD2DD, 0xD443,
    0xD58F, 0xD666, 0xD707, 0xD7D2, 0xD91A, 0xDB5D, 0xDEA5, 0xE26C, 0xE65E, 0xE9EE, 0xECAD, 0xEE4B, 0xEEE3, 0xEE12, 0xEC36, 0xEA4E,
    0xE933, 0xE962, 0xEB5C, 0xEF15, 0xF40D, 0xF978, 0xFE82, 0x02BA, 0x065B, 0x0A5C, 0x0E7F, 0x12C9, 0x1699, 0x1957, 0x1B66, 0x1D29,
    0x1F41, 0x2164, 0x237A, 0x2536, 0x273E, 0x2A06, 0x2D7C, 0x3192, 0x341F, 0x344D, 0x3170, 0x2C22, 0x25BA, 0x1F73, 0x1A24, 0x1560,
    0x1095, 0x0B07, 0x0500, 0xFE5A, 0xF753, 0xF0B1, 0xEA84, 0xE511, 0xE01F, 0xDC9A, 0xDAA2, 0xD97D, 0xD87B, 0xD6D8, 0xD4FD, 0xD309,
    0xD1BF, 0xD1A3, 0xD250, 0xD379, 0xD499, 0xD56D, 0xD5B4, 0xD611, 0xD6D5, 0xD8D9, 0xDBC2, 0xDF26, 0xE32D, 0xE6F6, 0xEA90, 0xED33,
    0xEE6D, 0xEE4D, 0xED0A, 0xEB18, 0xE903, 0xE7D8, 0xE837, 0xEAD5, 0xEF0D, 0xF3A2, 0xF803, 0xFC06, 0x0083, 0x051E, 0x098D, 0x0DDC,
    0x11AB, 0x148F, 0x170C, 0x198A, 0x1BA4, 0x1DAC, 0x1F34, 0x2096, 0x2289, 0x257D, 0x299F, 0x2E63, 0x3244, 0x33BD, 0x32A4, 0x2F3A,
    0x2A26, 0x24C8, 0x1FBD, 0x1B0B, 0x1609, 0x10A6, 0x0AC7, 0x04A2, 0xFE46, 0xF763, 0xF03C, 0xE90E, 0xE32E, 0xDED3, 0xDC17, 0xDA98,
    0xD92F, 0xD773, 0xD57C, 0xD38D, 0xD225, 0xD1CE, 0xD25E, 0xD359, 0xD471, 0xD528, 0xD573, 0xD5C3, 0xD699, 0xD7F1, 0xDA16, 0xDD2D,
    0xE0C5, 0xE4D5, 0xE8B2, 0xEC2A, 0xEE62, 0xEF1B, 0xEE47, 0xEC3F, 0xEA12, 0xE86A, 0xE828, 0xE9E2, 0xED50, 0xF14D, 0xF526, 0xF903,
    0xFCE4, 0x017A, 0x062F, 0x0A8C, 0x0E3D, 0x1165, 0x143F, 0x16EB, 0x19CE, 0x1BF9, 0x1D66, 0x1E55, 0x1F88, 0x2213, 0x263F, 0x2BD6,
    0x30A0, 0x334B, 0x3380, 0x3180, 0x2DD5, 0x29B7, 0x257B, 0x20C3, 0x1BB3, 0x1689, 0x1148, 0x0BAC, 0x0597, 0xFED1, 0xF777, 0xF020,
    0xE98B, 0xE496, 0xE127, 0xDEBB, 0xDCDD, 0xDAAF, 0xD864, 0xD616, 0xD456, 0xD375, 0xD376, 0xD434, 0xD525, 0xD5CE, 0xD5FF, 0xD652,
    0xD66F, 0xD71B, 0xD8BA, 0xDB31, 0xDEA5, 0xE2AD, 0xE6EA, 0xEAD5, 0xEE1E, 0xF010, 0xF00D, 0xEE7A, 0xEBE7, 0xE9B2, 0xE8C8, 0xE9B0,
    0xEBF6, 0xEEC8, 0xF1DB, 0xF532, 0xF939, 0xFDE5, 0x02E8, 0x0727, 0x0AD9, 0x0E2E, 0x1181, 0x14FF, 0x184E, 0x1AEA, 0x1C41, 0x1CEF,
    0x1DC6, 0x200C, 0x2437, 0x2971, 0x2E6A, 0x31CF, 0x3347, 0x32A8, 0x30B1, 0x2DB4, 0x29D6, 0x25A1, 0x210C, 0x1C3A, 0x1765, 0x12B3,
    0x0D83, 0x06FF, 0xFFA4, 0xF7E4, 0xF0BA, 0xEAF0, 0xE6C7, 0xE3D1, 0xE170, 0xDF26, 0xDC7A, 0xD9FD, 0xD7E5, 0xD69F, 0xD63C, 0xD696,
    0xD72E, 0xD79B, 0xD7CC, 0xD78B, 0xD781, 0xD7F8, 0xD912, 0xDAEF, 0xDDAF, 0xE170, 0xE5DA, 0xEA7F, 0xEEB1, 0xF1A1, 0xF274, 0xF16F,
    0xEF71, 0xED91, 0xECCA, 0xED15, 0xEE30, 0xEFB3, 0xF139, 0xF38C, 0xF761, 0xFCAC, 0x027E, 0x07CB, 0x0B98, 0x0E08, 0x1031, 0x1357,
    0x16F7, 0x1955, 0x1A73, 0x1A85, 0x1AE4, 0x1CB7, 0x2076, 0x2592, 0x2AC0, 0x2EE7, 0x3137, 0x3239, 0x31D5, 0x300D, 0x2D37, 0x297A,
    0x257A, 0x215D, 0x1D7C, 0x194A, 0x1463, 0x0E7B, 0x0783, 0x0009, 0xF86A, 0xF222, 0xED27, 0xE92C, 0xE5FB, 0xE31F, 0xE065, 0xDD7C,
    0xDAE5, 0xD915, 0xD813, 0xD798, 0xD802, 0xD907, 0xD98E, 0xD92B, 0xD7FE, 0xD6D8, 0xD706, 0xD913, 0xDBB4, 0xDE8F, 0xE285, 0xE7EC,
    0xED81, 0xF196, 0xF312, 0xF2A9, 0xF176, 0xF09C, 0xEFC9, 0xEF3A, 0xEF5E, 0xEF72, 0xF053, 0xF310, 0xF6C7, 0xFA6C, 0xFE92, 0x02FA,
    0x05EC, 0x089F, 0x0D16, 0x1249, 0x1699, 0x18C6, 0x1935, 0x19D5, 0x1A7A, 0x1B7B, 0x1E8C, 0x22FD, 0x27AD, 0x2C1E, 0x30AA, 0x33D7,
    0x3485, 0x3352, 0x314B, 0x2E21, 0x2A26, 0x271E, 0x241C, 0x2064, 0x1B99, 0x15CD, 0x0FB1, 0x08DA, 0x016D, 0xF9DE, 0xF324, 0xEE5F,
    0xEAD5, 0xE7DC, 0xE484, 0xE0A6, 0xDD4C, 0xDAE8, 0xD942, 0xD88A, 0xD8AF, 0xD8CB, 0xD8E0, 0xD8BE, 0xD89C, 0xD8AB, 0xD8E2, 0xD982,
    0xDAD9, 0xDD7C, 0xE19B, 0xE6E9, 0xEC5C, 0xF0C0, 0xF33B, 0xF402, 0xF38C, 0xF27D, 0xF166, 0xF0CC, 0xF08B, 0xF08C, 0xF124, 0xF2C9,
    0xF629, 0xFA24, 0xFE4C, 0x01E6, 0x0554, 0x08E6, 0x0D1B, 0x11A2, 0x15DB, 0x18FC, 0x1AF4, 0x1BBA, 0x1C23, 0x1D3E, 0x1F9D, 0x230D,
    0x26EF, 0x2BB7, 0x2F45, 0x32FE, 0x353C, 0x3635, 0x33DE, 0x317F, 0x2F3A, 0x2A04, 0x2907, 0x281C, 0x2467, 0x1E27, 0x1709, 0x0F7D,
    0x072C, 0xFF6A, 0xF8CB, 0xF320, 0xEE22, 0xEA53, 0xE6B7, 0xE34A, 0xDFBE, 0xDD0F, 0xDB3C, 0xDA41, 0xD955, 0xD8FB, 0xD8C0, 0xD850,
    0xD88A, 0xD881, 0xD872, 0xD865, 0xD901, 0xDB08, 0xDEB3, 0xE3AD, 0xE8F8, 0xEE20, 0xF17F, 0xF39F, 0xF483, 0xF4E9, 0xF4BE, 0xF42B,
    0xF2F9, 0xF22D, 0xF20D, 0xF38E, 0xF679, 0xFA07, 0xFD96, 0x0086, 0x0415, 0x0727, 0x0BB6, 0x1022, 0x15A1, 0x1844, 0x1B09, 0x1CA7,
    0x1BD7, 0x1EB5, 0x1F75, 0x21B3, 0x279D, 0x2BC0, 0x2DE9, 0x2DC2, 0x2E44, 0x2F73, 0x30CE, 0x311C, 0x3010, 0x2E97, 0x2D12, 0x2C96,
    0x2A1D, 0x29D8, 0x2359, 0x2194, 0x1AFD, 0x0F0D, 0x0F94, 0x0A09, 0xFE85, 0xF280, 0xEA7D, 0xE4F0, 0xE0BE, 0xDE5A, 0xDD13, 0xDAC4,
    0xD9AE, 0xD983, 0xD914, 0xD918, 0xD8BB, 0xD8B7, 0xD8FD, 0xD8A5, 0xD813, 0xD9F0, 0xDC4A, 0xE0A9, 0xE65C, 0xEB91, 0xEFA8, 0xF2F1,
    0xF424, 0xF5A1, 0xF51D, 0xF499, 0xF2D0, 0xF106, 0xF0F6, 0xF0BD, 0xF375, 0xF5D1, 0xF86D, 0xFC34, 0xFF3D, 0x0206, 0x07C5, 0x0D2B,
    0x1256, 0x1572, 0x1A62, 0x1CB8, 0x1A2A, 0x1C79, 0x1FF4, 0x2243, 0x22D4, 0x247F, 0x24AC, 0x2598, 0x2722, 0x2718, 0x2A73, 0x2BCA,
    0x2BC4, 0x2CC7, 0x2D1F, 0x2AE4, 0x2A2F, 0x2BA4, 0x2C67, 0x2969, 0x24AA, 0x2075, 0x1C26, 0x194C, 0x1257, 0x0C4F, 0x00C0, 0xFAC1,
    0xF272, 0xE845, 0xEB22, 0xE8B4, 0xE1EF, 0xDA2E, 0xD688, 0xD590, 0xD637, 0xD690, 0xD7C0, 0xD6E9, 0xD60A, 0xD759, 0xD8E3, 0xDD21,
    0xE239, 0xE6DF, 0xEC81, 0xF0BF, 0xF233, 0xF584, 0xF545, 0xF4AF, 0xF327, 0xF1AE, 0xF079, 0xEF58, 0xF11C, 0xF35C, 0xF43C, 0xF5D8,
    0xFAF9, 0xFD07, 0xFF9B, 0x06F9, 0x0CDE, 0x11A4, 0x165B, 0x188E, 0x1841, 0x17E2, 0x18ED, 0x19DF, 0x1B68, 0x1DA6, 0x1F2C, 0x1F83,
    0x20C3, 0x2276, 0x2378, 0x2570, 0x273F, 0x29A3, 0x290D, 0x28D4, 0x2A4E, 0x2A59, 0x2C08, 0x2BB8, 0x28D4, 0x279D, 0x2693, 0x22DF,
    0x1F92, 0x1C7F, 0x17C2, 0x0F4D, 0x0620, 0xFFA9, 0xFAB6, 0xF61F, 0xF104, 0xEA17, 0xE39B, 0xDF24, 0xDB0D, 0xD92D, 0xD744, 0xD58A,
    0xD3C5, 0xD375, 0xD33C, 0xD476, 0xD693, 0xDA58, 0xDDE4, 0xE15E, 0xE816, 0xE898, 0xECE4, 0xF238, 0xF0F6, 0xEF6B, 0xECF1, 0xEB0B,
    0xEB17, 0xEC5E, 0xEEF7, 0xF018, 0xF21E, 0xF72B, 0xFB3C, 0xFE63, 0x01E2, 0x05F5, 0x09E7, 0x0E5F, 0x112D, 0x12CA, 0x1324, 0x134B,
    0x14F0, 0x1585, 0x160C, 0x179D, 0x1881, 0x19A2, 0x1B39, 0x1C56, 0x1EBF, 0x218F, 0x22FE, 0x23B6, 0x259E, 0x2806, 0x293D, 0x294C,
    0x29C7, 0x29A0, 0x2802, 0x268A, 0x2596, 0x24A1, 0x2243, 0x1E32, 0x1863, 0x12B9, 0x0D12, 0x0838, 0x039D, 0xFE79, 0xF8F3, 0xF2A9,
    0xEE33, 0xE95B, 0xE518, 0xE2B6, 0xDF54, 0xDCB0, 0xDBB6, 0xDA61, 0xD98B, 0xDA62, 0xDC74, 0xDE5F, 0xDFFF, 0xE2FE, 0xE66D, 0xEA10,
    0xED92, 0xEF77, 0xEF13, 0xEE1D, 0xEDB7, 0xED47, 0xECD5, 0xEC86, 0xED83, 0xEFB1, 0xF250, 0xF51B, 0xF790, 0xFA2E, 0xFD92, 0x00D8,
    0x0392, 0x061E, 0x07FB, 0x09A4, 0x0B33, 0x0C08, 0x0CA2, 0x0DAD, 0x0F06, 0x0FE5, 0x108D, 0x1216, 0x142A, 0x166D, 0x1851, 0x1A1F,
    0x1C0E, 0x1E01, 0x1FAF, 0x214F, 0x22DE, 0x2351, 0x22F8, 0x21EC, 0x20A1, 0x1F2A, 0x1DE0, 0x1CE8, 0x1AE3, 0x1854, 0x1747, 0x1688,
    0x1313, 0x0EA8, 0x0A38, 0x04DA, 0xFF4E, 0xF9EE, 0xF475, 0xEF41, 0xEAB0, 0xE6E9, 0xE381, 0xE088, 0xDEC0, 0xDD9C, 0xDD0B, 0xDCEB,
    0xDD59, 0xDE59, 0xE01C, 0xE337, 0xE6E6, 0xE9F2, 0xEC9F, 0xEE7C, 0xEEF2, 0xEEAF, 0xEE2C, 0xED73, 0xECF6, 0xED5D, 0xEE48, 0xEFB2,
    0xF14C, 0xF2ED, 0xF4D1, 0xF6E8, 0xF932, 0xFB5F, 0xFDAC, 0x0004, 0x0195, 0x02B7, 0x03E2, 0x052B, 0x068B, 0x07A4, 0x08AC, 0x09D8,
    0x0B49, 0x0D0E, 0x0EEE, 0x114D, 0x13A3, 0x1592, 0x176F, 0x1904, 0x1A78, 0x1C3A, 0x1DC0, 0x1EA4, 0x1F50, 0x1FF6, 0x203A, 0x203C,
    0x201D, 0x1F2C, 0x1D20, 0x1A6F, 0x17A6, 0x149D, 0x1100, 0x0D2F, 0x0926, 0x04D0, 0x0022, 0xFADF, 0xF5D0, 0xF105, 0xECCA, 0xE97B,
    0xE685, 0xE40E, 0xE241, 0xE0F0, 0xE057, 0xE028, 0xE092, 0xE1A3, 0xE3C1, 0xE692, 0xE964, 0xEBF7, 0xEE0A, 0xEFC1, 0xF0C0, 0xF0F5,
    0xF0B3, 0xF04F, 0xF07A, 0xF14B, 0xF235, 0xF312, 0xF408, 0xF509, 0xF626, 0xF790, 0xF971, 0xFB78, 0xFD34, 0xFF1E, 0x00DE, 0x0268,
    0x036D, 0x0440, 0x054B, 0x05F4, 0x066D, 0x0742, 0x0895, 0x0A45, 0x0C3B, 0x0E14, 0x0FA9, 0x1103, 0x1276, 0x1437, 0x15E6, 0x1761,
    0x18A4, 0x1974, 0x1A4F, 0x1B0F, 0x1BAA, 0x1C14, 0x1C07, 0x1B92, 0x1A74, 0x18BB, 0x1693, 0x1402, 0x1122, 0x0DD1, 0x09E0, 0x0559,
    0x0028, 0xFAE3, 0xF61E, 0xF234, 0xEE7B, 0xEB66, 0xE8EB, 0xE6BE, 0xE4D1, 0xE36A, 0xE2E8, 0xE2E0, 0xE373, 0xE487, 0xE614, 0xE7F3,
    0xEA2E, 0xEC4B, 0xEE19, 0xEF3C, 0xEFF5, 0xF056, 0xF0CC, 0xF199, 0xF241, 0xF31F, 0xF3DB, 0xF45D, 0xF4BA, 0xF562, 0xF624, 0xF6DF,
    0xF7FC, 0xF94B, 0xFA73, 0xFB93, 0xFCD5, 0xFE18, 0xFF63, 0x0099, 0x01B3, 0x027C, 0x0365, 0x04B9, 0x0652, 0x07D5, 0x0907, 0x0A14,
    0x0B30, 0x0C54, 0x0D8A, 0x0F3F, 0x10EF, 0x129E, 0x1412, 0x1542, 0x165E, 0x1762, 0x184A, 0x18D0, 0x1930, 0x1937, 0x18D9, 0x182F,
    0x1760, 0x160F, 0x13F2, 0x10FC, 0x0D40, 0x08E0, 0x047C, 0x0065, 0xFCA0, 0xF8FD, 0xF578, 0xF220, 0xEEFF, 0xECA1, 0xEADD, 0xE98F,
    0xE8EB, 0xE8B1, 0xE8D1, 0xE993, 0xEA9C, 0xEBFE, 0xED6B, 0xEE87, 0xEF8C, 0xF07C, 0xF1B8, 0xF329, 0xF4BD, 0xF531, 0xF4A7, 0xF47B,
    0xF4B6, 0xF4B1, 0xF4DF, 0xF537, 0xF5C6, 0xF69C, 0xF760, 0xF7E5, 0xF83B, 0xF831, 0xF855, 0xF906, 0xFAED, 0xFCDA, 0xFE12, 0xFF49,
    0x0085, 0x01CE, 0x02DA, 0x03CD, 0x045D, 0x04AD, 0x052E, 0x0620, 0x0744, 0x08E5, 0x0A95, 0x0C77, 0x0E27, 0x1021, 0x1155, 0x11F8,
    0x125C, 0x1264, 0x12BE, 0x12B0, 0x1352, 0x1389, 0x1363, 0x128E, 0x113E, 0x0F3C, 0x0CA1, 0x0A5C, 0x0841, 0x05A1, 0x0297, 0x0017,
    0xFDC5, 0xFBA5, 0xFA2F, 0xF9EB, 0xFA67, 0xF437, 0xF9E7, 0x046E, 0x02A3, 0x0167, 0x0338, 0x03C6, 0xFF58, 0xFEC3, 0xF7FB, 0xF1CC,
    0xEC01, 0xEBC8, 0xE7C5, 0xD793, 0xD34D, 0xD653, 0xD320, 0xC23B, 0xBF6D, 0xC43C, 0xC3F3, 0xC94E, 0xC9BE, 0xC93E, 0xD118, 0xD834,
    0xD726, 0xD8D9, 0xDBD0, 0xDCE8, 0xDE97, 0xE392, 0xE76D, 0xE328, 0xE13D, 0xE02A, 0xE358, 0xE19F, 0xE7FA, 0xEA3F, 0xE592, 0xF990,
    0x00C6, 0xFDD2, 0xFB56, 0xFD3D, 0xFED5, 0xFE91, 0x0320, 0x077B, 0x0F9C, 0x142B, 0x1C48, 0x1FF7, 0x23AA, 0x244A, 0x2A47, 0x3BAD,
    0x36B7, 0x2C57, 0x384A, 0x488A, 0x4887, 0x4A56, 0x437D, 0x3B64, 0x3CE3, 0x37E3, 0x2E29, 0x1EF5, 0x1895, 0x151B, 0x0FCF, 0xFEC7,
    0xF5F4, 0xF648, 0xEB6A, 0xE45A, 0xDD38, 0xD87C, 0xD9A5, 0xDD71, 0xDC85, 0xDB48, 0xDD99, 0xE131, 0xDEE7, 0xDDD3, 0xE2A2, 0xDE3F,
    0xDF3A, 0xE1D9, 0xE451, 0xDDF8, 0xD817, 0xDA36, 0xD411, 0xD83D, 0xDC8C, 0xDA1D, 0xDA48, 0xE612, 0xF218, 0xF382, 0xF19A, 0xEF44,
    0xF07F, 0xEE46, 0xF032, 0xF1D1, 0xF69A, 0xFBFC, 0xFDF5, 0x0A5A, 0x0D86, 0x06C6, 0x1204, 0x2923, 0x27BF, 0x2384, 0x2A12, 0x33EB,
    0x4295, 0x4958, 0x4866, 0x4354, 0x43D3, 0x41A7, 0x3CE5, 0x2E77, 0x224A, 0x24B0, 0x1C17, 0x0DAC, 0x0419, 0xFD67, 0xF758, 0xF20D,
    0xE98C, 0xE387, 0xE2F1, 0xE783, 0xE90B, 0xE5DF, 0xEBAE, 0xEDB8, 0xECC7, 0xE971, 0xE9C7, 0xE5C4, 0xE0F0, 0xEA03, 0xEBEF, 0xEB1F,
    0xEBA0, 0xE867, 0xE280, 0xE3E8, 0xE798, 0xE30D, 0xE029, 0xE492, 0xF04E, 0xF4DD, 0xF53D, 0xF2B5, 0xF044, 0xF1FF, 0xF017, 0xF29F,
    0xF7D4, 0xF4EA, 0xF693, 0x08ED, 0x08B8, 0x0080, 0x0A58, 0x19F6, 0x2253, 0x214A, 0x1F9D, 0x22D3, 0x3092, 0x3B18, 0x40D5, 0x4061,
    0x3D9F, 0x430C, 0x417A, 0x35F6, 0x2E9B, 0x2C6A, 0x263A, 0x1E10, 0x1302, 0x0B01, 0x05D9, 0x00DC, 0xFA3D, 0xED9F, 0xE9EE, 0xEA29,
    0xEA7B, 0xE946, 0xED70, 0xF285, 0xEEF0, 0xF22C, 0xF295, 0xEB8D, 0xE836, 0xEB95, 0xEC61, 0xEF05, 0xF3F9, 0xF145, 0xEDC0, 0xED88,
    0xF330, 0xF0C6, 0xEBC6, 0xEDF8, 0xF4A2, 0xFF44, 0x0383, 0x02AF, 0x0543, 0x04A4, 0xFCD7, 0x0282, 0x02F2, 0xF811, 0xFBF6, 0x0B18,
    0x0FB8, 0x0C72, 0x118F, 0x1D51, 0x2CB4, 0x31D2, 0x302F, 0x30F3, 0x33F5, 0x3D97, 0x4579, 0x402B, 0x3A4B, 0x3F49, 0x3F93, 0x393B,
    0x321D, 0x2E46, 0x2B42, 0x2558, 0x1E49, 0x146A, 0x102F, 0x0DF5, 0x08A5, 0xFE71, 0xF6F5, 0xF5DF, 0xF165, 0xF0B5, 0xF56E, 0xF6BC,
    0xF59B, 0xFA20, 0xF9C4, 0xF3CC, 0xF1EF, 0xEF62, 0xEEB6, 0xEFEA, 0xF675, 0xF719, 0xF175, 0xF15F, 0xF3E9, 0xF3A2, 0xEF87, 0xEA57,
    0xED4B, 0xF88A, 0xFA62, 0xFFEC, 0x07AE, 0x0289, 0xFFA6, 0x07A5, 0x0706, 0xFC99, 0xFCD9, 0x054D, 0x0CF9, 0x0C34, 0x0838, 0x0D54,
    0x1766, 0x1EB6, 0x2218, 0x1EA2, 0x1DCA, 0x2AB2, 0x34D5, 0x3863, 0x3B8C, 0x420F, 0x4695, 0x42C4, 0x3D26, 0x3662, 0x3354, 0x2FF8,
    0x2916, 0x1F22, 0x16C8, 0x153A, 0x0F2B, 0x0523, 0xFEC8, 0xF97D, 0xF1FF, 0xF1DC, 0xF4D9, 0xF454, 0xF763, 0xFB3C, 0xFD26, 0xFAB8,
    0xF9C1, 0xF7FB, 0xF389, 0xF3EE, 0xF96D, 0xF9E4, 0xF61B, 0xF35A, 0xF259, 0xF6B1, 0xF0F7, 0xE877, 0xEBDE, 0xEF50, 0xF02C, 0xFABE,
    0x02B4, 0xFCC5, 0xFC68, 0x0376, 0x052C, 0xFEAD, 0xF8A7, 0xFD0B, 0x0723, 0x08C3, 0x06FB, 0x0849, 0x0C2F, 0x1922, 0x20CB, 0x1E98,
    0x1CC6, 0x23D2, 0x2DE8, 0x3172, 0x357B, 0x3A9A, 0x403F, 0x413A, 0x3CDB, 0x3675, 0x307E, 0x2ECF, 0x2975, 0x1DD8, 0x1493, 0x10E5,
    0x097A, 0x0243, 0xFDDA, 0xF517, 0xEDB5, 0xEB01, 0xEABB, 0xE8C6, 0xE9E1, 0xEDEF, 0xEF2A, 0xEE95, 0xF112, 0xEFC0, 0xEAAD, 0xEAF1,
    0xECBA, 0xF1F7, 0xF15A, 0xEAE9, 0xED3D, 0xF2CF, 0xED96, 0xE856, 0xE9DC, 0xE4D4, 0xE425, 0xEE84, 0xF587, 0xF414, 0xF2A6, 0xF787,
    0xFE9F, 0xFB64, 0xF357, 0xF450, 0xF8D9, 0xFEFB, 0x008D, 0xFCF7, 0xFD88, 0x0857, 0x1480, 0x15E2, 0x1523, 0x1934, 0x219F, 0x2820,
    0x2C87, 0x32F9, 0x3A58, 0x40E8, 0x4204, 0x3CE4, 0x36F4, 0x36A3, 0x3106, 0x25D8, 0x1DA2, 0x14DF, 0x0BEA, 0x04FE, 0xFF70, 0xF680,
    0xED66, 0xE855, 0xE4F3, 0xE052, 0xE0CF, 0xE3DF, 0xE3C9, 0xE6BD, 0xE955, 0xE9E1, 0xE7FB, 0xE31E, 0xE2CE, 0xE979, 0xE8A4, 0xE2C8,
    0xE72D, 0xEA3D, 0xE79E, 0xE8A5, 0xE887, 0xE1E1, 0xDF14, 0xE4F5, 0xEE98, 0xF162, 0xEE5C, 0xF422, 0xFB2E, 0xFB20, 0xF5F6, 0xF09E,
    0xF014, 0xF5A7, 0xFAD7, 0xF691, 0xF316, 0xFA19, 0x0618, 0x0C5A, 0x0CCD, 0x0F02, 0x1499, 0x1AA1, 0x1F91, 0x24A5, 0x2AD1, 0x3638,
    0x3CBA, 0x395F, 0x3749, 0x36D9, 0x32FC, 0x2C1A, 0x2550, 0x1CA2, 0x1408, 0x0E40, 0x09F6, 0x00AD, 0xF705, 0xF086, 0xE78C, 0xE0D6,
    0xDE2C, 0xDCDB, 0xDCAF, 0xDD7D, 0xDE89, 0xE26E, 0xE172, 0xD925, 0xD99C, 0xDEF6, 0xDCD0, 0xDAFF, 0xDF13, 0xDFD7, 0xE076, 0xE3C4,
    0xE4EC, 0xE0C3, 0xD88A, 0xDAE8, 0xE42C, 0xE814, 0xE877, 0xEC3F, 0xF3E5, 0xF929, 0xF9BB, 0xF3D9, 0xEF51, 0xF414, 0xFB44, 0xFA93,
    0xF5A5, 0xF72F, 0x0027, 0x07AA, 0x09B6, 0x0BB4, 0x0DA4, 0x133A, 0x1940, 0x1AF7, 0x20DA, 0x2D4A, 0x3656, 0x3854, 0x3947, 0x38FE,
    0x36E4, 0x332F, 0x2F0A, 0x2678, 0x1BFB, 0x1704, 0x114C, 0x090E, 0x022E, 0xFA70, 0xF0F9, 0xE9FA, 0xE48D, 0xE26E, 0xE2C7, 0xDFC0,
    0xE089, 0xE6D7, 0xE521, 0xDCA5, 0xDBE1, 0xDC16, 0xD9B8, 0xD92B, 0xD95D, 0xD986, 0xD7A0, 0xDA28, 0xDEDF, 0xDBCB, 0xD3B4, 0xD1AE,
    0xD779, 0xDBE5, 0xDE46, 0xE0A4, 0xE54B, 0xED46, 0xF293, 0xEF03, 0xE8A5, 0xE9DD, 0xF10B, 0xF478, 0xF019, 0xEF31, 0xF46D, 0xFC2A,
    0x0391, 0x062D, 0x081A, 0x0F71, 0x1553, 0x15AC, 0x1953, 0x2277, 0x2C0D, 0x312B, 0x347E, 0x35F3, 0x33E1, 0x3392, 0x31FF, 0x2A96,
    0x2254, 0x1C31, 0x14DC, 0x0E79, 0x082F, 0x0076, 0xF98C, 0xF09F, 0xE802, 0xE5F1, 0xE3F1, 0xDD6F, 0xDF23, 0xE5AC, 0xE637, 0xE3A7,
    0xE222, 0xE28C, 0xE150, 0xE0D8, 0xE27E, 0xE16E, 0xDD68, 0xDE56, 0xE482, 0xE40D, 0xDCF1, 0xD725, 0xD6D6, 0xD9B4, 0xDC3B, 0xDBF8,
    0xDCF0, 0xE4A7, 0xED87, 0xEF18, 0xE911, 0xE75C, 0xECFD, 0xF135, 0xF0DB, 0xEE57, 0xED62, 0xF3B3, 0xFC11, 0xFE85, 0x0127, 0x0821,
    0x0ED7, 0x1000, 0x1214, 0x19B3, 0x2233, 0x2B16, 0x33B0, 0x370F, 0x3771, 0x39E9, 0x3925, 0x3413, 0x2D58, 0x2486, 0x1C97, 0x1587,
    0x0CF9, 0x06E2, 0x01FA, 0xF649, 0xED04, 0xEAA1, 0xE53C, 0xDEA2, 0xDDC5, 0xE245, 0xE543, 0xE525, 0xE502, 0xE507, 0xE2F3, 0xE252,
    0xE56B, 0xE4E9, 0xE091, 0xE04B, 0xE66A, 0xEA37, 0xE816, 0xE271, 0xDDD5, 0xDF12, 0xE196, 0xE131, 0xDEC6, 0xE253, 0xEC89, 0xF10F,
    0xED30, 0xE9A0, 0xEA06, 0xED87, 0xF01C, 0xEC5D, 0xE8BC, 0xEC1C, 0xF307, 0xF60F, 0xF8BA, 0x0033, 0x0758, 0x09FC, 0x0CA1, 0x10F7,
    0x1627, 0x206C, 0x2A89, 0x2FED, 0x3446, 0x37F0, 0x39A6, 0x399A, 0x35C8, 0x2F21, 0x2AAC, 0x22D7, 0x19CC, 0x1629, 0x0FFB, 0x0472,
    0xFB04, 0xF594, 0xEE2B, 0xE510, 0xE00E, 0xE0E9, 0xE291, 0xE37E, 0xE551, 0xE583, 0xE2C6, 0xE1EB, 0xE5BC, 0xE699, 0xE336, 0xE14C,
    0xE422, 0xEA27, 0xEC54, 0xE8F4, 0xE35A, 0xE1B6, 0xE54A, 0xE607, 0xE230, 0xE394, 0xEC32, 0xF3BE, 0xF5ED, 0xF306, 0xF066, 0xF2E7,
    0xF6BC, 0xF45A, 0xEE93, 0xEE44, 0xF26E, 0xF394, 0xF4D0, 0xFA9A, 0xFF61, 0x03DF, 0x07C7, 0x08A6, 0x0B7B, 0x13E6, 0x1DA3, 0x25D4,
    0x2C82, 0x3046, 0x3572, 0x3853, 0x358C, 0x335E, 0x2FDF, 0x26EE, 0x1EC9, 0x1B6A, 0x163D, 0x0CA2, 0x0394, 0xFE13, 0xF796, 0xEE08,
    0xE691, 0xE3D4, 0xE2D8, 0xE2EC, 0xE5E3, 0xE674, 0xE27C, 0xDFA6, 0xE149, 0xE319, 0xE0EB, 0xDD52, 0xDCB2, 0xE111, 0xE690, 0xE794,
    0xE217, 0xDEF3, 0xE211, 0xE2E3, 0xDFC3, 0xDDEF, 0xE222, 0xEB15, 0xF268, 0xF2AC, 0xEFB4, 0xF1B0, 0xF7CC, 0xF88D, 0xF45C, 0xF432,
    0xF5D8, 0xF65F, 0xF8A3, 0xFC10, 0xFF9C, 0x059C, 0x09BF, 0x09DF, 0x0B37, 0x0E4A, 0x1573, 0x1EE8, 0x24A4, 0x2A20, 0x317B, 0x352C,
    0x35D5, 0x379F, 0x366C, 0x2F7D, 0x27FC, 0x23D4, 0x1F41, 0x16D3, 0x0E25, 0x0814, 0x018A, 0xF7F4, 0xEF94, 0xE9E1, 0xE57E, 0xE477,
    0xE786, 0xE9C4, 0xE836, 0xE5D4, 0xE6D6, 0xEA0A, 0xEA4B, 0xE73D, 0xE272, 0xE276, 0xE8D2, 0xEBBE, 0xE7D2, 0xE38F, 0xE3A3, 0xE497,
    0xE293, 0xDE3C, 0xDCAB, 0xE278, 0xEC0A, 0xEFFC, 0xED8E, 0xEF1B, 0xF4BC, 0xF5CD, 0xF40B, 0xF3A0, 0xF2A4, 0xF322, 0xF51A, 0xF600,
    0xF9E6, 0x00DF, 0x06FD, 0x0B85, 0x0CAD, 0x0D82, 0x140D, 0x1C39, 0x2190, 0x288E, 0x2FF5, 0x33E2, 0x3616, 0x391D, 0x3981, 0x33F6,
    0x2C4A, 0x26EB, 0x2265, 0x1AA8, 0x126E, 0x0CBF, 0x062C, 0xFDA1, 0xF5BD, 0xEE35, 0xE719, 0xE2B1, 0xE370, 0xE6BC, 0xE6D0, 0xE4F9,
    0xE467, 0xE686, 0xEA2A, 0xE9B3, 0xE42E, 0xE1D3, 0xE6EE, 0xEC9C, 0xED67, 0xEB1E, 0xEA41, 0xEBB3, 0xEBBF, 0xE7B7, 0xE157, 0xE1CF,
    0xEA5A, 0xEF2F, 0xEE3F, 0xEFB3, 0xF2DB, 0xF49C, 0xF605, 0xF4DE, 0xF2FD, 0xF3E0, 0xF44F, 0xF4B8, 0xF6F6, 0xFA91, 0x0188, 0x0856,
    0x0980, 0x09DE, 0x0E82, 0x147F, 0x19FD, 0x2208, 0x2B04, 0x311A, 0x35D8, 0x3B9D, 0x401A, 0x3EDD, 0x39BC, 0x35E7, 0x31A2, 0x2A2A,
    0x228B, 0x1BE5, 0x1443, 0x0B71, 0x02A8, 0xF97C, 0xEEF7, 0xE676, 0xE384, 0xE447, 0xE563, 0xE4D8, 0xE2C2, 0xE370, 0xE86B, 0xEAA4,
    0xE6BD, 0xE290, 0xE41D, 0xE929, 0xEC0A, 0xEBC3, 0xE9BC, 0xEA50, 0xEDA6, 0xEC1A, 0xE447, 0xE1D2, 0xE817, 0xED79, 0xF06E, 0xF2C4,
    0xF4C5, 0xF871, 0xFA99, 0xF98B, 0xF857, 0xF708, 0xF640, 0xF68D, 0xF526, 0xF4E1, 0xFA98, 0x018E, 0x0402, 0x0561, 0x08BF, 0x0C5B,
    0x1066, 0x17A4, 0x20AB, 0x2725, 0x2BA5, 0x32BF, 0x3A52, 0x3CB4, 0x3B65, 0x39C0, 0x36E8, 0x31D2, 0x2BD9, 0x2659, 0x1FF8, 0x1899,
    0x1227, 0x0AB1, 0x000F, 0xF593, 0xEE18, 0xEAFB, 0xEB69, 0xEA62, 0xE5EC, 0xE334, 0xE644, 0xE9B4, 0xE7B7, 0xE2EA, 0xE0C0, 0xE30B,
    0xE7A8, 0xEA2C, 0xE7F4, 0xE7CC, 0xED4D, 0xEDF2, 0xE7F4, 0xE3E6, 0xE440, 0xE857, 0xECB4, 0xEE5F, 0xF0A6, 0xF4FA, 0xF878, 0xFAC5,
    0xFB9B, 0xFAB1, 0xFB69, 0xFC93, 0xF9ED, 0xF746, 0xFA25, 0xFF8F, 0x02A1, 0x04BF, 0x072B, 0x08D7, 0x09FC, 0x0E3D, 0x15EB, 0x1BE0,
    0x204D, 0x2772, 0x2FC6, 0x359E, 0x37E1, 0x3886, 0x3755, 0x3331, 0x2E0F, 0x28DF, 0x2239, 0x1B5C, 0x15C6, 0x0FC5, 0x07C7, 0xFDC7,
    0xF3A0, 0xED89, 0xED42, 0xEDED, 0xEAD3, 0xE72F, 0xE880, 0xECF5, 0xEE75, 0xEBFD, 0xE760, 0xE504, 0xE890, 0xEAA3, 0xE70D, 0xE5EE,
    0xE9AB, 0xEB9C, 0xE915, 0xE41C, 0xE122, 0xE348, 0xE69C, 0xE933, 0xEC5C, 0xEFD2, 0xF467, 0xF95C, 0xFB21, 0xFA8F, 0xFC2C, 0xFE47,
    0xFC48, 0xF8F6, 0xF925, 0xFCE3, 0x00D9, 0x0485, 0x091E, 0x0B83, 0x0B85, 0x0E77, 0x1468, 0x195A, 0x1D21, 0x22CC, 0x2A7E, 0x30B3,
    0x34BF, 0x37BB, 0x37EE, 0x353C, 0x31C3, 0x2D75, 0x276C, 0x2102, 0x1B2E, 0x15DD, 0x1041, 0x079A, 0xFB6D, 0xF0F6, 0xED0F, 0xECA9,
    0xE9BC, 0xE593, 0xE47C, 0xE6C7, 0xEAF6, 0xECA7, 0xE85E, 0xE548, 0xE8C3, 0xEBB3, 0xEAE9, 0xEA4F, 0xEC5F, 0xF0B1, 0xF197, 0xECE0,
    0xE7DC, 0xE5AB, 0xE5AB, 0xE732, 0xE88D, 0xE973, 0xED25, 0xF2C3, 0xF53D, 0xF561, 0xF762, 0xFA5A, 0xFA66, 0xF774, 0xF65B, 0xF82D,
    0xFA96, 0xFEA9, 0x0467, 0x07BA, 0x0813, 0x09BE, 0x0ECA, 0x1436, 0x1869, 0x1E5C, 0x266D, 0x2E21, 0x3518, 0x3A9F, 0x3CE0, 0x3CA9,
    0x3ADC, 0x3775, 0x3264, 0x2BDE, 0x24A3, 0x1E2D, 0x196E, 0x12F8, 0x06F4, 0xF976, 0xF1AE, 0xEE82, 0xEB9C, 0xE81D, 0xE3B5, 0xE247,
    0xE6D4, 0xE9E6, 0xE6FC, 0xE3C8, 0xE480, 0xE728, 0xE7EB, 0xE67A, 0xE76A, 0xEC60, 0xF04A, 0xF00E, 0xED62, 0xE9D6, 0xE866, 0xEA35,
    0xEB63, 0xEB21, 0xED93, 0xF29C, 0xF574, 0xF56F, 0xF64D, 0xF8DD, 0xF914, 0xF68C, 0xF490, 0xF35B, 0xF2C7, 0xF51E, 0xFA94, 0xFF55,
    0x00C4, 0x0234, 0x0685, 0x0B19, 0x0F36, 0x1480, 0x1B0A, 0x2263, 0x2A75, 0x325B, 0x37DE, 0x3B39, 0x3C9A, 0x3C5C, 0x3AC7, 0x3747,
    0x3116, 0x2A53, 0x2692, 0x22EB, 0x1951, 0x0C6C, 0x010D, 0xF891, 0xF44E, 0xEFF2, 0xE825, 0xE2FD, 0xE495, 0xE77F, 0xE6EF, 0xE3B5,
    0xE24E, 0xE463, 0xE5A7, 0xE431, 0xE3C9, 0xE684, 0xEA6F, 0xED77, 0xED47, 0xE9C5, 0xE785, 0xE846, 0xE8DE, 0xE83A, 0xE99D, 0xEEB9,
    0xF373, 0xF594, 0xF865, 0xFC89, 0xFF08, 0xFF16, 0xFE31, 0xFC7E, 0xF96C, 0xF818, 0xFB0E, 0xFEC2, 0xFFCE, 0x005D, 0x0283, 0x0529,
    0x07EE, 0x0B86, 0x0FE0, 0x1598, 0x1D29, 0x25E6, 0x2E24, 0x3468, 0x385D, 0x3A0D, 0x3AF0, 0x3A5E, 0x3555, 0x2E74, 0x2B10, 0x28C0,
    0x23D7, 0x1B8A, 0x0FF3, 0x05E5, 0x0158, 0xFD18, 0xF54D, 0xEDE6, 0xEB62, 0xED3A, 0xEDB5, 0xEA78, 0xE797, 0xE7E1, 0xE829, 0xE668,
    0xE471, 0xE3D6, 0xE61C, 0xEA6F, 0xECC9, 0xEB3E, 0xE8F0, 0xE8ED, 0xE8F8, 0xE71E, 0xE6C3, 0xEA51, 0xEE9F, 0xF11E, 0xF3F7, 0xF85D,
    0xFC12, 0xFE17, 0xFF97, 0xFF8E, 0xFC92, 0xFA32, 0xFBED, 0xFF61, 0x01FD, 0x042C, 0x0640, 0x0886, 0x0AE2, 0x0D3E, 0x0FAA, 0x12D5,
    0x17B5, 0x1E24, 0x25AB, 0x2D0D, 0x31DA, 0x3431, 0x378B, 0x3967, 0x362B, 0x30ED, 0x2C72, 0x2963, 0x27BE, 0x22F6, 0x1861, 0x0D25,
    0x060A, 0x00F2, 0xFA1E, 0xF207, 0xEC9E, 0xECF5, 0xEED9, 0xEDE0, 0xEC65, 0xEC50, 0xECE0, 0xECE1, 0xEAFF, 0xE876, 0xE862, 0xEC28,
    0xEFEC, 0xEFA7, 0xED55, 0xEC74, 0xEB93, 0xE8A1, 0xE62F, 0xE6D1, 0xE9AD, 0xEC28, 0xEE9E, 0xF261, 0xF5D8, 0xF8C0, 0xFC67, 0xFE79,
    0xFCAA, 0xF990, 0xF8D8, 0xFAAA, 0xFD5E, 0xFFD3, 0x0217, 0x046A, 0x074F, 0x0AAC, 0x0D81, 0x10B3, 0x1523, 0x1A32, 0x21E8, 0x2B61,
    0x317A, 0x3568, 0x3A1E, 0x3D1F, 0x3C6A, 0x387D, 0x3236, 0x2D2B, 0x2B64, 0x28A0, 0x2063, 0x14D9, 0x0B5A, 0x05C1, 0xFFA1, 0xF607,
    0xED66, 0xEA33, 0xEA3A, 0xE9DF, 0xE85F, 0xE6FF, 0xE708, 0xE7F7, 0xE7DF, 0xE59D, 0xE420, 0xE742, 0xEC50, 0xEEC0, 0xEED1, 0xEF2D,
    0xEF89, 0xEDAB, 0xEB04, 0xEA79, 0xEB67, 0xEC0E, 0xED1C, 0xEF59, 0xF16B, 0xF355, 0xF6DB, 0xFA32, 0xFA85, 0xF815, 0xF57C, 0xF50B,
    0xF659, 0xF892, 0xFACA, 0xFCC3, 0xFFE7, 0x02B7, 0x0558, 0x0935, 0x0C4E, 0x0F37, 0x1623, 0x1F97, 0x2762, 0x2DFE, 0x346C, 0x3A75,
    0x3F33, 0x3FEB, 0x3BCC, 0x36EF, 0x3518, 0x347F, 0x300F, 0x25CF, 0x1ACA, 0x1344, 0x0C18, 0x020D, 0xF728, 0xEF42, 0xEB43, 0xE96D,
    0xE7B1, 0xE594, 0xE44B, 0xE52A, 0xE5F4, 0xE3F8, 0xE0F9, 0xE170, 0xE50B, 0xE7DB, 0xE905, 0xEA66, 0xEC16, 0xEBB3, 0xE9FF, 0xE956,
    0xE941, 0xE98B, 0xEB69, 0xEE43, 0xF095, 0xF2E0, 0xF664, 0xFABA, 0xFD49, 0xFCD8, 0xFA85, 0xF7E8, 0xF6D8, 0xF721, 0xF76E, 0xF8C1,
    0xFAF7, 0xFC3E, 0xFEB0, 0x0259, 0x0420, 0x05DB, 0x0A8F, 0x11D6, 0x1A19, 0x2202, 0x28C7, 0x2FCF, 0x378E, 0x3C84, 0x3BE1, 0x37A0,
    0x34A5, 0x3547, 0x34B2, 0x2E57, 0x2553, 0x1E05, 0x180E, 0x106C, 0x069D, 0xFD0F, 0xF5F0, 0xF208, 0xEF4A, 0xEB64, 0xE7E7, 0xE746,
    0xE7D8, 0xE61C, 0xE240, 0xDFE3, 0xE113, 0xE2DB, 0xE3C4, 0xE535, 0xE721, 0xE777, 0xE671, 0xE595, 0xE45A, 0xE2F9, 0xE30B, 0xE4F7,
    0xE714, 0xE8D6, 0xEC20, 0xF0FC, 0xF628, 0xFA0B, 0xFA82, 0xF928, 0xF8D5, 0xF848, 0xF7FC, 0xF981, 0xFAF2, 0xFBB8, 0xFE12, 0x012B,
    0x025D, 0x02B1, 0x03E5, 0x0797, 0x0E17, 0x1502, 0x1AF5, 0x2181, 0x29EC, 0x3268, 0x36C8, 0x3501, 0x31EE, 0x325C, 0x33BC, 0x3130,
    0x2ADB, 0x243D, 0x1E8C, 0x181A, 0x0FF1, 0x0664, 0xFD8C, 0xF809, 0xF51B, 0xF1D0, 0xEE66, 0xED45, 0xEEBA, 0xEF53, 0xECA8, 0xE96E,
    0xE874, 0xE869, 0xE862, 0xE959, 0xEA6D, 0xEA93, 0xE9B9, 0xE89F, 0xE6D6, 0xE419, 0xE26B, 0xE2BA, 0xE3A8, 0xE4A6, 0xE6B5, 0xEA1B,
    0xEF9B, 0xF482, 0xF62F, 0xF64D, 0xF60F, 0xF4D7, 0xF46C, 0xF5EB, 0xF6D7, 0xF7A9, 0xFA2B, 0xFD6A, 0x0022, 0x015B, 0x0184, 0x034A,
    0x0833, 0x0EF1, 0x1520, 0x1A15, 0x20D3, 0x2A9E, 0x3270, 0x339F, 0x30CE, 0x2FA7, 0x30C6, 0x3008, 0x2B98, 0x259B, 0x1FAC, 0x1A54,
    0x1398, 0x0A69, 0x0091, 0xF8F7, 0xF48E, 0xF080, 0xEBD6, 0xE8D4, 0xE97C, 0xEAD2, 0xE9EE, 0xE816, 0xE6EC, 0xE6B6, 0xE75A, 0xE95D,
    0xEBD6, 0xED9E, 0xEE9F, 0xEF53, 0xEEDA, 0xEC70, 0xEA0B, 0xE860, 0xE7CB, 0xE7A3, 0xE6FF, 0xE7EB, 0xEBD6, 0xF031, 0xF33B, 0xF576,
    0xF5B8, 0xF440, 0xF3B3, 0xF452, 0xF4C9, 0xF508, 0xF5BF, 0xF82B, 0xFC14, 0xFEF7, 0xFFDD, 0x006B, 0x033A, 0x0973, 0x103B, 0x152B,
    0x1AB6, 0x246F, 0x2F4A, 0x3568, 0x35FF, 0x3525, 0x3598, 0x361F, 0x343E, 0x2F40, 0x28C8, 0x2317, 0x1D4A, 0x1525, 0x0AE6, 0x00EB,
    0xFA04, 0xF4A3, 0xEE46, 0xE8F0, 0xE74F, 0xE7C1, 0xE79F, 0xE6A6, 0xE553, 0xE403, 0xE325, 0xE3F7, 0xE5F5, 0xE7B8, 0xE9B2, 0xEBA4,
    0xECB6, 0xECC1, 0xEBD8, 0xEA9C, 0xEB03, 0xEBC7, 0xEAD6, 0xEAE2, 0xEDAD, 0xF174, 0xF587, 0xF95E, 0xFAE1, 0xFA15, 0xF8EB, 0xF837,
    0xF7F9, 0xF741, 0xF649, 0xF682, 0xF8D7, 0xFC40, 0xFE3C, 0xFE19, 0xFE55, 0x0236, 0x0807, 0x0C69, 0x1053, 0x1808, 0x239E, 0x2DBB,
    0x3301, 0x34F0, 0x368B, 0x38A9, 0x39AA, 0x37A3, 0x3362, 0x2ECF, 0x2A90, 0x24E4, 0x1BE1, 0x1189, 0x0900, 0x01C2, 0xF9A3, 0xF1FA,
    0xECD6, 0xEA8F, 0xE966, 0xE82C, 0xE6D8, 0xE4A9, 0xE27C, 0xE1E1, 0xE1FD, 0xE29E, 0xE454, 0xE65A, 0xE85F, 0xE9A7, 0xE8C9, 0xE70D,
    0xE670, 0xE5D0, 0xE4D6, 0xE602, 0xE85D, 0xEAF8, 0xEFF3, 0xF5C4, 0xFA30, 0xFC8C, 0xFD32, 0xFD91, 0xFE1B, 0xFDF2, 0xFCDF, 0xFB9D,
    0xFBD3, 0xFE85, 0x0163, 0x015C, 0xFFAF, 0x0097, 0x04B4, 0x07FC, 0x0972, 0x0D43, 0x1626, 0x2163, 0x29C9, 0x2DFC, 0x3061, 0x3319,
    0x35AD, 0x363B, 0x33CC, 0x301C, 0x2DA0, 0x2AC7, 0x24A9, 0x1C43, 0x1454, 0x0D5F, 0x05C4, 0xFD91, 0xF6CD, 0xF275, 0xF017, 0xEF1E,
    0xEE13, 0xEBBB, 0xE8EE, 0xE695, 0xE4E8, 0xE476, 0xE4AF, 0xE564, 0xE7C6, 0xEA47, 0xEA73, 0xE98E, 0xE889, 0xE6F7, 0xE5D9, 0xE51B,
    0xE469, 0xE4F3, 0xE769, 0xEC32, 0xF1D4, 0xF5CB, 0xF7C4, 0xF8FE, 0xFA6B, 0xFBE6, 0xFCAD, 0xFC18, 0xFBB8, 0xFE5B, 0x0326, 0x05B8,
    0x04E4, 0x04DA, 0x07FE, 0x0B4C, 0x0C1B, 0x0CB6, 0x112C, 0x1A0D, 0x23EA, 0x2A90, 0x2DE4, 0x3018, 0x3302, 0x3589, 0x34C0, 0x31A6,
    0x2F36, 0x2D2C, 0x28E7, 0x2190, 0x1993, 0x121D, 0x0A2F, 0x01E9, 0xFA2F, 0xF3C5, 0xEFC6, 0xEE46, 0xEDB7, 0xED03, 0xEBB6, 0xE9B0,
    0xE822, 0xE7EA, 0xE76C, 0xE73C, 0xE901, 0xEB48, 0xEBDE, 0xEB22, 0xE9DB, 0xE87C, 0xE743, 0xE640, 0xE51B, 0xE3C5, 0xE387, 0xE5D3,
    0xEA62, 0xEF62, 0xF309, 0xF542, 0xF6D0, 0xF8A5, 0xFA6F, 0xFA38, 0xF83F, 0xF7FF, 0xFB96, 0xFF52, 0xFFD8, 0xFF7B, 0x0185, 0x0585,
    0x080E, 0x086B, 0x0A93, 0x11F4, 0x1CAE, 0x26EA, 0x2DE4, 0x31C9, 0x359B, 0x394F, 0x3A81, 0x38D3, 0x3649, 0x3471, 0x3153, 0x2B6A,
    0x2463, 0x1CBD, 0x148A, 0x0C04, 0x02FF, 0xFA31, 0xF378, 0xEF22, 0xEC6B, 0xEB06, 0xE980, 0xE71D, 0xE551, 0xE492, 0xE3B2, 0xE32D,
    0xE473, 0xE71C, 0xE96F, 0xEA8D, 0xEAF7, 0xEAD2, 0xEA5F, 0xEA08, 0xE96A, 0xE7D7, 0xE60F, 0xE5E0, 0xE7FB, 0xEBE8, 0xF02F, 0xF301,
    0xF42F, 0xF595, 0xF7F5, 0xF8F5, 0xF6E5, 0xF50D, 0xF6CC, 0xFA94, 0xFC90, 0xFC47, 0xFCF4, 0xFFE1, 0x02EF, 0x040C, 0x0400, 0x0635,
    0x0D65, 0x17E8, 0x20FD, 0x2763, 0x2D33, 0x335B, 0x3804, 0x397B, 0x39C1, 0x3A30, 0x3961, 0x366D, 0x3175, 0x2ACE, 0x238E, 0x1BC3,
    0x12C6, 0x08EC, 0xFF21, 0xF676, 0xF070, 0xEE5A, 0xED1B, 0xEA12, 0xE79A, 0xE5FF, 0xE3F0, 0xE200, 0xE104, 0xE1AC, 0xE32D, 0xE47E,
    0xE58F, 0xE602, 0xE64A, 0xE6B4, 0xE71D, 0xE682, 0xE503, 0xE3FF, 0xE489, 0xE759, 0xEC1D, 0xF0A6, 0xF326, 0xF52C, 0xF895, 0xFB58,
    0xFA94, 0xF7CF, 0xF6FD, 0xF968, 0xFBBB, 0xFBBE, 0xFB19, 0xFC6B, 0xFF8B, 0x01E4, 0x01B1, 0x0101, 0x0404, 0x0BD2, 0x155F, 0x1D13,
    0x23AD, 0x2B00, 0x3152, 0x34F8, 0x36C1, 0x37CA, 0x3860, 0x37F4, 0x354C, 0x30DC, 0x2BE6, 0x2658, 0x1FAF, 0x182F, 0x0F81, 0x066E,
    0xFF1E, 0xFA79, 0xF717, 0xF3B2, 0xF081, 0xEE02, 0xEB9F, 0xE8BB, 0xE647, 0xE509, 0xE510, 0xE5C3, 0xE6A2, 0xE704, 0xE6BD, 0xE692,
    0xE687, 0xE5BA, 0xE3E2, 0xE1A9, 0xDF78, 0xDF19, 0xE233, 0xE6E7, 0xEA2D, 0xEC96, 0xF082, 0xF57E, 0xF817, 0xF72D, 0xF5EF, 0xF733,
    0xFA14, 0xFBB8, 0xFB7F, 0xFB8D, 0xFDA2, 0x00C9, 0x01FC, 0x005D, 0xFF43, 0x02B6, 0x09B7, 0x10A5, 0x178D, 0x1F54, 0x26DB, 0x2CD6,
    0x30BB, 0x3303, 0x34BD, 0x35F1, 0x354F, 0x329D, 0x2EEB, 0x2A38, 0x24B7, 0x1E87, 0x16D2, 0x0DA1, 0x04C3, 0xFE16, 0xF9C4, 0xF6AB,
    0xF4EB, 0xF42F, 0xF2D1, 0xF084, 0xEE1D, 0xEC1E, 0xEB21, 0xEBB9, 0xEC51, 0xEC43, 0xEC45, 0xEC3A, 0xEC5E, 0xEC12, 0xEB12, 0xE930,
    0xE5A6, 0xE268, 0xE270, 0xE54D, 0xE831, 0xE979, 0xEB83, 0xEFDA, 0xF3E0, 0xF4B2, 0xF310, 0xF270, 0xF43B, 0xF6E6, 0xF808, 0xF823,
    0xF986, 0xFD61, 0x0146, 0x0180, 0xFF9E, 0x0013, 0x0422, 0x09DB, 0x104A, 0x17B1, 0x1FAC, 0x271D, 0x2C6E, 0x2FBE, 0x321F, 0x33D7,
    0x3448, 0x3369, 0x311E, 0x2D4C, 0x28A1, 0x23AE, 0x1DD0, 0x15B2, 0x0C6A, 0x0432, 0xFDE1, 0xF8F8, 0xF558, 0xF32B, 0xF1B5, 0xEFF6,
    0xEE01, 0xEC05, 0xEA64, 0xEA05, 0xEAF0, 0xEC14, 0xED15, 0xEE3E, 0xEF26, 0xEF89, 0xEFF4, 0xEFB5, 0xED34, 0xE8FF, 0xE65D, 0xE773,
    0xE9E4, 0xEB13, 0xEC06, 0xEF0A, 0xF37E, 0xF68B, 0xF68D, 0xF4E1, 0xF45E, 0xF584, 0xF67D, 0xF5BA, 0xF4CE, 0xF6AE, 0xFAA3, 0xFCB6,
    0xFBB5, 0xFA89, 0xFBA1, 0xFF79, 0x0502, 0x0BA0, 0x13D5, 0x1CDE, 0x2497, 0x2A1E, 0x2E22, 0x3166, 0x33BF, 0x34DF, 0x3479, 0x321D,
    0x2E64, 0x2A62, 0x259D, 0x1ED8, 0x1607, 0x0CD0, 0x0474, 0xFD62, 0xF7E4, 0xF448, 0xF1A2, 0xEF70, 0xED75, 0xEB37, 0xE8D5, 0xE73B,
    0xE726, 0xE7BE, 0xE8B9, 0xEA25, 0xEB33, 0xEBFA, 0xED7D, 0xEF83, 0xF049, 0xEE14, 0xEB46, 0xEAE5, 0xED70, 0xF055, 0xF20B, 0xF428,
    0xF7DB, 0xFA60, 0xFA1E, 0xF94E, 0xF856, 0xF892, 0xFA58, 0xFA30, 0xF88F, 0xF8A1, 0xFB5A, 0xFE30, 0xFE8C, 0xFCB3, 0xFB00, 0xFB69,
    0xFD37, 0x006F, 0x0614, 0x0DD7, 0x15F5, 0x1D2A, 0x2332, 0x2802, 0x2BEB, 0x2F8C, 0x3207, 0x325E, 0x30AA, 0x2E4D, 0x2B4A, 0x26BB,
    0x1FF7, 0x178B, 0x0EC1, 0x05F7, 0xFE73, 0xF882, 0xF3E5, 0xF043, 0xEDA1, 0xEB15, 0xE853, 0xE627, 0xE4FE, 0xE468, 0xE42F, 0xE498,
    0xE585, 0xE60B, 0xE6D0, 0xE963, 0xEBB4, 0xEB84, 0xE8CC, 0xE67E, 0xE6DA, 0xE859, 0xE94B, 0xEA63, 0xED90, 0xF322, 0xF8D5, 0xFC0C,
    0xFCB6, 0xFDB9, 0x0031, 0x01AB, 0x0089, 0xFF0D, 0x0004, 0x0303, 0x0573, 0x04FF, 0x02F6, 0x0197, 0x014B, 0x01F8, 0x04B8, 0x09FA,
    0x1074, 0x1769, 0x1E1D, 0x236F, 0x2751, 0x2ABC, 0x2DB1, 0x2F03, 0x2E71, 0x2CE8, 0x2AFC, 0x282A, 0x23B8, 0x1DC8, 0x165A, 0x0E2A,
    0x0655, 0xFF5D, 0xF972, 0xF501, 0xF1FA, 0xEF8C, 0xECB7, 0xE9A5, 0xE723, 0xE4F3, 0xE38B, 0xE37F, 0xE408, 0xE3B4, 0xE305, 0xE417,
    0xE72B, 0xE93C, 0xE7FC, 0xE51E, 0xE394, 0xE3E4, 0xE475, 0xE48E, 0xE565, 0xE8E5, 0xEEBB, 0xF3CF, 0xF61F, 0xF751, 0xF993, 0xFC4C,
    0xFD4F, 0xFC9A, 0xFCCD, 0xFFC1, 0x03F8, 0x068C, 0x06F9, 0x06B1, 0x0600, 0x0568, 0x062F, 0x08EA, 0x0DC6, 0x1460, 0x1BBE, 0x2248,
    0x277F, 0x2BE5, 0x2FE0, 0x32B0, 0x3379, 0x32B4, 0x3151, 0x2EF7, 0x2B50, 0x267E, 0x1FCA, 0x177F, 0x0E95, 0x05C1, 0xFD8B, 0xF6C6,
    0xF1FE, 0xEEBA, 0xEBEF, 0xE98C, 0xE766, 0xE536, 0xE338, 0xE29C, 0xE38A, 0xE41C, 0xE392, 0xE390, 0xE5E9, 0xE900, 0xE9FA, 0xE822,
    0xE56F, 0xE3F7, 0xE384, 0xE2DC, 0xE19E, 0xE22D, 0xE632, 0xEB84, 0xEF30, 0xF109, 0xF302, 0xF5E2, 0xF84F, 0xF84F, 0xF72B, 0xF805,
    0xFB10, 0xFE2F, 0x0046, 0x0148, 0x017E, 0x014D, 0x0191, 0x030A, 0x0654, 0x0BFB, 0x139D, 0x1BA2, 0x22C7, 0x28DF, 0x2E9C, 0x33A4,
    0x36B8, 0x37EC, 0x3810, 0x3715, 0x3550, 0x3278, 0x2DF7, 0x2762, 0x1F59, 0x16A7, 0x0D43, 0x0430, 0xFCE4, 0xF72E, 0xF24F, 0xEE55,
    0xEB25, 0xE7BB, 0xE3F2, 0xE133, 0xE0A1, 0xE112, 0xE0AC, 0xDFD2, 0xE0C1, 0xE3E7, 0xE6E6, 0xE806, 0xE6FA, 0xE585, 0xE553, 0xE545,
    0xE3BC, 0xE242, 0xE373, 0xE74D, 0xEB68, 0xEDB7, 0xEEFB, 0xF149, 0xF494, 0xF61C, 0xF53E, 0xF476, 0xF598, 0xF805, 0xFAA5, 0xFCF1,
    0xFDDF, 0xFDE0, 0xFD86, 0xFD55, 0xFDDE, 0x0050, 0x0580, 0x0CDC, 0x14B4, 0x1C34, 0x23BF, 0x2AF7, 0x3120, 0x35CB, 0x3893, 0x39D1,
    0x3A3F, 0x39B5, 0x37CC, 0x33E5, 0x2E68, 0x278B, 0x1F84, 0x16C2, 0x0E23, 0x0670, 0x001B, 0xFB1F, 0xF74E, 0xF3BE, 0xEF28, 0xEA8E,
    0xE7AD, 0xE699, 0xE559, 0xE2DB, 0xE094, 0xE0A3, 0xE2BB, 0xE468, 0xE411, 0xE278, 0xE189, 0xE1AC, 0xE0F7, 0xDF0B, 0xDE0D, 0xE005,
    0xE472, 0xE843, 0xEAB0, 0xED65, 0xF199, 0xF4F4, 0xF599, 0xF4C2, 0xF444, 0xF50B, 0xF702, 0xF95E, 0xFB1B, 0xFBEE, 0xFC2F, 0xFC10,
    0xFB7A, 0xFB6E, 0xFDD6, 0x02D6, 0x091A, 0x1011, 0x1772, 0x1EA0, 0x2598, 0x2BB2, 0x300D, 0x32B6, 0x3472, 0x35A5, 0x3606, 0x34F9,
    0x32A7, 0x2EE0, 0x2915, 0x21A1, 0x19F3, 0x12D3, 0x0C17, 0x0638, 0x01F9, 0xFEE7, 0xFB09, 0xF65A, 0xF25F, 0xF011, 0xEEF1, 0xECF2,
    0xE9E2, 0xE7C2, 0xE853, 0xEA3B, 0xEAC4, 0xE94C, 0xE730, 0xE60C, 0xE510, 0xE24F, 0xDE75, 0xDC8A, 0xDE17, 0xE0F4, 0xE2DB, 0xE4CA,
    0xE821, 0xEC2C, 0xEF8F, 0xF0FE, 0xF0F3, 0xF0FD, 0xF255, 0xF50D, 0xF82D, 0xFA5B, 0xFBD9, 0xFCD1, 0xFC71, 0xFAE9, 0xFA91, 0xFC8A,
    0x009C, 0x0662, 0x0CFA, 0x13D6, 0x1B0A, 0x225D, 0x28CB, 0x2D4F, 0x308A, 0x32D9, 0x342B, 0x345F, 0x338B, 0x316A, 0x2D00, 0x268E,
    0x1EFB, 0x1798, 0x1028, 0x0909, 0x03A1, 0x0086, 0xFDC9, 0xF9F7, 0xF5DB, 0xF35A, 0xF278, 0xF1E7, 0xF010, 0xED69, 0xEC86, 0xEE12,
    0xEFFD, 0xF069, 0xEF6C, 0xEE74, 0xEE59, 0xED3A, 0xE9ED, 0xE61F, 0xE4F1, 0xE61E, 0xE72F, 0xE7E5, 0xE95D, 0xEBF5, 0xEEED, 0xF0AA,
    0xF0A2, 0xEFA7, 0xEF46, 0xF04C, 0xF22F, 0xF431, 0xF664, 0xF8AD, 0xF9C2, 0xF960, 0xF8A0, 0xF8E2, 0xFB0C, 0xFF6F, 0x0561, 0x0BA3,
    0x1253, 0x1985, 0x209F, 0x26A4, 0x2B39, 0x2EA4, 0x30F4, 0x3254, 0x32F3, 0x3280, 0x3066, 0x2C36, 0x2658, 0x1FA2, 0x1840, 0x1036,
    0x08D2, 0x0391, 0xFFD3, 0xFBD2, 0xF6FD, 0xF2AF, 0xF089, 0xF007, 0xEF26, 0xECD3, 0xEACA, 0xEB2D, 0xED9B, 0xF01B, 0xF071, 0xEFEB,
    0xF091, 0xF195, 0xF0AA, 0xED71, 0xEA9A, 0xEA49, 0xEB3E, 0xEC54, 0xED95, 0xEFCD, 0xF301, 0xF669, 0xF8C8, 0xF8ED, 0xF804, 0xF78D,
    0xF7C4, 0xF83D, 0xF95A, 0xFACD, 0xFBB9, 0xFB57, 0xF9BF, 0xF7D1, 0xF6D3, 0xF7F8, 0xFB38, 0xFFB0, 0x0527, 0x0BEF, 0x13AB, 0x1B64,
    0x2236, 0x27F6, 0x2C5B, 0x2F32, 0x311E, 0x3289, 0x323F, 0x2FD3, 0x2BBB, 0x2676, 0x2014, 0x1819, 0x0F4B, 0x07BF, 0x02E7, 0xFF3B,
    0xFAC7, 0xF59D, 0xF179, 0xEFB6, 0xEEFF, 0xED40, 0xEA6C, 0xE80F, 0xE820, 0xEA3C, 0xEB7D, 0xEB9E, 0xEC7D, 0xEE64, 0xEF64, 0xEDD6,
    0xEB1F, 0xE981, 0xE965, 0xEA0B, 0xEAB5, 0xEC00, 0xEE8D, 0xF2C2, 0xF6DD, 0xF8E5, 0xF964, 0xF98B, 0xF9F1, 0xFAD5, 0xFC42, 0xFE21,
    0x000A, 0x0182, 0x01C8, 0x0049, 0xFDE9, 0xFC78, 0xFCB1, 0xFE68, 0x0122, 0x053A, 0x0AD0, 0x112C, 0x176E, 0x1D44, 0x2255, 0x2611,
    0x28B6, 0x2B01, 0x2CDB, 0x2D27, 0x2B92, 0x28B9, 0x24E0, 0x1F49, 0x17B8, 0x0F9C, 0x08E3, 0x0448, 0x0016, 0xFAE1, 0xF59A, 0xF1C5,
    0xEFF6, 0xEEA4, 0xEBB8, 0xE7FC, 0xE637, 0xE6DE, 0xE7E3, 0xE7DF, 0xE81E, 0xE988, 0xEB45, 0xEB52, 0xE953, 0xE6D4, 0xE571, 0xE546,
    0xE5C9, 0xE63B, 0xE7A2, 0xEAE5, 0xEF73, 0xF385, 0xF634, 0xF7C7, 0xF8C1, 0xF966, 0xFA5D, 0xFC02, 0xFE23, 0x00F0, 0x0354, 0x041F,
    0x0317, 0x01BE, 0x015C, 0x01DA, 0x034C, 0x0604, 0x0A2C, 0x0F85, 0x158C, 0x1BA4, 0x212A, 0x255C, 0x281E, 0x2A30, 0x2C13, 0x2CFF,
    0x2C41, 0x2A37, 0x2730, 0x22C6, 0x1C3A, 0x13C5, 0x0B71, 0x052C, 0x007D, 0xFBF2, 0xF6B6, 0xF1D8, 0xEF19, 0xEE5A, 0xECE8, 0xE9B8,
    0xE6CE, 0xE615, 0xE6BF, 0xE706, 0xE6CD, 0xE768, 0xE921, 0xEA48, 0xE992, 0xE75A, 0xE514, 0xE3B0, 0xE2D9, 0xE211, 0xE1B2, 0xE2B5,
    0xE5B6, 0xE9C0, 0xED89, 0xF077, 0xF27E, 0xF3E3, 0xF50B, 0xF648, 0xF855, 0xFBC0, 0xFF83, 0x0259, 0x0386, 0x031A, 0x0245, 0x01B1,
    0x019C, 0x02BD, 0x0571, 0x09DC, 0x0F98, 0x1639, 0x1D3E, 0x2394, 0x284D, 0x2BD8, 0x2F22, 0x31A2, 0x3277, 0x31BD, 0x2FFF, 0x2D31,
    0x2851, 0x20CA, 0x174A, 0x0E26, 0x0738, 0x01D2, 0xFB91, 0xF471, 0xEED0, 0xEBDE, 0xEA09, 0xE6F5, 0xE313, 0xE0B1, 0xE086, 0xE0D8,
    0xE0D4, 0xE14A, 0xE31E, 0xE5AB, 0xE750, 0xE6B8, 0xE4F6, 0xE373, 0xE2B8, 0xE1C6, 0xE056, 0xDFBE, 0xE10D, 0xE3DF, 0xE715, 0xEA29,
    0xECAB, 0xEE5E, 0xEFA0, 0xF087, 0xF16A, 0xF30A, 0xF5D4, 0xF934, 0xFBC4, 0xFCD4, 0xFCD6, 0xFC93, 0xFC71, 0xFCE0, 0xFE43, 0x00A8,
    0x0455, 0x0962, 0x0FD0, 0x16D9, 0x1E14, 0x2444, 0x2968, 0x2E74, 0x31F6, 0x3357, 0x3380, 0x331B, 0x3194, 0x2D94, 0x2630, 0x1D0A,
    0x14DC, 0x0EA8, 0x0880, 0x00EF, 0xF91F, 0xF35F, 0xF04F, 0xED37, 0xE8A2, 0xE463, 0xE1EF, 0xE0A6, 0xDF6A, 0xDE06, 0xDD89, 0xDE93,
    0xE061, 0xE140, 0xE072, 0xDF40, 0xDE5C, 0xDDC8, 0xDD09, 0xDC1E, 0xDBD3, 0xDD16, 0xE03D, 0xE429, 0xE7F1, 0xEB40, 0xEDBD, 0xEF6A,
    0xF075, 0xF16A, 0xF338, 0xF62E, 0xF988, 0xFBDB, 0xFCAC, 0xFC8F, 0xFC14, 0xFB5B, 0xFB36, 0xFC30, 0xFE4D, 0x01BF, 0x073C, 0x0E2F,
    0x1530, 0x1B5B, 0x20FA, 0x26AE, 0x2BC6, 0x2F64, 0x3156, 0x3282, 0x3338, 0x3276, 0x2EA3, 0x2775, 0x1F49, 0x18A4, 0x1356, 0x0CFE,
    0x054B, 0xFE9D, 0xFA25, 0xF651, 0xF232, 0xEE11, 0xEA64, 0xE802, 0xE609, 0xE38F, 0xE138, 0xE043, 0xE0D7, 0xE1B0, 0xE1A9, 0xE07F,
    0xDEE0, 0xDD89, 0xDC13, 0xDA28, 0xD83A, 0xD708, 0xD780, 0xD9EC, 0xDD52, 0xE108, 0xE4CC, 0xE804, 0xEA56, 0xEBDD, 0xED6D, 0xEFE3,
    0xF3AC, 0xF796, 0xFA79, 0xFC31, 0xFCDA, 0xFCB2, 0xFC87, 0xFCE2, 0xFD9E, 0xFF0F, 0x0229, 0x0781, 0x0DDD, 0x13E8, 0x194E, 0x1EC2,
    0x2478, 0x2938, 0x2C38, 0x2E0A, 0x2FD2, 0x3170, 0x3146, 0x2D96, 0x26E1, 0x2013, 0x1AA6, 0x14E9, 0x0D88, 0x05F6, 0xFFFE, 0xFBE5,
    0xF845, 0xF418, 0xEFB9, 0xEC93, 0xEAAC, 0xE8A1, 0xE61F, 0xE45A, 0xE3F4, 0xE4E5, 0xE5D8, 0xE5A5, 0xE493, 0xE324, 0xE1C7, 0xE00F,
    0xDDB2, 0xDB1F, 0xD9AA, 0xD9D0, 0xDB64, 0xDDFD, 0xE0F7, 0xE3BF, 0xE608, 0xE76A, 0xE7FD, 0xE907, 0xEB8F, 0xEF2B, 0xF2E0, 0xF616,
    0xF833, 0xF951, 0xF9D5, 0xFA79, 0xFB5B, 0xFBF4, 0xFD4D, 0x0109, 0x06B8, 0x0D1F, 0x1356, 0x1961, 0x1FA4, 0x25DB, 0x2AAA, 0x2DA9,
    0x2FB1, 0x322B, 0x3443, 0x33C3, 0x2F79, 0x2948, 0x2370, 0x1E0F, 0x1778, 0x0FAC, 0x0853, 0x033C, 0xFF7B, 0xFBA4, 0xF70C, 0xF324,
    0xF05D, 0xEE34, 0xEBB8, 0xE967, 0xE7CE, 0xE7FD, 0xE938, 0xEA5D, 0xEA75, 0xE9EC, 0xE961, 0xE845, 0xE695, 0xE480, 0xE417, 0xE15A,
    0xE19A, 0xE23F, 0xE4B1, 0xE3A8, 0xE986, 0xF852, 0xF7D5, 0xF6D5, 0xF664, 0xF71A, 0xF729, 0xF8CB, 0xFC39, 0xFBF3, 0xFC18, 0xFAD2,
    0xFB67, 0xF907, 0xF83A, 0xFB0D, 0xFC44, 0x0405, 0x0ADB, 0x0FFB, 0x138F, 0x17D3, 0x1E10, 0x21FF, 0x2717, 0x29D0, 0x2DB0, 0x3053,
    0x3022, 0x2CB0, 0x285D, 0x2468, 0x20A0, 0x1802, 0x100D, 0x0874, 0x0397, 0xFFA6, 0xFA9D, 0xF984, 0xF3AA, 0xF27C, 0xF48D, 0xED13,
    0xE545, 0xE047, 0xDE88, 0xF5E9, 0x042D, 0x048C, 0x05C0, 0x031F, 0x01B2, 0xFE8C, 0xFD82, 0xF85B, 0xF6E1, 0xF363, 0xF566, 0xF71A,
    0xF45B, 0xF859, 0xF26E, 0xF51E, 0xFF22, 0x04B2, 0x0A6E, 0x0B48, 0x113D, 0x15C9, 0x1D14, 0x1E5D, 0x15EF, 0x122C, 0x0F07, 0x1083,
    0x0E39, 0x0A1E, 0x0906, 0x01BE, 0xFD75, 0x0258, 0x09A2, 0x122D, 0x11AB, 0x11FE, 0x0C98, 0x0586, 0x138D, 0x169B, 0x0DED, 0x04BE,
    0xFFE6, 0xFA67, 0xF2D1, 0xF176, 0xEC20, 0xED48, 0xEE66, 0xF170, 0xF4A7, 0xF325, 0xF7F0, 0xF812, 0xFC0E, 0x0406, 0x06E6, 0x07B4,
    0x0505, 0x0509, 0x04D9, 0x03C6, 0x03D3, 0x04AD, 0x0624, 0x05F1, 0x0628, 0x05FC, 0x0435, 0x0376, 0x045D, 0x0812, 0x0D74, 0x1034,
    0x115E, 0x1171, 0x12F3, 0x1502, 0x150E, 0x14FD, 0x1478, 0x1445, 0x1230, 0x0FA8, 0x0D6E, 0x09F3, 0x0744, 0x061A, 0x06CD, 0x079D,
    0x0769, 0x06BD, 0x0797, 0x07A7, 0x08BE, 0x08AB, 0x06C7, 0x06CD, 0x074D, 0x0839, 0x052E, 0x025D, 0x0020, 0xFCCB, 0xFAEC, 0xFA1F,
    0xFA7E, 0xF986, 0xF93A, 0xFA73, 0xFADB, 0xFC00, 0xFCF7, 0xFE01, 0x006B, 0x034D, 0x05D8, 0x0726, 0x07DC, 0x083F, 0x078A, 0x07EB,
    0x0996, 0x0AE2, 0x0BAC, 0x0BE7, 0x0BB6, 0x0B27, 0x0B41, 0x0B21, 0x0A70, 0x0C07, 0x0D89, 0x0ED5, 0x1028, 0x10CE, 0x1102, 0x10B3,
    0x1132, 0x10DB, 0x10AC, 0x1088, 0x101B, 0x0FD0, 0x0EE1, 0x0DFC, 0x0CD5, 0x0BCD, 0x0BAC, 0x0B97, 0x0B2E, 0x0AB4, 0x0A0F, 0x09A9,
    0x08A9, 0x0761, 0x05CA, 0x044C, 0x0365, 0x0219, 0x00D6, 0xFF37, 0xFE36, 0xFD41, 0xFC0E, 0xFB83, 0xFB3B, 0xFB3B, 0xFB60, 0xFB37,
    0xFAEE, 0xFA6F, 0xFA4D, 0xFAF5, 0xFBC8, 0xFD36, 0xFEB9, 0xFFD1, 0x0083, 0x014D, 0x0209, 0x02A3, 0x037A, 0x047A, 0x057E, 0x0686,
    0x06D2, 0x0701, 0x06EE, 0x0664, 0x0610, 0x05D2, 0x05B0, 0x05F7, 0x0644, 0x0676, 0x0669, 0x066B, 0x0684, 0x06A7, 0x06F2, 0x0753,
    0x07DB, 0x0834, 0x0886, 0x089A, 0x0833, 0x07C6, 0x0735, 0x0712, 0x0726, 0x0727, 0x0749, 0x0747, 0x0707, 0x0657, 0x0565, 0x04CA,
    0x041F, 0x0360, 0x0213, 0x006D, 0xFF0D, 0xFDB9, 0xFC27, 0xFA90, 0xF947, 0xF887, 0xF7DD, 0xF734, 0xF66C, 0xF5BA, 0xF543, 0xF4FF,
    0xF4F8, 0xF548, 0xF601, 0xF690, 0xF754, 0xF85C, 0xF932, 0xF9EC, 0xFA88, 0xFB21, 0xFBEA, 0xFCB9, 0xFD55, 0xFDCB, 0xFDEF, 0xFE17,
    0xFE3B, 0xFE41, 0xFE8D, 0xFF26, 0xFF44, 0xFF69, 0xFF75, 0xFF3C, 0xFF12, 0xFF13, 0xFF1A, 0xFF70, 0xFFEC, 0x0056, 0x00C7, 0x013A,
    0x0186, 0x01C6, 0x0258, 0x030B, 0x038C, 0x03EE, 0x0415, 0x0419, 0x03F7, 0x036B, 0x0277, 0x0179, 0x00BB, 0x001B, 0xFF0C, 0xFDD0,
    0xFC97, 0xFB89, 0xFA55, 0xF8E0, 0xF788, 0xF660, 0xF5AA, 0xF501, 0xF424, 0xF357, 0xF2CD, 0xF21C, 0xF1CD, 0xF1F5, 0xF222, 0xF274,
    0xF2F2, 0xF387, 0xF42D, 0xF490, 0xF44D, 0xF3E3, 0xF3FF, 0xF463, 0xF4F6, 0xF571, 0xF60D, 0xF70F, 0xF89E, 0xFB2D, 0xFE34, 0x00CD,
    0x0254, 0x037E, 0x047D, 0x047E, 0x03D0, 0x0215, 0xFE3C, 0xF924, 0xF4C3, 0xF46A, 0xF62C, 0xF728, 0xF9C5, 0xFCA5, 0xFDDA, 0xFE9A,
    0xFEE3, 0xFF21, 0xFF9B, 0x00B2, 0x0141, 0x004C, 0xFE55, 0xFCE4, 0xFC9D, 0xFC4D, 0xFBF1, 0xFB21, 0xFA6C, 0xF9A7, 0xF885, 0xF776,
    0xF5FE, 0xF4A7, 0xF3EA, 0xF333, 0xF296, 0xF208, 0xF189, 0xF0F1, 0xF06A, 0xF095, 0xF0BE, 0xF0F7, 0xF11E, 0xF149, 0xF199, 0xF1D1,
    0xF1CC, 0xF1B3, 0xF112, 0xF0BB, 0xF05E, 0xF02A, 0xEFFB, 0xEFEF, 0xEFE6, 0xEFB0, 0xEFAD, 0xEFD3, 0xF01E, 0xF0D3, 0xF200, 0xF2FF,
    0xF460, 0xF590, 0xF6F4, 0xF7F5, 0xF92B, 0xFA2D, 0xFB25, 0xFBFA, 0xFD3A, 0xFE3D, 0xFEC9, 0xFF3D, 0xFF6A, 0xFF64, 0xFF3D, 0xFF30,
    0xFF49, 0xFF83, 0xFF64, 0xFF12, 0xFE89, 0xFEC1, 0xFE1A, 0xFD48, 0xFBA8, 0xFABF, 0xF98F, 0xF8D5, 0xF76B, 0xF65A, 0xF53F, 0xF4E6,
    0xF441, 0xF421, 0xF3BB, 0xF383, 0xF385, 0xF32E, 0xF493, 0xF440, 0xF525, 0xF4C3, 0xF661, 0xF556, 0xF776, 0xF5D2, 0xF793, 0xEBBE,
    0xF20F, 0x0106, 0xF5A7, 0xF614, 0xEA28, 0x068C, 0xF150, 0xEDA8, 0xF76F, 0xEF2E, 0xFA3B, 0xE1A1, 0xF7FA, 0xF634, 0xF2B4, 0xF559,
    0xF8EC, 0xEE90, 0x079B, 0xF0DF, 0xEF85, 0x02ED, 0xEAF5, 0xFFB6, 0xE854, 0xF17C, 0x06B9, 0xF9E1, 0xF4A7, 0x1B9B, 0xFFAA, 0xD8FC,
    0xF5DE, 0xFDD3, 0x2077, 0xECC7, 0xCE6F, 0x2C7F, 0xE34C, 0xEB44, 0x0D76, 0xEC57, 0x14C5, 0xCEFD, 0xF8FE, 0x122C, 0xD256, 0xE9C9,
    0xF2F5, 0x0D5F, 0xF942, 0xE64C, 0xEAF3, 0xFEFD, 0xE709, 0xDE4F, 0xDED1, 0xD049, 0xE6CA, 0xB6E0, 0xEAEB, 0xCD21, 0xB4CA, 0xBBBF,
    0xD235, 0xD3C0, 0xB30E, 0xCF38, 0xC498, 0xC03F, 0xC352, 0xFD07, 0xD7EA, 0xD748, 0x0306, 0x0CAB, 0x01EC, 0x0ED5, 0x1B67, 0x2CE6,
    0x30E5, 0x21CB, 0x3C0B, 0x33D2, 0x4805, 0x221C, 0x3F9E, 0x48F3, 0x3817, 0x2CD1, 0x1222, 0x4462, 0x0D59, 0xEF8B, 0xE3D3, 0xE774,
    0xD4F8, 0xB390, 0xBABB, 0xBC75, 0xA93A, 0x940A, 0xACB3, 0x97C0, 0x8FEA, 0x9E05, 0xADCF, 0x90D9, 0x8E18, 0xA1C9, 0xA6A2, 0xB5F4,
    0xAC79, 0xB029, 0xB316, 0xB3CB, 0xE199, 0xC8F5, 0xC08D, 0xD9AB, 0xD368, 0xC975, 0xED21, 0x2FAE, 0x01A2, 0x1A6C, 0x1CB9, 0x4212,
    0x4BF9, 0x4CA6, 0x6845, 0x56E4, 0x5D47, 0x632A, 0x7B76, 0x6D32, 0x6E17, 0x5307, 0x7FFF, 0x5381, 0x5717, 0x7FFF, 0x6AB9, 0x7FFF,
    0x6DB5, 0x7687, 0x7A80, 0x7E8C, 0x6BCC, 0x7D2B, 0x648F, 0x5A76, 0x64F1, 0x5ABE, 0x328E, 0x39B7, 0x563B, 0x243F, 0x3C29, 0x4597,
    0x2A83, 0x195E, 0x3E73, 0x3472, 0x1B17, 0x4EBC, 0x30FF, 0x21A2, 0x3593, 0x1FA2, 0x1985, 0x2833, 0x2104, 0xFF2E, 0x2C3E, 0x1B01,
    0x07D1, 0x06F9, 0x05D0, 0x0B70, 0xF9C9, 0x1B74, 0x0150, 0x2A67, 0x052B, 0x1322, 0x2622, 0x0089, 0x0DF5, 0x0893, 0x21BE, 0xEAA3,
    0x0DD5, 0x0909, 0xF7B3, 0xF49D, 0x0F70, 0xFBC6, 0xC2CA, 0xF0D8, 0xC325, 0xBF8D, 0xC4C8, 0xAE51, 0x9AFB, 0xBAF2, 0xABCF, 0x9219,
    0xB66F, 0x975A, 0x9D7C, 0xA8AF, 0x9960, 0xAA4A, 0xA963, 0xAEF9, 0xBF01, 0xA1B2, 0x9ACE, 0xA622, 0xA241, 0xA1D3, 0xABC6, 0x94E7,
    0x9FD1, 0xA91E, 0xA76E, 0xA1E7, 0xB26C, 0xA267, 0xA546, 0xC5C7, 0xAFF2, 0xBD5C, 0xB118, 0xC942, 0xB54D, 0xC450, 0xCA03, 0xC399,
    0xC8D2, 0xCCAF, 0xC274, 0xD689, 0xD14E, 0xBD56, 0xDF24, 0xAF36, 0xC391, 0xC1D3, 0xDA07, 0xCE3A, 0xC803, 0xD30C, 0xE2C5, 0xE400,
    0xD343, 0xD647, 0xD955, 0xE77B, 0xE105, 0x0658, 0x073A, 0xF6FD, 0x12CD, 0x261A, 0x00E2, 0x1841, 0x17A3, 0x09EF, 0x08F1, 0xFDFA,
    0xF765, 0x0D36, 0x01D8, 0xF410, 0x04D0, 0x1CB7, 0x1BE5, 0x1EA1, 0x2F6D, 0x2627, 0x4FEA, 0x36C0, 0x53AC, 0x4FFD, 0x2FCA, 0x40A0,
    0x3FB5, 0x3EF3, 0x3B21, 0x3B99, 0x36A4, 0x4234, 0x39CB, 0x33E1, 0x5A53, 0x563A, 0x47A3, 0x5BA4, 0x62D9, 0x6281, 0x75B7, 0x652B,
    0x652F, 0x7FFF, 0x6FF9, 0x69DE, 0x6747, 0x7FFF, 0x708E, 0x6EC7, 0x6DC2, 0x646B, 0x7680, 0x6171, 0x4603, 0x7503, 0x6AD4, 0x7225,
    0x68C1, 0x575E, 0x78AC, 0x6FA1, 0x6C4A, 0x68BA, 0x75BB, 0x4953, 0x6FC8, 0x5EB1, 0x6E1A, 0x692B, 0x54E1, 0x726E, 0x63BF, 0x5F78,
    0x59CC, 0x578B, 0x5E02, 0x5DEA, 0x3946, 0x575B, 0x4B9F, 0x535F, 0x43BA, 0x28B8, 0x4749, 0x2A38, 0x2BF5, 0x39B3, 0x1CCF, 0x348E,
    0x236F, 0x2BA9, 0x0505, 0xDDCB, 0x06F9, 0x019C, 0xFB9F, 0xE8E1, 0xDA3A, 0xF173, 0xF2DE, 0xE128, 0xE6B9, 0xE5F2, 0xF685, 0xE424,
    0x1963, 0x1BB4, 0xEB4F, 0x0F2B, 0x19FF, 0xFD20, 0xFE07, 0x197A, 0x057E, 0x0213, 0xF817, 0xD4E8, 0xF671, 0xE44C, 0xD148, 0xDABD,
    0xC524, 0xD418, 0xE09E, 0xCF58, 0xCF80, 0xDAE8, 0xBF8E, 0xCCFC, 0xBFA3, 0xC525, 0xD27C, 0xBA43, 0xCB27, 0xCD4F, 0xCBFB, 0xCD4E,
    0xC673, 0xD990, 0xD112, 0xD274, 0xCB54, 0xCA57, 0xC4E6, 0xCC6E, 0xB881, 0xB3E1, 0xC6DF, 0xA419, 0xB8D4, 0x9A7D, 0xAF1B, 0xA5AB,
    0xA678, 0xA92B, 0x9D76, 0xB143, 0xA555, 0x9D96, 0xA1A3, 0xAAF0, 0x9007, 0xA45F, 0x99F0, 0xA3AD, 0x9B55, 0xA3A2, 0xA242, 0xA375,
    0xA744, 0xA738, 0xAEEF, 0x9BB9, 0xBA04, 0xB661, 0xB731, 0xAFB8, 0xBD22, 0xBE40, 0xBC08, 0xBBB8, 0xCD18, 0xC282, 0xCD84, 0xCFF4,
    0xBB14, 0xC6EC, 0xCC31, 0xD042, 0xC530, 0xCBDB, 0xD961, 0xDA9F, 0xCE08, 0xF0DC, 0xD502, 0xF50F, 0xE918, 0xE1D8, 0xEA05, 0xE224,
    0x04B3, 0xEBF2, 0xF857, 0xF8C9, 0x03E8, 0xFFFD, 0xFF4A, 0x08F1, 0x124D, 0x1603, 0x10BB, 0x13D3, 0x1DB4, 0x21B1, 0x2A70, 0x153E,
    0x1D63, 0x2CCC, 0x1CC9, 0x2DE0, 0x2541, 0x2E84, 0x2D0A, 0x274C, 0x2711, 0x2190, 0x271E, 0x188E, 0x0E36, 0x14AB, 0x18BB, 0xFCF9,
    0x1148, 0x08AB, 0x06C7, 0x08C3, 0x09A8, 0x1657, 0x097A, 0x3250, 0x1D14, 0x20C7, 0x29C8, 0x1EDA, 0x1C83, 0x28EF, 0x29AB, 0x255B,
    0x14B8, 0x1A36, 0x1C8A, 0x1D5D, 0x226A, 0xF3A8, 0xFFFB, 0x0A4F, 0xF821, 0xFFD3, 0x2245, 0xFDCE, 0xFF47, 0x0FEC, 0x1168, 0x128F,
    0x1261, 0x0B20, 0x0C85, 0x1D12, 0x2369, 0x27B8, 0x317F, 0x38D5, 0x3417, 0x400D, 0x3B2A, 0x5032, 0x4913, 0x458B, 0x5AC4, 0x5078,
    0x55DA, 0x5DBD, 0x4AE7, 0x61BF, 0x4A79, 0x5561, 0x4B1F, 0x5014, 0x58B4, 0x4CDD, 0x5965, 0x547F, 0x4CA8, 0x455C, 0x5AE9, 0x389F,
    0x484B, 0x3F2B, 0x35D9, 0x4380, 0x4657, 0x296E, 0x4113, 0x3915, 0x3C22, 0x396F, 0x37C8, 0x51A1, 0x3762, 0x51E8, 0x3BCC, 0x3DA9,
    0x417A, 0x407E, 0x35A4, 0x45B6, 0x43F4, 0x34C6, 0x35F0, 0x3B2C, 0x2BD2, 0x23CE, 0x3693, 0x2753, 0x299A, 0x2D8B, 0x2926, 0x1F7B,
    0x26B4, 0x2FC0, 0x24DA, 0x1CFB, 0x2F00, 0x2543, 0x245C, 0x18C3, 0x21E9, 0x191B, 0x16B2, 0x228C, 0x0D38, 0x1559, 0x1727, 0x1A6C,
    0x1B47, 0x211F, 0x24C3, 0x29DF, 0x211C, 0x2FB3, 0x1CF1, 0x1A80, 0x2F0A, 0x1FA0, 0x1593, 0x2214, 0x2C91, 0x2759, 0x0D64, 0x2297,
    0x279A, 0x0E4A, 0x1697, 0x03B6, 0x0C01, 0x05FE, 0x0470, 0xF2B1, 0xF1E0, 0xEEC3, 0xFB8F, 0xEA7E, 0xF354, 0x08ED, 0xEB83, 0xFCA8,
    0xFCC2, 0xF759, 0xEE94, 0xEA52, 0xF334, 0xE1CB, 0xE9D6, 0xF42A, 0xD42A, 0xE219, 0xE62B, 0xCFED, 0xC2CE, 0xCAC1, 0xBC4E, 0xB2D3,
    0xBB1D, 0xBBEE, 0xB018, 0xB3DA, 0xB304, 0xADE8, 0xB270, 0xA97D, 0xAE54, 0xA74B, 0xA92B, 0xB149, 0xAEDF, 0xB59A, 0xBF51, 0xBE9B,
    0xC525, 0xC7BE, 0xC4EF, 0xCDD6, 0xD528, 0xD220, 0xE21F, 0xCB53, 0xD4AD, 0xDB48, 0xCC3A, 0xD6A9, 0xCB6E, 0xC46C, 0xC43F, 0xCAFF,
    0xC986, 0xCB30, 0xCB02, 0xC22A, 0xBE05, 0xBFBC, 0xB658, 0xBEE6, 0xB19F, 0xADE2, 0xABAE, 0xAE9B, 0xAA34, 0xA7A5, 0xA436, 0xA190,
    0xAF15, 0xAF01, 0xB22B, 0xA988, 0xB5CB, 0xAE69, 0xB3BD, 0xAD12, 0xB406, 0xB0D3, 0xAF24, 0xB796, 0xB198, 0xB428, 0xAA5D, 0xBA45,
    0xB147, 0xA8B1, 0xB295, 0xABD4, 0xB4E4, 0xB3F6, 0xB29B, 0xBA0F, 0xB44C, 0xBC5C, 0xBD2B, 0xBEB7, 0xB78A, 0xC80F, 0xC0DD, 0xB889,
    0xC4F3, 0xC2B8, 0xBEDE, 0xBACB, 0xC523, 0xC0A8, 0xC7A4, 0xBEEA, 0xCA6B, 0xCF1F, 0xC96C, 0xD39E, 0xD6F6, 0xD854, 0xDB6B, 0xE3FE,
    0xD456, 0xE125, 0xE175, 0xE32A, 0xE466, 0xE50E, 0xF3CB, 0xE177, 0xE613, 0xE77A, 0xE215, 0xE69B, 0xF2CD, 0xE256, 0xE2E3, 0xEC23,
    0xE160, 0xE818, 0xE085, 0xE2D2, 0xF1AB, 0xF1B1, 0xF092, 0xF8EC, 0xF0B4, 0xFDE8, 0xF2A1, 0xF4E8, 0xF4B1, 0xEF9F, 0x024E, 0xF3B1,
    0xF943, 0xFAD8, 0xF65B, 0xEF7E, 0xEBC6, 0xF458, 0xE097, 0xE20B, 0xEEB3, 0xE05A, 0xE337, 0xEA65, 0xEFCB, 0xE07E, 0xE71A, 0xE987,
    0xEBD8, 0xEEE4, 0xEC25, 0xF1EE, 0xF19B, 0xFA98, 0xFC86, 0x0A95, 0x0DDE, 0x17AB, 0x2269, 0x21C7, 0x2E11, 0x34A8, 0x39D7, 0x46B8,
    0x42A8, 0x3CED, 0x41E5, 0x4203, 0x42B4, 0x4349, 0x4206, 0x4D0A, 0x461C, 0x447E, 0x518E, 0x4476, 0x4CB8, 0x4C48, 0x46DE, 0x4A4A,
    0x3BAF, 0x4B1A, 0x3F36, 0x3952, 0x33F7, 0x31FF, 0x326B, 0x380D, 0x39AB, 0x3617, 0x4096, 0x3D9E, 0x4D5C, 0x3C37, 0x44C2, 0x480A,
    0x46AE, 0x47E7, 0x4F83, 0x5117, 0x4C2D, 0x4C0E, 0x4A40, 0x4947, 0x435E, 0x44F2, 0x4748, 0x3DC1, 0x41D3, 0x49AA, 0x3AE5, 0x4E8E,
    0x52EB, 0x477F, 0x4BAE, 0x52DC, 0x4F8B, 0x5D93, 0x5134, 0x5895, 0x591F, 0x53D2, 0x58C8, 0x4D0C, 0x4EAA, 0x5053, 0x473B, 0x406E,
    0x4C82, 0x49D2, 0x4AF6, 0x4057, 0x5181, 0x49DB, 0x4BB8, 0x4AB5, 0x4311, 0x5022, 0x46A5, 0x51E4, 0x4DD0, 0x4EB5, 0x4E77, 0x4799,
    0x47B9, 0x4617, 0x4644, 0x41EC, 0x3DDE, 0x3CF6, 0x350F, 0x380E, 0x351E, 0x2DFB, 0x3495, 0x3084, 0x394E, 0x3A29, 0x43BB, 0x46DD,
    0x3DD8, 0x3BF7, 0x35F0, 0x35DA, 0x22E1, 0x265B, 0x12D8, 0x0B12, 0x00CE, 0xEE5E, 0xF8C4, 0xED32, 0xF484, 0xE8A0, 0xE83E, 0xE6B9,
    0xE646, 0xE9F5, 0xE421, 0xEC98, 0xEF84, 0xEEF4, 0xEB41, 0xE945, 0xE1EE, 0xE8E3, 0xE7EE, 0xE321, 0xEA7C, 0xED99, 0xEDC6, 0xF3C6,
    0xF285, 0xF3EF, 0xFD0A, 0x0246, 0x0914, 0x0DDE, 0x1156, 0x1801, 0x1EF1, 0x1F82, 0x20A2, 0x1EFB, 0x266B, 0x2097, 0x2D5B, 0x3A0D,
    0x3537, 0x3B2C, 0x3B34, 0x3F08, 0x342B, 0x30E1, 0x2DBA, 0x31C3, 0x2C40, 0x2216, 0x244B, 0x1319, 0x078F, 0x0596, 0xF1B2, 0xE3CD,
    0xE6BF, 0xE17D, 0xD604, 0xCFEF, 0xD9FD, 0xD9F1, 0xD977, 0xD748, 0xD81E, 0xD835, 0xDC34, 0xD882, 0xDD30, 0xDC3C, 0xD3B1, 0xDA44,
    0xCE8B, 0xC889, 0xBD4D, 0xBDEF, 0xBB3C, 0xB92C, 0xBAFE, 0xC33D, 0xC645, 0xC357, 0xCB9F, 0xCBE2, 0xCF4F, 0xD0FE, 0xD446, 0xCE59,
    0xD7D6, 0xDDF9, 0xD22A, 0xDF6C, 0xD862, 0xD7A3, 0xE164, 0xD979, 0xE4F4, 0xEA0B, 0xF281, 0xF95E, 0xF74A, 0xEC1D, 0xEF01, 0xEE3C,
    0xE9BF, 0xEDD7, 0xEA97, 0xEFA2, 0xE850, 0xE9D0, 0xE59D, 0xDBC2, 0xD3A8, 0xCD58, 0xC022, 0xBFEB, 0xBEA7, 0xB3BD, 0xB847, 0xB922,
    0xB595, 0xB629, 0xBE5B, 0xBA6D, 0xC025, 0xBEE6, 0xC4FC, 0xC8D2, 0xCEA0, 0xD1BA, 0xC896, 0xC95F, 0xC57E, 0xC5E2, 0xC68A, 0xCA87,
    0xC417, 0xC5D8, 0xC4D6, 0xC3FD, 0xC2C1, 0xBED9, 0xC5CB, 0xBE8B, 0xBB42, 0xC3B3, 0xC0C7, 0xC231, 0xC3F9, 0xC6CC, 0xCC1C, 0xC71B,
    0xC991, 0xD602, 0xE089, 0xDE8C, 0xF59E, 0xFA72, 0xF547, 0xF709, 0xEF14, 0xEF90, 0xF0AF, 0xF75B, 0xFCA3, 0x0121, 0x0071, 0x044F,
    0xF3A7, 0xF2D3, 0xE980, 0xDD18, 0xD7F0, 0xCB27, 0xD1CE, 0xCF61, 0xD476, 0xD9F5, 0xD204, 0xDA01, 0xE2A7, 0xDF19, 0xE651, 0xE1AD,
    0xEC7E, 0xE52F, 0xE71A, 0xE86F, 0xDA64, 0xD88D, 0xD06E, 0xD4AF, 0xD67A, 0xD69A, 0xD259, 0xDA6B, 0xDA73, 0xDE2A, 0xE544, 0xE96D,
    0xEEC2, 0xEBFF, 0xF460, 0xF8AC, 0xF349, 0x002F, 0x0190, 0xF929, 0xFBFA, 0x0174, 0x080A, 0x08A8, 0x115C, 0x1F24, 0x2547, 0x2905,
    0x3446, 0x371B, 0x349A, 0x3C31, 0x3857, 0x3B86, 0x4109, 0x3F25, 0x44FE, 0x34AE, 0x3608, 0x26F7, 0x1A2B, 0x1485, 0x0265, 0xFE44,
    0xF691, 0xFBA0, 0xFBF1, 0xF57B, 0xFC06, 0xFE78, 0xF65A, 0x05FD, 0xFFC0, 0x031B, 0x18BD, 0x179A, 0x202E, 0x2413, 0x1C77, 0x2090,
    0x1F42, 0x26C6, 0x2198, 0x230A, 0x290C, 0x21EC, 0x1B4B, 0x21DB, 0x2354, 0x21CC, 0x2FEC, 0x264B, 0x3450, 0x2B71, 0x3596, 0x3917,
    0x35CA, 0x39B2, 0x46DC, 0x4E88, 0x4B74, 0x5C4D, 0x5C3C, 0x6B59, 0x69AA, 0x6A6F, 0x6A48, 0x656E, 0x6126, 0x5A23, 0x53C0, 0x55D8,
    0x55D5, 0x582B, 0x4DAF, 0x45A9, 0x443D, 0x3C7C, 0x2E05, 0x2137, 0x1924, 0x0FE9, 0x102B, 0x1278, 0x1147, 0x11A5, 0x1431, 0x0CB8,
    0x0DD0, 0x0CFA, 0x1446, 0x175E, 0x2193, 0x2B12, 0x34F8, 0x3187, 0x337A, 0x30A9, 0x2F96, 0x3161, 0x315A, 0x35BA, 0x2F9E, 0x37A5,
    0x38B8, 0x4088, 0x41E3, 0x4D4F, 0x4CC6, 0x517A, 0x5047, 0x5437, 0x53DA, 0x47D8, 0x504E, 0x447F, 0x43A0, 0x45C6, 0x43FC, 0x4892,
    0x4A63, 0x55F3, 0x551F, 0x585F, 0x5A73, 0x5740, 0x5B9C, 0x55A0, 0x58DF, 0x598C, 0x5F66, 0x5B58, 0x5D17, 0x54D2, 0x51F7, 0x4BAE,
    0x3D39, 0x34E7, 0x2BA2, 0x2A37, 0x2034, 0x1FE3, 0x1A0B, 0x2005, 0x1D2A, 0x1D1E, 0x1E42, 0x1F80, 0x25BA, 0x2C04, 0x30FE, 0x36CA,
    0x375E, 0x32B4, 0x333D, 0x2D19, 0x20CA, 0x1D86, 0x22E3, 0x18EB, 0x1BD9, 0x16B7, 0x19E8, 0x17C8, 0x16BF, 0x199C, 0x159D, 0x16FA,
    0x18C8, 0x20B2, 0x1B54, 0x2561, 0x2426, 0x253D, 0x2C5A, 0x2EDE, 0x3774, 0x3D10, 0x487C, 0x4D90, 0x4D99, 0x4EC2, 0x4C44, 0x442C,
    0x3D84, 0x3BA7, 0x3BC8, 0x3B8F, 0x4384, 0x38A2, 0x3840, 0x32CB, 0x2A72, 0x255B, 0x18BC, 0x187F, 0x09D7, 0x0C2D, 0x0B31, 0x0591,
    0x026D, 0x0666, 0xFD9E, 0xF926, 0xF611, 0xECE9, 0xEC62, 0xE89A, 0xF150, 0xEDBB, 0xF128, 0xEE62, 0xE5D1, 0xDE63, 0xD77C, 0xD6BF,
    0xD2F8, 0xD31B, 0xD0F5, 0xCFFF, 0xD078, 0xD0A2, 0xD5BE, 0xCF19, 0xCB67, 0xD1A5, 0xCD2B, 0xD2F4, 0xD0AF, 0xD64D, 0xD8E8, 0xD834,
    0xDE45, 0xE060, 0xEA30, 0xE9DD, 0xFCE4, 0xFEE7, 0x0189, 0x08EF, 0x0B96, 0x0B55, 0x061E, 0x0D9C, 0x1082, 0x1402, 0x1078, 0x11F1,
    0x06CE, 0x0170, 0xFADD, 0xEA0B, 0xDF0D, 0xD1CB, 0xCA7F, 0xC303, 0xBCB6, 0xB75E, 0xB6B3, 0xB4AB, 0xAFA2, 0xB23A, 0xAE0B, 0xB126,
    0xB690, 0xB450, 0xBCBD, 0xC074, 0xC159, 0xC2CA, 0xBE8A, 0xBBF4, 0xB9F1, 0xBB02, 0xB5CD, 0xB7DE, 0xBAF8, 0xB8AE, 0xBCE8, 0xBE20,
    0xBFCC, 0xC051, 0xC67C, 0xC6E8, 0xCE3B, 0xD1DF, 0xD484, 0xDAFA, 0xD7D3, 0xDA39, 0xD9A0, 0xD905, 0xDBAF, 0xDF3A, 0xE570, 0xE9D1,
    0xEEE2, 0xEF8E, 0xEAC3, 0xE736, 0xE202, 0xE172, 0xE17C, 0xE102, 0xE2A0, 0xE07A, 0xDDE3, 0xDBFD, 0xD6BE, 0xD42F, 0xCD3C, 0xCB21,
    0xC712, 0xC443, 0xC78D, 0xC292, 0xC014, 0xBE1D, 0xBB3C, 0xB4D1, 0xB420, 0xB30C, 0xB141, 0xB53B, 0xB7C4, 0xBB59, 0xBDB5, 0xB7F3,
    0xB611, 0xB456, 0xB12B, 0xB1B8, 0xB715, 0xBC94, 0xBD37, 0xC55E, 0xC3E8, 0xCAAB, 0xCA1A, 0xC78E, 0xCD6D, 0xC833, 0xC906, 0xCA62,
    0xCC65, 0xCA9F, 0xCD57, 0xCCC6, 0xC929, 0xCA56, 0xCF19, 0xD525, 0xDA20, 0xE5EC, 0xEB3F, 0xE9CD, 0xE95B, 0xE506, 0xE151, 0xDE37,
    0xE001, 0xDF73, 0xDE1B, 0xDE35, 0xDCC0, 0xD9EE, 0xD368, 0xD2A1, 0xCAE4, 0xCACF, 0xC72D, 0xC49C, 0xC233, 0xC307, 0xC77A, 0xC1CD,
    0xC5AE, 0xC352, 0xC9EC, 0xCBE9, 0xD34A, 0xD871, 0xDD59, 0xE529, 0xE152, 0xE251, 0xDBE4, 0xD6A6, 0xD4AC, 0xCDEE, 0xC974, 0xC8D8,
    0xC51C, 0xC925, 0xC314, 0xC595, 0xC47F, 0xC400, 0xC923, 0xC7D6, 0xD0B8, 0xD094, 0xD6E4, 0xDF50, 0xE02D, 0xE569, 0xE59F, 0xEC21,
    0xF475, 0xF919, 0x0715, 0x0E81, 0x1908, 0x1936, 0x1EDD, 0x1DF4, 0x1947, 0x1F37, 0x1D4D, 0x2041, 0x22E9, 0x28CF, 0x29C8, 0x26CF,
    0x2068, 0x18CC, 0x0F9B, 0x074A, 0xFDFE, 0xFAF9, 0xF2C0, 0xF08B, 0xF265, 0xECE0, 0xEA36, 0xE6CD, 0xEA09, 0xE4E1, 0xE97B, 0xED51,
    0xF04D, 0xF507, 0xF468, 0xF31F, 0xF344, 0xF72D, 0xF7ED, 0xFB34, 0xFF09, 0xFFB5, 0x0571, 0x06E6, 0x05DB, 0x0B3F, 0x0655, 0x08CA,
    0x0698, 0x0502, 0x02E3, 0x01AD, 0x03C8, 0x0260, 0x0480, 0x0360, 0x0711, 0x09CC, 0x0BA4, 0x15FE, 0x2423, 0x2E35, 0x3D11, 0x45A4,
    0x472D, 0x47BA, 0x4C11, 0x4877, 0x46BA, 0x48C0, 0x48AF, 0x46AE, 0x43D5, 0x3D3F, 0x3156, 0x28A8, 0x1DC4, 0x1621, 0x0AD4, 0x04F0,
    0x02FC, 0x01CE, 0xFB7B, 0xF95D, 0xF256, 0xEEBD, 0xE6F5, 0xE4AD, 0xE9A2, 0xE717, 0xED0D, 0xEEBC, 0xF12B, 0xEE18, 0xF155, 0xEE75,
    0xF0B3, 0xF38B, 0xF5DA, 0xFB0B, 0xFBDE, 0x000E, 0x018F, 0x06E2, 0x068A, 0x0EDC, 0x1576, 0x1A93, 0x1EEC, 0x269C, 0x2A99, 0x2A7F,
    0x3082, 0x2C90, 0x2C90, 0x2C38, 0x2C8E, 0x2F8A, 0x375E, 0x3A08, 0x3AD3, 0x3A0D, 0x3890, 0x383E, 0x34D9, 0x321B, 0x30CC, 0x34DD,
    0x360F, 0x395E, 0x3DF1, 0x3AE2, 0x3717, 0x3304, 0x2CDD, 0x2734, 0x218D, 0x1F16, 0x1886, 0x1CEE, 0x1941, 0x14D0, 0x134B, 0x0C1F,
    0x076F, 0x0B54, 0x0B74, 0x0F55, 0x1ABA, 0x1AFF, 0x1D9E, 0x210E, 0x1F08, 0x19C6, 0x1AE9, 0x1432, 0x1426, 0x10F6, 0x11E9, 0x0E2F,
    0x0EB7, 0x0E62, 0x0A45, 0x10F0, 0x0E16, 0x0AFA, 0x10B6, 0x124D, 0x0C3A, 0x0F94, 0x0F5C, 0x0CEC, 0x103A, 0x1717, 0x1BBC, 0x2A83,
    0x3809, 0x4313, 0x475D, 0x4BA3, 0x48DF, 0x4827, 0x4738, 0x4158, 0x3E41, 0x3C24, 0x39FF, 0x35E5, 0x31DF, 0x25F9, 0x2391, 0x1684,
    0x0D60, 0x06FA, 0x0261, 0xFC87, 0xFB6F, 0xFFB0, 0xFFC5, 0x086C, 0x078E, 0x060F, 0x0716, 0x06D1, 0x0782, 0x0C55, 0x0FB2, 0x0DE7,
    0x0F67, 0x0B3B, 0x008B, 0xFB59, 0xF564, 0xEDE5, 0xEBCC, 0xED88, 0xEA51, 0xE83F, 0xE6C8, 0xE3B8, 0xE222, 0xDDE9, 0xD761, 0xD6B8,
    0xD626, 0xD0C0, 0xD36E, 0xD3C5, 0xD210, 0xD45C, 0xD673, 0xD7F5, 0xE0CA, 0xEC95, 0xF59A, 0x0095, 0x070E, 0x0A36, 0x0ABE, 0x0CB5,
    0x0DE4, 0x0DFD, 0x1227, 0x13AA, 0x1AF0, 0x1CC9, 0x1B0F, 0x1CBD, 0x171C, 0x0C73, 0x02F0, 0xFA75, 0xED54, 0xE81E, 0xE2C1, 0xDCA3,
    0xDA97, 0xD59E, 0xCE30, 0xCA60, 0xC4D2, 0xC19F, 0xC653, 0xC85E, 0xCBCB, 0xD0BE, 0xD441, 0xD199, 0xD4FE, 0xD815, 0xD0F1, 0xD3E8,
    0xD7B0, 0xD672, 0xD7D9, 0xDA2A, 0xDA0E, 0xD8DB, 0xD7F1, 0xD165, 0xD1E3, 0xD5C4, 0xD3A6, 0xD6C8, 0xDBB6, 0xD8EA, 0xDE5F, 0xE0B3,
    0xDE22, 0xE22B, 0xEB15, 0xF49E, 0xFECC, 0x0994, 0x0A87, 0x08E6, 0x08E1, 0x07EA, 0x03F0, 0x05FE, 0x039E, 0x040B, 0x04A7, 0xFDE4,
    0xF8F0, 0xF387, 0xEA2B, 0xDFFA, 0xDBBC, 0xD3AF, 0xCE8E, 0xCEF6, 0xCB70, 0xCBC5, 0xCE2C, 0xC9C0, 0xC429, 0xBFBF, 0xB861, 0xB715,
    0xBA45, 0xBCB6, 0xC0A1, 0xC34C, 0xC38F, 0xBF58, 0xBF9C, 0xB78B, 0xB55F, 0xB980, 0xB98B, 0xBE92, 0xC171, 0xC5F8, 0xC8D6, 0xCD45,
    0xCCE8, 0xCE92, 0xD5C2, 0xD933, 0xDB49, 0xDEF2, 0xDF13, 0xDB68, 0xDC77, 0xD5E3, 0xD2E9, 0xD39D, 0xD2D7, 0xDA07, 0xE34B, 0xE9C0,
    0xECF3, 0xF11E, 0xF0F6, 0xECF3, 0xEC39, 0xEAD1, 0xE6BC, 0xE658, 0xDFFA, 0xDD81, 0xDA52, 0xD478, 0xCD79, 0xC993, 0xC59A, 0xBEB7,
    0xBDEE, 0xB9C1, 0xBB27, 0xB990, 0xB9C0, 0xBA3A, 0xB926, 0xB6C0, 0xB677, 0xBB26, 0xBC60, 0xC046, 0xC996, 0xC995, 0xCE6B, 0xD685,
    0xD25A, 0xD24F, 0xD2AA, 0xD06B, 0xCCA4, 0xD141, 0xCFBF, 0xCDD7, 0xD1E1, 0xCDD4, 0xCA7A, 0xCA33, 0xC88A, 0xC4EE, 0xC84C, 0xC80D,
    0xC6E4, 0xCD3A, 0xCA3E, 0xC734, 0xCA7A, 0xCC19, 0xD303, 0xE1DA, 0xEB6A, 0xF24B, 0xFEA9, 0x0271, 0xFF4A, 0x010B, 0x0103, 0xFDFD,
    0x00B7, 0x00EE, 0x01E3, 0x07BD, 0x06F1, 0x0275, 0x0292, 0xFD33, 0xF7C8, 0xF8DD, 0xF48B, 0xF108, 0xF07D, 0xF0E5, 0xED7A, 0xEC23,
    0xE86A, 0xE1C9, 0xE466, 0xE191, 0xE335, 0xE795, 0xE630, 0xE50D, 0xE796, 0xE29C, 0xDD23, 0xDEB9, 0xDCDD, 0xDA5F, 0xDDF9, 0xE0A6,
    0xE296, 0xEE9F, 0xF1A4, 0xF1F1, 0xF6A0, 0xFB89, 0xFA45, 0xFE2B, 0xFF9B, 0xFDF3, 0x0077, 0x00A6, 0xFC32, 0xF811, 0xF37D, 0xED35,
    0xF503, 0xF922, 0x014F, 0x0FA5, 0x181D, 0x1B43, 0x202D, 0x228D, 0x2223, 0x2701, 0x2D90, 0x304D, 0x377B, 0x3C91, 0x3B6C, 0x3B2C,
    0x32B8, 0x2919, 0x2032, 0x17A8, 0x0E84, 0x09F0, 0x06D8, 0x02F6, 0x0190, 0x00C9, 0xFB1C, 0xF869, 0xF702, 0xF3D6, 0xF614, 0xF2B5,
    0xEFA1, 0xEFCC, 0xE94D, 0xE20E, 0xE399, 0xE127, 0xDE83, 0xE2C2, 0xE0FF, 0xE024, 0xE548, 0xE769, 0xE714, 0xEAC3, 0xEDB1, 0xEE10,
    0xF330, 0xF7B5, 0xF929, 0x0188, 0x0A1F, 0x0CE4, 0x11A7, 0x14CB, 0x168C, 0x1FCD, 0x2776, 0x2A4D, 0x3504, 0x3E55, 0x3E6C, 0x3F2D,
    0x4046, 0x390E, 0x351D, 0x3428, 0x2CAC, 0x2CE4, 0x2E94, 0x2A18, 0x2846, 0x2719, 0x1E53, 0x182C, 0x14AD, 0x0C7A, 0x0B17, 0x0E7D,
    0x0C33, 0x102A, 0x148C, 0x1061, 0x0F30, 0x0F83, 0x0CA3, 0x0D97, 0x1326, 0x11CB, 0x1822, 0x1DF6, 0x1C1A, 0x1EE4, 0x2180, 0x212D,
    0x2211, 0x26EF, 0x2465, 0x2777, 0x2C55, 0x2476, 0x2676, 0x2A17, 0x2650, 0x26BF, 0x2ADA, 0x277E, 0x2736, 0x2DC6, 0x29D5, 0x28CE,
    0x26BF, 0x1EE0, 0x1D15, 0x20FC, 0x2057, 0x28FF, 0x37C9, 0x3D46, 0x453C, 0x4D40, 0x4E25, 0x4D5C, 0x5094, 0x4D6D, 0x4C5E, 0x5067,
    0x4ED6, 0x4DC6, 0x4CFA, 0x4411, 0x3A51, 0x31CC, 0x22C3, 0x1781, 0x106D, 0x0860, 0x05CF, 0x0829, 0x08AC, 0x08F8, 0x0D6A, 0x0A4F,
    0x0B6E, 0x114B, 0x1412, 0x1FB9, 0x2A1C, 0x2EDF, 0x35B3, 0x3AB1, 0x3892, 0x37C0, 0x361E, 0x30C9, 0x2EE6, 0x2E91, 0x29AF, 0x2960,
    0x2BB7, 0x267A, 0x2727, 0x2A9B, 0x2514, 0x238B, 0x2653, 0x224D, 0x1C2E, 0x1789, 0x0CDE, 0x0411, 0x0536, 0x0156, 0x05B5, 0x1661,
    0x1E76, 0x276C, 0x324C, 0x3254, 0x3276, 0x36D5, 0x337C, 0x3146, 0x3524, 0x3391, 0x32D4, 0x3707, 0x3656, 0x3318, 0x320F, 0x2AC2,
    0x23F5, 0x2003, 0x1783, 0x1315, 0x14E3, 0x10FC, 0x0B6C, 0x0A56, 0x015F, 0xFB28, 0xF892, 0xF065, 0xEFA7, 0xF481, 0xF3F3, 0xF4BF,
    0xF759, 0xF500, 0xF2CC, 0xF421, 0xF31B, 0xF3FE, 0xFBF2, 0xFE59, 0x02B0, 0x0AD4, 0x0AAB, 0x0D03, 0x12D3, 0x11B8, 0x0FBD, 0x136F,
    0x13A5, 0x1073, 0x1060, 0x0C82, 0x07CC, 0x09A3, 0x0914, 0x0B81, 0x1703, 0x22FA, 0x2C91, 0x393B, 0x3FF9, 0x3E6A, 0x43CC, 0x443F,
    0x402B, 0x42A3, 0x43CE, 0x41DD, 0x43C6, 0x43FF, 0x3DF3, 0x3898, 0x2FC1, 0x227F, 0x16D6, 0x0A90, 0x0043, 0xFCE3, 0xF88E, 0xF49F,
    0xF356, 0xF22F, 0xEEF9, 0xEF1B, 0xEC58, 0xE943, 0xED77, 0xF07D, 0xF249, 0xF564, 0xF69B, 0xF312, 0xEF5A, 0xE998, 0xE26C, 0xDFF8,
    0xDD55, 0xD91D, 0xDC4C, 0xDBC9, 0xDC6B, 0xE3FA, 0xE5ED, 0xE66C, 0xEEBE, 0xF572, 0xFBC7, 0x05E4, 0x0789, 0x068A, 0x06A0, 0x04EE,
    0x01B2, 0x0590, 0x0A3E, 0x0DE4, 0x1671, 0x1A59, 0x19B8, 0x1B49, 0x1B60, 0x1845, 0x1AA0, 0x1C1C, 0x197F, 0x1821, 0x1767, 0x1072,
    0x092E, 0x02EE, 0xF3A7, 0xE7BC, 0xDB8A, 0xCED5, 0xC8B7, 0xC513, 0xC1F7, 0xC1FB, 0xC34A, 0xC20F, 0xC291, 0xBEC7, 0xBC89, 0xBBF4,
    0xBB87, 0xBC35, 0xBF01, 0xC202, 0xC535, 0xC8EB, 0xC8A9, 0xC7C1, 0xC8F5, 0xC936, 0xC9CF, 0xCF9D, 0xD169, 0xD2A6, 0xD928, 0xDA38,
    0xD415, 0xD564, 0xD4A9, 0xD0C7, 0xD4F2, 0xD578, 0xCF53, 0xCF59, 0xCC3E, 0xC2B5, 0xC407, 0xC7A0, 0xCA36, 0xD732, 0xE4D1, 0xE7F0,
    0xF1FE, 0xFB0B, 0xF8C2, 0xFD49, 0x026F, 0xFE53, 0x0256, 0x0689, 0x0004, 0xFB96, 0xF98C, 0xF0AE, 0xE741, 0xE2D6, 0xDA35, 0xD58C,
    0xD596, 0xD1C3, 0xCF6A, 0xD194, 0xD1C2, 0xD1F1, 0xD424, 0xD1C5, 0xD0BB, 0xD45D, 0xD643, 0xD77D, 0xDE22, 0xE285, 0xE338, 0xE3A9,
    0xDF6B, 0xD8D1, 0xD2AF, 0xCE86, 0xCB81, 0xCAD1, 0xCB30, 0xCE1E, 0xD004, 0xCED9, 0xD014, 0xD25B, 0xD4C1, 0xDA11, 0xE036, 0xE1DC,
    0xE3D9, 0xE4F4, 0xDFFE, 0xDCC8, 0xDD4F, 0xDD9C, 0xE30A, 0xEA0A, 0xEE23, 0xF2F9, 0xF75C, 0xF616, 0xF53B, 0xF896, 0xF898, 0xFA76,
    0x01E8, 0x0659, 0x0907, 0x0F3C, 0x1125, 0x10FB, 0x0F15, 0x08C3, 0x0273, 0xFDC9, 0xF864, 0xF163, 0xEDF9, 0xE9E8, 0xE5A3, 0xE09C,
    0xDAF6, 0xD786, 0xD6C5, 0xD6C9, 0xD889, 0xDC38, 0xDDAF, 0xDE7C, 0xDCC5, 0xD8CF, 0xD56C, 0xD28F, 0xCF5D, 0xCE02, 0xCAAB, 0xC762,
    0xC981, 0xCD06, 0xCED1, 0xD358, 0xD6EA, 0xD528, 0xD7A1, 0xDA10, 0xD688, 0xD878, 0xDA92, 0xD7E2, 0xD921, 0xDAA3, 0xDBB3, 0xE0B0,
    0xEC9E, 0xF686, 0x02A3, 0x1387, 0x1B9B, 0x2263, 0x28AA, 0x262D, 0x24E5, 0x28CB, 0x2654, 0x2432, 0x2822, 0x2408, 0x1D0E, 0x17EA,
    0x0D87, 0x0135, 0xF8F7, 0xF308, 0xEB97, 0xEBB3, 0xEB5E, 0xE9D9, 0xEB5A, 0xE8E3, 0xE786, 0xE9C0, 0xEB1E, 0xEACB, 0xEE7F, 0xF04A,
    0xF174, 0xF4D1, 0xF441, 0xF18A, 0xF0C4, 0xF025, 0xF020, 0xF341, 0xF484, 0xF769, 0xFF31, 0x03A8, 0x061B, 0x0DE5, 0x1170, 0x1259,
    0x195A, 0x1D15, 0x208B, 0x2827, 0x29C8, 0x2621, 0x26B3, 0x246F, 0x20BF, 0x2341, 0x24FC, 0x25BA, 0x2D38, 0x3456, 0x35C4, 0x3ADD,
    0x3CFE, 0x3B28, 0x3C99, 0x3E5A, 0x3CC2, 0x4037, 0x45EA, 0x4681, 0x4691, 0x43F7, 0x3DAC, 0x355E, 0x2E5A, 0x2406, 0x1A6D, 0x1595,
    0x1152, 0x0BB0, 0x060A, 0x003B, 0xF8AD, 0xF475, 0xF27D, 0xF25E, 0xF56F, 0xFD1D, 0x051D, 0x0C44, 0x1321, 0x1695, 0x1965, 0x1D66,
    0x1FCF, 0x2096, 0x236C, 0x2487, 0x2290, 0x21EF, 0x233F, 0x2259, 0x23BF, 0x273D, 0x272F, 0x2962, 0x2CDA, 0x2BEE, 0x2A5C, 0x2883,
    0x227B, 0x1D49, 0x1C11, 0x1B39, 0x1CD9, 0x2312, 0x2812, 0x2CAD, 0x32B3, 0x35C7, 0x35B0, 0x380D, 0x3880, 0x3659, 0x37AD, 0x3829,
    0x369C, 0x36E8, 0x3447, 0x2C13, 0x258E, 0x1E36, 0x13A0, 0x0D36, 0x0D13, 0x0C8D, 0x0F9F, 0x11BF, 0x1048, 0x1051, 0x0E69, 0x0CC2,
    0x0D06, 0x0E34, 0x0F08, 0x1303, 0x15F5, 0x1492, 0x1195, 0x0E31, 0x093D, 0x04DC, 0x018C, 0xFD47, 0xFD0B, 0xFD12, 0xFC90, 0xFEFC,
    0x0284, 0x0591, 0x0C30, 0x106B, 0x11CF, 0x17D9, 0x19B3, 0x1785, 0x181D, 0x1601, 0x0D64, 0x0A09, 0x0B20, 0x09C4, 0x0F55, 0x1CA8,
    0x260B, 0x317D, 0x3EBE, 0x4290, 0x462E, 0x4C6D, 0x4C1E, 0x4C43, 0x52D1, 0x55C7, 0x5777, 0x5B87, 0x585D, 0x512D, 0x4DC5, 0x445B,
    0x36D0, 0x3028, 0x28CC, 0x1EE7, 0x19F2, 0x1388, 0x0920, 0x040B, 0x01D0, 0xFC8B, 0xF9E5, 0xFB64, 0xFA84, 0xFCE3, 0x035A, 0x0581,
    0x08EE, 0x0E43, 0x0CCA, 0x096B, 0x08DD, 0x054D, 0x0202, 0x02CE, 0x0128, 0xFE7A, 0xFF2B, 0xFDF6, 0xFA2F, 0xF8E1, 0xF850, 0xF7CD,
    0xFA8C, 0xFD12, 0xFCD2, 0xFBBB, 0xFC11, 0xFCFA, 0x0047, 0x0853, 0x1233, 0x1D47, 0x276B, 0x2DF5, 0x3248, 0x35C5, 0x3887, 0x3A16,
    0x3C67, 0x3EB2, 0x4137, 0x4373, 0x428B, 0x3FE9, 0x3D56, 0x3856, 0x2F4E, 0x2573, 0x1884, 0x0B6B, 0x007A, 0xF74A, 0xF085, 0xEB2C,
    0xE623, 0xE0E5, 0xDC9B, 0xD6A5, 0xD23E, 0xD0D6, 0xD0E6, 0xD225, 0xD4EB, 0xD6C9, 0xD593, 0xD445, 0xD19F, 0xCD2E, 0xCBE4, 0xCCAE,
    0xCE5E, 0xD1E2, 0xD722, 0xDA95, 0xDDBD, 0xE2B1, 0xE560, 0xEACA, 0xF1C0, 0xF602, 0xF9BC, 0xFC53, 0xF8E8, 0xF285, 0xEF52, 0xE942,
    0xE43B, 0xE649, 0xE8C2, 0xEC71, 0xF376, 0xF7C8, 0xF923, 0xFFC3, 0x0508, 0x0620, 0x0B2B, 0x100C, 0x126D, 0x185D, 0x1CEF, 0x1874,
    0x1742, 0x1462, 0x07FE, 0xFE5F, 0xF6EE, 0xEC7B, 0xE808, 0xE946, 0xE418, 0xE1B0, 0xE529, 0xE1F6, 0xDEF3, 0xE177, 0xE0C7, 0xE0F5,
    0xE8A1, 0xEC81, 0xEEE3, 0xF8B0, 0xFCAB, 0xFCB9, 0xFEDB, 0xFBA5, 0xF578, 0xF337, 0xF0A4, 0xEB16, 0xEC2B, 0xEC95, 0xE877, 0xE835,
    0xE843, 0xE577, 0xE7C0, 0xEC88, 0xEEDE, 0xF0A5, 0xF346, 0xF139, 0xEF68, 0xF143, 0xF061, 0xF459, 0xFD7C, 0x07E3, 0x0E3D, 0x139F,
    0x1865, 0x164D, 0x13B7, 0x12B6, 0x119C, 0x113A, 0x130F, 0x11D9, 0x0D4F, 0x0B54, 0x078B, 0x0212, 0x00FD, 0x0004, 0xFCF1, 0xFE38,
    0xFE98, 0xFACC, 0xF80B, 0xF8F0, 0xF6E8, 0xF3AF, 0xF4AA, 0xF1AC, 0xEE7C, 0xF125, 0xF2D4, 0xF27E, 0xFB14, 0x0161, 0x01B3, 0x0515,
    0x030E, 0xFA9C, 0xF3CB, 0xEE67, 0xE722, 0xE48E, 0xE666, 0xE40F, 0xE18A, 0xE196, 0xDE69, 0xDB50, 0xDD16, 0xDFBF, 0xDEF7, 0xDFC2,
    0xDFB2, 0xD8D2, 0xD355, 0xD255, 0xCFFA, 0xD14B, 0xDC46, 0xE407, 0xE8A1, 0xF540, 0xFD35, 0xFDF7, 0x0743, 0x0FF9, 0x118F, 0x1BC8,
    0x2535, 0x2313, 0x251B, 0x2947, 0x213D, 0x1B4E, 0x1A25, 0x0C86, 0x00E9, 0xFD7E, 0xEFBD, 0xE27B, 0xE2D7, 0xDCC4, 0xD4F0, 0xD926,
    0xD66A, 0xCF4D, 0xD4CF, 0xD7CB, 0xD620, 0xE0D9, 0xE9EF, 0xE989, 0xEE75, 0xF0F5, 0xE8B2, 0xE50A, 0xE579, 0xE015, 0xE139, 0xE7B5,
    0xE69B, 0xE853, 0xECB6, 0xEBAA, 0xED5B, 0xF48E, 0xF879, 0xFD13, 0x049A, 0x0719, 0x0795, 0x08D8, 0x0808, 0x079E, 0x0C00, 0x117D,
    0x16BA, 0x1CE5, 0x22A1, 0x267B, 0x2909, 0x2A71, 0x2ACD, 0x2A23, 0x299F, 0x29F2, 0x2825, 0x2750, 0x28F8, 0x2820, 0x25E0, 0x2488,
    0x1E78, 0x175F, 0x1426, 0x0DE6, 0x07D0, 0x0697, 0x0438, 0xFDA8, 0xFAC7, 0xF511, 0xE9E0, 0xE5FC, 0xE1EB, 0xDA9D, 0xDAB6, 0xDD0C,
    0xD9E1, 0xDACF, 0xDD15, 0xDA43, 0xDA35, 0xDE83, 0xDFE0, 0xE31E, 0xEA76, 0xEE0A, 0xF0B6, 0xF5B9, 0xF74F, 0xF7D7, 0xFD20, 0x01A2,
    0x040B, 0x0870, 0x0E22, 0x0F6D, 0x0FF0, 0x1095, 0x0E44, 0x0B28, 0x0DB6, 0x1036, 0x0F19, 0x1487, 0x1967, 0x18D1, 0x1A77, 0x1E2C,
    0x1B2A, 0x1B65, 0x2129, 0x1DF5, 0x1B8D, 0x1EB9, 0x19E1, 0x131A, 0x11A5, 0x0854, 0xFC91, 0xF904, 0xEFC7, 0xE460, 0xE25E, 0xDE08,
    0xD7A4, 0xD9D0, 0xD931, 0xD3B2, 0xD70A, 0xD92A, 0xD581, 0xDBA1, 0xE3E5, 0xE50C, 0xEDBF, 0xF628, 0xF421, 0xF537, 0xF661, 0xEDDC,
    0xE981, 0xE9A3, 0xE250, 0xDF24, 0xE06F, 0xDA4D, 0xD60E, 0xD895, 0xD75E, 0xD9AC, 0xE342, 0xE860, 0xEBD6, 0xF261, 0xF1D7, 0xECDB,
    0xED95, 0xED20, 0xECF5, 0xF1F6, 0xF7B6, 0xFCE7, 0x04B8, 0x0C75, 0x121E, 0x1829, 0x1F4A, 0x2520, 0x2881, 0x2B69, 0x2DEB, 0x2F53,
    0x3175, 0x34CC, 0x349B, 0x31D3, 0x2FF7, 0x29F8, 0x1FF2, 0x1B3D, 0x1644, 0x0F7E, 0x0E98, 0x0C06, 0x02E1, 0xFDBC, 0xF9C5, 0xEEC5,
    0xEB68, 0xEDB8, 0xEB1D, 0xEDA5, 0xF4EC, 0xF501, 0xF473, 0xF902, 0xF843, 0xF67F, 0xFB95, 0xFC4A, 0xFA1E, 0xFDCC, 0xFD3A, 0xF8CE,
    0xF9B8, 0xFB45, 0xF9A4, 0xFA71, 0xFAF1, 0xF5FD, 0xF116, 0xED03, 0xE560, 0xDEAE, 0xDCD6, 0xDAC3, 0xD9D3, 0xDF03, 0xE79A, 0xF017,
    0xFCCA, 0x0B1B, 0x13BD, 0x1CB4, 0x2694, 0x2AD1, 0x2D45, 0x346D, 0x37BF, 0x398A, 0x4064, 0x4173, 0x3D5E, 0x3D10, 0x38F5, 0x2D8E,
    0x2807, 0x220A, 0x16BF, 0x1130, 0x0AB7, 0xFCAE, 0xF47B, 0xEE7D, 0xE321, 0xDF85, 0xE0BC, 0xDC09, 0xDCA9, 0xE18F, 0xDE0B, 0xDCFB,
    0xE010, 0xDBD4, 0xD869, 0xDA8A, 0xD601, 0xD32D, 0xD6D6, 0xD542, 0xD354, 0xD7C5, 0xD908, 0xD842, 0xDF2C, 0xE250, 0xE406, 0xECD0,
    0xF1C9, 0xF11E, 0xF503, 0xF5FF, 0xF192, 0xF23F, 0xF350, 0xF355, 0xF87A, 0x0050, 0x036D, 0x04EC, 0x06A0, 0x0506, 0x038A, 0x0435,
    0x05FB, 0x09C2, 0x0FBE, 0x1661, 0x1A4C, 0x1A95, 0x1B53, 0x199F, 0x13B6, 0x1059, 0x0B6E, 0x0324, 0xFE0C, 0xF937, 0xF0C3, 0xEC9B,
    0xECEA, 0xE7EB, 0xE554, 0xE6C7, 0xE25A, 0xDFFC, 0xE4D5, 0xE6B2, 0xE94E, 0xF3F5, 0xFA7C, 0xFC4A, 0x02DF, 0x0479, 0x0097, 0x039A,
    0x0798, 0x0667, 0x0975, 0x0D23, 0x0966, 0x0782, 0x0796, 0x0486, 0x047A, 0x07AE, 0x058A, 0x01D9, 0xFFC8, 0xF9F6, 0xF396, 0xF224,
    0xF3DA, 0xF823, 0x0116, 0x0B86, 0x11F8, 0x16D5, 0x1D26, 0x2060, 0x22B7, 0x296C, 0x2DFF, 0x2F21, 0x31CD, 0x2ED4, 0x25E2, 0x1F46,
    0x1936, 0x0ED7, 0x070F, 0x0159, 0xF729, 0xF166, 0xEF5C, 0xEA28, 0xE99E, 0xED6D, 0xED5E, 0xEE3B, 0xF1B3, 0xEE6D, 0xEC63, 0xF01B,
    0xF06D, 0xF361, 0xFD0D, 0x02A3, 0x05F7, 0x0E55, 0x0E9B, 0x0B50, 0x0EE5, 0x0D5A, 0x09EA, 0x0C88, 0x0A66, 0x04DB, 0x041E, 0x000C,
    0xF927, 0xFB1F, 0xFD19, 0xF9E4, 0xFC52, 0xFC7C, 0xF40E, 0xEF2C, 0xEA71, 0xDFE3, 0xDD59, 0xE16D, 0xE2D5, 0xE7C3, 0xEF2A, 0xF208,
    0xF547, 0xFAFC, 0xFCD3, 0xFF98, 0x0601, 0x0BB7, 0x10E6, 0x15B6, 0x191C, 0x19BF, 0x18B1, 0x16C0, 0x13FD, 0x0FE7, 0x0D2E, 0x09ED,
    0x0290, 0xFBD0, 0xF563, 0xEC46, 0xE3FB, 0xDEB8, 0xD703, 0xD03A, 0xCED9, 0xCC67, 0xCB38, 0xD168, 0xD74A, 0xDB3C, 0xE3E5, 0xE88A,
    0xE671, 0xE7DA, 0xE877, 0xE3E5, 0xE4E6, 0xE96C, 0xE977, 0xEC07, 0xF0BD, 0xF0F6, 0xF2D4, 0xF855, 0xFB14, 0xFC7C, 0x010A, 0x027B,
    0x0007, 0xFFC8, 0xFE29, 0xFC0E, 0x0025, 0x0A09, 0x11E0, 0x1AFC, 0x24E9, 0x2AE5, 0x2DB0, 0x321B, 0x34AA, 0x3639, 0x3A58, 0x3DD1,
    0x3BAB, 0x39FC, 0x36C6, 0x2F80, 0x2A56, 0x2334, 0x1FB9, 0x15B4, 0x14BB, 0x0EB4, 0x07E3, 0x06DF, 0xFF5F, 0xFD9D, 0xFBFF, 0xFA92,
    0xF566, 0xF639, 0xF1E1, 0xED86, 0xEEC9, 0xED40, 0xE9AC, 0xEA52, 0xE72E, 0xDF7D, 0xDD3E, 0xD9A3, 0xD56A, 0xD591, 0xD847, 0xD7E5,
    0xDCCA, 0xE115, 0xE1EF, 0xE8A3, 0xF0F2, 0xF4FC, 0xFC29, 0x0322, 0x0202, 0x043F, 0x078B, 0x03A0, 0x04AB, 0x0B27, 0x0DD8, 0x13F5,
    0x1F05, 0x23AE, 0x27CD, 0x2FA0, 0x3126, 0x30B4, 0x33B8, 0x32D2, 0x2E86, 0x2E85, 0x2CF8, 0x28FB, 0x284E, 0x26F2, 0x2115, 0x1ADC,
    0x13C7, 0x094C, 0xFE10, 0xF592, 0xEE22, 0xE5EF, 0xE146, 0xDDE9, 0xD7E5, 0xD2F7, 0xD185, 0xCEDD, 0xCCE9, 0xCFFE, 0xD264, 0xD3A6,
    0xD91A, 0xDD7C, 0xDDDD, 0xE1B8, 0xE777, 0xE868, 0xEB1D, 0xF020, 0xEEAB, 0xED6C, 0xEE0E, 0xEAD5, 0xE809, 0xE983, 0xEA14, 0xE877,
    0xE8E2, 0xE7D6, 0xE5B4, 0xE6C6, 0xE816, 0xE7ED, 0xE9B8, 0xED06, 0xEFE3, 0xF2CA, 0xF6DD, 0xFBE0, 0x01C8, 0x0914, 0x0FC6, 0x14E4,
    0x18BF, 0x1C06, 0x1D1C, 0x1E86, 0x2196, 0x2349, 0x2517, 0x25BD, 0x227E, 0x1DCF, 0x19AF, 0x1395, 0x0F70, 0x0F9D, 0x0EBB, 0x0E1A,
    0x0E78, 0x0C02, 0x07CF, 0x05F5, 0x0441, 0x01B8, 0x0388, 0x03E0, 0x019C, 0x02C4, 0x00E2, 0xFBDD, 0xFAE9, 0xFB1C, 0xF8DA, 0xF9D7,
    0xFB17, 0xF7C6, 0xF64B, 0xF694, 0xF44B, 0xF587, 0xFC60, 0x00D9, 0x0704, 0x0D4B, 0x0DCF, 0x0E66, 0x0E68, 0x0968, 0x0437, 0xFF54,
    0xF67C, 0xEFFF, 0xECFF, 0xE8E0, 0xE8CF, 0xEF42, 0xF3E9, 0xF8B7, 0x02C5, 0x083F, 0x0AEB, 0x134E, 0x18B5, 0x1B3A, 0x2351, 0x28BA,
    0x2872, 0x2A01, 0x2A68, 0x256D, 0x2259, 0x21EC, 0x1E99, 0x1CB4, 0x1DD9, 0x1BA0, 0x172D, 0x1421, 0x0F4A, 0x0865, 0x03D4, 0x006B,
    0xFA1A, 0xF5C8, 0xF578, 0xF39C, 0xF0D7, 0xF21F, 0xF352, 0xF17D, 0xF1D9, 0xF1E7, 0xEDD9, 0xEA70, 0xE895, 0xE2DA, 0xDDA7, 0xDD2B,
    0xDCBE, 0xDD10, 0xE14E, 0xE4B4, 0xE654, 0xE84E, 0xE85E, 0xE640, 0xE384, 0xE285, 0xE2D4, 0xE4F4, 0xEA0E, 0xF104, 0xF8AD, 0x0069,
    0x0890, 0x0F1D, 0x13A2, 0x17B2, 0x1A0F, 0x1974, 0x1800, 0x1654, 0x13F1, 0x1249, 0x10CD, 0x0F90, 0x0D94, 0x0B72, 0x08C5, 0x0538,
    0x01B3, 0xFDA2, 0xFAD5, 0xF71E, 0xF382, 0xF10A, 0xED71, 0xE9FD, 0xE829, 0xE511, 0xE22A, 0xE3D8, 0xE507, 0xE47B, 0xE7A3, 0xEB0C,
    0xEAEB, 0xEE0D, 0xF2D0, 0xF364, 0xF58F, 0xFB32, 0xFCC8, 0xFD6F, 0x028B, 0x0659, 0x0AE7, 0x12C6, 0x1938, 0x1D5A, 0x21FA, 0x23BB,
    0x217B, 0x1D9E, 0x182A, 0x1261, 0x0E57, 0x0A4C, 0x08DE, 0x0BB5, 0x0CED, 0x107C, 0x1697, 0x1902, 0x1C03, 0x22BD, 0x2681, 0x28F5,
    0x3041, 0x3439, 0x3378, 0x360D, 0x3564, 0x2D4B, 0x27D6, 0x22C8, 0x165D, 0x0B69, 0x0373, 0xF642, 0xEA58, 0xE558, 0xDF13, 0xD988,
    0xDBAC, 0xDC69, 0xD8B7, 0xD923, 0xDB48, 0xD913, 0xDB3F, 0xE208, 0xE517, 0xE86F, 0xF000, 0xF399, 0xF44A, 0xF94F, 0xFE4A, 0xFF7B,
    0x03FA, 0x0A11, 0x0986, 0x0CD2, 0x111A, 0x12C9, 0x1331, 0x1688, 0x19DB, 0x1925, 0x162E, 0x1250, 0x0B68, 0x041F, 0x015D, 0xFE7A,
    0x013A, 0x0455, 0x09BE, 0x0D2B, 0x0E56, 0x0F60, 0x0E70, 0x0F42, 0x0F2A, 0x1227, 0x1388, 0x144E, 0x1479, 0x11C4, 0x0EAC, 0x0ADF,
    0x077D, 0x03C9, 0xFFA7, 0xFB8C, 0xF7B2, 0xF3FB, 0xF01A, 0xEE60, 0xEDB1, 0xED4D, 0xED75, 0xEB14, 0xE624, 0xE0FE, 0xDBFC, 0xD6DB,
    0xD4E4, 0xD5D8, 0xD70F, 0xDA4F, 0xDD94, 0xDE21, 0xDF75, 0xE213, 0xE384, 0xE5B4, 0xE849, 0xE927, 0xE9FB, 0xEB9F, 0xECB8, 0xEF4D,
    0xF431, 0xF8C5, 0xFC71, 0xFE26, 0xFBEA, 0xF7D0, 0xF39C, 0xEEE2, 0xED03, 0xF036, 0xF430, 0xFA1D, 0x0451, 0x0AB2, 0x0FC1, 0x1A13,
    0x2255, 0x2956, 0x35E9, 0x3F54, 0x433A, 0x48F4, 0x4C7B, 0x48E7, 0x4704, 0x471F, 0x4050, 0x398F, 0x3542, 0x2A88, 0x1DDB, 0x1739,
    0x0D7A, 0x023C, 0xFFAF, 0xFCD8, 0xF550, 0xF314, 0xF260, 0xECEF, 0xEC75, 0xF0FC, 0xF0D1, 0xF218, 0xF897, 0xF8A4, 0xF4F2, 0xF675,
    0xF485, 0xEDE8, 0xEC14, 0xE85C, 0xDF50, 0xDB49, 0xDA44, 0xD70A, 0xD9DF, 0xE22B, 0xE79F, 0xEDBE, 0xF416, 0xF329, 0xF0B2, 0xEFFC,
    0xED45, 0xEC05, 0xEF0B, 0xF24B, 0xF69D, 0xFF1C, 0x06B1, 0x0DFB, 0x195A, 0x23F8, 0x2BB2, 0x36AF, 0x3E80, 0x41D1, 0x463D, 0x4901,
    0x4810, 0x47A7, 0x47B8, 0x4337, 0x3CD4, 0x36A6, 0x2CD8, 0x228C, 0x1C59, 0x14AF, 0x0C26, 0x0672, 0x0074, 0xF6E9, 0xEDF0, 0xE715,
    0xDEBC, 0xD8A4, 0xD68B, 0xD308, 0xCF6E, 0xCFF3, 0xCF63, 0xCCED, 0xCE7B, 0xD0E4, 0xD14F, 0xD383, 0xD753, 0xD656, 0xD6DD, 0xDBEE,
    0xDEA4, 0xE321, 0xEB9F, 0xF2C3, 0xF6F3, 0xFB69, 0xFAC7, 0xF56F, 0xF0FA, 0xEC26, 0xE64B, 0xE40F, 0xE30E, 0xE2F1, 0xE618, 0xE96B,
    0xEC3C, 0xF2CF, 0xF957, 0xFEF0, 0x07CD, 0x0EB4, 0x13D3, 0x18F8, 0x20ED, 0x214B, 0x23E9, 0x29BC, 0x275E, 0x255A, 0x22EF, 0x1DBE,
    0x1539, 0x145E, 0x0FAC, 0x074B, 0x0838, 0x06E1, 0x007B, 0xFF69, 0x003A, 0xFAB4, 0xFB95, 0x0040, 0x006B, 0x007B, 0x0698, 0x06F6,
    0x02C4, 0x06EF, 0x05F0, 0x025A, 0x05A1, 0x06BA, 0xFFB3, 0xFC7F, 0xFA61, 0xF0FF, 0xEE71, 0xF1D8, 0xF262, 0xF8E3, 0x0242, 0x060E,
    0x0800, 0x0BDC, 0x0BA6, 0x094F, 0x0CD0, 0x0BA4, 0x094E, 0x0AAF, 0x0837, 0x0428, 0x0372, 0x01AE, 0xFE45, 0x005E, 0x016C, 0x0116,
    0x0584, 0x0A33, 0x0BF3, 0x0FE9, 0x1515, 0x15F2, 0x156D, 0x167B, 0x1254, 0x0C61, 0x0AE4, 0x083C, 0x0366, 0x040F, 0x08A5, 0x0713,
    0x086A, 0x0CB1, 0x09B5, 0x083B, 0x0E42, 0x0D0E, 0x0AD7, 0x1181, 0x1175, 0x0D27, 0x0F48, 0x0EF9, 0x096A, 0x0BC6, 0x0E3A, 0x0978,
    0x062E, 0x0484, 0xFD1A, 0xF6B0, 0xF63A, 0xF523, 0xF4E8, 0xFA1F, 0xFD3A, 0xF9DC, 0xF752, 0xF3F4, 0xEBF0, 0xE56B, 0xE3E3, 0xDFE1,
    0xDD3C, 0xDEEA, 0xE02A, 0xDF41, 0xE57A, 0xEB59, 0xF29A, 0xFEBF, 0x04CD, 0x0E04, 0x1966, 0x1ECE, 0x2180, 0x26F3, 0x248B, 0x2096,
    0x1ED8, 0x1564, 0x0C24, 0x079F, 0x00DB, 0xF977, 0xF6AB, 0xF2EC, 0xEBCE, 0xE9FA, 0xE95B, 0xE378, 0xE327, 0xE555, 0xE486, 0xE198,
    0xE4E4, 0xE65A, 0xE196, 0xE660, 0xE8C5, 0xE52A, 0xE967, 0xEF44, 0xE9CE, 0xEAA7, 0xF0CA, 0xEBA2, 0xEA5B, 0xF079, 0xEEDC, 0xEF28,
    0xFAA8, 0x01AF, 0x0552, 0x11D5, 0x1830, 0x16D6, 0x1A0D, 0x1912, 0x13CF, 0x12C3, 0x144A, 0x11C2, 0x13B1, 0x15BF, 0x162F, 0x1740,
    0x1777, 0x1862, 0x1A94, 0x1EAB, 0x241E, 0x28D2, 0x2C65, 0x3179, 0x3372, 0x34B8, 0x3639, 0x366C, 0x361F, 0x3650, 0x3303, 0x2D5A,
    0x2760, 0x1DEB, 0x12D4, 0x0969, 0xFE2E, 0xF3E9, 0xEDFC, 0xE68E, 0xDF43, 0xDC98, 0xDA21, 0xD6E6, 0xD91B, 0xDA8A, 0xD981, 0xDD6D,
    0xDFEA, 0xDDD2, 0xDF12, 0xE0EA, 0xDF8C, 0xE205, 0xE795, 0xEA4B, 0xEEEE, 0xF751, 0xFE15, 0x048C, 0x0FB0, 0x17A9, 0x1C76, 0x21A6,
    0x2281, 0x1DA4, 0x1AAA, 0x1844, 0x13BB, 0x1551, 0x18C7, 0x1954, 0x1BC6, 0x1FF1, 0x1E4B, 0x1E96, 0x22D1, 0x22FF, 0x268F, 0x2ED8,
    0x2EC8, 0x2BB7, 0x2AF2, 0x220D, 0x17FB, 0x151F, 0x0E84, 0x0529, 0x00FA, 0xFA1F, 0xEF0F, 0xE99D, 0xE5FD, 0xDE5C, 0xDCC5, 0xE0D0,
    0xE0FB, 0xE062, 0xE535, 0xE580, 0xE1D8, 0xE501, 0xE655, 0xE107, 0xE22F, 0xE4DC, 0xDD63, 0xDAC9, 0xDF21, 0xDA4F, 0xD716, 0xDE0A,
    0xD9D2, 0xD474, 0xDBA1, 0xDC41, 0xDB08, 0xE716, 0xEFDF, 0xEFFC, 0xF7F7, 0xFC12, 0xF487, 0xF303, 0xF39A, 0xED8D, 0xEDEE, 0xF358,
    0xF405, 0xF6B6, 0xFBD7, 0xFE2B, 0x00B4, 0x0717, 0x10B5, 0x19FC, 0x248D, 0x305E, 0x383F, 0x3C63, 0x406C, 0x41C3, 0x4040, 0x3FFD,
    0x3FF3, 0x3B4C, 0x3644, 0x30F7, 0x27CA, 0x1F5E, 0x184C, 0x0F59, 0x0849, 0x0352, 0xFC72, 0xF619, 0xF172, 0xEE8C, 0xEC7C, 0xEE12,
    0xEE99, 0xF1B1, 0xF4C2, 0xF8C6, 0xFE8D, 0x0199, 0x065F, 0x0803, 0x080A, 0x04EC, 0xFF96, 0xF84D, 0xF368, 0xEFB9, 0xED97, 0xEFF0,
    0xF083, 0xF11B, 0xF212, 0xEF82, 0xED17, 0xEBE3, 0xE8C0, 0xE6E1, 0xE70D, 0xE658, 0xE77C, 0xEB55, 0xECFF, 0xF1E2, 0xF9D5, 0xFFB3,
    0x0921, 0x16B5, 0x2081, 0x2B75, 0x38E8, 0x3D1A, 0x3FAE, 0x44F8, 0x42FC, 0x3F83, 0x4122, 0x3D77, 0x3647, 0x34D1, 0x2EC6, 0x241E,
    0x1E00, 0x1827, 0x0F6C, 0x0944, 0x05EE, 0xFF5E, 0xF914, 0xF73E, 0xF434, 0xEE28, 0xED03, 0xEE5B, 0xE8AD, 0xE601, 0xE83E, 0xE142,
    0xDBB4, 0xDF45, 0xD9CE, 0xD200, 0xD602, 0xD468, 0xCF0C, 0xD7A7, 0xE022, 0xE128, 0xEC63, 0xF707, 0xF443, 0xF4A7, 0xF6BA, 0xEDCE,
    0xE73B, 0xE783, 0xE29E, 0xDEBF, 0xE1FB, 0xE2FD, 0xE10B, 0xE4F8, 0xE9B3, 0xEC1C, 0xF2BA, 0xFBBB, 0x0296, 0x0A18, 0x13B0, 0x1963,
    0x1B99, 0x1EB6, 0x1F46, 0x1C6B, 0x1AC4, 0x18AF, 0x1495, 0x1124, 0x0D30, 0x0763, 0x0116, 0xFBF0, 0xF759, 0xF38A, 0xF191, 0xF25A,
    0xF40A, 0xF5C2, 0xF8E0, 0xFB11, 0xFCB6, 0x0090, 0x0484, 0x0799, 0x0C3C, 0x104E, 0x11B0, 0x1337, 0x120E, 0x0D6D, 0x0AFF, 0x063E,
    0x027B, 0x041D, 0x054C, 0x0611, 0x0AAD, 0x0A7A, 0x064D, 0x061A, 0x03F2, 0xFF9B, 0x0098, 0x0233, 0x0284, 0x076B, 0x0AB5, 0x0C0D,
    0x0F7A, 0x1111, 0x1211, 0x1539, 0x1507, 0x1651, 0x1925, 0x181E, 0x17B5, 0x1B6C, 0x1865, 0x1657, 0x18B8, 0x12BD, 0x0B5D, 0x0AEF,
    0x0491, 0xFBFD, 0xFB03, 0xF5E1, 0xEDA5, 0xEBC4, 0xE9FD, 0xE342, 0xE398, 0xE75B, 0xEA0B, 0xEC11, 0xF583, 0xF80D, 0xF9D1, 0xFC18,
    0x0439, 0x03E3, 0x067C, 0x14FF, 0x114F, 0x13E7, 0x1636, 0x10E6, 0x0578, 0x0A57, 0x0A09, 0x0523, 0x0D1D, 0x1238, 0x0EF1, 0x0CDB,
    0x100F, 0x0638, 0x0131, 0x02CE, 0xFD90, 0xF5A9, 0xF7B1, 0xF431, 0xE85B, 0xE898, 0xE7B3, 0xE365, 0xE659, 0xEE70, 0xF074, 0xF5E7,
    0x036E, 0x090C, 0x0FFB, 0x185A, 0x1EB9, 0x1ACE, 0x1BD6, 0x1810, 0x0D6F, 0x0958, 0x000F, 0xF9B7, 0xF12D, 0xEA7D, 0xE480, 0xDC3B,
    0xD5C5, 0xD337, 0xD0FD, 0xCFF7, 0xD37E, 0xD4FA, 0xD4C6, 0xD7A7, 0xDB44, 0xDAB6, 0xDD0F, 0xE44E, 0xE618, 0xEA33, 0xF16E, 0xF09D,
    0xEFBA, 0xF01B, 0xEBC7, 0xE989, 0xEBCE, 0xED6F, 0xF3FE, 0xFAD0, 0xFF4A, 0x05FE, 0x08DE, 0x0947, 0x0C42, 0x0C17, 0x09BE, 0x0CF9,
    0x0F61, 0x0F00, 0x13FE, 0x1807, 0x16FE, 0x1B64, 0x1FAA, 0x20CD, 0x26D9, 0x2E05, 0x31FE, 0x36AB, 0x3921, 0x3784, 0x362F, 0x321D,
    0x2E0A, 0x2CF3, 0x2A77, 0x2739, 0x2742, 0x2223, 0x1BCC, 0x1B07, 0x162D, 0x0DFD, 0x0AFA, 0x0517, 0xF985, 0xF38E, 0xED88, 0xE38D,
    0xDE3F, 0xDECB, 0xDBAB, 0xD760, 0xDA55, 0xDABE, 0xD6E0, 0xDB2B, 0xDFC7, 0xDC9E, 0xDDA2, 0xE1A7, 0xDB53, 0xD8A4, 0xE03E, 0xE26C,
    0xE573, 0xF362, 0xFCD6, 0xFDE0, 0x0633, 0x0C46, 0x07C1, 0x0896, 0x1035, 0x0E92, 0x0DC6, 0x167E, 0x17D7, 0x133B, 0x1937, 0x1E22,
    0x19C5, 0x1F69, 0x2B20, 0x2B2F, 0x2E66, 0x3A33, 0x37D0, 0x3296, 0x3811, 0x3433, 0x29EB, 0x2CA5, 0x2B0D, 0x1FD1, 0x1D4C, 0x188E,
    0x09E7, 0xFF46, 0xF74C, 0xEA6B, 0xE06A, 0xDCC1, 0xD979, 0xD5FA, 0xD5C0, 0xD87E, 0xD917, 0xD854, 0xDCD9, 0xDF5D, 0xDCE7, 0xE06D,
    0xE441, 0xDF8C, 0xDF57, 0xE1C5, 0xDA28, 0xD4A4, 0xD52A, 0xCFA7, 0xCC58, 0xD2A8, 0xD65F, 0xD8EE, 0xE04A, 0xE53A, 0xE558, 0xE687,
    0xE897, 0xE783, 0xE71C, 0xE9E4, 0xECBE, 0xED9C, 0xF019, 0xF5A1, 0xF64D, 0xF712, 0xFD3B, 0x00F9, 0x0452, 0x0E07, 0x1676, 0x1AA1,
    0x22E1, 0x2971, 0x29AF, 0x2BEB, 0x2E7A, 0x2CFA, 0x2BB4, 0x2C4B, 0x2A3B, 0x26B5, 0x23B4, 0x1EAC, 0x17BD, 0x11E5, 0x0DB1, 0x0992,
    0x07CE, 0x0627, 0x03ED, 0x012F, 0xFCB6, 0xF93F, 0xF725, 0xF50B, 0xF44B, 0xF82E, 0xFB6B, 0xFC58, 0x0205, 0x05D2, 0x037C, 0x0662,
    0x095A, 0x0497, 0x0523, 0x0A99, 0x0624, 0x03E4, 0x0848, 0x0304, 0xFB43, 0xFBC9, 0xF720, 0xEC1C, 0xEACA, 0xEA6E, 0xE3A6, 0xE303,
    0xE7D5, 0xE507, 0xE2AA, 0xE91B, 0xEC0B, 0xEB70, 0xF5B5, 0x0289, 0x0569, 0x0F1B, 0x1E8E, 0x1DF1, 0x1E5A, 0x2A5A, 0x293C, 0x2500,
    0x2EC2, 0x2EE3, 0x2579, 0x2950, 0x298B, 0x1C4E, 0x1A56, 0x1C76, 0x11D5, 0x0E3C, 0x1248, 0x0B98, 0x048F, 0x060F, 0x02DF, 0xFAF7,
    0xF9A3, 0xFB6A, 0xF789, 0xF60D, 0xFC2C, 0xFD13, 0xFABB, 0xFD93, 0xFD4D, 0xF26C, 0xEC5E, 0xEAF3, 0xE181, 0xDF07, 0xE640, 0xE833,
    0xE989, 0xF33C, 0xF72F, 0xF2C9, 0xF4CA, 0xF7EA, 0xF2B1, 0xEF9F, 0xF44E, 0xF2CC, 0xEE4E, 0xEFAB, 0xEDBD, 0xE609, 0xE6F8, 0xEC00,
    0xE9E2, 0xEDA2, 0xF5A1, 0xF6FF, 0xF896, 0xFF8F, 0x00E7, 0xFE75, 0x01AA, 0x029B, 0xFC55, 0xFAB8, 0xFB8F, 0xF67C, 0xF05D, 0xF08A,
    0xF006, 0xEBF7, 0xE9CB, 0xE82E, 0xE0D7, 0xDDFA, 0xDF50, 0xD84B, 0xD7D7, 0xDB9F, 0xDB57, 0xD677, 0xE29D, 0xE68D, 0xE6BA, 0xF582,
    0xF575, 0xF5A9, 0xF84F, 0xF656, 0xF4EE, 0xF878, 0xFA98, 0x009F, 0x086D, 0x0A3E, 0x0BF9, 0x0EBC, 0x0B25, 0x0820, 0x08B4, 0x03E9,
    0xFEAE, 0xFEF0, 0xFE7A, 0xFC47, 0x02BF, 0x08D3, 0x0BD7, 0x13EE, 0x1D8D, 0x2236, 0x260C, 0x2E47, 0x336C, 0x33B5, 0x368C, 0x375B,
    0x2EB7, 0x2659, 0x257B, 0x19E9, 0x0ED2, 0x10B9, 0x084F, 0xFAFF, 0xF8D6, 0xF0ED, 0xE033, 0xDD5F, 0xDD24, 0xD178, 0xD33D, 0xDB8D,
    0xD376, 0xD0A3, 0xD877, 0xD540, 0xD21D, 0xDCF3, 0xE2CC, 0xE26F, 0xED80, 0xF893, 0xF7B3, 0xFB52, 0x01FF, 0xFE19, 0xFB0E, 0x051A,
    0x0A93, 0x0AD5, 0x14C7, 0x1C96, 0x19E7, 0x1AE5, 0x1F67, 0x1A78, 0x133B, 0x1351, 0x1519, 0x1143, 0x131C, 0x15F2, 0x0EEB, 0x0BBB,
    0x0F8B, 0x0AFE, 0x05E1, 0x0C15, 0x0CFA, 0x07EA, 0x0FED, 0x185B, 0x13E1, 0x15FC, 0x1D26, 0x1A16, 0x1704, 0x1962, 0x121F, 0x093D,
    0x09BF, 0x0656, 0xFC5C, 0xF631, 0xF043, 0xE316, 0xD79C, 0xD3CE, 0xCDBC, 0xC659, 0xC6DF, 0xC7C6, 0xC114, 0xC0AF, 0xC65F, 0xC182,
    0xC1BA, 0xCC3E, 0xCD53, 0xCDDB, 0xD85F, 0xD9E9, 0xD524, 0xDAC7, 0xDC1C, 0xD6D0, 0xDD74, 0xE57F, 0xE605, 0xED37, 0xF44B, 0xF21C,
    0xF0F2, 0xF266, 0xEF0B, 0xED9C, 0xF287, 0xF631, 0xF93F, 0xFDD0, 0x009E, 0x03B2, 0x092F, 0x0F12, 0x17DE, 0x228D, 0x2CD1, 0x356B,
    0x3CEB, 0x427E, 0x4601, 0x4896, 0x4B5E, 0x49A0, 0x442C, 0x3E49, 0x342F, 0x2D11, 0x2A45, 0x2298, 0x1B91, 0x1C20, 0x19BA, 0x146A,
    0x14D9, 0x1404, 0x0C7B, 0x0AB4, 0x0B05, 0x035C, 0xFEA2, 0xFD2E, 0xF349, 0xEB4B, 0xEDEF, 0xEAD8, 0xE485, 0xEAF2, 0xEB0A, 0xE12D,
    0xE09A, 0xE299, 0xDD34, 0xDBAE, 0xE4D0, 0xE578, 0xE8A6, 0xF4BD, 0xF2F8, 0xEC17, 0xEF6F, 0xEE53, 0xE81A, 0xEF74, 0xF79F, 0xF500,
    0xF66C, 0xFB7B, 0xFAD4, 0xF90E, 0xFACA, 0xFE66, 0x0263, 0x0BDA, 0x18C4, 0x1FDC, 0x2510, 0x30B1, 0x36FF, 0x35AE, 0x3A5D, 0x3D64,
    0x346A, 0x319E, 0x348D, 0x2C7F, 0x27E7, 0x2B2F, 0x2307, 0x17D3, 0x16AC, 0x0D6B, 0xFE79, 0xF8EB, 0xF34F, 0xE657, 0xDFB9, 0xDE1F,
    0xD6E8, 0xD20C, 0xD3A0, 0xD42A, 0xD26B, 0xD6AC, 0xDCE5, 0xDAEE, 0xDB8F, 0xE0E3, 0xDA62, 0xD232, 0xD560, 0xD351, 0xCBC6, 0xD066,
    0xD5B1, 0xD16E, 0xD65C, 0xDF2F, 0xD99A, 0xD78E, 0xDD0E, 0xD80A, 0xD3D3, 0xDB71, 0xDE26, 0xDC42, 0xE60B, 0xEB85, 0xE738, 0xED7D,
    0xF620, 0xF5C4, 0xFD8A, 0x0D17, 0x12F7, 0x1813, 0x206D, 0x1FB2, 0x1B56, 0x1E25, 0x1EFD, 0x1E31, 0x268B, 0x2853, 0x232D, 0x23CA,
    0x217F, 0x1BD1, 0x1AE7, 0x1C93, 0x1B0C, 0x1BFD, 0x1E00, 0x1D3A, 0x1D36, 0x1C45, 0x188C, 0x15FC, 0x1759, 0x1652, 0x1010, 0x0A72,
    0x070F, 0x0012, 0xFE1D, 0xFFB8, 0xFCD9, 0xFD48, 0x0232, 0x0425, 0x0990, 0x15C3, 0x157D, 0x1359, 0x1A90, 0x18A3, 0x115F, 0x12A6,
    0x0E32, 0x040C, 0x065F, 0x04A0, 0xF9B8, 0xF95D, 0xF912, 0xF044, 0xEF45, 0xF2C5, 0xEF14, 0xF086, 0xF857, 0xFC33, 0x017D, 0x08A5,
    0x0B03, 0x09AF, 0x0866, 0x0742, 0x0533, 0x0336, 0x04D0, 0x061E, 0x054A, 0x0493, 0x071E, 0x02CE, 0xFC09, 0xFE07, 0xFB22, 0xF868,
    0xFD17, 0xFF73, 0xFC42, 0x0058, 0x02CC, 0xFC55, 0xFB61, 0xFFFC, 0xFFC3, 0xFFC1, 0x0741, 0x0878, 0x05BE, 0x068F, 0x05E2, 0xFEED,
    0xFA28, 0xFC20, 0xF997, 0xF76B, 0xFB76, 0xFD1E, 0xF919, 0xF8EB, 0xF8CC, 0xEFD9, 0xEC37, 0xEF42, 0xEAD5, 0xE724, 0xF089, 0xF41F,
    0xEFD5, 0xF819, 0xFD92, 0xF79D, 0xFCB8, 0x0704, 0x056E, 0x0C5E, 0x19D1, 0x15C4, 0x133D, 0x1BAE, 0x170D, 0x0F54, 0x15B3, 0x13A1,
    0x0A9D, 0x0EC6, 0x0F71, 0x06DD, 0x050B, 0x025E, 0xF930, 0xF7E8, 0xFB88, 0xF895, 0xF64C, 0xF8B0, 0xF76B, 0xF412, 0xF3FA, 0xF433,
    0xEF6C, 0xEBEB, 0xEF42, 0xF068, 0xF06F, 0xF53D, 0xF67E, 0xF69A, 0xFE9D, 0x04AA, 0x064F, 0x0C9B, 0x11C3, 0x12A1, 0x18BD, 0x1EAA,
    0x1EE7, 0x23AC, 0x2753, 0x236E, 0x23B4, 0x21C2, 0x17DB, 0x149C, 0x12B5, 0x09B5, 0x0701, 0x05D4, 0xFD9F, 0xFE92, 0x0632, 0x0A66,
    0x1560, 0x25C4, 0x2D23, 0x31DA, 0x3729, 0x333C, 0x2C72, 0x29D5, 0x2440, 0x1EA1, 0x1E52, 0x19E8, 0x126E, 0x0D4A, 0x05DD, 0xFB1D,
    0xF359, 0xED83, 0xE6E0, 0xE2B9, 0xDF59, 0xD9B0, 0xD59E, 0xD254, 0xCF6D, 0xCE8E, 0xCD81, 0xCDE8, 0xD0B0, 0xD393, 0xD5E4, 0xD8BA,
    0xDABA, 0xDC1F, 0xDD63, 0xDDE6, 0xDF71, 0xE401, 0xE973, 0xF033, 0xFA9E, 0x047F, 0x0C83, 0x1243, 0x1345, 0x12D5, 0x1110, 0x0D02,
    0x0C90, 0x10A6, 0x135F, 0x1738, 0x1C44, 0x1C49, 0x1E98, 0x25E0, 0x27A7, 0x2BCB, 0x35BE, 0x3636, 0x36C6, 0x3E2F, 0x3B5E, 0x34F2,
    0x363C, 0x30BC, 0x28C9, 0x2B9C, 0x27BC, 0x1D3D, 0x1D05, 0x18A8, 0x0D35, 0x0D61, 0x0BB4, 0xFE8E, 0xF9E5, 0xF8D9, 0xF024, 0xEDC7,
    0xEE6C, 0xE57E, 0xDE67, 0xDE20, 0xD85B, 0xD12C, 0xD17C, 0xD31F, 0xD30B, 0xD710, 0xDDD2, 0xDE11, 0xDDBA, 0xE392, 0xE4CE, 0xE366,
    0xEA98, 0xF077, 0xEF5B, 0xF56A, 0xFC7A, 0xF8C5, 0xF90F, 0xFD2F, 0xF775, 0xF3E6, 0xF81D, 0xF448, 0xEFB0, 0xF2B3, 0xF0D5, 0xEE4E,
    0xF5E0, 0xFD69, 0x015A, 0x0CD2, 0x1983, 0x2122, 0x2AD1, 0x3489, 0x3955, 0x3C9A, 0x3ED5, 0x3E6E, 0x3CB8, 0x3A97, 0x3867, 0x3603,
    0x2EF8, 0x2595, 0x1F28, 0x13EB, 0x06E8, 0x0198, 0xFC67, 0xF722, 0xFBC7, 0x002F, 0xFC97, 0x002C, 0x0544, 0xFE6F, 0xFB29, 0xFF6B,
    0xFCDA, 0xFBDD, 0x00B3, 0xFD5A, 0xF669, 0xF44D, 0xEE31, 0xE559, 0xE46A, 0xE628, 0xE526, 0xE7D9, 0xEDB4, 0xEEBF, 0xEB6D, 0xE9FB,
    0xE88C, 0xE268, 0xE044, 0xE426, 0xE277, 0xE0FE, 0xE6DA, 0xE72D, 0xE6BB, 0xF168, 0xF6FD, 0xF6E9, 0x030E, 0x0F27, 0x13DE, 0x213C,
    0x2E6E, 0x3135, 0x38FA, 0x4234, 0x428E, 0x44A1, 0x45B4, 0x3ED1, 0x3AE2, 0x3A5C, 0x35F1, 0x331C, 0x30C5, 0x2A70, 0x27C3, 0x2559,
    0x1DE0, 0x1A5B, 0x17CB, 0x1005, 0x0D4E, 0x0BA4, 0x0120, 0xF886, 0xF37A, 0xE993, 0xE43C, 0xE7BA, 0xE867, 0xE8E7, 0xEFA2, 0xF2A5,
    0xEE33, 0xEC9D, 0xEC63, 0xE6F6, 0xE64F, 0xED5D, 0xEFD9, 0xEE74, 0xF0FC, 0xED93, 0xE371, 0xE0DE, 0xDFF2, 0xD83D, 0xD612, 0xD8EF,
    0xD29F, 0xCD25, 0xD12A, 0xD053, 0xCDED, 0xD826, 0xE1DB, 0xE42C, 0xEF68, 0xFBEE, 0xFBF8, 0xFEF0, 0x0686, 0x047B, 0x02EE, 0x08C7,
    0x0827, 0x0345, 0x0604, 0x0603, 0xFFAC, 0xFD6C, 0xFBFC, 0xF665, 0xF1C4, 0xF05E, 0xF002, 0xEF9A, 0xEF2E, 0xF2A2, 0xF482, 0xF2CC,
    0xF6CA, 0xFAC7, 0xF85E, 0xFD7A, 0x0690, 0x038C, 0x0228, 0x08DF, 0x01A5, 0xF71F, 0xF8C2, 0xF2F3, 0xEA4F, 0xF139, 0xF8A8, 0xF7C2,
    0x00D1, 0x0B0A, 0x0ABA, 0x0E8D, 0x15AF, 0x12DA, 0x0E8E, 0x0F89, 0x0FDA, 0x09FB, 0x0A49, 0x109C, 0x0A2C, 0x07A4, 0x0E56, 0x0E3F,
    0x0B3E, 0x14E8, 0x1B95, 0x17C9, 0x2238, 0x2D6F, 0x2680, 0x248B, 0x2863, 0x1D96, 0x1652, 0x1C31, 0x162B, 0x0CA5, 0x1070, 0x0C8B,
    0x00AE, 0xFE16, 0xFB82, 0xF13F, 0xEFE8, 0xF5D0, 0xF513, 0xF581, 0xF929, 0xF867, 0xF31A, 0xF1CC, 0xF4D0, 0xF5D6, 0xF941, 0x01D7,
    0x07F9, 0x0986, 0x0C71, 0x0E8F, 0x0B00, 0x0AA9, 0x1182, 0x13B0, 0x1397, 0x198E, 0x1BC2, 0x1696, 0x1661, 0x17BD, 0x0FE1, 0x08C3,
    0x0685, 0xFB98, 0xEDF4, 0xEA91, 0xE872, 0xE277, 0xE51B, 0xEBC7, 0xE9DD, 0xEBC6, 0xF51C, 0xF8A3, 0xFA16, 0x0634, 0x0F27, 0x0B87,
    0x0CC6, 0x0EF6, 0x03BC, 0xFBC1, 0xFE7F, 0xF911, 0xF1F9, 0xF4FB, 0xF003, 0xE28F, 0xDEC0, 0xD9D5, 0xCF03, 0xCEDB, 0xD328, 0xD0A6,
    0xCFF5, 0xD2CD, 0xD05C, 0xCC91, 0xCC82, 0xCD60, 0xCDC6, 0xCF53, 0xD353, 0xD684, 0xD453, 0xD334, 0xD565, 0xD1C8, 0xD103, 0xDA19,
    0xDEC2, 0xDF2F, 0xEB1F, 0xF46A, 0xF5F4, 0x00EF, 0x0D1F, 0x0ADB, 0x0BFC, 0x14AF, 0x1409, 0x11CC, 0x19A9, 0x1C18, 0x144A, 0x1B6F,
    0x1F79, 0x1661, 0x134F, 0x1A92, 0x1767, 0x159B, 0x26F0, 0x2DCA, 0x2CF2, 0x38C5, 0x4354, 0x3CEA, 0x4087, 0x4A17, 0x4150, 0x3B14,
    0x4326, 0x3CB0, 0x2EF7, 0x31A4, 0x2C4B, 0x19CF, 0x1686, 0x1816, 0x0A17, 0x04AC, 0x0A1D, 0x00C1, 0xF455, 0xF40B, 0xEA28, 0xD9E1,
    0xD9D9, 0xDBC5, 0xD616, 0xD868, 0xDF98, 0xDBE1, 0xD6ED, 0xD947, 0xD683, 0xD0BE, 0xD38A, 0xD89B, 0xD8FC, 0xDC97, 0xE65E, 0xEB75,
    0xEDA4, 0xF53C, 0xFA1C, 0xF7EA, 0xF8E6, 0xFCA5, 0xF7A5, 0xF3EC, 0xFA52, 0xFBBB, 0xF9EB, 0x01C7, 0x08FD, 0x09AA, 0x114F, 0x1D77,
    0x2285, 0x285B, 0x3255, 0x33EC, 0x2FCD, 0x30C9, 0x2E11, 0x2409, 0x1F5C, 0x1E8A, 0x1611, 0x0E8E, 0x0CEF, 0x0515, 0xFB31, 0xF9E2,
    0xF745, 0xEFEF, 0xF0E9, 0xF380, 0xED16, 0xEBE7, 0xED22, 0xE753, 0xE3E2, 0xE463, 0xE315, 0xDE09, 0xDCE7, 0xD901, 0xD058, 0xCCCB,
    0xC9BD, 0xC55A, 0xC29B, 0xC25A, 0xC22F, 0xC4C6, 0xCAD6, 0xD06B, 0xD5AC, 0xDA05, 0xDEC6, 0xE195, 0xE235, 0xE2E7, 0xE1A3, 0xE155,
    0xE2DC, 0xE5F4, 0xE90B, 0xE9FE, 0xEB26, 0xEF0A, 0xF2A5, 0xF714, 0x01D4, 0x0B2F, 0x1303, 0x2032, 0x2A05, 0x2D1B, 0x343A, 0x3A3A,
    0x385D, 0x3B8F, 0x427B, 0x3F95, 0x3E9A, 0x4331, 0x3CDD, 0x33BD, 0x32C8, 0x2AA9, 0x1C47, 0x1B2C, 0x1956, 0x0D37, 0x0C5B, 0x0E5A,
    0x00DE, 0xF9E2, 0x015C, 0xFE22, 0xFA84, 0x0881, 0x0F9D, 0x0A71, 0x1214, 0x1770, 0x0B0B, 0x0829, 0x0BB6, 0xFFDC, 0xFA34, 0x02E2,
    0x016B, 0xFCD9, 0x04EC, 0x07AF, 0xFF6E, 0xFF59, 0xFFA7, 0xF4BC, 0xEC53, 0xEB00, 0xE496, 0xDC4E, 0xDCDE, 0xDDDA, 0xD88F, 0xD95E,
    0xE0D0, 0xE082, 0xE101, 0xEBD0, 0xF153, 0xEFA2, 0xF75A, 0xFFC3, 0xFDE3, 0x0272, 0x0DAA, 0x0D7F, 0x0AF5, 0x1106, 0x0F84, 0x072A,
    0x0949, 0x0BBA, 0x048C, 0x020A, 0x0603, 0x0132, 0xFB9D, 0x00A4, 0x01E5, 0xFE4A, 0x0449, 0x0B1C, 0x06E6, 0x03B9, 0x03D5, 0xFC45,
    0xF548, 0xF7CF, 0xF6C2, 0xEEA5, 0xECB2, 0xEB73, 0xE462, 0xE36E, 0xE941, 0xEC1D, 0xF085, 0xFA49, 0xFF31, 0xFDAE, 0xFD6B, 0xFB8A,
    0xF68A, 0xF577, 0xF627, 0xF451, 0xF1BC, 0xED65, 0xE773, 0xE31E, 0xDF44, 0xDDBF, 0xE22C, 0xE557, 0xE92C, 0xF33F, 0xF942, 0xFACF,
    0x0375, 0x0B1F, 0x0C1C, 0x1184, 0x1807, 0x1309, 0x0EAA, 0x1057, 0x094F, 0x0103, 0x017E, 0xFE83, 0xF5AC, 0xF512, 0xF6A7, 0xF085,
    0xEE49, 0xF2D9, 0xEE96, 0xE76C, 0xEB5E, 0xEBCF, 0xE67E, 0xECA5, 0xF62F, 0xF7AE, 0x0130, 0x0FD7, 0x118E, 0x120A, 0x18C1, 0x14EC,
    0x0C27, 0x0D16, 0x0AE6, 0x0495, 0x070A, 0x09FA, 0x07B9, 0x0973, 0x0AE5, 0x078C, 0x0561, 0x0428, 0x01B5, 0x00C1, 0x003A, 0x0055,
    0x025F, 0x02A7, 0x0304, 0x0632, 0x0803, 0x091F, 0x0F3E, 0x13A7, 0x13F2, 0x16FE, 0x19FB, 0x184B, 0x1736, 0x1799, 0x1396, 0x0EF4,
    0x0C01, 0x05DC, 0xFD6F, 0xF5C6, 0xEEF5, 0xE8C3, 0xE2ED, 0xDF67, 0xDBF8, 0xD5DE, 0xD06C, 0xCF2D, 0xCDCA, 0xCBC5, 0xCEF1, 0xD1F5,
    0xD18F, 0xD610, 0xDCB9, 0xDCA9, 0xDE43, 0xE4AF, 0xE594, 0xE635, 0xEC5C, 0xEE38, 0xEBDE, 0xEF78, 0xF5A8, 0xF9DC, 0x01C0, 0x0D51,
    0x1459, 0x1860, 0x1F07, 0x21C2, 0x1D25, 0x1AFC, 0x1C89, 0x17B4, 0x1260, 0x139A, 0x0FBC, 0x0430, 0x0563, 0x0740, 0x0251, 0x0D33,
    0x15A4, 0x1A32, 0x24F9, 0x2FDC, 0x3412, 0x3131, 0x3A7D, 0x3813, 0x3324, 0x35E7, 0x2ED1, 0x24FD, 0x1F14, 0x175E, 0x0514, 0xFF2D,
    0xFA30, 0xEF4F, 0xE87D, 0xE4FB, 0xDC1A, 0xD127, 0xCF3E, 0xCBCB, 0xC657, 0xC821, 0xCECD, 0xCE97, 0xD3B1, 0xDD0B, 0xDD97, 0xDDAB,
    0xE2E2, 0xE15B, 0xDBE3, 0xDEAD, 0xDF07, 0xDC39, 0xE2AE, 0xEA51, 0xEB6E, 0xF19A, 0xF9E5, 0xFA15, 0xFC24, 0x00B9, 0xFDD6, 0xFAA8,
    0xFD2A, 0xFB6C, 0xFA4E, 0xFFD5, 0x03DA, 0x075E, 0x0E29, 0x13E8, 0x14E0, 0x171A, 0x19C1, 0x1AC0, 0x1BF3, 0x1F03, 0x22DA, 0x2423,
    0x24B5, 0x27A1, 0x27F4, 0x2422, 0x24F6, 0x25AE, 0x2138, 0x2247, 0x25D0, 0x1E44, 0x1767, 0x1619, 0x0DFA, 0x0636, 0x072E, 0x0441,
    0xFB7E, 0xFAA6, 0xF900, 0xF00D, 0xEC74, 0xEBE1, 0xE6C5, 0xE32E, 0xE346, 0xE049, 0xD98F, 0xD485, 0xD1A5, 0xCEBC, 0xCD5D, 0xD2B4,
    0xD85E, 0xD872, 0xDBD7, 0xE24A, 0xE0CB, 0xE10F, 0xEA5D, 0xEC6D, 0xECA4, 0xF55E, 0xF86D, 0xF405, 0xF704, 0xFB05, 0xF8E4, 0xFB89,
    0x027A, 0x0577, 0x086E, 0x1062, 0x181D, 0x1D74, 0x258A, 0x32D4, 0x3B2E, 0x3E1A, 0x468D, 0x4CC2, 0x46DB, 0x44E8, 0x472E, 0x3C96,
    0x33DA, 0x3650, 0x2D0B, 0x1ED5, 0x2037, 0x1ABA, 0x0ADC, 0x095A, 0x0969, 0xFBFA, 0xF79E, 0xFCFF, 0xF6FA, 0xF309, 0xFD80, 0x00DD,
    0xFC2D, 0x027B, 0x066F, 0xFACA, 0xF3FC, 0xF56A, 0xE963, 0xDC93, 0xDF92, 0xDC34, 0xD043, 0xD3ED, 0xDA6A, 0xD2D6, 0xD585, 0xE1E4,
    0xDCFE, 0xD849, 0xE167, 0xDE41, 0xD446, 0xDBC4, 0xE181, 0xDAE1, 0xDF92, 0xE76E, 0xE0AA, 0xDE6D, 0xE871, 0xEA76, 0xEA53, 0xF540,
    0xFE01, 0xFE12, 0x0316, 0x0CE1, 0x0D71, 0x0AA0, 0x1004, 0x1365, 0x0E75, 0x1125, 0x178F, 0x11BA, 0x0E68, 0x1648, 0x14E3, 0x0E64,
    0x12F7, 0x113B, 0x0583, 0x04F3, 0x0562, 0xFA72, 0xF7AC, 0xFB15, 0xF5C9, 0xF50C, 0xFB5D, 0xFB16, 0xFA8D, 0xFF76, 0x00C9, 0x007F,
    0x03DD, 0x06C4, 0x088D, 0x0BA7, 0x0FA9, 0x12C5, 0x13DE, 0x14C8, 0x1779, 0x167A, 0x14A9, 0x16A1, 0x13C3, 0x0E2C, 0x0D43, 0x082C,
    0xFE4A, 0xFBCC, 0xF93D, 0xF232, 0xF3C7, 0xF90E, 0xF813, 0xFBA4, 0x02F5, 0x0423, 0x078D, 0x11CD, 0x1847, 0x18CE, 0x20FA, 0x219D,
    0x1DD1, 0x1E92, 0x19AB, 0x1A5C, 0x18EC, 0x1947, 0x1B1C, 0x17E4, 0x12FA, 0x1066, 0x09FB, 0xFD36, 0xFCDA, 0xFAA1, 0xF264, 0xF5ED,
    0xFAF8, 0xF99D, 0xFF84, 0x0BB9, 0x0E60, 0x0F6F, 0x17D3, 0x16D0, 0x0EA4, 0x0E4B, 0x0B5C, 0x0132, 0xFF30, 0x02EF, 0xFFA0, 0xFE5C,
    0x05C6, 0x07CA, 0x0577, 0x0BD0, 0x10F1, 0x0B4D, 0x0A24, 0x0FA8, 0x0A43, 0x0460, 0x0A0A, 0x0590, 0xF9FC, 0xFCAF, 0xFC0E, 0xEF58,
    0xEE19, 0xF2EB, 0xEA07, 0xE8FD, 0xF368, 0xEE40, 0xE902, 0xF182, 0xF11F, 0xEB27, 0xF297, 0xF7A9, 0xF174, 0xF114, 0xF510, 0xEF50,
    0xE976, 0xEBF1, 0xE9B7, 0xE16A, 0xE059, 0xE37C, 0xDBD2, 0xD5F5, 0xDCA6, 0xDC10, 0xD4CD, 0xDD62, 0xE35E, 0xD92B, 0xDC1B, 0xE5A6,
    0xDD77, 0xDCBF, 0xEBA3, 0xEB6D, 0xE94E, 0xF982, 0x00B7, 0xFCEE, 0x07A1, 0x127C, 0x0F25, 0x126D, 0x1C7D, 0x1A78, 0x158A, 0x18C8,
    0x1950, 0x11FB, 0x1121, 0x16A4, 0x1382, 0x0F8D, 0x1819, 0x1C47, 0x189F, 0x2148, 0x2C1D, 0x2AF2, 0x316C, 0x4057, 0x4204, 0x430A,
    0x4C34, 0x4BE2, 0x45A2, 0x46F3, 0x44E0, 0x3AD1, 0x35C7, 0x3274, 0x2951, 0x2126, 0x1BC8, 0x15D3, 0x0C87, 0x043C, 0xFEAD, 0xF40C,
    0xE808, 0xE250, 0xDE5C, 0xD870, 0xDA76, 0xE05D, 0xDFE0, 0xE1A8, 0xE832, 0xE714, 0xE44D, 0xE92E, 0xE977, 0xE61D, 0xEA3D, 0xEC16,
    0xE7BE, 0xE9D6, 0xEF3E, 0xEFDD, 0xF3EA, 0xFB9C, 0xFD55, 0xFD9D, 0x0202, 0x0487, 0x03B9, 0x06F7, 0x0C0C, 0x0C9B, 0x0D41, 0x1121,
    0x0F7B, 0x098D, 0x0AF1, 0x0D98, 0x0AE5, 0x0F25, 0x16E7, 0x138B, 0x130E, 0x1AE0, 0x1A76, 0x1A55, 0x24B2, 0x2782, 0x2467, 0x29B4,
    0x2A35, 0x20D0, 0x1EA7, 0x1CE6, 0x13E0, 0x0D94, 0x0959, 0x00A0, 0xF480, 0xECD2, 0xE504, 0xDD68, 0xD6A4, 0xD32A, 0xD09F, 0xCA9F,
    0xC9F2, 0xCB52, 0xC91C, 0xC94F, 0xCF3C, 0xCE4E, 0xCD4A, 0xD3EC, 0xD525, 0xD33D, 0xD8DE, 0xDB9B, 0xDA10, 0xE03E, 0xE45F, 0xE4DA,
    0xEB83, 0xF146, 0xF1B0, 0xF540, 0xF6EB, 0xF1D7, 0xF0F4, 0xF1BC, 0xEFC7, 0xF394, 0xFADB, 0xFEC6, 0x0456, 0x0F58, 0x18FC, 0x216F,
    0x2E62, 0x3C3C, 0x42F3, 0x487A, 0x4E42, 0x4CEB, 0x4628, 0x44E4, 0x43EC, 0x3C4C, 0x39BA, 0x3CC3, 0x3600, 0x2EAB, 0x30FB, 0x2C0C,
    0x21FB, 0x2172, 0x20A5, 0x1118, 0x119F, 0x10F7, 0x03DD, 0x0325, 0x0B62, 0x0D5E, 0x0B67, 0x153C, 0x16F2, 0x0FD9, 0x0A03, 0x09E4,
    0x0284, 0xF81E, 0xF95B, 0xFABC, 0xF4FB, 0xF4AA, 0xFAC3, 0xF5AB, 0xEF97, 0xF5E5, 0xF6A4, 0xED06, 0xEF0B, 0xF0F2, 0xE743, 0xE435,
    0xE884, 0xE54C, 0xDFC1, 0xE315, 0xE62A, 0xE36B, 0xE52B, 0xED58, 0xF014, 0xEDBC, 0xF5F1, 0xFF95, 0xFD3D, 0x021D, 0x0E4F, 0x0F70,
    0x10CD, 0x1E68, 0x22E7, 0x1DFF, 0x2637, 0x29B1, 0x230E, 0x23CA, 0x25E8, 0x1ECC, 0x1983, 0x15DA, 0x0D45, 0x06D1, 0x0066, 0xFA7C,
    0xF6A9, 0xF16E, 0xECD2, 0xEE7E, 0xED05, 0xEBD6, 0xF262, 0xF635, 0xF627, 0xFB95, 0xFF1E, 0xFC70, 0xFD27, 0xFED7, 0xFDAB, 0xFD94,
    0xFE11, 0xFCD2, 0xFBB8, 0xF8A1, 0xF5D8, 0xF407, 0xEF2E, 0xE9F8, 0xE94D, 0xE63E, 0xE081, 0xE0E5, 0xE10D, 0xDCE6, 0xDD20, 0xE213,
    0xE419, 0xE6FA, 0xEF7E, 0xF7C8, 0xFC1F, 0x03F1, 0x0E48, 0x11B0, 0x12DE, 0x1973, 0x1C35, 0x17EB, 0x1855, 0x1A5D, 0x14F2, 0x1195,
    0x1589, 0x1364, 0x0E2D, 0x0FCB, 0x0FB8, 0x0957, 0x068E, 0x085A, 0x04FF, 0x0320, 0x072C, 0x0987, 0x084F, 0x098C, 0x0D08, 0x0CA9,
    0x09E8, 0x0964, 0x06CC, 0xFF8F, 0xFAD1, 0xFBAF, 0xFC22, 0xFB9D, 0x023F, 0x0A99, 0x0C51, 0x0F53, 0x15DE, 0x14EF, 0x101B, 0x1396,
    0x1838, 0x15C7, 0x172E, 0x1B2A, 0x1488, 0x0A7F, 0x0892, 0x0575, 0xFB78, 0xFB0D, 0x00B7, 0xFBD0, 0xF8E1, 0xFF79, 0xFE2D, 0xF857,
    0xFEB6, 0x04CE, 0x0143, 0x041D, 0x0A17, 0x04C7, 0xFEA4, 0xFF15, 0xFC21, 0xF66F, 0xF622, 0xF81D, 0xF519, 0xEFEF, 0xF05F, 0xEFF1,
    0xE8C9, 0xE55F, 0xE7DF, 0xE266, 0xDAB1, 0xDCD6, 0xDC29, 0xD652, 0xDB7B, 0xE446, 0xE3E7, 0xE778, 0xF1A8, 0xF3B1, 0xF312, 0xFB38,
    0x016E, 0x0119, 0x05D3, 0x0D47, 0x0E52, 0x0E41, 0x12DB, 0x1463, 0x11C2, 0x12FF, 0x1487, 0x119F, 0x0F35, 0x0F32, 0x0EC9, 0x0D61,
    0x0D06, 0x0F20, 0x1137, 0x115A, 0x1642, 0x1E9A, 0x21D3, 0x25BE, 0x2D29, 0x2E14, 0x299F, 0x29A8, 0x27DE, 0x1EC2, 0x1987, 0x17ED,
    0x10CE, 0x0924, 0x0707, 0x03D6, 0xFD59, 0xFA30, 0xF941, 0xF335, 0xEA0F, 0xE51D, 0xE019, 0xD69F, 0xD27F, 0xD444, 0xD2BD, 0xD2D6,
    0xDA87, 0xDFCC, 0xDE57, 0xE043, 0xE214, 0xDC9D, 0xD83A, 0xD91D, 0xD8B2, 0xD5EC, 0xDA0A, 0xE362, 0xE7E5, 0xEE24, 0xFA65, 0x01CD,
    0x037C, 0x0A91, 0x1289, 0x1261, 0x13AB, 0x1A56, 0x1A58, 0x14E2, 0x158A, 0x12A4, 0x0811, 0x035B, 0x053E, 0x02DE, 0x0272, 0x0B40,
    0x1028, 0x10DB, 0x16DD, 0x1CC8, 0x1E9A, 0x238F, 0x2A38, 0x2EB2, 0x31E5, 0x335E, 0x32FD, 0x3034, 0x2ACC, 0x2541, 0x239C, 0x1E15,
    0x1605, 0x136F, 0x0D9F, 0x0152, 0xFA72, 0xF646, 0xEA18, 0xE183, 0xE13C, 0xDC39, 0xD50D, 0xD63A, 0xD6C7, 0xD03D, 0xCEA5, 0xD212,
    0xCEE4, 0xCA85, 0xCE8B, 0xD11D, 0xCE8E, 0xD3B6, 0xDD98, 0xDFE2, 0xE21F, 0xEB07, 0xEFC7, 0xEDD1, 0xF0F7, 0xF848, 0xF76F, 0xF5A2,
    0xFD73, 0x00EB, 0xFA56, 0xFD07, 0x0620, 0x0361, 0x04FB, 0x1658, 0x1D95, 0x1E19, 0x2EA5, 0x3B43, 0x37D8, 0x3D9D, 0x47AC, 0x4134,
    0x3C25, 0x42F3, 0x4042, 0x370E, 0x39A6, 0x3C4B, 0x3475, 0x302C, 0x3294, 0x2C95, 0x22BE, 0x22E1, 0x21DB, 0x16C7, 0x0FE6, 0x0EBB,
    0x04D1, 0xFAB1, 0xFB1B, 0xF8D8, 0xF0B6, 0xEF3E, 0xEE96, 0xE581, 0xDCA8, 0xD784, 0xD05B, 0xC951, 0xC920, 0xCC60, 0xCD91, 0xCF05,
    0xD2DB, 0xD4C9, 0xD37D, 0xD471, 0xD7C0, 0xD95E, 0xDB58, 0xE167, 0xE685, 0xE7B3, 0xE85F, 0xE949, 0xE61E, 0xE192, 0xE0A6, 0xE06B,
    0xDE4A, 0xDF45, 0xE422, 0xE89D, 0xEDA6, 0xF632, 0x00D3, 0x0900, 0x1092, 0x1B5F, 0x2453, 0x26C1, 0x2B14, 0x31B0, 0x2F3B, 0x2958,
    0x2AFF, 0x2653, 0x1990, 0x183B, 0x1954, 0x0F5C, 0x0BF7, 0x1080, 0x07DA, 0xFCF9, 0xFE9F, 0xFB96, 0xF219, 0xF586, 0xFD12, 0xFA50,
    0xFBF9, 0x0463, 0x02CF, 0xFD35, 0x0043, 0x0299, 0xFE2B, 0xFF40, 0x04C4, 0x033F, 0xFFE2, 0x0165, 0x01D4, 0xFDDF, 0xFD29, 0x0100,
    0x00AB, 0xFCD1, 0xFE67, 0xFF5F, 0xF74E, 0xF13E, 0xF151, 0xEA92, 0xE20C, 0xE579, 0xE879, 0xE748, 0xF0DB, 0xFF00, 0x04A1, 0x0B82,
    0x1738, 0x1B64, 0x1AB6, 0x1EA3, 0x2298, 0x2228, 0x23E6, 0x27FF, 0x280E, 0x24CA, 0x2282, 0x2188, 0x1EBB, 0x1B31, 0x1B58, 0x1A96,
    0x14C4, 0x0FA1, 0x0EA4, 0x0B43, 0x046F, 0x04A3, 0x074C, 0x0298, 0x0160, 0x0707, 0x02D0, 0xFA26, 0xFBB4, 0xFA94, 0xF162, 0xF20E,
    0xF8EF, 0xF647, 0xF6E4, 0x026F, 0x07AD, 0x0565, 0x0B82, 0x1244, 0x0CEB, 0x0A6B, 0x11F1, 0x101A, 0x0637, 0x071A, 0x049F, 0xF33B,
    0xE9A9, 0xE8B3, 0xDBB1, 0xD1EE, 0xD768, 0xD796, 0xD312, 0xD958, 0xDF79, 0xDCCD, 0xDE87, 0xE647, 0xEA5B, 0xEB4A, 0xF1EF, 0xFA61,
    0xFB43, 0xFA48, 0xFF25, 0xFEDB, 0xF5D8, 0xF5C8, 0xF834, 0xEEED, 0xEAC7, 0xEF7A, 0xE96A, 0xE27D, 0xE641, 0xE49A, 0xDD94, 0xE02B,
    0xE4CB, 0xE47A, 0xEA18, 0xF2FC, 0xF6CD, 0xF95E, 0xFBF4, 0xFB03, 0xF8CA, 0xF66E, 0xF534, 0xF74C, 0xF9EB, 0xFB5B, 0xFF5F, 0x0373,
    0x0250, 0x036F, 0x099E, 0x0BAC, 0x0CF9, 0x1533, 0x1AB7, 0x189D, 0x19F8, 0x1C49, 0x15C2, 0x118C, 0x1716, 0x18FB, 0x186C, 0x21CA,
    0x2B4A, 0x2C49, 0x30C8, 0x3805, 0x3639, 0x3259, 0x3587, 0x36A7, 0x337C, 0x345F, 0x360D, 0x30C2, 0x28E8, 0x2424, 0x1E07, 0x1255,
    0x0851, 0x04AF, 0xFCED, 0xF1E1, 0xEF9A, 0xEE15, 0xE357, 0xE045, 0xE6B4, 0xE2F8, 0xE02E, 0xE9CB, 0xEA2A, 0xE198, 0xE457, 0xE5BF,
    0xDD96, 0xDD75, 0xE2D8, 0xE0AA, 0xDFDD, 0xE6E5, 0xEC95, 0xEE56, 0xF402, 0xFE26, 0x02D6, 0x0343, 0x097D, 0x0E95, 0x0A47, 0x0B60,
    0x11D3, 0x0D8F, 0x091A, 0x0BC6, 0x0628, 0xFCB3, 0xFB55, 0xF93E, 0xF695, 0xFABA, 0x013C, 0x082D, 0x0FA7, 0x146A, 0x1BA6, 0x23E5,
    0x25BE, 0x2CA3, 0x369E, 0x3414, 0x30D4, 0x32E0, 0x27A2, 0x1766, 0x12AB, 0x08F5, 0xF973, 0xF5DC, 0xF3DA, 0xE88E, 0xE11B, 0xDD36,
    0xD31F, 0xC8DF, 0xC3AE, 0xC116, 0xBE09, 0xBC51, 0xC04F, 0xC3EC, 0xC230, 0xC401, 0xC904, 0xC62A, 0xC39C, 0xC9E2, 0xCAC5, 0xC6E7,
    0xCC64, 0xD2D7, 0xD16E, 0xD518, 0xDFCB, 0xE35F, 0xE5CE, 0xF2A5, 0xFE1B, 0x019F, 0x0A32, 0x1599, 0x15A2, 0x131B, 0x185B, 0x17F8,
    0x1177, 0x15EF, 0x1E89, 0x1F22, 0x24CD, 0x2F07, 0x2EC6, 0x2D3A, 0x3299, 0x34C0, 0x3578, 0x3BE3, 0x40A8, 0x422F, 0x44C5, 0x4486,
    0x439A, 0x4306, 0x3E07, 0x3B7D, 0x3BB2, 0x341C, 0x2CDF, 0x2BAF, 0x2298, 0x1852, 0x187B, 0x13CC, 0x098C, 0x08BC, 0x0611, 0xFC85,
    0xF946, 0xF7C8, 0xF1B1, 0xECB2, 0xE8EA, 0xE331, 0xDCD3, 0xD600, 0xD376, 0xD4A8, 0xD2C7, 0xD595, 0xDD53, 0xDD17, 0xDD0F, 0xE471,
    0xE5CB, 0xE4D7, 0xECCB, 0xF153, 0xEF92, 0xF215, 0xF2AD, 0xEDF6, 0xEA00, 0xE69D, 0xE4FC, 0xE4B0, 0xE3F8, 0xEA37, 0xF2E7, 0xF43D,
    0xFC94, 0x0B78, 0x0E22, 0x133F, 0x237F, 0x2727, 0x25FB, 0x3101, 0x3315, 0x2985, 0x293F, 0x285E, 0x1D21, 0x18CC, 0x1BAE, 0x1779,
    0x1221, 0x12BF, 0x1018, 0x0748, 0x0011, 0xFD00, 0xF965, 0xF5AB, 0xF9ED, 0x0103, 0x0040, 0xFFD6, 0x0272, 0xFC27, 0xF252, 0xEF0F,
    0xEA9A, 0xE21B, 0xDE90, 0xDE70, 0xD979, 0xD4C4, 0xD549, 0xD567, 0xD2D4, 0xD409, 0xD945, 0xD926, 0xD78A, 0xDB1F, 0xDC63, 0xD8B0,
    0xDA0D, 0xDD3F, 0xDAC2, 0xDB58, 0xE148, 0xE373, 0xE557, 0xEB84, 0xF01D, 0xF3CE, 0xF8CB, 0xFD41, 0x0380, 0x0994, 0x0DD9, 0x17EA,
    0x2279, 0x267E, 0x2F24, 0x392D, 0x3722, 0x3601, 0x3B62, 0x34D6, 0x2BEA, 0x2E4C, 0x29FB, 0x1EAE, 0x1ECF, 0x1CFD, 0x10FB, 0x0C6E,
    0x0C0C, 0x0521, 0x0185, 0x038C, 0x026D, 0x00A1, 0xFFBC, 0xFFCF, 0xFE3B, 0xF991, 0xF92D, 0xFBEB, 0xFA91, 0xFC83, 0x049E, 0x066D,
    0x05F8, 0x0B33, 0x0BE5, 0x08AA, 0x0B45, 0x0D02, 0x0CC1, 0x0E5E, 0x0E93, 0x0CE5, 0x0814, 0xFEB1, 0xF930, 0xF467, 0xE8D3, 0xE540,
    0xE6BC, 0xE00A, 0xDEB5, 0xE697, 0xE652, 0xE6AA, 0xF2ED, 0xF959, 0xFA2E, 0x033A, 0x09C4, 0x06DF, 0x0781, 0x09CD, 0x05F5, 0x021D,
    0x00C5, 0xFE1A, 0xFA64, 0xF807, 0xF79A, 0xF65D, 0xF1FC, 0xEEC9, 0xED3A, 0xE8BF, 0xE628, 0xE910, 0xEC09, 0xEE08, 0xF258, 0xF737,
    0xF6D3, 0xF2CB, 0xF1DB, 0xF00A, 0xE99F, 0xE897, 0xED34, 0xEC27, 0xEBF2, 0xF41D, 0xF68B, 0xF36C, 0xFA79, 0x01C6, 0x0238, 0x0AA6,
    0x1659, 0x1804, 0x1925, 0x1DDC, 0x1B22, 0x1604, 0x15A0, 0x1417, 0x1039, 0x0E74, 0x0DCD, 0x0CE7, 0x0AC6, 0x0866, 0x09ED, 0x0A20,
    0x0774, 0x0A14, 0x0D65, 0x0989, 0x08F5, 0x0C69, 0x084C, 0x04BD, 0x0741, 0x031B, 0xFB5F, 0xF985, 0xF52C, 0xED5F, 0xEACF, 0xE8FA,
    0xE3D1, 0xE0D7, 0xDE38, 0xD9E6, 0xD66F, 0xD3AE, 0xD3B5, 0xD6CD, 0xD9A4, 0xDE7E, 0xE544, 0xE74E, 0xE8E4, 0xED29, 0xEE82, 0xF000,
    0xF5CD, 0xFA8D, 0xFD69, 0x014A, 0x0393, 0x03D6, 0x0452, 0x0591, 0x0878, 0x0B65, 0x0CFE, 0x107F, 0x11C3, 0x0E4D, 0x0D33, 0x0C2A,
    0x05D8, 0x0385, 0x04A8, 0x0260, 0x0454, 0x0B49, 0x0F3B, 0x140A, 0x1CF7, 0x21CF, 0x25D8, 0x2B5C, 0x2DF3, 0x2EF6, 0x31C2, 0x30E4,
    0x2EB8, 0x2AE9, 0x2526, 0x20C0, 0x1921, 0x136A, 0x0CB1, 0x0479, 0xFB7A, 0xF232, 0xE7DD, 0xDD0F, 0xD686, 0xD0EC, 0xCE0D, 0xCFA5,
    0xCFA7, 0xD009, 0xD351, 0xD362, 0xD26A, 0xD60C, 0xD5B6, 0xD16B, 0xD35E, 0xD169, 0xCD6E, 0xD1BB, 0xD5A9, 0xD686, 0xDE02, 0xE616,
    0xE7AC, 0xEE9F, 0xF5B8, 0xF7B2, 0xFED8, 0x06DE, 0x0A4A, 0x0EFB, 0x11CB, 0x0E86, 0x0D0B, 0x0DD9, 0x0C07, 0x10D0, 0x181D, 0x1A88,
    0x1F6A, 0x24CC, 0x249D, 0x2777, 0x2F08, 0x3364, 0x3A75, 0x44AE, 0x4A44, 0x4C5E, 0x4E1B, 0x4C56, 0x47FF, 0x436F, 0x3E64, 0x3821,
    0x30DD, 0x280B, 0x206A, 0x15EC, 0x0AE2, 0x030A, 0xFAD8, 0xEFB4, 0xE907, 0xE2E5, 0xDB30, 0xD795, 0xD3E3, 0xCF9A, 0xCB8D, 0xCC3B,
    0xC4B6, 0xD071, 0xDE2B, 0xD937, 0xD8B7, 0xD8AE, 0xDA9B, 0xDB7C, 0xDECC, 0xDDAE, 0xDE53, 0xDDDB, 0xDC67, 0xE0B0, 0xDF72, 0xE4FB,
    0xEA11, 0xE89C, 0xEE7F, 0xF8AB, 0xFB79, 0xF6CE, 0xFBFC, 0xFF5E, 0xFEC0, 0x040E, 0x0C1F, 0x0E0B, 0x1109, 0x18A7, 0x1757, 0x19F5,
    0x1DFA, 0x1FBD, 0x22D2, 0x2468, 0x29E4, 0x26E5, 0x2164, 0x247D, 0x208A, 0x1441, 0x0D95, 0x0FDD, 0x0B7C, 0x09F4, 0x0AB9, 0x0718,
    0x0645, 0x0CB9, 0x0FBE, 0x0BCD, 0x1331, 0x14C9, 0x111C, 0x17CB, 0x1BA8, 0x1466, 0x1280, 0x0FE6, 0x0524, 0x0432, 0x0117, 0xF88C,
    0xF884, 0xF811, 0xF417, 0xF50F, 0xF673, 0xF495, 0xF617, 0xF930, 0xF944, 0xFBFB, 0xFD72, 0xFB5A, 0xFDFD, 0xFF9E, 0xFD46, 0xFD21,
    0x005D, 0xFEF1, 0xFD44, 0xFFB1, 0x004E, 0xFEC8, 0xFE54, 0x02A9, 0x045D, 0x071B, 0x0FCF, 0x160B, 0x16D9, 0x1A53, 0x1F91, 0x1BDC,
    0x178E, 0x175B, 0x123A, 0x0B30, 0x0B62, 0x0CAE, 0x0B4B, 0x0C37, 0x0D29, 0x0E4B, 0x0EC7, 0x0F83, 0x12E9, 0x1465, 0x13EB, 0x1851,
    0x1D5A, 0x1BDE, 0x1E25, 0x23E7, 0x22A1, 0x21AE, 0x2555, 0x240B, 0x1E69, 0x1D88, 0x1CF5, 0x1A03, 0x18F1, 0x1812, 0x14D7, 0x0E24,
    0x0881, 0x051D, 0xFEB6, 0xF665, 0xF443, 0xF202, 0xE8B8, 0xE487, 0xE2A3, 0xD93C, 0xD44C, 0xD8AC, 0xD79A, 0xD594, 0xDBBD, 0xDC59,
    0xD725, 0xD7E6, 0xD871, 0xD3F6, 0xD2A4, 0xD4D5, 0xD542, 0xD4B9, 0xD71B, 0xDCC2, 0xDFA0, 0xE194, 0xEAD8, 0xF237, 0xF279, 0xF9D2,
    0x0280, 0x00C8, 0x03A7, 0x0CFA, 0x0B12, 0x08C9, 0x0EF8, 0x0DA2, 0x0970, 0x0E9D, 0x1154, 0x0F8A, 0x1302, 0x1465, 0x11A7, 0x10CB,
    0x0FD4, 0x0F4C, 0x11B4, 0x151A, 0x19C9, 0x1FAE, 0x2292, 0x242F, 0x279A, 0x281A, 0x2705, 0x2835, 0x284E, 0x269C, 0x26B0, 0x2807,
    0x28B6, 0x2820, 0x2886, 0x29ED, 0x2608, 0x2096, 0x1E86, 0x175A, 0x0D32, 0x0980, 0x04EC, 0xFC99, 0xFA88, 0xFA6F, 0xF54B, 0xF4D8,
    0xF84B, 0xF75D, 0xF68C, 0xF7C1, 0xF5EC, 0xF273, 0xF012, 0xEEAB, 0xEEF9, 0xEF11, 0xEFD1, 0xF347, 0xF2A8, 0xEEEC, 0xEF87, 0xEED8,
    0xEB3C, 0xEE47, 0xF3FA, 0xF3FC, 0xF6EF, 0xFD6E, 0xFDCD, 0xFCE0, 0xFF9D, 0x0115, 0x0069, 0x02B5, 0x068D, 0x07D0, 0x0711, 0x082C,
    0x09E7, 0x0758, 0x0648, 0x0B1F, 0x0BD7, 0x0A50, 0x1050, 0x152A, 0x12F8, 0x1681, 0x1CFB, 0x1A46, 0x189C, 0x1CB9, 0x18FD, 0x11D8,
    0x11E6, 0x0FEE, 0x0995, 0x07E7, 0x07DD, 0x027C, 0xFBD4, 0xF6DA, 0xF0C1, 0xE796, 0xE15B, 0xE022, 0xDCEF, 0xD743, 0xD6B5, 0xD3F1,
    0xCC5C, 0xCAD6, 0xCBCE, 0xC9DC, 0xC9E4, 0xCEC6, 0xCE24, 0xC875, 0xCB52, 0xCB08, 0xC5C7, 0xC971, 0xC597, 0xC6ED, 0xCD05, 0xCA29,
    0xCE72, 0xD368, 0xD224, 0xD4B1, 0xDB81, 0xDE0A, 0xE5CE, 0xF14B, 0xF7BB, 0xFF40, 0x079F, 0x07DF, 0x095B, 0x0B4B, 0x0A8F, 0x0DD1,
    0x1018, 0x12F5, 0x16B6, 0x1797, 0x1766, 0x1CB6, 0x1BD9, 0x18F5, 0x1F79, 0x1D15, 0x1630, 0x1A09, 0x1AAF, 0x1311, 0x17A2, 0x1F4C,
    0x1A1C, 0x1CBE, 0x23AD, 0x1EDE, 0x1C49, 0x1FA5, 0x1CB0, 0x1837, 0x1753, 0x150A, 0x131F, 0x100A, 0x0D7D, 0x0F6D, 0x0C40, 0x0453,
    0x041B, 0xFF54, 0xF12F, 0xEC88, 0xEB48, 0xE15E, 0xDD99, 0xE1DB, 0xDF0C, 0xDC18, 0xDF14, 0xE048, 0xDE9D, 0xDE4F, 0xE0E2, 0xE39F,
    0xE164, 0xE14E, 0xE784, 0xE555, 0xE049, 0xE5C4, 0xE766, 0xE0FD, 0xE5BF, 0xED14, 0xE9D0, 0xECAA, 0xF52E, 0xF436, 0xF1FB, 0xF4A1,
    0xF383, 0xF03B, 0xEF8A, 0xEF8E, 0xF03B, 0xEFA2, 0xEEA1, 0xF16F, 0xF10F, 0xEB04, 0xEB31, 0xEC60, 0xE711, 0xE881, 0xEF5C, 0xF0CC,
    0xF4C6, 0xFCBC, 0x0164, 0x03EE, 0x07BD, 0x0AE2, 0x0C1A, 0x0BA8, 0x0B3C, 0x0D5D, 0x0B68, 0x065B, 0x066F, 0x038B, 0xFB2A, 0xFA68,
    0xFA5B, 0xF287, 0xEF44, 0xEDB4, 0xE48D, 0xDCBD, 0xD8EC, 0xD26A, 0xCE6F, 0xCEDF, 0xCF0A, 0xD0AB, 0xD2A5, 0xD329, 0xD469, 0xD3BB,
    0xD288, 0xD498, 0xD334, 0xD1A6, 0xD54A, 0xD520, 0xD47C, 0xDBE2, 0xDE68, 0xDE4B, 0xE767, 0xEA98, 0xE76F, 0xEE33, 0xF42B, 0xF221,
    0xF946, 0x033E, 0x02E4, 0x0665, 0x0D8B, 0x0C34, 0x0B9D, 0x0F17, 0x0EF0, 0x0E57, 0x0CEB, 0x09ED, 0x0984, 0x0615, 0x01F2, 0x05FB,
    0x0857, 0x04D3, 0x0991, 0x0E96, 0x0866, 0x0838, 0x0EBB, 0x0CD0, 0x0B80, 0x11E1, 0x1424, 0x1151, 0x1197, 0x148A, 0x1453, 0x105D,
    0x1306, 0x1864, 0x13D2, 0x10C9, 0x16BE, 0x1245, 0x084F, 0x0C3C, 0x0C00, 0x0068, 0xFDCF, 0xFE4A, 0xF481, 0xEF22, 0xF124, 0xEF18,
    0xEC14, 0xEC30, 0xEBFF, 0xE994, 0xE519, 0xE2EF, 0xE54A, 0xE3B8, 0xE185, 0xE71B, 0xE814, 0xE0CC, 0xDFA5, 0xDFEA, 0xD92C, 0xD6F4,
    0xDBDF, 0xDCF8, 0xDC58, 0xDFF2, 0xE470, 0xE44D, 0xE432, 0xE7CC, 0xEB14, 0xE8E1, 0xE779, 0xEF66, 0xEB3F, 0xE873, 0xED3B, 0xEBE4,
    0xE9A4, 0xEB97, 0xEFD8, 0xEBD8, 0xEFFB, 0xF44C, 0xF527, 0xFA4A, 0x0038, 0x039B, 0x0884, 0x0EA0, 0x125B, 0x18D0, 0x1D7E, 0x20D2,
    0x247D, 0x2574, 0x23F8, 0x25CF, 0x21B6, 0x1E3B, 0x206A, 0x1D00, 0x184C, 0x1C47, 0x1A81, 0x1205, 0x12BB, 0x0FD5, 0x045F, 0xFF8E,
    0xFD0F, 0xF3A5, 0xEF4E, 0xEFB5, 0xED7E, 0xEDD9, 0xEF48, 0xEF22, 0xF0D6, 0xEDA0, 0xE87A, 0xE948, 0xE577, 0xDD18, 0xDDB1, 0xDCB1,
    0xD496, 0xD402, 0xD7E4, 0xD5D6, 0xD6F2, 0xDEA2, 0xE23B, 0xE3D8, 0xE866, 0xEE1B, 0xF002, 0xF0A8, 0xF5A6, 0xFAC2, 0xFAF7, 0xFF0C,
    0x06D8, 0x06E9, 0x0799, 0x0E4A, 0x0EAD, 0x0CD7, 0x1239, 0x139A, 0x119F, 0x15EC, 0x1844, 0x16F3, 0x19CD, 0x1CA5, 0x1D37, 0x20F6,
    0x23F8, 0x2506, 0x2749, 0x263E, 0x248A, 0x2593, 0x223D, 0x1EAC, 0x215A, 0x2008, 0x1C68, 0x2012, 0x20C9, 0x1A54, 0x1901, 0x193F,
    0x11DF, 0x0AEB, 0x0941, 0x04A1, 0xFC41, 0xF857, 0xF83D, 0xF342, 0xEC46, 0xEE02, 0xEF0D, 0xE87C, 0xE8D5, 0xEE4F, 0xE966, 0xE555,
    0xEA27, 0xE7E1, 0xE1AA, 0xE41D, 0xE4A2, 0xDFE0, 0xE065, 0xE16C, 0xDF58, 0xDFE6, 0xE159, 0xE35F, 0xE8AB, 0xEBE7, 0xEEA6, 0xF55F,
    0xF8C8, 0xFAB3, 0x01AB, 0x0568, 0x0675, 0x0B42, 0x0CCC, 0x0BB4, 0x0DD3, 0x0D86, 0x0BE4, 0x1056, 0x1272, 0x1369, 0x1B29, 0x20FE,
    0x22EF, 0x2955, 0x2EE0, 0x2F20, 0x312D, 0x336B, 0x33E4, 0x361A, 0x37E2, 0x39AD, 0x3CAA, 0x3AD3, 0x37DA, 0x38DA, 0x34CA, 0x2E0C,
    0x2D87, 0x2B39, 0x22DD, 0x1D66, 0x197B, 0x1016, 0x0628, 0x00E4, 0xFCB4, 0xF4CE, 0xEEA2, 0xEE09, 0xEAD3, 0xE2EC, 0xE213, 0xE321,
    0xDCA0, 0xDA8C, 0xDDF4, 0xDB23, 0xD8A4, 0xDBD9, 0xDAF8, 0xD88C, 0xD943, 0xD89A, 0xD8EA, 0xDB8E, 0xDD47, 0xE31F, 0xEA44, 0xEC6D,
    0xF1EC, 0xFA3F, 0xFC2B, 0x00DF, 0x0A92, 0x0CFE, 0x0E47, 0x1487, 0x1440, 0x11AC, 0x14FD, 0x1667, 0x1556, 0x18B8, 0x1A67, 0x1711,
    0x146B, 0x1401, 0x12DE, 0x10F7, 0x1332, 0x191F, 0x1A17, 0x18EB, 0x1D7B, 0x1CE1, 0x165B, 0x18EF, 0x1E2F, 0x1989, 0x1B6C, 0x213B,
    0x1CD5, 0x1734, 0x1A5D, 0x1884, 0x148D, 0x16BC, 0x186C, 0x164D, 0x1450, 0x0F6B, 0x0998, 0x069F, 0x0110, 0xFF03, 0xFAA1, 0xF6A2,
    0xF84F, 0xFA85, 0xEDEB, 0xED62, 0xF8B5, 0xFAD9, 0xF631, 0xFB17, 0x00CB, 0x01CB, 0x00C4, 0xFDCB, 0xF96C, 0xF958, 0x023A, 0xFC9B,
    0xFC84, 0x0254, 0x068F, 0x0642, 0x09D5, 0x0E30, 0x0BAB, 0x098A, 0x10E0, 0x1289, 0x0C8B, 0x0C1A, 0x158A, 0x194C, 0x1811, 0x18A8,
    0x18B5, 0x11F0, 0x0F18, 0x1447, 0x0A3D, 0x0559, 0x0663, 0x0F55, 0x0C47, 0x0ADF, 0x11D7, 0x186C, 0x1BAE, 0x20BA, 0x2491, 0x1EB2,
    0x221C, 0x2A74, 0x2408, 0x1CE8, 0x22EE, 0x230D, 0x1F42, 0x1A76, 0x1B45, 0x209B, 0x1A1C, 0x1186, 0x1729, 0x122D, 0x0747, 0x0154,
    0xFF9D, 0xFA08, 0xF69F, 0xF934, 0xF6B4, 0xEE29, 0xF4C7, 0xF58B, 0xEB1F, 0xECBF, 0xEB0D, 0xEC83, 0xE5F7, 0xE5C4, 0xE287, 0xDE84,
    0xDC78, 0xD791, 0xDB2B, 0xD5A6, 0xD2F9, 0xD867, 0xD9C8, 0xD6D4, 0xDE01, 0xE44A, 0xE58A, 0xEC65, 0xED2C, 0xF58D, 0xF454, 0xF3E2,
    0xFC84, 0xFF51, 0x05EC, 0x0829, 0x0B00, 0x007F, 0x079F, 0x0FFA, 0x0382, 0x035E, 0x0C9A, 0x0E2A, 0x0920, 0x0E86, 0x1289, 0x1170,
    0x1110, 0x1491, 0x1288, 0x1FAE, 0x1F43, 0x159C, 0x2001, 0x1D95, 0x1FA1, 0x204E, 0x1DA3, 0x2C61, 0x2886, 0x269A, 0x2FDC, 0x2369,
    0x2079, 0x286D, 0x19F6, 0x1A02, 0x3B53, 0x11DB, 0x0E81, 0x291F, 0x11CB, 0x18E5, 0x015B, 0x1374, 0x0F62, 0xF731, 0x0C00, 0x02C1,
    0x13ED, 0x05CC, 0xFFD3, 0x237C, 0x14B2, 0xE999, 0x01C1, 0xFED5, 0xF16C, 0xFB5F, 0xDA73, 0xF659, 0xF16E, 0xF58C, 0xEDFD, 0xEBAC,
    0xFBD5, 0xE49C, 0xF694, 0xFBBD, 0xFADB, 0xF069, 0xF6D3, 0xFAB1, 0xFDA4, 0xF49F, 0xF1A8, 0xFE1F, 0xED4B, 0xF861, 0xFB68, 0x025C,
    0xF7F4, 0xF211, 0x0CB6, 0x0FEF, 0x0525, 0x1494, 0x1D92, 0x1F33, 0x2A1B, 0x24D6, 0x38EC, 0x23F9, 0x290E, 0x2E7A, 0x2E81, 0x3038,
    0x1D66, 0x335E, 0x2DBB, 0x1EA7, 0x2459, 0x21B8, 0x1250, 0x1D80, 0x08FE, 0x08F4, 0x0189, 0xFCCE, 0x082D, 0xE966, 0xF59E, 0xED2C,
    0xE0F7, 0xF01A, 0xE3CD, 0xE12B, 0xD6C0, 0xD70B, 0xD4FF, 0xB83A, 0xAD2D, 0xB43B, 0xAECE, 0x8E55, 0xB062, 0xAAD5, 0xA3BE, 0xAB87,
    0xA98B, 0xBE10, 0xB89F, 0xC218, 0xC785, 0xCDDD, 0xC4BC, 0xDCFC, 0xE585, 0xE381, 0xD704, 0xF1F3, 0xFE67, 0xDE07, 0xF86E, 0xF0C9,
    0xFD95, 0xFB65, 0xF67A, 0x0DCE, 0x144A, 0x0925, 0x20CF, 0x2913, 0x16EC, 0x3662, 0x3EF6, 0x40E4, 0x39E7, 0x4943, 0x39E1, 0x4217,
    0x580D, 0x4F02, 0x573C, 0x5D56, 0x6A51, 0x6019, 0x6CEB, 0x60B1, 0x52CF, 0x57CB, 0x4CB8, 0x4314, 0x3A45, 0x2E20, 0x2116, 0x1F87,
    0x06EA, 0xFE98, 0xF73B, 0xE38A, 0xE1FD, 0xC9C2, 0xD9FB, 0xD50C, 0xDB75, 0xD058, 0xD297, 0xE46E, 0xCB98, 0xD7DE, 0xC95F, 0xD6C7,
    0xD2E1, 0xCFE2, 0xCED6, 0xD108, 0xCC97, 0xC46A, 0xD6B1, 0xC57E, 0xD322, 0xD0A3, 0xCF31, 0xF5BD, 0xF123, 0xE950, 0xEFA1, 0x09EF,
    0xF474, 0xF56F, 0xFF16, 0xFE26, 0x00BB, 0xFA3B, 0x0AE1, 0xFE46, 0x0521, 0x1272, 0x2A75, 0x113E, 0x246E, 0x426A, 0x3D7D, 0x487E,
    0x4533, 0x4F87, 0x41A3, 0x421B, 0x484E, 0x2BAA, 0x3AC7, 0x39D9, 0x2F59, 0x15C8, 0x16C9, 0x1855, 0xF1B0, 0xF18E, 0xE86E, 0xE1D3,
    0xD665, 0xE3B9, 0xD93D, 0xD1E7, 0xCF89, 0xDE01, 0xCF69, 0xD3AA, 0xCF60, 0xCD25, 0xC96D, 0xC0DE, 0xDD99, 0xC6A9, 0xBF0E, 0xC0DE,
    0xCA1C, 0xC0A3, 0xBD6E, 0xBA30, 0xBC8D, 0xBF3A, 0xC81D, 0xD36C, 0xCF9E, 0xCB2C, 0xE577, 0xF105, 0xEC4F, 0xE70B, 0x113C, 0x0AD7,
    0xFE04, 0x1479, 0x1957, 0x2C43, 0x28EA, 0x39B8, 0x3A72, 0x58A6, 0x54C5, 0x5494, 0x4AB8, 0x5A38, 0x4B69, 0x458A, 0x4A6F, 0x3444,
    0x4A2A, 0x396F, 0x3364, 0x333C, 0x2926, 0x1388, 0x1DAB, 0x1610, 0xEEAF, 0xFC54, 0x09FC, 0xF9CF, 0x05BF, 0x00CE, 0xF3E0, 0x0301,
    0x0CF9, 0xFAA3, 0xFB22, 0xFE5D, 0xFE35, 0xE625, 0xF33C, 0xF2ED, 0xD47A, 0xE60C, 0xDDEC, 0xDD44, 0xE797, 0xD99D, 0xEA77, 0xED71,
    0xEE7F, 0xFF7E, 0xF7B6, 0x03D2, 0x002D, 0xFA64, 0xFC47, 0x189B, 0xF66C, 0xFBF4, 0x01D8, 0x1316, 0x1164, 0xF986, 0x2218, 0x1D53,
    0x1F70, 0x2DBB, 0x32E7, 0x2FF1, 0x384C, 0x336B, 0x3C55, 0x25A2, 0x2D44, 0x38E9, 0x179D, 0x1B0C, 0x1D30, 0x0304, 0x04E2, 0xF8C9,
    0xF02C, 0xE2A7, 0xE4DD, 0xE905, 0xE038, 0xF2B3, 0xE7E0, 0xFE4B, 0x0C6C, 0xF541, 0x069F, 0x0C56, 0x0975, 0x1080, 0x04FA, 0x1ED3,
    0x0F05, 0x03F1, 0x2088, 0x166D, 0xFC15, 0x1236, 0x0A13, 0x0660, 0x10A8, 0xF8CF, 0x0592, 0x18C3, 0x0454, 0x03FC, 0x08C3, 0x07EB,
    0x158A, 0xFF77, 0x0804, 0x12D3, 0x02D9, 0xFE9B, 0x16A0, 0xFF04, 0x00DB, 0x1AD2, 0x12BD, 0x1811, 0x1312, 0x1C26, 0x1F82, 0x0ECB,
    0x1C2A, 0x0B0B, 0x0DC6, 0x14E7, 0x0E21, 0x03EF, 0x0AD1, 0x0EFF, 0xFA20, 0x05F4, 0xF26B, 0x0438, 0xE4FE, 0x00C9, 0xF524, 0xE854,
    0x0BA2, 0xF3CF, 0xF793, 0xF2B9, 0x0713, 0xFDF7, 0x00E8, 0x008D, 0x0AA0, 0x04DD, 0xFE04, 0x0CE3, 0x012B, 0x023A, 0x0CE5, 0xFE08,
    0x0912, 0x11B5, 0x1755, 0x24D2, 0x208E, 0x2E11, 0x249D, 0x2D89, 0x3693, 0x2E61, 0x348E, 0x3803, 0x2A39, 0x36E8, 0x2D18, 0x2B29,
    0x2CC9, 0x24CF, 0x3272, 0x2CDE, 0x2E30, 0x2F53, 0x3593, 0x2D1D, 0x3A8D, 0x270C, 0x295D, 0x1DC3, 0x1DE6, 0x234E, 0x04DE, 0x137F,
    0xF2CE, 0xFA9E, 0xEDA0, 0xDE58, 0xDA3D, 0xCA2E, 0xD716, 0xD375, 0xCEE6, 0xD040, 0xD66C, 0xD0C3, 0xD2EF, 0xD560, 0xDD27, 0xE827,
    0xDAD0, 0xE1C7, 0xEC05, 0xD192, 0xE698, 0xE103, 0xD63E, 0xDD72, 0xC8A4, 0xDA34, 0xCE6A, 0xD04A, 0xE24A, 0xE6F0, 0xEB4F, 0xFD2E,
    0xFA59, 0xFDF9, 0x12A4, 0x0BC7, 0x0CEF, 0x1852, 0x2C2B, 0x1F98, 0x2F65, 0x3485, 0x2038, 0x2E4D, 0x3E4A, 0x3AF8, 0x4CD8, 0x429E,
    0x4243, 0x49AA, 0x4127, 0x3239, 0x285A, 0x3EF0, 0x2287, 0x2437, 0x172B, 0x0CCB, 0x0199, 0xFC27, 0xF67C, 0xDD52, 0xDC44, 0xD260,
    0xC1DF, 0xC796, 0xC915, 0xB45E, 0xBE65, 0xB8FB, 0xB8E4, 0xBB29, 0xBC26, 0xBD7F, 0xC42D, 0xBEBE, 0xC46E, 0xCB94, 0xBF81, 0xCDC5,
    0xD15E, 0xCA9C, 0xD844, 0xD898, 0xE9EF, 0xE8E7, 0xF74D, 0xFF71, 0xFAD9, 0x044D, 0x01C8, 0x11CD, 0x08E2, 0x0DEE, 0x098A, 0x1A14,
    0x0CBA, 0x1F41, 0x1926, 0x066A, 0x1D9C, 0x3486, 0x1DF6, 0x2577, 0x3EE1, 0x2DC0, 0x446A, 0x37DB, 0x42CE, 0x2A08, 0x3DE4, 0x30E1,
    0x2587, 0x3381, 0x213B, 0x17EE, 0x0C72, 0x0B0B, 0xF8C2, 0xEC43, 0xEAF1, 0xEF01, 0xD13B, 0xD865, 0xD942, 0xD6C1, 0xCDB0, 0xCE61,
    0xD709, 0xCA1A, 0xD858, 0xD8AD, 0xCC49, 0xC7CE, 0xC8C5, 0xD567, 0xC91C, 0xC066, 0xCBC6, 0xC6C9, 0xC5E5, 0xB799, 0xC36A, 0xC7F7,
    0xC346, 0xD4D4, 0xD979, 0xD44A, 0xE09A, 0xE949, 0xED4A, 0xF672, 0xF167, 0xFFD4, 0x000B, 0x0620, 0x0352, 0xFF8E, 0x133C, 0x1656,
    0x17F9, 0x1C37, 0x2545, 0x30D5, 0x27FC, 0x25F5, 0x3033, 0x2BEE, 0x296D, 0x29FD, 0x1FFD, 0x2252, 0x2CAD, 0x1B37, 0x193F, 0x1E80,
    0x16FF, 0x0527, 0x02D0, 0x05AA, 0xFCD1, 0xF9D7, 0xF39B, 0xFE00, 0xFCE5, 0xEAB1, 0xEDCA, 0xF381, 0xEA00, 0xF076, 0xF70F, 0xE8C2,
    0xE50F, 0xEE7E, 0xDF12, 0xD93D, 0xE368, 0xDEA6, 0xD8B4, 0xDC0E, 0xDB49, 0xD2FA, 0xDEDB, 0xD66E, 0xDB8A, 0xE1BA, 0xD9ED, 0xDE4D,
    0xD748, 0xD747, 0xDE49, 0xE2AA, 0xE45D, 0xEFD9, 0xEA9C, 0xF9E5, 0x01D8, 0xFAFA, 0x0AF6, 0x1405, 0x2760, 0x2E22, 0x2E7A, 0x2AF6,
    0x2DD9, 0x3247, 0x220C, 0x2365, 0x228B, 0x11BB, 0x1781, 0x14DB, 0x0436, 0xFF8E, 0xFFCB, 0xF616, 0xE6F5, 0xE655, 0xEB96, 0xE09E,
    0xE216, 0xEC6B, 0xDF1F, 0xE7CE, 0xEABA, 0xF40E, 0xEE6A, 0xEC9D, 0x016F, 0xFB62, 0xFE00, 0xFEC6, 0x0818, 0x0085, 0x002B, 0xF8E0,
    0xF09F, 0xFB81, 0xEFCE, 0xFFC4, 0xEFD5, 0xECCF, 0xFF94, 0xF803, 0x0170, 0xFC53, 0x0884, 0x05AC, 0x013B, 0x0717, 0xFF50, 0x00FB,
    0xFBB8, 0x097F, 0x0C4B, 0x0A90, 0x188B, 0x1D21, 0x1738, 0x206F, 0x2399, 0x19F0, 0x24D9, 0x22FC, 0x23C4, 0x23CD, 0x17C3, 0x141A,
    0x1E24, 0x0FD8, 0x13D4, 0x0B81, 0xFAED, 0xF8C3, 0xE8C3, 0xE9AA, 0xDAA2, 0xDEAD, 0xD5C9, 0xD124, 0xD27D, 0xD810, 0xD821, 0xD9E7,
    0xE3E4, 0xE3DE, 0xEC67, 0xEC22, 0xF22A, 0xEF7D, 0xF00B, 0xF659, 0x03D9, 0xFB4A, 0x002A, 0x0C62, 0x13DE, 0x148B, 0x0881, 0x18E6,
    0x18FB, 0x19BC, 0x1CEC, 0x175F, 0x1DF3, 0x1EBE, 0x1A8D, 0x14A5, 0x1301, 0x10FC, 0x1692, 0x1C57, 0x1402, 0x1D9F, 0x20CC, 0x23B5,
    0x1B5E, 0x1CAE, 0x1D47, 0x0E1C, 0x17D1, 0x1224, 0x0457, 0xFBE9, 0xF5B8, 0xEE5C, 0xE175, 0xE0AC, 0xE31A, 0xD9B9, 0xCFB6, 0xD44C,
    0xD61F, 0xCAE2, 0xD10E, 0xDC3C, 0xDC6B, 0xDC4B, 0xEC46, 0xEA85, 0xE615, 0xEA39, 0xEFA5, 0xF2C0, 0xEF62, 0xFB30, 0xFBC0, 0xF3CB,
    0xFD87, 0xF892, 0xF03B, 0xEDD7, 0xEC8F, 0xFE58, 0xF9F9, 0xF7FE, 0x02D9, 0x0B8D, 0x08D8, 0x0E65, 0x13B7, 0x1AA0, 0x1BB5, 0x1B56,
    0x1A7B, 0x1BE5, 0x20DA, 0x2A8B, 0x2BE0, 0x2521, 0x325D, 0x35FF, 0x388E, 0x384F, 0x3BFE, 0x3AB2, 0x3728, 0x36E0, 0x3B7E, 0x2D86,
    0x26D3, 0x26D9, 0x20A9, 0x18EC, 0x13D6, 0x0761, 0x0775, 0xF5B1, 0xF086, 0xEF88, 0xD5B8, 0xDE91, 0xD3BB, 0xD10F, 0xCB20, 0xCF49,
    0xD351, 0xD2B8, 0xCC8F, 0xD348, 0xD793, 0xD847, 0xDBCD, 0xDEC6, 0xE893, 0xE020, 0xED11, 0xEADE, 0xE611, 0xEB84, 0xF32E, 0xEC2A,
    0xEC72, 0xF586, 0xF745, 0xFA09, 0xFBFF, 0xF92C, 0xFD02, 0x06A4, 0x0569, 0x0AD5, 0x0835, 0x09FC, 0x1038, 0x165E, 0x193A, 0x246C,
    0x3376, 0x37F6, 0x42B1, 0x4756, 0x4CDA, 0x4AA7, 0x4E64, 0x4E6F, 0x47DB, 0x48AC, 0x3EAE, 0x3ECA, 0x2AA8, 0x265C, 0x21CC, 0x0B90,
    0x04BD, 0x0445, 0xFA24, 0xE921, 0xEC25, 0xE78F, 0xDBE9, 0xD4C7, 0xD650, 0xCC5C, 0xC549, 0xC53C, 0xBFAC, 0xBE58, 0xC3F0, 0xBA27,
    0xB9EF, 0xBA15, 0xB2C9, 0xB6C6, 0xB1F0, 0xB17C, 0xB2EB, 0xBC89, 0xC0ED, 0xBF7D, 0xC655, 0xD61E, 0xD88A, 0xDABD, 0xE87D, 0xEF7F,
    0xF1D1, 0xF995, 0x03D7, 0xF494, 0xF380, 0x08BD, 0x026A, 0xF84D, 0x096B, 0x19D4, 0x160C, 0x22A9, 0x3219, 0x256F, 0x295E, 0x36A0,
    0x341E, 0x3413, 0x314D, 0x377B, 0x3420, 0x2865, 0x27D6, 0x2B05, 0x233C, 0x1CA2, 0x1F7C, 0x1826, 0x10F4, 0x1153, 0x100C, 0x028D,
    0xFF1B, 0xFEC1, 0xFE17, 0xFA8D, 0xF7C9, 0xF488, 0xF492, 0xF344, 0xF086, 0xF325, 0xF064, 0xF2B6, 0xF6E0, 0xEE4B, 0xE6FF, 0xF337,
    0xEF3D, 0xE700, 0xF169, 0xEDC4, 0xF1AD, 0xF685, 0xEE20, 0xF912, 0xF2AC, 0xF4DB, 0xF9CF, 0xF6A4, 0xFB5C, 0x03FD, 0x067E, 0x0669,
    0x0D84, 0x10F2, 0x1C20, 0x1964, 0x2383, 0x279F, 0x2740, 0x298A, 0x2B63, 0x31EF, 0x2A83, 0x1D8E, 0x1CA2, 0x1AF6, 0x0A9D, 0x0B06,
    0x048A, 0xF82D, 0xF5D8, 0xF9EA, 0xE9C9, 0xE6B1, 0xF02E, 0xE7F6, 0xE648, 0xE87D, 0xF006, 0xEA64, 0xF008, 0xF38B, 0xEEF5, 0xF684,
    0xFD4D, 0xF99C, 0xFA72, 0xF6FD, 0xF309, 0xFABF, 0xF40D, 0xEC74, 0xEAC8, 0xE76C, 0xE574, 0xDE8C, 0xDC36, 0xE847, 0xE0BB, 0xE3D5,
    0xEDB1, 0xE4A4, 0xDBB2, 0xE617, 0xE3FE, 0xD5E2, 0xD97A, 0xE3DF, 0xDFEF, 0xD475, 0xE153, 0xE17D, 0xDA32, 0xE477, 0xF8D4, 0xF587,
    0x03A6, 0x0BFB, 0x11A1, 0x1AB8, 0x1A88, 0x2640, 0x2461, 0x28A1, 0x260E, 0x2716, 0x2827, 0x1F77, 0x15B1, 0x193E, 0x0C02, 0x089D,
    0x0670, 0x0284, 0xFCCC, 0xF5AD, 0xFBD2, 0xF20D, 0xF01D, 0xF411, 0xF905, 0xF7AD, 0xFFDD, 0x0418, 0xFEF4, 0xFBDD, 0x0A74, 0x0DC8,
    0xFEBC, 0x028A, 0x09F0, 0x0930, 0x1022, 0x0DFF, 0x0D3A, 0x1477, 0x12CB, 0x154A, 0x0CB9, 0x08AC, 0x0B83, 0x0DFA, 0x0A19, 0x0D10,
    0x0C39, 0x08FA, 0x0E2B, 0x06F8, 0x0813, 0x077C, 0x0D95, 0x1263, 0x1051, 0x1E62, 0x1A4C, 0x22B2, 0x25C5, 0x19D8, 0x1DC2, 0x1386,
    0x1257, 0x1001, 0x0779, 0xFD72, 0xF804, 0xF6A6, 0xEB12, 0xE6C7, 0xEBA8, 0xE48C, 0xDBB0, 0xE6AF, 0xDBB9, 0xD521, 0xDCCE, 0xD104,
    0xD0FD, 0xD0B9, 0xD615, 0xD836, 0xD67D, 0xD9EA, 0xD9B4, 0xDCE4, 0xDF6A, 0xDD89, 0xD4EB, 0xDE45, 0xD9F0, 0xD9F7, 0xD8F8, 0xDFE6,
    0xE919, 0xEB40, 0xF8C3, 0xF71F, 0xFFE7, 0x07FF, 0x103D, 0x09C7, 0x1627, 0x20A0, 0x1603, 0x1A6B, 0x1B62, 0x194C, 0x155E, 0x17DD,
    0x1E4D, 0x1B73, 0x20FB, 0x28AB, 0x2A25, 0x3198, 0x3218, 0x2FCF, 0x2D49, 0x299A, 0x21A2, 0x1946, 0x100C, 0x0337, 0xFDCB, 0xF941,
    0xE939, 0xDE74, 0xD8EC, 0xCF6D, 0xBCD6, 0xBE78, 0xBEBC, 0xB636, 0xB509, 0xBD94, 0xC11C, 0xBC4D, 0xCF59, 0xD3A1, 0xD062, 0xD339,
    0xDF1D, 0xDF03, 0xDFF6, 0xE6B5, 0xEA4A, 0xEB34, 0xEDA5, 0xF09D, 0xF00F, 0xF3FA, 0xF25D, 0x00CE, 0x02C2, 0x0376, 0x0BEF, 0x0BF4,
    0x0CE0, 0x09E1, 0x10A0, 0x157D, 0x18D5, 0x1B3D, 0x194C, 0x1A57, 0x1743, 0x1ECA, 0x261F, 0x2BBE, 0x3069, 0x4220, 0x4411, 0x4073,
    0x4B9A, 0x456F, 0x40E9, 0x3E1E, 0x40D1, 0x3590, 0x316B, 0x29D6, 0x186B, 0x11A6, 0x0BB1, 0x034C, 0xF990, 0xF5A9, 0xED63, 0xE654,
    0xE43D, 0xDE82, 0xD4E6, 0xD50B, 0xD611, 0xD721, 0xD644, 0xD752, 0xD1D9, 0xD4E0, 0xD724, 0xD18A, 0xD17B, 0xCF70, 0xD3A6, 0xD024,
    0xD5BF, 0xD74F, 0xD749, 0xDB30, 0xE9C1, 0xEC59, 0xE6AE, 0xF039, 0xF08C, 0xF11C, 0xF09D, 0xF41B, 0xF316, 0xF441, 0xFA79, 0xF7E6,
    0xECA5, 0xEBBD, 0xECE9, 0xF083, 0xF258, 0xFE4D, 0x0B9B, 0x12E6, 0x1C62, 0x20EC, 0x2A05, 0x278F, 0x2ED7, 0x33C3, 0x344D, 0x349E,
    0x3A9B, 0x35FE, 0x2F63, 0x27BC, 0x1E51, 0x1884, 0x09F9, 0x0606, 0xFD4E, 0xF914, 0xF276, 0xEF6F, 0xE8AE, 0xE5D2, 0xF11A, 0xEF28,
    0xE9F5, 0xE8BD, 0xEC71, 0xEA2E, 0xE392, 0xE0E7, 0xDAAC, 0xDCC5, 0xDA17, 0xD299, 0xD4AA, 0xCE3F, 0xCEF2, 0xD331, 0xCFE4, 0xD023,
    0xD532, 0xDE75, 0xDA0A, 0xE250, 0xEA8C, 0xF0A9, 0xF5E0, 0xFD98, 0x050F, 0x0156, 0x08D3, 0x078A, 0x1051, 0x11A2, 0x1A10, 0x22DF,
    0x264A, 0x2CED, 0x33C4, 0x37E5, 0x354A, 0x3E3D, 0x37D5, 0x314A, 0x2F6D, 0x2D6C, 0x23E6, 0x201A, 0x1E9D, 0x120E, 0x0FE8, 0x0BAE,
    0x0298, 0x006A, 0xFB21, 0xF7EB, 0xF5C2, 0xF075, 0xF1D8, 0xF211, 0xF536, 0xF0E0, 0xF21E, 0xF431, 0xF237, 0xF18E, 0xEBE7, 0xEA76,
    0xE3AB, 0xE0CF, 0xDFA7, 0xDD6D, 0xD7EE, 0xDA52, 0xDCA0, 0xD612, 0xD902, 0xDDE0, 0xE088, 0xE0B9, 0xE73F, 0xEE61, 0xE506, 0xE41B,
    0xE83B, 0xE40C, 0xE1B8, 0xE2D5, 0xE3D1, 0xE435, 0xE6C6, 0xED7E, 0xF7B8, 0xFFA7, 0x09C7, 0x15B8, 0x1CD8, 0x1D77, 0x26D1, 0x2656,
    0x20A0, 0x21DF, 0x213F, 0x1ED9, 0x1714, 0x129E, 0x129B, 0x0A02, 0xFA8E, 0xF32B, 0xEE62, 0xE401, 0xE186, 0xE363, 0xD6B2, 0xD5F7,
    0xDEA9, 0xE3BA, 0xE1A6, 0xE550, 0xEFE0, 0xF4AE, 0xFB50, 0x00F7, 0x0A30, 0x09A7, 0x0B28, 0x1321, 0x1178, 0x0E84, 0x0F95, 0x1590,
    0x1246, 0x0CF0, 0x13CB, 0x125D, 0x0D68, 0x116C, 0x180A, 0x143F, 0x14A1, 0x1D0A, 0x1F18, 0x19DD, 0x1260, 0x1168, 0x0A4E, 0x0433,
    0x03B5, 0x06D4, 0x0246, 0x0334, 0x085F, 0x05E4, 0x0362, 0x01E4, 0x015F, 0xF8C0, 0xFAC2, 0xF9DA, 0xF948, 0xF9FE, 0xF4FC, 0xF707,
    0xF431, 0xF1DA, 0xEBBF, 0xEA59, 0xE682, 0xE17F, 0xE3CE, 0xDD97, 0xDA4A, 0xD8B6, 0xDB3C, 0xD92F, 0xD278, 0xDB46, 0xE2D2, 0xE2E8,
    0xEA4C, 0xEB03, 0xEA2A, 0xE6D5, 0xEA52, 0xE8AD, 0xDC9C, 0xE654, 0xE9BE, 0xEA0E, 0xF06C, 0xF854, 0xFB53, 0xFAFC, 0x05E5, 0x02FA,
    0x01BE, 0x0C8F, 0x0F7B, 0x1213, 0x1250, 0x16AB, 0x14A5, 0x1276, 0x11B1, 0x0F7F, 0x15D9, 0x1706, 0x1B9D, 0x2411, 0x2316, 0x244A,
    0x2C5E, 0x3039, 0x2EC6, 0x2F0B, 0x3306, 0x2AFF, 0x2661, 0x2311, 0x1DC3, 0x162D, 0x096E, 0x046A, 0xF70D, 0xE907, 0xE301, 0xE0DA,
    0xD8B9, 0xD2E5, 0xDCB5, 0xDBF5, 0xD76D, 0xDD82, 0xE0CA, 0xDEB6, 0xDE93, 0xE82B, 0xE888, 0xE5E2, 0xE732, 0xE7A1, 0xE830, 0xDFB3,
    0xE4D3, 0xEA5F, 0xE331, 0xE0BB, 0xE62A, 0xE4B6, 0xDDC3, 0xE5BF, 0xEE03, 0xECFA, 0xF37E, 0xFF7E, 0x0814, 0x0DAD, 0x11D1, 0x1903,
    0x1B7B, 0x1DA3, 0x24FD, 0x2E72, 0x2D61, 0x314E, 0x38F8, 0x3870, 0x3885, 0x4021, 0x4521, 0x41D7, 0x402C, 0x3E55, 0x3E72, 0x353D,
    0x2FCA, 0x2CFF, 0x26C0, 0x1BB3, 0x1826, 0x0CE4, 0xFE09, 0xF830, 0xEF56, 0xE0D5, 0xD0C7, 0xCEC6, 0xC91A, 0xC1A4, 0xBC6E, 0xBA8B,
    0xB92E, 0xBAC5, 0xBEDE, 0xC202, 0xC127, 0xC26A, 0xC9A1, 0xC6D6, 0xC48A, 0xC881, 0xC84C, 0xC778, 0xD08D, 0xD8B9, 0xD635, 0xDC5B,
    0xE287, 0xE374, 0xE617, 0xEB72, 0xEFCC, 0xF561, 0xFE08, 0x01E6, 0x06D0, 0x061E, 0x02DA, 0x0535, 0x0901, 0x04D8, 0x0BDE, 0x183B,
    0x1BF7, 0x241E, 0x2F4D, 0x360E, 0x36ED, 0x3D59, 0x42AF, 0x42F9, 0x4334, 0x4269, 0x4625, 0x3E97, 0x3910, 0x3805, 0x28A8, 0x17A3,
    0x1361, 0x0CD6, 0xFC64, 0xF466, 0xF2AD, 0xEBBE, 0xE361, 0xE68D, 0xE451, 0xE05F, 0xE046, 0xE63E, 0xE6D2, 0xE8A2, 0xE96B, 0xEF01,
    0xEFB7, 0xE558, 0xE60F, 0xE345, 0xDDAD, 0xDCE1, 0xE240, 0xE0BE, 0xE141, 0xE910, 0xEFB9, 0xEDD2, 0xEFE9, 0xF6F4, 0xFDB2, 0xFEDA,
    0x05D9, 0x0E7C, 0x102E, 0x0C44, 0x0C25, 0x0908, 0x02CF, 0x0991, 0x0F5A, 0x1027, 0x125D, 0x1E2A, 0x2372, 0x28D7, 0x2595, 0x288C,
    0x2B72, 0x2772, 0x25A0, 0x2780, 0x264E, 0x1EC4, 0x2579, 0x239D, 0x1ED2, 0x1FE9, 0x1F8F, 0x164D, 0x0E57, 0x0CFC, 0x04F7, 0xFF91,
    0xFD12, 0xFA08, 0xF72B, 0xF408, 0xF4C3, 0xF525, 0xF56D, 0xF53E, 0xF93E, 0xF5F3, 0xEDF9, 0xEF98, 0xEA3C, 0xE3B4, 0xE5A8, 0xE740,
    0xE084, 0xDFE4, 0xE091, 0xD995, 0xD6F9, 0xD60E, 0xD2B4, 0xD03C, 0xD0C4, 0xCFFE, 0xD0D7, 0xCF83, 0xCDD0, 0xD157, 0xD2F8, 0xD120,
    0xD74F, 0xE1D7, 0xE16B, 0xEB20, 0xFAFB, 0x01D8, 0x08ED, 0x12F2, 0x1887, 0x1B01, 0x2292, 0x252A, 0x25B9, 0x2563, 0x2804, 0x29F1,
    0x22F1, 0x1BB1, 0x1A27, 0x1441, 0x0ABF, 0x06FB, 0x0184, 0xF946, 0xF546, 0xF56E, 0xEEE1, 0xEBD3, 0xF090, 0xF4EC, 0xFA1E, 0xFA69,
    0xFD78, 0x04D1, 0x05EA, 0x05F1, 0x09E1, 0x0AAF, 0x04DF, 0x0A16, 0x0EF5, 0x07B2, 0x0635, 0x0B05, 0x0ABD, 0x081D, 0x08F5, 0x0B54,
    0x0906, 0x06FB, 0x0F42, 0x16C1, 0x18A8, 0x19AE, 0x1FAB, 0x1C58, 0x13ED, 0x13AC, 0x1239, 0x0A42, 0x0D55, 0x13F6, 0x13F2, 0x19CC,
    0x1D68, 0x1F76, 0x21B4, 0x21A2, 0x1EAF, 0x20BD, 0x1F98, 0x1CB9, 0x23AB, 0x1FE1, 0x14EB, 0x1742, 0x1418, 0x02FA, 0xFA59, 0xF57F,
    0xE990, 0xE17C, 0xDE95, 0xD8CB, 0xD0EC, 0xCE2E, 0xC95F, 0xC982, 0xC898, 0xC599, 0xCC5B, 0xCC26, 0xCD53, 0xD2BF, 0xD46F, 0xD3E3,
    0xD9A0, 0xDFD1, 0xE043, 0xE6D6, 0xED8E, 0xF1CF, 0xF87C, 0xFD82, 0xFA67, 0xFD67, 0xFF92, 0xFD65, 0x0489, 0x070F, 0x0965, 0x0E6D,
    0x0E75, 0x08AE, 0x0A6A, 0x0CAD, 0x079A, 0x091D, 0x11C6, 0x15AC, 0x1CB1, 0x2299, 0x1F79, 0x1E08, 0x1EAB, 0x1BB6, 0x1486, 0x136D,
    0x0EA9, 0x0B6B, 0x0395, 0xFD6F, 0xF938, 0xF101, 0xEB74, 0xE768, 0xE1BF, 0xD8AF, 0xD870, 0xD618, 0xCF96, 0xD287, 0xD6E5, 0xD570,
    0xD90A, 0xD9B3, 0xDC7B, 0xDE34, 0xDEBB, 0xE478, 0xEEB4, 0xF39B, 0xF247, 0xFC5B, 0xFDA3, 0xF900, 0xFCC2, 0x02F9, 0xFFAA, 0x00D3,
    0x08DD, 0x0794, 0x07A8, 0x0AE8, 0x114A, 0x1843, 0x1DEB, 0x2715, 0x2F94, 0x2C42, 0x2922, 0x2E99, 0x2D6D, 0x278E, 0x2C14, 0x30D8,
    0x2FDD, 0x3317, 0x3526, 0x35AB, 0x370C, 0x34F3, 0x3269, 0x3347, 0x2C79, 0x27E1, 0x2DD9, 0x28B3, 0x1E45, 0x20E9, 0x1FE9, 0x139C,
    0x0F0D, 0x0C9E, 0xF9BD, 0xED74, 0xE75C, 0xDA77, 0xD0BD, 0xCB06, 0xC907, 0xC796, 0xC6BB, 0xC7D6, 0xCC58, 0xCCE3, 0xCE95, 0xD330,
    0xD3EE, 0xCFDA, 0xD62B, 0xD99C, 0xD565, 0xD5E6, 0xD678, 0xD543, 0xD568, 0xD7B7, 0xD7F8, 0xDABA, 0xD960, 0xDA9E, 0xDF51, 0xE210,
    0xE174, 0xEA03, 0xECCA, 0xEA52, 0xF256, 0xF47E, 0xF0C3, 0xF3DD, 0xFD9E, 0x057D, 0x11BB, 0x1F2A, 0x27FE, 0x2F7B, 0x3758, 0x3A00,
    0x3D85, 0x3FA7, 0x43FA, 0x48F4, 0x4733, 0x4350, 0x40A9, 0x3BAB, 0x32E8, 0x2CDE, 0x24C7, 0x1A6A, 0x125A, 0x0D11, 0x025C, 0xFB48,
    0xF65B, 0xF193, 0xEF0F, 0xE87C, 0xE39C, 0xE0B8, 0xD8E8, 0xD1F3, 0xD67A, 0xD365, 0xCE32, 0xD272, 0xD1B7, 0xCB69, 0xCC52, 0xCD49,
    0xC913, 0xCCC9, 0xD34A, 0xD539, 0xD910, 0xDF44, 0xE1C1, 0xE5B8, 0xE7DF, 0xED73, 0xF87C, 0xFD58, 0xFF39, 0x06C9, 0x091E, 0x046C,
    0x0740, 0x09F2, 0x0A7B, 0x1153, 0x1BB8, 0x1F8C, 0x2562, 0x2A3A, 0x2CFA, 0x3149, 0x2EFF, 0x2DAB, 0x35C2, 0x37BE, 0x3333, 0x38E3,
    0x3957, 0x2F1A, 0x2EE8, 0x3037, 0x2430, 0x1DE8, 0x18B6, 0x0D74, 0x041C, 0x00EF, 0xF9B2, 0xF431, 0xF261, 0xED91, 0xED95, 0xEBCA,
    0xE884, 0xE69A, 0xE6EC, 0xE51F, 0xE5B4, 0xE841, 0xE709, 0xE7B7, 0xE686, 0xE2C3, 0xE12C, 0xDD3C, 0xDC39, 0xDD01, 0xDA26, 0xD850,
    0xDB31, 0xDA8E, 0xDC43, 0xE67B, 0xE852, 0xE5C0, 0xECA1, 0xF2B3, 0xEE16, 0xF14C, 0xF634, 0xF639, 0xFC90, 0x040E, 0x06CF, 0x0A19,
    0x1141, 0x13C4, 0x164F, 0x19A2, 0x1DCC, 0x210B, 0x1FAB, 0x1FDD, 0x1DC5, 0x16F8, 0x1124, 0x0E9E, 0x0620, 0xFDEB, 0xFA37, 0xF7BF,
    0xF1A7, 0xF03C, 0xF13C, 0xECAD, 0xEB44, 0xEB30, 0xED94, 0xF041, 0xED52, 0xEED9, 0xF87B, 0xF692, 0xF49A, 0xFE5A, 0x02C0, 0xFDC9,
    0x02A7, 0x075A, 0x01E1, 0x024D, 0x088C, 0x0784, 0x070C, 0x07E8, 0x0A27, 0x0C10, 0x08D9, 0x0A2E, 0x0F8A, 0x0DDB, 0x0601, 0x0A30,
    0x0962, 0xFB67, 0xF576, 0xF670, 0xEE01, 0xECBC, 0xF11B, 0xF177, 0xF1EC, 0xFA56, 0x03E2, 0x081C, 0x0753, 0x0B21, 0x13A2, 0x11F1,
    0x1119, 0x1983, 0x1C1F, 0x155B, 0x1988, 0x1AE1, 0x123D, 0x0D17, 0x0DF3, 0x048C, 0xFCB3, 0xF945, 0xF381, 0xEEA2, 0xE968, 0xE392,
    0xE213, 0xE0DA, 0xDDB7, 0xE1B7, 0xE4C5, 0xE49D, 0xE65C, 0xEC88, 0xEEBB, 0xEF41, 0xF338, 0xF6D9, 0xF5CC, 0xF45E, 0xF8B1, 0xFE7A,
    0xFC56, 0xFE2F, 0x0346, 0xFEA9, 0xFC1B, 0x010D, 0xFCB5, 0xF5E8, 0xF995, 0xFB68, 0xF9C3, 0xFF51, 0x01E4, 0x0057, 0x01FC, 0x0464,
    0x047E, 0x089E, 0x0F7B, 0x12BB, 0x195C, 0x1D3C, 0x1D19, 0x1DA1, 0x2001, 0x1E5C, 0x1E0C, 0x1C54, 0x19A4, 0x17D9, 0x15D0, 0x11A1,
    0x0F1F, 0x078C, 0x0037, 0xFDCB, 0xF85C, 0xF239, 0xEE13, 0xE909, 0xE1EE, 0xE069, 0xDA70, 0xD7DD, 0xD7F7, 0xD39F, 0xD288, 0xDBDF,
    0xDC2E, 0xD9BE, 0xDECB, 0xE22E, 0xDD56, 0xE18F, 0xE97E, 0xE7A7, 0xEB89, 0xF411, 0xF924, 0xFB5E, 0x01DC, 0x07AA, 0x1360, 0x1784,
    0x1B5D, 0x255B, 0x2A77, 0x28D8, 0x2D28, 0x3067, 0x2B2F, 0x2DC6, 0x349D, 0x3327, 0x3045, 0x3520, 0x39D4, 0x3BF1, 0x3B87, 0x4049,
    0x44B7, 0x41AF, 0x3FFC, 0x428E, 0x3D51, 0x34B4, 0x3374, 0x2EC3, 0x21E2, 0x1BAD, 0x1537, 0x04A0, 0xF4A1, 0xEB2D, 0xDFFD, 0xD37A,
    0xCBE3, 0xC6CF, 0xC2B0, 0xBC6A, 0xBA01, 0xBCF3, 0xBD11, 0xBD3E, 0xC24F, 0xC478, 0xC2EB, 0xC5A3, 0xC9D3, 0xCA2F, 0xCB19, 0xCFA3,
    0xD5B9, 0xD7C0, 0xD949, 0xE0D7, 0xE4D9, 0xE14F, 0xE4D9, 0xEB4E, 0xEA4E, 0xEAA6, 0xF314, 0xF684, 0xF723, 0xFF22, 0x03A0, 0x0421,
    0x0AF1, 0x1094, 0x101C, 0x13F7, 0x1A81, 0x21D0, 0x2A15, 0x317C, 0x34C1, 0x3C76, 0x42A0, 0x43AE, 0x44C9, 0x4498, 0x415F, 0x40C5,
    0x40B7, 0x3CB6, 0x384B, 0x33C7, 0x2D35, 0x24B7, 0x1ED4, 0x18D5, 0x12D8, 0x0B32, 0x0611, 0xFDF6, 0xF668, 0xEDC9, 0xEBB0, 0xE636,
    0xE076, 0xE320, 0xE173, 0xE020, 0xE40E, 0xE622, 0xE37A, 0xE818, 0xEB6F, 0xE9CA, 0xE9CC, 0xF178, 0xF28D, 0xF565, 0xF87C, 0xFAC6,
    0x002F, 0x00E9, 0xFDC2, 0x01CE, 0x05C1, 0x032E, 0x0826, 0x0B9C, 0x08AC, 0x05A8, 0x0901, 0x05FF, 0xFF97, 0xFFFD, 0x051D, 0x0761,
    0x0B26, 0x1611, 0x1F3D, 0x2290, 0x259F, 0x2CE5, 0x2F86, 0x2FB0, 0x33CB, 0x38D9, 0x3A0E, 0x3C3F, 0x3CCA, 0x37C5, 0x31D8, 0x2A93,
    0x22A3, 0x17E1, 0x102E, 0x08A0, 0x03FD, 0xFD6D, 0xF9CE, 0xF7F7, 0xF435, 0xF007, 0xEFD7, 0xF026, 0xEC01, 0xEA2B, 0xE8A5, 0xE6B0,
    0xE29A, 0xDFEF, 0xD9E8, 0xD4C5, 0xCF51, 0xD1B7, 0xCF30, 0xC9DB, 0xC8FE, 0xCC28, 0xC9CE, 0xC865, 0xCD83, 0xCE4D, 0xD0ED, 0xD78E,
    0xDBE6, 0xDB21, 0xE340, 0xE6E0, 0xE84B, 0xEB6B, 0xF0C3, 0xF2B1, 0xFB2B, 0x0633, 0x0D4C, 0x1426, 0x1DE9, 0x2706, 0x2A9A, 0x2EBF,
    0x3091, 0x3406, 0x3329, 0x314C, 0x3133, 0x302D, 0x29A4, 0x2724, 0x2598, 0x20E9, 0x1B6B, 0x1962, 0x161D, 0x0E17, 0x0988, 0x0978,
    0x0729, 0x0105, 0x01A0, 0x0286, 0xFEE1, 0xFBB9, 0xFF45, 0xFD61, 0xF92D, 0xFB82, 0xFC7F, 0xF815, 0xF7F3, 0xFD9B, 0xFD95, 0xFE99,
    0x0038, 0x02A5, 0x0240, 0x01CF, 0x023F, 0x04DF, 0x062B, 0x055D, 0x0A90, 0x0D04, 0x0816, 0x05BE, 0x0BCD, 0x0719, 0x0083, 0x03DC,
    0x0A30, 0x0801, 0x0D03, 0x1867, 0x1CC0, 0x1D32, 0x252E, 0x2CF7, 0x28D0, 0x2889, 0x2C80, 0x2FE3, 0x2B4A, 0x2A85, 0x29CA, 0x2641,
    0x1D28, 0x1552, 0x0E0C, 0x0189, 0xF3C4, 0xEDCD, 0xEB17, 0xE188, 0xDD87, 0xDFBE, 0xDCF7, 0xD6CD, 0xDA64, 0xDD98, 0xDCF7, 0xDEC6,
    0xE62C, 0xE753, 0xE7F6, 0xED4C, 0xF154, 0xEE74, 0xEED6, 0xF6B4, 0xF915, 0xF606, 0xF978, 0x0124, 0xFED0, 0xFE94, 0x028F, 0x02E4,
    0xFF5B, 0x03A3, 0x06E0, 0x0518, 0x074B, 0x0C97, 0x0DDF, 0x0990, 0x04D8, 0x01A3, 0x01E0, 0xFECB, 0xFDB8, 0x02A9, 0x069A, 0x0583,
    0x08A2, 0x0D3D, 0x0C0C, 0x09E5, 0x0B43, 0x0B76, 0x0849, 0x0882, 0x07A3, 0x0506, 0x0045, 0xFDBB, 0xFA3A, 0xF5EF, 0xF18F, 0xED49,
    0xEB0B, 0xE917, 0xE664, 0xE492, 0xE605, 0xE461, 0xE249, 0xE24E, 0xE405, 0xE11E, 0xE1CA, 0xE869, 0xEDFF, 0xEDBC, 0xEFDC, 0xF3C8,
    0xF47B, 0xF78B, 0xFC1F, 0xFFEC, 0x027C, 0x0B11, 0x12EC, 0x162E, 0x1718, 0x1D41, 0x235F, 0x2679, 0x2858, 0x29E1, 0x2D89, 0x2A52,
    0x2244, 0x2510, 0x2497, 0x2327, 0x2A55, 0x2F34, 0x2D9C, 0x2EFF, 0x36DC, 0x35C8, 0x376E, 0x3BC2, 0x3D8B, 0x3B4A, 0x3B53, 0x39AB,
    0x3590, 0x3269, 0x2D41, 0x281C, 0x222B, 0x18B7, 0x0D07, 0x0711, 0xFEA9, 0xF3DB, 0xEEC7, 0xEE1B, 0xE6BB, 0xDEBD, 0xDE36, 0xDDBF,
    0xD92A, 0xD931, 0xDCEA, 0xD923, 0xD695, 0xDA35, 0xD89B, 0xD025, 0xD065, 0xD35A, 0xCF5E, 0xCD1E, 0xD077, 0xD1C5, 0xCEA6, 0xCF89,
    0xD031, 0xCEC3, 0xCE31, 0xD459, 0xD984, 0xDB6A, 0xE0A2, 0xEAC1, 0xF065, 0xF12F, 0xF74C, 0xFEBD, 0x014E, 0x04E3, 0x0FB7, 0x172F,
    0x1B69, 0x211A, 0x2C5B, 0x3144, 0x3322, 0x3958, 0x434E, 0x4483, 0x4399, 0x47B9, 0x464F, 0x3EE5, 0x3E36, 0x3DDD, 0x3243, 0x2B8F,
    0x2879, 0x1F08, 0x10F4, 0x08D2, 0xFDA9, 0xF21D, 0xE942, 0xE1C6, 0xD971, 0xD31D, 0xCE0A, 0xC9AD, 0xC814, 0xCAA8, 0xCEEA, 0xD339,
    0xD0A9, 0xD353, 0xD42B, 0xCF7B, 0xD424, 0xDA8C, 0xDADD, 0xDEBB, 0xEA6A, 0xEC31, 0xEC17, 0xEFAE, 0xFA5C, 0xFD2F, 0xFF38, 0x04E1,
    0x0F8E, 0x0D90, 0x0BE8, 0x11E7, 0x147F, 0x0F2A, 0x12DA, 0x1C3E, 0x17C6, 0x17E9, 0x1ED3, 0x26A4, 0x2821, 0x3107, 0x377C, 0x4065,
    0x421C, 0x4564, 0x484D, 0x4BCB, 0x48B6, 0x46EA, 0x466B, 0x402A, 0x36EC, 0x301E, 0x28EE, 0x17BB, 0x0E77, 0x09AA, 0x0209, 0xF77D,
    0xF765, 0xF2BB, 0xECA2, 0xE8E2, 0xE903, 0xE0C8, 0xDD4A, 0xE033, 0xDEE5, 0xD9F0, 0xD79C, 0xD961, 0xD533, 0xD16C, 0xCFC8, 0xD0E8,
    0xD0E5, 0xD21E, 0xD742, 0xDA90, 0xD740, 0xD587, 0xDE0E, 0xE05A, 0xDE10, 0xE3A6, 0xEF35, 0xEF7F, 0xEF2B, 0xF60D, 0xF5F1, 0xEFC9,
    0xEE94, 0xF574, 0xF415, 0xF520, 0xF806, 0x00C7, 0xFF09, 0x0458, 0x0CB7, 0x1642, 0x19C8, 0x2283, 0x25BE, 0x2478, 0x2658, 0x26DF,
    0x2559, 0x2425, 0x290F, 0x2498, 0x240B, 0x1FD8, 0x1E2B, 0x13F2, 0x1401, 0x08AC, 0x085C, 0x06A0, 0x03FB, 0x00B1, 0x03FE, 0x01F1,
    0x03FE, 0x0A4D, 0x0A0D, 0x08D0, 0x0495, 0x08CF, 0x0423, 0x0475, 0xFE89, 0x066B, 0x0345, 0x01B5, 0xFCDA, 0xFF94, 0xF93C, 0xF5AA,
    0xF4DA, 0xF664, 0xF5DF, 0xF483, 0xF966, 0xF954, 0xF4C5, 0xECE5, 0xF386, 0xEFAB, 0xEB03, 0xEC12, 0xF6E2, 0xF3AE, 0xF4F8, 0xFDC5,
    0x0578, 0x0490, 0x0B9E, 0x1740, 0x1AE8, 0x1D15, 0x22CF, 0x29C1, 0x270A, 0x23E0, 0x2156, 0x1EDD, 0x1718, 0x1059, 0x0BE7, 0x04B6,
    0xFCC5, 0xF954, 0xF75A, 0xEFD9, 0xEBD1, 0xED44, 0xED25, 0xEA72, 0xF061, 0xF7CF, 0xF606, 0xF863, 0xFA42, 0xF8CA, 0xF320, 0xF5ED,
    0xF32A, 0xF089, 0xEE91, 0xF3C9, 0xF37A, 0xF501, 0xF370, 0xF4D9, 0xF594, 0xF420, 0xF4BD, 0xF7EE, 0xFD8C, 0xFAD2, 0x02A4, 0x046C,
    0x0527, 0xFDCA, 0x040C, 0xFE9B, 0xFB0B, 0xF830, 0xFFD0, 0x0134, 0x0449, 0x0C8E, 0x1575, 0x1BD1, 0x1E01, 0x2601, 0x257D, 0x277E,
    0x271D, 0x2D33, 0x27D3, 0x2930, 0x258A, 0x24B1, 0x1AB1, 0x16B9, 0x0F86, 0x0878, 0xFDC8, 0xF3F4, 0xEA99, 0xE290, 0xDE74, 0xDBB9,
    0xD8F0, 0xD31C, 0xD86A, 0xD94A, 0xD7BA, 0xD6AD, 0xDF16, 0xDD0F, 0xDEFC, 0xE3F2, 0xE94B, 0xE6A9, 0xED71, 0xF56D, 0xFA7F, 0xFBCE,
    0x0284, 0x0938, 0x0AB9, 0x0DAD, 0x1233, 0x15A8, 0x1849, 0x20E4, 0x25BA, 0x2752, 0x27B8, 0x2973, 0x2808, 0x2847, 0x276B, 0x269A,
    0x2521, 0x28A1, 0x28D6, 0x2A11, 0x2A83, 0x2C41, 0x2973, 0x2792, 0x26AC, 0x27C9, 0x238A, 0x2013, 0x1C2C, 0x168B, 0x0D08, 0x0516,
    0xFEF3, 0xF6B9, 0xECB7, 0xE62E, 0xE38D, 0xD8FC, 0xD243, 0xD104, 0xD0AD, 0xC857, 0xCBD2, 0xCFEF, 0xD245, 0xD089, 0xD543, 0xD26C,
    0xD1C9, 0xD226, 0xD312, 0xD29D, 0xD5E6, 0xD878, 0xDBBA, 0xE0F8, 0xDEFB, 0xDD1E, 0xDD33, 0xE0CB, 0xDDCD, 0xE2B4, 0xE984, 0xF301,
    0xF73A, 0x035E, 0x092C, 0x0F1F, 0x1161, 0x144E, 0x1295, 0x118F, 0x1272, 0x168E, 0x1B53, 0x1DDE, 0x23D2, 0x28B0, 0x2D51, 0x2D37,
    0x3231, 0x3418, 0x3663, 0x3722, 0x3B9E, 0x37A7, 0x34A1, 0x324A, 0x2F34, 0x25E8, 0x1FCA, 0x1B73, 0x1256, 0x0820, 0x002F, 0xF8DE,
    0xEE38, 0xEA4E, 0xE763, 0xE523, 0xDE28, 0xE25E, 0xE156, 0xE25F, 0xE72D, 0xE606, 0xEAA8, 0xEB71, 0xE91B, 0xEC25, 0xEE8B, 0xEF1A,
    0xF022, 0xF13B, 0xF3B4, 0xEC66, 0xED2B, 0xECF2, 0xEB2F, 0xE661, 0xEAC7, 0xF0FA, 0xF310, 0xF6CB, 0xFC5D, 0x0066, 0xFFA1, 0x03C5,
    0x0507, 0x0A0F, 0x093F, 0x0FB2, 0x14B4, 0x1A96, 0x1D9C, 0x2A36, 0x30AD, 0x3198, 0x3714, 0x3EFA, 0x3FF3, 0x3F61, 0x4600, 0x46A1,
    0x4484, 0x429A, 0x44B5, 0x3A7B, 0x31BD, 0x2C7C, 0x294D, 0x1770, 0x0F82, 0x0E8B, 0x059F, 0xF4DE, 0xF126, 0xF044, 0xE4BB, 0xDFED,
    0xE012, 0xD8E8, 0xCEBB, 0xCE44, 0xCF10, 0xCC71, 0xC8FC, 0xCC4C, 0xCBEE, 0xCB21, 0xC500, 0xC58F, 0xC49C, 0xC222, 0xC178, 0xC6EE,
    0xC787, 0xC5FE, 0xCACF, 0xD364, 0xD5F8, 0xD954, 0xE29D, 0xE7DA, 0xE8D1, 0xE9D4, 0xED4B, 0xEBF0, 0xEFEC, 0xF667, 0xFD20, 0x0189,
    0x09E8, 0x0DE4, 0x1389, 0x1948, 0x1FA6, 0x2490, 0x2B69, 0x2FA1, 0x3534, 0x3AC3, 0x3CFC, 0x3D43, 0x3E12, 0x3D30, 0x36AF, 0x330B,
    0x2D03, 0x22FF, 0x17B1, 0x142D, 0x0CB0, 0x0310, 0xFE1E, 0xFF1A, 0xFA91, 0xF782, 0xF98F, 0xFDAD, 0xFB80, 0xFBFA, 0x0000, 0xFFA1,
    0xFA54, 0xFB4E, 0xFFC4, 0xFE7C, 0xFB3A, 0xFCE0, 0x00E5, 0xFD01, 0xF903, 0xFAFA, 0xFE7D, 0xFC8C, 0x02A0, 0x0C65, 0x0F20, 0x0CD8,
    0x132A, 0x13EA, 0x0FDE, 0x0E63, 0x12FF, 0x120B, 0x1183, 0x11C9, 0x13B6, 0x15C3, 0x1602, 0x142C, 0x1436, 0x160C, 0x12E3, 0x153E,
    0x18D6, 0x19CF, 0x1687, 0x19B0, 0x1613, 0x1038, 0x095E, 0x07E3, 0x006D, 0xF98A, 0xF4BA, 0xF3CF, 0xED79, 0xE797, 0xE7F6, 0xE505,
    0xE0AB, 0xE085, 0xE401, 0xE0B0, 0xE15C, 0xE2F9, 0xE611, 0xE573, 0xE8C9, 0xEB2D, 0xEEB1, 0xEDD7, 0xF045, 0xF328, 0xF516, 0xF478,
    0xF67A, 0xF6D8, 0xF187, 0xEF64, 0xF0E0, 0xF0DC, 0xEF4F, 0xF36B, 0xF5A0, 0xF4B4, 0xF2F6, 0xF5D3, 0xF1BF, 0xEC37, 0xEDAC, 0xEEF1,
    0xE9FA, 0xECEA, 0xF489, 0xF4D9, 0xF645, 0xFF09, 0x0210, 0x01F1, 0x07C1, 0x0C88, 0x0CB6, 0x1141, 0x1645, 0x178E, 0x1722, 0x1688,
    0x1440, 0x11E9, 0x0C40, 0x05F0, 0x026C, 0xFE70, 0xF7FB, 0xF2CC, 0xF010, 0xE9C3, 0xE607, 0xE447, 0xE4DD, 0xE34E, 0xE6CF, 0xEB20,
    0xF080, 0xF0EA, 0xF602, 0xFB2F, 0x0161, 0x0550, 0x0A2B, 0x0BF8, 0x0C99, 0x0D50, 0x0B61, 0x0D20, 0x0D41, 0x0E7E, 0x0F3F, 0x16A7,
    0x15FC, 0x16C4, 0x18DF, 0x1D15, 0x1A6D, 0x1E6E, 0x1F47, 0x1E2F, 0x1CE8, 0x1C25, 0x1813, 0x16D6, 0x1751, 0x14C4, 0x1937, 0x1C93,
    0x1E73, 0x1EE6, 0x25C3, 0x260A, 0x2806, 0x28A6, 0x2913, 0x2322, 0x201C, 0x1D20, 0x1A1D, 0x1157, 0x0A29, 0x05A5, 0xFFB4, 0xF71F,
    0xF169, 0xED3C, 0xE422, 0xDBF8, 0xD676, 0xD431, 0xCD3F, 0xCA03, 0xC995, 0xCA18, 0xC386, 0xC2F5, 0xC6B3, 0xC67F, 0xC5E5, 0xCE18,
    0xD28A, 0xD18A, 0xD660, 0xDBFC, 0xDA0B, 0xD98E, 0xDDD1, 0xE274, 0xE503, 0xEA62, 0xF20D, 0xF7F5, 0xFBD7, 0x0165, 0x051D, 0x0524,
    0x076E, 0x0B35, 0x0D1E, 0x1082, 0x18B7, 0x1D6A, 0x243F, 0x2A6C, 0x2ECE, 0x3179, 0x385E, 0x3755, 0x38CC, 0x3B51, 0x3B7A, 0x3796,
    0x37AF, 0x3237, 0x2AAA, 0x25FE, 0x1E3A, 0x1464, 0x0DC9, 0x092E, 0xFDBF, 0xF6D7, 0xED91, 0xE542, 0xD9BF, 0xD4A7, 0xCCA5, 0xCB0F,
    0xC836, 0xC891, 0xC8CC, 0xCB2F, 0xCA6D, 0xCA00, 0xCC4E, 0xCD76, 0xCF5B, 0xD290, 0xDC2E, 0xDE79, 0xE0DE, 0xE55A, 0xEC19, 0xE7D1,
    0xEA46, 0xF0FB, 0xF30B, 0xF12F, 0xFC38, 0x03A4, 0x0209, 0x060B, 0x0DDE, 0x1099, 0x119A, 0x1887, 0x1D2E, 0x200C, 0x1ECA, 0x211B,
    0x2566, 0x28A4, 0x292B, 0x312B, 0x35FA, 0x3386, 0x33EB, 0x37E7, 0x366C, 0x31F5, 0x347D, 0x368C, 0x32F7, 0x2D35, 0x2A79, 0x246A,
    0x1A94, 0x134D, 0x0FAD, 0x093F, 0xFE49, 0xF861, 0xF171, 0xE9C3, 0xE189, 0xDE30, 0xDBCD, 0xD916, 0xD415, 0xD475, 0xD416, 0xCF41,
    0xD0C9, 0xD67F, 0xD67C, 0xD42E, 0xDCD7, 0xDDE1, 0xD971, 0xD85F, 0xDB8C, 0xD651, 0xD806, 0xDB8B, 0xDFFC, 0xDE84, 0xDF8A, 0xE1E2,
    0xE25D, 0xDFD8, 0xE122, 0xE5E3, 0xE257, 0xE2D6, 0xE6E2, 0xEA84, 0xE726, 0xF010, 0xF6EC, 0xFD5B, 0x017A, 0x0AE7, 0x111E, 0x1740,
    0x19B5, 0x2016, 0x2485, 0x213E, 0x251F, 0x2B75, 0x2954, 0x2295, 0x2814, 0x24E6, 0x1CF9, 0x18E5, 0x17BE, 0x0CA8, 0x080D, 0x07E2,
    0x05CB, 0x01EE, 0x00D0, 0xFEFE, 0xFB7A, 0xF963, 0xF663, 0xF582, 0xF2C9, 0xF00E, 0xECCC, 0xEC88, 0xEB4A, 0xEA7D, 0xEB12, 0xEE73,
    0xEDD7, 0xE921, 0xE85F, 0xE842, 0xE296, 0xDFC8, 0xE6F1, 0xE892, 0xE857, 0xEE7C, 0xF3D2, 0xF127, 0xF0B7, 0xF437, 0xF395, 0xF262,
    0xF1D3, 0xF543, 0xF8B1, 0xFBC3, 0xFFBF, 0x0A3A, 0x0E2F, 0x0E91, 0x148A, 0x1C8A, 0x1BAF, 0x1C35, 0x227D, 0x231F, 0x1F5B, 0x1ECD,
    0x2047, 0x199A, 0x14A2, 0x1383, 0x13AA, 0x0D08, 0x0CAA, 0x0B88, 0x064A, 0xFE82, 0xFA5F, 0xF474, 0xEFA8, 0xED4B, 0xE845, 0xE6F7,
    0xE642, 0xE2F6, 0xE0B1, 0xE5B5, 0xE3E4, 0xE463, 0xE856, 0xEA52, 0xE77F, 0xEB58, 0xEB6F, 0xE7E7, 0xE72E, 0xE569, 0xE25E, 0xE2E6,
    0xE694, 0xE73A, 0xEB0D, 0xEE31, 0xF302, 0xF48E, 0xF388, 0xF07A, 0xF217, 0xF08F, 0xF086, 0xF87D, 0x003C, 0x0468, 0x091E, 0x10A5,
    0x1424, 0x170C, 0x1B04, 0x227C, 0x2297, 0x1F55, 0x21E7, 0x25A8, 0x1ED4, 0x1AA3, 0x1D9B, 0x15D8, 0x08F6, 0x046C, 0xFFF1, 0xF1A7,
    0xEB96, 0xEA95, 0xE804, 0xE3A3, 0xE41D, 0xE300, 0xE139, 0xE00F, 0xE18D, 0xE4AA, 0xE5B8, 0xE707, 0xE97D, 0xED94, 0xEE09, 0xF211,
    0xF661, 0xFCBD, 0xFF25, 0x02E6, 0x061B, 0x0A52, 0x0C24, 0x0FDA, 0x1654, 0x1B57, 0x1F9C, 0x2457, 0x289E, 0x28FC, 0x2A1E, 0x265A,
    0x24F1, 0x2224, 0x1DB8, 0x171F, 0x1516, 0x0FD0, 0x0CBF, 0x1093, 0x11C1, 0x0EF2, 0x11C8, 0x1680, 0x11D3, 0x10D8, 0x1374, 0x1256,
    0x0CFC, 0x0D73, 0x0A83, 0x01EB, 0xFA13, 0xF81D, 0xF240, 0xE7FD, 0xE3BF, 0xE144, 0xDB26, 0xD5EA, 0xD608, 0xD1E8, 0xCF83, 0xCEF2,
    0xCEA1, 0xCC19, 0xCA7D, 0xC5F1, 0xC565, 0xC897, 0xC883, 0xCC2A, 0xD35C, 0xD5BA, 0xD632, 0xDEFA, 0xE231, 0xE482, 0xE9F7, 0xEED1,
    0xEDC7, 0xF2CC, 0xF6DB, 0xF8AE, 0xFDDE, 0x0420, 0x062D, 0x0929, 0x0B96, 0x093C, 0x07DB, 0x0B5A, 0x0F13, 0x0F9E, 0x164D, 0x1ACA,
    0x1E6E, 0x1F9D, 0x254D, 0x256E, 0x259A, 0x2A93, 0x2BF4, 0x2BD1, 0x300E, 0x336A, 0x32C0, 0x30AC, 0x3493, 0x2BC0, 0x2149, 0x204A,
    0x1C3F, 0x0FD8, 0x08C4, 0x091B, 0x0186, 0xF982, 0xF5F8, 0xF6C9, 0xEFF6, 0xE87A, 0xE509, 0xE975, 0xE4DE, 0xE1FB, 0xE3C3, 0xE5F5,
    0xDA9A, 0xDF36, 0xF2E6, 0xF44E, 0xED61, 0xEDF3, 0xEEB5, 0xED41, 0xEB1E, 0xED70, 0xEFAE, 0xF2E1, 0xF5DD, 0xF8C9, 0xFD58, 0x013F,
    0x09F6, 0x0556, 0x0CCE, 0x110A, 0x1282, 0x1119, 0x154F, 0x1040, 0x0EF1, 0x140F, 0x1467, 0x1022, 0x172F, 0x1EF4, 0x1DD1, 0x20E6,
    0x2CDD, 0x302E, 0x3033, 0x3701, 0x3C1B, 0x3EA8, 0x3446, 0x3A37, 0x34FE, 0x265F, 0x1120, 0x0CE4, 0x026B, 0xFD78, 0xFABF, 0xF842,
    0xF5D4, 0xF2CD, 0xF090, 0xE915, 0xE58D, 0xE224, 0xDFC9, 0xDC6A, 0xDEAA, 0xE1A6, 0xE08A, 0xD747, 0xD784, 0xDA48, 0xD7C9, 0xD26F,
    0xDD40, 0xDC69, 0xD869, 0xDA05, 0xE1C4, 0xE145, 0xE5DC, 0xED58, 0xF203, 0xF3F4, 0xF3D3, 0xF2F4, 0xF32E, 0xF4EB, 0xF50E, 0xF920,
    0xFCE7, 0x00A4, 0x0106, 0x054D, 0x03EE, 0x053D, 0x080F, 0x0FDF, 0x1204, 0x1803, 0x1E9A, 0x21A5, 0x1DA5, 0x218E, 0x220A, 0x1EE1,
    0x1B87, 0x2065, 0x1D5E, 0x16A3, 0x1528, 0x16DB, 0x13FE, 0x0FE3, 0x121B, 0x126A, 0x1492, 0x1014, 0x1344, 0x1204, 0x1068, 0x0902,
    0x0DC4, 0x0C46, 0x0905, 0x066F, 0x0B34, 0x079B, 0x04F6, 0x08E6, 0x0B6F, 0x062F, 0x05D0, 0x0C73, 0x0D33, 0x0D65, 0x1319, 0x18DB,
    0x1508, 0x1977, 0x1CDC, 0x1F69, 0x1A04, 0x1D29, 0x1B98, 0x1B46, 0x13E9, 0x1260, 0x0E90, 0x0B24, 0x01C8, 0xFCFB, 0xFB91, 0xF6A5,
    0xEFCE, 0xEE34, 0xF189, 0xEE83, 0xEF2C, 0xF0B7, 0xF4F5, 0xF352, 0xF2FC, 0xF3BE, 0xF923, 0xF5F1, 0xF44A, 0xF5E9, 0xFAA8, 0xF84B,
    0xFBAE, 0x002A, 0x04BA, 0x03B4, 0x0600, 0x063C, 0x0764, 0x073A, 0x0940, 0x0B37, 0x0CE7, 0x1231, 0x13F2, 0x14F8, 0x158C, 0x1898,
    0x0FE6, 0x0CF8, 0x0DA3, 0x0B11, 0x01D0, 0x051B, 0x0548, 0x0059, 0xFD5A, 0x0082, 0xFADF, 0xF800, 0xF7BC, 0xF7A2, 0xF325, 0xF345,
    0xF2C5, 0xF1E5, 0xEE99, 0xEBCA, 0xEBF4, 0xE8AE, 0xE5D7, 0xE2B6, 0xE656, 0xDFE2, 0xDD09, 0xDE07, 0xE581, 0xDF87, 0xE253, 0xE79A,
    0xEA92, 0xE467, 0xE8B8, 0xEC59, 0xEA0C, 0xE611, 0xE92A, 0xEAC3, 0xEAA3, 0xEAD6, 0xEC16, 0xF05D, 0xF320, 0xF621, 0xF6CD, 0x01DF,
    0x0091, 0x03AC, 0x0472, 0x0CF0, 0x0B01, 0x0D37, 0x1086, 0x13F4, 0x11B8, 0x1453, 0x158C, 0x15BE, 0x168E, 0x1C1A, 0x1989, 0x1F29,
    0x21C1, 0x22BD, 0x204D, 0x2333, 0x28B1, 0x2364, 0x2744, 0x232D, 0x2A67, 0x1EEF, 0x2475, 0x1DF0, 0x22DC, 0x19A3, 0x173C, 0x11C8,
    0x0CFA, 0x073E, 0x002A, 0x03D9, 0xFF17, 0xFF45, 0xFC0C, 0x0040, 0xFE40, 0xFD89, 0xFBC7, 0xF9BC, 0xF81F, 0xF485, 0xEE84, 0xEED6,
    0xEAA4, 0xEAF2, 0xE521, 0xEC11, 0xE283, 0xE3BB, 0xDBCA, 0xDCD7, 0xD329, 0xD377, 0xD3DF, 0xD10E, 0xD314, 0xD0EF, 0xD728, 0xCD9D,
    0xD59E, 0xD60E, 0xDE1E, 0xD9AA, 0xE316, 0xE59D, 0xE3EF, 0xE391, 0xE77C, 0xEAD0, 0xEABC, 0xEE2B, 0xF4D7, 0xF87B, 0xFCD0, 0xFB30,
    0x030A, 0x0399, 0x0A49, 0x0DC2, 0x1599, 0x18BD, 0x18EB, 0x1DBB, 0x14BF, 0x19DD, 0x141D, 0x1746, 0x09FB, 0x1303, 0x0CCF, 0x0689,
    0x02A9, 0x0706, 0x01DF, 0xF83E, 0xFE51, 0xFB7B, 0xF725, 0xEDFC, 0xF04F, 0xEC3D, 0xE776, 0xE554, 0xE30A, 0xE327, 0xDE28, 0xDCB7,
    0xDB9F, 0xDBCF, 0xDABA, 0xD656, 0xDCD0, 0xD9BA, 0xDE18, 0xDB2E, 0xE4AB, 0xDE8C, 0xE112, 0xE253, 0xE3F9, 0xE3B1, 0xE611, 0xED84,
    0xE80A, 0xEE67, 0xEFF2, 0xF7E3, 0xF5F7, 0xFCB9, 0x0080, 0x0443, 0x06E1, 0x0911, 0x118B, 0x144E, 0x1703, 0x1B17, 0x2000, 0x1F8F,
    0x17CE, 0x1B31, 0x1670, 0x15A5, 0x0E9E, 0x15B1, 0x13A5, 0x1368, 0x1547, 0x13B1, 0x137D, 0x0DBC, 0x1315, 0x0865, 0x0B68, 0x04C5,
    0x0296, 0xF87B, 0xF94D, 0xF719, 0xF15E, 0xF078, 0xEC44, 0xEDAF, 0xE7C7, 0xE65C, 0xE409, 0xE55F, 0xE30D, 0xDEB3, 0xE34E, 0xE1FF,
    0xE1C9, 0xDE74, 0xE3E3, 0xE67C, 0xE506, 0xE82F, 0xE966, 0xEF16, 0xE601, 0xE951, 0xE6DB, 0xE9A7, 0xE18A, 0xE2BD, 0xE41A, 0xE0A8,
    0xDFB2, 0xDC7B, 0xDF75, 0xD7C9, 0xDA46, 0xD853, 0xDC6B, 0xDA9E, 0xDF4B, 0xE51A, 0xE415, 0xE9A4, 0xED89, 0xF06B, 0xEBBB, 0xF3E4,
    0xF6C2, 0xF405, 0xFA05, 0x01A7, 0x0488, 0xFF78, 0x08EB, 0x08FD, 0x0A5C, 0x0CD5, 0x12A6, 0x1568, 0x137A, 0x19D2, 0x18BB, 0x1BF5,
    0x169F, 0x1B32, 0x1694, 0x11EA, 0x0FD4, 0x0B52, 0x0F79, 0x02B0, 0x0720, 0x0398, 0x0315, 0xF771, 0xF715, 0xF7E1, 0xEE25, 0xEFA1,
    0xF08F, 0xF9E8, 0xF085, 0xFABC, 0xF6F8, 0xF963, 0xF1BD, 0xF283, 0xF44C, 0xF306, 0xF41D, 0xEFCF, 0xF8FA, 0xF506, 0xF6FA, 0xF3A6,
    0xFB43, 0xF4A6, 0xF1C5, 0xF36F, 0xF464, 0xEF6C, 0xEA26, 0xEB22, 0xE677, 0xE23B, 0xE177, 0xE2C1, 0xE393, 0xE5F5, 0xEB3F, 0xF0C7,
    0xF79A, 0xFB79, 0xF943, 0xFD92, 0xFD43, 0x0187, 0xFED3, 0x05D8, 0x0268, 0x0556, 0x0641, 0x05FC, 0x0624, 0x03EA, 0x072F, 0x0052,
    0x0658, 0xFF1B, 0x0475, 0xFDA8, 0x000B, 0xFE31, 0x02B2, 0x02D7, 0x0060, 0x06F8, 0x02FD, 0x0386, 0xFB89, 0x04CA, 0x002E, 0x0009,
    0xFC2B, 0x01B6, 0xFE29, 0xF80E, 0xFAA5, 0xFC93, 0xFA19, 0xF6DF, 0xFD8B, 0x00D5, 0x02D2, 0x0476, 0x0605, 0x0850, 0x0876, 0x034D,
    0x0474, 0x0655, 0x0558, 0xFC1A, 0x01C4, 0xFBE8, 0xF723, 0xF04F, 0xF529, 0xEFF5, 0xEB01, 0xEBE7, 0xEB05, 0xEB6F, 0xE2DC, 0xEA3D,
    0xE6D0, 0xE936, 0xE3D1, 0xEE7C, 0xEC35, 0xE96E, 0xEBE2, 0xF0B5, 0xF2DC, 0xEE38, 0xF7E5, 0xF762, 0xF666, 0xEF2C, 0xFA18, 0xFE59,
    0xFCBD, 0x02C5, 0x0FE3, 0x14E6, 0x11DF, 0x1C7F, 0x2349, 0x259A, 0x2682, 0x2C01, 0x30B1, 0x315E, 0x2ECB, 0x2E02, 0x31A5, 0x3089,
    0x2BED, 0x307E, 0x30C3, 0x2C4C, 0x2328, 0x2582, 0x21CA, 0x1C65, 0x16E1, 0x167C, 0x14AB, 0x0967, 0x07E6, 0x017C, 0x0176, 0xF572,
    0xF953, 0xF412, 0xF3B3, 0xECF0, 0xEAFC, 0xE8DE, 0xE1C6, 0xE196, 0xE063, 0xE502, 0xDAE5, 0xDF65, 0xDCC0, 0xDAFB, 0xD695, 0xDD60,
    0xDC07, 0xD85F, 0xD8D6, 0xD923, 0xD8A2, 0xD874, 0xDB5D, 0xDFE5, 0xE5A1, 0xE81A, 0xEA7D, 0xF218, 0xF5B7, 0xF55B, 0xFC2A, 0x0215,
    0x0504, 0x02EE, 0x0A96, 0x0987, 0x0B89, 0x07B7, 0x0F40, 0x1072, 0x12CC, 0x1661, 0x18AB, 0x1B16, 0x193C, 0x203D, 0x1DDB, 0x23E3,
    0x24A9, 0x2665, 0x2143, 0x24A4, 0x23C5, 0x1DEA, 0x1E7B, 0x19DC, 0x16CE, 0x1160, 0x13D6, 0x0F38, 0x10BC, 0x1071, 0x0E9F, 0x0E85,
    0x0B30, 0x0A12, 0x0623, 0x0678, 0x0253, 0x073A, 0x05B4, 0x0124, 0x0240, 0x0460, 0xFE65, 0xF8A9, 0xFE9B, 0xFD2E, 0xF3C5, 0xEF88,
    0xF2B9, 0xF109, 0xE4ED, 0xE81C, 0xEDDC, 0xE9A0, 0xE3AD, 0xEC7F, 0xF373, 0xEB98, 0xF10E, 0xF798, 0x0011, 0xFB76, 0x0758, 0x0C05,
    0x122A, 0x0EEE, 0x13F4, 0x1CDF, 0x1C7F, 0x1EBF, 0x21B4, 0x2AC9, 0x243D, 0x2B9A, 0x2E5A, 0x3251, 0x2DFC, 0x30A1, 0x309C, 0x2F95,
    0x2CB0, 0x2D63, 0x32FC, 0x31C4, 0x2D76, 0x2DD5, 0x2D8E, 0x277E, 0x1FE0, 0x2030, 0x1E79, 0x16C6, 0x0FEE, 0x0F14, 0x0E57, 0x00AE,
    0xFFB2, 0x00D8, 0x0098, 0xF401, 0xF832, 0xF5C7, 0xEEF8, 0xE7A0, 0xE642, 0xE69D, 0xE1FA, 0xE050, 0xDBBC, 0xE117, 0xDB75, 0xD9F4,
    0xDB9D, 0xDF5A, 0xDAF1, 0xD8FC, 0xDD15, 0xDBB5, 0xDCE1, 0xDB59, 0xDEF4, 0xE04A, 0xE2DF, 0xE305, 0xE5C2, 0xEC20, 0xEB79, 0xF01A,
    0xF482, 0xFE11, 0x00A2, 0x0586, 0x0C09, 0x1379, 0x14CA, 0x14F7, 0x1A80, 0x1731, 0x13A2, 0x1794, 0x1AF0, 0x1919, 0x1CF3, 0x24E7,
    0x21D0, 0x21E4, 0x22A3, 0x2220, 0x2032, 0x1DDA, 0x1F2A, 0x2036, 0x2311, 0x1B36, 0x21C1, 0x2087, 0x1CDD, 0x15D9, 0x1E0E, 0x1ADE,
    0x1231, 0x11B4, 0x12CA, 0x0ECF, 0x05AE, 0x0D04, 0x0DD6, 0x0AE3, 0x03B5, 0x0BD5, 0x0979, 0x05AF, 0x0A21, 0x137B, 0x126A, 0x12C4,
    0x183B, 0x17C7, 0x12DC, 0x13D9, 0x1621, 0x1730, 0x14A5, 0x17D5, 0x19E1, 0x149D, 0x0F34, 0x113E, 0x136F, 0x09C5, 0x0CD0, 0x0E03,
    0x0C5B, 0x017C, 0x0492, 0x0382, 0x02A6, 0x01B0, 0x050B, 0x0807, 0x03AF, 0x01C4, 0xFEE9, 0x01A8, 0xFBA2, 0xF873, 0xF5BD, 0xF67C,
    0xF563, 0xF29A, 0xF6EB, 0xFDD1, 0x0200, 0xFFE4, 0x07A0, 0x0C06, 0x07B3, 0x05EA, 0x0980, 0x0C54, 0x092E, 0x0C06, 0x0D82, 0x100C,
    0x0AC3, 0x0927, 0x0C6D, 0x0A7F, 0x0265, 0x02AD, 0x05BA, 0xFE52, 0xFA9D, 0xFCC3, 0xF8D7, 0xF2F9, 0xF0FB, 0xF0E0, 0xEBC0, 0xE93D,
    0xE54D, 0xE4B1, 0xE4D2, 0xE1F7, 0xE5C6, 0xE9F8, 0xED43, 0xE813, 0xEF55, 0xF0DD, 0xF2A1, 0xECED, 0xF2FD, 0xF5E6, 0xF2F9, 0xF1FE,
    0xF964, 0xFF9B, 0xF7F1, 0xFAFE, 0xFEC0, 0xFD5E, 0xF6A4, 0xFDC7, 0x021F, 0x050D, 0x05A7, 0x0A93, 0x0F04, 0x126F, 0x0F7E, 0x130A,
    0x1B35, 0x1654, 0x0A6C, 0x11E2, 0x126B, 0x0A9B, 0xF84F, 0xEEEB, 0xF0BF, 0xD492, 0xC7BB, 0xD789, 0xDFAC, 0xD85B, 0xDEEB, 0xE84A,
    0xF3C1, 0xF42C, 0x0363, 0x0E74, 0x09FB, 0x0C54, 0x1078, 0x0D94, 0x0A2A, 0x083A, 0x02BE, 0x024C, 0xFE7F, 0xFFA6, 0xFF90, 0xFB30,
    0xFFE7, 0x0890, 0x06F5, 0x07CA, 0x0CC5, 0x0F00, 0x0E5B, 0x1078, 0x1800, 0x1F44, 0x2170, 0x267E, 0x2778, 0x2557, 0x2D81, 0x32B1,
    0x2CF9, 0x35BC, 0x4257, 0x4155, 0x3A5A, 0x3603, 0x3791, 0x301C, 0x263A, 0x22B1, 0x124B, 0xFABD, 0xF176, 0xF5BB, 0xE487, 0xD511,
    0xD518, 0xC7DB, 0xB8D4, 0xB279, 0xB85E, 0xB76A, 0xBB7E, 0xC235, 0xC746, 0xC40F, 0xCFEA, 0xE151, 0xE1DB, 0xE279, 0xEF18, 0xF24F,
    0xEC6B, 0xF0C0, 0xF74D, 0xFA6F, 0xF883, 0xFCD1, 0x056E, 0x07A5, 0x069B, 0x0D99, 0x1387, 0x1776, 0x12C7, 0x1AE2, 0x1AFA, 0x16D9,
    0x14E7, 0x19B5, 0x16CE, 0x18B9, 0x1DB0, 0x149C, 0x1D3D, 0x223F, 0x2665, 0x2798, 0x3347, 0x4118, 0x45FB, 0x4041, 0x3D63, 0x3EFC,
    0x35B3, 0x34F5, 0x3A3A, 0x277F, 0x12F3, 0x1499, 0x0A81, 0xF4A3, 0xEE51, 0xE815, 0xD66D, 0xC2A9, 0xBC67, 0xB971, 0xB397, 0xB55A,
    0xBB9D, 0xC205, 0xBFCC, 0xCA41, 0xD516, 0xDA87, 0xDB76, 0xE299, 0xF1AD, 0xEF84, 0xEF1B, 0xF50D, 0xFF0C, 0xF94B, 0xFA19, 0x0752,
    0x0E81, 0x0C30, 0x1084, 0x2379, 0x1DC9, 0x1C92, 0x2458, 0x28F7, 0x239E, 0x26E7, 0x24AB, 0x2B1E, 0x31E3, 0x2A2F, 0x2AB5, 0x2B89,
    0x303B, 0x26D0, 0x2C01, 0x335E, 0x3F5B, 0x4433, 0x4726, 0x506D, 0x48A2, 0x4317, 0x4A9D, 0x4C70, 0x3C67, 0x33FF, 0x3613, 0x2EF1,
    0x257A, 0x1E4B, 0x1E63, 0x101C, 0xFF05, 0xF114, 0xE5D1, 0xDD49, 0xD3AC, 0xD713, 0xD051, 0xD1FD, 0xCD4C, 0xD55E, 0xCE9B, 0xCC70,
    0xD055, 0xCB5F, 0xCAC7, 0xC980, 0xCFE3, 0xC822, 0xCDDD, 0xCCA4, 0xD13F, 0xCEC8, 0xD2DE, 0xDECA, 0xDF92, 0xE444, 0xEBF7, 0xF283,
    0xF2F2, 0xFC2A, 0xFF68, 0x0346, 0x0B61, 0x1869, 0x1D3B, 0x1D5E, 0x29E9, 0x3322, 0x36B2, 0x376B, 0x4973, 0x5611, 0x5983, 0x65CC,
    0x66F4, 0x61E5, 0x5D32, 0x64C0, 0x6043, 0x528A, 0x4AFB, 0x48E1, 0x3F2A, 0x30FC, 0x3462, 0x2BD4, 0x203C, 0x11E5, 0x0959, 0xF5BE,
    0xE7B5, 0xE6E3, 0xE288, 0xE07A, 0xD925, 0xE255, 0xE0E8, 0xE209, 0xE125, 0xEA43, 0xE539, 0xDE00, 0xE19B, 0xE16A, 0xDB18, 0xCE37,
    0xDD05, 0xD9C7, 0xD24D, 0xCEBB, 0xD427, 0xD2C3, 0xCF50, 0xD1EF, 0xD82B, 0xE10B, 0xE24F, 0xE8E3, 0xE769, 0xE8CD, 0xEDC9, 0xEE3C,
    0xF401, 0xFA77, 0xFC76, 0xF8D2, 0x02D0, 0x0A39, 0x0F50, 0x2532, 0x313D, 0x37D2, 0x3469, 0x3E07, 0x3EB6, 0x417C, 0x3EA0, 0x3A63,
    0x379C, 0x3008, 0x2F03, 0x2414, 0x2006, 0x10B3, 0x064B, 0xF37C, 0xE893, 0xD9A9, 0xD0C8, 0xCDE4, 0xC5DF, 0xC4F5, 0xC36F, 0xCADE,
    0xC5F7, 0xC9AB, 0xD32B, 0xD449, 0xCD59, 0xD7DC, 0xDD6C, 0xD831, 0xE369, 0xE92C, 0xF10E, 0xF0B8, 0xF435, 0xFDEC, 0x06BB, 0x0AA9,
    0x0579, 0x0D27, 0x0ECF, 0x0E51, 0x0B47, 0x0AF0, 0x0DC5, 0x0B49, 0x04EC, 0x052B, 0x11E4, 0x056B, 0x043D, 0x076D, 0x0811, 0x09C8,
    0x0AD3, 0x12C5, 0x0FDE, 0x0EDA, 0x0B37, 0x1640, 0x12F3, 0x0EAA, 0x0AB1, 0x0BCB, 0x0F13, 0x0C80, 0x1388, 0x1127, 0x1500, 0x1296,
    0x0D1E, 0xFDE0, 0xFAA7, 0xF78B, 0xF094, 0xF11E, 0xF1DE, 0xF85E, 0xF4C7, 0xF0EF, 0xF35D, 0xF9CF, 0xF36F, 0xF290, 0xFBC5, 0xF7C3,
    0xF437, 0xF731, 0xF616, 0xF1B6, 0xEE6D, 0xE647, 0xEA5D, 0xEC32, 0xE51F, 0xEB52, 0xE8F7, 0xF11E, 0xF885, 0xFD88, 0x0485, 0x0B38,
    0x1028, 0x0D4E, 0x17F0, 0x17A2, 0x1A0F, 0x172B, 0x16E7, 0x0BCA, 0x0772, 0x10B9, 0x0F66, 0x126A, 0x0F27, 0x13D5, 0x1143, 0x179F,
    0x1429, 0x118E, 0x102F, 0x1122, 0x1060, 0x043C, 0xFD62, 0xF5E9, 0xF718, 0xEA5D, 0xE2A0, 0xDAB6, 0xD3CB, 0xCF4E, 0xCB2C, 0xD331,
    0xDBB3, 0xDD4E, 0xDCDA, 0xE90F, 0xF107, 0xEC4A, 0xF3F7, 0xFB20, 0xFCF8, 0xF85E, 0xFA93, 0xFA75, 0xF9B0, 0xF3DE, 0xE9BE, 0xEEAA,
    0xEECB, 0xF052, 0xE686, 0xF102, 0xF04B, 0xF191, 0xF374, 0xFC87, 0x00CD, 0xFA75, 0x062D, 0x04D3, 0x07FB, 0x08E6, 0x1825, 0x1708,
    0x1673, 0x1ED0, 0x2DB9, 0x36F0, 0x3FAB, 0x4C22, 0x4A68, 0x4E6B, 0x4F50, 0x50B3, 0x4BC7, 0x453B, 0x40D4, 0x39EB, 0x316B, 0x2917,
    0x23DF, 0x1ACC, 0x11B4, 0x05E8, 0xF909, 0xF0EA, 0xE3A6, 0xE4C7, 0xE016, 0xDF78, 0xD919, 0xD170, 0xCF61, 0xD237, 0xDA7C, 0xD685,
    0xDD71, 0xDDD6, 0xE57C, 0xE492, 0xF045, 0xFBD7, 0xFE05, 0xFB0C, 0x015F, 0x11FB, 0x091C, 0x0D2B, 0x10AF, 0x1926, 0x1646, 0x1A7E,
    0x1FF0, 0x2000, 0x1F6B, 0x18FE, 0x1E3F, 0x1727, 0x1946, 0x1CE0, 0x190E, 0x112E, 0x100F, 0x123A, 0x1024, 0x15BB, 0x1A24, 0x19DF,
    0x1696, 0x1C9F, 0x1FC6, 0x185A, 0x17FC, 0x1494, 0x17A2, 0x1194, 0x0C8E, 0x1001, 0x1041, 0x074E, 0xFD8C, 0xFDC7, 0xED28, 0xE338,
    0xD6BC, 0xD490, 0xC5C4, 0xC3F1, 0xC4AB, 0xBCE1, 0xC168, 0xBCEA, 0xC7DC, 0xC402, 0xC3B7, 0xC8AF, 0xD0DF, 0xCE98, 0xD784, 0xD9F9,
    0xCADD, 0xCE83, 0xD6E5, 0xDBBB, 0xD7A0, 0xE202, 0xE72A, 0xEC02, 0xF719, 0x009A, 0x068D, 0x0B2B, 0x15D5, 0x1481, 0x18C4, 0x246D,
    0x2B11, 0x2B6B, 0x2AF1, 0x30ED, 0x2D3C, 0x3205, 0x3A56, 0x4220, 0x4169, 0x41D0, 0x49DA, 0x47A2, 0x46F4, 0x3FA1, 0x4298, 0x4028,
    0x3A8B, 0x2C83, 0x2D5F, 0x2DAF, 0x1C7C, 0x1A01, 0x12E5, 0x09A2, 0xFB98, 0xF959, 0xEE91, 0xF148, 0xF293, 0xEE82, 0xF005, 0xF5DA,
    0xFB2F, 0xF387, 0xFC59, 0xFD48, 0xF824, 0xF0E4, 0xF28E, 0xF31B, 0xE958, 0xE2A5, 0xE01C, 0xDE6D, 0xDD20, 0xE056, 0xDDC4, 0xD83F,
    0xDD0E, 0xDFAF, 0xE10F, 0xDC5E, 0xDDB8, 0xD9F5, 0xD336, 0xD211, 0xD65F, 0xE008, 0xDB4C, 0xDEB8, 0xE53E, 0xEBAE, 0xE7EA, 0xF925,
    0x06E3, 0x0A50, 0x15C4, 0x2699, 0x319B, 0x3032, 0x3943, 0x3954, 0x3A88, 0x3568, 0x33A7, 0x315D, 0x2F50, 0x2A07, 0x222B, 0x1C8E,
    0x0DFC, 0x0838, 0xFE66, 0xF49A, 0xF231, 0xEE5B, 0xE47A, 0xDB33, 0xDF24, 0xDD60, 0xD882, 0xD8E3, 0xE172, 0xE085, 0xDA5A, 0xE224,
    0xED2A, 0xF1E2, 0xEB07, 0xF4D4, 0xFBE3, 0xF7B0, 0xF9B0, 0xFD43, 0xFC94, 0xFA38, 0xFE00, 0xF71A, 0xF7E2, 0xF8CA, 0xF71D, 0xEFE2,
    0xEB54, 0xF489, 0xF528, 0xF7AB, 0xFAFC, 0x0528, 0x021E, 0x04E1, 0x0A6D, 0x0DD1, 0x09FC, 0x0C21, 0x1C05, 0x1EA6, 0x20C4, 0x1E14,
    0x25FA, 0x246A, 0x2251, 0x2030, 0x222A, 0x205E, 0x1A5C, 0x1FE1, 0x1C4E, 0x119E, 0x0948, 0x0566, 0xF1B6, 0xE92F, 0xEAB6, 0xDD70,
    0xD492, 0xD385, 0xD230, 0xC9F6, 0xCC5A, 0xD166, 0xCFA3, 0xCCB0, 0xD05C, 0xD7FA, 0xD56A, 0xD761, 0xD688, 0xDB4F, 0xDCC7, 0xDF2D,
    0xDFD7, 0xE15F, 0xE71A, 0xE6C8, 0xEB5F, 0xF1DA, 0xFE31, 0x02E3, 0x094F, 0x08B0, 0x0CAA, 0x1201, 0x11D1, 0x160F, 0x1870, 0x11E0,
    0x046D, 0x0AAD, 0x0ADF, 0xFF94, 0x0208, 0x12E8, 0x144E, 0x13F9, 0x1D92, 0x202E, 0x217E, 0x226A, 0x209C, 0x18ED, 0x1126, 0x092B,
    0x05C4, 0x0075, 0xF9ED, 0xF27B, 0xE8AA, 0xDF4D, 0xDD1A, 0xD97B, 0xD536, 0xD561, 0xD7E9, 0xD99B, 0xDCFD, 0xE4F3, 0xE948, 0xEBCD,
    0xE996, 0xEF53, 0xF3F4, 0xF53A, 0xF69D, 0xF6CB, 0xF1ED, 0xF006, 0xF25B, 0xEF85, 0xEB29, 0xEE52, 0xF330, 0xECCC, 0xEAB8, 0xEFA2,
    0xED51, 0xE8ED, 0xE707, 0xE59E, 0xE4DD, 0xE555, 0xE80C, 0xE7EF, 0xE4E6, 0xE498, 0xED36, 0xEFE0, 0xF578, 0xFD22, 0x0686, 0x09EE,
    0x0FD9, 0x17C5, 0x19E2, 0x1C2F, 0x18ED, 0x17C5, 0x0E9C, 0x075B, 0x00CA, 0x01D8, 0xFD57, 0xFA9B, 0xFA5D, 0xEF59, 0xE382, 0xDE36,
    0xDF75, 0xD3B9, 0xCE42, 0xCC60, 0xC899, 0xC31D, 0xC75A, 0xCE39, 0xCB35, 0xCD5D, 0xD2FF, 0xDEB4, 0xE303, 0xEA7C, 0xF0CD, 0xF584,
    0xFD1F, 0x048B, 0x0AED, 0x0E86, 0x1561, 0x1682, 0x1A10, 0x1885, 0x1D86, 0x238C, 0x2530, 0x20C2, 0x1D4C, 0x2130, 0x1D36, 0x1EE5,
    0x2301, 0x20B1, 0x196B, 0x1B60, 0x175E, 0x0FB3, 0x1533, 0x1A9A, 0x1C5A, 0x2145, 0x2DAA, 0x2CE3, 0x2C10, 0x3484, 0x35CA, 0x3118,
    0x30E2, 0x3491, 0x31DD, 0x2E46, 0x2910, 0x27A9, 0x2065, 0x1407, 0x06F9, 0xFBE9, 0xEEDD, 0xDCE5, 0xD0F5, 0xCB49, 0xC89A, 0xC550,
    0xCA1C, 0xC964, 0xC173, 0xBD9D, 0xC23B, 0xC416, 0xC0B3, 0xBE2F, 0xBA1D, 0xBA13, 0xBB1E, 0xBC63, 0xBC7E, 0xC247, 0xC565, 0xC684,
    0xCCBA, 0xD617, 0xDD86, 0xE38D, 0xEE77, 0xF232, 0xF6AC, 0xFF63, 0x065F, 0x0904, 0x0CF0, 0x0EA8, 0x125B, 0x170F, 0x188E, 0x1DE6,
    0x20B1, 0x256E, 0x2AA5, 0x3009, 0x33C3, 0x39E5, 0x3E66, 0x4059, 0x3CC9, 0x36B3, 0x33D7, 0x2E67, 0x2760, 0x208F, 0x1EF6, 0x1685,
    0x0B0B, 0x0458, 0xFD6B, 0xF6F0, 0xF31F, 0xF145, 0xEE9B, 0xEE65, 0xEE32, 0xF0D6, 0xF479, 0xF4EC, 0xF244, 0xEF50, 0xF084, 0xEF27,
    0xEBE5, 0xE714, 0xE8E7, 0xEBA5, 0xEB07, 0xEA22, 0xED43, 0xEECC, 0xED40, 0xF29D, 0xF646, 0xFA11, 0xFBAB, 0xF872, 0xF46C, 0xF6D6,
    0xF64A, 0xF56E, 0xFA3F, 0xFA50, 0xF80D, 0xF9A8, 0xFB1A, 0xF878, 0xFDBE, 0x0384, 0x08A8, 0x14A6, 0x1B8F, 0x1E89, 0x2445, 0x2A55,
    0x2A78, 0x2AC9, 0x2981, 0x264B, 0x1ED6, 0x1902, 0x1653, 0x10CE, 0x0BC1, 0x02D8, 0xFBDC, 0xF3E5, 0xEA25, 0xDE77, 0xD8D4, 0xD317,
    0xCB94, 0xC7B9, 0xCCA3, 0xCD66, 0xC533, 0xC76D, 0xCB1A, 0xCAE3, 0xCFE9, 0xDB70, 0xDC84, 0xDF73, 0xE859, 0xE9DC, 0xE84B, 0xEF96,
    0xF5E3, 0xF305, 0xF13F, 0xF06F, 0xF337, 0xF6DC, 0xF725, 0xF8AE, 0xFF3F, 0x0347, 0x042E, 0x07E3, 0x0AAC, 0x0CCF, 0x0FD2, 0x135D,
    0x12EF, 0x0E0A, 0x0A4C, 0x098A, 0x0B93, 0x0F13, 0x1365, 0x1575, 0x1B8D, 0x2469, 0x28B5, 0x27AA, 0x2DBE, 0x3461, 0x2FFE, 0x3375,
    0x3A5C, 0x3952, 0x32A7, 0x3022, 0x2AC0, 0x21A5, 0x18ED, 0x12BD, 0x0C0C, 0x0086, 0xF983, 0xF71E, 0xF8A4, 0xEFB8, 0xEBFA, 0xEE71,
    0xED7F, 0xE916, 0xE858, 0xE83E, 0xE3B7, 0xE22D, 0xDF72, 0xDF52, 0xD9CC, 0xD97D, 0xD844, 0xD4BD, 0xD1B6, 0xD7CA, 0xE052, 0xE2CC,
    0xE96B, 0xF0CA, 0xF353, 0xF2F6, 0xFC66, 0xFF22, 0xFC00, 0xFC71, 0xFED1, 0xFBDF, 0xF641, 0xF4F4, 0xF515, 0xF85F, 0xFB93, 0x00C6,
    0x0511, 0x094C, 0x12DA, 0x1B1D, 0x1E65, 0x1C4E, 0x1B5F, 0x14C6, 0x0F08, 0x0DC6, 0x0D15, 0x088A, 0xFFE5, 0xFCFC, 0xFA80, 0xF4FB,
    0xF02F, 0xF25D, 0xED29, 0xE9B8, 0xEF4D, 0xF5BF, 0xF6B9, 0xF663, 0xF9B8, 0xF937, 0xFD19, 0x00FF, 0x003C, 0xFF38, 0x02D1, 0xFEF5,
    0xF93B, 0xFAD1, 0xF8D4, 0xF5D9, 0xF304, 0xF104, 0xEE6F, 0xF19E, 0xF34A, 0xF3D8, 0xF779, 0xF709, 0xF747, 0xFD7C, 0x0314, 0x0183,
    0x07B4, 0x0EC5, 0x11A4, 0x12A3, 0x19F6, 0x1F06, 0x1FCC, 0x2330, 0x29DA, 0x2C01, 0x2D1B, 0x31C2, 0x3107, 0x305B, 0x2E19, 0x2B77,
    0x1F9F, 0x217E, 0x1DEB, 0x1676, 0x1063, 0x0C6B, 0x01A8, 0xF465, 0xF274, 0xE51E, 0xD8AA, 0xC611, 0xC066, 0xBB5C, 0xBB6F, 0xB7ED,
    0xB720, 0xBA71, 0xB91B, 0xBFF3, 0xC88D, 0xD39D, 0xD45C, 0xE376, 0xEAD5, 0xED98, 0xF21E, 0xFA39, 0xFFD8, 0xFB70, 0x0066, 0x03F7,
    0x0B18, 0x08AD, 0x107C, 0x1232, 0x1006, 0x1340, 0x1618, 0x18F4, 0x14B8, 0x1DCC, 0x1B62, 0x1B27, 0x187C, 0x1882, 0x13B4, 0x0FAA,
    0x12EF, 0x11AF, 0x1626, 0x14EE, 0x1FA0, 0x23C8, 0x29E3, 0x2E49, 0x3429, 0x3563, 0x3353, 0x3716, 0x32F5, 0x33C4, 0x2F40, 0x2B8C,
    0x1F6C, 0x1925, 0x1184, 0x0641, 0xF61F, 0xE6AC, 0xE3A9, 0xDD07, 0xD620, 0xD39B, 0xD46F, 0xCD80, 0xCF8F, 0xD6A4, 0xD5C0, 0xD163,
    0xD322, 0xD314, 0xCF59, 0xD019, 0xD21C, 0xD199, 0xD1D1, 0xD13B, 0xD30C, 0xD8FD, 0xDCEF, 0xE429, 0xEAE0, 0xEEDF, 0xF218, 0xF8E5,
    0xFB16, 0xFAFB, 0x00F5, 0x052E, 0x050E, 0x04A4, 0x07D1, 0x023E, 0xFC8E, 0x00BE, 0x02E1, 0x0064, 0x0011, 0x0DEF, 0x1108, 0x134D,
    0x1AE8, 0x22EC, 0x2116, 0x1FB2, 0x24C8, 0x20FF, 0x2315, 0x1DA8, 0x1D2F, 0x162F, 0x164F, 0x12F4, 0x1167, 0x0E82, 0x0479, 0x0324,
    0xFBDF, 0xFBE9, 0xF679, 0xFAB0, 0xF2B9, 0xF376, 0xF868, 0xF505, 0xF2DE, 0xF260, 0xF8A1, 0xF034, 0xF81E, 0xFABC, 0xFD7E, 0xF8F0,
    0xFC2E, 0xFE89, 0xF9D6, 0xFD34, 0xFAB2, 0xFE1A, 0xF55F, 0xFC89, 0xFB31, 0xF904, 0xF71D, 0xF941, 0xFE5B, 0xFF40, 0x0852, 0x089D,
    0x0F30, 0x0B62, 0x0FA6, 0x139A, 0x1786, 0x1B8B, 0x2073, 0x2CF4, 0x2D88, 0x355A, 0x3897, 0x3B14, 0x364A, 0x35A2, 0x3530, 0x2F73,
    0x2D6C, 0x2353, 0x1FF3, 0x163B, 0x1238, 0x07BA, 0xFF48, 0xF217, 0xE35F, 0xD973, 0xCF4C, 0xCC5C, 0xC314, 0xC084, 0xBF92, 0xC2A0,
    0xBCCE, 0xBF93, 0xC6EB, 0xC7C3, 0xC669, 0xC981, 0xCF57, 0xCEF6, 0xCF97, 0xCF96, 0xCFBF, 0xCD88, 0xCDCE, 0xCF19, 0xCFFB, 0xCF34,
    0xD2FE, 0xD7A5, 0xD9EA, 0xD9F3, 0xDFE0, 0xE6D3, 0xEE3F, 0xF69B, 0xFA8B, 0xFB13, 0xF74C, 0xFBBC, 0xFAD4, 0xF8AF, 0xF983, 0xFEE6,
    0x018C, 0x0830, 0x18FA, 0x2028, 0x26A2, 0x2C2A, 0x365A, 0x3484, 0x3972, 0x40F6, 0x3FD7, 0x3DA1, 0x3A45, 0x3CBB, 0x35B4, 0x30CC,
    0x22B1, 0x1C7C, 0x12E5, 0x087D, 0x0230, 0xFA70, 0xF4EC, 0xED31, 0xF2B4, 0xED9F, 0xEEF7, 0xF254, 0xF446, 0xEEB5, 0xECF3, 0xF3FF,
    0xEFFD, 0xF522, 0xF5DF, 0xFA60, 0xF472, 0xF697, 0xFAF5, 0xFA37, 0xFD73, 0xFCC4, 0x0450, 0x00A4, 0x0687, 0x01F4, 0x0525, 0x0439,
    0x03F7, 0x046F, 0xFD9A, 0xFA59, 0xF11D, 0xF6FB, 0xEBEA, 0xEC7D, 0xECE7, 0xEF2E, 0xEF5A, 0xF4FC, 0xFFB3, 0xF949, 0xF7C0, 0xF5D7,
    0xF5D2, 0xEE23, 0xF163, 0xEFB8, 0xEA82, 0xE9FC, 0xEB69, 0xF127, 0xF060, 0xF041, 0xEC3A, 0xEE15, 0xEC07, 0xEA2C, 0xEA44, 0xE986,
    0xEA02, 0xE576, 0xEAB1, 0xEE10, 0xF020, 0xEF80, 0xF386, 0xF63B, 0xF1A0, 0xF1FC, 0xF414, 0xF6F6, 0xF3FC, 0xF477, 0xF4DE, 0xF559,
    0xF424, 0xF0BE, 0xF1D7, 0xF2E7, 0xF3C0, 0xF32D, 0xF78F, 0xFC4E, 0xFDEB, 0x032D, 0x0A3B, 0x10B6, 0x12EE, 0x17F4, 0x1B95, 0x1A45,
    0x1BA3, 0x1B70, 0x1C80, 0x1CF2, 0x2430, 0x26D8, 0x2780, 0x2886, 0x237F, 0x2139, 0x1FD8, 0x2572, 0x1F23, 0x1DB9, 0x1B8E, 0x1AC9,
    0x1A6A, 0x1749, 0x105A, 0x00EE, 0xFB13, 0xEB6E, 0xE603, 0xDC74, 0xD6A0, 0xD07A, 0xCEF7, 0xCF70, 0xCD03, 0xD735, 0xD7EC, 0xDF2B,
    0xE07A, 0xEAE8, 0xEBD1, 0xF096, 0xF6FA, 0xF55A, 0xF720, 0xF3B5, 0xFA6F, 0xF2E2, 0xF4D9, 0xF179, 0xF27A, 0xF07A, 0xEC89, 0xF011,
    0xF019, 0xF5CD, 0xF30E, 0xFD81, 0xFB08, 0xFB26, 0xF867, 0xFB6A, 0xFC25, 0xF733, 0x0085, 0xFEF4, 0x0673, 0x094B, 0x16D9, 0x1972,
    0x23F1, 0x2E42, 0x2A57, 0x2F71, 0x3153, 0x35E4, 0x2B72, 0x302E, 0x2CB8, 0x2CA5, 0x29C5, 0x239D, 0x1B09, 0x0DD4, 0x0A59, 0xFD6F,
    0xFD13, 0xF31D, 0xEF1F, 0xE85F, 0xE6AF, 0xE453, 0xDEBC, 0xDFDE, 0xDAFC, 0xD9E0, 0xD548, 0xD8AD, 0xD5C4, 0xD562, 0xD7CE, 0xDA01,
    0xDDB3, 0xE09B, 0xE83F, 0xEA0A, 0xF016, 0xF434, 0xF934, 0xFE50, 0x0150, 0x035F, 0x0561, 0x0DBB, 0x10FF, 0x1318, 0x13DD, 0x154B,
    0x13D3, 0x0F20, 0x0DE9, 0x0CB0, 0x0903, 0x0601, 0x0943, 0x0E3C, 0x0DCF, 0x12C4, 0x145C, 0x1342, 0x0F33, 0x106D, 0x12BC, 0x0E82,
    0x0A16, 0x047B, 0x07B1, 0x00C4, 0xFDE3, 0xFC37, 0xFB77, 0xF24A, 0xEBC0, 0xECDC, 0xE430, 0xE025, 0xDB30, 0xDB36, 0xD365, 0xD520,
    0xD481, 0xCFCA, 0xD0BF, 0xD116, 0xD640, 0xD127, 0xD9A5, 0xD9B5, 0xDD8C, 0xDF96, 0xE753, 0xEBFD, 0xE6FE, 0xEC4C, 0xE9EB, 0xF1DC,
    0xEAC1, 0xF280, 0xF165, 0xF5A0, 0xF88A, 0x0005, 0x0B7A, 0x09D0, 0x14F7, 0x15D9, 0x1E40, 0x1970, 0x2445, 0x244C, 0x22C2, 0x2905,
    0x2E8C, 0x364B, 0x334B, 0x3E30, 0x38C4, 0x3B02, 0x388B, 0x3A7C, 0x38EF, 0x325A, 0x3139, 0x2AAA, 0x3027, 0x22CF, 0x2106, 0x1A85,
    0x163D, 0x093A, 0x0509, 0x0534, 0xF805, 0xF7D2, 0xF0BF, 0xEF83, 0xE52B, 0xEC78, 0xEA73, 0xE92C, 0xEA10, 0xE98E, 0xEA69, 0xE835,
    0xEEA9, 0xE795, 0xE861, 0xE66C, 0xE4B3, 0xDD13, 0xD89F, 0xD8D6, 0xD671, 0xD9D5, 0xD6B4, 0xD75A, 0xD361, 0xD669, 0xD728, 0xDA72,
    0xDEB3, 0xDCDD, 0xDD88, 0xDD0F, 0xE021, 0xDC79, 0xDDCA, 0xDE1D, 0xE26F, 0xE5E6, 0xEF44, 0xFC68, 0x076F, 0x0D34, 0x1596, 0x20D0,
    0x288F, 0x2C52, 0x2FF5, 0x3236, 0x30EA, 0x32F4, 0x32E4, 0x3445, 0x2DFC, 0x29F7, 0x2096, 0x1A1A, 0x0D46, 0x06D3, 0x0389, 0xFBE2,
    0xF4A2, 0xF213, 0xF583, 0xEF63, 0xF190, 0xF34D, 0xF579, 0xF4F4, 0xF7E9, 0xFE66, 0xFF38, 0x02CB, 0x0166, 0x0880, 0x07E2, 0x0B54,
    0x0E5E, 0x0E3A, 0x137A, 0x11B9, 0x15EA, 0x1019, 0x13D2, 0x1292, 0x14C5, 0x0C39, 0x0D84, 0x0A34, 0x0424, 0x0372, 0x02CB, 0x04D3,
    0xF556, 0xFC45, 0xF9A3, 0x009B, 0x01FA, 0x1069, 0x1092, 0x0AD2, 0x146F, 0x1362, 0x158D, 0x0BC8, 0x1302, 0x0AD4, 0x0BA3, 0x09B8,
    0x0A41, 0x0AE2, 0x012E, 0x0344, 0xFD2E, 0xFF04, 0xF15D, 0xF428, 0xEB14, 0xE1FF, 0xDBF6, 0xD96D, 0xD631, 0xCC60, 0xD291, 0xCA9B,
    0xCD0D, 0xC849, 0xCFD3, 0xCDC1, 0xD179, 0xD476, 0xD5EC, 0xDB0F, 0xDC8D, 0xE2D1, 0xE22D, 0xED61, 0xEED2, 0xF1FB, 0xF495, 0xFA95,
    0xFCC2, 0xFE39, 0x06AB, 0x0B16, 0x12CD, 0x13AD, 0x16F8, 0x1AF3, 0x1E3D, 0x1AD4, 0x173E, 0x1C29, 0x19E2, 0x1D50, 0x2326, 0x27B8,
    0x24EF, 0x2AA2, 0x303D, 0x32AE, 0x328F, 0x31E3, 0x2F95, 0x2EA1, 0x312A, 0x2E03, 0x298D, 0x241D, 0x1F2C, 0x12B8, 0x0A0E, 0x018C,
    0xFCBA, 0xEF41, 0xE829, 0xE4B4, 0xE127, 0xDCA2, 0xDE01, 0xE3A0, 0xE364, 0xE7A0, 0xEB72, 0xF2B2, 0xF2E3, 0xF59D, 0xF9DF, 0x004A,
    0x0164, 0xFDBE, 0x0266, 0x01B4, 0x0309, 0x0167, 0x066D, 0x02E2, 0x00DE, 0x01DA, 0xFE1B, 0xFFCA, 0xFD7A, 0x0460, 0xFD1F, 0x0281,
    0xFF28, 0xFE8A, 0xF5A9, 0xF2F9, 0xF0DC, 0xE72F, 0xEBD1, 0xF0C8, 0xFC30, 0xF715, 0x038E, 0x0798, 0x0ED9, 0x10FA, 0x1365, 0x144B,
    0x1152, 0x1498, 0x0FAF, 0x128E, 0x0C4E, 0x0869, 0x02D0, 0xFEBD, 0xF8B2, 0xF156, 0xEF71, 0xE344, 0xE56C, 0xE48E, 0xDF88, 0xDB62,
    0xDB1D, 0xD9C9, 0xD35E, 0xD7B9, 0xDA2C, 0xDB28, 0xD79C, 0xDEC0, 0xDF9F, 0xE51F, 0xE7AE, 0xEEEB, 0xF67D, 0xFD68, 0x05B2, 0x08ED,
    0x1115, 0x0FC8, 0x1364, 0x1589, 0x1DCB, 0x20BA, 0x20C7, 0x250A, 0x2677, 0x266B, 0x21F8, 0x23EE, 0x21CE, 0x1C76, 0x14EA, 0x1689,
    0x1E1E, 0x1D61, 0x2116, 0x295F, 0x3312, 0x30FA, 0x3742, 0x3B45, 0x388B, 0x3467, 0x3551, 0x331B, 0x2F76, 0x30E8, 0x2D62, 0x2625,
    0x1FE6, 0x1B61, 0x112B, 0x0976, 0xFF16, 0xF885, 0xF047, 0xEA1F, 0xE109, 0xDD6A, 0xD6A8, 0xD37B, 0xD39C, 0xD476, 0xD14C, 0xCE37,
    0xD10D, 0xD0C2, 0xD003, 0xCFBB, 0xD2AF, 0xCE39, 0xD08F, 0xD76F, 0xDB7C, 0xDAC7, 0xDE4B, 0xE3AF, 0xE21F, 0xE5EE, 0xF02C, 0xF7D9,
    0xFB15, 0x0160, 0x0B9C, 0x0CC7, 0x1040, 0x0F9D, 0x1092, 0x0C33, 0x1151, 0x185C, 0x1CFB, 0x2231, 0x2655, 0x2E11, 0x2EE1, 0x36C7,
    0x3645, 0x3A2F, 0x37D5, 0x3818, 0x372D, 0x394C, 0x385F, 0x3524, 0x3786, 0x3042, 0x296C, 0x24AC, 0x228D, 0x1431, 0x09C8, 0x05BC,
    0xFC1B, 0xF519, 0xF360, 0xF4FD, 0xED3D, 0xEC8B, 0xEE46, 0xED55, 0xE947, 0xE85D, 0xEB70, 0xE874, 0xE904, 0xE405, 0xE29B, 0xDF88,
    0xE2E0, 0xE2FF, 0xE479, 0xE487, 0xE3D5, 0xE5AA, 0xE6C4, 0xEAA9, 0xEF9E, 0xF3FB, 0xF4F7, 0xFA2B, 0x0021, 0xFFBB, 0xFBA4, 0xF7B8,
    0xF137, 0xEDD7, 0xEE4E, 0xF418, 0xF8BC, 0x0041, 0x02FE, 0x0C3C, 0x15D3, 0x19F8, 0x170A, 0x1CB5, 0x22C6, 0x1F52, 0x1E13, 0x2228,
    0x22EE, 0x1997, 0x15BE, 0x13E0, 0x0EC4, 0x056B, 0xFFBD, 0xFA08, 0xF3C0, 0xEDC7, 0xEA92, 0xE990, 0xEB40, 0xE878, 0xE971, 0xEB71,
    0xEEA2, 0xED1C, 0xF0C9, 0xF2DA, 0xF431, 0xF817, 0xFA2E, 0xFAC1, 0xFC22, 0x02AB, 0xFFCD, 0x050D, 0x09E8, 0x0B82, 0x086E, 0x0E0D,
    0x1334, 0x1263, 0x13AF, 0x1565, 0x191B, 0x1A21, 0x1FB4, 0x21CE, 0x1FA5, 0x193C, 0x1382, 0x1377, 0x1153, 0x11F2, 0x110D, 0x152E,
    0x17DB, 0x1C65, 0x1E33, 0x1E41, 0x1E08, 0x1ABD, 0x1C38, 0x1AD7, 0x1D19, 0x1F04, 0x228B, 0x1CA8, 0x1C30, 0x1E10, 0x1802, 0x0F4B,
    0x0E94, 0x0D25, 0x02ED, 0xFC95, 0xFAC3, 0xF5D0, 0xED34, 0xE93A, 0xE91B, 0xE45F, 0xDECD, 0xDCB1, 0xDAF3, 0xD959, 0xD874, 0xD9BF,
    0xD7D3, 0xDA3E, 0xD8C9, 0xD811, 0xD671, 0xD727, 0xD3AD, 0xD32F, 0xD249, 0xD09F, 0xD530, 0xD937, 0xDA5B, 0xDE51, 0xE8CF, 0xEE2E,
    0xF4B3, 0xFA8B, 0xF8D0, 0xF48A, 0xF78D, 0xF983, 0xFA46, 0xFDAF, 0x03B0, 0x0809, 0x117C, 0x16B4, 0x1A63, 0x1C1A, 0x1FD0, 0x22DE,
    0x26D9, 0x2BD4, 0x2E6D, 0x30F4, 0x2CB6, 0x2B6E, 0x25DE, 0x2028, 0x160F, 0x0FD7, 0x08E6, 0x0254, 0xFEC1, 0xFA60, 0xF7F9, 0xF316,
    0xF555, 0xF6A8, 0xF8DF, 0xFA58, 0xFE60, 0xFF1C, 0xFEF6, 0x0920, 0x0BE1, 0x06F4, 0x0614, 0x0FA0, 0x09D0, 0x04DE, 0x090F, 0x0CEF,
    0x0707, 0x049A, 0x084F, 0x0A51, 0x0F72, 0x0AB1, 0x1031, 0x12AC, 0x1578, 0x120E, 0x170D, 0x1961, 0x0FC2, 0x0B1B, 0x05F9, 0x0970,
    0x0523, 0x0634, 0x0A28, 0x1279, 0x1A6C, 0x196B, 0x2051, 0x202E, 0x24C5, 0x20D7, 0x205D, 0x25AA, 0x2366, 0x1C88, 0x143C, 0x1B1D,
    0x0DD7, 0x0153, 0xF865, 0xF389, 0xE94F, 0xDDAB, 0xD967, 0xD302, 0xCF10, 0xC562, 0xC5B0, 0xC6FE, 0xC303, 0xBF48, 0xC072, 0xC3B4,
    0xC6DC, 0xCB3C, 0xCF85, 0xD28E, 0xDA88, 0xDC2B, 0xE0D6, 0xE752, 0xEC79, 0xF045, 0xF0E4, 0xF7AC, 0xFD3E, 0x01E4, 0xFFFC, 0x05CF,
    0x0D9C, 0x0DF0, 0x1048, 0x1772, 0x18F0, 0x11EF, 0x106C, 0x1025, 0x12D2, 0x1441, 0x116B, 0x17A6, 0x20F6, 0x2304, 0x22E1, 0x2EBD,
    0x34BF, 0x2E43, 0x2FA6, 0x31E6, 0x329A, 0x31E4, 0x319B, 0x32B3, 0x326D, 0x3016, 0x279D, 0x239D, 0x1E2B, 0x1596, 0x0ED0, 0x0A4F,
    0x0647, 0xF987, 0xF248, 0xEE07, 0xE95B, 0xE2D1, 0xDF05, 0xDF0E, 0xD973, 0xDFD8, 0xE146, 0xDE57, 0xDFA4, 0xE3AA, 0xE006, 0xD98D,
    0xE4E3, 0xDFFF, 0xDC50, 0xDDA0, 0xE2B9, 0xE088, 0xE257, 0xEA8A, 0xE7FC, 0xED29, 0xED81, 0xF825, 0xFBC3, 0xFCAE, 0xFBD8, 0xFE92,
    0xFE1D, 0xF7FB, 0xFB8F, 0xF996, 0xF9E0, 0xF9C7, 0xFFE4, 0x041B, 0x0815, 0x0DB3, 0x130E, 0x17B8, 0x192B, 0x1F26, 0x24A2, 0x25EB,
    0x291F, 0x2D27, 0x29DD, 0x291D, 0x2A21, 0x240E, 0x1973, 0x1680, 0x10A9, 0x07DF, 0x0476, 0xFFAC, 0xFEBC, 0xF966, 0xF64C, 0xF4F3,
    0xF551, 0xF0D9, 0xF210, 0xFE2B, 0xFA4E, 0xF5ED, 0xF6A3, 0xF8EA, 0xF172, 0xF0A7, 0xF50A, 0xF10A, 0xF088, 0xEB95, 0xF040, 0xF161,
    0xF16E, 0xEF9D, 0xF1F5, 0xF5A1, 0xF4FB, 0xFD2E, 0xFD35, 0xFF0C, 0xFCC0, 0xFA6E, 0xF970, 0xF917, 0xF8AF, 0xF794, 0xFE6D, 0x03AB,
    0x0CBA, 0x1605, 0x1B4C, 0x23B2, 0x2B11, 0x2E35, 0x2E74, 0x353D, 0x374D, 0x319C, 0x32F2, 0x3101, 0x2C5E, 0x25BC, 0x206E, 0x19AA,
    0x108E, 0x07BA, 0xFC08, 0xF748, 0xF074, 0xE9CD, 0xE447, 0xE007, 0xDF58, 0xD9A2, 0xD5C0, 0xD85D, 0xD985, 0xD572, 0xD7D2, 0xDB66,
    0xD631, 0xD4C1, 0xDD43, 0xDE04, 0xE0B5, 0xE455, 0xE9A1, 0xEB04, 0xF341, 0xF637, 0xF05A, 0xF544, 0xF247, 0xF604, 0xF7E5, 0x0217,
    0xFF00, 0xFFDD, 0x01EC, 0xFF6A, 0x02A8, 0xFD90, 0x0047, 0xFD59, 0x0529, 0x039A, 0x0762, 0x0F35, 0x126B, 0x17D6, 0x16F9, 0x2342,
    0x22FE, 0x2434, 0x278C, 0x30E5, 0x32F3, 0x31EB, 0x3BD5, 0x3758, 0x359E, 0x323D, 0x31FB, 0x257F, 0x20F7, 0x187C, 0x0DDD, 0x0658,
    0xFE75, 0xFAD3, 0xF27A, 0xEB5D, 0xE9F8, 0xEB23, 0xE53A, 0xE5F8, 0xEA0C, 0xEE2F, 0xE444, 0xEBB0, 0xEBCE, 0xEABA, 0xEA0A, 0xE930,
    0xE8B8, 0xE73B, 0xEBAD, 0xE767, 0xED5E, 0xEA8E, 0xEB8D, 0xF0F1, 0xFA44, 0xFE31, 0x0011, 0x0836, 0x085C, 0x07BE, 0x0354, 0xFE8E,
    0xFA3E, 0xF57B, 0xF906, 0xF6C4, 0xFA72, 0xFC18, 0xFFB9, 0xFD70, 0xFEA3, 0x0522, 0x021C, 0x0390, 0x0746, 0x0D5A, 0x0886, 0x0C36,
    0x097F, 0x05E3, 0x00CD, 0xFDFA, 0xF940, 0xF74D, 0xF3F5, 0xEE7E, 0xF018, 0xF2D5, 0xF451, 0xEE92, 0xF46A, 0xF49E, 0xF9AE, 0xF57B,
    0xFDFC, 0xFF49, 0xFF5B, 0xFF51, 0xFE3F, 0x0278, 0xFC64, 0x0372, 0xFAD4, 0x020C, 0xFF83, 0x049E, 0x040F, 0x08F1, 0x0B5C, 0x0653,
    0x1081, 0x0DE1, 0x165F, 0x1609, 0x1CBE, 0x14EB, 0x1866, 0x16AB, 0x0F91, 0x0D82, 0x0B99, 0x0D9A, 0x0AD4, 0x14DE, 0x1985, 0x1CEB,
    0x1F8E, 0x25DF, 0x2494, 0x225F, 0x2241, 0x226D, 0x1FB6, 0x21C6, 0x228F, 0x1C10, 0x18FB, 0x1585, 0x0D96, 0x058C, 0x045A, 0xFD90,
    0xF264, 0xF03D, 0xEB6A, 0xE6F7, 0xDDCD, 0xDA21, 0xD72C, 0xD618, 0xD2FB, 0xCF00, 0xD858, 0xD28E, 0xD48C, 0xD3EF, 0xDE61, 0xDAD9,
    0xDB5B, 0xDD4E, 0xDCD2, 0xE09A, 0xDA9B, 0xE2B2, 0xE1BE, 0xE6C9, 0xDD91, 0xE4F3, 0xE8F4, 0xEA97, 0xEEFF, 0xF561, 0xFDDF, 0xFD0B,
    0x033A, 0x00C1, 0x05E8, 0x05B2, 0x0807, 0x07CC, 0x128F, 0x1AAE, 0x1F06, 0x2353, 0x2878, 0x2999, 0x27ED, 0x2CDA, 0x2B07, 0x2FC5,
    0x3054, 0x366C, 0x3157, 0x3646, 0x3538, 0x30B4, 0x2DEA, 0x2BDA, 0x272C, 0x1707, 0x1774, 0x1139, 0x0C99, 0x02E6, 0x007B, 0xFA3A,
    0xF333, 0xF44C, 0xF110, 0xF2BF, 0xF188, 0xF30C, 0xEF63, 0xEEFD, 0xF213, 0xEDAC, 0xEE74, 0xEBF7, 0xECF6, 0xEB0E, 0xEED5, 0xEED0,
    0xEC38, 0xF1F8, 0xF568, 0xFAD1, 0xFE0D, 0x08E5, 0x092B, 0x0D8B, 0x1239, 0x15C3, 0x116A, 0x121C, 0x0FFC, 0x08CD, 0x04BE, 0x0705,
    0x097B, 0x0700, 0x112C, 0x1225, 0x13D0, 0x0E60, 0x18DE, 0x150B, 0x157C, 0x16DF, 0x1A18, 0x1AB6, 0x1545, 0x16DC, 0x0A08, 0x091F,
    0xFCED, 0xF925, 0xEF86, 0xECBE, 0xE58E, 0xE501, 0xE5DC, 0xDDF1, 0xDF50, 0xDDE3, 0xDEEB, 0xDB8F, 0xE1AF, 0xDFCE, 0xDD34, 0xDE83,
    0xE26C, 0xE009, 0xDF51, 0xE0D4, 0xDDA9, 0xD900, 0xDBDD, 0xE138, 0xE185, 0xE2F7, 0xE550, 0xE931, 0xE937, 0xEDD6, 0xF454, 0xFB33,
    0xFD8C, 0x015C, 0x08C1, 0x0780, 0x03F3, 0x07E3, 0x0C9B, 0x0EE3, 0x104D, 0x1C2C, 0x1E88, 0x253A, 0x28FF, 0x30AC, 0x3569, 0x360B,
    0x38BA, 0x351A, 0x3D24, 0x32A5, 0x3707, 0x3449, 0x3810, 0x2DFC, 0x2D65, 0x2C10, 0x2088, 0x1C09, 0x11D1, 0x12E2, 0x0642, 0x08E5,
    0xFF4C, 0xFF3B, 0xF63A, 0xF300, 0xEBB1, 0xE9D1, 0xEB50, 0xE8FB, 0xE9FE, 0xEA8A, 0xF23A, 0xEF99, 0xF668, 0xF2B7, 0xF590, 0xF353,
    0xFAC0, 0xF5A2, 0xF60F, 0xF646, 0xEEC2, 0xEB2A, 0xE992, 0xED22, 0xE38B, 0xE967, 0xE96C, 0xECE4, 0xECDE, 0xEC54, 0xEB09, 0xE97B,
    0xECD1, 0xE5E2, 0xEABF, 0xEFE5, 0xF283, 0xF1E5, 0xF6D4, 0x018E, 0xFFDE, 0x048F, 0x09E5, 0x1769, 0x1A10, 0x1E61, 0x2705, 0x299A,
    0x2C4D, 0x2934, 0x2EB9, 0x2ADD, 0x29A2, 0x1CBF, 0x17F2, 0x13BF, 0x0A8D, 0xFF3D, 0xFE0C, 0xFEB6, 0xF158, 0xEE18, 0xEE18, 0xEF17,
    0xE823, 0xF139, 0xF1C6, 0xF5D5, 0xF552, 0xFCF1, 0xF9C9, 0xF4AD, 0xF521, 0xF09C, 0xF39E, 0xEEE7, 0xF791, 0xEF0E, 0xF69F, 0xF5C2,
    0xFBE3, 0xFC4E, 0x010B, 0x095D, 0x0A52, 0x1255, 0x0BC2, 0x1184, 0x09F2, 0x0857, 0x029B, 0x0603, 0x0334, 0xFF4C, 0x04E6, 0x04DC,
    0x091D, 0x09FA, 0x101B, 0x11D5, 0x1862, 0x19EB, 0x1C7B, 0x2113, 0x1ECF, 0x197D, 0x18EC, 0x18AC, 0x11E9, 0x0C69, 0x0578, 0xFF5C,
    0xF9AD, 0xFA01, 0xEFBF, 0xED90, 0xEA3A, 0xE5FE, 0xE182, 0xDE31, 0xE290, 0xDAA3, 0xDE90, 0xD8F5, 0xE069, 0xDD97, 0xE1E1, 0xE4C6,
    0xE25A, 0xEB3D, 0xE6B4, 0xEF68, 0xEFE7, 0x017D, 0xFAEF, 0xFFA6, 0x092A, 0x0941, 0x0A0E, 0x08F2, 0x1501, 0x0B60, 0x1398, 0x101E,
    0x15C4, 0x1403, 0x12F2, 0x1143, 0x1216, 0x18BD, 0x1127, 0x1BA4, 0x1F94, 0x28CF, 0x26B9, 0x2FE0, 0x2F66, 0x2F11, 0x2F9C, 0x3025,
    0x3417, 0x2E72, 0x30C3, 0x2ADD, 0x2EA5, 0x2687, 0x2687, 0x1EF8, 0x1C05, 0x1857, 0x0E0D, 0x0B8C, 0x0186, 0xFD18, 0xECF4, 0xEE67,
    0xE72C, 0xE1E5, 0xDFF7, 0xDE5C, 0xE03B, 0xDAA5, 0xE5D0, 0xE3ED, 0xEA87, 0xE641, 0xEA46, 0xEBD1, 0xE8F0, 0xEBF6, 0xE985, 0xF06F,
    0xE742, 0xED91, 0xECCB, 0xF0ED, 0xED95, 0xF001, 0xF791, 0xF524, 0xF83C, 0xFB1D, 0x04E9, 0xFECC, 0x0103, 0x02CC, 0x0023, 0xFB8E,
    0xFDA5, 0xFDDC, 0xFBC7, 0x0011, 0x03DD, 0x061E, 0x0966, 0x0C4C, 0x0DC5, 0x146D, 0x1457, 0x1589, 0x1833, 0x1E16, 0x1BFA, 0x1C3E,
    0x1A9D, 0x12EF, 0x0D09, 0x060C, 0x03D3, 0xFB7E, 0xF623, 0xEE39, 0xE9AF, 0xE550, 0xE1F7, 0xE464, 0xE438, 0xE6DB, 0xE605, 0xEA48,
    0xED72, 0xEE38, 0xED5E, 0xEF62, 0xF384, 0xF282, 0xF6A7, 0xFB5D, 0xFC04, 0xFD61, 0x04E7, 0x06B2, 0x08C6, 0x0E09, 0x11FF, 0x10CF,
    0x1874, 0x1C6E, 0x1BA5, 0x1FCB, 0x2085, 0x1F80, 0x17B5, 0x1B53, 0x1457, 0x1889, 0x16BA, 0x1951, 0x1F20, 0x2266, 0x2880, 0x27A0,
    0x36E3, 0x302F, 0x364A, 0x346F, 0x38F2, 0x30EE, 0x2BEC, 0x2EC5, 0x24E8, 0x23FB, 0x15F8, 0x1887, 0x0B30, 0x0A2D, 0x0149, 0xFBD8,
    0xF79B, 0xEF45, 0xED55, 0xE3A5, 0xE8E4, 0xDF82, 0xDB9A, 0xD411, 0xD60A, 0xD271, 0xCCD8, 0xCCC1, 0xC9A4, 0xCA9A, 0xC264, 0xC82B,
    0xCA10, 0xCD51, 0xC8BC, 0xCFD3, 0xD4BF, 0xD1CE, 0xD491, 0xD763, 0xE20E, 0xDF07, 0xEA20, 0xEC4A, 0xF48A, 0xF243, 0xFA46, 0x01D5,
    0x0002, 0x06D7, 0x0504, 0x0E4B, 0x0622, 0x161E, 0x15EB, 0x2021, 0x227A, 0x27C2, 0x2EDC, 0x2A46, 0x310F, 0x28B1, 0x36B2, 0x2B0D,
    0x3218, 0x3270, 0x355F, 0x2EF9, 0x2D02, 0x32AC, 0x22AA, 0x240A, 0x1C6D, 0x1D22, 0x0B57, 0x06BF, 0xFE7B, 0xF792, 0xF563, 0xF01A,
    0xF133, 0xEEBD, 0xF497, 0xEF3A, 0xF267, 0xF5B0, 0xF6DD, 0xF584, 0xFD0B, 0x0433, 0xFD27, 0xFC37, 0xFD89, 0xFBA3, 0xF3CF, 0xF715,
    0xF487, 0xF32F, 0xF58A, 0xF627, 0xF6A3, 0xFAC3, 0x0174, 0xFC54, 0x0697, 0x0759, 0x0640, 0xFEE3, 0x01F0, 0xFEB0, 0xFB9B, 0x0219,
    0xFFBF, 0x05A4, 0x0345, 0x0C85, 0x08CA, 0x1060, 0x0DA8, 0x0DF9, 0x0FCF, 0x0FFE, 0x12C9, 0x0F89, 0x1485, 0x0C54, 0x0BC7, 0x0318,
    0x0047, 0xF66E, 0xF3C7, 0xEE9F, 0xEA4F, 0xE6E1, 0xE608, 0xE77E, 0xE50D, 0xE6DB, 0xE4B4, 0xE9D3, 0xE625, 0xEBBE, 0xE7EC, 0xE922,
    0xE0A7, 0xE238, 0xE2D4, 0xE01A, 0xE3D3, 0xE445, 0xEB8A, 0xE508, 0xEF90, 0xECB5, 0xF199, 0xF4C3, 0x004C, 0x08A5, 0x09CA, 0x149D,
    0x1292, 0x17B8, 0x1088, 0x16B7, 0x145B, 0x1208, 0x1281, 0x1271, 0x197E, 0x148C, 0x1D8D, 0x1DEB, 0x28E8, 0x28DF, 0x2BEF, 0x2FDE,
    0x2C1F, 0x2AD1, 0x252F, 0x304A, 0x258E, 0x26C9, 0x210B, 0x2285, 0x1747, 0x14D7, 0x125D, 0x07DF, 0x068D, 0xFC38, 0xFD35, 0xF095,
    0xF875, 0xEC4D, 0xEE1A, 0xE7C4, 0xE959, 0xE33D, 0xE19E, 0xE810, 0xDF92, 0xE6E7, 0xE124, 0xEBD7, 0xE1CF, 0xEF03, 0xEAE8, 0xEB25,
    0xECD3, 0xEDF7, 0xEE86, 0xE373, 0xEDFB, 0xE26D, 0xE7EC, 0xE3F7, 0xEC54, 0xEB35, 0xEE6B, 0xF153, 0xEC91, 0xF75B, 0xF01E, 0xF39F,
    0xF657, 0x0738, 0x03F1, 0x066B, 0x134C, 0x1280, 0x129D, 0x148E, 0x2306, 0x1ACA, 0x1CF6, 0x1F59, 0x2187, 0x1E43, 0x1D96, 0x202F,
    0x1ADE, 0x2042, 0x1856, 0x1619, 0x0E80, 0x0DC7, 0xFEDB, 0xF88E, 0xFA63, 0xF526, 0xEEB5, 0xE8B0, 0xF028, 0xE7F8, 0xEB64, 0xE7F8,
    0xEF9A, 0xE912, 0xE9D7, 0xE8A4, 0xEA5C, 0xEE1F, 0xE968, 0xEF4A, 0xE9F7, 0xF335, 0xE923, 0xED5D, 0xF12A, 0xF859, 0xF35A, 0xFDA5,
    0x034F, 0x0830, 0x11F0, 0x1070, 0x19C5, 0x1593, 0x1B29, 0x12E9, 0x0F4B, 0x0BD9, 0x0E75, 0x078F, 0x09C4, 0x10EC, 0x12C8, 0x12AD,
    0x1681, 0x2079, 0x1DAB, 0x1DBB, 0x2400, 0x2986, 0x25DE, 0x24AA, 0x23BA, 0x1B5E, 0x136E, 0x0BE7, 0x0766, 0xFF98, 0xF96E, 0xEC70,
    0xE407, 0xDEFB, 0xD64A, 0xD429, 0xD166, 0xD74D, 0xCE93, 0xD4A1, 0xD0DD, 0xD2FA, 0xCDF4, 0xD2D2, 0xD707, 0xD827, 0xDF0E, 0xDDFC,
    0xE438, 0xE0D3, 0xED2C, 0xE990, 0xEFC7, 0xF20E, 0xF77B, 0xF6B5, 0xF747, 0x020D, 0xFFCF, 0x0605, 0x07DD, 0x0F2F, 0x0C04, 0x0DA8,
    0x0D84, 0x09B3, 0x0F42, 0x0BEF, 0x1354, 0x13FE, 0x23F2, 0x1FD3, 0x28A7, 0x3009, 0x3661, 0x34B4, 0x3707, 0x404A, 0x331A, 0x37AA,
    0x30E8, 0x357B, 0x2408, 0x29D4, 0x1ED4, 0x1CBE, 0x177A, 0x13D7, 0x0DF5, 0x0605, 0x0883, 0xFB6C, 0xFE6C, 0xF535, 0xF37C, 0xE7B8,
    0xE8C9, 0xE453, 0xDF2D, 0xDF07, 0xDA31, 0xD91D, 0xD243, 0xD321, 0xD159, 0xD3B3, 0xD6DA, 0xD75C, 0xDF85, 0xDD22, 0xE0DD, 0xD96B,
    0xE2A9, 0xE0B0, 0xE3E1, 0xE4BE, 0xEB37, 0xEDC2, 0xE754, 0xF050, 0xED54, 0xF11D, 0xE700, 0xF17C, 0xECB6, 0xF0FC, 0xEEFD, 0xF67A,
    0xF7BF, 0xF9E4, 0x02C2, 0x059D, 0x0E89, 0x105F, 0x1D04, 0x1B1A, 0x227C, 0x26A8, 0x2C48, 0x2CB3, 0x2F18, 0x31A9, 0x2A5D, 0x28AA,
    0x215A, 0x1E39, 0x134F, 0x0AA8, 0x014C, 0xFD4E, 0xF7A0, 0xEB24, 0xEC32, 0xEBD2, 0xEC07, 0xE518, 0xEFAD, 0xEE4C, 0xECCB, 0xECC2,
    0xF63C, 0xF8ED, 0xF764, 0xFD0B, 0xFF37, 0x0285, 0x002A, 0x0406, 0xFF94, 0x03B2, 0x021E, 0x0285, 0x02C3, 0x0A33, 0x0A96, 0x08EB,
    0x0DE3, 0x12B3, 0x0EBD, 0x0AF4, 0x0C92, 0x0D12, 0x0BC5, 0x0B93, 0x0B0F, 0x0A98, 0x0961, 0x0B6F, 0x0D5E, 0x1585, 0x1A9D, 0x1CE4,
    0x1F7A, 0x249A, 0x2697, 0x208F, 0x25D0, 0x23CB, 0x23EC, 0x1A45, 0x1FC3, 0x1694, 0x13CB, 0x0985, 0x0459, 0xFA97, 0xF51F, 0xF095,
    0xE54D, 0xE85C, 0xDE66, 0xDCAD, 0xD419, 0xDD3D, 0xD251, 0xCE02, 0xC995, 0xC8D9, 0xC2AA, 0xBDE7, 0xC2C2, 0xC15C, 0xC6BD, 0xC568,
    0xCC88, 0xCD56, 0xD2CC, 0xD44F, 0xD859, 0xE455, 0xE94C, 0xEE4C, 0xF004, 0xFCE2, 0xFDA3, 0xFD3A, 0xFFBA, 0x0429, 0x01A5, 0xFE3C,
    0x02DD, 0x020F, 0x04B6, 0x0261, 0x0C52, 0x0FA2, 0x1A10, 0x1A45, 0x222C, 0x2546, 0x2A2D, 0x2D72, 0x2C04, 0x2E95, 0x2B02, 0x24F8,
    0x23F2, 0x30D0, 0x275C, 0x2476, 0x16E1, 0x2380, 0x104C, 0x071C, 0x0AD2, 0xFA59, 0x0302, 0xEC93, 0xF6D6, 0xF28A, 0xF15A, 0xF840,
    0xED8F, 0xF3A8, 0x022C, 0xF5B3, 0xF290, 0xFE57, 0xF611, 0x06E9, 0xF254, 0xF91C, 0x0C4A, 0xFDED, 0xFD80, 0x0592, 0xE9D8, 0xEB40,
    0x049E, 0xDFE4, 0x072A, 0x0D32, 0xF7F3, 0x0B8F, 0xF482, 0x136A, 0x0855, 0xF06F, 0x15F1, 0xFFF0, 0x0830, 0xF8A9, 0xEAC6, 0x168C,
    0xF494, 0xF14B, 0x215B, 0x1E84, 0xF2C6, 0x055E, 0x0924, 0x1377, 0x090A, 0xEF02, 0x0BFA, 0x0AC4, 0x2049, 0xF408, 0xF055, 0xF548,
    0xE26C, 0xE70A, 0x0EF3, 0x1A58, 0xDD17, 0xBDB6, 0xAC39, 0xAE37, 0xA0D3, 0xCB6F, 0xD73E, 0xBFAB, 0xC9BE, 0xFC43, 0x2B10, 0x36E9,
    0x26E5, 0x00DF, 0xBF01, 0x8801, 0x8FD0, 0x8BFC, 0xB3C1, 0xBCE7, 0xFE7E, 0x551B, 0x5FEF, 0x7883, 0x5E44, 0x5313, 0x340E, 0x3821,
    0x6AE0, 0x7804, 0x7C04, 0x64AB, 0x55FE, 0x62C7, 0x7A04, 0x77F9, 0x73DF, 0x69CA, 0x4970, 0x26B7, 0x37B4, 0x5545, 0x4786, 0x3969,
    0x143E, 0xE774, 0xC93A, 0xB806, 0xB695, 0xA58F, 0xA2B8, 0x9F3D, 0x9BEA, 0x9888, 0x9ABD, 0xB5DE, 0xB914, 0xBF10, 0xA772, 0xC139,
    0xD082, 0xD033, 0xD6AB, 0xD7BD, 0xD5E5, 0xC7DC, 0xCB7F, 0xC208, 0xDEC7, 0xF0E0, 0x39EB, 0x1DF9, 0x2433, 0x2153, 0x0235, 0x01E5,
    0xB2C1, 0xA3E4, 0xA4F9, 0xA958, 0xA737, 0xE54C, 0xDDE9, 0xE76E, 0xE0DC, 0xC539, 0xB18C, 0xAF10, 0xC10D, 0xBC54, 0xE5A5, 0xE4C3,
    0xEBCF, 0xFD72, 0x14B4, 0xF88D, 0x1342, 0x4B9F, 0x438D, 0x501C, 0x60D4, 0x6330, 0x690C, 0x71B1, 0x6888, 0x6118, 0x7137, 0x57B1,
    0x4CD8, 0x2D0A, 0x113F, 0xFD97, 0xE6DA, 0xF202, 0xD810, 0xD6F4, 0xC3DD, 0xE907, 0xF9B1, 0xE639, 0xE461, 0xDF74, 0xFDC3, 0x0756,
    0x0D40, 0x0235, 0x1420, 0x11C4, 0x2D56, 0x3C81, 0x2C5A, 0x3E7C, 0x0C5A, 0x3145, 0x4386, 0x15DC, 0xE991, 0xF0D8, 0xF709, 0xF37E,
    0x190D, 0x0466, 0x1087, 0x1EA6, 0x0D37, 0x00E3, 0xED11, 0xD771, 0xDFDA, 0xE952, 0xF8D4, 0x0F8F, 0x1B77, 0x135D, 0x1D1D, 0x10BE,
    0x136D, 0xFC26, 0x0032, 0xFA64, 0xEAF2, 0x0660, 0x2E32, 0x254B, 0xE7DF, 0xFB62, 0xF125, 0xFCE1, 0xE7B2, 0x04A5, 0x0A12, 0xD58A,
    0xB818, 0xC9D9, 0xC376, 0xABBD, 0xA103, 0xA006, 0xB3C0, 0xA7C9, 0xC0FC, 0xA4CC, 0xCA90, 0xE10E, 0xCA8F, 0xB535, 0xC038, 0xE85E,
    0xFE5A, 0xFF7E, 0x144C, 0x3E0B, 0x3573, 0x3C96, 0x3978, 0x3125, 0x301F, 0x0E43, 0xDFED, 0xCEFC, 0xCC6E, 0xD82B, 0xDD5B, 0xDBD6,
    0xDAC0, 0xD920, 0xDD9D, 0xE5A3, 0xDA18, 0xF71C, 0xECDE, 0xEBB2, 0xF4F9, 0xE78A, 0x05AC, 0x028F, 0x1B2F, 0xF7A6, 0xE578, 0x0A77,
    0xF1F3, 0xF2E2, 0xFAFF, 0xF5AD, 0x0999, 0x18F7, 0x27C6, 0x2246, 0x3196, 0x2C59, 0x0DAA, 0x1177, 0x0239, 0xE71C, 0xF1CA, 0xECB9,
    0xE6BA, 0xE89D, 0xEF89, 0xFFC1, 0x04B3, 0x3231, 0x2BF1, 0x1D4C, 0x249A, 0x1046, 0xFA92, 0xE4D9, 0xD9E9, 0xF083, 0xD92C, 0xFC71,
    0xFDA7, 0x0668, 0x1F00, 0xF864, 0x0D8F, 0x1A7C, 0x12C2, 0xE00D, 0xEF56, 0xF8F3, 0x1DD0, 0xFCFF, 0xF864, 0x1F59, 0x09B5, 0xF223,
    0xF815, 0x04E7, 0xEC63, 0x1575, 0x2D79, 0x3DC4, 0x2C3D, 0x519E, 0x5742, 0x4033, 0x4FC7, 0x417B, 0x4CC1, 0x442B, 0x2A9C, 0x24EA,
    0xFBEA, 0x02FC, 0xF9D3, 0xF4AC, 0xF4FB, 0xD4A4, 0xF2AF, 0xE288, 0xB60D, 0xD0EB, 0xD3D7, 0xD42C, 0xE90E, 0xF7A3, 0x3841, 0x1CF5,
    0x3390, 0x46D1, 0x4D12, 0x3ED2, 0x3847, 0x3880, 0x1E8E, 0x0ECF, 0xDCB5, 0xF932, 0xE236, 0xDCA5, 0xF1C5, 0xDCCD, 0xEFFD, 0x08E0,
    0xE123, 0xF6C1, 0x1498, 0xE763, 0xE664, 0xE758, 0xE203, 0xF9B0, 0xDD8A, 0xE3DF, 0xFED2, 0xF24D, 0x06B3, 0xFA51, 0x0E38, 0x110B,
    0xF432, 0xFAC2, 0xF94A, 0xFAD5, 0xE1C4, 0xE634, 0xE412, 0xF1B0, 0xD9B6, 0xDBB9, 0xE4BC, 0xCA2B, 0x0633, 0xE701, 0xF8BA, 0xFC9C,
    0xFF7F, 0xF3FD, 0xF22B, 0xF737, 0xDB11, 0xE4A1, 0xE20A, 0xDA16, 0xAB76, 0xCC25, 0xC306, 0xD4CF, 0xDD2F, 0xEC7E, 0xE215, 0xE73D,
    0xE89E, 0xE9F7, 0xF07E, 0xE027, 0x0A83, 0x005D, 0x0954, 0xEC67, 0xF214, 0x074F, 0x0F99, 0x02B3, 0x138D, 0xF97E, 0x0B46, 0x12AE,
    0x02B1, 0x1264, 0x01D2, 0x1291, 0x12FF, 0x0D6F, 0x1269, 0x16FE, 0x12B7, 0x1749, 0xF26C, 0x1A88, 0x004B, 0x016B, 0x0929, 0x0CE9,
    0x1DC9, 0x1ED1, 0x2487, 0xFD60, 0x2575, 0x3B6A, 0x36A9, 0x13D2, 0x0644, 0xFEAC, 0xE812, 0xF393, 0xEF5E, 0x00CA, 0x1536, 0xE72B,
    0xFCBE, 0x06D8, 0xF6D2, 0x0568, 0xF35E, 0xEC36, 0xE9DC, 0xFC6E, 0xFF19, 0xE27C, 0xEC30, 0xF43F, 0xE8A1, 0x02AD, 0x060E, 0xE563,
    0xEB07, 0xE99E, 0x06B3, 0x07AF, 0xF831, 0xF206, 0xEFFC, 0x0E3D, 0xF2AC, 0xE365, 0xDBA3, 0xD45D, 0xDD25, 0xEE39, 0xD522, 0xD858,
    0xC3DF, 0xBAC5, 0xC1D2, 0xDBBF, 0xEAE0, 0xD152, 0xF37A, 0xF5FD, 0xEB65, 0xEB7C, 0xED99, 0xE3A0, 0xFC76, 0xF896, 0x0529, 0x242F,
    0x2BD7, 0x12F2, 0x0E40, 0x184E, 0x016C, 0x00FF, 0x24DC, 0x12D9, 0x05B2, 0x13AD, 0xFC75, 0x10CC, 0x22CC, 0x1FA6, 0x1D9E, 0x109C,
    0x20C0, 0x26E3, 0x1516, 0x22FC, 0x0527, 0x1A6F, 0xF2D1, 0xFAF1, 0xFCCC, 0xF59A, 0x0A57, 0x0AF1, 0xFAD0, 0xEAD3, 0x0434, 0xF0B3,
    0x2461, 0x084E, 0xECA1, 0x1653, 0x27F2, 0xF997, 0x1011, 0x0EBF, 0x12EB, 0x0AB3, 0x2588, 0x4F3D, 0x2EFD, 0x3E23, 0x1A67, 0x1206,
    0x12E7, 0x1DE8, 0x3199, 0x3349, 0x170C, 0x1645, 0x0D23, 0x065F, 0x05AE, 0x1A60, 0x1D93, 0x0DDF, 0x18EC, 0x0EE5, 0xED6A, 0xDEC5,
    0xED53, 0xF21A, 0x045A, 0xFA8C, 0xE858, 0xD38C, 0xD3E6, 0xCDF3, 0xEF06, 0x01CD, 0x015D, 0xE4E2, 0xD6FF, 0x0C68, 0xF6F7, 0xE940,
    0xF11F, 0xEFB1, 0xE9A2, 0xDA1B, 0xD739, 0xF0A0, 0xEC72, 0xDE28, 0xDEB6, 0xE3E9, 0xEF79, 0xEA1A, 0xD1C0, 0xE03C, 0xE352, 0x07AD,
    0xF2C0, 0xDB24, 0x0C3D, 0xF575, 0xE7F1, 0xE225, 0xF986, 0xFDBB, 0x02FE, 0x018F, 0x2440, 0x1A87, 0x2032, 0x2C9B, 0x253F, 0x338F,
    0x248D, 0x290C, 0x20C3, 0x1D71, 0x0495, 0x054F, 0x1927, 0x0C26, 0xE914, 0xFDCB, 0xF644, 0xD3E7, 0xD12F, 0xC4BB, 0xC32E, 0xDEE9,
    0xF518, 0xE4B6, 0xDB54, 0xEF32, 0xD7E1, 0xDFF0, 0xFA9F, 0xEC3D, 0xF764, 0x054F, 0xF18D, 0xECA6, 0xEE33, 0xE99F, 0x0480, 0xF59E,
    0xF960, 0x12D9, 0x0D7F, 0xFF54, 0x0893, 0xFE4A, 0xEBF4, 0xE242, 0xF76B, 0xFD61, 0xF500, 0x0145, 0x0B17, 0x08CC, 0xEB98, 0xFAB0,
    0x10A5, 0x09DE, 0xFCF0, 0xF5D3, 0xFBFC, 0xFD0F, 0xED71, 0xF663, 0xE018, 0xE711, 0xEEE4, 0xE1F5, 0xD969, 0xD894, 0xDBFB, 0xF5EE,
    0xF35F, 0xD14C, 0xDF07, 0xE40F, 0xF30F, 0xE1D9, 0xDF65, 0xE137, 0x0008, 0xF475, 0xEE35, 0xFB07, 0xF1BC, 0xF844, 0xE701, 0xEA29,
    0xDDC0, 0xE4BD, 0xE850, 0xC58E, 0xCC64, 0xD912, 0xD843, 0xE9CA, 0xE804, 0xF790, 0xFC53, 0xF718, 0x0A8F, 0x1B0C, 0x13E8, 0x2230,
    0x2671, 0x17B8, 0x08EE, 0x0571, 0x0385, 0x1188, 0x274D, 0x0613, 0x1D4B, 0x2853, 0x2B4D, 0x4166, 0x3CA6, 0x1C92, 0x10FE, 0x2CE2,
    0x3481, 0x356E, 0x1606, 0x1366, 0x13BB, 0x0B8C, 0x02CA, 0xFE55, 0xFD20, 0xE96B, 0xF8F0, 0xFD5E, 0xED5C, 0xD703, 0xF516, 0xFCF9,
    0xF6D2, 0xF814, 0xDDE8, 0xED39, 0xFFD4, 0xF853, 0xEE88, 0xFDF7, 0xEED7, 0xEB59, 0xCCCF, 0xE9D8, 0xF2CE, 0xCFB9, 0xE2DB, 0xE4E5,
    0x0127, 0xFC0F, 0xFB7C, 0xEF19, 0xF260, 0xE41D, 0xDCF7, 0x0A0C, 0xF96B, 0xF164, 0x07B9, 0x050D, 0xF4EC, 0xFA25, 0x0C17, 0x08E7,
    0x1DE8, 0x1FFA, 0x1780, 0x1DF2, 0x2435, 0x2172, 0x0A9B, 0x03D8, 0x09B9, 0x1B51, 0x1816, 0x07A5, 0xFA87, 0x0659, 0x20E2, 0x160B,
    0xD13D, 0xC760, 0xEDCA, 0xEE9B, 0xF480, 0xDEFF, 0xE8D3, 0xF870, 0xEAFC, 0xF7DC, 0xF7CF, 0xDDAA, 0xD9D0, 0xE635, 0xFB42, 0x0CB7,
    0xF711, 0x0168, 0xF518, 0xF464, 0x0FCA, 0x12BA, 0xFE3C, 0xFA89, 0xF0EC, 0xFF40, 0x1967, 0x060A, 0x067A, 0xF961, 0x0B36, 0x05E2,
    0x00D2, 0x0719, 0x05C2, 0xF801, 0xF2D1, 0xFBDB, 0x0BA5, 0x2260, 0x1EF1, 0x1349, 0x14D2, 0x05C6, 0x146C, 0x21A6, 0x187D, 0x2F8F,
    0x1E6C, 0x188D, 0x1A45, 0x0F7D, 0x16D8, 0x3591, 0x263B, 0x2392, 0x1AAD, 0x09FA, 0x0101, 0xF5A4, 0xF44B, 0xF574, 0xFDBD, 0xF047,
    0xEB30, 0xF43E, 0xFE7E, 0xFAAD, 0x0DFE, 0xFB58, 0xF96D, 0xFD6B, 0xF9B5, 0xFAA3, 0x0621, 0x22AA, 0x1B10, 0x1A70, 0x0D78, 0x0572,
    0x10D0, 0x16C9, 0x050B, 0x0649, 0x0E67, 0x10A8, 0x1016, 0x0B29, 0x11CE, 0xFB76, 0xE637, 0xE09A, 0xEC75, 0xF14C, 0xF924, 0x0056,
    0x010F, 0x0728, 0x07A7, 0x0CAB, 0x0664, 0x149E, 0x1798, 0x29F4, 0x2DE0, 0x1ADA, 0x233A, 0x2B31, 0x38C4, 0x23A8, 0x13B1, 0x187A,
    0x230F, 0x1A5F, 0x036C, 0x13A4, 0x14AD, 0x0893, 0xF443, 0xF171, 0xFC67, 0xF7E2, 0xF5D7, 0xE967, 0xF431, 0xE9E0, 0xE36D, 0xE727,
    0xD033, 0xD195, 0xD542, 0xD64D, 0xC9B0, 0xD0AC, 0xED89, 0xEAD4, 0xE4A0, 0xE883, 0x0856, 0x0655, 0x0450, 0x01E0, 0xF831, 0x02A7,
    0x03BE, 0x0341, 0xF5C1, 0x0772, 0x064F, 0xF35E, 0xCEC5, 0xD5BE, 0xDF67, 0xE38D, 0xF29F, 0xDCC8, 0xDC43, 0xE254, 0xF2C4, 0xEBE7,
    0xECAB, 0xFB24, 0x0F67, 0x25A2, 0x2C19, 0x27D0, 0x17A9, 0x1972, 0x23A7, 0x1920, 0x1ACA, 0x1E10, 0x33F1, 0x3418, 0x1C8D, 0x10FB,
    0xFF1A, 0x080A, 0x0D25, 0x0533, 0xE483, 0xE6D5, 0xF59B, 0xE9F0, 0xE2CF, 0xF05D, 0x01B8, 0x11E0, 0x16A0, 0x14DA, 0x20BE, 0x0735,
    0x09CE, 0x0CF4, 0x1BB3, 0x2BD7, 0x0B57, 0x095C, 0x0961, 0x0E2D, 0x1E45, 0x2115, 0x0AAA, 0xFC5E, 0x1AF1, 0x26E0, 0x2847, 0x2062,
    0x2C2C, 0x3819, 0x2642, 0x2778, 0x1CD7, 0x15F3, 0x0E10, 0x12E5, 0x174F, 0x128A, 0xFF91, 0x0CA8, 0x0E4A, 0x043D, 0x0A75, 0x0636,
    0x10CD, 0x0497, 0x048F, 0xE95A, 0x0275, 0xFB59, 0xF060, 0xFD8C, 0xED51, 0xE8DD, 0xD1AC, 0xE196, 0xD064, 0xCD98, 0xE324, 0xE44C,
    0xDEC9, 0xEAAF, 0xEDFE, 0xDC71, 0xEA9D, 0xFB69, 0x00B2, 0xF748, 0xE3D3, 0xDEB8, 0xD5BB, 0xDD01, 0xE317, 0xD8C2, 0xDD05, 0xE9DE,
    0xF155, 0xF633, 0xFC64, 0xF231, 0xF470, 0xE735, 0xFCA1, 0xFFDA, 0xE47A, 0xEBD0, 0xEB0A, 0xE59D, 0xE895, 0xFFF5, 0xF865, 0xF8B7,
    0xF781, 0x05A4, 0x00BB, 0xF95F, 0x1398, 0x1640, 0x28D4, 0x2490, 0x23FA, 0x32B1, 0x21E6, 0x1F40, 0x0A42, 0xEF30, 0xF457, 0xF0F3,
    0x03BB, 0x0413, 0x15F7, 0x11BA, 0xF76E, 0xF8F7, 0x08CD, 0x116B, 0x0A4A, 0x0D8B, 0x1994, 0x1A18, 0x0829, 0x16F6, 0x0B79, 0x0FAC,
    0x0BA3, 0x0E8D, 0x18CC, 0x1880, 0x1C92, 0x1C88, 0x2AA5, 0x31CD, 0x406D, 0x24BA, 0x133D, 0x1BAC, 0x29E9, 0x3A02, 0x3A3E, 0x3DEB,
    0x269A, 0x1872, 0x1CDA, 0x19DC, 0xFF33, 0xFA74, 0x0378, 0xFA76, 0x0CC0, 0xF615, 0xF7B1, 0xE8A0, 0xF2DF, 0x0A36, 0xFC44, 0x01AC,
    0xF3C2, 0xFAB3, 0xF7D5, 0x06CA, 0x09DC, 0x0313, 0xF7DE, 0xF628, 0xE90E, 0xD8B7, 0xEA61, 0xDDB4, 0xE937, 0xEF10, 0xEE61, 0x01B1,
    0xECB9, 0xEFEA, 0xE5D0, 0xED3E, 0xFADD, 0xE719, 0xD72E, 0xE111, 0xE9CD, 0xE404, 0xE2BB, 0xE041, 0x0063, 0xEEE6, 0x01B6, 0xF5B9,
    0xEC06, 0xF3AC, 0xF2A1, 0x00DF, 0xF8BA, 0x10BE, 0x17E2, 0x2B09, 0x1610, 0xF087, 0xF2ED, 0xF849, 0x21F1, 0x2633, 0x0C71, 0x0A85,
    0xF773, 0xF966, 0xEE4D, 0xFAB8, 0xFFF3, 0xFCA1, 0xFB32, 0xFB1E, 0xFAE8, 0xE5E8, 0xDF7C, 0xE253, 0xE0FB, 0xE6B1, 0xEB08, 0xD926,
    0xE3CE, 0xEC15, 0xEF71, 0xEE84, 0xFDD7, 0x0676, 0xF0CC, 0xE6E7, 0xF2B3, 0xF516, 0xF998, 0xFEFF, 0x0FA5, 0x04AC, 0x0048, 0xFD36,
    0xFF51, 0x0A4D, 0x03DA, 0x124E, 0xFF07, 0x06C8, 0xF5BC, 0xF966, 0xE888, 0xDB8F, 0xF7DE, 0xF2D4, 0xF8F8, 0xE7A8, 0xE41B, 0xED96,
    0xED93, 0xFC67, 0x0577, 0x0BFD, 0x01B8, 0xF539, 0xF1A0, 0xF6FC, 0xFDEB, 0x025A, 0x0A7E, 0xFF49, 0x0AFB, 0xFC18, 0x0E00, 0x1BE8,
    0x26BA, 0x1393, 0x0D8F, 0x25B2, 0x165F, 0x1C1D, 0x0A99, 0x1300, 0x00B6, 0x0288, 0x0683, 0xFCC1, 0xF156, 0xECA3, 0x08DF, 0x07FA,
    0xFD2D, 0xF629, 0x08B6, 0x1938, 0x05A3, 0xFB98, 0x004F, 0x07A1, 0x0959, 0x0476, 0x0475, 0x0957, 0x14FF, 0x02CB, 0xFA03, 0x0282,
    0x1762, 0x2009, 0x2422, 0x29DC, 0x2E5A, 0x3114, 0x24A5, 0x1B82, 0x0F72, 0x0C98, 0x00CF, 0x0A41, 0x034C, 0xFF36, 0x01DC, 0xF8B7,
    0xEDF8, 0xE3C3, 0xF4DE, 0xF05C, 0xF90F, 0xF729, 0xFDCC, 0xFC4A, 0xF23D, 0xEAC2, 0xF034, 0x071D, 0xF411, 0xF3B3, 0xF40B, 0xFAF3,
    0x01D7, 0x0EF1, 0x01FE, 0xF733, 0xF586, 0xE55C, 0xEE99, 0xE7F8, 0xEBD1, 0xE6B3, 0xDEED, 0xDF56, 0xD9B0, 0xE1FD, 0xD107, 0xCA02,
    0xCAC6, 0xD7F9, 0xF750, 0xEB00, 0xE9E0, 0xEAC3, 0x0292, 0x081A, 0x009C, 0x0556, 0xF916, 0x07D1, 0x04BD, 0x10D6, 0x112C, 0x1355,
    0x19B6, 0x194F, 0x273E, 0x2597, 0x2EF9, 0x1BF6, 0x2016, 0x18CB, 0x14E5, 0x1B8E, 0x1313, 0x0FCA, 0x07D5, 0x1F9A, 0x1693, 0x1B5B,
    0x0EA1, 0x1254, 0x1447, 0x027D, 0x0EC3, 0xF975, 0xF7A3, 0xF3F4, 0x0566, 0x0E0A, 0x057C, 0x0CCE, 0x0A91, 0x107F, 0x0464, 0x0F68,
    0x1264, 0x01D6, 0x049A, 0x006A, 0x0783, 0x0A21, 0x074C, 0x0296, 0xFE9C, 0x0073, 0xFF2F, 0x0023, 0xFFD0, 0x0C40, 0x1251, 0x10BE,
    0x0054, 0x0558, 0x0ED4, 0x0221, 0x0459, 0xFAD6, 0x0164, 0xFDC6, 0x063E, 0x0885, 0x000C, 0x0784, 0x0182, 0x027B, 0x02EE, 0x0E8D,
    0x0C51, 0x0B26, 0x070E, 0x01AD, 0x02D2, 0xFB3B, 0xF87F, 0xED90, 0xE76B, 0xDFCF, 0xE9EA, 0xE92E, 0xE981, 0xFA38, 0xFE78, 0x0861,
    0xFF44, 0x09A7, 0x05E5, 0x0040, 0xFF46, 0xF6BA, 0xF245, 0xE42A, 0xF730, 0xF3BD, 0xF50D, 0xF209, 0xED56, 0xF626, 0xF4B9, 0xF1AF,
    0xFE1F, 0x0E1F, 0xFED3, 0xFF3B, 0xF87A, 0xF4AB, 0xF2A3, 0xF70B, 0xF98C, 0x0053, 0x02FC, 0x0820, 0x1274, 0x0377, 0x0EBC, 0x103B,
    0x0BEA, 0x0ABB, 0x0CED, 0x11D0, 0x0B34, 0x1096, 0x0EC4, 0x10A3, 0x1696, 0x194E, 0x2593, 0x24CF, 0x2BC4, 0x26F9, 0x2472, 0x2205,
    0x1581, 0x11AA, 0x14AD, 0x21D9, 0x1FC4, 0x20AD, 0x1D65, 0x224D, 0x1717, 0x04D3, 0xF926, 0xFBB8, 0x0061, 0xFA57, 0xF66A, 0xEEBF,
    0xFC18, 0xFD7A, 0xF466, 0xDF5D, 0xE3C3, 0xE97A, 0xE13F, 0xDEC2, 0xD487, 0xD22D, 0xD098, 0xCDAC, 0xD2DD, 0xCCF1, 0xCCCB, 0xD9E8,
    0xE412, 0xEC9D, 0xE128, 0xEC10, 0xE69D, 0xE79D, 0xE584, 0xEA2D, 0xED8D, 0xE61F, 0xF330, 0xF6D7, 0x01E3, 0x0E61, 0x1C23, 0x14A0,
    0x0A38, 0xFE4C, 0x028D, 0x0868, 0x0CCE, 0x0710, 0x0818, 0x0AA7, 0x00BA, 0xFFAA, 0xF865, 0xF9E9, 0xFE53, 0x0503, 0x03AA, 0x0481,
    0x0ED6, 0x106C, 0x0F13, 0x0ED6, 0x054C, 0x071F, 0xFE32, 0x00C8, 0x0252, 0x0914, 0x03B2, 0xFD04, 0x0BA8, 0x0139, 0x0B63, 0x0900,
    0x1354, 0x0A6F, 0x0310, 0x09F0, 0x09D4, 0x10C7, 0xFD4C, 0xFAEE, 0xFC3B, 0x060C, 0x199D, 0x1E6B, 0x19AE, 0x1790, 0x1A4E, 0x198A,
    0x0F9F, 0x1027, 0x1368, 0x1C03, 0x2433, 0x1D48, 0x1660, 0x10DC, 0x0BF3, 0x09FB, 0x00FE, 0x0059, 0xFE90, 0x03DA, 0x115C, 0x0ED1,
    0x13E0, 0x07B6, 0x0CEC, 0x02EC, 0xFD25, 0xF91B, 0xF12D, 0xF608, 0xF59C, 0x03F9, 0xFF80, 0x0050, 0xF802, 0xF920, 0xF286, 0xEA79,
    0xEF37, 0xEAE0, 0xE77B, 0xE6CF, 0xEE40, 0xF567, 0xF17F, 0xEA23, 0xEC68, 0xE003, 0xDE34, 0xEE87, 0xEE56, 0xEB3D, 0xEC22, 0xEFAA,
    0xED15, 0xDC6B, 0xDCBA, 0xDDBB, 0xDFA8, 0xE224, 0xE913, 0xE698, 0xD9F8, 0xE263, 0xEA54, 0xF917, 0xFB29, 0x0B29, 0x0F39, 0x06BC,
    0x0825, 0x050A, 0x08E1, 0x0592, 0x09C0, 0x05C3, 0x0A79, 0x0733, 0x06A9, 0x06A6, 0x0444, 0x03D1, 0x003F, 0x0678, 0x02EC, 0x0C3F,
    0x0FB5, 0x0F98, 0x1A1D, 0x1C1F, 0x1D7B, 0x1741, 0x1174, 0x09BA, 0x07D9, 0x0AC1, 0x02C0, 0x08A0, 0x0716, 0x0D08, 0x08E8, 0x1181,
    0x0E8C, 0x0C53, 0x0F91, 0x0770, 0x1347, 0x067A, 0x057F, 0x0054, 0xFC98, 0xF959, 0xECA8, 0xEE8B, 0xF4CE, 0xF148, 0xF515, 0xF24D,
    0xF57C, 0xF5B3, 0xF2FB, 0xF070, 0xE595, 0xE94B, 0xF0D5, 0xF05A, 0xEE4F, 0xF7D6, 0xFF46, 0x02E6, 0x0448, 0x09D4, 0x0B94, 0x0E35,
    0x10C5, 0x2764, 0x247D, 0x2425, 0x2110, 0x1721, 0x1F8B, 0x14FE, 0x1130, 0x0CDA, 0x1732, 0x101E, 0xFF9D, 0x0718, 0x0741, 0x0611,
    0x01A0, 0xF8AD, 0xFC30, 0xF591, 0xF9EA, 0xF500, 0xF384, 0xF5CE, 0xF04A, 0xF326, 0xE929, 0xE92C, 0xEDC5, 0xF27B, 0xF90B, 0xF5CE,
    0xEE29, 0xEFF5, 0xECC6, 0xF59B, 0xF828, 0xF74F, 0xF60A, 0xFA1E, 0x0399, 0xF90C, 0x01BD, 0xFF51, 0x0B4C, 0x10A5, 0x087B, 0x1346,
    0x09FE, 0x112F, 0x1228, 0x147C, 0x0DFB, 0x0486, 0x0FB0, 0x0602, 0x042D, 0x0572, 0x09CE, 0x0B36, 0x0EE6, 0x10F3, 0x05AF, 0x0086,
    0x01C8, 0x00FE, 0x036D, 0x0734, 0x09B2, 0x0D6E, 0x046F, 0x08EE, 0x09DD, 0x09E3, 0x083A, 0xFC57, 0xFDF7, 0xF74F, 0xFCA8, 0xF7F1,
    0xEB9B, 0xECE6, 0xE859, 0xEEF4, 0xE3C4, 0xDF93, 0xE0DD, 0xDC72, 0xE116, 0xDB02, 0xDF77, 0xE0A3, 0xE69B, 0xEAB4, 0xE555, 0xEF5C,
    0xF4E0, 0xFAEE, 0xFBAA, 0x0011, 0x0890, 0x02D4, 0x02A7, 0x0736, 0x0A46, 0x121C, 0x10AF, 0x183C, 0x1D2F, 0x142F, 0x2609, 0x23A3,
    0x25CD, 0x2831, 0x2AA7, 0x2AA6, 0x1989, 0x1BCF, 0x13CD, 0x1814, 0x1BE7, 0x21DD, 0x26C9, 0x1BFE, 0x198F, 0x1C42, 0x26F6, 0x25B9,
    0x18B2, 0x1B06, 0x17C8, 0x154E, 0x1460, 0x132E, 0x16AF, 0x1661, 0x179E, 0x17D1, 0x1AAB, 0x1DC6, 0x179E, 0x0C68, 0x0586, 0x05D0,
    0x03C1, 0xFFB1, 0xFD29, 0xF90E, 0x01C6, 0xFF59, 0xFA04, 0xEC89, 0xE178, 0xE742, 0xE4BB, 0xEC95, 0xED87, 0xEEFC, 0xF988, 0xF8A8,
    0xFABB, 0xF7FE, 0xF566, 0xF625, 0xF4DC, 0x0233, 0xFA42, 0xFB11, 0x021B, 0xFC5D, 0x0711, 0x04E3, 0x0673, 0xFE66, 0xF7E9, 0xFB01,
    0xFAED, 0xFDFD, 0xFBD4, 0xFD83, 0xFF87, 0xF919, 0xF335, 0xF8BC, 0xF60A, 0xF6A7, 0xECE7, 0xF8E3, 0xF6AC, 0xF126, 0xF214, 0xE8F2,
    0xF7F2, 0xF115, 0xFED6, 0xF597, 0xFC10, 0x002D, 0xF495, 0xF9A4, 0xEC3E, 0xF370, 0xEF01, 0xFA31, 0x0506, 0x02E7, 0x0BAD, 0x0B37,
    0x0C32, 0x0F46, 0x0CBD, 0x075F, 0xFBC3, 0xFAFB, 0x0607, 0xFEB8, 0xF94E, 0xFAA2, 0x02B1, 0x09C3, 0x0927, 0x0DC9, 0x06FA, 0x0F6E,
    0x1209, 0x13CB, 0x12FB, 0x06A3, 0x0E13, 0x0AC2, 0x1719, 0x1956, 0x15CD, 0x21FD, 0x2473, 0x2D8B, 0x20A5, 0x1D92, 0x1C09, 0x1150,
    0x18A5, 0x12E2, 0x1670, 0x186C, 0x1FBE, 0x296A, 0x260C, 0x23B4, 0x1AE7, 0x1622, 0x0FEA, 0x023C, 0xF7CC, 0xFB78, 0xFB40, 0xF2AB,
    0xE75D, 0xEBEF, 0xED6B, 0xE71B, 0xEB9B, 0xE8D5, 0xE799, 0xD77A, 0xD96A, 0xDE21, 0xE068, 0xE62A, 0xDF43, 0xE084, 0xD8A3, 0xDFEC,
    0xE032, 0xDDF6, 0xEC8C, 0xFB64, 0x0682, 0x0572, 0x0C1B, 0x0CDF, 0x02A9, 0x05B7, 0x00F7, 0xFF7D, 0x00DD, 0x0717, 0x01FC, 0xF4E0,
    0xFFBE, 0xFC84, 0xFFA6, 0x027E, 0xF82B, 0xEFF1, 0xEBB8, 0xF373, 0xF6BB, 0xF51A, 0x0214, 0x080D, 0x11AD, 0x1495, 0x1009, 0x1BB8,
    0x1703, 0x0F8C, 0xFCE4, 0xFEDB, 0x0511, 0xF69F, 0x0304, 0x0898, 0x0E14, 0x0899, 0x025E, 0x0BD3, 0xFDF4, 0xFBF1, 0xF22E, 0xEBFA,
    0xF22D, 0xF072, 0xF291, 0xEAD9, 0xF340, 0xEFDE, 0xE91D, 0xF243, 0xF2B1, 0xF4E8, 0xF013, 0xEF37, 0xFDD0, 0xFBA2, 0xFDC4, 0x02D7,
    0xFC67, 0xFF00, 0xFB16, 0x0E27, 0x0CEF, 0x0D3C, 0x12A1, 0x0A83, 0x17C9, 0x0E30, 0x16A3, 0x09F2, 0xFC10, 0xFD8F, 0xF879, 0xFE10,
    0xF8B1, 0xFCC2, 0xF26A, 0xEE1D, 0xEBC3, 0xE10D, 0xDF05, 0xE0DA, 0xE54D, 0xE677, 0xDDAF, 0xDFA6, 0xE8A8, 0xE2C6, 0xE2E7, 0xDCF4,
    0xE3FE, 0xED59, 0xEF63, 0xEF2B, 0xE60E, 0xF4C2, 0xF0C2, 0xED5D, 0xEDC3, 0xE917, 0xF45F, 0xEBD1, 0xF5F8, 0xF18C, 0xF0E7, 0xFAF2,
    0xEEB4, 0xF429, 0xEE56, 0xF599, 0xF3D9, 0xEF55, 0xFCAB, 0xFACE, 0x0126, 0xF9FF, 0xFAA1, 0xFF49, 0xFB57, 0x0142, 0xFFD2, 0x0852,
    0x0FAC, 0x08B1, 0x096C, 0x0C8D, 0x0C9A, 0x1146, 0x0F2B, 0x1A0B, 0x19DE, 0x19D4, 0x1BF1, 0x1808, 0x1DFE, 0x12F6, 0x17F7, 0x0EF9,
    0x0DA3, 0x1524, 0x0F43, 0x1424, 0x0B18, 0x1089, 0x0BB7, 0x0582, 0x0789, 0xF9C1, 0xF816, 0xF83E, 0x002A, 0xFACB, 0xF3B4, 0xF9FE,
    0xFB7B, 0xFFAC, 0xFABC, 0xF907, 0xF5EE, 0xF091, 0xF060, 0xEBF3, 0xE72E, 0xE247, 0xD898, 0xDDC7, 0xE39A, 0xE94F, 0xED6A, 0xE836,
    0xEA8E, 0xEA38, 0xF08E, 0xEE8A, 0xECFB, 0xF339, 0xECEB, 0xE681, 0xDECA, 0xE332, 0xE484, 0xDCA2, 0xE47A, 0xE616, 0xF2D9, 0xFA4A,
    0xFE70, 0x0403, 0x02BE, 0x0B3C, 0x04BA, 0x0611, 0x0629, 0x087E, 0x0A39, 0x0A6C, 0x119A, 0x0FBB, 0x09FE, 0x07F4, 0x0B3E, 0x07C9,
    0x053B, 0xFF6A, 0xFC7A, 0xF728, 0xFDD8, 0xF9BC, 0xF032, 0xF386, 0xEBD1, 0xEDEB, 0xE782, 0xEC79, 0xE633, 0xE47F, 0xE797, 0xE1FE,
    0xEFD3, 0xEF4B, 0xF7F0, 0xF25A, 0xF291, 0xF1D7, 0xEE25, 0xFAE0, 0xFAE3, 0x00C0, 0xFBD9, 0xFF62, 0x0009, 0x017D, 0x0EAB, 0x155D,
    0x15C0, 0x102B, 0x1506, 0x1F9E, 0x23CA, 0x1B03, 0x1B13, 0x1258, 0x0CAE, 0x0DD4, 0x0E25, 0x0E97, 0xFD90, 0x03A1, 0x04E5, 0x0853,
    0x0B22, 0x00D7, 0x014C, 0xF9D1, 0x02FB, 0xF9FC, 0xEDCF, 0xF166, 0xEEC6, 0xF63E, 0xF03D, 0xF4A5, 0xF4AC, 0xF229, 0xF956, 0xF2FF,
    0xF5B4, 0xF45A, 0xF4AF, 0xF8FD, 0xF507, 0xF590, 0xF031, 0xF216, 0xFEAE, 0xFA79, 0x0053, 0xFE61, 0xF6B7, 0xFA14, 0xF616, 0xFE4E,
    0xF83D, 0xF563, 0xF167, 0xEF03, 0xF8F4, 0xEBC1, 0xF145, 0xEF81, 0xEEDA, 0xF63E, 0xFB9A, 0x0B39, 0x021D, 0x0EEF, 0x10A3, 0x099E,
    0x0C80, 0x0652, 0x09A5, 0xFBC2, 0xF944, 0x075A, 0x06BF, 0x0AA0, 0x0E41, 0x0D1A, 0x0B81, 0x08DC, 0x10E3, 0x09D1, 0x0D9C, 0x0F67,
    0x04F4, 0x0500, 0xFF16, 0x06BC, 0x038A, 0x038C, 0x0932, 0x008A, 0x01AC, 0xF3B8, 0xF1B8, 0xF3D3, 0xEFA2, 0xF4E4, 0xF612, 0xFDDC,
    0xFA45, 0xF2CA, 0xF9A0, 0xFB2E, 0xFD7B, 0xFDD1, 0xFB97, 0xFCA2, 0xF2C1, 0xFA0A, 0xF5C8, 0xF4DF, 0xF6A6, 0xF4A0, 0xF8B6, 0xF674,
    0xF60D, 0xF1A0, 0xEDB6, 0xF011, 0xEB34, 0xE99E, 0xF332, 0xEFC4, 0xF2F7, 0xEB90, 0xF397, 0xEC43, 0xEED7, 0xF5C7, 0xEFFD, 0xF82B,
    0xEDF0, 0xF3F2, 0xE863, 0xEAE2, 0xFA30, 0xF975, 0x061E, 0x02B8, 0x0825, 0x08D1, 0x08B5, 0x0A4A, 0x019D, 0x021C, 0xFBC7, 0x0310,
    0x0570, 0x06E9, 0x013E, 0xFD95, 0xFCCD, 0x0262, 0x0265, 0x0357, 0x063E, 0xFDEE, 0xFF77, 0xF82A, 0xFFE4, 0xFAF0, 0xF8E4, 0xFF09,
    0x01F9, 0x0557, 0xFDB6, 0x05F2, 0xFB47, 0xF653, 0xFA82, 0xF75F, 0x0429, 0x0780, 0x141D, 0x0E66, 0x12B6, 0x1A09, 0x198F, 0x1E86,
    0x1EA8, 0x252B, 0x1EBF, 0x1DEA, 0x1E3C, 0x1B89, 0x15EF, 0x16D8, 0x177F, 0x1692, 0x12B7, 0x0F86, 0x0D02, 0x0E19, 0x0D62, 0x021F,
    0x03BE, 0x0CA9, 0x0DE4, 0x0B7E, 0x05F4, 0x0EF9, 0x07CF, 0xFF63, 0xF87E, 0xEE24, 0xF0A7, 0xEAC1, 0xF5CD, 0xEE12, 0xE680, 0xDDBA,
    0xD772, 0xDD27, 0xD9D7, 0xDD6E, 0xDAB7, 0xDB4E, 0xDCF4, 0xD9C1, 0xD8E0, 0xD6CC, 0xDC4C, 0xE07E, 0xDF5B, 0xE327, 0xE4C5, 0xE434,
    0xEA00, 0xEA58, 0xF023, 0xF334, 0x01E0, 0x0A1B, 0x0283, 0x0D6F, 0x09DD, 0x0CC0, 0x097D, 0x0C6B, 0x0FA6, 0x0D67, 0x1930, 0x15F4,
    0x1520, 0x16C8, 0x15F3, 0x184B, 0x0FE7, 0x1324, 0x1237, 0x11CB, 0x1675, 0x119E, 0x0E78, 0x0CA2, 0x0A37, 0x02B0, 0x019F, 0x012E,
    0x012B, 0x0364, 0x0D0E, 0x0AD5, 0x06ED, 0x0072, 0x01CC, 0x00AF, 0xFEED, 0x05D7, 0xFFEA, 0x003D, 0x0110, 0xFE87, 0xFEB9, 0xFA8B,
    0xFECA, 0xF3E1, 0xEF84, 0xF0D8, 0xEE89, 0xFA45, 0xFA24, 0x051F, 0xFEC9, 0x051A, 0xFE9E, 0xFC96, 0x0737, 0x01CB, 0xFEE3, 0xF813,
    0xFD96, 0xFBD0, 0xFB93, 0xFEFE, 0xFF82, 0xFAA6, 0xF505, 0xF5CA, 0xFBCE, 0xFB41, 0xF67C, 0xF6D2, 0xF480, 0xF685, 0xF173, 0xF29D,
    0xF77C, 0xF26B, 0xFF9B, 0xFA7C, 0x00C7, 0xFB9C, 0xF652, 0x0148, 0xFA11, 0xFB63, 0xF61C, 0xFF4A, 0x0392, 0xFF71, 0x06AA, 0x0158,
    0xFDE0, 0xF618, 0xEF5C, 0xED8F, 0xE4C2, 0xE71A, 0xEA0C, 0xE93D, 0xE9AF, 0xEB38, 0xEB4A, 0xEB22, 0xEE80, 0xFE98, 0xFA25, 0xFDC2,
    0x01FE, 0x06F3, 0x05E2, 0xFF0B, 0x04A7, 0xFB00, 0xFF1A, 0x0282, 0x011B, 0x0417, 0x092C, 0x0B8D, 0x0E34, 0x13AD, 0x1CCC, 0x1E5D,
    0x205E, 0x1821, 0x1AD8, 0x1B1C, 0x1938, 0x156F, 0x141B, 0x0F54, 0x06E3, 0x070C, 0x0179, 0x0206, 0x0234, 0x08FA, 0x03FD, 0x0B8A,
    0x0967, 0x0517, 0x04AB, 0x07E4, 0x0B0D, 0x0C9A, 0x11C9, 0x0E4F, 0x0D53, 0x05C4, 0x0569, 0xFFBA, 0xFDE7, 0xFFF8, 0xFB51, 0x02D2,
    0xFEB5, 0xFB77, 0xF64F, 0xF5BC, 0xF2B4, 0xE62B, 0xE3BA, 0xD864, 0xD544, 0xCD62, 0xCFB9, 0xD4B7, 0xD475, 0xDB40, 0xDB27, 0xE0C7,
    0xE53D, 0xE549, 0xE6C5, 0xE334, 0xEB00, 0xF2A4, 0xEF52, 0xEE64, 0xF760, 0xF980, 0xF8B8, 0xFCDF, 0x0962, 0x0DF4, 0x0978, 0x0365,
    0x0377, 0x099E, 0xFF2C, 0x0329, 0x04A1, 0x09FA, 0x08BC, 0x07BC, 0x0C61, 0x0282, 0x0232, 0x05F4, 0x038E, 0x04CF, 0xFA59, 0xFC52,
    0xF86E, 0xFDAE, 0x04C2, 0x0646, 0x0E12, 0x04C7, 0x0468, 0xFC90, 0x009B, 0xFEEF, 0xFCC3, 0xFFD5, 0x0961, 0x07BD, 0x07D9, 0x0CD8,
    0x1119, 0x0CCC, 0x0983, 0x08B2, 0xFFDA, 0x0C3B, 0x1287, 0x19A6, 0x199A, 0x1444, 0x15A2, 0x0CA1, 0x09BF, 0x0905, 0x0FF1, 0x1C94,
    0x173A, 0x1DD4, 0x1558, 0x13A4, 0x1066, 0x10FA, 0x1583, 0x0CBF, 0x0C5E, 0x03D4, 0x04EA, 0x0A70, 0x0D20, 0x0983, 0x0797, 0x029B,
    0xF421, 0xEAD5, 0xEA50, 0xE789, 0xE752, 0xEBD3, 0xEBD2, 0xEDA4, 0xF108, 0xF89D, 0xF81B, 0xF49A, 0xF07E, 0xE54B, 0xE36C, 0xDE96,
    0xDFE8, 0xDF23, 0xE491, 0xE4B6, 0xE026, 0xE353, 0xE301, 0xE8E9, 0xE92B, 0xE516, 0xEAA5, 0xEB22, 0xEE01, 0xEBD8, 0xEA01, 0xF3A7,
    0xF773, 0x002E, 0xFFB7, 0x09F1, 0x0DB2, 0x0B7B, 0x056A, 0x05D9, 0x05B8, 0x0734, 0x0A1C, 0x0F4D, 0x0D8B, 0x099D, 0x0CB3, 0x0740,
    0x0CB7, 0x0709, 0x0E96, 0x0C7F, 0x0F29, 0x14E4, 0x0DC7, 0x0E9E, 0x0AAE, 0x1078, 0x12A1, 0x1079, 0x15DC, 0x0DCC, 0x1273, 0x0EB6,
    0x0F3D, 0x0E51, 0x0634, 0x08B2, 0x059C, 0x1047, 0x0CE9, 0x06FE, 0x063A, 0x0898, 0x0471, 0x0147, 0x00FA, 0x02D8, 0xFDC1, 0xFE91,
    0x014C, 0xFB74, 0xFC8B, 0xF7C9, 0xFC48, 0xF76A, 0xF373, 0xF340, 0xEEA2, 0xF0D5, 0xEA3B, 0xF1B6, 0xF604, 0xF86E, 0xFE26, 0xF9D4,
    0x03E1, 0xFF70, 0xFAC2, 0xFCE6, 0xFB75, 0x04F3, 0x0968, 0x12B0, 0x0AEA, 0x07F1, 0x12D7, 0x0BB0, 0x0A29, 0x0BCE, 0x1630, 0x10AA,
    0x0A14, 0x0BE9, 0x06AF, 0x036A, 0x0991, 0x0151, 0xFD9C, 0xFFE1, 0xFE68, 0xF75F, 0xEF13, 0xF9D4, 0xF0C0, 0xF8FC, 0xFD23, 0x02D4,
    0x0710, 0x0160, 0x06F2, 0x00C3, 0x045F, 0x054C, 0xFB64, 0xFD84, 0xF50F, 0xF6F2, 0xF7B1, 0xF649, 0xFA9C, 0xF65C, 0xF9DF, 0xF79B,
    0xFA6C, 0xFC0D, 0xFD79, 0xFCCC, 0xFCE2, 0xFD39, 0x0280, 0xFECC, 0x0287, 0xFFC6, 0x0388, 0x06DE, 0x045D, 0x0B88, 0x02FD, 0x08B2,
    0x062A, 0x06C7, 0x0A30, 0x0EDD, 0x1C4A, 0x1B49, 0x1E05, 0x1F63, 0x1B29, 0x20B6, 0x1F9A, 0x26DA, 0x29A9, 0x218C, 0x18C7, 0x10C2,
    0x10B6, 0x0937, 0x02C2, 0x01D5, 0x017B, 0x00B5, 0xFBF0, 0xF9AF, 0xF5AC, 0xEDB9, 0xEB7E, 0xE655, 0xE6EB, 0xE9D1, 0xE44D, 0xE0A7,
    0xDC15, 0xDF14, 0xD9ED, 0xD482, 0xD894, 0xD8B0, 0xE418, 0xE701, 0xE9F0, 0xE7B5, 0xEA9E, 0xF286, 0xF142, 0xF835, 0xFA6F, 0xF99F,
    0xF6E8, 0xF85E, 0xFE6F, 0xFF2F, 0x09DA, 0x122F, 0x1170, 0x0DE5, 0x0EE8, 0x0E86, 0x0BCD, 0x12BF, 0x1897, 0x1CF3, 0x18E6, 0x1A6D,
    0x157D, 0x15A1, 0x1227, 0x105D, 0x0896, 0x0560, 0x0E55, 0x0C9E, 0x1040, 0x0C78, 0x0D7F, 0x0C6C, 0x133B, 0x161B, 0x158E, 0x1CCC,
    0x1AC8, 0x1872, 0x1926, 0x1E7A, 0x1E09, 0x17D1, 0x1B97, 0x15B1, 0x167F, 0x1679, 0x14BA, 0x12CD, 0x11FA, 0x1160, 0x0757, 0x07A8,
    0xFEC2, 0xF7EC, 0xF1DB, 0xF738, 0xF899, 0xF389, 0xF7EA, 0xFC88, 0xFDD9, 0xF883, 0xFC38, 0xFC9F, 0xFDA6, 0x000D, 0xFC31, 0xF70B,
    0xF8A9, 0xFF24, 0xF7F2, 0xF58A, 0xF547, 0xF1B8, 0xEB3A, 0xEC44, 0xF636, 0xF679, 0xF871, 0xF4B1, 0xF3F9, 0xF241, 0xF53E, 0xF8F3,
    0xF46C, 0xF865, 0xF816, 0xFA76, 0xFF6A, 0x006D, 0xF711, 0xEC27, 0xECB8, 0xE9B2, 0xEAF8, 0xF2EF, 0xFDC8, 0xFCD5, 0xFC31, 0xFE32,
    0x01E3, 0x0301, 0x04DF, 0x0812, 0x0480, 0x066E, 0x02B0, 0x0737, 0x0961, 0x0E4C, 0x0AB0, 0x09F8, 0x1169, 0x08DE, 0xFF97, 0xFDB7,
    0x03B4, 0xFE48, 0xF9A6, 0xFBAA, 0xF7C2, 0xFF20, 0x0549, 0x0567, 0x08DF, 0x1383, 0x1A06, 0x13BF, 0x17B6, 0x1A2E, 0x17E5, 0x12B2,
    0x150E, 0x1757, 0x195D, 0x1AF7, 0x1BA3, 0x1A81, 0x179E, 0x154D, 0x0EE2, 0x1125, 0x134B, 0x185D, 0x1925, 0x1B59, 0x1A41, 0x120D,
    0x14B1, 0x1367, 0x0E17, 0x0F35, 0x173D, 0x15C5, 0x0761, 0x0B65, 0x0995, 0x0284, 0xFF06, 0xF8BD, 0xF034, 0xE477, 0xE9AB, 0xE54B,
    0xE521, 0xEDA5, 0xEC2E, 0xE7A7, 0xE1D9, 0xE1AB, 0xDB43, 0xDE83, 0xE434, 0xDF49, 0xE1AF, 0xE8E7, 0xE6B8, 0xE1C7, 0xECB3, 0xFBBC,
    0xFF7D, 0xFDDF, 0x0488, 0x0611, 0x08C8, 0x06DA, 0x02E5, 0x025C, 0xFFDA, 0x04C8, 0x0076, 0x03E7, 0x0377, 0xFAD1, 0xFED1, 0xFCED,
    0x007A, 0x0112, 0x08FD, 0x0D84, 0x07E8, 0x1368, 0x0EE3, 0x0C3C, 0x08DA, 0x0890, 0x062A, 0xFE34, 0x05B0, 0x027F, 0xFD77, 0xFEB3,
    0x01DF, 0x0464, 0x02FE, 0x0553, 0x04AC, 0xFF72, 0x04D6, 0x045C, 0x01EA, 0x04B2, 0x02F3, 0x0239, 0xFD86, 0xFFFF, 0xFD03, 0xF683,
    0xFDB9, 0xF9F6, 0xFA15, 0xF578, 0xFD53, 0x037C, 0xFD2A, 0x0A76, 0x0D78, 0x13AC, 0x1774, 0x1C9B, 0x1C20, 0x1866, 0x1EB4, 0x1A12,
    0x1A0D, 0x22D7, 0x23E9, 0x1DDB, 0x1CD6, 0x2161, 0x1D10, 0x13F4, 0x11E7, 0x05F4, 0xFE11, 0xFCFD, 0xF7BC, 0xF26F, 0xEAD5, 0xEC13,
    0xE293, 0xE258, 0xE86E, 0xE106, 0xE286, 0xE182, 0xE800, 0xE5DD, 0xE820, 0xEFD6, 0xE9A9, 0xEA55, 0xECC3, 0xEE75, 0xE8B1, 0xE8E8,
    0xEF1B, 0xEE45, 0xF2B9, 0xF6F6, 0xF0A9, 0xEE61, 0xF10D, 0xF048, 0xEF10, 0xF0BC, 0xF56D, 0xF3EA, 0xF954, 0xFDE2, 0xF826, 0xF650,
    0xF2C1, 0xF65E, 0xF7FD, 0x0168, 0x04EE, 0xFB2F, 0xFFA6, 0xFCAF, 0xFB20, 0xFC04, 0x0498, 0x0905, 0x0BF7, 0x1897, 0x17D3, 0x1CEE,
    0x2153, 0x2393, 0x1EBF, 0x1F04, 0x2811, 0x2469, 0x24DD, 0x2B75, 0x2C96, 0x2849, 0x275E, 0x267B, 0x21F8, 0x1E5B, 0x207F, 0x1B5C,
    0x1A94, 0x1E59, 0x1487, 0x09CE, 0x053B, 0x067F, 0xFD3A, 0xF811, 0xFBA2, 0xF6F5, 0xF93F, 0xF901, 0xF966, 0xF8ED, 0xFAFA, 0xFE70,
    0xF208, 0xF0FC, 0xEEE4, 0xEE11, 0xEE4C, 0xEF11, 0xF66B, 0xF0BB, 0xEEF3, 0xE846, 0xE33C, 0xDFF5, 0xDCAB, 0xE562, 0xE343, 0xE6BB,
    0xEFA2, 0xF3EF, 0xF81F, 0xF509, 0xF898, 0xF861, 0xF903, 0xF793, 0xF3E7, 0xFA1A, 0xFCDC, 0xFDC1, 0x017B, 0x06B0, 0x05BC, 0x0328,
    0x0655, 0x0764, 0x0145, 0x02AC, 0xFF5D, 0x04F7, 0x1117, 0x160F, 0x1A0E, 0x1646, 0x1C75, 0x169E, 0x178B, 0x1C7C, 0x1899, 0x185C,
    0x126C, 0x14CE, 0x0E69, 0x0934, 0x097E, 0xFCF4, 0xF4CC, 0xF703, 0xFA6C, 0xFADE, 0xFB38, 0xFE16, 0xF920, 0xF759, 0xF5B8, 0xEEA6,
    0xF37D, 0xF56E, 0xFA12, 0xF801, 0xF5E1, 0x0260, 0xFD16, 0xFF6A, 0x0680, 0x0C8B, 0x0F83, 0x0E80, 0x18A9, 0x0F1E, 0x18A1, 0x1CB5,
    0x1055, 0x1639, 0x19E6, 0x1968, 0x125B, 0x19DA, 0x1ADB, 0x1439, 0x18FD, 0x17C2, 0x12A5, 0x0FFF, 0x0A95, 0x0784, 0xFE3B, 0xF8D9,
    0xF87D, 0xEEEE, 0xEA4E, 0xE97F, 0xEE12, 0xE935, 0xE440, 0xEA0E, 0xE6D1, 0xEEA6, 0xF1A4, 0xEFA0, 0xF889, 0xF3D8, 0xF387, 0xEF28,
    0xF724, 0xF632, 0xF386, 0xFA70, 0xF08F, 0xF4B1, 0xF1AD, 0xF1E8, 0xF551, 0xF75B, 0xF9B1, 0xF9FF, 0xFB60, 0xF7A3, 0xF957, 0xFD05,
    0xF6A8, 0xF714, 0xFB93, 0xF9BA, 0xFCA7, 0xFD2F, 0x034C, 0x0A9D, 0x0F1A, 0x1269, 0x10C3, 0x12E3, 0x108D, 0x111D, 0x14DF, 0x1224,
    0x1A4D, 0x1ADA, 0x18E9, 0x11FB, 0x10DE, 0x15B5, 0x0BC7, 0x0659, 0x02B9, 0x085C, 0x045B, 0x0340, 0x0D10, 0x0EA4, 0x0F8B, 0x10B5,
    0x0EDB, 0x0AC6, 0x0D4C, 0x0C1C, 0xFBD3, 0xF966, 0xFDE6, 0xF669, 0xF895, 0xFBE3, 0x0277, 0x0260, 0x05AC, 0x0797, 0x06A0, 0x0D9E,
    0x0B32, 0x0A16, 0x0B20, 0x0B9F, 0x0BD5, 0x071C, 0x036D, 0x0487, 0xFE66, 0xFE37, 0xFBE7, 0xFE16, 0xFA9F, 0xFDCE, 0x0133, 0xF479,
    0xF5AA, 0xEFF7, 0xEB71, 0xE9C7, 0xE967, 0xE9B1, 0xE95E, 0xED30, 0xEB22, 0xEA47, 0xF2B9, 0xF11D, 0xF47A, 0xF4A3, 0xF5A6, 0xFD2F,
    0xFAD6, 0xFDA8, 0xFD4A, 0x00D4, 0xFC9C, 0xF6DE, 0xF954, 0xF5BA, 0xFCD6, 0x032E, 0xFF30, 0xFF04, 0xFB2A, 0xFC83, 0xF765, 0xFDD6,
    0x0076, 0xFC70, 0xFFFF, 0xF5ED, 0xFB3C, 0xF78F, 0xF25B, 0xF542, 0xF702, 0xF955, 0xF9BC, 0xFE5D, 0xF9F0, 0xF93A, 0x017B, 0x01E9,
    0x029F, 0x0B2C, 0x117B, 0x171B, 0x17EC, 0x1E89, 0x2558, 0x24F5, 0x297D, 0x2D40, 0x335C, 0x3085, 0x30C0, 0x3460, 0x2B5D, 0x2DED,
    0x2EB9, 0x2AAB, 0x2436, 0x21F5, 0x23AD, 0x141A, 0x145B, 0x1433, 0x152E, 0x1171, 0x0D7F, 0x136A, 0x098F, 0x0855, 0x05CD, 0x0001,
    0xFAA0, 0xFDF8, 0xFF72, 0xFA89, 0x0071, 0x02BA, 0xFADD, 0xFB0F, 0xF8C9, 0xEFF0, 0xECF4, 0xEB47, 0xE54F, 0xE138, 0xE58E, 0xE208,
    0xDBD9, 0xDF11, 0xDD28, 0xD789, 0xD5C0, 0xD3A8, 0xD862, 0xD622, 0xD8E5, 0xD72A, 0xD851, 0xD969, 0xDB6D, 0xDFC4, 0xDBC7, 0xE35D,
    0xE71E, 0xEDBD, 0xF648, 0xFACE, 0xFF2D, 0x097F, 0x1361, 0x1495, 0x1736, 0x1FC5, 0x1CB5, 0x1E30, 0x2281, 0x23E6, 0x2432, 0x21B1,
    0x20E2, 0x1BCC, 0x1DA4, 0x18ED, 0x179A, 0x1886, 0x1242, 0x0DA7, 0x0C00, 0x0A26, 0x055D, 0x0454, 0x0970, 0x0A17, 0x0897, 0x0400,
    0xFFF2, 0xFE07, 0xF97F, 0x0179, 0x0290, 0xFDF0, 0xFFB1, 0x0255, 0xFF30, 0xFB76, 0x04FC, 0x066A, 0x02B6, 0x07D6, 0x08A4, 0x0648,
    0x0306, 0xFEB7, 0xFE8F, 0xFACC, 0x02B3, 0x05B8, 0x03F7, 0x0A85, 0x10CF, 0x1827, 0x120C, 0x1744, 0x1892, 0x0C87, 0x0BDB, 0x0623,
    0x059D, 0x0736, 0x04F9, 0x0001, 0xF5BD, 0x0156, 0xFAB9, 0xF3F9, 0xF4D9, 0xF614, 0xFCA8, 0xF540, 0xFBB7, 0xF84B, 0xF7DF, 0xFE31,
    0xFD77, 0xFAEE, 0xF8F4, 0xFF04, 0x033A, 0xFC19, 0x0589, 0x0855, 0x033A, 0x06C6, 0x0377, 0x0334, 0x0076, 0x0362, 0xFCEC, 0xF71C,
    0xFD1D, 0xF5B4, 0xF33B, 0xF40F, 0xECE9, 0xF163, 0xEC81, 0xE94B, 0xE5CA, 0xF05C, 0xF74B, 0xEBDB, 0xF267, 0xF243, 0xF429, 0xEFDB,
    0xEDDF, 0xF5B6, 0xF97D, 0x0210, 0x0286, 0xFF91, 0xFF5C, 0xFF0E, 0xFF95, 0xFB6B, 0x064F, 0x1069, 0x0C48, 0x11D2, 0x168C, 0x172C,
    0x16B7, 0x16BB, 0x0EBD, 0x08A6, 0x0F0D, 0x09F6, 0xFFDE, 0x05AC, 0x0951, 0x08F7, 0x0B8E, 0x0E6F, 0x0FF6, 0x0BE9, 0x0E10, 0x08AE,
    0x0B5A, 0x12B3, 0x186D, 0x1A8A, 0x1701, 0x1B1F, 0x1484, 0x09FB, 0x04E9, 0x0461, 0x0057, 0xFF2F, 0x0388, 0xFFAC, 0xFBFD, 0xFFE3,
    0xF4E6, 0xED45, 0xED23, 0xF0C9, 0xEC1A, 0xE3DD, 0xE757, 0xE693, 0xE5ED, 0xE070, 0xDDFC, 0xDDBF, 0xE152, 0xE948, 0xEB10, 0xE9BF,
    0xF19B, 0xF4FE, 0xF7A7, 0xFC62, 0x059E, 0x0489, 0x00C6, 0x0376, 0x024C, 0x0767, 0x072D, 0x04C5, 0x04E4, 0x086A, 0x0649, 0x04E4,
    0x05FD, 0x0839, 0x09EC, 0x0E0F, 0x0C25, 0x092A, 0x08C0, 0x03B6, 0x0121, 0x0014, 0x08B7, 0x0D2E, 0x06C9, 0x035D, 0x04F8, 0x05E4,
    0x018F, 0x04EA, 0x06F6, 0x0009, 0x0A39, 0x0E5C, 0x0AD5, 0x0F06, 0x188E, 0x14F5, 0x0D74, 0x1911, 0x1424, 0x0E5C, 0x10F4, 0x153F,
    0x13DD, 0x14E8, 0x165F, 0x08E1, 0x07A4, 0x0C09, 0x0CEE, 0x0588, 0x0881, 0x1200, 0x0FF0, 0x0EDA, 0x10E4, 0x0C0C, 0x0623, 0x0A30,
    0x0BA1, 0x06CA, 0x0B6C, 0x11C1, 0x0941, 0x086D, 0x10A7, 0x0CE5, 0x0510, 0x0371, 0x009C, 0xFC8A, 0xF9E7, 0xF57D, 0xEC48, 0xF112,
    0xEF64, 0xE9E6, 0xE501, 0xE0A3, 0xE1FE, 0xD963, 0xD9DE, 0xDAF0, 0xDFE1, 0xE24F, 0xE019, 0xE2A5, 0xE280, 0xE785, 0xE818, 0xDF2E,
    0xE3B7, 0xE477, 0xE4DF, 0xE568, 0xE773, 0xEF1F, 0xEF10, 0xF5DE, 0xF4CB, 0xFB12, 0x0878, 0x092B, 0x0BD2, 0x0B95, 0x0DD8, 0x137E,
    0x12D0, 0x186B, 0x1A1C, 0x2074, 0x222D, 0x1CFA, 0x1F29, 0x1E9A, 0x24AE, 0x1D4F, 0x12AA, 0x1893, 0x1708, 0x1313, 0x0FA7, 0x0F58,
    0x0F74, 0x0D63, 0x1233, 0x083A, 0x075C, 0x0E7E, 0x0465, 0x0177, 0x00E5, 0x07A9, 0x092F, 0x0975, 0x10E6, 0x0EAF, 0x126E, 0x0EC6,
    0x0AFD, 0x0B6D, 0x0A0D, 0x106F, 0x09DA, 0x03E5, 0x0A6C, 0x0A61, 0x06D6, 0x0620, 0x0D0C, 0x07C6, 0x04C0, 0x08D7, 0xFF9C, 0xFB00,
    0xFC1C, 0xF46F, 0xEA58, 0xECB8, 0xEE57, 0xE852, 0xE2C8, 0xE42A, 0xE1C0, 0xE22F, 0xDF86, 0xDE38, 0xE4C5, 0xEAD7, 0xEF24, 0xEF33,
    0xF36E, 0xFA81, 0xFEE7, 0xFFD8, 0x006B, 0x04E5, 0x09F9, 0x0FE9, 0x1482, 0x1378, 0x19A9, 0x1937, 0x1276, 0x0EF6, 0x1455, 0x0C6C,
    0x072A, 0x0ADE, 0x053C, 0x0761, 0x09DF, 0x026F, 0xF83D, 0xFE84, 0xFE8D, 0xF8CD, 0xF6D0, 0xF9FC, 0xFC02, 0xF832, 0xFD2A, 0x0058,
    0x0048, 0x0055, 0xFDF2, 0xFBCD, 0xF9C4, 0xFED5, 0xFDC0, 0xF63C, 0xFA72, 0xFC48, 0xF80F, 0xFEF9, 0x045B, 0x0321, 0x0747, 0x0821,
    0x0834, 0x0640, 0x0CEA, 0x0CC7, 0x02AC, 0x09B5, 0x0858, 0x0C77, 0x09B8, 0x02D1, 0x0D80, 0x05F7, 0x0699, 0x09AE, 0x0A5F, 0x11D4,
    0x1503, 0x205E, 0x1DA9, 0x1E5D, 0x28DE, 0x1D3C, 0x20B0, 0x254A, 0x217B, 0x2176, 0x1B90, 0x1F99, 0x1ACB, 0x186D, 0x167B, 0x103B,
    0x1408, 0x0EA7, 0x063F, 0x028B, 0xFC4F, 0xFA2D, 0xF22E, 0xEA69, 0xE9A7, 0xE666, 0xE225, 0xDF96, 0xDE98, 0xDED3, 0xE090, 0xE027,
    0xDA85, 0xDBE6, 0xE4B2, 0xE11A, 0xDD06, 0xE00C, 0xE24C, 0xE400, 0xE530, 0xE28A, 0xE6E3, 0xED22, 0xEEAA, 0xEEF8, 0xEF27, 0xF47D,
    0xF373, 0xF651, 0xF853, 0xF800, 0x01EE, 0x02BC, 0x0712, 0x073E, 0x0B5E, 0x15EF, 0x0DAB, 0x0D1A, 0x10A9, 0x135A, 0x0F0B, 0x094F,
    0x096E, 0x0402, 0x06E2, 0x0935, 0x02B8, 0x06F6, 0x1289, 0x12F1, 0x12F8, 0x1900, 0x1DE0, 0x1E08, 0x1B76, 0x1F5E, 0x223A, 0x2530,
    0x2642, 0x2180, 0x1E52, 0x1BF2, 0x1B9F, 0x152F, 0x0CBB, 0x0FF8, 0x1103, 0x0B5E, 0x0CE2, 0x0B44, 0x0809, 0x05E0, 0xFFCE, 0xFFF0,
    0x011D, 0x034F, 0x0051, 0xFBB0, 0xFF07, 0xF892, 0xFD36, 0xFE38, 0xF759, 0xFFDB, 0xFF8B, 0x0121, 0xFE8B, 0xFD8A, 0xFEA0, 0xFA90,
    0x0002, 0xF928, 0xF445, 0xF463, 0xEA91, 0xEA08, 0xEA1E, 0xE7CD, 0xEB5F, 0xE809, 0xE4DC, 0xE40C, 0xE47E, 0xE834, 0xE6D1, 0xED9D,
    0xEBE6, 0xE8C0, 0xEB04, 0xE67E, 0xEBA3, 0xEB6D, 0xEBAE, 0xF421, 0xFB40, 0xFF14, 0xFF06, 0xFEE7, 0x0174, 0x0392, 0x056D, 0x07BA,
    0x0A7D, 0x106E, 0x0DB8, 0x0DD0, 0x103B, 0x0B30, 0x0F16, 0x0E9C, 0x0CE2, 0x0CE0, 0x082F, 0x0430, 0xFE39, 0xFE7D, 0xFBEF, 0xF6CE,
    0xFADC, 0xF9BA, 0xFA87, 0x0061, 0xFE5F, 0x0274, 0xFFBF, 0x0158, 0x05EB, 0x009A, 0x071C, 0x08B1, 0x07A6, 0x0694, 0x0AF9, 0x108F,
    0x0C9D, 0x12A9, 0x14A7, 0x10F9, 0x1444, 0x12E8, 0x0D2C, 0x0D8B, 0x1188, 0x0F33, 0x0E70, 0x12F1, 0x121A, 0x0EF9, 0x0CC7, 0x0909,
    0x07DA, 0x0958, 0x06CA, 0x0339, 0x01E4, 0x0045, 0xFB00, 0xF17C, 0xE984, 0xED78, 0xEC1A, 0xE504, 0xE723, 0xE1DF, 0xE60C, 0xE668,
    0xE707, 0xE835, 0xE8EB, 0xF3A1, 0xE9F4, 0xF056, 0xF7B9, 0xF65A, 0xFCF4, 0xF6CF, 0xFB2C, 0x0121, 0x04D3, 0x067F, 0xFC99, 0x03DE,
    0x0835, 0x0550, 0x05C7, 0xFFB1, 0x0B07, 0x0C92, 0x04A5, 0x0A9A, 0x06EC, 0x0A48, 0x07FF, 0x025B, 0x0569, 0x024E, 0x099F, 0xFD4F,
    0xF847, 0x022D, 0xFE4D, 0x02DF, 0xFF85, 0xFED3, 0x008E, 0x0068, 0x0385, 0xF9E6, 0xFC6A, 0x069A, 0x00DD, 0xFC0B, 0xFF1E, 0x09DB,
    0x08D7, 0x009B, 0x0294, 0x0021, 0xFDE4, 0x01DC, 0xFEC8, 0xFB59, 0x00AB, 0xFED2, 0xF416, 0xEDB7, 0xF54C, 0xF441, 0xEF66, 0xF1FB,
    0xF409, 0xF97B, 0xFB1D, 0xF87F, 0xF858, 0xFD8E, 0x02C4, 0x087E, 0x091D, 0x10F1, 0x1560, 0x1446, 0x19BA, 0x1C73, 0x20B2, 0x2260,
    0x263F, 0x25DE, 0x23D4, 0x2D54, 0x2B8C, 0x22A7, 0x2479, 0x22F1, 0x19FF, 0x0FF7, 0x06C7, 0xFC7E, 0xF582, 0xF095, 0xEBDB, 0xE8BC,
    0xED73, 0xE82F, 0xE4E5, 0xE742, 0xE1F6, 0xE35E, 0xE272, 0xE0CD, 0xDEAC, 0xDE55, 0xDC9A, 0xD5E5, 0xCE1D, 0xCF76, 0xCDFD, 0xCB70,
    0xC9C3, 0xD006, 0xD73B, 0xCFEB, 0xDCA7, 0xE4B2, 0xE4E2, 0xED95, 0xECDB, 0xF018, 0xF37F, 0xF76C, 0xF4F7, 0xED23, 0xF90D, 0xF9F3,
    0xF8FB, 0xFBB7, 0xF434, 0xF692, 0xF369, 0xF026, 0xF783, 0xFE7D, 0x0D92, 0x17A2, 0x2049, 0x2D68, 0x31D7, 0x3D65, 0x3BC8, 0x3FA2,
    0x4795, 0x4114, 0x474B, 0x44F6, 0x475F, 0x4BBD, 0x4799, 0x4108, 0x39A0, 0x389D, 0x2CA3, 0x1E5C, 0x1C16, 0x17C9, 0x1066, 0x10EE,
    0x0E32, 0x08D3, 0x01B5, 0xFD23, 0xFB1D, 0xF05A, 0xEF1A, 0xF49A, 0xF160, 0xF083, 0xF4DD, 0xF77A, 0xEFF1, 0xEA38, 0xE582, 0xDC0E,
    0xDAA3, 0xDAE7, 0xD2E2, 0xD3E3, 0xD8A9, 0xD26C, 0xD45F, 0xD2BC, 0xD680, 0xDA1C, 0xDFA9, 0xE638, 0xE54F, 0xED60, 0xE8F5, 0xE86F,
    0xF090, 0xF133, 0xF542, 0xF3CF, 0xF79A, 0xFCCF, 0xF41C, 0xF112, 0xEBB6, 0xE605, 0xE300, 0xE46E, 0xE65F, 0xE6F2, 0xF577, 0xFBE7,
    0xF203, 0xF99A, 0x0367, 0xFDCB, 0x0119, 0x077B, 0x0CBF, 0x13DA, 0x1F28, 0x2140, 0x206F, 0x2A55, 0x2F28, 0x2864, 0x2044, 0x1C64,
    0x15C6, 0x0D5B, 0x04C9, 0x0570, 0x015F, 0xFB98, 0xFDA6, 0xF44B, 0xF0B9, 0xF7DD, 0xFB99, 0xFC74, 0x0262, 0x12DB, 0x1462, 0x0D6E,
    0x0D46, 0x03A0, 0x0351, 0xFC16, 0xEF92, 0xF18B, 0xF536, 0xFB88, 0xF9AE, 0xFB09, 0x028F, 0x00EB, 0x08F9, 0x0C1C, 0x1066, 0x1C84,
    0x1B27, 0x1FB0, 0x1AD3, 0x1CED, 0x2146, 0x18E6, 0x1684, 0x1502, 0x13FB, 0x0DE2, 0x03D4, 0xFC99, 0xF0D0, 0xEC12, 0xECF6, 0xE2D9,
    0xE644, 0xEE44, 0xF014, 0xEF80, 0xEF0C, 0xF49E, 0xF5DC, 0xF33F, 0xF8AC, 0xFA51, 0xFB30, 0xFD7D, 0x03A3, 0x0920, 0x075C, 0x10BC,
    0x131E, 0x0D83, 0x0FD1, 0x0B63, 0x0154, 0xFEC0, 0xF85F, 0xF7EF, 0xF560, 0xF034, 0xEBCF, 0xE79A, 0xED3D, 0xE5AA, 0xEAED, 0xF792,
    0xF77A, 0xFEE9, 0x0026, 0x0198, 0xFD1D, 0xF4EC, 0xF213, 0xE9B9, 0xEB5B, 0xECEE, 0xEB62, 0xEBDC, 0xEDCF, 0xF642, 0xF3E5, 0xF08B,
    0xFC51, 0x0045, 0x00D0, 0x092F, 0x0A1E, 0x0939, 0x0B33, 0x0D98, 0x07FE, 0x0BA2, 0x16CA, 0x12BC, 0x1273, 0x1146, 0x0CB8, 0x0382,
    0xFDA3, 0xF626, 0xF342, 0xF857, 0xFA2A, 0x033C, 0x06EC, 0x0CD3, 0x1235, 0x1247, 0x11D2, 0x0F04, 0x1275, 0x144C, 0x131F, 0x18A3,
    0x18DF, 0x2218, 0x21C0, 0x1D5C, 0x24B2, 0x1E8E, 0x1AEA, 0x177F, 0x11D3, 0x0B88, 0x0084, 0xFD98, 0xEF9F, 0xE391, 0xE7A0, 0xDBEA,
    0xDBB6, 0xDAB2, 0xDFFE, 0xE76C, 0xE19D, 0xE9EC, 0xE8A5, 0xE714, 0xE67B, 0xE095, 0xDFAE, 0xD85B, 0xD663, 0xD5AD, 0xD089, 0xD974,
    0xD724, 0xD53A, 0xDC0E, 0xDBFE, 0xE055, 0xE268, 0xEA70, 0xF22E, 0xF4E4, 0xFCCF, 0xFA9F, 0xFEF8, 0x0538, 0x027F, 0x0664, 0x02A2,
    0x0217, 0x025F, 0xFA19, 0xF2E5, 0xEE31, 0xED95, 0xECD0, 0xEC48, 0xF227, 0xFA8C, 0x0008, 0x018A, 0xFEF2, 0x0C1D, 0x0F15, 0x0691,
    0x0C43, 0x1027, 0x1302, 0x1704, 0x1FFE, 0x214D, 0x21D5, 0x2AD4, 0x2E74, 0x2DC3, 0x33D5, 0x3A0A, 0x3D5E, 0x39C1, 0x33E4, 0x3526,
    0x3162, 0x29F5, 0x23BA, 0x1C44, 0x1BAD, 0x1D37, 0x1558, 0x11EF, 0x17AC, 0x1BB6, 0x0FBB, 0x089F, 0x01E4, 0xF56E, 0xEF17, 0xEB22,
    0xE33E, 0xE321, 0xE65E, 0xDC81, 0xD6AC, 0xD22D, 0xD450, 0xD30A, 0xD20C, 0xD28B, 0xD229, 0xDA0D, 0xD802, 0xD681, 0xD89D, 0xD7AB,
    0xDD86, 0xDC9C, 0xE083, 0xE8AC, 0xE7BF, 0xEA02, 0xE75A, 0xE653, 0xE743, 0xE904, 0xEE22, 0xEF2D, 0xF8E9, 0x043A, 0x0657, 0x0FFF,
    0x1349, 0x10A6, 0x12A8, 0x118E, 0x14B7, 0x1369, 0x1638, 0x178A, 0x1517, 0x16A1, 0x16BB, 0x1C8B, 0x1D94, 0x1E84, 0x26B7, 0x2732,
    0x258D, 0x2BC9, 0x2A70, 0x2554, 0x2277, 0x21C1, 0x1AED, 0x11A8, 0x0C95, 0x098B, 0x0BD1, 0x0B50, 0x08B4, 0x0B1C, 0x0D0B, 0x08EB,
    0x05D1, 0xFD57, 0xF532, 0xF24C, 0xEDBD, 0xE75A, 0xE8D5, 0xEB90, 0xECD5, 0xE9AD, 0xEAA0, 0xEE4C, 0xF55A, 0xFB63, 0xF762, 0xFF41,
    0x0013, 0xFE5D, 0xFE42, 0xF79B, 0xF3C5, 0xF82A, 0xFCEB, 0xF898, 0xF609, 0xFE56, 0xFAD3, 0xF0F8, 0xF142, 0xF061, 0xF19E, 0xEE4A,
    0xF00C, 0xF893, 0xF7A5, 0xFB6F, 0xFA7D, 0xF63E, 0xF762, 0xF89F, 0xFD06, 0xF13A, 0xF261, 0xF719, 0xF53A, 0xF8AA, 0xF768, 0xFE5A,
    0x0524, 0x0A42, 0x0B70, 0x130C, 0x1C22, 0x1BE0, 0x1ABB, 0x1827, 0x13D3, 0x117E, 0x0B35, 0xFF83, 0xFE34, 0x00A5, 0xFF25, 0xFBD2,
    0xFF33, 0x0072, 0xFABC, 0xF567, 0xEFDF, 0xEDD6, 0xE6B8, 0xE4A5, 0xE475, 0xE15A, 0xE331, 0xE13F, 0xDF13, 0xDDAE, 0xE5FF, 0xEEB2,
    0xEDC8, 0xFA92, 0x02FC, 0x07F5, 0x096A, 0x049B, 0x0445, 0x06A4, 0x0A2B, 0x0608, 0x053E, 0x0C03, 0x0ADC, 0x05AE, 0x0429, 0xFEC4,
    0x065F, 0x023A, 0x0172, 0x0971, 0x0A0D, 0x1368, 0x14F1, 0x1411, 0x14EC, 0x1807, 0x1E77, 0x1316, 0x1028, 0x1893, 0x1400, 0x17B9,
    0x1283, 0x151B, 0x1D52, 0x1A04, 0x1987, 0x18AC, 0x20A6, 0x274F, 0x1F7D, 0x2123, 0x1BA5, 0x1786, 0x1116, 0xFB02, 0xF908, 0xED2D,
    0xE93B, 0xE7A1, 0xDAB5, 0xDD99, 0xE07A, 0xE008, 0xD6EB, 0xD1B6, 0xD9E4, 0xD086, 0xCB3A, 0xCE4F, 0xCAD7, 0xD2BA, 0xD146, 0xCC80,
    0xCC89, 0xCDA7, 0xD697, 0xD822, 0xDD79, 0xE958, 0xEFB3, 0xF5CF, 0xF05C, 0xF009, 0xF55D, 0xF1A6, 0xF5A2, 0xF6EB, 0xF998, 0x011F,
    0xFE46, 0xFC15, 0xFB59, 0xF680, 0xF5B5, 0xF510, 0xF666, 0xF771, 0xFBB4, 0x0537, 0xFECD, 0x046D, 0x0E5D, 0x0B1C, 0x0B27, 0x0617,
    0x048A, 0x0551, 0x05B0, 0x0CAA, 0x0F8A, 0x1729, 0x1D80, 0x19C8, 0x1E95, 0x21F0, 0x2759, 0x295C, 0x2BB9, 0x37EF, 0x3533, 0x3315,
    0x386B, 0x2C11, 0x244D, 0x235A, 0x24CA, 0x2082, 0x1EC2, 0x2793, 0x1FD9, 0x1D91, 0x1B9F, 0x15B6, 0x0EDB, 0x0554, 0x0181, 0xFFC3,
    0xF612, 0xEEB9, 0xED23, 0xE578, 0xE02A, 0xDF0D, 0xE1A4, 0xE3B9, 0xE85F, 0xEB35, 0xE5D1, 0xE7D7, 0xE8F8, 0xE212, 0xE499, 0xE6D5,
    0xE5B5, 0xE6CE, 0xE4CC, 0xE3A4, 0xE35A, 0xE2A3, 0xE2CE, 0xE067, 0xE51B, 0xE5D9, 0xE620, 0xECD0, 0xE3E1, 0xF002, 0x044D, 0x074E,
    0x0189, 0xF67A, 0xFAD5, 0xF564, 0xDDBC, 0xD331, 0xCBBF, 0xBC28, 0xB463, 0xC352, 0xD3B1, 0xD06B, 0xDDD1, 0xD85C, 0xDB2F, 0xEEFA,
    0xF3C9, 0x0727, 0x081B, 0x1241, 0x1B0A, 0x10F5, 0x11BA, 0x08AE, 0x057F, 0x08DE, 0x018B, 0x098B, 0x0D76, 0x0C14, 0x08AC, 0xFE7F,
    0xFD8D, 0xFB73, 0xECE5, 0xF13E, 0x019B, 0xEDEB, 0xDBC8, 0xE304, 0xE195, 0xEC81, 0x001A, 0x0175, 0x14BB, 0x25C7, 0x3118, 0x399A,
    0x4804, 0x4FAA, 0x45F3, 0x4313, 0x39F8, 0x3718, 0x3282, 0x3EB9, 0x41E0, 0x2B1A, 0x23C9, 0x1C97, 0x12E4, 0xFA2F, 0xED63, 0xE7F1,
    0xD142, 0xCFE5, 0xCA4D, 0xD0E1, 0xD8DC, 0xD572, 0xD72E, 0xCB47, 0xD40C, 0xDB5C, 0xD699, 0xD9F5, 0xD8A1, 0xE5F3, 0xEB31, 0xDCD3,
    0xD62D, 0xDC29, 0xE0F1, 0xE24A, 0xE8AF, 0xF1AD, 0xF9F8, 0xFA3A, 0xFD0E, 0xFF59, 0xF52A, 0xEB9B, 0xFCF7, 0xFD02, 0xFC0F, 0xFD7B,
    0xF0BA, 0xFA9C, 0xFAC0, 0xFECB, 0x04F4, 0x101C, 0x172F, 0x17EB, 0x2510, 0x2997, 0x2B1B, 0x1ACF, 0x17C0, 0x1440, 0xFEDA, 0x07BB,
    0x1A8A, 0x246B, 0x1A3D, 0x1CDD, 0x1952, 0x0603, 0x02FF, 0xF3F0, 0xE200, 0xCD7B, 0xC0DE, 0xC3CA, 0xBD9B, 0xBCE1, 0xC698, 0xC361,
    0xBF21, 0xBE60, 0xC664, 0xCDFF, 0xCE6A, 0xDC74, 0xE9FE, 0xED87, 0xF37E, 0xEB48, 0xEA6E, 0xEDB9, 0xE98A, 0xEBC9, 0xF314, 0xF5B3,
    0xF2CD, 0x0987, 0x0A50, 0xFFFF, 0x06E3, 0x0D3A, 0x19C8, 0x21D7, 0x1BA2, 0x1D59, 0x205E, 0x192A, 0x2167, 0x1FE8, 0x1DB0, 0x2330,
    0x24E3, 0x34C8, 0x3EA1, 0x4293, 0x406D, 0x39A0, 0x3051, 0x1072, 0x1287, 0x19B5, 0x10E7, 0x17D9, 0x0AFD, 0x0399, 0xFACE, 0xE8C3,
    0xE018, 0xCFF2, 0xC84D, 0xBE6F, 0xBA46, 0xC190, 0xBF48, 0xC925, 0xCDD4, 0xC83E, 0xCEDB, 0xD72C, 0xDB1E, 0xDFBC, 0xE306, 0xE86C,
    0xEE06, 0xEB7A, 0xDE7C, 0xE03F, 0xDE2E, 0xD1D1, 0xDE4B, 0xDBEE, 0xD5DB, 0xE815, 0xF95F, 0xFAA5, 0xFA38, 0xFDC7, 0x014F, 0x0E0D,
    0x0B6F, 0x08BD, 0x0DB1, 0x0C77, 0x0E2C, 0x0DF8, 0x1D98, 0x2443, 0x257C, 0x31A4, 0x3CF3, 0x56B4, 0x5D9F, 0x65C9, 0x6CA6, 0x5B6F,
    0x58C6, 0x4B52, 0x491C, 0x4E4F, 0x4B4D, 0x5585, 0x4B84, 0x467D, 0x4127, 0x3252, 0x2C99, 0x1596, 0x0526, 0x0113, 0xF039, 0xEBD7,
    0xEABC, 0xE48F, 0xD98F, 0xD032, 0xD3B8, 0xCADE, 0xD170, 0xD8BB, 0xDBD0, 0xE5B9, 0xDE50, 0xE77B, 0xE4AE, 0xD856, 0xE0A7, 0xE1A1,
    0xDFAE, 0xD9C9, 0xE03B, 0xEB73, 0xECF6, 0xE3C8, 0xDE52, 0xE09A, 0xE66A, 0xE9A9, 0xE355, 0xEB22, 0xE67E, 0xE66B, 0xEC56, 0xF6B9,
    0x072F, 0x06B3, 0x14AB, 0x2080, 0x223A, 0x351E, 0x3AEB, 0x4588, 0x4486, 0x35D2, 0x39DA, 0x2F36, 0x2FDC, 0x3A1C, 0x3FDB, 0x46EC,
    0x496A, 0x4B91, 0x4C60, 0x3C89, 0x3716, 0x2061, 0x1523, 0x10EF, 0x0735, 0x132F, 0x06CB, 0x0C6C, 0x066D, 0x050A, 0x098F, 0x0012,
    0x0C58, 0x0F59, 0x0B59, 0x122B, 0x06CF, 0xFC1D, 0xEFE6, 0xE26C, 0xE7B7, 0xDFEA, 0xD891, 0xD9C5, 0xE876, 0xF135, 0xEDE9, 0xEFA2,
    0xF7A7, 0xFEA7, 0x0C35, 0x0DC6, 0x12E8, 0x163C, 0x0AF1, 0x14EF, 0x1517, 0x0DFC, 0x127A, 0x15AE, 0x1468, 0x1E79, 0x290F, 0x3602,
    0x3B9B, 0x429E, 0x3E5C, 0x33CC, 0x34A5, 0x2DE4, 0x2F95, 0x2E71, 0x2C9B, 0x2E60, 0x2A84, 0x22BF, 0x1888, 0x0885, 0xFAD3, 0xE309,
    0xD813, 0xD27A, 0xDA82, 0xE7E4, 0xDEEC, 0xE9E6, 0xF143, 0xEB58, 0xEE99, 0xF08F, 0xEF22, 0xF9B5, 0x0071, 0x0473, 0xFE90, 0xFACB,
    0xFC2D, 0x0012, 0xFFF1, 0xF006, 0xF39C, 0x0284, 0xFF87, 0xF7CD, 0xF1B1, 0xEEA4, 0xF46C, 0xE637, 0xED21, 0xF0B1, 0xE64C, 0xE84C,
    0xE346, 0xE537, 0xE478, 0xEE4D, 0xF74D, 0xF65E, 0x0BE5, 0x235B, 0x2ED3, 0x4250, 0x416A, 0x4478, 0x439D, 0x34C7, 0x2BC6, 0x25C5,
    0x2AC1, 0x1F15, 0x1A7F, 0x22FC, 0x1CC1, 0x23F0, 0x1F38, 0x0C46, 0x0C1B, 0xF4FE, 0xF2A5, 0xEFB7, 0xE864, 0xF3B1, 0xF3A9, 0xF1BD,
    0xE662, 0xEA45, 0xEAB9, 0xDB7D, 0xDCF9, 0xE8F8, 0xEE59, 0xFA9F, 0xF647, 0xFE20, 0x1067, 0x0F73, 0x093A, 0xFDD8, 0x068B, 0x1026,
    0x0833, 0x08C7, 0x02D0, 0xFD2D, 0x00FA, 0xFB9A, 0x00F5, 0xF97B, 0xFACD, 0xFB1F, 0xEC97, 0xE7DD, 0xE70A, 0xE3FD, 0xDE13, 0xDAA6,
    0xE651, 0xF1A6, 0xFAAC, 0x086E, 0x025C, 0x0D8F, 0x05F7, 0xFF78, 0x049D, 0x00C4, 0x0E0C, 0x0C43, 0x0B76, 0x163B, 0x18A2, 0x18FF,
    0x0C2E, 0xF835, 0xEE08, 0xDA40, 0xD129, 0xC852, 0xC73A, 0xCE4D, 0xC841, 0xCA34, 0xCE15, 0xCFA2, 0xD3BB, 0xD2A3, 0xDBC7, 0xEC15,
    0xEF90, 0xF22F, 0xECEA, 0xF74C, 0xF70E, 0xE1E6, 0xE0F6, 0xE7E6, 0xE9FA, 0xF439, 0xFDDE, 0xFFD3, 0x00CD, 0x0A73, 0x1A50, 0x12E9,
    0x1884, 0x1C7D, 0x1C23, 0x18CB, 0x0F11, 0x18F6, 0x1682, 0x112B, 0x16DC, 0x1809, 0x2A76, 0x3D28, 0x4551, 0x5065, 0x4778, 0x4828,
    0x3842, 0x287D, 0x26AD, 0x15E2, 0x1B74, 0x1995, 0x0C0F, 0x144B, 0x11FD, 0x07E4, 0xF608, 0xE29E, 0xDE67, 0xCE0A, 0xD3A6, 0xD064,
    0xCE63, 0xD6C8, 0xCF8F, 0xD4D0, 0xD1EA, 0xC96C, 0xC972, 0xC909, 0xC9DF, 0xCA53, 0xBE2F, 0xC76D, 0xCC3E, 0xCC52, 0xC482, 0xC4E9,
    0xD0CC, 0xCD62, 0xDA46, 0xE0AE, 0xE1C6, 0xE8D0, 0xEDD1, 0xED61, 0xF2FB, 0xF0F7, 0xF500, 0xEE7E, 0xEF01, 0xF3FF, 0xF5F3, 0x037C,
    0x007B, 0x05E2, 0x124F, 0x1A88, 0x2EB3, 0x3F24, 0x4590, 0x5887, 0x4D2B, 0x4892, 0x4299, 0x3C6A, 0x3CCE, 0x3966, 0x3C1F, 0x351B,
    0x3E20, 0x428A, 0x31A9, 0x22F4, 0x1629, 0xFA3D, 0xEC98, 0xD62B, 0xD24F, 0xCF00, 0xC487, 0xC395, 0xBD78, 0xC1B5, 0xBDC3, 0xBB7B,
    0xC1A1, 0xC858, 0xD2E2, 0xD5C4, 0xD7A1, 0xE957, 0xE6C4, 0xEB12, 0xE8AA, 0xE173, 0xE24A, 0xE7C3, 0xE9DA, 0xDE21, 0xDC8A, 0xE670,
    0xE641, 0xE737, 0xF089, 0xED62, 0xF774, 0xF0AC, 0xF6FC, 0xFD90, 0xFC87, 0x0135, 0xFD96, 0xF65E, 0xF46D, 0x014E, 0x0B00, 0x1824,
    0x21FB, 0x2CD9, 0x2B3D, 0x2C61, 0x27BD, 0x261C, 0x2D57, 0x2B1C, 0x2A80, 0x33C0, 0x386E, 0x39E0, 0x31F4, 0x2549, 0x16C6, 0x0364,
    0xFEC2, 0xEEDD, 0xF2B7, 0xF11A, 0xE790, 0xEA83, 0xEB7A, 0xE3CA, 0xD8D7, 0xD737, 0xDAFF, 0xCF58, 0xCBB7, 0xD1B7, 0xC9CB, 0xCC15,
    0xC363, 0xC813, 0xBDC7, 0xBAD0, 0xCB31, 0xC948, 0xC824, 0xCC9D, 0xD3AE, 0xE310, 0xE527, 0xED3D, 0xF8ED, 0xF2DB, 0xF6AC, 0xE939,
    0xEB63, 0xEAB3, 0xE720, 0xEC08, 0xE568, 0xE628, 0xF2C5, 0xFE54, 0x1242, 0x202F, 0x34C8, 0x4350, 0x3CAC, 0x474E, 0x4350, 0x4372,
    0x3CA2, 0x3505, 0x38E4, 0x385D, 0x3904, 0x3E25, 0x31FF, 0x253B, 0x1B92, 0x1051, 0x0981, 0x00D2, 0x057C, 0xFD42, 0xFEB4, 0xFF51,
    0xF273, 0xED7C, 0xEDD1, 0xEB0E, 0xECD0, 0xE947, 0xEC5E, 0xEF69, 0xEBCE, 0xECD6, 0xE35B, 0xDC66, 0xD324, 0xD081, 0xCE15, 0xC68D,
    0xBFD2, 0xC08E, 0xBAB4, 0xC0FB, 0xC44E, 0xC3A0, 0xCB94, 0xC8A8, 0xC7F9, 0xC5AB, 0xCBF9, 0xCE3D, 0xD2E5, 0xD810, 0xDC95, 0xE4FD,
    0xF2D7, 0xF84C, 0x09F1, 0x1976, 0x1AB0, 0x1F4A, 0x1A28, 0x1EEE, 0x1D25, 0x16EC, 0x13B2, 0x183B, 0x22BE, 0x2ABE, 0x3335, 0x3AE3,
    0x318A, 0x2E70, 0x20D9, 0x134E, 0x0EAF, 0x0023, 0xFD92, 0xFAC2, 0xFC0F, 0xF82F, 0xF6C9, 0xFB46, 0xF77F, 0xF3B2, 0x0163, 0x0040,
    0x06B4, 0x0E37, 0x13F2, 0x1791, 0x04FF, 0x0295, 0x0241, 0x022D, 0x0202, 0x02AC, 0x0356, 0x0305, 0x06F2, 0x0DD5, 0x0765, 0x0DAF,
    0x0F0D, 0x07EA, 0x066D, 0xF896, 0xF930, 0xF98D, 0xE951, 0xE042, 0xE1AD, 0xE59A, 0xEDE9, 0xF2DC, 0x0621, 0x0B3B, 0x10CD, 0x15A3,
    0x11D5, 0x1C79, 0x1C94, 0x1BCF, 0x1773, 0x0FB2, 0x16EF, 0x1909, 0x11C0, 0x0C27, 0xF7A5, 0xEF62, 0xDF24, 0xD07A, 0xC593, 0xBB36,
    0xC893, 0xC86E, 0xC72C, 0xCE85, 0xD604, 0xDD5D, 0xDBAF, 0xD8B8, 0xE0D0, 0xE296, 0xE805, 0xEA0D, 0xEC32, 0xE74A, 0xE100, 0xE844,
    0xE6D0, 0xEA5A, 0xF42E, 0xFA29, 0xFB1E, 0x013B, 0x0ADD, 0x119D, 0x10AA, 0x1611, 0x1887, 0x1790, 0x1543, 0x1A78, 0x1EEC, 0x1A7D,
    0x1974, 0x18A0, 0x18F7, 0x185F, 0x27C0, 0x30C7, 0x317C, 0x2FBC, 0x30AF, 0x2CB0, 0x265D, 0x25F7, 0x210B, 0x185A, 0x1277, 0x1059,
    0x1574, 0x184A, 0x136D, 0x155C, 0x0DFE, 0x0B8D, 0x0414, 0xFB3A, 0xF3E9, 0xEAAE, 0xE9FE, 0xE420, 0xE094, 0xE50B, 0xE54E, 0xE66F,
    0xE05A, 0xD7F4, 0xDB68, 0xDACD, 0xE616, 0xE856, 0xEB48, 0xF04A, 0xEB99, 0xF1C5, 0xF104, 0xF0AF, 0xF2B7, 0xEAC1, 0xE7B4, 0xE59D,
    0xE384, 0xEAED, 0xE7FE, 0xEB1C, 0xECC6, 0xEC80, 0xF54F, 0xF928, 0xFD30, 0xFCB1, 0xFC72, 0xFF9B, 0xFA12, 0x0750, 0x1B2D, 0x22F1,
    0x349D, 0x38B4, 0x411D, 0x462C, 0x42F7, 0x4480, 0x3DC0, 0x374C, 0x36E9, 0x37D1, 0x3A68, 0x2D46, 0x2047, 0x1CD8, 0x0953, 0xFC22,
    0xE995, 0xE06B, 0xD8EC, 0xC9E0, 0xC58D, 0xC3D3, 0xC612, 0xC717, 0xCBCF, 0xD74A, 0xD895, 0xDBC6, 0xE1A8, 0xE58A, 0xEF92, 0xEADE,
    0xE9F6, 0xE973, 0xE6B1, 0xE52E, 0xE2CE, 0xDDFD, 0xD56F, 0xD78C, 0xDDD6, 0xDFCF, 0xEBBB, 0xFB26, 0x03E5, 0x0C1A, 0x0A65, 0x0E33,
    0x118F, 0x11D5, 0x0E9C, 0x0891, 0x01D8, 0xFEF7, 0x044C, 0x0D80, 0x1A7A, 0x29F5, 0x3AC8, 0x3E12, 0x427C, 0x47F5, 0x4BBA, 0x46E8,
    0x3B38, 0x3BB5, 0x4511, 0x4835, 0x45BF, 0x41D0, 0x3F2A, 0x3D67, 0x32D7, 0x2259, 0x0FF0, 0x0E63, 0x0694, 0xF03C, 0xE33D, 0xDC55,
    0xD908, 0xD4C1, 0xCB44, 0xC8F2, 0xC553, 0xC3E6, 0xC64D, 0xC090, 0xC219, 0xC17C, 0xC1E8, 0xBF7B, 0xC12A, 0xCDB4, 0xD169, 0xCFD6,
    0xD4E3, 0xD524, 0xDBCE, 0xE248, 0xE3DA, 0xEBD3, 0xEAEB, 0xF0F8, 0xEDB7, 0xE628, 0xE87E, 0xE83B, 0xEB6B, 0xE7DA, 0xE562, 0xFA8E,
    0x07E4, 0x1576, 0x25C1, 0x31F8, 0x4102, 0x4040, 0x4784, 0x4AA2, 0x442B, 0x3EFF, 0x3934, 0x3BDA, 0x3EF5, 0x4061, 0x4A9F, 0x4607,
    0x4293, 0x4235, 0x369C, 0x2B07, 0x1950, 0x1992, 0x1278, 0x0392, 0x0025, 0xFF9E, 0x040C, 0x00F3, 0xFE75, 0x01CA, 0xFF43, 0x0396,
    0x06E8, 0x0498, 0x00A9, 0xF882, 0xF65A, 0xEE97, 0xECD3, 0xECF6, 0xE686, 0xE0A8, 0xD967, 0xD2F1, 0xD2D4, 0xD218, 0xD4BF, 0xDC15,
    0xE171, 0xE6FC, 0xE978, 0xEDC3, 0xEB59, 0xEE4D, 0xEC35, 0xE134, 0xDF5E, 0xE668, 0xEA06, 0xEDE4, 0xF63E, 0xFAA1, 0xFCA1, 0xFEF5,
    0x0AB0, 0x0C06, 0x08DD, 0x0C47, 0x1248, 0x1ABC, 0x217D, 0x29A1, 0x3242, 0x2CF9, 0x29AD, 0x2111, 0x1230, 0x0E67, 0x0369, 0xFD9E,
    0xF598, 0xEFE0, 0xF0DA, 0xF2F8, 0xF7AA, 0xF77C, 0xF6D6, 0xFF14, 0xFEBE, 0x0318, 0x098A, 0x0777, 0x0C94, 0x0730, 0x094B, 0x10E1,
    0x138C, 0x157F, 0x13FF, 0x0E59, 0x0AFD, 0x047B, 0x0293, 0x034E, 0x051D, 0x0789, 0x01AB, 0xFFCD, 0xFAEB, 0xF680, 0xF45C, 0xE725,
    0xDC3F, 0xDD77, 0xDA16, 0xE2F0, 0xF1DD, 0x03C4, 0x0DB6, 0x1419, 0x253F, 0x2A7C, 0x3079, 0x33CA, 0x2C25, 0x2B98, 0x2D20, 0x2C96,
    0x2DF0, 0x2307, 0x2625, 0x23E2, 0x167C, 0x0B5E, 0x00F7, 0x0157, 0xF7DD, 0xF337, 0xEFBD, 0xEAC7, 0xF004, 0xECE8, 0xE569, 0xE2EB,
    0xDD19, 0xE0AB, 0xE0A7, 0xE0BD, 0xE570, 0xE9D2, 0xECF7, 0xE51D, 0xE86E, 0xF118, 0xF31A, 0xF10E, 0xED0E, 0xF01D, 0xF2EB, 0xEE61,
    0xF245, 0xF85B, 0x04DE, 0x0BD0, 0x0FC9, 0x1770, 0x1B51, 0x2405, 0x1A9D, 0x0A9B, 0x0356, 0xFAF8, 0xF68D, 0xFD73, 0x0593, 0x0C47,
    0x0BCC, 0x1225, 0x160B, 0x0D9F, 0x0C0A, 0x0BDC, 0x0A0E, 0x06DF, 0x0D4B, 0x1B78, 0x1F44, 0x20C1, 0x2A93, 0x2925, 0x24F1, 0x1E8B,
    0x162F, 0x108A, 0x02EA, 0xF442, 0xEA5C, 0xE2DB, 0xDFE4, 0xDA8E, 0xD7AE, 0xD6C2, 0xD3EE, 0xE2BA, 0xE85F, 0xEADF, 0xF498, 0xF8B5,
    0xFB17, 0xF9C5, 0xFC1F, 0xFF26, 0xF8EC, 0xF7AC, 0xF551, 0xF1B4, 0xF7C1, 0xF542, 0xFCAF, 0x0285, 0x0962, 0x12E0, 0x108F, 0x1AE4,
    0x2248, 0x1AD9, 0x174C, 0x0FE6, 0x09EE, 0x0539, 0x0B83, 0x20A6, 0x2578, 0x30DA, 0x3D7F, 0x43A3, 0x4538, 0x3D27, 0x36F7, 0x322A,
    0x2B82, 0x2AE6, 0x2566, 0x1EFA, 0x1ACB, 0x114F, 0x09AF, 0xF547, 0xEAC0, 0xE270, 0xD82B, 0xD05A, 0xC458, 0xC0AE, 0xC0B8, 0xBFA8,
    0xC0E9, 0xC366, 0xC67E, 0xC948, 0xCD68, 0xD19A, 0xD1B4, 0xD833, 0xD505, 0xCEF8, 0xCF53, 0xD120, 0xD3F5, 0xD4BF, 0xD513, 0xD906,
    0xDE43, 0xE411, 0xE681, 0xED9E, 0xFADD, 0x0004, 0x0684, 0x0729, 0x0B03, 0x1390, 0x1765, 0x1377, 0x0EBA, 0x09FA, 0x081D, 0x0876,
    0x0A6F, 0x14D0, 0x22C6, 0x3168, 0x3851, 0x428F, 0x4822, 0x442B, 0x41F4, 0x40D7, 0x428B, 0x4B7B, 0x4EF4, 0x53A4, 0x5770, 0x5343,
    0x4E2D, 0x4232, 0x37BE, 0x30D3, 0x2903, 0x1C42, 0x0C4E, 0x00D7, 0xF6C6, 0xE8B9, 0xE24D, 0xD533, 0xCFF5, 0xD411, 0xCF9B, 0xCF4C,
    0xD0EC, 0xD363, 0xD183, 0xCFFC, 0xD28A, 0xD7AA, 0xDDA7, 0xE1E9, 0xDBD1, 0xDDA3, 0xDC22, 0xD378, 0xD1E0, 0xCF42, 0xD1D6, 0xD253,
    0xD19D, 0xD70C, 0xDC02, 0xE150, 0xE99E, 0xE7C3, 0xE37C, 0xE2F9, 0xEF75, 0xF3D3, 0xF4CF, 0x05A4, 0x14B3, 0x1DB7, 0x268F, 0x2BB6,
    0x30D6, 0x3110, 0x2C6C, 0x2E0C, 0x3082, 0x3845, 0x3B9C, 0x46AC, 0x4411, 0x3ED8, 0x3CA2, 0x34C3, 0x2A10, 0x21B2, 0x1FF1, 0x17F0,
    0x128F, 0x0DC8, 0x10E4, 0x0A95, 0x0101, 0xFB68, 0xFC07, 0xFC1E, 0xFDE2, 0xFF95, 0xFA4A, 0xF35D, 0xEE38, 0xE418, 0xD616, 0xD51D,
    0xD383, 0xD275, 0xCDEF, 0xCC66, 0xCD31, 0xCC68, 0xCEB4, 0xD185, 0xD971, 0xE25E, 0xE8F5, 0xF534, 0xFC6E, 0x050A, 0x07F3, 0xF980,
    0xF22A, 0xEAD6, 0xEDDA, 0xED96, 0xED0D, 0xF85F, 0x0496, 0x18D5, 0x1EF1, 0x229A, 0x2F10, 0x2FC6, 0x3121, 0x32DA, 0x3488, 0x3B42,
    0x3D6C, 0x4440, 0x3E3E, 0x36FB, 0x33A4, 0x2C5C, 0x27EB, 0x16C8, 0x109C, 0x0F22, 0x0318, 0xFE48, 0xFAD3, 0xF665, 0xEE0E, 0xE9FD,
    0xE9A6, 0xE582, 0xF490, 0xFC20, 0xFBEA, 0xFC15, 0xFCA0, 0x0135, 0xF86A, 0xF9E0, 0xFBE0, 0xFC5B, 0xF978, 0xF059, 0xF119, 0xE6B8,
    0xDE00, 0xDDE0, 0xD714, 0xD719, 0xD6D5, 0xE183, 0xE7A9, 0xE06C, 0xE1D7, 0xDAD9, 0xDA00, 0xD610, 0xD82E, 0xE686, 0xEB01, 0xFFD7,
    0x12DF, 0x1D6F, 0x2744, 0x2B9A, 0x2DF6, 0x21B6, 0x2131, 0x20CA, 0x1D7E, 0x241B, 0x2256, 0x28E6, 0x2786, 0x209A, 0x2003, 0x1DD1,
    0x1DD5, 0x12E8, 0x0BBC, 0x07EF, 0x0124, 0x0341, 0xF903, 0xF252, 0xF235, 0xEC74, 0xEF55, 0xF01C, 0xF802, 0xFC54, 0x0015, 0x03FE,
    0xFDA7, 0x00C2, 0xFDBA, 0xFD19, 0x0138, 0xFD06, 0x01EE, 0x05B8, 0x04E3, 0x03AD, 0x0621, 0x0A82, 0x04DB, 0x0975, 0x10BA, 0x1944,
    0x1EFD, 0x12EF, 0x0849, 0xFBA7, 0xECB0, 0xE1FE, 0xD8B7, 0xD5CC, 0xDA47, 0xE394, 0xE99A, 0xEBBA, 0xF0B2, 0xF07C, 0xEFF2, 0xF25B,
    0xF404, 0xFD7E, 0x0CA5, 0x1449, 0x16CE, 0x1D00, 0x1D39, 0x17D5, 0x1193, 0x080D, 0x00F3, 0xF486, 0xE4F8, 0xDF4E, 0xDE68, 0xD8E8,
    0xD390, 0xD47D, 0xD447, 0xD60B, 0xDCB9, 0xE428, 0xE8D3, 0xF2B2, 0xF97F, 0xF642, 0xF89E, 0xF734, 0xFA1A, 0xFE01, 0xF768, 0xFFFC,
    0x064D, 0x0601, 0x0812, 0x06AB, 0x0ADA, 0x0447, 0x0418, 0x0A46, 0x0F44, 0x1E1E, 0x2051, 0x2123, 0x1B1C, 0x14C1, 0x1956, 0x103F,
    0x0BB3, 0x146A, 0x2897, 0x344C, 0x388F, 0x4894, 0x45A9, 0x4114, 0x3CE4, 0x3065, 0x2F89, 0x2B8D, 0x31D4, 0x2E47, 0x249E, 0x23CC,
    0x175F, 0x1793, 0x0784, 0xFD2A, 0xFD33, 0xECA0, 0xECD5, 0xE3E0, 0xE2EB, 0xE1C1, 0xD46F, 0xD2DE, 0xC706, 0xC984, 0xC541, 0xBE02,
    0xC45B, 0xBA8E, 0xC279, 0xC2C0, 0xC084, 0xC8B8, 0xC3AB, 0xCF23, 0xD068, 0xD38C, 0xDA5A, 0xD490, 0xE525, 0xDFDB, 0xDFE6, 0xE6BF,
    0xE20F, 0xF438, 0xF9FB, 0x04FD, 0x0CEA, 0x0C69, 0x0E3D, 0x07CB, 0x019A, 0xF75B, 0xF96D, 0x07B7, 0x0B88, 0x1D27, 0x3059, 0x38FA,
    0x3FC4, 0x3C87, 0x4208, 0x3FC3, 0x4646, 0x4DCB, 0x50A9, 0x5D79, 0x570E, 0x5566, 0x4E85, 0x437A, 0x3CAC, 0x28EA, 0x1C7D, 0x0DC7,
    0x03EF, 0xF712, 0xE914, 0xE155, 0xD229, 0xCBC9, 0xCD93, 0xCC29, 0xCB01, 0xD21D, 0xD7E4, 0xDB5F, 0xDC0A, 0xE004, 0xE56C, 0xE76A,
    0xE4AE, 0xE408, 0xE693, 0xDCF7, 0xDA92, 0xDB05, 0xDAEF, 0xDCDD, 0xDBEF, 0xE172, 0xE303, 0xEDCE, 0xF9A1, 0xFEE6, 0x032E, 0x0387,
    0x0A7B, 0x06E1, 0xF803, 0xF4B7, 0xFCD4, 0xFE6E, 0x0C1E, 0x1D3F, 0x2925, 0x34B4, 0x35B9, 0x3826, 0x2BD4, 0x2C32, 0x2FA5, 0x2D8E,
    0x3879, 0x3522, 0x3C70, 0x3B19, 0x3106, 0x3234, 0x29BE, 0x22A4, 0x1935, 0x1691, 0x1668, 0x0A24, 0x0876, 0xFDE2, 0xEFB9, 0xEAD4,
    0xDC45, 0xDE1E, 0xD8CC, 0xD2D5, 0xD8E8, 0xCE6D, 0xCD3A, 0xC60E, 0xC609, 0xC639, 0xBE7A, 0xC991, 0xC3FE, 0xCBA8, 0xD4CA, 0xD3E6,
    0xE003, 0xDE4E, 0xE2CB, 0xE7A6, 0xEF66, 0xF9F7, 0xF942, 0xFBA9, 0xF591, 0xF19B, 0xEF98, 0xE25B, 0xDE02, 0xDD86, 0xE27F, 0xEF22,
    0xFC60, 0x0D0D, 0x19FD, 0x284D, 0x2700, 0x224C, 0x2857, 0x2641, 0x2F73, 0x32EB, 0x39AE, 0x4751, 0x4985, 0x5055, 0x49CE, 0x4676,
    0x3BFC, 0x2E48, 0x2AB0, 0x1E0E, 0x200D, 0x1BD6, 0x12FB, 0x0F5E, 0x0627, 0x024D, 0x0118, 0x05AC, 0x05EE, 0x0499, 0x0BCC, 0x0B73,
    0x08F4, 0x046C, 0xFC3E, 0xFEF3, 0xF806, 0xEC08, 0xE9B4, 0xE9AB, 0xE5EA, 0xD725, 0xD0DF, 0xC8E7, 0xC073, 0xC41C, 0xC507, 0xCAB7,
    0xCE52, 0xD388, 0xDBC5, 0xD966, 0xD48C, 0xD906, 0xDAD5, 0xD63A, 0xDF03, 0xE947, 0xF338, 0xF7F6, 0xFFFD, 0x0417, 0xFB25, 0x014B,
    0xFFDA, 0x0428, 0x0B8D, 0x0E2E, 0x2020, 0x2391, 0x2662, 0x2EB8, 0x2ED2, 0x2860, 0x161B, 0x11BF, 0x0DD3, 0x0703, 0x0B63, 0x0426,
    0x0411, 0x02DA, 0xFBD1, 0xFEB1, 0xF46E, 0xF8CF, 0xFE1B, 0xFA53, 0xFE45, 0xFBA2, 0x08DA, 0x0060, 0x00B4, 0x0D27, 0x04CE, 0x0CB8,
    0x0A96, 0x0D77, 0x1109, 0x0DBD, 0x112E, 0x0C1F, 0x0FF3, 0x14CB, 0x18E4, 0x1F26, 0x1967, 0x19E3, 0x177B, 0x07BC, 0xFB0F, 0xECA9,
    0xE1E2, 0xDDBE, 0xE193, 0xE7F7, 0xF20D, 0x0706, 0x0C2F, 0x0F87, 0x10A4, 0x10CF, 0x1BD9, 0x1989, 0x1DDA, 0x1E03, 0x2066, 0x220D,
    0x1894, 0x186E, 0x09EE, 0x00A6, 0xF5C7, 0xE4C5, 0xE5BA, 0xE43F, 0xDFEC, 0xDDAA, 0xD951, 0xD92A, 0xD776, 0xD2FA, 0xCFE1, 0xD08F,
    0xD818, 0xD6F7, 0xDDFD, 0xE696, 0xE456, 0xEBDD, 0xEBDC, 0xEA19, 0xEA0C, 0xED3E, 0xF2AF, 0xF092, 0xF816, 0xF690, 0xF17D, 0xF8C7,
    0xF889, 0x012C, 0x0A02, 0x0F0A, 0x1F59, 0x1F6C, 0x2074, 0x2672, 0x1BB8, 0x16D6, 0x13A4, 0x1D03, 0x253A, 0x2441, 0x39EB, 0x3935,
    0x3567, 0x31B1, 0x2220, 0x2640, 0x19E4, 0x178B, 0x1C48, 0x1463, 0x19F5, 0x1B73, 0x202F, 0x1954, 0x1226, 0x1AC8, 0x0BD5, 0x049A,
    0x042B, 0xFDF2, 0xF9A4, 0xE5DD, 0xE263, 0xDCDE, 0xD37F, 0xD304, 0xCBDD, 0xD1E8, 0xCC34, 0xD378, 0xDE1D, 0xD786, 0xE904, 0xEA9A,
    0xE81C, 0xE500, 0xDF4C, 0xE8A6, 0xE6D3, 0xEE4D, 0xEE8A, 0xED27, 0xF756, 0xF493, 0xFD2A, 0x003D, 0x03C8, 0x120F, 0x1112, 0x0E9E,
    0x08E8, 0x075C, 0xFDE1, 0xEF3C, 0xF18E, 0xF211, 0x0290, 0x1291, 0x1B83, 0x2C68, 0x2B31, 0x3155, 0x3016, 0x2F05, 0x391B, 0x3791,
    0x4232, 0x3BD0, 0x3F73, 0x4688, 0x3671, 0x33DC, 0x20F3, 0x10C3, 0x06D9, 0xF479, 0xEE87, 0xE106, 0xDB13, 0xD8EF, 0xD2B2, 0xD7CE,
    0xD21A, 0xD7D0, 0xDC1B, 0xD68A, 0xE1E5, 0xDCEB, 0xDD8A, 0xE3D8, 0xE0D4, 0xE15A, 0xD764, 0xD8D1, 0xD2B1, 0xCD7F, 0xDE68, 0xDB60,
    0xDF4A, 0xE3E4, 0xE48A, 0xF159, 0xECB4, 0xF156, 0xFB21, 0xFB61, 0x0717, 0x07C9, 0x09C2, 0x0AD0, 0x022F, 0x0776, 0xFF06, 0x0749,
    0x1C3F, 0x233D, 0x339B, 0x38BE, 0x3D71, 0x403D, 0x3A28, 0x3C9D, 0x3EFF, 0x41E7, 0x42C2, 0x4B67, 0x536B, 0x4BD9, 0x4F3B, 0x4C90,
    0x3E82, 0x340E, 0x2FF1, 0x3073, 0x204D, 0x17AF, 0x10F2, 0x005E, 0xF603, 0xE3A5, 0xDFE5, 0xD512, 0xC615, 0xC9F5, 0xBB01, 0xB59E,
    0xBAB3, 0xBE38, 0xC05E, 0xB9DF, 0xC3E2, 0xC649, 0xC72D, 0xCEA3, 0xCBEB, 0xD2B0, 0xD01C, 0xCF04, 0xD3A1, 0xD045, 0xD2FF, 0xD305,
    0xD87C, 0xD983, 0xDDA9, 0xE84A, 0xE10D, 0xE539, 0xE405, 0xDDBD, 0xE39F, 0xE464, 0xF67D, 0x01D0, 0x0D15, 0x1C9E, 0x2087, 0x2E4F,
    0x2E5E, 0x360B, 0x3C05, 0x35F3, 0x46B8, 0x4A4D, 0x4C28, 0x510D, 0x4C18, 0x4A52, 0x3BF5, 0x3648, 0x30A8, 0x27FB, 0x2846, 0x19C5,
    0x189C, 0x1410, 0x0B16, 0x112B, 0x0802, 0x0962, 0x0DDC, 0x09CE, 0x094B, 0x0501, 0x0AEE, 0x088B, 0x0131, 0x018C, 0xF39D, 0xF455,
    0xF3C5, 0xE2B9, 0xDF3A, 0xD810, 0xD663, 0xD6F4, 0xD255, 0xDBE4, 0xE254, 0xE703, 0xEFE2, 0xF3CC, 0xFBD3, 0xF711, 0xF153, 0xEE5A,
    0xDECA, 0xDBA6, 0xDBF7, 0xDD4E, 0xE66D, 0xEBC7, 0xF472, 0xFBA5, 0xFEA5, 0x069F, 0x0ED9, 0x1031, 0x0EE1, 0x16D3, 0x1C25, 0x1CFE,
    0x24D3, 0x27DC, 0x2292, 0x1C7C, 0x1E65, 0x1773, 0x0ADA, 0x0C8B, 0x05E2, 0x02F8, 0xFA82, 0xF380, 0xF834, 0xEA80, 0xE939, 0xEA96,
    0xE409, 0xE5C3, 0xE6A1, 0xF1AE, 0xF1C4, 0xF098, 0xF987, 0xF4FF, 0xFAEB, 0x011B, 0x08DF, 0x1059, 0x0C98, 0x11F6, 0x120B, 0x1060,
    0x0D34, 0x100B, 0x17EC, 0x0BC1, 0x1095, 0x1023, 0xFFD5, 0xFB55, 0xE992, 0xE34A, 0xDB29, 0xD7B1, 0xE5DE, 0xE85D, 0xF737, 0xFFC9,
    0x0540, 0x1033, 0x0FA5, 0x19DF, 0x1880, 0x1536, 0x1C0E, 0x1758, 0x18FF, 0x1F43, 0x2686, 0x2502, 0x219F, 0x25CC, 0x1C3B, 0x19C3,
    0x1463, 0x078D, 0x0740, 0xFBF8, 0xF9B5, 0xF696, 0xEBD8, 0xF168, 0xEE98, 0xED3D, 0xE9A4, 0xE852, 0xF562, 0xF2E3, 0xF5A8, 0xF9B9,
    0xF09E, 0xF4F0, 0xF3F6, 0xEE53, 0xEF77, 0xEA6D, 0xEEC8, 0xEF70, 0xED40, 0xF10E, 0xF43C, 0xFF0E, 0x028B, 0x0C93, 0x17F9, 0x1938,
    0x2010, 0x1B94, 0x13F9, 0x0DCF, 0x0593, 0x0477, 0x0317, 0x0892, 0x0BE2, 0x053A, 0x0315, 0x0316, 0x07F4, 0x066A, 0x01E9, 0x0DA1,
    0x0F4D, 0x113F, 0x18AB, 0x1FD7, 0x1E61, 0x1C9A, 0x1E52, 0x10D8, 0x091B, 0x011F, 0xF940, 0xEC29, 0xE292, 0xE0E1, 0xE3FB, 0xE0A9,
    0xDD93, 0xE21F, 0xDC94, 0xDA55, 0xD75D, 0xDE0D, 0xDE6C, 0xDEF8, 0xE7F9, 0xE107, 0xE607, 0xE90A, 0xEA30, 0xF4B9, 0xEFEB, 0xF75D,
    0xFFCE, 0xFBB3, 0xFA3B, 0x03B0, 0x0BFC, 0x053F, 0x13D2, 0x1AC5, 0x1A08, 0x23AA, 0x1DA4, 0x1D1F, 0x11F8, 0x09AA, 0x0CC5, 0x0956,
    0x1794, 0x1D76, 0x2695, 0x2F47, 0x26D0, 0x3C20, 0x3C21, 0x3341, 0x4157, 0x3755, 0x3A35, 0x3799, 0x31BF, 0x30BA, 0x2148, 0x1D10,
    0x0CA0, 0x048D, 0xFBF6, 0xEA54, 0xEA17, 0xDBB0, 0xD793, 0xD9BD, 0xD276, 0xD3A4, 0xD3BC, 0xD437, 0xC969, 0xC517, 0xC56E, 0xBB7C,
    0xC343, 0xC289, 0xBE6A, 0xC6DD, 0xC444, 0xCCE9, 0xCEDB, 0xCE02, 0xD376, 0xD202, 0xD6F3, 0xD1B5, 0xD95C, 0xDF7F, 0xDE93, 0xF1C9,
    0xF447, 0xFE51, 0x0C80, 0x0F40, 0x14E4, 0x0FD3, 0x1165, 0x0CC5, 0x0E17, 0x1739, 0x1979, 0x2668, 0x2905, 0x2B6C, 0x362B, 0x340B,
    0x36D5, 0x3C01, 0x3C3E, 0x4010, 0x4B43, 0x52C9, 0x4E12, 0x56DF, 0x5537, 0x4D1D, 0x4D73, 0x42AC, 0x418F, 0x3467, 0x2827, 0x200C,
    0x0F07, 0x0608, 0xF07F, 0xEEBB, 0xE662, 0xD576, 0xD93D, 0xD134, 0xD02B, 0xD193, 0xD49E, 0xDA44, 0xD8E1, 0xDFFD, 0xE157, 0xE341,
    0xDE42, 0xD589, 0xDC73, 0xCC15, 0xC8C7, 0xD1F2, 0xCACE, 0xD280, 0xD2C1, 0xDD7D, 0xE3B0, 0xE2C6, 0xF46E, 0xEB5C, 0xEC65, 0xE9D0,
    0xDB14, 0xE039, 0xD7E1, 0xE059, 0xEFE5, 0xF136, 0xF9B6, 0x06F9, 0x0F1A, 0x1247, 0x1AB7, 0x1C51, 0x1EAB, 0x278B, 0x2CE0, 0x339D,
    0x32C6, 0x3710, 0x36DE, 0x2E54, 0x2E1C, 0x2571, 0x277C, 0x20B9, 0x131B, 0x1BDB, 0x106C, 0x0D5E, 0x11F0, 0x0BF2, 0x0F84, 0x0A32,
    0x0D39, 0x0637, 0x04E8, 0x086B, 0xFB8C, 0xFC69, 0xF0AC, 0xF13B, 0xF0F0, 0xE1D8, 0xE22B, 0xD979, 0xD76F, 0xD191, 0xD24D, 0xD88C,
    0xD364, 0xE486, 0xE6DF, 0xE630, 0xF378, 0xF432, 0xFB86, 0xF455, 0xEF0B, 0xEE73, 0xE594, 0xEBDC, 0xE831, 0xF495, 0xFC90, 0xFD58,
    0x137F, 0x0E40, 0x1999, 0x2218, 0x1A12, 0x1DFA, 0x1B2F, 0x2904, 0x29BA, 0x2E8D, 0x3658, 0x309D, 0x3886, 0x317B, 0x2BE6, 0x2914,
    0x2034, 0x1B5C, 0x0EBF, 0x0746, 0xFDA0, 0xF9A3, 0xF451, 0xE68E, 0xEB72, 0xE40E, 0xDF6E, 0xE464, 0xDFCB, 0xE568, 0xE2C8, 0xE6BA,
    0xED33, 0xEDD0, 0xF62E, 0xF6D3, 0xFF26, 0xF4EB, 0xEEDF, 0xF549, 0xE541, 0xE421, 0xDFA6, 0xE430, 0xE146, 0xDCB4, 0xEA7D, 0xDEC2,
    0xE435, 0xE0A9, 0xD5F6, 0xE128, 0xD72A, 0xE271, 0xEEBE, 0xEAD8, 0xFC1E, 0xFD2F, 0x013E, 0x04C6, 0x045B, 0x115A, 0x0826, 0x0E64,
    0x178A, 0x17DD, 0x23DB, 0x20A2, 0x2729, 0x29B8, 0x2770, 0x259F, 0x1E27, 0x1AC3, 0x10DA, 0x1287, 0x051B, 0xF9F3, 0xFFB4, 0xF693,
    0xF4E1, 0xF03F, 0xECFF, 0xF0F7, 0xF08A, 0xF642, 0xF578, 0xF3B0, 0xF70F, 0xF60E, 0xF965, 0xF6F8, 0xF8C9, 0x026B, 0xFAE2, 0xF619,
    0xF5C0, 0xF355, 0xEFF6, 0xF137, 0xF758, 0xF87F, 0x0757, 0x0F35, 0x144D, 0x1AC0, 0x1585, 0x1301, 0x0498, 0xFB2F, 0xF6AC, 0xF13D,
    0xEFB2, 0xEAFC, 0xF176, 0xEE7F, 0xECA1, 0xF425, 0xF2C7, 0xF94F, 0x0237, 0x07A1, 0x0E45, 0x12EF, 0x19FC, 0x16C2, 0x12E0, 0x12CE,
    0x0ACE, 0x0E51, 0x0363, 0xFBA2, 0xFA7F, 0xE881, 0xE43F, 0xDB7A, 0xD7C1, 0xD47A, 0xD02E, 0xD1D2, 0xC5EB, 0xCA1B, 0xCDBD, 0xCB9D,
    0xD06C, 0xCE9E, 0xD843, 0xDBCE, 0xDC26, 0xE6EC, 0xE92C, 0xEFAE, 0xF4C3, 0xF5E9, 0xF9C6, 0xF538, 0xFEFA, 0xFE98, 0xF6D6, 0x06C6,
    0x0C8B, 0x142A, 0x1B00, 0x1C3B, 0x1E5A, 0x17EA, 0x0F42, 0x0BE1, 0x1083, 0x1295, 0x1A72, 0x20A6, 0x27C5, 0x2E4E, 0x2F78, 0x37B5,
    0x2E28, 0x2E0F, 0x34BF, 0x2D06, 0x320C, 0x2ADE, 0x288A, 0x2A96, 0x1C68, 0x1E6F, 0x1D87, 0x1887, 0x1C08, 0x1793, 0x1443, 0x0866,
    0x0110, 0xFA6F, 0xEBA9, 0xE9F6, 0xDFEF, 0xDBCF, 0xD5E3, 0xD177, 0xD1C7, 0xC89E, 0xCD59, 0xC751, 0xCB13, 0xCF3A, 0xCAF4, 0xD693,
    0xCC8D, 0xCEC3, 0xD421, 0xC8F2, 0xCE08, 0xCDA5, 0xD2BD, 0xD2AB, 0xD240, 0xDFAD, 0xE3F6, 0xF026, 0xF82E, 0xFB52, 0x00A5, 0xF8C7,
    0xF71F, 0xF591, 0xF65F, 0xFA83, 0xFC7D, 0x0929, 0x09C1, 0x14CE, 0x16A4, 0x12FF, 0x1F61, 0x1E16, 0x2C34, 0x314E, 0x3763, 0x431C,
    0x40D2, 0x468D, 0x3F4E, 0x4020, 0x401C, 0x3791, 0x36AB, 0x226B, 0x1884, 0x0D9F, 0xFB97, 0xF071, 0xE3FF, 0xE492, 0xDAAD, 0xDACB,
    0xE02D, 0xD825, 0xDECC, 0xDBF4, 0xDB0C, 0xD958, 0xD294, 0xE00F, 0xD9D1, 0xDBB0, 0xDEEF, 0xDB80, 0xE1C4, 0xD627, 0xE29B, 0xDDE7,
    0xD8CF, 0xE7B4, 0xE0E2, 0xEE79, 0xF24E, 0xF8F5, 0x0363, 0xF9C9, 0xFF8D, 0xF5AD, 0xF04D, 0xF485, 0xEE32, 0xFB16, 0xFA75, 0xFF6F,
    0x1089, 0x1326, 0x1711, 0x1841, 0x2083, 0x2502, 0x2827, 0x2F32, 0x3121, 0x3748, 0x33C7, 0x34BE, 0x315A, 0x2704, 0x2F1D, 0x2A6D,
    0x29CF, 0x20FA, 0x1AD2, 0x1C7A, 0x0AC5, 0x0B1A, 0x0276, 0xFA1D, 0xFA15, 0xF137, 0xEF27, 0xE6D0, 0xDDCD, 0xD7D2, 0xCF17, 0xCA9A,
    0xC622, 0xCB9A, 0xCCB1, 0xCDE9, 0xD66A, 0xD30B, 0xD64A, 0xD5A6, 0xD5BC, 0xD700, 0xD122, 0xD978, 0xDAF7, 0xE2C3, 0xEEC5, 0xEC23,
    0xF69A, 0xF21D, 0xF028, 0xF085, 0xE80E, 0xEE18, 0xF0A7, 0xF407, 0xF57C, 0xFF5C, 0x0B09, 0x0D5E, 0x10BD, 0x1457, 0x1B0D, 0x2006,
    0x2421, 0x2D85, 0x3358, 0x3918, 0x3BBB, 0x3B92, 0x3D98, 0x3A75, 0x3EB3, 0x3ACC, 0x30DC, 0x3138, 0x2943, 0x222C, 0x1979, 0x0AC3,
    0x0394, 0xFD7C, 0xFB52, 0xF66D, 0xF913, 0xFC67, 0xF740, 0xF66B, 0xF2AE, 0xF3CC, 0xF60F, 0xFA23, 0xFA71, 0xF9BF, 0xF97B, 0xF3B2,
    0xED95, 0xDF91, 0xD7A4, 0xD466, 0xCCE6, 0xCBB8, 0xD0C7, 0xDAD7, 0xE4F8, 0xE85D, 0xED12, 0xE814, 0xE628, 0xE5B9, 0xDB58, 0xE03D,
    0xDCD1, 0xDD25, 0xE92C, 0xE812, 0xEF6E, 0xF2C6, 0xF3AD, 0xFA41, 0xFAB2, 0x04DE, 0x0673, 0x0A9A, 0x14A4, 0x1639, 0x1906, 0x1877,
    0x1C18, 0x1C71, 0x18E8, 0x1892, 0x16A9, 0x1150, 0x0DAB, 0x0E22, 0x0BBC, 0x0333, 0x04F7, 0x0094, 0xFEC4, 0x0496, 0x023E, 0x06CF,
    0x047D, 0x04F5, 0x035C, 0xFD55, 0xFFCC, 0xFBFA, 0x0156, 0x0656, 0x043A, 0x0AE6, 0x0637, 0x04F6, 0x0421, 0x00C9, 0x003F, 0x0425,
    0x1091, 0x15C5, 0x1D9A, 0x1BA5, 0x1295, 0x0E6A, 0xFE7C, 0xF690, 0xF1FF, 0xE91E, 0xF2F2, 0xF467, 0xFD44, 0x03E9, 0x0833, 0x1638,
    0x0E18, 0x166D, 0x1BEA, 0x1B1B, 0x22A2, 0x20CE, 0x280A, 0x2483, 0x1F38, 0x206B, 0x1E01, 0x1DBD, 0x1091, 0x102E, 0x0827, 0xF9FD,
    0xFAF3, 0xEDEB, 0xE9BD, 0xE1EF, 0xDA9E, 0xD9E6, 0xD237, 0xD747, 0xD32D, 0xD211, 0xD764, 0xD07D, 0xD9D4, 0xD569, 0xD6DC, 0xE251,
    0xDAF8, 0xE745, 0xE846, 0xECB9, 0xEF9D, 0xE82F, 0xEDA7, 0xE144, 0xE38E, 0xEBCF, 0xEF3A, 0x0118, 0x06C2, 0x0CD3, 0x0D0D, 0x085E,
    0x0CBB, 0x0960, 0x08B9, 0x0B10, 0x162A, 0x1DDA, 0x1DBE, 0x23CD, 0x219C, 0x1E1F, 0x1DB0, 0x1C2E, 0x1ADE, 0x1C51, 0x26B8, 0x285F,
    0x2BFF, 0x2D68, 0x2A76, 0x3633, 0x3057, 0x2EAA, 0x2A4E, 0x1FED, 0x2119, 0x1334, 0x0D5F, 0x05CE, 0xFC11, 0xF8A7, 0xEC8A, 0xED26,
    0xE930, 0xE5C9, 0xE8C5, 0xE0E0, 0xE23A, 0xE2B3, 0xE31C, 0xDFE1, 0xE0EA, 0xE7E7, 0xE335, 0xE873, 0xE936, 0xE6A6, 0xECEE, 0xE695,
    0xE439, 0xE169, 0xE329, 0xF013, 0xF6D7, 0x0336, 0x06C2, 0x0DCB, 0x113B, 0x08EC, 0x056E, 0xFC29, 0xFA87, 0xFC78, 0xFFA5, 0x05A5,
    0x0CCD, 0x1716, 0x16B0, 0x1A30, 0x1B25, 0x1C21, 0x2BE2, 0x308B, 0x3957, 0x3D0A, 0x3BCC, 0x3E49, 0x32D1, 0x2F53, 0x26CB, 0x1C54,
    0x15E4, 0x05E2, 0x02B8, 0xFA49, 0xEF29, 0xEE98, 0xE592, 0xE13E, 0xDFD4, 0xE115, 0xDC0F, 0xDBF4, 0xDC18, 0xD3D0, 0xD925, 0xD3AB,
    0xD4DA, 0xD8F7, 0xD694, 0xDE5E, 0xDA74, 0xE04D, 0xE6A8, 0xE38F, 0xE998, 0xDF58, 0xE35D, 0xE619, 0xE1BD, 0xF25C, 0xF627, 0x03DA,
    0x0916, 0x07AD, 0x1039, 0x0728, 0x05CE, 0x0072, 0xFF5C, 0x066A, 0x0486, 0x17DB, 0x1AED, 0x1BFA, 0x298F, 0x281E, 0x293B, 0x2788,
    0x31D5, 0x37DD, 0x38AD, 0x3FBB, 0x3FC3, 0x43B1, 0x4053, 0x3F04, 0x413E, 0x377B, 0x3945, 0x3A98, 0x36D6, 0x2F57, 0x258C, 0x2013,
    0x0B12, 0x01DD, 0xF960, 0xEBAD, 0xEBB3, 0xE21D, 0xDF45, 0xDAB1, 0xD3C8, 0xD71D, 0xD2A0, 0xD612, 0xD551, 0xD621, 0xD936, 0xD24D,
    0xD80C, 0xD1E2, 0xCA93, 0xCB25, 0xC77B, 0xCA49, 0xC9FF, 0xD29F, 0xD920, 0xDEC0, 0xE69A, 0xE242, 0xE87A, 0xE668, 0xDE6E, 0xE22B,
    0xDC45, 0xE0B0, 0xE9F4, 0xEF94, 0xF9A8, 0xFD4B, 0x055A, 0x0860, 0x096B, 0x134F, 0x1DA8, 0x29D1, 0x2FA8, 0x3762, 0x41D6, 0x4357,
    0x42BC, 0x41C1, 0x410F, 0x39B8, 0x37C0, 0x359B, 0x2921, 0x2A31, 0x2360, 0x15FA, 0x1027, 0x04BC, 0x05F3, 0x0796, 0x04EC, 0x08AC,
    0x0771, 0x0B39, 0x06E6, 0x0037, 0xFF39, 0xF618, 0xF75D, 0xF453, 0xEC90, 0xEFA9, 0xEE16, 0xEA5B, 0xE59C, 0xDF0B, 0xE008, 0xE718,
    0xEACB, 0xF11D, 0xFA8D, 0x0198, 0x00F9, 0xFC3F, 0xF7C0, 0xF1D6, 0xEE38, 0xEDFC, 0xE5F5, 0xE467, 0xED9C, 0xF412, 0xF61D, 0xF1F4,
    0xF52C, 0xFEAD, 0x02BD, 0x0146, 0x0847, 0x11A7, 0x1C9B, 0x1DCE, 0x200D, 0x21CE, 0x2358, 0x2018, 0x184D, 0x1B8A, 0x15FA, 0x1206,
    0x134C, 0x0F0A, 0x07C1, 0xFF1E, 0xF85C, 0xF47E, 0xF02F, 0xEC2D, 0xE6BB, 0xE71F, 0xE2F9, 0xE8C6, 0xE5F7, 0xE1A0, 0xE0AA, 0xE18D,
    0xEA81, 0xE94F, 0xF129, 0xF8EC, 0xFF7C, 0x0546, 0xFD9D, 0xF2A5, 0xF53A, 0xF9ED, 0xFCA6, 0xFADB, 0x047D, 0x0A3D, 0x07AB, 0x05F9,
    0x01D4, 0x0460, 0xFDFA, 0xF818, 0xFE58, 0x0119, 0x069B, 0x08FC, 0x083E, 0x0AB5, 0x0F74, 0x1460, 0x0E7A, 0x14F6, 0x1A89, 0x20D3,
    0x242A, 0x1E81, 0x2C32, 0x330E, 0x2BAD, 0x2339, 0x1D06, 0x21A2, 0x133E, 0x1282, 0x0F8E, 0x098A, 0x0343, 0xF392, 0xF5BF, 0xEC15,
    0xE66A, 0xE91A, 0xE2FE, 0xE3EE, 0xED6D, 0xE3E7, 0xEA3E, 0xDE96, 0xE52C, 0xEB3B, 0xDD31, 0xEE7E, 0xEFD3, 0xEF62, 0xF009, 0xFACF,
    0xF2B9, 0xD34E, 0xE2D8, 0xF144, 0x042D, 0xEDCB, 0xF178, 0x32C0, 0x0497, 0x122D, 0x185C, 0x0DAC, 0x15A1, 0xEF0B, 0x02CA, 0x0165,
    0xF36E, 0xF591, 0xF7A0, 0x0D65, 0x043A, 0xF19D, 0x077F, 0x158B, 0x0FD3, 0x183D, 0x1A81, 0x21F9, 0x2738, 0x1C77, 0x29EF, 0x21E5,
    0x1530, 0x067E, 0x1F9E, 0x12F2, 0x0265, 0x0617, 0xFE88, 0xF25C, 0xEC0E, 0xFE3E, 0xDE9A, 0xE3BC, 0xE6FE, 0xEAD3, 0xE4EE, 0xEB4C,
    0xE569, 0xE9C9, 0xEADD, 0xE6BD, 0xEF01, 0xEA45, 0xF84D, 0xE844, 0xFEE8, 0xF3BA, 0xF703, 0xEB3A, 0xE53A, 0x0876, 0xF98B, 0xFFA6,
    0x07D0, 0x1EFE, 0x170A, 0x10D3, 0x0F3E, 0x10EE, 0x069B, 0xFC82, 0x1035, 0x116D, 0x1527, 0x193B, 0x378D, 0x1D3D, 0x21D8, 0x3545,
    0x2D18, 0x3B8D, 0x2DA0, 0x368A, 0x3201, 0x2A3A, 0x369C, 0x1FA6, 0x1874, 0x2433, 0x1A44, 0x04C2, 0x198B, 0x18CC, 0xF504, 0xFA6B,
    0xE7CD, 0xF031, 0xDAC8, 0xD61F, 0xDA45, 0xCD5E, 0xC558, 0xCE55, 0xD6F6, 0xCA85, 0xCD28, 0xC23B, 0xEB69, 0xB8A0, 0xCD18, 0xDE5A,
    0xD284, 0xE567, 0xCCD3, 0xDC01, 0xD7D1, 0xD658, 0xD384, 0xE5CF, 0xD91C, 0xE953, 0xFC3F, 0x08C1, 0xF765, 0x00E8, 0x0A98, 0xF645,
    0x00B7, 0x08E2, 0x0884, 0x0087, 0x1E10, 0x1794, 0x16CA, 0x266E, 0x1E2A, 0x23D6, 0x30E6, 0x2D2C, 0x396C, 0x43A5, 0x43BA, 0x3F18,
    0x5475, 0x52EF, 0x4772, 0x4564, 0x4CA4, 0x402F, 0x367B, 0x37F9, 0x22A7, 0x21A1, 0xFF15, 0x0DCE, 0x01E6, 0xF18E, 0xEE34, 0xF652,
    0x0245, 0xD828, 0xF3C1, 0xF07E, 0xE2F0, 0xDF47, 0xF476, 0xE44E, 0xD1A6, 0xFABC, 0xDC34, 0xE1EB, 0xE4D1, 0xDECB, 0xCFFD, 0xEAEC,
    0xD802, 0xCAA6, 0xEEF0, 0xDE61, 0xEB88, 0xF02B, 0xEC07, 0xEFED, 0xE607, 0xE3E8, 0xF693, 0xDEAE, 0xE3AB, 0xEFB8, 0xF20B, 0xFC0B,
    0x02AC, 0xF6D0, 0xFF34, 0x079C, 0x0F8D, 0x0BB3, 0x203C, 0x1709, 0x20BB, 0x3013, 0x25EA, 0x2C9A, 0x1169, 0x28C8, 0x122D, 0x1992,
    0x11DC, 0x1584, 0x0D3E, 0x083B, 0xFD99, 0x127D, 0x0503, 0xFCC7, 0x121A, 0xECD0, 0xF452, 0xEA61, 0x05B2, 0xE9EB, 0xDFBD, 0xE979,
    0xF7D8, 0xF0FF, 0xEFDD, 0xECCB, 0xED10, 0xF8D1, 0xF129, 0xFED4, 0xEF87, 0xDE01, 0xF640, 0x03A0, 0xED23, 0xF755, 0x06FE, 0x02E7,
    0x07AE, 0xFEF5, 0xEC44, 0x0089, 0xF5ED, 0xF543, 0xF021, 0x058A, 0x0068, 0xFD68, 0x05F9, 0x05CA, 0x0A73, 0x00C6, 0x19F6, 0x127D,
    0x11A1, 0x20F7, 0x2B68, 0x2BB5, 0x2CC9, 0x27C0, 0x2DEA, 0x2A92, 0x1001, 0x1247, 0x2D78, 0x17CA, 0x0FF9, 0x0D5F, 0xFEC6, 0x0137,
    0x0EEA, 0xEF68, 0xEABE, 0xF7A0, 0xEDB0, 0xE642, 0xE8D1, 0xFF49, 0xE619, 0xF84B, 0xF47C, 0xFB29, 0x1593, 0xFA84, 0xE694, 0x0116,
    0xE28B, 0xEBF6, 0xE11A, 0xD598, 0xE829, 0xDE9E, 0xE859, 0xF0CA, 0xF752, 0xE3E2, 0x0319, 0xE953, 0xF4BA, 0xEFF5, 0xECA7, 0xFA5F,
    0xF265, 0xF276, 0xFC4A, 0x0099, 0x0420, 0x06B3, 0xF83F, 0x13A1, 0x0E36, 0x23DB, 0x1349, 0x18ED, 0x38E1, 0x19A2, 0x2BD2, 0x3137,
    0x214E, 0x2B47, 0x12F3, 0x268A, 0x0E20, 0x0083, 0x1574, 0x0A8D, 0x0BA3, 0xF3DA, 0xED81, 0xFCE6, 0xF5CF, 0xE78B, 0xE885, 0xEF7C,
    0xF88B, 0xDFF8, 0x0386, 0xF588, 0xDD29, 0xFF50, 0xFDF9, 0x00CB, 0xFAB1, 0xF930, 0xF9B8, 0x04CA, 0xFD53, 0xF34B, 0x1B46, 0x1140,
    0x10DD, 0x2569, 0x1B32, 0x18AE, 0x12A7, 0x0100, 0x0202, 0xFD87, 0xE9DB, 0x0177, 0xE702, 0xEE56, 0x01BF, 0xEF17, 0x0107, 0x0126,
    0x07C6, 0x07C5, 0x0804, 0x1221, 0x0FC5, 0x1A9D, 0x1854, 0x1968, 0x12CA, 0x2613, 0x08EA, 0x1074, 0x117A, 0xF69B, 0x0D23, 0xE7D1,
    0x0932, 0xE739, 0xE390, 0xE60F, 0xDDBD, 0xE9EB, 0xD5CC, 0xCF4E, 0xD987, 0xDC40, 0xC485, 0xE50F, 0xC79D, 0xE25E, 0xD8D4, 0xE343,
    0xEC38, 0xE796, 0xEFD3, 0xEEEA, 0xFC6A, 0xE48D, 0xFBAF, 0xFD41, 0x0735, 0xFFD8, 0x15D6, 0x1776, 0x1B2D, 0x1C51, 0x1ED5, 0x15A9,
    0x2141, 0x298A, 0x1D8B, 0x292A, 0x2E25, 0x2E0D, 0x275E, 0x22A9, 0x2ED9, 0x2552, 0x194C, 0x32D9, 0x11A3, 0x3512, 0x210B, 0x2B3A,
    0x249E, 0x2753, 0x3F97, 0x2357, 0x3069, 0x218B, 0x2725, 0x1BF9, 0x0F7C, 0x0A61, 0x0649, 0xFFFA, 0xF53F, 0xE9E3, 0xEC38, 0xE4AF,
    0xE73F, 0xD46F, 0xDD0E, 0xDB28, 0xD0E9, 0xDB83, 0xD4DE, 0xD6A9, 0xCB2E, 0xDC08, 0xD498, 0xCCF5, 0xDDF9, 0xD6B4, 0xC7B4, 0xD860,
    0xDD53, 0xCC2E, 0xE78A, 0xE013, 0xE702, 0xED41, 0xF6AA, 0xF2D0, 0xEAE6, 0x062E, 0xE361, 0xF20C, 0xF460, 0xEE8E, 0xEF64, 0xE7A3,
    0xEF05, 0xF391, 0xED71, 0xF075, 0xF97B, 0x1225, 0x1872, 0x0F2A, 0x23FE, 0x2E75, 0x24CC, 0x261D, 0x35E3, 0x1DDB, 0x2143, 0x1ADB,
    0x0FEA, 0x1512, 0x133D, 0xFF6C, 0x03C4, 0xFE8E, 0x0318, 0xFCAA, 0xF7E1, 0xFA5D, 0xF146, 0xF1EE, 0xF00A, 0xF3DF, 0xDFE9, 0xED41,
    0xF62D, 0xE317, 0xE7DC, 0xF2B0, 0xED32, 0xF6C8, 0xE519, 0xF0C1, 0xE428, 0xED8E, 0xEC79, 0xEC6A, 0xECB8, 0xF27B, 0xFA12, 0xF823,
    0x05B2, 0xF7E9, 0xFE36, 0xEE96, 0xF18D, 0xFCF7, 0xF3C5, 0xE6A4, 0x0800, 0xEC1C, 0x0487, 0xFCB5, 0x04A8, 0x135F, 0x0660, 0x1E06,
    0x1360, 0x21D3, 0x21BC, 0x288A, 0x1B98, 0x2D69, 0x28F4, 0x20A4, 0x25CF, 0x33A4, 0x1D51, 0x1D81, 0x21EA, 0x0FB0, 0x0E02, 0x0B00,
    0xFEC8, 0xE9AB, 0xF360, 0xEFE3, 0xDB95, 0xD140, 0xDB32, 0xD40D, 0xD5C7, 0xD008, 0xDA4D, 0xD226, 0xE067, 0xE8C7, 0xDD8C, 0xD982,
    0xDD56, 0xEAA1, 0xE1D7, 0xE188, 0xE765, 0xE454, 0xE10B, 0xFDDB, 0xEAA1, 0xF2F5, 0x06B6, 0x022D, 0xF919, 0xFFC0, 0x0A44, 0x067E,
    0xF02C, 0x0963, 0x04FE, 0xF6E7, 0x08A5, 0xFC7A, 0x0B23, 0x03B8, 0x0BE2, 0x09A7, 0x0C90, 0x16BC, 0x2F72, 0x1334, 0x23A4, 0x389E,
    0x2029, 0x2C3D, 0x2CBF, 0x2A44, 0x2230, 0x1F17, 0x20E9, 0x0878, 0x0668, 0x0422, 0xEB4E, 0xF945, 0xF52C, 0xF0AB, 0xF238, 0xFA5F,
    0xF3C6, 0xF130, 0xEA74, 0xF644, 0xEF91, 0xF2CE, 0xEC1F, 0xEC1B, 0xEEF3, 0xD914, 0xE903, 0xD6A8, 0xD8A7, 0xE6F8, 0xDCC3, 0xE7DA,
    0xF232, 0xEDF3, 0xF99C, 0xFA8A, 0xFB33, 0xFC7C, 0xF8CB, 0xF9D3, 0xF99D, 0xE5E9, 0xF274, 0xEF1E, 0xEF0E, 0xF174, 0xEF10, 0xF49A,
    0xF634, 0xFCC5, 0xF42D, 0xFE47, 0x04AC, 0x03A0, 0x0273, 0x0786, 0x0872, 0x170F, 0x0A89, 0x0B08, 0x0386, 0x07BF, 0xFDF7, 0xFA9E,
    0xF889, 0xF337, 0xF6BC, 0xF23A, 0xF993, 0xEE30, 0xF2EB, 0xED3C, 0xFA7C, 0xE903, 0xF4C9, 0xEDFA, 0xEB10, 0xF227, 0xF583, 0xFE88,
    0xF666, 0x13F7, 0x0F5A, 0x1335, 0x1219, 0x09BA, 0x18AF, 0x0A89, 0x0F32, 0x1B05, 0x1603, 0x1421, 0x19B5, 0x1A12, 0x02AB, 0x1956,
    0x0C44, 0x04D5, 0x0E76, 0x0D8D, 0x0CA0, 0x01FC, 0x08E7, 0x0CAA, 0x1224, 0x0394, 0x1A22, 0x1BA8, 0x12BC, 0x1DFE, 0x1699, 0x0E85,
    0x120A, 0x1935, 0x1747, 0x1B43, 0x1AD6, 0x1FBC, 0x109C, 0x158A, 0x17FC, 0x02E5, 0x0728, 0xFEBA, 0xF179, 0xF0CD, 0xF376, 0xE38E,
    0xDEF1, 0xDE56, 0xDAF9, 0xDDC0, 0xD41D, 0xCBD5, 0xD94A, 0xD8E7, 0xD587, 0xDE38, 0xD3DC, 0xE6E5, 0xE4BE, 0xE084, 0xDA3B, 0xD5C4,
    0xE09D, 0xD491, 0xDB41, 0xE48B, 0xE9CF, 0xEDCB, 0xF502, 0x0139, 0xF8AC, 0xF90D, 0x09F7, 0x04B0, 0xFBCA, 0x0436, 0x09BC, 0xFD0C,
    0xFF94, 0x028F, 0x047F, 0x04BF, 0x0FB5, 0x153B, 0x16ED, 0x20F4, 0x215F, 0x29E2, 0x26CC, 0x312C, 0x3505, 0x30EC, 0x3468, 0x3022,
    0x2A7E, 0x23FC, 0x181C, 0x0C9F, 0x0B04, 0x05E6, 0x03E9, 0xFB90, 0xF07C, 0xF737, 0xEE09, 0xE1C5, 0xEB76, 0xDEFB, 0xDFCE, 0xDB69,
    0xE1A2, 0xE5BA, 0xD95E, 0xEC98, 0xE603, 0xEF5C, 0xE77C, 0xE43E, 0xE911, 0xEDB7, 0xE4DF, 0xEBB6, 0xF56B, 0xF89A, 0x0EDA, 0x0002,
    0x056A, 0x0713, 0x04CB, 0xFF0F, 0x0111, 0xFDB0, 0xFBCE, 0x0512, 0x074B, 0x0803, 0x0B35, 0x1124, 0x1BF2, 0x16AB, 0x24E2, 0x25A9,
    0x1D89, 0x2FC7, 0x2BFE, 0x2616, 0x257E, 0x20B0, 0x249D, 0x256B, 0x1A2F, 0x2600, 0x161B, 0x1356, 0x0D5F, 0x04A1, 0x015C, 0x039D,
    0xFD87, 0xF3A2, 0xF81A, 0xF499, 0xF01F, 0xE3DC, 0xEC80, 0xDD66, 0xE28D, 0xD6FA, 0xD22B, 0xE6E0, 0xDD52, 0xE5E7, 0xE6B4, 0xEC5D,
    0xEF25, 0xEA1D, 0xEE3D, 0xECE0, 0xEE77, 0xF0F8, 0xF505, 0x02B1, 0x0096, 0x05FC, 0x0890, 0xFAD0, 0xFDB3, 0xFF81, 0x01D2, 0xF9CB,
    0x021A, 0x0D5B, 0x0BC3, 0x0321, 0x0922, 0x0D48, 0x0BB4, 0x176B, 0x10F5, 0x1DBF, 0x17EE, 0x219B, 0x2A83, 0x1D41, 0x2AE0, 0x2CA2,
    0x321C, 0x3088, 0x3006, 0x2E64, 0x2631, 0x1F6E, 0x171A, 0x0C33, 0x041A, 0xFC1D, 0xEEB4, 0xF4EF, 0xED96, 0xE2A3, 0xE616, 0xE1BC,
    0xDA1D, 0xDD91, 0xD5F7, 0xD6DD, 0xE071, 0xE4F8, 0xE980, 0xE6E3, 0xE6DB, 0xE296, 0xE650, 0xE22C, 0xDD3B, 0xDCBA, 0xDFCE, 0xDDCF,
    0xE597, 0xEDE6, 0xEB95, 0xE969, 0xEB8B, 0xEFB2, 0xE857, 0xE51B, 0xE123, 0xE881, 0xE606, 0xE202, 0xEB18, 0xE3E4, 0xE3A7, 0xF226,
    0xE942, 0xE7E4, 0xF787, 0x035A, 0x0939, 0x0C25, 0x1A9A, 0x202B, 0x2366, 0x230B, 0x2783, 0x2686, 0x2853, 0x292E, 0x24AE, 0x203F,
    0x1720, 0x20A3, 0x1ECA, 0x1C15, 0x1BC9, 0x202E, 0x20D0, 0x1E17, 0x16BF, 0x0F24, 0x0B95, 0x02F8, 0x01E1, 0xF9F8, 0xFB7E, 0x0220,
    0xFFFC, 0xF85B, 0xFECA, 0xFBCE, 0xF858, 0xF649, 0xED1D, 0xFDF3, 0x01D7, 0x01A7, 0x0525, 0x08BF, 0x0B8B, 0x0E69, 0x0B9E, 0x0291,
    0x0E4B, 0x02EF, 0xFFA6, 0xFCAD, 0xF2A6, 0xF8DA, 0xF6E2, 0xF948, 0xFE6C, 0xFE02, 0x0092, 0x088E, 0x0106, 0x0F05, 0x1518, 0x10DD,
    0x162A, 0x185A, 0x17EB, 0x1258, 0x158E, 0x14BE, 0x11EB, 0x0AA6, 0x0F20, 0x0967, 0x0243, 0x006E, 0xF072, 0xEDB0, 0xE6B3, 0xE080,
    0xE3C1, 0xDF90, 0xD9E0, 0xD9B5, 0xD1E5, 0xCEC9, 0xD497, 0xD484, 0xDD99, 0xE3C7, 0xE781, 0xE7F1, 0xEF5A, 0xF220, 0xE5ED, 0xE6DA,
    0xEEEB, 0xEB20, 0xE88A, 0xF692, 0xFE24, 0xFC05, 0x0584, 0x041E, 0x0245, 0x0578, 0x042C, 0x0EA2, 0x0B8A, 0x099E, 0x0F94, 0x0D65,
    0x0F4A, 0x1097, 0x0731, 0x0C97, 0x0F7E, 0x1625, 0x13D1, 0x1597, 0x1DD6, 0x1665, 0x2395, 0x2814, 0x1C98, 0x28BC, 0x27F2, 0x22AF,
    0x27F1, 0x1B41, 0x1D54, 0x0FD1, 0x0ECF, 0x0B6A, 0xFEF4, 0xF871, 0xF10E, 0xF8AE, 0xF2C4, 0xEEEA, 0xEC16, 0xEA57, 0xE99C, 0xE854,
    0xE4BC, 0xE025, 0xE684, 0xE5D5, 0xE91E, 0xE7AE, 0xE0D6, 0xE6F7, 0xE6BB, 0xDE25, 0xE247, 0xEAA3, 0xF629, 0x0209, 0x09D9, 0x1A3C,
    0x10D2, 0x11EF, 0x1714, 0x0F5B, 0x0D98, 0x0E6A, 0x05F0, 0x08D9, 0x00EA, 0xFC9F, 0x0268, 0xF456, 0x006C, 0xFB7C, 0xFE26, 0x0697,
    0x0C21, 0x10B3, 0x12F2, 0x19F1, 0x1A07, 0x16AE, 0x2068, 0x245F, 0x1D3D, 0x2256, 0x183E, 0x14A4, 0x1391, 0x0181, 0x01B5, 0xFBC1,
    0xF3D6, 0xF8CD, 0xF0DB, 0xFC41, 0xEE92, 0xF3BC, 0xF93E, 0xED06, 0xE994, 0xEE25, 0xE765, 0xEA85, 0xEBC0, 0xE559, 0xF60E, 0xEA63,
    0xF2F0, 0xEDFF, 0xF0B1, 0xE878, 0xF394, 0xF172, 0xED36, 0xFAC3, 0xF820, 0x0623, 0xFF4F, 0xFE33, 0x01A8, 0x0647, 0x0702, 0x0808,
    0x0800, 0x1094, 0x10F6, 0x10F6, 0x0BEB, 0x0CC7, 0x0ED0, 0x0F96, 0x0E0A, 0x0E22, 0x12AD, 0x14B6, 0x17D0, 0x16C1, 0x112C, 0x17AF,
    0x1C4F, 0x16B1, 0x1C7C, 0x1453, 0x161E, 0x17CB, 0x169B, 0x0A36, 0x070A, 0x002E, 0xFA0E, 0xF404, 0xF542, 0xF208, 0xEBA1, 0xE5BC,
    0xDEF7, 0xDF73, 0xD3D6, 0xD56E, 0xD174, 0xD923, 0xD371, 0xDC9E, 0xDB02, 0xDA48, 0xDB3C, 0xD8C4, 0xDAE7, 0xCC24, 0xD34E, 0xD8E9,
    0xDC9D, 0xDD0D, 0xDF1E, 0xED47, 0xEFF5, 0xF18E, 0xF632, 0xF269, 0xF6D9, 0xFA7A, 0x0027, 0xFF67, 0xF9FC, 0xFB87, 0x0608, 0xFF66,
    0x0316, 0x03C9, 0x10E7, 0x1FB5, 0x28A3, 0x3A42, 0x383E, 0x43AA, 0x4B2E, 0x509E, 0x4C11, 0x4D99, 0x529B, 0x4B62, 0x4487, 0x43A4,
    0x36BF, 0x2E6B, 0x21E6, 0x1939, 0x113F, 0x0BDB, 0x05F8, 0xFD22, 0xFC0D, 0xEDAC, 0xEEFE, 0xEE08, 0xE6C3, 0xE4A7, 0xE5E2, 0xDE1A,
    0xE8EE, 0xE387, 0xE439, 0xEA15, 0xDE6C, 0xE81B, 0xE026, 0xE674, 0xE3CA, 0xE784, 0xF32E, 0xEB92, 0xF891, 0xFAD1, 0xFB8F, 0x04CF,
    0x01C6, 0x0239, 0xFEBC, 0xF8DA, 0xFAFC, 0xEE7F, 0xF0C5, 0xE970, 0xED6C, 0xF326, 0xECF5, 0xF792, 0xFF1A, 0x06C8, 0x03B6, 0x045C,
    0x028F, 0x05D8, 0x0373, 0x0DD1, 0x0948, 0x10FB, 0x1894, 0x1701, 0x1D46, 0x147E, 0x165B, 0x0988, 0x0279, 0x0504, 0x013D, 0xF981,
    0xFEFD, 0xFA6B, 0xF679, 0xF3F2, 0xECE6, 0xE93E, 0xE276, 0xE23D, 0xE61E, 0xE27D, 0xE917, 0xE94A, 0xEAC6, 0xF234, 0xDEBC, 0xEA70,
    0xE39A, 0xE601, 0xF114, 0xF375, 0x00BB, 0xFD76, 0x0A11, 0x0A55, 0x0B25, 0x0C84, 0x0BFA, 0x0A3D, 0x0C75, 0x03B9, 0x0945, 0x057E,
    0x000F, 0x0CD6, 0xFDA4, 0x0499, 0x06B9, 0x05E9, 0x0D67, 0x0BE9, 0x0DC2, 0x11CF, 0x188A, 0x1AEB, 0x186E, 0x1DAC, 0x1C79, 0x23E9,
    0x23DD, 0x2127, 0x2396, 0x1781, 0x13C7, 0x06EB, 0xF7D1, 0xF61F, 0xEF70, 0xEA9B, 0xF278, 0xEE90, 0xEC25, 0xF0B2, 0xF08C, 0xF217,
    0xEE48, 0xECE3, 0xF566, 0xFADC, 0xFFA5, 0xF831, 0xFA30, 0xF1C2, 0xE9FD, 0xEDD2, 0xDEBB, 0xE02A, 0xDCAE, 0xE563, 0xF159, 0xE9D1,
    0xEE94, 0xF8E6, 0xF887, 0xF965, 0xF8E2, 0xF897, 0xF922, 0xF909, 0xFF11, 0xF710, 0xFCFA, 0x00B3, 0xFBA1, 0xFF90, 0xF986, 0xFED7,
    0xFF77, 0x012A, 0x0D80, 0x113B, 0x1929, 0x2261, 0x290A, 0x2DD0, 0x2C53, 0x2E01, 0x34E4, 0x2DFC, 0x2C28, 0x28DF, 0x1B86, 0x1856,
    0x0EC1, 0x097C, 0x061B, 0x0215, 0x0685, 0x021D, 0x03B6, 0xF9F0, 0xF20C, 0xF1AA, 0xDFB9, 0xE1F9, 0xE052, 0xE280, 0xF5DA, 0xF4AB,
    0xF526, 0xF811, 0xF3B8, 0xF73E, 0xF4DA, 0xF49A, 0xF67B, 0xFBE3, 0x0ACD, 0x050D, 0x03C9, 0x0B50, 0x0214, 0x047B, 0x0136, 0xFA63,
    0x0081, 0xF9EC, 0xFC81, 0xFCC2, 0xF777, 0xFB04, 0xF974, 0xFD91, 0x009D, 0x04B3, 0x0641, 0x0B0B, 0x19D5, 0x1AF0, 0x1A5F, 0x2437,
    0x258C, 0x2291, 0x22CC, 0x1E8A, 0x22BB, 0x1AE5, 0x1A7D, 0x159E, 0x0A96, 0x0486, 0xF7C3, 0xF7CE, 0xED7C, 0xE303, 0xE1CE, 0xDD07,
    0xD94A, 0xCF50, 0xCA3C, 0xCDC8, 0xC5F5, 0xCDFC, 0xCDF2, 0xD4B0, 0xDEA2, 0xDE47, 0xE7A7, 0xE1DC, 0xDA6E, 0xDB35, 0xDA30, 0xDAB9,
    0xDF66, 0xE7A7, 0xF209, 0xF9CD, 0x06C5, 0x0DC5, 0x14C4, 0x16FE, 0x1CA5, 0x261F, 0x29A0, 0x2AC8, 0x30EC, 0x2F0A, 0x283F, 0x2A17,
    0x1FFF, 0x1F5C, 0x1F32, 0x1EB5, 0x2327, 0x1E0D, 0x2192, 0x256C, 0x297E, 0x2FD5, 0x2D8A, 0x325D, 0x3325, 0x3584, 0x3970, 0x2ECB,
    0x2D61, 0x2662, 0x21E9, 0x1FD2, 0x1339, 0x1023, 0x095B, 0x0317, 0xFABD, 0xF2AC, 0xEE1F, 0xE12E, 0xE0B6, 0xE06A, 0xD97D, 0xD901,
    0xDAF0, 0xE66D, 0xE4AA, 0xE3A3, 0xE525, 0xE1BE, 0xDCBD, 0xDB5B, 0xD8F1, 0xD783, 0xDFDF, 0xE161, 0xEA95, 0xEE68, 0xF14B, 0xF39A,
    0xF24B, 0xEE5E, 0xEB82, 0xE529, 0xE44D, 0xE86C, 0xE929, 0xEC26, 0xEEFF, 0xF68F, 0xF856, 0xFD2D, 0x0250, 0x06D8, 0x12A8, 0x146E,
    0x1732, 0x200C, 0x203D, 0x1F89, 0x2008, 0x2044, 0x1D11, 0x20B6, 0x1C3A, 0x1AAE, 0x134A, 0x0B5D, 0x094D, 0x0533, 0x01C1, 0xFB99,
    0xFD59, 0xF607, 0xF80F, 0xF692, 0xF5FE, 0xF033, 0xEE45, 0xF3CD, 0xEE7A, 0xEF5E, 0xEBCE, 0xF1E5, 0xF33E, 0xF390, 0xEFFD, 0xEC4E,
    0xEA5C, 0xE919, 0xECA8, 0xEC37, 0xEC0B, 0xEF68, 0xFDCF, 0xFA73, 0xFE04, 0xF8F2, 0xF71E, 0xFC03, 0xF852, 0xF902, 0xFA0F, 0x02CC,
    0x0114, 0x03C9, 0x0441, 0xFC45, 0xFE39, 0xFEAB, 0xF9CC, 0xFE17, 0xFD38, 0xFF3E, 0x0B2F, 0x10EB, 0x1243, 0x1B23, 0x21EA, 0x2A2A,
    0x2E9A, 0x32AD, 0x3475, 0x398A, 0x337F, 0x3130, 0x2EAB, 0x1F2A, 0x1B4B, 0x1222, 0x0B43, 0x0285, 0xF96F, 0xF361, 0xF0C4, 0xE34C,
    0xE022, 0xDACA, 0xDAE4, 0xDB9E, 0xDAEC, 0xDFFB, 0xE0E3, 0xE194, 0xE30A, 0xE1CE, 0xDB48, 0xDE58, 0xDFF7, 0xE16F, 0xE592, 0xEBDD,
    0xEF57, 0xF63F, 0xF869, 0xF815, 0xF7EF, 0xFB71, 0xF75B, 0xFD17, 0x034E, 0x02C0, 0x0617, 0x081A, 0x0BF9, 0x0BF9, 0x08AC, 0x0795,
    0x0F07, 0x1112, 0x161F, 0x2009, 0x2422, 0x2743, 0x2FC1, 0x2CA6, 0x2C0D, 0x2FCE, 0x2A74, 0x29A7, 0x26A5, 0x20B9, 0x1889, 0x134F,
    0x1544, 0x0C31, 0x0D2C, 0x0C00, 0x0AFA, 0x0DF2, 0x05C2, 0x04ED, 0x028B, 0xF907, 0xF444, 0xEF2D, 0xEBA5, 0xEAFC, 0xE7AA, 0xE98B,
    0xE641, 0xE56A, 0xDF9E, 0xD875, 0xD9F7, 0xD84C, 0xD579, 0xDA25, 0xDC49, 0xE45F, 0xE9CA, 0xEF7E, 0xF641, 0xF6A7, 0xFCD3, 0xFEDD,
    0xFD92, 0x0164, 0xFC0C, 0xFD65, 0xFF6D, 0xF364, 0xFB87, 0xF727, 0xF5EB, 0xF6F9, 0xF1F4, 0xF651, 0xFD4C, 0x00B3, 0x0075, 0x06FD,
    0x09EC, 0x06D3, 0x09FE, 0x06B9, 0x0389, 0x0E89, 0x097B, 0x0DD9, 0x0D0B, 0x01C7, 0x07DF, 0x017E, 0xF866, 0xF6ED, 0xF2B0, 0xEF03,
    0xEB73, 0xEB31, 0xE4DF, 0xE02F, 0xDF9A, 0xDFB4, 0xEAF6, 0xEDFD, 0xEEBF, 0xFCD9, 0x01FA, 0x0527, 0x06ED, 0x049D, 0x07D8, 0x074A,
    0x0854, 0x0CB0, 0x07DB, 0x0991, 0x1146, 0x131E, 0x126F, 0x0DD3, 0x1025, 0x0F97, 0x10BD, 0x1145, 0x0BA7, 0x0F86, 0x10A5, 0x10DC,
    0x14A5, 0x11EF, 0x1904, 0x171E, 0x1616, 0x1D20, 0x1DCA, 0x1F66, 0x258D, 0x2B8B, 0x2B1D, 0x2566, 0x26B8, 0x2455, 0x1E31, 0x20A0,
    0x159F, 0x18C4, 0x0FCB, 0x0731, 0x05EF, 0xF8A4, 0xF30C, 0xF10F, 0xEC50, 0xE79D, 0xE7A3, 0xE6AB, 0xE4E6, 0xDF7C, 0xDA2F, 0xD6DE,
    0xD99E, 0xD9D3, 0xD60C, 0xDB55, 0xD67B, 0xD26D, 0xD280, 0xC975, 0xCAEE, 0xC82B, 0xD00F, 0xDB69, 0xDF49, 0xE6E5, 0xF20F, 0xF8F6,
    0x001C, 0xFD67, 0xFEBE, 0x0219, 0xFCD5, 0x0141, 0xFB57, 0xF778, 0xF7B2, 0xF93C, 0xFA26, 0xF6F9, 0xFA43, 0xF82C, 0xF6C2, 0x06D9,
    0x0556, 0x09E1, 0x138E, 0x164B, 0x275A, 0x247A, 0x2644, 0x33B8, 0x2EC2, 0x2FFE, 0x302B, 0x2D8F, 0x25F4, 0x2042, 0x1FA2, 0x11C4,
    0x1131, 0x095A, 0x019E, 0x08AF, 0xFA02, 0xF720, 0xF69E, 0xE905, 0xE8C2, 0xE38C, 0xDE2A, 0xE294, 0xE210, 0xE125, 0xE57F, 0xE42A,
    0xE7E7, 0xE1FE, 0xE719, 0xE3F1, 0xE42F, 0xECD8, 0xE8EA, 0xF042, 0xF15A, 0xEEAD, 0xF0B0, 0xF0CB, 0xF19C, 0xF350, 0xF227, 0xFB3E,
    0xFB98, 0x0250, 0x038B, 0x0699, 0x10E0, 0x1237, 0x179F, 0x192C, 0x19ED, 0x22C7, 0x2323, 0x25CD, 0x2576, 0x25FE, 0x28E4, 0x25A6,
    0x28AA, 0x24E1, 0x1F55, 0x1E2E, 0x1AB0, 0x12CF, 0x118C, 0x0363, 0x0176, 0x0271, 0xFD14, 0xF5B7, 0xF311, 0xF2C5, 0xEA84, 0xE70B,
    0xE3D4, 0xDDB8, 0xDF5E, 0xDEFB, 0xE01D, 0xE661, 0xDC2C, 0xE310, 0xE98C, 0xE1C1, 0xE3C5, 0xE12C, 0xDDDF, 0xE3EC, 0xE2D7, 0xEB9A,
    0xF131, 0xFB70, 0x0367, 0x060E, 0x0FB4, 0x0D01, 0x109C, 0x0E9C, 0x0B9F, 0x13CF, 0x076A, 0x07E6, 0x0AE5, 0xFF8E, 0x0536, 0xFD26,
    0xF9EE, 0xFF73, 0xFE00, 0x0B33, 0x0EE5, 0x15EB, 0x2284, 0x2912, 0x34A4, 0x3465, 0x3D1F, 0x3AF5, 0x37E8, 0x36F5, 0x29F3, 0x2599,
    0x1F48, 0x1029, 0x0F4B, 0x05E6, 0xFDD2, 0xFB8E, 0xF191, 0xEE7D, 0xE789, 0xE2C5, 0xE02A, 0xDEDF, 0xDADA, 0xDC9E, 0xE34E, 0xE561,
    0xE1CB, 0xE978, 0xE638, 0xE3E1, 0xE449, 0xE0A0, 0xDEB0, 0xDF98, 0xDE31, 0xE5FC, 0xEA85, 0xEC3F, 0xF28D, 0xF226, 0xF990, 0xF29D,
    0xF06F, 0xEB5F, 0xE9F8, 0xECD5, 0xE933, 0xE8A8, 0xECA3, 0xED50, 0xF28B, 0xF295, 0xF30D, 0xF722, 0xF89D, 0x0488, 0x0774, 0x082E,
    0x0AE4, 0x0C3E, 0x1584, 0x14D4, 0x12F8, 0x1837, 0x18DC, 0x1CFE, 0x194F, 0x1A97, 0x19FB, 0x17C5, 0x1DB2, 0x17CF, 0x18EE, 0x190A,
    0x1131, 0x15CE, 0x0E43, 0x05EE, 0x06D6, 0x011A, 0xFE79, 0x0078, 0xFB2B, 0xFB17, 0xFC2F, 0xF950, 0xF4EE, 0xF67B, 0xF299, 0xF0DC,
    0xF432, 0xF1AA, 0xF5EE, 0xFEE9, 0x025F, 0x096F, 0x0DB9, 0x0717, 0x10F0, 0x0D40, 0x0BB0, 0x0A41, 0x0AD4, 0x09C6, 0x09A4, 0x0AF7,
    0x05FF, 0x02D4, 0x0008, 0xFECB, 0xFC5B, 0xF995, 0xF559, 0x00E1, 0x08CD, 0x0BD0, 0x1113, 0x177A, 0x2080, 0x23B5, 0x218E, 0x24FC,
    0x20A0, 0x1ED0, 0x155D, 0x1282, 0x09D3, 0xFCEB, 0xF77A, 0xF37D, 0xEE9F, 0xE41C, 0xDF59, 0xDA1F, 0xD8D4, 0xD36E, 0xD7E2, 0xD4EF,
    0xDE19, 0xE4DE, 0xE70D, 0xEDE7, 0xE71A, 0xE9F1, 0xE675, 0xE2E3, 0xE24E, 0xDDFC, 0xDE46, 0xDEAB, 0xE43E, 0xE3CE, 0xE62C, 0xECE9,
    0xF028, 0xF29D, 0xF82D, 0xF944, 0xFC6F, 0x01CD, 0xFEF6, 0x06C4, 0x080F, 0x0D55, 0x113B, 0x0FA6, 0x1254, 0x1533, 0x179C, 0x15BB,
    0x1C61, 0x20AA, 0x2709, 0x2EAE, 0x2D64, 0x33A2, 0x363B, 0x33FC, 0x3010, 0x2DD4, 0x2503, 0x2229, 0x1B0A, 0x1645, 0x1560, 0x0661,
    0x052F, 0x055B, 0xFF32, 0xF877, 0xF88F, 0xF057, 0xED50, 0xE584, 0xDFAF, 0xDFE6, 0xD9DA, 0xD839, 0xDAC4, 0xDE80, 0xD94D, 0xDA28,
    0xDB07, 0xD9A0, 0xE082, 0xDDC2, 0xE3AF, 0xEF63, 0xF415, 0xF9BE, 0x00A5, 0x057B, 0x058F, 0x0D35, 0x0CF5, 0x11A6, 0x0F92, 0x0A5E,
    0x0564, 0x098E, 0x020C, 0xFCDC, 0xFC3D, 0xF7C1, 0xFDA1, 0xF7F7, 0xFA8D, 0xF9A5, 0xFFD5, 0x02FE, 0x0CCE, 0x1323, 0x16D7, 0x1B60,
    0x2405, 0x203C, 0x1B38, 0x1DFB, 0x1C37, 0x1E43, 0x1BA7, 0x1D50, 0x1561, 0x1237, 0x0C5A, 0x07EF, 0xFFEA, 0xF840, 0xEEE9, 0xF08F,
    0xE957, 0xE5DB, 0xE95F, 0xE88F, 0xF1AC, 0xF125, 0xFA2D, 0xFAEC, 0xFCE2, 0xFBA6, 0xF98E, 0xF601, 0xEE42, 0xEA59, 0xEE73, 0xEFDF,
    0xE9B2, 0xF217, 0xF362, 0xF652, 0xF7F8, 0xF475, 0xFE34, 0x080C, 0x0B87, 0x0C0B, 0x13EF, 0x16D8, 0x193D, 0x1BE8, 0x1576, 0x1979,
    0x17FB, 0x1411, 0x165B, 0x12CC, 0x0DF9, 0x126F, 0x134C, 0x1266, 0x1299, 0x134F, 0x1A4A, 0x197A, 0x1550, 0x1113, 0x15C4, 0x0FEB,
    0x0E85, 0x0DDD, 0x087B, 0x064A, 0xFF75, 0xFD58, 0xF665, 0xF1E1, 0xEA73, 0xEC2C, 0xE7C9, 0xE5ED, 0xE417, 0xE345, 0xE477, 0xE278,
    0xDFB4, 0xDBA1, 0xDC83, 0xD477, 0xD6D8, 0xD253, 0xD089, 0xD234, 0xD58C, 0xDB20, 0xDB46, 0xE1FA, 0xE584, 0xED28, 0xEC57, 0xEED0,
    0xF24E, 0xEF6C, 0xF207, 0xEE44, 0xF0CC, 0xEC7E, 0xF039, 0xEF20, 0xF0FC, 0xF52B, 0xF5D8, 0xFDD9, 0x05A3, 0x124F, 0x122E, 0x21DA,
    0x24A0, 0x315E, 0x360E, 0x3AF7, 0x454A, 0x42BB, 0x4844, 0x40C6, 0x444C, 0x3769, 0x32AB, 0x2DB4, 0x2937, 0x2374, 0x1925, 0x1581,
    0x1051, 0x0DAF, 0xFFE9, 0x000C, 0xFA17, 0xFDB2, 0xFA95, 0xF85F, 0xFF0B, 0xF528, 0xF7C4, 0xF52B, 0xF50C, 0xF123, 0xF1D3, 0xF137,
    0xF1F3, 0xF35E, 0xEDD8, 0xF40B, 0xEE7C, 0xEEAF, 0xF14F, 0xEE7E, 0xF007, 0xF426, 0xF48F, 0xF7E2, 0xFF63, 0xFE3B, 0xFFB4, 0x067D,
    0x0982, 0x0423, 0x0A39, 0x0399, 0x0046, 0x0810, 0xFB91, 0x0211, 0xFC26, 0xFACD, 0x05B5, 0x019D, 0x0289, 0x07B4, 0x0CB6, 0x0E96,
    0x0FB0, 0x1104, 0x13B5, 0x1253, 0x1565, 0x0D5F, 0x0F8B, 0x0E08, 0x03DA, 0x0708, 0xFD83, 0xF3F6, 0xEE8D, 0xE619, 0xE6BF, 0xDF73,
    0xDC70, 0xE270, 0xDFB8, 0xE131, 0xDDCD, 0xE1FB, 0xE745, 0xE267, 0xE485, 0xE940, 0xE806, 0xF0EC, 0xED1F, 0xF1A1, 0xF7D9, 0xF7F1,
    0x02CC, 0x0617, 0x0ED0, 0x1177, 0x136D, 0x1A27, 0x1B2C, 0x13E1, 0x1517, 0x10F5, 0x12EA, 0x0C2B, 0x0497, 0x08F6, 0x0345, 0x08E5,
    0x07F0, 0x0D03, 0x0F40, 0x1129, 0x1D00, 0x1D1B, 0x1FB5, 0x2214, 0x23D0, 0x2554, 0x2177, 0x1784, 0x1597, 0x0E55, 0x0756, 0x0524,
    0xFBB8, 0xFCC9, 0xF739, 0xF9D2, 0xF5D8, 0xF29C, 0xEE9A, 0xEF5E, 0xF26A, 0xED2A, 0xF505, 0xF1C5, 0xF9C6, 0xF8FE, 0xFA84, 0xFADA,
    0xF4CF, 0xF33A, 0xEF86, 0xEF70, 0xE803, 0xE956, 0xE25B, 0xE96A, 0xE8E1, 0xE875, 0xEBB3, 0xED64, 0xFB9B, 0xF47A, 0xF7C8, 0xF6C8,
    0xF9FE, 0xF847, 0xFABA, 0xF9C6, 0xFAED, 0xFDB2, 0xFC2A, 0x09F4, 0x035E, 0x0D8B, 0x0F15, 0x1651, 0x17E7, 0x1418, 0x1D1C, 0x18C4,
    0x20D4, 0x1E7D, 0x1FDB, 0x27DB, 0x2605, 0x234A, 0x2A09, 0x236F, 0x2146, 0x236C, 0x1A14, 0x2306, 0x1543, 0x1215, 0x09EC, 0xFCAD,
    0xF751, 0xE918, 0xEB37, 0xE1C7, 0xE423, 0xE696, 0xE477, 0xE84F, 0xEA4B, 0xE93B, 0xEE5A, 0xED01, 0xF09E, 0xF7DE, 0xF768, 0x016E,
    0xFFB9, 0x05D9, 0x0B50, 0x04E6, 0x097C, 0x0714, 0x0718, 0x071C, 0xFD76, 0xFC93, 0xF909, 0xF4B0, 0xF0F2, 0xF06B, 0xEDD9, 0xEDB3,
    0xF034, 0xF18D, 0xF072, 0xF183, 0xF41A, 0xF6A2, 0x0003, 0xFC3F, 0x0733, 0x134B, 0x1574, 0x2099, 0x21E2, 0x27FE, 0x2981, 0x2470,
    0x216F, 0x1DDD, 0x12E1, 0x0B9A, 0x081C, 0x02D5, 0xFB01, 0xF13E, 0xF297, 0xE6AF, 0xE37B, 0xDCBF, 0xDA65, 0xDCD2, 0xD846, 0xDD5A,
    0xDD36, 0xDD07, 0xDA3C, 0xD902, 0xD62E, 0xD28E, 0xD13B, 0xD092, 0xD286, 0xD7DB, 0xDC34, 0xE112, 0xE88E, 0xEC27, 0xF7B8, 0xFFB8,
    0x0746, 0x0EEB, 0x0EEA, 0x1A77, 0x1C0E, 0x1FE0, 0x1DCC, 0x1EDC, 0x25DA, 0x24FF, 0x23E9, 0x218D, 0x2033, 0x2345, 0x1F00, 0x1B98,
    0x2120, 0x1AED, 0x2896, 0x2AC2, 0x2C48, 0x301E, 0x2CF5, 0x3316, 0x2E56, 0x24C5, 0x2423, 0x20D8, 0x1B1B, 0x191E, 0x1406, 0x1449,
    0x0BEB, 0x0C69, 0x09C6, 0x0101, 0xFCD8, 0xEFBC, 0xEFDB, 0xE938, 0xE088, 0xE2FE, 0xDE80, 0xE1B1, 0xE1F7, 0xDB90, 0xE00C, 0xE030,
    0xDEDC, 0xE80B, 0xE746, 0xEF01, 0xF066, 0xF263, 0xF885, 0xF369, 0xF20C, 0xEFB6, 0xF0DC, 0xEDF7, 0xEBE8, 0xED38, 0xEBE3, 0xEAF4,
    0xEBAA, 0xE531, 0xEC57, 0xEB9C, 0xEA1C, 0xF59B, 0xF58B, 0xFCAD, 0x005B, 0x0338, 0x0CD2, 0x1131, 0x14EA, 0x1AE3, 0x1E7D, 0x1EBF,
    0x1D68, 0x1B84, 0x1674, 0x0D67, 0x0E77, 0x06F1, 0x0638, 0x06C3, 0x01D8, 0x0658, 0xFE50, 0xFAA8, 0xF671, 0xF30B, 0xEC83, 0xEBC1,
    0xEC72, 0xF288, 0xF2F7, 0xF518, 0xFC2F, 0xFEDC, 0x0479, 0xFD05, 0x00CF, 0xFBC2, 0xF7C5, 0xF8BC, 0xF670, 0xF5F7, 0xF3D0, 0xF8CF,
    0xFCA9, 0xFE6C, 0xFCAA, 0xFECA, 0x0442, 0x072B, 0x05AD, 0x0855, 0x0A87, 0x06BD, 0x0967, 0x0057, 0x019D, 0xF7BC, 0xF3E5, 0xF9CD,
    0xF3FD, 0xF967, 0xF470, 0xFA8E, 0x01C2, 0x055E, 0x0A8B, 0x13F2, 0x1B8B, 0x259A, 0x28BE, 0x2878, 0x28F5, 0x2477, 0x2657, 0x207B,
    0x2222, 0x1CEC, 0x18B4, 0x1BBA, 0x0BDA, 0x04DE, 0xF9B3, 0xEF12, 0xED74, 0xE271, 0xE10C, 0xE413, 0xE2FC, 0xE335, 0xE655, 0xE18D,
    0xE0F8, 0xDB6A, 0xDB99, 0xDC8B, 0xD9C1, 0xDFBB, 0xE0CE, 0xE9F9, 0xEA16, 0xF0C2, 0xFAB4, 0xF987, 0x0278, 0x020A, 0x0551, 0x0690,
    0x015B, 0x00BE, 0x01AA, 0xFE24, 0xFAEE, 0xF8BD, 0xF7C1, 0xFE9B, 0xFC2A, 0x05B0, 0x0869, 0x1090, 0x1376, 0x19F3, 0x22E4, 0x1B59,
    0x245F, 0x25E4, 0x2A59, 0x2955, 0x2524, 0x26E3, 0x2589, 0x1F88, 0x1A93, 0x1942, 0x15BF, 0x1AA3, 0x1536, 0x15AB, 0x1175, 0x0D81,
    0x0CB7, 0x0401, 0x0853, 0xFFAA, 0x04DA, 0x058F, 0x04EB, 0x0049, 0xFD7F, 0xF897, 0xF0A7, 0xEA5D, 0xDFFA, 0xE3B4, 0xDB7D, 0xE024,
    0xDC1E, 0xE0C5, 0xE15A, 0xE0EB, 0xE589, 0xE313, 0xE879, 0xE56B, 0xEC8C, 0xF24E, 0xF44F, 0xF9C1, 0x0137, 0x0295, 0x04E5, 0x0642,
    0x0897, 0x0D15, 0x03F0, 0x0944, 0x06B5, 0x04D7, 0x0566, 0x0577, 0x0B91, 0x0586, 0x0D9C, 0x0D9F, 0x1528, 0x158F, 0x1340, 0x195B,
    0x1619, 0x0F0D, 0x0936, 0x031E, 0xFE6E, 0xFFE4, 0xF1B3, 0xF22B, 0xEAF8, 0xE3B5, 0xE10D, 0xD8FD, 0xDA88, 0xD550, 0xDF9A, 0xE04F,
    0xE768, 0xEEAD, 0xED7B, 0xF5B1, 0xF657, 0xF93A, 0xF99C, 0xFD9B, 0xFE8D, 0x08C3, 0x06EB, 0x0CBE, 0x0F3E, 0x0AEF, 0x12AA, 0x0F86,
    0x11DE, 0x0AF2, 0x1076, 0x11B4, 0x1211, 0x11CD, 0x0D89, 0x0F22, 0x088E, 0x0A54, 0x05C0, 0x0383, 0x01EE, 0x0927, 0x0E02, 0x0F1E,
    0x1412, 0x15DF, 0x23F0, 0x22C2, 0x2A2E, 0x2D10, 0x330B, 0x33CA, 0x2E26, 0x2ED3, 0x25E4, 0x2089, 0x145E, 0x1466, 0x0D25, 0x094A,
    0x0144, 0x03B1, 0x034C, 0xFA06, 0xFA3E, 0xF227, 0xF655, 0xECCD, 0xEBEB, 0xEF50, 0xEA72, 0xE99C, 0xE300, 0xE139, 0xD9D6, 0xD6C3,
    0xD2AD, 0xD629, 0xD768, 0xD890, 0xDA20, 0xDC9F, 0xE419, 0xDEAA, 0xE856, 0xE75C, 0xF457, 0xF6CD, 0xF7D5, 0x0510, 0x03BB, 0x0525,
    0xFDBE, 0x006A, 0xF886, 0xF762, 0xF2F3, 0xF18D, 0xF54C, 0xF22A, 0xF7BA, 0xFA04, 0xFDE8, 0xFCF0, 0x07E9, 0x073D, 0x0D34, 0x1369,
    0x1484, 0x1FBD, 0x1DD4, 0x22E0, 0x205F, 0x2733, 0x23D4, 0x26BB, 0x2795, 0x1EB4, 0x2342, 0x1C02, 0x1548, 0x0A1B, 0x0464, 0xFB02,
    0xF81E, 0xEE0C, 0xEC7E, 0xF4A9, 0xEEF2, 0xF417, 0xF19E, 0xF62D, 0xF160, 0xEEBF, 0xEE68, 0xEAC8, 0xEE4F, 0xE99A, 0xED8D, 0xEC39,
    0xED88, 0xE857, 0xEC8B, 0xEB22, 0xEC5E, 0xEDDD, 0xF0B3, 0xFBE1, 0xF5E4, 0xFA6A, 0xF727, 0xFE0B, 0xFB75, 0xFA30, 0x0106, 0x04CF,
    0x0913, 0x0846, 0x0DF6, 0x0FE7, 0x142A, 0x136F, 0x187B, 0x1DB9, 0x1F24, 0x20B6, 0x249F, 0x2ABB, 0x1FAA, 0x21F5, 0x1E1F, 0x19EB,
    0x1702, 0x0A8C, 0x0B1C, 0x04CA, 0x01AD, 0xF82F, 0xF7B6, 0xF16D, 0xEFA3, 0xEEE0, 0xEAC7, 0xEBEA, 0xEBB4, 0xF279, 0xF19B, 0xF8A2,
    0xEE0A, 0xF007, 0xF1B7, 0xE82F, 0xE72D, 0xE204, 0xE408, 0xE488, 0xEAA7, 0xEA2F, 0xF493, 0xF6CD, 0xFCA2, 0x066D, 0x0521, 0x0C3D,
    0x0E17, 0x169C, 0x10BF, 0x14A9, 0x0FDA, 0x0AAA, 0x09AB, 0x02F3, 0x05F9, 0x02A4, 0x0622, 0x048D, 0x0C1E, 0x0D80, 0x0FAC, 0x1159,
    0x1510, 0x2369, 0x286D, 0x2EA9, 0x335A, 0x3BAE, 0x38FE, 0x3831, 0x321D, 0x2C50, 0x29E9, 0x1BD1, 0x1C70, 0x0DE2, 0x0804, 0xFEB5,
    0xF71B, 0xF257, 0xE642, 0xE35D, 0xDC7A, 0xDC8B, 0xD6D3, 0xDA13, 0xD91B, 0xDE04, 0xD8A5, 0xDB9D, 0xDF31, 0xDB42, 0xE1F6, 0xDD3E,
    0xE91E, 0xE935, 0xEE0E, 0xF4EE, 0xF47C, 0xF6B3, 0xF5A6, 0xF7AC, 0xF397, 0xF5CE, 0xF2FA, 0xF82C, 0xF636, 0xF478, 0xF59B, 0xF35D,
    0xF51C, 0xEE01, 0xF68E, 0xF146, 0xF2CD, 0xF170, 0xF212, 0xF828, 0xF147, 0xF371, 0xF78D, 0x012E, 0x01E3, 0x0A49, 0x0D9B, 0x14A2,
    0x1583, 0x116D, 0x1608, 0x142B, 0x1779, 0x14DD, 0x1FA3, 0x1BBA, 0x1AC4, 0x1BFC, 0x13FD, 0x176F, 0x0A14, 0x076A, 0x07C0, 0x0A59,
    0x0411, 0x0602, 0x07B3, 0x05AD, 0x05F2, 0xFCBB, 0x01D1, 0xFADF, 0xF786, 0xF195, 0xF5A5, 0xF3C6, 0xF09B, 0xF822, 0xF687, 0xFE89,
    0xFCFB, 0x0145, 0x05E9, 0x0B99, 0x0A25, 0x0D8B, 0x1467, 0x0E9F, 0x12D0, 0x0BD8, 0x0D8A, 0x0630, 0x045E, 0x018D, 0xFEAE, 0x020E,
    0x006A, 0x06AE, 0x0139, 0x0BF6, 0x1018, 0x18B4, 0x1CEA, 0x22FB, 0x2A1C, 0x27EA, 0x2740, 0x2100, 0x1E11, 0x1387, 0x133D, 0x09D1,
    0x061C, 0xFEF8, 0xF89C, 0xF723, 0xE7F2, 0xE5DA, 0xDA83, 0xDBCB, 0xDA30, 0xD657, 0xDC87, 0xDD61, 0xE47A, 0xE5B8, 0xE3BD, 0xE3B9,
    0xEA10, 0xE3D1, 0xE62B, 0xE2A4, 0xE499, 0xE86C, 0xE433, 0xEDA2, 0xEB9F, 0xF08C, 0xEDA0, 0xF143, 0xF57B, 0xEE9A, 0xF0D4, 0xF1FA,
    0xF452, 0xF561, 0xF2B0, 0xF319, 0xFA36, 0xF6CF, 0xF78D, 0x0046, 0x02AC, 0x0988, 0x0DCA, 0x163A, 0x1A83, 0x1DE6, 0x209C, 0x2794,
    0x2DDF, 0x2A74, 0x300A, 0x304A, 0x2DD0, 0x2D32, 0x2B3A, 0x2836, 0x2AEB, 0x257C, 0x220B, 0x2497, 0x1B6C, 0x1495, 0x0ABC, 0x0115,
    0xF88A, 0xF113, 0xEB2F, 0xE77B, 0xE8E6, 0xE525, 0xE511, 0xE435, 0xDFDA, 0xDE18, 0xDDBE, 0xD9A0, 0xDB84, 0xDD4D, 0xDFD6, 0xE95F,
    0xEA42, 0xF385, 0xF794, 0xFA9A, 0xFCF4, 0xFD67, 0x04A5, 0x04D7, 0x0474, 0x0646, 0x0991, 0x0B9C, 0x0938, 0x0670, 0x08C7, 0x046C,
    0xFF95, 0xFFF1, 0xFC50, 0xF9F8, 0xF7C0, 0xFEF5, 0xFD90, 0xFE22, 0x0559, 0x099D, 0x13ED, 0x137F, 0x17B3, 0x1AC4, 0x1CF0, 0x1A17,
    0x1765, 0x17B0, 0x144D, 0x10C3, 0x0F61, 0x0AAA, 0x03FC, 0x0148, 0xF71E, 0xF667, 0xEF61, 0xEBC4, 0xF0FC, 0xF103, 0xF4DD, 0xFA61,
    0xFC4E, 0xFB1D, 0xFBF5, 0xFBF0, 0xF7B0, 0xF4EB, 0xF600, 0xF259, 0xF653, 0xF874, 0xF400, 0xFB01, 0xF82F, 0xF81F, 0xFC98, 0xF95D,
    0xFEEC, 0x032D, 0x0184, 0x0832, 0x0CD4, 0x0A79, 0x0E4A, 0x0ECE, 0x0F5F, 0x0C8A, 0x0FE0, 0x0EBC, 0x0DE6, 0x1124, 0x0BF4, 0x147A,
    0x1474, 0x1235, 0x174D, 0x194D, 0x1A38, 0x16EC, 0x112E, 0x10F3, 0x0FCC, 0x0992, 0x0726, 0x041F, 0x03D8, 0xFEB4, 0xFE40, 0xFDC7,
    0xFB97, 0xF9CD, 0xF3D8, 0xF577, 0xEF8C, 0xECC5, 0xECE7, 0xECDF, 0xEC70, 0xE999, 0xE85A, 0xEA62, 0xE485, 0xDDA9, 0xDEC9, 0xDBDB,
    0xDFB3, 0xDD9D, 0xE080, 0xE79D, 0xE860, 0xE922, 0xE70D, 0xE7C6, 0xE64D, 0xE6CF, 0xE8BB, 0xE926, 0xE942, 0xEBD9, 0xEC44, 0xECA9,
    0xEE4E, 0xE7EB, 0xED16, 0xED95, 0xF1A1, 0xF5B6, 0xF75A, 0x0322, 0x06DB, 0x10F0, 0x1853, 0x21DB, 0x2872, 0x2F12, 0x3468, 0x35C1,
    0x35B2, 0x3630, 0x381F, 0x35A4, 0x36CC, 0x318E, 0x3446, 0x2D88, 0x24F0, 0x211A, 0x159B, 0x1017, 0x04D8, 0x020B, 0xFA51, 0xF5F8,
    0xF76B, 0xF3BC, 0xF65F, 0xF3C4, 0xF92B, 0xFD61, 0xF8DE, 0xF4DC, 0xF86A, 0xF20E, 0xF1EB, 0xF205, 0xEEFB, 0xFA30, 0xF442, 0xF66E,
    0xF69D, 0xF69B, 0xF4BC, 0xF634, 0xFD1D, 0xF9C1, 0xFF8F, 0xFF6B, 0x01F2, 0x00CB, 0xFE2B, 0xFA93, 0xFE57, 0xF97C, 0xF6FD, 0xFF2D,
    0xF84C, 0xFE51, 0xFA8E, 0xFDE6, 0x01CD, 0x03E7, 0x060F, 0x0822, 0x115D, 0x0ED4, 0x11E9, 0x110C, 0x15E5, 0x13A6, 0x149A, 0x1355,
    0x111B, 0x1161, 0x0A59, 0x0BA5, 0x00CF, 0xFFAF, 0xF71C, 0xF5CE, 0xF56D, 0xEE03, 0xF119, 0xEAEF, 0xEEC1, 0xE9E2, 0xE72D, 0xE467,
    0xE462, 0xDE02, 0xDB96, 0xDE19, 0xDA0A, 0xDF7E, 0xDE64, 0xE924, 0xE842, 0xF22F, 0xF614, 0xF9F3, 0x03CB, 0xFE9F, 0x09C9, 0x0B39,
    0x0C08, 0x0DD1, 0x109A, 0x0CD9, 0x0D3D, 0x0A6E, 0x07FF, 0x0B40, 0x0981, 0x1183, 0x0F4D, 0x1629, 0x14E7, 0x1979, 0x20C5, 0x1BB2,
    0x23C1, 0x21A2, 0x2385, 0x22C6, 0x202A, 0x1AFC, 0x188A, 0x14AF, 0x0F32, 0x0DA6, 0x04AD, 0x04CA, 0xFF54, 0xFD06, 0xF576, 0xF6F2,
    0xF105, 0xECF7, 0xF5D7, 0xEEEE, 0xF3A8, 0xF1DB, 0xF479, 0xF2AC, 0xEFE6, 0xEEFC, 0xEEE7, 0xEDCA, 0xE9AB, 0xF034, 0xEE90, 0xF148,
    0xEF04, 0xF39D, 0xF038, 0xF0F2, 0xF1B3, 0xED28, 0xF3B1, 0xE9C0, 0xF0EA, 0xF03B, 0xED06, 0xEEB0, 0xF078, 0xF5FA, 0xF41F, 0xF4E2,
    0xF2E8, 0xF949, 0xF50F, 0xF996, 0xF9F5, 0xFC3B, 0x02EC, 0x040F, 0x111A, 0x0ED8, 0x1956, 0x1BC7, 0x2374, 0x26F1, 0x24F0, 0x2AAC,
    0x2673, 0x2A60, 0x2369, 0x24AD, 0x20E7, 0x20ED, 0x19F8, 0x1801, 0x1245, 0x0924, 0x0A98, 0xFED2, 0x02C5, 0xFAC2, 0xF8B6, 0xF646,
    0xF634, 0xF69D, 0xF21F, 0xF8B0, 0xF42A, 0xF5B4, 0xF514, 0xF5BA, 0xF716, 0xF935, 0xF7CA, 0xFC76, 0xFEDC, 0xFC7D, 0x07D6, 0x0225,
    0x08D1, 0x075D, 0x082C, 0x0A9D, 0x02C2, 0x02FE, 0xF98A, 0xFD50, 0xF468, 0xEBB4, 0xEBDB, 0xEB75, 0xE5DB, 0xE89E, 0xEA9B, 0xEA8F,
    0xF5B0, 0xF6CA, 0x0382, 0x072F, 0x0F44, 0x167C, 0x1ACE, 0x1FCC, 0x1A09, 0x1FDA, 0x1A83, 0x186B, 0x157D, 0x1115, 0x0F71, 0x0B32,
    0x0405, 0x0136, 0xFFDF, 0xF2CF, 0xF3E5, 0xEBF1, 0xEA08, 0xE889, 0xE478, 0xE2D0, 0xDCEC, 0xE098, 0xD87E, 0xD74D, 0xD2EC, 0xD11B,
    0xD217, 0xCF06, 0xD1FE, 0xD37D, 0xD7D4, 0xD9E6, 0xE09B, 0xE390, 0xEDDA, 0xF24D, 0xF9FD, 0xFFB5, 0xFE0D, 0x0A3B, 0x05C9, 0x0B80,
    0x0BDD, 0x0D52, 0x0FC5, 0x0D4A, 0x1198, 0x103C, 0x148F, 0x1534, 0x18CB, 0x1B7F, 0x1D28, 0x20E6, 0x28C5, 0x281E, 0x2885, 0x2AA5,
    0x2760, 0x2E74, 0x2A86, 0x28E9, 0x2BC5, 0x28EE, 0x2A2B, 0x2818, 0x284E, 0x247C, 0x1EE9, 0x1955, 0x150E, 0x0EAE, 0x06A2, 0x00ED,
    0x003C, 0xFDC7, 0xF89A, 0xF8D4, 0xF635, 0xF9B9, 0xF217, 0xF016, 0xEF06, 0xE861, 0xE5AA, 0xE330, 0xE464, 0xE3E3, 0xE44B, 0xE561,
    0xEA9C, 0xE9E0, 0xEF16, 0xEE08, 0xF096, 0xF21A, 0xECF2, 0xF3E5, 0xED7C, 0xF0ED, 0xF016, 0xEFBE, 0xF879, 0xF4DF, 0xF5EC, 0xF5A7,
    0xF7C3, 0xF89B, 0xF9E8, 0xFA6D, 0x0167, 0x07CC, 0x10FB, 0x1482, 0x1717, 0x2168, 0x1A69, 0x2281, 0x1EA7, 0x188B, 0x1A52, 0x0FD2,
    0x1102, 0x08A2, 0x01DC, 0xFB60, 0xF441, 0xF0E3, 0xED19, 0xEA88, 0xE615, 0xEBA0, 0xEF0C, 0xEE17, 0xEDC6, 0xF837, 0xF6AE, 0xF6C2,
    0xF904, 0xF76A, 0xFB5B, 0xF2AA, 0xF428, 0xF5A7, 0xF85B, 0xF784, 0xF6C3, 0x00B6, 0x02E3, 0x0201, 0x0499, 0x0898, 0x079D, 0x06B7,
    0x058F, 0x06E2, 0x060C, 0xFEAD, 0xFDB9, 0xFAEB, 0xFBEF, 0xF41C, 0xF2C2, 0xF20D, 0xEE17, 0xF160, 0xEACC, 0xF221, 0xFB45, 0x010F,
    0x095B, 0x1456, 0x1750, 0x1E6C, 0x1FCC, 0x1F5C, 0x2576, 0x216E, 0x2455, 0x2318, 0x2681, 0x210E, 0x1A5C, 0x19FF, 0x0F6F, 0x0FE0,
    0x0766, 0x002D, 0x004C, 0xFAAD, 0xF58C, 0xF131, 0xEE71, 0xE9E1, 0xE8F9, 0xE3FD, 0xE1A4, 0xDCF0, 0xDEF6, 0xDB31, 0xDA6F, 0xDF2E,
    0xDD38, 0xE636, 0xE214, 0xEA61, 0xEE96, 0xEBC9, 0xF04D, 0xF0A6, 0xF659, 0xF3C0, 0xF8F0, 0xFDE9, 0xFEFC, 0x0185, 0x02F6, 0x02C2,
    0x0600, 0x02FB, 0xFEBF, 0x0514, 0xFDD5, 0x0264, 0x02FC, 0x06CA, 0x1216, 0x12D4, 0x1E0E, 0x2169, 0x25D8, 0x27D7, 0x23AD, 0x24AA,
    0x248B, 0x24BA, 0x23B2, 0x23A1, 0x2605, 0x27A3, 0x1EED, 0x1DED, 0x1712, 0x0F70, 0x0DC5, 0x06BB, 0x0868, 0xFEDB, 0x0126, 0x0070,
    0xFC60, 0xFE03, 0xFAF1, 0xFB8B, 0xF99A, 0xF331, 0xEF8F, 0xEC10, 0xE3E4, 0xE1AA, 0xDB8E, 0xDC4C, 0xD99A, 0xD849, 0xDC3B, 0xDA20,
    0xDD72, 0xDFD7, 0xE3F7, 0xE573, 0xE80C, 0xF2A2, 0xF1E2, 0xF0C9, 0xF4C0, 0xF5B9, 0xF5C7, 0xF51B, 0xF376, 0xF600, 0xF307, 0xF478,
    0xFC9B, 0xFF52, 0x05DA, 0x080E, 0x140F, 0x18F1, 0x18FD, 0x184E, 0x15D7, 0x1ACE, 0x15C4, 0x109A, 0x1233, 0x1162, 0x0C6C, 0x0A41,
    0x0205, 0xFD07, 0xF2C9, 0xE8B0, 0xEA73, 0xE751, 0xE709, 0xE35A, 0xEB62, 0xF298, 0xEEE5, 0xEED5, 0xEEF3, 0xF3B4, 0xF26C, 0xEDAF,
    0xEF40, 0xF3C9, 0xF0BA, 0xEEF2, 0xF085, 0xF5E5, 0xF6CE, 0xF870, 0xFEE9, 0x019A, 0x0922, 0x0632, 0x072D, 0x0C18, 0x0959, 0x0C5B,
    0x0978, 0x0A3F, 0x0B27, 0x071D, 0x0808, 0x098E, 0x073E, 0x068A, 0x0864, 0x0E32, 0x126B, 0x1370, 0x1ECD, 0x1E00, 0x274C, 0x27BA,
    0x2114, 0x261B, 0x2465, 0x253D, 0x2164, 0x23C6, 0x2592, 0x2315, 0x1E2C, 0x1C5B, 0x13B1, 0x0B81, 0x02B0, 0xFA4B, 0xFA8F, 0xEED1,
    0xEEAA, 0xEB5A, 0xEC06, 0xF07D, 0xE8AC, 0xEBE8, 0xE8D3, 0xE876, 0xE3A9, 0xE26F, 0xE3FA, 0xE1F7, 0xE477, 0xE609, 0xE749, 0xE6AA,
    0xEA7A, 0xE62D, 0xED4B, 0xEAD6, 0xE8FA, 0xEC53, 0xEAEF, 0xF089, 0xE955, 0xEF12, 0xF286, 0xF312, 0xF341, 0xF538, 0xFA47, 0xF4E5,
    0xF03B, 0xED5D, 0xF048, 0xED0F, 0xEFD1, 0xF190, 0xFA86, 0xFF53, 0xFF9B, 0x08BA, 0x0BF8, 0x148C, 0x12AA, 0x1961, 0x2038, 0x218A,
    0x24CE, 0x23F1, 0x24CD, 0x2104, 0x1C1B, 0x15C6, 0x1331, 0x0E02, 0x0A18, 0x07B2, 0x0825, 0x0B2C, 0x05CC, 0x093D, 0x0619, 0x04E9,
    0x01D8, 0xFADE, 0xF98A, 0xF549, 0xF707, 0xF026, 0xEDF2, 0xED57, 0xEBE6, 0xE821, 0xE486, 0xE577, 0xE848, 0xE71B, 0xE5CF, 0xEE98,
    0xF2AC, 0xF329, 0xF0E2, 0xF736, 0xFC7A, 0xF99F, 0xF911, 0xF6D6, 0xFD55, 0xF92A, 0xF334, 0xF6E4, 0xF59B, 0xFC90, 0xFF68, 0x05E5,
    0x114D, 0x16B3, 0x15DE, 0x1D98, 0x21DC, 0x20A4, 0x1BD3, 0x1A9C, 0x2067, 0x1991, 0x179D, 0x0D30, 0x0DA3, 0x0C49, 0x01F4, 0x000F,
    0xFD74, 0xFBC9, 0xF71B, 0xF5BB, 0xF307, 0xEFE6, 0xEABF, 0xE6FC, 0xDEC1, 0xD620, 0xCEDA, 0xC77F, 0xC7DE, 0xC2DB, 0xC1D2, 0xBCA0,
    0xB53F, 0xB745, 0xB3C3, 0xAC7A, 0xAB1C, 0xAC96, 0xAA67, 0xA8D3, 0xA82E, 0xA947, 0xA9BF, 0xA974, 0xA871, 0xAA66, 0xAEB2, 0xAD8E,
    0xAFB7, 0xB2F6, 0xB579, 0xB911, 0xBB42, 0xC171, 0xCA88, 0xD21D, 0xDD37, 0xE9AE, 0xF028, 0xFAB6, 0x06F3, 0x1518, 0x1CBB, 0x2626,
    0x301A, 0x38CA, 0x47C2, 0x4A27, 0x50AC, 0x5755, 0x5B16, 0x58A8, 0x5717, 0x5546, 0x5029, 0x4E6F, 0x4C8B, 0x4C79, 0x48AD, 0x44C9,
    0x4242, 0x46F9, 0x4607, 0x44CD, 0x4722, 0x4A68, 0x4CCF, 0x4A72, 0x4AF5, 0x4AC2, 0x4C85, 0x48AA, 0x499F, 0x4C0F, 0x4A19, 0x4B74,
    0x4D1E, 0x52B6, 0x54A0, 0x56AB, 0x56EB, 0x5C04, 0x5D35, 0x5B83, 0x5CCC, 0x5CB7, 0x5E34, 0x5AC6, 0x58A9, 0x549B, 0x528E, 0x4F1E,
    0x4B92, 0x499C, 0x4C31, 0x4BA4, 0x4A4F, 0x4B9D, 0x4D2B, 0x4EA4, 0x4AC1, 0x4BDF, 0x4A71, 0x4C16, 0x4A64, 0x4641, 0x4539, 0x43D7,
    0x3E48, 0x3809, 0x31A0, 0x2B09, 0x268D, 0x1C3B, 0x1B4C, 0x15D1, 0x130F, 0x0F49, 0x082D, 0x072A, 0xFFD4, 0xF844, 0xEF58, 0xEEB5,
    0xE7EC, 0xDDF5, 0xD90E, 0xD7BE, 0xD1B1, 0xCACE, 0xC93E, 0xC851, 0xC8A4, 0xC3C6, 0xC6AA, 0xC5B6, 0xC415, 0xC2E4, 0xC087, 0xBE65,
    0xBB2A, 0xB772, 0xB62E, 0xB775, 0xB386, 0xB49D, 0xB2EE, 0xB29E, 0xB10F, 0xB21F, 0xB27D, 0xB201, 0xB6E7, 0xB8BA, 0xBCE8, 0xBD4C,
    0xC17D, 0xC1F0, 0xC37E, 0xC24F, 0xC209, 0xC3B0, 0xC2AF, 0xC69A, 0xC2D9, 0xC437, 0xC17D, 0xC1C4, 0xBF1E, 0xBDA6, 0xBDDC, 0xB96E,
    0xBC04, 0xBACA, 0xBC87, 0xB972, 0xB9C3, 0xB816, 0xB6F4, 0xB71B, 0xB32C, 0xB67C, 0xB599, 0xB79D, 0xB973, 0xBB18, 0xBE0F, 0xBE7E,
    0xC2B1, 0xC3CD, 0xC693, 0xC842, 0xCB2C, 0xCE7F, 0xCDFC, 0xD206, 0xD3EB, 0xD71D, 0xD783, 0xDBB1, 0xE11F, 0xE528, 0xEA71, 0xEA29,
    0xF270, 0xF4F6, 0xF922, 0xFB06, 0xFEC5, 0x0697, 0x08D3, 0x141D, 0x1A69, 0x24B4, 0x27FF, 0x309A, 0x3657, 0x3932, 0x3D1B, 0x3A11,
    0x45DB, 0x46E6, 0x4851, 0x452E, 0x4611, 0x45A8, 0x4199, 0x3D8E, 0x36C6, 0x38D3, 0x3425, 0x34F3, 0x3253, 0x3226, 0x2FF3, 0x3061,
    0x2FF2, 0x308D, 0x32A5, 0x2F30, 0x35B6, 0x3622, 0x35AB, 0x33CB, 0x361B, 0x35F7, 0x37D6, 0x3701, 0x371F, 0x3B40, 0x3CB8, 0x4084,
    0x3ED9, 0x42D4, 0x4106, 0x42E9, 0x3F98, 0x414C, 0x40B9, 0x3E09, 0x3D24, 0x367E, 0x38EE, 0x3172, 0x30E7, 0x29E0, 0x2F7B, 0x3207,
    0x2F66, 0x3707, 0x3791, 0x3ED3, 0x3A7A, 0x3DF8, 0x3D5B, 0x3D76, 0x3A7E, 0x3826, 0x3A8A, 0x3647, 0x3625, 0x2F80, 0x3374, 0x2D3F,
    0x29C8, 0x2581, 0x21AD, 0x227F, 0x1B54, 0x1DB6, 0x1BE8, 0x1B0F, 0x15F2, 0x1364, 0x0FD9, 0x099A, 0x049B, 0xFFE4, 0xFFC2, 0xFB6F,
    0xF67B, 0xF53B, 0xF594, 0xF388, 0xF1AE, 0xF442, 0xF6D3, 0xF80C, 0xFB2E, 0xFAB0, 0xFE1C, 0xFC7A, 0xFC8B, 0xFBB9, 0xF7F9, 0xFA5B,
    0xF699, 0xF67C, 0xF437, 0xF157, 0xEE78, 0xECF5, 0xEBD9, 0xEAD5, 0xEB77, 0xE9C4, 0xEE64, 0xED54, 0xEDAB, 0xEC81, 0xE764, 0xE55F,
    0xE136, 0xDDC6, 0xD9AE, 0xDA89, 0xD71C, 0xD573, 0xD646, 0xD050, 0xD056, 0xCBD8, 0xC564, 0xC252, 0xBF0B, 0xBC93, 0xB7CF, 0xBAAA,
    0xB8FE, 0xBA56, 0xB84C, 0xB755, 0xBAFB, 0xB45A, 0xB651, 0xB4DB, 0xB725, 0xB3B6, 0xB54A, 0xB660, 0xB5A4, 0xB7C7, 0xB031, 0xB4CD,
    0xB243, 0xB4AE, 0xB1AE, 0xB2B6, 0xB391, 0xB008, 0xB347, 0xAE08, 0xB394, 0xB0EA, 0xB65F, 0xB7A0, 0xBA5C, 0xBE81, 0xBD55, 0xC326,
    0xC231, 0xC8BC, 0xC5A1, 0xCC07, 0xD04D, 0xD6DC, 0xDADD, 0xDA21, 0xE11F, 0xDEEE, 0xE5AF, 0xE66F, 0xE81F, 0xE8F9, 0xEB83, 0xEDE8,
    0xEBE2, 0xE813, 0xE3FB, 0xE18F, 0xDDA3, 0xDC87, 0xD8C9, 0xDA48, 0xD849, 0xDAE4, 0xDEBA, 0xDDD6, 0xDC38, 0xDCEC, 0xE00C, 0xDD17,
    0xDA7C, 0xD79B, 0xDA7E, 0xD8DA, 0xDA0C, 0xD845, 0xDB7B, 0xDDB5, 0xDBD7, 0xE2F3, 0xE166, 0xE76E, 0xE90B, 0xF057, 0xF525, 0xF6A5,
    0xF850, 0xF9A5, 0xFDDB, 0xF8E7, 0xFC76, 0xF870, 0xFA5F, 0xF9AD, 0xF457, 0xF55C, 0xF4A8, 0xF765, 0xF6D3, 0x015B, 0x0772, 0x0DCD,
    0x16BA, 0x18DE, 0x1E3B, 0x1F00, 0x2313, 0x2545, 0x2748, 0x276B, 0x2975, 0x2B83, 0x2749, 0x2815, 0x21CA, 0x21DD, 0x2279, 0x1D6B,
    0x1E67, 0x1F10, 0x2179, 0x1E8B, 0x22DB, 0x2129, 0x1FB1, 0x1F0C, 0x1B2B, 0x1D79, 0x16A5, 0x1918, 0x184F, 0x1AB4, 0x1CBE, 0x1F49,
    0x2386, 0x22F0, 0x2866, 0x2867, 0x2CDA, 0x2EAA, 0x3057, 0x33C4, 0x3708, 0x393A, 0x3A02, 0x3F99, 0x4021, 0x40F1, 0x4253, 0x4608,
    0x4685, 0x44C3, 0x48D5, 0x48C2, 0x48D9, 0x4A44, 0x4C3E, 0x5008, 0x51B4, 0x5452, 0x54F0, 0x53F4, 0x5547, 0x5111, 0x5114, 0x4FF2,
    0x517B, 0x510A, 0x4FD8, 0x52E5, 0x4F97, 0x4D8B, 0x48A9, 0x49B3, 0x424A, 0x4100, 0x3E1E, 0x3CB1, 0x3F12, 0x3878, 0x3A74, 0x36F6,
    0x3B0B, 0x363E, 0x3620, 0x37BE, 0x3495, 0x37F8, 0x3526, 0x35D5, 0x3022, 0x30F6, 0x2C3E, 0x2B77, 0x2592, 0x1E13, 0x232E, 0x205C,
    0x252E, 0x242D, 0x26DB, 0x269E, 0x28E0, 0x2A17, 0x25DD, 0x25D7, 0x207A, 0x2151, 0x2052, 0x1C84, 0x19CE, 0x19DD, 0x1AF0, 0x1DF7,
    0x1E6E, 0x1EE3, 0x27CE, 0x2A31, 0x2B2F, 0x31DE, 0x3223, 0x341A, 0x363C, 0x3734, 0x3806, 0x34A8, 0x31D5, 0x2F97, 0x2CD5, 0x2499,
    0x1BAF, 0x14C2, 0x0DD8, 0x0B2A, 0x058B, 0x0458, 0x04A8, 0x05D1, 0x0784, 0x064D, 0x058B, 0x01CB, 0x039D, 0xFFDE, 0xFE90, 0xFD10,
    0xFC24, 0xFC9F, 0xF99D, 0xF8F4, 0xF78C, 0xF714, 0xF618, 0xF7E3, 0xF7A1, 0xF82A, 0xF903, 0xF626, 0xF7C6, 0xF621, 0xF0A8, 0xED86,
    0xE95A, 0xE68A, 0xDE1E, 0xDB67, 0xD9E5, 0xD64E, 0xD30E, 0xD0C0, 0xD350, 0xD142, 0xD42C, 0xD482, 0xD5CB, 0xD88D, 0xD9E6, 0xDAA0,
    0xD9E6, 0xDD58, 0xDA6A, 0xDECE, 0xDE69, 0xDC96, 0xDD04, 0xDB3E, 0xDD29, 0xD809, 0xD69D, 0xD0E6, 0xD046, 0xCD84, 0xCA1F, 0xC7B5,
    0xC23C, 0xC210, 0xBF98, 0xBC00, 0xB3E0, 0xB2AD, 0xAFF6, 0xADD5, 0xAE13, 0xA938, 0xAD9E, 0xAE42, 0xAEAA, 0xAE14, 0xAFD7, 0xB242,
    0xB1E2, 0xB74C, 0xB822, 0xBCE6, 0xBD41, 0xBE7F, 0xC128, 0xC30E, 0xC2A9, 0xC397, 0xC5E0, 0xC4E3, 0xC911, 0xC58C, 0xC586, 0xC749,
    0xC531, 0xC63A, 0xC53E, 0xC6DC, 0xC856, 0xC90F, 0xCC41, 0xCF41, 0xD24F, 0xD419, 0xD968, 0xDC4D, 0xDCE3, 0xDE3C, 0xDFB3, 0xDEEB,
    0xDE28, 0xDE7C, 0xDA3C, 0xD7C5, 0xD3A9, 0xD0EE, 0xCEA3, 0xC94D, 0xC958, 0xC918, 0xC980, 0xC8C2, 0xC767, 0xC992, 0xCA9D, 0xC8D6,
    0xCA00, 0xCCAD, 0xC9F9, 0xCBC0, 0xCD33, 0xCD1E, 0xCA61, 0xC716, 0xC6DC, 0xC7F3, 0xC6DE, 0xC4B3, 0xC7DB, 0xCAFF, 0xCF00, 0xD0C1,
    0xD239, 0xD5B1, 0xDB0B, 0xDBF0, 0xDBC3, 0xDF77, 0xDEE4, 0xDEAC, 0xDE6A, 0xDE96, 0xDC9E, 0xDCAD, 0xDDC3, 0xE1B5, 0xE4F0, 0xE531,
    0xEBDC, 0xEE15, 0xF465, 0xF6BA, 0xF906, 0xFB29, 0xFC6E, 0xFE39, 0xFCF9, 0xFD50, 0xF94F, 0xFAA3, 0xFA65, 0xF7D8, 0xF309, 0xF3AF,
    0xF213, 0xEE6C, 0xEF08, 0xED82, 0xF0D2, 0xF025, 0xEF23, 0xF0F5, 0xEF5F, 0xEEE0, 0xEE50, 0xEDEA, 0xEE4B, 0xEFF6, 0xF122, 0xF27F,
    0xF63C, 0xF73A, 0xF9F9, 0x0015, 0x0461, 0x07D0, 0x0DAF, 0x10E0, 0x1416, 0x18D0, 0x16B1, 0x1728, 0x1730, 0x1581, 0x1610, 0x10E7,
    0x10F9, 0x0F44, 0x0FF6, 0x0E69, 0x0D35, 0x1064, 0x1124, 0x1718, 0x195F, 0x1E5A, 0x21B4, 0x2598, 0x2831, 0x2D41, 0x2E10, 0x2DAA,
    0x3190, 0x3136, 0x36FE, 0x33CE, 0x3197, 0x3345, 0x3341, 0x31D9, 0x2A4E, 0x27C8, 0x2623, 0x231B, 0x1CE7, 0x1A6F, 0x18E2, 0x17F6,
    0x17CD, 0x165C, 0x1967, 0x16CF, 0x13B3, 0x14B0, 0x16D8, 0x14E7, 0x1082, 0x1297, 0x127C, 0x1333, 0x13FC, 0x1083, 0x14D7, 0x17F7,
    0x19D2, 0x1BBD, 0x1F86, 0x215C, 0x252D, 0x2893, 0x287D, 0x2ED6, 0x307F, 0x3485, 0x388F, 0x3A06, 0x3A27, 0x3BC9, 0x3B6B, 0x3AA9,
    0x3D01, 0x3BB4, 0x3E3D, 0x3F9C, 0x4244, 0x4436, 0x46AE, 0x481D, 0x4A3B, 0x50CB, 0x4F59, 0x53A4, 0x556E, 0x5639, 0x56D8, 0x54FC,
    0x53E0, 0x527F, 0x4E5B, 0x49FC, 0x4C8F, 0x4752, 0x468F, 0x43A6, 0x45BC, 0x44B0, 0x4165, 0x4208, 0x3F05, 0x3F82, 0x3A63, 0x3833,
    0x34D1, 0x32D3, 0x2EA4, 0x2D15, 0x2A20, 0x28C4, 0x2A7E, 0x27F6, 0x2AB1, 0x2730, 0x2895, 0x292B, 0x2995, 0x2B51, 0x2A01, 0x2C24,
    0x2A74, 0x2B23, 0x2A44, 0x2ACB, 0x29BF, 0x28A3, 0x28E4, 0x2903, 0x2895, 0x2885, 0x2D6E, 0x3243, 0x374D, 0x38E8, 0x3E6B, 0x427E,
    0x422F, 0x43EC, 0x42F7, 0x417F, 0x4181, 0x3E39, 0x3AE9, 0x37D8, 0x340C, 0x2ED5, 0x294F, 0x2497, 0x1EE5, 0x1BF0, 0x1909, 0x1584,
    0x133C, 0x12E8, 0x1204, 0x119D, 0x103F, 0x0F7E, 0x0F43, 0x0AE4, 0x0D5A, 0x0C3E, 0x08A0, 0x09A0, 0x0A0E, 0x0B6D, 0x0D36, 0x0C98,
    0x0C2F, 0x11F6, 0x112B, 0x0EE7, 0x0DE6, 0x0E73, 0x0FFB, 0x1172, 0x0F7E, 0x1140, 0x152B, 0x1216, 0x13E7, 0x1382, 0x125B, 0x0ED6,
    0x0F3F, 0x0DFC, 0x0D2D, 0x0B2C, 0x0780, 0x0D37, 0x0F47, 0x0E4A, 0x0D55, 0x1098, 0x12E3, 0x1436, 0x10BD, 0x11D3, 0x1557, 0x1475,
    0x1803, 0x1742, 0x193D, 0x16C8, 0x1470, 0x12E9, 0x0D89, 0x0970, 0x0229, 0xFDAF, 0xFAE0, 0xF589, 0xEDA8, 0xE9F9, 0xE788, 0xE756,
    0xE311, 0xDF84, 0xDF82, 0xDF46, 0xE109, 0xDE3D, 0xDD98, 0xDEEC, 0xDF61, 0xDF3A, 0xDFE8, 0xDEB0, 0xE16E, 0xDFD5, 0xDF5F, 0xE230,
    0xE1FF, 0xE2EC, 0xE24B, 0xE5F8, 0xE529, 0xE56E, 0xE11D, 0xDF0B, 0xDE2A, 0xD900, 0xD579, 0xD39A, 0xD6DC, 0xD402, 0xD768, 0xD7FD,
    0xDAE0, 0xDC1E, 0xDA6D, 0xDDD0, 0xDD9E, 0xDFCE, 0xDDFA, 0xE1E0, 0xE047, 0xDFFB, 0xE17C, 0xDDA2, 0xDC6C, 0xD916, 0xD6CF, 0xD2F4,
    0xD1C1, 0xCD63, 0xCD36, 0xCE7A, 0xCCAC, 0xD148, 0xD237, 0xD349, 0xD252, 0xD3B6, 0xD458, 0xD0AD, 0xCEF1, 0xCC5D, 0xCC8A, 0xC709,
    0xC46E, 0xC41D, 0xC167, 0xC288, 0xC021, 0xC0C4, 0xC23F, 0xC2DD, 0xC21D, 0xC385, 0xC737, 0xC5B8, 0xC7D0, 0xC788, 0xC97B, 0xC96B,
    0xC720, 0xC546, 0xC3EF, 0xC3CA, 0xC030, 0xC21D, 0xC092, 0xC617, 0xC685, 0xC730, 0xCA08, 0xC86D, 0xC9F8, 0xC846, 0xCAC7, 0xC925,
    0xCB08, 0xCC92, 0xCDF4, 0xCDEB, 0xCE3B, 0xCDD9, 0xCBB5, 0xCA8F, 0xC828, 0xC709, 0xC0B1, 0xC029, 0xBF20, 0xBC77, 0xB9DA, 0xB81F,
    0xB91A, 0xB8D1, 0xB5D5, 0xB415, 0xB327, 0xB231, 0xB51B, 0xB2C1, 0xB49A, 0xB671, 0xB7DA, 0xBB74, 0xBD4C, 0xC099, 0xC142, 0xC510,
    0xC678, 0xC948, 0xC921, 0xC846, 0xC9AD, 0xCB36, 0xCC6A, 0xC979, 0xCC88, 0xCCBD, 0xD087, 0xCF5C, 0xCD64, 0xD05B, 0xD0F5, 0xD433,
    0xD660, 0xDAF8, 0xDA4A, 0xDFED, 0xE431, 0xE3EF, 0xE758, 0xE8CD, 0xECB6, 0xEF8A, 0xF30B, 0xF3E2, 0xF4C2, 0xF536, 0xF34D, 0xF362,
    0xEC33, 0xE77A, 0xE5FA, 0xE259, 0xDF51, 0xDB5D, 0xDAF1, 0xD8DC, 0xDB68, 0xD6F9, 0xD5C1, 0xD90B, 0xD521, 0xD5B2, 0xD32F, 0xD59E,
    0xD280, 0xD1A4, 0xD235, 0xD1C0, 0xD382, 0xD188, 0xD47C, 0xD476, 0xD6CE, 0xD7EC, 0xDA92, 0xDE08, 0xE2A8, 0xE7F7, 0xEC57, 0xF3C9,
    0xF601, 0xFC6F, 0xFECB, 0xFFD6, 0x00E4, 0xFEA4, 0xFF04, 0xF8E3, 0xF7EC, 0xF93C, 0xF9B9, 0xFAC2, 0xFBEB, 0x0059, 0x025E, 0x05E7,
    0x069B, 0x08F0, 0x100D, 0x1287, 0x168F, 0x1A7A, 0x1C74, 0x1E02, 0x1E42, 0x1EBB, 0x1D52, 0x1D28, 0x1959, 0x1D68, 0x1D5F, 0x19DF,
    0x1ABB, 0x1891, 0x1B80, 0x1889, 0x1988, 0x163A, 0x15FB, 0x1580, 0x13B0, 0x156E, 0x12E9, 0x1464, 0x13D2, 0x182B, 0x17BC, 0x1BEC,
    0x1CC1, 0x1EB3, 0x243D, 0x2402, 0x2870, 0x2635, 0x2B0A, 0x2E4D, 0x2F27, 0x2F24, 0x2F03, 0x338C, 0x31E2, 0x3229, 0x3070, 0x301D,
    0x31C4, 0x30F0, 0x32AF, 0x348E, 0x39A9, 0x3D5A, 0x4025, 0x445A, 0x474E, 0x4962, 0x471B, 0x4820, 0x4AB5, 0x490B, 0x46CD, 0x479D,
    0x4852, 0x4755, 0x45A6, 0x40B1, 0x4050, 0x3F2E, 0x3C13, 0x3AEB, 0x38A1, 0x3A25, 0x3787, 0x3591, 0x3290, 0x3086, 0x2F9D, 0x2CA9,
    0x2EB4, 0x2CA8, 0x2C1B, 0x2A15, 0x2A87, 0x291C, 0x2652, 0x238A, 0x210D, 0x22C9, 0x2062, 0x203B, 0x1F25, 0x2129, 0x22E0, 0x2287,
    0x2589, 0x26EB, 0x289B, 0x2D8B, 0x2C22, 0x2D0D, 0x2DB7, 0x2C32, 0x29EA, 0x2734, 0x28C5, 0x25C4, 0x24F0, 0x2532, 0x2ACB, 0x2AAD,
    0x29FE, 0x2EDA, 0x33D0, 0x3777, 0x38FD, 0x3FEF, 0x43F6, 0x4D4D, 0x4DEE, 0x508A, 0x567A, 0x5632, 0x5771, 0x5276, 0x53F5, 0x4E7A,
    0x4C82, 0x4797, 0x42CB, 0x42A1, 0x3B27, 0x3AE7, 0x363D, 0x3553, 0x301D, 0x2F7F, 0x2DC7, 0x2C6B, 0x2D74, 0x27B2, 0x2918, 0x23F8,
    0x23CC, 0x200D, 0x204D, 0x2140, 0x21D4, 0x273D, 0x24AA, 0x27A6, 0x292F, 0x2C60, 0x2B8A, 0x2BB5, 0x2E1E, 0x2E62, 0x305B, 0x2CE9,
    0x2D0A, 0x2AFB, 0x286C, 0x2859, 0x2667, 0x24FE, 0x22B5, 0x2515, 0x264F, 0x2755, 0x27A0, 0x2940, 0x2D5B, 0x2D91, 0x2F72, 0x2D7E,
    0x2F5D, 0x2FFD, 0x2F5C, 0x2F6A, 0x2DA4, 0x2C63, 0x29F4, 0x29D6, 0x2781, 0x24BE, 0x22E1, 0x23B6, 0x2400, 0x23F7, 0x2295, 0x234F,
    0x22B1, 0x21C2, 0x21F0, 0x1E99, 0x1BCE, 0x1972, 0x17BC, 0x14A2, 0x1107, 0x0ADB, 0x0A41, 0x0853, 0x06BB, 0x07D2, 0x05EB, 0x0A46,
    0x0B52, 0x0DBD, 0x0DF7, 0x0E38, 0x106B, 0x1070, 0x1302, 0x127C, 0x1715, 0x16A0, 0x1744, 0x1776, 0x1658, 0x12F8, 0x0D7E, 0x0EA1,
    0x0A32, 0x0B94, 0x061D, 0x071A, 0x06DE, 0x0467, 0x0670, 0x036A, 0x0629, 0x055A, 0x08E5, 0x061F, 0x086C, 0x0839, 0x065B, 0x057B,
    0xFFC2, 0xFE12, 0xF8F8, 0xF552, 0xEE4E, 0xED37, 0xE7E5, 0xE2D4, 0xE0B8, 0xDD4E, 0xDB2D, 0xD681, 0xD5D3, 0xD63A, 0xD88E, 0xD8D9,
    0xD773, 0xD889, 0xD9AA, 0xD793, 0xD675, 0xD5B4, 0xD630, 0xD5DE, 0xD3C5, 0xD441, 0xD437, 0xD2FE, 0xCED4, 0xCFD1, 0xCF1F, 0xCCC2,
    0xCD97, 0xCE14, 0xD111, 0xD008, 0xCEAA, 0xCCC8, 0xCE3E, 0xC989, 0xC750, 0xC82B, 0xC834, 0xCBA5, 0xCB22, 0xD1A5, 0xD0E6, 0xD623,
    0xD7DF, 0xD964, 0xDCCC, 0xDB56, 0xE094, 0xDD96, 0xDF1E, 0xDC4C, 0xDC91, 0xDBDA, 0xD779, 0xD780, 0xD203, 0xD083, 0xCCAC, 0xCB9D,
    0xC8D4, 0xC6DA, 0xC6D3, 0xC664, 0xC93E, 0xC4A5, 0xC468, 0xC3D5, 0xC386, 0xC201, 0xBFA2, 0xBD31, 0xBAA4, 0xBA55, 0xB514, 0xB5D6,
    0xB3C3, 0xB501, 0xB66D, 0xB855, 0xB9EC, 0xB973, 0xBF47, 0xBE5E, 0xC20E, 0xC123, 0xC232, 0xC5F6, 0xC41E, 0xC60E, 0xC31E, 0xC0DA,
    0xBBDD, 0xBA65, 0xB8A3, 0xB469, 0xB495, 0xB5E5, 0xB959, 0xBA5F, 0xBD04, 0xBC42, 0xBF8E, 0xC2DD, 0xC2D3, 0xC51F, 0xC688, 0xCA4E,
    0xCBF4, 0xCDED, 0xCDA5, 0xCDA1, 0xCC5F, 0xCBAD, 0xCA62, 0xC803, 0xC2AE, 0xBF57, 0xBDDA, 0xB96C, 0xB80E, 0xB357, 0xB507, 0xB2CE,
    0xB386, 0xB215, 0xB0B5, 0xB334, 0xB07E, 0xB317, 0xB0FA, 0xB416, 0xB341, 0xB3D0, 0xB682, 0xB6F8, 0xB9D7, 0xB961, 0xBBEE, 0xBDED,
    0xBFE6, 0xBE9C, 0xBFE0, 0xC2C5, 0xC5F3, 0xC8A3, 0xCB09, 0xCFBD, 0xD201, 0xD547, 0xD4E7, 0xD7B9, 0xD90B, 0xDB35, 0xDE31, 0xDF92,
    0xE57F, 0xE728, 0xEA62, 0xE88C, 0xEAA5, 0xECC7, 0xEB21, 0xEC89, 0xEC6C, 0xF0F0, 0xF0E4, 0xF189, 0xF158, 0xEF2C, 0xEE6C, 0xE8C4,
    0xE738, 0xE67B, 0xE2A7, 0xE1AC, 0xE11B, 0xE254, 0xE1BD, 0xE01C, 0xE182, 0xE27D, 0xE22A, 0xE0E9, 0xE15E, 0xE123, 0xDDCE, 0xDCDF,
    0xDC6B, 0xDAF0, 0xDB5E, 0xD9B6, 0xDC0B, 0xDE21, 0xDE3B, 0xDEF6, 0xE0BB, 0xE4BE, 0xE564, 0xE89B, 0xE93A, 0xED5C, 0xF04A, 0xF207,
    0xF567, 0xF479, 0xF6BC, 0xF482, 0xF47C, 0xF209, 0xEF5E, 0xF123, 0xF11B, 0xF439, 0xF941, 0xFD63, 0x023A, 0x0779, 0x0D54, 0x1290,
    0x14B5, 0x1B71, 0x2127, 0x276E, 0x29C5, 0x2A9E, 0x2F06, 0x2C21, 0x2B9E, 0x284F, 0x24D9, 0x229B, 0x1F21, 0x20CF, 0x1ED4, 0x1F01,
    0x1BBE, 0x1BD6, 0x1DF1, 0x1974, 0x19C0, 0x1843, 0x1B81, 0x1D26, 0x1A75, 0x1C36, 0x1C8C, 0x1FAC, 0x2065, 0x210B, 0x25B8, 0x255F,
    0x2850, 0x2903, 0x2976, 0x2A2B, 0x2701, 0x2B4F, 0x2D55, 0x2E27, 0x2EAE, 0x2F00, 0x3307, 0x3125, 0x2EC0, 0x2D76, 0x2B24, 0x2E33,
    0x2B61, 0x2C68, 0x2E28, 0x2F0F, 0x3429, 0x3225, 0x362F, 0x34F6, 0x369D, 0x37AF, 0x3625, 0x3B4B, 0x38CA, 0x3D6A, 0x3FFE, 0x4150,
    0x43F2, 0x400E, 0x4206, 0x4115, 0x3FA4, 0x3F46, 0x3CE8, 0x3F9B, 0x3D62, 0x3BB6, 0x3B4B, 0x362D, 0x3514, 0x2FDD, 0x2DF0, 0x2CFF,
    0x2908, 0x29FD, 0x25B6, 0x260C, 0x24A0, 0x2247, 0x229D, 0x1FF3, 0x226F, 0x204B, 0x21FB, 0x23C9, 0x2450, 0x28FA, 0x28EF, 0x2D42,
    0x31E9, 0x3457, 0x36A8, 0x36E7, 0x3C16, 0x39EA, 0x36DE, 0x375F, 0x3333, 0x35CF, 0x31DD, 0x32D0, 0x35A8, 0x34AE, 0x3890, 0x37BD,
    0x3CE6, 0x3CED, 0x3E05, 0x442A, 0x448E, 0x4A35, 0x4AEB, 0x4B77, 0x4F24, 0x4CAA, 0x4E48, 0x4B12, 0x479D, 0x43FB, 0x3EFC, 0x3E75,
    0x383D, 0x36A8, 0x3507, 0x34F3, 0x3532, 0x30E1, 0x308F, 0x2EAA, 0x2D7F, 0x2DA0, 0x2CC2, 0x2BB4, 0x2A6E, 0x2A32, 0x279D, 0x22D0,
    0x2114, 0x1D55, 0x1BCB, 0x1C98, 0x1939, 0x1A77, 0x1947, 0x1A5D, 0x197C, 0x192D, 0x1CB5, 0x1917, 0x1CEB, 0x1B45, 0x1E05, 0x1C34,
    0x1708, 0x194D, 0x16D4, 0x1823, 0x135A, 0x1711, 0x186F, 0x19A7, 0x1AC7, 0x1950, 0x1B87, 0x189E, 0x19D6, 0x196E, 0x1A41, 0x196C,
    0x1BF6, 0x1DF4, 0x1BDC, 0x19BE, 0x17FD, 0x1716, 0x1389, 0x1234, 0x0E29, 0x0E83, 0x0DA9, 0x0AD4, 0x0CE0, 0x09E3, 0x09BD, 0x0733,
    0x0602, 0x049C, 0x01F7, 0x0159, 0xFD19, 0xFF48, 0xFEA0, 0xFDB5, 0xFD2C, 0xFEA9, 0xFFF4, 0x00AC, 0x02DD, 0x037C, 0x097A, 0x0B25,
    0x0E2B, 0x0F0E, 0x0F9C, 0x1252, 0x1150, 0x12F6, 0x11EF, 0x11A6, 0x1108, 0x0E88, 0x0CB0, 0x085D, 0x05BE, 0x0468, 0x0147, 0x006A,
    0xFEB9, 0xFE63, 0x0036, 0xFDD9, 0xFFBC, 0x004E, 0x02B7, 0x0495, 0x05A3, 0x0A27, 0x0976, 0x0D20, 0x0B72, 0x0B89, 0x08D3, 0x045F,
    0xFFF7, 0xF9F0, 0xF830, 0xF26D, 0xF00B, 0xEAB1, 0xE99C, 0xE65B, 0xE2B4, 0xDE89, 0xDC9E, 0xDC59, 0xD8FD, 0xD7E0, 0xD568, 0xD958,
    0xD55E, 0xD4E1, 0xD20B, 0xD205, 0xD20D, 0xCD19, 0xD010, 0xCB38, 0xCFA5, 0xCD87, 0xCE94, 0xD1FC, 0xCFA5, 0xD5D6, 0xD58F, 0xDCBF,
    0xDBF7, 0xDE86, 0xE469, 0xE418, 0xE63B, 0xE218, 0xE33F, 0xE299, 0xE238, 0xE17F, 0xE2AE, 0xE4D7, 0xE570, 0xE5B5, 0xE856, 0xE9B3,
    0xE832, 0xEB33, 0xEC2E, 0xF273, 0xF090, 0xF073, 0xF333, 0xF048, 0xF2FF, 0xEF7B, 0xEEA7, 0xEC9A, 0xEC59, 0xEEB6, 0xE9F6, 0xEB57,
    0xE81E, 0xE817, 0xE769, 0xE157, 0xE0AD, 0xDD11, 0xDB49, 0xD70F, 0xD5CB, 0xD308, 0xCF0C, 0xCDFE, 0xC9CF, 0xCAAA, 0xC7E5, 0xC5B6,
    0xC78C, 0xC877, 0xCAE6, 0xC9B1, 0xCB50, 0xCD88, 0xCCE0, 0xD004, 0xCEF2, 0xD010, 0xD08C, 0xCF17, 0xD1BE, 0xCE95, 0xCDB5, 0xCC58,
    0xCC09, 0xCD47, 0xCB22, 0xCD77, 0xD0C4, 0xD2A0, 0xD705, 0xD829, 0xDB78, 0xDE92, 0xDEF5, 0xE38E, 0xE1AB, 0xE545, 0xE5DF, 0xE77D,
    0xE768, 0xE57E, 0xE838, 0xE1EA, 0xE159, 0xDE67, 0xDB55, 0xD90D, 0xD689, 0xD482, 0xD217, 0xD268, 0xCF56, 0xCE97, 0xCD70, 0xCDD3,
    0xCEEF, 0xCE6C, 0xCEAC, 0xCF7F, 0xCFB8, 0xCE51, 0xCED7, 0xCEB7, 0xCF59, 0xCE08, 0xCEF7, 0xCF11, 0xD040, 0xD0DD, 0xD169, 0xD41A,
    0xD3D1, 0xD86A, 0xD983, 0xDD94, 0xDFCE, 0xE2C4, 0xE669, 0xE7AC, 0xE96E, 0xE7EA, 0xEA8E, 0xEAE3, 0xEA97, 0xEA5B, 0xED14, 0xEE70,
    0xF0B1, 0xF0ED, 0xF05C, 0xF379, 0xF223, 0xF6A7, 0xF6E2, 0xFB8F, 0xFD8C, 0x0015, 0x05A1, 0x0397, 0x06EE, 0x00CE, 0x028E, 0xFF6B,
    0xFAAB, 0xFA34, 0xF5B7, 0xF672, 0xF0D4, 0xF057, 0xEC75, 0xEC61, 0xE87F, 0xE68E, 0xE809, 0xE241, 0xE0C7, 0xDCB5, 0xDE36, 0xD9D8,
    0xD818, 0xD8EB, 0xD9F2, 0xDDD6, 0xDCD4, 0xE004, 0xE063, 0xE330, 0xE3A0, 0xE5AA, 0xE67F, 0xE659, 0xEAB3, 0xE936, 0xEB80, 0xE6D1,
    0xE807, 0xE788, 0xE403, 0xE54B, 0xDE40, 0xE3CC, 0xE078, 0xE3A9, 0xE767, 0xE8C7, 0xEF4D, 0xEF50, 0xF948, 0xF8E0, 0xFD6D, 0xFF67,
    0x035C, 0x0869, 0x08CE, 0x0CF8, 0x0D7D, 0x0FB3, 0x0D23, 0x0F22, 0x0BBB, 0x0B61, 0x0AB9, 0x0A3B, 0x0DBE, 0x0C24, 0x0F48, 0x0D80,
    0x118F, 0x105B, 0x101D, 0x111B, 0x0D07, 0x0F9E, 0x0BE3, 0x0BC4, 0x0906, 0x0954, 0x08D2, 0x0740, 0x09A1, 0x06FC, 0x084F, 0x079B,
    0x068C, 0x05BC, 0x058B, 0x0743, 0x0931, 0x0C25, 0x0F34, 0x125C, 0x128B, 0x1111, 0x13E3, 0x135A, 0x10F9, 0x1003, 0x0D91, 0x0E69,
    0x0C09, 0x0AE4, 0x0C39, 0x0D3B, 0x0CBC, 0x0CA5, 0x0F09, 0x0F45, 0x0EE1, 0x0EDA, 0x1026, 0x118E, 0x155D, 0x15E1, 0x1876, 0x19EF,
    0x18E8, 0x1832, 0x1451, 0x13D3, 0x0F05, 0x0D65, 0x0D26, 0x0AC5, 0x09EE, 0x064D, 0x05B5, 0x046B, 0x0211, 0x0064, 0xFE19, 0x0088,
    0x00E6, 0x00C0, 0x02B1, 0x02C5, 0x0558, 0x0755, 0x08EC, 0x0BB5, 0x0CFB, 0x0E8E, 0x119E, 0x13AB, 0x1491, 0x167D, 0x1952, 0x1BA1,
    0x1D7C, 0x2036, 0x20B5, 0x1DFF, 0x1C5C, 0x1AA1, 0x181A, 0x13F4, 0x13BC, 0x157F, 0x180E, 0x1970, 0x1A92, 0x1F82, 0x23C7, 0x2640,
    0x27B0, 0x2CA4, 0x2FDD, 0x3226, 0x3479, 0x358B, 0x3736, 0x3745, 0x3514, 0x354A, 0x3189, 0x2CC9, 0x27AD, 0x23E9, 0x208A, 0x1A9C,
    0x1B10, 0x1674, 0x1811, 0x15D7, 0x1322, 0x11D6, 0x0D54, 0x0D75, 0x086A, 0x0675, 0x00E3, 0x01E0, 0xFED8, 0xFAB1, 0xF9D8, 0xF7E6,
    0xF83D, 0xF600, 0xF8B8, 0xF741, 0xFCD3, 0xFBB0, 0x0003, 0x0575, 0x06B7, 0x0D03, 0x0ACC, 0x1346, 0x11CC, 0x1292, 0x1074, 0x0F5E,
    0x122D, 0x0B06, 0x0D84, 0x0ACD, 0x0F6F, 0x0F98, 0x0F94, 0x1110, 0x1064, 0x1223, 0x100C, 0x1511, 0x1409, 0x17C6, 0x19BD, 0x1E11,
    0x2134, 0x2124, 0x235C, 0x2114, 0x23BE, 0x205B, 0x202D, 0x1CAE, 0x1A71, 0x1936, 0x14A2, 0x14DE, 0x0FC6, 0x106A, 0x0D58, 0x09B5,
    0x06FC, 0x0371, 0x02FD, 0xFC62, 0xFDF1, 0xFC52, 0xFE40, 0xFF0A, 0xFC96, 0x011E, 0x00E4, 0x02FA, 0x0168, 0x0362, 0x0578, 0x05DD,
    0x07FC, 0x096D, 0x0C5D, 0x0CE9, 0x0D67, 0x0F0E, 0x1090, 0x0E98, 0x0DE9, 0x0C17, 0x0DD1, 0x0F39, 0x0C75, 0x0F1A, 0x102B, 0x13A2,
    0x141A, 0x14A3, 0x1764, 0x1758, 0x19E9, 0x19F3, 0x1E61, 0x20D1, 0x208D, 0x24CB, 0x2554, 0x2418, 0x2115, 0x1C80, 0x18D9, 0x1404,
    0x10C4, 0x0C61, 0x0991, 0x075C, 0x03E0, 0x047A, 0x0221, 0xFF81, 0xFEBB, 0xFE38, 0xFD78, 0xFA00, 0xF63F, 0xF406, 0xF29C, 0xEF46,
    0xECEE, 0xEAD3, 0xE7D6, 0xE5FF, 0xE418, 0xE241, 0xDF6E, 0xDFCB, 0xE182, 0xE404, 0xE5DB, 0xE96D, 0xED6A, 0xF0D4, 0xF4A6, 0xF4B1,
    0xF71E, 0xF560, 0xF788, 0xFBCB, 0xFA86, 0xF9B6, 0xF8FB, 0xF9CB, 0xF97B, 0xF8DD, 0xFBA6, 0xFAB5, 0xFEE4, 0x0291, 0x0500, 0x0BE6,
    0x0C18, 0x13EF, 0x15DD, 0x1ABB, 0x1549, 0x094A, 0x118C, 0x1898, 0x1D59, 0x1665, 0x1829, 0x1C95, 0x1DDA, 0x1D28, 0x14CA, 0x128A,
    0x0FF0, 0x0E04, 0x0728, 0x04FD, 0x0275, 0x016D, 0xFFA3, 0xFA8D, 0xF78F, 0xF2B8, 0xEF4B, 0xECCC, 0xEF44, 0xF0D8, 0xFF9E, 0x052D,
    0x0008, 0xFFE6, 0xFB88, 0xFD1F, 0xFB64, 0xFE17, 0xFD12, 0xF809, 0xFA34, 0xF9AC, 0xF7C8, 0xEFCB, 0xEC5C, 0xE7EB, 0xE787, 0xECD3,
    0xECA3, 0xED81, 0xEC81, 0xF13D, 0xF406, 0xF212, 0xEFBC, 0xED0D, 0xEDA9, 0xF08B, 0xF08A, 0xEB0B, 0xE649, 0xE1BF, 0xEA5F, 0xF3D5,
    0xF5C8, 0xF55D, 0xF357, 0xF80B, 0xF991, 0xFEC4, 0xF624, 0xF0AE, 0xF52B, 0xF54D, 0xF610, 0xEFBE, 0xF237, 0xF375, 0xF8D3, 0xFFE8,
    0xFD5E, 0xF910, 0xF689, 0xFA8C, 0xFB92, 0xF75A, 0xF5A3, 0xF39E, 0xEF9D, 0xF92E, 0x0424, 0x01CC, 0x001A, 0x0247, 0x0525, 0x0384,
    0x0588, 0x069B, 0x0718, 0x0DA7, 0x16B2, 0x1A46, 0x1213, 0x0EEA, 0x0D48, 0x0B9F, 0x072E, 0x03D3, 0x0253, 0xFCE5, 0x0232, 0x0AF4,
    0x08C6, 0x01BC, 0xFCBE, 0xFA92, 0xF8BC, 0xF619, 0xF32A, 0xEF67, 0xF4AB, 0xFA60, 0xF5DD, 0xEE8B, 0xE86E, 0xE48D, 0xDDC1, 0xD96E,
    0xDAA5, 0xDB81, 0xE0BB, 0xE7D9, 0xEC66, 0xED2F, 0xEB23, 0xE9D1, 0xE7DC, 0xE921, 0xEC19, 0xEEBA, 0xEE69, 0xF02D, 0xF6E1, 0xF4C8,
    0xF012, 0xED97, 0xECDE, 0xF132, 0xF3DE, 0xF3C8, 0xF5DE, 0xFCD6, 0x01A5, 0x025C, 0x0277, 0x0065, 0xFE6B, 0xFE19, 0xFA98, 0xFAAD,
    0xFB5E, 0xFAF8, 0x0173, 0x005E, 0xFD0E, 0xFDC8, 0xFF76, 0xFE7F, 0xFA75, 0xFDDC, 0x0133, 0x047F, 0x04BD, 0x04CC, 0x07D2, 0x053B,
    0xFDDC, 0xF9C4, 0xF914, 0xF6EF, 0xF65E, 0xF504, 0xF6C5, 0xF96F, 0xF8B2, 0xF66B, 0xF608, 0xF4F0, 0xF47A, 0xF714, 0xFA81, 0xFCDD,
    0xFDB3, 0x0012, 0x0100, 0x02E7, 0xFF54, 0xFC43, 0xFD9C, 0xFE48, 0xFFDF, 0xFD20, 0xFE1F, 0x00AC, 0x038C, 0x04C1, 0x02B8, 0x049F,
    0x0640, 0x070B, 0x0805, 0x0A31, 0x0A90, 0x0C04, 0x0E99, 0x1245, 0x1481, 0x12CD, 0x1145, 0x103D, 0x1184, 0x0CA9, 0x073E, 0x02EF,
    0x003D, 0xFFC2, 0xFC6A, 0xFB27, 0xF9A7, 0xFA64, 0xF78F, 0xF660, 0xF4F6, 0xF3DC, 0xF5FB, 0xF57F, 0xF8A9, 0xF91E, 0xFA00, 0xFA5F,
    0xF9A2, 0xF816, 0xF3D3, 0xF180, 0xEEFA, 0xEE49, 0xECEC, 0xEC37, 0xEB01, 0xE99A, 0xEC74, 0xEB53, 0xEC51, 0xEC74, 0xEEDC, 0xF2CA,
    0xF209, 0xF50E, 0xF601, 0xF910, 0xF8E4, 0xF6E3, 0xF699, 0xF759, 0xF80C, 0xF648, 0xF551, 0xF847, 0xFC81, 0xFDA8, 0x0006, 0x029F,
    0x065F, 0x08A7, 0x0B3B, 0x0D04, 0x0D39, 0x0E0A, 0x0ED0, 0x118E, 0x10C3, 0x1079, 0x1113, 0x110B, 0x10A4, 0x0EDE, 0x108C, 0x0FE4,
    0x0F27, 0x0E13, 0x0B93, 0x0CC9, 0x07F7, 0x0467, 0x050B, 0x04A8, 0x062A, 0x044A, 0x05A3, 0x078E, 0x077C, 0x08DB, 0x047B, 0x04D6,
    0x0575, 0x0617, 0x0822, 0x0448, 0x058B, 0x067B, 0x0460, 0x006B, 0xFB8F, 0xFCA5, 0xFA1C, 0xF581, 0xF482, 0xF485, 0xF720, 0xF3CE,
    0xF1D1, 0xF3D2, 0xF521, 0xF65C, 0xF192, 0xF4A8, 0xF652, 0xF6BC, 0xF7D9, 0xF581, 0xF804, 0xF6FD, 0xF6F6, 0xF2FB, 0xF202, 0xF3EB,
    0xF2C2, 0xF4D6, 0xF4C2, 0xF75F, 0xFA7D, 0xF91E, 0xFA3E, 0xFA8E, 0xF8AA, 0xFAD0, 0xF91A, 0xFA38, 0xF9F9, 0xFBC2, 0xFE94, 0xFB36,
    0x0034, 0xFFB9, 0x04A8, 0x05E1, 0x0441, 0x0790, 0x0478, 0x06EF, 0xFFEF, 0xFEBD, 0xFE39, 0xFED5, 0x0235, 0xFDB1, 0x01EB, 0x02F8,
    0x045E, 0x0259, 0x021D, 0x06E0, 0x0989, 0x0C3F, 0x0EB9, 0x1276, 0x1618, 0x156A, 0x1256, 0x1457, 0x10B8, 0x119D, 0x0E03, 0x0B7D,
    0x0E37, 0x0AFB, 0x0C58, 0x04B9, 0x0712, 0x0696, 0x0449, 0x05D4, 0xFFB3, 0x056D, 0x0313, 0x02D3, 0xFFC8, 0xFD0B, 0xFF1A, 0xFAAA,
    0xFAB7, 0xF416, 0xF5B1, 0xF5A5, 0xF1EF, 0xF2B5, 0xF2CF, 0xF698, 0xF6B2, 0xF6E5, 0xF787, 0xF922, 0xF9E2, 0xF82A, 0xF6F7, 0xFA35,
    0xF7DD, 0xF6DD, 0xF78F, 0xF547, 0xF91F, 0xF471, 0xF7B9, 0xF884, 0xF724, 0xF92E, 0xF595, 0xF950, 0xF307, 0xF3E9, 0xF5E4, 0xF4D5,
    0xF75C, 0xF557, 0xFBCF, 0xFBA1, 0xFB34, 0xFCE9, 0xFF37, 0x046E, 0x050B, 0x06F1, 0x0B48, 0x0FD9, 0x118F, 0x1084, 0x1017, 0x10FD,
    0x1099, 0x0EFA, 0x0A7D, 0x0ABB, 0x0A04, 0x074B, 0x0651, 0x03A3, 0x058E, 0x03DA, 0x02B5, 0x01CC, 0x0315, 0x0594, 0x0199, 0x02BD,
    0x03FA, 0x04D0, 0x04BD, 0x018E, 0x02C9, 0x023A, 0x00F6, 0xFFEA, 0xFF68, 0x018E, 0x0182, 0x034B, 0x03D3, 0x04A2, 0x065B, 0x04BA,
    0x0503, 0x0589, 0x0548, 0x039F, 0x03A9, 0x0470, 0x0296, 0x0375, 0x0507, 0x05CB, 0x07F1, 0x092C, 0x0B98, 0x0C48, 0x09C4, 0x0920,
    0x076E, 0x07C7, 0x068E, 0x06AD, 0x05C5, 0x03D2, 0x0787, 0x04D7, 0x0394, 0x0289, 0x0418, 0x0585, 0x04B8, 0x05DC, 0x0547, 0x09A8,
    0x05DF, 0x0483, 0x0343, 0x0125, 0xFF9F, 0xF983, 0xF927, 0xF597, 0xF50A, 0xF111, 0xEE96, 0xF072, 0xECF6, 0xECD4, 0xECB7, 0xEC50,
    0xEE2B, 0xF01F, 0xEFA2, 0xF2C0, 0xF2EC, 0xF345, 0xF35E, 0xF22A, 0xF227, 0xEEA5, 0xF2E8, 0xF08A, 0xF192, 0xF289, 0xF1D9, 0xF83F,
    0xF698, 0xFA14, 0xF979, 0xFE1C, 0x014A, 0xFF84, 0x0324, 0x0240, 0x0809, 0x05B3, 0x0770, 0x0A32, 0x0A9C, 0x0FB3, 0x0F60, 0x153A,
    0x1500, 0x16B5, 0x16FD, 0x14D8, 0x1578, 0x1485, 0x1559, 0x1366, 0x1315, 0x1499, 0x1540, 0x105D, 0x0F75, 0x0CAD, 0x0E6B, 0x0D71,
    0x0914, 0x0CE2, 0x0AE2, 0x0EDD, 0x085F, 0x0780, 0x0877, 0x040E, 0x0487, 0xFBB3, 0xFDE3, 0xF98B, 0xF7F9, 0xF5B4, 0xF023, 0xF24A,
    0xEE51, 0xEF39, 0xEB93, 0xEBED, 0xEF24, 0xEDE2, 0xEEC7, 0xEEBA, 0xF0A7, 0xF262, 0xF083, 0xEF80, 0xEF35, 0xEEF1, 0xF068, 0xED99,
    0xEF16, 0xEF9D, 0xF179, 0xF445, 0xF278, 0xF866, 0xF89F, 0xFB40, 0xFC5F, 0xFC70, 0xFFB0, 0xFEA7, 0x0224, 0xFF82, 0x0210, 0x0647,
    0x0703, 0x0903, 0x0823, 0x0DD3, 0x0FC1, 0x0E02, 0x0CC2, 0x0D8D, 0x0FCD, 0x0B7B, 0x0AB2, 0x0AD2, 0x0A8A, 0x0BBB, 0x07D3, 0x05E2,
    0x06D0, 0x0546, 0x0665, 0x0521, 0x0755, 0x0B2C, 0x0C64, 0x0FD6, 0x0C38, 0x1120, 0x11A2, 0x0FF7, 0x0F9D, 0x0B13, 0x0F9A, 0x0C57,
    0x08EE, 0x057B, 0x06BA, 0x074D, 0x0114, 0x0114, 0x002C, 0x02AA, 0x0057, 0xFEBD, 0x0009, 0x0299, 0x045C, 0x0087, 0x008F, 0x00BC,
    0x01CE, 0xFE85, 0xFC4F, 0xFC76, 0xFDFB, 0xFE3A, 0xFDD9, 0xFDA5, 0xFEDE, 0x01F0, 0x0097, 0x0351, 0x020D, 0x038C, 0x0351, 0x00DD,
    0x011B, 0xFB4E, 0xFDEF, 0xFBEB, 0xFA43, 0xFA64, 0xF897, 0xFCC8, 0xF745, 0xF7C0, 0xF5D3, 0xF572, 0xF51D, 0xF197, 0xF4E5, 0xF46F,
    0xF6D2, 0xF348, 0xF47E, 0xF42C, 0xF3FA, 0xF3EC, 0xF1BF, 0xF575, 0xF874, 0xFDA2, 0xFC76, 0x009E, 0x0360, 0x0582, 0x07A4, 0x0583,
    0x0A0A, 0x0992, 0x0B1D, 0x07AD, 0x0906, 0x099E, 0x06E8, 0x0763, 0x03FD, 0x08F0, 0x0573, 0x06D6, 0x06E3, 0x0907, 0x0E26, 0x0BBA,
    0x0FDE, 0x0D6A, 0x1248, 0x117E, 0x0E81, 0x0FEC, 0x0C81, 0x0EBB, 0x0AC7, 0x0B16, 0x0A78, 0x0899, 0x0BF8, 0x0ABE, 0x0B22, 0x0C94,
    0x0C98, 0x0C67, 0x09AA, 0x0924, 0x09CD, 0x05A8, 0x06F4, 0x05DC, 0x076D, 0x0752, 0x0407, 0x0896, 0x0433, 0x04ED, 0x0417, 0x0262,
    0x0438, 0xFFFA, 0x02EF, 0x023A, 0x017C, 0x00DC, 0xFD64, 0xFF42, 0xFDA8, 0xFB06, 0xFC9C, 0xFCB5, 0xFF14, 0xFF30, 0x01CA, 0x055B,
    0x03A5, 0x0508, 0x0642, 0x0873, 0x0802, 0x0596, 0x0657, 0x06CD, 0x04F8, 0x0230, 0xFEA0, 0xFEC7, 0xFCE1, 0xFBF3, 0xFA23, 0xF8AB,
    0xF935, 0xF843, 0xF762, 0xF6AD, 0xF901, 0xF855, 0xF80E, 0xF522, 0xF63B, 0xF3A4, 0xF235, 0xF18A, 0xEFB8, 0xF1E0, 0xEF7D, 0xF12E,
    0xF0AB, 0xF451, 0xF5F4, 0xF5C1, 0xF981, 0xF9D3, 0xFBF2, 0xFBD8, 0xFBD2, 0xFB98, 0xFF1A, 0xFFB5, 0x01BC, 0x0427, 0x0734, 0x0B8C,
    0x0A26, 0x0CA4, 0x0BA0, 0x10FE, 0x102A, 0x1167, 0x1511, 0x14E9, 0x1887, 0x1623, 0x15F3, 0x1593, 0x1694, 0x1507, 0x13AF, 0x16D0,
    0x17C9, 0x180F, 0x1803, 0x189B, 0x1AAA, 0x1AFB, 0x1A2E, 0x1906, 0x1962, 0x1810, 0x15B8, 0x12DE, 0x0F16, 0x0D42, 0x09FA, 0x061D,
    0x01A4, 0xFE44, 0xFC85, 0xFACB, 0xF81E, 0xF4B8, 0xF63D, 0xF5BD, 0xF4D9, 0xF1C2, 0xF1A1, 0xF196, 0xEEFE, 0xED61, 0xE8EA, 0xEB56,
    0xE8B7, 0xE7B5, 0xE522, 0xE75E, 0xEB6D, 0xEA4A, 0xEAFC, 0xED0F, 0xF37B, 0xF218, 0xF1E2, 0xF308, 0xF6AD, 0xF738, 0xF722, 0xFA02,
    0xFC30, 0x01A5, 0x0079, 0x0393, 0x05E1, 0x07BA, 0x0A7C, 0x0B2C, 0x0F3A, 0x0FC1, 0x1454, 0x1541, 0x160E, 0x16A0, 0x15A3, 0x1767,
    0x155C, 0x120F, 0x134E, 0x15CD, 0x1484, 0x114F, 0x12E5, 0x178F, 0x15B8, 0x1580, 0x148A, 0x16B1, 0x18CB, 0x1480, 0x134F, 0x1184,
    0x1243, 0x11AF, 0x0A41, 0x0AB0, 0x0879, 0x06D0, 0x02EE, 0xFD99, 0x009E, 0xFE83, 0xFE93, 0xFACC, 0xFA32, 0xFE08, 0xF9C3, 0xF871,
    0xF72A, 0xF6B7, 0xF926, 0xF423, 0xF29F, 0xF304, 0xF2A6, 0xF559, 0xF2BE, 0xF58B, 0xF740, 0xF9FB, 0xFE3F, 0xF9F0, 0xFE9E, 0xFD22,
    0xFFBF, 0x014F, 0xFE20, 0x03A3, 0x040E, 0x0706, 0x0454, 0x055E, 0x07BF, 0x05D3, 0x03FA, 0x0280, 0x0486, 0x0722, 0x0386, 0x0098,
    0x03D6, 0x02B4, 0x0196, 0xFB0C, 0xFB30, 0xFC72, 0xF9C2, 0xF8B1, 0xF52F, 0xFAD0, 0xFB27, 0xFC98, 0xFC62, 0xFC6D, 0x01FE, 0x01E9,
    0x00ED, 0xFEF8, 0x0187, 0x0148, 0xFF50, 0xFCC2, 0xFD22, 0xFEA6, 0xFCD2, 0xF9FC, 0xF815, 0xFAA2, 0xFAA9, 0xF94F, 0xF93B, 0xFADF,
    0xFE5F, 0xFE9E, 0xFEAE, 0xFF57, 0x00D4, 0x022B, 0x00C9, 0xFFD3, 0x0070, 0x029B, 0x01AF, 0x01CC, 0x044F, 0x0792, 0x0A38, 0x0CE5,
    0x0E00, 0x0ECD, 0x1214, 0x12C3, 0x110A, 0x11B9, 0x13D8, 0x1409, 0x14B6, 0x1202, 0x110B, 0x1419, 0x0FE7, 0x0C5D, 0x09A1, 0x0B5B,
    0x0B78, 0x05B9, 0x0717, 0x05E6, 0x07FF, 0x0305, 0xFDAD, 0x0092, 0xFCF1, 0xFA98, 0xF62A, 0xF4BF, 0xF873, 0xF44B, 0xF4D1, 0xF595,
    0xF4AD, 0xF8FA, 0xF5B1, 0xF7E0, 0xF7BD, 0xF878, 0xFBDD, 0xF741, 0xFC91, 0xFB31, 0xFA89, 0xFC0C, 0xF66B, 0xF9AE, 0xF561, 0xF5B8,
    0xF684, 0xF33A, 0xF7FB, 0xF63D, 0xF7D1, 0xF731, 0xF5AC, 0xFAC2, 0xF76C, 0xF9D4, 0xF934, 0xF669, 0xFA9A, 0xF5FA, 0xF538, 0xF40C,
    0xF553, 0xFA03, 0xF821, 0xFBE1, 0xFDCE, 0xFDD3, 0xFF0E, 0xFBAD, 0xFF3B, 0xFECE, 0xFFEF, 0x035D, 0x0308, 0x0807, 0x0684, 0x05DD,
    0x06ED, 0x079F, 0x078F, 0x04D6, 0x0753, 0x07BD, 0x06A8, 0x0653, 0x06FB, 0x0766, 0x0563, 0x0621, 0x05BF, 0x03D1, 0x025D, 0x02C1,
    0x0235, 0x01D2, 0x02A0, 0x047E, 0x0588, 0x0786, 0x0973, 0x0ACC, 0x0D17, 0x0C45, 0x0E4F, 0x0EF1, 0x0F32, 0x0CB9, 0x09F7, 0x0BD5,
    0x0983, 0x0719, 0x0471, 0x02D8, 0x03AC, 0x01CB, 0x0075, 0x0072, 0x0066, 0x0095, 0x0027, 0xFDBE, 0xFD6C, 0xFB45, 0xF859, 0xF3F0,
    0xF1FC, 0xF191, 0xEA12, 0xEA5A, 0xE919, 0xE7F7, 0xE9F7, 0xE7A5, 0xE984, 0xE972, 0xEB04, 0xEB76, 0xE8B3, 0xECC0, 0xEE46, 0xEFE5,
    0xF379, 0xF315, 0xF5A6, 0xF72D, 0xF94C, 0xFB2D, 0xF8B7, 0x0034, 0xFFF6, 0xFF00, 0x03A1, 0x03E6, 0x0955, 0x05B9, 0x086F, 0x0969,
    0x08CA, 0x0D00, 0x0797, 0x0878, 0x095F, 0x0ADC, 0x0CAE, 0x0A05, 0x0EBA, 0x11AC, 0x1288, 0x14DB, 0x14D6, 0x19A4, 0x1D1A, 0x1C5B,
    0x1E14, 0x1BA6, 0x1F07, 0x1E6F, 0x198F, 0x1AD0, 0x17BB, 0x19BD, 0x1456, 0x1254, 0x112C, 0x0C71, 0x0CBD, 0x0630, 0x0561, 0x053C,
    0x01EC, 0xFED5, 0xFAD1, 0xFA0F, 0xF71F, 0xF23E, 0xEF66, 0xEED6, 0xEC9F, 0xEC36, 0xEBAB, 0xEB42, 0xEE2D, 0xEBB7, 0xE98A, 0xE655,
    0xE9B2, 0xEBFC, 0xE8C8, 0xE99F, 0xE8B8, 0xE95E, 0xE8B6, 0xE6AE, 0xE39A, 0xE2D9, 0xEAF7, 0xF174, 0xE9ED, 0xDFED, 0xDE58, 0xDF93,
    0xE44B, 0xE6C6, 0xE8B4, 0xED2A, 0xEE22, 0xEDCE, 0xEEDF, 0xF3E7, 0xF5CA, 0xF551, 0xF4F5, 0xFB9B, 0xFE3C, 0xFE45, 0x011A, 0x01C2,
    0x0920, 0x072A, 0x075E, 0x07E1, 0x0912, 0x0DC3, 0x07DF, 0x08D3, 0x07CB, 0x0578, 0x0429, 0xFF69, 0x012E, 0xFD5E, 0xFC93, 0xFE36,
    0xF96C, 0xFBC8, 0xFC0C, 0xFB63, 0xFB13, 0xF7F2, 0xFB18, 0xF643, 0xF590, 0xF8A1, 0xF91F, 0x03D7, 0x0361, 0x0368, 0x0341, 0x05BB,
    0x0CA6, 0x045E, 0x07E2, 0x092B, 0x080B, 0x09A6, 0x04EF, 0x0B9C, 0x0BAF, 0x0D10, 0x09F4, 0xFFF4, 0x0429, 0x03D3, 0x02B4, 0x0595,
    0x06F9, 0x0B18, 0x0584, 0x05D8, 0x0938, 0x05FB, 0x098F, 0x026D, 0x028D, 0x037C, 0xFF39, 0xFECF, 0xF8B8, 0xFDFB, 0xFBAC, 0xF927,
    0xF826, 0xF479, 0xF689, 0xF2AB, 0xF493, 0xF2CC, 0xF2BE, 0xF599, 0xF3E9, 0xF276, 0xF20D, 0xF0D5, 0xEE18, 0xED4E, 0xEA65, 0xE79C,
    0xE67C, 0xE747, 0xE42A, 0xE46C, 0xE667, 0xE87C, 0xE819, 0xE5C0, 0xEBF6, 0xEE4B, 0xEDEF, 0xECBC, 0xEC95, 0xEE6D, 0xF0C7, 0xF44C,
    0xF5B9, 0xFB41, 0xFF1D, 0x03AD, 0x0A34, 0x09A6, 0x057B, 0x00B6, 0x07D4, 0x1483, 0x1B50, 0x2100, 0x221C, 0x2305, 0x2244, 0x2482,
    0x2497, 0x1FFD, 0x2067, 0x1E83, 0x1F09, 0x1B8B, 0x19EC, 0x1A2A, 0x168B, 0x14CD, 0x104E, 0x0EF8, 0x0DEB, 0x0A43, 0x027F, 0x0104,
    0x0415, 0xFBB0, 0xF27E, 0xF682, 0xFFBC, 0x01DC, 0xFCF2, 0xF520, 0xF168, 0xEC63, 0xEF99, 0xF26E, 0xF2A9, 0xF6B7, 0xF49C, 0xF7CD,
    0xF4E0, 0xF6B8, 0xF642, 0xF2AD, 0xF729, 0xF07E, 0xF420, 0xF4EC, 0xF425, 0xF5B1, 0xF2E6, 0xF9C0, 0xF52F, 0xF445, 0xF528, 0xF067,
    0xF344, 0xEF89, 0xEEEA, 0xEF42, 0xEF2B, 0xF392, 0xEFD8, 0xF2A4, 0xF6B9, 0xF26F, 0xF4D4, 0xF46D, 0xF73D, 0xF854, 0xF752, 0xFEA6,
    0xFBB1, 0x00C5, 0x0104, 0xFD74, 0x02C6, 0x00D0, 0x0452, 0x00B8, 0x03D5, 0x07F4, 0x0508, 0x0824, 0x0765, 0x099D, 0x0968, 0x0935,
    0x08F3, 0x0667, 0x07BB, 0x0931, 0x067A, 0x0942, 0x07E9, 0x0640, 0x0937, 0x06C8, 0x0867, 0x0775, 0x0D49, 0x0DB7, 0x0D56, 0x11AB,
    0x1204, 0x1505, 0x11D0, 0x13F8, 0x1570, 0x148C, 0x124C, 0x126F, 0x126F, 0x118C, 0x0FA2, 0x0AEE, 0x0E31, 0x0CDD, 0x0D77, 0x09B8,
    0x09FC, 0x0A68, 0x03F9, 0x01DA, 0xFCB5, 0xFD65, 0xFA99, 0xF870, 0xF6AB, 0xF59F, 0xF66D, 0xF274, 0xEFD5, 0xF0E8, 0xF299, 0xEECB,
    0xEDF3, 0xEEA5, 0xF23C, 0xF37D, 0xF556, 0xF872, 0xF79F, 0xF960, 0xFA6C, 0xFE29, 0xFB1C, 0xFB40, 0xFEBD, 0x02FD, 0x0AE2, 0x053D,
    0x0201, 0xFD79, 0xFE53, 0x05B8, 0x07A7, 0x109B, 0x0E6C, 0x0DDC, 0x0F0A, 0x0CFE, 0x1069, 0x0945, 0x0B26, 0x0B08, 0x08B0, 0x0EAA,
    0x0997, 0x0BB4, 0x0F26, 0x0D57, 0x0DA6, 0x0B3B, 0x0FD6, 0x0C59, 0x07ED, 0x0EA7, 0x08BB, 0x03C0, 0xFC71, 0xF97F, 0x006A, 0xFF8B,
    0x0323, 0xF896, 0xF0A5, 0xF239, 0xECEA, 0xEEC5, 0xEB4F, 0xED69, 0xED66, 0xE862, 0xEC4F, 0xE946, 0xED95, 0xF083, 0xEE35, 0xF16C,
    0xF0FA, 0xF5F6, 0xF4B9, 0xF3EC, 0xF8E1, 0xF8F8, 0xFD9F, 0xFE94, 0xFFC4, 0x03B7, 0x0695, 0x0834, 0x067B, 0x0862, 0x0D33, 0x0CE4,
    0x0F2B, 0x12A4, 0x1231, 0x14F6, 0x12FD, 0x138D, 0x1086, 0x0C79, 0x0958, 0x03CE, 0x0651, 0x069B, 0x086E, 0x0855, 0x0A98, 0x0B4B,
    0x0BE9, 0x0D59, 0x0CF6, 0x0F4E, 0x105E, 0x142D, 0x10D9, 0x10B8, 0x10E6, 0x106E, 0x105C, 0x0DE0, 0x0F15, 0x0D7F, 0x0C2D, 0x0944,
    0x060C, 0x0152, 0xFF1E, 0xFD66, 0xFB08, 0xF9D1, 0xF9D8, 0xFA2B, 0xF67E, 0xF4C1, 0xF227, 0xF069, 0xEDAE, 0xEAF8, 0xE8B0, 0xE8E9,
    0xE8E6, 0xE688, 0xE733, 0xE6C0, 0xEA4A, 0xE64A, 0xE5F7, 0xE8A1, 0xE8FC, 0xECC5, 0xEA25, 0xF083, 0xF3A9, 0xF3E4, 0xF675, 0xF67C,
    0xFD2F, 0xFDBF, 0xFD0B, 0x00EB, 0x020A, 0x0615, 0x042A, 0x05AF, 0x0C75, 0x08B1, 0x0AC7, 0x0BB5, 0x0B70, 0x10B3, 0x0F52, 0x1432,
    0x1123, 0x121A, 0x1745, 0x139D, 0x17F5, 0x1215, 0x1663, 0x1E46, 0x2136, 0x24B3, 0x1B7F, 0x1A5F, 0x19F6, 0x190C, 0x2038, 0x204B,
    0x231E, 0x20EC, 0x1E7D, 0x1C80, 0x1754, 0x1102, 0x0560, 0x1003, 0x0B1A, 0x07FE, 0xFE90, 0x0929, 0x08B4, 0xF3F2, 0xFC61, 0xF132,
    0xF452, 0xE128, 0xE6D6, 0xED58, 0xE438, 0xE05B, 0xDFA3, 0xD62C, 0xE051, 0xE936, 0xD62C, 0xE3BA, 0xD0FB, 0xDB6E, 0xD754, 0xCD3A,
    0xE377, 0xE4D1, 0xE4C4, 0xEFED, 0xEE5B, 0xDD5E, 0xF467, 0xECAD, 0xF1FF, 0x133F, 0xE0BD, 0x0191, 0x0774, 0xEF1C, 0x22A2, 0xEC9A,
    0xFD00, 0x14F1, 0x0862, 0x06D8, 0xEA46, 0x1B10, 0x0229, 0xEB0C, 0x0FDE, 0x1A07, 0xFCD0, 0xF2C4, 0xFFB7, 0x0CCD, 0x12DE, 0xD7F1,
    0x06A3, 0x1BF2, 0x0511, 0xF9D2, 0xF24C, 0xF95A, 0xEE4B, 0xE9A5, 0xDBD4, 0xF819, 0xE87B, 0xD3B9, 0xD647, 0xFA79, 0xE8D5, 0xC679,
    0xF499, 0xEA28, 0xDFA0, 0xE2B5, 0xF9DB, 0xF882, 0xEC93, 0x0A0F, 0x1DB7, 0x03F2, 0x0BE2, 0x1EC9, 0x1D30, 0x3884, 0x11DB, 0x3121,
    0x365B, 0x3DAF, 0x3913, 0x3154, 0x44CF, 0x265C, 0x3371, 0x305D, 0x29D8, 0x075F, 0xFF9C, 0xF213, 0xF6F2, 0xD1A2, 0xBADD, 0xD390,
    0xC438, 0xB252, 0x9E80, 0xB2A0, 0xA96B, 0x9678, 0xA651, 0xAB79, 0x98EC, 0x98D3, 0xB04A, 0xA875, 0xAAD2, 0xACCA, 0xB752, 0xC1FD,
    0xA447, 0xEDB2, 0xD993, 0xC958, 0xDB32, 0xD3BB, 0xE8E4, 0xEA65, 0x0E90, 0x0460, 0x1FB0, 0x10AC, 0x290D, 0x3CE8, 0x3C49, 0x2E4A,
    0x48D9, 0x61E2, 0x36A2, 0x6ADE, 0x5D1F, 0x6FC0, 0x6ED8, 0x5CF9, 0x73B0, 0x7907, 0x7E30, 0x7438, 0x7B1E, 0x74FD, 0x7D7E, 0x7F2A,
    0x79E1, 0x7494, 0x7DB2, 0x6F0B, 0x6B51, 0x719A, 0x6206, 0x577C, 0x5DD1, 0x65CB, 0x3FBF, 0x5694, 0x5856, 0x407D, 0x464F, 0x4973,
    0x3CE0, 0x2D9E, 0x402D, 0x3106, 0x3519, 0x3723, 0x2637, 0x26B4, 0x221D, 0x25E6, 0x0CF4, 0x1C47, 0x1601, 0x1211, 0x151D, 0x051B,
    0x147E, 0x02CF, 0x01F6, 0xF69A, 0x0A0E, 0xF5FA, 0xEA48, 0xF0D4, 0xE9D5, 0xDEB0, 0xD98D, 0xEF6F, 0xC868, 0xE37C, 0xD871, 0xB683,
    0xDC14, 0xD4E2, 0xBEFE, 0xBE90, 0xD3AF, 0xB720, 0xBEF6, 0xC607, 0xB501, 0xC274, 0xAD44, 0xB8E5, 0xBA2E, 0xB4F8, 0xB456, 0xB23B,
    0xA91E, 0xAD20, 0xAE45, 0xB036, 0xB6CA, 0xACD4, 0xA918, 0xAD23, 0xB91E, 0xAC68, 0xAE53, 0xB7AD, 0xA345, 0xB844, 0xB5AE, 0xB052,
    0xAF9B, 0xB359, 0xB6A3, 0xB431, 0xCF53, 0xB567, 0xC004, 0xC6AF, 0xCC29, 0xC08E, 0xCC47, 0xC8C5, 0xD5DE, 0xCB9C, 0xD217, 0xDEB7,
    0xCDA3, 0xE6A6, 0xCE3A, 0xE297, 0xDCDD, 0xE6B9, 0xEBB2, 0xE0D7, 0xD7C2, 0xEB7E, 0xEF3F, 0xE6A0, 0xF37C, 0xE98F, 0xED63, 0x0804,
    0xFC5E, 0xF82B, 0xF563, 0x0172, 0x018D, 0xF9B7, 0xF1C1, 0xEC10, 0x0BB0, 0x01C3, 0xF42B, 0xF1BF, 0x1351, 0xFA48, 0x0DF2, 0xF552,
    0x0364, 0x07D1, 0x0DA9, 0x2279, 0x08DB, 0x2AB9, 0x1D8D, 0x24E0, 0x2DB9, 0x2CF1, 0x1AD9, 0x34E8, 0x3DB0, 0x344E, 0x3CB1, 0x409B,
    0x362F, 0x386C, 0x3F0B, 0x3E78, 0x5747, 0x59EF, 0x4EEB, 0x683A, 0x6E3B, 0x75CA, 0x6B64, 0x6A56, 0x766D, 0x6F10, 0x7D06, 0x6FCA,
    0x6D3C, 0x7C14, 0x6693, 0x686F, 0x6EE7, 0x502E, 0x594F, 0x5489, 0x520C, 0x5071, 0x4EEF, 0x49CA, 0x5A87, 0x3947, 0x3A3C, 0x483C,
    0x50AA, 0x5786, 0x3DE2, 0x5375, 0x47D5, 0x3BD7, 0x3E6B, 0x420E, 0x396F, 0x2F6D, 0x1D5F, 0x2E72, 0x2023, 0x140F, 0x2858, 0x237B,
    0x2FE9, 0x30C7, 0x225A, 0x40D3, 0x2613, 0x2282, 0x2079, 0x15F6, 0x1F23, 0x0980, 0x1F46, 0x061F, 0x11AD, 0x2365, 0xFB48, 0xF1BD,
    0xE569, 0xEA17, 0x03F1, 0xE2C2, 0xF5E9, 0x0665, 0xF615, 0x1A78, 0x10E9, 0x08EC, 0x3182, 0x14AB, 0x18D0, 0x3D4F, 0x226F, 0x0F23,
    0x3C90, 0x1FDC, 0x0198, 0x1D05, 0x1CF3, 0x28A2, 0xFEE1, 0xEEE4, 0xED08, 0xF34B, 0xE7C3, 0xE9D8, 0xD57D, 0xCF57, 0xDF83, 0xD6D4,
    0xE2DC, 0xCB67, 0xC6BB, 0xC7E6, 0xB474, 0xC4B9, 0xC0D7, 0xBFDE, 0xBA4A, 0xB881, 0xBF06, 0xBD6A, 0xBC36, 0xBE46, 0xD26C, 0xBE42,
    0xE047, 0xC6C7, 0xD48F, 0xCF9A, 0xC705, 0xD0BE, 0xB83A, 0xD078, 0xC1F9, 0xCB0A, 0xBF4A, 0xBB5F, 0xAC54, 0xBE9C, 0xB120, 0x9CC6,
    0xAD27, 0xAB30, 0xA92F, 0xB511, 0xC3B2, 0xAB49, 0xB51D, 0xBF7D, 0xBF98, 0xBC78, 0xBC77, 0xC04B, 0xB858, 0xB633, 0xAF9B, 0xAF50,
    0xAAA8, 0xA63D, 0xBA9C, 0xA19A, 0xA1D4, 0xB430, 0xA380, 0xA251, 0xA9C2, 0xAB99, 0xA5D8, 0xAC4E, 0xA3C3, 0xB155, 0xACAE, 0xC7FE,
    0xBD0D, 0xBA0E, 0xD4DB, 0xC8FD, 0xDCA8, 0xC60F, 0xE999, 0xE707, 0xE876, 0xF868, 0xEDDD, 0x00E0, 0x05DA, 0x0C66, 0xFE2B, 0x013D,
    0x0624, 0x006D, 0xF727, 0xF6FD, 0x0800, 0xF9F1, 0xEF3E, 0x0233, 0xE9E4, 0xFE4B, 0xFC7A, 0xEBAD, 0xF8DB, 0xEB4A, 0xFD66, 0xFB55,
    0xF489, 0xFD73, 0x0EF5, 0x0DEA, 0x1FC8, 0x12BD, 0x12C0, 0x1C55, 0x0789, 0x1577, 0x0CED, 0x1285, 0xF97F, 0x0AD4, 0x126A, 0xF40C,
    0x02C4, 0xF55D, 0xEAA8, 0xFF49, 0xFD90, 0xFE61, 0x072E, 0x0CBC, 0xFC50, 0xFF41, 0x25C7, 0x0B65, 0xFF57, 0xFD9B, 0x0D48, 0x10A5,
    0x1A2E, 0x11EC, 0x0EE2, 0x1E8C, 0x21BA, 0x20AF, 0x2E2F, 0x4DCB, 0x3631, 0x48D2, 0x597E, 0x50F9, 0x57E3, 0x6064, 0x50C8, 0x60CD,
    0x59B2, 0x5B2C, 0x6079, 0x43E2, 0x55E6, 0x4795, 0x368C, 0x4785, 0x3BFF, 0x433F, 0x34A8, 0x37FE, 0x4A28, 0x4671, 0x5217, 0x420D,
    0x5426, 0x5816, 0x520F, 0x47F1, 0x5426, 0x4232, 0x4624, 0x4B18, 0x3BC7, 0x38C9, 0x4C08, 0x3808, 0x3202, 0x3FD1, 0x2A7F, 0x355A,
    0x1F44, 0x428A, 0x2945, 0x384A, 0x3ACB, 0x2FC3, 0x3D54, 0x3084, 0x31DF, 0x33CE, 0x3761, 0x2F59, 0x344A, 0x2E84, 0x4305, 0x3660,
    0x44D2, 0x4821, 0x49F7, 0x531C, 0x5551, 0x5887, 0x54EB, 0x5E64, 0x55B9, 0x504A, 0x597E, 0x56DB, 0x52EF, 0x5483, 0x4952, 0x49FE,
    0x460A, 0x507B, 0x381B, 0x2694, 0x3647, 0x357A, 0x290D, 0x2DA5, 0x33E0, 0x324B, 0x343A, 0x41A2, 0x4E69, 0x436E, 0x4E07, 0x4E8E,
    0x483E, 0x4243, 0x4331, 0x3970, 0x2AC2, 0x3266, 0x296A, 0x0BD5, 0x1629, 0x0E10, 0xF2BE, 0xF4A7, 0xF724, 0xF869, 0xE650, 0xDEEC,
    0xEA22, 0xED96, 0xDE6B, 0xE6BB, 0xE68F, 0xE445, 0xE32F, 0xD5C3, 0xDC39, 0xDF5D, 0xE200, 0xCCE0, 0xD807, 0xF5BE, 0xE044, 0xE9C5,
    0x0350, 0xFD07, 0xFC59, 0x07CD, 0x0A42, 0xF979, 0xFD5F, 0x070B, 0xF6D6, 0xF372, 0xFF4D, 0xF3E9, 0xEACD, 0xED95, 0xE83B, 0xE53A,
    0xD0E2, 0xE469, 0xDD1A, 0xC970, 0xD4F6, 0xD392, 0xDBAA, 0xDF6D, 0xE74E, 0xE5F9, 0xF3C7, 0xEADA, 0xF72A, 0xEE1E, 0xDA63, 0xE7F0,
    0xDE33, 0xE436, 0xE20B, 0xE003, 0xD252, 0xD045, 0xD1B9, 0xC239, 0xC97F, 0xC75F, 0xB695, 0xBB77, 0xB9C2, 0xB8E2, 0xBA2A, 0xAE92,
    0xA9D3, 0xAFB8, 0xA9D1, 0xA5BF, 0xAA58, 0xA2C4, 0xA2C8, 0xA150, 0xA678, 0xA066, 0xA40D, 0xA5F3, 0xA979, 0xB56B, 0xB56C, 0xB571,
    0xB2E4, 0xC04C, 0xBD06, 0xC671, 0xC4E6, 0xCBB4, 0xDD30, 0xC912, 0xDBC1, 0xD1FA, 0xCB2A, 0xD395, 0xCA57, 0xCBF4, 0xBDE5, 0xC389,
    0xBDD5, 0xBD74, 0xB7A2, 0xBF54, 0xC74C, 0xBD74, 0xCC0A, 0xCBB5, 0xCD07, 0xCA9C, 0xD7EF, 0xD494, 0xCD8E, 0xD676, 0xCDB5, 0xCF8B,
    0xC5BA, 0xC8E8, 0xC7D5, 0xBDEB, 0xBF90, 0xC643, 0xBC7A, 0xBBA6, 0xBF9C, 0xBC25, 0xC311, 0xBD6B, 0xBFEF, 0xB7E9, 0xBA2A, 0xBE10,
    0xBB09, 0xB825, 0xC311, 0xBA9E, 0xB6EB, 0xC673, 0xCDA9, 0xD588, 0xD7A4, 0xEA1F, 0xEBB3, 0xEE7D, 0xF7FB, 0x01CE, 0xFAB3, 0x05CE,
    0x0A47, 0x0F87, 0x1725, 0x0437, 0x157A, 0x1529, 0x0ED5, 0x116E, 0x0943, 0x0746, 0x0275, 0xFFCB, 0xF2AA, 0xEDDA, 0xF8C2, 0xF18F,
    0xF22E, 0xFA2F, 0x01AE, 0xF6E1, 0xF981, 0x028E, 0xF7DC, 0xF710, 0xFC8A, 0x0144, 0xFDA5, 0x0249, 0x07D3, 0x0267, 0xFCF6, 0xFA02,
    0xF89E, 0xF643, 0xF96A, 0xF92F, 0xF8BC, 0x00B4, 0x01E6, 0x0125, 0x0230, 0x0452, 0x01D1, 0x0349, 0xFC8B, 0x018A, 0xFCCE, 0xF680,
    0xFCAE, 0xFA49, 0x036D, 0x0F17, 0x0F60, 0x202A, 0x1C81, 0x27BD, 0x3574, 0x3064, 0x45D9, 0x414F, 0x473E, 0x51B7, 0x5B33, 0x52C3,
    0x55A8, 0x532F, 0x5699, 0x55CE, 0x4A34, 0x4C2A, 0x45DC, 0x3E79, 0x387B, 0x32AF, 0x2E75, 0x339D, 0x38AF, 0x3A87, 0x3D88, 0x4A0B,
    0x4A7D, 0x423C, 0x3A94, 0x4325, 0x3303, 0x3783, 0x4343, 0x3799, 0x326F, 0x380A, 0x2A26, 0x2DA6, 0x2BB1, 0x2824, 0x2D9E, 0x25D4,
    0x3A52, 0x38FD, 0x3B1F, 0x3CE1, 0x4103, 0x3AA8, 0x463F, 0x3FCF, 0x3FA5, 0x3D90, 0x3AAF, 0x33E7, 0x2124, 0x3631, 0x2B03, 0x2CD1,
    0x2E8B, 0x3A02, 0x415A, 0x3F40, 0x4C76, 0x4DF7, 0x4C24, 0x4ABB, 0x4CBD, 0x55B5, 0x4E6D, 0x4A18, 0x4BF1, 0x46E7, 0x50D0, 0x48A5,
    0x456E, 0x3DB3, 0x322D, 0x2418, 0x15F7, 0x15F0, 0x0CDB, 0x0C46, 0x064C, 0x0A5F, 0x0B4C, 0x1390, 0x1619, 0x0FF1, 0x1E4C, 0x1D17,
    0x2AF5, 0x2207, 0x2722, 0x30E5, 0x283A, 0x293D, 0x2479, 0x21B5, 0x14F9, 0x12EA, 0x0CEE, 0x0AE1, 0x07DD, 0x0679, 0x003B, 0xFFE1,
    0x0407, 0xFFAB, 0xFD5B, 0x011F, 0xF8E8, 0xF4CD, 0xF912, 0xEC05, 0xEAC1, 0xEB8A, 0xEB7F, 0xE550, 0xE656, 0xE78E, 0xE838, 0xED83,
    0xF283, 0xF683, 0xFA57, 0xFF45, 0xFFCD, 0x0881, 0x07D2, 0x07FD, 0x0616, 0x02D6, 0x048D, 0x0559, 0x046F, 0x00F2, 0xFFDB, 0xF3E5,
    0xED62, 0xE32C, 0xD573, 0xD6EE, 0xD2BE, 0xCAB0, 0xCE3B, 0xD243, 0xD4D6, 0xD2A8, 0xD2BA, 0xCDE1, 0xD0A2, 0xD498, 0xD1A6, 0xD280,
    0xD2F0, 0xDBD6, 0xD6C8, 0xD5C4, 0xD78D, 0xD838, 0xD7DF, 0xD7E9, 0xD76E, 0xDC83, 0xE1CE, 0xDE67, 0xDD26, 0xDC57, 0xDC3A, 0xDD13,
    0xDB2F, 0xD888, 0xD053, 0xC840, 0xCD8A, 0xC2F8, 0xBC00, 0xC4EF, 0xC18C, 0xC1C3, 0xBFF7, 0xBC98, 0xCB92, 0xC3A4, 0xC1D6, 0xC7F1,
    0xCA57, 0xC8BD, 0xCC1D, 0xC7DD, 0xC654, 0xD135, 0xCB89, 0xD7A4, 0xD1C6, 0xD726, 0xD813, 0xCF9E, 0xCCF1, 0xC699, 0xC50D, 0xBF7E,
    0xB5BE, 0xB653, 0xC02A, 0xB6EF, 0xB866, 0xB3D8, 0xB4A0, 0xB375, 0xB295, 0xB36D, 0xB5D7, 0xBD84, 0xBBC2, 0xBD73, 0xBCD0, 0xC0A2,
    0xB9A1, 0xB519, 0xB5BA, 0xB5DB, 0xB8F3, 0xBDFC, 0xBA1B, 0xBCF8, 0xC1C6, 0xC260, 0xC754, 0xC363, 0xC497, 0xC7B6, 0xC197, 0xC3BF,
    0xC2D3, 0xBD32, 0xC0D8, 0xB9CB, 0xBCFC, 0xC077, 0xC2F8, 0xC70B, 0xD0D2, 0xCE6D, 0xDA0B, 0xE8C9, 0xE70A, 0xF5E3, 0xF75C, 0xF8A7,
    0xF946, 0xFC6F, 0x0271, 0x07C9, 0x0382, 0x082A, 0xFD4A, 0xFB70, 0xFB71, 0xEE4F, 0xE747, 0xDBDA, 0xDF61, 0xD608, 0xD391, 0xD578,
    0xD29B, 0xCCE6, 0xD335, 0xCDD6, 0xCF94, 0xCF1B, 0xCCFF, 0xCA3F, 0xC85B, 0xD404, 0xC994, 0xCA69, 0xC9F1, 0xCA6A, 0xCADC, 0xCC11,
    0xCC16, 0xC8A9, 0xC36A, 0xC7BA, 0xCAAF, 0xC772, 0xCD23, 0xD1AB, 0xD3B9, 0xDB1E, 0xD926, 0xD862, 0xDD79, 0xD454, 0xD35F, 0xD481,
    0xD561, 0xD749, 0xDD4D, 0xDF5F, 0xE561, 0xE799, 0xF046, 0xFA89, 0xF632, 0x017B, 0x0502, 0x07EE, 0x1187, 0x103E, 0x1BC7, 0x1F46,
    0x2987, 0x3338, 0x2D68, 0x3AB9, 0x33BF, 0x2CB8, 0x27FF, 0x1E1B, 0x1AA5, 0x10EE, 0x110B, 0x14D6, 0x0E9C, 0x168D, 0x18BB, 0x0B86,
    0x13F9, 0x1025, 0x1127, 0x15D2, 0x104B, 0x17B9, 0x0CA4, 0x0E25, 0x0E98, 0x06FE, 0x0951, 0xFFD6, 0xF8CC, 0x010A, 0x09A3, 0x0017,
    0x05AA, 0xFCB2, 0xFDF9, 0x0195, 0x0221, 0xFDAF, 0xF4D8, 0xF559, 0xE827, 0xEB1C, 0xEA7C, 0xEFD7, 0xE907, 0xEE92, 0xE8BD, 0xE5A8,
    0xF3A4, 0xF513, 0x06EB, 0x0E32, 0x18AC, 0x2732, 0x2CB4, 0x3171, 0x3086, 0x2D57, 0x344C, 0x3F70, 0x45C9, 0x4BC4, 0x5296, 0x505C,
    0x4F04, 0x4F86, 0x4792, 0x439B, 0x3A49, 0x31A6, 0x36E8, 0x3580, 0x349B, 0x2A6C, 0x3094, 0x3691, 0x3A6E, 0x44F3, 0x4D95, 0x5360,
    0x53C7, 0x63F1, 0x6634, 0x6C9C, 0x6FB1, 0x7381, 0x6E41, 0x63BE, 0x5EFE, 0x651A, 0x63CE, 0x6048, 0x6028, 0x51E8, 0x5173, 0x482E,
    0x4BF6, 0x3DBA, 0x3026, 0x3558, 0x2143, 0x201C, 0x1CB1, 0x1C7C, 0x19CB, 0x0F38, 0x1527, 0x0955, 0x088F, 0x0C22, 0x0F16, 0x15A3,
    0x1740, 0x1AA0, 0x248C, 0x1FEC, 0x20D8, 0x26F3, 0x23C8, 0x2BBD, 0x2DC3, 0x3989, 0x3376, 0x3D05, 0x3C49, 0x36D2, 0x3F5C, 0x353A,
    0x3156, 0x2C84, 0x326C, 0x354F, 0x2D27, 0x25B9, 0x2358, 0x1EA8, 0x2270, 0x2DF2, 0x31D1, 0x2B2A, 0x3B58, 0x4591, 0x4855, 0x4D19,
    0x4D60, 0x57B9, 0x5274, 0x4F71, 0x47C1, 0x45D1, 0x45BA, 0x4B22, 0x4A3F, 0x46AB, 0x46D7, 0x466A, 0x45B4, 0x3EBC, 0x4019, 0x3789,
    0x2D8E, 0x2346, 0x1C61, 0x16A9, 0x1941, 0x186B, 0x107D, 0x0ADC, 0x0808, 0x00EB, 0x068B, 0x07B3, 0x0953, 0x0FA0, 0x0901, 0x0B95,
    0x00E3, 0x05BF, 0xF8F0, 0xF698, 0xFE9A, 0xF8E2, 0xFCBD, 0x03A8, 0x0552, 0x017E, 0x07C6, 0x0565, 0xFFF9, 0xF820, 0x0244, 0x06A3,
    0x06D0, 0x09CE, 0x05F7, 0x03E6, 0x0252, 0x07B9, 0x0683, 0x06EC, 0x0B29, 0x1128, 0x16CD, 0x1645, 0x23C6, 0x2EA8, 0x2DFB, 0x30A0,
    0x297B, 0x20D8, 0x1C66, 0x1FA3, 0x23BF, 0x1C8A, 0x1E5C, 0x1CB4, 0x1DE6, 0x158A, 0x1332, 0x0E95, 0xFD16, 0xFA2D, 0xEFCA, 0xEAB9,
    0xE231, 0xE2C1, 0xDB41, 0xD28C, 0xCF04, 0xCE63, 0xCD23, 0xCBF8, 0xD3E9, 0xD742, 0xDBC7, 0xDBDE, 0xE0B0, 0xDE9E, 0xDE5C, 0xE1FF,
    0xE43B, 0xE7B7, 0xEDB3, 0xF423, 0xF0CF, 0xEAB7, 0xEDE9, 0xE8E7, 0xDEFC, 0xD9FA, 0xD489, 0xD78A, 0xD61D, 0xD45F, 0xCC2E, 0xCA37,
    0xC61E, 0xC49E, 0xCB1E, 0xC448, 0xC9C5, 0xD06E, 0xD46A, 0xD0B7, 0xD7C1, 0xDE4E, 0xE0AB, 0xE63C, 0xDD7A, 0xD752, 0xD15D, 0xCEEB,
    0xCF5B, 0xCE70, 0xD185, 0xD29E, 0xCCEF, 0xCB0A, 0xCA3E, 0xC986, 0xC404, 0xBD96, 0xB9F8, 0xB6FB, 0xB5E4, 0xB850, 0xB907, 0xB66F,
    0xB3C5, 0xB39B, 0xB0EE, 0xB2F1, 0xB8F4, 0xBD7C, 0xC1BD, 0xC25F, 0xCA2D, 0xC82C, 0xC81C, 0xCA9A, 0xCA74, 0xCABC, 0xD0E8, 0xDB48,
    0xD803, 0xDB0A, 0xE1BE, 0xE220, 0xE295, 0xE1F5, 0xDFD1, 0xE1F9, 0xE255, 0xE3DD, 0xE252, 0xD84C, 0xCE73, 0xD0BA, 0xD03C, 0xCC46,
    0xD4E5, 0xD7FC, 0xDDC1, 0xE1C1, 0xE57D, 0xE842, 0xF347, 0xFC7E, 0xFAA5, 0xF390, 0xE495, 0xE265, 0xDEB6, 0xDA06, 0xD695, 0xD615,
    0xD86A, 0xD364, 0xD4E4, 0xD41B, 0xCE6D, 0xCB72, 0xC3D7, 0xC06F, 0xBF36, 0xC278, 0xC89E, 0xC76A, 0xC765, 0xC9B8, 0xC4D3, 0xC5A6,
    0xC706, 0xC859, 0xCEC6, 0xD1F5, 0xDC76, 0xD8C7, 0xDDB6, 0xE282, 0xE04B, 0xE2B6, 0xECC7, 0xF988, 0xF3E3, 0xFAB8, 0xFDC7, 0xFE84,
    0x032D, 0x0171, 0x0007, 0xFFBC, 0xFCF4, 0x043E, 0x041A, 0xFBCF, 0xF49B, 0xF0D7, 0xED11, 0xE36D, 0xEA7A, 0xE960, 0xEDE5, 0xF2CD,
    0xF382, 0xFD69, 0x0596, 0x176C, 0x1E9C, 0x1D63, 0x1F3E, 0x17FB, 0x19E0, 0x1A28, 0x1F82, 0x20F4, 0x2197, 0x27C9, 0x2103, 0x21F0,
    0x1BEC, 0x1736, 0x11F0, 0x070A, 0xFD47, 0xF517, 0xEE77, 0xEC40, 0xEC3A, 0xE995, 0xE3FD, 0xE4C2, 0xE644, 0xE1FB, 0xE5F7, 0xE7B4,
    0xED52, 0xE9A3, 0xECF4, 0xF03A, 0xEC13, 0xF10A, 0xF80B, 0xFFBF, 0x047A, 0x09E9, 0x09D2, 0x0B81, 0x0BE6, 0x0CFA, 0x0F95, 0x087B,
    0x0711, 0x11A7, 0x1131, 0x0DE0, 0x07F0, 0x0833, 0x03DB, 0xFFDA, 0x02C1, 0x0234, 0x093F, 0x0C06, 0x1161, 0x0FC9, 0x1651, 0x27D5,
    0x3131, 0x34AF, 0x36B8, 0x303B, 0x2C5F, 0x271F, 0x24E2, 0x257B, 0x269D, 0x29F5, 0x27B3, 0x2D34, 0x2D96, 0x2EFF, 0x2EDE, 0x2722,
    0x246A, 0x217F, 0x1BAA, 0x1F82, 0x1BC6, 0x1A0A, 0x160E, 0x120D, 0x11BA, 0x126B, 0x165D, 0x1C87, 0x21CB, 0x1E7E, 0x24B7, 0x2328,
    0x2013, 0x1D98, 0x24E9, 0x2848, 0x2B19, 0x2F31, 0x2DE2, 0x2EDE, 0x2AE7, 0x3126, 0x2FEF, 0x2BD6, 0x2756, 0x2BAB, 0x2D89, 0x2B1B,
    0x2BA7, 0x2C2E, 0x2DE4, 0x2C23, 0x31AE, 0x2C89, 0x2F0D, 0x35A7, 0x34CE, 0x3202, 0x33E4, 0x3E4E, 0x4AE0, 0x5400, 0x55F3, 0x51A8,
    0x4D5B, 0x4B3A, 0x44F8, 0x470D, 0x4330, 0x43CC, 0x48C1, 0x4377, 0x42A1, 0x44AF, 0x42E0, 0x3F45, 0x37FC, 0x3308, 0x2716, 0x2507,
    0x2127, 0x1880, 0x1878, 0x1277, 0x0F05, 0x0AC5, 0x0920, 0x0EED, 0x124B, 0x11AE, 0x187F, 0x1940, 0x1B75, 0x1B42, 0x2157, 0x2927,
    0x302C, 0x377A, 0x4096, 0x3F79, 0x3FDA, 0x4914, 0x48FE, 0x4910, 0x42D0, 0x45A6, 0x45CE, 0x43A7, 0x4252, 0x4035, 0x3860, 0x34B1,
    0x31E8, 0x2AE1, 0x26E6, 0x2C43, 0x2DC3, 0x2DC6, 0x2CD8, 0x2F9C, 0x38D7, 0x3E03, 0x41F0, 0x4127, 0x3EEB, 0x3912, 0x3450, 0x2D3B,
    0x2CE2, 0x2AD1, 0x2CD1, 0x247E, 0x22CA, 0x2298, 0x1C7B, 0x1C73, 0x1700, 0x0F89, 0x0052, 0xFA14, 0xF1B1, 0xE999, 0xE459, 0xE1FC,
    0xDF7C, 0xDDDC, 0xE077, 0xE471, 0xEA36, 0xE868, 0xE8F8, 0xEC41, 0xEC2E, 0xEE89, 0xF59C, 0xFC15, 0xFF31, 0x0A08, 0x10DF, 0x0DDF,
    0x0F67, 0x136C, 0x169E, 0x170C, 0x1431, 0x1586, 0x1A5F, 0x1AB0, 0x1E20, 0x1CE2, 0x1C83, 0x1E29, 0x1B93, 0x17E2, 0x11A3, 0x1150,
    0x1141, 0x12BF, 0x133C, 0x156E, 0x1D0C, 0x26AB, 0x331B, 0x3892, 0x3992, 0x3676, 0x2F0A, 0x2543, 0x1E06, 0x1A23, 0x1573, 0x1023,
    0x08DA, 0x07F5, 0x00CB, 0xFCB2, 0xFAD3, 0xEE81, 0xE38D, 0xDAB2, 0xD35F, 0xCD27, 0xCAF4, 0xC90F, 0xC7A9, 0xC5D6, 0xC89F, 0xCBD3,
    0xCD22, 0xCBC6, 0xCA76, 0xCDC7, 0xC8C0, 0xCB38, 0xD191, 0xCF9E, 0xD44C, 0xDB10, 0xE29F, 0xE430, 0xE450, 0xE9A2, 0xECAE, 0xF2D3,
    0xF4DB, 0xF1B2, 0xF286, 0xF212, 0xF822, 0xFADD, 0xF768, 0xFB22, 0xF843, 0xF352, 0xEA87, 0xE3A3, 0xE526, 0xE48A, 0xE0D4, 0xDE71,
    0xDD5C, 0xE71C, 0xEF0C, 0xF66A, 0xFF0F, 0x00CF, 0x0510, 0xFF71, 0xFC2A, 0xFCE9, 0xFDA5, 0xFD20, 0xF862, 0xF6AB, 0xF021, 0xED86,
    0xF10E, 0xEB51, 0xE651, 0xE18E, 0xD660, 0xCEEA, 0xC836, 0xC37F, 0xC28C, 0xBB81, 0xBBA1, 0xBC43, 0xBDD6, 0xC05B, 0xBF19, 0xC012,
    0xB95E, 0xBA73, 0xB92F, 0xB3D4, 0xB5B1, 0xBA02, 0xBCF3, 0xBF33, 0xC14E, 0xC106, 0xC4F1, 0xC901, 0xCB34, 0xC428, 0xC202, 0xC4C4,
    0xC514, 0xC8BD, 0xC6AD, 0xCACB, 0xCD0B, 0xC7AD, 0xC282, 0xBEBF, 0xBD72, 0xBF20, 0xC04F, 0xC187, 0xC2A3, 0xC9E1, 0xD1F8, 0xDA0B,
    0xE68D, 0xED47, 0xF110, 0xEE5C, 0xEDDC, 0xEDE7, 0xEB98, 0xE899, 0xEAD1, 0xE6A2, 0xE36D, 0xE951, 0xEC26, 0xED6D, 0xEC12, 0xEB9C,
    0xE693, 0xDDC3, 0xDAD0, 0xD80E, 0xD21E, 0xD285, 0xD1BB, 0xD6BB, 0xD645, 0xD648, 0xD898, 0xD449, 0xD22C, 0xD220, 0xD5C2, 0xD3F7,
    0xD66A, 0xDBF6, 0xE037, 0xE1F4, 0xE107, 0xDE6F, 0xDC21, 0xE167, 0xE27D, 0xDE2C, 0xD77E, 0xD142, 0xCFCE, 0xCC6E, 0xC674, 0xC519,
    0xC8DB, 0xC801, 0xC5AE, 0xC1BC, 0xC066, 0xC4F1, 0xC6FB, 0xC7DD, 0xCA0D, 0xCF6B, 0xD636, 0xDDF9, 0xEA50, 0xF435, 0xFA53, 0x0084,
    0x0054, 0xFE94, 0xFAEC, 0xFA5B, 0xFCA3, 0xF724, 0xF522, 0xF5A9, 0xFC03, 0xFF96, 0x01AD, 0x06DA, 0x015F, 0xF774, 0xF10A, 0xECD6,
    0xEA55, 0xE85E, 0xE6D4, 0xE77E, 0xE3FE, 0xE759, 0xEA28, 0xE78C, 0xE266, 0xE1DA, 0xE01D, 0xDB61, 0xD9B1, 0xDD2A, 0xE434, 0xEB6A,
    0xF4CB, 0xF646, 0xFD06, 0x05A4, 0x0E78, 0x1240, 0x10A6, 0x0B2F, 0x0B82, 0x0EC6, 0x0EE0, 0x1007, 0x118C, 0x12D9, 0x0D6B, 0x0662,
    0xFD0C, 0xF7C9, 0xF6E8, 0xF492, 0xF1E3, 0xF3FB, 0xF673, 0xFD29, 0x05B3, 0x1092, 0x18EA, 0x1DDC, 0x2002, 0x1A33, 0x1513, 0x121C,
    0x11E0, 0x0FA5, 0x0B94, 0x092C, 0x0C2A, 0x0DE7, 0x1269, 0x1783, 0x12F7, 0x07EF, 0xFCA4, 0xF20C, 0xE641, 0xE3D5, 0xE379, 0xE1A9,
    0xE0E1, 0xE0AF, 0xE64C, 0xE667, 0xE1AC, 0xE24A, 0xE518, 0xE5FB, 0xE81F, 0xECA9, 0xF19A, 0xFB6D, 0x02F8, 0x03B7, 0x075B, 0x1068,
    0x180D, 0x1C49, 0x1BC1, 0x1766, 0x180E, 0x1810, 0x1812, 0x183A, 0x1922, 0x1FAC, 0x240B, 0x240C, 0x1E56, 0x1C5C, 0x1BF8, 0x190C,
    0x1A69, 0x1CA5, 0x1DAC, 0x1FED, 0x2443, 0x2BDD, 0x37DD, 0x4389, 0x4AC7, 0x4C5D, 0x4C36, 0x49A5, 0x496F, 0x4551, 0x3D3C, 0x3A1D,
    0x3A41, 0x3B54, 0x3E0C, 0x4331, 0x41F9, 0x39F4, 0x295B, 0x1911, 0x0BD3, 0xFFCD, 0xFE09, 0xFAD8, 0xFAE3, 0xFD7C, 0xFF1E, 0x0200,
    0xFE95, 0xFFEE, 0xFFA8, 0xFFEB, 0x0202, 0x0099, 0x02E3, 0x0985, 0x11C5, 0x1898, 0x1A91, 0x1DD5, 0x25BE, 0x2B73, 0x3106, 0x2FBC,
    0x2DFE, 0x2EDF, 0x2DDA, 0x2EA5, 0x2FC4, 0x353E, 0x3BCF, 0x3AAF, 0x37D6, 0x371A, 0x345E, 0x305E, 0x3047, 0x3072, 0x2E2C, 0x2DD5,
    0x2D7B, 0x2B0F, 0x2D88, 0x33FF, 0x39E0, 0x3D45, 0x3B25, 0x3AC0, 0x39A9, 0x3913, 0x376F, 0x35CF, 0x3518, 0x353C, 0x3AD7, 0x43E5,
    0x48C7, 0x4811, 0x43E5, 0x391A, 0x2F0F, 0x27D8, 0x22A9, 0x1D32, 0x17D8, 0x1410, 0x11D6, 0x1239, 0x1124, 0x0FFC, 0x1088, 0x0E7D,
    0x0ED1, 0x0ACA, 0x06B7, 0x0A9C, 0x0F06, 0x1449, 0x140D, 0x12EE, 0x15E6, 0x1B9D, 0x1FA6, 0x1E23, 0x1EB9, 0x20AE, 0x2138, 0x21AC,
    0x1DD7, 0x1ED2, 0x2583, 0x2275, 0x1F10, 0x1C95, 0x165A, 0x130F, 0x12F9, 0x1256, 0x0DBB, 0x0C69, 0x0AE4, 0x084C, 0x0AC6, 0x122F,
    0x2003, 0x2B85, 0x2FEB, 0x34C9, 0x35EB, 0x32AA, 0x2F97, 0x29B3, 0x2355, 0x2057, 0x21BE, 0x245C, 0x29BC, 0x2D24, 0x29DD, 0x1F21,
    0x11CD, 0x0824, 0xFF3F, 0xF91C, 0xF75A, 0xF702, 0xF825, 0xF902, 0xF7A6, 0xF6E4, 0xF57B, 0xF7B3, 0xF9E5, 0xF8F5, 0xF5CD, 0xF790,
    0x0181, 0x084C, 0x0E9B, 0x1043, 0x1139, 0x18A5, 0x1C8C, 0x1F6D, 0x1F5F, 0x1E22, 0x1EFE, 0x19C9, 0x158B, 0x1432, 0x11A1, 0x0F70,
    0x0AA9, 0x043F, 0xFCC2, 0xF54E, 0xF26E, 0xF37F, 0xF339, 0xF4F1, 0xF60B, 0xF551, 0xF610, 0xFB27, 0x05D1, 0x10F3, 0x1DBC, 0x24EE,
    0x27DF, 0x25D7, 0x1F93, 0x1D69, 0x18BA, 0x1397, 0x13E4, 0x14AF, 0x1706, 0x1BD8, 0x1D74, 0x1654, 0x0BFB, 0x0184, 0xF7F1, 0xF1E5,
    0xEB05, 0xE73D, 0xE3D7, 0xE29B, 0xE221, 0xE01F, 0xDF15, 0xDEDD, 0xE00C, 0xDC3C, 0xD261, 0xCCD0, 0xCBE3, 0xCC90, 0xCF87, 0xD045,
    0xD13A, 0xD3B2, 0xDBC8, 0xE27B, 0xE5F8, 0xECD2, 0xF297, 0xF676, 0xF6EB, 0xF99A, 0xFE29, 0xFFBA, 0x017B, 0x0455, 0x0249, 0xFB8E,
    0xF8B2, 0xF3C8, 0xED7A, 0xEB0C, 0xEA68, 0xE798, 0xE4C9, 0xE635, 0xECCC, 0xF516, 0xFF03, 0x0A90, 0x0EB4, 0x1032, 0x0BAE, 0x0750,
    0x004A, 0xF5DE, 0xF177, 0xEC9E, 0xEBEA, 0xF0F4, 0xF428, 0xF28A, 0xEC75, 0xE195, 0xD5B4, 0xCA77, 0xC1B5, 0xB926, 0xB413, 0xB13A,
    0xAF7C, 0xAF48, 0xACC7, 0xAAF0, 0xAC6F, 0xABE0, 0xA6E8, 0xA27B, 0xA2C6, 0xA655, 0xAA4E, 0xAF1A, 0xB227, 0xB7BC, 0xBE71, 0xC38E,
    0xC725, 0xCB16, 0xCE8C, 0xD17D, 0xD1F6, 0xD21A, 0xD3D4, 0xD4BE, 0xD99F, 0xDC6C, 0xDB90, 0xDB3D, 0xDC79, 0xDC80, 0xDC19, 0xDDA8,
    0xDF01, 0xDDDC, 0xDA2F, 0xD85D, 0xD9F3, 0xE254, 0xF0F9, 0x0199, 0x0CC9, 0x13FE, 0x17E2, 0x1556, 0x0F26, 0x0B89, 0x0A9B, 0x082E,
    0x08EB, 0x0D1A, 0x132F, 0x15F4, 0x12CE, 0x0914, 0xFBAF, 0xED94, 0xDFFC, 0xD35E, 0xC9D2, 0xC426, 0xBF20, 0xBBE1, 0xB915, 0xB802,
    0xB98F, 0xBA87, 0xB943, 0xB66A, 0xB19C, 0xB1A7, 0xB625, 0xB941, 0xB9F0, 0xBD40, 0xC251, 0xC63F, 0xC959, 0xCD47, 0xD232, 0xD4C2,
    0xD4C1, 0xD4F0, 0xD8B9, 0xD839, 0xD96E, 0xDE35, 0xE09B, 0xE1FA, 0xE417, 0xE5CC, 0xE539, 0xE71D, 0xEA5F, 0xEBC0, 0xECC3, 0xEE20,
    0xEDC4, 0xF0CE, 0xF6DC, 0x0259, 0x0D97, 0x12F3, 0x1592, 0x14A5, 0x1379, 0x0EC9, 0x0AAA, 0x082A, 0x06C7, 0x0AA3, 0x11AE, 0x1A62,
    0x203C, 0x1FC5, 0x1DC2, 0x1A7F, 0x150A, 0x0DB5, 0x072D, 0xFFC7, 0xFB09, 0xF961, 0xF4A8, 0xF105, 0xEDA4, 0xED15, 0xECC8, 0xE8EE,
    0xE2A8, 0xE058, 0xE28D, 0xE202, 0xE344, 0xE675, 0xE743, 0xEA67, 0xECAF, 0xEFEB, 0xF151, 0xF0F0, 0xF34D, 0xF302, 0xF15C, 0xEDEB,
    0xF033, 0xF34C, 0xF146, 0xF05E, 0xF33A, 0xF166, 0xED2F, 0xEBDB, 0xEA6D, 0xE9A2, 0xE72E, 0xE45D, 0xE053, 0xE105, 0xE5D9, 0xEC9B,
    0xF722, 0x009F, 0x0907, 0x0DF8, 0x0EB9, 0x0F44, 0x106B, 0x129B, 0x131A, 0x1406, 0x1928, 0x1FEF, 0x26EB, 0x28B2, 0x26F5, 0x238C,
    0x1BCE, 0x1279, 0x088C, 0x021E, 0x004A, 0x00EF, 0xFFE3, 0xFE21, 0xFC6A, 0xFEDD, 0x0325, 0x0170, 0xFB5C, 0xF767, 0xFAA0, 0xFD36,
    0x0391, 0x0CD1, 0x13D6, 0x19BA, 0x1F43, 0x240F, 0x27C1, 0x2C78, 0x300F, 0x3516, 0x3813, 0x3979, 0x39D2, 0x3A1E, 0x3A6B, 0x36BB,
    0x3512, 0x2F07, 0x28AE, 0x24F2, 0x1DE9, 0x19A5, 0x14FF, 0x0F04, 0x0A2F, 0x058E, 0x0683, 0x0BFF, 0x14F0, 0x21CA, 0x29DA, 0x2F6C,
    0x31DA, 0x31FB, 0x332D, 0x31BD, 0x324E, 0x3430, 0x33C2, 0x384E, 0x3D58, 0x40AD, 0x41E6, 0x3E09, 0x3B5B, 0x340F, 0x2AC7, 0x2315,
    0x1A65, 0x1715, 0x1653, 0x13E3, 0x1111, 0x111A, 0x16AD, 0x16EA, 0x1313, 0x1148, 0x0EB2, 0x0DBC, 0x0F09, 0x11A8, 0x153E, 0x169C,
    0x19D4, 0x1C49, 0x1D00, 0x1FF4, 0x2270, 0x28B0, 0x2A26, 0x2B0D, 0x2E4C, 0x3089, 0x344F, 0x36BE, 0x3C0E, 0x3EFA, 0x403F, 0x3F75,
    0x3982, 0x3693, 0x3326, 0x2D9E, 0x29D1, 0x2341, 0x1F10, 0x1D6D, 0x1FB2, 0x28A1, 0x3063, 0x3969, 0x3D4A, 0x3EEE, 0x4050, 0x3D96,
    0x3AC8, 0x36D1, 0x33E4, 0x334A, 0x3671, 0x3A3F, 0x3A6E, 0x38A0, 0x35B2, 0x2EA4, 0x25B0, 0x1BD0, 0x1197, 0x0976, 0x057C, 0x00FA,
    0xF970, 0xF42A, 0xF38C, 0xF3A7, 0xEDA3, 0xE78A, 0xE2B3, 0xDE25, 0xDD24, 0xDEDF, 0xE353, 0xE5C5, 0xE7B4, 0xEC66, 0xED71, 0xF12C,
    0xF828, 0x0164, 0x0BE4, 0x0F9C, 0x157B, 0x16EA, 0x15F1, 0x17F0, 0x15D3, 0x15CF, 0x1592, 0x14FF, 0x1525, 0x1273, 0x11B5, 0x109E,
    0x0D20, 0x0974, 0x0448, 0x03D6, 0x0406, 0x063D, 0x0EAC, 0x159F, 0x1DAC, 0x2438, 0x29A4, 0x2E80, 0x2F64, 0x30EF, 0x2F0D, 0x2BC2,
    0x2D5E, 0x310E, 0x3640, 0x399C, 0x3CD4, 0x3DDD, 0x38DD, 0x2F28, 0x2125, 0x153C, 0x0CD1, 0x02ED, 0xF7A5, 0xED63, 0xE5BA, 0xE173,
    0xDD75, 0xD865, 0xD18E, 0xCC88, 0xCC3C, 0xCD4D, 0xD090, 0xD3F9, 0xD754, 0xDB21, 0xDD1C, 0xDF07, 0xE4CE, 0xECF4, 0xF4B0, 0xFAEF,
    0xFEA2, 0x005C, 0x01B1, 0x0111, 0x0148, 0x0481, 0x0882, 0x0981, 0x08CF, 0x0725, 0x0295, 0x0103, 0xFFA3, 0xFF76, 0xFEAB, 0xFD85,
    0xFE6E, 0x00AE, 0x07C7, 0x0E6A, 0x1521, 0x1A67, 0x1C92, 0x1C3A, 0x1C62, 0x1C47, 0x1865, 0x1450, 0x108E, 0x10DE, 0x0F3C, 0x0E17,
    0x0F47, 0x0E01, 0x0FE5, 0x0C51, 0x06A8, 0x0099, 0xFCC4, 0xFC53, 0xF32A, 0xED42, 0xE87F, 0xE2DC, 0xE18C, 0xDC06, 0xD80E, 0xD32F,
    0xCB7B, 0xC9A1, 0xC958, 0xCCB6, 0xD0C1, 0xD3FA, 0xD817, 0xD84D, 0xDB78, 0xDF56, 0xE36A, 0xE9FF, 0xECB7, 0xEE9B, 0xF12A, 0xF09A,
    0xF008, 0xF0F8, 0xF365, 0xF3EC, 0xF2C9, 0xF153, 0xEC9C, 0xE9B6, 0xE712, 0xE4FD, 0xE31D, 0xE200, 0xDECB, 0xDB52, 0xDBB8, 0xDDDB,
    0xE3A4, 0xE74E, 0xEC5C, 0xF351, 0xF644, 0xFA45, 0xFBBD, 0xFAA0, 0xF890, 0xF7E6, 0xFE9B, 0x0187, 0x0619, 0x0C6D, 0x0F45, 0x0ED9,
    0x0495, 0xFB42, 0xF272, 0xE959, 0xE31D, 0xDCD0, 0xD94E, 0xD591, 0xD5A9, 0xD7C2, 0xD2FB, 0xCE85, 0xC94A, 0xC7AE, 0xC830, 0xC729,
    0xCD19, 0xD08B, 0xD45F, 0xD85E, 0xDB50, 0xE2AD, 0xE96E, 0xF530, 0xFC1A, 0xFFCF, 0x0659, 0x0692, 0x08AA, 0x0B81, 0x101B, 0x1616,
    0x191C, 0x1B34, 0x15DD, 0x0F4B, 0x08F0, 0x00F4, 0xFBEE, 0xF4B2, 0xF079, 0xEDD3, 0xE984, 0xE9AE, 0xEC54, 0xF22F, 0xF5D1, 0xFBE0,
    0x03C5, 0x08EC, 0x1091, 0x1204, 0x11D5, 0x134A, 0x1583, 0x192D, 0x1A17, 0x1D55, 0x21F5, 0x24E4, 0x2074, 0x1721, 0x1084, 0x06FC,
    0xFFDE, 0xF9C5, 0xF04E, 0xE992, 0xE36F, 0xE0BE, 0xDD28, 0xD848, 0xD6B9, 0xD420, 0xD473, 0xD4F9, 0xD7AF, 0xDDB7, 0xDD5A, 0xE018,
    0xE170, 0xE11A, 0xE6DD, 0xECCC, 0xF36E, 0xF4F2, 0xF7B8, 0xF8A4, 0xF336, 0xF3EF, 0xF52D, 0xFA08, 0x01B3, 0x04E1, 0x09A3, 0x09C1,
    0x09FE, 0x0B32, 0x0B26, 0x0CD0, 0x0A25, 0x095D, 0x054E, 0x02AF, 0x0667, 0x078C, 0x0B8C, 0x0F35, 0x1376, 0x1CAC, 0x2486, 0x2AF8,
    0x2C84, 0x2DC1, 0x2F76, 0x2DFA, 0x2D99, 0x2B08, 0x2ECC, 0x3468, 0x329D, 0x2DA5, 0x2635, 0x1DB3, 0x1482, 0x0BE5, 0x029F, 0xF712,
    0xEE4D, 0xE851, 0xE1BE, 0xDB0E, 0xD37F, 0xCE01, 0xC737, 0xC1DC, 0xBEE4, 0xBDD6, 0xBD38, 0xBC01, 0xBCAD, 0xBBBB, 0xBE51, 0xC278,
    0xC6CA, 0xCD1C, 0xD0F1, 0xD30B, 0xD57D, 0xD8D2, 0xDD94, 0xE046, 0xE70E, 0xEBB2, 0xEC4A, 0xEB6D, 0xE5D6, 0xE52D, 0xE35F, 0xE207,
    0xE597, 0xE870, 0xE971, 0xE9B1, 0xEB9E, 0xEE26, 0xF03A, 0xF632, 0xFB6D, 0x04D8, 0x11E0, 0x1AA8, 0x22A5, 0x263F, 0x2A27, 0x2F57,
    0x327E, 0x35EF, 0x3B11, 0x4348, 0x4817, 0x477B, 0x4752, 0x4277, 0x3F09, 0x3DA2, 0x38DA, 0x311C, 0x26D4, 0x1CC9, 0x1204, 0x05AE,
    0xF8D7, 0xF06D, 0xE9A5, 0xE1A7, 0xDAFD, 0xD7E6, 0xD525, 0xD2F0, 0xD116, 0xCF42, 0xD091, 0xD5D1, 0xDA5D, 0xDE25, 0xE304, 0xE595,
    0xE7A9, 0xE6F9, 0xE72B, 0xEA94, 0xEFAF, 0xF32C, 0xF502, 0xF71A, 0xF4C5, 0xEFFF, 0xED10, 0xE9F4, 0xEA04, 0xEA08, 0xE863, 0xE945,
    0xE909, 0xED82, 0xF3DA, 0xF8A8, 0xFB98, 0x0135, 0x0E76, 0x167E, 0x1C52, 0x239A, 0x2693, 0x2AC5, 0x2B9C, 0x2978, 0x2A65, 0x2C89,
    0x30B9, 0x301C, 0x2C31, 0x263C, 0x2093, 0x1D92, 0x18B5, 0x16CF, 0x143D, 0x0DD6, 0x0B72, 0x0985, 0x0541, 0x0128, 0xFC0D, 0xF5A5,
    0xEE02, 0xE951, 0xE62C, 0xE52E, 0xE51D, 0xE43D, 0xE4CD, 0xE6CD, 0xEA54, 0xF03E, 0xF6AE, 0xF86E, 0xFAE3, 0xFD37, 0xFAA0, 0xFA56,
    0xFD74, 0x013B, 0x061F, 0x06A0, 0x0504, 0x00D2, 0xFBDA, 0xF6F8, 0xF2CB, 0xF3B3, 0xF088, 0xEF29, 0xED2F, 0xE851, 0xEA3D, 0xE9B6,
    0xE618, 0xE68E, 0xE9DB, 0xEFC0, 0xF512, 0xF8EA, 0xFB98, 0xFD73, 0x023A, 0x01EA, 0x0387, 0x0863, 0x0D22, 0x14F6, 0x156E, 0x1383,
    0x1310, 0x12C6, 0x1059, 0x0A75, 0x05AD, 0xFD9D, 0xF5B9, 0xF042, 0xE8A7, 0xE5D3, 0xE3B7, 0xDF9E, 0xDBEE, 0xD6D9, 0xD447, 0xD326,
    0xD395, 0xD410, 0xD62F, 0xDB4B, 0xDECE, 0xE4A2, 0xEC38, 0xF11B, 0xF6AD, 0xFC5A, 0xFF21, 0x03F8, 0x0BD4, 0x12B9, 0x19DF, 0x2005,
    0x243B, 0x2647, 0x23BD, 0x2128, 0x2006, 0x1E08, 0x1B79, 0x17AF, 0x1212, 0x09B8, 0x06A7, 0x0519, 0xFCBA, 0xF956, 0xF949, 0xFAE6,
    0xFE23, 0xFFF8, 0x0508, 0x087B, 0x0CD8, 0x110E, 0x13F5, 0x178F, 0x18F8, 0x207B, 0x24D8, 0x21DC, 0x2304, 0x212D, 0x1FEF, 0x1F99,
    0x1BD8, 0x15DF, 0x0C47, 0x0596, 0xFCAF, 0xF4D7, 0xF140, 0xEA82, 0xE5F8, 0xE00F, 0xD9DB, 0xDA9B, 0xDA67, 0xDB14, 0xDEF6, 0xE23C,
    0xE47C, 0xE9BA, 0xF18F, 0xF51B, 0xFA0E, 0xFFF0, 0x00CF, 0x0084, 0x0141, 0x046E, 0x0829, 0x0AD6, 0x0AAB, 0x0AA0, 0x0872, 0x0129,
    0x0130, 0x01BD, 0x0441, 0x0A44, 0x0B50, 0x0CE4, 0x0F1C, 0x1367, 0x1154, 0x0B0B, 0x0A94, 0x086B, 0x0A95, 0x0EFE, 0x11FB, 0x1A58,
    0x1EE9, 0x2379, 0x26B9, 0x25AF, 0x2848, 0x2B65, 0x2FFA, 0x2DD1, 0x2AFF, 0x2B40, 0x246F, 0x2361, 0x1FCD, 0x1815, 0x1387, 0x0799,
    0xFF7B, 0xF7F8, 0xEFEB, 0xEA3C, 0xE087, 0xD8EC, 0xCD8A, 0xC7FF, 0xC61C, 0xC2A3, 0xC63E, 0xC643, 0xC5E1, 0xC5FC, 0xC5A9, 0xC796,
    0xC8F9, 0xCD19, 0xD060, 0xD524, 0xDBF3, 0xE037, 0xE984, 0xF13E, 0xF49A, 0xF995, 0xF940, 0xF691, 0xF448, 0xF184, 0xF203, 0xF5B5,
    0xF9D0, 0xF6A3, 0xF7CD, 0xFC20, 0xFB9C, 0xFB9B, 0xF859, 0xF981, 0xFCB0, 0xFFC3, 0x03AF, 0x0AAF, 0x1485, 0x1B2C, 0x2340, 0x26EE,
    0x2732, 0x2B23, 0x2DA2, 0x2EF0, 0x306B, 0x31AD, 0x34CD, 0x3756, 0x39D7, 0x38FC, 0x371F, 0x328B, 0x2790, 0x22F4, 0x1B09, 0x11A7,
    0x0D6B, 0x00C5, 0xF3E4, 0xE6C6, 0xDC9C, 0xD5BA, 0xCF6B, 0xD02F, 0xCDC5, 0xCD57, 0xCCA3, 0xCA1E, 0xCEE4, 0xD0D0, 0xD4B6, 0xDCB3,
    0xE141, 0xE885, 0xF068, 0xF71C, 0xFC65, 0x01C4, 0x0823, 0x04EA, 0x037B, 0x0424, 0x019A, 0x042D, 0x024F, 0x00C3, 0x0142, 0x00D3,
    0x02D8, 0x02C5, 0x01B5, 0xFD8C, 0xFEB5, 0x02B1, 0x0439, 0x0D51, 0x170A, 0x21E4, 0x2E67, 0x351E, 0x38CE, 0x3CCB, 0x4066, 0x428C,
    0x41AC, 0x4073, 0x3E2E, 0x3C34, 0x3929, 0x32F9, 0x2ECB, 0x24F0, 0x1A8E, 0x12DE, 0x0B7E, 0x0522, 0x02AC, 0x00A7, 0xF84C, 0xF238,
    0xEB10, 0xE5AC, 0xE29B, 0xDE30, 0xDC47, 0xDB16, 0xDA79, 0xD946, 0xDB52, 0xDE04, 0xDF72, 0xE4AE, 0xE71B, 0xE987, 0xF298, 0xFA9A,
    0x00F2, 0x08CC, 0x0CDD, 0x0D8D, 0x0A34, 0x0545, 0x022C, 0x0438, 0x0766, 0x04A0, 0x061F, 0x066A, 0x0651, 0x07CB, 0x0241, 0xFCBA,
    0xF89C, 0xF516, 0xF24B, 0xF359, 0xF904, 0xFF53, 0x08EB, 0x0E84, 0x0ECE, 0x0F42, 0x0DDD, 0x0DFF, 0x1133, 0x1340, 0x166D, 0x1D49,
    0x1E0A, 0x1C92, 0x1CC7, 0x169E, 0x0C7B, 0x03B3, 0xFD13, 0xF510, 0xEF9B, 0xECC5, 0xE66C, 0xDE83, 0xD4DC, 0xCB10, 0xC7F5, 0xC493,
    0xC487, 0xC84D, 0xC70F, 0xC861, 0xC935, 0xC9FF, 0xCC4E, 0xD0A0, 0xD7E0, 0xDA24, 0xE1BF, 0xE913, 0xED4E, 0xF5E3, 0xFB37, 0x03E3,
    0x0A85, 0x0B8E, 0x0E5D, 0x139B, 0x1861, 0x19FF, 0x1D5E, 0x1F17, 0x2003, 0x26CA, 0x277C, 0x22AB, 0x1F09, 0x182B, 0x120E, 0x0B6B,
    0x08E1, 0x0C9E, 0x14BB, 0x1CC9, 0x1EBF, 0x2288, 0x2191, 0x2056, 0x25B6, 0x24FB, 0x285B, 0x2DAE, 0x301F, 0x3079, 0x2FF8, 0x3050,
    0x2A75, 0x25F1, 0x1E6D, 0x15EB, 0x1121, 0x098B, 0x0207, 0xF961, 0xEE15, 0xE449, 0xDC1E, 0xD46A, 0xD018, 0xD09D, 0xD049, 0xCE3C,
    0xD080, 0xD0CE, 0xD22F, 0xD806, 0xDC12, 0xE2C0, 0xEA5E, 0xF2F7, 0xF9BB, 0x0011, 0x05C4, 0x06A1, 0x0890, 0x034E, 0xFC3E, 0xF934,
    0xF4CE, 0xF213, 0xF15F, 0xF1C8, 0xF481, 0xFBA9, 0x022D, 0x0588, 0x07E4, 0x06E3, 0x0297, 0x01B1, 0xFFDC, 0x01A9, 0x0B15, 0x1355,
    0x1E0E, 0x2582, 0x269D, 0x27DE, 0x2AAD, 0x2CB7, 0x2D59, 0x32F5, 0x3775, 0x387E, 0x3B86, 0x3A64, 0x3556, 0x3152, 0x28CF, 0x2039,
    0x1AD4, 0x13EE, 0x1054, 0x0A80, 0x0086, 0xF5EF, 0xEC46, 0xE229, 0xD7F2, 0xD530, 0xD2DE, 0xCFF5, 0xCFE0, 0xCC7B, 0xCA16, 0xCA10,
    0xC77E, 0xC654, 0xC7D7, 0xC8D8, 0xCB99, 0xD10C, 0xD5F0, 0xDCE5, 0xE67F, 0xE954, 0xE6F4, 0xE56F, 0xE175, 0xDE5F, 0xDC64, 0xD915,
    0xD960, 0xDF87, 0xE63A, 0xE8F3, 0xEC91, 0xEBD7, 0xE914, 0xE62E, 0xDDD0, 0xDD7D, 0xE44A, 0xEC75, 0xF796, 0x03C3, 0x0C8A, 0x0FDC,
    0x14E0, 0x18DF, 0x1C93, 0x22DD, 0x2508, 0x2870, 0x2D1C, 0x2CE6, 0x2EDB, 0x319B, 0x318E, 0x325D, 0x3247, 0x30DF, 0x2E5F, 0x2E4D,
    0x288F, 0x1E93, 0x17AA, 0x0BBC, 0x031B, 0xFD7E, 0xF790, 0xF3C6, 0xEEB1, 0xE876, 0xE119, 0xDDAA, 0xDBE0, 0xDABE, 0xDEB3, 0xE066,
    0xE337, 0xE97D, 0xEB73, 0xF160, 0xF90E, 0xFE05, 0x0127, 0x0044, 0xFEDF, 0xFB97, 0xFAB1, 0xF837, 0xF3AB, 0xF68E, 0xF886, 0xFD06,
    0xFF45, 0xF976, 0xF7E4, 0xF2AB, 0xEA1B, 0xE2A4, 0xE0B0, 0xE4E6, 0xEB96, 0xF76F, 0xFE83, 0x0534, 0x0E96, 0x11D6, 0x17AA, 0x1FC2,
    0x25DF, 0x2D0D, 0x3189, 0x33B2, 0x3448, 0x347A, 0x303C, 0x289B, 0x249B, 0x1B6A, 0x13A7, 0x0F35, 0x07AB, 0x02D1, 0xFC3B, 0xF55D,
    0xEDA8, 0xE8BD, 0xE690, 0xE46C, 0xE664, 0xE253, 0xE1D1, 0xE3BB, 0xDEC0, 0xDE39, 0xDFC0, 0xE2AB, 0xE74A, 0xEBE4, 0xF247, 0xF70C,
    0x0145, 0x08E3, 0x0A2C, 0x0ED2, 0x0BEC, 0x0C4B, 0x0B03, 0x0362, 0x01FA, 0xFEFB, 0x00F3, 0x0512, 0x0A5D, 0x0D2B, 0x08A7, 0x0767,
    0xFD52, 0xF1E6, 0xEC39, 0xE457, 0xE6ED, 0xECD8, 0xF25F, 0xF858, 0xF98A, 0xFABB, 0xFAB6, 0xFBBE, 0xFA44, 0xFA84, 0x018B, 0x010E,
    0x02AA, 0x082A, 0x093C, 0x0B70, 0x0A34, 0x07EB, 0x033A, 0xFD96, 0xF784, 0xEF78, 0xE9B5, 0xDFD9, 0xD9A6, 0xD5E2, 0xCFBB, 0xD007,
    0xD08B, 0xCDF2, 0xCA56, 0xC842, 0xC6E7, 0xC6DE, 0xCA79, 0xCD46, 0xD365, 0xDC5F, 0xE1C8, 0xE77E, 0xF034, 0xF8E9, 0x01DB, 0x060D,
    0x04FF, 0x0525, 0x05E2, 0x04A1, 0x0531, 0x0A6A, 0x0F7F, 0x1949, 0x22A2, 0x26C8, 0x2AC4, 0x2C24, 0x282C, 0x1F0B, 0x17F1, 0x0FE8,
    0x0A2B, 0x0A46, 0x0974, 0x0C38, 0x0EB9, 0x0D5F, 0x0ED6, 0x1046, 0x0FA6, 0x110C, 0x126C, 0x10CD, 0x0FE8, 0x11DB, 0x12D4, 0x145F,
    0x1787, 0x16EE, 0x1472, 0x11AE, 0x0A87, 0x048F, 0xFDD2, 0xF373, 0xEBCF, 0xE271, 0xD8DD, 0xD456, 0xD112, 0xCC65, 0xC8F4, 0xC769,
    0xC2F6, 0xC012, 0xC19D, 0xC212, 0xC72D, 0xCFCA, 0xD71D, 0xE21C, 0xED82, 0xFABE, 0x0B0C, 0x1762, 0x1D04, 0x1DF3, 0x2013, 0x1A82,
    0x1309, 0x0F03, 0x0792, 0x0943, 0x0DF6, 0x10D7, 0x167C, 0x19DB, 0x1AB4, 0x17DA, 0x1154, 0x09DA, 0x040E, 0x0593, 0x08BF, 0x0E79,
    0x1886, 0x1BAE, 0x2034, 0x2344, 0x21BA, 0x24D0, 0x26E5, 0x271F, 0x27D6, 0x281E, 0x289F, 0x29A8, 0x2A58, 0x29B4, 0x2A10, 0x2875,
    0x2198, 0x1C3C, 0x16E7, 0x0CCD, 0x03E1, 0xFA96, 0xEFED, 0xE808, 0xE282, 0xDB9F, 0xD5E4, 0xD2FA, 0xCC1A, 0xC7CA, 0xC36B, 0xBE00,
    0xBDC1, 0xBDF4, 0xBE6B, 0xC19A, 0xC67F, 0xCC5B, 0xD55A, 0xDEFD, 0xE3C9, 0xE769, 0xE9B0, 0xE835, 0xE93E, 0xEA41, 0xE910, 0xEA4F,
    0xEDEA, 0xF026, 0xF35D, 0xF793, 0xF887, 0xF956, 0xF8A3, 0xF145, 0xEC6C, 0xE985, 0xE622, 0xEA5D, 0xEF87, 0xF4F6, 0xFC35, 0x062F,
    0x0DA5, 0x1303, 0x1C8A, 0x20C5, 0x2418, 0x2587, 0x2431, 0x2785, 0x2980, 0x2AFA, 0x2D66, 0x2CC1, 0x29B3, 0x27A2, 0x23B0, 0x1E42,
    0x1C13, 0x1905, 0x113E, 0x0B05, 0x090D, 0x0289, 0xFDF5, 0xF843, 0xF01B, 0xEC09, 0xE409, 0xDA4F, 0xD29D, 0xCFAB, 0xCD2E, 0xCCB4,
    0xD0EC, 0xD35D, 0xDD36, 0xE87F, 0xEC61, 0xF10A, 0xF172, 0xF064, 0xEFD7, 0xEE18, 0xEF5D, 0xF06E, 0xF4CB, 0xF765, 0xFA65, 0x01B5,
    0x0214, 0x0661, 0x08CE, 0x01CB, 0xFE26, 0xF58D, 0xEEE1, 0xED0C, 0xED48, 0xF2CB, 0xF6AF, 0xFE23, 0x0471, 0x0B9D, 0x1621, 0x1A86,
    0x22D6, 0x2B21, 0x2EBE, 0x3672, 0x3D52, 0x4428, 0x4B73, 0x4CF8, 0x4940, 0x42D3, 0x3B60, 0x2FC0, 0x24D0, 0x1C00, 0x1071, 0x07FB,
    0xFEC7, 0xF5D0, 0xF1CF, 0xED62, 0xE7B3, 0xE324, 0xDFEF, 0xD9CD, 0xD4BD, 0xD2EE, 0xD204, 0xD528, 0xD7F2, 0xDAC7, 0xE15C, 0xE9D1,
    0xF28C, 0xFA7F, 0xFF0B, 0xFE42, 0xFE04, 0xFC83, 0xF6FC, 0xF696, 0xF857, 0xF951, 0xFEB5, 0x02FE, 0x06D3, 0x0CB9, 0x10F8, 0x0FB3,
    0x0A2A, 0x0559, 0xFD86, 0xF92C, 0xF8D4, 0xF975, 0x0072, 0x04F6, 0x07C2, 0x0B8B, 0x0E10, 0x10BA, 0x116F, 0x118B, 0x0E68, 0x0EF9,
    0x124A, 0x11F2, 0x183A, 0x1EBC, 0x2011, 0x1F8E, 0x1B28, 0x169D, 0x119C, 0x0B6D, 0x02D0, 0xF9BD, 0xF2D5, 0xE880, 0xE1ED, 0xDB60,
    0xD321, 0xD1EE, 0xCDF1, 0xC819, 0xC30B, 0xBE16, 0xBB11, 0xB996, 0xBD63, 0xC11F, 0xC837, 0xD503, 0xDF6D, 0xEB74, 0xF302, 0xF33B,
    0xF499, 0xF23E, 0xEF82, 0xEFF6, 0xEE60, 0xEDC1, 0xF088, 0xF510, 0xFA04, 0x01B5, 0x0CFB, 0x16C6, 0x1E62, 0x1FD6, 0x1AD1, 0x1705,
    0x1345, 0x0FDF, 0x11F8, 0x154D, 0x183D, 0x1F69, 0x2351, 0x2458, 0x2798, 0x28FB, 0x283C, 0x269F, 0x2953, 0x2B9F, 0x2F06, 0x32F0,
    0x3208, 0x3501, 0x32EE, 0x2CA5, 0x29B9, 0x2498, 0x216A, 0x1C01, 0x1325, 0x0B17, 0x02F3, 0xFC78, 0xF330, 0xEDCF, 0xEA30, 0xE1AA,
    0xD9A1, 0xCE3E, 0xC485, 0xC0C5, 0xBE65, 0xBDCB, 0xBFDF, 0xC5EA, 0xCE2E, 0xD9A9, 0xE746, 0xF1B3, 0xFC04, 0x009C, 0x01E5, 0x0385,
    0x021A, 0x01E2, 0x0082, 0xFE0E, 0xF987, 0xF92C, 0xFAD3, 0xFAA2, 0xFEC6, 0xFF67, 0xFC9E, 0xF8FA, 0xF30D, 0xEF8D, 0xEFDE, 0xF25F,
    0xF626, 0xFC8E, 0x0500, 0x0AA9, 0x12B0, 0x194F, 0x1B81, 0x1F99, 0x2001, 0x210E, 0x2683, 0x2D01, 0x3351, 0x382E, 0x3919, 0x34DF,
    0x32B8, 0x2E4D, 0x29A0, 0x28A8, 0x2377, 0x1D42, 0x14AE, 0x0CD6, 0x03E1, 0xFAA8, 0xF780, 0xF0D9, 0xEC94, 0xE70F, 0xDC80, 0xD82F,
    0xD29D, 0xD01D, 0xD097, 0xCE96, 0xD2E2, 0xD8A1, 0xDF51, 0xE3E3, 0xE502, 0xE829, 0xE735, 0xE7AA, 0xE7FB, 0xE467, 0xE5B5, 0xE48F,
    0xE2E5, 0xE49D, 0xE658, 0xEBB3, 0xF18A, 0xF538, 0xF605, 0xF494, 0xEEEA, 0xE693, 0xE113, 0xDE59, 0xDE02, 0xE2D0, 0xE9D4, 0xEEAD,
    0xF65A, 0xFD40, 0x019E, 0x0862, 0x0D26, 0x10F1, 0x179F, 0x1D62, 0x22B6, 0x28E5, 0x2C42, 0x2BC0, 0x28E0, 0x27C7, 0x25FE, 0x23BE,
    0x203C, 0x1AFA, 0x18F8, 0x1403, 0x100C, 0x107B, 0x1088, 0x117D, 0x0F7E, 0x08A8, 0xFEEB, 0xF5A1, 0xEC7B, 0xE570, 0xE4A3, 0xE32C,
    0xE475, 0xEA18, 0xEF28, 0xF53E, 0xFB21, 0xFDE2, 0xFDD4, 0xFDDE, 0xFC6D, 0xF8C5, 0xF6E8, 0xF533, 0xF1E9, 0xF150, 0xF157, 0xF543,
    0xFDE8, 0x03BC, 0x08B2, 0x0A82, 0x073E, 0xFFE6, 0xF792, 0xF060, 0xE9EA, 0xEAB9, 0xEBA1, 0xECD9, 0xF1EA, 0xF43D, 0xF6A4, 0xF967,
    0xF9D1, 0xFD39, 0x0389, 0x0A89, 0x15B3, 0x221F, 0x2E68, 0x361C, 0x39BA, 0x3B9B, 0x39F2, 0x3B18, 0x3852, 0x311B, 0x2BF6, 0x23B2,
    0x1ADD, 0x14A3, 0x0C42, 0x0777, 0x068B, 0x00D3, 0xFA16, 0xF09B, 0xE9F3, 0xE2F9, 0xDDF0, 0xDF30, 0xDE1A, 0xE42D, 0xECC0, 0xF51D,
    0x00D7, 0x090B, 0x100F, 0x15D1, 0x1591, 0x1575, 0x158E, 0x1322, 0x1023, 0x0DFE, 0x0C73, 0x0A6B, 0x1003, 0x1840, 0x1E43, 0x26C1,
    0x28AB, 0x2481, 0x1EB4, 0x14E6, 0x0D5C, 0x0A72, 0x0AE0, 0x0D7F, 0x1276, 0x1620, 0x187F, 0x1B15, 0x17E4, 0x139D, 0x101C, 0x0C7C,
    0x0C28, 0x0DCE, 0x1149, 0x139B, 0x1502, 0x1528, 0x12B1, 0x1159, 0x0D09, 0x05C5, 0x001C, 0xF6DC, 0xEDF8, 0xE80B, 0xE0FF, 0xDD34,
    0xDA9A, 0xD75D, 0xD133, 0xC83E, 0xBE52, 0xB675, 0xB458, 0xB192, 0xB07D, 0xB4E3, 0xBAEC, 0xC1E9, 0xCB3B, 0xD4E9, 0xDE3A, 0xE967,
    0xEFDB, 0xF44A, 0xF95C, 0xFA2E, 0xFA20, 0xF903, 0xF74F, 0xF740, 0xFA5F, 0xFFE8, 0x0666, 0x1059, 0x1868, 0x1C12, 0x1F8C, 0x1D7D,
    0x1D3D, 0x1FB1, 0x1F8F, 0x246E, 0x27A4, 0x2BEC, 0x306D, 0x328B, 0x363B, 0x347F, 0x361C, 0x3554, 0x2F6C, 0x30F2, 0x30A1, 0x327F,
    0x3610, 0x3589, 0x367E, 0x33DF, 0x2F84, 0x29BD, 0x22D0, 0x1C44, 0x14E4, 0x1062, 0x0A24, 0x0343, 0x001E, 0xF984, 0xF216, 0xEA2C,
    0xDDE6, 0xD2E4, 0xC9E1, 0xC412, 0xC024, 0xBD12, 0xBB6D, 0xBD4B, 0xC2EF, 0xC8C4, 0xD107, 0xDB22, 0xE671, 0xEF73, 0xF846, 0x0130,
    0x071A, 0x0E6A, 0x1149, 0x12A2, 0x15AD, 0x18F4, 0x2012, 0x2688, 0x2A54, 0x2C3C, 0x2C58, 0x2733, 0x1F33, 0x19F6, 0x15DB, 0x13AA,
    0x1646, 0x191A, 0x1D6C, 0x2289, 0x24B6, 0x26E4, 0x289A, 0x2B6B, 0x2DC8, 0x3129, 0x35F3, 0x3DCB, 0x445E, 0x43DB, 0x4511, 0x43C1,
    0x3F6E, 0x3C33, 0x3478, 0x2D46, 0x271F, 0x213D, 0x1B73, 0x12CC, 0x0EF9, 0x0A8F, 0x02A7, 0xFB7C, 0xEE37, 0xE13B, 0xD706, 0xCBC5,
    0xC490, 0xC0B7, 0xBF71, 0xC082, 0xC24A, 0xC4BE, 0xC931, 0xCEA4, 0xD20A, 0xD4B0, 0xD93F, 0xDA8B, 0xDACF, 0xDBE7, 0xDB0E, 0xDC22,
    0xDC01, 0xDB46, 0xDDE5, 0xE14E, 0xE65F, 0xEC99, 0xEFE6, 0xF33B, 0xF4BD, 0xF3CC, 0xF234, 0xEF32, 0xF078, 0xEED5, 0xED5D, 0xEF3B,
    0xEF1C, 0xF4AE, 0xFA72, 0xFFB0, 0x053E, 0x08E8, 0x0E80, 0x159A, 0x1F15, 0x298C, 0x3192, 0x3833, 0x3A2B, 0x38F2, 0x37EB, 0x3131,
    0x2C06, 0x2808, 0x229A, 0x1F1C, 0x1967, 0x1565, 0x1256, 0x0E99, 0x0827, 0x00A7, 0xFABD, 0xF42E, 0xF0B4, 0xEB9C, 0xE64E, 0xE3E0,
    0xE35F, 0xE479, 0xE7F5, 0xEE74, 0xF524, 0xFB2B, 0xFEAA, 0x0082, 0x0062, 0x00F7, 0xFEE3, 0xFCF4, 0xFC49, 0xFA2D, 0xF947, 0xF997,
    0xFC37, 0xFF31, 0x0530, 0x095A, 0x0B58, 0x0C18, 0x0958, 0x08D4, 0x060F, 0x0402, 0x0565, 0x06E0, 0x0697, 0x0784, 0x0946, 0x08C2,
    0x090E, 0x04CB, 0x038E, 0x052B, 0x0A04, 0x1257, 0x1BD3, 0x26E3, 0x3070, 0x37F7, 0x3B55, 0x3B46, 0x393A, 0x396B, 0x34B8, 0x32B9,
    0x2F51, 0x2793, 0x222D, 0x1667, 0x0C32, 0xFF5A, 0xF13F, 0xE518, 0xD960, 0xD378, 0xCE47, 0xCA57, 0xC8B6, 0xC781, 0xC8B7, 0xCC54,
    0xD001, 0xD93F, 0xE198, 0xE8D0, 0xF020, 0xF2A9, 0xF573, 0xF5C0, 0xF542, 0xF208, 0xF27B, 0xF3F2, 0xF320, 0xF664, 0xF95A, 0xFD8B,
    0x0115, 0x0315, 0x03CB, 0x0483, 0x03D0, 0x0307, 0x01FE, 0x0048, 0x0224, 0x03AC, 0x07F7, 0x0BD0, 0x111F, 0x166D, 0x167E, 0x174B,
    0x18B2, 0x1BC9, 0x201B, 0x24AB, 0x2696, 0x29A8, 0x29C6, 0x27E5, 0x253B, 0x208C, 0x1E14, 0x1C00, 0x195E, 0x14B3, 0x119A, 0x0C10,
    0x050A, 0xFF5D, 0xF61B, 0xECCD, 0xE221, 0xD85E, 0xD0BE, 0xC8F5, 0xC26E, 0xBCF7, 0xBB98, 0xBD3A, 0xC16E, 0xCA16, 0xD458, 0xDD44,
    0xE6D1, 0xEB30, 0xEE2F, 0xF17C, 0xF37D, 0xF5E8, 0xF62B, 0xF75D, 0xF627, 0xF5F2, 0xF573, 0xF64C, 0xFB13, 0xFEE0, 0x022D, 0x03C9,
    0x043D, 0x0416, 0x05B4, 0x0704, 0x0755, 0x0A60, 0x0F29, 0x143A, 0x19A9, 0x1D95, 0x1EE3, 0x2169, 0x2032, 0x20BF, 0x2766, 0x2CD7,
    0x31EA, 0x3553, 0x34B6, 0x32B1, 0x2F15, 0x27F7, 0x2527, 0x227A, 0x2096, 0x1FCF, 0x1A54, 0x15E6, 0x0F62, 0x09C7, 0x0421, 0xFB06,
    0xF393, 0xEB21, 0xE41E, 0xDF16, 0xD656, 0xCF52, 0xCB3E, 0xC6C0, 0xC629, 0xC78F, 0xCBCE, 0xD0CE, 0xD634, 0xDB21, 0xDE4A, 0xE53F,
    0xE9EF, 0xEF8D, 0xF6AD, 0xFC00, 0x01BD, 0x04FA, 0x05A3, 0x0892, 0x0D46, 0x10ED, 0x141C, 0x1766, 0x17C2, 0x13BA, 0x10C4, 0x0CE9,
    0x0987, 0x07AF, 0x0671, 0x071A, 0x07FD, 0x0A4C, 0x0C2C, 0x0DEC, 0x0DE3, 0x0F1D, 0x1345, 0x173D, 0x2023, 0x2828, 0x2F22, 0x3467,
    0x3713, 0x36CA, 0x3376, 0x3219, 0x3189, 0x3146, 0x3039, 0x2CF9, 0x286B, 0x24B4, 0x1CF6, 0x1458, 0x0C7F, 0x028F, 0xFBA4, 0xF5D0,
    0xEE27, 0xE889, 0xE457, 0xDFB3, 0xDDF8, 0xDF4C, 0xE24E, 0xE9D9, 0xF058, 0xF3E7, 0xF46B, 0xF31F, 0xF302, 0xF312, 0xF44F, 0xF4BF,
    0xF582, 0xF570, 0xF1DC, 0xED34, 0xEB7B, 0xEAF3, 0xEB59, 0xEE74, 0xEF68, 0xEFBA, 0xF053, 0xEDDF, 0xED0A, 0xECAD, 0xE940, 0xE69F,
    0xE56A, 0xE21C, 0xE13E, 0xDFE0, 0xDC9A, 0xDC61, 0xDE32, 0xE3C5, 0xEA2A, 0xF15B, 0xF854, 0xFEA1, 0x0363, 0x04A9, 0x04F2, 0x08B4,
    0x0C4F, 0x103D, 0x13A5, 0x10DA, 0x0EAA, 0x0AC1, 0x04DC, 0x00BA, 0xF9BD, 0xF2EB, 0xEDA1, 0xE6CB, 0xDFC8, 0xDA4E, 0xD81E, 0xD70A,
    0xD798, 0xDC80, 0xE1E4, 0xE8E2, 0xF215, 0xF834, 0xFEEC, 0x042F, 0x06BB, 0x0A57, 0x0D25, 0x0E55, 0x0F63, 0x1155, 0x0F26, 0x0ACD,
    0x0891, 0x07FE, 0x0BA6, 0x0F59, 0x1027, 0x129D, 0x1459, 0x11B4, 0x11E6, 0x12DA, 0x130F, 0x156D, 0x12EA, 0x105A, 0x1044, 0x0FBA,
    0x0D90, 0x08E5, 0x0693, 0x0674, 0x063C, 0x0934, 0x0B69, 0x0EE3, 0x15C5, 0x17CF, 0x1A4B, 0x1C82, 0x1E2A, 0x2675, 0x2C71, 0x2E84,
    0x2FC2, 0x2E62, 0x2A52, 0x24D2, 0x1E4B, 0x1515, 0x0D39, 0x03EF, 0xF8D4, 0xECEC, 0xE355, 0xDAFB, 0xD455, 0xCFCC, 0xCD18, 0xD1B8,
    0xD692, 0xDB4C, 0xE138, 0xE7D6, 0xECDC, 0xF346, 0xF914, 0xFDD9, 0x063D, 0x0B9B, 0x0E42, 0x0EEF, 0x0C05, 0x07C2, 0x07E6, 0x0A6C,
    0x0B7E, 0x0F40, 0x1210, 0x1322, 0x12B7, 0x11A6, 0x0FF9, 0x0F9F, 0x1059, 0x0CD6, 0x0AC1, 0x0B5C, 0x0AA4, 0x08E4, 0x0973, 0x07C1,
    0x0970, 0x0C7D, 0x0BE1, 0x0EFD, 0x106D, 0x0F3A, 0x0E65, 0x0ACF, 0x0563, 0x0495, 0x03B9, 0x022E, 0x015A, 0xFEE7, 0xFB8C, 0xF576,
    0xEFDF, 0xE7EE, 0xE110, 0xDB13, 0xD044, 0xC5C9, 0xBCBF, 0xB585, 0xB1CA, 0xAD70, 0xAA1A, 0xAA15, 0xAA20, 0xABFF, 0xAE16, 0xB269,
    0xB785, 0xBD33, 0xC434, 0xC924, 0xD1DB, 0xDBB4, 0xE1DE, 0xE814, 0xEA0B, 0xEA86, 0xED94, 0xEE81, 0xEF6E, 0xF3F1, 0xF8EA, 0xFE0D,
    0x020C, 0x05A0, 0x0B43, 0x1054, 0x154E, 0x14E3, 0x1661, 0x1979, 0x19F2, 0x1E3E, 0x2147, 0x23CF, 0x2C66, 0x32D5, 0x3639, 0x3C3B,
    0x3F5F, 0x4229, 0x421D, 0x4113, 0x3EED, 0x3BB2, 0x3C2D, 0x3946, 0x389F, 0x37AF, 0x3239, 0x2DDF, 0x275D, 0x20D1, 0x1A67, 0x0F64,
    0x0353, 0xF89B, 0xED56, 0xE374, 0xDC02, 0xD851, 0xD312, 0xCFC3, 0xCF81, 0xCC64, 0xCC28, 0xCAAF, 0xCA35, 0xCB9F, 0xCC3C, 0xCC55,
    0xCFE9, 0xD582, 0xDA44, 0xE310, 0xE78A, 0xEA23, 0xEEDC, 0xF306, 0xF71A, 0xFB54, 0x0024, 0x031E, 0x05A0, 0x06DD, 0x0879, 0x0C7A,
    0x1072, 0x0D7C, 0x0AD2, 0x0845, 0x039B, 0x0495, 0x0225, 0x0283, 0x067A, 0x0B38, 0x0FBC, 0x13CB, 0x183C, 0x1C01, 0x227D, 0x2491,
    0x23E3, 0x2542, 0x296C, 0x2C50, 0x30F0, 0x340D, 0x318C, 0x322D, 0x2DCB, 0x2864, 0x2622, 0x2095, 0x17C8, 0x0BA3, 0xFD46, 0xF003,
    0xE599, 0xDB37, 0xD480, 0xD153, 0xD27B, 0xD2BC, 0xD4DD, 0xD71D, 0xD7D0, 0xDD4B, 0xDDA8, 0xDEA4, 0xE0E1, 0xE431, 0xE831, 0xEB28,
    0xEE32, 0xEF1B, 0xF145, 0xF004, 0xE9CA, 0xE6B8, 0xE769, 0xE761, 0xEBD4, 0xEE89, 0xF161, 0xF9FE, 0xFD11, 0x010B, 0x0206, 0xFF8E,
    0xFEC9, 0xFBA7, 0xF87A, 0xF6BE, 0xF8D7, 0xFCE7, 0xFF37, 0x01C7, 0x04C3, 0x0475, 0x0A4E, 0x0E95, 0x1040, 0x1852, 0x1D7D, 0x2373,
    0x299F, 0x2D64, 0x304A, 0x329C, 0x34B6, 0x3370, 0x3164, 0x2D62, 0x2665, 0x1EBB, 0x1545, 0x08BA, 0xFFBB, 0xF71C, 0xEFF0, 0xED5C,
    0xE6C4, 0xE2F0, 0xE2F5, 0xE24B, 0xE42A, 0xEB6A, 0xF157, 0xF57A, 0xFB01, 0xFFB3, 0x03E7, 0x07D6, 0x0B83, 0x0C55, 0x0CAA, 0x0AA9,
    0x0475, 0xFE09, 0xF655, 0xF14B, 0xF03C, 0xEE3D, 0xEDF0, 0xF2F7, 0xF7A3, 0xFB80, 0xFE19, 0xFCD7, 0xFB80, 0xF9CC, 0xF96D, 0xF8E8,
    0xFB9B, 0xFED0, 0x0079, 0x0513, 0x068D, 0x0572, 0x083B, 0x07CF, 0x046E, 0x0675, 0x0607, 0x08C5, 0x0ECE, 0x13F9, 0x1C09, 0x24AA,
    0x2AF8, 0x2F31, 0x3386, 0x3477, 0x3269, 0x2D10, 0x24CC, 0x1BB4, 0x12EC, 0x0991, 0x00C4, 0xFB7F, 0xF4D2, 0xEEA2, 0xE9D8, 0xE478,
    0xDEF8, 0xDD8E, 0xE012, 0xE1AC, 0xE778, 0xEBA1, 0xEF4B, 0xF716, 0xFC0A, 0x00C4, 0x08D7, 0x0BF2, 0x0C86, 0x0C2C, 0x072D, 0x0592,
    0x0287, 0x0119, 0x02ED, 0x0738, 0x0F75, 0x13C9, 0x19B9, 0x1A70, 0x1606, 0x1260, 0x0A1E, 0x056F, 0x0690, 0x079C, 0x0E45, 0x170E,
    0x1BBC, 0x20D6, 0x20CC, 0x20C1, 0x201F, 0x1E69, 0x20D3, 0x203B, 0x227E, 0x2537, 0x24A9, 0x2826, 0x2B42, 0x2BFC, 0x3075, 0x2FA6,
    0x2A34, 0x25CB, 0x19AC, 0x0ED5, 0x0659, 0xFB40, 0xF241, 0xEABB, 0xE352, 0xDBE9, 0xD6FF, 0xCF7C, 0xCA49, 0xC937, 0xC6CD, 0xC53E,
    0xC61E, 0xC601, 0xC551, 0xC6AE, 0xC7C6, 0xCC00, 0xD295, 0xD85F, 0xDC40, 0xDFA3, 0xE0C3, 0xDEE1, 0xDC75, 0xDC0A, 0xDC98, 0xDEC2,
    0xE504, 0xEA03, 0xEFB3, 0xF3C1, 0xF4AB, 0xF88F, 0xF4D9, 0xF1E1, 0xF4E6, 0xF37B, 0xF557, 0xFAC2, 0xFF9B, 0x045C, 0x0AF5, 0x0F97,
    0x1487, 0x1BCB, 0x1FFD, 0x21FA, 0x23F0, 0x23BC, 0x24EE, 0x2923, 0x2CE8, 0x3193, 0x3672, 0x3925, 0x3917, 0x35B8, 0x2E6F, 0x247A,
    0x1A0E, 0x0E7C, 0x0312, 0xFB2C, 0xF311, 0xECFE, 0xEB4D, 0xE690, 0xE123, 0xE226, 0xE1FF, 0xE3C0, 0xE77C, 0xE69F, 0xE868, 0xEA25,
    0xE955, 0xE89F, 0xEB02, 0xF00E, 0xF394, 0xF933, 0xFB44, 0xF9F2, 0xFB09, 0xF7E4, 0xF981, 0xFD9E, 0x002E, 0x0A22, 0x12E4, 0x188B,
    0x1E25, 0x1EF7, 0x1E01, 0x1AFD, 0x1739, 0x1467, 0x1138, 0x113C, 0x111A, 0x1148, 0x1530, 0x14BE, 0x1385, 0x167C, 0x18C1, 0x1D02,
    0x1F91, 0x2135, 0x24C2, 0x274D, 0x29E5, 0x2CF5, 0x30C1, 0x35FA, 0x38E4, 0x3AC1, 0x386F, 0x3370, 0x2E89, 0x2464, 0x1AF9, 0x138C,
    0x0825, 0xFE81, 0xF61E, 0xEA21, 0xE1F4, 0xDC34, 0xD606, 0xD4DC, 0xD63A, 0xD72E, 0xDAAD, 0xDDCF, 0xE0B5, 0xE2B7, 0xE5A9, 0xEBFF,
    0xF157, 0xF7DE, 0xFC8F, 0xFBE1, 0xF81D, 0xF004, 0xEA71, 0xE712, 0xE226, 0xE1F5, 0xE504, 0xE943, 0xED4F, 0xEFF1, 0xEF0B, 0xED57,
    0xEB8F, 0xE771, 0xE41C, 0xE402, 0xE43C, 0xE438, 0xE4A5, 0xE3FA, 0xE3F7, 0xE570, 0xE4DC, 0xE5A2, 0xE804, 0xE732, 0xE7B4, 0xEA36,
    0xEF5A, 0xF6B8, 0xFE54, 0x083F, 0x122E, 0x1843, 0x19F0, 0x18A3, 0x1457, 0x0AF1, 0x020C, 0xF91A, 0xF06D, 0xEB6B, 0xE5E6, 0xE243,
    0xDEA6, 0xDB05, 0xD93D, 0xD617, 0xD872, 0xD94B, 0xDABE, 0xE327, 0xE75A, 0xEEF4, 0xF8EE, 0x02C2, 0x0FA2, 0x199E, 0x2082, 0x25D6,
    0x2645, 0x22A4, 0x1E86, 0x1C26, 0x1AFC, 0x19C0, 0x1ADF, 0x1BFF, 0x1E7D, 0x2097, 0x1E11, 0x1DC5, 0x1CFE, 0x1953, 0x17B4, 0x156F,
    0x143F, 0x1809, 0x1C6D, 0x2070, 0x2375, 0x2487, 0x2792, 0x25A0, 0x23B2, 0x1FBC, 0x1864, 0x15FC, 0x1035, 0x0ECD, 0x1297, 0x16C9,
    0x20D2, 0x28B1, 0x2CCC, 0x2F5E, 0x2F18, 0x2B4F, 0x251C, 0x1C4D, 0x114D, 0x0885, 0xFE9B, 0xF2EC, 0xE9B1, 0xE378, 0xDAC8, 0xD24A,
    0xCE1E, 0xCB93, 0xCA81, 0xCB65, 0xCB0F, 0xCC03, 0xCEA1, 0xD036, 0xD763, 0xDFA9, 0xE8FC, 0xF2C2, 0xF771, 0xF92E, 0xF637, 0xF1C4,
    0xEEC9, 0xEE4C, 0xF08A, 0xF3DF, 0xFAA0, 0x038A, 0x09CF, 0x0D03, 0x0F15, 0x0D41, 0x0AEB, 0x08EF, 0x02E6, 0x001D, 0x024F, 0x0330,
    0x0706, 0x0C90, 0x1012, 0x15FC, 0x194D, 0x1BAB, 0x1D57, 0x1B25, 0x19BC, 0x1BA6, 0x1EBA, 0x235A, 0x2B14, 0x311D, 0x35A2, 0x37BB,
    0x3626, 0x31E5, 0x2A0A, 0x20FD, 0x13C2, 0x07E8, 0xFE99, 0xF3AF, 0xEB77, 0xE502, 0xDE07, 0xD926, 0xD30E, 0xCD24, 0xCA35, 0xC5C1,
    0xC2A0, 0xBF6B, 0xBF4A, 0xC0B2, 0xC26B, 0xC7BF, 0xCCDE, 0xD406, 0xD956, 0xD8C7, 0xDA25, 0xDB40, 0xDA98, 0xDD49, 0xDE7A, 0xE020,
    0xE534, 0xE8F8, 0xEE10, 0xF513, 0xFA2B, 0xFF10, 0x0234, 0x04D9, 0x03FB, 0x0354, 0x05D9, 0x0894, 0x0D96, 0x1169, 0x15AC, 0x1C4D,
    0x1FE5, 0x228F, 0x275C, 0x2B44, 0x2D78, 0x2E48, 0x3381, 0x39EE, 0x3FF5, 0x46E6, 0x4B81, 0x4FDC, 0x5219, 0x4E55, 0x4A43, 0x43A0,
    0x36D3, 0x296B, 0x1B09, 0x0C5D, 0x00CF, 0xF672, 0xED2D, 0xE6F0, 0xDF25, 0xD874, 0xD43F, 0xCF8C, 0xCCAC, 0xCBF2, 0xCC39, 0xCE5E,
    0xCFCE, 0xD1C3, 0xD434, 0xD6CA, 0xD877, 0xD730, 0xD4A0, 0xD0F8, 0xCE6E, 0xCD52, 0xCDCD, 0xCE24, 0xD158, 0xD5BB, 0xD86A, 0xDF5B,
    0xE6F7, 0xEEBE, 0xF64A, 0xFBD9, 0xFEED, 0xFEA4, 0xFDDE, 0xFF0E, 0x03A1, 0x07C2, 0x0BBD, 0x107C, 0x15A3, 0x165C, 0x16EA, 0x1715,
    0x1595, 0x1730, 0x191B, 0x1D45, 0x265E, 0x30B2, 0x38A7, 0x4166, 0x46EC, 0x48F8, 0x48D3, 0x45A4, 0x43E4, 0x407C, 0x3850, 0x3038,
    0x2749, 0x2010, 0x17FB, 0x0EA2, 0x0799, 0xFE5E, 0xF603, 0xEFCD, 0xE74F, 0xE277, 0xDFDE, 0xDE63, 0xE227, 0xE3E7, 0xE793, 0xEE33,
    0xF3F0, 0xF7CB, 0xF8B4, 0xF6EE, 0xF59D, 0xF514, 0xF4C2, 0xF0E0, 0xEEC4, 0xEE83, 0xEAA5, 0xEA91, 0xEB09, 0xED0E, 0xF0B1, 0xF070,
    0xF045, 0xEF4D, 0xECB9, 0xEC7C, 0xEDE4, 0xF0A5, 0xF38A, 0xF6EF, 0xF968, 0xF9B6, 0xFA3E, 0xF9AF, 0xF688, 0xF4E9, 0xF2ED, 0xF160,
    0xF2C4, 0xF598, 0xFA13, 0x0071, 0x07A9, 0x0EBE, 0x170F, 0x1BDB, 0x1CC6, 0x1CE5, 0x18CD, 0x10B8, 0x0629, 0xFC85, 0xF4EB, 0xEF1D,
    0xEA3C, 0xE5C8, 0xE2C1, 0xDCB3, 0xD6C3, 0xD22C, 0xCF3A, 0xCDF0, 0xCF9A, 0xD305, 0xD75F, 0xDF1E, 0xE510, 0xEA33, 0xF1E4, 0xF5F4,
    0xF6AF, 0xF900, 0xFA89, 0xFAFB, 0xFA2A, 0xFA6D, 0xFB3C, 0xF99B, 0xFA97, 0xFD79, 0x0093, 0x0297, 0x0112, 0x00DB, 0xFD37, 0xF891,
    0xF691, 0xF669, 0xF999, 0xFFCB, 0x04BA, 0x08B4, 0x0E58, 0x1129, 0x127F, 0x13BC, 0x12FB, 0x11AB, 0x109C, 0x0FFF, 0x11FB, 0x15CD,
    0x1C2C, 0x20A8, 0x272D, 0x2E32, 0x30A1, 0x32FF, 0x3255, 0x2E2E, 0x2A02, 0x2263, 0x1C5C, 0x188C, 0x131F, 0x1070, 0x0C80, 0x0673,
    0xFFAC, 0xF791, 0xEF81, 0xEA62, 0xE7BD, 0xE685, 0xE61E, 0xE96A, 0xEE8C, 0xF0E1, 0xF655, 0xFBB4, 0xFE2E, 0x024E, 0x043A, 0x06B0,
    0x07EB, 0x04FF, 0x035E, 0x0023, 0xFDF0, 0xFE1A, 0xFF8C, 0x061B, 0x0B5B, 0x0F12, 0x0F31, 0x0C36, 0x0B30, 0x05F8, 0x048B, 0x0783,
    0x0937, 0x0A8C, 0x0A52, 0x0AD0, 0x08D0, 0x03F5, 0xFE58, 0xFA16, 0xFAC6, 0xFB38, 0xFE5B, 0x050E, 0x0C5B, 0x150B, 0x1B99, 0x20E9,
    0x26A1, 0x287D, 0x2823, 0x2471, 0x1CF0, 0x1276, 0x0624, 0xFD1F, 0xF348, 0xEC7D, 0xE744, 0xE0E5, 0xD9FB, 0xD302, 0xCB97, 0xC57E,
    0xC3C4, 0xC1D6, 0xC198, 0xC372, 0xC459, 0xC48B, 0xC4EE, 0xC775, 0xC9C3, 0xCB65, 0xCDDC, 0xCE2C, 0xD060, 0xD2AF, 0xD216, 0xD297,
    0xD24C, 0xD485, 0xD862, 0xDA1A, 0xDF4E, 0xE3C7, 0xE751, 0xE87D, 0xE780, 0xE89A, 0xE9E3, 0xEDE4, 0xF31E, 0xF88B, 0xFF16, 0x0298,
    0x0536, 0x0971, 0x0B7F, 0x0C13, 0x0EE4, 0x1128, 0x124F, 0x16F1, 0x1E42, 0x26C0, 0x314D, 0x3ACB, 0x4326, 0x498F, 0x4B4F, 0x4D77,
    0x4A4A, 0x462A, 0x4032, 0x374B, 0x2F03, 0x2551, 0x1C76, 0x10E8, 0x05CB, 0xFD55, 0xF2A1, 0xE8C7, 0xE602, 0xE496, 0xE87F, 0xECAF,
    0xF15A, 0xF726, 0xF99B, 0xFD60, 0xFE92, 0xFFDE, 0x0159, 0xFF20, 0xFEAB, 0xFD7D, 0xFA1B, 0xF765, 0xF357, 0xF0DF, 0xF0A1, 0xF1D9,
    0xF533, 0xFA54, 0xFEFE, 0x02EC, 0x039D, 0x0159, 0x0093, 0x02A9, 0x03AE, 0x0552, 0x08C1, 0x0909, 0x08F8, 0x0759, 0x04B8, 0x01BF,
    0x00B4, 0xFFB3, 0xFE20, 0xFEB3, 0x0067, 0x04D1, 0x0A71, 0x1233, 0x1946, 0x218E, 0x2697, 0x29CE, 0x2A11, 0x250C, 0x20BB, 0x1ACA,
    0x132F, 0x0D15, 0x0869, 0x019D, 0xFA0B, 0xEDA0, 0xE4C3, 0xDA45, 0xD1FB, 0xCD44, 0xC9B6, 0xCEFE, 0xCF1D, 0xD07D, 0xD352, 0xD57F,
    0xDA6E, 0xDD1D, 0xE438, 0xEAE4, 0xF056, 0xF6ED, 0xFA03, 0xFCE9, 0xFC8D, 0xFDF3, 0xFDD7, 0xFAB4, 0xFB0B, 0xFB88, 0xFD55, 0x0097,
    0x009E, 0x0117, 0x0061, 0x0107, 0x0258, 0x0140, 0x081F, 0x0A10, 0x0BD3, 0x0DDC, 0x0C82, 0x0DEF, 0x0B17, 0x0923, 0x055A, 0xFEE2,
    0xFB3F, 0xF809, 0xF8F7, 0xFEC6, 0x05AF, 0x0F49, 0x14D1, 0x17C1, 0x1A42, 0x1798, 0x151A, 0x0F7B, 0x0882, 0x038F, 0xFD90, 0xF7F6,
    0xF24E, 0xEC0C, 0xE377, 0xDA0C, 0xD21D, 0xCB42, 0xC717, 0xC6F0, 0xC8D5, 0xCB47, 0xCE69, 0xD159, 0xD5FC, 0xDB39, 0xE09E, 0xE6DE,
    0xEC9A, 0xF390, 0xF9A9, 0xFF68, 0x049E, 0x0881, 0x0A88, 0x0C11, 0x0CB5, 0x0BD3, 0x0B7E, 0x0D3F, 0x0F8F, 0x0DB8, 0x0CE2, 0x0C36,
    0x0A5B, 0x07B7, 0x071C, 0x0854, 0x09AF, 0x0C95, 0x0DEC, 0x101F, 0x140D, 0x160C, 0x14EB, 0x13A5, 0x10A7, 0x0F64, 0x0ED0, 0x0F0B,
    0x1613, 0x1A53, 0x20CE, 0x252F, 0x2462, 0x23BB, 0x1DBC, 0x1AF4, 0x157A, 0x0E0C, 0x0B47, 0x0561, 0x0061, 0xF974, 0xEFF8, 0xEAC4,
    0xE27F, 0xDCC6, 0xD82C, 0xD409, 0xD474, 0xD216, 0xD235, 0xD210, 0xD127, 0xD41E, 0xD4E8, 0xDA33, 0xDD04, 0xE0F3, 0xE6C5, 0xE883,
    0xECB2, 0xEF59, 0xF30F, 0xF493, 0xF564, 0xF8F0, 0xFA77, 0xFD12, 0x0236, 0x0376, 0x0956, 0x0BB0, 0x0F5D, 0x12E5, 0x14FE, 0x1A3F,
    0x1C0F, 0x1EE7, 0x1FEE, 0x1F64, 0x224D, 0x2303, 0x244C, 0x24F5, 0x2132, 0x1EFB, 0x1B30, 0x1BCD, 0x1F2A, 0x2770, 0x3064, 0x3909,
    0x3DC4, 0x42E0, 0x43F3, 0x430E, 0x3EE2, 0x3B7D, 0x36B1, 0x2E6C, 0x2790, 0x1DD1, 0x1338, 0x0682, 0xFCC6, 0xEE64, 0xE2DA, 0xD930,
    0xD489, 0xD1AF, 0xD069, 0xD081, 0xD1EA, 0xD2D0, 0xD3AE, 0xD3BA, 0xD3EA, 0xD1A7, 0xD091, 0xCF69, 0xCC8C, 0xCE10, 0xCE4A, 0xCFE5,
    0xCF90, 0xCE58, 0xCC38, 0xC958, 0xC944, 0xCAC5, 0xCC26, 0xD2AC, 0xD454, 0xD8E2, 0xDC12, 0xDE9D, 0xE3AA, 0xE4A6, 0xE815, 0xEB2E,
    0xEEDE, 0xF35C, 0xF5E6, 0xF94C, 0xFC18, 0xFDBF, 0xFFA7, 0x00CB, 0x055E, 0x0D35, 0x153A, 0x1EE2, 0x2749, 0x2E0F, 0x350E, 0x3A04,
    0x3CDD, 0x3D3D, 0x3DEA, 0x3CCA, 0x3AAC, 0x349A, 0x2ED5, 0x2687, 0x1C11, 0x0F1A, 0x02A0, 0xF62E, 0xEB97, 0xE417, 0xE0F6, 0xE055,
    0xE16E, 0xE50D, 0xE79E, 0xEBB5, 0xEE72, 0xF0EF, 0xF38D, 0xF571, 0xF53F, 0xF977, 0xF95B, 0xFA9D, 0xF8A0, 0xF618, 0xF276, 0xEE2E,
    0xEA56, 0xE6D5, 0xE4E5, 0xE785, 0xE86F, 0xE9B2, 0xEDAF, 0xEFF4, 0xF6E3, 0xF967, 0x0094, 0x0530, 0x09A4, 0x0DF5, 0x0FF1, 0x0F40,
    0x0D68, 0x0984, 0x083D, 0x040C, 0x0584, 0x0B02, 0x11DF, 0x1E24, 0x2629, 0x2F26, 0x34EF, 0x38E1, 0x3C2F, 0x3D8B, 0x414C, 0x4369,
    0x418E, 0x4113, 0x39CA, 0x34C3, 0x2D03, 0x2420, 0x1C61, 0x10BC, 0x084C, 0x0051, 0xF8BF, 0xF53E, 0xF210, 0xF244, 0xF0FA, 0xF000,
    0xF209, 0xEF75, 0xEE32, 0xEB88, 0xE87B, 0xE7BC, 0xE7FB, 0xEC28, 0xF06A, 0xF488, 0xF631, 0xF586, 0xF2BC, 0xEC49, 0xE813, 0xE434,
    0xE353, 0xE214, 0xE177, 0xE1D4, 0xE278, 0xE43C, 0xE584, 0xE631, 0xE9E4, 0xE998, 0xEBEE, 0xEC81, 0xEBDF, 0xEC4C, 0xE804, 0xE771,
    0xE4E0, 0xE2CD, 0xE259, 0xE4D1, 0xE96D, 0xED12, 0xF113, 0xF8DC, 0xFDC7, 0x0478, 0x07C8, 0x0C71, 0x0DA4, 0x0BA5, 0x0919, 0x0405,
    0x0068, 0xFA1E, 0xF453, 0xEDFC, 0xE5B1, 0xE05C, 0xD96E, 0xD39B, 0xD42C, 0xD226, 0xD786, 0xDAD8, 0xE07D, 0xE56C, 0xE8B5, 0xED9E,
    0xEE72, 0xF21E, 0xF8A5, 0xFD8B, 0x0612, 0x0C81, 0x10BF, 0x1468, 0x12D2, 0x12D7, 0x0ECF, 0x0F07, 0x1133, 0x124E, 0x15E6, 0x1712,
    0x1913, 0x1900, 0x1621, 0x1612, 0x12D6, 0x11F1, 0x1153, 0x0E4B, 0x0DB8, 0x0E1D, 0x0EC7, 0x0DA0, 0x0C3A, 0x0E34, 0x104B, 0x1400,
    0x1844, 0x1BBF, 0x2069, 0x2343, 0x245F, 0x2774, 0x2A5B, 0x2D73, 0x300F, 0x2F33, 0x2D2F, 0x286A, 0x2363, 0x1D93, 0x1688, 0x0F35,
    0x07C7, 0xFD9C, 0xF5AC, 0xEBF1, 0xE927, 0xE6E8, 0xE5D7, 0xE76A, 0xE67F, 0xE7AD, 0xE797, 0xE561, 0xE3B1, 0xE4D6, 0xE6CC, 0xEAC7,
    0xED92, 0xF679, 0xFBE0, 0xFF3D, 0xFECB, 0xFB26, 0xF60E, 0xF1A5, 0xF0D7, 0xF2B0, 0xF48E, 0xF87D, 0xFC91, 0xFE01, 0xFFAB, 0x00DD,
    0x02C3, 0x03C2, 0x04BB, 0x02F7, 0x01DE, 0xFEE8, 0xFDCA, 0xFA52, 0xF9CD, 0xF9CF, 0xF910, 0xFA55, 0xFC22, 0xFE62, 0x01BF, 0x0645,
    0x0A6A, 0x10B3, 0x17C2, 0x2104, 0x2877, 0x2C80, 0x2EA7, 0x2E52, 0x291A, 0x22D4, 0x1C8D, 0x14C1, 0x0E3D, 0x05A8, 0xFCA5, 0xF28D,
    0xE9C0, 0xE44B, 0xDF8A, 0xE115, 0xE328, 0xE58B, 0xE987, 0xEB21, 0xEAB3, 0xE9A4, 0xE825, 0xE982, 0xE910, 0xEC26, 0xF0C0, 0xF413,
    0xF712, 0xF4EC, 0xF317, 0xEF55, 0xEA47, 0xE609, 0xE1DC, 0xE14B, 0xE05B, 0xDF7D, 0xE37D, 0xE5DE, 0xEADD, 0xEEC9, 0xF353, 0xF4C8,
    0xF388, 0xF2CC, 0xF222, 0xEFC8, 0xF09C, 0xF080, 0xF123, 0xF389, 0xF56A, 0xFAE7, 0xFE4F, 0x06B4, 0x0C83, 0x13D9, 0x1B68, 0x2446,
    0x2D23, 0x33FE, 0x388B, 0x3BB6, 0x3B7E, 0x3972, 0x35B8, 0x2EED, 0x2986, 0x208A, 0x148E, 0x0686, 0xF80A, 0xEC53, 0xE473, 0xDEEF,
    0xDCF0, 0xDB00, 0xDD45, 0xE060, 0xE140, 0xE30C, 0xE580, 0xE801, 0xED41, 0xF12A, 0xF6ED, 0xFE0D, 0x0279, 0x0837, 0x0616, 0x01A5,
    0xFE11, 0xF87F, 0xF3BA, 0xEF5D, 0xEC8B, 0xEB55, 0xE9F8, 0xEAE5, 0xEF80, 0xF37B, 0xF933, 0xFDA5, 0x0217, 0x054F, 0x05BA, 0x055C,
    0x061D, 0x0770, 0x0626, 0x0707, 0x04F3, 0x04F0, 0x05E9, 0x0956, 0x0CA1, 0x0EE1, 0x13EA, 0x1AF2, 0x22D1, 0x29CC, 0x2E89, 0x3263,
    0x35AB, 0x34F1, 0x3308, 0x2F6C, 0x2E6C, 0x2C80, 0x24E3, 0x1B9C, 0x12FE, 0x0828, 0xFEE3, 0xF684, 0xF34F, 0xF04E, 0xEFB1, 0xEF88,
    0xEDE8, 0xED57, 0xED57, 0xEE49, 0xEE32, 0xF077, 0xF3FC, 0xF947, 0xFD2E, 0x02F0, 0x03B6, 0x0637, 0x077B, 0x065B, 0x0479, 0x010F,
    0x0096, 0xFF71, 0xFECC, 0x00E3, 0x0317, 0x068B, 0x0BDF, 0x0E02, 0x0F74, 0x0E7C, 0x0D4C, 0x0AAF, 0x085F, 0x08DD, 0x0A15, 0x0B2E,
    0x0C2A, 0x0C13, 0x0DEB, 0x0E84, 0x0E7A, 0x0F57, 0x0FD2, 0x11AB, 0x1105, 0x144D, 0x176B, 0x1948, 0x1B31, 0x1B29, 0x18BC, 0x120A,
    0x0AB1, 0x047A, 0xFBAD, 0xEFDA, 0xE635, 0xDB0D, 0xD23F, 0xCB78, 0xC5AE, 0xC251, 0xC0C3, 0xBEEA, 0xBDC0, 0xBD44, 0xBD3A, 0xC012,
    0xC0BD, 0xC402, 0xC7D1, 0xCD0C, 0xD422, 0xDB51, 0xE426, 0xEA7B, 0xED94, 0xEF78, 0xED16, 0xEB75, 0xEABF, 0xEA36, 0xEDEA, 0xF17A,
    0xF72A, 0xFF2D, 0x06BF, 0x0C98, 0x113C, 0x139A, 0x1478, 0x112F, 0x0E5A, 0x0D31, 0x0D82, 0x0CF7, 0x0F27, 0x0FDA, 0x129E, 0x1A70,
    0x1D58, 0x22C2, 0x26B6, 0x2D17, 0x3363, 0x36D3, 0x3BA5, 0x4122, 0x451A, 0x4823, 0x47FE, 0x461B, 0x42D7, 0x3E57, 0x36E2, 0x2B8A,
    0x2181, 0x148C, 0x0A20, 0x0129, 0xF9A1, 0xF656, 0xF364, 0xF261, 0xF0D6, 0xEBBE, 0xE8F2, 0xE7B0, 0xE6A3, 0xE3F9, 0xE225, 0xE309,
    0xE3CE, 0xE784, 0xEA8D, 0xEFD0, 0xF54D, 0xF71A, 0xF7C7, 0xF6A7, 0xF160, 0xEC35, 0xE943, 0xE8D4, 0xEB14, 0xF039, 0xF8A5, 0x014A,
    0x09E3, 0x0F00, 0x12FE, 0x1397, 0x13C6, 0x13E8, 0x1427, 0x1652, 0x185A, 0x18C4, 0x16C1, 0x1789, 0x1777, 0x1515, 0x15CA, 0x17F3,
    0x1A29, 0x1DAF, 0x1F93, 0x2508, 0x28CE, 0x2D50, 0x33E8, 0x37BB, 0x39FD, 0x3917, 0x367B, 0x303A, 0x26F5, 0x1D8F, 0x1186, 0x04E4,
    0xFB1A, 0xF168, 0xEC91, 0xE649, 0xE0A9, 0xDDCC, 0xDAA1, 0xD89C, 0xD7B6, 0xD636, 0xD3F8, 0xD410, 0xD243, 0xD27D, 0xD2A0, 0xD3CD,
    0xDA02, 0xDCD4, 0xDB63, 0xD978, 0xD448, 0xD02B, 0xCAA0, 0xC487, 0xC3E4, 0xC498, 0xC8D9, 0xCDF7, 0xD181, 0xD609, 0xD9D7, 0xDC13,
    0xDD1B, 0xDD3D, 0xDF08, 0xE0BC, 0xE4D1, 0xE730, 0xE8B1, 0xEB98, 0xED89, 0xF1D3, 0xF60E, 0xFB91, 0x036E, 0x0C85, 0x135D, 0x1C64,
    0x257D, 0x2E63, 0x372F, 0x3DA9, 0x4351, 0x48DE, 0x4998, 0x47F3, 0x46F4, 0x42B1, 0x3D5F, 0x35F8, 0x2DDC, 0x2575, 0x1E4E, 0x15E9,
    0x0E5D, 0x0602, 0xFDCC, 0xF8E0, 0xF507, 0xF220, 0xF194, 0xF121, 0xF225, 0xF564, 0xF82B, 0xFDDD, 0x049E, 0x0C26, 0x0F7E, 0x1030,
    0x0ECB, 0x07D9, 0xFFAC, 0xF7B8, 0xF0C0, 0xEE09, 0xEDAE, 0xEFB8, 0xF296, 0xF5C2, 0xFAA6, 0xFCA5, 0xFCEE, 0xFC36, 0xFD6E, 0xFDE2,
    0xFD83, 0xFF2D, 0xFECD, 0xFE93, 0xFE9F, 0xFD9F, 0xFD33, 0xFE82, 0x0016, 0x02E5, 0x0600, 0x09C4, 0x0EF3, 0x1380, 0x18B0, 0x2010,
    0x25FF, 0x2AB0, 0x2F08, 0x2E42, 0x2D1B, 0x2A05, 0x2522, 0x20F3, 0x19F6, 0x148D, 0x127E, 0x0C8F, 0x05C5, 0xFF34, 0xFA16, 0xF650,
    0xF11E, 0xEDEF, 0xED04, 0xEB25, 0xE88F, 0xE7D1, 0xE6AB, 0xE79C, 0xEBC2, 0xF3AE, 0xFA18, 0xFFCE, 0x02C0, 0x0116, 0xFCBD, 0xF53B,
    0xEE51, 0xEB4D, 0xE993, 0xECBD, 0xF2A9, 0xF47A, 0xFA8D, 0xFE20, 0xFD55, 0xFDED, 0xFB29, 0xF890, 0xF9A9, 0xF9CB, 0xFA29, 0xFB91,
    0xFC35, 0xFE4E, 0x000D, 0x001A, 0x013D, 0x0267, 0x02DD, 0x0437, 0x0575, 0x06DE, 0x0C09, 0x11D8, 0x179F, 0x1D3C, 0x1F98, 0x2174,
    0x1FFE, 0x1B79, 0x1521, 0x0D79, 0x0728, 0xFE93, 0xF553, 0xEE63, 0xE814, 0xE230, 0xDC3F, 0xD8C0, 0xD5A6, 0xD219, 0xD000, 0xD00C,
    0xCFDA, 0xD070, 0xD1D5, 0xD5B9, 0xDB7F, 0xE2D6, 0xEB91, 0xF387, 0xFC70, 0x0225, 0x045B, 0x0330, 0x00F6, 0xFF21, 0xFF5B, 0x0060,
    0x0259, 0x0606, 0x0B66, 0x12E1, 0x17A1, 0x187E, 0x1947, 0x17B6, 0x1569, 0x1080, 0x0A75, 0x086F, 0x06E8, 0x04DB, 0x045D, 0x0490,
    0x0519, 0x072B, 0x07FA, 0x0AF7, 0x0DC0, 0x105B, 0x14DA, 0x1952, 0x1E98, 0x2693, 0x2D0C, 0x2FAF, 0x2FBD, 0x2DB9, 0x27AD, 0x202A,
    0x185B, 0x0E09, 0x04EA, 0xFC88, 0xF2E3, 0xEBE5, 0xE4D9, 0xDFF8, 0xDD8E, 0xD8F2, 0xD85D, 0xD872, 0xD642, 0xD66D, 0xD73F, 0xD662,
    0xD9E2, 0xDE57, 0xE513, 0xEE4A, 0xF625, 0xFCDB, 0xFFD3, 0xFC28, 0xF8E1, 0xF61A, 0xF112, 0xEFF8, 0xF0F8, 0xF4F5, 0xFA57, 0xFF95,
    0x0644, 0x0C14, 0x11DF, 0x1653, 0x1997, 0x1C8F, 0x1CE8, 0x1E45, 0x1F1A, 0x1F18, 0x1EA6, 0x1F61, 0x1F4F, 0x1F5B, 0x1E1B, 0x1CA2,
    0x1BC4, 0x1C00, 0x1E40, 0x213C, 0x2696, 0x2D19, 0x33B2, 0x3719, 0x3958, 0x3A02, 0x37E8, 0x340F, 0x2FAC, 0x2BA2, 0x24E4, 0x1D61,
    0x1658, 0x0CD9, 0x0497, 0xFC18, 0xF3A1, 0xEB91, 0xE581, 0xE0BF, 0xDD81, 0xDA65, 0xD905, 0xD95E, 0xDAEA, 0xDFE9, 0xE500, 0xEC31,
    0xF3B7, 0xF9A1, 0xFD97, 0xFDCF, 0xFA0F, 0xF5D7, 0xEEB5, 0xE8F6, 0xE4A6, 0xE0A0, 0xDF98, 0xDF44, 0xDF97, 0xE26A, 0xE4D9, 0xE5FB,
    0xE777, 0xE7E8, 0xE72C, 0xE66F, 0xE5E0, 0xE43F, 0xE3C9, 0xE296, 0xE1BD, 0xE200, 0xE0E3, 0xE0E5, 0xE30C, 0xE31B, 0xE71D, 0xED56,
    0xF05B, 0xF761, 0x0223, 0x0AEC, 0x12E5, 0x192B, 0x1C45, 0x1FA1, 0x1FF6, 0x1ECF, 0x1E26, 0x1979, 0x16DD, 0x13F2, 0x0F7D, 0x094E,
    0x02E6, 0xFEB4, 0xF729, 0xEFFD, 0xE91B, 0xE1F5, 0xDE0D, 0xDB50, 0xDA54, 0xDD24, 0xDF6E, 0xE84B, 0xF19D, 0xF8A9, 0x032A, 0x0882,
    0x0C06, 0x0E1C, 0x0D80, 0x0E49, 0x0C1B, 0x09D3, 0x0BB7, 0x0AD5, 0x0A78, 0x0C9D, 0x0DD5, 0x12B8, 0x154C, 0x16F3, 0x18D3, 0x18B7,
    0x1B15, 0x1CA7, 0x1BFF, 0x1E79, 0x20E2, 0x205C, 0x1FE8, 0x1C6A, 0x1B4A, 0x18AB, 0x171C, 0x18E9, 0x1941, 0x1CC9, 0x2322, 0x2683,
    0x2AAA, 0x2C62, 0x2D7E, 0x2E8C, 0x2BAF, 0x2B73, 0x293F, 0x2767, 0x2444, 0x1D1A, 0x1510, 0x0DE5, 0x0772, 0x01E5, 0xFBB5, 0xF76F,
    0xF4AF, 0xF1A9, 0xEE07, 0xEAC0, 0xE71F, 0xE47B, 0xE286, 0xE263, 0xE672, 0xE9B6, 0xEC2E, 0xF0BE, 0xF1A4, 0xF1A5, 0xF06D, 0xED13,
    0xED8F, 0xE91F, 0xE8F3, 0xE95F, 0xE774, 0xEBCB, 0xF0D5, 0xF482, 0xFC2D, 0xFF40, 0x0170, 0x03E5, 0x029A, 0x032A, 0x01FC, 0x01F7,
    0x046F, 0x0721, 0x080F, 0x092B, 0x0A0D, 0x0B2B, 0x0A97, 0x0B62, 0x0D0E, 0x0DA1, 0x11A6, 0x156D, 0x1851, 0x1D43, 0x1E52, 0x2000,
    0x2132, 0x1DAD, 0x1AD3, 0x16F0, 0x0FB6, 0x096E, 0x0134, 0xF8BD, 0xF29C, 0xEA84, 0xE547, 0xDE0A, 0xD66A, 0xD0E6, 0xC9AE, 0xC313,
    0xBFF7, 0xBDA0, 0xBE31, 0xBEE4, 0xC208, 0xCA40, 0xCE80, 0xD513, 0xDC4F, 0xE092, 0xE4C9, 0xE5EE, 0xE6AE, 0xE6C4, 0xE60B, 0xE811,
    0xEACE, 0xEC7A, 0xF363, 0xFA44, 0x0212, 0x0AA3, 0x1054, 0x17BF, 0x1A54, 0x1BFF, 0x1CED, 0x1B24, 0x1A84, 0x1B80, 0x1835, 0x16E0,
    0x15D7, 0x161E, 0x1763, 0x16E1, 0x19BA, 0x1D5D, 0x22BD, 0x28FA, 0x2EEE, 0x3753, 0x3E86, 0x444A, 0x4986, 0x4974, 0x49AD, 0x481B,
    0x43AC, 0x3E61, 0x37BB, 0x2FA6, 0x298E, 0x2276, 0x1CA1, 0x1696, 0x0EE7, 0x06F6, 0x011F, 0xF924, 0xF19E, 0xED55, 0xE708, 0xE5F1,
    0xE4BD, 0xE4FA, 0xE77E, 0xE903, 0xECAD, 0xF10B, 0xF147, 0xF38D, 0xF253, 0xEF26, 0xEC99, 0xE59F, 0xE002, 0xDB00, 0xD942, 0xDBC8,
    0xDDDF, 0xE40A, 0xE8D4, 0xEB33, 0xEE66, 0xED5E, 0xF006, 0xF41A, 0xF5DF, 0xFBEB, 0xFF39, 0x00CC, 0x0403, 0x01F1, 0x019D, 0x019E,
    0x005E, 0x0325, 0x04CE, 0x0766, 0x0C44, 0x10C1, 0x18C9, 0x1F31, 0x25AD, 0x2B95, 0x2F51, 0x32B3, 0x3434, 0x30FA, 0x2F06, 0x2BB7,
    0x285D, 0x2582, 0x1F72, 0x1A99, 0x1473, 0x0C40, 0x02E5, 0xFAA9, 0xF0E2, 0xEC3C, 0xE8E6, 0xE71A, 0xE6C6, 0xE77E, 0xEAAC, 0xEED6,
    0xF216, 0xF659, 0xF998, 0xFC67, 0xFEAF, 0xFC63, 0xF9EC, 0xF662, 0xF212, 0xEF4B, 0xE9CD, 0xE6D7, 0xE7A1, 0xE501, 0xE5E1, 0xE4C0,
    0xE4CC, 0xE411, 0xE3E5, 0xE53C, 0xE598, 0xE621, 0xE6D8, 0xE5B4, 0xE555, 0xE27D, 0xE051, 0xE151, 0xDEAC, 0xE104, 0xE3D0, 0xE6C2,
    0xEB58, 0xF054, 0xF65F, 0xFE35, 0x0748, 0x0F75, 0x1551, 0x1C72, 0x221A, 0x261F, 0x275E, 0x288B, 0x2C16, 0x2CB5, 0x2BEF, 0x2B64,
    0x298B, 0x2541, 0x1DA7, 0x15A8, 0x0AD5, 0xFFC1, 0xF8D0, 0xEFA0, 0xEA6A, 0xE87E, 0xE785, 0xEA43, 0xEBE9, 0xEE43, 0xF38B, 0xF63E,
    0xFB14, 0xFE36, 0xFF02, 0x00CD, 0xFF42, 0xFE25, 0xFD13, 0xFA28, 0xFBB0, 0xFACD, 0xF9AA, 0xF970, 0xF65B, 0xF4B7, 0xF14C, 0xEE1E,
    0xEFBB, 0xEFEA, 0xF08F, 0xF15A, 0xF058, 0xF1A5, 0xEE97, 0xEC0E, 0xEA9B, 0xEA43, 0xECD1, 0xEF21, 0xEF8A, 0xF44B, 0xF8F5, 0xFFC2,
    0x06D8, 0x0CB6, 0x153A, 0x1A6A, 0x1C50, 0x1E40, 0x1D0C, 0x1AA7, 0x1B01, 0x19FA, 0x1AFD, 0x1AD1, 0x1B7A, 0x1A80, 0x16E4, 0x104C,
    0x0A29, 0x03C7, 0xFF00, 0xFBD8, 0xFB78, 0xFD63, 0xFF34, 0x00CB, 0x0318, 0x05CD, 0x078C, 0x0BDD, 0x0DFE, 0x112B, 0x119E, 0x104D,
    0x0DB8, 0x0958, 0x06CA, 0x03DA, 0x01CB, 0x0277, 0x0287, 0x04E3, 0x0452, 0x0323, 0x051E, 0x0331, 0x0266, 0x02FF, 0x01ED, 0x0324,
    0x02B8, 0xFFFA, 0xFAE1, 0xF631, 0xF393, 0xEF6C, 0xEF03, 0xEF15, 0xF1A9, 0xF58F, 0xF763, 0xFCA5, 0x0118, 0x071C, 0x0F51, 0x13FC,
    0x1724, 0x1708, 0x1645, 0x12A0, 0x0DF4, 0x0A63, 0x04E6, 0x003E, 0xFD97, 0xF73A, 0xF1DD, 0xE9BB, 0xE07B, 0xD870, 0xCF52, 0xC987,
    0xC35A, 0xBF80, 0xBDB0, 0xBCB4, 0xBCB1, 0xBCBF, 0xBE0E, 0xC391, 0xC6BB, 0xCBBF, 0xD0BB, 0xD4F1, 0xD8BA, 0xDA72, 0xDBFF, 0xDD3C,
    0xDCDB, 0xDE17, 0xE084, 0xE31D, 0xE828, 0xEC3D, 0xF294, 0xF742, 0xFDC7, 0x0501, 0x099E, 0x0D56, 0x11C2, 0x11C6, 0x1210, 0x1028,
    0x0ADA, 0x07B2, 0x0434, 0x02EC, 0x02C3, 0x024A, 0x03D4, 0x082E, 0x0C6D, 0x1125, 0x1702, 0x1E58, 0x24A1, 0x2A5C, 0x2E08, 0x2F18,
    0x30B0, 0x31E8, 0x3096, 0x2EC4, 0x2B9C, 0x26C6, 0x21C5, 0x199F, 0x0F5C, 0x067E, 0xFD15, 0xF4C9, 0xEF8C, 0xEB5E, 0xE970, 0xE95A,
    0xE905, 0xEAE0, 0xE9E7, 0xEABD, 0xEF11, 0xF17D, 0xF4A7, 0xF79B, 0xF9BC, 0xFAD9, 0xF8CC, 0xF727, 0xF5D0, 0xF2B7, 0xF2BB, 0xF1AF,
    0xF175, 0xF102, 0xF276, 0xF35F, 0xF5AD, 0xF9C2, 0xFCB9, 0x0001, 0x03BA, 0x0607, 0x0858, 0x0945, 0x09DB, 0x0BF3, 0x0C70, 0x0FAC,
    0x112F, 0x1551, 0x16B1, 0x17D1, 0x1989, 0x1A54, 0x1C64, 0x2082, 0x2222, 0x23B6, 0x2266, 0x1FC8, 0x2047, 0x1C16, 0x1BD9, 0x1C44,
    0x1E61, 0x1F56, 0x1CED, 0x1984, 0x128D, 0x0971, 0x00D3, 0xF42B, 0xE99F, 0xE2F5, 0xDCB7, 0xD8A7, 0xD4D2, 0xD4D9, 0xD502, 0xD566,
    0xD7DB, 0xD9EC, 0xDC03, 0xDFF0, 0xE22A, 0xE493, 0xE47E, 0xE59C, 0xE6E2, 0xE43E, 0xE2FF, 0xE0AE, 0xDEA9, 0xDC30, 0xDB94, 0xD9E5,
    0xDAF8, 0xDC6A, 0xDE18, 0xE0C4, 0xE283, 0xE4FE, 0xE687, 0xE88A, 0xE8DF, 0xE8DB, 0xE71B, 0xE534, 0xE1C6, 0xE1EC, 0xE035, 0xE033,
    0xE208, 0xE457, 0xEC3A, 0xF313, 0xF94F, 0x01C9, 0x08BB, 0x0C66, 0x0FF8, 0x109D, 0x1159, 0x13AF, 0x1759, 0x1A52, 0x1F74, 0x21C2,
    0x24B8, 0x2429, 0x21A7, 0x1D3F, 0x157F, 0x0EB2, 0x071D, 0x00B8, 0xFB22, 0xF6B8, 0xF36F, 0xF210, 0xED9A, 0xEE01, 0xEBD5, 0xECF2,
    0xEED4, 0xF000, 0xF44C, 0xF72B, 0xFB8A, 0xFDD2, 0x00AE, 0x02F6, 0x0497, 0x04AE, 0x0570, 0x0493, 0x05D2, 0x0756, 0x084A, 0x0896,
    0x09FE, 0x0B14, 0x0B9B, 0x0FA8, 0x1059, 0x12BF, 0x143B, 0x13F4, 0x13C7, 0x110C, 0x0F6D, 0x10FD, 0x109D, 0x12BA, 0x154C, 0x197C,
    0x1EA1, 0x2207, 0x2500, 0x2502, 0x25D1, 0x253D, 0x22EE, 0x2306, 0x23A4, 0x221D, 0x22D9, 0x1EF0, 0x1BBE, 0x15A5, 0x0F42, 0x09A0,
    0x018C, 0xF9A7, 0xF11B, 0xEAB0, 0xE461, 0xE0AD, 0xDE23, 0xDFBF, 0xE04C, 0xE39C, 0xE414, 0xE5CE, 0xE6F0, 0xE7E1, 0xE8E1, 0xE7FF,
    0xE96A, 0xE9FD, 0xEB5B, 0xE8D9, 0xE6ED, 0xE453, 0xE25A, 0xE0E8, 0xE1D3, 0xE488, 0xE8F0, 0xEEE0, 0xF5ED, 0xF8CC, 0xFAA4, 0xFE51,
    0xFEDF, 0xFEFE, 0xFE95, 0xFD6E, 0xFDD8, 0xFE6E, 0xFE88, 0x0000, 0x0053, 0x045C, 0x0840, 0x0CCB, 0x11C7, 0x197A, 0x201F, 0x254F,
    0x2AA1, 0x2E7F, 0x31D9, 0x32A7, 0x3723, 0x3745, 0x3822, 0x36BD, 0x33D7, 0x3178, 0x2BF1, 0x23EC, 0x1BB9, 0x119C, 0x05BF, 0xFBD3,
    0xEEDB, 0xE7A1, 0xDFF1, 0xDC6B, 0xDAAB, 0xD715, 0xD5A0, 0xD358, 0xD1A4, 0xCF28, 0xCC95, 0xCC8E, 0xCEAC, 0xD0E6, 0xD338, 0xD4E5,
    0xD524, 0xD5AB, 0xD5AA, 0xD200, 0xD1FB, 0xD456, 0xD827, 0xDCB3, 0xE455, 0xEC11, 0xF551, 0xFB71, 0x01FD, 0x066F, 0x0970, 0x0C1F,
    0x099C, 0x0A10, 0x046B, 0x033F, 0x00CC, 0xFE4C, 0xFFE1, 0x01CD, 0x043B, 0x08FA, 0x0CAB, 0x1122, 0x171B, 0x1922, 0x1E22, 0x21C0,
    0x2890, 0x2DBD, 0x33B4, 0x3931, 0x3AB9, 0x3DBF, 0x3BE7, 0x3731, 0x3135, 0x28AB, 0x1FC6, 0x1491, 0x08B2, 0xFEF6, 0xF7AA, 0xF245,
    0xEEC8, 0xED7E, 0xECB9, 0xEC41, 0xEC0C, 0xEAA5, 0xEA38, 0xECB3, 0xED30, 0xEF60, 0xF1BA, 0xF41D, 0xF43D, 0xF2C6, 0xF29D, 0xEE3E,
    0xED28, 0xEACC, 0xE9F8, 0xE8D2, 0xE8EF, 0xEAEC, 0xECCA, 0xEE52, 0xF084, 0xF5E3, 0xF9BC, 0xFEA4, 0x0061, 0x025F, 0x0128, 0x0167,
    0x0101, 0x0133, 0x048D, 0x0B03, 0x11EE, 0x189B, 0x20B0, 0x24B5, 0x2A6C, 0x2C42, 0x2DB2, 0x301F, 0x2EE8, 0x31AA, 0x34DC, 0x34A7,
    0x375E, 0x3804, 0x38C4, 0x385B, 0x366E, 0x3469, 0x3026, 0x2980, 0x2256, 0x185D, 0x0EE4, 0x0674, 0x008D, 0xFEA5, 0xFA72, 0xF9C9,
    0xF6EF, 0xF523, 0xF19A, 0xEF6E, 0xEE12, 0xEE00, 0xF09C, 0xF2CF, 0xF73E, 0xF896, 0xFB86, 0xFC22, 0xFA62, 0xF76A, 0xF47F, 0xF187,
    0xEF8D, 0xEBAB, 0xE8AE, 0xEA85, 0xE90A, 0xEB17, 0xE91F, 0xE883, 0xE8F3, 0xE543, 0xE27B, 0xDCDA, 0xD9FB, 0xD95C, 0xD845, 0xD80F,
    0xD845, 0xD931, 0xDB72, 0xDB6A, 0xDCFB, 0xDE84, 0xDF66, 0xE4DD, 0xE784, 0xEB3F, 0xF057, 0xF4C8, 0xFB14, 0xFCFE, 0x01C8, 0x035B,
    0x05B6, 0x075C, 0x079D, 0x09BD, 0x088C, 0x07E5, 0x0534, 0x0402, 0x025D, 0x02EB, 0x018D, 0x020D, 0x00D7, 0x0007, 0xFD79, 0xFADE,
    0xFAB2, 0xF90D, 0xFB0F, 0xFAD6, 0xFDDC, 0x001A, 0x02BD, 0x046D, 0x0418, 0x064C, 0x084E, 0x0A8A, 0x0B65, 0x0CD5, 0x10B2, 0x1326,
    0x1265, 0x121D, 0x1551, 0x158E, 0x154C, 0x14D3, 0x11D5, 0x0EEE, 0x0B2E, 0x0763, 0x05EF, 0x04A0, 0x0655, 0x0B6A, 0x0C90, 0x1131,
    0x13E1, 0x1666, 0x178E, 0x1618, 0x189F, 0x16A0, 0x1836, 0x18B4, 0x18DF, 0x1B31, 0x1C15, 0x1E90, 0x1F10, 0x1E02, 0x1C93, 0x197C,
    0x0FB6, 0x086C, 0xFFFD, 0xF879, 0xF20E, 0xEEF3, 0xEED1, 0xEE91, 0xEF5D, 0xEE15, 0xEF8E, 0xEFB3, 0xF347, 0xF6E3, 0xFA3C, 0x011F,
    0x0664, 0x0B28, 0x0D4F, 0x0D72, 0x0FA4, 0x0D44, 0x0AA8, 0x069C, 0x0221, 0xFFF0, 0xFCF0, 0xFB42, 0xFE08, 0x008D, 0x05D1, 0x0B5C,
    0x0F16, 0x1268, 0x0EAF, 0x0DE9, 0x0838, 0x016D, 0xFCEC, 0xFA38, 0xFA29, 0xFB0C, 0xFC3C, 0xFE11, 0xFFE9, 0x0058, 0x00E9, 0xFFEA,
    0x01FF, 0x022C, 0x047E, 0x060A, 0x0828, 0x0D45, 0x0F3B, 0x1186, 0x124D, 0x1244, 0x0FDF, 0x0C89, 0x06C2, 0xFEAC, 0xF60F, 0xEC6A,
    0xE507, 0xDDCD, 0xD91A, 0xD667, 0xD495, 0xD23B, 0xD07D, 0xCE0E, 0xCBB4, 0xCA4C, 0xC7CA, 0xC742, 0xC6F6, 0xC85D, 0xCB73, 0xCDB7,
    0xD19F, 0xD464, 0xD809, 0xD99F, 0xDA88, 0xD917, 0xD8ED, 0xDB59, 0xDCB1, 0xE233, 0xE7A9, 0xF226, 0xFC1C, 0x0750, 0x0FD5, 0x1581,
    0x18BD, 0x1AA3, 0x1C5F, 0x1DC6, 0x1CE9, 0x1ED1, 0x23A7, 0x2318, 0x2505, 0x2401, 0x23BD, 0x22A2, 0x1FD9, 0x1F17, 0x1EAE, 0x1D57,
    0x2315, 0x26FA, 0x2B5D, 0x3021, 0x3703, 0x37FF, 0x38F6, 0x3F10, 0x3717, 0x31BE, 0x249A, 0x273E, 0x1611, 0x0C9D, 0x0E47, 0x05DC,
    0x0820, 0xFA6A, 0x00F9, 0xFE41, 0xF797, 0xF6B9, 0xF7BE, 0xF0F4, 0xFBC2, 0xF67C, 0xF399, 0xFC47, 0xF374, 0x00DB, 0xF462, 0xF34B,
    0xFCFD, 0xF4C7, 0xF203, 0xF64C, 0xE894, 0xE19F, 0xEA26, 0xE4FA, 0xF61B, 0xF754, 0xDD13, 0xFF99, 0xF255, 0xEE21, 0xFB37, 0xE126,
    0x0158, 0xF278, 0xEE5E, 0xFA5C, 0x000E, 0x11BB, 0xF540, 0x0768, 0x20F0, 0x09E7, 0x0570, 0x197A, 0x1A04, 0x19F4, 0x1016, 0x0F14,
    0x294B, 0x0E6D, 0x16E8, 0x1F12, 0x1EE2, 0x02F9, 0xFE1D, 0x0D0B, 0xFB19, 0xF664, 0xD58B, 0xD995, 0xD952, 0xD680, 0xBC6E, 0xC113,
    0xC61F, 0xB4B1, 0xB729, 0xC0E6, 0xBC6B, 0xB048, 0xB7F9, 0xC0D4, 0xC842, 0xC1D1, 0xD96C, 0xD3E1, 0xE32B, 0xF606, 0xF70B, 0x0347,
    0x01BA, 0x1639, 0x1DF7, 0x2838, 0x2196, 0x2AE8, 0x41A1, 0x42B1, 0x3882, 0x35C3, 0x3CF0, 0x2D82, 0x2A28, 0x19D7, 0x1AB7, 0x0870,
    0xF441, 0xE897, 0xE390, 0xE013, 0xCA7A, 0xCCCC, 0xC664, 0xBB9C, 0xACBA, 0xADC3, 0xB574, 0xA614, 0xB083, 0xB017, 0xA895, 0xA6D4,
    0xA671, 0xDAD0, 0xC682, 0xBECC, 0xBDC7, 0xC2E3, 0xCFF8, 0xD51B, 0xD9FA, 0xD313, 0xDC50, 0xD038, 0xF153, 0xFF77, 0xFE6A, 0xECE8,
    0x179F, 0x04A9, 0xFD86, 0x24F9, 0x15F2, 0x2A1B, 0x209E, 0x28D6, 0x3B23, 0x442F, 0x3D8E, 0x4FBC, 0x51E8, 0x530B, 0x5A7C, 0x66D3,
    0x695B, 0x6687, 0x708F, 0x6430, 0x6DF6, 0x706D, 0x6AC4, 0x63FB, 0x6535, 0x5FB2, 0x5592, 0x5ECB, 0x55A8, 0x4586, 0x4F07, 0x5083,
    0x4B21, 0x4C98, 0x51FF, 0x4119, 0x4AF5, 0x49FE, 0x4ADC, 0x4700, 0x46E5, 0x4D90, 0x4628, 0x55A7, 0x4443, 0x5578, 0x40C2, 0x3FEF,
    0x4170, 0x35F8, 0x2FD4, 0x1F7B, 0x2DC3, 0x183C, 0x1AFF, 0x12D8, 0x07C2, 0xFA04, 0xFDB7, 0xFFA8, 0xE4F1, 0xF230, 0xDA7F, 0xDA9A,
    0xEC4C, 0xE06D, 0xD2A4, 0xE344, 0xDF33, 0xCA2B, 0xE704, 0xD845, 0xCDA9, 0xC962, 0xC43D, 0xC8F7, 0xC33A, 0xBBDE, 0xBF94, 0xBE66,
    0xBE57, 0xC088, 0xBA0A, 0xBE2A, 0xBD96, 0xB03E, 0xB94E, 0xB780, 0xB847, 0xB265, 0xBE5C, 0xBC96, 0xA7EC, 0xC007, 0xAD91, 0xBBC8,
    0xB93D, 0xB668, 0xAFF5, 0xB67B, 0xC305, 0xBF0E, 0xCA58, 0xCD3E, 0xC137, 0xCFD6, 0xDEE5, 0xD98C, 0xDF0B, 0xCEA0, 0xE153, 0xCC38,
    0xD052, 0xD7B5, 0xCA1A, 0xC830, 0xCA88, 0xCBE7, 0xC8C5, 0xC179, 0xC615, 0xC4B1, 0xB3DC, 0xBCCD, 0xC5C9, 0xBC80, 0xB600, 0xC5A7,
    0xBFEC, 0xC53F, 0xC2C5, 0xC6B8, 0xC215, 0xC418, 0xBF03, 0xC442, 0xC77B, 0xC672, 0xCAA0, 0xD3DA, 0xD654, 0xC7B5, 0xDEB3, 0xDEC6,
    0xDF74, 0xDB1D, 0xE80E, 0xEF00, 0xE806, 0xF8C5, 0xF783, 0x0782, 0x1D8C, 0x14B4, 0x1928, 0x2C89, 0x2FA3, 0x21C6, 0x363F, 0x38AC,
    0x36CE, 0x3E71, 0x4558, 0x50A8, 0x5AF2, 0x5D70, 0x6359, 0x7047, 0x6780, 0x6CCF, 0x6B0A, 0x7821, 0x6BBA, 0x68BD, 0x70A9, 0x6B6D,
    0x7258, 0x71A5, 0x5940, 0x6D8A, 0x6E65, 0x6377, 0x6312, 0x5DC4, 0x63DB, 0x60C2, 0x648C, 0x634A, 0x6EEC, 0x5A9A, 0x6A50, 0x60BB,
    0x6C1A, 0x634E, 0x5CE4, 0x670F, 0x56B3, 0x5C32, 0x5CDF, 0x5F40, 0x4E3E, 0x523F, 0x4E5F, 0x57D9, 0x4651, 0x49A1, 0x47C2, 0x31C7,
    0x3E61, 0x34DF, 0x2DF6, 0x34DE, 0x2AB2, 0x30F4, 0x2D6A, 0x2B22, 0x2D20, 0x2960, 0x3395, 0x2A0F, 0x3485, 0x2E13, 0x24E4, 0x3A12,
    0x3A19, 0x3271, 0x377D, 0x303B, 0x3FC0, 0x31FA, 0x28F5, 0x38AD, 0x275F, 0x25A3, 0x2A5C, 0x1787, 0x195A, 0x1E1A, 0x07B9, 0x143E,
    0x1697, 0x04C3, 0x0EC1, 0x11A6, 0x02BD, 0x02A9, 0xFFF0, 0xFE1A, 0x0258, 0xF405, 0xF99B, 0x07E7, 0xF423, 0xF6EF, 0xF40B, 0xF573,
    0xF8CE, 0xE358, 0xF514, 0xF2A1, 0xE981, 0xEE50, 0xE328, 0xE14C, 0xD510, 0xD564, 0xC94B, 0xC863, 0xC142, 0xBE56, 0xB7E8, 0xB1B5,
    0xBE52, 0xA8CE, 0xB8D9, 0xA943, 0xAF73, 0xACA6, 0xA3DD, 0xA29E, 0x9A72, 0xA5F2, 0x9FEA, 0x9DDB, 0x9DBB, 0xB7B9, 0xA702, 0xA707,
    0xAB49, 0xA6E6, 0xA169, 0xA2BA, 0x9FE8, 0x9A38, 0x9BEB, 0x9798, 0x9A09, 0x976A, 0x98E2, 0x9360, 0xA205, 0x9D79, 0xA45B, 0xA1F5,
    0xA635, 0xA796, 0xB07D, 0xAB74, 0xAEBD, 0xB848, 0xAA58, 0xB741, 0xBC22, 0xBA1F, 0xB3D8, 0xB81E, 0xBBF9, 0xC026, 0xAFD2, 0xC385,
    0xBB02, 0xCB3F, 0xCADD, 0xC40D, 0xD085, 0xCB08, 0xE0E9, 0xDDF6, 0xE8BF, 0xE785, 0xF3CD, 0x056B, 0x0D32, 0x0FB7, 0x107D, 0x0B6B,
    0x0EF7, 0x09B9, 0x049C, 0x040D, 0xFD46, 0xEC6A, 0xF888, 0xFCA8, 0xE803, 0xF6EE, 0xF712, 0xFEF8, 0xFDCA, 0xFE55, 0x0375, 0xFC75,
    0x013F, 0x02BD, 0xFEA7, 0xF841, 0x0583, 0xFA9E, 0xF71F, 0xFEC7, 0xF2CD, 0xF92A, 0xF797, 0xED85, 0xE1C3, 0xEF83, 0xED33, 0xE941,
    0xEFB8, 0xEB4C, 0xF755, 0x079C, 0x09C5, 0x1C9F, 0x161D, 0x1BB3, 0x2C28, 0x40C4, 0x4B26, 0x2F6E, 0x3C23, 0x3B5C, 0x3B49, 0x2D25,
    0x3343, 0x2997, 0x201E, 0x1D74, 0x178E, 0x1A28, 0x156C, 0x1612, 0x0FA6, 0x1244, 0x1433, 0x172F, 0x1BF3, 0x1EAC, 0x13C8, 0x1DC6,
    0x17E3, 0x23BF, 0x2807, 0x1E20, 0x32A8, 0x26DE, 0x2DF5, 0x4020, 0x30D1, 0x3737, 0x2C55, 0x3609, 0x37D9, 0x3E49, 0x3E49, 0x3ACD,
    0x3EB8, 0x3D8D, 0x47AF, 0x431B, 0x4FBD, 0x454B, 0x5E82, 0x5B03, 0x573A, 0x56F2, 0x5927, 0x4991, 0x480E, 0x4931, 0x3D1B, 0x3200,
    0x29DE, 0x39D4, 0x1F08, 0x2083, 0x1C17, 0x23DA, 0x1E56, 0x2147, 0x2A80, 0x26B3, 0x27A9, 0x25B7, 0x265F, 0x2DB8, 0x338E, 0x2FCE,
    0x3581, 0x3B19, 0x387C, 0x39E7, 0x3FF6, 0x3B31, 0x40AF, 0x40E5, 0x3F3D, 0x47D5, 0x4C8F, 0x4390, 0x5064, 0x4A74, 0x491B, 0x5139,
    0x5748, 0x54CE, 0x4A76, 0x5CA4, 0x6476, 0x6411, 0x5AAF, 0x5F31, 0x579A, 0x4D52, 0x4B62, 0x4A47, 0x375A, 0x2BC6, 0x307A, 0x2289,
    0x13E8, 0x16CB, 0x1738, 0x08A4, 0xFD2A, 0x04B7, 0xFCE2, 0xF125, 0xF407, 0xE9A3, 0xF054, 0xF5FD, 0xF710, 0xEDCB, 0xFECC, 0xFEE5,
    0x012F, 0xFAD2, 0x0121, 0x0AAC, 0xF6F5, 0xFB43, 0xFB5C, 0xFFAB, 0xFB5D, 0xFFC5, 0xFCC2, 0xF406, 0x0004, 0x06ED, 0xF0EC, 0xFAE5,
    0x04BD, 0x02C9, 0x1609, 0x1CFE, 0x1451, 0x126E, 0x1008, 0x110F, 0x06C2, 0x0193, 0xF9A7, 0xF045, 0xF80A, 0xF18E, 0xECD8, 0xE856,
    0xE81D, 0xF253, 0xEF2B, 0xEABD, 0xF830, 0xE939, 0xE7AC, 0xE818, 0xE5D0, 0xE267, 0xDF9B, 0xE118, 0xE161, 0xD8B3, 0xD890, 0xDEC0,
    0xD46C, 0xD32C, 0xCAEE, 0xC78F, 0xC615, 0xCB72, 0xCC86, 0xC976, 0xCAE0, 0xC858, 0xC464, 0xCE4F, 0xCBE9, 0xCEC4, 0xCDC0, 0xD4E3,
    0xDE74, 0xDF19, 0xDA57, 0xD807, 0xDAED, 0xD910, 0xD722, 0xCB2F, 0xC9C7, 0xC24C, 0xC974, 0xB6E7, 0xB0D7, 0xAF03, 0xB1B4, 0xB387,
    0xAFA7, 0xB60B, 0xAC2F, 0xB456, 0xAEC9, 0xB44D, 0xB41E, 0xA98D, 0xB8C2, 0xB4FD, 0xB554, 0xB9BC, 0xB6AE, 0xBD78, 0xB8AD, 0xBACA,
    0xB023, 0xB46D, 0xB20C, 0xB063, 0xACBE, 0xA314, 0xAAF8, 0xA61F, 0xAA9D, 0xAB04, 0xAB9C, 0xA8E5, 0xB6B3, 0xC075, 0xBF59, 0xC2B1,
    0xC599, 0xC3C5, 0xC82F, 0xCBBF, 0xCCBF, 0xCB32, 0xC4B6, 0xD192, 0xC905, 0xC480, 0xC1F3, 0xC118, 0xC3A0, 0xBF67, 0xC5C8, 0xC16B,
    0xC4F1, 0xC97C, 0xCE00, 0xCA3D, 0xCC39, 0xD753, 0xD519, 0xD6A1, 0xD7F5, 0xDE3B, 0xDCE4, 0xDF3F, 0xE1AC, 0xDDCD, 0xDB43, 0xE6A8,
    0xE358, 0xE399, 0xEA58, 0xE3BE, 0xEFDA, 0xEE6A, 0xFA88, 0x03AB, 0x007C, 0x0ABC, 0x1A87, 0x2835, 0x2C3F, 0x2EFF, 0x2A97, 0x2404,
    0x2484, 0x2282, 0x1392, 0x0579, 0x0C53, 0x0578, 0xF849, 0xF2E5, 0xF22A, 0xED36, 0xE9B0, 0xF37D, 0xEBCC, 0xEDC4, 0xEE7C, 0xF0E2,
    0xF4A8, 0xF41B, 0xFAC4, 0xFD1A, 0x0564, 0x0C21, 0x0E19, 0x1363, 0x1B54, 0x212F, 0x1F75, 0x1DD1, 0x1FFC, 0x2407, 0x239C, 0x2A7B,
    0x3025, 0x287E, 0x311B, 0x35EA, 0x3607, 0x366E, 0x32B1, 0x46F5, 0x4D8D, 0x501E, 0x5940, 0x5469, 0x5386, 0x5BC0, 0x58B1, 0x5293,
    0x4F5B, 0x4BAF, 0x4BC7, 0x4286, 0x40D3, 0x3CB1, 0x3A4A, 0x3506, 0x3D50, 0x3C42, 0x3D78, 0x3F40, 0x3931, 0x377F, 0x3882, 0x3AFB,
    0x33B2, 0x38EB, 0x38D5, 0x3746, 0x32AF, 0x3A1F, 0x3EE6, 0x2F15, 0x2D91, 0x2FAF, 0x2803, 0x30D9, 0x2EE3, 0x35B0, 0x315F, 0x2EB6,
    0x38EE, 0x39E1, 0x3F73, 0x38EA, 0x3B66, 0x44CA, 0x50BF, 0x567E, 0x58B8, 0x51BD, 0x545A, 0x5286, 0x51B6, 0x49D3, 0x3CF9, 0x3CF0,
    0x3535, 0x2C64, 0x2038, 0x1D1C, 0x1976, 0x1765, 0x18FC, 0x1C2B, 0x21F3, 0x1FF4, 0x1CAE, 0x26D0, 0x29B5, 0x27B6, 0x3218, 0x35DE,
    0x3AC6, 0x38A4, 0x3A0A, 0x3F2A, 0x3FCC, 0x3C14, 0x340F, 0x320D, 0x281D, 0x2B1D, 0x28BE, 0x23E4, 0x1A10, 0x1823, 0x1F68, 0x1DCC,
    0x1F72, 0x1AE9, 0x242E, 0x2970, 0x30BA, 0x39CE, 0x3A33, 0x3594, 0x38D9, 0x3C5C, 0x34EE, 0x30AF, 0x2E93, 0x2C7F, 0x24BD, 0x229F,
    0x1DBF, 0x1254, 0x13A0, 0x156D, 0x12E2, 0x19D3, 0x16E4, 0x144A, 0x1A1B, 0x1EA0, 0x1AC3, 0x17BD, 0x1C62, 0x185F, 0x16CC, 0x12A6,
    0x1559, 0x1603, 0x0F72, 0x07B6, 0x039C, 0x017C, 0xFE04, 0x0067, 0xFAF0, 0xF6B9, 0xF15D, 0xF5FE, 0xF9FA, 0xFB2A, 0xFA47, 0xFCA5,
    0x0B35, 0x164E, 0x1E57, 0x2552, 0x1E5B, 0x18AE, 0x1BC2, 0x1068, 0x05ED, 0xF930, 0xF5D2, 0xEC9F, 0xE408, 0xD9CA, 0xCEAE, 0xCC1A,
    0xC569, 0xC055, 0xBF6D, 0xC504, 0xBFBD, 0xBD9E, 0xC160, 0xC3BF, 0xC4F8, 0xC8DF, 0xCCAC, 0xCE10, 0xCB1D, 0xCF7D, 0xD45B, 0xD30C,
    0xD1EB, 0xCF82, 0xCB29, 0xC88B, 0xCFF3, 0xCD94, 0xCDA6, 0xCFB6, 0xC8F1, 0xD366, 0xD5C2, 0xD22F, 0xD54E, 0xD0D6, 0xDD48, 0xE5A9,
    0xEBDA, 0xEE5E, 0xEBDF, 0xEBB9, 0xEB4F, 0xE6E3, 0xDB81, 0xD68A, 0xCF0F, 0xC9A8, 0xBFD8, 0xB733, 0xB612, 0xB73B, 0xB40A, 0xB260,
    0xAECD, 0xB110, 0xB1A1, 0xAA80, 0xA9CB, 0xA6E4, 0xA401, 0xA4CF, 0xA76B, 0xA3EF, 0xA357, 0xA1E7, 0xA627, 0xA47D, 0xA683, 0xA749,
    0xA120, 0xA6C5, 0xA973, 0xADD7, 0xB029, 0xB0CE, 0xB615, 0xBE61, 0xC092, 0xC2E8, 0xC70D, 0xCBE4, 0xD726, 0xE232, 0xE4D8, 0xE872,
    0xEAC7, 0xEB92, 0xECC4, 0xE3E4, 0xE0A2, 0xDEB9, 0xD663, 0xD54D, 0xD01A, 0xC5E0, 0xC5CF, 0xC3E0, 0xC663, 0xCC5D, 0xC606, 0xC460,
    0xCC9E, 0xCD8F, 0xCC6B, 0xC955, 0xC9EC, 0xD19A, 0xCC67, 0xD0DA, 0xD37D, 0xD4EE, 0xD963, 0xDB43, 0xDD1C, 0xD5FB, 0xD651, 0xD77A,
    0xD423, 0xD59D, 0xD2DD, 0xCD61, 0xD4EC, 0xD26B, 0xCF75, 0xCB51, 0xCCA8, 0xD2A7, 0xD6C8, 0xE020, 0xE027, 0xDE69, 0xE2AE, 0xE991,
    0xE50A, 0xE0AE, 0xDEA6, 0xDDBF, 0xDB57, 0xD659, 0xD67F, 0xD133, 0xCD32, 0xD027, 0xD217, 0xDBCE, 0xDD96, 0xDEA8, 0xE626, 0xEB70,
    0xECB6, 0xECC7, 0xF5AC, 0xFAD5, 0xFC0C, 0xFB41, 0x00BE, 0x068B, 0x0719, 0x0C44, 0x03F6, 0x00D9, 0x026F, 0x004D, 0x08D6, 0x018E,
    0x018B, 0x0074, 0x07A0, 0x0ECA, 0x08DA, 0x0C45, 0x12E4, 0x1BFD, 0x20B9, 0x28C0, 0x2955, 0x267B, 0x2436, 0x252F, 0x1705, 0x0F05,
    0x125C, 0x0612, 0x014B, 0xFC4F, 0xEEBE, 0xEAB4, 0xE038, 0xE32B, 0xE23B, 0xDCD8, 0xE0D3, 0xDF7E, 0xE32D, 0xE875, 0xE7E5, 0xE5FF,
    0xF240, 0xF091, 0xF382, 0xEE8B, 0xF75C, 0xF9D8, 0xF8BA, 0xF931, 0xF9B7, 0xFA6B, 0xF3D7, 0x0064, 0xFFA1, 0xFFB6, 0xFC46, 0x029A,
    0x080B, 0x050F, 0x0756, 0x0748, 0x0861, 0x1A34, 0x249E, 0x298C, 0x289E, 0x2F48, 0x39A0, 0x39E1, 0x37AB, 0x36E7, 0x3974, 0x36A1,
    0x3A40, 0x392F, 0x39AE, 0x3C07, 0x3DA3, 0x3D7B, 0x4329, 0x447D, 0x42A8, 0x3E29, 0x3DFF, 0x3B35, 0x3A5F, 0x3781, 0x3ADA, 0x3583,
    0x303B, 0x3394, 0x3181, 0x33F7, 0x2FB0, 0x33CE, 0x2AE1, 0x255C, 0x2B91, 0x34EA, 0x3024, 0x2ACE, 0x2D31, 0x38A6, 0x38DF, 0x3572,
    0x3D64, 0x3977, 0x4284, 0x5117, 0x58DB, 0x5C5D, 0x6095, 0x63C5, 0x6151, 0x60B6, 0x5CB8, 0x5662, 0x556B, 0x4FCB, 0x49B6, 0x42BF,
    0x3E31, 0x3568, 0x3536, 0x3051, 0x2EE1, 0x2E31, 0x2BFD, 0x2C61, 0x29BA, 0x26B8, 0x1EB3, 0x26F2, 0x2441, 0x2697, 0x2675, 0x2718,
    0x2D79, 0x3008, 0x32BF, 0x2F81, 0x2A25, 0x2BCA, 0x2D0D, 0x2CA6, 0x2843, 0x2574, 0x2741, 0x2292, 0x261A, 0x203C, 0x2003, 0x1D91,
    0x25B0, 0x2EBC, 0x2FAF, 0x337A, 0x3547, 0x3CA4, 0x3D42, 0x3927, 0x32E9, 0x348D, 0x302B, 0x290D, 0x2336, 0x1C48, 0x161C, 0x11C8,
    0x12D6, 0x1437, 0x117E, 0x131F, 0x1672, 0x161A, 0x1503, 0x141A, 0x1728, 0x1741, 0x1A61, 0x17E4, 0x1A7A, 0x1C36, 0x1E31, 0x2251,
    0x2091, 0x1C81, 0x1380, 0x17BF, 0x1ADD, 0x17AE, 0x1173, 0x1905, 0x1A62, 0x1A39, 0x1CC6, 0x1C9C, 0x1F2F, 0x1D53, 0x2CAD, 0x34B5,
    0x3886, 0x39D8, 0x3BDB, 0x3BCE, 0x367F, 0x2E75, 0x24AF, 0x2180, 0x16B3, 0x0C7F, 0x0182, 0xF324, 0xE7AD, 0xDDB3, 0xD6DF, 0xD240,
    0xCA6B, 0xC98D, 0xC9A2, 0xCB00, 0xC84B, 0xCAA5, 0xD1C4, 0xD4D0, 0xDBD4, 0xD9B6, 0xE33D, 0xE672, 0xEDC4, 0xF41B, 0xF365, 0xF18F,
    0xEB98, 0xF0BC, 0xEF50, 0xEBC2, 0xE7B0, 0xE741, 0xE480, 0xE676, 0xE51C, 0xDD67, 0xDDFF, 0xE3F6, 0xECC7, 0xF149, 0xF43D, 0xF7EA,
    0xFB98, 0xFF95, 0xFAF6, 0xF4B9, 0xF240, 0xEFF1, 0xED35, 0xE84A, 0xE30C, 0xDD5C, 0xD957, 0xD8A6, 0xD93F, 0xD5D9, 0xD37F, 0xD555,
    0xD51A, 0xD3A2, 0xD1A0, 0xD190, 0xD004, 0xD17A, 0xD24B, 0xCB0E, 0xCE5E, 0xCD7D, 0xCE8E, 0xCE6A, 0xC91F, 0xC5EB, 0xC4F9, 0xCA55,
    0xC43D, 0xC37D, 0xC522, 0xC1ED, 0xC369, 0xC46B, 0xC650, 0xC346, 0xC475, 0xD036, 0xDA1D, 0xE058, 0xE5A8, 0xEF57, 0xF6F3, 0xF4A2,
    0xF31B, 0xF1B4, 0xECE1, 0xEC1E, 0xE396, 0xDDE1, 0xD6A3, 0xCF0F, 0xCDB6, 0xC8E8, 0xC861, 0xC5BC, 0xC533, 0xC4E2, 0xC476, 0xC27D,
    0xC1C7, 0xC582, 0xC5CE, 0xC681, 0xCA1F, 0xCC04, 0xD031, 0xD140, 0xD3D3, 0xD516, 0xCE47, 0xCE0D, 0xCD0B, 0xCC51, 0xC53E, 0xC2E9,
    0xC21E, 0xBEFC, 0xC279, 0xBDFB, 0xBA4B, 0xB7DE, 0xBAC4, 0xC355, 0xC733, 0xC99E, 0xCC9A, 0xD18A, 0xDB6B, 0xDD2F, 0xDC56, 0xDE67,
    0xDC27, 0xD9F3, 0xD806, 0xD562, 0xCD76, 0xC619, 0xC7B3, 0xC742, 0xC794, 0xC8E4, 0xC9C5, 0xCD47, 0xCC0D, 0xCC9E, 0xC985, 0xCC87,
    0xCC11, 0xC925, 0xC92F, 0xC85D, 0xCC51, 0xCC84, 0xCF9F, 0xC80B, 0xC315, 0xC202, 0xC129, 0xBDD1, 0xBA9D, 0xBC0B, 0xBB8A, 0xC0F2,
    0xC89B, 0xCC1E, 0xCBCC, 0xD0B0, 0xDC35, 0xEA65, 0xF2C7, 0xFE3A, 0x03C6, 0x0D84, 0x10DF, 0x0BC0, 0x095F, 0x041A, 0x007B, 0xF36A,
    0xEA9C, 0xE0B5, 0xD47A, 0xCE1E, 0xC88D, 0xC5BE, 0xC480, 0xC560, 0xCB22, 0xCCB3, 0xCF1F, 0xCFEE, 0xD637, 0xDAC2, 0xD9FB, 0xDFEB,
    0xE2F4, 0xE6A3, 0xEC66, 0xF5D8, 0xFA61, 0xF7DE, 0xF6D0, 0xFBB0, 0xFF89, 0xFF7F, 0xFED1, 0x0394, 0x0444, 0x08BD, 0x0B0A, 0x081D,
    0x08A6, 0x0BB0, 0x18D0, 0x1C7D, 0x24F9, 0x2A87, 0x2FD5, 0x36D7, 0x358B, 0x3406, 0x302C, 0x2D9B, 0x2796, 0x2407, 0x2186, 0x19A7,
    0x11F1, 0x0D8C, 0x0E45, 0x105C, 0x0AAC, 0x0E4F, 0x0FBF, 0x0FE8, 0x0F2D, 0x0FCE, 0x14EA, 0x13BB, 0x16E6, 0x16A4, 0x1624, 0x184B,
    0x1A34, 0x1C29, 0x1AD6, 0x13D9, 0x1319, 0x171E, 0x16BC, 0x1436, 0x15FC, 0x14C0, 0x18B5, 0x2176, 0x2215, 0x1EB3, 0x210C, 0x2915,
    0x327E, 0x3D0D, 0x4279, 0x4A68, 0x5077, 0x5377, 0x50FC, 0x4E98, 0x49C4, 0x45AF, 0x402C, 0x3BA1, 0x3779, 0x2E80, 0x29CA, 0x24CB,
    0x218D, 0x1C28, 0x1A9F, 0x18DA, 0x179C, 0x1454, 0x124C, 0x1457, 0x171E, 0x1849, 0x1AA9, 0x1F58, 0x1DC9, 0x2336, 0x28AD, 0x2AD6,
    0x25DB, 0x210C, 0x2004, 0x1CE0, 0x18EB, 0x1472, 0x10CC, 0x0B88, 0x0C7F, 0x0B6F, 0x0385, 0xFC02, 0xFC7A, 0xFFC9, 0x0562, 0x06DE,
    0x0A79, 0x1116, 0x1646, 0x1AB3, 0x17BC, 0x1696, 0x141C, 0x0FFF, 0x0F47, 0x0DF3, 0x0961, 0x028F, 0x054C, 0x0BE2, 0x0BC3, 0x121A,
    0x1526, 0x1F49, 0x24A7, 0x2446, 0x2A2E, 0x2EE8, 0x3033, 0x2F7B, 0x3378, 0x3690, 0x368E, 0x3A52, 0x40DF, 0x428B, 0x3FF4, 0x3C64,
    0x4096, 0x3E4E, 0x3FC5, 0x3D7D, 0x3C04, 0x3F55, 0x4473, 0x4900, 0x44EC, 0x4597, 0x4A6B, 0x5126, 0x599A, 0x5D87, 0x61E7, 0x6802,
    0x66FE, 0x6866, 0x6673, 0x622D, 0x5D3E, 0x5861, 0x52F6, 0x4DE9, 0x4187, 0x35E0, 0x2B59, 0x2445, 0x1D1A, 0x18FA, 0x1752, 0x13EC,
    0x156A, 0x10DF, 0x105E, 0x0EE3, 0x0DCA, 0x09AA, 0x083D, 0x04B1, 0x0469, 0x0A00, 0x0B45, 0x0AA0, 0x0755, 0x0829, 0x0893, 0x0849,
    0x06D0, 0x023C, 0x008F, 0x0687, 0x0A58, 0x08A5, 0x06A6, 0x05FB, 0x0C2C, 0x1591, 0x19E2, 0x1DA0, 0x218C, 0x2783, 0x2A35, 0x2B05,
    0x28FA, 0x2536, 0x2429, 0x2223, 0x22AF, 0x1D26, 0x15E7, 0x120E, 0x0F11, 0x0B9E, 0x0844, 0x0813, 0x0709, 0x05BB, 0x02CE, 0x00DB,
    0x01C6, 0xFDC2, 0xFB02, 0xFD10, 0xF6BF, 0xF238, 0xF529, 0xF761, 0xF6E4, 0xEF68, 0xED33, 0xED2C, 0xEB7F, 0xEAC6, 0xE902, 0xE649,
    0xE53A, 0xEB0D, 0xED8B, 0xEB92, 0xE8FA, 0xEAB2, 0xEFEB, 0xF74E, 0x009E, 0x0B70, 0x1275, 0x17A8, 0x1B06, 0x1AC3, 0x1A5A, 0x12BA,
    0x0B6C, 0x074A, 0x033F, 0xFBE2, 0xF339, 0xEF05, 0xE8D2, 0xE22E, 0xDC09, 0xD8B8, 0xD6A2, 0xD0C0, 0xCD14, 0xC9CA, 0xC866, 0xC849,
    0xC9A1, 0xCBF2, 0xCD0C, 0xD1CF, 0xDCD2, 0xE5FE, 0xEA4C, 0xED91, 0xF071, 0xF415, 0xF6C0, 0xF899, 0xF7FC, 0xF6F7, 0xF705, 0xFA80,
    0xF840, 0xEFA9, 0xE97A, 0xE7CF, 0xE73E, 0xE7B0, 0xEAC9, 0xED57, 0xF0CA, 0xF4B7, 0xF638, 0xF582, 0xF348, 0xEF39, 0xECC5, 0xEA7D,
    0xE526, 0xDE79, 0xD8A8, 0xD667, 0xD41E, 0xD314, 0xD42C, 0xD596, 0xD629, 0xD395, 0xD71B, 0xD573, 0xD3E0, 0xD632, 0xD909, 0xD9DB,
    0xD627, 0xDC90, 0xE1BF, 0xE26B, 0xDF68, 0xDC1B, 0xDA48, 0xD95F, 0xD8BD, 0xD437, 0xCFEC, 0xCE34, 0xD1FD, 0xD36F, 0xD167, 0xCD3F,
    0xCD39, 0xD099, 0xD322, 0xDAC2, 0xE00F, 0xE70D, 0xEC90, 0xEE77, 0xF344, 0xF25F, 0xED6C, 0xE761, 0xE3AD, 0xE099, 0xD5B0, 0xCE9F,
    0xC6E7, 0xC24B, 0xBECE, 0xBAA6, 0xBBBA, 0xBA0A, 0xB995, 0xB963, 0xBA41, 0xB80D, 0xB91D, 0xBC7B, 0xBC2B, 0xBAF7, 0xBC85, 0xC2D9,
    0xCAFC, 0xCDBC, 0xD02E, 0xD12E, 0xD0A9, 0xD3AC, 0xD208, 0xCF26, 0xCA80, 0xCACA, 0xCE5F, 0xCF61, 0xCD59, 0xCACE, 0xCC5D, 0xD1AF,
    0xD51B, 0xD8B4, 0xDE0D, 0xE1D0, 0xE798, 0xEAB4, 0xEDBB, 0xEF6D, 0xEEBA, 0xF1D9, 0xF278, 0xF0DF, 0xEEE3, 0xEA59, 0xE788, 0xE5C2,
    0xE49A, 0xE42A, 0xE4AA, 0xE5DB, 0xE888, 0xEB3B, 0xE8E3, 0xE7A2, 0xE969, 0xE9D2, 0xE58D, 0xDEC0, 0xDD5D, 0xDF4D, 0xDF38, 0xDB8B,
    0xD7AC, 0xD682, 0xD489, 0xD3F1, 0xCFF7, 0xC99B, 0xC76D, 0xC5B1, 0xC950, 0xC6F5, 0xC2C7, 0xC3B3, 0xC589, 0xCDFC, 0xD74F, 0xE166,
    0xEEDF, 0xFB0B, 0x0649, 0x0D7F, 0x108D, 0x1003, 0x0D4E, 0x0F2C, 0x0DD1, 0x08C6, 0x0163, 0xFC97, 0xF4F3, 0xEC5C, 0xE5C1, 0xE205,
    0xDE5D, 0xD8BF, 0xD766, 0xD765, 0xD53A, 0xD3FB, 0xD93A, 0xDA7E, 0xDB16, 0xDE59, 0xE59F, 0xED72, 0xF202, 0xF508, 0xF50B, 0xF5EB,
    0xF820, 0xF6D4, 0xF400, 0xEED6, 0xEDB6, 0xF29C, 0xF40E, 0xF09E, 0xEA90, 0xEA17, 0xEB85, 0xF11B, 0xF4F9, 0xFA79, 0x038C, 0x09CA,
    0x1288, 0x1848, 0x1BCF, 0x1AC2, 0x19B0, 0x1A4E, 0x1849, 0x143E, 0x0D42, 0x0849, 0x0561, 0x0135, 0x0017, 0x010E, 0x0100, 0x034F,
    0x03AF, 0x031E, 0x02D0, 0x05FC, 0x0A1F, 0x0990, 0x0B08, 0x0F84, 0x197D, 0x2186, 0x2573, 0x299C, 0x288D, 0x29AE, 0x2DA9, 0x2C90,
    0x286A, 0x236E, 0x255C, 0x2AC2, 0x2EA2, 0x2E40, 0x2B82, 0x2FBC, 0x33C3, 0x3CF1, 0x474B, 0x4FA7, 0x58E4, 0x5DC8, 0x62C0, 0x62ED,
    0x5EF1, 0x595E, 0x54B6, 0x4FB4, 0x4675, 0x3D9A, 0x33D0, 0x2A73, 0x2119, 0x17D1, 0x101F, 0x0B6C, 0x06CC, 0x0299, 0x00F8, 0xFD08,
    0xFC27, 0xFE49, 0x00F2, 0xFC53, 0xFBC6, 0x02C7, 0x07B3, 0x0FA2, 0x12D4, 0x16B5, 0x1950, 0x1A06, 0x1D56, 0x194B, 0x12CD, 0x0E36,
    0x108A, 0x1359, 0x0E65, 0x0BB5, 0x0B93, 0x0FC5, 0x1271, 0x134B, 0x1934, 0x1F05, 0x21A7, 0x23AE, 0x27F1, 0x285A, 0x238A, 0x20B2,
    0x1FFB, 0x1D76, 0x177E, 0x0DFC, 0x0924, 0x03D0, 0xFD51, 0xFCA0, 0xFC28, 0xFD33, 0x00D6, 0x04F1, 0x06AD, 0x06FA, 0x0B29, 0x1041,
    0x0F93, 0x0D16, 0x0DD4, 0x109F, 0x1504, 0x17E8, 0x1856, 0x16A5, 0x14F6, 0x1627, 0x17B5, 0x13CE, 0x0DBF, 0x0C83, 0x1109, 0x155A,
    0x13AC, 0x11FC, 0x1175, 0x14B4, 0x1D41, 0x285B, 0x338C, 0x3B27, 0x4448, 0x4E19, 0x539A, 0x528D, 0x50F9, 0x5205, 0x5240, 0x50C7,
    0x4CFC, 0x4A51, 0x4789, 0x429F, 0x3D02, 0x3A7C, 0x3613, 0x31C1, 0x31AB, 0x3020, 0x2C02, 0x2A4A, 0x303B, 0x3251, 0x3131, 0x315B,
    0x3130, 0x358C, 0x3AFD, 0x3CE6, 0x3AAC, 0x385E, 0x382D, 0x392C, 0x363A, 0x2CB4, 0x2847, 0x2891, 0x25F1, 0x21B4, 0x1B46, 0x1481,
    0x11CC, 0x0F86, 0x1029, 0x160B, 0x1901, 0x1CCF, 0x2296, 0x2904, 0x2AC9, 0x27DD, 0x25E9, 0x2659, 0x262D, 0x1E74, 0x17BC, 0x14B4,
    0x0FDD, 0x0BB1, 0x0A69, 0x0A4D, 0x09DB, 0x0AB3, 0x0D68, 0x0BC9, 0x082D, 0x0822, 0x0A4B, 0x0849, 0x0465, 0x068E, 0x08ED, 0x0E71,
    0x137F, 0x1572, 0x1387, 0x0F26, 0x10E8, 0x0EB5, 0x0855, 0x0114, 0xFE5D, 0x0199, 0x0579, 0x06A6, 0x0429, 0x03E3, 0x0597, 0x08F9,
    0x0EB2, 0x1586, 0x1D38, 0x26EE, 0x3056, 0x3799, 0x3694, 0x32AA, 0x30CD, 0x2C33, 0x2479, 0x196D, 0x0ED5, 0x04DA, 0xF918, 0xF06D,
    0xE9C7, 0xE184, 0xDACA, 0xD85B, 0xD54D, 0xCE1E, 0xCAA7, 0xC6CB, 0xC507, 0xC125, 0xBB41, 0xBA4D, 0xBB3C, 0xBFB0, 0xC439, 0xC640,
    0xC846, 0xCC5E, 0xD15E, 0xD4B6, 0xD1FD, 0xD41E, 0xD937, 0xDF99, 0xE46A, 0xE3FC, 0xE70A, 0xE90C, 0xECEF, 0xF56C, 0xFD2C, 0x011A,
    0x0498, 0x0C03, 0x1340, 0x147A, 0x1326, 0x139F, 0x155E, 0x1558, 0x117F, 0x0E68, 0x0C93, 0x0859, 0x0371, 0x0197, 0x0097, 0x0044,
    0x021F, 0x02EC, 0x04C8, 0x042C, 0x03FE, 0x064F, 0x0408, 0x00DA, 0xFCFF, 0xFAFE, 0xFC24, 0xFD47, 0xFCCC, 0xF87B, 0xF54C, 0xF56B,
    0xF687, 0xF119, 0xE7F0, 0xE1D0, 0xE05A, 0xE253, 0xDEE9, 0xD950, 0xD670, 0xD509, 0xD34E, 0xD778, 0xDCD1, 0xE003, 0xE6CF, 0xEE24,
    0xF4F0, 0xF6CC, 0xF46D, 0xF1F6, 0xF04F, 0xEC85, 0xE81D, 0xE42B, 0xDD00, 0xD594, 0xD12C, 0xCC23, 0xC519, 0xC01C, 0xBE29, 0xBC2B,
    0xB898, 0xB751, 0xB8FE, 0xBA0D, 0xBA17, 0xB96D, 0xB87C, 0xB9FA, 0xBFC2, 0xC4B4, 0xC677, 0xC9BE, 0xCEC1, 0xD480, 0xD8CB, 0xD738,
    0xD4B0, 0xD404, 0xD3F6, 0xD39F, 0xD018, 0xCAAF, 0xC542, 0xC401, 0xC657, 0xC9A9, 0xCAF6, 0xCDC7, 0xD3B4, 0xD982, 0xDCEF, 0xDA8C,
    0xD8FD, 0xD946, 0xD84B, 0xD653, 0xD4A8, 0xD180, 0xCDEA, 0xCCAC, 0xCAB2, 0xCADD, 0xC8CF, 0xC887, 0xCB04, 0xC9EC, 0xC997, 0xCAC1,
    0xCE35, 0xCFDD, 0xD026, 0xD04E, 0xD0EE, 0xD534, 0xDB88, 0xDEE5, 0xDF8C, 0xDE5E, 0xDF44, 0xE3E1, 0xE311, 0xDBA9, 0xD644, 0xD71B,
    0xD8D3, 0xD90D, 0xD663, 0xD2D1, 0xD0C0, 0xD05B, 0xD376, 0xD8D5, 0xDF6D, 0xE651, 0xF0B1, 0xFE72, 0x06C6, 0x0A1B, 0x0E07, 0x1011,
    0x10DB, 0x0E2D, 0x09C2, 0x04FF, 0xFCF1, 0xF644, 0xEFDB, 0xE8DC, 0xE2F9, 0xE0BD, 0xDDC9, 0xD609, 0xD039, 0xCFC0, 0xCEB5, 0xCB1F,
    0xC7D8, 0xC5CE, 0xC773, 0xCB17, 0xD2B7, 0xD865, 0xDACC, 0xDE1A, 0xE1DB, 0xE784, 0xE697, 0xE240, 0xE0E4, 0xE1F9, 0xE74D, 0xE7F8,
    0xE5D4, 0xE566, 0xE48C, 0xE7A3, 0xEA9D, 0xEC9D, 0xF06D, 0xF7E5, 0x001B, 0x0500, 0x07A2, 0x0A26, 0x0DBB, 0x0F21, 0x0FA7, 0x0F25,
    0x0CE6, 0x08C5, 0x03D5, 0x00C2, 0xFC57, 0xF808, 0xF78F, 0xF976, 0xF878, 0xF589, 0xF426, 0xF13C, 0xF049, 0xEDC8, 0xE7AC, 0xE367,
    0xE2CA, 0xE607, 0xE92E, 0xEA91, 0xE936, 0xEE39, 0xF761, 0xF92E, 0xF5D7, 0xF2A8, 0xF437, 0xF787, 0xFB35, 0xFC2F, 0xFA18, 0xF98B,
    0xFBAB, 0x0093, 0x06F1, 0x0E60, 0x196D, 0x2966, 0x37A9, 0x4186, 0x479C, 0x4BAB, 0x4F25, 0x5073, 0x4C2C, 0x49D4, 0x4559, 0x3E01,
    0x3A03, 0x329D, 0x2B3F, 0x2432, 0x219A, 0x1C63, 0x146E, 0x1002, 0x0CEA, 0x0BF4, 0x0A52, 0x06A4, 0x033E, 0x03D0, 0x066B, 0x0E06,
    0x12FF, 0x1534, 0x1A74, 0x2149, 0x2988, 0x2C54, 0x2976, 0x27C9, 0x2A79, 0x2C09, 0x28CD, 0x230B, 0x1E0E, 0x1810, 0x124B, 0x11B5,
    0x1015, 0x1106, 0x163D, 0x1BD5, 0x2224, 0x2376, 0x23AF, 0x233D, 0x2116, 0x1E72, 0x1C6A, 0x1954, 0x1143, 0x0ACB, 0x06A6, 0x007D,
    0xFA4B, 0xF71F, 0xF699, 0xF5EA, 0xF38E, 0xF2C5, 0xF4D2, 0xF9AF, 0xFE41, 0x0123, 0x04C0, 0x0A16, 0x14F8, 0x1CB8, 0x1E18, 0x2056,
    0x22D7, 0x283E, 0x29B8, 0x25B5, 0x208A, 0x1DE0, 0x1EF2, 0x1DED, 0x1CC7, 0x1954, 0x14B2, 0x1379, 0x1514, 0x188F, 0x1D7E, 0x22E8,
    0x2D54, 0x39A7, 0x41DA, 0x45FD, 0x4748, 0x49F0, 0x48B2, 0x4631, 0x4329, 0x3C2B, 0x35A2, 0x2EA7, 0x2A03, 0x217F, 0x1C0C, 0x1B61,
    0x16A5, 0x118A, 0x0AAC, 0x0828, 0x07C4, 0x05BA, 0x0389, 0x034B, 0x0109, 0x0329, 0x0C4D, 0x13C6, 0x17A1, 0x196A, 0x1E63, 0x2497,
    0x2779, 0x2321, 0x1FD1, 0x1E18, 0x1DB5, 0x1EDF, 0x1D53, 0x1A2D, 0x1659, 0x16A7, 0x16FE, 0x18D0, 0x1C8E, 0x201B, 0x287A, 0x30A0,
    0x3732, 0x3B90, 0x3D63, 0x3F7B, 0x4034, 0x407F, 0x3FCA, 0x3967, 0x3502, 0x3137, 0x2B26, 0x2744, 0x23C0, 0x25D9, 0x26C7, 0x253C,
    0x2501, 0x25C5, 0x27F9, 0x2768, 0x22FD, 0x1D58, 0x1939, 0x19AC, 0x1C65, 0x1AF9, 0x1892, 0x1750, 0x1973, 0x1CB7, 0x16B9, 0x0DA9,
    0x06CC, 0x018F, 0xFF96, 0xFE62, 0xFA98, 0xF40F, 0xF0CB, 0xEF27, 0xF0F8, 0xF299, 0xF4AC, 0xFE03, 0x09AC, 0x1355, 0x1ABB, 0x21D7,
    0x262E, 0x2916, 0x2C8A, 0x2C18, 0x27EA, 0x240F, 0x1F45, 0x186F, 0x0FA6, 0x066E, 0x00B7, 0xFBF5, 0xF68B, 0xF2E0, 0xEE6C, 0xEB11,
    0xE99B, 0xE7CE, 0xE167, 0xD96A, 0xD654, 0xD7CB, 0xDB90, 0xDA3C, 0xD766, 0xD979, 0xDF09, 0xE09C, 0xDBB3, 0xD7EB, 0xD6F2, 0xD680,
    0xD652, 0xD4C9, 0xD275, 0xD009, 0xCEC5, 0xD0B2, 0xD3C8, 0xD636, 0xDB6B, 0xE586, 0xEF03, 0xF63E, 0xFB1D, 0xFE19, 0x013E, 0x023A,
    0x0249, 0x007E, 0xFC18, 0xF88A, 0xF5FE, 0xF166, 0xE9AA, 0xE76D, 0xE87D, 0xE724, 0xE459, 0xE35F, 0xE2A7, 0xE3DB, 0xE73C, 0xE881,
    0xE9EB, 0xEC04, 0xF44C, 0xFBF8, 0x0160, 0x034F, 0x0507, 0x0CC3, 0x11D7, 0x142E, 0x11BB, 0x1000, 0x10D6, 0x11A0, 0x12C5, 0x1418,
    0x1217, 0x0E52, 0x0E68, 0x0F48, 0x1292, 0x154C, 0x1CB5, 0x27E8, 0x31CA, 0x3AF4, 0x4056, 0x43C8, 0x4352, 0x4024, 0x3C93, 0x3562,
    0x2AEF, 0x21C0, 0x16A0, 0x0A41, 0x0078, 0xF7F6, 0xF0B6, 0xE7B5, 0xE031, 0xD9E5, 0xD4D3, 0xD266, 0xCFFF, 0xCC9D, 0xC74C, 0xC5D5,
    0xC986, 0xCE38, 0xCE47, 0xCED3, 0xD4E1, 0xDB46, 0xDEDC, 0xE02C, 0xDF37, 0xE059, 0xE3E5, 0xE585, 0xE8B5, 0xE9E1, 0xE928, 0xE933,
    0xEA07, 0xEA9D, 0xEBD8, 0xEE37, 0xF322, 0xFB0F, 0x003F, 0x0376, 0x06A8, 0x082B, 0x0775, 0x0778, 0x0667, 0x0279, 0xFFAC, 0xFC88,
    0xF611, 0xF099, 0xEDE5, 0xEE05, 0xEDF1, 0xED38, 0xED00, 0xEE3D, 0xF032, 0xF0CC, 0xF0B5, 0xED97, 0xEB8F, 0xED4B, 0xF16F, 0xF558,
    0xF49E, 0xF638, 0xFACA, 0xFE44, 0xFF35, 0xFBB7, 0xF6B5, 0xF2D5, 0xEF3F, 0xEEB9, 0xED67, 0xE73F, 0xE350, 0xDFF2, 0xDE63, 0xDC75,
    0xDB1B, 0xDDC4, 0xE34B, 0xEA8D, 0xF090, 0xF8F3, 0xFF42, 0x016A, 0x054A, 0x09AC, 0x09A7, 0x08E1, 0x0749, 0x03DA, 0x0131, 0xFD00,
    0xFA3F, 0xF8DD, 0xF6DE, 0xF4F7, 0xF16D, 0xEF63, 0xEFB4, 0xEFE5, 0xECF7, 0xE6FF, 0xE4CB, 0xE664, 0xE942, 0xEDC8, 0xF090, 0xF672,
    0x01D2, 0x09FB, 0x109F, 0x12F3, 0x137F, 0x1419, 0x13EC, 0x15F9, 0x13F7, 0x0F13, 0x0BF1, 0x0926, 0x09E3, 0x0925, 0x07C7, 0x0C89,
    0x1098, 0x15BC, 0x19E6, 0x1C11, 0x1BBC, 0x1C26, 0x1DB9, 0x1BEC, 0x190D, 0x16B7, 0x1420, 0x0E95, 0x0767, 0x01A6, 0xFE21, 0xFB77,
    0xF87C, 0xF4B7, 0xF369, 0xF2D2, 0xF504, 0xF7AA, 0xF463, 0xF200, 0xF253, 0xF4BC, 0xF770, 0xF4E8, 0xF1F0, 0xF364, 0xF649, 0xF742,
    0xF586, 0xF0E3, 0xECDD, 0xED87, 0xEF99, 0xF07E, 0xEF73, 0xEBE7, 0xEA38, 0xEA6E, 0xEA38, 0xE954, 0xECF7, 0xF7A7, 0x03AF, 0x103D,
    0x1CF9, 0x260B, 0x2B37, 0x318E, 0x350D, 0x3353, 0x2F8D, 0x2CB3, 0x296D, 0x22BD, 0x1A87, 0x14D8, 0x100D, 0x0A3C, 0x0301, 0xF9E3,
    0xF229, 0xECBC, 0xEA69, 0xE477, 0xDC12, 0xD802, 0xD776, 0xD9FC, 0xDC9B, 0xDC0A, 0xDE81, 0xE37E, 0xE6A6, 0xEA0F, 0xEA85, 0xE9A0,
    0xEA41, 0xECB5, 0xF2E2, 0xF62F, 0xF722, 0xF46B, 0xF3F0, 0xF6F7, 0xF4C2, 0xF49A, 0xF7AC, 0xFDD5, 0x057F, 0x0B7A, 0x1007, 0x1419,
    0x1699, 0x19A0, 0x19DD, 0x191A, 0x1766, 0x13A4, 0x0F38, 0x068D, 0x0107, 0xFE6A, 0xFA5B, 0xF852, 0xF560, 0xF1B0, 0xEFFE, 0xEE93,
    0xED7E, 0xEA13, 0xE534, 0xE31C, 0xE677, 0xE9F9, 0xEA8C, 0xEBD0, 0xF13F, 0xF84B, 0xFD37, 0x0057, 0xFEF5, 0xFB5C, 0xF919, 0xF84E,
    0xF87E, 0xF5CC, 0xF18C, 0xEFAD, 0xEFFF, 0xED94, 0xEBB7, 0xEDD5, 0xF1AC, 0xF896, 0x0280, 0x0CE6, 0x1479, 0x1B48, 0x2153, 0x2626,
    0x26FF, 0x24A4, 0x233A, 0x20A3, 0x1ADB, 0x1460, 0x0EFD, 0x09E5, 0x0663, 0x0197, 0xF9BA, 0xF589, 0xF355, 0xF1EE, 0xF078, 0xEC17,
    0xE76A, 0xE692, 0xE9DA, 0xECB6, 0xEF9B, 0xF418, 0xFBA6, 0x058A, 0x0E0B, 0x11D3, 0x1244, 0x1069, 0x0F25, 0x0E90, 0x0C67, 0x06B0,
    0x0019, 0xFC7E, 0xF7B3, 0xF1DB, 0xEEF2, 0xEE10, 0xEFAE, 0xF0D5, 0xF48A, 0xFA8F, 0xFC26, 0xFE14, 0x013D, 0x037A, 0x042D, 0x04AE,
    0x03DD, 0x00B1, 0xFB14, 0xF693, 0xF129, 0xEBF8, 0xE9BC, 0xE72D, 0xE646, 0xE723, 0xE8EB, 0xED83, 0xF008, 0xEF25, 0xEFA6, 0xF3B4,
    0xF9F6, 0xFD9B, 0x00F9, 0x0602, 0x0D22, 0x14C6, 0x194C, 0x19F8, 0x18A0, 0x13FD, 0x13CA, 0x1374, 0x0F9A, 0x0CC9, 0x084D, 0x0562,
    0x0303, 0x019F, 0x028B, 0x0500, 0x0A5D, 0x146E, 0x2023, 0x2899, 0x2D73, 0x3393, 0x39DE, 0x3B1D, 0x3A7C, 0x382C, 0x3448, 0x2E6A,
    0x24B4, 0x1C54, 0x13FF, 0x0C37, 0x0377, 0xF9AF, 0xF169, 0xEA55, 0xE638, 0xE347, 0xDD6B, 0xD6F8, 0xD4F2, 0xD533, 0xD60A, 0xD682,
    0xD50D, 0xD570, 0xD88D, 0xD9C4, 0xD900, 0xD5DE, 0xD1B2, 0xD065, 0xD1A8, 0xD1C7, 0xD181, 0xD031, 0xD025, 0xD0D9, 0xCFB5, 0xCECC,
    0xD0D0, 0xD525, 0xDB64, 0xE531, 0xEF79, 0xF6E2, 0xFD56, 0x04D3, 0x0965, 0x0AA0, 0x0B68, 0x0B61, 0x097E, 0x0581, 0xFF3B, 0xFC57,
    0xF9F4, 0xF83A, 0xF84C, 0xF657, 0xF36B, 0xF31F, 0xF39E, 0xF263, 0xED50, 0xE807, 0xE889, 0xEB4F, 0xED54, 0xEE9F, 0xF281, 0xF77E,
    0xFE45, 0x037B, 0x04E4, 0x01EF, 0xFE60, 0xFD76, 0xFE0F, 0xFEDC, 0xFDBC, 0xFBCE, 0xFB74, 0xFC41, 0xFB99, 0xFA24, 0xF939, 0xFE81,
    0x07EC, 0x1170, 0x1A5A, 0x22CB, 0x2CE6, 0x3320, 0x3578, 0x3867, 0x38E1, 0x383D, 0x349A, 0x2DEA, 0x28DD, 0x210A, 0x1A36, 0x126D,
    0x0A49, 0x028A, 0xFAF7, 0xF86A, 0xF676, 0xF295, 0xEC1B, 0xE6DF, 0xE773, 0xE7E5, 0xE65E, 0xE812, 0xEB24, 0xF154, 0xF986, 0x00D6,
    0x055A, 0x05DF, 0x05B9, 0x094D, 0x0BF0, 0x0A96, 0x0760, 0x0530, 0x030C, 0x00B3, 0xFDE4, 0xFCAF, 0xFF31, 0x026E, 0x0A7F, 0x1094,
    0x1429, 0x1675, 0x18DB, 0x18C4, 0x171A, 0x14FC, 0x1262, 0x0F1B, 0x07B7, 0xFFD8, 0xF8CC, 0xF07A, 0xEB50, 0xE864, 0xE24C, 0xDDE9,
    0xDD36, 0xE07C, 0xE231, 0xE08C, 0xE03A, 0xE4EC, 0xEBBB, 0xF0D2, 0xF381, 0xF791, 0xFD0E, 0x048F, 0x0BD1, 0x0EA4, 0x0F3F, 0x0D1E,
    0x0BFD, 0x0B88, 0x0AA4, 0x0634, 0x01D1, 0x0151, 0xFEEA, 0xFB84, 0xF96B, 0xF857, 0xFA58, 0xFFEE, 0x0615, 0x0B72, 0x1071, 0x1427,
    0x17A5, 0x1819, 0x15E6, 0x1410, 0x10D0, 0x0A0A, 0x02A5, 0xFBF5, 0xF30B, 0xED10, 0xE7A0, 0xE1AE, 0xDB85, 0xD51C, 0xD432, 0xD4B2,
    0xD41C, 0xCFD5, 0xCC7F, 0xCCA2, 0xCD26, 0xCCE1, 0xCBF7, 0xCC87, 0xCFE6, 0xD5E0, 0xDB6C, 0xE034, 0xE1C8, 0xE432, 0xE698, 0xEBCD,
    0xEF0C, 0xEFEB, 0xF268, 0xF24F, 0xF398, 0xF5E4, 0xF71D, 0xF99F, 0xFECB, 0x0723, 0x1411, 0x1CA9, 0x21C3, 0x284E, 0x2D57, 0x2FBB,
    0x3170, 0x31BA, 0x3191, 0x2FD2, 0x2C3F, 0x2856, 0x250F, 0x232A, 0x2355, 0x2279, 0x1FCE, 0x1FBE, 0x22B0, 0x2448, 0x20FF, 0x1ECD,
    0x1D3B, 0x1EC9, 0x1F23, 0x2005, 0x2057, 0x1F93, 0x223F, 0x234D, 0x221B, 0x1BFC, 0x1217, 0x09CF, 0x055A, 0x00BD, 0xFC2E, 0xF8CC,
    0xF5F2, 0xF33F, 0xEF6A, 0xEAC0, 0xE6BC, 0xE4BD, 0xE569, 0xEB9B, 0xF388, 0xFAAD, 0x0381, 0x0C24, 0x1530, 0x1CB1, 0x226F, 0x2652,
    0x272B, 0x2680, 0x2262, 0x1D92, 0x18CD, 0x1575, 0x1221, 0x0CB4, 0x082E, 0x0470, 0x03C9, 0x0072, 0xF9DB, 0xF271, 0xEDA1, 0xEBB3,
    0xEB6E, 0xEA50, 0xEB19, 0xEE74, 0xF2E3, 0xFB7B, 0xFF1C, 0xFE97, 0xFB84, 0xFBAD, 0xFB84, 0xFA81, 0xF959, 0xF6C8, 0xF4CA, 0xF31A,
    0xF32A, 0xF2AC, 0xF066, 0xF055, 0xF56B, 0xFCB7, 0x012A, 0x0417, 0x08A4, 0x0B72, 0x0DBE, 0x0EC8, 0x0F50, 0x0D1A, 0x0AC6, 0x075B,
    0x012E, 0xFA14, 0xF42E, 0xEFF9, 0xEBC8, 0xE442, 0xDE87, 0xDD5F, 0xDAF5, 0xDA35, 0xD659, 0xD413, 0xD429, 0xD575, 0xD7E6, 0xD9B8,
    0xDBA3, 0xDF4A, 0xE76B, 0xF0CA, 0xF4E0, 0xF46F, 0xF4C2, 0xF7A7, 0xFBB3, 0xFAF8, 0xF9D1, 0xFAA2, 0xFB9A, 0xFB7A, 0xF9C9, 0xF9A5,
    0xFADB, 0x00D9, 0x0A70, 0x15DE, 0x21B1, 0x2C54, 0x37C3, 0x3F6D, 0x4477, 0x4882, 0x4852, 0x489B, 0x44C8, 0x3E45, 0x37D5, 0x2E97,
    0x28EA, 0x21FD, 0x1727, 0x0D7D, 0x06C9, 0x04E3, 0x01FC, 0xFB8A, 0xF6A6, 0xF2DB, 0xF2A1, 0xEFE5, 0xED12, 0xECA1, 0xEBF1, 0xF074,
    0xF730, 0xFCA3, 0x0034, 0xFFC0, 0x0266, 0x076C, 0x082B, 0x0AAD, 0x0A99, 0x0C09, 0x0B89, 0x092A, 0x089C, 0x0526, 0x0564, 0x0950,
    0x0C92, 0x1129, 0x148B, 0x179F, 0x197B, 0x176F, 0x1822, 0x16B3, 0x15D7, 0x14A3, 0x10E6, 0x0D88, 0x068B, 0x01F1, 0x001D, 0xFA88,
    0xF66B, 0xF15A, 0xEFE9, 0xF08B, 0xEEE5, 0xED4C, 0xE93C, 0xE9D3, 0xEC8E, 0xEF1B, 0xF067, 0xF129, 0xF3C1, 0xFAB6, 0x005E, 0x03AD,
    0x0477, 0x0368, 0x056F, 0x04D6, 0x0595, 0x056B, 0x03BE, 0x030F, 0x0158, 0xFED2, 0xFBB8, 0xF7EF, 0xF741, 0xFA0D, 0xFE86, 0x0520,
    0x0A11, 0x11C2, 0x1943, 0x1E68, 0x24F0, 0x27EF, 0x2A70, 0x2AA7, 0x28AD, 0x25E7, 0x1F89, 0x1E3D, 0x1B67, 0x15DA, 0x0EAE, 0x0806,
    0x0725, 0x0322, 0xFD0C, 0xF614, 0xF0A4, 0xEE79, 0xEC17, 0xEAA0, 0xEC40, 0xECED, 0xF35D, 0xFB95, 0x02CE, 0x081F, 0x06E1, 0x076F,
    0x0509, 0x02D8, 0x00E3, 0xFCE7, 0xF8F1, 0xF37A, 0xF10F, 0xED5B, 0xE613, 0xE257, 0xE173, 0xE4D0, 0xE863, 0xEC40, 0xF309, 0xF888,
    0xFC7C, 0x019C, 0x062E, 0x093B, 0x0C2E, 0x0BE4, 0x0937, 0x0326, 0xFF07, 0xF9F0, 0xF46B, 0xF046, 0xEAB3, 0xE9EA, 0xEB1B, 0xEBCF,
    0xEC9B, 0xEB49, 0xEAFA, 0xEDB8, 0xEF63, 0xF206, 0xF410, 0xF79F, 0xFF99, 0x0772, 0x0E89, 0x101E, 0x0F21, 0x0FB2, 0x0D6B, 0x0DA0,
    0x0CE5, 0x0AE5, 0x092C, 0x0664, 0x0746, 0x04AB, 0x016B, 0x0135, 0x0618, 0x0F1C, 0x163C, 0x1CD0, 0x255E, 0x2C21, 0x324F, 0x372B,
    0x3899, 0x3BFF, 0x3C4E, 0x3BBF, 0x3749, 0x2F66, 0x2929, 0x2261, 0x1AC9, 0x0F81, 0x046C, 0xFE32, 0xF8F7, 0xF428, 0xEE13, 0xE564,
    0xE111, 0xDE04, 0xDC56, 0xDAA4, 0xD62E, 0xD607, 0xDAA9, 0xDFAF, 0xE28C, 0xE0D9, 0xE1F6, 0xE3F2, 0xE715, 0xEA77, 0xEAF0, 0xEC88,
    0xECFC, 0xEEEE, 0xEF91, 0xEE22, 0xEE2A, 0xF268, 0xFA09, 0x0415, 0x0CD9, 0x158E, 0x1DA0, 0x24C7, 0x2A85, 0x2D36, 0x2FA3, 0x316E,
    0x32CD, 0x2FFD, 0x2A35, 0x2672, 0x23AF, 0x1FB3, 0x19C0, 0x1227, 0x0D40, 0x0AA5, 0x07F5, 0x03D5, 0xFF62, 0xFCA4, 0xFDC7, 0xFF11,
    0xFE5F, 0xFE61, 0xFE05, 0x0124, 0x0597, 0x09CE, 0x09FE, 0x0A1D, 0x0A87, 0x08E1, 0x0923, 0x0703, 0x05B6, 0x0372, 0x0016, 0xFF6F,
    0xFB46, 0xF4A0, 0xF195, 0xF170, 0xF4C8, 0xF809, 0xFD93, 0x06CD, 0x1012, 0x17EE, 0x1ADB, 0x1CFE, 0x1F70, 0x2057, 0x202C, 0x1948,
    0x11B0, 0x0D1C, 0x0629, 0x00AB, 0xF603, 0xEE08, 0xE916, 0xE4F3, 0xE28A, 0xDD87, 0xD9F6, 0xD5C7, 0xD448, 0xD51B, 0xD51D, 0xD2E6,
    0xD3F6, 0xDB0E, 0xE311, 0xE6F8, 0xE8F3, 0xE953, 0xEA26, 0xECDF, 0xED72, 0xED79, 0xEE2F, 0xEE78, 0xEFDD, 0xEF4C, 0xEB21, 0xE818,
    0xE81C, 0xE979, 0xECED, 0xF253, 0xF7CD, 0x007A, 0x0448, 0x098C, 0x0EF0, 0x1240, 0x15C2, 0x163E, 0x1735, 0x129E, 0x0DCD, 0x0931,
    0x0568, 0x020F, 0xFB8C, 0xF6C0, 0xF6F2, 0xF84A, 0xF7E1, 0xF565, 0xF430, 0xF5EF, 0xF8AA, 0xFD5C, 0x0139, 0x06CF, 0x0F23, 0x196D,
    0x23A8, 0x2879, 0x2A7B, 0x2A8E, 0x2832, 0x24E2, 0x2085, 0x1CFD, 0x174E, 0x132F, 0x0F8E, 0x0B5A, 0x0847, 0x051B, 0x065F, 0x083B,
    0x0C90, 0x12CD, 0x1955, 0x1F37, 0x249E, 0x2B4D, 0x3334, 0x3803, 0x3B6D, 0x3D79, 0x3B16, 0x374F, 0x3129, 0x2C8B, 0x2689, 0x1EA6,
    0x153D, 0x0E79, 0x0C4D, 0x0825, 0x01C3, 0xFC33, 0xF662, 0xF3C6, 0xF12B, 0xEC93, 0xE947, 0xE778, 0xE95C, 0xECA3, 0xEF3C, 0xF0A4,
    0xF124, 0xEEB1, 0xED55, 0xED49, 0xED2B, 0xEA58, 0xE949, 0xE96D, 0xE9B6, 0xE8FF, 0xE565, 0xE5D0, 0xE835, 0xEDC9, 0xF568, 0xFD06,
    0x04A1, 0x0B2C, 0x1110, 0x14E0, 0x1527, 0x1606, 0x18AE, 0x191C, 0x15BA, 0x114F, 0x0E0A, 0x0CB3, 0x0947, 0x023A, 0xFAD0, 0xF84F,
    0xF6AF, 0xF32E, 0xEFAD, 0xEA46, 0xE830, 0xE5F6, 0xE48E, 0xE2CA, 0xE025, 0xDE24, 0xDF42, 0xE39B, 0xE463, 0xE49C, 0xE1C5, 0xE157,
    0xE2D0, 0xE445, 0xE395, 0xE1FC, 0xE2B1, 0xE2F3, 0xE27A, 0xDC3C, 0xD820, 0xD72E, 0xD78B, 0xD9A0, 0xDD90, 0xE4C2, 0xEC64, 0xF37B,
    0xFCE9, 0x040B, 0x0A09, 0x117E, 0x177D, 0x1B2F, 0x1A9E, 0x191B, 0x1AC5, 0x18F5, 0x137C, 0x0E01, 0x074E, 0x055A, 0x0160, 0xFE36,
    0xF93F, 0xF3FD, 0xF1EE, 0xF09C, 0xF212, 0xF085, 0xEF80, 0xF5B0, 0xFD76, 0x05C3, 0x0C33, 0x0FEF, 0x15ED, 0x18D9, 0x1D46, 0x2184,
    0x22A5, 0x2534, 0x2765, 0x28A9, 0x2993, 0x25E4, 0x24B5, 0x2425, 0x24B3, 0x27D7, 0x29F5, 0x2C5D, 0x2F03, 0x3236, 0x31BF, 0x3123,
    0x314A, 0x30D3, 0x2F0F, 0x286F, 0x1DAC, 0x1776, 0x101E, 0x05E0, 0xFBFE, 0xF0F4, 0xEA61, 0xE717, 0xE123, 0xDC81, 0xD870, 0xD414,
    0xD42C, 0xD633, 0xD725, 0xD645, 0xD8EE, 0xDEA0, 0xE75C, 0xEF20, 0xF2C9, 0xF84A, 0xFB29, 0xFC27, 0xFCE8, 0xFAC2, 0xF81D, 0xF7A8,
    0xF794, 0xF9B6, 0xF948, 0xF7C2, 0xFB29, 0xFEDC, 0x03C3, 0x07C0, 0x0DB1, 0x13E9, 0x1B0E, 0x2106, 0x2485, 0x2777, 0x2CA0, 0x3060,
    0x2FAA, 0x2B22, 0x25ED, 0x2316, 0x1D52, 0x161F, 0x0BAD, 0x0261, 0xFCA3, 0xF875, 0xF526, 0xEF64, 0xE8F8, 0xE5D6, 0xE268, 0xE0C2,
    0xDBF2, 0xD711, 0xD780, 0xDAF0, 0xE0D1, 0xE59D, 0xE895, 0xEB6A, 0xED9D, 0xEEEB, 0xEF8E, 0xED62, 0xEC7E, 0xEAEB, 0xEAA8, 0xE794,
    0xE334, 0xE112, 0xDDC8, 0xDE38, 0xE106, 0xE4A9, 0xEB4F, 0xEF84, 0xF416, 0xF799, 0xF9C6, 0xFF53, 0x03D8, 0x0730, 0x0980, 0x0933,
    0x0974, 0x08ED, 0x0489, 0x0255, 0xFDEB, 0xFC2D, 0xFBCF, 0xFB28, 0xFC8F, 0xFAD5, 0xF9F2, 0xF873, 0xFB79, 0xFDDC, 0xFBCE, 0xFF00,
    0x035F, 0x08A5, 0x0ED2, 0x1131, 0x1438, 0x1642, 0x12E6, 0x153B, 0x1534, 0x11E7, 0x11B3, 0x100F, 0x0DA5, 0x07E4, 0x044E, 0xFF71,
    0xFC77, 0xFCD3, 0xFE63, 0x056F, 0x0B09, 0x0FF7, 0x199D, 0x1EF5, 0x2325, 0x28FC, 0x2DD7, 0x31D8, 0x3263, 0x30B6, 0x2FEF, 0x2F2D,
    0x2E41, 0x27BC, 0x1FE9, 0x1B1D, 0x148E, 0x0F5F, 0x056E, 0xFB75, 0xF477, 0xF099, 0xEDD7, 0xEA71, 0xE76E, 0xE7A3, 0xE995, 0xED14,
    0xF0A5, 0xF324, 0xF3EC, 0xF27C, 0xF36A, 0xF450, 0xF2B4, 0xF11A, 0xEF9D, 0xF055, 0xF096, 0xEABB, 0xE697, 0xE322, 0xE1D1, 0xE174,
    0xE3FA, 0xE91C, 0xEF6F, 0xF7FB, 0x00FA, 0x06E0, 0x0C9F, 0x1218, 0x1650, 0x1907, 0x158E, 0x132C, 0x1153, 0x106A, 0x0C28, 0x03E0,
    0xFF4B, 0xFA79, 0xF6F5, 0xF32D, 0xECFA, 0xE94C, 0xE44B, 0xE24C, 0xE345, 0xE11A, 0xE12D, 0xE50E, 0xEAE3, 0xF5B6, 0xFE82, 0x0540,
    0x08B2, 0x0AD9, 0x0E09, 0x0CA6, 0x0BAB, 0x09C0, 0x0B28, 0x0E69, 0x0BEC, 0x0CB9, 0x0A71, 0x07FD, 0x0AE2, 0x0BC2, 0x118D, 0x18D7,
    0x201F, 0x2B47, 0x3332, 0x37A5, 0x3E26, 0x4257, 0x457A, 0x42D6, 0x3F5C, 0x3A20, 0x3447, 0x2ADC, 0x1C81, 0x1051, 0x039C, 0xF7DD,
    0xF253, 0xE8BF, 0xE2CA, 0xDC44, 0xDACF, 0xEA8E, 0xE528, 0xDFDF, 0xDC89, 0xD805, 0xD721, 0xD66E, 0xD785, 0xD763, 0xD7D0, 0xD81B,
    0xD6E1, 0xDAC2, 0xDE4E, 0xDBE5, 0xDD6E, 0xDBA2, 0xDA7A, 0xDAC1, 0xDEC7, 0xE298, 0xE74C, 0xEBEA, 0xF051, 0xF643, 0xFCC1, 0x0115,
    0x0470, 0x0828, 0x0E24, 0x1160, 0x19F4, 0x13CF, 0x0739, 0x07FF, 0x0482, 0x0601, 0x02B8, 0x03B4, 0x0469, 0x077C, 0x0A6C, 0x09AC,
    0x0B03, 0x06FB, 0x09F2, 0x0BAE, 0x07F9, 0x0969, 0x0B9B, 0x0D78, 0x0E30, 0x0F0F, 0x1358, 0x169F, 0x1B16, 0x1CFA, 0x1E23, 0x230A,
    0x21E9, 0x1F8B, 0x1CBD, 0x1536, 0x1237, 0x0EE2, 0x0B13, 0x08EA, 0x066A, 0x04C9, 0x0286, 0x0358, 0x02C3, 0x030C, 0x03AF, 0x03ED,
    0x05C8, 0x0648, 0x059A, 0x02C4, 0x02CF, 0x0142, 0x0245, 0x000F, 0x0251, 0x0673, 0x07B4, 0x0B71, 0x0C21, 0x0F79, 0x107C, 0x11BE,
    0x10E2, 0x0F7B, 0x0E8D, 0x0E2E, 0x0E73, 0x0F23, 0x0ED2, 0x105E, 0x1499, 0x16B8, 0x19F1, 0x1CF6, 0x2025, 0x23B1, 0x22CF, 0x2360,
    0x2108, 0x1D62, 0x1896, 0x11D9, 0x0C8F, 0x0512, 0x017F, 0xFE80, 0xFDDE, 0xFC22, 0xFA9F, 0xF86C, 0xF769, 0xF4CA, 0xF182, 0xEEE5,
    0xEB79, 0xEC1A, 0xE97F, 0xE8FD, 0xE7EB, 0xE769, 0xE98D, 0xEA21, 0xED4D, 0xEF37, 0xF143, 0xF267, 0xF2AD, 0xF318, 0xF219, 0xF2DB,
    0xF525, 0xF987, 0xFE38, 0x038E, 0x05A8, 0x07B2, 0x07DF, 0x07B9, 0x06AF, 0x0244, 0x006D, 0xFCD9, 0xFC5A, 0xFD1A, 0xFD6B, 0xFEE9,
    0x0062, 0x0313, 0x02FE, 0x028D, 0x0034, 0xFE36, 0xFC83, 0xFAB9, 0xF9DD, 0xF937, 0xFA38, 0xFAF8, 0xFC88, 0xFB86, 0xFC84, 0xF8B9,
    0xF4BE, 0xF429, 0xF146, 0xF013, 0xF038, 0xF1DF, 0xF367, 0xF4FB, 0xF57B, 0xF6CE, 0xF88B, 0xF86E, 0xF769, 0xF6CF, 0xF473, 0xF249,
    0xF15E, 0xEF70, 0xEF14, 0xEF2A, 0xEEFE, 0xF139, 0xF17E, 0xF11A, 0xF27E, 0xF4CD, 0xF52C, 0xF612, 0xF8F0, 0xFC8C, 0x004B, 0x0425,
    0x0756, 0x0D87, 0x11CE, 0x11FC, 0x1473, 0x14B7, 0x1656, 0x144B, 0x1211, 0x0F52, 0x0E61, 0x0C63, 0x0B24, 0x0C0D, 0x0CB1, 0x0E22,
    0x1101, 0x15A8, 0x1773, 0x1D07, 0x1EA6, 0x2047, 0x2064, 0x21CF, 0x2259, 0x2191, 0x2242, 0x22D2, 0x2316, 0x2130, 0x2029, 0x1F9B,
    0x1FCD, 0x1E7E, 0x1F36, 0x1DED, 0x1CEA, 0x1AA2, 0x1851, 0x174C, 0x16D3, 0x15BA, 0x1342, 0x124A, 0x0E4D, 0x0A1D, 0x089C, 0x0487,
    0xFE5A, 0xFDD9, 0xFD76, 0xFBD2, 0xFD04, 0xFC2F, 0xFD23, 0xFE53, 0xFBA5, 0xF651, 0xF2B9, 0xEEFE, 0xEA96, 0xE6D6, 0xE020, 0xDD2F,
    0xDC65, 0xDBF9, 0xDD64, 0xE10F, 0xE014, 0xE0CE, 0xE370, 0xE1BF, 0xDF8C, 0xDACF, 0xD7D2, 0xD57C, 0xD39E, 0xD612, 0xDA21, 0xDA19,
    0xDAEF, 0xDFFA, 0xE3B6, 0xE3E4, 0xE3DE, 0xE1C2, 0xDB73, 0xD93C, 0xDA09, 0xDC61, 0xDCF3, 0xDBD0, 0xDBBB, 0xD8E1, 0xD770, 0xD506,
    0xD270, 0xCD66, 0xCA04, 0xC735, 0xC3BE, 0xC3A3, 0xC2FA, 0xC412, 0xC4F8, 0xC7D2, 0xC952, 0xCC78, 0xD0D0, 0xD646, 0xDC98, 0xE026,
    0xE458, 0xE578, 0xE928, 0xEBDF, 0xEE4D, 0xF1F6, 0xF642, 0xFD95, 0x02F4, 0x0929, 0x0DBE, 0x123B, 0x12D3, 0x16F4, 0x1B36, 0x1D1C,
    0x2033, 0x217D, 0x2420, 0x224B, 0x2345, 0x25E4, 0x26B4, 0x229F, 0x201D, 0x207E, 0x1AEA, 0x1492, 0x129E, 0x1047, 0x0C45, 0x113B,
    0x144B, 0x158A, 0x16F7, 0x137D, 0x0BDC, 0x06BC, 0x05E7, 0x0236, 0x01A7, 0xFDF5, 0xF92F, 0xF78D, 0xF817, 0xFB95, 0xFE09, 0xFF52,
    0x0160, 0x02AA, 0xFFF0, 0xFE75, 0xFDB9, 0xFB01, 0xFB55, 0xFA8D, 0xF8B0, 0xFAD0, 0xFB1F, 0xFB28, 0xFB9E, 0xF8DD, 0xF33B, 0xEEE5,
    0xED5B, 0xEAE1, 0xEA83, 0xEBDC, 0xEB0B, 0xECF8, 0xEBF5, 0xEC71, 0xEBE3, 0xE8E2, 0xEBE1, 0xED57, 0xECB2, 0xEC50, 0xED39, 0xECF1,
    0xEA02, 0xE4DB, 0xE684, 0xE855, 0xECC6, 0xEFCD, 0xF170, 0xF61D, 0xF8E5, 0x014B, 0x08B2, 0x0BAC, 0x0EA0, 0x156A, 0x195C, 0x165E,
    0x1615, 0x1629, 0x1233, 0x12A9, 0x1029, 0x0C8D, 0x0C6F, 0x0A0D, 0x03D3, 0x000D, 0xFEA3, 0x0130, 0x0376, 0x066B, 0x09A9, 0x0281,
    0xFE2C, 0xFB8E, 0xFA4A, 0xF890, 0xF597, 0xF594, 0xF52E, 0xF539, 0xF95C, 0xFC76, 0xFE9E, 0x018D, 0x0183, 0x02D7, 0x0228, 0x01FE,
    0x0251, 0x0123, 0x01F7, 0x0101, 0x03DF, 0x0697, 0x073C, 0x0A1D, 0x0C48, 0x0B47, 0x09EE, 0x0841, 0x0560, 0x0474, 0x01E4, 0x0299,
    0x0422, 0x0762, 0x0B17, 0x0F68, 0x1159, 0x118C, 0x126C, 0x1377, 0x17B0, 0x15F2, 0x169C, 0x14E7, 0x118B, 0x11BC, 0x1351, 0x14B4,
    0x0F69, 0x0D71, 0x0DD2, 0x0998, 0x04D2, 0x01CE, 0xFA88, 0xF6FE, 0xF5E2, 0xF053, 0xEF98, 0xEEC4, 0xEA24, 0xE18A, 0xDD96, 0xDC82,
    0xDCBA, 0xDEF1, 0xE15D, 0xE094, 0xDCF3, 0xDE20, 0xDE22, 0xE39E, 0xE59E, 0xE888, 0xEBB9, 0xEE39, 0xF4B0, 0xF7A6, 0xFE0D, 0x041B,
    0x0861, 0x0C1B, 0x0FB0, 0x16CB, 0x1E84, 0x20A6, 0x25E2, 0x2AD8, 0x2E62, 0x341F, 0x33C5, 0x36C8, 0x36DC, 0x3349, 0x31EC, 0x2CFA,
    0x2A06, 0x2587, 0x2616, 0x26FB, 0x28AB, 0x2C76, 0x2CEE, 0x3001, 0x3136, 0x2DA2, 0x2719, 0x214D, 0x1B0C, 0x1745, 0x10EA, 0x0C89,
    0x0777, 0x01AE, 0x039B, 0x0506, 0x0396, 0x02EA, 0x068F, 0x06E8, 0x04B4, 0x036C, 0xFF9E, 0xFDFF, 0xFDB0, 0xFE22, 0xFE1B, 0x013B,
    0x03BD, 0x00AF, 0xFC63, 0xF709, 0xF4E4, 0xF186, 0xF302, 0xF035, 0xEB6E, 0xEBE2, 0xE9DB, 0xEC5C, 0xEDFA, 0xF12C, 0xF330, 0xF3AF,
    0xF534, 0xF72F, 0xF56C, 0xF22D, 0xF2D3, 0xF1B7, 0xF11E, 0xED23, 0xEF1A, 0xEF96, 0xF01E, 0xF0D3, 0xEF34, 0xF41C, 0xF3D8, 0xF7B3,
    0xFDA4, 0x03AB, 0x0A16, 0x0F11, 0x142C, 0x16EF, 0x1B14, 0x1C05, 0x1F99, 0x2481, 0x2872, 0x2C04, 0x2DB4, 0x2FA8, 0x2E80, 0x2CBF,
    0x29F4, 0x29D2, 0x280A, 0x28EC, 0x2A60, 0x24A7, 0x1EC1, 0x1A3B, 0x1511, 0x0D1C, 0x084C, 0x03DA, 0x0150, 0x02D7, 0x02C5, 0xFF9F,
    0x006A, 0xFDF0, 0xF990, 0xF881, 0xF4D2, 0xEF76, 0xE708, 0xE149, 0xDEC0, 0xDB3E, 0xDEA1, 0xE245, 0xE223, 0xE19A, 0xDEAD, 0xDE96,
    0xDC86, 0xDE73, 0xE152, 0xE0FC, 0xE43F, 0xE763, 0xEBA3, 0xF145, 0xF3D0, 0xF750, 0xF997, 0xFAD0, 0xFE0E, 0xFDE1, 0xFFC6, 0x00F4,
    0xFDE7, 0xFF43, 0xFE48, 0xFE2F, 0xFF34, 0xFDDC, 0xFF70, 0xFEAD, 0xFD93, 0xFBCB, 0xFE18, 0xFF9E, 0x01B2, 0x0533, 0x0925, 0x0D81,
    0x11DA, 0x141C, 0x11ED, 0x105E, 0x0B6C, 0x0B3E, 0x0B30, 0x0C4E, 0x111C, 0x0F63, 0x0D1A, 0x1008, 0x124C, 0x11BA, 0x1428, 0x1667,
    0x1712, 0x1982, 0x19FA, 0x1706, 0x170C, 0x16F9, 0x1162, 0x1040, 0x0F41, 0x0ED3, 0x0C91, 0x0723, 0x0443, 0x0209, 0x03EA, 0x07C5,
    0x0954, 0x06AD, 0x0059, 0xF8A1, 0xF2BC, 0xEF5F, 0xEEC7, 0xEE13, 0xF166, 0xF6FF, 0xFD26, 0x045A, 0x0B7F, 0x1132, 0x1461, 0x169F,
    0x1784, 0x179E, 0x1716, 0x164C, 0x1514, 0x15CD, 0x1491, 0x13A9, 0x13C6, 0x11AB, 0x116E, 0x0F37, 0x0DA1, 0x0C64, 0x09BF, 0x0978,
    0x0796, 0x085F, 0x08E3, 0x0A12, 0x0CEC, 0x0F62, 0x0E7A, 0x0CFB, 0x0902, 0x0611, 0x02B9, 0xFC11, 0xFD63, 0xF951, 0xF460, 0xF119,
    0xF0EE, 0xF20A, 0xF185, 0xF568, 0xF412, 0xF53D, 0xF7D4, 0xF3F3, 0xF12B, 0xED13, 0xE6E2, 0xE0B2, 0xDB37, 0xD715, 0xD2F4, 0xCC56,
    0xC654, 0xC07C, 0xBD48, 0xBEAD, 0xBF6F, 0xC147, 0xC180, 0xC435, 0xC5FC, 0xC9E6, 0xD26B, 0xD7D2, 0xDDB9, 0xE229, 0xE7CF, 0xED2A,
    0xF13A, 0xF3A7, 0xF632, 0xF852, 0xF86B, 0xFB94, 0xFC62, 0x00B6, 0x02F5, 0x06F3, 0x0B13, 0x0B92, 0x0C95, 0x0AE0, 0x0C79, 0x09C5,
    0x092E, 0x0A5D, 0x0BB7, 0x0CC1, 0x0E10, 0x11EC, 0x1591, 0x18F8, 0x1997, 0x1D5D, 0x1DB7, 0x1E20, 0x1A47, 0x16BF, 0x15CC, 0x10F7,
    0x1653, 0x1931, 0x1A7A, 0x1A5C, 0x1C5B, 0x1F28, 0x2017, 0x23D8, 0x2485, 0x2830, 0x2B1B, 0x2CDC, 0x29CC, 0x2B4D, 0x2A6F, 0x273B,
    0x258D, 0x242C, 0x2612, 0x2414, 0x236E, 0x1E18, 0x18A9, 0x15AD, 0x1587, 0x168D, 0x1286, 0x0E94, 0x08E5, 0x0252, 0xFCBE, 0xF7ED,
    0xF536, 0xF3FC, 0xF111, 0xEEDF, 0xED23, 0xE8F8, 0xE54E, 0xE000, 0xDC41, 0xD5F0, 0xD18E, 0xD013, 0xCDAC, 0xCE33, 0xCC7E, 0xCC6C,
    0xCE89, 0xD073, 0xD2B1, 0xD5EB, 0xDAC0, 0xE129, 0xE46C, 0xE7D5, 0xEBAD, 0xEDCA, 0xF31E, 0xF6FD, 0xFC3C, 0x0092, 0x069D, 0x0E18,
    0x1010, 0x13D9, 0x1519, 0x1545, 0x18B1, 0x1F67, 0x21D9, 0x2108, 0x1FDB, 0x1DB9, 0x1B05, 0x1906, 0x179B, 0x137E, 0x1656, 0x1937,
    0x1BD9, 0x1EA7, 0x215E, 0x2260, 0x2065, 0x1E91, 0x1BB0, 0x1989, 0x13F8, 0x0E54, 0x06A3, 0x0130, 0xFF68, 0x00C2, 0x0419, 0x01DF,
    0xFF4E, 0xF883, 0xF51B, 0xF11F, 0xED1F, 0xEBF5, 0xEA76, 0xEB4C, 0xE8FE, 0xEB27, 0xEBF9, 0xECAD, 0xEB3E, 0xEAFF, 0xEAC3, 0xE9C2,
    0xE72A, 0xE4A2, 0xE614, 0xE110, 0xDF32, 0xDC71, 0xDB80, 0xDAB8, 0xD8DA, 0xDABF, 0xDAE4, 0xDD51, 0xDD5F, 0xDD8F, 0xDD8C, 0xDD92,
    0xDD0B, 0xDBDB, 0xDD45, 0xDF26, 0xE000, 0xDDA0, 0xDFC3, 0xDD24, 0xDCA5, 0xE054, 0xE4FC, 0xE97F, 0xEA90, 0xF050, 0xF447, 0xFCE2,
    0x044A, 0x0C65, 0x14C5, 0x1C0F, 0x2193, 0x225F, 0x25E6, 0x23E6, 0x2077, 0x1BF9, 0x19F3, 0x1910, 0x1A8B, 0x1C3B, 0x19A7, 0x18FD,
    0x170E, 0x1C92, 0x1F86, 0x2122, 0x1FBB, 0x1A67, 0x16C6, 0x119F, 0x1181, 0x0EE2, 0x1175, 0x14B7, 0x166E, 0x186F, 0x18BF, 0x1844,
    0x1589, 0x1253, 0x0C2C, 0x0AC7, 0x06E6, 0x0498, 0x0505, 0x0451, 0x05E4, 0x048B, 0x048D, 0x0140, 0xFFC3, 0xFCDE, 0xFA86, 0xFAAD,
    0xFA6B, 0xF9EC, 0xF8E9, 0xFB4F, 0xFD35, 0x001F, 0x01BC, 0x0903, 0x0E29, 0x112D, 0x15E4, 0x17FF, 0x1786, 0x17E3, 0x1BC0, 0x1D05,
    0x1DC0, 0x1BD3, 0x1858, 0x15F4, 0x15A3, 0x1463, 0x139C, 0x15F9, 0x1614, 0x1428, 0x1122, 0x0EE4, 0x0712, 0xFE76, 0xF7FB, 0xF001,
    0xEC12, 0xE6D5, 0xE33B, 0xDE21, 0xD9A9, 0xD71B, 0xD75C, 0xD92B, 0xD886, 0xD8A9, 0xD6DC, 0xD694, 0xD670, 0xD939, 0xDB89, 0xDF1B,
    0xE112, 0xE30A, 0xE867, 0xE9B4, 0xEE2A, 0xF238, 0xF763, 0xFDFF, 0x049F, 0x0A33, 0x115F, 0x1879, 0x1B9A, 0x21BA, 0x20CA, 0x1E6C,
    0x19BE, 0x16B4, 0x1238, 0x10D1, 0x12D6, 0x10D0, 0x144E, 0x13F6, 0x19DD, 0x1D52, 0x1F13, 0x217E, 0x2337, 0x244C, 0x1F07, 0x1AA4,
    0x1343, 0x0D4B, 0x0944, 0x0534, 0x040D, 0x0400, 0x01C8, 0xFA1C, 0xF1AB, 0xED6D, 0xEC96, 0xE76B, 0xE22C, 0xE016, 0xDE73, 0xE308,
    0xE30F, 0xDF49, 0xD973, 0xD5B0, 0xD4DA, 0xD3ED, 0xD44B, 0xD503, 0xD384, 0xCFD3, 0xCEB6, 0xCFE0, 0xD358, 0xD2D1, 0xD196, 0xCEC0,
    0xCE4C, 0xCE61, 0xCD02, 0xCE3B, 0xCF6E, 0xD2C5, 0xD49B, 0xD90D, 0xDC7C, 0xDE94, 0xE0B0, 0xE360, 0xE76A, 0xE6CF, 0xEADA, 0xEC89,
    0xF03D, 0xF3E9, 0xF846, 0xFC1E, 0xFC0D, 0x024A, 0x082F, 0x139B, 0x1BF3, 0x259B, 0x2CFA, 0x3062, 0x31B9, 0x3537, 0x37EB, 0x37A2,
    0x38D4, 0x3B12, 0x4149, 0x4195, 0x4156, 0x3958, 0x3989, 0x384D, 0x353F, 0x327A, 0x28C0, 0x2302, 0x18CE, 0x13C0, 0x1122, 0x107A,
    0x0B8E, 0x0819, 0x057D, 0x0374, 0x023C, 0xFAA9, 0xF0D9, 0xE68F, 0xDF30, 0xD971, 0xD879, 0xD8DE, 0xD982, 0xD656, 0xD356, 0xD272,
    0xD5A2, 0xD4BA, 0xE279, 0xF0DA, 0xE9B2, 0xE9E1, 0xE585, 0xDEC3, 0xDE25, 0xDC32, 0xDA53, 0xD999, 0xCF1A, 0xC582, 0xCAEF, 0xC40C,
    0xAC7E, 0xB4B4, 0xC05B, 0xBF77, 0xC6F1, 0xCB59, 0xD061, 0xCF4F, 0xD330, 0xD56E, 0xDB89, 0xDEFB, 0xD9A1, 0xE2E1, 0xEDC7, 0xF4C7,
    0xFBFB, 0x0390, 0x0D7E, 0x01C0, 0xF1A9, 0xF44A, 0xF7E4, 0x00DC, 0x0104, 0xFFE0, 0xFCA4, 0xF808, 0xFB32, 0x03FF, 0x0C7E, 0x0B62,
    0x1C4E, 0x37B4, 0x455F, 0x3F5A, 0x3A49, 0x36E5, 0x2CDF, 0x2179, 0x1C13, 0x122D, 0xF65F, 0xE9F1, 0xE3EF, 0xCA9E, 0xBE66, 0xC445,
    0xC7D5, 0xC8C0, 0xCAA7, 0xD147, 0xD01B, 0xD075, 0xD3F1, 0xD6B4, 0xD891, 0xD488, 0xD4F3, 0xD86A, 0xE362, 0xED1A, 0xF34D, 0x07B1,
    0x048C, 0xF8DC, 0xF677, 0xF9EB, 0x0204, 0x0158, 0x083A, 0x089F, 0x0A83, 0x0801, 0x0F94, 0x21AA, 0x2717, 0x2C23, 0x43BE, 0x5A0E,
    0x5938, 0x53FF, 0x5170, 0x5056, 0x4917, 0x4594, 0x466B, 0x3A5B, 0x2EE9, 0x3305, 0x253C, 0x1627, 0x1554, 0x15D8, 0x0F56, 0x0882,
    0x0CD3, 0x0AAE, 0x0420, 0x00BB, 0x0078, 0xFE53, 0xFC55, 0xFCB3, 0xF97C, 0xFEA9, 0x039D, 0xFBB6, 0x0530, 0x0444, 0xF475, 0xE17E,
    0xD42E, 0xD176, 0xCA93, 0xCA3A, 0xC8A3, 0xC926, 0xC35D, 0xC044, 0xC814, 0xCE13, 0xD244, 0xE56B, 0x05CC, 0x1B6F, 0x22D3, 0x226F,
    0x24A6, 0x2237, 0x1EB9, 0x257C, 0x1D98, 0x0D59, 0x0F55, 0x0C67, 0xFBAC, 0xF389, 0xF33F, 0xF56B, 0xF42B, 0xF8DB, 0xFEDC, 0xFE34,
    0xFF5A, 0xFD62, 0x025B, 0x0186, 0x02E0, 0x00B0, 0x05F7, 0x1536, 0x16B1, 0x233B, 0x2C92, 0x2CD2, 0x2311, 0x1A18, 0x1930, 0x1A47,
    0x1F21, 0x23D7, 0x26DA, 0x2041, 0x1CC6, 0x23B7, 0x30C3, 0x31B2, 0x35DE, 0x4927, 0x5A44, 0x61CC, 0x5B6B, 0x5CB7, 0x5653, 0x4867,
    0x4715, 0x3E66, 0x2AE1, 0x1F10, 0x15C9, 0xFF8D, 0xE6AE, 0xD942, 0xD6AB, 0xD0DB, 0xCF53, 0xD091, 0xCE3F, 0xCAAB, 0xC78E, 0xCC30,
    0xCB4D, 0xCCD9, 0xCA3A, 0xC818, 0xD058, 0xCBED, 0xCF52, 0xD78B, 0xDAC0, 0xD2D7, 0xC6F5, 0xC36B, 0xC0B6, 0xC12A, 0xC022, 0xC4DF,
    0xC5E4, 0xC34A, 0xC398, 0xCF45, 0xD5BF, 0xD709, 0xE4D0, 0xFD7D, 0x14F2, 0x1BED, 0x2394, 0x2B76, 0x2C71, 0x2FB7, 0x3945, 0x3023,
    0x2A66, 0x2D6D, 0x2913, 0x1FC0, 0x17A3, 0x1EB6, 0x1DD5, 0x1DAC, 0x2122, 0x25E4, 0x27E4, 0x242C, 0x2742, 0x2433, 0x251B, 0x23DC,
    0x1EB8, 0x2817, 0x2F19, 0x332D, 0x3B79, 0x4616, 0x48E8, 0x42D1, 0x3923, 0x3145, 0x29F1, 0x2222, 0x205D, 0x21D3, 0x1E87, 0x162C,
    0x1B42, 0x2054, 0x1DF1, 0x20A3, 0x2F39, 0x438E, 0x493F, 0x4405, 0x4210, 0x3528, 0x2664, 0x2777, 0x1ECF, 0x11CF, 0x0C05, 0x06ED,
    0xFDA1, 0xEE35, 0xE676, 0xE089, 0xDC93, 0xDB0E, 0xDA67, 0xDBD3, 0xD6AE, 0xD860, 0xD613, 0xD8B4, 0xDDEB, 0xDB89, 0xDF8C, 0xE7D9,
    0xEDF9, 0xF3F6, 0x024F, 0x08A1, 0x08FF, 0x0302, 0xFDE4, 0xFC9D, 0xFED7, 0x02C5, 0x0AE7, 0x0F9D, 0x05CE, 0x0628, 0x0D07, 0x0F76,
    0x0F1B, 0x1824, 0x2C6C, 0x40CB, 0x4719, 0x4F6A, 0x51EF, 0x48D9, 0x4B50, 0x4628, 0x38FE, 0x2BE2, 0x261A, 0x1C9D, 0x06F1, 0xF695,
    0xEAD3, 0xE376, 0xDD60, 0xDEBD, 0xE1DC, 0xDE70, 0xDC1F, 0xDA30, 0xDC94, 0xE1F7, 0xE1AE, 0xDFBB, 0xE457, 0xE2D0, 0xE032, 0xE7D6,
    0xEE51, 0xF0F4, 0xEE16, 0xE602, 0xE0AA, 0xDE15, 0xDBC9, 0xDE7E, 0xE50E, 0xE28F, 0xDE91, 0xE270, 0xEA33, 0xEDA3, 0xF0B9, 0x00B2,
    0x18D4, 0x2804, 0x3014, 0x37AD, 0x301F, 0x2C72, 0x3195, 0x2DB9, 0x2285, 0x1F8B, 0x2088, 0x177C, 0x0D6E, 0x06CA, 0x070B, 0x064E,
    0x041A, 0x05C1, 0x0540, 0x054E, 0x0388, 0x02EE, 0x08B6, 0x093A, 0x0697, 0x072E, 0x0C6E, 0x0C37, 0x0B46, 0x107A, 0x10D5, 0x0BC5,
    0xFFE6, 0xF3B6, 0xE918, 0xDCD8, 0xD4DE, 0xD375, 0xD316, 0xCC45, 0xCC50, 0xD2D2, 0xD22C, 0xCE38, 0xD377, 0xEAD2, 0xFE0E, 0x0CD0,
    0x1B9D, 0x1D02, 0x1519, 0x1588, 0x1720, 0x0DD5, 0x05BF, 0x03E4, 0x01E6, 0xF88C, 0xF0D2, 0xED2B, 0xEBA8, 0xEA7D, 0xEFF1, 0xF3B3,
    0xF6E7, 0xF8EC, 0xF546, 0xF87E, 0xFA78, 0xF9C4, 0xF663, 0xF93B, 0xFB71, 0xFD4C, 0x0A62, 0x181B, 0x23DF, 0x263D, 0x2127, 0x1E9F,
    0x1B34, 0x15D5, 0x19C0, 0x240E, 0x216E, 0x1C88, 0x1FA5, 0x25C8, 0x2586, 0x2453, 0x31F8, 0x413C, 0x4ACB, 0x510B, 0x5305, 0x489C,
    0x41FE, 0x42B3, 0x3954, 0x2D23, 0x2673, 0x229B, 0x1823, 0x083D, 0xF871, 0xE882, 0xD90C, 0xD3C9, 0xCF03, 0xCBEC, 0xC88F, 0xBE95,
    0xBD0B, 0xBE44, 0xBF2D, 0xBE28, 0xC006, 0xC250, 0xBDC7, 0xBDC7, 0xC0B3, 0xC7F3, 0xCB48, 0xC79C, 0xC588, 0xC57E, 0xC364, 0xC3FD,
    0xCB07, 0xCB52, 0xCB65, 0xC82C, 0xCE30, 0xD2C5, 0xCC84, 0xD428, 0xE376, 0xF4CD, 0x06F9, 0x1AAC, 0x1EED, 0x1B83, 0x2424, 0x2B85,
    0x27BE, 0x2282, 0x2216, 0x224F, 0x1D60, 0x157B, 0x1341, 0x1050, 0x13C6, 0x16F8, 0x177B, 0x1B41, 0x1660, 0x140B, 0x142E, 0x153F,
    0x10A1, 0x0A79, 0x0B07, 0x0776, 0x06CB, 0x0A08, 0x10CF, 0x1635, 0x11D0, 0x09BF, 0x0251, 0xF695, 0xEC51, 0xE85B, 0xE516, 0xDF70,
    0xD7F8, 0xDB0E, 0xE2BD, 0xDD61, 0xDB37, 0xE511, 0xF2B7, 0x0380, 0x17B3, 0x2294, 0x1B4E, 0x1465, 0x1359, 0x0BE6, 0x0098, 0xFA2D,
    0xFA29, 0xF6D8, 0xED84, 0xEB3C, 0xE615, 0xE313, 0xE2DE, 0xE2DB, 0xE857, 0xE954, 0xE6A0, 0xE784, 0xEDCA, 0xEF91, 0xF10F, 0xF5B7,
    0xFA39, 0xF76D, 0xF7F0, 0x00B4, 0x0B38, 0x11C6, 0x0AE9, 0x09A0, 0x06F7, 0xFCC9, 0xFA1F, 0xFD13, 0x0424, 0x0100, 0xFC4E, 0x021F,
    0x0052, 0xF749, 0xF770, 0xFD4A, 0x082E, 0x18F3, 0x272B, 0x2722, 0x1F74, 0x24D5, 0x2225, 0x1993, 0x0E44, 0x0611, 0x02FF, 0xF930,
    0xF3DA, 0xE9F4, 0xDF92, 0xD751, 0xD2FC, 0xD619, 0xD9AD, 0xD6D7, 0xCFDC, 0xD0A6, 0xD273, 0xD0CD, 0xD170, 0xD6FF, 0xD9C2, 0xD7D0,
    0xDA55, 0xE2A4, 0xF044, 0xF3A1, 0xF48B, 0xF851, 0xF3A4, 0xF20F, 0xF3E9, 0xFCEB, 0x0070, 0xFC9E, 0x0392, 0x0DD2, 0x0D9D, 0x0CC0,
    0x1340, 0x1B82, 0x29D9, 0x3C58, 0x46FD, 0x4173, 0x3EE9, 0x4002, 0x3E9D, 0x3915, 0x3538, 0x373D, 0x3274, 0x2E29, 0x25F4, 0x1B24,
    0x1196, 0x0A81, 0x04DE, 0x0236, 0xFEA1, 0xF3FE, 0xF00F, 0xEE37, 0xEB6E, 0xE86C, 0xE7D6, 0xE50B, 0xDD5E, 0xDA9B, 0xDBCC, 0xE4B7,
    0xE777, 0xE465, 0xE4C2, 0xDFD1, 0xD880, 0xD1BB, 0xCED3, 0xC986, 0xBD2E, 0xB70E, 0xB9F2, 0xB856, 0xB3DD, 0xB2EC, 0xB67F, 0xBF91,
    0xD0F4, 0xE6F5, 0xEF25, 0xF0CA, 0xF60A, 0xF6A2, 0xF17C, 0xEB8D, 0xEDCD, 0xEE0A, 0xEBD0, 0xECAB, 0xEBB6, 0xE9F5, 0xE66E, 0xE603,
    0xEAD1, 0xF01E, 0xEC87, 0xEC55, 0xEE82, 0xEE98, 0xEEF0, 0xEF62, 0xF644, 0xF84F, 0xF68E, 0xF6D9, 0x026A, 0x1287, 0x1A72, 0x2035,
    0x242D, 0x23D2, 0x1E32, 0x1E2E, 0x255D, 0x2743, 0x2462, 0x2A0E, 0x3109, 0x2DD1, 0x2C90, 0x2DCA, 0x31A1, 0x3DCE, 0x5050, 0x5A8D,
    0x5719, 0x52C7, 0x523B, 0x4D4A, 0x442F, 0x3CAC, 0x359D, 0x2F09, 0x25C0, 0x1B9F, 0x0F41, 0x002D, 0xEF54, 0xE3B6, 0xE104, 0xDC64,
    0xD609, 0xD296, 0xD04F, 0xCDD7, 0xCC79, 0xD0E0, 0xD575, 0xD4F1, 0xD1EF, 0xD313, 0xD9B6, 0xDC13, 0xDD9E, 0xDEF6, 0xDBE8, 0xD548,
    0xD133, 0xD565, 0xD702, 0xD0EB, 0xD1A5, 0xD7A4, 0xD84E, 0xD4AE, 0xD530, 0xD792, 0xDDCD, 0xEEA4, 0x0442, 0x1308, 0x14C6, 0x1A4F,
    0x1D04, 0x1B1D, 0x1AE5, 0x17F0, 0x1746, 0x172F, 0x1603, 0x112B, 0x0B8B, 0x07C3, 0x05BC, 0x0940, 0x0D36, 0x0C5F, 0x0B52, 0x0A98,
    0x09B3, 0x0AB7, 0x0B9A, 0x0FC0, 0x116E, 0x0B94, 0x0A1E, 0x1102, 0x1AFC, 0x20B5, 0x2387, 0x2207, 0x19D8, 0x0E77, 0x092C, 0x09D9,
    0x00B7, 0xF50B, 0xF2C8, 0xF30E, 0xEE78, 0xEBBB, 0xE5CD, 0xDFF6, 0xE5E3, 0xF5CC, 0x059B, 0x073A, 0x094E, 0x08B6, 0x0298, 0xFB9C,
    0xF2C4, 0xF065, 0xECE8, 0xE8C5, 0xE41C, 0xDEC4, 0xD6D0, 0xCCCC, 0xC74F, 0xC698, 0xC585, 0xC18F, 0xC01A, 0xBF1B, 0xC09E, 0xBF55,
    0xC038, 0xC727, 0xC6B8, 0xC52D, 0xC5C1, 0xCDF0, 0xDA15, 0xE35B, 0xEC07, 0xF1AA, 0xEF3E, 0xEC91, 0xF1B9, 0xF255, 0xEDEC, 0xEDBC,
    0xF403, 0xF361, 0xF4CF, 0xF6FE, 0xF41C, 0xFB50, 0x0D46, 0x290F, 0x381E, 0x3DF6, 0x44C6, 0x4852, 0x4A19, 0x4843, 0x4875, 0x462C,
    0x43F3, 0x40AF, 0x3E8F, 0x3913, 0x2E00, 0x2190, 0x19DB, 0x158F, 0x0C68, 0x085E, 0x03D3, 0x00D3, 0xFB84, 0xF7BA, 0xFBCB, 0xFD54,
    0xFA15, 0xF5BB, 0xF777, 0xFB63, 0xFDCF, 0xFF53, 0x0243, 0xFA7D, 0xEE0E, 0xEC0A, 0xED3F, 0xE92E, 0xE19D, 0xE2E2, 0xE3C3, 0xE37F,
    0xE496, 0xE140, 0xE0D6, 0xE62F, 0xF920, 0x0CDD, 0x171C, 0x1F6C, 0x23C2, 0x22AF, 0x206D, 0x2092, 0x20B8, 0x1FE8, 0x1DC7, 0x1D67,
    0x1C62, 0x14B1, 0x0974, 0x0518, 0x093F, 0x09EF, 0x097E, 0x0964, 0x0AF3, 0x0D00, 0x08ED, 0x0CA6, 0x115A, 0x0F3C, 0x0836, 0x028B,
    0x052B, 0x09B3, 0x0A29, 0x0D33, 0x0C1E, 0xFEBB, 0xF34E, 0xEF16, 0xEC55, 0xE08D, 0xD868, 0xD193, 0xCCD4, 0xCCDD, 0xCA20, 0xC693,
    0xC320, 0xCBD6, 0xD9B1, 0xE468, 0xEBC9, 0xF230, 0xF577, 0xF43C, 0xEEE5, 0xE7A1, 0xE518, 0xE082, 0xDC06, 0xD9B2, 0xD783, 0xD19D,
    0xCBF4, 0xCDD2, 0xD0A9, 0xD40E, 0xD659, 0xD9B7, 0xDE1D, 0xDF71, 0xE000, 0xE5D5, 0xEC95, 0xEEAA, 0xEE93, 0xF14E, 0xFA8D, 0x02B0,
    0x0E58, 0x1963, 0x189B, 0x13BA, 0x15C7, 0x1965, 0x15A1, 0x14FE, 0x18AA, 0x1E95, 0x2453, 0x2931, 0x2AAC, 0x25E3, 0x2834, 0x354A,
    0x44BA, 0x4CF2, 0x52D2, 0x53E3, 0x50BB, 0x4E4B, 0x4A2E, 0x4756, 0x41B4, 0x3A1B, 0x31EA, 0x2B4E, 0x1E80, 0x0C9D, 0xFCF0, 0xEE53,
    0xE2E4, 0xDBB2, 0xD74F, 0xD33B, 0xCE83, 0xC960, 0xC8A5, 0xC9CA, 0xCA46, 0xC86F, 0xC93A, 0xCE0B, 0xD08C, 0xD651, 0xDF1B, 0xE3B9,
    0xDDE8, 0xDA54, 0xDD0F, 0xDAAA, 0xD5AB, 0xD398, 0xD404, 0xD498, 0xD7FD, 0xDB05, 0xD991, 0xD84E, 0xE1C2, 0xF2F7, 0x02EB, 0x10DA,
    0x1CB9, 0x226F, 0x22AE, 0x2080, 0x1F14, 0x1FD6, 0x1E44, 0x1E1C, 0x2025, 0x2039, 0x18E9, 0x11A4, 0x0DEE, 0x0D4F, 0x0F01, 0x108B,
    0x1492, 0x16C7, 0x14B8, 0x1389, 0x19B6, 0x1E4D, 0x1E5D, 0x1998, 0x17C1, 0x197F, 0x1A56, 0x2200, 0x2953, 0x2593, 0x18D1, 0x157B,
    0x138A, 0x0C80, 0x04F0, 0xFE8B, 0xF809, 0xF0E1, 0xF0EB, 0xEC71, 0xE2E6, 0xDD54, 0xE36C, 0xEF2A, 0xFA44, 0x041E, 0x0B11, 0x106E,
    0x0FDE, 0x0BDA, 0x0812, 0x0556, 0xFF1F, 0xFC9F, 0xFB48, 0xF316, 0xEAB8, 0xE37B, 0xDEA5, 0xDC4B, 0xDBC6, 0xDC2D, 0xDF60, 0xDF5C,
    0xDF4E, 0xE19A, 0xE5CF, 0xE9ED, 0xE80B, 0xE88B, 0xE86E, 0xE946, 0xED36, 0xFA71, 0x0259, 0xFEE8, 0xFF6C, 0x018B, 0x0156, 0xFA97,
    0xF7F4, 0xF558, 0xF4B6, 0xF962, 0xFD37, 0xF9CC, 0xF3EA, 0xF86F, 0x0240, 0x10A9, 0x1D59, 0x24C9, 0x2866, 0x2612, 0x2077, 0x1B18,
    0x17DA, 0x1212, 0x0B8D, 0x086B, 0x02BE, 0xFC6D, 0xF439, 0xECE8, 0xE854, 0xE29C, 0xDEF8, 0xDFA4, 0xE077, 0xDDE2, 0xDB7F, 0xDA60,
    0xDEF8, 0xE045, 0xDECA, 0xE284, 0xE599, 0xE905, 0xF0E9, 0xFCEB, 0xFD90, 0xFA23, 0xF98E, 0xF9B0, 0xFBD4, 0xFD8F, 0x0131, 0x00F3,
    0x09EC, 0x160A, 0x196D, 0x141C, 0x10EE, 0x189A, 0x21B7, 0x2BAC, 0x3376, 0x3D47, 0x4144, 0x404A, 0x3E54, 0x3DE7, 0x3C78, 0x3816,
    0x3767, 0x3542, 0x30A5, 0x2486, 0x1978, 0x12FA, 0x0D8C, 0x099D, 0x0A5A, 0x0C34, 0x0B61, 0x072F, 0x018C, 0x01BD, 0xFF52, 0xFA5B,
    0xF486, 0xF15C, 0xEBC9, 0xEDEF, 0xFA4E, 0x00ED, 0x0106, 0xFCBF, 0xFB04, 0xF561, 0xF168, 0xEBCA, 0xE3E8, 0xDB31, 0xD808, 0xDAB5,
    0xD322, 0xCDE4, 0xCD99, 0xD397, 0xDA61, 0xE2AB, 0xECFC, 0xF755, 0x009F, 0x0244, 0x06D2, 0x0A12, 0x0B73, 0x0B86, 0x0F77, 0x113D,
    0x0C1E, 0x07D6, 0x0207, 0x00D2, 0xFD4E, 0xFD11, 0xFEDE, 0xFFCE, 0xFF6D, 0xFD02, 0x0098, 0x033D, 0x03E8, 0x03E7, 0x086C, 0x08B7,
    0x061C, 0x0FBA, 0x1C25, 0x1FFD, 0x1C83, 0x1BA1, 0x1C82, 0x1A1E, 0x1909, 0x15EC, 0x127D, 0x1485, 0x1BEA, 0x1FD9, 0x19E6, 0x1584,
    0x155B, 0x1AC7, 0x23DB, 0x2DE9, 0x375B, 0x3D43, 0x3C22, 0x376D, 0x3592, 0x2F6B, 0x29DA, 0x2452, 0x1E45, 0x17B8, 0x0C59, 0x00E1,
    0xF6E7, 0xED26, 0xE1C9, 0xDA0F, 0xD600, 0xD162, 0xCBEB, 0xC5A6, 0xC3D4, 0xC27A, 0xBCAD, 0xBC3D, 0xBD51, 0xBC40, 0xBE24, 0xC6D8,
    0xCE5D, 0xCE54, 0xCE35, 0xCC90, 0xCCA8, 0xCB1D, 0xCA4F, 0xC798, 0xC5F6, 0xCB00, 0xCF93, 0xD072, 0xCCF0, 0xD0BD, 0xD5C7, 0xDFFE,
    0xEB98, 0xF838, 0x076C, 0x0E60, 0x1295, 0x1340, 0x175A, 0x15D2, 0x17B2, 0x1C5B, 0x2185, 0x25F5, 0x236B, 0x2446, 0x201A, 0x2150,
    0x2218, 0x2875, 0x2E6C, 0x302A, 0x3225, 0x33F9, 0x39B5, 0x37D0, 0x3A80, 0x3B77, 0x384D, 0x34C1, 0x37A3, 0x3F6D, 0x41D2, 0x40E3,
    0x3DDD, 0x39EB, 0x34D7, 0x338E, 0x3090, 0x2AB7, 0x2668, 0x26E1, 0x237B, 0x17DE, 0x0CD5, 0x02D4, 0xFDA4, 0xFD7C, 0x00CB, 0x073B,
    0x0D6C, 0x1068, 0x1415, 0x15AF, 0x1373, 0x0EFF, 0x0AB3, 0x09EA, 0x025C, 0xF96E, 0xEF07, 0xE5BA, 0xDECF, 0xD810, 0xD7C8, 0xD897,
    0xD8D8, 0xD553, 0xD552, 0xD79A, 0xD5D5, 0xD344, 0xD4B2, 0xD87A, 0xD623, 0xD8D7, 0xE323, 0xEF64, 0xF4EC, 0xF88A, 0xFCCA, 0xFB63,
    0xFD59, 0xFAFD, 0xF5E8, 0xF15D, 0xF3B0, 0xFB7A, 0xFEA6, 0xFF7F, 0xFF19, 0x0645, 0x0DFC, 0x16F2, 0x22C6, 0x2E4E, 0x370F, 0x3764,
    0x3829, 0x35CD, 0x33F7, 0x311F, 0x30C7, 0x3041, 0x2863, 0x20B8, 0x1599, 0x0EC7, 0x0228, 0xF708, 0xF0CE, 0xEC30, 0xE737, 0xDECD,
    0xDED6, 0xDCD6, 0xD9B5, 0xD6F8, 0xD7D2, 0xD6A9, 0xD429, 0xDAE9, 0xE548, 0xEC2E, 0xED89, 0xEFCF, 0xECAB, 0xE8AA, 0xE7D7, 0xE42E,
    0xDF39, 0xDCE7, 0xE311, 0xE815, 0xE63D, 0xE0E8, 0xDDE7, 0xE260, 0xE8DD, 0xF033, 0xFC59, 0x090E, 0x1470, 0x1B63, 0x1EF7, 0x221B,
    0x2243, 0x2390, 0x24DE, 0x2526, 0x2234, 0x1D19, 0x16AD, 0x1105, 0x0B90, 0x096F, 0x0C7C, 0x0F5E, 0x11AF, 0x1185, 0x1515, 0x138F,
    0x1407, 0x188D, 0x192C, 0x1836, 0x1686, 0x1EEC, 0x2646, 0x2B69, 0x2E08, 0x2DB4, 0x29E5, 0x245B, 0x207F, 0x1715, 0x0FC7, 0x0B2A,
    0x0A27, 0x04E4, 0xFAEC, 0xF17D, 0xEBFE, 0xEC3F, 0xECEF, 0xF32B, 0xF949, 0xFFEF, 0x05D5, 0x06F0, 0x0770, 0x040C, 0xFF7E, 0xFD96,
    0xFC5E, 0xF679, 0xEF10, 0xE8F1, 0xE16E, 0xDC6D, 0xD793, 0xD6EB, 0xDA0E, 0xD906, 0xD823, 0xDC08, 0xDFF8, 0xE22D, 0xE751, 0xEC8D,
    0xEDEB, 0xEF6D, 0xF5A9, 0x00BD, 0x0953, 0x0F07, 0x12ED, 0x12CD, 0x149F, 0x1877, 0x1ADE, 0x18A2, 0x1A6C, 0x2322, 0x2B64, 0x2EC6,
    0x2BCE, 0x2ABD, 0x2CC0, 0x2E10, 0x3255, 0x3B2F, 0x4480, 0x4A9C, 0x4E16, 0x4ED5, 0x4BBB, 0x44F2, 0x4076, 0x3E33, 0x3786, 0x2E97,
    0x22FF, 0x19AE, 0x1019, 0x0511, 0xFC3F, 0xF541, 0xEE82, 0xE329, 0xDD40, 0xD76A, 0xCF53, 0xC8FE, 0xC495, 0xC1E4, 0xBC39, 0xBC20,
    0xC11A, 0xC850, 0xCC7B, 0xD197, 0xD36E, 0xCF21, 0xCD67, 0xCAC3, 0xC774, 0xC1C5, 0xC218, 0xC5AE, 0xC989, 0xC937, 0xC4BD, 0xC668,
    0xC91D, 0xD036, 0xD9E9, 0xE5AA, 0xF1D3, 0xFC5A, 0x06A7, 0x0C8A, 0x110B, 0x120D, 0x1588, 0x1B02, 0x1D76, 0x1E3F, 0x1C32, 0x1ACD,
    0x1504, 0x106E, 0x0F8F, 0x118F, 0x1241, 0x12B2, 0x1909, 0x1DCD, 0x2054, 0x233A, 0x28F1, 0x28CF, 0x26EF, 0x283B, 0x2A0F, 0x2E63,
    0x3012, 0x3047, 0x2C72, 0x2766, 0x241F, 0x1E9B, 0x16E3, 0x103F, 0x11D8, 0x13A6, 0x1081, 0x07E7, 0xFFAE, 0xF9EE, 0xF597, 0xF68F,
    0xF9BA, 0x0158, 0x0842, 0x0EA4, 0x16AE, 0x1BB1, 0x1D01, 0x1AED, 0x1B0D, 0x1BE9, 0x178B, 0x109A, 0x0AB2, 0x04DA, 0xFC73, 0xF4C9,
    0xF157, 0xEDAF, 0xE5BB, 0xE409, 0xE784, 0xE859, 0xE968, 0xE9D6, 0xEA1D, 0xE8A6, 0xE92A, 0xEC13, 0xF11B, 0xF89C, 0xFE1C, 0xFE5E,
    0xF97B, 0xF7AD, 0xF7FE, 0xF3A1, 0xEBE4, 0xE9A6, 0xED4D, 0xF0FB, 0xF055, 0xEF57, 0xF19D, 0xF5A8, 0xFBE7, 0x03E9, 0x106D, 0x1961,
    0x225D, 0x29D2, 0x2B2B, 0x283A, 0x21C3, 0x1F79, 0x1EF1, 0x1EE8, 0x1B38, 0x177A, 0x13F9, 0x0EA0, 0x0AF0, 0x097C, 0x0752, 0x014E,
    0xFC8D, 0xF8B4, 0xF548, 0xF078, 0xEE75, 0xEE6C, 0xE8A6, 0xE356, 0xE358, 0xE7E6, 0xED48, 0xF402, 0xF7F8, 0xF7A2, 0xF76A, 0xF71C,
    0xF774, 0xF41E, 0xF19F, 0xF639, 0xFEFF, 0x04DC, 0x046B, 0x00BE, 0xFBCA, 0xFB5A, 0xFE12, 0x01D9, 0x0A4B, 0x13D0, 0x1EF4, 0x281E,
    0x2CE0, 0x2E01, 0x2CC8, 0x2BC8, 0x2927, 0x24C9, 0x1E65, 0x1A6A, 0x1430, 0x0A5A, 0x03C3, 0x0238, 0xFF98, 0xFBDF, 0xFCAA, 0xFC46,
    0xFAC1, 0xF72D, 0xF6D9, 0xF496, 0xED26, 0xEBD9, 0xECAF, 0xEFA1, 0xF23C, 0xF457, 0xF561, 0xF2EC, 0xEF40, 0xEB72, 0xE5CA, 0xDC44,
    0xD76F, 0xDA46, 0xDDC5, 0xDB5D, 0xD648, 0xD1D1, 0xCF2D, 0xCE8F, 0xCEE6, 0xD3E0, 0xD9FA, 0xDF98, 0xE67C, 0xECBB, 0xF22E, 0xF46C,
    0xF6B6, 0xFB5C, 0x0056, 0xFF8E, 0xFE4B, 0xFE97, 0xF7C0, 0xF206, 0xEFF7, 0xF006, 0xEEFD, 0xEF30, 0xF10A, 0xF3B7, 0xF9CB, 0x0216,
    0x0ACC, 0x0CF2, 0x0E75, 0x12AB, 0x1840, 0x1FB1, 0x27EA, 0x2D9F, 0x2CF7, 0x2D91, 0x2D9D, 0x2E30, 0x2C0E, 0x27E2, 0x29C7, 0x2E8A,
    0x32C3, 0x3174, 0x2E50, 0x28D3, 0x2794, 0x2779, 0x2935, 0x2EA7, 0x337F, 0x3C7A, 0x4221, 0x4562, 0x42B3, 0x3DC4, 0x3998, 0x3720,
    0x32B3, 0x2AE9, 0x2486, 0x1A22, 0x0E89, 0x0472, 0x0094, 0xF8D6, 0xF0E4, 0xEBD8, 0xE4EA, 0xDF8C, 0xD9E9, 0xD908, 0xD581, 0xD05D,
    0xCC78, 0xCB65, 0xCF0F, 0xD5B8, 0xDE6C, 0xE321, 0xE665, 0xE834, 0xE9A5, 0xE61B, 0xDE09, 0xD8B4, 0xD81F, 0xD9E2, 0xDA10, 0xDAA5,
    0xD884, 0xD6A9, 0xD8BA, 0xDEAD, 0xE83F, 0xF0E1, 0xF961, 0x02ED, 0x0B88, 0x0FDC, 0x0FAC, 0x0F3B, 0x118B, 0x1370, 0x1307, 0x13B4,
    0x1382, 0x0F6E, 0x0A07, 0x072C, 0x042A, 0xFF1B, 0xFD2F, 0xFCB3, 0xFDEB, 0x025D, 0x0899, 0x0FA6, 0x11E9, 0x1290, 0x143A, 0x154C,
    0x1786, 0x1C98, 0x1F44, 0x1D59, 0x1B93, 0x1D22, 0x1F30, 0x1B59, 0x149D, 0x14AE, 0x1C1B, 0x1EE2, 0x1CDA, 0x17FB, 0x0DCC, 0x015A,
    0xF84E, 0xF488, 0xF323, 0xF2B0, 0xF359, 0xF868, 0xFEC8, 0x0012, 0xFCEA, 0xFCC8, 0xFE7B, 0xFCD5, 0xF8F7, 0xF4F2, 0xF004, 0xE71C,
    0xE1AE, 0xDEFD, 0xDB1D, 0xD87F, 0xD6D8, 0xD440, 0xCF83, 0xCE48, 0xD083, 0xD0D2, 0xCF68, 0xCEE7, 0xCEDE, 0xD2DF, 0xDB88, 0xE66F,
    0xEF02, 0xF26A, 0xF5C2, 0xFA97, 0xFCE3, 0xFA79, 0xF880, 0xFBD7, 0x032E, 0x091F, 0x0D4E, 0x0E05, 0x0E15, 0x0FFB, 0x147A, 0x1DD0,
    0x252A, 0x2D7A, 0x3719, 0x41EC, 0x4904, 0x49B6, 0x4883, 0x48EE, 0x4B3E, 0x49D9, 0x4A28, 0x46FF, 0x3FEE, 0x3607, 0x2F4D, 0x2948,
    0x1F2B, 0x18BE, 0x0FC8, 0x07A8, 0x004F, 0xFE01, 0xFBAB, 0xF67C, 0xF0B0, 0xE7FC, 0xE395, 0xE264, 0xE5F3, 0xE993, 0xEB39, 0xEADD,
    0xECFA, 0xEE8B, 0xEA92, 0xE5C9, 0xE131, 0xE377, 0xE5EF, 0xE777, 0xE714, 0xE21E, 0xDD94, 0xDA9B, 0xDE94, 0xE47F, 0xEDAC, 0xF8B8,
    0x04CD, 0x1341, 0x1B07, 0x1FC5, 0x23C5, 0x2610, 0x259D, 0x2455, 0x2383, 0x1F7C, 0x1A1E, 0x14E3, 0x1173, 0x0C24, 0x07CD, 0x066D,
    0x03B0, 0x012E, 0x02D0, 0x0975, 0x0C3B, 0x0E13, 0x0E54, 0x0DB4, 0x0F5A, 0x1260, 0x1834, 0x19CD, 0x1785, 0x148A, 0x14A2, 0x10A5,
    0x05BE, 0xFB17, 0xF5A4, 0xF4AD, 0xF3DA, 0xF328, 0xEE71, 0xE6B4, 0xE04F, 0xDD44, 0xDBB0, 0xDBC4, 0xDDF2, 0xE022, 0xE223, 0xE2BC,
    0xE104, 0xDF7B, 0xDF80, 0xDE6E, 0xDF54, 0xE1D9, 0xE308, 0xDDFC, 0xD765, 0xD46F, 0xCEC6, 0xC8F1, 0xC6FD, 0xC68D, 0xC3E4, 0xC439,
    0xC9CC, 0xD2D5, 0xD9D9, 0xDD44, 0xE03C, 0xE22B, 0xE6E6, 0xEC26, 0xF4DE, 0xFAED, 0xFEB1, 0x0595, 0x0B22, 0x0F59, 0x1001, 0x125A,
    0x187A, 0x20ED, 0x274C, 0x2A80, 0x2AD1, 0x26C8, 0x254D, 0x2834, 0x2D3B, 0x33AD, 0x3C03, 0x4602, 0x505D, 0x5730, 0x57FD, 0x585A,
    0x56AE, 0x525D, 0x5177, 0x5154, 0x4D75, 0x4496, 0x3E04, 0x36D3, 0x2DFF, 0x255F, 0x1BBE, 0x1350, 0x0597, 0xFC01, 0xF57E, 0xEF09,
    0xE965, 0xE135, 0xDA39, 0xD37A, 0xD33C, 0xD65C, 0xD998, 0xDA15, 0xD9E3, 0xDCC5, 0xDCA2, 0xD744, 0xCFA3, 0xCC40, 0xCB21, 0xCBBB,
    0xCCBC, 0xCD67, 0xCAF4, 0xC695, 0xC676, 0xC8DF, 0xCE99, 0xD3DC, 0xDB9A, 0xE779, 0xF265, 0xF958, 0xFE43, 0x0625, 0x0C11, 0x1122,
    0x15F9, 0x17AC, 0x17D9, 0x144D, 0x1178, 0x0F08, 0x0B32, 0x0A56, 0x0979, 0x08D3, 0x098A, 0x0ED4, 0x15D4, 0x1C3D, 0x21C6, 0x20B7,
    0x1EEB, 0x1E6E, 0x22C2, 0x27BC, 0x289A, 0x2731, 0x27D4, 0x2AE5, 0x28FA, 0x2318, 0x1B28, 0x176C, 0x15F0, 0x1782, 0x17DC, 0x1248,
    0x0957, 0xFE34, 0xF7D7, 0xF1EF, 0xEF42, 0xEE6A, 0xF085, 0xF6D9, 0xF8FC, 0xF9F5, 0xF9D1, 0xFAC5, 0xF99F, 0xF9DD, 0xFBB4, 0xF7AA,
    0xF1E1, 0xEB20, 0xE3B6, 0xD9D8, 0xD2AB, 0xD00E, 0xCC98, 0xC95E, 0xC75F, 0xC995, 0xCD8E, 0xD1EA, 0xD64A, 0xD7D6, 0xD781, 0xDAFC,
    0xE43A, 0xEC94, 0xF189, 0xF390, 0xF897, 0xFBE4, 0xF854, 0xF2CA, 0xEE28, 0xEE12, 0xEFDE, 0xF473, 0xF713, 0xF4DF, 0xF207, 0xF099,
    0xF4B8, 0xFA9B, 0x00D4, 0x0838, 0x1217, 0x1B5E, 0x20B2, 0x2311, 0x2456, 0x2462, 0x237F, 0x25EB, 0x26B6, 0x23F4, 0x1ECE, 0x190F,
    0x11BC, 0x095B, 0x03E2, 0xFFF9, 0xF95E, 0xF3AE, 0xF2C6, 0xF3C5, 0xF4ED, 0xF5DB, 0xF6A1, 0xF0A2, 0xEB33, 0xEA05, 0xEE2F, 0xF122,
    0xEFCE, 0xF596, 0xFDDE, 0x049C, 0x032C, 0x01A0, 0x02B9, 0x0555, 0x0989, 0x0B8E, 0x0E84, 0x0AEA, 0x05B0, 0x0119, 0x0273, 0x0554,
    0x0984, 0x12E7, 0x1B85, 0x23BF, 0x25AD, 0x285E, 0x288D, 0x26E5, 0x2705, 0x27F2, 0x2706, 0x2215, 0x1F23, 0x18FA, 0x128D, 0x0B24,
    0x063F, 0x003E, 0xF753, 0xF1A4, 0xEDC0, 0xF08D, 0xF2F1, 0xF609, 0xF5FF, 0xF2B3, 0xF3FC, 0xF852, 0xFF30, 0x0165, 0x019F, 0x03B1,
    0x062C, 0x060F, 0x00E3, 0xFB00, 0xF785, 0xF696, 0xF8D5, 0xFA67, 0xF7B0, 0xF1E9, 0xE9E9, 0xE4A3, 0xE1D9, 0xDF7A, 0xE0F8, 0xE449,
    0xE7B1, 0xE9D4, 0xEC1F, 0xEECE, 0xEEE2, 0xF10E, 0xF774, 0xFE27, 0xFF97, 0xFD66, 0xFB16, 0xF5AC, 0xEDC3, 0xE7AA, 0xE29C, 0xDE7E,
    0xDB1B, 0xDA35, 0xDCC4, 0xE1E6, 0xE8F4, 0xECFA, 0xEDFF, 0xEBD2, 0xEEBD, 0xF479, 0xF9CC, 0xFEC4, 0x0406, 0x0DE0, 0x1189, 0x1210,
    0x0FDD, 0x0C93, 0x0C44, 0x0DEF, 0x128C, 0x1404, 0x122F, 0x0BE9, 0x085B, 0x0809, 0x0927, 0x0DF1, 0x1585, 0x1E9A, 0x24D1, 0x2BB4,
    0x3031, 0x33C6, 0x3287, 0x31F4, 0x344F, 0x3276, 0x2F1B, 0x28D2, 0x2176, 0x14C2, 0x0BFC, 0x0499, 0xFBE4, 0xF4BB, 0xECA3, 0xE93B,
    0xE4B8, 0xE3C6, 0xE545, 0xE24D, 0xDA83, 0xD50B, 0xD611, 0xD80A, 0xD7FC, 0xD874, 0xDBF2, 0xDFA4, 0xE157, 0xDD49, 0xD86D, 0xD485,
    0xD267, 0xD361, 0xD64A, 0xD900, 0xD7B3, 0xD66E, 0xD733, 0xD987, 0xDCDA, 0xE36E, 0xEEB6, 0xF9C4, 0x00CB, 0x081A, 0x0E8B, 0x1133,
    0x150C, 0x1C53, 0x22DE, 0x233E, 0x2249, 0x1EEE, 0x1AAF, 0x14F7, 0x0E56, 0x0C26, 0x08B5, 0x06C0, 0x04AB, 0x0716, 0x0CB9, 0x152A,
    0x1DBD, 0x1D2A, 0x1AF9, 0x19E9, 0x1DF0, 0x2091, 0x2004, 0x2152, 0x24B8, 0x2983, 0x29FE, 0x280E, 0x2465, 0x20B1, 0x1FCD, 0x222A,
    0x23DB, 0x2080, 0x199F, 0x128B, 0x0E09, 0x0720, 0x0257, 0x0398, 0x0794, 0x0AE1, 0x0BFF, 0x0E62, 0x0D6B, 0x0CA9, 0x0C86, 0x0F76,
    0x12DE, 0x132C, 0x1388, 0x0F30, 0x0867, 0xFE59, 0xF543, 0xECAD, 0xE33B, 0xDACF, 0xD224, 0xCE72, 0xCEBB, 0xD278, 0xD512, 0xD3FD,
    0xD36D, 0xD72E, 0xDD6E, 0xDFD0, 0xE304, 0xE90E, 0xEFE5, 0xF279, 0xF0E1, 0xEC34, 0xE6E6, 0xE6F5, 0xE901, 0xEE12, 0xF257, 0xF1CB,
    0xEEE1, 0xEBE9, 0xEA8F, 0xEA4A, 0xEE7A, 0xF81E, 0x0387, 0x0EB6, 0x1859, 0x1FEF, 0x25B3, 0x2945, 0x2DA1, 0x2EEB, 0x2FCF, 0x2EFC,
    0x2B44, 0x24A8, 0x19D0, 0x1257, 0x0A08, 0x02B7, 0xFA3A, 0xF3BC, 0xEEE1, 0xE968, 0xEA6D, 0xE9F6, 0xE5CE, 0xDDB9, 0xD786, 0xD58D,
    0xD55B, 0xD526, 0xD5FE, 0xDB33, 0xE254, 0xE73B, 0xE74A, 0xE469, 0xE055, 0xDF43, 0xDF1F, 0xE07B, 0xE06A, 0xDD21, 0xDB8D, 0xD8DB,
    0xD7B7, 0xD838, 0xDEB3, 0xE8A9, 0xF267, 0xFF6C, 0x0997, 0x10B2, 0x156B, 0x1D4C, 0x26A0, 0x2C22, 0x3054, 0x3149, 0x30AC, 0x2BE7,
    0x2517, 0x20D3, 0x1BC4, 0x1695, 0x122E, 0x0E02, 0x0B3B, 0x0D43, 0x14BD, 0x1BCA, 0x1DCE, 0x1DC0, 0x2116, 0x27E9, 0x2BBE, 0x2EDF,
    0x338F, 0x3684, 0x3934, 0x3762, 0x3222, 0x2ACD, 0x2278, 0x1CD2, 0x1A62, 0x1A82, 0x1593, 0x0E26, 0x06F5, 0xFDDA, 0xF4A2, 0xED15,
    0xEB27, 0xEA58, 0xE9F9, 0xEA74, 0xE961, 0xE725, 0xE4A5, 0xE5CD, 0xE7CE, 0xE832, 0xE86E, 0xE632, 0xE0CF, 0xDA4F, 0xD306, 0xCCBB,
    0xC62D, 0xC315, 0xC228, 0xC192, 0xC482, 0xC9E3, 0xD304, 0xD908, 0xDB18, 0xDE3E, 0xE36E, 0xE910, 0xECB5, 0xF3F6, 0xFE6A, 0x0A80,
    0x1490, 0x1895, 0x1A24, 0x17E3, 0x1686, 0x186E, 0x1DAF, 0x22D8, 0x2269, 0x21F3, 0x213D, 0x1F01, 0x1EBD, 0x2078, 0x26FC, 0x2D7D,
    0x3352, 0x39C9, 0x3C03, 0x3E24, 0x3EC2, 0x40F9, 0x43D0, 0x433A, 0x42DC, 0x3E2F, 0x370D, 0x2C30, 0x1ECE, 0x136E, 0x0699, 0xFB3A,
    0xEF47, 0xE410, 0xDDE5, 0xDA47, 0xD964, 0xD499, 0xCE7C, 0xCB47, 0xC7F3, 0xC690, 0xC427, 0xC3A1, 0xC493, 0xC627, 0xC8A4, 0xC627,
    0xC364, 0xBF9A, 0xBE52, 0xC16B, 0xC21E, 0xC1EB, 0xBFF0, 0xBE3E, 0xBB28, 0xB6E6, 0xB672, 0xB8C3, 0xBFC9, 0xC867, 0xD2BB, 0xDDAD,
    0xE464, 0xEBF2, 0xF49E, 0xFD6F, 0x0648, 0x0CC3, 0x10D3, 0x10EB, 0x0FC1, 0x0EB7, 0x0CFB, 0x0E1B, 0x0E5C, 0x0ED3, 0x0E51, 0x0BCA,
    0x0FFB, 0x15ED, 0x1ACA, 0x1CDB, 0x1FC4, 0x254B, 0x2875, 0x2E8C, 0x338B, 0x3AB8, 0x42C5, 0x4741, 0x49D8, 0x46F9, 0x41E3, 0x3ABA,
    0x368D, 0x35AA, 0x3351, 0x30DC, 0x2CAA, 0x27F4, 0x2151, 0x174B, 0x1216, 0x10C4, 0x103B, 0x1340, 0x14E0, 0x1434, 0x122D, 0x11A6,
    0x10C3, 0x0F6E, 0x1153, 0x11B6, 0x0F5C, 0x0864, 0xFF5C, 0xF560, 0xEA84, 0xE024, 0xD7C4, 0xD0DF, 0xC9C9, 0xC7E0, 0xCA0A, 0xCD93,
    0xCF88, 0xD09C, 0xD374, 0xD86A, 0xDC75, 0xDEC3, 0xE2A5, 0xE8D3, 0xF00F, 0xF52F, 0xF7D1, 0xF4D0, 0xF03A, 0xEE32, 0xF054, 0xF5F2,
    0xF794, 0xFA5D, 0xFC93, 0xFC6B, 0xF80A, 0xF56E, 0xFA22, 0xFF87, 0x0A39, 0x144D, 0x1DEA, 0x2348, 0x27D3, 0x2BF7, 0x2E5D, 0x2F8B,
    0x2DE6, 0x2D7B, 0x2818, 0x20F5, 0x179D, 0x0E7F, 0x0773, 0x001E, 0xFA13, 0xF3F0, 0xE844, 0xF36A, 0xF441, 0xF044, 0xE9C2, 0xE63E,
    0xEEFA, 0xD626, 0xDC00, 0xD418, 0xD90C, 0xD7F2, 0xD5F7, 0xE92E, 0xE4B6, 0xE41E, 0xE305, 0xE072, 0xE382, 0xF2F7, 0xDE7A, 0xECEA,
    0xE9C2, 0xE93A, 0xED26, 0xD965, 0xEBAD, 0xF457, 0xF707, 0x078D, 0x13F3, 0xFFE7, 0x0AE5, 0x154E, 0x10A1, 0x3704, 0x1C63, 0x199F,
    0x39ED, 0x0F04, 0x2A16, 0x1137, 0x019F, 0x16A3, 0xEC8B, 0x04C6, 0xE8D8, 0xE444, 0x04C1, 0xEAC0, 0xF0BC, 0x0816, 0x08DC, 0xFF58,
    0xF916, 0x0730, 0x21E4, 0xF82F, 0x082E, 0x1692, 0x17DC, 0x16F2, 0xE949, 0x0B95, 0x023B, 0xFB04, 0xF52E, 0x18D6, 0x1222, 0xDD78,
    0xEC1F, 0xF400, 0xFBDC, 0xE7E3, 0x09B6, 0x34C0, 0x496E, 0x1D58, 0xF024, 0xD731, 0xBE81, 0xB9EC, 0xE323, 0xE2F5, 0xB420, 0xBD25,
    0xDC29, 0x2219, 0x0AE2, 0x186F, 0xD676, 0x8727, 0x88BF, 0x8109, 0x9334, 0x986B, 0xC56F, 0xF96A, 0x4777, 0x648A, 0x7B0E, 0x6C01,
    0x4AD8, 0x251D, 0x1D2F, 0x441C, 0x5880, 0x608F, 0x30B0, 0x3957, 0x5910, 0x68BD, 0x7BA1, 0x7D39, 0x7FFF, 0x6C05, 0x712D, 0x7FFF,
    0x7752, 0x713D, 0x6889, 0x62C3, 0x1764, 0x021C, 0xF9D5, 0xD218, 0xCDEA, 0xBAE6, 0xC463, 0xBCF3, 0xBC1D, 0xBD57, 0xC674, 0xCEFA,
    0xE278, 0xD5C5, 0xCB2D, 0xD8AB, 0xE474, 0x003C, 0xE752, 0x0EAC, 0xF264, 0xD531, 0xE1C3, 0xF199, 0x2E33, 0x347B, 0x1FE7, 0x0C82,
    0xFD71, 0xC916, 0xABC5, 0x8BEC, 0x8891, 0x8D19, 0x9112, 0x923B, 0xAD31, 0xD66A, 0xD501, 0xD25E, 0xBF84, 0xCA5B, 0xC23A, 0xE35D,
    0xFDC9, 0xE810, 0xF86A, 0xFF54, 0xFBCC, 0xF653, 0xE772, 0xE015, 0xEC84, 0x062F, 0x0612, 0x0F73, 0x17F4, 0x249E, 0x1AEC, 0x32CA,
    0x370C, 0x21C8, 0x2123, 0xE7F3, 0xF044, 0xD074, 0xC9EB, 0xD21C, 0xE541, 0xE307, 0xD0A9, 0x1CFE, 0x36D1, 0x4957, 0x4D07, 0x5D71,
    0x4C2E, 0x5469, 0x6F18, 0x388F, 0x4E51, 0x4B9D, 0x2F70, 0x31E9, 0x5118, 0x28C5, 0x11DF, 0x10B2, 0xFDE7, 0x1BA5, 0xE815, 0xCA79,
    0xC65D, 0xDA5B, 0xD7A2, 0x0037, 0x0AB3, 0x14FF, 0x3BA7, 0x2623, 0x13F5, 0x16C4, 0x10C0, 0xF06B, 0xE7BA, 0x0CB6, 0x14BF, 0x0E1D,
    0xFADF, 0x18CE, 0x20F7, 0xD841, 0xFCC7, 0xE7D1, 0xD100, 0xD586, 0xFFDF, 0x068F, 0x04A7, 0x0116, 0xEB5E, 0xD757, 0x0D91, 0x1A54,
    0x2ADA, 0x24F2, 0xEB77, 0x1102, 0xEA5B, 0x0630, 0xE08F, 0xC967, 0xB9C9, 0xC57B, 0xE3C8, 0xF03D, 0xF41B, 0x08CB, 0x0ED8, 0x028D,
    0xFE37, 0xE0C5, 0x001C, 0x1F14, 0x0333, 0x0E9C, 0x4644, 0x2179, 0x30B1, 0x1EE9, 0x0737, 0x04C5, 0xDFB5, 0xB5B0, 0xB40E, 0xCEC3,
    0xE222, 0xDCB8, 0xFFDB, 0xF1AF, 0xFF55, 0x0C3C, 0xE811, 0x0897, 0xF59D, 0xF72D, 0xF39D, 0xE11D, 0xEB03, 0xFF8A, 0xF105, 0xF2EA,
    0xE6CF, 0xD6C4, 0xD391, 0xCA61, 0xB193, 0xC44E, 0xC623, 0xB5AC, 0xD08A, 0xFC6E, 0xF9F8, 0xF25F, 0x0AF9, 0xF7A6, 0xDBEB, 0xE55C,
    0xF622, 0xCAF8, 0xC726, 0xD144, 0xEA7A, 0x0608, 0xE990, 0xFD73, 0x3002, 0x177E, 0x2B98, 0x2331, 0x0863, 0xF075, 0xDD3E, 0xDADD,
    0xFBC7, 0x050F, 0xFE5A, 0x1BE4, 0x19BB, 0x1FE8, 0x0669, 0x2BF5, 0x246E, 0x1AE4, 0x194E, 0xF861, 0x0F7C, 0x2847, 0x142D, 0x0F4A,
    0x1A73, 0x179A, 0x138E, 0xEDA9, 0xE3CF, 0x0421, 0x0D0C, 0x3244, 0x2BA4, 0x41C4, 0x5AA0, 0x3907, 0x521F, 0x34E1, 0x2ADF, 0x2F05,
    0x29AB, 0x1722, 0xEB80, 0xEBB4, 0xFF35, 0xE2E8, 0xD589, 0xC3B6, 0xD013, 0xE925, 0xD56A, 0xE059, 0xCEAC, 0xAB58, 0xCB2A, 0xCDC2,
    0xBE81, 0xFC70, 0xFB8D, 0xF4ED, 0x2E42, 0x3581, 0x2E04, 0x3E1A, 0x31DD, 0x32CE, 0x3AE2, 0x4D29, 0x633F, 0x5F60, 0x3A73, 0x3E1E,
    0x4E5D, 0x4405, 0x3972, 0x09C0, 0x27BE, 0x322E, 0x0465, 0x12DA, 0xF773, 0x0BA3, 0xFA23, 0xF0A2, 0x23AF, 0x2266, 0x3330, 0x3320,
    0x3273, 0x1C01, 0x2847, 0x0FAC, 0x14A8, 0xEFB9, 0xFACE, 0x203E, 0xEAEB, 0x1073, 0x13AB, 0xF410, 0xCBD8, 0xE101, 0xE16D, 0xDAC9,
    0xDFB3, 0xD2CC, 0xB7CE, 0xB50C, 0xD952, 0xBC97, 0xA470, 0xB7E4, 0xCC36, 0xB101, 0xAFDC, 0xA772, 0xABF1, 0xAE05, 0xAE2E, 0xC69C,
    0xD1CD, 0xE273, 0xDC19, 0xF442, 0xF7F5, 0xFDF9, 0x19F4, 0x10E9, 0x0FAA, 0x256E, 0x117B, 0x100D, 0x1D0C, 0x136A, 0x1318, 0xFEDB,
    0xEE8C, 0x0DB0, 0x1239, 0x0B59, 0x1625, 0xFC9D, 0x11D2, 0x0459, 0x08A5, 0x0B42, 0x120C, 0x17E7, 0xFCD1, 0x0B24, 0x064F, 0x1823,
    0x22F4, 0x2DC1, 0x4134, 0x2FC8, 0x2673, 0x3A73, 0x41AB, 0x4612, 0x34AB, 0x2657, 0x03D7, 0x0FEE, 0x019B, 0xE916, 0xFED5, 0xE812,
    0xF860, 0xED0A, 0x0904, 0x09A0, 0xE95C, 0xE660, 0xD32A, 0xBA78, 0xD1AF, 0xDA62, 0xC98A, 0xD9A7, 0xC338, 0xD353, 0xCC63, 0xF06D,
    0xFD58, 0xE2D9, 0xEEBE, 0xEE6C, 0xFFB6, 0x11F8, 0x128C, 0x151E, 0x0374, 0xE716, 0x0601, 0xF610, 0xE04D, 0xCEB7, 0xCEFE, 0xCADE,
    0xD82E, 0xDD02, 0xC427, 0xC6F8, 0xCD71, 0xD8D6, 0xD6BE, 0xE0BE, 0xD5DE, 0xC2AD, 0xC4DA, 0xD798, 0xCF7B, 0xD1D1, 0xD8B3, 0xE1A1,
    0xEEA3, 0x15D1, 0x20CF, 0x3A7A, 0x4041, 0x2C48, 0x47E2, 0x27D1, 0x31A7, 0x4DE5, 0x3758, 0x4574, 0x452A, 0x3F78, 0x452A, 0x4383,
    0x4F67, 0x279F, 0x3407, 0x4947, 0x414B, 0x1C87, 0x1877, 0x001C, 0xFF26, 0x0490, 0x0673, 0x0D2B, 0xE6B0, 0xFE5A, 0x25ED, 0x15FF,
    0xF078, 0x1DC7, 0xFB7E, 0xF7BA, 0xF652, 0x1259, 0xF576, 0xE39F, 0x0576, 0xD87C, 0xDCB6, 0xF197, 0xF47C, 0xF907, 0x1193, 0x0510,
    0x1191, 0x20A3, 0x32A8, 0x01D1, 0x064B, 0x1B0B, 0x0C04, 0x0776, 0x1A16, 0xFAC6, 0xC8FB, 0xD795, 0xDBED, 0xEFEE, 0xFB06, 0x11BD,
    0x2852, 0x279C, 0x0C68, 0x2ACA, 0x1985, 0x3579, 0x28CC, 0x192F, 0x2FA1, 0x0EE2, 0x1C77, 0x1875, 0x0D58, 0xFBD8, 0x0501, 0x0159,
    0x14C8, 0xF6A6, 0xDCCF, 0xCF4D, 0xC12F, 0xC75C, 0xC57E, 0xE214, 0xE64B, 0xDB64, 0xE8BC, 0xF045, 0x08D0, 0x1008, 0xF042, 0xEBA3,
    0xF2FA, 0xFDF9, 0xEF23, 0xE38F, 0xE6B4, 0x11BA, 0xEE3E, 0xD2F4, 0xCDEA, 0xC20E, 0xC7BB, 0xA527, 0xD528, 0xD480, 0xB1BD, 0xBB37,
    0xC12F, 0xBA59, 0xB289, 0xCEEA, 0xDFCA, 0xE8FD, 0xF977, 0xFD4A, 0x080B, 0x1359, 0x202E, 0x362F, 0x415D, 0x3B7F, 0x3798, 0x0A88,
    0xF3EA, 0x1C87, 0x0A87, 0x2056, 0x2D7C, 0x15F1, 0x0134, 0xEB98, 0x05D0, 0x02D9, 0xF801, 0x064C, 0x1514, 0x22BC, 0x4227, 0x288E,
    0x2B00, 0x2E34, 0x0D0D, 0x1758, 0x1462, 0x04F0, 0x03F9, 0x0DEC, 0xE83C, 0xE4DC, 0x0A03, 0xFE85, 0xF1CB, 0x02C3, 0xFF4A, 0x17C1,
    0x18EE, 0x09A6, 0x0D4B, 0xDE6F, 0xCCE8, 0xE307, 0xE1E9, 0xE634, 0xFA22, 0xEBD6, 0xE795, 0xD4B4, 0xD3A8, 0xD3FA, 0xDD1F, 0xE18B,
    0xC0E8, 0xC0A4, 0xB990, 0xC8DD, 0xCB71, 0xCDC8, 0xC991, 0xD78E, 0xEEA0, 0xE5B7, 0xFA6A, 0xED8F, 0x1689, 0x313D, 0x01C4, 0xF0AD,
    0xE347, 0xF093, 0xF179, 0xEAE5, 0xDAC3, 0xE0F6, 0xDFBD, 0xC451, 0xCDBA, 0xDBB7, 0xFC65, 0xFCEC, 0xDE20, 0xE58B, 0xFA2F, 0xFE7A,
    0xFB22, 0xF2DB, 0xF1CF, 0x02E9, 0xFEFD, 0x0707, 0x16C7, 0x17A3, 0x1708, 0x2FBA, 0x3E12, 0x339E, 0x3479, 0x2C06, 0x32BC, 0x1D1F,
    0x1D03, 0x1339, 0x1A0F, 0x307E, 0x1CAC, 0x0CD8, 0x28EA, 0x4A4A, 0x3355, 0x327C, 0x2E2C, 0x2881, 0x36E9, 0x3901, 0x32B8, 0x1AD8,
    0xF988, 0x00F7, 0x078E, 0x18FF, 0xFF34, 0xEB9F, 0x0820, 0x005B, 0x0150, 0xF894, 0xEF54, 0xEF51, 0xDF05, 0xE2C4, 0xF616, 0xF128,
    0xE946, 0xECE9, 0x0517, 0xF2D6, 0xD84B, 0xD46E, 0xDA33, 0xD5D9, 0xD50B, 0xD12B, 0xBF75, 0xD0B1, 0xCF11, 0xDA28, 0xDD5E, 0xD2E7,
    0xD096, 0xDEEF, 0xE4E1, 0xC3CA, 0xED1A, 0x0803, 0xFB94, 0x15A6, 0x133B, 0x1505, 0x1C5E, 0x230C, 0x1528, 0x155C, 0x2068, 0x090A,
    0xFEE8, 0x0363, 0xF9A4, 0xD7DF, 0xD2FB, 0xE960, 0xE9F6, 0xF8C1, 0xE54F, 0xE01C, 0xDEF4, 0xE5B6, 0x0B72, 0xE74B, 0xD1DD, 0xCEF4,
    0xDE97, 0xEE62, 0xFA57, 0xE92B, 0xF85F, 0xE85A, 0xE49F, 0xFDB6, 0xECA8, 0xEFEA, 0xFC3F, 0x0FAD, 0xFD8E, 0xFA77, 0xECB5, 0xFDFD,
    0xF3F0, 0xF494, 0x11AE, 0x1BDE, 0x2372, 0x1C9E, 0x25C5, 0x3181, 0x2E72, 0x257A, 0x2CBC, 0x321A, 0x2976, 0x21EC, 0x019B, 0x0EC0,
    0x1E2C, 0x094F, 0x1B1E, 0x09A8, 0x1C3B, 0x1B56, 0x1557, 0x2190, 0x3425, 0x4609, 0x44C1, 0x482A, 0x537D, 0x4EED, 0x3729, 0x2BA3,
    0x2269, 0x5483, 0x4537, 0x3333, 0x3F32, 0x388F, 0x2FE1, 0x1BB0, 0x0E75, 0xFEC1, 0x07A9, 0x0C60, 0xFD48, 0xF4D8, 0x06E6, 0x0E7E,
    0x15AC, 0x102D, 0x0FB2, 0x1264, 0x0BF2, 0x0A67, 0xFCB6, 0xFE5C, 0x0D73, 0x1D52, 0x119D, 0xFF13, 0xDD70, 0xD522, 0xDF7E, 0xC773,
    0xB78A, 0xB6F0, 0xCACE, 0xC647, 0xCB5F, 0xCE66, 0xC92A, 0xC60F, 0xC5CB, 0xD312, 0xD665, 0xE111, 0xDF13, 0xD7DC, 0xE2D3, 0xFDD3,
    0xFEE9, 0xFFB1, 0x0581, 0x0BCA, 0x0D98, 0xFED6, 0xF51F, 0x0389, 0x1512, 0x232A, 0x2A35, 0x164D, 0x179B, 0x2AC9, 0x2D8E, 0x2207,
    0x32BC, 0x3AEE, 0x26DA, 0x199F, 0x17B5, 0x28E7, 0x26C1, 0x0DC3, 0xF285, 0xF024, 0xF075, 0xDA0E, 0xDB38, 0xE28D, 0xE2F6, 0xE81E,
    0xE57E, 0xD598, 0xDE26, 0xE375, 0xD538, 0xE559, 0xF73F, 0xFC2C, 0x0000, 0xF6C9, 0xF1BD, 0xDD70, 0xD55F, 0xD9D4, 0xD293, 0xDEAB,
    0xE186, 0xD9F0, 0xC748, 0xB57D, 0xA324, 0xB00E, 0xCC71, 0xD92C, 0xD291, 0xD19C, 0xE8B0, 0xF671, 0xFB21, 0xFF5A, 0x1777, 0x235C,
    0x1FAC, 0x2D0A, 0x3E7C, 0x2DE3, 0x1E13, 0x2AA1, 0x2D80, 0x1F19, 0x2A26, 0x38E0, 0x28A4, 0x316C, 0x2907, 0x2849, 0x39B7, 0x3528,
    0x4ADB, 0x3213, 0x245C, 0x3E28, 0x42CF, 0x416F, 0x414D, 0x3E82, 0x4280, 0x4D1A, 0x4091, 0x496B, 0x3C13, 0x20AF, 0x1551, 0x1DFF,
    0x2A9C, 0x0F45, 0xF3A2, 0xFD15, 0x06C9, 0xF4F4, 0xFE56, 0x08AC, 0x063D, 0xF7C3, 0x0A7A, 0x18D3, 0x0564, 0xFF1E, 0x01BF, 0xFF0B,
    0xE6B8, 0xE3A9, 0xCC6C, 0xBC23, 0xBA91, 0xC03D, 0xBF8A, 0xB483, 0xB960, 0xC04F, 0xB9AE, 0xAD1F, 0xB239, 0xB70B, 0xC6D6, 0xCF45,
    0xDA22, 0xF7CA, 0xFCA3, 0x018B, 0x0FC2, 0xFBE4, 0xFAAE, 0xF377, 0xF90A, 0x00B8, 0xFFF7, 0xFD56, 0xF309, 0xEBB8, 0xE85E, 0xFDCE,
    0xF32A, 0xF691, 0x0219, 0x0E87, 0x24A5, 0x220B, 0x181D, 0x3198, 0x2EDE, 0x2306, 0x154A, 0x093A, 0x1D71, 0x1393, 0x1468, 0x02AD,
    0xF679, 0xF5E5, 0xE3BF, 0xEA54, 0xF6AA, 0xED1D, 0xF953, 0xEE4F, 0xE15E, 0xE7A3, 0xF0D4, 0xF9B0, 0xE632, 0xEBE8, 0xE51E, 0xD981,
    0xD865, 0xE278, 0xEEAE, 0xF79B, 0x0044, 0x0828, 0x09A3, 0x03C8, 0x04D5, 0x0717, 0x008D, 0xED80, 0xE614, 0xE6E7, 0xDDF6, 0xEAC4,
    0x003A, 0xFDA3, 0x08AF, 0x0CC8, 0x14F5, 0x24DE, 0x2CAE, 0x2F9A, 0x31C5, 0x3800, 0x39C4, 0x345C, 0x2714, 0x19DC, 0x1469, 0x128C,
    0x18EF, 0x0E57, 0x1E1E, 0x26DC, 0x10F5, 0x25C3, 0x1E5B, 0x1C52, 0x0C71, 0x0B93, 0x1461, 0x0826, 0x13A6, 0x0970, 0x028C, 0x11AF,
    0x144A, 0x07BA, 0x0EB9, 0x09FA, 0x106C, 0x12A9, 0xFC45, 0xF8B9, 0xE2CC, 0xD66A, 0xE85D, 0xF2EE, 0xF10E, 0xD2F4, 0xD238, 0xE9AC,
    0xFB00, 0xFB83, 0xF806, 0xEFC8, 0xF507, 0xF05C, 0xE5E6, 0xFAE4, 0x005C, 0x0658, 0xF804, 0xF9E4, 0xEE8E, 0xDC57, 0xCA01, 0xCF7C,
    0xE07F, 0xEA15, 0xE374, 0xBF54, 0xBD99, 0xCCB6, 0xD269, 0xC003, 0xC514, 0xD92F, 0xDC2D, 0xDC23, 0xDD6D, 0xCA10, 0xD0F3, 0xEEA5,
    0xF693, 0xEB27, 0xE5E4, 0xF8F7, 0x08FB, 0x0DBA, 0x0350, 0xF3A3, 0xFD6C, 0x0199, 0x03BC, 0x0405, 0x0C15, 0x1534, 0x23F0, 0x3386,
    0x2669, 0x26B5, 0x319D, 0x4FAD, 0x3D2F, 0x39A9, 0x3DF6, 0x345B, 0x2DD9, 0x2892, 0x1F54, 0x0402, 0x02D1, 0x04F9, 0x1077, 0x0F52,
    0x0433, 0xFBB3, 0x0647, 0xF353, 0xF3FC, 0x06AA, 0x0240, 0xF585, 0xD80D, 0xDF06, 0xEC0F, 0xE764, 0xE095, 0xE8C2, 0xEFE7, 0xDFE9,
    0xE17B, 0xF563, 0xFFA8, 0xEE7A, 0xE01D, 0xD8B9, 0xD901, 0xE2CC, 0xDC5E, 0xE7E7, 0xE882, 0xE773, 0xE463, 0xEB38, 0xEBF0, 0xE2CF,
    0xE88B, 0xF6A2, 0x0A87, 0xF5E5, 0xF216, 0x0CC7, 0x11EF, 0xFC33, 0xE8EE, 0xEA34, 0xEBFB, 0xD7C6, 0xD39B, 0xE31F, 0xEA06, 0xDEE9,
    0xE03F, 0xE7BD, 0xE8BE, 0xF22C, 0xE7FD, 0xEB0B, 0x0270, 0x19E2, 0x15BE, 0x1FB5, 0x282B, 0x29BC, 0x26DC, 0x1F25, 0x2A88, 0x29E1,
    0x3471, 0x2609, 0x2056, 0x171E, 0x07E8, 0x0CA0, 0x0FA4, 0x1B65, 0x2B2A, 0x2862, 0x20C3, 0x1C61, 0x184F, 0x2299, 0x3659, 0x3F3C,
    0x2A96, 0x2EAA, 0x2682, 0x2626, 0x2527, 0x165E, 0x0BF1, 0xFDE6, 0xF679, 0xF84E, 0xF49A, 0xF407, 0xF64F, 0xE4A5, 0xE248, 0xDE8A,
    0xE8F0, 0xDB97, 0xD644, 0xDF78, 0xEA68, 0xF6B0, 0xEC2F, 0xFCFF, 0x0E4B, 0x0C1E, 0x072E, 0x0D00, 0x0C76, 0xFC81, 0xF8A2, 0xF600,
    0xECCC, 0xEC24, 0xE634, 0xEC63, 0xF97C, 0x03DD, 0x0AAE, 0x0773, 0x1455, 0x0B2B, 0x0F2C, 0x1969, 0x206E, 0x1ECB, 0x201B, 0x3C83,
    0x3AA9, 0x36FA, 0x269D, 0x2760, 0x2A25, 0x2DEE, 0x2340, 0x161E, 0x0F29, 0x0684, 0x0999, 0x0990, 0x15B0, 0x123C, 0x0337, 0xF058,
    0xF9FC, 0x0943, 0x0BB6, 0x0421, 0x00F7, 0xFE3C, 0x0321, 0x0DA7, 0xFFBD, 0xF417, 0xFC95, 0xF9C3, 0xF547, 0xF131, 0xD9E5, 0xD661,
    0xD825, 0xDD19, 0xD2D8, 0xCB3D, 0xD53E, 0xE38D, 0xF1B6, 0xEE70, 0xF1A5, 0xF543, 0xFD41, 0x0315, 0x0ED3, 0x1007, 0x08D6, 0x05B4,
    0xFC37, 0x005B, 0x00C9, 0xF7F5, 0xF4C2, 0xF1E9, 0xF263, 0xF8AA, 0xFCA2, 0xFC48, 0xEDF0, 0xEBA5, 0xE9E3, 0xF328, 0x0680, 0x0D2C,
    0x0F73, 0x1BDD, 0x2E6B, 0x2E67, 0x2F1A, 0x2F65, 0x19DA, 0x191B, 0x26CC, 0x11FB, 0x0258, 0xFD5E, 0x08E1, 0x0208, 0xF5C4, 0xF73E,
    0xED5E, 0xEB5E, 0xEA7E, 0xEF27, 0xF634, 0xFF75, 0x02B8, 0xF94A, 0xF561, 0xFC40, 0xF629, 0xFA79, 0xFD7B, 0xF8B6, 0xF385, 0xEF4C,
    0xF13D, 0xEB7B, 0xE0CC, 0xD4C6, 0xDD7B, 0xDBDF, 0xE1CE, 0xDAAE, 0xD287, 0xD773, 0xDC06, 0xE84C, 0xEB7D, 0x088F, 0x1961, 0x1582,
    0x145A, 0x1E7A, 0x2462, 0x215F, 0x213E, 0x2445, 0x3169, 0x3DC0, 0x3F60, 0x38DA, 0x30AF, 0x2B3A, 0x1EA6, 0x1315, 0x178C, 0x1DD5,
    0x1FCF, 0x21E3, 0x2764, 0x35CD, 0x4D4D, 0x4BE8, 0x4775, 0x3C32, 0x436F, 0x4535, 0x3B8D, 0x38EC, 0x220A, 0x1F31, 0x0E46, 0x0874,
    0xF820, 0xECEB, 0xF4F2, 0xED23, 0xEF20, 0xE632, 0xD154, 0xCCA6, 0xC624, 0xC661, 0xCBA4, 0xCAC2, 0xD0F0, 0xCEB1, 0xD9CF, 0xD77F,
    0xDF37, 0xE175, 0xD555, 0xD091, 0xC8A2, 0xCED7, 0xCFFC, 0xD20C, 0xCFBD, 0xC2D3, 0xC4E4, 0xBD71, 0xBA56, 0xC563, 0xCFB1, 0xDA35,
    0xE179, 0xF138, 0xF49B, 0x032E, 0x07B0, 0x0B08, 0x10F4, 0x09B8, 0x03B5, 0xF8BB, 0xF4C2, 0xFBCF, 0x010D, 0xFC83, 0xFD33, 0xFF7E,
    0x0361, 0xFD74, 0x065E, 0x0A88, 0x0090, 0xF780, 0xFF1B, 0x143A, 0x13F8, 0x16FA, 0x1117, 0x189A, 0x2A22, 0x39F3, 0x4973, 0x46A7,
    0x4450, 0x4275, 0x3F55, 0x3676, 0x2699, 0x1F1F, 0x162E, 0x1857, 0x10AF, 0x009E, 0x063F, 0x051E, 0x03CE, 0xFFBE, 0x02A2, 0x0312,
    0x0D41, 0x1F26, 0x216A, 0x195A, 0x118A, 0x0881, 0xFC50, 0xEAE2, 0xDC9C, 0xD54F, 0xC78A, 0xC657, 0xCB7B, 0xCBC6, 0xC016, 0xBF9C,
    0xC3FC, 0xC159, 0xBD13, 0xC7EF, 0xCC6A, 0xCF4C, 0xD94A, 0xE6D0, 0xFADE, 0x0342, 0x03E4, 0x0442, 0x01A5, 0xFFCE, 0x1402, 0x19FF,
    0x1B9F, 0x1907, 0x1B2C, 0x179E, 0x07DE, 0x02B9, 0x0755, 0x0C08, 0x117B, 0x1B1E, 0x1593, 0x15B4, 0x17A6, 0x2560, 0x2E64, 0x31A7,
    0x37C6, 0x3624, 0x3202, 0x21C0, 0x19C6, 0x182C, 0x11C5, 0x0514, 0x012D, 0xFA03, 0xEFE3, 0xEBCF, 0xEB31, 0xE7E7, 0xDB14, 0xD6A2,
    0xD2B4, 0xD480, 0xD44E, 0xD779, 0xDE16, 0xEB8F, 0xF360, 0xF03E, 0xF38B, 0xEB23, 0xE0A7, 0xE423, 0xE8D3, 0xEEB1, 0xEC3F, 0xE8B2,
    0xE4AE, 0xE1C7, 0xE47C, 0xE5F9, 0xE968, 0xF06F, 0xFFD9, 0x084C, 0x09A1, 0x0E48, 0x1AFA, 0x1D96, 0x2151, 0x1B96, 0x20C1, 0x2C1E,
    0x2E86, 0x2E27, 0x2B33, 0x2A3C, 0x28B0, 0x1DF0, 0x1542, 0x0DC0, 0x0447, 0x0B32, 0x031B, 0x043A, 0x04F8, 0x07EC, 0x0A62, 0x0CBB,
    0x0E3C, 0x111A, 0x1246, 0x18C3, 0x26E8, 0x2513, 0x1D23, 0x17F9, 0x1579, 0x1707, 0x12A7, 0x0BF6, 0x0D7D, 0x0CD1, 0x05AA, 0xECB1,
    0xECCB, 0xF3B9, 0xF16D, 0xE85B, 0xE9EB, 0xEBA3, 0xF0A0, 0xF4B3, 0xF2DD, 0xF860, 0xF64A, 0xFA8A, 0xF236, 0xE9BD, 0xDDA6, 0xDB0D,
    0xDBCC, 0xD66B, 0xD19E, 0xC52F, 0xBE5D, 0xBDD7, 0xBD2C, 0xC1F9, 0xC227, 0xBEE6, 0xC008, 0xBE4C, 0xBF26, 0xC360, 0xCAE8, 0xDB6F,
    0xE970, 0xF24D, 0xF685, 0xF998, 0x0A7F, 0x0D00, 0x09B0, 0x0B61, 0x10F9, 0x1629, 0x13BF, 0x0FAF, 0x0534, 0x03AA, 0x02D8, 0x011F,
    0x0412, 0x0905, 0x0FB9, 0x0DD2, 0x1265, 0x25AA, 0x31B5, 0x36AC, 0x39A1, 0x39E7, 0x3EF7, 0x4022, 0x43BC, 0x3F8D, 0x3833, 0x38BC,
    0x355C, 0x3337, 0x2F1A, 0x2AB2, 0x1F6F, 0x1BA9, 0x1C15, 0x17F7, 0x0A99, 0x00E7, 0x0377, 0x0259, 0x06F9, 0x0999, 0x112A, 0x1493,
    0x13C1, 0x1200, 0x0BD0, 0x0ABB, 0x0ED2, 0x0F0C, 0x0A6A, 0x089C, 0xFE0B, 0xF22F, 0xEB93, 0xE33A, 0xE208, 0xDDC4, 0xE153, 0xE568,
    0xE2CD, 0xED8C, 0xF84E, 0x0105, 0x06C2, 0x0B87, 0x0CAB, 0x082A, 0x0103, 0xFD0E, 0xFD1F, 0x04A0, 0x0842, 0x0644, 0xFF3F, 0xF784,
    0xFB71, 0xFFAB, 0xFBCE, 0xF5DE, 0xF327, 0xEEBD, 0xE828, 0xE3C8, 0xE74D, 0xE9B2, 0xEE60, 0xF81E, 0x0708, 0x1335, 0x1B9D, 0x246B,
    0x2094, 0x2697, 0x3098, 0x349B, 0x3E59, 0x3A60, 0x339E, 0x317F, 0x297D, 0x2060, 0x11FB, 0x0882, 0x095E, 0x0901, 0x1262, 0x1290,
    0x13C7, 0x1D23, 0x1FAB, 0x22B9, 0x1A8E, 0x1686, 0x0E6B, 0x0AA6, 0x0E06, 0x0461, 0xFACC, 0xF18E, 0xEE6C, 0xEA8E, 0xDF2C, 0xD73D,
    0xCF4B, 0xC485, 0xBC90, 0xBDB8, 0xBE67, 0xBE8F, 0xC12E, 0xC693, 0xCCCA, 0xCFE3, 0xD445, 0xDAB3, 0xDE66, 0xE0F5, 0xE628, 0xF053,
    0xF228, 0xF0C3, 0xF63F, 0xF702, 0xF8C0, 0xF942, 0xF51E, 0xED02, 0xEC4B, 0xE98C, 0xEA46, 0xE745, 0xE4CB, 0xEAD4, 0xF8CE, 0x0AC6,
    0x14C0, 0x1FAA, 0x2528, 0x2EBF, 0x35C4, 0x368B, 0x31EE, 0x2DAB, 0x282B, 0x2FD9, 0x2B1C, 0x1EB8, 0x1CD6, 0x1C7A, 0x225C, 0x1DC1,
    0x1C10, 0x13CB, 0x0F72, 0x0A74, 0x09E3, 0x06C7, 0xFF0E, 0x0320, 0x0BF6, 0x1B2F, 0x1CFB, 0x1D80, 0x1E4C, 0x23D5, 0x2B2C, 0x21BF,
    0x1852, 0x0E7E, 0x01B0, 0xF890, 0xEE72, 0xE6BD, 0xE656, 0xF0A1, 0xFD56, 0x05B4, 0x09F8, 0x0D18, 0x10A0, 0x14E5, 0x11A8, 0x0D68,
    0x12FD, 0x187B, 0x15F8, 0x1184, 0x1408, 0x1132, 0x0D17, 0x06F3, 0x0610, 0xF85C, 0xE694, 0xE119, 0xE129, 0xE14F, 0xDB4F, 0xDCE9,
    0xD67E, 0xD1BF, 0xD4EE, 0xD755, 0xDB93, 0xEAAD, 0xFEE3, 0x0BA6, 0x0EE6, 0x13F6, 0x11E6, 0x1559, 0x1BD2, 0x19C5, 0x1821, 0x1651,
    0x1A51, 0x0EB1, 0x0306, 0x02F1, 0x0473, 0x071F, 0x0A7D, 0x0085, 0xF5BC, 0xF42D, 0xFDDB, 0x00EF, 0xFDFD, 0x0A68, 0x0F94, 0x11CA,
    0x100F, 0x07B8, 0x00CF, 0xF6EC, 0xE90D, 0xD6C7, 0xCB92, 0xC988, 0xC0D5, 0xC152, 0xC2F9, 0xC4F3, 0xC308, 0xBE7F, 0xC1FE, 0xBC08,
    0xBC24, 0xC061, 0xC2FE, 0xCF00, 0xDB2F, 0xE351, 0xEE9E, 0xF8A7, 0x0341, 0x0A44, 0x120E, 0x152A, 0x10D3, 0x0968, 0x06B8, 0x0C5A,
    0x0536, 0x0105, 0x034A, 0x0191, 0x031C, 0x08B6, 0x15E9, 0x259A, 0x28E2, 0x296F, 0x3009, 0x37C9, 0x3E6A, 0x40D0, 0x3DFA, 0x36AB,
    0x348A, 0x3394, 0x2DC0, 0x2D5A, 0x248D, 0x1523, 0x0BA6, 0xFCEC, 0xED66, 0xE1D2, 0xDF3E, 0xDC7E, 0xD2DF, 0xCC29, 0xCD46, 0xD419,
    0xD58F, 0xD36A, 0xD283, 0xD448, 0xDC11, 0xDF12, 0xDB3F, 0xDE9D, 0xE24D, 0xE496, 0xDCC8, 0xD28A, 0xCE6E, 0xC526, 0xC26C, 0xC1E6,
    0xC5DD, 0xC9B0, 0xD012, 0xD8A3, 0xDA6A, 0xE4F6, 0xEE3B, 0xF575, 0xFE13, 0x054B, 0x0FA4, 0x124C, 0x1338, 0x13BD, 0x10E8, 0x0D65,
    0x0967, 0x08B9, 0x0779, 0x09D7, 0x0635, 0x012C, 0xFEEC, 0xFD2E, 0xFB34, 0xFBBA, 0xFF90, 0x01A5, 0x0442, 0x06E8, 0x0FBD, 0x14DB,
    0x1D89, 0x21CA, 0x213F, 0x28BC, 0x2DAE, 0x3191, 0x3531, 0x3359, 0x303E, 0x2A33, 0x1EB3, 0x133D, 0x06FD, 0x0269, 0x026B, 0x066B,
    0x058A, 0x0567, 0x0AF4, 0x0ED8, 0x1840, 0x1927, 0x1650, 0x122D, 0x0E1A, 0x0D4F, 0x07F2, 0x0259, 0xF346, 0xE79E, 0xE80C, 0xE4D0,
    0xE215, 0xDFDC, 0xD609, 0xCFCD, 0xD1BB, 0xD40F, 0xD46A, 0xD335, 0xD6BB, 0xD7F6, 0xD720, 0xD8C1, 0xE0C7, 0xE645, 0xE613, 0xEB8F,
    0xF1D4, 0xFC5D, 0x0687, 0x0E37, 0x117D, 0x0F9B, 0x0E10, 0x07C3, 0x007C, 0xFB3E, 0xF5C8, 0xF760, 0xFDAF, 0xFF74, 0x021D, 0x02D1,
    0x037E, 0x05DB, 0x0710, 0x0819, 0x066E, 0x06E5, 0x0BDB, 0x13F7, 0x11E3, 0x0AED, 0x06AF, 0x042B, 0xFF95, 0xF96F, 0xF622, 0xEF45,
    0xE9BD, 0xE0D3, 0xDA89, 0xD742, 0xD8CD, 0xD5B5, 0xCBAA, 0xCCF3, 0xC9DE, 0xCC10, 0xD351, 0xDA7B, 0xDF7F, 0xDB9F, 0xDD56, 0xDE3A,
    0xE114, 0xE80C, 0xEBE8, 0xE6F2, 0xD9F7, 0xD7DF, 0xDC73, 0xD90E, 0xD7E3, 0xD69D, 0xD634, 0xDC15, 0xE0DC, 0xEFC5, 0xF7D2, 0xFA80,
    0x04FE, 0x1459, 0x24E8, 0x29AB, 0x2F45, 0x30FA, 0x352E, 0x37DF, 0x33D7, 0x2C4A, 0x204F, 0x1F32, 0x204F, 0x2150, 0x1E56, 0x1A14,
    0x1C3F, 0x1D44, 0x1799, 0x1871, 0x1BDA, 0x1A68, 0x1BD1, 0x1F8C, 0x2203, 0x21F1, 0x268D, 0x2FF3, 0x3484, 0x3A09, 0x3EA5, 0x3AB9,
    0x383C, 0x3826, 0x382B, 0x2E00, 0x21F0, 0x183B, 0x11A5, 0x0990, 0x01B7, 0xFD92, 0xFB71, 0xF76C, 0xF7B9, 0x0360, 0x0479, 0x013E,
    0x048A, 0x072D, 0xFF9A, 0xF953, 0xF162, 0xECA3, 0xDDEC, 0xD030, 0xCEA4, 0xCC13, 0xCC4D, 0xC9B3, 0xC749, 0xC079, 0xC01D, 0xBBAD,
    0xBA03, 0xBA62, 0xBADB, 0xBEEF, 0xC1FE, 0xCC36, 0xD80A, 0xE3A7, 0xEE3F, 0xFA1E, 0x017B, 0x0770, 0x0772, 0x056E, 0x0781, 0x0589,
    0x03E2, 0x075F, 0x0A65, 0x0620, 0x0333, 0x0807, 0x1015, 0x16D9, 0x1C2C, 0x2196, 0x22FE, 0x249C, 0x24BE, 0x26A9, 0x2D97, 0x2EFD,
    0x310D, 0x31B2, 0x2F51, 0x29F4, 0x22E1, 0x1827, 0x0EBF, 0x09F0, 0x01BC, 0xFEEB, 0xFBD2, 0xF4A7, 0xEF34, 0xE70C, 0xDEA6, 0xDF83,
    0xE190, 0xE1E9, 0xE1A9, 0xE061, 0xE311, 0xDB46, 0xD7B2, 0xE1B6, 0xEB78, 0xF071, 0xED09, 0xEA66, 0xE8B6, 0xEA03, 0xE2A6, 0xD651,
    0xD188, 0xCED8, 0xD212, 0xD646, 0xDB93, 0xDEA5, 0xDD2E, 0xE163, 0xE90C, 0xF212, 0xF97E, 0xFAFB, 0xFB69, 0xFC3F, 0xFC71, 0xFBE1,
    0xFC45, 0xFABD, 0xF8B4, 0xFA31, 0xF9D7, 0xF6FC, 0xF635, 0xF381, 0xEFFB, 0xEBF4, 0xE629, 0xE98C, 0xEED6, 0xF175, 0xF29F, 0xF663,
    0x0156, 0x0E82, 0x19AC, 0x214A, 0x2B4F, 0x321E, 0x3542, 0x37EB, 0x3C1F, 0x3E32, 0x3FFC, 0x4309, 0x4124, 0x3CB3, 0x3789, 0x366E,
    0x36FB, 0x359B, 0x324D, 0x3512, 0x3B4F, 0x3EBE, 0x3C43, 0x38DE, 0x3A89, 0x38D5, 0x34BB, 0x310C, 0x2A83, 0x2706, 0x24BC, 0x2224,
    0x19A5, 0x0411, 0xF153, 0xE3C9, 0xDE32, 0xD97A, 0xD259, 0xCBB9, 0xC50F, 0xC2FB, 0xBDE3, 0xB7BF, 0xB8FC, 0xBEB9, 0xC321, 0xC8EC,
    0xD0EE, 0xD58B, 0xD72B, 0xDD01, 0xE29D, 0xE635, 0xEC3F, 0xF3CB, 0xF67A, 0xF2F4, 0xEF4E, 0xEF0C, 0xED6A, 0xE96D, 0xE5C2, 0xE750,
    0xEC6D, 0xF17A, 0xFAB2, 0xFEDA, 0x0390, 0x0C25, 0x0F0C, 0x113C, 0x1936, 0x2279, 0x266A, 0x2AEB, 0x2F37, 0x299B, 0x2521, 0x2249,
    0x1B3A, 0x189E, 0x1418, 0x11B4, 0x0FC9, 0x0EDC, 0x0C73, 0xFCF1, 0xF33A, 0xEF34, 0xEC40, 0xF1B1, 0xF90C, 0xFF8B, 0x02B2, 0x065C,
    0x0CC2, 0x0CFF, 0x0E35, 0x0D39, 0x0503, 0xFC13, 0xF1C6, 0xEAF3, 0xE67C, 0xE772, 0xE5E0, 0xDF7F, 0xDF8E, 0xDE64, 0xDEE8, 0xE4E1,
    0xE5F7, 0xE5E1, 0xE5F1, 0xE7F8, 0xEFE9, 0xF7C8, 0xFF46, 0x026B, 0x03C6, 0x001A, 0xFE98, 0x03E4, 0xFD0F, 0xF5D9, 0xF0E8, 0xEEC6,
    0xEF45, 0xEA23, 0xE93A, 0xE81A, 0xE70F, 0xE7F8, 0xEB70, 0xEEC5, 0xEC61, 0xEEEB, 0xF470, 0xF76E, 0xF722, 0xF901, 0x02DA, 0x0B2C,
    0x15A3, 0x1D45, 0x2284, 0x2316, 0x1E19, 0x1B55, 0x1674, 0x1093, 0x0D19, 0x1222, 0x13EE, 0x11EA, 0x0FC8, 0x1123, 0x1500, 0x198F,
    0x1FAC, 0x22C3, 0x2565, 0x2604, 0x294D, 0x2449, 0x1C29, 0x17B6, 0x0D30, 0x00DF, 0xFA28, 0xF234, 0xE96C, 0xE57A, 0xDF6C, 0xDACE,
    0xD655, 0xD4EE, 0xD0D4, 0xC991, 0xC5B6, 0xC549, 0xC976, 0xD119, 0xDD7C, 0xE71D, 0xE93D, 0xEA86, 0xED27, 0xF28B, 0xF791, 0xFE45,
    0x0874, 0x0B81, 0x0BEF, 0x0A16, 0x0595, 0x051F, 0x05E5, 0x0651, 0x09D8, 0x0F94, 0x1610, 0x19B2, 0x1BE8, 0x1E28, 0x1EA6, 0x246C,
    0x2D7F, 0x372E, 0x42E9, 0x47F5, 0x487D, 0x46E8, 0x40BF, 0x3BA4, 0x3437, 0x2843, 0x1BCE, 0x1311, 0x0D77, 0x07D9, 0x038D, 0xFDCD,
    0xFA09, 0xF7DD, 0xF4D6, 0xF59C, 0xF56B, 0xF778, 0xF96E, 0xFACB, 0x0234, 0x0171, 0xFE5C, 0x008E, 0xFD09, 0xF9AA, 0xF71A, 0xF460,
    0xEDE9, 0xDFF1, 0xD317, 0xCBB3, 0xC452, 0xBEA7, 0xBD41, 0xBFCF, 0xC432, 0xC844, 0xCD9E, 0xD10A, 0xD48E, 0xD8D8, 0xE23E, 0xEAA8,
    0xEB45, 0xE8CC, 0xE70E, 0xE9BF, 0xEF84, 0xF680, 0xFBE5, 0xFBF3, 0xF9D2, 0xF330, 0xECD6, 0xE95A, 0xE3D5, 0xDE98, 0xDEE4, 0xE274,
    0xE44F, 0xE9B8, 0xF35C, 0xFF2A, 0x048D, 0x099B, 0x0F4D, 0x124C, 0x1B1A, 0x2610, 0x2E70, 0x2FFF, 0x2B83, 0x2573, 0x2025, 0x18F1,
    0x132B, 0x149C, 0x180D, 0x17E3, 0x12FD, 0x0E00, 0x09F2, 0x0ACB, 0x11B4, 0x17E0, 0x17ED, 0x14C8, 0x176D, 0x1BA5, 0x1F3C, 0x250E,
    0x24DA, 0x1E78, 0x11F9, 0xFB18, 0xEA92, 0xDE55, 0xD924, 0xD840, 0xD38D, 0xD259, 0xCD82, 0xCEEB, 0xD3AB, 0xD772, 0xDB78, 0xDA26,
    0xDEF7, 0xE59B, 0xEB30, 0xF188, 0xF80D, 0x035D, 0x078E, 0x0C3B, 0x168D, 0x1FCA, 0x2811, 0x2597, 0x1F11, 0x1DEE, 0x1A4D, 0x178F,
    0x160B, 0x12F1, 0x17A5, 0x1D62, 0x2491, 0x2C53, 0x3102, 0x32F2, 0x2F72, 0x2A92, 0x25F9, 0x2418, 0x22BE, 0x238A, 0x2266, 0x1D15,
    0x168C, 0x0FB0, 0x09C3, 0x05F7, 0x0177, 0xFB5B, 0xF692, 0xF06B, 0xE800, 0xDF53, 0xD8B8, 0xD3FE, 0xD406, 0xDBFF, 0xE29B, 0xE425,
    0xE7D3, 0xEB08, 0xEDAF, 0xEDF4, 0xEDF1, 0xECC6, 0xEAAD, 0xED9F, 0xF048, 0xF0F2, 0xEAAA, 0xE591, 0xE37E, 0xE0A9, 0xDE64, 0xDC33,
    0xE065, 0xE4FF, 0xED19, 0xF5E0, 0xFD73, 0x054C, 0x1026, 0x1C91, 0x203A, 0x2084, 0x2005, 0x2019, 0x1D10, 0x1CF6, 0x1EC6, 0x1AD4,
    0x170F, 0x126F, 0x0EAA, 0x0B55, 0x06D3, 0xFE43, 0xF46F, 0xEE74, 0xED50, 0xF304, 0xF339, 0xF0F9, 0xF4D6, 0xFBD4, 0x0048, 0xFF40,
    0x03F9, 0x0C04, 0x0E7A, 0x0BBD, 0x0933, 0x0A01, 0x0A33, 0x08DF, 0x03EA, 0xFD0A, 0xFAB3, 0xF8DF, 0xEE7A, 0xE7E6, 0xE8DD, 0xEBF3,
    0xF17F, 0xF5F1, 0xFC79, 0xFF18, 0x0075, 0x00E6, 0xFFF0, 0x03AC, 0x030D, 0xFEE1, 0xF77B, 0xEE10, 0xE600, 0xDE96, 0xD86C, 0xD0C2,
    0xCB82, 0xC611, 0xC1DB, 0xBDFD, 0xBCB3, 0xBE76, 0xBC3E, 0xBEC7, 0xC5EB, 0xCF2A, 0xDB08, 0xE664, 0xF016, 0xFBF9, 0x0522, 0x0B27,
    0x13E6, 0x1BBF, 0x2094, 0x2355, 0x2494, 0x2414, 0x24B2, 0x29EA, 0x2E5B, 0x2E96, 0x2C57, 0x2A28, 0x2F4F, 0x3945, 0x4491, 0x4CF6,
    0x4C9F, 0x4CEE, 0x4DD2, 0x4D7F, 0x4D0C, 0x4A90, 0x49FB, 0x481E, 0x4422, 0x3F95, 0x39ED, 0x30F5, 0x28B1, 0x1FEF, 0x1C79, 0x1A5D,
    0x133C, 0x0A74, 0x01A0, 0xFA9F, 0xF22F, 0xEDB0, 0xE9DF, 0xE89A, 0xEBA6, 0xF468, 0xFADD, 0xF7C0, 0xF1EA, 0xEFFD, 0xF2FD, 0xF33F,
    0xF184, 0xEE76, 0xE64A, 0xDA1F, 0xCEC7, 0xCA79, 0xC83F, 0xC69D, 0xC96D, 0xCAB5, 0xCD1A, 0xCF07, 0xD060, 0xD392, 0xDA4B, 0xE364,
    0xEBC5, 0xF0F5, 0xF139, 0xF451, 0xF903, 0xFA86, 0xFA05, 0xF85C, 0xF485, 0xF563, 0xF83B, 0xF769, 0xF720, 0xF3E0, 0xF14B, 0xEF01,
    0xEC36, 0xEDB3, 0xED8C, 0xEFAD, 0xF4CC, 0xFAB0, 0x043F, 0x0874, 0x099E, 0x09D9, 0x0B8C, 0x1069, 0x14E0, 0x1D22, 0x2498, 0x29F6,
    0x2BD9, 0x2BCC, 0x287F, 0x21DE, 0x1BB0, 0x164F, 0x12D0, 0x1400, 0x170F, 0x1AE1, 0x229B, 0x29B0, 0x2DAB, 0x2F93, 0x32CC, 0x34A4,
    0x300A, 0x297D, 0x22A2, 0x1E40, 0x1C1D, 0x12AD, 0x0633, 0xF79C, 0xEBE8, 0xE091, 0xD88F, 0xD5FB, 0xD3E1, 0xCF06, 0xC7DC, 0xC32B,
    0xBE51, 0xC213, 0xC786, 0xCB30, 0xCD35, 0xD368, 0xDCA5, 0xE2DC, 0xE2D9, 0xDD46, 0xDCE2, 0xDCE9, 0xDEB6, 0xE2CB, 0xE765, 0xED03,
    0xEF08, 0xED98, 0xEC9E, 0xEF28, 0xF522, 0xF9B9, 0xFE04, 0x04BA, 0x0A31, 0x0E1B, 0x16C5, 0x2141, 0x2712, 0x2C36, 0x3518, 0x3B88,
    0x38EB, 0x340A, 0x3417, 0x337E, 0x2CE0, 0x2662, 0x2205, 0x1DEE, 0x1B1B, 0x1819, 0x1402, 0x1275, 0x121D, 0x1139, 0x10B4, 0x13FE,
    0x17BD, 0x1932, 0x1912, 0x198E, 0x1C89, 0x1CEE, 0x1EB8, 0x1FE4, 0x2213, 0x1F7E, 0x1705, 0x0E0C, 0x042F, 0xFF4C, 0xFA4F, 0xF4E6,
    0xEF3A, 0xE8FD, 0xE69E, 0xE595, 0xE768, 0xEB92, 0xEEF7, 0xF76C, 0xFC5D, 0xFE50, 0x03B3, 0x089C, 0x0953, 0x05E3, 0x017F, 0xFC35,
    0xF3D0, 0xEE2E, 0xEF07, 0xEE7F, 0xEF3D, 0xED98, 0xEB3A, 0xE344, 0xDAA7, 0xD7C0, 0xD647, 0xD911, 0xDB6B, 0xE28D, 0xEA05, 0xEDFF,
    0xF18D, 0xFA1B, 0x0719, 0x10D3, 0x15C0, 0x1B76, 0x23A4, 0x2AD7, 0x2CBF, 0x2AAC, 0x27B4, 0x2318, 0x2340, 0x230D, 0x1EFC, 0x1988,
    0x156B, 0x15B3, 0x1771, 0x17D3, 0x19F8, 0x1D62, 0x1DF8, 0x1BD9, 0x19F9, 0x1856, 0x13CB, 0x0FBB, 0x09DC, 0x0266, 0xFA04, 0xEFFB,
    0xE3F0, 0xD61E, 0xCCFB, 0xC840, 0xC3BA, 0xBCBD, 0xB72E, 0xB4DA, 0xB19B, 0xB15D, 0xB401, 0xB66D, 0xBBB6, 0xC24E, 0xC89C, 0xCDD1,
    0xD2AA, 0xD64B, 0xDA81, 0xE122, 0xEA3A, 0xF4DC, 0xFB72, 0xFE47, 0x0208, 0x0522, 0x05D9, 0x050A, 0x03E0, 0x05E0, 0x06DE, 0x07B9,
    0x09F5, 0x0D6C, 0x1656, 0x1E24, 0x24B3, 0x2C00, 0x30BF, 0x3582, 0x38BF, 0x3AC4, 0x3A9A, 0x356F, 0x2F15, 0x2816, 0x24A7, 0x2596,
    0x2184, 0x1C34, 0x15EA, 0x0EEE, 0x0AA9, 0x03DF, 0xFE26, 0xFD69, 0x0025, 0x0482, 0x097C, 0x0E1C, 0x101C, 0x1012, 0x0FB1, 0x0F74,
    0x10BD, 0x1084, 0x0E8C, 0x0C0D, 0x083E, 0x0489, 0xFF06, 0xF577, 0xEC14, 0xE6CC, 0xE40D, 0xE030, 0xDCEE, 0xDEC5, 0xE182, 0xE540,
    0xE7E7, 0xE8D8, 0xE919, 0xE9C7, 0xF074, 0xF754, 0xFCCC, 0x001E, 0xFFBD, 0xFD0F, 0xF79B, 0xF110, 0xEAF1, 0xE748, 0xE56E, 0xE57C,
    0xE601, 0xE811, 0xE6E4, 0xE2E8, 0xE2B8, 0xE3C7, 0xE777, 0xEED5, 0xF9E2, 0x0181, 0x07C4, 0x0F45, 0x1441, 0x1827, 0x1CAB, 0x22BB,
    0x2712, 0x2A4B, 0x2D1E, 0x2DB9, 0x2CDA, 0x26FF, 0x1E7A, 0x1826, 0x1563, 0x1460, 0x1446, 0x18D2, 0x1EEC, 0x2451, 0x28F7, 0x2ED7,
    0x3270, 0x356C, 0x371C, 0x31BD, 0x2B72, 0x2636, 0x1FD5, 0x1826, 0x0E78, 0x03DE, 0xF98E, 0xEC17, 0xDBE9, 0xD006, 0xC809, 0xC09B,
    0xBC4F, 0xBA7C, 0xBBD1, 0xBDD0, 0xC239, 0xC707, 0xCA82, 0xCE2F, 0xD2AB, 0xD7A2, 0xD902, 0xDC84, 0xE3B0, 0xEE8E, 0xF668, 0xF9F2,
    0xFD72, 0xFAF2, 0xF709, 0xF525, 0xF2E9, 0xF26C, 0xEF89, 0xF018, 0xF9B6, 0x04DF, 0x0FF1, 0x160E, 0x17CC, 0x1783, 0x179B, 0x1C30,
    0x1FA6, 0x2393, 0x27A7, 0x295A, 0x2803, 0x225C, 0x1B04, 0x1330, 0x0710, 0xFB2F, 0xF4AF, 0xF452, 0xF363, 0xED7B, 0xE987, 0xE513,
    0xE1E4, 0xDFBF, 0xDFC5, 0xE3D2, 0xE8FD, 0xEDB6, 0xEFC9, 0xF074, 0xF300, 0xF75A, 0xFAAF, 0x0084, 0x0884, 0x0BF3, 0x07DD, 0x02FD,
    0xFFE7, 0xFB88, 0xF4D0, 0xEC05, 0xE9F2, 0xEC42, 0xF16E, 0xF9AA, 0x038A, 0x0CD2, 0x13CE, 0x1D4E, 0x25A2, 0x2C00, 0x2DE3, 0x31A8,
    0x3500, 0x3349, 0x2FD0, 0x2BAB, 0x28EC, 0x22A7, 0x1D7C, 0x1C6A, 0x1B8F, 0x1704, 0x1187, 0x0C4C, 0x09F4, 0x080B, 0x078A, 0x0977,
    0x09E5, 0x0AB1, 0x0AAB, 0x0BDC, 0x0C28, 0x0C0C, 0x0D67, 0x0D8D, 0x0B9C, 0x0B30, 0x0C80, 0x0E26, 0x0C4C, 0x0B37, 0x0B52, 0x08A0,
    0x0594, 0x00E0, 0xFD11, 0xF83A, 0xF482, 0xF1CA, 0xEF1F, 0xEDAC, 0xEF55, 0xF51B, 0xFBCC, 0x0255, 0x05CE, 0x0504, 0x0127, 0xFB63,
    0xF487, 0xED84, 0xE7FA, 0xE3E2, 0xDEE6, 0xD912, 0xD3C3, 0xCF38, 0xC8B2, 0xC225, 0xBECE, 0xBE58, 0xC0E6, 0xC63F, 0xCEF6, 0xD72E,
    0xE01E, 0xE9D3, 0xF2FD, 0xFCAA, 0x02A8, 0x0928, 0x0F2F, 0x0F27, 0x0E68, 0x0F29, 0x0FE5, 0x0FE6, 0x0E50, 0x0F2D, 0x0F47, 0x0E45,
    0x10B9, 0x13B0, 0x1822, 0x1BE0, 0x20EB, 0x294A, 0x2D1B, 0x2E27, 0x2F68, 0x2F39, 0x2F53, 0x2E96, 0x2E13, 0x2B5D, 0x2644, 0x1FC3,
    0x17EA, 0x1318, 0x0B76, 0x0364, 0xFDF7, 0xF836, 0xF47A, 0xECFF, 0xE6D4, 0xE4F1, 0xE292, 0xE53E, 0xE8E3, 0xEE90, 0xF290, 0xF2FC,
    0xF33A, 0xF1C0, 0xF2EA, 0xF2A0, 0xF2DF, 0xF3A3, 0xF0E0, 0xEB26, 0xE2D2, 0xDA84, 0xD5A6, 0xD489, 0xD697, 0xD608, 0xD34F, 0xD580,
    0xD6E6, 0xD93E, 0xDD94, 0xE157, 0xE452, 0xE993, 0xF04B, 0xF58C, 0xF9CF, 0xFEEF, 0x03D6, 0x03D1, 0x0403, 0x0625, 0x0592, 0xFFDA,
    0xFADC, 0xF8CF, 0xF8BF, 0xF720, 0xF8F6, 0xFC63, 0xFCEF, 0xFF97, 0x041C, 0x0ADA, 0x0EA5, 0x1370, 0x1A5E, 0x1EBB, 0x240A, 0x275F,
    0x2E3E, 0x3696, 0x3B3F, 0x4242, 0x436A, 0x40FB, 0x3FA0, 0x3BE8, 0x35E4, 0x2F0C, 0x2D83, 0x2F3C, 0x2D1A, 0x2C85, 0x2FE9, 0x349D,
    0x3450, 0x31A5, 0x3533, 0x3545, 0x337B, 0x3288, 0x332B, 0x32A1, 0x2BD6, 0x265D, 0x1E5D, 0x133C, 0x06F1, 0xF9FE, 0xF19A, 0xE71A,
    0xDCAF, 0xD4DB, 0xCCE3, 0xC522, 0xBF3B, 0xBD1A, 0xBC3B, 0xB9DE, 0xB871, 0xBC23, 0xC27D, 0xC679, 0xC9E5, 0xCF1E, 0xD2DA, 0xD754,
    0xDD9C, 0xE3DB, 0xEAA5, 0xF189, 0xF648, 0xF7B1, 0xF70C, 0xF793, 0xFB15, 0xFEDC, 0xFED8, 0xFE8C, 0xFFAF, 0x028D, 0x0478, 0x0912,
    0x11BA, 0x166A, 0x18AC, 0x1BF4, 0x22AC, 0x25B1, 0x238B, 0x2064, 0x1A03, 0x10D9, 0x0921, 0x057F, 0x0299, 0x000D, 0xFF0B, 0xFEC0,
    0xFB44, 0xF4BA, 0xEE3F, 0xEB48, 0xEBF2, 0xEF5B, 0xF771, 0xFE24, 0x0164, 0x02CF, 0x0432, 0x04EC, 0x0845, 0x0D7A, 0x102B, 0x10EF,
    0x0F84, 0x0B13, 0x0301, 0xF962, 0xEE31, 0xE7E4, 0xE3D8, 0xE170, 0xE271, 0xE3C9, 0xE5BC, 0xE925, 0xEFA7, 0xF474, 0xF813, 0xFB3C,
    0xFD2F, 0xFD2C, 0xFCAB, 0xFD5C, 0xFAB9, 0xF3E5, 0xEBE5, 0xE83B, 0xE5BD, 0xE280, 0xE1E6, 0xE15B, 0xE48C, 0xE892, 0xE9B9, 0xE8AB,
    0xE69E, 0xEBB0, 0xF25C, 0xF8D5, 0x0108, 0x0632, 0x0C2D, 0x130E, 0x1A40, 0x2162, 0x2741, 0x2D3C, 0x3055, 0x32AA, 0x3456, 0x3686,
    0x3B08, 0x3B15, 0x3A51, 0x3981, 0x3732, 0x356D, 0x33C0, 0x340B, 0x3387, 0x3130, 0x2FDE, 0x3178, 0x34A6, 0x3602, 0x34BA, 0x3446,
    0x3182, 0x2C4A, 0x2306, 0x1639, 0x0B30, 0x0105, 0xF6D0, 0xEB24, 0xDFDD, 0xD3A9, 0xC98D, 0xC1DA, 0xBBB6, 0xB916, 0xB926, 0xBB32,
    0xBC8A, 0xBE3B, 0xC1AB, 0xC398, 0xC48D, 0xC59E, 0xC8E8, 0xCE1D, 0xD17B, 0xD673, 0xDD3D, 0xE5C0, 0xED87, 0xF27A, 0xF44E, 0xF320,
    0xF063, 0xEDF3, 0xEE0F, 0xF25F, 0xFA6A, 0x0430, 0x0EC2, 0x165D, 0x1E91, 0x2681, 0x2B14, 0x2F0D, 0x34C4, 0x3AEB, 0x3EDB, 0x42B7,
    0x42A9, 0x41FB, 0x3F47, 0x3801, 0x32D3, 0x3021, 0x2D5F, 0x2A1E, 0x23F6, 0x1CCF, 0x1725, 0x0FBE, 0x09AC, 0x03FA, 0x0123, 0x031C,
    0x06CC, 0x0837, 0x032D, 0x0071, 0x0161, 0x00F9, 0x01FD, 0x0211, 0xFFC3, 0xF9B8, 0xF25C, 0xED49, 0xE638, 0xDD4B, 0xD5D3, 0xD007,
    0xCAA2, 0xC5D3, 0xC5A5, 0xC664, 0xC71C, 0xCCB8, 0xD2E5, 0xD811, 0xDBD4, 0xE0E2, 0xE832, 0xED74, 0xF1D5, 0xF571, 0xF585, 0xF182,
    0xEB3E, 0xE80F, 0xE7CD, 0xE67F, 0xE58D, 0xE440, 0xE153, 0xE07E, 0xDFB2, 0xE10B, 0xE48A, 0xE85F, 0xF062, 0xF6C2, 0xFBC7, 0xFEC5,
    0x020D, 0x06C1, 0x0DAA, 0x1904, 0x20A8, 0x225D, 0x23AA, 0x25FE, 0x2683, 0x2643, 0x24DC, 0x24CA, 0x2625, 0x2787, 0x2AF2, 0x2B9F,
    0x2994, 0x28D0, 0x2EB5, 0x37BE, 0x3D42, 0x4280, 0x46C8, 0x4A84, 0x4C42, 0x4AE4, 0x465D, 0x3D68, 0x3238, 0x2735, 0x1D71, 0x1342,
    0x0838, 0x01A6, 0xFC99, 0xF787, 0xF0CB, 0xE6D7, 0xDCFD, 0xD581, 0xD18C, 0xD079, 0xD43E, 0xD774, 0xDA03, 0xDDA1, 0xE208, 0xE6A3,
    0xE9ED, 0xEBE7, 0xEBBB, 0xEAD8, 0xEC3F, 0xEE97, 0xF284, 0xF67B, 0xF77E, 0xF869, 0xF734, 0xF7B8, 0xFBE3, 0xFE9F, 0x0019, 0x00F4,
    0x0430, 0x0827, 0x0BCE, 0x10C6, 0x1497, 0x1B9D, 0x2010, 0x1FEC, 0x20EB, 0x1E70, 0x1A41, 0x13AB, 0x09AB, 0x0048, 0xF7D0, 0xF4BD,
    0xF26C, 0xF0BC, 0xEEF7, 0xEB1E, 0xEBDE, 0xEC54, 0xEC40, 0xEE9F, 0xF2B7, 0xF6A6, 0xF7AA, 0xF8D1, 0xFCB8, 0x00C1, 0x070A, 0x0B98,
    0x10C6, 0x140D, 0x1287, 0x1290, 0x0EC1, 0x087A, 0x02D8, 0xFC31, 0xF540, 0xEF31, 0xEE1C, 0xF00D, 0xF179, 0xF53D, 0xF9DA, 0x009C,
    0x045B, 0x068B, 0x0AF8, 0x0D07, 0x0DA0, 0x0D4A, 0x0B76, 0x0789, 0x0295, 0xFE97, 0xFC51, 0xFBE3, 0xFADC, 0xF823, 0xF51F, 0xF1AE,
    0xEF02, 0xEBBF, 0xE954, 0xE6CF, 0xE94D, 0xEF66, 0xF302, 0xF712, 0xF81D, 0xF898, 0xFD40, 0x0212, 0x06B0, 0x0ADC, 0x0EA3, 0x115B,
    0x1001, 0x0EE3, 0x0B91, 0x07C8, 0x051D, 0x01E3, 0x02BB, 0x013B, 0xFA49, 0xF3D6, 0xEF9E, 0xF17A, 0xF4F9, 0xF7D0, 0xFD07, 0x0195,
    0x08BB, 0x0E0F, 0x12BD, 0x1477, 0x0FAA, 0x0B57, 0x0476, 0xFCE0, 0xF576, 0xEE90, 0xE800, 0xE168, 0xDC41, 0xD996, 0xD85E, 0xD634,
    0xD409, 0xD59D, 0xD960, 0xDCCA, 0xE4CF, 0xEBF5, 0xF164, 0xF75C, 0xFCEF, 0x060B, 0x0E21, 0x11AA, 0x15D9, 0x1BF1, 0x218F, 0x2432,
    0x25BD, 0x2743, 0x25E4, 0x24FF, 0x25B5, 0x257C, 0x2568, 0x2585, 0x2917, 0x2EBA, 0x3402, 0x38DA, 0x3C92, 0x3ED9, 0x3F6A, 0x4092,
    0x4007, 0x3D64, 0x39A1, 0x3393, 0x2B1E, 0x23C1, 0x1A4C, 0x11C2, 0x0C85, 0x0815, 0x047A, 0xFEC6, 0xF98B, 0xF36D, 0xEEB8, 0xEEA0,
    0xF14F, 0xF4FF, 0xF616, 0xF4E8, 0xF5AA, 0xF39C, 0xEF99, 0xEDEF, 0xEC18, 0xED17, 0xEECA, 0xF0E3, 0xF317, 0xF3E1, 0xF5F2, 0xF49E,
    0xF14C, 0xEE3B, 0xE98C, 0xE605, 0xE17D, 0xDE81, 0xE05F, 0xE274, 0xE7A9, 0xEE10, 0xF209, 0xF9DB, 0x0145, 0x06C5, 0x0B29, 0x0AB7,
    0x06A7, 0xFF50, 0xF642, 0xEE83, 0xE81D, 0xE496, 0xE1EE, 0xDFC9, 0xE056, 0xE040, 0xE0E2, 0xE1DA, 0xE10A, 0xE169, 0xE210, 0xE3F8,
    0xE74E, 0xEBAE, 0xF018, 0xF35A, 0xF7D4, 0xFC1C, 0x017C, 0x0669, 0x07ED, 0x0982, 0x0D01, 0x0DEF, 0x0DF4, 0x0EE9, 0x0FA2, 0x0EA3,
    0x0DA5, 0x0F1F, 0x10B9, 0x1661, 0x1D1C, 0x21C9, 0x2714, 0x29F7, 0x2D1B, 0x303F, 0x3008, 0x3020, 0x2F16, 0x2E2B, 0x2954, 0x20DA,
    0x19C8, 0x1116, 0x0877, 0xFFF8, 0xF75D, 0xEDCA, 0xE13C, 0xD55F, 0xCBEC, 0xC425, 0xC25B, 0xC445, 0xC592, 0xC758, 0xC925, 0xCBB0,
    0xCE0F, 0xD2CE, 0xD8F1, 0xDDB8, 0xE286, 0xE6F9, 0xEEF7, 0xF725, 0xFCCE, 0x00F4, 0x04C3, 0x07A0, 0x0780, 0x064A, 0x04FA, 0x0431,
    0x0709, 0x0C16, 0x112D, 0x185A, 0x20B9, 0x2ABE, 0x320D, 0x3738, 0x3F37, 0x4534, 0x47BB, 0x47BB, 0x432D, 0x3C8F, 0x3453, 0x2C15,
    0x24A6, 0x1DCA, 0x19EA, 0x15C4, 0x1120, 0x0EE7, 0x0AEB, 0x0837, 0x06EA, 0x03A5, 0x04E2, 0x0907, 0x0B2D, 0x09D8, 0x080B, 0x0854,
    0x0778, 0x05D4, 0x0802, 0x0A66, 0x0B04, 0x094D, 0x0585, 0xFFAD, 0xF4CB, 0xEADE, 0xE37C, 0xDD26, 0xD9DB, 0xD78D, 0xD75E, 0xD7E5,
    0xD9CF, 0xDE60, 0xE1CA, 0xE66F, 0xEA5A, 0xEE8E, 0xF54E, 0xF947, 0xFB99, 0xFA9F, 0xF59E, 0xF274, 0xEFD0, 0xEDEE, 0xECA5, 0xEA1C,
    0xE8A5, 0xE775, 0xE8D8, 0xEA26, 0xE980, 0xEAA4, 0xEA9C, 0xED82, 0xF322, 0xF756, 0xFB7A, 0xFCA4, 0xFDF1, 0x0059, 0x04A8, 0x099C,
    0x0B93, 0x0F18, 0x12DD, 0x165F, 0x1B3B, 0x1A4C, 0x168D, 0x1579, 0x15AC, 0x15F7, 0x14CE, 0x12D8, 0x111E, 0x1098, 0x1258, 0x14DC,
    0x17D8, 0x1A4E, 0x1BF3, 0x1D86, 0x1DB0, 0x1E9F, 0x1D39, 0x178F, 0x0F88, 0x0631, 0xFD72, 0xF3E6, 0xEB9A, 0xE420, 0xDCD2, 0xD70B,
    0xCF5B, 0xC96D, 0xC5A6, 0xC152, 0xBEC6, 0xBDF3, 0xBE28, 0xBF20, 0xBF77, 0xC0C2, 0xC427, 0xC841, 0xCD3C, 0xD18C, 0xD58E, 0xD890,
    0xDC03, 0xE071, 0xE34C, 0xE69A, 0xEAFC, 0xECE4, 0xEE67, 0xF249, 0xF548, 0xFB96, 0x036E, 0x0C14, 0x16FB, 0x2009, 0x2BB5, 0x35FA,
    0x3FA4, 0x48A9, 0x4D25, 0x5096, 0x50BD, 0x4FA2, 0x4E50, 0x490D, 0x43B5, 0x3F7B, 0x3BFB, 0x39FB, 0x3553, 0x31BE, 0x2E7A, 0x2B45,
    0x294C, 0x26D8, 0x27CB, 0x28C9, 0x2819, 0x25A1, 0x1FBB, 0x1BAB, 0x1675, 0x11C1, 0x10B0, 0x0F9D, 0x115A, 0x124A, 0x10D0, 0x0D16,
    0x051B, 0xFBFE, 0xF0CC, 0xE5F9, 0xDEE7, 0xD807, 0xD2A5, 0xCE3C, 0xCB7C, 0xCB3F, 0xCB89, 0xCCCA, 0xD002, 0xD4AA, 0xDA4D, 0xDE89,
    0xE208, 0xE424, 0xE480, 0xE3E0, 0xDF5E, 0xDA6F, 0xD7A8, 0xD5CB, 0xD479, 0xD28D, 0xCF6D, 0xCD77, 0xCBE9, 0xCB1B, 0xCBE8, 0xCF36,
    0xD62E, 0xE0CA, 0xED3D, 0xF6B8, 0xFE2A, 0x0600, 0x0D7E, 0x14F7, 0x1C84, 0x23C2, 0x28C3, 0x2C27, 0x2EF0, 0x3066, 0x2E4B, 0x2B2A,
    0x2AD9, 0x2ADF, 0x2CC8, 0x2F25, 0x3138, 0x30FB, 0x3279, 0x35C9, 0x36FA, 0x383D, 0x386B, 0x3978, 0x3947, 0x3957, 0x379E, 0x3281,
    0x2C63, 0x2294, 0x1920, 0x0F86, 0x0420, 0xF9E1, 0xEEC6, 0xE578, 0xDF21, 0xD798, 0xD059, 0xCA46, 0xC57D, 0xC438, 0xC3F5, 0xC43C,
    0xC3A9, 0xC32E, 0xC5F3, 0xC7F7, 0xCB16, 0xCFBC, 0xD328, 0xD6BB, 0xDA47, 0xDF9D, 0xE3C4, 0xE5DC, 0xE77C, 0xE6FD, 0xE5F8, 0xE5D6,
    0xE618, 0xE7F2, 0xEA29, 0xEC05, 0xF08F, 0xF72C, 0x005B, 0x071E, 0x0C25, 0x13DF, 0x1969, 0x1AE1, 0x1B33, 0x1993, 0x1623, 0x1331,
    0x0F6A, 0x0A0A, 0x030F, 0xFF0D, 0xFD0D, 0xFE68, 0x0004, 0xFE3A, 0xFD61, 0xFBC9, 0xF966, 0xF7C5, 0xF942, 0xFE02, 0x01C0, 0x0676,
    0x0D92, 0x125E, 0x15BA, 0x17CA, 0x1A6D, 0x1C85, 0x1BD6, 0x1BFC, 0x1B4F, 0x192D, 0x1746, 0x13DB, 0x0FFB, 0x0BC2, 0x0911, 0x0784,
    0x0686, 0x07BC, 0x0702, 0x07A7, 0x089C, 0x0A94, 0x0F29, 0x125D, 0x1654, 0x19F9, 0x1C73, 0x1C84, 0x1964, 0x14E9, 0x0F6E, 0x0AF7,
    0x08A7, 0x0547, 0x03B4, 0x0220, 0x0034, 0xFFEA, 0xFF39, 0x00B7, 0x0252, 0x03E7, 0x0517, 0x03C7, 0x00C7, 0xF955, 0xF229, 0xF044,
    0xEE36, 0xF095, 0xF564, 0xF888, 0xFBFC, 0xFDF9, 0xFD7E, 0xF7FE, 0xF0E3, 0xEC9D, 0xE97F, 0xE4F2, 0xE2B4, 0xE2EA, 0xE419, 0xE60C,
    0xE968, 0xEE58, 0xF39F, 0xF907, 0xFF3C, 0x056C, 0x0CA1, 0x1221, 0x163E, 0x1AD3, 0x1C7C, 0x1C51, 0x19D9, 0x1356, 0x08C5, 0xFE07,
    0xF5EA, 0xEF08, 0xE875, 0xE4A5, 0xDFED, 0xDBC4, 0xD782, 0xD192, 0xCF4F, 0xCC6A, 0xCC31, 0xCE60, 0xD193, 0xD97B, 0xE433, 0xF02A,
    0xF945, 0x00B6, 0x093B, 0x0E9C, 0x11E4, 0x11DF, 0x0EB4, 0x0D39, 0x0A73, 0x07F4, 0x06FE, 0x07CB, 0x0A05, 0x0A44, 0x0A42, 0x0B9E,
    0x0DBE, 0x1089, 0x11F8, 0x161D, 0x1A62, 0x1C48, 0x1D54, 0x18AF, 0x129D, 0x08F2, 0xFD51, 0xF2AF, 0xE905, 0xE16D, 0xDC6E, 0xDB95,
    0xDB47, 0xDC66, 0xE12C, 0xE53A, 0xE7DB, 0xEE44, 0xF570, 0xFAE3, 0xFD93, 0x00DF, 0x0504, 0x0869, 0x0A4E, 0x0B1F, 0x0DB3, 0x113A,
    0x161B, 0x1D2F, 0x20AC, 0x1DD5, 0x19A7, 0x133F, 0x0C4C, 0x058F, 0x018E, 0xFFE0, 0xFFBB, 0x032D, 0x09EC, 0x1455, 0x1EA3, 0x283C,
    0x31B2, 0x3714, 0x35FA, 0x32CF, 0x2E1F, 0x2491, 0x18C8, 0x0C4F, 0x01FF, 0xF985, 0xF089, 0xE91D, 0xDEC2, 0xD471, 0xCBB7, 0xC4DA,
    0xC369, 0xC256, 0xC3D8, 0xC6BB, 0xCB47, 0xD200, 0xD5F5, 0xD92A, 0xDCC3, 0xDFAC, 0xE349, 0xE962, 0xF1C4, 0xFBA8, 0x04D0, 0x0D28,
    0x118B, 0x126D, 0x1479, 0x17D4, 0x1E2D, 0x2566, 0x2BEF, 0x3278, 0x3559, 0x3691, 0x3751, 0x38C1, 0x3BE5, 0x3F17, 0x41AB, 0x4118,
    0x3E79, 0x38E1, 0x31E7, 0x2B2A, 0x2383, 0x1B4C, 0x1487, 0x0DC2, 0x08F3, 0x081D, 0x07A7, 0x0735, 0x0625, 0x0360, 0xFDE8, 0xF746,
    0xEF9C, 0xE755, 0xE08D, 0xDA5B, 0xD401, 0xD089, 0xCEDA, 0xCEAB, 0xCD9F, 0xCBBB, 0xCAAE, 0xCA1B, 0xC9E1, 0xC9BB, 0xCD13, 0xD00E,
    0xD17E, 0xD2BC, 0xD2B3, 0xD017, 0xCBE8, 0xC9D5, 0xCB3C, 0xCFBC, 0xD60B, 0xDEBC, 0xE753, 0xEFE3, 0xF89F, 0x025B, 0x0D55, 0x15F1,
    0x2095, 0x29A5, 0x2D8D, 0x2DCA, 0x2B8B, 0x298A, 0x25DE, 0x21D4, 0x1EDC, 0x1CF2, 0x17B3, 0x107F, 0x0ADD, 0x0574, 0x01AC, 0xFFE8,
    0xFFAB, 0xFF75, 0x02CD, 0x055B, 0x06C6, 0x092F, 0x0AF0, 0x10FF, 0x17CA, 0x1F1D, 0x2457, 0x23EB, 0x1DCA, 0x1302, 0x0672, 0xFB26,
    0xF183, 0xEA69, 0xE3C5, 0xDDF0, 0xDC29, 0xD828, 0xD336, 0xD13D, 0xD229, 0xD62D, 0xDC8A, 0xE478, 0xEDFE, 0xF6A9, 0xFB64, 0xFAB3,
    0xF5A1, 0xEDE4, 0xE86D, 0xE6C5, 0xE649, 0xE602, 0xE5F9, 0xE50D, 0xE493, 0xE864, 0xF052, 0xFB50, 0x050E, 0x107B, 0x1C2B, 0x2381,
    0x2820, 0x2BA3, 0x2F40, 0x33C3, 0x38F1, 0x3F69, 0x432A, 0x41F7, 0x3E6E, 0x36DF, 0x2D3F, 0x223C, 0x1957, 0x134A, 0x0CE0, 0x082C,
    0x07A9, 0x0C1F, 0x131B, 0x1B4D, 0x277C, 0x323B, 0x39E7, 0x3F45, 0x3E08, 0x3901, 0x3046, 0x2779, 0x1F28, 0x13BE, 0x0814, 0xFCA3,
    0xF16E, 0xE49A, 0xD72A, 0xCB8F, 0xBF63, 0xB74E, 0xB339, 0xB0AF, 0xAF65, 0xAF9B, 0xB2C1, 0xB483, 0xB4FA, 0xB466, 0xB4ED, 0xB6BE,
    0xB7BC, 0xBA8B, 0xBF4F, 0xC29F, 0xC4C8, 0xC8A7, 0xCE06, 0xD5A7, 0xDF54, 0xEA87, 0xF51A, 0xFE1B, 0x069A, 0x0D63, 0x1450, 0x1AC1,
    0x220C, 0x2C1A, 0x33D7, 0x3A96, 0x417E, 0x45CE, 0x4803, 0x4902, 0x48A7, 0x461D, 0x4024, 0x3834, 0x2FF4, 0x26B4, 0x2146, 0x20C5,
    0x2442, 0x28EE, 0x2C2B, 0x2F8D, 0x2D38, 0x273A, 0x208B, 0x1929, 0x15BF, 0x12C8, 0x0ECA, 0x0C13, 0x078A, 0x0230, 0xFC68, 0xF689,
    0xF22A, 0xEE21, 0xEC04, 0xE9F2, 0xE778, 0xE719, 0xE3CD, 0xDD6D, 0xD707, 0xD037, 0xCBC6, 0xC777, 0xC3C9, 0xC1D8, 0xBF6A, 0xBEB6,
    0xBE38, 0xC09E, 0xC54C, 0xCBD4, 0xD617, 0xDF9E, 0xE862, 0xEE10, 0xF00B, 0xF129, 0xEFDD, 0xEE1E, 0xEEB7, 0xEFFD, 0xF1D8, 0xF0E9,
    0xEE06, 0xE97E, 0xE34C, 0xE0EC, 0xE076, 0xE49D, 0xEB76, 0xEF2A, 0xF270, 0xF58D, 0xFAC4, 0x03B7, 0x0F4C, 0x1D29, 0x2AE5, 0x36A6,
    0x3D28, 0x3FD4, 0x40B7, 0x3D79, 0x3921, 0x3635, 0x35F4, 0x3607, 0x354A, 0x3581, 0x34DC, 0x33C5, 0x322B, 0x31A8, 0x3410, 0x3565,
    0x36A6, 0x3A65, 0x3D1A, 0x3BF3, 0x364C, 0x2F0F, 0x26C8, 0x1C39, 0x10A5, 0x05E6, 0xFBED, 0xF066, 0xE4F9, 0xDC64, 0xD6AE, 0xD408,
    0xD48B, 0xD6F0, 0xD97B, 0xDB3F, 0xDB72, 0xDB7E, 0xDB6D, 0xDBC8, 0xDF14, 0xE366, 0xE8E9, 0xEEB5, 0xF295, 0xF5EF, 0xF6E9, 0xF654,
    0xF40D, 0xEC4F, 0xE48C, 0xDBE0, 0xD340, 0xCE2B, 0xCB5E, 0xCFC0, 0xD748, 0xE1BD, 0xEF12, 0xFBE7, 0x0852, 0x111F, 0x16E2, 0x1BA3,
    0x1D9D, 0x1ED3, 0x211D, 0x22CA, 0x230A, 0x1F5F, 0x1B99, 0x1528, 0x0B9E, 0x0400, 0xFCEE, 0xF787, 0xF1C1, 0xED64, 0xEDE2, 0xEF73,
    0xF090, 0xF18E, 0xF2FF, 0xF34C, 0xF32B, 0xF336, 0xF139, 0xEF4D, 0xEECD, 0xEDDD, 0xED37, 0xEFCD, 0xF42F, 0xF81B, 0xFB0C, 0xFBD2,
    0xFAC0, 0xFA03, 0xFA46, 0xFB8F, 0xFE4E, 0x01D8, 0x0591, 0x08A6, 0x0A1B, 0x0B1D, 0x0E2A, 0x11D8, 0x14C8, 0x1608, 0x156C, 0x1230,
    0x0AE8, 0x01CF, 0xF90D, 0xF0D2, 0xEB14, 0xEA4A, 0xED60, 0xF19C, 0xF4B8, 0xF659, 0xF440, 0xF056, 0xEC67, 0xE882, 0xE770, 0xE8B2,
    0xEAF5, 0xECDA, 0xEE14, 0xED07, 0xEC11, 0xEB04, 0xEB61, 0xED53, 0xF0E3, 0xF6D6, 0xF8E0, 0xF8FE, 0xF5BB, 0xF2BB, 0xF1C2, 0xF022,
    0xF13B, 0xF14C, 0xF222, 0xF422, 0xF640, 0xF9A6, 0xFBF8, 0x02FA, 0x0D79, 0x172C, 0x21F5, 0x2991, 0x30C0, 0x3573, 0x36A1, 0x3874,
    0x371F, 0x3625, 0x34D0, 0x3283, 0x2F36, 0x2872, 0x2308, 0x1CD7, 0x1538, 0x0D5F, 0x02A5, 0xF85C, 0xEC53, 0xE08A, 0xD94A, 0xD40D,
    0xD2D5, 0xD546, 0xDB41, 0xE2B0, 0xE94C, 0xF060, 0xF4DC, 0xF7A6, 0xF8A1, 0xF724, 0xF5DE, 0xF5AD, 0xF607, 0xF685, 0xF6FC, 0xF46E,
    0xF200, 0xF20B, 0xF34A, 0xF72E, 0xFB01, 0x0095, 0x08DC, 0x0F33, 0x1348, 0x160F, 0x1959, 0x1A14, 0x17A6, 0x146A, 0x0D49, 0x04B1,
    0xFA40, 0xEFFE, 0xE995, 0xE46B, 0xE2ED, 0xE3C9, 0xE616, 0xE971, 0xEB55, 0xF1B8, 0xF768, 0xFC12, 0x0276, 0x0972, 0x130A, 0x1758,
    0x1C08, 0x2200, 0x25D9, 0x2A4E, 0x2BC8, 0x2DF3, 0x2DA4, 0x28E2, 0x20B0, 0x13B9, 0x06D2, 0xFA75, 0xF132, 0xEE33, 0xEE17, 0xF163,
    0xF63B, 0xF931, 0xFAA9, 0xFAC7, 0xFC05, 0xFCD6, 0xFD1C, 0xFDAC, 0xFE1C, 0xFE44, 0xFBB0, 0xF6DE, 0xEE6F, 0xE561, 0xDE76, 0xD96A,
    0xD736, 0xD4EA, 0xD400, 0xD149, 0xCD4C, 0xCD58, 0xCF56, 0xD512, 0xDA8B, 0xE014, 0xE3F2, 0xE40B, 0xE37C, 0xE0AD, 0xE046, 0xE0B7,
    0xE296, 0xE836, 0xEEAD, 0xF4E2, 0xF98B, 0xFD38, 0x01ED, 0x070A, 0x0DE8, 0x1244, 0x15A2, 0x1A28, 0x1CF2, 0x2372, 0x297E, 0x2FEA,
    0x37BC, 0x3CEC, 0x422B, 0x449F, 0x437C, 0x3D99, 0x335F, 0x2A0E, 0x1E4D, 0x172F, 0x149E, 0x11A4, 0x1291, 0x12F3, 0x14F1, 0x149C,
    0x0FD5, 0x0B41, 0x0468, 0x000B, 0xFC66, 0xF8DC, 0xF4BE, 0xED35, 0xE82E, 0xE2B6, 0xDF01, 0xDEA6, 0xDF78, 0xE374, 0xE718, 0xEA4B,
    0xECA8, 0xEE41, 0xF115, 0xF2CE, 0xF5E0, 0xF709, 0xF3EF, 0xF0DD, 0xEA34, 0xE4A9, 0xE2B7, 0xE315, 0xE595, 0xE9AF, 0xF0FA, 0xF989,
    0x01E9, 0x0AC6, 0x136B, 0x1D14, 0x2507, 0x2B28, 0x2F44, 0x2FF6, 0x2EED, 0x2CB7, 0x2C15, 0x29CE, 0x28A8, 0x26C4, 0x226F, 0x1DC1,
    0x152A, 0x0BD6, 0x021D, 0xF7B5, 0xEFF5, 0xEB69, 0xEAF7, 0xECB4, 0xF03E, 0xF6B2, 0xFA8B, 0xFCFA, 0xFDA3, 0xFEE5, 0x025C, 0x02A9,
    0x03B1, 0x054D, 0x0550, 0x0315, 0xFDAB, 0xF8E9, 0xF4A9, 0xF27C, 0xF24B, 0xF238, 0xF3D8, 0xF32E, 0xF3A5, 0xF6C5, 0xFA68, 0x008B,
    0x0790, 0x0D8A, 0x0FEB, 0x0D77, 0x0866, 0xFF4C, 0xF566, 0xECED, 0xE780, 0xE532, 0xE34A, 0xE231, 0xDFB7, 0xDD32, 0xDBAA, 0xDD3B,
    0xDFF7, 0xE446, 0xE9BE, 0xED91, 0xF0CA, 0xF540, 0xFB47, 0x00E3, 0x0A29, 0x14E6, 0x1E5A, 0x2552, 0x2750, 0x23B3, 0x1BDB, 0x1059,
    0x04E3, 0xFBA9, 0xF4DD, 0xF494, 0xF8C9, 0xFE5A, 0x02A3, 0x06B0, 0x0B44, 0x0DFC, 0x12E0, 0x194A, 0x2054, 0x280E, 0x2B3C, 0x2B58,
    0x2744, 0x201C, 0x18DE, 0x0FEA, 0x0666, 0xFBA1, 0xF43A, 0xED01, 0xE271, 0xDA4A, 0xD29D, 0xCD58, 0xCA9F, 0xC763, 0xC55D, 0xC322,
    0xC045, 0xBD2B, 0xBB3C, 0xBA5D, 0xB9EC, 0xBBD5, 0xBDC1, 0xC0F5, 0xC761, 0xCDAA, 0xD52F, 0xDDAF, 0xE53A, 0xED2B, 0xF49B, 0xFBBE,
    0x01A3, 0x077B, 0x0E33, 0x1676, 0x20F4, 0x2943, 0x319A, 0x3B4C, 0x437C, 0x49EF, 0x4F22, 0x52B3, 0x54C5, 0x56B0, 0x5440, 0x4EF4,
    0x4B5D, 0x4611, 0x4314, 0x4063, 0x3A71, 0x35D2, 0x3180, 0x2D7E, 0x26FE, 0x2215, 0x1EB5, 0x1A68, 0x1742, 0x113D, 0x0CA9, 0x0A4F,
    0x06D9, 0x0475, 0x0223, 0xFF17, 0xFC7E, 0xF9D3, 0xF8AC, 0xF7FD, 0xFA73, 0xFB5A, 0xF858, 0xF533, 0xED16, 0xE476, 0xDB35, 0xD2CA,
    0xCEF2, 0xCBCA, 0xC887, 0xC4A7, 0xC2DB, 0xC2BE, 0xC45C, 0xC96C, 0xCF54, 0xD694, 0xDE08, 0xE324, 0xE713, 0xE9D9, 0xEBC5, 0xEEF7,
    0xF266, 0xF614, 0xFBAB, 0x01EB, 0x0595, 0x0481, 0x0016, 0xF7BF, 0xEF41, 0xE9F8, 0xE726, 0xE82A, 0xED44, 0xF3E1, 0xF9DE, 0xFF6E,
    0x03BE, 0x088A, 0x0EC9, 0x1536, 0x1CFF, 0x2302, 0x2584, 0x2632, 0x253D, 0x2198, 0x1C19, 0x189E, 0x1498, 0x1103, 0x0EB2, 0x0BA4,
    0x0A8B, 0x09E8, 0x0B07, 0x0F78, 0x1543, 0x1C23, 0x2307, 0x292C, 0x2B66, 0x29F2, 0x2721, 0x2029, 0x16F4, 0x0DB9, 0x03A5, 0xFB50,
    0xF371, 0xEC8F, 0xE7DB, 0xE364, 0xDFD4, 0xDD55, 0xDC9C, 0xDA62, 0xD6F8, 0xD5DA, 0xD4F7, 0xD508, 0xD863, 0xDD7B, 0xE587, 0xEE8E,
    0xF677, 0xFD2A, 0x00D7, 0xFFD1, 0xF9A2, 0xF0D4, 0xE7A1, 0xE100, 0xDCFA, 0xDA68, 0xD9F2, 0xDBE9, 0xDDF7, 0xE120, 0xE7BD, 0xEE7F,
    0xF6FA, 0x028B, 0x0D47, 0x183C, 0x21D7, 0x2913, 0x2EFA, 0x3274, 0x338B, 0x31BE, 0x2F8C, 0x294A, 0x2140, 0x1B40, 0x1454, 0x0F7A,
    0x0CEE, 0x0A0E, 0x08C9, 0x07F5, 0x0719, 0x0828, 0x094D, 0x09CC, 0x0A8B, 0x0CB1, 0x0C0E, 0x0A15, 0x0917, 0x05CF, 0x050B, 0x05DA,
    0x06B6, 0x096D, 0x0BF3, 0x0DE4, 0x0D90, 0x0C6F, 0x0903, 0x045F, 0x03FF, 0x0474, 0x09F5, 0x12C7, 0x1942, 0x1FAF, 0x2315, 0x22DE,
    0x201B, 0x1B64, 0x1500, 0x0F2E, 0x0BCA, 0x0673, 0x0037, 0xFAF8, 0xF3C3, 0xEE2A, 0xEAF1, 0xE73E, 0xE56B, 0xE30B, 0xDFE2, 0xDC1F,
    0xD91A, 0xD682, 0xD464, 0xD57A, 0xD58A, 0xD764, 0xD972, 0xD9D5, 0xDBAF, 0xDCD9, 0xDEAD, 0xE262, 0xE876, 0xEF43, 0xF657, 0xFD86,
    0x00DF, 0x02BE, 0x0353, 0x00F2, 0xFFD0, 0xFE45, 0xFB62, 0xF85B, 0xF748, 0xF824, 0xFA95, 0x0044, 0x0578, 0x0D6D, 0x1824, 0x2051,
    0x28AD, 0x2CBD, 0x2C9B, 0x2C05, 0x2963, 0x27F1, 0x27F2, 0x2AB0, 0x2C05, 0x2A93, 0x2743, 0x1DB6, 0x1296, 0x04F8, 0xF532, 0xE9B8,
    0xE132, 0xDB5A, 0xD80B, 0xD572, 0xD3A5, 0xD2CB, 0xD48D, 0xD491, 0xD58D, 0xD9E7, 0xDD3A, 0xE175, 0xE460, 0xE68F, 0xE888, 0xE860,
    0xE74A, 0xE4F5, 0xE2DD, 0xDF2A, 0xDB91, 0xD968, 0xD73A, 0xDA4D, 0xE057, 0xE75D, 0xF0FF, 0xFA88, 0x0235, 0x09DF, 0x1234, 0x1808,
    0x1B29, 0x1B3E, 0x1828, 0x13B5, 0x0CD4, 0x0451, 0xFEF5, 0xFABD, 0xF726, 0xF5F3, 0xF584, 0xF603, 0xF7A9, 0xFA8E, 0xFA5D, 0xF9B2,
    0xFBA8, 0xFFEA, 0x099B, 0x14B0, 0x20B5, 0x2D02, 0x37C2, 0x3DE6, 0x3F9B, 0x3F76, 0x3AC0, 0x3613, 0x3137, 0x2A92, 0x256C, 0x1FB4,
    0x1891, 0x11FF, 0x0D89, 0x0AD2, 0x0A35, 0x0B95, 0x0BEB, 0x0BE9, 0x0D63, 0x0CDB, 0x0D76, 0x0F47, 0x1062, 0x11EB, 0x0F47, 0x08F4,
    0x0094, 0xF7A0, 0xED4D, 0xE383, 0xDD64, 0xD821, 0xD488, 0xD172, 0xCDA6, 0xCBFF, 0xCAC1, 0xCA13, 0xCC11, 0xCE11, 0xCDDD, 0xCE0F,
    0xCE6F, 0xCC58, 0xCB72, 0xCC96, 0xCEC5, 0xD47C, 0xDCC8, 0xE4C0, 0xEC09, 0xF0EC, 0xF21D, 0xF2C6, 0xF279, 0xF0D5, 0xF3F0, 0xFD3C,
    0x0882, 0x16DA, 0x2533, 0x30B7, 0x3AC3, 0x419E, 0x4649, 0x4A45, 0x4D8C, 0x4DDA, 0x4DFE, 0x4CDF, 0x46E7, 0x412D, 0x3BB0, 0x3690,
    0x334C, 0x304C, 0x2D52, 0x2A61, 0x269B, 0x206A, 0x1B05, 0x15C4, 0x0E42, 0x09AA, 0x0569, 0xFE35, 0xF638, 0xED36, 0xE47A, 0xDD37,
    0xD773, 0xD365, 0xD242, 0xD343, 0xD29D, 0xD3AA, 0xD4C9, 0xD384, 0xD50D, 0xD58A, 0xD469, 0xD3E4, 0xD209, 0xCFA0, 0xCCF6, 0xCB2D,
    0xCB0B, 0xCEA3, 0xD523, 0xDCB9, 0xE717, 0xEF5E, 0xF4A2, 0xF9B3, 0xFCE2, 0xFF43, 0x0322, 0x0823, 0x0E53, 0x15B2, 0x1BA7, 0x1F08,
    0x2180, 0x21F2, 0x1DFA, 0x190F, 0x1233, 0x09C4, 0x02DD, 0xFBF1, 0xF536, 0xF01B, 0xEF2E, 0xEF38, 0xF1B9, 0xF5E2, 0xF936, 0xFE42,
    0x016B, 0x03F3, 0x075D, 0x0C6E, 0x1205, 0x1668, 0x1892, 0x16A9, 0x135A, 0x0E29, 0x0732, 0x026E, 0x002E, 0xFEF8, 0x00B7, 0x0461,
    0x08CE, 0x0D93, 0x11BB, 0x15DA, 0x1AD2, 0x1FD8, 0x219E, 0x2284, 0x2089, 0x1A21, 0x12A6, 0x099B, 0x0215, 0xFEE8, 0xFE64, 0xFEEA,
    0xFED6, 0xFB86, 0xF43E, 0xED3C, 0xE72F, 0xE1BD, 0xE1D6, 0xE684, 0xEDFE, 0xF946, 0x05B3, 0x0FF2, 0x1821, 0x1EB5, 0x22B6, 0x25C4,
    0x272B, 0x259A, 0x23F3, 0x20DB, 0x1B64, 0x169E, 0x108B, 0x0A1C, 0x071D, 0x047F, 0x018E, 0xFFE4, 0xFFF9, 0x0132, 0x0452, 0x08F5,
    0x0E25, 0x167D, 0x1D77, 0x1F50, 0x2022, 0x1E6C, 0x1898, 0x121D, 0x0A37, 0x0212, 0xFBF6, 0xF648, 0xF08F, 0xEC6F, 0xE775, 0xE0E4,
    0xDD19, 0xDA96, 0xD8B7, 0xD893, 0xD6FA, 0xD291, 0xCEEC, 0xCB57, 0xC729, 0xC602, 0xC64A, 0xC958, 0xCF90, 0xD47E, 0xD7C7, 0xDA84,
    0xDAEA, 0xD8B0, 0xD84E, 0xD99D, 0xDCDA, 0xE45B, 0xECD9, 0xF54D, 0xFF04, 0x07DB, 0x1014, 0x18C7, 0x1F34, 0x2448, 0x2894, 0x2A65,
    0x297F, 0x299F, 0x29AC, 0x27B5, 0x280C, 0x2741, 0x24B4, 0x2284, 0x1F9F, 0x1E07, 0x1D0A, 0x1B93, 0x1927, 0x1765, 0x14BF, 0x10BA,
    0x0DF9, 0x0874, 0x026B, 0xFFD1, 0xFD48, 0xFA49, 0xF833, 0xF749, 0xF6E8, 0xF7C6, 0xF930, 0xFA0E, 0xFC49, 0xFCBC, 0xFC21, 0xFC40,
    0xF9C4, 0xF402, 0xED16, 0xE54D, 0xDCB0, 0xD6B4, 0xD400, 0xD317, 0xD519, 0xD79B, 0xD88F, 0xD9C2, 0xD7EB, 0xD6A1, 0xD935, 0xDD0A,
    0xE228, 0xEA0B, 0xF386, 0xFA74, 0x016A, 0x0626, 0x0962, 0x0E83, 0x1003, 0x0F72, 0x0CBC, 0x06C5, 0x00B7, 0xFB26, 0xF61F, 0xF2A5,
    0xF421, 0xF84A, 0xFA7D, 0xFEFB, 0x0343, 0x06D4, 0x0D2E, 0x1342, 0x1C50, 0x2592, 0x2C88, 0x3154, 0x3404, 0x3539, 0x315F, 0x2D87,
    0x280C, 0x1FC1, 0x1C4F, 0x198B, 0x1791, 0x1796, 0x180C, 0x1B3E, 0x20D6, 0x2734, 0x2E55, 0x3677, 0x3B54, 0x3B6F, 0x3A31, 0x333C,
    0x27D9, 0x1E5E, 0x1692, 0x10A4, 0x0C8D, 0x0846, 0x0206, 0xF8EF, 0xEBDE, 0xDE19, 0xD314, 0xC9F5, 0xC4E0, 0xC522, 0xC67A, 0xC8A0,
    0xCCE9, 0xD160, 0xD593, 0xDABF, 0xE0BD, 0xE4C0, 0xE790, 0xE63A, 0xE3BB, 0xE3FD, 0xE2FA, 0xE1E3, 0xE0FD, 0xDED6, 0xDD1A, 0xDD71,
    0xDE9C, 0xDFB5, 0xE306, 0xE82A, 0xEE11, 0xF843, 0x02C8, 0x0DA7, 0x19CF, 0x2211, 0x29AA, 0x2F12, 0x3029, 0x2E99, 0x2CDE, 0x2A31,
    0x249D, 0x1FF4, 0x19F2, 0x1335, 0x0EF7, 0x0883, 0x0249, 0xFEDE, 0xFB55, 0xF7A3, 0xF428, 0xEF09, 0xE8C4, 0xE45C, 0xE1E4, 0xE267,
    0xE7D9, 0xEE77, 0xF483, 0xFB1D, 0xFD14, 0xFC85, 0xFD90, 0xFCD0, 0xFB5D, 0xFB31, 0xFB53, 0xFB52, 0xFC7B, 0xFF28, 0x03D4, 0x0A6E,
    0x0FCB, 0x154F, 0x1AFA, 0x1B53, 0x19E1, 0x1959, 0x1753, 0x14B3, 0x12F9, 0x0FEB, 0x0B9E, 0x06F5, 0x0170, 0xFB61, 0xF54D, 0xF032,
    0xEC34, 0xEAE5, 0xE886, 0xE6B4, 0xE6F2, 0xE3C5, 0xE088, 0xDF0C, 0xDE03, 0xDDDE, 0xDF4A, 0xE116, 0xE396, 0xE63A, 0xE7AF, 0xE8FD,
    0xED31, 0xF373, 0xFAE9, 0x0609, 0x0F6A, 0x1678, 0x1AE4, 0x18E9, 0x14B3, 0x10B7, 0x0E21, 0x0E62, 0x1063, 0x1272, 0x14A6, 0x1768,
    0x1831, 0x177D, 0x192D, 0x1B31, 0x1E59, 0x2444, 0x28E8, 0x2DE2, 0x3229, 0x33D6, 0x3448, 0x3603, 0x37AE, 0x3841, 0x37A6, 0x33C1,
    0x2C4D, 0x21FE, 0x154A, 0x090B, 0xFF69, 0xF59A, 0xEDDA, 0xE81B, 0xE170, 0xDB13, 0xD6D8, 0xD39C, 0xD298, 0xD5F3, 0xDA31, 0xDE67,
    0xE0E4, 0xE10F, 0xE0D8, 0xE03B, 0xDDC6, 0xDA30, 0xD76D, 0xD379, 0xD0CB, 0xCF91, 0xCDD6, 0xCDFD, 0xD065, 0xD59D, 0xDE83, 0xEAA6,
    0xF6DC, 0x0080, 0x09DA, 0x0ED8, 0x0F7E, 0x1121, 0x11AC, 0x1396, 0x16DD, 0x1983, 0x1CC1, 0x1DAD, 0x1B12, 0x160E, 0x1031, 0x0815,
    0x004F, 0xFCDA, 0xF9BB, 0xF7F3, 0xFADA, 0xFF19, 0x058E, 0x0F30, 0x18CF, 0x2343, 0x2B81, 0x2FCA, 0x3176, 0x31AD, 0x2EF5, 0x29AA,
    0x265B, 0x2102, 0x1A92, 0x14DC, 0x0BA0, 0x01B0, 0xF921, 0xF181, 0xECE6, 0xEB82, 0xEC0B, 0xEE34, 0xF1BB, 0xF507, 0xF7DB, 0xFD24,
    0x0092, 0x02C2, 0x067D, 0x05B3, 0x0268, 0xFBA1, 0xF0AA, 0xE67E, 0xDE4F, 0xD80F, 0xD473, 0xD4AD, 0xD57F, 0xD5C8, 0xD57E, 0xD201,
    0xCD6E, 0xC950, 0xC4C9, 0xC33E, 0xC5D4, 0xC90B, 0xCDCD, 0xD381, 0xD6EB, 0xDA7E, 0xDEC3, 0xE15E, 0xE2C6, 0xE49E, 0xE55E, 0xE5E6,
    0xE770, 0xE8E4, 0xEE1B, 0xF77B, 0x00D2, 0x0A9F, 0x169C, 0x20D3, 0x2976, 0x3141, 0x367D, 0x3B63, 0x4025, 0x4436, 0x4864, 0x4B76,
    0x4BB3, 0x4A31, 0x47DC, 0x41E8, 0x3CE9, 0x3B01, 0x379B, 0x34D2, 0x332E, 0x308A, 0x2C3F, 0x2685, 0x1F7D, 0x1A23, 0x161C, 0x119A,
    0x0D4E, 0x0858, 0x00A9, 0xF8A5, 0xF229, 0xEB4A, 0xE817, 0xE7E0, 0xE873, 0xEA1D, 0xEB82, 0xEADF, 0xE88F, 0xE518, 0xDFF9, 0xDB4F,
    0xD89D, 0xD66D, 0xD56F, 0xD6C0, 0xD721, 0xD78E, 0xD842, 0xD8F3, 0xDAF4, 0xDD6A, 0xDF9D, 0xE1D0, 0xE6A2, 0xEC71, 0xF282, 0xF9BB,
    0xFF1A, 0x0503, 0x0BD3, 0x102F, 0x1410, 0x1627, 0x1526, 0x12F0, 0x101A, 0x0C04, 0x0821, 0x04A7, 0xFE73, 0xF766, 0xF32E, 0xEFBB,
    0xECF1, 0xEDA1, 0xF0E1, 0xF86D, 0x013B, 0x0953, 0x11D7, 0x1888, 0x1CD4, 0x1FA9, 0x22ED, 0x2317, 0x20A7, 0x1D20, 0x16ED, 0x1023,
    0x0984, 0x022E, 0xFF64, 0x023F, 0x0674, 0x0CAB, 0x1137, 0x10F2, 0x0F83, 0x0DF9, 0x0A40, 0x0579, 0x01E0, 0xFDFF, 0xFA31, 0xF64C,
    0xF01C, 0xEADA, 0xE6FA, 0xE1C5, 0xDBE6, 0xD558, 0xCE6B, 0xC8B9, 0xC445, 0xC152, 0xC1B4, 0xC466, 0xC981, 0xD116, 0xDA4F, 0xE392,
    0xED7F, 0xF79C, 0xFE2E, 0x047F, 0x0A4A, 0x0D7F, 0x117D, 0x14A3, 0x1424, 0x1183, 0x0DB6, 0x08FA, 0x04A4, 0x0141, 0xFE04, 0xFD8F,
    0xFF69, 0x0067, 0x0252, 0x04D4, 0x0833, 0x0F1E, 0x1876, 0x2114, 0x2916, 0x2E7D, 0x2E3F, 0x2A35, 0x22B1, 0x199F, 0x12E1, 0x0F4A,
    0x0DB4, 0x0D08, 0x0D8A, 0x0B99, 0x05F3, 0xFF1E, 0xF6F4, 0xF07C, 0xEB12, 0xE67A, 0xE50C, 0xE4CF, 0xE51F, 0xE695, 0xE7E2, 0xE74E,
    0xE815, 0xE91E, 0xE763, 0xE5AB, 0xE39E, 0xE189, 0xE0F5, 0xE325, 0xE72A, 0xEC93, 0xF3D0, 0xFA52, 0x0185, 0x093F, 0x0E24, 0x13DE,
    0x1A53, 0x1FAF, 0x26EC, 0x2C57, 0x3033, 0x3468, 0x36AC, 0x3776, 0x3633, 0x343F, 0x31D2, 0x301E, 0x2F80, 0x2CFD, 0x2B75, 0x29B3,
    0x2520, 0x221E, 0x1F53, 0x1BF8, 0x18F7, 0x1322, 0x0B3B, 0x031A, 0xFA82, 0xF261, 0xECD7, 0xEB7F, 0xECC2, 0xEF57, 0xF2FD, 0xF41A,
    0xF4D8, 0xF4FE, 0xF291, 0xF0DE, 0xEEF5, 0xEBA1, 0xE919, 0xE66D, 0xE3C4, 0xE2C3, 0xE265, 0xE1E8, 0xE1BA, 0xE28E, 0xE1F3, 0xE0F0,
    0xDF8F, 0xDD4A, 0xDE09, 0xE0A5, 0xE507, 0xEA94, 0xF021, 0xF518, 0xF972, 0xFD59, 0xFFF4, 0x036F, 0x04FF, 0x0338, 0x027E, 0x0100,
    0xFC42, 0xF676, 0xEF27, 0xE6D4, 0xE07C, 0xDBF6, 0xD88B, 0xD877, 0xDBA6, 0xDF8B, 0xE409, 0xE9BE, 0xEF3B, 0xF6F7, 0xFF6A, 0x07CD,
    0x11A9, 0x18D5, 0x1C76, 0x1BDA, 0x17F4, 0x129A, 0x0E57, 0x0D5D, 0x0E4F, 0x1221, 0x15E1, 0x177F, 0x198F, 0x1BA8, 0x1CD2, 0x1F5E,
    0x2235, 0x2415, 0x26A4, 0x280B, 0x2932, 0x2929, 0x2749, 0x24E1, 0x2060, 0x1ACA, 0x12E8, 0x09A9, 0xFEBC, 0xF069, 0xE420, 0xDA68,
    0xD2BD, 0xD059, 0xCF88, 0xD051, 0xD4A3, 0xD7E2, 0xDB4C, 0xDEAE, 0xE232, 0xE795, 0xED08, 0xF3DE, 0xF6F6, 0xF78D, 0xF767, 0xF3DA,
    0xF102, 0xEE89, 0xEBE7, 0xEB0E, 0xEA91, 0xE9FD, 0xEB69, 0xEDA1, 0xF09D, 0xF5EA, 0xFE24, 0x0899, 0x162A, 0x24BE, 0x2E45, 0x3539,
    0x37D2, 0x35E7, 0x334F, 0x302B, 0x2D72, 0x2D0A, 0x2DE6, 0x2DA4, 0x2D8D, 0x2A8E, 0x246F, 0x1D51, 0x1558, 0x0C92, 0x03A4, 0xFCE7,
    0xF852, 0xF5ED, 0xF5C6, 0xF761, 0xFA76, 0xFD8A, 0xFF86, 0x01BF, 0x0206, 0xFEB8, 0xFADF, 0xF6F6, 0xF2F7, 0xF107, 0xF031, 0xEF52,
    0xF00F, 0xF0E0, 0xF099, 0xF1E1, 0xF3BA, 0xF5D1, 0xF9F7, 0xFEBD, 0x0203, 0x04CE, 0x0769, 0x058D, 0x0290, 0x003A, 0xFE71, 0xFE1F,
    0xFBA8, 0xF83D, 0xF50D, 0xF121, 0xED83, 0xEBA4, 0xEB11, 0xEC76, 0xEFA4, 0xF284, 0xF288, 0xF0F2, 0xEEAF, 0xEA12, 0xE6E0, 0xE4E7,
    0xE4AB, 0xE857, 0xECFC, 0xF3DD, 0xFBE6, 0x00F5, 0x04F4, 0x0847, 0x0C6C, 0x0F02, 0x1096, 0x1311, 0x113B, 0x0EE7, 0x0D2E, 0x0A72,
    0x08FB, 0x0613, 0x0257, 0xFFC5, 0xFAC8, 0xF62B, 0xF31A, 0xF1F4, 0xF2EE, 0xF651, 0xFDF0, 0x059C, 0x0DC5, 0x1457, 0x1771, 0x1C35,
    0x1F72, 0x2208, 0x258D, 0x26B8, 0x2640, 0x22F0, 0x1BC8, 0x121E, 0x085C, 0xFDF8, 0xF36B, 0xEBB9, 0xE684, 0xE190, 0xDC3B, 0xD718,
    0xD269, 0xD1E1, 0xD4CB, 0xD91E, 0xDFE4, 0xE575, 0xE879, 0xE999, 0xE699, 0xE0EF, 0xDC95, 0xD761, 0xD306, 0xD1B2, 0xD341, 0xD647,
    0xDA1B, 0xDED5, 0xE2A8, 0xE83E, 0xEE40, 0xF3DB, 0xFAAC, 0x0276, 0x0A31, 0x1238, 0x1A10, 0x215B, 0x295C, 0x2FAB, 0x3433, 0x371B,
    0x35C3, 0x30E8, 0x299A, 0x1FE1, 0x16CF, 0x0F45, 0x099B, 0x065E, 0x0557, 0x07E7, 0x0AA5, 0x0EBB, 0x1345, 0x175E, 0x1F08, 0x2650,
    0x2BE0, 0x3073, 0x332A, 0x3461, 0x33A9, 0x304F, 0x2CC8, 0x29C2, 0x25C1, 0x1FF9, 0x198D, 0x1221, 0x08E6, 0x02B4, 0xFEA4, 0xFE01,
    0x022F, 0x0723, 0x0D1F, 0x11C6, 0x13A4, 0x136B, 0x1025, 0x0AF8, 0x0562, 0xFF6B, 0xF9BA, 0xF334, 0xED17, 0xE7C9, 0xE170, 0xDC90,
    0xD656, 0xD05B, 0xCB27, 0xC404, 0xBF2C, 0xBBD5, 0xBA6C, 0xBA4A, 0xBC76, 0xC197, 0xC6C5, 0xCC25, 0xD081, 0xD31A, 0xD707, 0xD929,
    0xDA54, 0xDDDE, 0xE03B, 0xE2DF, 0xE68E, 0xEB2B, 0xEFCE, 0xF80C, 0x0072, 0x06A4, 0x0F42, 0x182E, 0x22C6, 0x2C29, 0x31F4, 0x35F8,
    0x3998, 0x3C6C, 0x3F53, 0x439A, 0x473A, 0x4881, 0x470C, 0x43B1, 0x3E27, 0x37A1, 0x30C0, 0x2B79, 0x2919, 0x2784, 0x2653, 0x23D7,
    0x1F15, 0x1705, 0x0DCC, 0x04E9, 0xFCA3, 0xF614, 0xF014, 0xEC56, 0xEA83, 0xE9CB, 0xE994, 0xEA14, 0xE8E8, 0xE795, 0xE720, 0xE3C6,
    0xE07A, 0xDC4B, 0xD8B2, 0xD7D2, 0xD72A, 0xD6C4, 0xD6C6, 0xD734, 0xD703, 0xD5A0, 0xD43D, 0xD274, 0xD0A3, 0xD159, 0xD2DE, 0xD607,
    0xDBE7, 0xE134, 0xE761, 0xEC4B, 0xF08C, 0xF5B3, 0xFAB9, 0x01BC, 0x08A7, 0x0F55, 0x13B6, 0x148D, 0x13F8, 0x1236, 0x0F83, 0x0E81,
    0x0C00, 0x082C, 0x054C, 0xFF94, 0xFB92, 0xF89B, 0xF8D5, 0xFDFE, 0x054F, 0x0EEB, 0x1990, 0x24A3, 0x2B3F, 0x2F41, 0x3204, 0x3186,
    0x2F38, 0x2C45, 0x28FE, 0x277F, 0x2659, 0x2454, 0x23B7, 0x21DA, 0x2183, 0x20F9, 0x2044, 0x1EF0, 0x1B0A, 0x1990, 0x1712, 0x1615,
    0x16E2, 0x17B1, 0x1920, 0x18F9, 0x14FD, 0x0F58, 0x095C, 0x0146, 0xF7EE, 0xED68, 0xE439, 0xDC4D, 0xD7AA, 0xD25A, 0xCE1A, 0xCD37,
    0xCA95, 0xCB64, 0xCEB2, 0xD3AC, 0xD8D3, 0xDDEA, 0xE2F8, 0xE770, 0xED09, 0xF288, 0xF932, 0xFED9, 0x038F, 0x05B7, 0x04C1, 0x0110,
    0xFE83, 0xFC0F, 0xF6C8, 0xF4B8, 0xF662, 0xFB68, 0x0148, 0x0879, 0x0F2B, 0x1518, 0x1AB9, 0x1ED7, 0x22D7, 0x2600, 0x27C3, 0x28D1,
    0x2BAB, 0x2DEC, 0x2E22, 0x2E0B, 0x2C45, 0x2A44, 0x26FC, 0x2147, 0x19B7, 0x101D, 0x049F, 0xFAE6, 0xF423, 0xEC09, 0xE862, 0xE965,
    0xE9D4, 0xEB24, 0xE906, 0xE38A, 0xDEC7, 0xD971, 0xD68F, 0xD39B, 0xCFF0, 0xCD87, 0xC9C1, 0xC7D9, 0xC6C9, 0xC69A, 0xC941, 0xCD1A,
    0xD2FC, 0xDA71, 0xE14B, 0xE714, 0xEBEE, 0xF1AC, 0xF94E, 0x01B8, 0x0AEF, 0x14B1, 0x1D10, 0x21E7, 0x240D, 0x2522, 0x22F0, 0x2228,
    0x2386, 0x24C8, 0x27C8, 0x29F9, 0x2BBB, 0x2B89, 0x28EE, 0x2639, 0x22FC, 0x1DA6, 0x1738, 0x1110, 0x0CA5, 0x080F, 0x055A, 0x057E,
    0x03F5, 0x03D7, 0x0541, 0x0726, 0x08F7, 0x0877, 0x06B8, 0x0469, 0x02F3, 0x0227, 0x0200, 0x01B9, 0x0195, 0x0144, 0xFF58, 0xFAD1,
    0xF61C, 0xF27F, 0xEF8A, 0xEF5B, 0xF000, 0xF160, 0xF335, 0xF463, 0xF512, 0xF7B5, 0xFB94, 0xFF0C, 0x03B4, 0x0738, 0x098D, 0x0C8E,
    0x0D17, 0x0C79, 0x0C36, 0x0AD4, 0x088B, 0x0510, 0xFF6D, 0xF88E, 0xF223, 0xEAA6, 0xE375, 0xDFE8, 0xE024, 0xE20B, 0xE5FB, 0xEC4A,
    0xF52C, 0xFE26, 0x0609, 0x0C83, 0x11D7, 0x16C9, 0x19A0, 0x1C34, 0x1D60, 0x1BBC, 0x1A72, 0x187F, 0x169B, 0x17AE, 0x1945, 0x18F3,
    0x188F, 0x15CF, 0x122A, 0x10E2, 0x0F10, 0x101A, 0x1578, 0x1CB3, 0x2363, 0x27D0, 0x2977, 0x28B4, 0x25A0, 0x215A, 0x1B93, 0x1574,
    0x0EDE, 0x04FB, 0xFBC9, 0xF126, 0xE6F7, 0xDFFB, 0xDAB0, 0xD975, 0xDA3E, 0xDBF2, 0xDEB6, 0xE1B3, 0xE46D, 0xE6CE, 0xEB14, 0xF034,
    0xF570, 0xFBA5, 0xFF6F, 0xFEAF, 0xFADF, 0xF485, 0xEDA4, 0xE7A7, 0xE1CA, 0xDD4B, 0xDBF8, 0xDE69, 0xE121, 0xE4A5, 0xE94E, 0xEE24,
    0xF47C, 0xFA1E, 0xFF09, 0x041B, 0x0782, 0x0AF2, 0x0F7E, 0x1263, 0x156C, 0x195A, 0x1C9B, 0x1FDC, 0x2133, 0x1F58, 0x1AD6, 0x144E,
    0x0CE7, 0x057B, 0x0003, 0xFDA5, 0xFC29, 0xFB73, 0xFB87, 0xF9BD, 0xF8F6, 0xF7E0, 0xF642, 0xF6BA, 0xF67D, 0xF747, 0xF837, 0xF6F5,
    0xF514, 0xF287, 0xF0AC, 0xF005, 0xF1FD, 0xF324, 0xF37F, 0xF598, 0xF6AD, 0xF6EF, 0xF848, 0xFC54, 0x0159, 0x0738, 0x0D40, 0x1344,
    0x1682, 0x1673, 0x15CE, 0x1420, 0x115D, 0x0E1B, 0x0C11, 0x0A86, 0x0970, 0x0961, 0x0A8A, 0x0B2B, 0x0ACA, 0x0995, 0x0743, 0x04FA,
    0x0086, 0xFBE1, 0xF94F, 0xF772, 0xF771, 0xF90D, 0xFC0A, 0xFE9C, 0x0241, 0x0644, 0x07B1, 0x0875, 0x0972, 0x0ABA, 0x0DEB, 0x10CE,
    0x1331, 0x16E8, 0x1749, 0x15F7, 0x1434, 0x10A2, 0x0E5B, 0x0C5D, 0x09A9, 0x07BA, 0x03C4, 0xFD6F, 0xFA94, 0xFA03, 0xFB45, 0xFF3F,
    0x0614, 0x0DE0, 0x1283, 0x159C, 0x1620, 0x14FB, 0x136B, 0x11BD, 0x1077, 0x1028, 0x0F73, 0x0D67, 0x095D, 0x017C, 0xF7AB, 0xF027,
    0xEB41, 0xE60B, 0xE257, 0xDEDF, 0xDDC3, 0xDF6A, 0xE1C4, 0xE607, 0xE973, 0xEC2C, 0xEF98, 0xF15B, 0xEFB4, 0xED6B, 0xEB56, 0xE89F,
    0xE64E, 0xE60C, 0xE7B4, 0xE8F5, 0xEA13, 0xEA9A, 0xE9D7, 0xE881, 0xE6ED, 0xE8B0, 0xEC66, 0xF19A, 0xFB2E, 0x06AA, 0x0F2B, 0x1658,
    0x1BB8, 0x1E6E, 0x1FB5, 0x2030, 0x1F9D, 0x1AAC, 0x1560, 0x0E48, 0x0516, 0xFDDC, 0xF5AE, 0xEF57, 0xEBEB, 0xE9A0, 0xEA1B, 0xEA57,
    0xEAB4, 0xEC62, 0xEF16, 0xF3A1, 0xFAC4, 0x04BF, 0x0F49, 0x18DC, 0x20B8, 0x2548, 0x26C0, 0x244A, 0x1F6B, 0x1A62, 0x1476, 0x0ECC,
    0x09AB, 0x06B9, 0x0436, 0x0405, 0x0590, 0x06A4, 0x08BE, 0x0AB2, 0x0C04, 0x0B43, 0x0B4C, 0x0A6C, 0x088A, 0x091A, 0x0A3A, 0x0991,
    0x0861, 0x0557, 0xFE66, 0xF596, 0xE9DD, 0xE07D, 0xD87A, 0xD16F, 0xCE1C, 0xCC27, 0xCAFA, 0xC946, 0xC8C8, 0xC885, 0xC9DC, 0xCCC0,
    0xCF4E, 0xD28F, 0xD5BC, 0xD7A4, 0xD8CB, 0xDBC3, 0xDEC4, 0xE442, 0xEB20, 0xF0AB, 0xF7BA, 0xFD3D, 0x0199, 0x0416, 0x0634, 0x0A7C,
    0x121D, 0x1B52, 0x254D, 0x2F16, 0x36FC, 0x3C90, 0x3DCC, 0x3F53, 0x3F09, 0x3F82, 0x3FB2, 0x3DAE, 0x3BF2, 0x3A72, 0x3999, 0x37C7,
    0x370F, 0x3516, 0x337D, 0x3155, 0x2BCE, 0x2461, 0x1C0C, 0x130C, 0x0B7E, 0x0692, 0x021A, 0x0144, 0x001E, 0xFDBF, 0xFAEB, 0xF5FD,
    0xF1DA, 0xEC89, 0xE7ED, 0xE47D, 0xE161, 0xDF97, 0xDCCB, 0xD927, 0xD639, 0xD220, 0xCF0E, 0xCF38, 0xCE46, 0xCE5E, 0xCE20, 0xCBF2,
    0xC9BF, 0xC6C6, 0xC5CE, 0xC6AD, 0xCA2F, 0xCF15, 0xD521, 0xDCFE, 0xE388, 0xE8AF, 0xEE5E, 0xF448, 0xFB58, 0x053E, 0x0EC4, 0x185C,
    0x1E2D, 0x1FC9, 0x1FED, 0x1C87, 0x16EB, 0x11FB, 0x0D4E, 0x0822, 0x044E, 0x0187, 0x0022, 0x0075, 0x0305, 0x0742, 0x0C00, 0x124D,
    0x176C, 0x1A11, 0x1A6D, 0x18FB, 0x179C, 0x15A8, 0x1424, 0x1557, 0x17FA, 0x183C, 0x16B2, 0x12E1, 0x0D9B, 0x084F, 0x0410, 0x01FE,
    0x016F, 0x03A1, 0x055F, 0x0894, 0x0CB3, 0x0E7E, 0x10D6, 0x11A9, 0x0F2B, 0x0DB8, 0x0B83, 0x0604, 0xFEAD, 0xF4B8, 0xEB13, 0xE362,
    0xDCC5, 0xD683, 0xD0FD, 0xCCA1, 0xC866, 0xC51B, 0xC2EA, 0xC291, 0xC3F9, 0xC81C, 0xCEAD, 0xD718, 0xDFD7, 0xE85A, 0xF0D0, 0xF732,
    0xFB1C, 0xFD81, 0xFF5D, 0xFDD8, 0xFC75, 0xFB7E, 0xF8D5, 0xF820, 0xF8E9, 0xFBE4, 0x0162, 0x08A0, 0x0E74, 0x13B6, 0x1720, 0x186C,
    0x1B05, 0x1E6C, 0x24CB, 0x2C87, 0x3501, 0x3AAF, 0x3E24, 0x40FC, 0x400C, 0x3DE2, 0x3A55, 0x3670, 0x31E2, 0x2B45, 0x227D, 0x1989,
    0x0FEF, 0x07AA, 0x0194, 0xFD14, 0xFB06, 0xF810, 0xF603, 0xF1E6, 0xEC1C, 0xE672, 0xDFF2, 0xDC2C, 0xDAA2, 0xD99D, 0xDA4B, 0xDA9D,
    0xD8EC, 0xD7CF, 0xD574, 0xD35D, 0xD3C7, 0xD50C, 0xD90D, 0xDEE2, 0xE5C6, 0xECE4, 0xF340, 0xF87E, 0xFC1C, 0x00E4, 0x0631, 0x09E8,
    0x0D88, 0x1032, 0x0FE6, 0x10A0, 0x127A, 0x1592, 0x1A97, 0x1E0E, 0x2151, 0x2312, 0x224C, 0x1EB7, 0x1922, 0x1490, 0x113B, 0x0FEF,
    0x10C7, 0x1129, 0x105C, 0x0F46, 0x0CCF, 0x0B1D, 0x0925, 0x06A1, 0x078B, 0x07E2, 0x0834, 0x09BD, 0x0994, 0x08A4, 0x09E8, 0x0BBD,
    0x0C18, 0x0CB5, 0x0BC5, 0x092F, 0x054C, 0x000B, 0xF935, 0xF28D, 0xED82, 0xE8F2, 0xE6EB, 0xE617, 0xE60F, 0xE608, 0xE51E, 0xE44D,
    0xE50C, 0xE6C7, 0xE8BD, 0xEC1E, 0xEE76, 0xF0F7, 0xF365, 0xF38D, 0xF12E, 0xEEAA, 0xEAD9, 0xE4D6, 0xDE80, 0xD7A2, 0xD26D, 0xCEA3,
    0xCD3B, 0xCE67, 0xD2B1, 0xD9B9, 0xDFD6, 0xE6C5, 0xED45, 0xF13A, 0xF649, 0xFB84, 0x0066, 0x07AF, 0x0E45, 0x131C, 0x1715, 0x17EF,
    0x181E, 0x168A, 0x13E8, 0x12F9, 0x12AD, 0x12A2, 0x120E, 0x11F5, 0x1171, 0x116B, 0x144A, 0x186A, 0x1C32, 0x2133, 0x2546, 0x26DB,
    0x2691, 0x23FF, 0x2093, 0x1BEC, 0x15F9, 0x112E, 0x0D18, 0x090D, 0x03B1, 0xFD18, 0xF5D9, 0xEE02, 0xE93A, 0xE61F, 0xE3AC, 0xE526,
    0xE963, 0xEFBB, 0xF7D9, 0xFDE4, 0x038C, 0x09AA, 0x0C90, 0x0DF5, 0x0D50, 0x097A, 0x03E1, 0xFC7E, 0xF4ED, 0xEF50, 0xEBE5, 0xEB8D,
    0xED8C, 0xEF9E, 0xF0F6, 0xF07E, 0xF053, 0xF07E, 0xF239, 0xF842, 0x008B, 0x09EA, 0x12B2, 0x19C7, 0x1F52, 0x2346, 0x25BD, 0x275F,
    0x2843, 0x26CE, 0x2224, 0x1C1F, 0x14E9, 0x0C6F, 0x0562, 0x00C7, 0xFDB5, 0xFCA4, 0xFC1E, 0xFA85, 0xF917, 0xF61F, 0xF24F, 0xEF1B,
    0xEC4E, 0xEA80, 0xEA24, 0xEB0F, 0xECB6, 0xED9D, 0xED61, 0xED84, 0xECB8, 0xEB22, 0xEB2E, 0xECD6, 0xEF90, 0xF31D, 0xF6E5, 0xFBA9,
    0x0217, 0x0833, 0x0C75, 0x0FC4, 0x1324, 0x14F5, 0x1355, 0x1316, 0x1282, 0x1122, 0x1285, 0x1440, 0x167C, 0x171E, 0x15BE, 0x12C4,
    0x0DCF, 0x06AC, 0xFF21, 0xF909, 0xF486, 0xF206, 0xEFC4, 0xED31, 0xEAF3, 0xE8E9, 0xE5E6, 0xE432, 0xE5A1, 0xE786, 0xE9B1, 0xEAFF,
    0xEBEC, 0xEDDB, 0xF068, 0xF363, 0xF745, 0xFAFC, 0xFF3F, 0x043A, 0x0730, 0x08E3, 0x0786, 0x05A5, 0x03D1, 0x00BE, 0x004E, 0x0093,
    0x01B4, 0x02C5, 0x0208, 0x0263, 0x04F4, 0x075C, 0x09E9, 0x0D11, 0x10C1, 0x15D5, 0x1AB9, 0x1E90, 0x21CE, 0x25DA, 0x2842, 0x26C1,
    0x22FE, 0x1BF5, 0x11E8, 0x0699, 0xFB42, 0xF188, 0xEBF6, 0xE92D, 0xE987, 0xEB3D, 0xEAC8, 0xEAA9, 0xE922, 0xE7B4, 0xE87E, 0xE9C9,
    0xEC36, 0xEFE5, 0xF3D6, 0xF5E9, 0xF624, 0xF631, 0xF5B7, 0xF47B, 0xF505, 0xF6C8, 0xF801, 0xF8DD, 0xF869, 0xF789, 0xF8C9, 0xFC32,
    0x017D, 0x09C7, 0x1272, 0x1B59, 0x230D, 0x27CE, 0x2B10, 0x2AD8, 0x28EC, 0x2697, 0x2466, 0x21CB, 0x1F05, 0x1C7A, 0x173D, 0x109A,
    0x08F1, 0x01B4, 0xFBF8, 0xF83B, 0xF643, 0xF69F, 0xF9C5, 0xFCEE, 0x0162, 0x0885, 0x1065, 0x17D0, 0x1DD4, 0x1F74, 0x1EC2, 0x1C2A,
    0x174B, 0x1230, 0x0D70, 0x0B52, 0x0AA1, 0x09F6, 0x0848, 0x0545, 0x0193, 0xFC07, 0xF76B, 0xF57A, 0xF4EA, 0xF69E, 0xFA34, 0xFE48,
    0x034C, 0x0791, 0x0933, 0x0B71, 0x0CCF, 0x0CEB, 0x0C97, 0x095E, 0x0253, 0xF8A4, 0xEEC1, 0xE696, 0xDFF5, 0xDB98, 0xD99C, 0xD907,
    0xD96D, 0xD7E2, 0xD69A, 0xD53C, 0xD33B, 0xD2F9, 0xD36F, 0xD4A8, 0xD6E4, 0xD93F, 0xDBFD, 0xDEA2, 0xE084, 0xE29F, 0xE405, 0xE6AB,
    0xE8EF, 0xEA8D, 0xED7B, 0xF011, 0xF55A, 0xFD68, 0x0659, 0x10C1, 0x1A3D, 0x20D5, 0x253B, 0x278C, 0x2843, 0x2A2D, 0x2C86, 0x2FB8,
    0x3397, 0x36C0, 0x38A1, 0x3919, 0x39AE, 0x3838, 0x35AE, 0x336E, 0x3168, 0x2E85, 0x2AA6, 0x25C2, 0x20E2, 0x1D2B, 0x1803, 0x13D4,
    0x100D, 0x0C7B, 0x0A1A, 0x05E9, 0x0052, 0xFA80, 0xF4D3, 0xEEA3, 0xEA14, 0xE7DE, 0xE770, 0xE7C1, 0xE7D8, 0xE630, 0xE280, 0xDDAD,
    0xD7C7, 0xD36B, 0xCF92, 0xCB79, 0xC9D0, 0xC925, 0xC769, 0xC69D, 0xC739, 0xC81E, 0xCA93, 0xCED4, 0xD405, 0xDA7C, 0xE109, 0xE8A9,
    0xF13D, 0xFBFC, 0x0845, 0x1378, 0x1D80, 0x2433, 0x274D, 0x26AC, 0x21FA, 0x1C3C, 0x17FF, 0x1568, 0x15A8, 0x1707, 0x173F, 0x1778,
    0x176D, 0x15E3, 0x1502, 0x13FC, 0x1371, 0x15B8, 0x185B, 0x1AD4, 0x1D3E, 0x2016, 0x222A, 0x2397, 0x2659, 0x2755, 0x285D, 0x28A4,
    0x2610, 0x231C, 0x1EA5, 0x19C3, 0x1610, 0x1386, 0x13D4, 0x1692, 0x198F, 0x1BD5, 0x1C3F, 0x1AF2, 0x170D, 0x1253, 0x0DCF, 0x0837,
    0x035A, 0xFE0B, 0xF70E, 0xEF16, 0xE70E, 0xDEF5, 0xD6B8, 0xCF16, 0xC7ED, 0xC2DF, 0xBF8B, 0xBDA6, 0xBDB4, 0xC09C, 0xC6F0, 0xCF0B,
    0xD81D, 0xE106, 0xE99B, 0xEF65, 0xF26E, 0xF529, 0xF7AC, 0xFA42, 0xFDF1, 0x0268, 0x05DD, 0x0963, 0x0C80, 0x0CBC, 0x0E1A, 0x1042,
    0x1170, 0x1418, 0x1644, 0x176F, 0x19D8, 0x1D4C, 0x21DB, 0x26D0, 0x2BB0, 0x31BC, 0x35DD, 0x3808, 0x3786, 0x346A, 0x300E, 0x294E,
    0x22B7, 0x1C8B, 0x16C3, 0x1352, 0x0F81, 0x0A1F, 0x0520, 0xFF83, 0xF8C3, 0xF2B8, 0xEE4B, 0xEA48, 0xE7E5, 0xE5BB, 0xE36A, 0xE18F,
    0xDF7A, 0xDD3E, 0xDB36, 0xDAC4, 0xD9D0, 0xD7F0, 0xD557, 0xD22A, 0xD085, 0xD057, 0xD1AC, 0xD610, 0xDB70, 0xE099, 0xE5E3, 0xE8F7,
    0xEA11, 0xEA08, 0xEA95, 0xED71, 0xF1DE, 0xF79D, 0xFD5D, 0x0309, 0x085E, 0x0B42, 0x0D94, 0x10CB, 0x12D8, 0x153B, 0x1783, 0x17A9,
    0x17CC, 0x1665, 0x143B, 0x13CB, 0x1412, 0x1680, 0x18D3, 0x1B09, 0x1C85, 0x1BB3, 0x1A3C, 0x17AE, 0x15D5, 0x1512, 0x1543, 0x1907,
    0x1E08, 0x2183, 0x23F3, 0x25CC, 0x26E2, 0x26B8, 0x2510, 0x2263, 0x2051, 0x1CB4, 0x170E, 0x10E0, 0x0B3B, 0x05D3, 0x00CA, 0xFBB5,
    0xF803, 0xF54F, 0xF379, 0xF18B, 0xF0AF, 0xF25D, 0xF5ED, 0xFC66, 0x03D3, 0x0977, 0x0E1D, 0x0EB4, 0x0B09, 0x0539, 0xFE56, 0xF64D,
    0xEDF2, 0xE7BE, 0xE52E, 0xE2F8, 0xD9F2, 0xD77B, 0xDA10, 0xD7F3, 0xD2B3, 0xD3E3, 0xD74A, 0xDBE6, 0xDD3D, 0xDF50, 0xE281, 0xE8DB,
    0xF1B1, 0xF49F, 0xFDED, 0x03A8, 0x08AA, 0x0D16, 0x0D5E, 0x0B21, 0x093D, 0x081E, 0x0B54, 0x0E7F, 0x0FF4, 0x11FC, 0x1A29, 0x20E3,
    0x234E, 0x2398, 0x2629, 0x26D0, 0x29F4, 0x2DAB, 0x288E, 0x2835, 0x24C9, 0x25B4, 0x2290, 0x1B6E, 0x1227, 0x0DDA, 0x05CB, 0xF886,
    0xED6C, 0xE504, 0xE386, 0xE483, 0xE3A0, 0xE631, 0xED86, 0xEF9C, 0xF036, 0xEFE3, 0xF046, 0xF088, 0xED53, 0xE8C1, 0xE9A6, 0xEAB3,
    0xEB6D, 0xE695, 0xE480, 0xE5EF, 0xE396, 0xE07A, 0xE196, 0xDE86, 0xE064, 0xE029, 0xDC41, 0xE14F, 0xE461, 0xEF9B, 0xF886, 0x0504,
    0x0E79, 0x17B3, 0x1E9F, 0x1DC7, 0x2193, 0x1E3F, 0x1C77, 0x1E2F, 0x1D33, 0x182A, 0x17E1, 0x146D, 0x0E49, 0x0BF1, 0x0775, 0x04B3,
    0xFEE8, 0xFC52, 0xFA8C, 0xF6CC, 0xF21C, 0xF0BC, 0xED8C, 0xEDB3, 0xED55, 0xF158, 0xEDD2, 0xE585, 0xEAF5, 0xE4AC, 0xE751, 0xEA1C,
    0xF093, 0xF6F0, 0xFBDD, 0x055F, 0x0BF3, 0x10BD, 0x12AB, 0x17F1, 0x1765, 0x1D43, 0x1B32, 0x1EF1, 0x2BBE, 0x2BE7, 0x2E0C, 0x2819,
    0x3140, 0x32BB, 0x27A2, 0x2E16, 0x2699, 0x2343, 0x17DF, 0x11D0, 0x0E60, 0x052D, 0x0137, 0x03CF, 0xFB4D, 0xFDBD, 0xFDDF, 0xECCE,
    0xF32B, 0xE5F6, 0xECF4, 0xE8CD, 0xE676, 0xF558, 0xF3F5, 0xF3F8, 0x00FB, 0x0473, 0xF42C, 0x01CD, 0x01EF, 0x063A, 0x1358, 0xF454,
    0xFE9F, 0x06D6, 0xED0C, 0xFF6E, 0xF057, 0xF70C, 0xF789, 0xDE85, 0xF441, 0xE0A2, 0xE865, 0xECD4, 0xE659, 0x0B93, 0x0FEE, 0xF757,
    0x03D5, 0x2542, 0x1AF0, 0x06A4, 0x0709, 0x1E0F, 0x0136, 0x0130, 0x0999, 0xFDE9, 0xF690, 0xDBC5, 0xF45E, 0xF81D, 0xE7C5, 0xD961,
    0xF37E, 0xFDA7, 0xDBD0, 0xE48A, 0xE8D8, 0xEF29, 0xF1B6, 0xE8A7, 0xF3A0, 0x068E, 0xFCF8, 0xE7AE, 0xEF3C, 0x0060, 0xE50A, 0xDDDA,
    0xEFE7, 0xDF68, 0xE45E, 0xDD76, 0xF162, 0xDEE5, 0xEDE3, 0x039C, 0xF7F7, 0xF9EB, 0xFC9A, 0x1276, 0x031D, 0x072D, 0x005C, 0x19B7,
    0x1683, 0x11DB, 0x0C9E, 0x0CC0, 0x0859, 0xF14B, 0xF486, 0xEB55, 0xF9F7, 0xE9C3, 0xEE02, 0x0BC6, 0x053D, 0xFC4A, 0xFE42, 0x1D30,
    0x0ACD, 0xFCDE, 0x0DF5, 0x112D, 0x1529, 0xF10F, 0x21C4, 0x1D07, 0xFA53, 0x13F5, 0x14C7, 0x0F24, 0xFD04, 0xFA00, 0x0639, 0x0056,
    0xE6DC, 0xFB2C, 0xF157, 0xF3D4, 0xF3B9, 0xFE12, 0x0E94, 0xF5D1, 0x0954, 0x0392, 0x165F, 0x0588, 0xF671, 0x0614, 0x050F, 0xF934,
    0xF049, 0xFCCD, 0xE318, 0xE6EB, 0xE681, 0xECBE, 0xD7D1, 0xE60E, 0xD6D4, 0xD757, 0xF5EE, 0xD2E9, 0xDA7A, 0xE268, 0xF35D, 0xD0D3,
    0xDE3B, 0xE7CA, 0xD0D1, 0xE5F6, 0xE4EA, 0xDF2A, 0xE96A, 0xF6AF, 0xF421, 0x0065, 0xFE45, 0x057F, 0x1724, 0x1339, 0x1DC9, 0x2125,
    0x259E, 0x1B06, 0x2E3D, 0x3649, 0x2093, 0x3E9A, 0x2AE1, 0x35AC, 0x3431, 0x32CB, 0x34D8, 0x2616, 0x2B9D, 0x17AB, 0x239E, 0x177F,
    0x192E, 0x0A70, 0x1279, 0x16B1, 0xFD86, 0x0FFC, 0x0201, 0xF6A0, 0xF8A5, 0x014F, 0xE238, 0xECAB, 0xF868, 0xECCF, 0xF83A, 0xDE9F,
    0xF888, 0xF600, 0xE5F8, 0xEDEA, 0xFB28, 0xDE1A, 0xD468, 0xE8A9, 0xDE45, 0xE1AF, 0xD39B, 0xD647, 0xD863, 0xDA28, 0xCC04, 0xC13B,
    0xDA85, 0xCFC2, 0xDD1D, 0xE217, 0xE210, 0xF849, 0xE5AA, 0x073F, 0x086D, 0xFFA0, 0x0762, 0x082C, 0x06B9, 0x03BA, 0x08D0, 0x082D,
    0xEB3F, 0x027A, 0xFD64, 0xFB50, 0x0E7C, 0xE4F1, 0x017D, 0xF79E, 0x0726, 0xF353, 0xF8C3, 0x0963, 0xFD30, 0x024F, 0x10FD, 0x140E,
    0x10F2, 0x2505, 0x130B, 0x19DC, 0x1B74, 0x26FD, 0x238D, 0x06A3, 0x0A1A, 0x26B0, 0x22AD, 0x0969, 0x0FA0, 0x1DD0, 0x1DEF, 0x1DD9,
    0x0D31, 0x1258, 0x0F16, 0x190C, 0x072E, 0x12B7, 0x099C, 0xF787, 0x1188, 0xED71, 0xD581, 0xDC77, 0xD796, 0xC083, 0xC858, 0xB6F1,
    0xC7B6, 0xCDA7, 0xBA94, 0xBDBE, 0xD7CD, 0xD497, 0xCA15, 0xD8C1, 0xD6B9, 0xE3AE, 0xEBC0, 0xE56C, 0xF270, 0x0596, 0xFEC3, 0xFF03,
    0x1E2B, 0x1FED, 0x072F, 0x237D, 0x1F04, 0x0B0D, 0x1909, 0x12E9, 0x1CBC, 0x2B2B, 0x20AA, 0x293E, 0x26C2, 0x3DDD, 0x4A69, 0x306B,
    0x3044, 0x54CE, 0x3006, 0x2E3F, 0x430D, 0x2E09, 0x3CD1, 0x270B, 0x3703, 0x389C, 0x24D8, 0x1E58, 0x1413, 0x0E6F, 0x09EF, 0x0604,
    0x0583, 0xF485, 0xF2E2, 0x033F, 0xF08A, 0xDFA5, 0xDF7F, 0xCD9B, 0xDE48, 0xC8CB, 0xC82B, 0xC9C3, 0xBEF8, 0xCED8, 0xC08E, 0xCFF4,
    0xCCA2, 0xD0FC, 0xD883, 0xD1E5, 0xD301, 0xE672, 0xDEE7, 0xE439, 0xDC12, 0xF3DF, 0xF8C1, 0xE93D, 0x12AE, 0x08BD, 0xFF5E, 0x18BF,
    0x0D94, 0x0EA1, 0x17DD, 0x030C, 0x151F, 0x3112, 0x11F7, 0x1EC2, 0x240B, 0x18E6, 0x34B2, 0x12F3, 0x1681, 0x21C8, 0x134C, 0x036D,
    0x2DE7, 0x0A19, 0xFED9, 0x1652, 0x0617, 0x2593, 0x03EE, 0x07B7, 0x192F, 0x007E, 0x0389, 0x00F0, 0x0F37, 0x0AD7, 0xF9C3, 0x0DDB,
    0x0E7A, 0xFD8C, 0xF2D1, 0xFCC2, 0xDC50, 0xF0DC, 0xDBCB, 0xE930, 0xE8F1, 0xDE8F, 0x0322, 0xEC8A, 0xF733, 0xF630, 0x0C4C, 0x010E,
    0x031E, 0x0243, 0x05A8, 0xF987, 0xF54F, 0xED50, 0xE11D, 0xEF98, 0xE173, 0xE3EA, 0xE857, 0xE4B7, 0xD026, 0xE34E, 0xD905, 0xCE99,
    0xD6F6, 0xD3F0, 0xDB5A, 0xDF3A, 0xEEAC, 0xE52D, 0xEC85, 0xF7C1, 0xF549, 0x03C6, 0x03AE, 0x0FF9, 0xFCA8, 0x07D6, 0x1441, 0x12D6,
    0x123B, 0x116D, 0x32CE, 0x0CD8, 0x2E29, 0x3304, 0x23E3, 0x33FB, 0x3108, 0x4200, 0x343E, 0x4211, 0x4361, 0x3AB7, 0x3EAC, 0x3D0F,
    0x2D21, 0x1DE2, 0x2083, 0x212D, 0x0E50, 0x063C, 0x0D6A, 0xFBC5, 0xFA1F, 0x089B, 0xFCFF, 0xFB0D, 0x0C5C, 0xF507, 0xF688, 0x067F,
    0xFAF7, 0xFDC7, 0xF1A9, 0x03DF, 0x0561, 0x03A2, 0x0602, 0xF900, 0xF555, 0x07F5, 0xE7BE, 0xDAFB, 0xF59C, 0xDB5D, 0xE3B6, 0xE056,
    0xE00B, 0xDA67, 0xEABF, 0xF197, 0xEE7C, 0xEF37, 0xF6C3, 0xF86A, 0xF56E, 0xFD80, 0x0189, 0xFD37, 0xFA8A, 0x0A98, 0x0007, 0x16D6,
    0x05C2, 0xF513, 0x0659, 0xFEE0, 0xECA9, 0xFA7E, 0x08D6, 0xFDAA, 0xF82C, 0x035B, 0xFCF4, 0x0481, 0xF9ED, 0xE3C2, 0xFEB3, 0xF8F9,
    0xE78A, 0xE0D5, 0xF4F3, 0xEC30, 0xFC4C, 0xEE2C, 0xF0CE, 0x0D49, 0xEFE5, 0x0D15, 0x11AD, 0xF3AE, 0x09AE, 0xF98B, 0x05F0, 0x0F79,
    0x017D, 0x15F5, 0x0D11, 0x1972, 0x1521, 0x0D7C, 0x0DFA, 0x125C, 0x0081, 0x0C11, 0x03EA, 0x0300, 0x0583, 0xF4B4, 0xF935, 0x00FE,
    0xF386, 0xF3A3, 0x0050, 0xF149, 0xF27D, 0xE32B, 0xF46C, 0xE3AD, 0xF945, 0xF282, 0xE8C5, 0x0088, 0xFD27, 0xF263, 0xFCAC, 0xFFA4,
    0xE99F, 0x0047, 0x0EA2, 0x1061, 0xF69F, 0x1249, 0x03D6, 0xF9BA, 0x06CD, 0xF1E6, 0xE6FF, 0xEF2A, 0xF38C, 0xE3A4, 0xE6CD, 0xE332,
    0xEF08, 0xF8E2, 0xF112, 0xF7F8, 0x06FF, 0xFA45, 0x1224, 0x02BF, 0xF6D1, 0x07D0, 0x0C77, 0x08A4, 0xFF0A, 0x0D9F, 0x0311, 0xFB40,
    0x02AC, 0x0A00, 0xF37D, 0xEFF1, 0xFE74, 0xF8EB, 0xEED6, 0xFB47, 0xFEDC, 0xEBA3, 0xF77D, 0x0E85, 0xF980, 0xF911, 0x0A9A, 0x07CE,
    0xF885, 0xF494, 0xFFB8, 0xF682, 0xFB03, 0x012E, 0xFA08, 0xF2D9, 0x0EB3, 0x011A, 0xEBD7, 0x01D8, 0x0A8B, 0x0F4B, 0xFB75, 0x1903,
    0x2134, 0x153A, 0x2841, 0x1C56, 0x18E3, 0x2305, 0x1E2F, 0x07F6, 0x0C12, 0x1095, 0xFEBE, 0xE84E, 0xF786, 0xF3C7, 0xE2F1, 0xF734,
    0xF691, 0xF5D8, 0xF3B6, 0xEB88, 0x0094, 0xEC73, 0xF19A, 0xFC84, 0xF1F0, 0x04D3, 0x0B1C, 0x0FE9, 0x0644, 0x0C84, 0x1121, 0x10E1,
    0xFB84, 0x13C8, 0x088F, 0xF3EA, 0x0739, 0x0287, 0xFCD1, 0x03EB, 0x1463, 0x06DA, 0x0F20, 0x1542, 0x1734, 0x184D, 0x19AA, 0x0CEB,
    0x12E7, 0x1538, 0x17CC, 0x1154, 0x011E, 0x0D4D, 0x05FD, 0xE8C0, 0xDEFA, 0xE2A7, 0xD97F, 0xDD01, 0xCC40, 0xD589, 0xD541, 0xCAA8,
    0xC8DC, 0xC3CE, 0xC387, 0xBE71, 0xC502, 0xB401, 0xB9A6, 0xBFFF, 0xBF04, 0xBC39, 0xBA2D, 0xD36C, 0xCB1A, 0xDF19, 0xE0EF, 0xDBB1,
    0xF631, 0xF1FC, 0xFF1A, 0x02A0, 0x0738, 0x1570, 0x2013, 0x1B03, 0x2A51, 0x3505, 0x288D, 0x30C5, 0x3A9C, 0x31E6, 0x2AD2, 0x3242,
    0x2F54, 0x29E1, 0x2218, 0x2CC5, 0x3085, 0x23C7, 0x27F8, 0x2C2E, 0x1E63, 0x1199, 0x27EA, 0x1147, 0x070F, 0x19F4, 0x0737, 0x0BF5,
    0x031E, 0x0F46, 0x0098, 0xFAB2, 0x04D1, 0xFCDB, 0xFAD1, 0x006E, 0x0665, 0xF8F8, 0x09B3, 0x01A6, 0xF8C6, 0xFD3F, 0xFB16, 0xF9F5,
    0xEBD5, 0xE2C5, 0xF225, 0xE2A0, 0xE0FD, 0xE46A, 0xE913, 0xF04E, 0xEC36, 0x00DD, 0xF6E7, 0xFA22, 0x0E0E, 0x06AA, 0x00E6, 0x054A,
    0x13CE, 0x1EC7, 0x0A24, 0x10DA, 0x1A73, 0x13D8, 0x1013, 0x166A, 0x0DDD, 0x141E, 0x1924, 0x0884, 0x0725, 0x0556, 0x10BE, 0x037A,
    0x044A, 0x1082, 0x0F95, 0x08EF, 0x04F0, 0x1408, 0xFEE4, 0xFC3F, 0x0EAC, 0xFE61, 0x03A2, 0x0D95, 0x11C0, 0x075B, 0x08ED, 0x0A5B,
    0x032C, 0x032F, 0x0D07, 0x0BAD, 0x0AA6, 0x14FE, 0x1548, 0x1A05, 0x1718, 0x0F0D, 0x16FD, 0x09BB, 0x08AA, 0x0AD6, 0xF357, 0xF8C6,
    0xE7D5, 0xDF94, 0xDD7E, 0xDDD3, 0xD5A1, 0xDD5B, 0xD7EA, 0xE18B, 0xE135, 0xD773, 0xE352, 0xDB7C, 0xDE83, 0xE228, 0xEB1E, 0xE5F1,
    0xED2C, 0xF13E, 0xFC8C, 0xFF8D, 0xF8FC, 0x0449, 0x01A8, 0xFE05, 0x0A63, 0xFDDA, 0xF92C, 0x086F, 0x100D, 0x0218, 0x199E, 0x1E67,
    0x1C85, 0x1EFC, 0x2233, 0x320B, 0x21F0, 0x3606, 0x3668, 0x3589, 0x3550, 0x3600, 0x32FC, 0x37C9, 0x365D, 0x2E91, 0x1E30, 0x2364,
    0x2839, 0x17A3, 0x1B25, 0x1002, 0x1765, 0x0F30, 0x09D2, 0x01CB, 0xFE57, 0xF752, 0xEB15, 0xDE73, 0xD22D, 0xD4C7, 0xC98E, 0xC194,
    0xC097, 0xC423, 0xC11E, 0xC0C8, 0xC0A8, 0xC90F, 0xC90D, 0xC16A, 0xC988, 0xCF23, 0xCDE3, 0xD08B, 0xD93C, 0xDB3E, 0xE5A3, 0xE77A,
    0xF269, 0xFA68, 0xFA8A, 0x02B5, 0xFD92, 0x095B, 0x0837, 0x12A4, 0x15D8, 0x1685, 0x23F5, 0x2593, 0x2ED1, 0x29E3, 0x2DA1, 0x2F52,
    0x2EC3, 0x2C11, 0x35A9, 0x38C5, 0x33EC, 0x3932, 0x32E8, 0x2C6B, 0x2E93, 0x2C42, 0x2830, 0x2C02, 0x28F1, 0x2D0A, 0x2D66, 0x2E24,
    0x2AE8, 0x2B33, 0x2EE4, 0x2C51, 0x27FE, 0x21DA, 0x1E0D, 0x1110, 0x08BF, 0x034C, 0xFD95, 0xF73C, 0xF583, 0xF674, 0xF764, 0xF64F,
    0xF428, 0xF23A, 0xF1EA, 0xF3AD, 0xECAE, 0xEDBB, 0xF132, 0xEB12, 0xEC37, 0xEBBC, 0xE196, 0xE43C, 0xE0C6, 0xDD81, 0xD8FF, 0xD9A1,
    0xD713, 0xCB5C, 0xCE20, 0xCD44, 0xCC70, 0xCC4D, 0xD42C, 0xD6FD, 0xD976, 0xDC3E, 0xDC67, 0xDC97, 0xE5B0, 0xEBB0, 0xED05, 0xF12C,
    0xFA33, 0x0791, 0x05B1, 0x07D9, 0x0F74, 0x0FF5, 0x1128, 0x1560, 0x1494, 0x1922, 0x1F70, 0x1E8A, 0x29B3, 0x2789, 0x2818, 0x302C,
    0x2863, 0x345B, 0x20AC, 0x193A, 0x1F76, 0x0D76, 0x0214, 0x07C1, 0x03BD, 0xFB70, 0xFC2E, 0xF235, 0xFBDD, 0xF2ED, 0xF2A4, 0xF40C,
    0xF258, 0xEF50, 0xF03B, 0xF07C, 0xF309, 0xF8D5, 0xF9CD, 0x042B, 0xFD37, 0x0655, 0x0B73, 0x0993, 0xF93F, 0xF981, 0xFDB0, 0xF5F2,
    0xF0FB, 0xEA61, 0xF152, 0xEDA4, 0xF3BF, 0xECB9, 0xF10D, 0xF718, 0xEB72, 0xF0A2, 0xF830, 0xFD15, 0x0235, 0x0399, 0x01F1, 0x0713,
    0x065E, 0x0287, 0x0BB7, 0x0B10, 0x0445, 0x049F, 0x00B0, 0x0127, 0xFB92, 0x0343, 0x05A9, 0xFF80, 0x05BA, 0x0E97, 0x0288, 0xFE9E,
    0x0209, 0xF476, 0xF388, 0xEBFF, 0xEB2D, 0xEB55, 0xE984, 0xE938, 0xEE71, 0xE76B, 0xF491, 0xF253, 0xED0E, 0x00E0, 0xFF75, 0xFD23,
    0xF9E7, 0x0B59, 0x1060, 0x0F48, 0x1CE0, 0x1FC8, 0x1ABB, 0x29C4, 0x2720, 0x2804, 0x229A, 0x244F, 0x2628, 0x1BA4, 0x2720, 0x2339,
    0x2417, 0x205A, 0x2063, 0x1BF9, 0x175A, 0x1226, 0x0B6D, 0x0310, 0x0844, 0x086B, 0xFB50, 0xFCA9, 0xF6B8, 0xEA19, 0xEA21, 0xE700,
    0xE503, 0xE436, 0xDF75, 0xE9E1, 0xE7BC, 0xE86B, 0xEAF6, 0xF220, 0xFA67, 0x03F7, 0xFF3B, 0xF9CA, 0x00C8, 0xF524, 0xF00B, 0xEF13,
    0xEEF9, 0xF163, 0xEACC, 0xF209, 0xEFBE, 0xF63A, 0x0759, 0xFC7E, 0x0606, 0x075D, 0x0A6F, 0x097E, 0x0E15, 0x1887, 0x0C3B, 0x14F5,
    0x190D, 0x1194, 0x11E7, 0x13CE, 0x0341, 0x0148, 0x0049, 0xF275, 0xF52D, 0xECAF, 0xF046, 0xEBD1, 0xE8BB, 0xED8C, 0xE6DC, 0xE6BC,
    0xE0B1, 0xDD97, 0xDF70, 0xE2D0, 0xE081, 0xE69B, 0xDDE9, 0xE485, 0xE875, 0xE5A6, 0xE9B2, 0xE602, 0xEA32, 0xE7CA, 0xEDB9, 0xE8FF,
    0xED0E, 0xF13E, 0xF913, 0x029A, 0x0505, 0x12D0, 0x12EA, 0x0EE5, 0x10C1, 0x118B, 0x0E3A, 0x03E1, 0x03B9, 0xFE99, 0xFAE0, 0xFEFA,
    0xF804, 0xF148, 0xF467, 0xF5AD, 0xF3DB, 0xF400, 0xF6A5, 0xF4F9, 0xF36C, 0xF6EE, 0xF380, 0xFCDF, 0x002B, 0x099D, 0x07A5, 0x0D38,
    0x13EF, 0x0ED2, 0x0A7E, 0x08C6, 0x0E27, 0x04C8, 0x0BF3, 0x0B0E, 0x0E4B, 0x1068, 0x1343, 0x12B5, 0x110D, 0x15EF, 0x1AC8, 0x1A41,
    0x1D0E, 0x225C, 0x28AB, 0x325B, 0x2271, 0x2700, 0x29E4, 0x247D, 0x23E3, 0x1CAA, 0x1CBF, 0x131D, 0x0DD1, 0x034E, 0xFADB, 0xFDF7,
    0xFBB1, 0xFB2F, 0xF39B, 0xF73E, 0xF21A, 0xEFE9, 0xE61C, 0xE0BB, 0xDB42, 0xCCD8, 0xD2CD, 0xCA8C, 0xC8A0, 0xC92B, 0xD0BB, 0xCD40,
    0xCD5B, 0xD36E, 0xD435, 0xD8EB, 0xD838, 0xDD9F, 0xDECB, 0xE222, 0xEC16, 0xECDA, 0xEF96, 0xF8B9, 0xFB96, 0x0331, 0x0835, 0x086B,
    0x0386, 0x0CAA, 0x1255, 0x135A, 0x16DC, 0x165B, 0x1BFD, 0x18AD, 0x1960, 0x1744, 0x1926, 0x170F, 0x1783, 0x1530, 0x16EA, 0x1B27,
    0x15C7, 0x1858, 0x15A9, 0x1AC7, 0x14AE, 0x11FE, 0x0FC4, 0x094D, 0x08C4, 0x09D9, 0x08C1, 0x056F, 0x0281, 0x06B3, 0x0504, 0x012B,
    0xFEA8, 0xF7A6, 0xF559, 0xE740, 0xE44A, 0xD94F, 0xD86F, 0xD36E, 0xCC59, 0xCB75, 0xCB84, 0xCBA7, 0xD187, 0xD73D, 0xD53C, 0xDB2F,
    0xD769, 0xDDED, 0xDA5A, 0xE4BC, 0xEE6C, 0xF043, 0xFB3E, 0xFE48, 0x05FD, 0x0340, 0x03F7, 0x05B3, 0x0229, 0x0820, 0x04DD, 0x082D,
    0x093F, 0x0ADE, 0x0D96, 0x0674, 0x0811, 0x041A, 0x03C0, 0x0258, 0x0196, 0x064B, 0x00C1, 0x03F7, 0x0049, 0x02F0, 0x024C, 0x039A,
    0x0954, 0x0313, 0x05CD, 0x00AB, 0x0605, 0xFEB0, 0x004F, 0x02C1, 0x0783, 0x0E0D, 0x133E, 0x18A6, 0x151A, 0x1C4E, 0x1495, 0x12CE,
    0x0F93, 0x0CAA, 0x054F, 0xFDA6, 0xFC56, 0xF89B, 0xF626, 0xF11A, 0xEC47, 0xE8E4, 0xE712, 0xE91A, 0xE58C, 0xE04C, 0xE156, 0xDEEC,
    0xE34F, 0xE5CD, 0xEBD0, 0xEBB8, 0xF7BF, 0xFDC8, 0xF7C9, 0xFDF2, 0xFA5E, 0xFF0D, 0x0111, 0x0775, 0x065E, 0x0C19, 0x10B1, 0x11AA,
    0x1415, 0x10C4, 0x18E6, 0x1BB4, 0x1C63, 0x1D6E, 0x21F4, 0x29A9, 0x2DF0, 0x307C, 0x3351, 0x31A4, 0x366F, 0x34B8, 0x3124, 0x2AA6,
    0x24A0, 0x1F45, 0x17DB, 0x10F6, 0x09AE, 0x0596, 0x0698, 0x0564, 0x02F6, 0xFF00, 0xFA83, 0xFC22, 0xF0AC, 0xED33, 0xE656, 0xDF42,
    0xD7DD, 0xCEC9, 0xCA0F, 0xC63C, 0xC422, 0xC23B, 0xC326, 0xBEEA, 0xBE59, 0xBFC1, 0xBE18, 0xBF66, 0xC742, 0xC88E, 0xCEEF, 0xD5C2,
    0xDD05, 0xE04D, 0xE5E7, 0xEB4F, 0xEB68, 0xF19D, 0xEFE4, 0xF7B1, 0xF8E6, 0xF947, 0xFB2B, 0xFF27, 0x0247, 0x01DC, 0x088D, 0x09F3,
    0x0ECB, 0x10D2, 0x12A8, 0x1059, 0x117E, 0x1662, 0x17BF, 0x195A, 0x1AD9, 0x1DBC, 0x1C34, 0x1B7F, 0x1837, 0x1225, 0x10D7, 0x129B,
    0x1631, 0x1554, 0x19A4, 0x1BC1, 0x1ECC, 0x2472, 0x23D9, 0x27B2, 0x21EC, 0x253B, 0x1B56, 0x14C8, 0x1143, 0x098F, 0x09C1, 0xFFFE,
    0xFEF2, 0xF72E, 0xFB50, 0xFA4C, 0xF67F, 0xF5FE, 0xEEB3, 0xEC86, 0xEA2C, 0xEA49, 0xF0B1, 0xED32, 0xEEEC, 0xF02B, 0xEB1E, 0xE99F,
    0xDE4C, 0xDDCC, 0xD766, 0xD687, 0xD422, 0xCE8D, 0xD1E5, 0xCEE6, 0xD0BB, 0xCEB5, 0xCB37, 0xD1EC, 0xCF02, 0xD054, 0xD2CB, 0xD5C1,
    0xD9CF, 0xDCBC, 0xE728, 0xE7DF, 0xF1BF, 0xFB39, 0xFF3B, 0x04F3, 0x0984, 0x0BF1, 0x0DA6, 0x10C6, 0x14BE, 0x1B06, 0x2183, 0x2601,
    0x2EB2, 0x37D0, 0x3A69, 0x3F97, 0x3F22, 0x3FDF, 0x3D03, 0x3DC6, 0x3975, 0x319F, 0x3007, 0x2A54, 0x2985, 0x246A, 0x1FDD, 0x19F1,
    0x16DB, 0x12E8, 0x0984, 0x0508, 0x026C, 0x01A2, 0x028F, 0xFC83, 0x011A, 0x01D5, 0x00F4, 0x0139, 0xFAB4, 0xF9CE, 0xF2A6, 0xF3A9,
    0xEF69, 0xEC94, 0xEB81, 0xE77B, 0xE790, 0xE3E1, 0xDEF8, 0xE1C9, 0xE180, 0xE14B, 0xE131, 0xDF34, 0xDFA9, 0xE380, 0xE936, 0xEE05,
    0xF5E7, 0xF8F3, 0xFBFA, 0xFCB9, 0x0148, 0x007C, 0x0290, 0x0173, 0x0244, 0x0234, 0x0215, 0x06F5, 0x0873, 0x090B, 0x0D29, 0x1048,
    0x0F02, 0x10D0, 0x0A8C, 0x09C6, 0x015F, 0xFA71, 0xF2DE, 0xEDA0, 0xEAF7, 0xE704, 0xE58C, 0xE18E, 0xDFF7, 0xDB3F, 0xD893, 0xD1F7,
    0xD152, 0xD161, 0xD6C4, 0xDD16, 0xE2C8, 0xEA96, 0xF003, 0xF81A, 0xF8D7, 0xFE37, 0x0056, 0x0653, 0x0CF7, 0x0FED, 0x13BC, 0x1499,
    0x15BC, 0x1895, 0x1B4A, 0x1A00, 0x19DD, 0x18B4, 0x1B6F, 0x1827, 0x1508, 0x1118, 0x0CEC, 0x0D9E, 0x0B71, 0x06F7, 0x04F3, 0x03A0,
    0x0114, 0xFB6B, 0xF757, 0xEE56, 0xEAFC, 0xE8A6, 0xE6A3, 0xE9BB, 0xE837, 0xEB07, 0xEF0E, 0xF304, 0xF4CE, 0xFAA1, 0xFBF0, 0xFE5E,
    0xF92B, 0xF76D, 0xF5CE, 0xF47F, 0xF3BD, 0xF4E2, 0xF3C6, 0xF71A, 0xFA74, 0xFB9E, 0x0283, 0xFEBE, 0x0361, 0x0295, 0x07EB, 0x0E8F,
    0x12C4, 0x195A, 0x1F2B, 0x20CF, 0x207C, 0x1EF8, 0x1E9B, 0x1B7E, 0x1916, 0x17BC, 0x1674, 0x139B, 0x122B, 0x1372, 0x11A8, 0x1144,
    0x0D6F, 0x0C49, 0x084A, 0x0578, 0x00C4, 0x01F2, 0xFDF5, 0xFEA1, 0xFEF2, 0xFFB0, 0x00B4, 0xFDAD, 0xFF1C, 0xFBA6, 0xFA6E, 0xF53A,
    0xF39D, 0xEF9E, 0xEEB0, 0xEE34, 0xEB8B, 0xECB0, 0xEE6C, 0xF320, 0xF604, 0xF958, 0xFA31, 0xFACA, 0xFCA2, 0xF9B4, 0xF56F, 0xF122,
    0xF128, 0xF287, 0xF4FB, 0xF6DA, 0xF3E3, 0xF2C1, 0xF14F, 0xED46, 0xE9C9, 0xE7AE, 0xE8CC, 0xEE36, 0xF17A, 0xF393, 0xF76D, 0xFB6D,
    0x009E, 0x0474, 0x088C, 0x0D11, 0x0EB1, 0x10A6, 0x1205, 0x11D7, 0x1346, 0x13C7, 0x119A, 0x116B, 0x0DD1, 0x0D05, 0x0C3C, 0x09A5,
    0x097F, 0x054A, 0x04A9, 0x05C6, 0x0AF7, 0x0F31, 0x1456, 0x1805, 0x18C4, 0x18E6, 0x16DA, 0x1475, 0x1187, 0x0E2F, 0x0A08, 0x0509,
    0x006B, 0xFE96, 0xF877, 0xF8CC, 0xF8EA, 0xF7AC, 0xF86C, 0xF56A, 0xF4DA, 0xEFCE, 0xE9CF, 0xE631, 0xDEEB, 0xDA93, 0xD6B3, 0xD4DB,
    0xD34D, 0xCF6C, 0xCD7D, 0xC8A0, 0xC616, 0xC4B8, 0xC294, 0xC512, 0xC882, 0xCF0A, 0xD6F6, 0xDB80, 0xE3EB, 0xEA66, 0xF0E6, 0xF7B2,
    0xFBB0, 0x0215, 0x08A3, 0x0C21, 0x121D, 0x1410, 0x1715, 0x1D36, 0x1FEA, 0x2450, 0x237F, 0x255C, 0x269A, 0x26F7, 0x2658, 0x2418,
    0x25EE, 0x275A, 0x2AA2, 0x2A8A, 0x296B, 0x2BD7, 0x2CB7, 0x2936, 0x267C, 0x22BF, 0x1FA2, 0x1E09, 0x1B18, 0x1B3C, 0x16D6, 0x19B8,
    0x1A0E, 0x19F7, 0x1D05, 0x1B5C, 0x1D1D, 0x1706, 0x1319, 0x0CBB, 0x0506, 0x01A8, 0xFE11, 0xFB43, 0xF700, 0xF363, 0xEF25, 0xEB7C,
    0xE994, 0xEA9A, 0xE8A5, 0xE754, 0xE835, 0xE96E, 0xED21, 0xEE56, 0xF138, 0xF3E6, 0xF697, 0xF89C, 0xF89B, 0xF759, 0xF685, 0xF4DD,
    0xF37C, 0xF0B5, 0xF063, 0xF0EA, 0xF151, 0xF3CD, 0xF2FD, 0xF25F, 0xEDA9, 0xEE2C, 0xEA7C, 0xE972, 0xEB29, 0xEE95, 0xF2C4, 0xF5AA,
    0xFBBC, 0xFA3C, 0xFD22, 0xFDD1, 0xFEA6, 0x01E9, 0x002C, 0x01C3, 0x0384, 0x02F4, 0x07AA, 0x09A5, 0x1078, 0x17FC, 0x1EA1, 0x2616,
    0x26C0, 0x29AC, 0x2931, 0x267E, 0x21F9, 0x1D37, 0x197D, 0x1712, 0x135A, 0x0D20, 0x0662, 0xFD6B, 0xF606, 0xECA1, 0xE3F2, 0xDD92,
    0xD9DA, 0xD92B, 0xD773, 0xD51C, 0xD3DF, 0xD537, 0xD777, 0xD8B1, 0xDAF3, 0xDE72, 0xDFF8, 0xE008, 0xDF9D, 0xE2B5, 0xE647, 0xEB82,
    0xF054, 0xF520, 0xFAA4, 0xFD27, 0x02D6, 0x055C, 0x08EB, 0x0C0F, 0x0DF3, 0x12F6, 0x16CA, 0x1F9C, 0x2883, 0x309F, 0x33D1, 0x3509,
    0x381B, 0x37D4, 0x358E, 0x32CA, 0x2EA7, 0x2B03, 0x27B1, 0x2144, 0x1E6B, 0x1B9A, 0x1BC9, 0x1A19, 0x1910, 0x1542, 0x0FD4, 0x0B2A,
    0x05FA, 0x0198, 0xF9EA, 0xF55A, 0xF065, 0xEB45, 0xE404, 0xDDCB, 0xD6B6, 0xD20A, 0xCCDD, 0xCA00, 0xC6BD, 0xC3D2, 0xC779, 0xC86C,
    0xCAFF, 0xCF2B, 0xD2D5, 0xD898, 0xDD01, 0xE0F1, 0xE300, 0xE4B3, 0xEA44, 0xECC5, 0xF075, 0xF349, 0xF980, 0x005E, 0x0473, 0x07C0,
    0x09A7, 0x0D36, 0x10D1, 0x1321, 0x161F, 0x1A73, 0x1E8D, 0x252B, 0x2842, 0x2C49, 0x2F7A, 0x32CE, 0x3676, 0x36F2, 0x365E, 0x34B5,
    0x33A2, 0x2E20, 0x2AE3, 0x29A4, 0x2958, 0x2AEA, 0x2A49, 0x2BF3, 0x2E35, 0x2D1D, 0x2ADC, 0x27BB, 0x201A, 0x1928, 0x13A9, 0x0F53,
    0x0C68, 0x07FB, 0x02E6, 0xFBF8, 0xF5E6, 0xEF5F, 0xEBAD, 0xEBE8, 0xEAFC, 0xEA36, 0xEA10, 0xEAF7, 0xEC4E, 0xEC12, 0xEEE5, 0xF17D,
    0xF297, 0xF50C, 0xF3A2, 0xF270, 0xF01C, 0xEE08, 0xED0C, 0xEB3F, 0xEADF, 0xE91E, 0xE9F4, 0xEA42, 0xE7ED, 0xE565, 0xE01C, 0xDD2F,
    0xD981, 0xD63E, 0xD3D7, 0xD33F, 0xD39B, 0xD471, 0xD7B7, 0xD949, 0xDCE9, 0xDFFD, 0xE55C, 0xE699, 0xE719, 0xE96D, 0xEA7C, 0xEFDF,
    0xF0FF, 0xF5DE, 0xFE74, 0x0735, 0x10C1, 0x174A, 0x1D5A, 0x209C, 0x2629, 0x288F, 0x2ACD, 0x2CFA, 0x2EE1, 0x32C5, 0x33A7, 0x31D4,
    0x2E66, 0x2BB5, 0x257A, 0x1F35, 0x1788, 0x1196, 0x0CA5, 0x094A, 0x0704, 0x053E, 0x050F, 0x03A2, 0x0398, 0x0376, 0x0342, 0x028E,
    0x00C5, 0xFC5F, 0xF8DE, 0xF752, 0xF6B2, 0xF81F, 0xF7C8, 0xF77D, 0xF5AD, 0xF2CD, 0xEEF7, 0xE9D2, 0xE9C9, 0xE628, 0xE2C0, 0xE144,
    0xE138, 0xE48D, 0xE9FF, 0xEE6B, 0xF598, 0xFBC8, 0xFF71, 0x045A, 0x0355, 0x0414, 0x02FE, 0x0275, 0x02DB, 0x0539, 0x08DB, 0x0C35,
    0x10F0, 0x1432, 0x165B, 0x171D, 0x175F, 0x179A, 0x1897, 0x18D0, 0x18FF, 0x17DF, 0x16FE, 0x143F, 0x0FA7, 0x0B9D, 0x05AD, 0x0116,
    0xFE70, 0xFAB5, 0xF754, 0xF426, 0xF2F9, 0xF32D, 0xF2FE, 0xF570, 0xFA0A, 0xFFF9, 0x0434, 0x0519, 0x06B9, 0x08FC, 0x09FC, 0x0C4E,
    0x0F15, 0x11BD, 0x14FA, 0x17D5, 0x18E1, 0x17FD, 0x16AF, 0x134B, 0x1125, 0x1007, 0x0DF1, 0x0C50, 0x0A67, 0x0876, 0x05C5, 0x0355,
    0x017E, 0x01EF, 0x020D, 0x00EA, 0xFF23, 0xFAA3, 0xF4A3, 0xEEE8, 0xE9AA, 0xE86A, 0xE87F, 0xE942, 0xEB85, 0xEC21, 0xEEEE, 0xF244,
    0xF4A1, 0xF79A, 0xFB64, 0xFD8E, 0xFE2B, 0xFFDE, 0x01FD, 0x041F, 0x03CF, 0x01DD, 0xFF45, 0xFC02, 0xFA2A, 0xF8EF, 0xF921, 0xF7A1,
    0xF78A, 0xF933, 0xFA7A, 0xFC82, 0xFF52, 0x045A, 0x06EF, 0x0885, 0x0944, 0x0705, 0x0527, 0x0373, 0x018F, 0x0082, 0x0085, 0x0064,
    0x0085, 0x018A, 0xFFDE, 0xFF8C, 0xFDF7, 0xFBC4, 0xFB69, 0xF813, 0xF5FA, 0xF5AA, 0xF4F3, 0xF794, 0xF8B2, 0xFA9E, 0xFDAE, 0xFE90,
    0xFF55, 0xFB80, 0xF83D, 0xF650, 0xF3BC, 0xF216, 0xF1FA, 0xF17F, 0xF4EB, 0xF742, 0xF83F, 0xFA29, 0xFB15, 0xFD0A, 0xFE04, 0x0099,
    0x019B, 0x03B3, 0x04CD, 0x03B4, 0x0399, 0x0208, 0x00ED, 0xFFEF, 0xFCAD, 0xF82F, 0xF4C4, 0xF0E9, 0xEE0C, 0xEB97, 0xEC41, 0xEFFF,
    0xF44C, 0xF89F, 0xFC49, 0x026E, 0x04E8, 0x0908, 0x0B75, 0x0BEA, 0x0E04, 0x0F82, 0x146C, 0x186A, 0x1CDC, 0x1FAE, 0x1FEF, 0x1FCE,
    0x1E4B, 0x1C87, 0x1CCA, 0x1B6A, 0x19DA, 0x182E, 0x1716, 0x19A4, 0x1F14, 0x2578, 0x2CE2, 0x33B8, 0x3702, 0x38D3, 0x379C, 0x3386,
    0x2ECF, 0x2B4C, 0x28F3, 0x2704, 0x240B, 0x231D, 0x1F93, 0x1BC7, 0x17A6, 0x118B, 0x0C3A, 0x0600, 0x022A, 0xFD2F, 0xF721, 0xF1B7,
    0xEB0A, 0xE367, 0xDC9E, 0xD414, 0xCD40, 0xC783, 0xC221, 0xBCA3, 0xB70C, 0xB4C1, 0xB3FD, 0xB41A, 0xB537, 0xBA26, 0xBFA7, 0xC5E1,
    0xCB02, 0xCFCF, 0xD4FE, 0xDA0D, 0xDF76, 0xE5E3, 0xECF7, 0xF51F, 0xFF63, 0x085A, 0x1074, 0x15C5, 0x1C66, 0x213F, 0x2404, 0x2678,
    0x274E, 0x2980, 0x2A3B, 0x29E0, 0x2ACA, 0x2B77, 0x2C5A, 0x2CA3, 0x2B3F, 0x29E9, 0x271F, 0x2378, 0x1F37, 0x1AA2, 0x16A1, 0x143E,
    0x1455, 0x14BF, 0x120E, 0x103C, 0x0DAC, 0x0B85, 0x0A67, 0x09EB, 0x09D6, 0x080B, 0x05BD, 0x025B, 0x0092, 0xFDD3, 0xFB54, 0xF861,
    0xF3A7, 0xEEF1, 0xEA43, 0xE610, 0xE36C, 0xE230, 0xE0C6, 0xE194, 0xE2BD, 0xE4E7, 0xE7D3, 0xE9F3, 0xEC5C, 0xEECE, 0xF0A3, 0xF0AF,
    0xF21B, 0xF3C7, 0xF457, 0xF676, 0xF68E, 0xF755, 0xF9EF, 0xFB12, 0xFC22, 0xFC5C, 0xFC9A, 0xFC00, 0xFAB5, 0xF721, 0xF348, 0xF1BF,
    0xF15D, 0xF27B, 0xF55E, 0xF8E7, 0xFDA8, 0x00D2, 0x0110, 0x0088, 0xFCF9, 0xFDD6, 0xFEC8, 0x007D, 0x02E0, 0x053A, 0x09FC, 0x0DC3,
    0x1096, 0x1318, 0x16F8, 0x1B62, 0x1FCB, 0x2259, 0x267E, 0x29AA, 0x2B31, 0x2B8D, 0x2B08, 0x2A9D, 0x2A01, 0x26F7, 0x2355, 0x1E5B,
    0x1768, 0x0F94, 0x0754, 0x0111, 0xFCCE, 0xFA69, 0xFA7B, 0xF9FB, 0xF7F3, 0xF714, 0xF4CC, 0xF4D9, 0xF337, 0xF1EA, 0xF21A, 0xF109,
    0xF047, 0xF147, 0xF3EF, 0xF5F7, 0xF722, 0xF778, 0xF82E, 0xF69C, 0xF68F, 0xF593, 0xF37C, 0xF28E, 0xF167, 0xF33B, 0xF7FD, 0xFF79,
    0x07E4, 0x0EB4, 0x1435, 0x17B3, 0x18F9, 0x1995, 0x197E, 0x1A2A, 0x1C95, 0x1E1D, 0x1F43, 0x1F3A, 0x1F9C, 0x1F49, 0x1DD0, 0x1CD1,
    0x1B01, 0x1A68, 0x192D, 0x18A3, 0x169C, 0x159F, 0x14E8, 0x11D2, 0x0E41, 0x08BC, 0x0396, 0xFB42, 0xF2D6, 0xE953, 0xE02B, 0xDA4A,
    0xD5CF, 0xD065, 0xCCAF, 0xCC97, 0xCB6F, 0xCBE1, 0xCB3A, 0xCC29, 0xCD8A, 0xCF2C, 0xD09D, 0xD211, 0xD39C, 0xD5FB, 0xD95A, 0xDBB1,
    0xDFF4, 0xE4A9, 0xEA47, 0xEDA6, 0xF018, 0xF20A, 0xF2F4, 0xF4E0, 0xF77E, 0xFBBB, 0x02A8, 0x09B1, 0x10DE, 0x1676, 0x1B3C, 0x1F76,
    0x2222, 0x2403, 0x24CE, 0x23AE, 0x2331, 0x24A4, 0x24DA, 0x2755, 0x27E8, 0x27DD, 0x26F8, 0x25BA, 0x2545, 0x268A, 0x27FD, 0x282E,
    0x267C, 0x23C8, 0x2252, 0x1F46, 0x1DE3, 0x1B3B, 0x1730, 0x0F7E, 0x083B, 0x0195, 0xFAC2, 0xF6AC, 0xF3AB, 0xF3B7, 0xF345, 0xF3E1,
    0xF4AB, 0xF59A, 0xF551, 0xF55A, 0xF573, 0xF563, 0xF615, 0xF6F7, 0xF74C, 0xF59E, 0xF55D, 0xF4B7, 0xF4F5, 0xF4DB, 0xF3C2, 0xF357,
    0xF160, 0xEE1C, 0xE92E, 0xE2FC, 0xDF58, 0xDC15, 0xDBDD, 0xDB96, 0xDD57, 0xE1AE, 0xE582, 0xE8F2, 0xE9D1, 0xEB52, 0xED4E, 0xF000,
    0xF29A, 0xF73A, 0xFBBC, 0x01A2, 0x075B, 0x0C16, 0x1000, 0x15B2, 0x1B7A, 0x205C, 0x25BC, 0x291B, 0x2E87, 0x320B, 0x3535, 0x3839,
    0x392E, 0x3B00, 0x3BA4, 0x39C7, 0x35AB, 0x2F26, 0x27E5, 0x1E6B, 0x14EE, 0x0CA3, 0x05D9, 0x0153, 0xFDF0, 0xFAFE, 0xF758, 0xF46E,
    0xF256, 0xF112, 0xF169, 0xF1A9, 0xF0DD, 0xEFAD, 0xED49, 0xEDCF, 0xF009, 0xF2F6, 0xF60A, 0xF73F, 0xF794, 0xF4B1, 0xF2B9, 0xF003,
    0xED46, 0xEB25, 0xE9B1, 0xEAEB, 0xEC64, 0xEFCD, 0xF463, 0xF89A, 0xFB34, 0xFD0B, 0xFD2D, 0xFD3B, 0xFCA8, 0xFB36, 0xF9F8, 0xF828,
    0xF745, 0xF6C9, 0xF7F3, 0xF93D, 0xF913, 0xF97A, 0xFA63, 0xFB84, 0xFB19, 0xF9F7, 0xFB4C, 0xFEB8, 0x0169, 0x01CE, 0x0323, 0x030C,
    0x00FE, 0xFCD2, 0xF77A, 0xF1D4, 0xED07, 0xE9D2, 0xE900, 0xE821, 0xE727, 0xE8C9, 0xE9F8, 0xEC0D, 0xECFC, 0xEF45, 0xF27D, 0xF4AF,
    0xF67A, 0xF761, 0xF914, 0xFC16, 0xFF47, 0x044F, 0x0885, 0x0DA8, 0x12E4, 0x148B, 0x160C, 0x149A, 0x12DD, 0x1172, 0x117C, 0x107A,
    0x0FEA, 0x12C6, 0x132D, 0x13CB, 0x1248, 0x0ED0, 0x0D0A, 0x0A0B, 0x07A1, 0x0454, 0x0065, 0xFCD7, 0xF9D4, 0xF89C, 0xF6EA, 0xF64E,
    0xF5E2, 0xF4EC, 0xF4DB, 0xF599, 0xF73B, 0xF926, 0xFA0E, 0xFBAB, 0xFD39, 0xFF6F, 0x0275, 0x041D, 0x0601, 0x0377, 0x0143, 0xFD4D,
    0xFA44, 0xFABA, 0xF97A, 0xFD72, 0x014B, 0x0585, 0x09C6, 0x0D3D, 0x129B, 0x1524, 0x185D, 0x1BDB, 0x1E1F, 0x211E, 0x213C, 0x2173,
    0x220C, 0x232B, 0x24CB, 0x248C, 0x2343, 0x2127, 0x1D94, 0x1862, 0x1201, 0x0B1C, 0x060A, 0x01A4, 0xFF94, 0xFCD0, 0xFA4C, 0xF897,
    0xF62C, 0xF34C, 0xF096, 0xEE14, 0xEB4D, 0xEA93, 0xE82D, 0xE603, 0xE4FF, 0xE366, 0xE2E7, 0xE28A, 0xE293, 0xE3C5, 0xE425, 0xE51C,
    0xE622, 0xE732, 0xE8B1, 0xECDD, 0xF2C6, 0xF827, 0xFD0D, 0x01E9, 0x05A0, 0x065E, 0x06A8, 0x0565, 0x03B5, 0x011B, 0xFE7B, 0xFB81,
    0xF7BD, 0xF554, 0xF4EF, 0xF4CE, 0xF472, 0xF49C, 0xF45B, 0xF4A5, 0xF491, 0xF574, 0xF665, 0xF68B, 0xF71A, 0xF997, 0xFE37, 0x0369,
    0x0872, 0x0CB2, 0x0E97, 0x0B2F, 0x07D5, 0x0458, 0x00CB, 0xFFE9, 0xFF00, 0xFE4C, 0xFFC2, 0x0211, 0x0572, 0x0937, 0x0CEF, 0x1242,
    0x16BF, 0x1B4F, 0x1EEC, 0x21D7, 0x222F, 0x223B, 0x2301, 0x233A, 0x242F, 0x2424, 0x23D9, 0x22EB, 0x202A, 0x1D26, 0x18A0, 0x1384,
    0x10CE, 0x0E5F, 0x0D28, 0x0975, 0x052F, 0x0049, 0xF7BE, 0xEEC5, 0xE413, 0xD99E, 0xD136, 0xCA11, 0xC459, 0xBE5A, 0xBB0C, 0xBA32,
    0xB8FE, 0xB967, 0xBA5A, 0xBD7C, 0xC0E7, 0xC359, 0xC62A, 0xCA0B, 0xCE83, 0xD44E, 0xDC23, 0xE539, 0xEF34, 0xF8AD, 0x024C, 0x0A90,
    0x0FDD, 0x13A5, 0x1726, 0x19E6, 0x1D5E, 0x2151, 0x2673, 0x2C20, 0x304A, 0x32AF, 0x33A9, 0x355B, 0x355C, 0x3560, 0x35E9, 0x3568,
    0x3483, 0x31FE, 0x2FCA, 0x2F86, 0x3029, 0x3113, 0x313C, 0x30BA, 0x2EA8, 0x2CAC, 0x2B50, 0x2927, 0x28E7, 0x275C, 0x2615, 0x254F,
    0x231E, 0x1FA6, 0x1B5B, 0x1552, 0x0DB7, 0x0524, 0xFC20, 0xF3F7, 0xEDA2, 0xE877, 0xE175, 0xDD8B, 0xDB36, 0xDA0D, 0xDA2A, 0xD916,
    0xD7C3, 0xD65D, 0xD514, 0xD328, 0xD1C8, 0xD08C, 0xD34D, 0xD750, 0xDA8D, 0xDE61, 0xE0C1, 0xE377, 0xE53A, 0xE68A, 0xE626, 0xE51F,
    0xE7B6, 0xE9D7, 0xEBA7, 0xED98, 0xEF84, 0xF2AB, 0xF553, 0xF755, 0xFA06, 0xFD8E, 0xFFBD, 0x021A, 0x03D9, 0x045C, 0x0514, 0x06D1,
    0x07FE, 0x0999, 0x09FB, 0x099C, 0x09E1, 0x0975, 0x099D, 0x08CE, 0x0AA1, 0x0DDD, 0x14AD, 0x1C4D, 0x2071, 0x2432, 0x2635, 0x22C3,
    0x1FD1, 0x1D74, 0x1830, 0x13EB, 0x0E3C, 0x0762, 0xFFC7, 0xF96E, 0xF515, 0xF393, 0xF1C1, 0xEF8D, 0xED9B, 0xEB2C, 0xE84E, 0xE6C1,
    0xE66F, 0xE60D, 0xE617, 0xE5F4, 0xE7E4, 0xEABF, 0xED7A, 0xEDC7, 0xEE0B, 0xEC3D, 0xE9E9, 0xE7BB, 0xE5DA, 0xE658, 0xE734, 0xE94E,
    0xEB88, 0xEE5A, 0xF3DE, 0xFAFA, 0x01F8, 0x0848, 0x0D90, 0x1319, 0x180D, 0x1B7B, 0x1C4B, 0x1C4E, 0x1D4D, 0x1E3F, 0x1EA7, 0x1E23,
    0x1D00, 0x1C04, 0x1A5C, 0x18C8, 0x1674, 0x14E2, 0x1633, 0x17E7, 0x19DE, 0x1A23, 0x1B2B, 0x1B6B, 0x188F, 0x157C, 0x10B6, 0x0A7E,
    0x044C, 0xFDCD, 0xF6D9, 0xF033, 0xEA3E, 0xE658, 0xE383, 0xE2CC, 0xE252, 0xE16D, 0xE22E, 0xE1A1, 0xE1E7, 0xE1F4, 0xE2CA, 0xE823,
    0xEE0B, 0xF48A, 0xFABD, 0xFEEA, 0x0279, 0x038E, 0x0376, 0x031F, 0x0105, 0xFEE7, 0xFCF8, 0xFB8D, 0xF9ED, 0xF9A6, 0xFAE5, 0xFBA7,
    0xFC87, 0xFD34, 0xFEA4, 0xFFEA, 0x00F5, 0x0343, 0x0326, 0x03E5, 0x0549, 0x06DE, 0x0BC7, 0x0EB1, 0x1160, 0x1274, 0x10FD, 0x10A4,
    0x0FEB, 0x10B2, 0x129F, 0x15C8, 0x193B, 0x1B85, 0x1E5C, 0x1F82, 0x2115, 0x228B, 0x208E, 0x1D82, 0x1965, 0x147A, 0x1118, 0x0DB5,
    0x09EE, 0x0760, 0x070A, 0x067D, 0x05B8, 0x03E2, 0xFF6B, 0xFBE5, 0xF6B2, 0xF0E6, 0xEC87, 0xE8B8, 0xE818, 0xE74F, 0xE6E0, 0xE69A,
    0xE4A5, 0xE31F, 0xE0B3, 0xDEAB, 0xDCEC, 0xDA5A, 0xD8FC, 0xD727, 0xD5D2, 0xD4AF, 0xD2D8, 0xD343, 0xD40D, 0xD54A, 0xD62F, 0xD734,
    0xD970, 0xDA9D, 0xDC77, 0xDEAD, 0xE1BE, 0xE6CD, 0xEB1D, 0xF098, 0xF5D2, 0xF9A6, 0xFD94, 0x017D, 0x0708, 0x0A41, 0x0F1C, 0x14D6,
    0x1A41, 0x2110, 0x268D, 0x2ACC, 0x2D93, 0x2D58, 0x2D6E, 0x2BD2, 0x2812, 0x24D6, 0x1F01, 0x1905, 0x12FD, 0x0D25, 0x0949, 0x0698,
    0x05AF, 0x050C, 0x00DA, 0xFCA4, 0xF8E3, 0xF6F2, 0xF69E, 0xF6DD, 0xF87F, 0xFC85, 0x00B6, 0x0304, 0x068A, 0x07CA, 0x0821, 0x080D,
    0x064D, 0x03B9, 0x0114, 0x002F, 0xFF2E, 0xFCC5, 0xFABF, 0xF8E0, 0xF89C, 0xF9A6, 0xFACC, 0xFC38, 0xFBD7, 0xFBBB, 0xFD00, 0xFB62,
    0xFAB3, 0xFB11, 0xFAED, 0xFBC0, 0xFA9C, 0xFA74, 0xF942, 0xF73C, 0xF7D4, 0xF82B, 0xF946, 0xFC2A, 0x0063, 0x057B, 0x0AEE, 0x0F23,
    0x13E2, 0x1929, 0x1BFC, 0x1E5C, 0x1E6A, 0x1AE1, 0x1798, 0x121F, 0x0BB2, 0x063C, 0x00A5, 0xFE0B, 0xFB3F, 0xF9A6, 0xF6F6, 0xF3CB,
    0xF0E9, 0xED14, 0xEB23, 0xE8A0, 0xE772, 0xE8EF, 0xEA0C, 0xEC37, 0xEF0F, 0xF02B, 0xF180, 0xF128, 0xF273, 0xF3C0, 0xF42C, 0xF4E7,
    0xF3F8, 0xF41C, 0xF4AB, 0xF575, 0xF81B, 0xFA49, 0xFD27, 0xFFF6, 0x0114, 0x01D8, 0x0231, 0x0407, 0x0454, 0x04C8, 0x04A4, 0x043C,
    0x0611, 0x06E4, 0x06D3, 0x06D6, 0x0518, 0x03A5, 0x01DA, 0xFFA2, 0xFF13, 0xFD97, 0xFDBE, 0xFDF3, 0xFCFB, 0xFDC0, 0xFE4C, 0xFF5C,
    0xFF95, 0xFB97, 0xF70A, 0xF328, 0xEFFF, 0xEDA1, 0xEBF6, 0xECBD, 0xEF76, 0xF247, 0xF47E, 0xF60A, 0xF5A5, 0xF44A, 0xF374, 0xF2CA,
    0xF18E, 0xF2CF, 0xF688, 0xFA8C, 0xFED9, 0x0282, 0x0469, 0x070D, 0x0954, 0x08C7, 0x0A01, 0x08ED, 0x089B, 0x086C, 0x05BA, 0x056D,
    0x0550, 0x056B, 0x0607, 0x0601, 0x04DA, 0x02EC, 0x00CE, 0xFF70, 0xFC50, 0xFB52, 0xFAD8, 0xFAE3, 0xFB17, 0xF9CE, 0xF83A, 0xF549,
    0xF35B, 0xF0FA, 0xF0E9, 0xF081, 0xEF8C, 0xF0DC, 0xF1D0, 0xF353, 0xF6AA, 0xFA47, 0xFDB9, 0xFF4E, 0x006C, 0xFF7C, 0xFC17, 0xF869,
    0xF393, 0xEF90, 0xEBBB, 0xE7A2, 0xE6D0, 0xE685, 0xE7F1, 0xEA96, 0xEA75, 0xEB67, 0xEBC1, 0xED7E, 0xF0D3, 0xF69C, 0xFE1F, 0x0541,
    0x0DA0, 0x14C2, 0x1AF9, 0x2096, 0x24FC, 0x2976, 0x2BA0, 0x2B9A, 0x2B66, 0x2A96, 0x2A56, 0x2967, 0x287C, 0x2809, 0x279A, 0x2869,
    0x2886, 0x271D, 0x2576, 0x2362, 0x21FD, 0x214E, 0x1FAB, 0x1ED8, 0x1D12, 0x1AF9, 0x1766, 0x1186, 0x0C7E, 0x06D4, 0x02F6, 0xFEF6,
    0xFAA5, 0xF72A, 0xF395, 0xF168, 0xF008, 0xEFB0, 0xF0FE, 0xF1BA, 0xF379, 0xF38D, 0xF05E, 0xECC9, 0xE7BB, 0xE211, 0xDC61, 0xD6F6,
    0xD3EE, 0xD255, 0xD02F, 0xCF2D, 0xCDAC, 0xCAF2, 0xC8B2, 0xC77F, 0xC697, 0xC734, 0xC979, 0xCC51, 0xD0DB, 0xD649, 0xDC2F, 0xE25A,
    0xE751, 0xEBC7, 0xF07A, 0xF4A4, 0xF733, 0xF87C, 0xF9FC, 0xFAAA, 0xFC4A, 0xFE1E, 0x0056, 0x0478, 0x079C, 0x09C1, 0x0B5C, 0x0B72,
    0x0CA0, 0x100E, 0x12D2, 0x15D0, 0x1812, 0x19CC, 0x1B0A, 0x1D95, 0x1F62, 0x2099, 0x22C8, 0x240E, 0x25CF, 0x2560, 0x2652, 0x2765,
    0x27F8, 0x2996, 0x2914, 0x2A45, 0x2B78, 0x2AB4, 0x2A1F, 0x24C7, 0x1D39, 0x16D5, 0x0EC3, 0x07FC, 0x01A5, 0xFD36, 0xF934, 0xF58C,
    0xF181, 0xEBC1, 0xE76F, 0xE1C4, 0xDB87, 0xD7F6, 0xD371, 0xCF7F, 0xCEE7, 0xCF41, 0xD078, 0xD1AB, 0xD3B0, 0xD563, 0xD784, 0xD974,
    0xDA0E, 0xDBCA, 0xDCD4, 0xDE63, 0xE210, 0xE5D3, 0xEB7E, 0xF074, 0xF5B4, 0xF9D7, 0xFCA5, 0xFF55, 0xFF6B, 0x01B0, 0x032D, 0x067F,
    0x0AA8, 0x0CA2, 0x104B, 0x134A, 0x14D7, 0x1619, 0x166C, 0x17C0, 0x19A4, 0x1B54, 0x1CFA, 0x1E2C, 0x207D, 0x23EB, 0x28F2, 0x2E68,
    0x3302, 0x3707, 0x38F7, 0x37F5, 0x3519, 0x3088, 0x2BDD, 0x2736, 0x236C, 0x1EB2, 0x19A9, 0x15B5, 0x10EB, 0x0C99, 0x0550, 0xFEBF,
    0xF7F6, 0xF1BC, 0xEE36, 0xE9A0, 0xE879, 0xE731, 0xE60F, 0xE6C1, 0xE5D2, 0xE5C0, 0xE681, 0xE559, 0xE2B4, 0xDF96, 0xDBDA, 0xD8A0,
    0xD7A4, 0xD6F3, 0xD750, 0xD9B1, 0xDB8E, 0xDF5B, 0xE300, 0xE5D4, 0xEAA5, 0xEF35, 0xF55D, 0xFB7B, 0x010D, 0x0879, 0x0CF3, 0x11F5,
    0x150A, 0x15AB, 0x1749, 0x169D, 0x16A5, 0x15D5, 0x14DA, 0x14B2, 0x14BD, 0x15A3, 0x172F, 0x1A22, 0x1CE1, 0x1F4C, 0x20FA, 0x2006,
    0x1CDA, 0x184C, 0x1393, 0x0C6E, 0x0630, 0x00F9, 0xFB9B, 0xF839, 0xF278, 0xED0F, 0xE8AC, 0xE321, 0xDE97, 0xDBF1, 0xD9EA, 0xD85F,
    0xD69B, 0xD580, 0xD52A, 0xD753, 0xDB40, 0xDEA9, 0xE32B, 0xE59C, 0xE8A7, 0xEAEE, 0xEAAE, 0xEB38, 0xEABE, 0xEB2D, 0xEB13, 0xEBB2,
    0xEDC7, 0xEF2E, 0xF225, 0xF2B0, 0xF29F, 0xF37A, 0xF42B, 0xF71A, 0xFA12, 0xFDF8, 0x0166, 0x03B3, 0x067B, 0x0849, 0x0C39, 0x0F5C,
    0x132E, 0x173F, 0x1728, 0x18B1, 0x1A2C, 0x1C3A, 0x1FD1, 0x2311, 0x2785, 0x2AF3, 0x2DD4, 0x2F98, 0x2FB1, 0x2E83, 0x2BC3, 0x2943,
    0x2625, 0x22C4, 0x1FDC, 0x1D90, 0x1B4B, 0x1798, 0x13CD, 0x0F78, 0x0A7A, 0x0720, 0x023F, 0xFDF7, 0xF9EC, 0xF547, 0xF33A, 0xF162,
    0xF120, 0xF181, 0xF3F2, 0xF6AE, 0xF7E4, 0xFA78, 0xF9CE, 0xF9DD, 0xFA32, 0xF8DD, 0xFA2B, 0xFAFD, 0xFC80, 0xFC84, 0xFC37, 0xFB57,
    0xF8B1, 0xF82D, 0xF587, 0xF3B0, 0xF2C4, 0xF01C, 0xEF5E, 0xEE05, 0xED30, 0xEE5F, 0xEDA7, 0xED04, 0xECB3, 0xECC3, 0xED9F, 0xECF6,
    0xED65, 0xED60, 0xEEE2, 0xF387, 0xF832, 0xFEC0, 0x0463, 0x098B, 0x0CD4, 0x0D64, 0x0D3D, 0x0AE1, 0x09C4, 0x08BC, 0x08FC, 0x0965,
    0x0852, 0x0855, 0x0808, 0x086D, 0x07A2, 0x0610, 0x03B0, 0x00C3, 0xFEA8, 0xFCB1, 0xFC9A, 0xFDDB, 0xFFD4, 0x0349, 0x07CE, 0x0B33,
    0x0E68, 0x10DB, 0x116A, 0x0F8B, 0x0C24, 0x0975, 0x0761, 0x06DA, 0x04BE, 0x02A4, 0x0135, 0xFE62, 0xFC6C, 0xFA2B, 0xF8DF, 0xF7AE,
    0xF688, 0xF676, 0xF63D, 0xF6D1, 0xF623, 0xF5C1, 0xF5BD, 0xF462, 0xF357, 0xF136, 0xEE74, 0xEBE5, 0xE972, 0xE7AF, 0xE699, 0xE796,
    0xEBEB, 0xF1D4, 0xF93A, 0xFFCA, 0x0594, 0x0A23, 0x0BA7, 0x0C9E, 0x0C5E, 0x0CD4, 0x0CD0, 0x0C16, 0x0BA1, 0x0966, 0x07AD, 0x05CB,
    0x02EA, 0xFF3F, 0xFAE8, 0xF7A7, 0xF427, 0xF124, 0xEE0F, 0xEB4B, 0xEB3E, 0xEBEC, 0xEEDC, 0xF22C, 0xF400, 0xF677, 0xF5ED, 0xF4CC,
    0xF5DB, 0xF504, 0xF55A, 0xF6B5, 0xF78D, 0xF8DF, 0xF9DA, 0xFA55, 0xFB8B, 0xFD97, 0xFE25, 0xFF0D, 0xFF78, 0x0089, 0x01CD, 0x03BE,
    0x05CD, 0x05E9, 0x0707, 0x06EF, 0x0716, 0x088F, 0x08CE, 0x08F4, 0x07B0, 0x0551, 0x051F, 0x05E5, 0x08B9, 0x0DA1, 0x11ED, 0x16B2,
    0x1A88, 0x1D01, 0x1DF5, 0x1D3E, 0x1D85, 0x1C82, 0x1BC0, 0x1B11, 0x1AAE, 0x1A9C, 0x196A, 0x18CF, 0x1732, 0x1670, 0x14DC, 0x12A8,
    0x102B, 0x0B40, 0x0802, 0x04CB, 0x01C5, 0x011A, 0x00F6, 0x01B3, 0x02F8, 0x0392, 0x0298, 0x015F, 0x0028, 0xFE83, 0xFD66, 0xFBE5,
    0xFA4F, 0xF9B9, 0xF7E0, 0xF56A, 0xF33D, 0xF0AA, 0xEF43, 0xED7A, 0xED0B, 0xECA4, 0xED9A, 0xEFF3, 0xF10A, 0xF3B9, 0xF56B, 0xF7C7,
    0xF9ED, 0xFB57, 0xFBC9, 0xF97D, 0xF88F, 0xF6BF, 0xF5AB, 0xF564, 0xF4D3, 0xF7C1, 0xFA84, 0xFE2D, 0x0266, 0x0552, 0x07C0, 0x06D9,
    0x04A5, 0x0205, 0xFED1, 0xFC45, 0xF8E6, 0xF5B3, 0xF15C, 0xED7A, 0xEB4E, 0xE834, 0xE75D, 0xE54F, 0xE257, 0xE036, 0xDC0E, 0xDACF,
    0xDABA, 0xDD75, 0xE354, 0xE7E2, 0xEF35, 0xF604, 0xFD53, 0x030C, 0x0738, 0x0B88, 0x0CC0, 0x0FF4, 0x1204, 0x1334, 0x1616, 0x1726,
    0x189E, 0x19C9, 0x195E, 0x1A59, 0x1BDF, 0x1CEA, 0x1D82, 0x1D9F, 0x1E0F, 0x1E4E, 0x1FC1, 0x20F0, 0x220C, 0x2304, 0x2280, 0x2166,
    0x1C6E, 0x1689, 0x1038, 0x0BA1, 0x08D8, 0x0658, 0x0744, 0x081D, 0x0A49, 0x0C2C, 0x0C94, 0x0C48, 0x0AF5, 0x09C5, 0x07B3, 0x0536,
    0x01B7, 0xFDC4, 0xFA11, 0xF485, 0xEF4A, 0xEAF0, 0xE5A5, 0xE0E4, 0xDB27, 0xD568, 0xD020, 0xCAFC, 0xC802, 0xC5B8, 0xC5B8, 0xC721,
    0xC9BD, 0xCE43, 0xD210, 0xD65A, 0xDA54, 0xDE24, 0xE328, 0xE8E5, 0xEF08, 0xF52E, 0xFBF2, 0x01A7, 0x05C1, 0x0B08, 0x10BD, 0x1637,
    0x1B01, 0x1EA1, 0x2253, 0x2555, 0x27CF, 0x2AA8, 0x2DC0, 0x3087, 0x332E, 0x3553, 0x350F, 0x33EC, 0x3242, 0x2EA8, 0x2B8D, 0x27F3,
    0x252C, 0x2529, 0x25FB, 0x26EF, 0x281C, 0x294B, 0x284E, 0x26DE, 0x24A3, 0x217C, 0x1EEB, 0x1AAA, 0x15D8, 0x1072, 0x0B43, 0x0683,
    0x01F6, 0xFDF7, 0xF9AD, 0xF646, 0xF248, 0xEE2D, 0xE925, 0xE348, 0xDF12, 0xDB2D, 0xD846, 0xD6D0, 0xD5E8, 0xD665, 0xD66A, 0xD575,
    0xD6D3, 0xD6D8, 0xD6C9, 0xD7D0, 0xD82B, 0xDA85, 0xDC6D, 0xDE6F, 0xE05F, 0xE22A, 0xE463, 0xE639, 0xE84C, 0xE96C, 0xE9B5, 0xEA30,
    0xEACC, 0xEC15, 0xED41, 0xEF59, 0xF2D9, 0xF662, 0xFA3C, 0xFD7D, 0xFF0C, 0xFE9C, 0xFD16, 0xFCA0, 0xFCB7, 0xFE7A, 0x019A, 0x0508,
    0x0A21, 0x0E91, 0x1381, 0x1788, 0x1AC7, 0x1E30, 0x1F53, 0x20AD, 0x2126, 0x213C, 0x2175, 0x2049, 0x1F7C, 0x1DE2, 0x1B93, 0x18E6,
    0x15F5, 0x1284, 0x0D65, 0x081C, 0x01BC, 0xFBA6, 0xF81A, 0xF545, 0xF440, 0xF366, 0xF348, 0xF3B0, 0xF312, 0xF358, 0xF26A, 0xF1A3,
    0xF101, 0xEE32, 0xEC3D, 0xE9BC, 0xE785, 0xE64E, 0xE4E6, 0xE4D1, 0xE438, 0xE5A6, 0xE697, 0xE6E1, 0xE851, 0xE922, 0xECC1, 0xF0BD,
    0xF693, 0x0054, 0x07F1, 0x0E66, 0x123C, 0x1339, 0x128A, 0x0FC7, 0x0D1E, 0x09D3, 0x0986, 0x0A19, 0x0B8F, 0x0F7F, 0x128B, 0x1750,
    0x1BE4, 0x1F5F, 0x2423, 0x2671, 0x27D0, 0x28A8, 0x27DA, 0x276F, 0x2550, 0x2471, 0x2362, 0x2168, 0x1FC7, 0x1BAA, 0x16C1, 0x1059,
    0x0944, 0x0317, 0xFD88, 0xF927, 0xF4CA, 0xF1D0, 0xEFA7, 0xEE71, 0xEE2F, 0xED4E, 0xECA0, 0xEBB7, 0xEAA1, 0xE995, 0xE953, 0xE839,
    0xE615, 0xE41B, 0xE194, 0xE06A, 0xDFB1, 0xDD48, 0xDC2A, 0xDA93, 0xD7F8, 0xD67A, 0xD44F, 0xD48C, 0xD7D1, 0xDCCB, 0xE22C, 0xE6B2,
    0xEBB2, 0xEF6F, 0xF308, 0xF536, 0xF6FB, 0xFA4B, 0xFE6A, 0x032C, 0x0871, 0x0ECE, 0x15CF, 0x1C62, 0x227C, 0x2688, 0x28D3, 0x2C22,
    0x2DBF, 0x2EEA, 0x2E95, 0x2DAA, 0x2D21, 0x2BF4, 0x2B8E, 0x2951, 0x25F8, 0x20EA, 0x1AD6, 0x13E2, 0x0BDF, 0x0509, 0xFE5F, 0xF8CD,
    0xF4F2, 0xF1D6, 0xEFC9, 0xED90, 0xEB59, 0xE9EE, 0xE937, 0xE855, 0xE882, 0xE925, 0xE9DA, 0xEB80, 0xEC02, 0xEC4A, 0xED8C, 0xEE25,
    0xEF62, 0xF0A8, 0xF045, 0xF091, 0xEF63, 0xECFD, 0xEAFD, 0xE90B, 0xE898, 0xE98D, 0xEBBB, 0xED4D, 0xEF51, 0xF090, 0xEF30, 0xEDC7,
    0xEA49, 0xE7AB, 0xE674, 0xE5EC, 0xE7E0, 0xE99D, 0xED06, 0xF07F, 0xF4B4, 0xFAC2, 0xFF68, 0x046B, 0x071A, 0x08E9, 0x0B24, 0x0C81,
    0x0F22, 0x113A, 0x13FF, 0x1706, 0x179E, 0x17F7, 0x1673, 0x14B7, 0x12D3, 0x0E88, 0x0B7D, 0x06FE, 0x040F, 0x037E, 0x027A, 0x0133,
    0x0034, 0x0026, 0xFF5C, 0xFFDF, 0x0176, 0x034E, 0x05E0, 0x06DC, 0x0752, 0x07EE, 0x079E, 0x093D, 0x0B2E, 0x0D01, 0x0E62, 0x0FBA,
    0x109B, 0x1004, 0x10C4, 0x10B8, 0x11B7, 0x14CD, 0x17A7, 0x1B20, 0x1DB9, 0x1F1F, 0x1F11, 0x1C49, 0x1862, 0x1307, 0x0D65, 0x07BA,
    0x027B, 0xFEB0, 0xFB55, 0xF96B, 0xFA72, 0xFBA5, 0xFD9C, 0xFF93, 0x007C, 0x00C6, 0xFFB8, 0xFE26, 0xFCA1, 0xFC0B, 0xFA4E, 0xF8F6,
    0xF7F5, 0xF527, 0xF2CB, 0xEF1F, 0xEABF, 0xE620, 0xE13D, 0xDE5B, 0xDBFF, 0xDA8C, 0xDB41, 0xDC74, 0xDD78, 0xDFAB, 0xE2E6, 0xE6AA,
    0xEB33, 0xEF39, 0xF1EB, 0xF445, 0xF5F4, 0xF7AC, 0xF933, 0xF996, 0xFB28, 0xFCBA, 0xFE95, 0x0125, 0x0325, 0x04B4, 0x053D, 0x04FB,
    0x045C, 0x03C0, 0x054E, 0x0791, 0x09CE, 0x0BAB, 0x0BB0, 0x0B42, 0x0860, 0x0563, 0x033D, 0xFF9A, 0xFC58, 0xFA02, 0xF93C, 0xFB1D,
    0xFD5B, 0xFFF8, 0x035E, 0x056B, 0x068E, 0x0703, 0x0682, 0x0666, 0x0530, 0x03DA, 0x03C5, 0x041E, 0x05FD, 0x0738, 0x0784, 0x0651,
    0x03CB, 0x01A7, 0xFEDC, 0xFC18, 0xFA00, 0xF8AD, 0xF88E, 0xF862, 0xF83A, 0xF850, 0xF819, 0xF8E8, 0xF979, 0xFA10, 0xFB81, 0xFBED,
    0xFCDE, 0xFD77, 0xFE18, 0xFECD, 0xFF5C, 0x005C, 0x00CC, 0x00B5, 0xFF33, 0xFCFD, 0xF9D1, 0xF65D, 0xF45B, 0xF3A9, 0xF479, 0xF5E6,
    0xF8E0, 0xFB2C, 0xFC58, 0xFE84, 0xFF2E, 0xFE8F, 0xFDBB, 0xFB28, 0xF8DB, 0xF85D, 0xF7C3, 0xF807, 0xF87B, 0xFA35, 0xFC40, 0xFE86,
    0x0166, 0x0354, 0x0507, 0x0534, 0x05F7, 0x068C, 0x0726, 0x091A, 0x0BE9, 0x0F04, 0x0FFF, 0x0F58, 0x0DE6, 0x0B1B, 0x0911, 0x066A,
    0x0383, 0x015F, 0xFEB3, 0xFD9D, 0xFC0E, 0xFB10, 0xFB36, 0xFC31, 0xFF29, 0x01D2, 0x04F6, 0x07E7, 0x0A9D, 0x0DA1, 0x0F39, 0x1098,
    0x12A2, 0x14FC, 0x16E5, 0x17F8, 0x1836, 0x1660, 0x14CD, 0x126D, 0x0F4A, 0x0EFA, 0x0E07, 0x0DAB, 0x0EB4, 0x0E7E, 0x0ED6, 0x0E2C,
    0x0D2E, 0x0BCC, 0x0944, 0x07BA, 0x0460, 0x011A, 0xFE21, 0xFB50, 0xFA0C, 0xF89D, 0xF9A9, 0xFC50, 0xFEE2, 0x0251, 0x049F, 0x0729,
    0x0B90, 0x0D5D, 0x0BA7, 0x09F5, 0x08F9, 0x0863, 0x0739, 0x0475, 0x00C8, 0xFBD7, 0xF60A, 0xEF17, 0xE6DF, 0xDF41, 0xD876, 0xD2CA,
    0xCE6C, 0xC9D8, 0xC5FE, 0xC46B, 0xC428, 0xC615, 0xC82A, 0xC9DD, 0xCBC1, 0xCD79, 0xCFB5, 0xD26D, 0xD61A, 0xDA66, 0xDFB5, 0xE525,
    0xE991, 0xEDCC, 0xF1D3, 0xF56E, 0xF8E6, 0xFC81, 0x0011, 0x0440, 0x0988, 0x0FE2, 0x15FA, 0x1B74, 0x20CC, 0x242B, 0x26D2, 0x2802,
    0x277C, 0x26C7, 0x2561, 0x241A, 0x23A2, 0x23FD, 0x25F0, 0x293E, 0x2C0B, 0x2DF5, 0x2F20, 0x2F4A, 0x2E0F, 0x2CB8, 0x2AA6, 0x28D6,
    0x27E6, 0x2639, 0x260D, 0x251D, 0x22AF, 0x1FB8, 0x1B03, 0x151F, 0x0E81, 0x0844, 0x0231, 0xFBA8, 0xF601, 0xEFDD, 0xE9B9, 0xE519,
    0xE18B, 0xDFC6, 0xDD8B, 0xDB11, 0xD8B0, 0xD647, 0xD449, 0xD1D5, 0xD1FF, 0xD30B, 0xD49D, 0xD737, 0xD921, 0xDB14, 0xDC86, 0xDDA2,
    0xDDFF, 0xE03A, 0xE3C3, 0xE6B0, 0xEBE9, 0xF1BA, 0xF871, 0x0110, 0x0760, 0x0DAC, 0x141B, 0x1781, 0x1AC7, 0x1BDF, 0x1B14, 0x1AEA,
    0x1B82, 0x1D23, 0x1EAF, 0x2123, 0x2348, 0x2499, 0x25A6, 0x2578, 0x240C, 0x23B0, 0x2265, 0x20EA, 0x213F, 0x2126, 0x221D, 0x2302,
    0x21C3, 0x1F49, 0x1CA2, 0x1791, 0x11E3, 0x0CDC, 0x0677, 0xFFD0, 0xF91F, 0xF2A2, 0xEC96, 0xE817, 0xE543, 0xE2F5, 0xE249, 0xE261,
    0xE31D, 0xE4AF, 0xE5D9, 0xE809, 0xEA7E, 0xECF9, 0xF087, 0xF398, 0xF5D3, 0xF6BF, 0xF600, 0xF327, 0xEE99, 0xEB92, 0xE714, 0xE273,
    0xE31D, 0xE666, 0xEAA6, 0xEF12, 0xF3D5, 0xF89D, 0xFC47, 0xFEE4, 0x0044, 0x0146, 0x0035, 0xFE07, 0xFD79, 0xFC43, 0xFC7A, 0xFE1F,
    0x0035, 0x0411, 0x07F2, 0x0B3B, 0x0E51, 0x1000, 0x118B, 0x1346, 0x15E3, 0x17F1, 0x19B5, 0x1C4D, 0x1BF4, 0x1BA4, 0x19DB, 0x16F6,
    0x13BB, 0x0FA3, 0x0BB0, 0x061C, 0x0076, 0xFC80, 0xF8E7, 0xF514, 0xF2BD, 0xF14E, 0xF0A7, 0xF023, 0xF030, 0xF0ED, 0xF056, 0xEEE3,
    0xEE91, 0xEEA6, 0xEF22, 0xF0CA, 0xF1A8, 0xF16D, 0xF0D5, 0xEF4D, 0xECF8, 0xEA8D, 0xE96F, 0xE7CB, 0xE704, 0xE69E, 0xE6BE, 0xE8DB,
    0xEB47, 0xEE93, 0xF0E2, 0xF30D, 0xF488, 0xF5C4, 0xF596, 0xF391, 0xF318, 0xF28A, 0xF2F2, 0xF599, 0xF893, 0xFE66, 0x04F0, 0x0963,
    0x0E56, 0x1189, 0x14EE, 0x180D, 0x1B1F, 0x1EFD, 0x221A, 0x26BB, 0x29D5, 0x2CB0, 0x2FBB, 0x31A7, 0x3324, 0x33FB, 0x3403, 0x3232,
    0x2FE7, 0x2BCA, 0x2808, 0x24C9, 0x20E5, 0x1EA4, 0x1C42, 0x19FF, 0x17DC, 0x149F, 0x1140, 0x0D47, 0x0AD1, 0x0A0A, 0x0836, 0x0806,
    0x073F, 0x0650, 0x05FE, 0x0322, 0x0006, 0xFC20, 0xF823, 0xF3F2, 0xEF58, 0xEBD8, 0xE8CE, 0xE82E, 0xE665, 0xE453, 0xE3FE, 0xE244,
    0xE18F, 0xE00A, 0xDCF8, 0xD978, 0xD558, 0xD297, 0xD070, 0xD08E, 0xD2BE, 0xD616, 0xDAD1, 0xDE45, 0xE234, 0xE685, 0xE9BC, 0xEE9F,
    0xF2D1, 0xF733, 0xFC33, 0x00FB, 0x0788, 0x0CB3, 0x125F, 0x1621, 0x1896, 0x1AB5, 0x1A85, 0x1A62, 0x189E, 0x1552, 0x1199, 0x0E35,
    0x0B35, 0x08A5, 0x06D6, 0x0506, 0x0272, 0xFFC9, 0xFD13, 0xFA49, 0xF921, 0xF8F0, 0xFA36, 0xFBD9, 0xFE0A, 0x00C2, 0x0269, 0x04A6,
    0x04D4, 0x04E7, 0x041F, 0x02C0, 0x0288, 0x02EA, 0x0364, 0x0501, 0x0736, 0x08DD, 0x0CBF, 0x0E83, 0x1024, 0x11A3, 0x1112, 0x0EEB,
    0x0B33, 0x070D, 0x02F7, 0xFF03, 0xFB27, 0xF9B4, 0xF936, 0xF881, 0xF7DD, 0xF818, 0xF7CC, 0xF71C, 0xF79A, 0xF748, 0xF7DC, 0xF899,
    0xF942, 0xFA8E, 0xFAA6, 0xFB3B, 0xFBF0, 0xFC5C, 0xFC7C, 0xFB18, 0xF807, 0xF518, 0xF0DD, 0xEDE4, 0xEC03, 0xEAB4, 0xEB4F, 0xEAF1,
    0xEBE2, 0xECF2, 0xED4E, 0xEE0E, 0xEE50, 0xEFB4, 0xF187, 0xF334, 0xF5F2, 0xF87B, 0xFACE, 0xFBFF, 0xFB2F, 0xFAD6, 0xF94A, 0xF7E9,
    0xF7FF, 0xF7C0, 0xF842, 0xF981, 0xFCA3, 0xFF99, 0x045B, 0x0A32, 0x0FAA, 0x1573, 0x18AB, 0x1AD2, 0x1C48, 0x1C7D, 0x1C5F, 0x1C1D,
    0x1BE8, 0x1CAF, 0x1EBD, 0x20EA, 0x213E, 0x2281, 0x2375, 0x22F5, 0x2333, 0x2297, 0x21ED, 0x21B0, 0x2062, 0x1F56, 0x1E02, 0x1C35,
    0x1B2F, 0x1A98, 0x18C9, 0x1585, 0x1145, 0x0B5F, 0x0541, 0xFE5B, 0xF7CB, 0xF221, 0xEDAD, 0xE9F3, 0xE689, 0xE3C7, 0xE103, 0xDEDB,
    0xDD0A, 0xDBCD, 0xDBC1, 0xDD96, 0xE0CD, 0xE43B, 0xE8C2, 0xECC6, 0xEF7C, 0xF260, 0xF412, 0xF49F, 0xF52C, 0xF4AC, 0xF468, 0xF492,
    0xF43D, 0xF579, 0xF7AF, 0xFA3B, 0xFBEB, 0xFEB8, 0x005F, 0x00EA, 0x0265, 0x0102, 0xFF32, 0xFE13, 0xFBD4, 0xFA89, 0xFADF, 0xFACD,
    0xFB16, 0xFACB, 0xFA42, 0xFA54, 0xFA00, 0xFA00, 0xFA80, 0xFB45, 0xFAEF, 0xFAB0, 0xFC16, 0xFD20, 0xFF0F, 0x00A3, 0x00B2, 0x0018,
    0xFD40, 0xF5E3, 0xEAE7, 0xDDC6, 0xD46E, 0xD4E7, 0xE52A, 0xFE49, 0xFD69, 0xF342, 0xF532, 0xEFFD, 0xE95D, 0xE945, 0xE8C9, 0xE544,
    0xE741, 0xF859, 0x0685, 0x01D1, 0x056A, 0x0D8E, 0x0A06, 0x0A2E, 0x0BAB, 0x0A3C, 0x0A97, 0x0942, 0xFF38, 0xF830, 0xFBD4, 0x0755,
    0x18FA, 0x2316, 0x243E, 0x260B, 0x2DDD, 0x2ED5, 0x2059, 0x19E8, 0x16EC, 0x0D58, 0x0FDC, 0x11F1, 0x0E49, 0x1367, 0x1500, 0x0D7F,
    0x0815, 0x06FF, 0x045A, 0x0366, 0x03A0, 0xFCDD, 0xF81E, 0xF9AA, 0xFA6D, 0x0019, 0x0753, 0x07D2, 0x06B2, 0x08C0, 0x06BE, 0x000C,
    0xFBC5, 0xF3E0, 0xEB0B, 0xE9D3, 0xE94B, 0xE6F7, 0xE772, 0xE766, 0xE346, 0xE124, 0xE209, 0xE209, 0xE2AE, 0xE48C, 0xE283, 0xE083,
    0xE1C9, 0xE3D3, 0xE7C4, 0xECEB, 0xF143, 0xF435, 0xF9F3, 0xFF14, 0x009B, 0x01AB, 0x02EA, 0x0317, 0x067A, 0x0BD5, 0x102F, 0x13E2,
    0x1624, 0x1668, 0x1414, 0x1297, 0x1062, 0x0FC2, 0x10B7, 0x0DDB, 0x09A2, 0x0892, 0x07C7, 0x0744, 0x0917, 0x0B2D, 0x0F41, 0x1584,
    0x1A32, 0x1DEA, 0x1FF2, 0x1F11, 0x1EAE, 0x1F71, 0x20A5, 0x218F, 0x22BE, 0x23FD, 0x237B, 0x218F, 0x1D79, 0x1881, 0x1521, 0x0FCE,
    0x0A8C, 0x0464, 0xFE5D, 0xF941, 0xF355, 0xEE2C, 0xE816, 0xE44D, 0xE183, 0xDEBC, 0xDE0D, 0xDC95, 0xDAB8, 0xDA97, 0xD986, 0xD8B9,
    0xD6FF, 0xD5E3, 0xD56C, 0xD391, 0xD267, 0xD1B7, 0xD35C, 0xD5FC, 0xD967, 0xDDBA, 0xE1CF, 0xE5D8, 0xE97C, 0xECE0, 0xF02C, 0xF2C6,
    0xF656, 0xF9BE, 0xFD9C, 0x0186, 0x053B, 0x0964, 0x0BDC, 0x0E8D, 0x1220, 0x14CD, 0x1806, 0x1B71, 0x1DAE, 0x1FCC, 0x2161, 0x22F1,
    0x248C, 0x26E2, 0x28A8, 0x2A8D, 0x2C31, 0x2B92, 0x2996, 0x2677, 0x2274, 0x1E53, 0x1A53, 0x1640, 0x11BE, 0x0E50, 0x0B39, 0x081A,
    0x04A5, 0x0053, 0xFC7F, 0xF927, 0xF69B, 0xF41A, 0xF258, 0xF281, 0xF32D, 0xF316, 0xF375, 0xF416, 0xF453, 0xF362, 0xF129, 0xEE20,
    0xEA6A, 0xE6D3, 0xE5D2, 0xE672, 0xE78F, 0xEBF6, 0xF179, 0xF551, 0xFAB6, 0xFF20, 0x014E, 0x0401, 0x04C3, 0x06F7, 0x09E9, 0x0BF6,
    0x0F54, 0x1169, 0x14D2, 0x182C, 0x1C17, 0x200B, 0x2284, 0x26FF, 0x2A1E, 0x2AF2, 0x2B7E, 0x2C99, 0x2EDB, 0x318F, 0x33A5, 0x35C3,
    0x36A9, 0x36E8, 0x3604, 0x333B, 0x2F19, 0x2907, 0x2369, 0x1CBC, 0x155A, 0x0FC5, 0x09C1, 0x03BA, 0xFE7E, 0xF85E, 0xF2F1, 0xEDF5,
    0xE9C8, 0xE663, 0xE3DF, 0xE1F6, 0xE172, 0xE1E4, 0xE23C, 0xE36E, 0xE4A9, 0xE513, 0xE4E5, 0xE4A7, 0xE384, 0xE1BF, 0xE12F, 0xE0E8,
    0xE214, 0xE3C9, 0xE507, 0xE85E, 0xEB95, 0xED68, 0xEE0A, 0xEF2E, 0xEF7E, 0xEFC0, 0xF123, 0xF166, 0xF112, 0xF1FD, 0xF2FA, 0xF3CA,
    0xF649, 0xF926, 0xFB7D, 0xFD31, 0xFF34, 0x0200, 0x056F, 0x087C, 0x0C00, 0x119A, 0x1626, 0x1ABA, 0x1FE8, 0x23E3, 0x272D, 0x296F,
    0x2B36, 0x2BEF, 0x2BEB, 0x2B63, 0x2AAC, 0x289A, 0x2477, 0x1F9A, 0x1AED, 0x15D9, 0x10E1, 0x0B8B, 0x064F, 0x01BC, 0xFDCA, 0xFAAB,
    0xF838, 0xF85E, 0xF8CA, 0xF9FE, 0xFC53, 0xFD32, 0xFD75, 0xFCED, 0xF998, 0xF751, 0xF49F, 0xF195, 0xF09E, 0xF0C0, 0xF21D, 0xF3E5,
    0xF4A9, 0xF43F, 0xF3E3, 0xF326, 0xF2D3, 0xF150, 0xF013, 0xEF52, 0xED8C, 0xEC52, 0xEAFF, 0xEA9C, 0xEB3E, 0xEBA8, 0xEC4C, 0xEC5D,
    0xED87, 0xEDCB, 0xEC84, 0xED89, 0xEE8C, 0xEFE6, 0xF2EF, 0xF67B, 0xFBCF, 0xFFC2, 0x03E1, 0x084B, 0x0A1F, 0x0C58, 0x0D08, 0x0D37,
    0x0D8F, 0x0E0D, 0x0ED4, 0x0F1C, 0x0F0A, 0x0E33, 0x0DFA, 0x0EF2, 0x0FA2, 0x0FC4, 0x0FFD, 0x10ED, 0x12E9, 0x1533, 0x177D, 0x1BDD,
    0x202E, 0x23FC, 0x26F4, 0x28E2, 0x28E4, 0x269D, 0x23CD, 0x2075, 0x1DCD, 0x1C35, 0x1C9C, 0x1CCF, 0x1D98, 0x1E93, 0x1F2E, 0x1E75,
    0x1CF1, 0x1AAA, 0x177E, 0x130B, 0x0D99, 0x08BC, 0x0305, 0xFDB6, 0xF9AD, 0xF4C9, 0xF142, 0xEE53, 0xEAB0, 0xE838, 0xE61A, 0xE377,
    0xE101, 0xE0FF, 0xE0EA, 0xE203, 0xE493, 0xE7F5, 0xEAEB, 0xED64, 0xEF59, 0xF003, 0xF083, 0xF050, 0xF03B, 0xF0A6, 0xEF85, 0xEF04,
    0xF0AF, 0xF193, 0xF128, 0xF064, 0xEFE7, 0xEF82, 0xEF44, 0xEF40, 0xEFDA, 0xEF77, 0xF038, 0xF28F, 0xF49D, 0xF687, 0xF880, 0xF949,
    0xF896, 0xF68E, 0xF3F4, 0xF16E, 0xEFC6, 0xEFE2, 0xF0DB, 0xF2D0, 0xF558, 0xF7B8, 0xFA39, 0xFD3F, 0x0080, 0x02D7, 0x04CF, 0x06BF,
    0x085A, 0x07F3, 0x07AC, 0x0796, 0x079B, 0x088E, 0x0954, 0x0BE7, 0x0D21, 0x0D4B, 0x0E03, 0x0DAA, 0x0DB7, 0x0F3E, 0x11F3, 0x1509,
    0x17AC, 0x1A1E, 0x1C36, 0x1CF2, 0x1CD2, 0x1C44, 0x1AEF, 0x1823, 0x15F7, 0x14E2, 0x116F, 0x0E43, 0x0A1C, 0x041A, 0xFECD, 0xFA05,
    0xF583, 0xF0BF, 0xECB9, 0xE9DE, 0xE82B, 0xE66C, 0xE67B, 0xE78D, 0xEA99, 0xEF52, 0xF34F, 0xF633, 0xF8CC, 0xF925, 0xF7EE, 0xF609,
    0xF425, 0xF34B, 0xF374, 0xF457, 0xF5E7, 0xF7A1, 0xF8CF, 0xFB62, 0xFCE2, 0xFD9B, 0xFE70, 0xFFD7, 0x00F2, 0x02C4, 0x02F0, 0x0314,
    0x04EA, 0x075A, 0x0B50, 0x0E05, 0x1055, 0x1327, 0x154E, 0x15F8, 0x15B4, 0x15E7, 0x1739, 0x1834, 0x1A8A, 0x1BE0, 0x1D45, 0x1F78,
    0x2154, 0x22FF, 0x224F, 0x211E, 0x1E96, 0x1BF0, 0x18DF, 0x132F, 0x0E30, 0x097F, 0x03EA, 0xFE42, 0xF810, 0xF28D, 0xED73, 0xE7D3,
    0xE23F, 0xDDBF, 0xDA34, 0xD7D4, 0xD881, 0xDB1A, 0xDDF3, 0xE0F9, 0xE33B, 0xE61B, 0xE8FF, 0xE921, 0xE98B, 0xEA29, 0xEB98, 0xEE6C,
    0xF2C5, 0xF78C, 0xFBA3, 0x0246, 0x0862, 0x0E0B, 0x1301, 0x1738, 0x1998, 0x1A8F, 0x19FE, 0x1907, 0x17CA, 0x1631, 0x14EE, 0x13AF,
    0x135A, 0x115A, 0x0FDD, 0x0E40, 0x0C4F, 0x0A7A, 0x0929, 0x084B, 0x0804, 0x0752, 0x07E8, 0x092E, 0x0906, 0x0934, 0x0994, 0x08EF,
    0x084D, 0x069B, 0x0478, 0x026F, 0xFEE3, 0xFB17, 0xF7D3, 0xF609, 0xF336, 0xEFF6, 0xEC1C, 0xE7AB, 0xE36E, 0xE069, 0xDC78, 0xD9CE,
    0xD929, 0xD9A8, 0xDB35, 0xDCAE, 0xDEC1, 0xDEEA, 0xDFCB, 0xDF59, 0xDE32, 0xDDFA, 0xDE4D, 0xE019, 0xE23A, 0xE51A, 0xE8FE, 0xED68,
    0xF1D6, 0xF705, 0xFC19, 0x001A, 0x0376, 0x0697, 0x0864, 0x0981, 0x0AB3, 0x0B6F, 0x0CC7, 0x0E61, 0x10D6, 0x1453, 0x162F, 0x1765,
    0x184D, 0x184B, 0x185F, 0x18B8, 0x1A3F, 0x1C5D, 0x1ED7, 0x20D8, 0x22AD, 0x232C, 0x23F8, 0x24CB, 0x2420, 0x2315, 0x2146, 0x1FD9,
    0x1D76, 0x1ADB, 0x1778, 0x1359, 0x0DD2, 0x08A6, 0x031F, 0xFC99, 0xF64F, 0xF0BF, 0xEC4C, 0xE8DB, 0xE7B0, 0xE767, 0xE8DB, 0xEAF9,
    0xED7F, 0xF014, 0xF1AD, 0xF174, 0xF13F, 0xF083, 0xEF6D, 0xEDF6, 0xED2C, 0xED22, 0xEDFE, 0xF048, 0xF320, 0xF682, 0xF971, 0xFC54,
    0xFEA4, 0x0069, 0x0203, 0x0323, 0x04CE, 0x06DB, 0x0775, 0x0974, 0x0B75, 0x0D6A, 0x0EA2, 0x0E24, 0x0D59, 0x0B63, 0x0A40, 0x0993,
    0x0945, 0x0918, 0x0985, 0x0B01, 0x0BD1, 0x0C02, 0x0D1F, 0x0D3C, 0x0E9D, 0x100D, 0x0F60, 0x0FE5, 0x0F1F, 0x0E8F, 0x0CD8, 0x0B15,
    0x09A1, 0x0774, 0x05BB, 0x024E, 0xFF4E, 0xFACF, 0xF5E1, 0xF2EA, 0xEF13, 0xED3F, 0xECB4, 0xEDEB, 0xEFE2, 0xEFA8, 0xF0CE, 0xF16A,
    0xF207, 0xF180, 0xEEA6, 0xEBC7, 0xE820, 0xE59B, 0xE4A2, 0xE321, 0xE352, 0xE492, 0xE758, 0xEA94, 0xEC33, 0xED92, 0xED43, 0xEDF7,
    0xED87, 0xEBB7, 0xEC52, 0xED31, 0xEE57, 0xF15B, 0xF272, 0xF37C, 0xF460, 0xF54D, 0xF6B8, 0xF7A6, 0xFA71, 0xFE01, 0x024F, 0x0739,
    0x0B3C, 0x0E9C, 0x1312, 0x1693, 0x1B19, 0x1E09, 0x2091, 0x2259, 0x22EA, 0x2484, 0x2349, 0x2183, 0x2057, 0x1F39, 0x1EBB, 0x1B7B,
    0x15D5, 0x1043, 0x0975, 0x040E, 0xFEAD, 0xFAE7, 0xF984, 0xF72B, 0xF643, 0xF60A, 0xF4B1, 0xF2CC, 0xEF6D, 0xEC0D, 0xE4B5, 0xDA88,
    0xD439, 0xD05C, 0xD670, 0xE845, 0xF187, 0xEB01, 0xE870, 0xE976, 0xE687, 0xE646, 0xE603, 0xE3C4, 0xE1A9, 0xE052, 0xDCC8, 0xDA36,
    0xDDB2, 0xEAF7, 0xF030, 0xE9AA, 0xEB9F, 0xED3A, 0xED47, 0xEDA8, 0xEA45, 0xE97F, 0xED08, 0xFC7A, 0x12C1, 0x2018, 0x2EA5, 0x37F1,
    0x37E4, 0x3B4A, 0x3C39, 0x3D93, 0x3ED3, 0x3BB7, 0x3A84, 0x37A8, 0x351F, 0x38CC, 0x3E32, 0x40E7, 0x3C05, 0x311C, 0x256D, 0x1A6B,
    0x0F1E, 0x0307, 0xF79F, 0xF121, 0xEFCC, 0xF407, 0xFA7B, 0x00DF, 0x045F, 0x035D, 0xFD34, 0xF3EF, 0xEFD3, 0xE8A6, 0xE1B8, 0xDDD5,
    0xD766, 0xD433, 0xD7C9, 0xDE9D, 0xE6CB, 0xEC03, 0xED75, 0xEBBA, 0xE8AA, 0xE6FA, 0xE3B2, 0xE03E, 0xDE48, 0xDFF9, 0xE34B, 0xE893,
    0xF1FC, 0xF8A3, 0xF975, 0xF6A1, 0xF28A, 0xF06D, 0xED84, 0xEB61, 0xE9B4, 0xE692, 0xE560, 0xE73E, 0xECB0, 0xF356, 0xF9AD, 0xFDD0,
    0xFE24, 0xFC6E, 0xFAF5, 0xF7CE, 0xF5E7, 0xF625, 0xF79C, 0xF9D7, 0xFBDA, 0xFEDD, 0x0173, 0x035B, 0x02BB, 0x013B, 0x0121, 0x01CD,
    0xFF4C, 0xFDE8, 0xFD83, 0xFC69, 0xFE84, 0x00FA, 0x0561, 0x0ABE, 0x0F06, 0x0ECC, 0x0A69, 0x0751, 0x040B, 0x0170, 0x0161, 0x00C4,
    0x0299, 0x07A6, 0x0CE4, 0x12E1, 0x1770, 0x19A8, 0x1A85, 0x1988, 0x1820, 0x1501, 0x105A, 0x0C1F, 0x0816, 0x05E7, 0x0342, 0x0232,
    0x01E7, 0x01BD, 0x00F7, 0xFF3E, 0xFD71, 0xFA9E, 0xF833, 0xF634, 0xF52C, 0xF50C, 0xF62A, 0xF841, 0xFAEC, 0xFCAC, 0xFDA3, 0xFEB9,
    0xFF84, 0xFFC0, 0xFE96, 0xFD39, 0xFC9B, 0xFA96, 0xF7FD, 0xF491, 0xF27D, 0xF218, 0xF1A9, 0xF33E, 0xF3C5, 0xF401, 0xF5C0, 0xF740,
    0xF849, 0xFA04, 0xFCBD, 0xFF98, 0x023D, 0x05AF, 0x0822, 0x09FF, 0x0C4C, 0x0DD4, 0x103D, 0x1149, 0x12ED, 0x14C6, 0x14DC, 0x1599,
    0x15CE, 0x1578, 0x1650, 0x173D, 0x17BE, 0x1796, 0x1676, 0x152B, 0x132E, 0x115F, 0x0E7D, 0x0BEB, 0x0A8C, 0x0956, 0x0948, 0x090D,
    0x0835, 0x095B, 0x0BAA, 0x0DDD, 0x0F2F, 0x0FA1, 0x10A8, 0x0FDE, 0x0E5D, 0x0D12, 0x0AF0, 0x0902, 0x086C, 0x0883, 0x087E, 0x0695,
    0x0451, 0x00C3, 0xFBCE, 0xF54D, 0xEE5F, 0xE896, 0xE398, 0xE18E, 0xE055, 0xDFBF, 0xDF94, 0xDD8B, 0xD9AE, 0xD66F, 0xD2E2, 0xD189,
    0xD305, 0xD94E, 0xEA5A, 0x06F9, 0x0CE5, 0x0020, 0x0175, 0x00AA, 0xFDF0, 0xFC7F, 0xFE5A, 0xFC69, 0xF752, 0xF6ED, 0x0203, 0x107D,
    0x0D5D, 0x0AA0, 0x0D31, 0x0A1B, 0x042C, 0x00C1, 0xFDB9, 0xF962, 0xF9AE, 0x016F, 0x0309, 0x0371, 0x09D3, 0x0C4E, 0x08BD, 0x031F,
    0x0314, 0x09C2, 0x16C7, 0x1A3D, 0x103A, 0x0C3C, 0x0793, 0x074C, 0x0C3A, 0x0BE5, 0x0C6D, 0x108B, 0x16E6, 0x110E, 0x0835, 0x00D8,
    0xF449, 0xE715, 0xDEA6, 0xDD9F, 0xDE8C, 0xE2E0, 0xEBFE, 0xEC67, 0xE556, 0xE495, 0xE717, 0xEDFC, 0xF064, 0xEEBB, 0xEF98, 0xF0D3,
    0xF72D, 0xF8C4, 0xF41D, 0xF560, 0xF966, 0xFC11, 0xFEB1, 0x0028, 0xFF78, 0xFE56, 0xFF0C, 0x01C4, 0x050B, 0x0858, 0x0AB3, 0x0B42,
    0x0D72, 0x0D21, 0x094B, 0x097A, 0x0A63, 0x082F, 0x0798, 0x09E5, 0x0BAD, 0x0CCE, 0x0E01, 0x1005, 0x1277, 0x1553, 0x19EC, 0x1AD1,
    0x196C, 0x19E8, 0x17BD, 0x163F, 0x19A8, 0x1F5D, 0x2544, 0x2B5B, 0x2EB2, 0x2CFE, 0x291C, 0x277D, 0x24A3, 0x1DE8, 0x17B9, 0x1138,
    0x0B51, 0x0652, 0x03DB, 0xFF59, 0xF869, 0xF49E, 0xF04E, 0xEC8B, 0xE953, 0xE62C, 0xE223, 0xDDC2, 0xD8C4, 0xD588, 0xD4C5, 0xD3C8,
    0xD4B8, 0xD6C3, 0xD8FB, 0xDA6B, 0xDD0F, 0xDE7F, 0xDF54, 0xDFCA, 0xE0E5, 0xE482, 0xE850, 0xED02, 0xF0E4, 0xF4AD, 0xF85F, 0xFB0B,
    0xFEEA, 0x0253, 0x03E5, 0x0696, 0x08D7, 0x0A50, 0x0BCF, 0x0E45, 0x12C8, 0x1839, 0x1C1B, 0x1F3F, 0x20CF, 0x21FD, 0x233C, 0x236F,
    0x231E, 0x236F, 0x24A9, 0x2571, 0x2601, 0x25D6, 0x249E, 0x2118, 0x1D28, 0x1722, 0x10E4, 0x0A45, 0x02D1, 0xFC1C, 0xF5FD, 0xF225,
    0xEF45, 0xED8E, 0xED2D, 0xEBC0, 0xEC3E, 0xEC42, 0xEA41, 0xE972, 0xE615, 0xE2B8, 0xDF82, 0xDCEA, 0xDC56, 0xDBF2, 0xDBE5, 0xDCF3,
    0xDDF1, 0xDF62, 0xE029, 0xE0B0, 0xE072, 0xE22E, 0xE6BB, 0xEA2C, 0xF003, 0xF4D8, 0xF936, 0xFF6A, 0x0376, 0x06E6, 0x0A9B, 0x0C8C,
    0x0DCF, 0x0E21, 0x0E1F, 0x0E52, 0x0EC1, 0x112A, 0x1447, 0x189B, 0x1A72, 0x1BCD, 0x1DE6, 0x1DE6, 0x1E1A, 0x1DFA, 0x1E32, 0x1F4C,
    0x1FF1, 0x1FE4, 0x1FFF, 0x1CFC, 0x1A3B, 0x172A, 0x12F9, 0x0CB6, 0x0530, 0xFFFE, 0xFA3D, 0xF5E8, 0xF22E, 0xF02B, 0xF0AC, 0xF1C3,
    0xF25C, 0xF253, 0xF1C0, 0xF319, 0xF3DA, 0xF4A5, 0xF64A, 0xF6AB, 0xF742, 0xF889, 0xFAF3, 0xFD25, 0xFED2, 0x0218, 0x047A, 0x069C,
    0x08B4, 0x0964, 0x0B1E, 0x0B5F, 0x0C47, 0x0D21, 0x0D16, 0x0DA7, 0x0E89, 0x0E0F, 0x0CB7, 0x0A12, 0x075B, 0x0416, 0x003B, 0xFE7C,
    0xFE0F, 0xFFDD, 0x020C, 0x0433, 0x06C1, 0x082B, 0x0961, 0x0A8A, 0x0A13, 0x0ADD, 0x0BD5, 0x0E74, 0x123B, 0x13A1, 0x1468, 0x131F,
    0x10FB, 0x0F7E, 0x0D23, 0x0B1F, 0x07D0, 0x02F6, 0xFF61, 0xFB0C, 0xF7B9, 0xF541, 0xF3CF, 0xF374, 0xF24D, 0xF312, 0xF284, 0xF2B8,
    0xF365, 0xF04E, 0xEE40, 0xEC71, 0xE9BF, 0xE84F, 0xE578, 0xE3AB, 0xE442, 0xE389, 0xE438, 0xE4E3, 0xE4C8, 0xE49A, 0xE424, 0xE3FF,
    0xE386, 0xE334, 0xE1C8, 0xE10C, 0xE208, 0xE144, 0xE2AD, 0xE4D3, 0xE4EC, 0xE63D, 0xE702, 0xE768, 0xE8B8, 0xEA79, 0xEE4A, 0xF29A,
    0xF7A4, 0xFE25, 0x02B7, 0x08D3, 0x0C70, 0x10A8, 0x147D, 0x17DD, 0x1DB1, 0x215A, 0x2549, 0x2979, 0x2B95, 0x2CFA, 0x2C64, 0x2B18,
    0x298D, 0x24BA, 0x2042, 0x19EA, 0x163B, 0x1382, 0x1081, 0x0F46, 0x0CA1, 0x0B3B, 0x0A52, 0x07D6, 0x0783, 0x059C, 0x01FE, 0xFDF4,
    0xFA71, 0xF929, 0xF679, 0xF4F8, 0xF3B2, 0xF342, 0xF2F6, 0xF248, 0xF2C3, 0xF39A, 0xF36C, 0xF3BD, 0xF3D1, 0xF4C0, 0xF7D8, 0xFA08,
    0xFB9C, 0xFC8B, 0xFC65, 0xFB87, 0xF97D, 0xF82C, 0xF4EF, 0xEFC9, 0xED34, 0xEB6A, 0xE9F3, 0xEA60, 0xEAF8, 0xECB2, 0xEF25, 0xEF5B,
    0xF085, 0xF251, 0xF4F0, 0xF885, 0xFCE6, 0x01D4, 0x0703, 0x0D09, 0x1137, 0x1649, 0x1ABB, 0x1AE3, 0x1B40, 0x190B, 0x1693, 0x14F5,
    0x1154, 0x0F8D, 0x0F91, 0x0FAF, 0x1196, 0x134A, 0x1569, 0x16CF, 0x15E5, 0x14C9, 0x12A1, 0x11BC, 0x0FDB, 0x0E21, 0x0BF8, 0x0949,
    0x087E, 0x0733, 0x0570, 0x04E9, 0x0323, 0x0233, 0x01B2, 0x008D, 0xFFA2, 0xFE2A, 0xFCD6, 0xFBEF, 0xFB2E, 0xFADE, 0xFBDA, 0xFC41,
    0xFB17, 0xF81C, 0xF5E3, 0xF221, 0xEF3F, 0xECF5, 0xEB2B, 0xEC97, 0xEFA9, 0xF2A8, 0xF4B0, 0xF5A0, 0xF60C, 0xF4D6, 0xF3CB, 0xF3D6,
    0xF28A, 0xF2A4, 0xF47B, 0xF79E, 0xFA28, 0xFAD7, 0xFAAC, 0xFB03, 0xFB12, 0xFB0D, 0xF8A0, 0xF5E6, 0xF29C, 0xF02E, 0xEF6D, 0xEECA,
    0xF03A, 0xF151, 0xF459, 0xF6FC, 0xF7D0, 0xF8B8, 0xF8A8, 0xF8CB, 0xF82B, 0xF809, 0xF82E, 0xF7E6, 0xF86E, 0xF886, 0xF88B, 0xF907,
    0xFA18, 0xFAE1, 0xFC27, 0xFD0A, 0xFD6E, 0xFE8E, 0xFEF1, 0xFFBB, 0x00DA, 0x018A, 0x030D, 0x050E, 0x0717, 0x086A, 0x091D, 0x091A,
    0x0A79, 0x0AB7, 0x0A48, 0x0A03, 0x0B6F, 0x0CE7, 0x0ED8, 0x110B, 0x1105, 0x13A1, 0x13F4, 0x14BF, 0x15B6, 0x1726, 0x184E, 0x198D,
    0x1B15, 0x1BE5, 0x1C1F, 0x1B4C, 0x1983, 0x1602, 0x10F1, 0x0A6A, 0x03EE, 0xFBDD, 0xF394, 0xECC8, 0xE77E, 0xE4B7, 0xE1F0, 0xDF5C,
    0xDF2C, 0xDE08, 0xDE3D, 0xDE39, 0xDF75, 0xE026, 0xE148, 0xE380, 0xE5AD, 0xE8A6, 0xEB4E, 0xEEE9, 0xF293, 0xF740, 0xFB86, 0x0009,
    0x0383, 0x0826, 0x0BCD, 0x0FDD, 0x156D, 0x1A18, 0x1F84, 0x22E3, 0x25F4, 0x27A4, 0x2738, 0x2680, 0x24D8, 0x23D8, 0x2146, 0x1F62,
    0x1E1B, 0x1BF0, 0x19FC, 0x1890, 0x1761, 0x159E, 0x13C7, 0x1143, 0x0F1F, 0x0D65, 0x0D31, 0x0C0B, 0x0B10, 0x0BA7, 0x0C33, 0x0BCA,
    0x09DA, 0x0819, 0x0382, 0xFD97, 0xF651, 0xED5D, 0xE68B, 0xE013, 0xDC4C, 0xD961, 0xD8D1, 0xD9D0, 0xDA91, 0xDB18, 0xDB19, 0xDAEE,
    0xD9E9, 0xDB89, 0xDE0F, 0xDF88, 0xE169, 0xE3EF, 0xE5B6, 0xE8D3, 0xEB5D, 0xEE32, 0xF258, 0xF4B9, 0xF768, 0xFAC5, 0xFE4F, 0x0100,
    0x03DA, 0x0791, 0x0A06, 0x0D3F, 0x0ED5, 0x0F46, 0x0FE4, 0x0ED9, 0x0DE1, 0x0C9D, 0x0A6C, 0x08CD, 0x0812, 0x0784, 0x078E, 0x076C,
    0x06CB, 0x066E, 0x0776, 0x067D, 0x06A8, 0x06F5, 0x0749, 0x07D9, 0x0944, 0x0B8C, 0x0D5C, 0x0F87, 0x104F, 0x11D0, 0x1175, 0x118F,
    0x1030, 0x0E38, 0x09DD, 0x059C, 0x020D, 0xFED2, 0xFD1C, 0xFB5A, 0xFA94, 0xF87C, 0xF6EE, 0xF3FD, 0xF117, 0xED4C, 0xE9F7, 0xE795,
    0xE5A4, 0xE319, 0xE0F5, 0xDF9F, 0xDE3B, 0xDDA6, 0xDD3F, 0xDDF2, 0xDE93, 0xDF16, 0xDF3B, 0xE06D, 0xE2E9, 0xE550, 0xE8BF, 0xED8B,
    0xF00B, 0xF22F, 0xF4EA, 0xF67F, 0xF83B, 0xF953, 0xFB04, 0xFDF3, 0x00B1, 0x02A0, 0x03FD, 0x0698, 0x094A, 0x0CB4, 0x0F31, 0x10EC,
    0x14A5, 0x16BC, 0x1A06, 0x1DDE, 0x20FA, 0x2552, 0x29B7, 0x2E14, 0x3243, 0x34D7, 0x3702, 0x37BC, 0x36A2, 0x3364, 0x2EC6, 0x2B87,
    0x269B, 0x2315, 0x1EFA, 0x1B45, 0x1765, 0x12C4, 0x1024, 0x0BFD, 0x086A, 0x051A, 0x0206, 0xFDFC, 0xFA23, 0xF58D, 0xF122, 0xED2F,
    0xEA8E, 0xE75A, 0xE48C, 0xE345, 0xE0BA, 0xDFFB, 0xDD77, 0xDB52, 0xD8FF, 0xD8EE, 0xDAF1, 0xDC8C, 0xE029, 0xE315, 0xE62A, 0xE6DF,
    0xE766, 0xE8A6, 0xE945, 0xEA5C, 0xEB84, 0xEDA5, 0xEF8D, 0xF2F9, 0xF524, 0xF7C6, 0xF9FD, 0xFC88, 0xFFAB, 0x02B1, 0x0595, 0x0718,
    0x0AB4, 0x0B92, 0x0DB6, 0x0F78, 0x114F, 0x13AD, 0x14F1, 0x16E2, 0x15F8, 0x14B9, 0x1033, 0x0AC0, 0x052B, 0x0054, 0xFC84, 0xF89B,
    0xF6E9, 0xF71D, 0xF78E, 0xF762, 0xF843, 0xF829, 0xF8A1, 0xF86E, 0xF88B, 0xF907, 0xF7C3, 0xF82E, 0xF835, 0xF7D3, 0xF811, 0xF80A,
    0xF7F9, 0xF765, 0xF5A2, 0xF4AC, 0xF3EF, 0xF236, 0xF217, 0xF353, 0xF3D6, 0xF53C, 0xF600, 0xF585, 0xF574, 0xF48A, 0xF295, 0xF08A,
    0xF03E, 0xEF66, 0xEE58, 0xEF29, 0xEF28, 0xF12E, 0xF36F, 0xF511, 0xF804, 0xF9B2, 0xFCE9, 0x01BD, 0x0454, 0x0786, 0x0CFB, 0x11E7,
    0x182F, 0x1CDA, 0x213B, 0x2496, 0x25B3, 0x2700, 0x2588, 0x250A, 0x22C1, 0x1F2B, 0x1D56, 0x198F, 0x1647, 0x1346, 0x0F40, 0x0C62,
    0x081C, 0x0518, 0x0219, 0xFD8B, 0xFA23, 0xF60F, 0xF371, 0xF0ED, 0xEE03, 0xED69, 0xEC2B, 0xEBB4, 0xECBB, 0xEB66, 0xEC29, 0xEB56,
    0xEB20, 0xEC40, 0xECA2, 0xEED5, 0xF0CD, 0xF369, 0xF5B1, 0xF717, 0xF715, 0xF7BA, 0xF766, 0xF7DA, 0xF7ED, 0xF8F5, 0xFB1D, 0xFCDE,
    0xFEA5, 0xFE99, 0x0051, 0x00A4, 0x025B, 0x043D, 0x0447, 0x0503, 0x05B0, 0x078E, 0x093C, 0x0C40, 0x0FDC, 0x159F, 0x1AD1, 0x1FB7,
    0x2309, 0x23BD, 0x23CF, 0x2204, 0x1FEB, 0x1C4D, 0x18C5, 0x1423, 0x1100, 0x0CCE, 0x08E0, 0x05F3, 0x0238, 0x00A0, 0xFDD4, 0xFC2C,
    0xFA20, 0xF7FE, 0xF620, 0xF458, 0xF274, 0xF197, 0xF27B, 0xF264, 0xF36C, 0xF2DA, 0xF240, 0xF112, 0xF0AD, 0xEFC3, 0xED9C, 0xEDB3,
    0xEE8D, 0xF13C, 0xF3B5, 0xF718, 0xF8BD, 0xFA57, 0xF9E6, 0xF96D, 0xF8C7, 0xF5CE, 0xF4AC, 0xF2B2, 0xF21F, 0xF0BB, 0xF0C6, 0xF36B,
    0xF543, 0xF797, 0xF7A1, 0xF600, 0xF4FF, 0xF2BA, 0xF19C, 0xF2E2, 0xF224, 0xF42B, 0xF616, 0xF724, 0xF96F, 0xF842, 0xF8D1, 0xF730,
    0xF678, 0xF403, 0xF15A, 0xF26E, 0xF121, 0xF208, 0xF231, 0xF3AB, 0xF7BF, 0xFBCE, 0xFFC6, 0x02B9, 0x0260, 0x0386, 0x045B, 0x03CA,
    0x0393, 0x0258, 0x0423, 0x0456, 0x062E, 0x093C, 0x0926, 0x08E5, 0x082C, 0x08AD, 0x081D, 0x0868, 0x09DB, 0x0AC2, 0x0CF8, 0x0DD3,
    0x0FCC, 0x107C, 0x10AB, 0x1041, 0x0FE5, 0x0F98, 0x0F1F, 0x0E48, 0x0944, 0x0705, 0x04CE, 0x0125, 0xFE2F, 0xFC43, 0xFAA2, 0xF859,
    0xF637, 0xF415, 0xF33B, 0xF135, 0xF25B, 0xF44A, 0xF7CF, 0xFC60, 0x0043, 0x0425, 0x0504, 0x0774, 0x0831, 0x0A19, 0x0AB7, 0x09D6,
    0x0A42, 0x0947, 0x0842, 0x0708, 0x0792, 0x076A, 0x0876, 0x0A21, 0x0AEC, 0x0B11, 0x0ABB, 0x0A93, 0x0A17, 0x0A09, 0x0A02, 0x0B08,
    0x0A81, 0x0A60, 0x0991, 0x07E7, 0x06E1, 0x045A, 0x026B, 0xFF9F, 0xFE59, 0xFE26, 0xFDB1, 0xFDD9, 0xFCE5, 0xFB17, 0xF9EE, 0xF7AF,
    0xF636, 0xF51E, 0xF340, 0xF43C, 0xF478, 0xF53A, 0xF52F, 0xF4B8, 0xF720, 0xF7EF, 0xF8C6, 0xFB8C, 0xFC9F, 0xFE66, 0xFF55, 0x015A,
    0x0499, 0x0732, 0x0C10, 0x1015, 0x1468, 0x17A9, 0x1908, 0x1A37, 0x1865, 0x1575, 0x129D, 0x0E3D, 0x0A8C, 0x060A, 0x013D, 0xFD2A,
    0xF873, 0xF5A2, 0xF2D2, 0xEF9A, 0xED44, 0xE9C9, 0xE779, 0xE4FB, 0xE368, 0xE29A, 0xE359, 0xE54F, 0xE64B, 0xE852, 0xEA1F, 0xEB1F,
    0xEB43, 0xEC14, 0xED09, 0xEF19, 0xF015, 0xF170, 0xF4E3, 0xF7C5, 0xFBE5, 0xFFBD, 0x0331, 0x064D, 0x08D4, 0x0AD5, 0x0C77, 0x0DAF,
    0x0E3C, 0x0F35, 0x1023, 0x1145, 0x11BB, 0x11F9, 0x10E5, 0x0F88, 0x0D8C, 0x0A2B, 0x085A, 0x062B, 0x05A3, 0x06B5, 0x08AC, 0x0B7B,
    0x0E09, 0x10B2, 0x130E, 0x13AA, 0x13C0, 0x135B, 0x129C, 0x0FC1, 0x0BB9, 0x07F1, 0x02F0, 0xFE96, 0xFB15, 0xF816, 0xF5A1, 0xF491,
    0xF3FB, 0xF2F7, 0xEFDA, 0xEC95, 0xEA1B, 0xE8CD, 0xE842, 0xE7B1, 0xE918, 0xE9B3, 0xEB10, 0xEBE8, 0xEC4D, 0xEE2A, 0xEE8C, 0xF09E,
    0xF2AB, 0xF57B, 0xF9BA, 0xFDE0, 0x0348, 0x08A0, 0x0D68, 0x1203, 0x1658, 0x18C6, 0x1B5A, 0x1BC9, 0x1CE1, 0x1CCD, 0x1C51, 0x1D5A,
    0x1C8F, 0x1D38, 0x1D16, 0x1E62, 0x1F09, 0x1CF7, 0x1C00, 0x1A0A, 0x192B, 0x18AE, 0x17EB, 0x18C8, 0x1AC9, 0x1D03, 0x1EF0, 0x1FF7,
    0x2020, 0x1FC5, 0x1DEB, 0x1CFC, 0x1A70, 0x1805, 0x1498, 0x10EB, 0x0ED7, 0x0B0A, 0x09C7, 0x076C, 0x0522, 0x02C2, 0xFED8, 0xFB44,
    0xF5D1, 0xF05E, 0xEB11, 0xE780, 0xE3F2, 0xE203, 0xE092, 0xDF06, 0xDE29, 0xDBFE, 0xDA90, 0xD878, 0xD798, 0xD610, 0xD65F, 0xD685,
    0xD74F, 0xDA6D, 0xDC97, 0xDF45, 0xE057, 0xE265, 0xE455, 0xE6B1, 0xE858, 0xEB35, 0xEF66, 0xF2E1, 0xF879, 0xFC61, 0x00CA, 0x0380,
    0x066B, 0x0903, 0x0A5F, 0x0C27, 0x0C40, 0x0EAB, 0x10A5, 0x1408, 0x171A, 0x1BD2, 0x1FEA, 0x23D9, 0x2709, 0x28A4, 0x2B3F, 0x2A3C,
    0x28EF, 0x2543, 0x2211, 0x1DC6, 0x1977, 0x15FE, 0x1212, 0x0F5F, 0x0BCF, 0x0991, 0x067E, 0x0253, 0xFE63, 0xFB1D, 0xF85A, 0xF5BA,
    0xF3EA, 0xF2FC, 0xF1EF, 0xEFE5, 0xEF00, 0xEBF9, 0xE8D2, 0xE65D, 0xE48B, 0xE3BE, 0xE1D8, 0xE1E2, 0xE190, 0xE2BF, 0xE418, 0xE675,
    0xEA3E, 0xED6B, 0xF126, 0xF451, 0xF600, 0xF82F, 0xF99A, 0xFAB3, 0xFDF7, 0x009C, 0x040B, 0x0693, 0x0811, 0x08DE, 0x082A, 0x088B,
    0x07DA, 0x08BC, 0x09D7, 0x0ADD, 0x0E4B, 0x1164, 0x14C6, 0x1889, 0x1BEF, 0x1E99, 0x20D9, 0x2173, 0x2221, 0x2088, 0x1E08, 0x1AEF,
    0x1723, 0x13B9, 0x0FC2, 0x0D4D, 0x0A1E, 0x092D, 0x0818, 0x074E, 0x0647, 0x043F, 0x03AF, 0x0214, 0x021B, 0x0207, 0x0338, 0x03CF,
    0x0339, 0x02DC, 0x01F3, 0x017D, 0xFF59, 0xFE4A, 0xFCC0, 0xFC83, 0xFAE0, 0xFA02, 0xF98A, 0xF964, 0xF9AA, 0xF8E3, 0xF9A9, 0xF843,
    0xF78F, 0xF53B, 0xF4E6, 0xF318, 0xF134, 0xF10F, 0xEFCB, 0xEF9D, 0xED23, 0xEC42, 0xEAA7, 0xE867, 0xE718, 0xE717, 0xE902, 0xEB55,
    0xEED2, 0xF271, 0xF8B3, 0xFE99, 0x05A6, 0x0C30, 0x1289, 0x1805, 0x1B0D, 0x1E88, 0x1F46, 0x2108, 0x1FC8, 0x1F0E, 0x1ED5, 0x1D8D,
    0x1C7E, 0x1AB0, 0x19C8, 0x16EF, 0x1588, 0x126E, 0x0FB5, 0x0CCA, 0x08EE, 0x067F, 0x033F, 0x0083, 0xFDCF, 0xFC92, 0xF922, 0xF6B0,
    0xF3A3, 0xF12F, 0xEF9F, 0xEC27, 0xEA54, 0xE75F, 0xE6B7, 0xE52C, 0xE551, 0xE4C5, 0xE2FC, 0xE2AD, 0xE061, 0xDE9F, 0xDBBF, 0xD9D3,
    0xD99E, 0xDB4D, 0xDCAB, 0xDF38, 0xE211, 0xE285, 0xE3CE, 0xE3D0, 0xE4FE, 0xE4FB, 0xE5CF, 0xE735, 0xE946, 0xED66, 0xF0BD, 0xF711,
    0xFD6D, 0x049A, 0x0B1D, 0x11B3, 0x16FA, 0x1AB2, 0x1D20, 0x1F2C, 0x20E3, 0x20C5, 0x213F, 0x2184, 0x22BF, 0x21C0, 0x2119, 0x2048,
    0x1E5C, 0x1AE4, 0x1650, 0x1336, 0x0FF1, 0x0DBB, 0x0B8D, 0x0A00, 0x0870, 0x05D2, 0x030B, 0x0040, 0xFCBF, 0xF8A8, 0xF742, 0xF587,
    0xF438, 0xF30D, 0xF1C1, 0xF1E3, 0xF346, 0xF5D7, 0xF800, 0xFC81, 0xFF6F, 0x02BB, 0x0519, 0x0670, 0x0778, 0x0835, 0x0A45, 0x0C36,
    0x0E31, 0x0DB5, 0x0E79, 0x0D2E, 0x0A06, 0x06C8, 0x036B, 0x00F8, 0xFE71, 0xFDDC, 0xFD50, 0xFEE5, 0xFF94, 0x020B, 0x0452, 0x04AF,
    0x0557, 0x0546, 0x052C, 0x029E, 0x0129, 0xFD76, 0xFB2E, 0xF8C7, 0xF658, 0xF58B, 0xF47A, 0xF4F6, 0xF54C, 0xF717, 0xF7B1, 0xF911,
    0xF97A, 0xFA88, 0xFCC8, 0xFDD4, 0xFF72, 0xFFFF, 0x0198, 0x01DF, 0x02BF, 0x02CF, 0x03A9, 0x0481, 0x0439, 0x058E, 0x04C7, 0x0636,
    0x06AB, 0x08EF, 0x0AD2, 0x0B87, 0x0CB3, 0x0C79, 0x0B86, 0x0930, 0x07A0, 0x057A, 0x04E9, 0x0374, 0x02F3, 0x015C, 0xFFB1, 0xFE58,
    0xFB87, 0xFACA, 0xF7C3, 0xF592, 0xF364, 0xF128, 0xEF61, 0xEE41, 0xEFEC, 0xF1A8, 0xF4E3, 0xF842, 0xFBF8, 0xFD4D, 0xFDD1, 0xFDA5,
    0xFCD8, 0xFB9E, 0xF941, 0xF8DA, 0xF707, 0xF697, 0xF518, 0xF491, 0xF3B8, 0xF184, 0xF0F0, 0xEFB4, 0xEFBB, 0xEEEA, 0xEF8A, 0xEFEB,
    0xF09B, 0xF1DE, 0xF2B7, 0xF499, 0xF5A5, 0xF6B9, 0xF7A2, 0xF927, 0xF873, 0xF8A3, 0xF80C, 0xF716, 0xF7AC, 0xF758, 0xF98A, 0xFB52,
    0xFD31, 0xFCEA, 0xFDAD, 0xFDF8, 0xFD90, 0xFD89, 0xFCCE, 0xFFC6, 0x01E5, 0x03CB, 0x0596, 0x0799, 0x0899, 0x09CA, 0x0B49, 0x0ADB,
    0x0AB3, 0x0985, 0x091A, 0x0917, 0x0A16, 0x0B98, 0x0FA9, 0x13CE, 0x177B, 0x1BF7, 0x1E93, 0x2144, 0x20E3, 0x2100, 0x1F6E, 0x1D8F,
    0x1B85, 0x195D, 0x17B8, 0x1447, 0x120D, 0x0E38, 0x0ABF, 0x05ED, 0x0211, 0xFEC4, 0xFBC3, 0xF9C2, 0xF82E, 0xF703, 0xF584, 0xF5FB,
    0xF5A2, 0xF68A, 0xF569, 0xF57D, 0xF642, 0xF5FE, 0xF7D6, 0xF807, 0xFA39, 0xFB23, 0xFCEC, 0xFF0C, 0x006A, 0x02F1, 0x0447, 0x0598,
    0x0757, 0x09E1, 0x0B4A, 0x0D6B, 0x0EE0, 0x11BE, 0x1387, 0x1423, 0x14D2, 0x131D, 0x119F, 0x0DC3, 0x0AD0, 0x06F3, 0x0343, 0x01AC,
    0x005D, 0x00E3, 0x01DA, 0x0484, 0x0806, 0x0B86, 0x0C7C, 0x0D55, 0x0E26, 0x0CFB, 0x0BD3, 0x09C2, 0x0814, 0x05EE, 0x035B, 0xFFFB,
    0xFCFA, 0xF935, 0xF4A6, 0xF1D1, 0xEEA2, 0xEBBE, 0xE8B8, 0xE63B, 0xE4B9, 0xE430, 0xE2EE, 0xE1F3, 0xE244, 0xE150, 0xE13C, 0xE0D5,
    0xE03B, 0xE064, 0xE0D0, 0xE1BA, 0xE362, 0xE602, 0xE929, 0xED29, 0xF0C9, 0xF42A, 0xF7AA, 0xFA88, 0xFC70, 0xFF6C, 0x01A7, 0x0371,
    0x05FB, 0x06C7, 0x091F, 0x0A75, 0x0B08, 0x0B76, 0x0B5E, 0x0BE6, 0x0AD4, 0x097D, 0x07FB, 0x06C5, 0x05D8, 0x04F0, 0x04F8, 0x06C0,
    0x0941, 0x0D29, 0x1190, 0x1455, 0x15DC, 0x16B7, 0x1788, 0x1653, 0x156E, 0x1561, 0x15CE, 0x16D1, 0x1616, 0x15E5, 0x1569, 0x146C,
    0x12BA, 0x10F5, 0x1048, 0x0E61, 0x0C17, 0x094E, 0x057E, 0x028A, 0xFF4A, 0xFBCC, 0xF952, 0xF76E, 0xF892, 0xFA54, 0xF774, 0xF0F7,
    0xEC4C, 0xE8B6, 0xE57D, 0xE3CF, 0xE237, 0xE0D1, 0xDF65, 0xDEA2, 0xDEE2, 0xE171, 0xE2BB, 0xE271, 0xE167, 0xDDFD, 0xE02D, 0xE751,
    0xEDD8, 0xF4C6, 0xFADB, 0xFE26, 0x0133, 0x0390, 0x05EE, 0x08E6, 0x0AD0, 0x0E33, 0x11C2, 0x1786, 0x1CF0, 0x21FB, 0x27C0, 0x2B89,
    0x309B, 0x31F3, 0x3292, 0x333F, 0x3309, 0x32C6, 0x30E7, 0x2F4E, 0x2D20, 0x2A80, 0x266A, 0x21D2, 0x1DB5, 0x19AD, 0x150E, 0x1078,
    0x0B98, 0x077C, 0x0385, 0x0053, 0xFDDA, 0xFAB3, 0xF84E, 0xF647, 0xF2BE, 0xEEFC, 0xEA3B, 0xE74D, 0xE516, 0xE2CB, 0xE18E, 0xE147,
    0xE13C, 0xE146, 0xE200, 0xE303, 0xE486, 0xE53F, 0xE6E1, 0xE8AD, 0xEB26, 0xEC8A, 0xEF41, 0xF100, 0xF469, 0xF5C2, 0xF8EB, 0xF9AF,
    0xFB8F, 0xFB23, 0xFA44, 0xF9C6, 0xF9DF, 0xFBAD, 0xFED5, 0x04A5, 0x0C2B, 0x1579, 0x195A, 0x1DAB, 0x1C19, 0x1B93, 0x0673, 0x1DC1,
    0x32B5, 0x20F1, 0x241E, 0x268C, 0x2D37, 0x271B, 0x1EF9, 0x1AB1, 0x120B, 0x0581, 0xF208, 0xE213, 0xD80F, 0xA9EB, 0x8FC1, 0x92C6,
    0x9D36, 0xA8E5, 0xA84F, 0xB535, 0xABCA, 0xC106, 0xD12A, 0xEE06, 0xFD04, 0xCB06, 0xBFC0, 0xB96E, 0xC0C6, 0xC6BA, 0xCCC5, 0xD442,
    0xD90E, 0xE79C, 0xE946, 0xF4A2, 0xEED0, 0xF815, 0x280A, 0x5325, 0x6C2F, 0x69C9, 0x6014, 0x5C96, 0x52A5, 0x4976, 0x49F5, 0x2EFA,
    0x0E3B, 0xF45D, 0xDF30, 0xD6C9, 0xC45C, 0xBEAD, 0xC17A, 0xCC99, 0xD087, 0xDE52, 0xD750, 0xE394, 0xF6CB, 0x13F6, 0x3A27, 0x1BB0,
    0x0635, 0xF2B3, 0xF7D1, 0xF8B4, 0xFBA4, 0x02AB, 0x02BA, 0x110A, 0x0DE8, 0x1BD7, 0x1541, 0x0D99, 0x2A7E, 0x4D55, 0x6B53, 0x72DD,
    0x6D02, 0x6707, 0x5DD0, 0x4E96, 0x4DE6, 0x418D, 0x2760, 0x0BA8, 0xF130, 0xE197, 0xD274, 0xC46B, 0xBDFE, 0xC360, 0xBFE6, 0xCBC9,
    0xC363, 0xC4A9, 0xC9CA, 0xD501, 0xFE85, 0xF92A, 0xE570, 0xCED9, 0xCA50, 0xC885, 0xC754, 0xCCA0, 0xCA0F, 0xD385, 0xCF64, 0xDB47,
    0xDED1, 0xD48F, 0xE59B, 0x03ED, 0x314C, 0x5146, 0x5A46, 0x5C49, 0x5C50, 0x5217, 0x51D7, 0x5095, 0x444D, 0x2F45, 0x1866, 0x05B4,
    0xF676, 0xE4B8, 0xD5DB, 0xD98F, 0xD157, 0xDF14, 0xDAA2, 0xDAF0, 0xDC92, 0xDB65, 0x05A6, 0x16E0, 0x0E0C, 0xF002, 0xDFC1, 0xD856,
    0xD33A, 0xD73D, 0xD36A, 0xDCF4, 0xD97F, 0xE070, 0xED8E, 0xE10E, 0xE260, 0xF44C, 0x173D, 0x3D84, 0x4F35, 0x549C, 0x5577, 0x4B18,
    0x4613, 0x4450, 0x3F52, 0x2D57, 0x18F1, 0x02E4, 0xF137, 0xE09B, 0xCAB8, 0xCA8A, 0xBF0B, 0xC8F0, 0xC8E4, 0xCB13, 0xD046, 0xC6DF,
    0xE50B, 0x0374, 0x1198, 0xFF0B, 0xECB2, 0xE46D, 0xDDE9, 0xE2D8, 0xDF3D, 0xE984, 0xE939, 0xE975, 0xFAB5, 0xF58B, 0xED46, 0xF2F2,
    0x0B3C, 0x3396, 0x4ED5, 0x59AB, 0x6061, 0x5987, 0x5476, 0x504A, 0x4F84, 0x414A, 0x2D4E, 0x14B3, 0x0183, 0xF473, 0xDB18, 0xDA3E,
    0xCF61, 0xD7AB, 0xDBFB, 0xDDF6, 0xE8BC, 0xDAD5, 0xE6B1, 0x01FF, 0x1BE3, 0x16CA, 0x0667, 0x015A, 0xF6A4, 0xF656, 0xF212, 0xFCC3,
    0x0343, 0xFE1A, 0x0E93, 0x140A, 0x0925, 0x02A2, 0x08ED, 0x25FD, 0x46A7, 0x5587, 0x5E05, 0x5928, 0x566D, 0x4FD2, 0x50AC, 0x4BD1,
    0x411F, 0x3188, 0x2008, 0x16FA, 0xFE0B, 0xF86D, 0xE6D0, 0xE515, 0xE9CB, 0xE994, 0xF672, 0xEB39, 0xE545, 0xF116, 0x0E11, 0x1ACA,
    0x11F6, 0x03C8, 0xF088, 0xEDE0, 0xE7A1, 0xEA35, 0xF161, 0xEA9D, 0xF219, 0xFD5A, 0xFBAD, 0xF7F1, 0xF886, 0x0BBD, 0x2BDD, 0x40D4,
    0x5249, 0x553F, 0x5276, 0x4827, 0x4563, 0x40AC, 0x38D3, 0x2CB8, 0x1932, 0x0D7F, 0xF2B9, 0xE6BA, 0xD866, 0xD4A2, 0xD97F, 0xD7D2,
    0xE4FC, 0xE4C3, 0xDCA3, 0xDDD6, 0xF79F, 0x1009, 0x118B, 0x093F, 0xF7A3, 0xF793, 0xF403, 0xF40E, 0xFFC7, 0xFFFB, 0x03A6, 0x142A,
    0x1C93, 0x1BFE, 0x0FA2, 0x1230, 0x3BF2, 0x4E13, 0x6284, 0x61D4, 0x6F0A, 0x6202, 0x4E0B, 0x5703, 0x4835, 0x46C0, 0x2260, 0x1E1F,
    0x0C8B, 0xF6CC, 0xE4FE, 0xDA7C, 0xD270, 0xD581, 0xDAD4, 0xD22A, 0xDE16, 0xC54C, 0xE008, 0xEE38, 0xF394, 0x0A20, 0xF589, 0xEB42,
    0xF450, 0xE6A1, 0xDB03, 0xEBD6, 0xE371, 0xF7E2, 0x14B5, 0xE71A, 0x0971, 0x08CF, 0x0238, 0x4174, 0x34EC, 0x6792, 0x6335, 0x41F1,
    0x5A3F, 0x4A95, 0x51EE, 0x2B52, 0x2506, 0x426A, 0x13CC, 0xF3AD, 0xF76E, 0xEBC1, 0xDC5D, 0xD461, 0xC7CE, 0xF284, 0xDB57, 0xD6F8,
    0xEEA9, 0xF85F, 0xF4E5, 0xFDA6, 0x0820, 0xE4B0, 0xEAD2, 0xC311, 0xC722, 0xD022, 0xD61F, 0xC06F, 0xC5E3, 0xEA1D, 0xD249, 0xC7F8,
    0xD63A, 0xE6A3, 0xF525, 0x101D, 0x2C86, 0x400F, 0x3685, 0x46FB, 0x36A6, 0x3658, 0x4E4E, 0x3E83, 0x4030, 0x26AA, 0x260C, 0x1B6A,
    0x1787, 0x13EF, 0x0820, 0x24C4, 0x2408, 0x1463, 0x119B, 0x2A8D, 0x21AC, 0x3120, 0x1F87, 0x112F, 0xF5A2, 0xCD36, 0xC95B, 0xBE95,
    0xC6D4, 0xAEDD, 0xAD2A, 0xB7D4, 0xAFF1, 0xA69F, 0xABD8, 0xC059, 0xB193, 0xC27A, 0xE645, 0xEEA7, 0x0285, 0xE3E9, 0x27CC, 0x10C9,
    0xF660, 0x0B0F, 0xFEA5, 0x083D, 0xE3FE, 0xDA5B, 0xC439, 0xD2A8, 0xBDE0, 0xE906, 0xF952, 0xF289, 0xD65C, 0x0756, 0x1DD5, 0x04C9,
    0x4D8F, 0x2CC3, 0x3ED1, 0x3263, 0x2A5D, 0x40D4, 0x3E44, 0x2644, 0x33D8, 0x4AE9, 0x4879, 0x4A2E, 0x4685, 0x4E56, 0x5557, 0x77EA,
    0x732E, 0x7B9B, 0x7FFD, 0x7D1E, 0x68AC, 0x6880, 0x6D79, 0x4ED2, 0x5DB1, 0x455E, 0x193B, 0x264A, 0x1BF7, 0x078D, 0xF397, 0xFC0A,
    0xF268, 0x06FF, 0x1087, 0x086D, 0x142F, 0x2022, 0x40E4, 0x2B18, 0x3D49, 0x1CD1, 0x2E39, 0x1D30, 0x0BD1, 0x28D1, 0x15B0, 0x1910,
    0x0337, 0x2508, 0xFE92, 0xEDC7, 0x0879, 0x0B25, 0x1B31, 0x29EC, 0x4A8C, 0x25B8, 0x38DC, 0x2EF0, 0x12D4, 0x3866, 0x1652, 0xEBDC,
    0xFBCA, 0xF93F, 0xBE56, 0xDB1C, 0xC655, 0xA39D, 0xAEC5, 0xAA4A, 0xAD8D, 0x9C33, 0x8DAE, 0x950C, 0xA858, 0xA7DE, 0xA685, 0x980F,
    0x945F, 0x9A09, 0x9402, 0x9B5A, 0x9C3D, 0x9CCA, 0x9AB5, 0xA72F, 0xAEC6, 0x9165, 0xAB98, 0x9844, 0xA89D, 0xB44C, 0xC1F2, 0xCB4A,
    0xC835, 0xDE24, 0xC100, 0xDBEF, 0xDB6F, 0xC4A0, 0xCCF4, 0xE29C, 0xCABE, 0xC3DA, 0xB830, 0xBF66, 0xB0A2, 0xAEDB, 0xCC78, 0xB6D0,
    0xB68F, 0xBAA7, 0xCC16, 0xCE8E, 0xC71C, 0xCEC7, 0xC7A1, 0xA93A, 0xB304, 0xCACB, 0xB90E, 0xAC16, 0xC3C4, 0xC363, 0xCC73, 0xC521,
    0xC770, 0xC437, 0xCF6D, 0xDC93, 0xF2B6, 0x16EE, 0x150E, 0x1CA7, 0x1DCF, 0x23D4, 0x0DA1, 0x2781, 0x0F40, 0x0152, 0xF135, 0xEA82,
    0xF75A, 0xCD66, 0xD793, 0xCD7B, 0xDCF6, 0xF2DE, 0xE901, 0xDBA1, 0xFC0B, 0x2164, 0x0C54, 0x2A22, 0x3720, 0x2D0B, 0x26CE, 0x2625,
    0x214F, 0x20DD, 0x3009, 0x3230, 0x479B, 0x2F57, 0x3BC2, 0x3D1F, 0x5665, 0x5B69, 0x5B31, 0x7DAA, 0x77DD, 0x7D18, 0x7FFF, 0x7146,
    0x79FB, 0x7937, 0x5D77, 0x649C, 0x6846, 0x6CF9, 0x56A2, 0x400B, 0x2F18, 0x4C7B, 0x25D8, 0x23A9, 0x209D, 0x26F3, 0x3A1B, 0x258D,
    0x4BDD, 0x456E, 0x353B, 0x381F, 0x3BF4, 0x21DF, 0x1B6E, 0x0FB5, 0x2776, 0x17F5, 0x2666, 0x2EF8, 0x0E44, 0x2F93, 0x2C8B, 0x0BD1,
    0x2A2E, 0x3F59, 0x483C, 0x376D, 0x33C5, 0x4E82, 0x3485, 0x3E0A, 0x286C, 0x2D61, 0x3224, 0x15B3, 0x26E3, 0x13FF, 0xFCAB, 0x195D,
    0x06D7, 0x0A18, 0xF03B, 0xE422, 0x0FC9, 0xFE2B, 0xEE37, 0x067A, 0xFD96, 0x0197, 0x0DBD, 0xE8F2, 0xEE97, 0xF203, 0xE0C3, 0xFA01,
    0x07EB, 0xE888, 0x11C9, 0x054C, 0xE8D4, 0xF75E, 0xEEAF, 0x05F3, 0x2A74, 0x1637, 0x01E1, 0x0E4A, 0x1859, 0x1B62, 0xE33B, 0xE660,
    0xF911, 0xD643, 0xD145, 0xCC38, 0xC88C, 0xB0A7, 0xABD0, 0xABA6, 0xB515, 0xB414, 0xA399, 0xA758, 0xA3C8, 0xC5E4, 0xA5C5, 0xBD72,
    0xB205, 0xAA9F, 0xBA0E, 0xA198, 0xA8BF, 0x940C, 0xAF0C, 0xA495, 0x9E46, 0x9ADC, 0xAA07, 0x9A07, 0x925D, 0x9F67, 0xA443, 0xB3A7,
    0xB846, 0xB711, 0xAE3A, 0xB96A, 0xAF1C, 0xB18A, 0xABC0, 0xA61B, 0x9A48, 0xA236, 0x9BBF, 0x9C34, 0x9591, 0x92B2, 0x96B7, 0xA775,
    0x9E99, 0x98FA, 0xAB02, 0xA434, 0xBD19, 0xBE7B, 0xBD40, 0xB7CE, 0xBD7A, 0xB28E, 0xC0BD, 0xAE4A, 0xC116, 0xB6FC, 0xC021, 0xCC2C,
    0xB1AF, 0xC738, 0xB099, 0xCD0F, 0xCC46, 0xDDB6, 0xF0E9, 0xF30C, 0xFFA0, 0xFBAE, 0x04FF, 0x09CE, 0xF6D5, 0xF465, 0xF844, 0xF7AE,
    0xF18F, 0xF665, 0xE70E, 0xE078, 0xF927, 0xE807, 0xFB60, 0xFEA4, 0xFFB9, 0x05D3, 0xFA38, 0x17E4, 0x1BFE, 0x139C, 0x118F, 0x01D4,
    0xF6D2, 0x0C23, 0xF53A, 0xEB27, 0x0A73, 0x0238, 0xFE7E, 0xFA21, 0x04E8, 0xECBA, 0x0155, 0x0FF8, 0x02DB, 0x167D, 0x1CB2, 0x2383,
    0x2E7C, 0x1394, 0x1AE5, 0x22E8, 0x19CB, 0x19AD, 0x16CD, 0x2728, 0xFFD3, 0x0871, 0x017E, 0x044B, 0xFEA7, 0x027B, 0x01F5, 0xFD78,
    0x0A49, 0x1140, 0x2884, 0x2872, 0x23C2, 0x12AD, 0x1E6C, 0x187F, 0x1632, 0x263A, 0x26C0, 0x21CE, 0x424D, 0x367B, 0x34CC, 0x4152,
    0x2F83, 0x4AC3, 0x54EE, 0x57BA, 0x6E41, 0x5D47, 0x7128, 0x6BF6, 0x6753, 0x6A43, 0x6636, 0x6CC1, 0x5795, 0x5CF7, 0x59BA, 0x51C6,
    0x3630, 0x3F87, 0x2F92, 0x418F, 0x3119, 0x190F, 0x1CCB, 0x306C, 0x29BE, 0x335B, 0x3B78, 0x2187, 0x2892, 0x12D4, 0x2D35, 0x0772,
    0x0FBF, 0x151E, 0x1B15, 0x22E3, 0x11C3, 0x144A, 0x13B4, 0x1AB8, 0x23B0, 0x35A0, 0x48C0, 0x5DB5, 0x54F9, 0x5D92, 0x5603, 0x532B,
    0x586C, 0x4E8B, 0x3DCC, 0x41B3, 0x45E4, 0x2C66, 0x1E70, 0x1919, 0x0821, 0x195F, 0x15E1, 0x0392, 0x026D, 0x0DBE, 0x1C83, 0x1545,
    0x2741, 0x28C4, 0x1D69, 0x1672, 0x214C, 0x115D, 0x067E, 0x0930, 0x0F52, 0x09A1, 0x0641, 0x19B8, 0x0A1A, 0x00D1, 0x11F6, 0x25AA,
    0x2D3B, 0x30A5, 0x3F73, 0x42D9, 0x32BD, 0x374C, 0x219E, 0x20B4, 0x1FF2, 0x08A1, 0xF95D, 0xFFE5, 0xF461, 0xE270, 0xD3D1, 0xD859,
    0xE721, 0xCB82, 0xC7B6, 0xCD0D, 0xCE11, 0xD209, 0xDD75, 0xDCF7, 0xD3D0, 0xD917, 0xE613, 0xCB7A, 0xD6B1, 0xE2F8, 0xD716, 0xE692,
    0xF759, 0xF02B, 0xE25E, 0xE875, 0xEF81, 0xEB61, 0xFDD9, 0x1027, 0x0B5C, 0x1B64, 0x1B18, 0x133A, 0x0DF6, 0x0651, 0x115F, 0x08D0,
    0xF64E, 0x04E8, 0xF23C, 0xE55D, 0xE1DF, 0xDE51, 0xD491, 0xD837, 0xD195, 0xCE90, 0xC5C1, 0xC3E4, 0xE0A8, 0xD1E3, 0xD409, 0xCF9E,
    0xCC74, 0xC867, 0xC727, 0xC45B, 0xB881, 0xC191, 0xC863, 0xBBC8, 0xC0F6, 0xBC6C, 0xBC9B, 0xB34A, 0xAD34, 0xC092, 0xCD54, 0xC7A8,
    0xC677, 0xCDBB, 0xC332, 0xCBA1, 0xC3EA, 0xBFE2, 0xB28E, 0xBD77, 0xB663, 0xA81F, 0xA39A, 0xA46D, 0xA6D7, 0x9BF2, 0xA377, 0xA021,
    0xAB24, 0xA485, 0xB0C3, 0xC0E9, 0xB7B6, 0xC8C1, 0xBE6E, 0xB7D5, 0xC166, 0xB67A, 0xBE75, 0xB954, 0xC6E5, 0xC552, 0xC88D, 0xC73D,
    0xC332, 0xC2B9, 0xB6FE, 0xD674, 0xDA6B, 0xDF13, 0xE576, 0xED56, 0xE6E7, 0xE78B, 0xECA9, 0xDD0F, 0xDB5A, 0xD06A, 0xC914, 0xC3C2,
    0xB4EA, 0xAC32, 0xB198, 0xAE85, 0xB84B, 0xB674, 0xB2AF, 0xBAB2, 0xBDFC, 0xCAD9, 0xCCBD, 0xD5F9, 0xCFE2, 0xCD99, 0xCE6B, 0xCBCE,
    0xBC86, 0xBB87, 0xCC5E, 0xC515, 0xCAD5, 0xCCB3, 0xD443, 0xCADF, 0xC696, 0xD1A1, 0xDC4A, 0xE00F, 0xF48D, 0xF61B, 0xEF81, 0xF7DD,
    0xF047, 0xFD1D, 0xE9B1, 0xE9D5, 0xF8B7, 0xF142, 0xEED5, 0xE97A, 0xE7E1, 0xEA4E, 0xEBF6, 0xED2C, 0xE684, 0xEABE, 0xF147, 0xF709,
    0xFB3F, 0x0736, 0x073D, 0xFC3E, 0xFBB6, 0xF9B6, 0xF47B, 0xEBDC, 0xF540, 0xF291, 0xFAB5, 0x0318, 0x0842, 0x0660, 0x0067, 0x0D24,
    0x155B, 0x20E6, 0x3151, 0x3961, 0x3D81, 0x40A8, 0x4532, 0x4998, 0x46D0, 0x402E, 0x436B, 0x3E85, 0x380C, 0x3C25, 0x3123, 0x3276,
    0x34DF, 0x2E7B, 0x39AA, 0x2C50, 0x2EC9, 0x2EC3, 0x2BA5, 0x445D, 0x40E8, 0x3C64, 0x3EB1, 0x36DC, 0x2732, 0x2B79, 0x24DC, 0x2438,
    0x233E, 0x25D7, 0x297E, 0x28E7, 0x20E1, 0x22C9, 0x2AC1, 0x39C1, 0x4CE8, 0x532A, 0x61B2, 0x662A, 0x6A6C, 0x624E, 0x6448, 0x6148,
    0x5D60, 0x53AA, 0x5726, 0x5092, 0x3B60, 0x3AFD, 0x38B9, 0x24C6, 0x2B3E, 0x1DB4, 0x170F, 0x1EC9, 0x1C53, 0x2E44, 0x2CB0, 0x3845,
    0x3A7E, 0x3AD9, 0x33CF, 0x3A8D, 0x303E, 0x2C59, 0x2D19, 0x355E, 0x3D6E, 0x37FD, 0x3CBA, 0x2E9D, 0x3BDD, 0x441D, 0x4D6C, 0x5786,
    0x5FD3, 0x67E5, 0x666B, 0x6718, 0x673F, 0x62C0, 0x593F, 0x4B48, 0x4C51, 0x4C5E, 0x39C8, 0x32AD, 0x28C3, 0x2A2F, 0x2492, 0x1F38,
    0x1E5D, 0x182A, 0x18D7, 0x18D2, 0x26D3, 0x24A6, 0x24E7, 0x1DA3, 0x1700, 0x0D0C, 0x075E, 0x0B7F, 0x0328, 0x101D, 0x0FFF, 0x18E5,
    0x17B2, 0x0F76, 0x120D, 0x1504, 0x1C90, 0x259A, 0x315D, 0x32EA, 0x37E6, 0x3576, 0x335C, 0x2BBB, 0x25E3, 0x2054, 0x1472, 0x103B,
    0x0A9B, 0xF82D, 0xF2F0, 0xF4B9, 0xEB97, 0xEF75, 0xEF53, 0xEB84, 0xE642, 0xEEE0, 0xF721, 0xFC83, 0x02EA, 0x0520, 0x0414, 0xFC65,
    0xF693, 0xEF71, 0xF452, 0xF2B7, 0xF8BB, 0xFBC1, 0xFD99, 0xFE69, 0xF74C, 0xF050, 0xF3F8, 0x02D0, 0x07C1, 0x12B6, 0x18E6, 0x1578,
    0x17B2, 0x17C3, 0x1183, 0x0DAE, 0x00D8, 0xFE79, 0xF766, 0xEDE0, 0xE07F, 0xD7E8, 0xCF33, 0xC80C, 0xCC70, 0xC7DB, 0xC483, 0xC183,
    0xCFD3, 0xD89B, 0xDC71, 0xE0AA, 0xE637, 0xE404, 0xE30B, 0xDD58, 0xD4FE, 0xD87C, 0xDF8F, 0xE43F, 0xE3CF, 0xE444, 0xDBE8, 0xD806,
    0xD7D9, 0xE052, 0xDD0B, 0xE3C7, 0xFC11, 0xF7E2, 0xFE06, 0x051C, 0x03E7, 0x0BC0, 0xF9EB, 0xF97C, 0xFBF7, 0xEBB0, 0xDECE, 0xD9BB,
    0xCEB2, 0xCA43, 0xCEAF, 0xC172, 0xBFC9, 0xB7C3, 0xBD89, 0xC060, 0xC569, 0xCEFD, 0xCF1E, 0xCE17, 0xC8B8, 0xC161, 0xBC21, 0xBD79,
    0xB2DF, 0xB821, 0xBED3, 0xC22A, 0xB9DC, 0xB404, 0xB3B8, 0xB922, 0xBFA9, 0xC864, 0xD547, 0xDAD3, 0xE21D, 0xDD72, 0xE31C, 0xE31B,
    0xD5E4, 0xD093, 0xD732, 0xD2CF, 0xCE7A, 0xCB2C, 0xC579, 0xC480, 0xC2AD, 0xC7AD, 0xC6D5, 0xBCF6, 0xC01E, 0xC53C, 0xC840, 0xD2CD,
    0xD296, 0xD408, 0xCF4B, 0xC7A2, 0xC2A9, 0xC020, 0xB7DB, 0xBB49, 0xBEEA, 0xBE85, 0xC92F, 0xC3E8, 0xC2FF, 0xCA7B, 0xCF3A, 0xD2D5,
    0xE047, 0xE93C, 0xF715, 0xF534, 0xFD20, 0x02C8, 0xF67A, 0xF6B0, 0xF0D1, 0xF32C, 0xE9D3, 0xE439, 0xE008, 0xD616, 0xD533, 0xDD7D,
    0xD29D, 0xCF9F, 0xCA11, 0xCBA5, 0xD58C, 0xD95F, 0xE3F1, 0xDC9A, 0xE2AB, 0xE000, 0xDA0C, 0xD83A, 0xD381, 0xCEEC, 0xD134, 0xD53B,
    0xDC04, 0xD7D1, 0xCD0F, 0xCD1D, 0xCA4F, 0xCF13, 0xDF09, 0xE793, 0xF2E0, 0xFDB4, 0xFD26, 0x079B, 0x0AE5, 0x0606, 0x0500, 0x08EB,
    0x0826, 0x05AA, 0xFA7A, 0xF271, 0xF2C3, 0xEC97, 0xEF46, 0xE5B9, 0xDDD5, 0xDD3D, 0xD676, 0xE2EE, 0xE46E, 0xEF77, 0xF364, 0xF1A7,
    0xFC4F, 0xF3D7, 0xF2DE, 0xEFED, 0xF188, 0xF5F1, 0xFCAC, 0x00C9, 0x01F8, 0xFA87, 0x0068, 0x00A9, 0xFE36, 0x1A03, 0x22AF, 0x276E,
    0x348F, 0x380B, 0x422E, 0x3A90, 0x3C37, 0x3940, 0x2DC4, 0x3402, 0x2BC9, 0x1E85, 0x1A5F, 0x1C89, 0x0F48, 0x17BF, 0x0D84, 0x0FE3,
    0x0C77, 0x128B, 0x1DBA, 0x1C0B, 0x2358, 0x218E, 0x2071, 0x0AC0, 0x0A7A, 0x01FF, 0x0115, 0xFC50, 0x010C, 0x0C2C, 0x0C60, 0x0D30,
    0x0D88, 0x0E74, 0x1BB1, 0x279E, 0x34CA, 0x3FDA, 0x4527, 0x50C9, 0x5404, 0x4EAC, 0x460C, 0x4561, 0x3E41, 0x3980, 0x3002, 0x22B5,
    0x1899, 0x18DB, 0x1308, 0x1630, 0x16D8, 0x1544, 0x1025, 0x191B, 0x23C7, 0x2E27, 0x3328, 0x38B5, 0x3DC8, 0x3880, 0x3E01, 0x3425,
    0x3072, 0x2855, 0x37B6, 0x3D37, 0x3F87, 0x411A, 0x4052, 0x3C70, 0x3B13, 0x451F, 0x4F61, 0x5B89, 0x5944, 0x6276, 0x62E6, 0x635D,
    0x64FE, 0x57A0, 0x5215, 0x52AB, 0x5033, 0x48DB, 0x3E70, 0x3698, 0x282B, 0x267C, 0x2310, 0x1921, 0x0D6C, 0x0BC3, 0x090B, 0x120C,
    0x17B1, 0x1B20, 0x225F, 0x1CEC, 0x1D1C, 0x14E8, 0x17F9, 0x0EC4, 0x11BB, 0x15D2, 0x1F02, 0x25D7, 0x2313, 0x27EA, 0x269D, 0x2A7B,
    0x3393, 0x3F44, 0x4A02, 0x5031, 0x53F8, 0x5A6C, 0x5D19, 0x5D01, 0x5518, 0x5E11, 0x58A7, 0x5366, 0x4C44, 0x457F, 0x4113, 0x38D4,
    0x3915, 0x2B4B, 0x2598, 0x1D3D, 0x1C41, 0x1B19, 0x2414, 0x27AE, 0x2863, 0x309E, 0x2CBB, 0x2B93, 0x1FE2, 0x1724, 0x1521, 0x116A,
    0x167C, 0x1C52, 0x14D3, 0x0E04, 0x0B45, 0x1017, 0x10E1, 0x1DAF, 0x2674, 0x2C07, 0x367F, 0x395B, 0x3F8D, 0x3260, 0x301F, 0x25B2,
    0x1DEB, 0x1A77, 0x0F52, 0x0177, 0xF848, 0xEE62, 0xE904, 0xEBED, 0xE5FD, 0xE5F1, 0xDF77, 0xEABA, 0xF23D, 0xFDAE, 0x07CC, 0x0D43,
    0x13A0, 0x0EFD, 0x0DE7, 0x04A5, 0xFE0E, 0xF9C0, 0xFAB7, 0xFF5A, 0xFF3E, 0x01C8, 0x01B7, 0xFE0D, 0x0253, 0x058A, 0x13A3, 0x1BB3,
    0x2354, 0x2FB4, 0x306E, 0x3592, 0x2E3F, 0x2C61, 0x21CD, 0x1F19, 0x16C5, 0x08C6, 0x0079, 0xF202, 0xEEDC, 0xE666, 0xE585, 0xDAC8,
    0xD52B, 0xD29C, 0xD5FC, 0xD904, 0xDDBF, 0xE4D2, 0xDF5C, 0xE1A6, 0xDB43, 0xD5DF, 0xCFF3, 0xCB80, 0xC938, 0xCB78, 0xD112, 0xCA78,
    0xC5B8, 0xBE6F, 0xB939, 0xBA17, 0xBC3E, 0xC3E5, 0xC984, 0xCCA8, 0xD879, 0xDF76, 0xE022, 0xDED6, 0xE116, 0xE223, 0xE03B, 0xE48C,
    0xDE06, 0xD869, 0xD49F, 0xD700, 0xD462, 0xD465, 0xCF26, 0xC920, 0xC9FA, 0xC80E, 0xCE66, 0xCFBD, 0xD670, 0xD845, 0xD564, 0xD5A8,
    0xCF3E, 0xCA5F, 0xC8EB, 0xCB0D, 0xD19E, 0xD280, 0xD23D, 0xCF79, 0xCA24, 0xC401, 0xC6F3, 0xCD3C, 0xCE58, 0xD46F, 0xDDAE, 0xE19C,
    0xE5F1, 0xE3A2, 0xDEAE, 0xDE38, 0xD99C, 0xDA87, 0xD23F, 0xC6EA, 0xBFD8, 0xBAB0, 0xB73F, 0xB4AE, 0xB15F, 0xAB36, 0xADF0, 0xB377,
    0xB6C0, 0xBE3A, 0xC26E, 0xC670, 0xC92B, 0xC6A0, 0xC447, 0xBC7A, 0xB82A, 0xB2DF, 0xB725, 0xB896, 0xB87D, 0xB8F2, 0xB171, 0xB56A,
    0xB534, 0xBC6D, 0xC658, 0xCF99, 0xDA7F, 0xE650, 0xF37F, 0xF7ED, 0xF9C2, 0xFA21, 0xF944, 0xF600, 0xF2C2, 0xE8C0, 0xD9E9, 0xD30C,
    0xD00B, 0xCD7F, 0xCA48, 0xC691, 0xC33B, 0xC2DD, 0xC85F, 0xCEBB, 0xD6E0, 0xDD9D, 0xE44B, 0xE219, 0xE2BE, 0xDD1E, 0xD37A, 0xD03E,
    0xCE2D, 0xD5E2, 0xD2D9, 0xD6E8, 0xD2D6, 0xD101, 0xD11F, 0xD67C, 0xE209, 0xE84F, 0xF869, 0xFF0F, 0x0970, 0x0F6A, 0x0D43, 0x0BA8,
    0x0CB3, 0x0D13, 0x128E, 0x0C3B, 0x097F, 0xFF88, 0xFB45, 0xFE9B, 0xF36C, 0xEF46, 0xE0C3, 0xDEA2, 0xD98E, 0xD74A, 0xDC9E, 0xDAA8,
    0xE0D9, 0xE136, 0xDF18, 0xDFD1, 0xD5AA, 0xD119, 0xCE24, 0xD3FD, 0xD989, 0xE002, 0xE839, 0xE4F7, 0xEA1B, 0xED25, 0xF5F2, 0xFFEB,
    0x07F7, 0x0FE6, 0x19BF, 0x21E6, 0x25CC, 0x2468, 0x2402, 0x202F, 0x21C3, 0x2176, 0x1995, 0x15BC, 0x0B04, 0x09B5, 0x0467, 0x0323,
    0xFA1C, 0xF1D3, 0xEE6B, 0xEB4D, 0xF346, 0xF7EC, 0xFD85, 0xFFE2, 0x0522, 0x0599, 0x0230, 0x0031, 0xFC73, 0x00C4, 0x09C1, 0x0CAB,
    0x1567, 0x1248, 0x0E1C, 0x0C69, 0x0F08, 0x1A90, 0x246E, 0x319E, 0x39BD, 0x47A7, 0x4D52, 0x4DD0, 0x4DE6, 0x48E1, 0x418D, 0x3EC2,
    0x33CC, 0x22EA, 0x1323, 0x06E9, 0xFE24, 0xF9AB, 0xF247, 0xE8DA, 0xE4C7, 0xE19C, 0xE57A, 0xEC82, 0xF798, 0xFEF7, 0x0B9E, 0x1221,
    0x1684, 0x1185, 0x0A6E, 0x07D3, 0x07B2, 0x0937, 0x0D08, 0x0E9E, 0x0C5D, 0x0B6F, 0x0706, 0x116D, 0x186A, 0x2572, 0x3216, 0x41BF,
    0x4F6A, 0x5421, 0x56D0, 0x547F, 0x52A3, 0x5143, 0x5058, 0x4782, 0x3FAF, 0x345F, 0x2F97, 0x2DA6, 0x29D0, 0x23BC, 0x2091, 0x2168,
    0x2300, 0x2BBC, 0x327C, 0x3C81, 0x3FE2, 0x43C0, 0x4547, 0x4231, 0x3B4F, 0x3462, 0x32E3, 0x3398, 0x36DB, 0x39DA, 0x39E1, 0x3086,
    0x2BB3, 0x2912, 0x2A7C, 0x2E71, 0x2DFD, 0x3056, 0x3596, 0x3879, 0x365A, 0x32C3, 0x30A6, 0x2977, 0x2A8E, 0x22AD, 0x1A40, 0x13D7,
    0x0AEC, 0x0AE5, 0x0E38, 0x1083, 0x100B, 0x104D, 0x0EF9, 0x1548, 0x1AFB, 0x25BE, 0x2B38, 0x30B5, 0x32FB, 0x3548, 0x2E1C, 0x299E,
    0x22E9, 0x2209, 0x29CF, 0x2CFE, 0x3611, 0x32EE, 0x31E1, 0x2F62, 0x30E3, 0x36F6, 0x3EA1, 0x4412, 0x4D30, 0x54BF, 0x5789, 0x5723,
    0x54E8, 0x51F5, 0x530E, 0x5178, 0x4F88, 0x4803, 0x3E6B, 0x3812, 0x32E0, 0x2E0A, 0x25E2, 0x1EB9, 0x157C, 0x14A7, 0x1396, 0x19DC,
    0x1B0A, 0x2236, 0x2474, 0x265C, 0x2530, 0x19DF, 0x1003, 0x030D, 0xFF28, 0xF7DA, 0xF86B, 0xF470, 0xEB08, 0xE523, 0xE277, 0xE682,
    0xEA50, 0xF07A, 0xF9E5, 0x08E2, 0x185B, 0x22CE, 0x2A94, 0x300D, 0x3629, 0x3A21, 0x3D61, 0x39B8, 0x2FA5, 0x2687, 0x1FEC, 0x1B8F,
    0x13F3, 0x0A5F, 0x0010, 0xFB2E, 0xF8DF, 0xFE4E, 0x067B, 0x0E43, 0x1551, 0x1977, 0x1EED, 0x1C60, 0x13A0, 0x0BA8, 0x07E0, 0x0574,
    0x081B, 0x09DA, 0x0563, 0x011D, 0xF842, 0xF8D1, 0xFEAC, 0x04AC, 0x0E37, 0x18FA, 0x2454, 0x2A73, 0x2D7F, 0x2A53, 0x2759, 0x2276,
    0x1F0A, 0x19EC, 0x0FDA, 0x03C1, 0xF9C8, 0xF397, 0xEE42, 0xE827, 0xE113, 0xDB09, 0xD21C, 0xD0B0, 0xCFAC, 0xD0A4, 0xD2CA, 0xD39C,
    0xD7C2, 0xD4BC, 0xCEEE, 0xC678, 0xBF68, 0xBD26, 0xBCE2, 0xC266, 0xC56E, 0xC6F8, 0xC5B7, 0xC6AB, 0xCD02, 0xD4C1, 0xDD5D, 0xEA6C,
    0xF849, 0x07B0, 0x1204, 0x1341, 0x13CB, 0x1011, 0x1094, 0x0E53, 0x08B3, 0x0017, 0xF6CB, 0xF029, 0xEEDA, 0xEB93, 0xE688, 0xDF9D,
    0xD9A6, 0xD9C5, 0xD8D0, 0xDBF2, 0xDE02, 0xE0CC, 0xE298, 0xE3BF, 0xE1BC, 0xDA06, 0xD4FC, 0xCF0F, 0xCD13, 0xD150, 0xD405, 0xD342,
    0xCF1F, 0xCA16, 0xC9E8, 0xCCEC, 0xD035, 0xD702, 0xDD08, 0xEA22, 0xF282, 0xFAC7, 0xFEFD, 0xFDB2, 0xFFA0, 0xFB30, 0xF9A1, 0xEB7E,
    0xDA27, 0xCD9A, 0xC738, 0xC485, 0xBEBE, 0xBA65, 0xB31B, 0xAE47, 0xAC50, 0xAE75, 0xB0CC, 0xB74E, 0xBE36, 0xC5D7, 0xCE4C, 0xCDA2,
    0xCDE8, 0xCB4A, 0xCAF7, 0xCE80, 0xD3AD, 0xD814, 0xD72D, 0xD1B0, 0xCD32, 0xCB55, 0xCE59, 0xD08F, 0xD69A, 0xE1DF, 0xEC75, 0xF6F0,
    0xFB08, 0x001F, 0xFE4D, 0xFF08, 0xFF7E, 0xFEA0, 0xF4F0, 0xE88D, 0xE0E5, 0xD7A4, 0xD28C, 0xCC30, 0xC786, 0xC348, 0xBF58, 0xC36A,
    0xC8BE, 0xCC4D, 0xD5A0, 0xDAE1, 0xE316, 0xE45D, 0xE32E, 0xDF67, 0xD91A, 0xD863, 0xD7AE, 0xDCC0, 0xDFDA, 0xE13C, 0xDD43, 0xDC05,
    0xDD20, 0xDD88, 0xE2DE, 0xE634, 0xECF9, 0xF3C8, 0xF900, 0xFA4A, 0xF5EF, 0xF3B6, 0xF050, 0xEBCF, 0xE557, 0xDAF4, 0xD132, 0xCB21,
    0xC83A, 0xC6A8, 0xC3C1, 0xC0E3, 0xBF52, 0xC123, 0xC642, 0xCD4A, 0xD4D5, 0xDC22, 0xE3AA, 0xE7E9, 0xE7C5, 0xDF5C, 0xD62C, 0xD02E,
    0xCF47, 0xD3C0, 0xD6A6, 0xDB1D, 0xD8BB, 0xD918, 0xDA8E, 0xDFA8, 0xE9EE, 0xF0BC, 0xFBEA, 0x0903, 0x135C, 0x18C0, 0x1976, 0x1746,
    0x1780, 0x1645, 0x1752, 0x1210, 0x0903, 0xFE7A, 0xF781, 0xF1C6, 0xECFA, 0xE7F2, 0xE0A2, 0xDC57, 0xD9CB, 0xDC2D, 0xE0D8, 0xE89D,
    0xEF01, 0xF9CA, 0xFF2C, 0x0317, 0xFDD2, 0xF618, 0xF2AB, 0xEEB4, 0xF070, 0xF35D, 0xF265, 0xEC36, 0xE6AF, 0xE3BA, 0xE0DB, 0xE06C,
    0xE550, 0xEAB0, 0xF51E, 0xFD64, 0x04E7, 0x07D7, 0x0A1A, 0x0E5B, 0x1240, 0x1580, 0x12AF, 0x0D09, 0x09DA, 0x07CF, 0x0341, 0x0057,
    0xFA29, 0xF5D6, 0xF1E0, 0xF0E6, 0xF5BF, 0xFB4A, 0x023C, 0x0D47, 0x17C1, 0x1C3A, 0x1F2A, 0x1C38, 0x19BA, 0x18BA, 0x19E6, 0x1F3D,
    0x2022, 0x1B33, 0x151E, 0x1240, 0x1106, 0x12CF, 0x1885, 0x21C6, 0x2DEA, 0x3A9F, 0x430C, 0x4819, 0x49A4, 0x4823, 0x4897, 0x4A11,
    0x454E, 0x3C82, 0x33A4, 0x2C0D, 0x28F6, 0x25E9, 0x24A2, 0x1EA6, 0x1608, 0x0F9C, 0x0B73, 0x0A83, 0x0A37, 0x0CFB, 0x11A1, 0x14E0,
    0x12D6, 0x09BE, 0xFF61, 0xF356, 0xEA0B, 0xE7DA, 0xE939, 0xEABE, 0xE699, 0xE481, 0xE515, 0xEAAA, 0xF1E6, 0xFC45, 0x0B9B, 0x1D3E,
    0x2FD1, 0x3D6B, 0x467D, 0x4922, 0x4D44, 0x5153, 0x5227, 0x5123, 0x48FB, 0x41D0, 0x3C1B, 0x3708, 0x339B, 0x2E3A, 0x293A, 0x2367,
    0x22B3, 0x233E, 0x26F0, 0x2AFC, 0x2FB1, 0x3523, 0x3712, 0x3458, 0x2C79, 0x25A3, 0x1D2E, 0x1ACE, 0x1C50, 0x1E31, 0x1E02, 0x1ACC,
    0x16B0, 0x13E9, 0x1451, 0x16BD, 0x1BBF, 0x2478, 0x2F15, 0x3991, 0x423A, 0x44A7, 0x4639, 0x467C, 0x46AE, 0x44B1, 0x3C9B, 0x3398,
    0x28EB, 0x207D, 0x1823, 0x0F07, 0x076B, 0xFA8C, 0xF117, 0xEB2B, 0xE765, 0xE964, 0xEC14, 0xF341, 0xFC42, 0x0264, 0x06C4, 0x0852,
    0x0729, 0x0567, 0x070D, 0x0DFE, 0x136A, 0x15F4, 0x137B, 0x10EA, 0x11B1, 0x1180, 0x14E9, 0x1B90, 0x255B, 0x3148, 0x3A6C, 0x4027,
    0x432E, 0x44B8, 0x49C6, 0x4EAF, 0x4F82, 0x4A9F, 0x42AA, 0x3AB2, 0x3283, 0x2BEE, 0x2467, 0x1AF6, 0x127C, 0x0E01, 0x0C48, 0x0F09,
    0x1350, 0x1A00, 0x2404, 0x2BA6, 0x3054, 0x30B3, 0x29F4, 0x2064, 0x1A23, 0x18F2, 0x1B61, 0x1CD6, 0x1BE6, 0x1B05, 0x1940, 0x1675,
    0x1772, 0x18DE, 0x1CED, 0x24FE, 0x2DFA, 0x3503, 0x3888, 0x3859, 0x343A, 0x33F7, 0x3286, 0x2ABA, 0x2124, 0x14D9, 0x09A4, 0x0196,
    0xF968, 0xF421, 0xEE56, 0xE8DB, 0xE8CE, 0xEB7A, 0xF1F2, 0xF87E, 0x0177, 0x0BA8, 0x1435, 0x180B, 0x16FC, 0x12B0, 0x0987, 0x049E,
    0x024C, 0x04A9, 0x0561, 0x0084, 0xFBB0, 0xF82F, 0xF7E6, 0xFA40, 0x000E, 0x0944, 0x154D, 0x208B, 0x2B7C, 0x3030, 0x2F76, 0x30F3,
    0x3355, 0x32AD, 0x3023, 0x28D9, 0x2010, 0x1A7A, 0x1660, 0x1240, 0x0CE5, 0x0508, 0xFCBE, 0xF82D, 0xF3D0, 0xF39D, 0xF7F3, 0xFEA6,
    0x0870, 0x105C, 0x118B, 0x105F, 0x0984, 0x0082, 0xFBC2, 0xFBEF, 0xFC8D, 0xF907, 0xF3A4, 0xECC5, 0xE592, 0xDFA7, 0xDD15, 0xDBA6,
    0xE1C7, 0xE887, 0xF0A3, 0xF62E, 0xF517, 0xF561, 0xF845, 0xFEF5, 0x042C, 0x059A, 0xFF60, 0xF894, 0xF2F8, 0xEC75, 0xE575, 0xDD9E,
    0xD404, 0xCC4B, 0xC8C1, 0xC4FF, 0xC458, 0xC463, 0xC7E7, 0xCD18, 0xD112, 0xD363, 0xD358, 0xD015, 0xCB9D, 0xCD60, 0xD181, 0xD4E7,
    0xD5EB, 0xD445, 0xD2F1, 0xD220, 0xD3CB, 0xD5C6, 0xDC03, 0xE7F4, 0xF5D5, 0x0562, 0x1007, 0x1590, 0x1866, 0x1B07, 0x1C21, 0x194D,
    0x1365, 0x0845, 0xFF12, 0xF7D8, 0xF061, 0xEA46, 0xE1DA, 0xD8F9, 0xD22D, 0xCE6A, 0xCB83, 0xCAD8, 0xCE17, 0xD267, 0xD58B, 0xD76B,
    0xD5C1, 0xCEB2, 0xC425, 0xBB90, 0xB82F, 0xB741, 0xB59D, 0xB168, 0xADC0, 0xAA9C, 0xA94B, 0xAB7C, 0xAFC0, 0xB60C, 0xC0B9, 0xCCE7,
    0xD82B, 0xDF1F, 0xE2DC, 0xE759, 0xEAD6, 0xEF69, 0xF029, 0xEBC8, 0xE4EA, 0xDDE2, 0xD6C4, 0xD2FC, 0xD06C, 0xCC71, 0xCAF4, 0xCA81,
    0xCBD3, 0xCDC3, 0xD2B3, 0xDAA5, 0xE338, 0xEB5A, 0xF2B6, 0xF66F, 0xF240, 0xEB20, 0xE6C0, 0xE6D0, 0xE948, 0xEBF3, 0xEC34, 0xE9B9,
    0xE624, 0xE12E, 0xDE16, 0xDCB4, 0xDEF7, 0xE63E, 0xF02D, 0xF998, 0xFF35, 0x01DE, 0x03B9, 0x078B, 0x0811, 0x043E, 0xFF44, 0xF789,
    0xEF1A, 0xE74A, 0xE0A6, 0xD97F, 0xCEA4, 0xC47D, 0xBE2F, 0xB917, 0xB542, 0xB3A5, 0xB4F1, 0xB77D, 0xB866, 0xB96E, 0xB89D, 0xB467,
    0xB117, 0xB1CA, 0xB6FC, 0xBBEB, 0xBEE5, 0xC0D0, 0xC11D, 0xC135, 0xC38E, 0xC6D2, 0xCAEF, 0xD38D, 0xDF07, 0xEC24, 0xF6E8, 0xFDCE,
    0x0300, 0x08B6, 0x11E1, 0x179B, 0x1A77, 0x17F0, 0x1163, 0x0C51, 0x0842, 0x03E0, 0xFCFF, 0xF66F, 0xEF43, 0xE9E3, 0xE6F3, 0xE820,
    0xEC1A, 0xF2D6, 0xFA4E, 0x01C8, 0x0879, 0x052A, 0xFD01, 0xF3F6, 0xEE6B, 0xEDF9, 0xED0F, 0xECD6, 0xEA49, 0xE558, 0xE280, 0xE1CA,
    0xE237, 0xE525, 0xEC40, 0xF567, 0xFFD3, 0x04D7, 0x06FC, 0x0748, 0x0677, 0x080F, 0x05D8, 0x0106, 0xF6BD, 0xEB5B, 0xE1CE, 0xD88C,
    0xD061, 0xC9EC, 0xC479, 0xC14D, 0xC20F, 0xC368, 0xC6B9, 0xCDDA, 0xD826, 0xE30B, 0xEEDD, 0xF5AF, 0xF70C, 0xF513, 0xF251, 0xF14E,
    0xF291, 0xF511, 0xF38B, 0xF2F2, 0xF1A0, 0xF15A, 0xF562, 0xFB60, 0x051A, 0x108D, 0x207A, 0x2F90, 0x38E6, 0x3F4A, 0x436F, 0x484C,
    0x4B46, 0x4AFE, 0x47E7, 0x4191, 0x3BB7, 0x36EB, 0x3308, 0x2B6D, 0x22AD, 0x18D7, 0x0F97, 0x0798, 0x00B9, 0x0099, 0x0398, 0x09ED,
    0x0F52, 0x1613, 0x1758, 0x12C4, 0x0C99, 0x06BB, 0x0698, 0x08CE, 0x0C08, 0x0B2F, 0x0980, 0x060B, 0x030A, 0x0280, 0x0376, 0x084E,
    0x10CE, 0x1B9C, 0x237D, 0x27D7, 0x2982, 0x2BC9, 0x3115, 0x36FE, 0x39AF, 0x38AC, 0x3554, 0x3057, 0x2D99, 0x2B3C, 0x26B5, 0x2111,
    0x1B5E, 0x1582, 0x0F83, 0x0C78, 0x0C38, 0x0E3D, 0x12D3, 0x1904, 0x1E1E, 0x1F3D, 0x1C3D, 0x1787, 0x168B, 0x18D9, 0x1C56, 0x1FFF,
    0x1E8B, 0x1AEB, 0x1714, 0x12E2, 0x114E, 0x128F, 0x1931, 0x24CC, 0x3273, 0x3E40, 0x459F, 0x4A5E, 0x4D0A, 0x4E7B, 0x4E7E, 0x4B35,
    0x4638, 0x3DA3, 0x35CE, 0x2F79, 0x27DE, 0x20BC, 0x192E, 0x13D0, 0x0FF1, 0x0DDA, 0x0EF3, 0x13C5, 0x19AC, 0x20D1, 0x2865, 0x2D25,
    0x2CA8, 0x27F4, 0x2272, 0x1D58, 0x193A, 0x154E, 0x0FBD, 0x072B, 0xFEC6, 0xF813, 0xF3E7, 0xF2AF, 0xF447, 0xFAED, 0x06F6, 0x13A0,
    0x1CA7, 0x2343, 0x2AC8, 0x30DC, 0x3621, 0x3A69, 0x38A9, 0x329F, 0x2A22, 0x21C6, 0x1AAC, 0x1386, 0x0D0E, 0x069E, 0x0171, 0xFC9D,
    0xFA18, 0xFCC0, 0x00D3, 0x0813, 0x100C, 0x1624, 0x1954, 0x178A, 0x11CB, 0x0D13, 0x0C84, 0x0DCF, 0x117A, 0x1249, 0x10EA, 0x0EC9,
    0x0B82, 0x08EB, 0x0765, 0x09F4, 0x10B8, 0x1B8A, 0x23DC, 0x2AFB, 0x300C, 0x3399, 0x37C1, 0x3A8C, 0x3C96, 0x3A0E, 0x35C6, 0x2F9B,
    0x298E, 0x2371, 0x1C8D, 0x174F, 0x117D, 0x0C8B, 0x061A, 0x01B8, 0xFFE7, 0xFEB6, 0xFFA5, 0x0095, 0x0120, 0xFE87, 0xF862, 0xF16A,
    0xEC29, 0xE981, 0xE856, 0xE8D9, 0xE934, 0xE81D, 0xE713, 0xE5A5, 0xE3D3, 0xE5D3, 0xEBD9, 0xF3E7, 0xFC6B, 0x0260, 0x0762, 0x0BB4,
    0x1029, 0x14AC, 0x1942, 0x1C0A, 0x1B61, 0x1B07, 0x1AD2, 0x1A12, 0x1702, 0x1186, 0x0B98, 0x0482, 0xFDFB, 0xF936, 0xF7FF, 0xFB68,
    0x0139, 0x0B84, 0x1414, 0x18EF, 0x1801, 0x149C, 0x1089, 0x0D32, 0x0BF8, 0x0BA5, 0x0B25, 0x01C6, 0xFD7F, 0xFB6D, 0xFB6C, 0x0259,
    0x0C30, 0x10A1, 0x142A, 0x1CF0, 0x2251, 0x27EB, 0x2B20, 0x2E97, 0x302C, 0x2F63, 0x2A7A, 0x2330, 0x1849, 0x09BA, 0xFB03, 0xEAE5,
    0xDCB5, 0xCF66, 0xC6F7, 0xBA38, 0xB431, 0xB9AB, 0xBE03, 0xC39F, 0xC42D, 0xC60F, 0xC4C8, 0xC44A, 0xC419, 0xC46B, 0xC92B, 0xC6D7,
    0xC50C, 0xC46B, 0xC644, 0xC973, 0xD252, 0xD972, 0xDE85, 0xE93E, 0xF761, 0x0620, 0x134D, 0x1F5D, 0x2207, 0x2694, 0x2BED, 0x2E1C,
    0x2E36, 0x2A86, 0x26E7, 0x23D9, 0x16F0, 0x08B2, 0x079D, 0xFE6F, 0xF12A, 0xF051, 0xF3F9, 0xFA45, 0xFEAD, 0x0173, 0xFFCA, 0xFC2E,
    0xF8D2, 0xF33F, 0xF590, 0xF219, 0xEDBD, 0xE9F3, 0xE883, 0xE9B7, 0xEEAC, 0xF702, 0xF766, 0xF960, 0xFD71, 0x0325, 0x08EA, 0x0E94,
    0x0BD5, 0x04BB, 0x00DA, 0xFBE2, 0xF6B1, 0xEF52, 0xE4D1, 0xE064, 0xD7B4, 0xC69A, 0xC1C2, 0xC007, 0xB627, 0xB4B5, 0xB8AB, 0xC0EF,
    0xC9CA, 0xCFCF, 0xD41E, 0xD3F3, 0xD5FD, 0xD256, 0xD4CF, 0xD599, 0xD270, 0xCF1F, 0xCD7A, 0xCE8B, 0xD377, 0xE1C8, 0xED05, 0xF517,
    0xFD05, 0x0505, 0x0B23, 0x14CB, 0x1BDF, 0x1EBB, 0x2378, 0x2ABE, 0x305C, 0x3458, 0x3275, 0x2FCA, 0x2FB0, 0x2215, 0x1594, 0x13E8,
    0x08EE, 0xFA8D, 0xF270, 0xF09D, 0xF3C4, 0xF819, 0xFC55, 0xFB55, 0xFB3F, 0xF64A, 0xF456, 0xF624, 0xF4CC, 0xF062, 0xECFF, 0xEA9B,
    0xE7D4, 0xED6E, 0xF56E, 0xF88F, 0xF937, 0xFC29, 0xFCCE, 0xFF5D, 0x017A, 0xFE7A, 0xFB24, 0xFB67, 0xFD2E, 0x0122, 0x009B, 0xFDA6,
    0x01C0, 0xFBC1, 0xED6E, 0xE99F, 0xE614, 0xDDAB, 0xD64B, 0xD42D, 0xD68C, 0xDABE, 0xE074, 0xE0D2, 0xE29C, 0xE081, 0xDE79, 0xE17A,
    0xE76F, 0xEAC0, 0xEC86, 0xEF1F, 0xEDF9, 0xF138, 0xF9C3, 0x0142, 0x0517, 0x0B66, 0x1164, 0x1942, 0x22F8, 0x28FB, 0x28AA, 0x2796,
    0x2856, 0x2B9C, 0x2EF9, 0x2A55, 0x29CC, 0x27F2, 0x15B3, 0x06DF, 0xFD44, 0xF1F2, 0xE548, 0xDC80, 0xDCBF, 0xDF62, 0xE59B, 0xE777,
    0xE945, 0xE924, 0xE774, 0xE77E, 0xEC04, 0xEE8A, 0xECD9, 0xEDBB, 0xEA46, 0xE607, 0xE880, 0xEEBA, 0xEFB7, 0xF134, 0xF222, 0xF260,
    0xF722, 0xFEAE, 0x0167, 0x03A9, 0x056E, 0x07B8, 0x0E9A, 0x0EE4, 0x0E5E, 0x155C, 0x1126, 0x063B, 0x0008, 0xF82F, 0xEC5A, 0xDE77,
    0xD7CB, 0xD5D0, 0xDCCE, 0xE59D, 0xED22, 0xF2CB, 0xF36B, 0xF138, 0xF236, 0xF435, 0xF0AE, 0xEE57, 0xEA99, 0xE402, 0xE26B, 0xE8C6,
    0xEEB9, 0xF3BF, 0xF919, 0xFDBE, 0x049F, 0x0F8D, 0x1829, 0x1D93, 0x206A, 0x2157, 0x2728, 0x2937, 0x232E, 0x2608, 0x265E, 0x1CBA,
    0x1467, 0x0FD8, 0x089B, 0xFBFC, 0xF2E5, 0xEB98, 0xEE56, 0xF3E3, 0xFA85, 0x0008, 0x00B5, 0xFABD, 0xF2FF, 0xEFBF, 0xE8C9, 0xE1C6,
    0xDB59, 0xD205, 0xC7D4, 0xC653, 0xC8AA, 0xCC7A, 0xD197, 0xD4CF, 0xD928, 0xE2E5, 0xEDAB, 0xF5FC, 0xFD2B, 0x013E, 0x09AB, 0x149C,
    0x151C, 0x16E5, 0x1A3B, 0x138B, 0x0712, 0xFF5F, 0xFC54, 0xF520, 0xF004, 0xEA17, 0xEA87, 0xF0A7, 0xF6B7, 0xFCD0, 0x01C8, 0x03CB,
    0x01CA, 0x036D, 0x03F2, 0x01AF, 0x0141, 0xFE7D, 0xF74C, 0xF556, 0xFAAF, 0x0155, 0x07E6, 0x0FAF, 0x1401, 0x1A62, 0x23B0, 0x2A81,
    0x319D, 0x32EC, 0x3352, 0x3C17, 0x3D16, 0x3A7E, 0x3DCD, 0x3DB0, 0x341A, 0x2849, 0x2172, 0x182A, 0x0EA4, 0x023B, 0xF90F, 0xF6F3,
    0xF749, 0xF792, 0xF874, 0xF624, 0xED7B, 0xE4D6, 0xE010, 0xD969, 0xD309, 0xCE5F, 0xC4AF, 0xBD06, 0xBC07, 0xBFB0, 0xC4D9, 0xCC14,
    0xD1E2, 0xD8CC, 0xE3DD, 0xEDE9, 0xF7C9, 0xFDBB, 0xFB86, 0x00B9, 0x059A, 0x03A7, 0x0734, 0x0EC6, 0x10A6, 0x0BEF, 0x0A0C, 0x05A2,
    0xFEE2, 0xF53B, 0xECFB, 0xEA93, 0xEF5A, 0xF63B, 0xFF83, 0x0837, 0x09EE, 0x082F, 0x0833, 0x0998, 0x092A, 0x0D04, 0x0B81, 0x04CC,
    0xFFD5, 0xFEC9, 0x00CA, 0x05D2, 0x0B95, 0x0E04, 0x130D, 0x19A3, 0x2208, 0x2A68, 0x2A3F, 0x2C75, 0x343A, 0x3601, 0x3507, 0x3843,
    0x3A81, 0x3436, 0x2C26, 0x251E, 0x1C41, 0x0EB0, 0xFD0F, 0xEBE1, 0xE117, 0xDA6B, 0xD7A4, 0xD7B6, 0xD69F, 0xD114, 0xCADA, 0xC82A,
    0xC35F, 0xC217, 0xC204, 0xC042, 0xBE3D, 0xC009, 0xC44B, 0xC9E1, 0xD12A, 0xD42F, 0xD6ED, 0xDC1C, 0xE2B2, 0xEE64, 0xF557, 0xF982,
    0x059F, 0x10AB, 0x143D, 0x1A1C, 0x2313, 0x2522, 0x212A, 0x1C07, 0x1884, 0x1397, 0x0C95, 0x017C, 0xFA48, 0xF837, 0xFA1D, 0x0166,
    0x09DD, 0x0E7E, 0x0DC1, 0x0E57, 0x0BCA, 0x07DD, 0x0676, 0x0399, 0xFBDC, 0xF59E, 0xF3D5, 0xF482, 0xF98A, 0xFB61, 0xFAEA, 0xFDC3,
    0x005B, 0x0A00, 0x130B, 0x1413, 0x181B, 0x20E6, 0x23BB, 0x24AF, 0x2ADA, 0x2E17, 0x2B7A, 0x2394, 0x1AF7, 0x10FD, 0x0584, 0xF656,
    0xE886, 0xE0C9, 0xDCE8, 0xDD11, 0xE044, 0xE2B6, 0xE24C, 0xE424, 0xE829, 0xEBBD, 0xF031, 0xF4E6, 0xF216, 0xEAAD, 0xE4AE, 0xE056,
    0xE374, 0xE992, 0xED69, 0xF349, 0xF6F3, 0xFE8F, 0x0ADF, 0x10E0, 0x13B0, 0x1BBE, 0x2287, 0x2398, 0x2779, 0x2E73, 0x3178, 0x2DAC,
    0x28F5, 0x244D, 0x1F74, 0x169B, 0x09A7, 0xFFB5, 0xFA8A, 0xF8B8, 0xFBBE, 0x0256, 0x0374, 0x01D8, 0x0161, 0xFE62, 0xFBD8, 0xFCB7,
    0xFAB7, 0xF445, 0xEE16, 0xE85D, 0xE7CF, 0xECDF, 0xF1A5, 0xF870, 0xFDA5, 0x035D, 0x0ECF, 0x1791, 0x1928, 0x1C49, 0x2222, 0x21D2,
    0x1F59, 0x20E2, 0x2266, 0x1EF0, 0x1843, 0x0F18, 0x0700, 0xFE42, 0xF080, 0xE2D1, 0xD978, 0xD5AC, 0xD7EB, 0xE1CA, 0xEA02, 0xEDE2,
    0xF007, 0xEC5F, 0xE779, 0xE51C, 0xE4C6, 0xE2C6, 0xE05C, 0xDE3B, 0xDE3A, 0xE456, 0xE9A3, 0xF04C, 0xF694, 0xFAA4, 0x04B5, 0x12B4,
    0x19C1, 0x1CC6, 0x223A, 0x24C1, 0x24CF, 0x26E1, 0x2BE8, 0x2D8B, 0x2ABA, 0x24DA, 0x1E13, 0x1788, 0x0BC1, 0xFEA5, 0xF38C, 0xEC2F,
    0xE92A, 0xEB7D, 0xF1A2, 0xF52B, 0xF96D, 0xFA63, 0xF873, 0xF727, 0xF6D1, 0xF5CA, 0xF146, 0xED6E, 0xEA1D, 0xEC16, 0xF1C1, 0xF85F,
    0xFE61, 0xFF29, 0x0174, 0x07C1, 0x0C6D, 0x0D90, 0x0F3B, 0x10F3, 0x0DA7, 0x0A24, 0x09CF, 0x0971, 0x065F, 0x0092, 0xFB12, 0xF858,
    0xF4CD, 0xEDFD, 0xE6CF, 0xDFCD, 0xDADD, 0xD992, 0xDD07, 0xDFAB, 0xE0D4, 0xE1A5, 0xE0C6, 0xE207, 0xE3E2, 0xE4A1, 0xE2C7, 0xDE89,
    0xDA55, 0xD908, 0xDC04, 0xE1C3, 0xE949, 0xEE36, 0xF188, 0xF9F6, 0x0351, 0x0B79, 0x1468, 0x1E4C, 0x2695, 0x2C4D, 0x31A0, 0x36C2,
    0x3A4D, 0x3B24, 0x39E7, 0x3890, 0x34F1, 0x2DF9, 0x25F1, 0x1CA8, 0x141C, 0x1010, 0x1211, 0x1671, 0x1B39, 0x1E0D, 0x1CFE, 0x1B8F,
    0x1B35, 0x1C3D, 0x1CE2, 0x1994, 0x12C8, 0x0A2D, 0x0334, 0xFEDB, 0xFDE2, 0xFD0C, 0xF99F, 0xFAB1, 0xFD54, 0xFD36, 0xFBE0, 0xF948,
    0xF779, 0xF5C9, 0xF641, 0xFA67, 0xFE0F, 0xFF35, 0xFC80, 0xF96E, 0xF4D0, 0xECE1, 0xE38B, 0xD7F8, 0xCDFB, 0xC850, 0xC792, 0xCB27,
    0xD057, 0xD550, 0xD9CD, 0xDDB5, 0xE00B, 0xE2C7, 0xE5CD, 0xE7B9, 0xE841, 0xE6B9, 0xE6C5, 0xE8C6, 0xEF85, 0xF671, 0xFD0E, 0x07FF,
    0x1413, 0x1FAC, 0x2A0A, 0x32CE, 0x3941, 0x3C9E, 0x3F45, 0x437A, 0x470D, 0x4981, 0x47C9, 0x4395, 0x3DD2, 0x34B8, 0x2AEE, 0x1EFE,
    0x12D9, 0x08BC, 0x02A8, 0x038D, 0x068B, 0x0C24, 0x0F42, 0x11AF, 0x1101, 0x1051, 0x0D6A, 0x08E7, 0x0025, 0xEC3D, 0xEA3C, 0xEBDE,
    0xE984, 0xE7F4, 0xE4FC, 0xE57B, 0xE212, 0xDD4E, 0xDD77, 0xE3FA, 0xE8E6, 0xEF34, 0xF4EF, 0xF7D3, 0xFB6E, 0xFCA5, 0xFAC2, 0xF8ED,
    0xF676, 0xF0ED, 0xE9D2, 0xDE6A, 0xD770, 0xCC79, 0xC68E, 0xD107, 0xD6BC, 0xDEAC, 0xE2B2, 0xE77A, 0xE9CA, 0xEC74, 0xF078, 0xE51D,
    0xE1CE, 0xE624, 0xEC09, 0xF1FF, 0xF7AD, 0x036D, 0x0F17, 0x13E8, 0x175D, 0x1DC6, 0x2585, 0x2C84, 0x3221, 0x376F, 0x3B38, 0x40A7,
    0x3ECA, 0x3DD6, 0x3CB5, 0x38EC, 0x331A, 0x2138, 0x1927, 0x0C30, 0xFA2B, 0xFAD7, 0xFE3B, 0x0233, 0x0342, 0x0287, 0xFFF1, 0xFC6B,
    0xFCCA, 0xF161, 0xE2C4, 0xDCAC, 0xDBAE, 0xDAC9, 0xD8D9, 0xD9CE, 0xDFD1, 0xE1BA, 0xE245, 0xE964, 0xF2BE, 0xFDD2, 0x055E, 0x0BBF,
    0x0F1F, 0x1545, 0x16CA, 0x168A, 0x197E, 0x1A66, 0x1E02, 0x12B1, 0x0AC0, 0x04B0, 0xF30A, 0xED51, 0xF1C4, 0xFB5D, 0xFF9A, 0x0252,
    0x0391, 0x00E2, 0x065A, 0x0570, 0xFC16, 0xF59D, 0xF6F6, 0xFBD7, 0x0019, 0x0480, 0x0EAA, 0x18FD, 0x1C15, 0x1F7D, 0x23B9, 0x2868,
    0x2B1D, 0x2DE5, 0x2F4B, 0x3381, 0x33B6, 0x3017, 0x2DB3, 0x27F2, 0x2973, 0x1F1B, 0x1025, 0x0A10, 0xF9ED, 0xEC34, 0xE6F0, 0xEB06,
    0xED78, 0xEDC6, 0xEF88, 0xEBAC, 0xEE93, 0xF065, 0xE89E, 0xDADC, 0xD298, 0xD00B, 0xCE65, 0xCBF9, 0xCF87, 0xD928, 0xDF3E, 0xE543,
    0xEC41, 0xF5DF, 0xFE9F, 0x086E, 0x0D2F, 0x1456, 0x1A44, 0x19E5, 0x1C43, 0x18DC, 0x1D77, 0x1CFE, 0x1023, 0x0A12, 0xFF1C, 0xF079,
    0xE5F1, 0xE6BF, 0xED09, 0xF145, 0xF79C, 0xF69B, 0xF5E1, 0xFB9B, 0xFC42, 0xF3E7, 0xEC0B, 0xEA98, 0xED50, 0xED00, 0xEEB1, 0xF746,
    0x0023, 0x04A4, 0x062A, 0x0A59, 0x0E65, 0x1552, 0x177C, 0x1A20, 0x2009, 0x20CC, 0x231E, 0x1E74, 0x1E69, 0x2209, 0x189E, 0x13B3,
    0x0FA1, 0x0566, 0xF7F5, 0xF0A7, 0xF2D4, 0xF464, 0xF937, 0xFA5B, 0xF7C5, 0xFC00, 0xFFF7, 0xF934, 0xEA78, 0xDBB7, 0xD4EF, 0xCF53,
    0xCB5A, 0xCF39, 0xD698, 0xDD43, 0xDFDC, 0xE4C2, 0xE7B7, 0xEFDE, 0xF6AF, 0xF9E1, 0x0202, 0x0535, 0x0B3A, 0x0A12, 0x07AD, 0x0F8E,
    0x0E78, 0x0B00, 0x0895, 0x00E1, 0xF2EE, 0xE761, 0xE738, 0xE994, 0xF00E, 0xF64F, 0xF567, 0xF804, 0xFF08, 0x0135, 0xFC28, 0xF23C,
    0xF0B2, 0xF2E0, 0xF399, 0xF771, 0xFF11, 0x09F7, 0x0F8B, 0x1681, 0x1B6A, 0x21B1, 0x286A, 0x2A5B, 0x3095, 0x3201, 0x3564, 0x35DB,
    0x2F63, 0x3427, 0x35CA, 0x31A3, 0x2F53, 0x2C25, 0x22C9, 0x13CF, 0x0CFC, 0x0AAE, 0x0BC2, 0x119D, 0x132B, 0x12F0, 0x18DE, 0x1BCA,
    0x15B6, 0x0510, 0xF444, 0xEA02, 0xE041, 0xDA61, 0xDB75, 0xE33D, 0xE762, 0xEB54, 0xECB4, 0xEE59, 0xF47B, 0xF602, 0xFBC2, 0xFDE3,
    0x004D, 0x022E, 0xFA3C, 0xFAA3, 0xFDA8, 0xFBD6, 0xF766, 0xF4E3, 0xEF23, 0xDFC2, 0xD409, 0xCF05, 0xCF77, 0xD6A6, 0xDD2C, 0xDE70,
    0xE324, 0xEB55, 0xF0FF, 0xEDF8, 0xE860, 0xE8AC, 0xEA32, 0xEA75, 0xED19, 0xF6B3, 0x000A, 0x0976, 0x0F6F, 0x15AA, 0x2081, 0x2632,
    0x2D3F, 0x303E, 0x3289, 0x3907, 0x36A2, 0x34CD, 0x3938, 0x3C73, 0x39B5, 0x3751, 0x3497, 0x2811, 0x18FB, 0x0CF1, 0x05D7, 0x0751,
    0x0CE7, 0x0BB9, 0x0859, 0x08E0, 0x0AED, 0x04CF, 0xF2E5, 0xE347, 0xDA51, 0xD2BC, 0xCD86, 0xD02B, 0xD5A7, 0xDC0E, 0xDE70, 0xDE16,
    0xE186, 0xE294, 0xE5A2, 0xE6FD, 0xE6FC, 0xECB1, 0xEC91, 0xE7FD, 0xE8C2, 0xEE60, 0xF010, 0xF131, 0xF520, 0xF03F, 0xE46B, 0xD8FB,
    0xD1BE, 0xD167, 0xD8A6, 0xDE8E, 0xE06F, 0xE42A, 0xED81, 0xF4B4, 0xF298, 0xECB9, 0xEB42, 0xEC45, 0xEA46, 0xEED1, 0xF52F, 0xFE2D,
    0x092B, 0x0F73, 0x196B, 0x20BC, 0x26CF, 0x2C62, 0x2C2E, 0x3078, 0x33FF, 0x31FC, 0x30FF, 0x35B3, 0x38DB, 0x354E, 0x3484, 0x30C8,
    0x244B, 0x165F, 0x09D2, 0x0125, 0x029F, 0x0685, 0x0612, 0x017A, 0xFFF0, 0x0145, 0xFA0A, 0xEAD2, 0xDD0D, 0xD5B2, 0xCD1B, 0xC91D,
    0xCB48, 0xD1C9, 0xDCC2, 0xE2AA, 0xEA74, 0xF1F7, 0xF8ED, 0x032E, 0x07A5, 0x0E0B, 0x163D, 0x1866, 0x1772, 0x19F2, 0x1E75, 0x1DB7,
    0x1DF7, 0x1FB1, 0x19EF, 0x0E6A, 0x006A, 0xF382, 0xEF94, 0xF29B, 0xF762, 0xF79E, 0xF9F1, 0x01F2, 0x07E6, 0x0634, 0xFE90, 0xFAD0,
    0xF574, 0xF129, 0xF171, 0xF4C9, 0xFFB8, 0x0730, 0x0E84, 0x16AD, 0x1B42, 0x2366, 0x2569, 0x267C, 0x2C16, 0x3059, 0x30EF, 0x3188,
    0x37FE, 0x38A1, 0x34D7, 0x34C9, 0x2F4C, 0x24ED, 0x1704, 0x06E6, 0xFDE3, 0xFB31, 0xFCBC, 0xF821, 0xEF62, 0xEBF5, 0xEB09, 0xE797,
    0xDB66, 0xD248, 0xCB20, 0xC398, 0xC225, 0xC2C8, 0xCA7E, 0xD1E1, 0xD7A5, 0xDFB4, 0xE41B, 0xEBD7, 0xF1C3, 0xF420, 0xFBD0, 0x04E9,
    0x0892, 0x0A12, 0x0FA5, 0x1573, 0x1678, 0x19A2, 0x1C39, 0x18C6, 0x1115, 0x027F, 0xF4EA, 0xEE3D, 0xF10C, 0xF490, 0xF3CA, 0xF6DF,
    0xFFA5, 0x084B, 0x0562, 0x0028, 0xFB5D, 0xF5BF, 0xF376, 0xF0E0, 0xF64E, 0xFE4E, 0x0406, 0x09E2, 0x0B9D, 0x0E7D, 0x10BB, 0x0F65,
    0x0ED0, 0x1476, 0x190D, 0x1748, 0x18BA, 0x1DA5, 0x1EF3, 0x1EAE, 0x2151, 0x20B9, 0x1D26, 0x1490, 0x083A, 0xFED5, 0xFCB0, 0xFD52,
    0xF911, 0xF248, 0xEEC7, 0xF1C6, 0xEE43, 0xE572, 0xDCAB, 0xD310, 0xCCD6, 0xC5AC, 0xC585, 0xCAF6, 0xD143, 0xD9FB, 0xDED9, 0xE330,
    0xE96C, 0xEDCD, 0xEF04, 0xF561, 0xFEBB, 0x01A5, 0x0390, 0x0933, 0x0D8B, 0x0F7A, 0x136E, 0x168F, 0x16B0, 0x1232, 0x0686, 0xF88E,
    0xF10C, 0xF21A, 0xF61B, 0xF5F2, 0xF711, 0x008D, 0x069B, 0x05D6, 0x0102, 0xFA16, 0xF5AD, 0xF0DF, 0xF182, 0xF83A, 0xFFD3, 0x07FF,
    0x0DD6, 0x123F, 0x1792, 0x1EC7, 0x2171, 0x2583, 0x2F84, 0x351A, 0x36DB, 0x39F3, 0x3D85, 0x3D5D, 0x3E62, 0x430C, 0x44C0, 0x429A,
    0x3B78, 0x2E15, 0x21C1, 0x1ACF, 0x18B8, 0x142F, 0x09EE, 0x0644, 0x04DF, 0x00E9, 0xF9F0, 0xEE46, 0xE3FE, 0xD91D, 0xD0D6, 0xCE04,
    0xCE8C, 0xD26D, 0xD7AC, 0xDAA6, 0xDDD7, 0xE311, 0xE456, 0xE464, 0xEA42, 0xF25F, 0xF468, 0xF767, 0xFD0F, 0xFFFA, 0x026D, 0x04D9,
    0x0729, 0x0779, 0x0337, 0xF6FC, 0xE97C, 0xE185, 0xE117, 0xE46F, 0xE303, 0xE557, 0xEDCA, 0xF45B, 0xF679, 0xF2F3, 0xEFEC, 0xEDEC,
    0xE9BF, 0xEA34, 0xEF32, 0xF542, 0xFCD3, 0x016D, 0x053F, 0x0C45, 0x1266, 0x15C6, 0x1BB4, 0x264C, 0x2AE7, 0x2B5B, 0x2E90, 0x30F3,
    0x33E1, 0x36E7, 0x3AB2, 0x3E56, 0x3DEF, 0x36A3, 0x26D9, 0x177D, 0x0D96, 0x09D8, 0x0273, 0xF81A, 0xF509, 0xF39D, 0xF1D6, 0xEB60,
    0xE4A5, 0xDF0F, 0xD611, 0xCFC6, 0xCE95, 0xD151, 0xD786, 0xDDAC, 0xE1C8, 0xE688, 0xEBF2, 0xECFD, 0xEB0F, 0xEFD0, 0xF43A, 0xF3F7,
    0xF605, 0xF857, 0xFB6B, 0xFC8E, 0xFE68, 0x017E, 0x01D9, 0x009C, 0xF745, 0xEAFD, 0xE1EF, 0xE1ED, 0xE417, 0xE0B4, 0xE2D7, 0xE861,
    0xF0B1, 0xF584, 0xF456, 0xF484, 0xF1A3, 0xED39, 0xEA8F, 0xE9F0, 0xEE61, 0xF3E4, 0xF7F7, 0xFDD4, 0x0672, 0x0F81, 0x13EB, 0x1B32,
    0x24BF, 0x2731, 0x285B, 0x2957, 0x2B8A, 0x2EE3, 0x333A, 0x39AA, 0x3EFF, 0x41B9, 0x3B4F, 0x2C53, 0x194D, 0x0CF1, 0x0689, 0xFC03,
    0xF2DE, 0xECA8, 0xEBA4, 0xEAB3, 0xE5BC, 0xE09E, 0xD9BF, 0xD17F, 0xCB45, 0xC71A, 0xC605, 0xCA54, 0xCF55, 0xD37D, 0xDB21, 0xE42C,
    0xE6B8, 0xEA5F, 0xF448, 0xFC91, 0x03DA, 0x0B52, 0x113C, 0x14B5, 0x183E, 0x1A3C, 0x1CC2, 0x1F30, 0x1E5C, 0x19D2, 0x0E36, 0x05FD,
    0x0421, 0x01EE, 0xFD7A, 0xFA7D, 0xFE6A, 0x05AF, 0x0A7E, 0x0D64, 0x0DA6, 0x08FE, 0x0268, 0xFADC, 0xF4F9, 0xF4D8, 0xF854, 0xF9D7,
    0xFCB3, 0x03B4, 0x070C, 0x074B, 0x0BA2, 0x115A, 0x133C, 0x14A8, 0x1929, 0x1DA9, 0x22EC, 0x2789, 0x2BAB, 0x2FAD, 0x2FCA, 0x2B25,
    0x1ACF, 0x0624, 0xF8E0, 0xEF8F, 0xE688, 0xDDC0, 0xDA08, 0xDAEB, 0xDBF4, 0xDC03, 0xDBEA, 0xD97B, 0xD3BF, 0xCF51, 0xCB51, 0xCB91,
    0xD17A, 0xD61E, 0xD9EB, 0xE0E8, 0xE719, 0xE808, 0xEA0F, 0xF1CD, 0xF86D, 0xFCB0, 0x02B3, 0x0771, 0x0CFA, 0x0FE3, 0x1111, 0x15D0,
    0x1A4D, 0x1F18, 0x19C4, 0x0D11, 0x039B, 0xFBCF, 0xF609, 0xEE82, 0xEB69, 0xF083, 0xF851, 0xFFB1, 0x0430, 0x0589, 0x0250, 0xFBDE,
    0xF4AB, 0xF061, 0xF3CC, 0xF8A1, 0xFBA4, 0x0324, 0x0AF6, 0x0D84, 0x0CD5, 0x0F3F, 0x13C4, 0x15EA, 0x17BA, 0x1A12, 0x1D1C, 0x21C6,
    0x25BE, 0x2B2C, 0x3090, 0x3495, 0x32FF, 0x23C2, 0x11F3, 0x03F3, 0xF9BB, 0xEF89, 0xE463, 0xDF1F, 0xDDB0, 0xDD4A, 0xDD37, 0xDC18,
    0xD800, 0xD347, 0xCD12, 0xC728, 0xC63A, 0xC99D, 0xCBEE, 0xCEEC, 0xD6E1, 0xDD74, 0xE126, 0xE656, 0xEEB5, 0xF64B, 0xFC7D, 0x0200,
    0x0577, 0x0948, 0x0C2D, 0x101C, 0x1589, 0x1CB2, 0x239C, 0x1F74, 0x13BE, 0x08D3, 0x00CA, 0xFB1E, 0xF5BB, 0xF43C, 0xF936, 0x0103,
    0x095E, 0x0EC4, 0x0F34, 0x0B89, 0x04A5, 0xFD04, 0xF6C7, 0xFA69, 0x007A, 0x057B, 0x0F7E, 0x1859, 0x1DB0, 0x202C, 0x25B3, 0x2C1D,
    0x3194, 0x37D2, 0x3C0A, 0x40C5, 0x4499, 0x478A, 0x49E2, 0x4B6D, 0x4FF2, 0x4D3C, 0x405B, 0x3042, 0x2028, 0x14B9, 0x0927, 0xFDB8,
    0xF94C, 0xF7E7, 0xF966, 0xFC3F, 0xFD36, 0xFC54, 0xF64E, 0xEE46, 0xE3F7, 0xDEC8, 0xDDEA, 0xDAAF, 0xDC4D, 0xE228, 0xE86A, 0xEBEF,
    0xF01A, 0xF565, 0xF8C2, 0xFB03, 0xFB99, 0xFC9B, 0xFDB9, 0xFF1F, 0x0049, 0x031E, 0x0A56, 0x0E6B, 0x0817, 0xF9CD, 0xEBC6, 0xE2D4,
    0xDBA9, 0xD515, 0xD446, 0xD7AA, 0xDD59, 0xE5CA, 0xED1E, 0xEFD4, 0xEF1D, 0xEAEB, 0xE488, 0xE34F, 0xE697, 0xE9CC, 0xEDCB, 0xF530,
    0xFD8D, 0x01FB, 0x06C0, 0x0F07, 0x1862, 0x219E, 0x28D5, 0x3012, 0x3672, 0x3AEC, 0x3ECD, 0x4121, 0x460A, 0x49F8, 0x460F, 0x385E,
    0x24B3, 0x14CA, 0x0699, 0xF802, 0xECB3, 0xE5F1, 0xE399, 0xE2FA, 0xE3E3, 0xE48A, 0xE372, 0xE100, 0xDAD0, 0xD44B, 0xD2DB, 0xD250,
    0xD137, 0xD441, 0xDB89, 0xE02B, 0xE282, 0xE523, 0xE866, 0xEBE4, 0xEC85, 0xED88, 0xEE97, 0xF11B, 0xF5DA, 0xF8B4, 0xFD49, 0x04EF,
    0x09E8, 0x059B, 0xF910, 0xEF6C, 0xEA98, 0xE6C7, 0xE41B, 0xE4D7, 0xE8C9, 0xEDAD, 0xF47E, 0xF997, 0xFBD8, 0xFD26, 0xF8E9, 0xF2BC,
    0xEFCA, 0xF123, 0xF22B, 0xF41D, 0xFCE5, 0x0409, 0x0913, 0x0CF5, 0x11AA, 0x19B1, 0x211B, 0x2980, 0x30DB, 0x37EC, 0x3EB3, 0x411E,
    0x42CA, 0x45B3, 0x4936, 0x46DC, 0x3979, 0x2874, 0x185E, 0x09B4, 0xFC3B, 0xEFDB, 0xE96E, 0xE852, 0xEABE, 0xEDF5, 0xED90, 0xEC6B,
    0xE727, 0xDBFF, 0xD261, 0xCD06, 0xCAB7, 0xCADB, 0xCFD8, 0xD766, 0xDE88, 0xE56E, 0xEABC, 0xF096, 0xF54A, 0xF9F2, 0xFFCB, 0x041D,
    0x0B06, 0x1133, 0x13E2, 0x1835, 0x1F9C, 0x255A, 0x2250, 0x180E, 0x0E7D, 0x0824, 0x0213, 0xFC0D, 0xF85E, 0xF746, 0xF9CE, 0xFF85,
    0x04DC, 0x0AC5, 0x0E75, 0x0AE4, 0x04C5, 0x014D, 0xFF4C, 0xFCA4, 0xFDF5, 0x0378, 0x072D, 0x091C, 0x0A08, 0x0D45, 0x123E, 0x1851,
    0x1FBE, 0x267B, 0x2E0F, 0x340E, 0x35D6, 0x36C8, 0x3A2A, 0x3E2E, 0x3B42, 0x2E6E, 0x1E25, 0x0CD5, 0xFAF5, 0xE995, 0xDC02, 0xD4DA,
    0xD240, 0xD3E9, 0xD533, 0xD54B, 0xD5E9, 0xD1B1, 0xCB25, 0xC7B7, 0xC787, 0xC80C, 0xCAA0, 0xD1A7, 0xD903, 0xDE0E, 0xE134, 0xE546,
    0xEBC3, 0xF1F0, 0xF8CF, 0xFF1C, 0x05C1, 0x1000, 0x169C, 0x1AA1, 0x20C3, 0x29BA, 0x31E5, 0x3096, 0x2AA5, 0x25E3, 0x2003, 0x1A6F,
    0x156D, 0x126E, 0x10C2, 0x111D, 0x1310, 0x1431, 0x190C, 0x1A62, 0x1350, 0x0C22, 0x0682, 0x01F7, 0xFFD2, 0x014E, 0x0665, 0x0A2A,
    0x0C33, 0x0DA5, 0x0F18, 0x1294, 0x1632, 0x19FA, 0x1E0B, 0x234F, 0x26D8, 0x25F7, 0x24BA, 0x272C, 0x2BC0, 0x2B57, 0x2242, 0x1615,
    0x08F7, 0xFA14, 0xEC78, 0xE182, 0xDBD4, 0xDBE0, 0xDE6F, 0xE13B, 0xE463, 0xE510, 0xDE9C, 0xD510, 0xCF24, 0xCB61, 0xC961, 0xCA44,
    0xCD7A, 0xD18F, 0xD4AB, 0xD738, 0xDAEC, 0xDF46, 0xE637, 0xEE70, 0xF66C, 0xFF3E, 0x0681, 0x0A2B, 0x0A62, 0x0D77, 0x1551, 0x1B52,
    0x19F2, 0x1390, 0x0CE2, 0x068B, 0x0081, 0xFB95, 0xF70D, 0xF602, 0xF921, 0xFDAD, 0x04CC, 0x0CB8, 0x0F58, 0x0A88, 0x04F1, 0xFFA2,
    0xF926, 0xF518, 0xF561, 0xF94E, 0xFD6E, 0x01E8, 0x0735, 0x0D17, 0x15B6, 0x1F8F, 0x29BA, 0x343C, 0x3E05, 0x4441, 0x44E6, 0x4570,
    0x4944, 0x4D28, 0x4A4D, 0x4073, 0x34E5, 0x2711, 0x191C, 0x0C9E, 0x01B7, 0xFC4B, 0xFB53, 0xFCB1, 0xFF68, 0x03B7, 0x04C9, 0xFD87,
    0xF72D, 0xF3A5, 0xEF47, 0xEBB2, 0xE890, 0xE8BA, 0xE8C6, 0xE7E2, 0xE9CF, 0xEBBA, 0xF075, 0xF716, 0xFC44, 0x012B, 0x0503, 0x096C,
    0x0AC4, 0x0A50, 0x0EEF, 0x172E, 0x1CAC, 0x1B12, 0x1494, 0x0C25, 0x01F4, 0xF8C1, 0xF099, 0xEB45, 0xEBA8, 0xED19, 0xF03C, 0xF752,
    0xFEBA, 0x010F, 0xFE30, 0xF962, 0xF317, 0xEB93, 0xE5DF, 0xE50F, 0xE7F4, 0xEC50, 0xF130, 0xF72E, 0xFEE7, 0x0884, 0x1199, 0x1969,
    0x2192, 0x299D, 0x2E7E, 0x2F0D, 0x3080, 0x3578, 0x3847, 0x34D7, 0x2C6A, 0x221C, 0x17D7, 0x0D89, 0x03E4, 0xFBE1, 0xF71A, 0xF4AF,
    0xF1EA, 0xF32F, 0xF796, 0xF6C4, 0xF228, 0xED70, 0xE982, 0xE488, 0xDEEC, 0xDCFB, 0xDD46, 0xDE0E, 0xDF50, 0xE18A, 0xE50E, 0xE947,
    0xED4A, 0xF064, 0xF391, 0xF64C, 0xF610, 0xF225, 0xEF18, 0xF2BD, 0xFA57, 0xFEBE, 0xFDFE, 0xFA61, 0xF549, 0xEFF0, 0xEB39, 0xE6B2,
    0xE4F9, 0xE75C, 0xEB15, 0xF1D5, 0xFC3C, 0x03FE, 0x0547, 0x02A4, 0xFFFC, 0xFA9C, 0xF310, 0xEE34, 0xED84, 0xF0E6, 0xF63F, 0xFC7E,
    0x02EC, 0x0A99, 0x146D, 0x1D5F, 0x26CE, 0x3131, 0x39CE, 0x3EA0, 0x3E21, 0x3F84, 0x4305, 0x428B, 0x3E77, 0x352A, 0x2A8A, 0x1F7F,
    0x143D, 0x092A, 0xFD55, 0xF66D, 0xF12D, 0xEDA6, 0xEFC9, 0xF275, 0xF2F2, 0xEF4B, 0xE9FF, 0xE36B, 0xDA40, 0xD3D9, 0xD006, 0xCF3A,
    0xD204, 0xD582, 0xDAC3, 0xE15F, 0xE978, 0xF0AD, 0xF5EB, 0xFC66, 0x020A, 0x05DD, 0x0735, 0x0A5D, 0x135E, 0x1D24, 0x23F4, 0x25CA,
    0x22EC, 0x1D16, 0x1522, 0x0C84, 0x050E, 0x01D9, 0x008E, 0x003C, 0x03E4, 0x09CC, 0x0DF7, 0x0D83, 0x0AEA, 0x0691, 0xFED6, 0xF715,
    0xF241, 0xF155, 0xF2BA, 0xF4B9, 0xF810, 0xFD86, 0x04AB, 0x0CDE, 0x13CB, 0x1AA7, 0x22E7, 0x2875, 0x28F5, 0x27EB, 0x29E2, 0x2C70,
    0x2CEF, 0x2A4B, 0x249C, 0x1CEA, 0x1390, 0x08BE, 0xFC13, 0xF1CE, 0xE8CC, 0xE00C, 0xDCC7, 0xDED3, 0xE1CB, 0xE23B, 0xE021, 0xDC49,
    0xD52E, 0xCD5F, 0xC840, 0xC6CE, 0xC94B, 0xCD5A, 0xD20F, 0xD822, 0xDEEB, 0xE55E, 0xE947, 0xEC8C, 0xF327, 0xFB06, 0xFF49, 0x000D,
    0x0481, 0x0DB4, 0x164B, 0x1D69, 0x1FDE, 0x1E2D, 0x1B90, 0x1602, 0x0F5F, 0x0B13, 0x0998, 0x0977, 0x0BA9, 0x1351, 0x1B1A, 0x1E32,
    0x1CC4, 0x182B, 0x11F9, 0x0994, 0x027B, 0xFF1C, 0xFEFC, 0x0289, 0x05C5, 0x09EB, 0x104E, 0x16A6, 0x1D8E, 0x22D0, 0x295A, 0x2FF3,
    0x3063, 0x2BB2, 0x26F3, 0x2674, 0x2791, 0x271E, 0x242D, 0x1C77, 0x1353, 0x086B, 0xF8F0, 0xEA7B, 0xDE07, 0xD36F, 0xCD48, 0xCE64,
    0xD4C4, 0xDA06, 0xDC47, 0xDB4A, 0xD5E3, 0xCE1E, 0xC61E, 0xC0CB, 0xBF8E, 0xC14C, 0xC482, 0xC799, 0xCB33, 0xCFB9, 0xD427, 0xD790,
    0xDD1E, 0xE6D2, 0xEFC1, 0xF439, 0xF733, 0xFD33, 0x05E9, 0x0E6F, 0x150F, 0x1746, 0x167E, 0x12EA, 0x0BE6, 0x04D4, 0xFF96, 0xFBBA,
    0xFA89, 0xFD11, 0x03AF, 0x0955, 0x0B65, 0x0BDD, 0x08DD, 0x02A8, 0xFB02, 0xF592, 0xF2C6, 0xF290, 0xF2E2, 0xF529, 0xFA65, 0x031C,
    0x0D9B, 0x16D0, 0x207C, 0x2B64, 0x33C4, 0x3532, 0x3316, 0x329A, 0x3579, 0x39D3, 0x3D09, 0x3BCA, 0x3745, 0x303B, 0x24A9, 0x18D8,
    0x0F58, 0x0608, 0xFE9A, 0xFA14, 0xFC38, 0x00F9, 0x0328, 0x0373, 0x0008, 0xF940, 0xEFC0, 0xE66A, 0xE176, 0xE0A8, 0xE201, 0xE394,
    0xE4AE, 0xE84C, 0xEBBA, 0xED3A, 0xEE47, 0xF216, 0xFA33, 0xFE90, 0xFE9A, 0xFF02, 0x01AE, 0x07F0, 0x0C91, 0x0E56, 0x0D42, 0x0A06,
    0x03FC, 0xFAAB, 0xF344, 0xEDB0, 0xE98F, 0xE8B7, 0xED2C, 0xF54D, 0xFBC5, 0xFE74, 0xFE77, 0xFAB7, 0xF3CD, 0xEBA6, 0xE3D5, 0xDFB6,
    0xDEF9, 0xE076, 0xE4B3, 0xEB5C, 0xF728, 0x0263, 0x0BD2, 0x165D, 0x2148, 0x2905, 0x28DB, 0x265C, 0x25AA, 0x28C9, 0x2CF0, 0x2C8A,
    0x2732, 0x1FAB, 0x13EB, 0x0592, 0xF80D, 0xED20, 0xE3D2, 0xDCCB, 0xDC73, 0xE05A, 0xE49B, 0xE710, 0xE7A3, 0xE560, 0xE018, 0xD972,
    0xD368, 0xCFE1, 0xD075, 0xD265, 0xD4D2, 0xD7D5, 0xDB9D, 0xDEB7, 0xE00F, 0xE36A, 0xEB56, 0xF369, 0xF651, 0xF6BC, 0xF7D3, 0xFAB6,
    0x00A3, 0x047A, 0x045F, 0x0416, 0x0179, 0xFC22, 0xF53D, 0xEFD1, 0xEB16, 0xE63A, 0xE6C3, 0xEC7B, 0xF4CF, 0xFB31, 0xFF94, 0x0174,
    0xFEF6, 0xF97C, 0xF1E8, 0xECCF, 0xEB81, 0xEC95, 0xEFF9, 0xF536, 0xFD98, 0x07FB, 0x0F45, 0x15B0, 0x1D10, 0x249C, 0x2A62, 0x2B62,
    0x2AFD, 0x2CC5, 0x3262, 0x3769, 0x37C2, 0x354B, 0x2DB1, 0x21D1, 0x14D7, 0x091E, 0x0106, 0xF7DD, 0xF25A, 0xF109, 0xF16A, 0xF276,
    0xF202, 0xF17B, 0xEE21, 0xE78E, 0xE06E, 0xDAD7, 0xD85C, 0xD7F6, 0xD846, 0xDA5E, 0xDE4D, 0xE53B, 0xEB04, 0xEEF4, 0xF4A6, 0xFBC0,
    0x01E7, 0x03E1, 0x04AC, 0x07B2, 0x0D1D, 0x142A, 0x17FD, 0x1A31, 0x1B53, 0x18E9, 0x1486, 0x0F8F, 0x0C4A, 0x079E, 0x02E0, 0x0279,
    0x064D, 0x0ADD, 0x0DBE, 0x0F04, 0x0E28, 0x09E3, 0x0219, 0xF9CD, 0xF4E6, 0xF483, 0xF6F0, 0xFA40, 0x001A, 0x0867, 0x0FD9, 0x13BC,
    0x1780, 0x1E26, 0x2300, 0x2457, 0x229C, 0x2071, 0x2175, 0x2412, 0x23E3, 0x209F, 0x1B07, 0x11B7, 0x059E, 0xF940, 0xEFB2, 0xE64E,
    0xDCF9, 0xD7C3, 0xD5D7, 0xD633, 0xD61B, 0xD602, 0xD586, 0xD311, 0xCEC4, 0xCA45, 0xC78F, 0xC70F, 0xC8AC, 0xCA00, 0xCCD6, 0xD1CF,
    0xD71A, 0xDACE, 0xDF83, 0xE7E4, 0xF109, 0xF8FE, 0xFDE5, 0x00B3, 0x06BD, 0x0F53, 0x1788, 0x1CC4, 0x1FE8, 0x2167, 0x1EFB, 0x1BD5,
    0x186D, 0x131F, 0x0D29, 0x0915, 0x09B1, 0x0DE4, 0x12C6, 0x16B8, 0x16EC, 0x13B8, 0x0C76, 0x02CC, 0xFA3C, 0xF688, 0xF815, 0xFADF,
    0xFFBC, 0x07BA, 0x0FAA, 0x1466, 0x165D, 0x1A42, 0x2005, 0x24BF, 0x2704, 0x2550, 0x2414, 0x24CB, 0x250D, 0x242B, 0x21C4, 0x1D35,
    0x1538, 0x0AC0, 0x00A4, 0xF59F, 0xEAD5, 0xE198, 0xDC09, 0xD9D5, 0xD932, 0xDA14, 0xDAAC, 0xDA1A, 0xD653, 0xD0AE, 0xCAC7, 0xC774,
    0xC6D9, 0xC60F, 0xC532, 0xC61D, 0xC995, 0xCC29, 0xCDE4, 0xD204, 0xD95E, 0xE17C, 0xE6F7, 0xEA1C, 0xED58, 0xF3AF, 0xFB4B, 0x0365,
    0x0A34, 0x0EE6, 0x0F2F, 0x0BEA, 0x0935, 0x05CC, 0x00E7, 0xFBD1, 0xFA6F, 0xFC9F, 0x0039, 0x0363, 0x05ED, 0x05B0, 0x01BF, 0xFAA2,
    0xF21E, 0xED30, 0xEC7C, 0xEE6F, 0xF103, 0xF669, 0xFF48, 0x06E1, 0x0BFA, 0x1168, 0x1A25, 0x24FF, 0x2DE5, 0x333D, 0x3609, 0x39AD,
    0x3D9C, 0x3F37, 0x3FA9, 0x3E9A, 0x3AA6, 0x3364, 0x2B7A, 0x235C, 0x1852, 0x0CCA, 0x038B, 0xFE4F, 0xFD3B, 0xFE00, 0xFF88, 0xFFAC,
    0xFD68, 0xF90B, 0xF0FE, 0xE9AC, 0xE563, 0xE337, 0xE1C3, 0xE093, 0xE2D2, 0xE530, 0xE660, 0xE861, 0xECC0, 0xF582, 0xFDD5, 0x023C,
    0x03B1, 0x0671, 0x0D2C, 0x13C8, 0x19F5, 0x1E6C, 0x1E7A, 0x1AF1, 0x1526, 0x0EE8, 0x0686, 0xFD57, 0xF709, 0xF361, 0xF354, 0xF522,
    0xF7C0, 0xF93B, 0xF6FB, 0xF1D1, 0xEA04, 0xE25D, 0xDDE3, 0xDC3F, 0xDC81, 0xDE86, 0xE370, 0xE8D7, 0xEC99, 0xF0D1, 0xF6D6, 0x00F1,
    0x0CBD, 0x15D6, 0x1B4B, 0x1EE3, 0x2325, 0x2612, 0x2933, 0x2C0B, 0x2AD6, 0x2857, 0x238F, 0x1C12, 0x1257, 0x0632, 0xFAF2, 0xF2B2,
    0xEEC3, 0xED73, 0xEDDD, 0xEF3F, 0xEFCC, 0xED53, 0xE7E1, 0xE146, 0xDC68, 0xD9CC, 0xD7AE, 0xD5C4, 0xD650, 0xD8BF, 0xD9CB, 0xDB54,
    0xDDA6, 0xE3E1, 0xEBDE, 0xF120, 0xF28D, 0xF2A2, 0xF541, 0xF892, 0xFD79, 0x03B6, 0x084B, 0x0816, 0x04DE, 0x014A, 0xFD4B, 0xF833,
    0xF397, 0xF1AB, 0xF243, 0xF451, 0xF651, 0xF7F3, 0xF85C, 0xF6FA, 0xF327, 0xEEA8, 0xEB5E, 0xEBF8, 0xEE34, 0xF057, 0xF51B, 0xFB2E,
    0x01EF, 0x07DD, 0x0D4F, 0x1542, 0x1F24, 0x26F7, 0x2A35, 0x2BA7, 0x2CEC, 0x2E30, 0x2FC1, 0x321D, 0x3348, 0x315D, 0x2CC7, 0x26F0,
    0x1F89, 0x1573, 0x09BA, 0xFF3C, 0xF8CD, 0xF5DB, 0xF58C, 0xF663, 0xF7A6, 0xF706, 0xF215, 0xE9EE, 0xE137, 0xDA7F, 0xD511, 0xD0F6,
    0xD06C, 0xD254, 0xD5E6, 0xD9B6, 0xDD12, 0xE3DC, 0xED2E, 0xF68F, 0xFCD0, 0xFF97, 0x02FA, 0x07C4, 0x0E4D, 0x165B, 0x1D8E, 0x20CC,
    0x2043, 0x1F45, 0x1E29, 0x1AF7, 0x1734, 0x13F6, 0x1290, 0x12FB, 0x1309, 0x1387, 0x134F, 0x12AA, 0x1066, 0x0BA3, 0x06F0, 0x0391,
    0x0124, 0xFE67, 0xFDAF, 0xFFA5, 0x0269, 0x05C3, 0x0957, 0x0DBC, 0x154E, 0x1CD5, 0x2108, 0x2162, 0x2010, 0x1FB6, 0x2018, 0x2121,
    0x2174, 0x1FEF, 0x1BF4, 0x1632, 0x0EE0, 0x0560, 0xF939, 0xEC34, 0xE232, 0xDC12, 0xD915, 0xD93F, 0xDB4F, 0xDDAA, 0xDD4A, 0xD8A5,
    0xD27D, 0xCD57, 0xC915, 0xC501, 0xC365, 0xC53B, 0xC7E1, 0xCA81, 0xCBDB, 0xCE13, 0xD421, 0xDB04, 0xE151, 0xE601, 0xEAED, 0xF014,
    0xF59A, 0xFE9C, 0x0900, 0x11A5, 0x16B1, 0x1993, 0x1C24, 0x1CDF, 0x1B3A, 0x1924, 0x178D, 0x170C, 0x174C, 0x1800, 0x192C, 0x1B75,
    0x1DA6, 0x1B92, 0x1885, 0x1681, 0x1548, 0x1427, 0x129E, 0x146A, 0x1826, 0x1CAE, 0x2109, 0x2588, 0x2C6E, 0x3336, 0x371C, 0x3689,
    0x32F4, 0x2EFF, 0x2B75, 0x2A17, 0x29ED, 0x28A0, 0x2529, 0x1F4C, 0x17C9, 0x0E4F, 0x0273, 0xF4D5, 0xE8CE, 0xDF08, 0xD7EA, 0xD3CF,
    0xD332, 0xD4E1, 0xD6B8, 0xD57A, 0xD096, 0xCC04, 0xC884, 0xC61B, 0xC3E6, 0xC456, 0xC703, 0xC9FD, 0xCC2B, 0xCD86, 0xD156, 0xD7C0,
    0xDE5E, 0xE35B, 0xE80C, 0xEC31, 0xEFDF, 0xF5AA, 0xFC86, 0x02AE, 0x06E3, 0x08DF, 0x0AEE, 0x0C2B, 0x0AEA, 0x074B, 0x0307, 0xFF1F,
    0xFBD2, 0xFA8B, 0xFAEC, 0xFCC8, 0xFFA6, 0x0060, 0xFDFF, 0xFBEC, 0xF9C6, 0xF71A, 0xF481, 0xF352, 0xF66E, 0xFC0F, 0x0199, 0x0678,
    0x0D51, 0x16AA, 0x1F31, 0x24D7, 0x2766, 0x288E, 0x29EB, 0x2C2A, 0x3113, 0x3685, 0x38F0, 0x37E0, 0x3530, 0x3057, 0x27E8, 0x1C98,
    0x106F, 0x05FA, 0xFDF9, 0xFA72, 0xF9BE, 0xFCC7, 0x0170, 0x02E4, 0x00E8, 0xFC57, 0xF842, 0xF3CA, 0xEEF9, 0xEC6B, 0xED45, 0xF053,
    0xF23B, 0xF2D4, 0xF35A, 0xF6AE, 0xFC23, 0xFFF4, 0x03EE, 0x078D, 0x092F, 0x0B11, 0x0EE5, 0x13A5, 0x1746, 0x1941, 0x1AE2, 0x1C30,
    0x1B25, 0x15B0, 0x0C88, 0x035B, 0xFAC6, 0xF35A, 0xEDA3, 0xEC27, 0xF079, 0xF3E0, 0xF3DF, 0xF235, 0xEFB8, 0xED5C, 0xEA98, 0xE9BD,
    0xEBC9, 0xF07E, 0xF5A1, 0xF8B6, 0xFBFD, 0x02E7, 0x0BC8, 0x124E, 0x1668, 0x18AB, 0x1996, 0x1A87, 0x1C9C, 0x213B, 0x24F7, 0x2590,
    0x23AD, 0x2046, 0x1A74, 0x10CB, 0x04C7, 0xF999, 0xF19C, 0xEC7C, 0xE9F0, 0xE9DF, 0xEC7A, 0xEE0C, 0xEC6D, 0xE914, 0xE515, 0xE1B4,
    0xDE82, 0xDC51, 0xDC62, 0xDE98, 0xE18B, 0xE322, 0xE553, 0xE9F2, 0xF145, 0xF991, 0x0001, 0x050A, 0x07B6, 0x0957, 0x0BB5, 0x0FDF,
    0x1390, 0x159F, 0x17B7, 0x18D6, 0x1832, 0x13F4, 0x0B91, 0x00F2, 0xF6F7, 0xEEC2, 0xE991, 0xE8CE, 0xEC00, 0xF0B2, 0xF1C9, 0xEFA6,
    0xEC8D, 0xE903, 0xE57B, 0xE362, 0xE4EF, 0xE9F4, 0xF194, 0xF833, 0xFE00, 0x0577, 0x0E4F, 0x16D8, 0x1D4E, 0x21EB, 0x244F, 0x2537,
    0x26D6, 0x2A77, 0x2EFD, 0x327F, 0x339B, 0x31FC, 0x2D7A, 0x24A2, 0x18ED, 0x0CDF, 0x02B4, 0xFC66, 0xF86A, 0xF7FB, 0xFB39, 0xFF69,
    0x0007, 0xFD10, 0xF9E2, 0xF51C, 0xEF6F, 0xE8FA, 0xE2D0, 0xDF64, 0xDDBD, 0xDC58, 0xDC0E, 0xDE69, 0xE4DB, 0xECD8, 0xF3FB, 0xF9EC,
    0xFCFF, 0xFE2C, 0xFFC8, 0x049E, 0x0C0B, 0x126B, 0x184B, 0x1E24, 0x21FC, 0x239C, 0x20C5, 0x199E, 0x1146, 0x099D, 0x0431, 0x01EC,
    0x0535, 0x0B0A, 0x0F43, 0x101F, 0x0DC6, 0x0AB5, 0x078B, 0x0420, 0x0297, 0x0544, 0x0B9E, 0x11D1, 0x1542, 0x1812, 0x1B40, 0x1F74,
    0x2373, 0x2673, 0x27E1, 0x26E3, 0x2583, 0x2650, 0x281E, 0x291A, 0x294B, 0x27AF, 0x23BF, 0x1CF9, 0x1234, 0x0435, 0xF6A3, 0xEC08,
    0xE468, 0xDF88, 0xDF28, 0xE0A9, 0xE138, 0xDF01, 0xDB42, 0xD7C5, 0xD32E, 0xCED1, 0xCAFE, 0xC801, 0xC7FB, 0xC859, 0xC880, 0xCAA8,
    0xCFA3, 0xD71A, 0xDDFE, 0xE3B6, 0xE5F0, 0xE5DC, 0xE750, 0xEAB2, 0xF2BA, 0xFBF2, 0x04CA, 0x0DCB, 0x14D7, 0x1915, 0x1929, 0x154E,
    0x0EC4, 0x0913, 0x056F, 0x0361, 0x059B, 0x0BC6, 0x107E, 0x1346, 0x1354, 0x1167, 0x0EB2, 0x0B26, 0x0974, 0x0A46, 0x1048, 0x1787,
    0x1CCF, 0x2238, 0x27D1, 0x2E6D, 0x34A4, 0x3900, 0x3BC7, 0x3B4B, 0x39A5, 0x38B3, 0x3884, 0x380E, 0x362D, 0x3432, 0x3162, 0x2C39,
    0x2348, 0x15AE, 0x06BD, 0xF9F4, 0xEE9F, 0xE634, 0xE21E, 0xE1D6, 0xE2E9, 0xE1A4, 0xDE96, 0xDB8F, 0xD84B, 0xD3F5, 0xCF78, 0xCC1A,
    0xCB49, 0xCBAF, 0xCB82, 0xCCC8, 0xD07B, 0xD76B, 0xDD7F, 0xE21E, 0xE52F, 0xE3E4, 0xE1DC, 0xE1AB, 0xE548, 0xECAD, 0xF4E6, 0xFD15,
    0x0282, 0x0510, 0x047A, 0xFF9D, 0xF8AA, 0xF1E0, 0xED0F, 0xE9A8, 0xE969, 0xED85, 0xF354, 0xF87B, 0xFB48, 0xFB22, 0xFA81, 0xF975,
    0xF87A, 0xF91F, 0xFC4A, 0x027B, 0x07D0, 0x0DAD, 0x135C, 0x191D, 0x1F41, 0x2479, 0x2943, 0x2B01, 0x2AB9, 0x2B57, 0x2DB2, 0x3039,
    0x3120, 0x31CD, 0x31C3, 0x3011, 0x2CA0, 0x2586, 0x1B14, 0x106D, 0x0564, 0xFB17, 0xF5D4, 0xF51F, 0xF7F6, 0xFBAE, 0xFE5D, 0xFF44,
    0xFDA0, 0xFABD, 0xF571, 0xF0BA, 0xEFB5, 0xF12B, 0xF35D, 0xF5D0, 0xF9F6, 0xFFFC, 0x0607, 0x0BAA, 0x0F91, 0x0FDF, 0x0DAD, 0x0C1A,
    0x0E5E, 0x1404, 0x1B28, 0x21E9, 0x2710, 0x2AF7, 0x2B2E, 0x2634, 0x1E0B, 0x14C9, 0x0AF3, 0x009E, 0xF915, 0xF5DF, 0xF4C1, 0xF436,
    0xF2F7, 0xF0F2, 0xEEFF, 0xEC04, 0xE908, 0xE763, 0xE868, 0xECA9, 0xF075, 0xF382, 0xF75C, 0xFB20, 0xFFC7, 0x045E, 0x0845, 0x0A9C,
    0x0B80, 0x0D57, 0x10EE, 0x156A, 0x1961, 0x1AC5, 0x1BDC, 0x1D45, 0x1BBA, 0x172F, 0x0E4E, 0x03FE, 0xF8F7, 0xEE8B, 0xE7A9, 0xE50D,
    0xE69D, 0xE926, 0xEB4C, 0xEBC3, 0xE974, 0xE526, 0xDE8B, 0xD702, 0xD3C6, 0xD3B5, 0xD512, 0xD816, 0xDBF5, 0xE0F8, 0xE6BB, 0xEC9E,
    0xF1F5, 0xF53C, 0xF654, 0xF6E3, 0xFAC5, 0x0213, 0x0ADC, 0x1484, 0x1BED, 0x2175, 0x24DC, 0x2308, 0x1C8F, 0x1348, 0x0902, 0xFE4B,
    0xF4C4, 0xEF97, 0xEEC2, 0xEF8E, 0xF032, 0xEF5A, 0xEE70, 0xECA1, 0xE913, 0xE6A4, 0xE65E, 0xE88D, 0xEBE7, 0xEF04, 0xF390, 0xF981,
    0x003C, 0x086D, 0x1137, 0x18B7, 0x1CBB, 0x1FC2, 0x230A, 0x262F, 0x2A64, 0x2DBA, 0x3000, 0x3144, 0x30B0, 0x2D0A, 0x2563, 0x1B12,
    0x0FC1, 0x02A3, 0xF623, 0xED4E, 0xEA73, 0xEB86, 0xED9E, 0xF04C, 0xF0D4, 0xEF13, 0xE903, 0xE10E, 0xDAEE, 0xD75F, 0xD6F7, 0xD773,
    0xD95F, 0xDC48, 0xDF63, 0xE310, 0xE76A, 0xEB4D, 0xEEF4, 0xF25E, 0xF87F, 0x026D, 0x0CED, 0x176F, 0x2038, 0x27A8, 0x2E4D, 0x3103,
    0x2FC7, 0x2BC4, 0x2532, 0x1CF8, 0x13D9, 0x0DFF, 0x0B77, 0x0B82, 0x0C57, 0x0B42, 0x095B, 0x07D0, 0x047B, 0xFFB3, 0xFC12, 0xFC90,
    0xFFB6, 0x01FB, 0x04DD, 0x07D7, 0x0BD1, 0x1148, 0x180E, 0x1ED3, 0x22F0, 0x238B, 0x24A1, 0x267C, 0x295A, 0x2C5A, 0x2D6A, 0x2EF2,
    0x2FCA, 0x2E8C, 0x2996, 0x20A4, 0x14D0, 0x06C2, 0xF955, 0xEE00, 0xE852, 0xE888, 0xE9B7, 0xE9AF, 0xE7D5, 0xE46F, 0xDEAB, 0xD5BC,
    0xCE23, 0xC9FA, 0xC88B, 0xC936, 0xCA05, 0xCC41, 0xCE79, 0xD04E, 0xD38E, 0xD640, 0xD80A, 0xD9E5, 0xDC79, 0xE150, 0xE82F, 0xF116,
    0xF93E, 0x0147, 0x09E0, 0x0F91, 0x1318, 0x131C, 0x0FDF, 0x0AB3, 0x03C1, 0xFDD8, 0xFBD3, 0xFD6C, 0x018F, 0x05C6, 0x088E, 0x09A9,
    0x0903, 0x066E, 0x03ED, 0x0425, 0x065B, 0x09EC, 0x0D55, 0x1076, 0x1429, 0x198C, 0x21FC, 0x2B38, 0x32FC, 0x375D, 0x3811, 0x391E,
    0x3A14, 0x3AB5, 0x3B2F, 0x3B1F, 0x3BCC, 0x3A98, 0x3587, 0x2D27, 0x2195, 0x12CF, 0x0336, 0xF60A, 0xED66, 0xEA4D, 0xE9E7, 0xE8C6,
    0xE568, 0xE0DE, 0xDA8F, 0xD248, 0xCA4D, 0xC5F1, 0xC481, 0xC4CA, 0xC666, 0xC80E, 0xCB62, 0xCD91, 0xD103, 0xD620, 0xD9B4, 0xDCA8,
    0xDF07, 0xE3DD, 0xEA9F, 0xF250, 0xFA0E, 0x00BE, 0x07E5, 0x0D9F, 0x104C, 0x10D8, 0x0DE7, 0x0871, 0xFFD3, 0xF5D0, 0xEEC5, 0xEB05,
    0xEACB, 0xEB85, 0xECA7, 0xEEE2, 0xEF92, 0xEEEE, 0xECD1, 0xEBA3, 0xED50, 0xEF06, 0xF1F2, 0xF544, 0xF832, 0xFCC3, 0x03AA, 0x0CBE,
    0x14E0, 0x1ACB, 0x1E4C, 0x1FE3, 0x2257, 0x256A, 0x2864, 0x2B9B, 0x2F08, 0x31F4, 0x32EE, 0x3001, 0x2A26, 0x213B, 0x1622, 0x0AFD,
    0x02CA, 0xFFB5, 0xFFAE, 0x011A, 0x0147, 0xFFEC, 0xFDA0, 0xF8FB, 0xF335, 0xEF68, 0xEE2C, 0xEF27, 0xF129, 0xF23F, 0xF298, 0xF318,
    0xF5A6, 0xFA0E, 0xFF12, 0x02D7, 0x04DF, 0x070A, 0x0A3D, 0x0F4A, 0x1473, 0x1982, 0x1F87, 0x24FA, 0x2860, 0x29B1, 0x29C3, 0x2657,
    0x1F43, 0x162A, 0x0D00, 0x0664, 0x024D, 0xFF90, 0xFD13, 0xFBA3, 0xFA4C, 0xF71D, 0xF2FD, 0xEF3E, 0xEDA8, 0xEDCA, 0xEF29, 0xF123,
    0xF3B2, 0xF6A4, 0xFA67, 0x0101, 0x0764, 0x0C47, 0x0EA6, 0x0E3E, 0x0ED0, 0x1043, 0x11AF, 0x1482, 0x17D0, 0x1B05, 0x1BE6, 0x191A,
    0x1360, 0x0A5E, 0x0045, 0xF59D, 0xECB2, 0xE8E7, 0xE8AA, 0xE9BD, 0xEA4C, 0xEAA0, 0xE9B4, 0xE590, 0xE016, 0xDB9A, 0xD993, 0xD8CB,
    0xD8D0, 0xD892, 0xD7AD, 0xD643, 0xD6D0, 0xD9E2, 0xDED3, 0xE4A3, 0xE82B, 0xECA2, 0xF224, 0xF87F, 0x002D, 0x07FA, 0x10CD, 0x19CA,
    0x211D, 0x25A5, 0x26DE, 0x2539, 0x2050, 0x16E0, 0x0C3C, 0x0264, 0xFB7D, 0xF702, 0xF401, 0xF38B, 0xF3AC, 0xF344, 0xF0D0, 0xED14,
    0xE9E9, 0xE792, 0xE62A, 0xE602, 0xE698, 0xE80A, 0xEBA9, 0xF1CA, 0xFA23, 0x00D2, 0x05E1, 0x09A0, 0x0D64, 0x1315, 0x1937, 0x1F58,
    0x2594, 0x2B3E, 0x2EB4, 0x2F10, 0x2D01, 0x2870, 0x2172, 0x1852, 0x0E46, 0x0635, 0x00A4, 0xFD36, 0xF9F1, 0xF721, 0xF5D4, 0xF417,
    0xF1D8, 0xEF1C, 0xEE20, 0xEE8C, 0xEDD7, 0xECB2, 0xEA7F, 0xE655, 0xE288, 0xE0F5, 0xE21D, 0xE405, 0xE5AE, 0xE6FF, 0xE829, 0xEC35,
    0xF147, 0xF783, 0xFFF1, 0x08E3, 0x117A, 0x1820, 0x1C6D, 0x1EB6, 0x1D33, 0x1769, 0x116B, 0x0AF1, 0x0572, 0x03C0, 0x03EE, 0x05E7,
    0x0982, 0x0D08, 0x0DFE, 0x0C9A, 0x0C00, 0x0B9A, 0x0BBA, 0x0DBE, 0x102F, 0x1315, 0x15DA, 0x19BE, 0x1F95, 0x2500, 0x2818, 0x2940,
    0x2A28, 0x2C71, 0x2EA9, 0x3043, 0x31A4, 0x327F, 0x32F7, 0x2FF4, 0x2B1E, 0x258A, 0x1D81, 0x1414, 0x089C, 0xFE24, 0xF652, 0xEFFC,
    0xEAD7, 0xE6A2, 0xE4CF, 0xE320, 0xE048, 0xDCF1, 0xD9E6, 0xD8C9, 0xD880, 0xD795, 0xD675, 0xD40B, 0xD1BE, 0xD123, 0xD281, 0xD6A4,
    0xDA14, 0xDD06, 0xDF97, 0xE2AE, 0xE73A, 0xEA9C, 0xEF67, 0xF560, 0xFC9E, 0x0389, 0x08B3, 0x0BDD, 0x0B4B, 0x07C0, 0x003C, 0xF846,
    0xF251, 0xEE82, 0xEE2F, 0xF0B5, 0xF4C6, 0xF963, 0xFCDF, 0xFE0F, 0xFDEA, 0xFDFF, 0xFF2E, 0x01E8, 0x05BA, 0x08F2, 0x0BEA, 0x1084,
    0x1773, 0x1FD1, 0x26D7, 0x2B55, 0x2F53, 0x343D, 0x3A01, 0x3EB2, 0x4199, 0x4290, 0x425F, 0x4057, 0x3C1D, 0x3680, 0x2FD2, 0x2741,
    0x1C29, 0x106A, 0x05B6, 0xFCCF, 0xF5A8, 0xEF80, 0xEB79, 0xE94D, 0xE640, 0xE221, 0xDD83, 0xD8D6, 0xD4EC, 0xD1C6, 0xCEE1, 0xCBFF,
    0xC98B, 0xC8DB, 0xCAED, 0xCF61, 0xD3F9, 0xD84C, 0xDC77, 0xE036, 0xE522, 0xEA07, 0xEFC8, 0xF70D, 0xFF2C, 0x0722, 0x0D3C, 0x10F9,
    0x117F, 0x0DC1, 0x061C, 0xFB66, 0xF0C9, 0xE97D, 0xE46E, 0xE2D7, 0xE3E8, 0xE768, 0xEA2E, 0xE982, 0xE8DF, 0xE885, 0xE932, 0xEB6D,
    0xEF13, 0xF303, 0xF5E5, 0xF906, 0xFDAC, 0x03D2, 0x0B4D, 0x1224, 0x17FC, 0x1EC6, 0x25D2, 0x2B6F, 0x2EC9, 0x30F2, 0x328B, 0x3303,
    0x3275, 0x3121, 0x2EFE, 0x2AEC, 0x22F1, 0x179A, 0x0CDC, 0x0387, 0xFB9A, 0xF5A1, 0xF2A5, 0xF294, 0xF30C, 0xF27C, 0xF10C, 0xEF13,
    0xED13, 0xEBC7, 0xEB0E, 0xEA99, 0xE9CA, 0xE931, 0xEA85, 0xEEFD, 0xF572, 0xFB3D, 0x0004, 0x0556, 0x0B81, 0x11C0, 0x183B, 0x1EB8,
    0x25B3, 0x2C7F, 0x31EC, 0x368F, 0x391D, 0x389E, 0x3350, 0x29BE, 0x1ECC, 0x1584, 0x0E7D, 0x0906, 0x05D7, 0x04AB, 0x037A, 0x003D,
    0xFAED, 0xF3E5, 0xEE2B, 0xEBB6, 0xEB16, 0xEC31, 0xECC1, 0xECA1, 0xEDA7, 0xF109, 0xF736, 0xFE04, 0x03CF, 0x08D4, 0x0D77, 0x119F,
    0x1425, 0x1567, 0x1628, 0x15B4, 0x15E9, 0x1645, 0x15A6, 0x142A, 0x0EE0, 0x05E4, 0xFAC7, 0xF074, 0xE82F, 0xE16B, 0xDDB6, 0xDD03,
    0xDE25, 0xDF3F, 0xDF6B, 0xDEDD, 0xDD9B, 0xDBC8, 0xDACD, 0xD980, 0xD709, 0xD47C, 0xD37E, 0xD5AC, 0xDA57, 0xDF39, 0xE329, 0xE6A2,
    0xEAD8, 0xEFBA, 0xF554, 0xFC9E, 0x050D, 0x0EED, 0x1864, 0x2027, 0x2688, 0x296E, 0x2716, 0x1FB8, 0x1544, 0x0BC2, 0x0421, 0xFE33,
    0xFB0B, 0xFABA, 0xFBB9, 0xFA98, 0xF816, 0xF512, 0xF21C, 0xF12B, 0xF1C2, 0xF315, 0xF3ED, 0xF2D7, 0xF18B, 0xF243, 0xF5F2, 0xFBCA,
    0x01BE, 0x0754, 0x0CDE, 0x1171, 0x142D, 0x15E7, 0x17EC, 0x1A38, 0x1CB7, 0x1F8B, 0x2291, 0x2493, 0x22D2, 0x1C29, 0x10FB, 0x04DD,
    0xF9F4, 0xF0A6, 0xEABC, 0xE7D8, 0xE72F, 0xE785, 0xE73B, 0xE5FD, 0xE42E, 0xE287, 0xE1C3, 0xE161, 0xE153, 0xE0B3, 0xE027, 0xE12C,
    0xE3E5, 0xE82A, 0xEAFF, 0xECCA, 0xEE39, 0xF01E, 0xF2FF, 0xF781, 0xFE29, 0x05F4, 0x0E90, 0x1637, 0x1D35, 0x21EB, 0x22ED, 0x1F71,
    0x1727, 0x0DB7, 0x04C7, 0xFD90, 0xF909, 0xF6FD, 0xF7E9, 0xF948, 0xFA78, 0xFB4A, 0xFA74, 0xFA1D, 0xFB83, 0xFD9B, 0x0028, 0x01D6,
    0x02B4, 0x04C9, 0x0A22, 0x12BA, 0x1AF1, 0x22F3, 0x29B2, 0x2DA4, 0x2FC3, 0x304D, 0x3124, 0x31DF, 0x3248, 0x3306, 0x3369, 0x3400,
    0x3215, 0x2B96, 0x2143, 0x1408, 0x0702, 0xFB0E, 0xF135, 0xEB58, 0xE7EE, 0xE634, 0xE59B, 0xE36D, 0xDFBD, 0xDB2C, 0xD7B2, 0xD559,
    0xD29F, 0xD05E, 0xCD6B, 0xCBD3, 0xCD0A, 0xCFBA, 0xD339, 0xD5BA, 0xD816, 0xDAE5, 0xDDEC, 0xE248, 0xE807, 0xEF73, 0xF71A, 0xFDC9,
    0x0336, 0x0717, 0x0951, 0x0699, 0xFFB1, 0xF6E9, 0xEE42, 0xE692, 0xE0A4, 0xDE15, 0xDE3D, 0xE019, 0xE2B0, 0xE4FE, 0xE75B, 0xE98B,
    0xEB9D, 0xEFB0, 0xF40C, 0xF72C, 0xF9BB, 0xFC77, 0x01F3, 0x0A37, 0x13CC, 0x1D80, 0x2563, 0x2DE0, 0x3510, 0x3841, 0x3A88, 0x3DE2,
    0x4246, 0x45BB, 0x4803, 0x49FC, 0x4934, 0x4368, 0x39C4, 0x2BD3, 0x1C13, 0x0D41, 0xFFEE, 0xF708, 0xF245, 0xEFA5, 0xEE88, 0xECA0,
    0xE9FC, 0xE4AC, 0xDE69, 0xD992, 0xD47E, 0xD058, 0xCB70, 0xC803, 0xC7EB, 0xC947, 0xCC0D, 0xCED7, 0xD1AE, 0xD569, 0xD941, 0xDE41,
    0xE506, 0xED4B, 0xF76F, 0x005A, 0x08B1, 0x0F93, 0x1489, 0x169F, 0x13BE, 0x0E0B, 0x05E7, 0xFCCC, 0xF39F, 0xEBD1, 0xE771, 0xE593,
    0xE52F, 0xE552, 0xE56A, 0xE481, 0xE280, 0xE142, 0xE116, 0xE0BE, 0xE03A, 0xE096, 0xE424, 0xEC0E, 0xF578, 0xFF30, 0x07D7, 0x0EC9,
    0x144D, 0x17A7, 0x1AF0, 0x1F55, 0x2444, 0x2932, 0x2D0F, 0x3081, 0x338D, 0x33AE, 0x2FE0, 0x2857, 0x1E5B, 0x135E, 0x081F, 0xFF20,
    0xFA33, 0xF7FD, 0xF84F, 0xF979, 0xF9BC, 0xF80E, 0xF49B, 0xF0F3, 0xEE0C, 0xEC4B, 0xE9D7, 0xE6E3, 0xE658, 0xE808, 0xEB35, 0xEF15,
    0xF285, 0xF69C, 0xFB69, 0x0089, 0x0642, 0x0E05, 0x1796, 0x20FF, 0x2835, 0x2E10, 0x336A, 0x36B3, 0x35E5, 0x3133, 0x2B17, 0x2282,
    0x1942, 0x1154, 0x0BC1, 0x0A16, 0x0A86, 0x0C52, 0x0D18, 0x0C42, 0x0A57, 0x05CA, 0x01AD, 0xFD47, 0xF87C, 0xF50E, 0xF306, 0xF5EE,
    0xFB91, 0x01B2, 0x08BD, 0x0E9F, 0x1378, 0x15BC, 0x16B5, 0x1827, 0x19FB, 0x1D6E, 0x2039, 0x22E0, 0x25A0, 0x2548, 0x212B, 0x186C,
    0x0C53, 0xFE74, 0xF09A, 0xE522, 0xDD0E, 0xD9F7, 0xDA1F, 0xDB2D, 0xDC0C, 0xDBA3, 0xDA18, 0xD81B, 0xD727, 0xD728, 0xD6FE, 0xD5D2,
    0xD4BE, 0xD57D, 0xD71A, 0xD919, 0xDB0B, 0xDCE0, 0xE0B0, 0xE5B3, 0xEB77, 0xF233, 0xFA5D, 0x03AE, 0x0C38, 0x158F, 0x1EBE, 0x26A0,
    0x2B82, 0x2AEE, 0x2708, 0x1FD7, 0x16C8, 0x0D9E, 0x05AD, 0x0206, 0x0094, 0x0288, 0x052C, 0x04BF, 0x0336, 0xFED7, 0xFB42, 0xF876,
    0xF4F5, 0xF293, 0xF09B, 0xF20D, 0xF6AF, 0xFCF4, 0x03E7, 0x08B3, 0x0C9F, 0x0E8D, 0x0ECB, 0x1027, 0x1290, 0x16FB, 0x1BF4, 0x2139,
    0x2698, 0x2AB4, 0x2B8C, 0x279A, 0x20E3, 0x17B7, 0x0D45, 0x034D, 0xFAAC, 0xF533, 0xF1FB, 0xF0B3, 0xEFFA, 0xED8B, 0xEA0E, 0xE572,
    0xE14E, 0xDE69, 0xDC8A, 0xDB8F, 0xD96C, 0xD8FE, 0xDAD3, 0xDDBD, 0xE0B1, 0xE37B, 0xE803, 0xECC8, 0xF1E6, 0xF5B0, 0xF9ED, 0xFF0D,
    0x0374, 0x09A5, 0x10E7, 0x1880, 0x1F35, 0x2199, 0x1FDC, 0x1990, 0x1020, 0x0570, 0xFB12, 0xF5C4, 0xF45F, 0xF6E0, 0xFB77, 0xFE47,
    0x0016, 0xFF73, 0xFE22, 0xFE5A, 0xFE79, 0xFEFA, 0xFE98, 0x00F7, 0x0681, 0x0D0F, 0x1595, 0x1C4B, 0x22C2, 0x2856, 0x2C0C, 0x2F8A,
    0x326B, 0x36EE, 0x3B38, 0x3F37, 0x4373, 0x4659, 0x4738, 0x42F7, 0x3AA2, 0x2FC8, 0x2146, 0x129F, 0x04F8, 0xFA61, 0xF395, 0xEF11,
    0xED26, 0xEAFC, 0xE850, 0xE451, 0xE03F, 0xDDE2, 0xDB2D, 0xD8CE, 0xD590, 0xD15A, 0xCED4, 0xCE03, 0xCEA5, 0xD046, 0xD348, 0xD7C0,
    0xDC77, 0xE1A9, 0xE700, 0xED26, 0xF3EA, 0xFB23, 0x042D, 0x0E1E, 0x17A1, 0x1D43, 0x1E19, 0x18E3, 0x0F10, 0x03B4, 0xF7D5, 0xEF36,
    0xEA88, 0xE8D6, 0xEA31, 0xEB18, 0xEA8F, 0xE817, 0xE4AE, 0xE2EF, 0xE2B5, 0xE4A0, 0xE68E, 0xE91E, 0xEDAD, 0xF3AE, 0xFBF4, 0x0398,
    0x0A2C, 0x1094, 0x1559, 0x199C, 0x1E0A, 0x2394, 0x2A8D, 0x31A3, 0x39AD, 0x40AA, 0x46B4, 0x49C3, 0x47FF, 0x432D, 0x3AEA, 0x309F,
    0x25EF, 0x1BE5, 0x1333, 0x0C3F, 0x07CF, 0x0478, 0x0125, 0xFCC3, 0xF72B, 0xF2EC, 0xEF46, 0xEA32, 0xE344, 0xDB60, 0xD45B, 0xCFC9,
    0xCD96, 0xCCCF, 0xCE19, 0xD092, 0xD2E7, 0xD5D6, 0xD952, 0xDD79, 0xE2B3, 0xE8A9, 0xF039, 0xFA01, 0x0497, 0x0C4F, 0x103D, 0x0FF0,
    0x0AB4, 0x0314, 0xFA63, 0xF3B6, 0xF074, 0xF007, 0xF1B3, 0xF41C, 0xF5A9, 0xF3A3, 0xEF9D, 0xEBF0, 0xE95D, 0xE8C3, 0xE80E, 0xE70A,
    0xE780, 0xE96E, 0xED8A, 0xF241, 0xF74D, 0xFC95, 0x018B, 0x06A1, 0x0A08, 0x0EBB, 0x1444, 0x18ED, 0x1E41, 0x233B, 0x277D, 0x2A34,
    0x29E3, 0x25D2, 0x1E0F, 0x146E, 0x0A23, 0x0082, 0xF90C, 0xF38D, 0xF155, 0xF09A, 0xF0B0, 0xF1B8, 0xF1DE, 0xF1BB, 0xF228, 0xF1D4,
    0xEF33, 0xEB06, 0xE6F2, 0xE3AC, 0xE319, 0xE499, 0xE7A0, 0xEC04, 0xF0F5, 0xF5E2, 0xFA7C, 0x009F, 0x07A8, 0x1009, 0x196D, 0x2329,
    0x2D5C, 0x3577, 0x39AD, 0x39CA, 0x34BF, 0x2BDA, 0x21EC, 0x18D9, 0x11A8, 0x0DAE, 0x0D8D, 0x0E79, 0x1062, 0x10C8, 0x0E31, 0x0B94,
    0x0936, 0x07E7, 0x06FB, 0x051C, 0x0336, 0x014E, 0x0086, 0x00AC, 0x0224, 0x053E, 0x0738, 0x0980, 0x0AFF, 0x0CA9, 0x1048, 0x1324,
    0x1586, 0x1869, 0x1BC9, 0x1DAA, 0x1D5D, 0x1B46, 0x1599, 0x0D42, 0x0338, 0xF7A5, 0xEDC6, 0xE519, 0xDE67, 0xDAD6, 0xD92D, 0xD910,
    0xD89F, 0xD77B, 0xD679, 0xD653, 0xD5CF, 0xD348, 0xD03F, 0xCE40, 0xCDD9, 0xCFB8, 0xD2FC, 0xD686, 0xDA72, 0xDDA0, 0xDFAD, 0xE2A5,
    0xE78A, 0xEDDC, 0xF4C2, 0xFC40, 0x04C1, 0x0D7C, 0x139A, 0x1604, 0x152A, 0x10CF, 0x099E, 0x02DB, 0xFCBB, 0xF7E1, 0xF65F, 0xF61D,
    0xF6C1, 0xF821, 0xF7CB, 0xF683, 0xF597, 0xF691, 0xF836, 0xF970, 0xFADE, 0xFB4E, 0xFD5B, 0x0041, 0x03AA, 0x0741, 0x0B99, 0x0D87,
    0x18E9, 0x22A2, 0x2117, 0x230E, 0x23EB, 0x2425, 0x24C9, 0x274B, 0x26DC, 0x28B5, 0x2648, 0x211A, 0x1973, 0x0D77, 0x03AC, 0xF9B3,
    0xF2A2, 0xECBC, 0xEF5D, 0xECE8, 0xF00B, 0xE71A, 0xDEAB, 0xEF17, 0xEF50, 0xEBFA, 0xE843, 0xE5FC, 0xE46B, 0xE449, 0xE483, 0xE67A,
    0xEC7C, 0xEC78, 0xEE9C, 0xF254, 0xFD1C, 0x03AF, 0x0744, 0x0976, 0x0D56, 0x1176, 0x15CF, 0x1958, 0x0E70, 0x0A51, 0x0649, 0xFE96,
    0xFB6C, 0xF76E, 0xF5DE, 0xF42E, 0xF2C5, 0xF088, 0xF23E, 0xF6B0, 0xF6E3, 0xFA52, 0xFF59, 0x048A, 0x0A1A, 0x0EBB, 0x1323, 0x175F,
    0x1B78, 0x1DC0, 0x201B, 0x234B, 0x2677, 0x27F6, 0x2BAF, 0x2D1A, 0x2D30, 0x2D11, 0x2BD5, 0x2BC7, 0x2A45, 0x295C, 0x2713, 0x2465,
    0x2177, 0x1B6A, 0x155A, 0x0ED5, 0x0926, 0x0399, 0xFE07, 0xFC44, 0xFB48, 0xFACD, 0xFB01, 0xFA41, 0xF94B, 0xF835, 0xF5DE, 0xF509,
    0xF559, 0xF570, 0xF37F, 0xF1A6, 0xF034, 0xEE3B, 0xEE14, 0xED0F, 0xED9A, 0xEF83, 0xF217, 0xF389, 0xF54C, 0xF6E2, 0xF6D8, 0xF69A,
    0xF52C, 0xF3CA, 0xF348, 0xF229, 0xF1A2, 0xF1B6, 0xF1DA, 0xF17C, 0xF002, 0xEEA1, 0xED2E, 0xED09, 0xEDBC, 0xEEDA, 0xF300, 0xF7C7,
    0xFD29, 0x03AE, 0x0911, 0x0F9C, 0x14B8, 0x18DE, 0x1C8A, 0x205C, 0x2464, 0x26D7, 0x29F7, 0x2C1A, 0x2D92, 0x2E7F, 0x2D23, 0x2BBD,
    0x2AA1, 0x287E, 0x26B2, 0x24D0, 0x220A, 0x1DFC, 0x1988, 0x13DE, 0x0D47, 0x092C, 0x05CA, 0x02E5, 0x01B5, 0x003B, 0xFEA0, 0xFCA5,
    0xFA8E, 0xF899, 0xF750, 0xF604, 0xF461, 0xF3F7, 0xF18D, 0xEE07, 0xEA58, 0xE5F0, 0xE2B0, 0xE144, 0xE1C2, 0xE334, 0xE638, 0xE975,
    0xEB84, 0xECE1, 0xED82, 0xED19, 0xEC7E, 0xEB1D, 0xEAC0, 0xEB21, 0xEADE, 0xEBA7, 0xECC3, 0xED8B, 0xEE12, 0xEF4A, 0xF071, 0xF0DF,
    0xF229, 0xF34F, 0xF626, 0xFA11, 0xFDF8, 0x01A8, 0x04A8, 0x071B, 0x07ED, 0x08CD, 0x091F, 0x09B6, 0x0BA3, 0x0CA4, 0x0E33, 0x1008,
    0x10BE, 0x1170, 0x1240, 0x12AE, 0x1294, 0x1270, 0x1173, 0x0ED1, 0x0C24, 0x080E, 0x034D, 0xFFCF, 0xFC59, 0xFA20, 0xF91B, 0xF8C9,
    0xF8F3, 0xF93A, 0xF932, 0xF865, 0xF7D8, 0xF7A3, 0xF79A, 0xF949, 0xFAB2, 0xFC49, 0xFDB6, 0xFC73, 0xF98C, 0xF693, 0xF466, 0xF318,
    0xF421, 0xF609, 0xF8B2, 0xFCC7, 0x0014, 0x026B, 0x0462, 0x058B, 0x05E6, 0x0652, 0x06A9, 0x06BC, 0x06A3, 0x05EA, 0x04B1, 0x0458,
    0x0376, 0x02F7, 0x0397, 0x03CC, 0x053F, 0x07D4, 0x0B4C, 0x100C, 0x1641, 0x1BEC, 0x1F6E, 0x225D, 0x234D, 0x22AD, 0x2259, 0x2176,
    0x20B7, 0x2064, 0x1F5E, 0x1E12, 0x1C12, 0x18F1, 0x15AE, 0x12E7, 0x0F83, 0x0BBE, 0x086D, 0x03D4, 0xFDF6, 0xF791, 0xF076, 0xE9B8,
    0xE44D, 0xDFA0, 0xDC0F, 0xDA20, 0xD88A, 0xD6FE, 0xD648, 0xD474, 0xD2FD, 0xD258, 0xD160, 0xD254, 0xD408, 0xD51A, 0xD574, 0xD59E,
    0xD5A3, 0xD527, 0xD608, 0xD73E, 0xD9B3, 0xDDEA, 0xE1AA, 0xE5A4, 0xE996, 0xEC2C, 0xEDC6, 0xEE9D, 0xEE86, 0xEECF, 0xEFE4, 0xF020,
    0xF046, 0xF152, 0xF17F, 0xF175, 0xF1AA, 0xF066, 0xEF9D, 0xEF3C, 0xEF21, 0xEF99, 0xF1A3, 0xF443, 0xF708, 0xFB03, 0xFDFE, 0x00BD,
    0x02AC, 0x0365, 0x0436, 0x0546, 0x063B, 0x070F, 0x0847, 0x082C, 0x0766, 0x064A, 0x043B, 0x02F2, 0x02B4, 0x01D9, 0x002F, 0xFD5D,
    0xF907, 0xF403, 0xEE7C, 0xE920, 0xE548, 0xE3FA, 0xE39F, 0xE475, 0xE713, 0xE8D8, 0xEA6A, 0xEB7B, 0xEBBE, 0xECBC, 0xEDA7, 0xEE6A,
    0xEED2, 0xEEE4, 0xED79, 0xEB13, 0xE898, 0xE549, 0xE335, 0xE2E2, 0xE3AD, 0xE666, 0xEA3B, 0xED80, 0xF03E, 0xF2D5, 0xF41B, 0xF490,
    0xF4C5, 0xF3BC, 0xF2F9, 0xF307, 0xF26F, 0xF24A, 0xF242, 0xF166, 0xF0C6, 0xEF90, 0xEE1D, 0xED46, 0xEDF5, 0xEF6F, 0xF1AC, 0xF507,
    0xF7FE, 0xFB70, 0xFF59, 0x0284, 0x0601, 0x0A4A, 0x0E16, 0x121D, 0x1597, 0x1797, 0x1989, 0x1ADA, 0x1A5A, 0x19AC, 0x19F3, 0x19E2,
    0x192D, 0x187C, 0x16D4, 0x1479, 0x11F1, 0x0D9D, 0x08A6, 0x0448, 0xFF2F, 0xFB94, 0xF956, 0xF6F6, 0xF573, 0xF366, 0xF0DA, 0xEEBA,
    0xED38, 0xEBFC, 0xEAC8, 0xEAB3, 0xE99F, 0xE89B, 0xE7C5, 0xE56F, 0xE3A1, 0xE1BE, 0xDFEF, 0xDF3D, 0xDFD5, 0xE165, 0xE375, 0xE610,
    0xE73D, 0xE7F2, 0xE95A, 0xE946, 0xE936, 0xE930, 0xE8B3, 0xE92B, 0xE9CE, 0xE9B3, 0xEA0B, 0xEAA5, 0xEAA2, 0xE979, 0xE8E4, 0xE8CC,
    0xE990, 0xEB44, 0xEC70, 0xEF17, 0xF1DE, 0xF32F, 0xF3E6, 0xF4EC, 0xF5DC, 0xF84C, 0xFB54, 0xFE7E, 0x0301, 0x07EE, 0x0B37, 0x0E27,
    0x111B, 0x13E7, 0x1668, 0x1964, 0x1C53, 0x1E40, 0x2007, 0x1ED4, 0x1DB9, 0x1AC3, 0x197B, 0x200B, 0x1F0C, 0x1A29, 0x197A, 0x1D66,
    0x1FF1, 0x14D3, 0x12F1, 0x1944, 0x17AE, 0x0F72, 0x0E61, 0x10EB, 0x13D4, 0x0FED, 0x0A79, 0x05CC, 0x0294, 0x01FD, 0xF7F6, 0xF4AE,
    0xF26B, 0xF1C8, 0xF116, 0xEFF3, 0xEDA8, 0xEA6E, 0xE862, 0xE981, 0xE8C8, 0xE5A1, 0xE1B0, 0xE41D, 0xE684, 0xE5E4, 0xE1F3, 0xE050,
    0xDF85, 0xDE90, 0xE0EA, 0xDC74, 0xDE3A, 0xDFE3, 0xEA39, 0xF071, 0xF317, 0xF640, 0xFF6E, 0x080F, 0x08E1, 0x0A96, 0x0DE3, 0x1512,
    0x1BFA, 0x1AB4, 0x194D, 0x1D50, 0x1B80, 0x1A4C, 0x1889, 0x1938, 0x1E21, 0x1D9D, 0x1923, 0x1B04, 0x187A, 0x1707, 0x0F2B, 0x0BF1,
    0x0F7F, 0x0E11, 0x08B0, 0x085A, 0x0363, 0x02D4, 0x0372, 0xFD43, 0x018C, 0xFF17, 0x04AE, 0x0350, 0x042E, 0x0261, 0x01E2, 0x0414,
    0x006E, 0x0330, 0x01A7, 0x01D0, 0x065B, 0x0608, 0x044B, 0x128A, 0x10DF, 0x1061, 0x0C88, 0x1706, 0x16CD, 0x0ADA, 0x143B, 0x125E,
    0x1B12, 0x0E90, 0x1607, 0x14F1, 0x0EEA, 0x0E67, 0x12E2, 0x0C56, 0x099C, 0x1317, 0x0403, 0x12BC, 0x07E2, 0x1546, 0x1158, 0x08CE,
    0x1D26, 0x1C45, 0x1F9C, 0x2AAD, 0x2A76, 0x17A9, 0x2AC9, 0x2337, 0x2B7B, 0x3133, 0x147B, 0x30E5, 0x27F6, 0x1DFB, 0x2B55, 0x1AB2,
    0x2D41, 0x146C, 0xFF44, 0x24B2, 0x0CB3, 0xF545, 0xFB58, 0x00BF, 0xFF46, 0xF2FD, 0xE7FF, 0xFF4C, 0xF183, 0xE212, 0xF631, 0xEE25,
    0xECF7, 0xD6C5, 0xF998, 0xFD18, 0xC95D, 0xD462, 0xDF36, 0xDA33, 0xD817, 0xD2CF, 0xDA8F, 0xE5D8, 0xE1A7, 0xE823, 0xE996, 0xEBE1,
    0xECB6, 0xE8C5, 0xFE1E, 0xF9E5, 0xF320, 0xF903, 0xFD57, 0xF57F, 0xF95B, 0xFE06, 0xF860, 0xE12A, 0xF17E, 0x07C6, 0xF12B, 0x04D5,
    0xEB7C, 0x0F45, 0x1202, 0x0378, 0x0BD0, 0x109A, 0x23C2, 0x0E99, 0x122F, 0x255E, 0x29EB, 0x0A8A, 0x1FD5, 0x270C, 0x27D4, 0x13C2,
    0x1BA1, 0x3313, 0x1169, 0x1F4F, 0x1E5E, 0x1819, 0x1B77, 0x0339, 0x0F9D, 0x0D40, 0x017A, 0xFE72, 0xF8AF, 0xEA3D, 0xEB74, 0xE031,
    0xDE3F, 0x0E58, 0xEC87, 0xF2D4, 0xED6B, 0xF214, 0x03FE, 0xE8B8, 0xED4D, 0xF50A, 0xE2FD, 0xD7F7, 0x0449, 0xEC25, 0xEC02, 0xDF13,
    0xFD96, 0x0103, 0xD505, 0x0D1B, 0xF080, 0x01CB, 0x01A9, 0xFFD4, 0x0EE8, 0x0C16, 0x03ED, 0x0DDB, 0x22C7, 0xF3AB, 0x08FA, 0x0F95,
    0x0DEC, 0x00A9, 0x10EB, 0x05D1, 0x0727, 0x228B, 0x135D, 0x0775, 0x1150, 0x1A59, 0x072A, 0x286D, 0x1746, 0x0CA7, 0x1FDE, 0x1E00,
    0x146C, 0x2AD4, 0x2EF4, 0x11C9, 0x2D1A, 0x3298, 0x2A56, 0x29B9, 0x2069, 0x2D42, 0x1C84, 0x2695, 0x1F73, 0x28FA, 0x16D7, 0x04BB,
    0x2950, 0x0C31, 0x0446, 0x01D3, 0x1609, 0x09C1, 0x0F04, 0x1BA2, 0x086F, 0x0651, 0x0E52, 0x0EDA, 0xE9DF, 0xFF38, 0xF47D, 0xE31E,
    0xFEA8, 0xE5DD, 0xE966, 0xF076, 0xF4A9, 0xDF91, 0xFC1E, 0xEE2F, 0xD6C9, 0xF535, 0xEE8B, 0xF257, 0xE830, 0xE5E4, 0xE9EE, 0x05D5,
    0xE080, 0xDE81, 0xEF24, 0xE313, 0xE41B, 0xE5D9, 0xEA27, 0xF280, 0xE995, 0xFB67, 0x04F5, 0xF50F, 0xFCAC, 0x13BA, 0xFDA0, 0xFF5A,
    0x0F04, 0xFDC5, 0xFA2E, 0x0622, 0x12AD, 0x0569, 0x2674, 0x0D9E, 0x0F10, 0x18C0, 0x387E, 0x0E76, 0x16ED, 0x2357, 0x14C3, 0x12FF,
    0x1395, 0x2806, 0x00A6, 0x0EA8, 0x09A5, 0x1D54, 0x011E, 0x0C0A, 0x1231, 0x01C7, 0xF618, 0x16D3, 0x26C3, 0xF958, 0xFB22, 0x0D6A,
    0x05FA, 0xFE70, 0xF0C2, 0xEB86, 0xEE02, 0xF038, 0xE2F3, 0xE4E0, 0xEE15, 0xE05A, 0xEDB6, 0xE876, 0xDC73, 0xDFFB, 0xF810, 0xD089,
    0xF2FC, 0xDD62, 0xE634, 0xF4CE, 0xD62D, 0xE351, 0xE0CC, 0xECB8, 0xE3C7, 0xE200, 0xDB23, 0xF0C8, 0xECD9, 0xDADD, 0xED8D, 0x085E,
    0xED20, 0xFB19, 0x0BB8, 0xFB11, 0xFFB7, 0x11F8, 0x0E2A, 0x0147, 0xFBDF, 0x0EF7, 0x03B1, 0x1618, 0x150E, 0xF75D, 0x0C21, 0x036F,
    0x1541, 0x081A, 0xE8A9, 0x09D7, 0xFB91, 0xE88C, 0x0306, 0xE746, 0xEFF9, 0xF479, 0xDF0D, 0xE5A1, 0x003B, 0xDFD5, 0xE800, 0xEC3E,
    0xF418, 0x03AC, 0xEB3D, 0x01A7, 0xF963, 0xEE52, 0x00C8, 0xF4F2, 0xEDB1, 0xF77F, 0xF658, 0xFEB1, 0xED2C, 0x0433, 0x0E28, 0xF2D7,
    0x0CD3, 0x118F, 0x0668, 0x1F77, 0x0C63, 0x2550, 0x0F84, 0x1898, 0x29AA, 0x0C99, 0x2401, 0x1C56, 0x248C, 0x1797, 0x0C09, 0x1FFB,
    0x17C7, 0x1501, 0x1BCB, 0x1595, 0x2AF5, 0x139C, 0x2113, 0x469E, 0x220B, 0x25F3, 0x34D9, 0x2594, 0x396E, 0x306E, 0x22B9, 0x2F86,
    0x3ABD, 0x1C63, 0x3F14, 0x29E5, 0x0CBD, 0x2F52, 0x1A9A, 0x1EC3, 0x0D30, 0x07FE, 0x037C, 0x0A03, 0xE422, 0xE48A, 0xEE28, 0xD47D,
    0xD7A3, 0xD683, 0xE240, 0xD449, 0xD11D, 0xE9AF, 0xD4DB, 0xD84B, 0xDD1B, 0xDC23, 0xC7C7, 0xCDB0, 0xD6A3, 0xD11F, 0xD44F, 0xCBEF,
    0xEB0B, 0xBD64, 0xDEA4, 0xD68B, 0xD5D7, 0xED8D, 0xE0A9, 0xE55C, 0xE1A2, 0x0833, 0xF78C, 0xEFAD, 0xFAF3, 0x09FF, 0xE757, 0xF8F3,
    0x093D, 0xEDF5, 0xFA77, 0xFD45, 0xFAE7, 0xF690, 0xFEA6, 0xF472, 0x079C, 0xF862, 0x001B, 0x1022, 0xFA53, 0x1216, 0xF7F5, 0x067A,
    0x0CC5, 0x086C, 0x1D6D, 0x0C63, 0x1D02, 0x15BA, 0x1521, 0x2531, 0x1BCA, 0x134E, 0x1CDF, 0x165C, 0x13BA, 0x218C, 0x0A85, 0x1D50,
    0x0969, 0x1774, 0x0E68, 0xF086, 0x10C4, 0xF6D1, 0x0CEF, 0xFFE2, 0x0C71, 0x0A35, 0x00E7, 0x0D53, 0xFF93, 0x06E1, 0xFF7E, 0xF96E,
    0xF1B2, 0xFBDE, 0xF4BA, 0xF45F, 0xFAEB, 0xE92B, 0xF007, 0x02FA, 0xE506, 0xF69B, 0xF691, 0xFA08, 0xF3F4, 0xE8A7, 0x0A84, 0xEDF7,
    0xF671, 0x0572, 0xE9C6, 0xEBB0, 0x0D06, 0xE91F, 0xED53, 0xEDBD, 0xE985, 0xF63F, 0xE524, 0xFFA2, 0xF212, 0xFF31, 0xFBBA, 0xED13,
    0xF4AD, 0xF09C, 0xF50B, 0x0698, 0x0C0E, 0x1004, 0x0532, 0x0A04, 0x0D03, 0x0D91, 0x0CFF, 0xFCA1, 0x0D76, 0x199B, 0x0C2C, 0xF8FC,
    0x3549, 0x30B8, 0x19E6, 0x149C, 0x19A5, 0x1230, 0x1622, 0x0AB1, 0xF4E3, 0x15F6, 0xF9A9, 0x0036, 0x18F8, 0x1DFE, 0x1E74, 0x2151,
    0x0EDE, 0x20A9, 0x12C3, 0x0116, 0x1185, 0xF7CD, 0xF09A, 0xF25A, 0xE05F, 0x037F, 0x036E, 0x0401, 0x142B, 0x0D61, 0x1A57, 0x0798,
    0xFB96, 0xD3AE, 0xBF2B, 0xB0A1, 0xB57D, 0xB20B, 0xC22D, 0xC0AE, 0xB652, 0xBF5E, 0xD972, 0xC1B4, 0xCA8D, 0xE7AB, 0xEAEB, 0xF65E,
    0xE929, 0x100B, 0xE28D, 0xF565, 0xFBE7, 0xF797, 0x1A52, 0x3446, 0x3A3E, 0x465E, 0x5790, 0x496B, 0x4E19, 0x6299, 0x59E3, 0x3F95,
    0x539D, 0x3E79, 0x3EDB, 0x0F3D, 0xE881, 0xE130, 0xD5D8, 0xD544, 0xD98C, 0xD666, 0xD204, 0xD679, 0xEE5A, 0xEE31, 0xDC1F, 0x07E3,
    0x1317, 0x1CB9, 0x08D9, 0x1EDE, 0x1826, 0xF429, 0x0291, 0x06BD, 0x109C, 0x25D6, 0x3294, 0x327E, 0x34E0, 0x36CC, 0x3F83, 0x2FCA,
    0x3216, 0x398F, 0x23B4, 0x22BD, 0x1C49, 0xF289, 0xD96A, 0xBA32, 0xB4E4, 0xB2E5, 0xBF80, 0xBDEA, 0xB530, 0xC0EA, 0xC69B, 0xC481,
    0xBC6F, 0xD1DE, 0xD9A6, 0xE9BE, 0xDE23, 0xED9F, 0xEE37, 0xE042, 0xE17D, 0xD7E2, 0xF351, 0x075D, 0x23A7, 0x2B67, 0x3018, 0x45EE,
    0x47E2, 0x4D87, 0x508D, 0x55A1, 0x47CF, 0x4005, 0x5644, 0x2FAE, 0x01D2, 0xF4E4, 0xE314, 0xD2AA, 0xDC50, 0xDC94, 0xD4E9, 0xDA13,
    0xDF68, 0xEC39, 0xDF65, 0xEDEC, 0x02F3, 0x0192, 0xFBE9, 0x0E56, 0x04D6, 0xF85E, 0x0078, 0xE3A0, 0xFB2E, 0xFFCA, 0x0F1C, 0x28B9,
    0x1E06, 0x2388, 0x2B17, 0x3642, 0x32A6, 0x36FA, 0x2EA1, 0x32A3, 0x41CD, 0x25BA, 0x0375, 0xFADE, 0xE880, 0xE5CF, 0xDBFD, 0xDACC,
    0xF24C, 0xE8B1, 0xE5E2, 0xF423, 0xF81F, 0xF493, 0x0F5C, 0x0FAB, 0x0F4F, 0x1383, 0x1D48, 0x12F3, 0xF76D, 0xFE05, 0x04C1, 0x1353,
    0x1E8F, 0x3475, 0x42B9, 0x4A16, 0x4897, 0x570F, 0x5758, 0x50B3, 0x5FB1, 0x4989, 0x5637, 0x532D, 0x2B59, 0x16CB, 0xF9A8, 0xEF4E,
    0xE0B3, 0xE37C, 0xE3FB, 0xDE03, 0xDAC0, 0xDB24, 0xE536, 0xD71A, 0xE6D2, 0xF12A, 0xEC1C, 0xE792, 0xFB1D, 0xF294, 0xD75C, 0xE240,
    0xD131, 0xD644, 0xE2EA, 0xEDA3, 0xF5C2, 0xF711, 0xF899, 0x05BE, 0x03B7, 0x029A, 0x080E, 0xFC4E, 0x0F07, 0x0526, 0xF087, 0xDFFA,
    0xCB57, 0xC9D0, 0xC7B4, 0xBD14, 0xCBA5, 0xD190, 0xCB11, 0xD2C2, 0xE019, 0xD6AA, 0xDF02, 0xF4DF, 0xEDF5, 0xFBAE, 0x0473, 0x1631,
    0x0283, 0xF927, 0x0690, 0x0D17, 0x1C29, 0x2400, 0x45E2, 0x48DE, 0x487D, 0x559D, 0x54CA, 0x629D, 0x5DCE, 0x50AB, 0x5963, 0x5B54,
    0x5219, 0x3761, 0x1CB2, 0x0AF8, 0xFF3D, 0xEFD5, 0xEAB6, 0xF879, 0xE936, 0xEA7D, 0xFA3D, 0xEA30, 0xE8D2, 0xF559, 0x00B5, 0xFC01,
    0xFF15, 0x08DD, 0x013A, 0xF6BA, 0xEC3C, 0xECCF, 0xF2BE, 0xF6F4, 0x05C3, 0x11EC, 0x1316, 0x1884, 0x1D8B, 0x2894, 0x2473, 0x1B1A,
    0x2566, 0x2A4C, 0x232E, 0x145A, 0xF80B, 0xF4CE, 0xE193, 0xE18E, 0xDAA9, 0xDD6D, 0xE4B3, 0xDC46, 0xECA6, 0xE131, 0xE490, 0xE711,
    0xFBDE, 0xF427, 0xF720, 0x0429, 0x059E, 0xFFEC, 0xF2A9, 0xFAD8, 0xFC3E, 0x0806, 0x1D11, 0x2459, 0x2283, 0x2C59, 0x37EE, 0x31A2,
    0x3856, 0x37EA, 0x2CE6, 0x36D0, 0x2F48, 0x26C9, 0x0CCD, 0xF295, 0xE2B5, 0xDA34, 0xCA90, 0xD87F, 0xCFCF, 0xD45D, 0xE885, 0xDB59,
    0xDFAE, 0xE6BD, 0xFB96, 0xFB79, 0xFB22, 0x01F3, 0x116D, 0x0506, 0xFB92, 0xF25B, 0xFC69, 0x022F, 0x0CA6, 0x20BC, 0x19A1, 0x2EEC,
    0x2B02, 0x31D2, 0x3317, 0x2CA1, 0x3096, 0x2F12, 0x340A, 0x2DEE, 0x1B77, 0xFC3F, 0xE82E, 0xE3C0, 0xD2FD, 0xD4C4, 0xD3FC, 0xCEEE,
    0xDC58, 0xD535, 0xD74E, 0xD7AA, 0xE116, 0xE703, 0xE5E4, 0xF3D8, 0xF9BD, 0x0344, 0xF113, 0xF261, 0xF44B, 0xF9B7, 0x110A, 0x13E3,
    0x2E4B, 0x319F, 0x336A, 0x3BF3, 0x47BD, 0x469C, 0x3CBD, 0x4341, 0x4442, 0x3A02, 0x257B, 0x10C1, 0xF4FD, 0xE2A1, 0xD517, 0xD7F4,
    0xD3FD, 0xCD00, 0xD600, 0xDAE0, 0xD2DC, 0xD8B1, 0xE04E, 0xDCC8, 0xE6E3, 0xEC7C, 0xF7C4, 0xFB99, 0xF3A2, 0xEDE9, 0xE41B, 0xE750,
    0xF704, 0xFD95, 0x0536, 0x0DF3, 0x11AD, 0x1F5A, 0x2455, 0x244A, 0x1FDE, 0x1FDF, 0x2A26, 0x277E, 0x1B5F, 0x08E1, 0xF884, 0xDEE9,
    0xD02C, 0xD06E, 0xC3AA, 0xC030, 0xC8D4, 0xC841, 0xC4F1, 0xBFC8, 0xC766, 0xCA9D, 0xC898, 0xCCBE, 0xD577, 0xD6CB, 0xD495, 0xD4B8,
    0xCC47, 0xCB8E, 0xD64E, 0xEB84, 0xEF8D, 0xFBF3, 0x07A6, 0x120E, 0x1F6A, 0x271C, 0x26FB, 0x2328, 0x313C, 0x3670, 0x2C30, 0x1769,
    0x02BA, 0xF017, 0xDE2D, 0xDB68, 0xD62F, 0xCC50, 0xD636, 0xE15C, 0xD417, 0xD93F, 0xE241, 0xE260, 0xECD1, 0xE565, 0xF73B, 0x0195,
    0xFA04, 0xF840, 0xF6F9, 0xE9CA, 0xF3D6, 0xFE1F, 0x0000, 0x15BC, 0x12A9, 0x1B96, 0x1DD6, 0x268A, 0x2A1C, 0x26EB, 0x2886, 0x30A3,
    0x3393, 0x2494, 0x176D, 0xFC58, 0xED1D, 0xE91B, 0xE6E7, 0xDCEF, 0xE38B, 0xE8FE, 0xE67F, 0xE3BA, 0xE3B9, 0xF0B2, 0xF134, 0xF265,
    0xF7DD, 0x0700, 0x0A9B, 0xFE4B, 0xFCF0, 0xFDC7, 0xF77F, 0x03C2, 0x15E4, 0x21FD, 0x2C4C, 0x351E, 0x427C, 0x48BC, 0x46DD, 0x4B2A,
    0x486E, 0x4B2E, 0x53A9, 0x40FB, 0x3267, 0x1B13, 0xFDA9, 0xF13E, 0xEA43, 0xD992, 0xD952, 0xD9D0, 0xD864, 0xD7F8, 0xCCDE, 0xD71B,
    0xDB5E, 0xCFA3, 0xD17E, 0xE083, 0xDDEE, 0xDC3C, 0xD146, 0xCBC8, 0xC995, 0xC8FC, 0xD49F, 0xDA29, 0xDE22, 0xE169, 0xE72C, 0xEF5F,
    0xEDC9, 0xEB6B, 0xF3D5, 0xEFAF, 0xFCC4, 0xF3AB, 0xEBDA, 0xDE1F, 0xC399, 0xBF6F, 0xBB69, 0xBA0B, 0xB4BA, 0xBFFC, 0xC83F, 0xC65D,
    0xC3E1, 0xCDA2, 0xD45B, 0xD484, 0xDD4D, 0xEB73, 0xF51D, 0xF772, 0xF536, 0xF768, 0xF59E, 0xFBFA, 0x079D, 0x1202, 0x23A4, 0x25E8,
    0x2D5D, 0x3D8B, 0x452A, 0x44E6, 0x46AB, 0x454F, 0x4B12, 0x4B76, 0x4190, 0x2E72, 0x1096, 0x05E6, 0xFD8E, 0xEB6C, 0xECAC, 0xE9EC,
    0xEC29, 0xEFD7, 0xE782, 0xF1D2, 0xF29B, 0xF8CB, 0xF861, 0xFC4B, 0x0930, 0x06BB, 0x0636, 0xFF24, 0xF4DE, 0xF4A6, 0xF5B3, 0xFCB9,
    0x1060, 0x078A, 0x0824, 0x1583, 0x130F, 0x1579, 0x10BC, 0x14A2, 0x14F1, 0x121C, 0x135E, 0x0245, 0xE569, 0xD7EF, 0xCE7E, 0xC050,
    0xC1AE, 0xBE57, 0xC5D8, 0xC48E, 0xC53E, 0xC757, 0xC9C3, 0xD1B2, 0xD217, 0xD964, 0xDAB9, 0xEE5C, 0xF073, 0xEC8D, 0xEA86, 0xE608,
    0xEF41, 0xFC28, 0x0A2D, 0x0F48, 0x1930, 0x27D7, 0x2E8B, 0x340E, 0x3220, 0x30A0, 0x3A14, 0x349B, 0x2CB5, 0x2244, 0x0A92, 0xF17B,
    0xDE76, 0xD42A, 0xCAD2, 0xC6D3, 0xCCEC, 0xCBDD, 0xCB52, 0xCDF8, 0xD7E5, 0xD70B, 0xDAA3, 0xE547, 0xEC76, 0xF312, 0xF9D9, 0xF950,
    0xF13E, 0xEE0C, 0xE82F, 0xEDE8, 0xF966, 0x08D6, 0x0659, 0x1094, 0x1E72, 0x29ED, 0x2488, 0x22EB, 0x2F0F, 0x2FCC, 0x365D, 0x29D8,
    0x217C, 0x09DB, 0xF9CF, 0xEECC, 0xDA9C, 0xD850, 0xD7AF, 0xDE84, 0xDB84, 0xDC02, 0xE5D4, 0xE490, 0xEB73, 0xEDF4, 0xF07D, 0xFC04,
    0x051E, 0x0024, 0x008D, 0xFBAC, 0xF409, 0xFC11, 0x0716, 0x130A, 0x1754, 0x27B7, 0x3215, 0x3A79, 0x3969, 0x3AF3, 0x3EA0, 0x3CE8,
    0x3F43, 0x368B, 0x2742, 0x0F42, 0xFB23, 0xE909, 0xDAD6, 0xCEED, 0xCDE3, 0xD3E6, 0xCFBE, 0xCC01, 0xD7B7, 0xD6B9, 0xDA02, 0xDEF9,
    0xE3F5, 0xEFC4, 0xF4AE, 0xFAEA, 0xF725, 0xF845, 0xEE79, 0xEEBB, 0xF2C4, 0xFF8A, 0x0442, 0x0452, 0x1296, 0x194E, 0x1DB8, 0x1880,
    0x201B, 0x23D4, 0x248D, 0x296C, 0x21F7, 0x0960, 0xF3E4, 0xE608, 0xDC9C, 0xCB7C, 0xC90A, 0xC9BC, 0xC8CC, 0xC8B7, 0xC717, 0xCCE5,
    0xC7F9, 0xCDED, 0xCBF9, 0xD434, 0xDCD8, 0xE46A, 0xE2A7, 0xDE24, 0xD8C5, 0xD3E5, 0xE2A1, 0xEB5E, 0xF8C1, 0x0238, 0x1094, 0x2114,
    0x282A, 0x2862, 0x29DB, 0x3045, 0x3172, 0x3706, 0x32BA, 0x2558, 0x134B, 0xFC75, 0xEE54, 0xDD74, 0xD827, 0xDA1A, 0xD67C, 0xD5CD,
    0xD55B, 0xD9EF, 0xDB39, 0xDB5B, 0xDEAB, 0xDF6E, 0xEB39, 0xEFE7, 0xF574, 0xEEF7, 0xE9D7, 0xE52C, 0xE8AF, 0xF52E, 0xF953, 0x054F,
    0x07C3, 0x19E9, 0x225E, 0x26E0, 0x25CF, 0x2A45, 0x30C0, 0x3681, 0x3996, 0x2DD1, 0x215A, 0x0E6D, 0x02F5, 0xF5FE, 0xF00B, 0xEF82,
    0xF445, 0xF3D5, 0xEF82, 0xF54B, 0xFAAB, 0xF93C, 0x0060, 0x0360, 0x0B06, 0x156A, 0x1520, 0x19A8, 0x102F, 0x0706, 0x0316, 0x0D8C,
    0x1645, 0x1DA6, 0x2B55, 0x35EC, 0x43C0, 0x4736, 0x463C, 0x4413, 0x49E5, 0x4A23, 0x4AA7, 0x43CD, 0x30FB, 0x1FDD, 0x0C61, 0xFC3A,
    0xEA8F, 0xE2FA, 0xE5BA, 0xE013, 0xDD85, 0xDCA8, 0xDD68, 0xE0BF, 0xDE87, 0xE1FE, 0xE5AF, 0xE877, 0xEB2B, 0xEDFC, 0xE3D0, 0xD783,
    0xD55A, 0xD9A2, 0xDD0A, 0xE179, 0xE3E8, 0xEA21, 0xF35C, 0xF2D5, 0xF341, 0xEDAD, 0xF039, 0xF50E, 0xF636, 0xF0FC, 0xE524, 0xD4A6,
    0xC643, 0xBDF7, 0xB1ED, 0xAF2B, 0xB3AF, 0xB39D, 0xB39D, 0xB79A, 0xBB40, 0xBF1D, 0xC255, 0xC9DD, 0xCF68, 0xDC93, 0xE25F, 0xEA55,
    0xEEEF, 0xE490, 0xE947, 0xED95, 0xFC7C, 0x08EF, 0x143C, 0x21C1, 0x2FC4, 0x3AB2, 0x3BC6, 0x40D0, 0x4254, 0x4772, 0x4C5B, 0x4CCC,
    0x437E, 0x32A4, 0x26DD, 0x1772, 0x03DB, 0xF926, 0xF8F8, 0xF88C, 0xF590, 0xF6CC, 0xF85D, 0xFBAF, 0xFAE7, 0xFB54, 0xFDEF, 0x0718,
    0x0DEA, 0x1195, 0x1289, 0x0665, 0x00E4, 0xF7AC, 0xFE0A, 0x02EA, 0x05A5, 0x0CFD, 0x16B1, 0x216A, 0x2174, 0x24A6, 0x1E8A, 0x205F,
    0x25CA, 0x25AA, 0x21CD, 0x14B6, 0x04CE, 0xF8B3, 0xE3C0, 0xDA5E, 0xD3FF, 0xD388, 0xD42B, 0xCC45, 0xD3A2, 0xD70A, 0xDD03, 0xDA90,
    0xDD4C, 0xE510, 0xE4B3, 0xEE72, 0xEEBF, 0xE7CE, 0xE3B9, 0xDDE7, 0xE595, 0xEEDF, 0xFB19, 0x02C2, 0x107E, 0x20C9, 0x22B0, 0x2A0A,
    0x2699, 0x2375, 0x26B3, 0x2958, 0x25BE, 0x1656, 0x05FE, 0xF69A, 0xE25A, 0xD444, 0xCC36, 0xCC43, 0xCAA5, 0xC724, 0xCAEB, 0xCD50,
    0xD4A2, 0xD427, 0xDB9C, 0xE366, 0xEA07, 0xF4E7, 0xFD63, 0x0192, 0xF835, 0xEFAE, 0xEF43, 0xF6B2, 0xFABC, 0xFF11, 0x0C37, 0x1722,
    0x1E6F, 0x24EF, 0x23B3, 0x2829, 0x2B5C, 0x3290, 0x35C7, 0x2C63, 0x2208, 0x14DB, 0x0494, 0xF1C0, 0xE92E, 0xE2F9, 0xDF71, 0xDED3,
    0xDD8E, 0xDF6E, 0xE634, 0xE6A4, 0xEAED, 0xF13A, 0xF737, 0xFE59, 0x0703, 0x0908, 0x02F3, 0xFECC, 0xFF1F, 0x09C8, 0x12E4, 0x1C3A,
    0x28AE, 0x3740, 0x3FE7, 0x4726, 0x4627, 0x4363, 0x44B7, 0x4A67, 0x4BE2, 0x44BD, 0x36D9, 0x28A0, 0x1529, 0xFB40, 0xEE0C, 0xE2AA,
    0xDE76, 0xD780, 0xD4B1, 0xD428, 0xD5EC, 0xD62E, 0xD566, 0xD964, 0xDCE2, 0xE4E0, 0xEA1C, 0xEFF7, 0xEB2E, 0xE589, 0xE179, 0xE48C,
    0xEBF2, 0xF192, 0xFBB6, 0x050C, 0x10C0, 0x1707, 0x1C28, 0x1A92, 0x1A3D, 0x1F8A, 0x271A, 0x2666, 0x1EE5, 0x14EA, 0x03A5, 0xEF16,
    0xDF32, 0xD914, 0xD349, 0xD1DB, 0xCF1D, 0xCFA1, 0xD4BB, 0xD5EB, 0xD77D, 0xD95B, 0xDA89, 0xDC5C, 0xE1E8, 0xE920, 0xE5B4, 0xE1D9,
    0xD9DE, 0xDCE0, 0xE457, 0xE6BB, 0xF001, 0xFDF3, 0x0B9C, 0x1774, 0x1EF3, 0x1FBE, 0x20AB, 0x21D6, 0x2ADB, 0x298D, 0x22FE, 0x18D8,
    0x0CDA, 0xF7A3, 0xEA18, 0xDF47, 0xD9E7, 0xD9CB, 0xD4D5, 0xD7B3, 0xDA30, 0xE01F, 0xE3DF, 0xE765, 0xEBA3, 0xF38E, 0xF990, 0xFF73,
    0xFF5A, 0xF929, 0xF194, 0xF2CF, 0xF789, 0xFE35, 0x04C2, 0x112B, 0x1B9A, 0x2515, 0x2C66, 0x2CCA, 0x2BBC, 0x2C58, 0x3492, 0x3641,
    0x34BB, 0x2B33, 0x22CF, 0x0EBD, 0xFD86, 0xEF52, 0xE822, 0xE89A, 0xE63A, 0xE86B, 0xEBBF, 0xF2CC, 0xF4EC, 0xF9B3, 0xFC3F, 0x006D,
    0x099C, 0x1310, 0x19A2, 0x15C8, 0x0EA9, 0x0D08, 0x10E5, 0x15A1, 0x19E4, 0x2355, 0x3014, 0x3C07, 0x44A1, 0x4B04, 0x4A48, 0x4901,
    0x4DE4, 0x50D5, 0x4E65, 0x4803, 0x3E43, 0x2C3D, 0x192F, 0x0660, 0xFAC8, 0xF525, 0xEE12, 0xE97F, 0xE7F3, 0xE867, 0xE868, 0xE7E4,
    0xE6F7, 0xE885, 0xEB76, 0xF241, 0xF57E, 0xEF6B, 0xE5E3, 0xDCCC, 0xDC44, 0xDC46, 0xDE9D, 0xE4F1, 0xEC67, 0xF623, 0xFDD8, 0x02BD,
    0xFEA3, 0xFD19, 0x00CB, 0x069B, 0x0812, 0x03E3, 0xFD45, 0xF00F, 0xDEE5, 0xCF23, 0xC500, 0xC0F6, 0xBF4B, 0xBD49, 0xC0DF, 0xC434,
    0xC7FA, 0xCBF3, 0xCD3F, 0xD11D, 0xD4CE, 0xDE4C, 0xE872, 0xEABC, 0xE68C, 0xE2DC, 0xE77A, 0xEA8F, 0xF213, 0xFC2E, 0x0935, 0x192F,
    0x2592, 0x2F36, 0x3230, 0x3178, 0x3852, 0x408C, 0x4355, 0x42FB, 0x3D0C, 0x337C, 0x22BA, 0x1228, 0x05A7, 0xFE3D, 0xF6E9, 0xF4FF,
    0xF590, 0xF90E, 0xFC21, 0xFF75, 0x0417, 0x03A2, 0x0710, 0x0D91, 0x1865, 0x1BDF, 0x1593, 0x0DB9, 0x08EA, 0x089C, 0x079B, 0x099D,
    0x106C, 0x15C2, 0x1B85, 0x22D8, 0x2343, 0x20D2, 0x22CA, 0x2821, 0x2BD5, 0x2858, 0x2647, 0x195C, 0x0935, 0xF702, 0xE5FC, 0xDF8D,
    0xD826, 0xD75F, 0xD5A2, 0xD6EC, 0xD94F, 0xDB87, 0xDE12, 0xDF9B, 0xE374, 0xE904, 0xF304, 0xF9CD, 0xF77B, 0xEEE4, 0xED4B, 0xEE28,
    0xF1F8, 0xFA58, 0x0385, 0x1195, 0x1DAB, 0x28C8, 0x2CF8, 0x2A8B, 0x2AB8, 0x2F5A, 0x32D8, 0x3573, 0x3336, 0x2D06, 0x1CD8, 0x0789,
    0xF4C9, 0xE680, 0xDC6A, 0xD3C9, 0xD3A5, 0xD04F, 0xD0AE, 0xD13C, 0xD4D4, 0xD608, 0xD78A, 0xDCE9, 0xE3F0, 0xEDA6, 0xEC75, 0xE861,
    0xE634, 0xE487, 0xE7A1, 0xE9B2, 0xECB6, 0xF63E, 0xFE9D, 0x0C73, 0x12A4, 0x14BF, 0x1782, 0x1DFB, 0x2688, 0x2B4B, 0x2E55, 0x29BD,
    0x20FD, 0x0F91, 0xFFD5, 0xF57D, 0xEEC3, 0xEBE1, 0xE97C, 0xEB04, 0xED1B, 0xF05F, 0xF487, 0xF6CA, 0xF99C, 0xFBF8, 0x02BF, 0x0D50,
    0x1193, 0x0DCA, 0x08E1, 0x07D4, 0x0955, 0x0C73, 0x132D, 0x1C38, 0x2786, 0x35CC, 0x3FB1, 0x40E9, 0x40DB, 0x43EF, 0x4686, 0x491D,
    0x4782, 0x439D, 0x38C4, 0x26D1, 0x13CE, 0x010C, 0xF443, 0xE91D, 0xE408, 0xDEE1, 0xDE08, 0xE092, 0xE136, 0xE41F, 0xE57D, 0xE529,
    0xE96A, 0xF258, 0xF5D5, 0xF328, 0xEC53, 0xEAF7, 0xEAFF, 0xEEA4, 0xF200, 0xF835, 0x00A7, 0x0C5D, 0x16E3, 0x18FA, 0x1A44, 0x1DDC,
    0x21C0, 0x231D, 0x259E, 0x23C7, 0x1E1A, 0x0E59, 0xFD4B, 0xEB09, 0xDD4A, 0xD57F, 0xCDEF, 0xCB5F, 0xCBDA, 0xCD0A, 0xCFB6, 0xD3FA,
    0xD72B, 0xD77B, 0xDB63, 0xE53A, 0xEAAB, 0xEBA3, 0xE6BD, 0xE607, 0xE604, 0xE819, 0xECE2, 0xF136, 0xF88D, 0x03AA, 0x101E, 0x1770,
    0x19D2, 0x1BFE, 0x216D, 0x24E7, 0x291C, 0x29B2, 0x2557, 0x1AB7, 0x078F, 0xF44C, 0xE602, 0xDABE, 0xD379, 0xD1DE, 0xD107, 0xD30D,
    0xD5E5, 0xD822, 0xDBE2, 0xDCB8, 0xDF7E, 0xE96A, 0xF340, 0xF668, 0xF37E, 0xF0CB, 0xEF97, 0xEFD1, 0xF23D, 0xF545, 0xFD00, 0x0ACB,
    0x1A15, 0x2416, 0x2816, 0x2B80, 0x311D, 0x356E, 0x3966, 0x3D12, 0x3DD8, 0x395B, 0x2BA1, 0x1DC9, 0x116A, 0x0611, 0xFD41, 0xF7BB,
    0xF647, 0xF721, 0xFA04, 0xFE8F, 0x01F8, 0x02F4, 0x038D, 0x09CC, 0x1414, 0x1995, 0x1964, 0x15BD, 0x138F, 0x122A, 0x14FD, 0x171F,
    0x1A42, 0x2248, 0x2CC1, 0x3535, 0x35A3, 0x3646, 0x3772, 0x3B3D, 0x3E98, 0x3FAE, 0x4166, 0x3B09, 0x2F51, 0x1F4F, 0x0EB5, 0x007D,
    0xF4E4, 0xEE56, 0xE8DD, 0xE84C, 0xE753, 0xE9D5, 0xEB56, 0xE7B0, 0xE4F4, 0xE82F, 0xF02B, 0xF54C, 0xF549, 0xEF21, 0xEA02, 0xE3B1,
    0xE14A, 0xE1B3, 0xE215, 0xE6E2, 0xF20D, 0xFDA4, 0x02E1, 0x0452, 0x063C, 0x07F6, 0x0979, 0x0B50, 0x0A5F, 0x0725, 0xFB95, 0xEB8B,
    0xDC9B, 0xCF0C, 0xC663, 0xC006, 0xBDDC, 0xBD5B, 0xBD7A, 0xC0B0, 0xC246, 0xC36F, 0xC3D4, 0xC797, 0xD185, 0xDA71, 0xDEE6, 0xE06D,
    0xDF5F, 0xDFCE, 0xE3CF, 0xE9A1, 0xF022, 0xFAC4, 0x0BBE, 0x1BC1, 0x26E5, 0x2BDF, 0x2F65, 0x3540, 0x3A05, 0x3F89, 0x4515, 0x46B1,
    0x433E, 0x3829, 0x2B20, 0x1D65, 0x10B0, 0x0839, 0x00D2, 0xFCDD, 0xFAD1, 0xFB24, 0xFDEB, 0xFDCE, 0xFB0B, 0xFB8E, 0x018E, 0x093D,
    0x0CEC, 0x0C60, 0x0992, 0x0572, 0x0307, 0x024A, 0x01CF, 0x046F, 0x0DC0, 0x1905, 0x2132, 0x248A, 0x23FA, 0x24AF, 0x25B8, 0x288D,
    0x2CE9, 0x2CF1, 0x2676, 0x1A35, 0x0A13, 0xF9E3, 0xEC62, 0xE1EF, 0xDB0E, 0xD6FD, 0xD5CC, 0xD61F, 0xD986, 0xDAF9, 0xD85B, 0xD754,
    0xDB54, 0xE44A, 0xEA97, 0xED5C, 0xEE63, 0xEC19, 0xEB03, 0xED13, 0xEDA9, 0xF0F5, 0xFB96, 0x0976, 0x167B, 0x1EA9, 0x219B, 0x255E,
    0x2914, 0x2A88, 0x2ED3, 0x3141, 0x2FFF, 0x27C4, 0x19A0, 0x0AAC, 0xFB3F, 0xEF7C, 0xE5F5, 0xDF65, 0xDBE7, 0xDA33, 0xDAD6, 0xDC6E,
    0xDBE7, 0xDA79, 0xDE8B, 0xE74E, 0xED6D, 0xF242, 0xF257, 0xEF2F, 0xED72, 0xEE48, 0xF057, 0xF16A, 0xF7F0, 0x0317, 0x0F03, 0x15CD,
    0x1970, 0x1B83, 0x1C11, 0x1EA2, 0x23C9, 0x27CD, 0x28B5, 0x237A, 0x183C, 0x0A1E, 0xFB46, 0xEED1, 0xE598, 0xE0EA, 0xDE84, 0xDDB5,
    0xE066, 0xE4E4, 0xE3DD, 0xE3AD, 0xE723, 0xEFB1, 0xFA2E, 0x007A, 0x03A6, 0x0314, 0x027C, 0x0443, 0x0729, 0x0748, 0x0C73, 0x1886,
    0x26A6, 0x3136, 0x384F, 0x3BD5, 0x3F96, 0x43D2, 0x4650, 0x4B39, 0x4BC3, 0x475D, 0x3C3D, 0x2CCA, 0x1B05, 0x0A61, 0xFD24, 0xF2AA,
    0xEBD7, 0xE632, 0xE4A0, 0xE4C0, 0xE2E3, 0xDE96, 0xDD2F, 0xE191, 0xE75D, 0xEBA8, 0xEDAD, 0xEB07, 0xE67E, 0xE4BA, 0xE2C9, 0xE243,
    0xE4F2, 0xED3E, 0xFA53, 0x06AD, 0x0D7E, 0x126D, 0x1650, 0x173F, 0x1B99, 0x21D2, 0x261C, 0x26F1, 0x22D3, 0x1986, 0x0D3C, 0xFF26,
    0xF347, 0xEA8F, 0xE354, 0xDED0, 0xDD88, 0xDF84, 0xE120, 0xDF48, 0xDE6D, 0xE2C8, 0xEAE0, 0xF2BC, 0xF78F, 0xF7F1, 0xF3BB, 0xF16E,
    0xEF9B, 0xEDD2, 0xEDFB, 0xF33B, 0xFD7C, 0x070A, 0x0C3C, 0x0ED2, 0x1157, 0x11CE, 0x13B8, 0x1718, 0x1AF4, 0x1A9E, 0x1612, 0x0C5B,
    0xFF18, 0xF089, 0xE2B6, 0xD9A7, 0xD25F, 0xCE80, 0xCE8A, 0xD176, 0xD42B, 0xD3AC, 0xD1C3, 0xD4C7, 0xDB90, 0xE39E, 0xEA5B, 0xEBF1,
    0xEA4F, 0xE88B, 0xE92C, 0xE8FE, 0xE8CF, 0xEED0, 0xF93D, 0x063D, 0x10F6, 0x1888, 0x1F0C, 0x2313, 0x26AB, 0x2B9F, 0x31D8, 0x3545,
    0x33D1, 0x2E37, 0x25CB, 0x19D0, 0x0EE0, 0x06E8, 0x01BE, 0xFD33, 0xF9E2, 0xFC55, 0x004A, 0x0127, 0x002A, 0x02FC, 0x0AED, 0x14AF,
    0x1E3D, 0x232C, 0x22AC, 0x20FF, 0x2084, 0x202F, 0x1EF3, 0x2271, 0x2B25, 0x363D, 0x3E70, 0x44D6, 0x4792, 0x468D, 0x45E0, 0x46E0,
    0x49D2, 0x4B52, 0x4907, 0x422F, 0x3773, 0x29B0, 0x19B5, 0x0C5E, 0x01EC, 0xF67C, 0xEEAE, 0xEAE2, 0xEAC4, 0xE97E, 0xE549, 0xE30F,
    0xE3BB, 0xE68E, 0xEB4A, 0xEBE8, 0xE886, 0xE3CF, 0xDFF5, 0xDCE3, 0xD733, 0xD549, 0xD9FD, 0xE2DB, 0xEC80, 0xF373, 0xF8A4, 0xFC2C,
    0xFCF8, 0x000B, 0x04B0, 0x08C6, 0x09DF, 0x04F8, 0xFC96, 0xF14D, 0xE2CD, 0xD6EE, 0xCD58, 0xC60F, 0xC0F2, 0xBF95, 0xC31B, 0xC4FC,
    0xC45F, 0xC3FC, 0xC683, 0xCC45, 0xD51D, 0xDCEB, 0xE0CC, 0xE2DA, 0xE470, 0xE54A, 0xE50B, 0xE566, 0xEBCF, 0xF7F2, 0x0560, 0x1269,
    0x1D69, 0x242D, 0x27B4, 0x2B4F, 0x31AD, 0x3742, 0x3B84, 0x3B6C, 0x37AE, 0x3138, 0x26A1, 0x1BA6, 0x11FE, 0x091D, 0x002D, 0xFA72,
    0xF9AA, 0xFB15, 0xF953, 0xF7E2, 0xF804, 0xFDA3, 0x0694, 0x0E88, 0x111C, 0x0FEB, 0x0F69, 0x0F5A, 0x0DC0, 0x0B0C, 0x0D83, 0x148C,
    0x1EDB, 0x2776, 0x2E00, 0x30BD, 0x304D, 0x2DDD, 0x2CD6, 0x2EE3, 0x2F91, 0x2D8E, 0x273B, 0x1BD8, 0x0B67, 0xFABA, 0xEC32, 0xDF3C,
    0xD3F9, 0xCC10, 0xCA7A, 0xCB0A, 0xC9CC, 0xC8DF, 0xC96A, 0xCCF0, 0xD52D, 0xDDE8, 0xE4BE, 0xE777, 0xEA37, 0xECB5, 0xEC8A, 0xEB99,
    0xEC5A, 0xF3AE, 0xFE37, 0x0A8A, 0x1643, 0x1E09, 0x21EB, 0x237E, 0x2581, 0x2AB8, 0x2ECD, 0x301F, 0x2D2F, 0x25D8, 0x18DF, 0x0890,
    0xFA25, 0xECDC, 0xE167, 0xD865, 0xD47B, 0xD492, 0xD31D, 0xCFE7, 0xCD74, 0xCC88, 0xD124, 0xD802, 0xDE0E, 0xDFAE, 0xE0DF, 0xE32F,
    0xE385, 0xE207, 0xE1C5, 0xE8B0, 0xF3DC, 0x0089, 0x0D7C, 0x170A, 0x1C1B, 0x1E6D, 0x1FF6, 0x245E, 0x29ED, 0x2DF5, 0x2F72, 0x2CA7,
    0x24B8, 0x184A, 0x0AFB, 0xFE73, 0xF134, 0xE684, 0xE202, 0xE286, 0xE3EA, 0xE3B7, 0xE2BF, 0xE435, 0xEA7A, 0xF4FA, 0xFEE5, 0x0448,
    0x064B, 0x07B2, 0x07BC, 0x0492, 0x010A, 0x0309, 0x0AFA, 0x14EE, 0x1FF9, 0x28E8, 0x2EF1, 0x30FB, 0x31B3, 0x3447, 0x3899, 0x3C79,
    0x3E45, 0x3C25, 0x347D, 0x2757, 0x17F0, 0x0870, 0xF8D8, 0xEAFD, 0xE1BB, 0xDF48, 0xDD9C, 0xD9B8, 0xD5D3, 0xD245, 0xD1D4, 0xD69E,
    0xDC76, 0xDF40, 0xDE9E, 0xDE1C, 0xDDEA, 0xDB64, 0xD7A3, 0xD862, 0xDE38, 0xE705, 0xF1B7, 0xFCA2, 0x051E, 0x0B10, 0x0E63, 0x126B,
    0x1897, 0x1DE3, 0x223D, 0x22E7, 0x1E9E, 0x14B9, 0x0857, 0xFC7F, 0xF17B, 0xE67A, 0xDEA7, 0xDB93, 0xDA02, 0xD82F, 0xD4E4, 0xD231,
    0xD35D, 0xD9AB, 0xE3BC, 0xEB51, 0xEEF6, 0xF0D4, 0xF27D, 0xF1E6, 0xED5B, 0xEC80, 0xF0DC, 0xF9BD, 0x0535, 0x0F74, 0x16D3, 0x1A3D,
    0x19F9, 0x1ACC, 0x1DFC, 0x2191, 0x24CC, 0x24D0, 0x208B, 0x15F3, 0x07F1, 0xFA17, 0xEBF5, 0xDD70, 0xD16A, 0xCC32, 0xCA23, 0xC910,
    0xC775, 0xC46A, 0xC33D, 0xC53E, 0xCB64, 0xD026, 0xD229, 0xD35C, 0xD46D, 0xD420, 0xD0F5, 0xCFB8, 0xD34C, 0xDB4E, 0xE6B4, 0xF378,
    0xFF5C, 0x0842, 0x0F09, 0x14FB, 0x1C9A, 0x255C, 0x2C9A, 0x3124, 0x31D6, 0x2D31, 0x235B, 0x1965, 0x0EFA, 0x0284, 0xF8B7, 0xF496,
    0xF46F, 0xF676, 0xF82C, 0xF824, 0xF7FC, 0xFB8E, 0x040F, 0x0E6E, 0x1484, 0x180D, 0x1B67, 0x1D04, 0x1BF5, 0x1933, 0x1A29, 0x1F5D,
    0x287C, 0x3257, 0x3B8B, 0x411B, 0x4329, 0x4387, 0x442C, 0x45D9, 0x47B3, 0x49B2, 0x4816, 0x420F, 0x3752, 0x2A55, 0x1E35, 0x0F50,
    0xFFB7, 0xF44F, 0xEDE9, 0xEB3E, 0xE831, 0xE49E, 0xE07F, 0xDFF4, 0xE341, 0xE897, 0xEB34, 0xEAC6, 0xEB24, 0xEAC8, 0xE826, 0xE2E1,
    0xE047, 0xE257, 0xE844, 0xF0F2, 0xFA67, 0x01CC, 0x04D1, 0x0511, 0x0571, 0x0718, 0x09EC, 0x0CA2, 0x0CE0, 0x08DE, 0xFE4C, 0xF0AF,
    0xE37D, 0xD597, 0xC79D, 0xBDA8, 0xB891, 0xB6A9, 0xB627, 0xB5A4, 0xB56A, 0xB634, 0xBAB0, 0xC19D, 0xC7E1, 0xCC5B, 0xD1E9, 0xD730,
    0xDAC6, 0xDBA8, 0xDC9C, 0xE0ED, 0xE8BD, 0xF57E, 0x02C2, 0x0EB2, 0x16FB, 0x1CB5, 0x21BA, 0x2744, 0x2DCE, 0x3487, 0x39B1, 0x3A21,
    0x3455, 0x2B83, 0x22C8, 0x18D8, 0x0D20, 0x0335, 0xFDA8, 0xFB2C, 0xF9E1, 0xF725, 0xF352, 0xEEC3, 0xEF15, 0xF497, 0xFA63, 0xFEDF,
    0x02E9, 0x075C, 0x099A, 0x08B2, 0x070A, 0x081C, 0x0CFF, 0x1624, 0x2206, 0x2D8A, 0x3553, 0x38F1, 0x3AEE, 0x3C7D, 0x3E9C, 0x4077,
    0x428F, 0x4241, 0x3BFF, 0x3227, 0x2617, 0x17DA, 0x0611, 0xF4C5, 0xE806, 0xDFBF, 0xDBF9, 0xD942, 0xD53D, 0xD1EE, 0xD280, 0xD7FA,
    0xDF69, 0xE446, 0xE8C3, 0xED73, 0xEFA7, 0xF017, 0xEE13, 0xEDB7, 0xEFAB, 0xF448, 0xFC36, 0x04A6, 0x0C2B, 0x107C, 0x1330, 0x1652,
    0x19E4, 0x1D64, 0x2270, 0x2643, 0x23E8, 0x1BDD, 0x11E5, 0x0673, 0xF7A4, 0xE930, 0xDEC5, 0xD908, 0xD6D1, 0xD58E, 0xD2BB, 0xCE8E,
    0xCC35, 0xCE8C, 0xD33C, 0xD725, 0xDA26, 0xDE33, 0xE229, 0xE444, 0xE49E, 0xE4FD, 0xE7DD, 0xED87, 0xF70C, 0x032B, 0x0CF3, 0x13F9,
    0x193F, 0x1D9D, 0x2288, 0x2723, 0x2DEC, 0x3426, 0x3488, 0x3034, 0x28BC, 0x1F8D, 0x1374, 0x0413, 0xF6D9, 0xEE7A, 0xEAD6, 0xE9A9,
    0xE7D0, 0xE50A, 0xE39E, 0xE862, 0xF164, 0xF9A0, 0x0155, 0x099E, 0x1107, 0x14AA, 0x1459, 0x1358, 0x1316, 0x15B9, 0x1C0F, 0x259F,
    0x2EDF, 0x3523, 0x37C1, 0x3A0B, 0x3CA4, 0x3EEB, 0x432D, 0x47BB, 0x495F, 0x44DB, 0x3DC7, 0x35A4, 0x294C, 0x1930, 0x08B4, 0xFAA9,
    0xF0E1, 0xEB37, 0xE600, 0xDF24, 0xD775, 0xD396, 0xD43C, 0xD5D4, 0xD701, 0xD90B, 0xDB0C, 0xDA01, 0xD70A, 0xD317, 0xD09E, 0xD10D,
    0xD4E2, 0xDCEA, 0xE68B, 0xEF48, 0xF614, 0xFC7B, 0x03E7, 0x0B23, 0x1269, 0x1C0E, 0x22AE, 0x23A5, 0x1FBE, 0x198E, 0x10C5, 0x03FD,
    0xF68C, 0xEC2B, 0xE713, 0xE68E, 0xE6E9, 0xE455, 0xE0A9, 0xDED5, 0xE211, 0xE6AD, 0xEB41, 0xF1B0, 0xF976, 0xFF36, 0x0106, 0xFF53,
    0xFD50, 0xFCBD, 0xFDA8, 0x0324, 0x0C15, 0x13E4, 0x196F, 0x1D1C, 0x1FBB, 0x226F, 0x24B1, 0x2945, 0x2C65, 0x2A7C, 0x2503, 0x1D95,
    0x1306, 0x04E4, 0xF4D8, 0xE57F, 0xDA7D, 0xD418, 0xD0CE, 0xCD43, 0xC87C, 0xC62F, 0xC81C, 0xCC50, 0xD05C, 0xD422, 0xD9B7, 0xDE2B,
    0xE076, 0xE079, 0xDF2B, 0xDEEB, 0xE0A1, 0xE754, 0xF288, 0xFDE6, 0x0742, 0x0E05, 0x1467, 0x1A1D, 0x1FCE, 0x284E, 0x3080, 0x33CB,
    0x320B, 0x2CAF, 0x24A4, 0x1972, 0x0BBF, 0xFE0E, 0xF38F, 0xEED8, 0xEE9B, 0xEFF9, 0xEE67, 0xED65, 0xF166, 0xF823, 0xFF9A, 0x076D,
    0x112B, 0x1B11, 0x213E, 0x236B, 0x23D4, 0x2330, 0x2406, 0x284D, 0x30B5, 0x3A4B, 0x40EC, 0x44EE, 0x46CE, 0x47AC, 0x4898, 0x4BAF,
    0x4F5B, 0x500A, 0x4CC2, 0x4618, 0x3CBA, 0x3040, 0x20A0, 0x1083, 0x0235, 0xF7E8, 0xF354, 0xEFE2, 0xE9E2, 0xE349, 0xDFF6, 0xDFEE,
    0xE311, 0xE5D5, 0xEAB0, 0xF12B, 0xF490, 0xF503, 0xF2A8, 0xEF8C, 0xECF1, 0xED5B, 0xF2D9, 0xFC15, 0x03F8, 0x0A67, 0x0ECF, 0x11EA,
    0x13F1, 0x16A0, 0x1BA2, 0x1F25, 0x1DEF, 0x1913, 0x1145, 0x05C7, 0xF6EC, 0xE661, 0xD7AD, 0xCCBF, 0xC78E, 0xC503, 0xC141, 0xBD3F,
    0xBC07, 0xBEB5, 0xC3FB, 0xC8DD, 0xCF6D, 0xD6F6, 0xDD14, 0xE0E9, 0xE1FA, 0xE1DA, 0xE1AC, 0xE2FD, 0xE82C, 0xF142, 0xFB58, 0x03B3,
    0x0A57, 0x0EEF, 0x1271, 0x1752, 0x1EEB, 0x262C, 0x2A27, 0x2A8B, 0x273A, 0x2103, 0x1734, 0x0BCE, 0x003E, 0xF78B, 0xF37B, 0xF387,
    0xF25E, 0xEE09, 0xEA55, 0xEA2F, 0xED5A, 0xF188, 0xF5AA, 0xFC3A, 0x0364, 0x084D, 0x0B64, 0x0CA0, 0x0D56, 0x0EC2, 0x135A, 0x1C00,
    0x265E, 0x2F35, 0x36BC, 0x3B6E, 0x3EF4, 0x426F, 0x478C, 0x4BD0, 0x4C4B, 0x48EF, 0x425F, 0x3917, 0x2C1F, 0x1CE6, 0x0C2F, 0xFC10,
    0xF039, 0xE877, 0xE150, 0xD936, 0xD230, 0xCF78, 0xD09D, 0xD469, 0xD955, 0xE10D, 0xE856, 0xEDD3, 0xF0F9, 0xF0FE, 0xEFFC, 0xEFDD,
    0xF326, 0xFAA2, 0x03A7, 0x0B65, 0x119D, 0x1623, 0x1925, 0x1BAC, 0x2090, 0x26D6, 0x2B0F, 0x2BFA, 0x29DB, 0x252C, 0x1E0A, 0x127A,
    0x0444, 0xF646, 0xEAE3, 0xE521, 0xE17D, 0xDB81, 0xD417, 0xCED1, 0xCDC0, 0xCEB5, 0xD095, 0xD40F, 0xD8AB, 0xDC01, 0xDD63, 0xDCBD,
    0xDB17, 0xD9FB, 0xDBC5, 0xE18D, 0xEAD5, 0xF51E, 0xFF72, 0x08F4, 0x0ED0, 0x14F4, 0x1CAE, 0x25D6, 0x2D94, 0x31B5, 0x32C8, 0x314A,
    0x2B8E, 0x2232, 0x162A, 0x0893, 0xFCFE, 0xF6A7, 0xF48A, 0xF1D3, 0xECDE, 0xE905, 0xE8F9, 0xEC41, 0xF154, 0xF7F3, 0x0067, 0x0854,
    0x0F8F, 0x12F3, 0x13D3, 0x12C9, 0x11C6, 0x13FE, 0x19BB, 0x20B9, 0x27C2, 0x2E8C, 0x331C, 0x35E5, 0x38DF, 0x3E3F, 0x4375, 0x4623,
    0x45F6, 0x43B5, 0x3F05, 0x387E, 0x2E7E, 0x214B, 0x1328, 0x0816, 0x00A5, 0xF994, 0xF03D, 0xE807, 0xE3FE, 0xE237, 0xE273, 0xE3E8,
    0xE705, 0xEA74, 0xEBC9, 0xEA7F, 0xE650, 0xE050, 0xDB42, 0xDA09, 0xDCD4, 0xE279, 0xE965, 0xF118, 0xF6BA, 0xF9C6, 0xFEE9, 0x06D4,
    0x0F81, 0x1644, 0x1984, 0x199C, 0x1739, 0x1198, 0x0839, 0xFBFE, 0xEF30, 0xE55E, 0xE16F, 0xDF5A, 0xDC88, 0xD98F, 0xD7CB, 0xD950,
    0xDCE8, 0xE166, 0xE777, 0xEFD3, 0xF769, 0xFCDE, 0xFF2C, 0xFE63, 0xFC18, 0xFB9D, 0xFEEC, 0x0419, 0x09E7, 0x1117, 0x16CC, 0x19CD,
    0x1BE0, 0x20FF, 0x281A, 0x2D2C, 0x2F3E, 0x2ED4, 0x2B82, 0x2561, 0x1BAC, 0x0DD5, 0xFE23, 0xEFD8, 0xE72C, 0xE023, 0xD85B, 0xD070,
    0xCA3B, 0xC6E1, 0xC631, 0xC7A9, 0xCC15, 0xD16A, 0xD6D1, 0xDB43, 0xDCCD, 0xDBEC, 0xD8AB, 0xD672, 0xD90D, 0xDEF6, 0xE702, 0xF194,
    0xFBB0, 0x03CF, 0x09A1, 0x1013, 0x196E, 0x2272, 0x2928, 0x2DD5, 0x2EAF, 0x2DB9, 0x28B8, 0x1F6F, 0x13A7, 0x074C, 0x001E, 0xFC67,
    0xF8BC, 0xF51F, 0xF2EA, 0xF418, 0xF816, 0xFDBA, 0x063F, 0x0F49, 0x1923, 0x2164, 0x2694, 0x28AB, 0x266B, 0x2351, 0x22AA, 0x251E,
    0x2A6F, 0x319F, 0x38B0, 0x3CEC, 0x3D68, 0x3E65, 0x4151, 0x44CF, 0x477A, 0x483F, 0x4686, 0x41E9, 0x3AB7, 0x2F77, 0x20C0, 0x1193,
    0x04F9, 0xFCD0, 0xF55F, 0xEDE6, 0xE724, 0xE1E1, 0xDF9F, 0xDEC7, 0xDF9D, 0xE306, 0xE6E8, 0xEA95, 0xEE2A, 0xEEE8, 0xEC36, 0xE80F,
    0xE60B, 0xE856, 0xEC8C, 0xF35E, 0xFB71, 0x0237, 0x062E, 0x0996, 0x0F40, 0x1657, 0x1C33, 0x1F3D, 0x1F0E, 0x1AEF, 0x14DA, 0x0AB6,
    0xFC2B, 0xEC42, 0xDEDA, 0xD67E, 0xD0A3, 0xCA5F, 0xC4A7, 0xC0B9, 0xBF33, 0xC064, 0xC3B6, 0xC9C1, 0xD0C5, 0xD789, 0xDCF0, 0xDF8A,
    0xDF36, 0xDCD9, 0xDC29, 0xDF7D, 0xE44F, 0xEBEF, 0xF5C4, 0xFDDF, 0x03A0, 0x07FC, 0x0D0F, 0x1494, 0x1C7C, 0x2330, 0x27F6, 0x2A44,
    0x2B32, 0x2823, 0x1F82, 0x139A, 0x080E, 0x0181, 0xFE34, 0xF9B9, 0xF50B, 0xF072, 0xED84, 0xEC7A, 0xECC0, 0xF042, 0xF4DD, 0xF842,
    0xFB9D, 0xFD51, 0xFD30, 0xFA1A, 0xF776, 0xF905, 0xFDD6, 0x05E5, 0x1049, 0x1B1B, 0x23D4, 0x29FF, 0x3076, 0x3825, 0x3F91, 0x466B,
    0x498A, 0x4955, 0x473F, 0x41E3, 0x378B, 0x27E8, 0x1702, 0x097C, 0xFFED, 0xF738, 0xED8A, 0xE56F, 0xDEA5, 0xDA2E, 0xD811, 0xD82E,
    0xDBA0, 0xE025, 0xE547, 0xE993, 0xEB42, 0xE9FF, 0xE6E2, 0xE628, 0xE85F, 0xEC9D, 0xF417, 0xFD10, 0x040D, 0x080E, 0x0B8F, 0x10BE,
    0x170B, 0x1CF1, 0x224C, 0x24E1, 0x24F8, 0x2336, 0x1D31, 0x1296, 0x050E, 0xF8EC, 0xF0A3, 0xE9E6, 0xE2AC, 0xDCFC, 0xD86B, 0xD59B,
    0xD4B0, 0xD597, 0xD972, 0xDDAA, 0xE20A, 0xE63E, 0xE71F, 0xE401, 0xDFAC, 0xDD40, 0xDE74, 0xE39C, 0xEC89, 0xF7C9, 0x0189, 0x0967,
    0x0F9C, 0x16B3, 0x1FC6, 0x27D4, 0x2E9D, 0x326B, 0x32E5, 0x31B7, 0x2D40, 0x2292, 0x1443, 0x064F, 0xFCC3, 0xF5C4, 0xEF44, 0xE9E3,
    0xE5C1, 0xE39D, 0xE33D, 0xE502, 0xEAC2, 0xF282, 0xFA9B, 0x0292, 0x094D, 0x0C23, 0x0BBF, 0x0B5B, 0x0CD4, 0x1104, 0x1738, 0x1EF3,
    0x255D, 0x298A, 0x2BA3, 0x2E5E, 0x331C, 0x39C4, 0x3FA2, 0x431E, 0x43AA, 0x423D, 0x3DC4, 0x3554, 0x282A, 0x191F, 0x0E19, 0x05C2,
    0xFE01, 0xF632, 0xEE93, 0xE7D4, 0xE2DE, 0xE064, 0xE0B4, 0xE2F4, 0xE690, 0xEA8C, 0xEDC4, 0xECD4, 0xE8B8, 0xE42A, 0xE11C, 0xE05F,
    0xE31B, 0xE959, 0xF079, 0xF624, 0xF9DF, 0xFCA0, 0x003D, 0x06B3, 0x0D4E, 0x1335, 0x16EB, 0x18BD, 0x18EF, 0x13D7, 0x09E0, 0xFDC4,
    0xF3C5, 0xED2C, 0xE7D3, 0xE34C, 0xDF91, 0xDD93, 0xDE49, 0xDFF5, 0xE397, 0xE946, 0xEFAA, 0xF78F, 0xFF00, 0x0406, 0x0587, 0x0398,
    0x01D3, 0x023E, 0x0552, 0x0A94, 0x1083, 0x1568, 0x1762, 0x1848, 0x193F, 0x1C2E, 0x20EC, 0x2575, 0x27D7, 0x2744, 0x2614, 0x211A,
    0x161B, 0x0784, 0xF8FE, 0xED8F, 0xE442, 0xDB18, 0xD315, 0xCC54, 0xC7CA, 0xC56B, 0xC42E, 0xC509, 0xC6D2, 0xCA94, 0xCF97, 0xD2AC,
    0xD381, 0xD28D, 0xD1FC, 0xD2EA, 0xD586, 0xDC43, 0xE57F, 0xEE4A, 0xF549, 0xFBC1, 0x01F0, 0x0927, 0x11E5, 0x1999, 0x1F6D, 0x230D,
    0x2573, 0x2493, 0x1E23, 0x1357, 0x07BB, 0xFEA8, 0xF820, 0xF329, 0xEF16, 0xEB57, 0xE97F, 0xE9E3, 0xECAF, 0xF2AA, 0xFA6F, 0x042F,
    0x0EDC, 0x17C7, 0x1D3F, 0x1F08, 0x1F7D, 0x1EE6, 0x1FF4, 0x244C, 0x2B37, 0x3337, 0x3935, 0x3E03, 0x41E3, 0x44ED, 0x48F9, 0x4C58,
    0x4E3C, 0x4EF2, 0x4E58, 0x4C6F, 0x4503, 0x382A, 0x2932, 0x1C32, 0x12CF, 0x09B5, 0xFF24, 0xF4FB, 0xEC3A, 0xE703, 0xE46D, 0xE2E2,
    0xE30E, 0xE3DD, 0xE6B9, 0xE91F, 0xE991, 0xE83C, 0xE52E, 0xE313, 0xE225, 0xE3B7, 0xE9BE, 0xF0F1, 0xF77C, 0xFCED, 0x018A, 0x06A4,
    0x0CBB, 0x13C9, 0x19D5, 0x1D61, 0x1F92, 0x1F38, 0x19B6, 0x0D3A, 0xFCD1, 0xEDC0, 0xE1C7, 0xD892, 0xD043, 0xC9AB, 0xC442, 0xC09A,
    0xBEE1, 0xBEB9, 0xC021, 0xC32B, 0xC858, 0xCEF1, 0xD442, 0xD789, 0xD970, 0xD92D, 0xD93B, 0xDB18, 0xE02B, 0xE7B1, 0xEE6E, 0xF52A,
    0xFA6F, 0xFFE4, 0x0751, 0x0EAA, 0x161C, 0x1BB0, 0x1FFB, 0x2469, 0x2563, 0x2120, 0x182F, 0x0CF9, 0x0362, 0xFB90, 0xF4F4, 0xEF7B,
    0xEBA5, 0xE994, 0xE8DA, 0xE9F2, 0xEC45, 0xEFA0, 0xF56A, 0xFB00, 0xFF31, 0x009E, 0xFF3D, 0xFD7D, 0xFC4C, 0xFD1B, 0x028B, 0x0BDF,
    0x153E, 0x1E11, 0x259A, 0x2CB6, 0x3387, 0x3B5C, 0x4296, 0x474F, 0x4AAD, 0x4C9F, 0x4B97, 0x451E, 0x3973, 0x2B2D, 0x1C55, 0x0F56,
    0x043C, 0xF9BE, 0xF0D9, 0xE830, 0xE156, 0xDC67, 0xD918, 0xD7FF, 0xD9B4, 0xDDE4, 0xE26E, 0xE408, 0xE40D, 0xE30B, 0xE104, 0xE0E8,
    0xE30E, 0xE8DC, 0xEF82, 0xF596, 0xFA90, 0xFE3C, 0x033A, 0x09F3, 0x115E, 0x1844, 0x1D40, 0x2189, 0x23D2, 0x2090, 0x1797, 0x0A92,
    0xFE79, 0xF46A, 0xEBE1, 0xE532, 0xDF84, 0xDABE, 0xD6FC, 0xD45D, 0xD44E, 0xD46E, 0xD68D, 0xDBE4, 0xE12D, 0xE4F7, 0xE5F9, 0xE50A,
    0xE237, 0xE037, 0xE134, 0xE686, 0xEE66, 0xF6E0, 0xFE6B, 0x044A, 0x0A25, 0x1166, 0x1A27, 0x21EE, 0x2843, 0x2CF9, 0x317C, 0x31AD,
    0x2C44, 0x22C5, 0x17CD, 0x0E42, 0x05B8, 0xFDEA, 0xF756, 0xF119, 0xEBFA, 0xE97E, 0xE91D, 0xEA36, 0xEDA9, 0xF513, 0xFDD1, 0x05EA,
    0x0AD1, 0x0D80, 0x0D76, 0x0C46, 0x0CD1, 0x108B, 0x16E2, 0x1D7E, 0x2277, 0x24B7, 0x2649, 0x2938, 0x2E13, 0x32D8, 0x3704, 0x3A22,
    0x3CD6, 0x3C49, 0x36A5, 0x2C60, 0x1FF7, 0x13ED, 0x094F, 0x001D, 0xF814, 0xF098, 0xE94F, 0xE3C6, 0xDFDB, 0xDD30, 0xDB50, 0xDC70,
    0xDFD2, 0xE36F, 0xE524, 0xE532, 0xE31D, 0xDF63, 0xDC9B, 0xE0C9, 0xE7AC, 0xE971, 0xEB47, 0xED38, 0xF08B, 0xF3EF, 0xFA27, 0xFFA0,
    0x0657, 0x0B2E, 0x0F57, 0x1299, 0x0EF8, 0x0969, 0xFEE5, 0xF59A, 0xEC96, 0xE819, 0xE203, 0xDF9B, 0xD9AC, 0xD31B, 0xD4F4, 0xDAB4,
    0xE070, 0xE714, 0xEE17, 0xFA90, 0x15D4, 0x16B2, 0x1155, 0x1074, 0x0C74, 0x0C68, 0x0F71, 0x1152, 0x157D, 0x19FA, 0x1A01, 0x1E4D,
    0x1FF6, 0x2904, 0x2B36, 0x2E6A, 0x30C6, 0x353F, 0x337D, 0x2B4C, 0x246E, 0x030F, 0xF2E0, 0xECCD, 0xE474, 0xDFA5, 0xD69D, 0xD2C5,
    0xC9A0, 0xD64D, 0xE394, 0xE849, 0xEAFE, 0xE575, 0xE3A7, 0xE2DC, 0xE2EE, 0xDD9F, 0xD959, 0xD294, 0xD242, 0xD340, 0xDCBA, 0xE4B0,
    0xE821, 0xEE90, 0xF0BC, 0xFCBF, 0xFE10, 0x0794, 0x082B, 0xFD90, 0xFA82, 0xF27B, 0xF360, 0xEEEA, 0xED19, 0xEC75, 0xEB11, 0xEC63,
    0xEDC2, 0xF2E9, 0xF54C, 0xFB1C, 0x0357, 0x0A2E, 0x1154, 0x1733, 0x1B66, 0x2104, 0x263C, 0x296D, 0x2988, 0x2960, 0x2A5F, 0x2A08,
    0x2F08, 0x32F0, 0x34F2, 0x3600, 0x34EB, 0x362F, 0x34F5, 0x3545, 0x330D, 0x2F0C, 0x2C05, 0x27DA, 0x2478, 0x227E, 0x1FFF, 0x1BDC,
    0x179B, 0x113B, 0x0C11, 0x0722, 0x0417, 0x0346, 0x0224, 0x0309, 0x02A2, 0x0340, 0x0454, 0x03D0, 0x042C, 0x02F0, 0x00CD, 0xFE81,
    0xFE56, 0xFECA, 0x0029, 0x031E, 0x054D, 0x0747, 0x0908, 0x0A53, 0x0A0D, 0x09BD, 0x0804, 0x062D, 0x0327, 0xFF28, 0xFA55, 0xF636,
    0xF2D0, 0xEDB8, 0xE9B4, 0xE401, 0xDEF7, 0xDAFD, 0xD7B5, 0xD6CD, 0xD724, 0xD873, 0xD9EA, 0xDBDF, 0xDEA8, 0xE130, 0xE33E, 0xE578,
    0xE70D, 0xE8C6, 0xEA6F, 0xED13, 0xEF1A, 0xF109, 0xF367, 0xF509, 0xF5C3, 0xF719, 0xF677, 0xF4E0, 0xF50D, 0xF4FF, 0xF4EB, 0xF2AC,
    0xEE57, 0xEAB9, 0xEC2E, 0xED31, 0xEB7D, 0xEBB8, 0xEAC6, 0xE99A, 0xE9CD, 0xEA68, 0xEB6F, 0xEC90, 0xED1F, 0xED27, 0xECCD, 0xE71E,
    0xE9EB, 0xEFFE, 0xF014, 0xEDD2, 0xEB56, 0xEC6E, 0xEE72, 0xF4C2, 0xF75F, 0xF769, 0xF70C, 0xF914, 0xFA3F, 0xFE8C, 0x0120, 0x002E,
    0xFFDB, 0x00B9, 0x02FA, 0x03D5, 0x073F, 0x06E1, 0x09AA, 0x08E9, 0x07AE, 0x0702, 0x040A, 0x01D5, 0x0009, 0xFEAF, 0xFC20, 0xFBD8,
    0xFB32, 0xFD93, 0x00B2, 0x0197, 0x00D0, 0x006A, 0x006D, 0xFEFC, 0xFFEB, 0x00EF, 0x0299, 0x03DD, 0x00CA, 0x00DD, 0x0374, 0x02B3,
    0x030C, 0x0320, 0x0459, 0x0460, 0x008E, 0xFA84, 0xF7AB, 0xF5AE, 0xF686, 0xFBBB, 0xF8AB, 0xF696, 0xF25B, 0xF25C, 0xF582, 0xF630,
    0xF406, 0xF1D7, 0xEFCD, 0xEC07, 0xED3E, 0xF20D, 0xF7B4, 0xF39B, 0xEF43, 0xEEAF, 0xEFEF, 0xF060, 0xF143, 0xEC97, 0xE62A, 0xE292,
    0xDEAD, 0xDD64, 0xDC05, 0xDC29, 0xD7C1, 0xD65A, 0xD5D4, 0xD6A3, 0xD79E, 0xD6A3, 0xDB33, 0xDDCD, 0xE038, 0xE2E1, 0xE688, 0xEA69,
    0xED9F, 0xF0D4, 0xF3A6, 0xF7C7, 0xFB0D, 0xFF9F, 0x0419, 0x09AC, 0x0EB6, 0x1261, 0x1644, 0x1A8E, 0x1C38, 0x1FF4, 0x2665, 0x2C91,
    0x2F2C, 0x3089, 0x3474, 0x32C4, 0x2F7F, 0x2D70, 0x2C77, 0x2A4F, 0x2886, 0x2434, 0x22B8, 0x2002, 0x21A8, 0x2810, 0x2918, 0x2695,
    0x2066, 0x1F11, 0x1C87, 0x1C0A, 0x1936, 0x15F4, 0x124E, 0x0C85, 0x0928, 0x0A09, 0x0C8D, 0x0CCE, 0x0996, 0x031B, 0xFF47, 0xFC65,
    0xFCE0, 0xF780, 0xF15C, 0xEB25, 0xE224, 0xD92E, 0xD35A, 0xD03B, 0xC7BD, 0xC2F7, 0xC149, 0xC081, 0xBFC6, 0xBF6F, 0xC1BC, 0xC3BA,
    0xC58E, 0xC8F0, 0xCC13, 0xCE21, 0xD531, 0xDD68, 0xE2B8, 0xE761, 0xED28, 0xF363, 0xF849, 0xFD31, 0x01A2, 0x0506, 0x065D, 0x0955,
    0x0D16, 0x0EC0, 0x11C2, 0x17A5, 0x1B64, 0x1E92, 0x2107, 0x2212, 0x20DB, 0x1F63, 0x1FD2, 0x2110, 0x231C, 0x21B3, 0x2093, 0x1CFD,
    0x1B13, 0x1B52, 0x1DB0, 0x1CA9, 0x181E, 0x147B, 0x0EF9, 0x0CF1, 0x0AD2, 0x037B, 0xFCBC, 0xF2F3, 0xF105, 0xF363, 0xECF1, 0xEE28,
    0xEF91, 0xEB21, 0xE8A6, 0xE864, 0xE873, 0xE876, 0xE488, 0xE36F, 0xDD00, 0xDD70, 0xE01E, 0xDE8B, 0xDE83, 0xDB4E, 0xD8F7, 0xD428,
    0xD219, 0xCEB8, 0xD15A, 0xD4E2, 0xD467, 0xD82E, 0xE654, 0xF0AE, 0xF3F7, 0xF4C8, 0xF591, 0xF3F2, 0xF29D, 0xF283, 0xF228, 0xF4D5,
    0xF88E, 0xFBAD, 0x01D0, 0x12DA, 0x1BC7, 0x1FF1, 0x20DF, 0x2494, 0x297E, 0x298D, 0x2CE4, 0x2E56, 0x2FF5, 0x336F, 0x3170, 0x3B30,
    0x4751, 0x4943, 0x48B8, 0x43DA, 0x4159, 0x3CF1, 0x3FE7, 0x3FC3, 0x3FDE, 0x3C7E, 0x36CE, 0x322C, 0x3500, 0x393C, 0x365B, 0x334F,
    0x2A76, 0x18E9, 0xF9AC, 0xE8BA, 0xDA9E, 0xC80A, 0xC137, 0xC098, 0xBF6A, 0xC79E, 0xCE78, 0xD960, 0xE0FB, 0xE255, 0xE2C8, 0xDD63,
    0xDED4, 0xCC74, 0xBA34, 0xB614, 0xB6C7, 0xBD7D, 0xC5E0, 0xDAAD, 0xF3CC, 0x074B, 0x15D6, 0x207B, 0x1EC7, 0x15D7, 0x1519, 0x1681,
    0x1736, 0x0FE9, 0x0DE9, 0xFFE6, 0xE5BB, 0xD226, 0xC5AE, 0xBBCE, 0xB890, 0xBC46, 0xB76F, 0xB99D, 0xBE78, 0xCA1B, 0xCF22, 0xD894,
    0xE24C, 0xE8AE, 0xF59A, 0xF20A, 0xE54D, 0xDE34, 0xDDD4, 0xE097, 0xE2FD, 0xF082, 0x0A5D, 0x1FD9, 0x2EA4, 0x3901, 0x367D, 0x2BEC,
    0x2A7A, 0x2F6B, 0x371B, 0x34FB, 0x36D1, 0x2D96, 0x164E, 0x03D0, 0xFA16, 0xF1B5, 0xEDEF, 0xF07C, 0xEEB0, 0xF356, 0xF711, 0xFEFD,
    0x00B1, 0x04EE, 0x0857, 0x0B03, 0x18CB, 0x1AA2, 0x106A, 0x053E, 0xFFF3, 0xFF4A, 0xFD1F, 0x0498, 0x176D, 0x2945, 0x363F, 0x442E,
    0x4690, 0x4145, 0x3BBB, 0x3A51, 0x3AEA, 0x3245, 0x2C6E, 0x1DA1, 0x0270, 0xE491, 0xD131, 0xBF26, 0xBA90, 0xBDD6, 0xBEF7, 0xC0F4,
    0xC574, 0xD023, 0xD44A, 0xDE12, 0xE3B6, 0xEAE4, 0xF822, 0xFF9C, 0xFD48, 0xF6B0, 0xF59F, 0xF682, 0xF67B, 0xFA95, 0x097E, 0x1BB2,
    0x29E7, 0x3ABB, 0x3F19, 0x391C, 0x2F33, 0x2C60, 0x2ECF, 0x299E, 0x28BE, 0x211F, 0x0913, 0xEDAF, 0xDB09, 0xCA9D, 0xC435, 0xC05C,
    0xBD5E, 0xBB7B, 0xBDDC, 0xC4CE, 0xC9FC, 0xD36D, 0xD4F0, 0xD5B1, 0xDE93, 0xE671, 0xE492, 0xDAA3, 0xD64B, 0xD798, 0xD803, 0xDAE6,
    0xEBE9, 0xFE61, 0x0C71, 0x1F7A, 0x28F6, 0x2908, 0x214F, 0x2122, 0x23DF, 0x25A5, 0x27AF, 0x26A6, 0x19C3, 0x0439, 0xF150, 0xDD2C,
    0xD231, 0xCCC7, 0xCFFC, 0xCDF7, 0xD42E, 0xDEF7, 0xE52F, 0xF090, 0xF6BB, 0xFFFB, 0x0CB0, 0x162A, 0x1275, 0x03E5, 0xF6EE, 0xF1B1,
    0xEF6F, 0xEDD7, 0xFC41, 0x1046, 0x23CE, 0x3B7E, 0x4C6B, 0x5073, 0x46ED, 0x422A, 0x424D, 0x40CE, 0x4321, 0x46D9, 0x3C55, 0x274D,
    0x1056, 0xFB3E, 0xEF1F, 0xE9B7, 0xE78A, 0xE21C, 0xE1B8, 0xE467, 0xE849, 0xF272, 0xF6CF, 0xF447, 0xF40A, 0xF88A, 0xF99A, 0xED45,
    0xDEEC, 0xD854, 0xD125, 0xC975, 0xCED9, 0xD4B2, 0xDD29, 0xEB9F, 0xFA4B, 0x0222, 0xFEB9, 0xFC9E, 0xFE2D, 0x01AF, 0x0491, 0x0E1D,
    0x0E3A, 0x070C, 0xFAFD, 0xEB21, 0xDB9F, 0xD4E9, 0xD90E, 0xD715, 0xDD75, 0xE4F1, 0xEB5D, 0xF47F, 0xF8F4, 0xFC29, 0x0572, 0x14F5,
    0x1E7D, 0x1E09, 0x1A57, 0x1AD0, 0x19DA, 0x14A7, 0x174F, 0x1D74, 0x26D8, 0x3723, 0x4BE4, 0x597B, 0x5728, 0x5384, 0x5473, 0x4F6A,
    0x49AC, 0x4813, 0x3C94, 0x27E8, 0x0CB4, 0xF454, 0xE271, 0xDA04, 0xD7A2, 0xD3AE, 0xD39E, 0xD440, 0xD6D4, 0xDF9F, 0xE688, 0xE624,
    0xE6FE, 0xEF1E, 0xF815, 0xF773, 0xEE95, 0xEB88, 0xE745, 0xDF9C, 0xE21E, 0xE88A, 0xF10E, 0xFC57, 0x0D9D, 0x1BDC, 0x2085, 0x1F91,
    0x2156, 0x2086, 0x1E0B, 0x21BA, 0x2327, 0x1FAD, 0x1272, 0x02B1, 0xEC57, 0xDD06, 0xD8BD, 0xD381, 0xD3A3, 0xD759, 0xDDA9, 0xE69B,
    0xEF02, 0xF284, 0xFA72, 0x09DA, 0x1962, 0x21A8, 0x1FBB, 0x2056, 0x230C, 0x2358, 0x283B, 0x31A5, 0x3AF4, 0x462C, 0x55DD, 0x62E0,
    0x620E, 0x5A6A, 0x5769, 0x5202, 0x4E78, 0x51DB, 0x5532, 0x4FF4, 0x433F, 0x329D, 0x1F50, 0x1167, 0x0ABD, 0x0528, 0x042E, 0x05A1,
    0x0679, 0x0F1B, 0x1A39, 0x1F3E, 0x2117, 0x22C3, 0x269C, 0x25DD, 0x1917, 0x0EDF, 0x0383, 0xF558, 0xEE83, 0xEF6C, 0xF3EC, 0xFC3A,
    0x0A34, 0x1AFB, 0x2367, 0x2051, 0x1E18, 0x1891, 0x1486, 0x145C, 0x1742, 0x1560, 0x0BFD, 0x0223, 0xED48, 0xD8A2, 0xCAFF, 0xC0AD,
    0xBB19, 0xB822, 0xB894, 0xBD56, 0xC342, 0xC3CE, 0xC398, 0xC777, 0xD0DB, 0xD964, 0xD99E, 0xD8EA, 0xD795, 0xD2A7, 0xD0D4, 0xD3FA,
    0xD764, 0xDB0F, 0xE3F6, 0xF851, 0x067D, 0x0AA0, 0x0CBB, 0x0BAC, 0x0A47, 0x0BD4, 0x1366, 0x173C, 0x14C1, 0x0CCB, 0x00F0, 0xF982,
    0xF67D, 0xF53F, 0xF7E6, 0xFA9C, 0xFA6B, 0xFD43, 0x0545, 0x0BC6, 0x0EB0, 0x1019, 0x17B3, 0x215D, 0x228D, 0x20AA, 0x1D7F, 0x16CD,
    0x0F85, 0x0D42, 0x0F6A, 0x153F, 0x1F68, 0x3174, 0x41A2, 0x4B4D, 0x5203, 0x53BD, 0x5578, 0x5511, 0x56BC, 0x5344, 0x4956, 0x3F61,
    0x2A87, 0x11B0, 0xFDAE, 0xEE65, 0xE49F, 0xDFD4, 0xDD28, 0xDE1D, 0xE1C2, 0xE2D2, 0xE0AE, 0xDFF6, 0xE790, 0xF254, 0xF6C0, 0xF574,
    0xF4BA, 0xF0AD, 0xEC59, 0xEB6D, 0xEDA6, 0xEF53, 0xF303, 0x0364, 0x14C2, 0x1DCD, 0x2015, 0x1CDA, 0x158B, 0x0EDA, 0x0F90, 0x123D,
    0x1046, 0x08A2, 0xF716, 0xE586, 0xD9BA, 0xCF58, 0xCA0A, 0xC738, 0xC1B8, 0xC004, 0xC41B, 0xCA12, 0xCE14, 0xCE07, 0xD2FD, 0xDC44,
    0xE1B1, 0xE3B3, 0xE5F4, 0xE4EA, 0xE1CB, 0xE168, 0xE490, 0xEA1E, 0xF2C5, 0x03F7, 0x1635, 0x2329, 0x29EF, 0x2B48, 0x2BAF, 0x2A00,
    0x2DF4, 0x3364, 0x3570, 0x3708, 0x2F9D, 0x2036, 0x0E49, 0xFBD4, 0xED79, 0xE6DD, 0xE345, 0xE597, 0xEE57, 0xFA91, 0x0216, 0x03E5,
    0x0BD9, 0x1936, 0x2203, 0x239E, 0x2324, 0x1F3B, 0x185D, 0x11F7, 0x13A2, 0x1510, 0x14D5, 0x1F06, 0x3103, 0x400F, 0x46CF, 0x4958,
    0x474A, 0x4240, 0x4131, 0x41F8, 0x4319, 0x4222, 0x3772, 0x2825, 0x196D, 0x08DC, 0xFC6E, 0xF62D, 0xEEC1, 0xE7E2, 0xE3D4, 0xE576,
    0xE8B4, 0xE617, 0xE3DE, 0xE6E1, 0xEA06, 0xE867, 0xE412, 0xDD85, 0xD3CA, 0xC95A, 0xC3A4, 0xBF77, 0xBC75, 0xC011, 0xC78D, 0xD25A,
    0xD958, 0xDBE8, 0xDBC8, 0xD7B2, 0xD964, 0xDD16, 0xDF76, 0xE2DA, 0xE37A, 0xDDF1, 0xD654, 0xCD99, 0xC671, 0xC4F6, 0xC5FA, 0xC7CA,
    0xCC0C, 0xD3B8, 0xD959, 0xD8FE, 0xDA03, 0xE4E5, 0xF186, 0xFB46, 0x031F, 0x07CD, 0x051C, 0xFDFE, 0xFDFD, 0xFF28, 0xFD5C, 0x015D,
    0x0FE2, 0x2365, 0x3252, 0x3DC2, 0x42D9, 0x4191, 0x4167, 0x40D9, 0x412E, 0x4086, 0x3783, 0x279B, 0x15EC, 0x006D, 0xEF2B, 0xE757,
    0xE35B, 0xE022, 0xDE76, 0xE18B, 0xE646, 0xE651, 0xE3C2, 0xE67C, 0xEB91, 0xEE9E, 0xF0C5, 0xF177, 0xEDFB, 0xE5E3, 0xE05A, 0xDC31,
    0xD834, 0xDA2D, 0xE2DD, 0xF1C9, 0xFDC1, 0x067D, 0x0A1A, 0x06AC, 0x04A7, 0x040F, 0x042C, 0x0568, 0x057D, 0x00B0, 0xF815, 0xEAA5,
    0xDADE, 0xCE4B, 0xC65A, 0xC050, 0xBD52, 0xC0C2, 0xC68C, 0xC70E, 0xC4A1, 0xC849, 0xD167, 0xDC06, 0xE343, 0xE9BF, 0xED41, 0xEB12,
    0xEDF8, 0xF575, 0xFB3F, 0x0101, 0x0D5B, 0x2093, 0x30F4, 0x3CD1, 0x41F0, 0x40E4, 0x3F69, 0x3D89, 0x3D9E, 0x4244, 0x43B8, 0x3EF4,
    0x3754, 0x28D9, 0x1895, 0x0CE6, 0x0522, 0xFED5, 0xF949, 0xF988, 0x00DC, 0x08A3, 0x0C9E, 0x1114, 0x1800, 0x1BE7, 0x1AFE, 0x1894,
    0x121F, 0x0660, 0xFC66, 0xF335, 0xEB86, 0xE84B, 0xEC2E, 0xF877, 0x0539, 0x1259, 0x1C3F, 0x1EFD, 0x2054, 0x23A0, 0x2592, 0x27B7,
    0x2977, 0x27FD, 0x2261, 0x178B, 0x07BC, 0xF7DF, 0xEC0A, 0xE1B1, 0xD934, 0xD554, 0xD6F0, 0xD5A7, 0xCFED, 0xCBB2, 0xCD0C, 0xD16D,
    0xD458, 0xD836, 0xD840, 0xD1AC, 0xCBD7, 0xC916, 0xC83F, 0xC4DC, 0xC4D4, 0xCCC0, 0xD758, 0xE486, 0xEDB6, 0xEF97, 0xEFEB, 0xEE0E,
    0xEBE4, 0xF0C5, 0xF52D, 0xF5BB, 0xF557, 0xF099, 0xE79E, 0xE034, 0xDEA3, 0xE081, 0xE141, 0xE2F6, 0xE8B6, 0xEDC1, 0xEF14, 0xEFB6,
    0xF4A4, 0xFB27, 0xFF95, 0x055C, 0x0A66, 0x0998, 0x059B, 0xFF2C, 0xF986, 0xF3F3, 0xF300, 0xFB55, 0x0920, 0x1C71, 0x2FC0, 0x3C4A,
    0x4312, 0x4792, 0x4A31, 0x4CDB, 0x4EC1, 0x4E9F, 0x4A9B, 0x42A4, 0x350E, 0x22BF, 0x1121, 0x0332, 0xF689, 0xED3D, 0xEB8A, 0xECA8,
    0xEB0B, 0xE546, 0xE3DA, 0xE760, 0xEA03, 0xEE4C, 0xF327, 0xF3DD, 0xF0D1, 0xEE6D, 0xEF31, 0xEE6C, 0xED5E, 0xF17B, 0xFB43, 0x0984,
    0x16EB, 0x1D96, 0x20A8, 0x20B1, 0x1B77, 0x194A, 0x1A0E, 0x1871, 0x15F2, 0x1046, 0x03D8, 0xF290, 0xE385, 0xD958, 0xCEB1, 0xC6A7,
    0xC39C, 0xC37A, 0xC319, 0xC005, 0xC09F, 0xC490, 0xC651, 0xC919, 0xCB57, 0xCAC3, 0xC903, 0xC73C, 0xC67D, 0xC42A, 0xC415, 0xC993,
    0xD396, 0xE235, 0xF376, 0x00EB, 0x088C, 0x0E07, 0x122A, 0x1533, 0x1997, 0x1DB3, 0x214D, 0x2307, 0x1E49, 0x11F0, 0x01AB, 0xF481,
    0xE822, 0xDD68, 0xDB0B, 0xE143, 0xE95D, 0xEB3F, 0xEE52, 0xF645, 0xFDC6, 0x0687, 0x0EB8, 0x1304, 0x0FE7, 0x09B1, 0x073B, 0x0556,
    0x03ED, 0x05E8, 0x0CAB, 0x1915, 0x280D, 0x333C, 0x3B71, 0x408E, 0x3EC4, 0x3C5C, 0x3E99, 0x4002, 0x40B9, 0x41AC, 0x3DAE, 0x30B0,
    0x20CA, 0x15D6, 0x0CF0, 0x049B, 0x0008, 0xFF8F, 0x0017, 0xFB45, 0xF66A, 0xF726, 0xF63A, 0xF5AA, 0xF5B0, 0xF574, 0xF22F, 0xEB28,
    0xE3D1, 0xD961, 0xCE75, 0xC7F2, 0xC730, 0xCD37, 0xD79D, 0xE11D, 0xE69F, 0xE7F4, 0xE6D2, 0xE3C6, 0xE138, 0xDFA7, 0xDF1E, 0xE02C,
    0xE120, 0xDD9F, 0xD650, 0xCF45, 0xC8C2, 0xC27A, 0xBF5E, 0xC335, 0xCA4B, 0xCD0A, 0xCD1C, 0xD05A, 0xD5AC, 0xDBF7, 0xE520, 0xF0AE,
    0xF7B6, 0xFA06, 0xFA88, 0xF8EA, 0xF674, 0xF583, 0xF77D, 0xFFB8, 0x1016, 0x227B, 0x33F4, 0x4202, 0x486F, 0x4A79, 0x4C6B, 0x4D6A,
    0x4BA6, 0x4A03, 0x47FE, 0x3DB3, 0x2D0B, 0x1C94, 0x0DEE, 0x0012, 0xF495, 0xF00D, 0xF0D9, 0xEF7E, 0xED26, 0xEDE7, 0xEF4C, 0xEFF6,
    0xF177, 0xF4E8, 0xF530, 0xF251, 0xEE24, 0xE7B9, 0xE03B, 0xDB13, 0xDA96, 0xE005, 0xEBAD, 0xFA7A, 0x072E, 0x0F9C, 0x1496, 0x16BE,
    0x1772, 0x1823, 0x182C, 0x18A2, 0x1A48, 0x15C2, 0x09FB, 0xFB67, 0xECA7, 0xDEB4, 0xD127, 0xCB6A, 0xCD1D, 0xCD47, 0xCB7E, 0xCAA6,
    0xCCA0, 0xCECE, 0xD21B, 0xD860, 0xDD72, 0xDFF0, 0xE172, 0xE2B7, 0xE4C2, 0xE826, 0xEC77, 0xF546, 0x0652, 0x1942, 0x2968, 0x379E,
    0x3E9D, 0x3FCD, 0x403B, 0x40EC, 0x4103, 0x415F, 0x4542, 0x4511, 0x3A47, 0x2B0C, 0x1BDE, 0x0E36, 0x0031, 0xF719, 0xF6FE, 0xF844,
    0xFA27, 0xFE14, 0x030C, 0x07AB, 0x0C38, 0x114C, 0x138F, 0x1156, 0x0E47, 0x0853, 0xFE3E, 0xF499, 0xECF7, 0xEAE6, 0xF116, 0xFE56,
    0x0D80, 0x1904, 0x2037, 0x245F, 0x2500, 0x24FD, 0x2562, 0x268C, 0x2995, 0x2A2A, 0x2421, 0x191A, 0x0C47, 0xFED9, 0xEED6, 0xE1B6,
    0xDD11, 0xDBD6, 0xD970, 0xD516, 0xD15A, 0xCDFF, 0xCBCE, 0xCD79, 0xD1DF, 0xD4AF, 0xD687, 0xD602, 0xD2CE, 0xD0FF, 0xCE48, 0xCC71,
    0xD0AD, 0xD940, 0xE3C1, 0xEFFA, 0xFA27, 0xFF68, 0xFFC6, 0xFE9A, 0xFA67, 0xF51C, 0xF5EF, 0xFA81, 0xF986, 0xF0DE, 0xE7D5, 0xE138,
    0xD9B3, 0xD477, 0xD70F, 0xDBE9, 0xDDDB, 0xDF1B, 0xE2D3, 0xE7DD, 0xED79, 0xF509, 0xFC69, 0x0120, 0x04B2, 0x0620, 0x01FA, 0xFADF,
    0xF2E5, 0xED62, 0xEF3A, 0xF938, 0x09D9, 0x1C4B, 0x2D03, 0x3AB3, 0x4209, 0x46B2, 0x4A23, 0x4BE6, 0x4DF5, 0x4EF1, 0x4C57, 0x4343,
    0x3664, 0x29AD, 0x1A2A, 0x092F, 0xFDD1, 0xF91F, 0xF650, 0xF1F1, 0xEEC8, 0xECCA, 0xEAFB, 0xEC1F, 0xF02F, 0xF51D, 0xF87C, 0xF7ED,
    0xF47D, 0xF22F, 0xF0FC, 0xEFC8, 0xF31E, 0xFBFF, 0x06D2, 0x12F5, 0x1F1D, 0x26D4, 0x2871, 0x2758, 0x2516, 0x1F97, 0x1C05, 0x1E6B,
    0x1F87, 0x17DB, 0x09CF, 0xFC67, 0xEDE0, 0xDE12, 0xD48D, 0xD22C, 0xD202, 0xD1BA, 0xD1C4, 0xD243, 0xD21A, 0xD32B, 0xD52A, 0xD609,
    0xD796, 0xDA1D, 0xD9F8, 0xD742, 0xD41C, 0xD1DA, 0xD280, 0xD8F5, 0xE573, 0xF3F8, 0x01D8, 0x0D61, 0x15EB, 0x1C0C, 0x1F54, 0x2019,
    0x21A6, 0x2538, 0x29C2, 0x2870, 0x2028, 0x15B1, 0x07C1, 0xF5D0, 0xE65F, 0xDFC5, 0xDEAE, 0xE023, 0xE3F8, 0xE891, 0xEC66, 0xF0F5,
    0xF8AB, 0x0197, 0x0946, 0x0E4F, 0x0E2E, 0x0D47, 0x0B91, 0x0791, 0x0573, 0x0818, 0x0F55, 0x18D4, 0x2631, 0x32AC, 0x39E5, 0x3EC7,
    0x41AE, 0x3F52, 0x3A2D, 0x3970, 0x3EC3, 0x3F12, 0x37A7, 0x2FA8, 0x260E, 0x1833, 0x0948, 0x01E7, 0xFF46, 0xFD23, 0xFC2F, 0xFC00,
    0xFB0B, 0xF9B2, 0xFAB0, 0xFB32, 0xF9B4, 0xF910, 0xF740, 0xF251, 0xEA46, 0xDF63, 0xD5AC, 0xD021, 0xD0F9, 0xD634, 0xDDFC, 0xE726,
    0xED2A, 0xF14F, 0xF2B3, 0xF031, 0xEC6A, 0xEA0E, 0xEB32, 0xEAED, 0xE5A1, 0xDF93, 0xDA78, 0xD34C, 0xCAD9, 0xC632, 0xC697, 0xC8CD,
    0xCC47, 0xD029, 0xD397, 0xD76A, 0xDCA7, 0xE3E1, 0xED7E, 0xF880, 0xFF9D, 0x01E3, 0x010B, 0xFC82, 0xF779, 0xF66D, 0xFA3A, 0x0164,
    0x0D4C, 0x1CF2, 0x2A6D, 0x351F, 0x3DB5, 0x4187, 0x3FEA, 0x3CF5, 0x4068, 0x447E, 0x404F, 0x37DC, 0x2DFB, 0x1F24, 0x0AF9, 0xFB8E,
    0xF45A, 0xEFC3, 0xEE15, 0xED96, 0xED14, 0xECBF, 0xEDC1, 0xEF78, 0xF00E, 0xF10E, 0xF315, 0xF3B8, 0xF054, 0xEA80, 0xE30D, 0xDC15,
    0xDA9C, 0xDF06, 0xE826, 0xF49A, 0xFF04, 0x06C7, 0x0BB4, 0x0C4A, 0x0B2F, 0x0A61, 0x0D67, 0x1224, 0x114C, 0x0CE1, 0x06AE, 0xFC47,
    0xED82, 0xDE3C, 0xD4A7, 0xCF70, 0xCE62, 0xD065, 0xD159, 0xD10A, 0xD16A, 0xD27C, 0xD50B, 0xDABD, 0xE035, 0xE3EE, 0xE731, 0xEA30,
    0xEC65, 0xF03F, 0xF883, 0x01A7, 0x0CE6, 0x1D1D, 0x2C87, 0x38A3, 0x41DA, 0x4847, 0x49BB, 0x46C6, 0x476F, 0x4E65, 0x518F, 0x4CFC,
    0x455E, 0x3B21, 0x2B46, 0x1992, 0x0DB4, 0x058E, 0x0188, 0x0163, 0x02E9, 0x057A, 0x081A, 0x0B84, 0x0EF6, 0x121F, 0x14DC, 0x16A8,
    0x15A7, 0x117A, 0x09D6, 0xFEDA, 0xF58E, 0xF22D, 0xF558, 0xFE15, 0x0861, 0x1273, 0x1AF9, 0x2046, 0x2227, 0x2021, 0x1F46, 0x21C7,
    0x22F9, 0x211D, 0x1CA0, 0x1696, 0x0D04, 0xFFE8, 0xF421, 0xEAC5, 0xE517, 0xE2C1, 0xDF8A, 0xDACB, 0xD713, 0xD45E, 0xD338, 0xD629,
    0xDAEC, 0xDD8D, 0xDDDF, 0xDC11, 0xD840, 0xD417, 0xD2F2, 0xD443, 0xD7A5, 0xE01E, 0xEB31, 0xF513, 0xFCD0, 0x0297, 0x04B1, 0xFF64,
    0xF8BE, 0xF8A7, 0xFC29, 0xFBE4, 0xF811, 0xF479, 0xEC7B, 0xE0AB, 0xD9B1, 0xD776, 0xD8A8, 0xDDA8, 0xE2DC, 0xE63F, 0xE8EE, 0xED5C,
    0xF35C, 0xFAF0, 0x0380, 0x0BE4, 0x1288, 0x1512, 0x12DF, 0x0BD2, 0x02CE, 0xFCAA, 0xFBBD, 0x01E8, 0x0E77, 0x1D2B, 0x2BB0, 0x379E,
    0x3EB6, 0x4017, 0x3F70, 0x42CD, 0x473D, 0x47B6, 0x450F, 0x410E, 0x3961, 0x2C84, 0x1DD9, 0x0F6D, 0x03B4, 0xFD1F, 0xF912, 0xF562,
    0xF19E, 0xEE2F, 0xEA8B, 0xE9AA, 0xEC76, 0xEF9C, 0xF1D7, 0xF30B, 0xF155, 0xECE9, 0xEABB, 0xEB27, 0xED1A, 0xF258, 0xFC70, 0x0749,
    0x0F83, 0x1797, 0x1FC4, 0x226C, 0x1DD9, 0x1AE1, 0x1D79, 0x2000, 0x1DA9, 0x19A8, 0x12E5, 0x04CF, 0xF38E, 0xE550, 0xDC44, 0xD8E3,
    0xD87F, 0xD864, 0xD7D6, 0xD664, 0xD598, 0xD536, 0xD620, 0xD767, 0xD838, 0xD92A, 0xD942, 0xD762, 0xD3AA, 0xD053, 0xCFD7, 0xD3DF,
    0xDCED, 0xE945, 0xF735, 0x04FC, 0x10ED, 0x19BE, 0x1E69, 0x24AA, 0x2DEF, 0x3479, 0x3690, 0x35C3, 0x3207, 0x28FD, 0x1C60, 0x0DCE,
    0xFE92, 0xF4DE, 0xF161, 0xF0CB, 0xF246, 0xF3B5, 0xF3E5, 0xF4DC, 0xFA61, 0x02A5, 0x09BE, 0x0FDB, 0x115E, 0x0E41, 0x0AE4, 0x07E3,
    0x05B2, 0x05E1, 0x0BD1, 0x1666, 0x2032, 0x2900, 0x33AD, 0x3BEE, 0x3BC6, 0x37A7, 0x36C2, 0x397B, 0x3A53, 0x3943, 0x3779, 0x309D,
    0x2513, 0x17B9, 0x0C55, 0x04D5, 0x0037, 0xFD63, 0xF8FB, 0xF377, 0xF02E, 0xEE7A, 0xEEDF, 0xF156, 0xF397, 0xF63B, 0xF7A4, 0xF51A,
    0xEDBA, 0xE2A0, 0xD80F, 0xD21D, 0xD354, 0xDA9D, 0xE431, 0xEDE3, 0xF692, 0xFBE6, 0xFA43, 0xF68D, 0xF546, 0xF4AF, 0xF27D, 0xEF62,
    0xED59, 0xE95B, 0xE375, 0xDB6C, 0xD08E, 0xC8C2, 0xC6B2, 0xC7AB, 0xCA6F, 0xCD9A, 0xCFA3, 0xD156, 0xD663, 0xDF39, 0xE983, 0xF586,
    0x003E, 0x06FD, 0x0A67, 0x0C36, 0x0D18, 0x0C9F, 0x0F87, 0x180E, 0x23AA, 0x2F77, 0x3C9F, 0x4AFD, 0x5271, 0x5282, 0x51FC, 0x543B,
    0x56DA, 0x55EF, 0x5315, 0x4DE2, 0x4487, 0x361D, 0x2389, 0x138B, 0x0876, 0x0248, 0xFDB4, 0xF7B2, 0xF377, 0xF0A1, 0xEF4B, 0xEEF4,
    0xEDC2, 0xED4C, 0xED2C, 0xED4E, 0xEBBA, 0xE6AA, 0xDFC8, 0xD9E1, 0xD89C, 0xDB77, 0xE1CD, 0xEA41, 0xF3A3, 0xFD7C, 0x0237, 0x02CE,
    0x0417, 0x06D9, 0x094F, 0x09C6, 0x094C, 0x0590, 0xFF3A, 0xF750, 0xEB24, 0xDEEE, 0xD690, 0xD224, 0xD089, 0xCFB5, 0xCFC2, 0xCDF0,
    0xCC64, 0xCD80, 0xCF0C, 0xD237, 0xD708, 0xDAEA, 0xDD28, 0xE016, 0xE36E, 0xE56B, 0xE926, 0xF23D, 0xFFCE, 0x0D5B, 0x1AF8, 0x2B81,
    0x3A29, 0x418C, 0x4439, 0x4728, 0x4B7D, 0x4ED5, 0x5083, 0x4F82, 0x4B2B, 0x4288, 0x3450, 0x255C, 0x1A49, 0x14A2, 0x134A, 0x128A,
    0x11E3, 0x110F, 0x11BC, 0x1490, 0x1820, 0x1B85, 0x1DDE, 0x1F56, 0x1F7F, 0x1C23, 0x14D4, 0x0A72, 0x001B, 0xFA29, 0xFB29, 0x0115,
    0x09A0, 0x1435, 0x1C38, 0x1E77, 0x1DDF, 0x1CDD, 0x1B6F, 0x1971, 0x181E, 0x167E, 0x13E9, 0x10E2, 0x09C3, 0xFEDF, 0xF44D, 0xEC42,
    0xE61B, 0xE1DF, 0xDF68, 0xDA9F, 0xD497, 0xD0BA, 0xCEE9, 0xCF5C, 0xD21D, 0xD585, 0xD657, 0xD489, 0xD1F5, 0xCDE0, 0xC8E6, 0xC77C,
    0xCB88, 0xD2DC, 0xDB1B, 0xE5F7, 0xF387, 0xFCE9, 0xFD33, 0xF8E7, 0xF4B3, 0xF1C6, 0xF23A, 0xF3E8, 0xF5FF, 0xF620, 0xF047, 0xE600,
    0xDB89, 0xD652, 0xD613, 0xD78C, 0xD990, 0xDBF8, 0xDFF8, 0xE603, 0xEE19, 0xF61F, 0xFCD8, 0x0367, 0x0990, 0x0E4E, 0x0ED4, 0x0931,
    0x00D1, 0xFA21, 0xF88A, 0xFD89, 0x063A, 0x1369, 0x22DE, 0x2ED1, 0x372B, 0x3ED3, 0x45DF, 0x4AA6, 0x4E9F, 0x5016, 0x4FB5, 0x4F1B,
    0x4BE1, 0x43CC, 0x37F0, 0x2C90, 0x2416, 0x1E70, 0x1ADE, 0x1657, 0x0F82, 0x08B7, 0x02B7, 0xFD95, 0xFB47, 0xFBCF, 0xFC70, 0xFA9A,
    0xF802, 0xF43C, 0xEDEA, 0xE863, 0xE82F, 0xED76, 0xF280, 0xF824, 0x0296, 0x0D7E, 0x1371, 0x13DE, 0x1290, 0x1209, 0x12FE, 0x1520,
    0x16CD, 0x16B1, 0x11CA, 0x065C, 0xF6BC, 0xE930, 0xE267, 0xE028, 0xE012, 0xDF3B, 0xDC52, 0xD985, 0xD675, 0xD37A, 0xD126, 0xD033,
    0xD19D, 0xD3E6, 0xD5CE, 0xD4D8, 0xCFEC, 0xCA70, 0xC80E, 0xCB00, 0xD13B, 0xDAA7, 0xE810, 0xF577, 0x0052, 0x09BB, 0x12F3, 0x1B17,
    0x22D6, 0x2A7A, 0x2F40, 0x3286, 0x342D, 0x301A, 0x261F, 0x19DA, 0x0EB0, 0x05C2, 0x00D1, 0xFEB2, 0xFC01, 0xFA28, 0xF95A, 0xF985,
    0xFC1C, 0x0131, 0x080B, 0x0D4D, 0x1126, 0x13EE, 0x11D7, 0x0BDF, 0x0718, 0x096C, 0x1176, 0x1982, 0x230A, 0x2DEE, 0x3652, 0x3AFD,
    0x3B00, 0x3940, 0x37C0, 0x3852, 0x3B5A, 0x3E5B, 0x4013, 0x3CFA, 0x3391, 0x25ED, 0x1A6F, 0x12D2, 0x0D06, 0x0803, 0x0251, 0xFC9A,
    0xF79D, 0xF4A7, 0xF37D, 0xF2CB, 0xF2BB, 0xF2C9, 0xF2F0, 0xF0FC, 0xE97B, 0xDE24, 0xD322, 0xCD46, 0xCCF8, 0xD074, 0xD91B, 0xE35B,
    0xEAC7, 0xEF56, 0xF1C8, 0xF17C, 0xEFDB, 0xEEC7, 0xED5C, 0xEB6B, 0xEB11, 0xEAD1, 0xE70D, 0xE0F1, 0xD8B8, 0xD0B6, 0xCB12, 0xC837,
    0xC62F, 0xC527, 0xC722, 0xCAAD, 0xCFA0, 0xD6C9, 0xE0E9, 0xEAA6, 0xF295, 0xF8DA, 0xFC79, 0xFB55, 0xF7D0, 0xF93B, 0xFFCC, 0x0688,
    0x0EB7, 0x1AED, 0x297F, 0x36B6, 0x3FC2, 0x454B, 0x4956, 0x4DE2, 0x527E, 0x571F, 0x595A, 0x5852, 0x50B3, 0x4215, 0x32A4, 0x2698,
    0x1FB4, 0x1BCE, 0x168F, 0x0FA4, 0x0939, 0x045B, 0x0180, 0xFE3A, 0xFA53, 0xF7A5, 0xF809, 0xFA23, 0xF9D7, 0xF4E9, 0xEBA5, 0xE3F3,
    0xE039, 0xDF19, 0xE308, 0xEB4E, 0xF436, 0xFB30, 0x004A, 0x02FE, 0x03AA, 0x05A0, 0x06A8, 0x05CC, 0x0537, 0x0474, 0x016F, 0xFA0E,
    0xEFFF, 0xE4B9, 0xDAE6, 0xD574, 0xD199, 0xCE66, 0xCBB3, 0xC984, 0xC769, 0xC559, 0xC618, 0xC84F, 0xCA78, 0xCE07, 0xD23F, 0xD495,
    0xD387, 0xD38F, 0xD82C, 0xDE1E, 0xE57A, 0xF07C, 0x0013, 0x1213, 0x22F8, 0x3049, 0x38D0, 0x3F4F, 0x45D6, 0x4C71, 0x525E, 0x5671,
    0x56C7, 0x5022, 0x43F9, 0x363D, 0x2AB1, 0x23B3, 0x1E18, 0x1905, 0x1510, 0x12F8, 0x1389, 0x1563, 0x1729, 0x18ED, 0x1BCB, 0x1F96,
    0x22A0, 0x2162, 0x199D, 0x0F12, 0x0741, 0x01B3, 0x0023, 0x04F4, 0x0CD1, 0x15B9, 0x1DC0, 0x2342, 0x258F, 0x25E7, 0x25A0, 0x2462,
    0x24A3, 0x2735, 0x293F, 0x27DD, 0x21DB, 0x184E, 0x0CC9, 0x0294, 0xFA66, 0xF2AB, 0xECE4, 0xE8EC, 0xE547, 0xE0EC, 0xDE7C, 0xDED5,
    0xDEFF, 0xDE71, 0xDE31, 0xDD96, 0xD87C, 0xD0EF, 0xCCC8, 0xCCF3, 0xCF64, 0xD3FB, 0xDB8C, 0xE5FE, 0xF03F, 0xF786, 0xFAB6, 0xF970,
    0xF6C8, 0xF42A, 0xF403, 0xF6E2, 0xF9F0, 0xF94B, 0xF249, 0xE6F8, 0xDB64, 0xD35B, 0xCFA0, 0xCDCC, 0xCC0A, 0xCB25, 0xCC10, 0xD035,
    0xD5D2, 0xDBA9, 0xE2F8, 0xECA6, 0xF751, 0xFF45, 0x0045, 0xFBD4, 0xF6CC, 0xF217, 0xF020, 0xF465, 0xFE54, 0x0A67, 0x170F, 0x235A,
    0x2C84, 0x3379, 0x3A31, 0x4007, 0x447F, 0x48CE, 0x4CE0, 0x4DED, 0x4ACB, 0x436D, 0x3904, 0x2ED6, 0x2739, 0x2091, 0x1B24, 0x174E,
    0x12E5, 0x0C0E, 0x037D, 0xFCCB, 0xF828, 0xF5EF, 0xF7BF, 0xFD1A, 0xFFE6, 0xFC83, 0xF88D, 0xF74B, 0xF8B1, 0xFB23, 0xFEF5, 0x0566,
    0x0E9A, 0x192B, 0x20D7, 0x2445, 0x24BB, 0x240D, 0x2400, 0x251E, 0x26F8, 0x27C4, 0x235F, 0x184E, 0x094A, 0xFB56, 0xF214, 0xEBA8,
    0xE60F, 0xE007, 0xDA27, 0xD597, 0xD203, 0xCEBD, 0xCB18, 0xC8DE, 0xC9FF, 0xCDF6, 0xCF9B, 0xCCCB, 0xC8AC, 0xC3C8, 0xBF95, 0xBF3B,
    0xC3F9, 0xCC41, 0xD652, 0xE26A, 0xEDDC, 0xF733, 0x00F3, 0x0A92, 0x1309, 0x1B0A, 0x2257, 0x2815, 0x2A59, 0x2878, 0x2156, 0x1652,
    0x0BA1, 0x0166, 0xF8B6, 0xF32F, 0xF1F0, 0xF15D, 0xF02E, 0xF0B7, 0xF351, 0xF820, 0xFDA7, 0x050D, 0x0C54, 0x0DEC, 0x0AE0, 0x0806,
    0x07DB, 0x0AB6, 0x0F65, 0x1710, 0x2195, 0x2CE9, 0x36D5, 0x3BD0, 0x3CF1, 0x3BC8, 0x3A09, 0x3A77, 0x3D1B, 0x4173, 0x436A, 0x3F07,
    0x3558, 0x29BE, 0x1FA8, 0x1774, 0x1129, 0x0BC2, 0x06C3, 0x02FD, 0x014B, 0x006D, 0xFF28, 0xFE1B, 0xFE79, 0x01D1, 0x0434, 0x01E7,
    0xFC33, 0xF455, 0xEABC, 0xE3C0, 0xE321, 0xE73F, 0xEDB1, 0xF564, 0xFC8D, 0xFFF2, 0x00EC, 0x009C, 0xFE80, 0xFB01, 0xF788, 0xF592,
    0xF3C5, 0xF040, 0xE963, 0xDEBD, 0xD359, 0xC9E4, 0xC1DF, 0xBC60, 0xBA20, 0xB9AA, 0xB8DE, 0xB89F, 0xBBD0, 0xC0E8, 0xC729, 0xD0DA,
    0xDDAC, 0xE89B, 0xEDE4, 0xEF00, 0xEF62, 0xF060, 0xF26F, 0xF73B, 0xFFA4, 0x0C54, 0x1B70, 0x2927, 0x335D, 0x3A62, 0x3F74, 0x43C5,
    0x4949, 0x4F7F, 0x54A6, 0x55C7, 0x5034, 0x4572, 0x38CF, 0x2D5C, 0x244F, 0x1D7B, 0x1715, 0x1062, 0x0B00, 0x0676, 0x0207, 0xFCE9,
    0xF82F, 0xF75A, 0xFA48, 0xFC6C, 0xFBEA, 0xF926, 0xF409, 0xED1B, 0xE7C3, 0xE62D, 0xE6AE, 0xEB35, 0xF318, 0xFAD9, 0x00E1, 0x0607,
    0x0A29, 0x0D1F, 0x0FAF, 0x10F2, 0x1102, 0x1017, 0x0C96, 0x05CF, 0xFC8B, 0xF30D, 0xEB37, 0xE410, 0xDE87, 0xDB35, 0xD785, 0xD263,
    0xCDFA, 0xCB6A, 0xC9E1, 0xCAB9, 0xCFC2, 0xD64F, 0xD9DB, 0xD8C0, 0xD58B, 0xD3E3, 0xD465, 0xD686, 0xDB39, 0xE330, 0xEE99, 0xFC17,
    0x093C, 0x14EC, 0x1F81, 0x27E3, 0x2EE9, 0x3792, 0x4107, 0x48CF, 0x4B54, 0x46DA, 0x3D60, 0x31CE, 0x2731, 0x1EEE, 0x1849, 0x1235,
    0x0CD6, 0x09F5, 0x0944, 0x0A3B, 0x0B59, 0x0DFC, 0x13D9, 0x1977, 0x1B8B, 0x1B0C, 0x17E0, 0x1101, 0x09BC, 0x05B9, 0x0594, 0x0857,
    0x0E8B, 0x15A7, 0x1B00, 0x1E69, 0x202F, 0x2143, 0x219E, 0x21F9, 0x2236, 0x23F2, 0x25E9, 0x2432, 0x1F1B, 0x17B2, 0x0EF2, 0x04E5,
    0xFB21, 0xF52A, 0xF230, 0xEE87, 0xE9AE, 0xE59C, 0xE247, 0xDFF7, 0xE0DD, 0xE473, 0xE6DD, 0xE5F0, 0xE1BD, 0xDC9D, 0xD94F, 0xD824,
    0xD996, 0xDE28, 0xE61E, 0xEFA6, 0xF823, 0xFE87, 0x0220, 0x0268, 0x0087, 0xFF1A, 0xFFEF, 0x03B1, 0x0707, 0x05ED, 0xFEF2, 0xF373,
    0xE6DA, 0xDBE9, 0xD338, 0xCC74, 0xC77E, 0xC407, 0xC3B3, 0xC5D5, 0xC802, 0xCA74, 0xD062, 0xD997, 0xE2EC, 0xEB05, 0xF029, 0xF028,
    0xEB9E, 0xE69F, 0xE321, 0xE297, 0xE6C7, 0xEFE5, 0xFBB0, 0x0827, 0x15D6, 0x22F8, 0x2D91, 0x3559, 0x39AF, 0x3C6B, 0x3FA9, 0x417E,
    0x4067, 0x3CCE, 0x3773, 0x3098, 0x2854, 0x21B1, 0x1D9E, 0x19C2, 0x1478, 0x0E73, 0x08A2, 0x02AE, 0xFDFB, 0xFD2C, 0xFFE2, 0x0265,
    0x02C0, 0xFFAC, 0xFB90, 0xF85C, 0xF60C, 0xF5A2, 0xF859, 0xFF3D, 0x090F, 0x12B9, 0x1AB7, 0x204F, 0x236E, 0x256F, 0x25F3, 0x2771,
    0x29DD, 0x2999, 0x2578, 0x1C8D, 0x1067, 0x0504, 0xFCA7, 0xF737, 0xF327, 0xEE4A, 0xE94E, 0xE62A, 0xE287, 0xDC7A, 0xD86B, 0xD88D,
    0xDA6D, 0xDD49, 0xE033, 0xDFFF, 0xDB02, 0xD403, 0xCD68, 0xC8A7, 0xC798, 0xCB2D, 0xD24C, 0xDAFB, 0xE3EB, 0xED56, 0xF665, 0xFEAD,
    0x05F5, 0x0C4B, 0x1424, 0x1C33, 0x2165, 0x2153, 0x1D16, 0x15C8, 0x0A40, 0xFDB2, 0xF40D, 0xEE30, 0xEA4F, 0xE796, 0xE688, 0xE6F0,
    0xE78B, 0xE9FE, 0xF042, 0xF896, 0xFF98, 0x02A0, 0x0205, 0xFF9E, 0xFDA8, 0xFD88, 0x009C, 0x08C4, 0x139B, 0x1EEA, 0x2814, 0x2E99,
    0x320A, 0x329D, 0x3251, 0x3307, 0x37B9, 0x3E3C, 0x4215, 0x40D5, 0x39BA, 0x2E5B, 0x2374, 0x1B63, 0x164D, 0x127E, 0x0ED5, 0x0CA3,
    0x09CF, 0x0435, 0xFCCB, 0xF9CB, 0xFBC9, 0xFDCC, 0x0058, 0x0249, 0x0016, 0xFA2A, 0xF1FB, 0xE93F, 0xE3A4, 0xE36A, 0xE79C, 0xEDBE,
    0xF3BE, 0xF8DC, 0xFCD0, 0xFF97, 0x0068, 0xFF76, 0xFECA, 0x0065, 0x01DB, 0x0092, 0xFB7D, 0xF3F2, 0xE9EF, 0xDC56, 0xD0B0, 0xC8A7,
    0xC388, 0xC064, 0xBE56, 0xBDBD, 0xBDE8, 0xC020, 0xC620, 0xCF84, 0xDA68, 0xE34F, 0xE796, 0xE884, 0xE735, 0xE5BA, 0xE564, 0xE793,
    0xEDFB, 0xF7C7, 0x03E5, 0x1085, 0x1D33, 0x27D7, 0x2F85, 0x359D, 0x3C5F, 0x44EB, 0x4C05, 0x4ED4, 0x4BFA, 0x4460, 0x3AFD, 0x3322,
    0x2D9F, 0x2885, 0x218D, 0x19CF, 0x120C, 0x09DF, 0x019A, 0xFB19, 0xF8BA, 0xF8E6, 0xFABA, 0xFDF8, 0xFEC8, 0xFAC0, 0xF30C, 0xE9C9,
    0xE206, 0xDEBA, 0xE025, 0xE4D8, 0xEBCB, 0xF2DE, 0xF974, 0xFFFE, 0x05A7, 0x08D7, 0x095A, 0x0A25, 0x0C30, 0x0DBE, 0x0CD4, 0x09D3,
    0x0474, 0xFC44, 0xF309, 0xEC81, 0xE8BE, 0xE45D, 0xDF22, 0xD9F2, 0xD489, 0xCF6E, 0xCBEB, 0xCC0D, 0xD075, 0xD618, 0xD9CB, 0xDAB9,
    0xD924, 0xD682, 0xD473, 0xD4A5, 0xD7FF, 0xDED5, 0xE847, 0xF29A, 0xFE93, 0x0AD5, 0x159C, 0x1F08, 0x2834, 0x3275, 0x3E7F, 0x48CF,
    0x4DF2, 0x4D04, 0x46B0, 0x3DF6, 0x3534, 0x2D8A, 0x250B, 0x1C6C, 0x1618, 0x1173, 0x0D0C, 0x0968, 0x089E, 0x0A1A, 0x0CA2, 0x1015,
    0x13C0, 0x13B1, 0x0FB3, 0x092F, 0x01F7, 0xFDDA, 0xFCE2, 0xFFBF, 0x04F9, 0x0ADA, 0x1063, 0x1515, 0x1A18, 0x1D30, 0x1D1B, 0x1CC7,
    0x1E98, 0x2167, 0x2353, 0x2298, 0x1FEF, 0x1A4A, 0x1127, 0x0711, 0xFED4, 0xF922, 0xF4DE, 0xF239, 0xF081, 0xEDEF, 0xEA40, 0xE6E6,
    0xE5E0, 0xE6CA, 0xE7A2, 0xE643, 0xE32E, 0xDF2C, 0xDA4C, 0xD716, 0xD791, 0xDBE9, 0xE335, 0xEAAE, 0xF12F, 0xF835, 0xFEFC, 0x0341,
    0x045A, 0x0422, 0x059C, 0x0961, 0x0C9D, 0x0BF5, 0x068A, 0xFD46, 0xF2CA, 0xE9E2, 0xE1A0, 0xD888, 0xD115, 0xCC92, 0xC921, 0xC6A6,
    0xC69C, 0xCA1B, 0xD02A, 0xD858, 0xE1E3, 0xEA45, 0xEED3, 0xEE96, 0xEA9B, 0xE54C, 0xE17B, 0xE159, 0xE573, 0xECC5, 0xF5B4, 0xFFE3,
    0x0B9E, 0x178D, 0x21A0, 0x27CA, 0x2CE9, 0x3327, 0x380B, 0x3A8D, 0x3B1F, 0x3978, 0x3557, 0x2E9E, 0x27CA, 0x224D, 0x1CB3, 0x1776,
    0x1233, 0x0C78, 0x051A, 0xFD48, 0xF7C8, 0xF75E, 0xFB69, 0xFFFB, 0x019C, 0xFFA9, 0xFA7A, 0xF337, 0xED93, 0xEB55, 0xEE2F, 0xF533,
    0xFE11, 0x089A, 0x13CF, 0x1C44, 0x2068, 0x212A, 0x215E, 0x234C, 0x2719, 0x2AD5, 0x2AF5, 0x260A, 0x1C68, 0x1279, 0x0ABC, 0x01A6,
    0xF81C, 0xF071, 0xEA0D, 0xE450, 0xDFA2, 0xDCA9, 0xD9E2, 0xD81F, 0xD981, 0xDCDE, 0xDFBE, 0xDFCF, 0xDBA8, 0xD57E, 0xCEA3, 0xC92C,
    0xC775, 0xC900, 0xCD50, 0xD242, 0xD917, 0xE246, 0xECC2, 0xF5E1, 0xFDE1, 0x07FD, 0x1319, 0x1D13, 0x2461, 0x28A1, 0x281E, 0x21E3,
    0x188C, 0x0EB2, 0x05AF, 0xFE6C, 0xF99A, 0xF71B, 0xF542, 0xF21D, 0xEFA7, 0xF01E, 0xF3EF, 0xF9E0, 0xFE4E, 0xFFFC, 0xFE7A, 0xFB27,
    0xF7B7, 0xF67A, 0xF8FA, 0xFF6D, 0x085A, 0x1153, 0x1ACC, 0x23C1, 0x2941, 0x2ACB, 0x2A4C, 0x2BA1, 0x3001, 0x3622, 0x3B5A, 0x3BD7,
    0x3688, 0x2E4A, 0x263D, 0x1DFA, 0x14E0, 0x0C33, 0x068C, 0x0281, 0xFED9, 0xFBE2, 0xF8D1, 0xF676, 0xF5DE, 0xF6F1, 0xF852, 0xF879,
    0xF60F, 0xF0F4, 0xEA52, 0xE4A3, 0xE170, 0xE1C5, 0xE569, 0xE8D0, 0xEC73, 0xF1D0, 0xF805, 0xFD28, 0xFE71, 0xFEEC, 0x01FE, 0x0606,
    0x0861, 0x084B, 0x04EA, 0xFE28, 0xF409, 0xE907, 0xDE27, 0xD4CB, 0xCDDA, 0xC79C, 0xC33E, 0xBF73, 0xBBB8, 0xBAA9, 0xBDE5, 0xC587,
    0xCF39, 0xD801, 0xDDCE, 0xDF01, 0xDD37, 0xDA13, 0xD95A, 0xDDBC, 0xE56A, 0xEF69, 0xFB41, 0x0874, 0x15D6, 0x2085, 0x27D7, 0x2E1C,
    0x35BB, 0x3F66, 0x49D5, 0x51A9, 0x53A4, 0x50AC, 0x4BC3, 0x460E, 0x3E6E, 0x35BE, 0x2DFF, 0x26E4, 0x1F40, 0x1702, 0x0E9F, 0x06C8,
    0x0076, 0xFD92, 0xFDCA, 0xFF2D, 0xFED6, 0xFA62, 0xF260, 0xE8D7, 0xDFE2, 0xD9FB, 0xD961, 0xDCA9, 0xE15E, 0xE86B, 0xF199, 0xFA37,
    0xFF59, 0x00FA, 0x0245, 0x040E, 0x0569, 0x067D, 0x0764, 0x0694, 0x02BE, 0xFD15, 0xF674, 0xEF4B, 0xE909, 0xE361, 0xDECF, 0xDB11,
    0xD63F, 0xD092, 0xCC5F, 0xCC0A, 0xCF60, 0xD41A, 0xD702, 0xD67E, 0xD2E8, 0xCE08, 0xCA61, 0xCA42, 0xCD7E, 0xD269, 0xD7EE, 0xDF7A,
    0xE921, 0xF44E, 0xFE93, 0x0791, 0x120B, 0x1E79, 0x2C64, 0x3A55, 0x42CC, 0x43CA, 0x4069, 0x3AAA, 0x3394, 0x2B83, 0x2469, 0x1FBF,
    0x1C1C, 0x1931, 0x168E, 0x1403, 0x11DB, 0x10A9, 0x1200, 0x1559, 0x18B7, 0x1A21, 0x18C3, 0x1438, 0x0EA6, 0x09A6, 0x082D, 0x0AEF,
    0x0ED0, 0x12EF, 0x179E, 0x1D75, 0x21AD, 0x22F0, 0x2360, 0x244D, 0x25EA, 0x2716, 0x2710, 0x258D, 0x20C4, 0x195C, 0x106A, 0x06A9,
    0xFE4A, 0xF828, 0xF481, 0xF2AD, 0xF00B, 0xEB60, 0xE598, 0xE1FE, 0xE1EF, 0xE3B9, 0xE5AE, 0xE54F, 0xE28B, 0xDD93, 0xD78B, 0xD3AF,
    0xD428, 0xD89F, 0xDE8F, 0xE4E1, 0xEC64, 0xF438, 0xFA63, 0xFDE6, 0xFFCC, 0x01D4, 0x0643, 0x0D29, 0x1372, 0x13C7, 0x0D7C, 0x04FD,
    0xFBA3, 0xF005, 0xE35F, 0xD895, 0xD042, 0xCA2B, 0xC581, 0xC227, 0xBFED, 0xBF7C, 0xC277, 0xC991, 0xD332, 0xDCAB, 0xE36A, 0xE5E7,
    0xE3E4, 0xDED7, 0xDA13, 0xD908, 0xDBF4, 0xE0E1, 0xE821, 0xF3B5, 0x01B3, 0x0DB8, 0x169B, 0x1E79, 0x264C, 0x2DC7, 0x3485, 0x3A01,
    0x3E36, 0x3F96, 0x3E1E, 0x3A75, 0x3568, 0x2F51, 0x294E, 0x243E, 0x2030, 0x1B51, 0x1441, 0x0D7B, 0x0996, 0x094D, 0x0B0C, 0x0C88,
    0x0C20, 0x095C, 0x0384, 0xFC67, 0xF755, 0xF675, 0xF909, 0xFD51, 0x03EC, 0x0CAC, 0x15C4, 0x1D94, 0x22DD, 0x25EC, 0x272A, 0x28D9,
    0x2C1D, 0x2D65, 0x2A76, 0x2505, 0x1EC1, 0x1735, 0x0D4D, 0x0301, 0xF9C8, 0xF0C6, 0xE8B6, 0xE14F, 0xDA9E, 0xD4E5, 0xD0CA, 0xCF54,
    0xD0B5, 0xD430, 0xD6B3, 0xD702, 0xD4D4, 0xD091, 0xCB45, 0xC76F, 0xC62E, 0xC6CF, 0xC8DB, 0xCD43, 0xD50D, 0xDD45, 0xE4A2, 0xEBCB,
    0xF431, 0xFDD1, 0x079F, 0x1076, 0x17B9, 0x1BF3, 0x1C36, 0x1879, 0x11D3, 0x0A12, 0x0240, 0xFBD5, 0xF85E, 0xF6B5, 0xF424, 0xEFC9,
    0xEB3C, 0xE98B, 0xEBF7, 0xF0A8, 0xF578, 0xFA01, 0xFC6E, 0xFCF9, 0xFCF7, 0xFEFA, 0x0424, 0x0ADA, 0x1210, 0x1AF9, 0x25B2, 0x2F71,
    0x37BF, 0x3DA1, 0x411F, 0x4384, 0x47A1, 0x4C52, 0x4DC9, 0x4ACC, 0x44CF, 0x3CCA, 0x32C0, 0x2776, 0x1CC3, 0x1426, 0x0D55, 0x07F9,
    0x032A, 0xFDED, 0xF835, 0xF386, 0xF12A, 0xF180, 0xF314, 0xF417, 0xF3EB, 0xF20C, 0xECD6, 0xE649, 0xE21D, 0xE14B, 0xE2AB, 0xE5B4,
    0xEBF1, 0xF446, 0xFB77, 0xFF99, 0x01C4, 0x0344, 0x0480, 0x062D, 0x082B, 0x0909, 0x07D5, 0x0260, 0xF8D9, 0xEC72, 0xDDF7, 0xD0AC,
    0xC739, 0xC224, 0xBE23, 0xB9A1, 0xB5E9, 0xB460, 0xB6D4, 0xBC31, 0xC34C, 0xCAF1, 0xD117, 0xD453, 0xD415, 0xD26A, 0xD288, 0xD4FE,
    0xD997, 0xE1D5, 0xED62, 0xFAF9, 0x0986, 0x1708, 0x2185, 0x2866, 0x2FD2, 0x392B, 0x41CF, 0x4760, 0x4996, 0x49E4, 0x4838, 0x4258,
    0x3A77, 0x3333, 0x2C71, 0x268F, 0x209A, 0x1B13, 0x147D, 0x0F41, 0x0BCA, 0x0BDD, 0x0D90, 0x0D2A, 0x0CAB, 0x09FF, 0x03CE, 0xFA1A,
    0xF151, 0xEC52, 0xEB41, 0xECA7, 0xF10F, 0xF8C0, 0x00D4, 0x085C, 0x0E52, 0x11BE, 0x13C7, 0x1448, 0x142E, 0x1449, 0x13A4, 0x1105,
    0x0BB3, 0x033F, 0xF9AE, 0xF063, 0xE883, 0xE35E, 0xDF00, 0xD9D5, 0xD335, 0xCC4E, 0xC75E, 0xC663, 0xC7C4, 0xCCC4, 0xD2A9, 0xD6CB,
    0xD734, 0xD173, 0xCBBB, 0xC7F5, 0xC730, 0xC815, 0xCBF2, 0xD2A5, 0xDAD9, 0xE4FE, 0xEE96, 0xF89D, 0x028F, 0x0F5B, 0x1F2B, 0x2CED,
    0x371C, 0x3CB5, 0x3D6A, 0x39D2, 0x329E, 0x29E4, 0x2314, 0x1D8E, 0x18FA, 0x152A, 0x1123, 0x0CA8, 0x0876, 0x064F, 0x0767, 0x0AEC,
    0x0ED7, 0x135B, 0x152E, 0x1377, 0x0F86, 0x0CC3, 0x0D69, 0x0D03, 0x0D4B, 0x0FF6, 0x15AD, 0x1CDE, 0x2324, 0x2848, 0x2C14, 0x3029,
    0x334B, 0x3636, 0x3722, 0x34CF, 0x30C1, 0x2A9F, 0x22FC, 0x1A6B, 0x11C0, 0x0B5E, 0x08D3, 0x06DA, 0x03EF, 0xFDF5, 0xF6E1, 0xF15C,
    0xEE3F, 0xEDB8, 0xEF06, 0xF0BD, 0xF009, 0xEAE7, 0xE2E6, 0xDD29, 0xD9A2, 0xDA42, 0xDD73, 0xE32C, 0xEBC1, 0xF46A, 0xFCF3, 0x021F,
    0x04EE, 0x070C, 0x0B40, 0x104D, 0x1358, 0x14C0, 0x12B6, 0x0E71, 0x0670, 0xFA23, 0xEC9F, 0xDF4D, 0xD4BC, 0xCBCE, 0xC42E, 0xBE3D,
    0xB9E5, 0xB8DE, 0xBB66, 0xC048, 0xC5F2, 0xCAE4, 0xCFE6, 0xD1FD, 0xD017, 0xCC8D, 0xC9D6, 0xCAA9, 0xCC19, 0xD12C, 0xD8D5, 0xE306,
    0xEEE5, 0xF90E, 0x044B, 0x0F3D, 0x17E6, 0x1EC8, 0x24DC, 0x2A3E, 0x2E97, 0x313B, 0x3288, 0x31A7, 0x2E5A, 0x2AC8, 0x28A2, 0x26DD,
    0x23FA, 0x1EEB, 0x18A1, 0x13BD, 0x1144, 0x111E, 0x130C, 0x1609, 0x1795, 0x153F, 0x0EC0, 0x05FD, 0xFF1E, 0xFBAB, 0xFD21, 0x02EC,
    0x0A74, 0x14E7, 0x1F4B, 0x28E3, 0x2EA8, 0x310E, 0x33FF, 0x36D6, 0x3A93, 0x3DA0, 0x3DE4, 0x3A99, 0x3415, 0x2AD8, 0x1FFA, 0x146D,
    0x09F6, 0x00C9, 0xF7A7, 0xEF4A, 0xE7A0, 0xE05C, 0xD9E1, 0xD643, 0xD604, 0xD885, 0xDCDC, 0xE02C, 0xDFCE, 0xDB09, 0xD3F9, 0xCDF7,
    0xC979, 0xC5E2, 0xC54A, 0xC73B, 0xCBE1, 0xD22A, 0xD860, 0xDFF6, 0xE6DC, 0xEE16, 0xF53E, 0xFC9D, 0x042B, 0x0857, 0x09D1, 0x08D1,
    0x05AF, 0xFFF4, 0xF94D, 0xF504, 0xF29C, 0xF09E, 0xECDA, 0xE903, 0xE6A6, 0xE5B7, 0xE769, 0xEBF1, 0xF1B3, 0xF6A3, 0xF8C9, 0xF8A3,
    0xF86B, 0xF886, 0xFABF, 0xFFEB, 0x074B, 0x1018, 0x1B68, 0x282C, 0x336C, 0x3AAD, 0x4038, 0x4538, 0x490E, 0x4BD5, 0x4B4C, 0x4924,
    0x4485, 0x3CFC, 0x34CB, 0x2A96, 0x20B6, 0x18FE, 0x141D, 0x1150, 0x0D92, 0x0926, 0x0311, 0xFF4A, 0xFDC8, 0xFD62, 0xFFEC, 0x02C7,
    0x04A8, 0x03B5, 0xFF5E, 0xFB41, 0xF7C7, 0xF5F4, 0xF6F5, 0xF9A2, 0xFF31, 0x05E4, 0x0CAF, 0x1258, 0x15F1, 0x1711, 0x16D5, 0x1638,
    0x15A0, 0x1410, 0x0FDE, 0x0AD6, 0x02FA, 0xF810, 0xEAB9, 0xDC9D, 0xD0D1, 0xC7CA, 0xBF87, 0xB7ED, 0xB34B, 0xB2B6, 0xB42F, 0xB7CF,
    0xBD79, 0xC479, 0xCA4D, 0xCB65, 0xC9F8, 0xC728, 0xC56F, 0xC7E2, 0xCDEE, 0xD687, 0xDF57, 0xEA08, 0xF6F9, 0x02C0, 0x0CE3, 0x1581,
    0x1E5D, 0x2837, 0x3207, 0x3AD6, 0x41A6, 0x44E5, 0x44AD, 0x415F, 0x3B31, 0x347B, 0x2DD2, 0x2820, 0x23C7, 0x1E61, 0x188C, 0x133F,
    0x0FE9, 0x0D2F, 0x0D4E, 0x0FDA, 0x12E2, 0x126F, 0x0C65, 0x03B1, 0xFB4F, 0xF3E7, 0xEF4C, 0xEEAF, 0xF13B, 0xF850, 0xFFC8, 0x08D8,
    0x0E07, 0x1150, 0x11E1, 0x137B, 0x143D, 0x1711, 0x179D, 0x18D8, 0x11B7, 0x0C6E, 0x136E, 0x0270, 0xFABC, 0xEA6C, 0xF5F3, 0xE905,
    0xD741, 0xDCF8, 0xCDA5, 0xD663, 0xC52C, 0xD446, 0xDD1C, 0xDC12, 0xDEA2, 0xDBE0, 0xCFE5, 0xD886, 0xD234, 0xC644, 0xD507, 0xC642,
    0xDB44, 0xD677, 0xDB3B, 0xF3D3, 0xF636, 0xFEEA, 0x18CD, 0x150E, 0x0A0A, 0x2683, 0x1DA2, 0x2809, 0x31CA, 0xF9F6, 0x2226, 0x1767,
    0x01DA, 0x1D31, 0xF47E, 0x15F3, 0xFE33, 0xF7E1, 0x067B, 0xEDCB, 0x0F16, 0xFBE6, 0xF398, 0x2288, 0x1FC6, 0xE8F0, 0x0261, 0x105D,
    0x0348, 0x0F4C, 0xF889, 0x2A51, 0x20FA, 0x283D, 0x2D52, 0x2D90, 0x3299, 0x171F, 0x3B05, 0x4860, 0x33ED, 0x19AF, 0x29A6, 0x186F,
    0x2E36, 0x1B3E, 0x1A19, 0x1ECD, 0xDD09, 0xAF81, 0xA75E, 0xC746, 0xCA9F, 0xBE74, 0xC8B8, 0xED11, 0xFBF7, 0x3093, 0x380C, 0x30B3,
    0xEEC5, 0x9A39, 0x9163, 0x8000, 0xA4D3, 0xBEEF, 0xDBBD, 0x20D3, 0x58B1, 0x77A2, 0x7C95, 0x6598, 0x33B9, 0x1994, 0x320C, 0x619E,
    0x6F3D, 0x7CAD, 0x77DE, 0x63B0, 0x6439, 0x63E2, 0x6C6E, 0x5D5E, 0x48DA, 0x1A39, 0xF29A, 0x00E3, 0x08DC, 0x1702, 0xF726, 0xBCE3,
    0xA4E0, 0x9917, 0x9048, 0x8BE3, 0x9FB5, 0x8F69, 0x937D, 0x8E0A, 0x9A5C, 0xA53E, 0xA918, 0xCC46, 0xC5F1, 0xBD77, 0xCBEA, 0xFA11,
    0xF778, 0x1341, 0x0284, 0x1B7B, 0x078B, 0xCDF7, 0xF98F, 0x0805, 0x4C5D, 0x42B8, 0x2D74, 0x45DC, 0x37E5, 0x0C7D, 0xFBC9, 0xCB2A,
    0xAA3D, 0xBFF6, 0xCA24, 0xCE19, 0xEAC9, 0x09CF, 0xEA27, 0xEB8B, 0xE839, 0xC759, 0xBD5F, 0xD245, 0xDB48, 0xE3AA, 0x040C, 0x0AEA,
    0x085A, 0x17CA, 0x21A3, 0x3869, 0x4340, 0x5384, 0x5113, 0x5F97, 0x5AF5, 0x6621, 0x6FC3, 0x592D, 0x600B, 0x45E2, 0x422F, 0x1A5B,
    0x0BBA, 0xE546, 0xE194, 0xF4E6, 0xE069, 0xCA91, 0xBA7E, 0xDF9F, 0xD9E6, 0xDC00, 0xD1FB, 0xCE02, 0xCB2D, 0xE4E8, 0x140C, 0xED92,
    0x0DBB, 0x0D75, 0x0C8A, 0x3CAA, 0x3F04, 0x2D0D, 0x29A6, 0x3877, 0x28A6, 0x31BE, 0x0B94, 0xEE68, 0xF167, 0xF8C4, 0xFF51, 0x0744,
    0xF528, 0x0725, 0x12FD, 0xF0DF, 0xF2AA, 0xE9A0, 0xD141, 0xE9C4, 0xDA8D, 0xE504, 0x0F13, 0x1259, 0x0F02, 0x0763, 0x1A13, 0x0B56,
    0x126C, 0xF0F1, 0x1210, 0x09D3, 0x250C, 0x39CC, 0x302D, 0x34B0, 0x1FD1, 0x21FD, 0x1DAF, 0x3030, 0x30EF, 0x21A4, 0xF62E, 0x0730,
    0xD663, 0xDEDB, 0xD6AD, 0xB05B, 0xB317, 0xBB9D, 0xC8E7, 0xC8E7, 0xD524, 0xE00F, 0xCF0F, 0xCA86, 0xC610, 0xBE83, 0xD920, 0xEFA9,
    0x1477, 0x1C2D, 0x37F0, 0x4C6C, 0x621E, 0x40B1, 0x4A49, 0x4159, 0x1BF6, 0xFA38, 0xD99C, 0xE088, 0xEC6C, 0xE30E, 0xCF93, 0xD4EC,
    0xCE03, 0xC286, 0xA83C, 0xCC8E, 0xACA7, 0xC39F, 0xC607, 0x9020, 0xD061, 0xD736, 0xC19A, 0xCD85, 0xCA2F, 0xB16A, 0xB7C6, 0xC992,
    0xAE7C, 0xC740, 0xCF08, 0xCE30, 0xF97F, 0x0810, 0x0225, 0x2A3E, 0x234C, 0x015B, 0x1EBB, 0x13F8, 0x0E84, 0x03E4, 0x25C0, 0x0C59,
    0x026B, 0x2D3B, 0x2E4B, 0x4BA1, 0x5EB3, 0x403E, 0x58E6, 0x47CA, 0x21BA, 0x1595, 0xF306, 0x0888, 0xFBDB, 0xFA1B, 0x1D76, 0x260A,
    0xFEEA, 0x2153, 0x0D43, 0x16A9, 0x14B5, 0x0781, 0x227F, 0x0693, 0x17A9, 0x3EA2, 0x3716, 0x0CF3, 0x2B08, 0x2786, 0x1E8B, 0x008C,
    0x08B9, 0x1F8D, 0x0A1C, 0x35E2, 0x371A, 0x24E3, 0x4720, 0x3E16, 0x3777, 0x1F68, 0x2511, 0x2CCF, 0x0EA5, 0x1598, 0xEF63, 0xF156,
    0xF11E, 0xD490, 0xEB95, 0xDF5A, 0xD68E, 0xD66B, 0xC7E9, 0xCDB2, 0xAA8A, 0xBA5E, 0xDC67, 0xD086, 0xEB52, 0x1914, 0x2FC0, 0x4E50,
    0x50E4, 0x5484, 0x5BF1, 0x580A, 0x5062, 0x40C4, 0x0B0E, 0x0B9A, 0x2244, 0xEAC3, 0xF218, 0xFA4B, 0xF2E5, 0xD33F, 0xE741, 0xE1F5,
    0xE1CE, 0xF0C2, 0xEE73, 0xFB5B, 0xB1C0, 0xCA47, 0xF394, 0xDF22, 0xCF3E, 0xDAB0, 0x0FCD, 0xFE12, 0x087A, 0x1E38, 0x2C70, 0x19B4,
    0x0466, 0x0CCB, 0x0589, 0x13B9, 0xE4EB, 0x0413, 0xE5DF, 0xE089, 0xE964, 0xD4A8, 0xE327, 0xE4A3, 0x12D6, 0xF923, 0x0428, 0x04E1,
    0x1892, 0xFC72, 0xEE97, 0x0688, 0x098C, 0xFE2B, 0xD4CC, 0xD2DB, 0xD7BA, 0xDB06, 0xDE1A, 0xFB0E, 0xF391, 0x09DC, 0x0C44, 0x0305,
    0xFD21, 0xFB11, 0x0519, 0x204B, 0x16B5, 0x23BD, 0x143E, 0x0A77, 0x20DE, 0x1959, 0x1F96, 0xED09, 0xF8FA, 0xF2F6, 0xF334, 0xF3A0,
    0xF054, 0xC32D, 0xD3D3, 0xC8D2, 0xD458, 0xD511, 0xCBCE, 0xDC08, 0xB180, 0xE602, 0xC7FE, 0xC489, 0xC2F3, 0xD107, 0xD064, 0xC871,
    0xF6E1, 0xFC51, 0xEBBF, 0xF9D9, 0x1335, 0x243F, 0x273F, 0x2F5E, 0xFF98, 0xEEAC, 0x0D07, 0xF77C, 0x1C01, 0x0DAF, 0x1454, 0x12EB,
    0x0270, 0x0CA6, 0x02F9, 0x1DA2, 0x0422, 0xE1F2, 0x0439, 0x1CA6, 0x0367, 0x185D, 0x137D, 0x0809, 0x1371, 0x09C0, 0x13CA, 0xF39E,
    0x1157, 0x0D91, 0xF7B9, 0x1EC1, 0x17BE, 0x03C4, 0x1824, 0x1930, 0x1E26, 0x1457, 0x0F0D, 0x0824, 0x0770, 0x156D, 0xE2DF, 0xEB6C,
    0xE28A, 0xD5A9, 0xCC6A, 0xE626, 0xDCFD, 0xD7D4, 0xD73E, 0xD23C, 0xDFAE, 0xD1C0, 0xCFDF, 0xCB32, 0xE7A3, 0xF910, 0x1B05, 0x17C8,
    0xF9C1, 0xFC70, 0x0033, 0xE008, 0xF920, 0xFEE1, 0xF78B, 0x10D6, 0x0B9F, 0x10C9, 0x0F29, 0x1041, 0x3C5B, 0x177E, 0x127D, 0x1F22,
    0x1EFD, 0x2373, 0x0824, 0x0F32, 0x0C25, 0x0958, 0xE319, 0xEBC2, 0xDF31, 0xF583, 0xEE67, 0xD72E, 0xEB45, 0x087D, 0xDD1E, 0x038F,
    0x1955, 0xF2FA, 0xF387, 0xE779, 0x14CA, 0xEE3C, 0x0FB3, 0x0594, 0x1232, 0x2CB5, 0x2518, 0x403E, 0x6039, 0x4BD8, 0x17C7, 0x16DB,
    0x22FB, 0x2D6B, 0x34C3, 0x3C26, 0x13F5, 0x1789, 0x21ED, 0x0C03, 0x1B71, 0x3D80, 0x3F1E, 0x1A00, 0x0857, 0x1EE1, 0x05E7, 0x0196,
    0xF523, 0x0B62, 0x13BD, 0x09B8, 0x1665, 0xED0E, 0xDD2A, 0xF19B, 0x078D, 0xFC28, 0x105B, 0x0C0A, 0x0E24, 0xFF6F, 0x18B3, 0x237D,
    0x09E4, 0x064F, 0x09E8, 0x0904, 0x0060, 0x1629, 0xF8FA, 0xDB95, 0xE7F1, 0xF5E8, 0xC572, 0xB2E6, 0xBDBF, 0xC990, 0xB57F, 0xB8F5,
    0xC72D, 0xC08B, 0xC072, 0xC44E, 0xACAE, 0xABD6, 0xCD26, 0xBEC0, 0xC4B2, 0xDB80, 0xE154, 0xE295, 0xF490, 0xFA7B, 0x0591, 0x172D,
    0x2DBB, 0x1723, 0x1882, 0x2617, 0x1C7C, 0x1079, 0x3152, 0x42BB, 0x19B0, 0x1F66, 0x196A, 0xF924, 0xF275, 0xF05E, 0xF4DB, 0x0206,
    0xFD7E, 0x0078, 0xF738, 0xE543, 0xF925, 0x026E, 0xF393, 0xFB2C, 0xF200, 0x065D, 0xFD5D, 0xE039, 0xEA41, 0xF5B8, 0xEE44, 0xFB49,
    0xF95E, 0x0968, 0x21B0, 0x1529, 0x195F, 0x01ED, 0xFB0D, 0xF1E9, 0xF8EE, 0xFE46, 0xF81D, 0x07D8, 0x0CB7, 0xF8ED, 0xEC18, 0xDFA1,
    0xEDE1, 0xDC12, 0xC9A2, 0xED44, 0xF225, 0xD8BF, 0xC89F, 0xD8A9, 0xEEF1, 0xD996, 0xCB10, 0xDAE9, 0xC622, 0xD6F7, 0xD6A1, 0xE476,
    0xE860, 0xE3BA, 0xE66F, 0xE706, 0xF29C, 0xED6A, 0x057B, 0xFC52, 0x10E1, 0x1CC9, 0x08C4, 0x1296, 0x0519, 0x168E, 0x11AD, 0xF36E,
    0xF601, 0xF08B, 0xFA93, 0xDBA6, 0xD9E3, 0xE0F5, 0xEC1E, 0xDFF9, 0xD024, 0x017B, 0x0A79, 0xFD6E, 0xFAE0, 0x15DA, 0x08E6, 0x0F2B,
    0x12F3, 0x16DA, 0x1AFF, 0xF87B, 0x1224, 0x1C4C, 0x1A48, 0x2751, 0x26FA, 0x23E1, 0x356D, 0x430C, 0x47A2, 0x25A4, 0x07D3, 0x29FC,
    0x2E6F, 0x1C36, 0x0969, 0x0A2B, 0x0044, 0xF8AD, 0xEDEC, 0xEE68, 0xF0C6, 0xE5B9, 0xF3E9, 0xE82F, 0xF218, 0xF0BB, 0xF08B, 0xFB51,
    0x014C, 0xF98E, 0xF718, 0xF509, 0xFDBD, 0x0F04, 0x07F0, 0x087A, 0xF588, 0xFF1F, 0xFAEA, 0x03EA, 0x0CBB, 0xFD07, 0x1349, 0x1707,
    0x2110, 0x2B59, 0x1F79, 0x14D6, 0x0DD9, 0xFD76, 0xDC07, 0xFA42, 0x0703, 0xE0DA, 0xD2F9, 0xD5B7, 0xD771, 0xD8A1, 0xDDBB, 0xE09B,
    0xEB2B, 0xF07B, 0xF193, 0xDCBF, 0xDCC9, 0xE690, 0xD8B8, 0xC724, 0xCF88, 0xEF7D, 0xEF8D, 0xE3A4, 0xED94, 0xF9F4, 0x0D87, 0x09DE,
    0xEFDE, 0xDF87, 0xE566, 0x0576, 0x02C3, 0xF735, 0xF8DC, 0xF69E, 0x08B5, 0x0A31, 0x137F, 0xFC12, 0xF070, 0x1529, 0x1A2B, 0x1365,
    0x1BDA, 0x1637, 0x1436, 0x1F49, 0x0E8E, 0x17E2, 0x0FA4, 0x022C, 0xF212, 0xFC99, 0x1059, 0x16BF, 0x0DA3, 0x1370, 0x1688, 0x202B,
    0x1DC0, 0x14EB, 0x2E55, 0x1E32, 0x07C5, 0x0DAC, 0x32AA, 0x2512, 0x3077, 0x2CD1, 0x0BA5, 0xFDB1, 0x0776, 0x0623, 0x0014, 0xF3EA,
    0xF967, 0xF0F8, 0xDA87, 0xE78F, 0xF8C2, 0x1C9C, 0x0EE7, 0x017C, 0xF305, 0xF350, 0xEF12, 0xE228, 0xD194, 0xEDD7, 0xF103, 0xEE16,
    0xF913, 0xE869, 0x0938, 0x0F3A, 0x1194, 0x0EE1, 0x0DEF, 0x0DA5, 0x0ABB, 0x0D3D, 0x1663, 0x2011, 0x1814, 0x0F66, 0x1700, 0x16AC,
    0x0584, 0xFF8F, 0xFE21, 0x05F7, 0xFD6E, 0x074B, 0x0A0F, 0x04A9, 0x0280, 0xEDAF, 0xE385, 0xD748, 0xDFBC, 0xE2DB, 0xFCCD, 0x0910,
    0x054A, 0x1072, 0x0E30, 0x17D3, 0x14B4, 0x2530, 0x3AC8, 0x40CB, 0x3D39, 0x3C65, 0x3F9C, 0x3D05, 0x3C76, 0x3384, 0x2D9B, 0x26C0,
    0x2FDE, 0x1C38, 0x02B2, 0x173C, 0x0EE3, 0xFC3D, 0xF236, 0xE947, 0x00C5, 0xFD32, 0xE38D, 0xE443, 0xE6A0, 0xEA2A, 0xE078, 0xDCE3,
    0xD688, 0xD405, 0xE02C, 0xDCBF, 0xCB86, 0xD956, 0xEF1E, 0xEC6E, 0xFF49, 0x09C4, 0x0DFA, 0x1454, 0x2060, 0x148B, 0x016C, 0xFDD7,
    0xF6EE, 0xEDE6, 0xE497, 0xEC3B, 0xED62, 0xD6D4, 0xBE3D, 0xAC18, 0xA7D8, 0xC0EC, 0xC8F0, 0xC4D5, 0xBDFA, 0xB9CF, 0xC1CA, 0xCA06,
    0xBAB5, 0xBFD5, 0xDAD4, 0xF467, 0x01CC, 0xFC15, 0x04C8, 0xF934, 0x08AB, 0x0FE0, 0x0A7B, 0x2247, 0x351D, 0x40D1, 0x3DB9, 0x2FA2,
    0x261D, 0x23D7, 0x2A56, 0x2794, 0x2072, 0x145A, 0x062E, 0x1517, 0x0E4E, 0x15C8, 0x27EC, 0x2540, 0x32BD, 0x22D6, 0x1F6B, 0x2FB3,
    0x0C2E, 0x03C2, 0x0DAD, 0x1584, 0x13FF, 0xFA69, 0xF863, 0x1045, 0x1ECD, 0x1A0D, 0x2254, 0x0DD6, 0x1453, 0x22F1, 0x2444, 0x2D36,
    0x2C46, 0x2B9C, 0x26EA, 0x1F0A, 0x1D9D, 0x0D73, 0xEEBC, 0xF07F, 0xEAB7, 0xE629, 0xD7A3, 0xD29E, 0xCF56, 0xD384, 0xD219, 0xC979,
    0xD48C, 0xDFC8, 0xD6D0, 0xC1CF, 0xD4EE, 0xE26B, 0xDF8A, 0xE4A4, 0xE071, 0xD10E, 0xDB47, 0xD6BC, 0xD3C2, 0xDE49, 0xDC98, 0xE54C,
    0xF448, 0xF913, 0x02B7, 0x0145, 0x0540, 0x122A, 0x120A, 0x1A71, 0x03B7, 0xEA24, 0xF3CD, 0xFDFD, 0xE104, 0xD93E, 0xDF5F, 0xDFFC,
    0xEBDA, 0xF8C7, 0xFFDB, 0xF685, 0xEED0, 0xE925, 0xE45D, 0xED18, 0xF494, 0xD101, 0xDB48, 0xE981, 0xECB7, 0x07FE, 0x15A6, 0x1DBB,
    0x159D, 0x2122, 0x2D7D, 0x2031, 0x2218, 0x40AB, 0x3DDA, 0x384E, 0x28DC, 0x3162, 0x3595, 0x1C7F, 0x14ED, 0xF73D, 0xEB50, 0xECF2,
    0xF841, 0xFCFE, 0x065D, 0x1060, 0xFE0F, 0xF7E5, 0x088A, 0x0354, 0xF9D0, 0x006D, 0x04FB, 0x0667, 0x030E, 0x0115, 0x03F8, 0x03F6,
    0x0A8D, 0x175F, 0x14D9, 0x176C, 0x198F, 0x23EB, 0x3B3D, 0x4018, 0x391B, 0x3BC7, 0x2CFA, 0x0F3A, 0x1DAF, 0x210F, 0x2138, 0x1D6E,
    0xFFCB, 0xF43F, 0xD45F, 0xD5BB, 0xCFE6, 0xBB52, 0xC2D8, 0xC6B7, 0xCFA0, 0xD0C5, 0xC5F3, 0xBBD1, 0xBC63, 0xCF04, 0xE76A, 0xD71C,
    0xDA0C, 0xDA0B, 0xDE1F, 0x026E, 0x0640, 0x0735, 0x044F, 0xF7EC, 0x019B, 0xF5C6, 0xF5F7, 0xF46F, 0xF9C1, 0xFCDF, 0xF7D1, 0x0235,
    0xFF7F, 0xF7F9, 0xE760, 0xF9AE, 0xEEFF, 0xF9BB, 0xE659, 0xE31F, 0xF4D2, 0x016B, 0xFD86, 0xE970, 0x0190, 0xFE98, 0xFA35, 0xF10A,
    0xFB16, 0xEE4C, 0xF3E8, 0x02E0, 0x0928, 0x179B, 0x2959, 0x3606, 0x3694, 0x1E48, 0x126E, 0x17AD, 0x2D2D, 0x46F0, 0x3F41, 0x3317,
    0x19CD, 0x0FE6, 0x14B2, 0x04F2, 0xF86D, 0xFD71, 0xF3DB, 0xEFB6, 0xDD55, 0xD093, 0xCC3F, 0xD36A, 0xCCDE, 0xC9F7, 0xD2F4, 0xD2FE,
    0xBF4B, 0xC504, 0xD371, 0xD162, 0xDD8E, 0xE589, 0xDBBB, 0xC7EB, 0xD902, 0xDBBA, 0xE1CE, 0xE222, 0xF3FC, 0xFAA6, 0xFC2D, 0xEDDD,
    0xF56F, 0x0E52, 0xF843, 0xFBD2, 0xF4A5, 0xF7E0, 0xFB38, 0xE7CE, 0xDD66, 0xD4A1, 0xDC7C, 0xE9E2, 0xE624, 0xED54, 0xF11D, 0xF804,
    0xF912, 0xFBBF, 0x09AF, 0x0C63, 0xFF57, 0x0029, 0xF69C, 0xF98C, 0x10FF, 0x1D65, 0x2213, 0x248A, 0x3878, 0x3155, 0x3F03, 0x4C93,
    0x59E8, 0x56A6, 0x4588, 0x468D, 0x4323, 0x42D8, 0x4030, 0x31F5, 0x21D3, 0x2352, 0x1E41, 0x0B84, 0xFC91, 0xFB55, 0x04EB, 0x17CC,
    0xFDF6, 0xFAB0, 0x07EB, 0x1124, 0x0731, 0xED98, 0xF315, 0xF782, 0xFED8, 0xF333, 0xF63B, 0xF3E4, 0x0591, 0x0560, 0xEF04, 0xF6E4,
    0x0271, 0x182D, 0x1876, 0x1BA8, 0x2B70, 0x2749, 0x1BAA, 0x0D57, 0xF968, 0xEC2A, 0xE654, 0xE4C0, 0xD063, 0xCD23, 0xC48A, 0xC05D,
    0xBEFB, 0xB472, 0xBAA9, 0xB7DC, 0xCAF6, 0xCE23, 0xC724, 0xC489, 0xC551, 0xBE3D, 0xC27F, 0xD242, 0xD66C, 0xDC0E, 0xE0A9, 0xEBA7,
    0xF89F, 0x1254, 0x180F, 0x1393, 0x1616, 0x1262, 0x13CF, 0x2031, 0x256E, 0x16DA, 0x1237, 0x0F77, 0x0A99, 0x148D, 0x0B30, 0xFF0A,
    0xF43F, 0xF7A3, 0x1AC8, 0x19CF, 0x1613, 0x1C92, 0x2186, 0x2675, 0x27B6, 0x1E90, 0x0344, 0x0470, 0x0200, 0x0E86, 0x0F8F, 0x11BB,
    0x20C3, 0x24EB, 0x2B06, 0x29A0, 0x33FA, 0x3043, 0x2C14, 0x286A, 0x26CE, 0x23B8, 0x2584, 0x1D4C, 0x11C4, 0x19F2, 0x17B8, 0x0CED,
    0x041D, 0x018C, 0xF6A8, 0xE7FC, 0xE49D, 0xDD38, 0xDEA7, 0xDB28, 0xEAD9, 0xFC15, 0xF051, 0xF4FF, 0xF1EB, 0xE613, 0xE721, 0xEE6A,
    0xEF32, 0xE660, 0xE4F0, 0xE682, 0xE91F, 0xF00C, 0xEC1C, 0xEE9F, 0xEE63, 0xF098, 0xF986, 0x04A2, 0xFF64, 0x07E9, 0x162F, 0x0745,
    0xFDE7, 0xFBA4, 0x030E, 0xFAAB, 0xEF05, 0xEA31, 0xE1E0, 0xECF8, 0xFBBB, 0xF5F0, 0xF6D8, 0x057F, 0x0460, 0xFBBF, 0x059B, 0x0CC9,
    0x0AB0, 0x0AD4, 0x0BE3, 0x0E99, 0x15E2, 0x1833, 0x17C9, 0x1420, 0x13B5, 0x1482, 0x155C, 0x1C95, 0x1AB6, 0x257D, 0x2B32, 0x2B85,
    0x28DA, 0x1F26, 0x1E33, 0x1B28, 0x19CD, 0x1213, 0xFE22, 0xF6A5, 0xF3FC, 0xFEE4, 0x0146, 0xF6E1, 0xFF54, 0x041F, 0x0789, 0xFBFC,
    0x04B8, 0x0D7F, 0x1081, 0x07A3, 0xFD58, 0x074B, 0xFDDE, 0xFF64, 0x013A, 0x0C03, 0x0F9C, 0x13E1, 0x1FF8, 0x2377, 0x27E2, 0x2A8E,
    0x29E0, 0x25AF, 0x22DC, 0x1B2A, 0x141B, 0x11FA, 0x0CB6, 0x058C, 0xFC0A, 0xF338, 0xF2C6, 0xEFB3, 0xEEED, 0xED72, 0xE9BE, 0xE32F,
    0xE32B, 0xDA42, 0xD5AC, 0xD0D7, 0xD748, 0xDF95, 0xD773, 0xDB0A, 0xD199, 0xD013, 0xC27D, 0xCB73, 0xD574, 0xD678, 0xD95D, 0xD42F,
    0xE90F, 0xF244, 0xEF2B, 0xE3C5, 0xDF08, 0xE633, 0xE2DB, 0xD915, 0xDA3B, 0xD187, 0xDC8D, 0xDF46, 0xDFCE, 0xE2EA, 0xDA02, 0xF2D6,
    0x07A8, 0x167C, 0x18B9, 0x120F, 0x0BED, 0x01EA, 0xFEF3, 0xF71E, 0xF503, 0xFC95, 0x02CF, 0x0E2B, 0x104C, 0x24C4, 0x326F, 0x33E7,
    0x2871, 0x1DAE, 0x2C03, 0x2DE2, 0x3638, 0x3912, 0x3466, 0x32CF, 0x2FBA, 0x233E, 0x1A82, 0x150F, 0x14E9, 0x0AB7, 0x064F, 0x0116,
    0xFAB7, 0x0447, 0x03A6, 0x06A2, 0xFB10, 0xFCCC, 0xF20F, 0xE84F, 0xEE7C, 0xEDFA, 0xE8DF, 0xDFA3, 0xE599, 0xE4CD, 0xE7BD, 0xEEFD,
    0xF2B9, 0xED6C, 0xE07D, 0xE44E, 0xED95, 0xEB6C, 0xEDFC, 0xE2B2, 0xE48C, 0xEBE1, 0xF4E1, 0xFF5E, 0xFB5E, 0xF727, 0xEE9F, 0xF0F8,
    0xE843, 0xE02B, 0xE15E, 0xE4E1, 0xF269, 0xFF82, 0xF75D, 0xF1EC, 0xF636, 0xF18D, 0xE2DA, 0xE101, 0xE04A, 0xE65A, 0xF553, 0x04AC,
    0x0B78, 0x0C09, 0x19F6, 0x188D, 0x1EB5, 0x277B, 0x2EA5, 0x2D45, 0x36BD, 0x46B5, 0x498B, 0x3FA8, 0x3B5A, 0x38DB, 0x3221, 0x2B1A,
    0x26D6, 0x2995, 0x1769, 0x13A8, 0x0ECD, 0x118C, 0x1329, 0x0A70, 0x053F, 0xFE15, 0xF6C7, 0xFBB1, 0x0186, 0xF5BE, 0xF5EF, 0xF3BB,
    0xF388, 0xE4D1, 0xD7C2, 0xDBBF, 0xE166, 0xE627, 0xEB8E, 0xE980, 0xE300, 0xEC8F, 0xF185, 0x013E, 0x09F2, 0x0E0A, 0x0ED5, 0x0A97,
    0xFE29, 0xF21C, 0xF203, 0xED67, 0xE726, 0xDC33, 0xD83D, 0xCE39, 0xC8A4, 0xCDB9, 0xCCE8, 0xCD64, 0xCEDD, 0xCD75, 0xCD3F, 0xCAED,
    0xCBD4, 0xC9A2, 0xD648, 0xDD69, 0xDD8E, 0xE47C, 0xE281, 0xDAD6, 0xDFCA, 0xE827, 0xF3E9, 0x0171, 0x0476, 0x1093, 0x17E3, 0x1F3F,
    0x1F69, 0x1BA3, 0x1D71, 0x244A, 0x2212, 0x2609, 0x1A7C, 0x182C, 0x165D, 0x0E05, 0x0DA8, 0x0C74, 0x1928, 0x1B10, 0x1D17, 0x1B8A,
    0x1C53, 0x1881, 0x129F, 0x0C46, 0x03F7, 0xFE98, 0x01B8, 0x0249, 0x030D, 0x06E6, 0x147F, 0x14C1, 0x195C, 0x1D14, 0x1A08, 0x1E0E,
    0x233A, 0x3281, 0x3525, 0x315C, 0x26AD, 0x23CC, 0x1DC3, 0x1701, 0x04BD, 0x00C4, 0x00A0, 0xF56B, 0xE77A, 0xDFDC, 0xEE0B, 0xF120,
    0xF12B, 0xEC8D, 0xE911, 0xE698, 0xE1E6, 0xE05D, 0xDEB4, 0xDC8B, 0xDD68, 0xE2D4, 0xDF07, 0xD658, 0xDB20, 0xE620, 0xEE6E, 0xEF49,
    0xEEB9, 0xEEC3, 0xF512, 0xFC56, 0xFFD3, 0x00DD, 0xFF8F, 0x01D1, 0x004D, 0xFE9C, 0xF736, 0xF161, 0xF501, 0xFA45, 0xF743, 0xF178,
    0xF2A1, 0x00D6, 0x08D6, 0x0003, 0xF803, 0xF2D2, 0xF3BC, 0xED0F, 0xEAA4, 0xEA93, 0xE73F, 0xF177, 0xF6A2, 0xFC26, 0x031E, 0x0983,
    0x0B1C, 0x0AFB, 0x19F9, 0x2336, 0x26A5, 0x273C, 0x280B, 0x2873, 0x289D, 0x2787, 0x20B9, 0x1CA8, 0x193F, 0x16A9, 0x14A9, 0x12A4,
    0x0C94, 0x0218, 0xFFE8, 0x0533, 0x081C, 0x02AD, 0x0008, 0x000A, 0xFF9B, 0xFB51, 0xF643, 0xFAE3, 0xFF6E, 0x070B, 0x0532, 0x07FF,
    0x0A49, 0x0FEA, 0x1B1B, 0x215C, 0x267A, 0x29B4, 0x2D15, 0x316D, 0x32AD, 0x32FD, 0x36D9, 0x3385, 0x314E, 0x259E, 0x253D, 0x259F,
    0x1AD2, 0x0F1C, 0x0150, 0xF58B, 0xE98C, 0xE00A, 0xDABF, 0xDCD1, 0xE1B8, 0xE7A5, 0xE8CE, 0xDD21, 0xDC63, 0xE48D, 0xE439, 0xE3B9,
    0xDDEC, 0xD735, 0xD5AA, 0xD79C, 0xD7F4, 0xDAE6, 0xDFFB, 0xE66D, 0xECE2, 0xF7FA, 0x0433, 0x0700, 0x038F, 0xFEC4, 0xF700, 0xF140,
    0xF0DF, 0xEA5F, 0xE38C, 0xE238, 0xE7EA, 0xED9A, 0xECFF, 0xEB97, 0xEA54, 0xF2B3, 0xF7B3, 0x0746, 0x13FC, 0x0AC2, 0x0FBB, 0x17D4,
    0x1366, 0x12F4, 0x110F, 0x0B0A, 0x10AB, 0x1406, 0x1887, 0x1A61, 0x1F52, 0x286E, 0x2EDA, 0x3AE6, 0x3FBE, 0x4159, 0x3DE0, 0x37B8,
    0x3E71, 0x3665, 0x2E1F, 0x26D6, 0x1FEB, 0x17C1, 0x0971, 0x06E8, 0xFCC4, 0x0027, 0xFACB, 0x0389, 0x156A, 0x1396, 0x0FC3, 0x08C2,
    0x07A4, 0x0358, 0x01DA, 0xFDA2, 0xF6B3, 0xF1C7, 0xE847, 0xE4BE, 0xE15B, 0xD9DE, 0xD9AF, 0xDFD7, 0xE6D5, 0xEEBF, 0xF442, 0xFB40,
    0x0188, 0xF3BA, 0xEF64, 0xE9CF, 0xDE82, 0xD941, 0xD79C, 0xD8BE, 0xD0A0, 0xD272, 0xD6BE, 0xE59C, 0xF611, 0xFD6C, 0x0679, 0x0D63,
    0x0F59, 0x0D33, 0x0A53, 0xFD8D, 0xF353, 0xF1ED, 0xF64D, 0xF8ED, 0xFB49, 0x05ED, 0x1239, 0x20FC, 0x23B6, 0x2762, 0x26B1, 0x26AC,
    0x2B5E, 0x234B, 0x25C3, 0x22BE, 0x28DE, 0x301F, 0x3272, 0x32CB, 0x2C04, 0x26BE, 0x1F61, 0x1E7A, 0x1166, 0x15A0, 0x1D0B, 0x1751,
    0x12A1, 0x1593, 0x18AC, 0x15D2, 0x1574, 0x157F, 0x0E6F, 0xFF98, 0xFA44, 0xF1E7, 0xF155, 0xF1A9, 0xF48D, 0xF338, 0xEFD7, 0xED02,
    0xE926, 0xE6A6, 0xE9EB, 0xF380, 0xF8FE, 0xFE5F, 0xFD1E, 0xFD3C, 0xF974, 0xFA14, 0xF31E, 0xEC47, 0xEDC9, 0xED65, 0xE636, 0xDC73,
    0xDCBB, 0xDDC0, 0xE0DD, 0xE7B0, 0xE254, 0xD21B, 0xCB92, 0xCF7B, 0xD0AF, 0xCC86, 0xD1C1, 0xD742, 0xDC6C, 0xE130, 0xE46D, 0xEBD3,
    0xF15A, 0xEE0A, 0xE73E, 0xE6A8, 0xE9F9, 0xED53, 0xF24B, 0xFB2B, 0x0236, 0x060B, 0x0888, 0x0E51, 0x0B8A, 0x07D7, 0x096B, 0x0535,
    0x0C34, 0x11F0, 0x17B1, 0x1EA2, 0x1E96, 0x21FA, 0x2058, 0x2000, 0x1ED3, 0x1879, 0x1115, 0x0FBE, 0x14D7, 0x1381, 0x0F9A, 0x0F0A,
    0x0AAC, 0x04B9, 0x0333, 0x04B6, 0x0837, 0x0650, 0x004B, 0xFE3E, 0xFFCD, 0x041F, 0x06DC, 0x0365, 0xFDB5, 0xFB87, 0xFE61, 0xFD56,
    0x00D6, 0x03CE, 0xFF53, 0xFBF5, 0xF72D, 0xF2BD, 0xEBD4, 0xEF08, 0xF834, 0xF52C, 0xEDE8, 0xE9B0, 0xEDDF, 0xEE4D, 0xE921, 0xE7D9,
    0xE5B4, 0xEBE4, 0xF01D, 0xEB3C, 0xE8B5, 0xE9E8, 0xEB37, 0xE699, 0xE1D7, 0xDEE2, 0xE051, 0xE369, 0xE4ED, 0xEA59, 0xEAC8, 0xEF98,
    0xF0F8, 0xECD4, 0xEC9C, 0xED76, 0xF0AC, 0xF1C9, 0xF5E9, 0xFAEB, 0xFFEE, 0xFF71, 0x005B, 0x0027, 0xFF7B, 0x0069, 0x00F9, 0x03C6,
    0x05C3, 0x04D9, 0xFD5E, 0xFC80, 0xFE18, 0x020B, 0x0811, 0x0F56, 0x16E2, 0x170D, 0x164B, 0x1522, 0x1229, 0x1043, 0x0C4C, 0x08AE,
    0x0B6A, 0x0E9A, 0x0E47, 0x1001, 0x1157, 0x11F4, 0x13B5, 0x11DD, 0x0CB4, 0x04A7, 0x0336, 0x03C5, 0x090F, 0x0C96, 0x09CA, 0x0E9D,
    0x100E, 0x136D, 0x182F, 0x1579, 0x1283, 0x0E9C, 0x0C47, 0x09D2, 0x06EA, 0x01CA, 0xFC1C, 0x00D0, 0x071A, 0x0F11, 0x17F3, 0x1877,
    0x1556, 0x189C, 0x211D, 0x2489, 0x236A, 0x242F, 0x1F20, 0x1284, 0x0A21, 0x021E, 0xF899, 0xEE67, 0xE97B, 0xE7F0, 0xE891, 0xEA10,
    0xEBE5, 0xECC2, 0xE8D6, 0xE88E, 0xE4E9, 0xE1C9, 0xDDD7, 0xD49C, 0xD49D, 0xD68B, 0xD3E8, 0xD0FA, 0xCE21, 0xCC72, 0xCB2C, 0xC8BB,
    0xC9C0, 0xC713, 0xC3A4, 0xC902, 0xD143, 0xD2CC, 0xD08A, 0xCF91, 0xD2C5, 0xD6E9, 0xD7CC, 0xE10B, 0xE652, 0xEC37, 0xEFB1, 0xF38D,
    0xFD2A, 0x0716, 0x1140, 0x0E0C, 0x0DBA, 0x0903, 0x058A, 0x0C1B, 0x11C6, 0x184F, 0x1727, 0x15C4, 0x17A4, 0x1962, 0x1CC2, 0x22B7,
    0x2335, 0x1A9E, 0x1D17, 0x26CA, 0x2BA3, 0x2CA7, 0x27B2, 0x255A, 0x244B, 0x22C4, 0x25B7, 0x23B1, 0x1C8C, 0x1A57, 0x1E95, 0x2553,
    0x23F9, 0x1F7D, 0x1B6F, 0x198A, 0x1856, 0x14A3, 0x0C98, 0x036C, 0x0745, 0x09A8, 0x0B23, 0x08C8, 0x035C, 0x004D, 0xFC9D, 0xF724,
    0xF0AE, 0xF173, 0xEE13, 0xE7E8, 0xE320, 0xDBA3, 0xD63A, 0xD634, 0xDC98, 0xE15A, 0xE10A, 0xE532, 0xE2FF, 0xDD77, 0xDEB8, 0xE4AD,
    0xE674, 0xE860, 0xE89C, 0xE98F, 0xED44, 0xEBF0, 0xF218, 0xF650, 0xF3D8, 0xF26C, 0xFC6C, 0x01F6, 0xFD4A, 0xFF59, 0x0589, 0x0447,
    0x0103, 0x034D, 0x070B, 0x061A, 0x03B2, 0x0DE8, 0x1749, 0x1F07, 0x23C7, 0x23A2, 0x24B1, 0x27A5, 0x2A73, 0x2AB5, 0x2E27, 0x2D3A,
    0x2CB4, 0x2912, 0x2442, 0x253A, 0x2569, 0x2748, 0x24F1, 0x22A2, 0x1F4B, 0x1662, 0x0F96, 0x0B79, 0x08F2, 0x07E4, 0x0CB6, 0x1032,
    0x0AB0, 0x0124, 0xFC15, 0xFB2A, 0xF993, 0xF8D5, 0xF5CD, 0xF062, 0xEC9B, 0xE8CA, 0xE546, 0xE906, 0xEB09, 0xEE2B, 0xF68E, 0xFB52,
    0xFC4E, 0xF946, 0xF44F, 0xF37B, 0xF451, 0xF337, 0xF53C, 0xF589, 0xF168, 0xECE9, 0xE993, 0xE4DA, 0xE574, 0xE831, 0xE5C6, 0xE44A,
    0xDFE5, 0xDD5D, 0xD786, 0xD0B0, 0xD74A, 0xDEF0, 0xE474, 0xE6AD, 0xE61E, 0xE8EC, 0xF14F, 0xF505, 0xEFC6, 0xF054, 0xF3DA, 0xF87A,
    0xFB32, 0x0060, 0x02FB, 0xFDD1, 0xFE02, 0x04EB, 0x0E73, 0x162E, 0x1B8B, 0x1C83, 0x20BA, 0x2546, 0x26FB, 0x2ADE, 0x2B4F, 0x2ACE,
    0x2D8C, 0x3062, 0x2F48, 0x2CAF, 0x27F0, 0x218C, 0x1BF4, 0x1709, 0x1812, 0x1C70, 0x1BE0, 0x15BF, 0x0FE4, 0x0BC7, 0x0A21, 0x094F,
    0x0645, 0x08F9, 0x0B26, 0x0822, 0x042A, 0x00C3, 0xFD0A, 0xF7F6, 0xFA24, 0xFBF3, 0xFBEA, 0xFA87, 0xF7C2, 0xF67C, 0xF4F4, 0xF0E5,
    0xF128, 0xF988, 0xFFE7, 0x0050, 0xFDBB, 0xFFE1, 0xFE34, 0xF8C6, 0xF30E, 0xE982, 0xE57B, 0xE6D7, 0xEAB9, 0xEC19, 0xE368, 0xDC4D,
    0xD97D, 0xDC8B, 0xDF99, 0xE0E6, 0xE3F5, 0xE608, 0xEA8F, 0xEBC7, 0xEA0A, 0xE7BF, 0xEC64, 0xEE05, 0xEB2B, 0xEF24, 0xF30E, 0xF4CB,
    0xF89A, 0xFE6D, 0x0325, 0x082E, 0x1180, 0x16A5, 0x1487, 0x152D, 0x1524, 0x1238, 0x0F57, 0x0A4C, 0x0877, 0x0ABB, 0x0C56, 0x0FA8,
    0x0F24, 0x0DCA, 0x0FB3, 0x0E49, 0x0A62, 0x09AB, 0x0EC1, 0x147D, 0x1946, 0x1F0C, 0x1FE6, 0x1AEC, 0x1B0D, 0x18A9, 0x15B7, 0x1578,
    0x133E, 0x133E, 0x15BA, 0x1A65, 0x1724, 0x127B, 0x115F, 0x11DF, 0x11A0, 0x137D, 0x1514, 0x10DE, 0x1104, 0x1197, 0x1039, 0x0D28,
    0x0B9A, 0x06B0, 0xFF1B, 0xFA94, 0xFA41, 0xFCA7, 0x03F7, 0x0B71, 0x0A25, 0x0E58, 0x1033, 0x10B0, 0x15C8, 0x179F, 0x1513, 0x0FA6,
    0x0B70, 0x0A3C, 0x098E, 0x06EF, 0x0298, 0xFCAB, 0xF4A7, 0xEC10, 0xEDD6, 0xE95D, 0xE238, 0xDE50, 0xDB4F, 0xDC15, 0xD516, 0xD0F8,
    0xCFD1, 0xCF11, 0xCD6B, 0xCE0C, 0xCF40, 0xCB8D, 0xCA16, 0xCBAD, 0xCC17, 0xC9D9, 0xC791, 0xCADE, 0xCFBE, 0xD44B, 0xD8B3, 0xD8CC,
    0xD882, 0xD755, 0xD911, 0xDDC1, 0xE227, 0xE684, 0xF0B1, 0xFB99, 0x0257, 0x04F4, 0x0703, 0x0CD9, 0x1109, 0x16B3, 0x19BF, 0x1CE0,
    0x1F56, 0x248C, 0x261F, 0x213B, 0x2151, 0x1F21, 0x1ACB, 0x1C13, 0x1F77, 0x1E1E, 0x20D3, 0x22D5, 0x26F4, 0x2D2A, 0x32AC, 0x3AC8,
    0x3B70, 0x386E, 0x37A3, 0x341A, 0x30C3, 0x321C, 0x3115, 0x2CE3, 0x2587, 0x1FE6, 0x1DA3, 0x19AB, 0x183F, 0x198C, 0x18B0, 0x1888,
    0x14E9, 0x0F71, 0x0AF9, 0x07D9, 0x0370, 0xFCD6, 0xF983, 0xF24D, 0xEB22, 0xE2DE, 0xDBBE, 0xD63D, 0xD212, 0xD245, 0xD10B, 0xD5E5,
    0xDB10, 0xDD21, 0xDEAC, 0xDE24, 0xDDEA, 0xDCBA, 0xD796, 0xD175, 0xCDD8, 0xCE7C, 0xD054, 0xD3D0, 0xDA87, 0xE0ED, 0xEAB6, 0xF1BC,
    0xF606, 0xF6AF, 0xF48D, 0xF202, 0xEF8D, 0xF42B, 0xF569, 0xF26D, 0xF5FA, 0xF946, 0xFB12, 0x0253, 0x0B4F, 0x116B, 0x1358, 0x120D,
    0x12C8, 0x13E8, 0x14D2, 0x184B, 0x1E43, 0x2496, 0x28FF, 0x2CAB, 0x2D18, 0x2A21, 0x2657, 0x27C7, 0x2ACA, 0x2868, 0x20ED, 0x1B26,
    0x19CF, 0x1B09, 0x1FF1, 0x237B, 0x24C2, 0x2424, 0x1CEF, 0x1571, 0x11D8, 0x0DEC, 0x08C3, 0x062E, 0x06C3, 0x049E, 0x0138, 0xFE00,
    0xFC03, 0xF412, 0xEC62, 0xE8DB, 0xE5B2, 0xEA01, 0xF4DD, 0xFFD5, 0x0420, 0x00C2, 0xFB4D, 0xF872, 0xF50E, 0xF2E9, 0xF7E1, 0xFD5F,
    0xFE49, 0xFACA, 0xF4C9, 0xEF92, 0xEA88, 0xE8E9, 0xEA02, 0xE50B, 0xDC67, 0xD88F, 0xD6CB, 0xD720, 0xD9AC, 0xDBFE, 0xDBEA, 0xD93B,
    0xD236, 0xCE6F, 0xD139, 0xD4DC, 0xDBDD, 0xE389, 0xE9B7, 0xEDD7, 0xF2D4, 0xF967, 0xFD8E, 0x000F, 0xFD6A, 0xF977, 0xF9F5, 0xFC5D,
    0x005B, 0x0550, 0x0ECB, 0x12B9, 0x1376, 0x1760, 0x1B46, 0x21BD, 0x22A0, 0x2181, 0x2309, 0x266B, 0x27F7, 0x25A4, 0x212A, 0x1FB2,
    0x216F, 0x200D, 0x1E24, 0x1B86, 0x180D, 0x1466, 0x0AAB, 0x016A, 0xFDFB, 0xFD92, 0x01B2, 0x0588, 0x080D, 0x06AF, 0x036A, 0x00BD,
    0x0009, 0x00EC, 0x01C7, 0x0332, 0x039C, 0x0457, 0x0271, 0x026C, 0x0161, 0x0189, 0x0724, 0x08F4, 0x0768, 0x0570, 0x060C, 0x07CB,
    0x066C, 0x032A, 0xFDE1, 0xF651, 0xF2EE, 0xF209, 0xEEDE, 0xE8C6, 0xE291, 0xE0F1, 0xDEEF, 0xDD8E, 0xDDA8, 0xDF28, 0xE180, 0xE25C,
    0xE2DF, 0xE51E, 0xE495, 0xE46C, 0xE88D, 0xE9D8, 0xE990, 0xE997, 0xED34, 0xEF88, 0xF354, 0xFB15, 0x00CD, 0x054D, 0x083C, 0x095C,
    0x0849, 0x0733, 0x0360, 0xFF9B, 0xFE79, 0x01E2, 0x0B06, 0x1032, 0x0DBA, 0x0AB6, 0x0E03, 0x0C93, 0x0754, 0x06CC, 0x0BA5, 0x1197,
    0x126C, 0x12C7, 0x14CC, 0x1746, 0x1A0A, 0x1B16, 0x1A50, 0x1B8D, 0x1E2E, 0x17DA, 0x0F8F, 0x0EE1, 0x0E57, 0x118F, 0x1476, 0x166B,
    0x1808, 0x16E7, 0x13CB, 0x1199, 0x1193, 0x128E, 0x106F, 0x0C55, 0x0B8F, 0x0897, 0x0AAE, 0x0C5A, 0x0AE8, 0x0B7D, 0x0B79, 0x0EE7,
    0x11B2, 0x1559, 0x1C7A, 0x1E73, 0x1FA2, 0x20C7, 0x20D1, 0x21F3, 0x1FFA, 0x1B72, 0x18F3, 0x1651, 0x10AF, 0x0C9B, 0x071C, 0x013E,
    0xFB04, 0xF473, 0xEF38, 0xEB90, 0xEA0D, 0xE8A7, 0xE489, 0xDB1E, 0xD18F, 0xCB0B, 0xC948, 0xC9E6, 0xCB0C, 0xC99B, 0xC623, 0xC47D,
    0xC368, 0xC3C3, 0xC42F, 0xC76D, 0xCB35, 0xCF8B, 0xD464, 0xD6E7, 0xD6C5, 0xD4FB, 0xD4DE, 0xDBF6, 0xE504, 0xE9A0, 0xECBD, 0xEE7F,
    0xF32A, 0xF3ED, 0xF49B, 0xF70A, 0xF936, 0xFE06, 0x07BB, 0x12AB, 0x1588, 0x1380, 0x131F, 0x17DA, 0x1ADC, 0x1C96, 0x1D72, 0x1CED,
    0x1AA8, 0x1794, 0x1B13, 0x2043, 0x251E, 0x2D79, 0x32E7, 0x3436, 0x3497, 0x342D, 0x3504, 0x3922, 0x3D67, 0x40BC, 0x40A8, 0x3AD8,
    0x36A7, 0x3434, 0x2F69, 0x29D9, 0x24D4, 0x1E84, 0x1C48, 0x1D6D, 0x1D27, 0x1A8D, 0x174A, 0x165F, 0x1488, 0x1163, 0x0C08, 0x0675,
    0xFE73, 0xF57C, 0xEF4B, 0xEAE7, 0xE6C3, 0xDF1E, 0xD973, 0xD724, 0xD7BD, 0xDAC1, 0xDF0B, 0xE17F, 0xE161, 0xE023, 0xDD8C, 0xDB06,
    0xD87C, 0xD624, 0xD5BF, 0xD864, 0xDC66, 0xDF08, 0xE242, 0xE841, 0xED20, 0xEDD0, 0xEAEA, 0xEABA, 0xEBEB, 0xEB66, 0xE789, 0xE4BE,
    0xE8A0, 0xEF81, 0xF45C, 0xF741, 0xFAD3, 0xFB6C, 0xFC98, 0x0016, 0x06D5, 0x118C, 0x18FC, 0x1DE0, 0x2357, 0x2559, 0x2ADC, 0x3322,
    0x3626, 0x3624, 0x3739, 0x3BFB, 0x403C, 0x3E03, 0x357B, 0x2D8F, 0x2675, 0x2227, 0x206C, 0x20F7, 0x23F4, 0x2311, 0x1F75, 0x1A93,
    0x1822, 0x18BD, 0x1542, 0x0E42, 0x075A, 0x00E7, 0xFA59, 0xF8CF, 0xFA6B, 0xFA05, 0xF69F, 0xF616, 0xF9CC, 0xF6CE, 0xF464, 0xF7EE,
    0xFE6A, 0xFFD1, 0xFD28, 0xFC6C, 0xFC1D, 0xFE25, 0x00A3, 0x0025, 0xFFE2, 0x03BD, 0x0574, 0x0475, 0x0343, 0x0130, 0xFCC8, 0xF6C5,
    0xF1B0, 0xEF2B, 0xEB4B, 0xE6A6, 0xE29E, 0xDEF1, 0xDA87, 0xD3EE, 0xD092, 0xD26A, 0xD652, 0xDA68, 0xE0E1, 0xE50B, 0xE770, 0xE97E,
    0xE963, 0xEA39, 0xEB49, 0xEE84, 0xF498, 0xF7C1, 0xF6F8, 0xF9E2, 0x0021, 0x02FE, 0x0534, 0x0660, 0x0642, 0x0400, 0x0234, 0x0873,
    0x0F32, 0x156F, 0x1A61, 0x1E16, 0x1D9F, 0x186E, 0x160D, 0x15C8, 0x14E7, 0x10A2, 0x0F03, 0x0E13, 0x0A3F, 0x04FC, 0x040E, 0x0684,
    0x0719, 0x062D, 0x04E2, 0x08EC, 0x0DE4, 0x0F86, 0x0DD0, 0x0B16, 0x0873, 0x0978, 0x0D62, 0x0CEE, 0x08FB, 0x0246, 0xFEB6, 0xFE96,
    0xFCB2, 0xFD71, 0x029A, 0x0782, 0x081C, 0x0A22, 0x0BEF, 0x0B68, 0x0AC7, 0x06A8, 0x02B9, 0x0008, 0xFF4E, 0xFC34, 0xF527, 0xEF15,
    0xED5D, 0xEE21, 0xEB66, 0xE95D, 0xEB18, 0xEC6E, 0xED48, 0xEEEC, 0xEDCC, 0xEAD9, 0xEA7C, 0xE8BA, 0xE6B2, 0xE6B3, 0xE75C, 0xE90C,
    0xEA73, 0xECD7, 0xEF57, 0xF290, 0xF14F, 0xF209, 0xF510, 0xF752, 0xF817, 0xF7AB, 0xFA7B, 0xFA3E, 0xF873, 0xF493, 0xF1B3, 0xF392,
    0xF8EB, 0xFC75, 0xFEBE, 0x0049, 0x00F4, 0x03DF, 0x06D1, 0x09C2, 0x0CD9, 0x0DDF, 0x0D00, 0x0CFF, 0x1007, 0x123F, 0x1104, 0x0EF3,
    0x0CD5, 0x0D49, 0x0DA4, 0x0ADE, 0x0A25, 0x0E10, 0x0FD2, 0x1161, 0x1286, 0x1231, 0x116F, 0x0EDC, 0x0E75, 0x0EDE, 0x0F06, 0x0EA3,
    0x0DAC, 0x0EF0, 0x10AF, 0x11D6, 0x0F84, 0x0AD2, 0x0A78, 0x0D5B, 0x1001, 0x1221, 0x1643, 0x1C60, 0x234C, 0x268B, 0x250C, 0x207F,
    0x1B38, 0x19AC, 0x1A1D, 0x1A03, 0x178D, 0x1160, 0x09D7, 0x0358, 0xFD6A, 0xF8CD, 0xF696, 0xF492, 0xF2AD, 0xF15D, 0xF01C, 0xEC99,
    0xE488, 0xDC23, 0xD5A5, 0xCF04, 0xCC3A, 0xCDF5, 0xCE64, 0xCF7A, 0xD0E8, 0xD04D, 0xD010, 0xD024, 0xD023, 0xD1A6, 0xD2B0, 0xD356,
    0xD3F9, 0xD4A0, 0xD2D1, 0xCFF7, 0xCEEB, 0xCEF9, 0xCF1D, 0xCE84, 0xD158, 0xD6C1, 0xDD10, 0xE25B, 0xEA21, 0xF0F1, 0xF795, 0xFDAD,
    0xFE6E, 0xFFC8, 0x01DB, 0x0698, 0x0CB8, 0x11F0, 0x17F6, 0x1C4E, 0x1D14, 0x1B43, 0x187D, 0x1939, 0x19C1, 0x1C6A, 0x22FB, 0x2948,
    0x2EF7, 0x34BE, 0x398B, 0x3928, 0x3763, 0x35C1, 0x33CD, 0x2DE7, 0x26B0, 0x21EE, 0x20B6, 0x212A, 0x21D9, 0x258C, 0x260D, 0x252F,
    0x240A, 0x21D3, 0x1F63, 0x1923, 0x12E9, 0x1209, 0x1341, 0x1350, 0x1099, 0x0B32, 0x021B, 0xF97A, 0xF636, 0xF2FC, 0xEE8A, 0xEA86,
    0xE8C2, 0xE77E, 0xE73A, 0xE473, 0xDEBD, 0xD6DF, 0xCD19, 0xCA5D, 0xCC52, 0xCF92, 0xD184, 0xD365, 0xD55F, 0xD749, 0xD97A, 0xDC23,
    0xE0F4, 0xE42D, 0xE5F5, 0xE657, 0xE58D, 0xE66B, 0xE893, 0xEAEA, 0xEE19, 0xF397, 0xF888, 0xFA0E, 0xFB9A, 0x007C, 0x04D6, 0x06BE,
    0x06B0, 0x08F6, 0x0DC2, 0x1158, 0x17B4, 0x1F93, 0x24C3, 0x26EA, 0x2A29, 0x2D0E, 0x2E8F, 0x2DA9, 0x2CF3, 0x2C02, 0x28D4, 0x2547,
    0x1F84, 0x1C8B, 0x1900, 0x15B9, 0x150A, 0x1562, 0x1318, 0x0FC9, 0x0F2E, 0x0F9B, 0x10A1, 0x0E5B, 0x0C0F, 0x0783, 0x00FA, 0xFC32,
    0xF834, 0xF499, 0xEFAF, 0xEBE2, 0xEA6B, 0xE7F5, 0xE8AD, 0xEF42, 0xF67D, 0xFB06, 0xFE95, 0x0254, 0x04C8, 0x0693, 0x06BD, 0x0576,
    0x0024, 0xFA44, 0xF768, 0xF4CD, 0xF127, 0xEE3D, 0xEE6C, 0xF014, 0xF18E, 0xF186, 0xEEC3, 0xE848, 0xE1A2, 0xDCB4, 0xD98E, 0xDA66,
    0xDD9C, 0xE08B, 0xE2B4, 0xE517, 0xE75E, 0xE8DC, 0xE8FC, 0xE76C, 0xE8A3, 0xEA74, 0xEC92, 0xF1DD, 0xF5C9, 0xF9B1, 0xFCB1, 0x0075,
    0x05FD, 0x093B, 0x0BB8, 0x0CE8, 0x0B1A, 0x06D3, 0x04DB, 0x05F0, 0x0823, 0x0A26, 0x0DA2, 0x10E2, 0x1139, 0x1258, 0x130F, 0x1272,
    0x1015, 0x0E14, 0x0F8A, 0x0FDE, 0x0C50, 0x09BF, 0x07AE, 0x0524, 0x03A6, 0x034C, 0x04B1, 0x08B6, 0x0EE5, 0x1281, 0x13AB, 0x11E5,
    0x0DC0, 0x0A8F, 0x08A5, 0x0822, 0x04E3, 0x00AD, 0xFFDA, 0xFDBE, 0xFE00, 0xFFE7, 0x0156, 0x049C, 0x0611, 0x06BA, 0x0699, 0x099D,
    0x0B27, 0x0AC9, 0x09F6, 0x08B0, 0x06A2, 0x0183, 0xFC96, 0xF810, 0xF960, 0xFCA9, 0xFD3D, 0xF9C4, 0xF60D, 0xF50A, 0xF3F0, 0xF43D,
    0xF450, 0xEF95, 0xEAF3, 0xE8B1, 0xE545, 0xE0AB, 0xE025, 0xE36C, 0xE546, 0xE984, 0xF069, 0xF6D1, 0xF723, 0xF644, 0xF65E, 0xF741,
    0xF682, 0xF779, 0xFAC8, 0xFA7F, 0xF9ED, 0xFBBA, 0xFDBD, 0xFB8B, 0xFC55, 0xFF7D, 0x018F, 0x00D6, 0x0005, 0x00DE, 0x021E, 0x05A1,
    0x0C6B, 0x124D, 0x135F, 0x11CC, 0x1129, 0x1171, 0x0F67, 0x122C, 0x1701, 0x1693, 0x144E, 0x1363, 0x1398, 0x1022, 0x0C60, 0x0D6A,
    0x0FC0, 0x1049, 0x11EC, 0x1615, 0x1930, 0x184B, 0x1640, 0x1540, 0x127D, 0x0E0D, 0x0989, 0x0816, 0x06C4, 0x0494, 0x0387, 0x0399,
    0x04D3, 0x05C7, 0x0A34, 0x100A, 0x13DD, 0x17CA, 0x1CB9, 0x2201, 0x21FB, 0x1E60, 0x1AD6, 0x1683, 0x11EB, 0x0EA8, 0x0C02, 0x0726,
    0x04B1, 0x0599, 0x0919, 0x0B10, 0x0A80, 0x0AA5, 0x08CF, 0x0256, 0xF7AC, 0xEE59, 0xE4CB, 0xDACB, 0xD340, 0xD07B, 0xCFA8, 0xCBE3,
    0xC8F7, 0xC85D, 0xC84D, 0xC77F, 0xCA1C, 0xCDE3, 0xCD05, 0xCB7D, 0xCAFC, 0xCBC1, 0xCB89, 0xCE58, 0xD5FF, 0xDB8F, 0xDD45, 0xDC88,
    0xDC16, 0xDC68, 0xE087, 0xE863, 0xF02D, 0xF6AF, 0xFA4D, 0xFEE3, 0x032F, 0x079B, 0x0CBB, 0x0FBE, 0x11CB, 0x123F, 0x1396, 0x117E,
    0x0D3B, 0x099A, 0x0891, 0x0A61, 0x0C5A, 0x1169, 0x17B4, 0x1FBE, 0x26A3, 0x2C97, 0x3219, 0x3504, 0x36DD, 0x34E7, 0x3285, 0x300B,
    0x2ED8, 0x2F80, 0x2BA5, 0x265B, 0x223B, 0x20BD, 0x1E39, 0x1C0B, 0x1BF2, 0x1CCE, 0x1FCE, 0x2298, 0x236F, 0x1E71, 0x1A25, 0x1604,
    0x0F90, 0x08B2, 0x0039, 0xF899, 0xF3C9, 0xF109, 0xEC44, 0xE743, 0xE500, 0xE43B, 0xE46C, 0xE40E, 0xE1E0, 0xDE9B, 0xDAC3, 0xD796,
    0xD5DD, 0xD53B, 0xD435, 0xD312, 0xD41F, 0xD4F5, 0xD4C0, 0xD465, 0xD79B, 0xDDCE, 0xE193, 0xE329, 0xE36F, 0xE469, 0xE520, 0xE521,
    0xE690, 0xEA4C, 0xEF6A, 0xF4D8, 0xF82B, 0xF99A, 0xF8ED, 0xF77C, 0xFA44, 0xFE6B, 0x03E3, 0x0BFF, 0x14CE, 0x1D84, 0x24D1, 0x2AD0,
    0x2E46, 0x2F2F, 0x2EFB, 0x2E57, 0x2EC8, 0x2CFB, 0x2B5B, 0x2AA1, 0x2BAC, 0x2CD2, 0x2CDD, 0x2D10, 0x2A10, 0x2638, 0x20C2, 0x1A8F,
    0x1759, 0x1754, 0x160C, 0x13B4, 0x100E, 0x09A0, 0x02BC, 0xFA5F, 0xF291, 0xECF2, 0xE9B2, 0xE719, 0xE686, 0xEA3F, 0xEFB7, 0xF402,
    0xF52E, 0xF671, 0xF8BB, 0xFAF9, 0xFD4D, 0xFEB0, 0x0052, 0x00E4, 0xFEFC, 0xFC37, 0xF81B, 0xF4F0, 0xF5B6, 0xFAEF, 0xFF3A, 0xFD59,
    0xF9DF, 0xF84F, 0xF566, 0xF284, 0xEF8A, 0xEAAC, 0xE431, 0xDDB8, 0xDD73, 0xDD98, 0xDD7A, 0xE064, 0xE500, 0xE9E5, 0xEB4E, 0xEC00,
    0xED8E, 0xEF5E, 0xF227, 0xF595, 0xF7A9, 0xF735, 0xF696, 0xF72A, 0xF6B5, 0xF89D, 0xFF0F, 0x048C, 0x0511, 0x0368, 0x0435, 0x05D9,
    0x077E, 0x095A, 0x0AD3, 0x0BBE, 0x0E11, 0x1302, 0x17F1, 0x1A58, 0x181F, 0x14E7, 0x1211, 0x0F1C, 0x0C7D, 0x0AA6, 0x09EF, 0x0A62,
    0x0CF4, 0x0D16, 0x0CA2, 0x0C1F, 0x0E86, 0x107E, 0x0F00, 0x0F95, 0x0F0B, 0x1050, 0x11AC, 0x127E, 0x10D1, 0x08A9, 0x00E4, 0xFE79,
    0xFFC2, 0xFF02, 0xFD5C, 0xFCDA, 0xFF64, 0x030B, 0x0463, 0x0595, 0x05F1, 0x0595, 0x0359, 0x01B9, 0x010F, 0xFC22, 0xF92F, 0xF7FF,
    0xF818, 0xF974, 0xF89E, 0xF7B8, 0xF694, 0xF5E4, 0xF625, 0xF909, 0xF98E, 0xF7F4, 0xF5B8, 0xF363, 0xF14F, 0xEE7B, 0xED2B, 0xEABE,
    0xEB03, 0xEBCE, 0xEBAF, 0xEDDD, 0xEF7A, 0xF0BB, 0xF14E, 0xF1BB, 0xF1E5, 0xF3EA, 0xF6D0, 0xF70F, 0xF56B, 0xF2E8, 0xF0F5, 0xED9F,
    0xECE4, 0xEEB7, 0xF1DE, 0xF4E4, 0xF3FD, 0xF31E, 0xF510, 0xFAC5, 0x0253, 0x08CC, 0x0D15, 0x0ECE, 0x10A3, 0x13CD, 0x169F, 0x188F,
    0x1986, 0x1A88, 0x1B0C, 0x1A2D, 0x1799, 0x1688, 0x15A0, 0x13CF, 0x1320, 0x1387, 0x1628, 0x19D2, 0x1CC3, 0x1EF1, 0x1F30, 0x1BA1,
    0x18AE, 0x1551, 0x112C, 0x0E8C, 0x0C40, 0x09FB, 0x06B5, 0x057F, 0x08C7, 0x0C4E, 0x1089, 0x1464, 0x1978, 0x1DA9, 0x1FAB, 0x217B,
    0x1FB6, 0x1DB0, 0x1B50, 0x1A68, 0x18F8, 0x1672, 0x16A3, 0x15F9, 0x135F, 0x105F, 0x0ABA, 0x048A, 0x00B7, 0xFEC6, 0xFBCF, 0xF664,
    0xEEDB, 0xE712, 0xE0EC, 0xDB45, 0xD531, 0xD060, 0xCEBB, 0xCE78, 0xCFE6, 0xCEC8, 0xCBB5, 0xC9E9, 0xCB5B, 0xCD41, 0xCDD9, 0xCE79,
    0xCDFC, 0xCFF4, 0xD254, 0xD55D, 0xD942, 0xD991, 0xD748, 0xD57E, 0xD669, 0xD8E4, 0xDAFE, 0xDD79, 0xE181, 0xE71B, 0xEC51, 0xF22E,
    0xF71D, 0xF8E9, 0xFB15, 0xFEC7, 0x0282, 0x047B, 0x0615, 0x0761, 0x087D, 0x0A31, 0x0D90, 0x1473, 0x19D1, 0x1DB2, 0x22E4, 0x287E,
    0x2D43, 0x31D5, 0x378F, 0x3B4A, 0x3C36, 0x3C5B, 0x3F63, 0x4021, 0x3D78, 0x396B, 0x3516, 0x319C, 0x2BA0, 0x26D9, 0x251D, 0x253C,
    0x252E, 0x26C0, 0x281D, 0x2643, 0x22AD, 0x1D86, 0x18F5, 0x1371, 0x0D40, 0x0773, 0x0283, 0xFF3E, 0xFBC5, 0xF840, 0xF50B, 0xF3AD,
    0xF35D, 0xF2E5, 0xF252, 0xEF92, 0xE9DE, 0xE15C, 0xDA35, 0xD53B, 0xD28F, 0xD13C, 0xD06B, 0xCF7B, 0xCF19, 0xD21C, 0xD4D4, 0xD694,
    0xD7AA, 0xD978, 0xDB45, 0xDAB8, 0xDA44, 0xDA4C, 0xDAE2, 0xDDD4, 0xE156, 0xE401, 0xE6FC, 0xEACB, 0xEDDB, 0xF061, 0xF2E8, 0xF588,
    0xF84B, 0xFA4E, 0xFF4D, 0x0510, 0x0AB3, 0x12F0, 0x19ED, 0x1FFD, 0x25C4, 0x2ADA, 0x2D29, 0x2F3E, 0x317E, 0x3178, 0x3074, 0x2D3B,
    0x2991, 0x266E, 0x24E8, 0x2308, 0x2112, 0x2014, 0x1F99, 0x1FF2, 0x1F5A, 0x1EE4, 0x1CCA, 0x19EA, 0x1686, 0x119A, 0x0E5D, 0x0A82,
    0x0679, 0x018D, 0xFBCD, 0xF69C, 0xF213, 0xEF8F, 0xEEE6, 0xF28E, 0xF5EB, 0xF8B7, 0xFB0F, 0xFC74, 0xFD55, 0xFC0C, 0xFB16, 0xF8DE,
    0xF7E1, 0xF6E2, 0xF562, 0xF42E, 0xF42C, 0xF6C8, 0xF814, 0xF838, 0xF686, 0xF5D4, 0xF561, 0xF241, 0xED0F, 0xE71B, 0xE394, 0xDFA9,
    0xDD2B, 0xDCA5, 0xDB5F, 0xDA5A, 0xDA69, 0xDA44, 0xD984, 0xDBA4, 0xE081, 0xE485, 0xE5BA, 0xE755, 0xEB39, 0xEFD9, 0xF48A, 0xF7D1,
    0xF904, 0xF8DF, 0xF80E, 0xF8DA, 0xF969, 0xFA49, 0xFC4F, 0xFFF1, 0x0417, 0x06CF, 0x089D, 0x089A, 0x08A9, 0x0A3D, 0x0E2D, 0x0FD2,
    0x0FB7, 0x0FDE, 0x0FB3, 0x0E89, 0x0A6E, 0x07DB, 0x06ED, 0x0586, 0x037F, 0x0291, 0x0201, 0x02E4, 0x057D, 0x076A, 0x09E2, 0x0BB1,
    0x0DF3, 0x116E, 0x144B, 0x174F, 0x1899, 0x180E, 0x1335, 0x0DBC, 0x0B8C, 0x09C5, 0x0848, 0x061C, 0x05B7, 0x0638, 0x078F, 0x0AD7,
    0x0F18, 0x114B, 0x1101, 0x10A3, 0x0E84, 0x09DB, 0x04F4, 0x035A, 0x0262, 0x0152, 0x02F1, 0x04B3, 0x044D, 0x0394, 0x0338, 0x0135,
    0xFF17, 0xFCAF, 0xF8C0, 0xF580, 0xF30E, 0xF01A, 0xEB50, 0xE82A, 0xE699, 0xE598, 0xE633, 0xE62F, 0xE52E, 0xE364, 0xE362, 0xE536,
    0xE75F, 0xE91D, 0xE998, 0xE93F, 0xE7F9, 0xE8DF, 0xEA5A, 0xE916, 0xE7B5, 0xE7B1, 0xE7B1, 0xE8C8, 0xEA59, 0xEB98, 0xECD5, 0xEF12,
    0xF433, 0xFA9B, 0xFFBC, 0x0341, 0x0713, 0x0CDC, 0x138D, 0x17BA, 0x1A9D, 0x1C72, 0x1C49, 0x1C70, 0x1C01, 0x1B97, 0x19CA, 0x17A8,
    0x15E2, 0x13E4, 0x131C, 0x145F, 0x1656, 0x1570, 0x1500, 0x1657, 0x179F, 0x16CE, 0x14D3, 0x139E, 0x10AF, 0x0E1D, 0x0CB5, 0x0D69,
    0x0F5A, 0x118F, 0x156F, 0x1970, 0x1D6F, 0x2051, 0x2326, 0x259C, 0x272B, 0x2674, 0x2554, 0x23E8, 0x2179, 0x206B, 0x1E2D, 0x1C4F,
    0x1B86, 0x1C33, 0x1B35, 0x167D, 0x10B3, 0x09C0, 0x029D, 0xFBC2, 0xF5A8, 0xEF96, 0xE8EA, 0xE395, 0xE0E2, 0xE0E3, 0xE26E, 0xE40A,
    0xE3D6, 0xE25E, 0xE016, 0xDD51, 0xDA51, 0xD76D, 0xD4B2, 0xD159, 0xCEAB, 0xCBD7, 0xC950, 0xC8D0, 0xCA1C, 0xCB5F, 0xCD3E, 0xCF4C,
    0xD0AA, 0xD153, 0xD0E2, 0xD0FD, 0xD1E0, 0xD1A3, 0xD0F4, 0xD0EA, 0xD1BC, 0xD337, 0xD621, 0xD980, 0xDC9D, 0xDF29, 0xE15D, 0xE467,
    0xE8D6, 0xEFCF, 0xF7CB, 0xFEFD, 0x060B, 0x0C2A, 0x0E77, 0x1010, 0x1220, 0x16AE, 0x1EA0, 0x2715, 0x2DDD, 0x31EC, 0x32DD, 0x31E9,
    0x3004, 0x2C7C, 0x2931, 0x28D5, 0x2C32, 0x3117, 0x369D, 0x3BB9, 0x3FAC, 0x426E, 0x44D8, 0x4689, 0x46E2, 0x46BF, 0x4931, 0x4A7F,
    0x47F7, 0x4327, 0x3E44, 0x3B20, 0x35B5, 0x2E8E, 0x254D, 0x1901, 0x0D6F, 0x0360, 0xFAAC, 0xF1E8, 0xEA6A, 0xE592, 0xDEDF, 0xD8E5,
    0xD4D7, 0xD25F, 0xD044, 0xCF35, 0xD0AF, 0xD1C8, 0xD30E, 0xD397, 0xD35F, 0xD1ED, 0xCF9A, 0xCDB1, 0xCBF0, 0xCACF, 0xCA28, 0xCBDC,
    0xCF1E, 0xD173, 0xD3C3, 0xD660, 0xDACD, 0xE0EC, 0xE6E1, 0xEC9B, 0xF160, 0xF557, 0xFA2D, 0xFFA2, 0x04B4, 0x0841, 0x0DA6, 0x165C,
    0x1EAC, 0x24D0, 0x2823, 0x2961, 0x27B1, 0x2320, 0x1E81, 0x1944, 0x1605, 0x1372, 0x1344, 0x15FC, 0x1644, 0x16EA, 0x1659, 0x14C4,
    0x134A, 0x1321, 0x16D8, 0x1C12, 0x1FAB, 0x21B2, 0x22F2, 0x234C, 0x214E, 0x1B5E, 0x1309, 0x0937, 0x008C, 0xFA29, 0xF630, 0xF2A1,
    0xF01A, 0xEFB0, 0xEFE9, 0xF087, 0xF084, 0xF2C4, 0xF667, 0xFA3A, 0xFDFA, 0x0289, 0x0915, 0x0CD7, 0x0EA0, 0x1068, 0x0EC3, 0x08CD,
    0x00E5, 0xFA6F, 0xF51D, 0xEF59, 0xEA84, 0xE80C, 0xE657, 0xE55E, 0xE5CF, 0xE5FC, 0xE56B, 0xE61A, 0xE90B, 0xEC55, 0xEF6D, 0xF18A,
    0xF2BE, 0xF30C, 0xF554, 0xF903, 0xFB22, 0xFC74, 0xFA7E, 0xF7A6, 0xF43B, 0xEFAF, 0xEC3F, 0xEBAC, 0xED8D, 0xF270, 0xF89C, 0xFD49,
    0xFFE4, 0xFECC, 0xFC79, 0xFA5F, 0xFA4A, 0xFBDF, 0xFFD8, 0x05D7, 0x0C87, 0x1225, 0x14CB, 0x1733, 0x1888, 0x1909, 0x173A, 0x12AF,
    0x0D57, 0x0749, 0x03A0, 0x01DD, 0xFFFA, 0xFD49, 0xFD03, 0xFE70, 0xFEFC, 0x0083, 0x0416, 0x0ADC, 0x10BC, 0x160C, 0x1982, 0x191B,
    0x154C, 0x0F3A, 0x094C, 0x029F, 0xFC21, 0xF5EA, 0xF2CE, 0xF1E0, 0xF204, 0xF3FA, 0xF657, 0xF742, 0xF826, 0xFBAB, 0xFFF2, 0x0517,
    0x0A13, 0x0EB1, 0x1298, 0x1417, 0x1582, 0x178D, 0x1934, 0x1AC5, 0x1AEE, 0x194C, 0x15D0, 0x1128, 0x0B18, 0x02C9, 0xFA68, 0xF5BE,
    0xF4CD, 0xF559, 0xF651, 0xF72A, 0xF91D, 0xF962, 0xF6F0, 0xF365, 0xF00A, 0xECE8, 0xE990, 0xE780, 0xE733, 0xE97C, 0xEC14, 0xED24,
    0xEEDD, 0xF10C, 0xF1A8, 0xF03F, 0xEC98, 0xE832, 0xE435, 0xE13B, 0xE084, 0xE0F8, 0xE062, 0xE008, 0xE136, 0xE31B, 0xE8CF, 0xF2E2,
    0xFD46, 0x0584, 0x0C7E, 0x11D1, 0x126B, 0x0F62, 0x0B52, 0x082B, 0x0546, 0x0209, 0xFF9A, 0xFD25, 0xFB57, 0xFA42, 0xFC0C, 0xFEF6,
    0x0113, 0x0439, 0x08BC, 0x0B58, 0x0BAB, 0x0C71, 0x0C8B, 0x0BE9, 0x0ACC, 0x0E46, 0x1475, 0x1A5A, 0x210C, 0x2611, 0x28B8, 0x26E2,
    0x2226, 0x1D8A, 0x19FB, 0x186E, 0x18CB, 0x1CB7, 0x2111, 0x2568, 0x291A, 0x296C, 0x26A7, 0x21E2, 0x1DBC, 0x1A1C, 0x161C, 0x1092,
    0x0ACD, 0x067D, 0x035A, 0x002E, 0xFCC7, 0xF99C, 0xF6D8, 0xF2E7, 0xEEB6, 0xECA9, 0xE98D, 0xE6C4, 0xE4D4, 0xE24F, 0xDE50, 0xD878,
    0xD475, 0xD0E2, 0xCE88, 0xCFC9, 0xD25B, 0xD4AA, 0xD4DA, 0xD3EE, 0xD1C7, 0xCE1A, 0xC9C4, 0xC63F, 0xC2F2, 0xC1F9, 0xC358, 0xC558,
    0xC70C, 0xC9E7, 0xCDF2, 0xD2F8, 0xD81F, 0xDF9D, 0xE7D7, 0xEF18, 0xF482, 0xF65F, 0xF679, 0xF4BD, 0xF55A, 0xF674, 0xF978, 0xFFD3,
    0x0AAF, 0x0A26, 0x1DD5, 0x3A29, 0x36EA, 0x3A76, 0x3C1F, 0x3F69, 0x4219, 0x409B, 0x3EB6, 0x3BB0, 0x3EC7, 0x30E3, 0x3CCA, 0x4C41,
    0x427E, 0x37C6, 0x247D, 0x1962, 0x1592, 0x1149, 0x08DE, 0xFF3A, 0xF832, 0xF131, 0xF3FA, 0xFE7A, 0xF28D, 0xE219, 0xDE55, 0xDAF2,
    0xD67F, 0xD846, 0xD704, 0xD47D, 0xD06E, 0xCCEB, 0xD0D3, 0xCC28, 0xC997, 0xC8EC, 0xCC41, 0xD072, 0xD5F0, 0xDC35, 0xDAE3, 0xDB20,
    0xDF92, 0xE575, 0xEE13, 0xE445, 0xE2CA, 0xFF74, 0xFD30, 0xF52B, 0xFC6E, 0xFEC0, 0x0CBC, 0x0B54, 0x0907, 0xFFC3, 0xF7AE, 0xF1A5,
    0xECBA, 0xF8F1, 0xEFA1, 0xE271, 0xDAFE, 0xD93D, 0xD97C, 0xDE1A, 0xE071, 0xE5C7, 0xE91A, 0xEDEA, 0xFBFA, 0x04A3, 0x0B64, 0x0ED1,
    0x14D1, 0x1A55, 0x215E, 0x2602, 0x22BE, 0x1D33, 0x1BE7, 0x1F0A, 0x2C4A, 0x2648, 0x20B8, 0x4093, 0x44B2, 0x3AAA, 0x3692, 0x3114,
    0x380B, 0x33BA, 0x30B3, 0x23B5, 0x1B21, 0x0E40, 0x04D4, 0x0CD1, 0x02BB, 0xF01B, 0xE0E6, 0xD87F, 0xD247, 0xD46B, 0xD63F, 0xD8DB,
    0xD3E1, 0xD084, 0xD305, 0xD3CC, 0xD69B, 0xD626, 0xD67F, 0xD599, 0xD8FD, 0xDFB8, 0xDFCA, 0xE07B, 0xE370, 0xEA0E, 0xFE6C, 0xFD7A,
    0xF4BB, 0x0C45, 0x131B, 0x0D89, 0x06A3, 0xFEEC, 0x04C9, 0x079F, 0x0A51, 0xFFB1, 0xFC91, 0xF3CE, 0xEA83, 0xF40E, 0xF5F7, 0xEEDE,
    0xE816, 0xE321, 0xE23A, 0xE5DC, 0xE790, 0xEB14, 0xE73F, 0xE38B, 0xE269, 0xE279, 0xE2CA, 0xE0E4, 0xDFF8, 0xE09A, 0xE713, 0xF42A,
    0xFC73, 0x043A, 0x09A3, 0x0B0F, 0x2169, 0x2688, 0x1C77, 0x2F7B, 0x3993, 0x38DD, 0x2C21, 0x1D1B, 0x174C, 0x1476, 0x168C, 0x0EA5,
    0x1149, 0x0D65, 0x0591, 0x0C73, 0x114D, 0x06B8, 0xF63D, 0xE5BB, 0xDAD3, 0xD55C, 0xD0F2, 0xD14C, 0xCF5E, 0xCE9D, 0xD031, 0xD6CD,
    0xDF2F, 0xE5DA, 0xED47, 0xF194, 0xF3B6, 0xFA50, 0xFD6E, 0x02D6, 0x04B6, 0xFF9E, 0x14CF, 0x1E90, 0x1615, 0x2526, 0x34D6, 0x3E0B,
    0x37A7, 0x2FE0, 0x2A14, 0x28BD, 0x29E5, 0x2185, 0x2203, 0x1BB0, 0x0FA1, 0x10F9, 0x17FD, 0x1243, 0x0500, 0xF38F, 0xE532, 0xDB1B,
    0xD5D6, 0xD5DA, 0xD54C, 0xD612, 0xD89D, 0xDF18, 0xE68D, 0xEB34, 0xEFEB, 0xF2FA, 0xF5E4, 0x00ED, 0x06BB, 0x0C62, 0x0B88, 0xFF08,
    0x0EB6, 0x17C3, 0x0DB7, 0x14D0, 0x2527, 0x364F, 0x376D, 0x35CF, 0x304E, 0x2FE1, 0x3326, 0x2CA2, 0x297B, 0x201D, 0x0F69, 0x099F,
    0x0C64, 0x090C, 0x0183, 0xF8FF, 0xF586, 0xF3F5, 0xF782, 0xFE87, 0x039C, 0x01E0, 0xFD18, 0xFC95, 0xFD1F, 0xFD72, 0x00A4, 0x019C,
    0xFE7F, 0x0361, 0x049A, 0x0C52, 0x12A6, 0x097E, 0x197E, 0x2A84, 0x2C37, 0x305D, 0x3F24, 0x531A, 0x5A7A, 0x5C11, 0x52E3, 0x4F9E,
    0x4ECF, 0x4877, 0x4706, 0x450D, 0x390A, 0x31B7, 0x33D4, 0x347F, 0x2EF6, 0x21CE, 0x1536, 0x088A, 0x0104, 0xFDE7, 0xFC59, 0xF942,
    0xF39D, 0xED11, 0xE729, 0xE0D7, 0xDE21, 0xDABD, 0xD5BD, 0xDAC4, 0xDAC7, 0xE107, 0xE637, 0xD8C0, 0xDEDB, 0xEA31, 0xE9DC, 0xE3F5,
    0xE680, 0xF0EE, 0xF46B, 0xF3E7, 0xEA0B, 0xE9BD, 0xF087, 0xF274, 0xF821, 0xFF28, 0xFB1E, 0xF75F, 0xFBCB, 0x02BB, 0x04A3, 0xFF3F,
    0xF934, 0xF27F, 0xEE15, 0xED17, 0xEDD7, 0xEC1B, 0xE6C4, 0xE3B5, 0xE525, 0xE721, 0xEF11, 0xF7CF, 0xFF5A, 0x0E70, 0x1731, 0x2A4A,
    0x3DD5, 0x38F7, 0x3BDA, 0x4581, 0x4711, 0x3E09, 0x3D24, 0x4657, 0x4EB6, 0x52FA, 0x4BF8, 0x460D, 0x44AF, 0x3FD5, 0x3DA0, 0x4077,
    0x3AD4, 0x3315, 0x31D1, 0x361B, 0x3684, 0x2F14, 0x228D, 0x124F, 0x0340, 0xF9A3, 0xF719, 0xF62B, 0xF23F, 0xEEAB, 0xEB7C, 0xE4D9,
    0xE3C8, 0xE26D, 0xDDB1, 0xDE74, 0xD653, 0xD892, 0xDF86, 0xD50A, 0xCE74, 0xD3BA, 0xDB23, 0xD779, 0xD9BF, 0xE384, 0xF0E8, 0xFD4A,
    0xFD7F, 0xFB22, 0xFD22, 0xFC58, 0xFC9F, 0x0046, 0xFBF0, 0xF2B3, 0xEBC0, 0xED00, 0xEE6C, 0xEC0D, 0xE5CF, 0xDDFA, 0xD8B8, 0xD7F7,
    0xDF4E, 0xE895, 0xEE9A, 0xF508, 0xFE4C, 0x04D4, 0x0E58, 0x1436, 0x133C, 0x180A, 0x1389, 0x18B1, 0x2532, 0x22A7, 0x1C8E, 0x2086,
    0x2986, 0x25C1, 0x24B6, 0x2B03, 0x3813, 0x4550, 0x463A, 0x4118, 0x3DE7, 0x356C, 0x2A6A, 0x2512, 0x1CA9, 0x0E7E, 0x0215, 0x0043,
    0x0420, 0x04B1, 0xFF13, 0xF3F3, 0xE7BB, 0xDC40, 0xD56D, 0xD361, 0xCE45, 0xC9FE, 0xC90B, 0xC59A, 0xC86C, 0xCADA, 0xCE9B, 0xDA96,
    0xDBB8, 0xE299, 0xF1A0, 0xF7DE, 0xF34B, 0xF58C, 0x00F0, 0x01DF, 0xFF4F, 0x005E, 0x0874, 0x156E, 0x1830, 0x1277, 0x0DF3, 0x0498,
    0xFBA4, 0xFA80, 0xFC19, 0xF69A, 0xEEDA, 0xEDA8, 0xF3C7, 0xFAD5, 0xFCB9, 0xF948, 0xEFF5, 0xE4E3, 0xDCB4, 0xDB72, 0xD9F5, 0xD824,
    0xD888, 0xD314, 0xD681, 0xD7AB, 0xD5C5, 0xDC45, 0xDABC, 0xDE71, 0xEE10, 0xFC2E, 0xFCD5, 0x00C0, 0x0C76, 0x114F, 0x0FB8, 0x0C47,
    0x0E84, 0x1976, 0x1FB4, 0x1D9C, 0x1E2C, 0x1D46, 0x1A5A, 0x1A7C, 0x1F51, 0x1D23, 0x1543, 0x1012, 0x101B, 0x118E, 0x0B60, 0xFF8A,
    0xF154, 0xE33F, 0xD9F8, 0xDABC, 0xDC3E, 0xDD67, 0xE268, 0xE18C, 0xE70E, 0xE906, 0xE900, 0xF151, 0xF149, 0xEF93, 0xF95F, 0x06D4,
    0x043C, 0x00AC, 0x06C7, 0x0B2F, 0x098C, 0x0502, 0x0542, 0x12CE, 0x20BC, 0x2666, 0x2C04, 0x2E67, 0x2B42, 0x294D, 0x2CC3, 0x2A9A,
    0x1FE4, 0x148F, 0x0E3C, 0x0D0B, 0x0A85, 0x02A7, 0xF752, 0xE7FA, 0xD916, 0xD334, 0xCF2E, 0xCF96, 0xD452, 0xD2B6, 0xD71C, 0xD89E,
    0xD6C8, 0xDA7E, 0xD89E, 0xD2B6, 0xD562, 0xE0AB, 0xE0D2, 0xDDFB, 0xE34E, 0xE9A4, 0xEE81, 0xEECC, 0xF091, 0xFF3C, 0x108C, 0x1A19,
    0x1EDD, 0x1F6D, 0x18F6, 0x126D, 0x1348, 0x149D, 0x0FEB, 0x08DF, 0x064F, 0x08E6, 0x0E22, 0x0FF5, 0x0DA4, 0x0576, 0xFB36, 0xFB41,
    0xFC12, 0xFF79, 0x0423, 0x00A3, 0x014D, 0xFD81, 0xF724, 0xF61A, 0xF12A, 0xE475, 0xE01F, 0xECA3, 0xF414, 0xF74A, 0x017D, 0x0E8A,
    0x1A89, 0x1E5F, 0x1D16, 0x24AE, 0x3247, 0x3AFD, 0x3F67, 0x429E, 0x4092, 0x3BD4, 0x3982, 0x3649, 0x2E4D, 0x21B5, 0x16F7, 0x13D2,
    0x15B0, 0x1601, 0x140D, 0x0ACA, 0xF984, 0xEF4E, 0xE6C2, 0xE287, 0xDF97, 0xD713, 0xD396, 0xCE63, 0xC727, 0xC620, 0xC757, 0xC0BF,
    0xBE48, 0xC904, 0xCFD8, 0xCC6D, 0xC9F3, 0xC9FB, 0xCC3E, 0xC9E7, 0xC342, 0xC65F, 0xD1B8, 0xDC9C, 0xE3B1, 0xE9E7, 0xEA92, 0xE6F5,
    0xE823, 0xEBB2, 0xED5E, 0xEBB3, 0xEA81, 0xEE6B, 0xF71D, 0xFE4B, 0x042B, 0x021D, 0xF484, 0xE9FF, 0xDD9C, 0xD7AC, 0xD691, 0xD3BB,
    0xD6A6, 0xDBCF, 0xE1AE, 0xEC0D, 0xFBCF, 0x0094, 0x022C, 0x1084, 0x1FA6, 0x255E, 0x2822, 0x2C03, 0x3342, 0x369D, 0x2F9A, 0x2BBA,
    0x3202, 0x3A97, 0x401D, 0x456C, 0x46A4, 0x3F19, 0x36D8, 0x3378, 0x2FEB, 0x286C, 0x1F74, 0x1C87, 0x22C5, 0x2859, 0x2BCA, 0x2648,
    0x1834, 0x0CC3, 0xFED2, 0xF86E, 0xF589, 0xEE76, 0xE90B, 0xE4C7, 0xDD1D, 0xD5F5, 0xD543, 0xCCE3, 0xC012, 0xBF61, 0xC45A, 0xC68E,
    0xC708, 0xC852, 0xCF82, 0xD4FD, 0xD341, 0xD1DF, 0xDA5E, 0xE726, 0xF180, 0xFC4E, 0x02AB, 0x0308, 0x0209, 0x04C3, 0x0781, 0x0294,
    0xF64C, 0xEB56, 0xE842, 0xE79C, 0xEDCA, 0xF33B, 0xF296, 0xF293, 0xEE36, 0xECF1, 0xF08D, 0xF315, 0xF752, 0xFF8F, 0x0322, 0x0577,
    0x0EC5, 0x119F, 0x07B5, 0x044B, 0x08F3, 0x0C57, 0x0E42, 0x0F4C, 0x1846, 0x2419, 0x2851, 0x2683, 0x295B, 0x319B, 0x37C3, 0x3F31,
    0x4339, 0x4061, 0x3828, 0x3040, 0x2C03, 0x26CF, 0x1C0A, 0x1107, 0x0D86, 0x0C0C, 0x102B, 0x0F21, 0x05FF, 0xF9BE, 0xE7E0, 0xD94C,
    0xD183, 0xCB42, 0xC60A, 0xC804, 0xC7EE, 0xC70E, 0xD01C, 0xD812, 0xD699, 0xD613, 0xDC8D, 0xE55A, 0xEB43, 0xEE88, 0xF67B, 0x0438,
    0x0A84, 0x058D, 0x02D9, 0x05A5, 0x0689, 0x06C8, 0x07C0, 0x0695, 0x02D4, 0x0199, 0x05E1, 0x0CEF, 0x0CEF, 0x08FA, 0x0851, 0x0815,
    0x11AA, 0x1A9A, 0x1BB2, 0x169C, 0x0A4F, 0xFCBA, 0xF290, 0xEAB0, 0xE38F, 0xE2F7, 0xE1F7, 0xDDE3, 0xE261, 0xE939, 0xE607, 0xE25F,
    0xE67F, 0xF130, 0xFA7F, 0xFE32, 0x0190, 0x0A07, 0x0F5F, 0x0945, 0x018C, 0xFFD1, 0x031A, 0x09A8, 0x123E, 0x17ED, 0x1889, 0x167A,
    0x1533, 0x1657, 0x1140, 0x081A, 0x008F, 0xF8C2, 0xF8BF, 0xFBAD, 0xFB8A, 0xFA39, 0xF2EC, 0xE98A, 0xE5FC, 0xE3CE, 0xE08E, 0xE3F9,
    0xEA7F, 0xEBAB, 0xF3F3, 0x006D, 0x0272, 0xFE53, 0xFC18, 0xFF43, 0x014F, 0xFE69, 0xFBD5, 0x027D, 0x0D22, 0x0F91, 0x0F9A, 0x13B9,
    0x1AFB, 0x2581, 0x329D, 0x3C0F, 0x3F37, 0x3FB8, 0x411E, 0x459F, 0x4182, 0x3629, 0x28B2, 0x184B, 0x0FAA, 0x0D26, 0x0C3F, 0x0931,
    0xFF87, 0xF10A, 0xE6E6, 0xE0C0, 0xD98F, 0xD877, 0xD999, 0xD4EF, 0xD32D, 0xD799, 0xD75D, 0xD0F9, 0xCB3E, 0xCB86, 0xD041, 0xD1FA,
    0xD120, 0xD704, 0xE239, 0xE4AE, 0xDFBD, 0xDD50, 0xDF03, 0xE535, 0xEF1E, 0xF84D, 0xFCFD, 0xFD06, 0xFE4C, 0x04D7, 0x078B, 0x0544,
    0x00B6, 0xFA9B, 0xFA08, 0xFF53, 0x06EA, 0x0E4B, 0x1185, 0x0EE8, 0x0D0D, 0x0D45, 0x072C, 0x0203, 0xFF53, 0xF5B3, 0xEEFB, 0xF257,
    0xF64D, 0xF35C, 0xEFF8, 0xF320, 0xFD19, 0x0679, 0x0ACD, 0x146D, 0x247C, 0x304A, 0x3514, 0x37BB, 0x39FB, 0x3BA0, 0x4185, 0x4784,
    0x4BA0, 0x4B41, 0x477D, 0x48FF, 0x48B0, 0x4545, 0x3E8A, 0x33D9, 0x2B5C, 0x2743, 0x259B, 0x245E, 0x1F20, 0x1163, 0x01CC, 0xF63E,
    0xE7B5, 0xDC8C, 0xD8E1, 0xD225, 0xCBFA, 0xCBA8, 0xCD9A, 0xC994, 0xC0E1, 0xBB89, 0xBB70, 0xBB48, 0xB586, 0xB28C, 0xB754, 0xBBA2,
    0xBB83, 0xBAC3, 0xBC4C, 0xBFDD, 0xC7AD, 0xD1D8, 0xDC79, 0xE27B, 0xE5B3, 0xEE37, 0xF6FB, 0xFE2A, 0x014E, 0xFE6D, 0xFA37, 0xF8B8,
    0xF960, 0xFCEB, 0xFF31, 0xF948, 0xF0AE, 0xEB25, 0xE35E, 0xDD14, 0xDFA7, 0xE220, 0xE47B, 0xEE97, 0xFDCD, 0x0924, 0x0DCD, 0x103A,
    0x1602, 0x1DEB, 0x1F8D, 0x1F2D, 0x2590, 0x2DF1, 0x30D0, 0x3075, 0x3049, 0x3211, 0x3792, 0x3E20, 0x4761, 0x4BE1, 0x4A68, 0x4A52,
    0x4A40, 0x493D, 0x458C, 0x3CB9, 0x329D, 0x2CA1, 0x2A09, 0x2A9C, 0x2D39, 0x27EB, 0x1D17, 0x147C, 0x079E, 0xF95D, 0xF068, 0xE79B,
    0xDAA7, 0xD22F, 0xD23E, 0xD2D6, 0xCE26, 0xC5D9, 0xC215, 0xC48F, 0xC417, 0xC04B, 0xC296, 0xCAFA, 0xD25D, 0xD913, 0xDD7C, 0xE17F,
    0xE802, 0xEF3B, 0xFA22, 0x0015, 0xFEE3, 0xFD1B, 0xFD3E, 0xFEF4, 0xFF11, 0xF9D3, 0xF0ED, 0xEA11, 0xE71A, 0xE9F9, 0xF37F, 0xFA87,
    0xFCC5, 0x000A, 0xFEEB, 0xFBD9, 0xFD88, 0x010B, 0xFFF3, 0xFE16, 0x033B, 0x0971, 0x0B13, 0x05AF, 0x017D, 0x0626, 0x0998, 0x093F,
    0x0D6D, 0x19EF, 0x248B, 0x2AC3, 0x2D4E, 0x2D58, 0x2E5A, 0x2FE0, 0x36ED, 0x3CA9, 0x3B36, 0x3811, 0x3605, 0x36B6, 0x37F9, 0x33CE,
    0x2A0A, 0x1E27, 0x1285, 0x08EE, 0x0578, 0xFE92, 0xF1B7, 0xE8A5, 0xDF66, 0xD479, 0xD009, 0xCFA6, 0xCBC0, 0xC759, 0xC8B0, 0xD0B1,
    0xD8E9, 0xDD2C, 0xE035, 0xE899, 0xF07D, 0xF121, 0xF1F9, 0xF6D0, 0xFC02, 0xFECD, 0xFE60, 0xFC15, 0xFA0D, 0xFA7C, 0xFFFF, 0x06A4,
    0x08D8, 0x0A0F, 0x0DE1, 0x1439, 0x1DA1, 0x22FF, 0x20EA, 0x1BBE, 0x1501, 0x105E, 0x13A2, 0x16C8, 0x1453, 0x1116, 0x07E8, 0xF8BB,
    0xED7B, 0xE861, 0xE1E1, 0xD9BA, 0xD710, 0xDB0F, 0xE10E, 0xE18B, 0xDE89, 0xE0A7, 0xE615, 0xE7B0, 0xE8C8, 0xEEDF, 0xF775, 0x00B8,
    0x05DE, 0x072D, 0x07C0, 0x0679, 0x0950, 0x0F77, 0x116C, 0x0F0D, 0x0B2E, 0x0962, 0x0BFC, 0x0E7D, 0x0AB1, 0x045E, 0xFDC3, 0xF664,
    0xF5B3, 0xF7EF, 0xF7BC, 0xF905, 0xF9F9, 0xF6D1, 0xF529, 0xF867, 0xF92B, 0xF6CF, 0xF421, 0xF519, 0xFA77, 0xFB1C, 0xF659, 0xF396,
    0xF6B8, 0xF638, 0xF33D, 0xF58A, 0xFCC6, 0x0832, 0x1128, 0x191B, 0x202E, 0x2620, 0x2F5B, 0x3B90, 0x44A5, 0x47AF, 0x47A3, 0x4621,
    0x4627, 0x45D2, 0x401B, 0x370A, 0x2B3C, 0x1DCD, 0x18B7, 0x1A02, 0x1760, 0x1300, 0x0C6F, 0x0016, 0xF2A6, 0xE9E2, 0xE2C6, 0xD965,
    0xD145, 0xCF04, 0xD341, 0xD55D, 0xD0DA, 0xCE4A, 0xD224, 0xD36F, 0xCFFF, 0xCD72, 0xCD03, 0xCE09, 0xCDCB, 0xCD73, 0xCDE7, 0xCD56,
    0xD170, 0xDADB, 0xE414, 0xEA4A, 0xED3D, 0xEFF9, 0xF55C, 0xFF76, 0x084E, 0x0E2B, 0x1007, 0x0D4F, 0x0F91, 0x1643, 0x1B14, 0x1F36,
    0x245A, 0x2213, 0x19FB, 0x1515, 0x1165, 0x0A06, 0xFE48, 0xF680, 0xF878, 0xFD5D, 0xFCA5, 0xFC67, 0x048E, 0x0D7F, 0x138D, 0x1772,
    0x1C99, 0x24BE, 0x2B36, 0x2FC2, 0x31D8, 0x303F, 0x2FB3, 0x33FF, 0x3ABD, 0x40C3, 0x44AD, 0x4567, 0x468A, 0x4A66, 0x4C1A, 0x4A3B,
    0x449F, 0x39AD, 0x3049, 0x2C58, 0x282C, 0x2361, 0x2013, 0x17C2, 0x0A3F, 0xFFB8, 0xF90F, 0xF11F, 0xE4FF, 0xD843, 0xD0C2, 0xCE00,
    0xC78B, 0xBF88, 0xBC62, 0xBBA9, 0xBAE0, 0xB84F, 0xB628, 0xB728, 0xB857, 0xBA18, 0xBCEA, 0xBEEF, 0xC224, 0xC8FF, 0xD3AF, 0xDE5F,
    0xE63A, 0xE9B5, 0xED8C, 0xF5F4, 0xFD45, 0x0283, 0x0593, 0x010D, 0xFA50, 0xF81A, 0xF749, 0xF560, 0xF54A, 0xF40F, 0xED40, 0xE8ED,
    0xE8F1, 0xEC36, 0xEE4B, 0xEC39, 0xEFE6, 0xFB3C, 0x04F3, 0x084C, 0x0BE7, 0x112F, 0x1463, 0x13AF, 0x1412, 0x1A7B, 0x2203, 0x291D,
    0x3019, 0x3376, 0x3341, 0x357D, 0x3AD9, 0x40C3, 0x453B, 0x4516, 0x43F0, 0x4495, 0x4526, 0x46B3, 0x47B3, 0x4257, 0x39F4, 0x35CA,
    0x328A, 0x2CD3, 0x27A8, 0x208A, 0x1337, 0x0431, 0xF99F, 0xF3A8, 0xECF5, 0xE0C1, 0xD573, 0xD19D, 0xCED0, 0xC90C, 0xC54E, 0xC727,
    0xCBB6, 0xCE5A, 0xD017, 0xD5EC, 0xDD57, 0xE35E, 0xE9B4, 0xEDE2, 0xEE69, 0xEF0F, 0xF3A7, 0xFAE6, 0x0022, 0xFF39, 0xFC72, 0xFCFF,
    0xFDF7, 0x0092, 0x04D4, 0x030D, 0xFBEE, 0xF8D5, 0xFA9F, 0xFD69, 0x039F, 0x0B9B, 0x0E5E, 0x0AAC, 0x06D4, 0x06D1, 0x05CD, 0xFF77,
    0xF9E0, 0xFE3B, 0x0436, 0x0511, 0x0449, 0x05BB, 0x097C, 0x09B9, 0x0843, 0x08EA, 0x0B9B, 0x0E94, 0x12DE, 0x1679, 0x1630, 0x1812,
    0x1E69, 0x2822, 0x3317, 0x379E, 0x35AF, 0x3325, 0x2FC9, 0x2D98, 0x2C5C, 0x26B2, 0x1A22, 0x0E53, 0x0665, 0xFCBD, 0xF612, 0xF112,
    0xE978, 0xDF2F, 0xD65F, 0xD3BA, 0xD4F3, 0xD404, 0xD0AD, 0xD341, 0xDAFB, 0xE07D, 0xE325, 0xE6D6, 0xEDE9, 0xF3ED, 0xF3F7, 0xF255,
    0xF209, 0xF256, 0xF39E, 0xF5F4, 0xF67D, 0xF5BB, 0xF6FA, 0xFBD2, 0x052B, 0x0E79, 0x14D8, 0x1CEF, 0x2515, 0x2AE3, 0x31BF, 0x34B5,
    0x2EC6, 0x26FB, 0x21A7, 0x1CE8, 0x1ACA, 0x1CB2, 0x1D21, 0x1761, 0x0EF1, 0x0801, 0x040B, 0xFD45, 0xF013, 0xE69F, 0xE33B, 0xDF9B,
    0xDA13, 0xD553, 0xD6AF, 0xDBDC, 0xE0B0, 0xE553, 0xEA5A, 0xEF8D, 0xF382, 0xF4FF, 0xF1B3, 0xED14, 0xE9C2, 0xE9B1, 0xF047, 0xF6D4,
    0xF88B, 0xF791, 0xF593, 0xF329, 0xF4BC, 0xF857, 0xF673, 0xF277, 0xF020, 0xEFC6, 0xF2B2, 0xF99D, 0x009A, 0x03B0, 0x02E3, 0x0191,
    0x048E, 0x054D, 0xFDE4, 0xF625, 0xF515, 0xF5FE, 0xF3CF, 0xF07A, 0xEFD8, 0xF212, 0xF387, 0xF539, 0xF975, 0xFF07, 0x083E, 0x1596,
    0x2180, 0x29A6, 0x2E5A, 0x320B, 0x38A9, 0x3EEE, 0x4064, 0x3F8F, 0x3F7F, 0x3E8A, 0x3FDB, 0x42FB, 0x4012, 0x39F2, 0x3306, 0x2A9D,
    0x21DB, 0x1B38, 0x16D7, 0x0E64, 0x016C, 0xF426, 0xEDAD, 0xEB40, 0xE459, 0xDD97, 0xDBF9, 0xDC95, 0xD9A0, 0xD278, 0xCD1E, 0xCB6E,
    0xC9C5, 0xC79D, 0xC558, 0xC310, 0xC24A, 0xC378, 0xC44A, 0xC354, 0xC212, 0xC2A5, 0xC942, 0xD46D, 0xDDF7, 0xE5D3, 0xED3C, 0xF2C9,
    0xFABB, 0x0716, 0x10BA, 0x135C, 0x1368, 0x1363, 0x138A, 0x15CE, 0x1949, 0x1B1C, 0x179A, 0x0ED5, 0x0924, 0x07DE, 0x01D1, 0xF95C,
    0xF642, 0xFA68, 0xFF6C, 0x00DF, 0x03AD, 0x09C5, 0x0FFB, 0x137E, 0x16B5, 0x18CF, 0x1BBD, 0x2200, 0x26ED, 0x2973, 0x29FA, 0x29D5,
    0x2EB0, 0x381C, 0x4110, 0x4667, 0x48E5, 0x4764, 0x448E, 0x45D1, 0x44ED, 0x3F63, 0x3A0E, 0x35AE, 0x30DA, 0x2CF8, 0x2A51, 0x274F,
    0x2031, 0x122C, 0x04A1, 0xFB7E, 0xF0EF, 0xE283, 0xD698, 0xD016, 0xCAD2, 0xC1F5, 0xB8CB, 0xB407, 0xB0BC, 0xADC6, 0xABE1, 0xABF8,
    0xADC3, 0xB241, 0xB8D9, 0xBFB4, 0xC5B0, 0xC9B4, 0xCFE7, 0xDA77, 0xE392, 0xE95C, 0xEF3C, 0xF1CE, 0xF4AD, 0xFB04, 0x017A, 0x03E6,
    0x026D, 0x0143, 0xFE95, 0xFC87, 0xFD90, 0x018D, 0x0503, 0x01A2, 0xFDF0, 0xFF6C, 0x0086, 0xFDEE, 0xF947, 0xF97A, 0xFC6B, 0xFD6F,
    0xFD6E, 0xFF5A, 0x0424, 0x08B2, 0x0E45, 0x131D, 0x16DC, 0x1D38, 0x22DB, 0x26B4, 0x26DD, 0x21AC, 0x1E79, 0x21BC, 0x29AF, 0x3141,
    0x383C, 0x3B25, 0x3A8D, 0x3D6E, 0x40A9, 0x408B, 0x3D03, 0x37AD, 0x31AD, 0x2BC7, 0x26C8, 0x23FC, 0x1F81, 0x1373, 0x03ED, 0xF7AC,
    0xED93, 0xE142, 0xD467, 0xCC74, 0xCB2E, 0xCA8E, 0xC8C6, 0xC8D2, 0xCBDF, 0xCFFD, 0xD435, 0xD7A8, 0xD8CD, 0xDB23, 0xDDB1, 0xE0EA,
    0xE37A, 0xE1B3, 0xDF7A, 0xE180, 0xE5F3, 0xEA62, 0xEFC2, 0xF3C9, 0xF4AA, 0xF90B, 0x033A, 0x0AF4, 0x0DA0, 0x0CE1, 0x0B9C, 0x0A38,
    0x0986, 0x0CE0, 0x1265, 0x12C9, 0x0DED, 0x0C67, 0x0F23, 0x102B, 0x0E1D, 0x0DDD, 0x1136, 0x1357, 0x106D, 0x0C67, 0x0898, 0x0455,
    0x01F7, 0x0079, 0xFFF4, 0x0308, 0x095D, 0x1160, 0x1734, 0x17BA, 0x1556, 0x1548, 0x1834, 0x1CB8, 0x23D7, 0x2837, 0x274C, 0x2444,
    0x230E, 0x1FE1, 0x17EC, 0x0E35, 0x0223, 0xF646, 0xEB4D, 0xE5B1, 0xE5CC, 0xE3AB, 0xDC7A, 0xD67A, 0xD709, 0xD844, 0xD78C, 0xD68A,
    0xDA20, 0xDFA1, 0xE166, 0xE14D, 0xE0BC, 0xE101, 0xE2D3, 0xE3E7, 0xE351, 0xE334, 0xE4ED, 0xE967, 0xEF72, 0xF3BF, 0xF45E, 0xF6B1,
    0xFDB2, 0x06E5, 0x124F, 0x1C6F, 0x213B, 0x24C1, 0x2A01, 0x2F0A, 0x314D, 0x2FD3, 0x2C7B, 0x28BB, 0x2613, 0x26E4, 0x2D00, 0x3035,
    0x2A39, 0x202D, 0x16E0, 0x0DE5, 0x0149, 0xF377, 0xEBCD, 0xE9DF, 0xE804, 0xE67F, 0xE4EA, 0xE318, 0xE265, 0xE2F8, 0xE43A, 0xE58E,
    0xE796, 0xEAE9, 0xEFF0, 0xF17B, 0xECA8, 0xE7B0, 0xE599, 0xE447, 0xE595, 0xE963, 0xEA16, 0xE86D, 0xE974, 0xEDC8, 0xF24D, 0xF541,
    0xF67E, 0xF7BC, 0xF7BB, 0xF91D, 0x00DA, 0x08F3, 0x0A64, 0x0679, 0x048C, 0x03D9, 0xFE8B, 0xF512, 0xECCD, 0xE943, 0xE5F2, 0xE2B1,
    0xE172, 0xE202, 0xE62E, 0xEC8B, 0xF269, 0xF823, 0xFE96, 0x0799, 0x1452, 0x1FC4, 0x249D, 0x25A8, 0x2724, 0x2A22, 0x3180, 0x3CA6,
    0x44CD, 0x48D0, 0x4C6A, 0x4FE8, 0x5218, 0x5056, 0x4AB3, 0x422A, 0x36D5, 0x2C56, 0x276E, 0x2757, 0x2344, 0x18FC, 0x0ED5, 0x0730,
    0xFF1B, 0xF3BA, 0xE9B8, 0xE4AF, 0xE122, 0xDDCE, 0xD922, 0xD2DD, 0xCC36, 0xC5E6, 0xC005, 0xB917, 0xB476, 0xB28E, 0xB2E7, 0xB5CD,
    0xB71F, 0xB884, 0xBBF6, 0xC0D5, 0xCABD, 0xD85D, 0xE605, 0xF009, 0xF853, 0x025F, 0x0C3A, 0x13F3, 0x1830, 0x1A69, 0x1832, 0x1383,
    0x1316, 0x1795, 0x1A59, 0x173B, 0x1288, 0x1172, 0x1227, 0x10A5, 0x0DBA, 0x0CB7, 0x0E5C, 0x10BB, 0x1215, 0x1065, 0x0E9F, 0x0F32,
    0x102B, 0x1011, 0x108E, 0x1210, 0x1869, 0x22FF, 0x2A62, 0x2D09, 0x2CCD, 0x2BF9, 0x2C15, 0x3143, 0x36BB, 0x3915, 0x3A7C, 0x3BCF,
    0x3EFB, 0x40C2, 0x3EB6, 0x3A57, 0x33BA, 0x2B31, 0x258D, 0x2564, 0x26A4, 0x2297, 0x185F, 0x0EE9, 0x070E, 0xFAE0, 0xEAF0, 0xDD79,
    0xD261, 0xC7F7, 0xBE9D, 0xB6E0, 0xB1F8, 0xAF03, 0xAE19, 0xAF0C, 0xB141, 0xB3D9, 0xB837, 0xBFE6, 0xC7F6, 0xCDA3, 0xD25B, 0xD540,
    0xD775, 0xDC0B, 0xE1ED, 0xE5A9, 0xE6BB, 0xE95F, 0xEE99, 0xF461, 0xF996, 0xFDF7, 0x003E, 0xFD88, 0xFB17, 0xFF10, 0x065F, 0x0B4D,
    0x0AB0, 0x0964, 0x09BF, 0x0711, 0x0133, 0xFC23, 0xFB40, 0xFE0A, 0x031A, 0x08C1, 0x0D6A, 0x11F6, 0x1548, 0x15EE, 0x160B, 0x14AB,
    0x156E, 0x1C1C, 0x2308, 0x26DD, 0x27E1, 0x269D, 0x2357, 0x238A, 0x286A, 0x2CC4, 0x306B, 0x327C, 0x3641, 0x3A23, 0x3B2B, 0x3AA2,
    0x36F2, 0x2F58, 0x24D2, 0x1CF9, 0x19BC, 0x156E, 0x0BD9, 0x0102, 0xF926, 0xF14B, 0xE731, 0xDD87, 0xD6F4, 0xD2E2, 0xD162, 0xD0A4,
    0xD0FA, 0xD39A, 0xD6FA, 0xDAE0, 0xDD97, 0xDE11, 0xDD79, 0xDF39, 0xE219, 0xE2D5, 0xE2EB, 0xE177, 0xDEF2, 0xDFCB, 0xE68A, 0xEF22,
    0xF705, 0xFE0C, 0x068C, 0x101A, 0x16A1, 0x1A96, 0x1C6D, 0x19C2, 0x1219, 0x0C44, 0x0E1F, 0x140B, 0x17DE, 0x18EF, 0x1C09, 0x1F2D,
    0x1C1B, 0x154E, 0x0EB0, 0x0B17, 0x0922, 0x06E3, 0x0520, 0x03BA, 0x01D8, 0xFF7D, 0xFE62, 0xFCDF, 0xFB37, 0xFE08, 0x0573, 0x0C16,
    0x1015, 0x11BD, 0x107D, 0x0F8E, 0x1184, 0x1615, 0x19EB, 0x1994, 0x17CA, 0x17BA, 0x1715, 0x13F4, 0x0F91, 0x0873, 0xFC76, 0xF163,
    0xEDA7, 0xEF15, 0xEE99, 0xEB24, 0xEA76, 0xEDC0, 0xEEED, 0xEBCC, 0xE7AD, 0xE376, 0xE0F4, 0xDFAF, 0xDE0B, 0xDC9A, 0xDAE0, 0xD9C3,
    0xDA30, 0xDA49, 0xD8F1, 0xD981, 0xE03A, 0xE926, 0xF2FB, 0xFB91, 0xFE72, 0xFF1F, 0x019A, 0x07D3, 0x0EDA, 0x1388, 0x1891, 0x20AB,
    0x2A85, 0x3356, 0x3A71, 0x3DD3, 0x39BC, 0x3176, 0x2CB3, 0x2D1A, 0x2D70, 0x28F7, 0x2373, 0x1ED5, 0x1752, 0x0C58, 0xFF1C, 0xF33E,
    0xEC08, 0xE80B, 0xE4F9, 0xE21C, 0xE077, 0xE022, 0xE05A, 0xE01C, 0xDD17, 0xDBD3, 0xDD5A, 0xDE8A, 0xE043, 0xDFBA, 0xDBA5, 0xD57F,
    0xD17E, 0xD247, 0xD62D, 0xD95E, 0xDC49, 0xE1A2, 0xE8FF, 0xF165, 0xFA9C, 0x0395, 0x0730, 0x0649, 0x05A8, 0x093C, 0x0D49, 0x0C19,
    0x0946, 0x06D4, 0x03C0, 0xFD56, 0xF43F, 0xEB45, 0xE5CE, 0xE56F, 0xE699, 0xE8CB, 0xEBAE, 0xEF47, 0xF3FC, 0xF74F, 0xF70B, 0xF62C,
    0xF960, 0x002C, 0x09A7, 0x14B8, 0x1D31, 0x21BB, 0x251F, 0x2A24, 0x3140, 0x36E0, 0x3A53, 0x3E99, 0x4322, 0x4669, 0x491A, 0x49AB,
    0x44C0, 0x39A4, 0x2D01, 0x2473, 0x1F75, 0x193B, 0x11BA, 0x0C13, 0x0750, 0x015F, 0xF907, 0xEF36, 0xE6DA, 0xE030, 0xDAF6, 0xD497,
    0xCD00, 0xC56A, 0xBEE9, 0xBA77, 0xB480, 0xAF38, 0xACE5, 0xAC9D, 0xAFC3, 0xB4D6, 0xBA6C, 0xBE48, 0xC29D, 0xCBDF, 0xD8CE, 0xE4C6,
    0xED26, 0xF4AE, 0xFC05, 0x014A, 0x0690, 0x0C2C, 0x0EB0, 0x0B4D, 0x046B, 0x022B, 0x04FF, 0x06A4, 0x0785, 0x0982, 0x0D78, 0x10C6,
    0x10A0, 0x0E44, 0x092E, 0x04D3, 0x0258, 0x01D5, 0x0382, 0x058D, 0x099F, 0x0EA1, 0x107B, 0x0F2A, 0x0EB4, 0x116D, 0x177F, 0x1F89,
    0x252C, 0x266F, 0x25F5, 0x2729, 0x2ABD, 0x2FE2, 0x3399, 0x3518, 0x36A9, 0x3805, 0x3980, 0x3BEC, 0x3D11, 0x39C5, 0x3062, 0x274E,
    0x2372, 0x209E, 0x1AA9, 0x126E, 0x0AB5, 0x025B, 0xF6CE, 0xE7A1, 0xD7B8, 0xCAA9, 0xC00A, 0xB8B1, 0xB419, 0xAF9F, 0xAD4E, 0xAF01,
    0xB214, 0xB403, 0xB61D, 0xB997, 0xBE61, 0xC4B9, 0xCB88, 0xCF50, 0xCEEF, 0xCD73, 0xCDFF, 0xD0F6, 0xD2EE, 0xD4D3, 0xD9BD, 0xE0C3,
    0xE9D5, 0xF4FC, 0x01E1, 0x0B3B, 0x0BDF, 0x082D, 0x0724, 0x0820, 0x085A, 0x085E, 0x0A3F, 0x0E61, 0x11F8, 0x127F, 0x0FCE, 0x0C8A,
    0x0992, 0x07C9, 0x0837, 0x07E2, 0x0824, 0x0AC3, 0x0CFC, 0x0BFB, 0x09C5, 0x0928, 0x09F5, 0x0CF1, 0x117F, 0x1445, 0x132C, 0x0FC7,
    0x0EF4, 0x1262, 0x1638, 0x1983, 0x1E4C, 0x22C3, 0x2515, 0x26BA, 0x2963, 0x29D9, 0x239D, 0x19CD, 0x121B, 0x0D62, 0x0833, 0x015D,
    0xFB98, 0xF6EE, 0xF2EA, 0xEE12, 0xE90C, 0xE511, 0xE0C1, 0xDE04, 0xDDAA, 0xDDC7, 0xDDB7, 0xDE56, 0xDF0C, 0xDCA1, 0xD728, 0xD187,
    0xCDCA, 0xCDB6, 0xD20E, 0xD862, 0xDE3A, 0xE28B, 0xE75A, 0xEEDB, 0xF6E6, 0xFD2D, 0x0194, 0x058E, 0x08B2, 0x0CF2, 0x1622, 0x1FAB,
    0x22C4, 0x1EB0, 0x1AED, 0x1C18, 0x1EDA, 0x213D, 0x22BA, 0x24E5, 0x27DB, 0x2844, 0x23EB, 0x1CE7, 0x15C0, 0x0F20, 0x0A69, 0x05E7,
    0x00EA, 0xFD46, 0xFBCC, 0xFA00, 0xF69D, 0xF47E, 0xF3B7, 0xF57A, 0xF9EE, 0xFFAA, 0x03B2, 0x0331, 0x0166, 0x0131, 0x0234, 0x0220,
    0x010F, 0xFF9D, 0xFD55, 0xFB63, 0xFC00, 0xFF8A, 0x000F, 0xF9F2, 0xF2F1, 0xF098, 0xF1C2, 0xF2F6, 0xF472, 0xF6D0, 0xF944, 0xF9C6,
    0xF6EF, 0xF27C, 0xEB80, 0xE3BC, 0xDEB3, 0xDC57, 0xDB66, 0xDC53, 0xE181, 0xE76F, 0xEABE, 0xECD4, 0xEE42, 0xEF21, 0xF1EB, 0xF825,
    0xFF2B, 0x02E4, 0x0540, 0x0A34, 0x1073, 0x15BE, 0x1906, 0x1D83, 0x227C, 0x25D4, 0x2C07, 0x3615, 0x3F19, 0x3FCD, 0x3AE5, 0x3770,
    0x3530, 0x3223, 0x2CE1, 0x2660, 0x1F4E, 0x17F0, 0x0F51, 0x04F8, 0xFAA0, 0xF144, 0xEA61, 0xE6B8, 0xE2DC, 0xE05C, 0xE0D3, 0xE10E,
    0xDF80, 0xDD08, 0xD9DC, 0xD691, 0xD3BE, 0xD32E, 0xD3F3, 0xD1DA, 0xCD90, 0xCB61, 0xCCA4, 0xCE46, 0xD117, 0xD81E, 0xE099, 0xE777,
    0xEF6F, 0xFC92, 0x0AEC, 0x1116, 0x0E83, 0x0A0C, 0x065D, 0x018B, 0xF9E3, 0xF2D8, 0xF0C9, 0xF28E, 0xF48B, 0xF50B, 0xF3F4, 0xF22A,
    0xF165, 0xF274, 0xF149, 0xEEB8, 0xF07A, 0xF438, 0xF7D3, 0xFB9A, 0xFEFA, 0x01CB, 0x067F, 0x0ED8, 0x194F, 0x21CB, 0x277F, 0x2C47,
    0x3092, 0x34B3, 0x38D7, 0x3DFF, 0x4207, 0x4415, 0x45E9, 0x494A, 0x4D54, 0x4D68, 0x4783, 0x3E14, 0x3583, 0x2EDB, 0x2805, 0x2091,
    0x1AC8, 0x15D6, 0x0EF5, 0x06BC, 0xFE2C, 0xF484, 0xEA49, 0xE069, 0xD65E, 0xCBCA, 0xC30A, 0xBCE6, 0xB7D6, 0xB41C, 0xB0F0, 0xAE6B,
    0xAD5A, 0xAF8B, 0xB522, 0xBC0E, 0xC1B0, 0xC6A3, 0xCDE9, 0xD5B6, 0xDC74, 0xE2A0, 0xE7FE, 0xEBBF, 0xEDBE, 0xF1FC, 0xFBAC, 0x05A4,
    0x0AF5, 0x0C3F, 0x0D33, 0x0F6A, 0x1086, 0x1079, 0x1061, 0x12AC, 0x1574, 0x1627, 0x165E, 0x14B6, 0x1205, 0x10D6, 0x0FF5, 0x0F85,
    0x0EE7, 0x0FAE, 0x11C0, 0x12B3, 0x1338, 0x12F5, 0x1388, 0x1612, 0x1B6E, 0x2196, 0x2430, 0x230E, 0x2258, 0x237D, 0x252B, 0x2780,
    0x2AB0, 0x2E54, 0x3033, 0x322F, 0x3882, 0x4015, 0x4251, 0x3E5F, 0x37AB, 0x30ED, 0x2A30, 0x2150, 0x16DF, 0x0DC8, 0x0583, 0xFC9F,
    0xF2C6, 0xE699, 0xD94B, 0xCDCF, 0xC49D, 0xBDF0, 0xBA8C, 0xBB37, 0xBE3A, 0xC1F1, 0xC5AA, 0xC84C, 0xC85A, 0xC6C7, 0xC660, 0xC750,
    0xC781, 0xC64F, 0xC677, 0xC85E, 0xCC90, 0xD289, 0xDA3B, 0xE1AB, 0xE662, 0xEB33, 0xF424, 0x005B, 0x0A1D, 0x0E5F, 0x0E97, 0x0E20,
    0x0E01, 0x0D35, 0x0C5E, 0x0D7A, 0x107E, 0x1385, 0x1503, 0x1452, 0x1186, 0x0F36, 0x0D24, 0x0C17, 0x0B14, 0x0AF5, 0x0BA7, 0x0B8A,
    0x0BB6, 0x0A59, 0x0826, 0x05DF, 0x06D8, 0x0B99, 0x0FCA, 0x1146, 0x11B1, 0x129A, 0x1487, 0x1710, 0x19F7, 0x1D0B, 0x1CCA, 0x1A72,
    0x1975, 0x1B79, 0x1CBB, 0x1925, 0x12D3, 0x0C45, 0x0784, 0x02C3, 0xFC9D, 0xF7B3, 0xF594, 0xF657, 0xF908, 0xFB00, 0xFAD7, 0xF804,
    0xF456, 0xEEE5, 0xE77C, 0xE101, 0xDD94, 0xDDC5, 0xDE8D, 0xDF50, 0xDF44, 0xDDC1, 0xDD5A, 0xE0C6, 0xE620, 0xEA91, 0xED90, 0xF147,
    0xF73A, 0xFD67, 0x035A, 0x08EF, 0x0CB2, 0x0D34, 0x0EA5, 0x162E, 0x2042, 0x2650, 0x26F8, 0x2569, 0x24F4, 0x25C2, 0x25A6, 0x2581,
    0x2665, 0x26F8, 0x2769, 0x2603, 0x218D, 0x1A71, 0x13B0, 0x0E05, 0x07C2, 0x019F, 0xFCBE, 0xF95E, 0xF6EC, 0xF4CD, 0xF2FB, 0xF06D,
    0xEDAC, 0xEE4E, 0xF16F, 0xF2A8, 0xF075, 0xED83, 0xEBBC, 0xEA84, 0xEA03, 0xEBA8, 0xECA4, 0xEA89, 0xE6C5, 0xE788, 0xEE10, 0xF58E,
    0xFAF5, 0xFDEF, 0x0069, 0x01DA, 0x00F6, 0xFD96, 0xF969, 0xF630, 0xF56F, 0xF50D, 0xF2CE, 0xEF66, 0xEBF0, 0xE95B, 0xE6AF, 0xE3E7,
    0xE2C1, 0xE36E, 0xE545, 0xE748, 0xE96A, 0xE9ED, 0xE931, 0xEBC7, 0xF273, 0xF9D4, 0xFF81, 0x042E, 0x0884, 0x0B8E, 0x0F0F, 0x1463,
    0x1B08, 0x200E, 0x234F, 0x2A4C, 0x351A, 0x4009, 0x4608, 0x45F9, 0x43E2, 0x4143, 0x3D79, 0x3919, 0x3405, 0x2E96, 0x28C1, 0x2288,
    0x1B34, 0x1265, 0x0A00, 0x01DC, 0xF8F2, 0xEF72, 0xE739, 0xE01E, 0xD91E, 0xD3A9, 0xCFEB, 0xCB3F, 0xC582, 0xC0A0, 0xBE9D, 0xBDE0,
    0xBD36, 0xBCCE, 0xBE6B, 0xC2C4, 0xC854, 0xD044, 0xD9DB, 0xE0F2, 0xE3F0, 0xE61A, 0xEB57, 0xF3D4, 0xFBAD, 0x003E, 0x02B3, 0x04AF,
    0x064B, 0x0715, 0x073C, 0x073C, 0x07E9, 0x0984, 0x098E, 0x0714, 0x02FE, 0xFE7A, 0xFA18, 0xF550, 0xF268, 0xF306, 0xF5D9, 0xF9D0,
    0xFE80, 0x022B, 0x04B5, 0x06F5, 0x0B87, 0x131A, 0x1AF8, 0x21E1, 0x2728, 0x2B83, 0x2F53, 0x33B6, 0x39CC, 0x3E9C, 0x3F49, 0x3E9B,
    0x404B, 0x44C2, 0x4879, 0x4832, 0x44AE, 0x40AC, 0x3CA5, 0x365C, 0x2FE4, 0x2982, 0x218E, 0x1A24, 0x138E, 0x0C06, 0x030D, 0xF8A6,
    0xED1F, 0xE0C3, 0xD3A5, 0xC824, 0xBF3B, 0xB9E8, 0xB85A, 0xB8E2, 0xB965, 0xB9D4, 0xBC8B, 0xC177, 0xC545, 0xC7AF, 0xC942, 0xCB60,
    0xCD61, 0xCFBD, 0xD628, 0xDE41, 0xE38B, 0xE637, 0xEADE, 0xF412, 0xFEF2, 0x07FE, 0x0D42, 0x0FD2, 0x118D, 0x1245, 0x13E5, 0x1536,
    0x1650, 0x18FB, 0x1C1A, 0x1DAF, 0x1CF6, 0x1BB7, 0x1B25, 0x19E1, 0x17E0, 0x1669, 0x15D0, 0x15EC, 0x1633, 0x184D, 0x1980, 0x17EE,
    0x16FB, 0x18B7, 0x1BC2, 0x1C2D, 0x1C03, 0x1D22, 0x1D78, 0x1DD2, 0x21AE, 0x2889, 0x2D3D, 0x2F03, 0x2FC1, 0x31EC, 0x363F, 0x3817,
    0x3628, 0x3297, 0x2EB6, 0x2A03, 0x239C, 0x1B01, 0x0F22, 0x039F, 0xF9B0, 0xF0F9, 0xE8E6, 0xE269, 0xDE97, 0xDB44, 0xD78A, 0xD38A,
    0xD04E, 0xCD03, 0xCAA2, 0xC9EF, 0xC967, 0xC6FB, 0xC4B5, 0xC4EF, 0xC71F, 0xC9BC, 0xCB3E, 0xCCA1, 0xCE1E, 0xD0D0, 0xD603, 0xDCDC,
    0xE36C, 0xE836, 0xEBE7, 0xF216, 0xFC73, 0x07DC, 0x1005, 0x148F, 0x1777, 0x191D, 0x19B4, 0x1A37, 0x1A8C, 0x1BEA, 0x1E75, 0x2010,
    0x1FBB, 0x1E08, 0x1C52, 0x1A76, 0x1806, 0x155C, 0x11F7, 0x0D7B, 0x096A, 0x07BB, 0x07B4, 0x0614, 0x02DF, 0x01B0, 0x0405, 0x05C9,
    0x056D, 0x0414, 0x00B6, 0xFC34, 0xFA25, 0xFCB9, 0x00D1, 0x0193, 0xFE7A, 0xFB49, 0xFA84, 0xFC5C, 0xFD84, 0xFE84, 0x002A, 0x01C2,
    0x045E, 0x072D, 0x08C4, 0x08E6, 0x0942, 0x0A22, 0x0920, 0x0679, 0x0321, 0xFF09, 0xFA80, 0xF5E3, 0xF1C7, 0xEDA4, 0xE9D7, 0xE808,
    0xE6FD, 0xE494, 0xE00C, 0xDC66, 0xDD03, 0xE020, 0xE468, 0xE8D4, 0xED63, 0xF15C, 0xF50F, 0xFB5F, 0x0340, 0x0942, 0x0C5D, 0x0EA6,
    0x147B, 0x1E79, 0x27D7, 0x2E0C, 0x319F, 0x33DD, 0x367B, 0x38D4, 0x395B, 0x38BE, 0x37C3, 0x36B4, 0x345C, 0x2FCD, 0x2AA9, 0x2581,
    0x2067, 0x1B6D, 0x1620, 0x1034, 0x093F, 0x02B9, 0xFD4D, 0xF7EF, 0xF156, 0xEA20, 0xE6B1, 0xE534, 0xE230, 0xDE58, 0xD988, 0xD396,
    0xCE0A, 0xCD22, 0xD1D4, 0xD807, 0xDBC9, 0xDDE2, 0xE296, 0xEAC9, 0xF383, 0xFA04, 0xFDC4, 0xFE9C, 0xFDAC, 0xFC2F, 0xF9A3, 0xF632,
    0xF478, 0xF5B2, 0xF786, 0xF894, 0xF852, 0xF706, 0xF476, 0xF11A, 0xEE09, 0xEB6A, 0xE993, 0xE991, 0xEC9B, 0xF09E, 0xF2AB, 0xF25D,
    0xF379, 0xF73D, 0xFC20, 0x0238, 0x0888, 0x0CC8, 0x0E12, 0x0FA4, 0x14F7, 0x1C8D, 0x224E, 0x25DD, 0x29DE, 0x3131, 0x3942, 0x3EC0,
    0x40DB, 0x4068, 0x3F8D, 0x3E65, 0x3C87, 0x38D5, 0x342C, 0x2FD1, 0x2A7F, 0x2355, 0x1BC5, 0x145E, 0x0CBF, 0x04C1, 0xFC0F, 0xF263,
    0xE6DD, 0xDA88, 0xD0A6, 0xC99C, 0xC311, 0xBD60, 0xBA6E, 0xBB25, 0xBE1E, 0xC1B7, 0xC5C0, 0xC8F8, 0xC9AE, 0xCAB2, 0xCDF9, 0xD397,
    0xD88C, 0xDAE6, 0xDC96, 0xDFA4, 0xE685, 0xEF59, 0xF729, 0xFCE8, 0x00D7, 0x03CE, 0x05DE, 0x0616, 0x053D, 0x0515, 0x0691, 0x07E2,
    0x07E3, 0x068B, 0x0431, 0x0173, 0xFDCB, 0xF9E1, 0xF6EA, 0xF565, 0xF66B, 0xFA6F, 0xFE32, 0xFFD3, 0x013E, 0x04BA, 0x09FB, 0x0FC4,
    0x1595, 0x1ABB, 0x1DBB, 0x1E37, 0x2016, 0x2576, 0x2BE2, 0x2F84, 0x3112, 0x3468, 0x3926, 0x3D77, 0x3F7A, 0x3E76, 0x3BD1, 0x393A,
    0x376E, 0x3464, 0x2EA2, 0x27F9, 0x2024, 0x1630, 0x0A5E, 0xFD3D, 0xF144, 0xE5C7, 0xDC26, 0xD46B, 0xCD40, 0xC74A, 0xC2EC, 0xC178,
    0xC07B, 0xBE22, 0xBBC7, 0xBADE, 0xBB6F, 0xBC5E, 0xBE5E, 0xC131, 0xC2ED, 0xC3EE, 0xC5D9, 0xCAFC, 0xD2A2, 0xD8E1, 0xDCA4, 0xE077,
    0xE784, 0xF0BA, 0xFA62, 0x0398, 0x0ABB, 0x108D, 0x157C, 0x18A8, 0x1A64, 0x1C19, 0x1EE7, 0x2147, 0x2314, 0x2452, 0x24FF, 0x23F6,
    0x2169, 0x1FD4, 0x1ED1, 0x1C60, 0x1893, 0x15CF, 0x13D1, 0x1091, 0x0AFE, 0x05A1, 0x0329, 0x0382, 0x0601, 0x0A31, 0x0DD2, 0x0EA3,
    0x0CFB, 0x0D01, 0x10A5, 0x1441, 0x16CD, 0x1856, 0x1AE8, 0x1E0C, 0x2003, 0x203F, 0x1D05, 0x1821, 0x141E, 0x1098, 0x0C85, 0x0839,
    0x0428, 0x0118, 0xFD97, 0xF91A, 0xF3D4, 0xEDDE, 0xE7A9, 0xE16F, 0xDC0F, 0xD5F7, 0xCFE2, 0xCC79, 0xCB57, 0xC9E6, 0xC723, 0xC47C,
    0xC2FB, 0xC25E, 0xC2A3, 0xC44A, 0xC6BB, 0xC7EE, 0xC849, 0xCAF9, 0xD0CE, 0xD84C, 0xDE79, 0xE302, 0xE8E4, 0xF152, 0xFB86, 0x0544,
    0x0D53, 0x13F1, 0x198D, 0x1E42, 0x21D0, 0x2497, 0x2791, 0x29C7, 0x2AC6, 0x29D4, 0x2705, 0x2361, 0x1F47, 0x1BCD, 0x185B, 0x14F2,
    0x111F, 0x0DCB, 0x0C04, 0x0A22, 0x0663, 0x0175, 0xFE64, 0xFD45, 0xFDFF, 0xFF98, 0x00FD, 0xFF2A, 0xF7D6, 0xEE92, 0xE80A, 0xE4B6,
    0xE190, 0xDE1E, 0xDD1F, 0xDFB5, 0xE57F, 0xED8B, 0xF4D0, 0xFA4B, 0xFF14, 0x02CB, 0x048C, 0x0451, 0x0310, 0x024F, 0x0145, 0xFF7E,
    0xFE46, 0xFE17, 0xFC6B, 0xF9CE, 0xF75E, 0xF473, 0xEF90, 0xE9F6, 0xE6FF, 0xE604, 0xE447, 0xE1DF, 0xDFDA, 0xDF45, 0xE0AE, 0xE496,
    0xEA38, 0xEF1F, 0xF2AD, 0xF3FA, 0xF6DA, 0xFCD4, 0x034E, 0x0811, 0x0BB1, 0x1113, 0x1916, 0x2230, 0x2953, 0x2C67, 0x2D3F, 0x2DF8,
    0x2E39, 0x2E96, 0x2F5C, 0x2FC5, 0x2F9B, 0x2E1D, 0x2B78, 0x2872, 0x240B, 0x1FBB, 0x1B86, 0x182C, 0x140E, 0x0F23, 0x0A9B, 0x05BD,
    0xFE18, 0xF3B5, 0xE836, 0xDE1E, 0xD641, 0xD1A2, 0xD0AA, 0xD120, 0xD072, 0xCEFE, 0xCFA5, 0xD3A4, 0xD9EE, 0xDDB9, 0xE017, 0xE192,
    0xE5D7, 0xEB0D, 0xF176, 0xF5A9, 0xF7DF, 0xF6F7, 0xF57A, 0xF695, 0xFBD3, 0xF7E3, 0xF07C, 0xF7A1, 0xFE13, 0xFAA4, 0xF6C4, 0xF864,
    0xF9B5, 0xFB1A, 0xF656, 0xF3D5, 0xF237, 0xF972, 0xFA23, 0xF744, 0xF86F, 0xF7E6, 0xFA1B, 0xFD05, 0x00AA, 0x04F4, 0x084B, 0x0940,
    0x0B04, 0x09E4, 0x092E, 0x0B9E, 0x126B, 0x1651, 0x1A90, 0x1FAC, 0x299C, 0x2DCC, 0x35D9, 0x3403, 0x329F, 0x32FB, 0x3241, 0x3646,
    0x31DE, 0x2CB9, 0x2987, 0x2B9E, 0x233E, 0x15AC, 0x068B, 0xF9F1, 0xF133, 0xE512, 0xD467, 0xCFBB, 0xCCD4, 0xC87D, 0xC462, 0xC120,
    0xC14E, 0xC30C, 0xBEBC, 0xC181, 0xC5B1, 0xC74B, 0xC203, 0xBD07, 0xCDBC, 0xCFE0, 0xD10B, 0xCCAE, 0xDAB9, 0xDAC0, 0xE026, 0xEDAC,
    0xEFDC, 0xFFC3, 0xF928, 0x06B7, 0x09BD, 0x0990, 0x0B74, 0x1451, 0x0F1D, 0x1873, 0x1AE0, 0x0A5B, 0x15DF, 0x0881, 0x0F8D, 0x04F8,
    0x0225, 0x0FE5, 0x100B, 0x10EB, 0x19D4, 0x1003, 0xF98E, 0x08E8, 0x03D9, 0x0E71, 0x20D2, 0x015B, 0x1A32, 0x1AE7, 0x0DEA, 0x35D5,
    0x1256, 0x2C72, 0x306C, 0x27B0, 0x4176, 0x2ABC, 0x4710, 0x3924, 0x3228, 0x3ACD, 0x35BC, 0x287C, 0x21C2, 0x0683, 0x0E2A, 0x24DA,
    0xE70D, 0xF0C5, 0xFF3B, 0xFE4D, 0xE29F, 0xD5D5, 0xE157, 0xD54F, 0xC6CA, 0xC372, 0xDA33, 0xC206, 0xB266, 0xB368, 0xDD4C, 0xBFAE,
    0xA6C1, 0xD32D, 0xC69C, 0xCF1E, 0xC239, 0xCB39, 0xDBA6, 0xDD08, 0xD486, 0xE12A, 0xF3D9, 0xF526, 0xE489, 0x04ED, 0x2563, 0xFF70,
    0x1519, 0x10BF, 0x289B, 0x1BB5, 0x278C, 0x3B47, 0x2445, 0x31D0, 0x357D, 0x2D82, 0x29E2, 0x2515, 0x1583, 0x359F, 0x1CE6, 0x1406,
    0x1660, 0x1CF3, 0x14CF, 0xF0E2, 0x13DE, 0x15F0, 0x0432, 0x0C08, 0x1693, 0x29C9, 0x1298, 0x120F, 0x252F, 0x1A10, 0x0D2E, 0x10E5,
    0x0C6B, 0xFD48, 0x1FCC, 0x060E, 0x105D, 0x04C3, 0x0226, 0x2A55, 0x0500, 0x0DF6, 0xFF10, 0xFBA2, 0x0632, 0x0395, 0xFBD7, 0xF579,
    0xD41E, 0xF1FB, 0xEA4F, 0xB399, 0xE804, 0xCA98, 0xC944, 0xDA7B, 0xCC1D, 0xC5AC, 0xCBC5, 0xBB9E, 0xCC41, 0xD1C1, 0xBF59, 0xD4BE,
    0xD0C4, 0xD197, 0xD25D, 0xEE8B, 0xD09C, 0xE1E5, 0xF425, 0x029D, 0xFAEB, 0x037B, 0x20BB, 0x13DB, 0x3692, 0x1FAD, 0x1C65, 0x257A,
    0x2F58, 0x2D23, 0x2A1F, 0x2E03, 0x1DE9, 0x2B03, 0x2A98, 0x1B71, 0x135B, 0x146A, 0x1ECB, 0x0026, 0x1D94, 0x1A4A, 0x11FB, 0x06F7,
    0x04B4, 0x1832, 0xF379, 0xFB52, 0xEA60, 0x01C2, 0xE161, 0xDE03, 0xEC22, 0xE171, 0xDB39, 0xDF26, 0x0102, 0xCE09, 0xF6FF, 0xF99D,
    0xE8C3, 0x1791, 0x1074, 0x058C, 0x058E, 0x2219, 0xF826, 0x1179, 0x0DA6, 0xFF25, 0x1CA6, 0x10D4, 0x0531, 0x0608, 0x07F6, 0xF92C,
    0x04F6, 0xEC39, 0xFF63, 0xED40, 0xE964, 0xF895, 0xE9AF, 0xE3BE, 0xE8AF, 0xEB7A, 0xFFAF, 0x02A0, 0xF70C, 0xFA6C, 0x221B, 0xFC96,
    0x06E7, 0x167D, 0x0A74, 0x119D, 0x0C79, 0x4490, 0x1667, 0x2C33, 0x38F9, 0x2DD3, 0x2A1E, 0x49D3, 0x2CB5, 0x2FF9, 0x2E94, 0x3715,
    0x37B0, 0x3D76, 0x462C, 0x2074, 0x35EC, 0x3521, 0x3708, 0xFF7A, 0x158F, 0x0306, 0xF297, 0xE609, 0xF246, 0xE674, 0xD166, 0xCF60,
    0xE68C, 0xE090, 0xD1D3, 0xE81C, 0xDF45, 0xD682, 0xE13D, 0xF134, 0xE085, 0xE878, 0xE5FA, 0xF49C, 0xFCE1, 0x0671, 0xF7F7, 0x034B,
    0xFAE3, 0x10CE, 0x002C, 0x0839, 0x1322, 0x047E, 0x2323, 0x09B0, 0x05E7, 0x2742, 0x0C14, 0xFAD6, 0x110B, 0x0B0F, 0xFA34, 0x0A96,
    0x18FC, 0xFF3F, 0x20FC, 0x1611, 0xFFCB, 0x092F, 0x18C1, 0x0387, 0x0C2F, 0x05D6, 0x1220, 0x042C, 0x05E7, 0x1409, 0x013A, 0x106A,
    0x06D3, 0x26F4, 0x241C, 0x0122, 0x2765, 0x3A50, 0x296C, 0x3A47, 0x1B0B, 0x27D2, 0x268E, 0x2282, 0x14E3, 0x0FEF, 0xF829, 0xF827,
    0xE024, 0xE79D, 0xF003, 0xBEAA, 0xE7EC, 0xD2C9, 0xCB5A, 0xD65A, 0xD122, 0xC097, 0xC0BC, 0xBDE7, 0xCC09, 0xC813, 0xC463, 0xD353,
    0xB313, 0xD668, 0xD571, 0xC24E, 0xDAF7, 0xD0FE, 0xE9BC, 0xDA30, 0xEC9E, 0xFA31, 0xF22C, 0x116D, 0x0987, 0x128F, 0x1CFF, 0x03C9,
    0x1D93, 0x1652, 0x0522, 0x25E8, 0x0E40, 0x222D, 0x1B2C, 0x1626, 0x1CFA, 0x01EF, 0x08D5, 0x14AC, 0x0A63, 0x0B59, 0x156E, 0x06D7,
    0xF68A, 0x0919, 0x08BB, 0x0FD7, 0x0B2B, 0x080E, 0x1903, 0x2606, 0x203A, 0x24DF, 0x309E, 0x27BE, 0x3152, 0x32EE, 0x4686, 0x23EE,
    0x22DA, 0x3749, 0x2876, 0x181A, 0x0B77, 0x0BBC, 0x12EE, 0xF3D4, 0xF5EB, 0xFE20, 0xFD3F, 0xE18F, 0xE86F, 0xFEFB, 0xE093, 0xD4CA,
    0xC7D8, 0xE387, 0xB13D, 0xCC96, 0xC4DB, 0xB543, 0xC210, 0xACD6, 0xB811, 0xA999, 0xC14F, 0xB99B, 0xB7FD, 0xBAF6, 0xCD08, 0xC326,
    0xCA32, 0xDBD6, 0xCBA2, 0xD1B4, 0xE8FB, 0xF42F, 0xEA8D, 0x0452, 0x1761, 0x157A, 0x085B, 0x2BCB, 0x1E10, 0x17F4, 0x2AF4, 0x1F9C,
    0x35CC, 0x37A7, 0x2C2F, 0x347D, 0x333B, 0x15BF, 0x33DE, 0x1A8E, 0x20C8, 0x2379, 0x0FB2, 0x1EB0, 0x150A, 0x1BF1, 0x1B7C, 0x216F,
    0x2E61, 0x1947, 0x2B9F, 0x30B3, 0x01C4, 0x23D1, 0x0561, 0x10D6, 0x097B, 0xFB7D, 0x067E, 0xFBE0, 0x146A, 0x0811, 0x0701, 0x0EF9,
    0x1660, 0x116D, 0x04D2, 0x033C, 0x0304, 0xFED8, 0xF32C, 0xEC31, 0x04E9, 0xE3F9, 0xED33, 0xDECD, 0xD41D, 0xD6A0, 0xC2E8, 0xD5D0,
    0xC110, 0xD107, 0xD21C, 0xBD64, 0xB9FD, 0xCB3E, 0xB9F7, 0xB6FA, 0xBA88, 0xC448, 0xC7C7, 0xC0AF, 0xE3DC, 0xC9B2, 0xD467, 0xE8C1,
    0xD862, 0xEE5B, 0xF50A, 0xF238, 0x14B7, 0x0A37, 0x09AD, 0x18C5, 0x19FA, 0x0F8F, 0x0C0D, 0x291B, 0x0B7C, 0x1DE2, 0x1F47, 0x1494,
    0x18F6, 0x1E77, 0x182F, 0x10BD, 0x290E, 0x1305, 0x0C13, 0x1C95, 0x1478, 0x0310, 0xF4A7, 0xEF0A, 0xF7AC, 0xEEB3, 0xD9A1, 0xD4A1,
    0xE474, 0xDAEC, 0xE212, 0xD3FD, 0xD593, 0xE81A, 0xDBC8, 0xE3AC, 0xE871, 0xDF3B, 0xF9CE, 0xEAD4, 0xFD84, 0x0782, 0xF70B, 0x0C62,
    0xF315, 0x084F, 0x046C, 0x0322, 0x0755, 0x1F08, 0x066B, 0x110A, 0x1162, 0xEDCA, 0xF6E9, 0x04D8, 0xE726, 0xE93B, 0xFE06, 0xE722,
    0xF6A0, 0xE84C, 0x0086, 0xE498, 0xF694, 0xFD88, 0xF2AD, 0x00ED, 0x02FE, 0x03D1, 0x038D, 0x0DAA, 0x0677, 0xF93D, 0x0907, 0x1D77,
    0x0FB9, 0x1505, 0x12E6, 0x2846, 0x1A2C, 0x218B, 0x29BE, 0x1FFA, 0x2E7E, 0x38D0, 0x245C, 0x246B, 0x1E50, 0x1C18, 0x0EFF, 0xF225,
    0xF652, 0xF0D1, 0xEF8A, 0xD423, 0xE0F0, 0xCFFF, 0xC4C3, 0xD15B, 0xDD5F, 0xC995, 0xCDD7, 0xD384, 0xCA51, 0xDAA5, 0xD8B0, 0xE9D4,
    0xD31B, 0xE27A, 0xF267, 0xE40F, 0xE6F7, 0xF1CF, 0xF7EE, 0xFBD6, 0xFE62, 0x1621, 0x08C4, 0x0B7B, 0x1E33, 0x1453, 0x0BDF, 0x123D,
    0x1285, 0x1252, 0x2517, 0x079C, 0x1083, 0x1283, 0x1957, 0xFF74, 0x009E, 0x19C4, 0x1795, 0x0F9C, 0x0204, 0x1DC1, 0x194A, 0x0431,
    0x08B3, 0x183A, 0x0077, 0x0779, 0x0ED6, 0xFEFF, 0x00E5, 0x1A0E, 0x0A91, 0x0028, 0x28DF, 0x26C3, 0x1F7A, 0x3B16, 0x3CB4, 0x347F,
    0x2F31, 0x2810, 0x3312, 0x14B4, 0x0E74, 0x0EFA, 0xFFF0, 0xFA68, 0x01B6, 0xED03, 0xE053, 0xEE70, 0xDEDC, 0xD612, 0xD166, 0xD5E3,
    0xD611, 0xC7A5, 0xCDDC, 0xD393, 0xC483, 0xCAC6, 0xC82B, 0xC54C, 0xC078, 0xC49A, 0xCDB5, 0xC303, 0xCDE1, 0xD047, 0xD904, 0xDB16,
    0xDC64, 0xE4EC, 0xED95, 0xFD40, 0xFA76, 0x00B6, 0x1072, 0x1E3B, 0x184F, 0x1CE7, 0x105E, 0x2856, 0x29DD, 0x1444, 0x279F, 0x2490,
    0x250C, 0x1CE8, 0x2735, 0x156E, 0x1F01, 0x17C4, 0x14B8, 0x1167, 0xF8DF, 0x1741, 0x00C7, 0x06D8, 0x0F8C, 0x0860, 0x1D22, 0x1738,
    0x2A5E, 0x2A88, 0x2A63, 0x3B89, 0x312C, 0x3505, 0x29D2, 0x2DE5, 0x2953, 0x26AF, 0x27A3, 0x1E87, 0x21C4, 0x2662, 0x1E5D, 0x09D7,
    0x1D5D, 0x13FA, 0x06B7, 0x0CDA, 0x085A, 0x017A, 0xFA9D, 0xF23A, 0xFB7E, 0xDC5B, 0xD9D1, 0xDEFE, 0xC8E2, 0xCED4, 0xC021, 0xC638,
    0xBC6E, 0xBFC4, 0xC301, 0xC5F6, 0xB6A4, 0xBAAD, 0xCAB3, 0xC262, 0xCC83, 0xC844, 0xCE1E, 0xD7E4, 0xDCEF, 0xE31C, 0xEB57, 0xF5CF,
    0x055B, 0x0026, 0x086C, 0x229C, 0x1D1D, 0x1D5E, 0x26D8, 0x2832, 0x232E, 0x294E, 0x383D, 0x274C, 0x27A6, 0x23EC, 0x2482, 0x2869,
    0x1659, 0x230E, 0x2968, 0x258D, 0x1EAE, 0x226D, 0x262D, 0x31F7, 0x32E9, 0x2316, 0x26AB, 0x2583, 0x1E67, 0x1131, 0x137D, 0x17E8,
    0x0D3C, 0x097D, 0x1178, 0x1821, 0x0447, 0x1135, 0x1BE5, 0x165C, 0x1914, 0x21FC, 0x2596, 0x1596, 0x1970, 0x0CCA, 0x0CE9, 0x0878,
    0xFA59, 0xFD16, 0xF679, 0xECE1, 0xEEE3, 0xE10B, 0xE3BB, 0xD7FB, 0xDC08, 0xD756, 0xCFFA, 0xD47F, 0xCB22, 0xCF04, 0xC9E7, 0xCC9D,
    0xC1A1, 0xCF2C, 0xCC41, 0xD2FD, 0xD2E2, 0xDCD2, 0xDB4B, 0xE81B, 0xF062, 0xF02C, 0x001F, 0x0CBB, 0x1853, 0x0D36, 0x1BBB, 0x1D52,
    0x1E01, 0x18D1, 0x1470, 0x15B0, 0x207F, 0x1F01, 0x2661, 0x2CEB, 0x2444, 0x35C8, 0x34FA, 0x1C8C, 0x3B30, 0x255E, 0x1826, 0x211C,
    0x0F0B, 0x0C1D, 0xFC22, 0x03E8, 0xF987, 0xF542, 0xE8C7, 0xEE37, 0xE403, 0xE347, 0xE58C, 0xE42B, 0xE55E, 0xE9FD, 0xF71A, 0xE4E1,
    0xECD8, 0xF064, 0xF496, 0xF6D7, 0xEEC7, 0xF35C, 0xFBDC, 0xFBBF, 0x016F, 0xFB50, 0x067D, 0x0BB6, 0x0759, 0x0919, 0x0B6E, 0x16AF,
    0x0D1D, 0x123C, 0x102D, 0x130A, 0x062E, 0xFC59, 0x0BEE, 0x027B, 0x00A6, 0xFC96, 0x01A5, 0xFFFD, 0x0417, 0x07AA, 0x07A0, 0x1028,
    0x05F7, 0x120C, 0x0A91, 0x0827, 0x0A61, 0x0A67, 0x04F8, 0x0662, 0x0E43, 0x0E9F, 0x1516, 0x153D, 0x2453, 0x24E0, 0x2730, 0x27B7,
    0x35B9, 0x3503, 0x2673, 0x2ABB, 0x2A1E, 0x18B7, 0x1B9A, 0x1C2C, 0x0B4F, 0x108A, 0x0AE4, 0x00A2, 0xF175, 0xE8FE, 0xE3F9, 0xDF58,
    0xDFBA, 0xDF15, 0xD6D7, 0xD559, 0xD3A7, 0xC8B7, 0xD1B3, 0xD07B, 0xD196, 0xD436, 0xD39A, 0xDEE6, 0xDD5B, 0xD8FF, 0xE092, 0xE80C,
    0xE43C, 0xEC1E, 0xF3A4, 0xF067, 0xFC36, 0x0712, 0x0643, 0x0D06, 0x0EFB, 0x1606, 0x16C9, 0x18AC, 0x1F08, 0x24DE, 0x21F1, 0x22D8,
    0x3078, 0x2E5E, 0x2F0F, 0x2E36, 0x35BB, 0x2AC1, 0x275D, 0x2276, 0x0DA5, 0x08F6, 0x0A7C, 0x025D, 0xF437, 0xF5D5, 0x0124, 0x013F,
    0xFA07, 0x0718, 0x1002, 0x0CF0, 0x0D63, 0x1887, 0x0E2C, 0x0930, 0x1AD2, 0x0B16, 0x1027, 0x0B47, 0x0171, 0x0EEF, 0xFFE9, 0xFA75,
    0xF205, 0xEEE5, 0xF03B, 0xEF90, 0xE9C1, 0xF69D, 0xFC78, 0xEEEC, 0xF16F, 0xEAA3, 0xEA48, 0xDD3F, 0xD8D6, 0xDF42, 0xD4E9, 0xD07C,
    0xD27D, 0xC3F6, 0xC525, 0xCD41, 0xC31B, 0xBF45, 0xC35C, 0xCDD6, 0xCE29, 0xD1F9, 0xCBFE, 0xD781, 0xE405, 0xE330, 0xEB67, 0xEF8B,
    0xFC49, 0xFD44, 0x0611, 0x0CDE, 0x12E4, 0x1AD6, 0x2114, 0x1FA6, 0x2786, 0x2B16, 0x209C, 0x21F1, 0x1B2F, 0x1DD4, 0x18EE, 0x0F5E,
    0x1B40, 0x1484, 0x0CD3, 0x1856, 0x13F5, 0x1A0F, 0x216D, 0x20A2, 0x1DA6, 0x20C8, 0x186D, 0x18DF, 0x1685, 0x10A6, 0x1604, 0x0C0D,
    0x0B92, 0x0B56, 0x03DA, 0xFE2D, 0x012A, 0xF8F9, 0xFACB, 0xF675, 0x02B5, 0x032B, 0x0022, 0x0BE5, 0xFFA3, 0xFB49, 0xF990, 0xFC4F,
    0xFAE3, 0xF06D, 0xF017, 0xF625, 0xE8F3, 0xEFCC, 0xE9C0, 0xE4F6, 0xE33E, 0xDDC5, 0xDED9, 0xD53B, 0xD8A6, 0xD828, 0xD509, 0xD683,
    0xD616, 0xD28C, 0xD56D, 0xD1F3, 0xD0F7, 0xD80F, 0xDEFB, 0xE24D, 0xE925, 0xF088, 0xFB46, 0xFA50, 0x0462, 0x1252, 0x0F3D, 0x0DDF,
    0x13B2, 0x1846, 0x1891, 0x1C1A, 0x1B1D, 0x22D1, 0x2355, 0x28E3, 0x3182, 0x3856, 0x405C, 0x3C01, 0x41C0, 0x4616, 0x399D, 0x44ED,
    0x3C79, 0x3D71, 0x3D65, 0x3303, 0x3643, 0x2030, 0x201F, 0x1492, 0x08DE, 0xFFF1, 0xFAE9, 0xF6C8, 0xF31A, 0xF130, 0xF4FC, 0xF14F,
    0xE7A9, 0xF754, 0xE190, 0xE010, 0xE8BE, 0xDBBC, 0xE177, 0xDCA9, 0xDF4E, 0xDA42, 0xD8BC, 0xE4F1, 0xDF51, 0xD8C7, 0xDFAD, 0xE643,
    0xDB71, 0xE75E, 0xE719, 0xE7D9, 0xE445, 0xE973, 0xEF51, 0xE3F0, 0xEB02, 0xE9CF, 0xEC11, 0xE1C3, 0xECF7, 0xE9C9, 0xED16, 0xF07C,
    0xEA2D, 0xF10F, 0xEF7B, 0xF43B, 0xF046, 0xE9B9, 0xEE7E, 0xF377, 0xEC92, 0xEA71, 0xEF4C, 0xFB5F, 0x03CE, 0x0B84, 0x0EF4, 0x1AAC,
    0x22F1, 0x2205, 0x2A34, 0x2EB8, 0x32C1, 0x39B7, 0x35C3, 0x34A8, 0x3AC0, 0x3A9B, 0x2F47, 0x2C3D, 0x2608, 0x2444, 0x1EAD, 0x1E8D,
    0x1D37, 0x1073, 0x130F, 0x06D6, 0x0289, 0xF694, 0xF8AB, 0xEFD7, 0xE6C6, 0xE1ED, 0xDD4B, 0xDD1F, 0xD7A5, 0xD64F, 0xCEB7, 0xD0B5,
    0xCE27, 0xD60A, 0xD143, 0xD587, 0xE114, 0xDE63, 0xE2C2, 0xECA6, 0xF54D, 0xF623, 0xF9B7, 0xFADC, 0xF943, 0x05AF, 0x0A08, 0x08F1,
    0x0F1C, 0x18CA, 0x18D1, 0x2439, 0x2493, 0x24BB, 0x2C71, 0x2810, 0x2DEE, 0x21F1, 0x2649, 0x1DCB, 0x16AD, 0x0DC9, 0x0F19, 0x133C,
    0x09F6, 0x10E9, 0x0E60, 0x106E, 0x0DBE, 0x0DBD, 0x0CFC, 0x0B46, 0x0C62, 0x100B, 0x128A, 0x1173, 0x08D5, 0x0D26, 0x03B3, 0x046F,
    0x051B, 0xFF57, 0x02D0, 0xFD35, 0x06FE, 0xFF5E, 0x0017, 0xFE29, 0xFE19, 0xF54E, 0xF878, 0xF4BE, 0xEC4A, 0xF4A5, 0xF0D3, 0xF4FD,
    0xF483, 0xF8DB, 0xF92F, 0xF65D, 0xF63F, 0xFA78, 0xF471, 0xF2BF, 0xF18B, 0xF2A2, 0xE9A3, 0xEF79, 0xEE3C, 0xE9CD, 0xF118, 0xED02,
    0xF36F, 0xEE8D, 0xFAC3, 0xFD60, 0x014E, 0x0717, 0x0CF8, 0x0E4A, 0x193A, 0x2051, 0x1E9B, 0x2611, 0x23D5, 0x2550, 0x1C44, 0x1C0D,
    0x161D, 0x178A, 0x14E9, 0x1235, 0x1994, 0x1880, 0x1EB2, 0x1ACC, 0x2352, 0x2438, 0x20A7, 0x26B4, 0x2122, 0x254E, 0x21EE, 0x17B1,
    0x161C, 0x0963, 0x0035, 0xF882, 0xEDFF, 0xEA00, 0xDFBE, 0xDD1B, 0xD6B7, 0xD7F0, 0xCB5E, 0xCCD8, 0xC960, 0xC59B, 0xCBEF, 0xC6ED,
    0xCD52, 0xC732, 0xD082, 0xCF08, 0xD256, 0xD1CE, 0xD838, 0xD965, 0xD9BF, 0xDEFC, 0xDBA0, 0xE2A2, 0xE0AD, 0xE3E9, 0xE7D8, 0xED9C,
    0xE9C7, 0xEE85, 0xF8A7, 0xF3C7, 0xFAC7, 0xFFDD, 0xFE02, 0x0982, 0x0792, 0x0B0C, 0x0FA3, 0x0EAC, 0x16BD, 0x15CB, 0x13D2, 0x14F4,
    0x183B, 0x0F68, 0x0EA1, 0x0D8A, 0x0581, 0x03D6, 0x0439, 0x0852, 0x0A6B, 0x1272, 0x10D3, 0x1340, 0x1A15, 0x1E53, 0x256B, 0x275E,
    0x2FE9, 0x33BC, 0x3179, 0x36F8, 0x30E5, 0x2AC3, 0x2546, 0x1E68, 0x1BC3, 0x157C, 0x13FF, 0x0FBD, 0x0A14, 0x0288, 0xFF24, 0xFB36,
    0xF3C4, 0xEEFE, 0xEDD3, 0xE561, 0xE707, 0xE4EA, 0xDC3C, 0xDA6B, 0xD872, 0xD78A, 0xCFB3, 0xD15B, 0xD01A, 0xCE01, 0xCA32, 0xCA42,
    0xCBDA, 0xC882, 0xCCA5, 0xCF07, 0xCB8E, 0xCF6E, 0xD224, 0xD2CB, 0xD729, 0xD9E1, 0xDEBC, 0xDF0D, 0xE782, 0xE7F8, 0xF1AD, 0xF613,
    0xFDFC, 0x0A29, 0x06DD, 0x1588, 0x157B, 0x14E9, 0x1384, 0x1214, 0x1166, 0x10E3, 0x1300, 0x12E7, 0x161D, 0x1818, 0x1A48, 0x1931,
    0x1B93, 0x1EC7, 0x22E7, 0x27A1, 0x2BFD, 0x2AEF, 0x2BE3, 0x2DCE, 0x2978, 0x25A8, 0x2234, 0x1C8A, 0x1B57, 0x1A7B, 0x1C85, 0x1759,
    0x176F, 0x1480, 0x0E2D, 0x0E31, 0x09F5, 0x0DAC, 0x059F, 0x0B59, 0x057C, 0x0434, 0x0303, 0xFF02, 0x0016, 0xF4EA, 0xF81C, 0xEF5A,
    0xEC0E, 0xE3D4, 0xDADC, 0xD769, 0xD37E, 0xCEAB, 0xCF3D, 0xCD69, 0xCE18, 0xC78C, 0xC7E2, 0xCCB0, 0xC359, 0xC8AA, 0xC6BE, 0xCCEC,
    0xCC82, 0xCCFE, 0xD391, 0xD36E, 0xDE87, 0xE3E5, 0xE535, 0xEB0F, 0xEB08, 0xF055, 0xEF9A, 0xF3CB, 0xF276, 0xF4D2, 0x001A, 0xFEF7,
    0x09DD, 0x0BE5, 0x0FD9, 0x14ED, 0x17F6, 0x1D5F, 0x233E, 0x2749, 0x2ABE, 0x2D36, 0x2D61, 0x274C, 0x2449, 0x1FAA, 0x1688, 0x1613,
    0x0E45, 0x0CFD, 0x0755, 0x09DF, 0x0600, 0x01D2, 0xFFE0, 0xF8FC, 0xFB40, 0xF489, 0xF1EE, 0xF193, 0xF3C3, 0xF112, 0xF01C, 0xF438,
    0xEF99, 0xEEB8, 0xF068, 0xEB92, 0xF02C, 0xECF6, 0xEE20, 0xEF53, 0xEE4B, 0xF0C6, 0xF1BD, 0xF775, 0xF5C9, 0xFAC0, 0xFA14, 0xF9C4,
    0xFBEC, 0xF94D, 0xF61B, 0xF754, 0xF3DD, 0xF157, 0xF2F6, 0xF629, 0xF739, 0xFB5B, 0xFE61, 0xFE6F, 0xFF92, 0xFD52, 0xFC44, 0xFAF1,
    0xFC5E, 0xFB67, 0xFF33, 0xFE54, 0x0214, 0x02E2, 0x046E, 0x06CC, 0x0C4A, 0x114A, 0x17E7, 0x1FD2, 0x26D5, 0x2D41, 0x2953, 0x2E44,
    0x285C, 0x2641, 0x2332, 0x2389, 0x2163, 0x1AD0, 0x19BB, 0x14B0, 0x1058, 0x0A70, 0x0779, 0xFEE9, 0xF94F, 0xF095, 0xED6A, 0xE66D,
    0xE076, 0xDF11, 0xDC7F, 0xDBEE, 0xD7C0, 0xD8EF, 0xD51E, 0xD845, 0xD92A, 0xDB1A, 0xD8BB, 0xD83F, 0xDB76, 0xDE6F, 0xE282, 0xE495,
    0xE80B, 0xEB3E, 0xF303, 0xF4F7, 0xF9D2, 0xFA20, 0xFA01, 0xFCBD, 0xFEDF, 0x0435, 0x0C7E, 0x1630, 0x1E2B, 0x2709, 0x2FEA, 0x2F0A,
    0x335B, 0x2EC1, 0x2D34, 0x2DEF, 0x26FA, 0x23F1, 0x2094, 0x1CD2, 0x17E3, 0x12EA, 0x0BFF, 0x0A40, 0x046A, 0x0543, 0x0585, 0x09EC,
    0x0BE9, 0x0F8F, 0x0CC3, 0x1077, 0x0E0A, 0x0B85, 0x0CC8, 0x065D, 0x06B9, 0x0104, 0x02A8, 0x00BC, 0xFCC4, 0xF9FF, 0xFA18, 0xF5B7,
    0xF203, 0xEC9E, 0xE822, 0xE31C, 0xE214, 0xE160, 0xE27B, 0xE071, 0xE15F, 0xDF4D, 0xDCDE, 0xDC08, 0xD87F, 0xD8FA, 0xD61D, 0xD4D2,
    0xD126, 0xD1FD, 0xCDA7, 0xCFAD, 0xCBD7, 0xCE55, 0xCD73, 0xCD8D, 0xD0D3, 0xD062, 0xD325, 0xD301, 0xDAAE, 0xDEDE, 0xEA3C, 0xF437,
    0xFE4D, 0x09B6, 0x11DC, 0x1A68, 0x1EE5, 0x2125, 0x22F2, 0x2616, 0x2A4B, 0x2B8E, 0x2D07, 0x2EC7, 0x2D6C, 0x29E9, 0x2AF6, 0x2B51,
    0x2B77, 0x2D71, 0x2ED1, 0x3127, 0x32C2, 0x3337, 0x30A6, 0x3011, 0x2B58, 0x27BC, 0x2442, 0x1E96, 0x1899, 0x1279, 0x0F25, 0x0B17,
    0x0718, 0x039F, 0x01B4, 0xFD42, 0xFB55, 0xF7A1, 0xF326, 0xF2F7, 0xEEC3, 0xF090, 0xF229, 0xF2C9, 0xF3CB, 0xF26A, 0xF283, 0xF1A7,
    0xF224, 0xF013, 0xF0FB, 0xEDEA, 0xEB27, 0xEA43, 0xE8D8, 0xE7AC, 0xE565, 0xE437, 0xE27F, 0xE079, 0xDE03, 0xDAD3, 0xD29F, 0xD032,
    0xCE83, 0xCF6F, 0xD276, 0xD49B, 0xDC5E, 0xE03E, 0xE65F, 0xE99D, 0xEA18, 0xEBDE, 0xEBE3, 0xF21C, 0xF55F, 0xFA4B, 0xFE0E, 0x0116,
    0x068C, 0x0964, 0x0D32, 0x14DA, 0x1AAD, 0x2380, 0x2B1D, 0x3126, 0x392F, 0x3D46, 0x42C5, 0x4322, 0x42CA, 0x4317, 0x44A8, 0x4200,
    0x409F, 0x3B69, 0x3699, 0x3110, 0x2B27, 0x290E, 0x2242, 0x1E0E, 0x17C3, 0x12C0, 0x0B58, 0x05A4, 0x021F, 0xFECE, 0xFF35, 0xFC71,
    0xF9AA, 0xF953, 0xF674, 0xF23D, 0xF062, 0xEE3C, 0xED37, 0xEBD9, 0xE9CD, 0xE998, 0xE59C, 0xE7CC, 0xE51D, 0xE5DB, 0xE6C6, 0xE41B,
    0xE710, 0xE306, 0xE379, 0xDEE1, 0xDCED, 0xDF2F, 0xE164, 0xE685, 0xEB97, 0xF233, 0xF4DE, 0xF580, 0xF542, 0xF5A9, 0xF07B, 0xEE8A,
    0xEC09, 0xE91A, 0xE84B, 0xE1D0, 0xE00B, 0xDDAE, 0xDDB3, 0xDFF8, 0xE38E, 0xE9C0, 0xF06B, 0xF62A, 0xFD32, 0x01CB, 0x09CD, 0x0E60,
    0x11A8, 0x1531, 0x16C0, 0x193A, 0x18B3, 0x1DD5, 0x1B34, 0x1D01, 0x1DDA, 0x1FFF, 0x1F18, 0x1ED8, 0x2083, 0x1C65, 0x1C35, 0x1935,
    0x1829, 0x1742, 0x127A, 0x11C6, 0x0F83, 0x090F, 0x0722, 0xFEF1, 0xF99E, 0xF08C, 0xEB0F, 0xE59A, 0xDF35, 0xDD03, 0xD86E, 0xD6E6,
    0xD4A4, 0xD6C9, 0xD722, 0xD8D2, 0xD98B, 0xD9F5, 0xDBC5, 0xDB28, 0xDEAB, 0xE2A5, 0xE9D9, 0xF283, 0xF954, 0x0202, 0x0839, 0x0C77,
    0x10E5, 0x15AF, 0x1899, 0x1A39, 0x1C3D, 0x200C, 0x2283, 0x2287, 0x20FB, 0x1EB4, 0x1D35, 0x1BC7, 0x1C7B, 0x1E31, 0x1F6F, 0x1F70,
    0x2197, 0x206B, 0x1D67, 0x1BD0, 0x1964, 0x1766, 0x1219, 0x10AB, 0x0C28, 0x09EB, 0x034B, 0xFF74, 0x006A, 0xFBCA, 0xFAC5, 0xF90B,
    0xFBB6, 0xFBC4, 0xF7EB, 0xF48C, 0xF211, 0xEE94, 0xEDE7, 0xEBC7, 0xECC6, 0xEB44, 0xEC27, 0xEE0A, 0xEC1F, 0xEA77, 0xEA56, 0xEC18,
    0xECB8, 0xEDF3, 0xEE39, 0xF26F, 0xF359, 0xF5D8, 0xF48E, 0xF73C, 0xF37A, 0xF11E, 0xF445, 0xF152, 0xEFE8, 0xEF3D, 0xEB96, 0xEE59,
    0xEE1D, 0xF14B, 0xFD7F, 0x0122, 0x0938, 0x0C7A, 0x1220, 0x143B, 0x1B5C, 0x218B, 0x20D2, 0x22C8, 0x203F, 0x1F4A, 0x2009, 0x1F09,
    0x1FE1, 0x215E, 0x218F, 0x2434, 0x2440, 0x213D, 0x1BBA, 0x22F4, 0x298E, 0x267C, 0x250C, 0x26F9, 0x2663, 0x249C, 0x24F9, 0x1CC2,
    0x181F, 0x154C, 0x0EF7, 0x0AAE, 0x04EA, 0xFE7E, 0xFBBA, 0xF6A7, 0xEF6A, 0xE963, 0xDE9F, 0xD7D3, 0xD7D8, 0xD7FB, 0xD4F9, 0xD3E2,
    0xD3E5, 0xCFBF, 0xCDA6, 0xCD50, 0xCB8E, 0xCD10, 0xCEFE, 0xD0C8, 0xD478, 0xD74A, 0xDB3A, 0xDAAE, 0xD75E, 0xD452, 0xD1F7, 0xCFEC,
    0xD00D, 0xD3EF, 0xD839, 0xDED5, 0xE6DD, 0xEDC0, 0xF581, 0xFBE1, 0x03EE, 0x0A47, 0x0F97, 0x16B8, 0x19FF, 0x1DB8, 0x1D54, 0x1F81,
    0x1F9A, 0x1D76, 0x1CE5, 0x1AA7, 0x19EC, 0x199E, 0x1CB7, 0x1E05, 0x218A, 0x254E, 0x26DD, 0x2A7A, 0x2A39, 0x2B18, 0x2A3C, 0x2836,
    0x2812, 0x27B5, 0x286F, 0x2697, 0x25BB, 0x21DB, 0x1FD3, 0x1BD0, 0x1688, 0x133E, 0x10D6, 0x0E74, 0x0ABD, 0x0869, 0x02E4, 0x0071,
    0xFD01, 0xFA9C, 0xF91F, 0xF714, 0xF4E4, 0xF1B7, 0xEE5B, 0xEA11, 0xE795, 0xE71D, 0xE6EE, 0xE7D4, 0xEA0E, 0xE97A, 0xE8E7, 0xE60D,
    0xE19E, 0xDE1D, 0xD9E6, 0xD81D, 0xD66A, 0xD654, 0xD62B, 0xD725, 0xDAE8, 0xDAA1, 0xDE13, 0xE1D1, 0xE47B, 0xE9DC, 0xED03, 0xEF43,
    0xF16A, 0xF1C8, 0xF357, 0xF4E7, 0xF472, 0xF625, 0xF84D, 0xFA5E, 0xFB8E, 0xFF64, 0x0429, 0x096F, 0x10D1, 0x15C3, 0x1B74, 0x211E,
    0x25AF, 0x2A86, 0x2BC7, 0x2D18, 0x2D5D, 0x2DAD, 0x3075, 0x3139, 0x325B, 0x3105, 0x2D2C, 0x295A, 0x24F8, 0x20B0, 0x1D87, 0x1AF8,
    0x184F, 0x1544, 0x10DF, 0x0D5C, 0x0BF6, 0x0B75, 0x0B0E, 0x0B74, 0x0AD6, 0x095B, 0x053D, 0x008B, 0xFE5C, 0xFC18, 0xFC17, 0xFC07,
    0xFC76, 0xFD19, 0xFA9C, 0xF687, 0xF0BF, 0xE976, 0xE429, 0xE0F6, 0xDF4F, 0xDF8F, 0xDF9C, 0xE0FC, 0xE100, 0xE1FC, 0xE2C3, 0xE365,
    0xE5AC, 0xE71F, 0xEB5F, 0xEEE7, 0xF030, 0xF20D, 0xF207, 0xF1CD, 0xF116, 0xEDF1, 0xECAC, 0xEB87, 0xE947, 0xE8A5, 0xEAB3, 0xED01,
    0xF1D5, 0xF8D0, 0xFDE6, 0x03F1, 0x0780, 0x0B65, 0x0E7B, 0x10CF, 0x137D, 0x1580, 0x17A7, 0x17CD, 0x17D5, 0x1784, 0x16A5, 0x1478,
    0x132F, 0x113D, 0x0E84, 0x0D66, 0x0BE3, 0x08F7, 0x07BF, 0x044F, 0x0212, 0x0233, 0x0202, 0x01DC, 0x0071, 0xFF59, 0xFB7A, 0xF897,
    0xF428, 0xF0FD, 0xF0C1, 0xEFF0, 0xF145, 0xF253, 0xEFE6, 0xEDE6, 0xE91E, 0xE4C1, 0xE206, 0xE153, 0xE33D, 0xE468, 0xE7A6, 0xEA94,
    0xED12, 0xF012, 0xF4C9, 0xF6ED, 0xFD4B, 0x0242, 0x0603, 0x0A1B, 0x0C06, 0x0DDF, 0x0DF1, 0x0DDE, 0x0CE4, 0x0E5C, 0x0D53, 0x0D88,
    0x0EBB, 0x0EBF, 0x0EF8, 0x1290, 0x14AB, 0x1709, 0x1AB4, 0x1B07, 0x1D68, 0x1EDA, 0x209A, 0x20FC, 0x2160, 0x211E, 0x20D7, 0x20E7,
    0x1EA6, 0x1CDB, 0x19A3, 0x1678, 0x125D, 0x0F26, 0x0C4B, 0x0939, 0x07AF, 0x0420, 0x0055, 0xFD72, 0xFA04, 0xF6C9, 0xF3AF, 0xEF94,
    0xEC19, 0xE809, 0xE27F, 0xDD6B, 0xDAE1, 0xD903, 0xDB58, 0xDF9C, 0xE1A1, 0xE56C, 0xE69D, 0xE5FC, 0xE562, 0xE3D1, 0xE219, 0xE0F4,
    0xE10E, 0xE2CB, 0xE428, 0xE7BD, 0xEBF4, 0xF049, 0xF3C4, 0xF663, 0xF9E7, 0xFC40, 0x0014, 0x047F, 0x079F, 0x09E4, 0x0C07, 0x0DE7,
    0x1060, 0x1250, 0x1600, 0x1785, 0x1888, 0x1AB2, 0x1CBA, 0x1F76, 0x2195, 0x23F5, 0x24EC, 0x25A6, 0x25AB, 0x259F, 0x2539, 0x2543,
    0x2424, 0x2209, 0x1F59, 0x1CEA, 0x1AD4, 0x16F4, 0x1448, 0x1217, 0x0F70, 0x0BFA, 0x07E5, 0x02E7, 0xFDBD, 0xF9B6, 0xF5C9, 0xF245,
    0xEF6D, 0xED9F, 0xEA91, 0xE709, 0xE22D, 0xDB9B, 0xD5E9, 0xD052, 0xCCCD, 0xCA81, 0xC915, 0xCA21, 0xCD10, 0xCF8D, 0xD1CD, 0xD419,
    0xD40C, 0xD3AE, 0xD456, 0xD4C5, 0xD53A, 0xD677, 0xD838, 0xD9CB, 0xDC0B, 0xDD79, 0xE04D, 0xE459, 0xE946, 0xEEA4, 0xF3DD, 0xFAE8,
    0x0099, 0x05EE, 0x09A9, 0x0D4F, 0x1048, 0x11A0, 0x131F, 0x1493, 0x16C4, 0x190A, 0x1B07, 0x1C32, 0x1E70, 0x1FAB, 0x200F, 0x20B2,
    0x1FDA, 0x1F2A, 0x1FE0, 0x2157, 0x22DD, 0x2314, 0x2368, 0x2203, 0x22BC, 0x238F, 0x2216, 0x227C, 0x2165, 0x1FD0, 0x1CDB, 0x18C9,
    0x13D9, 0x0F16, 0x0C3F, 0x0A2B, 0x07FD, 0x06E6, 0x03D1, 0xFF9C, 0xFB91, 0xF5A2, 0xF168, 0xEE1E, 0xEB09, 0xE997, 0xE906, 0xE9B1,
    0xEACD, 0xEA16, 0xE96A, 0xE84C, 0xE659, 0xE4CF, 0xE2EF, 0xE0BB, 0xDF1F, 0xDC38, 0xDB26, 0xDA44, 0xD8D7, 0xD969, 0xD945, 0xDAFF,
    0xDC7E, 0xDE89, 0xE156, 0xE4F0, 0xE91F, 0xEE06, 0xF100, 0xF275, 0xF392, 0xF349, 0xF3A0, 0xF4B4, 0xF6CA, 0xF87B, 0xFB43, 0xFDD1,
    0x013A, 0x0556, 0x0968, 0x0D01, 0x1136, 0x15ED, 0x1943, 0x1E72, 0x225C, 0x258E, 0x28B0, 0x2AE9, 0x2B6E, 0x2B5C, 0x2B8A, 0x2BBA,
    0x2C55, 0x2B75, 0x28D0, 0x23B9, 0x1DD7, 0x1728, 0x12C2, 0x0F83, 0x0D23, 0x0AC8, 0x07BD, 0x0377, 0xFE9C, 0xFA88, 0xF7D0, 0xF7E4,
    0xF7CC, 0xFABB, 0xFDF2, 0x0092, 0x024F, 0x03A4, 0x039C, 0x0219, 0x00FE, 0xFE59, 0xFBA8, 0xF917, 0xF62E, 0xF182, 0xEE1C, 0xEBA3,
    0xE903, 0xE771, 0xE684, 0xE662, 0xE6EA, 0xE825, 0xE94F, 0xEAE5, 0xEB79, 0xEC14, 0xEC1E, 0xEB46, 0xEA0C, 0xE8C8, 0xE805, 0xE667,
    0xE6E9, 0xE82B, 0xE8DE, 0xE993, 0xE9C5, 0xEA12, 0xEAE0, 0xECEA, 0xEFEB, 0xF402, 0xF9CA, 0xFF8D, 0x041D, 0x0861, 0x0C0A, 0x0E37,
    0x119A, 0x1425, 0x1633, 0x18B0, 0x18C9, 0x17EF, 0x1614, 0x13F4, 0x114C, 0x0F59, 0x0DED, 0x0DE1, 0x0E65, 0x0E58, 0x0C4B, 0x0918,
    0x0451, 0xFEE8, 0xFADC, 0xF6FD, 0xF6CE, 0xF6E4, 0xF819, 0xF9E5, 0xF9DC, 0xF85D, 0xF602, 0xF3BD, 0xF0BE, 0xEEF7, 0xED8B, 0xEC46,
    0xEA04, 0xE768, 0xE556, 0xE468, 0xE42E, 0xE3F4, 0xE4EC, 0xE730, 0xE9D6, 0xEDD2, 0xF26B, 0xF58A, 0xFA43, 0xFEB1, 0x023A, 0x04FF,
    0x060E, 0x0552, 0x04DF, 0x050D, 0x05C9, 0x0790, 0x0A4A, 0x0CDD, 0x0EBE, 0x1096, 0x120D, 0x1498, 0x1790, 0x1A22, 0x1C61, 0x1E4D,
    0x1FB9, 0x2119, 0x21B5, 0x21BD, 0x225E, 0x2364, 0x2360, 0x2281, 0x2189, 0x1E22, 0x1A33, 0x1568, 0x0EBB, 0x0A30, 0x087F, 0x073D,
    0x0836, 0x0852, 0x06E0, 0x0449, 0xFF3D, 0xF9A9, 0xF3DC, 0xEF1E, 0xEC23, 0xEAE4, 0xE9D8, 0xE8F3, 0xE808, 0xE6C3, 0xE6A0, 0xE6C2,
    0xE703, 0xE711, 0xE74F, 0xE7DD, 0xE813, 0xE82D, 0xE827, 0xE87A, 0xE8C9, 0xE8AD, 0xE8D5, 0xEA8D, 0xEDBC, 0xF0D8, 0xF4D3, 0xF89A,
    0xFBB0, 0xFF16, 0x014A, 0x02D0, 0x0387, 0x03D6, 0x03CB, 0x04FA, 0x07A6, 0x0AE7, 0x10AD, 0x1629, 0x1B37, 0x2029, 0x2457, 0x286E,
    0x2D13, 0x3085, 0x32D5, 0x3487, 0x3429, 0x33AB, 0x3300, 0x32B2, 0x31ED, 0x31BA, 0x31FE, 0x2FD6, 0x2C30, 0x2678, 0x1FE4, 0x1976,
    0x13CB, 0x0F23, 0x0C0E, 0x0A28, 0x07E3, 0x0645, 0x0241, 0xFCFD, 0xF6B5, 0xEFDB, 0xEA83, 0xE5EB, 0xE379, 0xE17F, 0xE004, 0xDE3E,
    0xDC5A, 0xDA13, 0xD6B5, 0xD4A9, 0xD218, 0xD0C2, 0xD178, 0xD236, 0xD31C, 0xD359, 0xD490, 0xD4B1, 0xD56D, 0xD6DB, 0xD776, 0xD945,
    0xDBAA, 0xDE4B, 0xE1B6, 0xE5F5, 0xEA5D, 0xEF7D, 0xF38C, 0xF766, 0xFB0B, 0xFCD5, 0xFFAC, 0x030B, 0x0775, 0x0DA9, 0x139A, 0x1804,
    0x1AEC, 0x1F05, 0x2430, 0x28F1, 0x2CBA, 0x302D, 0x326A, 0x32FF, 0x328D, 0x31A4, 0x31A6, 0x30C7, 0x31A9, 0x3297, 0x3222, 0x328D,
    0x30B1, 0x2D86, 0x2977, 0x256E, 0x230B, 0x205A, 0x1F70, 0x1F1A, 0x1E4F, 0x1B80, 0x17C4, 0x1390, 0x0D3F, 0x076A, 0x01E6, 0xFCB4,
    0xF8C9, 0xF6EF, 0xF5E2, 0xF610, 0xF5BC, 0xF48F, 0xF36B, 0xF1D9, 0xF0C1, 0xEF85, 0xEDC4, 0xECFD, 0xEBEB, 0xEA3B, 0xE918, 0xE79F,
    0xE615, 0xE478, 0xE2FA, 0xE125, 0xE061, 0xE0BE, 0xE29D, 0xE464, 0xE5D8, 0xE7AE, 0xE85F, 0xEA73, 0xEC1A, 0xED66, 0xEFAB, 0xF1FC,
    0xF2A6, 0xF424, 0xF52A, 0xF6C4, 0xF95F, 0xFADA, 0xFDCB, 0x00AF, 0x0519, 0x091A, 0x0D52, 0x112C, 0x138B, 0x168E, 0x1912, 0x1C7E,
    0x2171, 0x2658, 0x2B1B, 0x2EF8, 0x3143, 0x319F, 0x2FFF, 0x2DF2, 0x2CF7, 0x2DA5, 0x2E38, 0x2EFB, 0x2E85, 0x2D34, 0x2AE7, 0x2677,
    0x2145, 0x1B2B, 0x150F, 0x0FFB, 0x0BBE, 0x080D, 0x069C, 0x0627, 0x0617, 0x06D2, 0x076D, 0x0920, 0x0A91, 0x0B70, 0x0BC8, 0x0BE6,
    0x0B47, 0x0AB8, 0x08FA, 0x0523, 0x0146, 0xFCE0, 0xF92B, 0xF595, 0xF20E, 0xF065, 0xF00C, 0xEFE8, 0xEFCE, 0xEF72, 0xEF0F, 0xEE81,
    0xEEDE, 0xEFB7, 0xEF52, 0xEF2F, 0xEF23, 0xEE4F, 0xEEA1, 0xEED7, 0xEFD9, 0xF250, 0xF572, 0xF8FD, 0xFAFB, 0xFC5D, 0xFB88, 0xFA3E,
    0xF978, 0xF944, 0xFB25, 0xFECF, 0x0358, 0x07FF, 0x0BEE, 0x0E39, 0x0F9A, 0x0EF4, 0x0CB0, 0x0B09, 0x0A46, 0x0A1A, 0x0AAE, 0x0BAE,
    0x0C71, 0x0CB2, 0x0C79, 0x0B3F, 0x09A5, 0x06AB, 0x0397, 0x0135, 0xFF7C, 0xFF0D, 0xFF3D, 0x00C5, 0x01A9, 0x0366, 0x049C, 0x04F1,
    0x0587, 0x044C, 0x029C, 0x00D6, 0xFEB1, 0xFCCE, 0xFACB, 0xF7E1, 0xF51B, 0xF19F, 0xEEF6, 0xEDEF, 0xED89, 0xEE74, 0xF0E2, 0xF3B0,
    0xF55E, 0xF7D0, 0xFA19, 0xFB50, 0xFD53, 0xFF9E, 0x00EF, 0x02A1, 0x044D, 0x04C9, 0x045A, 0x0513, 0x0706, 0x0A2B, 0x0E87, 0x125F,
    0x15AB, 0x1764, 0x1849, 0x17D6, 0x17B6, 0x17F5, 0x1903, 0x1BF8, 0x1E46, 0x217E, 0x23C7, 0x24B9, 0x24FA, 0x23D7, 0x20C3, 0x1D14,
    0x1A30, 0x17A1, 0x15E8, 0x13BE, 0x1179, 0x0EB3, 0x0B18, 0x084E, 0x05B3, 0x02C1, 0x0019, 0xFDA1, 0xFAA8, 0xF820, 0xF5BE, 0xF456,
    0xF2D9, 0xF18F, 0xF019, 0xED7B, 0xEB1D, 0xE855, 0xE60F, 0xE4E6, 0xE4AC, 0xE3E6, 0xE2D8, 0xE0F0, 0xDF47, 0xDE17, 0xDE36, 0xE01D,
    0xE30D, 0xE674, 0xEA00, 0xEDEE, 0xF1F2, 0xF5BD, 0xF858, 0xFB87, 0xFE20, 0x019B, 0x0506, 0x06BB, 0x07D1, 0x0822, 0x0836, 0x08EC,
    0x0B12, 0x0EEC, 0x147F, 0x1A68, 0x2047, 0x24DE, 0x282A, 0x2B0F, 0x2DBB, 0x2FFF, 0x330E, 0x366E, 0x39DA, 0x3BAE, 0x3BFC, 0x3B1A,
    0x38A0, 0x35E3, 0x323B, 0x2E95, 0x2A8A, 0x271B, 0x2345, 0x1F3F, 0x1B42, 0x165D, 0x1150, 0x0C25, 0x07AD, 0x0314, 0xFE5E, 0xF96D,
    0xF490, 0xF01A, 0xEBD4, 0xE871, 0xE66A, 0xE473, 0xE296, 0xE069, 0xDD9B, 0xDB0E, 0xD85B, 0xD580, 0xD2B3, 0xD085, 0xCF1D, 0xCE34,
    0xCD34, 0xCBEB, 0xCB38, 0xCC15, 0xCDC7, 0xD04C, 0xD33C, 0xD5D8, 0xD8BE, 0xDB79, 0xDE91, 0xE16C, 0xE533, 0xE8CE, 0xEC30, 0xEF1D,
    0xF0AE, 0xF244, 0xF3BE, 0xF69C, 0xFAC3, 0x016E, 0x0952, 0x112D, 0x1815, 0x1DA5, 0x2133, 0x23C3, 0x2699, 0x2935, 0x2C70, 0x2FC1,
    0x333C, 0x358F, 0x3694, 0x3626, 0x34E3, 0x32FD, 0x3118, 0x2EDF, 0x2D3E, 0x2BE8, 0x2AEB, 0x29CC, 0x2887, 0x26D8, 0x241E, 0x2234,
    0x1EE8, 0x1C0D, 0x17D1, 0x134E, 0x0F96, 0x0B7E, 0x07B5, 0x0470, 0x0184, 0xFEB2, 0xFC22, 0xF95E, 0xF714, 0xF44F, 0xF228, 0xEFE8,
    0xED86, 0xEC0D, 0xEA2A, 0xE80E, 0xE576, 0xE287, 0xE11D, 0xE14E, 0xE2F2, 0xE45A, 0xE562, 0xE61A, 0xE535, 0xE4C8, 0xE4E7, 0xE4C5,
    0xE5DF, 0xE6B5, 0xE671, 0xE71F, 0xE72B, 0xE74D, 0xE7F9, 0xE9FB, 0xECC7, 0xF07D, 0xF542, 0xF8C0, 0xFC0D, 0xFDA7, 0xFDA6, 0xFE07,
    0xFEBF, 0x006E, 0x0390, 0x0803, 0x0D30, 0x11D3, 0x14BD, 0x1668, 0x1753, 0x1810, 0x1A19, 0x1C64, 0x1FEE, 0x236A, 0x269A, 0x28DF,
    0x29D3, 0x29D2, 0x2946, 0x2819, 0x261F, 0x236C, 0x202F, 0x1C6D, 0x187E, 0x150B, 0x116A, 0x0E83, 0x0B84, 0x088B, 0x062E, 0x0394,
    0x022A, 0x0196, 0x016F, 0x0213, 0x01A8, 0x0196, 0x0141, 0x0022, 0xFFA0, 0xFE65, 0xFD6C, 0xFD37, 0xFD89, 0xFDC9, 0xFE05, 0xFE3D,
    0xFD6A, 0xFCF4, 0xFC07, 0xFA94, 0xF999, 0xF82F, 0xF674, 0xF409, 0xF15D, 0xEE78, 0xECA3, 0xEB90, 0xEC6C, 0xEE83, 0xF0B5, 0xF2EF,
    0xF3D4, 0xF425, 0xF365, 0xF1EA, 0xF170, 0xF156, 0xF145, 0xF1F9, 0xF2AA, 0xF36F, 0xF420, 0xF440, 0xF489, 0xF52C, 0xF623, 0xF850,
    0xFA4E, 0xFBF3, 0xFE1A, 0xFFD7, 0x016D, 0x0298, 0x033D, 0x02D9, 0x0218, 0x010A, 0x002D, 0xFF88, 0xFE53, 0xFDBF, 0xFC99, 0xFBBC,
    0xFB57, 0xFAE7, 0xFA87, 0xFAB1, 0xFB2D, 0xFC34, 0xFDCC, 0xFE51, 0xFE68, 0xFCBB, 0xFA3C, 0xF76A, 0xF428, 0xF167, 0xEF3B, 0xED39,
    0xEC2F, 0xEC4C, 0xEC1B, 0xEC8D, 0xED4C, 0xEE9B, 0xF0D0, 0xF37F, 0xF645, 0xF7FC, 0xF8DF, 0xF8E7, 0xF82D, 0xF72E, 0xF6F9, 0xF86F,
    0xFB72, 0x0006, 0x03B0, 0x078D, 0x0A9B, 0x0C77, 0x0E8D, 0x0FCE, 0x11A0, 0x1419, 0x16C7, 0x1938, 0x1BEC, 0x1E40, 0x1F63, 0x2047,
    0x2068, 0x1F9D, 0x1F2A, 0x1F92, 0x2075, 0x2140, 0x2167, 0x20DA, 0x1F4F, 0x1C9D, 0x1981, 0x157B, 0x10B0, 0x0BBE, 0x06DB, 0x0293,
    0xFE77, 0xFBB2, 0xF914, 0xF689, 0xF3AE, 0xF009, 0xECE4, 0xEA4E, 0xE95E, 0xE85E, 0xE82C, 0xE724, 0xE53B, 0xE29E, 0xDE6F, 0xDB92,
    0xD99F, 0xD86D, 0xD839, 0xD859, 0xD842, 0xD903, 0xDACF, 0xDD9B, 0xE106, 0xE5FF, 0xEAFF, 0xF068, 0xF4FB, 0xF7AE, 0xF8DC, 0xF839,
    0xF6DF, 0xF651, 0xF6FB, 0xF8ED, 0xFC4F, 0xFF93, 0x026F, 0x0504, 0x0733, 0x0899, 0x09A2, 0x0B80, 0x0ECC, 0x134F, 0x187B, 0x1DC5,
    0x235B, 0x2812, 0x2C2A, 0x2FB8, 0x324F, 0x3399, 0x346B, 0x35A1, 0x3610, 0x3664, 0x3675, 0x3636, 0x351B, 0x3349, 0x3034, 0x2B39,
    0x2545, 0x1E00, 0x1674, 0x0FE6, 0x0A57, 0x05F8, 0x01F7, 0xFDC7, 0xF951, 0xF55F, 0xF21D, 0xEEB3, 0xEBA8, 0xE8FD, 0xE5EB, 0xE2B2,
    0xDED5, 0xD9D5, 0xD46D, 0xCF1D, 0xCAF8, 0xC882, 0xC719, 0xC683, 0xC60C, 0xC5C0, 0xC683, 0xC79E, 0xC964, 0xCC94, 0xD015, 0xD3F8,
    0xD6C6, 0xD845, 0xD8BF, 0xD7C5, 0xD73D, 0xD71D, 0xD839, 0xDADE, 0xDE46, 0xE314, 0xE783, 0xEBC9, 0xF00B, 0xF436, 0xF8BD, 0xFDE1,
    0x049C, 0x0BC3, 0x11E4, 0x181A, 0x1E23, 0x2285, 0x271F, 0x29F1, 0x2B94, 0x2CDE, 0x2C80, 0x2C70, 0x2CB9, 0x2CE9, 0x2D5F, 0x2D90,
    0x2DD0, 0x2D15, 0x2B78, 0x2933, 0x2594, 0x21F1, 0x1E89, 0x1B1E, 0x1855, 0x1569, 0x1255, 0x0FC0, 0x0C12, 0x09CA, 0x0733, 0x0505,
    0x0457, 0x0325, 0x0275, 0x00FA, 0xFECB, 0xFB71, 0xF6F7, 0xF261, 0xEE8C, 0xEB70, 0xEA78, 0xE95F, 0xE7AB, 0xE66B, 0xE53E, 0xE630,
    0xE8E2, 0xEBF0, 0xF015, 0xF35C, 0xF477, 0xF456, 0xF1C7, 0xED5E, 0xE880, 0xE48E, 0xE243, 0xE1BC, 0xE26C, 0xE3C4, 0xE5C5, 0xE760,
    0xE8A1, 0xEA66, 0xEC09, 0xEDC5, 0xF0BD, 0xF3DE, 0xF71A, 0xFA8B, 0xFD74, 0xFF7D, 0x009B, 0x016E, 0x029C, 0x0414, 0x0559, 0x060B,
    0x06F2, 0x08F9, 0x0BFB, 0x0FD8, 0x1400, 0x1798, 0x1B04, 0x1D3D, 0x1DBA, 0x1E2E, 0x1DED, 0x1D46, 0x1C80, 0x1A66, 0x17EF, 0x14E3,
    0x118E, 0x0E9E, 0x0BF3, 0x0ACD, 0x09D9, 0x08AF, 0x0747, 0x0586, 0x037B, 0x00D3, 0xFDF8, 0xFB44, 0xF950, 0xF826, 0xF763, 0xF6F2,
    0xF737, 0xF6F5, 0xF7CF, 0xFA6D, 0xFD38, 0x0192, 0x0619, 0x0A22, 0x0C74, 0x0CAD, 0x0AEE, 0x0712, 0x02A6, 0xFE39, 0xFABD, 0xF89D,
    0xF711, 0xF682, 0xF687, 0xF665, 0xF623, 0xF663, 0xF765, 0xF848, 0xF9C3, 0xFB15, 0xFC3A, 0xFCD4, 0xFDE1, 0xFE98, 0xFE07, 0xFD85,
    0xFC75, 0xFB66, 0xF993, 0xF7DF, 0xF6BB, 0xF66B, 0xF76E, 0xF86D, 0xF93C, 0xFA2B, 0xF9AC, 0xF891, 0xF833, 0xF6B8, 0xF5FD, 0xF54B,
    0xF428, 0xF2F7, 0xF179, 0xF064, 0xEF03, 0xEE4B, 0xEE97, 0xEF5C, 0xF0A3, 0xF25C, 0xF3A9, 0xF422, 0xF405, 0xF3E6, 0xF3E3, 0xF362,
    0xF312, 0xF22B, 0xF147, 0xF0BA, 0xEF28, 0xED55, 0xEC69, 0xEBD7, 0xECB4, 0xEF18, 0xF1A6, 0xF457, 0xF621, 0xF6F0, 0xF635, 0xF4A0,
    0xF39C, 0xF291, 0xF2D4, 0xF418, 0xF5D3, 0xF7E3, 0xF982, 0xFA9A, 0xFB7C, 0xFD63, 0xFF3D, 0x0206, 0x06CF, 0x0BCB, 0x113C, 0x16B7,
    0x1A83, 0x1CEF, 0x1E72, 0x1F2C, 0x1EFD, 0x1E90, 0x1E92, 0x1E95, 0x1F09, 0x1FA9, 0x20EB, 0x229C, 0x245C, 0x2558, 0x24B4, 0x2364,
    0x2126, 0x1E3B, 0x1A6E, 0x15F6, 0x1159, 0x0C59, 0x074F, 0x022F, 0xFE4E, 0xFBC6, 0xFA7A, 0xFA8E, 0xFABE, 0xF9C6, 0xF86E, 0xF66E,
    0xF3C7, 0xF1AA, 0xEFE8, 0xEDF7, 0xEB5A, 0xE80E, 0xE3F2, 0xDF1E, 0xDB44, 0xD856, 0xD609, 0xD58F, 0xD624, 0xD84A, 0xDC00, 0xDFB3,
    0xE26C, 0xE374, 0xE3B8, 0xE437, 0xE469, 0xE4A1, 0xE50C, 0xE62B, 0xE85F, 0xEA42, 0xEB97, 0xECFE, 0xEE32, 0xEF67, 0xF1F1, 0xF610,
    0xFA9A, 0xFF5F, 0x050B, 0x0AB0, 0x0F9E, 0x1500, 0x1A3B, 0x1E1C, 0x2094, 0x22C7, 0x2549, 0x2843, 0x2B64, 0x2E47, 0x314E, 0x3492,
    0x3725, 0x38CE, 0x3A62, 0x39AF, 0x37CC, 0x35F2, 0x32FC, 0x2E31, 0x281D, 0x218F, 0x1954, 0x1082, 0x08BF, 0x0316, 0xFFB4, 0xFD8E,
    0xFBF6, 0xFB12, 0xFA0E, 0xF895, 0xF745, 0xF464, 0xF12E, 0xEDB0, 0xE95A, 0xE425, 0xDE4F, 0xD876, 0xD30F, 0xCF76, 0xCD6A, 0xCD51,
    0xCF34, 0xD1F0, 0xD546, 0xD845, 0xDA4D, 0xDB4C, 0xDB75, 0xDAD6, 0xDA09, 0xD93F, 0xD865, 0xD7FA, 0xD7CF, 0xD7AC, 0xD77D, 0xD885,
    0xD9CE, 0xDB05, 0xDD58, 0xE06B, 0xE480, 0xE98D, 0xEFB7, 0xF773, 0xFF3D, 0x06D7, 0x0D76, 0x1295, 0x16EC, 0x1A92, 0x1E2A, 0x2211,
    0x24E8, 0x2795, 0x2A04, 0x2B8D, 0x2CD3, 0x2D98, 0x2D97, 0x2D97, 0x2DC4, 0x2D74, 0x2C0D, 0x2980, 0x25D7, 0x20D5, 0x1B8E, 0x16DD,
    0x1278, 0x0F78, 0x0D7B, 0x0BE6, 0x0ACD, 0x0990, 0x0926, 0x086C, 0x07EA, 0x0752, 0x0670, 0x061E, 0x0509, 0x0187, 0xFC5D, 0xF5FC,
    0xEFA2, 0xEAC1, 0xE7DD, 0xE768, 0xE8F4, 0xEBE0, 0xEEDF, 0xF1D0, 0xF448, 0xF60F, 0xF606, 0xF654, 0xF5C6, 0xF3DA, 0xF21E, 0xEF60,
    0xECD3, 0xEA77, 0xE847, 0xE6F3, 0xE5ED, 0xE52B, 0xE51E, 0xE5EE, 0xE88C, 0xEC6B, 0xF0A2, 0xF5F0, 0xFB63, 0x0010, 0x0487, 0x0729,
    0x094A, 0x0A18, 0x0A2D, 0x0B2A, 0x0BB6, 0x0CA9, 0x0DE9, 0x0F1D, 0x1047, 0x10EE, 0x11E4, 0x12FC, 0x1378, 0x1499, 0x1501, 0x147B,
    0x1339, 0x119A, 0x101D, 0x0E63, 0x0DAA, 0x0CFD, 0x0C3C, 0x0C14, 0x0AA6, 0x0951, 0x081D, 0x06C5, 0x06B8, 0x0720, 0x0722, 0x06B0,
    0x061A, 0x03CD, 0xFFBF, 0xFAD8, 0xF5ED, 0xF250, 0xF07E, 0xF062, 0xF207, 0xF536, 0xF9A1, 0xFE20, 0x0170, 0x04C7, 0x06FF, 0x081B,
    0x093B, 0x09A0, 0x08F0, 0x06F8, 0x0469, 0x01DC, 0xFEB1, 0xFB4C, 0xF81C, 0xF53B, 0xF327, 0xF2A9, 0xF3B8, 0xF643, 0xFA9E, 0xFFBA,
    0x04F1, 0x090B, 0x0B05, 0x0B7E, 0x0AA8, 0x0903, 0x0785, 0x062E, 0x05B0, 0x057D, 0x04D7, 0x03F1, 0x02E8, 0x01FB, 0x01AB, 0x0160,
    0x016C, 0x0139, 0x0032, 0xFDFB, 0xFAE4, 0xF76B, 0xF3E8, 0xF181, 0xEF71, 0xEF26, 0xEFD4, 0xEFDE, 0xEFD9, 0xEF9A, 0xF076, 0xF2B1,
    0xF54F, 0xF86E, 0xFB87, 0xFCC0, 0xFDBC, 0xFD36, 0xFABE, 0xF70A, 0xF21F, 0xEE47, 0xEBEC, 0xEBCD, 0xECDC, 0xEE6D, 0xEFF6, 0xF120,
    0xF1E3, 0xF283, 0xF2CC, 0xF30C, 0xF301, 0xF36F, 0xF3FA, 0xF288, 0xF1B4, 0xF156, 0xF0E3, 0xF0E3, 0xF0C7, 0xF104, 0xF1D9, 0xF2E6,
    0xF505, 0xF90D, 0xFEAA, 0x0585, 0x0BFE, 0x12A6, 0x17AB, 0x1BBB, 0x1F23, 0x212E, 0x221A, 0x214A, 0x210B, 0x20A7, 0x1FF5, 0x1F3B,
    0x1F39, 0x1FE2, 0x2089, 0x2348, 0x2582, 0x26FA, 0x2702, 0x258A, 0x21F0, 0x1D6F, 0x1923, 0x1440, 0x10D1, 0x0D36, 0x0A69, 0x06F5,
    0x041F, 0x0191, 0x0069, 0x00A2, 0x021D, 0x0444, 0x0503, 0x0560, 0x03DA, 0xFFF9, 0xFBB0, 0xF5CC, 0xF05E, 0xEC6C, 0xE8F3, 0xE701,
    0xE5B4, 0xE582, 0xE3BC, 0xE3B1, 0xE1CA, 0xE22E, 0xE00C, 0xDED3, 0xDF22, 0xDE82, 0xDA6C, 0xDC1D, 0xE185, 0xE475, 0xFDDF, 0xFD91,
    0xF500, 0xF6CE, 0xEC36, 0xE99C, 0xE22C, 0xDD4F, 0xDA41, 0xDCA4, 0xE00A, 0xE92A, 0xEE6E, 0xDC49, 0xDBB5, 0xD740, 0xDD01, 0xEBD8,
    0xEAB3, 0xF09E, 0xFA01, 0xFC5E, 0x01B2, 0x0EC5, 0x115F, 0x12E7, 0x1C0D, 0x1E3C, 0x2013, 0x24E8, 0x090F, 0xFD58, 0xFFEE, 0xFDF3,
    0x0750, 0x0731, 0x0744, 0x0E66, 0x1160, 0x0FF8, 0x174E, 0x11E5, 0x1875, 0x342E, 0x3CB8, 0x4481, 0x464B, 0x33E4, 0x266E, 0x1962,
    0x064F, 0xF68F, 0xE9F8, 0xDDD0, 0xDE2C, 0xD125, 0xC441, 0xC266, 0xBD46, 0xC67D, 0xCCDE, 0xC9FC, 0xD2EF, 0xDAD6, 0xD893, 0xDD22,
    0xE14F, 0xDEEB, 0xDD05, 0xDC78, 0xD3B3, 0xDA83, 0xD154, 0xBD63, 0xBBCA, 0xB9B8, 0xC1CF, 0xCB51, 0xD114, 0xDC8C, 0xEBC7, 0xF370,
    0x02C7, 0x0EAE, 0x0EE5, 0x24EB, 0x3B4C, 0x45CD, 0x531C, 0x50C8, 0x48DA, 0x454A, 0x3EA8, 0x357C, 0x3193, 0x2847, 0x28AB, 0x28B3,
    0x17EE, 0x0EC8, 0x028D, 0xFCDA, 0x05A7, 0x0390, 0xFF47, 0x05E4, 0x04D4, 0x020C, 0x04CE, 0x06F6, 0x01C3, 0x05B7, 0xFF6B, 0xFF7E,
    0x082B, 0xF69F, 0xE7F5, 0xDBFA, 0xD4D0, 0xD637, 0xD55A, 0xD1F2, 0xD601, 0xD523, 0xD268, 0xD906, 0xD280, 0xD0DD, 0xE013, 0xE6D5,
    0xF005, 0xF676, 0xECEA, 0xDFC2, 0xD451, 0xC2E1, 0xB7A0, 0xAC28, 0xA1F8, 0xA351, 0x9BAD, 0x95ED, 0x9387, 0x9091, 0x9521, 0x9BE2,
    0x9C69, 0xA21A, 0xA8EA, 0xACA6, 0xB1F1, 0xBA10, 0xBBEB, 0xC397, 0xCAA4, 0xC87F, 0xD5E1, 0xD95A, 0xD396, 0xD132, 0xD1DE, 0xDBA6,
    0xEB5A, 0xF6FC, 0x0609, 0x1AA9, 0x2513, 0x35AA, 0x44FC, 0x4414, 0x4E39, 0x5CAC, 0x65B1, 0x7072, 0x752D, 0x724D, 0x7124, 0x6D7D,
    0x689C, 0x67CF, 0x60D6, 0x61A6, 0x64BC, 0x6009, 0x5CB1, 0x5489, 0x4B6B, 0x4F70, 0x4E92, 0x4927, 0x4BE1, 0x4FDE, 0x4E66, 0x5246,
    0x5604, 0x5529, 0x5B6D, 0x56BE, 0x57A2, 0x5FD9, 0x5F74, 0x5C2C, 0x5708, 0x5346, 0x5583, 0x57AC, 0x54B5, 0x574E, 0x5723, 0x544E,
    0x5B1C, 0x58F0, 0x53E3, 0x5753, 0x5C09, 0x619C, 0x6876, 0x694D, 0x6585, 0x62C0, 0x5AA8, 0x5625, 0x4CCA, 0x417D, 0x3E0F, 0x37CA,
    0x30FC, 0x2C20, 0x204B, 0x1AE9, 0x1C95, 0x1A11, 0x1692, 0x17C0, 0x1695, 0x1201, 0x13FB, 0x0D86, 0x0B90, 0x0738, 0xF8ED, 0xF340,
    0xEEE9, 0xE6D8, 0xDB76, 0xCE6F, 0xC69F, 0xC714, 0xC5A9, 0xC562, 0xC9A8, 0xC761, 0xC95A, 0xCD7A, 0xC969, 0xC607, 0xC6CF, 0xC865,
    0xCD91, 0xD356, 0xD176, 0xD048, 0xCADC, 0xC648, 0xC422, 0xBC50, 0xB898, 0xB8D4, 0xB799, 0xB86B, 0xB4B5, 0xAE82, 0xAE63, 0xAFDF,
    0xAF4D, 0xAFBA, 0xB37A, 0xB2EF, 0xB6D0, 0xB90C, 0xB99C, 0xBF47, 0xBE87, 0xBD7A, 0xC207, 0xC6BC, 0xC85D, 0xC6CA, 0xC131, 0xC010,
    0xC309, 0xC215, 0xC6AB, 0xCA5F, 0xCB0F, 0xD33A, 0xD8F7, 0xD91E, 0xDB5A, 0xDFEC, 0xE59A, 0xF239, 0xFBC0, 0x020C, 0x04E1, 0x009C,
    0xFEAE, 0xF867, 0xED20, 0xE774, 0xE3B2, 0xE22D, 0xE353, 0xDDD0, 0xD86C, 0xDA85, 0xDF06, 0xE0D6, 0xE819, 0xEBFB, 0xEF24, 0xF5E2,
    0xF511, 0xF890, 0xFCF7, 0xF9A7, 0xF75F, 0xFA55, 0xFD61, 0xFDD4, 0xF827, 0xEE7A, 0xED67, 0xED31, 0xEEAB, 0xF81D, 0xFCA1, 0x03EB,
    0x10BD, 0x19AF, 0x1CCB, 0x2092, 0x23C0, 0x2C7F, 0x393F, 0x4216, 0x4A31, 0x4AAE, 0x4965, 0x4AAA, 0x45FD, 0x4159, 0x4272, 0x43A8,
    0x4953, 0x4C92, 0x4944, 0x46A4, 0x4A82, 0x4BD4, 0x4DB0, 0x53F1, 0x5569, 0x5BDD, 0x60F1, 0x61D0, 0x66BD, 0x6852, 0x64E1, 0x654F,
    0x6883, 0x6A7A, 0x69DE, 0x608F, 0x5798, 0x53C4, 0x4BDB, 0x496F, 0x48DC, 0x4491, 0x44D7, 0x495B, 0x48E0, 0x4741, 0x4659, 0x4589,
    0x4B42, 0x4FFB, 0x5460, 0x54EC, 0x4D69, 0x47EF, 0x4184, 0x35A3, 0x2D3B, 0x2581, 0x2041, 0x1E42, 0x19B3, 0x0DB2, 0x04D0, 0x0268,
    0xFDBE, 0x001A, 0x017F, 0x0247, 0x076F, 0x06A6, 0x0583, 0x07A9, 0x04CA, 0xFDD9, 0xF999, 0xF748, 0xF787, 0xF368, 0xE66C, 0xDF4C,
    0xD943, 0xD4EA, 0xD870, 0xDB98, 0xDE0C, 0xE595, 0xED51, 0xF15D, 0xF5B0, 0xF6CA, 0xFBCD, 0x0664, 0x1308, 0x20D5, 0x2768, 0x2757,
    0x28FC, 0x2509, 0x1DCD, 0x17FC, 0x127F, 0x1076, 0x119B, 0x0D2F, 0x0061, 0xF8FB, 0xF067, 0xE915, 0xE64D, 0xE0FA, 0xE040, 0xE11C,
    0xDF08, 0xE077, 0xE447, 0xE2EA, 0xDF93, 0xDD2D, 0xDC38, 0xDEDC, 0xD7ED, 0xCCE4, 0xC611, 0xBDB5, 0xBA33, 0xBB1C, 0xBA1F, 0xB920,
    0xBC30, 0xBDEC, 0xBF32, 0xBEF5, 0xBDBF, 0xC1F1, 0xC8EE, 0xD2BA, 0xDDCD, 0xE06C, 0xDFF3, 0xDE01, 0xD721, 0xCF41, 0xC7A6, 0xC0E2,
    0xBD8E, 0xBE51, 0xB853, 0xB2DC, 0xB0C8, 0xAE6D, 0xB047, 0xB1DB, 0xB32D, 0xB74D, 0xB99E, 0xBA1A, 0xBE77, 0xC2D3, 0xC3B3, 0xC534,
    0xC804, 0xD032, 0xD6B9, 0xD369, 0xCF81, 0xCAB2, 0xC4F4, 0xC4CD, 0xC7D9, 0xC833, 0xCBCD, 0xD112, 0xD549, 0xD8FA, 0xD7A6, 0xD5D1,
    0xD792, 0xDB00, 0xE461, 0xED5E, 0xF0AA, 0xF478, 0xF5C5, 0xF437, 0xF0B8, 0xEC68, 0xE6A1, 0xE6C1, 0xE6C1, 0xDEE6, 0xD956, 0xD38A,
    0xCF85, 0xCFDD, 0xCE93, 0xCEE7, 0xD238, 0xD2BC, 0xD380, 0xD8FE, 0xDD06, 0xE008, 0xE13E, 0xE28A, 0xEBEF, 0xF1FD, 0xF0F2, 0xEF5B,
    0xEB3B, 0xE64E, 0xE829, 0xEA73, 0xEB17, 0xEF17, 0xF39C, 0xF9EF, 0xFEE8, 0xFFC6, 0x0233, 0x065B, 0x0E5E, 0x1BFA, 0x243C, 0x2834,
    0x2ADC, 0x2B14, 0x286F, 0x252F, 0x1F3F, 0x19D3, 0x1D38, 0x1CC7, 0x188A, 0x1492, 0x0E0A, 0x0CE6, 0x0DD6, 0x0DE1, 0x111E, 0x150D,
    0x1595, 0x1772, 0x1B24, 0x1C07, 0x1BE4, 0x16AA, 0x150F, 0x1A1A, 0x1BFE, 0x1A11, 0x17E6, 0x11B6, 0x0D0D, 0x0EB5, 0x0F4E, 0x112D,
    0x14BF, 0x193A, 0x205F, 0x23EE, 0x248D, 0x265A, 0x27B6, 0x2FCF, 0x3A1A, 0x40BB, 0x4476, 0x46B9, 0x45E4, 0x4378, 0x4107, 0x38EA,
    0x3639, 0x3951, 0x37AA, 0x352F, 0x3043, 0x2A6D, 0x2874, 0x2682, 0x23E3, 0x2518, 0x264F, 0x25D5, 0x2956, 0x2D8B, 0x33F8, 0x37B2,
    0x3648, 0x3A4A, 0x4154, 0x437E, 0x4420, 0x4248, 0x3C9E, 0x3AF4, 0x3CA5, 0x3E5F, 0x4102, 0x43E7, 0x499D, 0x5058, 0x5209, 0x539C,
    0x53C4, 0x54BD, 0x5BD0, 0x635A, 0x66A8, 0x6756, 0x665D, 0x6118, 0x5BCA, 0x52E3, 0x475C, 0x419D, 0x3D56, 0x3925, 0x33B7, 0x2A81,
    0x230B, 0x203E, 0x1D28, 0x1B0A, 0x1CF2, 0x1BF6, 0x1B6A, 0x1C56, 0x1D31, 0x2022, 0x1D2F, 0x1734, 0x175A, 0x1955, 0x1872, 0x1726,
    0x1082, 0x073A, 0x025C, 0xFF6D, 0xFDE1, 0xFD4E, 0xFD7D, 0x01FD, 0x05DC, 0x0764, 0x07B8, 0x03A8, 0x0261, 0x064D, 0x0C46, 0x1051,
    0x14B7, 0x169A, 0x1649, 0x16BC, 0x1073, 0x096D, 0x07E0, 0x0743, 0x06C8, 0x04FD, 0x0025, 0xFD92, 0xFDD0, 0xFC81, 0xFE8B, 0x02AD,
    0x0527, 0x08EB, 0x0BF1, 0x1226, 0x18BC, 0x17B4, 0x1539, 0x17C3, 0x198B, 0x19CD, 0x17EC, 0x0EF6, 0x0414, 0xFBC1, 0xF558, 0xF175,
    0xEE5E, 0xEDE6, 0xF1F3, 0xF4DA, 0xF701, 0xF632, 0xF27D, 0xF196, 0xF637, 0xFADC, 0xFDDC, 0x000A, 0xFC33, 0xF811, 0xF165, 0xE44C,
    0xD910, 0xD19F, 0xCCC9, 0xC9E6, 0xC4A3, 0xBD79, 0xB976, 0xB5E7, 0xB2A0, 0xB2EE, 0xB394, 0xB466, 0xB4CC, 0xB523, 0xB7E2, 0xB8FF,
    0xB459, 0xB141, 0xB117, 0xB091, 0xB18B, 0xB068, 0xABD4, 0xA83A, 0xA597, 0xA54F, 0xA5E1, 0xA593, 0xA917, 0xAD8C, 0xB276, 0xB6FA,
    0xB925, 0xBA09, 0xBD83, 0xC511, 0xCC89, 0xD5B2, 0xDCDB, 0xE068, 0xE587, 0xE619, 0xE244, 0xDF44, 0xDDB6, 0xDDBD, 0xDCF6, 0xD7B0,
    0xD0AF, 0xCBFA, 0xC678, 0xC314, 0xC2AC, 0xC2DD, 0xC47E, 0xC52A, 0xC6B8, 0xCC0F, 0xCD5E, 0xCAF1, 0xCAB4, 0xCB8A, 0xCCFE, 0xCEF1,
    0xCD13, 0xC734, 0xC147, 0xBC58, 0xBA79, 0xB881, 0xB79C, 0xB9C1, 0xBCF9, 0xC0C1, 0xC38B, 0xC3F4, 0xC290, 0xC5E5, 0xCC19, 0xD3DB,
    0xDDB6, 0xE254, 0xE4B6, 0xE68F, 0xE23F, 0xDA86, 0xD479, 0xD07B, 0xCFC0, 0xCFC3, 0xCC88, 0xCA3F, 0xC828, 0xC59D, 0xC56A, 0xC6B8,
    0xC944, 0xCBD5, 0xCCF4, 0xD0DB, 0xD849, 0xDB87, 0xDBC9, 0xDDD1, 0xE094, 0xE665, 0xEC60, 0xEDD4, 0xEBAD, 0xE6E4, 0xE435, 0xE3C6,
    0xE19F, 0xE13C, 0xE275, 0xE4C0, 0xE75C, 0xE9E0, 0xE8BD, 0xE67F, 0xEA1E, 0xEFD8, 0xF998, 0x037F, 0x08CA, 0x0DF5, 0x11B4, 0x1056,
    0x0C45, 0x0817, 0x058E, 0x0682, 0x0539, 0x007E, 0xFBEF, 0xF608, 0xF0EF, 0xEE4A, 0xED91, 0xEFB5, 0xF162, 0xF08E, 0xF37F, 0xF8BC,
    0xF9B5, 0xF9D4, 0xFAE4, 0xFD25, 0x027B, 0x06B1, 0x0687, 0x0231, 0xFB16, 0xF733, 0xF4C6, 0xF327, 0xF3FC, 0xF788, 0xFD7B, 0x0589,
    0x0C63, 0x0D0C, 0x0EC0, 0x136D, 0x1A94, 0x25D5, 0x2EDA, 0x3400, 0x38D1, 0x3B6C, 0x3951, 0x351B, 0x2FF6, 0x2E2D, 0x30AE, 0x308F,
    0x2ECA, 0x2CE1, 0x2974, 0x2637, 0x2363, 0x21C2, 0x221D, 0x1F95, 0x1A87, 0x1A7C, 0x1BFA, 0x19F8, 0x1789, 0x1490, 0x1431, 0x1700,
    0x1908, 0x191A, 0x1363, 0x0CCC, 0x08B1, 0x05AB, 0x0343, 0x01ED, 0x02A7, 0x049D, 0x09B7, 0x0C48, 0x0A93, 0x0B09, 0x0D44, 0x13F5,
    0x1ED1, 0x2715, 0x2D03, 0x332C, 0x36D8, 0x36B9, 0x33D8, 0x2F7B, 0x2F97, 0x311A, 0x2F5A, 0x2C9D, 0x285B, 0x22FB, 0x1F3B, 0x1C7B,
    0x1D57, 0x20BC, 0x2099, 0x20AB, 0x25FF, 0x2AF5, 0x2D7B, 0x2F1D, 0x2FD3, 0x33A3, 0x38F2, 0x3EB7, 0x4135, 0x3E36, 0x3ACD, 0x3928,
    0x3823, 0x383B, 0x3AE8, 0x3E82, 0x44BF, 0x4D6C, 0x5192, 0x531D, 0x53FF, 0x542F, 0x5816, 0x5D3D, 0x5F18, 0x5FD9, 0x6117, 0x5F69,
    0x5B68, 0x54CA, 0x4DA8, 0x4A45, 0x4773, 0x43D4, 0x40A6, 0x3BFA, 0x3773, 0x3389, 0x2FB0, 0x2FBC, 0x2FE3, 0x2BC9, 0x2960, 0x2ABB,
    0x2BDA, 0x2C83, 0x2A49, 0x27C9, 0x27DD, 0x2966, 0x2BE7, 0x2A75, 0x24C9, 0x1F17, 0x1AF7, 0x1740, 0x1511, 0x13EE, 0x1247, 0x1469,
    0x17EE, 0x1807, 0x171D, 0x1509, 0x13FF, 0x18AA, 0x1F52, 0x23B5, 0x28DD, 0x2D68, 0x2F81, 0x2F07, 0x2A6F, 0x26A5, 0x2645, 0x268C,
    0x268B, 0x2575, 0x22F5, 0x20C5, 0x1E04, 0x1C6F, 0x2008, 0x2413, 0x256B, 0x2908, 0x2EAC, 0x33D9, 0x367B, 0x3537, 0x336F, 0x3201,
    0x3281, 0x3392, 0x30B5, 0x29CD, 0x2357, 0x1DB0, 0x1803, 0x14B3, 0x117F, 0x0FCF, 0x1390, 0x185C, 0x1ACB, 0x1B76, 0x19B9, 0x1922,
    0x1CC8, 0x2092, 0x2321, 0x2597, 0x26BD, 0x2676, 0x2210, 0x18CF, 0x10A1, 0x0B23, 0x0690, 0x035F, 0xFE90, 0xF9EB, 0xF681, 0xF0DB,
    0xED85, 0xEDFC, 0xEC14, 0xE865, 0xE6CF, 0xE6F9, 0xE7F6, 0xE6BE, 0xE411, 0xE0DC, 0xDF53, 0xE0E4, 0xE264, 0xE0D1, 0xDBF3, 0xD731,
    0xD2EB, 0xCF87, 0xCDA1, 0xCADC, 0xCB11, 0xCF70, 0xD3F3, 0xD7FA, 0xDA2E, 0xDA8B, 0xDE32, 0xE6B2, 0xF0B4, 0xFBBC, 0x05DA, 0x0EC5,
    0x1560, 0x1570, 0x1036, 0x0B7A, 0x0806, 0x0566, 0x02BA, 0xFE52, 0xF9DE, 0xF4EC, 0xEE32, 0xEAD2, 0xEAA8, 0xE846, 0xE682, 0xE671,
    0xE8EA, 0xEB06, 0xEAA0, 0xE8A4, 0xE55B, 0xE3A0, 0xE46C, 0xE5AB, 0xE2D8, 0xDD99, 0xD7F5, 0xD14E, 0xCC86, 0xC856, 0xC429, 0xC402,
    0xC710, 0xCB37, 0xCF11, 0xCFB8, 0xCDFF, 0xCEF3, 0xD2A5, 0xD6EC, 0xDB86, 0xDF89, 0xE33C, 0xE60F, 0xE35F, 0xDD24, 0xD710, 0xD229,
    0xCFA1, 0xCCD2, 0xC966, 0xC6E6, 0xC32B, 0xBEB8, 0xBE3B, 0xBEDC, 0xBE75, 0xBD8D, 0xBD92, 0xC009, 0xC23D, 0xC34C, 0xC398, 0xC3C5,
    0xC605, 0xCBEF, 0xD13F, 0xD27E, 0xD1C0, 0xCEC0, 0xCA2B, 0xC709, 0xC2CF, 0xBE81, 0xBD74, 0xBE8B, 0xC088, 0xC219, 0xC084, 0xBE2B,
    0xBEFF, 0xC239, 0xC752, 0xCD1C, 0xD291, 0xD8CB, 0xDCC1, 0xDB73, 0xD6F9, 0xD20F, 0xCEF7, 0xCDAD, 0xCB29, 0xC816, 0xC579, 0xBFD4,
    0xBA3E, 0xB851, 0xB7F4, 0xB791, 0xB6B0, 0xB780, 0xB9F6, 0xBC96, 0xBE3B, 0xBDCE, 0xBC4F, 0xBCBC, 0xC08F, 0xC381, 0xC3E3, 0xC302,
    0xBFED, 0xBD8A, 0xBC2F, 0xB99A, 0xB813, 0xBA06, 0xBE25, 0xC419, 0xC98F, 0xCBBB, 0xCDCF, 0xD1B7, 0xD7E3, 0xDF26, 0xE561, 0xEB7F,
    0xF2C2, 0xF751, 0xF6A2, 0xF37F, 0xF01B, 0xEF86, 0xF076, 0xEF71, 0xEEB9, 0xED17, 0xE75D, 0xE1BC, 0xDED2, 0xDD0D, 0xDA87, 0xD6AF,
    0xD4AF, 0xD479, 0xD4DA, 0xD4DF, 0xD34F, 0xD0CF, 0xD162, 0xD5CD, 0xD8ED, 0xDA6B, 0xD923, 0xD540, 0xD28B, 0xD054, 0xCD00, 0xCACE,
    0xCB10, 0xCCF0, 0xD0FF, 0xD34A, 0xD25F, 0xD189, 0xD2B5, 0xD7A6, 0xDEC3, 0xE557, 0xEDB3, 0xF753, 0xFDEB, 0xFFE0, 0xFD56, 0xF9AD,
    0xF862, 0xF790, 0xF58C, 0xF4D6, 0xF23E, 0xED43, 0xE95F, 0xE81F, 0xE892, 0xE7F6, 0xE7B7, 0xE946, 0xED44, 0xF25D, 0xF76F, 0xF9AB,
    0xF9E5, 0xFD64, 0x034E, 0x08D5, 0x0D4A, 0x0EB8, 0x0DFE, 0x0EE3, 0x107D, 0x1161, 0x13C9, 0x1788, 0x1D4D, 0x25E6, 0x2BAC, 0x2D53,
    0x2DF5, 0x2EFE, 0x327C, 0x3681, 0x3943, 0x3D65, 0x4223, 0x4458, 0x4361, 0x3E90, 0x392B, 0x368F, 0x3336, 0x2FAD, 0x2D28, 0x28ED,
    0x2304, 0x1DF1, 0x1C6C, 0x1C65, 0x1A8D, 0x17D5, 0x164E, 0x16A7, 0x1817, 0x195C, 0x1820, 0x16D5, 0x1A32, 0x1F76, 0x2435, 0x277A,
    0x265C, 0x22D2, 0x2046, 0x1C84, 0x17F1, 0x149D, 0x1249, 0x1430, 0x187F, 0x1A7D, 0x1A85, 0x18D5, 0x186B, 0x1BF8, 0x209B, 0x257C,
    0x2CCC, 0x3522, 0x3B56, 0x3D68, 0x3A40, 0x3726, 0x35A7, 0x32C3, 0x314A, 0x31D1, 0x3128, 0x2F88, 0x2EFA, 0x322B, 0x364D, 0x38B7,
    0x3AF6, 0x3E4B, 0x41E0, 0x4676, 0x4994, 0x4887, 0x46F9, 0x4798, 0x492B, 0x4ACD, 0x4AF6, 0x478A, 0x43DC, 0x410A, 0x3D4A, 0x38D5,
    0x352C, 0x329D, 0x33D2, 0x379A, 0x3A36, 0x3AF6, 0x39ED, 0x3A7F, 0x3CBC, 0x3E93, 0x4065, 0x43D3, 0x4799, 0x49CF, 0x4803, 0x4353,
    0x401A, 0x3D29, 0x39ED, 0x3801, 0x3675, 0x3329, 0x2DA0, 0x295F, 0x27CA, 0x2658, 0x2386, 0x2045, 0x1E52, 0x1DB7, 0x1F4D, 0x1F71,
    0x1C08, 0x191E, 0x18AD, 0x1AAA, 0x1E43, 0x1FF2, 0x1EAE, 0x1D3C, 0x1ABB, 0x1688, 0x11BF, 0x0BE0, 0x0804, 0x094E, 0x0E2B, 0x131F,
    0x15D6, 0x17DD, 0x1CB3, 0x241B, 0x2BC9, 0x3480, 0x3E13, 0x47E8, 0x4FB7, 0x51C3, 0x5003, 0x4DE9, 0x4AFB, 0x47D6, 0x45A9, 0x4431,
    0x410C, 0x3C2C, 0x389F, 0x36ED, 0x35B3, 0x33A3, 0x3198, 0x3062, 0x30D5, 0x33D7, 0x34EE, 0x328D, 0x3094, 0x2EE7, 0x2E87, 0x2F27,
    0x2D67, 0x296B, 0x24E4, 0x2088, 0x1C89, 0x183D, 0x12F2, 0x1041, 0x11DB, 0x15F2, 0x1988, 0x19D2, 0x18C2, 0x19B6, 0x1BEE, 0x1E24,
    0x215E, 0x2582, 0x2B6F, 0x2FF3, 0x2EED, 0x2B40, 0x273B, 0x2307, 0x1F77, 0x1D45, 0x1C89, 0x19E8, 0x14C7, 0x1071, 0x0D64, 0x0A6C,
    0x0701, 0x0452, 0x0275, 0x0442, 0x0870, 0x0AAE, 0x0B2B, 0x0B72, 0x0CC3, 0x1095, 0x157D, 0x1738, 0x1602, 0x130F, 0x0E1F, 0x0879,
    0x0127, 0xF8DA, 0xF387, 0xF229, 0xF408, 0xF60D, 0xF5C0, 0xF382, 0xF290, 0xF367, 0xF5A9, 0xF96F, 0xFF7E, 0x0921, 0x1085, 0x11F1,
    0x0FD1, 0x0BE1, 0x0656, 0x006E, 0xFC89, 0xF9E5, 0xF51D, 0xEEA4, 0xEA71, 0xE864, 0xE657, 0xE468, 0xE1D4, 0xDF7F, 0xDFA0, 0xE16B,
    0xE106, 0xDEAB, 0xDB9A, 0xD9AF, 0xDB17, 0xDCCC, 0xDC9D, 0xDB05, 0xD7C3, 0xD3F5, 0xCFF0, 0xCAD3, 0xC689, 0xC4D2, 0xC6E8, 0xCC29,
    0xD110, 0xD299, 0xD3C0, 0xD634, 0xD922, 0xDD3F, 0xE206, 0xEA1D, 0xF4E9, 0xFD5E, 0x0181, 0x01ED, 0x012C, 0xFEC8, 0xFBFE, 0xFB27,
    0xF976, 0xF45D, 0xECA1, 0xE5A6, 0xE00B, 0xDA27, 0xD505, 0xCF62, 0xCA40, 0xC8C5, 0xC860, 0xC63D, 0xC290, 0xBE8F, 0xBC26, 0xBCD5,
    0xBE49, 0xBEB7, 0xBE2D, 0xBB8F, 0xB8C2, 0xB55D, 0xB00C, 0xAB1A, 0xA7F9, 0xA877, 0xAAF0, 0xAC26, 0xABD3, 0xABC3, 0xACB5, 0xAED7,
    0xB18C, 0xB47F, 0xBA23, 0xC171, 0xC71B, 0xC91E, 0xC8D2, 0xC717, 0xC445, 0xC21A, 0xC0CB, 0xBF61, 0xBC30, 0xB87B, 0xB602, 0xB472,
    0xB435, 0xB452, 0xB328, 0xB336, 0xB5D6, 0xB84B, 0xB99B, 0xB917, 0xB76F, 0xB797, 0xBA4B, 0xBDA7, 0xC0AD, 0xC264, 0xC342, 0xC48B,
    0xC588, 0xC55B, 0xC4EF, 0xC5B6, 0xC917, 0xCE24, 0xD174, 0xD260, 0xD25A, 0xD2FE, 0xD499, 0xD5AE, 0xD6FB, 0xDB4F, 0xE1B4, 0xE642,
    0xE6C9, 0xE4CC, 0xE16E, 0xDDA4, 0xDA97, 0xD902, 0xD7A8, 0xD3A9, 0xCF08, 0xCB73, 0xC83E, 0xC5C2, 0xC2C4, 0xBEA5, 0xBC92, 0xBD45,
    0xBE77, 0xBF9E, 0xBF52, 0xBE0F, 0xBF6B, 0xC2BE, 0xC60E, 0xC871, 0xC877, 0xC801, 0xC6F6, 0xC508, 0xC20B, 0xBDD3, 0xBAFF, 0xBB3F,
    0xBDB2, 0xBF6B, 0xBFAD, 0xBFBC, 0xC0C3, 0xC36A, 0xC60A, 0xC957, 0xCFE1, 0xD813, 0xDEBB, 0xE28E, 0xE3D4, 0xE296, 0xDFE9, 0xDE49,
    0xDF4D, 0xE013, 0xDF56, 0xDF93, 0xE0D0, 0xE386, 0xE7C9, 0xEA96, 0xEB88, 0xEDD0, 0xF139, 0xF500, 0xF835, 0xF852, 0xF799, 0xF8AE,
    0xFAB2, 0xFD4E, 0xFFA3, 0xFFF1, 0xFE76, 0xFC97, 0xFA6B, 0xF768, 0xF35C, 0xF0C9, 0xF2A2, 0xF70A, 0xFABF, 0xFCA3, 0xFCE7, 0xFE2F,
    0xFFBB, 0x00B8, 0x02CB, 0x0800, 0x0F7C, 0x15A3, 0x191C, 0x1A79, 0x18F9, 0x1549, 0x12C7, 0x11FE, 0x107D, 0x0D13, 0x0950, 0x055E,
    0x02EF, 0x0172, 0xFE12, 0xF933, 0xF5D9, 0xF532, 0xF673, 0xF78C, 0xF6C4, 0xF5F7, 0xF68F, 0xF91C, 0xFCDB, 0xFF90, 0x007C, 0x00A6,
    0x008A, 0xFF24, 0xFBD3, 0xF6B0, 0xF39A, 0xF55A, 0xF9C6, 0xFF31, 0x0384, 0x06F3, 0x0CA9, 0x12C0, 0x17AA, 0x1DC4, 0x26BB, 0x310D,
    0x39B8, 0x3FA6, 0x42C7, 0x432C, 0x40EE, 0x3FA9, 0x3F86, 0x3E80, 0x3C73, 0x3964, 0x3703, 0x36A5, 0x37E2, 0x3788, 0x3619, 0x362E,
    0x37CF, 0x3AC0, 0x3C92, 0x3BDE, 0x39F1, 0x3881, 0x3903, 0x3A6C, 0x3AD3, 0x3A3C, 0x39F3, 0x3938, 0x380B, 0x347F, 0x2EF4, 0x2B48,
    0x2AE1, 0x2D7F, 0x3020, 0x30EB, 0x3181, 0x3306, 0x33BC, 0x32DA, 0x32EE, 0x36D5, 0x3D32, 0x422A, 0x455C, 0x46DF, 0x4531, 0x416D,
    0x3EFC, 0x3DCE, 0x3BF2, 0x395A, 0x35EB, 0x32E1, 0x3162, 0x3040, 0x2E00, 0x2BE0, 0x2B21, 0x2D8E, 0x32C8, 0x373C, 0x39ED, 0x3B94,
    0x3D78, 0x409F, 0x4428, 0x463F, 0x469A, 0x45DC, 0x445D, 0x41B9, 0x3C6E, 0x34B7, 0x2E3D, 0x2B6F, 0x2C26, 0x2D33, 0x2CB1, 0x2CBB,
    0x2DB5, 0x2E93, 0x2E81, 0x2FE7, 0x354C, 0x3CA4, 0x42ED, 0x474E, 0x48A0, 0x45E7, 0x4156, 0x3DDA, 0x3B69, 0x38E2, 0x35C4, 0x31FF,
    0x2EEF, 0x2E0B, 0x2DA5, 0x2BF9, 0x29F6, 0x2887, 0x2960, 0x2B7A, 0x2C1C, 0x2A2C, 0x2670, 0x2340, 0x2219, 0x2207, 0x223C, 0x2248,
    0x21AF, 0x2191, 0x20B9, 0x1C63, 0x160A, 0x1100, 0x0FCF, 0x1251, 0x151B, 0x16D5, 0x18BE, 0x1B27, 0x1D40, 0x1E44, 0x21C6, 0x2A2D,
    0x34F9, 0x3EC3, 0x46D9, 0x4BD0, 0x4C11, 0x4A49, 0x48D6, 0x4775, 0x4541, 0x41E1, 0x3C59, 0x36EE, 0x3261, 0x2DC0, 0x27A8, 0x2044,
    0x1A61, 0x1765, 0x169A, 0x1559, 0x1280, 0x0ED8, 0x0C2C, 0x0B67, 0x0B7A, 0x0B4D, 0x0A2E, 0x0813, 0x0643, 0x02BF, 0xFC26, 0xF3B5,
    0xEC5B, 0xE95F, 0xE937, 0xE9DE, 0xE99D, 0xE983, 0xEB03, 0xEBF8, 0xEC34, 0xEE75, 0xF4C2, 0xFD57, 0x0518, 0x0B29, 0x0DDF, 0x0C32,
    0x08B2, 0x0567, 0x034B, 0x01A7, 0xFE8F, 0xFA6A, 0xF75E, 0xF598, 0xF425, 0xF205, 0xEED9, 0xED14, 0xEE33, 0xF12D, 0xF39D, 0xF3F6,
    0xF304, 0xF320, 0xF54C, 0xF93D, 0xFD99, 0x013F, 0x04C2, 0x082B, 0x09E3, 0x08A9, 0x0487, 0x0067, 0x0034, 0x0287, 0x04A8, 0x04F7,
    0x0588, 0x05D8, 0x04AC, 0x0234, 0x0174, 0x04E8, 0x09AE, 0x0EC6, 0x1318, 0x13FC, 0x1105, 0x0CE8, 0x08F1, 0x059F, 0x022F, 0xFD33,
    0xF6FA, 0xF163, 0xECDF, 0xE885, 0xE318, 0xDCC3, 0xD814, 0xD62D, 0xD693, 0xD72D, 0xD648, 0xD4A5, 0xD462, 0xD65A, 0xD957, 0xDC2E,
    0xDD2F, 0xDCF4, 0xDC89, 0xDAA6, 0xD5F2, 0xCEB3, 0xC8A9, 0xC650, 0xC6E0, 0xC750, 0xC718, 0xC75C, 0xC850, 0xC83A, 0xC76D, 0xC90D,
    0xCD5A, 0xD357, 0xDB00, 0xE23D, 0xE655, 0xE767, 0xE693, 0xE65F, 0xE72F, 0xE8A6, 0xE8EA, 0xE7D3, 0xE7A8, 0xE8D7, 0xE9FF, 0xE9FB,
    0xE892, 0xE817, 0xE9AB, 0xEB81, 0xECBE, 0xEBD8, 0xE948, 0xE6D5, 0xE5B0, 0xE68A, 0xE727, 0xE6BB, 0xE682, 0xE696, 0xE5E5, 0xE259,
    0xDC03, 0xD664, 0xD428, 0xD4DA, 0xD59E, 0xD56A, 0xD62A, 0xD6C2, 0xD631, 0xD529, 0xD56D, 0xD8A5, 0xDDB4, 0xE440, 0xEB0D, 0xEF14,
    0xF036, 0xEF71, 0xEE20, 0xED06, 0xEB6B, 0xE7D7, 0xE1EF, 0xDC3E, 0xD7FE, 0xD408, 0xCF00, 0xC971, 0xC571, 0xC443, 0xC49F, 0xC4F1,
    0xC399, 0xC1A6, 0xC085, 0xC097, 0xC1A7, 0xC200, 0xC1EA, 0xC227, 0xC2DA, 0xC325, 0xC118, 0xBD5D, 0xBABE, 0xBB50, 0xBE5C, 0xC109,
    0xC32B, 0xC668, 0xCA43, 0xCC66, 0xCD9C, 0xD0C9, 0xD607, 0xDC97, 0xE49F, 0xECCF, 0xF191, 0xF2F1, 0xF1FB, 0xF05E, 0xEFC7, 0xEF55,
    0xEDB0, 0xEB6B, 0xEA2E, 0xEA16, 0xEAB7, 0xE9C9, 0xE72D, 0xE565, 0xE537, 0xE70E, 0xE8A7, 0xE85C, 0xE6EE, 0xE52A, 0xE4F0, 0xE59A,
    0xE5E1, 0xE5B8, 0xE5E3, 0xE77C, 0xE8D1, 0xE711, 0xE2CB, 0xDF15, 0xDDFE, 0xDE94, 0xDE77, 0xDE5F, 0xDFAC, 0xE170, 0xE14F, 0xE099,
    0xE170, 0xE4A1, 0xEA0F, 0xF180, 0xF919, 0xFDF8, 0xFFB1, 0xFE8D, 0xFCB3, 0xFBA3, 0xFA78, 0xF823, 0xF518, 0xF27C, 0xF1A2, 0xF147,
    0xEFD7, 0xED61, 0xEB63, 0xEBEC, 0xEEBB, 0xF1D9, 0xF3F4, 0xF4DA, 0xF5DF, 0xF7FB, 0xFABE, 0xFD11, 0xFD68, 0xFDAB, 0xFE49, 0xFD4C,
    0xF8C3, 0xF128, 0xEA1E, 0xE694, 0xE621, 0xE5E9, 0xE662, 0xE88D, 0xEB0C, 0xEBF7, 0xEB96, 0xEC4E, 0xEF98, 0xF556, 0xFE38, 0x0708,
    0x0D0B, 0x0FAB, 0x0F0D, 0x0E33, 0x0D1E, 0x0BF6, 0x0990, 0x06D5, 0x0537, 0x05C2, 0x069A, 0x05AE, 0x0362, 0x00DA, 0x002A, 0x00E8,
    0x0226, 0x0174, 0xFED7, 0xFC11, 0xFB0B, 0xFB7E, 0xFBBE, 0xFBB1, 0xFC8B, 0xFE79, 0xFFB8, 0xFDBE, 0xF7ED, 0xF21E, 0xEF63, 0xEF8D,
    0xF0BC, 0xF3AB, 0xF8B6, 0xFDBF, 0x00AE, 0x0319, 0x0725, 0x0D8F, 0x16AC, 0x2184, 0x2C98, 0x34C8, 0x391E, 0x3AC4, 0x3B7D, 0x3B7F,
    0x3A4A, 0x36AB, 0x31F0, 0x2D6F, 0x29E4, 0x260B, 0x2058, 0x19B7, 0x1342, 0x0F5C, 0x0E3B, 0x0E06, 0x0BE8, 0x08BA, 0x0578, 0x0381,
    0x02E7, 0x0251, 0x0175, 0x013A, 0x0260, 0x025A, 0xFEA8, 0xF7F6, 0xF09E, 0xEC7E, 0xEC24, 0xEBC1, 0xEBF8, 0xEE33, 0xF0DC, 0xF1F5,
    0xF2CE, 0xF4A5, 0xF7FE, 0xFDB9, 0x0614, 0x0E86, 0x14A6, 0x1724, 0x16A1, 0x1614, 0x15F6, 0x1544, 0x13D4, 0x11BA, 0x0FDE, 0x0F38,
    0x0D4D, 0x09E9, 0x054B, 0x019E, 0x00CB, 0x02F7, 0x06B2, 0x0928, 0x0A60, 0x0B6C, 0x0E1E, 0x1201, 0x15DD, 0x1950, 0x1D78, 0x22D8,
    0x27AE, 0x28A0, 0x2593, 0x2244, 0x2141, 0x2154, 0x2138, 0x2255, 0x24DB, 0x2655, 0x25B6, 0x24A6, 0x245A, 0x25DD, 0x2A69, 0x3143,
    0x37D9, 0x3C79, 0x3D2A, 0x3B1F, 0x3880, 0x35DC, 0x3307, 0x2F30, 0x2A51, 0x25C3, 0x21B9, 0x1DA1, 0x17F8, 0x110A, 0x0B1E, 0x078D,
    0x070A, 0x078E, 0x0783, 0x062F, 0x04A4, 0x04EE, 0x05E9, 0x061A, 0x05DE, 0x05F2, 0x0731, 0x0801, 0x04BE, 0xFE29, 0xF7D8, 0xF4AC,
    0xF2D6, 0xF1CD, 0xF235, 0xF38E, 0xF41C, 0xF2DA, 0xF151, 0xF034, 0xF114, 0xF652, 0xFED4, 0x084F, 0x115C, 0x1685, 0x199D, 0x1B65,
    0x1D59, 0x1F8F, 0x1FB2, 0x1F4A, 0x1F79, 0x2085, 0x21F9, 0x223E, 0x2051, 0x1E2B, 0x1D41, 0x1E1A, 0x1F25, 0x1EA2, 0x1C8F, 0x1AA2,
    0x19B3, 0x19D2, 0x1A40, 0x1A2A, 0x1ADB, 0x1C8F, 0x1D9C, 0x1B3F, 0x14EF, 0x0EB5, 0x0B2F, 0x08D1, 0x0724, 0x070C, 0x0818, 0x088F,
    0x0794, 0x065E, 0x053F, 0x05AE, 0x091C, 0x0F13, 0x1684, 0x1CC4, 0x1F71, 0x1FAF, 0x1F29, 0x1E90, 0x1D57, 0x19D8, 0x150E, 0x1058,
    0x0C5F, 0x0942, 0x04FC, 0xFF52, 0xFA79, 0xF768, 0xF656, 0xF5BE, 0xF40E, 0xF14B, 0xEE77, 0xED11, 0xECA1, 0xEC98, 0xECD9, 0xEEC2,
    0xF271, 0xF5BF, 0xF596, 0xF241, 0xEF0F, 0xEDC5, 0xED05, 0xED0D, 0xEF38, 0xF284, 0xF593, 0xF7D1, 0xF8CD, 0xF924, 0xFAB9, 0xFE52,
    0x0493, 0x0C41, 0x1259, 0x1546, 0x15EE, 0x1501, 0x1438, 0x133A, 0x10E0, 0x0E99, 0x0C7D, 0x0B0A, 0x0AA4, 0x08A6, 0x0552, 0x019F,
    0xFFB7, 0x0011, 0x00E1, 0x00FE, 0xFF18, 0xFD89, 0xFD0E, 0xFDA6, 0xFE0A, 0xFE1A, 0xFF69, 0x028E, 0x058B, 0x04E8, 0x00D9, 0xFD21,
    0xFA4C, 0xF6EC, 0xF481, 0xF41A, 0xF560, 0xF6D4, 0xF7ED, 0xF7FE, 0xF7A9, 0xF8A0, 0xFBB0, 0x01C0, 0x08BB, 0x0E82, 0x1183, 0x1141,
    0x1048, 0x0FA1, 0x0ED6, 0x0D22, 0x0AD3, 0x090F, 0x08AE, 0x087A, 0x0792, 0x050F, 0x028F, 0x015E, 0x01FB, 0x048D, 0x05E8, 0x0632,
    0x0656, 0x070E, 0x0825, 0x0810, 0x06EC, 0x066F, 0x0825, 0x096B, 0x0716, 0x0125, 0xFABA, 0xF59B, 0xF0B0, 0xEC85, 0xEAEA, 0xEB0F,
    0xEB97, 0xEB95, 0xE9F4, 0xE837, 0xE766, 0xE96D, 0xEEE7, 0xF68B, 0xFD8F, 0x0164, 0x034B, 0x03EE, 0x0488, 0x0427, 0x027A, 0xFFFF,
    0xFE28, 0xFE0D, 0xFE7C, 0xFD78, 0xFA63, 0xF699, 0xF3BE, 0xF332, 0xF3A7, 0xF393, 0xF23F, 0xF078, 0xF010, 0xF09C, 0xF059, 0xEF2D,
    0xEEE6, 0xF09C, 0xF286, 0xF13F, 0xECCA, 0xE859, 0xE4FF, 0xE24C, 0xE19A, 0xE3AF, 0xE803, 0xECD1, 0xF12E, 0xF457, 0xF6E2, 0xF9DB,
    0xFF7C, 0x0861, 0x12C9, 0x1C76, 0x2314, 0x2635, 0x2700, 0x2713, 0x2571, 0x224E, 0x1E14, 0x1A16, 0x16D1, 0x1406, 0x0FE3, 0x09A0,
    0x02FC, 0xFDBC, 0xFB33, 0xFA13, 0xF896, 0xF5C9, 0xF2B2, 0xF02B, 0xEEDC, 0xECC4, 0xEA52, 0xE98A, 0xEB3D, 0xED1D, 0xEB8E, 0xE77B,
    0xE2FD, 0xDE9E, 0xDABE, 0xD8D8, 0xD96D, 0xDB69, 0xDE25, 0xE066, 0xE0CF, 0xE050, 0xE00B, 0xE215, 0xE73E, 0xEEC8, 0xF6A9, 0xFC30,
    0xFE7E, 0xFFC8, 0x00F3, 0x0086, 0xFE38, 0xFA8D, 0xF713, 0xF4EC, 0xF353, 0xF04C, 0xEBC8, 0xE704, 0xE435, 0xE47A, 0xE6A6, 0xE8CA,
    0xE9E5, 0xEB8E, 0xEE04, 0xF151, 0xF435, 0xF653, 0xFA25, 0x0071, 0x06AE, 0x0916, 0x082C, 0x0621, 0x0389, 0x00E8, 0xFFB1, 0x007B,
    0x02E2, 0x05A3, 0x071D, 0x0785, 0x06D8, 0x062A, 0x07BE, 0x0C92, 0x13BF, 0x1ACF, 0x1E9E, 0x1F91, 0x1EF4, 0x1D19, 0x1A4D, 0x160D,
    0x1105, 0x0C93, 0x093F, 0x0687, 0x02BC, 0xFD24, 0xF75A, 0xF393, 0xF242, 0xF295, 0xF29D, 0xF184, 0xF069, 0xF017, 0xF015, 0xEF59,
    0xEE39, 0xEF15, 0xF31B, 0xF6F4, 0xF742, 0xF496, 0xF0EA, 0xEC33, 0xE7A3, 0xE3EC, 0xE1D4, 0xE1DC, 0xE229, 0xE20B, 0xE0EC, 0xDF00,
    0xDE16, 0xE00B, 0xE5AB, 0xEE65, 0xF768, 0xFE85, 0x032C, 0x06B9, 0x0A32, 0x0CB1, 0x0DBB, 0x0D56, 0x0CD6, 0x0D7C, 0x0E84, 0x0ED1,
    0x0D5C, 0x0AD2, 0x0960, 0x09B2, 0x0A99, 0x09FF, 0x08E2, 0x0816, 0x0814, 0x08D3, 0x087A, 0x0733, 0x07B7, 0x0B2C, 0x0DD3, 0x0C81,
    0x08C8, 0x0412, 0xFECD, 0xFA0A, 0xF636, 0xF4E6, 0xF57D, 0xF6B8, 0xF82B, 0xF88B, 0xF7CB, 0xF713, 0xF87D, 0xFD55, 0x04F4, 0x0C37,
    0x10DD, 0x12D9, 0x134C, 0x1387, 0x12DF, 0x10B9, 0x0D49, 0x0A1A, 0x07FB, 0x05FF, 0x034D, 0xFE6B, 0xF857, 0xF345, 0xF058, 0xEF11,
    0xED54, 0xEA8B, 0xE73B, 0xE531, 0xE489, 0xE3AE, 0xE2A4, 0xE4DF, 0xEA69, 0xEF3D, 0xF172, 0xF142, 0xF073, 0xEEC4, 0xED37, 0xEBFB,
    0xEC4E, 0xEE1D, 0xF10A, 0xF57E, 0xF8BC, 0xFAB1, 0xFAE7, 0xFBDE, 0xFF3A, 0x04E1, 0x0B0E, 0x0F34, 0x11BE, 0x12E1, 0x1376, 0x13B7,
    0x12D9, 0x10C8, 0x0E29, 0x0B5D, 0x089E, 0x0677, 0x04EB, 0x0314, 0x013B, 0xFFF9, 0xFEED, 0xFE1B, 0xFD3A, 0xFBF3, 0xFBC1, 0xFD43,
    0xFEA4, 0xFEC1, 0xFE22, 0xFD0C, 0xFB71, 0xF93A, 0xF779, 0xF69B, 0xF646, 0xF652, 0xF6F1, 0xF7EF, 0xF862, 0xF884, 0xF82A, 0xF96E,
    0xFBE9, 0xFF1F, 0x01BA, 0x03F0, 0x04DD, 0x0509, 0x04DA, 0x04A1, 0x04A1, 0x0411, 0x04A3, 0x04E9, 0x05C1, 0x06CD, 0x07D7, 0x0984,
    0x0BC4, 0x0E19, 0x1055, 0x1230, 0x1309, 0x1372, 0x1448, 0x1516, 0x14B7, 0x13AE, 0x12C0, 0x1155, 0x0F83, 0x0CCC, 0x0A4A, 0x07E8,
    0x05DC, 0x04E9, 0x046C, 0x03C9, 0x01FD, 0xFF95, 0xFDC4, 0xFD49, 0xFCF6, 0xFD6F, 0xFD5A, 0xFD70, 0xFD65, 0xFE42, 0xFF83, 0x081A,
    0x0899, 0x01D2, 0x0280, 0x000D, 0x00BC, 0x00DB, 0x018A, 0x014B, 0x0031, 0x014C, 0x01C0, 0x02C9, 0x03D0, 0x0619, 0x0799, 0x08F9,
    0x097A, 0x092C, 0x09A9, 0x07B8, 0x053D, 0x0433, 0x0171, 0x0091, 0x00E5, 0xFDEF, 0xF9C7, 0xF5C3, 0xF297, 0xF1CB, 0xF2B0, 0xF43E,
    0xF647, 0xF8EB, 0xFBE3, 0xFF61, 0x03C0, 0x08E3, 0x0DA8, 0x1176, 0x14C6, 0x171C, 0x18CC, 0x1AE6, 0x1BCA, 0x1D3C, 0x1DD2, 0x1E36,
    0x1FC6, 0x20DC, 0x215C, 0x20CA, 0x206F, 0x1F71, 0x1F48, 0x1E35, 0x1C54, 0x19C5, 0x161E, 0x127D, 0x0E18, 0x0A61, 0x0726, 0x030E,
    0xFEDE, 0xFA66, 0xF5AB, 0xF284, 0xF03A, 0xEFB9, 0xF169, 0xF249, 0xF2C8, 0xF614, 0xF97E, 0xFA75, 0xF98E, 0xF8B6, 0xF889, 0xF7CA,
    0xF768, 0xF71B, 0xF6D3, 0xF73E, 0xF7B2, 0xF7EA, 0xF8E2, 0xF993, 0xFA1C, 0xFA83, 0xFA41, 0xF9E4, 0xFA0B, 0xFA86, 0xFAA2, 0xFAF5,
    0xFACC, 0xFA9D, 0xFB26, 0xFBFB, 0xFC4F, 0xFCFB, 0xFAE7, 0xFCE6, 0x01D8, 0x0395, 0x043C, 0x0366, 0x04A8, 0x0588, 0x069C, 0x085B,
    0x09C7, 0x0BD4, 0x0E6A, 0x10A3, 0x1261, 0x13FC, 0x151E, 0x15B1, 0x1617, 0x15CD, 0x15F0, 0x162F, 0x1558, 0x14CD, 0x132E, 0x1124,
    0x1035, 0x0FFE, 0x0F9E, 0x0E9E, 0x0C3C, 0x0A30, 0x0871, 0x0702, 0x0569, 0x0514, 0x04F9, 0x059A, 0x060F, 0x060D, 0x096B, 0x0942,
    0x06C7, 0x04A2, 0x01BD, 0xFFAD, 0xFE53, 0xFDA3, 0xFDA6, 0xFCF1, 0xFBDD, 0xFB5F, 0xFCBC, 0xFE2B, 0xFE70, 0xFE91, 0xFDEC, 0xFD37,
    0xFBF3, 0xFA9D, 0xF876, 0xF6C5, 0xF4DE, 0xF306, 0xF1C4, 0xF10D, 0xEF90, 0xEE31, 0xEF67, 0xF02A, 0xF1A7, 0xF5CA, 0xF925, 0xFAC4,
    0xFCA4, 0xFF90, 0x02E4, 0x0447, 0x05FE, 0x08D5, 0x0A31, 0x0B53, 0x0C9F, 0x0D5D, 0x0EB8, 0x0F83, 0x1093, 0x11E2, 0x1281, 0x1349,
    0x135D, 0x135F, 0x12D2, 0x11B0, 0x1031, 0x0EE9, 0x0D67, 0x0B72, 0x0945, 0x067B, 0x03F3, 0x01D6, 0x00C3, 0x008A, 0x012C, 0x025E,
    0x036C, 0x03F1, 0x03E1, 0x031F, 0x0209, 0x008A, 0xFF82, 0xFED7, 0xFE12, 0xFE11, 0xFDC6, 0xFDAB, 0xFDC6, 0xFD48, 0xFD07, 0xFD71,
    0xFE1F, 0xFEAD, 0xFEBF, 0xFE43, 0xFD9B, 0xFC83, 0xFB1A, 0xF963, 0xF773, 0xF563, 0xF30F, 0xF076, 0xEE6E, 0xECD1, 0xEBC6, 0xEC4D,
    0xED90, 0xEFCA, 0xF276, 0xF507, 0xF79C, 0xF9FA, 0xFC09, 0xFCA0, 0xFCD5, 0xFCDA, 0xFC57, 0xFC1E, 0xFB8C, 0xFAD0, 0xFA0F, 0xFA3C,
    0xFAF0, 0xFB74, 0xFBC2, 0xFBF9, 0xFC81, 0xFC9A, 0xFCB4, 0xFCC2, 0xFD05, 0xFDED, 0xFEB5, 0xFF55, 0xFFBF, 0xFFD9, 0x0015, 0x0051,
    0x0076, 0x0138, 0x0241, 0x0355, 0x0404, 0x0459, 0x0440, 0x036E, 0x0259, 0x0128, 0x006E, 0xFFA4, 0xFEE7, 0xFE86, 0xFE50, 0xFEDD,
    0xFEFC, 0xFF55, 0xFFBA, 0xFFD1, 0x0037, 0x0027, 0xFFFF, 0xFED5, 0xFD30, 0xFBDF, 0xFA70, 0xF968, 0xF847, 0xF6AF, 0xF5B4, 0xF4B1,
    0xF42E, 0xF49D, 0xF54C, 0xF6FD, 0xF940, 0xFC0D, 0xFF9F, 0x031B, 0x0638, 0x097A, 0x0C72, 0x0E43, 0x0F09, 0x0F96, 0x0FAE, 0x0F60,
    0x0EC4, 0x0E52, 0x0DDC, 0x0D4D, 0x0CDE, 0x0C85, 0x0BC8, 0x0A26, 0x086B, 0x06E6, 0x0594, 0x0494, 0x0301, 0x0177, 0xFF65, 0xFC73,
    0xF985, 0xF648, 0xF2BB, 0xEF4A, 0xECEC, 0xEBE1, 0xEB56, 0xEB0F, 0xEB61, 0xEC0C, 0xECD0, 0xEDDE, 0xEEA2, 0xEF75, 0xF06E, 0xF133,
    0xF28F, 0xF49D, 0xF6F1, 0xF99C, 0xFC83, 0xFF68, 0x024A, 0x0502, 0x0717, 0x081B, 0x083C, 0x0783, 0x061C, 0x041F, 0x01A1, 0xFF04,
    0xFC4A, 0xF9EA, 0xF7E4, 0xF5E6, 0xF428, 0xF3BE, 0xF3BF, 0xF44B, 0xF5D5, 0xF7D7, 0xFA92, 0xFD9B, 0x0024, 0x0287, 0x0465, 0x05A5,
    0x06CA, 0x0756, 0x078E, 0x07AE, 0x080D, 0x08CD, 0x0A51, 0x0BA7, 0x0CA8, 0x0D8A, 0x0E43, 0x0F48, 0x0FE2, 0x1049, 0x10D1, 0x1120,
    0x10BF, 0x0F9C, 0x0D6D, 0x0A64, 0x0614, 0x0123, 0xFBBE, 0xF685, 0xF1E1, 0xEE0D, 0xEB3C, 0xE911, 0xE795, 0xE6D1, 0xE646, 0xE612,
    0xE61B, 0xE5AD, 0xE537, 0xE414, 0xE2EC, 0xE254, 0xE1D5, 0xE1BF, 0xE212, 0xE27D, 0xE31C, 0xE424, 0xE509, 0xE5FA, 0xE6BA, 0xE74C,
    0xE7F5, 0xE85F, 0xE87F, 0xE8E0, 0xE90E, 0xE933, 0xE9A3, 0xEA81, 0xEB79, 0xEC92, 0xEDCF, 0xEF5D, 0xF16A, 0xF374, 0xF5EB, 0xF86B,
    0xFA9B, 0xFD0F, 0xFEC1, 0xFFBE, 0xFFFB, 0x0005, 0x0005, 0xFFB0, 0xFFB1, 0x002C, 0x0155, 0x0286, 0x03D8, 0x054D, 0x0635, 0x06F6,
    0x0860, 0x09F6, 0x0B96, 0x0CB9, 0x0D09, 0x0CED, 0x0BB1, 0x0967, 0x06CA, 0x0447, 0x01BE, 0xFF47, 0xFD81, 0xFBF4, 0xFB08, 0xFA63,
    0xFA02, 0xFA90, 0xFB08, 0xFB3A, 0xFBB3, 0xFC1B, 0xFBDF, 0xFB2D, 0xF9CB, 0xF7ED, 0xF659, 0xF4F8, 0xF40E, 0xF341, 0xF277, 0xF1A2,
    0xF12E, 0xF12B, 0xF0FB, 0xF0C4, 0xF0C1, 0xF0FF, 0xF11B, 0xF0EA, 0xF047, 0xEF18, 0xEDC8, 0xEC9B, 0xEB36, 0xEA22, 0xE8E8, 0xE7CE,
    0xE784, 0xE7C1, 0xE887, 0xE9EA, 0xEC01, 0xEE8D, 0xF15E, 0xF3D5, 0xF551, 0xF69C, 0xF78C, 0xF8A7, 0xFA7D, 0xFC56, 0xFF05, 0x0211,
    0x049A, 0x074C, 0x0937, 0x0AB3, 0x0C3E, 0x0D94, 0x0EE1, 0x0FEA, 0x1042, 0x0FA0, 0x0E73, 0x0C79, 0x09F7, 0x076A, 0x047C, 0x01EA,
    0x0034, 0xFF05, 0xFE43, 0xFD7A, 0xFC9C, 0xFC77, 0xFD19, 0xFE13, 0xFF07, 0xFF11, 0xFE6B, 0xFDF6, 0xFCE2, 0xFB42, 0xF9D6, 0xF8C5,
    0xF883, 0xF90A, 0xF99D, 0xFA6F, 0xFB7A, 0xFC41, 0xFCB5, 0xFCE3, 0xFD12, 0xFD48, 0xFD60, 0xFD37, 0xFC97, 0xFB06, 0xF921, 0xF757,
    0xF55A, 0xF2F9, 0xF009, 0xED59, 0xEAF9, 0xE94C, 0xE88C, 0xE90E, 0xEA33, 0xEB85, 0xED55, 0xEF6C, 0xF15E, 0xF2E1, 0xF3A6, 0xF3BA,
    0xF3A6, 0xF3C2, 0xF413, 0xF453, 0xF3C1, 0xF359, 0xF302, 0xF31B, 0xF44B, 0xF54D, 0xF6A7, 0xF858, 0xF90E, 0xF9C1, 0xF994, 0xF8B3,
    0xF7EB, 0xF6F1, 0xF630, 0xF5D5, 0xF5DB, 0xF6E3, 0xF7F6, 0xF90D, 0xFA40, 0xFB73, 0xFD28, 0xFF1A, 0x00C4, 0x0189, 0x01A1, 0x0123,
    0x0000, 0xFEC1, 0xFD9D, 0xFCD1, 0xFC8C, 0xFCBC, 0xFDD6, 0xFEE8, 0x0050, 0x013F, 0x0216, 0x02FC, 0x0365, 0x040A, 0x03CB, 0x026A,
    0x00E3, 0xFF1C, 0xFCCF, 0xFA77, 0xF81A, 0xF618, 0xF485, 0xF3E2, 0xF3D5, 0xF4CC, 0xF64E, 0xF897, 0xFC0C, 0xFFC8, 0x038F, 0x074F,
    0x0ADC, 0x0DDC, 0x0FF1, 0x115E, 0x1260, 0x1329, 0x1367, 0x1339, 0x12B3, 0x1160, 0x1069, 0x0F81, 0x0EF5, 0x0ED0, 0x0E6F, 0x0E65,
    0x0E41, 0x0DCF, 0x0D09, 0x0AF9, 0x0852, 0x052A, 0x015B, 0xFE32, 0xFB14, 0xF7F7, 0xF46D, 0xF127, 0xEEED, 0xED48, 0xEC80, 0xEBD0,
    0xEBE1, 0xEC48, 0xECAD, 0xED43, 0xED7D, 0xEDBA, 0xEE25, 0xEEF6, 0xF0B6, 0xF324, 0xF649, 0xFA25, 0xFE70, 0x0292, 0x0607, 0x0914,
    0x0BA5, 0x0D65, 0x0DEC, 0x0D76, 0x0C46, 0x0A36, 0x0750, 0x0481, 0x0190, 0xFE40, 0xFBA3, 0xF988, 0xF842, 0xF7D4, 0xF841, 0xF976,
    0xFB85, 0xFE73, 0x020B, 0x0534, 0x07D1, 0x09DC, 0x0C00, 0x0DDB, 0x0F0C, 0x0FC9, 0x1055, 0x10E9, 0x1190, 0x12A0, 0x13B4, 0x14F7,
    0x169B, 0x18E1, 0x1B7D, 0x1E1F, 0x205E, 0x2212, 0x2307, 0x2364, 0x229E, 0x20DA, 0x1E51, 0x1B17, 0x1790, 0x1315, 0x0E54, 0x096A,
    0x042D, 0xFF94, 0xFBF4, 0xF8F9, 0xF68E, 0xF492, 0xF368, 0xF278, 0xF193, 0xF0D7, 0xEFFC, 0xEEFF, 0xEE41, 0xEE58, 0xEE7A, 0xEE98,
    0xEE93, 0xEEF8, 0xEFA7, 0xF013, 0xF057, 0xF086, 0xF09E, 0xF0C7, 0xF0AF, 0xF05B, 0xEF7E, 0xEE69, 0xEDB5, 0xED6D, 0xEDBD, 0xEE2C,
    0xEF5F, 0xF1AC, 0xF476, 0xF7E7, 0xFB73, 0xFE9C, 0x01D7, 0x0448, 0x06A2, 0x086A, 0x096A, 0x09FD, 0x09F8, 0x0A2F, 0x0987, 0x08E9,
    0x0855, 0x07FA, 0x0892, 0x0994, 0x0B6A, 0x0DA9, 0x0FFC, 0x126C, 0x14CC, 0x168E, 0x1769, 0x171A, 0x1661, 0x155A, 0x13CD, 0x1197,
    0x0F17, 0x0CE4, 0x0ACA, 0x0994, 0x0907, 0x08B7, 0x0883, 0x0899, 0x09BC, 0x0ABE, 0x0B76, 0x0C89, 0x0D8E, 0x0E59, 0x0F0C, 0x0EF8,
    0x0EA4, 0x0DF4, 0x0CAE, 0x0BFD, 0x0BB0, 0x0AAA, 0x09A8, 0x0833, 0x0711, 0x05E3, 0x0426, 0x0281, 0x010F, 0xFFB6, 0xFE66, 0xFCF9,
    0xFB18, 0xF8D2, 0xF689, 0xF4E4, 0xF386, 0xF260, 0xF1AA, 0xF16E, 0xF1EB, 0xF295, 0xF316, 0xF48B, 0xF59C, 0xF6E9, 0xF8B7, 0xFA6B,
    0xFC58, 0xFDA6, 0xFEE6, 0xFFF5, 0x00D6, 0x022E, 0x046C, 0x079B, 0x0B35, 0x0F0C, 0x1307, 0x1696, 0x199A, 0x1B6B, 0x1C39, 0x1C01,
    0x1AAF, 0x18AB, 0x1631, 0x1356, 0x1016, 0x0C4A, 0x0902, 0x0678, 0x046B, 0x0380, 0x0395, 0x04C3, 0x07BE, 0x0D91, 0x12A4, 0x12EA,
    0x1196, 0x1165, 0x11A0, 0x1106, 0x0F3E, 0x0CCC, 0x0A12, 0x0772, 0x0623, 0x0615, 0x0709, 0x077B, 0x066E, 0x0378, 0x0077, 0x014D,
    0x0402, 0x0663, 0x08FB, 0x0A1F, 0x08F2, 0x068B, 0x04B2, 0x02E9, 0x00CB, 0xFFB1, 0xFE35, 0xFCC1, 0xFB9A, 0xFAB8, 0xFA7F, 0xFA50,
    0xFAE6, 0xFB86, 0xFD2F, 0xFF39, 0x0134, 0x0308, 0x0353, 0x0310, 0x0273, 0x0187, 0x00C4, 0x000A, 0xFFC5, 0xFFF3, 0x0070, 0x00CF,
    0x00B5, 0x0073, 0x004F, 0x0065, 0x0012, 0xFF77, 0xFE27, 0xFC81, 0xFAEB, 0xF94D, 0xF774, 0xF620, 0xF611, 0xF701, 0xF88B, 0xFA06,
    0xFB6C, 0xFD13, 0xFE82, 0xFF49, 0x003B, 0x00E1, 0x00EC, 0x016F, 0x019B, 0x013F, 0x00A8, 0x000B, 0xFFFE, 0x0086, 0x01C3, 0x03D4,
    0x05B0, 0x06DF, 0x0859, 0x0A1C, 0x0BB8, 0x0CB8, 0x0C83, 0x0BD5, 0x09FE, 0x0808, 0x05AC, 0x0300, 0x00FC, 0xFF42, 0xFF01, 0xFFD9,
    0x00D2, 0x01E0, 0x035B, 0x0545, 0x076D, 0x0A3D, 0x0D82, 0x1139, 0x14FC, 0x1825, 0x1A4C, 0x1B62, 0x1BBC, 0x1B93, 0x1B0D, 0x1AFD,
    0x1A96, 0x1A98, 0x1A45, 0x198E, 0x19FB, 0x1A11, 0x19AF, 0x19EB, 0x196E, 0x18A6, 0x1787, 0x14FB, 0x11F2, 0x0E6D, 0x0AB4, 0x0752,
    0x03F3, 0x00CA, 0xFDB6, 0xFB42, 0xF8EB, 0xF6FA, 0xF558, 0xF376, 0xF1FF, 0xF112, 0xF0BC, 0xF06A, 0xEFDF, 0xEF76, 0xEEF7, 0xEEE1,
    0xEF42, 0xF048, 0xF22B, 0xF49C, 0xF79C, 0xFAFF, 0xFE51, 0x01B2, 0x043C, 0x061F, 0x0766, 0x07A8, 0x06D5, 0x0502, 0x02EB, 0x004E,
    0xFDDB, 0xFC33, 0xFAD8, 0xFA55, 0xFA2E, 0xFA50, 0xFAEE, 0xFBB6, 0xFD4A, 0xFF81, 0x029F, 0x05F7, 0x0912, 0x0BB7, 0x0DD5, 0x0F5F,
    0x0FD9, 0x100C, 0x0F8F, 0x0FA4, 0x10CE, 0x1262, 0x1470, 0x15D0, 0x178E, 0x19F6, 0x1C59, 0x1E59, 0x2031, 0x21C5, 0x22DF, 0x231D,
    0x2253, 0x20F8, 0x1EF8, 0x1C66, 0x1980, 0x1719, 0x13E7, 0x1086, 0x0D5F, 0x09C7, 0x0699, 0x0347, 0x00B3, 0xFEC1, 0xFCFC, 0xFC07,
    0xFAF7, 0xFA43, 0xF901, 0xF7F8, 0xF6D2, 0xF5B1, 0xF4DF, 0xF42D, 0xF405, 0xF44A, 0xF492, 0xF4D0, 0xF486, 0xF3B5, 0xF2C2, 0xF1A3,
    0xF0D2, 0xEEF8, 0xECFC, 0xEBEB, 0xEB44, 0xEA91, 0xEA63, 0xEA98, 0xECBE, 0xEEE0, 0xF18A, 0xF375, 0xF68E, 0xF902, 0xFC2A, 0xFE5A,
    0x008E, 0x0178, 0x0280, 0x02FB, 0x0334, 0x02DC, 0x027C, 0x0472, 0x063E, 0x09BA, 0x0D59, 0x1335, 0x139A, 0x15E7, 0x1203, 0x1080,
    0x06E1, 0x1821, 0x2AC7, 0x279E, 0x2B90, 0x24E9, 0x24EF, 0x1BA3, 0x161C, 0x05B6, 0xEC36, 0xDB94, 0xCDE3, 0xB7B3, 0xA127, 0xACA5,
    0xB444, 0xB8BA, 0xC1FD, 0xC49D, 0xD293, 0xE2BA, 0xEB36, 0xEDF7, 0xFACE, 0xEE27, 0xF924, 0xE55A, 0xC59E, 0xD485, 0xD629, 0xE166,
    0xE62B, 0xF014, 0xF42A, 0x0285, 0x0F64, 0x2596, 0x1F32, 0x31DD, 0x65F8, 0x69FB, 0x5FF2, 0x5319, 0x4B8D, 0x443E, 0x4129, 0x262A,
    0x03EE, 0xEE42, 0xDE84, 0xD1CA, 0xC15E, 0xBF15, 0xCD3B, 0xDA36, 0xDE5D, 0xDF41, 0xDEED, 0xEE98, 0xF70C, 0xF962, 0x07FD, 0xFA1F,
    0x0B4E, 0xFF4B, 0xE433, 0xE5F0, 0xE76E, 0xF0CD, 0xF443, 0xFAD8, 0xFBA7, 0x01CD, 0x0745, 0x1FF7, 0x170E, 0x1CC5, 0x48DD, 0x5F81,
    0x5F1B, 0x57E4, 0x51B8, 0x490E, 0x47DA, 0x35F9, 0x16A6, 0xFBCC, 0xE9CF, 0xDC2A, 0xC939, 0xBF54, 0xC60A, 0xD32D, 0xD9E8, 0xDBCE,
    0xD94A, 0xE9A5, 0xF2A8, 0xF804, 0x075D, 0xF84B, 0x095E, 0x0218, 0xE790, 0xDB6E, 0xD904, 0xDEE0, 0xE2EA, 0xE837, 0xEB44, 0xED3D,
    0xEF4B, 0x0ABB, 0x074C, 0x0588, 0x28FC, 0x4D95, 0x58DB, 0x582A, 0x52BD, 0x497E, 0x4AFE, 0x419C, 0x2A2F, 0x0C15, 0xF5B0, 0xE6AD,
    0xD15A, 0xC228, 0xC121, 0xCB0F, 0xCD3D, 0xE073, 0xDAEC, 0xE8DD, 0xEA4C, 0xF59B, 0x0FB8, 0xEDAA, 0x0774, 0xFEFC, 0xF000, 0xD4DA,
    0xCB19, 0xD574, 0xD366, 0xD60C, 0xDE7C, 0xDD42, 0xDD81, 0x0488, 0xF603, 0xFFC8, 0x0DD3, 0x3984, 0x5229, 0x4843, 0x56C0, 0x4E54,
    0x4920, 0x4A83, 0x38E2, 0x0735, 0xF789, 0xE6CA, 0xCE5C, 0xD9D9, 0xB0B6, 0xC16C, 0xDCD2, 0xC825, 0xEE0E, 0xDCB7, 0xD759, 0xFA42,
    0x03E7, 0x000B, 0xE54F, 0x0DBD, 0x027D, 0xCDC5, 0xDF6C, 0xE7B4, 0xE099, 0xD47D, 0xE689, 0xF1BC, 0xFF38, 0xE5AE, 0x0515, 0x25E2,
    0x207D, 0x355D, 0x4FC1, 0x68A6, 0x55E3, 0x5065, 0x434B, 0x541E, 0x46E4, 0x1B0E, 0xF876, 0x027D, 0xF491, 0xBC0E, 0xCFA3, 0xCE57,
    0xC63B, 0xCF41, 0xD8D8, 0xE8A0, 0xD866, 0xF06E, 0x1B6E, 0x093C, 0x0307, 0x2044, 0x1852, 0x2166, 0x032F, 0x06DD, 0x121B, 0x0BA6,
    0x1F1C, 0x1A1A, 0x2FB6, 0x1E5D, 0x304D, 0x347B, 0x34C8, 0x3925, 0x4702, 0x50BD, 0x5DE2, 0x43A0, 0x1CAA, 0x2F2C, 0x25CF, 0x0B12,
    0xD35B, 0xD143, 0xC439, 0x9BCB, 0x98E7, 0x9B8E, 0xA1B0, 0x9DC1, 0xA65F, 0xA606, 0x9833, 0xAA3F, 0xBFEF, 0xD286, 0xABDD, 0xDB42,
    0xE4C9, 0xCCC5, 0xD948, 0xC7A4, 0xD854, 0xCC76, 0xE715, 0xE355, 0x02E2, 0x0124, 0x1733, 0x3015, 0x2970, 0x3C96, 0x5DDD, 0x7FFE,
    0x659F, 0x7D7D, 0x7A67, 0x7B55, 0x7FFF, 0x78C3, 0x7767, 0x716C, 0x6E7D, 0x6016, 0x62C7, 0x4A10, 0x5BCD, 0x6C78, 0x5F9C, 0x601B,
    0x72A1, 0x6EAF, 0x68B9, 0x740F, 0x627D, 0x60BC, 0x5E54, 0x67CA, 0x401A, 0x3E86, 0x5148, 0x2BF2, 0x3292, 0x4201, 0x3D72, 0x2725,
    0x3C32, 0x408F, 0x38E2, 0x3F8D, 0x3FBF, 0x5438, 0x586F, 0x620B, 0x4756, 0x49EE, 0x48D1, 0x3E22, 0x33C1, 0x1081, 0x178B, 0xF70F,
    0xF2C8, 0xDD0C, 0xE35B, 0xE943, 0xD47C, 0xE6F9, 0xE571, 0xE025, 0xDC27, 0xF2BE, 0xD888, 0xE62F, 0xF566, 0xCA53, 0xD52B, 0xD1ED,
    0xBDC5, 0xB7F1, 0xCA1B, 0xBA65, 0xBB88, 0xCA7E, 0xC67E, 0xE155, 0xCD8D, 0xCEB8, 0xDD26, 0xED0B, 0xFA19, 0xFBF7, 0xED3A, 0xE9D0,
    0xDF54, 0xD717, 0xDF9B, 0xC78C, 0xBDC7, 0xB52A, 0xB2E1, 0x9F1F, 0x9AA8, 0xAB56, 0x9E86, 0xAB34, 0xA71C, 0xA291, 0xA8F1, 0xA661,
    0xB489, 0xA879, 0xC031, 0xB5D6, 0xB1B9, 0xB55D, 0xB7BE, 0xB0AB, 0xB279, 0xBAF8, 0xC214, 0xBC84, 0xBB40, 0xD55A, 0xBD50, 0xD0C1,
    0xC214, 0xD2B8, 0xE3AC, 0xEF3A, 0xF851, 0xEDAA, 0xE70B, 0xF431, 0xFE61, 0xEB33, 0xEE04, 0xDE1B, 0xD678, 0xE0BF, 0xD6E5, 0xCFED,
    0xD315, 0xE6C5, 0xF48A, 0xEE9B, 0xF4BF, 0xF21D, 0x0E59, 0x15A1, 0x1213, 0x0BDF, 0x2C34, 0x0ED2, 0x12A2, 0x0851, 0xF8DA, 0x04E7,
    0xFB88, 0x184F, 0x00BC, 0x2E1A, 0x2E62, 0x228E, 0x32DB, 0x3EEF, 0x3ECC, 0x50CE, 0x5EC4, 0x48BA, 0x5184, 0x602A, 0x598E, 0x5740,
    0x4BA9, 0x363F, 0x42E8, 0x38EF, 0x15FE, 0x1EFB, 0x1FB0, 0x1FED, 0x25B2, 0x25CD, 0x2DDF, 0x249A, 0x487F, 0x4A21, 0x3C5E, 0x55B6,
    0x46EE, 0x42BF, 0x5383, 0x3FD9, 0x3AC0, 0x4228, 0x5881, 0x4E4E, 0x48C2, 0x4D62, 0x68D7, 0x5596, 0x3FBE, 0x499F, 0x5413, 0x74B8,
    0x683A, 0x7369, 0x7214, 0x5EC6, 0x5D97, 0x69F8, 0x54EA, 0x4D96, 0x2F2E, 0x2D0F, 0x230C, 0x13B4, 0x1BE5, 0x0B0C, 0x2B87, 0x385E,
    0x157C, 0x37B3, 0x3C6D, 0x3461, 0x3F9E, 0x3723, 0x5018, 0x35BD, 0x3DF5, 0x2698, 0x0981, 0x20D9, 0x1526, 0x0F2D, 0x04EB, 0xF3BA,
    0x21EE, 0x1F1D, 0x1BA3, 0x26C3, 0x1705, 0x351E, 0x3E5C, 0x2B5F, 0x3EF0, 0x365F, 0x186C, 0x2CFF, 0x25E8, 0x0055, 0x06F5, 0x00F3,
    0xD709, 0xCF93, 0xC761, 0xEBC1, 0xDB35, 0xC55E, 0xD183, 0xC642, 0xCB7D, 0xDE44, 0xD1E9, 0xC4BD, 0xC7CC, 0xCEA6, 0xEA95, 0xCF89,
    0xC30A, 0xD4E0, 0xC594, 0xC94F, 0xC9EF, 0xD03F, 0xCE8F, 0xC4E9, 0xC4FE, 0xC487, 0xCEF0, 0xC4D7, 0xE5E0, 0xDDD7, 0xF83B, 0xEA5A,
    0xEC40, 0xEEC8, 0xCEFE, 0xDEE3, 0xB709, 0xBD31, 0xAAFE, 0xADEC, 0xA7CE, 0xA025, 0x9BEF, 0xA5FF, 0xAEE5, 0xA045, 0xA3CC, 0xA57F,
    0xAE5E, 0xACCE, 0xC21B, 0xB969, 0xABAC, 0xAC09, 0xA725, 0x9E6D, 0xA027, 0xA533, 0x9EF9, 0xA1EB, 0xAC2F, 0xAE9F, 0xAE48, 0x9FAE,
    0xB826, 0xBBC1, 0xB81E, 0xDB98, 0xD6A7, 0xCE60, 0xD22C, 0xDD7B, 0xD3C3, 0xD355, 0xC750, 0xC85B, 0xB1CC, 0xBC11, 0xB6C3, 0xA32A,
    0xBA91, 0xAA63, 0xBDB0, 0xA53C, 0xB7AC, 0xC338, 0xB2E2, 0xC279, 0xC425, 0xCC51, 0xC813, 0xD2D8, 0xD270, 0xCC73, 0xD702, 0xE2F7,
    0xDB62, 0xD361, 0xE44F, 0xE512, 0xD7D7, 0xE8AD, 0xD966, 0xE6E7, 0x03C3, 0x0763, 0x1FCC, 0x1720, 0x2334, 0x2A41, 0x1F39, 0x130D,
    0x0D0B, 0x06B4, 0x0E21, 0xF45F, 0xDABF, 0xF09D, 0xD847, 0xDC7A, 0xE6F8, 0xF36B, 0xE50B, 0xEB5D, 0x0362, 0xF238, 0x0160, 0x0D6C,
    0x062B, 0x0CEE, 0x0129, 0xF555, 0xF510, 0xFE39, 0xF8E3, 0xDD46, 0x00FE, 0x0B69, 0x117D, 0x0A6F, 0x0E75, 0x1702, 0x2A3D, 0x36B1,
    0x328C, 0x41A5, 0x3E0D, 0x3FD2, 0x3212, 0x41AF, 0x3707, 0x29EA, 0x25D9, 0x18E6, 0x0C4B, 0x0BFA, 0x0611, 0x124D, 0x0CCE, 0x04E3,
    0x1BFC, 0x0DFF, 0x1AAC, 0x1EB6, 0x0D42, 0x203C, 0x1EC8, 0x2BFC, 0x2F5C, 0x2074, 0x2BD9, 0x2D5F, 0x4047, 0x2E0B, 0x2B5F, 0x37C5,
    0x3D55, 0x2CDD, 0x35D8, 0x2D23, 0x3766, 0x5442, 0x5627, 0x5D77, 0x645B, 0x63AA, 0x5FDA, 0x67BE, 0x52C1, 0x5F70, 0x3EA3, 0x5144,
    0x3FCF, 0x2D91, 0x2B7F, 0x22AD, 0x35F3, 0x2534, 0x2B05, 0x358E, 0x44B8, 0x3C8A, 0x4A0D, 0x4AB6, 0x51D7, 0x4E8C, 0x5417, 0x467C,
    0x3720, 0x3FD2, 0x33E8, 0x2E80, 0x2C0E, 0x38C9, 0x3705, 0x341D, 0x3AE2, 0x37EB, 0x37B9, 0x41F2, 0x46B2, 0x4F3C, 0x4CE7, 0x5D1E,
    0x5983, 0x46AF, 0x48E9, 0x4473, 0x3544, 0x2C40, 0x21E7, 0x0D4F, 0xFD05, 0xFBEC, 0x0205, 0xF041, 0xF847, 0xFF01, 0xFA75, 0xF6E8,
    0xF98A, 0x0061, 0xF800, 0x02C5, 0x135A, 0xFEA5, 0x02BC, 0x0F6F, 0x03DE, 0x0672, 0x031A, 0x0368, 0xFE72, 0xF914, 0xFB6D, 0xF59D,
    0xEEA8, 0xFFF3, 0x0B1C, 0x1173, 0x1E8F, 0x1430, 0x1655, 0x1D4F, 0x21BF, 0x0B9A, 0xF893, 0x1499, 0xF994, 0xDFB7, 0xE945, 0xDAC3,
    0xD122, 0xD535, 0xDD7B, 0xDA5A, 0xDB8E, 0xEB1C, 0xEB63, 0xEC61, 0xF6F1, 0xFA1B, 0xF798, 0xF218, 0xEB5C, 0xE71D, 0xD04B, 0xDC09,
    0xE530, 0xCF5B, 0xD99B, 0xDCF2, 0xE021, 0xDC79, 0xE170, 0xD86C, 0xEB73, 0xF579, 0xF781, 0x0276, 0xF29C, 0xFB4A, 0xE894, 0xDFBA,
    0xDE75, 0xD4A9, 0xC27A, 0xB3DA, 0xAFF5, 0x9AD5, 0x9ACF, 0xA844, 0x9B65, 0x9976, 0x9B50, 0x99B3, 0x9D74, 0x9A96, 0x9821, 0x9D44,
    0xA4EF, 0xA0BF, 0xA352, 0xA12E, 0xA526, 0xA585, 0xA806, 0xA143, 0xA29B, 0xA9AC, 0xA5B8, 0xA9B1, 0xAA21, 0xAF47, 0xADC5, 0xC037,
    0xC474, 0xC760, 0xC779, 0xC438, 0xD83B, 0xC336, 0xC920, 0xC827, 0xB60B, 0xB8CA, 0xA998, 0xA92E, 0x9E69, 0xA598, 0xA567, 0xA449,
    0xA848, 0xAD03, 0xB79C, 0xABAC, 0xB709, 0xBBAF, 0xBBCF, 0xB9E6, 0xBC79, 0xB984, 0xAFD6, 0xB7D8, 0xB4B3, 0xB86E, 0xB1CA, 0xBA13,
    0xCA2A, 0xC59A, 0xC5AC, 0xD186, 0xD436, 0xDE48, 0xEF69, 0xED89, 0xFB9D, 0xFD3F, 0x01AF, 0xFA66, 0xF46B, 0xF456, 0xEC26, 0xDD7E,
    0xDB71, 0xCEE7, 0xBE35, 0xCCE1, 0xC710, 0xC596, 0xC2A0, 0xCA69, 0xC755, 0xC104, 0xC4A5, 0xD336, 0xD091, 0xDAD5, 0xE677, 0xDE67,
    0xECB6, 0xE155, 0xE965, 0xEAE3, 0xE1FC, 0xE731, 0xE5D9, 0xEE26, 0xF06A, 0xEF1E, 0xF1BA, 0xF5EF, 0x0AA6, 0x0C9F, 0x0972, 0x137F,
    0x215C, 0x1A96, 0x124E, 0x1EB4, 0x1934, 0x08D3, 0x01E5, 0xFB1E, 0xEAFC, 0xEB30, 0xEEB6, 0xEDFC, 0xF1E1, 0xFC52, 0x03D1, 0x07F8,
    0x10C7, 0x1592, 0x147E, 0x1F5E, 0x21F9, 0x1BFC, 0x17D1, 0x195E, 0x1A0B, 0x19D9, 0x161E, 0x1DD1, 0x23F2, 0x2265, 0x2EA6, 0x2A54,
    0x29DE, 0x3F21, 0x4905, 0x588A, 0x5965, 0x5AD2, 0x69F7, 0x5D6B, 0x6811, 0x62E9, 0x5A06, 0x570E, 0x55A6, 0x43FB, 0x3963, 0x3758,
    0x32DA, 0x2EE5, 0x2162, 0x221E, 0x20D7, 0x1D40, 0x1DE2, 0x1DA2, 0x1CF8, 0x2D9E, 0x3B60, 0x3AA4, 0x325E, 0x3B77, 0x3D5A, 0x3B54,
    0x3040, 0x38BB, 0x347E, 0x3394, 0x43A3, 0x3D14, 0x357A, 0x3E18, 0x4047, 0x46C8, 0x4E1E, 0x4E2D, 0x5B08, 0x4F5F, 0x56F7, 0x5373,
    0x509F, 0x4A29, 0x481A, 0x3726, 0x2A06, 0x221E, 0x1B77, 0x1A58, 0x1CA4, 0x2CA6, 0x1EB9, 0x314C, 0x355C, 0x3657, 0x34AC, 0x36BC,
    0x415E, 0x36CF, 0x3413, 0x32A7, 0x31B9, 0x2BAF, 0x234A, 0x26D9, 0x2739, 0x2896, 0x31B6, 0x297F, 0x2B6A, 0x2E5E, 0x3C52, 0x4667,
    0x4B16, 0x513A, 0x4D7A, 0x5597, 0x4E52, 0x4E24, 0x475E, 0x3DD4, 0x35C5, 0x2970, 0x213A, 0x0F8F, 0x1052, 0x0544, 0x05D3, 0xFF54,
    0xF9BF, 0x0059, 0xF9DE, 0xFA1D, 0xF9C5, 0x07EB, 0x104C, 0x193E, 0x190E, 0x173C, 0x18D8, 0x1AA6, 0x13B4, 0x0D5C, 0x10AF, 0x0E86,
    0x1394, 0x1A26, 0x1050, 0x09C8, 0x163C, 0x1905, 0x1EB3, 0x265C, 0x2E26, 0x3186, 0x357E, 0x360B, 0x3206, 0x2F19, 0x28C9, 0x1DD9,
    0x0E1B, 0x0467, 0xF944, 0xF69D, 0xF2F0, 0xF420, 0xF8CC, 0xFBB5, 0x03BD, 0x0552, 0x031D, 0x0551, 0x105D, 0x0FAD, 0x0DAA, 0x0888,
    0xFC72, 0xFF79, 0xFD5E, 0xED04, 0xE9DE, 0xEB8A, 0xED26, 0xEBEC, 0xE89E, 0xE328, 0xE4DB, 0xEFBE, 0xF2AA, 0xFA8C, 0x0060, 0x0B84,
    0x0A7B, 0x0629, 0x022A, 0x0010, 0xFD3E, 0xF34F, 0xE650, 0xD6E8, 0xD2E5, 0xCC4A, 0xC2F0, 0xBE4F, 0xB98F, 0xB4EA, 0xB659, 0xB8CC,
    0xB742, 0xB316, 0xC462, 0xCF4C, 0xCBFE, 0xD54F, 0xD396, 0xD3B4, 0xD4F5, 0xC5B0, 0xD0B6, 0xD103, 0xCFC6, 0xD976, 0xD62C, 0xCF5A,
    0xD357, 0xD9AC, 0xD86B, 0xE839, 0xE874, 0xF51E, 0xF5B6, 0xF99A, 0xFCAF, 0xF2ED, 0xEEBC, 0xE1BD, 0xDB0E, 0xD0C5, 0xC339, 0xB7F3,
    0xBD4D, 0xB700, 0xB98C, 0xBD88, 0xBD5D, 0xBEF4, 0xBE98, 0xBCB5, 0xBFF4, 0xCAFC, 0xC898, 0xC486, 0xBA25, 0xBC40, 0xBAEC, 0xB369,
    0xB0B8, 0xAE74, 0xAF3D, 0xB513, 0xB566, 0xB209, 0xB380, 0xB793, 0xC1ED, 0xC4DC, 0xCB4F, 0xD629, 0xD37B, 0xD454, 0xD5DB, 0xCDF2,
    0xD0E8, 0xCBE2, 0xC558, 0xBCD4, 0xB29B, 0xAFEF, 0xB00A, 0xA645, 0xA3C9, 0xA96A, 0xA25C, 0xAB47, 0xADA0, 0xAB07, 0xAE65, 0xB8F8,
    0xC1FB, 0xC61A, 0xC149, 0xC4F6, 0xC209, 0xBEE4, 0xC5B8, 0xC07E, 0xC51F, 0xC6B2, 0xCFD7, 0xCD2D, 0xCAF5, 0xD2CB, 0xD90F, 0xDA80,
    0xEA73, 0xF110, 0xF9E1, 0x0565, 0x062A, 0x075B, 0xFD81, 0x067B, 0xF948, 0xED50, 0xE6E3, 0xDEDF, 0xDB3B, 0xD936, 0xDA9C, 0xDD1D,
    0xDC75, 0xE4C4, 0xEE80, 0xE9B2, 0xEC6D, 0xF382, 0xF91D, 0xFE96, 0xF998, 0xF0BB, 0xF5D7, 0xEE0B, 0xE7D7, 0xE3DC, 0xE26E, 0xE47C,
    0xE882, 0xE915, 0xE7A0, 0xE983, 0xF0DF, 0xFE16, 0xFFBC, 0x0C17, 0x15B2, 0x19A0, 0x2095, 0x1959, 0x19BD, 0x1765, 0x1815, 0x1705,
    0x02B7, 0x027D, 0xF9B4, 0xEAFB, 0xE4A4, 0xDF31, 0xDE2A, 0xDB31, 0xDDFA, 0xE20A, 0xDF19, 0xEA67, 0xFB0C, 0xF83B, 0x00F9, 0x0159,
    0xFD24, 0x05DE, 0xFE25, 0x016A, 0xFD7D, 0xFF56, 0x0BCF, 0x0B1F, 0x0CFC, 0x09E6, 0x0BD9, 0x1229, 0x22EC, 0x27C0, 0x39B7, 0x41F1,
    0x4B40, 0x4E5D, 0x48C2, 0x5287, 0x4BE0, 0x47EC, 0x39BF, 0x38FD, 0x3037, 0x2A17, 0x26BD, 0x28D8, 0x2D15, 0x2B5E, 0x3568, 0x32E1,
    0x3450, 0x3E18, 0x401B, 0x463F, 0x494E, 0x4648, 0x4580, 0x4110, 0x3FA6, 0x3C34, 0x3610, 0x338C, 0x3932, 0x3B3B, 0x38DF, 0x35BB,
    0x3863, 0x3A8E, 0x4505, 0x48F4, 0x4ADD, 0x5002, 0x55B4, 0x5468, 0x4FD9, 0x509B, 0x4E5E, 0x48EE, 0x43AE, 0x4251, 0x329D, 0x2C2E,
    0x1ED3, 0x1BB6, 0x0F94, 0x0C2C, 0x10BB, 0x1069, 0x124B, 0x111E, 0x1FD4, 0x285C, 0x2F10, 0x2B9D, 0x2C5E, 0x25D4, 0x2B5A, 0x2D42,
    0x20DE, 0x26BE, 0x283D, 0x2BC9, 0x2B9D, 0x26DA, 0x2806, 0x28F7, 0x32A1, 0x3A65, 0x451E, 0x4E15, 0x579C, 0x59A5, 0x5635, 0x543A,
    0x57B8, 0x53FA, 0x45D9, 0x4534, 0x38B7, 0x3374, 0x2FB8, 0x346D, 0x30A1, 0x2E65, 0x349C, 0x3841, 0x3D36, 0x37A7, 0x3D67, 0x413E,
    0x4459, 0x457E, 0x4256, 0x3EFC, 0x3C9D, 0x35BE, 0x2DDA, 0x2945, 0x2CA8, 0x2AAF, 0x2D61, 0x29EF, 0x278C, 0x2DDF, 0x3022, 0x3A53,
    0x3A26, 0x43A2, 0x46C6, 0x497F, 0x47E2, 0x4692, 0x456D, 0x4470, 0x4654, 0x38EF, 0x35AF, 0x2769, 0x1C0F, 0x0E42, 0x0008, 0xFC4C,
    0xF7AA, 0xF705, 0xF901, 0xF58B, 0xF8F5, 0x03A8, 0x0CF2, 0x0BD0, 0x0C58, 0x10F9, 0x0DB0, 0x13A6, 0x097B, 0x0881, 0x0325, 0x08FB,
    0x0B97, 0x0225, 0x037F, 0x0114, 0x0115, 0x090A, 0x175D, 0x1BEA, 0x28FF, 0x3142, 0x34F1, 0x2EDE, 0x314C, 0x30B4, 0x26AA, 0x1EF4,
    0x11D7, 0x0A24, 0xFE7E, 0xF68E, 0xF063, 0xEBAD, 0xEBE9, 0xEBE0, 0xED50, 0xEAEC, 0xED26, 0xF3EE, 0xF621, 0xFE0C, 0xFE3F, 0xFBD7,
    0xFBE1, 0xF789, 0xF851, 0xEE50, 0xEC70, 0xEBF7, 0xF04C, 0xF0F0, 0xEE33, 0xF290, 0xEF57, 0xF9F3, 0xFD2D, 0x05F7, 0x07FD, 0x109F,
    0x1442, 0x0F2C, 0x10A6, 0x14B5, 0x142C, 0x09F7, 0x088A, 0xF610, 0xEB23, 0xDF21, 0xD166, 0xC75A, 0xC1AC, 0xC171, 0xC14F, 0xC449,
    0xC231, 0xC5FE, 0xCB32, 0xCF68, 0xD40A, 0xD160, 0xCF5A, 0xD293, 0xCC8E, 0xCA17, 0xC68A, 0xC4A8, 0xC5AB, 0xC66C, 0xC4C8, 0xBD4A,
    0xC263, 0xC513, 0xCAF7, 0xD01F, 0xDB55, 0xE3BA, 0xE983, 0xEA6B, 0xE4EC, 0xE5E5, 0xDE07, 0xD9E8, 0xD19C, 0xC7DB, 0xC027, 0xB9C4,
    0xB864, 0xB432, 0xB0BD, 0xB374, 0xB3D5, 0xB526, 0xB380, 0xB409, 0xB8D2, 0xBDF4, 0xBE2C, 0xBC32, 0xBDE3, 0xBD27, 0xBBD6, 0xB7B6,
    0xB1A3, 0xB381, 0xBA09, 0xBB04, 0xC005, 0xBEF1, 0xC216, 0xC797, 0xCC2A, 0xD26B, 0xD77D, 0xDD3F, 0xE0DF, 0xE4E7, 0xE4FB, 0xEADB,
    0xEE17, 0xEB38, 0xEA2F, 0xE0B1, 0xD49E, 0xCC60, 0xC038, 0xB553, 0xAD67, 0xAE57, 0xAF4B, 0xB0E0, 0xB0C2, 0xAF1D, 0xB69C, 0xB6B6,
    0xBEC1, 0xC085, 0xBF09, 0xC32F, 0xC4D1, 0xC3D5, 0xBD12, 0xBE8D, 0xBEB8, 0xBE80, 0xBF02, 0xBE44, 0xBCB3, 0xBF5F, 0xC865, 0xCDCE,
    0xD759, 0xE633, 0xF22F, 0xF834, 0xFA68, 0xFCA7, 0xFAE4, 0xF87D, 0xF574, 0xEDD5, 0xE39F, 0xDD2A, 0xD5EA, 0xD012, 0xCDA4, 0xCA40,
    0xCFAA, 0xCFEB, 0xD1FA, 0xD031, 0xD41C, 0xDD7A, 0xE2D4, 0xE8B4, 0xE912, 0xED46, 0xE936, 0xEABC, 0xE399, 0xDC1F, 0xDED2, 0xE05E,
    0xE538, 0xE8B5, 0xE712, 0xEAA5, 0xED7D, 0xF380, 0xF96F, 0xFBA3, 0x0932, 0x0937, 0x0EE9, 0x11D6, 0x171E, 0x1BA1, 0x1497, 0x127B,
    0x037E, 0xF6FA, 0xEB87, 0xDCA5, 0xD637, 0xCC1C, 0xCBCD, 0xCE81, 0xD04E, 0xD035, 0xCFB5, 0xDB17, 0xDDE0, 0xE50B, 0xEA0D, 0xEC19,
    0xF102, 0xF353, 0xF05C, 0xEB93, 0xEB0C, 0xEEEC, 0xF254, 0xF2BD, 0xF00D, 0xF20A, 0xFC6D, 0x0165, 0x0E0F, 0x17F7, 0x2555, 0x2DB6,
    0x3387, 0x3657, 0x348D, 0x38F2, 0x34E6, 0x33C9, 0x2C77, 0x2509, 0x1F8E, 0x1ACA, 0x1459, 0x0C79, 0x0EAF, 0x118E, 0x10A7, 0x1054,
    0x0A5D, 0x0F0F, 0x14FE, 0x1834, 0x1B96, 0x187B, 0x1A1E, 0x1751, 0x1400, 0x091A, 0x0423, 0x0751, 0x0C09, 0x10DB, 0x1256, 0x119E,
    0x15AD, 0x1715, 0x15A4, 0x18C0, 0x1E3D, 0x242E, 0x2786, 0x2BED, 0x2E0D, 0x33FA, 0x3478, 0x2FDF, 0x2630, 0x1BA5, 0x0E87, 0x0467,
    0xF7FD, 0xEC4C, 0xE661, 0xE668, 0xE784, 0xE582, 0xE376, 0xE5E6, 0xEED2, 0xF603, 0x0091, 0x00EF, 0x099E, 0x0E1D, 0x0E8A, 0x0D15,
    0x08A1, 0x0A23, 0x0DEB, 0x1316, 0x1279, 0x1439, 0x1640, 0x1E88, 0x245C, 0x2E73, 0x3AE5, 0x4837, 0x4F3A, 0x4FA0, 0x536C, 0x5516,
    0x5795, 0x5348, 0x50A3, 0x4821, 0x40B4, 0x3A3F, 0x31ED, 0x2A21, 0x2301, 0x21E9, 0x2345, 0x23F9, 0x21E8, 0x2414, 0x2824, 0x3276,
    0x36D9, 0x38F3, 0x3A53, 0x3A67, 0x38CF, 0x2FB5, 0x2706, 0x247B, 0x27AA, 0x2BCD, 0x2C52, 0x2EF3, 0x2C9A, 0x2E9E, 0x2EE6, 0x2C5B,
    0x342D, 0x385E, 0x3F05, 0x44B2, 0x4AA6, 0x4DD4, 0x50D0, 0x4ED9, 0x4C6F, 0x4128, 0x35D7, 0x29DA, 0x1CB2, 0x0F1C, 0x0615, 0x00DB,
    0x00DF, 0x01A8, 0xFB70, 0xFF41, 0x0098, 0x0BDD, 0x13D8, 0x1A49, 0x2055, 0x25B7, 0x2949, 0x2954, 0x22E9, 0x1C8C, 0x1A1E, 0x1AFA,
    0x1B5E, 0x1A30, 0x194C, 0x1C0C, 0x1F70, 0x23C6, 0x2CD0, 0x35FF, 0x4142, 0x438C, 0x48C7, 0x4A49, 0x4B5A, 0x4976, 0x494D, 0x41E2,
    0x3BF1, 0x353D, 0x2F3B, 0x2862, 0x1BF4, 0x1B27, 0x1A3F, 0x1CAC, 0x18E6, 0x19A1, 0x1B28, 0x20C2, 0x27AA, 0x29D4, 0x2BC9, 0x2B8E,
    0x2C02, 0x2731, 0x1F38, 0x1911, 0x1767, 0x1BA3, 0x1E65, 0x1F78, 0x1F95, 0x1F5C, 0x1E31, 0x1BB2, 0x1CF4, 0x2160, 0x2AC0, 0x319D,
    0x36E3, 0x3B93, 0x3F3A, 0x4037, 0x3FFB, 0x38D6, 0x2B3A, 0x1FA0, 0x116D, 0x01C2, 0xF229, 0xE85D, 0xE3FC, 0xE074, 0xDB24, 0xD67F,
    0xD43A, 0xD639, 0xDD85, 0xE1B7, 0xE505, 0xE8BC, 0xEE2A, 0xF0A1, 0xEC45, 0xE7F0, 0xE242, 0xE1EB, 0xE3CB, 0xE601, 0xE531, 0xE688,
    0xE9C9, 0xEB49, 0xEFEE, 0xF7BE, 0x0221, 0x08AF, 0x0E3D, 0x1100, 0x140F, 0x14E0, 0x155E, 0x10D7, 0x0A01, 0x04B2, 0xFE15, 0xF7A2,
    0xEBD9, 0xE57D, 0xE287, 0xE181, 0xE219, 0xDE6F, 0xDCEA, 0xDD72, 0xE51D, 0xEC8A, 0xEF14, 0xF024, 0xEF4D, 0xEFCF, 0xEAED, 0xE219,
    0xDE67, 0xDDDF, 0xE110, 0xE4AA, 0xE20C, 0xE1A4, 0xE029, 0xDE21, 0xDB67, 0xDD26, 0xE49B, 0xEEB0, 0xF51F, 0xFC5A, 0x020F, 0x03FB,
    0x0635, 0x023F, 0xFA92, 0xEC0F, 0xE130, 0xD58F, 0xC845, 0xBC58, 0xB4B1, 0xB2BC, 0xAF7B, 0xAD08, 0xAA05, 0xA960, 0xAE72, 0xB2AD,
    0xB3EE, 0xB702, 0xBDCF, 0xC3F6, 0xC56B, 0xC17A, 0xBEA1, 0xBA5D, 0xBCA6, 0xBF21, 0xBDA6, 0xC07A, 0xC17B, 0xC81B, 0xCA12, 0xD15F,
    0xDAE8, 0xE3ED, 0xEF73, 0xF44D, 0xF9A4, 0xFC7E, 0x0028, 0x01F9, 0xFEDE, 0xF7EA, 0xF48A, 0xEF4A, 0xE698, 0xDE58, 0xD75F, 0xD840,
    0xD7C4, 0xD7F9, 0xD754, 0xD74F, 0xDBDE, 0xE14D, 0xE4C6, 0xE631, 0xE587, 0xE514, 0xE1A3, 0xDB37, 0xD49F, 0xCF37, 0xD0C1, 0xD2E2,
    0xD43C, 0xD044, 0xD1A7, 0xCEFB, 0xCB4B, 0xCBFF, 0xD0E1, 0xD8F5, 0xE0D1, 0xEBEB, 0xF1DF, 0xF8BA, 0xFCEB, 0xFDFB, 0xFCB1, 0xF50B,
    0xEBBB, 0xE591, 0xD955, 0xCE9B, 0xC362, 0xBE34, 0xBB8C, 0xB7F3, 0xB73B, 0xB350, 0xB66B, 0xBC00, 0xC2CD, 0xC6D1, 0xCC8B, 0xD299,
    0xD5BA, 0xD630, 0xD223, 0xCE75, 0xCBDB, 0xCE5E, 0xD05F, 0xD055, 0xD354, 0xD6F6, 0xDB05, 0xDE9E, 0xE3AA, 0xEB84, 0xF44A, 0xF961,
    0xFAE2, 0xFBBA, 0xFDF9, 0x0133, 0x020B, 0xFEC0, 0xF962, 0xF4FD, 0xEE7E, 0xE4D2, 0xDB27, 0xD600, 0xD499, 0xD5E4, 0xD4A8, 0xD457,
    0xD77E, 0xDB78, 0xE1F8, 0xE235, 0xE2B1, 0xE46B, 0xE728, 0xE5FE, 0xE0AD, 0xDD87, 0xDA36, 0xDDA3, 0xE0F2, 0xDFDE, 0xDDED, 0xDD90,
    0xD9EE, 0xD78C, 0xD842, 0xDFBF, 0xE8DF, 0xF538, 0xFEDB, 0x04DF, 0x0D16, 0x1219, 0x1626, 0x10E2, 0x0931, 0x0262, 0xFB2D, 0xEE1F,
    0xE1F4, 0xD6E1, 0xD1CE, 0xCF00, 0xCDE7, 0xCA41, 0xC68D, 0xCD56, 0xD43C, 0xDB63, 0xE309, 0xEA90, 0xF0BA, 0xF4A7, 0xF36E, 0xEE73,
    0xE821, 0xE906, 0xEA17, 0xEB4E, 0xEBE5, 0xEF50, 0xF499, 0xF681, 0xFBD5, 0x0285, 0x0BCA, 0x15F2, 0x1CD3, 0x1FE9, 0x2333, 0x2502,
    0x28B6, 0x2877, 0x2440, 0x203C, 0x1A2A, 0x128A, 0x0827, 0xFE9D, 0xFABF, 0xFBBD, 0xFCE3, 0xFEC1, 0xFF98, 0x048F, 0x0D97, 0x1045,
    0x11D5, 0x13EC, 0x1534, 0x185A, 0x1896, 0x136B, 0x0E88, 0x0FE8, 0x1460, 0x1615, 0x15A6, 0x148F, 0x1389, 0x1208, 0x11B6, 0x16E9,
    0x2070, 0x2C37, 0x37F9, 0x3FA1, 0x44F4, 0x4B87, 0x4F7B, 0x4FDD, 0x4AF3, 0x452C, 0x403E, 0x3629, 0x2780, 0x17B2, 0x0B37, 0x01C8,
    0xFBEB, 0xF5CF, 0xEE42, 0xEC30, 0xEE8A, 0xF34D, 0xF9FE, 0xFF30, 0x065C, 0x0BDB, 0x0F9E, 0x0C59, 0x0651, 0x02E7, 0x01DF, 0x05B3,
    0x0712, 0x0C1E, 0x10E4, 0x15A6, 0x194C, 0x1D81, 0x2644, 0x2D76, 0x36A2, 0x3BF0, 0x3F49, 0x4458, 0x494D, 0x4DDC, 0x4D39, 0x4CBC,
    0x49F2, 0x458A, 0x3C87, 0x317E, 0x2A60, 0x25A6, 0x2695, 0x27F8, 0x2747, 0x2697, 0x2C19, 0x30A4, 0x3313, 0x33BD, 0x35C6, 0x3AD0,
    0x3DCF, 0x3E4F, 0x3AAB, 0x38E6, 0x38EE, 0x37FE, 0x359F, 0x3162, 0x2CC1, 0x295B, 0x24D1, 0x235F, 0x2783, 0x2EFE, 0x39F1, 0x41FE,
    0x4673, 0x47E8, 0x4A8C, 0x4C46, 0x498E, 0x4851, 0x4277, 0x3A3B, 0x2FA6, 0x1F7B, 0x0F25, 0x020A, 0xF9FC, 0xF453, 0xEC87, 0xE7EB,
    0xE951, 0xECC0, 0xF120, 0xF6D7, 0xFDCC, 0x0376, 0x092B, 0x0A88, 0x039F, 0xFBD6, 0xF7F5, 0xF766, 0xF855, 0xF9C1, 0xFDC2, 0x01EE,
    0x05EE, 0x08DF, 0x0D2F, 0x1696, 0x1F89, 0x274D, 0x2E72, 0x3364, 0x3937, 0x4078, 0x4268, 0x3FBC, 0x3E00, 0x3A10, 0x32FB, 0x27DE,
    0x1BAF, 0x14A9, 0x1407, 0x1566, 0x15D6, 0x1624, 0x1715, 0x19F6, 0x1CE7, 0x2070, 0x20FD, 0x2383, 0x2865, 0x2B4D, 0x2966, 0x23DB,
    0x20DF, 0x1E71, 0x1AF4, 0x16B0, 0x144D, 0x116B, 0x0FDB, 0x0C37, 0x0C03, 0x1255, 0x1A40, 0x2505, 0x2CD6, 0x32A0, 0x3788, 0x3D07,
    0x40F8, 0x3FF9, 0x3DFE, 0x3971, 0x3201, 0x2741, 0x14EA, 0x0343, 0xF862, 0xF127, 0xEA58, 0xE35C, 0xDF36, 0xE01F, 0xE5C5, 0xE97A,
    0xEEDD, 0xF5C5, 0xFDB0, 0x02A1, 0xFF9C, 0xF91C, 0xF30B, 0xF1C7, 0xF193, 0xF28E, 0xF4A6, 0xF967, 0xFCB9, 0xFE04, 0x005D, 0x03E7,
    0x0A2A, 0x11FE, 0x1929, 0x1E59, 0x2333, 0x2925, 0x2E2A, 0x2F28, 0x2DC1, 0x29D6, 0x2427, 0x18E8, 0x0A75, 0xFD15, 0xF550, 0xF479,
    0xF3E4, 0xF09D, 0xEDB9, 0xECAC, 0xEF0A, 0xEFDA, 0xF037, 0xF303, 0xF85E, 0x021B, 0x0627, 0x050B, 0x01C9, 0xFEEF, 0xFAD7, 0xF8F9,
    0xF508, 0xF288, 0xF225, 0xED4C, 0xEC64, 0xEE3D, 0xF50F, 0xFF98, 0x0AF0, 0x1130, 0x16B6, 0x1D79, 0x2363, 0x279B, 0x2727, 0x2415,
    0x1F9D, 0x1591, 0x04C2, 0xF356, 0xE21A, 0xD7A5, 0xD0C1, 0xC97A, 0xC395, 0xC215, 0xC450, 0xC712, 0xCB74, 0xCED1, 0xD3CE, 0xD8A6,
    0xDA56, 0xD548, 0xCD73, 0xC8C9, 0xC4EA, 0xC339, 0xC369, 0xC4FD, 0xC7F7, 0xC8E1, 0xC946, 0xCBEF, 0xCF34, 0xD63A, 0xDE4F, 0xE492,
    0xE9EC, 0xF0A9, 0xF757, 0xFB66, 0xFBF3, 0xF78E, 0xF2E9, 0xEB57, 0xDF37, 0xD23C, 0xC741, 0xC321, 0xC3AE, 0xC191, 0xBF2E, 0xBCF7,
    0xBCCF, 0xBDBC, 0xBE6E, 0xBF24, 0xC2EB, 0xCC87, 0xD326, 0xD531, 0xD4C7, 0xD1EF, 0xCFBF, 0xCE2F, 0xCB82, 0xCB7D, 0xCC44, 0xCCF5,
    0xCD00, 0xCC11, 0xCF75, 0xD689, 0xDDFA, 0xE50D, 0xEB7C, 0xF29E, 0xFBE5, 0x02A0, 0x04D5, 0x040D, 0x0130, 0xFABD, 0xEF51, 0xDE62,
    0xCC31, 0xC0AB, 0xB94E, 0xB351, 0xADBE, 0xAA01, 0xAAD2, 0xADA4, 0xB084, 0xB328, 0xB692, 0xBC11, 0xC0E8, 0xC200, 0xBEE7, 0xBA72,
    0xB7F7, 0xB73A, 0xB87E, 0xBC20, 0xC126, 0xC4D5, 0xC6BD, 0xC760, 0xCA27, 0xD04C, 0xD950, 0xE2B3, 0xEA18, 0xF0F0, 0xF852, 0xFF34,
    0x0296, 0x01E9, 0xFF52, 0xFC2E, 0xF465, 0xEB1C, 0xE0AF, 0xD8F1, 0xD700, 0xD677, 0xD5E1, 0xD23F, 0xD009, 0xD0A0, 0xD305, 0xD55A,
    0xD88D, 0xE100, 0xED05, 0xF545, 0xF6AF, 0xF565, 0xF3A9, 0xF0EE, 0xED55, 0xEBDB, 0xEB2F, 0xEA51, 0xE980, 0xE823, 0xE771, 0xE9D5,
    0xEF23, 0xF695, 0xFCE6, 0x0331, 0x0A4C, 0x11DC, 0x18AA, 0x19DD, 0x1B0D, 0x1863, 0x1257, 0x06CE, 0xF483, 0xE3E5, 0xD895, 0xD2E1,
    0xCC4F, 0xC5D6, 0xC2E8, 0xC463, 0xC941, 0xCDA7, 0xD1D8, 0xD740, 0xE05D, 0xE749, 0xE670, 0xE40E, 0xE09B, 0xDF65, 0xDF22, 0xE0F3,
    0xE6B1, 0xEB4D, 0xEF5C, 0xF090, 0xF0C4, 0xF3C3, 0xFA71, 0x0419, 0x0D87, 0x1681, 0x2041, 0x29E1, 0x30AA, 0x33D2, 0x3411, 0x3251,
    0x302F, 0x2AC1, 0x218B, 0x169E, 0x1067, 0x0DC7, 0x095B, 0x04B3, 0xFEB3, 0xFB25, 0xF96C, 0xF8A6, 0xF858, 0xFBEE, 0x045E, 0x0C79,
    0x114F, 0x0FAF, 0x0D01, 0x0921, 0x0557, 0x0135, 0xFE30, 0xFF4D, 0xFE49, 0xFC16, 0xFABD, 0xFAFE, 0xFDDA, 0x0568, 0x0D78, 0x1404,
    0x1B50, 0x2423, 0x2B86, 0x310A, 0x3411, 0x354B, 0x336F, 0x2C1C, 0x1F14, 0x0D85, 0xFEA9, 0xF381, 0xED17, 0xE5FD, 0xE0CA, 0xDF64,
    0xE099, 0xE547, 0xE946, 0xEE05, 0xF414, 0xFCC5, 0x00D7, 0xFF95, 0xFC4A, 0xF99D, 0xF702, 0xF59A, 0xF8C3, 0xFD2B, 0x01C7, 0x044C,
    0x0636, 0x06AB, 0x0965, 0x1168, 0x1AB2, 0x22E2, 0x2C9A, 0x37AF, 0x400E, 0x4544, 0x46BC, 0x45F6, 0x4479, 0x426B, 0x3D4D, 0x3383,
    0x2ACD, 0x25AE, 0x2296, 0x1F5C, 0x195B, 0x13CF, 0x103D, 0x104A, 0x1192, 0x133F, 0x194B, 0x2420, 0x2CFB, 0x311B, 0x31AB, 0x2ED4,
    0x2B74, 0x27F9, 0x26C2, 0x2698, 0x2682, 0x25CA, 0x235C, 0x2047, 0x1F5E, 0x23C0, 0x2BCE, 0x3260, 0x395C, 0x41BA, 0x4AD2, 0x5328,
    0x56DA, 0x5903, 0x58A6, 0x557B, 0x4F42, 0x42F2, 0x32D6, 0x250E, 0x1AA8, 0x1111, 0x08D3, 0x026C, 0x0083, 0x02E5, 0x066E, 0x08C7,
    0x0C83, 0x13E0, 0x19AE, 0x1A5C, 0x17D3, 0x12ED, 0x0E87, 0x0B4E, 0x08D6, 0x0A4E, 0x0BDE, 0x0C1D, 0x0AC8, 0x0883, 0x0795, 0x0AB3,
    0x1212, 0x1AA7, 0x22F1, 0x2ABA, 0x3450, 0x3C8A, 0x4093, 0x4129, 0x4070, 0x405C, 0x3F1F, 0x3979, 0x3127, 0x2A12, 0x2575, 0x2129,
    0x1B11, 0x1444, 0x0F9F, 0x0E79, 0x0FA5, 0x11CA, 0x1609, 0x1F26, 0x2A8B, 0x3190, 0x3411, 0x34BB, 0x321E, 0x2E3C, 0x2B95, 0x2A64,
    0x2B34, 0x2B7A, 0x2A81, 0x27B1, 0x2432, 0x2512, 0x2AC0, 0x3137, 0x3701, 0x3D58, 0x43DA, 0x4ADA, 0x4F47, 0x5093, 0x4FA4, 0x4C6A,
    0x46CA, 0x3B42, 0x2A21, 0x1728, 0x06E0, 0xF9C6, 0xEDF1, 0xE4AD, 0xDF1F, 0xDE2B, 0xDFB4, 0xE0C4, 0xE210, 0xE4D7, 0xE9CB, 0xECE5,
    0xECF5, 0xEB59, 0xE8AA, 0xE66B, 0xE4CA, 0xE568, 0xE66F, 0xE77E, 0xE762, 0xE5E0, 0xE443, 0xE3FF, 0xE82A, 0xEEF9, 0xF5F0, 0xFCE4,
    0x0485, 0x0B0E, 0x1027, 0x12A2, 0x12AA, 0x12CD, 0x13B4, 0x1278, 0x0BA6, 0x02DA, 0xFC62, 0xF84B, 0xF359, 0xEC65, 0xE639, 0xE314,
    0xE3F9, 0xE597, 0xE7DA, 0xEC3C, 0xF499, 0xFF2F, 0x0483, 0x06B7, 0x064F, 0x03BA, 0xFFB4, 0xFCCC, 0xFC60, 0xFC6F, 0xFDB9, 0xFC70,
    0xF94D, 0xF6C0, 0xF812, 0xFD69, 0x0300, 0x07AC, 0x0DA6, 0x167F, 0x1E7E, 0x2414, 0x274C, 0x27D8, 0x2748, 0x225A, 0x1530, 0x0342,
    0xF22B, 0xE484, 0xDAB8, 0xD244, 0xCBB5, 0xC929, 0xCA4E, 0xCAE3, 0xCA4F, 0xCC2E, 0xD04E, 0xD5B8, 0xD943, 0xDA3D, 0xD923, 0xD717,
    0xD413, 0xD136, 0xD0F3, 0xD23E, 0xD3C2, 0xD4B2, 0xD31F, 0xD2C8, 0xD60B, 0xDCFF, 0xE6E2, 0xEF3B, 0xF8CD, 0x02B4, 0x0B70, 0x11C7,
    0x1479, 0x175A, 0x1AA3, 0x1DAF, 0x1C71, 0x1674, 0x0F14, 0x087E, 0x03C1, 0xFCC1, 0xF4CE, 0xEECA, 0xEC31, 0xEB9F, 0xEB35, 0xEBDB,
    0xF0B6, 0xF84C, 0xFE66, 0x01D1, 0x017F, 0xFF2F, 0xFB06, 0xF66C, 0xF3C4, 0xF2A7, 0xF290, 0xF357, 0xF24B, 0xEFC0, 0xEFF5, 0xF46B,
    0xFAB4, 0x0215, 0x0A26, 0x1440, 0x1FB8, 0x29D4, 0x316F, 0x357E, 0x3917, 0x39E7, 0x343A, 0x27B8, 0x17EC, 0x08DE, 0xFD96, 0xF443,
    0xEBD0, 0xE672, 0xE3A7, 0xE40A, 0xE33F, 0xE1B6, 0xE211, 0xE566, 0xE99A, 0xEB23, 0xEBB7, 0xEA6E, 0xE806, 0xE5E6, 0xE42E, 0xE333,
    0xE387, 0xE487, 0xE3E0, 0xE183, 0xE0E7, 0xE43C, 0xEA8A, 0xF161, 0xF86B, 0xFF2F, 0x05BF, 0x0C40, 0x0F48, 0x1068, 0x137E, 0x17B3,
    0x1A2D, 0x17FF, 0x10F3, 0x095C, 0x031E, 0xFC50, 0xF41C, 0xEB8A, 0xE64F, 0xE48D, 0xE3C3, 0xE2F4, 0xE4B0, 0xE9F9, 0xF0A7, 0xF5CC,
    0xF7F3, 0xF7F1, 0xF4BF, 0xF068, 0xEC42, 0xE8BC, 0xE75B, 0xE7B5, 0xE6F0, 0xE458, 0xE216, 0xE32F, 0xE77B, 0xED6B, 0xF4EE, 0xFD56,
    0x086B, 0x1585, 0x1FF7, 0x2742, 0x2D0B, 0x3109, 0x30CC, 0x2980, 0x1C5D, 0x0C5F, 0xFE87, 0xF395, 0xEA5D, 0xE2D1, 0xDDF2, 0xDCAC,
    0xDBEB, 0xD99E, 0xD7CB, 0xD912, 0xDC91, 0xE074, 0xE38B, 0xE4EF, 0xE447, 0xE1C8, 0xDE88, 0xDB27, 0xD8DF, 0xD8C3, 0xD8CD, 0xD797,
    0xD651, 0xD81C, 0xDDA5, 0xE545, 0xED53, 0xF448, 0xFBC1, 0x03C3, 0x0AC2, 0x0F14, 0x1324, 0x1950, 0x1EDD, 0x2169, 0x1DEB, 0x16BF,
    0x0FBA, 0x0961, 0x0316, 0xFBDF, 0xF50A, 0xF242, 0xF127, 0xEF68, 0xEF4A, 0xF210, 0xF860, 0x002B, 0x0689, 0x0974, 0x09E3, 0x07AE,
    0x0392, 0xFF8A, 0xFD9D, 0xFD8D, 0xFE62, 0xFDEE, 0xFB9C, 0xF9E1, 0xFB8C, 0x002A, 0x0642, 0x0E3C, 0x17C2, 0x249A, 0x30C6, 0x39DB,
    0x3F63, 0x4306, 0x44A8, 0x40A7, 0x36A5, 0x26FA, 0x16D4, 0x0921, 0xFD64, 0xF302, 0xEA6E, 0xE51B, 0xE289, 0xDFBA, 0xDBF1, 0xDA70,
    0xDBBB, 0xDF03, 0xE30B, 0xE5F5, 0xE792, 0xE710, 0xE447, 0xE070, 0xDDBF, 0xDD24, 0xDE7F, 0xDF84, 0xDFCB, 0xE122, 0xE5BF, 0xED61,
    0xF581, 0xFD9E, 0x0406, 0x0B8C, 0x13F8, 0x1A78, 0x1F27, 0x2514, 0x2BFA, 0x31A0, 0x32C1, 0x2D87, 0x25A9, 0x1ECD, 0x1928, 0x1212,
    0x0A9E, 0x0525, 0x03B5, 0x02AF, 0x0188, 0x026B, 0x063F, 0x0D96, 0x147C, 0x19E1, 0x1C6B, 0x1B30, 0x1761, 0x11B5, 0x0B69, 0x0812,
    0x068C, 0x052D, 0x018C, 0xFBD7, 0xF80C, 0xF73C, 0xF92C, 0xFD23, 0x0347, 0x0D5C, 0x1A93, 0x25C8, 0x2CFF, 0x3162, 0x3402, 0x335C,
    0x2D81, 0x20E4, 0x10F1, 0x018F, 0xF4F6, 0xEA87, 0xE034, 0xD85A, 0xD3DE, 0xD06E, 0xCC77, 0xC89D, 0xC7CD, 0xC9BD, 0xCD1E, 0xD14E,
    0xD484, 0xD65B, 0xD58A, 0xD2D6, 0xCF38, 0xCD13, 0xCE51, 0xD0D5, 0xD28B, 0xD3AE, 0xD681, 0xDB9C, 0xE2B0, 0xEA30, 0xF071, 0xF6ED,
    0xFF1F, 0x072E, 0x0CD3, 0x1266, 0x1970, 0x20C3, 0x255D, 0x24F0, 0x1E48, 0x1587, 0x0E35, 0x0683, 0xFE75, 0xF6BD, 0xF303, 0xF109,
    0xEECE, 0xECF4, 0xEDA3, 0xF138, 0xF6B6, 0xFD1F, 0x0239, 0x047F, 0x0394, 0x0067, 0xFB14, 0xF65B, 0xF474, 0xF4B4, 0xF3B1, 0xF0B5,
    0xED50, 0xEC3C, 0xEDD8, 0xF22E, 0xF7EC, 0x006B, 0x0DAD, 0x1BBE, 0x276D, 0x2F83, 0x3599, 0x3978, 0x3A40, 0x33EB, 0x2842, 0x1ABB,
    0x0E8E, 0x0581, 0xFBD1, 0xF2E0, 0xEC4F, 0xE796, 0xE266, 0xDD02, 0xD98B, 0xD9CD, 0xDD1A, 0xE30B, 0xE9A0, 0xEE10, 0xF069, 0xEF08,
    0xEAB7, 0xE61E, 0xE422, 0xE5E1, 0xE8BB, 0xEAF1, 0xECC5, 0xEFE6, 0xF552, 0xFACA, 0xFF4D, 0x03E0, 0x09CE, 0x1172, 0x17E0, 0x1C2B,
    0x2157, 0x2775, 0x2D29, 0x2ED4, 0x2ACA, 0x2308, 0x1A3E, 0x12D0, 0x0A16, 0x00FA, 0xFA98, 0xF748, 0xF4E3, 0xF1E8, 0xF085, 0xF223,
    0xF6C8, 0xFD73, 0x041A, 0x08F0, 0x0B72, 0x0BE2, 0x0886, 0x037B, 0x003A, 0xFFEF, 0x002A, 0xFE3B, 0xFAF3, 0xF846, 0xF85A, 0xFB1F,
    0x007B, 0x0765, 0x122F, 0x20C5, 0x2E3C, 0x38C2, 0x400F, 0x44D6, 0x4804, 0x477C, 0x4123, 0x36F9, 0x2C32, 0x2305, 0x1A4A, 0x0FD8,
    0x06EF, 0xFFB7, 0xF91C, 0xF1BB, 0xE98D, 0xE4A7, 0xE35C, 0xE585, 0xEA50, 0xEEBB, 0xEFF3, 0xEE13, 0xE868, 0xDFC8, 0xD92E, 0xD6E8,
    0xD7C4, 0xD9B7, 0xDAE0, 0xDC05, 0xDE59, 0xE1CA, 0xE4CA, 0xE794, 0xEC66, 0xF406, 0xFCDC, 0x03C6, 0x09F5, 0x10B6, 0x17F4, 0x1E4C,
    0x1F1A, 0x1A25, 0x12BB, 0x0B14, 0x037E, 0xFA50, 0xF155, 0xEBD9, 0xE89A, 0xE55E, 0xE322, 0xE2E7, 0xE619, 0xEBC8, 0xF1E7, 0xF887,
    0xFD22, 0x003E, 0x0018, 0xFCA4, 0xF8C8, 0xF6BF, 0xF675, 0xF4DC, 0xF18F, 0xEC90, 0xE9B2, 0xEA39, 0xECF6, 0xF1B1, 0xFA03, 0x066B,
    0x1509, 0x21B1, 0x29FF, 0x30BA, 0x3598, 0x38FC, 0x37C0, 0x30C8, 0x2713, 0x1D48, 0x14CF, 0x0ADB, 0xFFBA, 0xF67E, 0xEF3B, 0xE770,
    0xDF98, 0xD98B, 0xD6A5, 0xD7BB, 0xDBA6, 0xE0B4, 0xE422, 0xE580, 0xE3DD, 0xDDC3, 0xD684, 0xD20C, 0xD223, 0xD451, 0xD764, 0xD90D,
    0xDB1D, 0xDF81, 0xE444, 0xE86D, 0xEBFC, 0xF227, 0xFB5C, 0x0517, 0x0CD3, 0x1493, 0x1D13, 0x24FD, 0x2A91, 0x29DB, 0x247C, 0x1D86,
    0x1755, 0x108B, 0x0892, 0x0200, 0xFE30, 0xFBD1, 0xF98D, 0xF881, 0xF95E, 0xFD05, 0x0389, 0x0A6F, 0x1095, 0x15A2, 0x18D2, 0x17CC,
    0x1315, 0x0EAD, 0x0C26, 0x0A21, 0x05F4, 0x004E, 0xF99E, 0xF5E7, 0xF621, 0xF89F, 0xFDC6, 0x058D, 0x1157, 0x1DFB, 0x26D3, 0x2CD8,
    0x3145, 0x3445, 0x35D7, 0x3255, 0x2A0D, 0x204F, 0x17B4, 0x0E61, 0x03E5, 0xF9EF, 0xF178, 0xEAFA, 0xE439, 0xDE33, 0xDAB5, 0xDAF3,
    0xDEFD, 0xE59D, 0xEBA1, 0xF055, 0xF2E1, 0xF11E, 0xEB75, 0xE585, 0xE3A2, 0xE51D, 0xE834, 0xEA70, 0xEB8E, 0xEE20, 0xF1E7, 0xF5F3,
    0xF9AA, 0xFE3E, 0x063F, 0x1094, 0x1A12, 0x2177, 0x285C, 0x300C, 0x3727, 0x3981, 0x3589, 0x2E05, 0x2563, 0x1C26, 0x1182, 0x064A,
    0xFDDA, 0xF80B, 0xF2D2, 0xEE25, 0xEA87, 0xE974, 0xEC39, 0xF1EF, 0xF842, 0xFEA0, 0x0418, 0x06E2, 0x04E5, 0x007E, 0xFC9D, 0xFA19,
    0xF7BD, 0xF2B4, 0xEC00, 0xE70F, 0xE5D2, 0xE711, 0xEA47, 0xF04E, 0xF9E7, 0x058C, 0x1066, 0x1788, 0x1BCD, 0x2014, 0x244A, 0x25BB,
    0x214F, 0x18FA, 0x1000, 0x0782, 0xFDBD, 0xF1FA, 0xE812, 0xDFFD, 0xD923, 0xD367, 0xCEDF, 0xCD40, 0xCF2C, 0xD455, 0xDA53, 0xDF34,
    0xE2C4, 0xE4AA, 0xE1F4, 0xDD0E, 0xD957, 0xD872, 0xDAFE, 0xDD54, 0xDDFD, 0xDE6C, 0xE010, 0xE31A, 0xE5F6, 0xE92C, 0xEEBB, 0xF779,
    0x01C3, 0x0A1D, 0x1117, 0x1813, 0x2042, 0x270F, 0x28CE, 0x2462, 0x1E6C, 0x17C7, 0x0F95, 0x0662, 0xFCBB, 0xF6A9, 0xF1E5, 0xEE6E,
    0xEB9B, 0xE9B2, 0xEB22, 0xF02A, 0xF6D8, 0xFE84, 0x069C, 0x0DA7, 0x1157, 0x108C, 0x0DDE, 0x0AA7, 0x07B5, 0x044E, 0xFDBE, 0xF664,
    0xF2C4, 0xF2C4, 0xF5DE, 0xFAC4, 0x027B, 0x0DA0, 0x19CC, 0x2408, 0x2B4E, 0x30A5, 0x36EC, 0x3D51, 0x3F90, 0x3C6A, 0x36B3, 0x3078,
    0x27E2, 0x1D0D, 0x1129, 0x06B7, 0xFE84, 0xF743, 0xF139, 0xEC45, 0xEA44, 0xEBFF, 0xEF2F, 0xF27B, 0xF49C, 0xF522, 0xF238, 0xEC08,
    0xE48A, 0xDEF9, 0xDCE4, 0xDD29, 0xDD0B, 0xDAD3, 0xD997, 0xDA71, 0xDC24, 0xDDE5, 0xE098, 0xE70A, 0xF0E6, 0xFB6F, 0x0523, 0x0E16,
    0x1861, 0x23EB, 0x2BF0, 0x2DBA, 0x2B4B, 0x273C, 0x215E, 0x19A8, 0x10C4, 0x0954, 0x04E2, 0x01A0, 0xFEEF, 0xFCD1, 0xFBB3, 0xFDEE,
    0x03B6, 0x09EA, 0x1120, 0x190D, 0x1EDE, 0x2090, 0x1E98, 0x1B1B, 0x1714, 0x1399, 0x0DE4, 0x05E0, 0xFF2A, 0xFC13, 0xFD34, 0x0094,
    0x05BA, 0x0D6C, 0x17D2, 0x2226, 0x28EB, 0x2D68, 0x31E4, 0x37CE, 0x3C57, 0x3C39, 0x378B, 0x3058, 0x2778, 0x1BC8, 0x0E03, 0x0057,
    0xF529, 0xEC58, 0xE4BD, 0xDDDD, 0xD8B1, 0xD6CD, 0xD862, 0xDA9A, 0xDC3F, 0xDECB, 0xDF9A, 0xDD36, 0xD844, 0xD2E2, 0xCFC1, 0xCEE8,
    0xCEF8, 0xCD55, 0xCA80, 0xC94B, 0xC9FA, 0xCACF, 0xCB86, 0xCE81, 0xD4B6, 0xDDC7, 0xE7D3, 0xF12F, 0xFA9B, 0x063F, 0x11E7, 0x18E0,
    0x1A7C, 0x185B, 0x143E, 0x0E6E, 0x0677, 0xFE32, 0xF83E, 0xF406, 0xF107, 0xEE11, 0xEB1C, 0xEA28, 0xEC55, 0xF0D0, 0xF692, 0xFE75,
    0x06C7, 0x0BD7, 0x0CA2, 0x0A69, 0x0729, 0x037D, 0xFFEA, 0xFA4B, 0xF287, 0xED2E, 0xEBBE, 0xED48, 0xF0F6, 0xF68F, 0xFF4C, 0x0A2B,
    0x1471, 0x1BC1, 0x205C, 0x26D2, 0x2E33, 0x3363, 0x339E, 0x2F8F, 0x296B, 0x20A5, 0x1517, 0x07F0, 0xFC44, 0xF2EF, 0xECCC, 0xE80D,
    0xE3C5, 0xE164, 0xE23A, 0xE4D9, 0xE72D, 0xEA9E, 0xEE27, 0xEF9F, 0xEDC2, 0xE9D0, 0xE525, 0xE291, 0xE23A, 0xE0E8, 0xDF17, 0xDDB2,
    0xDDF4, 0xE030, 0xE248, 0xE540, 0xEB05, 0xF48A, 0xFF81, 0x0976, 0x125E, 0x1B7B, 0x274A, 0x3126, 0x3547, 0x34AB, 0x3152, 0x2B7C,
    0x23AE, 0x1A79, 0x11C1, 0x0A44, 0x0483, 0xFFA7, 0xF93B, 0xF390, 0xF0EA, 0xF1F1, 0xF4A4, 0xFA6D, 0x0345, 0x0A8B, 0x0E6B, 0x0DBA,
    0x096F, 0x045F, 0xFFC4, 0xFB28, 0xF526, 0xEF34, 0xECD1, 0xEE52, 0xF195, 0xF6A0, 0xFDE1, 0x0758, 0x1267, 0x1C24, 0x2289, 0x28FC,
    0x31BB, 0x3A97, 0x4026, 0x40E8, 0x3EC3, 0x398B, 0x3195, 0x26D2, 0x1B13, 0x103E, 0x07B3, 0x0225, 0xFD7B, 0xF8E5, 0xF639, 0xF612,
    0xF699, 0xF889, 0xFBAB, 0xFF1F, 0x00B5, 0xFF27, 0xFB47, 0xF780, 0xF657, 0xF597, 0xF354, 0xEF4A, 0xEBBD, 0xEA44, 0xE8FE, 0xE810,
    0xE8C0, 0xECAF, 0xF380, 0xFB31, 0x01E2, 0x08CF, 0x1249, 0x1D21, 0x2573, 0x2793, 0x25E8, 0x2239, 0x1BE8, 0x13F6, 0x0B05, 0x0230,
    0xFB1E, 0xF4F6, 0xEDED, 0xE633, 0xE09F, 0xDEAC, 0xDF91, 0xE3A4, 0xEAB0, 0xF397, 0xFB31, 0xFE3D, 0xFC94, 0xF70A, 0xF123, 0xEC1D,
    0xE69A, 0xE08F, 0xDC32, 0xDB6F, 0xDD94, 0xE10E, 0xE5B7, 0xED06, 0xF6E2, 0x020C, 0x0ACD, 0x1156, 0x1990, 0x238E, 0x2CE1, 0x321A,
    0x32D1, 0x3073, 0x2A29, 0x20F3, 0x1578, 0x0991, 0xFF20, 0xF754, 0xF182, 0xEC1B, 0xE723, 0xE461, 0xE362, 0xE34C, 0xE54E, 0xE84B,
    0xEB97, 0xEB97, 0xE8B1, 0xE448, 0xE0E2, 0xDF86, 0xDF17, 0xDCEE, 0xDA55, 0xD9AD, 0xD99A, 0xDA4C, 0xDAC5, 0xDDAC, 0xE465, 0xEDF4,
    0xF79B, 0xFF9F, 0x08AB, 0x1416, 0x1F4D, 0x2710, 0x2A4B, 0x2A4B, 0x27E4, 0x23DC, 0x1D5A, 0x1668, 0x0FAC, 0x0A83, 0x0543, 0xFE41,
    0xF786, 0xF2D1, 0xF136, 0xF251, 0xF73F, 0xFF08, 0x0792, 0x0D7C, 0x0EED, 0x0B2D, 0x05BF, 0x0130, 0xFD4E, 0xF8A5, 0xF40E, 0xF260,
    0xF324, 0xF683, 0xFA50, 0xFEF5, 0x0755, 0x119E, 0x1B66, 0x2368, 0x29E9, 0x323A, 0x3C2E, 0x42AA, 0x4436, 0x42BE, 0x3D58, 0x3463,
    0x287E, 0x1AFD, 0x0D9F, 0x034B, 0xFB31, 0xF35A, 0xEBAB, 0xE570, 0xE1CF, 0xDE84, 0xDDAF, 0xDF53, 0xE2D9, 0xE5D8, 0xE621, 0xE36C,
    0xDF8D, 0xDDBC, 0xDD9D, 0xDD80, 0xDBFC, 0xDA57, 0xD9A4, 0xDA2D, 0xDADF, 0xDC22, 0xE076, 0xE924, 0xF49E, 0xFFB5, 0x0A65, 0x1578,
    0x2256, 0x2DBD, 0x34A8, 0x385C, 0x3953, 0x380B, 0x341E, 0x2F3E, 0x2808, 0x2059, 0x19CD, 0x12CE, 0x0AA2, 0x0398, 0xFF79, 0xFE9C,
    0x0103, 0x06AD, 0x0FC0, 0x17E6, 0x1C59, 0x1A7F, 0x145C, 0x0D62, 0x0670, 0x0019, 0xF881, 0xF1CD, 0xEEA4, 0xEE32, 0xEEAF, 0xEFD0,
    0xF266, 0xF8FB, 0x0229, 0x0A4D, 0x11A5, 0x18D7, 0x22F8, 0x2CD6, 0x331F, 0x3584, 0x3384, 0x2E11, 0x2506, 0x190A, 0x0B2F, 0xFE43,
    0xF485, 0xEC98, 0xE413, 0xDC6E, 0xD5B9, 0xD0D4, 0xCDF6, 0xCCDD, 0xCF72, 0xD37A, 0xD5FA, 0xD595, 0xD290, 0xD02E, 0xCF8E, 0xCFEE,
    0xCF44, 0xCDBD, 0xCD23, 0xCD0A, 0xCCA9, 0xCCDD, 0xCE91, 0xD3C9, 0xDD49, 0xE7B8, 0xF182, 0xFA6A, 0x0586, 0x116C, 0x1A45, 0x205C,
    0x23A9, 0x23E3, 0x2236, 0x1E8C, 0x1868, 0x109E, 0x096E, 0x030C, 0xFB29, 0xF34A, 0xED19, 0xEAA6, 0xEB0C, 0xEF08, 0xF78C, 0x017A,
    0x0A0B, 0x0D6B, 0x0ADB, 0x0531, 0xFFC6, 0xFB4C, 0xF626, 0xF1B4, 0xEEA5, 0xEDD5, 0xEED5, 0xEFA8, 0xF15C, 0xF658, 0xFFA3, 0x0A3A,
    0x1332, 0x1B21, 0x248C, 0x2F37, 0x37EB, 0x3D28, 0x3E70, 0x3CDC, 0x372E, 0x2E43, 0x22F7, 0x168C, 0x0BEF, 0x0283, 0xF9DE, 0xF175,
    0xEA1F, 0xE4A5, 0xE098, 0xDEF8, 0xE052, 0xE4F2, 0xEA89, 0xEE7B, 0xEE8A, 0xEC55, 0xEB7E, 0xECA0, 0xEE54, 0xEE40, 0xEC05, 0xE935,
    0xE631, 0xE417, 0xE289, 0xE25B, 0xE6BF, 0xEE38, 0xF5CC, 0xFC5E, 0x03FD, 0x0CF4, 0x15FF, 0x1D50, 0x22DA, 0x2616, 0x25BD, 0x230C,
    0x1CDA, 0x1402, 0x0B57, 0x02D9, 0xFA84, 0xF309, 0xEC2E, 0xE7DE, 0xE683, 0xE928, 0xF019, 0xF994, 0x04B6, 0x0D21, 0x108C, 0x0E67,
    0x0A7A, 0x0803, 0x05AB, 0x02FD, 0x0122, 0x0099, 0x0154, 0x01DD, 0x0187, 0x0314, 0x08BC, 0x1233, 0x1C9B, 0x2568, 0x2E1B, 0x38CC,
    0x42E2, 0x4A13, 0x4E1A, 0x4EEF, 0x4C1F, 0x46BF, 0x3E37, 0x32A5, 0x26F3, 0x1C4B, 0x11FF, 0x0724, 0xFCD8, 0xF3D0, 0xEBD2, 0xE598,
    0xE218, 0xE17E, 0xE481, 0xE843, 0xE94D, 0xE7A0, 0xE4BF, 0xE2BD, 0xE19D, 0xDFBA, 0xDCC2, 0xD918, 0xD66F, 0xD43C, 0xD10B, 0xCF92,
    0xD1FC, 0xD893, 0xE051, 0xE76E, 0xED70, 0xF3AA, 0xFBD1, 0x03B7, 0x0AF9, 0x1089, 0x13BE, 0x151C, 0x12D6, 0x0C41, 0x03E5, 0xFB96,
    0xF2E0, 0xEAA4, 0xE302, 0xDD34, 0xDAE9, 0xDB8D, 0xDEE2, 0xE652, 0xF135, 0xFC26, 0x0369, 0x0484, 0x00F2, 0xFCF3, 0xFA6A, 0xF80D,
    0xF543, 0xF35E, 0xF277, 0xF220, 0xF12B, 0xEFA8, 0xF0D6, 0xF6C1, 0xFFBE, 0x08D9, 0x116A, 0x1B23, 0x26A7, 0x30AC, 0x38BE, 0x3DF9,
    0x3F4D, 0x3D7C, 0x37E7, 0x2F3B, 0x247A, 0x1AB4, 0x11C4, 0x087F, 0xFEA2, 0xF528, 0xECE0, 0xE5BB, 0xE037, 0xDD82, 0xDEAD, 0xE201,
    0xE50C, 0xE51E, 0xE264, 0xE003, 0xDEEB, 0xDE79, 0xDC65, 0xD8ED, 0xD6EC, 0xD552, 0xD36A, 0xD1AF, 0xD1CC, 0xD605, 0xDE57, 0xE76E,
    0xEEF5, 0xF5CF, 0xFE6D, 0x07EE, 0x1129, 0x19DE, 0x20FE, 0x26C4, 0x296B, 0x2844, 0x22DC, 0x1B48, 0x13D5, 0x0BAB, 0x03C0, 0xFCD5,
    0xF881, 0xF6FF, 0xF799, 0xFB2A, 0x0278, 0x0C2C, 0x14C5, 0x18C5, 0x16D6, 0x11EB, 0x0D0E, 0x0880, 0x030F, 0xFD76, 0xF882, 0xF48C,
    0xF165, 0xED07, 0xEA14, 0xEBC4, 0xF213, 0xFA99, 0x0344, 0x0BD3, 0x162A, 0x215D, 0x2BA3, 0x3417, 0x3987, 0x3C14, 0x3B72, 0x36CF,
    0x2ED7, 0x259F, 0x1D2E, 0x14DA, 0x0C43, 0x02EF, 0xFA01, 0xF23B, 0xEB67, 0xE68E, 0xE59C, 0xE957, 0xEFB4, 0xF4FA, 0xF5C0, 0xF4E1,
    0xF402, 0xF363, 0xF1D9, 0xEF2A, 0xEC1A, 0xE994, 0xE7B3, 0xE5C8, 0xE3C8, 0xE490, 0xEA9C, 0xF385, 0xFC3D, 0x031E, 0x0AB7, 0x1337,
    0x1C77, 0x2594, 0x2D01, 0x3379, 0x374E, 0x370D, 0x3172, 0x2812, 0x1D7B, 0x12AD, 0x082D, 0xFDF8, 0xF6B8, 0xF21C, 0xEFE0, 0xEF81,
    0xF18B, 0xF777, 0xFFA2, 0x05D8, 0x06EF, 0x0355, 0xFE64, 0xFA99, 0xF6E9, 0xF27E, 0xED9B, 0xE9B6, 0xE635, 0xE2EB, 0xDF9E, 0xDDAA,
    0xE137, 0xE8C2, 0xF144, 0xF94E, 0x0144, 0x0AB1, 0x1434, 0x1D5D, 0x244F, 0x28F9, 0x2AE9, 0x295C, 0x23C1, 0x1B36, 0x128B, 0x0AB6,
    0x037F, 0xFB65, 0xF37D, 0xEC06, 0xE523, 0xDE55, 0xDA97, 0xDAC9, 0xDF0A, 0xE586, 0xE942, 0xE9AC, 0xE837, 0xE719, 0xE5CB, 0xE37F,
    0xE029, 0xDD68, 0xDC47, 0xDBA5, 0xDA94, 0xDA28, 0xDD64, 0xE42C, 0xEB9E, 0xF19A, 0xF6DD, 0xFDB9, 0x06CA, 0x10DA, 0x1A79, 0x232A,
    0x2A23, 0x2D93, 0x2BA3, 0x24A6, 0x1A99, 0x0FC5, 0x0534, 0xFACC, 0xF253, 0xECBB, 0xEA13, 0xE98F, 0xEA7B, 0xEF05, 0xF72A, 0x012B,
    0x0919, 0x0BF5, 0x0B1F, 0x0A23, 0x0934, 0x069C, 0x032A, 0xFF41, 0xFC18, 0xF8D0, 0xF4ED, 0xF0D0, 0xEF94, 0xF487, 0xFC5D, 0x04B7,
    0x0D8B, 0x177D, 0x223D, 0x2D12, 0x371D, 0x3E6B, 0x43A6, 0x4592, 0x4357, 0x3D07, 0x33E5, 0x2AD9, 0x228C, 0x1988, 0x0FBC, 0x0680,
    0xFD77, 0xF47D, 0xEC25, 0xE6BD, 0xE5B1, 0xE954, 0xEE60, 0xF0AA, 0xEF70, 0xED5D, 0xEB5C, 0xE7CE, 0xE2F5, 0xDDAB, 0xDA2C, 0xD8CD,
    0xD774, 0xD54C, 0xD4FF, 0xD880, 0xDEB5, 0xE4E5, 0xEA86, 0xF0AD, 0xF93E, 0x04F1, 0x1175, 0x1DB1, 0x28AF, 0x30E0, 0x3414, 0x3205,
    0x2AFC, 0x21DF, 0x1957, 0x1138, 0x09FD, 0x04F8, 0x023B, 0x00C9, 0x0068, 0x01EB, 0x06AE, 0x0F0D, 0x183A, 0x1E97, 0x2063, 0x1F78,
    0x1E60, 0x1C54, 0x18B5, 0x1411, 0x0FAD, 0x0C89, 0x0928, 0x042F, 0xFFD2, 0xFFEA, 0x04AD, 0x0B40, 0x1233, 0x1935, 0x2078, 0x28C2,
    0x3102, 0x37DA, 0x3D6A, 0x40FC, 0x4103, 0x3CE0, 0x3506, 0x2B27, 0x2170, 0x180F, 0x0DF1, 0x0362, 0xF8FE, 0xEEE3, 0xE493, 0xDC1A,
    0xD701, 0xD6B9, 0xDA9A, 0xDE33, 0xDFBC, 0xDE72, 0xDC59, 0xDA31, 0xD650, 0xD1C5, 0xCE16, 0xCCA1, 0xCC0F, 0xCA81, 0xC911, 0xC9F1,
    0xCE0B, 0xD2F6, 0xD7F5, 0xDD52, 0xE503, 0xF001, 0xFBB5, 0x08C6, 0x157E, 0x208B, 0x2897, 0x2B04, 0x27AB, 0x20F4, 0x1954, 0x10BC,
    0x0996, 0x034D, 0xFD82, 0xF93A, 0xF542, 0xF21A, 0xF13F, 0xF4D8, 0xFBF4, 0x03C4, 0x09A0, 0x0B6A, 0x0BE9, 0x0B84, 0x086A, 0x02DC,
    0xFD53, 0xF9CD, 0xF664, 0xF3E4, 0xF00D, 0xEE31, 0xF01A, 0xF58B, 0xFC9B, 0x0277, 0x0A29, 0x1261, 0x1AFF, 0x233E, 0x2A46, 0x3090,
    0x34D9, 0x36C1, 0x3319, 0x2BBD, 0x2648, 0x1F6F, 0x170C, 0x0E68, 0x0445, 0xFB14, 0xF15A, 0xE64E, 0xDD6F, 0xD8E0, 0xDA8E, 0xDEFC,
    0xE324, 0xE2F8, 0xE027, 0xDEC8, 0xDB5B, 0xD65D, 0xD0AE, 0xCDA7, 0xCCCB, 0xCC98, 0xCC15, 0xCB70, 0xCC62, 0xD08B, 0xD69F, 0xDC15,
    0xE247, 0xEAC4, 0xF68A, 0x053A, 0x13B1, 0x1FA1, 0x290D, 0x2DD8, 0x2D1B, 0x271E, 0x1E4E, 0x141D, 0x09D8, 0x0198, 0xF96A, 0xF228,
    0xEC35, 0xE677, 0xE291, 0xE1E6, 0xE5D7, 0xED24, 0xF52B, 0xF9A8, 0xFC14, 0xFE6D, 0xFE9C, 0xFC71, 0xF842, 0xF44B, 0xF15C, 0xEF8D,
    0xED61, 0xEA7E, 0xEA10, 0xEDE9, 0xF546, 0xFED4, 0x07C3, 0x10EB, 0x1C1B, 0x2751, 0x3256, 0x3C61, 0x4560, 0x4BD7, 0x4DCF, 0x4B8B,
    0x4654, 0x3FA5, 0x3843, 0x30EA, 0x28A6, 0x1F7A, 0x1576, 0x0B29, 0x0107, 0xFA3A, 0xF882, 0xFB90, 0x0110, 0x0464, 0x04E7, 0x0206,
    0xFC67, 0xF521, 0xEC03, 0xE45C, 0xE041, 0xDD75, 0xDA16, 0xD6BE, 0xD4A2, 0xD42A, 0xD603, 0xD99C, 0xDD86, 0xE286, 0xEB7E, 0xF835,
    0x0567, 0x1172, 0x1B08, 0x2232, 0x2569, 0x23BC, 0x1E75, 0x16D2, 0x0E17, 0x0607, 0xFECE, 0xF722, 0xEF71, 0xE926, 0xE2BC, 0xDD9C,
    0xDCB3, 0xDF9B, 0xE5B5, 0xEACD, 0xEE40, 0xF0D0, 0xF281, 0xF1E4, 0xEE92, 0xEB47, 0xE955, 0xE877, 0xE76F, 0xE55E, 0xE47D, 0xE602,
    0xEA54, 0xF12E, 0xF899, 0x01F2, 0x0C5C, 0x17AF, 0x22D8, 0x2CB8, 0x350E, 0x3BD4, 0x3F3D, 0x3DEA, 0x39C4, 0x328E, 0x29CF, 0x20F9,
    0x1774, 0x0D47, 0x028E, 0xF83B, 0xEDD3, 0xE47B, 0xDEEA, 0xDE6F, 0xE2FF, 0xE831, 0xEB00, 0xEC7A, 0xED05, 0xEACB, 0xE6D4, 0xE298,
    0xDFC6, 0xDEC8, 0xDDD2, 0xDB38, 0xD779, 0xD51C, 0xD5B1, 0xD8B7, 0xDCD2, 0xE298, 0xEB06, 0xF736, 0x04E2, 0x1383, 0x211D, 0x2D75,
    0x36AE, 0x38FA, 0x3696, 0x30E7, 0x2964, 0x213D, 0x1992, 0x1252, 0x0BD4, 0x063F, 0x008A, 0xFB13, 0xF73B, 0xF8F6, 0x0137, 0x0BFD,
    0x1434, 0x1952, 0x1CE0, 0x1D3E, 0x19B2, 0x13F8, 0x0EAA, 0x0A8A, 0x079E, 0x050E, 0x030A, 0x0210, 0x03D1, 0x07A4, 0x0CEF, 0x1503,
    0x1DAE, 0x257C, 0x2C85, 0x3382, 0x3985, 0x3F40, 0x43BD, 0x44FB, 0x43A8, 0x3EEC, 0x37C7, 0x2F7B, 0x2675, 0x1BE2, 0x10C1, 0x0729,
    0xFCF6, 0xF2AD, 0xE8DF, 0xE31B, 0xE3F5, 0xE7DB, 0xEB26, 0xEC68, 0xED34, 0xED99, 0xEC23, 0xE8A3, 0xE4A0, 0xE2B8, 0xE2BB, 0xE1FE,
    0xDF68, 0xDC2A, 0xDA43, 0xDB41, 0xDEE2, 0xE499, 0xECBD, 0xF75A, 0x0519, 0x1411, 0x2258, 0x2F87, 0x39BE, 0x3EE2, 0x3FA3, 0x3CAC,
    0x366B, 0x2EE6, 0x2752, 0x1F2A, 0x16E5, 0x0FF2, 0x090B, 0x015E, 0xF9B8, 0xF516, 0xF630, 0xFC57, 0x02BF, 0x0758, 0x0ACB, 0x0D03,
    0x0D86, 0x0A96, 0x05C8, 0x0115, 0xFD7C, 0xFA5D, 0xF6BA, 0xF2AC, 0xEFF0, 0xF11C, 0xF58D, 0xFB7A, 0x01D3, 0x0926, 0x11D4, 0x1AE7,
    0x237B, 0x2C85, 0x356B, 0x3C22, 0x4010, 0x3FA0, 0x3B5A, 0x3390, 0x2A88, 0x20C5, 0x159F, 0x0AA4, 0xFFEC, 0xF523, 0xEA72, 0xE2FF,
    0xE168, 0xE4AD, 0xE954, 0xEC7A, 0xED49, 0xED6D, 0xEC67, 0xE84F, 0xE277, 0xDD83, 0xDB1E, 0xD9FA, 0xD791, 0xD390, 0xCFD6, 0xCEF5,
    0xD10C, 0xD4B4, 0xDA20, 0xE186, 0xEAD4, 0xF65B, 0x02DD, 0x0F95, 0x1C4D, 0x2711, 0x2E5D, 0x31FE, 0x30F8, 0x2BF3, 0x25D7, 0x1F6C,
    0x192B, 0x12DA, 0x0CEA, 0x06F2, 0xFF60, 0xF869, 0xF451, 0xF519, 0xF9DE, 0xFEC6, 0x026A, 0x04EE, 0x05BB, 0x03CB, 0xFF74, 0xFA47,
    0xF77D, 0xF516, 0xF251, 0xEE9D, 0xEA38, 0xE8EF, 0xEAC0, 0xEEF0, 0xF4F4, 0xFCAB, 0x04A0, 0x0DDF, 0x17FA, 0x20DE, 0x29AA, 0x3175,
    0x3773, 0x3A45, 0x3931, 0x33DD, 0x2BCE, 0x225C, 0x1800, 0x0E53, 0x0574, 0xFC17, 0xF134, 0xE7B4, 0xE17E, 0xDFDD, 0xE20C, 0xE481,
    0xE6AF, 0xE8C9, 0xEAC5, 0xEC15, 0xEAF1, 0xE8E0, 0xE6E1, 0xE4B8, 0xE267, 0xDDE2, 0xD8BE, 0xD508, 0xD358, 0xD391, 0xD5F9, 0xDA4A,
    0xDFF3, 0xE80B, 0xF318, 0xFF02, 0x0B84, 0x1987, 0x2484, 0x2C14, 0x2FA0, 0x2E36, 0x2A57, 0x2454, 0x1EE3, 0x194F, 0x13A5, 0x0ECC,
    0x0950, 0x02A7, 0xFD8D, 0xFCEE, 0x014A, 0x08F7, 0x0FB7, 0x1624, 0x1A75, 0x1BDD, 0x1AD1, 0x16BA, 0x121E, 0x0E3A, 0x0B27, 0x08C9,
    0x04D0, 0x020A, 0x028D, 0x06B1, 0x0D48, 0x13D9, 0x1B63, 0x2111, 0x2855, 0x303C, 0x366E, 0x4039, 0x495E, 0x4F03, 0x51F5, 0x4FD2,
    0x4AF3, 0x4398, 0x3A25, 0x2EF5, 0x23AF, 0x193F, 0x0CE2, 0xFFB8, 0xF3EB, 0xEB06, 0xE6F2, 0xE64D, 0xE3EC, 0xE104, 0xDE9A, 0xDCC6,
    0xDA69, 0xD74E, 0xD165, 0xCA14, 0xC834, 0xC3DA, 0xBD87, 0xBA59, 0xB8D6, 0xB637, 0xB773, 0xBD7B, 0xBF7B, 0xC672, 0xD31D, 0xDB9B,
    0xE211, 0xEADC, 0xF377, 0xFCC8, 0x03E5, 0x0412, 0x0140, 0xFCB0, 0xF69D, 0xEFC8, 0xEAE7, 0xE7E3, 0xE5FA, 0xE326, 0xDE57, 0xD999,
    0xD949, 0xDF72, 0xE5AE, 0xEACF, 0xF16E, 0xF792, 0xFB6D, 0xFC65, 0xFAA1, 0xF886, 0xF75C, 0xF66C, 0xF3F5, 0xF13B, 0xEFDD, 0xF22B,
    0xF6BE, 0xFD48, 0x041D, 0x09C2, 0x10EE, 0x18CA, 0x2256, 0x2D27, 0x3780, 0x407F, 0x46E1, 0x48FA, 0x4766, 0x42EB, 0x3B22, 0x3105,
    0x276E, 0x1E88, 0x14EE, 0x0B24, 0xFFC4, 0xF590, 0xF100, 0xF05B, 0xF1D1, 0xF385, 0xF3E1, 0xF5C6, 0xF6AA, 0xF513, 0xF162, 0xEBA6,
    0xE683, 0xE1D4, 0xDC4E, 0xD5AC, 0xCF90, 0xCCAA, 0xCC91, 0xCEA3, 0xD338, 0xD7D5, 0xDE67, 0xE752, 0xF178, 0xFC62, 0x081E, 0x1507,
    0x1E82, 0x2494, 0x278D, 0x25C7, 0x211A, 0x1AA8, 0x1443, 0x0F61, 0x0A77, 0x0502, 0xFE2E, 0xF6AE, 0xF241, 0xF27C, 0xF64C, 0xFB08,
    0xFEFD, 0x02E5, 0x059A, 0x0536, 0x01AE, 0xFD1E, 0xF980, 0xF6DD, 0xF35E, 0xEFEE, 0xECDC, 0xEAE9, 0xEBDA, 0xF12C, 0xFB58, 0x037F,
    0x0C30, 0x191D, 0x2426, 0x2D8B, 0x389C, 0x417D, 0x4773, 0x4DF4, 0x50BD, 0x4C0F, 0x427B, 0x37E4, 0x2D9B, 0x24AC, 0x1C9F, 0x13D2,
    0x09EB, 0xFFF2, 0xF77C, 0xF258, 0xF144, 0xF269, 0xF4E5, 0xF875, 0xFB2A, 0xFCB5, 0xFD9E, 0xF97B, 0xF393, 0xEF42, 0xE6AF, 0xDE80,
    0xD96B, 0xD41B, 0xD105, 0xD3EE, 0xD6CA, 0xD7D9, 0xDD91, 0xE7C8, 0xF42E, 0x003E, 0x0AB4, 0x1442, 0x1FD6, 0x29C7, 0x2F2E, 0x301E,
    0x2CFD, 0x2647, 0x1E67, 0x16F4, 0x0F27, 0x0936, 0x046E, 0xFE42, 0xF706, 0xF3F7, 0xF568, 0xF88F, 0xFC55, 0x0018, 0x0612, 0x09A4,
    0x082E, 0x0416, 0xFF42, 0xFA0A, 0xF55C, 0xF0EC, 0xEBD5, 0xE8A6, 0xE6FE, 0xE82D, 0xEB9C, 0xEF97, 0xF428, 0xF8A0, 0xFEF0, 0x0665,
    0x0F86, 0x1A51, 0x2655, 0x30EA, 0x37BB, 0x3AC1, 0x3954, 0x3439, 0x2D04, 0x254D, 0x1DEC, 0x17C1, 0x0FE2, 0x055B, 0xF9D9, 0xEFA2,
    0xE9C8, 0xE6B8, 0xE4F6, 0xE4D9, 0xE69A, 0xE8B0, 0xEA11, 0xEA07, 0xE86E, 0xE568, 0xE1DE, 0xDD6F, 0xD768, 0xD1CF, 0xCE07, 0xCBDE,
    0xCC04, 0xCEB5, 0xD271, 0xD849, 0xE022, 0xE7D8, 0xF132, 0xFC67, 0x07C2, 0x11B3, 0x183E, 0x1BA4, 0x1BAD, 0x1708, 0x0FAB, 0x0834,
    0x0147, 0xFC32, 0xF77D, 0xF126, 0xE9CB, 0xE32A, 0xE083, 0xE234, 0xE64B, 0xEB50, 0xF0EE, 0xF69A, 0xF9F1, 0xF94E, 0xF695, 0xF50B,
    0xF4A2, 0xF317, 0xF208, 0xF2D0, 0xF1EB, 0xF0CA, 0xF3CB, 0xF878, 0xFE65, 0x06A3, 0x1088, 0x1AD5, 0x2782, 0x357B, 0x4011, 0x4863,
    0x4FFC, 0x557B, 0x5700, 0x5345, 0x4B96, 0x420A, 0x38AC, 0x312F, 0x29C1, 0x2033, 0x148C, 0x0936, 0x011D, 0xFBDA, 0xF8FA, 0xF953,
    0xFA23, 0xFB60, 0xFCCD, 0xFA4D, 0xF565, 0xF08B, 0xE9AF, 0xE071, 0xD806, 0xD045, 0xC852, 0xC3FD, 0xC481, 0xC6D7, 0xC967, 0xCC2C,
    0xD177, 0xDA1A, 0xE552, 0xF08C, 0xFB05, 0x05F2, 0x10DF, 0x1A08, 0x20C5, 0x2320, 0x2117, 0x1E02, 0x1956, 0x147E, 0x1175, 0x0E4C,
    0x09D2, 0x041F, 0x0010, 0xFF92, 0x013D, 0x042A, 0x0783, 0x0B31, 0x0DFA, 0x0F0C, 0x0DF8, 0x0B19, 0x081B, 0x0564, 0x0219, 0xFEB1,
    0xFB3C, 0xF7CE, 0xF616, 0xF6BB, 0xF8A6, 0xFBB2, 0x0035, 0x0658, 0x0E36, 0x171B, 0x2198, 0x2D90, 0x3850, 0x3F86, 0x4304, 0x41D1,
    0x3CF6, 0x35A3, 0x2C3F, 0x2382, 0x1C1B, 0x133E, 0x0734, 0xF842, 0xE998, 0xDF10, 0xD7D1, 0xD3AF, 0xD2D4, 0xD4F9, 0xD82E, 0xDA1A,
    0xDA40, 0xD736, 0xD3B4, 0xD06D, 0xCC4C, 0xC833, 0xC42C, 0xC0E5, 0xBEC4, 0xBF5D, 0xC16F, 0xC4D1, 0xC988, 0xD01B, 0xD869, 0xE1DC,
    0xED96, 0xFA95, 0x0837, 0x1436, 0x1DF3, 0x2439, 0x2652, 0x2425, 0x1EE8, 0x18A3, 0x128F, 0x0CEE, 0x0679, 0xFED9, 0xF77D, 0xF352,
    0xF21D, 0xF46F, 0xF811, 0xFC7D, 0x018D, 0x0640, 0x0651, 0x01EF, 0xFF0E, 0xFE63, 0xFE3A, 0xFDD4, 0xFD57, 0xFB5B, 0xF991, 0xF82C,
    0xF7D8, 0xF8FB, 0xFD0F, 0x01EF, 0x08E8, 0x13B8, 0x1FB0, 0x2A8C, 0x3211, 0x3803, 0x3CF2, 0x4063, 0x40A3, 0x3C3C, 0x34E1, 0x2B9E,
    0x2345, 0x1C22, 0x1289, 0x0693, 0xFA2E, 0xEE7C, 0xE53E, 0xE003, 0xDCCA, 0xDCE0, 0xE025, 0xE308, 0xE3DD, 0xE32F, 0xE20B, 0xDF11,
    0xDA49, 0xD4AF, 0xCEA7, 0xC71B, 0xC05E, 0xBD66, 0xBD88, 0xC044, 0xC358, 0xC71F, 0xCD6C, 0xD65B, 0xE1A9, 0xEDB5, 0xF967, 0x0354,
    0x0C39, 0x1247, 0x13DA, 0x1192, 0x0C45, 0x057D, 0xFE09, 0xF7D5, 0xF204, 0xEBBD, 0xE427, 0xDD35, 0xD971, 0xD967, 0xDBCE, 0xDFE7,
    0xE531, 0xE998, 0xEC3E, 0xEC9F, 0xEBAD, 0xEB59, 0xEB79, 0xEC08, 0xECA8, 0xEC65, 0xEB78, 0xE9C0, 0xE91A, 0xEA6B, 0xEE65, 0xF462,
    0xFCA0, 0x06ED, 0x12F5, 0x2061, 0x2EB1, 0x3C51, 0x47A1, 0x50D9, 0x564F, 0x5820, 0x56D2, 0x523A, 0x4BEA, 0x463C, 0x4094, 0x3852,
    0x2C69, 0x1F64, 0x1496, 0x0CAE, 0x079B, 0x054C, 0x0547, 0x0732, 0x095A, 0x08AA, 0x05DD, 0x01A0, 0xFB6F, 0xF4F8, 0xEE58, 0xE795,
    0xE094, 0xDB23, 0xD807, 0xD6DB, 0xD7B7, 0xD9B7, 0xDD71, 0xE1F3, 0xE7DA, 0xEF65, 0xF8FF, 0x02FE, 0x0C45, 0x14CF, 0x1AD5, 0x1DDC,
    0x1C01, 0x16E0, 0x1011, 0x0A0F, 0x053D, 0xFF80, 0xF815, 0xEEFD, 0xE6E4, 0xE1D1, 0xDFA0, 0xDE76, 0xDE05, 0xE0C3, 0xE511, 0xE729,
    0xE6DC, 0xE4EA, 0xE569, 0xE9AF, 0xEDE7, 0xEFE6, 0xF02D, 0xEFB0, 0xEE39, 0xECAA, 0xED7B, 0xF0B0, 0xF4ED, 0xFAE2, 0x03EC, 0x11A5,
    0x204E, 0x2ACE, 0x318D, 0x370C, 0x3BB9, 0x3E3A, 0x3E90, 0x3A22, 0x32A6, 0x2B4B, 0x237C, 0x1A1D, 0x0DDD, 0xFF8F, 0xF1E6, 0xE852,
    0xE239, 0xDE36, 0xDD34, 0xDFC1, 0xE369, 0xE4C4, 0xE441, 0xE259, 0xDFA2, 0xDC55, 0xD87C, 0xD4B7, 0xCF66, 0xC81E, 0xC0D5, 0xBC91,
    0xBBBA, 0xBCE7, 0xBF94, 0xC317, 0xC827, 0xCF9D, 0xDA6C, 0xE70F, 0xF42B, 0x015C, 0x0D02, 0x16B7, 0x1B57, 0x1B4C, 0x1843, 0x12C1,
    0x0E28, 0x0A02, 0x04BF, 0xFDF2, 0xF7CD, 0xF466, 0xF36F, 0xF3D0, 0xF6FE, 0xFB5E, 0xFFBC, 0x03BF, 0x0453, 0x03D0, 0x0274, 0x017B,
    0x009C, 0x0025, 0xFEF0, 0xFC82, 0xF9AC, 0xF6D6, 0xF665, 0xF6DA, 0xF94C, 0xFC84, 0x0120, 0x06D6, 0x0D59, 0x153A, 0x1D91, 0x260A,
    0x2D68, 0x3469, 0x3835, 0x3959, 0x36B8, 0x3122, 0x2BCC, 0x2630, 0x1F82, 0x1471, 0x077D, 0xFAA8, 0xF061, 0xE930, 0xE470, 0xE279,
    0xE30F, 0xE4BD, 0xE5C6, 0xE5EA, 0xE4E4, 0xE39F, 0xE21D, 0xDFE4, 0xDCFE, 0xD9F2, 0xD6DF, 0xD506, 0xD43D, 0xD54A, 0xD850, 0xDCB9,
    0xE30C, 0xE9E6, 0xF211, 0xFC3A, 0x0704, 0x11F4, 0x1C5E, 0x248E, 0x2A6F, 0x2BB4, 0x28F4, 0x240B, 0x1E50, 0x195F, 0x142C, 0x0D74,
    0x051B, 0xFC39, 0xF567, 0xF1B8, 0xEF16, 0xEDDF, 0xEE2E, 0xF09E, 0xF397, 0xF572, 0xF4DA, 0xF354, 0xF6D3, 0xFD4E, 0x01D4, 0x0325,
    0x02C7, 0x008E, 0xFD99, 0xFBDC, 0xFCF5, 0xFF3D, 0x0158, 0x0406, 0x09A5, 0x13A2, 0x1E37, 0x2733, 0x2D30, 0x32CD, 0x3848, 0x3BE3,
    0x3B5C, 0x35CF, 0x2EA6, 0x26B4, 0x1DFF, 0x1328, 0x0604, 0xF943, 0xEF8D, 0xE90D, 0xE476, 0xE34F, 0xE547, 0xE936, 0xEC6D, 0xEE4D,
    0xEEC5, 0xED5A, 0xEAD1, 0xE78A, 0xE4BD, 0xE1F8, 0xDDE2, 0xD813, 0xD1B8, 0xCDBD, 0xCD4A, 0xCE92, 0xD077, 0xD230, 0xD51F, 0xDBC7,
    0xE457, 0xEE81, 0xFA91, 0x0659, 0x11BD, 0x18F2, 0x18FD, 0x15ED, 0x1221, 0x0ECA, 0x0C85, 0x09C4, 0x048E, 0xFCDB, 0xF586, 0xF023,
    0xECC2, 0xEA1B, 0xE91C, 0xEA73, 0xECBF, 0xEEE1, 0xF004, 0xF0D8, 0xF169, 0xF210, 0xF263, 0xF1BC, 0xF01A, 0xED28, 0xE9AF, 0xE757,
    0xE7C6, 0xEA93, 0xEE46, 0xF29E, 0xF7F1, 0xFEB8, 0x06E4, 0x109D, 0x1A82, 0x2403, 0x2D07, 0x3414, 0x384F, 0x3835, 0x3460, 0x2EED,
    0x297D, 0x22A0, 0x1910, 0x0CE8, 0x002C, 0xF5CA, 0xED9B, 0xE841, 0xE502, 0xE4C5, 0xE60C, 0xE73B, 0xE7E6, 0xE792, 0xE6D8, 0xE4F2,
    0xE283, 0xDEDF, 0xDAE7, 0xD5F6, 0xD0D2, 0xCDC8, 0xCC4B, 0xCD1A, 0xCEEE, 0xD1D9, 0xD597, 0xDA97, 0xE158, 0xEA43, 0xF561, 0x017A,
    0x0D77, 0x17B6, 0x1EC4, 0x20E8, 0x1F14, 0x1BE6, 0x199E, 0x17E9, 0x14F8, 0x1070, 0x0A52, 0x053C, 0x0202, 0xFFC1, 0xFF7F, 0x00D4,
    0x0358, 0x086E, 0x0E50, 0x1116, 0x101D, 0x0FCC, 0x1359, 0x184B, 0x1B93, 0x1D10, 0x1C4F, 0x1AD5, 0x19AA, 0x1AEE, 0x1E44, 0x20C3,
    0x2151, 0x21C8, 0x26D4, 0x2F22, 0x36E2, 0x3C67, 0x4125, 0x45AF, 0x4933, 0x4A55, 0x47D4, 0x42A4, 0x3C76, 0x35F4, 0x2D42, 0x2161,
    0x13C7, 0x06EB, 0xFC05, 0xF24D, 0xEA11, 0xE5EA, 0xE595, 0xE729, 0xE863, 0xE85C, 0xE775, 0xE502, 0xE160, 0xDD24, 0xD91B, 0xD512,
    0xCFCE, 0xC93E, 0xC36D, 0xBFA9, 0xBE54, 0xBE3F, 0xBF04, 0xC0C6, 0xC471, 0xCACD, 0xD357, 0xDC61, 0xE5C6, 0xEFB9, 0xF88D, 0xFE8F,
    0xFF82, 0xFD63, 0xFB17, 0xF975, 0xF7EE, 0xF4D3, 0xEF82, 0xE998, 0xE4CE, 0xE0A8, 0xDD63, 0xDCC8, 0xDEF3, 0xE26C, 0xE6E5, 0xEACA,
    0xEE01, 0xF0DC, 0xF23C, 0xF27E, 0xF1EB, 0xF0B1, 0xEEA0, 0xEBF2, 0xE9F6, 0xEA4E, 0xECAE, 0xEFBB, 0xF362, 0xF726, 0xFBB9, 0x0243,
    0x0BC6, 0x17DF, 0x243C, 0x30BB, 0x3BBD, 0x4392, 0x46DB, 0x45B1, 0x4148, 0x3B86, 0x3597, 0x2E87, 0x2524, 0x1963, 0x0F27, 0x0616,
    0xFE9F, 0xFA65, 0xF967, 0xFA9C, 0xFB7A, 0xFBA4, 0xFAD2, 0xF97C, 0xF70E, 0xF3BA, 0xEF5D, 0xEA93, 0xE57D, 0xE06D, 0xDC28, 0xD96E,
    0xD923, 0xD9B1, 0xDB59, 0xDDBD, 0xE121, 0xE66E, 0xEE16, 0xF6DB, 0xFFD2, 0x0976, 0x12EC, 0x1B31, 0x1F5B, 0x1F96, 0x1DA2, 0x1BDA,
    0x1AD8, 0x1A19, 0x17DB, 0x134C, 0x0CC3, 0x049C, 0xFCF8, 0xF7A0, 0xF41C, 0xF0DD, 0xF06C, 0xF2FD, 0xF625, 0xF5CE, 0xF22C, 0xF0D2,
    0xF254, 0xF4D0, 0xF659, 0xF6E8, 0xF653, 0xF4BF, 0xF458, 0xF74F, 0xFBB1, 0xFF1D, 0x0112, 0x04D1, 0x0DD8, 0x18A5, 0x21F7, 0x2A00,
    0x3175, 0x3873, 0x3D9D, 0x3E56, 0x3B55, 0x3704, 0x32BA, 0x2DB9, 0x25DB, 0x1B53, 0x1094, 0x07CA, 0xFFC5, 0xF7A0, 0xF26B, 0xF1F6,
    0xF460, 0xF7D1, 0xFAE5, 0xFD9A, 0xFF00, 0xFE11, 0xFB2E, 0xF72B, 0xF362, 0xF03C, 0xEC66, 0xE75A, 0xE2F0, 0xE010, 0xDE52, 0xDCFC,
    0xDC11, 0xDD73, 0xE1C8, 0xE904, 0xF26A, 0xFD25, 0x0950, 0x14DB, 0x1E1E, 0x2280, 0x218D, 0x1E8B, 0x1BEA, 0x1A7C, 0x1811, 0x12B4,
    0x0AD2, 0x01BD, 0xF9AA, 0xF2F4, 0xEE6D, 0xED66, 0xEEBB, 0xF170, 0xF3C4, 0xF4FF, 0xF46A, 0xF2F9, 0xF086, 0xECE3, 0xE95E, 0xE5CB,
    0xE284, 0xDEC4, 0xDCAB, 0xDCB8, 0xDE5C, 0xE12F, 0xE43A, 0xE7F3, 0xED2E, 0xF509, 0xFE8C, 0x09B3, 0x156D, 0x216E, 0x2C04, 0x3314,
    0x3550, 0x33B5, 0x3132, 0x2E78, 0x2AD4, 0x24A9, 0x1C34, 0x11DD, 0x0713, 0xFCB7, 0xF411, 0xEEE9, 0xEC22, 0xEBC2, 0xEBFB, 0xEBCC,
    0xEB45, 0xE9EA, 0xE821, 0xE5B1, 0xE324, 0xE01C, 0xDC01, 0xD762, 0xD387, 0xD16D, 0xD16C, 0xD349, 0xD554, 0xD86A, 0xDD45, 0xE3FD,
    0xEB39, 0xF24F, 0xFA5A, 0x02AB, 0x0AB2, 0x1088, 0x12CF, 0x119E, 0x0F54, 0x0DAD, 0x0C37, 0x0978, 0x05DC, 0x0025, 0xF832, 0xF06F,
    0xEB0D, 0xE8AC, 0xE6B0, 0xE55F, 0xE795, 0xEBE6, 0xEF78, 0xEFFD, 0xED5E, 0xED65, 0xEFDA, 0xF3AF, 0xF7B3, 0xFA26, 0xFB63, 0xFAD2,
    0xFB9F, 0xFF2F, 0x02FF, 0x05C4, 0x0856, 0x0DF2, 0x1851, 0x2394, 0x2DE1, 0x3798, 0x40F4, 0x4880, 0x4BDB, 0x4AFF, 0x47AE, 0x4392,
    0x3EF4, 0x385A, 0x2EB5, 0x23BF, 0x18E7, 0x0F28, 0x05BA, 0xFD97, 0xF856, 0xF697, 0xF6AB, 0xF774, 0xF85F, 0xF895, 0xF801, 0xF51F,
    0xF0EA, 0xEC01, 0xE865, 0xE4FF, 0xE116, 0xDE32, 0xDC38, 0xDC33, 0xDCFE, 0xDE27, 0xDF22, 0xE1AA, 0xE677, 0xECE8, 0xF553, 0xFF03,
    0x0A3F, 0x15D0, 0x1ED6, 0x2364, 0x2564, 0x26B8, 0x28CE, 0x2ABE, 0x2A68, 0x26DB, 0x20F9, 0x195C, 0x10AD, 0x09C1, 0x052D, 0x03F6,
    0x051E, 0x06CE, 0x085C, 0x0991, 0x09C9, 0x091E, 0x0729, 0x04DA, 0x02F3, 0xFFA0, 0xFB13, 0xF5AD, 0xF1D5, 0xF0FA, 0xF1D1, 0xF3F9,
    0xF6E2, 0xFB65, 0x01DB, 0x099F, 0x128B, 0x1C9D, 0x27B9, 0x3226, 0x3A38, 0x3D9A, 0x3C44, 0x37EF, 0x3213, 0x2BD0, 0x2449, 0x1A16,
    0x0E30, 0x0191, 0xF4CE, 0xE9A5, 0xE096, 0xDAD7, 0xD7F7, 0xD726, 0xD6C3, 0xD617, 0xD4CB, 0xD2CA, 0xD0E1, 0xCF2B, 0xCE0B, 0xCC16,
    0xC983, 0xC6C2, 0xC466, 0xC440, 0xC5C1, 0xC7CC, 0xCA3C, 0xCE71, 0xD515, 0xDDA1, 0xE74D, 0xF14B, 0xFC8F, 0x08AF, 0x142F, 0x1C65,
    0x2009, 0x21A9, 0x222E, 0x2211, 0x2081, 0x1DD9, 0x1AB2, 0x1488, 0x0C8D, 0x0596, 0x0230, 0x015C, 0x00F4, 0x00CC, 0x02C5, 0x05E4,
    0x0730, 0x0547, 0x00B5, 0xFEC0, 0x002F, 0x0322, 0x05D6, 0x062B, 0x042E, 0x018F, 0x0124, 0x0355, 0x057E, 0x0662, 0x08BB, 0x0DA0,
    0x1620, 0x1FAB, 0x2709, 0x2D91, 0x345C, 0x39B7, 0x3BDC, 0x3AD1, 0x38B0, 0x36B5, 0x33BC, 0x2EE1, 0x269F, 0x1C50, 0x114D, 0x05FF,
    0xFB3A, 0xF1CE, 0xEB4F, 0xE704, 0xE467, 0xE2F5, 0xE258, 0xE303, 0xE3B4, 0xE2F1, 0xE0C6, 0xDDF3, 0xDAA9, 0xD692, 0xD253, 0xCF72,
    0xCF75, 0xD204, 0xD4EB, 0xD758, 0xDA4F, 0xDDAE, 0xE16D, 0xE5FD, 0xEB75, 0xF3B0, 0xFD61, 0x0658, 0x0CA0, 0x0ECC, 0x0ECC, 0x0D44,
    0x0B94, 0x097E, 0x0604, 0x00E1, 0xF9F7, 0xF19C, 0xE9D7, 0xE41C, 0xE1B9, 0xE29A, 0xE523, 0xE885, 0xEB96, 0xEE82, 0xF0E7, 0xF302,
    0xF4C5, 0xF580, 0xF5D1, 0xF4CB, 0xF2D2, 0xF14B, 0xF08D, 0xF1AF, 0xF431, 0xF819, 0xFDF2, 0x05C4, 0x0FF3, 0x1B45, 0x2832, 0x3696,
    0x44E3, 0x511C, 0x591F, 0x5C06, 0x5B48, 0x58AA, 0x54C0, 0x4F93, 0x487C, 0x3FD1, 0x35F9, 0x2B6B, 0x208B, 0x1780, 0x119D, 0x0E4E,
    0x0CCF, 0x0BF4, 0x0B31, 0x090C, 0x05E4, 0x01DC, 0xFDAC, 0xF961, 0xF4AE, 0xEF3B, 0xE8FE, 0xE303, 0xDED1, 0xDD29, 0xDD10, 0xDD92,
    0xDF1E, 0xE271, 0xE6E4, 0xEBD3, 0xF0E0, 0xF700, 0xFEBA, 0x06D8, 0x0D78, 0x10D9, 0x1217, 0x12DA, 0x124D, 0x1009, 0x0CF7, 0x0900,
    0x0398, 0xFAFE, 0xF0D9, 0xEA21, 0xE6F9, 0xE4E6, 0xE326, 0xE25D, 0xE3E7, 0xE7CB, 0xEA3C, 0xEA94, 0xE9C6, 0xE8A1, 0xEA05, 0xEE02,
    0xF232, 0xF3BA, 0xF35F, 0xF3C8, 0xF66D, 0xFA90, 0xFEC1, 0x0251, 0x06BB, 0x0E64, 0x180E, 0x2318, 0x2E2F, 0x3698, 0x3CAE, 0x3FA9,
    0x3F15, 0x3BD1, 0x37F0, 0x3473, 0x2FC9, 0x2927, 0x2000, 0x14C2, 0x091B, 0xFE5D, 0xF667, 0xF0A7, 0xEBD8, 0xE844, 0xE4E9, 0xE304,
    0xE1D5, 0xE10C, 0xE070, 0xDEDC, 0xDCFB, 0xDA5E, 0xD700, 0xD314, 0xCFC4, 0xCD76, 0xCDB3, 0xCFBD, 0xD21A, 0xD546, 0xD8C5, 0xDCAE,
    0xE144, 0xE753, 0xEF8C, 0xFA9D, 0x068A, 0x1110, 0x189F, 0x1CF3, 0x1E58, 0x1E57, 0x1D0C, 0x1A85, 0x1741, 0x11BD, 0x0B18, 0x03E2,
    0xFE37, 0xFB5F, 0xFAE2, 0xFC16, 0xFE3E, 0x013B, 0x03CE, 0x05F6, 0x07A5, 0x08DA, 0x0940, 0x0880, 0x05E6, 0x01C4, 0xFCB1, 0xF862,
    0xF612, 0xF536, 0xF51E, 0xF64C, 0xF9EB, 0xFEEF, 0x0515, 0x0C9B, 0x15D2, 0x2186, 0x2DDF, 0x3769, 0x3D1E, 0x3FCB, 0x3FAB, 0x3DE4,
    0x3A9D, 0x35DE, 0x2FDD, 0x283D, 0x1ED2, 0x1487, 0x0ADC, 0x030F, 0xFD22, 0xF969, 0xF7E6, 0xF81A, 0xF96F, 0xFA8E, 0xFB05, 0xFA9F,
    0xF930, 0xF68E, 0xF2BC, 0xEE6D, 0xEA5C, 0xE787, 0xE703, 0xE89A, 0xEB4C, 0xEE47, 0xF1AF, 0xF669, 0xFBB6, 0x01CF, 0x0916, 0x12B1,
    0x1E19, 0x278B, 0x2CC5, 0x2E51, 0x2E66, 0x2DDD, 0x2B1A, 0x26F1, 0x2278, 0x1DBB, 0x1624, 0x0B3E, 0x0092, 0xF96D, 0xF666, 0xF472,
    0xF2AF, 0xF21B, 0xF35F, 0xF5F6, 0xF7EC, 0xF7FB, 0xF5E4, 0xF380, 0xF200, 0xF1E3, 0xF387, 0xF4B5, 0xF3F0, 0xF2B0, 0xF22E, 0xF24C,
    0xF395, 0xF611, 0xF994, 0xFFC0, 0x0A69, 0x17D2, 0x252D, 0x30C1, 0x3753, 0x3873, 0x363C, 0x32EC, 0x2F89, 0x2C72, 0x2948, 0x23F1,
    0x1C2A, 0x1294, 0x09B6, 0x02D8, 0xFE8A, 0xFCB7, 0xFB9C, 0xFB85, 0xFAF1, 0xFA33, 0xF971, 0xF8B8, 0xF851, 0xF659, 0xF296, 0xEDC7,
    0xE874, 0xE348, 0xDF83, 0xDDBA, 0xDD64, 0xDE0F, 0xDFEC, 0xE27E, 0xE515, 0xE74C, 0xEA18, 0xEE90, 0xF58F, 0xFDD1, 0x062E, 0x0DC8,
    0x1342, 0x178D, 0x19B0, 0x19EE, 0x1918, 0x171A, 0x1386, 0x0D1E, 0x04CD, 0xFC61, 0xF52A, 0xEFD5, 0xEC89, 0xEB16, 0xEBDC, 0xED98,
    0xEFC2, 0xF1A1, 0xF314, 0xF40C, 0xF3C5, 0xF1F5, 0xEE1E, 0xE955, 0xE526, 0xE253, 0xE08B, 0xDF8C, 0xE041, 0xE2E3, 0xE796, 0xEE44,
    0xF731, 0x029B, 0x0FF7, 0x1E84, 0x2AC0, 0x3392, 0x38CD, 0x3B04, 0x3B31, 0x394F, 0x363B, 0x3245, 0x2C88, 0x23F3, 0x195A, 0x0E5F,
    0x05BA, 0xFFA4, 0xFBC2, 0xF958, 0xF824, 0xF78A, 0xF653, 0xF4C0, 0xF314, 0xEFA6, 0xEB23, 0xE638, 0xDFFD, 0xD9FD, 0xD4FC, 0xD1BC,
    0xD05D, 0xD02A, 0xD030, 0xD1B1, 0xD441, 0xD82E, 0xDD93, 0xE503, 0xEF4A, 0xFCC0, 0x0B81, 0x16B3, 0x1E28, 0x231B, 0x2617, 0x2524,
    0x23B2, 0x2213, 0x227B, 0x219F, 0x1F40, 0x16FB, 0x0BFE, 0x0A41, 0x0A29, 0x0C18, 0x0D85, 0x0FE7, 0x1323, 0x16EA, 0x1A68, 0x1BCE,
    0x1B27, 0x1676, 0x1248, 0x0FE5, 0x0F52, 0x101F, 0x10D3, 0x112F, 0x12A1, 0x15E7, 0x19E2, 0x1D1D, 0x2109, 0x276E, 0x303B, 0x3BBD,
    0x470D, 0x4E33, 0x51DD, 0x4E90, 0x49B8, 0x44E8, 0x3FEF, 0x3E3B, 0x3C2E, 0x3759, 0x31AE, 0x2A1F, 0x1DA5, 0x129E, 0x098C, 0x02A2,
    0xFBD7, 0xF7E3, 0xF592, 0xF16A, 0xED8C, 0xE94D, 0xE5E5, 0xE175, 0xDBC2, 0xD502, 0xCF07, 0xCB08, 0xC93A, 0xC85C, 0xC729, 0xC734,
    0xC96F, 0xCC6E, 0xD02F, 0xD4AE, 0xDA54, 0xE1E8, 0xEA73, 0xF369, 0xF761, 0xF7FE, 0xFA74, 0xFC0B, 0xFE96, 0x0086, 0x0288, 0x0440,
    0x038F, 0x029F, 0xFE36, 0xF81A, 0xF0EE, 0xEC47, 0xE6C4, 0xE380, 0xE3FE, 0xE533, 0xE77D, 0xE9F8, 0xED8E, 0xF0C3, 0xF388, 0xF4BE,
    0xF47A, 0xF0BE, 0xEED3, 0xE6EF, 0xE147, 0xE228, 0xE31F, 0xE819, 0xEE58, 0xF735, 0x01B2, 0x0E9B, 0x1DF5, 0x2987, 0x2F4A, 0x33E8,
    0x3689, 0x3719, 0x36B6, 0x35FD, 0x34B7, 0x33AE, 0x30C9, 0x2DDA, 0x29FB, 0x24F5, 0x1E86, 0x1843, 0x1282, 0x0BE6, 0x0759, 0x0396,
    0x0132, 0xFEAF, 0xFC3C, 0xF931, 0xF601, 0xF157, 0xED90, 0xE971, 0xE6FF, 0xE40D, 0xDDD8, 0xDBCE, 0xDA6D, 0xDB24, 0xDBBC, 0xDB56,
    0xE11F, 0xE7AE, 0xEE5C, 0xF72B, 0xFE4B, 0x029A, 0x061E, 0x09E8, 0x0D6D, 0x10FA, 0x12F4, 0x168A, 0x1A7E, 0x1C8D, 0x1CB7, 0x19A9,
    0x1422, 0x0EE7, 0x0AD8, 0x056F, 0xFF7B, 0xFA5E, 0xF749, 0xF714, 0xF8C8, 0xF977, 0xF738, 0xF26C, 0xEF4C, 0xEE07, 0xEFBD, 0xF35D,
    0xF3A4, 0xF378, 0xF548, 0xF91F, 0xFE72, 0x0117, 0x0473, 0x0BFA, 0x1483, 0x1ED1, 0x2824, 0x2EB8, 0x3289, 0x33AB, 0x3233, 0x2FBF,
    0x2E0D, 0x2D88, 0x2E93, 0x2E6E, 0x2D95, 0x2CA5, 0x2AA9, 0x27E0, 0x246C, 0x207D, 0x1B9C, 0x154B, 0x0D3B, 0x04C8, 0xFDC0, 0xF84E,
    0xF4B6, 0xF169, 0xEEB2, 0xECA5, 0xEA6D, 0xE964, 0xE73F, 0xE353, 0xDF69, 0xDC78, 0xDC0A, 0xDC6C, 0xDCDC, 0xDF4A, 0xE2B5, 0xE6E0,
    0xEBE1, 0xF09F, 0xF454, 0xF822, 0xFB5B, 0xFE8D, 0x023F, 0x0566, 0x08C9, 0x0B40, 0x0C37, 0x0CCC, 0x0D7A, 0x0CF8, 0x0B23, 0x07DD,
    0x0376, 0xFEB9, 0xFA32, 0xF69A, 0xF3AD, 0xF208, 0xF139, 0xF0FF, 0xF04B, 0xEFB6, 0xEE58, 0xED19, 0xECDB, 0xEB90, 0xEA3A, 0xE89F,
    0xE86F, 0xEA3F, 0xEC1F, 0xEE70, 0xF1FD, 0xF713, 0xFD27, 0x03DE, 0x0A26, 0x0FE0, 0x148B, 0x17BF, 0x1AD1, 0x1D9B, 0x1F93, 0x20A9,
    0x1FEF, 0x1E5B, 0x1CD7, 0x1B35, 0x190C, 0x154E, 0x10E1, 0x0B6A, 0x0513, 0xFDE4, 0xF626, 0xEF48, 0xE967, 0xE509, 0xE153, 0xDF83,
    0xDE3F, 0xDD48, 0xDCFE, 0xDCA4, 0xDCC2, 0xDBFE, 0xDA7B, 0xD986, 0xDA40, 0xDA7F, 0xDAAB, 0xDB2C, 0xDCD0, 0xE034, 0xE373, 0xE6A6,
    0xE980, 0xED1E, 0xF01C, 0xF215, 0xF3FF, 0xF6A5, 0xFA00, 0xFC27, 0xFCD9, 0xFC7E, 0xFCA7, 0xFC7F, 0xFC93, 0xFBE6, 0xF9B7, 0xF626,
    0xF2CE, 0xF279, 0xF3EE, 0xF611, 0xF5C0, 0xF2CC, 0xF030, 0xEFA0, 0xF207, 0xF5BE, 0xF9D8, 0xFED2, 0x0449, 0x099A, 0x0EA7, 0x12E5,
    0x1588, 0x17E9, 0x1B25, 0x1F84, 0x245E, 0x2836, 0x2A7E, 0x29B9, 0x25BD, 0x1FDE, 0x19FF, 0x1548, 0x121C, 0x101B, 0x0E8D, 0x0E69,
    0x0ED1, 0x0FBB, 0x104E, 0x1012, 0x0EC7, 0x0B78, 0x05D9, 0xFEF2, 0xF883, 0xF323, 0xEF42, 0xEBDE, 0xE990, 0xE837, 0xE799, 0xE857,
    0xE965, 0xEAE9, 0xEC4E, 0xED53, 0xEE60, 0xEFC1, 0xF0E5, 0xF1A7, 0xF20C, 0xF15E, 0xF036, 0xEF67, 0xF01A, 0xF1E4, 0xF48C, 0xF82C,
    0xFC85, 0x01B7, 0x0637, 0x09C4, 0x0BE3, 0x0D10, 0x0E19, 0x0EF5, 0x0F7D, 0x0F9E, 0x0F2B, 0x0DCD, 0x0B69, 0x086A, 0x060D, 0x042E,
    0x02E5, 0x0196, 0x0071, 0xFF5B, 0xFE8B, 0xFDF7, 0xFD56, 0xFCD1, 0xFCA2, 0xFD76, 0xFE09, 0xFE82, 0xFF16, 0xFF62, 0xFF5E, 0xFFCD,
    0x0028, 0x00B8, 0x010C, 0x00D7, 0x0046, 0xFEA8, 0xFCE9, 0xFB1A, 0xF995, 0xF820, 0xF668, 0xF542, 0xF4AC, 0xF470, 0xF48F, 0xF3DA,
    0xF1FD, 0xEF7B, 0xEB8F, 0xE745, 0xE32B, 0xE025, 0xDDC5, 0xDC45, 0xDB04, 0xD9EE, 0xD9BD, 0xD963, 0xD959, 0xD9E3, 0xDB5F, 0xDCFD,
    0xDE0D, 0xDEFE, 0xDFDE, 0xE09B, 0xE0F7, 0xE1EE, 0xE3E2, 0xE624, 0xE881, 0xEAB4, 0xED37, 0xF049, 0xF322, 0xF575, 0xF712, 0xF8E2,
    0xFBE4, 0xFE8A, 0x00E6, 0x02A5, 0x03E4, 0x0638, 0x097F, 0x0CC2, 0x0E31, 0x0D9B, 0x0C75, 0x0C9B, 0x0E4A, 0x0F15, 0x0CC0, 0x06ED,
    0x00CA, 0xFCC2, 0xFBB8, 0xFD42, 0x0052, 0x04CF, 0x0A28, 0x0FF0, 0x14F0, 0x17DE, 0x193C, 0x1993, 0x1991, 0x19F3, 0x1B32, 0x1C88,
    0x1D15, 0x1BC8, 0x189F, 0x1448, 0x1045, 0x0D30, 0x0ACB, 0x090C, 0x0817, 0x083B, 0x081B, 0x07E5, 0x076E, 0x0705, 0x0667, 0x0420,
    0xFFB0, 0xF97A, 0xF3BD, 0xEF1E, 0xEB57, 0xE893, 0xE663, 0xE542, 0xE56A, 0xE60D, 0xE789, 0xE9BD, 0xEBC3, 0xED5F, 0xEE95, 0xEF3C,
    0xEFF9, 0xF093, 0xF03C, 0xEE55, 0xEB6B, 0xE833, 0xE518, 0xE262, 0xE046, 0xDF57, 0xDF77, 0xE07B, 0xE13E, 0xE1CC, 0xE2B1, 0xE3E3,
    0xE5E0, 0xE7C2, 0xE99C, 0xEB19, 0xEBFB, 0xECAD, 0xED6F, 0xEE69, 0xF01E, 0xF2A4, 0xF58E, 0xF80A, 0xFA4A, 0xFC98, 0xFF22, 0x0294,
    0x0630, 0x09A8, 0x0D32, 0x10A7, 0x1447, 0x17EF, 0x1BC2, 0x1FE2, 0x2465, 0x2887, 0x2C31, 0x2F5B, 0x314B, 0x31A1, 0x2FA4, 0x2C50,
    0x2917, 0x2631, 0x23E9, 0x2213, 0x20EB, 0x2055, 0x205A, 0x206F, 0x2032, 0x1F67, 0x1E09, 0x1C4D, 0x19F3, 0x173E, 0x14BD, 0x1287,
    0x0F90, 0x0B96, 0x078C, 0x041B, 0x0149, 0xFEAE, 0xFCF1, 0xFC43, 0xFC0E, 0xFB29, 0xF9EB, 0xF88E, 0xF68E, 0xF37F, 0xF024, 0xED66,
    0xEB71, 0xE9A2, 0xE7B9, 0xE62D, 0xE597, 0xE652, 0xE6E0, 0xE6CA, 0xE617, 0xE53F, 0xE581, 0xE67B, 0xE759, 0xE757, 0xE74F, 0xE875,
    0xEB88, 0xEF0C, 0xF16E, 0xF1A3, 0xF1C6, 0xF44D, 0xF8CF, 0xFD27, 0xFE41, 0xFC84, 0xF9BF, 0xF7B2, 0xF793, 0xF955, 0xFCF6, 0x019C,
    0x0800, 0x0F96, 0x16CE, 0x1D2E, 0x2242, 0x2584, 0x27F0, 0x2A02, 0x2B76, 0x2CC8, 0x2C5D, 0x29C3, 0x2554, 0x1FC8, 0x19D6, 0x1429,
    0x0FDC, 0x0D36, 0x0C42, 0x0B55, 0x09C8, 0x076A, 0x04A7, 0x0263, 0x0076, 0xFE6E, 0xFBCE, 0xF8E6, 0xF5F1, 0xF2F6, 0xF017, 0xED19,
    0xEB0F, 0xEA24, 0xEA31, 0xEAF7, 0xEC02, 0xEC92, 0xECD5, 0xECDD, 0xEC77, 0xEC6C, 0xED38, 0xEF13, 0xF1B0, 0xF3D2, 0xF556, 0xF5FA,
    0xF51E, 0xF346, 0xF117, 0xEFC1, 0xEF70, 0xEFCD, 0xF071, 0xF14F, 0xF2E8, 0xF553, 0xF7F0, 0xFAA0, 0xFD98, 0x00AC, 0x03DB, 0x0692,
    0x0874, 0x09C3, 0x0A5C, 0x0A28, 0x09A0, 0x0934, 0x087E, 0x080C, 0x081A, 0x08A7, 0x0987, 0x0A7F, 0x0B30, 0x0B8C, 0x0BE2, 0x0C64,
    0x0DF5, 0x0FCE, 0x116E, 0x129B, 0x135F, 0x14AD, 0x157B, 0x15BC, 0x1545, 0x1449, 0x13CD, 0x13A1, 0x13C4, 0x13F7, 0x1437, 0x1469,
    0x14B8, 0x1508, 0x14D2, 0x1427, 0x12C5, 0x10F8, 0x0EE6, 0x0D56, 0x0C5D, 0x0B4B, 0x09C6, 0x07F1, 0x0669, 0x05B1, 0x055B, 0x055E,
    0x0625, 0x072A, 0x0835, 0x08F2, 0x0959, 0x092A, 0x0884, 0x07EA, 0x06E8, 0x069F, 0x06DF, 0x06F6, 0x06A3, 0x05A9, 0x04FB, 0x0412,
    0x0358, 0x01E5, 0xFF3B, 0xFCD6, 0xFBBE, 0xFB66, 0xFAA9, 0xF8CD, 0xF660, 0xF4F9, 0xF5B8, 0xF78D, 0xF807, 0xF6D2, 0xF58B, 0xF62B