/**
 * Copyright (c) 2020 Raspberry Pi (Trading) Ltd.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>
#include "pico/stdlib.h"
#include "bsp_battery.h"

int main()
{
    stdio_init_all();
    bsp_battery_init();
    float voltage;
    uint16_t adc_raw;
    while (true)
    {
        bsp_battery_read(&voltage, &adc_raw);
        printf("voltage: %.1f V adc_raw: %d\n", voltage, adc_raw);
        sleep_ms(1000);
    }
}
