#ifndef AUDIO_DATA_H
#define AUDIO_DATA_H

#include <stdint.h>

// 采样率: 24000Hz
// 位深度: 16bit
// 音频时长: 77.45秒
const uint32_t AUDIO_SAMPLES = 1858882;
const int16_t audio_data[] __attribute__((aligned(4))) = {
    0xFFA7, 0xFF6F, 0xFF5D, 0xFF3F, 0xFF55, 0xFF5F, 0xFF71, 0xFF5E, 0xFF69, 0xFF58, 0xFF46, 0xFF40, 0xFF76, 0xFF69, 0xFF48, 0xFF48,
    0xFF53, 0xFF53, 0xFF59, 0xFF5A, 0xFF4B, 0xFF49, 0xFF55, 0xFF53, 0xFF43, 0xFF3A, 0xFF2E, 0xFF32, 0xFF43, 0xFF5A, 0xFF3C, 0xFF27,
    0xFF34, 0xFF3D, 0xFF42, 0xFF41, 0xFF30, 0xFF33, 0xFF38, 0xFF29, 0xFF3C, 0xFF4E, 0xFF30, 0xFF3C, 0xFF35, 0xFF21, 0xFF2B, 0xFF2D,
    0xFF2D, 0xFF2F, 0xFF48, 0xFF4D, 0xFF55, 0xFF5C, 0xFF5A, 0xFF45, 0xFF42, 0xFF46, 0xFF48, 0xFF38, 0xFF52, 0xFF34, 0xFF31, 0xFF37,
    0xFF45, 0xFF20, 0xFF33, 0xFF4F, 0xFF3D, 0xFF65, 0xFF68, 0xFF68, 0xFF77, 0xFF71, 0xFF7D, 0xFF71, 0xFF84, 0xFFAB, 0xFF9F, 0xFFA4,
    0xFF98, 0xFF8B, 0xFF99, 0xFF8F, 0xFF80, 0xFF74, 0xFF78, 0xFF81, 0xFF65, 0xFF85, 0xFF7F, 0xFF6E, 0xFF81, 0xFF68, 0xFF74, 0xFF92,
    0xFF95, 0xFF73, 0xFF85, 0xFF5A, 0xFF58, 0xFF64, 0xFF41, 0xFF3D, 0xFF52, 0xFF50, 0xFF51, 0xFF6A, 0xFF69, 0xFF59, 0xFF5A, 0xFF78,
    0xFF60, 0xFF57, 0xFF6D, 0xFF5E, 0xFF63, 0xFF7B, 0xFF72, 0xFF5F, 0xFF63, 0xFF71, 0xFF5A, 0xFF5B, 0xFF56, 0xFF68, 0xFF57, 0xFF51,
    0xFF49, 0xFF33, 0xFF39, 0xFF4C, 0xFF3F, 0xFF3F, 0xFF6B, 0xFF4B, 0xFF59, 0xFFA5, 0x00A9, 0x02A4, 0x04AB, 0x05F7, 0x060E, 0x041D,
    0x0047, 0xFCD2, 0xFBC6, 0xFBD6, 0xFBEE, 0xFC4C, 0xFC9C, 0xFCDE, 0xFD2A, 0xFD70, 0xFD98, 0xFDE7, 0xFE08, 0xFE17, 0xFE3E, 0xFE6C,
    0xFE7B, 0xFEA5, 0xFEC1, 0xFEBE, 0xFECA, 0xFEE0, 0xFEEE, 0xFEE3, 0xFEF8, 0xFF04, 0xFF01, 0xFEF3, 0xFF0C, 0xFF09, 0xFF03, 0xFF16,
    0xFF0A, 0xFF19, 0xFF23, 0xFF12, 0xFF1A, 0xFF1A, 0xFF26, 0xFF24, 0xFF20, 0xFEE9, 0xFE8E, 0xFE96, 0xFF09, 0xFF67, 0xFF81, 0xFF93,
    0xFF8F, 0xFF89, 0xFF7D, 0xFF77, 0xFF78, 0xFF6A, 0xFF67, 0xFF6B, 0xFF5A, 0xFF67, 0xFF62, 0xFF65, 0xFF65, 0xFF4B, 0xFF64, 0xFF6B,
    0xFF72, 0xFF53, 0xFF6C, 0xFF54, 0xFF52, 0xFF62, 0xFF78, 0xFF71, 0xFF98, 0xFF90, 0xFFA0, 0xFFAC, 0xFFAA, 0xFFB1, 0xFFA2, 0xFFBE,
    0xFFAB, 0xFF9A, 0xFFBF, 0xFFD9, 0x0000, 0x0052, 0x00B9, 0x00D9, 0x0036, 0xFF95, 0xFF95, 0xFFAF, 0xFFA8, 0xFFA8, 0xFFB4, 0xFFCF,
    0xFFE5, 0xFFDE, 0x0008, 0xFFFD, 0xFFF8, 0xFFF2, 0x0004, 0x0005, 0x0001, 0x001C, 0x0020, 0x006F, 0x0068, 0x0029, 0x000D, 0x0026,
    0x0029, 0x0021, 0x002C, 0x002D, 0x0019, 0x001D, 0x0004, 0xFFF0, 0x0013, 0x002C, 0x0048, 0x0051, 0x0048, 0x003F, 0x0056, 0x004B,
    0x0034, 0x003A, 0x0050, 0x0055, 0x004A, 0x0061, 0x005B, 0x0083, 0x0090, 0x0076, 0x0076, 0x0077, 0x007F, 0x0088, 0x008D, 0x0094,
    0x0098, 0x0093, 0x0091, 0x009D, 0x00B4, 0x00C4, 0x00C6, 0x00CF, 0x00DE, 0x00E9, 0x00E2, 0x00F9, 0x0105, 0x00FB, 0x00F2, 0x00F3,
    0x00EB, 0x0115, 0x0120, 0x0106, 0x00FB, 0x0108, 0x00F6, 0x00D5, 0x00BE, 0x00F2, 0x011E, 0x0117, 0x0135, 0x016E, 0x01A6, 0x0221,
    0x027D, 0x0236, 0x01B0, 0x00EC, 0x007D, 0x006C, 0x006A, 0x0079, 0x0097, 0x00C6, 0x00AE, 0x00BB, 0x00C3, 0x00D1, 0x00E2, 0x00EC,
    0x00F7, 0x010C, 0x011C, 0x0119, 0x0108, 0x0115, 0x0121, 0x0122, 0x0140, 0x0143, 0x014A, 0x015D, 0x014A, 0x013E, 0x0151, 0x016A,
    0x0172, 0x019B, 0x01A9, 0x0184, 0x018A, 0x01B2, 0x01C9, 0x01CB, 0x01D6, 0x01D4, 0x01DA, 0x01EE, 0x01F6, 0x01DA, 0x01DB, 0x01DB,
    0x01CB, 0x01D8, 0x01E0, 0x01CE, 0x01C2, 0x01D4, 0x01D0, 0x01E4, 0x01DE, 0x01CC, 0x01D1, 0x0200, 0x0212, 0x0215, 0x022C, 0x022D,
    0x021B, 0x023A, 0x023E, 0x024D, 0x024D, 0x025D, 0x0267, 0x024F, 0x0273, 0x025D, 0x026B, 0x0240, 0x021A, 0x020B, 0x0258, 0x0277,
    0x026B, 0x0297, 0x02A0, 0x02C9, 0x02B2, 0x02CE, 0x02C8, 0x02CA, 0x02CD, 0x02D9, 0x02F2, 0x02F5, 0x02F4, 0x02EF, 0x030A, 0x02F2,
    0x02E7, 0x02E0, 0x02E3, 0x02DF, 0x02DC, 0x02F6, 0x02D4, 0x02F3, 0x02E7, 0x02DF, 0x02FB, 0x02D0, 0x02E1, 0x02CD, 0x02CB, 0x02E8,
    0x02C7, 0x02D0, 0x02DC, 0x02D0, 0x02FC, 0x0305, 0x02FD, 0x0305, 0x02FC, 0x02F1, 0x0302, 0x02FD, 0x0301, 0x02F1, 0x02F8, 0x0324,
    0x030E, 0x032B, 0x033E, 0x031E, 0x0356, 0x0352, 0x033A, 0x032A, 0x033C, 0x034D, 0x0379, 0x0372, 0x0350, 0x0356, 0x0344, 0x034A,
    0x0337, 0x0354, 0x0378, 0x0364, 0x038F, 0x0370, 0x036E, 0x0380, 0x036F, 0x0387, 0x038D, 0x0388, 0x0379, 0x0343, 0x0366, 0x0375,
    0x0361, 0x037C, 0x037A, 0x0364, 0x0365, 0x0365, 0x037B, 0x037C, 0x0387, 0x038C, 0x0375, 0x0384, 0x0385, 0x037C, 0x035F, 0x0330,
    0x034D, 0x0363, 0x0366, 0x0368, 0x039A, 0x0364, 0x0380, 0x0395, 0x0384, 0x03A2, 0x038B, 0x03B8, 0x038D, 0x0389, 0x03C0, 0x03A4,
    0x039E, 0x0388, 0x03A0, 0x0387, 0x03B1, 0x03A2, 0x0384, 0x03AE, 0x0387, 0x038B, 0x0377, 0x038E, 0x038E, 0x039F, 0x03A2, 0x03AA,
    0x03BC, 0x03B2, 0x03D7, 0x03EF, 0x03E6, 0x03CA, 0x03D9, 0x03E5, 0x03D7, 0x03E9, 0x03FE, 0x03F8, 0x040B, 0x03FC, 0x03F9, 0x042A,
    0x03FC, 0x03F7, 0x040D, 0x0413, 0x03FB, 0x03FA, 0x03B4, 0x032E, 0x030F, 0x02E8, 0x02E3, 0x0387, 0x0474, 0x04AF, 0x04B6, 0x04E8,
    0x0495, 0x04B3, 0x04C0, 0x0486, 0x0482, 0x0483, 0x047A, 0x0492, 0x047C, 0x045C, 0x046D, 0x0460, 0x047D, 0x0465, 0x045B, 0x0453,
    0x0437, 0x0457, 0x0422, 0x0436, 0x041F, 0x0412, 0x040E, 0x0423, 0x0415, 0x03DE, 0x03E4, 0x03B1, 0x03CA, 0x03EA, 0x0405, 0x03F2,
    0x03C1, 0x03F6, 0x03DF, 0x03D5, 0x03FE, 0x03E8, 0x03E5, 0x0404, 0x040D, 0x03FB, 0x0416, 0x03FF, 0x0419, 0x03E9, 0x03E5, 0x03F6,
    0x03D0, 0x03FB, 0x0403, 0x03D5, 0x03CD, 0x03FE, 0x03DB, 0x03E2, 0x040D, 0x03FC, 0x03E7, 0x0414, 0x041F, 0x0410, 0x0432, 0x0412,
    0x03EE, 0x0423, 0x0416, 0x040F, 0x044D, 0x042A, 0x040E, 0x0426, 0x0413, 0x03EA, 0x03FB, 0x0416, 0x043B, 0x048D, 0x04B4, 0x049C,
    0x043F, 0x041F, 0x0450, 0x0441, 0x0430, 0x0418, 0x0405, 0x0416, 0x03EA, 0x03E6, 0x03FC, 0x03DE, 0x03DB, 0x0408, 0x03E1, 0x040B,
    0x0430, 0x0412, 0x0452, 0x044F, 0x046D, 0x0490, 0x0495, 0x0491, 0x049A, 0x04B1, 0x048B, 0x048F, 0x0489, 0x04BE, 0x04C0, 0x04B2,
    0x04BB, 0x04A8, 0x04B3, 0x0496, 0x0499, 0x0467, 0x0466, 0x0469, 0x0470, 0x0466, 0x046D, 0x0472, 0x045B, 0x0474, 0x0464, 0x046E,
    0x045B, 0x044E, 0x043D, 0x0403, 0x0418, 0x0418, 0x042C, 0x043C, 0x041D, 0x0431, 0x0423, 0x03F5, 0x0402, 0x0410, 0x03E3, 0x03E7,
    0x03E2, 0x03DA, 0x03E5, 0x03DB, 0x03E8, 0x03FE, 0x041B, 0x041D, 0x0425, 0x0448, 0x0479, 0x048B, 0x04CD, 0x04E9, 0x04E5, 0x0529,
    0x0521, 0x0551, 0x0595, 0x0587, 0x05DB, 0x0632, 0x0673, 0x0698, 0x06EA, 0x06F1, 0x0765, 0x07A5, 0x0786, 0x076D, 0x07EA, 0x0820,
    0x0887, 0x0933, 0x0985, 0x0970, 0x09A4, 0x0A35, 0x0B30, 0x0C6E, 0x0C9E, 0x0CD6, 0x0D0B, 0x0D35, 0x0CF5, 0x0DC9, 0x0DC5, 0x0E0E,
    0x0E06, 0x0F0B, 0x0F5C, 0x1061, 0x1125, 0x12AC, 0x142A, 0x1748, 0x1A2E, 0x1CCE, 0x1FA1, 0x2243, 0x2923, 0x2D10, 0x2E59, 0x3160,
    0x383E, 0x3DA1, 0x40B5, 0x3EB7, 0x4121, 0x428D, 0x467E, 0x4126, 0x3E47, 0x37FC, 0x34A6, 0x25E6, 0x205F, 0x157C, 0xF23D, 0x0C52,
    0x145C, 0xEF8A, 0xADF3, 0x982B, 0xA10B, 0xA1D4, 0xADB1, 0xB22B, 0xB60F, 0xB427, 0xBA00, 0xBC0D, 0xC216, 0xC2CD, 0xC63F, 0xC53E,
    0xCBBA, 0xD4DA, 0xD7EE, 0xD841, 0xDDD5, 0xEB08, 0xEA85, 0xDEE6, 0xD1BD, 0xCEB3, 0xCC99, 0xD365, 0xD37D, 0xD658, 0xD6A0, 0xD60E,
    0xD455, 0xD471, 0xE014, 0xD70B, 0xDDED, 0xE574, 0xEB20, 0xE9FE, 0xEFC5, 0x0D52, 0x178D, 0x0EE4, 0x00C6, 0x0BF3, 0x28F7, 0x49F8,
    0x5821, 0x6003, 0x5A3C, 0x57F7, 0x58FA, 0x4B37, 0x5186, 0x4DD7, 0x4A87, 0x4B15, 0x4D85, 0x48C1, 0x4240, 0x4827, 0x4918, 0x32A5,
    0x171F, 0x12B5, 0x1A3B, 0x1F40, 0x104C, 0xF4E9, 0xD3EF, 0xC117, 0xBAB4, 0xB9D8, 0xBAFB, 0xBD82, 0xBEF5, 0xBDAF, 0xBFA2, 0xBFF3,
    0xC01F, 0xBB99, 0xBED8, 0xBEBE, 0xBFA8, 0xBED8, 0xC3C8, 0xCAC8, 0xCB22, 0xCD0A, 0xC675, 0xCD45, 0xD4DD, 0xD89B, 0xDA99, 0xE03F,
    0xE4C5, 0xE210, 0xE40E, 0xEAD1, 0xEBAF, 0xE2FE, 0xE5EA, 0xEA91, 0xEDC1, 0xE3AC, 0xDFC0, 0xEE1D, 0xFDB6, 0x0C38, 0x07DA, 0xF94A,
    0xF5DA, 0x03A5, 0x15F9, 0x2BAF, 0x3F4B, 0x493B, 0x491D, 0x4A4C, 0x4AFF, 0x4435, 0x4090, 0x44C9, 0x4944, 0x408B, 0x3A06, 0x3DBB,
    0x47DE, 0x4970, 0x3C71, 0x27E1, 0x1C21, 0x1E3B, 0x2326, 0x2278, 0x153B, 0x02E7, 0xE802, 0xD3C8, 0xC8F7, 0xC4A5, 0xC0E6, 0xBE21,
    0xC281, 0xC284, 0xC2C9, 0xC2A3, 0xC42D, 0xC4AB, 0xC440, 0xC01A, 0xBDE6, 0xC339, 0xC9DC, 0xCB20, 0xCA3A, 0xCDB0, 0xCB4A, 0xCBBA,
    0xD05A, 0xD7CB, 0xDB90, 0xD999, 0xDF70, 0xE884, 0xE9A0, 0xE556, 0xE37D, 0xE5FD, 0xEE04, 0xEF9A, 0xE68D, 0xDD49, 0xE3ED, 0xF3CA,
    0xFEC3, 0x02AC, 0xFF56, 0xF70F, 0xF250, 0xFC69, 0x0D20, 0x1BC0, 0x295F, 0x3A70, 0x43B7, 0x422D, 0x3DD9, 0x3FED, 0x46C6, 0x45A0,
    0x3E26, 0x354F, 0x3936, 0x43D3, 0x49E8, 0x455E, 0x38D7, 0x2C99, 0x230C, 0x2369, 0x2906, 0x2851, 0x1CBC, 0x0CC1, 0xF961, 0xE6AF,
    0xD70B, 0xCC5A, 0xC664, 0xC466, 0xC5A8, 0xC253, 0xC229, 0xC6E6, 0xC93D, 0xC67A, 0xC259, 0xC15A, 0xC25E, 0xC29F, 0xC738, 0xCDEF,
    0xCD0B, 0xC99F, 0xCB39, 0xD09D, 0xD32C, 0xD37D, 0xD42E, 0xDABC, 0xE4DD, 0xE831, 0xE3E9, 0xE2B5, 0xEA5D, 0xF255, 0xF351, 0xEE49,
    0xE864, 0xE355, 0xE990, 0xF85A, 0x027C, 0x0211, 0xFC1A, 0xFA4F, 0xF98D, 0xFB24, 0x0266, 0x124D, 0x2638, 0x33DB, 0x374A, 0x3805,
    0x3EA3, 0x474E, 0x486E, 0x4088, 0x398C, 0x374B, 0x3C46, 0x4527, 0x4A64, 0x462F, 0x3AC3, 0x3076, 0x2AE2, 0x2BEF, 0x2EA3, 0x2BC5,
    0x24A0, 0x1B3F, 0x0B47, 0xF6F3, 0xE592, 0xDBB8, 0xD40A, 0xCB67, 0xC775, 0xC89E, 0xCA09, 0xCA0A, 0xCC58, 0xCCB8, 0xC811, 0xC3EE,
    0xC531, 0xC974, 0xCD91, 0xCE4A, 0xCD01, 0xCF8A, 0xD459, 0xD51B, 0xD09B, 0xD18B, 0xDA1B, 0xE268, 0xE554, 0xE440, 0xE35E, 0xE529,
    0xEC97, 0xF456, 0xF425, 0xEB98, 0xE3F5, 0xE553, 0xEDC6, 0xF62A, 0xFB5F, 0xFE89, 0x006E, 0xFE8E, 0xF7D7, 0xF69F, 0x015D, 0x118E,
    0x1D1E, 0x2225, 0x270D, 0x2F0A, 0x38EF, 0x40ED, 0x40E0, 0x39C2, 0x3313, 0x325C, 0x399F, 0x42A8, 0x4576, 0x401A, 0x37BB, 0x31A2,
    0x2D7C, 0x2AD2, 0x2BAA, 0x2E2F, 0x2A8D, 0x1F80, 0x1200, 0x0423, 0xF45D, 0xE5A7, 0xDA8F, 0xD209, 0xCC3D, 0xC94D, 0xC9A9, 0xCC1C,
    0xCE36, 0xCADB, 0xC558, 0xC500, 0xC8A8, 0xC9BD, 0xC7F2, 0xC9A4, 0xCF7F, 0xD30F, 0xD1A4, 0xCF1B, 0xCE85, 0xD206, 0xD93D, 0xDFED,
    0xE0DC, 0xDD19, 0xDD56, 0xE509, 0xEE86, 0xF12A, 0xEC29, 0xE660, 0xE43C, 0xE461, 0xE616, 0xEC1B, 0xF659, 0xFCD5, 0xFA43, 0xF29C,
    0xECBB, 0xEEF0, 0xF825, 0x027D, 0x09EF, 0x10A5, 0x1A21, 0x26EF, 0x3481, 0x3CDD, 0x3BC4, 0x33DA, 0x2EF5, 0x327D, 0x3981, 0x3E0D,
    0x407C, 0x3FF9, 0x39B1, 0x316C, 0x2D25, 0x2DDC, 0x2F1C, 0x2EF1, 0x2CCF, 0x2692, 0x1C1F, 0x0ECF, 0x009B, 0xF363, 0xE60F, 0xD7BD,
    0xCD92, 0xCBEC, 0xCEBA, 0xCF24, 0xCC9B, 0xCAC2, 0xCAEA, 0xCA5F, 0xC877, 0xC7A9, 0xC930, 0xCDB8, 0xD353, 0xD576, 0xD24F, 0xCD21,
    0xCC5A, 0xD27C, 0xD94C, 0xDAC2, 0xD7B5, 0xD70D, 0xDCF0, 0xE46F, 0xE900, 0xEB1F, 0xEB48, 0xE874, 0xE319, 0xDF27, 0xE1D4, 0xEB32,
    0xF52C, 0xF8F7, 0xF5AE, 0xF03A, 0xEDB4, 0xF003, 0xF5F3, 0xFC34, 0xFFFA, 0x04A3, 0x10F1, 0x230F, 0x3124, 0x3662, 0x361F, 0x3396,
    0x30A4, 0x31A8, 0x37FF, 0x3EF0, 0x41CD, 0x3FF8, 0x3B16, 0x35A0, 0x31EC, 0x30D6, 0x3178, 0x3375, 0x331C, 0x2D33, 0x2493, 0x1C9B,
    0x1329, 0x0411, 0xF195, 0xE336, 0xDBA7, 0xD7CB, 0xD4F1, 0xD295, 0xD199, 0xD1C2, 0xD149, 0xCF10, 0xCBA7, 0xC9C5, 0xCBEC, 0xD1C3,
    0xD684, 0xD4FD, 0xCFC6, 0xCEEA, 0xD458, 0xD9F9, 0xDBB1, 0xDB13, 0xDB82, 0xDDAF, 0xE0FC, 0xE5E3, 0xEC95, 0xF247, 0xF3AB, 0xEF41,
    0xE856, 0xE5DE, 0xEA39, 0xF2A6, 0xFAD5, 0xFE0E, 0xFB2B, 0xF6B9, 0xF6BD, 0xFA42, 0xFBF2, 0xFBE6, 0xFDDD, 0x04F4, 0x11D8, 0x2196,
    0x2F2A, 0x36EF, 0x380E, 0x3575, 0x3376, 0x35F8, 0x3C30, 0x4158, 0x43E1, 0x4404, 0x40C6, 0x3A89, 0x35DB, 0x361B, 0x3850, 0x37E7,
    0x34C3, 0x3240, 0x3026, 0x2A81, 0x1F60, 0x100D, 0xFFCA, 0xF251, 0xE84E, 0xE0BF, 0xDAE2, 0xD73D, 0xD6D3, 0xD814, 0xD70C, 0xD1B6,
    0xCC53, 0xCC8B, 0xD1F4, 0xD6EC, 0xD749, 0xD4C6, 0xD3C7, 0xD603, 0xD986, 0xDC09, 0xDD64, 0xDED9, 0xDF6E, 0xDEFC, 0xE0EF, 0xE7D1,
    0xF06F, 0xF5ED, 0xF69B, 0xF243, 0xEB85, 0xE8EF, 0xEE64, 0xF735, 0xFC1E, 0xFC1A, 0xFB32, 0xFC53, 0xFEBF, 0x000E, 0xFED6, 0xFC54,
    0xFBBC, 0x007D, 0x0C15, 0x1C21, 0x2A6A, 0x321D, 0x3455, 0x3478, 0x348B, 0x35E0, 0x3A2D, 0x4110, 0x461B, 0x4583, 0x40DE, 0x3CC0,
    0x3B1C, 0x3A82, 0x3934, 0x3757, 0x3709, 0x385D, 0x37E2, 0x330A, 0x2973, 0x1C2B, 0x0E48, 0x01BD, 0xF5F3, 0xEA0F, 0xE109, 0xDE6B,
    0xDFF0, 0xDF21, 0xD963, 0xD2DB, 0xD0AA, 0xD320, 0xD653, 0xD762, 0xD6F9, 0xD6BD, 0xD6CB, 0xD76A, 0xD9BF, 0xDD6C, 0xDFB9, 0xDFBE,
    0xDEB9, 0xDE1F, 0xE02E, 0xE73A, 0xF177, 0xF853, 0xF748, 0xF118, 0xEC7E, 0xED58, 0xF23F, 0xF708, 0xF930, 0xF9E4, 0xFB30, 0xFD9B,
    0x0077, 0x01ED, 0xFFB8, 0xFA5B, 0xF734, 0xFB6D, 0x0670, 0x13F6, 0x20D2, 0x2B1D, 0x30C3, 0x3130, 0x304B, 0x32EE, 0x39B4, 0x4087,
    0x4381, 0x4322, 0x41FE, 0x40AD, 0x3EAB, 0x3C21, 0x394B, 0x378E, 0x38AE, 0x3BDC, 0x3CA6, 0x3836, 0x3004, 0x2723, 0x1D03, 0x0F9E,
    0x00BB, 0xF55A, 0xF093, 0xF093, 0xEFC1, 0xEAA6, 0xE387, 0xDE80, 0xDC7C, 0xDBE5, 0xDBF6, 0xDB45, 0xD74C, 0xD030, 0xCAFA, 0xCC22,
    0xD02A, 0xD424, 0xD80E, 0xD825, 0xD579, 0xD403, 0xD7C1, 0xE16D, 0xEB99, 0xF06F, 0xEEEE, 0xEBD4, 0xEA80, 0xEBC2, 0xEF15, 0xF270,
    0xF40A, 0xF44F, 0xF6A4, 0xFC04, 0x00AC, 0x0110, 0xFD3B, 0xF875, 0xF5C7, 0xF723, 0xFE29, 0x0A76, 0x1893, 0x2324, 0x27EC, 0x296B,
    0x2BBE, 0x306C, 0x364B, 0x3B4E, 0x3E4C, 0x3FF5, 0x413E, 0x41B9, 0x400E, 0x3BCA, 0x37B6, 0x375A, 0x3A2E, 0x3C4F, 0x3BAD, 0x3957,
    0x36D8, 0x3281, 0x282E, 0x1820, 0x0819, 0xFCD3, 0xF5A3, 0xF052, 0xEB56, 0xE579, 0xDF08, 0xDA2A, 0xD802, 0xD7CA, 0xD82A, 0xD894,
    0xD865, 0xD6FB, 0xD57C, 0xD61D, 0xDA16, 0xDEF3, 0xE07D, 0xDD23, 0xD875, 0xD768, 0xDC15, 0xE42D, 0xEBA1, 0xEF66, 0xEEC1, 0xECAB,
    0xEC70, 0xEEA0, 0xF105, 0xF188, 0xF0F3, 0xF24D, 0xF6A0, 0xFBDF, 0xFF9A, 0x009F, 0xFE86, 0xF961, 0xF3F4, 0xF329, 0xF989, 0x04C3,
    0x1085, 0x1987, 0x1ED0, 0x2234, 0x266D, 0x2C0F, 0x3181, 0x3528, 0x386E, 0x3CC0, 0x4095, 0x4153, 0x3E6B, 0x3A08, 0x37B2, 0x3898,
    0x39A4, 0x393E, 0x398B, 0x3B49, 0x3BB6, 0x375A, 0x2D8A, 0x2001, 0x126B, 0x075F, 0xFE7C, 0xF6F6, 0xEFFB, 0xE900, 0xE2BA, 0xDD9B,
    0xD9D4, 0xD83E, 0xD89A, 0xD924, 0xD7B3, 0xD472, 0xD29A, 0xD54D, 0xDAD3, 0xDEC4, 0xDE63, 0xDAC3, 0xD6CD, 0xD5DE, 0xDA0E, 0xE182,
    0xE7EC, 0xEA81, 0xEA57, 0xEAC0, 0xECA5, 0xEE55, 0xEE7D, 0xEDEF, 0xEE34, 0xEFA8, 0xF324, 0xF8BF, 0xFE6F, 0x010E, 0xFEAE, 0xF8C8,
    0xF325, 0xF266, 0xF7D7, 0x012F, 0x0AAA, 0x11F1, 0x17EB, 0x1E34, 0x2478, 0x293C, 0x2C2D, 0x2F7B, 0x354C, 0x3B9B, 0x3EC8, 0x3E01,
    0x3C0A, 0x3ADF, 0x399B, 0x376D, 0x356B, 0x3588, 0x3847, 0x3C37, 0x3E18, 0x3B5C, 0x334F, 0x27EF, 0x1C28, 0x11C2, 0x08AB, 0x0075,
    0xF912, 0xF1CD, 0xE9DC, 0xE254, 0xDE10, 0xDD90, 0xDDFF, 0xDC72, 0xD88A, 0xD49B, 0xD3C2, 0xD6D4, 0xDBED, 0xDF3C, 0xDDE8, 0xD907,
    0xD52F, 0xD615, 0xDA9B, 0xDEC8, 0xE0D9, 0xE196, 0xE2D3, 0xE49A, 0xE74A, 0xEBD4, 0xEF9A, 0xEF90, 0xEE6E, 0xEF00, 0xF24D, 0xF8EF,
    0xFF46, 0x021B, 0xFFB9, 0xF97E, 0xF448, 0xF346, 0xF719, 0xFD1E, 0x0320, 0x09C0, 0x1208, 0x1A27, 0x1F4E, 0x2268, 0x262C, 0x2BF0,
    0x32D6, 0x3848, 0x3B5F, 0x3CF1, 0x3DF1, 0x3DB5, 0x3BA6, 0x3854, 0x3598, 0x35BF, 0x3919, 0x3DA1, 0x401D, 0x3E76, 0x38AD, 0x3006,
    0x2577, 0x1AEB, 0x11D4, 0x0A00, 0x01BF, 0xF797, 0xED30, 0xE560, 0xE200, 0xE11C, 0xDFF6, 0xDCD3, 0xD7D1, 0xD389, 0xD2D6, 0xD673,
    0xDBB6, 0xDDD8, 0xDB85, 0xD794, 0xD52D, 0xD565, 0xD79B, 0xDB11, 0xDEB2, 0xE19B, 0xE423, 0xE6C4, 0xE97D, 0xEB97, 0xEC0E, 0xEA7D,
    0xE867, 0xE84E, 0xEC65, 0xF3E5, 0xFB7B, 0xFE6D, 0xFBD0, 0xF738, 0xF414, 0xF341, 0xF3EA, 0xF66C, 0xFBAD, 0x03A5, 0x0C15, 0x12AE,
    0x179E, 0x1C6C, 0x2237, 0x2887, 0x2E6D, 0x3362, 0x379D, 0x3B34, 0x3DD7, 0x3E57, 0x3BCE, 0x376E, 0x3457, 0x34BB, 0x37EB, 0x3BFB,
    0x3F57, 0x401D, 0x3C82, 0x34CE, 0x2B57, 0x229C, 0x1AE7, 0x12E6, 0x0932, 0xFDC7, 0xF2C0, 0xEA6E, 0xE644, 0xE4FC, 0xE2DA, 0xDDAD,
    0xD732, 0xD30B, 0xD33F, 0xD67F, 0xD9FF, 0xDB07, 0xD961, 0xD6B5, 0xD4BA, 0xD44D, 0xD5A2, 0xD802, 0xDA89, 0xDCFF, 0xDFF0, 0xE394,
    0xE79F, 0xEAC2, 0xEB6D, 0xE8FB, 0xE59C, 0xE584, 0xEACA, 0xF2D3, 0xF8F4, 0xFB3A, 0xFAE4, 0xF95C, 0xF6C6, 0xF3F3, 0xF27B, 0xF400,
    0xF8C5, 0xFF97, 0x0647, 0x0C35, 0x1192, 0x174E, 0x1D8A, 0x236F, 0x2841, 0x2CD0, 0x32A7, 0x386A, 0x3BFE, 0x3BED, 0x3914, 0x3526,
    0x31C9, 0x3083, 0x3245, 0x371D, 0x3C75, 0x3E93, 0x3C2D, 0x3668, 0x2F52, 0x2860, 0x2198, 0x19FF, 0x1013, 0x03C3, 0xF7D7, 0xEFC3,
    0xEC31, 0xE9A9, 0xE51A, 0xDE53, 0xD7C4, 0xD3F1, 0xD3A2, 0xD5DB, 0xD851, 0xD928, 0xD814, 0xD610, 0xD496, 0xD44E, 0xD4D2, 0xD652,
    0xD816, 0xD9AD, 0xDC0B, 0xE0D0, 0xE71E, 0xEB19, 0xEA58, 0xE681, 0xE3E4, 0xE4E3, 0xE9C4, 0xF019, 0xF540, 0xF86F, 0xF9BA, 0xF8D5,
    0xF5CE, 0xF236, 0xF015, 0xF0C8, 0xF437, 0xF92D, 0xFE49, 0x0383, 0x09AA, 0x105E, 0x1659, 0x1AF1, 0x1F82, 0x2592, 0x2CA7, 0x3319,
    0x37CF, 0x39CB, 0x3879, 0x348D, 0x3047, 0x2E67, 0x303D, 0x34B9, 0x3962, 0x3C1B, 0x3B0A, 0x36B1, 0x3161, 0x2CEB, 0x27FC, 0x2066,
    0x1556, 0x08AE, 0xFD9A, 0xF62F, 0xF1D8, 0xED8C, 0xE780, 0xE010, 0xD979, 0xD5BB, 0xD570, 0xD6FE, 0xD8A8, 0xD95A, 0xD8B7, 0xD715,
    0xD58D, 0xD565, 0xD64F, 0xD6AC, 0xD5F9, 0xD5FE, 0xD952, 0xDFC3, 0xE636, 0xE942, 0xE828, 0xE53E, 0xE368, 0xE3F5, 0xE6F9, 0xEBC6,
    0xF138, 0xF5F4, 0xF8F9, 0xF937, 0xF66E, 0xF2CC, 0xF0B0, 0xF0F2, 0xF271, 0xF4DC, 0xF8A5, 0xFE26, 0x046A, 0x0A50, 0x0F62, 0x13E8,
    0x18DB, 0x1ED0, 0x25EF, 0x2D72, 0x33DB, 0x3735, 0x36F8, 0x33F7, 0x3006, 0x2DCA, 0x2F0E, 0x3354, 0x3826, 0x3ACF, 0x3A34, 0x37AF,
    0x356F, 0x3389, 0x2F96, 0x27FE, 0x1D1F, 0x112C, 0x06E6, 0xFFA1, 0xFA57, 0xF485, 0xECED, 0xE4BC, 0xDDF8, 0xD98C, 0xD7AA, 0xD829,
    0xD997, 0xD9E4, 0xD86F, 0xD6E6, 0xD6CE, 0xD7D1, 0xD80B, 0xD658, 0xD447, 0xD476, 0xD86E, 0xDE90, 0xE433, 0xE736, 0xE726, 0xE588,
    0xE41E, 0xE3B4, 0xE503, 0xE8A4, 0xEE4B, 0xF400, 0xF7AB, 0xF83B, 0xF6A1, 0xF46F, 0xF29E, 0xF14F, 0xF0DB, 0xF235, 0xF59E, 0xFA5F,
    0xFFBF, 0x0530, 0x0A02, 0x0E31, 0x1292, 0x186C, 0x1FD4, 0x280F, 0x2F7C, 0x346E, 0x3586, 0x3304, 0x2EC9, 0x2C58, 0x2DBA, 0x319E,
    0x3506, 0x3650, 0x3618, 0x35C8, 0x35FD, 0x3606, 0x339C, 0x2CEE, 0x22D5, 0x185F, 0x0F77, 0x0850, 0x01E0, 0xFB22, 0xF32D, 0xEA7C,
    0xE276, 0xDCE2, 0xDAA0, 0xDAAE, 0xDAB1, 0xD936, 0xD769, 0xD718, 0xD823, 0xD8BF, 0xD79C, 0xD4E1, 0xD2AF, 0xD303, 0xD675, 0xDBBC,
    0xE0CA, 0xE440, 0xE5A8, 0xE55D, 0xE3C8, 0xE22F, 0xE2A5, 0xE64E, 0xEBE3, 0xF148, 0xF504, 0xF6C1, 0xF6EF, 0xF5D4, 0xF410, 0xF252,
    0xF145, 0xF166, 0xF36F, 0xF73D, 0xFBD8, 0x0076, 0x04A7, 0x0854, 0x0C53, 0x119A, 0x18C3, 0x219F, 0x2AC5, 0x3153, 0x330D, 0x30E4,
    0x2DBB, 0x2C71, 0x2DA4, 0x3074, 0x32B0, 0x3361, 0x33D5, 0x3545, 0x37B0, 0x38F5, 0x36FC, 0x3133, 0x28FC, 0x2008, 0x177B, 0x1045,
    0x0A06, 0x0342, 0xFA73, 0xF061, 0xE782, 0xE1EC, 0xDF39, 0xDD6F, 0xDB2B, 0xD8C6, 0xD79F, 0xD83E, 0xD9AC, 0xDA04, 0xD822, 0xD506,
    0xD2BD, 0xD289, 0xD4B0, 0xD89F, 0xDD5F, 0xE1CD, 0xE46A, 0xE457, 0xE260, 0xE0B8, 0xE11F, 0xE3B6, 0xE813, 0xED08, 0xF155, 0xF467,
    0xF5F6, 0xF5EE, 0xF49E, 0xF2B3, 0xF0EB, 0xF065, 0xF1DF, 0xF4DE, 0xF8A0, 0xFCD4, 0x00CF, 0x03F0, 0x06AE, 0x0AE4, 0x1228, 0x1C05,
    0x25F1, 0x2CFA, 0x2FA1, 0x2EDF, 0x2D27, 0x2CF0, 0x2E5A, 0x2FC2, 0x3035, 0x3061, 0x31B4, 0x3473, 0x37C7, 0x39CB, 0x3914, 0x3515,
    0x2E27, 0x25D5, 0x1E66, 0x1876, 0x12BC, 0x0B31, 0x0144, 0xF6B9, 0xEE12, 0xE848, 0xE456, 0xE09B, 0xDCC3, 0xD9C4, 0xD8B6, 0xD9B3,
    0xDAF4, 0xDAA0, 0xD8BA, 0xD62A, 0xD3C5, 0xD25B, 0xD322, 0xD671, 0xDB54, 0xDFFD, 0xE2DF, 0xE345, 0xE218, 0xE0AE, 0xE070, 0xE218,
    0xE57E, 0xE9C4, 0xEE26, 0xF239, 0xF52E, 0xF63C, 0xF583, 0xF39D, 0xF1B1, 0xF0A5, 0xF0EC, 0xF2FE, 0xF6B3, 0xFAE0, 0xFE18, 0x000A,
    0x01B4, 0x0541, 0x0C4A, 0x1681, 0x20C5, 0x2828, 0x2B7B, 0x2C29, 0x2C83, 0x2D8C, 0x2E67, 0x2E71, 0x2E23, 0x2E3E, 0x2F7B, 0x323C,
    0x3630, 0x3997, 0x3A4C, 0x372A, 0x3116, 0x2A4D, 0x24A6, 0x1FD4, 0x19FA, 0x11E0, 0x07D6, 0xFDAC, 0xF569, 0xEF11, 0xE948, 0xE377,
    0xDE6D, 0xDB55, 0xDA5A, 0xDABB, 0xDB43, 0xDB04, 0xD9B0, 0xD71E, 0xD402, 0xD1D2, 0xD1CD, 0xD46C, 0xD8C6, 0xDD3B, 0xE065, 0xE198,
    0xE120, 0xE010, 0xDFC2, 0xE09C, 0xE2A5, 0xE62B, 0xEADB, 0xEF92, 0xF329, 0xF52F, 0xF598, 0xF474, 0xF285, 0xF0B1, 0xF052, 0xF233,
    0xF5DA, 0xF9CF, 0xFC51, 0xFCF4, 0xFD64, 0x0069, 0x07AA, 0x1190, 0x1B2D, 0x2266, 0x26EF, 0x29E8, 0x2C0F, 0x2DC1, 0x2EBC, 0x2EC6,
    0x2DFE, 0x2D20, 0x2DD2, 0x30D7, 0x359C, 0x39DD, 0x3B3D, 0x38F1, 0x346F, 0x2F9D, 0x2B89, 0x2759, 0x2170, 0x191A, 0x0F7B, 0x0669,
    0xFE48, 0xF6A4, 0xEF23, 0xE833, 0xE250, 0xDE3D, 0xDC0B, 0xDB95, 0xDC23, 0xDC65, 0xDB53, 0xD8C2, 0xD58C, 0xD2D1, 0xD1F8, 0xD3D0,
    0xD791, 0xDBA5, 0xDED6, 0xE0BF, 0xE153, 0xE0D1, 0xDFF4, 0xDFB5, 0xE0B9, 0xE349, 0xE796, 0xEC3C, 0xF021, 0xF264, 0xF364, 0xF2DD,
    0xF0BB, 0xEE7A, 0xEE07, 0xF054, 0xF44C, 0xF811, 0xF993, 0xF919, 0xF928, 0xFC3B, 0x02C0, 0x0B76, 0x1464, 0x1C09, 0x21F5, 0x2682,
    0x2A40, 0x2D36, 0x2EFF, 0x2EE9, 0x2D47, 0x2BA7, 0x2BFF, 0x2F25, 0x3451, 0x38E7, 0x3A85, 0x3917, 0x3677, 0x33EA, 0x3124, 0x2D57,
    0x27A7, 0x2039, 0x17DD, 0x0FA1, 0x07BB, 0xFFA2, 0xF785, 0xEF90, 0xE883, 0xE34D, 0xE02C, 0xDF0E, 0xDF61, 0xDF6C, 0xDE4F, 0xDB70,
    0xD77A, 0xD433, 0xD2C6, 0xD386, 0xD5ED, 0xD954, 0xDCB2, 0xDF49, 0xE0AD, 0xE0C2, 0xDFD5, 0xDF02, 0xDF7A, 0xE173, 0xE4F9, 0xE935,
    0xEDA4, 0xF1AD, 0xF43E, 0xF428, 0xF1B2, 0xEF1F, 0xEEA8, 0xF109, 0xF4B9, 0xF774, 0xF7FF, 0xF726, 0xF6EB, 0xF91F, 0xFE5E, 0x05C8,
    0x0DD9, 0x1593, 0x1C27, 0x21C3, 0x26F1, 0x2B89, 0x2E92, 0x2EFF, 0x2D1D, 0x2B0B, 0x2B90, 0x2F52, 0x342B, 0x3803, 0x39A8, 0x3997,
    0x38C6, 0x37B2, 0x35CD, 0x325C, 0x2D28, 0x26CC, 0x1FE3, 0x1876, 0x10D2, 0x086F, 0xFF66, 0xF686, 0xEE72, 0xE7BF, 0xE346, 0xE169,
    0xE14E, 0xE139, 0xDFE5, 0xDD13, 0xD94F, 0xD5DC, 0xD3B7, 0xD336, 0xD46C, 0xD6F8, 0xDA48, 0xDD3F, 0xDF19, 0xDF6A, 0xDED7, 0xDE45,
    0xDE43, 0xDF08, 0xE11B, 0xE4CF, 0xE9F6, 0xEF47, 0xF2A7, 0xF2D1, 0xF08B, 0xEE70, 0xEE6E, 0xF0C4, 0xF3F5, 0xF649, 0xF6CA, 0xF601,
    0xF572, 0xF6C2, 0xFAD8, 0x013B, 0x0880, 0x0F87, 0x15FC, 0x1C65, 0x2332, 0x2970, 0x2CF3, 0x2D48, 0x2B9C, 0x2A22, 0x2AAF, 0x2D8D,
    0x3143, 0x3469, 0x36A2, 0x37FC, 0x38AC, 0x38BB, 0x3798, 0x34D1, 0x30AA, 0x2B95, 0x25B8, 0x1F49, 0x183B, 0x105C, 0x0790, 0xFE16,
    0xF4B2, 0xECC6, 0xE757, 0xE47A, 0xE38F, 0xE2E9, 0xE149, 0xDE53, 0xDA7E, 0xD6E6, 0xD434, 0xD323, 0xD3BC, 0xD5A4, 0xD8AB, 0xDBC0,
    0xDDE6, 0xDF30, 0xDFB1, 0xDF82, 0xDEB3, 0xDE18, 0xDF1B, 0xE2B5, 0xE88B, 0xEE86, 0xF233, 0xF2E0, 0xF163, 0xEFA8, 0xEFA2, 0xF189,
    0xF41C, 0xF60C, 0xF687, 0xF5B9, 0xF4C0, 0xF57D, 0xF8BA, 0xFDAA, 0x033C, 0x08CA, 0x0F19, 0x16A1, 0x1ED0, 0x25ED, 0x2A16, 0x2B13,
    0x2A2A, 0x2983, 0x2A63, 0x2C92, 0x2F58, 0x31FD, 0x3443, 0x3659, 0x381C, 0x391D, 0x38F5, 0x3760, 0x3453, 0x2FF4, 0x2ADA, 0x254C,
    0x1F34, 0x1837, 0x0FCE, 0x0602, 0xFBD4, 0xF2DB, 0xEC5C, 0xE86F, 0xE68F, 0xE55F, 0xE3EB, 0xE19E, 0xDE74, 0xDAAC, 0xD706, 0xD47A,
    0xD3F4, 0xD52B, 0xD738, 0xD96B, 0xDB97, 0xDDA5, 0xDECD, 0xDE95, 0xDD1B, 0xDBB8, 0xDBFE, 0xDF32, 0xE4B3, 0xEA52, 0xEE4A, 0xEFC6,
    0xEF53, 0xEE86, 0xEF03, 0xF0DC, 0xF39B, 0xF59B, 0xF5D6, 0xF4BA, 0xF3C5, 0xF451, 0xF6A4, 0xFA0A, 0xFD93, 0x01C8, 0x07FF, 0x1033,
    0x190A, 0x2098, 0x2570, 0x275C, 0x27B3, 0x27E3, 0x28B9, 0x2A38, 0x2C34, 0x2E52, 0x309C, 0x3323, 0x358C, 0x376F, 0x3877, 0x3801,
    0x35E9, 0x3277, 0x2E61, 0x29E7, 0x2527, 0x1F53, 0x17B0, 0x0E10, 0x03E3, 0xFA6E, 0xF2D0, 0xED9D, 0xEA73, 0xE876, 0xE6DC, 0xE4B2,
    0xE160, 0xDD4C, 0xD96A, 0xD68F, 0xD545, 0xD4FA, 0xD58C, 0xD735, 0xD9D6, 0xDC94, 0xDE58, 0xDE63, 0xDCA0, 0xDACD, 0xDAA2, 0xDD31,
    0xE1EE, 0xE74E, 0xEB77, 0xED63, 0xED81, 0xED4B, 0xEE25, 0xF067, 0xF329, 0xF4BD, 0xF4AB, 0xF3C9, 0xF359, 0xF3DF, 0xF535, 0xF6BB,
    0xF89D, 0xFC0D, 0x01EC, 0x0A51, 0x1386, 0x1B68, 0x20F9, 0x2427, 0x25C4, 0x26E3, 0x27F4, 0x2955, 0x2AE4, 0x2CC9, 0x2EF8, 0x315C,
    0x33E9, 0x366E, 0x3838, 0x3875, 0x372F, 0x34A0, 0x318E, 0x2E68, 0x2AB7, 0x25BC, 0x1EE1, 0x1607, 0x0C16, 0x0233, 0xF991, 0xF2BD,
    0xEE27, 0xEB79, 0xE99F, 0xE718, 0xE38E, 0xDF71, 0xDB81, 0xD876, 0xD63A, 0xD4BA, 0xD465, 0xD5CF, 0xD896, 0xDBB8, 0xDDC5, 0xDDCB,
    0xDC3E, 0xDA5C, 0xD9E5, 0xDBD4, 0xDFEA, 0xE4F0, 0xE90E, 0xEB36, 0xEBDB, 0xEC38, 0xEDBA, 0xF035, 0xF273, 0xF3A3, 0xF3C8, 0xF3B5,
    0xF3F4, 0xF476, 0xF49C, 0xF44B, 0xF487, 0xF6A4, 0xFBA7, 0x0351, 0x0C2A, 0x143C, 0x1AAD, 0x1F38, 0x220E, 0x23FB, 0x25A1, 0x2739,
    0x28AF, 0x2A33, 0x2BEA, 0x2E1E, 0x3114, 0x3446, 0x36D0, 0x37DD, 0x3745, 0x3593, 0x3398, 0x319A, 0x2EE9, 0x2AC0, 0x24D7, 0x1D07,
    0x13A8, 0x0969, 0xFFA0, 0xF7A4, 0xF20C, 0xEE44, 0xEB1E, 0xE7E1, 0xE43F, 0xE06F, 0xDCB8, 0xD919, 0xD5BC, 0xD327, 0xD22C, 0xD31C,
    0xD5B6, 0xD8DB, 0xDB09, 0xDB65, 0xDA05, 0xD7FE, 0xD70F, 0xD8B7, 0xDC6B, 0xE0E3, 0xE47F, 0xE666, 0xE744, 0xE8A9, 0xEB42, 0xEDF6,
    0xEFFE, 0xF103, 0xF196, 0xF242, 0xF344, 0xF3DF, 0xF367, 0xF21B, 0xF159, 0xF270, 0xF64E, 0xFCD4, 0x04CA, 0x0CCD, 0x13AC, 0x1905,
    0x1CDC, 0x1FEE, 0x2262, 0x2471, 0x2617, 0x2767, 0x28DA, 0x2B13, 0x2E34, 0x31A7, 0x347C, 0x35FE, 0x3664, 0x3601, 0x3529, 0x33F4,
    0x3231, 0x2F8A, 0x2B33, 0x24BA, 0x1C3C, 0x1232, 0x0819, 0xFF7D, 0xF8E8, 0xF3E2, 0xEFA7, 0xEBD4, 0xE80F, 0xE460, 0xE0B2, 0xDC8F,
    0xD828, 0xD4A3, 0xD2A4, 0xD2AF, 0xD4BD, 0xD7B7, 0xDA15, 0xDAB2, 0xD96E, 0xD75F, 0xD66F, 0xD7AD, 0xDAC9, 0xDE61, 0xE13F, 0xE30C,
    0xE4AB, 0xE6E5, 0xE9A4, 0xEBF7, 0xED8F, 0xEE8C, 0xEFA2, 0xF11E, 0xF285, 0xF333, 0xF2B0, 0xF0F8, 0xEED4, 0xEE84, 0xF142, 0xF70A,
    0x0001, 0x09AB, 0x0EFE, 0x120F, 0x16CA, 0x1AF9, 0x1E8E, 0x2197, 0x2353, 0x24A7, 0x2601, 0x285C, 0x2B8C, 0x2F0D, 0x322A, 0x3416,
    0x34C2, 0x34C9, 0x349B, 0x3404, 0x3349, 0x31EE, 0x2F0D, 0x29FB, 0x2254, 0x18E1, 0x0F0E, 0x0642, 0xFEBB, 0xF87D, 0xF342, 0xEEF2,
    0xEB65, 0xE7F4, 0xE400, 0xDF7C, 0xDA9C, 0xD622, 0xD309, 0xD22D, 0xD3A3, 0xD65D, 0xD8BA, 0xD94A, 0xD7FE, 0xD628, 0xD543, 0xD628,
    0xD882, 0xDB09, 0xDD2E, 0xDF11, 0xE173, 0xE450, 0xE73B, 0xE995, 0xEB1D, 0xEC58, 0xEDCE, 0xEFBA, 0xF1C0, 0xF32A, 0xF315, 0xF17D,
    0xEF86, 0xEE9F, 0xEFB6, 0xF2FF, 0xF8AD, 0xFFC8, 0x06D0, 0x0D41, 0x12F9, 0x17F7, 0x1C2E, 0x1F54, 0x213C, 0x22A6, 0x244F, 0x26AA,
    0x29A5, 0x2CB0, 0x2F8B, 0x3232, 0x33F5, 0x34AE, 0x34B6, 0x34EC, 0x3549, 0x3515, 0x3389, 0x2FF2, 0x2A10, 0x2270, 0x19EE, 0x116E,
    0x09A4, 0x02C6, 0xFC88, 0xF6BF, 0xF1D3, 0xED52, 0xE8A1, 0xE35A, 0xDD5F, 0xD73E, 0xD295, 0xD090, 0xD156, 0xD3A5, 0xD616, 0xD783,
    0xD791, 0xD6EB, 0xD6B4, 0xD7F0, 0xDA52, 0xDCE0, 0xDE78, 0xDFE2, 0xE1E8, 0xE476, 0xE737, 0xE935, 0xEAAA, 0xEC10, 0xED65, 0xEEC9,
    0xF003, 0xF05E, 0xEFD4, 0xEEB2, 0xED18, 0xEBB1, 0xEBC2, 0xEE16, 0xF276, 0xF85A, 0xFF21, 0x0645, 0x0D7C, 0x143F, 0x19A6, 0x1D8B,
    0x2055, 0x2250, 0x2442, 0x2673, 0x28E7, 0x2BCB, 0x2EE6, 0x31AC, 0x33C0, 0x34CC, 0x3585, 0x3651, 0x3766, 0x3814, 0x3762, 0x34A5,
    0x2FF6, 0x2961, 0x2153, 0x18A5, 0x0FE1, 0x07BB, 0x0075, 0xFAA5, 0xF613, 0xF25B, 0xEE95, 0xE9EC, 0xE3FD, 0xDD99, 0xD85F, 0xD5E0,
    0xD5E2, 0xD782, 0xD956, 0xD981, 0xD884, 0xD74D, 0xD6D2, 0xD720, 0xD7D4, 0xD8DD, 0xDA28, 0xDBD5, 0xDE38, 0xE0F1, 0xE37F, 0xE585,
    0xE735, 0xE8CA, 0xEAC8, 0xED7E, 0xF0A5, 0xF346, 0xF435, 0xF32C, 0xF10C, 0xEEC7, 0xEDF1, 0xEF21, 0xF1A7, 0xF597, 0xFADD, 0x0128,
    0x07C8, 0x0E2B, 0x1380, 0x179F, 0x1ACE, 0x1D4D, 0x1F4D, 0x2144, 0x23BD, 0x26C0, 0x2A3D, 0x2E20, 0x3047, 0x3202, 0x33DA, 0x355A,
    0x372A, 0x388E, 0x38E5, 0x37B2, 0x34BD, 0x2FFF, 0x2967, 0x217F, 0x1923, 0x10D4, 0x08E0, 0x0274, 0xFDD6, 0xFA63, 0xF70F, 0xF26A,
    0xEBE0, 0xE480, 0xDE3D, 0xDAC8, 0xDA02, 0xDA7F, 0xDAF0, 0xDA93, 0xD99F, 0xD8AE, 0xD822, 0xD7E0, 0xD814, 0xD87A, 0xD990, 0xDB2E,
    0xDD2E, 0xDFB7, 0xE220, 0xE455, 0xE5FE, 0xE77D, 0xE98D, 0xEC95, 0xF032, 0xF357, 0xF4C6, 0xF43F, 0xF266, 0xF070, 0xEEEE, 0xEE94,
    0xEFA3, 0xF257, 0xF6E5, 0xFCE7, 0x0397, 0x0A28, 0x1025, 0x1530, 0x190F, 0x1C01, 0x1E57, 0x2097, 0x2373, 0x26D8, 0x2A1C, 0x2CD7,
    0x2F01, 0x30D8, 0x329E, 0x34C8, 0x371B, 0x3924, 0x3A91, 0x3AA7, 0x3911, 0x35CD, 0x30E4, 0x2A62, 0x22A3, 0x19E4, 0x1108, 0x0960,
    0x03EF, 0x0050, 0xFCCE, 0xF7FA, 0xF13E, 0xE9D7, 0xE36E, 0xDF3E, 0xDD21, 0xDC63, 0xDC0A, 0xDB8D, 0xDAD8, 0xDA36, 0xD9AD, 0xD949,
    0xD909, 0xD909, 0xD951, 0xDA51, 0xDC36, 0xDEBB, 0xE13E, 0xE32E, 0xE47C, 0xE5D8, 0xE7FF, 0xEB43, 0xEF2A, 0xF2AC, 0xF4CE, 0xF55F,
    0xF4B6, 0xF30B, 0xF151, 0xF016, 0xEFEF, 0xF14A, 0xF491, 0xF96D, 0xFF47, 0x05C0, 0x0C2F, 0x11DC, 0x1638, 0x1973, 0x1BD7, 0x1E5D,
    0x213C, 0x245E, 0x2743, 0x29D0, 0x2BC1, 0x2D4A, 0x2EFA, 0x3100, 0x3387, 0x3633, 0x385A, 0x394B, 0x38DF, 0x372A, 0x340E, 0x2F30,
    0x286C, 0x1FDE, 0x16D3, 0x0F28, 0x09A6, 0x05D0, 0x0219, 0xFD05, 0xF645, 0xEECF, 0xE800, 0xE2E0, 0xDFA8, 0xDDF0, 0xDCE8, 0xDC1B,
    0xDB76, 0xDAE7, 0xDA75, 0xDA23, 0xD99B, 0xD916, 0xD8F8, 0xD9C0, 0xDB90, 0xDE02, 0xE054, 0xE1F4, 0xE325, 0xE458, 0xE68A, 0xE9DC,
    0xEDDA, 0xF1A4, 0xF460, 0xF5F7, 0xF61E, 0xF4ED, 0xF320, 0xF139, 0xF00A, 0xF02D, 0xF1CC, 0xF50A, 0xF9D1, 0xFFC2, 0x060C, 0x0BD0,
    0x1093, 0x1417, 0x16F3, 0x19D3, 0x1CCF, 0x1FD9, 0x22DE, 0x259E, 0x2796, 0x293B, 0x2AF2, 0x2CF4, 0x2FB2, 0x3299, 0x3501, 0x3696,
    0x3743, 0x3719, 0x3592, 0x3243, 0x2C43, 0x241E, 0x1B5A, 0x13A4, 0x0DD7, 0x09A5, 0x05DD, 0x00F1, 0xFA6D, 0xF318, 0xEC13, 0xE656,
    0xE227, 0xDF62, 0xDD69, 0xDC1E, 0xDB27, 0xDA6C, 0xD9FA, 0xD94E, 0xD858, 0xD734, 0xD697, 0xD715, 0xD8BF, 0xDAE5, 0xDCD7, 0xDE34,
    0xDF49, 0xE077, 0xE29B, 0xE5B4, 0xE95F, 0xED3D, 0xF0AB, 0xF337, 0xF460, 0xF402, 0xF292, 0xF099, 0xEEE4, 0xEDE3, 0xEE08, 0xF010,
    0xF405, 0xF95B, 0xFF40, 0x04E7, 0x09CA, 0x0DAE, 0x10D2, 0x13EB, 0x171B, 0x1A8A, 0x1DF1, 0x20B9, 0x22C4, 0x2431, 0x259D, 0x27A1,
    0x2A37, 0x2D02, 0x2F7A, 0x31AA, 0x3391, 0x353A, 0x35D6, 0x3415, 0x2FA4, 0x289D, 0x2072, 0x18CE, 0x12C9, 0x0E2B, 0x09E6, 0x04F6,
    0xFED7, 0xF7AA, 0xF09F, 0xEA59, 0xE502, 0xE0C7, 0xDD83, 0xDB53, 0xD9F2, 0xD941, 0xD8C1, 0xD7CE, 0xD658, 0xD4DE, 0xD3E0, 0xD42D,
    0xD573, 0xD72B, 0xD8CE, 0xD9D8, 0xDA98, 0xDBAE, 0xDD6B, 0xDFE1, 0xE339, 0xE724, 0xEAC4, 0xEDC7, 0xEFE1, 0xF0D2, 0xF0A6, 0xEF5D,
    0xED96, 0xEBC1, 0xEB04, 0xEC11, 0xEEC7, 0xF323, 0xF876, 0xFE0C, 0x034D, 0x0798, 0x0B08, 0x0E4D, 0x11FA, 0x15CE, 0x196C, 0x1C47,
    0x1E53, 0x1FC6, 0x216D, 0x23D0, 0x268C, 0x290D, 0x2B55, 0x2D88, 0x3020, 0x32E8, 0x3494, 0x33FF, 0x3093, 0x2ACE, 0x2388, 0x1C79,
    0x167F, 0x11B3, 0x0D22, 0x0803, 0x01D7, 0xFB00, 0xF42F, 0xED84, 0xE77E, 0xE236, 0xDDD3, 0xDAB4, 0xD8DD, 0xD80C, 0xD767, 0xD66B,
    0xD4DC, 0xD30A, 0xD1DD, 0xD1B6, 0xD27A, 0xD3D0, 0xD532, 0xD62D, 0xD6D5, 0xD78A, 0xD89C, 0xDA8B, 0xDD87, 0xE138, 0xE523, 0xE8E4,
    0xEBEC, 0xEDEA, 0xEED2, 0xEE7B, 0xECDB, 0xEAD4, 0xE973, 0xE923, 0xEA8B, 0xEDC2, 0xF265, 0xF7CB, 0xFCFF, 0x0182, 0x0538, 0x090F,
    0x0D35, 0x116C, 0x1589, 0x1890, 0x1AD4, 0x1C94, 0x1E94, 0x20BA, 0x22D7, 0x24B4, 0x2683, 0x2917, 0x2C4E, 0x3054, 0x3397, 0x3486,
    0x32AA, 0x2DF9, 0x27C7, 0x2153, 0x1BB7, 0x16D4, 0x1227, 0x0CD6, 0x06ED, 0x0087, 0xF97C, 0xF2BD, 0xEC5C, 0xE6B9, 0xE194, 0xDD7F,
    0xDB24, 0xD9C7, 0xD8DC, 0xD766, 0xD596, 0xD3A2, 0xD202, 0xD194, 0xD206, 0xD319, 0xD443, 0xD53A, 0xD5A4, 0xD5ED, 0xD680, 0xD812,
    0xDACF, 0xDE00, 0xE1E8, 0xE5CF, 0xE97A, 0xEC8A, 0xEE2D, 0xEE7F, 0xED84, 0xEBC2, 0xE99D, 0xE810, 0xE7E6, 0xE9C3, 0xEDA8, 0xF231,
    0xF6B4, 0xFABE, 0xFF10, 0x03B2, 0x082D, 0x0C8B, 0x108E, 0x13C1, 0x163F, 0x18CE, 0x1B00, 0x1D0E, 0x1ECC, 0x201C, 0x21D6, 0x2470,
    0x2835, 0x2CE9, 0x3143, 0x3392, 0x333C, 0x3089, 0x2BD2, 0x2673, 0x2141, 0x1C87, 0x17A4, 0x1262, 0x0CAA, 0x068F, 0x0054, 0xF992,
    0xF284, 0xEB36, 0xE4DB, 0xE005, 0xDCC3, 0xDB04, 0xD9A5, 0xD80A, 0xD61B, 0xD421, 0xD27D, 0xD1CA, 0xD221, 0xD303, 0xD41F, 0xD4FC,
    0xD563, 0xD5A0, 0xD644, 0xD779, 0xD94A, 0xDC26, 0xDF96, 0xE38B, 0xE788, 0xEB27, 0xEDDE, 0xEF08, 0xEEB6, 0xECF1, 0xEAB8, 0xE8D6,
    0xE808, 0xE922, 0xEC1B, 0xF013, 0xF3F0, 0xF7D1, 0xFBA3, 0xFFF6, 0x04C2, 0x0939, 0x0D2B, 0x1070, 0x1365, 0x160F, 0x18EC, 0x1B67,
    0x1D02, 0x1E13, 0x1F0A, 0x211F, 0x24BD, 0x2A0D, 0x2F55, 0x32B6, 0x33B2, 0x3258, 0x2F17, 0x2AFF, 0x26DA, 0x2249, 0x1D4E, 0x1827,
    0x12F4, 0x0D7A, 0x078D, 0x0106, 0xF9C8, 0xF266, 0xEB73, 0xE5F4, 0xE218, 0xDF67, 0xDD72, 0xDB68, 0xD91C, 0xD6C8, 0xD4CC, 0xD3A2,
    0xD35E, 0xD3EB, 0xD4DD, 0xD5A9, 0xD5F0, 0xD639, 0xD667, 0xD6C6, 0xD827, 0xDA4B, 0xDD7E, 0xE15D, 0xE59A, 0xE9AA, 0xED2F, 0xEFA8,
    0xF040, 0xEF1E, 0xECBC, 0xEA48, 0xE8E1, 0xE938, 0xEB29, 0xEDDE, 0xF0E0, 0xF418, 0xF7E2, 0xFC5E, 0x015D, 0x05F1, 0x09B4, 0x0D2F,
    0x106D, 0x13E8, 0x1750, 0x1A3B, 0x1BF1, 0x1CC1, 0x1D69, 0x1F1F, 0x22C0, 0x27C2, 0x2CFE, 0x30EF, 0x330D, 0x330A, 0x316B, 0x2EBF,
    0x2B1C, 0x26F8, 0x2287, 0x1DBD, 0x18E7, 0x1428, 0x0F46, 0x0928, 0x0201, 0xFA50, 0xF2D8, 0xEC93, 0xE7EB, 0xE4A9, 0xE223, 0xDFE9,
    0xDD52, 0xDABB, 0xD87D, 0xD6E8, 0xD648, 0xD668, 0xD702, 0xD77E, 0xD7C8, 0xD7A5, 0xD775, 0xD7C5, 0xD8A2, 0xDA4A, 0xDCB1, 0xE02E,
    0xE46D, 0xE90C, 0xED7B, 0xF0E7, 0xF26F, 0xF1E6, 0xF01C, 0xEE11, 0xECE7, 0xECE4, 0xEDC5, 0xEF39, 0xF0B6, 0xF2B0, 0xF5FE, 0xFAE9,
    0x00AC, 0x0643, 0x0A97, 0x0D5A, 0x0F78, 0x1236, 0x15EB, 0x18BF, 0x1A39, 0x1A8F, 0x1AA4, 0x1BF5, 0x1F16, 0x23E8, 0x2930, 0x2DC8,
    0x30AC, 0x3208, 0x3220, 0x30BB, 0x2E35, 0x2AB7, 0x26BB, 0x22A8, 0x1EAA, 0x1AB3, 0x15FD, 0x107A, 0x09C1, 0x026E, 0xFABA, 0xF3EB,
    0xEE9C, 0xEA4C, 0xE6F3, 0xE3F9, 0xE147, 0xDE62, 0xDBA3, 0xD98F, 0xD852, 0xD7AE, 0xD7C4, 0xD8B6, 0xD97E, 0xD962, 0xD869, 0xD721,
    0xD6BE, 0xD84E, 0xDAE1, 0xDD97, 0xE11C, 0xE622, 0xEBD6, 0xF093, 0xF2DC, 0xF2F0, 0xF1D4, 0xF0D7, 0xF00E, 0xEF51, 0xEF4D, 0xEF6B,
    0xEFDC, 0xF207, 0xF59C, 0xF944, 0xFD30, 0x01B0, 0x0529, 0x07A3, 0x0B80, 0x10B5, 0x1569, 0x185F, 0x191E, 0x1995, 0x1A53, 0x1AFB,
    0x1D61, 0x2185, 0x2640, 0x2AB4, 0x2F4D, 0x3318, 0x3491, 0x33D3, 0x31FE, 0x2F4C, 0x2B54, 0x27FE, 0x251D, 0x21A7, 0x1D3B, 0x17AA,
    0x11A6, 0x0B17, 0x03C7, 0xFC38, 0xF50C, 0xEFAE, 0xEBDC, 0xE8C7, 0xE5A6, 0xE1DA, 0xDE3E, 0xDB8F, 0xD9B6, 0xD8A0, 0xD89E, 0xD8C5,
    0xD8DB, 0xD8D0, 0xD8A0, 0xD8A3, 0xD8CA, 0xD93F, 0xDA54, 0xDC7B, 0xE02E, 0xE52A, 0xEAB7, 0xEF90, 0xF2A8, 0xF3EC, 0xF3CA, 0xF2DA,
    0xF1B3, 0xF0EE, 0xF09C, 0xF07C, 0xF0E6, 0xF213, 0xF4F9, 0xF8E1, 0xFD01, 0x00DB, 0x0437, 0x07C5, 0x0BAF, 0x1041, 0x1497, 0x182B,
    0x1A6E, 0x1BA0, 0x1BEE, 0x1CD2, 0x1EAF, 0x21F7, 0x2592, 0x2A4C, 0x2E35, 0x31DD, 0x34BC, 0x3617, 0x34FC, 0x31DF, 0x3073, 0x2B6C,
    0x28F2, 0x28BD, 0x25D0, 0x2059, 0x193B, 0x11FC, 0x09C5, 0x01BB, 0xFABC, 0xF4D8, 0xEF91, 0xEB72, 0xE7D6, 0xE45F, 0xE0CF, 0xDDCA,
    0xDBB5, 0xDA86, 0xD99B, 0xD902, 0xD8E3, 0xD860, 0xD877, 0xD88B, 0xD874, 0xD866, 0xD8AB, 0xDA3E, 0xDD5B, 0xE213, 0xE741, 0xECAC,
    0xF09B, 0xF316, 0xF455, 0xF4D1, 0xF4DE, 0xF465, 0xF362, 0xF253, 0xF202, 0xF2D7, 0xF586, 0xF8CE, 0xFC9F, 0xFF80, 0x030D, 0x0612,
    0x0A3D, 0x0EAB, 0x13FC, 0x17C6, 0x19E8, 0x1CB9, 0x1BC1, 0x1DB6, 0x1F87, 0x205E, 0x25CD, 0x2AB2, 0x2D7B, 0x2DEF, 0x2DE5, 0x2F25,
    0x304F, 0x3150, 0x3055, 0x2F40, 0x2D3E, 0x2D0F, 0x2AA0, 0x2A44, 0x25B6, 0x2158, 0x1ED3, 0x116E, 0x0F19, 0x0CEB, 0x024A, 0xF60E,
    0xEC7E, 0xE69E, 0xE1D1, 0xDEF2, 0xDD7B, 0xDB94, 0xD9BA, 0xD9AF, 0xD91B, 0xD926, 0xD8D2, 0xD8B0, 0xD8E2, 0xD8ED, 0xD800, 0xD93C,
    0xDB71, 0xDF0C, 0xE48C, 0xEA18, 0xEE66, 0xF22C, 0xF3CE, 0xF539, 0xF57F, 0xF4A6, 0xF3B0, 0xF138, 0xF119, 0xF08A, 0xF274, 0xF530,
    0xF777, 0xFAF4, 0xFE84, 0x00D8, 0x05D6, 0x0B91, 0x10D2, 0x149A, 0x1885, 0x1CEC, 0x1AB1, 0x1B4C, 0x1EFD, 0x21BD, 0x22A9, 0x23EA,
    0x24DA, 0x24F1, 0x2701, 0x26D2, 0x2945, 0x2BC8, 0x2BA1, 0x2C6F, 0x2D42, 0x2BB9, 0x2A01, 0x2B2E, 0x2C60, 0x2ADD, 0x25F2, 0x21FB,
    0x1D20, 0x1A9B, 0x1489, 0x0E81, 0x049C, 0xFBB1, 0xF66B, 0xE9DB, 0xE9FC, 0xEA5C, 0xE435, 0xDC71, 0xD725, 0xD5BE, 0xD5E6, 0xD67F,
    0xD753, 0xD78B, 0xD5E7, 0xD700, 0xD826, 0xDB97, 0xE0AA, 0xE56A, 0xEA98, 0xEFF2, 0xF18E, 0xF49D, 0xF5B2, 0xF4BE, 0xF3DF, 0xF1EA,
    0xF10C, 0xEF5D, 0xF066, 0xF2B6, 0xF428, 0xF4DD, 0xF964, 0xFCCD, 0xFE2E, 0x0487, 0x0B57, 0x1010, 0x1511, 0x1830, 0x1884, 0x17D1,
    0x188D, 0x1998, 0x1AC9, 0x1CFA, 0x1ED3, 0x1F76, 0x2029, 0x2214, 0x230F, 0x24CF, 0x26A1, 0x28FF, 0x2995, 0x287C, 0x2A07, 0x2A45,
    0x2B69, 0x2C49, 0x29B3, 0x27C0, 0x2733, 0x2425, 0x2078, 0x1D90, 0x198E, 0x1254, 0x08B6, 0x0177, 0xFC28, 0xF795, 0xF2C0, 0xEC6E,
    0xE555, 0xE087, 0xDC1D, 0xD9A7, 0xD7E6, 0xD60E, 0xD445, 0xD369, 0xD351, 0xD3D5, 0xD5E9, 0xD8DD, 0xDD2D, 0xDFA7, 0xE66C, 0xE8C1,
    0xEAB3, 0xF15E, 0xF19E, 0xEFE1, 0xEDD8, 0xEB60, 0xEAF7, 0xEBC6, 0xEE2B, 0xEFEF, 0xF10C, 0xF58C, 0xFA20, 0xFD6E, 0x00AC, 0x04B7,
    0x089C, 0x0D04, 0x108B, 0x1253, 0x133B, 0x1309, 0x146F, 0x157A, 0x15BC, 0x171F, 0x1850, 0x1926, 0x1ACE, 0x1BEE, 0x1DD3, 0x20CB,
    0x22B2, 0x2370, 0x24DC, 0x275B, 0x2904, 0x2950, 0x2991, 0x29E1, 0x288E, 0x26F3, 0x25D4, 0x2507, 0x232F, 0x1FAC, 0x1A4C, 0x146F,
    0x0ED9, 0x0997, 0x052A, 0x000E, 0xFAD7, 0xF482, 0xEF76, 0xEB03, 0xE61F, 0xE37D, 0xE077, 0xDD45, 0xDBFE, 0xDAD4, 0xD9A7, 0xD9F0,
    0xDBC0, 0xDDDD, 0xDF62, 0xE1F0, 0xE558, 0xE8E8, 0xEC8E, 0xEF23, 0xEF5F, 0xEE5A, 0xEDD1, 0xED6D, 0xECF9, 0xEC8C, 0xED06, 0xEEF3,
    0xF172, 0xF442, 0xF6D3, 0xF947, 0xFC76, 0xFFE5, 0x02BD, 0x055E, 0x0779, 0x0917, 0x0AC9, 0x0BD6, 0x0C69, 0x0D4D, 0x0E9C, 0x0FB4,
    0x1048, 0x1181, 0x137E, 0x15B9, 0x17C9, 0x1984, 0x1B76, 0x1D65, 0x1F33, 0x20C5, 0x2278, 0x2349, 0x2328, 0x224E, 0x2109, 0x1FA7,
    0x1E34, 0x1D42, 0x1BAC, 0x190A, 0x1769, 0x16FE, 0x1467, 0x1001, 0x0BB0, 0x069D, 0x0100, 0xFBA2, 0xF626, 0xF0D7, 0xEC06, 0xE806,
    0xE490, 0xE158, 0xDF35, 0xDDE9, 0xDD29, 0xDCEC, 0xDD1F, 0xDE01, 0xDF6A, 0xE21D, 0xE5CA, 0xE90D, 0xEBD3, 0xEE0D, 0xEEEC, 0xEECC,
    0xEE5C, 0xEDB1, 0xED06, 0xED2A, 0xEDF1, 0xEF36, 0xF0CD, 0xF264, 0xF433, 0xF63B, 0xF87A, 0xFAB3, 0xFCEC, 0xFF53, 0x0130, 0x025D,
    0x0382, 0x04BF, 0x0621, 0x0752, 0x0858, 0x0974, 0x0ACC, 0x0C7B, 0x0E52, 0x1080, 0x12F8, 0x14FA, 0x16DF, 0x188D, 0x1A00, 0x1BA6,
    0x1D59, 0x1E6B, 0x1F17, 0x1FCA, 0x2031, 0x203A, 0x2036, 0x1F97, 0x1DDC, 0x1B4F, 0x1885, 0x15A0, 0x122F, 0x0E5F, 0x0A77, 0x062D,
    0x01AD, 0xFC8A, 0xF758, 0xF281, 0xEE00, 0xEA72, 0xE76F, 0xE4BB, 0xE2C7, 0xE147, 0xE075, 0xE02D, 0xE05C, 0xE13A, 0xE2F7, 0xE5AC,
    0xE887, 0xEB31, 0xED74, 0xEF41, 0xF08B, 0xF0F6, 0xF0CD, 0xF06C, 0xF052, 0xF103, 0xF1ED, 0xF2CC, 0xF3BA, 0xF4B5, 0xF5CA, 0xF70E,
    0xF8D4, 0xFADA, 0xFCAC, 0xFE81, 0x0057, 0x01F9, 0x0328, 0x03F9, 0x04F9, 0x05CD, 0x0641, 0x06F2, 0x081F, 0x09B5, 0x0B9C, 0x0D86,
    0x0F33, 0x1098, 0x11FC, 0x13A3, 0x156A, 0x16E9, 0x184F, 0x1938, 0x1A06, 0x1ADC, 0x1B78, 0x1C01, 0x1C16, 0x1BC5, 0x1AE0, 0x1953,
    0x174C, 0x14D8, 0x1212, 0x0EEC, 0x0B29, 0x06DA, 0x01D0, 0xFC85, 0xF782, 0xF362, 0xEF9D, 0xEC45, 0xE9AA, 0xE762, 0xE568, 0xE3BD,
    0xE302, 0xE2D4, 0xE334, 0xE425, 0xE58B, 0xE755, 0xE976, 0xEBAB, 0xED95, 0xEEF3, 0xEFC3, 0xF03F, 0xF09B, 0xF158, 0xF20D, 0xF2D6,
    0xF3A6, 0xF43E, 0xF497, 0xF525, 0xF5EC, 0xF69D, 0xF798, 0xF8E4, 0xFA1B, 0xFB35, 0xFC70, 0xFDB0, 0xFEFF, 0x0037, 0x0164, 0x0242,
    0x030F, 0x0447, 0x05CC, 0x0767, 0x08AC, 0x09C1, 0x0AD6, 0x0BF8, 0x0D1F, 0x0EAF, 0x1069, 0x121B, 0x13A6, 0x14E7, 0x1606, 0x1714,
    0x1807, 0x18B2, 0x1912, 0x1945, 0x18FD, 0x186B, 0x17A9, 0x1689, 0x14B8, 0x11F9, 0x0E86, 0x0A46, 0x05D3, 0x01A6, 0xFDC2, 0xFA25,
    0xF688, 0xF32D, 0xEFE7, 0xED4A, 0xEB5F, 0xE9E7, 0xE90D, 0xE8BE, 0xE8B4, 0xE94C, 0xEA41, 0xEB86, 0xED03, 0xEE31, 0xEF3F, 0xF02B,
    0xF14E, 0xF2AF, 0xF44B, 0xF537, 0xF4D6, 0xF472, 0xF4AC, 0xF4B0, 0xF4CD, 0xF515, 0xF591, 0xF656, 0xF72B, 0xF7BD, 0xF82E, 0xF833,
    0xF843, 0xF8B1, 0xFA3A, 0xFC5C, 0xFDB2, 0xFEEA, 0x001D, 0x016C, 0x028B, 0x0387, 0x043B, 0x0497, 0x04F4, 0x05D3, 0x06D9, 0x0860,
    0x0A06, 0x0BE4, 0x0D9E, 0x0F81, 0x111A, 0x11BE, 0x1255, 0x1253, 0x12AE, 0x12AA, 0x1319, 0x1389, 0x137B, 0x12E3, 0x11B3, 0x0FF7,
    0x0D71, 0x0B04, 0x08F4, 0x0683, 0x038A, 0x00C8, 0xFE8C, 0xFC2E, 0xFAAF, 0xF994, 0xFAF3, 0xF611, 0xF621, 0x028F, 0x03B5, 0x016D,
    0x0256, 0x046B, 0x0073, 0xFF10, 0xFAC3, 0xF340, 0xEDE7, 0xEAE3, 0xEB1D, 0xDC29, 0xD336, 0xD545, 0xD5F3, 0xC780, 0xBDFA, 0xC3B0,
    0xC38A, 0xC78E, 0xCA65, 0xC89E, 0xCDF7, 0xD6F7, 0xD7C4, 0xD7B2, 0xDB43, 0xDC7F, 0xDDF7, 0xE17B, 0xE747, 0xE4A0, 0xE19B, 0xE02C,
    0xE257, 0xE27D, 0xE483, 0xEC14, 0xE484, 0xF28A, 0x0104, 0xFE80, 0xFC22, 0xFBE4, 0xFF2D, 0xFDE3, 0x01D6, 0x0599, 0x0D4F, 0x12AF,
    0x199D, 0x1F75, 0x2226, 0x24DF, 0x2621, 0x3766, 0x3ADA, 0x2DAE, 0x3265, 0x4531, 0x493E, 0x4982, 0x474B, 0x3C3D, 0x3CD0, 0x39F0,
    0x3219, 0x2350, 0x19A9, 0x1644, 0x124C, 0x04F3, 0xF651, 0xF75D, 0xEF14, 0xE612, 0xDFA8, 0xD946, 0xD8BF, 0xDC76, 0xDD5A, 0xDB30,
    0xDCA5, 0xE03C, 0xE076, 0xDCDB, 0xE1EE, 0xDFE3, 0xDE11, 0xE147, 0xE3B8, 0xE14C, 0xD83C, 0xDA66, 0xD5CD, 0xD5B5, 0xDC4D, 0xDAFF,
    0xD955, 0xE133, 0xEFA9, 0xF39B, 0xF289, 0xEF80, 0xF049, 0xEF06, 0xEF0E, 0xF1A3, 0xF436, 0xFB4F, 0xFC59, 0x062B, 0x0E8C, 0x0840,
    0x0B96, 0x2376, 0x2A9C, 0x2314, 0x27DE, 0x2FEE, 0x3E6C, 0x482C, 0x4986, 0x448C, 0x4361, 0x42DE, 0x3EC9, 0x343F, 0x23F6, 0x240D,
    0x205C, 0x11C3, 0x069E, 0xFF68, 0xF91A, 0xF3E3, 0xEC71, 0xE4B0, 0xE2AC, 0xE59E, 0xE9C7, 0xE607, 0xE98B, 0xEDCB, 0xED32, 0xEA8F,
    0xE933, 0xE84F, 0xE0BA, 0xE6F5, 0xEC74, 0xEAED, 0xEBC6, 0xE9E1, 0xE423, 0xE258, 0xE762, 0xE4CD, 0xE07D, 0xE215, 0xECB8, 0xF47D,
    0xF517, 0xF415, 0xF043, 0xF1BD, 0xF0B8, 0xF10D, 0xF6B0, 0xF6B2, 0xF3B9, 0x035F, 0x0BB5, 0x014F, 0x05DB, 0x1550, 0x2108, 0x21FE,
    0x1FFE, 0x20A0, 0x2BCF, 0x38AD, 0x3F4C, 0x4188, 0x3D92, 0x412E, 0x437E, 0x39C5, 0x2FEE, 0x2D46, 0x2896, 0x20CB, 0x16A8, 0x0CC8,
    0x07A5, 0x0221, 0xFD3F, 0xF13E, 0xEA02, 0xEA34, 0xEA5E, 0xE9B6, 0xEB16, 0xF22A, 0xEFE6, 0xF083, 0xF39F, 0xEDE0, 0xE857, 0xEA5B,
    0xEC92, 0xED58, 0xF32F, 0xF28F, 0xEEB7, 0xECD0, 0xF183, 0xF2C6, 0xEC77, 0xECDE, 0xF1D6, 0xFC2F, 0x031C, 0x02E7, 0x03FE, 0x0638,
    0xFE85, 0xFF96, 0x0500, 0xFADB, 0xF8A0, 0x0696, 0x1004, 0x0CF2, 0x0F10, 0x18F4, 0x284A, 0x31B2, 0x307C, 0x3097, 0x326D, 0x3A07,
    0x4431, 0x4304, 0x3ACF, 0x3D64, 0x4095, 0x3B70, 0x343A, 0x2EF9, 0x2CA4, 0x2735, 0x20F0, 0x1746, 0x10D0, 0x0EEF, 0x0AC0, 0x0203,
    0xF842, 0xF650, 0xF2FD, 0xF003, 0xF3F0, 0xF6FC, 0xF585, 0xF869, 0xFB1E, 0xF546, 0xF26C, 0xF024, 0xEEBD, 0xEF0E, 0xF435, 0xF83A,
    0xF2E2, 0xF0D0, 0xF331, 0xF43D, 0xF10F, 0xEBC3, 0xEAC5, 0xF589, 0xFA89, 0xFCEF, 0x0683, 0x0500, 0xFF1E, 0x04EB, 0x0921, 0xFF69,
    0xFB57, 0x0268, 0x0B27, 0x0D7A, 0x08CF, 0x0AB8, 0x1453, 0x1CD8, 0x2198, 0x2061, 0x1C80, 0x25F8, 0x32BD, 0x3779, 0x3A65, 0x3F9F,
    0x462C, 0x4466, 0x3F0D, 0x385B, 0x33DF, 0x317C, 0x2B81, 0x2293, 0x1886, 0x159A, 0x11EE, 0x0815, 0x0053, 0xFB7D, 0xF413, 0xF0DA,
    0xF477, 0xF452, 0xF61A, 0xFA1F, 0xFD02, 0xFBB0, 0xF9B7, 0xF915, 0xF4B7, 0xF307, 0xF7B4, 0xFAAC, 0xF71F, 0xF451, 0xF1E3, 0xF59C,
    0xF433, 0xE9EC, 0xEA04, 0xEEF0, 0xEF4B, 0xF67A, 0x01FC, 0xFF0F, 0xFB26, 0x015A, 0x05A0, 0x0142, 0xF9B5, 0xFA71, 0x0461, 0x0953,
    0x0718, 0x07D9, 0x0A0E, 0x14A9, 0x1FD5, 0x1FB2, 0x1CB9, 0x208C, 0x2B6D, 0x30AB, 0x33F4, 0x38F6, 0x3E96, 0x41C2, 0x3E71, 0x38B5,
    0x31DB, 0x2F3B, 0x2BFD, 0x21BA, 0x16AF, 0x1201, 0x0C5D, 0x03E0, 0xFF95, 0xF817, 0xEF83, 0xEB5F, 0xEAEF, 0xE966, 0xE8F0, 0xECC8,
    0xEF2F, 0xEE94, 0xF01D, 0xF11A, 0xEBCC, 0xEA87, 0xEBE5, 0xF040, 0xF2C6, 0xEC80, 0xEB5F, 0xF1DF, 0xF042, 0xE8D3, 0xE9AF, 0xE6EE,
    0xE2DC, 0xEAE1, 0xF466, 0xF504, 0xF28E, 0xF54D, 0xFCF7, 0xFDCA, 0xF520, 0xF33C, 0xF746, 0xFD19, 0x00F0, 0xFE16, 0xFC64, 0x03F8,
    0x11B4, 0x164F, 0x14F7, 0x1755, 0x1ED7, 0x2694, 0x2AFB, 0x30CD, 0x37F6, 0x3F40, 0x4264, 0x3F08, 0x3839, 0x3694, 0x33EC, 0x2921,
    0x200E, 0x17C4, 0x0E95, 0x06DA, 0x015D, 0xF9A9, 0xEFDD, 0xE984, 0xE627, 0xE1A1, 0xDFDA, 0xE357, 0xE3B9, 0xE583, 0xE8D9, 0xE9D3,
    0xE907, 0xE49D, 0xE1E6, 0xE761, 0xEA50, 0xE3C8, 0xE50B, 0xEA42, 0xE858, 0xE7E8, 0xE95B, 0xE42F, 0xDEEE, 0xE269, 0xEBB6, 0xF1C8,
    0xEEC8, 0xF16E, 0xF9AB, 0xFBD8, 0xF7E6, 0xF1EC, 0xEF99, 0xF35E, 0xFA1B, 0xF89F, 0xF32D, 0xF6DF, 0x0285, 0x0B58, 0x0CC0, 0x0DEA,
    0x129A, 0x18E9, 0x1E03, 0x2317, 0x286A, 0x3260, 0x3C0E, 0x3AC2, 0x3783, 0x3729, 0x34B5, 0x2E47, 0x2789, 0x1F8B, 0x167F, 0x0FAF,
    0x0B95, 0x0424, 0xF980, 0xF2B2, 0xEA7A, 0xE25F, 0xDEC9, 0xDD2A, 0xDC97, 0xDD3C, 0xDE00, 0xE113, 0xE2FF, 0xDB81, 0xD827, 0xDDDC,
    0xDE23, 0xDAC1, 0xDDBE, 0xE018, 0xDFC8, 0xE2D3, 0xE4E7, 0xE2EE, 0xDA9C, 0xD8B6, 0xE186, 0xE78C, 0xE849, 0xEA6A, 0xF187, 0xF7EC,
    0xFA42, 0xF620, 0xEFDC, 0xF1BC, 0xF98B, 0xFBC6, 0xF6DD, 0xF5B9, 0xFCF5, 0x060C, 0x0946, 0x0B0B, 0x0CE7, 0x10F9, 0x17E9, 0x1A7D,
    0x1E16, 0x2934, 0x346E, 0x380D, 0x38FF, 0x394D, 0x37BD, 0x346D, 0x3082, 0x29D6, 0x1EC1, 0x1836, 0x138C, 0x0B95, 0x0437, 0xFD2D,
    0xF3D4, 0xEBDD, 0xE621, 0xE282, 0xE2F5, 0xE0D1, 0xDF5B, 0xE50A, 0xE70F, 0xDEE5, 0xDB52, 0xDC91, 0xDA4D, 0xD93C, 0xD931, 0xD9B7,
    0xD827, 0xD8A0, 0xDDEE, 0xDDB4, 0xD61F, 0xD128, 0xD572, 0xDAE2, 0xDD93, 0xDFD2, 0xE364, 0xEAAD, 0xF1B6, 0xF106, 0xEA20, 0xE885,
    0xEEAE, 0xF464, 0xF1BB, 0xEE96, 0xF274, 0xF98B, 0x01A6, 0x05D5, 0x0705, 0x0CBD, 0x1443, 0x15A6, 0x1777, 0x1F42, 0x2969, 0x3003,
    0x336F, 0x3600, 0x348C, 0x3373, 0x3312, 0x2D62, 0x2496, 0x1E24, 0x173D, 0x1041, 0x0A66, 0x02D0, 0xFBBF, 0xF3B9, 0xEA26, 0xE5FE,
    0xE545, 0xDF3A, 0xDD61, 0xE40F, 0xE6AC, 0xE479, 0xE256, 0xE26F, 0xE1E3, 0xE0A3, 0xE206, 0xE246, 0xDE91, 0xDD1E, 0xE2C1, 0xE541,
    0xDF61, 0xD86C, 0xD667, 0xD8B4, 0xDBA6, 0xDC56, 0xDBF1, 0xE1B4, 0xEB2C, 0xEFB9, 0xEB1E, 0xE6DB, 0xEAF6, 0xF06A, 0xF156, 0xEF32,
    0xED1D, 0xF0EF, 0xF9FD, 0xFE2F, 0xFFDA, 0x05A0, 0x0D40, 0x1010, 0x10C1, 0x1701, 0x1F94, 0x2832, 0x3150, 0x36B1, 0x3724, 0x391D,
    0x3A0C, 0x35D6, 0x2FB5, 0x275C, 0x1EDA, 0x17DB, 0x0FB3, 0x0840, 0x0415, 0xFA6F, 0xEEE2, 0xEB4F, 0xE76B, 0xE055, 0xDD3C, 0xE0B5,
    0xE4C1, 0xE553, 0xE4F2, 0xE52C, 0xE3C7, 0xE1F8, 0xE475, 0xE5C1, 0xE1DD, 0xDF8E, 0xE43D, 0xE9BF, 0xE93A, 0xE46E, 0xDEB2, 0xDE39,
    0xE101, 0xE1B6, 0xDF5A, 0xE023, 0xE95A, 0xF0CB, 0xEEC8, 0xEA53, 0xE982, 0xEC34, 0xEFE7, 0xEE08, 0xE942, 0xEA4B, 0xF10D, 0xF591,
    0xF767, 0xFD87, 0x0591, 0x097E, 0x0B7A, 0x0FA8, 0x1419, 0x1CC5, 0x27E9, 0x2E89, 0x32E8, 0x36F8, 0x3954, 0x39D6, 0x378E, 0x310C,
    0x2C09, 0x25EC, 0x1C0B, 0x1711, 0x12A8, 0x083B, 0xFD60, 0xF734, 0xF0E9, 0xE7B6, 0xE0F0, 0xE03F, 0xE23C, 0xE31B, 0xE4BF, 0xE5D0,
    0xE3C5, 0xE195, 0xE46A, 0xE704, 0xE457, 0xE180, 0xE2A8, 0xE85E, 0xEC52, 0xEA77, 0xE4FE, 0xE17D, 0xE407, 0xE686, 0xE35B, 0xE219,
    0xE93E, 0xF1DA, 0xF5E7, 0xF43E, 0xF0C3, 0xF19D, 0xF5EF, 0xF5E1, 0xF01E, 0xED91, 0xF12D, 0xF3A4, 0xF3DF, 0xF8A1, 0xFE1B, 0x0259,
    0x06E3, 0x0886, 0x09FB, 0x10D5, 0x1AC3, 0x235C, 0x2AC3, 0x2F2C, 0x33A0, 0x3830, 0x369D, 0x33DF, 0x318B, 0x2A16, 0x20C1, 0x1C45,
    0x186B, 0x0FE3, 0x0602, 0xFF99, 0xFA0A, 0xF118, 0xE85E, 0xE451, 0xE324, 0xE292, 0xE4DE, 0xE6E1, 0xE3EC, 0xE011, 0xE06E, 0xE2E9,
    0xE1F5, 0xDE53, 0xDC57, 0xDF50, 0xE510, 0xE80E, 0xE420, 0xDF15, 0xE0E9, 0xE337, 0xE0E1, 0xDE03, 0xE01A, 0xE81A, 0xF0BD, 0xF356,
    0xF066, 0xF054, 0xF5FF, 0xF940, 0xF587, 0xF3BB, 0xF57E, 0xF626, 0xF7AF, 0xFB05, 0xFE52, 0x0390, 0x0908, 0x09EB, 0x0A8E, 0x0D17,
    0x12A2, 0x1C35, 0x2330, 0x281A, 0x2F49, 0x349A, 0x3592, 0x370C, 0x377E, 0x3207, 0x2A08, 0x24DA, 0x211D, 0x19BA, 0x109B, 0x09C9,
    0x03EF, 0xFB17, 0xF1D6, 0xEB80, 0xE6AB, 0xE440, 0xE65E, 0xE977, 0xE902, 0xE65E, 0xE60E, 0xE92C, 0xEAA2, 0xE880, 0xE3D5, 0xE18A,
    0xE6AE, 0xEBB0, 0xE978, 0xE47B, 0xE33F, 0xE483, 0xE396, 0xDF98, 0xDC7B, 0xDFE1, 0xE937, 0xEFBD, 0xEE62, 0xEDD0, 0xF328, 0xF61A,
    0xF478, 0xF3BB, 0xF2FC, 0xF2A6, 0xF49A, 0xF5AA, 0xF822, 0xFEB1, 0x0533, 0x0A63, 0x0CAC, 0x0CCC, 0x1169, 0x1A02, 0x1FEF, 0x2615,
    0x2DED, 0x3305, 0x355A, 0x3827, 0x3A05, 0x3631, 0x2E95, 0x284A, 0x240D, 0x1D65, 0x14BC, 0x0E65, 0x0889, 0x0054, 0xF818, 0xF097,
    0xE928, 0xE39B, 0xE2A4, 0xE5DE, 0xE731, 0xE582, 0xE45A, 0xE585, 0xE932, 0xEA8A, 0xE610, 0xE1B3, 0xE4D2, 0xEB46, 0xEDAB, 0xEBE4,
    0xEA2C, 0xEB39, 0xEC10, 0xE97F, 0xE314, 0xE07B, 0xE77C, 0xEE93, 0xEE9E, 0xEECC, 0xF205, 0xF41C, 0xF5B7, 0xF591, 0xF34C, 0xF373,
    0xF457, 0xF462, 0xF625, 0xF929, 0xFF06, 0x06B5, 0x09A2, 0x095D, 0x0CA9, 0x12C0, 0x181F, 0x1F32, 0x286C, 0x2F82, 0x3449, 0x39BE,
    0x3F24, 0x3FF3, 0x3B59, 0x36EC, 0x334F, 0x2CB8, 0x24C2, 0x1E00, 0x16D1, 0x0E42, 0x055D, 0xFC84, 0xF248, 0xE89A, 0xE3DC, 0xE3DF,
    0xE526, 0xE541, 0xE363, 0xE2A3, 0xE6BD, 0xEAAC, 0xE85F, 0xE36A, 0xE2F9, 0xE79C, 0xEB85, 0xEC23, 0xEA57, 0xE9A0, 0xECBA, 0xED82,
    0xE6CD, 0xE164, 0xE5C7, 0xEC36, 0xEF8E, 0xF22A, 0xF3FC, 0xF73A, 0xFA54, 0xFA09, 0xF8A8, 0xF77E, 0xF64D, 0xF689, 0xF5C4, 0xF46B,
    0xF840, 0xFFC6, 0x03A5, 0x04BE, 0x078E, 0x0B4B, 0x0EE3, 0x14FF, 0x1DF2, 0x2582, 0x2A25, 0x3028, 0x385A, 0x3C90, 0x3BEC, 0x3A4B,
    0x3809, 0x339C, 0x2DAD, 0x2814, 0x2222, 0x1AE0, 0x1416, 0x0D5F, 0x0399, 0xF89B, 0xF004, 0xEB74, 0xEB26, 0xEB24, 0xE77B, 0xE371,
    0xE4DE, 0xE916, 0xE8E9, 0xE459, 0xE0F1, 0xE1EB, 0xE630, 0xE9EE, 0xE8E7, 0xE714, 0xEB81, 0xEEC5, 0xE9FB, 0xE4AA, 0xE3B4, 0xE6C7,
    0xEB9E, 0xEE06, 0xEF9F, 0xF399, 0xF78B, 0xFA25, 0xFB9A, 0xFAF8, 0xFAE9, 0xFC83, 0xFB1F, 0xF7A0, 0xF8AE, 0xFDFD, 0x01EF, 0x0407,
    0x066D, 0x0878, 0x097B, 0x0C68, 0x1370, 0x1A64, 0x1EBF, 0x24E4, 0x2D4D, 0x3431, 0x3774, 0x386F, 0x3805, 0x34BC, 0x2FA2, 0x2A97,
    0x2477, 0x1D5D, 0x1775, 0x11D2, 0x0A85, 0x0110, 0xF696, 0xEEC6, 0xECE7, 0xEE0A, 0xEC26, 0xE7F8, 0xE77A, 0xEBA6, 0xEE7B, 0xED18,
    0xE8DC, 0xE521, 0xE713, 0xEABA, 0xE85F, 0xE593, 0xE860, 0xEB7C, 0xEA4A, 0xE5B4, 0xE187, 0xE236, 0xE5B2, 0xE85D, 0xEB50, 0xEEB2,
    0xF2CA, 0xF801, 0xFB03, 0xFAAD, 0xFB5B, 0xFDF2, 0xFD53, 0xF9C8, 0xF898, 0xFB8A, 0xFFB6, 0x0345, 0x07B3, 0x0B33, 0x0B6E, 0x0D10,
    0x127E, 0x1807, 0x1BE5, 0x20B2, 0x2813, 0x2F10, 0x3396, 0x36FE, 0x3842, 0x363F, 0x32DF, 0x2EFF, 0x296F, 0x22F9, 0x1CED, 0x1781,
    0x122B, 0x0ACC, 0xFF60, 0xF3A5, 0xED95, 0xECDE, 0xEB02, 0xE6AF, 0xE469, 0xE5C3, 0xE9A2, 0xECC3, 0xEA1F, 0xE57C, 0xE74D, 0xEB43,
    0xEB54, 0xEA4B, 0xEB5B, 0xEF62, 0xF202, 0xEEB0, 0xE925, 0xE616, 0xE574, 0xE6A5, 0xE83E, 0xE90C, 0xEB90, 0xF128, 0xF4E8, 0xF548,
    0xF67D, 0xF990, 0xFADB, 0xF868, 0xF64C, 0xF779, 0xF9C3, 0xFD19, 0x02AB, 0x071A, 0x0815, 0x08D0, 0x0CFB, 0x12B1, 0x1710, 0x1C32,
    0x23D2, 0x2BD7, 0x32F7, 0x3935, 0x3C81, 0x3CEB, 0x3B95, 0x38B3, 0x342A, 0x2E04, 0x26EA, 0x1FFF, 0x1AD8, 0x1582, 0x0B42, 0xFD4B,
    0xF363, 0xEF59, 0xEC90, 0xE952, 0xE510, 0xE208, 0xE510, 0xE9A4, 0xE846, 0xE46D, 0xE3E3, 0xE65E, 0xE806, 0xE6F0, 0xE697, 0xEAA5,
    0xEF7E, 0xF081, 0xEE61, 0xEAE7, 0xE86D, 0xE97E, 0xEB49, 0xEB20, 0xEC5A, 0xF112, 0xF4F6, 0xF58D, 0xF5BE, 0xF81B, 0xF970, 0xF767,
    0xF50D, 0xF3B5, 0xF2C8, 0xF3F1, 0xF8BE, 0xFE2B, 0x0097, 0x016F, 0x04FA, 0x09C9, 0x0DDA, 0x12B1, 0x18E3, 0x2003, 0x27DB, 0x3012,
    0x366B, 0x3A61, 0x3C60, 0x3C92, 0x3B70, 0x38A7, 0x3344, 0x2C3C, 0x2767, 0x2488, 0x1CFC, 0x1069, 0x0460, 0xFAC4, 0xF554, 0xF1B5,
    0xEAB6, 0xE3DC, 0xE393, 0xE6DB, 0xE789, 0xE4C0, 0xE250, 0xE390, 0xE59A, 0xE4C5, 0xE38E, 0xE56A, 0xE93A, 0xECBA, 0xEDCF, 0xEAFD,
    0xE7D4, 0xE7E4, 0xE8DE, 0xE867, 0xE8C0, 0xECE5, 0xF249, 0xF50A, 0xF742, 0xFB4C, 0xFE8B, 0xFF3F, 0xFE82, 0xFD31, 0xFA6B, 0xF80E,
    0xF9CB, 0xFDD3, 0xFFB7, 0x0008, 0x01B7, 0x0459, 0x06FE, 0x0A4F, 0x0E6B, 0x1399, 0x1AA1, 0x231B, 0x2BBF, 0x32AE, 0x3764, 0x39B3,
    0x3AAE, 0x3AEE, 0x3765, 0x3060, 0x2BBF, 0x29AC, 0x25B5, 0x1E8E, 0x13BF, 0x0875, 0x025E, 0xFECC, 0xF7FC, 0xEFD4, 0xEB8A, 0xEC80,
    0xEDFF, 0xEBB8, 0xE823, 0xE795, 0xE84C, 0xE717, 0xE4F8, 0xE3CA, 0xE509, 0xE919, 0xEC7A, 0xEC08, 0xE978, 0xE8B7, 0xE931, 0xE7C3,
    0xE674, 0xE8E5, 0xED75, 0xF072, 0xF2E2, 0xF6EF, 0xFB1A, 0xFD93, 0xFF2A, 0xFFE4, 0xFDB5, 0xFA8A, 0xFB02, 0xFE58, 0x0142, 0x0381,
    0x0598, 0x07CB, 0x0A23, 0x0C83, 0x0EDE, 0x11B3, 0x15FA, 0x1BFF, 0x233A, 0x2AEA, 0x30B9, 0x337D, 0x365E, 0x3957, 0x37A1, 0x3288,
    0x2DBB, 0x2A21, 0x284E, 0x251D, 0x1C1F, 0x104B, 0x07D9, 0x0299, 0xFC84, 0xF47E, 0xEDBB, 0xEC5A, 0xEE7E, 0xEE6F, 0xECB4, 0xEC3B,
    0xECB0, 0xED09, 0xEBCA, 0xE922, 0xE7FA, 0xEAB3, 0xEF16, 0xF02B, 0xEDFF, 0xEC90, 0xEC0F, 0xE9B0, 0xE6AE, 0xE643, 0xE8BA, 0xEB79,
    0xEDB8, 0xF120, 0xF4E3, 0xF7C7, 0xFB3F, 0xFE38, 0xFD95, 0xFA64, 0xF8BC, 0xF9EB, 0xFC86, 0xFF19, 0x015F, 0x03AC, 0x064D, 0x09A6,
    0x0CAC, 0x0F8C, 0x13AF, 0x1876, 0x1F1B, 0x2894, 0x3005, 0x3421, 0x38A2, 0x3C93, 0x3D01, 0x3A0B, 0x3443, 0x2E5F, 0x2BC0, 0x29FB,
    0x238D, 0x1878, 0x0DDF, 0x0741, 0x01F4, 0xF93A, 0xEF9D, 0xEAA3, 0xEA23, 0xEA22, 0xE8E7, 0xE750, 0xE6DC, 0xE7AD, 0xE823, 0xE678,
    0xE431, 0xE5CE, 0xEADF, 0xEE5B, 0xEEDF, 0xEEF5, 0xEF99, 0xEE7E, 0xEBB5, 0xEA62, 0xEB18, 0xEBE1, 0xECA6, 0xEE93, 0xF0DE, 0xF29E,
    0xF597, 0xF966, 0xFAC9, 0xF904, 0xF620, 0xF4F0, 0xF5D1, 0xF7CF, 0xFA2C, 0xFC0E, 0xFED7, 0x01F6, 0x0462, 0x07F4, 0x0B85, 0x0E08,
    0x1379, 0x1CB0, 0x252B, 0x2BF2, 0x3273, 0x389D, 0x3E04, 0x4043, 0x3D71, 0x3835, 0x3559, 0x34D6, 0x3224, 0x296B, 0x1DEF, 0x1550,
    0x0E9D, 0x0575, 0xFA67, 0xF146, 0xEC2C, 0xE9EA, 0xE84A, 0xE63B, 0xE480, 0xE4B2, 0xE5F6, 0xE4E0, 0xE1B9, 0xE0CE, 0xE3D4, 0xE734,
    0xE8B9, 0xE9DD, 0xEBAD, 0xEC19, 0xEA7A, 0xE96B, 0xE948, 0xE954, 0xEAA4, 0xED62, 0xEFEC, 0xF213, 0xF520, 0xF96D, 0xFCD0, 0xFD42,
    0xFB5B, 0xF8A4, 0xF6F3, 0xF704, 0xF74E, 0xF82A, 0xFA54, 0xFBE3, 0xFDA6, 0x0151, 0x03C4, 0x0514, 0x08BA, 0x0F63, 0x177F, 0x1FA3,
    0x26C1, 0x2D72, 0x353C, 0x3B81, 0x3CAA, 0x390F, 0x352A, 0x34DE, 0x356E, 0x30E2, 0x2816, 0x200E, 0x19F5, 0x131C, 0x09CA, 0xFFDE,
    0xF7D1, 0xF2FA, 0xF036, 0xECBB, 0xE8BD, 0xE72D, 0xE7C8, 0xE6FD, 0xE380, 0xE039, 0xE077, 0xE266, 0xE384, 0xE4A0, 0xE69C, 0xE798,
    0xE6C5, 0xE5DB, 0xE4CD, 0xE354, 0xE2CA, 0xE43E, 0xE681, 0xE836, 0xEAE0, 0xEF5E, 0xF495, 0xF91D, 0xFAC0, 0xF984, 0xF8DC, 0xF88B,
    0xF7E2, 0xF8E9, 0xFAA1, 0xFB68, 0xFD1E, 0x0054, 0x0231, 0x028F, 0x0356, 0x0614, 0x0BE0, 0x12F2, 0x1926, 0x1F41, 0x2724, 0x2FF5,
    0x361F, 0x3608, 0x329C, 0x31E1, 0x338A, 0x328A, 0x2D04, 0x2630, 0x2050, 0x1A4B, 0x12AE, 0x0973, 0x000C, 0xF959, 0xF5F4, 0xF2F2,
    0xEF56, 0xED48, 0xEE24, 0xEF7C, 0xEDBF, 0xEA41, 0xE88D, 0xE86D, 0xE858, 0xE8ED, 0xEA2F, 0xEAA4, 0xEA0D, 0xE8FE, 0xE786, 0xE4F8,
    0xE2B3, 0xE27D, 0xE362, 0xE443, 0xE5EF, 0xE8D7, 0xEDB8, 0xF351, 0xF5EE, 0xF650, 0xF637, 0xF549, 0xF44C, 0xF565, 0xF6AD, 0xF740,
    0xF93C, 0xFC66, 0xFF69, 0x0129, 0x016D, 0x026C, 0x065A, 0x0CC8, 0x135F, 0x1886, 0x1E53, 0x276F, 0x309A, 0x33F5, 0x31B8, 0x2FAB,
    0x3065, 0x30B1, 0x2D45, 0x2786, 0x2174, 0x1C06, 0x15FA, 0x0D7C, 0x038A, 0xFAF5, 0xF5BC, 0xF1E0, 0xED44, 0xE966, 0xE8F7, 0xEA9D,
    0xEA69, 0xE8A4, 0xE72D, 0xE6B0, 0xE707, 0xE89B, 0xEB1A, 0xED2B, 0xEE59, 0xEF27, 0xEF3B, 0xED4D, 0xEAB5, 0xE8CF, 0xE7DB, 0xE7BD,
    0xE72E, 0xE74B, 0xEA62, 0xEEFB, 0xF25D, 0xF4E7, 0xF5EA, 0xF4BA, 0xF3AF, 0xF419, 0xF4AF, 0xF4F4, 0xF565, 0xF72D, 0xFAD8, 0xFE48,
    0xFFC0, 0x001C, 0x01F9, 0x073E, 0x0E46, 0x13C8, 0x189A, 0x20FB, 0x2C2F, 0x342D, 0x3636, 0x354B, 0x3558, 0x3619, 0x3533, 0x3114,
    0x2ACC, 0x24C4, 0x1F48, 0x17FC, 0x0E3B, 0x03C8, 0xFBDA, 0xF661, 0xF054, 0xEA45, 0xE76F, 0xE79B, 0xE7C5, 0xE703, 0xE5C0, 0xE468,
    0xE34F, 0xE37B, 0xE556, 0xE72F, 0xE906, 0xEB1E, 0xEC79, 0xECDB, 0xEC3B, 0xEAE3, 0xEAB5, 0xEBB1, 0xEB3D, 0xEA8B, 0xEC9A, 0xF040,
    0xF435, 0xF852, 0xFABB, 0xFA72, 0xF943, 0xF85C, 0xF80D, 0xF790, 0xF687, 0xF63A, 0xF7E8, 0xFB35, 0xFDE4, 0xFE43, 0xFDFB, 0x0094,
    0x0646, 0x0B3C, 0x0EE3, 0x1511, 0x1FD8, 0x2B0E, 0x31D8, 0x347E, 0x35F8, 0x3800, 0x39A1, 0x3899, 0x34D5, 0x3030, 0x2BEC, 0x26FB,
    0x1F06, 0x14AE, 0x0B6B, 0x0410, 0xFC41, 0xF42C, 0xEE1C, 0xEB0B, 0xE9C2, 0xE88E, 0xE751, 0xE571, 0xE304, 0xE1F0, 0xE1EC, 0xE251,
    0xE3B4, 0xE5B9, 0xE7C0, 0xE972, 0xE945, 0xE787, 0xE683, 0xE621, 0xE503, 0xE55F, 0xE7AC, 0xE9F5, 0xEE29, 0xF407, 0xF902, 0xFC0C,
    0xFD15, 0xFD6D, 0xFDF6, 0xFE1B, 0xFD47, 0xFBF3, 0xFB7B, 0xFD7E, 0x00B2, 0x01B6, 0x0023, 0xFFD7, 0x034F, 0x073C, 0x08F9, 0x0B8F,
    0x12E0, 0x1DF6, 0x27A7, 0x2D03, 0x2FA6, 0x3232, 0x34FC, 0x3663, 0x34D3, 0x3136, 0x2E45, 0x2BEF, 0x26F6, 0x1EEF, 0x16AF, 0x0F85,
    0x0849, 0x0013, 0xF8AA, 0xF393, 0xF0A6, 0xEF55, 0xEE87, 0xEC95, 0xE9C6, 0xE743, 0xE550, 0xE47D, 0xE497, 0xE50A, 0xE6DB, 0xE9B1,
    0xEAA3, 0xE9D0, 0xE8EF, 0xE775, 0xE61D, 0xE55C, 0xE48C, 0xE49A, 0xE665, 0xEA7C, 0xF026, 0xF4CF, 0xF749, 0xF89E, 0xF9F2, 0xFB75,
    0xFC94, 0xFC63, 0xFB9C, 0xFD29, 0x01A9, 0x055E, 0x0550, 0x0482, 0x06C9, 0x0A7E, 0x0C14, 0x0C42, 0x0F3C, 0x16F1, 0x2108, 0x28ED,
    0x2D13, 0x2F63, 0x3200, 0x3501, 0x3564, 0x32A6, 0x2FD8, 0x2DEA, 0x2A9D, 0x2413, 0x1BFE, 0x1475, 0x0CBE, 0x0478, 0xFC85, 0xF58D,
    0xF0BA, 0xEE8D, 0xEDE3, 0xED44, 0xEC39, 0xEA56, 0xE87B, 0xE7E9, 0xE7A8, 0xE71C, 0xE845, 0xEAB0, 0xEBE3, 0xEB70, 0xEA49, 0xE8E8,
    0xE79E, 0xE690, 0xE580, 0xE428, 0xE360, 0xE4CF, 0xE8CE, 0xEDE8, 0xF212, 0xF4AF, 0xF654, 0xF805, 0xF9FD, 0xFA94, 0xF8DF, 0xF7A8,
    0xFA2F, 0xFE74, 0xFFF7, 0xFF74, 0x0089, 0x0448, 0x078F, 0x085D, 0x0966, 0x0F1D, 0x1933, 0x23F8, 0x2C23, 0x30B5, 0x3453, 0x3853,
    0x3A7A, 0x3992, 0x3705, 0x34FF, 0x32A0, 0x2D76, 0x26A7, 0x1F32, 0x1726, 0x0EBB, 0x05D9, 0xFCD5, 0xF541, 0xF051, 0xED17, 0xEB62,
    0xEA17, 0xE7E3, 0xE5B9, 0xE4C8, 0xE3FE, 0xE333, 0xE3D5, 0xE63D, 0xE8D3, 0xEA50, 0xEAE3, 0xEAEB, 0xEA86, 0xEA1E, 0xE9B3, 0xE86E,
    0xE684, 0xE5B3, 0xE713, 0xEA8E, 0xEEEF, 0xF256, 0xF3E7, 0xF502, 0xF733, 0xF8FE, 0xF7BD, 0xF555, 0xF5D9, 0xF970, 0xFC45, 0xFC6F,
    0xFC77, 0xFED3, 0x021E, 0x03F1, 0x03F4, 0x050D, 0x0A99, 0x1490, 0x1E7B, 0x2590, 0x2B54, 0x3175, 0x36E4, 0x394B, 0x39A5, 0x3A18,
    0x39DB, 0x3794, 0x3339, 0x2CFF, 0x25DC, 0x1E4C, 0x15BC, 0x0C08, 0x0221, 0xF8FA, 0xF1E9, 0xEEAD, 0xEDB1, 0xEB19, 0xE834, 0xE687,
    0xE49C, 0xE28D, 0xE129, 0xE14E, 0xE2B4, 0xE41B, 0xE546, 0xE5EE, 0xE62E, 0xE691, 0xE706, 0xE6DD, 0xE57A, 0xE433, 0xE424, 0xE636,
    0xEA83, 0xEF6C, 0xF28E, 0xF468, 0xF76B, 0xFAC8, 0xFB34, 0xF8A5, 0xF6DA, 0xF874, 0xFB3C, 0xFBF4, 0xFB2B, 0xFBBE, 0xFE82, 0x0166,
    0x01FF, 0x00FF, 0x0283, 0x08FE, 0x1276, 0x1AEA, 0x218E, 0x28AE, 0x2F9C, 0x3418, 0x3650, 0x3784, 0x383F, 0x3848, 0x3663, 0x3257,
    0x2D7E, 0x282F, 0x21E2, 0x1AA0, 0x1259, 0x0930, 0x0119, 0xFBB8, 0xF819, 0xF4CA, 0xF16A, 0xEEC0, 0xEC67, 0xE9AB, 0xE6EB, 0xE549,
    0xE4F1, 0xE583, 0xE65E, 0xE6FF, 0xE6D7, 0xE696, 0xE695, 0xE619, 0xE48A, 0xE25E, 0xE017, 0xDEDC, 0xE0E6, 0xE57B, 0xE95C, 0xEBC2,
    0xEF0E, 0xF405, 0xF7B2, 0xF7B6, 0xF61C, 0xF685, 0xF92E, 0xFB74, 0xFBAA, 0xFB5A, 0xFCC3, 0xFFDC, 0x01F7, 0x010A, 0xFF3F, 0x0114,
    0x0768, 0x0E8D, 0x154E, 0x1CD6, 0x24A0, 0x2B2D, 0x2FBD, 0x3264, 0x343B, 0x35B0, 0x35C4, 0x339C, 0x3029, 0x2BCD, 0x2680, 0x2093,
    0x196F, 0x1097, 0x075A, 0xFFE5, 0xFAEF, 0xF786, 0xF54F, 0xF466, 0xF35F, 0xF14B, 0xEED4, 0xECAF, 0xEB43, 0xEB6F, 0xEC39, 0xEC4D,
    0xEC40, 0xEC3F, 0xEC51, 0xEC40, 0xEB73, 0xE9EE, 0xE6E5, 0xE32A, 0xE206, 0xE442, 0xE776, 0xE925, 0xEAA1, 0xEE54, 0xF2E4, 0xF4D2,
    0xF39F, 0xF262, 0xF372, 0xF627, 0xF7E1, 0xF812, 0xF8D5, 0xFBF8, 0x0056, 0x01DA, 0x0024, 0xFF83, 0x0293, 0x07FE, 0x0E2D, 0x1548,
    0x1D29, 0x24F5, 0x2B05, 0x2EDE, 0x316B, 0x336B, 0x344C, 0x33CF, 0x3206, 0x2E9E, 0x2A21, 0x2545, 0x1FD7, 0x187B, 0x0F4B, 0x068E,
    0xFFAF, 0xFA5F, 0xF652, 0xF3BA, 0xF227, 0xF08F, 0xEE9D, 0xECA5, 0xEACB, 0xE9FB, 0xEA90, 0xEBC0, 0xECC3, 0xEDDD, 0xEEF1, 0xEF6D,
    0xEFD3, 0xEFF8, 0xEE42, 0xEA56, 0xE6CC, 0xE6C8, 0xE936, 0xEAD6, 0xEB97, 0xEDD6, 0xF21B, 0xF5E7, 0xF6D7, 0xF568, 0xF44C, 0xF514,
    0xF653, 0xF624, 0xF4E4, 0xF5BC, 0xF96A, 0xFC70, 0xFC37, 0xFAB9, 0xFAFE, 0xFE01, 0x032F, 0x0964, 0x111B, 0x1A13, 0x226A, 0x2899,
    0x2CFA, 0x3074, 0x3322, 0x34AA, 0x34CC, 0x330E, 0x2F9E, 0x2BA9, 0x2746, 0x2137, 0x18EF, 0x0F9F, 0x06F6, 0xFF6F, 0xF968, 0xF540,
    0xF267, 0xF018, 0xEE14, 0xEBF4, 0xE98F, 0xE790, 0xE70E, 0xE787, 0xE859, 0xE9B4, 0xEAEF, 0xEBB3, 0xECEA, 0xEEE5, 0xF05A, 0xEF01,
    0xEC02, 0xEAA4, 0xEC76, 0xEF8D, 0xF193, 0xF352, 0xF69E, 0xF9F2, 0xFA59, 0xF990, 0xF8A0, 0xF83D, 0xF9D8, 0xFA88, 0xF906, 0xF848,
    0xFA54, 0xFD7E, 0xFEBD, 0xFD66, 0xFB59, 0xFB0F, 0xFC90, 0xFF2F, 0x040A, 0x0B47, 0x137C, 0x1B09, 0x216E, 0x26A3, 0x2ABB, 0x2E78,
    0x3175, 0x3283, 0x3156, 0x2F11, 0x2C5B, 0x2862, 0x2251, 0x1A43, 0x1186, 0x08A5, 0x009F, 0xFA36, 0xF539, 0xF14A, 0xEE60, 0xEBF1,
    0xE924, 0xE6C1, 0xE53C, 0xE494, 0xE430, 0xE463, 0xE53C, 0xE5F0, 0xE668, 0xE872, 0xEB30, 0xEBE7, 0xE9C8, 0xE6F6, 0xE67C, 0xE7EB,
    0xE90C, 0xE9EB, 0xEC41, 0xF13E, 0xF738, 0xFB62, 0xFCA3, 0xFD32, 0xFF63, 0x017A, 0x011A, 0xFF57, 0xFF65, 0x0202, 0x04EC, 0x0574,
    0x0398, 0x01E3, 0x014D, 0x019B, 0x038F, 0x0822, 0x0E5B, 0x1537, 0x1C1D, 0x21F5, 0x2634, 0x29AB, 0x2CE4, 0x2ED2, 0x2EC6, 0x2D71,
    0x2BA1, 0x2938, 0x2543, 0x1FD3, 0x18CA, 0x10C1, 0x08B0, 0x0172, 0xFB2B, 0xF635, 0xF2D2, 0xF04F, 0xEDAB, 0xEA91, 0xE7DE, 0xE598,
    0xE3D8, 0xE363, 0xE3E5, 0xE3EF, 0xE323, 0xE379, 0xE625, 0xE8E6, 0xE8B5, 0xE5FB, 0xE3D2, 0xE3AE, 0xE458, 0xE486, 0xE4EF, 0xE774,
    0xECD1, 0xF27F, 0xF5A6, 0xF6E5, 0xF8B8, 0xFB8C, 0xFD3D, 0xFCE3, 0xFC74, 0xFE92, 0x02B4, 0x0603, 0x06FF, 0x06CC, 0x0644, 0x0580,
    0x05BC, 0x07D8, 0x0C07, 0x122C, 0x1973, 0x2064, 0x25FB, 0x2A90, 0x2EB3, 0x3202, 0x3373, 0x3307, 0x31D2, 0x2FD8, 0x2C92, 0x282F,
    0x2214, 0x1A39, 0x115F, 0x087C, 0x0002, 0xF8AE, 0xF349, 0xEFA7, 0xECC8, 0xEA3F, 0xE813, 0xE5E5, 0xE3C6, 0xE293, 0xE332, 0xE40F,
    0xE3CF, 0xE357, 0xE4F6, 0xE824, 0xEA01, 0xE8F0, 0xE632, 0xE446, 0xE39D, 0xE329, 0xE1F7, 0xE1A3, 0xE4A2, 0xE9ED, 0xEE4B, 0xF08B,
    0xF248, 0xF4EF, 0xF7BD, 0xF896, 0xF76E, 0xF773, 0xF9FF, 0xFD4C, 0xFFBF, 0x0113, 0x017B, 0x0160, 0x015D, 0x026E, 0x050D, 0x09F5,
    0x1118, 0x192F, 0x20AC, 0x2707, 0x2CD8, 0x3238, 0x3602, 0x37AD, 0x3822, 0x3780, 0x35F1, 0x3385, 0x2F94, 0x29AA, 0x21F0, 0x1977,
    0x103A, 0x06E6, 0xFEF3, 0xF8DD, 0xF3C1, 0xEF75, 0xEC1F, 0xE8DD, 0xE51D, 0xE1D5, 0xE09C, 0xE0F3, 0xE0EE, 0xE000, 0xE02B, 0xE2CF,
    0xE61B, 0xE7EF, 0xE776, 0xE5E0, 0xE543, 0xE56B, 0xE458, 0xE288, 0xE2B6, 0xE5F2, 0xEA41, 0xED34, 0xEE8E, 0xF061, 0xF39A, 0xF5F3,
    0xF5A3, 0xF48B, 0xF507, 0xF736, 0xF9D5, 0xFC50, 0xFDC0, 0xFDE8, 0xFDA9, 0xFD57, 0xFD90, 0xFF45, 0x0392, 0x0A70, 0x1245, 0x19E3,
    0x215F, 0x28CA, 0x2F58, 0x3485, 0x37E8, 0x398C, 0x3A2E, 0x3A02, 0x3896, 0x3553, 0x3044, 0x29D8, 0x221D, 0x198C, 0x10C2, 0x08B7,
    0x01EE, 0xFC8E, 0xF862, 0xF4F4, 0xF0AE, 0xEBE0, 0xE854, 0xE6DB, 0xE5DC, 0xE3BD, 0xE11B, 0xE052, 0xE200, 0xE40F, 0xE464, 0xE2FD,
    0xE1A9, 0xE1A3, 0xE159, 0xDFAD, 0xDE1C, 0xDF08, 0xE2FF, 0xE73F, 0xEA01, 0xEC61, 0xF037, 0xF42C, 0xF5A9, 0xF50D, 0xF44E, 0xF4A7,
    0xF64F, 0xF8A4, 0xFAAE, 0xFBBE, 0xFC27, 0xFC25, 0xFBB0, 0xFB43, 0xFCC2, 0x0113, 0x0710, 0x0DD0, 0x1523, 0x1C69, 0x2372, 0x29F5,
    0x2EE2, 0x3207, 0x33F4, 0x3558, 0x3606, 0x3578, 0x337F, 0x3044, 0x2B1D, 0x2410, 0x1C4C, 0x1500, 0x0E27, 0x07E7, 0x031E, 0xFFDA,
    0xFC66, 0xF7CD, 0xF37B, 0xF092, 0xEF52, 0xEDB6, 0xEAE1, 0xE828, 0xE7E3, 0xE9AA, 0xEAD7, 0xE9ED, 0xE7C6, 0xE64F, 0xE57B, 0xE365,
    0xDF9E, 0xDCC1, 0xDD4F, 0xE01E, 0xE259, 0xE411, 0xE6F0, 0xEAEA, 0xEEAB, 0xF0C2, 0xF10A, 0xF0DF, 0xF1BD, 0xF41A, 0xF73D, 0xF9CD,
    0xFB6A, 0xFC9B, 0xFCC1, 0xFB60, 0xFA6F, 0xFBAF, 0xFF1F, 0x0473, 0x0ADD, 0x11AD, 0x18BB, 0x201D, 0x26F8, 0x2C13, 0x2FA2, 0x3238,
    0x33E1, 0x346B, 0x33EA, 0x3247, 0x2EA6, 0x28BE, 0x2162, 0x19DE, 0x1281, 0x0B28, 0x050C, 0x0159, 0xFEB8, 0xFB48, 0xF709, 0xF3ED,
    0xF2A2, 0xF227, 0xF0D0, 0xEE2D, 0xEC80, 0xED6B, 0xEF81, 0xF076, 0xEFD1, 0xEEA9, 0xEE5B, 0xEDD3, 0xEB24, 0xE728, 0xE4F3, 0xE5AC,
    0xE6ED, 0xE7A4, 0xE8C6, 0xEB0D, 0xEE0D, 0xF052, 0xF0CF, 0xEFF5, 0xEF44, 0xEFD4, 0xF190, 0xF38F, 0xF5A9, 0xF807, 0xF999, 0xF99C,
    0xF8CD, 0xF8A2, 0xFA22, 0xFDD5, 0x0373, 0x09A6, 0x102D, 0x173A, 0x1E7A, 0x24EC, 0x29E9, 0x2DB5, 0x3055, 0x31FC, 0x32D8, 0x32CB,
    0x3144, 0x2DBE, 0x284F, 0x21C8, 0x1AAC, 0x12B9, 0x0AF6, 0x04F6, 0x00F3, 0xFD2E, 0xF888, 0xF3DB, 0xF0F5, 0xF01E, 0xEF96, 0xEDA5,
    0xEB3B, 0xEAC6, 0xECB7, 0xEF7D, 0xF092, 0xF000, 0xF03B, 0xF160, 0xF13E, 0xEE96, 0xEB3C, 0xEA2A, 0xEAE7, 0xEBFD, 0xED21, 0xEEF8,
    0xF1F1, 0xF564, 0xF83D, 0xF91C, 0xF847, 0xF7A1, 0xF7A5, 0xF80F, 0xF8EC, 0xFA5C, 0xFB8F, 0xFB9A, 0xFA58, 0xF860, 0xF6F4, 0xF75B,
    0xFA06, 0xFE34, 0x034C, 0x09AF, 0x1132, 0x190C, 0x2030, 0x2649, 0x2B26, 0x2E76, 0x308B, 0x3239, 0x328F, 0x30CE, 0x2D26, 0x2837,
    0x223C, 0x1AC1, 0x1208, 0x09D4, 0x042C, 0x0067, 0xFC4B, 0xF73A, 0xF288, 0xF008, 0xEF45, 0xEDF0, 0xEB60, 0xE898, 0xE7CD, 0xE988,
    0xEB47, 0xEB99, 0xEC0C, 0xEDC8, 0xEF53, 0xEE90, 0xEBF2, 0xE9D1, 0xE94F, 0xE9D2, 0xEA7C, 0xEB79, 0xED97, 0xF14F, 0xF5C2, 0xF87F,
    0xF94D, 0xF981, 0xF9C3, 0xFA80, 0xFBC0, 0xFD84, 0xFF79, 0x0120, 0x01E3, 0x00EA, 0xFEA4, 0xFCBD, 0xFC73, 0xFDBE, 0x002B, 0x03C5,
    0x08EF, 0x0F29, 0x1583, 0x1B7F, 0x20DF, 0x250D, 0x27F2, 0x2A50, 0x2C5F, 0x2D4A, 0x2C39, 0x29BA, 0x2636, 0x2147, 0x1A3A, 0x1217,
    0x0ABF, 0x0590, 0x017E, 0xFC99, 0xF727, 0xF2C1, 0xF058, 0xEF2D, 0xECD3, 0xE912, 0xE671, 0xE686, 0xE7A8, 0xE7F2, 0xE7EB, 0xE8FA,
    0xEAD2, 0xEB8F, 0xEA18, 0xE78B, 0xE5B9, 0xE539, 0xE59C, 0xE614, 0xE6FF, 0xE9AF, 0xEDFB, 0xF264, 0xF583, 0xF75C, 0xF882, 0xF930,
    0xFA00, 0xFB6D, 0xFD69, 0x0005, 0x02B7, 0x0416, 0x038B, 0x0217, 0x015E, 0x019D, 0x02B6, 0x0506, 0x08B7, 0x0DC2, 0x139D, 0x19C3,
    0x1F8E, 0x2435, 0x2763, 0x298C, 0x2B8A, 0x2CDF, 0x2CAA, 0x2AF3, 0x2843, 0x2458, 0x1E8A, 0x1683, 0x0DE4, 0x06E3, 0x01E2, 0xFD6C,
    0xF866, 0xF335, 0xEFAE, 0xEE82, 0xED93, 0xEAD1, 0xE786, 0xE615, 0xE680, 0xE70B, 0xE6D4, 0xE717, 0xE888, 0xEA1B, 0xE9FF, 0xE822,
    0xE5B5, 0xE409, 0xE316, 0xE24F, 0xE1B6, 0xE230, 0xE493, 0xE87A, 0xEC6A, 0xEFAA, 0xF1F0, 0xF37E, 0xF4B2, 0xF5D8, 0xF78D, 0xFA90,
    0xFE65, 0x019C, 0x035D, 0x0355, 0x0284, 0x01D5, 0x018E, 0x0236, 0x046D, 0x084A, 0x0DB4, 0x140F, 0x1B13, 0x21BB, 0x2703, 0x2AC8,
    0x2E23, 0x3101, 0x3265, 0x3219, 0x30A2, 0x2E3D, 0x2A1E, 0x236C, 0x1A5C, 0x10CF, 0x0924, 0x037F, 0xFDB0, 0xF6A3, 0xF049, 0xEC8A,
    0xEAAD, 0xE815, 0xE43F, 0xE12A, 0xE06D, 0xE0C9, 0xE0D7, 0xE105, 0xE267, 0xE4E2, 0xE703, 0xE71F, 0xE588, 0xE3D6, 0xE2E9, 0xE226,
    0xE0C7, 0xDFBE, 0xE06F, 0xE2E6, 0xE614, 0xE93C, 0xEBF9, 0xEDE8, 0xEF43, 0xF047, 0xF119, 0xF268, 0xF4D8, 0xF82B, 0xFB1E, 0xFCA5,
    0xFCE6, 0xFCA8, 0xFC71, 0xFCA8, 0xFDB6, 0xFFCB, 0x0309, 0x07A3, 0x0DB3, 0x149C, 0x1BD8, 0x2283, 0x27CF, 0x2CF0, 0x3120, 0x3315,
    0x3385, 0x3350, 0x323B, 0x2F35, 0x28CE, 0x1FEB, 0x1733, 0x1074, 0x0A93, 0x036B, 0xFB75, 0xF4D5, 0xF11C, 0xEE5B, 0xEA26, 0xE58E,
    0xE280, 0xE105, 0xDFD1, 0xDE71, 0xDD85, 0xDE19, 0xDFD7, 0xE128, 0xE0D5, 0xDF95, 0xDE9C, 0xDDF1, 0xDD52, 0xDC5F, 0xDBCD, 0xDC77,
    0xDF1C, 0xE2EB, 0xE6CE, 0xEA47, 0xED10, 0xEEF8, 0xF02C, 0xF114, 0xF281, 0xF52D, 0xF883, 0xFB4F, 0xFC8D, 0xFCA4, 0xFC46, 0xFB92,
    0xFB23, 0xFBC4, 0xFD83, 0x007B, 0x054C, 0x0BF0, 0x1312, 0x1984, 0x1F38, 0x24EA, 0x2A4B, 0x2E77, 0x30DC, 0x322B, 0x331B, 0x32ED,
    0x3043, 0x29F0, 0x21C7, 0x1A7C, 0x1502, 0x0F2D, 0x07B9, 0x0076, 0xFB5F, 0xF78B, 0xF382, 0xEF56, 0xEB6E, 0xE8A3, 0xE6B1, 0xE45F,
    0xE1DD, 0xE05C, 0xE090, 0xE17A, 0xE1CC, 0xE0F5, 0xDF5F, 0xDDEE, 0xDC95, 0xDACB, 0xD8C9, 0xD747, 0xD71E, 0xD905, 0xDC30, 0xDFE0,
    0xE39F, 0xE71D, 0xE9B5, 0xEB6D, 0xECE3, 0xEEF6, 0xF266, 0xF66F, 0xF9B6, 0xFBC2, 0xFCC4, 0xFCC8, 0xFC8A, 0xFCB8, 0xFD59, 0xFE78,
    0x00F7, 0x059E, 0x0BE1, 0x1216, 0x17A7, 0x1D01, 0x22B6, 0x27E9, 0x2B76, 0x2D85, 0x2F3C, 0x3107, 0x31A5, 0x2F28, 0x2923, 0x220F,
    0x1C42, 0x16E0, 0x0FFA, 0x0835, 0x01A5, 0xFD08, 0xF974, 0xF575, 0xF10A, 0xED5E, 0xEB37, 0xE95C, 0xE6DE, 0xE4CB, 0xE3E5, 0xE487,
    0xE5A3, 0xE5D7, 0xE4F6, 0xE39A, 0xE233, 0xE0AC, 0xDE80, 0xDBDC, 0xD9F6, 0xD996, 0xDAC5, 0xDD1B, 0xE006, 0xE2ED, 0xE563, 0xE718,
    0xE7D9, 0xE88B, 0xEAA1, 0xEDF7, 0xF1C2, 0xF52C, 0xF7A9, 0xF910, 0xF9B0, 0xFA39, 0xFB1A, 0xFBC7, 0xFCAA, 0xFF9C, 0x04CB, 0x0B1F,
    0x116B, 0x177E, 0x1DA2, 0x2402, 0x295B, 0x2CE7, 0x2F0C, 0x3158, 0x33C6, 0x3454, 0x3129, 0x2B41, 0x252A, 0x1FCB, 0x19B7, 0x1229,
    0x0A6F, 0x0498, 0x009A, 0xFCF1, 0xF87D, 0xF439, 0xF125, 0xEEDC, 0xEC8D, 0xEA0C, 0xE831, 0xE7B3, 0xE8DC, 0xEA03, 0xEA9F, 0xEA04,
    0xE9AA, 0xE896, 0xE752, 0xE4DF, 0xE469, 0xE22D, 0xE131, 0xE213, 0xE3CF, 0xE478, 0xE59B, 0xF4DA, 0xF912, 0xF69F, 0xF6BC, 0xF696,
    0xF773, 0xF7A2, 0xFBA4, 0xFC0D, 0xFC2D, 0xFB25, 0xFB31, 0xFA32, 0xF7AF, 0xFA79, 0xFB74, 0x0116, 0x093B, 0x0E4B, 0x12C9, 0x15F0,
    0x1C75, 0x20A5, 0x25A6, 0x290C, 0x2C58, 0x2FD4, 0x3088, 0x2E04, 0x29B3, 0x2585, 0x2224, 0x1B16, 0x1234, 0x0AF3, 0x047D, 0x016B,
    0xFB8F, 0xFA28, 0xF5AF, 0xF1DD, 0xF493, 0xF057, 0xE6DB, 0xE266, 0xDCBC, 0xED23, 0x029D, 0x0417, 0x0602, 0x03B9, 0x0275, 0xFF37,
    0xFE2B, 0xF9F6, 0xF713, 0xF4B2, 0xF3B1, 0xF7DD, 0xF439, 0xF7A6, 0xF4CF, 0xF250, 0xFCB6, 0x02C2, 0x0943, 0x0AD3, 0x0F06, 0x149A,
    0x1A5A, 0x1FC1, 0x1849, 0x1323, 0x0FB1, 0x0FD2, 0x0FC1, 0x0AD2, 0x09BD, 0x048A, 0xFD92, 0x0068, 0x0700, 0x1015, 0x1298, 0x115D,
    0x0FFF, 0x056A, 0x0E81, 0x17FC, 0x10B9, 0x0792, 0x00B8, 0xFD07, 0xF448, 0xF222, 0xEDAD, 0xEC34, 0xEE7D, 0xEFB7, 0xF4A1, 0xF30B,
    0xF660, 0xF882, 0xF9AF, 0x0213, 0x063F, 0x07E2, 0x05DA, 0x04B6, 0x0533, 0x03F6, 0x03C2, 0x0442, 0x05CD, 0x061F, 0x05F4, 0x0648,
    0x04C5, 0x0380, 0x03E4, 0x0683, 0x0BF2, 0x0F9D, 0x111E, 0x1172, 0x1234, 0x1499, 0x151E, 0x1509, 0x14A0, 0x1464, 0x1317, 0x104B,
    0x0E49, 0x0B0E, 0x07F3, 0x0643, 0x0677, 0x076D, 0x07A4, 0x06C9, 0x074E, 0x07B0, 0x083C, 0x091E, 0x072E, 0x06B9, 0x0701, 0x0831,
    0x067F, 0x02E8, 0x0118, 0xFDB1, 0xFB68, 0xFA32, 0xFA68, 0xF9F9, 0xF908, 0xFA23, 0xFAB8, 0xFB92, 0xFCBD, 0xFD8D, 0xFF8D, 0x0267,
    0x0524, 0x06E1, 0x079F, 0x0842, 0x07C8, 0x0790, 0x0913, 0x0A85, 0x0B7F, 0x0BE1, 0x0BD1, 0x0B54, 0x0B1E, 0x0B57, 0x0A7B, 0x0B5B,
    0x0D32, 0x0E59, 0x0FD8, 0x109C, 0x1111, 0x10B6, 0x110E, 0x110C, 0x10A4, 0x10A9, 0x1030, 0x0FF9, 0x0F32, 0x0E44, 0x0D3A, 0x0C0B,
    0x0BA3, 0x0BAC, 0x0B50, 0x0AE1, 0x0A3E, 0x09CE, 0x090A, 0x07CA, 0x0656, 0x04AB, 0x03B5, 0x0282, 0x0142, 0xFFB7, 0xFE71, 0xFDA1,
    0xFC5F, 0xFBA2, 0xFB4B, 0xFB33, 0xFB58, 0xFB4D, 0xFB06, 0xFA9C, 0xFA3D, 0xFAB6, 0xFB7F, 0xFCB1, 0xFE4D, 0xFF85, 0x004F, 0x0109,
    0x01D6, 0x0270, 0x032E, 0x042B, 0x0527, 0x0642, 0x06C9, 0x06EF, 0x0708, 0x068D, 0x0625, 0x05E6, 0x05B0, 0x05DB, 0x062E, 0x066C,
    0x0671, 0x0665, 0x067E, 0x0697, 0x06D8, 0x0730, 0x07B1, 0x081E, 0x086B, 0x08A5, 0x0856, 0x07EC, 0x075E, 0x070F, 0x0724, 0x0723,
    0x073E, 0x074E, 0x0724, 0x069D, 0x05AA, 0x04F7, 0x0456, 0x03A5, 0x028D, 0x00EE, 0xFF74, 0xFE29, 0xFCA9, 0xFB0B, 0xF9A1, 0xF8B8,
    0xF815, 0xF769, 0xF6AC, 0xF5EE, 0xF561, 0xF50E, 0xF4F6, 0xF51C, 0xF5CB, 0xF664, 0xF70A, 0xF80C, 0xF8F5, 0xF9B1, 0xFA5F, 0xFAE9,
    0xFBA9, 0xFC7C, 0xFD29, 0xFDAC, 0xFDEB, 0xFE05, 0xFE36, 0xFE3D, 0xFE68, 0xFEFB, 0xFF46, 0xFF56, 0xFF7E, 0xFF4D, 0xFF1D, 0xFF0F,
    0xFF15, 0xFF4B, 0xFFC7, 0x0035, 0x00A3, 0x0118, 0x0174, 0x01AC, 0x0221, 0x02D7, 0x0367, 0x03D6, 0x040C, 0x041E, 0x0405, 0x03A8,
    0x02C8, 0x01C4, 0x00EF, 0x0053, 0xFF6C, 0xFE34, 0xFCF5, 0xFBDC, 0xFAC0, 0xF953, 0xF7F0, 0xF6B3, 0xF5D9, 0xF53D, 0xF46D, 0xF38B,
    0xF2FB, 0xF253, 0xF1D2, 0xF1E7, 0xF212, 0xF254, 0xF2C8, 0xF356, 0xF3FA, 0xF481, 0xF471, 0xF3F9, 0xF3EB, 0xF43E, 0xF4C6, 0xF54F,
    0xF5D0, 0xF6B5, 0xF808, 0xFA48, 0xFD42, 0x0018, 0x01F1, 0x031E, 0x0442, 0x0498, 0x0414, 0x02D4, 0xFFA6, 0xFAC7, 0xF5D8, 0xF409,
    0xF5BA, 0xF6C8, 0xF8C1, 0xFBEC, 0xFD96, 0xFE63, 0xFEDA, 0xFF07, 0xFF65, 0x0056, 0x0137, 0x00C4, 0xFEF9, 0xFD2F, 0xFCAA, 0xFC69,
    0xFC14, 0xFB6D, 0xFA99, 0xF9F4, 0xF8E0, 0xF7CC, 0xF683, 0xF4FA, 0xF422, 0xF36B, 0xF2C4, 0xF232, 0xF1B1, 0xF127, 0xF084, 0xF07B,
    0xF0B6, 0xF0E2, 0xF117, 0xF137, 0xF17C, 0xF1CA, 0xF1CC, 0xF1C9, 0xF149, 0xF0CA, 0xF082, 0xF030, 0xF00E, 0xEFEA, 0xEFF2, 0xEFBD,
    0xEFAA, 0xEFC1, 0xF004, 0xF083, 0xF1A8, 0xF2A8, 0xF3F0, 0xF532, 0xF683, 0xF7AE, 0xF8C1, 0xF9E9, 0xFAD4, 0xFBB8, 0xFCC7, 0xFE06,
    0xFE9A, 0xFF25, 0xFF5D, 0xFF70, 0xFF43, 0xFF38, 0xFF32, 0xFF7F, 0xFF6C, 0xFF41, 0xFE98, 0xFEBF, 0xFE54, 0xFDA4, 0xFC22, 0xFB01,
    0xF9F0, 0xF90A, 0xF7F1, 0xF69A, 0xF59E, 0xF4E4, 0xF491, 0xF400, 0xF40F, 0xF353, 0xF3CA, 0xF2EF, 0xF45C, 0xF43C, 0xF4FD, 0xF4B7,
    0xF605, 0xF596, 0xF6C9, 0xF674, 0xF737, 0xF0CD, 0xEB4C, 0x00CF, 0xF7BA, 0xF7C7, 0xEAC8, 0xFD6C, 0xFE3A, 0xE67A, 0xFAEB, 0xEC5A,
    0xFC1F, 0xE640, 0xEF36, 0xFA6F, 0xF1DA, 0xF44C, 0xF97A, 0xEFDA, 0xFEDE, 0xFEF0, 0xE566, 0x05E4, 0xED41, 0xFB0F, 0xF1C1, 0xE872,
    0x03F7, 0x0045, 0xF0B0, 0x1036, 0x12A5, 0xDB1F, 0xED36, 0xFAB4, 0x163D, 0x0A8E, 0xC16F, 0x18D8, 0x0538, 0xD395, 0x149D, 0xEAE2,
    0x1032, 0xE6E9, 0xDB22, 0x1EA3, 0xDDA7, 0xE01C, 0xF059, 0x05BC, 0x0533, 0xE785, 0xE880, 0xF8F0, 0xF4C0, 0xD868, 0xE720, 0xCB1C,
    0xE960, 0xC020, 0xD70C, 0xE327, 0xB153, 0xBD77, 0xC4BF, 0xDF47, 0xB3CB, 0xC94C, 0xC83F, 0xC344, 0xBA7E, 0xEF53, 0xEB33, 0xCB2A,
    0xF97A, 0x0BF0, 0x05F7, 0x06B4, 0x1ACB, 0x2378, 0x3770, 0x1F3E, 0x37A2, 0x3414, 0x44BD, 0x2F76, 0x2CD9, 0x51C5, 0x3615, 0x3953,
    0x0E8C, 0x3A4E, 0x25FD, 0xF0C8, 0xE9B0, 0xE2C6, 0xE250, 0xB7C8, 0xB897, 0xBC10, 0xB404, 0x93A0, 0xA72D, 0xA16E, 0x8E4D, 0x9858,
    0xAC0E, 0x9CD3, 0x87EC, 0x9ED9, 0xA346, 0xB2F4, 0xB0C2, 0xAC01, 0xB5BE, 0xAD95, 0xD555, 0xD863, 0xB932, 0xD6CA, 0xD4F7, 0xCDDE,
    0xD58E, 0x27F5, 0x1012, 0x0C99, 0x207C, 0x2F30, 0x53B6, 0x4273, 0x67AD, 0x5943, 0x5CDE, 0x5CAE, 0x78E1, 0x6FD9, 0x71E3, 0x5578,
    0x769A, 0x6F87, 0x41CB, 0x7FFD, 0x6CFA, 0x7D6A, 0x73E5, 0x71F3, 0x796B, 0x7FE9, 0x6FC2, 0x7704, 0x71B6, 0x56A3, 0x64C5, 0x5F9C,
    0x4177, 0x2BCD, 0x58E1, 0x30FF, 0x2E7F, 0x49B5, 0x338C, 0x1A22, 0x3004, 0x428C, 0x17A7, 0x4141, 0x4287, 0x1C8F, 0x345A, 0x271A,
    0x18C8, 0x2222, 0x2AA4, 0x02B4, 0x1C1A, 0x2A53, 0x059E, 0x0C45, 0xFFB9, 0x11A9, 0xF6C4, 0x168B, 0x0702, 0x1C00, 0x1A0A, 0xFF4C,
    0x2FEE, 0x031D, 0x0E3F, 0x03A5, 0x2240, 0xF9DB, 0xFB51, 0x153D, 0xF6B0, 0xF7A3, 0x010B, 0x122C, 0xC578, 0xE6C7, 0xD69E, 0xB7FF,
    0xC8C1, 0xB5AE, 0x9DBB, 0xADA1, 0xBB9B, 0x8E98, 0xB004, 0xA3BD, 0x94AB, 0xAB12, 0x9B6D, 0xA3C3, 0xACE9, 0xA889, 0xBEEF, 0xAC1D,
    0x9894, 0xA381, 0xA537, 0x9ED5, 0xAC0D, 0x9BED, 0x9853, 0xA979, 0xA794, 0xA350, 0xAB8C, 0xADB1, 0x999F, 0xC44E, 0xB38F, 0xBAC5,
    0xB308, 0xC202, 0xBEB1, 0xB944, 0xCED7, 0xC188, 0xC907, 0xCAA2, 0xC782, 0xCA31, 0xDE59, 0xB726, 0xDDDC, 0xBC3D, 0xB921, 0xC4FA,
    0xCF79, 0xD8CE, 0xC343, 0xD263, 0xDA90, 0xEA33, 0xD415, 0xD775, 0xD463, 0xE75C, 0xDF01, 0xFA11, 0x0CCA, 0xF906, 0x051D, 0x290D,
    0x09C0, 0x0C9D, 0x1E68, 0x0AAB, 0x0ABE, 0x01BB, 0xF6F6, 0x05A3, 0x0B16, 0xF2F9, 0xFF50, 0x1483, 0x215B, 0x16F2, 0x311E, 0x2219,
    0x46B5, 0x40B5, 0x4386, 0x5CE1, 0x3209, 0x3C4C, 0x4086, 0x3FC7, 0x3B81, 0x3C5B, 0x3702, 0x3E11, 0x402D, 0x2FD7, 0x4E84, 0x5DDB,
    0x4763, 0x54CC, 0x6328, 0x6088, 0x703A, 0x6EED, 0x5D0D, 0x7D49, 0x7535, 0x6C14, 0x6433, 0x7C2F, 0x79FD, 0x6A8B, 0x7256, 0x6376,
    0x7174, 0x6EA4, 0x45DF, 0x65FA, 0x749A, 0x68F3, 0x7561, 0x5227, 0x7336, 0x71F0, 0x6FBC, 0x642B, 0x79A1, 0x5281, 0x60A0, 0x6B1F,
    0x6049, 0x767C, 0x5053, 0x6E4F, 0x6854, 0x6111, 0x5A4A, 0x5986, 0x5827, 0x65CF, 0x3ED0, 0x4CC2, 0x53B8, 0x4C0E, 0x5163, 0x27FE,
    0x4079, 0x37C1, 0x2290, 0x3DE1, 0x210E, 0x2D24, 0x2BC6, 0x2592, 0x1BF6, 0xDCC8, 0xFC42, 0x0667, 0xFCE5, 0xF0E7, 0xDAF4, 0xE817,
    0xF89D, 0xE2C4, 0xE68E, 0xE30E, 0xF4F9, 0xE76C, 0x0278, 0x2A42, 0xF17B, 0x00BC, 0x1D5C, 0x0661, 0xF776, 0x145B, 0x0ED4, 0xFE5C,
    0x026D, 0xD96C, 0xEA3F, 0xF270, 0xCF1D, 0xDC91, 0xC9EB, 0xCC69, 0xE00A, 0xD677, 0xCA19, 0xDCEB, 0xC624, 0xC6DB, 0xC7E4, 0xBCA4,
    0xD51D, 0xBF2A, 0xC37B, 0xD050, 0xC9AA, 0xCFEE, 0xC528, 0xD4B3, 0xD572, 0xD069, 0xCF58, 0xC8E5, 0xC7D7, 0xC815, 0xC4DF, 0xAB2D,
    0xCA8C, 0xA98F, 0xB41F, 0xA519, 0xA362, 0xAFEE, 0x9E96, 0xAFEA, 0x9A3B, 0xAED9, 0xA8FF, 0xA0AF, 0x9BF4, 0xAE5D, 0x9499, 0x9D9A,
    0x9F38, 0x9E3F, 0xA0F7, 0x9CE9, 0xA76F, 0x9E31, 0xAAE2, 0xA1E5, 0xB302, 0x9C36, 0xB113, 0xB9F3, 0xB656, 0xB1D8, 0xB740, 0xC07B,
    0xBBDD, 0xBAC2, 0xC7A2, 0xC8BF, 0xC49D, 0xD6A6, 0xBCB3, 0xC3E7, 0xC97B, 0xD1E9, 0xC6DF, 0xC95E, 0xD35F, 0xE024, 0xCABE, 0xEA3E,
    0xDE56, 0xE54F, 0xF729, 0xD9E5, 0xF00B, 0xDB75, 0x003B, 0xF33F, 0xF21E, 0xFA31, 0xFF1B, 0x03FA, 0xFCA8, 0x069A, 0x0EE2, 0x1699,
    0x1215, 0x1173, 0x1B40, 0x1FE9, 0x294C, 0x1DD5, 0x141B, 0x2E95, 0x1E4B, 0x291B, 0x2948, 0x2907, 0x312C, 0x2655, 0x2966, 0x20F5,
    0x2727, 0x1DF3, 0x103F, 0x1014, 0x1C7D, 0x0313, 0x0830, 0x10E3, 0x01B4, 0x0D22, 0x0343, 0x1905, 0x06F5, 0x27CA, 0x2844, 0x1937,
    0x2BB1, 0x213A, 0x1C37, 0x242B, 0x2BBA, 0x2683, 0x1B15, 0x1415, 0x209B, 0x1795, 0x28E8, 0xFF7B, 0xF706, 0x0B75, 0xFE9A, 0xF665,
    0x1D6A, 0x0C4D, 0xF723, 0x0EC3, 0x0FB2, 0x13A0, 0x1195, 0x0F3B, 0x083B, 0x1989, 0x2121, 0x2752, 0x2C34, 0x3A25, 0x329E, 0x3E58,
    0x3B15, 0x491E, 0x4F70, 0x41AE, 0x55FD, 0x562C, 0x4F21, 0x6185, 0x4BF7, 0x5C6F, 0x53BD, 0x4D96, 0x53E2, 0x4730, 0x5D4A, 0x4B42,
    0x5876, 0x548E, 0x52E2, 0x40DA, 0x5A3C, 0x4242, 0x3FE1, 0x4748, 0x346D, 0x3ECB, 0x49DA, 0x3058, 0x3601, 0x4208, 0x3462, 0x41FC,
    0x2E65, 0x5285, 0x3AAE, 0x4ABD, 0x45C6, 0x389E, 0x429E, 0x40E1, 0x38C7, 0x3DD3, 0x49EE, 0x367F, 0x35A1, 0x393D, 0x3472, 0x200C,
    0x343D, 0x2C73, 0x26E3, 0x2D4A, 0x2BB7, 0x2168, 0x22E5, 0x2E42, 0x2ABF, 0x1B24, 0x2B06, 0x2992, 0x23EB, 0x1CF8, 0x1C84, 0x2091,
    0x1139, 0x2461, 0x11D0, 0x11AD, 0x1747, 0x1975, 0x1A89, 0x1FA2, 0x22C8, 0x2A54, 0x2232, 0x2B3E, 0x26C4, 0x1488, 0x2C5C, 0x2639,
    0x1602, 0x1CF3, 0x2AA0, 0x2BCF, 0x1442, 0x1633, 0x2F1F, 0x1091, 0x16BE, 0x0858, 0x089D, 0x08F7, 0x0546, 0xF8C9, 0xF040, 0xEFF3,
    0xF6C3, 0xF40D, 0xE7C4, 0x0AF4, 0xF19D, 0xF530, 0xFFF6, 0xF7EE, 0xF2B6, 0xE8DF, 0xF234, 0xE8A0, 0xE1B4, 0xF7E7, 0xDBE8, 0xDA10,
    0xE994, 0xD749, 0xC412, 0xC894, 0xC37A, 0xB262, 0xB8C2, 0xBD20, 0xB3E4, 0xB06D, 0xB636, 0xACC8, 0xB327, 0xAB28, 0xACE4, 0xAA6C,
    0xA663, 0xB000, 0xAFCD, 0xB1C1, 0xBDDE, 0xBE80, 0xC2B3, 0xC7EC, 0xC593, 0xC91E, 0xD5D3, 0xD043, 0xDF65, 0xD44D, 0xCBCE, 0xDFB5,
    0xCCEE, 0xD4D2, 0xCFEE, 0xC5B8, 0xC329, 0xC970, 0xCA49, 0xCA44, 0xCBD1, 0xC5C8, 0xBD35, 0xC13D, 0xB794, 0xBCB5, 0xB78A, 0xACBC,
    0xAD7D, 0xAC52, 0xADD3, 0xA61A, 0xA7F1, 0x9E9D, 0xACF3, 0xAE06, 0xB356, 0xAA21, 0xB292, 0xB175, 0xB111, 0xB08D, 0xAF5E, 0xB56D,
    0xAB99, 0xB81B, 0xB1A6, 0xB552, 0xAB83, 0xB4B5, 0xB803, 0xA749, 0xB13E, 0xADB2, 0xB0AC, 0xB6E4, 0xB036, 0xB9EA, 0xB4F4, 0xB9C6,
    0xBD2E, 0xBF27, 0xB8A3, 0xC19F, 0xC7BB, 0xB674, 0xC2EC, 0xC352, 0xC15F, 0xB993, 0xC345, 0xC1A4, 0xC5B8, 0xC252, 0xC3BA, 0xD1B8,
    0xC86C, 0xD128, 0xD5C3, 0xD8F9, 0xD834, 0xE454, 0xD854, 0xDAE5, 0xE484, 0xDFD1, 0xE70B, 0xE0CE, 0xF2DA, 0xE73C, 0xE228, 0xE945,
    0xE2F5, 0xE396, 0xF0A0, 0xE9B3, 0xDDD9, 0xED3F, 0xE2E3, 0xE65B, 0xE3D3, 0xDF9B, 0xED7B, 0xF3DF, 0xEE65, 0xF88A, 0xF1FB, 0xF991,
    0xF8DC, 0xF02A, 0xF938, 0xEC31, 0xFF93, 0xF8C1, 0xF522, 0xFCA6, 0xF6F2, 0xF2F2, 0xEA47, 0xF3AC, 0xE857, 0xDC81, 0xEEBE, 0xE439,
    0xE0F5, 0xE7BA, 0xF049, 0xE535, 0xE279, 0xEB36, 0xE8F2, 0xF046, 0xEB0D, 0xF164, 0xF074, 0xF872, 0xFB3C, 0x05E1, 0x0E21, 0x1289,
    0x2147, 0x210F, 0x2980, 0x340A, 0x36BE, 0x4396, 0x45C0, 0x3D24, 0x404A, 0x429B, 0x41D6, 0x4404, 0x410F, 0x49CE, 0x4AAD, 0x413D,
    0x500C, 0x48D6, 0x4774, 0x5035, 0x4529, 0x4CA3, 0x3D97, 0x4637, 0x45E5, 0x3877, 0x377C, 0x306B, 0x33B8, 0x33F7, 0x3CA5, 0x338D,
    0x4016, 0x3BDB, 0x4AC2, 0x4251, 0x3ED1, 0x4A08, 0x4581, 0x482A, 0x4BBA, 0x5314, 0x4C45, 0x4CF9, 0x49EC, 0x4AC0, 0x4477, 0x4407,
    0x4724, 0x41CD, 0x3CDD, 0x4B7C, 0x3D0D, 0x469C, 0x5557, 0x4A33, 0x484A, 0x52D7, 0x4EAA, 0x5A3B, 0x569D, 0x52BF, 0x5D29, 0x51F5,
    0x5A09, 0x4FAE, 0x4D9B, 0x5012, 0x4C1A, 0x3F12, 0x4A2B, 0x4A60, 0x4C0D, 0x41FB, 0x4B3D, 0x4FAD, 0x4722, 0x4F97, 0x40DB, 0x4EDD,
    0x488B, 0x4DCF, 0x50F2, 0x4C85, 0x508E, 0x48AC, 0x47D3, 0x4670, 0x465A, 0x43DC, 0x3E5F, 0x3DEA, 0x3768, 0x35D1, 0x3867, 0x2DE4,
    0x3372, 0x3165, 0x35D6, 0x3AF4, 0x3EC3, 0x493C, 0x3F03, 0x3DCE, 0x3630, 0x382D, 0x27CD, 0x2494, 0x1BF7, 0x0958, 0x08E0, 0xEF11,
    0xF799, 0xF017, 0xF1FF, 0xEE23, 0xE5B2, 0xE972, 0xE3E7, 0xEB27, 0xE454, 0xE9D9, 0xEF24, 0xEFBD, 0xEBF8, 0xEAB2, 0xE368, 0xE5C1,
    0xEA46, 0xE306, 0xE7EA, 0xED89, 0xED1B, 0xF1EB, 0xF3E3, 0xF1EA, 0xFA9E, 0x0091, 0x0701, 0x0C96, 0x1047, 0x1537, 0x1DC3, 0x1F27,
    0x20EE, 0x1E83, 0x2495, 0x22FB, 0x2604, 0x39C9, 0x355B, 0x39D3, 0x3ABB, 0x3EDE, 0x382A, 0x30C7, 0x2EFF, 0x2F8B, 0x30A1, 0x22E4,
    0x24E8, 0x19DA, 0x08E5, 0x0760, 0xF979, 0xE541, 0xE617, 0xE408, 0xDA16, 0xCF9D, 0xD6EA, 0xDAFD, 0xD944, 0xD830, 0xD774, 0xD839,
    0xDAD5, 0xDA7F, 0xD9D6, 0xDFB2, 0xD39E, 0xD9BC, 0xD2A4, 0xCA3D, 0xC0C0, 0xBC77, 0xBD5B, 0xB8A6, 0xBA87, 0xBF95, 0xC78A, 0xC281,
    0xC993, 0xCBF2, 0xCE22, 0xD05C, 0xD3D3, 0xD060, 0xD24E, 0xDFE1, 0xD3BB, 0xDABC, 0xDD85, 0xD3EB, 0xE14F, 0xDAA0, 0xE085, 0xE962,
    0xEEE6, 0xF859, 0xF901, 0xEF7F, 0xEC3E, 0xF0D5, 0xE908, 0xEDE9, 0xEA87, 0xEEE0, 0xEAE1, 0xE867, 0xE88A, 0xDE80, 0xD602, 0xCFAB,
    0xC46E, 0xBDCD, 0xC1AA, 0xB573, 0xB67E, 0xB972, 0xB727, 0xB439, 0xBD0F, 0xBB79, 0xBDE5, 0xC007, 0xC1AC, 0xC8FD, 0xCB3A, 0xD360,
    0xCA4E, 0xC953, 0xC696, 0xC5A1, 0xC5CE, 0xCA06, 0xC66A, 0xC431, 0xC656, 0xC32E, 0xC481, 0xBE84, 0xC422, 0xC241, 0xBA03, 0xC1C5,
    0xC265, 0xC0AA, 0xC446, 0xC4AA, 0xCBD3, 0xC892, 0xC7B7, 0xD108, 0xDF7D, 0xDD9F, 0xECFC, 0xFD0B, 0xF4A6, 0xF835, 0xF0C6, 0xEF4B,
    0xEFA7, 0xF562, 0xFAAD, 0x00CE, 0xFFB4, 0x04C0, 0xF96B, 0xF0F9, 0xEF86, 0xDE46, 0xDBB0, 0xCD04, 0xCF8D, 0xD0D5, 0xD143, 0xDA1B,
    0xD45A, 0xD50F, 0xE2AB, 0xDEB7, 0xE50F, 0xE28E, 0xE8B1, 0xE9C7, 0xE337, 0xEBD1, 0xDCE3, 0xD9EF, 0xD20D, 0xD2DD, 0xD630, 0xD748,
    0xD2D7, 0xD765, 0xDBAA, 0xDB5F, 0xE414, 0xE762, 0xEE2F, 0xEC8A, 0xF081, 0xF98E, 0xF397, 0xFB29, 0x03FC, 0xFA79, 0xFAAB, 0xFF42,
    0x06AD, 0x085C, 0x0D5D, 0x1B46, 0x2452, 0x2712, 0x3096, 0x37F3, 0x342D, 0x3A05, 0x3AB4, 0x384B, 0x4184, 0x3DE9, 0x4558, 0x39C2,
    0x3450, 0x2EE3, 0x1AC2, 0x190C, 0x0672, 0xFFAD, 0xF84A, 0xF921, 0xFD6A, 0xF6DC, 0xF86E, 0x0086, 0xF686, 0x00F6, 0x0475, 0xFD7F,
    0x1432, 0x18AC, 0x1BE1, 0x257D, 0x1D9F, 0x1F54, 0x1F77, 0x242C, 0x24E9, 0x1FF7, 0x2949, 0x2435, 0x1D0F, 0x1DD6, 0x2602, 0x1E76,
    0x2E96, 0x27DF, 0x2FED, 0x2FD0, 0x2F1E, 0x3BB8, 0x3485, 0x3937, 0x404E, 0x502D, 0x48F0, 0x58C4, 0x5B85, 0x6690, 0x6C02, 0x68CA,
    0x6BAA, 0x6695, 0x62CD, 0x5CA1, 0x54E6, 0x54E9, 0x55E6, 0x57C4, 0x527F, 0x4653, 0x4579, 0x3F53, 0x3367, 0x23EC, 0x1C58, 0x11C2,
    0x0F9E, 0x11B1, 0x1267, 0x103B, 0x14FF, 0x0E6A, 0x0D63, 0x0CB6, 0x11D2, 0x1676, 0x1DA5, 0x2858, 0x3278, 0x33AF, 0x3191, 0x334E,
    0x2DE1, 0x328F, 0x2F60, 0x3684, 0x2FF9, 0x3566, 0x3819, 0x3E53, 0x411F, 0x498E, 0x4E34, 0x4EC2, 0x524E, 0x50B7, 0x5796, 0x48C3,
    0x4E95, 0x4960, 0x418C, 0x46B1, 0x4351, 0x47B6, 0x48E3, 0x5273, 0x56C8, 0x55A3, 0x5BE6, 0x5683, 0x5B96, 0x56F8, 0x57A1, 0x5912,
    0x5DEA, 0x5D18, 0x5C1A, 0x58DC, 0x50F5, 0x504D, 0x4030, 0x3885, 0x2CD6, 0x2BE3, 0x2284, 0x2029, 0x1B6C, 0x1D8C, 0x1F6E, 0x1BB7,
    0x1EE5, 0x1DFF, 0x2401, 0x29CC, 0x2FDB, 0x3494, 0x38BB, 0x3343, 0x3385, 0x2FB3, 0x2510, 0x1C02, 0x2324, 0x1B8C, 0x1A6D, 0x1915,
    0x1782, 0x1A51, 0x1507, 0x1A6D, 0x15D5, 0x1728, 0x16B5, 0x1FC4, 0x1C72, 0x215C, 0x2693, 0x22AB, 0x2B72, 0x2D13, 0x3531, 0x3ACD,
    0x44E5, 0x4D00, 0x4D91, 0x4E57, 0x4DF2, 0x46B8, 0x3F5F, 0x3B64, 0x3C78, 0x3A32, 0x4240, 0x3D03, 0x367C, 0x36F9, 0x2AF7, 0x292A,
    0x1AAB, 0x19D7, 0x0E1D, 0x09D3, 0x0D12, 0x06F3, 0x02D2, 0x0539, 0x01FE, 0xF86D, 0xF927, 0xEE19, 0xED71, 0xE84B, 0xEF07, 0xEF83,
    0xEF0E, 0xF123, 0xE7C8, 0xE15A, 0xD88E, 0xD749, 0xD3F1, 0xD2E9, 0xD1F5, 0xCFCC, 0xD0A3, 0xCFF5, 0xD478, 0xD2AE, 0xCA3F, 0xD0F4,
    0xCE27, 0xD0CA, 0xD23C, 0xD2DF, 0xDA33, 0xD690, 0xDD9E, 0xDE3A, 0xE871, 0xE8C9, 0xF645, 0x00F4, 0xFE64, 0x0821, 0x09F9, 0x0D38,
    0x060E, 0x0B6B, 0x0F8A, 0x13AA, 0x1158, 0x11DA, 0x0B6F, 0x0166, 0xFF11, 0xEE9D, 0xE2AA, 0xD59F, 0xCC54, 0xC58C, 0xBE67, 0xB8E6,
    0xB64B, 0xB647, 0xB054, 0xB186, 0xAFD6, 0xAE8C, 0xB658, 0xB443, 0xB986, 0xC070, 0xC07E, 0xC31D, 0xBFE1, 0xBCB5, 0xBA30, 0xBAF3,
    0xB7C7, 0xB5C3, 0xBB64, 0xB88E, 0xBBB6, 0xBDC2, 0xBF8E, 0xBF91, 0xC4B7, 0xC6F9, 0xCB00, 0xD220, 0xD254, 0xDA30, 0xD8B9, 0xD919,
    0xDA72, 0xD89C, 0xDADC, 0xDDC5, 0xE382, 0xE899, 0xED3A, 0xF05A, 0xEC26, 0xE87D, 0xE372, 0xE11D, 0xE1CA, 0xE0D6, 0xE23F, 0xE1A2,
    0xDE48, 0xDD1A, 0xD82A, 0xD527, 0xCF96, 0xCB12, 0xC93E, 0xC3C3, 0xC747, 0xC468, 0xC07B, 0xBECC, 0xBC86, 0xB6B7, 0xB3A7, 0xB40A,
    0xB114, 0xB3DC, 0xB729, 0xB9E5, 0xBDDB, 0xBA09, 0xB5EB, 0xB587, 0xB1A5, 0xB15B, 0xB48F, 0xBC04, 0xBC16, 0xC34B, 0xC4B2, 0xC787,
    0xCC60, 0xC653, 0xCCD6, 0xC9D4, 0xC838, 0xC9FE, 0xCBFF, 0xCB3A, 0xCBFB, 0xCDF8, 0xC9BC, 0xC9A9, 0xCD1B, 0xD3A8, 0xD7F1, 0xE204,
    0xEAF7, 0xEA13, 0xE9D0, 0xE691, 0xE25D, 0xDEE5, 0xDF0F, 0xE050, 0xDDF5, 0xDE9E, 0xDCE9, 0xDBB7, 0xD4B5, 0xD346, 0xCD63, 0xCA03,
    0xC956, 0xC469, 0xC3D1, 0xC106, 0xC7DC, 0xC2B1, 0xC4A3, 0xC3F4, 0xC730, 0xCC07, 0xCFBB, 0xD84A, 0xDA39, 0xE471, 0xE23E, 0xE237,
    0xDE97, 0xD78B, 0xD58A, 0xD090, 0xC9C2, 0xC9C9, 0xC55F, 0xC84B, 0xC575, 0xC37A, 0xC672, 0xC247, 0xC8E8, 0xC726, 0xCE21, 0xD143,
    0xD36B, 0xDDF2, 0xDFA1, 0xE3CB, 0xE5F7, 0xE8A7, 0xF324, 0xF661, 0x0307, 0x0C43, 0x160A, 0x19FB, 0x1BF8, 0x2079, 0x18C3, 0x1E1B,
    0x1DD4, 0x1F0F, 0x21E9, 0x26F5, 0x2A37, 0x2803, 0x22B2, 0x1B52, 0x1275, 0x0A02, 0x0084, 0xFBA5, 0xF60C, 0xEF73, 0xF326, 0xEE2D,
    0xEB73, 0xE6EB, 0xE990, 0xE693, 0xE6C5, 0xED30, 0xEE75, 0xF45E, 0xF4A4, 0xF3BB, 0xF289, 0xF631, 0xF7C2, 0xF9C1, 0xFE42, 0xFF60,
    0x031D, 0x07CE, 0x04DC, 0x0A83, 0x07EC, 0x0768, 0x0842, 0x04B4, 0x0457, 0x00F4, 0x03E6, 0x0247, 0x042B, 0x0387, 0x0583, 0x0969,
    0x0A8C, 0x119F, 0x2054, 0x2ABC, 0x385B, 0x4414, 0x4718, 0x4719, 0x4AF7, 0x4A6E, 0x4636, 0x4886, 0x48A7, 0x47C5, 0x4479, 0x4082,
    0x348F, 0x2BB1, 0x20D0, 0x18BF, 0x0E52, 0x060B, 0x0351, 0x02AC, 0xFD6D, 0xF9E0, 0xF50E, 0xEF38, 0xEA6E, 0xE327, 0xE97D, 0xE707,
    0xEB41, 0xEE49, 0xF0DF, 0xEEE7, 0xF011, 0xF012, 0xEEB5, 0xF3B1, 0xF407, 0xFA58, 0xFB0A, 0xFF31, 0x0092, 0x05B1, 0x0676, 0x0B62,
    0x143F, 0x189C, 0x1DDA, 0x237E, 0x2ADF, 0x2955, 0x2F78, 0x2E1E, 0x2C03, 0x2CA4, 0x2C1F, 0x2E23, 0x34D3, 0x3A0A, 0x3A46, 0x3AE3,
    0x3880, 0x38D8, 0x35D2, 0x3312, 0x3085, 0x3392, 0x35F4, 0x37BA, 0x3D20, 0x3C81, 0x37E1, 0x34D7, 0x2E7F, 0x295F, 0x2293, 0x2087,
    0x19D1, 0x1B1A, 0x1BD8, 0x150F, 0x1490, 0x0E76, 0x0821, 0x098F, 0x0C61, 0x0C30, 0x1852, 0x1B3A, 0x1C71, 0x201D, 0x20CE, 0x1A65,
    0x1B2B, 0x1647, 0x13B5, 0x124F, 0x111A, 0x1037, 0x0D26, 0x102F, 0x09F2, 0x0F3C, 0x0FE2, 0x0B14, 0x0E46, 0x1370, 0x0D5D, 0x0E20,
    0x1030, 0x0D5B, 0x0E49, 0x1573, 0x1986, 0x2540, 0x344D, 0x400B, 0x4689, 0x4A59, 0x4AA5, 0x4750, 0x48BE, 0x42A6, 0x3F6E, 0x3C3C,
    0x3B77, 0x3673, 0x3482, 0x28E3, 0x2473, 0x1B99, 0x0EFD, 0x0964, 0x033F, 0xFEF5, 0xFA1C, 0xFF65, 0xFEBC, 0x05F4, 0x08DD, 0x05D2,
    0x0702, 0x06DB, 0x0708, 0x0A65, 0x0F78, 0x0E5C, 0x0EC5, 0x0DD9, 0x038B, 0xFC92, 0xF7B3, 0xEFF5, 0xEBA4, 0xED4A, 0xEBB6, 0xE86D,
    0xE79F, 0xE47B, 0xE2B4, 0xDFAD, 0xD938, 0xD61D, 0xD74D, 0xD1E3, 0xD20E, 0xD471, 0xD221, 0xD372, 0xD605, 0xD71D, 0xDD0F, 0xE95D,
    0xF296, 0xFD4B, 0x059F, 0x0971, 0x0AC2, 0x0BBA, 0x0E17, 0x0D56, 0x1111, 0x12F6, 0x1846, 0x1D7B, 0x1AE3, 0x1CAF, 0x19AC, 0x1006,
    0x0562, 0xFDC6, 0xF11E, 0xE8F2, 0xE512, 0xDDF1, 0xDB3F, 0xD7B0, 0xD053, 0xCB44, 0xC70E, 0xC16B, 0xC4DD, 0xC7E5, 0xCA6D, 0xCF1F,
    0xD3C9, 0xD298, 0xD2CE, 0xD8A9, 0xD2E6, 0xD1CC, 0xD776, 0xD6AC, 0xD72F, 0xD97F, 0xDA86, 0xD8E9, 0xD8DA, 0xD36E, 0xD093, 0xD538,
    0xD470, 0xD4C4, 0xDB35, 0xD996, 0xDBD6, 0xE146, 0xDE5B, 0xE04C, 0xE7E3, 0xF1E9, 0xFB12, 0x0713, 0x0B01, 0x0949, 0x08AB, 0x08D3,
    0x04B6, 0x0532, 0x04EA, 0x0300, 0x058D, 0x000E, 0xFA53, 0xF57B, 0xEDA8, 0xE27C, 0xDCFE, 0xD6A9, 0xCF19, 0xCF15, 0xCCB3, 0xCADC,
    0xCE07, 0xCBB5, 0xC593, 0xC171, 0xBA9D, 0xB673, 0xB97D, 0xBBB0, 0xBF8C, 0xC274, 0xC441, 0xC048, 0xBFBF, 0xBAD7, 0xB443, 0xB904,
    0xB901, 0xBD06, 0xC089, 0xC490, 0xC7F3, 0xCBF0, 0xCDA2, 0xCCFC, 0xD3BC, 0xD876, 0xDA93, 0xDDA9, 0xDFFA, 0xDBFC, 0xDC69, 0xD89F,
    0xD2A4, 0xD3FA, 0xD25E, 0xD72D, 0xE083, 0xE842, 0xEBE7, 0xEFEE, 0xF1B9, 0xEE1F, 0xEC04, 0xEBED, 0xE786, 0xE6C8, 0xE246, 0xDD96,
    0xDC09, 0xD62B, 0xCFE7, 0xCA00, 0xC7D2, 0xC001, 0xBE6D, 0xBAD0, 0xBA6F, 0xBA7F, 0xB923, 0xBA83, 0xB967, 0xB7C9, 0xB5B6, 0xB9D0,
    0xBC4D, 0xBE12, 0xC721, 0xCA63, 0xCB47, 0xD583, 0xD3DA, 0xD1CF, 0xD2CB, 0xD199, 0xCD2A, 0xCF6D, 0xD173, 0xCD24, 0xD143, 0xCF9B,
    0xCB09, 0xCA2B, 0xC98F, 0xC58F, 0xC6CA, 0xC922, 0xC61A, 0xCB94, 0xCC36, 0xC722, 0xC977, 0xCB97, 0xCFB1, 0xDD1A, 0xE970, 0xEF68,
    0xFAF5, 0x02AD, 0x0004, 0x0013, 0x01CB, 0xFE72, 0xFF96, 0x016A, 0x00C3, 0x061D, 0x082E, 0x0368, 0x027E, 0xFFC7, 0xF868, 0xF8C1,
    0xF65A, 0xF1A6, 0xF079, 0xF0F5, 0xEEDF, 0xEC01, 0xEAB8, 0xE2C1, 0xE392, 0xE2E6, 0xE19C, 0xE6DF, 0xE6F9, 0xE4E4, 0xE6FD, 0xE534,
    0xDDC3, 0xDE45, 0xDDDC, 0xDAC0, 0xDC31, 0xE0B2, 0xE0B0, 0xEAF2, 0xF1E3, 0xF14D, 0xF4D2, 0xFA96, 0xFACF, 0xFC37, 0x0045, 0xFDC9,
    0xFFC9, 0x00ED, 0xFE20, 0xF8C1, 0xF5E0, 0xEDC7, 0xF200, 0xF87A, 0xFD69, 0x0B7D, 0x1644, 0x1A62, 0x1E6A, 0x2288, 0x21E3, 0x24EB,
    0x2BE2, 0x2F7D, 0x3494, 0x3C28, 0x3B87, 0x3BE1, 0x35FF, 0x2BEB, 0x22F1, 0x1A68, 0x112D, 0x0AD0, 0x080A, 0x0403, 0x01AE, 0x016C,
    0xFD30, 0xF87C, 0xF812, 0xF42D, 0xF574, 0xF474, 0xEFDE, 0xF01B, 0xEC25, 0xE361, 0xE2C4, 0xE2CE, 0xDE46, 0xE198, 0xE238, 0xDF85,
    0xE399, 0xE757, 0xE6E8, 0xE944, 0xED4B, 0xEDB2, 0xF118, 0xF6F2, 0xF853, 0xFE29, 0x083F, 0x0C19, 0x0FED, 0x145C, 0x156C, 0x1C47,
    0x260F, 0x28F2, 0x30ED, 0x3C8C, 0x3EDB, 0x3E75, 0x40A9, 0x3BDC, 0x353D, 0x3553, 0x2ED7, 0x2BD1, 0x2ED9, 0x2BA9, 0x2844, 0x282F,
    0x2184, 0x193D, 0x1655, 0x0EFE, 0x0A50, 0x0DF9, 0x0CFB, 0x0DE4, 0x1458, 0x11D3, 0x0F0C, 0x0FAE, 0x0DBB, 0x0C3A, 0x1208, 0x1247,
    0x14FE, 0x1D81, 0x1C71, 0x1DAB, 0x20FE, 0x218A, 0x2117, 0x25D1, 0x25B4, 0x250B, 0x2C73, 0x26ED, 0x246F, 0x2A15, 0x2785, 0x25D3,
    0x29EE, 0x2954, 0x25C3, 0x2C8F, 0x2B9F, 0x286A, 0x285C, 0x213B, 0x1C8D, 0x200A, 0x2098, 0x2481, 0x3420, 0x3BE8, 0x4233, 0x4B61,
    0x4E96, 0x4D0A, 0x4FCC, 0x4F13, 0x4B9F, 0x4F85, 0x4FC5, 0x4DA5, 0x4DEA, 0x4790, 0x3CD9, 0x3513, 0x27C3, 0x1A17, 0x12D7, 0x0A9C,
    0x05D8, 0x074C, 0x08F6, 0x0839, 0x0C60, 0x0BEA, 0x09B9, 0x101F, 0x1292, 0x1B62, 0x27C1, 0x2D6D, 0x3348, 0x39F4, 0x398F, 0x37A1,
    0x373C, 0x3263, 0x2EF0, 0x2F19, 0x2B5F, 0x2879, 0x2BCC, 0x284B, 0x25C8, 0x2A72, 0x2737, 0x22F5, 0x25EC, 0x2441, 0x1DCB, 0x194B,
    0x10E5, 0x057A, 0x04C9, 0x02FD, 0x0225, 0x117D, 0x1CC4, 0x23BC, 0x2FCE, 0x3335, 0x3185, 0x35ED, 0x3544, 0x30EF, 0x3422, 0x34A0,
    0x3249, 0x35C8, 0x3758, 0x33B2, 0x32BD, 0x2DA6, 0x2565, 0x21A4, 0x1A5A, 0x1376, 0x145F, 0x1322, 0x0C5D, 0x0B1F, 0x04D2, 0xFC02,
    0xFA0E, 0xF2E2, 0xEE9D, 0xF35D, 0xF485, 0xF3E8, 0xF6F6, 0xF620, 0xF305, 0xF3A8, 0xF3D2, 0xF2B4, 0xF984, 0xFE41, 0x0049, 0x08FD,
    0x0B39, 0x0B62, 0x117A, 0x12C7, 0x0FB0, 0x121C, 0x145E, 0x112B, 0x105A, 0x0E67, 0x0886, 0x08DD, 0x09A1, 0x09A1, 0x12E4, 0x1FA3,
    0x296E, 0x3515, 0x3F60, 0x3E8A, 0x41AE, 0x455D, 0x40D5, 0x417B, 0x440A, 0x424A, 0x42C8, 0x44C9, 0x3FFF, 0x3A40, 0x333D, 0x26AE,
    0x1A48, 0x0EA8, 0x029E, 0xFDB2, 0xFA26, 0xF58A, 0xF388, 0xF2D3, 0xEFDB, 0xEECF, 0xEDEB, 0xE959, 0xEBE0, 0xEFE3, 0xF19E, 0xF453,
    0xF6D1, 0xF463, 0xF081, 0xEBD0, 0xE45B, 0xE03F, 0xDEBE, 0xD9C1, 0xDAFF, 0xDCAD, 0xDB1D, 0xE1BA, 0xE619, 0xE58E, 0xEBA0, 0xF408,
    0xF8FF, 0x0341, 0x07DD, 0x06A7, 0x06A1, 0x05DA, 0x024F, 0x0393, 0x095C, 0x0C1B, 0x13CA, 0x19F0, 0x19E5, 0x1A89, 0x1BFA, 0x18EF,
    0x1966, 0x1C48, 0x1A64, 0x1843, 0x1805, 0x1350, 0x0AC8, 0x05D1, 0xF8C3, 0xEAD7, 0xDFF3, 0xD217, 0xCA2E, 0xC619, 0xC2DB, 0xC16F,
    0xC34F, 0xC241, 0xC2A0, 0xC048, 0xBCC1, 0xBC41, 0xBB7C, 0xBBE7, 0xBDD7, 0xC14A, 0xC3E6, 0xC823, 0xC908, 0xC7DF, 0xC866, 0xC97E,
    0xC8F7, 0xCDC3, 0xD17A, 0xD19F, 0xD6FE, 0xDB32, 0xD5AC, 0xD447, 0xD5EB, 0xD13A, 0xD33A, 0xD674, 0xD10C, 0xCEB1, 0xCE94, 0xC50B,
    0xC284, 0xC70E, 0xC8A9, 0xD207, 0xE1D8, 0xE71E, 0xEDBE, 0xF9C7, 0xF995, 0xFAC1, 0x0214, 0xFF93, 0xFFEA, 0x068F, 0x0279, 0xFC4C,
    0xFA9B, 0xF43B, 0xE966, 0xE468, 0xDD2A, 0xD601, 0xD5DA, 0xD338, 0xCF8D, 0xD0C7, 0xD216, 0xD170, 0xD3C3, 0xD2E0, 0xD067, 0xD318,
    0xD616, 0xD69C, 0xDBBC, 0xE1DE, 0xE2ED, 0xE3E5, 0xE131, 0xDAF4, 0xD463, 0xCFB2, 0xCC40, 0xCAD3, 0xCAF0, 0xCCEC, 0xCFF6, 0xCF1D,
    0xCF6E, 0xD1AD, 0xD3D9, 0xD7FF, 0xDEAF, 0xE1AC, 0xE2EE, 0xE545, 0xE1DD, 0xDD22, 0xDD2F, 0xDD3E, 0xE0B8, 0xE835, 0xECF3, 0xF145,
    0xF673, 0xF6FE, 0xF4D4, 0xF7A4, 0xF8E9, 0xF91C, 0xFF76, 0x0592, 0x07C4, 0x0D57, 0x112D, 0x10E7, 0x1047, 0x0AE8, 0x044A, 0xFF16,
    0xFA73, 0xF34E, 0xEED3, 0xEB62, 0xE6E3, 0xE26A, 0xDC8E, 0xD850, 0xD6C8, 0xD6CA, 0xD794, 0xDB3B, 0xDD61, 0xDE5A, 0xDDAD, 0xDA19,
    0xD654, 0xD38F, 0xD033, 0xCE63, 0xCC11, 0xC7E8, 0xC860, 0xCC22, 0xCE36, 0xD18C, 0xD686, 0xD5BA, 0xD631, 0xDA24, 0xD797, 0xD715,
    0xDAC2, 0xD884, 0xD868, 0xDA5C, 0xDB32, 0xDE56, 0xE88F, 0xF3E8, 0xFDCE, 0x0ECD, 0x19E9, 0x1FD2, 0x278F, 0x278D, 0x246D, 0x27C5,
    0x27E8, 0x23D8, 0x2732, 0x2657, 0x1EC5, 0x19EB, 0x1146, 0x04E5, 0xFAE9, 0xF536, 0xED79, 0xEAF2, 0xEC27, 0xE9BA, 0xEB2D, 0xE9E7,
    0xE784, 0xE8D6, 0xEB1D, 0xEA93, 0xED1E, 0xF033, 0xF0AD, 0xF3F5, 0xF4ED, 0xF246, 0xF0CF, 0xF07D, 0xEFBA, 0xF240, 0xF459, 0xF5DB,
    0xFCA9, 0x02F1, 0x04D4, 0x0B41, 0x1147, 0x1162, 0x1703, 0x1C7F, 0x1ED3, 0x25E5, 0x2A51, 0x2707, 0x2644, 0x25D9, 0x2144, 0x221E,
    0x24E0, 0x2504, 0x2A34, 0x32FA, 0x353B, 0x38FB, 0x3D27, 0x3B8B, 0x3BCA, 0x3E38, 0x3D36, 0x3E4B, 0x44B2, 0x468B, 0x46A6, 0x4530,
    0x4009, 0x37DB, 0x30A2, 0x27AA, 0x1CCF, 0x16DE, 0x12BF, 0x0D9A, 0x07A9, 0x0253, 0xFAEA, 0xF558, 0xF301, 0xF21D, 0xF400, 0xFA5D,
    0x02D9, 0x09ED, 0x1149, 0x15CA, 0x185C, 0x1C22, 0x1F67, 0x2031, 0x2271, 0x24A0, 0x2343, 0x21C5, 0x22F2, 0x22C8, 0x22B7, 0x2680,
    0x2750, 0x2838, 0x2C23, 0x2C94, 0x2AAD, 0x2979, 0x24AD, 0x1E67, 0x1C41, 0x1B7E, 0x1BBB, 0x20FB, 0x26C7, 0x2B04, 0x30DF, 0x355F,
    0x35A1, 0x371B, 0x38F1, 0x36C7, 0x3701, 0x3866, 0x3703, 0x36AC, 0x35EE, 0x2EB9, 0x275B, 0x20F5, 0x16F5, 0x0E4B, 0x0CFD, 0x0CA0,
    0x0E35, 0x11C5, 0x1095, 0x1066, 0x0F27, 0x0D1A, 0x0CB7, 0x0DEE, 0x0E95, 0x1177, 0x1598, 0x1543, 0x129B, 0x0F51, 0x0AF9, 0x05EB,
    0x02CA, 0xFE5D, 0xFCBD, 0xFD52, 0xFC7B, 0xFDEB, 0x018C, 0x0460, 0x09D7, 0x0FDA, 0x10EA, 0x15DD, 0x19F3, 0x180D, 0x17B4, 0x1793,
    0x1023, 0x0A19, 0x0B0B, 0x0A0E, 0x0C4F, 0x1883, 0x238A, 0x2D1A, 0x3B68, 0x421C, 0x4467, 0x4AE4, 0x4CDE, 0x4B58, 0x50AF, 0x5577,
    0x567F, 0x5A90, 0x5A61, 0x5308, 0x4EDB, 0x4867, 0x3A7F, 0x31BA, 0x2BB4, 0x21A8, 0x1B1A, 0x163F, 0x0C34, 0x04E0, 0x02CB, 0xFE54,
    0xFA05, 0xFB00, 0xFAF0, 0xFB54, 0x0192, 0x0532, 0x0745, 0x0D12, 0x0DF8, 0x0A12, 0x091C, 0x06CB, 0x0283, 0x027C, 0x021F, 0xFEF8,
    0xFECD, 0xFED8, 0xFB41, 0xF8FF, 0xF8A1, 0xF7AB, 0xF974, 0xFC92, 0xFD23, 0xFBF7, 0xFBD4, 0xFCA5, 0xFEB6, 0x0574, 0x0F05, 0x19B1,
    0x24A0, 0x2C3A, 0x3115, 0x34B7, 0x37D0, 0x399E, 0x3B93, 0x3E0C, 0x4052, 0x4303, 0x4326, 0x40C3, 0x3E2C, 0x3A70, 0x324E, 0x28B4,
    0x1CE7, 0x0F35, 0x03CA, 0xF9DC, 0xF278, 0xECB5, 0xE7CF, 0xE266, 0xDE09, 0xD89D, 0xD336, 0xD115, 0xD0C0, 0xD19A, 0xD3F3, 0xD68C,
    0xD622, 0xD49C, 0xD2D2, 0xCE6A, 0xCBE4, 0xCC61, 0xCDAF, 0xD088, 0xD57D, 0xD9CF, 0xDC6B, 0xE151, 0xE495, 0xE897, 0xEFD7, 0xF4DD,
    0xF888, 0xFBF1, 0xFAB9, 0xF435, 0xF047, 0xEB98, 0xE4FF, 0xE540, 0xE821, 0xEAD5, 0xF132, 0xF710, 0xF868, 0xFD36, 0x0427, 0x0597,
    0x0935, 0x0EF1, 0x1193, 0x1608, 0x1C8A, 0x1A2F, 0x16F8, 0x167F, 0x0C2E, 0x00B6, 0xF99A, 0xEFB8, 0xE83E, 0xE944, 0xE63E, 0xE153,
    0xE466, 0xE3A9, 0xDF16, 0xE0A8, 0xE179, 0xE009, 0xE5F5, 0xEC2A, 0xED46, 0xF580, 0xFC80, 0xFC53, 0xFE75, 0xFD57, 0xF731, 0xF379,
    0xF211, 0xEC6B, 0xEB36, 0xED3A, 0xE9A2, 0xE7D1, 0xE8B8, 0xE627, 0xE65B, 0xEB40, 0xEE5A, 0xEFF0, 0xF2A7, 0xF271, 0xEF45, 0xF0EF,
    0xF093, 0xF253, 0xFA51, 0x04D2, 0x0CC4, 0x11A1, 0x1798, 0x176B, 0x143D, 0x1306, 0x11F2, 0x1121, 0x126C, 0x12E7, 0x0E8E, 0x0BD1,
    0x092F, 0x037D, 0x00E4, 0x00C7, 0xFD9D, 0xFD75, 0xFF09, 0xFC28, 0xF879, 0xF88D, 0xF828, 0xF422, 0xF469, 0xF324, 0xEEE0, 0xEFED,
    0xF2EA, 0xF1F7, 0xF7A8, 0x0093, 0x0159, 0x040F, 0x04B3, 0xFD65, 0xF58B, 0xF049, 0xE95B, 0xE47B, 0xE605, 0xE540, 0xE1DE, 0xE1B8,
    0xDFC3, 0xDBD3, 0xDC14, 0xDF4A, 0xDF56, 0xDF2C, 0xE06E, 0xDB5F, 0xD462, 0xD292, 0xD0E0, 0xCFBF, 0xD865, 0xE295, 0xE67C, 0xF0DB,
    0xFC19, 0xFD55, 0x036D, 0x0E6B, 0x10C6, 0x178B, 0x23B0, 0x2426, 0x236B, 0x290A, 0x24A5, 0x1BE4, 0x1B68, 0x11D5, 0x0311, 0xFEF9,
    0xF549, 0xE4F4, 0xE256, 0xE003, 0xD600, 0xD778, 0xD8C8, 0xD06C, 0xD238, 0xD827, 0xD5BA, 0xDC71, 0xE88C, 0xE9A5, 0xEC41, 0xF189,
    0xEBA0, 0xE514, 0xE5E7, 0xE1E6, 0xDF84, 0xE652, 0xE75E, 0xE6F3, 0xEBDC, 0xEC45, 0xEBF9, 0xF24E, 0xF7AE, 0xFB07, 0x0287, 0x06E2,
    0x0749, 0x088B, 0x088D, 0x0744, 0x0A45, 0x0FDC, 0x1500, 0x1AEA, 0x2100, 0x2579, 0x2855, 0x2A24, 0x2AC8, 0x2A74, 0x299A, 0x29FB,
    0x28E2, 0x272C, 0x2880, 0x28C7, 0x2668, 0x252B, 0x20FD, 0x190E, 0x152F, 0x1044, 0x092C, 0x06B2, 0x058A, 0xFFB1, 0xFB3D, 0xF7F1,
    0xECF8, 0xE681, 0xE3E7, 0xDC82, 0xD9C2, 0xDCF8, 0xDAF3, 0xD9CE, 0xDCF4, 0xDB54, 0xD97F, 0xDD39, 0xDFC1, 0xE161, 0xE84D, 0xED61,
    0xEF8C, 0xF437, 0xF75A, 0xF72F, 0xFB38, 0x0093, 0x0348, 0x06AD, 0x0CA8, 0x0F70, 0x0F96, 0x10A0, 0x0F52, 0x0BC6, 0x0C4A, 0x1028,
    0x0F0E, 0x1239, 0x189F, 0x1929, 0x195D, 0x1D7E, 0x1C9F, 0x1A20, 0x1FEA, 0x1FC9, 0x1B4A, 0x1E0E, 0x1C69, 0x1473, 0x1249, 0x0C69,
    0xFF4A, 0xF9F4, 0xF3C2, 0xE6FC, 0xE27E, 0xE038, 0xD8E0, 0xD896, 0xDA77, 0xD4E3, 0xD526, 0xD99F, 0xD634, 0xD87E, 0xE24F, 0xE48C,
    0xEA03, 0xF4D2, 0xF520, 0xF422, 0xF70C, 0xF0FB, 0xE9B0, 0xEA3E, 0xE4F8, 0xDF0B, 0xE08D, 0xDCD7, 0xD653, 0xD7D4, 0xD81C, 0xD7CD,
    0xE047, 0xE774, 0xEA4D, 0xF084, 0xF327, 0xEDEB, 0xED0A, 0xEDA7, 0xEC71, 0xF00D, 0xF612, 0xFB1E, 0x0201, 0x0A55, 0x1069, 0x1621,
    0x1D09, 0x239D, 0x2794, 0x2A81, 0x2D3D, 0x2EF6, 0x3089, 0x33E9, 0x352F, 0x329E, 0x30A1, 0x2CA1, 0x22D3, 0x1C2B, 0x1865, 0x1121,
    0x0E6F, 0x0DB3, 0x05E3, 0xFE89, 0xFBDE, 0xF23B, 0xEB16, 0xED77, 0xEC06, 0xEBCC, 0xF30E, 0xF5C2, 0xF3DE, 0xF7AB, 0xF946, 0xF646,
    0xF9C9, 0xFD01, 0xFA31, 0xFC79, 0xFE53, 0xF9D4, 0xF8E9, 0xFB3A, 0xFA27, 0xF9D3, 0xFB5B, 0xF7E4, 0xF24F, 0xEE95, 0xE80C, 0xE036,
    0xDD2A, 0xDB97, 0xD992, 0xDCC2, 0xE4E4, 0xED48, 0xF82C, 0x0728, 0x1169, 0x1987, 0x23DE, 0x2A27, 0x2C07, 0x320B, 0x377B, 0x3851,
    0x3E48, 0x4226, 0x3E74, 0x3CE1, 0x3B67, 0x3102, 0x2907, 0x24CF, 0x1A15, 0x1241, 0x0DC4, 0x0120, 0xF60C, 0xF11D, 0xE68A, 0xDF64,
    0xE0E7, 0xDDB4, 0xDB48, 0xE0BB, 0xDFB0, 0xDC5A, 0xDF90, 0xDDDB, 0xD885, 0xDA28, 0xD81B, 0xD2F8, 0xD5D9, 0xD663, 0xD33D, 0xD615,
    0xD97F, 0xD7B7, 0xDCB4, 0xE22F, 0xE2B3, 0xE9CA, 0xF13F, 0xF126, 0xF361, 0xF6BA, 0xF2AF, 0xF18E, 0xF351, 0xF306, 0xF630, 0xFE2A,
    0x02F9, 0x0442, 0x0668, 0x05BF, 0x03C2, 0x03DA, 0x0546, 0x084E, 0x0DB3, 0x1466, 0x1994, 0x1A9B, 0x1B05, 0x1ACE, 0x1589, 0x1121,
    0x0D94, 0x059C, 0xFF41, 0xFB28, 0xF377, 0xECFC, 0xED23, 0xE9E5, 0xE541, 0xE6B4, 0xE43A, 0xDFBD, 0xE326, 0xE6AD, 0xE78B, 0xF055,
    0xF97C, 0xFB5B, 0x00A0, 0x051E, 0x0170, 0x01E5, 0x0705, 0x06D2, 0x07C7, 0x0CCE, 0x0AE8, 0x0787, 0x07DE, 0x0597, 0x03C9, 0x06F7,
    0x06D4, 0x02AC, 0x00A3, 0xFC35, 0xF529, 0xF217, 0xF320, 0xF65A, 0xFDD4, 0x0885, 0x106C, 0x151B, 0x1B43, 0x1FD3, 0x218D, 0x2718,
    0x2D37, 0x2EA5, 0x3119, 0x30BD, 0x28C0, 0x20EB, 0x1B8E, 0x1248, 0x08D5, 0x0399, 0xFA72, 0xF24C, 0xF055, 0xEBC6, 0xE8E8, 0xEC6E,
    0xEDC5, 0xED58, 0xF10D, 0xF010, 0xEC19, 0xEF07, 0xF0A2, 0xF186, 0xF9E5, 0x01B8, 0x044C, 0x0BD9, 0x0FCC, 0x0B89, 0x0DAA, 0x0EC1,
    0x0A42, 0x0B9F, 0x0BFB, 0x0626, 0x0424, 0x0228, 0xFAAD, 0xF9AE, 0xFD5B, 0xFAAE, 0xFAFB, 0xFD99, 0xF6E5, 0xF002, 0xECC7, 0xE30B,
    0xDCCE, 0xE056, 0xE26B, 0xE592, 0xED2D, 0xF188, 0xF3C5, 0xF96C, 0xFC98, 0xFE2F, 0x03ED, 0x0A0E, 0x0F4A, 0x1449, 0x184F, 0x19D2,
    0x191D, 0x1773, 0x14FD, 0x1136, 0x0DCB, 0x0B67, 0x0514, 0xFDAE, 0xF7A6, 0xEF52, 0xE626, 0xE05F, 0xD9C5, 0xD1B2, 0xCF0C, 0xCD78,
    0xCAD9, 0xCEF3, 0xD5FF, 0xD997, 0xE0F5, 0xE829, 0xE71B, 0xE6EF, 0xE905, 0xE548, 0xE3A2, 0xE870, 0xE9A1, 0xEA9F, 0xEFA1, 0xF131,
    0xF1A0, 0xF6A8, 0xFAA7, 0xFBC0, 0xFF7F, 0x02C5, 0x00AA, 0xFFC2, 0xFEF6, 0xFC60, 0xFDE9, 0x06ED, 0x0F9C, 0x17C5, 0x2219, 0x298A,
    0x2CCE, 0x309A, 0x3446, 0x3577, 0x38E1, 0x3D30, 0x3CD4, 0x3A0C, 0x38B4, 0x3159, 0x2C5E, 0x24EA, 0x214E, 0x18C3, 0x1418, 0x1228,
    0x0873, 0x082A, 0x0156, 0xFDEA, 0xFC5F, 0xFB82, 0xF6B4, 0xF5B1, 0xF42D, 0xEDEB, 0xEE73, 0xEE28, 0xEA96, 0xE9C2, 0xE94D, 0xE157,
    0xDDC4, 0xDB0C, 0xD683, 0xD4D8, 0xD7CD, 0xD7DC, 0xDAA6, 0xE07A, 0xE155, 0xE5DE, 0xEED0, 0xF3D7, 0xF94C, 0x01E2, 0x02A7, 0x02C5,
    0x0753, 0x0511, 0x0339, 0x0961, 0x0D33, 0x1120, 0x1BD3, 0x22FA, 0x25CF, 0x2D7B, 0x316E, 0x3069, 0x32C1, 0x33E1, 0x2F8E, 0x2E3B,
    0x2E03, 0x29FF, 0x283D, 0x27DD, 0x2334, 0x1CB0, 0x165A, 0x0CDB, 0x0166, 0xF7E5, 0xF0A0, 0xE850, 0xE24C, 0xDF32, 0xD9F8, 0xD40B,
    0xD1E0, 0xCFF1, 0xCCFC, 0xCEBC, 0xD205, 0xD2F0, 0xD70B, 0xDCBB, 0xDDB7, 0xDFEC, 0xE611, 0xE870, 0xE99C, 0xEF0B, 0xEFA8, 0xED4E,
    0xEE28, 0xEC2A, 0xE86F, 0xE8CF, 0xEA52, 0xE8D8, 0xE8A4, 0xE884, 0xE620, 0xE626, 0xE7ED, 0xE7EA, 0xE8DD, 0xEC00, 0xEF0A, 0xF1CE,
    0xF56E, 0xFA45, 0xFFBF, 0x06C2, 0x0DD6, 0x1376, 0x179B, 0x1B25, 0x1CFC, 0x1DC8, 0x20B3, 0x22DD, 0x2476, 0x25EA, 0x23DE, 0x1F2F,
    0x1B15, 0x15A6, 0x101D, 0x0F79, 0x0F2D, 0x0E14, 0x0E7D, 0x0D2A, 0x0903, 0x0640, 0x0515, 0x022B, 0x02A3, 0x0464, 0x0202, 0x024D,
    0x0222, 0xFD3B, 0xFAB8, 0xFB61, 0xF980, 0xF90F, 0xFB40, 0xF8F5, 0xF651, 0xF6B1, 0xF520, 0xF440, 0xFA3B, 0xFFA9, 0x04A2, 0x0BF1,
    0x0DFB, 0x0DFD, 0x0EE0, 0x0B5F, 0x0585, 0x0148, 0xF96A, 0xF168, 0xEDFC, 0xEA21, 0xE7F7, 0xED01, 0xF2E8, 0xF68F, 0xFF8D, 0x0768,
    0x098B, 0x1066, 0x17D3, 0x19F5, 0x2076, 0x27E8, 0x289B, 0x2940, 0x2AE6, 0x273B, 0x22BD, 0x223E, 0x1FDC, 0x1CC4, 0x1D96, 0x1CD4,
    0x1871, 0x150F, 0x112D, 0x0A80, 0x04E1, 0x01C0, 0xFC3A, 0xF68D, 0xF57D, 0xF486, 0xF169, 0xF155, 0xF367, 0xF209, 0xF172, 0xF254,
    0xEF5D, 0xEB24, 0xE964, 0xE50A, 0xDEB5, 0xDD14, 0xDD05, 0xDC8B, 0xDFC3, 0xE3FC, 0xE5C7, 0xE7C5, 0xE8A0, 0xE716, 0xE445, 0xE29D,
    0xE2A6, 0xE3F1, 0xE836, 0xEEB4, 0xF645, 0xFDF4, 0x0608, 0x0D5E, 0x124E, 0x167D, 0x19A6, 0x19E0, 0x186B, 0x16F6, 0x14AC, 0x12B7,
    0x1148, 0x0FF0, 0x0E50, 0x0C11, 0x09C7, 0x064D, 0x02E4, 0xFED1, 0xFBA8, 0xF873, 0xF46D, 0xF1DF, 0xEEAD, 0xEAE5, 0xE8AC, 0xE64F,
    0xE29B, 0xE307, 0xE507, 0xE476, 0xE639, 0xEA71, 0xEAFA, 0xEC7E, 0xF1B8, 0xF375, 0xF44C, 0xF988, 0xFCDF, 0xFCB3, 0x00CE, 0x0566,
    0x0909, 0x1035, 0x1797, 0x1C0B, 0x2098, 0x23B7, 0x226E, 0x1EFB, 0x1A06, 0x140B, 0x0F7A, 0x0B97, 0x08AC, 0x0ACC, 0x0CAD, 0x0EC7,
    0x14F0, 0x1893, 0x1A91, 0x209A, 0x25DD, 0x27BA, 0x2DC1, 0x33D8, 0x3392, 0x34F9, 0x369F, 0x3009, 0x28F5, 0x2519, 0x1AB5, 0x0E22,
    0x064D, 0xFAD7, 0xED3E, 0xE698, 0xE177, 0xDA75, 0xDA8A, 0xDCE9, 0xD9CE, 0xD85B, 0xDB16, 0xD9D7, 0xD9A9, 0xE017, 0xE485, 0xE6D9,
    0xED96, 0xF33A, 0xF3BD, 0xF75F, 0xFD2A, 0xFF3C, 0x01D0, 0x08EB, 0x09CE, 0x0B32, 0x101D, 0x1274, 0x12FF, 0x1513, 0x194D, 0x19A5,
    0x174E, 0x1397, 0x0E1C, 0x05BC, 0x0243, 0xFEF8, 0xFFF5, 0x036B, 0x07BD, 0x0CBF, 0x0DBB, 0x0F79, 0x0E80, 0x0F19, 0x0F03, 0x110A,
    0x1373, 0x13E4, 0x14CC, 0x12B9, 0x0FB3, 0x0C14, 0x087F, 0x050D, 0x00EA, 0xFCDD, 0xF8D0, 0xF53B, 0xF12C, 0xEEAA, 0xEDF1, 0xED49,
    0xED8A, 0xEC31, 0xE7D0, 0xE288, 0xDDA2, 0xD848, 0xD50E, 0xD578, 0xD692, 0xD90F, 0xDCD6, 0xDE1F, 0xDEC0, 0xE15A, 0xE31E, 0xE4D7,
    0xE7A4, 0xE901, 0xE999, 0xEB21, 0xEC62, 0xEE2B, 0xF293, 0xF776, 0xFB61, 0xFE05, 0xFCF6, 0xF920, 0xF4FA, 0xF051, 0xECFE, 0xEEE3,
    0xF305, 0xF7A7, 0x0121, 0x0956, 0x0DA0, 0x169A, 0x2051, 0x269A, 0x31B3, 0x3D49, 0x4209, 0x46F3, 0x4C30, 0x4A64, 0x46F6, 0x47A0,
    0x4306, 0x3B1C, 0x36F1, 0x2EB5, 0x2132, 0x190C, 0x1149, 0x04FF, 0xFFCA, 0xFE83, 0xF784, 0xF30C, 0xF32A, 0xEEB0, 0xEB9B, 0xEFCE,
    0xF153, 0xF0DD, 0xF6B2, 0xF9A1, 0xF5A7, 0xF5B7, 0xF611, 0xEFB5, 0xEC3C, 0xEA61, 0xE20F, 0xDBC1, 0xDAE5, 0xD7DC, 0xD800, 0xDFA1,
    0xE639, 0xEB6F, 0xF2B5, 0xF41B, 0xF123, 0xF054, 0xEE44, 0xEBEB, 0xEDD4, 0xF16D, 0xF4C4, 0xFC45, 0x049A, 0x0B5A, 0x1575, 0x212F,
    0x2914, 0x3311, 0x3CD9, 0x40C6, 0x44C8, 0x4898, 0x488C, 0x4783, 0x480B, 0x4519, 0x3EBA, 0x38CC, 0x3059, 0x254F, 0x1E21, 0x1770,
    0x0E90, 0x0800, 0x02B1, 0xFA22, 0xF062, 0xE94B, 0xE16B, 0xD9FE, 0xD715, 0xD471, 0xD024, 0xCF88, 0xD007, 0xCD6E, 0xCD97, 0xD062,
    0xD139, 0xD268, 0xD673, 0xD712, 0xD5EB, 0xDA70, 0xDDF2, 0xE134, 0xE8C9, 0xF100, 0xF5A1, 0xFA37, 0xFBC7, 0xF729, 0xF23E, 0xEDE6,
    0xE7EA, 0xE45E, 0xE375, 0xE29A, 0xE4EB, 0xE886, 0xEB26, 0xF057, 0xF7B5, 0xFCC7, 0x0506, 0x0CCD, 0x126A, 0x16F2, 0x1EC1, 0x21F7,
    0x21EB, 0x28D4, 0x286B, 0x25DF, 0x23D0, 0x1FFF, 0x1778, 0x1403, 0x126B, 0x08FA, 0x0775, 0x0824, 0x026B, 0xFED9, 0x00C3, 0xFC69,
    0xFA46, 0xFF29, 0x00C9, 0xFFDD, 0x0471, 0x0830, 0x0339, 0x0567, 0x073E, 0x02D1, 0x0427, 0x0767, 0x0228, 0xFCA8, 0xFBEE, 0xF403,
    0xEDEE, 0xF117, 0xF213, 0xF5F3, 0xFFCC, 0x0564, 0x0731, 0x0AAD, 0x0C7A, 0x096A, 0x0BA0, 0x0CC9, 0x096C, 0x0A61, 0x097F, 0x0528,
    0x0367, 0x02BA, 0xFEE8, 0xFF4F, 0x019C, 0x00C9, 0x03BA, 0x0921, 0x0B6E, 0x0E42, 0x13C4, 0x1628, 0x1553, 0x165A, 0x145A, 0x0DBF,
    0x0B29, 0x0979, 0x04BF, 0x02EA, 0x07AC, 0x07F3, 0x0720, 0x0BEB, 0x0B40, 0x07A1, 0x0C6B, 0x0E8B, 0x0A5D, 0x0F5A, 0x12A7, 0x0DF8,
    0x0E27, 0x1017, 0x0ABC, 0x0A38, 0x0E58, 0x0B45, 0x06B1, 0x0573, 0xFFF0, 0xF7E7, 0xF629, 0xF5AE, 0xF476, 0xF81C, 0xFD23, 0xFB21,
    0xF7E5, 0xF57C, 0xEEC6, 0xE6B8, 0xE461, 0xE160, 0xDD8A, 0xDE1A, 0xE03C, 0xDF22, 0xE2DA, 0xEA11, 0xEF53, 0xFB6D, 0x032B, 0x0A70,
    0x163A, 0x1DDE, 0x2045, 0x258C, 0x2647, 0x2125, 0x2000, 0x18FA, 0x0E5E, 0x08F1, 0x036B, 0xFB51, 0xF73F, 0xF4A0, 0xEDE9, 0xE9C1,
    0xEA4C, 0xE531, 0xE27F, 0xE4E6, 0xE52B, 0xE245, 0xE31B, 0xE72C, 0xE275, 0xE421, 0xE930, 0xE5F7, 0xE706, 0xEE8E, 0xEC09, 0xE8C8,
    0xEFE2, 0xEDEC, 0xE95A, 0xEEEA, 0xF02C, 0xEDA8, 0xF6AD, 0x0098, 0x0361, 0x0D7E, 0x17C9, 0x16E2, 0x18F6, 0x1A2E, 0x1561, 0x125A,
    0x1445, 0x127F, 0x1288, 0x158F, 0x15DD, 0x1710, 0x1757, 0x1809, 0x19A5, 0x1D42, 0x2247, 0x27AD, 0x2B09, 0x300C, 0x3324, 0x3434,
    0x35DB, 0x3685, 0x3618, 0x366F, 0x3485, 0x2F18, 0x297F, 0x2145, 0x162A, 0x0C52, 0x01FA, 0xF68C, 0xEFBB, 0xE92C, 0xE11E, 0xDD0B,
    0xDB3D, 0xD77D, 0xD7F8, 0xDAB0, 0xD978, 0xDBCD, 0xDFDE, 0xDE6E, 0xDE35, 0xE0C6, 0xDFF3, 0xE08E, 0xE610, 0xE996, 0xECF1, 0xF49A,
    0xFC54, 0x0205, 0x0C0F, 0x15D8, 0x1AE0, 0x2034, 0x22FF, 0x1F5E, 0x1B21, 0x197B, 0x14C9, 0x1427, 0x1803, 0x1948, 0x1A7E, 0x1F14,
    0x1F3E, 0x1DAF, 0x21C4, 0x232E, 0x247F, 0x2CA3, 0x2FDA, 0x2C29, 0x2BA6, 0x25C3, 0x1A45, 0x15CD, 0x116B, 0x0796, 0x020C, 0xFD07,
    0xF257, 0xEA88, 0xE7AC, 0xE0A6, 0xDC39, 0xDFA4, 0xE17B, 0xDFFB, 0xE38C, 0xE664, 0xE280, 0xE375, 0xE6EC, 0xE2A1, 0xE0C8, 0xE518,
    0xE02F, 0xDA38, 0xDE37, 0xDCCE, 0xD68E, 0xDC16, 0xDCB0, 0xD486, 0xD91F, 0xDD4F, 0xDA22, 0xE273, 0xEEAA, 0xEFA0, 0xF4B9, 0xFC77,
    0xF708, 0xF270, 0xF440, 0xEF7C, 0xEC9F, 0xF20B, 0xF40E, 0xF54D, 0xFA71, 0xFDAA, 0xFF9D, 0x0495, 0x0DA1, 0x171C, 0x20F5, 0x2CD9,
    0x3662, 0x3B2C, 0x3F3F, 0x41CB, 0x40C9, 0x3FCB, 0x4059, 0x3D25, 0x3795, 0x3314, 0x2AD7, 0x21B5, 0x1AA0, 0x1247, 0x09FC, 0x0517,
    0xFEA2, 0xF7FA, 0xF29C, 0xEF77, 0xECBD, 0xED79, 0xEE7D, 0xF051, 0xF41F, 0xF6F0, 0xFD2D, 0x007B, 0x0501, 0x07D0, 0x083B, 0x0641,
    0x0176, 0xFA9C, 0xF487, 0xF100, 0xEDAB, 0xEF1C, 0xF09E, 0xF0A9, 0xF215, 0xF096, 0xED8C, 0xEC71, 0xE9CF, 0xE723, 0xE6FE, 0xE6A4,
    0xE6A2, 0xEA42, 0xEC8A, 0xEFB0, 0xF786, 0xFDE2, 0x056C, 0x129A, 0x1DD7, 0x2759, 0x354C, 0x3CBD, 0x3E40, 0x43BE, 0x446C, 0x3FF6,
    0x4096, 0x3F9D, 0x37F9, 0x3517, 0x31AC, 0x2729, 0x1F7E, 0x1A60, 0x122F, 0x0AA8, 0x071C, 0x01C9, 0xFA8B, 0xF792, 0xF5AB, 0xEFEB,
    0xEC93, 0xEE85, 0xEAEB, 0xE5C4, 0xE814, 0xE45D, 0xDC13, 0xDE45, 0xDCE8, 0xD323, 0xD451, 0xD643, 0xCF9E, 0xD3BF, 0xDEC7, 0xE071,
    0xE7A8, 0xF54F, 0xF5B1, 0xF38F, 0xF718, 0xF158, 0xE814, 0xE79C, 0xE4B4, 0xDF16, 0xE0AC, 0xE35C, 0xE14C, 0xE322, 0xE8AC, 0xEB29,
    0xF016, 0xF914, 0x009A, 0x0769, 0x10CB, 0x183A, 0x1AE8, 0x1DB7, 0x1FA6, 0x1D57, 0x1B1C, 0x19A3, 0x15E0, 0x1227, 0x0E9C, 0x095E,
    0x02FA, 0xFD6D, 0xF8C1, 0xF497, 0xF1E6, 0xF1DD, 0xF392, 0xF514, 0xF7D9, 0xFA98, 0xFC03, 0xFF2B, 0x0377, 0x0687, 0x0AA5, 0x0F58,
    0x1162, 0x12B6, 0x130D, 0x0EBB, 0x0BB9, 0x0811, 0x0305, 0x0351, 0x053E, 0x056B, 0x092D, 0x0B7D, 0x0744, 0x05F7, 0x052D, 0x009F,
    0xFFBE, 0x021E, 0x0201, 0x05A6, 0x0A24, 0x0B77, 0x0E51, 0x10F5, 0x1161, 0x146D, 0x1555, 0x1572, 0x188C, 0x18D0, 0x1731, 0x1A7F,
    0x1A1D, 0x15FE, 0x187C, 0x1584, 0x0CDD, 0x0AEE, 0x07B1, 0xFDB7, 0xFB33, 0xF840, 0xEFE5, 0xEB93, 0xEB7A, 0xE4F1, 0xE2CB, 0xE611,
    0xE9A9, 0xEAA6, 0xF288, 0xF822, 0xF8E0, 0xFB41, 0x0139, 0x05C2, 0x02E1, 0x1227, 0x130A, 0x1225, 0x163B, 0x13B9, 0x082D, 0x0764,
    0x0C3F, 0x0501, 0x0A4B, 0x1165, 0x10CD, 0x0C34, 0x101A, 0x0A0E, 0x014C, 0x02AC, 0x0018, 0xF766, 0xF653, 0xF726, 0xEB35, 0xE799,
    0xE8ED, 0xE440, 0xE47E, 0xEC13, 0xF08D, 0xF29C, 0xFFC2, 0x07BB, 0x0D6B, 0x15AE, 0x1DAC, 0x1C80, 0x1AA0, 0x1B1A, 0x0FCC, 0x0AF9,
    0x0309, 0xFB84, 0xF423, 0xEC13, 0xE6C4, 0xDEC9, 0xD769, 0xD3B3, 0xD1DE, 0xCFB5, 0xD246, 0xD4F1, 0xD4A9, 0xD65D, 0xDA84, 0xDB21,
    0xDB6F, 0xE249, 0xE609, 0xE7FA, 0xEFD7, 0xF179, 0xEF84, 0xF06B, 0xED6C, 0xE97E, 0xEB20, 0xECB2, 0xF161, 0xF931, 0xFDA8, 0x03F4,
    0x0898, 0x08E8, 0x0B44, 0x0CCC, 0x0A08, 0x0B89, 0x0F36, 0x0ED3, 0x11E1, 0x1799, 0x1723, 0x1964, 0x1EFC, 0x2028, 0x246D, 0x2C22,
    0x30E0, 0x3517, 0x38FD, 0x380F, 0x36B8, 0x33B2, 0x2EF6, 0x2D2B, 0x2B9F, 0x27D5, 0x2753, 0x2488, 0x1D10, 0x1B35, 0x187A, 0x1036,
    0x0B84, 0x07F7, 0xFCE5, 0xF4D5, 0xF00B, 0xE69A, 0xDF05, 0xDE90, 0xDD51, 0xD809, 0xD8F4, 0xDB91, 0xD79D, 0xD8F5, 0xDF48, 0xDDDA,
    0xDC55, 0xE133, 0xDE18, 0xD7E0, 0xDDDB, 0xE280, 0xE351, 0xEE73, 0xFB60, 0xFD46, 0x02D7, 0x0BBD, 0x0981, 0x06F6, 0x0E48, 0x1015,
    0x0CB0, 0x13B0, 0x18D9, 0x13FF, 0x1653, 0x1DFB, 0x1B04, 0x1BF8, 0x285A, 0x2C16, 0x2BC0, 0x3729, 0x3A47, 0x32D5, 0x3641, 0x3732,
    0x2C1A, 0x2ADE, 0x2D56, 0x22EC, 0x1D43, 0x1B6B, 0x0EB3, 0x01C7, 0xFA40, 0xEEB3, 0xE2B3, 0xDD95, 0xDAAC, 0xD6DA, 0xD55F, 0xD796,
    0xD95C, 0xD829, 0xDB08, 0xDF6E, 0xDD7D, 0xDE85, 0xE40A, 0xE153, 0xDE58, 0xE1EB, 0xDD38, 0xD546, 0xD540, 0xD202, 0xCC21, 0xD05E,
    0xD5D6, 0xD798, 0xDDC9, 0xE460, 0xE574, 0xE5DB, 0xE832, 0xE817, 0xE6D7, 0xE8D6, 0xEC0B, 0xED78, 0xEEC8, 0xF418, 0xF6AC, 0xF61E,
    0xFB31, 0x0044, 0x02B2, 0x0A85, 0x1495, 0x1925, 0x1FE8, 0x2839, 0x29C8, 0x2AD2, 0x2E18, 0x2DB9, 0x2BC6, 0x2C34, 0x2B3E, 0x27B7,
    0x24BE, 0x208A, 0x19F5, 0x1371, 0x0F05, 0x0AB2, 0x0826, 0x06D3, 0x0494, 0x0244, 0xFE22, 0xFA23, 0xF7BD, 0xF5BC, 0xF417, 0xF69A,
    0xFAEB, 0xFBC3, 0xFFD0, 0x058E, 0x0426, 0x04BE, 0x0957, 0x0651, 0x03B9, 0x0998, 0x085A, 0x0350, 0x075C, 0x05D6, 0xFCCF, 0xFB47,
    0xF9F1, 0xEF02, 0xEA2E, 0xEB74, 0xE5C6, 0xE20B, 0xE6BD, 0xE6B4, 0xE25A, 0xE6BD, 0xEC18, 0xEAF8, 0xF134, 0xFF9A, 0x04DD, 0x0A72,
    0x1AD9, 0x1FA0, 0x1C5D, 0x26F1, 0x2B69, 0x24B8, 0x2B4E, 0x3103, 0x278F, 0x26F7, 0x2B82, 0x205F, 0x192A, 0x1D2B, 0x15A5, 0x0D9F,
    0x11B0, 0x0EC0, 0x05A5, 0x0564, 0x04E5, 0xFD1B, 0xF935, 0xFB43, 0xF93A, 0xF56B, 0xFA39, 0xFDB0, 0xFB0E, 0xFC49, 0xFEA7, 0xF63F,
    0xECFE, 0xEC22, 0xE4BF, 0xDE2A, 0xE403, 0xE862, 0xE833, 0xEFE2, 0xF76A, 0xF3FC, 0xF356, 0xF7BA, 0xF4EC, 0xEF70, 0xF2DA, 0xF449,
    0xEF1D, 0xEEF6, 0xEF54, 0xE837, 0xE559, 0xEB39, 0xEAA9, 0xEB59, 0xF39E, 0xF72B, 0xF758, 0xFD66, 0x0175, 0xFECD, 0x0036, 0x0358,
    0xFE57, 0xFA6F, 0xFBC1, 0xF8AB, 0xF1BA, 0xEFFF, 0xF0CC, 0xED35, 0xEA2C, 0xE917, 0xE390, 0xDD8C, 0xDFDC, 0xDA83, 0xD703, 0xDA79,
    0xDC80, 0xD6E5, 0xDD8E, 0xE7D1, 0xE448, 0xF19D, 0xF6BB, 0xF4B0, 0xF7F9, 0xF746, 0xF4CD, 0xF736, 0xFA0B, 0xFDF1, 0x069B, 0x0A0E,
    0x0B18, 0x0E46, 0x0CE5, 0x084E, 0x08DE, 0x05ED, 0xFFCD, 0xFE6D, 0xFF3B, 0xFC4C, 0x0005, 0x07A1, 0x0A93, 0x10D6, 0x1AEA, 0x2143,
    0x2464, 0x2B83, 0x32A1, 0x3394, 0x3562, 0x37FC, 0x323F, 0x27DC, 0x2607, 0x1EF0, 0x107B, 0x101A, 0x0CAB, 0xFE12, 0xF8EF, 0xF524,
    0xE4CF, 0xDC85, 0xDEC3, 0xD500, 0xD071, 0xDA78, 0xD6F8, 0xCF8F, 0xD671, 0xD794, 0xD173, 0xD8FB, 0xE269, 0xE1DE, 0xE8D2, 0xF694,
    0xF85F, 0xF91C, 0x00B8, 0x004F, 0xFA8B, 0x0157, 0x0A3F, 0x09FD, 0x10ED, 0x1B70, 0x1B2B, 0x198A, 0x1EB1, 0x1CF2, 0x14EB, 0x1281,
    0x1533, 0x127C, 0x1198, 0x1617, 0x11A1, 0x0B76, 0x0EA4, 0x0D82, 0x0631, 0x09AF, 0x0E20, 0x08B9, 0x0C02, 0x1754, 0x159E, 0x13E8,
    0x1BAC, 0x1BFA, 0x16FA, 0x1910, 0x1596, 0x0AEC, 0x093C, 0x087D, 0xFF77, 0xF78E, 0xF2D4, 0xE7B4, 0xDA43, 0xD4AE, 0xD044, 0xC80C,
    0xC5EF, 0xC860, 0xC365, 0xBF59, 0xC55B, 0xC3C8, 0xBFD8, 0xC943, 0xCE28, 0xCC63, 0xD500, 0xDB1F, 0xD5C4, 0xD85E, 0xDD27, 0xD7CA,
    0xDA16, 0xE41D, 0xE5B8, 0xEA1C, 0xF321, 0xF34E, 0xF0AC, 0xF248, 0xF07C, 0xED31, 0xF0CD, 0xF559, 0xF811, 0xFC6E, 0xFFF8, 0x0263,
    0x076B, 0x0D0B, 0x14C5, 0x1F2D, 0x29BF, 0x32E5, 0x3AAE, 0x410A, 0x450E, 0x47C3, 0x4AA7, 0x4AE8, 0x45CF, 0x4089, 0x3789, 0x2E7F,
    0x2B56, 0x2593, 0x1CDF, 0x1BA7, 0x1B43, 0x15A6, 0x1437, 0x152C, 0x0EE1, 0x0A44, 0x0BC0, 0x0626, 0xFF37, 0xFE39, 0xF725, 0xEC75,
    0xECCA, 0xED1C, 0xE557, 0xE835, 0xECF6, 0xE3CC, 0xDFBF, 0xE29F, 0xDF72, 0xDA94, 0xE20F, 0xE64F, 0xE5F8, 0xF195, 0xF545, 0xED42,
    0xEDD5, 0xF00D, 0xE91F, 0xEBD1, 0xF66A, 0xF62A, 0xF502, 0xFA58, 0xFB8B, 0xF94E, 0xF9E0, 0xFD4C, 0x00D3, 0x0823, 0x14FD, 0x1E6E,
    0x22CC, 0x2CCB, 0x365B, 0x35F1, 0x3825, 0x3DD7, 0x37AD, 0x30F1, 0x3486, 0x2FC9, 0x27DE, 0x2A9B, 0x2719, 0x1A1B, 0x16E9, 0x11D3,
    0x0272, 0xF9D3, 0xF605, 0xEA7E, 0xE091, 0xDF15, 0xD982, 0xD2BB, 0xD2D3, 0xD480, 0xD2AD, 0xD486, 0xDBA6, 0xDC21, 0xDA40, 0xDFE8,
    0xDDC3, 0xD378, 0xD3EF, 0xD557, 0xCD5C, 0xCDB0, 0xD55B, 0xD2C1, 0xD339, 0xDDBF, 0xDC46, 0xD6A1, 0xDBED, 0xDAAD, 0xD3B5, 0xD899,
    0xDEA2, 0xDBEE, 0xE224, 0xEB8D, 0xE831, 0xEA2B, 0xF487, 0xF604, 0xF96F, 0x08CB, 0x1213, 0x15B6, 0x1E51, 0x210F, 0x1C15, 0x1CC6,
    0x1F8A, 0x1D8D, 0x238C, 0x2959, 0x2448, 0x235A, 0x22F2, 0x1D5E, 0x1A88, 0x1C55, 0x1BA2, 0x1B34, 0x1DBC, 0x1D83, 0x1D23, 0x1CDC,
    0x19E7, 0x1647, 0x16D0, 0x1745, 0x1255, 0x0BBB, 0x0867, 0x0253, 0xFDC2, 0xFFAB, 0xFDE1, 0xFC64, 0x00B0, 0x03E2, 0x06A0, 0x127D,
    0x1716, 0x12AF, 0x1862, 0x1AC0, 0x12E3, 0x11D1, 0x111D, 0x0644, 0x04B9, 0x06EC, 0xFCA1, 0xF856, 0xFA68, 0xF2F9, 0xEE46, 0xF25D,
    0xF085, 0xEED2, 0xF61F, 0xFB43, 0xFF59, 0x06AD, 0x0AE9, 0x0A2D, 0x08C3, 0x07A5, 0x0600, 0x0385, 0x040E, 0x05FC, 0x05B7, 0x0473,
    0x065F, 0x055A, 0xFD18, 0xFD47, 0xFCC9, 0xF861, 0xFB3D, 0xFFA6, 0xFCFE, 0xFE3F, 0x0352, 0xFE6D, 0xFAA4, 0xFEA9, 0x0084, 0xFEC8,
    0x04DE, 0x0929, 0x063A, 0x061F, 0x06B3, 0x0190, 0xFAA2, 0xFB8B, 0xFAF8, 0xF757, 0xF9F0, 0xFD61, 0xFA75, 0xF840, 0xF9D7, 0xF2F6,
    0xEC09, 0xEEA5, 0xED17, 0xE6EC, 0xECEB, 0xF4C8, 0xF05B, 0xF46A, 0xFDA4, 0xF954, 0xF957, 0x04FB, 0x0660, 0x0836, 0x16FC, 0x187A,
    0x1233, 0x196D, 0x1A4B, 0x102A, 0x133D, 0x1635, 0x0C5A, 0x0C8D, 0x10D6, 0x0957, 0x04DB, 0x043A, 0xFBE7, 0xF70D, 0xFAE6, 0xFA0C,
    0xF64B, 0xF7FA, 0xF863, 0xF4E1, 0xF3AD, 0xF488, 0xF15B, 0xEC2D, 0xEDF3, 0xF0A1, 0xEFE3, 0xF39F, 0xF6CE, 0xF5D1, 0xFB9B, 0x03A1,
    0x058F, 0x0A30, 0x10E1, 0x122E, 0x162D, 0x1DA2, 0x1ECA, 0x218F, 0x2737, 0x24B8, 0x230A, 0x2390, 0x1AE1, 0x14A7, 0x1435, 0x0C91,
    0x06CB, 0x072F, 0x000A, 0xFCC9, 0x0424, 0x0902, 0x10B6, 0x2127, 0x2BD4, 0x2FF2, 0x362C, 0x3571, 0x2E15, 0x2A91, 0x268A, 0x1FAE,
    0x1E61, 0x1C07, 0x148D, 0x0ED3, 0x08BE, 0xFE6A, 0xF554, 0xEF71, 0xE8DF, 0xE3AA, 0xE0AF, 0xDB7D, 0xD69F, 0xD375, 0xD012, 0xCEC7,
    0xCDD2, 0xCD7D, 0xCFAB, 0xD2CA, 0xD51E, 0xD7D9, 0xDA3D, 0xDBAA, 0xDD14, 0xDDC1, 0xDEAD, 0xE24F, 0xE7C9, 0xEDAC, 0xF729, 0x01AE,
    0x0A1D, 0x10F3, 0x1352, 0x12F9, 0x11F4, 0x0E3C, 0x0C01, 0x0F4D, 0x12B4, 0x1598, 0x1B19, 0x1CA1, 0x1D03, 0x23CD, 0x27AA, 0x295F,
    0x331A, 0x3718, 0x356F, 0x3C3A, 0x3DA4, 0x360C, 0x35BA, 0x33B4, 0x2A21, 0x2A53, 0x2A90, 0x1FC1, 0x1C5D, 0x1B90, 0x1016, 0x0C39,
    0x0DE0, 0x02B2, 0xF9F5, 0xFA18, 0xF2F5, 0xED5D, 0xEF15, 0xE8F7, 0xDF8A, 0xDE4B, 0xDAF5, 0xD2B9, 0xD0C8, 0xD2EC, 0xD2ED, 0xD523,
    0xDC15, 0xDEB8, 0xDD12, 0xE1A0, 0xE554, 0xE328, 0xE79D, 0xEFBA, 0xEF8F, 0xF27C, 0xFB6A, 0xFA70, 0xF7D1, 0xFCAA, 0xFA0A, 0xF3B5,
    0xF709, 0xF682, 0xF017, 0xF1B1, 0xF23B, 0xEE23, 0xF2BE, 0xFBD2, 0xFFB1, 0x0869, 0x1632, 0x1EDD, 0x2768, 0x31FB, 0x3838, 0x3B93,
    0x3E68, 0x3ECA, 0x3D4D, 0x3B50, 0x3903, 0x3707, 0x31CF, 0x2832, 0x2139, 0x1839, 0x0A4A, 0x02AE, 0xFE7D, 0xF7FE, 0xF969, 0xFFEC,
    0xFDB3, 0xFDE4, 0x04E2, 0x0144, 0xFACC, 0xFE62, 0xFE55, 0xFB20, 0xFF7F, 0xFF82, 0xF80D, 0xF4DA, 0xF0EF, 0xE78D, 0xE3DE, 0xE5FA,
    0xE569, 0xE65B, 0xEC10, 0xEF27, 0xEC82, 0xEA18, 0xE97E, 0xE483, 0xDFE8, 0xE316, 0xE3B3, 0xE085, 0xE4E9, 0xE811, 0xE5AF, 0xED8C,
    0xF6AF, 0xF61B, 0xFE1A, 0x0C9B, 0x1217, 0x1BFF, 0x2BA0, 0x3098, 0x3590, 0x4045, 0x42E0, 0x4372, 0x4651, 0x4149, 0x3B4E, 0x3AD8,
    0x378A, 0x338E, 0x3201, 0x2C6C, 0x280A, 0x26C0, 0x2044, 0x1AC7, 0x1941, 0x1279, 0x0D4D, 0x0D12, 0x04ED, 0xFA64, 0xF56F, 0xECED,
    0xE4A6, 0xE66C, 0xE8C1, 0xE80C, 0xED45, 0xF2C3, 0xEFC4, 0xEC7F, 0xECFE, 0xE8D8, 0xE555, 0xEB12, 0xEFF9, 0xEE8E, 0xF01D, 0xEFEC,
    0xE64E, 0xE0B9, 0xE109, 0xDACD, 0xD58F, 0xD89C, 0xD580, 0xCD9F, 0xCFAF, 0xD195, 0xCD98, 0xD3E7, 0xE009, 0xE332, 0xEAA9, 0xF955,
    0xFCA3, 0xFCDA, 0x04CD, 0x0605, 0x0254, 0x06F6, 0x0981, 0x042D, 0x04A6, 0x0712, 0x0196, 0xFD95, 0xFCE4, 0xF85E, 0xF2CC, 0xF09F,
    0xF00D, 0xEFDB, 0xEF02, 0xF140, 0xF497, 0xF316, 0xF4DA, 0xFA65, 0xF915, 0xFA8E, 0x04AE, 0x0581, 0x0124, 0x0752, 0x05B9, 0xF8ED,
    0xF801, 0xF62F, 0xEBB4, 0xEDB3, 0xF7B4, 0xF7B3, 0xFCBC, 0x0915, 0x0B39, 0x0C49, 0x1439, 0x14A6, 0x0F44, 0x0EEE, 0x1057, 0x0C20,
    0x089C, 0x0FA3, 0x0D0E, 0x06DB, 0x0C58, 0x0F5E, 0x0B3A, 0x10CB, 0x1B57, 0x186B, 0x1D34, 0x2BF1, 0x2991, 0x2378, 0x2850, 0x2226,
    0x168B, 0x1A88, 0x19D7, 0x0E21, 0x0ED2, 0x0F87, 0x03D5, 0xFDF8, 0xFD63, 0xF468, 0xEEB8, 0xF46F, 0xF5CA, 0xF4BA, 0xF82E, 0xF95D,
    0xF4C3, 0xF16F, 0xF3EC, 0xF5AA, 0xF77E, 0xFEFC, 0x06B9, 0x0926, 0x0B41, 0x0E7F, 0x0C6A, 0x09BA, 0x0F4C, 0x13D8, 0x1307, 0x1763,
    0x1C31, 0x1839, 0x159C, 0x181E, 0x1311, 0x0A14, 0x0797, 0x0027, 0xF15A, 0xEABA, 0xE9CB, 0xE405, 0xE303, 0xEA78, 0xEAF3, 0xE9F1,
    0xF241, 0xF87A, 0xF8BE, 0x0195, 0x0E03, 0x0D03, 0x0B55, 0x0F8E, 0x082A, 0xFC97, 0xFDB4, 0xFC00, 0xF2FE, 0xF3D0, 0xF34E, 0xE63F,
    0xDF04, 0xDC8B, 0xD1E4, 0xCD8B, 0xD275, 0xD1D7, 0xCF6F, 0xD233, 0xD1B6, 0xCD62, 0xCC3F, 0xCD2C, 0xCDA1, 0xCE96, 0xD1E1, 0xD604,
    0xD56E, 0xD2DE, 0xD510, 0xD368, 0xD005, 0xD6E3, 0xDE7F, 0xDE30, 0xE679, 0xF2F3, 0xF517, 0xFC4B, 0x0AAE, 0x0C84, 0x0A10, 0x127E,
    0x153F, 0x1197, 0x167B, 0x1D56, 0x15E3, 0x17DF, 0x202A, 0x197C, 0x12BE, 0x1857, 0x1A07, 0x13B1, 0x2129, 0x2DAA, 0x2C59, 0x33C9,
    0x4206, 0x3F6F, 0x3D3A, 0x48B5, 0x4572, 0x3AF4, 0x40B4, 0x412D, 0x31A6, 0x3001, 0x3055, 0x1F1C, 0x156D, 0x193B, 0x0F21, 0x0419,
    0x092D, 0x056B, 0xF6C8, 0xF3E3, 0xEF30, 0xDDBB, 0xD85E, 0xDC52, 0xD7BF, 0xD65A, 0xDE18, 0xDE21, 0xD785, 0xD86F, 0xD85C, 0xD1E3,
    0xD1D2, 0xD780, 0xD914, 0xDA8B, 0xE346, 0xEAB8, 0xEC7B, 0xF288, 0xF987, 0xF8D3, 0xF7CA, 0xFC12, 0xFA0C, 0xF3CB, 0xF80B, 0xFC63,
    0xF9B1, 0xFE85, 0x07BB, 0x095C, 0x0DC1, 0x1A31, 0x2186, 0x25C4, 0x2F84, 0x34B2, 0x30BB, 0x302A, 0x3009, 0x2734, 0x1FD0, 0x1F58,
    0x1964, 0x0FF8, 0x0D92, 0x0878, 0xFD82, 0xF9AC, 0xF8FC, 0xF1E0, 0xEF86, 0xF3BA, 0xEF59, 0xEB34, 0xED8F, 0xE965, 0xE456, 0xE41F,
    0xE40D, 0xDF83, 0xDCE0, 0xDB32, 0xD2B9, 0xCD7B, 0xCAF0, 0xC6B2, 0xC323, 0xC255, 0xC230, 0xC36B, 0xC8E2, 0xCEBD, 0xD41A, 0xD8B0,
    0xDD45, 0xE120, 0xE1F8, 0xE2DA, 0xE223, 0xE129, 0xE23F, 0xE4D3, 0xE84A, 0xE9DB, 0xEA87, 0xED9E, 0xF1BF, 0xF511, 0xFE14, 0x08D6,
    0x1012, 0x1BC5, 0x27FD, 0x2C23, 0x3170, 0x3955, 0x3925, 0x3974, 0x4112, 0x4146, 0x3DBB, 0x4255, 0x4022, 0x35A9, 0x32E2, 0x2EC5,
    0x1FE7, 0x1A3C, 0x1B80, 0x10C9, 0x0AF7, 0x0F46, 0x05F6, 0xF9CA, 0xFF1D, 0x00B3, 0xF9B9, 0x033F, 0x0FA3, 0x0B8E, 0x0E3C, 0x180C,
    0x0F5C, 0x0707, 0x0BF3, 0x048C, 0xF9AD, 0x0044, 0x0367, 0xFD06, 0x01AF, 0x08A3, 0x01DC, 0xFE4A, 0x00CD, 0xF8C4, 0xEDD8, 0xEB6E,
    0xE76E, 0xDE29, 0xDBE9, 0xDE59, 0xDA4E, 0xD7D2, 0xDED5, 0xE177, 0xDF9D, 0xE80C, 0xF103, 0xEFBC, 0xF3D3, 0xFE59, 0xFECA, 0xFF84,
    0x0ACB, 0x0EDD, 0x0AB1, 0x0EFE, 0x118C, 0x0922, 0x0791, 0x0C1D, 0x072A, 0x018D, 0x0528, 0x03C6, 0xFC2E, 0xFE94, 0x02A9, 0xFED4,
    0x015D, 0x0A1D, 0x08E8, 0x03E9, 0x0448, 0xFF69, 0xF663, 0xF68F, 0xF846, 0xF10A, 0xEC7D, 0xECA3, 0xE699, 0xE28C, 0xE776, 0xEB8E,
    0xEE63, 0xF732, 0xFEA9, 0xFE44, 0xFD53, 0xFCAB, 0xF7FB, 0xF542, 0xF630, 0xF50E, 0xF29E, 0xEF0B, 0xE941, 0xE447, 0xE085, 0xDD88,
    0xE081, 0xE4BE, 0xE740, 0xEFE1, 0xF861, 0xF9E0, 0x0018, 0x09A9, 0x0BE1, 0x0F01, 0x16F7, 0x158E, 0x0EE7, 0x1037, 0x0C89, 0x02A7,
    0x00E8, 0x0090, 0xF817, 0xF434, 0xF6FB, 0xF2CD, 0xEDCD, 0xF1AE, 0xF133, 0xE89B, 0xE979, 0xECF7, 0xE788, 0xE956, 0xF424, 0xF74F,
    0xFCAE, 0x0C39, 0x123A, 0x10D8, 0x1700, 0x17AB, 0x0E00, 0x0C3C, 0x0CA8, 0x05F3, 0x056F, 0x09DB, 0x085C, 0x0866, 0x0B18, 0x08B8,
    0x05C8, 0x04B1, 0x0271, 0x00DC, 0x0076, 0x0008, 0x01C0, 0x02CF, 0x0294, 0x0513, 0x07D3, 0x0855, 0x0CFD, 0x12F7, 0x13CC, 0x15AF,
    0x1986, 0x191E, 0x1729, 0x17C4, 0x1548, 0x1016, 0x0D0F, 0x083D, 0x000B, 0xF814, 0xF0FB, 0xEAB8, 0xE48F, 0xE04E, 0xDD47, 0xD800,
    0xD1B0, 0xCF45, 0xCE8A, 0xCBFF, 0xCD7E, 0xD18D, 0xD191, 0xD3E4, 0xDB34, 0xDD2E, 0xDCE4, 0xE2E7, 0xE5F2, 0xE54D, 0xEA56, 0xEE8B,
    0xEC49, 0xEDA2, 0xF3F5, 0xF87F, 0xFE99, 0x09D6, 0x12D8, 0x16E5, 0x1CE0, 0x21D8, 0x1EEA, 0x1ADA, 0x1C6B, 0x19E7, 0x1351, 0x12F0,
    0x125E, 0x0743, 0x037B, 0x083C, 0x02BE, 0x0896, 0x1461, 0x17F2, 0x2173, 0x2C8A, 0x3451, 0x311B, 0x3743, 0x3ADE, 0x3307, 0x35CD,
    0x31CC, 0x27F3, 0x2041, 0x1B4F, 0x0A78, 0xFF8D, 0xFCF0, 0xF277, 0xEA21, 0xE619, 0xDFE1, 0xD3A1, 0xCF6A, 0xCD6C, 0xC7BA, 0xC66A,
    0xCD42, 0xCEF9, 0xD0DB, 0xDAD6, 0xDE29, 0xDCEE, 0xE14F, 0xE303, 0xDCE3, 0xDD46, 0xDFD8, 0xDC72, 0xDFBA, 0xE8C4, 0xEB27, 0xEEC0,
    0xF813, 0xFA82, 0xFABD, 0xFFD4, 0xFF77, 0xFADE, 0xFC61, 0xFC91, 0xF9CB, 0xFDE8, 0x02EC, 0x05FB, 0x0BC2, 0x12B4, 0x14BE, 0x161B,
    0x1929, 0x1A7D, 0x1B74, 0x1DCF, 0x21D2, 0x2405, 0x2453, 0x2694, 0x2895, 0x2529, 0x2423, 0x262A, 0x229B, 0x20F5, 0x259B, 0x2188,
    0x1883, 0x16D4, 0x1143, 0x07A8, 0x0675, 0x065B, 0xFDD2, 0xFA18, 0xFA9A, 0xF2D7, 0xECB3, 0xEC7A, 0xE8A4, 0xE3B9, 0xE340, 0xE1D2,
    0xDBB2, 0xD5C7, 0xD272, 0xCFB7, 0xCD39, 0xD066, 0xD749, 0xD895, 0xD9FD, 0xE0C9, 0xE206, 0xDFAD, 0xE779, 0xECE7, 0xEB96, 0xF260,
    0xF8D7, 0xF521, 0xF52A, 0xFA9B, 0xF996, 0xF9D6, 0x007A, 0x04FC, 0x06F5, 0x0D96, 0x1608, 0x1BD3, 0x224E, 0x2E9D, 0x3996, 0x3CF9,
    0x4348, 0x4C2F, 0x494D, 0x443B, 0x4771, 0x4101, 0x34F0, 0x35A6, 0x31E3, 0x21C6, 0x1EF4, 0x1E91, 0x0F1A, 0x082D, 0x0B08, 0x0088,
    0xF6F0, 0xFBF5, 0xF9F8, 0xF27B, 0xF9C0, 0x0192, 0xFCFE, 0xFF71, 0x0705, 0xFF30, 0xF46F, 0xF5A3, 0xEEB6, 0xDECE, 0xDDEE, 0xDF22,
    0xD329, 0xD0F4, 0xDA03, 0xD59A, 0xD260, 0xDF1D, 0xE03D, 0xD7CA, 0xDE8E, 0xE163, 0xD601, 0xD7FA, 0xE1A1, 0xDCC5, 0xDC6E, 0xE66A,
    0xE3AD, 0xDD40, 0xE54B, 0xEB19, 0xE93E, 0xF125, 0xFC72, 0xFE41, 0x0066, 0x0A56, 0x0E65, 0x0AD3, 0x0DAC, 0x138A, 0x0FFE, 0x0EF8,
    0x1693, 0x1480, 0x0DD8, 0x13C9, 0x16F5, 0x0F66, 0x10F5, 0x139D, 0x08C0, 0x03C1, 0x06B0, 0xFE12, 0xF6E8, 0xFAC9, 0xF7E5, 0xF3F4,
    0xF9AA, 0xFBE9, 0xF9F5, 0xFDE2, 0x00FB, 0x0032, 0x02A1, 0x0614, 0x07F1, 0x0A7E, 0x0E6F, 0x11FC, 0x13B8, 0x1443, 0x16B5, 0x1759,
    0x14B4, 0x1615, 0x1576, 0x0F78, 0x0D63, 0x0AC1, 0x00FE, 0xFBCD, 0xFAE3, 0xF405, 0xF222, 0xF807, 0xF898, 0xF986, 0x012C, 0x042C,
    0x0599, 0x0E50, 0x1766, 0x1828, 0x1E0F, 0x2308, 0x1E0B, 0x1EF6, 0x1B0B, 0x19BC, 0x19D7, 0x186F, 0x1B22, 0x1935, 0x1481, 0x10E3,
    0x0D4A, 0x007D, 0xFBD1, 0xFCCB, 0xF427, 0xF3B1, 0xFA4A, 0xF9FF, 0xFC54, 0x0860, 0x0EB0, 0x0E16, 0x154E, 0x18C4, 0x10A5, 0x0DD1,
    0x0D6F, 0x043B, 0xFE7B, 0x0238, 0x0149, 0xFD97, 0x0345, 0x084E, 0x0592, 0x090C, 0x1091, 0x0D92, 0x091F, 0x0E7B, 0x0D39, 0x04BD,
    0x0823, 0x08EC, 0xFC80, 0xFABA, 0xFE22, 0xF332, 0xEC95, 0xF29F, 0xED96, 0xE6F9, 0xF0FC, 0xF17F, 0xE8CE, 0xEEA3, 0xF2FB, 0xEBE8,
    0xEF3F, 0xF7A6, 0xF39D, 0xEFFE, 0xF47F, 0xF20F, 0xEA36, 0xEAF9, 0xEB7E, 0xE3D8, 0xDF7D, 0xE343, 0xDF36, 0xD637, 0xDA2D, 0xDDFC,
    0xD601, 0xD938, 0xE3C8, 0xDC69, 0xD8E5, 0xE441, 0xE122, 0xDA4B, 0xE767, 0xED80, 0xE7DF, 0xF3BC, 0x00CE, 0xFD4D, 0x02C4, 0x10D3,
    0x10AB, 0x0FC3, 0x1A1C, 0x1C63, 0x163D, 0x174A, 0x1A42, 0x145A, 0x1017, 0x154F, 0x1593, 0x0F83, 0x14B7, 0x1C8C, 0x1929, 0x1D1B,
    0x2A0F, 0x2BC0, 0x2D81, 0x3C7C, 0x42CF, 0x4171, 0x4989, 0x4D7A, 0x46FF, 0x4607, 0x46C3, 0x3DF9, 0x368E, 0x341C, 0x2C7C, 0x2343,
    0x1D61, 0x17F6, 0x0FBB, 0x0648, 0x00AA, 0xF801, 0xEB49, 0xE378, 0xDFF5, 0xD9F1, 0xD8B9, 0xDF12, 0xE070, 0xE038, 0xE671, 0xE871,
    0xE446, 0xE770, 0xEA63, 0xE693, 0xE865, 0xEC8D, 0xE8F0, 0xE83B, 0xEE01, 0xEFDD, 0xF1D2, 0xF98B, 0xFD77, 0xFD12, 0x0070, 0x0455,
    0x03D5, 0x0561, 0x0ACF, 0x0CD4, 0x0C95, 0x0FFF, 0x10FE, 0x0AF9, 0x09B2, 0x0D77, 0x0BB2, 0x0C98, 0x1568, 0x1566, 0x11CB, 0x18AD,
    0x1BA0, 0x1908, 0x2143, 0x2825, 0x24B0, 0x2786, 0x2BA1, 0x23A7, 0x1E5B, 0x1E76, 0x16D1, 0x0F0C, 0x0ADA, 0x0418, 0xF800, 0xEEE3,
    0xE7AA, 0xDF97, 0xD8B0, 0xD3AE, 0xD1F9, 0xCC47, 0xC980, 0xCB34, 0xCA0F, 0xC85C, 0xCD8A, 0xCF81, 0xCC8F, 0xD1C7, 0xD5C1, 0xD331,
    0xD69B, 0xDBCE, 0xD9F3, 0xDDC6, 0xE3F4, 0xE445, 0xE8E4, 0xF03F, 0xF195, 0xF3B8, 0xF756, 0xF380, 0xF082, 0xF1F9, 0xF025, 0xF198,
    0xF8CB, 0xFDD4, 0x01E4, 0x0BB5, 0x1658, 0x1E86, 0x29C1, 0x3886, 0x4172, 0x4673, 0x4CEC, 0x4E4B, 0x4825, 0x4488, 0x4517, 0x3ECC,
    0x396D, 0x3C38, 0x395B, 0x2F95, 0x304C, 0x2EC3, 0x24B8, 0x204C, 0x22DE, 0x15B8, 0x0F64, 0x138A, 0x0758, 0x01D9, 0x08A7, 0x0E2C,
    0x0AC3, 0x11E5, 0x17FD, 0x1246, 0x0B36, 0x09D9, 0x062D, 0xFA42, 0xF821, 0xFB29, 0xF708, 0xF363, 0xF979, 0xF880, 0xF02D, 0xF344,
    0xF841, 0xEF95, 0xED12, 0xF1E7, 0xEA84, 0xE3BF, 0xE770, 0xE753, 0xE0B2, 0xE156, 0xE602, 0xE45C, 0xE39F, 0xEAC4, 0xF051, 0xEDF3,
    0xF212, 0xFDEC, 0xFE61, 0xFEE4, 0x0B2E, 0x1036, 0x0EEE, 0x19C6, 0x23A3, 0x1E99, 0x22B7, 0x2A69, 0x24EA, 0x229A, 0x262A, 0x2194,
    0x1A64, 0x17A6, 0x0FFC, 0x0898, 0x028D, 0xFC0C, 0xF7D0, 0xF35E, 0xED95, 0xEDBF, 0xEE20, 0xEB4C, 0xF002, 0xF5D4, 0xF5DB, 0xF961,
    0xFEF9, 0xFD44, 0xFC75, 0xFEA2, 0xFE28, 0xFD52, 0xFE28, 0xFD35, 0xFC2E, 0xF9C7, 0xF67B, 0xF4C3, 0xF112, 0xEB26, 0xE945, 0xE7E7,
    0xE1DC, 0xE03B, 0xE1A1, 0xDE30, 0xDC37, 0xE098, 0xE3CD, 0xE57A, 0xEC6C, 0xF5B5, 0xFACE, 0x00D0, 0x0B78, 0x1171, 0x11F7, 0x1722,
    0x1C6F, 0x1945, 0x176C, 0x1A69, 0x172D, 0x1192, 0x144F, 0x1514, 0x0F2F, 0x0ED7, 0x1092, 0x0B88, 0x0684, 0x0813, 0x0680, 0x02E9,
    0x05B5, 0x094E, 0x08C1, 0x08A5, 0x0C24, 0x0D4D, 0x0AA0, 0x0966, 0x083F, 0x01F4, 0xFB9F, 0xFB18, 0xFC60, 0xFB50, 0xFF5D, 0x089C,
    0x0C3A, 0x0DAE, 0x1422, 0x164C, 0x110D, 0x11A2, 0x1790, 0x16D0, 0x15CE, 0x1AB1, 0x17C1, 0x0CF7, 0x0880, 0x077A, 0xFE6B, 0xF998,
    0xFFB6, 0xFE3F, 0xF864, 0xFD68, 0xFFFC, 0xF93C, 0xFBA1, 0x0430, 0x0283, 0x0204, 0x0928, 0x076D, 0xFFAE, 0xFECD, 0xFDC6, 0xF7DB,
    0xF59D, 0xF7C9, 0xF6AD, 0xF128, 0xEFB6, 0xF0E4, 0xEB4A, 0xE564, 0xE759, 0xE53A, 0xDC24, 0xDB92, 0xDD81, 0xD795, 0xD87C, 0xE271,
    0xE47C, 0xE520, 0xEEC5, 0xF428, 0xF271, 0xF815, 0x0080, 0x012D, 0x0383, 0x0B6B, 0x0EA3, 0x0DC1, 0x1140, 0x14AD, 0x126F, 0x1225,
    0x148B, 0x12C7, 0x0FA3, 0x0F1A, 0x0F14, 0x0DD0, 0x0CE5, 0x0E40, 0x10D9, 0x1134, 0x13E6, 0x1C59, 0x2141, 0x23E8, 0x2B0B, 0x2ED7,
    0x2AD2, 0x2931, 0x2963, 0x21CB, 0x1A4E, 0x18C6, 0x139E, 0x0AF0, 0x0762, 0x055A, 0xFF58, 0xFA9B, 0xF9D3, 0xF5CD, 0xECAF, 0xE635,
    0xE241, 0xD994, 0xD2C2, 0xD3C3, 0xD39D, 0xD1EF, 0xD7B5, 0xDF1F, 0xDEE0, 0xDF1B, 0xE246, 0xDEC4, 0xD8EE, 0xD89A, 0xD950, 0xD686,
    0xD7A9, 0xE0BE, 0xE6E5, 0xEB58, 0xF67E, 0x0080, 0x02D1, 0x0797, 0x10DA, 0x12F4, 0x126C, 0x1857, 0x1B88, 0x1630, 0x14E9, 0x14BA,
    0x0B67, 0x03AD, 0x04BC, 0x0423, 0x016F, 0x0830, 0x0F95, 0x104A, 0x147E, 0x1B7E, 0x1E0E, 0x217C, 0x285C, 0x2D75, 0x310E, 0x3317,
    0x335B, 0x3154, 0x2CC8, 0x268F, 0x240B, 0x2099, 0x1809, 0x13F6, 0x106C, 0x052A, 0xFBA7, 0xF848, 0xEE68, 0xE2EF, 0xE141, 0xDEA3,
    0xD69E, 0xD523, 0xD791, 0xD265, 0xCE1C, 0xD150, 0xD0B2, 0xCB18, 0xCCB4, 0xD133, 0xCF20, 0xD0E8, 0xDB06, 0xDFE4, 0xE098, 0xE80A,
    0xEF56, 0xEE76, 0xEEFD, 0xF677, 0xF8A2, 0xF535, 0xFA78, 0x0159, 0xFC5C, 0xFA89, 0x041E, 0x053B, 0x0257, 0x10A3, 0x1D5A, 0x1CA5,
    0x2839, 0x398B, 0x392C, 0x3A0D, 0x45F5, 0x4488, 0x3C05, 0x40C8, 0x42D0, 0x3917, 0x37BF, 0x3CB4, 0x3763, 0x3055, 0x3211, 0x2FB7,
    0x2505, 0x21FD, 0x236B, 0x1AA0, 0x10E0, 0x0F8A, 0x08E8, 0xFCB0, 0xFA6D, 0xFA9D, 0xF302, 0xEEDE, 0xEFA7, 0xE8E9, 0xDED8, 0xD91D,
    0xD2EB, 0xCAFE, 0xC86D, 0xCB7B, 0xCD62, 0xCE47, 0xD195, 0xD4AB, 0xD3EA, 0xD3B6, 0xD6C1, 0xD919, 0xDA4B, 0xDF45, 0xE55D, 0xE79C,
    0xE7FE, 0xE947, 0xE794, 0xE2B3, 0xE099, 0xE0BA, 0xDEF2, 0xDE59, 0xE286, 0xE74C, 0xEBCE, 0xF318, 0xFD9A, 0x06C2, 0x0DEB, 0x17C2,
    0x2244, 0x2654, 0x290F, 0x3027, 0x3123, 0x2A79, 0x2A26, 0x2967, 0x1D06, 0x173C, 0x1A35, 0x12E9, 0x0B54, 0x0FC9, 0x0C13, 0xFF04,
    0xFD82, 0xFDFC, 0xF461, 0xF2DE, 0xFBC0, 0xFBB1, 0xFA1A, 0x0232, 0x049F, 0xFE36, 0xFE9F, 0x02CA, 0xFF9D, 0xFDDD, 0x0378, 0x047F,
    0x006F, 0x009F, 0x0245, 0xFF34, 0xFCA4, 0xFFD3, 0x018B, 0xFDBA, 0xFD4E, 0x0003, 0xFA64, 0xF225, 0xF16C, 0xEDBC, 0xE3A4, 0xE37E,
    0xE87E, 0xE714, 0xEC7B, 0xFB4C, 0x0382, 0x0872, 0x13DD, 0x1B26, 0x1AAA, 0x1CF1, 0x21E5, 0x226C, 0x22D9, 0x26E5, 0x28A0, 0x25D7,
    0x2302, 0x21DD, 0x1FED, 0x1C00, 0x1AFD, 0x1B66, 0x16E4, 0x10BF, 0x0EC6, 0x0D01, 0x0643, 0x03A2, 0x0724, 0x0485, 0x008C, 0x0591,
    0x0595, 0xFBF8, 0xFA7F, 0xFC40, 0xF40E, 0xF03E, 0xF784, 0xF7D2, 0xF535, 0xFE93, 0x077A, 0x05C6, 0x088A, 0x1163, 0x0F5C, 0x09C2,
    0x0F8E, 0x1277, 0x08A6, 0x05D9, 0x074E, 0xF920, 0xEAC3, 0xE9BC, 0xE0DD, 0xD302, 0xD530, 0xD8E1, 0xD3AB, 0xD669, 0xDEAE, 0xDDE3,
    0xDCF2, 0xE3DC, 0xE9C3, 0xEAB7, 0xEF1F, 0xF851, 0xFBC3, 0xFA09, 0xFD54, 0x0061, 0xF87C, 0xF477, 0xF8A5, 0xF26F, 0xEA6D, 0xEE78,
    0xEC91, 0xE35D, 0xE4BB, 0xE669, 0xDF30, 0xDE4E, 0xE417, 0xE471, 0xE770, 0xF099, 0xF612, 0xF863, 0xFB75, 0xFB9F, 0xF976, 0xF736,
    0xF53C, 0xF661, 0xF949, 0xFAD1, 0xFDC2, 0x02AE, 0x02FC, 0x0245, 0x07BE, 0x0BA5, 0x0BE4, 0x1234, 0x1A08, 0x1976, 0x18D2, 0x1C5E,
    0x1873, 0x119B, 0x1509, 0x194A, 0x17D6, 0x1DF0, 0x295A, 0x2C48, 0x2E7E, 0x3666, 0x37BD, 0x32D9, 0x3424, 0x3712, 0x3459, 0x338D,
    0x3616, 0x3321, 0x2B19, 0x256A, 0x208A, 0x1659, 0x0AA5, 0x05A5, 0x0047, 0xF4C0, 0xEF61, 0xEF98, 0xE6FC, 0xDF6B, 0xE521, 0xE54A,
    0xDF73, 0xE68B, 0xEC04, 0xE394, 0xE26D, 0xE6BF, 0xE017, 0xDC24, 0xE1B4, 0xE1F8, 0xDF23, 0xE453, 0xEB6C, 0xEDC7, 0xF172, 0xFB1A,
    0x0248, 0x02D4, 0x06E9, 0x0E14, 0x0BF7, 0x09B4, 0x1082, 0x0FF3, 0x0960, 0x0B20, 0x092B, 0xFEE8, 0xFB3F, 0xFA69, 0xF6CD, 0xF8D6,
    0xFF41, 0x05CD, 0x0D8D, 0x130D, 0x18CB, 0x21FC, 0x255F, 0x295B, 0x3478, 0x3600, 0x30CD, 0x32D7, 0x2CED, 0x1B56, 0x1396, 0x0D6F,
    0xFD89, 0xF5BD, 0xF597, 0xEC68, 0xE280, 0xDEE6, 0xD6CE, 0xCB8F, 0xC4D9, 0xC1DA, 0xBF12, 0xBC59, 0xBE90, 0xC378, 0xC2DF, 0xC29E,
    0xC7F2, 0xC7E0, 0xC354, 0xC7AD, 0xCBB2, 0xC77E, 0xC9B8, 0xD1BE, 0xD223, 0xD2AD, 0xDCAE, 0xE331, 0xE40E, 0xEDE1, 0xFB9F, 0x00A6,
    0x0681, 0x12D9, 0x16D1, 0x1306, 0x1679, 0x1968, 0x12F6, 0x1321, 0x1CAB, 0x1F40, 0x21CE, 0x2C90, 0x2FDF, 0x2CDA, 0x30BA, 0x34C0,
    0x34AE, 0x398D, 0x3FC7, 0x419E, 0x440B, 0x44FC, 0x43A1, 0x439B, 0x3FD7, 0x3B8D, 0x3C25, 0x3742, 0x2E2B, 0x2C49, 0x2685, 0x1A65,
    0x17FC, 0x1694, 0x0C1E, 0x0831, 0x0816, 0xFF51, 0xF977, 0xF8CE, 0xF3C6, 0xEDEF, 0xEA41, 0xE523, 0xDEDE, 0xD805, 0xD380, 0xD47D,
    0xD379, 0xD3A3, 0xDB5B, 0xDDFE, 0xDC10, 0xE215, 0xE66E, 0xE43E, 0xE9D6, 0xF109, 0xEFF1, 0xF0F0, 0xF341, 0xEF95, 0xEB11, 0xE7A6,
    0xE528, 0xE4F0, 0xE3D7, 0xE74E, 0xF0F0, 0xF40B, 0xF864, 0x07A0, 0x0E66, 0x0FE3, 0x1EAE, 0x27E2, 0x250D, 0x2D23, 0x3495, 0x2C2A,
    0x2847, 0x2A03, 0x20D6, 0x18B3, 0x1B1D, 0x1998, 0x131D, 0x1255, 0x11CC, 0x0A41, 0x01C9, 0xFDC4, 0xFACC, 0xF653, 0xF79C, 0xFF74,
    0x0120, 0xFF41, 0x021F, 0xFF3B, 0xF4CF, 0xEFA1, 0xECB0, 0xE4A3, 0xDEE2, 0xDEC6, 0xDB7F, 0xD5A5, 0xD4D0, 0xD5C4, 0xD39A, 0xD2E9,
    0xD7D4, 0xD9E6, 0xD77F, 0xD9BA, 0xDCC9, 0xD9C1, 0xD8DB, 0xDCD3, 0xDBCF, 0xDA44, 0xDF7E, 0xE344, 0xE439, 0xE972, 0xEF07, 0xF271,
    0xF746, 0xFBCD, 0x014E, 0x0808, 0x0C3D, 0x140C, 0x1FF8, 0x255F, 0x2B84, 0x3715, 0x38BD, 0x3524, 0x3A3A, 0x3860, 0x2D68, 0x2D2A,
    0x2CF7, 0x2174, 0x1DC4, 0x1F0F, 0x14C1, 0x0C9A, 0x0CCC, 0x079E, 0x01AD, 0x02FD, 0x0321, 0x010B, 0xFFF2, 0xFFB7, 0xFF35, 0xFAF2,
    0xF895, 0xFB54, 0xFB48, 0xFAE0, 0x023A, 0x06C9, 0x0575, 0x096F, 0x0CA5, 0x0938, 0x0A0C, 0x0CF4, 0x0CA5, 0x0DD3, 0x0ECA, 0x0D91,
    0x0A34, 0x01B0, 0xFA2F, 0xF6C2, 0xEC6E, 0xE4F5, 0xE6FD, 0xE293, 0xDD8D, 0xE459, 0xE771, 0xE519, 0xEEBA, 0xF8B2, 0xF954, 0xFFBD,
    0x08FF, 0x0805, 0x0691, 0x09AA, 0x0797, 0x02EC, 0x012F, 0xFF2B, 0xFB7D, 0xF88C, 0xF79B, 0xF71D, 0xF384, 0xEF64, 0xEDEE, 0xEA5A,
    0xE64E, 0xE7D8, 0xEB5B, 0xED43, 0xF0B7, 0xF600, 0xF7AA, 0xF3EF, 0xF1CD, 0xF13F, 0xEB9E, 0xE7DD, 0xEBF7, 0xED28, 0xEAF8, 0xF156,
    0xF718, 0xF3C1, 0xF742, 0x008C, 0x01EA, 0x06CD, 0x138A, 0x1855, 0x180D, 0x1CC9, 0x1CDC, 0x1721, 0x157E, 0x1504, 0x1156, 0x0EC3,
    0x0E05, 0x0D39, 0x0BAB, 0x08CE, 0x092C, 0x0AA1, 0x080B, 0x0897, 0x0D1B, 0x0B17, 0x082F, 0x0BD0, 0x0A50, 0x04ED, 0x0693, 0x0576,
    0xFD3F, 0xF9C7, 0xF74E, 0xEF7F, 0xEB0F, 0xEA04, 0xE570, 0xE173, 0xDF4F, 0xDB3B, 0xD76E, 0xD467, 0xD33E, 0xD5BF, 0xD8C8, 0xDC80,
    0xE375, 0xE723, 0xE7F9, 0xEBEA, 0xEE70, 0xEF0F, 0xF3C3, 0xF975, 0xFC6B, 0x0017, 0x0327, 0x03D4, 0x0416, 0x050D, 0x0761, 0x0AB5,
    0x0C65, 0x0F43, 0x1208, 0x0F78, 0x0D1C, 0x0D16, 0x07F7, 0x0364, 0x04A6, 0x031F, 0x02DB, 0x0927, 0x0E60, 0x11E4, 0x1A47, 0x20CB,
    0x2445, 0x29C6, 0x2D8E, 0x2E70, 0x30F9, 0x31A8, 0x2F42, 0x2CA2, 0x26A8, 0x226C, 0x1B95, 0x14F8, 0x0F29, 0x0703, 0xFE77, 0xF506,
    0xEB67, 0xE00E, 0xD841, 0xD2AA, 0xCE51, 0xCF0D, 0xCFF0, 0xCF7B, 0xD257, 0xD3DD, 0xD242, 0xD4BB, 0xD6C8, 0xD23F, 0xD277, 0xD2EF,
    0xCDE6, 0xCFCB, 0xD512, 0xD5ED, 0xDADD, 0xE470, 0xE726, 0xEBB1, 0xF451, 0xF6F0, 0xFBEE, 0x04F4, 0x0954, 0x0D51, 0x11A0, 0x0FD6,
    0x0CE8, 0x0DEE, 0x0C67, 0x0E5F, 0x1667, 0x19E6, 0x1D65, 0x23B0, 0x24F3, 0x25AD, 0x2CDD, 0x322B, 0x379C, 0x41AD, 0x492D, 0x4BB7,
    0x4DCC, 0x4D50, 0x4974, 0x44D5, 0x4021, 0x3A26, 0x335E, 0x2ABE, 0x22D6, 0x199F, 0x0DFB, 0x054B, 0xFDC3, 0xF329, 0xEA6E, 0xE56A,
    0xDD12, 0xD8A9, 0xD4EF, 0xD158, 0xCBF3, 0xCCBE, 0xC6B9, 0xC9FF, 0xDCA4, 0xDAE0, 0xD889, 0xD88D, 0xDA08, 0xDB11, 0xDDD1, 0xDE80,
    0xDD8B, 0xDECB, 0xDBEE, 0xDFB3, 0xDFEC, 0xE236, 0xE9B2, 0xE8B5, 0xEBC3, 0xF5A5, 0xFC0C, 0xF7BC, 0xF980, 0xFF60, 0xFE77, 0x01C8,
    0x09DC, 0x0E33, 0x0EFD, 0x1706, 0x1827, 0x184A, 0x1D48, 0x1EEA, 0x221A, 0x2399, 0x283D, 0x2937, 0x21F7, 0x237F, 0x2315, 0x1846,
    0x0E38, 0x0F58, 0x0D70, 0x097B, 0x0B1E, 0x083D, 0x05E2, 0x0A15, 0x104A, 0x0C39, 0x1033, 0x15E5, 0x1152, 0x14FF, 0x1BE3, 0x16F3,
    0x1218, 0x121B, 0x080F, 0x0391, 0x0359, 0xFA99, 0xF7D7, 0xF8ED, 0xF510, 0xF43A, 0xF682, 0xF51D, 0xF515, 0xF890, 0xF941, 0xFAC5,
    0xFDAD, 0xFBBA, 0xFCC6, 0xFFB1, 0xFE17, 0xFC9C, 0xFF7F, 0xFFFA, 0xFD30, 0xFEE9, 0x0067, 0xFF6A, 0xFDEB, 0x012D, 0x0449, 0x0578,
    0x0CE4, 0x14CC, 0x16CB, 0x188C, 0x1E9E, 0x1DD1, 0x1837, 0x1790, 0x148D, 0x0CD7, 0x0A9F, 0x0CC3, 0x0B97, 0x0BC2, 0x0CF1, 0x0DE0,
    0x0ECE, 0x0EF4, 0x11C9, 0x145D, 0x13D5, 0x1652, 0x1C79, 0x1C97, 0x1C81, 0x22A0, 0x23A1, 0x2148, 0x243A, 0x255B, 0x1FE9, 0x1D53,
    0x1D8F, 0x1AD8, 0x191B, 0x1879, 0x1645, 0x1069, 0x09E2, 0x063D, 0x013E, 0xF89D, 0xF443, 0xF397, 0xEBBF, 0xE4E3, 0xE3F8, 0xDC92,
    0xD474, 0xD73D, 0xD8D4, 0xD544, 0xD994, 0xDD64, 0xD86E, 0xD715, 0xD8F4, 0xD573, 0xD267, 0xD42F, 0xD562, 0xD4C0, 0xD5E1, 0xDAF6,
    0xDF41, 0xE060, 0xE757, 0xF103, 0xF245, 0xF679, 0x00DF, 0x01D8, 0x0158, 0x0AB5, 0x0CD5, 0x0847, 0x0D15, 0x0F42, 0x09D4, 0x0C71,
    0x1176, 0x0FB8, 0x1195, 0x14AF, 0x1276, 0x10E3, 0x1043, 0x0F2B, 0x10B7, 0x1403, 0x1810, 0x1DF8, 0x2215, 0x2370, 0x2699, 0x2865,
    0x2726, 0x27B8, 0x2898, 0x2718, 0x2666, 0x27A1, 0x28A1, 0x2861, 0x281B, 0x29CA, 0x27E5, 0x21D8, 0x1F3D, 0x1A75, 0x0FE0, 0x0A21,
    0x0713, 0xFEEC, 0xFA5E, 0xFB0C, 0xF6FA, 0xF414, 0xF784, 0xF808, 0xF66A, 0xF784, 0xF6E3, 0xF373, 0xF0B9, 0xEEEF, 0xEEC5, 0xEF27,
    0xEF37, 0xF240, 0xF390, 0xEFCF, 0xEEFA, 0xEFAF, 0xEC0B, 0xEC71, 0xF2BE, 0xF441, 0xF532, 0xFBC5, 0xFE56, 0xFCBD, 0xFE97, 0x0108,
    0x007F, 0x0197, 0x0581, 0x07C2, 0x074A, 0x0780, 0x09B6, 0x087F, 0x05D5, 0x0983, 0x0C6A, 0x0A2F, 0x0DCE, 0x14A0, 0x13B3, 0x145C,
    0x1BB8, 0x1BDA, 0x1826, 0x1BAD, 0x1B49, 0x1368, 0x1173, 0x1159, 0x0B69, 0x07C8, 0x0857, 0x04A1, 0xFDB8, 0xF854, 0xF30B, 0xEA87,
    0xE29C, 0xE059, 0xDE7E, 0xD8BA, 0xD670, 0xD5BC, 0xCE70, 0xCA97, 0xCBC6, 0xCAA4, 0xC937, 0xCD36, 0xCF7A, 0xC9B5, 0xC9AD, 0xCC87,
    0xC66F, 0xC852, 0xC793, 0xC4D6, 0xCC48, 0xCAF8, 0xCC33, 0xD2AB, 0xD2B4, 0xD2FC, 0xD9B7, 0xDD55, 0xE260, 0xEE21, 0xF610, 0xFC60,
    0x05B2, 0x085A, 0x0849, 0x0B4B, 0x0A6E, 0x0CA4, 0x0F8C, 0x11D4, 0x15A9, 0x17C8, 0x16EE, 0x1AEC, 0x1D50, 0x18B1, 0x1D67, 0x1F5E,
    0x175B, 0x1824, 0x1BE0, 0x1518, 0x1479, 0x1E68, 0x1C0D, 0x1A57, 0x22A0, 0x211A, 0x1BFC, 0x1ED8, 0x1E64, 0x1916, 0x179D, 0x15DA,
    0x13AB, 0x1140, 0x0DC4, 0x0EBD, 0x0E55, 0x064A, 0x0399, 0x026A, 0xF559, 0xECA8, 0xEC94, 0xE4CC, 0xDD43, 0xE0D2, 0xE0B2, 0xDC3A,
    0xDDF5, 0xE065, 0xDF25, 0xDE1D, 0xDFCE, 0xE328, 0xE283, 0xE057, 0xE5C3, 0xE748, 0xE0D8, 0xE36B, 0xE859, 0xE291, 0xE2CE, 0xEC00,
    0xEB2D, 0xEA5C, 0xF32C, 0xF56C, 0xF1FB, 0xF3D0, 0xF476, 0xF106, 0xEF91, 0xEF86, 0xEFFB, 0xF01A, 0xEE99, 0xF057, 0xF21E, 0xECBE,
    0xEA48, 0xECDA, 0xE8BC, 0xE6D1, 0xED9F, 0xF0AB, 0xF2C5, 0xFA5B, 0x0068, 0x0309, 0x067A, 0x0A1D, 0x0BE6, 0x0BF8, 0x0B11, 0x0CB6,
    0x0CCB, 0x078C, 0x0610, 0x0573, 0xFD7A, 0xF9B6, 0xFB59, 0xF521, 0xEF70, 0xEEED, 0xE7E7, 0xDE76, 0xDA3C, 0xD4A4, 0xCEF7, 0xCEAB,
    0xCEF9, 0xCFED, 0xD23E, 0xD2F8, 0xD406, 0xD44C, 0xD283, 0xD3F4, 0xD42B, 0xD17F, 0xD40C, 0xD5E4, 0xD3CD, 0xD945, 0xDEBE, 0xDD5D,
    0xE433, 0xEB0F, 0xE7C7, 0xEB27, 0xF385, 0xF296, 0xF5AE, 0x0138, 0x037A, 0x0434, 0x0C01, 0x0D45, 0x0B0A, 0x0E2E, 0x0F54, 0x0E61,
    0x0DB8, 0x0AA8, 0x0991, 0x07C1, 0x0284, 0x0418, 0x08A2, 0x05A1, 0x0703, 0x0E56, 0x0AB5, 0x06D1, 0x0D36, 0x0E35, 0x0AE6, 0x0FB0,
    0x145F, 0x1221, 0x1106, 0x13A7, 0x150A, 0x116A, 0x112C, 0x1785, 0x1616, 0x106C, 0x14FC, 0x1572, 0x0A3A, 0x0A11, 0x0DE4, 0x03ED,
    0xFD40, 0xFF33, 0xF811, 0xEF7F, 0xF09E, 0xF03A, 0xECAE, 0xEBFC, 0xEC46, 0xEA98, 0xE695, 0xE2F6, 0xE48D, 0xE4DE, 0xE169, 0xE4FC,
    0xE91E, 0xE2FF, 0xDF1E, 0xE09E, 0xDB89, 0xD67C, 0xDA55, 0xDD38, 0xDC33, 0xDE65, 0xE366, 0xE4C5, 0xE3BF, 0xE684, 0xEA57, 0xEA57,
    0xE691, 0xED42, 0xEDF2, 0xE7B1, 0xEC42, 0xECAC, 0xEA3E, 0xEA1A, 0xEF70, 0xED0F, 0xEDA1, 0xF3DD, 0xF474, 0xF868, 0xFE83, 0x02CA,
    0x0672, 0x0D27, 0x10F7, 0x16B9, 0x1C56, 0x1FC2, 0x235D, 0x25BF, 0x2410, 0x2562, 0x23BA, 0x1E62, 0x1FE2, 0x1EDD, 0x18F0, 0x1A9B,
    0x1C97, 0x1403, 0x11DC, 0x1222, 0x07DF, 0x000C, 0xFEA0, 0xF6BF, 0xEFA3, 0xEFCC, 0xEE3C, 0xED47, 0xEF25, 0xEEFD, 0xF06A, 0xEF67,
    0xE97B, 0xE8CF, 0xE7C5, 0xDF1C, 0xDCB6, 0xDE2F, 0xD6EF, 0xD30D, 0xD722, 0xD6E1, 0xD586, 0xDC47, 0xE1B0, 0xE31E, 0xE6A1, 0xEC8E,
    0xEFE0, 0xF01E, 0xF3AB, 0xF9AE, 0xFB18, 0xFCD2, 0x04F4, 0x0795, 0x067A, 0x0C4A, 0x0F88, 0x0CA5, 0x1043, 0x1422, 0x11AF, 0x1435,
    0x183F, 0x1728, 0x1878, 0x1C35, 0x1CDC, 0x1F80, 0x2374, 0x2489, 0x26B3, 0x2703, 0x24AB, 0x2560, 0x23E1, 0x1F0D, 0x2058, 0x2148,
    0x1CE8, 0x1E70, 0x21B0, 0x1C53, 0x189B, 0x19E2, 0x14BF, 0x0C64, 0x09A7, 0x06C1, 0xFEC2, 0xF8D5, 0xF86A, 0xF596, 0xEDC9, 0xECB0,
    0xEFC5, 0xEA95, 0xE768, 0xED4D, 0xEBEA, 0xE551, 0xE8A4, 0xE9D0, 0xE2E0, 0xE2BC, 0xE572, 0xE123, 0xDFA5, 0xE19D, 0xDFEA, 0xDF65,
    0xE104, 0xE25E, 0xE6EA, 0xEB4F, 0xED54, 0xF330, 0xF85B, 0xF991, 0xFF4F, 0x04FA, 0x05BF, 0x09AC, 0x0CF8, 0x0BC7, 0x0D03, 0x0E33,
    0x0BD4, 0x0EA1, 0x1272, 0x1270, 0x1857, 0x1FEB, 0x221D, 0x26DE, 0x2DDD, 0x2F28, 0x303A, 0x3301, 0x33AE, 0x353E, 0x378A, 0x38D5,
    0x3BFC, 0x3C00, 0x3847, 0x3893, 0x36EC, 0x2F9C, 0x2D43, 0x2CC9, 0x259D, 0x1E82, 0x1B2D, 0x137D, 0x08D8, 0x0219, 0xFE58, 0xF787,
    0xEFE2, 0xEDF9, 0xECA8, 0xE529, 0xE15B, 0xE3A2, 0xDEEF, 0xDA18, 0xDD34, 0xDCAD, 0xD89A, 0xDAD8, 0xDBDF, 0xD8EC, 0xD8F8, 0xD904,
    0xD863, 0xDAD0, 0xDC9D, 0xE0AD, 0xE88D, 0xEBF2, 0xEF65, 0xF82A, 0xFBFF, 0xFE66, 0x07E5, 0x0D14, 0x0D24, 0x12BB, 0x1546, 0x11D8,
    0x13AC, 0x168F, 0x155D, 0x1750, 0x1A97, 0x1847, 0x14F8, 0x1406, 0x1378, 0x1157, 0x11DE, 0x175D, 0x1A99, 0x18AC, 0x1BE8, 0x1E38,
    0x180F, 0x16D6, 0x1DA7, 0x1B3E, 0x1988, 0x2039, 0x1F33, 0x17F9, 0x191C, 0x1A1B, 0x150E, 0x15C5, 0x1846, 0x173C, 0x14CE, 0x11A1,
    0x0AC5, 0x07F0, 0x0288, 0xFF9B, 0xFC43, 0xF78C, 0xF6E1, 0xFB53, 0xF251, 0xEB02, 0xF5A3, 0xFB71, 0xF751, 0xF864, 0xFFF8, 0x0164,
    0x01B2, 0xFE77, 0xFB5A, 0xF77D, 0x008C, 0xFF1F, 0xFB2A, 0x0099, 0x05A4, 0x0686, 0x07F9, 0x0D88, 0x0D05, 0x0941, 0x0E26, 0x1376,
    0x0E50, 0x0B15, 0x1234, 0x1970, 0x1811, 0x1899, 0x18D8, 0x1511, 0x0DE4, 0x1422, 0x0DDD, 0x05FF, 0x0521, 0x0CC6, 0x0EA4, 0x09B6,
    0x0FB5, 0x1664, 0x1B2B, 0x1E55, 0x24D0, 0x2060, 0x1F9A, 0x28C0, 0x27B2, 0x1D4D, 0x20F1, 0x23DF, 0x2093, 0x1BD0, 0x1A08, 0x1F6F,
    0x1DCD, 0x126F, 0x154F, 0x1568, 0x0A3D, 0x0298, 0x0029, 0xFC43, 0xF6B8, 0xF865, 0xF8A0, 0xF026, 0xF122, 0xF819, 0xECFB, 0xEC38,
    0xEB6B, 0xEC71, 0xE85E, 0xE4E3, 0xE4C4, 0xDEAD, 0xDE23, 0xD7F9, 0xDA56, 0xD83B, 0xD277, 0xD6A8, 0xDA37, 0xD749, 0xDA9C, 0xE3B1,
    0xE449, 0xEAC3, 0xECBA, 0xF28C, 0xF674, 0xF1F9, 0xFAAB, 0xFE04, 0x043C, 0x0748, 0x0B34, 0x0401, 0x0272, 0x108F, 0x0740, 0x01A4,
    0x09B6, 0x0F46, 0x09DA, 0x0C34, 0x11F7, 0x122C, 0x1061, 0x1421, 0x127E, 0x1A6B, 0x22F4, 0x15F5, 0x1CF3, 0x1F74, 0x1D9B, 0x21D6,
    0x1C6A, 0x27DD, 0x2C48, 0x242B, 0x2F08, 0x2835, 0x1EF8, 0x26FA, 0x211C, 0x1314, 0x35A3, 0x2435, 0x0414, 0x28BF, 0x16C5, 0x1796,
    0x0959, 0x0859, 0x19BF, 0xF756, 0x07D6, 0x0530, 0x0D71, 0x0F4F, 0xFA69, 0x19DD, 0x212C, 0xF20F, 0xF598, 0x080B, 0xEE27, 0xFEF6,
    0xE0D2, 0xEB1D, 0xF7E4, 0xF00A, 0xF5CC, 0xE532, 0xFD20, 0xE93E, 0xEEF9, 0xFC88, 0xFB64, 0xF3CB, 0xF2A6, 0xFB54, 0xFBC7, 0xFA58,
    0xEDC8, 0xFE25, 0xF16C, 0xF31E, 0xFC03, 0xFF5D, 0xFEA5, 0xEEBB, 0x04D5, 0x1260, 0x0701, 0x0D32, 0x1E5F, 0x1BA1, 0x29D5, 0x23A7,
    0x3458, 0x2D2D, 0x220A, 0x315F, 0x2A9A, 0x34E3, 0x1F15, 0x2BFE, 0x3397, 0x2137, 0x2118, 0x2629, 0x1403, 0x1AFF, 0x1193, 0x04EA,
    0x087E, 0xF83E, 0x0A6C, 0xF15F, 0xEEA4, 0xF54C, 0xDF5F, 0xED8E, 0xE8A4, 0xE0D1, 0xDB81, 0xD3D7, 0xDA26, 0xC067, 0xAEC0, 0xB005,
    0xB6AD, 0x9353, 0xA2CD, 0xB40D, 0x9F85, 0xAD82, 0xA59D, 0xBA7B, 0xB9E8, 0xBEB1, 0xC581, 0xCDE1, 0xC5E9, 0xD32D, 0xE68B, 0xE3E0,
    0xDB34, 0xE2FA, 0x054E, 0xE1D5, 0xF02A, 0xF575, 0xF64E, 0x00F3, 0xF32F, 0x06ED, 0x151D, 0x0BB1, 0x1519, 0x2E50, 0x16F5, 0x2C0E,
    0x3EB7, 0x4114, 0x3AD3, 0x4440, 0x423A, 0x383F, 0x56F6, 0x4FF9, 0x5510, 0x59BD, 0x68C9, 0x62A3, 0x67CF, 0x68FA, 0x52F5, 0x57D6,
    0x50B5, 0x45DB, 0x3CEC, 0x32F7, 0x2373, 0x211C, 0x104F, 0xFD2F, 0xFDD8, 0xE609, 0xE561, 0xCF15, 0xD2E8, 0xD9BA, 0xD665, 0xD8DF,
    0xC9DC, 0xE68F, 0xCFCA, 0xD4D6, 0xCE2F, 0xD026, 0xD7D7, 0xCDF0, 0xD123, 0xCE0C, 0xD1EF, 0xC1FC, 0xD3E4, 0xCB4E, 0xCB3D, 0xD70D,
    0xC847, 0xEC6C, 0xF5B4, 0xEAA1, 0xEA60, 0x0428, 0xFED7, 0xEED0, 0x0092, 0xFB3E, 0x03CB, 0xF7F3, 0x087C, 0x020D, 0x0188, 0x0C47,
    0x2653, 0x1B4A, 0x15CB, 0x4017, 0x3CD3, 0x4672, 0x457D, 0x4CA4, 0x4898, 0x3CF1, 0x4C18, 0x3235, 0x333D, 0x3E1E, 0x320C, 0x1FC0,
    0x0FF1, 0x1FF1, 0xFA37, 0xF0CF, 0xEB87, 0xE4EE, 0xD791, 0xDFCC, 0xDEBB, 0xD2D9, 0xCEED, 0xDA09, 0xD663, 0xCE60, 0xD52C, 0xC947,
    0xD036, 0xBC3C, 0xD8DA, 0xCFD6, 0xBEC4, 0xBF98, 0xC815, 0xC4DB, 0xBD1B, 0xBBAD, 0xBAD1, 0xBEBD, 0xC402, 0xD0F9, 0xD2C4, 0xC95E,
    0xDC36, 0xF044, 0xEF14, 0xE4F1, 0x0231, 0x1601, 0xF988, 0x1145, 0x14AE, 0x29B5, 0x27CA, 0x35F7, 0x3829, 0x4F76, 0x5931, 0x5362,
    0x4E3C, 0x52F0, 0x564A, 0x3FB7, 0x504B, 0x355F, 0x44F0, 0x411E, 0x3299, 0x342B, 0x2E3F, 0x18C7, 0x1791, 0x1F2B, 0xF7FD, 0xF29E,
    0x0B70, 0xFCE0, 0x00D0, 0x05D9, 0xF568, 0xFBEE, 0x0DFD, 0x000E, 0xF919, 0xFDA9, 0x0049, 0xEDC1, 0xE9D1, 0xFB5B, 0xD8AF, 0xDFFA,
    0xE39B, 0xD964, 0xE790, 0xDD22, 0xE22E, 0xF146, 0xE918, 0xFE2E, 0xF85B, 0x0080, 0x0223, 0xFD23, 0xF6C7, 0x1411, 0x03DD, 0xF36E,
    0x0465, 0x0858, 0x1BC7, 0xF7BE, 0x170F, 0x2225, 0x1BD5, 0x2963, 0x3384, 0x2F08, 0x371E, 0x33E3, 0x3ACE, 0x2EB1, 0x246C, 0x3C38,
    0x2123, 0x1589, 0x21B1, 0x0965, 0x030F, 0xFEC4, 0xF133, 0xE86F, 0xDFE7, 0xEC5A, 0xDEAF, 0xEEFA, 0xEB8C, 0xF29A, 0x0EDC, 0xFA68,
    0xFDCC, 0x0F53, 0x069A, 0x1217, 0x0529, 0x16B8, 0x199A, 0x009B, 0x1892, 0x1F8D, 0xFF87, 0x09CC, 0x11C2, 0x01C0, 0x125C, 0xFF35,
    0xFCF3, 0x1709, 0x0C4C, 0xFFB7, 0x0ACA, 0x044F, 0x1513, 0x0660, 0x015F, 0x12CE, 0x0957, 0xFB0A, 0x117F, 0x0A31, 0xF85F, 0x175C,
    0x1505, 0x1608, 0x157D, 0x1678, 0x2330, 0x10E6, 0x186F, 0x12FC, 0x0805, 0x167F, 0x0F10, 0x08B0, 0x03B6, 0x14C5, 0xFB27, 0x05E1,
    0xF5B2, 0x0051, 0xF007, 0xF0FB, 0x04CA, 0xDF3F, 0x08AF, 0xF9C2, 0xF692, 0xF226, 0x0168, 0x02D7, 0xFDCD, 0x01CC, 0x05CB, 0x0ABD,
    0xFB9B, 0x0A59, 0x0633, 0xFE73, 0x0C5B, 0x02BC, 0x0218, 0x126C, 0x1235, 0x23EF, 0x1FE4, 0x2AF0, 0x288E, 0x2796, 0x36DD, 0x3070,
    0x30CE, 0x3A0A, 0x2CCA, 0x3203, 0x3395, 0x278A, 0x304D, 0x2383, 0x2FE9, 0x2EB2, 0x2DC5, 0x2DB5, 0x35A8, 0x2E0C, 0x3720, 0x2F82,
    0x24B1, 0x2668, 0x1692, 0x2A30, 0x0872, 0x11AC, 0xFDEE, 0xF3B8, 0xF7E3, 0xDDCA, 0xDF9D, 0xCB60, 0xD365, 0xD5FD, 0xCFC0, 0xCEBC,
    0xD57E, 0xD2D8, 0xD121, 0xD538, 0xD8F2, 0xE6F3, 0xE00F, 0xDB01, 0xEE92, 0xD79D, 0xDCA1, 0xE985, 0xD36D, 0xE03E, 0xCBE7, 0xD450,
    0xD54B, 0xCAE1, 0xDE7F, 0xE600, 0xE8EC, 0xF744, 0xFE9B, 0xF7DE, 0x0F86, 0x0E1F, 0x0BEF, 0x1232, 0x2915, 0x23E5, 0x26BA, 0x38A1,
    0x2449, 0x2691, 0x3CAC, 0x3A8B, 0x4727, 0x4961, 0x3DA5, 0x4B11, 0x4291, 0x3A40, 0x24C9, 0x3C4E, 0x2C5F, 0x2095, 0x1EF5, 0x0D0A,
    0x0791, 0xFA63, 0xFCB6, 0xE2C3, 0xDBFC, 0xD720, 0xC629, 0xC2BD, 0xCD69, 0xB814, 0xBA95, 0xBC6F, 0xB71F, 0xBB51, 0xBB87, 0xBCC8,
    0xC241, 0xC1A2, 0xBFB0, 0xCCD0, 0xC1C9, 0xC741, 0xD40C, 0xC9D2, 0xD4C2, 0xD820, 0xE3CC, 0xEB80, 0xEEC6, 0x0235, 0xF84C, 0x0475,
    0xFF60, 0x0F43, 0x0B31, 0x0CCD, 0x0963, 0x15CE, 0x1207, 0x156B, 0x2297, 0x0648, 0x14FC, 0x2FE6, 0x2954, 0x1942, 0x3FD4, 0x2DFB,
    0x3FE9, 0x3B15, 0x4096, 0x3249, 0x332B, 0x3D21, 0x20AB, 0x347F, 0x25BB, 0x1C01, 0x0DD4, 0x0D62, 0xFE6B, 0xEFED, 0xE85F, 0xF1FC,
    0xD98E, 0xD2B9, 0xDC03, 0xD61B, 0xD296, 0xCA11, 0xD82A, 0xCC4A, 0xD280, 0xDBE5, 0xCF31, 0xC8FB, 0xC6D8, 0xD226, 0xD029, 0xBEDB,
    0xC9F4, 0xC836, 0xC744, 0xBB81, 0xBCD1, 0xCA64, 0xC1CA, 0xCF30, 0xDA48, 0xD4F9, 0xDAFA, 0xE8E9, 0xEA0D, 0xF5DF, 0xF192, 0xFAEA,
    0x018E, 0x02A5, 0x072F, 0xFD08, 0x0DAB, 0x16EA, 0x16AC, 0x1AFD, 0x2137, 0x2ED2, 0x2C46, 0x23CC, 0x2E27, 0x2E31, 0x2931, 0x2AA4,
    0x23B5, 0x1E7E, 0x2C54, 0x2177, 0x1706, 0x1E3C, 0x1AB0, 0x0ABF, 0x00D3, 0x06E1, 0xFEEC, 0xFB37, 0xF48A, 0xF995, 0x00AB, 0xEF58,
    0xEA60, 0xF3FB, 0xEC9C, 0xEC5E, 0xF777, 0xEE12, 0xE340, 0xED2B, 0xE5D1, 0xD770, 0xE17B, 0xE11B, 0xD9EE, 0xD9EB, 0xDDDE, 0xD34B,
    0xDB7F, 0xDAC7, 0xD68C, 0xE33E, 0xDA97, 0xDDB1, 0xD9CF, 0xD60E, 0xDBC5, 0xE26E, 0xE25C, 0xED4F, 0xEC9B, 0xF215, 0x03DB, 0xFA2E,
    0x0613, 0x10D1, 0x210C, 0x2E09, 0x2E1B, 0x2CC0, 0x2AFC, 0x3381, 0x271F, 0x2083, 0x2601, 0x158B, 0x140F, 0x18B6, 0x089F, 0xFFCE,
    0x001F, 0xFAAA, 0xEABE, 0xE4CB, 0xEB15, 0xE53A, 0xDE00, 0xEC6F, 0xE27B, 0xE388, 0xEAFD, 0xEFF8, 0xF3A6, 0xE828, 0xFD87, 0xFDD2,
    0xFC88, 0xFE36, 0x0555, 0x04B2, 0xFE0A, 0xFE9C, 0xEED2, 0xFAF9, 0xF1F3, 0xFA2D, 0xF949, 0xE700, 0xFDCE, 0xF906, 0xFEF2, 0xFE09,
    0x0325, 0x0A0E, 0xFF55, 0x078D, 0x00C0, 0x0108, 0xFC79, 0x03D3, 0x0E3D, 0x08CD, 0x1421, 0x1D7D, 0x18AD, 0x1BA4, 0x2601, 0x1ABA,
    0x2152, 0x24EA, 0x224C, 0x254B, 0x1C1D, 0x127C, 0x1CB9, 0x153C, 0x0FD9, 0x12C5, 0xFC51, 0xFC0A, 0xEBC1, 0xEA69, 0xDEFA, 0xDC35,
    0xDAC6, 0xD03F, 0xD2CD, 0xD522, 0xDA25, 0xD6A3, 0xE2BE, 0xE2AC, 0xEA8A, 0xEBED, 0xF081, 0xF0E2, 0xEF3A, 0xF320, 0x00E5, 0xFF72,
    0xFB4F, 0x0A66, 0x1067, 0x17B4, 0x0983, 0x131A, 0x1B5B, 0x1777, 0x1DD9, 0x1804, 0x1B7E, 0x1F99, 0x1BF9, 0x167A, 0x12F2, 0x11EE,
    0x1302, 0x1D16, 0x155C, 0x19CD, 0x20D3, 0x22D3, 0x1F42, 0x1984, 0x20AE, 0x1097, 0x1419, 0x16A2, 0x07B9, 0xFE81, 0xF732, 0xF1A3,
    0xE4FB, 0xDF5C, 0xE386, 0xDD8C, 0xD1C4, 0xD169, 0xD7E6, 0xCD92, 0xCD33, 0xD9A7, 0xDD97, 0xDA6B, 0xE75D, 0xED8F, 0xE5A7, 0xE938,
    0xED3B, 0xF363, 0xEF24, 0xF6DD, 0xFE2D, 0xF48E, 0xFA05, 0xFCBF, 0xF0DC, 0xEFE4, 0xEA25, 0xF9A9, 0xFD61, 0xF686, 0xFEFD, 0x0A28,
    0x09C8, 0x0BAC, 0x128B, 0x1826, 0x1C86, 0x1ACA, 0x1B5F, 0x1A63, 0x1F86, 0x2697, 0x2E55, 0x24C6, 0x2E35, 0x35B1, 0x37DC, 0x383D,
    0x3AD3, 0x3BB7, 0x384F, 0x35D1, 0x3B56, 0x3320, 0x26CD, 0x27A8, 0x22FB, 0x1AFC, 0x1600, 0x0AF7, 0x06D8, 0xFDFB, 0xED3B, 0xF55B,
    0xDA41, 0xDBB2, 0xD88D, 0xD090, 0xCDA2, 0xCC32, 0xD36A, 0xD2F4, 0xCEB8, 0xCF1C, 0xD889, 0xD641, 0xDC66, 0xDB63, 0xE836, 0xE179,
    0xE841, 0xEE05, 0xE5F3, 0xE93B, 0xF19B, 0xEF9A, 0xE9E8, 0xF3BC, 0xF6B0, 0xF93D, 0xFB93, 0xFA8E, 0xF9DE, 0x051D, 0x0575, 0x0935,
    0x09BD, 0x0836, 0x0E73, 0x1478, 0x1891, 0x1F17, 0x3059, 0x3630, 0x3F5D, 0x465E, 0x4B34, 0x4C1B, 0x4BC3, 0x50BF, 0x482F, 0x49EC,
    0x40E7, 0x3F9B, 0x3237, 0x2469, 0x26D7, 0x1155, 0x05AF, 0x0447, 0xFFA4, 0xEC68, 0xEA86, 0xEA8C, 0xDF8B, 0xD5BE, 0xD632, 0xD0A7,
    0xC5EA, 0xC5B4, 0xC1BF, 0xBD5A, 0xC326, 0xBE2F, 0xB7C8, 0xBC57, 0xB364, 0xB612, 0xB3B0, 0xB122, 0xB1F6, 0xB8FC, 0xC0EE, 0xBF8B,
    0xC2C1, 0xD18B, 0xD987, 0xD828, 0xE462, 0xEE1E, 0xF136, 0xF5BC, 0x02B7, 0xFB04, 0xEF53, 0x0391, 0x075E, 0xF8CE, 0x01F4, 0x1754,
    0x1772, 0x1BD3, 0x308B, 0x2A26, 0x24C8, 0x3482, 0x351C, 0x3432, 0x31CA, 0x34FA, 0x376D, 0x2B19, 0x2702, 0x2A90, 0x26FF, 0x1CE5,
    0x1F42, 0x1B33, 0x1288, 0x1062, 0x121C, 0x06A8, 0xFEED, 0xFF31, 0xFE42, 0xFC0A, 0xF855, 0xF5BA, 0xF3E7, 0xF49E, 0xF062, 0xF2CD,
    0xF14B, 0xF126, 0xF661, 0xF278, 0xE6DD, 0xEF2C, 0xF346, 0xE707, 0xEE53, 0xF052, 0xEDF9, 0xF7F5, 0xEED0, 0xF5C4, 0xF64F, 0xF1A7,
    0xFA47, 0xF6BA, 0xF97D, 0x00F7, 0x074C, 0x04E5, 0x0C2A, 0x0EB2, 0x19A6, 0x1A71, 0x1EDA, 0x2878, 0x2628, 0x29B6, 0x2997, 0x30EE,
    0x2E32, 0x2122, 0x1B34, 0x1DFB, 0x0EC8, 0x09D6, 0x0869, 0xFB4D, 0xF520, 0xF9D7, 0xF064, 0xE3C2, 0xEF85, 0xEA84, 0xE656, 0xE6C7,
    0xEEAC, 0xEC84, 0xEC8A, 0xF485, 0xEF56, 0xF347, 0xFC5F, 0xFB23, 0xF96E, 0xF98D, 0xF255, 0xF906, 0xF78A, 0xEDCB, 0xEB54, 0xE890,
    0xE5F2, 0xE1B1, 0xDA66, 0xE59E, 0xE45F, 0xE012, 0xEC8B, 0xE8D5, 0xDCA1, 0xE1D8, 0xE7E7, 0xD8B3, 0xD6F4, 0xE0CA, 0xE406, 0xD573,
    0xDCAB, 0xE3C1, 0xDB7E, 0xDE7E, 0xF497, 0xF71E, 0xFCD2, 0x0C3D, 0x0D72, 0x1A5D, 0x18AF, 0x23B1, 0x251E, 0x2726, 0x277D, 0x25EA,
    0x28A9, 0x2366, 0x16F6, 0x18BF, 0x115A, 0x0770, 0x08CB, 0x0270, 0x0083, 0xF55F, 0xFB39, 0xF58C, 0xEF7C, 0xF275, 0xF82E, 0xF7CF,
    0xFC6D, 0x0442, 0x00F6, 0xFB67, 0x04A8, 0x1055, 0x0276, 0xFF5A, 0x08F4, 0x090C, 0x0DA5, 0x1048, 0x0B69, 0x1366, 0x12F8, 0x1515,
    0x102E, 0x0899, 0x0A7C, 0x0DB9, 0x0B7C, 0x0B1F, 0x0E2C, 0x0841, 0x0DA9, 0x0967, 0x06C9, 0x0849, 0x0A01, 0x132B, 0x0ED7, 0x1AAE,
    0x1CBE, 0x1D82, 0x28A4, 0x1B7C, 0x1D30, 0x175B, 0x113B, 0x122E, 0x09FB, 0x00F3, 0xF852, 0xF835, 0xEEEA, 0xE68D, 0xEA53, 0xE8C8,
    0xDBE9, 0xE388, 0xE1F0, 0xD37C, 0xDC8F, 0xD4CA, 0xCFC2, 0xD147, 0xD350, 0xD92F, 0xD5DB, 0xD97B, 0xD957, 0xDC0E, 0xDE56, 0xDFE4,
    0xD5E1, 0xDB2C, 0xDCCD, 0xD875, 0xDA5A, 0xDB40, 0xE8AB, 0xE873, 0xF5F6, 0xF79E, 0xFC4C, 0x0597, 0x0EAB, 0x0C32, 0x0F20, 0x214D,
    0x1846, 0x1853, 0x1BE2, 0x1A0B, 0x1694, 0x15D6, 0x1D33, 0x1C90, 0x1DB9, 0x278E, 0x290B, 0x2F6C, 0x32C2, 0x3072, 0x2E27, 0x2B16,
    0x2482, 0x1BAD, 0x1377, 0x0710, 0xFE55, 0xFC15, 0xEE76, 0xE0E6, 0xDA72, 0xD3DF, 0xC1D0, 0xBBC2, 0xC0E7, 0xB807, 0xB4D8, 0xB9A3,
    0xC2B0, 0xBB4D, 0xC8F3, 0xD4A1, 0xD0DD, 0xD13F, 0xDB82, 0xE09A, 0xDE12, 0xE534, 0xE919, 0xEB82, 0xEBEF, 0xF0D5, 0xEF37, 0xF3B8,
    0xF1B4, 0xFBA8, 0x046C, 0x0135, 0x0A5E, 0x0BEC, 0x0D0A, 0x0A68, 0x0D99, 0x14F5, 0x1725, 0x1B8C, 0x194A, 0x1AA3, 0x1798, 0x1B9D,
    0x2447, 0x2A37, 0x2E1E, 0x3BEE, 0x46C9, 0x3EBC, 0x497A, 0x482D, 0x41FD, 0x3E46, 0x40A9, 0x3A13, 0x3110, 0x2E9C, 0x1CC9, 0x134C,
    0x0D9B, 0x0688, 0xFBE4, 0xF6EF, 0xF06B, 0xE7E2, 0xE4AF, 0xE159, 0xD71B, 0xD457, 0xD5E5, 0xD6E7, 0xD678, 0xD73B, 0xD3ED, 0xD24E,
    0xD85F, 0xD256, 0xD207, 0xCF2C, 0xD2EC, 0xD11F, 0xD32F, 0xD7ED, 0xD6B2, 0xD950, 0xE46F, 0xEE90, 0xE649, 0xED91, 0xF10C, 0xF0DA,
    0xF094, 0xF2ED, 0xF3FD, 0xF2E7, 0xF8CA, 0xFA50, 0xEFAD, 0xEB08, 0xECAC, 0xEF22, 0xF1CF, 0xF8CF, 0x0910, 0x0FBF, 0x1A7D, 0x1EA3,
    0x2839, 0x2862, 0x2B7F, 0x3356, 0x341E, 0x342C, 0x38AC, 0x391B, 0x306A, 0x2B7B, 0x1FE1, 0x1BC9, 0x0DB6, 0x0709, 0x004F, 0xF9E6,
    0xF4F4, 0xEFB2, 0xEBF5, 0xE44E, 0xEE25, 0xF120, 0xEB18, 0xE8A3, 0xEB1B, 0xEC2C, 0xE4FC, 0xE216, 0xDC53, 0xDB51, 0xDC9B, 0xD3AF,
    0xD441, 0xD0DD, 0xCD04, 0xD321, 0xD0AE, 0xCFE3, 0xD265, 0xDCE1, 0xDB8C, 0xDE03, 0xE948, 0xEDF9, 0xF524, 0xF9A9, 0x04FF, 0x0140,
    0x06EC, 0x07CE, 0x0D02, 0x1231, 0x15A0, 0x21CC, 0x2457, 0x2B5D, 0x30E2, 0x3862, 0x34AD, 0x3BF3, 0x3B60, 0x323D, 0x3009, 0x2E69,
    0x2788, 0x1FA8, 0x20C0, 0x159F, 0x0F94, 0x0E46, 0x04C8, 0x00D9, 0xFD4C, 0xF814, 0xF746, 0xF168, 0xF14E, 0xF1CC, 0xF47E, 0xF2CB,
    0xF06F, 0xF4B5, 0xF233, 0xF29C, 0xED3F, 0xEB27, 0xE608, 0xE105, 0xE032, 0xDE63, 0xD998, 0xD854, 0xDD70, 0xD7A8, 0xD72B, 0xDCB2,
    0xDFEC, 0xE0AD, 0xE3F9, 0xEDEE, 0xE886, 0xE296, 0xE7F7, 0xE598, 0xE1FD, 0xE242, 0xE3C3, 0xE3DB, 0xE5C3, 0xEAAA, 0xF4BD, 0xFD25,
    0x064D, 0x11FA, 0x1BD6, 0x1CB2, 0x2395, 0x2864, 0x215C, 0x218A, 0x2180, 0x2032, 0x19B0, 0x1332, 0x12DB, 0x0E23, 0xFEF9, 0xF48A,
    0xF070, 0xE767, 0xE093, 0xE467, 0xDAE2, 0xD410, 0xDC2E, 0xE2BD, 0xE2CE, 0xE280, 0xED41, 0xF324, 0xF953, 0xFED9, 0x079B, 0x0AF2,
    0x0926, 0x1167, 0x12B5, 0x0F1F, 0x0E92, 0x13D4, 0x14D1, 0x0D0D, 0x118D, 0x1425, 0x0E30, 0x0F3D, 0x16BF, 0x1639, 0x12E9, 0x1AC7,
    0x1F2D, 0x1C65, 0x13E1, 0x11DE, 0x0D1E, 0x0571, 0x033D, 0x0633, 0x0454, 0x015A, 0x07CA, 0x06C4, 0x0458, 0x01B8, 0x0291, 0xFB20,
    0xF922, 0xFB44, 0xF850, 0xFB03, 0xF5CD, 0xF672, 0xF571, 0xF29E, 0xEDE5, 0xE9FD, 0xE8E9, 0xE1B4, 0xE3B9, 0xDFE7, 0xDAC8, 0xD913,
    0xDA0C, 0xDB34, 0xD372, 0xD726, 0xE215, 0xE22C, 0xE7FE, 0xEB9B, 0xEA4D, 0xE814, 0xE803, 0xEBCC, 0xDE8F, 0xE220, 0xEA5E, 0xE8EA,
    0xEE5A, 0xF5AB, 0xFBB5, 0xF9BF, 0x02AF, 0x05AD, 0xFFE2, 0x09B5, 0x0EF9, 0x1166, 0x1219, 0x1532, 0x1649, 0x1242, 0x12B8, 0x0F27,
    0x13D5, 0x172E, 0x190F, 0x222A, 0x241D, 0x22C1, 0x29EA, 0x2FAC, 0x2FA0, 0x2E03, 0x32AE, 0x2E4A, 0x26C2, 0x24DC, 0x1F02, 0x19BE,
    0x0CA1, 0x060A, 0xFC56, 0xEC71, 0xE446, 0xE192, 0xDC3E, 0xD2BD, 0xD969, 0xDE07, 0xD780, 0xDB50, 0xE06F, 0xDFC6, 0xDD72, 0xE516,
    0xE9EB, 0xE5CA, 0xE72A, 0xE6FB, 0xE922, 0xE212, 0xE170, 0xEA7B, 0xE5AA, 0xE066, 0xE44B, 0xE6B5, 0xDEDC, 0xE1E3, 0xECCD, 0xED47,
    0xF02F, 0xFC06, 0x05A9, 0x0C63, 0x101B, 0x16F4, 0x1B31, 0x1C8D, 0x21F9, 0x2C47, 0x2E66, 0x2EA4, 0x3787, 0x38FB, 0x37EC, 0x3D06,
    0x44F9, 0x42C0, 0x40DB, 0x3E68, 0x3F2A, 0x3893, 0x30A5, 0x2E1C, 0x2963, 0x1EE4, 0x18B7, 0x123B, 0x0147, 0xFA1D, 0xF264, 0xE66D,
    0xD460, 0xCECE, 0xCBBA, 0xC39C, 0xBDD7, 0xBAD1, 0xB9A4, 0xB9AF, 0xBDB1, 0xC131, 0xC1F1, 0xC0DE, 0xC7ED, 0xC8AE, 0xC432, 0xC75D,
    0xC8ED, 0xC705, 0xCCAE, 0xD7AE, 0xD6E5, 0xD95B, 0xE198, 0xE312, 0xE50C, 0xE983, 0xEED4, 0xF2DC, 0xFBD5, 0x00C0, 0x056E, 0x071E,
    0x0385, 0x03B7, 0x08AE, 0x0624, 0x07C1, 0x157D, 0x1ADC, 0x20E2, 0x2BEA, 0x34DB, 0x368B, 0x3AAA, 0x41F0, 0x42C7, 0x4387, 0x4207,
    0x4573, 0x4223, 0x394A, 0x398A, 0x2EB4, 0x1BD7, 0x13AA, 0x108B, 0x0144, 0xF5C3, 0xF330, 0xEEF9, 0xE4AF, 0xE54E, 0xE5DC, 0xE142,
    0xDF99, 0xE45C, 0xE73F, 0xE793, 0xE984, 0xEC3C, 0xF1D0, 0xE7A5, 0xE567, 0xE4E1, 0xDF48, 0xDC17, 0xE0E0, 0xE1CF, 0xE026, 0xE62A,
    0xEE99, 0xEEB4, 0xEE65, 0xF48B, 0xFC1A, 0xFEA4, 0x029D, 0x0C94, 0x104A, 0x0DBB, 0x0B78, 0x0B64, 0x035D, 0x06E0, 0x0E0A, 0x1080,
    0x1051, 0x1AAC, 0x222E, 0x2785, 0x2736, 0x263E, 0x2BF9, 0x2866, 0x2626, 0x263A, 0x2854, 0x1FCD, 0x22F6, 0x25B1, 0x1F71, 0x1F67,
    0x2055, 0x1A12, 0x0F93, 0x0DD8, 0x07DF, 0x0085, 0xFE07, 0xFAD4, 0xF849, 0xF4A0, 0xF45B, 0xF51D, 0xF56A, 0xF508, 0xF7D6, 0xF889,
    0xEF5E, 0xEF02, 0xECF2, 0xE4DB, 0xE466, 0xE7B6, 0xE2D0, 0xDEF7, 0xE171, 0xDBC3, 0xD731, 0xD695, 0xD3F1, 0xD08F, 0xD0A0, 0xD040,
    0xD06E, 0xD071, 0xCDBA, 0xD00B, 0xD305, 0xD18C, 0xD3F0, 0xDFAA, 0xE1C4, 0xE631, 0xF6F6, 0x002D, 0x0649, 0x0FCD, 0x17B1, 0x19A2,
    0x2044, 0x24FA, 0x2584, 0x2588, 0x26AA, 0x2A41, 0x25C4, 0x1D4F, 0x1A70, 0x171A, 0x0D2E, 0x07DE, 0x03C4, 0xFBC3, 0xF5B0, 0xF5C2,
    0xF17D, 0xEB7D, 0xEF09, 0xF369, 0xF8C8, 0xFAB9, 0xFB8A, 0x02F6, 0x061F, 0x0594, 0x085D, 0x0B8B, 0x064A, 0x071B, 0x0F13, 0x0A37,
    0x0574, 0x09AF, 0x0B86, 0x08A1, 0x085D, 0x0ABC, 0x0A76, 0x0683, 0x0C19, 0x1508, 0x1894, 0x18C3, 0x1DF3, 0x1EE1, 0x15D6, 0x1325,
    0x13A8, 0x0C7E, 0x0ABC, 0x1304, 0x1397, 0x17A9, 0x1CC9, 0x1EB1, 0x211E, 0x2220, 0x1F66, 0x1FA5, 0x20FC, 0x1C7A, 0x216B, 0x2314,
    0x173D, 0x15A3, 0x1732, 0x0864, 0xFBA7, 0xF7DC, 0xED74, 0xE331, 0xDF65, 0xDB42, 0xD2E0, 0xCEEA, 0xCAFB, 0xC8A2, 0xC9FA, 0xC54D,
    0xCA4B, 0xCCFB, 0xCC08, 0xD148, 0xD460, 0xD3D0, 0xD6FB, 0xDED2, 0xDFDD, 0xE42C, 0xEBF3, 0xF05E, 0xF617, 0xFCE2, 0xFB87, 0xFB78,
    0x0024, 0xFD1D, 0x0218, 0x06F4, 0x081B, 0x0D03, 0x0F66, 0x0A4A, 0x08DF, 0x0D03, 0x0933, 0x075B, 0x0F3C, 0x14D0, 0x19B8, 0x2200,
    0x20A4, 0x1E29, 0x1E63, 0x1D9D, 0x162D, 0x13BB, 0x106C, 0x0C52, 0x06BA, 0xFE6D, 0xFB45, 0xF359, 0xED0F, 0xE870, 0xE448, 0xDAED,
    0xD7D3, 0xD7D8, 0xD111, 0xD086, 0xD67E, 0xD59A, 0xD7B9, 0xD9D9, 0xDB19, 0xDE53, 0xDDFC, 0xE23A, 0xEB2E, 0xF3A5, 0xF1A5, 0xF8E6,
    0xFEE7, 0xF9C7, 0xFABA, 0x01B6, 0x0177, 0xFECB, 0x0729, 0x087E, 0x0716, 0x09AC, 0x0EED, 0x165B, 0x1BFC, 0x23BD, 0x2DE8, 0x2E56,
    0x28E8, 0x2CD5, 0x2F0A, 0x28B2, 0x29A6, 0x305C, 0x2FF6, 0x31C7, 0x34EF, 0x3556, 0x36C6, 0x3613, 0x32AA, 0x3350, 0x2F7B, 0x27C2,
    0x2C1A, 0x2C1D, 0x205B, 0x1F37, 0x21E4, 0x178E, 0x0F0B, 0x0F03, 0x0075, 0xEF7C, 0xEA21, 0xDE8B, 0xD34E, 0xCC55, 0xC97C, 0xC7FA,
    0xC6FB, 0xC6F1, 0xCB1D, 0xCD0C, 0xCD8C, 0xD1C4, 0xD499, 0xD0A2, 0xD328, 0xDA1D, 0xD652, 0xD581, 0xD66C, 0xD5D9, 0xD4CA, 0xD75D,
    0xD797, 0xDA13, 0xDA09, 0xD99A, 0xDDC8, 0xE1D5, 0xE126, 0xE699, 0xEDB0, 0xE9DF, 0xEFA2, 0xF4F4, 0xF1C8, 0xF1AC, 0xFAAF, 0x02E8,
    0x0D52, 0x1B5D, 0x25B1, 0x2CE5, 0x3559, 0x396E, 0x3C41, 0x3F3A, 0x4201, 0x481A, 0x483A, 0x4482, 0x4159, 0x3DF3, 0x356F, 0x2EB4,
    0x27AD, 0x1DB8, 0x1442, 0x0F20, 0x05F8, 0xFCB5, 0xF83F, 0xF287, 0xF03C, 0xEAAE, 0xE4BC, 0xE1C8, 0xDC19, 0xD2C7, 0xD4CF, 0xD5BF,
    0xCE9D, 0xD0E8, 0xD30C, 0xCD13, 0xCB2E, 0xCDF0, 0xCA04, 0xCAAE, 0xD1B7, 0xD4DC, 0xD741, 0xDDAE, 0xE112, 0xE45D, 0xE773, 0xEAB1,
    0xF545, 0xFCAA, 0xFE31, 0x0417, 0x09D0, 0x056D, 0x05BC, 0x09A6, 0x0A02, 0x0E3C, 0x1905, 0x1EB2, 0x2316, 0x295D, 0x2BBA, 0x305E,
    0x305D, 0x2D06, 0x32D8, 0x38B1, 0x33D5, 0x3675, 0x3AF2, 0x3221, 0x2D7B, 0x316A, 0x2848, 0x1EDD, 0x1B27, 0x1137, 0x0647, 0x01CF,
    0xFC93, 0xF4F1, 0xF375, 0xEEB8, 0xED58, 0xECC3, 0xE976, 0xE6EB, 0xE6D8, 0xE5DF, 0xE4E5, 0xE7DF, 0xE77D, 0xE745, 0xE781, 0xE3AC,
    0xE1C6, 0xDE8F, 0xDBF6, 0xDD17, 0xDB4C, 0xD853, 0xDA2F, 0xDB5A, 0xDA6B, 0xE36F, 0xE904, 0xE5E7, 0xE983, 0xF239, 0xEF96, 0xEF15,
    0xF59E, 0xF5D4, 0xF9FB, 0x021E, 0x0660, 0x086E, 0x0F33, 0x1373, 0x152A, 0x18BD, 0x1C31, 0x20B0, 0x201B, 0x1FBA, 0x1EF9, 0x196C,
    0x1259, 0x0FB7, 0x095E, 0xFFE3, 0xFB0F, 0xF8C3, 0xF3BA, 0xEFAC, 0xF1AF, 0xEE10, 0xEB60, 0xEB18, 0xEC82, 0xEFDC, 0xEEA8, 0xECE3,
    0xF5FB, 0xF874, 0xF3C8, 0xFAD4, 0x02FA, 0xFF08, 0xFFF0, 0x0743, 0x03CB, 0x00E2, 0x0713, 0x086C, 0x06AD, 0x07D4, 0x08F8, 0x0C3C,
    0x09C1, 0x0913, 0x0DEB, 0x0FD8, 0x0799, 0x0805, 0x0B8C, 0x0001, 0xF599, 0xF6FB, 0xF0EF, 0xEBB7, 0xF01A, 0xF1AC, 0xF138, 0xF6E0,
    0x0186, 0x0747, 0x07E7, 0x08A0, 0x11D6, 0x1337, 0x105D, 0x165E, 0x1D1F, 0x16D5, 0x175A, 0x1BDA, 0x1550, 0x0D8B, 0x0E3B, 0x086B,
    0xFE15, 0xFAAA, 0xF545, 0xF020, 0xEB25, 0xE542, 0xE1EB, 0xE1E3, 0xDE0A, 0xE00E, 0xE44B, 0xE4CA, 0xE52C, 0xEAA5, 0xEE9F, 0xEECB,
    0xF1AE, 0xF62D, 0xF680, 0xF469, 0xF6A2, 0xFD63, 0xFD6F, 0xFC81, 0x0281, 0x00D6, 0xFBAC, 0xFFC2, 0xFF5E, 0xF6F3, 0xF7D3, 0xFBBD,
    0xF9B4, 0xFD23, 0x0201, 0x0097, 0x0131, 0x03D0, 0x048F, 0x066F, 0x0DE9, 0x117B, 0x172F, 0x1C98, 0x1D59, 0x1D0F, 0x1F90, 0x1F12,
    0x1DF1, 0x1D3C, 0x1A54, 0x185F, 0x16A9, 0x12F1, 0x0FE6, 0x0ABB, 0x018C, 0xFED0, 0xFA36, 0xF426, 0xEEFE, 0xEB4F, 0xE376, 0xE101,
    0xDC97, 0xD7E3, 0xD84A, 0xD55D, 0xD17D, 0xD8F0, 0xDD78, 0xD995, 0xDCD8, 0xE207, 0xDF08, 0xDE7F, 0xE85F, 0xE833, 0xE97D, 0xF152,
    0xF860, 0xFA1E, 0xFFEE, 0x0554, 0x0FB6, 0x174C, 0x1920, 0x224D, 0x29D0, 0x2966, 0x2ADD, 0x30C3, 0x2C9A, 0x2BDA, 0x32F8, 0x3493,
    0x304A, 0x333F, 0x3897, 0x3BB8, 0x3B6F, 0x3E33, 0x4424, 0x4315, 0x3FC4, 0x4205, 0x4015, 0x36B7, 0x3363, 0x317F, 0x25D2, 0x1CB8,
    0x1862, 0x0A6A, 0xF8E0, 0xEDD0, 0xE40E, 0xD6EC, 0xCDDF, 0xC82D, 0xC426, 0xBE6C, 0xB9E7, 0xBC03, 0xBD76, 0xBC9C, 0xC092, 0xC480,
    0xC33C, 0xC43A, 0xC8E2, 0xCA52, 0xCA73, 0xCDD6, 0xD408, 0xD79F, 0xD839, 0xDE1F, 0xE4C5, 0xE251, 0xE2A9, 0xE9F9, 0xEB2C, 0xE98F,
    0xF036, 0xF67F, 0xF62B, 0xFC56, 0x031D, 0x039F, 0x0828, 0x0FCE, 0x1026, 0x1234, 0x1864, 0x1F72, 0x275A, 0x2FB2, 0x33A9, 0x398C,
    0x4182, 0x4374, 0x446E, 0x4500, 0x4278, 0x4071, 0x4141, 0x3E17, 0x39B9, 0x352D, 0x2FC2, 0x2715, 0x20A1, 0x1A9D, 0x1503, 0x0D56,
    0x07C7, 0x00AA, 0xF8CD, 0xF038, 0xEBC0, 0xE8FD, 0xE0F4, 0xE26C, 0xE257, 0xE01B, 0xE251, 0xE681, 0xE3C2, 0xE630, 0xEAFD, 0xEAB4,
    0xE8BF, 0xEF30, 0xF2DA, 0xF3CE, 0xF81F, 0xF976, 0xFEBB, 0x015A, 0xFE90, 0xFF83, 0x05C1, 0x037F, 0x060F, 0x0B49, 0x0A1A, 0x05D9,
    0x07EC, 0x0802, 0x0110, 0xFF14, 0x037E, 0x0716, 0x0916, 0x125A, 0x1D01, 0x2202, 0x2418, 0x2AAA, 0x2F70, 0x2F4C, 0x3224, 0x3790,
    0x39F4, 0x3B3C, 0x3D67, 0x3982, 0x33E5, 0x2CCC, 0x2588, 0x1B17, 0x1269, 0x0AD9, 0x054B, 0xFFB5, 0xFA41, 0xF8E2, 0xF566, 0xF14A,
    0xEF35, 0xF0D2, 0xED20, 0xEAAF, 0xE8FA, 0xE7B7, 0xE3A5, 0xE111, 0xDBD5, 0xD67C, 0xD074, 0xD08D, 0xD111, 0xCAFC, 0xC8D5, 0xCB15,
    0xCB7C, 0xC78D, 0xCC4D, 0xCE24, 0xCFC1, 0xD50C, 0xDBAA, 0xDAA4, 0xE05F, 0xE690, 0xE79F, 0xEA29, 0xEF40, 0xF222, 0xF767, 0x0366,
    0x0B17, 0x1207, 0x1A47, 0x2515, 0x2964, 0x2DC2, 0x2FDA, 0x331E, 0x33E5, 0x31AE, 0x310F, 0x311B, 0x2BCC, 0x2741, 0x268A, 0x2289,
    0x1D03, 0x1998, 0x17E8, 0x1089, 0x0A65, 0x0937, 0x08B6, 0x027E, 0x00DB, 0x02BA, 0x0069, 0xFBF9, 0xFDFF, 0xFF02, 0xF9BC, 0xFA7D,
    0xFCC5, 0xF9BF, 0xF6C8, 0xFC46, 0xFDE3, 0xFE02, 0xFFB6, 0x01EB, 0x02BF, 0x01A9, 0x0223, 0x03A9, 0x067F, 0x04F9, 0x08B9, 0x0D04,
    0x0A38, 0x0519, 0x0A4E, 0x09D6, 0x019B, 0x01DB, 0x08EC, 0x0910, 0x09D3, 0x156B, 0x1C19, 0x1CE5, 0x2183, 0x2C21, 0x2A4D, 0x2800,
    0x2AE1, 0x2FB5, 0x2CEC, 0x2A33, 0x2A6C, 0x27C0, 0x207C, 0x172A, 0x10F6, 0x05C8, 0xF7CC, 0xEE73, 0xECCC, 0xE48B, 0xDDC6, 0xDEFC,
    0xDEE4, 0xD7E8, 0xD897, 0xDD32, 0xDD49, 0xDD69, 0xE3F7, 0xE7C7, 0xE70E, 0xEB7F, 0xF0A2, 0xEFE5, 0xED70, 0xF45F, 0xF934, 0xF6FC,
    0xF71B, 0xFFA5, 0x001C, 0xFDD9, 0x015A, 0x0390, 0x000E, 0x0185, 0x06D5, 0x0572, 0x061A, 0x0AEE, 0x0E53, 0x0B12, 0x0656, 0x0226,
    0x01E2, 0x0014, 0xFD4A, 0x00CA, 0x0601, 0x05EB, 0x06E9, 0x0C65, 0x0CD4, 0x0A51, 0x0A7E, 0x0C0E, 0x0909, 0x0845, 0x082A, 0x0613,
    0x01C2, 0xFE47, 0xFBAC, 0xF71B, 0xF323, 0xEE4E, 0xEBB9, 0xE9A6, 0xE76F, 0xE49F, 0xE5B1, 0xE52E, 0xE2D0, 0xE1E6, 0xE3D2, 0xE246,
    0xE0A9, 0xE622, 0xECCB, 0xEE2F, 0xEE74, 0xF315, 0xF422, 0xF661, 0xFA88, 0xFF2A, 0x012B, 0x07FC, 0x10F2, 0x15AC, 0x1684, 0x1ACE,
    0x21F1, 0x259A, 0x27F5, 0x2924, 0x2C82, 0x2C9B, 0x23F5, 0x2377, 0x25D3, 0x2276, 0x27DA, 0x2E57, 0x2E9D, 0x2D45, 0x3502, 0x36AB,
    0x361F, 0x3AA0, 0x3D65, 0x3C29, 0x3AED, 0x3ADF, 0x3691, 0x33A7, 0x2EE5, 0x29C5, 0x242C, 0x1C50, 0x102F, 0x08A8, 0x01EA, 0xF6F3,
    0xEF7D, 0xEE9D, 0xE9D9, 0xE068, 0xDDEA, 0xDE62, 0xDAAE, 0xD835, 0xDC51, 0xDAE9, 0xD685, 0xD8F7, 0xDA52, 0xD281, 0xCF25, 0xD337,
    0xD0EC, 0xCD2D, 0xCF14, 0xD22D, 0xCF69, 0xCEED, 0xD049, 0xCF5B, 0xCDCC, 0xD1EA, 0xD88B, 0xDAB5, 0xDE64, 0xE76E, 0xEFAF, 0xF095,
    0xF4E2, 0xFCB6, 0x0112, 0x02C4, 0x0C45, 0x155D, 0x1A48, 0x1E96, 0x28EB, 0x30A5, 0x323D, 0x36C0, 0x407D, 0x4551, 0x4308, 0x469C,
    0x47AB, 0x4132, 0x3D49, 0x3F6E, 0x3614, 0x2CCC, 0x29AD, 0x2311, 0x14D7, 0x0B2C, 0x01A8, 0xF55C, 0xEBD1, 0xE424, 0xDC0A, 0xD4C8,
    0xCFA4, 0xCAD8, 0xC81E, 0xC991, 0xCD61, 0xD270, 0xD1C2, 0xD189, 0xD54E, 0xD026, 0xD1F9, 0xD8EF, 0xDB69, 0xDBEE, 0xE775, 0xEC5F,
    0xEC04, 0xED8A, 0xF743, 0xFD18, 0xFE32, 0x026C, 0x0CA2, 0x0FB2, 0x0AEC, 0x1032, 0x1455, 0x1151, 0x0F79, 0x1B0D, 0x195B, 0x1727,
    0x1BD2, 0x2548, 0x271A, 0x2E11, 0x3578, 0x3DCF, 0x4238, 0x43D5, 0x47B0, 0x4AB7, 0x4A9B, 0x4671, 0x4783, 0x423D, 0x3A49, 0x313F,
    0x2CC0, 0x1CCD, 0x1086, 0x0AFD, 0x0561, 0xF9C4, 0xF71D, 0xF4EA, 0xEE51, 0xE986, 0xE94C, 0xE419, 0xDCD9, 0xDFB9, 0xDFA0, 0xDBD7,
    0xD75A, 0xD95D, 0xD6D0, 0xD25F, 0xCFF9, 0xD078, 0xD113, 0xD140, 0xD57B, 0xDA28, 0xD8DE, 0xD4DB, 0xDB1C, 0xE0E7, 0xDE41, 0xE0CF,
    0xEBFD, 0xF0DA, 0xEDD7, 0xF45E, 0xF6B2, 0xF229, 0xED41, 0xF410, 0xF4AB, 0xF4AD, 0xF642, 0xFEA6, 0x000F, 0x016F, 0x0A51, 0x1350,
    0x1935, 0x1ED3, 0x2697, 0x23C7, 0x2678, 0x261E, 0x26FC, 0x22D4, 0x28DA, 0x2597, 0x24B7, 0x2090, 0x1FD4, 0x1665, 0x1437, 0x0CBF,
    0x06D4, 0x0871, 0x0420, 0x01FD, 0x0203, 0x0410, 0x0122, 0x0A0E, 0x0943, 0x0ACF, 0x0412, 0x08C0, 0x04F0, 0x053D, 0xFF48, 0x03DE,
    0x0549, 0x01D3, 0xFE72, 0xFE31, 0xFCB5, 0xF52E, 0xF5E8, 0xF4D0, 0xF787, 0xF34A, 0xF8C8, 0xF913, 0xF7D4, 0xED6B, 0xF1C0, 0xF1BE,
    0xEC31, 0xEA3E, 0xF420, 0xF5D2, 0xF2F3, 0xFB02, 0x03AA, 0x0556, 0x079C, 0x14BA, 0x19F9, 0x1C8B, 0x2018, 0x28AF, 0x284E, 0x24CD,
    0x21EE, 0x2019, 0x19DE, 0x11FD, 0x0D6A, 0x0752, 0xFEEE, 0xF9DF, 0xF86E, 0xF285, 0xEC19, 0xECCD, 0xED89, 0xEB1D, 0xED24, 0xF6E6,
    0xF66A, 0xF77A, 0xF9B7, 0xFA37, 0xF41B, 0xF4F3, 0xF4A1, 0xF125, 0xEEB7, 0xF1DC, 0xF457, 0xF3EA, 0xF4BE, 0xF342, 0xF69C, 0xF399,
    0xF546, 0xF55E, 0xFD96, 0xFA6E, 0x007D, 0x03DD, 0x0624, 0xFF23, 0x01E1, 0x01A0, 0xFB48, 0xF8F5, 0xFC56, 0x0274, 0x0172, 0x0AD9,
    0x119B, 0x1BA9, 0x1BBD, 0x24CE, 0x2531, 0x279B, 0x2612, 0x2C5E, 0x2975, 0x289B, 0x26E2, 0x2536, 0x1E68, 0x1703, 0x12D2, 0x0A0A,
    0x022D, 0xF5FD, 0xEE63, 0xE3DA, 0xE04A, 0xDB96, 0xDB28, 0xD36E, 0xD6DD, 0xD93C, 0xD8DD, 0xD592, 0xDD05, 0xDE42, 0xDD92, 0xE23B,
    0xE84E, 0xE789, 0xEA07, 0xF3B0, 0xF8FA, 0xFBB4, 0xFF4D, 0x084B, 0x09EE, 0x0CE3, 0x1052, 0x1556, 0x1688, 0x1E5F, 0x248D, 0x2749,
    0x2732, 0x2958, 0x2859, 0x2849, 0x2799, 0x272C, 0x2503, 0x2797, 0x28F5, 0x299C, 0x2A4F, 0x2BE5, 0x2AB5, 0x27D4, 0x26D8, 0x2787,
    0x257E, 0x20A0, 0x1DEA, 0x1850, 0x1095, 0x06C1, 0x0169, 0xF921, 0xF054, 0xE6E3, 0xE570, 0xDC38, 0xD3F5, 0xD07B, 0xD218, 0xCA43,
    0xC9D8, 0xCEF0, 0xD20B, 0xD0B9, 0xD3B3, 0xD432, 0xD113, 0xD282, 0xD269, 0xD31F, 0xD3FC, 0xD896, 0xD985, 0xE089, 0xDF71, 0xDE1A,
    0xDC0D, 0xE0AF, 0xDE3A, 0xE0BA, 0xE6E5, 0xF0A1, 0xF57E, 0xFF53, 0x082A, 0x0CFB, 0x1144, 0x131E, 0x13FC, 0x110A, 0x127F, 0x1454,
    0x1AC1, 0x1C4D, 0x225D, 0x26B2, 0x2CCA, 0x2CB8, 0x30B9, 0x3393, 0x35E9, 0x367B, 0x3A94, 0x39A2, 0x3501, 0x3344, 0x306C, 0x296A,
    0x20A7, 0x1D9F, 0x1534, 0x0B8D, 0x01F0, 0xFC02, 0xF0DC, 0xEB51, 0xE7F0, 0xE694, 0xDFB0, 0xE059, 0xE2CE, 0xE093, 0xE6BF, 0xE5EC,
    0xE90A, 0xEBF5, 0xE985, 0xEAA7, 0xEE6C, 0xEE93, 0xF039, 0xF02C, 0xF40A, 0xEEA2, 0xEC1B, 0xED9D, 0xEBCF, 0xE7DC, 0xE7F3, 0xF01E,
    0xF1F7, 0xF5DA, 0xF9F7, 0x0061, 0xFF11, 0x02ED, 0x0418, 0x0905, 0x0948, 0x0D2A, 0x1364, 0x18D6, 0x1C63, 0x2566, 0x3071, 0x3088,
    0x3549, 0x3C50, 0x411F, 0x3E17, 0x4488, 0x46A0, 0x45CF, 0x421C, 0x452B, 0x3E41, 0x3413, 0x2D68, 0x2B82, 0x1DA6, 0x0FEC, 0x0F92,
    0x0970, 0xF9FF, 0xF040, 0xF24A, 0xE81E, 0xE090, 0xE016, 0xDC7B, 0xD0CE, 0xCDF7, 0xCED9, 0xCE07, 0xC912, 0xCB75, 0xCC19, 0xCBF3,
    0xC6C3, 0xC4C4, 0xC587, 0xC2B8, 0xC132, 0xC4E8, 0xC864, 0xC5BF, 0xC8C5, 0xD0BC, 0xD614, 0xD71B, 0xE003, 0xE694, 0xE910, 0xE8C8,
    0xECDC, 0xEC24, 0xEE2B, 0xF42A, 0xFB70, 0xFFC9, 0x0763, 0x0CF7, 0x1168, 0x17A1, 0x1D98, 0x231F, 0x2915, 0x2EC4, 0x32DE, 0x39A9,
    0x3C4C, 0x3D8D, 0x3D5B, 0x3E7F, 0x3873, 0x3440, 0x2F2B, 0x26D0, 0x1A62, 0x1519, 0x0FB3, 0x05DA, 0xFEC1, 0xFEF4, 0xFC80, 0xF7C7,
    0xF878, 0xFCC1, 0xFCAE, 0xFAEB, 0xFF12, 0x005A, 0xFC0F, 0xF9D1, 0xFF05, 0xFF3F, 0xFC35, 0xFB67, 0x0076, 0xFEA5, 0xF9E5, 0xF982,
    0xFE3E, 0xFCCF, 0xFFC8, 0x0996, 0x0F89, 0x0CC9, 0x10E9, 0x14C1, 0x1115, 0x0E26, 0x1185, 0x130F, 0x1119, 0x11FC, 0x1291, 0x15A5,
    0x15CC, 0x153B, 0x1345, 0x1662, 0x1371, 0x1437, 0x1790, 0x1A7B, 0x16DB, 0x18D9, 0x17E9, 0x1228, 0x0B24, 0x0845, 0x0388, 0xFB16,
    0xF623, 0xF3CE, 0xF08E, 0xE820, 0xE839, 0xE603, 0xE23C, 0xDF62, 0xE3D4, 0xE193, 0xE0EF, 0xE228, 0xE584, 0xE57C, 0xE78B, 0xEA71,
    0xEDC6, 0xEE5B, 0xEEE9, 0xF29D, 0xF47B, 0xF4F2, 0xF538, 0xF7CF, 0xF2FB, 0xEFBC, 0xF00D, 0xF192, 0xEF16, 0xF210, 0xF536, 0xF578,
    0xF2E6, 0xF51D, 0xF3EA, 0xED44, 0xEC9F, 0xEF63, 0xEB6F, 0xEAB5, 0xF2BB, 0xF55D, 0xF4D8, 0xFC39, 0x0221, 0x016F, 0x0582, 0x0BBE,
    0x0C90, 0x0F47, 0x152E, 0x1764, 0x175B, 0x16C5, 0x1525, 0x12A7, 0x0E96, 0x076C, 0x038E, 0xFFC1, 0xFA5F, 0xF3B4, 0xF16D, 0xEB98,
    0xE70A, 0xE45C, 0xE4F9, 0xE37D, 0xE55C, 0xE9A3, 0xEF2D, 0xF0E2, 0xF3CD, 0xF9DE, 0xFF30, 0x048C, 0x083E, 0x0C52, 0x0BB4, 0x0DFA,
    0x0B46, 0x0CF0, 0x0CD1, 0x0EA3, 0x0E00, 0x14CE, 0x16A5, 0x1636, 0x17E2, 0x1C44, 0x1B5D, 0x1C6A, 0x200B, 0x1E0E, 0x1DB1, 0x1C1E,
    0x1A07, 0x1608, 0x183D, 0x1497, 0x17DF, 0x1B63, 0x1E93, 0x1DD0, 0x2400, 0x263D, 0x2741, 0x2887, 0x2963, 0x2550, 0x208C, 0x1E4B,
    0x1B31, 0x14C3, 0x0B8D, 0x0765, 0x0194, 0xFA29, 0xF24B, 0xEF5E, 0xE6DD, 0xDE9B, 0xD75A, 0xD579, 0xCF51, 0xCAA9, 0xC949, 0xCA9D,
    0xC5BF, 0xC208, 0xC5D1, 0xC707, 0xC558, 0xCAF5, 0xD25E, 0xD179, 0xD43E, 0xDAEB, 0xDB2A, 0xD8F7, 0xDC4F, 0xE127, 0xE44E, 0xE81C,
    0xEFD5, 0xF649, 0xFABF, 0xFF56, 0x04B2, 0x04F6, 0x0686, 0x09F2, 0x0CF0, 0x0E85, 0x167F, 0x1BE4, 0x2207, 0x288B, 0x2DF2, 0x3010,
    0x369C, 0x3839, 0x37A1, 0x3AE6, 0x3BC4, 0x38E0, 0x3749, 0x3528, 0x2C2B, 0x27F8, 0x20A6, 0x17DD, 0x0EB7, 0x0BCB, 0x00E4, 0xF922,
    0xF052, 0xE853, 0xDCDD, 0xD625, 0xCF16, 0xCAF2, 0xC973, 0xC7D1, 0xC913, 0xC9F6, 0xCB90, 0xC928, 0xCC2A, 0xCC8F, 0xCF55, 0xD04E,
    0xD9C8, 0xDE12, 0xE017, 0xE33A, 0xEAF7, 0xE98C, 0xE83A, 0xEF3B, 0xF32C, 0xF118, 0xF78C, 0x032B, 0x0229, 0x0438, 0x0B5B, 0x10C4,
    0x105A, 0x167E, 0x1BCA, 0x1FBA, 0x1F19, 0x1FF7, 0x23F7, 0x2823, 0x2892, 0x2E0E, 0x35B1, 0x3452, 0x333D, 0x36B8, 0x37D8, 0x32BA,
    0x3336, 0x367B, 0x34A0, 0x2EC6, 0x2B34, 0x2712, 0x1D88, 0x1532, 0x1090, 0x0C2D, 0x0158, 0xF9F6, 0xF3DA, 0xEC3F, 0xE3DC, 0xDEBB,
    0xDCB4, 0xDA08, 0xD5AD, 0xD37D, 0xD545, 0xD03E, 0xCFB5, 0xD496, 0xD7C9, 0xD380, 0xDA25, 0xDEA3, 0xDAF1, 0xD7B3, 0xDB53, 0xD80E,
    0xD690, 0xDAA2, 0xDEA5, 0xDFAD, 0xDE45, 0xE1C8, 0xE20C, 0xE13C, 0xDF4A, 0xE5A4, 0xE340, 0xE26E, 0xE4E9, 0xEAB1, 0xE756, 0xEC95,
    0xF545, 0xFB60, 0x0017, 0x078B, 0x0FCB, 0x1520, 0x197D, 0x1D04, 0x24CB, 0x21A4, 0x236D, 0x298B, 0x2BBA, 0x2335, 0x265B, 0x2718,
    0x1F54, 0x1958, 0x18F4, 0x1082, 0x0831, 0x084A, 0x0683, 0x0344, 0x00A5, 0x0035, 0xFC28, 0xFA59, 0xF6FA, 0xF5F3, 0xF3A6, 0xF110,
    0xED8C, 0xEC81, 0xEBD2, 0xEA94, 0xEAA1, 0xED50, 0xEEE4, 0xEA61, 0xE82D, 0xE8BC, 0xE4D8, 0xDF59, 0xE486, 0xE908, 0xE7B4, 0xEC28,
    0xF2E9, 0xF286, 0xEFEA, 0xF383, 0xF3FA, 0xF2D4, 0xF196, 0xF3FF, 0xF7A9, 0xFAF2, 0xFDD2, 0x06D8, 0x0E18, 0x0DED, 0x121A, 0x1A8A,
    0x1CDD, 0x1AD6, 0x20E9, 0x2385, 0x20C1, 0x1E13, 0x20B8, 0x1BF4, 0x15D1, 0x1348, 0x1460, 0x0F13, 0x0C0D, 0x0C9A, 0x082B, 0x00F6,
    0xFB38, 0xF6E8, 0xF04E, 0xEE9C, 0xE978, 0xE73A, 0xE674, 0xE492, 0xE041, 0xE474, 0xE4F2, 0xE385, 0xE711, 0xEA5C, 0xE82D, 0xE98A,
    0xEC90, 0xE87D, 0xE786, 0xE605, 0xE36D, 0xE1DA, 0xE5EB, 0xE6C4, 0xE9D0, 0xED16, 0xF199, 0xF472, 0xF430, 0xF130, 0xF148, 0xF1B5,
    0xEF6B, 0xF5B9, 0xFE16, 0x037F, 0x0709, 0x0E9E, 0x1349, 0x162B, 0x1949, 0x205F, 0x2396, 0x1FE6, 0x2073, 0x2543, 0x21E2, 0x1A74,
    0x1D49, 0x1988, 0x0C91, 0x04CC, 0x02B6, 0xF608, 0xEC51, 0xEAF6, 0xE925, 0xE4C0, 0xE391, 0xE3DF, 0xE176, 0xE08A, 0xE06E, 0xE420,
    0xE53B, 0xE6CE, 0xE82A, 0xECD2, 0xEDB0, 0xF0A3, 0xF4D2, 0xFAEC, 0xFEA7, 0x0175, 0x0547, 0x08D9, 0x0C00, 0x0DEA, 0x149C, 0x19AD,
    0x1E8E, 0x2271, 0x2801, 0x28A1, 0x2A48, 0x2791, 0x253B, 0x2341, 0x1F69, 0x18F5, 0x1574, 0x1213, 0x0C92, 0x0F5D, 0x11E5, 0x0FE1,
    0x0FCA, 0x1623, 0x1385, 0x106F, 0x12A8, 0x1388, 0x0E46, 0x0CF7, 0x0C5A, 0x04CA, 0xFC07, 0xF85B, 0xF532, 0xEAB1, 0xE497, 0xE232,
    0xDD90, 0xD6AE, 0xD632, 0xD377, 0xCFD5, 0xCF14, 0xCEE1, 0xCCFA, 0xCAFE, 0xC7AB, 0xC47E, 0xC81E, 0xC85A, 0xCA89, 0xD109, 0xD602,
    0xD4FE, 0xDC40, 0xE1D9, 0xE36C, 0xE7F3, 0xEE04, 0xEE0D, 0xF080, 0xF65C, 0xF7B1, 0xFC07, 0x0255, 0x05FF, 0x07B3, 0x0B9A, 0x09FA,
    0x0815, 0x0981, 0x0ECC, 0x0EBC, 0x142D, 0x1986, 0x1DA2, 0x1EF6, 0x2370, 0x263A, 0x24B4, 0x291F, 0x2C0A, 0x2B7A, 0x2E75, 0x32C0,
    0x337F, 0x30A6, 0x33A4, 0x303D, 0x2314, 0x2083, 0x1E45, 0x1457, 0x093B, 0x09C4, 0x043F, 0xFBEC, 0xF60A, 0xF733, 0xF280, 0xEAC9,
    0xE4E4, 0xE877, 0xE707, 0xE223, 0xE2C6, 0xE659, 0xDEB4, 0xDA3C, 0xEDFF, 0xF5C9, 0xEF22, 0xED08, 0xEF0B, 0xEDA3, 0xEBCB, 0xEC03,
    0xEF8C, 0xF129, 0xF5BD, 0xF6E2, 0xFCE8, 0xFE8C, 0x08DD, 0x066C, 0x0993, 0x1098, 0x1238, 0x1150, 0x13F5, 0x12FB, 0x0DAE, 0x12F5,
    0x14D9, 0x1149, 0x1355, 0x1E1D, 0x1E06, 0x1F28, 0x2899, 0x312A, 0x2E8C, 0x35AA, 0x3992, 0x4045, 0x362F, 0x3810, 0x3839, 0x2C0B,
    0x16C6, 0x0D2C, 0x06E0, 0xFD4B, 0xFCA0, 0xF80B, 0xF793, 0xF2C2, 0xF272, 0xEAD5, 0xE6D5, 0xE2B8, 0xE111, 0xDCB9, 0xDDE6, 0xE078,
    0xE25F, 0xD997, 0xD6AE, 0xD977, 0xD9E1, 0xD264, 0xD9A8, 0xDE5A, 0xD8E8, 0xD8D0, 0xDF78, 0xE237, 0xE2FC, 0xEBD2, 0xF04F, 0xF429,
    0xF378, 0xF3C4, 0xF248, 0xF516, 0xF449, 0xF81C, 0xFB3F, 0x004E, 0x0040, 0x0477, 0x0466, 0x04AE, 0x0688, 0x0DB2, 0x1190, 0x1594,
    0x1CC6, 0x2196, 0x1EB5, 0x1FA7, 0x22E2, 0x1FD7, 0x1C27, 0x1E57, 0x200F, 0x17B3, 0x15A9, 0x15C7, 0x164E, 0x0FB2, 0x121B, 0x1176,
    0x1519, 0x10B3, 0x126D, 0x126D, 0x11BB, 0x0A99, 0x0BAA, 0x0DDF, 0x09B3, 0x06E0, 0x0963, 0x0A22, 0x044E, 0x07E7, 0x0AE5, 0x08C4,
    0x0401, 0x0B45, 0x0CEA, 0x0D84, 0x0FFC, 0x18E1, 0x1572, 0x1802, 0x1B7E, 0x1FD0, 0x1B22, 0x1C06, 0x1C5F, 0x1BA8, 0x1681, 0x1220,
    0x106A, 0x0C04, 0x0592, 0xFCF1, 0xFCED, 0xF7EC, 0xF27B, 0xED04, 0xF1A1, 0xEF03, 0xEF1C, 0xEF83, 0xF453, 0xF3D0, 0xF33A, 0xF2B1,
    0xF809, 0xF76D, 0xF461, 0xF4D3, 0xF9B7, 0xF930, 0xF9D6, 0xFEF9, 0x0381, 0x046D, 0x04B1, 0x06D0, 0x0677, 0x07DE, 0x07BA, 0x0B80,
    0x0B50, 0x113B, 0x131B, 0x155D, 0x1458, 0x18F7, 0x12C4, 0x0D1C, 0x0D46, 0x0D1D, 0x03E8, 0x033B, 0x064C, 0x01F8, 0xFD79, 0xFFD0,
    0xFD68, 0xF7F4, 0xF809, 0xF7BC, 0xF4E6, 0xF255, 0xF3BD, 0xF196, 0xF0A0, 0xEB75, 0xECD3, 0xE920, 0xE798, 0xE243, 0xE636, 0xE1FE,
    0xDDB9, 0xDC76, 0xE43A, 0xE1C6, 0xE025, 0xE650, 0xEA5F, 0xE680, 0xE5DB, 0xEC9B, 0xEAB2, 0xE75F, 0xE71A, 0xEB79, 0xE9CF, 0xEBA3,
    0xEA70, 0xEFF4, 0xF14B, 0xF69A, 0xF4B9, 0xFF81, 0x0118, 0x02BB, 0x039E, 0x0A7D, 0x0C71, 0x0B8A, 0x0FD3, 0x1308, 0x12C7, 0x12BA,
    0x15E3, 0x1566, 0x1608, 0x1A6E, 0x1AF9, 0x1BE5, 0x22A4, 0x2152, 0x22A0, 0x1F90, 0x29F0, 0x22FD, 0x27CC, 0x2286, 0x2A09, 0x21E2,
    0x225F, 0x2091, 0x2077, 0x1E8D, 0x15BF, 0x15B3, 0x0C6A, 0x0B5F, 0xFFAF, 0x0437, 0xFFBA, 0xFFF8, 0xFC13, 0xFF53, 0xFF07, 0xFDD0,
    0xFC38, 0xFAB4, 0xF818, 0xF6DC, 0xEF12, 0xEF9C, 0xEB09, 0xEBFD, 0xE584, 0xEAB9, 0xE5F6, 0xE295, 0xDF39, 0xDB52, 0xD827, 0xD03B,
    0xD6B1, 0xCF42, 0xD4DF, 0xCEE4, 0xD7ED, 0xCEF1, 0xD340, 0xD588, 0xDC30, 0xDB2D, 0xDEBF, 0xE6C9, 0xE3AD, 0xE3EB, 0xE56C, 0xEAA8,
    0xEA79, 0xEC96, 0xF2ED, 0xF757, 0xFBF9, 0xFB6D, 0x000A, 0x0467, 0x06CB, 0x0E15, 0x114E, 0x1A87, 0x1626, 0x1F45, 0x1580, 0x1975,
    0x14F0, 0x17AC, 0x0D7E, 0x0ED1, 0x1183, 0x069F, 0x048D, 0x0418, 0x06B3, 0xF845, 0xFD5D, 0xFC55, 0xF996, 0xEFC7, 0xEF58, 0xEE68,
    0xE861, 0xE618, 0xE37D, 0xE343, 0xE032, 0xDC39, 0xDCBE, 0xDAA8, 0xDCC8, 0xD5C2, 0xDBD7, 0xDA26, 0xDD33, 0xDB79, 0xE1A8, 0xE1F8,
    0xDE2C, 0xE3B1, 0xE1EF, 0xE58C, 0xE2B8, 0xEDBD, 0xE866, 0xECBE, 0xEEDD, 0xF5F8, 0xF6BD, 0xF9AB, 0x0047, 0x026C, 0x06E1, 0x0766,
    0x0F13, 0x140F, 0x15A8, 0x1A0F, 0x1E13, 0x218A, 0x18EF, 0x1A68, 0x1826, 0x15FC, 0x10A2, 0x122C, 0x167F, 0x113B, 0x16AD, 0x1278,
    0x15BF, 0x0D3A, 0x1342, 0x0B1A, 0x0A36, 0x078C, 0x02FC, 0xFC41, 0xF72E, 0xF9E9, 0xF18D, 0xF1DC, 0xEC7C, 0xEE00, 0xE993, 0xE683,
    0xE4CB, 0xE488, 0xE4E3, 0xDEEA, 0xE1EC, 0xE2E4, 0xE1B3, 0xDFA0, 0xE0D2, 0xE789, 0xE40F, 0xE844, 0xE78C, 0xEF2A, 0xE85A, 0xE7CD,
    0xE7FB, 0xE8A3, 0xE532, 0xE022, 0xE5BF, 0xE05C, 0xE157, 0xDBE0, 0xDFFA, 0xD992, 0xD943, 0xD904, 0xDAC3, 0xDBF0, 0xDC29, 0xE4EA,
    0xE38F, 0xE801, 0xEC1C, 0xF08C, 0xECB7, 0xF025, 0xF7D7, 0xF3A9, 0xF7FF, 0xFEE5, 0x056E, 0xFFC7, 0x059E, 0x0A3F, 0x08E0, 0x0C98,
    0x0FD1, 0x1653, 0x129B, 0x189A, 0x18CE, 0x1B6D, 0x1859, 0x18DD, 0x1A16, 0x116E, 0x1248, 0x0A82, 0x103B, 0x0605, 0x04CC, 0x05D7,
    0x02C1, 0xFC9E, 0xF404, 0xFAE5, 0xEF05, 0xF02D, 0xEE12, 0xF95A, 0xF276, 0xF700, 0xF98B, 0xF798, 0xF5E7, 0xEF8A, 0xF622, 0xF156,
    0xF613, 0xEEB9, 0xF76B, 0xF60E, 0xF6B9, 0xF401, 0xF8EA, 0xF84D, 0xF0EE, 0xF38B, 0xF3DA, 0xF23C, 0xEA6D, 0xEB65, 0xE820, 0xE35D,
    0xE126, 0xE292, 0xE312, 0xE522, 0xE91F, 0xEF6C, 0xF4D8, 0xFBC9, 0xF8FF, 0xFCB6, 0xFCE8, 0x00BB, 0xFF57, 0x0357, 0x04B9, 0x02AC,
    0x07CE, 0x0475, 0x07EE, 0x0292, 0x0840, 0x00D0, 0x056C, 0x0115, 0x0277, 0x00DA, 0xFDB0, 0x003C, 0xFF39, 0x0594, 0xFE59, 0x06F8,
    0x0311, 0x04FF, 0xFC57, 0x0214, 0x0296, 0xFF73, 0xFD9F, 0xFEED, 0x018F, 0xF81F, 0xFA30, 0xFBB1, 0xFC18, 0xF65E, 0xFB8F, 0xFFFE,
    0x0273, 0x03AD, 0x05E0, 0x0710, 0x09AC, 0x042F, 0x040C, 0x0549, 0x075F, 0xFDA8, 0xFFE5, 0xFEEB, 0xF825, 0xF252, 0xF28A, 0xF3FA,
    0xEA2E, 0xED26, 0xE999, 0xEDA9, 0xE380, 0xE881, 0xE7E1, 0xE8CB, 0xE50A, 0xEA17, 0xEF78, 0xE834, 0xEC1A, 0xEDB6, 0xF4A0, 0xED89,
    0xF57F, 0xF7D9, 0xF785, 0xF080, 0xF542, 0xFF2F, 0xFC2D, 0x005E, 0x0B31, 0x15A0, 0x1163, 0x18B9, 0x21F4, 0x252F, 0x25EE, 0x29ED,
    0x2FAE, 0x3196, 0x2FB6, 0x2DBB, 0x3058, 0x320B, 0x2C65, 0x2EDD, 0x3157, 0x2E6B, 0x2572, 0x23F0, 0x2470, 0x1D33, 0x194B, 0x14F5,
    0x17A8, 0x0B67, 0x091C, 0x0281, 0x02A7, 0xF89F, 0xF742, 0xF6FF, 0xF2A5, 0xF0B1, 0xE96A, 0xEBDA, 0xE21D, 0xE2D4, 0xDEE2, 0xE5A5,
    0xDD33, 0xDD83, 0xDE5A, 0xDB70, 0xD796, 0xDA6C, 0xDE45, 0xD84B, 0xD924, 0xD89D, 0xD95C, 0xD7CB, 0xDA9D, 0xDDE5, 0xE455, 0xE761,
    0xE992, 0xEF18, 0xF608, 0xF462, 0xFA2C, 0xFFF2, 0x0575, 0x025B, 0x089C, 0x0A1E, 0x0B0F, 0x08C7, 0x0BD5, 0x11AA, 0x1088, 0x168E,
    0x16BC, 0x1BF7, 0x1832, 0x1F0A, 0x1E3F, 0x21C4, 0x24E1, 0x2601, 0x2338, 0x223F, 0x260E, 0x1E5F, 0x1F06, 0x1B09, 0x1847, 0x124A,
    0x132A, 0x111B, 0x0F34, 0x11B5, 0x0E42, 0x0F6B, 0x0BA5, 0x0B05, 0x06C2, 0x06CF, 0x0332, 0x0529, 0x0792, 0x01C1, 0x01A6, 0x03FF,
    0x016B, 0xF8E6, 0xFC99, 0xFF0F, 0xF6AD, 0xEFE0, 0xF15F, 0xF335, 0xE840, 0xE52C, 0xED81, 0xEB62, 0xE50B, 0xE7A4, 0xF439, 0xECDF,
    0xEEF4, 0xF4D2, 0xFEF6, 0xFC4D, 0x028D, 0x0BDE, 0x0FAD, 0x1179, 0x0F94, 0x1C6C, 0x1B88, 0x1F2B, 0x1EBE, 0x2A17, 0x2593, 0x28B7,
    0x2DED, 0x3160, 0x2FBB, 0x2ED1, 0x31A9, 0x2F5F, 0x2E3D, 0x2BCB, 0x31EA, 0x32B0, 0x2EBC, 0x2D0F, 0x2E7B, 0x29B0, 0x21FE, 0x1F1A,
    0x2067, 0x18D4, 0x1244, 0x0DD9, 0x10C0, 0x042B, 0xFF37, 0x002E, 0x0238, 0xF764, 0xF57B, 0xF882, 0xF056, 0xEA7F, 0xE509, 0xE807,
    0xE26E, 0xE1DC, 0xDBCE, 0xDFF1, 0xDDE0, 0xD980, 0xDB08, 0xDE51, 0xDD62, 0xD808, 0xDC90, 0xDBF4, 0xDCB0, 0xDBA8, 0xDD73, 0xE052,
    0xE1AA, 0xE3A8, 0xE397, 0xEB36, 0xEB50, 0xEE90, 0xF2A7, 0xFB38, 0x0077, 0x033F, 0x0A33, 0x1112, 0x1585, 0x13CB, 0x195E, 0x1900,
    0x13F7, 0x15CD, 0x1A9F, 0x19AF, 0x1A9A, 0x2342, 0x2382, 0x20E4, 0x2328, 0x21C9, 0x21AB, 0x1D8A, 0x1F6C, 0x1EC2, 0x23DF, 0x1CB9,
    0x1F2E, 0x2209, 0x1E27, 0x1773, 0x1A4D, 0x1EB1, 0x1312, 0x1251, 0x1194, 0x124A, 0x0653, 0x0AD2, 0x0DF6, 0x0CE5, 0x0498, 0x08EA,
    0x0BCE, 0x05C5, 0x07FA, 0x10E9, 0x13E8, 0x115C, 0x1700, 0x189D, 0x144C, 0x12C0, 0x15C8, 0x16F5, 0x15AB, 0x15C3, 0x1AA4, 0x1623,
    0x1101, 0x0EFB, 0x14F6, 0x0BCC, 0x0B5E, 0x0DD1, 0x0E13, 0x0459, 0x027B, 0x050C, 0x0211, 0x028A, 0x02BC, 0x08AA, 0x047F, 0x02E7,
    0xFEDE, 0x0167, 0xFDF1, 0xF8EE, 0xF6A8, 0xF5BF, 0xF68B, 0xF2BD, 0xF515, 0xFB89, 0x01AA, 0x002D, 0x0437, 0x0C44, 0x08F0, 0x0628,
    0x07A1, 0x0C9A, 0x09A8, 0x0AFD, 0x0D00, 0x0FAA, 0x0D07, 0x087E, 0x0BB5, 0x0BF0, 0x04E7, 0x012A, 0x05F8, 0x010C, 0xFAB5, 0xFC4C,
    0xFAD5, 0xF46F, 0xF12B, 0xF13E, 0xEDA3, 0xE98C, 0xE708, 0xE3CB, 0xE5EA, 0xE1D5, 0xE4BD, 0xE802, 0xEDC3, 0xE8BC, 0xECB9, 0xF0F2,
    0xF25F, 0xEED6, 0xEF80, 0xF6E3, 0xF329, 0xF278, 0xF552, 0x0035, 0xF98D, 0xF97F, 0xFDA1, 0xFF30, 0xF78A, 0xFAE4, 0x015F, 0x0438,
    0x0568, 0x089F, 0x0DD6, 0x11CB, 0x10B6, 0x108D, 0x1966, 0x19C9, 0x0CAE, 0x0E51, 0x1447, 0x0D30, 0xFF8B, 0xEE42, 0xF327, 0xDE91,
    0xC7C6, 0xD156, 0xE00D, 0xD9C7, 0xDBE9, 0xE504, 0xF104, 0xF41F, 0xFC93, 0x0DE9, 0x0AFC, 0x0B08, 0x0F7B, 0x0F69, 0x0A66, 0x09AC,
    0x03D5, 0x029B, 0xFFA1, 0xFEB9, 0x0069, 0xFC39, 0xFD0F, 0x06D5, 0x0804, 0x06AC, 0x0B51, 0x0EC0, 0x0E8E, 0x0F3B, 0x152E, 0x1DAE,
    0x20C0, 0x24B3, 0x2826, 0x253E, 0x2A0C, 0x32D0, 0x2E58, 0x310B, 0x3FD2, 0x42B2, 0x3CBF, 0x3674, 0x3750, 0x33BE, 0x2845, 0x244A,
    0x1937, 0x0178, 0xF1EE, 0xF533, 0xEC75, 0xD6D7, 0xD60D, 0xCCE2, 0xBD3B, 0xB28F, 0xB6BE, 0xB805, 0xB95F, 0xC027, 0xC680, 0xC4FD,
    0xC9B7, 0xDDAE, 0xE2BF, 0xE109, 0xEA9C, 0xF39B, 0xED48, 0xEECC, 0xF53B, 0xFA60, 0xF8CE, 0xFAB6, 0x02C4, 0x0836, 0x05E5, 0x0B61,
    0x1178, 0x1787, 0x1393, 0x179F, 0x1CA0, 0x1791, 0x1547, 0x17B4, 0x1932, 0x15B2, 0x1ECB, 0x1617, 0x19B9, 0x215B, 0x252E, 0x2702,
    0x2E33, 0x3DC2, 0x4572, 0x42E4, 0x3CE0, 0x3F91, 0x38F8, 0x3341, 0x3A30, 0x2FE3, 0x16B6, 0x1364, 0x1069, 0xFA65, 0xEEF5, 0xEB58,
    0xDCD8, 0xC7FC, 0xBCD6, 0xBB42, 0xB4A9, 0xB453, 0xB8FB, 0xC135, 0xC014, 0xC594, 0xD2CD, 0xD8EB, 0xDBCC, 0xDE3C, 0xEE7B, 0xF126,
    0xEE63, 0xF263, 0xFCC5, 0xFC80, 0xF741, 0x03A9, 0x0CE4, 0x0E0E, 0x0C18, 0x1F4B, 0x2133, 0x1B15, 0x21DB, 0x28A7, 0x254A, 0x251B,
    0x2663, 0x26B5, 0x3299, 0x2BAF, 0x2AB3, 0x2A3A, 0x303D, 0x2998, 0x28BD, 0x317B, 0x3AE3, 0x448C, 0x4474, 0x4EFD, 0x4C39, 0x433D,
    0x4794, 0x4E06, 0x4229, 0x3478, 0x3605, 0x31ED, 0x286A, 0x1FA9, 0x1EA8, 0x168A, 0x0323, 0xF618, 0xE7EC, 0xE142, 0xD499, 0xD6D6,
    0xD22A, 0xD171, 0xCE8B, 0xD221, 0xD32F, 0xCA16, 0xD15E, 0xCBB5, 0xCC06, 0xC80D, 0xCF96, 0xC9FE, 0xCB83, 0xCDB2, 0xCF03, 0xD0F6,
    0xCEFB, 0xDCAB, 0xDF36, 0xE28B, 0xE900, 0xF1AB, 0xF213, 0xF919, 0xFF30, 0x0158, 0x087C, 0x1418, 0x1D8A, 0x1BE4, 0x25A3, 0x30E7,
    0x3663, 0x361B, 0x424B, 0x5495, 0x572D, 0x6271, 0x67C5, 0x63E2, 0x5D88, 0x6205, 0x6410, 0x5623, 0x4CE5, 0x4917, 0x444C, 0x3341,
    0x335C, 0x2FDD, 0x23C7, 0x165C, 0x0BC8, 0xFD9C, 0xE924, 0xE80B, 0xE2F3, 0xE27B, 0xD9C4, 0xDF5F, 0xE249, 0xE12D, 0xE154, 0xE6B0,
    0xE9A9, 0xDDAF, 0xE174, 0xE0D5, 0xDFAD, 0xCF31, 0xD81B, 0xDD36, 0xD3B5, 0xCF70, 0xD1BE, 0xD4DE, 0xCF14, 0xD157, 0xD502, 0xDF79,
    0xE17D, 0xE708, 0xE8A7, 0xE733, 0xECE7, 0xEDE0, 0xF1A9, 0xF8C3, 0xFCAF, 0xF986, 0xFE0B, 0x09F8, 0x0B42, 0x1EAD, 0x2E36, 0x3710,
    0x34F0, 0x3A52, 0x3FEF, 0x3F83, 0x416C, 0x3A11, 0x3A44, 0x30CB, 0x30C0, 0x26CD, 0x2202, 0x15C4, 0x0987, 0xF9EC, 0xEACE, 0xDF9D,
    0xD12D, 0xD05A, 0xC721, 0xC5C8, 0xC294, 0xC943, 0xC813, 0xC6C4, 0xD0C9, 0xD546, 0xCEE0, 0xD29C, 0xDEA8, 0xD7FF, 0xDFA9, 0xE7BB,
    0xEEA2, 0xF1CB, 0xF189, 0xFB56, 0x0395, 0x0B48, 0x061D, 0x0A31, 0x0F6D, 0x0E20, 0x0CDB, 0x09E0, 0x0DAD, 0x0C2C, 0x079E, 0x0267,
    0x0FC2, 0x0AB2, 0x0200, 0x07EB, 0x06BF, 0x0A6C, 0x08DF, 0x117C, 0x10CB, 0x0FAD, 0x0B24, 0x128F, 0x1604, 0x0EB8, 0x0CDA, 0x0989,
    0x0FEE, 0x0BB5, 0x122B, 0x11C8, 0x13AF, 0x1408, 0x0F8F, 0x02E0, 0xF9C0, 0xFA40, 0xF168, 0xF144, 0xF0AB, 0xF6EF, 0xF6B8, 0xF18F,
    0xF1B5, 0xF889, 0xF68F, 0xF097, 0xF9D7, 0xFA0F, 0xF44B, 0xF638, 0xF738, 0xF2CB, 0xEFF5, 0xE88F, 0xE770, 0xEDEB, 0xE5D7, 0xE981,
    0xEA03, 0xECFA, 0xF7A3, 0xFAF3, 0x031F, 0x082E, 0x1081, 0x0CB9, 0x14CC, 0x188A, 0x18E5, 0x18C8, 0x169E, 0x111E, 0x056A, 0x0F65,
    0x0F40, 0x123E, 0x0F8A, 0x1299, 0x120A, 0x1519, 0x16E1, 0x10FF, 0x1189, 0x0F7B, 0x12CD, 0x0759, 0xFFF0, 0xF708, 0xF773, 0xEF3E,
    0xE3E6, 0xDE05, 0xD4F7, 0xD159, 0xCB37, 0xCFEC, 0xD9A4, 0xDD9E, 0xDC1C, 0xE417, 0xF0C7, 0xED2A, 0xF083, 0xF9AF, 0xFD02, 0xF9F2,
    0xF8EB, 0xFBA4, 0xF910, 0xF7D2, 0xEAB9, 0xED74, 0xEE4C, 0xF150, 0xE890, 0xEC92, 0xF292, 0xEF71, 0xF3EC, 0xF789, 0x02FB, 0xF9B4,
    0x036A, 0x0567, 0x0729, 0x077D, 0x1344, 0x198E, 0x14C1, 0x1C06, 0x284A, 0x35B9, 0x3B25, 0x4A24, 0x4ADB, 0x4CF6, 0x4F53, 0x505E,
    0x4E35, 0x46C1, 0x4270, 0x3C49, 0x343C, 0x2B5A, 0x2583, 0x1E2A, 0x1430, 0x0A8E, 0xFBF1, 0xF459, 0xE6C5, 0xE3C2, 0xE265, 0xDEBD,
    0xDCD3, 0xD246, 0xD0A0, 0xCF47, 0xD9D5, 0xD6E9, 0xDB52, 0xDDAF, 0xE2EF, 0xE56E, 0xEA5B, 0xFA5C, 0xFD17, 0xFD1E, 0xFBF0, 0x0FC7,
    0x0BFC, 0x0AC1, 0x0FB9, 0x167A, 0x186B, 0x171A, 0x2011, 0x1EF2, 0x215B, 0x1962, 0x1D44, 0x19DB, 0x170C, 0x1CE2, 0x1AAE, 0x13BF,
    0x0F14, 0x1273, 0x102F, 0x1386, 0x194C, 0x1A82, 0x173E, 0x199E, 0x20B9, 0x1A23, 0x180A, 0x1580, 0x1660, 0x1509, 0x0C52, 0x0F58,
    0x105F, 0x0BD4, 0xFE65, 0xFF4B, 0xF2A9, 0xE5F0, 0xDA4C, 0xD4EE, 0xCBD2, 0xC133, 0xC77E, 0xBCE2, 0xC16B, 0xBCED, 0xC497, 0xC699,
    0xC26C, 0xC6F3, 0xCEA3, 0xD004, 0xD294, 0xDCFB, 0xCE15, 0xCC1E, 0xD415, 0xDBB9, 0xD818, 0xDDC6, 0xE6F4, 0xE92A, 0xF3E9, 0xFD90,
    0x059B, 0x08A1, 0x133E, 0x15BF, 0x15B8, 0x213A, 0x296E, 0x2C3C, 0x29EC, 0x2FC3, 0x2EA9, 0x2F1D, 0x382C, 0x3FB2, 0x4319, 0x3FBA,
    0x4895, 0x4842, 0x47DB, 0x4182, 0x4106, 0x41FB, 0x3C95, 0x315B, 0x2A3C, 0x311E, 0x207A, 0x1A8E, 0x156F, 0x0D62, 0xFF07, 0xF9F5,
    0xF253, 0xEE4E, 0xF44D, 0xEE7E, 0xEFEA, 0xF28D, 0xFBE4, 0xF4BA, 0xF8E8, 0xFE82, 0xF9D9, 0xF2FD, 0xF0D0, 0xF488, 0xEC7C, 0xE434,
    0xE096, 0xDF1D, 0xDD14, 0xDF36, 0xDFCB, 0xD8DE, 0xDB33, 0xDF30, 0xE10C, 0xDE05, 0xDC81, 0xDCBC, 0xD421, 0xD2B0, 0xD33A, 0xDEB2,
    0xDCCD, 0xDCCB, 0xE2E4, 0xEAD9, 0xE87C, 0xF162, 0x055C, 0x0822, 0x11F1, 0x207A, 0x30AD, 0x2F94, 0x36A6, 0x39E5, 0x3A2E, 0x3797,
    0x3369, 0x32B9, 0x2F70, 0x2CE2, 0x23AA, 0x1F82, 0x123A, 0x0963, 0x0281, 0xF684, 0xF2DF, 0xEFE3, 0xE876, 0xDC92, 0xDD87, 0xDF04,
    0xD99A, 0xD7E6, 0xDE86, 0xE2C9, 0xDAD5, 0xDEDC, 0xE9B5, 0xF235, 0xEC97, 0xEFF4, 0xFBF5, 0xF882, 0xF8B2, 0xFC22, 0xFDC1, 0xF9E0,
    0xFD90, 0xF9A9, 0xF65E, 0xF97E, 0xF75F, 0xF370, 0xEA64, 0xF236, 0xF53C, 0xF6D8, 0xF91A, 0x0285, 0x041C, 0x0268, 0x098C, 0x0C97,
    0x0C84, 0x0883, 0x184F, 0x1E30, 0x20C1, 0x1E31, 0x2343, 0x263A, 0x2239, 0x2142, 0x209C, 0x22B2, 0x1AAA, 0x1E55, 0x1E9E, 0x1551,
    0x0AC4, 0x07C5, 0xF8CC, 0xE8F8, 0xEBC7, 0xE227, 0xD634, 0xD35E, 0xD377, 0xCC5B, 0xCA18, 0xD0DA, 0xD05A, 0xCDA3, 0xCDBC, 0xD6E0,
    0xD62B, 0xD6A5, 0xD6CA, 0xD94D, 0xDD0E, 0xDDC6, 0xE089, 0xDF9C, 0xE644, 0xE67C, 0xE9D7, 0xEEFA, 0xFABE, 0x01CE, 0x074E, 0x09AA,
    0x0A04, 0x119F, 0x1148, 0x14D0, 0x17F2, 0x15CE, 0x0716, 0x076E, 0x0D0F, 0x02AE, 0xFEDA, 0x0DFC, 0x15EE, 0x123E, 0x1B06, 0x1FD8,
    0x2116, 0x2227, 0x21EB, 0x1B85, 0x13AB, 0x0B4D, 0x0698, 0x028D, 0xFBDF, 0xF51D, 0xEBED, 0xE1AC, 0xDD3C, 0xDB48, 0xD5E9, 0xD521,
    0xD6DA, 0xD977, 0xDB04, 0xE2CF, 0xE7FE, 0xEBB8, 0xE9EC, 0xECCE, 0xF346, 0xF4BC, 0xF644, 0xF717, 0xF3DA, 0xEFA3, 0xF202, 0xF0E7,
    0xEC2C, 0xEC40, 0xF2D0, 0xEF5C, 0xEA06, 0xEE6A, 0xEEE4, 0xE9E2, 0xE79F, 0xE5E1, 0xE52E, 0xE4BF, 0xE763, 0xE83F, 0xE631, 0xE36B,
    0xEAA5, 0xEF7A, 0xF307, 0xFAC4, 0x0394, 0x09B5, 0x0CBF, 0x1669, 0x18E2, 0x1C4C, 0x19AB, 0x18B5, 0x11DF, 0x0954, 0x026F, 0x010A,
    0xFFDA, 0xFA12, 0xFBCA, 0xF32D, 0xE722, 0xDE51, 0xE024, 0xD7F4, 0xCEAF, 0xCD63, 0xC9DA, 0xC4B6, 0xC45C, 0xCD96, 0xCBF5, 0xCC50,
    0xD06C, 0xDB48, 0xE240, 0xE75B, 0xEFBA, 0xF35A, 0xFB02, 0x01DC, 0x09B9, 0x0CC8, 0x13C5, 0x162B, 0x1919, 0x1936, 0x1ADA, 0x227B,
    0x24DB, 0x231D, 0x1CED, 0x20A0, 0x1EA1, 0x1D73, 0x2228, 0x2268, 0x1B28, 0x1A1D, 0x1A44, 0x10B0, 0x12CD, 0x1961, 0x1C0F, 0x1E84,
    0x2A4C, 0x2EA8, 0x2ABC, 0x3218, 0x3665, 0x32A9, 0x2FED, 0x3402, 0x3309, 0x2F90, 0x2A7E, 0x27FF, 0x23C2, 0x17E5, 0x0B25, 0xFEF9,
    0xF3E8, 0xE22A, 0xD3FE, 0xCC5E, 0xC9BA, 0xC5AC, 0xC838, 0xCAF6, 0xC3E6, 0xBDE8, 0xC046, 0xC48B, 0xC196, 0xBF3F, 0xBB19, 0xB9CC,
    0xBAB5, 0xBC33, 0xBC21, 0xC006, 0xC541, 0xC596, 0xCA6B, 0xD2EB, 0xDBDF, 0xE0F4, 0xEB57, 0xF1BC, 0xF486, 0xFC9E, 0x04AE, 0x0857,
    0x0B92, 0x0E7F, 0x1077, 0x164F, 0x17A3, 0x1C52, 0x1FE2, 0x23B3, 0x2906, 0x2E78, 0x3295, 0x37BC, 0x3D75, 0x3FF4, 0x3EC3, 0x3819,
    0x34DF, 0x3050, 0x29D0, 0x221B, 0x1F7D, 0x1A43, 0x0E07, 0x064D, 0xFFA3, 0xF8CE, 0xF3E9, 0xF1F4, 0xEF4E, 0xEE46, 0xEE41, 0xEF84,
    0xF3B5, 0xF505, 0xF387, 0xEFAA, 0xF02E, 0xEFDC, 0xED33, 0xE845, 0xE792, 0xEB54, 0xEB50, 0xEA45, 0xEBC4, 0xEF3C, 0xED05, 0xF0B5,
    0xF565, 0xF8C8, 0xFBB9, 0xF9E2, 0xF526, 0xF5B2, 0xF73D, 0xF4CF, 0xF8DD, 0xFAEC, 0xF887, 0xF8B1, 0xFB52, 0xF8F6, 0xFB33, 0x0269,
    0x0628, 0x10E1, 0x1A3A, 0x1D82, 0x2210, 0x2904, 0x2AC2, 0x2A8E, 0x2A44, 0x2780, 0x21A9, 0x19FC, 0x179B, 0x1262, 0x0DBD, 0x05AA,
    0xFDE6, 0xF699, 0xED83, 0xE1D9, 0xD9F4, 0xD56F, 0xCDAC, 0xC83C, 0xCA56, 0xCEEA, 0xC725, 0xC5C9, 0xCA7F, 0xCB07, 0xCD0E, 0xD867,
    0xDD24, 0xDD44, 0xE5FC, 0xEA49, 0xE836, 0xEC68, 0xF52B, 0xF429, 0xF19A, 0xF07E, 0xF1E7, 0xF60F, 0xF746, 0xF7A1, 0xFCF8, 0x02B5,
    0x03A9, 0x069C, 0x0A02, 0x0C11, 0x0EC3, 0x1260, 0x13CA, 0x0FA1, 0x0B38, 0x0960, 0x0ACB, 0x0DC0, 0x1246, 0x14C4, 0x18FB, 0x21D9,
    0x2824, 0x27F4, 0x2AA4, 0x33C7, 0x3166, 0x3126, 0x38D7, 0x3A9E, 0x349E, 0x3094, 0x2D41, 0x2462, 0x1BB0, 0x1423, 0x0EFE, 0x03DE,
    0xFB4B, 0xF708, 0xF8DA, 0xF337, 0xEBA6, 0xEE07, 0xEE1A, 0xEAAB, 0xE7C0, 0xE929, 0xE4BF, 0xE2DA, 0xDFEA, 0xDFC5, 0xDB96, 0xD8F1,
    0xD947, 0xD5C5, 0xD250, 0xD492, 0xDEAB, 0xE1C9, 0xE70B, 0xEE9D, 0xF382, 0xF223, 0xF91F, 0xFFA8, 0xFCB4, 0xFBEE, 0xFE3A, 0xFDA3,
    0xF78B, 0xF527, 0xF4BF, 0xF72B, 0xFA93, 0xFEE0, 0x0426, 0x075B, 0x0FA8, 0x18ED, 0x1E25, 0x1CFD, 0x1BD7, 0x177D, 0x1009, 0x0E20,
    0x0D40, 0x0AE6, 0x0224, 0xFD82, 0xFB7F, 0xF722, 0xF0C7, 0xF1C9, 0xEFB1, 0xE97D, 0xED35, 0xF3F5, 0xF739, 0xF5C8, 0xF90A, 0xF952,
    0xFB59, 0x004D, 0x00DA, 0xFF03, 0x01BF, 0x015E, 0xF9F7, 0xFA5A, 0xF9D5, 0xF6BE, 0xF3CD, 0xF1BD, 0xEEEC, 0xF019, 0xF378, 0xF30B,
    0xF6A9, 0xF76D, 0xF6C3, 0xFADB, 0x026B, 0x01BD, 0x04EF, 0x0D18, 0x1123, 0x11FE, 0x1717, 0x1E65, 0x1F55, 0x21D5, 0x2799, 0x2C4F,
    0x2BCE, 0x30FC, 0x313F, 0x30EF, 0x2E65, 0x2D80, 0x22D0, 0x1FC4, 0x20B9, 0x1807, 0x12B0, 0x0D15, 0x06FB, 0xF672, 0xF407, 0xE990,
    0xDD18, 0xCB75, 0xC0ED, 0xBD4E, 0xBA94, 0xBA2C, 0xB5AB, 0xBAAF, 0xB87B, 0xBDC8, 0xC4F5, 0xD175, 0xD390, 0xDDB2, 0xEA79, 0xEBDE,
    0xF123, 0xF691, 0x0026, 0xFBE5, 0xFEC3, 0x026C, 0x0985, 0x0990, 0x0CD7, 0x13AF, 0x0F51, 0x12E1, 0x1443, 0x19AC, 0x14AE, 0x1B12,
    0x1D32, 0x1A7D, 0x1A04, 0x17BB, 0x16B5, 0x0F07, 0x12F2, 0x1120, 0x157E, 0x1488, 0x1BD1, 0x2365, 0x2738, 0x2DA7, 0x3194, 0x36B1,
    0x3286, 0x36FA, 0x33E4, 0x33B9, 0x30D5, 0x2D29, 0x23A9, 0x1A15, 0x14FD, 0x0994, 0xFC54, 0xE9BE, 0xE484, 0xDF73, 0xD81B, 0xD380,
    0xD4EB, 0xCFBD, 0xCD61, 0xD51B, 0xD6DA, 0xD262, 0xD20F, 0xD3F0, 0xD032, 0xCF6E, 0xD1B5, 0xD1E7, 0xD196, 0xD1A1, 0xD1AD, 0xD75A,
    0xDB8B, 0xE1A3, 0xE914, 0xEDE7, 0xF0C4, 0xF6B1, 0xFB49, 0xFA5D, 0xFED3, 0x0464, 0x0573, 0x0449, 0x0712, 0x052E, 0xFCEF, 0xFF47,
    0x0293, 0x01D6, 0xFE6D, 0x0982, 0x118F, 0x1171, 0x1897, 0x2096, 0x2336, 0x1E44, 0x2485, 0x21A5, 0x22DA, 0x1F6F, 0x1D3F, 0x18D0,
    0x152E, 0x154E, 0x1064, 0x1186, 0x0621, 0x0451, 0xFD7D, 0xFC31, 0xF7BD, 0xF93C, 0xF693, 0xF0A9, 0xF8CB, 0xF55A, 0xF471, 0xF09B,
    0xF887, 0xF231, 0xF48C, 0xFB0B, 0xFC4C, 0xFB60, 0xF914, 0x0038, 0xF994, 0xFD40, 0xFA72, 0xFE47, 0xF79A, 0xF92B, 0xFD7A, 0xF874,
    0xF8A4, 0xF6CF, 0xFE52, 0xFD74, 0x0672, 0x0826, 0x0D7C, 0x0D25, 0x0CE5, 0x137C, 0x1545, 0x1B61, 0x1D22, 0x2A48, 0x2D5B, 0x326F,
    0x3854, 0x3A4F, 0x38B2, 0x3462, 0x36EF, 0x302D, 0x2F36, 0x25F9, 0x2130, 0x1964, 0x1321, 0x0BF0, 0x0124, 0xF7BD, 0xE69A, 0xDD52,
    0xD125, 0xCDF2, 0xC5B8, 0xC0DB, 0xBF6A, 0xC218, 0xBF1A, 0xBCEE, 0xC590, 0xC7BC, 0xC6F7, 0xC77E, 0xCE51, 0xCF25, 0xCF6C, 0xCF7E,
    0xCFFB, 0xCE28, 0xCD76, 0xCEA5, 0xCFFD, 0xCF34, 0xD159, 0xD669, 0xD98F, 0xD9BC, 0xDD49, 0xE513, 0xEB57, 0xF49C, 0xF969, 0xFBD2,
    0xF7D5, 0xFA0E, 0xFC09, 0xF8CE, 0xF90B, 0xFCBF, 0x0186, 0x042A, 0x1469, 0x1E70, 0x24BD, 0x29ED, 0x33A5, 0x3619, 0x35FA, 0x4039,
    0x3FF4, 0x3F2B, 0x3A23, 0x3CDC, 0x3800, 0x32CF, 0x277B, 0x1D44, 0x175D, 0x0A60, 0x04FC, 0xFBED, 0xF7AC, 0xEE0A, 0xF128, 0xEFFF,
    0xED1F, 0xF202, 0xF38F, 0xF1C6, 0xEB25, 0xF34A, 0xF0BD, 0xF34D, 0xF5CE, 0xF910, 0xF754, 0xF3C3, 0xFB69, 0xF925, 0xFDA8, 0xFB91,
    0x0302, 0x0185, 0x0489, 0x044F, 0x02A5, 0x064F, 0x0234, 0x0667, 0xFE62, 0xFCFF, 0xF219, 0xF5EB, 0xF024, 0xEA77, 0xEDEB, 0xED64,
    0xF073, 0xF0D8, 0xFE9E, 0xFB59, 0xF80C, 0xF615, 0xF692, 0xF051, 0xEF50, 0xF1E4, 0xEB1B, 0xEA70, 0xE9F0, 0xF00D, 0xF0B2, 0xF0A0,
    0xED57, 0xED0A, 0xED91, 0xE9E2, 0xEAD5, 0xE915, 0xEAC0, 0xE63E, 0xE86C, 0xED9A, 0xEF71, 0xEFED, 0xF158, 0xF6C0, 0xF2B7, 0xF197,
    0xF316, 0xF6A2, 0xF50D, 0xF3D4, 0xF513, 0xF4F0, 0xF52F, 0xF153, 0xF155, 0xF292, 0xF3B0, 0xF32A, 0xF590, 0xFB6D, 0xFD31, 0x012E,
    0x07EE, 0x0F17, 0x1266, 0x15DD, 0x1B5D, 0x1A70, 0x1B46, 0x1B71, 0x1C41, 0x1C66, 0x2174, 0x2728, 0x2685, 0x2944, 0x24C0, 0x2225,
    0x1F3F, 0x244D, 0x21E7, 0x1D12, 0x1D1F, 0x19F9, 0x1B9A, 0x1799, 0x147F, 0x0484, 0xFD83, 0xF055, 0xE6C7, 0xE05F, 0xD746, 0xD346,
    0xCDB0, 0xD0FA, 0xCBB9, 0xD4CB, 0xD788, 0xDCF0, 0xE00A, 0xE703, 0xED2F, 0xED02, 0xF70D, 0xF4C0, 0xF7DD, 0xF35B, 0xF93F, 0xF5A1,
    0xF339, 0xF3B0, 0xF0B5, 0xF305, 0xEBDC, 0xF009, 0xEED9, 0xF53A, 0xF2F3, 0xFA25, 0xFD3B, 0xFA07, 0xFA4D, 0xF89F, 0xFE76, 0xF652,
    0xFE9F, 0xFF1B, 0x03EE, 0x0830, 0x1206, 0x1A3E, 0x1E06, 0x2E24, 0x2A49, 0x2E65, 0x2FD8, 0x362B, 0x2E4F, 0x2DAF, 0x2F4D, 0x2B2E,
    0x2C81, 0x245A, 0x1FC7, 0x0FFA, 0x0CBA, 0x008E, 0xFD1A, 0xF6F7, 0xEF5C, 0xEB5B, 0xE5B6, 0xE6B9, 0xDF00, 0xE05F, 0xDC1B, 0xDA98,
    0xD63A, 0xD758, 0xD790, 0xD45D, 0xD79C, 0xD8A9, 0xDD1C, 0xDEE2, 0xE64F, 0xE990, 0xEDC1, 0xF36C, 0xF71B, 0xFD40, 0x0031, 0x033A,
    0x03E4, 0x0B3C, 0x107D, 0x1267, 0x13C3, 0x14C0, 0x14FA, 0x105D, 0x0DFE, 0x0D5E, 0x0A4F, 0x0687, 0x0770, 0x0D6A, 0x0DC0, 0x10DB,
    0x149E, 0x139E, 0x10BF, 0x0EDC, 0x1333, 0x0F98, 0x0C2E, 0x050D, 0x071B, 0x039F, 0xFDD9, 0xFD16, 0xFBA4, 0xF688, 0xEBBC, 0xEDC5,
    0xE6BB, 0xE15E, 0xDC48, 0xDB7E, 0xD627, 0xD312, 0xD685, 0xCFF0, 0xD121, 0xCFBC, 0xD5F4, 0xD20F, 0xD664, 0xDADD, 0xDB22, 0xDFFA,
    0xE304, 0xED68, 0xE69D, 0xEBDB, 0xE96F, 0xF05D, 0xED05, 0xEED3, 0xF374, 0xF24E, 0xF974, 0xFAD2, 0x0AD6, 0x0889, 0x1264, 0x1516,
    0x1C54, 0x1B07, 0x1F52, 0x271B, 0x20C8, 0x284E, 0x2B28, 0x3612, 0x32AE, 0x3B69, 0x3B6B, 0x3914, 0x3A9D, 0x383C, 0x3BC3, 0x3294,
    0x3337, 0x2ACE, 0x2FCE, 0x2775, 0x2053, 0x1DB6, 0x16E6, 0x0EE8, 0x032E, 0x0829, 0xFA6E, 0xF878, 0xF266, 0xF0B0, 0xE7BA, 0xE8F3,
    0xED1D, 0xE7CD, 0xEB1E, 0xE872, 0xEB94, 0xE73D, 0xEDD4, 0xEA03, 0xE757, 0xE7C1, 0xE501, 0xE076, 0xD86F, 0xD9B3, 0xD632, 0xD95D,
    0xD79E, 0xD738, 0xD4B4, 0xD49C, 0xD7CA, 0xD82B, 0xDEAD, 0xDCED, 0xDDC5, 0xDC7E, 0xDFD8, 0xDD8D, 0xDD0E, 0xDE02, 0xE0B5, 0xE4E6,
    0xEB44, 0xF891, 0x044B, 0x0BE3, 0x1209, 0x1DC6, 0x2659, 0x2BB2, 0x2E52, 0x327A, 0x30B1, 0x32B9, 0x3275, 0x34A8, 0x2FFF, 0x2B71,
    0x23B5, 0x1C17, 0x11E8, 0x0746, 0x0593, 0xFDF1, 0xF73A, 0xF14C, 0xF58A, 0xF128, 0xF017, 0xF334, 0xF48E, 0xF5A5, 0xF5BA, 0xFD4D,
    0xFE99, 0x022E, 0x0175, 0x05E8, 0x0936, 0x08B2, 0x0F20, 0x0CB6, 0x1320, 0x1161, 0x1587, 0x11AB, 0x1238, 0x1357, 0x1427, 0x0FC7,
    0x0B38, 0x0DAF, 0x03F4, 0x051C, 0x00D5, 0x0742, 0xF86C, 0xF99B, 0xFAF3, 0xFD8B, 0x020C, 0x0A2E, 0x148C, 0x092A, 0x131A, 0x12D6,
    0x169B, 0x0DA1, 0x10A1, 0x0ECA, 0x0963, 0x0C37, 0x07D3, 0x0D83, 0x0244, 0x03A9, 0xFE25, 0xFF98, 0xF58F, 0xF1F0, 0xF077, 0xE2C3,
    0xDF27, 0xD828, 0xD9F4, 0xCCB4, 0xD1F8, 0xCCB9, 0xCC40, 0xC9A0, 0xCCAE, 0xCFE0, 0xCE67, 0xD55A, 0xD3C4, 0xDADC, 0xDABD, 0xE226,
    0xE144, 0xE9E7, 0xEF4E, 0xF052, 0xF41B, 0xF816, 0xFD4C, 0xFC6B, 0x047F, 0x096F, 0x10AA, 0x13EE, 0x1543, 0x1A18, 0x1D34, 0x1D24,
    0x16CB, 0x1B3A, 0x1AA1, 0x1B8B, 0x2142, 0x2714, 0x25C3, 0x27C6, 0x2F5A, 0x31CB, 0x332A, 0x31BE, 0x30EF, 0x2DE1, 0x3119, 0x2F14,
    0x2B67, 0x2549, 0x21B0, 0x1686, 0x0CA1, 0x03C9, 0xFEA6, 0xF400, 0xE903, 0xE63F, 0xE1EE, 0xDE56, 0xDC16, 0xE2DF, 0xE30F, 0xE64E,
    0xE9D5, 0xF0C6, 0xF356, 0xF410, 0xF8B7, 0xFDE6, 0x0294, 0xFDC6, 0x0126, 0x0219, 0x02A3, 0x01CD, 0x046D, 0x0593, 0xFFB4, 0x031C,
    0xFDF8, 0x0059, 0xFCC1, 0x035E, 0xFF53, 0xFFF9, 0x0191, 0xFDDE, 0xFA1E, 0xF148, 0xF446, 0xE7F1, 0xEAD5, 0xED89, 0xFA99, 0xF801,
    0xFEA8, 0x07AE, 0x0B80, 0x11E1, 0x1146, 0x15D2, 0x10AD, 0x14C8, 0x1097, 0x11D7, 0x0F08, 0x08F9, 0x0537, 0xFF42, 0xFBC9, 0xF242,
    0xF13F, 0xE6A3, 0xE35D, 0xE65A, 0xE080, 0xDD05, 0xDA23, 0xDBBF, 0xD41C, 0xD639, 0xD962, 0xDBBD, 0xD7D5, 0xDC4E, 0xDFDD, 0xE2B1,
    0xE795, 0xEB5A, 0xF544, 0xFA13, 0x046B, 0x06F4, 0x0F6D, 0x1045, 0x11F0, 0x14CF, 0x1AA4, 0x212F, 0x1FD6, 0x241C, 0x25ED, 0x272D,
    0x22F7, 0x2300, 0x234D, 0x1E2C, 0x1750, 0x142F, 0x1CD8, 0x1D88, 0x1F79, 0x25FF, 0x3140, 0x31CD, 0x343A, 0x3B50, 0x3986, 0x359F,
    0x346D, 0x34E9, 0x2F8D, 0x30E6, 0x2ED3, 0x28E1, 0x210E, 0x1DA7, 0x1421, 0x0C23, 0x0213, 0xFA8D, 0xF2C3, 0xEC33, 0xE3BC, 0xDE2C,
    0xD948, 0xD373, 0xD3D4, 0xD3F2, 0xD33F, 0xCE00, 0xD088, 0xD0CD, 0xD097, 0xCF10, 0xD274, 0xCFB6, 0xCEBA, 0xD56A, 0xDAC9, 0xDB1B,
    0xDC59, 0xE2C0, 0xE2CE, 0xE38F, 0xED04, 0xF5DE, 0xFA73, 0xFE44, 0x0957, 0x0C9C, 0x0F2C, 0x1010, 0x1057, 0x0DCF, 0x0E09, 0x175C,
    0x1AAA, 0x2191, 0x23D1, 0x2CDD, 0x2DD8, 0x34C1, 0x36A7, 0x38C7, 0x3948, 0x374C, 0x3803, 0x37CA, 0x3A13, 0x34D9, 0x37AC, 0x32F8,
    0x2B62, 0x2594, 0x23F8, 0x19B3, 0x0B66, 0x07B0, 0xFF20, 0xF6EB, 0xF300, 0xF54C, 0xEFF7, 0xEB7F, 0xEE6A, 0xED8B, 0xEB24, 0xE74D,
    0xEB7F, 0xE8EF, 0xE94F, 0xE58B, 0xE2F8, 0xE044, 0xE15E, 0xE399, 0xE366, 0xE54B, 0xE358, 0xE574, 0xE5FB, 0xE976, 0xEDBF, 0xF33C,
    0xF46A, 0xF81F, 0xFEA3, 0x00BE, 0xFCAE, 0xF968, 0xF301, 0xEEAF, 0xED51, 0xF267, 0xF6F1, 0xFE36, 0x0222, 0x087E, 0x1377, 0x196D,
    0x180F, 0x1982, 0x2262, 0x2071, 0x1E15, 0x2046, 0x2444, 0x1C65, 0x165D, 0x148B, 0x111A, 0x0824, 0x0144, 0xFBED, 0xF5CC, 0xEF5B,
    0xEB6D, 0xE95B, 0xEB18, 0xE960, 0xE8B4, 0xEAC1, 0xEDDA, 0xEDCA, 0xEED3, 0xF326, 0xF2E9, 0xF766, 0xF939, 0xFB51, 0xFA69, 0x01A9,
    0x0094, 0x029E, 0x08E9, 0x0B7E, 0x0946, 0x0B1D, 0x12DD, 0x1251, 0x136A, 0x1469, 0x184D, 0x1990, 0x1DB7, 0x21EE, 0x2085, 0x1BD9,
    0x145D, 0x13A3, 0x11D4, 0x11C1, 0x112C, 0x1375, 0x1763, 0x1A81, 0x1E8F, 0x1DA1, 0x1F02, 0x1B0A, 0x1C0C, 0x1B06, 0x1C57, 0x1E1D,
    0x2213, 0x1F0C, 0x1B10, 0x1E66, 0x1A80, 0x11B0, 0x0DCF, 0x0EE6, 0x0631, 0xFDDD, 0xFB3B, 0xF81A, 0xEFAF, 0xE9CE, 0xE93B, 0xE688,
    0xDFF6, 0xDD61, 0xDB48, 0xDA1D, 0xD822, 0xD9DB, 0xD80E, 0xD988, 0xD988, 0xD831, 0xD6E7, 0xD6EC, 0xD533, 0xD292, 0xD35F, 0xD03F,
    0xD3A7, 0xD81B, 0xDA5E, 0xDBEC, 0xE5D6, 0xECC7, 0xF260, 0xF943, 0xFA4C, 0xF525, 0xF644, 0xF93D, 0xF9F2, 0xFC14, 0x0212, 0x064C,
    0x0E63, 0x15B9, 0x1923, 0x1BD9, 0x1E24, 0x2272, 0x24DE, 0x2AF8, 0x2D27, 0x3119, 0x2DEA, 0x2BF2, 0x27E9, 0x2221, 0x1974, 0x1120,
    0x0BB5, 0x0399, 0x003F, 0xFB41, 0xF92F, 0xF41C, 0xF42F, 0xF687, 0xF7EF, 0xFA0C, 0xFCAA, 0xFFFA, 0xFD9C, 0x05FC, 0x0C28, 0x08ED,
    0x04AC, 0x0D42, 0x0D3A, 0x04D3, 0x0793, 0x0C3B, 0x09ED, 0x03A1, 0x07FA, 0x08A4, 0x0F23, 0x0BBE, 0x0DD7, 0x1271, 0x14A4, 0x1394,
    0x13DE, 0x1B06, 0x1229, 0x0CD6, 0x06A0, 0x087C, 0x070F, 0x04AC, 0x0942, 0x0EB1, 0x19A2, 0x18F7, 0x1E5F, 0x2079, 0x2309, 0x2370,
    0x1E88, 0x253F, 0x2404, 0x2023, 0x14A0, 0x19CC, 0x13D5, 0x03F0, 0xFB63, 0xF46F, 0xEE06, 0xDFCF, 0xDB3D, 0xD469, 0xD106, 0xC809,
    0xC484, 0xC75A, 0xC47E, 0xC00B, 0xBF9E, 0xC2AE, 0xC5DE, 0xC99A, 0xCE9A, 0xD10F, 0xD829, 0xDC46, 0xDE66, 0xE5E5, 0xEA76, 0xEFF8,
    0xF003, 0xF573, 0xFB81, 0x0113, 0x00A6, 0x02B7, 0x0C31, 0x0E04, 0x0EFB, 0x1506, 0x19E9, 0x13F9, 0x1050, 0x104F, 0x1171, 0x14BA,
    0x11C8, 0x14AE, 0x1E8B, 0x234C, 0x21F8, 0x2A29, 0x3504, 0x3006, 0x2E6F, 0x319A, 0x325B, 0x3262, 0x3150, 0x3292, 0x327A, 0x3190,
    0x2A52, 0x2449, 0x20AB, 0x17FE, 0x10EF, 0x0B22, 0x0879, 0xFDBC, 0xF391, 0xEFA5, 0xEAAE, 0xE547, 0xDF15, 0xDFEC, 0xDA89, 0xDCF8,
    0xE255, 0xDE8D, 0xDF27, 0xE21B, 0xE31F, 0xD933, 0xE1B6, 0xE32B, 0xDC1F, 0xDD3D, 0xE0CE, 0xE292, 0xDF82, 0xE9B9, 0xE818, 0xEBC8,
    0xECFA, 0xF43A, 0xFBFC, 0xFBF2, 0xFC9C, 0xFCBE, 0x0009, 0xF898, 0xFAA6, 0xFA66, 0xF9A1, 0xF987, 0xFD73, 0x036D, 0x064C, 0x0C33,
    0x111D, 0x16D8, 0x1873, 0x1CE4, 0x236B, 0x25B8, 0x278B, 0x2CA0, 0x2B3C, 0x28AE, 0x2A47, 0x26EF, 0x1C53, 0x16C8, 0x139A, 0x09CD,
    0x05B1, 0x00CE, 0xFF20, 0xFB6C, 0xF6B2, 0xF569, 0xF518, 0xF309, 0xEF6E, 0xFB72, 0xFCC8, 0xF67A, 0xF60A, 0xF8C1, 0xF48F, 0xEEF3,
    0xF507, 0xF1E7, 0xF126, 0xECAC, 0xEE1D, 0xF1EB, 0xF107, 0xF0B1, 0xEFEF, 0xF5CF, 0xF3FD, 0xFAF8, 0xFDB3, 0xFE34, 0xFE39, 0xFA8B,
    0xFA10, 0xF8BC, 0xF969, 0xF70A, 0xFC0B, 0x0228, 0x0933, 0x13D7, 0x1975, 0x20DF, 0x2922, 0x2DCD, 0x2E0A, 0x328A, 0x3844, 0x32D3,
    0x3243, 0x323F, 0x2DE3, 0x2802, 0x21C2, 0x1C70, 0x1314, 0x0B10, 0xFF31, 0xF85A, 0xF321, 0xEB62, 0xE64A, 0xE0A2, 0xDFEA, 0xDBC2,
    0xD63C, 0xD71C, 0xDA00, 0xD687, 0xD639, 0xDB19, 0xD876, 0xD394, 0xDAE9, 0xDE58, 0xDF50, 0xE348, 0xE7EC, 0xEAE4, 0xEF6E, 0xF7CA,
    0xF098, 0xF458, 0xF307, 0xF4A2, 0xF6E1, 0xFEDE, 0x01A6, 0xFD9A, 0x032B, 0xFEA3, 0x02F8, 0xFE68, 0xFFBE, 0xFDD8, 0x023A, 0x0577,
    0x041F, 0x0E37, 0x1064, 0x177E, 0x15F7, 0x1F78, 0x2473, 0x22BE, 0x26B0, 0x2D13, 0x348F, 0x2FF9, 0x3A0E, 0x3924, 0x3616, 0x32F6,
    0x32CB, 0x29FE, 0x211F, 0x1CC6, 0x0FFB, 0x0977, 0xFFE3, 0xFC99, 0xF504, 0xED82, 0xE930, 0xEBF4, 0xE696, 0xE56C, 0xE7EF, 0xEEB8,
    0xE6C5, 0xE803, 0xEDAE, 0xE9C2, 0xEB66, 0xE849, 0xEA2D, 0xE60E, 0xEBA6, 0xE7EE, 0xEB7C, 0xEC41, 0xEA1D, 0xEF2D, 0xF6FF, 0xFE3F,
    0xFE53, 0x062E, 0x08E8, 0x07DF, 0x0560, 0xFF74, 0xFC48, 0xF5D5, 0xF826, 0xF791, 0xF8AF, 0xFC11, 0xFE37, 0xFF50, 0xFC57, 0x0491,
    0x02BC, 0x0311, 0x0536, 0x0CB6, 0x09DD, 0x0A95, 0x0B6C, 0x068E, 0x02D0, 0xFE50, 0xFB58, 0xF6F3, 0xF649, 0xEEF7, 0xEFCC, 0xF134,
    0xF57B, 0xEF23, 0xF2AF, 0xF473, 0xF86C, 0xF6F7, 0xF9D5, 0x011C, 0xFD94, 0x013E, 0xFC54, 0x036F, 0xFC74, 0x0277, 0xFD40, 0xFEDE,
    0x0193, 0x016E, 0x0614, 0x04EB, 0x0DE5, 0x04EF, 0x0EED, 0x0DD6, 0x140E, 0x1601, 0x1B09, 0x1844, 0x155F, 0x19BE, 0x1032, 0x0F0F,
    0x0ACE, 0x0E3B, 0x0A5C, 0x1185, 0x18AB, 0x1BEA, 0x1E65, 0x2418, 0x25DD, 0x228F, 0x224B, 0x2283, 0x20A6, 0x2056, 0x2383, 0x1E01,
    0x19A0, 0x1703, 0x1085, 0x0764, 0x046E, 0x010A, 0xF4F5, 0xF0A3, 0xED40, 0xE86C, 0xE107, 0xDA2F, 0xD8D6, 0xD560, 0xD5A4, 0xCDD1,
    0xD6B1, 0xD48C, 0xD37A, 0xD3CE, 0xDAA5, 0xDE0F, 0xD8D7, 0xDECC, 0xDADD, 0xE1A9, 0xDABA, 0xE0B8, 0xE1C1, 0xE5F7, 0xE0BA, 0xE073,
    0xE9E2, 0xE87B, 0xEEB5, 0xF1A6, 0xFD31, 0xFC36, 0x0226, 0x0139, 0x0424, 0x0623, 0x0723, 0x07AC, 0x0DEB, 0x199C, 0x1D06, 0x2298,
    0x2630, 0x2AD5, 0x26ED, 0x2C56, 0x2AF3, 0x2E93, 0x2FB8, 0x350A, 0x3357, 0x3368, 0x378F, 0x30E2, 0x2FC4, 0x2B37, 0x2B27, 0x1A83,
    0x16FF, 0x13C3, 0x0DF8, 0x0637, 0x002C, 0xFDB9, 0xF3BF, 0xF48B, 0xF1B0, 0xF236, 0xF1FA, 0xF279, 0xF143, 0xEDC2, 0xF237, 0xEEC1,
    0xEE26, 0xECDA, 0xEC63, 0xEBEE, 0xECB3, 0xF06D, 0xEB8B, 0xF08E, 0xF3DA, 0xF9C0, 0xFC13, 0x05FB, 0x09C0, 0x0B54, 0x112C, 0x14FD,
    0x1367, 0x10C2, 0x1246, 0x0A47, 0x062C, 0x04D3, 0x0A8E, 0x05EC, 0x0E96, 0x11F7, 0x1429, 0x0F1F, 0x151A, 0x182F, 0x1353, 0x17E9,
    0x175E, 0x1D14, 0x14CD, 0x1889, 0x0D0F, 0x09C5, 0x010E, 0xF9A9, 0xF339, 0xEC7F, 0xE907, 0xE2F2, 0xE7DE, 0xDF15, 0xDF35, 0xDDD8,
    0xDF50, 0xDBD8, 0xDFA1, 0xE178, 0xDD54, 0xDDD0, 0xE15D, 0xE17C, 0xDEA7, 0xE0EE, 0xDEF2, 0xDA3E, 0xD9CF, 0xE05D, 0xE153, 0xE298,
    0xE41D, 0xE877, 0xE90F, 0xEBE5, 0xF23C, 0xF948, 0xFD43, 0xFF65, 0x06DD, 0x0901, 0x042F, 0x0658, 0x0B1B, 0x0EE7, 0x0EA3, 0x1897,
    0x1E96, 0x2236, 0x28C8, 0x2CDF, 0x35F6, 0x343C, 0x39E9, 0x3424, 0x3C53, 0x35C7, 0x34BA, 0x35F0, 0x364E, 0x3322, 0x2A74, 0x2FEE,
    0x21ED, 0x1F5C, 0x12D3, 0x1443, 0x092B, 0x0821, 0x02D0, 0xFE73, 0xFA54, 0xF292, 0xEF7F, 0xE812, 0xECA5, 0xE842, 0xEAF4, 0xE86B,
    0xF17B, 0xEF6C, 0xF4E6, 0xF3F1, 0xF48D, 0xF3E0, 0xF80B, 0xF8F2, 0xF3BE, 0xF881, 0xEFEF, 0xED1E, 0xE836, 0xEDF8, 0xE5A5, 0xE6D7,
    0xEA3F, 0xEAFB, 0xEE05, 0xEB9F, 0xEC86, 0xE88E, 0xED06, 0xE7C1, 0xE7F7, 0xEF23, 0xF18B, 0xF2A9, 0xF370, 0xFFA9, 0x0069, 0x029A,
    0x07C5, 0x12F1, 0x1AF0, 0x1B23, 0x25B5, 0x281E, 0x2CCB, 0x290E, 0x2D8D, 0x2C4F, 0x2A70, 0x2195, 0x17C0, 0x166F, 0x0D29, 0x031F,
    0xFC2B, 0x0100, 0xF4C4, 0xEEA9, 0xED4A, 0xF039, 0xE90F, 0xEDF1, 0xF27E, 0xF3F8, 0xF5FF, 0xF971, 0xFD7F, 0xF3D7, 0xF6F0, 0xF014,
    0xF462, 0xEE8C, 0xF617, 0xF1AE, 0xF306, 0xF76B, 0xF84D, 0xFE40, 0xFCC3, 0x0955, 0x07EE, 0x1200, 0x0CCE, 0x1019, 0x0D0A, 0x0826,
    0x04D6, 0x0396, 0x0641, 0xFE49, 0x0427, 0x043D, 0x083D, 0x0939, 0x0E57, 0x114E, 0x1605, 0x1A4D, 0x1ABA, 0x2068, 0x2003, 0x1B27,
    0x1840, 0x19C4, 0x13F3, 0x0E4F, 0x0779, 0x018D, 0xFA90, 0xFA7B, 0xF37B, 0xECD5, 0xEC9B, 0xE632, 0xE43A, 0xDD15, 0xE2F8, 0xDC3F,
    0xDD7F, 0xDABE, 0xDD05, 0xE055, 0xDDE8, 0xE6E6, 0xE038, 0xEA9E, 0xE6CC, 0xED3F, 0xEEB1, 0xFC13, 0xFF9A, 0xFA56, 0x0924, 0x07A6,
    0x0BF2, 0x0644, 0x13B2, 0x0DCB, 0x1059, 0x125A, 0x1270, 0x16BC, 0x1165, 0x13AF, 0x0F06, 0x1973, 0x11CA, 0x183E, 0x1E46, 0x2663,
    0x27A8, 0x2BE5, 0x31B2, 0x2D5F, 0x310D, 0x2E0B, 0x34E4, 0x2EFD, 0x30F7, 0x2C01, 0x2DC5, 0x29AE, 0x258E, 0x22E7, 0x1AE6, 0x1BDF,
    0x0F80, 0x0D93, 0x03C4, 0xFFAB, 0xF16B, 0xECA2, 0xEB6D, 0xE183, 0xE1FD, 0xDCF8, 0xE1B2, 0xDA55, 0xE2D5, 0xE4E2, 0xE7F7, 0xE8F6,
    0xE6D0, 0xEDE2, 0xE7BB, 0xECC8, 0xE867, 0xEFF6, 0xE9B4, 0xEAA8, 0xEE0D, 0xEEB2, 0xF049, 0xEC9A, 0xF752, 0xF4F8, 0xF7D6, 0xF8D2,
    0x0325, 0x013B, 0xFF10, 0x033C, 0x0113, 0xFCE2, 0xFC24, 0xFEEA, 0xFB81, 0xFEA9, 0x02B7, 0x05AC, 0x07E4, 0x0C1C, 0x0C76, 0x12C8,
    0x14B9, 0x14E3, 0x1700, 0x1C86, 0x1D6A, 0x1B43, 0x1C7D, 0x14E4, 0x0F55, 0x0787, 0x04E8, 0xFE50, 0xF789, 0xF10C, 0xEA57, 0xE754,
    0xE1EA, 0xE3FA, 0xE3F7, 0xE644, 0xE638, 0xE863, 0xED13, 0xEDEC, 0xEDE6, 0xEDE2, 0xF2FB, 0xF29D, 0xF4DB, 0xFA3D, 0xFC41, 0xFC1A,
    0x02AC, 0x06BF, 0x0795, 0x0C47, 0x1162, 0x1100, 0x1507, 0x1CDB, 0x1AD6, 0x1F17, 0x1FEC, 0x213A, 0x18FE, 0x1A7A, 0x16E0, 0x15DF,
    0x18FF, 0x1631, 0x1F29, 0x1F7F, 0x28D8, 0x256E, 0x339E, 0x32DA, 0x332F, 0x364F, 0x3648, 0x365E, 0x29EC, 0x30D2, 0x2626, 0x261E,
    0x1908, 0x17FC, 0x1031, 0x08DB, 0x0635, 0xFB26, 0xFB3D, 0xEFC1, 0xEFD2, 0xE4D5, 0xE7E1, 0xE32E, 0xDC2F, 0xD6BC, 0xD416, 0xD59A,
    0xCCD0, 0xCDEF, 0xC965, 0xCBB1, 0xC411, 0xC5AE, 0xC9FD, 0xCC67, 0xCA9C, 0xCB8F, 0xD5AC, 0xD150, 0xD49F, 0xD4AA, 0xE05C, 0xDF54,
    0xE62E, 0xEC69, 0xF149, 0xF48D, 0xF4CA, 0x02C5, 0xFE36, 0x06B3, 0x03A0, 0x0D50, 0x078D, 0x1021, 0x17F2, 0x1A82, 0x24CE, 0x22A3,
    0x307B, 0x28BE, 0x31B4, 0x28E4, 0x3366, 0x2FB5, 0x2D71, 0x34A2, 0x32B5, 0x33F4, 0x2988, 0x34E6, 0x25E3, 0x2407, 0x1E4E, 0x1DC1,
    0x11CF, 0x061B, 0x0318, 0xF78D, 0xF798, 0xF03F, 0xF1D1, 0xEE4A, 0xF386, 0xF12C, 0xF040, 0xF568, 0xF672, 0xF60A, 0xF913, 0x0419,
    0xFF47, 0xFBE8, 0xFD11, 0xFD50, 0xF590, 0xF56E, 0xF682, 0xF253, 0xF576, 0xF57E, 0xF70D, 0xF7E0, 0x0156, 0xFCDA, 0x02EA, 0x086B,
    0x0686, 0x0190, 0xFF6C, 0x021A, 0xF9C6, 0x01E8, 0xFF25, 0x04DF, 0x0304, 0x0A0B, 0x0A61, 0x0CE7, 0x1090, 0x0BB8, 0x110C, 0x0E26,
    0x13D4, 0x0ED5, 0x146E, 0x0E98, 0x0C1F, 0x0609, 0x00E7, 0xFA20, 0xF35C, 0xF17C, 0xEA75, 0xE8DC, 0xE4C8, 0xE86F, 0xE49D, 0xE75F,
    0xE426, 0xE92A, 0xE6C7, 0xEA0C, 0xE9AD, 0xE871, 0xE45E, 0xDF6F, 0xE4F7, 0xDEE0, 0xE42A, 0xE242, 0xEB41, 0xE5E5, 0xEC11, 0xEEC6,
    0xEE82, 0xF4C6, 0xFA8F, 0x08EB, 0x0728, 0x12ED, 0x129C, 0x16E0, 0x12D3, 0x1383, 0x1737, 0x10DA, 0x13E5, 0x1062, 0x191D, 0x1510,
    0x1AA0, 0x1E0D, 0x248A, 0x2B01, 0x28A2, 0x3118, 0x2BC0, 0x2D37, 0x2441, 0x2E62, 0x2970, 0x2562, 0x23B7, 0x2136, 0x1CE8, 0x126B,
    0x1688, 0x0871, 0x0933, 0xFD55, 0xFECA, 0xF2E0, 0xF64B, 0xF13D, 0xEBAC, 0xEBAB, 0xE68A, 0xE84C, 0xDDE5, 0xE9DA, 0xDF7A, 0xE673,
    0xE139, 0xE9B8, 0xE4DA, 0xE918, 0xEF84, 0xE7D1, 0xEF06, 0xEAC9, 0xF240, 0xE362, 0xEC8F, 0xE5D7, 0xE554, 0xE5FE, 0xE810, 0xEDFC,
    0xEA96, 0xF3AE, 0xEB0E, 0xF5C5, 0xF245, 0xF202, 0xF49C, 0x01C9, 0x07B9, 0x020C, 0x1180, 0x1261, 0x1377, 0x119F, 0x201F, 0x1E6B,
    0x1A65, 0x1FD0, 0x201F, 0x20CB, 0x1BB2, 0x2175, 0x1ADF, 0x1F95, 0x1B10, 0x16A3, 0x10F4, 0x0DE4, 0x054B, 0xF76D, 0xFB98, 0xF5F2,
    0xF251, 0xE7DA, 0xEF7D, 0xEA1D, 0xEA22, 0xE8F2, 0xECCA, 0xECE6, 0xE758, 0xEB26, 0xE719, 0xEFE4, 0xE86B, 0xEF6E, 0xE9E5, 0xF175,
    0xECBE, 0xEA62, 0xF081, 0xF631, 0xF5B8, 0xF7D0, 0x047E, 0x03AC, 0x11CE, 0x0ED9, 0x1878, 0x1635, 0x19EC, 0x164E, 0x0FAF, 0x0CC4,
    0x0D99, 0x0A9E, 0x06DD, 0x0FEA, 0x11ED, 0x135D, 0x1399, 0x1E99, 0x1F18, 0x1CE1, 0x2191, 0x28C0, 0x2778, 0x2452, 0x24E8, 0x1E46,
    0x15CA, 0x0E09, 0x08C9, 0x0253, 0xFB3F, 0xF184, 0xE4D6, 0xE203, 0xD7A2, 0xD5A0, 0xD089, 0xD6FC, 0xD0CE, 0xD21C, 0xD31E, 0xD154,
    0xD0D0, 0xCEBD, 0xD846, 0xD566, 0xDF08, 0xDC9C, 0xE3F5, 0xE050, 0xE9C7, 0xEB88, 0xEC6E, 0xF295, 0xF4A1, 0xF8FE, 0xF468, 0x0066,
    0x0019, 0x03F2, 0x074B, 0x0CD2, 0x0E4E, 0x0B63, 0x0FC3, 0x08B4, 0x0F01, 0x0BCD, 0x1197, 0x12B2, 0x1F30, 0x22C9, 0x2313, 0x3013,
    0x32CA, 0x3824, 0x322B, 0x41C1, 0x3502, 0x375E, 0x31C3, 0x35BF, 0x292E, 0x2692, 0x24D0, 0x1A8A, 0x1BC9, 0x1263, 0x12ED, 0x04FE,
    0x0AB2, 0xFDA9, 0xFE2E, 0xF807, 0xF43D, 0xEB98, 0xE6FA, 0xE79A, 0xDF18, 0xE022, 0xDB0B, 0xDA05, 0xD438, 0xD22B, 0xD2A1, 0xD191,
    0xD754, 0xD58A, 0xDE42, 0xDD5D, 0xE08A, 0xDB4E, 0xDEB3, 0xE32D, 0xE0EB, 0xE63E, 0xE6A5, 0xF0AF, 0xE62B, 0xEF51, 0xED0F, 0xF1C1,
    0xE8C1, 0xEDF6, 0xEF5C, 0xEE5A, 0xF0C3, 0xF231, 0xF9EB, 0xF666, 0x020B, 0x02FB, 0x0D59, 0x0E41, 0x1A13, 0x1C04, 0x1F33, 0x2631,
    0x29FE, 0x2DB7, 0x2CEF, 0x32AC, 0x2C0E, 0x298A, 0x239C, 0x1F3C, 0x1791, 0x0C89, 0x04D1, 0xFD14, 0xFB88, 0xED5A, 0xEBCF, 0xEB7B,
    0xED3B, 0xE5F6, 0xEBCE, 0xF07D, 0xEC34, 0xECDB, 0xF1FA, 0xFA77, 0xF606, 0xFC45, 0xFDA6, 0x02D5, 0xFFD2, 0x03BC, 0x008A, 0x0235,
    0x031E, 0x0214, 0x0261, 0x0778, 0x0BD9, 0x0871, 0x0C18, 0x11B9, 0x10E9, 0x0B2D, 0x0C17, 0x0D14, 0x0C48, 0x0B6C, 0x0B65, 0x0AB0,
    0x09B9, 0x0A70, 0x0CB9, 0x1228, 0x1A4A, 0x1B75, 0x1F56, 0x21CD, 0x2844, 0x20BE, 0x24DC, 0x2407, 0x252B, 0x1C45, 0x1DF9, 0x1ABC,
    0x1384, 0x0E49, 0x0441, 0xFFAF, 0xF413, 0xF511, 0xE5E1, 0xE92D, 0xE09A, 0xDE28, 0xD53D, 0xDAA5, 0xD78B, 0xCD78, 0xCC18, 0xC7D4,
    0xC697, 0xBCD6, 0xC29A, 0xC0B9, 0xC5CC, 0xC553, 0xCA29, 0xCD99, 0xD051, 0xD504, 0xD538, 0xE170, 0xE7AF, 0xED6C, 0xEE82, 0xF8C4,
    0xFF19, 0xFC3A, 0xFF56, 0x0249, 0x042D, 0xFD62, 0x0271, 0x018C, 0x04DE, 0x01E6, 0x0948, 0x0E88, 0x16C6, 0x1B03, 0x1E63, 0x25E5,
    0x270B, 0x2E6C, 0x2B06, 0x2F03, 0x2BB0, 0x281D, 0x210D, 0x2F16, 0x2A69, 0x2616, 0x19F2, 0x1E95, 0x1B49, 0x0380, 0x0EF9, 0xFB70,
    0x02FE, 0xF322, 0xF0D6, 0xF79E, 0xEDD3, 0xF926, 0xF014, 0xEFAF, 0xFEEC, 0xFC96, 0xEE8B, 0xFE65, 0xF601, 0x0301, 0xFB61, 0xF077,
    0x0B2C, 0x02A0, 0xFB35, 0x0522, 0xF5A0, 0xE1A2, 0x04FA, 0xE8E6, 0xF3FC, 0x16E7, 0xF666, 0x09FD, 0xFA10, 0x05AD, 0x1648, 0xED84,
    0x0DC3, 0x09A5, 0x00BF, 0x05B1, 0xE427, 0x0DFC, 0x043A, 0xE87A, 0x13A6, 0x2846, 0xFC6C, 0xFB27, 0x0C89, 0x0BEF, 0x1528, 0xEE25,
    0x05B4, 0x0944, 0x1CE7, 0x05F0, 0xE8B0, 0xFA5E, 0xE559, 0xE3B4, 0xFE31, 0x22B3, 0xEF3D, 0xC580, 0xAE91, 0xAF7F, 0xA1EE, 0xBA10,
    0xDC62, 0xC456, 0xC287, 0xE904, 0x20FA, 0x358B, 0x2FA0, 0x0DED, 0xD7FB, 0x9036, 0x8D79, 0x8AAC, 0xA5B5, 0xBD10, 0xDD40, 0x4561,
    0x5BC9, 0x741E, 0x6916, 0x5485, 0x4104, 0x2C68, 0x5E7E, 0x7598, 0x7D16, 0x6D94, 0x5789, 0x5C0F, 0x747E, 0x7AC0, 0x7433, 0x6F6A,
    0x5582, 0x2E84, 0x2C04, 0x5122, 0x4D6A, 0x3E50, 0x2331, 0xF381, 0xD200, 0xBAB0, 0xB7EC, 0xAB74, 0xA153, 0xA23C, 0x9B0C, 0x9BC4,
    0x954D, 0xAF94, 0xB818, 0xBFC6, 0xAE16, 0xB368, 0xD23C, 0xCCB3, 0xD7AD, 0xD4B2, 0xDB0F, 0xC801, 0xCDE1, 0xC025, 0xD757, 0xE5B9,
    0x25F2, 0x305D, 0x1663, 0x2FA1, 0x0130, 0x0CE2, 0xC8FA, 0xA355, 0xA38F, 0xAB0B, 0xA113, 0xD2BE, 0xE734, 0xDE0B, 0xEB60, 0xC97A,
    0xBABE, 0xA835, 0xC177, 0xB7FA, 0xDA5B, 0xE7E0, 0xE761, 0xF654, 0x112D, 0x038E, 0xFF62, 0x41E7, 0x477E, 0x48C8, 0x5DF0, 0x628E,
    0x6698, 0x6F8B, 0x6E35, 0x5EFF, 0x6EF3, 0x61EC, 0x4DF1, 0x3BD2, 0x149B, 0x0855, 0xE764, 0xF246, 0xDF75, 0xD735, 0xC8D1, 0xD6EE,
    0xFE3A, 0xE86E, 0xE757, 0xDC77, 0xF4BB, 0x05B0, 0x0D02, 0x04AA, 0x0CD5, 0x152F, 0x1DE7, 0x41EE, 0x29D5, 0x4008, 0x1A46, 0x1C55,
    0x4985, 0x24D9, 0xF553, 0xE7C9, 0xFC26, 0xECA6, 0x1203, 0x0CBD, 0x0747, 0x1F25, 0x132E, 0x040D, 0xF577, 0xDB12, 0xDBB9, 0xE685,
    0xF2FB, 0x07E8, 0x1B6E, 0x1435, 0x1AFA, 0x1537, 0x1224, 0x05E4, 0xF954, 0x0337, 0xE915, 0xFD31, 0x2002, 0x3599, 0xF268, 0xF48D,
    0xF525, 0xF933, 0xEF93, 0xF478, 0x13BF, 0xE4E7, 0xBD53, 0xC0BA, 0xCCF2, 0xAE86, 0xA76D, 0x9960, 0xB3CE, 0xA6AD, 0xBCCF, 0xAD92,
    0xB6CF, 0xE395, 0xD0E2, 0xBBE2, 0xB61B, 0xDD93, 0xF908, 0x0138, 0x0726, 0x3654, 0x3978, 0x3874, 0x3D5E, 0x31BF, 0x3249, 0x1D17,
    0xEBBE, 0xD200, 0xCBA7, 0xD3FE, 0xDD1D, 0xDC65, 0xDAE1, 0xDA05, 0xDA0B, 0xE64C, 0xDB25, 0xEC8A, 0xF675, 0xE495, 0xF91B, 0xE57E,
    0xFE81, 0x0306, 0x13B3, 0x0AEE, 0xDF08, 0x0411, 0xFC43, 0xED2B, 0xFC74, 0xF46F, 0x02E9, 0x142D, 0x24DF, 0x2441, 0x2A59, 0x3480,
    0x13F7, 0x0EFF, 0x0B5E, 0xEC08, 0xECB1, 0xF1C6, 0xE58A, 0xE9C6, 0xE9B8, 0xFE26, 0xFEAA, 0x24B0, 0x34BA, 0x1D0C, 0x2448, 0x18FC,
    0xFFB2, 0xED94, 0xD720, 0xED33, 0xDFFD, 0xEB98, 0x06AF, 0xF8C0, 0x22D8, 0xFFA0, 0x04E6, 0x172B, 0x1C25, 0xEC09, 0xE697, 0xF60F,
    0x1255, 0x1068, 0xEBF1, 0x1B3B, 0x11A3, 0xF9A8, 0xEF78, 0x08FB, 0xEE2B, 0x067F, 0x27E8, 0x3BC7, 0x30BD, 0x4053, 0x6016, 0x40B7,
    0x4D53, 0x4608, 0x46A2, 0x4CE9, 0x2E71, 0x2A3D, 0x07C7, 0xFBFA, 0x0286, 0xEFD4, 0xFC6C, 0xD935, 0xE74A, 0xF116, 0xBD8C, 0xC465,
    0xD9CF, 0xCD0A, 0xE7C1, 0xEA56, 0x2A6A, 0x297E, 0x2403, 0x477C, 0x488D, 0x48E4, 0x333D, 0x3FDA, 0x21C1, 0x1AD9, 0xE5A6, 0xEE5D,
    0xF074, 0xD53B, 0xF0D1, 0xE2FA, 0xE3B8, 0x08A5, 0xEE3C, 0xE5BE, 0x15F1, 0xF567, 0xE12F, 0xEB76, 0xDEC2, 0xF51C, 0xEA02, 0xD8A3,
    0xFD70, 0xF338, 0x011E, 0xFFD4, 0x02C3, 0x18C0, 0xF8B2, 0xF8D9, 0xF8FD, 0xFD11, 0xE90B, 0xE263, 0xE5CF, 0xEC3F, 0xE72A, 0xD09D,
    0xEDCB, 0xC69E, 0xF7C9, 0xF551, 0xEB58, 0x0272, 0xF9E2, 0xFDDD, 0xEA91, 0xFE7E, 0xDDF9, 0xE3B7, 0xE02D, 0xE479, 0xB335, 0xC043,
    0xC9A1, 0xCA68, 0xDE48, 0xE564, 0xEA4A, 0xDF3C, 0xEED5, 0xE226, 0xF74C, 0xDC06, 0x0133, 0x0419, 0x079D, 0xF72C, 0xEA77, 0x0221,
    0x0FCD, 0x050A, 0x0E97, 0x04FC, 0xFD00, 0x1AAC, 0xFFE1, 0x12A7, 0x0423, 0x0CFF, 0x1480, 0x0F69, 0x0E0A, 0x19A4, 0x0F7A, 0x1D03,
    0xF80F, 0x0CBA, 0x1044, 0xF76F, 0x0DF6, 0x04B2, 0x1E94, 0x1949, 0x2B16, 0x03FD, 0x1450, 0x39E9, 0x3A33, 0x20A6, 0x058B, 0x0546,
    0xEBCA, 0xEEEE, 0xF2D3, 0xF51C, 0x17B7, 0xF448, 0xEE55, 0x0C84, 0xF665, 0x035F, 0xFA36, 0xECC2, 0xE9DB, 0xF463, 0x0437, 0xE97A,
    0xE552, 0xF5F5, 0xE9E6, 0xF78F, 0x0CC7, 0xEC62, 0xE7F3, 0xE991, 0xFAE5, 0x0E74, 0xF8F8, 0xF73F, 0xE9FE, 0x0940, 0xFE62, 0xE4EA,
    0xDEEB, 0xD5D1, 0xD72C, 0xED1D, 0xDD6D, 0xD4F7, 0xCEBD, 0xB7E4, 0xC171, 0xCE32, 0xEFB7, 0xD359, 0xE7C3, 0xF9B8, 0xEDBF, 0xE9C0,
    0xEF9D, 0xE3AC, 0xF44A, 0xFCF7, 0xFBD4, 0x1C8A, 0x2CA9, 0x1C9F, 0x0A4D, 0x18F7, 0x098C, 0xFB3E, 0x1B24, 0x1F48, 0x01E4, 0x1496,
    0x01D3, 0x0682, 0x20D2, 0x20CE, 0x1ED4, 0x14C6, 0x16DD, 0x2CBD, 0x1466, 0x23D0, 0x0B6F, 0x1416, 0x0417, 0xEE96, 0x0596, 0xEF65,
    0x08B0, 0x08A1, 0x06A3, 0xE5D9, 0x0373, 0xF0EA, 0x1454, 0x1B58, 0xEB83, 0x0662, 0x2C23, 0x05A3, 0x038B, 0x156E, 0x0CC6, 0x1272,
    0x10F5, 0x4F53, 0x346D, 0x3B7D, 0x281A, 0x0FE2, 0x13BE, 0x17FA, 0x2C16, 0x36F2, 0x1F44, 0x141C, 0x126E, 0x0668, 0x0595, 0x1140,
    0x22A9, 0x0EF3, 0x160F, 0x1501, 0xF936, 0xDDA4, 0xEA38, 0xEEF0, 0x0019, 0x0008, 0xEEA5, 0xD844, 0xD36A, 0xCE7B, 0xE0D0, 0x0175,
    0x00C5, 0xF3D2, 0xCF90, 0xFFC3, 0x03A6, 0xE7F2, 0xF000, 0xF063, 0xEC84, 0xDF93, 0xD405, 0xE92F, 0xF1D2, 0xE09D, 0xDDE3, 0xE1AC,
    0xEB95, 0xF039, 0xD626, 0xDA5A, 0xE24A, 0xF9DB, 0x052C, 0xD488, 0x0279, 0xFFD4, 0xEA6F, 0xE156, 0xF1E1, 0xFE13, 0x01B6, 0xFFCD,
    0x1896, 0x23AE, 0x16CD, 0x2FAD, 0x2257, 0x3320, 0x27CB, 0x280D, 0x2341, 0x1FEA, 0x0CD8, 0x0071, 0x1455, 0x15D0, 0xEFFA, 0xF3C8,
    0x009A, 0xDAB8, 0xD19E, 0xC996, 0xC03B, 0xD46C, 0xF1CA, 0xECFB, 0xD8E9, 0xEB79, 0xE1E6, 0xD5A1, 0xF7EF, 0xF08F, 0xF092, 0x0461,
    0xF991, 0xEA09, 0xF13E, 0xE663, 0xFE14, 0xFD5D, 0xF279, 0x0D28, 0x127F, 0x0142, 0x0561, 0x0482, 0xF0CD, 0xE33B, 0xEE35, 0x00B0,
    0xF454, 0xFDD7, 0x0759, 0x0E2F, 0xF29B, 0xF13B, 0x0D1A, 0x0DF4, 0x0056, 0xF769, 0xF819, 0x00A5, 0xEF6F, 0xF4EC, 0xE87D, 0xDFCC,
    0xF10D, 0xE517, 0xDC3C, 0xD75D, 0xDA84, 0xEB15, 0xFD26, 0xD644, 0xDA62, 0xE181, 0xF087, 0xE87B, 0xDE4F, 0xDEF8, 0xF5B2, 0xFEA4,
    0xE8F6, 0xFBF4, 0xF1B6, 0xF8DB, 0xEB94, 0xE8A4, 0xE2FA, 0xDE77, 0xED26, 0xCF4B, 0xC508, 0xD916, 0xD5B3, 0xE5AC, 0xE8BF, 0xF0DF,
    0xFE45, 0xF683, 0x027B, 0x1921, 0x15D6, 0x1B72, 0x2907, 0x1C0E, 0x0DB9, 0x0455, 0x05B1, 0x079A, 0x27CA, 0x0EFB, 0x1095, 0x2AC8,
    0x25C8, 0x3CB0, 0x4108, 0x289F, 0x0D98, 0x256E, 0x32DA, 0x3838, 0x206C, 0x0FE2, 0x16BB, 0x0CAE, 0x072E, 0xFCC0, 0x014D, 0xECCF,
    0xF256, 0xFECB, 0xF49E, 0xDA62, 0xE7E5, 0x0144, 0xF462, 0xFCAD, 0xE361, 0xE529, 0xFC20, 0xFDF1, 0xED47, 0xFB66, 0xF422, 0xED36,
    0xD671, 0xD852, 0xFC91, 0xD34A, 0xDDEE, 0xE253, 0xF909, 0x006E, 0xFA72, 0xF47D, 0xEE8D, 0xEE16, 0xD625, 0xFF0D, 0x0417, 0xED86,
    0x024B, 0x0897, 0xF98D, 0xF49C, 0x092C, 0x090F, 0x15AB, 0x23C8, 0x177F, 0x1C3D, 0x21A6, 0x259D, 0x1115, 0x044F, 0x061B, 0x1680,
    0x1BE1, 0x0CED, 0xFD1A, 0xFF61, 0x19AA, 0x212B, 0xE769, 0xBEE3, 0xE5C6, 0xEEE4, 0xF41B, 0xE6D8, 0xDFE9, 0xF8F0, 0xED75, 0xF244,
    0xFBE1, 0xE5D5, 0xD725, 0xE2DC, 0xF1E6, 0x0CDF, 0xFCA5, 0xFC80, 0xFCBF, 0xEEB0, 0x08A1, 0x1528, 0x04E5, 0xF986, 0xF5E9, 0xF3EF,
    0x1812, 0x0AE4, 0x0704, 0xFC0F, 0x041D, 0x0B8E, 0xFF02, 0x0662, 0x06B8, 0xFDA7, 0xF170, 0xF949, 0x0494, 0x1D23, 0x22CE, 0x1547,
    0x14E8, 0x0B1B, 0x0A82, 0x23DB, 0x16BF, 0x2A69, 0x2682, 0x1704, 0x1B78, 0x1325, 0x0FBB, 0x2EF9, 0x2E17, 0x20F5, 0x2181, 0x0C76,
    0x059E, 0xF707, 0xF595, 0xF2C8, 0xFD91, 0xF4DD, 0xEB72, 0xEF6A, 0xFE3E, 0xF958, 0x094A, 0x0449, 0xF546, 0xFF73, 0xF8C4, 0xFBCB,
    0xFDE5, 0x1D55, 0x1E99, 0x1A23, 0x134A, 0x0540, 0x0C55, 0x17AB, 0x0B0C, 0x02A0, 0x0DA6, 0x0F16, 0x123B, 0x0A81, 0x1197, 0x04CA,
    0xEAE1, 0xE092, 0xE7E1, 0xF140, 0xF4F4, 0x002E, 0xFF68, 0x0677, 0x0667, 0x0CAA, 0x071E, 0x0F56, 0x17CE, 0x216D, 0x328C, 0x1DC1,
    0x2008, 0x27B9, 0x368D, 0x2D5E, 0x1501, 0x1684, 0x1F67, 0x21AB, 0x06D1, 0x0D03, 0x1799, 0x0C7E, 0xFB53, 0xEE2A, 0xFB4E, 0xF8C6,
    0xF800, 0xEBD4, 0xEFED, 0xF0AA, 0xE132, 0xE9C5, 0xD690, 0xCED5, 0xD510, 0xD668, 0xCEE0, 0xC917, 0xE748, 0xED88, 0xE65F, 0xE3DF,
    0xFECF, 0x0B32, 0x01AC, 0x0645, 0xF7BE, 0x0076, 0x02C9, 0x05FC, 0xF77D, 0x00DE, 0x09EB, 0xFB2B, 0xD955, 0xCDBB, 0xE110, 0xDDB5,
    0xF2C1, 0xE33C, 0xDA98, 0xDF58, 0xEE7D, 0xF02F, 0xE95F, 0xF6C6, 0x0794, 0x205A, 0x2B36, 0x2AC9, 0x1C92, 0x15B3, 0x22EF, 0x1C80,
    0x190E, 0x1C80, 0x2B6B, 0x39F4, 0x21B6, 0x1604, 0x0278, 0x03D9, 0x0CBD, 0x0A8C, 0xEE8C, 0xE097, 0xF47C, 0xEE6A, 0xE33E, 0xEA20,
    0xFD4F, 0x0C36, 0x1862, 0x1223, 0x2065, 0x0FF9, 0x04FA, 0x0E7E, 0x124D, 0x2D7F, 0x153A, 0x06A4, 0x0B13, 0x0A0A, 0x1A21, 0x2236,
    0x1462, 0xFB16, 0x107B, 0x262D, 0x27EE, 0x2382, 0x2476, 0x397B, 0x2A7D, 0x26E3, 0x211F, 0x177D, 0x1045, 0x0FEF, 0x1702, 0x15B5,
    0x04B6, 0x04DC, 0x133D, 0x0342, 0x0B2C, 0x04B8, 0x101D, 0x075B, 0x06CD, 0xF062, 0xF62B, 0x05F0, 0xEBEE, 0xFECC, 0xF011, 0xED54,
    0xD5C7, 0xDC11, 0xD9C2, 0xC86A, 0xDE5F, 0xE575, 0xDFDD, 0xE4D7, 0xF151, 0xDFDD, 0xE36E, 0xF7EE, 0xFFCD, 0xFCB0, 0xE899, 0xDFE1,
    0xD881, 0xD83C, 0xE440, 0xDB25, 0xDA37, 0xE589, 0xF077, 0xF344, 0xFCD8, 0xF47F, 0xF45C, 0xEB04, 0xF1A9, 0x06BB, 0xE925, 0xE8DA,
    0xEC33, 0xE7E7, 0xE416, 0xFA8A, 0xFCA0, 0xF6F2, 0xF850, 0xFF44, 0x076A, 0xF5A0, 0x0D61, 0x154A, 0x2287, 0x296A, 0x1FCF, 0x3136,
    0x280F, 0x1E56, 0x15B0, 0xF2A1, 0xF381, 0xF046, 0xFDD7, 0x050B, 0x0E04, 0x1960, 0xFCA5, 0xF6B8, 0x0298, 0x11E2, 0x0B94, 0x0BF4,
    0x1480, 0x1E95, 0x0A3C, 0x12BC, 0x10CD, 0x0BC2, 0x0FBA, 0x09C8, 0x187B, 0x16F2, 0x1D0F, 0x1A45, 0x272D, 0x2E44, 0x3E5E, 0x3101,
    0x13A6, 0x191F, 0x23AB, 0x3758, 0x39B7, 0x3E6D, 0x3009, 0x1951, 0x1B91, 0x1CBF, 0x090E, 0xF646, 0x04FC, 0xF990, 0x0969, 0xFED0,
    0xF42F, 0xF100, 0xE7AB, 0x09FA, 0xFE15, 0x01D7, 0xF718, 0xF800, 0xF8CF, 0x006C, 0x0BF6, 0x04B6, 0xFC16, 0xF4DC, 0xF145, 0xD88E,
    0xE665, 0xE2F9, 0xE18A, 0xF206, 0xE9B4, 0xFFAE, 0xF3B0, 0xECC9, 0xEB76, 0xE5CA, 0xFB6E, 0xEDF4, 0xDAB1, 0xDAA7, 0xEB0F, 0xE391,
    0xE61B, 0xDB47, 0xF9E3, 0xF564, 0xF848, 0x0061, 0xE839, 0xF591, 0xEE91, 0x0057, 0xF872, 0x08F3, 0x166D, 0x24BE, 0x23DF, 0xF70B,
    0xF171, 0xF3F9, 0x1324, 0x2D5E, 0x108D, 0x0CF1, 0xFC2F, 0xF879, 0xF210, 0xF3CF, 0x01EB, 0xFBE2, 0xFD2D, 0xF90E, 0xFE29, 0xEC04,
    0xDFCB, 0xE13A, 0xE228, 0xE2A8, 0xED73, 0xDD1D, 0xDE62, 0xEAF8, 0xEE98, 0xEE72, 0xF702, 0x07AB, 0xF8B4, 0xE676, 0xEF2E, 0xF4F8,
    0xF7EB, 0xFC48, 0x0B1B, 0x0B35, 0xFE3A, 0x010C, 0xFA24, 0x0B46, 0x023B, 0x10F6, 0x0485, 0x0381, 0xFD60, 0xF49F, 0xF430, 0xD726,
    0xF252, 0xF48A, 0xF78E, 0xEF1D, 0xE128, 0xEC8B, 0xEC50, 0xF73D, 0x0384, 0x0A79, 0x073A, 0xF74C, 0xF2D2, 0xF352, 0xFDCA, 0xFE89,
    0x0B70, 0x0074, 0x0882, 0x0126, 0x0445, 0x1ABF, 0x2287, 0x1F11, 0x0690, 0x240C, 0x193E, 0x1BF7, 0x0F3D, 0x0FCD, 0x091F, 0xFD16,
    0x0963, 0xFE2E, 0xF73F, 0xE8D9, 0x012D, 0x0B3E, 0x0054, 0xF6D4, 0x0001, 0x1845, 0x0D4C, 0xFBE5, 0xFEB5, 0x04F1, 0x0A83, 0x0527,
    0x04C2, 0x05C3, 0x13C8, 0x0A3B, 0xF9E5, 0xFEAB, 0x105C, 0x1FB1, 0x2183, 0x2946, 0x2BB6, 0x32A3, 0x2830, 0x1F0D, 0x11FE, 0x0E4B,
    0x0383, 0x0617, 0x088B, 0xFD2F, 0x0393, 0xFAA8, 0xF369, 0xE2F9, 0xF093, 0xF270, 0xF529, 0xF969, 0xF98C, 0x0037, 0xF37E, 0xEE9E,
    0xE952, 0x0458, 0xFAD9, 0xF187, 0xF4A7, 0xF7B3, 0xFFC0, 0x0B1D, 0x09CA, 0xF680, 0xF97E, 0xE7A8, 0xEBD3, 0xEAFE, 0xE914, 0xEAFB,
    0xDEFC, 0xE0C8, 0xD9AA, 0xE06F, 0xD882, 0xC8E0, 0xCC0C, 0xCED0, 0xF199, 0xF093, 0xE85B, 0xEA12, 0xF8B7, 0x0BDC, 0xFF44, 0x0706,
    0xFA70, 0x032B, 0x06B1, 0x0B0F, 0x1437, 0x0F66, 0x1AB7, 0x166B, 0x24FB, 0x24E1, 0x2DE2, 0x22BE, 0x1BD1, 0x1EF2, 0x1198, 0x1CF0,
    0x13DB, 0x1349, 0x0625, 0x1986, 0x1B37, 0x1823, 0x15A2, 0x0BF4, 0x19F4, 0x0337, 0x0D5B, 0x00EE, 0xF602, 0xF596, 0xFCAC, 0x104C,
    0x0579, 0x0BAD, 0x0A5A, 0x0FDA, 0x0860, 0x08C3, 0x1644, 0x04C8, 0x03BC, 0x01A5, 0x0423, 0x0AF0, 0x07C6, 0x04DF, 0xFEA2, 0x005F,
    0xFF32, 0x004F, 0xFED1, 0x07DA, 0x11A0, 0x1268, 0x05FC, 0xFF99, 0x1002, 0x048D, 0x044D, 0xFD6C, 0xFE6A, 0x0037, 0x00F0, 0x0BB6,
    0xFFDD, 0x0673, 0x034E, 0x01FB, 0x01EE, 0x0AE2, 0x0EC1, 0x0A36, 0x0A15, 0x0183, 0x03CC, 0xFD14, 0xF9F0, 0xF111, 0xE931, 0xE163,
    0xE54A, 0xEC54, 0xE5C0, 0xF6B3, 0xFC55, 0x06E9, 0x020D, 0x04A7, 0x0A7E, 0xFF25, 0x021B, 0xF76F, 0xF647, 0xE55D, 0xF0C1, 0xF780,
    0xF257, 0xF5B8, 0xEBF0, 0xF478, 0xF585, 0xF284, 0xF70E, 0x0D25, 0x039A, 0xFDF3, 0xFBEA, 0xF4A4, 0xF389, 0xF4A6, 0xF9A0, 0xFCE8,
    0x041B, 0x0392, 0x12D6, 0x0711, 0x094D, 0x1281, 0x0BF0, 0x0BCC, 0x0AA6, 0x1213, 0x0C9D, 0x0E50, 0x1095, 0x0E3A, 0x1615, 0x16DE,
    0x22B4, 0x254D, 0x2923, 0x2A5C, 0x2345, 0x251A, 0x1857, 0x12C7, 0x11A8, 0x1EFF, 0x20F2, 0x2059, 0x1E3C, 0x2097, 0x1D50, 0x095C,
    0xFC63, 0xF89D, 0x0132, 0xFB5B, 0xF909, 0xEEFD, 0xF789, 0xFECD, 0xF89B, 0xE56A, 0xDEFB, 0xEAD2, 0xE2C1, 0xE067, 0xD788, 0xD20E,
    0xD1B4, 0xCDCE, 0xD12E, 0xD06B, 0xC9E0, 0xD6C5, 0xDFAE, 0xECFF, 0xE36C, 0xE7F8, 0xEA55, 0xE542, 0xE7FF, 0xE5E4, 0xF014, 0xE590,
    0xEF99, 0xF595, 0xFE06, 0x09CE, 0x1984, 0x1879, 0x0D71, 0x0154, 0xFF86, 0x0762, 0x0B88, 0x0A1D, 0x056F, 0x0C6E, 0x02B7, 0x0079,
    0xFA63, 0xF89B, 0xFCB7, 0x033C, 0x04F3, 0x02D3, 0x0BA1, 0x1163, 0x0E76, 0x107B, 0x075C, 0x06AB, 0x018B, 0xFE33, 0x02FE, 0x0582,
    0x0920, 0xFA6C, 0x09F0, 0x03B3, 0x0790, 0x0A97, 0x0ECD, 0x1114, 0x0132, 0x09FB, 0x07BB, 0x115D, 0x03B3, 0xF96E, 0xFC74, 0x00A6,
    0x1475, 0x1EA2, 0x1B47, 0x17A6, 0x191C, 0x1B27, 0x1270, 0x0EC3, 0x12A5, 0x181B, 0x2369, 0x202C, 0x1815, 0x12C5, 0x0CF4, 0x0B0F,
    0x0405, 0xFF39, 0x004F, 0xFF41, 0x0F9C, 0x0EBC, 0x13A4, 0x0B6B, 0x0A10, 0x08D2, 0xFBF9, 0xFD27, 0xF0C2, 0xF615, 0xF391, 0x00B1,
    0x01A3, 0xFFD8, 0xFB48, 0xF758, 0xF70F, 0xEA71, 0xEE92, 0xEC7E, 0xE874, 0xE62B, 0xEB6E, 0xF3D2, 0xF44A, 0xEB04, 0xEC53, 0xE51F,
    0xDB57, 0xEA38, 0xF014, 0xEB57, 0xEBEA, 0xEE02, 0xF041, 0xE0DC, 0xDB10, 0xDE3D, 0xDE4D, 0xE1B7, 0xE605, 0xEA70, 0xDBA5, 0xDF29,
    0xE741, 0xF50E, 0xFAE7, 0x045B, 0x11DA, 0x0764, 0x08B1, 0x04E6, 0x087B, 0x0611, 0x08B6, 0x071F, 0x0851, 0x09A7, 0x0546, 0x0816,
    0x03CC, 0x0547, 0xFFCB, 0x0551, 0x03D2, 0x0810, 0x10A7, 0x0DE8, 0x173F, 0x1C14, 0x1D3F, 0x1A16, 0x12A3, 0x0CEA, 0x064F, 0x0BDA,
    0x0403, 0x06C6, 0x079C, 0x0B15, 0x0AC3, 0x0D23, 0x12A4, 0x09A2, 0x11DF, 0x0701, 0x111F, 0x0B7A, 0x041F, 0x038E, 0xFC2F, 0xFC2A,
    0xEFED, 0xEC1F, 0xF42B, 0xF224, 0xF3A7, 0xF3D9, 0xF33E, 0xF748, 0xF2A2, 0xF2FB, 0xE7EB, 0xE6E9, 0xEEDD, 0xF1B8, 0xED8C, 0xF491,
    0xFD4A, 0x0274, 0x0332, 0x087C, 0x0AD1, 0x0E19, 0x0DD8, 0x208F, 0x2883, 0x2185, 0x2580, 0x16E6, 0x1E80, 0x18B3, 0x11EF, 0x0D70,
    0x1335, 0x1613, 0x0206, 0x0402, 0x089B, 0x0599, 0x04C3, 0xF9C0, 0xFB9E, 0xF7B0, 0xF7A0, 0xF86E, 0xF19F, 0xF729, 0xF08D, 0xF355,
    0xEC80, 0xE7A9, 0xECAB, 0xF094, 0xF75F, 0xF85F, 0xEF5B, 0xEF95, 0xED75, 0xF1C0, 0xF930, 0xF693, 0xF77F, 0xF646, 0x0381, 0xFB65,
    0xFE3A, 0x0143, 0x04A0, 0x135D, 0x07EB, 0x1173, 0x0D0B, 0x0D48, 0x13A6, 0x1266, 0x1319, 0x03E9, 0x0D91, 0x0A07, 0x0339, 0x0561,
    0x07E9, 0x0B8B, 0x0CA7, 0x1230, 0x0958, 0x0108, 0x0153, 0x0177, 0x01D8, 0x06BC, 0x0810, 0x0DC4, 0x0708, 0x061C, 0x0B2A, 0x088A,
    0x0B03, 0xFEAB, 0xFD8A, 0xF98C, 0xF994, 0xFC90, 0xED22, 0xED42, 0xE8C7, 0xED47, 0xE912, 0xDE37, 0xE24E, 0xDC45, 0xE092, 0xDCCF,
    0xDD1E, 0xE122, 0xE340, 0xEBA4, 0xE5A1, 0xEBA4, 0xF3D9, 0xF8CE, 0xFC53, 0xFD09, 0x076E, 0x0520, 0x0173, 0x0630, 0x08C8, 0x0FF0,
    0x11EA, 0x13AC, 0x1F0F, 0x1465, 0x202A, 0x26CF, 0x22C8, 0x296D, 0x27CC, 0x2E33, 0x1D03, 0x1B07, 0x16B6, 0x14FA, 0x1BF3, 0x1E77,
    0x2799, 0x1F3E, 0x1962, 0x1AC7, 0x2344, 0x28E7, 0x1B74, 0x19A2, 0x19DB, 0x151E, 0x1555, 0x12AD, 0x15ED, 0x1683, 0x172B, 0x17CA,
    0x194C, 0x1D7B, 0x1AA1, 0x0FBE, 0x06E8, 0x0543, 0x0542, 0x0052, 0xFEB4, 0xF907, 0xFEEB, 0x01AA, 0xFB50, 0xF285, 0xE217, 0xE607,
    0xE54B, 0xE957, 0xEED6, 0xEC9D, 0xF723, 0xF977, 0xF99F, 0xF9FA, 0xF4F3, 0xF6FC, 0xF376, 0xFE9F, 0xFEDF, 0xF774, 0x02B1, 0xFC68,
    0x03ED, 0x0683, 0x056B, 0x02BB, 0xF7C3, 0xFABD, 0xFA53, 0xFD99, 0xFC72, 0xFC97, 0xFF4F, 0xFC5B, 0xF326, 0xF7A1, 0xF6CB, 0xF735,
    0xEF79, 0xF313, 0xFB59, 0xEF5E, 0xF530, 0xE835, 0xF4E3, 0xF2D9, 0xF9DA, 0xFB39, 0xF592, 0x0406, 0xF4C0, 0xFA69, 0xEF41, 0xF092,
    0xF154, 0xF3BF, 0x04B3, 0x0239, 0x0932, 0x0C2F, 0x0B0C, 0x0EE5, 0x0DE6, 0x0995, 0xFFA5, 0xF8A2, 0x03CE, 0x0270, 0xF994, 0xFA18,
    0xFEFF, 0x0943, 0x086A, 0x0D64, 0x08E1, 0x0B3A, 0x1344, 0x1180, 0x162E, 0x0852, 0x0BD5, 0x0BF9, 0x1164, 0x1C03, 0x13FE, 0x1F41,
    0x2317, 0x2BBD, 0x2674, 0x1B9B, 0x1F70, 0x1246, 0x16D6, 0x153C, 0x13FB, 0x18C6, 0x1B91, 0x2852, 0x2716, 0x24FE, 0x1DC8, 0x171C,
    0x12B1, 0x070C, 0xF979, 0xF9AE, 0xFC81, 0xF606, 0xEA1D, 0xE8C3, 0xEF55, 0xE77A, 0xEABB, 0xE996, 0xE91D, 0xDCCA, 0xD5F7, 0xDEA7,
    0xDDD2, 0xE67B, 0xE09A, 0xE0B5, 0xDAD2, 0xDC29, 0xE271, 0xDC5E, 0xE789, 0xF6BA, 0x0467, 0x060A, 0x08E6, 0x0F1C, 0x04A4, 0x047D,
    0x0361, 0xFED0, 0x00A5, 0x046B, 0x06BD, 0xF618, 0xFC49, 0xFEDC, 0xFCD1, 0x03B4, 0xFB76, 0xF25C, 0xEBE4, 0xF046, 0xF754, 0xF430,
    0xFD8E, 0x0732, 0x0D77, 0x1665, 0x0F28, 0x18BF, 0x19CE, 0x1253, 0x032A, 0xFA51, 0x0708, 0xF945, 0xFDA1, 0x0874, 0x0BA0, 0x0CFD,
    0x0105, 0x0ADC, 0x02F2, 0xFB24, 0xF75B, 0xEAEE, 0xF188, 0xF046, 0xF307, 0xEC9C, 0xEF84, 0xF3B6, 0xE8A5, 0xEFD1, 0xF2FB, 0xF424,
    0xF2B0, 0xED19, 0xF9BF, 0xFE13, 0xFACF, 0x0390, 0xFD43, 0xFEF1, 0xFAE8, 0x0726, 0x10F7, 0x0970, 0x14A3, 0x0A01, 0x151B, 0x117F,
    0x12A0, 0x1217, 0xFC71, 0xFEDE, 0xF84B, 0xFD6C, 0xF9E9, 0xFBA9, 0xF715, 0xED6F, 0xEE4B, 0xE3B1, 0xDF02, 0xDFED, 0xE3D9, 0xE71C,
    0xE0D2, 0xDC95, 0xE7AA, 0xE4A3, 0xE2BE, 0xDF11, 0xDF87, 0xEC4A, 0xEDF3, 0xF15F, 0xE6D9, 0xEF88, 0xF4F6, 0xEBBD, 0xF00F, 0xE7CB,
    0xF277, 0xEE77, 0xF133, 0xF630, 0xED00, 0xFB3F, 0xF160, 0xF236, 0xF0CF, 0xF16C, 0xF7A0, 0xED4D, 0xF9ED, 0xFB55, 0xFF29, 0xFDB4,
    0xF7E7, 0xFFE3, 0xFB55, 0xFFBD, 0x005E, 0x042A, 0x0F5F, 0x0B0F, 0x07DF, 0x0C86, 0x0BBA, 0x1092, 0x0F40, 0x15E1, 0x1C19, 0x17C9,
    0x1D68, 0x1742, 0x1DD5, 0x1619, 0x1575, 0x1424, 0x0A70, 0x1573, 0x0FB2, 0x1397, 0x0DF1, 0x0D74, 0x0FE7, 0x04D5, 0x08FB, 0xFDB7,
    0xF79E, 0xF7E4, 0xFD6B, 0xFED8, 0xF392, 0xF879, 0xFABC, 0xFEED, 0xFCD4, 0xF8D7, 0xF7CE, 0xF18E, 0xF077, 0xEDEF, 0xE821, 0xE4C2,
    0xDAC8, 0xDAB8, 0xE2BC, 0xE69C, 0xEDD0, 0xE93F, 0xE9B9, 0xEA26, 0xEE37, 0xF0B8, 0xEBA4, 0xF258, 0xEF93, 0xE86E, 0xE0DA, 0xE03F,
    0xE684, 0xDD71, 0xE1D9, 0xE5B1, 0xED7E, 0xF9FC, 0xFBAB, 0x040F, 0x01AC, 0x098C, 0x0767, 0x046A, 0x070B, 0x06AA, 0x0AEA, 0x0908,
    0x0FF8, 0x1119, 0x0BE6, 0x0781, 0x0AC5, 0x0917, 0x062A, 0x013D, 0xFD63, 0xF871, 0xFAAA, 0xFDFB, 0xF0A2, 0xF3C5, 0xEDA3, 0xED5F,
    0xE99E, 0xE9F1, 0xEA6A, 0xE208, 0xE95F, 0xE120, 0xEC35, 0xEFB8, 0xF4E3, 0xF5F9, 0xF02D, 0xF49E, 0xEC62, 0xF800, 0xFAD7, 0xFF30,
    0xFE06, 0xFCD7, 0x0174, 0xFEE9, 0x0AF7, 0x13C2, 0x16D1, 0x114C, 0x1266, 0x1C30, 0x245D, 0x1D90, 0x1A8F, 0x1699, 0x0C69, 0x0E6D,
    0x0CB8, 0x10FA, 0x01F2, 0xFFC1, 0x066C, 0x0529, 0x0D11, 0x02B1, 0x01D2, 0xFB60, 0xFF55, 0x0046, 0xEE72, 0xF153, 0xEE75, 0xF482,
    0xF2C1, 0xF197, 0xF6E3, 0xF0BE, 0xF87C, 0xF502, 0xF408, 0xF5D8, 0xF334, 0xF8B2, 0xF634, 0xF53C, 0xF2B1, 0xEEFB, 0xFC38, 0xFC43,
    0xFD22, 0x01A2, 0xF706, 0xF9FF, 0xF671, 0xFBB5, 0xFBD9, 0xF48E, 0xF487, 0xECC4, 0xF82A, 0xEFF2, 0xED90, 0xF28B, 0xEC55, 0xF59A,
    0xF77B, 0x08BE, 0x0507, 0x088A, 0x13F4, 0x0951, 0x0D27, 0x0736, 0x094F, 0x0180, 0xF681, 0x040C, 0x07BC, 0x0847, 0x0E4E, 0x0D06,
    0x0CE8, 0x082F, 0x0F0E, 0x0CFC, 0x0A1F, 0x11C1, 0x06CF, 0x0580, 0x003D, 0x03AA, 0x067C, 0x0103, 0x09B7, 0x0271, 0x01D2, 0xF918,
    0xEFB1, 0xF517, 0xEF90, 0xF393, 0xF54F, 0xFB64, 0xFD57, 0xF37D, 0xF70E, 0xFB9A, 0xFBF2, 0xFF0A, 0xFAFF, 0xFDF9, 0xF4CA, 0xF70B,
    0xF8F0, 0xF324, 0xF7AD, 0xF3F1, 0xF832, 0xF711, 0xF666, 0xF355, 0xEE63, 0xEF08, 0xEE31, 0xE784, 0xF1C0, 0xF071, 0xF29D, 0xED91,
    0xF030, 0xF0FB, 0xEA2F, 0xF732, 0xEF40, 0xF777, 0xF0A8, 0xF194, 0xEE31, 0xE58B, 0xF84B, 0xF853, 0x02BD, 0x04C2, 0x04E1, 0x0A9A,
    0x06DE, 0x0C00, 0x0317, 0x029D, 0xFD0C, 0x0001, 0x059C, 0x066B, 0x03ED, 0xFDC0, 0xFD0E, 0xFFD2, 0x0402, 0x0122, 0x079F, 0xFF43,
    0xFFBD, 0xF9CF, 0xFCBD, 0xFEA4, 0xF706, 0xFE4A, 0xFFFE, 0x0635, 0xFEE4, 0x0340, 0x0120, 0xF482, 0xFB64, 0xF639, 0x00B6, 0x0620,
    0x1078, 0x11F1, 0x0E6C, 0x1A2C, 0x183C, 0x1E26, 0x1D7B, 0x2429, 0x213B, 0x1D42, 0x1E90, 0x1CCC, 0x1768, 0x15F1, 0x17BD, 0x16EC,
    0x1445, 0x102A, 0x0DDE, 0x0D09, 0x0F1A, 0x0574, 0x012F, 0x0ABB, 0x0DCE, 0x0D29, 0x066A, 0x0BE9, 0x0C92, 0x0008, 0xFCB3, 0xEF05,
    0xF10E, 0xEB42, 0xF24E, 0xF2D6, 0xE746, 0xE211, 0xD6DE, 0xDC6C, 0xDA8D, 0xDC34, 0xDC3D, 0xDA18, 0xDD5D, 0xDA7B, 0xD953, 0xD706,
    0xD9DA, 0xE02B, 0xDF7A, 0xE186, 0xE522, 0xE38B, 0xE869, 0xEA5B, 0xEDCC, 0xF284, 0xFB41, 0x0B52, 0x02BF, 0x0A69, 0x0BD0, 0x0AFC,
    0x0BB0, 0x0984, 0x10C5, 0x0C1E, 0x160F, 0x1856, 0x13F7, 0x1748, 0x1543, 0x18B9, 0x1260, 0x10F0, 0x1402, 0x103F, 0x1639, 0x1337,
    0x0F66, 0x0CCC, 0x0BDE, 0x0499, 0x0194, 0x0140, 0x015A, 0x0190, 0x0A8F, 0x0CA3, 0x07F5, 0x0295, 0x0032, 0x028F, 0xFD9D, 0x04CA,
    0x0237, 0xFF03, 0x01CB, 0xFEB2, 0xFF4D, 0xFB3B, 0xFD9B, 0xF922, 0xEE08, 0xF290, 0xECAC, 0xF7FC, 0xF951, 0x0264, 0x017F, 0x01AB,
    0x038C, 0xF960, 0x063D, 0x0334, 0x0093, 0xF91D, 0xFB96, 0xFD50, 0xFAAD, 0xFE2C, 0xFFC9, 0xFCB7, 0xF64A, 0xF4B6, 0xF9FB, 0xFC9A,
    0xF75E, 0xF6C6, 0xF52B, 0xF5AE, 0xF420, 0xEFEC, 0xF855, 0xF1F9, 0xFBFB, 0xFD39, 0xFD00, 0x0099, 0xF418, 0x0000, 0xFC1D, 0xFAF6,
    0xF7AF, 0xFA9F, 0x04DB, 0xFF12, 0x04FC, 0x03F5, 0xFE55, 0xF9B6, 0xEFF0, 0xEF3F, 0xE6E0, 0xE56F, 0xE9B7, 0xE9A3, 0xE91D, 0xEB1B,
    0xEAFE, 0xEBBB, 0xEB5F, 0xFAA5, 0xFCF6, 0xFA9C, 0x0213, 0x0420, 0x08E9, 0xFEBA, 0x0467, 0xFDE4, 0xFC54, 0x02AC, 0x0137, 0x029E,
    0x07E0, 0x0AD5, 0x0D6E, 0x110B, 0x1ABD, 0x1DE4, 0x2096, 0x1ACC, 0x18A4, 0x1C62, 0x1924, 0x1773, 0x1368, 0x12C1, 0x07BB, 0x07F1,
    0x027D, 0x0226, 0x0102, 0x07E8, 0x0559, 0x084C, 0x0C11, 0x0522, 0x0534, 0x05D0, 0x0B39, 0x0AEC, 0x1152, 0x0F38, 0x0E25, 0x0811,
    0x04F4, 0x0291, 0xFCB2, 0x00D5, 0xFB8D, 0x008A, 0x0146, 0xFBA8, 0xF8B3, 0xF46F, 0xF603, 0xE8AE, 0xE521, 0xDBD4, 0xD5CB, 0xD041,
    0xCD09, 0xD4A9, 0xD37F, 0xD98A, 0xDB65, 0xDE20, 0xE4F3, 0xE4C9, 0xE703, 0xE3DD, 0xE748, 0xF1A1, 0xF0EC, 0xED6D, 0xF46A, 0xF9FB,
    0xF870, 0xFADD, 0x04FC, 0x0E7D, 0x0AA5, 0x05E5, 0x013A, 0x09D7, 0x01FF, 0x00D3, 0x04CB, 0x07A4, 0x0AB3, 0x0646, 0x0C67, 0x0604,
    0x006C, 0x0612, 0x0395, 0x057B, 0xFD8D, 0xFA8F, 0xFAE9, 0xF968, 0x0502, 0x03A6, 0x0DF4, 0x072F, 0x04C9, 0xFEC5, 0xFE72, 0x00B7,
    0xFC97, 0xFE3F, 0x0681, 0x09AA, 0x0651, 0x0BC1, 0x0FB4, 0x0FB0, 0x08AF, 0x0B09, 0x00AB, 0x0788, 0x1192, 0x16E8, 0x1B71, 0x14C8,
    0x15DA, 0x100A, 0x094D, 0x09E0, 0x0B54, 0x1B15, 0x1859, 0x1BCE, 0x1970, 0x1260, 0x12FF, 0x0E63, 0x167D, 0x0E98, 0x0CF2, 0x068D,
    0x0330, 0x0900, 0x0CD0, 0x0B10, 0x07B5, 0x0576, 0xF8E3, 0xEC79, 0xEA40, 0xE8CD, 0xE666, 0xEACB, 0xEBF8, 0xECCD, 0xEF9D, 0xF63D,
    0xF9A3, 0xF4E6, 0xF330, 0xE7F9, 0xE3D6, 0xE008, 0xDF03, 0xDF9A, 0xE1F7, 0xE681, 0xE048, 0xE2B2, 0xE2C4, 0xE6B9, 0xEA72, 0xE569,
    0xE89F, 0xEBAF, 0xEC60, 0xEE21, 0xE868, 0xF162, 0xF5A9, 0xFE35, 0xFFAB, 0x05EE, 0x0E0D, 0x0C41, 0x077F, 0x04B5, 0x0688, 0x05CD,
    0x09AE, 0x0D06, 0x101A, 0x08CA, 0x0D61, 0x07A6, 0x0BB6, 0x08A3, 0x0B4B, 0x0EEC, 0x0BF1, 0x1567, 0x0F50, 0x0E6F, 0x0BDA, 0x0D6D,
    0x13D5, 0x0F89, 0x1580, 0x102A, 0x1005, 0x1186, 0x0D0E, 0x1124, 0x06CB, 0x08E1, 0x054C, 0x0CFD, 0x0FBC, 0x07F0, 0x0620, 0x0800,
    0x0675, 0x0196, 0x00F6, 0x025E, 0x001B, 0xFC8E, 0x023D, 0xFC5F, 0xFCB4, 0xF8DE, 0xFA81, 0xFA7C, 0xF314, 0xF48C, 0xEEFD, 0xF0E5,
    0xEC09, 0xEDCC, 0xF679, 0xF60A, 0xFE27, 0xFA10, 0x007F, 0x0300, 0xFA3A, 0xFD4F, 0xFAA9, 0x0200, 0x0803, 0x1004, 0x0FA9, 0x0569,
    0x1157, 0x0E44, 0x0A12, 0x0A60, 0x133E, 0x1475, 0x0A5E, 0x0BD9, 0x08EA, 0x031E, 0x0806, 0x057D, 0xFC90, 0x005D, 0xFE3E, 0xFBB3,
    0xEE8B, 0xF7D4, 0xF3E7, 0xF457, 0xFDC2, 0xFF29, 0x084D, 0x0198, 0x05D5, 0x032D, 0x0189, 0x0774, 0xFD3C, 0xFD0A, 0xF856, 0xF47A,
    0xF955, 0xF4EE, 0xFAB5, 0xF6EF, 0xF8FC, 0xF861, 0xF918, 0xFBD1, 0xFD1F, 0xFD09, 0xFCFC, 0xFC6F, 0x015E, 0x0038, 0x009C, 0x01DB,
    0x003C, 0x0844, 0x02F5, 0x0B13, 0x0539, 0x0618, 0x085B, 0x04FC, 0x0A21, 0x0BA3, 0x1917, 0x1C8C, 0x1BFD, 0x208D, 0x1B4F, 0x1F22,
    0x2027, 0x2367, 0x2AD6, 0x23FF, 0x1C04, 0x1229, 0x10E7, 0x0C59, 0x03DF, 0x0202, 0x017C, 0x0155, 0xFD95, 0xF9F1, 0xF7D4, 0xEFB3,
    0xEC0C, 0xE831, 0xE57C, 0xEA07, 0xE61A, 0xE1CF, 0xDD1B, 0xDDB7, 0xDD38, 0xD446, 0xD80E, 0xD7A1, 0xE068, 0xE711, 0xE8AE, 0xE950,
    0xE7CA, 0xF184, 0xF125, 0xF5B3, 0xFA9C, 0xF9D3, 0xF804, 0xF6B9, 0xFD3C, 0xFE8E, 0x0586, 0x10F9, 0x120F, 0x0F0E, 0x0DCB, 0x0FD2,
    0x0B68, 0x1079, 0x169B, 0x1CAC, 0x19F5, 0x19F7, 0x1773, 0x14E2, 0x141C, 0x103C, 0x0C8E, 0x0391, 0x0CE0, 0x0CCF, 0x0F7A, 0x0DD3,
    0x0CD0, 0x0CC9, 0x101A, 0x16D3, 0x1466, 0x1B0B, 0x1C34, 0x18A9, 0x18A8, 0x1C67, 0x1FDB, 0x188B, 0x1AB5, 0x1821, 0x14FE, 0x17A0,
    0x1486, 0x1439, 0x1104, 0x1361, 0x097D, 0x07B4, 0x0248, 0xF98B, 0xF363, 0xF43D, 0xFA2A, 0xF3F0, 0xF653, 0xFAFE, 0xFE99, 0xF9A4,
    0xFA81, 0xFD46, 0xFC84, 0x0011, 0xFDB5, 0xF88D, 0xF6BC, 0xFE4B, 0xFAE5, 0xF51F, 0xF607, 0xF2E3, 0xED93, 0xE9EB, 0xF404, 0xF6A2,
    0xF7FA, 0xF644, 0xF3A3, 0xF331, 0xF310, 0xF947, 0xF539, 0xF6DC, 0xF8C3, 0xF8D0, 0xFE47, 0x00B2, 0xFB68, 0xEE0C, 0xEC71, 0xEAD5,
    0xE9B7, 0xEFBC, 0xFB1A, 0xFE34, 0xFB89, 0xFDC8, 0x0051, 0x037E, 0x032F, 0x0862, 0x04EF, 0x0646, 0x0399, 0x0539, 0x0911, 0x0C87,
    0x0D48, 0x07FE, 0x1087, 0x0C88, 0x01EB, 0xFD10, 0x0230, 0x0154, 0xF990, 0xFBC7, 0xF88D, 0xFBA4, 0x04A5, 0x051D, 0x0753, 0x0F57,
    0x1A15, 0x1546, 0x15A9, 0x1A2F, 0x1906, 0x140C, 0x1380, 0x1736, 0x184A, 0x1AF8, 0x1B21, 0x1B99, 0x17F5, 0x16E0, 0x1035, 0x0FF7,
    0x129C, 0x16A8, 0x1984, 0x19FF, 0x1C25, 0x13CD, 0x133A, 0x14F8, 0x0F3B, 0x0E11, 0x1466, 0x18CC, 0x0AC0, 0x08CD, 0x0C21, 0x03B7,
    0x00BE, 0xFA60, 0xF419, 0xE685, 0xE787, 0xE826, 0xE2EF, 0xEC07, 0xED1B, 0xE995, 0xE2F3, 0xE1FC, 0xDD74, 0xDBBF, 0xE3FD, 0xE0BE,
    0xDFD2, 0xE70A, 0xE8C4, 0xE1FF, 0xE7D5, 0xF7C8, 0xFFC8, 0xFD8D, 0x0251, 0x062D, 0x078A, 0x08A6, 0x032B, 0x0337, 0xFFA9, 0x03A5,
    0x024E, 0x016D, 0x05E0, 0xFC13, 0xFD86, 0xFDCB, 0xFEB9, 0x0178, 0x04D4, 0x0EDB, 0x07A5, 0x1025, 0x11D2, 0x0BF4, 0x0ABC, 0x076A,
    0x08DA, 0xFEE8, 0x0342, 0x04F5, 0xFE0F, 0xFE1A, 0x00A7, 0x041D, 0x036B, 0x041F, 0x060F, 0x0034, 0x02A5, 0x05D0, 0x01A3, 0x0440,
    0x0388, 0x02B0, 0xFEF9, 0xFE57, 0xFFE1, 0xF68F, 0xFBED, 0xFBBD, 0xF99A, 0xF75E, 0xF870, 0x04C1, 0xFD04, 0x062A, 0x0D71, 0x10FB,
    0x1702, 0x1A62, 0x1DFD, 0x17F6, 0x1D48, 0x1C57, 0x1870, 0x204C, 0x24D2, 0x1FB9, 0x1C31, 0x2026, 0x1FE6, 0x15E1, 0x12DE, 0x0AAA,
    0xFEDC, 0xFDF3, 0xF932, 0xF4BA, 0xEC51, 0xEBD0, 0xE69A, 0xDFBE, 0xE89C, 0xE2D4, 0xE1D1, 0xE19C, 0xE59E, 0xE7E5, 0xE53D, 0xEF3C,
    0xEB9A, 0xE962, 0xEC0E, 0xEE73, 0xEAF8, 0xE744, 0xEDEB, 0xEEA1, 0xF076, 0xF6D6, 0xF313, 0xEDFD, 0xF083, 0xF0B7, 0xEF62, 0xEF8D,
    0xF46B, 0xF497, 0xF664, 0xFE26, 0xF9BB, 0xF6ED, 0xF384, 0xF4C4, 0xF7AF, 0xFD2C, 0x06A2, 0xFCFD, 0xFDEB, 0xFE8A, 0xFAD9, 0xFB8F,
    0x00F9, 0x094B, 0x0920, 0x15BC, 0x1885, 0x1A76, 0x209B, 0x2307, 0x2128, 0x1CD8, 0x2658, 0x262D, 0x238A, 0x2984, 0x2D33, 0x2988,
    0x274A, 0x271F, 0x23B6, 0x1EBA, 0x1FFB, 0x1DBE, 0x1939, 0x1E73, 0x187D, 0x0CA5, 0x05B2, 0x0680, 0x013F, 0xF7B1, 0xFB65, 0xF852,
    0xF7EE, 0xF9C5, 0xF8AD, 0xF9BD, 0xF8FA, 0xFF4E, 0xF5E8, 0xF008, 0xF081, 0xED3F, 0xEF2B, 0xED4D, 0xF546, 0xF2FC, 0xEF10, 0xEB4D,
    0xE3B0, 0xE1E9, 0xDC11, 0xE2ED, 0xE4E2, 0xE3E1, 0xEDBB, 0xF23F, 0xF7C2, 0xF5C9, 0xF710, 0xF929, 0xF82D, 0xF923, 0xF3E4, 0xF7EE,
    0xFC98, 0xFD49, 0xFFE4, 0x0571, 0x06B5, 0x0383, 0x04CC, 0x0846, 0x02C5, 0x01E6, 0x00F2, 0x010C, 0x0E85, 0x142F, 0x1A13, 0x16B3,
    0x1A92, 0x19B9, 0x1507, 0x1CB1, 0x1929, 0x1929, 0x13C9, 0x13D7, 0x11C6, 0x093A, 0x0A92, 0x0195, 0xF5DD, 0xF5D9, 0xF98D, 0xFB1A,
    0xFA9A, 0xFDA6, 0xFB50, 0xF6D9, 0xF786, 0xEFE1, 0xF162, 0xF557, 0xF812, 0xFA67, 0xF419, 0xFF6E, 0xFFED, 0xFCA9, 0x0539, 0x09DC,
    0x105D, 0x0CD9, 0x16F0, 0x1293, 0x12C8, 0x1F6B, 0x1259, 0x13C3, 0x1926, 0x1A99, 0x13DB, 0x1646, 0x1CD2, 0x1504, 0x173C, 0x194A,
    0x13CC, 0x1117, 0x0C31, 0x0891, 0x01E2, 0xF8FE, 0xF9AC, 0xF1FF, 0xEB1C, 0xE936, 0xECAB, 0xEC41, 0xE3EE, 0xE8DE, 0xE7E1, 0xEAC3,
    0xF2FD, 0xEE47, 0xF6CE, 0xF5BE, 0xF360, 0xF078, 0xF346, 0xF92D, 0xF192, 0xFA7D, 0xF313, 0xF2AF, 0xF3C1, 0xF075, 0xF4F0, 0xF639,
    0xF98C, 0xF981, 0xFB7F, 0xF8DB, 0xF7CF, 0xFCDC, 0xF90F, 0xF568, 0xFB31, 0xF9F9, 0xFBAB, 0xFD0C, 0x0084, 0x08F0, 0x0D8B, 0x1210,
    0x112B, 0x120E, 0x11FE, 0x0F9F, 0x14DE, 0x1230, 0x1762, 0x1BED, 0x193E, 0x150D, 0x0F0E, 0x15F9, 0x0F13, 0x07B1, 0x0316, 0x0666,
    0x0711, 0x0174, 0x0A91, 0x0EB2, 0x0F13, 0x107E, 0x0FF6, 0x0BAF, 0x0BD0, 0x0E5A, 0x012A, 0xF784, 0xFE45, 0xF85C, 0xF725, 0xFACA,
    0x006C, 0x0324, 0x0395, 0x0860, 0x059A, 0x0BFE, 0x0C9A, 0x09D1, 0x0AF0, 0x0B6B, 0x0C05, 0x093A, 0x0383, 0x04E7, 0x0041, 0xFDDB,
    0xFCCF, 0xFCFA, 0xFCA7, 0xFAB5, 0x02EF, 0xF786, 0xF4C9, 0xF2C6, 0xEBEE, 0xEA88, 0xE90C, 0xE9FD, 0xE8F7, 0xEC0C, 0xECB0, 0xE907,
    0xF095, 0xF23B, 0xF276, 0xF5ED, 0xF38E, 0xFC0D, 0xFB6F, 0xFCA8, 0xFD80, 0xFF7D, 0xFF6C, 0xF732, 0xF90F, 0xF6B2, 0xF925, 0x0303,
    0x0017, 0xFF5B, 0xFC17, 0xFC2C, 0xF934, 0xFA0C, 0x0223, 0xFBD9, 0x0087, 0xF883, 0xF88D, 0xFAB9, 0xF249, 0xF4B6, 0xF60B, 0xF930,
    0xF8F9, 0xFD5F, 0xFC1F, 0xF7E0, 0xFF27, 0x02B7, 0x0142, 0x0871, 0x0FAF, 0x15AB, 0x17DF, 0x1B5A, 0x247F, 0x24BB, 0x27EE, 0x2BED,
    0x31B6, 0x3271, 0x2F10, 0x34E1, 0x2DFA, 0x2BE0, 0x2FC7, 0x2BAD, 0x26ED, 0x20D8, 0x253C, 0x18C5, 0x128C, 0x1558, 0x13F5, 0x1465,
    0x0C6D, 0x1322, 0x0CE1, 0x07AE, 0x0785, 0x01B5, 0xFBF5, 0xFBE2, 0x0077, 0xFB47, 0xFDC9, 0x03A3, 0xFD25, 0xFA1C, 0xFADD, 0xF24C,
    0xED65, 0xEC0C, 0xE7B4, 0xE150, 0xE441, 0xE45D, 0xDCCD, 0xDDA8, 0xDF05, 0xD88D, 0xD6AB, 0xD368, 0xD73D, 0xD70E, 0xD790, 0xD881,
    0xD6E5, 0xDA0C, 0xD96F, 0xDFEF, 0xDC26, 0xE083, 0xE67F, 0xEAD0, 0xF41B, 0xF9A8, 0xFD62, 0x05AE, 0x111E, 0x14E8, 0x1539, 0x1DCD,
    0x1E81, 0x1C5B, 0x21F7, 0x231E, 0x24E4, 0x21EF, 0x21D6, 0x1CD9, 0x1D01, 0x1B23, 0x16D6, 0x1930, 0x1463, 0x0EB6, 0x0C4F, 0x0B10,
    0x06EF, 0x03BA, 0x07DB, 0x0A86, 0x0909, 0x0601, 0x006F, 0xFF59, 0xF9EB, 0xFE51, 0x03EC, 0xFEA3, 0xFED7, 0x01AD, 0x012C, 0xFB2F,
    0x0198, 0x07A9, 0x02E2, 0x05FE, 0x093F, 0x06D3, 0x0491, 0xFF67, 0xFEFC, 0xFB7A, 0xFF23, 0x069F, 0x033B, 0x089D, 0x0E36, 0x172C,
    0x1433, 0x13F1, 0x1AD2, 0x0F68, 0x0BB1, 0x088B, 0x046A, 0x07C4, 0x051F, 0x0349, 0xF6D9, 0xFD4C, 0xFF93, 0xF39B, 0xF5C7, 0xF3CA,
    0xFC93, 0xF6D8, 0xF929, 0xFAD9, 0xF62B, 0xFCFD, 0xFE0F, 0xFBDD, 0xF90B, 0xFC36, 0x03A7, 0xFDB4, 0x0100, 0x0A13, 0x034C, 0x064F,
    0x0471, 0x0363, 0x010C, 0x025E, 0x007D, 0xF6E8, 0xFBDE, 0xF92A, 0xF228, 0xF574, 0xEE0D, 0xEFF6, 0xEF00, 0xE9A0, 0xE6DC, 0xEABD,
    0xF8BD, 0xEE01, 0xEFBF, 0xF32A, 0xF30F, 0xF282, 0xEC8F, 0xF3BF, 0xF7F8, 0xFF70, 0x039D, 0xFFED, 0xFF9E, 0xFEC0, 0x0016, 0xFC27,
    0x0105, 0x0F98, 0x0D33, 0x0F42, 0x15D0, 0x171F, 0x16D3, 0x1708, 0x1246, 0x08C9, 0x0D19, 0x0D78, 0x0192, 0x02D3, 0x095E, 0x088C,
    0x0AE2, 0x0D2C, 0x1080, 0x0CA0, 0x0D8F, 0x0AD8, 0x08D2, 0x111B, 0x1636, 0x1B53, 0x1726, 0x1A2C, 0x17E0, 0x0CD6, 0x05C6, 0x049C,
    0x01F2, 0xFE92, 0x026F, 0x0202, 0xFBAA, 0xFF95, 0xF97F, 0xEE2B, 0xECFE, 0xEF66, 0xEF67, 0xE4CA, 0xE652, 0xE6FD, 0xE671, 0xE261,
    0xDE2A, 0xDDC6, 0xDF70, 0xE6E7, 0xEB9D, 0xE937, 0xEEE4, 0xF4A3, 0xF676, 0xFA8E, 0x02BC, 0x06A0, 0x008B, 0x0346, 0x0217, 0x05CA,
    0x07F3, 0x0563, 0x044B, 0x0795, 0x0774, 0x04D5, 0x058D, 0x0783, 0x0945, 0x0CC6, 0x0DB8, 0x0948, 0x0986, 0x052C, 0x01E0, 0xFFA6,
    0x054C, 0x0D66, 0x0906, 0x03BB, 0x042D, 0x0638, 0x02E4, 0x02A5, 0x082B, 0x010C, 0x05DD, 0x0F11, 0x0B3D, 0x0CEF, 0x15B2, 0x187E,
    0x0D46, 0x15AC, 0x17A5, 0x0EA5, 0x0FFD, 0x13E6, 0x152F, 0x132F, 0x17FA, 0x0CE6, 0x0677, 0x0ADF, 0x0D7D, 0x080A, 0x0584, 0x1037,
    0x1132, 0x0E89, 0x1089, 0x0E83, 0x06F1, 0x0861, 0x0C3B, 0x0814, 0x0886, 0x1164, 0x0C7E, 0x06BD, 0x0EB8, 0x0F7D, 0x06C8, 0x03C1,
    0x01C1, 0xFDD6, 0xFA62, 0xF7EA, 0xEE36, 0xEEAC, 0xF19E, 0xEAC1, 0xE76B, 0xE095, 0xE2AD, 0xDBEF, 0xD8CF, 0xDAD8, 0xDDA7, 0xE2BC,
    0xE038, 0xE1E8, 0xE28F, 0xE53C, 0xE9CB, 0xE118, 0xE169, 0xE553, 0xE3E8, 0xE60C, 0xE55E, 0xEDBA, 0xEEB6, 0xF3B3, 0xF5EF, 0xF6F7,
    0x0597, 0x0973, 0x0AA9, 0x0C43, 0x0BFB, 0x12A6, 0x12AD, 0x1674, 0x19F6, 0x1D9A, 0x237F, 0x1D9B, 0x1EAE, 0x1E5A, 0x22C9, 0x21E5,
    0x13D7, 0x1681, 0x189C, 0x13ED, 0x10E1, 0x0EB0, 0x104A, 0x0D00, 0x1168, 0x0C90, 0x04CD, 0x0E54, 0x07CA, 0x017F, 0x00DB, 0x04D4,
    0x0A3E, 0x07C1, 0x0F92, 0x0F5C, 0x10F7, 0x1132, 0x0AF2, 0x0BFA, 0x0985, 0x0EC4, 0x0D8F, 0x03CA, 0x0880, 0x0B27, 0x080B, 0x054C,
    0x0B30, 0x0AEB, 0x03B9, 0x08DC, 0x0311, 0xFB36, 0xFC20, 0xF816, 0xEC4D, 0xEB2D, 0xEEB7, 0xEAC5, 0xE39E, 0xE3B8, 0xE2C4, 0xE1A4,
    0xE126, 0xDD64, 0xE2A6, 0xE8EC, 0xEE66, 0xEF1C, 0xF17F, 0xF85E, 0xFE01, 0xFFBE, 0x0004, 0x030A, 0x08A8, 0x0D94, 0x1421, 0x1340,
    0x1787, 0x1A95, 0x14AD, 0x0EE9, 0x12E6, 0x1095, 0x0690, 0x0ADC, 0x06CD, 0x05ED, 0x09CB, 0x0621, 0xF9E1, 0xFBBC, 0x002A, 0xFA1E,
    0xF723, 0xF850, 0xFC84, 0xF8D0, 0xFAF9, 0x0028, 0x0019, 0x00AC, 0xFEAA, 0xFC9F, 0xF9DC, 0xFCD2, 0xFFB9, 0xF7B1, 0xF83D, 0xFD0A,
    0xF8B4, 0xFBC4, 0x040A, 0x0306, 0x05EC, 0x0839, 0x084C, 0x06A5, 0x09D1, 0x0F65, 0x042C, 0x071B, 0x09B6, 0x09E5, 0x0D2F, 0x023B,
    0x0B11, 0x0980, 0x0466, 0x0A1D, 0x08D1, 0x1021, 0x135A, 0x1CF1, 0x206F, 0x1B59, 0x27C2, 0x2168, 0x1D21, 0x2607, 0x21AE, 0x2278,
    0x1C99, 0x1E39, 0x1D62, 0x17F0, 0x1866, 0x1115, 0x12C9, 0x11C8, 0x07F7, 0x0408, 0xFDF9, 0xFAD1, 0xF595, 0xEBC3, 0xE9E1, 0xE7BB,
    0xE35F, 0xE027, 0xDECF, 0xDE8F, 0xDFFA, 0xE0E3, 0xDC6A, 0xD9D8, 0xE2B7, 0xE363, 0xDD45, 0xDEE5, 0xE1D8, 0xE34D, 0xE550, 0xE338,
    0xE485, 0xEBE1, 0xEE44, 0xEF37, 0xEE6E, 0xF304, 0xF44A, 0xF470, 0xF8EF, 0xF6B3, 0xFF20, 0x031F, 0x0506, 0x0857, 0x07E9, 0x1491,
    0x10DA, 0x0BD8, 0x0FE7, 0x1299, 0x1194, 0x09F8, 0x09EB, 0x0592, 0x04E4, 0x09D9, 0x048E, 0x03D8, 0x0FAE, 0x13D5, 0x1209, 0x1707,
    0x1CA0, 0x1EBE, 0x1BBA, 0x1DC0, 0x21B6, 0x23F3, 0x26CB, 0x2306, 0x1F2E, 0x1C76, 0x1BD8, 0x1836, 0x0E5C, 0x0E17, 0x11FE, 0x0CB1,
    0x0BF2, 0x0CA1, 0x0879, 0x0731, 0x0164, 0xFF4C, 0x00EC, 0x0277, 0x0270, 0xFBD1, 0xFE9D, 0xFAD2, 0xFA14, 0x005E, 0xF7AB, 0xFD2E,
    0x0071, 0x001F, 0x0054, 0xFC98, 0xFF84, 0xFACE, 0xFE87, 0xFCBD, 0xF41B, 0xF59A, 0xED82, 0xE90D, 0xEB01, 0xE7C0, 0xEA6B, 0xE9E2,
    0xE520, 0xE49D, 0xE388, 0xE7B3, 0xE6DB, 0xEB14, 0xEE19, 0xE83C, 0xEB57, 0xE754, 0xE984, 0xEC95, 0xEA56, 0xF15D, 0xF94E, 0xFE5B,
    0xFF46, 0xFEAF, 0x0079, 0x0322, 0x04A3, 0x0737, 0x090F, 0x0F08, 0x0F59, 0x0C8F, 0x10A8, 0x0C4A, 0x0D4E, 0x0FCD, 0x0CAA, 0x0D8E,
    0x099A, 0x05B0, 0xFFCB, 0xFDD8, 0xFDCB, 0xF770, 0xF953, 0xFAF9, 0xF8E8, 0xFF78, 0xFEDD, 0x00E9, 0x019B, 0xFF16, 0x0633, 0x0180,
    0x0473, 0x0949, 0x079F, 0x0712, 0x085F, 0x1043, 0x0D73, 0x0FEA, 0x1588, 0x1167, 0x130F, 0x144B, 0x0EAF, 0x0C8D, 0x10B1, 0x107E,
    0x0DC0, 0x11BC, 0x1307, 0x0FC2, 0x0D99, 0x0A3B, 0x07AA, 0x091B, 0x0805, 0x0419, 0x022A, 0x0109, 0xFD27, 0xF4CC, 0xEAF9, 0xEB65,
    0xEE60, 0xE5EF, 0xE6E4, 0xE381, 0xE3BA, 0xE797, 0xE595, 0xE935, 0xE69B, 0xF1ED, 0xED9D, 0xEB99, 0xF7E9, 0xF54D, 0xFBF5, 0xF8FB,
    0xF835, 0x0058, 0x02EB, 0x07CD, 0xFEFA, 0xFFE4, 0x08E8, 0x053D, 0x06B6, 0x0099, 0x062C, 0x0F15, 0x0546, 0x0906, 0x0894, 0x0823,
    0x0AB7, 0x0257, 0x055F, 0x0260, 0x07BA, 0x0371, 0xF62B, 0x00C2, 0xFF43, 0x0131, 0x019E, 0xFDC1, 0x00E7, 0xFF8B, 0x03A4, 0xFD5A,
    0xF917, 0x0502, 0x038A, 0xFCBC, 0xFD1A, 0x0697, 0x0B3C, 0x021A, 0x01AB, 0x01AE, 0xFDA6, 0x00C1, 0x00C1, 0xFB38, 0xFF00, 0x00B1,
    0xF7D9, 0xEE09, 0xF28B, 0xF648, 0xEFC9, 0xF134, 0xF310, 0xF7C7, 0xFB42, 0xF978, 0xF7A0, 0xFBD4, 0x00F7, 0x072B, 0x08E3, 0x0D97,
    0x1589, 0x13C6, 0x1814, 0x1BA6, 0x1F60, 0x2206, 0x24BE, 0x2718, 0x232A, 0x2A30, 0x2E3B, 0x2452, 0x2375, 0x2469, 0x1D3D, 0x12E5,
    0x09D2, 0xFF8B, 0xF753, 0xF1FF, 0xED80, 0xE8CE, 0xEC09, 0xEB30, 0xE42F, 0xE7AA, 0xE33C, 0xE29D, 0xE325, 0xE141, 0xDF51, 0xDE44,
    0xDD9D, 0xD892, 0xCFC9, 0xCE7C, 0xCF40, 0xCBC5, 0xCA5B, 0xCC62, 0xD73C, 0xD15B, 0xD6CB, 0xE4A3, 0xE371, 0xEB71, 0xED95, 0xEE47,
    0xF2F5, 0xF5C5, 0xF7A9, 0xEDAE, 0xF4A2, 0xFBBC, 0xF7A7, 0xFC63, 0xF61B, 0xF533, 0xF5B0, 0xEFA6, 0xF515, 0xFBD8, 0x0845, 0x15CF,
    0x1C4C, 0x2A6A, 0x3018, 0x39E6, 0x3DDF, 0x3BF8, 0x477E, 0x4246, 0x4502, 0x46BC, 0x450E, 0x4BB4, 0x4907, 0x43B2, 0x3B0F, 0x3944,
    0x31D6, 0x2191, 0x1C18, 0x1A23, 0x11EE, 0x1075, 0x0FBF, 0x0A77, 0x043C, 0xFDA9, 0xFCA2, 0xF3E0, 0xEDA6, 0xF3BC, 0xF2CB, 0xF00A,
    0xF337, 0xF79C, 0xF2FC, 0xEB27, 0xE7D9, 0xDE9E, 0xDA1F, 0xDBB0, 0xD59D, 0xD1B9, 0xD8CC, 0xD401, 0xD361, 0xD39F, 0xD44F, 0xD9C7,
    0xDCB1, 0xE5AE, 0xE4AF, 0xEB1E, 0xEBB4, 0xE68D, 0xEED9, 0xF0FE, 0xF3F7, 0xF4DA, 0xF4EC, 0xFCF7, 0xF6FC, 0xF170, 0xEE18, 0xE73E,
    0xE3D8, 0xE33F, 0xE688, 0xE59B, 0xF001, 0xFC9D, 0xF4A3, 0xF4E6, 0x0292, 0xFF7E, 0xFEF2, 0x05C7, 0x0B0C, 0x111A, 0x1BC6, 0x2213,
    0x1F70, 0x26E2, 0x2F02, 0x2B58, 0x222C, 0x1DAE, 0x181C, 0x1044, 0x06C5, 0x049D, 0x03FF, 0xFC03, 0xFDAC, 0xF80A, 0xEFF8, 0xF5A3,
    0xFAE9, 0xFC3D, 0xFF1B, 0x0DD2, 0x1677, 0x0E5D, 0x0E23, 0x06AA, 0x026D, 0x007E, 0xF1D3, 0xF052, 0xF3CB, 0xF9D7, 0xFB29, 0xF902,
    0x0137, 0x014B, 0x057C, 0x0CAC, 0x0CFC, 0x1A34, 0x1BA0, 0x1E39, 0x1D53, 0x1A4A, 0x21DB, 0x1B61, 0x16C1, 0x1585, 0x146D, 0x10A7,
    0x06B5, 0xFEF6, 0xF4E0, 0xEBBE, 0xEE0A, 0xE5C3, 0xE35C, 0xECA7, 0xEFBC, 0xF00B, 0xEE8C, 0xF2A5, 0xF689, 0xF35A, 0xF6A3, 0xFA8A,
    0xFA73, 0xFCD6, 0x00E3, 0x08C1, 0x0730, 0x0D24, 0x143A, 0x0E9D, 0x0EC4, 0x0E57, 0x039D, 0xFF8F, 0xFA79, 0xF73F, 0xF747, 0xF124,
    0xEDF9, 0xE76A, 0xEC23, 0xE8C5, 0xE669, 0xF589, 0xF723, 0xFC69, 0x008A, 0x00CB, 0xFFFB, 0xF671, 0xF394, 0xEBFE, 0xE9C3, 0xED5F,
    0xEB6E, 0xEBE9, 0xEC50, 0xF3D9, 0xF633, 0xEFC9, 0xF835, 0x00A1, 0xFF76, 0x06CD, 0x0AA9, 0x0925, 0x0A4F, 0x0D68, 0x0A37, 0x0832,
    0x14DE, 0x1489, 0x11E7, 0x1237, 0x0E84, 0x069B, 0xFEEF, 0xF917, 0xF274, 0xF757, 0xF8ED, 0x0058, 0x0653, 0x0A46, 0x1166, 0x1248,
    0x124C, 0x0FA9, 0x10A9, 0x14CB, 0x128D, 0x173C, 0x18A1, 0x1E78, 0x2432, 0x1CAE, 0x233B, 0x215E, 0x1B30, 0x194B, 0x133E, 0x0E52,
    0x0373, 0xFE3F, 0xF600, 0xE460, 0xE780, 0xDFFD, 0xDA2D, 0xDC12, 0xDC21, 0xE78C, 0xE256, 0xE6F5, 0xEA7B, 0xE679, 0xE7CA, 0xE1E0,
    0xE029, 0xDB24, 0xD5AD, 0xD73E, 0xD0C7, 0xD65D, 0xD9AB, 0xD3E3, 0xDAB1, 0xDBEA, 0xDEC6, 0xE1E3, 0xE6E2, 0xF0FD, 0xF34D, 0xFADC,
    0xFC01, 0xFBF1, 0x04E3, 0x02C7, 0x054B, 0x048C, 0x012B, 0x0371, 0xFCE5, 0xF4EC, 0xEF37, 0xED8A, 0xED3F, 0xEC06, 0xEF89, 0xF84A,
    0xFE6C, 0x0216, 0xFEB1, 0x06E8, 0x111E, 0x07D3, 0x09E6, 0x0F61, 0x1217, 0x153A, 0x1D3F, 0x220A, 0x207D, 0x27EF, 0x2E58, 0x2D85,
    0x315C, 0x3886, 0x3CAA, 0x3BEA, 0x34D7, 0x34B4, 0x3368, 0x2C22, 0x25C4, 0x1E73, 0x1AB8, 0x1DD1, 0x1814, 0x11F2, 0x151C, 0x1C1E,
    0x143B, 0x09A2, 0x0531, 0xF8EA, 0xF075, 0xECA3, 0xE5DC, 0xE180, 0xE6F3, 0xDFD2, 0xD80B, 0xD33D, 0xD325, 0xD44B, 0xD17F, 0xD321,
    0xD12C, 0xD7D5, 0xD9CC, 0xD5D3, 0xD8AB, 0xD74A, 0xDBB3, 0xDDA4, 0xDDB2, 0xE750, 0xE806, 0xE94E, 0xE8BB, 0xE5F0, 0xE749, 0xE7C7,
    0xECEF, 0xEEB2, 0xF48B, 0x0203, 0x0577, 0x0C69, 0x13E9, 0x10BB, 0x1258, 0x11A3, 0x13BB, 0x1428, 0x1489, 0x183B, 0x1536, 0x1665,
    0x163D, 0x1A8D, 0x1E19, 0x1D34, 0x2438, 0x2844, 0x2500, 0x29EC, 0x2BF1, 0x26AB, 0x231A, 0x2215, 0x1E0C, 0x13EF, 0x0E20, 0x09D7,
    0x0AFE, 0x0C05, 0x093C, 0x09C7, 0x0D49, 0x0A42, 0x06F6, 0x009E, 0xF709, 0xF2FF, 0xEFBC, 0xE8C6, 0xE7B1, 0xEAF4, 0xECB7, 0xEAF0,
    0xE968, 0xED69, 0xF228, 0xFB3B, 0xF7E5, 0xFC36, 0x013F, 0xFE12, 0xFF17, 0xF9E5, 0xF423, 0xF618, 0xFC40, 0xFAB5, 0xF56E, 0xFBB5,
    0xFE05, 0xF2D7, 0xF0ED, 0xF0A5, 0xF13F, 0xEFD8, 0xEDE2, 0xF6C1, 0xF83B, 0xF9A0, 0xFC31, 0xF690, 0xF75D, 0xF74D, 0xFD09, 0xF575,
    0xEFA1, 0xF758, 0xF4DD, 0xF82D, 0xF75D, 0xFB8C, 0x035D, 0x08F2, 0x0B25, 0x0F85, 0x1A66, 0x1C65, 0x1B10, 0x1943, 0x151F, 0x120D,
    0x0E48, 0x029D, 0xFD74, 0x003D, 0x0010, 0xFC7F, 0xFD77, 0x013D, 0xFC7C, 0xF74B, 0xF11A, 0xEEBD, 0xE932, 0xE444, 0xE544, 0xE1C5,
    0xE2A2, 0xE248, 0xDF91, 0xDDC8, 0xE1F5, 0xEDBB, 0xED3A, 0xF5A5, 0x01AA, 0x05F8, 0x0A45, 0x05B5, 0x0423, 0x0562, 0x09BF, 0x07C6,
    0x0457, 0x09ED, 0x0C9E, 0x0673, 0x0561, 0xFF70, 0x03A6, 0x0550, 0xFF49, 0x082F, 0x0926, 0x1062, 0x159B, 0x13CD, 0x14E3, 0x1613,
    0x1DAC, 0x180B, 0x0E10, 0x178B, 0x152B, 0x1668, 0x1517, 0x1217, 0x1C46, 0x1B2B, 0x1983, 0x18AE, 0x1CE4, 0x2740, 0x21D0, 0x1FE1,
    0x1EEE, 0x1719, 0x161A, 0x0066, 0xF8EA, 0xF23E, 0xE80D, 0xEA7B, 0xDD91, 0xDB9E, 0xE037, 0xE093, 0xDAD6, 0xD110, 0xD819, 0xD526,
    0xCA91, 0xCE87, 0xCB0B, 0xCFEA, 0xD367, 0xCCF9, 0xCCD1, 0xCC4A, 0xD3E8, 0xD874, 0xDA43, 0xE642, 0xEDB4, 0xF4AA, 0xF2FB, 0xEE51,
    0xF4E6, 0xF298, 0xF3BF, 0xF757, 0xF789, 0xFF94, 0xFFEB, 0xFC13, 0xFC2B, 0xF7E4, 0xF58F, 0xF56D, 0xF584, 0xF796, 0xF8EE, 0x0397,
    0x0171, 0x0033, 0x0D39, 0x0C14, 0x0B41, 0x080F, 0x0424, 0x058A, 0x04D0, 0x0A6B, 0x0F05, 0x13AE, 0x1D39, 0x1A7F, 0x1C88, 0x213B,
    0x253B, 0x29BF, 0x2970, 0x34A8, 0x37CB, 0x31CC, 0x3833, 0x30FE, 0x2534, 0x23A6, 0x2415, 0x2317, 0x1D16, 0x2616, 0x231E, 0x1D0E,
    0x1D3A, 0x1754, 0x1195, 0x07FD, 0x01FE, 0x00DA, 0xF9D4, 0xEFC6, 0xEE27, 0xE81E, 0xE145, 0xDEF7, 0xE0AB, 0xE322, 0xE672, 0xEB72,
    0xE776, 0xE629, 0xEA08, 0xE3C8, 0xE2E5, 0xE6FA, 0xE5B7, 0xE6A5, 0xE5A7, 0xE3AE, 0xE3A1, 0xE2A1, 0xE312, 0xE0E1, 0xE2F3, 0xE6F1,
    0xE45F, 0xEC44, 0xE6A5, 0xE8D1, 0x000F, 0x0749, 0x04AF, 0xF8CE, 0xF874, 0xFA2A, 0xE4DC, 0xD4C5, 0xCF46, 0xC106, 0xB4F2, 0xBC2E,
    0xD189, 0xD0AE, 0xD916, 0xDCF0, 0xD5BF, 0xEB2B, 0xF106, 0x017D, 0x0969, 0x0C7F, 0x1B9C, 0x1366, 0x1157, 0x0CB7, 0x043A, 0x0974,
    0x0314, 0x05CE, 0x0DD8, 0x0C05, 0x0AF8, 0x0138, 0xFCDF, 0xFDA5, 0xF178, 0xEC2E, 0xFF3C, 0xF731, 0xDDD3, 0xE070, 0xE2E2, 0xE5EB,
    0xFC68, 0x0088, 0x0CF8, 0x2209, 0x2D61, 0x3756, 0x4247, 0x5056, 0x4870, 0x4445, 0x3CC9, 0x37A2, 0x338C, 0x38CD, 0x454F, 0x3194,
    0x24E5, 0x1F4E, 0x16D0, 0x0313, 0xEE11, 0xEC7D, 0xD715, 0xCF0A, 0xCCC9, 0xCC44, 0xD8EC, 0xD55E, 0xD81B, 0xCE91, 0xCEC8, 0xDBD2,
    0xD704, 0xD954, 0xD863, 0xE079, 0xEC96, 0xE193, 0xD69C, 0xD996, 0xE057, 0xE162, 0xE65F, 0xEE7F, 0xF843, 0xFA69, 0xFBAF, 0xFF71,
    0xF9FF, 0xEBB7, 0xF6C7, 0x0002, 0xF9BF, 0x0014, 0xF2B7, 0xF6DD, 0xFBF1, 0xFC31, 0x037C, 0x0B76, 0x171E, 0x15FD, 0x2148, 0x28AE,
    0x2BE9, 0x20E8, 0x15C8, 0x1900, 0x03A0, 0x0215, 0x1510, 0x237B, 0x1E11, 0x19DA, 0x1E14, 0x0A55, 0x03F0, 0xFA18, 0xE74A, 0xD463,
    0xC264, 0xC2FA, 0xC084, 0xBAF4, 0xC463, 0xC573, 0xBFE9, 0xBE22, 0xC2D1, 0xCCFA, 0xCD9B, 0xD694, 0xE77B, 0xEC1A, 0xF27E, 0xEED9,
    0xE8A9, 0xEE24, 0xEA53, 0xEA9F, 0xF02A, 0xF6E7, 0xF147, 0x01B8, 0x0E36, 0x00E1, 0x046F, 0x0AEF, 0x1556, 0x2105, 0x1E17, 0x1B0D,
    0x2165, 0x1A4E, 0x1E26, 0x2240, 0x1C97, 0x2246, 0x234C, 0x2EFA, 0x3D26, 0x4121, 0x42AE, 0x3ABB, 0x3625, 0x19BD, 0x0D3C, 0x1B38,
    0x11AA, 0x1678, 0x10A0, 0x0409, 0xFFD9, 0xED31, 0xE32F, 0xD514, 0xC9AE, 0xC27F, 0xB92B, 0xC044, 0xBFB9, 0xC4D0, 0xCE94, 0xC931,
    0xCBAB, 0xD548, 0xD9DE, 0xDE60, 0xE1FC, 0xE66E, 0xECA2, 0xEDDD, 0xE237, 0xDDCB, 0xE1BD, 0xD35D, 0xD984, 0xDF9A, 0xD503, 0xE100,
    0xF594, 0xFB8A, 0xF969, 0xFD1E, 0xFF0D, 0x0A76, 0x0E28, 0x07BB, 0x0CFD, 0x0C93, 0x0E00, 0x0D04, 0x179A, 0x24AA, 0x233E, 0x2E4F,
    0x37E1, 0x4ED6, 0x5DE5, 0x60E3, 0x6E2B, 0x603D, 0x5912, 0x50D9, 0x46A6, 0x4ED7, 0x4A76, 0x5334, 0x505E, 0x4614, 0x4518, 0x35B9,
    0x2F27, 0x1E67, 0x076D, 0x039B, 0xF58E, 0xEB5E, 0xEC28, 0xE66C, 0xDE1F, 0xD104, 0xD35E, 0xCDDF, 0xCCFD, 0xD88E, 0xD8F5, 0xE481,
    0xE078, 0xE302, 0xE92A, 0xD997, 0xDDCE, 0xE22E, 0xE09F, 0xDB57, 0xDC71, 0xE8DA, 0xED9E, 0xE767, 0xDE8A, 0xDFEB, 0xE3B6, 0xEA9E,
    0xE412, 0xE893, 0xE968, 0xE47E, 0xEB25, 0xF185, 0x03D4, 0x0706, 0x0E2F, 0x1F76, 0x1FE1, 0x2F26, 0x3A78, 0x40D3, 0x48BA, 0x3803,
    0x3911, 0x3365, 0x2D26, 0x3790, 0x3E00, 0x44C8, 0x4966, 0x4A05, 0x4E37, 0x4153, 0x38A0, 0x29A1, 0x14B5, 0x1552, 0x068E, 0x1154,
    0x0AF1, 0x0903, 0x0AE6, 0x0241, 0x0AF7, 0x0168, 0x074A, 0x10EE, 0x0AF6, 0x10C8, 0x0C3C, 0xFDF9, 0xF59E, 0xE404, 0xE658, 0xE39B,
    0xD9E7, 0xD81E, 0xE307, 0xF072, 0xEF10, 0xEE02, 0xF541, 0xFBF0, 0x0813, 0x0ECF, 0x0F5C, 0x1830, 0x0CD8, 0x10C6, 0x175B, 0x0F1A,
    0x103C, 0x15D7, 0x13E2, 0x1A9F, 0x25C9, 0x320C, 0x3AA7, 0x4001, 0x4245, 0x3531, 0x3507, 0x2FCB, 0x2E60, 0x2FA4, 0x2C7A, 0x2E0D,
    0x2C8D, 0x2516, 0x1CAD, 0x0D35, 0xFFDE, 0xEAA1, 0xD97F, 0xD488, 0xD4E9, 0xE6D9, 0xE130, 0xE473, 0xF179, 0xECCB, 0xECA6, 0xF127,
    0xEE67, 0xF5F0, 0xFF08, 0x03A2, 0x0177, 0xFAA6, 0xFC06, 0xFE04, 0x024F, 0xF498, 0xEF86, 0xFF11, 0x0251, 0xF96A, 0xF448, 0xED9A,
    0xF45A, 0xEAEB, 0xE7E6, 0xF33C, 0xE7C1, 0xE832, 0xE49D, 0xE455, 0xE4A5, 0xE9A8, 0xF67B, 0xF582, 0x029B, 0x1E65, 0x2A3C, 0x3D34,
    0x4376, 0x41C1, 0x46AA, 0x38C0, 0x2EBA, 0x2610, 0x29D3, 0x245A, 0x18EB, 0x21B5, 0x1EDA, 0x2006, 0x24D7, 0x0F7E, 0x0D74, 0xFD10,
    0xEFF4, 0xF3CC, 0xE782, 0xF0F6, 0xF408, 0xF366, 0xE98C, 0xE750, 0xED25, 0xDFED, 0xD9D4, 0xE637, 0xEC05, 0xF766, 0xF908, 0xF82F,
    0x0CDE, 0x109B, 0x0C23, 0x0068, 0x0184, 0x0F9D, 0x0AC1, 0x07C5, 0x066B, 0xFCC3, 0x010D, 0xFC82, 0xFF68, 0xFCF1, 0xF83A, 0xFDAD,
    0xF0A4, 0xE868, 0xE754, 0xE567, 0xDFFD, 0xDABA, 0xE107, 0xEFCC, 0xF5FD, 0x0689, 0x03C8, 0x0939, 0x0BA0, 0xFE0D, 0x0501, 0x003E,
    0x09DA, 0x0ECC, 0x0992, 0x134A, 0x1896, 0x192F, 0x127D, 0xFD00, 0xF1D3, 0xE087, 0xD2A2, 0xCBCF, 0xC532, 0xCD99, 0xCA40, 0xC87B,
    0xCD7D, 0xCEC8, 0xD2B9, 0xD32D, 0xD6B6, 0xE869, 0xEECF, 0xF222, 0xEE2F, 0xF260, 0xFB1F, 0xE784, 0xDF00, 0xE664, 0xE91B, 0xEFF9,
    0xFC1A, 0xFF4C, 0x009C, 0x0538, 0x17A5, 0x15DF, 0x14C2, 0x1D24, 0x1B3F, 0x1BEB, 0x101A, 0x1562, 0x1971, 0x110A, 0x1566, 0x1724,
    0x2270, 0x39AF, 0x41B4, 0x4EE4, 0x4AAB, 0x474B, 0x404F, 0x2A03, 0x2931, 0x1A41, 0x17A1, 0x1D7D, 0x0E34, 0x10DF, 0x14F4, 0x0AB3,
    0xFDA8, 0xE618, 0xE0CE, 0xD278, 0xCFF1, 0xD427, 0xCBDA, 0xD65A, 0xD13E, 0xD28C, 0xD48B, 0xCB51, 0xC8CA, 0xC9C7, 0xC88C, 0xCC2E,
    0xC0EA, 0xC2CA, 0xCC92, 0xCBF4, 0xC86A, 0xC16C, 0xCF4B, 0xCD9B, 0xD53F, 0xE054, 0xE0D7, 0xE625, 0xED5D, 0xECDA, 0xF19B, 0xF1BB,
    0xF381, 0xF1ED, 0xEC63, 0xF43F, 0xF336, 0x007A, 0x022B, 0x0250, 0x0F04, 0x1794, 0x26D0, 0x3CB1, 0x4190, 0x545B, 0x52F7, 0x47B9,
    0x468F, 0x3C22, 0x3E1B, 0x38FE, 0x3C9A, 0x3688, 0x39E7, 0x4399, 0x3851, 0x25CF, 0x1C78, 0x0223, 0xF08A, 0xDD89, 0xD084, 0xD2C5,
    0xC5DB, 0xC4D7, 0xBE5D, 0xC063, 0xBFEA, 0xBB02, 0xBF5F, 0xC62D, 0xCF37, 0xD6C6, 0xD46F, 0xE4F7, 0xE8C5, 0xE865, 0xEBA2, 0xE24F,
    0xE1F6, 0xE521, 0xEB4E, 0xE1AA, 0xDB53, 0xE330, 0xE81D, 0xE483, 0xEF82, 0xED4E, 0xF4AA, 0xF3FD, 0xF24A, 0xFE03, 0xFB6C, 0x00B9,
    0xFF01, 0xF937, 0xF2CB, 0xFD55, 0x07BE, 0x143B, 0x1EBE, 0x2A4C, 0x2C85, 0x2B7D, 0x2A68, 0x24B0, 0x2BCE, 0x2C7E, 0x298C, 0x307D,
    0x37EC, 0x397A, 0x3632, 0x2856, 0x1D25, 0x0770, 0x00DE, 0xF387, 0xEF51, 0xF46C, 0xE8DE, 0xE951, 0xEBC9, 0xE74F, 0xDB8F, 0xD691,
    0xDA89, 0xD491, 0xC9A8, 0xD218, 0xCB4A, 0xCBFD, 0xC5EB, 0xC5DF, 0xC381, 0xB79D, 0xC780, 0xCB0D, 0xC780, 0xCB26, 0xD086, 0xDE69,
    0xE62D, 0xE7F5, 0xF847, 0xF3B9, 0xF681, 0xEDE7, 0xE881, 0xED28, 0xE64A, 0xEB92, 0xE7E6, 0xE413, 0xEEAC, 0xFA5B, 0x0B75, 0x1CDF,
    0x2C52, 0x42D1, 0x3D36, 0x441B, 0x45CB, 0x4274, 0x409C, 0x357F, 0x37C8, 0x38FC, 0x37EC, 0x3D65, 0x37AF, 0x27B5, 0x1FB0, 0x1298,
    0x0C9F, 0x01D5, 0x047B, 0x0092, 0xFC5F, 0x0155, 0xF65C, 0xEDD7, 0xEE09, 0xEBBB, 0xEC24, 0xEAF0, 0xE9D9, 0xF03A, 0xEBE5, 0xED8C,
    0xE68D, 0xDE87, 0xD5ED, 0xD088, 0xCF81, 0xC94C, 0xC0FA, 0xC08B, 0xBC99, 0xBD4D, 0xC569, 0xC1F4, 0xCA3D, 0xC9AD, 0xC85F, 0xC5BF,
    0xC9AF, 0xCE09, 0xD0CB, 0xD6D7, 0xDAEB, 0xE18D, 0xEEE2, 0xF6EC, 0x0247, 0x1778, 0x1986, 0x1F0B, 0x1B5B, 0x1CE7, 0x1F0D, 0x1887,
    0x143F, 0x15BC, 0x1F6E, 0x28AE, 0x2FDD, 0x3A32, 0x3510, 0x2EB0, 0x275C, 0x150D, 0x11BA, 0x03D9, 0xFDCA, 0xFB84, 0xFB95, 0xFA04,
    0xF629, 0xFA0D, 0xFA15, 0xF2A5, 0xFD4E, 0x01F9, 0x028E, 0x0DA3, 0x107D, 0x19AD, 0x0A60, 0x01C1, 0x02EB, 0x01D5, 0x0247, 0x0232,
    0x0357, 0x0314, 0x04AD, 0x0CF4, 0x0996, 0x09F8, 0x1139, 0x08B3, 0x0851, 0xFCA6, 0xF734, 0xFB80, 0xEF00, 0xE131, 0xE13B, 0xE365,
    0xEC0B, 0xF01B, 0xFFD8, 0x0BB8, 0x0D45, 0x1676, 0x1159, 0x1937, 0x1DB4, 0x1B8D, 0x1A0D, 0x10F0, 0x1387, 0x1A89, 0x133A, 0x0F86,
    0xFE03, 0xF0E7, 0xE614, 0xD30D, 0xCA90, 0xBB82, 0xC42D, 0xCA4F, 0xC61F, 0xCC1C, 0xD393, 0xDB80, 0xDD7A, 0xD82B, 0xDE5D, 0xE26C,
    0xE5CE, 0xEA35, 0xEB1B, 0xEA95, 0xE0E3, 0xE65A, 0xE7C3, 0xE80B, 0xF11B, 0xF926, 0xFAA1, 0xFEAF, 0x07B7, 0x1089, 0x10E1, 0x13C6,
    0x18AD, 0x17CE, 0x15FA, 0x1798, 0x1F26, 0x1B8C, 0x19DD, 0x1867, 0x1989, 0x1722, 0x2224, 0x2F97, 0x3175, 0x3064, 0x3015, 0x2F1C,
    0x276A, 0x2639, 0x2336, 0x1B1D, 0x13BF, 0x10A0, 0x12EF, 0x190E, 0x141D, 0x153E, 0x10B8, 0x0BAE, 0x07AD, 0xFD11, 0xF70C, 0xEC90,
    0xEA22, 0xE69E, 0xE079, 0xE3A8, 0xE5A6, 0xE5DE, 0xE3E0, 0xD8D8, 0xDA98, 0xDA5E, 0xE1ED, 0xE955, 0xE8A9, 0xF08D, 0xEC31, 0xEF8E,
    0xF24F, 0xEFBD, 0xF31C, 0xEDA0, 0xE7A0, 0xE726, 0xE2B7, 0xE91C, 0xE982, 0xE8F3, 0xED97, 0xEB3A, 0xF2B7, 0xF849, 0xFBF1, 0xFD90,
    0xFB9A, 0xFF7E, 0xFB94, 0x001B, 0x172E, 0x1F8B, 0x2F7F, 0x3892, 0x3D30, 0x4693, 0x4332, 0x4487, 0x4093, 0x388B, 0x36C3, 0x373F,
    0x3A3A, 0x3370, 0x21FB, 0x1F86, 0x0FBA, 0xFFD9, 0xEFE9, 0xE15C, 0xDD0B, 0xCD9B, 0xC64B, 0xC408, 0xC528, 0xC706, 0xC923, 0xD426,
    0xD935, 0xD982, 0xE0CA, 0xE322, 0xED75, 0xED45, 0xE926, 0xEA7A, 0xE716, 0xE5F9, 0xE35D, 0xE05E, 0xD77A, 0xD5A7, 0xDC67, 0xDEFD,
    0xE670, 0xF76B, 0x00F7, 0x0A8A, 0x0B2C, 0x0C34, 0x1138, 0x11C5, 0x104A, 0x0A5F, 0x041E, 0xFEBB, 0x0241, 0x09FF, 0x1666, 0x245F,
    0x36AC, 0x3DED, 0x4066, 0x469E, 0x4AC3, 0x49FE, 0x3E31, 0x39F6, 0x4231, 0x4847, 0x4699, 0x434A, 0x3F63, 0x3EC8, 0x36D7, 0x2851,
    0x147C, 0x0D88, 0x0BA2, 0xF6E4, 0xE62E, 0xDE33, 0xD9AB, 0xD6E4, 0xCDFC, 0xC8F2, 0xC72E, 0xC30C, 0xC6A5, 0xC214, 0xC126, 0xC218,
    0xC182, 0xC0D0, 0xBEFB, 0xC9D8, 0xD1B6, 0xCFA1, 0xD347, 0xD56C, 0xD869, 0xE1BE, 0xE242, 0xEA14, 0xEB39, 0xEE9C, 0xF0B2, 0xE71D,
    0xE7BE, 0xE852, 0xEA2F, 0xEA70, 0xE38F, 0xF305, 0x0557, 0x0FB6, 0x21EA, 0x2D1F, 0x3DDA, 0x40EB, 0x4419, 0x4B84, 0x4608, 0x40D3,
    0x3A82, 0x3A1C, 0x3EDA, 0x3ECF, 0x47D3, 0x4938, 0x41DF, 0x4408, 0x3A18, 0x2FA7, 0x1DD5, 0x1817, 0x172E, 0x06DB, 0x00CB, 0xFF21,
    0x02DC, 0x02DB, 0xFE14, 0x013C, 0x0013, 0x0147, 0x0707, 0x051D, 0x02CB, 0xFA71, 0xF724, 0xF15B, 0xEC27, 0xEDE6, 0xE89D, 0xE284,
    0xDBDC, 0xD466, 0xD26D, 0xD2A2, 0xD2E1, 0xDA1B, 0xDF90, 0xE5BF, 0xE869, 0xECEC, 0xEC4C, 0xECA7, 0xEEA4, 0xE433, 0xDEA8, 0xE3EE,
    0xE9A0, 0xEBC8, 0xF3F6, 0xF97A, 0xFC79, 0xFD28, 0x0705, 0x0D40, 0x0904, 0x0AE8, 0x1005, 0x181D, 0x1F98, 0x2679, 0x30B5, 0x2F97,
    0x29DE, 0x25C7, 0x155C, 0x0FDB, 0x0718, 0xFECD, 0xF8C9, 0xF080, 0xF07E, 0xF1EB, 0xF651, 0xF84E, 0xF5FC, 0xFC85, 0xFFDA, 0x0001,
    0x0941, 0x073D, 0x0B84, 0x0972, 0x06FB, 0x0F25, 0x12DF, 0x1508, 0x151B, 0x100F, 0x0C02, 0x06CA, 0x0227, 0x0385, 0x03C4, 0x07E0,
    0x037D, 0x0021, 0xFD04, 0xF731, 0xF5B9, 0xEC6F, 0xDDBE, 0xDD4C, 0xDADA, 0xDE8A, 0xED43, 0xFDD7, 0x0C76, 0x1063, 0x2076, 0x29D7,
    0x2DE1, 0x3445, 0x2EA8, 0x2A8F, 0x2D82, 0x2BE8, 0x2EE0, 0x2649, 0x238D, 0x2720, 0x1A0C, 0x0F7A, 0x02B5, 0x0191, 0xFB8B, 0xF374,
    0xF1CB, 0xEB29, 0xEE33, 0xEF6E, 0xE6DE, 0xE41C, 0xDE6C, 0xDEDA, 0xE1AE, 0xDFA0, 0xE456, 0xE7E5, 0xED66, 0xE779, 0xE5B7, 0xEF13,
    0xF2FB, 0xF224, 0xEDFA, 0xEE41, 0xF343, 0xEF61, 0xF057, 0xF62F, 0x006D, 0x0B14, 0x0D82, 0x15D3, 0x1965, 0x2219, 0x1FD4, 0x0E90,
    0x054A, 0xFDDC, 0xF697, 0xFAB3, 0x031A, 0x0ACB, 0x0C35, 0x0EF1, 0x16D3, 0x100E, 0x0BDF, 0x0C1A, 0x0AE7, 0x077E, 0x09C0, 0x176E,
    0x1F7D, 0x1F04, 0x27EA, 0x2ADD, 0x25DA, 0x2164, 0x1826, 0x12DE, 0x07EA, 0xF84D, 0xED25, 0xE4CF, 0xE08F, 0xDCBB, 0xD78B, 0xD80C,
    0xD330, 0xDD59, 0xE88C, 0xE8AC, 0xF200, 0xF7BC, 0xFAB2, 0xFA47, 0xFAAB, 0xFF23, 0xFB3D, 0xF715, 0xF746, 0xF148, 0xF670, 0xF610,
    0xF925, 0x01D5, 0x05CD, 0x1181, 0x10FC, 0x1632, 0x2233, 0x1D4A, 0x182D, 0x12D0, 0x0B19, 0x06E7, 0x06A7, 0x1B21, 0x24DB, 0x2BC8,
    0x3AC0, 0x41BD, 0x45FA, 0x4002, 0x3860, 0x3408, 0x2D35, 0x2ABA, 0x2838, 0x1FFA, 0x1D1C, 0x13BA, 0x0D37, 0xFC00, 0xEC67, 0xE611,
    0xDA90, 0xD383, 0xC7A8, 0xC0E7, 0xC0D7, 0xBFF0, 0xC02C, 0xC2AE, 0xC55B, 0xC89C, 0xCB98, 0xD117, 0xD11C, 0xD63A, 0xD776, 0xCFF1,
    0xCF06, 0xD051, 0xD338, 0xD4B7, 0xD4BC, 0xD769, 0xDCA2, 0xE24C, 0xE624, 0xE9ED, 0xF781, 0xFE9C, 0x04A1, 0x0781, 0x08C0, 0x1122,
    0x1701, 0x1544, 0x0FF5, 0x0B98, 0x07FF, 0x08A9, 0x08D8, 0x1115, 0x1DEF, 0x2D98, 0x3667, 0x3EE7, 0x47D8, 0x459B, 0x4249, 0x4148,
    0x4110, 0x48AA, 0x4E8F, 0x516A, 0x5772, 0x54A3, 0x505D, 0x465B, 0x3A6E, 0x32E2, 0x2BD8, 0x20D5, 0x1138, 0x03A7, 0xFAB1, 0xEC85,
    0xE427, 0xDA16, 0xCF45, 0xD3C6, 0xD109, 0xCEED, 0xD045, 0xD2DC, 0xD27D, 0xD00A, 0xD14F, 0xD608, 0xDB83, 0xE1B2, 0xDDED, 0xDBE9,
    0xDE6A, 0xD555, 0xD259, 0xCFC8, 0xD0AD, 0xD2CA, 0xD147, 0xD4E2, 0xDAF0, 0xDEE1, 0xE7C6, 0xE92C, 0xE4B9, 0xE1EC, 0xEAE7, 0xF467,
    0xF2B4, 0xFFA3, 0x10E3, 0x1B18, 0x23E1, 0x2A91, 0x2EF9, 0x325A, 0x2D0E, 0x2D96, 0x2EF2, 0x3641, 0x3A21, 0x4337, 0x46E8, 0x3F2A,
    0x3E49, 0x373C, 0x2E0A, 0x22E8, 0x212C, 0x1A5E, 0x144B, 0x0E76, 0x0FF7, 0x0DE2, 0x0379, 0xFCB1, 0xFB4D, 0xFC7E, 0xFCA7, 0xFFF6,
    0xFC43, 0xF591, 0xEF96, 0xE8A3, 0xD933, 0xD4C7, 0xD447, 0xD2C9, 0xCFB6, 0xCC0B, 0xCD63, 0xCC4E, 0xCDE8, 0xD059, 0xD659, 0xE017,
    0xE673, 0xF133, 0xFAF3, 0x0181, 0x099F, 0xFDF4, 0xF3FB, 0xECC6, 0xEBD6, 0xEF1E, 0xEB6B, 0xF4CF, 0xFFD5, 0x12CA, 0x1EFE, 0x1FCE,
    0x2BDC, 0x3085, 0x2FF1, 0x32FE, 0x3307, 0x39A8, 0x3C75, 0x4262, 0x41D3, 0x37E7, 0x3599, 0x2DF3, 0x2A5C, 0x1C95, 0x1064, 0x1125,
    0x06AF, 0xFF07, 0xFC2D, 0xF7E6, 0xF11C, 0xE9E5, 0xEAD8, 0xE550, 0xEEAC, 0xFBF3, 0xFB54, 0xFCD2, 0xFB28, 0x0132, 0xFB46, 0xF80D,
    0xFC30, 0xFBA8, 0xFBE5, 0xF231, 0xF0E9, 0xEB76, 0xDED8, 0xDEAF, 0xD8F6, 0xD6A0, 0xD6B2, 0xDCB9, 0xE85D, 0xE1D9, 0xE1A6, 0xDD75,
    0xD959, 0xD860, 0xD4E5, 0xE329, 0xE90E, 0xF797, 0x0EC9, 0x19C5, 0x2520, 0x29FF, 0x2EC4, 0x25CD, 0x1F89, 0x2296, 0x1CD8, 0x22B1,
    0x22D7, 0x2629, 0x29E6, 0x21B3, 0x2071, 0x1E1B, 0x1E7D, 0x1736, 0x0C92, 0x0A18, 0x0231, 0x02E7, 0xFD91, 0xF27E, 0xF34B, 0xED86,
    0xEE30, 0xEFC8, 0xF4CA, 0xFC23, 0xFDD2, 0x0466, 0xFF23, 0xFF54, 0xFFC6, 0xFBBC, 0x0111, 0xFE09, 0xFF7E, 0x057E, 0x0516, 0x042E,
    0x045F, 0x0A53, 0x068C, 0x06A4, 0x0F04, 0x15CA, 0x1F37, 0x1786, 0x0B12, 0x006E, 0xF0DC, 0xE52B, 0xDB3E, 0xD5CB, 0xD83A, 0xE07C,
    0xE892, 0xEABF, 0xEF49, 0xF133, 0xEF85, 0xF1C7, 0xF31E, 0xF963, 0x082D, 0x1307, 0x15B2, 0x1B11, 0x1E40, 0x197C, 0x13FC, 0x0AF1,
    0x0322, 0xF972, 0xE918, 0xE005, 0xDEE5, 0xDB31, 0xD477, 0xD400, 0xD486, 0xD4E4, 0xDA47, 0xE226, 0xE747, 0xEEEA, 0xF8F0, 0xF71E,
    0xF790, 0xF83C, 0xF7D8, 0xFE77, 0xF8CE, 0xFBD4, 0x0608, 0x0574, 0x0815, 0x067D, 0x09F2, 0x0742, 0x0232, 0x093E, 0x0C4D, 0x19F3,
    0x20DF, 0x2085, 0x1E8D, 0x14C9, 0x18B7, 0x1410, 0x0B71, 0x106F, 0x21A9, 0x32EF, 0x35A3, 0x4435, 0x48BE, 0x4107, 0x4007, 0x3337,
    0x2F8E, 0x2CA0, 0x2EEC, 0x3206, 0x25B2, 0x256C, 0x1AAF, 0x1738, 0x0EEA, 0xFCF0, 0xFFB2, 0xF0DA, 0xEC12, 0xE7EA, 0xE0F3, 0xE4D5,
    0xD731, 0xD3DE, 0xCAC0, 0xC704, 0xC949, 0xBD7A, 0xC3F8, 0xBD5D, 0xBE3A, 0xC553, 0xBEA6, 0xC7D7, 0xC48A, 0xCA81, 0xD229, 0xD01C,
    0xDADD, 0xD462, 0xDFC4, 0xE463, 0xDC65, 0xE77E, 0xE130, 0xEE3B, 0xF977, 0x000A, 0x0C81, 0x0BDB, 0x0E88, 0x0A16, 0x03B9, 0xFA98,
    0xF634, 0x041F, 0x0A60, 0x1582, 0x2C4C, 0x35FA, 0x3F1E, 0x3D12, 0x4024, 0x4132, 0x4244, 0x4D56, 0x4DF7, 0x5ABD, 0x5A45, 0x54BB,
    0x52A9, 0x4576, 0x4058, 0x2F12, 0x1FD5, 0x12B1, 0x0638, 0xFC55, 0xEC24, 0xE47B, 0xD6E5, 0xCC48, 0xCCFB, 0xCD29, 0xCA76, 0xCF85,
    0xD67E, 0xDA85, 0xDBED, 0xDE22, 0xE423, 0xE71E, 0xE613, 0xE31F, 0xE6F1, 0xE061, 0xD9F8, 0xDB8E, 0xDA37, 0xDCF1, 0xDB8B, 0xDFC7,
    0xE281, 0xE905, 0xF72F, 0xFD0F, 0x02A0, 0x02DB, 0x0846, 0x0A0D, 0xFC74, 0xF3A1, 0xFAB0, 0xFDE3, 0x05F2, 0x1925, 0x24D9, 0x3274,
    0x3556, 0x385C, 0x306A, 0x297C, 0x30B4, 0x2C2E, 0x35F7, 0x3697, 0x38CC, 0x3E5B, 0x3279, 0x3253, 0x2CFF, 0x248F, 0x1C78, 0x15CF,
    0x1820, 0x0DB3, 0x082D, 0x0368, 0xF23C, 0xED74, 0xE03B, 0xDC16, 0xDCCB, 0xD204, 0xD899, 0xD1E9, 0xCCCE, 0xC95F, 0xC3E8, 0xC8AD,
    0xBE9B, 0xC67E, 0xC6E7, 0xC65B, 0xD4B8, 0xD256, 0xDCED, 0xDF9E, 0xE025, 0xE6EB, 0xEB8D, 0xF81A, 0xF98A, 0xFB0E, 0xF87A, 0xF188,
    0xF1AF, 0xE674, 0xDE28, 0xDDCD, 0xDF96, 0xEB37, 0xF7B5, 0x0818, 0x15F3, 0x2452, 0x29A9, 0x21D3, 0x2733, 0x2697, 0x2BA7, 0x3345,
    0x355E, 0x44A4, 0x4882, 0x4ED4, 0x4CE1, 0x46A2, 0x4161, 0x3094, 0x2CD5, 0x216D, 0x1E39, 0x1F21, 0x1489, 0x1133, 0x08DB, 0x02FE,
    0x010D, 0x03E3, 0x06ED, 0x03E5, 0x099A, 0x0C97, 0x094C, 0x06E7, 0xFDCE, 0xFDC9, 0xFC11, 0xEEA4, 0xE9FD, 0xE97B, 0xE883, 0xDBCA,
    0xD1BE, 0xCCA5, 0xC175, 0xC2D6, 0xC4C0, 0xC871, 0xCDD1, 0xD0E9, 0xDA05, 0xDB2B, 0xD553, 0xD6D3, 0xDBBD, 0xD6BA, 0xDB2F, 0xE671,
    0xF021, 0xF729, 0xFC56, 0x0546, 0xFCE1, 0xFEBE, 0x0173, 0x00D8, 0x0AE5, 0x0B9A, 0x1A94, 0x2466, 0x23E1, 0x2D0F, 0x2F26, 0x2C04,
    0x1B92, 0x1154, 0x10A2, 0x0779, 0x0A8C, 0x0723, 0x028C, 0x051A, 0xFC89, 0xFE91, 0xF80F, 0xF4ED, 0xFEE1, 0xFA16, 0xFE12, 0xFB28,
    0x04CD, 0x05B9, 0xFC5B, 0x0C52, 0x0695, 0x09A1, 0x0CA0, 0x0ABF, 0x11BF, 0x0DB1, 0x10BE, 0x0DCD, 0x0D7A, 0x1429, 0x16AE, 0x1E5D,
    0x1BA0, 0x189A, 0x1A36, 0x0CCD, 0xFECE, 0xF15D, 0xE460, 0xDE6C, 0xDF70, 0xE663, 0xED2A, 0x0112, 0x0C4E, 0x0D87, 0x11C4, 0x0ECF,
    0x1958, 0x1AC3, 0x1B9B, 0x1F27, 0x1E24, 0x23BE, 0x1A84, 0x1906, 0x0FA5, 0x01F8, 0xFB33, 0xE863, 0xE471, 0xE5BF, 0xE0C9, 0xDEAA,
    0xDA7A, 0xD8D9, 0xD89F, 0xD433, 0xD0D6, 0xCF3F, 0xD624, 0xD7D8, 0xD9FD, 0xE5CC, 0xE45F, 0xE93B, 0xED0F, 0xE9FF, 0xEA50, 0xEB33,
    0xF218, 0xF0C2, 0xF532, 0xF90C, 0xF148, 0xF6C1, 0xF8DF, 0xFCF9, 0x08C0, 0x0BF8, 0x1AB7, 0x2149, 0x1E28, 0x2667, 0x1F8B, 0x177B,
    0x1479, 0x1818, 0x2548, 0x223B, 0x3309, 0x3CA6, 0x3466, 0x35B8, 0x24F2, 0x2503, 0x1F67, 0x1526, 0x1D17, 0x15DB, 0x17AF, 0x1B70,
    0x1E68, 0x1DC1, 0x1182, 0x197A, 0x123E, 0x043A, 0x05CD, 0xFEEE, 0xFCB7, 0xEBF0, 0xE171, 0xE0B9, 0xD493, 0xD42E, 0xCD1A, 0xCFD4,
    0xCF2D, 0xCDE8, 0xDE34, 0xD7AC, 0xE2C0, 0xECD9, 0xE763, 0xE7D2, 0xDED7, 0xE645, 0xE7BA, 0xEAD1, 0xF0A8, 0xEB3C, 0xF559, 0xF573,
    0xF949, 0x0113, 0x006B, 0x0EBB, 0x1269, 0x0F4C, 0x0AEF, 0x074A, 0x02FC, 0xF1E5, 0xF061, 0xF184, 0xFB4D, 0x0FC7, 0x1724, 0x2881,
    0x2C68, 0x2E3A, 0x32AD, 0x2CB2, 0x3784, 0x3741, 0x3EFB, 0x3FA7, 0x3AF4, 0x47F6, 0x3ABF, 0x3493, 0x2905, 0x1368, 0x0BAB, 0xF91C,
    0xF02B, 0xE603, 0xDB03, 0xDB02, 0xD332, 0xD694, 0xD471, 0xD3E2, 0xDD73, 0xD657, 0xDE94, 0xE02D, 0xDAF2, 0xE38F, 0xE12E, 0xE21E,
    0xDA7D, 0xD723, 0xD6F8, 0xCBA9, 0xD9ED, 0xDDDD, 0xDBF6, 0xE470, 0xE251, 0xEE59, 0xEF49, 0xED70, 0xF9E2, 0xFA5C, 0x0346, 0x091C,
    0x079F, 0x0CAF, 0x0372, 0x0608, 0x02A5, 0x00C9, 0x17C4, 0x207E, 0x2E76, 0x3899, 0x3AF4, 0x410D, 0x3B7D, 0x3B4A, 0x3E75, 0x40F6,
    0x4287, 0x4745, 0x5312, 0x4E16, 0x4D14, 0x4F97, 0x42AE, 0x370A, 0x2FE7, 0x319A, 0x2655, 0x186B, 0x14F6, 0x04CF, 0xF9D2, 0xE928,
    0xDF6F, 0xDB3F, 0xC7DE, 0xC996, 0xC10A, 0xB494, 0xB9D2, 0xBC69, 0xC150, 0xBADA, 0xBFB0, 0xC782, 0xC50C, 0xCDA7, 0xCC56, 0xD03A,
    0xD26E, 0xCD97, 0xD35A, 0xD0F8, 0xD1FD, 0xD30F, 0xD631, 0xDA53, 0xDA57, 0xE6C8, 0xE3AB, 0xE25D, 0xE6CA, 0xDDB2, 0xE262, 0xE329,
    0xEF94, 0x002E, 0x0798, 0x19A8, 0x1E84, 0x2A40, 0x2FA2, 0x3171, 0x3D25, 0x35BD, 0x40C5, 0x4B76, 0x49D9, 0x512C, 0x4D30, 0x4BC1,
    0x410F, 0x3659, 0x341B, 0x28F2, 0x2962, 0x1E9D, 0x1708, 0x17ED, 0x0B7F, 0x101B, 0x0BA5, 0x06C9, 0x0E22, 0x0A92, 0x09E7, 0x05D4,
    0x085F, 0x0B66, 0x01E9, 0x029F, 0xF845, 0xF1B6, 0xF6F5, 0xE730, 0xDF9D, 0xDAF1, 0xD570, 0xD812, 0xD2AC, 0xD7F5, 0xE184, 0xE489,
    0xEDC4, 0xF244, 0xF9A8, 0xFA3C, 0xF1A6, 0xF0EF, 0xE374, 0xDB07, 0xDC8D, 0xDBAE, 0xE3B4, 0xEA3D, 0xF13A, 0xFA3B, 0xFD6A, 0x03A7,
    0x0CC7, 0x10A6, 0x0E91, 0x13A5, 0x1BA5, 0x1C10, 0x2225, 0x2805, 0x24C6, 0x1DB7, 0x1D68, 0x1BB9, 0x0D19, 0x0BF4, 0x08BC, 0x030D,
    0xFED4, 0xF335, 0xF837, 0xEF76, 0xE74D, 0xEC06, 0xE524, 0xE539, 0xE5A7, 0xEDD6, 0xF3D1, 0xEEC9, 0xF7F9, 0xF694, 0xF7AE, 0x0013,
    0x053F, 0x0FCF, 0x0D4C, 0x0FD4, 0x1309, 0x107B, 0x0EBA, 0x0D2A, 0x1796, 0x0FCC, 0x0CA6, 0x13DE, 0x036F, 0xFD6F, 0xEF97, 0xE382,
    0xDF59, 0xD59A, 0xE250, 0xE788, 0xF14E, 0xFF29, 0x01DA, 0x0E43, 0x0F68, 0x162B, 0x1B24, 0x1426, 0x1AE5, 0x192F, 0x1752, 0x1D4D,
    0x2464, 0x26F7, 0x2131, 0x2574, 0x1FF4, 0x190F, 0x1840, 0x0A03, 0x07A2, 0x003A, 0xF887, 0xF9CD, 0xED79, 0xEF5C, 0xF090, 0xECC2,
    0xEC02, 0xE665, 0xF1FC, 0xF4F6, 0xF2E5, 0xFA99, 0xF2DB, 0xF281, 0xF618, 0xEED8, 0xEFB7, 0xEBBE, 0xEC82, 0xF0A3, 0xECD9, 0xF02F,
    0xF264, 0xFBC6, 0x020D, 0x07D7, 0x1619, 0x186C, 0x1E27, 0x1E80, 0x1594, 0x106E, 0x076D, 0x048E, 0x0353, 0x05FF, 0x0C56, 0x0756,
    0x0332, 0x02E1, 0x0603, 0x089A, 0x0169, 0x09C8, 0x1024, 0x0F6F, 0x1673, 0x1DC8, 0x2034, 0x1BA7, 0x1F7C, 0x155F, 0x0AD4, 0x03EF,
    0xFBCC, 0xF0D3, 0xE45B, 0xE0F0, 0xE2CC, 0xE302, 0xDCDD, 0xE1AA, 0xDE82, 0xDADA, 0xD7E0, 0xDB2C, 0xDFFD, 0xDCB4, 0xE6B3, 0xE374,
    0xE2CD, 0xE9E2, 0xE7E1, 0xF2B3, 0xF1D7, 0xF2FA, 0xFF20, 0xFD24, 0xF9FE, 0xFF49, 0x0BC4, 0x0670, 0x0D5A, 0x1B97, 0x1833, 0x21F6,
    0x2007, 0x1CDF, 0x174F, 0x09AC, 0x0CED, 0x0930, 0x1227, 0x1D59, 0x218B, 0x2FCA, 0x2786, 0x33CC, 0x4112, 0x31F1, 0x3E9D, 0x3B62,
    0x3759, 0x3AE9, 0x317B, 0x3336, 0x256B, 0x1E5E, 0x12F7, 0x04D7, 0x014C, 0xEDC5, 0xEA68, 0xE154, 0xD636, 0xDACE, 0xD40F, 0xD2F8,
    0xD3B2, 0xD4B4, 0xCDB7, 0xC463, 0xC713, 0xBD93, 0xBF95, 0xC530, 0xBD71, 0xC520, 0xC506, 0xC91B, 0xD03B, 0xCC9F, 0xD2D9, 0xD1D3,
    0xD5E0, 0xD3B7, 0xD4C3, 0xE037, 0xDC63, 0xEC00, 0xF51F, 0xF89E, 0x0A2C, 0x0DCE, 0x142A, 0x117D, 0x106F, 0x0F3F, 0x0B7A, 0x1590,
    0x17F3, 0x221A, 0x29EA, 0x28D5, 0x33D4, 0x3560, 0x34BC, 0x3B38, 0x3C0B, 0x3E45, 0x46F8, 0x526C, 0x4EF1, 0x532E, 0x585E, 0x4DDB,
    0x4E88, 0x45CA, 0x4188, 0x3A7F, 0x29EE, 0x246F, 0x1338, 0x09D2, 0xF703, 0xECE9, 0xEC70, 0xD7F5, 0xD849, 0xD47D, 0xCF01, 0xD1E0,
    0xD27B, 0xD9A6, 0xD8C3, 0xDD73, 0xE1CF, 0xE210, 0xE1EA, 0xD5EC, 0xDB53, 0xD31A, 0xC5BC, 0xD192, 0xCC2D, 0xCF8A, 0xD367, 0xD81B,
    0xE4C8, 0xE02D, 0xF04B, 0xF018, 0xE95B, 0xEE3C, 0xDD29, 0xDEFE, 0xDB07, 0xDA8F, 0xED17, 0xF0C9, 0xF608, 0x02EB, 0x0D95, 0x10DB,
    0x180C, 0x1CD5, 0x1CA9, 0x2524, 0x2B10, 0x31F9, 0x3375, 0x34C0, 0x38F5, 0x2FEE, 0x2E9E, 0x2848, 0x257F, 0x25E6, 0x1475, 0x1983,
    0x15FC, 0x0B32, 0x12A1, 0x0CB6, 0x0EDD, 0x0BEB, 0x0BBD, 0x0A18, 0x0297, 0x0A03, 0xFE97, 0xFC1D, 0xF55F, 0xEE5D, 0xF448, 0xE4FC,
    0xE212, 0xDCB9, 0xD71E, 0xD480, 0xCFA0, 0xD8C6, 0xD367, 0xDE1A, 0xE93B, 0xE38F, 0xF08A, 0xF3ED, 0xF94D, 0xF88A, 0xEE83, 0xF084,
    0xE6D6, 0xE9E6, 0xE9BB, 0xEE25, 0xFD84, 0xF9AF, 0x0E25, 0x1157, 0x12C1, 0x2366, 0x1AD5, 0x1D87, 0x1AFB, 0x2415, 0x2B8C, 0x2A82,
    0x3686, 0x3126, 0x362C, 0x3573, 0x2BFB, 0x2B54, 0x2246, 0x1D88, 0x12D4, 0x0913, 0x011D, 0xF97C, 0xF816, 0xE931, 0xE95A, 0xE861,
    0xDE50, 0xE441, 0xE092, 0xE36F, 0xE486, 0xE3A1, 0xECC7, 0xEC73, 0xF42F, 0xF666, 0xFCA3, 0xFAC5, 0xED18, 0xF5F1, 0xEA22, 0xE33E,
    0xE1BA, 0xE128, 0xE515, 0xDA90, 0xE831, 0xE328, 0xE011, 0xE59D, 0xD5C2, 0xDEEE, 0xDAF7, 0xDB3E, 0xEEA9, 0xE9F1, 0xF691, 0xFED2,
    0xFE0A, 0x05DC, 0x0218, 0x0EC9, 0x0C11, 0x0958, 0x174C, 0x15E7, 0x2123, 0x2227, 0x23B9, 0x2AC2, 0x2733, 0x277D, 0x1FB3, 0x1CA6,
    0x134C, 0x11AD, 0x0BD0, 0xFA1F, 0xFF17, 0xF9DC, 0xF46F, 0xF2D0, 0xEC79, 0xF04E, 0xF04C, 0xF448, 0xF6DA, 0xF331, 0xF676, 0xF63C,
    0xF831, 0xF89F, 0xF647, 0x00BA, 0xFE6A, 0xF649, 0xF64A, 0xF406, 0xF133, 0xEF89, 0xF643, 0xF74B, 0x01CC, 0x0E87, 0x1172, 0x1A5F,
    0x170E, 0x145E, 0x0A12, 0xFC7F, 0xF8CE, 0xF209, 0xF0D5, 0xEB91, 0xEF13, 0xF10C, 0xEB37, 0xF2A2, 0xF347, 0xF611, 0x0023, 0x05B7,
    0x0C72, 0x1145, 0x1814, 0x192C, 0x12B9, 0x1417, 0x0C87, 0x0D09, 0x08F2, 0xFB55, 0xFD41, 0xED9A, 0xE4AF, 0xDF17, 0xD779, 0xD6D5,
    0xCFED, 0xD2C6, 0xC975, 0xC6C2, 0xCE8E, 0xCAFE, 0xCFA3, 0xCEBF, 0xD449, 0xDC8D, 0xDA66, 0xE3F3, 0xE8FD, 0xECB9, 0xF464, 0xF4C3,
    0xF991, 0xF631, 0xFA99, 0x01E0, 0xF678, 0x0160, 0x0C0A, 0x10A0, 0x1A35, 0x1B5E, 0x1E7D, 0x1A8C, 0x11D7, 0x0BC2, 0x0F11, 0x11DD,
    0x1756, 0x1F6E, 0x24A9, 0x2D9B, 0x2E15, 0x3606, 0x3297, 0x2B1F, 0x34FE, 0x2E9D, 0x303B, 0x2EC3, 0x26DD, 0x2C4A, 0x2057, 0x1C2D,
    0x1FAC, 0x18A5, 0x1B76, 0x194F, 0x157C, 0x0D06, 0x01C7, 0xFE60, 0xEEFF, 0xEA65, 0xE3C7, 0xDBE0, 0xD90C, 0xD102, 0xD360, 0xCA5B,
    0xCBAE, 0xCA45, 0xC77C, 0xD092, 0xCA12, 0xD3E7, 0xD144, 0xCADA, 0xD597, 0xCB32, 0xCBD9, 0xCE5F, 0xD02A, 0xD476, 0xD01E, 0xDBFF,
    0xE2D4, 0xEB52, 0xF752, 0xF967, 0x004A, 0xFBAD, 0xF695, 0xF6CB, 0xF4D2, 0xFA3C, 0xFA6A, 0x05C2, 0x0A10, 0x0FDC, 0x1927, 0x114D,
    0x1CB3, 0x1E34, 0x2687, 0x31E7, 0x3318, 0x4190, 0x40FD, 0x451D, 0x429C, 0x3DE1, 0x4274, 0x38C3, 0x3866, 0x29AA, 0x1997, 0x132E,
    0xFFFE, 0xF47D, 0xE68F, 0xE451, 0xDED2, 0xD80B, 0xE0CD, 0xD9AF, 0xDC23, 0xDE69, 0xD9B3, 0xDC0F, 0xD22E, 0xDC3E, 0xDD9F, 0xD86D,
    0xE084, 0xDA52, 0xE1DD, 0xD8F7, 0xDCF6, 0xE367, 0xD5E2, 0xE572, 0xE28E, 0xE89A, 0xF384, 0xF40B, 0x0341, 0xFBF3, 0xFD5E, 0xFB0E,
    0xEEE9, 0xF537, 0xEEA3, 0xF67D, 0xFCB1, 0xFAC8, 0x0CB8, 0x12BF, 0x15E6, 0x17B7, 0x1D3F, 0x24C8, 0x261B, 0x2DBE, 0x302A, 0x35B3,
    0x35B6, 0x3331, 0x34C8, 0x2819, 0x2CA3, 0x2D0A, 0x290F, 0x25CF, 0x19DD, 0x1E96, 0x0FAA, 0x09BD, 0x074C, 0xFA81, 0xFB50, 0xF3A8,
    0xEF94, 0xEA76, 0xDFBE, 0xDA38, 0xD16F, 0xCBF5, 0xC6EF, 0xC91C, 0xCDB4, 0xCBD4, 0xD4E5, 0xD44E, 0xD48E, 0xD6EC, 0xD482, 0xD80F,
    0xD1EA, 0xD62E, 0xDBB3, 0xDDF7, 0xED5A, 0xEC1C, 0xF333, 0xF580, 0xEEAA, 0xF280, 0xE94E, 0xEBBF, 0xF046, 0xF2DF, 0xF4FB, 0xFAE3,
    0x08A7, 0x0CD5, 0x0F93, 0x130D, 0x18AE, 0x1F0A, 0x2236, 0x2A88, 0x31FF, 0x370B, 0x3BCD, 0x3B0F, 0x3D92, 0x3B2F, 0x3CDD, 0x3DFF,
    0x32AE, 0x3133, 0x2CAD, 0x239A, 0x1D7E, 0x0EBC, 0x0570, 0xFF1D, 0xFBEA, 0xF80F, 0xF6E3, 0xFCDB, 0xF87D, 0xF6CA, 0xF3C8, 0xF2E2,
    0xF56D, 0xF8AF, 0xFB22, 0xF95A, 0xFA63, 0xF572, 0xF02C, 0xE44A, 0xD8C5, 0xD604, 0xCF12, 0xCB20, 0xCECC, 0xD713, 0xE2AC, 0xE758,
    0xEBF2, 0xEAB6, 0xE534, 0xE7B2, 0xDD8E, 0xDDED, 0xDF8B, 0xDA71, 0xE6A1, 0xE8A7, 0xEC10, 0xF34E, 0xF207, 0xF918, 0xF9F0, 0x015C,
    0x074D, 0x0782, 0x1299, 0x15C1, 0x1867, 0x1892, 0x1A9B, 0x1D3E, 0x19BD, 0x1880, 0x17C3, 0x130C, 0x0E65, 0x0DA9, 0x0DA3, 0x053C,
    0x03D0, 0x033F, 0xFD64, 0x03DB, 0x0297, 0x054E, 0x05F9, 0x03E3, 0x0548, 0xFE1E, 0xFF3B, 0xFD5E, 0xFE1A, 0x0691, 0x03C3, 0x0942,
    0x089A, 0x043C, 0x055C, 0x0136, 0x0094, 0x0174, 0x0D1F, 0x146D, 0x1B0B, 0x1E30, 0x148B, 0x107D, 0x042B, 0xF71A, 0xF503, 0xEA00,
    0xEF63, 0xF4E7, 0xF8BA, 0x03FF, 0x046B, 0x13F7, 0x10FE, 0x118B, 0x1CB4, 0x199A, 0x215A, 0x2105, 0x2576, 0x2779, 0x1F4E, 0x20CC,
    0x1E18, 0x1F10, 0x14C4, 0x0EBF, 0x0D86, 0xFBF8, 0xFB86, 0xF279, 0xE9D0, 0xE5E1, 0xDB1D, 0xDB49, 0xD3BD, 0xD52A, 0xD614, 0xD024,
    0xD799, 0xD1B7, 0xD636, 0xD91F, 0xD2E0, 0xE184, 0xDC3E, 0xE271, 0xE9E7, 0xE93D, 0xF17F, 0xE8A4, 0xECF2, 0xE600, 0xDFDD, 0xEB1B,
    0xEC49, 0xFBC0, 0x0636, 0x0A40, 0x0ECA, 0x087D, 0x0BBC, 0x0AE1, 0x0854, 0x09DF, 0x11C7, 0x1D20, 0x1D20, 0x2214, 0x234F, 0x1E8C,
    0x1E01, 0x1C8C, 0x1B70, 0x1AB6, 0x238B, 0x28E5, 0x29BC, 0x2EC9, 0x2970, 0x3317, 0x33CC, 0x2D7B, 0x2DFC, 0x213F, 0x21B8, 0x183D,
    0x0DC0, 0x09C0, 0xFD9A, 0xFACB, 0xEFDA, 0xEBDC, 0xEBF2, 0xE509, 0xE927, 0xE32C, 0xE0EA, 0xE32A, 0xE2B6, 0xE19E, 0xDEDA, 0xE704,
    0xE4A6, 0xE5B5, 0xEABD, 0xE5DE, 0xEBC8, 0xE956, 0xE3F9, 0xE31B, 0xE085, 0xEC9F, 0xF475, 0xFF6C, 0x0692, 0x0A6E, 0x1250, 0x0B10,
    0x06D5, 0xFF23, 0xF9D6, 0xFC31, 0xFDF9, 0x0401, 0x09C9, 0x14AC, 0x1772, 0x182B, 0x1C39, 0x19BA, 0x273F, 0x2FF1, 0x35A1, 0x3DBE,
    0x3AF0, 0x3EFB, 0x369E, 0x2F85, 0x2B04, 0x1E3E, 0x1932, 0x0A6C, 0x028F, 0xFEC9, 0xF0E0, 0xEF4A, 0xE8BA, 0xE1CA, 0xE027, 0xE0BA,
    0xDE5B, 0xDA77, 0xDDF8, 0xD515, 0xD768, 0xD683, 0xD273, 0xD968, 0xD606, 0xDC64, 0xDC65, 0xDC65, 0xE6EB, 0xE334, 0xE8B3, 0xE33D,
    0xDF88, 0xE825, 0xE05B, 0xED70, 0xF59C, 0xFE1F, 0x0A4C, 0x0600, 0x0F0A, 0x0AA0, 0x0518, 0x0381, 0xFD45, 0x05E5, 0x038B, 0x10F3,
    0x1D0E, 0x18C0, 0x26CF, 0x28F2, 0x28E6, 0x27AD, 0x2D5F, 0x37D9, 0x373A, 0x3E2C, 0x3FC9, 0x425E, 0x4278, 0x3DE7, 0x420E, 0x3A5C,
    0x375D, 0x3B65, 0x37D6, 0x32CC, 0x277B, 0x2320, 0x1226, 0x02A8, 0xFE00, 0xEE30, 0xEBE5, 0xE5BF, 0xDED6, 0xDDB0, 0xD44C, 0xD694,
    0xD414, 0xD42A, 0xD6C1, 0xD458, 0xD9F7, 0xD398, 0xD5E2, 0xD5CF, 0xCB0F, 0xCBB5, 0xC800, 0xC974, 0xC9DF, 0xCEF0, 0xD844, 0xDBCB,
    0xE5AA, 0xE374, 0xE597, 0xE963, 0xDF32, 0xE173, 0xDE7D, 0xDD5C, 0xE818, 0xED0D, 0xF706, 0xFC42, 0x026B, 0x08A4, 0x07FC, 0x0FEF,
    0x1A3D, 0x2642, 0x2E7D, 0x33F8, 0x3F6A, 0x4377, 0x42FB, 0x41EC, 0x41BB, 0x3C6F, 0x3714, 0x380E, 0x2C4B, 0x28EE, 0x27AF, 0x18ED,
    0x1278, 0x07F4, 0x0408, 0x0872, 0x04CC, 0x07D5, 0x07C8, 0x09C8, 0x09D5, 0x00F8, 0x0074, 0xF8B1, 0xF5EA, 0xF704, 0xEDB2, 0xEE80,
    0xEF4E, 0xEB5F, 0xE784, 0xE0C6, 0xDE8A, 0xE514, 0xE9CB, 0xEE8B, 0xF79C, 0x0005, 0x0203, 0xFDB1, 0xF944, 0xF3C2, 0xEEB3, 0xEE7C,
    0xE911, 0xE2F7, 0xEAD1, 0xF248, 0xF66E, 0xF315, 0xF30A, 0xFBAE, 0x02AE, 0x011E, 0x0577, 0x0E77, 0x19B4, 0x1E50, 0x1E9E, 0x21EF,
    0x2260, 0x22BA, 0x195B, 0x1AA8, 0x18A5, 0x122A, 0x1330, 0x1107, 0x0A11, 0x0203, 0xF9D7, 0xF5E8, 0xF137, 0xEDF8, 0xE7A8, 0xE754,
    0xE3E3, 0xE658, 0xE899, 0xE19F, 0xE1CF, 0xDF83, 0xE8C5, 0xE992, 0xEDBF, 0xF725, 0xFD0C, 0x046C, 0x0190, 0xF4C2, 0xF38A, 0xF895,
    0xFC6E, 0xFAF8, 0x004E, 0x0A4A, 0x080C, 0x0729, 0x0266, 0x03AE, 0x013D, 0xF84A, 0xFC33, 0x008E, 0x0463, 0x094A, 0x07E2, 0x0A11,
    0x0D22, 0x144F, 0x0FF3, 0x11B4, 0x19B8, 0x1DEF, 0x2511, 0x1EFB, 0x2673, 0x338F, 0x2DE9, 0x268F, 0x1D04, 0x217B, 0x1883, 0x107A,
    0x12BB, 0x09B2, 0x07B7, 0xF67C, 0xF517, 0xF045, 0xE684, 0xE89B, 0xE5DF, 0xE0F4, 0xECCE, 0xE64B, 0xE7F4, 0xE40B, 0xDEBC, 0xEE74,
    0xDE43, 0xE8A2, 0xF16A, 0xEEAB, 0xEFC5, 0xF64B, 0xFAC8, 0xD9AC, 0xDAAD, 0xEE49, 0xFE0E, 0xFB9F, 0xE1E3, 0x27F0, 0x16ED, 0x0405,
    0x2002, 0x0996, 0x1A88, 0xF7C1, 0xF8EC, 0x0793, 0xF48A, 0xF5BF, 0xF4AF, 0x06EF, 0x0C06, 0xF331, 0xFE6F, 0x14A9, 0x1115, 0x1477,
    0x1B68, 0x1D25, 0x2976, 0x1D0D, 0x2646, 0x2638, 0x19E3, 0x0818, 0x164B, 0x1DA1, 0x01CF, 0x07B1, 0xFF76, 0xF949, 0xE7C9, 0xFDD4,
    0xE873, 0xDE62, 0xE7FB, 0xE90D, 0xE7A7, 0xE7B2, 0xE9CD, 0xE4BA, 0xEEE1, 0xE3B4, 0xF018, 0xE80E, 0xF76C, 0xEB52, 0xF6B4, 0xFB5C,
    0xF185, 0xF563, 0xDDC7, 0x0285, 0xFEE3, 0xFBD4, 0x046B, 0x1833, 0x1D36, 0x0FD4, 0x113F, 0x0ECA, 0x0DC3, 0xFA4F, 0x0BB2, 0x1104,
    0x1530, 0x142A, 0x30D2, 0x29C4, 0x17DE, 0x35A5, 0x2C2C, 0x3939, 0x324D, 0x314D, 0x3793, 0x285A, 0x3560, 0x28E6, 0x1639, 0x21E3,
    0x203A, 0x093F, 0x0ED8, 0x21F5, 0xFB33, 0xF9A7, 0xED56, 0xEC5F, 0xE588, 0xD195, 0xDD6E, 0xCFA3, 0xC8BF, 0xC70D, 0xDA23, 0xCA46,
    0xD0E0, 0xBE62, 0xE38D, 0xCD0B, 0xB9A9, 0xE56C, 0xCD50, 0xE690, 0xD122, 0xD714, 0xDA23, 0xD758, 0xD1BA, 0xE1D0, 0xDDE9, 0xE033,
    0xF85C, 0x05FC, 0xFF46, 0xF791, 0x0EAF, 0xF919, 0xFD03, 0x05FE, 0x0BE2, 0xFEB7, 0x152C, 0x1DC8, 0x125D, 0x2405, 0x2190, 0x1EF8,
    0x2F3D, 0x2DB5, 0x344E, 0x4196, 0x4531, 0x3E6B, 0x4CE0, 0x579F, 0x4913, 0x45D5, 0x49A5, 0x480D, 0x3489, 0x3C39, 0x2627, 0x2515,
    0x0887, 0x0539, 0x0C58, 0xF162, 0xF218, 0xED93, 0x0788, 0xE11E, 0xE746, 0xF822, 0xE3EF, 0xE04C, 0xEB1C, 0xF2BF, 0xCBB0, 0xF3E9,
    0xE791, 0xDB79, 0xE6EC, 0xE133, 0xD2D4, 0xDFED, 0xE725, 0xC349, 0xE96C, 0xE383, 0xE4DF, 0xF198, 0xEC47, 0xEEBC, 0xEB80, 0xDF89,
    0xF4A0, 0xE729, 0xDD93, 0xEE70, 0xF090, 0xF831, 0x02F2, 0xFA1A, 0xFA8A, 0x05DA, 0x0DA8, 0x0C75, 0x1847, 0x1ED6, 0x15EB, 0x3336,
    0x2375, 0x30FC, 0x149A, 0x2308, 0x1B08, 0x13FF, 0x1740, 0x11AA, 0x12FB, 0x07C2, 0x019D, 0x07ED, 0x125D, 0xF408, 0x1545, 0xF461,
    0xF2BF, 0xEABF, 0xFE41, 0xF7B8, 0xDCB3, 0xE777, 0xF2D2, 0xF667, 0xECD8, 0xF120, 0xE862, 0xF909, 0xF12A, 0xFB5F, 0xF7C9, 0xDFB8,
    0xEB4D, 0x05A6, 0xF2CA, 0xF0B4, 0x046B, 0x04F9, 0x0471, 0x068F, 0xECCE, 0xFB54, 0xFAFA, 0xF443, 0xF136, 0xFCE1, 0x0751, 0xF90A,
    0x06FE, 0x02AD, 0x0D0B, 0xFFA0, 0x12E5, 0x17C9, 0x0E99, 0x1C29, 0x296E, 0x2BC5, 0x2CF3, 0x2910, 0x2AE7, 0x2EE6, 0x187E, 0x0B5A,
    0x28D6, 0x2169, 0x0E88, 0x10E2, 0x0273, 0xFD9F, 0x0D7E, 0xFC84, 0xE4CC, 0xF84F, 0xEF3F, 0xEAAE, 0xE20C, 0xFE09, 0xECB1, 0xEFBE,
    0xFA07, 0xF313, 0x1154, 0x0816, 0xE4C1, 0xFC3C, 0xEE83, 0xE2F1, 0xECA0, 0xD072, 0xE7A3, 0xDEE8, 0xE685, 0xEB49, 0xFB66, 0xE428,
    0xFB77, 0xF45E, 0xEB65, 0xF7FD, 0xE727, 0xFA5A, 0xF3A0, 0xF29B, 0xF729, 0x0272, 0xFF70, 0x0B65, 0xF732, 0x0CC1, 0x102A, 0x1BD2,
    0x1E1E, 0x0D5E, 0x36C5, 0x231D, 0x2053, 0x372B, 0x20F8, 0x2C07, 0x18BB, 0x1E7C, 0x1D1F, 0xFB65, 0x13A4, 0x0CC0, 0x0CEC, 0xFC66,
    0xEB74, 0xF897, 0xFB81, 0xE963, 0xE8AC, 0xEA69, 0xFAE9, 0xE45A, 0xF50A, 0x047E, 0xDAB8, 0xF6BB, 0x002B, 0xFF62, 0xFDA8, 0xF876,
    0xF98A, 0x0032, 0x046F, 0xEFB6, 0x0FBE, 0x19F6, 0x0A4F, 0x22F1, 0x1EC0, 0x18BE, 0x15F5, 0x06A2, 0xFE6A, 0x0436, 0xEA97, 0xFBA2,
    0xF32C, 0xE367, 0x0324, 0xF1CA, 0xFA95, 0x0323, 0x03C8, 0x0A74, 0x04D7, 0x1146, 0x0EFE, 0x17FB, 0x1933, 0x1A0A, 0x12C5, 0x20FE,
    0x1686, 0x04BE, 0x1CA8, 0xF4CA, 0x0D65, 0xEF89, 0xFD75, 0xF996, 0xDAA4, 0xED4F, 0xD936, 0xEBB6, 0xDA63, 0xD1A8, 0xD1D2, 0xE3BC,
    0xC3CE, 0xDF0B, 0xD11E, 0xD568, 0xE2A3, 0xD7DF, 0xF156, 0xE2E2, 0xF286, 0xE95C, 0xFEE1, 0xE7D2, 0xF410, 0xFDA7, 0x04C3, 0x0182,
    0x0D11, 0x1A77, 0x17A1, 0x1DCF, 0x1D2B, 0x1A24, 0x18F3, 0x2CB0, 0x1DEB, 0x25EB, 0x2C8C, 0x2FC0, 0x28C2, 0x241B, 0x2883, 0x2F54,
    0x13BD, 0x3276, 0x1840, 0x283D, 0x2D67, 0x207A, 0x2F41, 0x1BA8, 0x41E4, 0x27C8, 0x2D7B, 0x2679, 0x242C, 0x2233, 0x11A2, 0x0BFD,
    0x07A1, 0x0218, 0xF9BF, 0xEB6A, 0xEC44, 0xE66C, 0xE756, 0xDB01, 0xD65B, 0xE12A, 0xCF5E, 0xDABA, 0xD5C9, 0xD7BD, 0xCD1E, 0xD586,
    0xDB5D, 0xCAA2, 0xD9F9, 0xDBAF, 0xCA66, 0xCFF3, 0xE1EF, 0xCCC2, 0xDF0A, 0xE5C3, 0xE0B6, 0xEE83, 0xF07E, 0xFA4D, 0xE552, 0x03D6,
    0xEE5B, 0xE82C, 0xF92C, 0xECEA, 0xF1BF, 0xE836, 0xEC3F, 0xF342, 0xEFB2, 0xEDE9, 0xF632, 0x08D1, 0x1BBF, 0x0E61, 0x1CF6, 0x2D36,
    0x29A7, 0x20F1, 0x3579, 0x2552, 0x1D9D, 0x200A, 0x1112, 0x12C9, 0x16A1, 0x0479, 0x00E1, 0x01C4, 0xFF9C, 0x0214, 0xF59F, 0xFCBE,
    0xF202, 0xF322, 0xEE61, 0xF5DC, 0xE4E8, 0xE5C0, 0xF78E, 0xE933, 0xE219, 0xF341, 0xEC18, 0xF6B5, 0xE967, 0xEC59, 0xEA2B, 0xE6D5,
    0xF110, 0xE8C4, 0xEFCF, 0xEC55, 0xFC80, 0xF412, 0x05CE, 0xFA22, 0xFD97, 0xF3A5, 0xEE5A, 0xF991, 0xFB75, 0xE361, 0x019A, 0xF60A,
    0xF753, 0x0716, 0xF88D, 0x1841, 0x0329, 0x1AF4, 0x14E5, 0x1DBD, 0x215B, 0x2850, 0x1E53, 0x2655, 0x2E2E, 0x20FF, 0x22DD, 0x3119,
    0x2712, 0x17B0, 0x25E1, 0x1314, 0x0ED6, 0x0B4E, 0x05E5, 0xECE3, 0xEFA1, 0xF373, 0xE2E5, 0xD0B8, 0xD987, 0xD640, 0xD55F, 0xD127,
    0xD6E6, 0xD615, 0xD7D0, 0xEB49, 0xDF32, 0xDBC1, 0xD8CF, 0xE963, 0xE47B, 0xE0F7, 0xE4B7, 0xE879, 0xDCB9, 0xF7C1, 0xF338, 0xEA73,
    0x0419, 0x04A1, 0xFB51, 0xFBBF, 0x07EB, 0x0AA4, 0xF50A, 0xFD75, 0x0ED6, 0xF379, 0x07C4, 0xFDB8, 0x077E, 0x064B, 0x0885, 0x0B57,
    0x0AEA, 0x10FF, 0x2B03, 0x1EDA, 0x1551, 0x3B50, 0x2471, 0x2796, 0x2E0D, 0x2B14, 0x254B, 0x1E60, 0x2257, 0x1182, 0x0235, 0x0AA5,
    0xEEF8, 0xF45D, 0xF87A, 0xF121, 0xF0A3, 0xF8DF, 0xF659, 0xF212, 0xEB87, 0xF20F, 0xF3D5, 0xEF3F, 0xF1C5, 0xE733, 0xF40F, 0xDB8D,
    0xE4E4, 0xDEFC, 0xD2BD, 0xE607, 0xDF99, 0xE19D, 0xF21C, 0xEDC2, 0xF5D3, 0xFB81, 0xFA46, 0xFCA3, 0xFA50, 0xF7F9, 0xFCC6, 0xEA54,
    0xEC87, 0xF37C, 0xEBD5, 0xF38B, 0xED4C, 0xF4A2, 0xF3B6, 0xFD2C, 0xF594, 0xFA32, 0x039B, 0x04E3, 0x0149, 0x073C, 0x060C, 0x1451,
    0x0F79, 0x097B, 0x06F5, 0x04CA, 0x040F, 0xF808, 0xFCA0, 0xF157, 0xF8A1, 0xF08E, 0xFA37, 0xF002, 0xF28A, 0xED22, 0xF7EE, 0xEF32,
    0xEDE5, 0xF4ED, 0xE6F3, 0xF355, 0xF0CD, 0x001D, 0xF4C0, 0x0B40, 0x1403, 0x0ED2, 0x1670, 0x0874, 0x15B6, 0x1096, 0x0988, 0x1A66,
    0x1714, 0x150E, 0x15BE, 0x1EE3, 0x0644, 0x1106, 0x15B4, 0x017F, 0x0E47, 0x0C3D, 0x0F9E, 0x0302, 0x070F, 0x0A64, 0x1325, 0x066D,
    0x1055, 0x20C4, 0x117E, 0x1C03, 0x19FA, 0x1057, 0x0F3A, 0x187D, 0x1746, 0x1A6E, 0x1A5A, 0x1F5C, 0x1652, 0x1025, 0x1C2E, 0x0743,
    0x0516, 0x0388, 0xF47C, 0xEF8E, 0xF44D, 0xE94E, 0xDE19, 0xDFEF, 0xDABB, 0xDDB4, 0xD857, 0xCC52, 0xD3FB, 0xDC55, 0xD335, 0xDE52,
    0xD54D, 0xDFB9, 0xE904, 0xDF87, 0xDEC9, 0xD364, 0xDFBD, 0xD83A, 0xD6EB, 0xE2D8, 0xE7DE, 0xED0A, 0xF154, 0xFED9, 0xFD02, 0xF56B,
    0x0612, 0x087A, 0xFD07, 0x0004, 0x0AB8, 0x009D, 0xFD44, 0x0275, 0x03A7, 0x0498, 0x0ADA, 0x15DB, 0x1449, 0x1F4D, 0x2066, 0x27E3,
    0x27E4, 0x2C4F, 0x3665, 0x30D6, 0x33E2, 0x31FB, 0x2C3F, 0x2648, 0x1C9F, 0x0EF4, 0x0B66, 0x07BC, 0x0427, 0xFFC8, 0xF219, 0xF4A2,
    0xF408, 0xE224, 0xE992, 0xE3FA, 0xDD71, 0xDEC8, 0xDBF9, 0xE983, 0xD8EF, 0xE7E8, 0xE8B3, 0xEB53, 0xECAB, 0xE26E, 0xE862, 0xEC3A,
    0xE938, 0xE571, 0xF65D, 0xF331, 0x0B8B, 0x052B, 0x0186, 0x084F, 0x0541, 0x010B, 0xFF7B, 0x004B, 0xFA5A, 0x0285, 0x074F, 0x075C,
    0x0A4F, 0x0E1F, 0x19F2, 0x1865, 0x1E15, 0x2A11, 0x1BF0, 0x2B0E, 0x2F1B, 0x26ED, 0x25C6, 0x228A, 0x216F, 0x2882, 0x1ACC, 0x236E,
    0x1CD9, 0x1195, 0x11B7, 0x0598, 0x02E1, 0x01AC, 0x0251, 0xF3D5, 0xF7EA, 0xF4FF, 0xF3AA, 0xE525, 0xEADA, 0xE2F3, 0xDE84, 0xDEF9,
    0xCD56, 0xE3EE, 0xE00D, 0xE20A, 0xE7C9, 0xE908, 0xF06A, 0xEA8A, 0xED04, 0xEDC1, 0xED2A, 0xF0D3, 0xF23E, 0xFF20, 0x028A, 0x021E,
    0x0B08, 0xFDC3, 0xFC17, 0xFEF3, 0x01F6, 0xFC3B, 0xFD20, 0x0B99, 0x0D24, 0x05C1, 0x04F6, 0x0ECA, 0x096D, 0x15C9, 0x122E, 0x192E,
    0x1BEB, 0x1A58, 0x2CD2, 0x1EA3, 0x2649, 0x2D19, 0x2FCD, 0x3251, 0x2F0F, 0x3054, 0x2869, 0x21D8, 0x19AE, 0x101A, 0x0582, 0x003B,
    0xF117, 0xF260, 0xF261, 0xE40B, 0xE4D5, 0xE491, 0xDB29, 0xDCA1, 0xD96B, 0xD410, 0xDE86, 0xE305, 0xE939, 0xE75B, 0xE76C, 0xE35A,
    0xE50B, 0xE487, 0xDE18, 0xDC77, 0xDEFC, 0xDE99, 0xE178, 0xED0F, 0xEC51, 0xEA3B, 0xE9AB, 0xEFDB, 0xEAA7, 0xE60A, 0xE1B3, 0xE593,
    0xE8E8, 0xE106, 0xE905, 0xE7A4, 0xE0AE, 0xEF0C, 0xEDEF, 0xE51C, 0xF2E0, 0xFFDA, 0x08AE, 0x09CD, 0x1635, 0x1F58, 0x227D, 0x2339,
    0x25B5, 0x27D1, 0x267E, 0x2A83, 0x2534, 0x232F, 0x1812, 0x1D59, 0x20E5, 0x1C0F, 0x1BE8, 0x1E3A, 0x21BB, 0x1EAF, 0x1A31, 0x1033,
    0x0DC4, 0x04C7, 0x028B, 0xFC88, 0xF97C, 0x009E, 0x01F9, 0xF9BF, 0xFC05, 0xFEB8, 0xF797, 0xF92A, 0xED83, 0xF7CC, 0x02FA, 0x007A,
    0x0492, 0x0710, 0x0B65, 0x0CC7, 0x0ED9, 0x02D8, 0x0B36, 0x089B, 0xFDF0, 0x005A, 0xF378, 0xF736, 0xF7D7, 0xF7BE, 0xFD13, 0xFEE5,
    0xFE0C, 0x07DF, 0x02D4, 0x0879, 0x1675, 0x108C, 0x14E8, 0x1776, 0x1941, 0x1332, 0x1477, 0x1557, 0x136D, 0x0C4B, 0x0D0C, 0x0D57,
    0x0279, 0x02EE, 0xF4FF, 0xED7E, 0xEA36, 0xE0CB, 0xE305, 0xE1C1, 0xDAEC, 0xD9EA, 0xD53B, 0xCDCF, 0xD38A, 0xD40B, 0xDA2E, 0xE28F,
    0xE677, 0xE7DF, 0xEBF5, 0xF3A3, 0xE978, 0xE4A5, 0xED35, 0xED7D, 0xE78A, 0xF152, 0xFDE6, 0xFBBC, 0x0242, 0x065C, 0x0123, 0x05B2,
    0x033E, 0x0B9B, 0x0E15, 0x0887, 0x0E4B, 0x0E9B, 0x0D84, 0x1209, 0x0942, 0x09EF, 0x0F29, 0x138A, 0x1648, 0x1263, 0x1DA1, 0x17CE,
    0x1DA4, 0x2A33, 0x1E85, 0x237E, 0x2B87, 0x215F, 0x28B5, 0x1E63, 0x1CAF, 0x154F, 0x0C83, 0x0F68, 0x0141, 0xFB95, 0xF151, 0xF6BC,
    0xF5C0, 0xEF2D, 0xED73, 0xEA47, 0xEA3E, 0xE86D, 0xE6C8, 0xE03E, 0xE489, 0xE6A6, 0xE73D, 0xE9EE, 0xE1A0, 0xE48D, 0xE876, 0xE047,
    0xDF6D, 0xE883, 0xF158, 0xFFE1, 0x05B0, 0x16E8, 0x1557, 0x0ED8, 0x1794, 0x11AF, 0x0D3D, 0x0F08, 0x0895, 0x06C7, 0x0612, 0xFA2D,
    0x03FC, 0xF6C2, 0xFC09, 0xFF0D, 0xFAA9, 0x0542, 0x09A2, 0x105D, 0x114E, 0x1830, 0x1AD4, 0x171E, 0x1BE9, 0x25EE, 0x1DE4, 0x2157,
    0x1CA4, 0x13A7, 0x163C, 0x06C6, 0xFFA1, 0x0074, 0xF325, 0xF96A, 0xF17C, 0xF96D, 0xF481, 0xEE43, 0xFB40, 0xF009, 0xE9E0, 0xEC7A,
    0xEB25, 0xE65C, 0xEF74, 0xE2EA, 0xF39C, 0xEDAD, 0xEF77, 0xF0C3, 0xEF17, 0xEBEA, 0xED31, 0xF6D3, 0xE99E, 0xF993, 0xF6EC, 0x02D2,
    0x02B1, 0xFD26, 0x0090, 0x050E, 0x06E4, 0x0802, 0x0733, 0x0DE7, 0x11B6, 0x10D8, 0x0DFC, 0x0B43, 0x0F00, 0x0EE7, 0x0F51, 0x0CE2,
    0x11D6, 0x13B9, 0x173A, 0x179A, 0x12D0, 0x13B5, 0x1D8B, 0x16B1, 0x1BBD, 0x170B, 0x147F, 0x17B3, 0x17F2, 0x0E4E, 0x06F6, 0x037A,
    0xFB18, 0xF640, 0xF394, 0xF506, 0xEC30, 0xE946, 0xDED2, 0xE161, 0xD628, 0xD53A, 0xD1D2, 0xD71C, 0xD591, 0xD82C, 0xDE23, 0xD81B,
    0xDD31, 0xD750, 0xDCE7, 0xCF8C, 0xCF6E, 0xD848, 0xDB15, 0xDDD1, 0xDCCD, 0xE8F1, 0xF0BD, 0xEFAA, 0xF61B, 0xF30F, 0xF517, 0xF94E,
    0xFE8A, 0x0082, 0xFBC1, 0xF924, 0x0411, 0x0210, 0x0089, 0x047B, 0x09E9, 0x1DCF, 0x235C, 0x3724, 0x388B, 0x3F39, 0x4995, 0x4F68,
    0x4E3C, 0x4B85, 0x523C, 0x4E99, 0x4571, 0x44CC, 0x3B59, 0x3061, 0x26AD, 0x1AAD, 0x14A3, 0x0C2B, 0x098E, 0xFDFE, 0xFE05, 0xF19D,
    0xED35, 0xEFB0, 0xE8F3, 0xE428, 0xE6CA, 0xDF84, 0xE4A4, 0xE808, 0xE039, 0xEC12, 0xDFAC, 0xE5AA, 0xE347, 0xE2C6, 0xE703, 0xE2B9,
    0xF2BC, 0xECA6, 0xF381, 0xFC4C, 0xF965, 0x02E8, 0x0365, 0x013F, 0x0174, 0xF8E8, 0xFBD3, 0xF219, 0xEF17, 0xED39, 0xE90A, 0xF48C,
    0xECD5, 0xF434, 0xFC79, 0x0592, 0x04B3, 0x0441, 0x02A8, 0x0545, 0x0382, 0x0A5E, 0x0C4A, 0x0B71, 0x1972, 0x153B, 0x1D76, 0x1672,
    0x162C, 0x0EC6, 0x02BD, 0x0459, 0x03A9, 0xFAB2, 0xFCF8, 0xFD59, 0xF663, 0xF5EC, 0xEE79, 0xEAC2, 0xE466, 0xE13F, 0xE591, 0xE3A5,
    0xE5B9, 0xEB84, 0xE731, 0xF3C2, 0xE34E, 0xE51B, 0xE8F6, 0xE0E0, 0xF0B4, 0xF023, 0xFEBC, 0xFD9A, 0x05C0, 0x0BCC, 0x09EA, 0x0CAA,
    0x0C3C, 0x0A6C, 0x0C47, 0x06D6, 0x0578, 0x0A3E, 0xFD84, 0x0BBC, 0x025C, 0x000E, 0x0881, 0x0430, 0x0C07, 0x0C8E, 0x0CA9, 0x106F,
    0x162C, 0x1B73, 0x1854, 0x1C39, 0x1CF9, 0x209B, 0x25FE, 0x2025, 0x24A5, 0x1B25, 0x148E, 0x0CA6, 0xFAF6, 0xF62D, 0xF29F, 0xEA39,
    0xF04C, 0xF119, 0xEB63, 0xEFBD, 0xF0A4, 0xF1A4, 0xF044, 0xEBC4, 0xF2DB, 0xF912, 0xFF3B, 0xFACB, 0xF886, 0xF6FC, 0xE93C, 0xEEF8,
    0xE2F1, 0xDE94, 0xDE95, 0xDFE5, 0xF059, 0xEC30, 0xEB32, 0xF6B8, 0xF93B, 0xF8A7, 0xF9AA, 0xF7F6, 0xF9C1, 0xF7CF, 0xFE52, 0xF9DC,
    0xF8FD, 0x0218, 0xFBAD, 0xFF38, 0xFB40, 0xFC13, 0x00CF, 0xFE98, 0x0A4D, 0x105D, 0x15EE, 0x1FEE, 0x2701, 0x2CDC, 0x2D4B, 0x2C30,
    0x33C0, 0x310A, 0x2B4E, 0x2BE8, 0x1EDD, 0x191E, 0x127D, 0x09D8, 0x0823, 0x01F1, 0x05BD, 0x03A6, 0x02E0, 0xFF00, 0xF1F0, 0xF413,
    0xE4B9, 0xDF55, 0xE2CB, 0xDE97, 0xF0FB, 0xF6BF, 0xF371, 0xF883, 0xF47A, 0xF5F3, 0xF668, 0xF3A6, 0xF67F, 0xF859, 0x074A, 0x08C2,
    0x0182, 0x0AD6, 0x0516, 0x025B, 0x0473, 0xFA62, 0xFF5D, 0xFC7A, 0xFA2E, 0xFE91, 0xF7D1, 0xFA34, 0xF9E8, 0xFBB5, 0x001A, 0x0305,
    0x0687, 0x07C4, 0x15D5, 0x1C1F, 0x1931, 0x2102, 0x26B4, 0x2295, 0x2397, 0x1F00, 0x21CC, 0x1E35, 0x191A, 0x196B, 0x0C95, 0x07B2,
    0xFAAA, 0xF78B, 0xF249, 0xE4B9, 0xE24C, 0xDEB6, 0xDA7A, 0xD35A, 0xC9A5, 0xCE1C, 0xC7B5, 0xCA7A, 0xCF74, 0xD018, 0xDDD0, 0xDD25,
    0xE551, 0xE54E, 0xDB87, 0xDAD1, 0xDAC8, 0xD9EE, 0xDDC4, 0xE45F, 0xEF58, 0xF6D0, 0x02E2, 0x0C12, 0x1294, 0x16D9, 0x19BE, 0x23BB,
    0x290A, 0x2A2F, 0x2EAA, 0x318C, 0x28DB, 0x2A68, 0x2379, 0x1E15, 0x2066, 0x1D7F, 0x22D8, 0x1F96, 0x1F66, 0x24FF, 0x2740, 0x2EE9,
    0x2E29, 0x3037, 0x33F4, 0x335A, 0x3A18, 0x320B, 0x2D17, 0x29CA, 0x21AE, 0x222E, 0x16A1, 0x109B, 0x0C29, 0x0495, 0xFE21, 0xF429,
    0xF081, 0xE501, 0xDF37, 0xE221, 0xDADC, 0xD929, 0xD919, 0xE331, 0xE6AB, 0xE2B4, 0xE584, 0xE2DF, 0xDE77, 0xDB07, 0xDAB2, 0xD63C,
    0xDDE1, 0xE0A4, 0xE74F, 0xEE23, 0xEFEB, 0xF373, 0xF2F0, 0xEFB9, 0xEC5D, 0xE788, 0xE322, 0xE7CC, 0xE896, 0xEB6B, 0xED82, 0xF466,
    0xF836, 0xFAE5, 0x016B, 0x046C, 0x0F38, 0x151B, 0x14DD, 0x1E0D, 0x20AD, 0x1FAF, 0x1F8F, 0x20E7, 0x1D67, 0x1FB9, 0x1E52, 0x1A8D,
    0x1711, 0x0C5E, 0x0A98, 0x05DC, 0x03CB, 0xFC56, 0xFD77, 0xF849, 0xF68F, 0xF7F2, 0xF598, 0xF34C, 0xEC9C, 0xF3A5, 0xEFB1, 0xEF4E,
    0xEC91, 0xEF4F, 0xF3DC, 0xF30A, 0xF219, 0xEC84, 0xEBAA, 0xE857, 0xEC2F, 0xEC18, 0xEC9D, 0xEC5D, 0xFA80, 0xFC56, 0xFBFB, 0xFC62,
    0xF546, 0xFC15, 0xF8DF, 0xF920, 0xF899, 0x009A, 0x0249, 0x01EC, 0x05B3, 0xFE46, 0xFC9C, 0xFFE1, 0xFA70, 0xFC87, 0xFE3B, 0xFD2E,
    0x074C, 0x1068, 0x110B, 0x1831, 0x1FE8, 0x279D, 0x2D9A, 0x3172, 0x33DA, 0x3815, 0x36D3, 0x2FF8, 0x3209, 0x22E6, 0x1C73, 0x1546,
    0x0D3A, 0x057D, 0xFC49, 0xF44D, 0xF2B0, 0xE773, 0xE019, 0xDD2E, 0xD96D, 0xDCA1, 0xD9E3, 0xDEF1, 0xE091, 0xE198, 0xE225, 0xE377,
    0xDC76, 0xDCF6, 0xDFC9, 0xE0CA, 0xE3C5, 0xEA45, 0xEDFF, 0xF429, 0xF84B, 0xF857, 0xF773, 0xFAC9, 0xF8DE, 0xF9A2, 0x02F7, 0x0249,
    0x054F, 0x0722, 0x0B11, 0x0C4B, 0x0A1C, 0x06B6, 0x0CC8, 0x10E7, 0x1392, 0x1D26, 0x23AE, 0x255E, 0x2DAC, 0x2EBA, 0x2AC4, 0x2FB2,
    0x2C3D, 0x2964, 0x285D, 0x2275, 0x1BA8, 0x136C, 0x159C, 0x0F28, 0x0B93, 0x0DB5, 0x09C8, 0x0E69, 0x084C, 0x0455, 0x0476, 0xFBE9,
    0xF537, 0xF138, 0xEBE1, 0xEBCE, 0xE817, 0xE928, 0xE78B, 0xE56E, 0xE278, 0xD9AF, 0xD927, 0xD9A9, 0xD56A, 0xD8A3, 0xDB90, 0xE133,
    0xE8FA, 0xECC6, 0xF536, 0xF62C, 0xFA9F, 0xFF30, 0xFD63, 0x006B, 0xFEAC, 0xFADC, 0x018C, 0xF58D, 0xF866, 0xFA4C, 0xF46B, 0xF839,
    0xF297, 0xF464, 0xFB10, 0x0088, 0xFFF6, 0x0498, 0x0A0F, 0x0792, 0x087E, 0x0960, 0x0234, 0x0BF7, 0x0BF4, 0x0AA9, 0x103A, 0x036A,
    0x05C3, 0x0566, 0xF9DF, 0xF798, 0xF409, 0xF03D, 0xEC30, 0xEB6C, 0xE78D, 0xE0A7, 0xE026, 0xDE90, 0xE70C, 0xEEBF, 0xECC4, 0xF867,
    0x0197, 0x0395, 0x075D, 0x04C7, 0x06BE, 0x0801, 0x0717, 0x0C12, 0x09D6, 0x076D, 0x0F8B, 0x12B9, 0x1359, 0x0ED1, 0x0F0A, 0x1052,
    0x0F9F, 0x1241, 0x0CDC, 0x0D8D, 0x115D, 0x0FB4, 0x146E, 0x1232, 0x166C, 0x1941, 0x14A8, 0x1B85, 0x1DDA, 0x1E7F, 0x2329, 0x2A48,
    0x2BFE, 0x2726, 0x2551, 0x26E2, 0x1E59, 0x213D, 0x18B8, 0x16E4, 0x14F9, 0x077D, 0x07F8, 0xFCA9, 0xF3E2, 0xF1CA, 0xEE3B, 0xE872,
    0xE795, 0xE706, 0xE5C8, 0xE165, 0xDBB5, 0xD76A, 0xD843, 0xDAD7, 0xD660, 0xD993, 0xD98E, 0xD1F7, 0xD40A, 0xCB7E, 0xCA35, 0xC925,
    0xCBD1, 0xD905, 0xDE15, 0xE3D1, 0xEED3, 0xF704, 0xFE35, 0xFF58, 0xFC96, 0x02DC, 0xFD70, 0x0020, 0xFE25, 0xF7A9, 0xF7BB, 0xF862,
    0xFA8C, 0xF7A9, 0xF8BA, 0xFA4A, 0xF4C8, 0x0239, 0x0798, 0x05E9, 0x127A, 0x13B0, 0x228C, 0x2798, 0x22A1, 0x3151, 0x30F0, 0x2E94,
    0x3108, 0x2E3E, 0x295B, 0x205D, 0x2169, 0x15D9, 0x1023, 0x0E02, 0x012F, 0x07F4, 0xFFCA, 0xF554, 0xF955, 0xEC42, 0xE83D, 0xE63A,
    0xDEAC, 0xE0D7, 0xE355, 0xE02A, 0xE4F8, 0xE40A, 0xE756, 0xE3EC, 0xE465, 0xE6F1, 0xE152, 0xEC1C, 0xE970, 0xED81, 0xF238, 0xEF0A,
    0xEFCA, 0xF14F, 0xF08E, 0xF3C8, 0xF146, 0xF8AA, 0xFBE5, 0xFF65, 0x0492, 0x03C2, 0x0EB2, 0x11DB, 0x1597, 0x19A4, 0x1887, 0x2049,
    0x23C0, 0x2449, 0x269A, 0x2490, 0x2936, 0x25F8, 0x27EC, 0x26C8, 0x20C7, 0x1E01, 0x1D08, 0x1436, 0x12DA, 0x082B, 0x0010, 0x0367,
    0xFEBE, 0xF851, 0xF2A7, 0xF402, 0xED00, 0xE79E, 0xE552, 0xDF55, 0xDDFD, 0xE033, 0xDDFE, 0xE644, 0xDF46, 0xDE9C, 0xEA00, 0xE3C3,
    0xE265, 0xE35E, 0xDD41, 0xE2A8, 0xE2E6, 0xE815, 0xF025, 0xF6FF, 0x02B2, 0x03E7, 0x0DA7, 0x0E4C, 0x0E97, 0x1101, 0x0A63, 0x12A1,
    0x0C76, 0x04C3, 0x0CEF, 0x0191, 0x033F, 0x016D, 0xF869, 0xFF14, 0xFD50, 0x0686, 0x0F51, 0x119A, 0x200A, 0x25F5, 0x3238, 0x345D,
    0x39F8, 0x3D7D, 0x3757, 0x38EA, 0x2DF3, 0x25DA, 0x22FB, 0x13F7, 0x0EC9, 0x0A97, 0xFE5B, 0xFDA5, 0xF40A, 0xEF7B, 0xE9E7, 0xE3E9,
    0xE0B0, 0xDF98, 0xDBE8, 0xDB4B, 0xE102, 0xE61F, 0xE1D8, 0xE704, 0xE8A2, 0xE35C, 0xE4F1, 0xE1A6, 0xDF04, 0xDF4B, 0xDE8B, 0xE24F,
    0xEADC, 0xEA26, 0xF1F9, 0xF12C, 0xF826, 0xF588, 0xF053, 0xEDBF, 0xE904, 0xECBC, 0xEA81, 0xE809, 0xEB95, 0xED14, 0xF08B, 0xF3A9,
    0xF1AB, 0xF6BD, 0xF707, 0x00BD, 0x07DC, 0x072D, 0x0AA0, 0x0AFB, 0x129F, 0x1695, 0x1219, 0x1724, 0x1859, 0x1C16, 0x1AEA, 0x193A,
    0x1B71, 0x1709, 0x1C92, 0x1A55, 0x1705, 0x1AFE, 0x1259, 0x145A, 0x1255, 0x06EF, 0x06D5, 0x0377, 0xFE1E, 0x008C, 0xFCF8, 0xFA4E,
    0xFC5B, 0xFA90, 0xF5EB, 0xF5B5, 0xF4CB, 0xEFF4, 0xF403, 0xF230, 0xF3B5, 0xFC3B, 0x01F1, 0x05F7, 0x0ECB, 0x0795, 0x0DD0, 0x0FDF,
    0x0B08, 0x0B64, 0x09DF, 0x0B00, 0x0896, 0x0BAE, 0x074A, 0x0404, 0x0069, 0xFF97, 0xFCB7, 0xFB48, 0xF546, 0xFC5D, 0x0791, 0x0A98,
    0x0F51, 0x1542, 0x1D8C, 0x241D, 0x2167, 0x2470, 0x2234, 0x1F8A, 0x18CF, 0x125D, 0x0E7E, 0xFF98, 0xF95C, 0xF407, 0xF16B, 0xE6A8,
    0xE105, 0xDB0D, 0xD9DD, 0xD450, 0xD675, 0xD624, 0xD95F, 0xE4E3, 0xE4BC, 0xED7A, 0xE902, 0xE871, 0xE8D1, 0xE2DB, 0xE34C, 0xDED5,
    0xDE2B, 0xDE0D, 0xE288, 0xE49D, 0xE451, 0xEB31, 0xEF58, 0xF1AF, 0xF645, 0xF9BD, 0xFA24, 0x0191, 0xFF0B, 0x040F, 0x0863, 0x0A9E,
    0x115E, 0x0F94, 0x1180, 0x1409, 0x1790, 0x15DB, 0x19A4, 0x2012, 0x23E4, 0x2DAA, 0x2D6E, 0x3140, 0x3646, 0x34FC, 0x3114, 0x2EEE,
    0x2805, 0x223A, 0x1E97, 0x15D1, 0x17B4, 0x0A8E, 0x043A, 0x0612, 0x01BD, 0xF9A1, 0xF8EB, 0xF34E, 0xED93, 0xE927, 0xDFDB, 0xE0BA,
    0xDB8C, 0xD852, 0xD955, 0xDE37, 0xDB30, 0xD8D4, 0xDBD5, 0xD8E8, 0xDEBD, 0xDF3F, 0xDFCE, 0xECD2, 0xF288, 0xF817, 0xFE03, 0x0533,
    0x048C, 0x0B41, 0x0D36, 0x0FE5, 0x1158, 0x0BDC, 0x066E, 0x07E2, 0x065B, 0xFC31, 0xFE3D, 0xF72C, 0xFD02, 0xF976, 0xF985, 0xF9D2,
    0xFD76, 0x0231, 0x08E8, 0x124E, 0x1540, 0x19E5, 0x213C, 0x238B, 0x1AC4, 0x1E27, 0x1BF1, 0x1E69, 0x1BD3, 0x1D90, 0x180F, 0x12D8,
    0x0E81, 0x093A, 0x02CC, 0xFAAF, 0xF156, 0xEF4F, 0xED5F, 0xE476, 0xE9DE, 0xE716, 0xEFCF, 0xF0E5, 0xF71C, 0xFBB1, 0xFBA1, 0xFCFF,
    0xF999, 0xF81A, 0xF057, 0xEB13, 0xEC2F, 0xF143, 0xEA53, 0xEEFC, 0xF412, 0xF457, 0xF8F1, 0xF465, 0xFA46, 0x05A4, 0x0B26, 0x0B60,
    0x110B, 0x1709, 0x1779, 0x1C90, 0x16E8, 0x1794, 0x19CA, 0x1449, 0x15D1, 0x14B7, 0x0E9D, 0x108A, 0x13F9, 0x1214, 0x1312, 0x1208,
    0x188C, 0x1A64, 0x16FA, 0x1171, 0x146A, 0x12DD, 0x0D65, 0x0F92, 0x0936, 0x07E0, 0x00F3, 0xFE6C, 0xF875, 0xF392, 0xEC3E, 0xEB3A,
    0xEA11, 0xE580, 0xE579, 0xE27D, 0xE4EF, 0xE2A9, 0xE175, 0xDBBE, 0xDD4C, 0xD68D, 0xD592, 0xD4DA, 0xCFBD, 0xD247, 0xD367, 0xDA75,
    0xDA93, 0xDFEA, 0xE451, 0xEACB, 0xEDA4, 0xEC96, 0xF2C0, 0xEF69, 0xF1E3, 0xEF19, 0xF017, 0xEE1A, 0xEE11, 0xF0D0, 0xEEA3, 0xF566,
    0xF42F, 0xFBFD, 0x01C1, 0x1018, 0x1144, 0x1CA9, 0x24E4, 0x2B97, 0x374F, 0x368E, 0x44C7, 0x420C, 0x480B, 0x4276, 0x438B, 0x3CC0,
    0x3244, 0x30AD, 0x2949, 0x2706, 0x1AFF, 0x174C, 0x10EA, 0x100D, 0x037B, 0xFF63, 0xFC7C, 0xFB22, 0xFDD7, 0xF63F, 0xFF38, 0xF7B6,
    0xF65F, 0xF69F, 0xF4AD, 0xF2E8, 0xF098, 0xF270, 0xF05D, 0xF4A9, 0xEE31, 0xF273, 0xF11D, 0xED1B, 0xF193, 0xEF10, 0xEF1E, 0xF2E6,
    0xF4EC, 0xF5AE, 0xFDDB, 0xFEFD, 0xFE7C, 0x0419, 0x09EF, 0x053D, 0x07C5, 0x0806, 0xFDFD, 0x0836, 0xFED6, 0xFEDA, 0x006A, 0xF7F0,
    0x0404, 0x032C, 0x0176, 0x05D9, 0x0B95, 0x0E06, 0x0FA1, 0x100D, 0x1390, 0x123A, 0x150F, 0x105F, 0x0D1E, 0x110B, 0x055A, 0x064E,
    0x01EB, 0xF5B8, 0xF0F1, 0xE7FA, 0xE64D, 0xE2F3, 0xDB36, 0xE199, 0xE070, 0xE0D0, 0xDF04, 0xDF60, 0xE6EF, 0xE41B, 0xE27C, 0xE8FE,
    0xE774, 0xEE52, 0xEF80, 0xEDF0, 0xF802, 0xF63A, 0xFFFA, 0x04FE, 0x0BE7, 0x118D, 0x121B, 0x17F4, 0x1C5A, 0x1598, 0x147F, 0x12A7,
    0x117C, 0x1082, 0x0468, 0x08DB, 0x046C, 0x06C1, 0x08E9, 0x0A36, 0x101D, 0x0E9E, 0x1A31, 0x1DA7, 0x1E56, 0x21BC, 0x2311, 0x252F,
    0x239F, 0x1A5D, 0x157E, 0x1209, 0x07DA, 0x073C, 0xFDA1, 0xFC8F, 0xF905, 0xF855, 0xF863, 0xF293, 0xF0CC, 0xED29, 0xF399, 0xED16,
    0xF336, 0xF2C0, 0xF677, 0xFAD5, 0xF876, 0xFCAA, 0xF59D, 0xF47B, 0xEFB5, 0xF093, 0xE996, 0xE931, 0xE47C, 0xE5BB, 0xEB4C, 0xE663,
    0xEC92, 0xEA32, 0xF923, 0xF713, 0xF5D0, 0xF7D0, 0xF847, 0xF9CC, 0xF8B4, 0xFBAE, 0xF87C, 0xFF25, 0xF9DA, 0x076D, 0x0566, 0x08FF,
    0x104D, 0x1212, 0x1A6F, 0x128B, 0x1BE6, 0x1987, 0x1DF4, 0x209A, 0x1D94, 0x2637, 0x2777, 0x2314, 0x2804, 0x274A, 0x1F5B, 0x255A,
    0x1AF1, 0x20F4, 0x1B47, 0x10A4, 0x0F8A, 0xFE50, 0xFAFB, 0xEBC1, 0xEACC, 0xE530, 0xE191, 0xE757, 0xE450, 0xE6F9, 0xEA3B, 0xE931,
    0xEC81, 0xEE69, 0xED98, 0xF749, 0xF661, 0xFEA4, 0x011C, 0x021B, 0x0BE1, 0x0612, 0x07B8, 0x08DD, 0x05CD, 0x08CE, 0xFFE8, 0xFC6D,
    0xFAAC, 0xF5E1, 0xF1F1, 0xF061, 0xEF00, 0xECFE, 0xEFAB, 0xF125, 0xF129, 0xF05C, 0xF402, 0xF48D, 0xFE11, 0xFDB9, 0x0152, 0x11E1,
    0x138D, 0x1DAA, 0x21E9, 0x2569, 0x2A73, 0x25D4, 0x223E, 0x1F7E, 0x16EC, 0x0CA4, 0x09D1, 0x0411, 0xFEB3, 0xF29F, 0xF2EC, 0xEAF0,
    0xE343, 0xE01E, 0xD912, 0xDD9E, 0xD8AD, 0xDBBC, 0xDDB5, 0xDD13, 0xDB51, 0xD921, 0xD78C, 0xD351, 0xD1A0, 0xD091, 0xD18B, 0xD5FB,
    0xDB2F, 0xDEF5, 0xE6A8, 0xEABD, 0xF35F, 0xFE5D, 0x03CC, 0x0E2D, 0x0DC2, 0x16F4, 0x1C6C, 0x1E2C, 0x1F9E, 0x1CC1, 0x24AD, 0x2565,
    0x2472, 0x223C, 0x205B, 0x2209, 0x21E9, 0x1A6C, 0x210A, 0x1BC4, 0x2333, 0x2C67, 0x29E9, 0x30B6, 0x2CC4, 0x3171, 0x314B, 0x270D,
    0x23AB, 0x22F5, 0x1C0B, 0x1A56, 0x14F8, 0x14AC, 0x0ED1, 0x0AE7, 0x0C84, 0x029A, 0xFF44, 0xF350, 0xEEC4, 0xED3C, 0xE158, 0xE2B7,
    0xDFE4, 0xDFC8, 0xE360, 0xDCD4, 0xDDD5, 0xE1A2, 0xDD8A, 0xE5D4, 0xE7AF, 0xEBB1, 0xF196, 0xEFFE, 0xF82D, 0xF4ED, 0xF26A, 0xF034,
    0xF083, 0xEF55, 0xEBFB, 0xECD1, 0xECC4, 0xEA87, 0xEC6B, 0xE6A2, 0xE903, 0xEE04, 0xE819, 0xF2F7, 0xF5C2, 0xF9A4, 0x0059, 0x012D,
    0x0A0C, 0x1053, 0x136D, 0x1900, 0x1DDE, 0x1ECE, 0x1E10, 0x1BF9, 0x1913, 0x0F4C, 0x0E02, 0x0A41, 0x0485, 0x087D, 0x01C3, 0x05E1,
    0x0149, 0xFB38, 0xF7FD, 0xF427, 0xEE99, 0xEB38, 0xEC3C, 0xF00E, 0xF42B, 0xF2AB, 0xFB31, 0xFCFB, 0x0448, 0xFF09, 0xFF02, 0xFEE6,
    0xF770, 0xF939, 0xF6B0, 0xF691, 0xF3DF, 0xF6DD, 0xFBD3, 0xFE23, 0xFD61, 0xFD4A, 0x02C3, 0x06A3, 0x066B, 0x067F, 0x0B46, 0x06ED,
    0x0976, 0x0344, 0x006A, 0xFCE6, 0xF1D4, 0xFA25, 0xF493, 0xF831, 0xF62C, 0xF720, 0x007A, 0x0408, 0x08A2, 0x10C1, 0x1966, 0x222C,
    0x2940, 0x27AA, 0x29FA, 0x2502, 0x263D, 0x226A, 0x20DE, 0x203D, 0x17DA, 0x1CAC, 0x1155, 0x05D1, 0xFED2, 0xF05F, 0xEEFE, 0xE5C0,
    0xE033, 0xE379, 0xE3B7, 0xE253, 0xE622, 0xE327, 0xE0EA, 0xDDC5, 0xDA12, 0xDDB6, 0xD946, 0xDE4D, 0xE006, 0xE6F5, 0xEB25, 0xEC86,
    0xF99F, 0xF907, 0xFFB8, 0x030F, 0x0337, 0x07A7, 0x0282, 0x00B0, 0x0166, 0xFFFC, 0xFB1D, 0xFA37, 0xF673, 0xFD82, 0xFC67, 0x0220,
    0x086D, 0x0CE1, 0x143A, 0x157D, 0x22FC, 0x1C82, 0x2106, 0x264C, 0x283E, 0x2B30, 0x2562, 0x268F, 0x2642, 0x2208, 0x1B21, 0x1A58,
    0x15DD, 0x196C, 0x17A7, 0x1460, 0x1482, 0x0CCE, 0x0EFF, 0x04FC, 0x07C5, 0x0269, 0x01CD, 0x06D9, 0x0467, 0x02E2, 0xFD1B, 0xFBDE,
    0xF1AF, 0xEE1B, 0xE10F, 0xE37F, 0xDDB2, 0xDE1C, 0xDE4A, 0xDDA4, 0xE33A, 0xDF0C, 0xE5B7, 0xE2B3, 0xE775, 0xE63D, 0xE93B, 0xF18F,
    0xF356, 0xF7AF, 0xFF22, 0x02CD, 0x0389, 0x06A6, 0x068C, 0x0D7D, 0x064F, 0x068D, 0x094E, 0x03B7, 0x069D, 0x038F, 0x0B75, 0x067F,
    0x0AB7, 0x0E46, 0x11A4, 0x1799, 0x1219, 0x1850, 0x17B5, 0x1191, 0x0A71, 0x05D2, 0xFE43, 0x010E, 0xF608, 0xF0A2, 0xEF5C, 0xE3E8,
    0xE38A, 0xD9FC, 0xDAD5, 0xD602, 0xDBB4, 0xE181, 0xE308, 0xEEC0, 0xEC65, 0xF3B8, 0xF633, 0xF87E, 0xF930, 0xFCA0, 0xFDA5, 0x058C,
    0x08BF, 0x08E2, 0x1137, 0x0A0B, 0x1162, 0x1039, 0x11A2, 0x0D1A, 0x0D5D, 0x12F0, 0x10B2, 0x1378, 0x0D87, 0x0FAF, 0x0A26, 0x0996,
    0x07DB, 0x0393, 0x0262, 0x059A, 0x0E32, 0x0D71, 0x13BF, 0x1395, 0x205E, 0x23CB, 0x26AC, 0x2D73, 0x2FCA, 0x3606, 0x2E2E, 0x300D,
    0x282A, 0x231A, 0x1760, 0x1407, 0x102C, 0x09EB, 0x0450, 0x00E5, 0x062B, 0xFB1E, 0xFB4E, 0xF3C0, 0xF517, 0xF11D, 0xE9B6, 0xF019,
    0xEB2B, 0xEA9D, 0xE4B7, 0xE1F5, 0xDC5A, 0xD745, 0xD3F5, 0xD414, 0xD828, 0xD71D, 0xDACC, 0xD9F6, 0xE3C6, 0xDF44, 0xE533, 0xE81C,
    0xEE88, 0xF92D, 0xF447, 0x02E6, 0x03D4, 0x05BD, 0xFF77, 0xFF94, 0xFBDA, 0xF66F, 0xF5C5, 0xEFED, 0xF5AF, 0xF217, 0xF625, 0xF914,
    0xFD5A, 0xFC75, 0x042F, 0x08EE, 0x0919, 0x13CE, 0x1206, 0x1DAD, 0x1E32, 0x217D, 0x2127, 0x2481, 0x266A, 0x239A, 0x2A3C, 0x1F77,
    0x228C, 0x1ED4, 0x1797, 0x0D83, 0x05F3, 0xFE19, 0xF866, 0xF28A, 0xE9DC, 0xF438, 0xEFFA, 0xF279, 0xF2AC, 0xF431, 0xF48A, 0xEDBB,
    0xF020, 0xEA4C, 0xEE5B, 0xEA70, 0xEC4B, 0xECD1, 0xED4F, 0xEA10, 0xEA35, 0xED08, 0xEA4A, 0xEF13, 0xED3C, 0xFAA5, 0xF745, 0xF8FC,
    0xF84C, 0xFB03, 0xFE3C, 0xF86D, 0xFFBE, 0x02FB, 0x08C8, 0x07D6, 0x0C46, 0x0F55, 0x12F0, 0x13F2, 0x15D8, 0x1D12, 0x1E57, 0x20B1,
    0x2219, 0x2ABD, 0x232B, 0x1FD3, 0x214D, 0x1960, 0x1A26, 0x0CF3, 0x0B1C, 0x06E1, 0x02E4, 0xFB23, 0xF712, 0xF48E, 0xEE7F, 0xF0B0,
    0xEAB8, 0xEC6A, 0xEA64, 0xF15D, 0xF123, 0xF737, 0xF27D, 0xECB8, 0xF407, 0xE9CD, 0xE812, 0xE2F7, 0xE369, 0xE3DB, 0xE90B, 0xEA36,
    0xF062, 0xF7E8, 0xF864, 0x05A1, 0x046C, 0x0A97, 0x0CD0, 0x14BD, 0x132B, 0x1234, 0x13A0, 0x0A26, 0x0BC6, 0x037E, 0x05B0, 0x0337,
    0x0527, 0x04E3, 0x090D, 0x0E56, 0x0DE4, 0x11F5, 0x11E2, 0x1FAA, 0x272D, 0x2CC0, 0x3193, 0x397C, 0x3AE2, 0x379E, 0x35A9, 0x2C31,
    0x2CDC, 0x1ED4, 0x1C8A, 0x1387, 0x082C, 0x0365, 0xF768, 0xF5D5, 0xE89A, 0xE4D8, 0xDDD8, 0xDCF0, 0xD83A, 0xD8B5, 0xD995, 0xDC36,
    0xDBA4, 0xD835, 0xE0B2, 0xDA62, 0xE14E, 0xDDC1, 0xE4CF, 0xEAD3, 0xEA81, 0xF48D, 0xF3E1, 0xF6C0, 0xF552, 0xF7CD, 0xF47C, 0xF520,
    0xF3E8, 0xF5C8, 0xF87D, 0xF35D, 0xF6AD, 0xF2AB, 0xF630, 0xEEDB, 0xF3DD, 0xF437, 0xF0A7, 0xF3A6, 0xEF88, 0xF855, 0xF2D3, 0xF26A,
    0xF576, 0xFEC9, 0x01C2, 0x0702, 0x0D76, 0x1163, 0x1773, 0x10F5, 0x157B, 0x142F, 0x1705, 0x14F2, 0x1BD6, 0x1F36, 0x1892, 0x1E2F,
    0x1491, 0x17AB, 0x0EA9, 0x06C4, 0x07D7, 0x09A3, 0x06D6, 0x0384, 0x0912, 0x04C2, 0x07DA, 0xFE21, 0x0073, 0xFDE6, 0xF7FB, 0xF39E,
    0xF300, 0xF699, 0xEF24, 0xF71D, 0xF63E, 0xFC33, 0xFE18, 0xFEDA, 0x0502, 0x098D, 0x0BDA, 0x0A3D, 0x1497, 0x0F57, 0x121D, 0x0E2E,
    0x0C77, 0x09C9, 0x0329, 0x0436, 0xFD80, 0x0284, 0xFF5F, 0x0618, 0x022A, 0x07B5, 0x0FCF, 0x14F1, 0x1D09, 0x1F63, 0x29C8, 0x27F9,
    0x2880, 0x224C, 0x1FE9, 0x1643, 0x1319, 0x0DBD, 0x05E6, 0x02F5, 0xF869, 0xF9D3, 0xEBB7, 0xE674, 0xDE78, 0xD97C, 0xDCD0, 0xD577,
    0xDB67, 0xDC85, 0xE25F, 0xE5F1, 0xE4A6, 0xE28A, 0xE904, 0xE61E, 0xE475, 0xE51F, 0xE1BD, 0xE992, 0xE39F, 0xEB54, 0xEC7D, 0xEE99,
    0xEF91, 0xEE38, 0xF649, 0xF00E, 0xEFB6, 0xF1D2, 0xF35D, 0xF589, 0xF3B6, 0xF1EC, 0xF85A, 0xF8FB, 0xF567, 0xFE5D, 0x01AD, 0x075B,
    0x0C6F, 0x134E, 0x19F1, 0x1C75, 0x2014, 0x2447, 0x2D9B, 0x2AEC, 0x2DF1, 0x3134, 0x2E3A, 0x2D68, 0x2C31, 0x28A4, 0x2A0D, 0x2862,
    0x216D, 0x24FC, 0x1EB1, 0x1673, 0x0E60, 0x03A1, 0xFB6B, 0xF2F1, 0xED3B, 0xE7BA, 0xE8CE, 0xE67D, 0xE485, 0xE52C, 0xE117, 0xDE45,
    0xDE2A, 0xDAF1, 0xD9FC, 0xDDA6, 0xDD91, 0xE747, 0xE9CF, 0xF001, 0xF778, 0xF8E4, 0xFD37, 0xFC3A, 0x02AE, 0x0570, 0x0432, 0x0592,
    0x0872, 0x0B60, 0x0A6C, 0x06B7, 0x0811, 0x06D2, 0x000A, 0x003D, 0xFD6C, 0xFAD6, 0xF7AA, 0xFC67, 0xFF6C, 0xFC22, 0x03FD, 0x0741,
    0x117E, 0x140E, 0x15B2, 0x1A5D, 0x1C35, 0x1BD3, 0x175D, 0x1817, 0x156C, 0x11DA, 0x0F82, 0x0D2A, 0x0516, 0x030A, 0xF9E8, 0xF612,
    0xF2C2, 0xEB01, 0xEFE8, 0xF0F9, 0xF329, 0xF8D6, 0xFC46, 0xFB66, 0xFB85, 0xFC59, 0xF95C, 0xF508, 0xF608, 0xF37D, 0xF3F0, 0xF97A,
    0xF43A, 0xF8BE, 0xFA52, 0xF67D, 0xFC60, 0xF9FE, 0xFC58, 0x02F0, 0x01AD, 0x0531, 0x0CD0, 0x0AA6, 0x0D09, 0x0EE8, 0x0F5B, 0x0D67,
    0x0E29, 0x1061, 0x0CA1, 0x118E, 0x0CA7, 0x112C, 0x162E, 0x1193, 0x15EC, 0x18D2, 0x1A38, 0x187E, 0x12BA, 0x105B, 0x1123, 0x0B2F,
    0x07DE, 0x04D7, 0x0414, 0x00A0, 0xFD77, 0xFECE, 0xFB98, 0xFB59, 0xF4E2, 0xF51B, 0xF20F, 0xECAC, 0xED29, 0xEC9E, 0xECFD, 0xEA77,
    0xE85B, 0xE9D5, 0xE7A9, 0xDE66, 0xDEDD, 0xDC5D, 0xDE56, 0xDEF5, 0xDE19, 0xE64D, 0xE823, 0xE942, 0xE78F, 0xE77B, 0xE6FB, 0xE627,
    0xE85C, 0xE911, 0xE926, 0xEAC4, 0xECCB, 0xEBB4, 0xEEF9, 0xE95A, 0xEAB3, 0xEE6A, 0xEEF8, 0xF5F1, 0xF527, 0x0014, 0x05A8, 0x0D58,
    0x1668, 0x1E7F, 0x2711, 0x2C78, 0x3396, 0x3535, 0x3632, 0x354B, 0x3858, 0x35EB, 0x36F3, 0x330F, 0x32EB, 0x3189, 0x2605, 0x2392,
    0x18A0, 0x121C, 0x0842, 0x022C, 0xFDE7, 0xF57D, 0xF814, 0xF416, 0xF5DD, 0xF47D, 0xF687, 0xFD35, 0xFAD2, 0xF526, 0xF786, 0xF500,
    0xF028, 0xF3F2, 0xED99, 0xF7C2, 0xF6E7, 0xF46B, 0xF7BA, 0xF5C7, 0xF659, 0xF3D2, 0xFC8D, 0xFA28, 0xFDA2, 0xFFED, 0x00CA, 0x01E0,
    0xFEE0, 0xFB82, 0xFC8D, 0xFCEE, 0xF4F5, 0xFE8C, 0xF9DC, 0xFC0E, 0xFCC8, 0xFB1D, 0x01F5, 0x0237, 0x0695, 0x05C0, 0x0FC7, 0x0F91,
    0x10DC, 0x114F, 0x141F, 0x154E, 0x132E, 0x152D, 0x1050, 0x12F2, 0x0B56, 0x0C21, 0x0450, 0xFF45, 0xFB09, 0xF3F9, 0xF7DB, 0xEE85,
    0xF118, 0xEC61, 0xED56, 0xEC6A, 0xE72C, 0xE5B1, 0xE3ED, 0xE150, 0xDA35, 0xDF07, 0xD9E2, 0xDE85, 0xDDE2, 0xE5D0, 0xE94D, 0xED4F,
    0xF74C, 0xF60F, 0x034F, 0xFEFB, 0x05E8, 0x0C11, 0x0B1F, 0x0D65, 0x0FE4, 0x0E99, 0x0C35, 0x0CA7, 0x0715, 0x0B69, 0x08D7, 0x0F8B,
    0x102A, 0x133D, 0x16CE, 0x1599, 0x2107, 0x1BF1, 0x2164, 0x2306, 0x2228, 0x23F0, 0x20B1, 0x1D27, 0x1869, 0x171A, 0x0FAA, 0x0F53,
    0x06C4, 0x04AF, 0x0155, 0xFDA7, 0xF80E, 0xF54E, 0xF51A, 0xEB1D, 0xF4F3, 0xF0B5, 0xF1AE, 0xF325, 0xF2D1, 0xF48B, 0xEFC5, 0xEFEA,
    0xEE0A, 0xEF8A, 0xE961, 0xEEAA, 0xEF2B, 0xF066, 0xEFD4, 0xF1A3, 0xF2B0, 0xEEC7, 0xF3B7, 0xEC62, 0xF344, 0xEC97, 0xED27, 0xF2B0,
    0xEC67, 0xEF02, 0xEEA7, 0xF564, 0xF458, 0xF530, 0xF2A3, 0xF7A7, 0xF6EF, 0xF6CD, 0xFB89, 0xF961, 0x02AE, 0x01C8, 0x0E36, 0x0F9D,
    0x1506, 0x1C7E, 0x1F3B, 0x2877, 0x2378, 0x2A80, 0x26DB, 0x29D9, 0x25B3, 0x23B3, 0x22BA, 0x2061, 0x1D55, 0x16F3, 0x1685, 0x0974,
    0x0BFC, 0x0179, 0x013F, 0xFE82, 0xF7C5, 0xF841, 0xF49D, 0xF858, 0xF1C4, 0xF766, 0xF5E0, 0xF48C, 0xF5E0, 0xF4ED, 0xF6EB, 0xF86B,
    0xF8AA, 0xF99C, 0x0038, 0xFB03, 0x0577, 0x0451, 0x0563, 0x09E1, 0x05A2, 0x0C59, 0x03C1, 0x0417, 0xFBBD, 0xFBC8, 0xF914, 0xECB9,
    0xEBCB, 0xEBE2, 0xE7D6, 0xE638, 0xEBBD, 0xE87D, 0xF33E, 0xF5FA, 0xFF09, 0x074A, 0x0B2E, 0x15DE, 0x1823, 0x2033, 0x1AD4, 0x1E1A,
    0x1D45, 0x17F6, 0x177B, 0x119E, 0x106D, 0x0C87, 0x06C3, 0x0098, 0x0242, 0xF5EF, 0xF320, 0xEF85, 0xE8F0, 0xEA82, 0xE47F, 0xE4A3,
    0xDD64, 0xE024, 0xDB79, 0xD6C0, 0xD550, 0xD041, 0xD2E5, 0xCF27, 0xD135, 0xD2AE, 0xD6B5, 0xD8E8, 0xDE8E, 0xE293, 0xEA00, 0xF21C,
    0xF5FB, 0x0053, 0xFC79, 0x0779, 0x07BA, 0x0872, 0x0D59, 0x0B47, 0x10A0, 0x0CD4, 0x10E8, 0x1052, 0x1322, 0x153B, 0x173B, 0x1B14,
    0x1C7B, 0x1F3E, 0x267A, 0x296E, 0x2727, 0x2B45, 0x2757, 0x2C4F, 0x2D15, 0x27D2, 0x2BE6, 0x2966, 0x29ED, 0x28CB, 0x2828, 0x2657,
    0x2077, 0x1B2B, 0x1630, 0x1141, 0x08DA, 0x0274, 0xFFD4, 0xFF9A, 0xF94D, 0xF92E, 0xF668, 0xF902, 0xF565, 0xEF2E, 0xF0C1, 0xE9D4,
    0xE6B1, 0xE363, 0xE42F, 0xE3EC, 0xE457, 0xE45A, 0xE96E, 0xEA15, 0xED11, 0xEF65, 0xEE4D, 0xF3A8, 0xECDF, 0xF26A, 0xF007, 0xEE67,
    0xF22F, 0xED9C, 0xF714, 0xF623, 0xF542, 0xF5D6, 0xF6E4, 0xF888, 0xF978, 0xFA09, 0xFE8D, 0x0635, 0x0D7C, 0x151A, 0x1438, 0x200D,
    0x1C6E, 0x1EC3, 0x22A6, 0x17F4, 0x1BA8, 0x1253, 0x106C, 0x0C73, 0x02EF, 0xFE46, 0xF599, 0xF24A, 0xEDC0, 0xEBF9, 0xE692, 0xE966,
    0xEE99, 0xEED4, 0xECB4, 0xF4F5, 0xF8BF, 0xF51A, 0xF9C1, 0xF699, 0xFB68, 0xF565, 0xF28B, 0xF5CC, 0xF6FE, 0xF8E6, 0xF56E, 0xFDBD,
    0x032F, 0x01FB, 0x035F, 0x07B1, 0x0856, 0x06BC, 0x0618, 0x05E1, 0x0799, 0x006D, 0xFDEE, 0xFB9C, 0xFBD1, 0xF759, 0xF186, 0xF3E4,
    0xEDC0, 0xF17C, 0xEC6E, 0xEE52, 0xF941, 0xFF13, 0x0643, 0x1161, 0x16DD, 0x1B7B, 0x210B, 0x1DD4, 0x24C7, 0x2277, 0x2332, 0x23BD,
    0x2503, 0x2496, 0x1AA7, 0x1B7F, 0x1233, 0x0F41, 0x0B95, 0x00B2, 0x00EF, 0xFC80, 0xF73A, 0xF21F, 0xEFB1, 0xEADD, 0xE97C, 0xE59A,
    0xE251, 0xDE51, 0xDDB9, 0xDDAF, 0xD8A7, 0xDF43, 0xDC75, 0xE40E, 0xE3D1, 0xE5EC, 0xEFB6, 0xEB30, 0xEF9B, 0xEFDC, 0xF516, 0xF4C4,
    0xF62C, 0xFD62, 0xFE4E, 0x00E5, 0x0297, 0x02DE, 0x0496, 0x0586, 0xFE1C, 0x042D, 0x0049, 0xFF8D, 0x0460, 0x0340, 0x1031, 0x11E3,
    0x1A50, 0x2160, 0x23A6, 0x2899, 0x2471, 0x2444, 0x24A0, 0x24C2, 0x2402, 0x2388, 0x24C9, 0x284E, 0x21BD, 0x1D65, 0x1AE2, 0x1017,
    0x0F7E, 0x07CC, 0x088E, 0x020B, 0xFEDF, 0x0273, 0xFC50, 0xFE2F, 0xFBA6, 0xFB43, 0xFAC0, 0xF56D, 0xEFF5, 0xEE26, 0xE5D3, 0xE279,
    0xDD64, 0xDB63, 0xDB73, 0xD752, 0xDBC8, 0xDA96, 0xDC04, 0xDF51, 0xE25C, 0xE5B9, 0xE5EC, 0xEFCE, 0xF34F, 0xF01D, 0xF3B6, 0xF5AA,
    0xF5C0, 0xF58E, 0xF3A7, 0xF524, 0xF4B6, 0xF252, 0xFAE4, 0xFE0D, 0x0432, 0x06F2, 0x0FA1, 0x191D, 0x184E, 0x198B, 0x156E, 0x19BC,
    0x184D, 0x1156, 0x1166, 0x127B, 0x0DA3, 0x0B41, 0x04F1, 0xFE18, 0xF75D, 0xE9FE, 0xEA1F, 0xE850, 0xE731, 0xE44F, 0xE742, 0xF241,
    0xEFD0, 0xEED7, 0xEE70, 0xF241, 0xF3C5, 0xEECC, 0xEDE3, 0xF2FD, 0xF22B, 0xEEF6, 0xEFB3, 0xF411, 0xF75C, 0xF6CC, 0xFD7A, 0x0049,
    0x071F, 0x082A, 0x053C, 0x0BCC, 0x09CB, 0x0B71, 0x0AE8, 0x090F, 0x0BDE, 0x0809, 0x0755, 0x0968, 0x0840, 0x0632, 0x07C8, 0x0BA7,
    0x1262, 0x11AE, 0x1BDB, 0x1EB7, 0x2306, 0x2A71, 0x212B, 0x251F, 0x24D9, 0x2547, 0x2288, 0x2257, 0x25A5, 0x2438, 0x1F8F, 0x1CF4,
    0x175B, 0x0D34, 0x0684, 0xFB32, 0xFB8A, 0xF285, 0xED67, 0xEDB2, 0xE9B6, 0xF128, 0xEA55, 0xEAA7, 0xEA64, 0xE81E, 0xE601, 0xE16C,
    0xE483, 0xE1E3, 0xE3DD, 0xE543, 0xE790, 0xE608, 0xEA15, 0xE730, 0xEA4C, 0xED90, 0xE78A, 0xECB7, 0xEA07, 0xEFF7, 0xEB88, 0xEBD5,
    0xF2D6, 0xF23C, 0xF3E9, 0xF356, 0xF9F0, 0xF6D5, 0xF1B4, 0xED6B, 0xEFB9, 0xEE27, 0xEE52, 0xF138, 0xF68E, 0xFFCC, 0xFDE4, 0x0697,
    0x0A77, 0x125D, 0x13C7, 0x15B3, 0x1F8F, 0x2081, 0x2469, 0x2405, 0x24D1, 0x228D, 0x1DC7, 0x1796, 0x13C6, 0x101B, 0x0AAE, 0x08C0,
    0x06ED, 0x0B62, 0x0714, 0x07C3, 0x081A, 0x043E, 0x0445, 0xFBF3, 0xFA86, 0xF5E4, 0xF6E3, 0xF2CF, 0xEDAB, 0xEDFB, 0xEC33, 0xE9D6,
    0xE501, 0xE4F7, 0xE74E, 0xE85C, 0xE4EC, 0xEBBB, 0xF213, 0xF357, 0xF159, 0xF420, 0xFC46, 0xFA4B, 0xF97F, 0xF6EB, 0xFB07, 0xFC6A,
    0xF337, 0xF65D, 0xF579, 0xFA11, 0xFF0F, 0x02BF, 0x0E01, 0x160F, 0x15CD, 0x1A5E, 0x21D7, 0x20E1, 0x1E2A, 0x1916, 0x2004, 0x1BB2,
    0x186A, 0x10D5, 0x0BAC, 0x0EEB, 0x0431, 0x008C, 0xFE19, 0xFCA6, 0xF870, 0xF5FB, 0xF416, 0xF0F5, 0xEC75, 0xE81A, 0xE217, 0xD826,
    0xD1B3, 0xC8C2, 0xC7E7, 0xC4B0, 0xC199, 0xBF7F, 0xB65D, 0xB685, 0xB5D3, 0xAE6B, 0xAAC5, 0xAC77, 0xAB44, 0xA921, 0xA849, 0xA8C8,
    0xA9D2, 0xA988, 0xA8CF, 0xA919, 0xADE1, 0xAE11, 0xAE74, 0xB247, 0xB46A, 0xB828, 0xBA67, 0xBEF1, 0xC7BF, 0xCFCD, 0xD8FE, 0xE68A,
    0xEE1E, 0xF6EF, 0x02FA, 0x10D6, 0x1B19, 0x223D, 0x2DFF, 0x34C8, 0x4411, 0x49FE, 0x4DD0, 0x55D0, 0x5A36, 0x5A1B, 0x56DE, 0x56B6,
    0x5146, 0x4F0F, 0x4CD0, 0x4CC9, 0x4A06, 0x4614, 0x424A, 0x455C, 0x4735, 0x4467, 0x4688, 0x48FD, 0x4CDE, 0x4AF7, 0x4ACC, 0x4A9F,
    0x4C3A, 0x4A3E, 0x4839, 0x4C3B, 0x4A52, 0x4B11, 0x4C21, 0x5110, 0x544B, 0x5612, 0x56C1, 0x59F2, 0x5DF5, 0x5B5A, 0x5CC3, 0x5C56,
    0x5E3E, 0x5BEE, 0x5958, 0x55EB, 0x5306, 0x5077, 0x4C84, 0x49DD, 0x4B1D, 0x4C8B, 0x4A18, 0x4B72, 0x4C37, 0x4F09, 0x4BA4, 0x4B69,
    0x4B05, 0x4B39, 0x4BCB, 0x4715, 0x4580, 0x4478, 0x4092, 0x399A, 0x3426, 0x2C5B, 0x28D1, 0x1EEE, 0x1B12, 0x1857, 0x12E2, 0x11C6,
    0x0952, 0x07FF, 0x0255, 0xFAED, 0xF181, 0xEE8E, 0xEB48, 0xE071, 0xDA32, 0xD809, 0xD483, 0xCC09, 0xC9D9, 0xC80E, 0xC94E, 0xC4E0,
    0xC54E, 0xC6D5, 0xC40B, 0xC3BD, 0xC0FC, 0xBF5D, 0xBC10, 0xB8CD, 0xB5C2, 0xB7C4, 0xB481, 0xB414, 0xB3C9, 0xB26A, 0xB1D6, 0xB123,
    0xB330, 0xB131, 0xB5B8, 0xB7EF, 0xBBDB, 0xBD24, 0xBFFB, 0xC253, 0xC297, 0xC374, 0xC121, 0xC410, 0xC219, 0xC610, 0xC409, 0xC381,
    0xC2D7, 0xC10D, 0xC0E0, 0xBCF3, 0xBEF2, 0xB9F6, 0xBB5C, 0xBB22, 0xBC0D, 0xBAC0, 0xB912, 0xB960, 0xB66A, 0xB802, 0xB3AC, 0xB564,
    0xB637, 0xB662, 0xB967, 0xBA05, 0xBDA6, 0xBDFB, 0xC169, 0xC3B0, 0xC565, 0xC81A, 0xC9A8, 0xCE32, 0xCDC1, 0xD0AF, 0xD376, 0xD60F,
    0xD7AA, 0xD980, 0xE01F, 0xE339, 0xE9B6, 0xE9A8, 0xEF92, 0xF4F6, 0xF71F, 0xFB63, 0xFC20, 0x0553, 0x0732, 0x109E, 0x188A, 0x216F,
    0x27A4, 0x2CBA, 0x362A, 0x370B, 0x3D9B, 0x3978, 0x422B, 0x47A3, 0x4782, 0x46DD, 0x44AA, 0x4723, 0x4215, 0x3FF9, 0x3797, 0x38A1,
    0x3598, 0x3460, 0x3391, 0x31BD, 0x3123, 0x2F79, 0x30E8, 0x2F39, 0x3348, 0x2F41, 0x3398, 0x36AA, 0x35C1, 0x344D, 0x3510, 0x366D,
    0x36C1, 0x381F, 0x35EC, 0x3AA7, 0x3BA2, 0x401C, 0x3EED, 0x41B9, 0x41D5, 0x4212, 0x4143, 0x3F9B, 0x4265, 0x3D98, 0x3EED, 0x3747,
    0x38DD, 0x33D4, 0x30D0, 0x2C70, 0x2BAE, 0x33C0, 0x2E1C, 0x35B4, 0x369D, 0x3D46, 0x3C31, 0x3BF6, 0x3EA7, 0x3C95, 0x3CB7, 0x3742,
    0x3B0D, 0x36EA, 0x36FD, 0x30ED, 0x3200, 0x3076, 0x2999, 0x281C, 0x2144, 0x2397, 0x1CD7, 0x1CB5, 0x1CE4, 0x1B44, 0x1802, 0x1384,
    0x11C9, 0x0B29, 0x0679, 0x00B6, 0xFFEC, 0xFD40, 0xF7B1, 0xF53C, 0xF5A0, 0xF468, 0xF1E4, 0xF307, 0xF67B, 0xF744, 0xFA95, 0xFAB5,
    0xFCED, 0xFDB2, 0xFBB0, 0xFD1A, 0xF828, 0xFA0A, 0xF7ED, 0xF622, 0xF57B, 0xF1EE, 0xEF95, 0xECFC, 0xEC96, 0xEA96, 0xEBCE, 0xE9B1,
    0xECED, 0xEE4E, 0xECEE, 0xEDD9, 0xE88B, 0xE62A, 0xE280, 0xDEF9, 0xDA98, 0xDA17, 0xD8E0, 0xD4ED, 0xD6F7, 0xD1F5, 0xCFF5, 0xCE40,
    0xC6BC, 0xC378, 0xBFB3, 0xBDE0, 0xB8A7, 0xB990, 0xBA08, 0xB93C, 0xBA19, 0xB606, 0xBB4A, 0xB5FE, 0xB55E, 0xB58D, 0xB629, 0xB58B,
    0xB36E, 0xB77A, 0xB471, 0xB8CC, 0xB197, 0xB32B, 0xB398, 0xB344, 0xB3B6, 0xB0CB, 0xB51A, 0xAF90, 0xB380, 0xAEDC, 0xB1CF, 0xB236,
    0xB37F, 0xB8B2, 0xB7DB, 0xBEEB, 0xBC54, 0xC241, 0xC1D4, 0xC712, 0xC6EA, 0xC8BE, 0xD011, 0xD38E, 0xDB85, 0xD8C4, 0xDFFF, 0xDF38,
    0xE33C, 0xE705, 0xE702, 0xE932, 0xEA04, 0xEDFC, 0xEC7C, 0xE9BE, 0xE4B6, 0xE2C1, 0xDE66, 0xDD31, 0xD9A2, 0xD9A4, 0xD943, 0xD90F,
    0xDE5C, 0xDE1A, 0xDCEF, 0xDBE4, 0xDFC7, 0xDE1F, 0xDB78, 0xD7F0, 0xD993, 0xD9B6, 0xD944, 0xD95B, 0xD935, 0xDEA5, 0xDAEA, 0xE178,
    0xE1C1, 0xE521, 0xE904, 0xED03, 0xF4FE, 0xF573, 0xF8A8, 0xF811, 0xFDDE, 0xF9F0, 0xFB42, 0xFA5A, 0xF88A, 0xFB8E, 0xF4EA, 0xF55F,
    0xF458, 0xF6FA, 0xF65F, 0xFD44, 0x06BF, 0x0A92, 0x1510, 0x17DF, 0x1CD6, 0x1EDB, 0x2179, 0x2505, 0x2673, 0x27CE, 0x2806, 0x2BFE,
    0x2825, 0x280F, 0x2439, 0x207F, 0x23A2, 0x1E4C, 0x1E11, 0x1E85, 0x213F, 0x1F46, 0x20FE, 0x22F0, 0x1EF7, 0x2088, 0x1B24, 0x1DB1,
    0x1891, 0x179F, 0x193B, 0x1904, 0x1CF4, 0x1D72, 0x234A, 0x225D, 0x26F9, 0x2882, 0x2B02, 0x2EC7, 0x2F3A, 0x32F7, 0x35BD, 0x3925,
    0x391D, 0x3E05, 0x406B, 0x4066, 0x41E2, 0x449D, 0x4743, 0x448F, 0x479B, 0x493C, 0x4872, 0x49EC, 0x4B52, 0x4EF3, 0x5154, 0x534E,
    0x555E, 0x53BE, 0x555F, 0x5273, 0x509C, 0x50A4, 0x5060, 0x5226, 0x4F21, 0x52BB, 0x508A, 0x4E96, 0x49AB, 0x4996, 0x4536, 0x4030,
    0x4047, 0x3B6A, 0x3FF6, 0x39B0, 0x3A07, 0x37E1, 0x397F, 0x38EF, 0x3467, 0x38D3, 0x3458, 0x379F, 0x35C3, 0x3609, 0x31E2, 0x304D,
    0x2E80, 0x2AAF, 0x295E, 0x1E2B, 0x225A, 0x20E6, 0x2383, 0x24FD, 0x2568, 0x2773, 0x271E, 0x2B25, 0x2663, 0x2671, 0x21F1, 0x208E,
    0x214A, 0x1DA3, 0x1A6F, 0x1996, 0x1A87, 0x1CD9, 0x1EF0, 0x1DBC, 0x24E4, 0x2A8F, 0x29DE, 0x3027, 0x327D, 0x32F7, 0x3604, 0x36A1,
    0x3846, 0x35D7, 0x3299, 0x303C, 0x2E0F, 0x27C4, 0x1E01, 0x1723, 0x0F7F, 0x0C0B, 0x076C, 0x03F3, 0x04EC, 0x04E4, 0x079C, 0x0665,
    0x0658, 0x0275, 0x0318, 0x018B, 0xFE53, 0xFE0F, 0xFBC3, 0xFD11, 0xFA5B, 0xF92A, 0xF7E9, 0xF74D, 0xF631, 0xF73B, 0xF808, 0xF78E,
    0xF950, 0xF6DD, 0xF6E7, 0xF79A, 0xF201, 0xEEAC, 0xEA67, 0xE7D9, 0xE0E7, 0xDB4C, 0xDB07, 0xD717, 0xD475, 0xD098, 0xD2E8, 0xD1D4,
    0xD2D7, 0xD504, 0xD4AF, 0xD82A, 0xD92C, 0xDB06, 0xD967, 0xDCCB, 0xDB48, 0xDCBB, 0xDFD4, 0xDC27, 0xDDB1, 0xDAFA, 0xDD4E, 0xD998,
    0xD70E, 0xD2E8, 0xCFBA, 0xCF4D, 0xCA65, 0xC949, 0xC34E, 0xC225, 0xC078, 0xBDA5, 0xB641, 0xB24F, 0xB19A, 0xAD82, 0xAEF0, 0xAA13,
    0xABC7, 0xAECB, 0xAE1F, 0xAEB1, 0xAE6E, 0xB26C, 0xB127, 0xB5EC, 0xB7D4, 0xBB41, 0xBDC5, 0xBD7A, 0xC0A3, 0xC25F, 0xC33E, 0xC289,
    0xC5EF, 0xC48E, 0xC812, 0xC741, 0xC481, 0xC784, 0xC584, 0xC5F2, 0xC59C, 0xC5F5, 0xC844, 0xC878, 0xCB43, 0xCE38, 0xD198, 0xD34C,
    0xD78C, 0xDBFB, 0xDC8E, 0xDDD7, 0xDF43, 0xDF89, 0xDDF5, 0xDEE0, 0xDBA8, 0xD863, 0xD53C, 0xD144, 0xCFF6, 0xCA97, 0xC8F8, 0xC95F,
    0xC929, 0xC96C, 0xC761, 0xC8CB, 0xCA9C, 0xC980, 0xC8F3, 0xCC83, 0xCAC4, 0xCAB4, 0xCD25, 0xCD2C, 0xCBB2, 0xC7B2, 0xC6C9, 0xC785,
    0xC7C2, 0xC4CB, 0xC6A8, 0xCA00, 0xCDC8, 0xD080, 0xD18A, 0xD45E, 0xD96C, 0xDC65, 0xDB24, 0xDE91, 0xDF5B, 0xDE94, 0xDE88, 0xDE96,
    0xDD68, 0xDC34, 0xDD8B, 0xDFD4, 0xE4E1, 0xE447, 0xE9F5, 0xED73, 0xF219, 0xF6C3, 0xF7B6, 0xFB1F, 0xFB7A, 0xFE5A, 0xFCF6, 0xFDC0,
    0xFA55, 0xF9DA, 0xFAE9, 0xF8E2, 0xF467, 0xF2DE, 0xF38C, 0xEEC9, 0xEF24, 0xEDA3, 0xEFA0, 0xF10A, 0xEED0, 0xF0B3, 0xEFFE, 0xEED8,
    0xEE9E, 0xEDE2, 0xEE23, 0xEF44, 0xF106, 0xF1AB, 0xF534, 0xF71E, 0xF890, 0xFE29, 0x035B, 0x067B, 0x0BD3, 0x104F, 0x1293, 0x17E7,
    0x17BF, 0x165D, 0x17EC, 0x1566, 0x168C, 0x1267, 0x108D, 0x1023, 0x0F3A, 0x0FBB, 0x0C84, 0x0FF2, 0x1050, 0x1557, 0x18C5, 0x1C8D,
    0x20ED, 0x243F, 0x2780, 0x2B5C, 0x2EDD, 0x2CC0, 0x3106, 0x30CB, 0x354F, 0x35E1, 0x312C, 0x3331, 0x32FD, 0x332F, 0x2C87, 0x280E,
    0x26D4, 0x245A, 0x1EE3, 0x1AA0, 0x19AA, 0x17CA, 0x1852, 0x1640, 0x1895, 0x184E, 0x141C, 0x1427, 0x1642, 0x1641, 0x1152, 0x119A,
    0x1306, 0x125B, 0x1499, 0x110B, 0x12FA, 0x1778, 0x1920, 0x1B1C, 0x1E2E, 0x2124, 0x234D, 0x2878, 0x27C4, 0x2CEB, 0x3054, 0x32BB,
    0x37C2, 0x39A9, 0x3A30, 0x3B0A, 0x3C22, 0x3A34, 0x3CB3, 0x3BF8, 0x3D31, 0x3F63, 0x4127, 0x43E9, 0x4591, 0x483B, 0x4891, 0x4F7F,
    0x4FE1, 0x51B0, 0x55AA, 0x557A, 0x5746, 0x554F, 0x5470, 0x52C2, 0x5077, 0x4A26, 0x4C53, 0x4923, 0x4666, 0x44CD, 0x444A, 0x464C,
    0x4161, 0x4289, 0x3F73, 0x3FC9, 0x3C1C, 0x38A1, 0x3606, 0x3356, 0x3030, 0x2D10, 0x2BAF, 0x2821, 0x2AC7, 0x282D, 0x2A16, 0x2896,
    0x2756, 0x29BF, 0x28B2, 0x2B80, 0x29EA, 0x2BBF, 0x2B07, 0x2AC5, 0x2AB8, 0x2A64, 0x2A7F, 0x2895, 0x28FC, 0x28CB, 0x290F, 0x27E5,
    0x2BC7, 0x30AC, 0x3607, 0x3870, 0x3C28, 0x420D, 0x4221, 0x4362, 0x43AA, 0x41A1, 0x41B9, 0x3F86, 0x3BC4, 0x38EC, 0x354A, 0x30B2,
    0x2AD2, 0x263F, 0x207E, 0x1CA5, 0x1A19, 0x168F, 0x13BA, 0x12E9, 0x126A, 0x119C, 0x10F3, 0x0F44, 0x0FFC, 0x0BE7, 0x0C19, 0x0D95,
    0x091E, 0x0944, 0x09E4, 0x0AEB, 0x0CAA, 0x0D49, 0x0B76, 0x104D, 0x1234, 0x0F46, 0x0E39, 0x0DFE, 0x0F8B, 0x111B, 0x1075, 0x0F9B,
    0x14FD, 0x12D0, 0x1321, 0x13F1, 0x12DA, 0x0FEC, 0x0EAE, 0x0EF0, 0x0CDF, 0x0CB7, 0x0792, 0x0B34, 0x0F44, 0x0EB8, 0x0D48, 0x0F58,
    0x1262, 0x1411, 0x122B, 0x1058, 0x1523, 0x1437, 0x171C, 0x179D, 0x1871, 0x1850, 0x1476, 0x141E, 0x0EFD, 0x0B08, 0x0471, 0xFEAD,
    0xFBD3, 0xF7BA, 0xEFDC, 0xEAC7, 0xE828, 0xE75F, 0xE507, 0xDFD6, 0xDFBF, 0xDEE7, 0xE0E2, 0xDF49, 0xDD5B, 0xDE87, 0xDF6A, 0xDF1A,
    0xDFEE, 0xDEDB, 0xE06B, 0xE10E, 0xDE8F, 0xE1DA, 0xE1CD, 0xE2FD, 0xE206, 0xE4F0, 0xE5BA, 0xE546, 0xE319, 0xDEBF, 0xDF4E, 0xDA54,
    0xD6C7, 0xD343, 0xD65B, 0xD4D8, 0xD5CD, 0xD871, 0xD925, 0xDCEC, 0xD9FF, 0xDD35, 0xDD6A, 0xDF78, 0xDE5C, 0xE05C, 0xE1B6, 0xDF00,
    0xE1F9, 0xDE90, 0xDCF1, 0xDA19, 0xD7A2, 0xD40A, 0xD216, 0xCF0E, 0xCC47, 0xCEEF, 0xCC89, 0xCFC8, 0xD251, 0xD2D5, 0xD2E5, 0xD2AF,
    0xD4FF, 0xD195, 0xCFA1, 0xCCDC, 0xCCB3, 0xC942, 0xC451, 0xC4D2, 0xC1C5, 0xC251, 0xC10B, 0xC008, 0xC212, 0xC29C, 0xC299, 0xC253,
    0xC6B2, 0xC61D, 0xC6FA, 0xC7E4, 0xC86F, 0xCA32, 0xC780, 0xC630, 0xC3C3, 0xC486, 0xC0C1, 0xC19F, 0xC0E3, 0xC3CF, 0xC788, 0xC5D8,
    0xCA1E, 0xC866, 0xC9E7, 0xC878, 0xCA15, 0xC9D9, 0xC9EC, 0xCC77, 0xCD53, 0xCE4D, 0xCDC3, 0xCE88, 0xCC07, 0xCB47, 0xC888, 0xC7F2,
    0xC299, 0xBFAD, 0xC005, 0xBD17, 0xBADA, 0xB83A, 0xB8CC, 0xB929, 0xB6FA, 0xB430, 0xB3CE, 0xB1DD, 0xB481, 0xB3B8, 0xB34A, 0xB67C,
    0xB6CA, 0xBAB6, 0xBC6D, 0xBFE2, 0xC0E4, 0xC3C9, 0xC645, 0xC82A, 0xC9DF, 0xC7F2, 0xC97F, 0xCA4E, 0xCCD7, 0xC9E4, 0xCB75, 0xCCCF,
    0xCEFC, 0xD0D4, 0xCCF1, 0xCFD6, 0xD071, 0xD355, 0xD561, 0xD9DF, 0xDA9C, 0xDD3A, 0xE40A, 0xE377, 0xE672, 0xE83A, 0xEB64, 0xEEC0,
    0xF1EF, 0xF406, 0xF420, 0xF5A2, 0xF38B, 0xF3CC, 0xEF09, 0xE802, 0xE6DF, 0xE347, 0xE092, 0xDC2B, 0xDB2C, 0xD940, 0xDA8D, 0xD953,
    0xD490, 0xD924, 0xD5FE, 0xD5A7, 0xD3CB, 0xD4B4, 0xD439, 0xD0EE, 0xD2C1, 0xD128, 0xD3A3, 0xD1B2, 0xD38E, 0xD49E, 0xD5C8, 0xD7DD,
    0xD944, 0xDD33, 0xE0B2, 0xE6CD, 0xEA5E, 0xF1ED, 0xF553, 0xFA17, 0xFEEC, 0xFEF7, 0x014E, 0xFEE6, 0xFF62, 0xFB06, 0xF74D, 0xF938,
    0xF947, 0xFAB4, 0xFB0C, 0xFF1B, 0x01C8, 0x04BA, 0x06D6, 0x0751, 0x0E1C, 0x120B, 0x14E3, 0x19B1, 0x1BB8, 0x1DD4, 0x1E04, 0x1EE5,
    0x1D92, 0x1D8E, 0x1A51, 0x1B5A, 0x1ED0, 0x19FA, 0x1B10, 0x18A1, 0x1AE6, 0x199C, 0x18EF, 0x17E4, 0x151B, 0x16A1, 0x1348, 0x159D,
    0x1342, 0x141F, 0x139D, 0x16DA, 0x1823, 0x19F3, 0x1D89, 0x1CBF, 0x2394, 0x2381, 0x277D, 0x26F9, 0x28A9, 0x2E36, 0x2E7E, 0x2FC8,
    0x2E26, 0x329D, 0x32A7, 0x31D4, 0x3162, 0x2F8E, 0x31AC, 0x3100, 0x320D, 0x33C7, 0x37D1, 0x3CA3, 0x3EF4, 0x4334, 0x4659, 0x492E,
    0x47F2, 0x472A, 0x4A55, 0x49E0, 0x4742, 0x4713, 0x486D, 0x4792, 0x469B, 0x4222, 0x3FE5, 0x402C, 0x3CA7, 0x3B87, 0x38F9, 0x39B5,
    0x38CA, 0x35D6, 0x33EF, 0x3084, 0x3085, 0x2CF4, 0x2E38, 0x2D7F, 0x2C22, 0x2ADA, 0x2A03, 0x2A34, 0x26D0, 0x24DE, 0x210D, 0x2297,
    0x212F, 0x201F, 0x1F87, 0x200C, 0x22E3, 0x2250, 0x2475, 0x26DB, 0x277A, 0x2C62, 0x2D03, 0x2C24, 0x2E25, 0x2C6D, 0x2B24, 0x2755,
    0x289B, 0x26D5, 0x24F6, 0x24BC, 0x28D6, 0x2BC1, 0x2935, 0x2D68, 0x3207, 0x3704, 0x37D2, 0x3DEC, 0x4273, 0x4A58, 0x4EEF, 0x4E41,
    0x55C5, 0x55DC, 0x57DA, 0x53A9, 0x5370, 0x50E4, 0x4C40, 0x4A64, 0x42CA, 0x43E3, 0x3CE1, 0x3B01, 0x37CF, 0x356B, 0x3232, 0x2EB9,
    0x2F58, 0x2B95, 0x2E72, 0x28BB, 0x28E9, 0x25C3, 0x2363, 0x21D7, 0x1F18, 0x21EB, 0x206D, 0x2675, 0x2561, 0x2654, 0x28EA, 0x2B3E,
    0x2C75, 0x2AD5, 0x2DEC, 0x2DDE, 0x3047, 0x2E0C, 0x2CA1, 0x2C40, 0x28A5, 0x28A4, 0x26E9, 0x25A3, 0x2316, 0x2408, 0x2647, 0x26CB,
    0x27D8, 0x2810, 0x2C8E, 0x2D69, 0x2F0F, 0x2E37, 0x2E41, 0x306D, 0x2F27, 0x2FCC, 0x2E03, 0x2D09, 0x2A77, 0x29EB, 0x2876, 0x258C,
    0x2335, 0x2351, 0x2407, 0x240E, 0x2306, 0x22D5, 0x2353, 0x219E, 0x224C, 0x1FB9, 0x1CA1, 0x1A0C, 0x1869, 0x159B, 0x127B, 0x0C99,
    0x09DD, 0x099A, 0x0663, 0x0819, 0x05F8, 0x08BE, 0x0B65, 0x0C9D, 0x0E8D, 0x0D6E, 0x1045, 0x0FFC, 0x1294, 0x1257, 0x1587, 0x1770,
    0x166E, 0x1813, 0x1648, 0x1513, 0x0E15, 0x0ECE, 0x0B52, 0x0B20, 0x0862, 0x057C, 0x085F, 0x03E8, 0x06B9, 0x03BC, 0x057D, 0x0569,
    0x07E0, 0x076D, 0x06CE, 0x0975, 0x060D, 0x06C7, 0x0103, 0xFEDF, 0xFA7D, 0xF6C0, 0xF049, 0xED2E, 0xEA6B, 0xE38B, 0xE1CC, 0xDE00,
    0xDC3B, 0xD7BF, 0xD5B6, 0xD5FC, 0xD7BF, 0xD92E, 0xD7B9, 0xD7EF, 0xD9A9, 0xD85B, 0xD69C, 0xD5F9, 0xD5CE, 0xD66D, 0xD423, 0xD40F,
    0xD443, 0xD3C7, 0xCFF6, 0xCEFA, 0xD019, 0xCCEE, 0xCD7C, 0xCD8C, 0xD05E, 0xD0A2, 0xCF20, 0xCD20, 0xCDD7, 0xCBC4, 0xC6DF, 0xC88E,
    0xC755, 0xCB4B, 0xCA98, 0xCFCC, 0xD182, 0xD39C, 0xD894, 0xD7AF, 0xDCFB, 0xDACE, 0xDF82, 0xDEB7, 0xDE4B, 0xDDD8, 0xDB81, 0xDD4E,
    0xD7FA, 0xD810, 0xD3A5, 0xD0CD, 0xCE16, 0xCB82, 0xCA48, 0xC6B9, 0xC754, 0xC5C9, 0xC902, 0xC647, 0xC3E1, 0xC46C, 0xC34F, 0xC2FC,
    0xC004, 0xBE6E, 0xBAC1, 0xBB1C, 0xB66A, 0xB54E, 0xB4C5, 0xB3E3, 0xB689, 0xB716, 0xBA54, 0xB89C, 0xBDE8, 0xBECB, 0xC080, 0xC251,
    0xC0A4, 0xC5C8, 0xC44D, 0xC5AB, 0xC456, 0xC187, 0xBDA4, 0xBA27, 0xB9F9, 0xB52F, 0xB46F, 0xB51B, 0xB87E, 0xB9FD, 0xBC4E, 0xBCAB,
    0xBDC5, 0xC2A1, 0xC278, 0xC493, 0xC5CF, 0xC939, 0xCB86, 0xCD63, 0xCDEC, 0xCD8F, 0xCCF5, 0xCBB3, 0xCB0C, 0xC8D4, 0xC4BB, 0xBF98,
    0xBEF8, 0xBA58, 0xB8D8, 0xB47A, 0xB436, 0xB403, 0xB295, 0xB389, 0xAFF0, 0xB357, 0xB0C9, 0xB27F, 0xB1A5, 0xB2B0, 0xB44F, 0xB2AD,
    0xB655, 0xB653, 0xB955, 0xB965, 0xBAFA, 0xBD58, 0xBF80, 0xBF2E, 0xBEEE, 0xC20C, 0xC4B7, 0xC82C, 0xC9CF, 0xCE8C, 0xD133, 0xD484,
    0xD519, 0xD674, 0xD91F, 0xD9E3, 0xDDE4, 0xDE75, 0xE3EC, 0xE6B8, 0xE97F, 0xE987, 0xE913, 0xED15, 0xEB23, 0xEC5C, 0xEC0A, 0xEF85,
    0xF16F, 0xF0E2, 0xF20A, 0xEF71, 0xEF23, 0xEAA0, 0xE706, 0xE749, 0xE3AA, 0xE1C9, 0xE138, 0xE1D0, 0xE25D, 0xE047, 0xE0F2, 0xE252,
    0xE272, 0xE137, 0xE10C, 0xE19C, 0xDEE0, 0xDCC6, 0xDCE2, 0xDB1F, 0xDB60, 0xDA2F, 0xDAC9, 0xDE03, 0xDDFD, 0xDEE4, 0xDFA6, 0xE3DD,
    0xE51B, 0xE790, 0xE933, 0xEB7B, 0xF01F, 0xF0D5, 0xF507, 0xF47B, 0xF634, 0xF577, 0xF426, 0xF37B, 0xEF6F, 0xF0BA, 0xF109, 0xF2D0,
    0xF7BF, 0xFC22, 0x008E, 0x05E8, 0x0B44, 0x1176, 0x13C4, 0x1909, 0x1F9C, 0x2558, 0x29E4, 0x2994, 0x2E40, 0x2D55, 0x2B75, 0x29FE,
    0x2555, 0x23D5, 0x1F8D, 0x2067, 0x1F98, 0x1ECB, 0x1D43, 0x1AB4, 0x1E51, 0x1A97, 0x197F, 0x18C5, 0x19CE, 0x1DAB, 0x1AD2, 0x1B9E,
    0x1C6F, 0x1E6A, 0x20D1, 0x2008, 0x24AD, 0x2596, 0x2705, 0x296D, 0x28BC, 0x2ABE, 0x2773, 0x2986, 0x2D51, 0x2D9B, 0x2EE7, 0x2E55,
    0x31FD, 0x326B, 0x2EF9, 0x2E54, 0x2B36, 0x2D63, 0x2CBF, 0x2B1C, 0x2E73, 0x2DC5, 0x335E, 0x329C, 0x34A4, 0x3618, 0x3511, 0x3891,
    0x3573, 0x3A4E, 0x399E, 0x3B21, 0x402C, 0x4017, 0x4417, 0x4104, 0x4108, 0x420E, 0x3F89, 0x3FEA, 0x3D23, 0x3EBD, 0x3EC2, 0x3B7D,
    0x3C33, 0x377D, 0x356A, 0x31E7, 0x2DA5, 0x2E21, 0x299D, 0x29F4, 0x273A, 0x2548, 0x25EB, 0x2238, 0x231C, 0x2045, 0x21B9, 0x2148,
    0x20AB, 0x23F5, 0x2368, 0x27E1, 0x2909, 0x2B3D, 0x3105, 0x335D, 0x3662, 0x3668, 0x3A71, 0x3BC3, 0x36C3, 0x3801, 0x33F5, 0x34F9,
    0x33BC, 0x3132, 0x35DA, 0x3433, 0x37C8, 0x37CC, 0x3AF0, 0x3DE7, 0x3C68, 0x42F5, 0x443E, 0x4829, 0x4BA7, 0x4A4F, 0x4EC6, 0x4D54,
    0x4DA0, 0x4CD9, 0x481E, 0x45D1, 0x3FCA, 0x3F08, 0x3A4F, 0x3686, 0x35ED, 0x3453, 0x35E9, 0x31F8, 0x307C, 0x2F84, 0x2D84, 0x2DB7,
    0x2D0A, 0x2C1D, 0x2AB8, 0x2A48, 0x28E7, 0x2417, 0x217D, 0x1ED4, 0x1B7E, 0x1CF1, 0x1A0A, 0x19DD, 0x19F7, 0x1984, 0x1A92, 0x181E,
    0x1C97, 0x19D1, 0x1B81, 0x1C5A, 0x1C45, 0x1E77, 0x173A, 0x1932, 0x1738, 0x1824, 0x14C7, 0x14FD, 0x18FD, 0x186F, 0x1B6C, 0x18F1,
    0x1B74, 0x195E, 0x1942, 0x19BA, 0x19E1, 0x19D1, 0x1A92, 0x1E11, 0x1C7B, 0x1A8C, 0x1836, 0x17BF, 0x147D, 0x12B3, 0x0F7C, 0x0DBF,
    0x0ED0, 0x0AE9, 0x0C94, 0x0AF6, 0x0982, 0x0873, 0x05CF, 0x05B0, 0x0233, 0x021C, 0xFE04, 0xFE44, 0xFF63, 0xFDA7, 0xFD78, 0xFDC1,
    0x0007, 0xFFF2, 0x02A4, 0x02B4, 0x07A3, 0x0B03, 0x0CE0, 0x0F6C, 0x0EC8, 0x11FB, 0x117F, 0x1268, 0x1293, 0x1168, 0x11A5, 0x0F2B,
    0x0D75, 0x09D9, 0x0625, 0x0514, 0x022C, 0x007C, 0xFF83, 0xFDE1, 0x0020, 0xFE7F, 0xFEC6, 0x0079, 0x0164, 0x04B4, 0x047E, 0x095E,
    0x0978, 0x0BF9, 0x0C84, 0x0B01, 0x0A96, 0x0534, 0x0211, 0xFB10, 0xF925, 0xF412, 0xF0CE, 0xEC6A, 0xE97D, 0xE7FE, 0xE377, 0xE035,
    0xDC5F, 0xDD2B, 0xD991, 0xD8A9, 0xD56A, 0xD862, 0xD72C, 0xD457, 0xD3B7, 0xD0CC, 0xD38D, 0xCD6B, 0xCFC5, 0xCC8B, 0xCD9C, 0xCF74,
    0xCC8A, 0xD280, 0xCF2A, 0xD45D, 0xD574, 0xDA2E, 0xDD67, 0xDC13, 0xE3D6, 0xE3AA, 0xE640, 0xE349, 0xE27B, 0xE338, 0xE212, 0xE1E4,
    0xE1D5, 0xE478, 0xE53A, 0xE5A9, 0xE711, 0xEA19, 0xE80C, 0xEA73, 0xEB7F, 0xF085, 0xF237, 0xEF2F, 0xF36A, 0xF0A0, 0xF253, 0xF109,
    0xEE53, 0xEDE0, 0xEB56, 0xEF02, 0xEB24, 0xEAB1, 0xE9B9, 0xE720, 0xE8E0, 0xE29D, 0xE0F6, 0xDE41, 0xDBCE, 0xD88D, 0xD5B0, 0xD4A4,
    0xCF9C, 0xCEC8, 0xCACC, 0xCA30, 0xC966, 0xC59C, 0xC723, 0xC7F6, 0xCA58, 0xCA4A, 0xCA27, 0xCD7F, 0xCCAA, 0xCF21, 0xCFA4, 0xCF20,
    0xD127, 0xCEDF, 0xD148, 0xCFE0, 0xCD8C, 0xCD21, 0xCB8C, 0xCD60, 0xCBA8, 0xCC30, 0xD017, 0xD1C8, 0xD5B1, 0xD822, 0xD9C9, 0xDE71,
    0xDE1F, 0xE2A4, 0xE24D, 0xE39F, 0xE667, 0xE647, 0xE885, 0xE501, 0xE841, 0xE3FB, 0xE0F2, 0xE003, 0xDBC4, 0xDA1D, 0xD6FA, 0xD57E,
    0xD25A, 0xD296, 0xD058, 0xCE91, 0xCDF6, 0xCD4C, 0xCEE4, 0xCE84, 0xCE8E, 0xCF24, 0xCFF7, 0xCE94, 0xCEAB, 0xCEB6, 0xCF40, 0xCE7D,
    0xCE64, 0xCF50, 0xCF7D, 0xD12B, 0xD09A, 0xD3CC, 0xD377, 0xD6FB, 0xD95D, 0xDBE5, 0xDFA8, 0xE135, 0xE5E0, 0xE6F5, 0xE968, 0xE81D,
    0xE993, 0xEB24, 0xEA9B, 0xEA4A, 0xEC01, 0xEE50, 0xEFA6, 0xF19A, 0xEFB1, 0xF319, 0xF231, 0xF51D, 0xF729, 0xF954, 0xFE03, 0xFDF2,
    0x0536, 0x039A, 0x0677, 0x02FD, 0x0105, 0x01FC, 0xFAC9, 0xFB4C, 0xF655, 0xF6BC, 0xF28B, 0xF03B, 0xEDFC, 0xEBDB, 0xEAAD, 0xE5C6,
    0xE8C0, 0xE3AE, 0xE167, 0xDDAD, 0xDD9D, 0xDBF8, 0xD790, 0xD93F, 0xD8C2, 0xDD57, 0xDCDC, 0xDEFD, 0xE06A, 0xE20F, 0xE3EB, 0xE475,
    0xE712, 0xE572, 0xE9F4, 0xE98E, 0xEAEB, 0xE8CF, 0xE66D, 0xE93A, 0xE3BE, 0xE62C, 0xDF98, 0xE1B7, 0xE28A, 0xE0E7, 0xE7D3, 0xE6D1,
    0xEE86, 0xEE45, 0xF674, 0xF9B1, 0xFB18, 0xFFC0, 0x00E5, 0x080C, 0x07F7, 0x0C25, 0x0D15, 0x0F78, 0x0DCF, 0x0E66, 0x0D6D, 0x0A93,
    0x0BD1, 0x093F, 0x0D77, 0x0C33, 0x0E82, 0x0E14, 0x0FCE, 0x11D0, 0x0F03, 0x120C, 0x0D6D, 0x0F24, 0x0D40, 0x0B78, 0x0A4C, 0x087B,
    0x09DA, 0x06D6, 0x0976, 0x07B6, 0x07A4, 0x083D, 0x06A4, 0x0622, 0x054A, 0x06B6, 0x087B, 0x0B2D, 0x0E39, 0x1178, 0x1300, 0x1121,
    0x12DC, 0x1434, 0x1155, 0x109F, 0x0E04, 0x0E28, 0x0D22, 0x0ABA, 0x0BDA, 0x0CF1, 0x0D26, 0x0C3B, 0x0E6E, 0x0F58, 0x0F0C, 0x0EA9,
    0x0FC9, 0x10D8, 0x1443, 0x15FA, 0x1732, 0x1A27, 0x18E9, 0x18F6, 0x153B, 0x1415, 0x10DA, 0x0D21, 0x0DC5, 0x0B35, 0x0A79, 0x0768,
    0x058B, 0x053C, 0x028D, 0x012C, 0xFE66, 0xFF88, 0x0147, 0x005A, 0x024D, 0x02A8, 0x0450, 0x06F9, 0x0835, 0x0AEA, 0x0CBA, 0x0DD9,
    0x10A4, 0x133B, 0x1445, 0x15B7, 0x1872, 0x1AFF, 0x1CDB, 0x1F54, 0x2113, 0x1ED6, 0x1CCA, 0x1B37, 0x191E, 0x1521, 0x1345, 0x14FF,
    0x171B, 0x1961, 0x19BB, 0x1DE1, 0x2291, 0x25CC, 0x26EC, 0x2AF1, 0x2F38, 0x314B, 0x33EF, 0x3532, 0x36A7, 0x37AD, 0x3596, 0x353E,
    0x3348, 0x2E00, 0x2993, 0x247A, 0x225D, 0x1BAE, 0x1B21, 0x17EF, 0x16EA, 0x179F, 0x1301, 0x1334, 0x0DF0, 0x0DEA, 0x09E7, 0x0729,
    0x0297, 0x00E4, 0x00F8, 0xFAFE, 0xFAAB, 0xF7DA, 0xF8BB, 0xF60F, 0xF82F, 0xF76F, 0xFACC, 0xFCEF, 0xFD03, 0x0552, 0x0509, 0x0C3D,
    0x0ACC, 0x1073, 0x1373, 0x114F, 0x1276, 0x0DF9, 0x12FB, 0x0C7D, 0x0CAA, 0x0BC4, 0x0D31, 0x10C6, 0x0E80, 0x1186, 0x0FCB, 0x1266,
    0x0FF4, 0x13A6, 0x14A0, 0x15F8, 0x19B3, 0x1BE5, 0x2155, 0x2069, 0x2371, 0x214B, 0x2325, 0x21BC, 0x1FCD, 0x1E8A, 0x1A34, 0x1A8C,
    0x1552, 0x1534, 0x1154, 0x0FB4, 0x0F3B, 0x0A19, 0x0887, 0x03B4, 0x03EF, 0xFE14, 0xFCF0, 0xFD67, 0xFCAC, 0x000C, 0xFC49, 0x0004,
    0x0101, 0x0258, 0x0227, 0x0213, 0x056F, 0x055A, 0x0786, 0x08B9, 0x0B9D, 0x0CE3, 0x0D2C, 0x0E5A, 0x1078, 0x0F4C, 0x0E04, 0x0CC0,
    0x0C9C, 0x0FA9, 0x0CDB, 0x0E1E, 0x0FE8, 0x1254, 0x1497, 0x13C7, 0x1706, 0x1715, 0x193B, 0x19E9, 0x1C77, 0x20ED, 0x200F, 0x2381,
    0x25A8, 0x2475, 0x226B, 0x1DC5, 0x1A1E, 0x1576, 0x11B4, 0x0DE9, 0x0A04, 0x0875, 0x0489, 0x043B, 0x034E, 0xFFF7, 0xFEFF, 0xFE44,
    0xFDF8, 0xFB49, 0xF749, 0xF488, 0xF32C, 0xF075, 0xED64, 0xEBBB, 0xE89E, 0xE693, 0xE4A1, 0xE2FA, 0xE02E, 0xDF4D, 0xE0FC, 0xE323,
    0xE563, 0xE7EB, 0xEC80, 0xEF6D, 0xF3FA, 0xF48B, 0xF678, 0xF63A, 0xF5EC, 0xFB29, 0xFB12, 0xF9E7, 0xF923, 0xF966, 0xF9EF, 0xF891,
    0xFAF3, 0xFB21, 0xFCB8, 0x025D, 0x0330, 0x0A90, 0x0BAE, 0x1132, 0x15FD, 0x1890, 0x19AB, 0x0AC4, 0x0E37, 0x16AA, 0x1CD4, 0x190C,
    0x15F1, 0x1C3F, 0x1CEB, 0x1EBB, 0x16F9, 0x1301, 0x10A9, 0x0F04, 0x0960, 0x050F, 0x03AC, 0x0124, 0x010D, 0xFBB5, 0xF8CE, 0xF406,
    0xF082, 0xECE4, 0xEEA5, 0xEF85, 0xFA15, 0x0600, 0x00D2, 0x0070, 0xFC89, 0xFC74, 0xFC2E, 0xFC8A, 0xFECE, 0xF89D, 0xF996, 0xF9F3,
    0xF8FA, 0xF264, 0xECDE, 0xE9C3, 0xE64D, 0xEBC5, 0xECBE, 0xED5E, 0xEC9D, 0xEF2E, 0xF40E, 0xF2A8, 0xF0AD, 0xED99, 0xED29, 0xEF88,
    0xF15F, 0xECCA, 0xE7E5, 0xE266, 0xE63D, 0xF228, 0xF534, 0xF636, 0xF31A, 0xF6B6, 0xF8E3, 0xFD8D, 0xFA74, 0xF02D, 0xF471, 0xF4E7,
    0xF6B8, 0xF169, 0xF0B3, 0xF38C, 0xF5FB, 0xFED3, 0xFEA2, 0xFA7A, 0xF6A2, 0xF8FE, 0xFC1A, 0xF8B4, 0xF5C6, 0xF4D6, 0xF018, 0xF49E,
    0x024C, 0x0320, 0x0022, 0x013D, 0x04B4, 0x041B, 0x0460, 0x06E8, 0x0636, 0x0B41, 0x13B9, 0x1AC3, 0x14CE, 0x0F2C, 0x0E04, 0x0C17,
    0x090C, 0x0422, 0x0379, 0xFE19, 0xFF2D, 0x0923, 0x0A84, 0x03DC, 0xFDFD, 0xFB04, 0xF97F, 0xF6D3, 0xF463, 0xF00C, 0xF200, 0xF9BB,
    0xF7F1, 0xF0D8, 0xEA02, 0xE5D9, 0xE02D, 0xD9EC, 0xDA35, 0xDB11, 0xDE82, 0xE5DD, 0xEB44, 0xED75, 0xEBB9, 0xEA49, 0xE85A, 0xE84F,
    0xEB35, 0xEE08, 0xEEDA, 0xEEB6, 0xF530, 0xF678, 0xF11A, 0xEE69, 0xEC7F, 0xEFA3, 0xF380, 0xF3D7, 0xF4A4, 0xFA71, 0x00C4, 0x0243,
    0x028F, 0x014D, 0xFEB0, 0xFE70, 0xFBCB, 0xF9FB, 0xFBC6, 0xFA44, 0xFF7C, 0x01CB, 0xFD75, 0xFD78, 0xFED1, 0xFF96, 0xFB20, 0xFC50,
    0x0061, 0x0374, 0x052E, 0x0435, 0x0724, 0x06D4, 0x0039, 0xFA59, 0xF974, 0xF783, 0xF686, 0xF564, 0xF5C3, 0xF8EE, 0xF940, 0xF708,
    0xF600, 0xF57F, 0xF437, 0xF61E, 0xF961, 0xFC77, 0xFD3F, 0xFF6E, 0x00AB, 0x027C, 0x0121, 0xFC66, 0xFD51, 0xFDD6, 0xFFC2, 0xFE15,
    0xFD32, 0x0013, 0x026C, 0x050B, 0x0313, 0x03C5, 0x05EE, 0x06D0, 0x0795, 0x098C, 0x0A9F, 0x0B3E, 0x0DD4, 0x10E9, 0x1469, 0x135D,
    0x11D4, 0x102E, 0x1168, 0x0ED6, 0x0881, 0x0479, 0x0077, 0x0050, 0xFD55, 0xFB83, 0xF9F0, 0xFA3A, 0xF8C8, 0xF645, 0xF5E0, 0xF385,
    0xF5A8, 0xF56D, 0xF78D, 0xF95B, 0xF96A, 0xFAA3, 0xF9B2, 0xF908, 0xF50A, 0xF225, 0xEFB6, 0xEE55, 0xED8C, 0xEC28, 0xEBCC, 0xE96D,
    0xEBB7, 0xEBEE, 0xEB9D, 0xECC5, 0xED4C, 0xF255, 0xF1FF, 0xF412, 0xF5C8, 0xF7F1, 0xF99B, 0xF736, 0xF6AD, 0xF6E6, 0xF825, 0xF6E7,
    0xF55B, 0xF6D6, 0xFB93, 0xFD50, 0xFF2D, 0x01BC, 0x0530, 0x0820, 0x0A40, 0x0CD2, 0x0D07, 0x0DE5, 0x0E4E, 0x10D4, 0x115D, 0x1034,
    0x1116, 0x10ED, 0x1118, 0x0F20, 0x0FEA, 0x107D, 0x0F0F, 0x0EE9, 0x0BDB, 0x0CA0, 0x0A1A, 0x04AB, 0x0504, 0x048D, 0x05DB, 0x050F,
    0x0491, 0x0788, 0x071B, 0x08F8, 0x05F3, 0x0406, 0x05CB, 0x053F, 0x083B, 0x056D, 0x048B, 0x06CA, 0x0505, 0x0225, 0xFC79, 0xFC19,
    0xFBAC, 0xF679, 0xF4BE, 0xF425, 0xF68A, 0xF57A, 0xF192, 0xF36B, 0xF468, 0xF6BC, 0xF2DC, 0xF2E0, 0xF6AA, 0xF5F5, 0xF846, 0xF5B3,
    0xF74F, 0xF784, 0xF6F7, 0xF4B1, 0xF153, 0xF3E9, 0xF2CD, 0xF434, 0xF4E7, 0xF606, 0xFA11, 0xF9A5, 0xF978, 0xFB19, 0xF8C3, 0xFA40,
    0xF9E0, 0xF963, 0xFA9A, 0xFA37, 0xFEDF, 0xFB93, 0xFE83, 0x0050, 0x0229, 0x070C, 0x0379, 0x077C, 0x04F0, 0x0686, 0x02C6, 0xFDD7,
    0xFF4F, 0xFD56, 0x0275, 0xFE87, 0x0037, 0x0321, 0x03C0, 0x0396, 0x012E, 0x059A, 0x08B6, 0x0B80, 0x0DC9, 0x1146, 0x150C, 0x167A,
    0x1295, 0x1401, 0x120D, 0x10CB, 0x1046, 0x0AC9, 0x0E58, 0x0B72, 0x0C81, 0x0741, 0x0501, 0x0856, 0x038A, 0x06C0, 0x00A4, 0x0369,
    0x04C4, 0x0213, 0x01E9, 0xFC7A, 0xFF79, 0xFB9C, 0xFB14, 0xF63F, 0xF414, 0xF6F1, 0xF24F, 0xF2AF, 0xF250, 0xF58A, 0xF6F8, 0xF6AA,
    0xF74F, 0xF88A, 0xF9ED, 0xF8E8, 0xF6D7, 0xF935, 0xF95C, 0xF635, 0xF83B, 0xF51D, 0xF86D, 0xF629, 0xF58A, 0xF9B2, 0xF65F, 0xF99F,
    0xF5EB, 0xF883, 0xF5A5, 0xF21A, 0xF689, 0xF430, 0xF760, 0xF54B, 0xF997, 0xFCAB, 0xFA95, 0xFCB7, 0xFDDA, 0x0330, 0x0513, 0x05FA,
    0x09C9, 0x0E96, 0x116E, 0x10F4, 0x0FF8, 0x10CE, 0x10C9, 0x0FDB, 0x0BC6, 0x0A1A, 0x0AEE, 0x07B8, 0x06F4, 0x0417, 0x04DD, 0x04DD,
    0x02A9, 0x0252, 0x01F6, 0x059D, 0x02D0, 0x01C5, 0x0403, 0x0440, 0x0562, 0x023D, 0x0227, 0x02D4, 0x0121, 0x006F, 0xFF21, 0x0103,
    0x0192, 0x028A, 0x03FD, 0x03F8, 0x063D, 0x053D, 0x04B4, 0x057B, 0x057A, 0x0436, 0x0343, 0x048F, 0x031B, 0x02D5, 0x04BE, 0x0569,
    0x0743, 0x08D9, 0x0AA5, 0x0CAC, 0x0A64, 0x095B, 0x07E7, 0x078B, 0x072F, 0x063A, 0x06BE, 0x0396, 0x06AB, 0x0623, 0x038B, 0x030A,
    0x0301, 0x05C9, 0x0476, 0x05F5, 0x04DA, 0x0899, 0x07C3, 0x041A, 0x0463, 0x0124, 0x00FD, 0xFAE8, 0xF939, 0xF6DB, 0xF4E7, 0xF306,
    0xEE48, 0xF074, 0xEE11, 0xEC7F, 0xECFD, 0xEC3D, 0xED55, 0xEFE4, 0xEF97, 0xF198, 0xF368, 0xF2AE, 0xF3F1, 0xF1FE, 0xF2DB, 0xEF16,
    0xF176, 0xF20F, 0xF01F, 0xF369, 0xF0BD, 0xF6F4, 0xF724, 0xF8B2, 0xFA23, 0xFB83, 0x01CE, 0xFF16, 0x0296, 0x020D, 0x0640, 0x0748,
    0x0599, 0x0A77, 0x096F, 0x0ED3, 0x0F16, 0x1355, 0x15BE, 0x157C, 0x17D1, 0x14EB, 0x1594, 0x148A, 0x1551, 0x1411, 0x12EF, 0x13EA,
    0x15B8, 0x11DF, 0x0F6F, 0x0DCA, 0x0D08, 0x0F30, 0x0923, 0x0C30, 0x0B3E, 0x0DB8, 0x0B84, 0x05F0, 0x09D1, 0x0441, 0x058A, 0xFDF9,
    0xFC9E, 0xFBFE, 0xF734, 0xF7E1, 0xF08F, 0xF225, 0xEF79, 0xEEC1, 0xED41, 0xEAAC, 0xEEDE, 0xEE22, 0xEE7A, 0xEEBE, 0xEFC4, 0xF23D,
    0xF14B, 0xEF80, 0xEF85, 0xEEA1, 0xF054, 0xEE84, 0xEE13, 0xEFFD, 0xF00F, 0xF45E, 0xF253, 0xF678, 0xF927, 0xF9B7, 0xFCF4, 0xFB7F,
    0xFF61, 0xFE8E, 0x013D, 0x00BC, 0x0022, 0x05CF, 0x0663, 0x08E5, 0x07F5, 0x0BAF, 0x1012, 0x0E5F, 0x0D41, 0x0CB0, 0x0FC6, 0x0D07,
    0x0A50, 0x0B29, 0x0A3A, 0x0BBF, 0x0966, 0x05CA, 0x06D5, 0x05A4, 0x05F0, 0x05D0, 0x05BF, 0x0AB4, 0x0B6E, 0x0F85, 0x0D2F, 0x0EC9,
    0x12D4, 0x0F86, 0x10D0, 0x0B84, 0x0E3A, 0x0E3C, 0x0985, 0x06BE, 0x0561, 0x0873, 0x0281, 0x00E5, 0x0054, 0x01CF, 0x01C3, 0xFE7E,
    0xFFCC, 0x0155, 0x04B0, 0x0190, 0x0049, 0x00A5, 0x01A7, 0xFFF3, 0xFC82, 0xFC5E, 0xFD59, 0xFE84, 0xFDB9, 0xFDEF, 0xFDD8, 0x0195,
    0x00CB, 0x0267, 0x02DA, 0x026D, 0x045D, 0x00D8, 0x01D6, 0xFCBC, 0xFC8F, 0xFD96, 0xF9BE, 0xFB42, 0xF814, 0xFC36, 0xF948, 0xF6D1,
    0xF747, 0xF48B, 0xF666, 0xF1A6, 0xF42A, 0xF468, 0xF656, 0xF4A9, 0xF364, 0xF509, 0xF350, 0xF4C9, 0xF19D, 0xF45A, 0xF72B, 0xFC79,
    0xFD04, 0xFE8A, 0x035D, 0x0419, 0x0803, 0x056A, 0x08C3, 0x09F1, 0x0A9B, 0x0937, 0x0788, 0x0AAD, 0x06D8, 0x080F, 0x0431, 0x078E,
    0x072C, 0x0566, 0x07D4, 0x06E8, 0x0DEA, 0x0BD0, 0x0EDF, 0x0E42, 0x1002, 0x1347, 0x0E33, 0x1054, 0x0D05, 0x0E35, 0x0C67, 0x0A2E,
    0x0B8C, 0x084F, 0x0B2C, 0x0B67, 0x0A96, 0x0C58, 0x0C98, 0x0CA2, 0x0AB7, 0x08AB, 0x0A48, 0x06B9, 0x062F, 0x06A7, 0x062A, 0x0895,
    0x03E8, 0x079D, 0x060E, 0x03C3, 0x056A, 0x01D6, 0x048A, 0x00E6, 0x01A3, 0x0328, 0x0124, 0x01BF, 0xFDFF, 0xFE7C, 0xFEDB, 0xFB3A,
    0xFC27, 0xFCA2, 0xFE37, 0xFF7A, 0x0038, 0x0507, 0x0414, 0x0463, 0x05E8, 0x07B9, 0x08AB, 0x061A, 0x05D6, 0x0700, 0x0597, 0x0353,
    0xFF63, 0xFEA4, 0xFDB7, 0xFBF8, 0xFB15, 0xF89D, 0xF94E, 0xF870, 0xF7E5, 0xF665, 0xF881, 0xF898, 0xF85B, 0xF5F0, 0xF5A6, 0xF51A,
    0xF1E4, 0xF274, 0xEF7D, 0xF1B3, 0xF015, 0xF080, 0xF0F3, 0xF290, 0xF65F, 0xF50A, 0xF8B2, 0xF9AA, 0xFB52, 0xFC0C, 0xFBD3, 0xFB70,
    0xFDD1, 0xFFFF, 0x007B, 0x03EA, 0x0576, 0x0B21, 0x0A38, 0x0C16, 0x0BB5, 0x0F01, 0x1170, 0x0FBD, 0x14EC, 0x1449, 0x17E4, 0x1715,
    0x15B8, 0x15C7, 0x1621, 0x1607, 0x136F, 0x15D6, 0x17C1, 0x17E9, 0x1820, 0x1825, 0x1A1D, 0x1B12, 0x1A84, 0x1948, 0x1935, 0x18CE,
    0x165A, 0x1405, 0x1010, 0x0DD0, 0x0B35, 0x074E, 0x031E, 0xFF04, 0xFD16, 0xFB46, 0xF94D, 0xF54C, 0xF599, 0xF636, 0xF51C, 0xF2F4,
    0xF0FB, 0xF259, 0xEF56, 0xEE89, 0xE9A4, 0xEA8E, 0xE9FF, 0xE7A8, 0xE63F, 0xE588, 0xEB1F, 0xEA64, 0xEAEB, 0xEB9E, 0xF1F9, 0xF311,
    0xF179, 0xF2A9, 0xF549, 0xF7CA, 0xF675, 0xF971, 0xFAF0, 0x0069, 0x0116, 0x01EF, 0x05D0, 0x068E, 0x0A3A, 0x0A6B, 0x0E47, 0x0F76,
    0x12B4, 0x1594, 0x1559, 0x1700, 0x1582, 0x1705, 0x1674, 0x12CA, 0x1264, 0x1561, 0x1544, 0x123B, 0x117F, 0x16B9, 0x168E, 0x154F,
    0x14FD, 0x155A, 0x190A, 0x15D7, 0x1362, 0x1245, 0x1169, 0x130B, 0x0C26, 0x0A08, 0x09D0, 0x06CA, 0x052C, 0xFE15, 0xFFD8, 0xFF6A,
    0xFE61, 0xFC90, 0xF925, 0xFDA1, 0xFB65, 0xF84E, 0xF7FB, 0xF620, 0xF8FE, 0xF61A, 0xF23C, 0xF364, 0xF229, 0xF4F3, 0xF39E, 0xF3F1,
    0xF774, 0xF815, 0xFE36, 0xFACC, 0xFCCC, 0xFE6E, 0xFDAC, 0x0267, 0xFDE3, 0x0230, 0x03F3, 0x0639, 0x05A0, 0x041D, 0x07BB, 0x0667,
    0x04AD, 0x029F, 0x039A, 0x06A6, 0x056A, 0x006E, 0x031E, 0x0333, 0x0249, 0xFD45, 0xF9F5, 0xFD12, 0xFA15, 0xF9A6, 0xF574, 0xF8CE,
    0xFBC8, 0xFB86, 0xFD4D, 0xFB46, 0x00BF, 0x0232, 0x0171, 0xFF3A, 0x008C, 0x01E3, 0xFFDD, 0xFD9B, 0xFC70, 0xFE9F, 0xFD83, 0xFB06,
    0xF826, 0xF9BC, 0xFB1C, 0xF98C, 0xF932, 0xF9FD, 0xFD76, 0xFED8, 0xFE78, 0xFF2C, 0x0026, 0x021B, 0x0147, 0x000D, 0xFFE8, 0x0224,
    0x0232, 0x0160, 0x036D, 0x0685, 0x097B, 0x0C0C, 0x0DF5, 0x0E36, 0x1113, 0x12FE, 0x1187, 0x111E, 0x1361, 0x1402, 0x1495, 0x1349,
    0x1077, 0x13A6, 0x11BB, 0x0D16, 0x0A7A, 0x0A14, 0x0CB3, 0x06DB, 0x068A, 0x0656, 0x072D, 0x05DF, 0xFDE2, 0x0013, 0xFE70, 0xFB14,
    0xF7FE, 0xF405, 0xF7EF, 0xF5EE, 0xF3B8, 0xF63D, 0xF403, 0xF836, 0xF6EB, 0xF677, 0xF8B3, 0xF709, 0xFC09, 0xF828, 0xFA63, 0xFCE8,
    0xF962, 0xFCF6, 0xF761, 0xF8A5, 0xF774, 0xF457, 0xF78F, 0xF338, 0xF6AD, 0xF73B, 0xF6A4, 0xF86A, 0xF4F4, 0xF9C2, 0xF8C4, 0xF834,
    0xFABE, 0xF600, 0xF9EE, 0xF7CF, 0xF4C7, 0xF4EB, 0xF3DC, 0xF958, 0xF8A5, 0xFA1C, 0xFE06, 0xFD41, 0xFF62, 0xFC56, 0xFDBD, 0xFFB6,
    0xFE8D, 0x0320, 0x028A, 0x06A1, 0x07A8, 0x056B, 0x06E3, 0x0726, 0x0827, 0x054B, 0x0642, 0x0823, 0x06CA, 0x067C, 0x0683, 0x07B3,
    0x05D7, 0x05BD, 0x062B, 0x0471, 0x02A4, 0x028B, 0x0291, 0x01BE, 0x0249, 0x03DF, 0x054E, 0x06A9, 0x0923, 0x0A12, 0x0CBE, 0x0C75,
    0x0D76, 0x0F0E, 0x0F08, 0x0E16, 0x0A1A, 0x0B6C, 0x0A9B, 0x07A7, 0x0577, 0x02DC, 0x039C, 0x028C, 0x00A7, 0x006B, 0x006E, 0x0075,
    0x0095, 0xFE68, 0xFD6A, 0xFC4A, 0xF92C, 0xF59C, 0xF1BF, 0xF2A9, 0xEC30, 0xE982, 0xEA46, 0xE76F, 0xE9F0, 0xE82A, 0xE8B9, 0xE9C2,
    0xEA0F, 0xEC20, 0xE8FB, 0xEB29, 0xEE5B, 0xEECE, 0xF2CA, 0xF337, 0xF485, 0xF719, 0xF818, 0xFB7D, 0xF8C0, 0xFD6F, 0x0189, 0xFDDA,
    0x0300, 0x032A, 0x0821, 0x0749, 0x067F, 0x0A60, 0x07BD, 0x0CAB, 0x0968, 0x0761, 0x09A1, 0x09C3, 0x0CED, 0x0A69, 0x0CB3, 0x1176,
    0x11E7, 0x146E, 0x14AA, 0x179B, 0x1CDE, 0x1C49, 0x1DD1, 0x1C6C, 0x1D40, 0x2016, 0x1A13, 0x1AD9, 0x1869, 0x1927, 0x16D3, 0x11C6,
    0x12AC, 0x0D0C, 0x0D2E, 0x0862, 0x04BF, 0x05FA, 0x02CC, 0x0010, 0xFBC5, 0xFA30, 0xF87F, 0xF3A9, 0xEFF5, 0xEF05, 0xED74, 0xEBF4,
    0xEC40, 0xEABD, 0xEDA5, 0xECCE, 0xEA2B, 0xE731, 0xE7C5, 0xEC6A, 0xE964, 0xE955, 0xE913, 0xE900, 0xE93F, 0xE751, 0xE4BB, 0xE237,
    0xE7BC, 0xF0BB, 0xED85, 0xE22B, 0xDE49, 0xDEE9, 0xE29A, 0xE68F, 0xE78D, 0xEC0D, 0xEE16, 0xEDFA, 0xEE03, 0xF258, 0xF5A3, 0xF5A0,
    0xF48E, 0xF90C, 0xFE8A, 0xFD7C, 0x00D1, 0x00C3, 0x071A, 0x08A8, 0x0661, 0x087D, 0x078D, 0x0D6D, 0x09D7, 0x07B4, 0x090E, 0x057D,
    0x055C, 0x0043, 0x0098, 0xFF35, 0xFBAF, 0xFEB0, 0xFA99, 0xFA79, 0xFCB3, 0xFB0B, 0xFBE4, 0xF842, 0xFA3F, 0xF89A, 0xF44C, 0xF8AC,
    0xF7B6, 0x00BB, 0x04BA, 0x027E, 0x0421, 0x0350, 0x0C30, 0x0705, 0x0555, 0x0A4F, 0x072E, 0x0A63, 0x057C, 0x092A, 0x0C9F, 0x0BD3,
    0x0CCC, 0x01CB, 0x022D, 0x0502, 0x0221, 0x050C, 0x0613, 0x0A60, 0x07F6, 0x041D, 0x0983, 0x0635, 0x08E5, 0x055E, 0x00E3, 0x04B7,
    0xFF9D, 0xFFD4, 0xF9DF, 0xFBD6, 0xFDC3, 0xF8CC, 0xF97E, 0xF4A3, 0xF66B, 0xF3C7, 0xF394, 0xF40F, 0xF1CB, 0xF54B, 0xF48B, 0xF2DA,
    0xF207, 0xF19A, 0xEEB1, 0xEDA8, 0xEB73, 0xE863, 0xE678, 0xE74A, 0xE54F, 0xE3AF, 0xE609, 0xE799, 0xE910, 0xE593, 0xE9C4, 0xEE4B,
    0xEDF9, 0xED4C, 0xEC36, 0xEDED, 0xEFBD, 0xF378, 0xF518, 0xF932, 0xFE62, 0x0195, 0x08C2, 0x0A6E, 0x0716, 0x0198, 0x0400, 0x1139,
    0x195F, 0x1F99, 0x220F, 0x22B9, 0x229B, 0x234A, 0x25A0, 0x20E9, 0x2043, 0x1F24, 0x1EC6, 0x1D35, 0x1991, 0x1AC6, 0x1772, 0x1591,
    0x11AF, 0x0F03, 0x0E80, 0x0BD5, 0x0504, 0x002A, 0x03FD, 0xFF5E, 0xF443, 0xF3DE, 0xFD5B, 0x0206, 0xFF2E, 0xF735, 0xF280, 0xEDBD,
    0xED8C, 0xF29D, 0xF1B8, 0xF626, 0xF511, 0xF6BA, 0xF667, 0xF505, 0xF7FF, 0xF242, 0xF6B9, 0xF2A5, 0xF1C4, 0xF614, 0xF338, 0xF65A,
    0xF2AC, 0xF7DC, 0xF7C2, 0xF30C, 0xF63D, 0xF108, 0xF27B, 0xF146, 0xEE3A, 0xEFD2, 0xEE50, 0xF2C8, 0xF15E, 0xF06D, 0xF6CE, 0xF373,
    0xF3B6, 0xF4FD, 0xF58E, 0xF931, 0xF64A, 0xFD01, 0xFCF9, 0xFE05, 0x02DF, 0xFCEC, 0x01D3, 0x0141, 0x0336, 0x0279, 0x0149, 0x0836,
    0x053F, 0x074E, 0x07B5, 0x08AD, 0x09F2, 0x08E6, 0x097C, 0x0701, 0x06D6, 0x095D, 0x071A, 0x07FB, 0x0958, 0x05A4, 0x08FE, 0x074D,
    0x07EB, 0x0795, 0x0AE9, 0x0EE1, 0x0C36, 0x1106, 0x1179, 0x149D, 0x12DE, 0x12A5, 0x1593, 0x14CF, 0x1327, 0x11DF, 0x12F9, 0x1165,
    0x1120, 0x0B82, 0x0D29, 0x0D98, 0x0D1B, 0x0B7D, 0x08B4, 0x0BAF, 0x0570, 0x02C9, 0xFE06, 0xFCE2, 0xFC0F, 0xF897, 0xF79E, 0xF54D,
    0xF6BD, 0xF3CD, 0xF05C, 0xF014, 0xF2B1, 0xF014, 0xEDCB, 0xEE4E, 0xF0E4, 0xF39D, 0xF41C, 0xF81C, 0xF7AD, 0xF8DB, 0xF9D6, 0xFD3A,
    0xFCB6, 0xFA13, 0xFE30, 0x0098, 0x098F, 0x07C3, 0x025B, 0xFF73, 0xFC54, 0x0450, 0x066B, 0x0E05, 0x1061, 0x0CB9, 0x0FD1, 0x0C95,
    0x1034, 0x0BBC, 0x0940, 0x0C9A, 0x07DF, 0x0D97, 0x0BA4, 0x09AB, 0x0F34, 0x0D83, 0x0DF2, 0x0B8F, 0x0E17, 0x0F0E, 0x0772, 0x0D2D,
    0x0BA0, 0x04A2, 0xFF98, 0xF861, 0xFF0D, 0xFFAA, 0x0259, 0xFDA2, 0xF0D9, 0xF2BC, 0xEE0F, 0xEE1F, 0xECCB, 0xEBAD, 0xEEFA, 0xE8C5,
    0xEB58, 0xEA79, 0xEB10, 0xF108, 0xEE20, 0xF0B3, 0xF0EA, 0xF429, 0xF638, 0xF2E0, 0xF7EC, 0xF8BD, 0xFBFC, 0xFEE2, 0xFEC7, 0x02A4,
    0x05A8, 0x0824, 0x0706, 0x0716, 0x0C0E, 0x0D55, 0x0DB4, 0x1246, 0x11FE, 0x144E, 0x13DD, 0x1306, 0x125B, 0x0D08, 0x0B1C, 0x04B0,
    0x0557, 0x06AE, 0x07BD, 0x088E, 0x097B, 0x0BA7, 0x0B25, 0x0D75, 0x0C9F, 0x0ECF, 0x0FA5, 0x1367, 0x1256, 0x1006, 0x116A, 0x1015,
    0x10FD, 0x0E33, 0x0ECD, 0x0E29, 0x0C97, 0x0A59, 0x071B, 0x02DA, 0xFF61, 0xFE3D, 0xFB8B, 0xFA3A, 0xF97E, 0xFA91, 0xF7A7, 0xF52A,
    0xF314, 0xF0D4, 0xEEC2, 0xEBA4, 0xE968, 0xE860, 0xE987, 0xE6D6, 0xE729, 0xE67E, 0xE965, 0xE847, 0xE4CC, 0xE89E, 0xE819, 0xEC50,
    0xEAB1, 0xEDB0, 0xF3E3, 0xF317, 0xF63C, 0xF5E1, 0xFAF2, 0xFE9E, 0xFC62, 0x0000, 0x0187, 0x04E4, 0x057D, 0x03BC, 0x0B60, 0x0A29,
    0x0934, 0x0C72, 0x0A67, 0x0FBA, 0x0F96, 0x1272, 0x1344, 0x0FE9, 0x1742, 0x13F3, 0x16FB, 0x1474, 0x1308, 0x1D24, 0x1F92, 0x2504,
    0x1E99, 0x197A, 0x1B12, 0x180B, 0x1E56, 0x20A6, 0x21E1, 0x22A9, 0x1E4E, 0x1E34, 0x1826, 0x14C1, 0x06BE, 0x0C78, 0x0E58, 0x082D,
    0x0226, 0x0251, 0x0F07, 0xF622, 0xFB32, 0xF439, 0xF3DD, 0xE841, 0xE0C9, 0xEF19, 0xE608, 0xE1B5, 0xDF8D, 0xDA35, 0xD888, 0xECB5,
    0xD844, 0xE0EC, 0xD7D8, 0xD454, 0xDE30, 0xCAF3, 0xDD87, 0xE617, 0xE3A1, 0xEBB0, 0xF2C5, 0xDF74, 0xEB8D, 0xF4D2, 0xE6F5, 0x11F0,
    0xF075, 0xECC5, 0x146D, 0xE941, 0x19DA, 0x01D4, 0xEB00, 0x1826, 0x06EB, 0x0E30, 0xEBAC, 0x0B3D, 0x1459, 0xE7A6, 0x0510, 0x1B14,
    0x0892, 0xEF94, 0xFE4A, 0x0464, 0x1B1F, 0xE577, 0xEEB6, 0x213A, 0x089E, 0xFFB3, 0xF043, 0xFA71, 0xF00C, 0xEDC6, 0xDBDD, 0xEF6D,
    0xF2F7, 0xD6B5, 0xD2D7, 0xEDCB, 0xF98F, 0xC5D8, 0xE76A, 0xF2EC, 0xDF83, 0xE0F5, 0xF11F, 0xFE98, 0xEB73, 0xFEEC, 0x1C38, 0x0E23,
    0x019D, 0x1FC8, 0x1740, 0x36B4, 0x1CD6, 0x2104, 0x3C37, 0x358D, 0x4262, 0x2AC3, 0x4664, 0x2CE8, 0x2E39, 0x3295, 0x2E4A, 0x1210,
    0xFFCF, 0xF6D3, 0xF485, 0xE435, 0xB781, 0xCFE1, 0xCA23, 0xB95D, 0xA0F7, 0xAB24, 0xB1BC, 0x982D, 0xA002, 0xAD42, 0x9F35, 0x946C,
    0xAA82, 0xAD8B, 0xA695, 0xAF6D, 0xAE33, 0xC7FF, 0xA49C, 0xD4C0, 0xEDD0, 0xC165, 0xDDAE, 0xCF99, 0xE6ED, 0xE483, 0x0760, 0x0699,
    0x16C3, 0x18A1, 0x1A06, 0x3D95, 0x3A8B, 0x35BB, 0x35C6, 0x68DE, 0x3ADE, 0x5A36, 0x6729, 0x62A4, 0x78C6, 0x5ADC, 0x6EB4, 0x769E,
    0x7F3B, 0x75A3, 0x797E, 0x76E0, 0x7992, 0x7FFF, 0x7BB5, 0x7503, 0x7B02, 0x7687, 0x67DD, 0x7335, 0x6676, 0x5ABF, 0x57BF, 0x69E0,
    0x495E, 0x49F2, 0x6004, 0x43BD, 0x443C, 0x48BD, 0x442B, 0x2DA1, 0x3B96, 0x3826, 0x2F5B, 0x3B8D, 0x28CA, 0x278C, 0x21AD, 0x27A4,
    0x13D6, 0x13EA, 0x1DB7, 0x0D63, 0x1A22, 0x04F6, 0x127B, 0x085C, 0x021E, 0xF8DE, 0x0306, 0x0226, 0xE73B, 0xF285, 0xEA1D, 0xE5C6,
    0xD40F, 0xEF27, 0xD39B, 0xD496, 0xE805, 0xB6BC, 0xD13C, 0xDC19, 0xC4B5, 0xBA4F, 0xD060, 0xC2A3, 0xB526, 0xCB9C, 0xB4C8, 0xC194,
    0xB357, 0xB26D, 0xBD13, 0xB519, 0xB4F2, 0xB348, 0xAC05, 0xAA12, 0xAFD3, 0xAD59, 0xB6FC, 0xAFEF, 0xA9A5, 0xAA3E, 0xB6D0, 0xB25B,
    0xA926, 0xB993, 0xA756, 0xAF4B, 0xBB6F, 0xAE5A, 0xB270, 0xAE66, 0xBA83, 0xAE82, 0xCC03, 0xBDBD, 0xB91B, 0xC685, 0xCAF8, 0xC465,
    0xC697, 0xCC31, 0xCEBF, 0xD471, 0xC78C, 0xE406, 0xCB61, 0xE3E0, 0xD463, 0xDA3C, 0xE1CC, 0xDFD9, 0xEE09, 0xE3EF, 0xD936, 0xE2AB,
    0xF34A, 0xE59B, 0xF0CA, 0xEE52, 0xE77C, 0x0217, 0x02CE, 0xF6DB, 0xF749, 0xFADB, 0x064B, 0xF8BE, 0xF88D, 0xE69D, 0x0563, 0x065F,
    0xF9CF, 0xEBAF, 0x0DE8, 0x0205, 0x05B1, 0x021D, 0xF61C, 0x0F87, 0x01B3, 0x26A2, 0x09A2, 0x2201, 0x23E3, 0x1F77, 0x2C31, 0x2FA8,
    0x1E66, 0x291C, 0x40C6, 0x349B, 0x39E0, 0x40AA, 0x3A30, 0x34E7, 0x3F4D, 0x3C42, 0x4E9D, 0x5E0C, 0x4E65, 0x5FAC, 0x6EB4, 0x7285,
    0x71ED, 0x6583, 0x7693, 0x6EF6, 0x798E, 0x7667, 0x69AA, 0x7A1B, 0x6F93, 0x61D3, 0x73B4, 0x56D2, 0x54F4, 0x57F5, 0x51BD, 0x50F3,
    0x5088, 0x48C4, 0x5770, 0x4750, 0x31C7, 0x48FD, 0x493F, 0x5CD4, 0x40E5, 0x4CC9, 0x4F04, 0x3D34, 0x3CB0, 0x426C, 0x3C11, 0x3457,
    0x204C, 0x27F3, 0x2A01, 0x118E, 0x23E4, 0x25D2, 0x2931, 0x3621, 0x213C, 0x38FC, 0x338F, 0x1C6F, 0x27B9, 0x12B1, 0x2225, 0x0BDC,
    0x19A7, 0x1142, 0x05CA, 0x2665, 0x079A, 0xF16F, 0xEBC0, 0xE1E9, 0x01F0, 0xEDD0, 0xE823, 0x09B5, 0xF5E8, 0x0E42, 0x1B6B, 0x0226,
    0x292F, 0x224E, 0x0DD3, 0x374F, 0x3002, 0x0CC5, 0x2EBC, 0x33D6, 0xFF6E, 0x1815, 0x1ADD, 0x295D, 0x0DE7, 0xEF78, 0xED84, 0xF19A,
    0xEC80, 0xE7AE, 0xE013, 0xCA24, 0xDEF7, 0xD723, 0xE0C9, 0xD538, 0xC343, 0xCC1C, 0xB77B, 0xBE7F, 0xC515, 0xBDC8, 0xBECA, 0xB55D,
    0xBFC9, 0xBBCF, 0xBFA5, 0xB7D4, 0xD255, 0xC062, 0xD627, 0xD384, 0xC85B, 0xDABD, 0xC043, 0xD674, 0xB91D, 0xCB7D, 0xC694, 0xC798,
    0xC491, 0xBC28, 0xB08B, 0xB607, 0xBCD7, 0x9C27, 0xA9BE, 0xAC29, 0xA9F4, 0xADD7, 0xC445, 0xB24B, 0xAE4A, 0xBEF6, 0xBF20, 0xBE64,
    0xBACD, 0xC0A4, 0xBAC6, 0xB694, 0xB230, 0xAE0A, 0xAE87, 0xA38A, 0xB69A, 0xACD7, 0x9A73, 0xB384, 0xA872, 0xA12B, 0xA6C3, 0xAD6E,
    0xA56C, 0xAC1A, 0xA4F2, 0xAD2D, 0xAE26, 0xBCC8, 0xC867, 0xB0F8, 0xD3C8, 0xC861, 0xDA2E, 0xCB79, 0xDA72, 0xEFBF, 0xE036, 0xF9C4,
    0xED58, 0xFB9D, 0x044F, 0x0C14, 0x0303, 0xFDC3, 0x0675, 0x0282, 0xFA54, 0xF463, 0x0370, 0x02C4, 0xEC51, 0x0027, 0xF18F, 0xF2CA,
    0x0548, 0xEA4C, 0xF865, 0xED8C, 0xF6AA, 0xFF2D, 0xF4E9, 0xF8BC, 0x0B21, 0x0E01, 0x1978, 0x1B82, 0x0BF1, 0x2009, 0x09F1, 0x1225,
    0x0F7C, 0x11C1, 0x027A, 0xFE81, 0x1945, 0xF8D3, 0xFD92, 0xFD92, 0xE917, 0xF946, 0x0090, 0xFBAD, 0x0543, 0x0B69, 0x04B0, 0xF5DD,
    0x1F3F, 0x16CA, 0xFFC1, 0xFD93, 0x0740, 0x1173, 0x15C9, 0x185D, 0x0AC3, 0x1C01, 0x2004, 0x22E9, 0x23CD, 0x4A12, 0x3DB6, 0x3DC1,
    0x592B, 0x531F, 0x536A, 0x6113, 0x5461, 0x59D1, 0x605D, 0x550B, 0x658B, 0x4924, 0x4EA4, 0x5206, 0x35AB, 0x4448, 0x4022, 0x3F8B,
    0x3CDC, 0x3026, 0x49B0, 0x4449, 0x51F3, 0x4552, 0x4CB8, 0x5981, 0x54AC, 0x492E, 0x50C7, 0x4A57, 0x3FD9, 0x4E42, 0x3F5C, 0x37E3,
    0x4591, 0x448F, 0x2AB1, 0x437D, 0x2BBD, 0x3662, 0x21AC, 0x3803, 0x35EE, 0x2B62, 0x4319, 0x2BEF, 0x3DC5, 0x32AF, 0x3229, 0x312F,
    0x3952, 0x2F45, 0x34FF, 0x2D36, 0x3E37, 0x3B78, 0x3CBF, 0x4B45, 0x45DB, 0x52B1, 0x5304, 0x59B9, 0x5401, 0x5C73, 0x59E0, 0x4FF6,
    0x5662, 0x59D8, 0x51FA, 0x562E, 0x4BB3, 0x4A19, 0x460A, 0x4E17, 0x43E9, 0x265B, 0x31BB, 0x380E, 0x2C5C, 0x2A01, 0x33CC, 0x3223,
    0x3394, 0x3B0B, 0x4E26, 0x45C8, 0x497D, 0x5097, 0x49D8, 0x43F6, 0x4264, 0x3EF1, 0x2D0B, 0x2F07, 0x30C7, 0x127D, 0x1003, 0x168C,
    0xF7D9, 0xF332, 0xF606, 0xF9D3, 0xECCA, 0xDE92, 0xE5C5, 0xEF87, 0xE22A, 0xE22D, 0xE958, 0xE2C0, 0xE654, 0xD815, 0xD998, 0xDE78,
    0xE2D1, 0xD480, 0xCD89, 0xF1FF, 0xE85A, 0xE0C8, 0xFEF9, 0x004A, 0xFAA6, 0x03E4, 0x0C24, 0xFEA6, 0xF8C7, 0x0706, 0xFCC4, 0xF154,
    0xFCC6, 0xF9F0, 0xEAB2, 0xEE2A, 0xE8E1, 0xE894, 0xD54F, 0xDB66, 0xE64F, 0xCA19, 0xD2A9, 0xD351, 0xD966, 0xDD96, 0xE618, 0xE517,
    0xF035, 0xEEC0, 0xF053, 0xF783, 0xDA9F, 0xE5BB, 0xE115, 0xE179, 0xE3D4, 0xE0BA, 0xD7BC, 0xCDE9, 0xD449, 0xC5CC, 0xC567, 0xCB9A,
    0xBA02, 0xB8D7, 0xBBD6, 0xB79D, 0xBB66, 0xB27A, 0xA9AE, 0xADFD, 0xAD63, 0xA4B6, 0xAA6E, 0xA4DC, 0xA28C, 0xA152, 0xA521, 0xA30E,
    0xA112, 0xA72B, 0xA5E7, 0xB35A, 0xB53D, 0xB67F, 0xB1D0, 0xBC9C, 0xBEF7, 0xC1A3, 0xC879, 0xC464, 0xDD3B, 0xCD78, 0xD400, 0xDA31,
    0xC7E7, 0xD482, 0xCB63, 0xCD3B, 0xC153, 0xC0F3, 0xC10B, 0xBC4E, 0xBABA, 0xB966, 0xC90E, 0xBDDB, 0xC78B, 0xCD02, 0xCC55, 0xCB05,
    0xD278, 0xD98A, 0xCBFB, 0xD5E2, 0xCFE5, 0xCF38, 0xC937, 0xC613, 0xCA8E, 0xC008, 0xBDD3, 0xC514, 0xC0F1, 0xB918, 0xC0AB, 0xBB54,
    0xC230, 0xBEE2, 0xBF54, 0xBAFA, 0xB7B2, 0xBE07, 0xBC58, 0xB7E2, 0xBF75, 0xC03C, 0xB3F3, 0xC2D7, 0xCACA, 0xD494, 0xD527, 0xE4B3,
    0xECDA, 0xEC5A, 0xF484, 0x0037, 0xFD2C, 0xFFE8, 0x0BEA, 0x0A73, 0x1971, 0x07C4, 0x0E2B, 0x1920, 0x0E43, 0x1224, 0x0B85, 0x07BB,
    0x0419, 0x00C7, 0xF819, 0xEC06, 0xF6D2, 0xF489, 0xF06C, 0xF75D, 0x00AA, 0xFB61, 0xF55E, 0x0281, 0xFB26, 0xF61A, 0xFA7A, 0x00BD,
    0xFED1, 0xFF8D, 0x0769, 0x04A1, 0xFE4F, 0xFAB6, 0xF91A, 0xF6CE, 0xF7E1, 0xFA58, 0xF777, 0xFE94, 0x020D, 0x0172, 0x0143, 0x0472,
    0x0216, 0x037B, 0xFE72, 0xFF03, 0x009D, 0xF622, 0xFB73, 0xFB0D, 0xFE9E, 0x0D73, 0x0E16, 0x1ACD, 0x2006, 0x1F9D, 0x362B, 0x2E62,
    0x406F, 0x440E, 0x4378, 0x4E92, 0x598C, 0x561F, 0x532E, 0x558F, 0x535C, 0x5946, 0x4BD4, 0x4C00, 0x484A, 0x40DD, 0x39DD, 0x3513,
    0x2E73, 0x31E0, 0x3701, 0x3AD9, 0x3AE3, 0x46E8, 0x4B5D, 0x460F, 0x3A75, 0x41D7, 0x3949, 0x31EE, 0x42B6, 0x3C00, 0x31EE, 0x3785,
    0x2F5A, 0x299E, 0x2FD7, 0x257A, 0x2F5F, 0x24EF, 0x3471, 0x3B01, 0x398F, 0x3C4A, 0x4090, 0x3C11, 0x41C1, 0x448C, 0x3CBE, 0x4138,
    0x389B, 0x3AEC, 0x21B1, 0x30BB, 0x3081, 0x29BD, 0x2F2F, 0x3417, 0x423D, 0x3DB0, 0x48BD, 0x4EAB, 0x4C7D, 0x4B41, 0x4B03, 0x537D,
    0x5298, 0x490D, 0x4D35, 0x46A3, 0x4E5D, 0x4C9C, 0x4519, 0x41F5, 0x34D7, 0x2A1A, 0x1805, 0x16AE, 0x0F72, 0x0C32, 0x0858, 0x07DB,
    0x0C11, 0x0EF1, 0x18D0, 0x0EA5, 0x1B0F, 0x1CF5, 0x269D, 0x2741, 0x2144, 0x31B0, 0x2990, 0x299C, 0x256F, 0x23CC, 0x187B, 0x1308,
    0x0F3C, 0x0AE6, 0x0926, 0x06BE, 0x02CE, 0xFE56, 0x03CB, 0x0151, 0xFD4B, 0x0022, 0xFD21, 0xF36F, 0xF9D3, 0xF007, 0xE9DE, 0xEBA1,
    0xEBDB, 0xE778, 0xE4D9, 0xE819, 0xE712, 0xEC0D, 0xF0B3, 0xF5CC, 0xF870, 0xFEA8, 0xFED3, 0x05EC, 0x0907, 0x073A, 0x07B0, 0x02EF,
    0x0433, 0x04ED, 0x0577, 0x0169, 0x011C, 0xF813, 0xEE87, 0xE7EE, 0xD839, 0xD5BE, 0xD59B, 0xCC01, 0xCC81, 0xD132, 0xD476, 0xD372,
    0xD2AF, 0xCFCD, 0xCE25, 0xD4F4, 0xD1D5, 0xD2C8, 0xD186, 0xD9CC, 0xD95B, 0xD4D9, 0xD77E, 0xD7D2, 0xD842, 0xD7B1, 0xD7A0, 0xD9E5,
    0xE16A, 0xDF85, 0xDD5B, 0xDC8F, 0xDC29, 0xDCD5, 0xDC32, 0xD945, 0xD41E, 0xC8DE, 0xCC54, 0xC813, 0xBB7B, 0xC299, 0xC3B0, 0xC05C,
    0xC26B, 0xBAF2, 0xC7D3, 0xC813, 0xBFEF, 0xC6DC, 0xC999, 0xC9AC, 0xCA26, 0xCB63, 0xC371, 0xD040, 0xCBFC, 0xD3FC, 0xD50C, 0xD319,
    0xDAC3, 0xD0CD, 0xCEAD, 0xC7D3, 0xC5D8, 0xC18D, 0xB925, 0xB365, 0xBF38, 0xB9DB, 0xB736, 0xB622, 0xB328, 0xB50F, 0xB1A5, 0xB414,
    0xB37F, 0xBC61, 0xBC1E, 0xBD23, 0xBC91, 0xBFE0, 0xBCD1, 0xB54C, 0xB5B7, 0xB5A3, 0xB774, 0xBD0B, 0xBBCD, 0xBA98, 0xC17A, 0xC15A,
    0xC67A, 0xC503, 0xC312, 0xC7D5, 0xC394, 0xC1E0, 0xC4F7, 0xBD5C, 0xC094, 0xBC04, 0xBAC9, 0xC011, 0xC1EC, 0xC540, 0xCE0C, 0xD02F,
    0xD315, 0xE794, 0xE5E0, 0xF16E, 0xF825, 0xF7BF, 0xF948, 0xFAFC, 0x0031, 0x074A, 0x047E, 0x06BE, 0x0276, 0xF90C, 0xFE74, 0xF119,
    0xEAAF, 0xDDAF, 0xDEA3, 0xD9C5, 0xD2DC, 0xD545, 0xD459, 0xCD8F, 0xD139, 0xD0A1, 0xCD52, 0xD116, 0xCC2B, 0xCCFB, 0xC5EF, 0xD273,
    0xCD47, 0xC8D1, 0xCAF0, 0xC99A, 0xCB26, 0xCB4B, 0xCCA9, 0xC9FB, 0xC4BA, 0xC532, 0xCB42, 0xC7AE, 0xCAD2, 0xD0E7, 0xD29E, 0xD8CC,
    0xDB3E, 0xD6BB, 0xDD80, 0xD751, 0xD2A0, 0xD471, 0xD507, 0xD640, 0xDB7E, 0xDEE4, 0xE313, 0xE799, 0xEBA6, 0xF9AA, 0xF6C2, 0xFCEF,
    0x05CE, 0x0513, 0x0FFF, 0x1011, 0x1771, 0x1F8E, 0x23E8, 0x3378, 0x2D59, 0x36B9, 0x3860, 0x2D0E, 0x2B09, 0x2021, 0x1C3E, 0x13EA,
    0x0F65, 0x14EF, 0x1050, 0x1239, 0x1B6B, 0x0DDB, 0x1099, 0x1341, 0x0E4C, 0x16C2, 0x105A, 0x164D, 0x1127, 0x0B2B, 0x111C, 0x079D,
    0x0975, 0x0379, 0xF9E0, 0xFC82, 0x09B9, 0x023D, 0x03B2, 0x00F8, 0xFAFB, 0x024D, 0x00C8, 0x018B, 0xF531, 0xF72F, 0xEB35, 0xE9A2,
    0xEA91, 0xEE83, 0xEBAE, 0xEB4D, 0xED92, 0xE29E, 0xF130, 0xF364, 0x00F5, 0x0D47, 0x13C2, 0x23C4, 0x2B4E, 0x3028, 0x31AE, 0x2D96,
    0x310C, 0x3C45, 0x444D, 0x496C, 0x5129, 0x51CC, 0x4E96, 0x5042, 0x4A4C, 0x4458, 0x3E9A, 0x323F, 0x3586, 0x361C, 0x359C, 0x2D77,
    0x2C7B, 0x368B, 0x3788, 0x426F, 0x4A22, 0x5377, 0x51A0, 0x5F5D, 0x6665, 0x69E0, 0x6F77, 0x7217, 0x71A5, 0x6656, 0x5FBC, 0x624C,
    0x6653, 0x5F67, 0x6294, 0x553C, 0x51A6, 0x4B17, 0x49D6, 0x45D2, 0x3008, 0x364C, 0x27A2, 0x1E58, 0x1F5C, 0x1AAA, 0x1D64, 0x101B,
    0x143E, 0x0DE8, 0x06A8, 0x0BFA, 0x0D37, 0x1415, 0x170D, 0x18A8, 0x21E0, 0x2306, 0x1DF6, 0x273A, 0x2341, 0x29E3, 0x2C2A, 0x36B6,
    0x3616, 0x37CF, 0x4035, 0x352A, 0x3EC3, 0x388C, 0x3242, 0x2D8C, 0x2F97, 0x35EE, 0x303F, 0x2744, 0x2437, 0x1FEB, 0x1FE9, 0x2A42,
    0x329B, 0x2C0A, 0x343E, 0x451A, 0x460A, 0x4D3D, 0x4B8F, 0x559E, 0x54D7, 0x5033, 0x4A7C, 0x457D, 0x45CC, 0x48D4, 0x4C22, 0x46A2,
    0x476E, 0x45C1, 0x474A, 0x3FFA, 0x3FFA, 0x3B2A, 0x3074, 0x266B, 0x1E42, 0x17F9, 0x17BD, 0x19F7, 0x12FC, 0x0C1C, 0x0943, 0x02D3,
    0x0355, 0x094D, 0x067E, 0x100A, 0x09D6, 0x0BF3, 0x03B7, 0x03BE, 0xFF48, 0xF364, 0xFE92, 0xF9E6, 0xFB08, 0x0133, 0x0671, 0x0163,
    0x061E, 0x06D3, 0x023D, 0xF96B, 0xFDBE, 0x073E, 0x0590, 0x09F5, 0x06F9, 0x04C3, 0x0200, 0x0615, 0x07A5, 0x05DE, 0x09FD, 0x0EAD,
    0x161C, 0x15BD, 0x1E21, 0x2D45, 0x2DF4, 0x3026, 0x2CDD, 0x22D0, 0x1D8D, 0x1D4D, 0x2427, 0x1E65, 0x1D56, 0x1D98, 0x1D6A, 0x196B,
    0x11DA, 0x130F, 0x00DC, 0xFB4C, 0xF31A, 0xEC2A, 0xE4AF, 0xE1EB, 0xDF46, 0xD3F6, 0xD060, 0xCDC0, 0xCE90, 0xCACC, 0xD1D1, 0xD61A,
    0xDAD8, 0xDB98, 0xDF34, 0xE015, 0xDD6B, 0xE12D, 0xE35F, 0xE68A, 0xEB5F, 0xF2CE, 0xF2FB, 0xEBB6, 0xEC9C, 0xEC27, 0xE12B, 0xDBE8,
    0xD552, 0xD683, 0xD6F7, 0xD52A, 0xCF26, 0xC9B1, 0xC8BA, 0xC2DD, 0xCABA, 0xC61B, 0xC6DB, 0xCECE, 0xD3CB, 0xD1FA, 0xD3E7, 0xDDED,
    0xDEB5, 0xE5F8, 0xE0C2, 0xD8C3, 0xD353, 0xCEF9, 0xCF6E, 0xCE8B, 0xD01F, 0xD346, 0xCEB1, 0xCB33, 0xCA84, 0xC9F4, 0xC656, 0xBF2D,
    0xBB05, 0xB7CF, 0xB5DA, 0xB764, 0xB947, 0xB76B, 0xB45B, 0xB3A1, 0xB200, 0xB130, 0xB788, 0xBBAD, 0xC13A, 0xC16E, 0xC7F0, 0xC9D7,
    0xC700, 0xCA7A, 0xCA44, 0xCAC0, 0xCD81, 0xD964, 0xD98A, 0xD8BF, 0xE062, 0xE24B, 0xE249, 0xE295, 0xE01A, 0xE123, 0xE277, 0xE31D,
    0xE3D4, 0xDBFE, 0xD09B, 0xCEF0, 0xD1FE, 0xCBED, 0xD229, 0xD766, 0xDB8A, 0xE0F5, 0xE42F, 0xE745, 0xEEA3, 0xFB5D, 0xFB66, 0xF73F,
    0xE878, 0xE224, 0xE0AB, 0xDAFD, 0xD7DF, 0xD549, 0xD887, 0xD4F0, 0xD3A6, 0xD589, 0xCFBB, 0xCCC3, 0xC64A, 0xC0DE, 0xBF92, 0xC08D,
    0xC752, 0xC850, 0xC6AE, 0xC9A1, 0xC69B, 0xC458, 0xC77B, 0xC6BC, 0xCD80, 0xD001, 0xD9E4, 0xDAD2, 0xDA51, 0xE2D6, 0xE03C, 0xE1EB,
    0xE7D6, 0xF7D1, 0xF59A, 0xF756, 0xFE49, 0xFD44, 0x024E, 0x0265, 0x0008, 0x004E, 0xFD33, 0x014F, 0x060F, 0xFE07, 0xF71D, 0xF0F4,
    0xEFD1, 0xE4E4, 0xE7CE, 0xEAB8, 0xEAE3, 0xF2D2, 0xF203, 0xFA6E, 0x0266, 0x1169, 0x1EA9, 0x1CDC, 0x1FC1, 0x1A02, 0x1889, 0x1A75,
    0x1CEA, 0x220A, 0x1FA8, 0x276F, 0x22F7, 0x215D, 0x1EC3, 0x17D4, 0x149C, 0x0A64, 0x003D, 0xF76C, 0xF053, 0xEC4E, 0xEC7E, 0xEAB8,
    0xE5C5, 0xE357, 0xE71A, 0xE27A, 0xE4A7, 0xE6F1, 0xEBDC, 0xEB7E, 0xEA4F, 0xF0F6, 0xEC7E, 0xEF07, 0xF597, 0xFDBC, 0x02E1, 0x08A1,
    0x0A21, 0x0AA8, 0x0C32, 0x0C07, 0x0F80, 0x0B76, 0x0564, 0x0EDA, 0x125D, 0x0EF2, 0x09CA, 0x076A, 0x068E, 0xFF7A, 0x029F, 0x0184,
    0x072B, 0x0B2C, 0x0FE4, 0x10CC, 0x122F, 0x22A7, 0x2F66, 0x338F, 0x36E0, 0x32AC, 0x2D12, 0x2943, 0x2489, 0x25D8, 0x2559, 0x29DF,
    0x27D1, 0x2B4C, 0x2E1F, 0x2DF8, 0x2FFC, 0x299B, 0x2477, 0x2364, 0x1C70, 0x1E50, 0x1DB4, 0x19EA, 0x1833, 0x125D, 0x1225, 0x117B,
    0x1553, 0x19C7, 0x21B2, 0x1EC3, 0x22AA, 0x249D, 0x20CB, 0x1DEA, 0x21BC, 0x2886, 0x290D, 0x2F28, 0x2D9F, 0x2F74, 0x2B4F, 0x2EF9,
    0x3169, 0x2CF8, 0x287A, 0x2947, 0x2E5C, 0x2B20, 0x2BE3, 0x2B53, 0x2E3E, 0x2BC3, 0x306E, 0x2ECE, 0x2C87, 0x349D, 0x355F, 0x32F3,
    0x3224, 0x3A9F, 0x46E8, 0x5202, 0x55EE, 0x53AA, 0x4DEB, 0x4CA9, 0x4644, 0x462F, 0x4529, 0x4213, 0x4851, 0x4576, 0x41E9, 0x4491,
    0x4381, 0x40FD, 0x3A02, 0x3505, 0x2AF3, 0x2430, 0x2428, 0x19D7, 0x18E1, 0x147D, 0x0FDD, 0x0C3C, 0x08E4, 0x0C89, 0x1269, 0x10F3,
    0x168F, 0x1960, 0x1AA5, 0x1B63, 0x1E73, 0x2733, 0x2DB5, 0x3535, 0x3DD9, 0x4165, 0x3DA3, 0x4748, 0x4903, 0x49D1, 0x4460, 0x4417,
    0x4694, 0x4417, 0x42BB, 0x4157, 0x3B14, 0x350A, 0x336B, 0x2D2D, 0x2728, 0x2A2B, 0x2E28, 0x2D5C, 0x2D9E, 0x2D59, 0x366E, 0x3C62,
    0x4154, 0x4174, 0x4034, 0x3AAF, 0x363D, 0x2EDE, 0x2CD9, 0x2B46, 0x2C6D, 0x2812, 0x2177, 0x245D, 0x1D4F, 0x1D05, 0x18B3, 0x12F2,
    0x04B8, 0xFB58, 0xF4FF, 0xEB82, 0xE5F0, 0xE24B, 0xE0A8, 0xDDAD, 0xDFA3, 0xE2B2, 0xE8FD, 0xE97A, 0xE7F6, 0xEBA8, 0xEC38, 0xED4C,
    0xF302, 0xFAB0, 0xFDD1, 0x05EF, 0x1055, 0x0EC7, 0x0E52, 0x1234, 0x15CC, 0x1757, 0x1526, 0x1431, 0x195D, 0x1A88, 0x1CF7, 0x1DF8,
    0x1BD0, 0x1E45, 0x1C62, 0x198C, 0x132E, 0x10FD, 0x1161, 0x1208, 0x136B, 0x13EF, 0x1A86, 0x2327, 0x2F8B, 0x37B7, 0x3978, 0x3815,
    0x319D, 0x2878, 0x1F99, 0x1B81, 0x16C4, 0x124F, 0x0A8C, 0x082D, 0x03D3, 0xFCB3, 0xFCA9, 0xF2B7, 0xE69F, 0xDD44, 0xD5A5, 0xCEAF,
    0xCB6F, 0xC9A4, 0xC825, 0xC631, 0xC73A, 0xCB37, 0xCCBE, 0xCCC0, 0xCA06, 0xCD49, 0xCABB, 0xC8CF, 0xD0C6, 0xD00C, 0xD221, 0xD8F7,
    0xE061, 0xE49F, 0xE37A, 0xE813, 0xEBB1, 0xF0A5, 0xF54F, 0xF257, 0xF234, 0xF211, 0xF571, 0xFB8C, 0xF7A8, 0xFA15, 0xF9E6, 0xF4E5,
    0xEDD2, 0xE4B4, 0xE45E, 0xE55F, 0xE1D9, 0xDF41, 0xDCDE, 0xE336, 0xED7F, 0xF339, 0xFD6A, 0x0001, 0x0447, 0x01FF, 0xFC2D, 0xFCE1,
    0xFD28, 0xFE04, 0xF9A0, 0xF74E, 0xF2AA, 0xECFE, 0xF098, 0xEDD2, 0xE73C, 0xE3DE, 0xD9F4, 0xD0B0, 0xCA9D, 0xC415, 0xC373, 0xBDA9,
    0xBAAA, 0xBCA9, 0xBC8B, 0xC06C, 0xBEFA, 0xC07F, 0xBB7B, 0xB929, 0xBAD9, 0xB4C5, 0xB49D, 0xB89D, 0xBC59, 0xBE43, 0xC117, 0xC0D3,
    0xC372, 0xC7C8, 0xCB45, 0xC6F5, 0xC143, 0xC48A, 0xC467, 0xC814, 0xC754, 0xC8BB, 0xCD7F, 0xC990, 0xC3FA, 0xBFBC, 0xBD7B, 0xBE7A,
    0xC00C, 0xC126, 0xC207, 0xC6D5, 0xD006, 0xD6A8, 0xE315, 0xEB89, 0xF085, 0xEF7D, 0xED8D, 0xEE31, 0xEC8F, 0xE91F, 0xE9FE, 0xE905,
    0xE2F7, 0xE789, 0xEB7F, 0xED5A, 0xEC7A, 0xEBDF, 0xE8E9, 0xE04A, 0xDAFB, 0xD9BF, 0xD355, 0xD246, 0xD1BE, 0xD4D6, 0xD771, 0xD532,
    0xD8D6, 0xD591, 0xD2BF, 0xD181, 0xD4FA, 0xD4C0, 0xD4CD, 0xDA70, 0xDEF0, 0xE1EA, 0xE152, 0xDFA9, 0xDC09, 0xDF7D, 0xE318, 0xDFB6,
    0xD9E2, 0xD2A6, 0xD018, 0xCDF8, 0xC83C, 0xC49D, 0xC7DB, 0xC8C4, 0xC661, 0xC334, 0xBFEE, 0xC37D, 0xC6B3, 0xC77E, 0xC920, 0xCD60,
    0xD429, 0xDB16, 0xE634, 0xF1D8, 0xF84A, 0xFF09, 0x00F8, 0xFF0E, 0xFC5F, 0xF98A, 0xFCC7, 0xF905, 0xF541, 0xF524, 0xF988, 0xFF64,
    0x0035, 0x05F8, 0x0431, 0xFA57, 0xF2A1, 0xEE16, 0xEACF, 0xE93C, 0xE6C7, 0xE7C2, 0xE4E4, 0xE58A, 0xEA10, 0xE8BA, 0xE3ED, 0xE170,
    0xE174, 0xDC84, 0xD9F9, 0xDB32, 0xE24F, 0xE87F, 0xF2A9, 0xF5EC, 0xFA2F, 0x030E, 0x0BCF, 0x11E4, 0x1192, 0x0CF5, 0x0A55, 0x0E59,
    0x0EAA, 0x0FCA, 0x10BE, 0x1322, 0x0F82, 0x08CB, 0xFFF3, 0xF8B2, 0xF71A, 0xF5A5, 0xF23F, 0xF318, 0xF586, 0xFA8A, 0x0300, 0x0CE6,
    0x170F, 0x1C35, 0x2054, 0x1C4F, 0x166F, 0x12B1, 0x11EC, 0x10AE, 0x0CE7, 0x095A, 0x0AFB, 0x0D95, 0x104B, 0x16CB, 0x1557, 0x0BBF,
    0xFFDC, 0xF5B8, 0xE95D, 0xE39E, 0xE40D, 0xE1F2, 0xE155, 0xE01A, 0xE46E, 0xE779, 0xE2CF, 0xE186, 0xE460, 0xE5D3, 0xE70C, 0xEB45,
    0xEFB0, 0xF7F7, 0x018B, 0x03AB, 0x0577, 0x0D62, 0x1617, 0x1B47, 0x1CAB, 0x187D, 0x176F, 0x186C, 0x17C1, 0x187C, 0x1827, 0x1D7E,
    0x231E, 0x24B2, 0x2052, 0x1C34, 0x1CA2, 0x19A9, 0x199A, 0x1C1F, 0x1D5B, 0x1EF6, 0x22B6, 0x28EA, 0x33E8, 0x4029, 0x493E, 0x4C27,
    0x4C88, 0x4A6E, 0x4952, 0x478C, 0x3F65, 0x3A99, 0x39FD, 0x3B05, 0x3CB5, 0x41E7, 0x432F, 0x3D46, 0x2F42, 0x1D6D, 0x103F, 0x0288,
    0xFE14, 0xFC34, 0xF9F8, 0xFD26, 0xFE16, 0x01D1, 0xFFA5, 0xFF04, 0x004F, 0xFF2D, 0x01D7, 0x00F7, 0x0195, 0x0724, 0x0F2E, 0x16DF,
    0x1A5F, 0x1C09, 0x2362, 0x29B5, 0x2FA7, 0x30E0, 0x2DEE, 0x2ED6, 0x2E19, 0x2E45, 0x2F42, 0x32E3, 0x3A69, 0x3BB8, 0x3869, 0x3759,
    0x3595, 0x315F, 0x2FE4, 0x30CA, 0x2ED5, 0x2DB3, 0x2DE5, 0x2BB3, 0x2BF2, 0x320C, 0x3805, 0x3CF0, 0x3BE6, 0x3AB4, 0x3A24, 0x3926,
    0x3831, 0x3612, 0x356B, 0x34BC, 0x387B, 0x4118, 0x4815, 0x4887, 0x45F0, 0x3CD4, 0x31CC, 0x29E3, 0x2424, 0x1F0E, 0x1952, 0x1523,
    0x123C, 0x1201, 0x11CB, 0x0FFA, 0x109A, 0x0F1C, 0x0E99, 0x0CDF, 0x06F3, 0x0922, 0x0D86, 0x12E7, 0x14C3, 0x12CB, 0x14A8, 0x199E,
    0x1F15, 0x1EC7, 0x1E15, 0x204C, 0x20FD, 0x21DB, 0x1F47, 0x1D3F, 0x240F, 0x2441, 0x1F89, 0x1DEA, 0x183D, 0x13A9, 0x12C4, 0x130A,
    0x0F2C, 0x0C61, 0x0BD2, 0x08AD, 0x097F, 0x0F29, 0x1B4B, 0x28E0, 0x2EC5, 0x3338, 0x365B, 0x33AB, 0x30BD, 0x2BCF, 0x2521, 0x20B6,
    0x2115, 0x2357, 0x27DA, 0x2CBD, 0x2BA8, 0x2335, 0x15A7, 0x0AE9, 0x01FB, 0xFA79, 0xF7A1, 0xF706, 0xF799, 0xF912, 0xF80B, 0xF735,
    0xF5BE, 0xF69E, 0xF99B, 0xF97F, 0xF6DD, 0xF5C6, 0xFE5A, 0x0684, 0x0CAD, 0x1085, 0x100E, 0x164D, 0x1BC2, 0x1E83, 0x1FF1, 0x1E12,
    0x1F1F, 0x1BEB, 0x1640, 0x14C3, 0x1263, 0x1043, 0x0C75, 0x0655, 0xFF3D, 0xF760, 0xF2A7, 0xF32E, 0xF357, 0xF41F, 0xF618, 0xF570,
    0xF5A0, 0xF8C0, 0x0257, 0x0D45, 0x19EA, 0x237B, 0x2727, 0x275D, 0x213A, 0x1DE9, 0x1ABA, 0x1499, 0x1380, 0x1479, 0x15EB, 0x1A52,
    0x1DC7, 0x195F, 0x0F1A, 0x04F8, 0xFA6B, 0xF3D1, 0xED09, 0xE822, 0xE4F0, 0xE296, 0xE294, 0xE0A6, 0xDF62, 0xDEB2, 0xDFD2, 0xDE59,
    0xD584, 0xCDB8, 0xCC1A, 0xCBF5, 0xCEB9, 0xD030, 0xD0D4, 0xD27E, 0xD8C6, 0xE122, 0xE48B, 0xEA95, 0xF0FC, 0xF596, 0xF6F0, 0xF836,
    0xFD08, 0xFF69, 0x00BB, 0x0393, 0x03D3, 0xFD71, 0xF959, 0xF5DB, 0xEF18, 0xEB70, 0xEAAF, 0xE8C2, 0xE54D, 0xE53D, 0xEA3E, 0xF29B,
    0xFB57, 0x078F, 0x0DF8, 0x1017, 0x0DA8, 0x0851, 0x0371, 0xF884, 0xF29B, 0xEE25, 0xEB4A, 0xEF30, 0xF3BA, 0xF372, 0xEEFF, 0xE539,
    0xD975, 0xCDB5, 0xC458, 0xBBB6, 0xB525, 0xB227, 0xAFB4, 0xAF80, 0xADBF, 0xAB25, 0xABCE, 0xACA6, 0xA8A9, 0xA380, 0xA219, 0xA532,
    0xA8E2, 0xADC5, 0xB12C, 0xB59D, 0xBC7E, 0xC225, 0xC616, 0xC9C9, 0xCD97, 0xD0A2, 0xD232, 0xD1B1, 0xD37B, 0xD42A, 0xD7D8, 0xDC2A,
    0xDBE5, 0xDB2A, 0xDC08, 0xDCC1, 0xDBFB, 0xDD18, 0xDEB5, 0xDEA6, 0xDB4B, 0xD8A5, 0xD8E4, 0xDEE1, 0xEBEB, 0xFCA5, 0x0A09, 0x11DD,
    0x175A, 0x16BA, 0x1125, 0x0C19, 0x0B10, 0x08D6, 0x083B, 0x0B7C, 0x1157, 0x15B5, 0x1479, 0x0CC2, 0xFFFE, 0xF209, 0xE414, 0xD73A,
    0xCC35, 0xC5D3, 0xC08C, 0xBCC2, 0xB9EB, 0xB801, 0xB8EF, 0xBA85, 0xB9C5, 0xB7A2, 0xB2F2, 0xB0E2, 0xB4AB, 0xB8A3, 0xB9B6, 0xBBC4,
    0xC0DC, 0xC517, 0xC874, 0xCBC8, 0xD0D3, 0xD43C, 0xD505, 0xD467, 0xD7A4, 0xD8D2, 0xD850, 0xDCDF, 0xE012, 0xE18E, 0xE348, 0xE597,
    0xE55A, 0xE62B, 0xE978, 0xEB89, 0xEC46, 0xEDF1, 0xEDC0, 0xEF6D, 0xF492, 0xFE31, 0x0ACB, 0x1197, 0x1534, 0x1506, 0x140D, 0x108E,
    0x0B98, 0x0901, 0x06C1, 0x08E6, 0x0F49, 0x179A, 0x1F27, 0x2050, 0x1E6B, 0x1BBF, 0x1702, 0x1007, 0x0927, 0x0236, 0xFBD3, 0xFA2F,
    0xF636, 0xF209, 0xEE98, 0xECE7, 0xED38, 0xEA83, 0xE49A, 0xE041, 0xE1F8, 0xE264, 0xE255, 0xE5C3, 0xE6F0, 0xE93F, 0xEC24, 0xEEAF,
    0xF179, 0xF0A6, 0xF2B2, 0xF34E, 0xF225, 0xEEC3, 0xEEC7, 0xF2F4, 0xF225, 0xF023, 0xF25B, 0xF2C2, 0xEE1A, 0xEC42, 0xEAC2, 0xEA05,
    0xE805, 0xE563, 0xE177, 0xE009, 0xE446, 0xEA00, 0xF3BC, 0xFDDC, 0x0687, 0x0D09, 0x0EA5, 0x0F08, 0x0FF4, 0x11EB, 0x1338, 0x1345,
    0x1743, 0x1DAE, 0x2505, 0x28D5, 0x2786, 0x2519, 0x1E7F, 0x158F, 0x0B77, 0x039C, 0x006D, 0x00C0, 0x0073, 0xFEA6, 0xFCD3, 0xFD6E,
    0x024B, 0x0299, 0xFD82, 0xF7C2, 0xF95E, 0xFC71, 0x00DE, 0x0A22, 0x11CB, 0x1800, 0x1D7A, 0x22D1, 0x2674, 0x2B15, 0x2EE7, 0x3371,
    0x378A, 0x3900, 0x39F6, 0x39BA, 0x3ADB, 0x37D6, 0x359B, 0x3194, 0x2A06, 0x267D, 0x2016, 0x1AA7, 0x16D1, 0x10B7, 0x0BBD, 0x06B4,
    0x056F, 0x0A1C, 0x1174, 0x1DF6, 0x27E5, 0x2DC6, 0x31A3, 0x31C3, 0x32F8, 0x3258, 0x31A0, 0x33FB, 0x33A8, 0x3658, 0x3C29, 0x3F90,
    0x4237, 0x3F4C, 0x3C41, 0x370F, 0x2D57, 0x25AA, 0x1CDD, 0x176A, 0x16C7, 0x14B5, 0x11F4, 0x1054, 0x14EE, 0x17C6, 0x1411, 0x11D3,
    0x0F89, 0x0DB0, 0x0E86, 0x109E, 0x1449, 0x1645, 0x187F, 0x1C05, 0x1C72, 0x1F24, 0x2151, 0x26B9, 0x2A67, 0x2A2F, 0x2D87, 0x2F99,
    0x3347, 0x35D3, 0x3A3F, 0x3E8F, 0x3FBB, 0x406D, 0x3B65, 0x3716, 0x34B9, 0x2F1D, 0x2B25, 0x257A, 0x1FCF, 0x1DEE, 0x1E00, 0x25C4,
    0x2DF2, 0x36B0, 0x3CD6, 0x3E22, 0x4067, 0x3E8E, 0x3BBB, 0x3819, 0x3496, 0x3321, 0x351B, 0x3958, 0x3AC4, 0x3935, 0x36F7, 0x313F,
    0x288B, 0x1F05, 0x14B6, 0x0B93, 0x066C, 0x02D9, 0xFBC9, 0xF55E, 0xF342, 0xF42B, 0xEFF8, 0xE91B, 0xE454, 0xDF41, 0xDD1F, 0xDDFF,
    0xE1DB, 0xE56B, 0xE6A8, 0xEB1D, 0xED5A, 0xEF52, 0xF5FC, 0xFDEA, 0x094F, 0x0EA6, 0x1372, 0x1768, 0x15A8, 0x17A8, 0x169C, 0x1581,
    0x15EB, 0x14EE, 0x155F, 0x135D, 0x11A1, 0x1160, 0x0E2D, 0x0ADB, 0x05A8, 0x037D, 0x0435, 0x04B2, 0x0BEE, 0x1390, 0x1B02, 0x228D,
    0x27C7, 0x2D71, 0x2F3B, 0x3073, 0x3040, 0x2C50, 0x2C7E, 0x2FB9, 0x34A4, 0x38C9, 0x3BB9, 0x3E32, 0x3AF4, 0x32C3, 0x25AD, 0x1868,
    0x0F69, 0x064E, 0xFB23, 0xF06A, 0xE7B6, 0xE297, 0xDED2, 0xDA1F, 0xD3D6, 0xCD80, 0xCC18, 0xCCC9, 0xCF5B, 0xD305, 0xD628, 0xDA0B,
    0xDCB7, 0xDE1D, 0xE294, 0xEA5C, 0xF262, 0xF936, 0xFDC6, 0xFFE1, 0x0168, 0x016F, 0x00D8, 0x034B, 0x075E, 0x09A6, 0x08E8, 0x0822,
    0x03E1, 0x013E, 0x0022, 0xFF4E, 0xFF3A, 0xFD8C, 0xFE2B, 0xFF71, 0x0559, 0x0C77, 0x12FD, 0x191A, 0x1C33, 0x1C7E, 0x1C17, 0x1CC3,
    0x19BF, 0x15A3, 0x1167, 0x1087, 0x1037, 0x0DD2, 0x0F4E, 0x0E23, 0x0F60, 0x0E36, 0x082D, 0x02CB, 0xFD0D, 0xFD34, 0xF67C, 0xEE4E,
    0xEA8B, 0xE3FC, 0xE220, 0xDE15, 0xD8D9, 0xD568, 0xCD70, 0xC9C2, 0xC951, 0xCB27, 0xCFDB, 0xD2A5, 0xD737, 0xD848, 0xDA09, 0xDE60,
    0xE1BB, 0xE815, 0xEC53, 0xEDBE, 0xF0A5, 0xF100, 0xF007, 0xF083, 0xF295, 0xF42F, 0xF2FE, 0xF231, 0xEE1A, 0xEA66, 0xE7F7, 0xE586,
    0xE3B2, 0xE251, 0xE031, 0xDBF1, 0xDB6B, 0xDCCA, 0xE1BD, 0xE678, 0xEA30, 0xF191, 0xF576, 0xF8EB, 0xFBD7, 0xFAED, 0xF97F, 0xF73A,
    0xFC5A, 0x0126, 0x03E9, 0x0AFA, 0x0E6C, 0x1000, 0x085B, 0xFDAD, 0xF590, 0xEBC5, 0xE512, 0xDE93, 0xDA3C, 0xD6BD, 0xD4DF, 0xD7C3,
    0xD4D7, 0xCFC3, 0xCB04, 0xC769, 0xC887, 0xC6DA, 0xCAED, 0xCFFA, 0xD2B0, 0xD7A3, 0xD9D1, 0xE05F, 0xE705, 0xF13B, 0xFB0A, 0xFE05,
    0x04D3, 0x06D0, 0x0793, 0x0AC4, 0x0E27, 0x149C, 0x182C, 0x1B18, 0x183B, 0x1100, 0x0B57, 0x0320, 0xFD87, 0xF717, 0xF129, 0xEF11,
    0xEA81, 0xE945, 0xEB26, 0xF04A, 0xF4F4, 0xF942, 0x01D2, 0x0705, 0x0E68, 0x1250, 0x1184, 0x12EE, 0x1474, 0x184E, 0x19D5, 0x1BF2,
    0x2098, 0x2467, 0x22E5, 0x19C9, 0x12A3, 0x0A36, 0x0178, 0xFC3C, 0xF31E, 0xEB80, 0xE52D, 0xE13E, 0xDEC6, 0xD965, 0xD731, 0xD4E7,
    0xD3F8, 0xD50B, 0xD607, 0xDC5F, 0xDDBB, 0xDEAF, 0xE1CE, 0xE07A, 0xE4DF, 0xEAD6, 0xF1A4, 0xF4E9, 0xF658, 0xF96E, 0xF4A4, 0xF325,
    0xF4F3, 0xF7A4, 0xFFD9, 0x03E3, 0x083A, 0x0A4E, 0x0964, 0x0B3F, 0x0AC8, 0x0CAC, 0x0B19, 0x0979, 0x0728, 0x027D, 0x0551, 0x073F,
    0x09E8, 0x0E6D, 0x117A, 0x19B2, 0x2240, 0x2948, 0x2C88, 0x2CF7, 0x2F6A, 0x2E59, 0x2DE3, 0x2BB5, 0x2CAA, 0x336C, 0x33B7, 0x2F74,
    0x28B9, 0x2073, 0x1763, 0x0E84, 0x05CC, 0xFAB6, 0xF07D, 0xEA43, 0xE3BF, 0xDD53, 0xD5B3, 0xCFA8, 0xC980, 0xC31F, 0xBFB8, 0xBDE1,
    0xBDA9, 0xBC18, 0xBC9B, 0xBBEE, 0xBD0B, 0xC149, 0xC52E, 0xCB26, 0xD02A, 0xD24D, 0xD4C5, 0xD777, 0xDC4D, 0xDF53, 0xE47F, 0xEB18,
    0xEBF8, 0xEC6D, 0xE760, 0xE4FB, 0xE461, 0xE1CF, 0xE44B, 0xE7CE, 0xE943, 0xE991, 0xEAC3, 0xED89, 0xEF44, 0xF41C, 0xF9E4, 0x00F6,
    0x0E3B, 0x1813, 0x206F, 0x2585, 0x2886, 0x2DF3, 0x3194, 0x34C3, 0x391F, 0x4096, 0x4777, 0x47AA, 0x47A5, 0x4461, 0x3F82, 0x3E63,
    0x3AA6, 0x33EC, 0x2A14, 0x1FF2, 0x157E, 0x09CB, 0xFC89, 0xF299, 0xEBE6, 0xE434, 0xDCAE, 0xD8A3, 0xD614, 0xD378, 0xD1C3, 0xCFA5,
    0xCFA8, 0xD3FA, 0xD93E, 0xDCBA, 0xE1AF, 0xE4E4, 0xE730, 0xE76D, 0xE6B1, 0xE946, 0xEE09, 0xF272, 0xF458, 0xF6AD, 0xF619, 0xF14F,
    0xEDEE, 0xEAD4, 0xE994, 0xEA7A, 0xE899, 0xE90A, 0xE8F7, 0xEB7A, 0xF219, 0xF73F, 0xFAE7, 0xFE71, 0x0A3A, 0x14DA, 0x1A0C, 0x21BF,
    0x25CD, 0x2954, 0x2C1C, 0x29D3, 0x29F6, 0x2B95, 0x2F8F, 0x30FB, 0x2D81, 0x2866, 0x21E4, 0x1EA3, 0x1A36, 0x16FE, 0x15AD, 0x0FB4,
    0x0BB8, 0x0A82, 0x0695, 0x0284, 0xFDBD, 0xF7E3, 0xF041, 0xEA72, 0xE714, 0xE52A, 0xE54D, 0xE46A, 0xE478, 0xE602, 0xE90C, 0xEE12,
    0xF511, 0xF836, 0xF9BF, 0xFD0D, 0xFBA0, 0xF9D3, 0xFC74, 0xFFCC, 0x04DC, 0x06EE, 0x059F, 0x0281, 0xFD30, 0xF8C6, 0xF368, 0xF37F,
    0xF1E2, 0xEF10, 0xEE8C, 0xE948, 0xE93E, 0xEAA2, 0xE6F0, 0xE5FC, 0xE890, 0xEDBA, 0xF3B0, 0xF7B4, 0xFB17, 0xFC79, 0x00ED, 0x0280,
    0x0238, 0x0721, 0x0B20, 0x12E0, 0x161B, 0x13D7, 0x1336, 0x12D9, 0x11A7, 0x0C45, 0x073C, 0x0095, 0xF7AB, 0xF238, 0xEADF, 0xE620,
    0xE4CC, 0xE0C8, 0xDD45, 0xD857, 0xD4CC, 0xD364, 0xD34D, 0xD3FE, 0xD506, 0xD9C4, 0xDDC1, 0xE256, 0xEA14, 0xEFBE, 0xF4B1, 0xFAE5,
    0xFE5E, 0x01F0, 0x0960, 0x10A6, 0x1792, 0x1E60, 0x2305, 0x261D, 0x24DB, 0x21AD, 0x2071, 0x1EB7, 0x1C63, 0x18FD, 0x1431, 0x0C42,
    0x06BD, 0x066C, 0xFF69, 0xF994, 0xF95C, 0xF9EE, 0xFD69, 0xFF20, 0x0357, 0x07A1, 0x0B28, 0x1020, 0x12CF, 0x16C1, 0x1842, 0x1D85,
    0x24CF, 0x228D, 0x2284, 0x2235, 0x1FD3, 0x2026, 0x1D25, 0x1846, 0x0F30, 0x077F, 0xFFEB, 0xF687, 0xF294, 0xECB8, 0xE713, 0xE274,
    0xDB0A, 0xDA0E, 0xDAC0, 0xDA60, 0xDDB1, 0xE15B, 0xE3C2, 0xE779, 0xEF6D, 0xF448, 0xF807, 0xFE8F, 0x00ED, 0x0085, 0x00D3, 0x0337,
    0x0711, 0x0A3A, 0x0AFA, 0x0A6C, 0x09FF, 0x031A, 0x0077, 0x01EF, 0x02A1, 0x08D5, 0x0B37, 0x0C41, 0x0E3F, 0x121D, 0x1326, 0x0C66,
    0x0A92, 0x0934, 0x090F, 0x0E1A, 0x107B, 0x17A6, 0x1E03, 0x21A8, 0x267F, 0x25C6, 0x2740, 0x2A48, 0x2EC0, 0x2F6B, 0x2AFF, 0x2BEB,
    0x269C, 0x22FD, 0x2217, 0x19E1, 0x1581, 0x0BB1, 0x013C, 0xFAE8, 0xF1CF, 0xEC7F, 0xE37D, 0xDB67, 0xD14D, 0xC885, 0xC74E, 0xC2FA,
    0xC4F0, 0xC6D4, 0xC59E, 0xC642, 0xC56B, 0xC708, 0xC861, 0xCB9D, 0xCF91, 0xD31A, 0xDA2B, 0xDEAB, 0xE61B, 0xEFA5, 0xF365, 0xF837,
    0xFA0D, 0xF737, 0xF52F, 0xF222, 0xF182, 0xF42C, 0xF927, 0xF807, 0xF656, 0xFB6F, 0xFBC5, 0xFBDE, 0xF95F, 0xF878, 0xFBE3, 0xFE9B,
    0x026E, 0x07D4, 0x11C2, 0x1920, 0x20B4, 0x26A1, 0x26C5, 0x29BF, 0x2D32, 0x2E6C, 0x3016, 0x3115, 0x33C6, 0x3699, 0x392C, 0x39B7,
    0x3781, 0x34FB, 0x2AC6, 0x23DA, 0x1E88, 0x139E, 0x0F46, 0x0566, 0xF796, 0xEB15, 0xDEFA, 0xD829, 0xD098, 0xCFCD, 0xCEE4, 0xCCE8,
    0xCD8B, 0xCA2F, 0xCD23, 0xD0B0, 0xD29C, 0xDA82, 0xDFE4, 0xE5D2, 0xEE36, 0xF4FB, 0xFB13, 0xFF9B, 0x06E4, 0x06A6, 0x0302, 0x049F,
    0x01ED, 0x034F, 0x0384, 0x00A0, 0x0169, 0x00A2, 0x024B, 0x02F4, 0x024D, 0xFEE4, 0xFD5B, 0x0206, 0x0331, 0x09DE, 0x1444, 0x1DFA,
    0x2AE8, 0x33A2, 0x37A7, 0x3B8D, 0x3F54, 0x4233, 0x4224, 0x40CD, 0x3F16, 0x3C97, 0x3AB1, 0x34B3, 0x3051, 0x28AC, 0x1D4F, 0x1547,
    0x0DAE, 0x06F5, 0x02D6, 0x020F, 0xFB07, 0xF3E2, 0xED8B, 0xE6C6, 0xE3CE, 0xDF65, 0xDCB1, 0xDB65, 0xDAB5, 0xD98D, 0xDA39, 0xDD8B,
    0xDEA5, 0xE2EC, 0xE6E2, 0xE80B, 0xEF66, 0xF894, 0xFEB4, 0x0687, 0x0C12, 0x0DAB, 0x0BB0, 0x06AF, 0x02CF, 0x02E6, 0x071E, 0x0584,
    0x0527, 0x06E8, 0x05C4, 0x07F3, 0x0476, 0xFE21, 0xF9E6, 0xF614, 0xF309, 0xF24D, 0xF729, 0xFD0E, 0x05CF, 0x0DAB, 0x0EC1, 0x0F3D,
    0x0E67, 0x0D86, 0x101F, 0x12D3, 0x14DB, 0x1B53, 0x1EA4, 0x1C98, 0x1D1F, 0x194A, 0x0FB3, 0x061B, 0xFF2E, 0xF7A4, 0xF0BD, 0xEDDE,
    0xE8C8, 0xE101, 0xD83F, 0xCD84, 0xC881, 0xC5D8, 0xC39E, 0xC798, 0xC795, 0xC798, 0xC94D, 0xC962, 0xCBAB, 0xCE9F, 0xD609, 0xD981,
    0xDE8D, 0xE7AB, 0xEB65, 0xF359, 0xF9A1, 0x00B7, 0x095B, 0x0B42, 0x0D2F, 0x11C6, 0x1748, 0x1988, 0x1C1B, 0x1F13, 0x1F14, 0x2493,
    0x2876, 0x23F6, 0x2072, 0x1A71, 0x13E2, 0x0D7C, 0x08D4, 0x0B04, 0x11B6, 0x1AFC, 0x1E48, 0x213B, 0x22C7, 0x1F9D, 0x245F, 0x2583,
    0x2672, 0x2C7F, 0x2F67, 0x30CF, 0x2FB7, 0x30D0, 0x2C8A, 0x272F, 0x216E, 0x17FD, 0x12C0, 0x0C24, 0x0444, 0xFC78, 0xF1A8, 0xE70C,
    0xDEAB, 0xD6A3, 0xD0E0, 0xD029, 0xD0DA, 0xCE86, 0xCF90, 0xD126, 0xD0FE, 0xD64E, 0xDAC4, 0xE056, 0xE7FF, 0xF030, 0xF800, 0xFDC6,
    0x04A8, 0x0655, 0x083C, 0x05E0, 0xFDD4, 0xFA33, 0xF631, 0xF2A6, 0xF16D, 0xF193, 0xF324, 0xF92C, 0x0085, 0x04AC, 0x0747, 0x07D1,
    0x03C3, 0x01B7, 0x00AC, 0xFFF6, 0x080A, 0x10BE, 0x1A78, 0x241D, 0x2675, 0x2754, 0x29A8, 0x2C6F, 0x2CD4, 0x30BF, 0x36BD, 0x37FE,
    0x3A9E, 0x3B81, 0x36D1, 0x32C2, 0x2C05, 0x2254, 0x1CA9, 0x15F4, 0x1131, 0x0CFE, 0x03C8, 0xF93E, 0xEF22, 0xE5A4, 0xDA87, 0xD571,
    0xD402, 0xD06F, 0xD007, 0xCDDC, 0xCA56, 0xCA3E, 0xC878, 0xC63E, 0xC75C, 0xC887, 0xCA5A, 0xCF49, 0xD473, 0xDA34, 0xE3C2, 0xE975,
    0xE7A2, 0xE606, 0xE2EA, 0xDEFC, 0xDD3B, 0xD9FD, 0xD8A6, 0xDD1C, 0xE49F, 0xE82F, 0xEB76, 0xECCC, 0xE996, 0xE7CA, 0xE052, 0xDC42,
    0xE210, 0xE992, 0xF3E5, 0xFFFE, 0x0A90, 0x0EEC, 0x1311, 0x1805, 0x1AF2, 0x2122, 0x24B1, 0x26D5, 0x2C26, 0x2D2B, 0x2DBE, 0x312D,
    0x3189, 0x321C, 0x3270, 0x3185, 0x2EFF, 0x2E49, 0x2B7C, 0x2134, 0x1A25, 0x0FBF, 0x0504, 0xFF75, 0xF921, 0xF4F8, 0xF070, 0xEA99,
    0xE33D, 0xDE39, 0xDC9D, 0xDA8E, 0xDD45, 0xE04E, 0xE198, 0xE7E4, 0xEAEF, 0xEED1, 0xF70B, 0xFC8C, 0x00A4, 0x00B9, 0xFF6C, 0xFCAE,
    0xFA9A, 0xF9B9, 0xF465, 0xF544, 0xF823, 0xFB0D, 0xFFD4, 0xFB27, 0xF827, 0xF514, 0xECB2, 0xE4C0, 0xE057, 0xE366, 0xE8DF, 0xF3B2,
    0xFD07, 0x0269, 0x0C2B, 0x1125, 0x1526, 0x1D8C, 0x23DA, 0x2AE7, 0x307F, 0x3330, 0x3436, 0x3484, 0x3265, 0x2A96, 0x25F9, 0x1EE2,
    0x153A, 0x1105, 0x09E5, 0x043A, 0xFE90, 0xF76C, 0xF032, 0xE993, 0xE784, 0xE47E, 0xE60A, 0xE412, 0xE0ED, 0xE3FF, 0xE058, 0xDDC0,
    0xDF5D, 0xE15D, 0xE5F6, 0xEA2E, 0xF068, 0xF567, 0xFD6C, 0x07C6, 0x095D, 0x0DBF, 0x0D62, 0x0B51, 0x0CBF, 0x0538, 0x0240, 0xFFEC,
    0xFF92, 0x03FC, 0x0850, 0x0D75, 0x09E3, 0x07FA, 0x01B7, 0xF464, 0xEE57, 0xE640, 0xE4F1, 0xEB61, 0xF040, 0xF704, 0xF95A, 0xFA60,
    0xFAC8, 0xFB54, 0xFB37, 0xF95B, 0xFF9F, 0x01F0, 0x011C, 0x06F8, 0x08EE, 0x0AD3, 0x0AFF, 0x089E, 0x0521, 0xFF1D, 0xF9DD, 0xF1B3,
    0xEBB4, 0xE332, 0xDAB6, 0xD797, 0xD136, 0xCF63, 0xD0D2, 0xCEF0, 0xCB71, 0xC8A8, 0xC76B, 0xC664, 0xC949, 0xCC65, 0xD0D6, 0xD9CA,
    0xE06C, 0xE54A, 0xED63, 0xF62B, 0xFF35, 0x0593, 0x056A, 0x04DE, 0x05CE, 0x0531, 0x045D, 0x08B3, 0x0DB5, 0x15A8, 0x2074, 0x259A,
    0x29A1, 0x2C26, 0x2A2A, 0x21FA, 0x19EB, 0x12B4, 0x0B15, 0x0A31, 0x09A1, 0x0AE4, 0x0E87, 0x0DC0, 0x0E07, 0x1030, 0x0FC5, 0x105D,
    0x124E, 0x1182, 0x0FCD, 0x112E, 0x12B1, 0x138F, 0x16BA, 0x179A, 0x1518, 0x12F3, 0x0D03, 0x0616, 0x0087, 0xF694, 0xEE06, 0xE5C8,
    0xDB5C, 0xD55B, 0xD23C, 0xCDED, 0xC9AC, 0xC80A, 0xC4A0, 0xC050, 0xC11D, 0xC1DC, 0xC4C7, 0xCD4E, 0xD499, 0xDE58, 0xEA10, 0xF60A,
    0x0617, 0x142A, 0x1C0F, 0x1D9A, 0x1FAA, 0x1D50, 0x1499, 0x10BB, 0x0989, 0x0799, 0x0CFB, 0x0F9D, 0x14B8, 0x192A, 0x1AAF, 0x1949,
    0x1388, 0x0C41, 0x053E, 0x046F, 0x07F7, 0x0BC7, 0x15DA, 0x1B2B, 0x1E4B, 0x2332, 0x21EA, 0x2385, 0x26AC, 0x26F7, 0x27A9, 0x2807,
    0x286C, 0x2947, 0x2A4C, 0x29EB, 0x29D4, 0x299B, 0x23F3, 0x1D83, 0x1920, 0x1022, 0x066E, 0xFDCF, 0xF31A, 0xEA21, 0xE433, 0xDE02,
    0xD71F, 0xD42C, 0xCE6D, 0xC8A8, 0xC545, 0xBF34, 0xBD7C, 0xBE0A, 0xBE04, 0xC054, 0xC4E5, 0xCA4E, 0xD226, 0xDC62, 0xE2B7, 0xE627,
    0xE980, 0xE8B0, 0xE88C, 0xEA56, 0xE95C, 0xE982, 0xECD3, 0xEF91, 0xF20D, 0xF680, 0xF884, 0xF8E4, 0xF993, 0xF3E5, 0xED3D, 0xEAD5,
    0xE684, 0xE87D, 0xEE18, 0xF308, 0xF9B9, 0x02DE, 0x0C05, 0x10C8, 0x19B6, 0x200C, 0x22CF, 0x25C5, 0x2435, 0x263D, 0x293B, 0x2A45,
    0x2CCF, 0x2D64, 0x2AA2, 0x2839, 0x255B, 0x1FAC, 0x1C8B, 0x1A70, 0x1407, 0x0C35, 0x09E8, 0x04E5, 0xFEE8, 0xFAC8, 0xF225, 0xED5F,
    0xE70F, 0xDD39, 0xD49D, 0xD02C, 0xCE2E, 0xCC13, 0xCFB9, 0xD260, 0xD919, 0xE5E6, 0xEB5E, 0xEF9B, 0xF1F7, 0xF067, 0xF056, 0xEE58,
    0xEEE0, 0xEFF5, 0xF324, 0xF71E, 0xF8A3, 0xFFDF, 0x025B, 0x042C, 0x0987, 0x03E4, 0xFF4B, 0xF8D8, 0xF004, 0xEDAD, 0xEC76, 0xF112,
    0xF56B, 0xFB6A, 0x02F3, 0x0894, 0x135F, 0x195D, 0x1F83, 0x295C, 0x2D63, 0x33BF, 0x3B79, 0x41B9, 0x4990, 0x4D36, 0x4AD1, 0x44F0,
    0x3E01, 0x33C5, 0x27B5, 0x1F11, 0x1400, 0x0A4B, 0x020C, 0xF809, 0xF2D4, 0xEF01, 0xE978, 0xE451, 0xE114, 0xDC03, 0xD5C9, 0xD37A,
    0xD1EE, 0xD3E6, 0xD756, 0xD983, 0xDEFE, 0xE711, 0xEFE0, 0xF828, 0xFE47, 0xFEC2, 0xFDDB, 0xFD9A, 0xF897, 0xF5FC, 0xF81B, 0xF89B,
    0xFCC9, 0x01FB, 0x0557, 0x0ADC, 0x100C, 0x10DA, 0x0BDB, 0x0706, 0x0023, 0xF9B7, 0xF909, 0xF8A0, 0xFDF9, 0x0426, 0x069F, 0x0A87,
    0x0D3E, 0x100D, 0x1151, 0x11BE, 0x0F8D, 0x0DEE, 0x11CE, 0x11C5, 0x1586, 0x1D6D, 0x1FD4, 0x2021, 0x1CBF, 0x17F5, 0x1357, 0x0D7C,
    0x05DE, 0xFC30, 0xF53B, 0xEBD5, 0xE359, 0xDE17, 0xD505, 0xD1FF, 0xCFD8, 0xC9AA, 0xC4C7, 0xBF5E, 0xBBF8, 0xB98D, 0xBBDA, 0xC01B,
    0xC50F, 0xD110, 0xDC48, 0xE786, 0xF1CD, 0xF339, 0xF438, 0xF383, 0xEFD9, 0xEFE3, 0xEF0C, 0xED8F, 0xEF65, 0xF38D, 0xF865, 0xFEC1,
    0x0969, 0x13FA, 0x1C55, 0x205E, 0x1C89, 0x17F8, 0x14A6, 0x1079, 0x10CD, 0x1484, 0x16EB, 0x1D01, 0x22D1, 0x23C4, 0x2697, 0x28D0,
    0x28B8, 0x26D6, 0x281E, 0x2B32, 0x2D6F, 0x3264, 0x3231, 0x33DD, 0x34B0, 0x2E2B, 0x2ABA, 0x2641, 0x2232, 0x1E5A, 0x15D7, 0x0DAD,
    0x0545, 0xFEA6, 0xF631, 0xEEB8, 0xEBEE, 0xE46D, 0xDC44, 0xD223, 0xC6D1, 0xC1A0, 0xBF0A, 0xBDBA, 0xBED7, 0xC3A2, 0xCB74, 0xD585,
    0xE34E, 0xEE93, 0xF8F9, 0x0009, 0x0142, 0x0362, 0x0290, 0x01E7, 0x0119, 0xFF08, 0xFAEC, 0xF88F, 0xFABC, 0xFA51, 0xFD57, 0xFFEA,
    0xFD79, 0xFA6D, 0xF4E8, 0xF029, 0xEF7B, 0xF169, 0xF4D6, 0xFA1A, 0x0292, 0x08FB, 0x0FCA, 0x17FF, 0x1AB2, 0x1E65, 0x2052, 0x201F,
    0x2499, 0x2AEC, 0x3178, 0x36DD, 0x3989, 0x3644, 0x332B, 0x3044, 0x2A69, 0x2937, 0x256F, 0x1F46, 0x179B, 0x0F06, 0x0730, 0xFCCA,
    0xF878, 0xF33E, 0xED55, 0xE9C6, 0xDF5F, 0xD92C, 0xD4A3, 0xD008, 0xD0E8, 0xCED2, 0xD0F6, 0xD6F1, 0xDD07, 0xE327, 0xE46E, 0xE756,
    0xE7E2, 0xE6FD, 0xE89A, 0xE536, 0xE503, 0xE580, 0xE2DE, 0xE41B, 0xE589, 0xE9B5, 0xEFE8, 0xF45C, 0xF60B, 0xF554, 0xF13C, 0xE911,
    0xE265, 0xDF03, 0xDDB1, 0xE0BA, 0xE7DF, 0xED1F, 0xF399, 0xFB9E, 0x0010, 0x062E, 0x0C11, 0x0F71, 0x156A, 0x1BD0, 0x20DB, 0x271B,
    0x2B9F, 0x2C53, 0x29B8, 0x27F7, 0x26C5, 0x245C, 0x21C1, 0x1C52, 0x198F, 0x15F9, 0x10A0, 0x1049, 0x1079, 0x1139, 0x10B1, 0x0B37,
    0x0218, 0xF85E, 0xEF74, 0xE6E8, 0xE49F, 0xE3C9, 0xE353, 0xE84F, 0xED90, 0xF334, 0xF985, 0xFD70, 0xFDF1, 0xFDD4, 0xFD3B, 0xF9E4,
    0xF73C, 0xF603, 0xF2CD, 0xF13F, 0xF14B, 0xF338, 0xFB4A, 0x0230, 0x0734, 0x0A8F, 0x08B1, 0x029C, 0xF9E9, 0xF2C5, 0xEB54, 0xE9E3,
    0xEBC5, 0xEBDA, 0xF068, 0xF3CE, 0xF5A0, 0xF8D7, 0xF9AC, 0xFB9B, 0x0194, 0x07FC, 0x11DD, 0x1E3C, 0x2ABD, 0x3471, 0x38A2, 0x3B89,
    0x3A60, 0x3A93, 0x3A1B, 0x332C, 0x2D9E, 0x26BB, 0x1D39, 0x16AA, 0x0F01, 0x0818, 0x0736, 0x02EB, 0xFC5E, 0xF3AD, 0xEB93, 0xE593,
    0xDE7C, 0xDEF3, 0xDE38, 0xE159, 0xEA6C, 0xF201, 0xFD43, 0x06EE, 0x0DB2, 0x14A6, 0x1600, 0x1539, 0x15D3, 0x1406, 0x1116, 0x0E72,
    0x0D21, 0x0AA2, 0x0D53, 0x1622, 0x1C1B, 0x2440, 0x2928, 0x25E7, 0x20FA, 0x1817, 0x0F2D, 0x0AF0, 0x0A78, 0x0C6D, 0x10C6, 0x155B,
    0x1790, 0x1AB0, 0x1971, 0x14AF, 0x115C, 0x0D5B, 0x0BEF, 0x0D1E, 0x101B, 0x1321, 0x148B, 0x157B, 0x1377, 0x11BD, 0x0F00, 0x07E0,
    0x01FF, 0xFA30, 0xF034, 0xEA06, 0xE30C, 0xDE08, 0xDB7D, 0xD883, 0xD395, 0xCB26, 0xC182, 0xB840, 0xB4BE, 0xB2A7, 0xB02C, 0xB329,
    0xB8FA, 0xBF8A, 0xC810, 0xD215, 0xDB0B, 0xE60F, 0xEE80, 0xF29F, 0xF825, 0xFA3D, 0xFA20, 0xF98F, 0xF7BC, 0xF6FF, 0xF904, 0xFE18,
    0x041A, 0x0CF5, 0x1699, 0x1AEE, 0x1ED2, 0x1E9A, 0x1C89, 0x1F5F, 0x1F45, 0x229C, 0x26FF, 0x2A1A, 0x2F8E, 0x3195, 0x3579, 0x354B,
    0x34FF, 0x36C0, 0x30A7, 0x301B, 0x311B, 0x312A, 0x358B, 0x35A2, 0x3649, 0x3529, 0x30DA, 0x2BDE, 0x24D7, 0x1E7E, 0x16FC, 0x11A3,
    0x0C89, 0x04F0, 0x0120, 0xFC0D, 0xF42A, 0xED2A, 0xE1E2, 0xD60D, 0xCC77, 0xC586, 0xC151, 0xBDE3, 0xBBBD, 0xBC22, 0xC119, 0xC6CB,
    0xCE2C, 0xD7CB, 0xE2F6, 0xECF1, 0xF53F, 0xFECD, 0x0536, 0x0C35, 0x1108, 0x11DD, 0x14D6, 0x178F, 0x1D9F, 0x24D2, 0x2963, 0x2BC6,
    0x2CB2, 0x2971, 0x218B, 0x1B4F, 0x1724, 0x13D4, 0x152A, 0x1852, 0x1BB0, 0x2146, 0x2424, 0x2639, 0x2808, 0x2A77, 0x2D18, 0x2FE4,
    0x3448, 0x3AF4, 0x432D, 0x443C, 0x4470, 0x44E1, 0x408B, 0x3D86, 0x373E, 0x2F2A, 0x2932, 0x22D1, 0x1DB2, 0x1550, 0x0FA4, 0x0C9B,
    0x04F9, 0xFE1A, 0xF2F2, 0xE4B3, 0xDA63, 0xCF18, 0xC64A, 0xC1B1, 0xBF87, 0xC005, 0xC1B7, 0xC3D0, 0xC78F, 0xCD0D, 0xD13D, 0xD3A6,
    0xD7DB, 0xDAA2, 0xDA6F, 0xDBD3, 0xDB41, 0xDBA5, 0xDC61, 0xDB2D, 0xDCD8, 0xE035, 0xE479, 0xEADD, 0xEF16, 0xF21A, 0xF4BA, 0xF411,
    0xF302, 0xEFD4, 0xEFDB, 0xEFF2, 0xED1D, 0xEEF0, 0xEED9, 0xF265, 0xF901, 0xFDCA, 0x03CD, 0x07AE, 0x0C8A, 0x1332, 0x1BD3, 0x2677,
    0x2F44, 0x365D, 0x3A41, 0x3928, 0x38B4, 0x33AB, 0x2D19, 0x29A6, 0x240A, 0x2050, 0x1B4B, 0x1652, 0x1366, 0x0FE0, 0x0A95, 0x02B8,
    0xFCB4, 0xF605, 0xF19D, 0xED93, 0xE799, 0xE473, 0xE349, 0xE405, 0xE66D, 0xEC55, 0xF308, 0xF98A, 0xFDC1, 0x0032, 0x006C, 0x00D7,
    0xFFE0, 0xFD33, 0xFCB5, 0xFAC5, 0xF979, 0xF935, 0xFB54, 0xFE10, 0x0317, 0x0896, 0x0A99, 0x0C68, 0x0A1D, 0x08E9, 0x0747, 0x0422,
    0x04D8, 0x0687, 0x06D9, 0x06D0, 0x091C, 0x08C3, 0x094E, 0x0658, 0x034B, 0x049D, 0x07DC, 0x0FB7, 0x1889, 0x238E, 0x2D8E, 0x360F,
    0x3A9E, 0x3BC0, 0x3998, 0x3996, 0x368B, 0x32B5, 0x3162, 0x298F, 0x245A, 0x1A6A, 0x0F1E, 0x0407, 0xF537, 0xE913, 0xDC7D, 0xD4EF,
    0xCFFB, 0xCB3A, 0xC924, 0xC7C9, 0xC7E9, 0xCB42, 0xCE7B, 0xD5DE, 0xDF8A, 0xE62D, 0xEE71, 0xF1F7, 0xF4B1, 0xF5DD, 0xF597, 0xF324,
    0xF1A6, 0xF40D, 0xF2FF, 0xF532, 0xF874, 0xFC16, 0x0037, 0x0292, 0x03AA, 0x0447, 0x0446, 0x0310, 0x02A5, 0x006D, 0x0173, 0x031E,
    0x0656, 0x0AD3, 0x0EFE, 0x156F, 0x169B, 0x16EE, 0x1821, 0x1AA8, 0x1E9B, 0x2380, 0x260B, 0x28A7, 0x2A47, 0x285A, 0x2678, 0x21D6,
    0x1EBA, 0x1C9F, 0x1A71, 0x1627, 0x1275, 0x0E58, 0x06E6, 0x0171, 0xF938, 0xEFAC, 0xE5AE, 0xDB03, 0xD32E, 0xCB45, 0xC468, 0xBE5F,
    0xBB8E, 0xBC84, 0xBFB5, 0xC6E9, 0xD157, 0xDA62, 0xE411, 0xEA73, 0xECF2, 0xF0C5, 0xF2B1, 0xF56B, 0xF60C, 0xF716, 0xF6B5, 0xF5C6,
    0xF5D2, 0xF571, 0xF98E, 0xFDC5, 0x0144, 0x0373, 0x0437, 0x040D, 0x0500, 0x06E0, 0x0709, 0x0922, 0x0D97, 0x12A2, 0x17ED, 0x1CC6,
    0x1E6A, 0x20B8, 0x2104, 0x1FAE, 0x2535, 0x2B52, 0x3051, 0x34A9, 0x3547, 0x3340, 0x30C5, 0x2A09, 0x2593, 0x239E, 0x20AC, 0x2096,
    0x1C28, 0x173C, 0x11B5, 0x0B22, 0x066F, 0xFDD2, 0xF5D1, 0xEDEE, 0xE5D7, 0xE0EE, 0xD956, 0xD0ED, 0xCCA0, 0xC7E5, 0xC5F7, 0xC6F4,
    0xCA23, 0xCF62, 0xD448, 0xDA07, 0xDCF3, 0xE2FA, 0xE8C7, 0xED59, 0xF4AD, 0xFA58, 0xFFFE, 0x046B, 0x0563, 0x0747, 0x0BDF, 0x0FE2,
    0x131A, 0x1670, 0x1842, 0x1514, 0x1195, 0x0E4C, 0x0A4F, 0x0843, 0x069C, 0x06D4, 0x079E, 0x097A, 0x0BB0, 0x0D66, 0x0E26, 0x0E29,
    0x121D, 0x1592, 0x1D10, 0x25F6, 0x2CED, 0x3327, 0x3662, 0x376C, 0x3469, 0x3258, 0x31AD, 0x315D, 0x30BB, 0x2E46, 0x29BA, 0x260A,
    0x1FE1, 0x16BD, 0x0F3B, 0x0599, 0xFD61, 0xF7E4, 0xF085, 0xE9F8, 0xE5B8, 0xE110, 0xDE00, 0xDECF, 0xE0E7, 0xE739, 0xEEBE, 0xF2FE,
    0xF4B0, 0xF363, 0xF30A, 0xF2EB, 0xF3EC, 0xF4AF, 0xF52E, 0xF5CC, 0xF34E, 0xEE7A, 0xEBAE, 0xEB31, 0xEAD9, 0xED7B, 0xEF71, 0xEF68,
    0xF077, 0xEEBC, 0xECF8, 0xED1D, 0xEA7E, 0xE71F, 0xE5F8, 0xE32B, 0xE128, 0xE0C7, 0xDD5D, 0xDC38, 0xDD45, 0xE1BF, 0xE82B, 0xEF00,
    0xF646, 0xFCB2, 0x023D, 0x049A, 0x0499, 0x073E, 0x0B68, 0x0EB4, 0x133D, 0x1207, 0x0F29, 0x0C7F, 0x0675, 0x0221, 0xFC3D, 0xF4B6,
    0xEF6D, 0xE905, 0xE1ED, 0xDBAE, 0xD887, 0xD762, 0xD6F5, 0xDAAD, 0xE04A, 0xE639, 0xEF6D, 0xF67A, 0xFCAA, 0x0304, 0x05E2, 0x092A,
    0x0C76, 0x0E18, 0x0EE5, 0x10E6, 0x1066, 0x0BFA, 0x0919, 0x07D7, 0x0A1B, 0x0E9C, 0x0FEE, 0x1192, 0x145C, 0x129A, 0x115A, 0x12E8,
    0x129D, 0x14F3, 0x142D, 0x10B9, 0x104B, 0x0FF7, 0x0E94, 0x0A61, 0x06D7, 0x0690, 0x0614, 0x0805, 0x0B06, 0x0D1F, 0x13EB, 0x1790,
    0x192C, 0x1C42, 0x1D01, 0x2384, 0x2B46, 0x2DEB, 0x2F9B, 0x2F17, 0x2BE4, 0x2683, 0x20B5, 0x17F3, 0x0F9C, 0x0722, 0xFC6E, 0xF096,
    0xE5FC, 0xDDA4, 0xD5F7, 0xD14E, 0xCD2F, 0xCFD5, 0xD543, 0xD9A9, 0xDF3F, 0xE5DA, 0xEB62, 0xF0FD, 0xF7AF, 0xFBF0, 0x0396, 0x0A70,
    0x0D86, 0x0F18, 0x0D48, 0x08E1, 0x073B, 0x09E0, 0x0AF9, 0x0DEC, 0x1175, 0x12E9, 0x1307, 0x11F4, 0x109C, 0x0F53, 0x1082, 0x0E2D,
    0x0AEF, 0x0B28, 0x0B28, 0x0932, 0x094E, 0x086D, 0x0832, 0x0C22, 0x0BE0, 0x0DC2, 0x107C, 0x0F95, 0x0EBA, 0x0C6D, 0x06BF, 0x0473,
    0x0450, 0x026D, 0x01D3, 0xFFAF, 0xFCED, 0xF76C, 0xF1AA, 0xEAB0, 0xE2BF, 0xDD71, 0xD3EA, 0xC8D1, 0xBF81, 0xB762, 0xB2C8, 0xAF00,
    0xAAA9, 0xAA08, 0xA9FD, 0xAB49, 0xAD61, 0xB0BB, 0xB60E, 0xBB1B, 0xC23A, 0xC78B, 0xCE8B, 0xD916, 0xE006, 0xE64C, 0xEA02, 0xEA05,
    0xECA7, 0xEE7F, 0xEEC6, 0xF249, 0xF76F, 0xFC64, 0x0113, 0x0435, 0x0988, 0x0EAC, 0x1421, 0x156C, 0x153D, 0x18FD, 0x198C, 0x1CA3,
    0x20C1, 0x2279, 0x2951, 0x3198, 0x34D0, 0x3A77, 0x3EA1, 0x4154, 0x428E, 0x413A, 0x400F, 0x3C39, 0x3C21, 0x3A6B, 0x3850, 0x38A6,
    0x33F3, 0x2F3E, 0x29AE, 0x22A1, 0x1CC6, 0x1348, 0x06DE, 0xFC03, 0xF0D1, 0xE657, 0xDDEA, 0xD953, 0xD500, 0xD012, 0xCFEF, 0xCD41,
    0xCC0B, 0xCB65, 0xC9F1, 0xCB3E, 0xCC24, 0xCC31, 0xCE38, 0xD408, 0xD85F, 0xE046, 0xE6DB, 0xE8F4, 0xED70, 0xF1B4, 0xF5E6, 0xF9D9,
    0xFEC8, 0x0252, 0x04E6, 0x069B, 0x07C0, 0x0AF3, 0x0FBE, 0x0F00, 0x0B20, 0x09B5, 0x0477, 0x0439, 0x033C, 0x01A1, 0x0543, 0x098B,
    0x0E92, 0x1250, 0x1717, 0x1A7E, 0x2091, 0x248B, 0x2403, 0x2477, 0x280D, 0x2B91, 0x2F14, 0x33FC, 0x322C, 0x31F9, 0x2FEE, 0x297B,
    0x2709, 0x22B0, 0x1AEC, 0x0FB9, 0x01E8, 0xF3BA, 0xE8DB, 0xDE3D, 0xD62D, 0xD1DD, 0xD1E1, 0xD2E1, 0xD3AA, 0xD706, 0xD6F3, 0xDBC0,
    0xDE04, 0xDDE7, 0xE04A, 0xE2D4, 0xE72F, 0xEA1C, 0xED7F, 0xEED0, 0xF090, 0xF128, 0xEBD1, 0xE6FC, 0xE746, 0xE727, 0xEA09, 0xEE58,
    0xEF8C, 0xF791, 0xFC81, 0xFF8A, 0x028C, 0x000F, 0xFF2C, 0xFCCF, 0xF95C, 0xF6FE, 0xF7BF, 0xFBB8, 0xFEB1, 0x00AE, 0x0447, 0x0456,
    0x07D1, 0x0E2A, 0x0EFF, 0x15B1, 0x1C38, 0x2139, 0x280A, 0x2C4C, 0x2F88, 0x31CA, 0x345D, 0x3412, 0x3212, 0x2F06, 0x28C2, 0x2125,
    0x18AF, 0x0C95, 0x0216, 0xFA1E, 0xF165, 0xEE61, 0xE913, 0xE368, 0xE2FB, 0xE27C, 0xE2F8, 0xE8DD, 0xEFF5, 0xF3FD, 0xF94F, 0xFE4C,
    0x02A8, 0x068F, 0x0A96, 0x0C50, 0x0C88, 0x0BDE, 0x0689, 0x001E, 0xF8C7, 0xF244, 0xF07F, 0xEEFD, 0xED72, 0xF114, 0xF676, 0xFA30,
    0xFDC7, 0xFD5F, 0xFBEF, 0xFA43, 0xF977, 0xF8FF, 0xFA4B, 0xFE37, 0xFFA8, 0x0396, 0x06B5, 0x0585, 0x071D, 0x08CF, 0x04EB, 0x05B6,
    0x0669, 0x071C, 0x0D23, 0x121E, 0x1949, 0x2216, 0x295D, 0x2DD8, 0x3259, 0x349D, 0x334E, 0x2F2C, 0x2787, 0x1E92, 0x159F, 0x0CA6,
    0x031E, 0xFD09, 0xF725, 0xF043, 0xEB67, 0xE633, 0xE08F, 0xDD42, 0xDF68, 0xE0E9, 0xE55A, 0xEAD6, 0xED97, 0xF4A3, 0xFAEA, 0xFED0,
    0x0669, 0x0BB9, 0x0C1C, 0x0CF0, 0x08AB, 0x05CE, 0x03D0, 0x00E6, 0x025D, 0x052D, 0x0D1F, 0x129A, 0x17BF, 0x1B53, 0x1730, 0x13E8,
    0x0CED, 0x05F7, 0x0623, 0x070F, 0x0B61, 0x14D8, 0x1A4A, 0x1F7F, 0x2153, 0x2065, 0x20DB, 0x1E62, 0x2028, 0x2095, 0x2137, 0x24ED,
    0x24AB, 0x269B, 0x2AD7, 0x2B6E, 0x2EFC, 0x30FB, 0x2B94, 0x27C2, 0x1E0B, 0x1184, 0x0960, 0xFEA8, 0xF4D3, 0xECFB, 0xE5C7, 0xDDED,
    0xD894, 0xD215, 0xCB30, 0xC998, 0xC7A2, 0xC577, 0xC5B4, 0xC65A, 0xC53D, 0xC644, 0xC74B, 0xCA3E, 0xD07F, 0xD6C6, 0xDB27, 0xDEA8,
    0xE0CF, 0xDFA6, 0xDD1B, 0xDBEA, 0xDC74, 0xDD94, 0xE2F0, 0xE8A4, 0xEDB0, 0xF327, 0xF40C, 0xF798, 0xF6EC, 0xF1AB, 0xF449, 0xF40F,
    0xF41C, 0xF903, 0xFE39, 0x02AC, 0x08E1, 0x0E71, 0x1291, 0x19A4, 0x1F1B, 0x2158, 0x2377, 0x23F9, 0x2411, 0x27D0, 0x2BB6, 0x2FFC,
    0x350F, 0x389C, 0x3967, 0x3736, 0x3115, 0x27BE, 0x1D53, 0x1252, 0x0644, 0xFD77, 0xF5B1, 0xEE4D, 0xEBC2, 0xE8A1, 0xE227, 0xE189,
    0xE254, 0xE289, 0xE6D6, 0xE6F3, 0xE77C, 0xE9F7, 0xE9AF, 0xE8B0, 0xE9C0, 0xEE9A, 0xF26D, 0xF74F, 0xFB74, 0xF9FE, 0xFAFA, 0xF903,
    0xF816, 0xFCD4, 0xFEC9, 0x067D, 0x10D3, 0x16A3, 0x1CC9, 0x1F1F, 0x1E63, 0x1C3A, 0x183A, 0x155D, 0x1207, 0x10ED, 0x116A, 0x10BD,
    0x13FF, 0x158D, 0x134A, 0x158A, 0x17F6, 0x1B8F, 0x1F25, 0x2070, 0x23A5, 0x269F, 0x28F9, 0x2C06, 0x2F52, 0x3474, 0x3835, 0x3A55,
    0x39D0, 0x34D0, 0x3083, 0x27F3, 0x1D6D, 0x162B, 0x0BF9, 0x00FC, 0xF932, 0xEDDB, 0xE3E6, 0xDE29, 0xD7AA, 0xD49A, 0xD5EF, 0xD6AC,
    0xD96B, 0xDCFC, 0xDFBF, 0xE248, 0xE440, 0xE9FE, 0xEFB6, 0xF5AB, 0xFBB8, 0xFC74, 0xF9C4, 0xF2BA, 0xEB92, 0xE86A, 0xE36F, 0xE174,
    0xE3E5, 0xE7E3, 0xEC1E, 0xEF6D, 0xEFA8, 0xEDBA, 0xEC5F, 0xE8DC, 0xE4D0, 0xE3CE, 0xE44B, 0xE41E, 0xE499, 0xE443, 0xE3B9, 0xE50D,
    0xE53D, 0xE4EE, 0xE793, 0xE796, 0xE739, 0xE946, 0xED5A, 0xF465, 0xFBCC, 0x04E5, 0x0F64, 0x16D6, 0x19DA, 0x193A, 0x1645, 0x0E27,
    0x0495, 0xFC26, 0xF2B0, 0xECE2, 0xE7A4, 0xE31D, 0xE009, 0xDBCD, 0xD9FB, 0xD6CD, 0xD733, 0xD9B2, 0xD93B, 0xE0A9, 0xE645, 0xEBDA,
    0xF60E, 0xFF49, 0x0B9D, 0x1700, 0x1E77, 0x2488, 0x26BF, 0x23F7, 0x1FB8, 0x1C9F, 0x1B6D, 0x19EF, 0x1A5F, 0x1BB1, 0x1D69, 0x207B,
    0x1EF9, 0x1D7D, 0x1DBF, 0x1A5E, 0x1812, 0x1654, 0x1417, 0x1680, 0x1B39, 0x1F13, 0x22EF, 0x23F2, 0x26D3, 0x26C2, 0x23F0, 0x21D8,
    0x1A26, 0x16C0, 0x1243, 0x0E2F, 0x1187, 0x14EC, 0x1D62, 0x26DC, 0x2BA4, 0x2ED4, 0x2F87, 0x2CDD, 0x2735, 0x1F7D, 0x149A, 0x0B22,
    0x020B, 0xF683, 0xEC20, 0xE56B, 0xDDDE, 0xD475, 0xCF20, 0xCC47, 0xCA94, 0xCB14, 0xCB58, 0xCB41, 0xCE13, 0xCF59, 0xD49B, 0xDD41,
    0xE5AA, 0xF034, 0xF65D, 0xF90B, 0xF798, 0xF303, 0xEF8F, 0xEE0C, 0xEFBD, 0xF294, 0xF817, 0x00D3, 0x084D, 0x0C1F, 0x0EBB, 0x0E33,
    0x0B64, 0x09F0, 0x04F7, 0x0027, 0x019E, 0x02F3, 0x0541, 0x0B2B, 0x0ECC, 0x1418, 0x18AD, 0x1AC2, 0x1D40, 0x1C0A, 0x19CE, 0x1AC9,
    0x1DC2, 0x217D, 0x289C, 0x2F88, 0x3448, 0x3793, 0x36D9, 0x33B2, 0x2CA5, 0x2424, 0x183A, 0x0B09, 0x01B5, 0xF706, 0xEDA6, 0xE719,
    0xE01A, 0xDA84, 0xD54A, 0xCE87, 0xCB31, 0xC72A, 0xC37D, 0xC05F, 0xBED4, 0xC077, 0xC16E, 0xC5FC, 0xCB36, 0xD18C, 0xD86D, 0xD921,
    0xD956, 0xDB5C, 0xDA80, 0xDC4A, 0xDE6F, 0xDF1B, 0xE398, 0xE7EE, 0xEC0B, 0xF30E, 0xF8A6, 0xFDA5, 0x0158, 0x042E, 0x04AC, 0x0307,
    0x050C, 0x0784, 0x0BED, 0x1072, 0x13F6, 0x1A4E, 0x1F33, 0x216E, 0x25D8, 0x2A2F, 0x2D11, 0x2DCC, 0x3161, 0x381F, 0x3DE1, 0x44E0,
    0x4A45, 0x4E6D, 0x520E, 0x4FE1, 0x4B65, 0x467C, 0x3B21, 0x2D94, 0x1FBE, 0x10B6, 0x041B, 0xF9BD, 0xEFAF, 0xE8D9, 0xE1C8, 0xDA20,
    0xD591, 0xD0FE, 0xCD3B, 0xCC1B, 0xCBE8, 0xCDA8, 0xCF71, 0xD0FD, 0xD37E, 0xD5E8, 0xD84B, 0xD7C2, 0xD598, 0xD216, 0xCF0F, 0xCD7E,
    0xCD95, 0xCDFC, 0xCFDD, 0xD4B2, 0xD750, 0xDCCA, 0xE4BC, 0xEC29, 0xF42A, 0xFA46, 0xFE62, 0xFEEA, 0xFE0D, 0xFE3E, 0x0217, 0x068F,
    0x0A76, 0x0ED3, 0x1451, 0x168D, 0x1672, 0x1779, 0x15C1, 0x1687, 0x1878, 0x1B79, 0x2311, 0x2DC0, 0x362E, 0x3EB3, 0x45C5, 0x4875,
    0x494C, 0x46AC, 0x4441, 0x422D, 0x3B06, 0x32C2, 0x2A17, 0x2218, 0x1AE9, 0x1145, 0x09D5, 0x0183, 0xF82C, 0xF1F1, 0xE9F8, 0xE359,
    0xE0DE, 0xDE30, 0xE0E5, 0xE38F, 0xE5E3, 0xEC1F, 0xF251, 0xF6D4, 0xF8D3, 0xF789, 0xF5F2, 0xF51F, 0xF518, 0xF265, 0xEEC7, 0xEF17,
    0xEBBA, 0xEA35, 0xEB04, 0xEBF7, 0xEFE0, 0xF0C9, 0xF028, 0xEFF5, 0xED60, 0xEC51, 0xED4D, 0xEFB3, 0xF2A3, 0xF5CF, 0xF8EB, 0xF9B5,
    0xFA00, 0xFA3A, 0xF786, 0xF53B, 0xF3C0, 0xF180, 0xF224, 0xF48F, 0xF877, 0xFE44, 0x0574, 0x0C64, 0x1485, 0x1AFE, 0x1C8F, 0x1D24,
    0x1A9C, 0x1396, 0x0990, 0xFF42, 0xF726, 0xF0B3, 0xEBD6, 0xE6E7, 0xE3E2, 0xDED9, 0xD868, 0xD382, 0xCFEC, 0xCE27, 0xCEB0, 0xD200,
    0xD59E, 0xDC96, 0xE396, 0xE846, 0xEF82, 0xF558, 0xF659, 0xF839, 0xFA34, 0xFAF8, 0xFA7A, 0xFA14, 0xFB44, 0xFA20, 0xF9D5, 0xFCA1,
    0xFF78, 0x0278, 0x0186, 0x00F7, 0xFEDD, 0xF9AD, 0xF70D, 0xF622, 0xF839, 0xFDB6, 0x038C, 0x0730, 0x0CB5, 0x10A0, 0x120A, 0x137E,
    0x136C, 0x11FD, 0x1103, 0x0FEA, 0x1130, 0x1444, 0x1A31, 0x1F68, 0x24A6, 0x2C8C, 0x300B, 0x324A, 0x3322, 0x2F7B, 0x2B8A, 0x250D,
    0x1DAB, 0x1A03, 0x14A2, 0x111E, 0x0E15, 0x086C, 0x01E8, 0xFA3F, 0xF1CC, 0xEBA3, 0xE863, 0xE6CE, 0xE60F, 0xE7D7, 0xED42, 0xF020,
    0xF431, 0xFA86, 0xFD4D, 0x0106, 0x03E1, 0x05A8, 0x0829, 0x05E9, 0x03D7, 0x015D, 0xFE31, 0xFE14, 0xFE91, 0x03CE, 0x0A14, 0x0DF9,
    0x0FDD, 0x0CDA, 0x0BC7, 0x07CE, 0x041C, 0x06AF, 0x08B4, 0x0A4D, 0x0A6A, 0x0AA5, 0x09F0, 0x0589, 0x0037, 0xFADB, 0xFA56, 0xFB24,
    0xFCC4, 0x02EA, 0x09DF, 0x1260, 0x19E3, 0x1F19, 0x251A, 0x2851, 0x2866, 0x262A, 0x1F7C, 0x163A, 0x09AE, 0xFFDA, 0xF65A, 0xEE21,
    0xE911, 0xE2EC, 0xDC3B, 0xD521, 0xCE0C, 0xC6DC, 0xC422, 0xC27E, 0xC149, 0xC2E5, 0xC42D, 0xC489, 0xC4A5, 0xC678, 0xC946, 0xCAB6,
    0xCD41, 0xCE28, 0xCF53, 0xD262, 0xD245, 0xD261, 0xD272, 0xD34A, 0xD784, 0xD95E, 0xDD6B, 0xE2A9, 0xE635, 0xE8A1, 0xE799, 0xE833,
    0xE957, 0xEC4C, 0xF194, 0xF6A0, 0xFD31, 0x01DF, 0x0425, 0x082F, 0x0B30, 0x0BC3, 0x0DCF, 0x10BF, 0x11BC, 0x1510, 0x1BD8, 0x23E5,
    0x2DE0, 0x3820, 0x4077, 0x4834, 0x4ACB, 0x4D0D, 0x4BD9, 0x473E, 0x42B1, 0x39EC, 0x31CF, 0x2842, 0x1F5E, 0x14C7, 0x08EA, 0xFFF0,
    0xF662, 0xEB0D, 0xE689, 0xE4BD, 0xE6BC, 0xEBB7, 0xEF6A, 0xF5C8, 0xF8D0, 0xFC38, 0xFE87, 0xFF26, 0x0151, 0xFFE9, 0xFE89, 0xFE4B,
    0xFB11, 0xF858, 0xF4A5, 0xF151, 0xF091, 0xF145, 0xF3E3, 0xF8AF, 0xFD9F, 0x01D9, 0x03E7, 0x0215, 0x0075, 0x01E9, 0x0393, 0x046A,
    0x07E9, 0x092B, 0x08FE, 0x0819, 0x058E, 0x02A5, 0x00BF, 0x004B, 0xFE56, 0xFE77, 0xFF8E, 0x034D, 0x086D, 0x0FC0, 0x1709, 0x1EF8,
    0x258B, 0x28BA, 0x2ACB, 0x26AC, 0x2218, 0x1CE8, 0x159E, 0x0E98, 0x0A24, 0x03B8, 0xFCE9, 0xF195, 0xE71F, 0xDE0A, 0xD3A3, 0xCF1B,
    0xC9BD, 0xCD43, 0xCFB2, 0xCF5F, 0xD2DC, 0xD454, 0xD91B, 0xDC22, 0xE183, 0xE94C, 0xEE4A, 0xF539, 0xF927, 0xFC38, 0xFCD6, 0xFD30,
    0xFE87, 0xFB6D, 0xFAB3, 0xFB77, 0xFC64, 0xFFD2, 0x00D3, 0x00CB, 0x00E4, 0x003E, 0x0299, 0x00E1, 0x05B7, 0x0A48, 0x0A9C, 0x0DFD,
    0x0C88, 0x0DBE, 0x0C40, 0x0986, 0x0722, 0x00AE, 0xFC38, 0xF8EC, 0xF7EE, 0xFCCE, 0x0340, 0x0C45, 0x13CD, 0x169E, 0x1A08, 0x18A8,
    0x15E2, 0x11C5, 0x0A5F, 0x0529, 0xFF7A, 0xF9AA, 0xF41C, 0xEE2B, 0xE66B, 0xDCDC, 0xD479, 0xCD3B, 0xC7F9, 0xC69C, 0xC831, 0xCA69,
    0xCD70, 0xD060, 0xD44B, 0xD9B0, 0xDEC0, 0xE4FD, 0xEAB9, 0xF158, 0xF7E5, 0xFD93, 0x0323, 0x0772, 0x0A14, 0x0B8D, 0x0CC0, 0x0C1B,
    0x0B7C, 0x0C5B, 0x0F42, 0x0E79, 0x0CE7, 0x0C9E, 0x0AFF, 0x0890, 0x06E2, 0x0808, 0x0908, 0x0BBE, 0x0D9E, 0x0F28, 0x12D3, 0x15DA,
    0x155F, 0x141F, 0x11B7, 0x0F5D, 0x0F55, 0x0E23, 0x13C5, 0x1944, 0x1E4B, 0x24CD, 0x2476, 0x247C, 0x1FB5, 0x1B72, 0x1805, 0x0FB9,
    0x0C35, 0x0781, 0x01A8, 0xFC5B, 0xF26E, 0xEC6F, 0xE54E, 0xDDFE, 0xD9F4, 0xD4AD, 0xD463, 0xD2FD, 0xD1B1, 0xD2A3, 0xD0D7, 0xD359,
    0xD481, 0xD831, 0xDCB7, 0xDEEE, 0xE599, 0xE7CA, 0xEB66, 0xEE90, 0xF1DB, 0xF47D, 0xF4D0, 0xF7C3, 0xFA59, 0xFB94, 0x011B, 0x02DA,
    0x074A, 0x0B7E, 0x0D98, 0x1276, 0x13BC, 0x18E7, 0x1B97, 0x1DEA, 0x200C, 0x1F44, 0x213F, 0x2331, 0x236F, 0x2584, 0x2235, 0x1FDB,
    0x1C24, 0x1B32, 0x1DAE, 0x2482, 0x2D9B, 0x36A0, 0x3C82, 0x414F, 0x4433, 0x435B, 0x40A8, 0x3C0D, 0x3911, 0x30A0, 0x2A1C, 0x20CF,
    0x1708, 0x0A0E, 0x0025, 0xF306, 0xE60E, 0xDBF1, 0xD56F, 0xD29F, 0xD07E, 0xD06F, 0xD157, 0xD2AE, 0xD35A, 0xD3D9, 0xD3D7, 0xD2B8,
    0xD063, 0xD065, 0xCCDF, 0xCD9C, 0xCE2B, 0xCF68, 0xCFE8, 0xCEBF, 0xCD07, 0xCA30, 0xC8C6, 0xCAA0, 0xCB0D, 0xD0C4, 0xD426, 0xD6E4,
    0xDBCC, 0xDD1B, 0xE299, 0xE44B, 0xE6D0, 0xEA5A, 0xED74, 0xF228, 0xF52A, 0xF818, 0xFB7C, 0xFD22, 0xFF35, 0x0045, 0x0370, 0x0AA4,
    0x12AC, 0x1BB0, 0x2512, 0x2BCC, 0x3316, 0x3898, 0x3C62, 0x3D14, 0x3DDE, 0x3D34, 0x3BB4, 0x36B3, 0x30A0, 0x2988, 0x1F82, 0x135E,
    0x0654, 0xFA2D, 0xEE6C, 0xE634, 0xE14F, 0xE0A1, 0xE08A, 0xE41E, 0xE69D, 0xEA85, 0xEDA0, 0xF045, 0xF284, 0xF567, 0xF4C9, 0xF84B,
    0xF9A7, 0xFA16, 0xF9C8, 0xF6A1, 0xF401, 0xEF45, 0xEBB0, 0xE7B6, 0xE53F, 0xE63E, 0xE8D2, 0xE872, 0xED06, 0xEE88, 0xF516, 0xF87E,
    0xFE0E, 0x0435, 0x07F9, 0x0CE6, 0x0F93, 0x0FAA, 0x0E35, 0x0AA4, 0x0891, 0x0598, 0x03D7, 0x09B7, 0x0EB8, 0x1AA6, 0x23BF, 0x2C64,
    0x3391, 0x379E, 0x3B62, 0x3D21, 0x3FC2, 0x438F, 0x41D5, 0x41C3, 0x3C66, 0x35F8, 0x302D, 0x265F, 0x1F59, 0x144C, 0x0A95, 0x0304,
    0xFAAC, 0xF629, 0xF2E8, 0xF1E6, 0xF1DE, 0xEFA2, 0xF1CD, 0xF071, 0xEE67, 0xECBD, 0xE916, 0xE7EF, 0xE78D, 0xEA94, 0xEF38, 0xF33C,
    0xF62B, 0xF5B4, 0xF43C, 0xEE2B, 0xE94B, 0xE537, 0xE363, 0xE29C, 0xE16F, 0xE1BB, 0xE22A, 0xE394, 0xE55F, 0xE5A0, 0xE8DC, 0xE9F5,
    0xEAB4, 0xED15, 0xEB74, 0xECE8, 0xE91D, 0xE786, 0xE5E9, 0xE33B, 0xE242, 0xE3BA, 0xE7E1, 0xEC3C, 0xEF3E, 0xF696, 0xFC45, 0x0263,
    0x0710, 0x0AB5, 0x0E28, 0x0BFE, 0x0A72, 0x055B, 0x01C3, 0xFC32, 0xF60B, 0xF037, 0xE841, 0xE1A7, 0xDC3B, 0xD44B, 0xD453, 0xD24E,
    0xD56A, 0xDA32, 0xDE1D, 0xE494, 0xE731, 0xEC86, 0xEE46, 0xF060, 0xF6C1, 0xFBE7, 0x030A, 0x0B37, 0x0F0E, 0x140F, 0x1330, 0x1317,
    0x1033, 0x0E2F, 0x10EB, 0x1197, 0x14E1, 0x16E2, 0x183F, 0x19B2, 0x16AF, 0x1637, 0x1409, 0x11BC, 0x11FE, 0x0F13, 0x0DB2, 0x0DEF,
    0x0EA4, 0x0E40, 0x0C56, 0x0D61, 0x0FAE, 0x1287, 0x1727, 0x1A80, 0x1EFE, 0x22AD, 0x23F7, 0x2645, 0x29A3, 0x2C42, 0x2FB3, 0x2F93,
    0x2E20, 0x2A05, 0x2502, 0x1F7A, 0x18EE, 0x114C, 0x0A86, 0x00A0, 0xF83B, 0xEEC9, 0xE931, 0xE820, 0xE560, 0xE763, 0xE68E, 0xE755,
    0xE7C7, 0xE659, 0xE3BA, 0xE48B, 0xE5BE, 0xE9D6, 0xEC2C, 0xF379, 0xFACD, 0xFE37, 0xFF9C, 0xFC50, 0xF7E1, 0xF29A, 0xF0C9, 0xF1EE,
    0xF407, 0xF6D5, 0xFBC5, 0xFD7B, 0xFF4C, 0x0051, 0x0256, 0x0352, 0x04C7, 0x037C, 0x025E, 0xFFC6, 0xFE23, 0xFB90, 0xF96A, 0xFA32,
    0xF8FB, 0xF9E9, 0xFB72, 0xFDB4, 0x0068, 0x04FD, 0x08E8, 0x0EA3, 0x1554, 0x1E0D, 0x2690, 0x2B7D, 0x2E26, 0x2EE3, 0x2B29, 0x249F,
    0x1EC7, 0x1715, 0x1053, 0x0896, 0xFF66, 0xF5F0, 0xEBEC, 0xE610, 0xE07E, 0xE01E, 0xE2BC, 0xE47B, 0xE864, 0xEAF8, 0xEADF, 0xEA27,
    0xE854, 0xE90D, 0xE94E, 0xEA7F, 0xEFB8, 0xF2C6, 0xF6B9, 0xF5C9, 0xF3A1, 0xF0DD, 0xEBBE, 0xE761, 0xE2FC, 0xE10E, 0xE11E, 0xDF0D,
    0xE249, 0xE50B, 0xE925, 0xEDB4, 0xF1DB, 0xF4ED, 0xF3DB, 0xF2FF, 0xF277, 0xF081, 0xEFF2, 0xF0FF, 0xF04A, 0xF339, 0xF430, 0xF97B,
    0xFCDF, 0x03EC, 0x0AFC, 0x1130, 0x1932, 0x212D, 0x2AAE, 0x31FC, 0x3769, 0x3AD6, 0x3C14, 0x39F7, 0x3778, 0x30E3, 0x2B5E, 0x23CF,
    0x1889, 0x0B11, 0xFC7B, 0xEF74, 0xE6BB, 0xE033, 0xDD7B, 0xDB6B, 0xDC0C, 0xDFC3, 0xE0F9, 0xE255, 0xE4CB, 0xE701, 0xEB74, 0xF033,
    0xF481, 0xFC55, 0x00DA, 0x06D8, 0x07A2, 0x02B0, 0xFF79, 0xFA3C, 0xF524, 0xF0A7, 0xED30, 0xEBA9, 0xEA67, 0xEA0E, 0xEE05, 0xF231,
    0xF749, 0xFC83, 0x0086, 0x04C4, 0x05A6, 0x0597, 0x0580, 0x0776, 0x065C, 0x06DA, 0x05C5, 0x0490, 0x059C, 0x07E2, 0x0BFD, 0x0DE2,
    0x121E, 0x1889, 0x206D, 0x27BD, 0x2D62, 0x3100, 0x351D, 0x355B, 0x33DA, 0x3078, 0x2E75, 0x2DA5, 0x27CE, 0x1E47, 0x15F9, 0x0B7F,
    0x01B2, 0xF8C4, 0xF3E5, 0xF161, 0xEF62, 0xF001, 0xEE2E, 0xEDA2, 0xED02, 0xEE45, 0xEDF3, 0xEFB2, 0xF287, 0xF7D3, 0xFBC0, 0x0160,
    0x03D9, 0x04FB, 0x07B9, 0x0689, 0x057E, 0x01D1, 0x00A3, 0xFFEB, 0xFEBC, 0x0006, 0x0286, 0x0504, 0x0A79, 0x0D86, 0x0F29, 0x0EF7,
    0x0DAC, 0x0BB6, 0x08C7, 0x0886, 0x09B7, 0x0AD2, 0x0BF9, 0x0C0F, 0x0D27, 0x0EB4, 0x0E34, 0x0F45, 0x0F63, 0x1159, 0x1121, 0x12D4,
    0x16D7, 0x1889, 0x1AD4, 0x1B4D, 0x19F9, 0x146E, 0x0CD8, 0x066C, 0xFF02, 0xF362, 0xE936, 0xDEA0, 0xD489, 0xCD9F, 0xC731, 0xC32E,
    0xC11A, 0xBFA6, 0xBDD1, 0xBD9F, 0xBCC6, 0xBF51, 0xC08B, 0xC2A3, 0xC6BE, 0xCB00, 0xD200, 0xD8D8, 0xE16D, 0xE8F7, 0xECBD, 0xEF31,
    0xEE31, 0xEB89, 0xEB40, 0xE9DD, 0xEC9E, 0xF057, 0xF505, 0xFC92, 0x049A, 0x0AD8, 0x100D, 0x12FA, 0x1495, 0x1279, 0x0EFC, 0x0D65,
    0x0D64, 0x0D1F, 0x0E23, 0x101E, 0x10B0, 0x1877, 0x1C77, 0x20EB, 0x259B, 0x2AA5, 0x31E8, 0x35B7, 0x39F4, 0x3F84, 0x4401, 0x475B,
    0x4874, 0x46B1, 0x4426, 0x3FC1, 0x39EC, 0x2EF5, 0x24D1, 0x18BA, 0x0CE7, 0x0419, 0xFB70, 0xF732, 0xF443, 0xF26F, 0xF1CB, 0xED5D,
    0xE973, 0xE81A, 0xE6F7, 0xE511, 0xE239, 0xE2D5, 0xE34C, 0xE63C, 0xE9A6, 0xEDC6, 0xF402, 0xF6C4, 0xF7A3, 0xF769, 0xF357, 0xED83,
    0xEA04, 0xE895, 0xEA32, 0xEE1F, 0xF5F1, 0xFE7C, 0x077E, 0x0DA5, 0x11F0, 0x13C2, 0x1383, 0x1415, 0x13C3, 0x15A6, 0x17B5, 0x1911,
    0x173F, 0x170D, 0x17E5, 0x15BC, 0x151E, 0x1771, 0x192D, 0x1CCE, 0x1ECC, 0x2312, 0x2808, 0x2B57, 0x3224, 0x36AD, 0x399B, 0x399C,
    0x378B, 0x32AB, 0x29EE, 0x2095, 0x15B5, 0x086D, 0xFE34, 0xF40F, 0xEDCA, 0xE8A2, 0xE1E4, 0xDEC2, 0xDB82, 0xD927, 0xD7DC, 0xD6FB,
    0xD45B, 0xD41D, 0xD2E1, 0xD21E, 0xD2D5, 0xD2CE, 0xD7F2, 0xDCB1, 0xDBDF, 0xDA59, 0xD614, 0xD13B, 0xCCDA, 0xC5D7, 0xC3CC, 0xC42B,
    0xC71C, 0xCC9D, 0xD05C, 0xD48C, 0xD8DF, 0xDB76, 0xDCFE, 0xDD0D, 0xDE6B, 0xE017, 0xE35C, 0xE6E3, 0xE7E7, 0xEADB, 0xECBF, 0xF05E,
    0xF4B7, 0xF9A2, 0x00A6, 0x09E3, 0x113F, 0x1944, 0x22DB, 0x2B70, 0x34AE, 0x3BD2, 0x4181, 0x4760, 0x4A06, 0x483A, 0x4794, 0x4437,
    0x3F37, 0x3870, 0x3077, 0x27F9, 0x208D, 0x18A2, 0x1094, 0x08DF, 0x0001, 0xFA31, 0xF630, 0xF2D4, 0xF18A, 0xF163, 0xF15E, 0xF480,
    0xF712, 0xFBDB, 0x0263, 0x09F5, 0x0F07, 0x0FF8, 0x0FD2, 0x0A6C, 0x0224, 0xFA42, 0xF28E, 0xEE79, 0xEDA2, 0xEEC7, 0xF1D5, 0xF475,
    0xF944, 0xFC57, 0xFCF5, 0xFC66, 0xFCD2, 0xFE19, 0xFD53, 0xFEBE, 0xFF19, 0xFE7C, 0xFEBE, 0xFDF8, 0xFD24, 0xFE02, 0xFF8B, 0x01DC,
    0x0519, 0x0858, 0x0D59, 0x1222, 0x16D2, 0x1DAB, 0x247E, 0x290D, 0x2E28, 0x2ED4, 0x2D65, 0x2B6D, 0x2685, 0x226C, 0x1C68, 0x159D,
    0x1355, 0x0ED0, 0x07C0, 0x014E, 0xFB56, 0xF7AC, 0xF2B3, 0xEE9A, 0xED37, 0xEC02, 0xE921, 0xE80E, 0xE6F2, 0xE705, 0xE9FA, 0xF11A,
    0xF859, 0xFE04, 0x0273, 0x01E2, 0xFE7A, 0xF7C4, 0xF019, 0xEBF3, 0xE9F5, 0xEAEC, 0xF151, 0xF3CE, 0xF842, 0xFDDD, 0xFD6F, 0xFDE1,
    0xFC67, 0xF8E8, 0xF933, 0xF9F1, 0xF9CF, 0xFB39, 0xFBF6, 0xFD79, 0xFFC6, 0x0012, 0x00BF, 0x022C, 0x02AE, 0x03B0, 0x0533, 0x061F,
    0x0A15, 0x102E, 0x15A5, 0x1BD3, 0x1F04, 0x2100, 0x20F3, 0x1D09, 0x1762, 0x0FC3, 0x0923, 0x01A1, 0xF7EF, 0xF074, 0xE9F4, 0xE41C,
    0xDDE9, 0xD9A4, 0xD6B8, 0xD327, 0xD061, 0xCFF7, 0xCFEF, 0xD01E, 0xD149, 0xD41F, 0xD9AE, 0xE030, 0xE8FD, 0xF0E7, 0xF9C7, 0x00D1,
    0x0403, 0x03D6, 0x01A2, 0xFF93, 0xFF0C, 0x0017, 0x017A, 0x04C8, 0x0968, 0x1089, 0x16BC, 0x184B, 0x1928, 0x1872, 0x1629, 0x1283,
    0x0BF4, 0x08CB, 0x0784, 0x056A, 0x044E, 0x0498, 0x04AA, 0x06A4, 0x07A7, 0x09CE, 0x0D16, 0x0F50, 0x135E, 0x17F5, 0x1CA9, 0x23F0,
    0x2B7B, 0x2F2F, 0x2FEC, 0x2EB4, 0x29F7, 0x226D, 0x1B11, 0x115D, 0x077D, 0xFF5C, 0xF5C5, 0xEDD6, 0xE72F, 0xE0E4, 0xDE9B, 0xDA3A,
    0xD816, 0xD8C2, 0xD6EA, 0xD5FE, 0xD756, 0xD662, 0xD863, 0xDCFC, 0xE279, 0xEB7A, 0xF3D5, 0xFAEC, 0xFFA1, 0xFDBC, 0xF97A, 0xF76C,
    0xF264, 0xEFF0, 0xF076, 0xF357, 0xF8C1, 0xFDC8, 0x0427, 0x0A5F, 0x1005, 0x153E, 0x1874, 0x1BF6, 0x1CD1, 0x1DC1, 0x1EFC, 0x1F2B,
    0x1EB9, 0x1F19, 0x1F6E, 0x1F55, 0x1EB4, 0x1CF0, 0x1C13, 0x1B99, 0x1D89, 0x200B, 0x24C1, 0x2AED, 0x31E2, 0x3653, 0x38AC, 0x3A1E,
    0x38CD, 0x3568, 0x30F7, 0x2D09, 0x2757, 0x1F84, 0x18D5, 0x0FD5, 0x070F, 0xFED5, 0xF63C, 0xEDF9, 0xE729, 0xE224, 0xDE5E, 0xDB66,
    0xD912, 0xD951, 0xD9FA, 0xDE43, 0xE34B, 0xE9BA, 0xF181, 0xF7FA, 0xFC9B, 0xFE52, 0xFB56, 0xF75C, 0xF125, 0xEA5A, 0xE621, 0xE193,
    0xDFB3, 0xDF69, 0xDF3C, 0xE15D, 0xE454, 0xE595, 0xE70F, 0xE7E8, 0xE77F, 0xE68D, 0xE635, 0xE4B2, 0xE3E1, 0xE314, 0xE1CE, 0xE1FA,
    0xE15F, 0xE07C, 0xE284, 0xE31B, 0xE522, 0xEBD0, 0xEF5C, 0xF47C, 0xFED2, 0x086A, 0x1063, 0x17A5, 0x1B60, 0x1EA1, 0x205C, 0x1EE8,
    0x1EC3, 0x1B0E, 0x1759, 0x1534, 0x10E2, 0x0B98, 0x047A, 0x003E, 0xF9C1, 0xF207, 0xEB6A, 0xE3F8, 0xDEEC, 0xDC3B, 0xDA17, 0xDC43,
    0xDE6F, 0xE4BA, 0xEF63, 0xF5F7, 0x0014, 0x076D, 0x0AD1, 0x0DEE, 0x0D99, 0x0E13, 0x0D3E, 0x09FA, 0x0B1B, 0x0B7F, 0x0A0E, 0x0C21,
    0x0D2D, 0x1103, 0x14F9, 0x1627, 0x1896, 0x189D, 0x1A23, 0x1C89, 0x1C1C, 0x1D47, 0x20A4, 0x206E, 0x2064, 0x1D7C, 0x1B73, 0x19D3,
    0x16FD, 0x1874, 0x191C, 0x1B18, 0x2158, 0x259E, 0x2946, 0x2C51, 0x2CCA, 0x2ECE, 0x2C74, 0x2B73, 0x2A2E, 0x27CE, 0x25BD, 0x1F99,
    0x1782, 0x100F, 0x0958, 0x03A8, 0xFD9E, 0xF875, 0xF58D, 0xF2AB, 0xEF2E, 0xEBC0, 0xE846, 0xE521, 0xE325, 0xE1EE, 0xE4FC, 0xE8F8,
    0xEB2F, 0xEF5B, 0xF1E6, 0xF15A, 0xF176, 0xED95, 0xEDAC, 0xEAB9, 0xE83A, 0xE9E6, 0xE792, 0xE9E1, 0xEFAA, 0xF2F7, 0xF9C0, 0xFEFF,
    0x0043, 0x03C2, 0x02DC, 0x0307, 0x027A, 0x01A5, 0x037F, 0x0678, 0x07D5, 0x08D0, 0x09C0, 0x0AEC, 0x0AE0, 0x0ACB, 0x0CC6, 0x0D3B,
    0x1012, 0x1496, 0x171B, 0x1BE4, 0x1E5C, 0x1F16, 0x2172, 0x1EEA, 0x1B95, 0x1893, 0x1210, 0x0B4B, 0x0436, 0xFAE6, 0xF4C6, 0xECE5,
    0xE6C5, 0xE0B8, 0xD86D, 0xD2B4, 0xCC1C, 0xC4C2, 0xC0BE, 0xBE37, 0xBDB2, 0xBEDD, 0xC033, 0xC7DC, 0xCD6A, 0xD27A, 0xDA85, 0xDF37,
    0xE3B5, 0xE5CF, 0xE660, 0xE6F3, 0xE61E, 0xE716, 0xEA3B, 0xEB9B, 0xF0C3, 0xF86E, 0xFF1E, 0x087D, 0x0E51, 0x15B0, 0x19FB, 0x1B53,
    0x1CFA, 0x1BD5, 0x1A4D, 0x1B8B, 0x196C, 0x16EC, 0x165C, 0x1591, 0x1761, 0x16C4, 0x189C, 0x1C27, 0x20D1, 0x271D, 0x2CE9, 0x347F,
    0x3CB0, 0x424A, 0x4874, 0x49B6, 0x4987, 0x4903, 0x4537, 0x4016, 0x3A19, 0x3207, 0x2B65, 0x24C8, 0x1E34, 0x18C4, 0x1159, 0x095D,
    0x02C7, 0xFC23, 0xF346, 0xEEFE, 0xE8AA, 0xE5E9, 0xE54A, 0xE474, 0xE6C8, 0xE887, 0xEB1F, 0xF025, 0xF142, 0xF2B5, 0xF36A, 0xEFC9,
    0xEDE1, 0xE7F3, 0xE185, 0xDC8C, 0xD919, 0xDB02, 0xDCFE, 0xE1C0, 0xE7EE, 0xEA34, 0xEDCB, 0xEDCC, 0xEE85, 0xF34A, 0xF507, 0xF9C4,
    0xFEE2, 0xFFDB, 0x0375, 0x02E0, 0x0142, 0x0208, 0x0061, 0x0214, 0x048E, 0x0617, 0x0AEC, 0x0EFE, 0x162C, 0x1D6F, 0x237A, 0x2A0B,
    0x2E3F, 0x31A6, 0x3443, 0x322F, 0x2F66, 0x2D29, 0x28FE, 0x26E5, 0x2146, 0x1C25, 0x1688, 0x0F25, 0x0597, 0xFD79, 0xF3AC, 0xED2D,
    0xEA05, 0xE750, 0xE6E9, 0xE6F7, 0xE97F, 0xED8F, 0xF11F, 0xF4DE, 0xF8E4, 0xFB46, 0xFE84, 0xFD4C, 0xFAAF, 0xF7B3, 0xF345, 0xF032,
    0xEBD8, 0xE6E1, 0xE7D1, 0xE5A4, 0xE57C, 0xE552, 0xE489, 0xE493, 0xE390, 0xE4F6, 0xE57A, 0xE5ED, 0xE6B8, 0xE632, 0xE555, 0xE3E5,
    0xE03A, 0xE178, 0xDF50, 0xDFC8, 0xE330, 0xE58F, 0xE9E0, 0xEEB2, 0xF44C, 0xFB95, 0x0460, 0x0D39, 0x1379, 0x1A25, 0x209F, 0x2501,
    0x2756, 0x27C3, 0x2B1C, 0x2CDC, 0x2C1F, 0x2BA0, 0x2A56, 0x26F3, 0x2042, 0x1828, 0x0EBF, 0x0295, 0xFB17, 0xF282, 0xEB58, 0xE924,
    0xE76B, 0xE93B, 0xEBAE, 0xED00, 0xF213, 0xF571, 0xF953, 0xFDC6, 0xFE95, 0x0071, 0x0009, 0xFE2F, 0xFDD0, 0xFABD, 0xFAFD, 0xFB94,
    0xF998, 0xF9E8, 0xF748, 0xF52F, 0xF2AE, 0xEE99, 0xEF02, 0xF032, 0xEFF6, 0xF196, 0xF04B, 0xF17F, 0xEFE0, 0xEC8C, 0xEB19, 0xEA0D,
    0xEBCA, 0xEEC5, 0xEF27, 0xF274, 0xF7A6, 0xFD25, 0x0516, 0x0A7B, 0x12AC, 0x1949, 0x1BD6, 0x1DAB, 0x1DFE, 0x1AF2, 0x1B08, 0x1A2D,
    0x1A9E, 0x1AF6, 0x1B30, 0x1B29, 0x1850, 0x1288, 0x0BF5, 0x05D2, 0x002F, 0xFCB9, 0xFB20, 0xFCD4, 0xFE92, 0x0069, 0x0214, 0x0546,
    0x06A8, 0x0AA0, 0x0D63, 0x1027, 0x11EF, 0x10AB, 0x0EE1, 0x0A9B, 0x0773, 0x04EC, 0x0207, 0x0243, 0x0268, 0x0408, 0x0515, 0x02F1,
    0x04B6, 0x041D, 0x022E, 0x0316, 0x0221, 0x029F, 0x0341, 0x00F8, 0xFCC6, 0xF737, 0xF49A, 0xF087, 0xEECF, 0xEF1A, 0xF05A, 0xF4AE,
    0xF6A3, 0xFABC, 0xFFF3, 0x04A6, 0x0D14, 0x12BD, 0x1671, 0x174B, 0x1697, 0x1430, 0x0F2F, 0x0B9E, 0x06CE, 0x0147, 0xFEAF, 0xF96D,
    0xF364, 0xECE1, 0xE2F5, 0xDB48, 0xD1D0, 0xCB43, 0xC539, 0xC060, 0xBE25, 0xBCF0, 0xBC93, 0xBCD7, 0xBD17, 0xC1D9, 0xC5E8, 0xC9D3,
    0xCF79, 0xD379, 0xD7DA, 0xD9F2, 0xDB8D, 0xDCED, 0xDD1E, 0xDD45, 0xDFFC, 0xE1E3, 0xE6B3, 0xEAC7, 0xF096, 0xF5E5, 0xFB62, 0x02FD,
    0x086F, 0x0C05, 0x10A3, 0x1227, 0x11BA, 0x1179, 0x0C4E, 0x08A7, 0x0536, 0x030B, 0x02DC, 0x0264, 0x02F1, 0x06BD, 0x0B1B, 0x0F97,
    0x14F7, 0x1C0D, 0x22CC, 0x28A0, 0x2D44, 0x2ED6, 0x3011, 0x31CA, 0x312D, 0x2F55, 0x2CE4, 0x2847, 0x2383, 0x1C9D, 0x1277, 0x0937,
    0x0019, 0xF709, 0xF0FA, 0xEC95, 0xE9A8, 0xE97A, 0xE8E4, 0xEA55, 0xEA86, 0xE9C9, 0xEDDE, 0xF0C6, 0xF394, 0xF6C9, 0xF923, 0xFABC,
    0xF9BC, 0xF754, 0xF6A0, 0xF365, 0xF2A7, 0xF215, 0xF172, 0xF11D, 0xF1CF, 0xF342, 0xF484, 0xF8A0, 0xFBCE, 0xFEEC, 0x0296, 0x0580,
    0x077E, 0x0962, 0x093D, 0x0BA1, 0x0BFC, 0x0EBA, 0x10A5, 0x13E6, 0x16B8, 0x1724, 0x1939, 0x19FF, 0x1B82, 0x1F38, 0x21F6, 0x230C,
    0x238F, 0x1FE7, 0x209F, 0x1D5B, 0x1B80, 0x1C35, 0x1D70, 0x1F94, 0x1DC0, 0x1ADB, 0x152A, 0x0C34, 0x03C2, 0xF876, 0xEC2F, 0xE518,
    0xDE5C, 0xD9F1, 0xD5B9, 0xD488, 0xD525, 0xD502, 0xD700, 0xD96B, 0xDB1D, 0xDEC1, 0xE19A, 0xE3D9, 0xE4D2, 0xE4C6, 0xE719, 0xE4FF,
    0xE36A, 0xE16F, 0xDF56, 0xDCD6, 0xDBB6, 0xDA77, 0xDA30, 0xDC43, 0xDD32, 0xE02E, 0xE1CC, 0xE45B, 0xE5F8, 0xE80E, 0xE8D2, 0xE90B,
    0xE7AC, 0xE602, 0xE2A6, 0xE1AA, 0xE115, 0xDF95, 0xE1C4, 0xE2F1, 0xE995, 0xF12B, 0xF735, 0xFEED, 0x0720, 0x0B36, 0x0F20, 0x1093,
    0x1100, 0x12AD, 0x1655, 0x192D, 0x1DEC, 0x2142, 0x23B8, 0x24FD, 0x223E, 0x1F4D, 0x17C4, 0x10F8, 0x0958, 0x02B7, 0xFCA0, 0xF831,
    0xF3FD, 0xF2E1, 0xEEC3, 0xED9D, 0xECDF, 0xEBCE, 0xEED8, 0xEF00, 0xF330, 0xF613, 0xFA50, 0xFD30, 0xFFBC, 0x0253, 0x0441, 0x04A3,
    0x0547, 0x04E1, 0x051D, 0x0712, 0x07EE, 0x089F, 0x093F, 0x0B27, 0x0AEA, 0x0E8F, 0x104C, 0x11B7, 0x142E, 0x13F0, 0x140A, 0x121D,
    0x0F6C, 0x1096, 0x10C2, 0x11B6, 0x14A2, 0x17BA, 0x1D5A, 0x20DF, 0x2470, 0x250D, 0x2585, 0x25B6, 0x23A1, 0x2292, 0x23E5, 0x224D,
    0x22DA, 0x2082, 0x1C91, 0x1825, 0x10BE, 0x0BE3, 0x03E9, 0xFC68, 0xF373, 0xECC2, 0xE60F, 0xE1C7, 0xDE79, 0xDF2D, 0xE00B, 0xE275,
    0xE44F, 0xE4D8, 0xE709, 0xE72B, 0xE917, 0xE7E9, 0xE91A, 0xE9A0, 0xEB3F, 0xE9D3, 0xE76D, 0xE53D, 0xE2D4, 0xE146, 0xE135, 0xE393,
    0xE75A, 0xECD7, 0xF3DB, 0xF87E, 0xF9A0, 0xFD72, 0xFEE2, 0xFEF2, 0xFED4, 0xFDC3, 0xFD78, 0xFE7D, 0xFE39, 0xFFBD, 0xFFF8, 0x02D9,
    0x0723, 0x0B3A, 0x1021, 0x16BF, 0x1E8B, 0x236D, 0x2952, 0x2D19, 0x3150, 0x320A, 0x35D4, 0x379E, 0x379E, 0x37C5, 0x3471, 0x328F,
    0x2DE8, 0x26B0, 0x1E22, 0x1561, 0x0903, 0xFF54, 0xF2A2, 0xE974, 0xE27D, 0xDCB5, 0xDBB3, 0xD7EA, 0xD621, 0xD408, 0xD230, 0xD007,
    0xCD43, 0xCC2D, 0xCDFE, 0xD027, 0xD28D, 0xD477, 0xD53C, 0xD544, 0xD632, 0xD30C, 0xD18A, 0xD373, 0xD6E4, 0xDB04, 0xE1C3, 0xE99B,
    0xF267, 0xF9F4, 0xFF9B, 0x05C6, 0x07F9, 0x0C34, 0x0A08, 0x0A55, 0x065C, 0x0305, 0x022E, 0xFE6C, 0xFF53, 0x0120, 0x035E, 0x073F,
    0x0BE3, 0x0F22, 0x15D0, 0x1854, 0x1C85, 0x2094, 0x2623, 0x2C85, 0x315E, 0x382D, 0x3A16, 0x3D02, 0x3D18, 0x38AF, 0x336A, 0x2B6D,
    0x22AF, 0x1859, 0x0C3B, 0x01C3, 0xF9AE, 0xF3D0, 0xEF97, 0xEDC2, 0xECFA, 0xEC51, 0xEC2F, 0xEB38, 0xE9E8, 0xEC01, 0xED1E, 0xEE69,
    0xF12B, 0xF342, 0xF4C8, 0xF2D3, 0xF325, 0xEF90, 0xED41, 0xEBBF, 0xE9E7, 0xE96E, 0xE869, 0xEA72, 0xEC0B, 0xEE1B, 0xEF44, 0xF45F,
    0xF867, 0xFD54, 0xFFF9, 0x01E0, 0x01C4, 0x0104, 0x0174, 0x00AA, 0x0351, 0x0890, 0x101F, 0x1610, 0x1EA2, 0x2372, 0x28A9, 0x2C3A,
    0x2CCF, 0x2FCC, 0x2F47, 0x3030, 0x347B, 0x3481, 0x3673, 0x3814, 0x3864, 0x38D4, 0x36FA, 0x3533, 0x31CA, 0x2BB4, 0x24B4, 0x1BCE,
    0x117B, 0x093C, 0x0195, 0xFF8C, 0xFB84, 0xF9E9, 0xF807, 0xF58C, 0xF301, 0xEFA5, 0xEEBF, 0xED6D, 0xEFFE, 0xF1C4, 0xF612, 0xF842,
    0xFA79, 0xFC6D, 0xFAFD, 0xF87D, 0xF54F, 0xF27F, 0xF009, 0xED59, 0xE8C4, 0xEA39, 0xE966, 0xEA54, 0xEA50, 0xE7F8, 0xE981, 0xE64A,
    0xE39A, 0xDEA9, 0xDA62, 0xD99D, 0xD892, 0xD804, 0xD83B, 0xD8A7, 0xDAE3, 0xDB8C, 0xDC26, 0xDE6D, 0xDE9C, 0xE314, 0xE711, 0xE98A,
    0xEF1A, 0xF2F3, 0xF98D, 0xFC63, 0x0024, 0x035C, 0x047A, 0x0780, 0x06FF, 0x0984, 0x08E0, 0x0850, 0x05FA, 0x0463, 0x02B5, 0x02C1,
    0x0211, 0x01B3, 0x018E, 0x0008, 0xFECE, 0xFB0F, 0xFB1F, 0xF922, 0xFA84, 0xFADE, 0xFC9A, 0xFFAF, 0x01A6, 0x0464, 0x03F4, 0x0581,
    0x07B5, 0x09DD, 0x0B4E, 0x0C0A, 0x0F74, 0x12B6, 0x12E6, 0x11BA, 0x1455, 0x15E2, 0x1523, 0x1557, 0x12CF, 0x0FDE, 0x0C79, 0x0863,
    0x0631, 0x0519, 0x0508, 0x0A37, 0x0C2E, 0x0F6F, 0x1386, 0x1542, 0x17EF, 0x15FF, 0x1816, 0x1764, 0x1738, 0x191C, 0x1845, 0x1AC0,
    0x1B98, 0x1DE3, 0x1F17, 0x1E89, 0x1CDC, 0x1B40, 0x12EA, 0x0A6A, 0x02EC, 0xFA73, 0xF418, 0xEF36, 0xEF0E, 0xEE4F, 0xEF77, 0xEE3E,
    0xEF17, 0xEF9C, 0xF1B7, 0xF622, 0xF8BA, 0xFEEA, 0x04FA, 0x09A5, 0x0D35, 0x0D12, 0x0F35, 0x0E66, 0x0B53, 0x0841, 0x032C, 0x00A3,
    0xFDF0, 0xFB56, 0xFCE6, 0xFFDB, 0x03A0, 0x0A2C, 0x0D8F, 0x1240, 0x0FDB, 0x0E19, 0x0ABE, 0x0316, 0xFE57, 0xFAA1, 0xFA1D, 0xFA9D,
    0xFBF3, 0xFD43, 0xFFA5, 0x0010, 0x0109, 0xFFF6, 0x014E, 0x023C, 0x036E, 0x05F3, 0x06E3, 0x0BEE, 0x0EBC, 0x10D3, 0x123A, 0x1269,
    0x10E3, 0x0D9B, 0x0908, 0x012B, 0xF8FE, 0xEF3D, 0xE73E, 0xDFF2, 0xDA3E, 0xD721, 0xD524, 0xD303, 0xD0EF, 0xCF05, 0xCC2E, 0xCAEA,
    0xC877, 0xC73F, 0xC719, 0xC784, 0xCAA6, 0xCCD6, 0xD06C, 0xD38E, 0xD6E0, 0xD96D, 0xDA3A, 0xD9EC, 0xD84B, 0xDAF1, 0xDBCB, 0xE072,
    0xE596, 0xEE8F, 0xF91F, 0x03AB, 0x0DC0, 0x13CF, 0x181E, 0x19F0, 0x1BF6, 0x1D5B, 0x1D7E, 0x1D49, 0x22D4, 0x2337, 0x2466, 0x24A1,
    0x2390, 0x235B, 0x20A0, 0x1F08, 0x1F28, 0x1D33, 0x20DA, 0x263F, 0x298F, 0x2ED3, 0x3487, 0x3917, 0x36E9, 0x3EDF, 0x3990, 0x342C,
    0x27EE, 0x25F6, 0x1E5B, 0x0B68, 0x107A, 0x065A, 0x094B, 0xFDD5, 0xFDA3, 0x0133, 0xF8AF, 0xF693, 0xF82D, 0xF27F, 0xF710, 0xFBA8,
    0xF041, 0xFCFE, 0xF3E4, 0xFD56, 0xFA89, 0xEFEB, 0xFC0F, 0xF806, 0xF138, 0xF609, 0xEE82, 0xE0AB, 0xE8A1, 0xE675, 0xEDBA, 0xFE0D,
    0xDFCF, 0xF345, 0xFDF2, 0xE6B6, 0xFF11, 0xE40E, 0xF6A7, 0xFCFC, 0xE918, 0xFA53, 0xFA36, 0x111A, 0xFE5C, 0xFA95, 0x1F77, 0x1245,
    0x027B, 0x13B6, 0x1C1C, 0x189A, 0x1655, 0x08E5, 0x2602, 0x17E0, 0x0F77, 0x1FB7, 0x1F11, 0x0F5D, 0xF794, 0x0E6D, 0xFE4A, 0xFB29,
    0xDE42, 0xD5A3, 0xDADD, 0xD88C, 0xC579, 0xBA5C, 0xC9CB, 0xB816, 0xB553, 0xBD80, 0xC127, 0xB13F, 0xB594, 0xBCD3, 0xC8E7, 0xC10C,
    0xD220, 0xD84E, 0xD913, 0xF4FC, 0xF415, 0x01BC, 0x0065, 0x0F76, 0x1CAB, 0x2511, 0x2570, 0x2378, 0x3D25, 0x437A, 0x3CFC, 0x3349,
    0x3DB1, 0x31B9, 0x2BA3, 0x1EDA, 0x194D, 0x11C2, 0xF7B9, 0xED5A, 0xE267, 0xE4B7, 0xCF4C, 0xCB28, 0xC9EE, 0xBF02, 0xB165, 0xAA63,
    0xB5E9, 0xAA7B, 0xAA67, 0xB493, 0xA77B, 0xAB15, 0x9EE2, 0xCD77, 0xD32B, 0xBB3C, 0xC199, 0xBCA0, 0xCF7C, 0xD0A5, 0xDCB8, 0xD13D,
    0xDD2C, 0xD065, 0xE577, 0xFDCA, 0x0187, 0xEE83, 0x07DD, 0x1547, 0xF265, 0x20B8, 0x1823, 0x242E, 0x2572, 0x22C5, 0x3624, 0x438B,
    0x3E8B, 0x487B, 0x547B, 0x5030, 0x591A, 0x6170, 0x6C1D, 0x63F7, 0x704A, 0x6733, 0x6958, 0x71BD, 0x6C7E, 0x65E3, 0x6403, 0x6383,
    0x56AC, 0x5B80, 0x5C0C, 0x477D, 0x4B69, 0x5182, 0x4CE5, 0x4A43, 0x52EA, 0x45C5, 0x457B, 0x4D50, 0x480D, 0x4B5B, 0x4296, 0x4FF0,
    0x442C, 0x5454, 0x4833, 0x4F77, 0x4B85, 0x3A0B, 0x466F, 0x35DA, 0x35FA, 0x1FAC, 0x2BDD, 0x1FB6, 0x177B, 0x189A, 0x0982, 0xFFAE,
    0xF7FF, 0x0577, 0xE92B, 0xEE87, 0xE519, 0xD40C, 0xEA74, 0xE598, 0xD528, 0xDB30, 0xE79D, 0xCA1A, 0xDF15, 0xE115, 0xCD89, 0xCC8D,
    0xC3D2, 0xC836, 0xC606, 0xBD2B, 0xBDD7, 0xBFDB, 0xBD15, 0xC122, 0xBBC0, 0xBB9F, 0xC065, 0xB2CE, 0xB56B, 0xB9DF, 0xB6D0, 0xB593,
    0xB6A7, 0xC49C, 0xA772, 0xBB61, 0xB3E2, 0xB448, 0xBDFB, 0xB4D7, 0xB40D, 0xB024, 0xC2DB, 0xBE7B, 0xC6C2, 0xCE0E, 0xC517, 0xC69C,
    0xDF75, 0xD827, 0xE112, 0xD08E, 0xDC3D, 0xD5E2, 0xC941, 0xDA59, 0xCCC1, 0xC8A3, 0xC8F2, 0xCC94, 0xC9B2, 0xC41C, 0xC264, 0xC911,
    0xB6B1, 0xB89F, 0xC420, 0xC1DD, 0xB3F8, 0xC281, 0xC1F4, 0xC30C, 0xC418, 0xC50E, 0xC460, 0xC286, 0xC1C8, 0xC031, 0xC90F, 0xC4D1,
    0xCA68, 0xCEAF, 0xDA57, 0xC833, 0xD74F, 0xE11E, 0xDE56, 0xDCF1, 0xE11F, 0xF10F, 0xE73B, 0xF3E8, 0xF927, 0xFE82, 0x1A86, 0x181C,
    0x1525, 0x265E, 0x328B, 0x2389, 0x2E1C, 0x3BBA, 0x34AD, 0x3D21, 0x41DD, 0x4DD1, 0x5748, 0x5E98, 0x5E5C, 0x6F8A, 0x6931, 0x6B70,
    0x6A9F, 0x7472, 0x7248, 0x65DC, 0x7042, 0x6CB1, 0x6EA9, 0x75F9, 0x5E95, 0x63A9, 0x7414, 0x6320, 0x65C5, 0x5C8A, 0x6408, 0x5FEF,
    0x6560, 0x6096, 0x6F08, 0x5F61, 0x641B, 0x6646, 0x64D4, 0x6C24, 0x582C, 0x6926, 0x593B, 0x5AF3, 0x5B6E, 0x6162, 0x5216, 0x50B6,
    0x4F0E, 0x5576, 0x4DEF, 0x43FE, 0x4E3E, 0x34A0, 0x3A40, 0x3AB5, 0x2CD2, 0x3477, 0x2DBF, 0x2D72, 0x311C, 0x2919, 0x2F04, 0x27D2,
    0x3260, 0x2C96, 0x2FE3, 0x33D6, 0x23B5, 0x3329, 0x3DB9, 0x3239, 0x3784, 0x311B, 0x3A61, 0x3AE7, 0x25E5, 0x36DA, 0x2DF1, 0x22F4,
    0x2B87, 0x1DF2, 0x14DD, 0x2112, 0x0D19, 0x0D39, 0x1AA1, 0x0839, 0x099F, 0x1418, 0x069E, 0x0184, 0x0202, 0xFD04, 0x028E, 0xF93A,
    0xF386, 0x0795, 0xFA71, 0xF383, 0xF787, 0xF195, 0xFC4D, 0xE782, 0xED42, 0xF831, 0xE8A4, 0xEF24, 0xE5D4, 0xE28D, 0xD889, 0xD4EE,
    0xCE3C, 0xC69B, 0xC5EA, 0xBC65, 0xBDB9, 0xAE3E, 0xBF32, 0xAD27, 0xB357, 0xB0F9, 0xA905, 0xB2B4, 0xA280, 0xA689, 0x9928, 0xA464,
    0xA15B, 0x9FB0, 0x99E4, 0xB1CA, 0xAF24, 0xA2CC, 0xACC0, 0xA759, 0xA3EE, 0xA094, 0xA347, 0x999F, 0x9D1D, 0x976B, 0x9A7B, 0x96F6,
    0x9A31, 0x92C4, 0x9E2B, 0x9FA5, 0xA121, 0xA41A, 0xA355, 0xA82D, 0xAC69, 0xB016, 0xA90F, 0xBA18, 0xAC28, 0xB2A1, 0xBB8A, 0xBC09,
    0xB45D, 0xB72E, 0xB94A, 0xC246, 0xB243, 0xBCCD, 0xC013, 0xC1A7, 0xD1B1, 0xC002, 0xD105, 0xC8F0, 0xDBBB, 0xDF2A, 0xE4CF, 0xE8EC,
    0xED40, 0x0160, 0x0B58, 0x0F35, 0x10DC, 0x0CBC, 0x0D65, 0x0CE2, 0x04E2, 0x04B5, 0x00A0, 0xF107, 0xF0D4, 0x0171, 0xEADC, 0xF1A4,
    0xF856, 0xFB31, 0x0068, 0xFBB0, 0x041B, 0xFDAD, 0xFF5E, 0x02CA, 0x010F, 0xF84D, 0x0163, 0x0132, 0xF3D6, 0xFFBA, 0xF52E, 0xF6A1,
    0xF94C, 0xF1D7, 0xE326, 0xEA3F, 0xF0EC, 0xE7D4, 0xEF12, 0xEC57, 0xF10E, 0x04DF, 0x07DD, 0x16F3, 0x1AF7, 0x158D, 0x2918, 0x3723,
    0x4F1A, 0x34F5, 0x36D1, 0x3D1A, 0x3BC4, 0x31AA, 0x2F6E, 0x3047, 0x1FBF, 0x2090, 0x170A, 0x1AEF, 0x15C6, 0x16F6, 0x10E7, 0x113C,
    0x135C, 0x169E, 0x195A, 0x2061, 0x157A, 0x1A72, 0x1AEA, 0x1CBB, 0x2B9F, 0x1D35, 0x2D2B, 0x2D6E, 0x25DC, 0x3FB3, 0x3437, 0x3546,
    0x305A, 0x3071, 0x39EA, 0x39A5, 0x41F3, 0x387C, 0x405E, 0x3A96, 0x479C, 0x41CA, 0x4E4F, 0x46B5, 0x5552, 0x6064, 0x55A0, 0x583C,
    0x580F, 0x50EB, 0x440D, 0x4D14, 0x3E85, 0x3899, 0x26AD, 0x395A, 0x274E, 0x1DCF, 0x1E6D, 0x2007, 0x2290, 0x1CC3, 0x2A57, 0x2707,
    0x27E8, 0x25F8, 0x2602, 0x2A48, 0x338B, 0x3055, 0x330D, 0x3A05, 0x3A11, 0x37BF, 0x3F9C, 0x3C2F, 0x3E6E, 0x41E6, 0x3EFA, 0x43FE,
    0x4DB4, 0x44C5, 0x4BC8, 0x4F0E, 0x465E, 0x500C, 0x545A, 0x58DD, 0x4A59, 0x567F, 0x6359, 0x6579, 0x5CE1, 0x5D33, 0x5C15, 0x4F29,
    0x4B9C, 0x4B8D, 0x3F19, 0x2BF5, 0x3046, 0x2884, 0x16CB, 0x1492, 0x1908, 0x0DF3, 0xFEE0, 0x0187, 0x02B1, 0xF199, 0xF4ED, 0xEBDA,
    0xED53, 0xF464, 0xF89D, 0xEED8, 0xF874, 0x0169, 0xFED9, 0xFF17, 0xFA94, 0x0D03, 0xFB3A, 0xF92E, 0xFB5D, 0xFEB2, 0xFCD9, 0xFD8B,
    0xFFB4, 0xF54A, 0xFA1B, 0x08F4, 0xF70F, 0xF3F3, 0x0532, 0x0120, 0x0F5B, 0x1DAF, 0x16C2, 0x129E, 0x10AE, 0x10FB, 0x0B2D, 0x0188,
    0xFE5A, 0xF061, 0xF66B, 0xF470, 0xEDC6, 0xE9EA, 0xE6F1, 0xEEE8, 0xF2D3, 0xE8BA, 0xF605, 0xEF3B, 0xE59A, 0xE98D, 0xE5AF, 0xE46E,
    0xDF58, 0xE0F7, 0xE17B, 0xDC87, 0xD5C1, 0xDF5A, 0xD70A, 0xD3B0, 0xCDC2, 0xC808, 0xC626, 0xC954, 0xCD43, 0xCA0E, 0xCA1D, 0xCA5D,
    0xC3D7, 0xCB8D, 0xCD7E, 0xCCFB, 0xCEEA, 0xD091, 0xDD31, 0xDEDA, 0xDCF8, 0xD6E7, 0xDB5A, 0xD89F, 0xD9C1, 0xCD97, 0xCAF5, 0xC33F,
    0xC814, 0xBEBA, 0xAF91, 0xB13B, 0xAE81, 0xB5D1, 0xAE25, 0xB663, 0xAE0F, 0xB184, 0xB1C1, 0xB03A, 0xB7C3, 0xA9DC, 0xB3ED, 0xB877,
    0xB2A0, 0xBA8C, 0xB5E9, 0xBC80, 0xB9DE, 0xBAAB, 0xB3C1, 0xB146, 0xB510, 0xAECF, 0xB0BD, 0xA33C, 0xA987, 0xA784, 0xA8B4, 0xAB60,
    0xABA3, 0xA91B, 0xB0A7, 0xBFBE, 0xBF3A, 0xC181, 0xC508, 0xC48B, 0xC5AD, 0xCBE5, 0xCB87, 0xCDAE, 0xC455, 0xCE19, 0xCDC2, 0xC3E9,
    0xC414, 0xBF89, 0xC48F, 0xBF53, 0xC455, 0xC32F, 0xC2A2, 0xC89C, 0xCC8E, 0xCCA1, 0xC919, 0xD562, 0xD5F1, 0xD5FE, 0xD716, 0xDC7F,
    0xDDE4, 0xDD9E, 0xE1C4, 0xDF71, 0xDABA, 0xE2C8, 0xE6B9, 0xE07C, 0xEAF8, 0xE3F4, 0xEC2F, 0xEF9B, 0xF46D, 0x03AF, 0x0053, 0x0686,
    0x1545, 0x2504, 0x2B75, 0x2E60, 0x2D01, 0x2547, 0x2406, 0x2426, 0x19B6, 0x0777, 0x09B6, 0x0A14, 0xFB31, 0xF456, 0xF1CB, 0xF037,
    0xE84B, 0xF1BA, 0xEED1, 0xEBB3, 0xEF64, 0xEECB, 0xF4C6, 0xF347, 0xF8EB, 0xFC53, 0x0217, 0x0AFE, 0x0D44, 0x1166, 0x18A4, 0x2030,
    0x2071, 0x1DF0, 0x1EE2, 0x230F, 0x23E1, 0x26F6, 0x3086, 0x2A33, 0x2CE8, 0x364B, 0x34EA, 0x37EE, 0x319F, 0x3FB7, 0x4E2C, 0x4D6B,
    0x57C3, 0x56A0, 0x5258, 0x5964, 0x5B4B, 0x5374, 0x5117, 0x4BB6, 0x4CEF, 0x451B, 0x410C, 0x3E12, 0x3B4F, 0x35E9, 0x39F9, 0x3E4B,
    0x3B4D, 0x4098, 0x3A46, 0x3858, 0x36F3, 0x3BEA, 0x3509, 0x36DE, 0x3997, 0x37E3, 0x33DF, 0x3620, 0x4025, 0x3449, 0x2B8A, 0x3139,
    0x28D1, 0x2E02, 0x3032, 0x326D, 0x3559, 0x2C56, 0x3748, 0x38C7, 0x3ED5, 0x3B14, 0x3954, 0x415C, 0x4D72, 0x5511, 0x590D, 0x53CD,
    0x52AB, 0x5433, 0x5124, 0x4E8D, 0x3F0D, 0x3D51, 0x380B, 0x2F8B, 0x239C, 0x1D45, 0x1B27, 0x1737, 0x189B, 0x1A94, 0x208C, 0x2197,
    0x1C79, 0x22E6, 0x2ACA, 0x26BA, 0x2EE8, 0x3528, 0x3940, 0x3A2A, 0x3833, 0x3E6A, 0x3F78, 0x3E94, 0x357C, 0x3384, 0x2ABB, 0x2932,
    0x2ADC, 0x2506, 0x1E11, 0x1623, 0x1E8D, 0x1DC7, 0x1FC4, 0x1B89, 0x2062, 0x28C3, 0x2D51, 0x37EB, 0x3AD7, 0x36F7, 0x3689, 0x3CD4,
    0x3757, 0x31A5, 0x2EF9, 0x2DC3, 0x272C, 0x228F, 0x20A5, 0x1534, 0x11DE, 0x1624, 0x12A3, 0x17B1, 0x1923, 0x13B8, 0x182E, 0x1DAC,
    0x1D0D, 0x1728, 0x1BA6, 0x19E5, 0x1728, 0x13FA, 0x1391, 0x171E, 0x118C, 0x0A50, 0x03F2, 0x02E8, 0xFE1C, 0x0035, 0xFD00, 0xF7FE,
    0xF2A4, 0xF37C, 0xF9AC, 0xFA82, 0xFB33, 0xFA38, 0x0669, 0x137F, 0x1BBF, 0x23F2, 0x2222, 0x185D, 0x1C1D, 0x148E, 0x093B, 0xFCC3,
    0xF645, 0xF0A6, 0xE5C7, 0xDE41, 0xD0A9, 0xCD48, 0xC774, 0xC1E1, 0xBE80, 0xC3EF, 0xC22C, 0xBD1E, 0xC039, 0xC33D, 0xC46F, 0xC76E,
    0xCBA4, 0xCE2E, 0xCBEA, 0xCD15, 0xD3DC, 0xD36E, 0xD27B, 0xD03D, 0xCD04, 0xC808, 0xCDC4, 0xCF77, 0xCC29, 0xD0AA, 0xCA0C, 0xCEDC,
    0xD77A, 0xD1A9, 0xD58D, 0xD12E, 0xD83B, 0xE456, 0xE960, 0xEEE6, 0xEC24, 0xEC06, 0xEB2B, 0xE9AA, 0xDE7D, 0xD803, 0xD178, 0xCB53,
    0xC381, 0xB90B, 0xB5CE, 0xB739, 0xB538, 0xB2C1, 0xB00C, 0xAF52, 0xB308, 0xAC22, 0xA9E4, 0xA807, 0xA4C0, 0xA3D9, 0xA754, 0xA504,
    0xA36D, 0xA212, 0xA49B, 0xA5D6, 0xA499, 0xA8D7, 0xA1D9, 0xA4AD, 0xA8EC, 0xAC2D, 0xB001, 0xB04B, 0xB3C6, 0xBC23, 0xC073, 0xC1AE,
    0xC5EC, 0xC9D5, 0xD309, 0xDF97, 0xE483, 0xE6E3, 0xEAB8, 0xEACB, 0xED64, 0xE70B, 0xE080, 0xE065, 0xD8A7, 0xD50D, 0xD31C, 0xC82D,
    0xC54D, 0xC4E7, 0xC450, 0xCBA0, 0xC8BB, 0xC33B, 0xCA33, 0xCE2D, 0xCC7B, 0xCAE8, 0xC80B, 0xD069, 0xCE37, 0xCE35, 0xD3EA, 0xD36B,
    0xD8B4, 0xDA2B, 0xDDA1, 0xD82E, 0xD53D, 0xD7E4, 0xD504, 0xD4AC, 0xD51B, 0xCD88, 0xD298, 0xD45D, 0xCFCD, 0xCD13, 0xCAB8, 0xD192,
    0xD492, 0xDDC7, 0xE0F9, 0xDE8F, 0xE06F, 0xE851, 0xE751, 0xE167, 0xDF63, 0xDDBE, 0xDCC8, 0xD767, 0xD668, 0xD3AD, 0xCD3A, 0xCF70,
    0xD0D5, 0xD898, 0xDE53, 0xDD22, 0xE3F7, 0xE9F3, 0xED13, 0xEBCC, 0xF2A0, 0xF9F3, 0xFBE7, 0xFB61, 0xFE12, 0x05D1, 0x0654, 0x0B43,
    0x07D1, 0xFFC7, 0x0367, 0xFF47, 0x0729, 0x0498, 0x0057, 0x0176, 0x0361, 0x0EFA, 0x0A07, 0x0AA9, 0x1043, 0x19AC, 0x1F03, 0x267A,
    0x2A00, 0x2776, 0x245F, 0x25A0, 0x1CEE, 0x0EC9, 0x12B4, 0x0A91, 0x0139, 0xFFB5, 0xF207, 0xEC15, 0xE376, 0xE083, 0xE4C6, 0xDCB5,
    0xE044, 0xDF91, 0xE1C4, 0xE6A8, 0xE99C, 0xE466, 0xEF43, 0xF190, 0xF290, 0xF046, 0xF2E2, 0xFB72, 0xF786, 0xFA69, 0xF7E5, 0xFC8A,
    0xF38E, 0xFCBC, 0x00E4, 0xFF75, 0xFD6A, 0xFF2F, 0x07F6, 0x05AE, 0x063B, 0x0822, 0x063C, 0x1410, 0x22C8, 0x2826, 0x2971, 0x2B57,
    0x37D9, 0x3A00, 0x38DE, 0x3617, 0x398E, 0x36F7, 0x391B, 0x39EB, 0x3918, 0x3B35, 0x3D94, 0x3CFE, 0x414C, 0x44B1, 0x438B, 0x3F63,
    0x3DD7, 0x3C5B, 0x3A69, 0x3875, 0x3933, 0x3920, 0x2FAF, 0x33AE, 0x3140, 0x3426, 0x304B, 0x32DE, 0x2EEE, 0x2569, 0x28CD, 0x32CA,
    0x330D, 0x2B61, 0x2BAC, 0x34A1, 0x3B37, 0x344C, 0x3C02, 0x3AA7, 0x3DCC, 0x4D45, 0x5704, 0x5B76, 0x5F04, 0x6368, 0x624D, 0x6099,
    0x5EF2, 0x5788, 0x55FF, 0x51CB, 0x4BCA, 0x4494, 0x4002, 0x37D6, 0x34AA, 0x32C2, 0x2E08, 0x2F8E, 0x2B97, 0x2D35, 0x29CD, 0x2927,
    0x1F7E, 0x244F, 0x2610, 0x24B7, 0x27BC, 0x2573, 0x2C15, 0x2F13, 0x325C, 0x3125, 0x2B64, 0x2A97, 0x2D48, 0x2C9A, 0x2A8D, 0x24DA,
    0x27E5, 0x2327, 0x2564, 0x227A, 0x1F69, 0x1E9A, 0x213D, 0x2DBB, 0x2EBD, 0x32DF, 0x33F5, 0x3AA2, 0x3DC0, 0x3B01, 0x3435, 0x33C7,
    0x32A3, 0x2ACE, 0x2554, 0x1E4C, 0x1813, 0x1291, 0x121B, 0x1438, 0x1271, 0x11C9, 0x1600, 0x1630, 0x15AF, 0x13BD, 0x1677, 0x170C,
    0x1992, 0x1902, 0x18C2, 0x1C8E, 0x1C8B, 0x21FE, 0x20F9, 0x1EE5, 0x1554, 0x1584, 0x1AB0, 0x196E, 0x127F, 0x15B2, 0x1B9F, 0x18F1,
    0x1D0F, 0x1BA7, 0x1F89, 0x1C6E, 0x2721, 0x33AF, 0x370D, 0x3A02, 0x3AAE, 0x3CDD, 0x3814, 0x31D0, 0x26CC, 0x22CF, 0x1ABE, 0x0F33,
    0x059E, 0xF778, 0xEAF6, 0xE0BE, 0xD85E, 0xD42A, 0xCC8B, 0xC925, 0xC9CC, 0xCA6F, 0xC9C0, 0xC848, 0xD097, 0xD2F3, 0xDAB7, 0xD9E4,
    0xDF95, 0xE680, 0xEA0B, 0xF3D5, 0xF30E, 0xF367, 0xEC35, 0xEF14, 0xF085, 0xECDE, 0xE8BD, 0xE748, 0xE57C, 0xE524, 0xE6F5, 0xDF37,
    0xDD07, 0xE199, 0xEA2D, 0xF06C, 0xF318, 0xF6E9, 0xFA2C, 0xFEE9, 0xFD4F, 0xF617, 0xF2F9, 0xF09A, 0xEE50, 0xE9EE, 0xE4BB, 0xDF19,
    0xDA49, 0xD87E, 0xD955, 0xD745, 0xD39A, 0xD4BF, 0xD576, 0xD423, 0xD234, 0xD168, 0xD0CA, 0xD027, 0xD374, 0xCCAB, 0xCCBF, 0xCE90,
    0xCD58, 0xCFA6, 0xCA5E, 0xC729, 0xC41B, 0xC963, 0xC6DD, 0xC256, 0xC5A4, 0xC27B, 0xC2D0, 0xC40E, 0xC5EC, 0xC4B2, 0xC29B, 0xCC3B,
    0xD784, 0xDEB1, 0xE3B5, 0xEBE6, 0xF5A0, 0xF5FB, 0xF2F6, 0xF2EC, 0xEDDC, 0xECBC, 0xE6D4, 0xDEEF, 0xD9D7, 0xD046, 0xCE86, 0xCA27,
    0xC86B, 0xC6BE, 0xC4FB, 0xC534, 0xC480, 0xC36D, 0xC14D, 0xC46C, 0xC61C, 0xC5C8, 0xC918, 0xCB65, 0xCEC0, 0xD171, 0xD248, 0xD60A,
    0xD00D, 0xCDBA, 0xCD81, 0xCCD0, 0xC7F7, 0xC26D, 0xC361, 0xBEED, 0xC1D0, 0xBFFB, 0xBAFE, 0xB898, 0xB8C5, 0xC0DE, 0xC683, 0xC8AC,
    0xCBC4, 0xCF43, 0xD88D, 0xDDC0, 0xDBF6, 0xDE1F, 0xDD19, 0xDA86, 0xD8A2, 0xD689, 0xD08E, 0xC768, 0xC6CD, 0xC7E5, 0xC6E7, 0xC8EE,
    0xC8E4, 0xCCAB, 0xCC6F, 0xCC97, 0xCA80, 0xCADD, 0xCD6F, 0xC932, 0xC9BB, 0xC7CA, 0xCB80, 0xCC2A, 0xCF2E, 0xCB52, 0xC386, 0xC299,
    0xC133, 0xBF8D, 0xBAB5, 0xBBE9, 0xBB54, 0xBEAB, 0xC656, 0xCBCF, 0xCB9A, 0xCE82, 0xD7C7, 0xE69D, 0xF019, 0xFAC1, 0x0279, 0x09C0,
    0x11CF, 0x0CBE, 0x0AA9, 0x0550, 0x026B, 0xF7E3, 0xEC9E, 0xE4AA, 0xD7AE, 0xCFCB, 0xCA3C, 0xC62E, 0xC500, 0xC456, 0xC984, 0xCC77,
    0xCE46, 0xCFB5, 0xD366, 0xDAA4, 0xD982, 0xDDFA, 0xE247, 0xE541, 0xEA31, 0xF2DB, 0xF9F7, 0xF8F3, 0xF676, 0xF9DD, 0xFEC5, 0xFFE7,
    0xFE7A, 0x0206, 0x0471, 0x0682, 0x0BA9, 0x0866, 0x08C6, 0x0945, 0x151B, 0x1BE1, 0x217F, 0x29DF, 0x2D22, 0x35C0, 0x361A, 0x34C1,
    0x314B, 0x2E96, 0x29AA, 0x2498, 0x22C9, 0x1C8D, 0x13E2, 0x0EB1, 0x0D26, 0x10C9, 0x0C20, 0x0C56, 0x1036, 0x0F53, 0x1017, 0x0E6F,
    0x1417, 0x13FB, 0x15B1, 0x174F, 0x15D2, 0x179C, 0x199F, 0x1B95, 0x1C0D, 0x15FE, 0x124A, 0x160F, 0x177D, 0x1492, 0x1561, 0x1565,
    0x1636, 0x1F59, 0x22B5, 0x1FA0, 0x1F4B, 0x268A, 0x2F18, 0x3A52, 0x40D0, 0x47C0, 0x4EF3, 0x5306, 0x521A, 0x4F47, 0x4B9C, 0x46AA,
    0x425E, 0x3C5F, 0x39A5, 0x30F7, 0x2B25, 0x2635, 0x22AF, 0x1DC6, 0x1AB4, 0x19A3, 0x17D9, 0x15C4, 0x1239, 0x13A9, 0x1624, 0x1853,
    0x191F, 0x1EA8, 0x1E16, 0x20CE, 0x2774, 0x2A9E, 0x282C, 0x21BE, 0x2098, 0x1DDD, 0x1A6D, 0x158E, 0x1248, 0x0CC1, 0x0BBD, 0x0C9B,
    0x0676, 0xFD9B, 0xFBB4, 0xFE90, 0x03A6, 0x06E9, 0x087A, 0x0F67, 0x145F, 0x1A24, 0x18E6, 0x16A9, 0x1560, 0x10FC, 0x0F47, 0x0EB2,
    0x0B35, 0x0467, 0x02EE, 0x0AE8, 0x0B5A, 0x1002, 0x1436, 0x1B4A, 0x24A0, 0x2393, 0x2843, 0x2D9B, 0x3068, 0x2F40, 0x31F9, 0x35FF,
    0x36A2, 0x384F, 0x3F53, 0x4257, 0x417E, 0x3C7E, 0x3F79, 0x3F5E, 0x3ED1, 0x3F19, 0x3B6D, 0x3E75, 0x4234, 0x48BC, 0x4640, 0x44A1,
    0x48BE, 0x4EC1, 0x5719, 0x5CE8, 0x5FC5, 0x66F0, 0x6764, 0x67DB, 0x679E, 0x638A, 0x5ED0, 0x59FC, 0x5482, 0x4FF9, 0x45FF, 0x3909,
    0x2EAE, 0x25F0, 0x1FBA, 0x1940, 0x1894, 0x141F, 0x157B, 0x124E, 0x1035, 0x0F86, 0x0E36, 0x0B20, 0x0851, 0x0654, 0x033B, 0x08AA,
    0x0B0D, 0x0B4C, 0x081A, 0x079C, 0x08AF, 0x0854, 0x07A4, 0x03CD, 0x0034, 0x0444, 0x09F3, 0x0962, 0x0736, 0x05C7, 0x0951, 0x131A,
    0x18D5, 0x1C6F, 0x2023, 0x25A8, 0x29E0, 0x2ABE, 0x2A3E, 0x25F1, 0x24A4, 0x2281, 0x22AE, 0x1FB1, 0x17B0, 0x1324, 0x0FE9, 0x0CE7,
    0x08F2, 0x080A, 0x0781, 0x0627, 0x03F5, 0x00F1, 0x01B8, 0xFF8A, 0xFAF9, 0xFCD8, 0xF98A, 0xF270, 0xF42C, 0xF6B7, 0xF7E6, 0xF1D4,
    0xED07, 0xED99, 0xEBD0, 0xEB24, 0xE992, 0xE759, 0xE4BF, 0xE906, 0xED7C, 0xEC68, 0xE98F, 0xE996, 0xEE15, 0xF4C1, 0xFD7A, 0x0827,
    0x10D2, 0x15E3, 0x1A9F, 0x1AB8, 0x1B0B, 0x15AE, 0x0D2B, 0x0882, 0x04A1, 0xFEBC, 0xF572, 0xF037, 0xEB16, 0xE419, 0xDDEE, 0xD937,
    0xD7C5, 0xD296, 0xCDFE, 0xCAD3, 0xC882, 0xC855, 0xC8E5, 0xCB69, 0xCC9C, 0xCF94, 0xD90A, 0xE3D5, 0xE922, 0xECAB, 0xEF6A, 0xF305,
    0xF5F4, 0xF848, 0xF84F, 0xF74D, 0xF698, 0xF970, 0xFA0C, 0xF263, 0xEAE8, 0xE7FA, 0xE780, 0xE72C, 0xE9C8, 0xEC91, 0xEF89, 0xF3A2,
    0xF615, 0xF5D9, 0xF43E, 0xF07C, 0xED4A, 0xEB80, 0xE712, 0xE09C, 0xDA23, 0xD6DC, 0xD4FB, 0xD2F9, 0xD3E7, 0xD4EA, 0xD69C, 0xD3ED,
    0xD5CF, 0xD6D5, 0xD384, 0xD5A0, 0xD7D0, 0xDA9B, 0xD698, 0xD9D0, 0xE0E6, 0xE274, 0xE0C7, 0xDCC8, 0xDAF0, 0xD952, 0xD968, 0xD5C2,
    0xD12C, 0xCE1C, 0xD098, 0xD38D, 0xD240, 0xCE99, 0xCC5E, 0xCFDE, 0xD1D2, 0xD841, 0xDEA8, 0xE475, 0xEB9C, 0xED8E, 0xF1E6, 0xF37F,
    0xEF02, 0xE967, 0xE431, 0xE275, 0xD93F, 0xD05C, 0xC99A, 0xC2F4, 0xC07E, 0xBB30, 0xBB7D, 0xBAAD, 0xB999, 0xB953, 0xBA27, 0xB8E4,
    0xB813, 0xBBCC, 0xBC87, 0xBB3A, 0xBB8A, 0xC061, 0xC8C7, 0xCD65, 0xCF1A, 0xD184, 0xD03B, 0xD304, 0xD2E6, 0xD030, 0xCBE4, 0xC9E1,
    0xCD79, 0xCF58, 0xCE4E, 0xCB4B, 0xCB54, 0xCFF3, 0xD45D, 0xD72C, 0xDC99, 0xE07D, 0xE5CD, 0xEA10, 0xEC94, 0xEF70, 0xEEA4, 0xF0B3,
    0xF2D6, 0xF13F, 0xEFDA, 0xEBC4, 0xE82B, 0xE64E, 0xE4D8, 0xE441, 0xE45D, 0xE575, 0xE76A, 0xEADB, 0xE9F2, 0xE783, 0xE8D6, 0xEA0B,
    0xE77F, 0xE093, 0xDD1E, 0xDEBE, 0xDFA1, 0xDCFD, 0xD88D, 0xD6D2, 0xD530, 0xD403, 0xD1FD, 0xCB11, 0xC815, 0xC5C3, 0xC811, 0xC8BF,
    0xC34A, 0xC369, 0xC466, 0xCAD4, 0xD498, 0xDDCA, 0xEA97, 0xF770, 0x02E8, 0x0BEA, 0x0FC9, 0x10D1, 0x0DAD, 0x0E85, 0x0EC8, 0x0AB3,
    0x039B, 0xFDF4, 0xF7E4, 0xEEB3, 0xE7B9, 0xE2C0, 0xE000, 0xDA2A, 0xD778, 0xD774, 0xD648, 0xD389, 0xD788, 0xDAA8, 0xDA8A, 0xDD0E,
    0xE2E0, 0xEB6B, 0xF0B9, 0xF467, 0xF536, 0xF550, 0xF7A9, 0xF793, 0xF502, 0xF0A0, 0xECFE, 0xF132, 0xF411, 0xF254, 0xEC10, 0xE9C6,
    0xEADB, 0xEF01, 0xF441, 0xF7E0, 0x011C, 0x07AB, 0x0FCD, 0x16E2, 0x1AFB, 0x1B92, 0x1992, 0x1A5D, 0x191B, 0x15DC, 0x0F87, 0x0967,
    0x0665, 0x027C, 0xFFE6, 0x00F4, 0x00D4, 0x0283, 0x03E8, 0x0333, 0x02D7, 0x0465, 0x096B, 0x09CF, 0x0A3D, 0x0D9E, 0x15FB, 0x1FC8,
    0x241E, 0x28B2, 0x293F, 0x2895, 0x2CCF, 0x2D60, 0x29FC, 0x249D, 0x23E3, 0x293E, 0x2D94, 0x2F25, 0x2BB5, 0x2E15, 0x3272, 0x394E,
    0x4495, 0x4CBE, 0x566D, 0x5C69, 0x6157, 0x6398, 0x605D, 0x5B38, 0x55E7, 0x51C2, 0x4984, 0x4052, 0x36FE, 0x2D41, 0x241D, 0x1A98,
    0x1247, 0x0C99, 0x0881, 0x036E, 0x01B0, 0xFE3B, 0xFBF8, 0xFD5D, 0x0096, 0xFE60, 0xFA7F, 0x00D4, 0x05E6, 0x0D45, 0x124C, 0x151A,
    0x1928, 0x194F, 0x1CB9, 0x1B53, 0x14A9, 0x0F3D, 0x0EF3, 0x1378, 0x101F, 0x0C26, 0x0B48, 0x0E1D, 0x1237, 0x1290, 0x1704, 0x1D87,
    0x2121, 0x22C6, 0x26A2, 0x28FE, 0x252C, 0x2121, 0x2050, 0x1E7C, 0x19F2, 0x10CE, 0x0A20, 0x0611, 0xFEBF, 0xFC88, 0xFC62, 0xFC7E,
    0xFF92, 0x03BD, 0x0686, 0x06A6, 0x0962, 0x0F1A, 0x1063, 0x0D91, 0x0D53, 0x0F85, 0x13A3, 0x174B, 0x1871, 0x1759, 0x153F, 0x157B,
    0x179A, 0x15A8, 0x0F56, 0x0C38, 0x0F30, 0x14A1, 0x148E, 0x124A, 0x117F, 0x12FB, 0x1A42, 0x24A1, 0x306E, 0x38E8, 0x4117, 0x4B4B,
    0x5296, 0x5362, 0x510E, 0x51B1, 0x524C, 0x518B, 0x4E37, 0x4AFB, 0x489B, 0x4469, 0x3E82, 0x3B1B, 0x37E6, 0x3284, 0x31A3, 0x30E5,
    0x2D7D, 0x29EB, 0x2E1E, 0x3286, 0x3145, 0x3177, 0x30EA, 0x33BC, 0x398C, 0x3CCA, 0x3BA5, 0x38D5, 0x3811, 0x38E1, 0x3812, 0x2FC0,
    0x28AF, 0x28A6, 0x270A, 0x232F, 0x1D8E, 0x1647, 0x1255, 0x1052, 0x0F26, 0x143F, 0x185A, 0x1B46, 0x20AB, 0x2723, 0x2B0A, 0x28D1,
    0x2656, 0x25E6, 0x26EF, 0x2164, 0x192B, 0x15B8, 0x118A, 0x0CAF, 0x0A91, 0x0A58, 0x0A04, 0x0A16, 0x0CC0, 0x0CDD, 0x090D, 0x07B9,
    0x09B9, 0x099E, 0x0507, 0x058E, 0x082A, 0x0C49, 0x126C, 0x14FB, 0x14DE, 0x0FEE, 0x102A, 0x1030, 0x0A71, 0x0348, 0xFE53, 0x005C,
    0x0455, 0x06D9, 0x04EE, 0x03A3, 0x04F0, 0x07A9, 0x0CB1, 0x1360, 0x1A91, 0x23D1, 0x2D79, 0x35F2, 0x37CC, 0x338B, 0x3182, 0x2E00,
    0x2744, 0x1D15, 0x11E4, 0x0833, 0xFCBC, 0xF29C, 0xEC0F, 0xE418, 0xDC8B, 0xD8AE, 0xD6F2, 0xD030, 0xCB77, 0xC81B, 0xC53F, 0xC31A,
    0xBC8B, 0xBA59, 0xBA9C, 0xBE08, 0xC30F, 0xC5D1, 0xC766, 0xCAFA, 0xCFAD, 0xD464, 0xD2EA, 0xD2A5, 0xD7BC, 0xDD3F, 0xE3C4, 0xE3F7,
    0xE5DD, 0xE8A5, 0xEB10, 0xF29B, 0xFB16, 0x003E, 0x0322, 0x095C, 0x117E, 0x14B4, 0x1371, 0x1345, 0x14CD, 0x15CF, 0x12E3, 0x0F13,
    0x0D4A, 0x09F5, 0x04BE, 0x01DD, 0x0102, 0x0008, 0x0196, 0x02AB, 0x042E, 0x04C2, 0x0380, 0x05E6, 0x0523, 0x01C7, 0xFE4F, 0xFB1A,
    0xFBBE, 0xFCEB, 0xFD69, 0xF9FD, 0xF5EE, 0xF50F, 0xF683, 0xF3B1, 0xEA94, 0xE35E, 0xE020, 0xE1F9, 0xE09C, 0xDADC, 0xD703, 0xD595,
    0xD389, 0xD574, 0xDBA7, 0xDEB2, 0xE478, 0xEBD8, 0xF318, 0xF6E5, 0xF551, 0xF29C, 0xF0E3, 0xEE03, 0xE94B, 0xE5A5, 0xDF90, 0xD791,
    0xD264, 0xCE01, 0xC74D, 0xC144, 0xBE97, 0xBD05, 0xB9AE, 0xB748, 0xB864, 0xB9DF, 0xBA25, 0xB9B8, 0xB8B2, 0xB906, 0xBDAF, 0xC39D,
    0xC5F7, 0xC86B, 0xCD1F, 0xD2A0, 0xD7FE, 0xD835, 0xD533, 0xD42C, 0xD3DE, 0xD404, 0xD17B, 0xCC88, 0xC6AB, 0xC3E0, 0xC561, 0xC8BB,
    0xCABB, 0xCC64, 0xD1CE, 0xD7BA, 0xDC7E, 0xDBA1, 0xD90E, 0xD949, 0xD8BB, 0xD6FA, 0xD528, 0xD2CD, 0xCEB3, 0xCD18, 0xCB33, 0xCABD,
    0xC9C8, 0xC7E9, 0xCA99, 0xCA64, 0xC987, 0xCA25, 0xCD0E, 0xCFB3, 0xD001, 0xD058, 0xD075, 0xD36B, 0xD9B2, 0xDE3E, 0xDF8A, 0xDEDA,
    0xDE5C, 0xE293, 0xE442, 0xDE3D, 0xD739, 0xD675, 0xD86D, 0xD937, 0xD787, 0xD3C7, 0xD149, 0xD026, 0xD226, 0xD6FC, 0xDD50, 0xE409,
    0xECD4, 0xFA4F, 0x050A, 0x0918, 0x0CD7, 0x0FAB, 0x10C5, 0x0F80, 0x0AFC, 0x06E2, 0xFF89, 0xF823, 0xF1FD, 0xEB07, 0xE482, 0xE11D,
    0xDF47, 0xD8AC, 0xD167, 0xCF99, 0xCF6F, 0xCC46, 0xC8D6, 0xC615, 0xC6AB, 0xC99D, 0xD00E, 0xD743, 0xD9F3, 0xDD1B, 0xE061, 0xE600,
    0xE7CC, 0xE34B, 0xE125, 0xE119, 0xE5A1, 0xE88F, 0xE633, 0xE5A7, 0xE489, 0xE657, 0xE9F8, 0xEBDB, 0xEEF1, 0xF528, 0xFDDC, 0x03C6,
    0x06F9, 0x092C, 0x0CB9, 0x0EED, 0x0F7F, 0x0F85, 0x0DC1, 0x0A4F, 0x0533, 0x01AB, 0xFDF5, 0xF90C, 0xF747, 0xF8EB, 0xF948, 0xF63D,
    0xF4AC, 0xF229, 0xF055, 0xEF2B, 0xE990, 0xE46E, 0xE275, 0xE4DC, 0xE84E, 0xEA81, 0xE986, 0xEB90, 0xF509, 0xF96E, 0xF723, 0xF33F,
    0xF34B, 0xF67D, 0xFA15, 0xFC6A, 0xFABA, 0xF976, 0xFAA9, 0xFED5, 0x04D6, 0x0BE1, 0x154E, 0x243E, 0x33AC, 0x3EE4, 0x4606, 0x4A81,
    0x4E17, 0x50A5, 0x4DC0, 0x4A2F, 0x4792, 0x3FCF, 0x3B73, 0x3526, 0x2D82, 0x2621, 0x220F, 0x1ED3, 0x1683, 0x113D, 0x0DA2, 0x0C2D,
    0x0B06, 0x0803, 0x03E2, 0x0367, 0x0529, 0x0B5A, 0x122E, 0x1430, 0x18A8, 0x1ED8, 0x2733, 0x2C49, 0x2A93, 0x27D1, 0x2960, 0x2C12,
    0x2A3B, 0x24E5, 0x1F80, 0x1A3E, 0x138D, 0x11A9, 0x10CA, 0x0FFD, 0x1498, 0x19DC, 0x2083, 0x2384, 0x2377, 0x23B1, 0x21C5, 0x1F59,
    0x1CE1, 0x1AD8, 0x1404, 0x0C57, 0x080A, 0x02A5, 0xFBF8, 0xF7C3, 0xF69A, 0xF65A, 0xF44F, 0xF2B2, 0xF3DE, 0xF7F5, 0xFD1C, 0x0033,
    0x0394, 0x07E3, 0x113D, 0x1B49, 0x1DBE, 0x1F97, 0x21D6, 0x2674, 0x2A1F, 0x2727, 0x2233, 0x1E13, 0x1EB0, 0x1E68, 0x1D28, 0x1ACE,
    0x15E4, 0x1375, 0x1462, 0x173B, 0x1BF3, 0x20EC, 0x296D, 0x362C, 0x3FAE, 0x4538, 0x46C5, 0x4936, 0x499E, 0x46B9, 0x44A6, 0x3E66,
    0x37BF, 0x30A2, 0x2B82, 0x249A, 0x1CAD, 0x1BFB, 0x1844, 0x1354, 0x0CB0, 0x085C, 0x080A, 0x0684, 0x0403, 0x0361, 0x01E6, 0x0161,
    0x095B, 0x11C3, 0x16E4, 0x18A7, 0x1C80, 0x22BE, 0x2759, 0x24E7, 0x2063, 0x1EBA, 0x1D69, 0x1EC2, 0x1E00, 0x1B65, 0x173E, 0x1638,
    0x1713, 0x17BF, 0x1B96, 0x1E94, 0x2584, 0x2E5E, 0x353A, 0x3A97, 0x3CDC, 0x3ED6, 0x4033, 0x4043, 0x4094, 0x3BB3, 0x35D6, 0x32E6,
    0x2CCF, 0x287C, 0x2472, 0x24C1, 0x2711, 0x2592, 0x2506, 0x254C, 0x275D, 0x280F, 0x24A8, 0x1F10, 0x1A2B, 0x18F5, 0x1BD4, 0x1BCE,
    0x192F, 0x178C, 0x1838, 0x1C61, 0x1988, 0x1035, 0x08DA, 0x02D7, 0xFFF9, 0xFED8, 0xFC4B, 0xF5EF, 0xF17F, 0xEF77, 0xF009, 0xF272,
    0xF355, 0xFA7C, 0x0623, 0x10A0, 0x187D, 0x1FBC, 0x2536, 0x280B, 0x2BA5, 0x2CD3, 0x294F, 0x2537, 0x2104, 0x1AC2, 0x129E, 0x090F,
    0x0224, 0xFDA1, 0xF810, 0xF3FC, 0xEFE3, 0xEBD7, 0xE9F9, 0xE8A3, 0xE404, 0xDB7B, 0xD6CD, 0xD6D3, 0xDAA4, 0xDB46, 0xD7E1, 0xD842,
    0xDD4B, 0xE0FD, 0xDD7E, 0xD8AE, 0xD723, 0xD698, 0xD670, 0xD571, 0xD32E, 0xD0CE, 0xCED9, 0xCFD0, 0xD2E1, 0xD569, 0xD92F, 0xE220,
    0xEC5B, 0xF427, 0xF9ED, 0xFD25, 0x0060, 0x022B, 0x0246, 0x0177, 0xFD80, 0xF97F, 0xF6C7, 0xF35D, 0xEBE5, 0xE759, 0xE853, 0xE7D6,
    0xE52B, 0xE374, 0xE2F6, 0xE2F6, 0xE669, 0xE822, 0xE98D, 0xEADC, 0xF13C, 0xFA0B, 0xFFC1, 0x0352, 0x03AF, 0x0A4A, 0x10A1, 0x13D8,
    0x12E2, 0x100F, 0x1095, 0x1156, 0x1260, 0x13C7, 0x134B, 0x0F17, 0x0E38, 0x0ECC, 0x1174, 0x1464, 0x198B, 0x2492, 0x2EAF, 0x386B,
    0x3EF8, 0x42F0, 0x43FD, 0x4125, 0x3DE5, 0x382B, 0x2E36, 0x2489, 0x1A8A, 0x0DD7, 0x0364, 0xFA67, 0xF317, 0xEA9B, 0xE23A, 0xDBE9,
    0xD609, 0xD318, 0xD0C0, 0xCDF8, 0xC8DC, 0xC5A0, 0xC801, 0xCD0E, 0xCEBA, 0xCE00, 0xD2A9, 0xD988, 0xDE06, 0xE002, 0xDF9F, 0xDF75,
    0xE2FD, 0xE4FA, 0xE7A1, 0xE9F0, 0xE950, 0xE91E, 0xE9B5, 0xEA7D, 0xEB46, 0xED63, 0xF118, 0xF8A5, 0xFF03, 0x0279, 0x05B3, 0x0807,
    0x07B7, 0x075E, 0x071D, 0x03C8, 0x0052, 0xFDE8, 0xF839, 0xF202, 0xEE6C, 0xEDCD, 0xEE26, 0xED62, 0xED01, 0xED9E, 0xEFBC, 0xF0A9,
    0xF0F8, 0xEECE, 0xEBB6, 0xEC7F, 0xEFDF, 0xF49E, 0xF507, 0xF524, 0xF967, 0xFD55, 0xFF5F, 0xFD33, 0xF829, 0xF402, 0xF036, 0xEE84,
    0xEE7D, 0xE933, 0xE44A, 0xE0FB, 0xDEA1, 0xDD53, 0xDB0B, 0xDCAA, 0xE12C, 0xE872, 0xEE90, 0xF625, 0xFDEA, 0x00CD, 0x03C0, 0x08AD,
    0x0A03, 0x0903, 0x081C, 0x04DC, 0x0219, 0xFE64, 0xFAC8, 0xF965, 0xF771, 0xF5B4, 0xF298, 0xEFAB, 0xEF86, 0xEFFD, 0xEE68, 0xE8C5,
    0xE4DE, 0xE5C1, 0xE827, 0xEC5E, 0xEFE1, 0xF3B0, 0xFE5A, 0x07C3, 0x0EBD, 0x12CB, 0x1321, 0x142D, 0x13B4, 0x1569, 0x153F, 0x1073,
    0x0CDC, 0x09D0, 0x0958, 0x09F0, 0x0783, 0x0AD4, 0x0F6C, 0x13F9, 0x18E4, 0x1B92, 0x1C17, 0x1B9C, 0x1D91, 0x1CB6, 0x19F8, 0x1754,
    0x1531, 0x109F, 0x09A3, 0x032A, 0xFF17, 0xFC40, 0xF993, 0xF5C1, 0xF395, 0xF2F6, 0xF3D8, 0xF771, 0xF5BE, 0xF253, 0xF212, 0xF3AF,
    0xF705, 0xF62C, 0xF26D, 0xF28E, 0xF57F, 0xF73A, 0xF664, 0xF28F, 0xEDAB, 0xECEC, 0xEF0F, 0xF055, 0xF020, 0xED0A, 0xEA65, 0xEA59,
    0xEA67, 0xE97D, 0xEAEF, 0xF3E9, 0xFFEF, 0x0C33, 0x1927, 0x23D3, 0x299E, 0x2F86, 0x349A, 0x343F, 0x30BE, 0x2D73, 0x2AC2, 0x252E,
    0x1CF8, 0x164F, 0x11B3, 0x0C1A, 0x0591, 0xFCB6, 0xF462, 0xEE09, 0xEB21, 0xE6F9, 0xDE69, 0xD8C5, 0xD759, 0xD8E2, 0xDC2D, 0xDC44,
    0xDD22, 0xE220, 0xE5AF, 0xE917, 0xEACE, 0xE9B4, 0xEA04, 0xEB70, 0xF0F3, 0xF593, 0xF70F, 0xF5A1, 0xF33A, 0xF67F, 0xF5A9, 0xF42B,
    0xF672, 0xFB91, 0x032C, 0x09DB, 0x0E9E, 0x1301, 0x15D6, 0x18BB, 0x1A2F, 0x1935, 0x1851, 0x14C2, 0x1108, 0x0969, 0x0211, 0xFF6D,
    0xFB89, 0xF8CB, 0xF69A, 0xF29B, 0xF072, 0xEEF7, 0xEDEC, 0xEB7C, 0xE6A0, 0xE335, 0xE4FF, 0xE944, 0xEA7F, 0xEB13, 0xEF19, 0xF645,
    0xFBDA, 0xFFB5, 0xFFE8, 0xFC60, 0xF9AF, 0xF854, 0xF896, 0xF702, 0xF2C7, 0xEFDC, 0xF001, 0xEEA4, 0xEBD0, 0xECF2, 0xF035, 0xF614,
    0xFF1F, 0x09EC, 0x124B, 0x1931, 0x1F87, 0x24E6, 0x274A, 0x2560, 0x239A, 0x21C8, 0x1CEF, 0x1642, 0x10A6, 0x0B61, 0x0756, 0x0399,
    0xFC0E, 0xF662, 0xF408, 0xF22F, 0xF13B, 0xEDAA, 0xE8AA, 0xE63D, 0xE8B2, 0xEBEF, 0xEE94, 0xF26B, 0xF8F0, 0x025B, 0x0BD8, 0x1116,
    0x1271, 0x1112, 0x0F60, 0x0ED0, 0x0D62, 0x08DD, 0x01D9, 0xFD7C, 0xF989, 0xF371, 0xEF98, 0xEE12, 0xEF0E, 0xF08C, 0xF2C3, 0xF90D,
    0xFBEF, 0xFD39, 0x0044, 0x02FA, 0x0401, 0x0498, 0x0453, 0x0205, 0xFCDF, 0xF7DA, 0xF31C, 0xED35, 0xEA5C, 0xE7F9, 0xE640, 0xE6D5,
    0xE815, 0xEBF0, 0xEFCD, 0xEF73, 0xEF31, 0xF1F8, 0xF82B, 0xFCB3, 0xFFC3, 0x0437, 0x0AB8, 0x1285, 0x186D, 0x19EE, 0x197A, 0x155E,
    0x1342, 0x1435, 0x10B2, 0x0DCA, 0x09B8, 0x0615, 0x03CA, 0x01C9, 0x0214, 0x0408, 0x0836, 0x10D9, 0x1CA3, 0x2676, 0x2C0B, 0x315A,
    0x3853, 0x3B31, 0x3AB0, 0x393C, 0x357F, 0x30C7, 0x27CF, 0x1EC3, 0x16B0, 0x0E89, 0x0681, 0xFC95, 0xF3E8, 0xEC4D, 0xE72F, 0xE45F,
    0xDF9A, 0xD8A2, 0xD522, 0xD510, 0xD5B5, 0xD693, 0xD593, 0xD4DC, 0xD79D, 0xD9A8, 0xD972, 0xD71B, 0xD2E2, 0xD055, 0xD150, 0xD1D2,
    0xD1AB, 0xD0A5, 0xCFE4, 0xD0D0, 0xD02E, 0xCEE0, 0xCFCE, 0xD3AF, 0xD90D, 0xE1DB, 0xEC79, 0xF4E4, 0xFB23, 0x029A, 0x086A, 0x0A6E,
    0x0B1D, 0x0BA5, 0x0A31, 0x0729, 0x010A, 0xFCE4, 0xFADC, 0xF871, 0xF857, 0xF740, 0xF425, 0xF2F1, 0xF397, 0xF30F, 0xEF5A, 0xE91A,
    0xE7EB, 0xEA68, 0xECE8, 0xEE07, 0xF111, 0xF5CC, 0xFC0C, 0x0244, 0x04E2, 0x0341, 0xFF2D, 0xFD91, 0xFDB8, 0xFEC9, 0xFE43, 0xFC5D,
    0xFB4A, 0xFC1E, 0xFBEC, 0xFAAF, 0xF91D, 0xFC12, 0x04EE, 0x0E73, 0x17B8, 0x1FFB, 0x29C8, 0x31E3, 0x34B9, 0x378D, 0x3910, 0x3870,
    0x3666, 0x2FCC, 0x2A98, 0x23A8, 0x1C28, 0x152B, 0x0C99, 0x052D, 0xFCE0, 0xF8D6, 0xF745, 0xF40B, 0xEE58, 0xE7EB, 0xE6D9, 0xE832,
    0xE69B, 0xE749, 0xE9FF, 0xEEFD, 0xF6F9, 0xFEBE, 0x045C, 0x0614, 0x056A, 0x07F1, 0x0B91, 0x0B54, 0x0868, 0x05B2, 0x03DE, 0x0156,
    0xFEEE, 0xFC78, 0xFE68, 0x00F9, 0x07BD, 0x0F2A, 0x1323, 0x15D2, 0x1826, 0x1930, 0x1792, 0x15D2, 0x1316, 0x108A, 0x0A52, 0x0223,
    0xFB1A, 0xF314, 0xEC4F, 0xE9A4, 0xE448, 0xDEEB, 0xDCF1, 0xDF4A, 0xE223, 0xE12D, 0xDFDD, 0xE2F7, 0xE9AE, 0xEF87, 0xF2BD, 0xF603,
    0xFB43, 0x01E9, 0x0A07, 0x0E0C, 0x0F61, 0x0DDE, 0x0C27, 0x0BAF, 0x0B20, 0x0801, 0x02AC, 0x0169, 0x0000, 0xFC6C, 0xFA01, 0xF877,
    0xF942, 0xFDF7, 0x0441, 0x09CA, 0x0F05, 0x1307, 0x16AF, 0x186F, 0x1697, 0x14A6, 0x1229, 0x0C7C, 0x04BC, 0xFE4D, 0xF5C9, 0xEE8D,
    0xE98E, 0xE363, 0xDDBA, 0xD6A4, 0xD409, 0xD49D, 0xD491, 0xD180, 0xCD02, 0xCC7D, 0xCCFC, 0xCD25, 0xCC22, 0xCC2A, 0xCE68, 0xD404,
    0xD9A9, 0xDF0F, 0xE162, 0xE35A, 0xE5BE, 0xE9E5, 0xEEAE, 0xEF56, 0xF1DB, 0xF26A, 0xF2EE, 0xF543, 0xF6C9, 0xF87D, 0xFCFE, 0x03E5,
    0x1004, 0x1ABC, 0x2009, 0x2639, 0x2C20, 0x2F1A, 0x3103, 0x31C1, 0x31AA, 0x30A6, 0x2D70, 0x298E, 0x25F2, 0x2392, 0x2320, 0x231F,
    0x207F, 0x1F68, 0x218B, 0x246D, 0x2221, 0x1F5C, 0x1D83, 0x1E17, 0x1F4F, 0x1F71, 0x20B1, 0x1F64, 0x215F, 0x2338, 0x22DA, 0x1E82,
    0x1547, 0x0BEF, 0x068E, 0x0254, 0xFD6F, 0xF9CE, 0xF6C3, 0xF42E, 0xF0BD, 0xEC3D, 0xE7CA, 0xE52B, 0xE4B3, 0xE923, 0xF13E, 0xF847,
    0x00AF, 0x0970, 0x125D, 0x1AA5, 0x20B3, 0x2581, 0x270C, 0x2706, 0x23F5, 0x1F00, 0x1A4C, 0x163C, 0x1385, 0x0E57, 0x0997, 0x0546,
    0x03EC, 0x0206, 0xFC13, 0xF4B0, 0xEEB3, 0xEC20, 0xEB6A, 0xEAD5, 0xEA47, 0xED89, 0xF0E6, 0xF8ED, 0xFEA3, 0xFF18, 0xFC6E, 0xFB3C,
    0xFBEE, 0xFAA3, 0xF9FD, 0xF781, 0xF573, 0xF36E, 0xF314, 0xF307, 0xF12A, 0xEFCB, 0xF35F, 0xFA86, 0x0037, 0x02F1, 0x074E, 0x0AB2,
    0x0D1F, 0x0E86, 0x0F55, 0x0E0A, 0x0B5F, 0x08D1, 0x0340, 0xFC54, 0xF5C1, 0xF137, 0xED48, 0xE6F3, 0xDF8A, 0xDDD2, 0xDB98, 0xDA89,
    0xD7D1, 0xD44C, 0xD41E, 0xD4CC, 0xD736, 0xD924, 0xDB05, 0xDDB5, 0xE477, 0xEE24, 0xF45E, 0xF4A1, 0xF47B, 0xF65D, 0xFAC9, 0xFBA1,
    0xF9DB, 0xFA58, 0xFB4B, 0xFBCD, 0xFA39, 0xF98F, 0xFA28, 0xFE5F, 0x0747, 0x1211, 0x1E2F, 0x28EF, 0x3449, 0x3DA0, 0x42CD, 0x47BB,
    0x4885, 0x488F, 0x46AE, 0x401A, 0x3A3E, 0x315C, 0x2A56, 0x24C5, 0x1A96, 0x1048, 0x0862, 0x0525, 0x037A, 0xFD81, 0xF812, 0xF3B8,
    0xF28F, 0xF13A, 0xED77, 0xECE9, 0xEBCB, 0xEE7F, 0xF52E, 0xFB0E, 0xFF7E, 0x0014, 0x00CD, 0x0663, 0x07E8, 0x09EC, 0x0AD1, 0x0B50,
    0x0C52, 0x0985, 0x0911, 0x063D, 0x04A3, 0x0819, 0x0B86, 0x0F9D, 0x13C4, 0x1675, 0x1985, 0x17F0, 0x17D3, 0x1773, 0x15C9, 0x157B,
    0x11F7, 0x0EDA, 0x08F9, 0x02AD, 0x010D, 0xFC61, 0xF78E, 0xF30A, 0xEF9D, 0xF0C4, 0xEF48, 0xEE28, 0xEA50, 0xE917, 0xEBBF, 0xEE57,
    0xF02F, 0xF0D7, 0xF285, 0xF843, 0xFF0F, 0x02AF, 0x04C3, 0x035A, 0x04E2, 0x052F, 0x051A, 0x05DD, 0x041E, 0x0352, 0x0202, 0xFFA7,
    0xFCCC, 0xF909, 0xF6EB, 0xF90F, 0xFCC6, 0x0328, 0x0885, 0x0EF2, 0x1767, 0x1C9A, 0x2314, 0x2754, 0x2994, 0x2B20, 0x2921, 0x2755,
    0x214D, 0x1E35, 0x1CEA, 0x178A, 0x1154, 0x095C, 0x075C, 0x04DE, 0xFEFD, 0xF854, 0xF1EA, 0xEF02, 0xECF7, 0xEAA6, 0xEBC5, 0xEC86,
    0xF094, 0xF963, 0x0052, 0x0759, 0x0755, 0x0737, 0x0632, 0x032B, 0x01E0, 0xFE14, 0xFA65, 0xF512, 0xF17C, 0xEF2A, 0xE82F, 0xE31E,
    0xE15D, 0xE364, 0xE787, 0xEA9F, 0xF0E3, 0xF70F, 0xFB3F, 0xFFD8, 0x050B, 0x0836, 0x0B85, 0x0C44, 0x0A6E, 0x0522, 0x000B, 0xFBED,
    0xF5C6, 0xF1D4, 0xEC30, 0xE99D, 0xEADA, 0xEB85, 0xEC81, 0xEBE4, 0xEA9D, 0xECDB, 0xEEED, 0xF10F, 0xF399, 0xF5ED, 0xFCF2, 0x050B,
    0x0CA1, 0x1056, 0x0F27, 0x0FC1, 0x0E2D, 0x0D3D, 0x0D91, 0x0B4A, 0x0A06, 0x06E5, 0x06F8, 0x05FF, 0x0211, 0x00F3, 0x03D3, 0x0C50,
    0x1445, 0x1A89, 0x22A8, 0x2A53, 0x3036, 0x3639, 0x3802, 0x3B01, 0x3C8C, 0x3BF6, 0x396B, 0x31B4, 0x2B19, 0x248A, 0x1D71, 0x1362,
    0x0768, 0xFFC7, 0xFAAE, 0xF587, 0xF07A, 0xE7DD, 0xE1FF, 0xDF00, 0xDC97, 0xDB8E, 0xD783, 0xD54F, 0xD913, 0xDE1E, 0xE241, 0xE16C,
    0xE134, 0xE377, 0xE5B9, 0xE9DE, 0xEAB7, 0xEC18, 0xECD1, 0xEE36, 0xEFB5, 0xEE9C, 0xEDC3, 0xF0A5, 0xF751, 0x00E5, 0x0A4B, 0x12B9,
    0x1B54, 0x2283, 0x2921, 0x2C78, 0x2EF1, 0x30DD, 0x329E, 0x3171, 0x2BF3, 0x275B, 0x24A3, 0x211A, 0x1BE7, 0x1472, 0x0E60, 0x0B68,
    0x08E6, 0x0547, 0x00AD, 0xFD2A, 0xFD0E, 0xFF08, 0xFE7F, 0xFE79, 0xFDE7, 0xFFD3, 0x042F, 0x08B7, 0x0A5E, 0x09B5, 0x0AD0, 0x0930,
    0x0923, 0x07DE, 0x05E7, 0x048E, 0x00D0, 0xFFA7, 0xFD33, 0xF671, 0xF22D, 0xF11D, 0xF387, 0xF718, 0xFB42, 0x03D9, 0x0D2A, 0x15EF,
    0x1A54, 0x1C27, 0x1ED9, 0x201C, 0x20A9, 0x1C2C, 0x136E, 0x0ED1, 0x0838, 0x02A2, 0xF9C0, 0xEFBC, 0xEAD0, 0xE5C7, 0xE3A1, 0xDF09,
    0xDB0F, 0xD706, 0xD456, 0xD4CD, 0xD562, 0xD39C, 0xD2E7, 0xD868, 0xE0E4, 0xE625, 0xE869, 0xE96A, 0xE98B, 0xEC1F, 0xED81, 0xED57,
    0xEE00, 0xEE59, 0xEF54, 0xF005, 0xEC82, 0xE8BC, 0xE7D3, 0xE901, 0xEB68, 0xF0CB, 0xF5A8, 0xFDF0, 0x038A, 0x0758, 0x0DCF, 0x10F3,
    0x151E, 0x15FC, 0x174B, 0x1480, 0x0F10, 0x0AC6, 0x0648, 0x0375, 0xFDB9, 0xF7B4, 0xF682, 0xF804, 0xF83B, 0xF64D, 0xF425, 0xF546,
    0xF79B, 0xFBD5, 0x0018, 0x04A4, 0x0C64, 0x15ED, 0x20EC, 0x277E, 0x29F5, 0x2AE2, 0x2906, 0x261C, 0x21CB, 0x1E33, 0x1939, 0x141E,
    0x10F5, 0x0C6B, 0x0965, 0x05B5, 0x05AF, 0x07A0, 0x0ACB, 0x10D9, 0x1742, 0x1D86, 0x22D8, 0x2901, 0x30D4, 0x36F3, 0x3A3A, 0x3D66,
    0x3C02, 0x38CB, 0x3311, 0x2DE2, 0x28BC, 0x213E, 0x1843, 0x0FEA, 0x0CE5, 0x09E0, 0x03B5, 0xFDF1, 0xF813, 0xF433, 0xF264, 0xEDE4,
    0xEA3D, 0xE7AA, 0xE87A, 0xEB98, 0xEE9B, 0xF035, 0xF150, 0xEF8E, 0xED88, 0xED37, 0xED70, 0xEB5C, 0xE938, 0xE987, 0xE96E, 0xE9C2,
    0xE64A, 0xE54A, 0xE74A, 0xEB9C, 0xF30A, 0xFA98, 0x0256, 0x093A, 0x0F4D, 0x1419, 0x1541, 0x1577, 0x17DC, 0x1973, 0x1708, 0x12AB,
    0x0ECF, 0x0D16, 0x0AD0, 0x04AE, 0xFCD3, 0xF889, 0xF797, 0xF424, 0xF117, 0xEBC5, 0xE896, 0xE6CA, 0xE4C6, 0xE3A1, 0xE0D5, 0xDEBE,
    0xDE36, 0xE289, 0xE454, 0xE4BB, 0xE2D4, 0xE0F3, 0xE271, 0xE3CD, 0xE439, 0xE223, 0xE284, 0xE2C3, 0xE32E, 0xDE79, 0xD8D1, 0xD76B,
    0xD72B, 0xD8E3, 0xDBF6, 0xE245, 0xEA29, 0xF112, 0xF9E0, 0x0246, 0x07E1, 0x0F41, 0x15C7, 0x1A71, 0x1B30, 0x1946, 0x1A24, 0x1A4B,
    0x1512, 0x100D, 0x08FB, 0x05CD, 0x02E3, 0xFEFC, 0xFB4B, 0xF51B, 0xF299, 0xF0A5, 0xF1AC, 0xF168, 0xEF1E, 0xF336, 0xFB1D, 0x030B,
    0x0AC1, 0x0E84, 0x142C, 0x1825, 0x1B88, 0x20A4, 0x2251, 0x2435, 0x26FA, 0x281C, 0x29C2, 0x2732, 0x24A0, 0x248E, 0x2401, 0x26FD,
    0x293E, 0x2BAE, 0x2DF9, 0x3181, 0x322D, 0x3124, 0x3149, 0x310D, 0x2FE5, 0x2B47, 0x20D5, 0x18FA, 0x1305, 0x08F9, 0xFF45, 0xF43E,
    0xEBBE, 0xE84A, 0xE32B, 0xDD9A, 0xD9FA, 0xD50E, 0xD3BC, 0xD58F, 0xD725, 0xD66C, 0xD799, 0xDCA0, 0xE44B, 0xED57, 0xF196, 0xF685,
    0xFAB9, 0xFBC6, 0xFCE5, 0xFBBB, 0xF8B0, 0xF7B4, 0xF779, 0xF8E8, 0xFA05, 0xF7A6, 0xF9EE, 0xFD97, 0x0245, 0x0675, 0x0B9F, 0x1202,
    0x18AF, 0x1F87, 0x238D, 0x2673, 0x2AC8, 0x2FC1, 0x303F, 0x2CFB, 0x2724, 0x2429, 0x1F5A, 0x18A1, 0x0F30, 0x04CF, 0xFE3A, 0xF99B,
    0xF642, 0xF194, 0xEA97, 0xE6BC, 0xE369, 0xE138, 0xDE01, 0xD7F1, 0xD70A, 0xD978, 0xDEF8, 0xE450, 0xE7CD, 0xEA70, 0xED2B, 0xEE68,
    0xEFBE, 0xEE0C, 0xECB9, 0xEB6A, 0xEAAC, 0xE918, 0xE432, 0xE1D8, 0xDEB4, 0xDD87, 0xE039, 0xE31F, 0xE93D, 0xEE7E, 0xF268, 0xF6FC,
    0xF8B4, 0xFD7D, 0x02A5, 0x0630, 0x0904, 0x0980, 0x0919, 0x09AF, 0x05D0, 0x02FF, 0xFF7B, 0xFC23, 0xFC3F, 0xFAEE, 0xFC69, 0xFB70,
    0xFA36, 0xF8CB, 0xF9EB, 0xFDF3, 0xFC27, 0xFD81, 0x0222, 0x06AB, 0x0D31, 0x10BD, 0x12EE, 0x1663, 0x13D0, 0x13EB, 0x162C, 0x1276,
    0x11DD, 0x1092, 0x0ECD, 0x09AF, 0x0544, 0x0131, 0xFCC6, 0xFCBD, 0xFD60, 0x02E3, 0x09D5, 0x0DCC, 0x16A2, 0x1DE2, 0x217D, 0x2742,
    0x2C5B, 0x30DA, 0x32A1, 0x3137, 0x3019, 0x2F6A, 0x2ECA, 0x2A8A, 0x21C2, 0x1CDA, 0x1671, 0x113E, 0x08FD, 0xFE34, 0xF65C, 0xF180,
    0xEECA, 0xEB88, 0xE82A, 0xE734, 0xE8EA, 0xEBC4, 0xEFBE, 0xF25C, 0xF41A, 0xF2D0, 0xF2E1, 0xF452, 0xF357, 0xF186, 0xF013, 0xEFAC,
    0xF147, 0xECB2, 0xE7A5, 0xE425, 0xE1F8, 0xE17F, 0xE2B4, 0xE773, 0xED33, 0xF521, 0xFE5B, 0x0558, 0x0A9A, 0x10B2, 0x14DE, 0x18E1,
    0x16E3, 0x13AA, 0x11EC, 0x10A3, 0x0E46, 0x063F, 0x0076, 0xFC1D, 0xF7BB, 0xF4D5, 0xEEB6, 0xEA65, 0xE5F2, 0xE240, 0xE336, 0xE1F4,
    0xE086, 0xE3C6, 0xE87E, 0xF228, 0xFC30, 0x033C, 0x082B, 0x09CB, 0x0D7E, 0x0D4B, 0x0BE2, 0x0A71, 0x09F8, 0x0E0D, 0x0CC6, 0x0C23,
    0x0BEE, 0x07D9, 0x0A25, 0x0B51, 0x0F23, 0x16CE, 0x1D6E, 0x27A6, 0x317D, 0x35FF, 0x3C3E, 0x4125, 0x44EA, 0x4427, 0x4058, 0x3C1C,
    0x3606, 0x2EB1, 0x20E8, 0x13F7, 0x07D0, 0xFADA, 0xF3F0, 0xEC3C, 0xE3AB, 0xDF5F, 0xD85C, 0xE6A7, 0xE8C0, 0xE036, 0xDE6A, 0xD8B0,
    0xD795, 0xD645, 0xD757, 0xD765, 0xD7A7, 0xD823, 0xD738, 0xD8B5, 0xDE4C, 0xDC4C, 0xDD00, 0xDC76, 0xDAA2, 0xDA5F, 0xDD42, 0xE187,
    0xE59E, 0xEAA6, 0xEEC8, 0xF43D, 0xFAE0, 0xFFEC, 0x0378, 0x06A9, 0x0C7B, 0x1027, 0x173C, 0x186E, 0x0937, 0x07F0, 0x0561, 0x0585,
    0x040C, 0x02B4, 0x049F, 0x05C0, 0x0A6D, 0x0968, 0x0B2F, 0x081B, 0x0832, 0x0C35, 0x08D3, 0x0884, 0x0B17, 0x0CD5, 0x0E3E, 0x0E55,
    0x11F9, 0x15A0, 0x199B, 0x1CF0, 0x1D2E, 0x21BF, 0x22F8, 0x1FE5, 0x1E53, 0x176C, 0x12B4, 0x1050, 0x0BEE, 0x09B2, 0x0709, 0x056B,
    0x0303, 0x02EC, 0x0337, 0x0294, 0x03CF, 0x037F, 0x0562, 0x061C, 0x063B, 0x0366, 0x02CD, 0x01B2, 0x01E3, 0x010C, 0x0098, 0x05E7,
    0x06D7, 0x0AA1, 0x0BC5, 0x0E68, 0x1063, 0x114F, 0x117D, 0x0FBF, 0x0EE5, 0x0E24, 0x0E5C, 0x0EEB, 0x0F07, 0x0F5B, 0x136E, 0x1620,
    0x18C4, 0x1C30, 0x1EE2, 0x2305, 0x233C, 0x230F, 0x2259, 0x1E44, 0x1AA8, 0x1399, 0x0E8E, 0x072C, 0x0259, 0xFF54, 0xFDE9, 0xFCE1,
    0xFAFC, 0xF939, 0xF784, 0xF616, 0xF225, 0xF01C, 0xEC04, 0xEBFF, 0xEA82, 0xE8C5, 0xE8A2, 0xE701, 0xE919, 0xE9C9, 0xEC30, 0xEED4,
    0xF07A, 0xF25C, 0xF26B, 0xF337, 0xF24A, 0xF279, 0xF428, 0xF81A, 0xFCA0, 0x0213, 0x0547, 0x06F6, 0x0834, 0x077B, 0x07A0, 0x0371,
    0x00FF, 0xFE06, 0xFBFC, 0xFD1E, 0xFD14, 0xFE8A, 0xFFB1, 0x026D, 0x0336, 0x02BB, 0x012B, 0xFE96, 0xFD3E, 0xFB0B, 0xFA40, 0xF924,
    0xF9FA, 0xFA8E, 0xFC4C, 0xFBCC, 0xFC39, 0xFA9E, 0xF548, 0xF498, 0xF224, 0xF046, 0xEFFA, 0xF153, 0xF2E9, 0xF492, 0xF55E, 0xF638,
    0xF822, 0xF8B0, 0xF7A7, 0xF71A, 0xF55A, 0xF2BE, 0xF1B7, 0xF00F, 0xEEEE, 0xEF52, 0xEEC7, 0xF07E, 0xF1BA, 0xF108, 0xF1E3, 0xF429,
    0xF541, 0xF57D, 0xF7F5, 0xFB5B, 0xFF1F, 0x02FD, 0x0643, 0x0B37, 0x114F, 0x11A4, 0x13D9, 0x1497, 0x15F1, 0x154D, 0x129E, 0x1043,
    0x0E63, 0x0D65, 0x0AFA, 0x0BF7, 0x0C41, 0x0DCE, 0x0F8F, 0x14AA, 0x1694, 0x1B4F, 0x1E8D, 0x1FA0, 0x2098, 0x2105, 0x22AC, 0x2183,
    0x2224, 0x227E, 0x2357, 0x21BB, 0x207B, 0x1F93, 0x1FF3, 0x1EC4, 0x1EF8, 0x1E8C, 0x1D1D, 0x1BA2, 0x18C5, 0x17A2, 0x16D8, 0x1662,
    0x13D9, 0x12B4, 0x0FE6, 0x0B14, 0x0909, 0x065C, 0xFFE9, 0xFD76, 0xFE10, 0xFBEF, 0xFCB8, 0xFC8A, 0xFC81, 0xFE4E, 0xFCE7, 0xF805,
    0xF38B, 0xF081, 0xEBA9, 0xE865, 0xE225, 0xDD96, 0xDCAA, 0xDBFF, 0xDC92, 0xE01E, 0xE0D4, 0xDFDD, 0xE325, 0xE262, 0xE07A, 0xDC58,
    0xD878, 0xD659, 0xD3D7, 0xD4D9, 0xD922, 0xDA79, 0xDA18, 0xDE43, 0xE2F5, 0xE40F, 0xE3C6, 0xE311, 0xDD59, 0xD954, 0xD9B2, 0xDB7E,
    0xDD49, 0xDBE2, 0xDC10, 0xD9C6, 0xD7D1, 0xD5E6, 0xD356, 0xCF34, 0xCA9A, 0xC87B, 0xC45F, 0xC3AA, 0xC315, 0xC3A7, 0xC49A, 0xC6D4,
    0xC906, 0xCB11, 0xCF97, 0xD427, 0xDB09, 0xDEF0, 0xE34B, 0xE52B, 0xE7AD, 0xEB71, 0xED27, 0xF105, 0xF468, 0xFB6D, 0x0148, 0x0748,
    0x0C5D, 0x1117, 0x12CF, 0x1500, 0x1A88, 0x1C2C, 0x1F93, 0x20D8, 0x23A3, 0x230D, 0x226B, 0x253E, 0x26CD, 0x2459, 0x201E, 0x20DE,
    0x1D23, 0x1634, 0x12CA, 0x119E, 0x0CC8, 0x0F1B, 0x140B, 0x14D3, 0x16FA, 0x1515, 0x0E7F, 0x0780, 0x0670, 0x0343, 0x01AC, 0xFFB7,
    0xFA41, 0xF7EA, 0xF781, 0xFA70, 0xFD78, 0xFEEE, 0x0099, 0x02AF, 0x00FE, 0xFE8D, 0xFE44, 0xFBB9, 0xFAF1, 0xFB45, 0xF8D2, 0xFA10,
    0xFB4E, 0xFAF3, 0xFBB0, 0xFA27, 0xF516, 0xEFDE, 0xEDC6, 0xEBC2, 0xEA1A, 0xEBC7, 0xEB1B, 0xEC58, 0xEC9B, 0xEBD1, 0xECD3, 0xE934,
    0xEAB6, 0xED43, 0xECFA, 0xEC3E, 0xECFC, 0xED2B, 0xEB77, 0xE5FD, 0xE57D, 0xE7EA, 0xEAEB, 0xEF90, 0xF052, 0xF4F1, 0xF7B0, 0xFE35,
    0x06FB, 0x0B00, 0x0D55, 0x1313, 0x1907, 0x1787, 0x1590, 0x16D4, 0x132E, 0x124B, 0x1190, 0x0D37, 0x0C66, 0x0B5A, 0x05D0, 0x00D2,
    0xFED9, 0xFFF5, 0x0329, 0x04D8, 0x09BE, 0x0529, 0xFEE6, 0xFC7D, 0xFA62, 0xF982, 0xF639, 0xF56D, 0xF579, 0xF4D2, 0xF7CE, 0xFBE3,
    0xFDAB, 0x00F5, 0x018D, 0x025F, 0x02AB, 0x01AF, 0x0293, 0x013E, 0x01D3, 0x013C, 0x027D, 0x063E, 0x06CD, 0x0920, 0x0BDE, 0x0BE6,
    0x0A26, 0x091F, 0x0600, 0x04DE, 0x029A, 0x0202, 0x03B2, 0x0612, 0x0A0B, 0x0DF0, 0x1150, 0x1132, 0x126E, 0x128D, 0x16C9, 0x16C9,
    0x1601, 0x1630, 0x120F, 0x119E, 0x127C, 0x14F7, 0x1152, 0x0D4E, 0x0E1C, 0x0B50, 0x05F9, 0x0304, 0xFD0F, 0xF730, 0xF6E5, 0xF1DA,
    0xEF65, 0xEF64, 0xEC1E, 0xE43A, 0xDE0E, 0xDCF8, 0xDC39, 0xDE52, 0xE084, 0xE1AA, 0xDD7B, 0xDDD2, 0xDDCB, 0xE1A1, 0xE59A, 0xE6FA,
    0xEB58, 0xECB6, 0xF2FB, 0xF6B2, 0xFBAA, 0x0292, 0x070E, 0x0B0D, 0x0E63, 0x1414, 0x1CAF, 0x2029, 0x23B0, 0x29E6, 0x2CC0, 0x32DA,
    0x3413, 0x355E, 0x37D7, 0x33F0, 0x32BC, 0x2E7C, 0x2AF1, 0x26DA, 0x2542, 0x2723, 0x277B, 0x2BC0, 0x2CA7, 0x2EEC, 0x314D, 0x2F4E,
    0x2913, 0x2334, 0x1CC8, 0x1876, 0x1324, 0x0D71, 0x09A8, 0x02B5, 0x0290, 0x0500, 0x0431, 0x02A8, 0x0549, 0x077D, 0x0526, 0x0416,
    0x00D2, 0xFE30, 0xFDBF, 0xFDF7, 0xFE13, 0xFFC4, 0x03B5, 0x01D2, 0xFE01, 0xF862, 0xF591, 0xF267, 0xF228, 0xF22D, 0xEC03, 0xEC03,
    0xEA3D, 0xEB4B, 0xEDA4, 0xEFE2, 0xF304, 0xF359, 0xF4B6, 0xF69A, 0xF6AB, 0xF299, 0xF2BE, 0xF1FF, 0xF1A1, 0xEE3E, 0xEDDD, 0xF01E,
    0xEF49, 0xF16F, 0xEEDD, 0xF2BE, 0xF434, 0xF5AF, 0xFC15, 0x0170, 0x0870, 0x0D50, 0x12F0, 0x15F1, 0x19F0, 0x1BEA, 0x1DE8, 0x2345,
    0x270D, 0x2B40, 0x2D10, 0x2F53, 0x2F09, 0x2D6A, 0x2AB3, 0x29B3, 0x28DB, 0x27EC, 0x2AC8, 0x26C1, 0x2075, 0x1B7B, 0x171D, 0x0F7B,
    0x097E, 0x0557, 0x0192, 0x0230, 0x0358, 0x0065, 0xFFEC, 0xFF7E, 0xFA66, 0xF8F7, 0xF633, 0xF16E, 0xE9CF, 0xE269, 0xDFBD, 0xDBF5,
    0xDCD4, 0xE1D4, 0xE218, 0xE22C, 0xDF60, 0xDE96, 0xDD40, 0xDD21, 0xE10A, 0xE0D8, 0xE2FA, 0xE68A, 0xE9ED, 0xEFC9, 0xF327, 0xF60D,
    0xF946, 0xFA19, 0xFD40, 0xFE22, 0xFEB9, 0x0152, 0xFE9B, 0xFE95, 0xFF12, 0xFD9A, 0xFF6B, 0xFDF0, 0xFF04, 0xFF14, 0xFE05, 0xFC1C,
    0xFD0E, 0xFF70, 0x00AB, 0x0434, 0x07B1, 0x0C4B, 0x1058, 0x1423, 0x1286, 0x112C, 0x0CEA, 0x0AB4, 0x0BA0, 0x0B2C, 0x1003, 0x1091,
    0x0D3D, 0x0ECC, 0x120E, 0x11CE, 0x1311, 0x160E, 0x16B6, 0x18AE, 0x1A53, 0x17FA, 0x1680, 0x17C8, 0x1309, 0x1024, 0x0FD0, 0x0EB4,
    0x0DF7, 0x0895, 0x0517, 0x0272, 0x02E1, 0x06A4, 0x0947, 0x07EF, 0x02A9, 0xFAEC, 0xF45E, 0xF009, 0xEEEA, 0xEE24, 0xEFCC, 0xF550,
    0xFB03, 0x021E, 0x0943, 0x0FC4, 0x137C, 0x1616, 0x1750, 0x17B3, 0x173D, 0x16AC, 0x154B, 0x1588, 0x1542, 0x1391, 0x140E, 0x123C,
    0x1176, 0x1030, 0x0DC3, 0x0D2A, 0x0A41, 0x09AA, 0x081B, 0x07DF, 0x08E5, 0x096B, 0x0BF9, 0x0EDE, 0x0F0D, 0x0D72, 0x0AA1, 0x066D,
    0x04A4, 0xFD62, 0xFCCF, 0xFB67, 0xF56F, 0xF22D, 0xF051, 0xF23B, 0xF11E, 0xF45A, 0xF4F5, 0xF409, 0xF7D2, 0xF554, 0xF1E6, 0xEEB7,
    0xE8DD, 0xE299, 0xDCCD, 0xD83C, 0xD47A, 0xCE8E, 0xC806, 0xC264, 0xBD8F, 0xBE3B, 0xBF1B, 0xC0CB, 0xC16A, 0xC316, 0xC5BF, 0xC7CF,
    0xCFFA, 0xD63F, 0xDBE2, 0xE0E1, 0xE5D1, 0xEBBE, 0xF001, 0xF324, 0xF521, 0xF825, 0xF807, 0xFAB4, 0xFC13, 0xFF13, 0x02AE, 0x0508,
    0x0A8E, 0x0B25, 0x0CBE, 0x0B17, 0x0C18, 0x0AF9, 0x08C3, 0x0A2F, 0x0B13, 0x0CB6, 0x0D37, 0x10C8, 0x1443, 0x1857, 0x192E, 0x1C2B,
    0x1DFE, 0x1DE7, 0x1C44, 0x16EA, 0x16E9, 0x11B5, 0x140C, 0x1902, 0x19E0, 0x1AB8, 0x1B0C, 0x1EE9, 0x1F44, 0x2303, 0x242D, 0x26E6,
    0x2A45, 0x2CCB, 0x2ACB, 0x2A4A, 0x2B92, 0x27C7, 0x265D, 0x2400, 0x25CE, 0x24C1, 0x23BB, 0x2055, 0x19E4, 0x168A, 0x1509, 0x16C3,
    0x1401, 0x0FCB, 0x0AF9, 0x043E, 0xFE73, 0xF940, 0xF5D0, 0xF468, 0xF22E, 0xEF3A, 0xEE0B, 0xEA3A, 0xE69A, 0xE19F, 0xDD66, 0xD840,
    0xD235, 0xD0D0, 0xCE12, 0xCE15, 0xCD31, 0xCC03, 0xCDE2, 0xCFD9, 0xD1E8, 0xD4CC, 0xD8F4, 0xDF4B, 0xE3C0, 0xE66A, 0xEADD, 0xECD3,
    0xF163, 0xF5E5, 0xFA5F, 0xFF7E, 0x0410, 0x0C6C, 0x0F82, 0x1294, 0x1525, 0x14F9, 0x1725, 0x1D56, 0x21D0, 0x2135, 0x2072, 0x1E54,
    0x1C0F, 0x193F, 0x1890, 0x1459, 0x14DF, 0x18AB, 0x1AC9, 0x1DF3, 0x2066, 0x229B, 0x20F2, 0x1F57, 0x1C6D, 0x1A7A, 0x15EB, 0x101B,
    0x0943, 0x023C, 0xFFE1, 0xFFAC, 0x03A1, 0x02C4, 0x0060, 0xFAD4, 0xF598, 0xF2F2, 0xEDB4, 0xEC98, 0xEA75, 0xEB66, 0xE987, 0xEA2A,
    0xEC06, 0xEC66, 0xEBFB, 0xEAAC, 0xEB33, 0xE9E2, 0xE888, 0xE499, 0xE62C, 0xE2D2, 0xDF61, 0xDD9D, 0xDB3B, 0xDB8B, 0xD8D5, 0xDA4F,
    0xDABB, 0xDC80, 0xDDAF, 0xDD42, 0xDDC8, 0xDD5D, 0xDD8C, 0xDBE2, 0xDCC7, 0xDE6B, 0xE04E, 0xDE0A, 0xDF09, 0xDE91, 0xDBD9, 0xDF56,
    0xE30F, 0xE8D4, 0xE9C0, 0xEE83, 0xF2EA, 0xF9C2, 0x0263, 0x0968, 0x1290, 0x198A, 0x20AD, 0x21DF, 0x24FF, 0x251B, 0x2178, 0x1D78,
    0x1A1F, 0x1976, 0x197D, 0x1C74, 0x1A3C, 0x196A, 0x172A, 0x1A58, 0x1F53, 0x2055, 0x2126, 0x1BAA, 0x184A, 0x12BA, 0x1183, 0x0FBA,
    0x0FE3, 0x143D, 0x159D, 0x1823, 0x1893, 0x18CB, 0x1651, 0x13C2, 0x0DDD, 0x0AE8, 0x08A1, 0x0482, 0x0548, 0x041D, 0x05B0, 0x04EF,
    0x04AA, 0x0280, 0xFFEA, 0xFE39, 0xFAAB, 0xFAD1, 0xFA4C, 0xFA6E, 0xF8C4, 0xFA90, 0xFC7B, 0xFF63, 0x00EC, 0x0646, 0x0D4A, 0x0FD9,
    0x14A4, 0x1795, 0x17F2, 0x1733, 0x1AAA, 0x1CD1, 0x1D9E, 0x1CCC, 0x195F, 0x1682, 0x1599, 0x150C, 0x1360, 0x1548, 0x1658, 0x14F3,
    0x11FC, 0x0FD1, 0x0A3B, 0x0095, 0xFA5A, 0xF220, 0xED31, 0xE88D, 0xE42F, 0xE00A, 0xDAA8, 0xD7DE, 0xD6B9, 0xD8FE, 0xD89F, 0xD8CC,
    0xD768, 0xD690, 0xD656, 0xD81C, 0xDAF5, 0xDDBE, 0xE0FA, 0xE1BB, 0xE719, 0xE952, 0xEC69, 0xF134, 0xF558, 0xFC0C, 0x0278, 0x08AB,
    0x0E98, 0x1704, 0x1A41, 0x2026, 0x21C0, 0x1F1B, 0x1B7B, 0x1747, 0x141A, 0x1017, 0x1309, 0x10D7, 0x135B, 0x1402, 0x175F, 0x1D1D,
    0x1E09, 0x2127, 0x2250, 0x24C2, 0x20CD, 0x1C14, 0x15DA, 0x0EAD, 0x0AA7, 0x0637, 0x042C, 0x0408, 0x0307, 0xFCF1, 0xF3FF, 0xEE30,
    0xECF1, 0xE9A2, 0xE32E, 0xE0EA, 0xDE4D, 0xE179, 0xE3D8, 0xE095, 0xDB74, 0xD645, 0xD531, 0xD40B, 0xD424, 0xD4C9, 0xD47B, 0xD0C2,
    0xCEE0, 0xCF16, 0xD27C, 0xD354, 0xD1F6, 0xCFC7, 0xCDEE, 0xCECD, 0xCD18, 0xCDDB, 0xCED6, 0xD1C0, 0xD409, 0xD758, 0xDBDA, 0xDDBC,
    0xE046, 0xE206, 0xE6BD, 0xE6D6, 0xE94E, 0xEC62, 0xEE86, 0xF337, 0xF64E, 0xFBDE, 0xFB68, 0x003E, 0x05F3, 0x0FD2, 0x19BF, 0x2237,
    0x2B6F, 0x2F68, 0x3186, 0x3392, 0x37DE, 0x3755, 0x38BD, 0x398E, 0x3FDD, 0x41A8, 0x4205, 0x3C00, 0x384F, 0x39E4, 0x354E, 0x3499,
    0x2B5B, 0x2519, 0x1BFB, 0x14AF, 0x11D5, 0x10BC, 0x0D95, 0x0892, 0x06B1, 0x0383, 0x0351, 0xFD64, 0xF42B, 0xE974, 0xE162, 0xDAC4,
    0xD878, 0xD89D, 0xD99F, 0xD790, 0xD422, 0xD231, 0xD4D0, 0xD4D8, 0xDBCF, 0xEF47, 0xEC27, 0xE924, 0xE815, 0xE00C, 0xDE30, 0xDD18,
    0xDA80, 0xDA70, 0xD36E, 0xC6E8, 0xC88C, 0xC99E, 0xB22F, 0xAEB9, 0xBF59, 0xBED9, 0xC4A2, 0xC9F6, 0xCF4A, 0xCFBD, 0xD170, 0xD527,
    0xD8AB, 0xDFB4, 0xDA64, 0xDEA6, 0xEB2F, 0xF273, 0xF9FC, 0x0088, 0x0B80, 0x0824, 0xF45C, 0xF2DB, 0xF65F, 0xFE23, 0x021C, 0xFFAB,
    0xFE9D, 0xF880, 0xF9C8, 0x005F, 0x0B51, 0x0B18, 0x1485, 0x2FBE, 0x437D, 0x4250, 0x3AEB, 0x38C2, 0x3062, 0x24D5, 0x1CEC, 0x17A0,
    0xFF33, 0xEB23, 0xE7E5, 0xD32F, 0xBF24, 0xC23D, 0xC70C, 0xC8C4, 0xC94B, 0xCF91, 0xD130, 0xCF7C, 0xD325, 0xD594, 0xD8BB, 0xD5CF,
    0xD42D, 0xD709, 0xDEEF, 0xEB86, 0xEFA4, 0x01CA, 0x08DC, 0xFAE8, 0xF733, 0xF74C, 0x00C7, 0x010C, 0x060C, 0x0911, 0x09B3, 0x093F,
    0x0AC0, 0x1CF0, 0x2687, 0x291C, 0x3A86, 0x55AE, 0x5AE5, 0x556B, 0x51CD, 0x512B, 0x4BB5, 0x459E, 0x46D4, 0x3FB8, 0x303B, 0x3229,
    0x2BCA, 0x18D8, 0x150D, 0x15F5, 0x1272, 0x0935, 0x0B5B, 0x0C6A, 0x05FD, 0x0157, 0x0080, 0xFF51, 0xFC86, 0xFCD1, 0xFA86, 0xFB81,
    0x0440, 0xFD39, 0x0113, 0x0766, 0xF98C, 0xE7EE, 0xD661, 0xD2C4, 0xCC53, 0xCA0B, 0xC92E, 0xC906, 0xC607, 0xBFB0, 0xC54F, 0xCCCA,
    0xD047, 0xDD0A, 0xFBED, 0x1666, 0x21CC, 0x229A, 0x23C4, 0x2403, 0x1E87, 0x237E, 0x2298, 0x10E3, 0x0D73, 0x0F94, 0x00CD, 0xF4CC,
    0xF2E6, 0xF4E3, 0xF4B4, 0xF63A, 0xFE20, 0xFE28, 0xFF6B, 0xFD85, 0x00A4, 0x0276, 0x01DC, 0x0240, 0x01B4, 0x1205, 0x1617, 0x1E3D,
    0x2B0A, 0x2D7D, 0x2726, 0x1BA0, 0x1957, 0x1962, 0x1D9E, 0x2234, 0x26DA, 0x22D7, 0x1CC8, 0x205F, 0x2D33, 0x32BE, 0x325A, 0x42D1,
    0x556B, 0x6160, 0x5D78, 0x5B8F, 0x5A7F, 0x4B7C, 0x470B, 0x42ED, 0x30F1, 0x2182, 0x19D2, 0x07A3, 0xEDBD, 0xDBC4, 0xD75E, 0xD2F2,
    0xCED4, 0xD0B9, 0xCEFA, 0xCC33, 0xC797, 0xCAC0, 0xCC18, 0xCBCA, 0xCC57, 0xC6DD, 0xCEA0, 0xCDE4, 0xCCA3, 0xD595, 0xDA59, 0xD6E3,
    0xC997, 0xC45D, 0xC124, 0xC12D, 0xC017, 0xC319, 0xC65F, 0xC417, 0xC288, 0xCAD5, 0xD567, 0xD588, 0xDF42, 0xF4C6, 0x0F63, 0x1A9C,
    0x2094, 0x29A6, 0x2CBA, 0x2D58, 0x3764, 0x34AD, 0x2A0B, 0x2D48, 0x2ACF, 0x2383, 0x185F, 0x1C3E, 0x1F35, 0x1CB8, 0x2049, 0x23ED,
    0x2889, 0x24A4, 0x265E, 0x25AC, 0x23E4, 0x25B5, 0x1EED, 0x2465, 0x2DCB, 0x318A, 0x3865, 0x430C, 0x494A, 0x4547, 0x3C46, 0x3354,
    0x2C95, 0x2410, 0x205A, 0x2153, 0x20BC, 0x17F3, 0x1862, 0x1FFF, 0x1E9F, 0x1EC7, 0x293A, 0x3DF6, 0x4983, 0x4581, 0x42DA, 0x3AF1,
    0x2913, 0x26DD, 0x2334, 0x14F4, 0x0D8C, 0x0898, 0x018A, 0xF2C4, 0xE800, 0xE2B0, 0xDD1B, 0xDBD4, 0xD9E4, 0xDC31, 0xD810, 0xD76D,
    0xD76D, 0xD670, 0xDD86, 0xDC01, 0xDD93, 0xE512, 0xECB8, 0xF102, 0xFDEB, 0x07C2, 0x0954, 0x0576, 0xFED2, 0xFCD9, 0xFDA2, 0x0191,
    0x0790, 0x1026, 0x08E4, 0x0479, 0x0B24, 0x0F55, 0x0ECF, 0x13DA, 0x254B, 0x3BA5, 0x4617, 0x4BF0, 0x537A, 0x4ACF, 0x4A1B, 0x4959,
    0x3D3C, 0x2F9E, 0x2719, 0x2167, 0x0DC7, 0xFAF1, 0xEE15, 0xE579, 0xDEFA, 0xDD44, 0xE1C4, 0xDF9F, 0xDCBE, 0xDA9C, 0xDB2B, 0xE089,
    0xE28F, 0xDF9D, 0xE2CD, 0xE45D, 0xDFDE, 0xE4F2, 0xECD9, 0xF076, 0xEFD8, 0xE88B, 0xE1DF, 0xDED4, 0xDC57, 0xDCBE, 0xE387, 0xE454,
    0xDF08, 0xE082, 0xE7D6, 0xED44, 0xEEC4, 0xFA2F, 0x1172, 0x24D0, 0x2D35, 0x3689, 0x3391, 0x2BDB, 0x305D, 0x303A, 0x25E7, 0x1F13,
    0x2135, 0x1AF1, 0x1052, 0x0836, 0x0676, 0x0728, 0x0449, 0x053E, 0x059D, 0x0521, 0x048B, 0x0233, 0x06F4, 0x09D9, 0x0741, 0x0665,
    0x0AC7, 0x0D2E, 0x0AA2, 0x0EF5, 0x1165, 0x0E04, 0x0428, 0xF716, 0xECAD, 0xE083, 0xD6A8, 0xD34B, 0xD3DA, 0xCE95, 0xCAD3, 0xD14A,
    0xD313, 0xCF55, 0xCFA4, 0xE2B5, 0xF952, 0x07C1, 0x17E5, 0x1E4D, 0x175A, 0x143B, 0x17DB, 0x1146, 0x0798, 0x03F1, 0x0351, 0xFBD3,
    0xF2B0, 0xEDF7, 0xEC29, 0xEA66, 0xEDB7, 0xF32F, 0xF55F, 0xF95A, 0xF5F3, 0xF710, 0xFA48, 0xFA4F, 0xF749, 0xF793, 0xFB92, 0xFB87,
    0x05A9, 0x140B, 0x20AF, 0x26DF, 0x22B1, 0x1F2D, 0x1CB3, 0x172A, 0x1700, 0x21A0, 0x2397, 0x1D27, 0x1E10, 0x2404, 0x26AC, 0x234B,
    0x2C9D, 0x3D1B, 0x484F, 0x4F40, 0x538A, 0x4CBC, 0x4275, 0x4325, 0x3D3A, 0x308E, 0x27D7, 0x242E, 0x1C48, 0x0D6B, 0xFD32, 0xEDCC,
    0xDD0E, 0xD49F, 0xD0ED, 0xCC2C, 0xCAB2, 0xC158, 0xBC9C, 0xBE0C, 0xBEEA, 0xBEA9, 0xBEBB, 0xC283, 0xBF2E, 0xBD30, 0xBF83, 0xC559,
    0xCB66, 0xC8CF, 0xC5EB, 0xC56E, 0xC470, 0xC2A2, 0xC93D, 0xCBA8, 0xCB77, 0xC929, 0xCADB, 0xD35F, 0xCDB8, 0xD044, 0xDE62, 0xEF57,
    0x00E9, 0x1535, 0x1FC6, 0x1B89, 0x2093, 0x2A69, 0x29C1, 0x2396, 0x21ED, 0x2277, 0x1FC4, 0x1764, 0x13C5, 0x1118, 0x11D4, 0x16E5,
    0x169B, 0x1AC2, 0x185F, 0x1419, 0x142A, 0x14EF, 0x1319, 0x0B69, 0x0AFD, 0x08D2, 0x0656, 0x08C5, 0x0E4C, 0x156C, 0x1419, 0x0C1A,
    0x04EA, 0xFAA8, 0xEEBC, 0xE947, 0xE63B, 0xE1A7, 0xD9D6, 0xD88C, 0xE174, 0xDFF5, 0xDA56, 0xE147, 0xEE36, 0xFDC7, 0x116D, 0x2157,
    0x1EA1, 0x1586, 0x13E2, 0x0F25, 0x03E0, 0xFB6D, 0xF9CA, 0xF90D, 0xEFF8, 0xEB92, 0xE83F, 0xE320, 0xE357, 0xE218, 0xE6AF, 0xE9B1,
    0xE77D, 0xE661, 0xEBF2, 0xEF82, 0xF033, 0xF400, 0xF960, 0xF8DE, 0xF681, 0xFDBC, 0x07AE, 0x1149, 0x0D7E, 0x08F7, 0x0943, 0xFF83,
    0xFA36, 0xFB78, 0x024A, 0x035B, 0xFC6F, 0x0021, 0x0270, 0xF9A1, 0xF64A, 0xFB3C, 0x03DD, 0x1393, 0x2397, 0x2935, 0x20A5, 0x22B8,
    0x2489, 0x1C1B, 0x1264, 0x0748, 0x04C7, 0xFC21, 0xF55C, 0xEDC5, 0xE250, 0xD9E8, 0xD35F, 0xD4BC, 0xD8EA, 0xD8B5, 0xD18C, 0xCFA4,
    0xD26D, 0xD153, 0xD0B7, 0xD4F8, 0xD9C7, 0xD838, 0xD8F9, 0xDF33, 0xEC4E, 0xF3FB, 0xF349, 0xF80F, 0xF550, 0xF20D, 0xF2C5, 0xF9A0,
    0x00EE, 0xFD2F, 0x002C, 0x0B6C, 0x0EAB, 0x0C10, 0x10EE, 0x1885, 0x249F, 0x3697, 0x4596, 0x43F2, 0x3EA6, 0x4005, 0x3F3B, 0x3B65,
    0x354D, 0x3713, 0x3459, 0x2F6B, 0x293E, 0x1E58, 0x1478, 0x0C5B, 0x069E, 0x027A, 0x00CD, 0xF724, 0xF07E, 0xEF0C, 0xEC42, 0xE95B,
    0xE7A7, 0xE6DC, 0xDF74, 0xDB0E, 0xDAA7, 0xE19C, 0xE807, 0xE4DD, 0xE4E4, 0xE1F2, 0xDAC9, 0xD398, 0xCF62, 0xCC27, 0xC124, 0xB795,
    0xB8F6, 0xB99D, 0xB500, 0xB2C7, 0xB4D0, 0xBC13, 0xCA60, 0xE0D2, 0xEE51, 0xEFC1, 0xF48F, 0xF720, 0xF3A0, 0xECBB, 0xEC84, 0xEECD,
    0xEC06, 0xEC81, 0xEC1D, 0xEAB9, 0xE779, 0xE59A, 0xE8C1, 0xEF4A, 0xEE1F, 0xEB7B, 0xEE50, 0xEE5A, 0xEF29, 0xEE86, 0xF404, 0xF880,
    0xF716, 0xF60D, 0xFD5D, 0x0E44, 0x1889, 0x1E76, 0x2341, 0x24A2, 0x2007, 0x1CFB, 0x2325, 0x27A6, 0x24E9, 0x272C, 0x2FFE, 0x2F45,
    0x2C5D, 0x2D68, 0x2FBA, 0x38F7, 0x4A91, 0x5919, 0x58F0, 0x5398, 0x5269, 0x4FA9, 0x46EF, 0x3EEF, 0x37B8, 0x3142, 0x28E8, 0x1ED8,
    0x1382, 0x051C, 0xF498, 0xE623, 0xE191, 0xDE5A, 0xD7C7, 0xD368, 0xD103, 0xCEAC, 0xCC6B, 0xCEFC, 0xD48E, 0xD58B, 0xD2DD, 0xD1CA,
    0xD7C5, 0xDBCD, 0xDCEB, 0xDEEB, 0xDD5D, 0xD784, 0xD199, 0xD390, 0xD7A7, 0xD2CA, 0xD045, 0xD600, 0xD8E3, 0xD5B1, 0xD47B, 0xD6E6,
    0xDABA, 0xE87E, 0xFD79, 0x1020, 0x1493, 0x17FC, 0x1D41, 0x1B61, 0x1B40, 0x18D8, 0x1737, 0x174B, 0x16A5, 0x1314, 0x0D09, 0x08E4,
    0x05E1, 0x07A7, 0x0C7B, 0x0CED, 0x0B79, 0x0AF6, 0x09C4, 0x0A5C, 0x0B2F, 0x0E1A, 0x11ED, 0x0D8E, 0x0996, 0x0E28, 0x1813, 0x1F71,
    0x22D5, 0x2349, 0x1CF7, 0x11F3, 0x099B, 0x0A20, 0x04BC, 0xF7E1, 0xF295, 0xF380, 0xF009, 0xEC64, 0xE864, 0xE0B5, 0xE2D5, 0xEFF2,
    0x020D, 0x0795, 0x0823, 0x09F7, 0x046C, 0xFE4C, 0xF501, 0xF0C1, 0xEE60, 0xE9EB, 0xE5C6, 0xE076, 0xD9D2, 0xCFAA, 0xC869, 0xC67E,
    0xC659, 0xC2A7, 0xC066, 0xBF48, 0xC000, 0xC045, 0xBECA, 0xC569, 0xC782, 0xC568, 0xC524, 0xCA60, 0xD693, 0xE097, 0xE96C, 0xF092,
    0xF0D5, 0xEC64, 0xEFFD, 0xF305, 0xEF54, 0xECC6, 0xF23F, 0xF44C, 0xF366, 0xF75E, 0xF45F, 0xF7ED, 0x0633, 0x2089, 0x357D, 0x3BD2,
    0x4310, 0x4746, 0x4A12, 0x48C1, 0x4864, 0x4727, 0x448E, 0x41D6, 0x3F10, 0x3BA8, 0x31AF, 0x256F, 0x1B48, 0x178A, 0x0F15, 0x093A,
    0x056F, 0x0182, 0xFDC0, 0xF7D1, 0xFA62, 0xFD5D, 0xFB9A, 0xF693, 0xF666, 0xFA33, 0xFD57, 0xFE95, 0x01C8, 0xFE78, 0xF103, 0xEBCB,
    0xED1D, 0xEB52, 0xE365, 0xE1B9, 0xE426, 0xE30F, 0xE4CA, 0xE24C, 0xE086, 0xE357, 0xF1F7, 0x07E0, 0x145E, 0x1D02, 0x2309, 0x2374,
    0x20E0, 0x2067, 0x20C1, 0x2054, 0x1E6F, 0x1D3F, 0x1D44, 0x17D4, 0x0CC9, 0x0529, 0x07D9, 0x0A42, 0x0963, 0x0996, 0x09E2, 0x0D33,
    0x09FE, 0x0A87, 0x10A9, 0x107A, 0x0AC7, 0x037E, 0x03A7, 0x08AF, 0x0A2A, 0x0BCF, 0x0E07, 0x0365, 0xF625, 0xEFA2, 0xEE11, 0xE4A2,
    0xDA2C, 0xD417, 0xCD5F, 0xCD1C, 0xCB0A, 0xC801, 0xC35C, 0xC7CA, 0xD59F, 0xE16A, 0xE9BF, 0xF03A, 0xF512, 0xF4EC, 0xF12A, 0xE973,
    0xE5B7, 0xE24E, 0xDD14, 0xDA57, 0xD85C, 0xD3F9, 0xCCEE, 0xCCC7, 0xCFD6, 0xD2F3, 0xD5C5, 0xD855, 0xDCF5, 0xDF63, 0xDF75, 0xE36F,
    0xEAF5, 0xEE5E, 0xEEB1, 0xEF9A, 0xF77C, 0x0034, 0x0A11, 0x1702, 0x19F1, 0x14DD, 0x1442, 0x1914, 0x1711, 0x1477, 0x1750, 0x1C85,
    0x22C2, 0x27A2, 0x2B27, 0x274A, 0x262D, 0x305B, 0x4078, 0x4B02, 0x5112, 0x5471, 0x5190, 0x4F46, 0x4B5F, 0x4851, 0x43CF, 0x3CA0,
    0x3450, 0x2D84, 0x238F, 0x120D, 0x01B3, 0xF2AF, 0xE607, 0xDD82, 0xD895, 0xD482, 0xD029, 0xCAB6, 0xC862, 0xC980, 0xCA42, 0xC934,
    0xC834, 0xCCB9, 0xCFC0, 0xD3F6, 0xDC5D, 0xE35D, 0xE067, 0xDA53, 0xDC63, 0xDC11, 0xD712, 0xD3D1, 0xD3E0, 0xD43A, 0xD6A6, 0xDA80,
    0xDA6F, 0xD7F7, 0xDD73, 0xED75, 0xFE38, 0x0CA0, 0x1972, 0x2174, 0x22EB, 0x215D, 0x1F1D, 0x1FC3, 0x1EDB, 0x1DD7, 0x1F67, 0x20E8,
    0x1BC2, 0x1365, 0x0EE2, 0x0D06, 0x0E92, 0x0FD2, 0x133A, 0x168B, 0x15B9, 0x1322, 0x1765, 0x1D74, 0x1ECE, 0x1B68, 0x1771, 0x194A,
    0x1986, 0x1F0E, 0x27C6, 0x285E, 0x1C7B, 0x1567, 0x14F7, 0x0ECA, 0x0761, 0x0036, 0xFA8D, 0xF25F, 0xF0AF, 0xEED0, 0xE5D9, 0xDE17,
    0xE044, 0xEB98, 0xF6C0, 0x016F, 0x08FD, 0x0F37, 0x10AC, 0x0D38, 0x0908, 0x066D, 0x013B, 0xFC9F, 0xFC78, 0xF600, 0xED2A, 0xE596,
    0xDFDD, 0xDCC1, 0xDBE7, 0xDBBA, 0xDE63, 0xDFD0, 0xDEE3, 0xE0DE, 0xE40D, 0xE965, 0xE8B1, 0xE82C, 0xE898, 0xE8C5, 0xEB40, 0xF595,
    0x01C5, 0xFFEE, 0xFEDC, 0x00D7, 0x0234, 0xFCC4, 0xF840, 0xF67B, 0xF41D, 0xF7C5, 0xFC71, 0xFBE0, 0xF4E1, 0xF616, 0xFEC5, 0x0BD1,
    0x1A12, 0x22CE, 0x27DD, 0x2759, 0x225C, 0x1C84, 0x18DA, 0x1459, 0x0D21, 0x0970, 0x04CB, 0xFE69, 0xF711, 0xEEB3, 0xE9D7, 0xE464,
    0xDFAB, 0xDF0D, 0xE0A5, 0xDEC9, 0xDC3A, 0xDA3B, 0xDD31, 0xE0C5, 0xDEAC, 0xE12C, 0xE4C1, 0xE7C0, 0xED94, 0xF9BA, 0xFEBB, 0xFAAD,
    0xF9D5, 0xF93E, 0xFB56, 0xFCA7, 0x0071, 0x00D2, 0x05C7, 0x1316, 0x194D, 0x167C, 0x108A, 0x15BC, 0x1EBE, 0x28C2, 0x30F5, 0x3A41,
    0x4100, 0x40A7, 0x3F0B, 0x3DB0, 0x3D95, 0x3919, 0x378B, 0x361B, 0x32BE, 0x28E1, 0x1C35, 0x14DB, 0x0F21, 0x0A88, 0x0994, 0x0BFB,
    0x0BCF, 0x0915, 0x02B7, 0x017D, 0x0095, 0xFC0C, 0xF62E, 0xF249, 0xEDB1, 0xEB70, 0xF6A1, 0xFF92, 0x01CD, 0xFDDF, 0xFBAE, 0xF771,
    0xF249, 0xEE29, 0xE642, 0xDE12, 0xD798, 0xDAB9, 0xD611, 0xCEC9, 0xCD2F, 0xD124, 0xD882, 0xDF80, 0xE9FF, 0xF3BC, 0xFEA8, 0x01E1,
    0x0512, 0x097B, 0x0B16, 0x0B7C, 0x0DAA, 0x11D6, 0x0DA7, 0x096C, 0x0381, 0x0108, 0xFEA6, 0xFC67, 0xFEA0, 0xFF53, 0x0025, 0xFD37,
    0xFF2B, 0x02BA, 0x03E3, 0x039C, 0x06B6, 0x09B9, 0x05F1, 0x0B97, 0x18EA, 0x1FDD, 0x1DD0, 0x1B48, 0x1CA4, 0x1AE4, 0x194D, 0x1749,
    0x131E, 0x1336, 0x194F, 0x1FD4, 0x1C2E, 0x1652, 0x14F8, 0x186B, 0x20ED, 0x2AA4, 0x34B7, 0x3BEC, 0x3D68, 0x3884, 0x3655, 0x31BA,
    0x2B42, 0x2658, 0x1FF2, 0x1A48, 0x102F, 0x0448, 0xF9E4, 0xF061, 0xE54B, 0xDBD3, 0xD741, 0xD2E3, 0xCDCE, 0xC769, 0xC3CE, 0xC390,
    0xBE58, 0xBBAF, 0xBD5B, 0xBC82, 0xBCEA, 0xC38A, 0xCCFD, 0xCE97, 0xCE4E, 0xCD14, 0xCC85, 0xCBD5, 0xCA59, 0xC8F4, 0xC58C, 0xC941,
    0xCE4A, 0xD0FF, 0xCD9F, 0xCEEB, 0xD42F, 0xDBF8, 0xE870, 0xF36B, 0x0376, 0x0CAC, 0x11BD, 0x12D9, 0x1623, 0x16DC, 0x1614, 0x1B58,
    0x1F42, 0x25BF, 0x23DE, 0x2459, 0x2165, 0x2068, 0x21F9, 0x2583, 0x2D99, 0x2F44, 0x320A, 0x3291, 0x3892, 0x389B, 0x390A, 0x3BFE,
    0x3952, 0x35BC, 0x3592, 0x3D6A, 0x418B, 0x4181, 0x3EDB, 0x3B69, 0x3629, 0x33B6, 0x3206, 0x2C8F, 0x274F, 0x2670, 0x25B9, 0x1BBA,
    0x1024, 0x05B4, 0xFE90, 0xFD2E, 0xFF59, 0x0505, 0x0BD3, 0x0FA0, 0x12CB, 0x15C6, 0x144E, 0x10BD, 0x0B73, 0x0A80, 0x0564, 0xFC12,
    0xF29D, 0xE80C, 0xE13B, 0xD989, 0xD77A, 0xD854, 0xD918, 0xD695, 0xD491, 0xD751, 0xD6A4, 0xD3F1, 0xD383, 0xD7E4, 0xD70A, 0xD6EA,
    0xDF72, 0xEBD6, 0xF418, 0xF6DD, 0xFC39, 0xFBBC, 0xFCA1, 0xFC78, 0xF765, 0xF297, 0xF1BE, 0xF96C, 0xFDF6, 0xFF9D, 0xFEB1, 0x0361,
    0x0BE5, 0x1388, 0x1F35, 0x2A8D, 0x3559, 0x3795, 0x37EC, 0x36E6, 0x3449, 0x324B, 0x3027, 0x3179, 0x2AE1, 0x2383, 0x18DE, 0x10D9,
    0x06E8, 0xF97A, 0xF2DB, 0xED1B, 0xE9A1, 0xE0B5, 0xDE69, 0xDDF6, 0xDA8B, 0xD7B6, 0xD725, 0xD7D0, 0xD415, 0xD806, 0xE20E, 0xEAD6,
    0xED27, 0xEF41, 0xEE63, 0xE94C, 0xE850, 0xE589, 0xE0D9, 0xDCC4, 0xE092, 0xE754, 0xE757, 0xE2B9, 0xDE10, 0xE065, 0xE6F2, 0xED71,
    0xF831, 0x0540, 0x1117, 0x19E4, 0x1DC9, 0x2176, 0x224A, 0x22FB, 0x2496, 0x253F, 0x2389, 0x1ECC, 0x18C6, 0x129D, 0x0D4F, 0x0948,
    0x0B7B, 0x0E61, 0x115F, 0x114E, 0x13F4, 0x14B5, 0x12D4, 0x17A1, 0x1909, 0x1901, 0x1632, 0x1B9E, 0x249A, 0x29BF, 0x2DC7, 0x2DE4,
    0x2BBF, 0x259D, 0x2239, 0x1A3D, 0x11A3, 0x0C48, 0x0A59, 0x0772, 0xFE03, 0xF460, 0xECD3, 0xEC1D, 0xEC52, 0xF0C6, 0xF7A8, 0xFD84,
    0x04A1, 0x06BB, 0x0782, 0x058E, 0x00AC, 0xFDEC, 0xFD05, 0xF8E2, 0xF117, 0xEB0C, 0xE3A7, 0xDDCC, 0xD90B, 0xD653, 0xD950, 0xD9C3,
    0xD7E6, 0xDA7C, 0xDF10, 0xE15A, 0xE55B, 0xEB56, 0xEDBC, 0xEEA0, 0xF307, 0xFD24, 0x0734, 0x0D40, 0x123D, 0x12E8, 0x13B2, 0x1734,
    0x1A9D, 0x1984, 0x18D8, 0x202D, 0x291C, 0x2E8B, 0x2CF9, 0x2A84, 0x2C24, 0x2D9C, 0x306C, 0x381D, 0x41D9, 0x490B, 0x4D3F, 0x4EF4,
    0x4D31, 0x4732, 0x4149, 0x3F40, 0x39FC, 0x31A6, 0x26B3, 0x1C38, 0x1386, 0x0843, 0xFEE4, 0xF71A, 0xF12F, 0xE6A0, 0xDE6B, 0xD9D8,
    0xD199, 0xCAF4, 0xC57A, 0xC31C, 0xBDD7, 0xBB58, 0xBF38, 0xC61E, 0xCB7F, 0xCFAE, 0xD3F0, 0xD057, 0xCDDD, 0xCBA9, 0xC8C7, 0xC35E,
    0xC12C, 0xC4A3, 0xC84A, 0xCA4B, 0xC5A0, 0xC585, 0xC817, 0xCD6B, 0xD6D3, 0xE1A4, 0xEE57, 0xF8F4, 0x03D2, 0x0B00, 0x0FDB, 0x11FB,
    0x13C7, 0x19AF, 0x1CC9, 0x1E6D, 0x1CC6, 0x1B7C, 0x1735, 0x114D, 0x0F96, 0x10AF, 0x1287, 0x11DF, 0x16DC, 0x1CA9, 0x1FB1, 0x21F0,
    0x274D, 0x29AF, 0x26FD, 0x27DD, 0x2923, 0x2D1C, 0x2FD8, 0x3066, 0x2E31, 0x28A1, 0x254A, 0x2093, 0x198B, 0x1193, 0x10B9, 0x139A,
    0x1211, 0x0B00, 0x01C8, 0xFBC6, 0xF662, 0xF5EC, 0xF860, 0xFE9F, 0x067A, 0x0C4E, 0x1455, 0x1A85, 0x1D0B, 0x1BA9, 0x1A92, 0x1C16,
    0x196B, 0x12C7, 0x0C5E, 0x06ED, 0xFF42, 0xF6C8, 0xF20D, 0xEF60, 0xE830, 0xE36D, 0xE6AF, 0xE827, 0xE919, 0xE9BB, 0xEA25, 0xE92F,
    0xE895, 0xEB10, 0xEF22, 0xF648, 0xFCC9, 0xFF10, 0xFB0F, 0xF7AC, 0xF829, 0xF5A9, 0xEE1E, 0xE97B, 0xEBE1, 0xF02C, 0xF0F8, 0xEF3C,
    0xF0BC, 0xF415, 0xF9E3, 0x00DF, 0x0C7A, 0x170F, 0x1F33, 0x2849, 0x2B1A, 0x29D4, 0x238D, 0x1FC9, 0x1F05, 0x1F19, 0x1CC2, 0x1858,
    0x1566, 0x1037, 0x0BDF, 0x09B8, 0x087D, 0x0347, 0xFDD2, 0xF9DF, 0xF667, 0xF20E, 0xEE71, 0xEEEE, 0xEADE, 0xE47C, 0xE2BF, 0xE638,
    0xEB8C, 0xF1D4, 0xF765, 0xF7D3, 0xF77F, 0xF717, 0xF78C, 0xF58A, 0xF1BC, 0xF410, 0xFC33, 0x03C0, 0x0508, 0x022C, 0xFD24, 0xFAD7,
    0xFD41, 0x0035, 0x0756, 0x10C4, 0x1B58, 0x25CC, 0x2BBD, 0x2E17, 0x2D20, 0x2C38, 0x2A20, 0x2675, 0x2051, 0x1B75, 0x16CA, 0x0D5C,
    0x0537, 0x026A, 0x00E5, 0xFC8D, 0xFC45, 0xFC9B, 0xFB68, 0xF84F, 0xF679, 0xF649, 0xEF1F, 0xEBB0, 0xEC58, 0xEE7B, 0xF1A5, 0xF395,
    0xF578, 0xF3E8, 0xF079, 0xEC9C, 0xE818, 0xDF3C, 0xD7FC, 0xD8E3, 0xDD28, 0xDCB9, 0xD7D2, 0xD324, 0xCFAA, 0xCEBC, 0xCE6C, 0xD1E0,
    0xD845, 0xDDA4, 0xE45D, 0xEACD, 0xF0BF, 0xF3FD, 0xF5B9, 0xF9B1, 0xFF20, 0x0073, 0xFE19, 0xFF23, 0xFA53, 0xF349, 0xF056, 0xEFF3,
    0xEF75, 0xEEC1, 0xF086, 0xF283, 0xF7A4, 0xFF33, 0x088F, 0x0CDF, 0x0D8E, 0x1146, 0x1639, 0x1D4F, 0x253D, 0x2CA6, 0x2D5C, 0x2D2D,
    0x2DC6, 0x2DDD, 0x2D6D, 0x28A3, 0x28B3, 0x2CDA, 0x31F7, 0x3241, 0x2F81, 0x2A84, 0x2758, 0x27C9, 0x27E7, 0x2D2D, 0x3184, 0x39AF,
    0x40C4, 0x44BB, 0x4438, 0x3F25, 0x3ADD, 0x37AD, 0x34C5, 0x2D23, 0x26C6, 0x1DBA, 0x1230, 0x06FC, 0x0190, 0xFBFD, 0xF2AA, 0xEDC2,
    0xE6E0, 0xE15A, 0xDB45, 0xD918, 0xD72E, 0xD1BC, 0xCDA6, 0xCB1B, 0xCDA0, 0xD332, 0xDBF3, 0xE206, 0xE573, 0xE7C0, 0xE95C, 0xE80B,
    0xE082, 0xD9E4, 0xD7CE, 0xD975, 0xDA0A, 0xDA8A, 0xD986, 0xD6CC, 0xD7BE, 0xDC44, 0xE530, 0xEE56, 0xF694, 0xFFEB, 0x091F, 0x0F1E,
    0x0FFD, 0x0F1E, 0x109A, 0x132E, 0x132C, 0x135A, 0x13F6, 0x110E, 0x0B90, 0x07CB, 0x0576, 0x008F, 0xFD69, 0xFCDC, 0xFD1C, 0x00CC,
    0x0660, 0x0DC2, 0x11B6, 0x1232, 0x13BA, 0x1501, 0x167B, 0x1AEC, 0x1F08, 0x1E2E, 0x1BD9, 0x1C48, 0x1EFB, 0x1D39, 0x1677, 0x137C,
    0x19C4, 0x1ED4, 0x1DAC, 0x1A0D, 0x1176, 0x0527, 0xFA7F, 0xF554, 0xF36B, 0xF2CF, 0xF2CA, 0xF65C, 0xFD19, 0x0063, 0xFDEC, 0xFC48,
    0xFE39, 0xFDAE, 0xFA50, 0xF618, 0xF207, 0xE9F5, 0xE2B9, 0xDFFF, 0xDC45, 0xD92C, 0xD750, 0xD560, 0xD0EE, 0xCE10, 0xCFD0, 0xD112,
    0xCFCB, 0xCF03, 0xCEAF, 0xD0FF, 0xD87B, 0xE2F5, 0xECF6, 0xF19F, 0xF47E, 0xF916, 0xFCBB, 0xFB84, 0xF8AD, 0xFA28, 0x00D3, 0x0782,
    0x0C3B, 0x0E30, 0x0DC7, 0x0F56, 0x1268, 0x1AD7, 0x2313, 0x2A92, 0x340B, 0x3E7B, 0x47AD, 0x49D3, 0x48F8, 0x4850, 0x4AE1, 0x4A59,
    0x49FA, 0x48A7, 0x4261, 0x394A, 0x30B2, 0x2BE9, 0x2207, 0x1ABA, 0x12D1, 0x09FF, 0x0263, 0xFE1F, 0xFD03, 0xF7F6, 0xF2FE, 0xEA7D,
    0xE480, 0xE25A, 0xE475, 0xE8BA, 0xEAE7, 0xEB09, 0xEBDB, 0xEECA, 0xEBFD, 0xE775, 0xE216, 0xE233, 0xE58A, 0xE6D6, 0xE7E1, 0xE3BA,
    0xDF01, 0xDAED, 0xDCC4, 0xE29B, 0xEA3E, 0xF56F, 0x007D, 0x0F23, 0x1950, 0x1E47, 0x22B5, 0x258D, 0x2615, 0x2489, 0x2408, 0x2107,
    0x1BD8, 0x165A, 0x1280, 0x0E11, 0x08A8, 0x06E7, 0x04A7, 0x01C8, 0x0184, 0x0774, 0x0BD2, 0x0D5F, 0x0EAD, 0x0D8E, 0x0ED2, 0x10FF,
    0x1682, 0x19EA, 0x1875, 0x153F, 0x1476, 0x12E5, 0x096B, 0xFE14, 0xF69B, 0xF4E9, 0xF405, 0xF39D, 0xF071, 0xE92A, 0xE1F8, 0xDDED,
    0xDC1E, 0xDB6E, 0xDD34, 0xDF77, 0xE194, 0xE2C9, 0xE1C1, 0xDFAE, 0xDF95, 0xDEBE, 0xDEBA, 0xE10D, 0xE31D, 0xE043, 0xD8F6, 0xD563,
    0xD0E2, 0xCA6E, 0xC72E, 0xC6E8, 0xC4C1, 0xC37B, 0xC798, 0xCFDB, 0xD83C, 0xDC3E, 0xDF80, 0xE15E, 0xE53F, 0xEA52, 0xF1E1, 0xF9C2,
    0xFD17, 0x0373, 0x097F, 0x0E63, 0x0FF8, 0x1124, 0x163D, 0x1E39, 0x25C7, 0x29AB, 0x2B48, 0x2827, 0x252D, 0x2701, 0x2B7C, 0x3183,
    0x3926, 0x42CC, 0x4D36, 0x55C9, 0x5813, 0x5824, 0x57C0, 0x5383, 0x5168, 0x5192, 0x4F58, 0x4775, 0x3FB9, 0x3985, 0x3092, 0x285C,
    0x1E76, 0x1661, 0x0A19, 0xFE25, 0xF7C4, 0xF0B4, 0xEB87, 0xE3B4, 0xDC6C, 0xD536, 0xD28C, 0xD561, 0xD8A7, 0xDA5E, 0xD987, 0xDBE5,
    0xDD39, 0xD980, 0xD1BF, 0xCCE0, 0xCB5A, 0xCB5E, 0xCC7B, 0xCD4A, 0xCC43, 0xC79C, 0xC622, 0xC7CA, 0xCC9F, 0xD251, 0xD88B, 0xE3AA,
    0xEF47, 0xF7B0, 0xFC75, 0x0393, 0x0A98, 0x0F5B, 0x14D2, 0x1750, 0x181C, 0x15AF, 0x1204, 0x1020, 0x0C27, 0x0A6C, 0x09D2, 0x08EF,
    0x0900, 0x0CA2, 0x13D9, 0x1A0D, 0x20B1, 0x2179, 0x1F58, 0x1E46, 0x20DD, 0x26A6, 0x28A4, 0x27BD, 0x2710, 0x2A43, 0x2A1E, 0x2553,
    0x1D71, 0x181B, 0x1644, 0x16A5, 0x187E, 0x145D, 0x0CA8, 0x0153, 0xF981, 0xF3C4, 0xEF90, 0xEEC3, 0xEF0C, 0xF521, 0xF8A6, 0xF9BA,
    0xF9DD, 0xFA70, 0xFA49, 0xF931, 0xFBAA, 0xF95B, 0xF3C1, 0xED52, 0xE634, 0xDD1A, 0xD428, 0xD0DA, 0xCDBC, 0xCA51, 0xC7AC, 0xC872,
    0xCC5C, 0xD068, 0xD527, 0xD7AD, 0xD78E, 0xD91B, 0xE11F, 0xEA4E, 0xF06B, 0xF2E3, 0xF6A5, 0xFBB2, 0xF9DA, 0xF49B, 0xEF2D, 0xEDBE,
    0xEF1D, 0xF2C9, 0xF6F0, 0xF5BC, 0xF2F3, 0xF08B, 0xF2F4, 0xF8CC, 0xFEC6, 0x05B4, 0x0EC7, 0x18E0, 0x1F65, 0x2291, 0x23F1, 0x24AB,
    0x237C, 0x24FE, 0x26EB, 0x251C, 0x2093, 0x1AE6, 0x144F, 0x0BCC, 0x053D, 0x0153, 0xFBBD, 0xF4E4, 0xF2BD, 0xF357, 0xF4B0, 0xF562,
    0xF6ED, 0xF309, 0xEC56, 0xE9FC, 0xEC50, 0xF125, 0xEFB9, 0xF326, 0xFB41, 0x0325, 0x0455, 0x0184, 0x0276, 0x0406, 0x0896, 0x0ABA,
    0x0E03, 0x0CA6, 0x0738, 0x0241, 0x014A, 0x04C8, 0x0763, 0x0FFE, 0x18B4, 0x21BE, 0x256A, 0x2755, 0x291A, 0x271F, 0x26FA, 0x277E,
    0x2800, 0x2379, 0x202B, 0x1B31, 0x1485, 0x0D82, 0x075E, 0x02D0, 0xF9C5, 0xF356, 0xEE55, 0xEF48, 0xF269, 0xF4E6, 0xF6D5, 0xF355,
    0xF339, 0xF688, 0xFD37, 0x0152, 0x0152, 0x02F3, 0x0570, 0x06AE, 0x02D9, 0xFCA2, 0xF858, 0xF689, 0xF7E9, 0xFA58, 0xF8EB, 0xF40D,
    0xEC64, 0xE5CD, 0xE2C1, 0xDFEB, 0xE01E, 0xE339, 0xE6AC, 0xE955, 0xEB2D, 0xEE40, 0xEEEF, 0xEFDD, 0xF527, 0xFC6A, 0xFFCE, 0xFE1D,
    0xFBF3, 0xF7D7, 0xF02C, 0xE95C, 0xE422, 0xDFAA, 0xDC13, 0xDA07, 0xDBC0, 0xDFE4, 0xE6ED, 0xEC0D, 0xEE1F, 0xEC69, 0xED0D, 0xF2DE,
    0xF7F8, 0xFD86, 0x01BC, 0x0AF9, 0x112B, 0x11ED, 0x110E, 0x0D35, 0x0C44, 0x0CEF, 0x113A, 0x13F1, 0x1339, 0x0E13, 0x08CD, 0x0828,
    0x085D, 0x0C30, 0x12BF, 0x1C0B, 0x22F0, 0x2999, 0x2F0A, 0x32D8, 0x3382, 0x3162, 0x33FE, 0x333D, 0x307D, 0x2ADE, 0x243D, 0x18F0,
    0x0DF7, 0x0764, 0xFE3F, 0xF740, 0xEEBC, 0xEA20, 0xE634, 0xE360, 0xE51E, 0xE3D4, 0xDD32, 0xD5F6, 0xD55E, 0xD794, 0xD834, 0xD7ED,
    0xDAB9, 0xDE87, 0xE15C, 0xDEFE, 0xD9C0, 0xD5B7, 0xD2A8, 0xD2E3, 0xD526, 0xD890, 0xD85C, 0xD699, 0xD6C4, 0xD8AD, 0xDBA7, 0xE0CE,
    0xEAE0, 0xF6BD, 0xFED3, 0x05A0, 0x0CFF, 0x1082, 0x137A, 0x19C2, 0x2170, 0x238D, 0x229F, 0x2059, 0x1BE3, 0x1739, 0x0FE4, 0x0CC1,
    0x09D6, 0x0738, 0x053C, 0x059C, 0x0AF2, 0x11EF, 0x1BF7, 0x1DF5, 0x1B92, 0x19DD, 0x1C44, 0x2066, 0x200D, 0x20C0, 0x234F, 0x2848,
    0x2A50, 0x28C6, 0x25BD, 0x219D, 0x1FB9, 0x212D, 0x23D0, 0x220A, 0x1C05, 0x1472, 0x0F76, 0x098D, 0x0315, 0x02CE, 0x0624, 0x0A43,
    0x0B7B, 0x0DD3, 0x0DFE, 0x0CB5, 0x0C7E, 0x0E0F, 0x124C, 0x1305, 0x13C2, 0x10FA, 0x0AC9, 0x01BC, 0xF7C2, 0xEFA4, 0xE5FA, 0xDD94,
    0xD488, 0xCF03, 0xCE4E, 0xD10B, 0xD4C6, 0xD475, 0xD353, 0xD564, 0xDBC7, 0xDF53, 0xE1A3, 0xE6F3, 0xEDF2, 0xF24E, 0xF19F, 0xEE16,
    0xE80F, 0xE689, 0xE82D, 0xEC2D, 0xF18E, 0xF253, 0xEFF0, 0xECA9, 0xEAE1, 0xEA20, 0xEC79, 0xF4B9, 0xFFF6, 0x0B44, 0x159F, 0x1DAC,
    0x243E, 0x281C, 0x2C60, 0x2EDE, 0x2F5F, 0x2FC7, 0x2C77, 0x2773, 0x1D09, 0x147B, 0x0CC3, 0x04DB, 0xFD1C, 0xF528, 0xF0CC, 0xEA7C,
    0xE9C9, 0xEA97, 0xE780, 0xE07D, 0xD8DC, 0xD5F0, 0xD548, 0xD552, 0xD54A, 0xD932, 0xE01C, 0xE637, 0xE7AE, 0xE593, 0xE172, 0xDF49,
    0xDF2B, 0xDFD6, 0xE103, 0xDE0B, 0xDC08, 0xD9BE, 0xD7D3, 0xD7C5, 0xDBD0, 0xE5C2, 0xEEF3, 0xFB5C, 0x06DB, 0x0EC1, 0x13F9, 0x1A3B,
    0x2428, 0x2A92, 0x2F4F, 0x313F, 0x3117, 0x2DF8, 0x26F4, 0x2213, 0x1D81, 0x1814, 0x138A, 0x0F42, 0x0BC6, 0x0BEB, 0x1218, 0x1A0B,
    0x1DAC, 0x1D9E, 0x1F7A, 0x25D0, 0x2AFA, 0x2D92, 0x323F, 0x35A4, 0x3896, 0x3890, 0x33E8, 0x2D6B, 0x24DA, 0x1E4F, 0x1AAB, 0x1AAE,
    0x17C8, 0x1051, 0x096F, 0x00C4, 0xF785, 0xEEEB, 0xEB4F, 0xEAB8, 0xE9DC, 0xEA71, 0xE9D8, 0xE7FF, 0xE52E, 0xE50F, 0xE764, 0xE821,
    0xE86D, 0xE75C, 0xE2A0, 0xDC7F, 0xD53B, 0xCEAD, 0xC823, 0xC382, 0xC28F, 0xC16A, 0xC351, 0xC7CC, 0xD00A, 0xD7D9, 0xDA77, 0xDD10,
    0xE190, 0xE792, 0xEB78, 0xF127, 0xFAFD, 0x0694, 0x121E, 0x17B1, 0x1A00, 0x18DA, 0x1689, 0x178C, 0x1BA9, 0x21CF, 0x22E2, 0x21E2,
    0x21C3, 0x1F95, 0x1EA1, 0x1F88, 0x2489, 0x2BCD, 0x3135, 0x3829, 0x3B8C, 0x3D77, 0x3EBA, 0x3FD6, 0x4363, 0x436F, 0x4331, 0x4025,
    0x3970, 0x3030, 0x22C7, 0x1702, 0x0AAF, 0xFE90, 0xF34B, 0xE702, 0xDF7C, 0xDB0F, 0xD9B4, 0xD6B7, 0xCFF9, 0xCC47, 0xC8D3, 0xC6F3,
    0xC4FC, 0xC365, 0xC465, 0xC54D, 0xC84D, 0xC741, 0xC42C, 0xC0F4, 0xBDF6, 0xC08A, 0xC21E, 0xC216, 0xC0B5, 0xBEAA, 0xBC84, 0xB7E9,
    0xB641, 0xB7A0, 0xBD29, 0xC5B5, 0xCF24, 0xDAA9, 0xE285, 0xE94A, 0xF1F4, 0xFA92, 0x03B5, 0x0AF9, 0x0FEC, 0x1144, 0x0FFF, 0x0F3A,
    0x0D4C, 0x0D97, 0x0E7F, 0x0E77, 0x0EFE, 0x0C21, 0x0E07, 0x143F, 0x1965, 0x1C8D, 0x1E4A, 0x23D3, 0x275E, 0x2C6F, 0x322B, 0x37EF,
    0x40BA, 0x45F7, 0x498C, 0x484D, 0x43AC, 0x3D05, 0x3737, 0x360A, 0x341D, 0x31B7, 0x2E2D, 0x2964, 0x23EC, 0x1A54, 0x12F0, 0x1135,
    0x1004, 0x122B, 0x14B4, 0x1498, 0x12D0, 0x1198, 0x1155, 0x0F7D, 0x10A3, 0x11E8, 0x107C, 0x0B06, 0x0237, 0xF8AE, 0xEDE1, 0xE34F,
    0xDA09, 0xD329, 0xCBAE, 0xC7D4, 0xC923, 0xCC7B, 0xCF2F, 0xD024, 0xD252, 0xD6BE, 0xDB82, 0xDDFC, 0xE130, 0xE6A4, 0xEDEE, 0xF3CF,
    0xF774, 0xF653, 0xF163, 0xEE94, 0xEEF8, 0xF473, 0xF74D, 0xF939, 0xFC3B, 0xFCB5, 0xF9EB, 0xF531, 0xF889, 0xFD6A, 0x068F, 0x115B,
    0x1B0A, 0x222A, 0x2615, 0x2B20, 0x2D72, 0x2FC0, 0x2E2F, 0x2DF3, 0x2A32, 0x2355, 0x1AB9, 0x1122, 0x097B, 0x02A3, 0xFB54, 0xF717,
    0xEA67, 0xEE60, 0xF6C9, 0xEFE7, 0xEE20, 0xE353, 0xF062, 0xDCFE, 0xD82D, 0xD8DD, 0xD425, 0xDC5C, 0xD1C1, 0xE5B3, 0xE686, 0xE441,
    0xE2EC, 0xE270, 0xDF03, 0xF1EF, 0xE481, 0xE533, 0xEF75, 0xE48D, 0xF13A, 0xDC39, 0xE446, 0xF3EE, 0xF51B, 0x00C1, 0x13E5, 0x066A,
    0x02A7, 0x175D, 0x0CD4, 0x2C88, 0x2C3B, 0x0E40, 0x39CD, 0x1A0C, 0x1D43, 0x237B, 0xF9EA, 0x19D7, 0xF58F, 0xFB31, 0xF910, 0xDA4A,
    0x01A2, 0xF37B, 0xE9E5, 0x0265, 0x0B3C, 0x019D, 0xFB2C, 0xFD71, 0x2055, 0x0674, 0xFA7D, 0x19E0, 0x116D, 0x2127, 0xF04A, 0xFF0F,
    0x0ABC, 0xFA27, 0xF6DC, 0x08A6, 0x21C0, 0xE5E7, 0xE659, 0xF0F7, 0xFD04, 0xEBF3, 0xF992, 0x2997, 0x47A3, 0x3140, 0xF92E, 0xE058,
    0xC43A, 0xB80F, 0xD290, 0xEF5B, 0xBC3C, 0xB93F, 0xCAA9, 0x1342, 0x15EB, 0x10CE, 0xFAAB, 0x9177, 0x8A40, 0x8000, 0x8FC6, 0x9350,
    0xB5D4, 0xE60D, 0x30EA, 0x6016, 0x73C6, 0x7711, 0x5357, 0x32ED, 0x1695, 0x39E1, 0x51A5, 0x6485, 0x3FC3, 0x2DE6, 0x5306, 0x6223,
    0x7846, 0x7C07, 0x7FFF, 0x748D, 0x69E1, 0x7FFF, 0x796B, 0x74B3, 0x6883, 0x6ADA, 0x3167, 0xFE86, 0x0494, 0xD9A9, 0xD069, 0xBF1F,
    0xC07D, 0xC14B, 0xBA63, 0xBD81, 0xC25B, 0xCC74, 0xDBEF, 0xDF54, 0xC807, 0xD7A7, 0xDB39, 0xFE91, 0xEBED, 0x000F, 0x0678, 0xD3CC,
    0xE176, 0xE513, 0x1E22, 0x37E7, 0x278C, 0x1030, 0x0631, 0xD9BB, 0xB2C6, 0x9613, 0x852A, 0x8DC8, 0x8E43, 0x9315, 0x9E3B, 0xCF45,
    0xD5C5, 0xD5B3, 0xC32B, 0xC695, 0xC553, 0xD264, 0xFE63, 0xEC89, 0xF0E1, 0x0045, 0xFC18, 0xF9AB, 0xEBC5, 0xE13D, 0xE546, 0x0070,
    0x0705, 0x0B39, 0x1581, 0x2179, 0x1EF7, 0x25DA, 0x3F37, 0x218D, 0x294B, 0xF63E, 0xEB14, 0xDFAF, 0xC440, 0xD2F7, 0xDA79, 0xEDC9,
    0xCA78, 0x04CD, 0x343A, 0x42A0, 0x4D64, 0x570F, 0x5734, 0x46ED, 0x7297, 0x469E, 0x41A6, 0x5473, 0x3573, 0x2CC3, 0x49C3, 0x3D7B,
    0x0E89, 0x1907, 0xFAD0, 0x1870, 0xFC39, 0xCEB9, 0xC50E, 0xD4DE, 0xD809, 0xEF5B, 0x0F51, 0x0954, 0x35A7, 0x2FE1, 0x16EE, 0x14A7,
    0x163A, 0xFB04, 0xE46E, 0x004F, 0x1724, 0x0F8A, 0x01EF, 0x05F9, 0x2FA7, 0xE56F, 0xEE88, 0xF672, 0xD302, 0xD154, 0xF111, 0x0AB0,
    0x0206, 0x059D, 0xF309, 0xD8E4, 0xF735, 0x2097, 0x1BEE, 0x37F9, 0xEEF2, 0x0B29, 0xF50D, 0xFB49, 0xF4AD, 0xC955, 0xC1E6, 0xBA11,
    0xDE7F, 0xEBA1, 0xF487, 0xFE71, 0x13E2, 0x01E1, 0x051C, 0xE565, 0xF197, 0x1AAF, 0x104C, 0xFDDB, 0x3F02, 0x2DA3, 0x2768, 0x2C3A,
    0x0888, 0x08DB, 0xEE06, 0xC01E, 0xAFC9, 0xC535, 0xE016, 0xDBF3, 0xF3FD, 0xFCA8, 0xF0C3, 0x14D1, 0xEAEE, 0xFFFB, 0xFEBB, 0xF2AF,
    0xF8CD, 0xE535, 0xE3EA, 0xFCCE, 0xF63A, 0xF0C9, 0xEDAE, 0xD9AF, 0xD42A, 0xCFCC, 0xB74A, 0xBA77, 0xCC16, 0xB68A, 0xC477, 0xF048,
    0x014E, 0xEE2D, 0x0670, 0x013A, 0xE2C3, 0xDC9E, 0xF80C, 0xD900, 0xC2D1, 0xCF48, 0xDE80, 0x033A, 0xF483, 0xEC21, 0x2907, 0x1F69,
    0x2159, 0x2D0D, 0x0DFE, 0xF9ED, 0xE04B, 0xDA0D, 0xED92, 0x0A91, 0xF8FC, 0x16AE, 0x18DE, 0x2233, 0x0AC5, 0x1D31, 0x2EFE, 0x1729,
    0x207E, 0xFED2, 0x0348, 0x25A6, 0x1C91, 0x0C52, 0x1900, 0x181B, 0x1765, 0xFBB8, 0xDEAF, 0xFC35, 0x090E, 0x265F, 0x3311, 0x311B,
    0x5EB5, 0x3DAD, 0x4B24, 0x42D3, 0x27CC, 0x309C, 0x2A6D, 0x216E, 0xF79C, 0xE518, 0xFDCA, 0xEDAB, 0xD734, 0xCAB9, 0xC51B, 0xE7EB,
    0xDA77, 0xDB2E, 0xDAE5, 0xB09B, 0xBCFB, 0xD626, 0xBA00, 0xE8A4, 0x054E, 0xED77, 0x1CE4, 0x3A64, 0x2BB7, 0x3B50, 0x36C5, 0x3022,
    0x3876, 0x4593, 0x5DD6, 0x6524, 0x45D6, 0x3652, 0x4E38, 0x45C7, 0x418C, 0x1634, 0x1552, 0x3C58, 0x0BDA, 0x0F73, 0x00FC, 0x0012,
    0x09A2, 0xE65A, 0x197C, 0x229B, 0x2E64, 0x3356, 0x358C, 0x2097, 0x24BF, 0x197A, 0x1008, 0x0268, 0xE748, 0x2430, 0xF579, 0x0082,
    0x19D9, 0xFFF0, 0xD49F, 0xD5D2, 0xE7AD, 0xD836, 0xE151, 0xD6F6, 0xC29F, 0xAD39, 0xD2CE, 0xCA40, 0xA71F, 0xADF7, 0xCB7A, 0xBA19,
    0xAD59, 0xAC5A, 0xA6CB, 0xB16A, 0xA93B, 0xC0EE, 0xCCF2, 0xDFF7, 0xDCE3, 0xEAC6, 0xFB11, 0xF715, 0x13D1, 0x16CB, 0x0B31, 0x2155,
    0x1AA5, 0x0AE3, 0x1C9B, 0x15B7, 0x13C8, 0x07BD, 0xEEE6, 0x0192, 0x1778, 0x07EB, 0x1830, 0x0196, 0x09F8, 0x0C9E, 0x021D, 0x0EDB,
    0x0AA5, 0x1D71, 0x00E6, 0x06AC, 0x0835, 0x0FF5, 0x2269, 0x2767, 0x3DFA, 0x384A, 0x245F, 0x34D7, 0x3FCC, 0x46A9, 0x3AB3, 0x2C0F,
    0x0DF8, 0x06CF, 0x0F9D, 0xE6EC, 0xFD5D, 0xED1F, 0xF2D5, 0xF19A, 0xFB45, 0x12EA, 0xEF2D, 0xE7BF, 0xDB44, 0xBFA2, 0xC534, 0xE00A,
    0xC8BB, 0xD89E, 0xC8C8, 0xCCE4, 0xCFDC, 0xDEBB, 0x040B, 0xE5E5, 0xEB90, 0xEDF5, 0xF8A0, 0x0DBD, 0x13F4, 0x12FC, 0x0F0F, 0xE8A0,
    0xFCBD, 0x0067, 0xE4C8, 0xD449, 0xCCA5, 0xCDC7, 0xCFD9, 0xE227, 0xC90F, 0xC553, 0xCA09, 0xD71C, 0xD682, 0xDE0B, 0xDBF8, 0xC79E,
    0xC079, 0xD3D4, 0xD33C, 0xCF16, 0xD6DE, 0xDEBC, 0xE82E, 0x0946, 0x20BD, 0x2DEF, 0x478C, 0x2B2B, 0x42A4, 0x3508, 0x2543, 0x4C57,
    0x3DA4, 0x3D9C, 0x4A3F, 0x3CFA, 0x46C0, 0x3FD6, 0x5143, 0x33A6, 0x29A7, 0x4637, 0x4770, 0x276E, 0x171D, 0x0B7B, 0xF871, 0x0884,
    0xFFBF, 0x1364, 0xEE97, 0xF1D5, 0x1B3F, 0x2564, 0xF0FE, 0x1291, 0x0B75, 0xF2AF, 0xF873, 0x0671, 0x0A07, 0xDA52, 0x04D3, 0xE5E5,
    0xD608, 0xEBF9, 0xF69C, 0xF2B2, 0x0E02, 0x0883, 0x0C12, 0x1A6D, 0x3259, 0x13B7, 0xFAD6, 0x1B59, 0x0FF9, 0x073F, 0x1367, 0x0EBC,
    0xCF74, 0xD2E7, 0xD973, 0xEA01, 0xF702, 0x0A3A, 0x2115, 0x2E95, 0x0EFB, 0x21EA, 0x2162, 0x26A9, 0x3847, 0x1210, 0x315A, 0x15C8,
    0x170B, 0x1B92, 0x1258, 0xFE9B, 0x026A, 0x0165, 0x0F4E, 0x063F, 0xDF24, 0xD6F0, 0xC116, 0xC78A, 0xC31C, 0xD87D, 0xE989, 0xDC67,
    0xE396, 0xEE7B, 0xFE4F, 0x14FC, 0xF880, 0xEB1E, 0xEF08, 0xFD26, 0xF491, 0xE712, 0xE025, 0x06F6, 0x0205, 0xD2A2, 0xD4C1, 0xBF84,
    0xCCD2, 0xAA9B, 0xC178, 0xE060, 0xB6A8, 0xB74F, 0xC019, 0xBEB5, 0xB156, 0xC452, 0xDD94, 0xE45C, 0xF58C, 0xFC64, 0x039F, 0x1083,
    0x1AE0, 0x2F42, 0x405A, 0x3D6A, 0x3A64, 0x1DAA, 0xEFA0, 0x1379, 0x1296, 0x12BB, 0x318D, 0x1B61, 0x0AA3, 0xECB8, 0xFD10, 0x0815,
    0xF8B1, 0xFFE6, 0x1280, 0x1AF7, 0x3BF4, 0x3465, 0x22F9, 0x3547, 0x136D, 0x128F, 0x180D, 0x09B2, 0x00C7, 0x0EB3, 0xF682, 0xDD15,
    0x0156, 0x06F2, 0xF0BF, 0xFEBD, 0x0041, 0x0D35, 0x1F66, 0x0994, 0x109D, 0xEF4C, 0xCB1D, 0xDCA6, 0xE51A, 0xE089, 0xF74A, 0xF133,
    0xE870, 0xDBE9, 0xD07E, 0xD63D, 0xD638, 0xE6E9, 0xC8A4, 0xBFCD, 0xBB44, 0xC265, 0xCD4B, 0xCB82, 0xCCC4, 0xCD94, 0xED29, 0xE5A6,
    0xF531, 0xF242, 0x0163, 0x3565, 0x0F55, 0xF46D, 0xE5AE, 0xEB0A, 0xF3A7, 0xED17, 0xE02C, 0xDB41, 0xE612, 0xC9C0, 0xC8CC, 0xD654,
    0xF178, 0x03B5, 0xE55C, 0xDF44, 0xF515, 0xFEBC, 0xFC52, 0xF63D, 0xEF1F, 0xFE97, 0x01A7, 0x016C, 0x13B2, 0x183A, 0x15E7, 0x2535,
    0x3EDE, 0x3514, 0x35B2, 0x2CD5, 0x324A, 0x24DB, 0x1A49, 0x1930, 0x11D2, 0x2E42, 0x24CA, 0x0EDF, 0x1A74, 0x46AA, 0x3BA4, 0x2FB8,
    0x3248, 0x274B, 0x326A, 0x3A3A, 0x34F5, 0x2600, 0x0021, 0xFC92, 0x058A, 0x13F8, 0x0DBD, 0xE8E5, 0x01B0, 0x046E, 0xFFBA, 0xFD99,
    0xEFF5, 0xF0BA, 0xE49A, 0xDD52, 0xF256, 0xF413, 0xEB8A, 0xE87C, 0xFF2C, 0xFDA5, 0xDD51, 0xD483, 0xD7F5, 0xD920, 0xD2CB, 0xD67A,
    0xC139, 0xCB04, 0xD115, 0xD447, 0xE000, 0xD4EC, 0xD0F0, 0xD76F, 0xE9B8, 0xCAA2, 0xD8C4, 0x0970, 0xFAD1, 0x0E15, 0x1674, 0x126F,
    0x1A59, 0x21EA, 0x1B65, 0x10CE, 0x20D0, 0x1170, 0xFF1E, 0x0244, 0xFFC3, 0xE2CE, 0xCE5E, 0xE4AF, 0xE94F, 0xF4C3, 0xEF0F, 0xDC82,
    0xE3A7, 0xDB9C, 0x0629, 0xF640, 0xD483, 0xCEA4, 0xD862, 0xE989, 0xF965, 0xEE5B, 0xF0ED, 0xF3DF, 0xDC95, 0xFC09, 0xF0E4, 0xEE2E,
    0xF57F, 0x0DD1, 0x0359, 0xFB5A, 0xEFFB, 0xF6B8, 0xFC00, 0xED71, 0x0B2B, 0x187B, 0x232A, 0x1E1E, 0x2140, 0x2F00, 0x312D, 0x271B,
    0x28F6, 0x329D, 0x2BDF, 0x263D, 0x0BE4, 0x02FF, 0x21C1, 0x0AF7, 0x1779, 0x0F68, 0x12CA, 0x211F, 0x12EE, 0x1E94, 0x2BF3, 0x43C0,
    0x44C4, 0x46EB, 0x4ECC, 0x5548, 0x3C04, 0x316C, 0x1E9F, 0x4533, 0x52C4, 0x314F, 0x3E52, 0x3A21, 0x34BD, 0x2103, 0x135C, 0x01C9,
    0x0321, 0x0D4C, 0x034E, 0xF40E, 0x00D3, 0x0D5B, 0x1363, 0x139D, 0x0D72, 0x13BE, 0x0CC2, 0x0C51, 0x009C, 0xFBD2, 0x079A, 0x1A86,
    0x177F, 0x055B, 0xE912, 0xD1B4, 0xE03A, 0xCFCD, 0xBB2E, 0xB41A, 0xC581, 0xC99F, 0xC733, 0xD031, 0xC97C, 0xC843, 0xC345, 0xCFFE,
    0xD4F5, 0xDDE9, 0xE170, 0xD942, 0xDC34, 0xF6CE, 0x00F7, 0xFDB6, 0x0450, 0x0923, 0x0F1A, 0x0432, 0xF5FD, 0xFCE3, 0x10EE, 0x1DE8,
    0x2B7B, 0x1CB6, 0x137E, 0x2542, 0x2FA5, 0x2421, 0x2ACD, 0x3CF5, 0x2D39, 0x1CF8, 0x15E4, 0x236B, 0x2B03, 0x16A5, 0xF9C4, 0xEDAB,
    0xF3D2, 0xE056, 0xD80F, 0xE197, 0xE28B, 0xE637, 0xE894, 0xD9A3, 0xD894, 0xE5B3, 0xD7EB, 0xDD5D, 0xF40D, 0xFA5A, 0x003C, 0xF9DC,
    0xF395, 0xE56B, 0xD3F9, 0xDABE, 0xD32D, 0xDA4A, 0xE243, 0xDD76, 0xCD94, 0xBB27, 0xA781, 0xA7BB, 0xC4FF, 0xD6EE, 0xD67E, 0xCE4E,
    0xE169, 0xF35E, 0xFAA3, 0xFC33, 0x0EF7, 0x22CA, 0x201B, 0x2682, 0x3BAC, 0x362F, 0x1F62, 0x25B1, 0x2F7F, 0x2306, 0x22CB, 0x38A9,
    0x2D05, 0x2CE8, 0x2F51, 0x230D, 0x37FD, 0x342F, 0x451E, 0x3F34, 0x211D, 0x3762, 0x42F4, 0x41F4, 0x40FF, 0x4033, 0x3E96, 0x4CB5,
    0x43D8, 0x456F, 0x44E8, 0x272D, 0x17C3, 0x182A, 0x2A73, 0x1ABE, 0xF908, 0xF698, 0x0815, 0xF97B, 0xF8CE, 0x0727, 0x0896, 0xFB66,
    0x0041, 0x1A20, 0x0AE4, 0x0016, 0xFFA5, 0x0376, 0xECF0, 0xE447, 0xD632, 0xBDF6, 0xBB1B, 0xBD34, 0xC282, 0xB668, 0xB6EA, 0xBEAB,
    0xBE10, 0xAF0D, 0xB026, 0xB4F1, 0xC138, 0xCE46, 0xD3F8, 0xEF0D, 0xFE7A, 0xFC62, 0x0F23, 0x0272, 0xF93C, 0xF714, 0xF439, 0x00EB,
    0xFF00, 0x0053, 0xF4F3, 0xEF7A, 0xE571, 0xF8D9, 0xF87F, 0xF211, 0xFFE8, 0x089F, 0x1EDD, 0x2661, 0x179B, 0x28C3, 0x349A, 0x2431,
    0x1CE5, 0x077F, 0x1924, 0x17B8, 0x136D, 0x0B1B, 0xF690, 0xF877, 0xE8DF, 0xE4A6, 0xF61E, 0xEF18, 0xF48E, 0xF5FC, 0xE16D, 0xE67A,
    0xEBB7, 0xFB04, 0xEB46, 0xE887, 0xEA11, 0xDB7D, 0xD80F, 0xDDF1, 0xEBC0, 0xF482, 0xFDF5, 0x0593, 0x0ABF, 0x050F, 0x0408, 0x06A1,
    0x0476, 0xF36A, 0xE659, 0xE794, 0xE099, 0xE2EB, 0xFCAD, 0xFE4F, 0x0439, 0x0CEA, 0x1057, 0x20C1, 0x2AC3, 0x2F40, 0x307E, 0x3627,
    0x39F6, 0x36E5, 0x2BE9, 0x1D0F, 0x15DA, 0x11F3, 0x17C9, 0x124C, 0x1478, 0x2B48, 0x137C, 0x1F0C, 0x2369, 0x1B6B, 0x1411, 0x069A,
    0x1610, 0x0979, 0x1057, 0x0F04, 0x01B6, 0x0C38, 0x16DB, 0x09FA, 0x0C12, 0x0CBE, 0x0BA8, 0x1651, 0x020B, 0xF96A, 0xEC54, 0xD54E,
    0xE2D3, 0xF022, 0xF51E, 0xDC6F, 0xCD6F, 0xE27D, 0xF6EB, 0xFCED, 0xF8F3, 0xF2A9, 0xF138, 0xF602, 0xE47A, 0xF512, 0xFEF3, 0x0628,
    0xFCB3, 0xF7E9, 0xF501, 0xE12E, 0xCF98, 0xC99B, 0xDD2F, 0xE658, 0xEAD6, 0xC8E3, 0xBA7D, 0xC7C2, 0xD3B3, 0xC5D3, 0xBF8A, 0xD43E,
    0xDCD6, 0xDB0B, 0xDF0D, 0xD078, 0xC9A8, 0xE6BA, 0xF6BA, 0xEFD3, 0xE4AA, 0xF1CB, 0x0582, 0x0D37, 0x08D4, 0xF631, 0xF8FF, 0x01DE,
    0x0261, 0x047F, 0x07C3, 0x13BB, 0x1C86, 0x32CD, 0x2A16, 0x25E0, 0x2AEC, 0x48F9, 0x46C5, 0x35A3, 0x4035, 0x35F8, 0x311F, 0x2863,
    0x25FA, 0x0A6B, 0x01CE, 0x0396, 0x0CF7, 0x116A, 0x086C, 0xFBE2, 0x03E8, 0xFBE1, 0xEDE9, 0x0411, 0x03DB, 0xFC75, 0xDF68, 0xD8FE,
    0xEA6C, 0xE9B3, 0xE1FE, 0xE435, 0xF0A4, 0xE52A, 0xDDB7, 0xEEF3, 0xFF2E, 0xF5C1, 0xE289, 0xDBB0, 0xD622, 0xE1F2, 0xDD79, 0xE376,
    0xEA24, 0xE707, 0xE5C6, 0xE74E, 0xEECD, 0xE3B0, 0xE67D, 0xEFDB, 0x07A5, 0xFEE1, 0xEDC0, 0x04E3, 0x1401, 0x0452, 0xECF9, 0xE7F3,
    0xEDE0, 0xDEC1, 0xD15D, 0xDE36, 0xE9E3, 0xE320, 0xDD03, 0xE75B, 0xE6BD, 0xF0D4, 0xEBE2, 0xE73D, 0xF9AA, 0x152A, 0x1831, 0x19EA,
    0x2828, 0x27EF, 0x2A7C, 0x1E79, 0x2814, 0x2955, 0x31FD, 0x2CAB, 0x1F8B, 0x1D13, 0x09F0, 0x0AE0, 0x0E72, 0x166C, 0x2750, 0x2B6E,
    0x21F7, 0x1E9B, 0x17F3, 0x1E80, 0x2F00, 0x4115, 0x2FF8, 0x2BFF, 0x2B1C, 0x2386, 0x2880, 0x1A1C, 0x0FDF, 0x01D3, 0xF7F1, 0xF70C,
    0xF744, 0xF1D0, 0xF8AD, 0xE942, 0xE28E, 0xDEB7, 0xE5E8, 0xE294, 0xD3FF, 0xDDCF, 0xE4CF, 0xF631, 0xEE7B, 0xF4D9, 0x0B81, 0x0DDE,
    0x07F7, 0x0A46, 0x0F13, 0x014B, 0xF83E, 0xF844, 0xEEE1, 0xEC46, 0xE848, 0xE823, 0xF66D, 0xFFCD, 0x0ADD, 0x06AB, 0x1101, 0x0FBC,
    0x0AA1, 0x17FE, 0x1D35, 0x2234, 0x1AC7, 0x35B5, 0x3CF2, 0x38B4, 0x2BED, 0x24D0, 0x2A5A, 0x2C56, 0x2960, 0x17E6, 0x12E6, 0x0718,
    0x096C, 0x081C, 0x1260, 0x1523, 0x091A, 0xF47C, 0xF40B, 0x0610, 0x0C18, 0x06F7, 0x0108, 0xFF92, 0xFF6E, 0x0C72, 0x05FB, 0xF527,
    0xF973, 0xFCBB, 0xF4E0, 0xF54D, 0xE07A, 0xD57E, 0xD7AB, 0xDBC2, 0xD82F, 0xCABE, 0xD1E6, 0xDDED, 0xEF65, 0xEFB8, 0xEFF5, 0xF418,
    0xFA77, 0x0155, 0x0A9E, 0x1221, 0x09F6, 0x07BD, 0xFE5F, 0xFDFA, 0x025A, 0xFA83, 0xF52E, 0xF31F, 0xF115, 0xF707, 0xFB34, 0xFE3A,
    0xF241, 0xEB15, 0xEAD4, 0xEDB0, 0x0190, 0x0C15, 0x0E87, 0x160E, 0x2A23, 0x2FCC, 0x2DA1, 0x3184, 0x2161, 0x14A1, 0x25E8, 0x1A25,
    0x0594, 0xFD76, 0x04BD, 0x07A9, 0xF6CC, 0xF7FC, 0xF051, 0xEB5B, 0xEA96, 0xED12, 0xF3E3, 0xFC7D, 0x032D, 0xFCF7, 0xF488, 0xFAFE,
    0xF888, 0xF766, 0xFE69, 0xF9B9, 0xF5ED, 0xEF3C, 0xF171, 0xED85, 0xE56F, 0xD645, 0xDA7A, 0xDD2C, 0xDEFB, 0xDFCA, 0xD22D, 0xD6D5,
    0xD8C9, 0xE5FB, 0xE8D4, 0xFDC1, 0x17CA, 0x1704, 0x13BF, 0x1A6F, 0x2440, 0x2213, 0x2136, 0x2255, 0x2C96, 0x3ADC, 0x4008, 0x3B63,
    0x32FA, 0x2D05, 0x23B8, 0x14E7, 0x1536, 0x1C46, 0x1F9F, 0x20AC, 0x2593, 0x2F10, 0x47C6, 0x4E2E, 0x48CC, 0x3FDA, 0x3E5B, 0x488F,
    0x3C05, 0x3CC0, 0x27E1, 0x1FCE, 0x1498, 0x08A6, 0x0005, 0xEC3B, 0xF41D, 0xEF84, 0xEDD4, 0xEBB1, 0xD6C1, 0xCCE8, 0xC90E, 0xC420,
    0xCBA6, 0xC9B2, 0xD020, 0xCE72, 0xD64A, 0xD968, 0xDA9F, 0xE419, 0xD7F0, 0xD2B2, 0xC9FD, 0xCC37, 0xD0A1, 0xD088, 0xD29B, 0xC5C7,
    0xC39A, 0xC173, 0xB8A9, 0xC230, 0xCBDF, 0xD7FF, 0xDDE6, 0xED2E, 0xF3A6, 0xFDA3, 0x0883, 0x081B, 0x1111, 0x0BF4, 0x0610, 0xFC19,
    0xF4BC, 0xF8BC, 0x00F3, 0xFDB9, 0xFCB0, 0xFE45, 0x0323, 0xFF1C, 0x01C9, 0x0BE6, 0x0397, 0xFA1B, 0xF940, 0x0FAD, 0x14C6, 0x1606,
    0x1386, 0x136F, 0x2584, 0x341B, 0x4671, 0x488E, 0x446A, 0x4375, 0x4043, 0x3AAB, 0x2AEC, 0x2122, 0x18BD, 0x167A, 0x1634, 0x0319,
    0x0416, 0x0633, 0x0433, 0x00E4, 0x0120, 0x0358, 0x07CE, 0x1AD3, 0x224B, 0x1C58, 0x13A4, 0x0BED, 0x0049, 0xF11A, 0xDF70, 0xD87F,
    0xCB41, 0xC556, 0xC9C9, 0xCD3E, 0xC3B5, 0xBE18, 0xC348, 0xC2F8, 0xBD3E, 0xC395, 0xCCB8, 0xCCEA, 0xD66F, 0xE127, 0xF56C, 0x01C5,
    0x043E, 0x03A8, 0x03CF, 0xFDBA, 0x0D84, 0x1A03, 0x1ACB, 0x1A7B, 0x195F, 0x1B35, 0x0C1B, 0x032E, 0x0510, 0x0B62, 0x0E65, 0x19A0,
    0x17BD, 0x14E8, 0x169B, 0x1FDC, 0x2D80, 0x2F9E, 0x36E5, 0x36A7, 0x349A, 0x271A, 0x1AC6, 0x18E1, 0x14B7, 0x08CB, 0x017E, 0xFD98,
    0xF21D, 0xECF8, 0xEAB9, 0xEA91, 0xDE97, 0xD78B, 0xD3AD, 0xD390, 0xD4AD, 0xD5BB, 0xDBBE, 0xE694, 0xF307, 0xF0AB, 0xF2B3, 0xEF7B,
    0xE24A, 0xE268, 0xE74E, 0xED2B, 0xEE01, 0xE93C, 0xE690, 0xE19F, 0xE3E1, 0xE534, 0xE868, 0xED04, 0xFB25, 0x06AB, 0x09A9, 0x0B5B,
    0x17B1, 0x1D3A, 0x206D, 0x1E07, 0x1CBB, 0x29F0, 0x2DE7, 0x2EED, 0x2BD2, 0x2A88, 0x2991, 0x2271, 0x1677, 0x11C5, 0x04D3, 0x09CF,
    0x063B, 0x0289, 0x057C, 0x0632, 0x0A46, 0x0B88, 0x0E38, 0x0FAD, 0x128F, 0x14C8, 0x23B6, 0x2715, 0x1F89, 0x1927, 0x1603, 0x163E,
    0x1574, 0x0CAF, 0x0D4E, 0x0CBC, 0x0A8B, 0xF3AE, 0xE9C7, 0xF2D8, 0xF2EC, 0xEB22, 0xE800, 0xEC0C, 0xED9B, 0xF55A, 0xF1F8, 0xF7A9,
    0xF659, 0xF9C5, 0xF5D5, 0xEC28, 0xE1AC, 0xDA15, 0xDCCB, 0xD7C0, 0xD3E6, 0xC949, 0xBF4D, 0xBE12, 0xBCF7, 0xC02F, 0xC331, 0xBF4B,
    0xBFCA, 0xBEFA, 0xBE4F, 0xC1EF, 0xC7B0, 0xD5AA, 0xE613, 0xEF8B, 0xF651, 0xF6FD, 0x0541, 0x0E5F, 0x09D2, 0x0ACA, 0x0E79, 0x15A8,
    0x148D, 0x11C7, 0x0840, 0x031B, 0x03D0, 0x00F9, 0x030C, 0x06F3, 0x0E41, 0x0F03, 0x0EDE, 0x1F61, 0x2F60, 0x3517, 0x395E, 0x394E,
    0x3D72, 0x3FFD, 0x426C, 0x426E, 0x393F, 0x38CF, 0x3675, 0x33FC, 0x305F, 0x2CA6, 0x2322, 0x1B7C, 0x1C79, 0x19D1, 0x0FD8, 0x01D5,
    0x02F5, 0x025D, 0x0555, 0x08C7, 0x0E4F, 0x14A5, 0x13B7, 0x1344, 0x0D97, 0x0A4A, 0x0D68, 0x0FF2, 0x0B8F, 0x0977, 0x0281, 0xF4E5,
    0xEDF9, 0xE542, 0xE229, 0xDF50, 0xDEBC, 0xE5C1, 0xE27F, 0xE95A, 0xF565, 0xFE75, 0x0541, 0x0A20, 0x0CF8, 0x0A1A, 0x0319, 0xFDEB,
    0xFC5A, 0x01E9, 0x0822, 0x071A, 0x024A, 0xF8CD, 0xF968, 0xFF1C, 0xFDC6, 0xF74D, 0xF3FC, 0xF065, 0xEA61, 0xE447, 0xE5D5, 0xE939,
    0xEC36, 0xF49F, 0x01F0, 0x1068, 0x1874, 0x22DD, 0x2233, 0x22C5, 0x2ECC, 0x3294, 0x3BDD, 0x3D3D, 0x34B3, 0x32AA, 0x2C54, 0x237A,
    0x16FE, 0x09C6, 0x0938, 0x086B, 0x0F18, 0x141B, 0x117D, 0x1B15, 0x1EB2, 0x22B7, 0x1D93, 0x1738, 0x11E0, 0x09EB, 0x0E2B, 0x081B,
    0xFD85, 0xF44C, 0xEE8B, 0xECF2, 0xE2AD, 0xD95E, 0xD21E, 0xC80B, 0xBE15, 0xBCD3, 0xBE9B, 0xBE30, 0xC028, 0xC485, 0xCB2D, 0xCF0D,
    0xD285, 0xD8CB, 0xDD94, 0xE00E, 0xE3EC, 0xED2D, 0xF30A, 0xF01B, 0xF4CB, 0xF6FD, 0xF817, 0xF964, 0xF745, 0xEEFB, 0xEC2E, 0xEA9E,
    0xE993, 0xE930, 0xE453, 0xE886, 0xF30F, 0x0630, 0x119D, 0x1CB5, 0x2378, 0x2B63, 0x344C, 0x3709, 0x3374, 0x2F48, 0x2906, 0x2CB5,
    0x2F6C, 0x20E6, 0x1D9E, 0x1B5F, 0x216B, 0x1F75, 0x1CA4, 0x16E9, 0x1009, 0x0C78, 0x0905, 0x0966, 0x0022, 0x015A, 0x081D, 0x171D,
    0x1DB3, 0x1CB6, 0x1E62, 0x20C8, 0x2A83, 0x25BD, 0x1AA2, 0x124F, 0x054F, 0xFB56, 0xF1AB, 0xE894, 0xE554, 0xEC8D, 0xF9BD, 0x0395,
    0x08F0, 0x0C16, 0x0F63, 0x13DA, 0x13B6, 0x0DA0, 0x10B4, 0x1757, 0x17C5, 0x11F2, 0x1367, 0x1288, 0x0E94, 0x088E, 0x0667, 0xFEC2,
    0xEA91, 0xE23C, 0xE05D, 0xE26D, 0xDC85, 0xDC6E, 0xD97B, 0xD1F5, 0xD3C9, 0xD6C2, 0xD964, 0xE4C7, 0xF8D3, 0x090B, 0x0E00, 0x1289,
    0x133C, 0x12AC, 0x1B20, 0x1A52, 0x1914, 0x15E6, 0x19E2, 0x13E8, 0x051E, 0x0269, 0x0416, 0x05CC, 0x0A60, 0x04E2, 0xF818, 0xF397,
    0xFA0A, 0x0216, 0xFD31, 0x0635, 0x0F17, 0x10E0, 0x11B7, 0x0A51, 0x02FB, 0xFA88, 0xEDD4, 0xDCAF, 0xCD4D, 0xCAB9, 0xC370, 0xC00A,
    0xC30A, 0xC3DC, 0xC4F6, 0xBE9A, 0xC175, 0xBE67, 0xBABC, 0xBFA7, 0xC174, 0xCA69, 0xD82C, 0xE07F, 0xEB0A, 0xF58D, 0x0015, 0x085F,
    0x0F71, 0x155C, 0x1279, 0x0C09, 0x05FC, 0x0B4E, 0x0887, 0x00D7, 0x0309, 0x0217, 0x021D, 0x0672, 0x10C6, 0x21A0, 0x2914, 0x2889,
    0x2DA8, 0x355B, 0x3CB2, 0x408F, 0x3F8C, 0x38E8, 0x345E, 0x34B0, 0x2F3F, 0x2D52, 0x2904, 0x193E, 0x0EB7, 0x021F, 0xF1EB, 0xE4BA,
    0xDF2E, 0xDE5B, 0xD5F9, 0xCD99, 0xCBEA, 0xD21A, 0xD5E0, 0xD404, 0xD2A7, 0xD320, 0xD94F, 0xDF7B, 0xDC02, 0xDCFE, 0xE164, 0xE44E,
    0xE0A0, 0xD49B, 0xD036, 0xC7E6, 0xC290, 0xC1F6, 0xC40E, 0xC8E7, 0xCD13, 0xD6F4, 0xD97F, 0xE0DA, 0xEC2A, 0xF2B5, 0xFBCC, 0x0291,
    0x0CBF, 0x1254, 0x128E, 0x1425, 0x11C6, 0x0ECB, 0x0A36, 0x08FE, 0x078C, 0x092A, 0x0830, 0x0237, 0xFFA8, 0xFD92, 0xFBF9, 0xFAD4,
    0xFE9E, 0x00DD, 0x03AF, 0x0569, 0x0CEF, 0x1380, 0x1A49, 0x21DD, 0x208C, 0x2629, 0x2C98, 0x3027, 0x3480, 0x346C, 0x311A, 0x2CF1,
    0x2254, 0x170D, 0x0A58, 0x0304, 0x020F, 0x050A, 0x06AE, 0x044C, 0x0995, 0x0D0B, 0x1575, 0x1A09, 0x16F5, 0x13FE, 0x0EA8, 0x0E00,
    0x09B5, 0x04A1, 0xF8EC, 0xE979, 0xE7C4, 0xE650, 0xE26D, 0xE146, 0xD98A, 0xD095, 0xD0D4, 0xD36F, 0xD4B5, 0xD336, 0xD560, 0xD824,
    0xD73C, 0xD7BB, 0xDDB6, 0xE5B3, 0xE5B9, 0xE981, 0xEFB0, 0xF89F, 0x03CB, 0x0BF0, 0x1157, 0x102C, 0x0ED2, 0x0A3D, 0x0272, 0xFCEA,
    0xF738, 0xF5C4, 0xFC1B, 0xFF1A, 0x0125, 0x0303, 0x02D8, 0x0554, 0x0696, 0x0817, 0x06F7, 0x065E, 0x09A2, 0x11EA, 0x13D6, 0x0CC7,
    0x07D9, 0x04D4, 0x0197, 0xFAE0, 0xF773, 0xF179, 0xEB89, 0xE3E3, 0xDBDD, 0xD81D, 0xD7BD, 0xD860, 0xCDC3, 0xCC31, 0xCB58, 0xCA08,
    0xD164, 0xD7CF, 0xDF33, 0xDCBF, 0xDC45, 0xDE59, 0xDF62, 0xE5FE, 0xEB45, 0xE9E1, 0xDDBE, 0xD6D5, 0xDBB2, 0xDA8E, 0xD7A7, 0xD795,
    0xD54C, 0xDA74, 0xDEA6, 0xEA84, 0xF703, 0xF8C0, 0x014E, 0x0EB6, 0x20E9, 0x28B8, 0x2D63, 0x30F3, 0x331B, 0x3835, 0x3520, 0x2FAD,
    0x234A, 0x1EA3, 0x2022, 0x210E, 0x1FEF, 0x1ACE, 0x1B17, 0x1DD1, 0x1965, 0x1718, 0x1B7B, 0x1AD7, 0x1AF6, 0x1E51, 0x21A3, 0x21DE,
    0x243F, 0x2D30, 0x3396, 0x37B9, 0x3E47, 0x3C35, 0x38B3, 0x37DA, 0x38E8, 0x321F, 0x2551, 0x1B12, 0x1370, 0x0C8C, 0x0398, 0xFEBD,
    0xFBE2, 0xF92E, 0xF5DD, 0xFFFE, 0x0581, 0x01B8, 0x02D7, 0x0783, 0x0255, 0xFB2B, 0xF3DC, 0xEE22, 0xE418, 0xD279, 0xCF32, 0xCC7D,
    0xCC80, 0xCA6B, 0xC895, 0xC24F, 0xBFE4, 0xBDB4, 0xB98B, 0xBAD7, 0xB9E8, 0xBE06, 0xC06B, 0xC882, 0xD455, 0xE031, 0xEAC4, 0xF6A2,
    0xFF9C, 0x05BC, 0x085C, 0x0567, 0x0707, 0x068E, 0x03E4, 0x05D9, 0x0A28, 0x07F9, 0x0341, 0x05E9, 0x0D86, 0x1507, 0x1A6B, 0x202D,
    0x22E0, 0x23E9, 0x251C, 0x251C, 0x2BCA, 0x2EE6, 0x302E, 0x31F6, 0x3047, 0x2BF9, 0x253F, 0x1BFA, 0x10D4, 0x0BBC, 0x0436, 0xFF20,
    0xFD84, 0xF6CF, 0xF0DF, 0xEA1F, 0xE07F, 0xDE70, 0xE169, 0xE196, 0xE23A, 0xE026, 0xE2BA, 0xDEBD, 0xD6D1, 0xDE34, 0xE8A5, 0xEFE9,
    0xEE70, 0xEB00, 0xE900, 0xE9B1, 0xE677, 0xD95E, 0xD2AB, 0xCF3C, 0xD091, 0xD512, 0xD9B1, 0xDE7B, 0xDD69, 0xDF5C, 0xE692, 0xEF15,
    0xF7D2, 0xFAE7, 0xFB2F, 0xFC01, 0xFC84, 0xFC00, 0xFC20, 0xFB96, 0xF8F3, 0xF996, 0xFA72, 0xF7BD, 0xF65F, 0xF4BB, 0xF0DA, 0xEDB9,
    0xE75C, 0xE798, 0xED9B, 0xF0BE, 0xF267, 0xF45E, 0xFD73, 0x0A57, 0x16C1, 0x1ECB, 0x281C, 0x309B, 0x3468, 0x36FE, 0x3ABC, 0x3DF8,
    0x3F00, 0x4280, 0x4225, 0x3E51, 0x38E1, 0x365A, 0x36E4, 0x3668, 0x3315, 0x335E, 0x3987, 0x3E26, 0x3DAF, 0x394D, 0x39F1, 0x39F9,
    0x35DB, 0x3278, 0x2C9A, 0x279B, 0x25AE, 0x22DB, 0x1DFA, 0x0B43, 0xF674, 0xE76C, 0xDF23, 0xDB8D, 0xD45E, 0xCE08, 0xC6A7, 0xC383,
    0xC00F, 0xB920, 0xB7B8, 0xBCFA, 0xC1D2, 0xC6C0, 0xCE7A, 0xD4BD, 0xD667, 0xDACE, 0xE13E, 0xE4FD, 0xE9FF, 0xF1A2, 0xF673, 0xF46A,
    0xF011, 0xEEF9, 0xEE51, 0xEABF, 0xE6A5, 0xE60B, 0xEB00, 0xEF6B, 0xF7DE, 0xFE37, 0x0147, 0x09D0, 0x0EB3, 0x100C, 0x1625, 0x2008,
    0x2599, 0x2907, 0x2EC3, 0x2C13, 0x25BA, 0x23E2, 0x1D25, 0x193F, 0x15C2, 0x11F1, 0x10BB, 0x0E8C, 0x0EA6, 0x024A, 0xF4EA, 0xF0B1,
    0xEC5C, 0xEF5F, 0xF6D9, 0xFDB3, 0x0219, 0x04A0, 0x0B29, 0x0D63, 0x0D69, 0x0E8A, 0x07CD, 0xFF0B, 0xF4D7, 0xECB7, 0xE784, 0xE6A7,
    0xE76B, 0xE104, 0xDF20, 0xDF2E, 0xDDD8, 0xE32C, 0xE62E, 0xE5B1, 0xE615, 0xE696, 0xED35, 0xF55D, 0xFD31, 0x01E1, 0x0383, 0x01EF,
    0xFDB5, 0x02F7, 0x0044, 0xF764, 0xF29F, 0xEE9A, 0xEFC9, 0xEBB4, 0xE912, 0xE8C3, 0xE711, 0xE795, 0xE9EC, 0xEE6E, 0xED2B, 0xED4A,
    0xF2FB, 0xF6BD, 0xF797, 0xF75E, 0xFF99, 0x08A8, 0x122A, 0x1B80, 0x20DF, 0x23F8, 0x1F76, 0x1C44, 0x182B, 0x127F, 0x0D49, 0x102C,
    0x1434, 0x1284, 0x1068, 0x1017, 0x13ED, 0x17BA, 0x1E13, 0x21DD, 0x24DC, 0x2599, 0x2878, 0x2714, 0x1E01, 0x1973, 0x1126, 0x0448,
    0xFBD0, 0xF54F, 0xEB80, 0xE6BD, 0xE167, 0xDC16, 0xD7A1, 0xD517, 0xD2E6, 0xCB89, 0xC69C, 0xC4E7, 0xC7C8, 0xCE37, 0xD953, 0xE509,
    0xE8FB, 0xE9FB, 0xEC1D, 0xF09D, 0xF63A, 0xFB77, 0x05AA, 0x0B4F, 0x0BBC, 0x0B3D, 0x06C2, 0x04D4, 0x05D2, 0x05F3, 0x086A, 0x0D9E,
    0x1427, 0x18F7, 0x1B10, 0x1DBE, 0x1E49, 0x21E1, 0x2ABB, 0x33CA, 0x3F85, 0x474D, 0x4858, 0x47FF, 0x42CB, 0x3D1D, 0x3728, 0x2C3E,
    0x1F82, 0x153F, 0x0F34, 0x097C, 0x04E7, 0xFFBB, 0xFAB6, 0xF8D1, 0xF570, 0xF533, 0xF59D, 0xF65A, 0xF959, 0xF99E, 0xFFFA, 0x02EE,
    0xFE66, 0x002F, 0xFE9B, 0xFA62, 0xF807, 0xF53B, 0xF0D6, 0xE4BA, 0xD66F, 0xCDC1, 0xC6BB, 0xBFEE, 0xBD4E, 0xBE94, 0xC2EE, 0xC6D1,
    0xCC0A, 0xD01C, 0xD366, 0xD72E, 0xDEC6, 0xE8E3, 0xEBAA, 0xE9A8, 0xE742, 0xE864, 0xED94, 0xF436, 0xFAC9, 0xFC4A, 0xFACC, 0xF5B6,
    0xEE4C, 0xEA8D, 0xE5C0, 0xDFE1, 0xDE0C, 0xE190, 0xE396, 0xE78A, 0xEFDB, 0xFBD4, 0x0385, 0x0787, 0x0E0D, 0x1103, 0x17BF, 0x22C1,
    0x2C5E, 0x3058, 0x2D4A, 0x2748, 0x21D4, 0x1B78, 0x143D, 0x1394, 0x172B, 0x1889, 0x14C3, 0x0F6F, 0x0B02, 0x09AE, 0x0F47, 0x166C,
    0x18AB, 0x156A, 0x15FC, 0x1A96, 0x1DD3, 0x235D, 0x25F4, 0x20B1, 0x1749, 0x025D, 0xEEBD, 0xE1FF, 0xD983, 0xD92B, 0xD4AF, 0xD2DF,
    0xCF14, 0xCD67, 0xD297, 0xD5E2, 0xDAE5, 0xDA74, 0xDCA6, 0xE3E7, 0xE92E, 0xEFCD, 0xF563, 0x0002, 0x071C, 0x09C7, 0x1367, 0x1CCF,
    0x2631, 0x279E, 0x2084, 0x1E26, 0x1BD4, 0x17DF, 0x16FD, 0x1352, 0x158D, 0x1BC7, 0x21E1, 0x2A51, 0x2FAC, 0x32F7, 0x30DE, 0x2C28,
    0x2726, 0x248A, 0x2309, 0x2323, 0x2354, 0x1EF5, 0x18AD, 0x11CB, 0x0B6C, 0x06FD, 0x0332, 0xFD2B, 0xF806, 0xF2A6, 0xEAC7, 0xE1E4,
    0xDA8D, 0xD53A, 0xD320, 0xD901, 0xE157, 0xE3A3, 0xE67F, 0xEA2E, 0xECF3, 0xEE29, 0xEDC6, 0xED98, 0xEAD1, 0xEC77, 0xEF94, 0xF14E,
    0xED2D, 0xE674, 0xE458, 0xE159, 0xDF56, 0xDC4B, 0xDEB6, 0xE387, 0xEA0D, 0xF377, 0xFAF6, 0x02DA, 0x0C15, 0x1967, 0x1FD9, 0x2083,
    0x2023, 0x2037, 0x1E3F, 0x1C3B, 0x1ED3, 0x1C52, 0x182B, 0x13FB, 0x0FA5, 0x0C79, 0x087B, 0x0179, 0xF71D, 0xF002, 0xECC1, 0xF12A,
    0xF41C, 0xF113, 0xF31E, 0xF987, 0xFFAD, 0xFF83, 0x0192, 0x09E6, 0x0E64, 0x0CEC, 0x0991, 0x09A4, 0x0A4D, 0x098A, 0x05F0, 0xFEF4,
    0xFAD5, 0xFA3F, 0xF239, 0xE8C0, 0xE859, 0xEA93, 0xEFDD, 0xF469, 0xFA75, 0xFED9, 0xFFCA, 0x0147, 0xFFB4, 0x027F, 0x03EF, 0x0057,
    0xFA4D, 0xF0D4, 0xE887, 0xE0A8, 0xDA82, 0xD315, 0xCCED, 0xC7E1, 0xC2E7, 0xBF50, 0xBC61, 0xBE4F, 0xBCEF, 0xBD2F, 0xC382, 0xCBF2,
    0xD72B, 0xE31F, 0xECF3, 0xF81E, 0x02F0, 0x0912, 0x10FD, 0x19A2, 0x1F56, 0x22A5, 0x245D, 0x245D, 0x2408, 0x27F9, 0x2D76, 0x2ED5,
    0x2D47, 0x2A59, 0x2CD0, 0x3607, 0x40E7, 0x4B4D, 0x4D38, 0x4C64, 0x4DE2, 0x4D6E, 0x4D86, 0x4B39, 0x4A14, 0x48FF, 0x4585, 0x40FC,
    0x3C14, 0x33DE, 0x2B39, 0x228E, 0x1CC1, 0x1BAB, 0x15B1, 0x0D69, 0x040E, 0xFCFE, 0xF49E, 0xEEC0, 0xEB12, 0xE882, 0xEA28, 0xF137,
    0xF9ED, 0xF967, 0xF39D, 0xEFD9, 0xF204, 0xF39F, 0xF209, 0xEFD9, 0xE96E, 0xDE25, 0xD1C2, 0xCB1E, 0xC930, 0xC68E, 0xC87C, 0xCA6F,
    0xCC26, 0xCEAC, 0xCFCA, 0xD251, 0xD7B9, 0xE094, 0xE942, 0xF002, 0xF138, 0xF2D6, 0xF7CE, 0xFA63, 0xFA3F, 0xF92B, 0xF5A1, 0xF45E,
    0xF7D3, 0xF7B1, 0xF758, 0xF52D, 0xF1C2, 0xF00F, 0xEC9D, 0xED20, 0xEDCA, 0xEE61, 0xF34D, 0xF857, 0x0162, 0x07E3, 0x0933, 0x09FC,
    0x0A6C, 0x0F03, 0x1329, 0x1A55, 0x2289, 0x288D, 0x2B9F, 0x2BF5, 0x2A12, 0x2400, 0x1D86, 0x17E5, 0x1382, 0x1325, 0x1632, 0x1946,
    0x1FF8, 0x27CC, 0x2CC2, 0x2EF8, 0x31A0, 0x34AA, 0x320A, 0x2B76, 0x24DB, 0x1EF7, 0x1D57, 0x1646, 0x0A4B, 0xFC2F, 0xEF2D, 0xE441,
    0xDA32, 0xD6A8, 0xD48D, 0xD129, 0xC9BC, 0xC4CA, 0xBF3B, 0xC01B, 0xC623, 0xCA29, 0xCC98, 0xD0AB, 0xDA09, 0xE143, 0xE3E8, 0xDEBB,
    0xDC98, 0xDD01, 0xDDB7, 0xE184, 0xE5C2, 0xEB6A, 0xEEEE, 0xEE2C, 0xECAB, 0xEDDC, 0xF331, 0xF88D, 0xFC66, 0x0287, 0x08D5, 0x0CA8,
    0x136D, 0x1E5E, 0x25AB, 0x2A3F, 0x3213, 0x3A6B, 0x3A83, 0x352A, 0x33A4, 0x345C, 0x2F4B, 0x2816, 0x2355, 0x1F22, 0x1BDA, 0x193E,
    0x152C, 0x12A1, 0x1247, 0x118D, 0x109C, 0x1290, 0x16E3, 0x18DB, 0x1952, 0x18F6, 0x1BC8, 0x1CE1, 0x1E06, 0x1F99, 0x2159, 0x2153,
    0x19B6, 0x111D, 0x06E6, 0x0073, 0xFC21, 0xF674, 0xF13D, 0xEAA3, 0xE704, 0xE5DB, 0xE647, 0xEA81, 0xED7B, 0xF48B, 0xFBA1, 0xFD5D,
    0x01D3, 0x0761, 0x09B0, 0x0729, 0x02EC, 0xFE17, 0xF6B2, 0xEEFF, 0xEEB1, 0xEEB2, 0xEF00, 0xEE62, 0xEC1F, 0xE695, 0xDC83, 0xD891,
    0xD63B, 0xD81F, 0xDA7C, 0xDFC8, 0xE824, 0xECF6, 0xF032, 0xF6A9, 0x030D, 0x0E6B, 0x146F, 0x1950, 0x2101, 0x28F3, 0x2CDD, 0x2B5A,
    0x28F5, 0x2441, 0x22C1, 0x23A1, 0x207A, 0x1B4D, 0x1646, 0x1539, 0x1705, 0x17BC, 0x18F1, 0x1C83, 0x1E24, 0x1CAD, 0x1A59, 0x1925,
    0x1556, 0x10F4, 0x0C0F, 0x04B7, 0xFCE2, 0xF336, 0xE818, 0xDA38, 0xCF2B, 0xC987, 0xC55B, 0xBF18, 0xB86D, 0xB591, 0xB29E, 0xB0DF,
    0xB33B, 0xB57D, 0xB9C0, 0xC03F, 0xC6BC, 0xCC44, 0xD134, 0xD54B, 0xD8E6, 0xDEDB, 0xE70B, 0xF1B3, 0xFA06, 0xFD6B, 0x00BE, 0x0473,
    0x05C8, 0x0581, 0x03F3, 0x0514, 0x06D4, 0x072F, 0x0951, 0x0BCB, 0x133D, 0x1C1D, 0x2270, 0x29F1, 0x2F65, 0x3406, 0x37FC, 0x3A2B,
    0x3B33, 0x3763, 0x3117, 0x2A45, 0x24ED, 0x2585, 0x2351, 0x1DB9, 0x183C, 0x10C2, 0x0C0B, 0x0644, 0xFF6A, 0xFD2B, 0xFF0B, 0x030B,
    0x07E6, 0x0CD4, 0x0FD6, 0x1022, 0x0FDC, 0x0F61, 0x1048, 0x10EB, 0x0F2B, 0x0D00, 0x0978, 0x05B6, 0x012D, 0xF8C2, 0xEE9F, 0xE80A,
    0xE4DA, 0xE1A2, 0xDD6F, 0xDDDA, 0xE0AA, 0xE3F3, 0xE76C, 0xE885, 0xE940, 0xE900, 0xEDF2, 0xF576, 0xFB20, 0xFF8D, 0x0017, 0xFE3B,
    0xF980, 0xF32A, 0xECA5, 0xE82E, 0xE5D0, 0xE558, 0xE5C1, 0xE75D, 0xE7F6, 0xE3D3, 0xE286, 0xE349, 0xE5F5, 0xEC05, 0xF66A, 0xFFAC,
    0x0583, 0x0D1C, 0x12EE, 0x16F1, 0x1B10, 0x20D4, 0x2603, 0x2936, 0x2C79, 0x2DAD, 0x2D77, 0x296F, 0x2105, 0x19CC, 0x15DD, 0x14BF,
    0x13E2, 0x1701, 0x1D0B, 0x22C7, 0x2768, 0x2D06, 0x31A8, 0x3448, 0x374D, 0x33E8, 0x2D32, 0x27EA, 0x21F7, 0x1ABB, 0x11B8, 0x071D,
    0xFCED, 0xF0CD, 0xE0D9, 0xD30D, 0xCA7E, 0xC2B1, 0xBD56, 0xBABD, 0xBB31, 0xBD1A, 0xC086, 0xC5C7, 0xC95F, 0xCD15, 0xD0FD, 0xD672,
    0xD8B3, 0xDAF2, 0xE10F, 0xEAF9, 0xF4BD, 0xF8C7, 0xFCBB, 0xFC60, 0xF7E6, 0xF5CE, 0xF372, 0xF296, 0xF0B8, 0xEEC6, 0xF63B, 0x015F,
    0x0CB0, 0x14E5, 0x1768, 0x17E1, 0x170D, 0x1A9B, 0x1EC2, 0x2221, 0x269C, 0x2911, 0x28E5, 0x2480, 0x1D46, 0x15F7, 0x0B3C, 0xFE6D,
    0xF60B, 0xF3F3, 0xF467, 0xEF55, 0xEA9D, 0xE68D, 0xE29E, 0xE06A, 0xDF3F, 0xE254, 0xE751, 0xEC77, 0xEF66, 0xF039, 0xF1D8, 0xF611,
    0xF99F, 0xFE3B, 0x0629, 0x0BC0, 0x09A7, 0x042E, 0x00F6, 0xFD02, 0xF766, 0xEE66, 0xE9C6, 0xEB5F, 0xEF56, 0xF6F5, 0x003C, 0x0A5A,
    0x116D, 0x1A3E, 0x233B, 0x2A6A, 0x2D8D, 0x3000, 0x34A0, 0x340B, 0x3126, 0x2CB9, 0x29FD, 0x24E7, 0x1E97, 0x1C7A, 0x1C29, 0x18BA,
    0x133B, 0x0DC3, 0x0A65, 0x08C3, 0x073B, 0x08FC, 0x09C9, 0x0A79, 0x0AAD, 0x0B5F, 0x0C4C, 0x0BE6, 0x0CEF, 0x0DD2, 0x0C37, 0x0B11,
    0x0BF4, 0x0DD9, 0x0D34, 0x0B1C, 0x0BA1, 0x0989, 0x06B4, 0x0259, 0xFE3C, 0xF9D8, 0xF564, 0xF2B9, 0xEFD2, 0xEDF9, 0xEE43, 0xF317,
    0xF9AB, 0x0072, 0x0535, 0x05A8, 0x029B, 0xFD5B, 0xF6BB, 0xEFA7, 0xE977, 0xE52B, 0xE09B, 0xDAE7, 0xD54A, 0xD0B8, 0xCAFF, 0xC3DE,
    0xBF8D, 0xBE22, 0xBFD8, 0xC429, 0xCC16, 0xD4BE, 0xDD0E, 0xE6F3, 0xEFF6, 0xF9E7, 0x0113, 0x06CD, 0x0DE9, 0x0F98, 0x0E66, 0x0EE7,
    0x0FAA, 0x1020, 0x0EBE, 0x0EA1, 0x0FA8, 0x0E3E, 0x0FC0, 0x12B8, 0x169A, 0x1AE5, 0x1ECC, 0x26CC, 0x2C91, 0x2DBA, 0x2F2D, 0x2F50,
    0x2F4F, 0x2EE0, 0x2E3F, 0x2CA3, 0x27E7, 0x2223, 0x1A1B, 0x1484, 0x0E5B, 0x0571, 0xFFC0, 0xF9CB, 0xF5B9, 0xEFCD, 0xE7FB, 0xE5A5,
    0xE2F5, 0xE3FE, 0xE7C0, 0xEC86, 0xF1F3, 0xF2CF, 0xF36C, 0xF20B, 0xF26E, 0xF2F8, 0xF279, 0xF3BA, 0xF213, 0xED45, 0xE598, 0xDCE0,
    0xD6B9, 0xD480, 0xD5CF, 0xD6DE, 0xD3B1, 0xD496, 0xD6A5, 0xD829, 0xDC34, 0xE04C, 0xE355, 0xE78C, 0xEE57, 0xF402, 0xF88E, 0xFD14,
    0x02C9, 0x0423, 0x03A4, 0x057A, 0x0667, 0x01DC, 0xFC1D, 0xF91C, 0xF8D5, 0xF7A9, 0xF7BF, 0xFBC1, 0xFCAE, 0xFE8B, 0x0264, 0x08CF,
    0x0DCD, 0x1164, 0x187E, 0x1D5C, 0x226F, 0x266B, 0x2B5F, 0x3493, 0x3999, 0x4033, 0x43EE, 0x418D, 0x4031, 0x3D58, 0x3805, 0x30EE,
    0x2D39, 0x2EFD, 0x2E03, 0x2C2B, 0x2E97, 0x3344, 0x3545, 0x31CF, 0x33EC, 0x35E2, 0x33D4, 0x32D7, 0x32AA, 0x338E, 0x2E27, 0x27EA,
    0x217D, 0x16B4, 0x0B23, 0xFD93, 0xF416, 0xEAC3, 0xDF8B, 0xD743, 0xCF63, 0xC77E, 0xC0B1, 0xBD72, 0xBC99, 0xBABE, 0xB874, 0xBA6E,
    0xC098, 0xC58A, 0xC88D, 0xCD8A, 0xD1D0, 0xD5A6, 0xDB9B, 0xE1E4, 0xE86E, 0xEF81, 0xF523, 0xF79A, 0xF741, 0xF726, 0xF9AB, 0xFE0E,
    0xFF1B, 0xFE7B, 0xFF26, 0x0196, 0x03FF, 0x06E0, 0x0F36, 0x1566, 0x180A, 0x1A88, 0x207D, 0x2591, 0x245B, 0x219B, 0x1C6B, 0x13D0,
    0x0B16, 0x065D, 0x0390, 0x00B3, 0xFF2E, 0xFEFC, 0xFCD7, 0xF6E3, 0xF016, 0xEBAA, 0xEB91, 0xEDBB, 0xF4B7, 0xFC78, 0x00A9, 0x026C,
    0x03CA, 0x04AD, 0x06BD, 0x0C0E, 0x0F8F, 0x10ED, 0x102D, 0x0CF5, 0x05B0, 0xFCB3, 0xF174, 0xE943, 0xE530, 0xE1AE, 0xE20E, 0xE347,
    0xE51B, 0xE7AF, 0xED90, 0xF33E, 0xF6ED, 0xFA5F, 0xFCB8, 0xFD6D, 0xFC9E, 0xFD44, 0xFC16, 0xF659, 0xEE2B, 0xE8DD, 0xE6CB, 0xE33D,
    0xE1FE, 0xE163, 0xE30C, 0xE7B1, 0xE984, 0xE964, 0xE6C2, 0xE968, 0xF08F, 0xF674, 0xFEB0, 0x04C5, 0x0A0A, 0x10F8, 0x17DA, 0x1F5F,
    0x255F, 0x2B8A, 0x2FAB, 0x31D8, 0x3407, 0x3569, 0x39DB, 0x3B86, 0x3A58, 0x3A07, 0x37DF, 0x3600, 0x341D, 0x33D5, 0x33F5, 0x31F9,
    0x2FFB, 0x30B1, 0x33A7, 0x35FF, 0x351F, 0x346E, 0x32C4, 0x2E20, 0x2696, 0x1A24, 0x0E7D, 0x041F, 0xFA2D, 0xEED1, 0xE369, 0xD782,
    0xCC4B, 0xC430, 0xBD4A, 0xB991, 0xB8DD, 0xBA7D, 0xBC45, 0xBD6F, 0xC09E, 0xC335, 0xC440, 0xC538, 0xC776, 0xCCA6, 0xD073, 0xD4A1,
    0xDAF1, 0xE2FA, 0xEB60, 0xF13C, 0xF41E, 0xF3B4, 0xF15C, 0xEE7D, 0xEDAD, 0xF07E, 0xF7B0, 0x00E9, 0x0BAA, 0x1435, 0x1BBD, 0x246C,
    0x29D6, 0x2DBD, 0x32B3, 0x394A, 0x3DA0, 0x41C0, 0x4311, 0x420B, 0x40CB, 0x3A58, 0x3406, 0x30ED, 0x2E40, 0x2B50, 0x2643, 0x1ECE,
    0x1906, 0x121F, 0x0B5C, 0x05C6, 0x0162, 0x0234, 0x0596, 0x0878, 0x0518, 0x008F, 0x0135, 0x010F, 0x0191, 0x0251, 0x00C6, 0xFC0B,
    0xF468, 0xEED5, 0xE8D5, 0xE001, 0xD7F7, 0xD1B4, 0xCC62, 0xC6FD, 0xC53A, 0xC66F, 0xC668, 0xCAA1, 0xD11B, 0xD690, 0xDAC0, 0xDEE8,
    0xE5FB, 0xEC0E, 0xF06C, 0xF49A, 0xF5F0, 0xF32E, 0xED20, 0xE888, 0xE7E5, 0xE702, 0xE5B6, 0xE4EC, 0xE227, 0xE08E, 0xE002, 0xE020,
    0xE396, 0xE6B8, 0xEDBF, 0xF511, 0xFA4B, 0xFE15, 0x00B9, 0x054A, 0x0AE6, 0x1569, 0x1F0F, 0x2228, 0x2307, 0x2566, 0x267E, 0x266F,
    0x255C, 0x247C, 0x25D1, 0x26DA, 0x29E6, 0x2BE1, 0x2A48, 0x2894, 0x2C0A, 0x3540, 0x3BB7, 0x40DF, 0x4590, 0x4968, 0x4C16, 0x4B98,
    0x483D, 0x40A0, 0x35C1, 0x2A92, 0x205D, 0x16B2, 0x0B67, 0x0338, 0xFE48, 0xF911, 0xF357, 0xEA15, 0xDFF0, 0xD76C, 0xD28B, 0xD047,
    0xD2CD, 0xD6B6, 0xD914, 0xDC6C, 0xE08E, 0xE54D, 0xE90B, 0xEB75, 0xEC08, 0xEAF1, 0xEB99, 0xEDCE, 0xF109, 0xF597, 0xF747, 0xF838,
    0xF7C5, 0xF6FC, 0xFA8E, 0xFDFE, 0xFFBA, 0x009C, 0x02D8, 0x0719, 0x0A70, 0x0F57, 0x1344, 0x1921, 0x1F80, 0x1FE1, 0x20BC, 0x1FA8,
    0x1B8E, 0x164B, 0x0CCC, 0x0338, 0xFA0A, 0xF53C, 0xF355, 0xF0F5, 0xEFF8, 0xEBFE, 0xEB4D, 0xEC77, 0xEC0A, 0xEDA6, 0xF14F, 0xF5A9,
    0xF79E, 0xF816, 0xFB73, 0xFF53, 0x04FD, 0x0A6E, 0x0EDF, 0x13D3, 0x12EE, 0x129F, 0x1088, 0x0A56, 0x04AD, 0xFE5B, 0xF76B, 0xF0C5,
    0xEDCC, 0xEF8D, 0xF0D9, 0xF3E5, 0xF83D, 0xFE70, 0x03C2, 0x0584, 0x09AB, 0x0CAC, 0x0D80, 0x0D87, 0x0C40, 0x08F5, 0x041E, 0xFFAA,
    0xFCD2, 0xFBE6, 0xFB73, 0xF901, 0xF62C, 0xF2AC, 0xEFDD, 0xECC2, 0xEA09, 0xE773, 0xE7B3, 0xEDBB, 0xF1EE, 0xF5E0, 0xF838, 0xF803,
    0xFB88, 0x00B5, 0x052B, 0x09B8, 0x0D5D, 0x10F8, 0x1098, 0x0F38, 0x0CFA, 0x08AB, 0x0623, 0x0294, 0x0232, 0x027D, 0xFC9C, 0xF5B3,
    0xF072, 0xF046, 0xF42D, 0xF698, 0xFB70, 0x0004, 0x0657, 0x0CC4, 0x1122, 0x14D5, 0x1155, 0x0CB6, 0x06F5, 0xFF20, 0xF7D4, 0xF098,
    0xEA1C, 0xE361, 0xDDA4, 0xDA23, 0xD8C9, 0xD700, 0xD480, 0xD49A, 0xD859, 0xDB63, 0xE1F0, 0xEA2E, 0xEF88, 0xF5A3, 0xFAF1, 0x02E3,
    0x0C2B, 0x10C4, 0x143F, 0x19F7, 0x200A, 0x23AE, 0x2528, 0x2706, 0x268C, 0x24F6, 0x258E, 0x2596, 0x2570, 0x254C, 0x2785, 0x2D01,
    0x325A, 0x377A, 0x3B7C, 0x3E67, 0x3F3B, 0x4039, 0x407F, 0x3E5B, 0x3AEF, 0x35DE, 0x2DB9, 0x2611, 0x1D88, 0x13EE, 0x0E15, 0x0945,
    0x05CC, 0x00A0, 0xFB26, 0xF577, 0xEFB2, 0xEE43, 0xF041, 0xF3EE, 0xF632, 0xF526, 0xF55E, 0xF4D2, 0xF092, 0xEE6D, 0xEC89, 0xEC76,
    0xEE5F, 0xF008, 0xF2A8, 0xF383, 0xF560, 0xF58E, 0xF234, 0xEF62, 0xEB01, 0xE70B, 0xE316, 0xDED6, 0xDF93, 0xE1C3, 0xE581, 0xEC76,
    0xF09A, 0xF70C, 0xFF57, 0x0504, 0x0A36, 0x0B5A, 0x083E, 0x01F6, 0xF906, 0xF0CC, 0xE9E1, 0xE566, 0xE2DC, 0xE025, 0xE011, 0xE063,
    0xE075, 0xE1C9, 0xE14B, 0xE125, 0xE1E0, 0xE31C, 0xE63B, 0xEA20, 0xEEF0, 0xF23D, 0xF65E, 0xFAC9, 0xFF9E, 0x0539, 0x07B5, 0x08B3,
    0x0C00, 0x0DF8, 0x0DCF, 0x0E98, 0x0F7F, 0x0F30, 0x0DA1, 0x0E9F, 0x1003, 0x141D, 0x1B54, 0x2048, 0x2584, 0x2953, 0x2BD8, 0x2FAE,
    0x302F, 0x301D, 0x2F82, 0x2E81, 0x2B96, 0x235B, 0x1C0F, 0x13F3, 0x0B0E, 0x02B4, 0xFA03, 0xF11C, 0xE559, 0xD8BE, 0xCEC8, 0xC625,
    0xC22F, 0xC3B4, 0xC527, 0xC6C4, 0xC889, 0xCADB, 0xCD46, 0xD0E9, 0xD738, 0xDC33, 0xE125, 0xE558, 0xEC1F, 0xF4E5, 0xFB37, 0xFFC9,
    0x0386, 0x070D, 0x07C4, 0x06AF, 0x0569, 0x0430, 0x05B2, 0x0A8B, 0x0F6B, 0x15ED, 0x1DEF, 0x2796, 0x304F, 0x3559, 0x3C97, 0x43D6,
    0x4721, 0x4831, 0x44FC, 0x3EC0, 0x3710, 0x2E82, 0x26FE, 0x1FAE, 0x1AE4, 0x1754, 0x124B, 0x0F94, 0x0C62, 0x0898, 0x07A5, 0x047A,
    0x03E2, 0x07CD, 0x0ADC, 0x0A8F, 0x085E, 0x0828, 0x080A, 0x060A, 0x0702, 0x09E3, 0x0AFB, 0x0A2D, 0x06C5, 0x020A, 0xF87C, 0xED8C,
    0xE5C0, 0xDED1, 0xDAB1, 0xD824, 0xD730, 0xD7C9, 0xD8C8, 0xDCFF, 0xE0BA, 0xE4DA, 0xE95A, 0xECDB, 0xF345, 0xF862, 0xFAFA, 0xFB8F,
    0xF733, 0xF330, 0xF0B9, 0xEE48, 0xED3C, 0xEADB, 0xE907, 0xE7B7, 0xE818, 0xEA1D, 0xE98F, 0xEA44, 0xEAAB, 0xEBFF, 0xF186, 0xF605,
    0xFA60, 0xFC89, 0xFD50, 0xFF8B, 0x02FA, 0x0862, 0x0B0E, 0x0DB2, 0x11ED, 0x14FB, 0x19FF, 0x1B58, 0x1779, 0x159B, 0x1587, 0x15FA,
    0x1555, 0x1375, 0x1198, 0x1089, 0x1199, 0x1412, 0x16D9, 0x19B6, 0x1B62, 0x1D31, 0x1DA6, 0x1E4B, 0x1E34, 0x199F, 0x124A, 0x0912,
    0x0036, 0xF6E9, 0xEDF6, 0xE68D, 0xDEE2, 0xD8EF, 0xD1E2, 0xCAD8, 0xC6E6, 0xC29A, 0xBF50, 0xBE1A, 0xBDF6, 0xBED8, 0xBF69, 0xC013,
    0xC2FE, 0xC6DB, 0xCBAE, 0xD048, 0xD455, 0xD7BF, 0xDAB4, 0xDF2E, 0xE283, 0xE55C, 0xE9B6, 0xECA2, 0xED97, 0xF11A, 0xF443, 0xF922,
    0x0120, 0x08F1, 0x13BF, 0x1D21, 0x27D6, 0x3325, 0x3C62, 0x465B, 0x4BFC, 0x4FAD, 0x511A, 0x4FD3, 0x4F15, 0x4B00, 0x4521, 0x40DB,
    0x3CC6, 0x3ACB, 0x36F0, 0x3298, 0x2FB0, 0x2C02, 0x2A09, 0x2765, 0x272A, 0x28C8, 0x2855, 0x26E1, 0x2197, 0x1CC1, 0x1867, 0x12B6,
    0x10F7, 0x0FCB, 0x108E, 0x1263, 0x115E, 0x0EBF, 0x07DD, 0xFEF0, 0xF493, 0xE8E6, 0xE0F8, 0xDA24, 0xD41F, 0xCF94, 0xCC00, 0xCB32,
    0xCB6C, 0xCC30, 0xCED3, 0xD30E, 0xD891, 0xDD68, 0xE0F2, 0xE3C6, 0xE469, 0xE469, 0xE11A, 0xDBBD, 0xD85D, 0xD653, 0xD4D8, 0xD359,
    0xD05D, 0xCDF4, 0xCC67, 0xCB2D, 0xCB7A, 0xCDCC, 0xD39C, 0xDD18, 0xE975, 0xF42D, 0xFBCF, 0x038C, 0x0B2F, 0x129C, 0x1A25, 0x21A5,
    0x2777, 0x2B27, 0x2E29, 0x3031, 0x2F65, 0x2BCE, 0x2ADC, 0x2ABC, 0x2C04, 0x2E6C, 0x30B8, 0x313C, 0x3181, 0x3500, 0x36A2, 0x37F1,
    0x3859, 0x3920, 0x397D, 0x3936, 0x38AF, 0x342C, 0x2EA1, 0x25E7, 0x1BD9, 0x12D8, 0x079E, 0xFD11, 0xF251, 0xE7EB, 0xE118, 0xDA1C,
    0xD268, 0xCC29, 0xC69E, 0xC45C, 0xC408, 0xC415, 0xC414, 0xC2F0, 0xC4FD, 0xC771, 0xC9C7, 0xCE65, 0xD21F, 0xD5A0, 0xD90B, 0xDDD4,
    0xE2CE, 0xE53F, 0xE722, 0xE75B, 0xE62F, 0xE5D3, 0xE5EF, 0xE726, 0xE9A3, 0xEB36, 0xEEE6, 0xF4CE, 0xFD6A, 0x0582, 0x0A4A, 0x1161,
    0x1832, 0x1AAB, 0x1B2B, 0x1A6F, 0x1728, 0x1429, 0x10B2, 0x0C03, 0x051E, 0xFFF0, 0xFD80, 0xFD8B, 0x0000, 0xFECE, 0xFD95, 0xFC74,
    0xFA20, 0xF817, 0xF850, 0xFC73, 0x00BF, 0x0493, 0x0B6F, 0x1124, 0x14C7, 0x173D, 0x196E, 0x1C3B, 0x1C1D, 0x1BD3, 0x1BCC, 0x19CF,
    0x17F4, 0x1515, 0x112F, 0x0D16, 0x099D, 0x0817, 0x0680, 0x0771, 0x0755, 0x0733, 0x0872, 0x0988, 0x0DCC, 0x1167, 0x14FF, 0x18F7,
    0x1BD3, 0x1CE2, 0x1A99, 0x1667, 0x1139, 0x0C06, 0x0969, 0x0658, 0x03EE, 0x02DD, 0x008D, 0x000C, 0xFF4F, 0x0010, 0x01EA, 0x0355,
    0x04F5, 0x0463, 0x0206, 0xFC25, 0xF3BC, 0xF0B3, 0xEEC1, 0xEF25, 0xF425, 0xF783, 0xFAFC, 0xFD8A, 0xFE19, 0xFA30, 0xF2EC, 0xED9A,
    0xEAA8, 0xE653, 0xE306, 0xE2BA, 0xE3A2, 0xE559, 0xE825, 0xECB3, 0xF200, 0xF73C, 0xFD49, 0x036C, 0x0A54, 0x10C7, 0x14CE, 0x199A,
    0x1C44, 0x1C83, 0x1B00, 0x15DE, 0x0C57, 0x0124, 0xF831, 0xF138, 0xEA48, 0xE5AC, 0xE1A1, 0xDCC3, 0xD942, 0xD31C, 0xCFD9, 0xCD62,
    0xCBB8, 0xCDC3, 0xD020, 0xD696, 0xE09E, 0xEC82, 0xF6DF, 0xFE32, 0x06B8, 0x0D4F, 0x1101, 0x1276, 0x0F98, 0x0DA5, 0x0B7E, 0x0886,
    0x072B, 0x0747, 0x0968, 0x0A6B, 0x0A14, 0x0B1F, 0x0CF1, 0x0FC6, 0x117E, 0x146B, 0x1978, 0x1BA0, 0x1D83, 0x1A8E, 0x149F, 0x0C82,
    0x00CD, 0xF5FE, 0xEBCF, 0xE3A0, 0xDD85, 0xDB99, 0xDB69, 0xDBA6, 0xDF72, 0xE457, 0xE6C1, 0xEBEC, 0xF357, 0xF976, 0xFCE9, 0xFF98,
    0x03CC, 0x0770, 0x09F4, 0x0AC0, 0x0CB8, 0x100E, 0x1450, 0x1AEF, 0x206C, 0x1F05, 0x1B1D, 0x1575, 0x0E6F, 0x078F, 0x0264, 0x0058,
    0xFF69, 0x01C3, 0x075F, 0x10DE, 0x1B98, 0x252C, 0x2EF0, 0x361C, 0x36D3, 0x33CB, 0x3009, 0x2803, 0x1C89, 0x1034, 0x04CE, 0xFC4B,
    0xF32B, 0xEB86, 0xE259, 0xD753, 0xCE80, 0xC65C, 0xC3A0, 0xC29C, 0xC300, 0xC5DD, 0xC96B, 0xD00E, 0xD4FF, 0xD811, 0xDBB1, 0xDECD,
    0xE1ED, 0xE735, 0xEEE9, 0xF88E, 0x020A, 0x0ABF, 0x10C6, 0x1228, 0x13AF, 0x168C, 0x1BDE, 0x234D, 0x29CA, 0x30B2, 0x34D1, 0x3631,
    0x372A, 0x380A, 0x3AE5, 0x3E0C, 0x4124, 0x4191, 0x3F89, 0x3AF1, 0x340E, 0x2D4C, 0x2611, 0x1DC4, 0x1686, 0x0FEC, 0x09ED, 0x0835,
    0x07CF, 0x0760, 0x0694, 0x048C, 0xFFD2, 0xF96E, 0xF224, 0xE9DB, 0xE279, 0xDC66, 0xD5CB, 0xD14F, 0xCF41, 0xCE9E, 0xCE33, 0xCC35,
    0xCAFE, 0xCA2B, 0xCA0E, 0xC97B, 0xCBC8, 0xCF66, 0xD10D, 0xD270, 0xD2E6, 0xD142, 0xCD1B, 0xCA27, 0xCA63, 0xCE1E, 0xD3D2, 0xDBDE,
    0xE4BE, 0xED1D, 0xF5F2, 0xFEFC, 0x0A25, 0x1340, 0x1D04, 0x276C, 0x2CBA, 0x2E24, 0x2C3E, 0x2A42, 0x272D, 0x2305, 0x1F9B, 0x1DA9,
    0x19D7, 0x1295, 0x0C93, 0x070D, 0x02A5, 0x0035, 0xFFC4, 0xFF4D, 0x016F, 0x04FB, 0x0612, 0x089F, 0x0A13, 0x0EBF, 0x15BC, 0x1CBF,
    0x2348, 0x24A6, 0x2052, 0x16B8, 0x0A5A, 0xFE7D, 0xF451, 0xEC60, 0xE602, 0xDF42, 0xDCA6, 0xD9CB, 0xD481, 0xD189, 0xD18B, 0xD49C,
    0xDA60, 0xE1C9, 0xEAF3, 0xF43C, 0xFA7D, 0xFB72, 0xF7A2, 0xF057, 0xE9A2, 0xE711, 0xE661, 0xE61A, 0xE5F7, 0xE584, 0xE456, 0xE6C0,
    0xED5C, 0xF7DF, 0x0214, 0x0C92, 0x18E8, 0x21A2, 0x26D7, 0x2A99, 0x2E05, 0x324A, 0x3730, 0x3D5D, 0x42A2, 0x429C, 0x3FEC, 0x3996,
    0x3069, 0x25B6, 0x1BA6, 0x152B, 0x0EDE, 0x0944, 0x074B, 0x0A3F, 0x10E4, 0x185B, 0x236D, 0x2F62, 0x3793, 0x3E36, 0x3F02, 0x3AEB,
    0x3353, 0x29F2, 0x2214, 0x177E, 0x0BAB, 0x0034, 0xF4F7, 0xE8E7, 0xDB1E, 0xCF39, 0xC30E, 0xB932, 0xB455, 0xB146, 0xAFC4, 0xAF26,
    0xB1BA, 0xB431, 0xB4EC, 0xB4A3, 0xB47B, 0xB643, 0xB764, 0xB958, 0xBDCF, 0xC1DF, 0xC3F8, 0xC747, 0xCC26, 0xD2FE, 0xDC22, 0xE6EB,
    0xF208, 0xFB54, 0x041A, 0x0B5D, 0x1218, 0x18D8, 0x1F65, 0x28F4, 0x31C6, 0x3856, 0x3F88, 0x44BF, 0x477C, 0x48CD, 0x48F6, 0x4737,
    0x4263, 0x3AB1, 0x32AF, 0x297B, 0x2255, 0x2085, 0x22C3, 0x27B1, 0x2B18, 0x2EC8, 0x2EB7, 0x2915, 0x22E1, 0x1B30, 0x1670, 0x13FA,
    0x0FDF, 0x0CFC, 0x092F, 0x03D6, 0xFE58, 0xF830, 0xF37C, 0xEF45, 0xEC79, 0xEACC, 0xE800, 0xE738, 0xE560, 0xDF73, 0xD91C, 0xD236,
    0xCCEE, 0xC8F4, 0xC49F, 0xC286, 0xC00E, 0xBED2, 0xBE4A, 0xBF67, 0xC3D3, 0xC949, 0xD2C7, 0xDCC9, 0xE5C0, 0xECD4, 0xEF93, 0xF0F3,
    0xF093, 0xEE63, 0xEE69, 0xEF7E, 0xF160, 0xF199, 0xEEF5, 0xEB49, 0xE4FF, 0xE14A, 0xE067, 0xE29E, 0xE998, 0xEE39, 0xF15D, 0xF495,
    0xF8AA, 0x00A2, 0x0B5D, 0x18B8, 0x26B7, 0x3361, 0x3BC0, 0x3F22, 0x40D1, 0x3ED8, 0x3A61, 0x36E2, 0x35CA, 0x362E, 0x3570, 0x356B,
    0x3532, 0x341C, 0x32BC, 0x3175, 0x3335, 0x3539, 0x35F4, 0x3921, 0x3C95, 0x3CD3, 0x386A, 0x315A, 0x299A, 0x1FBD, 0x1440, 0x0919,
    0xFF22, 0xF42C, 0xE84F, 0xDEBF, 0xD82A, 0xD480, 0xD417, 0xD61D, 0xD8B9, 0xDADA, 0xDB80, 0xDB6B, 0xDB87, 0xDB67, 0xDDCD, 0xE203,
    0xE6FF, 0xED18, 0xF178, 0xF502, 0xF6F0, 0xF67E, 0xF554, 0xEF0F, 0xE6D0, 0xDEE7, 0xD581, 0xCF9B, 0xCBA6, 0xCDB0, 0xD4D5, 0xDDF1,
    0xEAE9, 0xF7E4, 0x04A9, 0x0ED9, 0x1533, 0x1A57, 0x1D50, 0x1E43, 0x2070, 0x224F, 0x235A, 0x20C3, 0x1CBA, 0x17C8, 0x0E7A, 0x0643,
    0xFF08, 0xF915, 0xF3B4, 0xEE34, 0xED6A, 0xEF04, 0xF03D, 0xF138, 0xF28C, 0xF364, 0xF31B, 0xF359, 0xF206, 0xEFB7, 0xEEE7, 0xEE47,
    0xED26, 0xEEA4, 0xF2D3, 0xF6EF, 0xFA52, 0xFBD7, 0xFB28, 0xFA20, 0xFA17, 0xFB04, 0xFD4F, 0x00B3, 0x046B, 0x07D2, 0x09D5, 0x0AA4,
    0x0D03, 0x10C1, 0x13FB, 0x15DF, 0x15CC, 0x139F, 0x0D8E, 0x04A5, 0xFBC3, 0xF344, 0xEC69, 0xEA01, 0xEC25, 0xF059, 0xF3E1, 0xF61F,
    0xF552, 0xF186, 0xEDB8, 0xE986, 0xE773, 0xE81D, 0xEA45, 0xEC47, 0xEDE8, 0xED82, 0xEC47, 0xEB61, 0xEAF3, 0xECB6, 0xEF54, 0xF530,
    0xF8A1, 0xF925, 0xF71E, 0xF33C, 0xF238, 0xF066, 0xF0CB, 0xF16D, 0xF197, 0xF396, 0xF563, 0xF8AD, 0xFB20, 0x0005, 0x0A52, 0x13FF,
    0x1EBB, 0x2781, 0x2E69, 0x34A0, 0x362D, 0x3814, 0x37CC, 0x363B, 0x3582, 0x3323, 0x30AD, 0x2AA6, 0x2485, 0x1F1F, 0x1781, 0x101F,
    0x0621, 0xFB85, 0xF06E, 0xE3B8, 0xDB45, 0xD566, 0xD2B7, 0xD431, 0xD8FE, 0xE080, 0xE729, 0xEE46, 0xF3CD, 0xF6D5, 0xF8AB, 0xF7B6,
    0xF622, 0xF5A5, 0xF5EB, 0xF648, 0xF711, 0xF583, 0xF26B, 0xF1F0, 0xF29C, 0xF5D5, 0xF9DA, 0xFE64, 0x064E, 0x0D81, 0x1238, 0x152E,
    0x1857, 0x1A5F, 0x1873, 0x15BD, 0x0FE1, 0x076A, 0xFDD3, 0xF2C0, 0xEB62, 0xE5D0, 0xE2ED, 0xE37A, 0xE50F, 0xE8A1, 0xEA80, 0xEF50,
    0xF615, 0xFA49, 0x008C, 0x06D8, 0x1048, 0x1688, 0x1A0B, 0x2080, 0x2488, 0x2922, 0x2B7C, 0x2D2A, 0x2E5E, 0x2A9F, 0x23D9, 0x1803,
    0x0AB5, 0xFE4C, 0xF35D, 0xEEAF, 0xEDDC, 0xEFF3, 0xF4E0, 0xF86F, 0xFA65, 0xFABA, 0xFB83, 0xFCC2, 0xFCF1, 0xFD8C, 0xFDEB, 0xFE6F,
    0xFCC6, 0xF8AE, 0xF16D, 0xE7F5, 0xE07C, 0xDAA4, 0xD7CE, 0xD59A, 0xD42C, 0xD299, 0xCE29, 0xCD0F, 0xCE61, 0xD305, 0xD906, 0xDE36,
    0xE34C, 0xE415, 0xE3EB, 0xE187, 0xE016, 0xE0A4, 0xE190, 0xE638, 0xECAB, 0xF304, 0xF851, 0xFBFB, 0x0068, 0x054A, 0x0BB8, 0x115C,
    0x1445, 0x1900, 0x1BE1, 0x2118, 0x27E0, 0x2D88, 0x358A, 0x3B69, 0x4093, 0x445A, 0x4426, 0x402D, 0x368C, 0x2D14, 0x220F, 0x1874,
    0x1593, 0x1239, 0x1217, 0x12E7, 0x1417, 0x1577, 0x1150, 0x0CE5, 0x0690, 0x010B, 0xFDB6, 0xF9C0, 0xF687, 0xEF80, 0xE98B, 0xE490,
    0xDFA4, 0xDEAC, 0xDEE6, 0xE206, 0xE61F, 0xE941, 0xEC25, 0xED98, 0xF03D, 0xF24F, 0xF4B8, 0xF756, 0xF4EF, 0xF20C, 0xEC97, 0xE5E3,
    0xE31B, 0xE2AA, 0xE4AE, 0xE819, 0xEE66, 0xF6E5, 0xFF3D, 0x0803, 0x10A7, 0x1A06, 0x22E3, 0x294A, 0x2E6B, 0x2FF3, 0x2F7A, 0x2D48,
    0x2C49, 0x2AA9, 0x28C3, 0x27CD, 0x23BD, 0x1F8B, 0x182D, 0x0EA9, 0x0559, 0xFACE, 0xF207, 0xEC72, 0xEAAF, 0xEC1E, 0xEEB0, 0xF4BE,
    0xF9A7, 0xFC4B, 0xFDA9, 0xFE13, 0x017A, 0x02CA, 0x0318, 0x04FC, 0x0572, 0x042F, 0xFF7B, 0xFA3F, 0xF5F4, 0xF2C6, 0xF268, 0xF205,
    0xF36A, 0xF398, 0xF313, 0xF5BD, 0xF918, 0xFE5B, 0x0570, 0x0BE0, 0x0FC6, 0x0E8E, 0x0A58, 0x0281, 0xF852, 0xEF6D, 0xE8B0, 0xE5DD,
    0xE3C0, 0xE29F, 0xE099, 0xDDEB, 0xDBE8, 0xDC6E, 0xDF1A, 0xE29C, 0xE830, 0xEC7C, 0xEFCA, 0xF38D, 0xF97A, 0xFEEE, 0x06D5, 0x11AA,
    0x1B8B, 0x2394, 0x2751, 0x255A, 0x1EBD, 0x1432, 0x0832, 0xFE69, 0xF66E, 0xF3FC, 0xF732, 0xFCA7, 0x0177, 0x0545, 0x0A01, 0x0D29,
    0x10F7, 0x1755, 0x1DE4, 0x25EE, 0x2ABF, 0x2B92, 0x2922, 0x2252, 0x1B51, 0x12C8, 0x098A, 0xFEE9, 0xF611, 0xEFCB, 0xE5AA, 0xDC9D,
    0xD501, 0xCE86, 0xCB7E, 0xC85D, 0xC5E1, 0xC3F4, 0xC132, 0xBE1D, 0xBBA1, 0xBAA8, 0xB9DA, 0xBB0F, 0xBD42, 0xBF83, 0xC545, 0xCBB7,
    0xD293, 0xDB26, 0xE2D9, 0xEAB1, 0xF255, 0xF991, 0xFFF3, 0x0581, 0x0C10, 0x1385, 0x1DBB, 0x26EB, 0x2EBA, 0x3858, 0x411F, 0x4816,
    0x4D9E, 0x51D4, 0x5420, 0x5649, 0x55AB, 0x506A, 0x4C8C, 0x47CD, 0x4391, 0x41B8, 0x3C48, 0x3728, 0x32CF, 0x2EDF, 0x293E, 0x2322,
    0x2000, 0x1B90, 0x1869, 0x1356, 0x0DA1, 0x0B23, 0x07F2, 0x050B, 0x0304, 0xFFFD, 0xFD54, 0xFA8E, 0xF8EC, 0xF80D, 0xF95A, 0xFBC3,
    0xF938, 0xF692, 0xF006, 0xE702, 0xDE57, 0xD4E1, 0xCFE8, 0xCCCA, 0xC99F, 0xC5CF, 0xC318, 0xC2BB, 0xC375, 0xC79F, 0xCD6F, 0xD41C,
    0xDBEC, 0xE1BF, 0xE5EC, 0xE927, 0xEB19, 0xEDD6, 0xF163, 0xF4C1, 0xF9BF, 0x0009, 0x04F8, 0x053C, 0x01DD, 0xFAB1, 0xF18E, 0xEB5F,
    0xE7B0, 0xE75F, 0xEB55, 0xF1DB, 0xF80A, 0xFDC8, 0x0281, 0x06CE, 0x0CD4, 0x1314, 0x1A82, 0x2191, 0x24F8, 0x262A, 0x25BC, 0x231D,
    0x1DB0, 0x1993, 0x1602, 0x11DF, 0x0F84, 0x0C81, 0x0AB0, 0x0A1F, 0x0A42, 0x0DDF, 0x1353, 0x19ED, 0x20E7, 0x2779, 0x2B49, 0x2A85,
    0x2853, 0x22D1, 0x19CD, 0x10BB, 0x06BC, 0xFDB7, 0xF5F5, 0xEE6B, 0xE93E, 0xE4C0, 0xE0D4, 0xDDEF, 0xDCC4, 0xDB6B, 0xD7D9, 0xD606,
    0xD551, 0xD4A9, 0xD716, 0xDBAA, 0xE2B2, 0xEBDA, 0xF414, 0xFB4B, 0x0021, 0x00B9, 0xFC01, 0xF3B7, 0xEA61, 0xE2B4, 0xDE10, 0xDB0B,
    0xD9CB, 0xDB27, 0xDD65, 0xDFBF, 0xE578, 0xEC74, 0xF3D8, 0xFEE6, 0x0A00, 0x14C2, 0x1F2F, 0x26E9, 0x2D64, 0x3192, 0x3395, 0x3266,
    0x306D, 0x2BCC, 0x2381, 0x1D21, 0x1687, 0x1090, 0x0DBF, 0x0AE4, 0x08FB, 0x0854, 0x072E, 0x07B3, 0x0904, 0x09B6, 0x0A20, 0x0C11,
    0x0CB6, 0x0A72, 0x09A3, 0x06DA, 0x04D9, 0x05B9, 0x0636, 0x0887, 0x0B30, 0x0D77, 0x0DDF, 0x0CD6, 0x0A85, 0x056E, 0x03DC, 0x0422,
    0x0773, 0x1040, 0x174D, 0x1DCA, 0x227F, 0x2338, 0x2139, 0x1D0B, 0x1723, 0x10AE, 0x0CD5, 0x0873, 0x01FA, 0xFCBE, 0xF622, 0xEF7B,
    0xEC00, 0xE848, 0xE5DC, 0xE3F6, 0xE0E7, 0xDD58, 0xD9DC, 0xD773, 0xD4AA, 0xD516, 0xD594, 0xD67B, 0xD924, 0xD993, 0xDB14, 0xDC8E,
    0xDDE8, 0xE0FE, 0xE658, 0xED2D, 0xF3FF, 0xFB89, 0x003D, 0x0218, 0x0390, 0x01B7, 0x0006, 0xFEF5, 0xFC59, 0xF938, 0xF74F, 0xF7CD,
    0xF971, 0xFE5C, 0x03E2, 0x0A56, 0x14FE, 0x1DDF, 0x2624, 0x2C3A, 0x2CAC, 0x2C6D, 0x2A40, 0x2832, 0x27BC, 0x299D, 0x2C1C, 0x2B07,
    0x28E9, 0x212B, 0x1614, 0x09BE, 0xF9E0, 0xECCE, 0xE3AE, 0xDCCB, 0xD8FC, 0xD627, 0xD42E, 0xD2C6, 0xD3EE, 0xD4DB, 0xD4B1, 0xD892,
    0xDC30, 0xE017, 0xE3B6, 0xE5C7, 0xE826, 0xE88D, 0xE7C5, 0xE5B9, 0xE38B, 0xE090, 0xDC67, 0xDA2C, 0xD796, 0xD8B7, 0xDE71, 0xE4E1,
    0xEDD0, 0xF7BF, 0xFFF3, 0x0750, 0x0FBB, 0x168D, 0x1A71, 0x1B9F, 0x1955, 0x153E, 0x0F5A, 0x06CC, 0x004B, 0xFC20, 0xF7FF, 0xF630,
    0xF591, 0xF5C5, 0xF6EF, 0xF9C3, 0xFAD3, 0xF98F, 0xFAEB, 0xFE0A, 0x062C, 0x1138, 0x1CCA, 0x2946, 0x34AF, 0x3CA9, 0x3F3A, 0x3FEE,
    0x3C8D, 0x374E, 0x3310, 0x2C8F, 0x26ED, 0x21B5, 0x1AD7, 0x13DD, 0x0EB5, 0x0B7F, 0x0A1D, 0x0B1C, 0x0C07, 0x0BB1, 0x0D03, 0x0D2E,
    0x0CEE, 0x0EDD, 0x0FEA, 0x11AD, 0x10A5, 0x0B30, 0x0356, 0xFA7A, 0xF0B8, 0xE62F, 0xDF11, 0xD9B7, 0xD56F, 0xD28D, 0xCEBA, 0xCC49,
    0xCB3C, 0xCA03, 0xCB3E, 0xCDAC, 0xCE12, 0xCDCD, 0xCE92, 0xCD1C, 0xCB66, 0xCC2C, 0xCDD0, 0xD246, 0xDA1F, 0xE25A, 0xE9DA, 0xEFDB,
    0xF1F0, 0xF28E, 0xF2D2, 0xF12E, 0xF225, 0xF9FA, 0x04C3, 0x120D, 0x210F, 0x2D45, 0x37E2, 0x3FD1, 0x44F3, 0x4908, 0x4CC4, 0x4E02,
    0x4DCB, 0x4DC8, 0x4904, 0x42CA, 0x3D81, 0x37F0, 0x3439, 0x313F, 0x2E3F, 0x2B4E, 0x2807, 0x227C, 0x1C78, 0x17B8, 0x108D, 0x0AB5,
    0x0719, 0x00A1, 0xF8CA, 0xF01F, 0xE70F, 0xDF52, 0xD919, 0xD46D, 0xD239, 0xD308, 0xD2E5, 0xD2FF, 0xD4D7, 0xD3C8, 0xD455, 0xD5C9,
    0xD4A4, 0xD428, 0xD2B9, 0xD06C, 0xCDC2, 0xCB9A, 0xCACC, 0xCD0A, 0xD306, 0xDA0F, 0xE3BE, 0xED45, 0xF30E, 0xF832, 0xFC25, 0xFE63,
    0x01C4, 0x067B, 0x0C34, 0x1368, 0x1A13, 0x1E2B, 0x20C8, 0x2244, 0x1F8B, 0x1A98, 0x14BA, 0x0C44, 0x04F3, 0xFE20, 0xF746, 0xF149,
    0xEF2A, 0xEF2E, 0xF07B, 0xF4C7, 0xF7FD, 0xFCB0, 0x00B3, 0x0308, 0x0635, 0x0AA0, 0x1067, 0x1527, 0x1853, 0x1792, 0x1474, 0x101D,
    0x0952, 0x0389, 0x00C9, 0xFF21, 0xFFD1, 0x032F, 0x074D, 0x0C28, 0x1074, 0x148A, 0x191A, 0x1E8F, 0x2151, 0x2247, 0x21C3, 0x1C55,
    0x1521, 0x0C86, 0x03F9, 0xFF84, 0xFE5F, 0xFEB9, 0xFF13, 0xFD0E, 0xF6BD, 0xEF31, 0xE927, 0xE30F, 0xE11C, 0xE4CC, 0xEB3C, 0xF56E,
    0x01F0, 0x0D0A, 0x15B3, 0x1CEA, 0x21AB, 0x24D8, 0x271A, 0x263C, 0x246E, 0x2232, 0x1D1C, 0x1812, 0x12B9, 0x0BCA, 0x07D1, 0x056D,
    0x0264, 0x0039, 0xFFCA, 0x00B1, 0x0310, 0x0785, 0x0C41, 0x13A3, 0x1BE3, 0x1F08, 0x1FEC, 0x1F7D, 0x1AA0, 0x142E, 0x0CE6, 0x0467,
    0xFDBA, 0xF81D, 0xF23B, 0xED9A, 0xE955, 0xE2CC, 0xDDFA, 0xDB61, 0xD91A, 0xD890, 0xD7DA, 0xD40B, 0xCFE1, 0xCCA8, 0xC841, 0xC613,
    0xC618, 0xC7E6, 0xCD91, 0xD336, 0xD6D3, 0xD9C1, 0xDB36, 0xD961, 0xD81C, 0xD928, 0xDB60, 0xE1B2, 0xEA46, 0xF285, 0xFBF0, 0x0546,
    0x0D68, 0x162E, 0x1D76, 0x22BC, 0x2765, 0x2A36, 0x29DA, 0x295C, 0x29FA, 0x2839, 0x27C1, 0x27E1, 0x256E, 0x2349, 0x207C, 0x1E5D,
    0x1D61, 0x1C21, 0x19F1, 0x17D8, 0x15E1, 0x11D9, 0x0EE7, 0x0A93, 0x03ED, 0x0072, 0xFE30, 0xFB30, 0xF8B1, 0xF780, 0xF6F3, 0xF755,
    0xF8DA, 0xF9AC, 0xFB91, 0xFCE8, 0xFC31, 0xFC50, 0xFAF8, 0xF608, 0xEF4C, 0xE7E5, 0xDF4B, 0xD822, 0xD4A5, 0xD31E, 0xD42D, 0xD70F,
    0xD839, 0xD98E, 0xD8CD, 0xD691, 0xD829, 0xDBC1, 0xE057, 0xE736, 0xF0BA, 0xF87A, 0xFF2F, 0x0527, 0x0811, 0x0D12, 0x0FFC, 0x0FAE,
    0x0E07, 0x08C4, 0x028C, 0xFCD7, 0xF7A2, 0xF359, 0xF313, 0xF726, 0xF9D2, 0xFD3D, 0x0249, 0x055B, 0x0B27, 0x113F, 0x191C, 0x2304,
    0x2A77, 0x3036, 0x332D, 0x3557, 0x32EB, 0x2E87, 0x2A60, 0x2206, 0x1CF9, 0x1A8E, 0x17DB, 0x178F, 0x17B7, 0x19E6, 0x1EF1, 0x252E,
    0x2BEF, 0x3400, 0x3A71, 0x3B9F, 0x3AE0, 0x363D, 0x2B61, 0x2110, 0x18E2, 0x123A, 0x0DC0, 0x09C4, 0x043D, 0xFC2D, 0xF04E, 0xE226,
    0xD649, 0xCC8F, 0xC5D2, 0xC4B4, 0xC61C, 0xC7B0, 0xCB74, 0xD009, 0xD43C, 0xD8EE, 0xDF00, 0xE3AB, 0xE6EC, 0xE72A, 0xE425, 0xE3E3,
    0xE375, 0xE21D, 0xE163, 0xDF98, 0xDD72, 0xDD24, 0xDE48, 0xDF44, 0xE1A1, 0xE695, 0xEBDB, 0xF4B9, 0xFFB3, 0x09E6, 0x164F, 0x1FC7,
    0x2748, 0x2DDE, 0x3034, 0x2F38, 0x2D5A, 0x2B60, 0x2672, 0x214C, 0x1C2B, 0x1503, 0x104A, 0x0AD7, 0x03D9, 0xFFD7, 0xFC82, 0xF8BF,
    0xF550, 0xF0E4, 0xEAA3, 0xE57A, 0xE27B, 0xE1B9, 0xE5BE, 0xEC8C, 0xF27E, 0xF945, 0xFD19, 0xFC80, 0xFD45, 0xFD4B, 0xFBB4, 0xFB21,
    0xFB55, 0xFB43, 0xFBEF, 0xFE2D, 0x020F, 0x085E, 0x0E4B, 0x135B, 0x199B, 0x1BBF, 0x1A2C, 0x1996, 0x1825, 0x156C, 0x1384, 0x111D,
    0x0CF8, 0x0887, 0x0335, 0xFD5A, 0xF719, 0xF1BA, 0xED30, 0xEB2A, 0xE985, 0xE6D9, 0xE717, 0xE50E, 0xE14D, 0xDF6C, 0xDE4E, 0xDDBA,
    0xDEC0, 0xE07F, 0xE2B4, 0xE582, 0xE756, 0xE86C, 0xEB7A, 0xF17B, 0xF831, 0x0262, 0x0CEF, 0x144E, 0x1A2C, 0x1A0C, 0x1600, 0x11EA,
    0x0EA8, 0x0E05, 0x0FB4, 0x11D2, 0x13E3, 0x1695, 0x184E, 0x178A, 0x1870, 0x1AA5, 0x1CF5, 0x226B, 0x2790, 0x2C3D, 0x3113, 0x3394,
    0x3411, 0x3559, 0x374F, 0x3821, 0x381D, 0x355F, 0x2EFC, 0x257D, 0x1972, 0x0C8B, 0x0257, 0xF8A8, 0xEFE4, 0xE9F1, 0xE39C, 0xDCE2,
    0xD7F3, 0xD497, 0xD263, 0xD4A4, 0xD8E0, 0xDD22, 0xE071, 0xE11A, 0xE0ED, 0xE088, 0xDECF, 0xDB35, 0xD858, 0xD4C8, 0xD152, 0xD006,
    0xCE4B, 0xCDAA, 0xCF6A, 0xD397, 0xDB58, 0xE698, 0xF359, 0xFD94, 0x0713, 0x0E09, 0x0F47, 0x109C, 0x1197, 0x12A8, 0x15F1, 0x189D,
    0x1BD1, 0x1DC7, 0x1C3C, 0x17BE, 0x122B, 0x0AE2, 0x024B, 0xFDA8, 0xFAD0, 0xF803, 0xF99A, 0xFDBB, 0x0313, 0x0C17, 0x15C1, 0x1FFE,
    0x2965, 0x2EC7, 0x3128, 0x31C0, 0x304E, 0x2B32, 0x2750, 0x2319, 0x1C58, 0x16EB, 0x0ED6, 0x049F, 0xFBBD, 0xF3AD, 0xEDEF, 0xEBB1,
    0xEBB5, 0xED59, 0xF08A, 0xF427, 0xF6C7, 0xFB5C, 0xFFF2, 0x01C5, 0x0591, 0x0678, 0x038D, 0xFE67, 0xF42E, 0xE978, 0xE0A8, 0xD9CD,
    0xD52D, 0xD44E, 0xD562, 0xD5A7, 0xD5D7, 0xD36D, 0xCEBF, 0xCAAF, 0xC618, 0xC330, 0xC4CE, 0xC805, 0xCC05, 0xD1EB, 0xD604, 0xD931,
    0xDD8A, 0xE0C1, 0xE255, 0xE409, 0xE552, 0xE58F, 0xE6FF, 0xE843, 0xEBE0, 0xF461, 0xFE02, 0x0747, 0x12D4, 0x1DF4, 0x26C3, 0x2F13,
    0x3508, 0x39CA, 0x3EC3, 0x42F2, 0x4718, 0x4AC3, 0x4BEE, 0x4AB2, 0x48E0, 0x4412, 0x3DF5, 0x3BA3, 0x38CC, 0x3579, 0x33B6, 0x3190,
    0x2DBA, 0x2883, 0x21AA, 0x1B89, 0x1765, 0x130B, 0x0E9D, 0x0A20, 0x0358, 0xFAE4, 0xF441, 0xED45, 0xE893, 0xE7DA, 0xE827, 0xE983,
    0xEB3F, 0xEB4E, 0xE964, 0xE65C, 0xE1AC, 0xDC8F, 0xD94F, 0xD71E, 0xD56D, 0xD64E, 0xD724, 0xD750, 0xD819, 0xD89F, 0xDA36, 0xDCA6,
    0xDF00, 0xE0F2, 0xE4D6, 0xEAB3, 0xF06A, 0xF78F, 0xFD99, 0x02E2, 0x09E9, 0x0EFC, 0x12E1, 0x15DE, 0x15B0, 0x13AD, 0x111B, 0x0D67,
    0x092F, 0x05ED, 0x00B3, 0xF963, 0xF43C, 0xF0E4, 0xED7B, 0xED1C, 0xEF7F, 0xF5A5, 0xFEA3, 0x06B3, 0x0F4A, 0x16AC, 0x1BC6, 0x1EB5,
    0x2209, 0x237F, 0x217C, 0x1E7A, 0x1919, 0x1229, 0x0BB7, 0x0455, 0xFF73, 0x011C, 0x04F7, 0x0A97, 0x1058, 0x115D, 0x0FE6, 0x0E9B,
    0x0BB0, 0x06DB, 0x02F4, 0xFF46, 0xFB4B, 0xF7BB, 0xF22C, 0xEC34, 0xE847, 0xE387, 0xDDC7, 0xD77D, 0xD086, 0xCA52, 0xC599, 0xC1EA,
    0xC143, 0xC358, 0xC79B, 0xCE80, 0xD754, 0xE0B8, 0xEA31, 0xF4BF, 0xFC67, 0x025E, 0x08D1, 0x0C8D, 0x101D, 0x1405, 0x149F, 0x127A,
    0x0F03, 0x0A85, 0x05D9, 0x024F, 0xFEE5, 0xFD47, 0xFEDF, 0x001D, 0x0190, 0x040F, 0x06DF, 0x0C85, 0x1586, 0x1E7D, 0x26A8, 0x2D5E,
    0x2EDB, 0x2BCC, 0x256A, 0x1C56, 0x14A4, 0x101D, 0x0E17, 0x0D1C, 0x0D60, 0x0CBC, 0x07E1, 0x016F, 0xF97C, 0xF23F, 0xECCE, 0xE79A,
    0xE53E, 0xE4DA, 0xE4EA, 0xE606, 0xE7AB, 0xE78F, 0xE78E, 0xE91C, 0xE80F, 0xE627, 0xE459, 0xE216, 0xE0E3, 0xE229, 0xE5D1, 0xEAA1,
    0xF183, 0xF864, 0xFF06, 0x0716, 0x0CC7, 0x11CB, 0x1881, 0x1DE1, 0x2492, 0x2B0B, 0x2EE0, 0x333F, 0x3625, 0x3768, 0x36C7, 0x34DA,
    0x32A7, 0x3068, 0x2FD4, 0x2DE3, 0x2BB2, 0x2AA1, 0x2694, 0x22D4, 0x2060, 0x1CE8, 0x1A13, 0x1551, 0x0DC1, 0x05AF, 0xFD3A, 0xF4C3,
    0xEE25, 0xEB81, 0xEC3E, 0xEE51, 0xF1FC, 0xF405, 0xF478, 0xF549, 0xF365, 0xF144, 0xEFC0, 0xECB2, 0xE9C2, 0xE767, 0xE469, 0xE2F5,
    0xE280, 0xE215, 0xE1A6, 0xE253, 0xE256, 0xE128, 0xE03A, 0xDDC9, 0xDD7E, 0xDFB0, 0xE371, 0xE8D4, 0xEE68, 0xF3A8, 0xF812, 0xFC4B,
    0xFF23, 0x0249, 0x04FF, 0x03D8, 0x028A, 0x01DC, 0xFDF0, 0xF85E, 0xF1A9, 0xE958, 0xE22E, 0xDD4D, 0xD95F, 0xD80A, 0xDA78, 0xDE56,
    0xE273, 0xE7F7, 0xED6B, 0xF441, 0xFCEC, 0x04F1, 0x0EAC, 0x16FE, 0x1BBA, 0x1C84, 0x195F, 0x145D, 0x0F4C, 0x0D70, 0x0DBE, 0x10B1,
    0x14FE, 0x170D, 0x18D0, 0x1B1F, 0x1C71, 0x1E5B, 0x217F, 0x2370, 0x25DB, 0x27C1, 0x28CC, 0x2979, 0x27E6, 0x25D1, 0x21F5, 0x1CAF,
    0x15A9, 0x0C92, 0x0297, 0xF4F8, 0xE78B, 0xDD59, 0xD4A8, 0xD0A1, 0xCFDA, 0xCF94, 0xD338, 0xD707, 0xDA14, 0xDDC8, 0xE0D2, 0xE5E6,
    0xEB2C, 0xF1D0, 0xF693, 0xF749, 0xF7D6, 0xF51B, 0xF1B4, 0xEF6E, 0xEC90, 0xEB2C, 0xEACC, 0xEA06, 0xEAC5, 0xECEE, 0xEF7C, 0xF3F2,
    0xFB49, 0x0517, 0x1183, 0x2093, 0x2BC3, 0x3345, 0x37B2, 0x36AB, 0x342B, 0x3130, 0x2E20, 0x2CE1, 0x2DBB, 0x2DBE, 0x2DAB, 0x2BF9,
    0x267C, 0x1FA7, 0x17E9, 0x0F6B, 0x0649, 0xFEBE, 0xF98A, 0xF66D, 0xF59A, 0xF6B5, 0xF962, 0xFCB7, 0xFEEF, 0x010D, 0x0262, 0xFFF4,
    0xFC08, 0xF842, 0xF416, 0xF162, 0xF07C, 0xEF7F, 0xEFA7, 0xF0CD, 0xF0A2, 0xF145, 0xF33C, 0xF4F5, 0xF87F, 0xFD53, 0x012E, 0x03D0,
    0x06ED, 0x0693, 0x0352, 0x0107, 0xFEBF, 0xFE4F, 0xFCB2, 0xF93D, 0xF61C, 0xF26C, 0xEE79, 0xEC12, 0xEB16, 0xEBC5, 0xEE8E, 0xF1D6,
    0xF2DB, 0xF16F, 0xEFA6, 0xEB94, 0xE79B, 0xE582, 0xE44B, 0xE6F2, 0xEB76, 0xF157, 0xF9A4, 0xFF9D, 0x03C2, 0x073E, 0x0B0F, 0x0E8F,
    0x0FDA, 0x1295, 0x1236, 0x0F61, 0x0DE9, 0x0B33, 0x0967, 0x0748, 0x034E, 0x00B7, 0xFC8B, 0xF75F, 0xF3F5, 0xF200, 0xF281, 0xF4C1,
    0xFB56, 0x034D, 0x0B18, 0x12D3, 0x166E, 0x1AA0, 0x1EC0, 0x2101, 0x249D, 0x2696, 0x2696, 0x2467, 0x1E63, 0x1540, 0x0B62, 0x015E,
    0xF685, 0xEDC7, 0xE801, 0xE332, 0xDDDE, 0xD8B9, 0xD3A1, 0xD17B, 0xD3C1, 0xD77F, 0xDDA9, 0xE40D, 0xE7B7, 0xE98C, 0xE812, 0xE29F,
    0xDDE5, 0xD923, 0xD40E, 0xD1D0, 0xD27A, 0xD550, 0xD8B8, 0xDD73, 0xE168, 0xE647, 0xEC7E, 0xF202, 0xF867, 0xFFFA, 0x07CE, 0x0FA1,
    0x17BE, 0x1EFD, 0x26E6, 0x2DF8, 0x32E1, 0x3689, 0x36B1, 0x32A8, 0x2C37, 0x2305, 0x196E, 0x1185, 0x0B0E, 0x0739, 0x0541, 0x06E7,
    0x09D3, 0x0D2E, 0x1211, 0x15C8, 0x1C62, 0x2451, 0x2A32, 0x2F36, 0x327E, 0x3428, 0x342E, 0x3189, 0x2DC4, 0x2AC2, 0x272B, 0x21F7,
    0x1B86, 0x14C4, 0x0BAC, 0x043D, 0xFFC9, 0xFD8B, 0x00AC, 0x0584, 0x0B33, 0x10A7, 0x1347, 0x13C5, 0x1180, 0x0CA3, 0x0732, 0x0145,
    0xFB85, 0xF55D, 0xEEC6, 0xE99A, 0xE357, 0xDE06, 0xD888, 0xD1EB, 0xCD0E, 0xC62D, 0xC069, 0xBCC2, 0xBAA0, 0xBA3D, 0xBB5D, 0xBFE0,
    0xC52E, 0xCA6F, 0xCF6A, 0xD241, 0xD5B7, 0xD8E5, 0xD9A5, 0xDCC5, 0xDF9A, 0xE1E9, 0xE54A, 0xE9B6, 0xEE31, 0xF507, 0xFE43, 0x0485,
    0x0C6B, 0x1552, 0x1F4E, 0x29A6, 0x306C, 0x34CB, 0x387E, 0x3BA6, 0x3E40, 0x4237, 0x464A, 0x486A, 0x47BD, 0x44F5, 0x4015, 0x39B5,
    0x32E4, 0x2CC5, 0x29AA, 0x27F7, 0x26BB, 0x24D6, 0x20E5, 0x19D8, 0x109F, 0x07B5, 0xFF05, 0xF80C, 0xF1D3, 0xED35, 0xEAF8, 0xE9EC,
    0xE995, 0xE9EE, 0xE98C, 0xE7B9, 0xE786, 0xE4FF, 0xE172, 0xDDC8, 0xD977, 0xD7FB, 0xD762, 0xD6D6, 0xD6B9, 0xD70F, 0xD73A, 0xD61D,
    0xD4A7, 0xD31E, 0xD102, 0xD0E4, 0xD266, 0xD4A1, 0xDA0D, 0xDF88, 0xE566, 0xEB03, 0xEF0E, 0xF426, 0xF8FD, 0xFF6A, 0x068D, 0x0D50,
    0x12C6, 0x148A, 0x143C, 0x12F0, 0x1047, 0x0EAE, 0x0D34, 0x0921, 0x0674, 0x0175, 0xFC86, 0xF981, 0xF814, 0xFC1F, 0x02BB, 0x0BC9,
    0x1612, 0x216E, 0x29BB, 0x2E00, 0x3182, 0x31F2, 0x300C, 0x2D41, 0x29F1, 0x27BB, 0x26E8, 0x24CF, 0x23F2, 0x2278, 0x2166, 0x215B,
    0x204B, 0x1FCF, 0x1C17, 0x19F0, 0x17F7, 0x1604, 0x16AB, 0x1758, 0x18B6, 0x195F, 0x16A0, 0x110D, 0x0B75, 0x03F2, 0xFB0D, 0xF0A1,
    0xE6FB, 0xDE7C, 0xD8E5, 0xD447, 0xCED8, 0xCDA1, 0xCB54, 0xCAA7, 0xCD90, 0xD1EA, 0xD759, 0xDC33, 0xE18D, 0xE5E8, 0xEB4A, 0xF0B6,
    0xF718, 0xFD3C, 0x0235, 0x056E, 0x055D, 0x025E, 0xFEFC, 0xFD41, 0xF857, 0xF4E6, 0xF579, 0xF99D, 0xFF64, 0x0615, 0x0D4A, 0x132B,
    0x1928, 0x1D9A, 0x219F, 0x2526, 0x2760, 0x2862, 0x2A9B, 0x2D87, 0x2E1B, 0x2E32, 0x2CF8, 0x2ADE, 0x2853, 0x233D, 0x1C51, 0x1355,
    0x0850, 0xFD71, 0xF652, 0xEE84, 0xE8B5, 0xE90F, 0xE9AA, 0xEAC3, 0xEA56, 0xE531, 0xE052, 0xDB04, 0xD72D, 0xD4D0, 0xD0DC, 0xCE67,
    0xCAE9, 0xC830, 0xC72B, 0xC659, 0xC83A, 0xCBC4, 0xD0DD, 0xD81C, 0xDF41, 0xE565, 0xEA70, 0xEFA6, 0xF6CA, 0xFF05, 0x07F2, 0x11AC,
    0x1ABE, 0x20D1, 0x2375, 0x2518, 0x23D2, 0x21F6, 0x2329, 0x2436, 0x26CC, 0x2969, 0x2B3C, 0x2BF4, 0x29D5, 0x2709, 0x2432, 0x1F85,
    0x1943, 0x12D9, 0x0DE5, 0x0991, 0x05B2, 0x0588, 0x0485, 0x0390, 0x04CF, 0x0672, 0x089A, 0x08D5, 0x075A, 0x051B, 0x034E, 0x0254,
    0x0207, 0x01D2, 0x019A, 0x0175, 0x0038, 0xFC71, 0xF767, 0xF3A2, 0xF033, 0xEF34, 0xEFC6, 0xF0D6, 0xF2AC, 0xF41C, 0xF4CC, 0xF691,
    0xFA78, 0xFDDB, 0x0233, 0x0665, 0x08B5, 0x0BBD, 0x0D3B, 0x0C96, 0x0C5E, 0x0B62, 0x0959, 0x0658, 0x0170, 0xFAA9, 0xF430, 0xED1D,
    0xE574, 0xE084, 0xDFD2, 0xE14A, 0xE47D, 0xEA08, 0xF235, 0xFB7F, 0x03A6, 0x0AB4, 0x1028, 0x156F, 0x18E2, 0x1B60, 0x1D5F, 0x1C5A,
    0x1AC7, 0x1947, 0x16EE, 0x1712, 0x18FE, 0x191E, 0x18C2, 0x1708, 0x1306, 0x113F, 0x0F99, 0x0F3A, 0x137A, 0x1A60, 0x217E, 0x26B8,
    0x293A, 0x2933, 0x26C8, 0x22CB, 0x1D92, 0x173D, 0x114C, 0x0830, 0xFE96, 0xF4C2, 0xE9B8, 0xE205, 0xDBFD, 0xD972, 0xD9F2, 0xDB3F,
    0xDDD2, 0xE0BA, 0xE3B1, 0xE5EF, 0xE984, 0xEEA9, 0xF3A9, 0xF9BF, 0xFEBE, 0xFF51, 0xFC5B, 0xF6B6, 0xEFAF, 0xE97F, 0xE391, 0xDE73,
    0xDBEB, 0xDD72, 0xE055, 0xE353, 0xE7DF, 0xEC7A, 0xF270, 0xF888, 0xFD70, 0x02A2, 0x069B, 0x09AD, 0x0E27, 0x11A4, 0x1449, 0x1830,
    0x1B98, 0x1EEB, 0x2120, 0x203A, 0x1C84, 0x167D, 0x0F45, 0x07B6, 0x0160, 0xFE26, 0xFCA4, 0xFB77, 0xFBAA, 0xFA5F, 0xF906, 0xF874,
    0xF685, 0xF68D, 0xF69B, 0xF6D5, 0xF828, 0xF77C, 0xF5BA, 0xF357, 0xF122, 0xEFFF, 0xF131, 0xF314, 0xF32C, 0xF4EB, 0xF680, 0xF6DB,
    0xF792, 0xFADD, 0xFFB7, 0x054E, 0x0B5F, 0x1178, 0x15FD, 0x1695, 0x1617, 0x14C5, 0x1257, 0x0F10, 0x0C90, 0x0B05, 0x09AA, 0x0945,
    0x0A1C, 0x0B21, 0x0AF6, 0x0A1C, 0x0801, 0x05CA, 0x022E, 0xFD13, 0xFA03, 0xF7E5, 0xF73B, 0xF861, 0xFB0F, 0xFDD8, 0x00E3, 0x0540,
    0x0773, 0x082D, 0x0925, 0x0A2E, 0x0CC2, 0x101C, 0x1240, 0x15DD, 0x179E, 0x164A, 0x1506, 0x11BA, 0x0EE9, 0x0D17, 0x0A7B, 0x084E,
    0x0578, 0xFF42, 0xFB09, 0xFA18, 0xFA8E, 0xFDC1, 0x0397, 0x0BBA, 0x114B, 0x14D4, 0x1646, 0x1560, 0x13F9, 0x1238, 0x10C9, 0x102E,
    0x0FD6, 0x0E28, 0x0B03, 0x0450, 0xFAB6, 0xF20E, 0xECCC, 0xE796, 0xE361, 0xDFEB, 0xDDA8, 0xDED7, 0xE0D5, 0xE49D, 0xE894, 0xEB3C,
    0xEE8A, 0xF12E, 0xF077, 0xEE0D, 0xEC0F, 0xE97F, 0xE6E3, 0xE5D6, 0xE725, 0xE8A3, 0xE9B4, 0xEA9C, 0xEA1F, 0xE910, 0xE730, 0xE7C3,
    0xEB2E, 0xEF9D, 0xF7B1, 0x0349, 0x0CC9, 0x142A, 0x1A62, 0x1DBF, 0x1F7B, 0x1FFE, 0x2039, 0x1C81, 0x16F6, 0x10F6, 0x07CA, 0x0012,
    0xF855, 0xF0DB, 0xECEA, 0xEA0E, 0xE9CC, 0xEA66, 0xEA6C, 0xEBC4, 0xEE15, 0xF1F7, 0xF834, 0x016A, 0x0C14, 0x15FA, 0x1E90, 0x2438,
    0x26A3, 0x2582, 0x20F4, 0x1C0F, 0x1656, 0x1089, 0x0B1A, 0x0778, 0x04F7, 0x03AA, 0x052F, 0x0633, 0x0810, 0x0A17, 0x0BD1, 0x0B95,
    0x0B27, 0x0B00, 0x08ED, 0x08B6, 0x0A01, 0x09F6, 0x08B7, 0x06CA, 0x00C9, 0xF8AC, 0xED99, 0xE2FE, 0xDB1A, 0xD334, 0xCEED, 0xCCA1,
    0xCB65, 0xC9C2, 0xC8D1, 0xC897, 0xC921, 0xCBE3, 0xCE75, 0xD17F, 0xD4CF, 0xD73F, 0xD84B, 0xDAB6, 0xDDCF, 0xE217, 0xE938, 0xEECD,
    0xF584, 0xFBBC, 0x0056, 0x0389, 0x055F, 0x08D2, 0x0F67, 0x1869, 0x220B, 0x2C47, 0x3498, 0x3B60, 0x3D88, 0x3EE3, 0x3F4C, 0x3F1E,
    0x3FFE, 0x3E4C, 0x3C87, 0x3AC1, 0x39FF, 0x3846, 0x3748, 0x35D8, 0x33D5, 0x325C, 0x2DD0, 0x26D7, 0x1EB6, 0x15EB, 0x0D72, 0x0816,
    0x033C, 0x0138, 0x00CC, 0xFE65, 0xFC18, 0xF787, 0xF324, 0xEE53, 0xE922, 0xE595, 0xE232, 0xE01F, 0xDDDE, 0xDA3A, 0xD727, 0xD390,
    0xCF91, 0xCF21, 0xCEAA, 0xCE20, 0xCE83, 0xCCA3, 0xCA87, 0xC7A2, 0xC5D9, 0xC630, 0xC8CF, 0xCD85, 0xD2F6, 0xDA8D, 0xE1B1, 0xE71E,
    0xEC79, 0xF279, 0xF8C5, 0x020F, 0x0BD6, 0x1574, 0x1D05, 0x1F6D, 0x202D, 0x1DFD, 0x18B1, 0x1368, 0x0EDB, 0x09B1, 0x0554, 0x0250,
    0x005D, 0x002E, 0x01EC, 0x05E9, 0x0A5B, 0x1043, 0x1623, 0x196F, 0x1A9D, 0x1975, 0x180F, 0x1656, 0x1466, 0x14A3, 0x174A, 0x186E,
    0x1758, 0x145A, 0x0F44, 0x09F7, 0x051F, 0x0284, 0x014D, 0x02D4, 0x04E5, 0x073D, 0x0BA9, 0x0E03, 0x1006, 0x11DA, 0x1008, 0x0DFE,
    0x0C98, 0x07F2, 0x0141, 0xF7FE, 0xEDDF, 0xE5A2, 0xDEC3, 0xD877, 0xD28B, 0xCDF8, 0xC9AA, 0xC605, 0xC370, 0xC27B, 0xC34D, 0xC67F,
    0xCC68, 0xD452, 0xDD2D, 0xE5A1, 0xEE51, 0xF574, 0xFA2A, 0xFCBF, 0xFF0D, 0xFE9A, 0xFCA0, 0xFC10, 0xF995, 0xF820, 0xF87F, 0xFAB0,
    0xFF61, 0x0661, 0x0CD2, 0x1210, 0x1677, 0x17EF, 0x1A1F, 0x1D24, 0x2282, 0x2A08, 0x3267, 0x3963, 0x3CFE, 0x4075, 0x409E, 0x3EA4,
    0x3B96, 0x37A3, 0x337B, 0x2D9E, 0x2558, 0x1C55, 0x1302, 0x09E6, 0x036A, 0xFE20, 0xFBAD, 0xF8FF, 0xF6A1, 0xF394, 0xEDD6, 0xE85E,
    0xE1DB, 0xDCF9, 0xDB0E, 0xD9CD, 0xD9ED, 0xDAC8, 0xD97E, 0xD81F, 0xD667, 0xD3B3, 0xD389, 0xD476, 0xD77C, 0xDCF6, 0xE380, 0xEAC2,
    0xF14F, 0xF717, 0xFAFA, 0xFF35, 0x04A9, 0x08E0, 0x0C54, 0x0FB8, 0x1019, 0x1026, 0x11E5, 0x144A, 0x1911, 0x1D22, 0x2043, 0x22DE,
    0x22C0, 0x2034, 0x1ADF, 0x15D4, 0x1223, 0x100A, 0x106C, 0x113B, 0x109F, 0x0FBE, 0x0DA4, 0x0B7B, 0x0A03, 0x071B, 0x070E, 0x07FE,
    0x07DE, 0x0958, 0x09D8, 0x08CF, 0x093E, 0x0B5D, 0x0BFF, 0x0C8C, 0x0C52, 0x0A1A, 0x06AD, 0x01D7, 0xFB7C, 0xF46A, 0xEF0D, 0xEA30,
    0xE74A, 0xE652, 0xE5F4, 0xE62B, 0xE570, 0xE478, 0xE496, 0xE649, 0xE7F3, 0xEB10, 0xEDD7, 0xF013, 0xF2CD, 0xF3D3, 0xF20E, 0xEF6C,
    0xEC60, 0xE6C4, 0xE094, 0xD9B2, 0xD3DA, 0xCFAB, 0xCD56, 0xCDCE, 0xD0E6, 0xD784, 0xDDFE, 0xE46C, 0xEB94, 0xF008, 0xF486, 0xFA06,
    0xFEB0, 0x0538, 0x0C85, 0x119A, 0x1624, 0x17E3, 0x1818, 0x1755, 0x1493, 0x1326, 0x12B5, 0x12B5, 0x1239, 0x11F4, 0x11B2, 0x112A,
    0x131A, 0x172E, 0x1AEF, 0x1F8C, 0x244C, 0x268E, 0x26E8, 0x24FB, 0x21AF, 0x1D9D, 0x17CA, 0x128B, 0x0E58, 0x0A61, 0x0591, 0xFF33,
    0xF842, 0xF050, 0xEA50, 0xE72A, 0xE418, 0xE448, 0xE7E0, 0xED71, 0xF560, 0xFC44, 0x0194, 0x0801, 0x0BF4, 0x0D9B, 0x0DE7, 0x0AE7,
    0x05D5, 0xFEEE, 0xF72B, 0xF0CF, 0xECB7, 0xEB47, 0xECDA, 0xEEFF, 0xF0BA, 0xF0BF, 0xF040, 0xF077, 0xF13C, 0xF602, 0xFDCE, 0x06EF,
    0x1020, 0x17BC, 0x1DC1, 0x2235, 0x251A, 0x26E7, 0x2823, 0x27A2, 0x23D8, 0x1E15, 0x175C, 0x0F14, 0x074E, 0x0203, 0xFE82, 0xFCC1,
    0xFC6C, 0xFB07, 0xF995, 0xF748, 0xF36F, 0xF012, 0xED1C, 0xEAEA, 0xEA1A, 0xEAA9, 0xEC2C, 0xED87, 0xED6F, 0xED7B, 0xED25, 0xEB8C,
    0xEAF0, 0xEC35, 0xEE95, 0xF1F9, 0xF5AA, 0xF9FD, 0xFFF6, 0x067F, 0x0B45, 0x0EC5, 0x1212, 0x14D2, 0x13F0, 0x12EB, 0x12FF, 0x1148,
    0x11F1, 0x13AF, 0x15CD, 0x1735, 0x1650, 0x13EB, 0x0F94, 0x0918, 0x015D, 0xFAC9, 0xF5B9, 0xF2A8, 0xF08D, 0xEDF7, 0xEB9D, 0xE998,
    0xE6EC, 0xE455, 0xE505, 0xE6ED, 0xE905, 0xEABB, 0xEB8A, 0xED29, 0xEF91, 0xF261, 0xF5FB, 0xF9E6, 0xFDB4, 0x02D6, 0x066D, 0x0891,
    0x0847, 0x060A, 0x04A6, 0x0187, 0x0037, 0x007D, 0x0135, 0x02A4, 0x0255, 0x01FB, 0x040F, 0x06AD, 0x0903, 0x0C12, 0x0F71, 0x142E,
    0x1948, 0x1D7F, 0x20BB, 0x248E, 0x27F0, 0x2787, 0x2470, 0x1E8E, 0x1546, 0x0A2D, 0xFEC1, 0xF436, 0xED44, 0xE9D5, 0xE901, 0xEAF0,
    0xEAFD, 0xEAB3, 0xE9D3, 0xE7DF, 0xE824, 0xE951, 0xEB4A, 0xEEA7, 0xF2B1, 0xF58A, 0xF625, 0xF62C, 0xF5FF, 0xF4D0, 0xF492, 0xF649,
    0xF7A7, 0xF8AE, 0xF8B9, 0xF7AA, 0xF81C, 0xFAF9, 0xFF83, 0x06FB, 0x0FCB, 0x187F, 0x2104, 0x267A, 0x2A52, 0x2B47, 0x298B, 0x275E,
    0x250A, 0x22BB, 0x1FC2, 0x1D7E, 0x191D, 0x12CB, 0x0B64, 0x03D2, 0xFD95, 0xF92B, 0xF6B8, 0xF622, 0xF8AC, 0xFBF6, 0xFFAE, 0x0616,
    0x0DFA, 0x1587, 0x1C53, 0x1F63, 0x1F11, 0x1D50, 0x18E4, 0x13D0, 0x0EBA, 0x0BB0, 0x0AD9, 0x0A2D, 0x0905, 0x0641, 0x02E6, 0xFDE5,
    0xF883, 0xF5ED, 0xF4E7, 0xF5CE, 0xF8FE, 0xFCF4, 0x019E, 0x0693, 0x08C0, 0x0AA9, 0x0CA1, 0x0CDE, 0x0CE5, 0x0AC9, 0x04E7, 0xFBD3,
    0xF1B5, 0xE8F3, 0xE1DF, 0xDC9F, 0xDA1B, 0xD8FF, 0xD96C, 0xD887, 0xD6D7, 0xD5DD, 0xD3B5, 0xD2E6, 0xD344, 0xD41F, 0xD629, 0xD87F,
    0xDB10, 0xDDEE, 0xDFE7, 0xE205, 0xE390, 0xE5B0, 0xE872, 0xE9E1, 0xEC94, 0xEF29, 0xF346, 0xFAC6, 0x0365, 0x0D70, 0x178B, 0x1F13,
    0x240A, 0x2715, 0x2807, 0x296B, 0x2BCD, 0x2E8C, 0x3270, 0x35D8, 0x3842, 0x38F4, 0x3997, 0x38F2, 0x366D, 0x3421, 0x3207, 0x2F9C,
    0x2BE4, 0x2775, 0x2230, 0x1E6E, 0x19B2, 0x14F0, 0x1155, 0x0D67, 0x0AEA, 0x0777, 0x0222, 0xFC48, 0xF6AA, 0xF087, 0xEB3A, 0xE858,
    0xE76D, 0xE7A6, 0xE7E7, 0xE6FD, 0xE3C4, 0xDF5D, 0xD993, 0xD494, 0xD0E1, 0xCC9A, 0xCA0C, 0xC977, 0xC7FA, 0xC6A8, 0xC6FC, 0xC7C4,
    0xC98C, 0xCD67, 0xD23E, 0xD86B, 0xDEEF, 0xE624, 0xEE6E, 0xF84D, 0x0480, 0x100E, 0x1A9E, 0x2286, 0x26B0, 0x2757, 0x23C1, 0x1DEA,
    0x192A, 0x15F6, 0x154B, 0x16B0, 0x1743, 0x1757, 0x179B, 0x166B, 0x152B, 0x146D, 0x134E, 0x14D4, 0x1797, 0x1A09, 0x1C7F, 0x1F24,
    0x21BA, 0x22FB, 0x2587, 0x2738, 0x27E7, 0x28EB, 0x26FD, 0x241A, 0x203A, 0x1B2E, 0x171A, 0x1422, 0x1355, 0x15A5, 0x18A2, 0x1B4B,
    0x1C4F, 0x1B94, 0x188A, 0x13B4, 0x0F59, 0x09F8, 0x04C8, 0xFFE8, 0xF962, 0xF1A0, 0xE98D, 0xE186, 0xD942, 0xD16D, 0xCA0A, 0xC42E,
    0xC07A, 0xBE08, 0xBD76, 0xBF4B, 0xC4B2, 0xCC5D, 0xD542, 0xDE40, 0xE70F, 0xEE04, 0xF190, 0xF455, 0xF6E6, 0xF964, 0xFCA0, 0x010F,
    0x04E3, 0x082D, 0x0BD5, 0x0CC9, 0x0D64, 0x0FC1, 0x10FA, 0x1328, 0x15C7, 0x1704, 0x18EE, 0x1C21, 0x204C, 0x2557, 0x2A03, 0x2FE3,
    0x34DD, 0x3786, 0x3814, 0x357E, 0x31AD, 0x2B8D, 0x24A8, 0x1E83, 0x185E, 0x1437, 0x10F5, 0x0BCE, 0x06AC, 0x016A, 0xFAEC, 0xF465,
    0xEF9F, 0xEB6A, 0xE87E, 0xE67E, 0xE40F, 0xE22B, 0xE01F, 0xDDFE, 0xDBAF, 0xDAD5, 0xDA43, 0xD890, 0xD649, 0xD312, 0xD0D6, 0xD04A,
    0xD0F7, 0xD46A, 0xD9D0, 0xDEF0, 0xE458, 0xE84E, 0xE9D9, 0xEA1F, 0xEA2D, 0xEC57, 0xF052, 0xF5BE, 0xFB9D, 0x013A, 0x06E3, 0x0A99,
    0x0CB5, 0x0FD6, 0x124F, 0x1459, 0x1706, 0x17B8, 0x17C3, 0x171D, 0x14B7, 0x13DA, 0x13CA, 0x159B, 0x1832, 0x1A49, 0x1C54, 0x1C13,
    0x1ACC, 0x1886, 0x163C, 0x1547, 0x14EB, 0x177B, 0x1C9B, 0x208E, 0x234A, 0x253E, 0x26B3, 0x26E1, 0x25CB, 0x2329, 0x2101, 0x1E1A,
    0x18F4, 0x12C6, 0x0CF4, 0x077A, 0x025F, 0xFD3A, 0xF8FE, 0xF618, 0xF3F7, 0xF233, 0xF0A5, 0xF1A7, 0xF488, 0xFA17, 0x01A6, 0x07D7,
    0x0CDD, 0x0F24, 0x0C6C, 0x0746, 0x007E, 0xF90D, 0xF054, 0xE975, 0xE572, 0xE473, 0xDCD2, 0xD71C, 0xD97A, 0xD954, 0xD3F4, 0xD2E1,
    0xD636, 0xDA71, 0xDD4C, 0xDE1E, 0xE1C6, 0xE5D6, 0xEFE0, 0xF34B, 0xFAC4, 0x0276, 0x06CE, 0x0C2A, 0x0DAA, 0x0BE3, 0x09CC, 0x0824,
    0x09F7, 0x0DCA, 0x0F99, 0x10E2, 0x171C, 0x1F7F, 0x22BF, 0x2398, 0x2507, 0x2722, 0x27ED, 0x2DE7, 0x29D5, 0x2861, 0x25CA, 0x2528,
    0x245B, 0x1DDC, 0x14F5, 0x0EB0, 0x0983, 0xFC60, 0xF0E1, 0xE6E3, 0xE37A, 0xE43C, 0xE41A, 0xE464, 0xEB9D, 0xEF59, 0xF019, 0xEFFF,
    0xF014, 0xF097, 0xEEEC, 0xE99C, 0xE920, 0xEA5D, 0xEB97, 0xE87C, 0xE451, 0xE5BF, 0xE4C0, 0xE0F8, 0xE14A, 0xDFC7, 0xDEDB, 0xE1AC,
    0xDC38, 0xDFE1, 0xE2DB, 0xEBB6, 0xF5FA, 0x009A, 0x0C5D, 0x141D, 0x1DED, 0x1D90, 0x20A9, 0x1FE9, 0x1C45, 0x1DBD, 0x1E11, 0x19A9,
    0x1777, 0x168D, 0x0F80, 0x0CF4, 0x08AC, 0x05C3, 0x00C4, 0xFCAA, 0xFB57, 0xF834, 0xF34E, 0xF116, 0xEE9F, 0xED38, 0xEDA0, 0xEF6D,
    0xF127, 0xE605, 0xE9EE, 0xE6F8, 0xE545, 0xE9D8, 0xED7F, 0xF5FA, 0xF956, 0x02D1, 0x09CD, 0x0FFB, 0x117A, 0x16DA, 0x1762, 0x1B2C,
    0x1D07, 0x1B5A, 0x2923, 0x2C08, 0x2DD2, 0x29F0, 0x2C5D, 0x35EA, 0x28C1, 0x2CA6, 0x29A6, 0x23FC, 0x1C79, 0x1206, 0x10B1, 0x07AE,
    0x01AA, 0x0324, 0xFF23, 0xFA0A, 0x020F, 0xEF47, 0xF20B, 0xEA6C, 0xE88F, 0xED5E, 0xE351, 0xF23F, 0xF522, 0xF303, 0xFB91, 0x0756,
    0xF736, 0xFBD4, 0x04F8, 0x00BA, 0x1410, 0xFE7E, 0xF4EF, 0x0BEC, 0xF0D8, 0xF96C, 0xF863, 0xEF28, 0xFF24, 0xE056, 0xEED2, 0xE954,
    0xE080, 0xF13B, 0xE2A7, 0xFFDA, 0x143B, 0xFE11, 0xF9C7, 0x1E92, 0x2170, 0x0C50, 0x023C, 0x1A3F, 0x0D6E, 0xFA46, 0x0C74, 0xFEB7,
    0xFD2B, 0xE001, 0xEA35, 0xFBBD, 0xECDD, 0xDBE6, 0xE6D2, 0x0301, 0xE393, 0xDF10, 0xE96A, 0xEB90, 0xF37F, 0xEA4B, 0xEDC6, 0x0245,
    0x039A, 0xEC51, 0xE970, 0xFE24, 0xF13E, 0xD887, 0xEF1E, 0xE33D, 0xE320, 0xDE35, 0xEB3C, 0xE851, 0xE0E2, 0x0476, 0xF8A9, 0xFB78,
    0xF728, 0x0FC2, 0x0782, 0x05D4, 0x0135, 0x102F, 0x1C57, 0x1018, 0x10F4, 0x0929, 0x0F1F, 0xF4A6, 0xF4C5, 0xEC77, 0xF592, 0xF221,
    0xE5B6, 0x0613, 0x091A, 0xFECE, 0xFA03, 0x147B, 0x1707, 0xF9BF, 0x0BBB, 0x0D71, 0x1A58, 0xF790, 0x0CF8, 0x2BFA, 0xFBCD, 0x0CDA,
    0x160B, 0x1258, 0x0259, 0xF8CE, 0x01A7, 0x076D, 0xEA7E, 0xF3F5, 0xF808, 0xEEE0, 0xF780, 0xF49C, 0x1109, 0xF9BC, 0x02FD, 0x0651,
    0x0E8A, 0x118A, 0xF3FA, 0x03AF, 0x0526, 0x0005, 0xEDBC, 0xFD36, 0xEA7B, 0xE3B8, 0xE6F1, 0xEC09, 0xDEE9, 0xDDB5, 0xE2F5, 0xCC08,
    0xF5AB, 0xDC18, 0xD5C0, 0xDEE2, 0xF177, 0xDDA2, 0xD1BC, 0xEDE5, 0xD29C, 0xDF3A, 0xE7D9, 0xDFA3, 0xE43B, 0xF4C9, 0xF43F, 0xFC0A,
    0x0101, 0xFF6C, 0x1495, 0x13EF, 0x19CE, 0x20F3, 0x248F, 0x1F11, 0x22E6, 0x3C63, 0x20B9, 0x3726, 0x33B4, 0x2D52, 0x3A31, 0x2E06,
    0x39CF, 0x2639, 0x2D7A, 0x1B96, 0x1FAE, 0x1CFF, 0x16F1, 0x11AB, 0x0A06, 0x1D20, 0x0033, 0x0AC6, 0x0956, 0xF80D, 0xF659, 0x0175,
    0xED7A, 0xE1D3, 0xFC5A, 0xEB08, 0xF97F, 0xE40E, 0xED63, 0xFD1D, 0xE78F, 0xE9FA, 0xF923, 0xEB6F, 0xCF5F, 0xE684, 0xE0A8, 0xE163,
    0xD86C, 0xD344, 0xD91A, 0xD91B, 0xD3DC, 0xBEEA, 0xD449, 0xD535, 0xD44E, 0xE659, 0xDBAC, 0xF6F5, 0xE8D8, 0xF9E5, 0x0EAA, 0xFE39,
    0x0654, 0x0796, 0x081A, 0x03E0, 0x0652, 0x0C09, 0xF2BB, 0xF624, 0x07B5, 0xF198, 0x133E, 0xEC1F, 0xF7BF, 0xFCFF, 0x001C, 0xFEB5,
    0xEEB4, 0x0AD9, 0xFE7F, 0x00AB, 0x0A6D, 0x17D3, 0x0C9D, 0x22C0, 0x1892, 0x15B8, 0x1C04, 0x21B9, 0x2971, 0x0E8B, 0x03FD, 0x1F00,
    0x28AE, 0x0FC2, 0x09C7, 0x1C0C, 0x1D01, 0x2078, 0x10DD, 0x1046, 0x0FD6, 0x166E, 0x0E99, 0x0A1D, 0x14E3, 0xF43C, 0x0E43, 0xFC32,
    0xD87E, 0xD8B4, 0xDDD4, 0xC421, 0xC6D1, 0xBCB4, 0xBE19, 0xD1AE, 0xBEE4, 0xB9D8, 0xCF63, 0xDAD6, 0xC8BE, 0xD5AC, 0xD72E, 0xDE19,
    0xEBAE, 0xE6F1, 0xEB60, 0x0236, 0x0272, 0xFB7D, 0x1330, 0x26A7, 0x0A10, 0x18A8, 0x273A, 0x0C8D, 0x14E9, 0x1683, 0x157D, 0x2AFD,
    0x226C, 0x26A4, 0x2738, 0x339B, 0x4BE6, 0x39A1, 0x292C, 0x4D66, 0x416E, 0x23A3, 0x4535, 0x301A, 0x3A7A, 0x2E10, 0x2DCB, 0x3E0D,
    0x28E8, 0x20AF, 0x1724, 0x0FA4, 0x0BB2, 0x0664, 0x06D0, 0xFAD3, 0xEF51, 0x0028, 0xFA10, 0xE09D, 0xE270, 0xD089, 0xD8E1, 0xD3C5,
    0xC1C2, 0xCFA4, 0xBC5B, 0xCDDC, 0xC33A, 0xCA74, 0xCFA5, 0xCD4F, 0xD7BF, 0xD50D, 0xCF21, 0xE270, 0xE1F5, 0xE1D9, 0xDF3F, 0xE7AB,
    0xFFBA, 0xE68C, 0x069A, 0x1215, 0xFBD7, 0x12C7, 0x13F8, 0x09C6, 0x1928, 0x08E4, 0x095E, 0x2EBD, 0x1CFE, 0x13AF, 0x2AC7, 0x146C,
    0x3174, 0x1ED8, 0x1002, 0x2119, 0x1AFB, 0x0204, 0x2174, 0x1EDA, 0xF51B, 0x1803, 0x04D7, 0x1F0D, 0x125E, 0xFDD4, 0x1AAD, 0x06E1,
    0x00F2, 0x0273, 0x0847, 0x123C, 0xF9C0, 0x0817, 0x1033, 0x0534, 0xF0D0, 0xFEC7, 0xE418, 0xE854, 0xE775, 0xDC76, 0xF398, 0xD689,
    0xFEF0, 0xF258, 0xF33E, 0xF56F, 0x05CE, 0x0763, 0xFF67, 0x0491, 0x0343, 0x0065, 0xF2CF, 0xF48E, 0xDF5B, 0xEE1A, 0xE5B4, 0xE1E2,
    0xE6CD, 0xE921, 0xD3C3, 0xDBAC, 0xE186, 0xCCCC, 0xD6B0, 0xD362, 0xD9C1, 0xDC80, 0xEB14, 0xE9D7, 0xE62C, 0xF7F9, 0xF375, 0x0095,
    0x02EC, 0x0D69, 0x048C, 0xFE69, 0x15C9, 0x0FE0, 0x1710, 0x09E4, 0x2F49, 0x1871, 0x1C06, 0x3C5A, 0x20DE, 0x32FA, 0x2EB0, 0x3F71,
    0x3862, 0x3B2C, 0x46E0, 0x3B5C, 0x3D82, 0x3EB8, 0x3396, 0x20A8, 0x1E93, 0x22DC, 0x1573, 0x0536, 0x0D1E, 0x0291, 0xF690, 0x0606,
    0x02A9, 0xF75D, 0x09B9, 0xFEE9, 0xEF89, 0x065B, 0xFCE9, 0xFE49, 0xF416, 0xFC36, 0x0892, 0x01A1, 0x0779, 0xFD6E, 0xF368, 0x0380,
    0xF812, 0xD457, 0xF3C8, 0xE2BE, 0xDEFA, 0xE350, 0xDF60, 0xDC0E, 0xE315, 0xF318, 0xEDEC, 0xEF96, 0xF2CA, 0xFAAF, 0xF3E8, 0xFBFB,
    0xFFAD, 0x0143, 0xF6F1, 0x08FB, 0x017A, 0x0EFF, 0x1137, 0xF404, 0x0208, 0x0451, 0xF062, 0xF2D2, 0x07D2, 0x0218, 0xF78F, 0x0035,
    0x0069, 0xFF58, 0x03C5, 0xE3E4, 0xF6F6, 0xFE22, 0xED1B, 0xDEF3, 0xF035, 0xEF96, 0xF51E, 0xF85D, 0xE695, 0x0C2E, 0xF765, 0xFE5D,
    0x1A13, 0xF71E, 0x02F7, 0x01DE, 0xFB50, 0x1433, 0x0032, 0x120F, 0x0F8C, 0x149E, 0x18FF, 0x0ED4, 0x0C77, 0x135A, 0x0556, 0x064A,
    0x0A70, 0xFEA9, 0x095A, 0xF7AC, 0xF6CE, 0xFF35, 0xFA82, 0xEDDF, 0x0184, 0xF381, 0xF496, 0xE4E7, 0xF01C, 0xE9BF, 0xEE41, 0xFC52,
    0xE43A, 0xFBFD, 0xFF70, 0xF5E0, 0xF582, 0x054D, 0xEBC5, 0xF832, 0x0AA5, 0x1474, 0xFB42, 0x0768, 0x0F9E, 0xF549, 0x0771, 0xF886,
    0xE8FC, 0xEA26, 0xF647, 0xE6C2, 0xE5C2, 0xE3FB, 0xE9A8, 0xF7E7, 0xF451, 0xF1E5, 0x0681, 0xFC13, 0x09A6, 0x0DB7, 0xF3EE, 0x0472,
    0x0A9A, 0x0CD4, 0xFE81, 0x0A31, 0x085D, 0xFBCB, 0xFEE4, 0x0A8B, 0xFBCF, 0xECA1, 0xFB64, 0xFCAE, 0xF034, 0xF5A0, 0x0191, 0xF0DA,
    0xEEF6, 0x0B98, 0x0220, 0xF409, 0x0748, 0x0A27, 0xFE37, 0xF230, 0xFE4D, 0xF990, 0xF7DA, 0x0070, 0xFE06, 0xF196, 0x056F, 0x0C91,
    0xEBA3, 0xFB8E, 0x07D0, 0x1103, 0xFFC1, 0x0B2F, 0x2673, 0x13A5, 0x2458, 0x21D1, 0x1763, 0x1FE9, 0x2315, 0x0D75, 0x0850, 0x1172,
    0x06A8, 0xEC52, 0xF056, 0xFA7E, 0xE3AB, 0xF077, 0xF9A2, 0xF3CE, 0xF77E, 0xEA19, 0xFB9D, 0xF5E4, 0xE982, 0xFF01, 0xF15D, 0xFF65,
    0x095A, 0x102F, 0x088E, 0x09B6, 0x0FA5, 0x13EA, 0x0006, 0x091E, 0x1450, 0xF2F5, 0x0320, 0x04EA, 0xFEA0, 0xFE48, 0x12C6, 0x0AE8,
    0x0A63, 0x14E6, 0x1667, 0x17C8, 0x1A7B, 0x10D6, 0x0ECA, 0x169C, 0x154E, 0x1733, 0x02B9, 0x093E, 0x0BDD, 0xF212, 0xDE0F, 0xE3CD,
    0xDACC, 0xDD4A, 0xD178, 0xCF98, 0xD97F, 0xCB92, 0xCAC8, 0xC3DE, 0xC521, 0xBE14, 0xC4AF, 0xB9E5, 0xB463, 0xC0E9, 0xBDB8, 0xBFA7,
    0xB647, 0xCDB9, 0xCE9F, 0xD524, 0xE6B0, 0xD70C, 0xF0C2, 0xF382, 0xF9AA, 0x0375, 0x03FF, 0x10C5, 0x1E67, 0x1CA6, 0x2281, 0x3606,
    0x2B45, 0x2C53, 0x3932, 0x364B, 0x2AAC, 0x3060, 0x310E, 0x2BEF, 0x23A0, 0x278F, 0x32BE, 0x2696, 0x255E, 0x2C27, 0x2515, 0x114F,
    0x217B, 0x1E22, 0x01F4, 0x192C, 0x0BDF, 0x0A4B, 0x05BB, 0x0A6A, 0x096D, 0xF706, 0x04E7, 0xFE7C, 0xFBCE, 0xFC3A, 0x0855, 0xFAA5,
    0x03ED, 0x07C0, 0xF885, 0xFCAB, 0xFBB8, 0xFAC9, 0xF217, 0xE1B0, 0xEEC4, 0xE9C4, 0xDDC7, 0xE5A6, 0xE4C8, 0xF165, 0xEA4E, 0xFB83,
    0xFC9F, 0xF485, 0x0A2D, 0x0AE3, 0x00D2, 0x03AE, 0x0D4A, 0x1F7F, 0x105D, 0x0B3D, 0x1A1C, 0x1641, 0x1002, 0x14C6, 0x11C5, 0x0EB7,
    0x1BF3, 0x0C17, 0x07B2, 0x043B, 0x0E48, 0x0976, 0x002E, 0x0E9D, 0x101A, 0x0C58, 0x0320, 0x10FB, 0x08BA, 0xF682, 0x0D2D, 0x036D,
    0xFF87, 0x0B33, 0x11BC, 0x0B14, 0x0670, 0x0BD2, 0x04EE, 0x0218, 0x09B3, 0x0E1C, 0x0898, 0x12BB, 0x1551, 0x183C, 0x19CE, 0x0FE5,
    0x14A8, 0x106A, 0x0477, 0x0F6B, 0xF7CA, 0xF75B, 0xEED5, 0xE014, 0xDE24, 0xDE46, 0xD7BF, 0xDA13, 0xDB3C, 0xDB4C, 0xE659, 0xD617,
    0xE1D4, 0xDD90, 0xDD3A, 0xE010, 0xE99A, 0xE77C, 0xE9DF, 0xF089, 0xF7D3, 0x016F, 0xF935, 0x004E, 0x0514, 0xFC1A, 0x0826, 0x0377,
    0xF7C8, 0x02A0, 0x1134, 0x04A5, 0x0F68, 0x21F9, 0x199A, 0x2157, 0x1C94, 0x31E2, 0x24C9, 0x2E4A, 0x395E, 0x3426, 0x3648, 0x3554,
    0x3451, 0x352D, 0x38AB, 0x310F, 0x23DE, 0x1D8F, 0x2BC6, 0x1A05, 0x1B4F, 0x129E, 0x1499, 0x13A4, 0x0A2A, 0x0568, 0xFDF6, 0xFB8E,
    0xEDD0, 0xE3E5, 0xD390, 0xD4C5, 0xCDE2, 0xC319, 0xC020, 0xC36A, 0xC263, 0xC083, 0xC06C, 0xC5A3, 0xCB78, 0xC22C, 0xC649, 0xCE51,
    0xCEA4, 0xCE5D, 0xD74B, 0xDA34, 0xE235, 0xE7BD, 0xECFB, 0xFAA3, 0xF87E, 0x0204, 0xFE13, 0x055E, 0x09AE, 0x0D3F, 0x17F4, 0x1327,
    0x2197, 0x2425, 0x2CEB, 0x2BCF, 0x2B68, 0x2FB0, 0x2EEE, 0x2C9A, 0x3142, 0x3A63, 0x33D2, 0x3827, 0x35E9, 0x2D77, 0x2D74, 0x2E41,
    0x2816, 0x2B6B, 0x29BC, 0x2B4B, 0x2DF1, 0x2DA1, 0x2CA1, 0x29C1, 0x2EB2, 0x2D21, 0x29F9, 0x2326, 0x200E, 0x1578, 0x0A75, 0x052D,
    0xFF57, 0xF925, 0xF554, 0xF64A, 0xF708, 0xF717, 0xF495, 0xF313, 0xF140, 0xF403, 0xEF03, 0xEC04, 0xF14A, 0xED20, 0xEAA3, 0xEDC7,
    0xE3D2, 0xE2DD, 0xE2E5, 0xDDE0, 0xDAF1, 0xD81A, 0xDA30, 0xCD8E, 0xCCDD, 0xCDF3, 0xCCB0, 0xCBA8, 0xD171, 0xD6EA, 0xD829, 0xDBD1,
    0xDC7E, 0xDC01, 0xE207, 0xEB20, 0xEC0E, 0xEFF7, 0xF601, 0x04B3, 0x072E, 0x05C2, 0x0DA9, 0x1057, 0x101B, 0x146F, 0x150A, 0x168B,
    0x1EB0, 0x1E15, 0x25BC, 0x2A96, 0x24D1, 0x3088, 0x28EE, 0x316A, 0x2A00, 0x16AD, 0x2094, 0x13B6, 0x03CD, 0x04FB, 0x07B5, 0xFB90,
    0xFDF5, 0xF377, 0xF90C, 0xF750, 0xF084, 0xF512, 0xF23B, 0xF0E8, 0xEEBC, 0xF1A2, 0xF056, 0xF8DF, 0xF782, 0x02B4, 0xFF25, 0x020D,
    0x0B41, 0x0B1A, 0xFF10, 0xF624, 0xFF19, 0xF75A, 0xF3C4, 0xEA69, 0xEFE9, 0xEE94, 0xF1B2, 0xF046, 0xECB8, 0xF867, 0xEE1B, 0xED9C,
    0xF662, 0xFB89, 0x00AC, 0x03EE, 0x01ED, 0x0525, 0x07F4, 0x0270, 0x085E, 0x0D67, 0x0522, 0x050A, 0x0178, 0x0174, 0xFCF8, 0xFF7A,
    0x0726, 0x006C, 0x028C, 0x0D3D, 0x0819, 0xFCA2, 0x03AA, 0xF7DF, 0xF398, 0xEEBC, 0xEA69, 0xEBC4, 0xEA38, 0xE854, 0xEDCE, 0xE957,
    0xEE6E, 0xF762, 0xEA01, 0xFC54, 0x00D4, 0xFE49, 0xF93C, 0x04F5, 0x1176, 0x0DDE, 0x1829, 0x217C, 0x1A14, 0x252D, 0x29C0, 0x2668,
    0x2616, 0x20D2, 0x2934, 0x1C0C, 0x241F, 0x2530, 0x235D, 0x2200, 0x1FE2, 0x1E3E, 0x1843, 0x1443, 0x0D9D, 0x0540, 0x04F9, 0x0B3E,
    0xFE36, 0xFB9B, 0xFA5C, 0xED18, 0xE937, 0xE91A, 0xE445, 0xE60A, 0xDF10, 0xE6E4, 0xE977, 0xE73F, 0xEA49, 0xEF26, 0xF7FC, 0x0130,
    0x02FF, 0xF8E2, 0x000C, 0xF9BF, 0xF005, 0xF007, 0xEDF0, 0xF1DF, 0xEC47, 0xEECF, 0xF26F, 0xF03A, 0x058E, 0xFF78, 0x0183, 0x08C7,
    0x0814, 0x0B88, 0x0992, 0x1884, 0x0F57, 0x1060, 0x1A18, 0x13A5, 0x109A, 0x14EB, 0x0922, 0xFF09, 0x03AC, 0xF4E2, 0xF4A2, 0xEF9A,
    0xEDD1, 0xEF69, 0xE71E, 0xEDDA, 0xE865, 0xE701, 0xE2D0, 0xDE12, 0xDE13, 0xE2CA, 0xE058, 0xE559, 0xE14E, 0xDFDC, 0xEA1B, 0xE480,
    0xEA01, 0xE60A, 0xE995, 0xE7EF, 0xEC22, 0xEB16, 0xEA43, 0xF0EB, 0xF4FB, 0x015A, 0x0302, 0x0EAF, 0x14C1, 0x0F24, 0x1041, 0x114A,
    0x1079, 0x0692, 0x0313, 0x016D, 0xFA60, 0xFE72, 0xFB27, 0xF246, 0xF2E5, 0xF610, 0xF429, 0xF3DA, 0xF58F, 0xF694, 0xF275, 0xF70D,
    0xF386, 0xF9B5, 0xFF61, 0x0666, 0x09BB, 0x0906, 0x1457, 0x0FC4, 0x0CCC, 0x0724, 0x0E86, 0x06D1, 0x08FE, 0x0C65, 0x0C2C, 0x109C,
    0x11B6, 0x1412, 0x106F, 0x1469, 0x195B, 0x1B2B, 0x1ACC, 0x21C6, 0x24CD, 0x3224, 0x279C, 0x22D7, 0x2BA7, 0x24CF, 0x2539, 0x1E31,
    0x1D0B, 0x16D2, 0x0EA6, 0x081B, 0xFB3B, 0xFDAC, 0xFC03, 0xFC46, 0xF54E, 0xF5CA, 0xF4BD, 0xEFDD, 0xEACB, 0xE01D, 0xDFDF, 0xCEBA,
    0xD162, 0xCDE8, 0xC829, 0xC8BE, 0xCE2D, 0xCFEF, 0xCB35, 0xD2C8, 0xD330, 0xD81E, 0xD81D, 0xDBB2, 0xDF17, 0xDFE6, 0xE95A, 0xEDA0,
    0xED40, 0xF695, 0xFA90, 0x008A, 0x072B, 0x092C, 0x0470, 0x0868, 0x1261, 0x11F1, 0x16D8, 0x1587, 0x1AE9, 0x19ED, 0x18E4, 0x181B,
    0x182F, 0x185A, 0x16A9, 0x16DC, 0x1495, 0x1BB5, 0x1687, 0x17F3, 0x160A, 0x1943, 0x17CA, 0x1176, 0x11BD, 0x0A98, 0x08AD, 0x096F,
    0x0996, 0x067B, 0x0307, 0x04D2, 0x070E, 0x0130, 0x00D4, 0xF89B, 0xF788, 0xEB1E, 0xE4FF, 0xDD36, 0xD73B, 0xD6D0, 0xCD1F, 0xCC12,
    0xCAEB, 0xCC05, 0xCE25, 0xD77B, 0xD474, 0xDA65, 0xD80A, 0xDBDE, 0xDC08, 0xDF0E, 0xEDE6, 0xEE14, 0xF892, 0xFD2F, 0x03CD, 0x0534,
    0x0246, 0x06AF, 0x0204, 0x06A9, 0x0650, 0x061C, 0x0A0C, 0x0914, 0x0E5C, 0x081F, 0x0752, 0x05F8, 0x02EF, 0x03CF, 0x0054, 0x060D,
    0x0232, 0x029F, 0x0230, 0x00C9, 0x0421, 0x00F9, 0x09BE, 0x03F5, 0x05A0, 0x01B0, 0x0469, 0x0206, 0xFDE0, 0x0343, 0x0467, 0x0D5E,
    0x103B, 0x1907, 0x14C2, 0x1AE5, 0x17C3, 0x125A, 0x115C, 0x0D23, 0x08BE, 0xFED1, 0xFD0B, 0xF9A1, 0xF715, 0xF2DC, 0xED9D, 0xE9D4,
    0xE74B, 0xE855, 0xE7CF, 0xE0D3, 0xE16D, 0xDF3B, 0xE1AF, 0xE501, 0xE9FB, 0xEBF7, 0xF218, 0xFF21, 0xF7D8, 0xFCC7, 0xFB58, 0xFD22,
    0x0088, 0x055E, 0x0770, 0x08C8, 0x10E6, 0x1038, 0x14B8, 0x10AC, 0x1617, 0x1BA0, 0x1C08, 0x1CFD, 0x1FFE, 0x2741, 0x2D42, 0x2F41,
    0x3330, 0x31B1, 0x34D7, 0x362C, 0x3210, 0x2D43, 0x25EB, 0x2177, 0x19F6, 0x1356, 0x0BB1, 0x066B, 0x05E1, 0x0682, 0x0339, 0x0137,
    0xFA87, 0xFCD1, 0xF484, 0xED5E, 0xE990, 0xE0AA, 0xDB0E, 0xD0E0, 0xCB9E, 0xC6F9, 0xC513, 0xC239, 0xC353, 0xC059, 0xBDEB, 0xBF8A,
    0xBEE9, 0xBDD8, 0xC538, 0xC85A, 0xCC2F, 0xD401, 0xDA8E, 0xE001, 0xE30B, 0xEB12, 0xEA51, 0xF076, 0xF01E, 0xF4AD, 0xF9CC, 0xF84B,
    0xFB07, 0xFD12, 0x0283, 0x00EF, 0x06D0, 0x0988, 0x0D1E, 0x108A, 0x1222, 0x1184, 0x1010, 0x155C, 0x174A, 0x1901, 0x1A10, 0x1D2E,
    0x1CED, 0x1B8A, 0x19F3, 0x13A8, 0x10DD, 0x11A1, 0x1573, 0x15A2, 0x17A2, 0x1BFD, 0x1CA1, 0x23E1, 0x2353, 0x275D, 0x238E, 0x23EA,
    0x2058, 0x14A0, 0x1437, 0x0A33, 0x0B01, 0x0270, 0xFF6A, 0xF982, 0xF8C8, 0xFC65, 0xF66C, 0xF731, 0xF0C0, 0xECCA, 0xEB30, 0xE938,
    0xEF1F, 0xEF1B, 0xECEB, 0xF185, 0xEBA6, 0xEB62, 0xE151, 0xDD77, 0xDA25, 0xD57E, 0xD670, 0xCEE4, 0xD138, 0xD000, 0xCF8F, 0xD098,
    0xCAD6, 0xD02B, 0xD0A7, 0xCECB, 0xD2C3, 0xD3E9, 0xD97C, 0xDA81, 0xE4A5, 0xE7CA, 0xED5F, 0xF97C, 0xFDB2, 0x0346, 0x082E, 0x0B86,
    0x0CDE, 0x0FD1, 0x1335, 0x18F1, 0x1F9D, 0x24AD, 0x2B21, 0x3601, 0x395F, 0x3E4A, 0x3F92, 0x3F9A, 0x3E33, 0x3CF4, 0x3C54, 0x32EA,
    0x3106, 0x2BC6, 0x29C1, 0x266E, 0x2118, 0x1BFB, 0x173D, 0x1507, 0x0C53, 0x05CB, 0x036E, 0x012C, 0x0320, 0xFE19, 0xFE9E, 0x0311,
    0x0009, 0x0292, 0xFBF0, 0xFAA9, 0xF49B, 0xF2DE, 0xF1AC, 0xEC75, 0xEC98, 0xE84A, 0xE77E, 0xE5BA, 0xDFC0, 0xE08E, 0xE23E, 0xE0CE,
    0xE1D1, 0xDF73, 0xDF75, 0xE197, 0xE7EB, 0xEBE1, 0xF3E8, 0xF816, 0xFB59, 0xFC27, 0x0008, 0x0109, 0x018F, 0x0265, 0x0148, 0x030C,
    0x011D, 0x05C2, 0x0821, 0x08E0, 0x0B30, 0x1068, 0x0EB6, 0x1118, 0x0C68, 0x09F0, 0x04E9, 0xFBDB, 0xF5D8, 0xEE3C, 0xEC6F, 0xE79A,
    0xE681, 0xE26C, 0xE0CC, 0xDC91, 0xD9AC, 0xD3F6, 0xD0DD, 0xD174, 0xD422, 0xDBD4, 0xE03C, 0xE8CA, 0xEDB7, 0xF646, 0xF8AB, 0xFC33,
    0x0022, 0x037C, 0x0BC1, 0x0EB0, 0x12F1, 0x1456, 0x1564, 0x1748, 0x1B16, 0x1A47, 0x1A1E, 0x18A7, 0x1AC0, 0x19CA, 0x159F, 0x12D3,
    0x0D97, 0x0D55, 0x0CAB, 0x082F, 0x0561, 0x040C, 0x0248, 0xFD20, 0xF8CE, 0xF170, 0xEAF0, 0xEA33, 0xE61C, 0xE95E, 0xE875, 0xE9E2,
    0xED94, 0xF247, 0xF3BC, 0xF914, 0xFB9B, 0xFDF9, 0xFB56, 0xF72C, 0xF6DA, 0xF46D, 0xF42C, 0xF431, 0xF498, 0xF4DB, 0xFABF, 0xF9CB,
    0x01A6, 0xFF98, 0x01AA, 0x034A, 0x050F, 0x0D47, 0x110B, 0x174F, 0x1D97, 0x20C9, 0x20A0, 0x1F7D, 0x1EAD, 0x1CDF, 0x195F, 0x1865,
    0x16A7, 0x14F6, 0x11C2, 0x13A5, 0x11E0, 0x11E0, 0x0E63, 0x0CD1, 0x0984, 0x0692, 0x01D3, 0x017C, 0xFFAD, 0xFD73, 0xFFAD, 0xFE8B,
    0x017F, 0xFDD9, 0xFF28, 0xFCA1, 0xFB09, 0xF6E3, 0xF3D9, 0xF138, 0xEE38, 0xEF0F, 0xEBDD, 0xEC4F, 0xED86, 0xF1AA, 0xF541, 0xF843,
    0xFA5F, 0xFA29, 0xFC7F, 0xFAF2, 0xF6D9, 0xF235, 0xF0B1, 0xF233, 0xF3E5, 0xF6E4, 0xF4E5, 0xF2D9, 0xF21A, 0xEEA2, 0xEAB3, 0xE82E,
    0xE7DB, 0xEC6E, 0xF0DD, 0xF2B2, 0xF62F, 0xFA11, 0xFEFC, 0x0373, 0x0705, 0x0BF2, 0x0E54, 0x0FEC, 0x11D8, 0x11DD, 0x129D, 0x141A,
    0x121E, 0x1192, 0x0F36, 0x0C9F, 0x0D28, 0x09E9, 0x09FC, 0x068C, 0x047D, 0x0525, 0x090F, 0x0E1F, 0x1270, 0x1777, 0x1876, 0x192E,
    0x1785, 0x1553, 0x1267, 0x0F66, 0x0B4B, 0x06DE, 0x0150, 0xFF8E, 0xFA49, 0xF7E5, 0xF997, 0xF77F, 0xF8A8, 0xF645, 0xF505, 0xF218,
    0xEB1C, 0xE7B4, 0xE134, 0xDB93, 0xD802, 0xD4FA, 0xD44A, 0xD060, 0xCE44, 0xCA46, 0xC669, 0xC56D, 0xC2E4, 0xC3E9, 0xC770, 0xCC61,
    0xD502, 0xD9E0, 0xE10F, 0xE8C7, 0xEE82, 0xF5FA, 0xFA69, 0xFFB9, 0x0707, 0x0AF2, 0x102E, 0x1415, 0x1544, 0x1BD1, 0x1EDC, 0x2346,
    0x2403, 0x244D, 0x26AF, 0x2698, 0x2715, 0x2455, 0x2546, 0x26CE, 0x299A, 0x2B1E, 0x2959, 0x2AEE, 0x2CF8, 0x2A81, 0x2723, 0x2440,
    0x2015, 0x1EF3, 0x1B88, 0x1B8D, 0x181A, 0x1807, 0x1AFC, 0x18F1, 0x1CE3, 0x1B72, 0x1D06, 0x196C, 0x13DA, 0x0F8A, 0x06C1, 0x02B8,
    0xFF0D, 0xFC47, 0xF856, 0xF483, 0xF081, 0xEC86, 0xE9CC, 0xEA4B, 0xE9A6, 0xE73C, 0xE815, 0xE8A2, 0xEC27, 0xEE01, 0xF01E, 0xF335,
    0xF5A6, 0xF83D, 0xF8C4, 0xF7C8, 0xF6C0, 0xF57A, 0xF3E5, 0xF1B7, 0xEFF0, 0xF127, 0xF0A2, 0xF378, 0xF323, 0xF30F, 0xEEEA, 0xEDC6,
    0xEC3E, 0xE8D5, 0xEAEE, 0xECD4, 0xF221, 0xF400, 0xFA90, 0xFAD3, 0xFBC1, 0xFE41, 0xFDAE, 0x0167, 0x00D7, 0x00AC, 0x039B, 0x0299,
    0x061C, 0x092F, 0x0D79, 0x164A, 0x1BF1, 0x2497, 0x269C, 0x28AE, 0x29E3, 0x2761, 0x23A6, 0x1E82, 0x1A9C, 0x17AA, 0x14FD, 0x0F02,
    0x08D6, 0x0020, 0xF85A, 0xEFCB, 0xE64F, 0xDF6E, 0xDA8B, 0xD95C, 0xD824, 0xD5CE, 0xD405, 0xD48C, 0xD6D8, 0xD860, 0xD9F3, 0xDD80,
    0xDFAC, 0xE033, 0xDF7B, 0xE177, 0xE52E, 0xE99D, 0xEF22, 0xF33D, 0xF962, 0xFC28, 0x0103, 0x04F6, 0x075C, 0x0BA0, 0x0CDB, 0x118D,
    0x1549, 0x1C73, 0x25EE, 0x2E40, 0x338D, 0x3441, 0x3762, 0x383F, 0x3660, 0x33AF, 0x302C, 0x2BC8, 0x293E, 0x230D, 0x1F20, 0x1C59,
    0x1B8E, 0x1AEC, 0x1930, 0x171E, 0x1127, 0x0CF6, 0x0736, 0x0377, 0xFC22, 0xF69F, 0xF1FF, 0xED0E, 0xE652, 0xDFB5, 0xD8E6, 0xD342,
    0xCE9E, 0xCA6E, 0xC849, 0xC3D9, 0xC64C, 0xC85E, 0xC9BC, 0xCE07, 0xD17B, 0xD6BA, 0xDBDF, 0xDFA2, 0xE2D2, 0xE394, 0xE8AC, 0xEC21,
    0xEF2E, 0xF26F, 0xF6FC, 0xFEB3, 0x032A, 0x06FE, 0x08F0, 0x0BFA, 0x0FCC, 0x1287, 0x14E1, 0x193F, 0x1CF0, 0x233E, 0x2792, 0x2AC1,
    0x2ED2, 0x3165, 0x35C1, 0x36E1, 0x36CF, 0x3509, 0x3453, 0x3016, 0x2B58, 0x2A29, 0x2907, 0x2AA0, 0x2A81, 0x2B10, 0x2DCD, 0x2DC9,
    0x2B77, 0x292B, 0x22C2, 0x1B00, 0x1566, 0x1060, 0x0D72, 0x0972, 0x04AD, 0xFE2E, 0xF7B8, 0xF170, 0xEC34, 0xEBCE, 0xEB69, 0xEA53,
    0xEA15, 0xEA7D, 0xEC16, 0xEC11, 0xED9E, 0xF11E, 0xF1F7, 0xF48F, 0xF456, 0xF2B0, 0xF119, 0xEE5C, 0xED8C, 0xEBA3, 0xEB0E, 0xE9AA,
    0xE952, 0xEAA9, 0xE894, 0xE685, 0xE1BA, 0xDDE5, 0xDADD, 0xD706, 0xD49A, 0xD30F, 0xD3B5, 0xD3B8, 0xD6E3, 0xD8AC, 0xDBB8, 0xDEEE,
    0xE3A1, 0xE6E8, 0xE65D, 0xE91C, 0xE9A0, 0xEE50, 0xF0EF, 0xF372, 0xFBF0, 0x0425, 0x0E20, 0x154C, 0x1BC2, 0x1F8C, 0x2458, 0x284B,
    0x29C0, 0x2CAA, 0x2DDB, 0x31C8, 0x33A7, 0x32C3, 0x2F4E, 0x2CD3, 0x27A3, 0x212C, 0x1A08, 0x131C, 0x0E3C, 0x09FE, 0x07DE, 0x0577,
    0x0545, 0x0402, 0x0383, 0x038E, 0x0355, 0x02D7, 0x0195, 0xFDE9, 0xF9A1, 0xF7CA, 0xF698, 0xF7B9, 0xF80F, 0xF781, 0xF69D, 0xF386,
    0xF0A9, 0xEAE2, 0xE9BB, 0xE7C8, 0xE35F, 0xE1C3, 0xE0D8, 0xE333, 0xE845, 0xED13, 0xF2E3, 0xFA8F, 0xFDE0, 0x0368, 0x03D4, 0x03AC,
    0x03A7, 0x024A, 0x02CA, 0x040C, 0x07EE, 0x0AE8, 0x0F8F, 0x134A, 0x15DE, 0x16ED, 0x1761, 0x1765, 0x1858, 0x18C3, 0x1905, 0x1851,
    0x173A, 0x1586, 0x10F9, 0x0D07, 0x07A2, 0x0229, 0xFF53, 0xFBEF, 0xF852, 0xF514, 0xF305, 0xF334, 0xF2E6, 0xF459, 0xF870, 0xFE11,
    0x0353, 0x04F2, 0x05FC, 0x0872, 0x09A5, 0x0B66, 0x0E4B, 0x10D4, 0x13F3, 0x170E, 0x18D5, 0x1852, 0x1741, 0x147A, 0x117D, 0x108D,
    0x0E88, 0x0CDC, 0x0AF9, 0x0929, 0x069E, 0x0414, 0x01DD, 0x01A2, 0x023A, 0x014B, 0xFFE4, 0xFC5D, 0xF67C, 0xF0B9, 0xEB08, 0xE860,
    0xE894, 0xE8B5, 0xEAF9, 0xEBE7, 0xEDC6, 0xF15F, 0xF3E6, 0xF68B, 0xFA3A, 0xFD2E, 0xFDEC, 0xFF3C, 0x014C, 0x0393, 0x043D, 0x027B,
    0x0042, 0xFCE4, 0xFAAD, 0xF925, 0xF91D, 0xF83D, 0xF72C, 0xF8C6, 0xF9F9, 0xFBE2, 0xFE28, 0x02CB, 0x067B, 0x07EC, 0x0964, 0x07DD,
    0x0597, 0x0415, 0x0210, 0x00BF, 0x006B, 0x008C, 0x003E, 0x0176, 0x0079, 0xFF7A, 0xFED4, 0xFC1E, 0xFBB4, 0xF956, 0xF634, 0xF5EA,
    0xF4E5, 0xF696, 0xF8A7, 0xF990, 0xFD11, 0xFE39, 0xFF73, 0xFD07, 0xF8EC, 0xF6FF, 0xF48F, 0xF257, 0xF214, 0xF16B, 0xF381, 0xF704,
    0xF7A7, 0xF9CA, 0xFA9F, 0xFC8C, 0xFD9A, 0xFFC7, 0x0170, 0x02CE, 0x04EA, 0x03EB, 0x03B9, 0x029A, 0x0126, 0x0064, 0xFE00, 0xF979,
    0xF5D6, 0xF21A, 0xEED2, 0xEC4B, 0xEB79, 0xEED2, 0xF2C6, 0xF788, 0xFACD, 0x00AD, 0x0461, 0x0766, 0x0B57, 0x0B6A, 0x0D8F, 0x0EB6,
    0x12C4, 0x1748, 0x1B65, 0x1F33, 0x1FEF, 0x1FE8, 0x1EF9, 0x1CD5, 0x1CB6, 0x1C0D, 0x1A3A, 0x18D3, 0x1717, 0x1877, 0x1D2B, 0x2372,
    0x2A64, 0x31FB, 0x3631, 0x387B, 0x385F, 0x34FE, 0x3032, 0x2C45, 0x298A, 0x27C7, 0x24D5, 0x2360, 0x2112, 0x1CB3, 0x1959, 0x134F,
    0x0E0B, 0x07C6, 0x033D, 0xFF07, 0xF8F1, 0xF36C, 0xED60, 0xE5A9, 0xDED9, 0xD6D5, 0xCF09, 0xC96A, 0xC3A3, 0xBE93, 0xB876, 0xB53D,
    0xB415, 0xB411, 0xB481, 0xB858, 0xBDF3, 0xC3DF, 0xC99F, 0xCE2A, 0xD374, 0xD864, 0xDDC1, 0xE3B0, 0xEACF, 0xF232, 0xFC45, 0x0597,
    0x0E37, 0x142F, 0x1A2A, 0x2036, 0x230E, 0x25F7, 0x26F7, 0x28C6, 0x2A48, 0x29E1, 0x2A6E, 0x2B53, 0x2BFC, 0x2CCF, 0x2BB0, 0x2A69,
    0x2829, 0x24A5, 0x20A2, 0x1C0B, 0x17C2, 0x14C2, 0x1407, 0x14F5, 0x1300, 0x10AE, 0x0EAA, 0x0BED, 0x0AD1, 0x09D9, 0x0A16, 0x08A4,
    0x06A3, 0x034E, 0x0114, 0xFED1, 0xFBFA, 0xF993, 0xF526, 0xF072, 0xEBAA, 0xE752, 0xE3F8, 0xE2A0, 0xE111, 0xE123, 0xE267, 0xE403,
    0xE703, 0xE947, 0xEB9A, 0xEE04, 0xF04A, 0xF0B1, 0xF16C, 0xF37C, 0xF406, 0xF5CF, 0xF6C9, 0xF6B0, 0xF942, 0xFAC4, 0xFBDB, 0xFC55,
    0xFC8F, 0xFC48, 0xFB3E, 0xF888, 0xF435, 0xF216, 0xF156, 0xF1F3, 0xF451, 0xF7C0, 0xFC09, 0x0057, 0x00F4, 0x0120, 0xFDED, 0xFD1E,
    0xFEBF, 0xFF96, 0x0260, 0x0422, 0x0883, 0x0CAE, 0x0FD7, 0x1229, 0x15B2, 0x19E6, 0x1EA1, 0x2188, 0x250E, 0x28F6, 0x2AC8, 0x2B9C,
    0x2B33, 0x2AB6, 0x2A5E, 0x2825, 0x2470, 0x203B, 0x19A6, 0x122D, 0x09C5, 0x02C8, 0xFDF3, 0xFAEB, 0xFA41, 0xFA7D, 0xF868, 0xF780,
    0xF565, 0xF4B8, 0xF406, 0xF1F7, 0xF231, 0xF161, 0xF073, 0xF0A3, 0xF32A, 0xF55A, 0xF6F7, 0xF742, 0xF827, 0xF72A, 0xF65F, 0xF63C,
    0xF3F3, 0xF2E8, 0xF196, 0xF247, 0xF639, 0xFCDF, 0x0560, 0x0CBE, 0x12A1, 0x16E5, 0x18B5, 0x1971, 0x1994, 0x19B4, 0x1BD0, 0x1DBE,
    0x1EF6, 0x1F57, 0x1F5F, 0x1FA8, 0x1E2B, 0x1D40, 0x1B7C, 0x1A92, 0x1993, 0x18CC, 0x176E, 0x1595, 0x1582, 0x12C6, 0x0FA3, 0x0A6E,
    0x0561, 0xFE24, 0xF55D, 0xEC8F, 0xE2A1, 0xDBEC, 0xD726, 0xD249, 0xCD34, 0xCCB7, 0xCBB0, 0xCBBB, 0xCB79, 0xCB9F, 0xCD34, 0xCE8B,
    0xD04C, 0xD17C, 0xD33A, 0xD4EE, 0xD881, 0xDACB, 0xDE86, 0xE315, 0xE896, 0xECE2, 0xEF45, 0xF19E, 0xF2A1, 0xF425, 0xF6A1, 0xFA0D,
    0x0061, 0x0780, 0x0EAC, 0x14F0, 0x19B2, 0x1E56, 0x2165, 0x2385, 0x24B6, 0x243C, 0x22F2, 0x245C, 0x24A1, 0x267D, 0x2808, 0x27CD,
    0x2772, 0x2600, 0x2552, 0x25EC, 0x27BC, 0x282F, 0x275C, 0x2463, 0x22F3, 0x2029, 0x1E41, 0x1C44, 0x18B3, 0x123E, 0x0A25, 0x03EE,
    0xFC84, 0xF7E5, 0xF443, 0xF39B, 0xF371, 0xF38B, 0xF474, 0xF555, 0xF58E, 0xF52D, 0xF58F, 0xF545, 0xF5E1, 0xF69D, 0xF77C, 0xF617,
    0xF55D, 0xF4F5, 0xF4BE, 0xF516, 0xF40E, 0xF379, 0xF243, 0xEF2A, 0xEB10, 0xE4B2, 0xE05C, 0xDCEE, 0xDBAA, 0xDBCE, 0xDC3D, 0xE06F,
    0xE435, 0xE833, 0xE995, 0xEAC9, 0xEC92, 0xEF34, 0xF1A1, 0xF5AA, 0xFA53, 0xFF9A, 0x05BF, 0x0AAB, 0x0EC9, 0x139D, 0x19F7, 0x1EA0,
    0x2455, 0x27F3, 0x2CC1, 0x3141, 0x3407, 0x3794, 0x38E0, 0x3A62, 0x3BB9, 0x3A97, 0x3740, 0x3152, 0x2A4E, 0x2199, 0x17B6, 0x0F2A,
    0x07AF, 0x029A, 0xFEDF, 0xFBFE, 0xF87C, 0xF539, 0xF2EE, 0xF151, 0xF12B, 0xF1BF, 0xF11F, 0xF035, 0xEDF4, 0xED39, 0xEF62, 0xF1D7,
    0xF555, 0xF6E5, 0xF7CF, 0xF5B9, 0xF330, 0xF116, 0xEDEA, 0xEBEB, 0xE9CB, 0xEA78, 0xEBCF, 0xEE84, 0xF2EB, 0xF76F, 0xFA86, 0xFC94,
    0xFD4A, 0xFD23, 0xFD0A, 0xFB9D, 0xFA6C, 0xF8B1, 0xF775, 0xF6DB, 0xF766, 0xF904, 0xF92A, 0xF93D, 0xFA17, 0xFB2F, 0xFB81, 0xFA1E,
    0xFA9A, 0xFD87, 0x00E5, 0x01AE, 0x02B2, 0x0355, 0x01D6, 0xFE56, 0xF931, 0xF399, 0xEE59, 0xEAA0, 0xE907, 0xE8A3, 0xE71E, 0xE83F,
    0xE98F, 0xEB68, 0xECC8, 0xEE3F, 0xF1A0, 0xF407, 0xF603, 0xF722, 0xF857, 0xFB20, 0xFE29, 0x029A, 0x0765, 0x0BB1, 0x11BA, 0x141B,
    0x15BF, 0x1553, 0x134C, 0x11D5, 0x1158, 0x1114, 0x0F94, 0x11F4, 0x1340, 0x1386, 0x133F, 0x0FB0, 0x0DA3, 0x0B0A, 0x0851, 0x0592,
    0x0187, 0xFE02, 0xFA85, 0xF8FC, 0xF76F, 0xF658, 0xF622, 0xF52C, 0xF4C3, 0xF54C, 0xF699, 0xF8A9, 0xF9CC, 0xFB0B, 0xFCD7, 0xFE77,
    0x01BD, 0x037D, 0x05BF, 0x0491, 0x01C9, 0xFEF7, 0xFA7E, 0xFADC, 0xF98A, 0xFBC9, 0x005A, 0x03EA, 0x08C1, 0x0BDD, 0x1110, 0x1495,
    0x1712, 0x1B08, 0x1D47, 0x205D, 0x216F, 0x2136, 0x21EC, 0x22A2, 0x2472, 0x24C9, 0x23C1, 0x21E8, 0x1EEE, 0x1A18, 0x1430, 0x0D16,
    0x0789, 0x02D5, 0x0014, 0xFDDD, 0xFADC, 0xF939, 0xF6F3, 0xF447, 0xF14D, 0xEF03, 0xEBF1, 0xEACA, 0xE927, 0xE66D, 0xE567, 0xE3D8,
    0xE2F2, 0xE2B5, 0xE263, 0xE36D, 0xE411, 0xE4B6, 0xE5DC, 0xE6D5, 0xE814, 0xEB30, 0xF0F7, 0xF684, 0xFB92, 0x005A, 0x04D5, 0x0641,
    0x06AC, 0x05EC, 0x0440, 0x020D, 0xFF36, 0xFC9B, 0xF8DB, 0xF5DA, 0xF4E8, 0xF4F2, 0xF475, 0xF49D, 0xF465, 0xF48E, 0xF495, 0xF50C,
    0xF638, 0xF682, 0xF6CF, 0xF882, 0xFCAD, 0x01BC, 0x06FA, 0x0B6C, 0x0E95, 0x0C8D, 0x08B4, 0x059E, 0x01A3, 0x0006, 0xFF64, 0xFE52,
    0xFF1A, 0x0154, 0x0430, 0x082E, 0x0B8C, 0x109B, 0x1566, 0x19E5, 0x1DE9, 0x2111, 0x2261, 0x21FC, 0x22E5, 0x230E, 0x23EF, 0x2440,
    0x23ED, 0x2365, 0x2127, 0x1E19, 0x1A54, 0x14D7, 0x1193, 0x0F02, 0x0D97, 0x0AF3, 0x0656, 0x0244, 0xFA90, 0xF1AA, 0xE799, 0xDCA6,
    0xD3B3, 0xCC1E, 0xC61D, 0xC02E, 0xBB98, 0xBA85, 0xB940, 0xB928, 0xB9F2, 0xBC41, 0xC002, 0xC294, 0xC534, 0xC8B3, 0xCD18, 0xD236,
    0xD991, 0xE237, 0xEC19, 0xF5C0, 0xFF47, 0x084D, 0x0E77, 0x1280, 0x1621, 0x190C, 0x1C2C, 0x200B, 0x24A6, 0x2A7D, 0x2F22, 0x3231,
    0x334D, 0x34DE, 0x3591, 0x352D, 0x35E2, 0x3596, 0x34ED, 0x32EA, 0x3041, 0x2F79, 0x2FE3, 0x30D7, 0x3143, 0x30FE, 0x2F7B, 0x2D15,
    0x2BE9, 0x29AA, 0x28EC, 0x280B, 0x2645, 0x25B1, 0x23F3, 0x20D7, 0x1CD0, 0x1772, 0x102F, 0x07F3, 0xFEDF, 0xF66D, 0xEF49, 0xEA51,
    0xE38F, 0xDE5B, 0xDBF9, 0xDA1E, 0xDA3F, 0xD97A, 0xD838, 0xD6BC, 0xD597, 0xD3B1, 0xD241, 0xD0AF, 0xD1FD, 0xD641, 0xD96A, 0xDD4E,
    0xE010, 0xE29A, 0xE4D3, 0xE623, 0xE69C, 0xE515, 0xE6B5, 0xE95D, 0xEAFA, 0xED14, 0xEEC4, 0xF1A9, 0xF497, 0xF6BA, 0xF8FE, 0xFC8C,
    0xFF25, 0x014F, 0x037B, 0x0442, 0x04B7, 0x0647, 0x07A8, 0x090C, 0x0A26, 0x098A, 0x09F1, 0x097A, 0x09B2, 0x08ED, 0x09CB, 0x0CAA,
    0x1215, 0x1A4E, 0x1F55, 0x22FF, 0x261B, 0x243C, 0x2052, 0x1E9E, 0x19CE, 0x1544, 0x1033, 0x09A4, 0x0220, 0xFB38, 0xF627, 0xF3DB,
    0xF282, 0xF024, 0xEE49, 0xEBF7, 0xE937, 0xE6F5, 0xE698, 0xE612, 0xE627, 0xE5D7, 0xE71B, 0xE9C8, 0xECD8, 0xEDD1, 0xEDFD, 0xED1A,
    0xEA7C, 0xE88C, 0xE627, 0xE618, 0xE6D9, 0xE88B, 0xEAE1, 0xED3D, 0xF1DA, 0xF8BB, 0xFFD0, 0x0671, 0x0BF0, 0x1157, 0x16A4, 0x1AA3,
    0x1C4E, 0x1C2E, 0x1CF4, 0x1DFE, 0x1E99, 0x1E6D, 0x1D54, 0x1C5E, 0x1AED, 0x1943, 0x1750, 0x1503, 0x15AA, 0x1751, 0x195E, 0x1A2A,
    0x1AA8, 0x1BC3, 0x198E, 0x1682, 0x1278, 0x0C74, 0x063C, 0xFFE9, 0xF904, 0xF23E, 0xEBEF, 0xE75F, 0xE448, 0xE2C3, 0xE2B1, 0xE176,
    0xE202, 0xE1DC, 0xE1AC, 0xE21A, 0xE20F, 0xE62D, 0xEC41, 0xF25E, 0xF90B, 0xFDB6, 0x017E, 0x038A, 0x0369, 0x0370, 0x01C0, 0xFF89,
    0xFD88, 0xFBFC, 0xFA6B, 0xF979, 0xFA83, 0xFB72, 0xFC3E, 0xFCFE, 0xFE13, 0xFFAD, 0x006D, 0x02AA, 0x0363, 0x0359, 0x050E, 0x05F6,
    0x0A37, 0x0E0A, 0x106E, 0x1294, 0x1162, 0x10B9, 0x1020, 0x1038, 0x11F9, 0x149A, 0x1854, 0x1AC5, 0x1D87, 0x1F53, 0x2060, 0x226C,
    0x2173, 0x1E7B, 0x1AE1, 0x15EA, 0x1203, 0x0EE2, 0x0B0D, 0x07F0, 0x0702, 0x06CB, 0x05E4, 0x04D3, 0x00D7, 0xFCF2, 0xF8A5, 0xF279,
    0xEDEB, 0xE99D, 0xE816, 0xE7B3, 0xE6CF, 0xE6EC, 0xE543, 0xE39B, 0xE191, 0xDF24, 0xDD9C, 0xDB16, 0xD956, 0xD7D4, 0xD60D, 0xD53D,
    0xD33B, 0xD2F9, 0xD3D0, 0xD4D7, 0xD606, 0xD6B0, 0xD8CA, 0xDA4E, 0xDBBE, 0xDE07, 0xE081, 0xE534, 0xE9CD, 0xEEAF, 0xF474, 0xF866,
    0xFC75, 0x0007, 0x056B, 0x0960, 0x0D3D, 0x1337, 0x185E, 0x1EF3, 0x250A, 0x2988, 0x2D0A, 0x2D92, 0x2D4E, 0x2CC8, 0x291E, 0x260D,
    0x2105, 0x1ACD, 0x14F8, 0x0EC8, 0x0A52, 0x0752, 0x05B7, 0x0596, 0x0264, 0xFDD3, 0xFA09, 0xF739, 0xF6B9, 0xF6A2, 0xF7CF, 0xFAFE,
    0xFFB2, 0x023A, 0x0576, 0x07B7, 0x07F0, 0x0849, 0x06F4, 0x049F, 0x01C2, 0x004F, 0xFFB3, 0xFD89, 0xFB59, 0xF963, 0xF874, 0xF952,
    0xFA5F, 0xFBDF, 0xFC29, 0xFB78, 0xFCCB, 0xFC1A, 0xFA94, 0xFB1D, 0xFACF, 0xFB9E, 0xFB11, 0xFA57, 0xF9FA, 0xF794, 0xF78B, 0xF81C,
    0xF8B8, 0xFB1A, 0xFEF3, 0x03CE, 0x094B, 0x0DEF, 0x122E, 0x17BB, 0x1B45, 0x1DA4, 0x1EE7, 0x1C15, 0x18A5, 0x1431, 0x0D80, 0x080E,
    0x021E, 0xFEB7, 0xFC22, 0xFA07, 0xF815, 0xF496, 0xF20A, 0xEE18, 0xEBAF, 0xE97C, 0xE770, 0xE864, 0xE9C2, 0xEB45, 0xEE66, 0xEFCE,
    0xF138, 0xF14B, 0xF1CD, 0xF394, 0xF3EC, 0xF4D8, 0xF44B, 0xF3E6, 0xF491, 0xF502, 0xF734, 0xF9AE, 0xFC12, 0xFF58, 0x00BD, 0x01BD,
    0x01EC, 0x0379, 0x0465, 0x0488, 0x04E6, 0x041C, 0x056D, 0x06D9, 0x06CB, 0x06F6, 0x05C6, 0x03F6, 0x02A3, 0x0016, 0xFF4D, 0xFE09,
    0xFD77, 0xFE22, 0xFD26, 0xFD68, 0xFE33, 0xFEE1, 0xFFF4, 0xFD22, 0xF854, 0xF45E, 0xF0D3, 0xEE5F, 0xEC47, 0xEC37, 0xEE82, 0xF17A,
    0xF3D4, 0xF5B8, 0xF5FA, 0xF4B1, 0xF3A3, 0xF315, 0xF1DD, 0xF200, 0xF551, 0xF93D, 0xFD83, 0x0189, 0x03EB, 0x0603, 0x0906, 0x08E3,
    0x0996, 0x0991, 0x0853, 0x08F0, 0x0669, 0x055B, 0x0566, 0x054B, 0x05D9, 0x0626, 0x0547, 0x03AA, 0x014A, 0x000B, 0xFD45, 0xFB59,
    0xFB1C, 0xFAA8, 0xFB47, 0xFA2B, 0xF8F1, 0xF61F, 0xF3FC, 0xF19C, 0xF0B5, 0xF0E4, 0xEF9B, 0xF057, 0xF1A0, 0xF298, 0xF58F, 0xF91B,
    0xFCCC, 0xFEF7, 0x001A, 0x0030, 0xFD2E, 0xF9AF, 0xF51D, 0xF0AB, 0xED14, 0xE8AB, 0xE6C9, 0xE6AD, 0xE713, 0xEA16, 0xEA87, 0xEB09,
    0xEBB2, 0xECAA, 0xEFAD, 0xF467, 0xFBE0, 0x02E3, 0x0B00, 0x12BB, 0x1907, 0x1EFF, 0x23A1, 0x2821, 0x2B56, 0x2BA1, 0x2B8B, 0x2AD2,
    0x2A63, 0x29D3, 0x28A3, 0x283C, 0x279C, 0x281A, 0x28B2, 0x279F, 0x2601, 0x240E, 0x2241, 0x219E, 0x202B, 0x1F0F, 0x1DCC, 0x1B93,
    0x18ED, 0x134D, 0x0E18, 0x088E, 0x03F7, 0x0067, 0xFBD8, 0xF848, 0xF49F, 0xF1EC, 0xF072, 0xEF8B, 0xF099, 0xF17A, 0xF2DA, 0xF3FB,
    0xF17A, 0xEDFF, 0xE977, 0xE3D3, 0xDE30, 0xD87E, 0xD497, 0xD2E0, 0xD0D2, 0xCF61, 0xCE58, 0xCBD2, 0xC946, 0xC7CF, 0xC6D2, 0xC6BF,
    0xC8B8, 0xCB48, 0xCF43, 0xD492, 0xDA3E, 0xE083, 0xE5E3, 0xEA59, 0xEF06, 0xF372, 0xF6A3, 0xF80E, 0xF995, 0xFA75, 0xFBA3, 0xFDA3,
    0xFF64, 0x0328, 0x06CC, 0x091D, 0x0B00, 0x0B81, 0x0BEC, 0x0EF6, 0x1202, 0x14DC, 0x177B, 0x194B, 0x1AA1, 0x1CA3, 0x1F18, 0x2001,
    0x2239, 0x2397, 0x2567, 0x25A1, 0x25BC, 0x2751, 0x278D, 0x2946, 0x2949, 0x299C, 0x2B6C, 0x2AE7, 0x2A88, 0x2717, 0x1F58, 0x1900,
    0x114B, 0x09F4, 0x0392, 0xFE5C, 0xFA8C, 0xF68D, 0xF30D, 0xED7C, 0xE8B6, 0xE3D7, 0xDD31, 0xD8F8, 0xD513, 0xD04F, 0xCEEE, 0xCF07,
    0xD013, 0xD140, 0xD2FF, 0xD4EC, 0xD6B9, 0xD910, 0xD9D0, 0xDB2E, 0xDCA6, 0xDD98, 0xE0E3, 0xE481, 0xE99F, 0xEF08, 0xF3F2, 0xF8E6,
    0xFB9D, 0xFED9, 0xFF52, 0x00D4, 0x02D7, 0x0504, 0x09B6, 0x0BEF, 0x0F05, 0x129A, 0x145E, 0x15CF, 0x1656, 0x1727, 0x191F, 0x1AC0,
    0x1C8D, 0x1DBC, 0x1FA2, 0x22B3, 0x2737, 0x2CCA, 0x319E, 0x35E6, 0x38B2, 0x3882, 0x3633, 0x320B, 0x2D4F, 0x28A3, 0x2485, 0x206F,
    0x1AFB, 0x1718, 0x124E, 0x0E2A, 0x07CB, 0x0092, 0xFA54, 0xF337, 0xEF6E, 0xEAE3, 0xE884, 0xE7D5, 0xE617, 0xE6A2, 0xE635, 0xE58C,
    0xE662, 0xE5F5, 0xE396, 0xE0A1, 0xDD10, 0xD96D, 0xD7C6, 0xD73A, 0xD6DF, 0xD8F9, 0xDAE6, 0xDDF2, 0xE21E, 0xE4BC, 0xE912, 0xEDC5,
    0xF331, 0xF9D7, 0xFF03, 0x064E, 0x0BC7, 0x1037, 0x14A5, 0x1548, 0x16F9, 0x16EA, 0x168B, 0x1648, 0x14FE, 0x14C5, 0x149D, 0x1552,
    0x168C, 0x1921, 0x1C1F, 0x1E83, 0x20B3, 0x2096, 0x1E12, 0x19B9, 0x153B, 0x0ED7, 0x07D4, 0x02C1, 0xFD06, 0xF95A, 0xF483, 0xEE7B,
    0xEA2B, 0xE4E6, 0xDFC2, 0xDCAB, 0xDA7C, 0xD8DC, 0xD725, 0xD5C0, 0xD523, 0xD646, 0xDA1C, 0xDD79, 0xE1D4, 0xE50A, 0xE77B, 0xEAA7,
    0xEAB3, 0xEB18, 0xEAEE, 0xEAEA, 0xEB47, 0xEB29, 0xED43, 0xEE96, 0xF13F, 0xF2DE, 0xF269, 0xF354, 0xF3BC, 0xF60F, 0xF929, 0xFC9A,
    0x0095, 0x02E1, 0x05BC, 0x079E, 0x0AD5, 0x0E96, 0x11A3, 0x1676, 0x1748, 0x17FA, 0x19DD, 0x1B4A, 0x1EC0, 0x21F2, 0x261C, 0x2A07,
    0x2CF1, 0x2F45, 0x2FC3, 0x2F19, 0x2CA7, 0x2A0A, 0x2739, 0x23C4, 0x20BA, 0x1E34, 0x1C1E, 0x18E2, 0x14E8, 0x110A, 0x0BDB, 0x082E,
    0x03F3, 0xFF0E, 0xFB6E, 0xF676, 0xF3C1, 0xF1E5, 0xF109, 0xF153, 0xF2DD, 0xF627, 0xF754, 0xF9CF, 0xFA52, 0xF979, 0xFA7D, 0xF907,
    0xF9AA, 0xFAC6, 0xFBFB, 0xFCC9, 0xFC1F, 0xFC01, 0xF94D, 0xF85D, 0xF696, 0xF3E8, 0xF354, 0xF0D6, 0xEF77, 0xEEA0, 0xED1C, 0xEE13,
    0xEE11, 0xED0E, 0xECE3, 0xEC8A, 0xED80, 0xED31, 0xED21, 0xED83, 0xEDE9, 0xF20E, 0xF698, 0xFC99, 0x02D2, 0x07E7, 0x0C3F, 0x0D41,
    0x0D8A, 0x0BA5, 0x09F6, 0x0919, 0x08A5, 0x098D, 0x088D, 0x0854, 0x0818, 0x084A, 0x0816, 0x0689, 0x049F, 0x018E, 0xFF53, 0xFD2F,
    0xFC68, 0xFD65, 0xFF1A, 0x01FF, 0x0672, 0x0A41, 0x0D5D, 0x1050, 0x116C, 0x1073, 0x0D26, 0x0A43, 0x07DB, 0x0702, 0x05A2, 0x0312,
    0x01D6, 0xFF3F, 0xFCFE, 0xFAE1, 0xF922, 0xF829, 0xF6B9, 0xF682, 0xF639, 0xF6A9, 0xF681, 0xF5AC, 0xF5F0, 0xF4CC, 0xF3B4, 0xF207,
    0xEF49, 0xECB5, 0xEA25, 0xE82D, 0xE6D2, 0xE6E7, 0xEA51, 0xEFD1, 0xF6DB, 0xFDEC, 0x03C0, 0x0915, 0x0B4F, 0x0C6B, 0x0C7E, 0x0C90,
    0x0D0A, 0x0C30, 0x0BF3, 0x0A2C, 0x081A, 0x0688, 0x03DD, 0x008A, 0xFC2E, 0xF89E, 0xF549, 0xF1FB, 0xEF24, 0xEBDF, 0xEB18, 0xEB9A,
    0xEDA7, 0xF164, 0xF35C, 0xF5CD, 0xF682, 0xF4CB, 0xF59E, 0xF565, 0xF4F5, 0xF664, 0xF73A, 0xF877, 0xF998, 0xFA38, 0xFAF6, 0xFD14,
    0xFE06, 0xFEBF, 0xFF61, 0x0014, 0x0174, 0x02F1, 0x056B, 0x05DF, 0x06A1, 0x072B, 0x06C4, 0x0830, 0x08D0, 0x08EA, 0x085F, 0x05E4,
    0x04FC, 0x0595, 0x0779, 0x0C1B, 0x109A, 0x1528, 0x1990, 0x1C4B, 0x1DF3, 0x1D6A, 0x1D6B, 0x1CFE, 0x1BD4, 0x1B66, 0x1A9D, 0x1AD3,
    0x19B8, 0x1910, 0x17B9, 0x1695, 0x1596, 0x1337, 0x1143, 0x0CC9, 0x08D1, 0x05F6, 0x0271, 0x012D, 0x00F9, 0x0156, 0x029B, 0x0385,
    0x030A, 0x01B1, 0x009E, 0xFEFB, 0xFDBC, 0xFC72, 0xFAB2, 0xF9E7, 0xF8A8, 0xF61A, 0xF401, 0xF15D, 0xEFAE, 0xEE02, 0xED06, 0xECD7,
    0xECF0, 0xEF66, 0xF09A, 0xF2D3, 0xF504, 0xF6DB, 0xF976, 0xFAD5, 0xFC06, 0xFA37, 0xF8BB, 0xF77F, 0xF5B2, 0xF5B0, 0xF4AA, 0xF6A2,
    0xF9C4, 0xFCC4, 0x0148, 0x0464, 0x0741, 0x0773, 0x0552, 0x02F7, 0xFFC1, 0xFD16, 0xFA05, 0xF6B0, 0xF2E6, 0xEE61, 0xEC14, 0xE913,
    0xE771, 0xE652, 0xE306, 0xE121, 0xDD45, 0xDADA, 0xDABF, 0xDBFB, 0xE1A7, 0xE64C, 0xECBA, 0xF408, 0xFAE8, 0x01B2, 0x05B8, 0x0A8A,
    0x0C66, 0x0EBA, 0x11C2, 0x128C, 0x1548, 0x16F4, 0x1801, 0x19AC, 0x1977, 0x19DC, 0x1B76, 0x1C9C, 0x1D69, 0x1D8F, 0x1DF0, 0x1E2A,
    0x1F33, 0x20AF, 0x2197, 0x22EE, 0x22A8, 0x220E, 0x1E50, 0x1856, 0x123E, 0x0CAC, 0x09CF, 0x06C9, 0x06CE, 0x07DF, 0x0968, 0x0BD8,
    0x0C78, 0x0C8B, 0x0B5C, 0x0A31, 0x0871, 0x0606, 0x02F8, 0xFEE8, 0xFB5D, 0xF669, 0xF0B6, 0xEC67, 0xE74C, 0xE25F, 0xDD18, 0xD711,
    0xD1DA, 0xCC62, 0xC8CD, 0xC653, 0xC566, 0xC6B4, 0xC89A, 0xCCDE, 0xD0E9, 0xD4EE, 0xD935, 0xDCD3, 0xE17D, 0xE709, 0xED1B, 0xF339,
    0xF9CA, 0x0023, 0x0473, 0x0937, 0x0F05, 0x147D, 0x19B0, 0x1D82, 0x2131, 0x247F, 0x2705, 0x29B6, 0x2CCD, 0x2FB3, 0x3255, 0x34DB,
    0x355F, 0x343F, 0x32FE, 0x2FDD, 0x2C70, 0x2934, 0x25B2, 0x24FF, 0x25B2, 0x26A3, 0x27AE, 0x2913, 0x28D0, 0x2748, 0x258A, 0x2263,
    0x1FD0, 0x1C27, 0x1762, 0x122F, 0x0CCB, 0x0804, 0x034A, 0xFF41, 0xFAF5, 0xF74E, 0xF39F, 0xEF72, 0xEAEE, 0xE4FE, 0xE042, 0xDC63,
    0xD8FD, 0xD72F, 0xD61C, 0xD616, 0xD6AE, 0xD58D, 0xD64C, 0xD71C, 0xD688, 0xD7A3, 0xD7E5, 0xD9AE, 0xDBF0, 0xDDB5, 0xDFE1, 0xE17E,
    0xE3C1, 0xE5A0, 0xE7AC, 0xE93C, 0xE999, 0xEA0C, 0xEA88, 0xEBA9, 0xECE3, 0xEE7D, 0xF1B6, 0xF543, 0xF906, 0xFC9D, 0xFEC7, 0xFEF2,
    0xFD87, 0xFCA6, 0xFCA1, 0xFDA7, 0x00A4, 0x03C8, 0x087D, 0x0D41, 0x11DE, 0x1687, 0x199E, 0x1D5D, 0x1F10, 0x2038, 0x212D, 0x2119,
    0x218C, 0x20B0, 0x1FB5, 0x1E8A, 0x1C4E, 0x19CE, 0x16DC, 0x13C7, 0x0F14, 0x09CC, 0x03E2, 0xFD43, 0xF915, 0xF605, 0xF46C, 0xF3B8,
    0xF31C, 0xF3BB, 0xF331, 0xF345, 0xF2DD, 0xF1B2, 0xF176, 0xEF1D, 0xECC2, 0xEAAB, 0xE7FB, 0xE6C6, 0xE530, 0xE4D7, 0xE45B, 0xE4F8,
    0xE697, 0xE690, 0xE7FA, 0xE8B6, 0xEB5A, 0xEF99, 0xF428, 0xFD4A, 0x05D4, 0x0C76, 0x117E, 0x1304, 0x1314, 0x10A5, 0x0E0B, 0x0AB8,
    0x0943, 0x0A0B, 0x0AB6, 0x0E4B, 0x1194, 0x1595, 0x1ABD, 0x1E1F, 0x22B8, 0x260C, 0x2747, 0x28AB, 0x280F, 0x27B0, 0x2609, 0x2483,
    0x23F3, 0x21E8, 0x207C, 0x1D25, 0x185B, 0x1292, 0x0B5E, 0x04FE, 0xFF1C, 0xFA83, 0xF613, 0xF294, 0xF04F, 0xEE9E, 0xEE55, 0xED94,
    0xECD6, 0xEC08, 0xEAFD, 0xE9D8, 0xE95F, 0xE8C4, 0xE6BB, 0xE4C6, 0xE259, 0xE08E, 0xE020, 0xDE0A, 0xDC59, 0xDB56, 0xD8A3, 0xD6FC,
    0xD4F0, 0xD40C, 0xD69C, 0xDB0D, 0xE0A4, 0xE536, 0xEA37, 0xEE59, 0xF1F0, 0xF4BF, 0xF641, 0xF928, 0xFD07, 0x01A6, 0x06B2, 0x0CB2,
    0x13A0, 0x1A63, 0x20A9, 0x259E, 0x2803, 0x2B26, 0x2D6B, 0x2E91, 0x2EEE, 0x2DD0, 0x2D6E, 0x2C36, 0x2BC5, 0x2A39, 0x271C, 0x22BB,
    0x1CBB, 0x1646, 0x0E4E, 0x0713, 0x0077, 0xFA4C, 0xF614, 0xF2AD, 0xF064, 0xEE4C, 0xEBFE, 0xEA41, 0xE971, 0xE895, 0xE84A, 0xE905,
    0xE97F, 0xEB00, 0xEC06, 0xEC0B, 0xED2F, 0xEDFF, 0xEED8, 0xF079, 0xF066, 0xF074, 0xF00A, 0xEDAD, 0xEBA5, 0xE98A, 0xE891, 0xE916,
    0xEB08, 0xECE3, 0xEE8F, 0xF087, 0xEFAE, 0xEE52, 0xEB93, 0xE825, 0xE6E8, 0xE5C4, 0xE736, 0xE907, 0xEBBF, 0xEF8D, 0xF309, 0xF8FB,
    0xFDFA, 0x02E8, 0x0699, 0x082D, 0x0A9B, 0x0BFA, 0x0E43, 0x10A6, 0x12EE, 0x1653, 0x178E, 0x17EA, 0x172B, 0x1513, 0x13BF, 0x0FD9,
    0x0C6A, 0x088E, 0x0487, 0x03B3, 0x02CB, 0x01AC, 0x0058, 0x003A, 0xFF9A, 0xFF7A, 0x00FD, 0x0299, 0x0526, 0x06BE, 0x0714, 0x07E4,
    0x079D, 0x088C, 0x0AA5, 0x0C66, 0x0E10, 0x0F36, 0x1095, 0x1022, 0x1074, 0x10DF, 0x110B, 0x13D6, 0x16BA, 0x1A05, 0x1D17, 0x1EC2,
    0x1F62, 0x1D59, 0x19B9, 0x14D4, 0x0F1E, 0x098A, 0x03F7, 0xFFC3, 0xFC5F, 0xF9A8, 0xF9FE, 0xFB47, 0xFCDC, 0xFF1E, 0x003A, 0x00D7,
    0x0022, 0xFEB0, 0xFCFD, 0xFC3E, 0xFAFF, 0xF929, 0xF883, 0xF60B, 0xF38A, 0xF07C, 0xEC0D, 0xE7B7, 0xE296, 0xDF1B, 0xDCBD, 0xDAC3,
    0xDAE0, 0xDC21, 0xDD15, 0xDED5, 0xE1D2, 0xE569, 0xE9BE, 0xEE1D, 0xF12A, 0xF38E, 0xF584, 0xF70C, 0xF8E6, 0xF96D, 0xFA8A, 0xFC51,
    0xFDDB, 0x0062, 0x0293, 0x0447, 0x0537, 0x0514, 0x04A0, 0x03CB, 0x0495, 0x06EF, 0x0906, 0x0B50, 0x0BBF, 0x0B8D, 0x0986, 0x061A,
    0x040E, 0x00CD, 0xFD41, 0xFAA4, 0xF930, 0xFA5B, 0xFCB1, 0xFF05, 0x0259, 0x04F8, 0x0636, 0x0706, 0x06A5, 0x0674, 0x05BC, 0x0419,
    0x03C3, 0x03DD, 0x0554, 0x0700, 0x077C, 0x06F2, 0x048E, 0x0257, 0xFFCF, 0xFCDF, 0xFA9C, 0xF8F2, 0xF889, 0xF87B, 0xF838, 0xF853,
    0xF820, 0xF88C, 0xF96C, 0xF9B7, 0xFB21, 0xFBD4, 0xFC81, 0xFD61, 0xFDCD, 0xFEAB, 0xFF19, 0x0016, 0x00B6, 0x00D8, 0xFFD2, 0xFDB6,
    0xFAF6, 0xF74E, 0xF4DC, 0xF3AF, 0xF425, 0xF553, 0xF7D4, 0xFAB6, 0xFBDE, 0xFDDA, 0xFF3B, 0xFEBF, 0xFE1D, 0xFC22, 0xF950, 0xF87D,
    0xF7EA, 0xF7DF, 0xF84A, 0xF982, 0xFBB1, 0xFDA5, 0x00A0, 0x02B6, 0x04A7, 0x0535, 0x059F, 0x067C, 0x06CD, 0x0864, 0x0AEF, 0x0E2A,
    0x0FF8, 0x0F9A, 0x0E85, 0x0C00, 0x099F, 0x076A, 0x0445, 0x021E, 0xFF70, 0xFDDA, 0xFCA7, 0xFB28, 0xFB2B, 0xFB9E, 0xFE32, 0x0101,
    0x03E9, 0x0715, 0x09AE, 0x0CC9, 0x0EDC, 0x1015, 0x11F2, 0x143F, 0x1667, 0x17AD, 0x1859, 0x1711, 0x1533, 0x1371, 0x1003, 0x0EEB,
    0x0E82, 0x0D76, 0x0E83, 0x0E91, 0x0EB6, 0x0E8B, 0x0D6A, 0x0C6F, 0x09FC, 0x083D, 0x05A3, 0x01F3, 0xFF2D, 0xFBFA, 0xFA70, 0xF8F8,
    0xF8F8, 0xFB8B, 0xFDF5, 0x0146, 0x040C, 0x061E, 0x0A33, 0x0D4E, 0x0C55, 0x0A61, 0x093D, 0x088D, 0x07C0, 0x0576, 0x0207, 0xFD88,
    0xF7E9, 0xF178, 0xE972, 0xE189, 0xDA80, 0xD466, 0xCFBB, 0xCB57, 0xC6EF, 0xC4C1, 0xC40B, 0xC54B, 0xC7A4, 0xC945, 0xCB36, 0xCCE3,
    0xCEF8, 0xD17B, 0xD4DE, 0xD8FB, 0xDDEE, 0xE38F, 0xE83F, 0xEC76, 0xF0A1, 0xF452, 0xF7CF, 0xFB60, 0xFEEE, 0x02D4, 0x07C2, 0x0DD2,
    0x1433, 0x19B5, 0x1F45, 0x234E, 0x2603, 0x27ED, 0x27AC, 0x2710, 0x25DF, 0x2468, 0x23B7, 0x23BD, 0x2522, 0x282C, 0x2B47, 0x2D73,
    0x2ED1, 0x2F6F, 0x2E7C, 0x2D2B, 0x2B65, 0x2938, 0x2849, 0x26AD, 0x25FB, 0x25AB, 0x2378, 0x20CC, 0x1CAA, 0x170C, 0x109C, 0x0A20,
    0x042E, 0xFDA4, 0xF7BA, 0xF1E5, 0xEB7D, 0xE670, 0xE277, 0xE03D, 0xDE60, 0xDBC3, 0xD981, 0xD6EE, 0xD4FF, 0xD276, 0xD1A7, 0xD2C8,
    0xD3EB, 0xD676, 0xD88B, 0xDA81, 0xDC1B, 0xDD5F, 0xDDDB, 0xDF33, 0xE2C8, 0xE5A1, 0xEA0B, 0xEFF9, 0xF607, 0xFE72, 0x05A9, 0x0B78,
    0x126C, 0x1697, 0x19C6, 0x1BEB, 0x1B49, 0x1AE9, 0x1B2F, 0x1C9C, 0x1E27, 0x204C, 0x22BC, 0x2438, 0x2561, 0x25BC, 0x2474, 0x23B9,
    0x2307, 0x211F, 0x2124, 0x2128, 0x21AE, 0x22E7, 0x2267, 0x200A, 0x1DA0, 0x196A, 0x1383, 0x0E8A, 0x0892, 0x01E1, 0xFB39, 0xF49D,
    0xEE67, 0xE93D, 0xE619, 0xE38D, 0xE253, 0xE259, 0xE2B9, 0xE43D, 0xE571, 0xE73A, 0xE9CA, 0xEC15, 0xEF5F, 0xF2C2, 0xF531, 0xF6AD,
    0xF662, 0xF45C, 0xEFF2, 0xEC6D, 0xE8D2, 0xE36E, 0xE269, 0xE545, 0xE93D, 0xEDB5, 0xF243, 0xF739, 0xFB3E, 0xFE36, 0xFFE9, 0x010B,
    0x00DD, 0xFE86, 0xFDA3, 0xFCA8, 0xFC23, 0xFD9B, 0xFF63, 0x02B9, 0x06DA, 0x0A2E, 0x0D7C, 0x0F92, 0x1105, 0x12B2, 0x14F8, 0x1784,
    0x18EC, 0x1BBB, 0x1C3E, 0x1BB3, 0x1AB6, 0x17CD, 0x14E9, 0x10DE, 0x0D0B, 0x0801, 0x0212, 0xFD95, 0xFA1F, 0xF629, 0xF352, 0xF1AF,
    0xF0C9, 0xF051, 0xF007, 0xF0C1, 0xF0B6, 0xEF49, 0xEE87, 0xEEAA, 0xEED1, 0xF042, 0xF18E, 0xF188, 0xF11A, 0xEFDE, 0xEDCB, 0xEB2B,
    0xE9C1, 0xE858, 0xE717, 0xE6D5, 0xE66E, 0xE825, 0xEA69, 0xED92, 0xF045, 0xF258, 0xF434, 0xF558, 0xF600, 0xF41B, 0xF31F, 0xF2C9,
    0xF283, 0xF4B2, 0xF782, 0xFC32, 0x0331, 0x07FD, 0x0CDA, 0x10B3, 0x13BC, 0x173F, 0x19F4, 0x1DEB, 0x2100, 0x2542, 0x2919, 0x2BA2,
    0x2EF2, 0x3112, 0x32C9, 0x33BA, 0x3439, 0x32DB, 0x30BA, 0x2D40, 0x28FE, 0x25F4, 0x21FC, 0x1F3D, 0x1D16, 0x1A99, 0x18A7, 0x15AF,
    0x1258, 0x0E88, 0x0B41, 0x0A60, 0x08BE, 0x07ED, 0x07B5, 0x0662, 0x0655, 0x042D, 0x00FE, 0xFD77, 0xF94E, 0xF566, 0xF0A9, 0xECE8,
    0xE990, 0xE83A, 0xE742, 0xE4AB, 0xE431, 0xE2D7, 0xE1A7, 0xE0CB, 0xDDF2, 0xDAB0, 0xD68C, 0xD356, 0xD100, 0xD031, 0xD1F7, 0xD4D4,
    0xD95F, 0xDD50, 0xE0C6, 0xE55C, 0xE8A0, 0xECFE, 0xF1AB, 0xF59E, 0xFAC7, 0xFF41, 0x0586, 0x0B2B, 0x108E, 0x1553, 0x17B4, 0x1A55,
    0x1AA5, 0x1A79, 0x196B, 0x166D, 0x12C4, 0x0F35, 0x0C1E, 0x095E, 0x0759, 0x05A9, 0x0351, 0x0094, 0xFDFC, 0xFB0C, 0xF951, 0xF8E9,
    0xF9A5, 0xFB66, 0xFD29, 0x0012, 0x01D4, 0x040D, 0x04F7, 0x04CC, 0x049A, 0x0306, 0x028C, 0x02BA, 0x0341, 0x0441, 0x06B5, 0x081B,
    0x0B8A, 0x0E3A, 0x0F74, 0x116B, 0x1165, 0x0FCF, 0x0C71, 0x0861, 0x042E, 0x0051, 0xFC2C, 0xF9ED, 0xF963, 0xF8BE, 0xF7FE, 0xF7F8,
    0xF80C, 0xF72D, 0xF777, 0xF76B, 0xF786, 0xF87C, 0xF8E7, 0xFA42, 0xFAAA, 0xFAF4, 0xFBC6, 0xFC3D, 0xFC85, 0xFBCB, 0xF900, 0xF614,
    0xF246, 0xEE84, 0xECB0, 0xEAD2, 0xEB28, 0xEB13, 0xEB62, 0xECCA, 0xED1D, 0xEDE3, 0xEE30, 0xEF1E, 0xF108, 0xF293, 0xF508, 0xF7C2,
    0xFA12, 0xFBEA, 0xFB76, 0xFAF0, 0xF9F5, 0xF81B, 0xF7FA, 0xF7CD, 0xF806, 0xF8F1, 0xFB90, 0xFEA9, 0x0291, 0x0877, 0x0DDD, 0x13CE,
    0x17EB, 0x1A29, 0x1BF8, 0x1C85, 0x1C64, 0x1C3E, 0x1BE2, 0x1C54, 0x1DF2, 0x2070, 0x2131, 0x21F2, 0x236A, 0x2311, 0x231F, 0x22E7,
    0x2204, 0x21DB, 0x20DA, 0x1F98, 0x1E8D, 0x1CB4, 0x1B6D, 0x1ACF, 0x1993, 0x1699, 0x12D0, 0x0D44, 0x073F, 0x008B, 0xF9C1, 0xF3CC,
    0xEEEB, 0xEB21, 0xE77F, 0xE4A5, 0xE1D5, 0xDF7A, 0xDD91, 0xDC1B, 0xDB94, 0xDCD0, 0xDFBE, 0xE318, 0xE740, 0xEBB6, 0xEEA9, 0xF17C,
    0xF3C1, 0xF471, 0xF512, 0xF4EC, 0xF45B, 0xF49C, 0xF442, 0xF4E8, 0xF6F0, 0xF97D, 0xFB65, 0xFDBA, 0x002E, 0x0091, 0x0219, 0x01BB,
    0xFF95, 0xFE88, 0xFC94, 0xFAB0, 0xFAC1, 0xFAD7, 0xFAF9, 0xFB00, 0xFA56, 0xFA52, 0xFA20, 0xF9ED, 0xFA4F, 0xFB0C, 0xFB35, 0xFA89,
    0xFBA0, 0xFCD0, 0xFE51, 0x005D, 0x00BD, 0x006A, 0xFE8B, 0xF8B2, 0xEEA0, 0xE1EA, 0xD66D, 0xD384, 0xDDE9, 0xF7DA, 0x00D6, 0xF4DD,
    0xF489, 0xF2A2, 0xEAA6, 0xE8F6, 0xE959, 0xE666, 0xE52B, 0xF1C5, 0x045B, 0x03ED, 0x0269, 0x0C60, 0x0B78, 0x0969, 0x0BA9, 0x0AAB,
    0x0A3B, 0x0A87, 0x02ED, 0xF920, 0xF9DD, 0x02BC, 0x1397, 0x213F, 0x2440, 0x24E4, 0x2B15, 0x3094, 0x253C, 0x1A57, 0x1902, 0x0FBD,
    0x0DD4, 0x129A, 0x0EC3, 0x113A, 0x15C8, 0x1028, 0x0918, 0x074E, 0x0559, 0x032E, 0x0421, 0xFF81, 0xF8A2, 0xF920, 0xFA0D, 0xFD9D,
    0x05A1, 0x084E, 0x06AB, 0x0814, 0x0839, 0x0206, 0xFD0C, 0xF706, 0xED15, 0xE9A3, 0xE9D5, 0xE78A, 0xE700, 0xE7E9, 0xE4B5, 0xE14A,
    0xE1BE, 0xE226, 0xE232, 0xE430, 0xE38F, 0xE0AE, 0xE148, 0xE304, 0xE65B, 0xEB3E, 0xF02D, 0xF324, 0xF7E0, 0xFDE8, 0x0059, 0x013B,
    0x02AC, 0x02F2, 0x04EC, 0x0A48, 0x0EDA, 0x12E4, 0x158D, 0x16B2, 0x14D5, 0x1301, 0x1127, 0x0F8D, 0x10A6, 0x0F34, 0x0AB0, 0x08A7,
    0x082A, 0x0728, 0x0868, 0x0A7A, 0x0D9B, 0x1396, 0x18F4, 0x1CC7, 0x1FB0, 0x1F74, 0x1EA2, 0x1F21, 0x2047, 0x214A, 0x224D, 0x23B9,
    0x23D6, 0x224F, 0x1F0B, 0x19DA, 0x1640, 0x11A6, 0x0C1D, 0x0686, 0xFFFF, 0xFB01, 0xF514, 0xEFE0, 0xE9ED, 0xE52C, 0xE27D, 0xDF66,
    0xDE27, 0xDD46, 0xDB14, 0xDAA1, 0xD9EF, 0xD8F1, 0xD7AD, 0xD5FC, 0xD5C3, 0xD420, 0xD2BB, 0xD1C1, 0xD29F, 0xD523, 0xD831, 0xDC5A,
    0xE094, 0xE492, 0xE86D, 0xEBC7, 0xEF3E, 0xF1E9, 0xF52A, 0xF8B4, 0xFC4E, 0x0063, 0x03FA, 0x0832, 0x0B3D, 0x0D87, 0x110F, 0x1407,
    0x16DE, 0x1A85, 0x1D05, 0x1F2D, 0x20E9, 0x2277, 0x23F9, 0x2622, 0x2832, 0x29DB, 0x2BE5, 0x2BF9, 0x2A4F, 0x2795, 0x23BD, 0x1F9F,
    0x1B8A, 0x179B, 0x131A, 0x0F41, 0x0C3F, 0x0906, 0x05E1, 0x01A7, 0xFDA5, 0xFA1E, 0xF75A, 0xF4E4, 0xF2B4, 0xF247, 0xF310, 0xF31E,
    0xF345, 0xF3E9, 0xF454, 0xF3DA, 0xF1F1, 0xEF29, 0xEBA3, 0xE7C9, 0xE5CE, 0xE642, 0xE6FA, 0xEA36, 0xEFF5, 0xF419, 0xF8D8, 0xFE25,
    0x0090, 0x0348, 0x04A3, 0x05F1, 0x0937, 0x0B26, 0x0E56, 0x10CA, 0x1394, 0x173C, 0x1AA7, 0x1F16, 0x2199, 0x257F, 0x297C, 0x2ACA,
    0x2B48, 0x2C2A, 0x2E00, 0x30CD, 0x32FC, 0x352A, 0x368A, 0x36D3, 0x3691, 0x3430, 0x30A9, 0x2AF6, 0x2523, 0x1F0C, 0x1782, 0x1167,
    0x0BCA, 0x056F, 0x003A, 0xFA48, 0xF48C, 0xEF7C, 0xEAF6, 0xE766, 0xE48A, 0xE282, 0xE163, 0xE1CB, 0xE20E, 0xE2FC, 0xE45A, 0xE508,
    0xE4F9, 0xE4C1, 0xE408, 0xE236, 0xE144, 0xE0F4, 0xE17C, 0xE367, 0xE476, 0xE72F, 0xEAB6, 0xED03, 0xEDD9, 0xEECC, 0xEF8A, 0xEF82,
    0xF0B8, 0xF17B, 0xF11C, 0xF18A, 0xF2D1, 0xF35C, 0xF561, 0xF84D, 0xFAD1, 0xFCB6, 0xFE76, 0x010F, 0x0453, 0x079F, 0x0AA5, 0x0FCE,
    0x14E4, 0x1920, 0x1E66, 0x22B9, 0x2643, 0x28CA, 0x2ABB, 0x2BD6, 0x2BF6, 0x2B9B, 0x2AEE, 0x2980, 0x25ED, 0x2118, 0x1C6A, 0x1777,
    0x1269, 0x0D4B, 0x07D6, 0x0326, 0xFEE2, 0xFBA6, 0xF8BC, 0xF825, 0xF8B4, 0xF965, 0xFBA9, 0xFD1C, 0xFD51, 0xFD6F, 0xFAB3, 0xF7DF,
    0xF5AE, 0xF250, 0xF0C9, 0xF08F, 0xF19A, 0xF35B, 0xF49F, 0xF461, 0xF40A, 0xF359, 0xF2F8, 0xF1E9, 0xF04B, 0xEFB0, 0xEE18, 0xECAB,
    0xEB6A, 0xEA87, 0xEB16, 0xEB79, 0xEC2B, 0xEC4D, 0xED0F, 0xEE07, 0xECC4, 0xED08, 0xEE5A, 0xEF3E, 0xF1F1, 0xF532, 0xFA17, 0xFEC2,
    0x0252, 0x073F, 0x0997, 0x0BAC, 0x0D07, 0x0D14, 0x0D7E, 0x0DD1, 0x0EA2, 0x0F0E, 0x0F23, 0x0E81, 0x0DDD, 0x0EA0, 0x0F7A, 0x0FC6,
    0x0FD7, 0x108D, 0x122A, 0x1491, 0x1696, 0x1A5A, 0x1EEF, 0x22D2, 0x262D, 0x285E, 0x293B, 0x2767, 0x24C4, 0x2178, 0x1E91, 0x1C79,
    0x1C69, 0x1CC5, 0x1D3F, 0x1E50, 0x1F12, 0x1ED7, 0x1D74, 0x1B80, 0x188F, 0x14A4, 0x0F3F, 0x0A45, 0x04EA, 0xFF2A, 0xFAF8, 0xF659,
    0xF21A, 0xEF68, 0xEBB9, 0xE8EA, 0xE6C2, 0xE469, 0xE183, 0xE0E2, 0xE0F6, 0xE170, 0xE3AE, 0xE6DB, 0xEA19, 0xEC9D, 0xEEE5, 0xEFDB,
    0xF064, 0xF073, 0xF023, 0xF09F, 0xF002, 0xEEE0, 0xF01D, 0xF177, 0xF162, 0xF098, 0xF00F, 0xEF99, 0xEF5A, 0xEF28, 0xEFB7, 0xEFA4,
    0xEFB6, 0xF1D0, 0xF403, 0xF5E8, 0xF7F1, 0xF937, 0xF8F4, 0xF750, 0xF4C2, 0xF234, 0xF019, 0xEFB6, 0xF079, 0xF218, 0xF48A, 0xF702,
    0xF963, 0xFC3A, 0xFF8F, 0x022D, 0x0438, 0x061F, 0x0801, 0x083D, 0x07A0, 0x07B4, 0x0771, 0x084D, 0x08F3, 0x0B03, 0x0D0D, 0x0D1F,
    0x0DDF, 0x0DD7, 0x0D8D, 0x0E9D, 0x1103, 0x1418, 0x16E5, 0x195A, 0x1BAB, 0x1CDD, 0x1CE5, 0x1C81, 0x1B7A, 0x1924, 0x165E, 0x1569,
    0x12A9, 0x0F26, 0x0BBD, 0x05F4, 0x0066, 0xFB71, 0xF6F8, 0xF233, 0xEDE0, 0xEA99, 0xE8AF, 0xE6E4, 0xE63D, 0xE726, 0xE953, 0xEDDA,
    0xF236, 0xF552, 0xF81E, 0xF953, 0xF85C, 0xF6B8, 0xF49D, 0xF37B, 0xF343, 0xF40E, 0xF545, 0xF73F, 0xF84A, 0xFA91, 0xFC94, 0xFD65,
    0xFE1C, 0xFF69, 0x0092, 0x0231, 0x0325, 0x02C1, 0x0456, 0x0660, 0x0A17, 0x0D55, 0x0F8A, 0x1244, 0x14CB, 0x15E2, 0x15DC, 0x15A2,
    0x16DE, 0x17CA, 0x19C2, 0x1BA4, 0x1CA2, 0x1EDE, 0x20AB, 0x22B7, 0x22A8, 0x218F, 0x1F87, 0x1CA8, 0x1A21, 0x1511, 0x0F94, 0x0B17,
    0x05AE, 0x0012, 0xFA04, 0xF426, 0xEF19, 0xE9A0, 0xE3EB, 0xDF02, 0xDB44, 0xD84B, 0xD7FA, 0xDA39, 0xDD09, 0xE00F, 0xE29A, 0xE503,
    0xE863, 0xE93B, 0xE948, 0xEA05, 0xEAEC, 0xED75, 0xF12D, 0xF642, 0xFA20, 0x0014, 0x0699, 0x0C4B, 0x118D, 0x1604, 0x1914, 0x1A5E,
    0x1A57, 0x1943, 0x1852, 0x1693, 0x156D, 0x13E3, 0x1397, 0x120E, 0x103B, 0x0ED9, 0x0CE6, 0x0B07, 0x0981, 0x0882, 0x0819, 0x078B,
    0x077C, 0x08EF, 0x0923, 0x090C, 0x098F, 0x0930, 0x0883, 0x0750, 0x0508, 0x033E, 0x000E, 0xFC51, 0xF8A1, 0xF69D, 0xF437, 0xF0FD,
    0xED6A, 0xE917, 0xE4A0, 0xE156, 0xDDCC, 0xDA4B, 0xD950, 0xD944, 0xDACE, 0xDC0D, 0xDE4E, 0xDEE6, 0xDF79, 0xDFBF, 0xDE6A, 0xDE0A,
    0xDE08, 0xDF73, 0xE188, 0xE415, 0xE7AD, 0xEC0A, 0xF063, 0xF557, 0xFA9B, 0xFEF6, 0x026B, 0x05B2, 0x07FF, 0x091E, 0x0A63, 0x0B31,
    0x0C45, 0x0DE4, 0x0FDA, 0x1353, 0x15C9, 0x16FB, 0x1826, 0x184F, 0x1859, 0x1880, 0x19AD, 0x1BA3, 0x1E19, 0x203D, 0x2231, 0x2320,
    0x2394, 0x24BB, 0x245F, 0x2387, 0x21CD, 0x2058, 0x1E48, 0x1BB5, 0x189E, 0x14C5, 0x0F9F, 0x0A2F, 0x0505, 0xFEA1, 0xF843, 0xF250,
    0xEDAB, 0xE9A9, 0xE7ED, 0xE75A, 0xE83E, 0xEA4B, 0xECA8, 0xEF4F, 0xF163, 0xF19F, 0xF147, 0xF0D9, 0xEFC4, 0xEE73, 0xED45, 0xED21,
    0xED85, 0xEF82, 0xF225, 0xF577, 0xF892, 0xFB6C, 0xFE05, 0xFFDE, 0x018D, 0x02D2, 0x0420, 0x0661, 0x0741, 0x08AC, 0x0AEF, 0x0CBC,
    0x0E83, 0x0E52, 0x0DB9, 0x0C03, 0x0A7E, 0x09C4, 0x0956, 0x0921, 0x0943, 0x0A7E, 0x0BBC, 0x0BD9, 0x0CCB, 0x0D44, 0x0DE8, 0x0FF3,
    0x0F81, 0x0FC1, 0x0F78, 0x0EB2, 0x0D98, 0x0B70, 0x0A44, 0x0804, 0x066C, 0x0371, 0x0038, 0xFC81, 0xF723, 0xF3DF, 0xF040, 0xED87,
    0xECD6, 0xED37, 0xEF8B, 0xEFBA, 0xF052, 0xF15E, 0xF1C0, 0xF206, 0xEF95, 0xECB9, 0xE950, 0xE61B, 0xE4FC, 0xE38C, 0xE306, 0xE426,
    0xE635, 0xE9CF, 0xEBAF, 0xED54, 0xED60, 0xEDA5, 0xEDFE, 0xEC1D, 0xEBEA, 0xED0B, 0xEDB8, 0xF073, 0xF255, 0xF302, 0xF441, 0xF4D6,
    0xF666, 0xF738, 0xF969, 0xFCD5, 0x00E2, 0x05A9, 0x0A30, 0x0D66, 0x11BD, 0x1577, 0x19A4, 0x1D62, 0x1FA3, 0x221F, 0x228B, 0x2430,
    0x23F2, 0x21F0, 0x20BB, 0x1F7C, 0x1EF7, 0x1CF4, 0x1795, 0x121F, 0x0B95, 0x0595, 0x006C, 0xFBAA, 0xFA00, 0xF7E6, 0xF652, 0xF63B,
    0xF52A, 0xF38A, 0xF088, 0xED3A, 0xE7AE, 0xDD6D, 0xD5E0, 0xD116, 0xD2DB, 0xE26F, 0xF0C1, 0xED9C, 0xE825, 0xE9AC, 0xE769, 0xE60C,
    0xE661, 0xE48F, 0xE229, 0xE0E4, 0xDE0A, 0xDAA2, 0xDB82, 0xE664, 0xF0AF, 0xEB55, 0xEA3E, 0xED59, 0xECEE, 0xEE01, 0xEB5C, 0xE94E,
    0xEB28, 0xF605, 0x0C75, 0x1C7E, 0x29B3, 0x369D, 0x37CE, 0x3A15, 0x3C50, 0x3CC2, 0x3F05, 0x3CB7, 0x3AB9, 0x38F5, 0x3544, 0x3732,
    0x3C95, 0x40B0, 0x3E71, 0x34D0, 0x28FB, 0x1DDC, 0x12B7, 0x06E8, 0xFAD3, 0xF28C, 0xEFA8, 0xF230, 0xF87D, 0xFEEE, 0x03D9, 0x040D,
    0xFFE7, 0xF661, 0xF0F1, 0xEB6D, 0xE347, 0xDF40, 0xD97B, 0xD46C, 0xD625, 0xDC3D, 0xE452, 0xEAE0, 0xED4F, 0xECA2, 0xE970, 0xE791,
    0xE4E1, 0xE139, 0xDE98, 0xDF11, 0xE23F, 0xE66A, 0xEEE6, 0xF746, 0xF9A5, 0xF7DA, 0xF3A5, 0xF101, 0xEE8F, 0xEBCA, 0xEA75, 0xE77D,
    0xE573, 0xE640, 0xEAB8, 0xF140, 0xF7CF, 0xFCE5, 0xFE6F, 0xFCF0, 0xFB86, 0xF8E7, 0xF626, 0xF5FE, 0xF6F3, 0xF93A, 0xFB1B, 0xFDE8,
    0x00B3, 0x02EF, 0x0333, 0x019C, 0x00F1, 0x01CF, 0x0052, 0xFDF1, 0xFDE8, 0xFC6F, 0xFDB2, 0x0023, 0x03BE, 0x0920, 0x0DF1, 0x0F8D,
    0x0BD1, 0x0820, 0x0533, 0x01EB, 0x0157, 0x00F9, 0x0184, 0x05FE, 0x0B30, 0x1101, 0x164E, 0x1921, 0x1A6E, 0x19FA, 0x1898, 0x164D,
    0x11BF, 0x0D7D, 0x0926, 0x068B, 0x0416, 0x0247, 0x020E, 0x01BA, 0x0168, 0xFFBE, 0xFE22, 0xFB82, 0xF8E9, 0xF6BE, 0xF566, 0xF4F6,
    0xF5B3, 0xF77F, 0xFA1C, 0xFC47, 0xFD52, 0xFE67, 0xFF4D, 0xFFCD, 0xFF14, 0xFD89, 0xFCDA, 0xFB61, 0xF8D3, 0xF5B5, 0xF2CC, 0xF247,
    0xF19D, 0xF2A6, 0xF3D7, 0xF3BC, 0xF527, 0xF6DD, 0xF7F1, 0xF959, 0xFBD3, 0xFEC0, 0x0158, 0x0496, 0x0790, 0x094C, 0x0BB2, 0x0D45,
    0x0F85, 0x1117, 0x1233, 0x146F, 0x14D7, 0x1552, 0x15E0, 0x1580, 0x15F0, 0x1705, 0x179D, 0x17C4, 0x16D7, 0x15A4, 0x13D0, 0x11F9,
    0x0F82, 0x0C8A, 0x0AF2, 0x09A7, 0x092D, 0x0948, 0x085C, 0x08BC, 0x0AFA, 0x0D2B, 0x0EFA, 0x0F64, 0x106E, 0x1054, 0x0EC5, 0x0D8B,
    0x0BAB, 0x097B, 0x0880, 0x086B, 0x08AB, 0x0750, 0x050C, 0x021A, 0xFD72, 0xF78E, 0xF05C, 0xEA67, 0xE4DD, 0xE1FB, 0xE0B2, 0xDFD3,
    0xDFB3, 0xDE82, 0xDADB, 0xD775, 0xD3EC, 0xD19F, 0xD235, 0xD698, 0xE33F, 0xFE6C, 0x0F0D, 0x0312, 0x003B, 0x01AC, 0xFE8E, 0xFCC1,
    0xFD91, 0xFDE6, 0xF88B, 0xF653, 0xFCEF, 0x0D8D, 0x0F98, 0x0A59, 0x0CB8, 0x0BBA, 0x05E0, 0x0193, 0xFEDC, 0xFAB0, 0xF885, 0xFF03,
    0x0379, 0x027C, 0x07CA, 0x0C44, 0x0A62, 0x0491, 0x0258, 0x06DB, 0x129E, 0x1B53, 0x1352, 0x0CE4, 0x0961, 0x0624, 0x0B33, 0x0C31,
    0x0C08, 0x0E94, 0x15B0, 0x1429, 0x0A66, 0x03AC, 0xF88D, 0xEAFE, 0xE068, 0xDD76, 0xDE31, 0xE0C7, 0xE949, 0xEDD8, 0xE723, 0xE445,
    0xE5E6, 0xEBAA, 0xF09E, 0xEEEF, 0xEF5B, 0xF001, 0xF4F4, 0xF973, 0xF553, 0xF440, 0xF850, 0xFB42, 0xFDE9, 0xFFEC, 0xFFDE, 0xFE91,
    0xFE92, 0x00C7, 0x0406, 0x0750, 0x0A37, 0x0B0F, 0x0C9E, 0x0DEA, 0x0A4B, 0x08F8, 0x0A78, 0x08FA, 0x075D, 0x0914, 0x0B45, 0x0C72,
    0x0D99, 0x0F42, 0x11C3, 0x142F, 0x1892, 0x1B22, 0x199F, 0x19D5, 0x18B9, 0x1631, 0x182E, 0x1D84, 0x2365, 0x2986, 0x2E31, 0x2DFD,
    0x2A38, 0x27C5, 0x2613, 0x2019, 0x1999, 0x134B, 0x0D0D, 0x07B4, 0x0470, 0x015C, 0xFA4A, 0xF5AB, 0xF1C1, 0xED8F, 0xEA5C, 0xE72A,
    0xE388, 0xDF1E, 0xDA61, 0xD61E, 0xD506, 0xD3FB, 0xD438, 0xD60E, 0xD863, 0xD9EA, 0xDC2C, 0xDE47, 0xDEFE, 0xDFCA, 0xE031, 0xE352,
    0xE70B, 0xEB86, 0xEFCD, 0xF367, 0xF75D, 0xFA2F, 0xFD8D, 0x018A, 0x0362, 0x05A5, 0x084A, 0x09DD, 0x0B4D, 0x0D50, 0x1125, 0x169F,
    0x1B0A, 0x1E59, 0x2081, 0x2187, 0x22F7, 0x2370, 0x2341, 0x2325, 0x2455, 0x252F, 0x25EF, 0x25EA, 0x2545, 0x224D, 0x1E80, 0x193C,
    0x12BC, 0x0C8A, 0x0510, 0xFE33, 0xF7B2, 0xF327, 0xF020, 0xEDDD, 0xED5A, 0xEC32, 0xEBCE, 0xECAD, 0xEAB9, 0xE9D3, 0xE75E, 0xE39D,
    0xE09C, 0xDD76, 0xDC6D, 0xDC17, 0xDBC6, 0xDC97, 0xDD9C, 0xDEED, 0xE004, 0xE085, 0xE09C, 0xE119, 0xE56B, 0xE8FE, 0xEDFB, 0xF3AA,
    0xF78A, 0xFD8F, 0x0274, 0x05B2, 0x0999, 0x0C15, 0x0D75, 0x0E2B, 0x0E0C, 0x0E52, 0x0E69, 0x104C, 0x132B, 0x174D, 0x1A38, 0x1B1F,
    0x1D76, 0x1DFD, 0x1DFF, 0x1E10, 0x1E06, 0x1EE3, 0x1FED, 0x1FCB, 0x2036, 0x1E27, 0x1AEA, 0x185B, 0x1451, 0x0F15, 0x0741, 0x019C,
    0xFBFF, 0xF71B, 0xF34D, 0xF079, 0xF05C, 0xF175, 0xF237, 0xF278, 0xF1CC, 0xF28A, 0xF3CE, 0xF42E, 0xF5E8, 0xF698, 0xF704, 0xF804,
    0xFA1E, 0xFC97, 0xFE2E, 0x00F9, 0x03F2, 0x05C8, 0x084B, 0x0915, 0x0AA2, 0x0B63, 0x0BD9, 0x0D04, 0x0D16, 0x0D64, 0x0E53, 0x0E61,
    0x0D33, 0x0B0C, 0x081E, 0x0552, 0x013F, 0xFEDF, 0xFDFC, 0xFF1E, 0x0170, 0x0370, 0x0603, 0x07DE, 0x08E4, 0x0A63, 0x0A36, 0x0A79,
    0x0B8B, 0x0D49, 0x1146, 0x1357, 0x1443, 0x13CB, 0x1189, 0x1003, 0x0DED, 0x0BB4, 0x092E, 0x045C, 0x007C, 0xFC75, 0xF88D, 0xF60B,
    0xF400, 0xF3B1, 0xF289, 0xF2BC, 0xF2EE, 0xF248, 0xF39E, 0xF169, 0xEEA6, 0xED38, 0xEA76, 0xE8C4, 0xE688, 0xE3CF, 0xE427, 0xE3C6,
    0xE3D1, 0xE4D9, 0xE4C9, 0xE4BB, 0xE43B, 0xE414, 0xE3A8, 0xE35A, 0xE25A, 0xE0F5, 0xE1D8, 0xE18D, 0xE1D7, 0xE476, 0xE4DA, 0xE5BD,
    0xE6EC, 0xE72E, 0xE842, 0xE9CE, 0xECD9, 0xF160, 0xF5B6, 0xFC58, 0x0136, 0x06EF, 0x0B95, 0x0F0F, 0x13A3, 0x166E, 0x1BF4, 0x2065,
    0x23E0, 0x2859, 0x2B18, 0x2C99, 0x2CE5, 0x2B4C, 0x2A74, 0x2648, 0x21C3, 0x1BF2, 0x16EE, 0x149A, 0x1128, 0x0FBD, 0x0D85, 0x0B67,
    0x0AD9, 0x0884, 0x0776, 0x069B, 0x0313, 0xFF5F, 0xFB2E, 0xF9A4, 0xF756, 0xF54C, 0xF41B, 0xF342, 0xF328, 0xF26D, 0xF278, 0xF372,
    0xF383, 0xF38F, 0xF3E2, 0xF423, 0xF6DB, 0xF97F, 0xFB1D, 0xFC69, 0xFC7B, 0xFBF5, 0xFA20, 0xF88D, 0xF661, 0xF137, 0xEDC8, 0xEC02,
    0xEA3D, 0xEA19, 0xEAD2, 0xEBE3, 0xEE9C, 0xEF5E, 0xEFF7, 0xF1C4, 0xF3F2, 0xF75C, 0xFB67, 0x0050, 0x053F, 0x0B3F, 0x1010, 0x146C,
    0x19E2, 0x1AF6, 0x1B31, 0x1A16, 0x170E, 0x15B2, 0x127A, 0x0FC5, 0x0F92, 0x0F83, 0x10DD, 0x12D9, 0x149C, 0x16B8, 0x1634, 0x1547,
    0x133B, 0x11FB, 0x1093, 0x0E91, 0x0CD8, 0x09F1, 0x08A3, 0x07C9, 0x05D5, 0x051C, 0x03C9, 0x0248, 0x01FF, 0x00D8, 0x0001, 0xFE9A,
    0xFD42, 0xFC1F, 0xFB7B, 0xFAC3, 0xFB8E, 0xFC36, 0xFBC1, 0xF900, 0xF6A1, 0xF36C, 0xEFEC, 0xEDC6, 0xEB6C, 0xEBDC, 0xEEA2, 0xF1CE,
    0xF42E, 0xF568, 0xF604, 0xF565, 0xF3E0, 0xF3F6, 0xF2F1, 0xF261, 0xF3BE, 0xF695, 0xF98A, 0xFAD5, 0xFAA6, 0xFAF3, 0xFB00, 0xFB3F,
    0xF995, 0xF6B1, 0xF3C3, 0xF09D, 0xEFBA, 0xEEC1, 0xEFBC, 0xF0ED, 0xF32B, 0xF67A, 0xF789, 0xF887, 0xF8B4, 0xF8C3, 0xF871, 0xF7EC,
    0xF842, 0xF7E3, 0xF844, 0xF88A, 0xF882, 0xF8CD, 0xF9C1, 0xFAA5, 0xFBB0, 0xFCE6, 0xFD3A, 0xFE37, 0xFEE4, 0xFF5A, 0x0098, 0x0141,
    0x0286, 0x045B, 0x068E, 0x0805, 0x090B, 0x0903, 0x09FB, 0x0ADB, 0x0A5F, 0x0A0A, 0x0AC5, 0x0C9F, 0x0DEB, 0x10C8, 0x10C8, 0x12D5,
    0x1411, 0x144F, 0x157E, 0x1693, 0x1817, 0x18FF, 0x1ABF, 0x1B9F, 0x1C39, 0x1B95, 0x1A4A, 0x173B, 0x12C2, 0x0C78, 0x0608, 0xFE93,
    0xF605, 0xEEC4, 0xE8EB, 0xE55C, 0xE302, 0xDFD1, 0xDF44, 0xDE5D, 0xDE12, 0xDE3B, 0xDEEF, 0xE01A, 0xE0A9, 0xE2E6, 0xE4D6, 0xE7CB,
    0xEA5F, 0xEDC5, 0xF155, 0xF5C6, 0xFA31, 0xFEAF, 0x026F, 0x0696, 0x0AE2, 0x0E44, 0x13CF, 0x188E, 0x1DE8, 0x220B, 0x24EF, 0x277A,
    0x275B, 0x26DF, 0x254F, 0x2435, 0x223A, 0x1FBC, 0x1EA6, 0x1C9D, 0x1A91, 0x18EA, 0x17D5, 0x1628, 0x1471, 0x120A, 0x0FC4, 0x0DCD,
    0x0D2E, 0x0C9A, 0x0B1C, 0x0B75, 0x0C09, 0x0C27, 0x0A73, 0x08C7, 0x054C, 0xFF69, 0xF8F6, 0xEFFB, 0xE897, 0xE1EE, 0xDD3B, 0xDA3B,
    0xD89E, 0xD993, 0xDA47, 0xDB10, 0xDB06, 0xDB2C, 0xDA11, 0xDABF, 0xDD5F, 0xDF22, 0xE0AD, 0xE339, 0xE51D, 0xE7B9, 0xEAC2, 0xED06,
    0xF12F, 0xF415, 0xF672, 0xF9B1, 0xFD39, 0x0048, 0x02C5, 0x0684, 0x0947, 0x0C31, 0x0EAB, 0x0F03, 0x0FE2, 0x0F3C, 0x0E2A, 0x0D1A,
    0x0B28, 0x0927, 0x084B, 0x079E, 0x078A, 0x0779, 0x071A, 0x064C, 0x0744, 0x06E5, 0x0661, 0x0703, 0x070B, 0x07BE, 0x0890, 0x0AF8,
    0x0CA9, 0x0F0C, 0x0FFD, 0x1177, 0x11A4, 0x1188, 0x10CD, 0x0EEA, 0x0B86, 0x06A7, 0x0354, 0xFF87, 0xFDBB, 0xFBB6, 0xFAF4, 0xF91F,
    0xF77A, 0xF505, 0xF1FB, 0xEE9A, 0xEAD2, 0xE84D, 0xE63A, 0xE3FF, 0xE16E, 0xE01D, 0xDE8B, 0xDDD7, 0xDD40, 0xDDB0, 0xDE64, 0xDEF9,
    0xDF29, 0xDFDD, 0xE217, 0xE493, 0xE76C, 0xEC22, 0xEF8A, 0xF152, 0xF434, 0xF603, 0xF7B9, 0xF906, 0xFA4E, 0xFD02, 0xFFE0, 0x022C,
    0x0376, 0x05B1, 0x0872, 0x0B8C, 0x0EB4, 0x1021, 0x1383, 0x1633, 0x18B7, 0x1CD8, 0x1FE7, 0x23DF, 0x2865, 0x2CAB, 0x3116, 0x342B,
    0x3658, 0x37CA, 0x3719, 0x34C2, 0x3007, 0x2CA5, 0x282E, 0x2407, 0x2071, 0x1C35, 0x18E9, 0x13EA, 0x110D, 0x0D58, 0x0973, 0x061D,
    0x030A, 0xFF4E, 0xFB56, 0xF712, 0xF26F, 0xEE59, 0xEB40, 0xE890, 0xE511, 0xE3DE, 0xE15F, 0xE03C, 0xDE67, 0xDBE3, 0xD9BF, 0xD87B,
    0xDA70, 0xDBD5, 0xDEFF, 0xE237, 0xE546, 0xE6F2, 0xE6FF, 0xE865, 0xE901, 0xEA0E, 0xEB05, 0xED03, 0xEED4, 0xF1E0, 0xF49C, 0xF6CE,
    0xF978, 0xFB7F, 0xFED7, 0x0190, 0x0500, 0x065F, 0x09AE, 0x0B7D, 0x0CC6, 0x0F2E, 0x1072, 0x1335, 0x145A, 0x168D, 0x165E, 0x1549,
    0x11FA, 0x0C5B, 0x06FE, 0x019E, 0xFDC3, 0xF9B2, 0xF729, 0xF6EE, 0xF787, 0xF75B, 0xF7FA, 0xF849, 0xF85E, 0xF8AE, 0xF843, 0xF924,
    0xF817, 0xF7E7, 0xF861, 0xF7D4, 0xF804, 0xF80F, 0xF800, 0xF7B7, 0xF636, 0xF4D2, 0xF44F, 0xF2B8, 0xF1DB, 0xF2FC, 0xF3AE, 0xF4B0,
    0xF600, 0xF5A3, 0xF57D, 0xF4F7, 0xF346, 0xF10D, 0xF033, 0xEFE1, 0xEE6A, 0xEEED, 0xEF21, 0xF045, 0xF2F5, 0xF45C, 0xF728, 0xF93B,
    0xFB8C, 0x005F, 0x03B6, 0x062E, 0x0B46, 0x1050, 0x162A, 0x1BA7, 0x1FB9, 0x23F1, 0x2548, 0x26D5, 0x261B, 0x2511, 0x23E8, 0x2006,
    0x1DFF, 0x1AE9, 0x1717, 0x146B, 0x1063, 0x0D53, 0x0989, 0x05C7, 0x0357, 0xFEDA, 0xFB3A, 0xF74F, 0xF412, 0xF1E2, 0xEEBA, 0xED74,
    0xECBF, 0xEB75, 0xECAD, 0xEBC7, 0xEBC6, 0xEBE7, 0xEAC8, 0xEC1C, 0xEC51, 0xEE18, 0xF02D, 0xF28F, 0xF508, 0xF6DB, 0xF70E, 0xF78D,
    0xF790, 0xF795, 0xF808, 0xF851, 0xFA93, 0xFC30, 0xFE5A, 0xFE86, 0xFFBA, 0x00AF, 0x017D, 0x03FC, 0x0433, 0x04CE, 0x055C, 0x06F4,
    0x08A4, 0x0B32, 0x0E96, 0x13A7, 0x1966, 0x1E18, 0x2273, 0x2386, 0x2409, 0x229B, 0x20BC, 0x1D79, 0x19F2, 0x1596, 0x11D3, 0x0E68,
    0x09BE, 0x0720, 0x031D, 0x0128, 0xFEBD, 0xFC8A, 0xFAF0, 0xF886, 0xF6C9, 0xF4D1, 0xF321, 0xF182, 0xF252, 0xF257, 0xF31F, 0xF335,
    0xF25D, 0xF18C, 0xF097, 0xF066, 0xEE0B, 0xED96, 0xEE14, 0xF05A, 0xF2E1, 0xF611, 0xF866, 0xF9D5, 0xFA5A, 0xF94B, 0xF96A, 0xF691,
    0xF508, 0xF34B, 0xF231, 0xF153, 0xF049, 0xF2A6, 0xF4A8, 0xF6EE, 0xF7FA, 0xF672, 0xF559, 0xF392, 0xF188, 0xF29F, 0xF262, 0xF322,
    0xF5E4, 0xF674, 0xF918, 0xF8A2, 0xF898, 0xF7F3, 0xF672, 0xF552, 0xF187, 0xF249, 0xF181, 0xF195, 0xF24B, 0xF2CB, 0xF667, 0xFA94,
    0xFE82, 0x0228, 0x029A, 0x02E2, 0x0473, 0x03CF, 0x03E0, 0x0277, 0x037C, 0x047A, 0x051D, 0x08A8, 0x0948, 0x0906, 0x0854, 0x0878,
    0x0872, 0x07FF, 0x098E, 0x0A4B, 0x0C60, 0x0D8C, 0x0F22, 0x107A, 0x1090, 0x1087, 0x0FDA, 0x0FDF, 0x0F0C, 0x0F11, 0x0ADB, 0x075A,
    0x05D3, 0x0237, 0xFF0E, 0xFCB5, 0xFB45, 0xF902, 0xF6FA, 0xF48A, 0xF39F, 0xF1B7, 0xF1A5, 0xF3C2, 0xF653, 0xFB2D, 0xFEDA, 0x0354,
    0x04B3, 0x06AC, 0x081D, 0x0944, 0x0B00, 0x09D8, 0x0A46, 0x099B, 0x08A7, 0x0742, 0x0759, 0x0785, 0x07E5, 0x09BA, 0x0AB8, 0x0B22,
    0x0AC9, 0x0AB1, 0x0A2E, 0x0A16, 0x09E3, 0x0AC2, 0x0AD2, 0x0A43, 0x0A1C, 0x083E, 0x0761, 0x0523, 0x0307, 0x008C, 0xFE6F, 0xFE52,
    0xFDBB, 0xFDD5, 0xFD62, 0xFB95, 0xFA53, 0xF87F, 0xF66D, 0xF5B3, 0xF38F, 0xF3D3, 0xF480, 0xF4DF, 0xF579, 0xF489, 0xF64F, 0xF7F6,
    0xF82B, 0xFACA, 0xFC5B, 0xFDC4, 0xFF2F, 0x005B, 0x03C7, 0x0627, 0x0A7C, 0x0EEC, 0x12F9, 0x16F6, 0x1898, 0x1A0C, 0x1949, 0x164A,
    0x13A9, 0x0FA7, 0x0BA0, 0x07A5, 0x0293, 0xFE8A, 0xF9D7, 0xF64B, 0xF3EA, 0xF067, 0xEE25, 0xEAD4, 0xE81A, 0xE5D1, 0xE3B1, 0xE2DA,
    0xE2CC, 0xE4D5, 0xE5EF, 0xE79F, 0xE9A0, 0xEAF3, 0xEB30, 0xEBC7, 0xECAC, 0xEE63, 0xEFFE, 0xF0AB, 0xF3D9, 0xF6CE, 0xFA83, 0xFEA4,
    0x0219, 0x056D, 0x080F, 0x0A4C, 0x0BEF, 0x0D6F, 0x0E08, 0x0EE2, 0x0FD7, 0x10ED, 0x11AB, 0x11EF, 0x116B, 0x0FDA, 0x0E74, 0x0B19,
    0x08DE, 0x06DA, 0x0583, 0x0650, 0x07EA, 0x0A9A, 0x0D43, 0x0FD3, 0x127A, 0x139C, 0x13BD, 0x1389, 0x12F0, 0x10F5, 0x0CE2, 0x0943,
    0x0487, 0xFFD4, 0xFC1C, 0xF8FE, 0xF646, 0xF4C7, 0xF42A, 0xF372, 0xF104, 0xED79, 0xEAD4, 0xE905, 0xE880, 0xE7AF, 0xE895, 0xE99D,
    0xEA79, 0xEBE4, 0xEBF0, 0xEDAE, 0xEE71, 0xEFC0, 0xF229, 0xF44D, 0xF876, 0xFC72, 0x0188, 0x0700, 0x0BFC, 0x1082, 0x1536, 0x180D,
    0x1AA7, 0x1BD0, 0x1C60, 0x1D2E, 0x1C21, 0x1D3B, 0x1CC3, 0x1CF3, 0x1D32, 0x1DB8, 0x1F48, 0x1D8E, 0x1C4F, 0x1AB6, 0x193B, 0x18F7,
    0x1803, 0x185A, 0x1A15, 0x1C58, 0x1E62, 0x1FCB, 0x2012, 0x2014, 0x1E7B, 0x1D43, 0x1B75, 0x189F, 0x15FF, 0x11B7, 0x0FB1, 0x0C21,
    0x09FD, 0x086D, 0x059C, 0x03D0, 0xFFF9, 0xFC8E, 0xF79F, 0xF20E, 0xEC99, 0xE881, 0xE50C, 0xE25C, 0xE12F, 0xDF4B, 0xDEA1, 0xDC98,
    0xDB14, 0xD90C, 0xD7D6, 0xD68E, 0xD600, 0xD6B8, 0xD69E, 0xD98F, 0xDBDA, 0xDE8C, 0xE00E, 0xE1A1, 0xE3C8, 0xE5E4, 0xE7F3, 0xE9F0,
    0xEE4A, 0xF18C, 0xF6C1, 0xFB46, 0xFF5D, 0x02EC, 0x0541, 0x088E, 0x09BF, 0x0BE1, 0x0C0B, 0x0DD5, 0x1000, 0x12DE, 0x1627, 0x1A20,
    0x1EE8, 0x2267, 0x2679, 0x27DF, 0x2AC2, 0x2ABA, 0x2975, 0x2697, 0x22F2, 0x1F62, 0x1A8B, 0x173F, 0x131C, 0x104A, 0x0CE1, 0x0A2B,
    0x07B0, 0x039B, 0xFF98, 0xFC06, 0xF93C, 0xF678, 0xF467, 0xF32D, 0xF26F, 0xF070, 0xEF51, 0xED31, 0xE99A, 0xE733, 0xE4DB, 0xE429,
    0xE24F, 0xE1C9, 0xE1A8, 0xE22F, 0xE3C1, 0xE56C, 0xE920, 0xEC69, 0xEFED, 0xF386, 0xF584, 0xF76B, 0xF966, 0xFA12, 0xFCED, 0xFFCE,
    0x02E1, 0x0607, 0x0790, 0x08DD, 0x0852, 0x086D, 0x081E, 0x0832, 0x09B2, 0x0A40, 0x0D26, 0x1079, 0x13A2, 0x175D, 0x1AF7, 0x1DC7,
    0x204F, 0x2154, 0x21FA, 0x215A, 0x1EB8, 0x1C23, 0x182E, 0x14F3, 0x10D1, 0x0E1B, 0x0B08, 0x093E, 0x089B, 0x0759, 0x06E5, 0x04AB,
    0x03F0, 0x0288, 0x01F6, 0x0215, 0x02A6, 0x03F1, 0x0346, 0x0323, 0x0217, 0x01D5, 0xFFFD, 0xFE96, 0xFD35, 0xFC84, 0xFB99, 0xF9FC,
    0xF9E0, 0xF927, 0xF9E1, 0xF8DE, 0xF99A, 0xF8BB, 0xF7D4, 0xF602, 0xF4C3, 0xF416, 0xF15A, 0xF152, 0xF007, 0xEFD5, 0xEDFB, 0xEC54,
    0xEB6E, 0xE8F1, 0xE77E, 0xE6C6, 0xE869, 0xEA6B, 0xEDC5, 0xF113, 0xF69B, 0xFCD0, 0x0340, 0x0A63, 0x105A, 0x16C7, 0x19F7, 0x1DBB,
    0x1F0E, 0x208B, 0x2084, 0x1EEC, 0x1F31, 0x1DCC, 0x1D0A, 0x1B0E, 0x1A46, 0x17C9, 0x15F0, 0x139F, 0x1056, 0x0DFD, 0x09EE, 0x0752,
    0x043C, 0x0165, 0xFE7B, 0xFD0A, 0xFA5E, 0xF73E, 0xF4D7, 0xF191, 0xF074, 0xED11, 0xEAF7, 0xE835, 0xE6C7, 0xE5C5, 0xE4F5, 0xE560,
    0xE341, 0xE2F4, 0xE123, 0xDF2F, 0xDCBB, 0xDA31, 0xD982, 0xDAA4, 0xDC58, 0xDE19, 0xE18B, 0xE255, 0xE377, 0xE3D4, 0xE489, 0xE52D,
    0xE540, 0xE6F2, 0xE837, 0xEC44, 0xEF75, 0xF4E9, 0xFB75, 0x0248, 0x0932, 0x0F96, 0x15A2, 0x1991, 0x1C95, 0x1E64, 0x20A3, 0x20C8,
    0x211E, 0x2153, 0x2273, 0x2246, 0x211D, 0x20BF, 0x1EFF, 0x1C48, 0x1792, 0x142C, 0x10E7, 0x0E56, 0x0C42, 0x0A5B, 0x0916, 0x06AB,
    0x03EE, 0x011D, 0xFE08, 0xF9B9, 0xF787, 0xF630, 0xF477, 0xF38E, 0xF1FC, 0xF1C7, 0xF293, 0xF52A, 0xF718, 0xFB11, 0xFEB2, 0x018E,
    0x04A9, 0x05EB, 0x0758, 0x07C3, 0x09A8, 0x0B83, 0x0DCE, 0x0DEE, 0x0E1D, 0x0E0C, 0x0AEE, 0x07EE, 0x044A, 0x01D4, 0xFF03, 0xFE02,
    0xFD54, 0xFE4E, 0xFF75, 0x00EE, 0x0403, 0x0476, 0x054B, 0x052E, 0x0581, 0x0365, 0x01AB, 0xFECB, 0xFB95, 0xF9D2, 0xF6C2, 0xF5E8,
    0xF49D, 0xF4D3, 0xF50F, 0xF688, 0xF795, 0xF888, 0xF98F, 0xF9DC, 0xFC45, 0xFD6B, 0xFF0E, 0xFFC3, 0x011F, 0x01E0, 0x0261, 0x02F6,
    0x0318, 0x049B, 0x0402, 0x055C, 0x04F2, 0x05A5, 0x069E, 0x07E9, 0x0A98, 0x0B20, 0x0C87, 0x0C8E, 0x0C0F, 0x09D6, 0x082E, 0x0609,
    0x050E, 0x03F7, 0x02FE, 0x021F, 0xFFF3, 0xFF15, 0xFC2F, 0xFB16, 0xF8E3, 0xF609, 0xF440, 0xF1AD, 0xF00C, 0xEE3E, 0xEF55, 0xF106,
    0xF3C4, 0xF72F, 0xFAE7, 0xFD2D, 0xFD95, 0xFDEB, 0xFCF9, 0xFC4D, 0xF9C2, 0xF908, 0xF79E, 0xF69C, 0xF5BE, 0xF472, 0xF45E, 0xF1F7,
    0xF12F, 0xEFFF, 0xEFB8, 0xEF2F, 0xEF28, 0xEFF8, 0xF029, 0xF1A1, 0xF24A, 0xF410, 0xF558, 0xF66D, 0xF740, 0xF8CF, 0xF8D1, 0xF861,
    0xF88E, 0xF710, 0xF7A7, 0xF73F, 0xF8BD, 0xFACE, 0xFCB8, 0xFD27, 0xFD34, 0xFE2E, 0xFD79, 0xFDCE, 0xFCAE, 0xFEAF, 0x016B, 0x031E,
    0x0516, 0x06EF, 0x0876, 0x0934, 0x0B12, 0x0B00, 0x0AD2, 0x09E7, 0x0923, 0x090B, 0x09AC, 0x0B02, 0x0E12, 0x12CB, 0x1610, 0x1AD0,
    0x1DBA, 0x20AA, 0x212E, 0x20E2, 0x203B, 0x1DF2, 0x1C65, 0x19C7, 0x1887, 0x153D, 0x12D1, 0x0F81, 0x0BD6, 0x0791, 0x0306, 0xFFE8,
    0xFC81, 0xFA6A, 0xF881, 0xF78A, 0xF5BE, 0xF5DB, 0xF5B3, 0xF63E, 0xF603, 0xF508, 0xF662, 0xF5BD, 0xF767, 0xF7E6, 0xF96E, 0xFB0C,
    0xFC10, 0xFEA4, 0xFFC7, 0x0241, 0x03E7, 0x0531, 0x06A4, 0x092D, 0x0ADB, 0x0CBB, 0x0E71, 0x10A9, 0x1357, 0x13C4, 0x14EC, 0x13A9,
    0x123C, 0x0F1C, 0x0B91, 0x0870, 0x040F, 0x022F, 0x0093, 0x00A6, 0x016D, 0x0385, 0x06E0, 0x0A95, 0x0C73, 0x0CDC, 0x0E2F, 0x0D5C,
    0x0C46, 0x0A6B, 0x0895, 0x06AE, 0x0437, 0x0119, 0xFDD4, 0xFAA5, 0xF5E0, 0xF2AC, 0xEFA5, 0xEC9F, 0xE9AD, 0xE6E4, 0xE518, 0xE44E,
    0xE37B, 0xE1FF, 0xE247, 0xE1A1, 0xE128, 0xE117, 0xE04F, 0xE051, 0xE0A1, 0xE163, 0xE2BF, 0xE522, 0xE812, 0xEBE4, 0xEFB6, 0xF31A,
    0xF691, 0xF9CA, 0xFBCE, 0xFE64, 0x0130, 0x02AD, 0x0562, 0x0681, 0x0842, 0x0A4D, 0x0AC3, 0x0B7B, 0x0B47, 0x0BD7, 0x0B4B, 0x09E2,
    0x087C, 0x0711, 0x0627, 0x052F, 0x04C4, 0x0612, 0x0863, 0x0BBF, 0x1056, 0x139A, 0x158A, 0x1663, 0x1771, 0x16DC, 0x1584, 0x156C,
    0x1581, 0x16A7, 0x1666, 0x15DA, 0x15B0, 0x14BB, 0x1366, 0x1156, 0x108A, 0x0F1E, 0x0CC4, 0x0A5B, 0x06A4, 0x0366, 0x006A, 0xFCC9,
    0xFA0D, 0xF7D3, 0xF7DD, 0xFA19, 0xF8F8, 0xF2FF, 0xED7B, 0xE9E1, 0xE64F, 0xE447, 0xE2B3, 0xE141, 0xDFD0, 0xDEC7, 0xDE9B, 0xE07E,
    0xE2B1, 0xE277, 0xE217, 0xDEE3, 0xDE9C, 0xE509, 0xEBDB, 0xF287, 0xF943, 0xFD4B, 0x0032, 0x02FB, 0x0502, 0x081E, 0x0A25, 0x0D08,
    0x1092, 0x1576, 0x1B89, 0x2020, 0x263D, 0x2A3E, 0x2F26, 0x31F8, 0x3228, 0x3346, 0x32FD, 0x3315, 0x317D, 0x2FD5, 0x2DDB, 0x2B6D,
    0x27DA, 0x2335, 0x1EF1, 0x1B03, 0x1681, 0x11F0, 0x0D18, 0x08AD, 0x04C9, 0x0126, 0xFEB0, 0xFBB6, 0xF8E2, 0xF713, 0xF3EA, 0xF03C,
    0xEBB8, 0xE7EE, 0xE5E7, 0xE35E, 0xE1E0, 0xE13B, 0xE159, 0xE11B, 0xE1D4, 0xE284, 0xE438, 0xE4E8, 0xE665, 0xE7F3, 0xEA89, 0xEBF9,
    0xEE7D, 0xF053, 0xF36A, 0xF561, 0xF7D6, 0xF9BE, 0xFAB4, 0xFBDA, 0xFA18, 0xFA4D, 0xF94A, 0xFB5D, 0xFD2E, 0x0316, 0x08F8, 0x1381,
    0x17BE, 0x1D5A, 0x1BD8, 0x1E01, 0x0C13, 0x108D, 0x3315, 0x2536, 0x221B, 0x25B7, 0x2B70, 0x2A92, 0x2093, 0x1C5E, 0x153B, 0x09E2,
    0xF8FE, 0xE4FD, 0xDDFF, 0xBA94, 0x9245, 0x91D8, 0x97DF, 0xA809, 0xA674, 0xB2F7, 0xAE6C, 0xB6F7, 0xCEDC, 0xE058, 0x0227, 0xD9D3,
    0xBF99, 0xBC08, 0xBC3B, 0xC6C6, 0xC90D, 0xD3BE, 0xD573, 0xE482, 0xE85D, 0xF135, 0xF294, 0xEFB3, 0x17DD, 0x474D, 0x6715, 0x6CE2,
    0x6244, 0x5DB8, 0x56CF, 0x4A9E, 0x4B0B, 0x3AAC, 0x1693, 0xFD39, 0xE359, 0xDA78, 0xC9B0, 0xBF29, 0xBF62, 0xC9AA, 0xCEC6, 0xDA77,
    0xDB2D, 0xDB53, 0xF368, 0x0543, 0x3576, 0x2806, 0x0AFE, 0xF83E, 0xF371, 0xFB0D, 0xF7CC, 0x032D, 0x000E, 0x0E47, 0x0E78, 0x169F,
    0x1B32, 0x0B7E, 0x1FA9, 0x4266, 0x63BA, 0x72EA, 0x6F33, 0x68AE, 0x61EA, 0x5268, 0x4D43, 0x484E, 0x2F5A, 0x1518, 0xF7F7, 0xE647,
    0xD6E9, 0xC8F9, 0xBDB6, 0xC2BD, 0xC002, 0xC800, 0xC866, 0xC0C1, 0xCAEA, 0xCBE5, 0xF436, 0xFF48, 0xEB5E, 0xD5A6, 0xC92D, 0xCAC2,
    0xC58D, 0xCCA7, 0xC971, 0xD132, 0xD105, 0xD54F, 0xE19D, 0xD551, 0xDE40, 0xF8C2, 0x22B8, 0x4A43, 0x5901, 0x5B87, 0x5D6C, 0x5561,
    0x507B, 0x529A, 0x48C8, 0x36F7, 0x1EB7, 0x0BA6, 0xFA68, 0xEBC2, 0xD766, 0xD97B, 0xD2EC, 0xD9AE, 0xDF1C, 0xD76F, 0xDFA8, 0xD672,
    0xF7E5, 0x159A, 0x130A, 0xFA4C, 0xE1DE, 0xDBC1, 0xD2B6, 0xD734, 0xD399, 0xD9D0, 0xDC10, 0xDAFD, 0xEC98, 0xE560, 0xDF7D, 0xED40,
    0x0A7D, 0x332C, 0x4BF0, 0x5323, 0x5675, 0x4EB1, 0x469F, 0x451C, 0x41B8, 0x345D, 0x1EB2, 0x0A99, 0xF4F9, 0xE7F8, 0xCEE8, 0xCAE3,
    0xC258, 0xC3BD, 0xCBDE, 0xC71A, 0xD263, 0xC694, 0xD8EF, 0xFBAD, 0x0FE4, 0x07AB, 0xEFE6, 0xE7D1, 0xDDFD, 0xE211, 0xDFE6, 0xE549,
    0xEBCB, 0xE63E, 0xF688, 0xF958, 0xEE6D, 0xEF99, 0x012C, 0x26D0, 0x4907, 0x568F, 0x5FA2, 0x5C57, 0x558E, 0x5170, 0x4FFF, 0x47BB,
    0x330F, 0x1DA6, 0x04E1, 0xFB10, 0xE0E8, 0xD9EA, 0xD33A, 0xD23B, 0xDDBE, 0xDA22, 0xE888, 0xDEA9, 0xDF97, 0xF92C, 0x156D, 0x1C63,
    0x097A, 0x03AC, 0xF93F, 0xF626, 0xF34A, 0xF75A, 0x0449, 0xFDBC, 0x087D, 0x151D, 0x0CC5, 0x03A3, 0x04EB, 0x1A9B, 0x3E7B, 0x51BF,
    0x5CAC, 0x5B45, 0x570C, 0x5220, 0x4F60, 0x4F43, 0x43C8, 0x3853, 0x2336, 0x1BF1, 0x04CE, 0xF974, 0xED9E, 0xE1F5, 0xEAD4, 0xE70C,
    0xF432, 0xF03F, 0xE509, 0xEB5B, 0x047A, 0x1A81, 0x1515, 0x0991, 0xF535, 0xEDCC, 0xEA4D, 0xE720, 0xF11D, 0xEC67, 0xEDE2, 0xFB27,
    0xFD1E, 0xF8C1, 0xF761, 0x02DC, 0x22BF, 0x3AD3, 0x4DE0, 0x559D, 0x53D6, 0x4BB6, 0x44FA, 0x439F, 0x3A72, 0x32A1, 0x1DC8, 0x1291,
    0xFB06, 0xE8F3, 0xDDDD, 0xD2E2, 0xD9AD, 0xD6C4, 0xE0D2, 0xE6E4, 0xDEC1, 0xDB65, 0xED44, 0x0B55, 0x1231, 0x0D82, 0xFC2C, 0xF630,
    0xF68C, 0xF1AD, 0xFCED, 0x00B4, 0x00E9, 0x0E96, 0x1BB9, 0x1C83, 0x153C, 0x0B49, 0x2FAF, 0x49D6, 0x5C8F, 0x63A5, 0x68BD, 0x6CB3,
    0x4DCC, 0x57A8, 0x4AFD, 0x4A1D, 0x2DDB, 0x1C3A, 0x1620, 0xFB0B, 0xEBE3, 0xDB47, 0xD68E, 0xD09D, 0xDDC0, 0xD0B4, 0xDE2D, 0xCBC5,
    0xD27D, 0xEFD1, 0xED01, 0x0706, 0xFE5D, 0xEA99, 0xF27E, 0xED9E, 0xDAAA, 0xE6FE, 0xE85D, 0xE9B1, 0x15A3, 0xF373, 0xF6E1, 0x154F,
    0xF632, 0x34B7, 0x38B5, 0x5249, 0x7265, 0x422D, 0x55FD, 0x4F50, 0x4FEF, 0x3C83, 0x1BDB, 0x40C0, 0x2637, 0xF816, 0xF583, 0xF2B2,
    0xDE02, 0xDA48, 0xC541, 0xE667, 0xE98F, 0xCF6C, 0xEAD7, 0xF444, 0xF97C, 0xF480, 0x0DCE, 0xEB23, 0xEB2E, 0xD0A3, 0xBFC4, 0xD04E,
    0xD3D2, 0xCB2C, 0xBAA6, 0xE538, 0xDBF8, 0xC793, 0xD04A, 0xE2B3, 0xEEFC, 0x078E, 0x22E0, 0x3E22, 0x386B, 0x4113, 0x4094, 0x2E7C,
    0x4C60, 0x4270, 0x40D0, 0x2F8E, 0x2304, 0x224C, 0x1466, 0x1A02, 0x0607, 0x1CB9, 0x273F, 0x1A15, 0x0D7A, 0x2557, 0x24C0, 0x2B08,
    0x2A27, 0x119F, 0x04FC, 0xD3C8, 0xCBD1, 0xBF50, 0xC635, 0xB7DD, 0xA925, 0xB6CB, 0xB346, 0xA8FC, 0xA741, 0xBBCD, 0xB8D5, 0xB4DB,
    0xE16E, 0xE7C2, 0x03CF, 0xE78C, 0x0E8C, 0x2803, 0xEFF2, 0x0CD8, 0xFCB8, 0x0B9E, 0xED20, 0xDED1, 0xC760, 0xD00C, 0xC2F6, 0xD5E0,
    0xFBF8, 0xF42B, 0xDFAF, 0xEBB8, 0x2942, 0xFCB2, 0x3E02, 0x3A88, 0x3329, 0x3E37, 0x24E5, 0x3C8E, 0x4161, 0x2E0B, 0x28F7, 0x4903,
    0x47A2, 0x4BD5, 0x4517, 0x4DB8, 0x4EFE, 0x6F42, 0x770C, 0x7626, 0x7FFF, 0x7ECA, 0x70AA, 0x634A, 0x71F2, 0x55C9, 0x5691, 0x55EF,
    0x1FCF, 0x217F, 0x223F, 0x0E3A, 0xF78D, 0xF88F, 0xF6E4, 0xFB2C, 0x14DE, 0x05BE, 0x13BE, 0x1632, 0x3D82, 0x2FDB, 0x3878, 0x298F,
    0x21B5, 0x2DD2, 0x04AF, 0x2747, 0x18C8, 0x1B6A, 0x05BC, 0x1AA3, 0x1377, 0xE714, 0x050B, 0x07A5, 0x185B, 0x2091, 0x469C, 0x328B,
    0x2B92, 0x3DA5, 0x10A6, 0x302E, 0x27F1, 0xF3C6, 0xF1B1, 0x04EC, 0xCAF8, 0xCD4A, 0xD7EA, 0xA59B, 0xAD4B, 0xAA8C, 0xAE1F, 0xA2D3,
    0x90A7, 0x8F97, 0xA42F, 0xA8D4, 0xA79B, 0x9D76, 0x92C5, 0x99CB, 0x9578, 0x97F0, 0x9DB1, 0x9B52, 0x9CC3, 0x9ED1, 0xB42B, 0x9557,
    0xA398, 0xA19B, 0x9CC6, 0xB669, 0xB816, 0xCFA1, 0xC1DE, 0xDE3B, 0xC76E, 0xD02C, 0xE219, 0xC99A, 0xC601, 0xDFF1, 0xD3F7, 0xC394,
    0xBCE6, 0xBA8B, 0xBAB4, 0xA685, 0xC930, 0xBDFE, 0xB48E, 0xB8C9, 0xC60C, 0xD0BA, 0xC816, 0xCB7F, 0xCE43, 0xB0EB, 0xAAEA, 0xC689,
    0xC295, 0xAA3F, 0xBD7E, 0xC47B, 0xC923, 0xC932, 0xC499, 0xC70E, 0xC801, 0xDB9D, 0xE5FB, 0x1106, 0x150D, 0x1B6C, 0x1B6D, 0x2620,
    0x1158, 0x1E9C, 0x1D50, 0xFF93, 0xFBEB, 0xE3F0, 0xFBE3, 0xD763, 0xD238, 0xD2F0, 0xD28A, 0xF092, 0xED6E, 0xDE1D, 0xEAF4, 0x1E22,
    0x1173, 0x1C41, 0x396E, 0x2E85, 0x29C4, 0x245D, 0x25A7, 0x1C51, 0x2EC1, 0x2DC2, 0x450F, 0x370F, 0x348E, 0x3ECD, 0x4A3A, 0x611C,
    0x53A2, 0x76C5, 0x7ADD, 0x79BA, 0x7FFF, 0x7603, 0x7380, 0x7FEF, 0x6276, 0x61B5, 0x6677, 0x6E34, 0x5E4B, 0x486D, 0x2E5F, 0x45DD,
    0x36F3, 0x1BF4, 0x2853, 0x1BEB, 0x3D79, 0x2561, 0x4064, 0x4C58, 0x3883, 0x349E, 0x3F09, 0x28ED, 0x1D84, 0x10CD, 0x1FC3, 0x20D6,
    0x1A20, 0x3654, 0x127F, 0x2279, 0x3621, 0x10C7, 0x1C88, 0x3CF6, 0x44E9, 0x419B, 0x2C20, 0x4CD0, 0x3B5D, 0x3A3A, 0x3247, 0x256E,
    0x37E4, 0x1ADB, 0x1FCB, 0x2138, 0xFB84, 0x12EA, 0x0EEC, 0x0641, 0xFED5, 0xDD49, 0x05A8, 0x0940, 0xED27, 0xFF4C, 0x0458, 0xFA23,
    0x10FC, 0xF33D, 0xE875, 0xF54B, 0xE434, 0xECEF, 0x0CB8, 0xED0A, 0x01D2, 0x13CB, 0xE9A4, 0xF4FD, 0xF0EE, 0xF9BC, 0x2315, 0x2212,
    0x0279, 0x0B03, 0x1389, 0x20D4, 0xF59A, 0xDB44, 0xFBA1, 0xE00D, 0xD0B7, 0xCE3C, 0xCAB5, 0xB932, 0xA9C9, 0xAD68, 0xAF03, 0xBA31,
    0xA426, 0xA970, 0x9EEE, 0xBFDA, 0xB143, 0xAF9C, 0xBF9A, 0xA23E, 0xBE24, 0xA404, 0xAA40, 0x96EA, 0xA60C, 0xABEF, 0x9DBA, 0x9BC1,
    0xA460, 0xA40A, 0x8E7A, 0x9E45, 0xA019, 0xB0BB, 0xB61F, 0xBA6C, 0xADBD, 0xB7A7, 0xB269, 0xB034, 0xAE54, 0xA86C, 0x9CD7, 0x9F03,
    0x9F83, 0x9A60, 0x99BA, 0x914B, 0x958F, 0xA0FF, 0xA6C6, 0x93DB, 0xAA06, 0xA311, 0xB5D0, 0xBFB8, 0xBE4A, 0xB7E1, 0xBD8D, 0xB42B,
    0xBD2F, 0xB513, 0xB716, 0xC0D7, 0xB3C5, 0xD354, 0xB21C, 0xC4CE, 0xB5A5, 0xC1B2, 0xD097, 0xD2B2, 0xEFEA, 0xEFDC, 0xFD9F, 0xFCCE,
    0x006A, 0x0B79, 0xFCED, 0xF2AD, 0xF7F3, 0xF830, 0xF371, 0xF405, 0xEFF1, 0xDB6F, 0xF5AF, 0xED21, 0xF1D9, 0x027C, 0xFB24, 0x0880,
    0xF9E5, 0x0D84, 0x1F32, 0x1488, 0x1334, 0x0842, 0xF660, 0x05E1, 0x0269, 0xE524, 0x048C, 0x05C5, 0xFFF5, 0xF92A, 0x040E, 0xF4AC,
    0xF476, 0x12C1, 0x0331, 0x0FCF, 0x1CBE, 0x1F22, 0x2E7D, 0x1D27, 0x129F, 0x262E, 0x1916, 0x1D28, 0x1230, 0x2850, 0x0B41, 0x01FD,
    0x0718, 0x004E, 0x038D, 0xFD54, 0x06BA, 0xFA2F, 0x08E3, 0x0BBB, 0x239E, 0x28E8, 0x2790, 0x15BB, 0x19E1, 0x1CF3, 0x13DD, 0x2121,
    0x29EC, 0x1EF5, 0x38B7, 0x3F77, 0x2EC4, 0x42D8, 0x3246, 0x3F22, 0x570A, 0x51F4, 0x6B52, 0x6231, 0x67DE, 0x7359, 0x637F, 0x6DBB,
    0x6305, 0x6F91, 0x5BB7, 0x5B50, 0x5A63, 0x57F0, 0x3B7F, 0x3CD1, 0x34D8, 0x391F, 0x3D7A, 0x1B3C, 0x1B0E, 0x2912, 0x3089, 0x2904,
    0x4260, 0x2339, 0x2B26, 0x148A, 0x279B, 0x1679, 0x0572, 0x1961, 0x13BF, 0x2687, 0x142F, 0x142F, 0x128B, 0x1929, 0x1EFB, 0x30E2,
    0x40AE, 0x5AD8, 0x5773, 0x5A24, 0x5AB3, 0x5155, 0x5842, 0x5318, 0x4234, 0x3DC3, 0x4806, 0x3595, 0x1FB8, 0x1D07, 0x0B37, 0x11CF,
    0x1C44, 0x0683, 0x02A2, 0x073F, 0x1BA1, 0x15C2, 0x20D0, 0x2B29, 0x2137, 0x1670, 0x1E85, 0x1952, 0x0686, 0x08D9, 0x0C91, 0x0E6F,
    0x02BB, 0x160E, 0x1180, 0x0049, 0x0AF9, 0x20C8, 0x2BC6, 0x2F3D, 0x3958, 0x4638, 0x3552, 0x3707, 0x29B7, 0x1D34, 0x23EB, 0x102D,
    0xFBCD, 0xFD31, 0xFB51, 0xE649, 0xD924, 0xD1E8, 0xE7B6, 0xD474, 0xC5AA, 0xCC31, 0xCDE1, 0xCFA5, 0xDA5A, 0xDEA4, 0xD6C0, 0xD407,
    0xE625, 0xD42E, 0xCD8A, 0xE48F, 0xD88E, 0xDFC5, 0xF3EE, 0xF525, 0xE4B9, 0xE523, 0xEEBB, 0xEC53, 0xF49C, 0x0EAE, 0x0B4E, 0x15DC,
    0x1DE7, 0x14B2, 0x1070, 0x075D, 0x0CCB, 0x105C, 0xF769, 0x0186, 0xFAF3, 0xE691, 0xE370, 0xDF91, 0xD799, 0xD5B6, 0xD60E, 0xCD05,
    0xCC14, 0xBDE1, 0xDB87, 0xD7C1, 0xD158, 0xD2E1, 0xCC19, 0xCAB6, 0xC62D, 0xC73E, 0xBAFA, 0xBC84, 0xC976, 0xBECC, 0xBE7D, 0xBF43,
    0xBB3F, 0xB8DE, 0xAB20, 0xBA60, 0xCAA5, 0xCB8E, 0xC379, 0xCE98, 0xC4B2, 0xC968, 0xC724, 0xC16C, 0xB61B, 0xB810, 0xBCFC, 0xA9B9,
    0xA624, 0xA195, 0xA95A, 0x9CF9, 0xA1DA, 0xA07B, 0xA7AE, 0xA81F, 0xA87C, 0xC080, 0xB8A6, 0xC2ED, 0xC5D6, 0xB4F6, 0xC1B6, 0xB84D,
    0xBC3B, 0xBAD2, 0xC146, 0xC88E, 0xC4D4, 0xCB0D, 0xC120, 0xC6EC, 0xB5D8, 0xCC5B, 0xDC4C, 0xDBB8, 0xE444, 0xEABC, 0xEB05, 0xE404,
    0xEE84, 0xE0FA, 0xDBB1, 0xD4C6, 0xCA2F, 0xC65E, 0xBA37, 0xACA3, 0xB05E, 0xAF54, 0xB41F, 0xB9D0, 0xB128, 0xB962, 0xBB88, 0xC7B3,
    0xCC09, 0xD345, 0xD375, 0xCC86, 0xCF1F, 0xCCDA, 0xC2E8, 0xB707, 0xCA03, 0xC720, 0xC869, 0xCC22, 0xD238, 0xCFB4, 0xC541, 0xCDD7,
    0xD9B0, 0xDE66, 0xECBC, 0xFA4A, 0xEDB9, 0xF7FC, 0xF08C, 0xFA3E, 0xF24A, 0xE46A, 0xF733, 0xF3B7, 0xEF5E, 0xEB72, 0xE772, 0xE9CA,
    0xEB1B, 0xEDC5, 0xE858, 0xE81E, 0xEFBE, 0xF522, 0xF9D1, 0x02BE, 0x0A4C, 0xFE33, 0xFC06, 0xFA02, 0xF7A7, 0xEC76, 0xF271, 0xF417,
    0xF64D, 0x01DF, 0x0621, 0x0909, 0x0023, 0x0895, 0x1380, 0x1C07, 0x2CCF, 0x37A7, 0x3C55, 0x3FAF, 0x4386, 0x48AA, 0x48B8, 0x4180,
    0x41E8, 0x41DC, 0x381B, 0x3BE3, 0x3545, 0x2F8B, 0x36C6, 0x2E23, 0x373C, 0x3219, 0x2A9E, 0x3280, 0x280A, 0x3E14, 0x4451, 0x3C66,
    0x3E19, 0x3B8E, 0x2A24, 0x29C7, 0x2804, 0x230B, 0x2465, 0x23C9, 0x2943, 0x295C, 0x23FD, 0x1FEF, 0x2918, 0x3295, 0x4965, 0x500F,
    0x5E04, 0x64CC, 0x6A5E, 0x64B0, 0x630A, 0x62FA, 0x5ED7, 0x568E, 0x549C, 0x5608, 0x4099, 0x3917, 0x3C6E, 0x2994, 0x27C0, 0x25BF,
    0x1412, 0x1FA2, 0x19D7, 0x2A46, 0x2D0F, 0x3420, 0x3ADC, 0x3B40, 0x357D, 0x3809, 0x35C0, 0x2ACB, 0x2E40, 0x2FF1, 0x3E81, 0x3760,
    0x3DA1, 0x31CE, 0x359D, 0x4354, 0x4909, 0x558C, 0x5C57, 0x66B9, 0x66FC, 0x66A4, 0x6795, 0x64B4, 0x5CE5, 0x4F3D, 0x49D0, 0x4F58,
    0x3F0A, 0x3470, 0x2BAF, 0x28AD, 0x282D, 0x1F00, 0x2019, 0x18F0, 0x193D, 0x1721, 0x22EA, 0x26B4, 0x2412, 0x217E, 0x17D3, 0x11E2,
    0x0614, 0x0C91, 0x03E1, 0x0BD1, 0x110E, 0x14A8, 0x1B11, 0x1020, 0x1181, 0x133E, 0x1A75, 0x21CA, 0x2EDE, 0x3272, 0x3685, 0x36DE,
    0x33E7, 0x2EEE, 0x26B8, 0x233F, 0x17BD, 0x10C8, 0x0DC8, 0xFE45, 0xF1E4, 0xF606, 0xED97, 0xED8F, 0xF046, 0xECEF, 0xE73D, 0xEAB5,
    0xF5D3, 0xFA0C, 0x01C2, 0x0438, 0x05AE, 0xFE61, 0xF905, 0xF068, 0xF2B6, 0xF387, 0xF5CD, 0xFC0C, 0xFC23, 0xFF81, 0xF987, 0xF265,
    0xF07C, 0xFF0B, 0x065D, 0x0EA1, 0x188B, 0x1685, 0x1639, 0x191C, 0x12DE, 0x0FDC, 0x0498, 0xFE61, 0xFACF, 0xF090, 0xE557, 0xD941,
    0xD342, 0xC811, 0xCBE8, 0xC95E, 0xC5EC, 0xC0F6, 0xCA6C, 0xD74C, 0xDB02, 0xDF4D, 0xE4BD, 0xE581, 0xE2BC, 0xE0A0, 0xD631, 0xD6CE,
    0xDD09, 0xE3D1, 0xE38B, 0xE507, 0xDEAC, 0xD8B1, 0xD714, 0xDDA6, 0xDF9F, 0xDDBB, 0xF69F, 0xFAD8, 0xF966, 0x058E, 0x0245, 0x0B69,
    0x0072, 0xF660, 0xFE0F, 0xF10D, 0xE207, 0xDAE9, 0xD359, 0xC8D2, 0xCF96, 0xC52A, 0xBFFE, 0xBA5A, 0xBA05, 0xC118, 0xC1DA, 0xCD83,
    0xCEFD, 0xCF2C, 0xCA44, 0xC46A, 0xBC16, 0xBE7D, 0xB5AA, 0xB4EA, 0xBD71, 0xC1B6, 0xBD99, 0xB47D, 0xB3DA, 0xB65A, 0xBE6C, 0xC427,
    0xD285, 0xD88C, 0xE110, 0xDEE6, 0xE03B, 0xE545, 0xDA27, 0xD05F, 0xD55A, 0xD579, 0xCECE, 0xCD20, 0xC67C, 0xC501, 0xC2B6, 0xC5C0,
    0xC8B5, 0xBF96, 0xBD7C, 0xC4DC, 0xC5F4, 0xD043, 0xD332, 0xD36E, 0xD1D1, 0xC9B0, 0xC3DE, 0xC139, 0xBA84, 0xB84D, 0xBFB8, 0xBCB5,
    0xC6E4, 0xC691, 0xC1CC, 0xC7F7, 0xCE8A, 0xD08B, 0xDC19, 0xE657, 0xF31F, 0xF752, 0xF7DB, 0x04CB, 0xF8D3, 0xF712, 0xF215, 0xF2B0,
    0xEDCA, 0xE4BA, 0xE24F, 0xD91D, 0xD375, 0xDC40, 0xD715, 0xCEF9, 0xCD3F, 0xC83A, 0xD451, 0xD674, 0xE297, 0xDEBD, 0xDFCE, 0xE2BF,
    0xDAD3, 0xD92E, 0xD523, 0xCFE8, 0xCFD6, 0xD3F1, 0xD9DF, 0xDB41, 0xCF21, 0xCCE8, 0xCB59, 0xCBD0, 0xDA18, 0xE5CC, 0xEE0B, 0xFC3C,
    0xFCAF, 0x03C7, 0x0B83, 0x0779, 0x048D, 0x07D1, 0x08E0, 0x06C4, 0xFF0A, 0xF31A, 0xF381, 0xEDFE, 0xEE4C, 0xEA94, 0xDE0C, 0xDEF7,
    0xD6CC, 0xDEA2, 0xE504, 0xEA1C, 0xF548, 0xEF70, 0xFAD8, 0xF6D9, 0xF27A, 0xF12B, 0xF031, 0xF486, 0xFA74, 0xFFDA, 0x026B, 0xFCD0,
    0xFCCA, 0x0366, 0xFB4D, 0x10EC, 0x22F6, 0x23C1, 0x31CC, 0x3664, 0x3FC0, 0x3E56, 0x3964, 0x3D7D, 0x2EA5, 0x32C4, 0x2F94, 0x22BF,
    0x194B, 0x1E4F, 0x11D1, 0x14F1, 0x1249, 0x0CC7, 0x0FDC, 0x0CBF, 0x1DB6, 0x1A77, 0x22C4, 0x20ED, 0x23AE, 0x1071, 0x0991, 0x0593,
    0x0023, 0xFED3, 0xFCFA, 0x0A53, 0x0C6C, 0x0CF0, 0x0D8F, 0x0D62, 0x166E, 0x24DA, 0x2F9D, 0x3E17, 0x4261, 0x4DC0, 0x53C0, 0x519D,
    0x4795, 0x45F8, 0x40A8, 0x3AF7, 0x33A2, 0x2727, 0x1A4C, 0x1907, 0x14C3, 0x1456, 0x1777, 0x15E6, 0x1177, 0x1471, 0x218D, 0x2A23,
    0x3347, 0x3516, 0x3EE5, 0x3840, 0x3DBD, 0x3734, 0x31E8, 0x2993, 0x3148, 0x3DF5, 0x3D78, 0x41F8, 0x3FD0, 0x3EF7, 0x3946, 0x4276,
    0x4AFB, 0x599B, 0x599E, 0x5EFA, 0x6457, 0x61CF, 0x6646, 0x5C2E, 0x5242, 0x52E2, 0x511D, 0x4C28, 0x40F4, 0x39F9, 0x2C0E, 0x25EE,
    0x253A, 0x1CA9, 0x1076, 0x0B95, 0x09EA, 0x0D8B, 0x180B, 0x180D, 0x224A, 0x1DCC, 0x1E18, 0x169F, 0x1743, 0x123D, 0x0EDD, 0x1589,
    0x1A75, 0x261A, 0x22C1, 0x26EF, 0x26FB, 0x2894, 0x3034, 0x3BB8, 0x46BB, 0x4F2B, 0x5218, 0x5902, 0x5C00, 0x5E99, 0x5639, 0x5AE2,
    0x5C63, 0x53A5, 0x500A, 0x45E8, 0x4425, 0x399A, 0x3A6F, 0x2F99, 0x26E8, 0x1FE3, 0x1BCB, 0x1B6D, 0x1FFC, 0x28A7, 0x263D, 0x2F6E,
    0x2DFF, 0x2C5C, 0x2481, 0x187D, 0x1601, 0x1235, 0x13B5, 0x1BF7, 0x17CA, 0x0FC1, 0x0B41, 0x0E93, 0x1082, 0x1829, 0x25C8, 0x2885,
    0x34C8, 0x376E, 0x3F84, 0x36C9, 0x2FDE, 0x2A98, 0x1E7E, 0x1CBF, 0x1301, 0x0605, 0xFA36, 0xF26B, 0xE87F, 0xEC63, 0xE72B, 0xE6A2,
    0xE09A, 0xE5DA, 0xF109, 0xF8A5, 0x0658, 0x0A7A, 0x133F, 0x1039, 0x0EA5, 0x0816, 0xFF6B, 0xFB0D, 0xF96F, 0xFE5D, 0xFF6D, 0x008F,
    0x02C5, 0xFE64, 0x00D3, 0x0413, 0x0E47, 0x1AED, 0x1F11, 0x2D9B, 0x2FB1, 0x34E5, 0x30DD, 0x2CC4, 0x25F5, 0x1E5D, 0x1BE6, 0x0B5C,
    0x048B, 0xF528, 0xF022, 0xE8A2, 0xE5E2, 0xDF02, 0xD59E, 0xD3A8, 0xD3C6, 0xD922, 0xDAAA, 0xE483, 0xE099, 0xE0FB, 0xDE29, 0xD6EC,
    0xD24C, 0xCC2E, 0xCA20, 0xC97E, 0xD08E, 0xCD09, 0xC6E5, 0xC13B, 0xB9DF, 0xB9B9, 0xBB1A, 0xC11C, 0xC890, 0xCAED, 0xD456, 0xDE7D,
    0xE00B, 0xDF65, 0xDFA2, 0xE2F4, 0xDFBD, 0xE3EE, 0xE0BE, 0xD9C7, 0xD559, 0xD613, 0xD5CC, 0xD3C8, 0xD23F, 0xC973, 0xCA6F, 0xC7B4,
    0xCC87, 0xCF6D, 0xD3C6, 0xD912, 0xD5AB, 0xD609, 0xD1BD, 0xCB37, 0xC955, 0xC987, 0xCFE6, 0xD2B3, 0xD255, 0xD0BD, 0xCC0D, 0xC57C,
    0xC4D3, 0xCBF7, 0xCDF3, 0xD1B4, 0xDB32, 0xE0B9, 0xE48D, 0xE59C, 0xDF47, 0xDEED, 0xDAA6, 0xDA50, 0xD630, 0xC9C1, 0xC1F8, 0xBBEE,
    0xB85E, 0xB53A, 0xB300, 0xACA8, 0xAC0E, 0xB23A, 0xB561, 0xBBBE, 0xC1B1, 0xC4B8, 0xC940, 0xC73D, 0xC5A2, 0xBEDD, 0xB960, 0xB436,
    0xB4C6, 0xB97A, 0xB761, 0xBA66, 0xB2D1, 0xB3DA, 0xB589, 0xB8DB, 0xC3DD, 0xCC26, 0xD761, 0xE1FA, 0xF02A, 0xF72E, 0xF948, 0xFA24,
    0xF9CB, 0xF71B, 0xF3F6, 0xED0B, 0xDE0A, 0xD457, 0xD0FA, 0xCE38, 0xCB7D, 0xC79C, 0xC44C, 0xC22E, 0xC678, 0xCC82, 0xD46E, 0xDB6A,
    0xE2D4, 0xE360, 0xE1EE, 0xE0A1, 0xD537, 0xD1BF, 0xCD44, 0xD436, 0xD3F7, 0xD530, 0xD565, 0xD038, 0xD1DA, 0xD2C9, 0xDFC5, 0xE513,
    0xF3CF, 0xFD75, 0x05A8, 0x0ED7, 0x0E39, 0x0BAE, 0x0C9D, 0x0C49, 0x116B, 0x0F0F, 0x09A3, 0x043B, 0xF9C5, 0xFFD1, 0xF648, 0xF138,
    0xE54E, 0xDDE9, 0xDC7F, 0xD601, 0xDBFF, 0xDAD6, 0xDE77, 0xE268, 0xDEC5, 0xE0B7, 0xD90F, 0xD1CD, 0xCEE1, 0xD0FE, 0xD8D1, 0xDC9C,
    0xE760, 0xE595, 0xE818, 0xEC4E, 0xF253, 0xFD47, 0x0568, 0x0D5D, 0x167D, 0x1FD6, 0x251E, 0x251C, 0x240B, 0x21BB, 0x201B, 0x2353,
    0x1B36, 0x17D3, 0x0DD5, 0x09BB, 0x066C, 0x0323, 0xFE63, 0xF2DC, 0xF04C, 0xEAC1, 0xF0C8, 0xF68D, 0xFBF4, 0xFF2B, 0x0354, 0x066C,
    0x0300, 0x00FF, 0xFD71, 0xFE01, 0x07D2, 0x0B59, 0x12E0, 0x14C7, 0x0E58, 0x0D78, 0x0C7E, 0x1757, 0x20BB, 0x2E0F, 0x36E9, 0x4336,
    0x4CE8, 0x4D73, 0x4E4D, 0x4B11, 0x4368, 0x3FB4, 0x3892, 0x280C, 0x17F9, 0x0A22, 0x00A9, 0xFA9C, 0xF59A, 0xEAEE, 0xE62E, 0xE1D2,
    0xE3F6, 0xE994, 0xF484, 0xFC5E, 0x079A, 0x10DF, 0x155C, 0x146D, 0x0BC1, 0x08AF, 0x0726, 0x08F0, 0x0B3C, 0x0F50, 0x0C54, 0x0CC3,
    0x070C, 0x0D99, 0x168D, 0x206E, 0x2EB6, 0x3BE7, 0x4CA8, 0x52AF, 0x56B6, 0x5535, 0x535F, 0x5139, 0x517A, 0x4A81, 0x423A, 0x37FB,
    0x3000, 0x2EB4, 0x2AFB, 0x2602, 0x208E, 0x2183, 0x2186, 0x290E, 0x3028, 0x398D, 0x3F7D, 0x421D, 0x45A7, 0x434D, 0x3E12, 0x35C8,
    0x3333, 0x32E2, 0x35F8, 0x38B9, 0x3B11, 0x3398, 0x2C87, 0x29E3, 0x2943, 0x2DAA, 0x2E46, 0x2EF7, 0x3418, 0x37E9, 0x37B4, 0x3352,
    0x320E, 0x2B37, 0x29F7, 0x2696, 0x1BB9, 0x16CC, 0x0CC6, 0x0A60, 0x0CDF, 0x107B, 0x0FCF, 0x10CD, 0x0E8E, 0x1330, 0x18CD, 0x2268,
    0x29FF, 0x2EF9, 0x3285, 0x34F5, 0x3136, 0x2A27, 0x25F8, 0x2003, 0x287E, 0x2AF3, 0x3429, 0x3484, 0x31D7, 0x305C, 0x2F99, 0x34D1,
    0x3C5C, 0x4258, 0x49EA, 0x5312, 0x56FB, 0x5790, 0x55C7, 0x529A, 0x5286, 0x5269, 0x5014, 0x4B6A, 0x40B4, 0x3A43, 0x33EC, 0x304E,
    0x2805, 0x219B, 0x177D, 0x14C7, 0x1352, 0x17D3, 0x1AED, 0x1F3C, 0x2509, 0x24BE, 0x2787, 0x1CF7, 0x13DF, 0x062D, 0x004D, 0xFA09,
    0xF775, 0xF728, 0xED74, 0xE6F0, 0xE26A, 0xE50D, 0xE91A, 0xEE2A, 0xF681, 0x039D, 0x1419, 0x1FDB, 0x2880, 0x2E52, 0x3454, 0x3916,
    0x3C93, 0x3C0B, 0x32CC, 0x2946, 0x217C, 0x1D2E, 0x1695, 0x0DA7, 0x02E0, 0xFC42, 0xF927, 0xFBAF, 0x043A, 0x0B8F, 0x13AC, 0x17F2,
    0x1D9A, 0x1E43, 0x1685, 0x0DC0, 0x08C1, 0x05FF, 0x069F, 0x0A4C, 0x06BB, 0x02EF, 0xFADA, 0xF739, 0xFD27, 0x0242, 0x0B34, 0x153B,
    0x214F, 0x28D9, 0x2D2D, 0x2BA6, 0x2834, 0x2437, 0x1FC5, 0x1C41, 0x133D, 0x07AD, 0xFC49, 0xF573, 0xEFC8, 0xEA72, 0xE2F0, 0xDD61,
    0xD481, 0xD072, 0xD050, 0xCFAD, 0xD2A5, 0xD2CB, 0xD6D6, 0xD66D, 0xD0CA, 0xC97E, 0xC0DD, 0xBDCC, 0xBC48, 0xC08D, 0xC4DD, 0xC69A,
    0xC661, 0xC59E, 0xCAC0, 0xD24C, 0xDA5B, 0xE5E7, 0xF410, 0x029E, 0x1040, 0x12EB, 0x1429, 0x1116, 0x1025, 0x0FAF, 0x0A9E, 0x0328,
    0xF97D, 0xF1BC, 0xEEF1, 0xED2C, 0xE7F8, 0xE24A, 0xDA94, 0xD9C7, 0xD8DF, 0xDAB7, 0xDD95, 0xDFBB, 0xE256, 0xE349, 0xE346, 0xDC5F,
    0xD664, 0xD105, 0xCCBB, 0xCFE1, 0xD385, 0xD3E9, 0xD0AC, 0xCB76, 0xC936, 0xCC2C, 0xCEA9, 0xD505, 0xDA9F, 0xE5BA, 0xF0B8, 0xF7A6,
    0xFF23, 0xFD5B, 0xFFC3, 0xFC6E, 0xFA91, 0xF177, 0xDECA, 0xD147, 0xC82E, 0xC5DC, 0xC05D, 0xBBFD, 0xB56F, 0xAF66, 0xAC8A, 0xAD8B,
    0xAFFD, 0xB4AE, 0xBC7E, 0xC2BD, 0xCCAB, 0xCE27, 0xCDC7, 0xCC6C, 0xCA5F, 0xCD47, 0xD1DC, 0xD729, 0xD819, 0xD394, 0xCE4F, 0xCB7E,
    0xCD0F, 0xD022, 0xD39E, 0xDE97, 0xE8C5, 0xF47C, 0xF9BA, 0xFEF8, 0xFF44, 0xFE4B, 0xFFB3, 0xFF2C, 0xF94C, 0xEB7F, 0xE39C, 0xDA22,
    0xD40D, 0xCE3F, 0xC8B6, 0xC4C7, 0xC013, 0xC137, 0xC7CD, 0xCA69, 0xD2E2, 0xD94C, 0xE077, 0xE510, 0xE323, 0xE198, 0xDA40, 0xD8B0,
    0xD75B, 0xDAF6, 0xDF34, 0xE126, 0xDEE9, 0xDB94, 0xDD3A, 0xDCC7, 0xE136, 0xE529, 0xEA66, 0xF205, 0xF765, 0xFACC, 0xF743, 0xF445,
    0xF1A5, 0xED3C, 0xE7D7, 0xDE68, 0xD3E4, 0xCCA3, 0xC8DD, 0xC737, 0xC4CA, 0xC1AA, 0xBF94, 0xC01D, 0xC46F, 0xCAE9, 0xD291, 0xD9BC,
    0xE187, 0xE6F9, 0xE892, 0xE2B3, 0xD888, 0xD1E4, 0xCE8B, 0xD28D, 0xD580, 0xDA24, 0xD9F0, 0xD845, 0xDA66, 0xDCEA, 0xE725, 0xEE70,
    0xF7EF, 0x04FB, 0x10B6, 0x1774, 0x19E8, 0x17AA, 0x178B, 0x167D, 0x1725, 0x1494, 0x0BE7, 0x01D2, 0xF912, 0xF3D7, 0xEE06, 0xEA23,
    0xE286, 0xDDAC, 0xD9F8, 0xDB41, 0xDED4, 0xE66C, 0xEC94, 0xF683, 0xFE0C, 0x021D, 0x00CE, 0xF79C, 0xF405, 0xEF6C, 0xEF7B, 0xF29D,
    0xF369, 0xEE58, 0xE820, 0xE475, 0xE1E3, 0xDFBF, 0xE3C5, 0xE887, 0xF1AF, 0xFB25, 0x02A3, 0x0795, 0x08E1, 0x0D38, 0x10D5, 0x150B,
    0x141C, 0x0ECB, 0x0A61, 0x08D8, 0x0486, 0x016A, 0xFC46, 0xF6D6, 0xF340, 0xF05E, 0xF406, 0xF981, 0xFFBF, 0x0960, 0x1538, 0x1B0F,
    0x1EAE, 0x1D9F, 0x1A0E, 0x1927, 0x18D8, 0x1DAD, 0x2097, 0x1D2C, 0x16BD, 0x12E1, 0x1139, 0x11CD, 0x1659, 0x1E84, 0x29E1, 0x36E7,
    0x40F2, 0x46C2, 0x49AB, 0x489B, 0x4818, 0x49F4, 0x47A0, 0x3F39, 0x3687, 0x2DDF, 0x29CA, 0x26BF, 0x2519, 0x2144, 0x1878, 0x117C,
    0x0C52, 0x0AB0, 0x0A22, 0x0BB9, 0x1035, 0x1430, 0x1456, 0x0D02, 0x02A1, 0xF74F, 0xEC10, 0xE818, 0xE869, 0xEAE1, 0xE815, 0xE4C1,
    0xE48D, 0xE864, 0xEFAF, 0xF844, 0x06A0, 0x1756, 0x2A6B, 0x39A1, 0x445B, 0x48A1, 0x4B88, 0x5093, 0x51EA, 0x5221, 0x4BFD, 0x438F,
    0x3E14, 0x3836, 0x34ED, 0x2FDE, 0x2AF6, 0x24E7, 0x2277, 0x2306, 0x2559, 0x29FC, 0x2DCE, 0x33D6, 0x36BC, 0x360B, 0x2EE2, 0x27F0,
    0x1F99, 0x1ABC, 0x1BCF, 0x1D9B, 0x1E83, 0x1BEF, 0x1805, 0x1467, 0x13F4, 0x15BE, 0x19D6, 0x2157, 0x2BCD, 0x363B, 0x402A, 0x444B,
    0x45AF, 0x46A1, 0x4679, 0x4613, 0x3F6B, 0x3685, 0x2C4D, 0x22C0, 0x1B1F, 0x1182, 0x0A36, 0xFED6, 0xF33F, 0xED19, 0xE7D7, 0xE88E,
    0xEB07, 0xF06C, 0xF9BA, 0x00B1, 0x059F, 0x0831, 0x07B6, 0x05D4, 0x05DD, 0x0BA0, 0x121A, 0x1588, 0x14C5, 0x1129, 0x1187, 0x116B,
    0x1359, 0x193D, 0x21DF, 0x2DA6, 0x3802, 0x3E9F, 0x4293, 0x4408, 0x47D8, 0x4D8A, 0x4FC4, 0x4CC7, 0x4521, 0x3D4A, 0x34EA, 0x2DEE,
    0x2701, 0x1E05, 0x14BE, 0x0F11, 0x0C6D, 0x0DC5, 0x11F7, 0x175C, 0x20EC, 0x29A0, 0x2F2D, 0x3149, 0x2CBE, 0x2336, 0x1B93, 0x18C8,
    0x1A7E, 0x1CB2, 0x1C4F, 0x1B37, 0x1A1D, 0x170A, 0x16D9, 0x1874, 0x1B12, 0x2248, 0x2B2E, 0x333F, 0x37B3, 0x3907, 0x356D, 0x3396,
    0x33C6, 0x2D7F, 0x245B, 0x18E9, 0x0CAC, 0x0412, 0xFBD4, 0xF57C, 0xF07E, 0xE9FD, 0xE871, 0xEA45, 0xEFB3, 0xF671, 0xFE43, 0x089F,
    0x11C8, 0x179D, 0x177A, 0x14C5, 0x0C49, 0x05A8, 0x02BD, 0x0376, 0x0600, 0x0229, 0xFD2A, 0xF8F0, 0xF7B8, 0xF927, 0xFDE7, 0x05F0,
    0x118A, 0x1D0A, 0x285A, 0x2FAB, 0x2FB1, 0x3023, 0x32D9, 0x3322, 0x313F, 0x2BB2, 0x2279, 0x1BFE, 0x1791, 0x13A8, 0x0EBE, 0x07D3,
    0xFEF0, 0xF974, 0xF50B, 0xF302, 0xF655, 0xFC3C, 0x0528, 0x0EA1, 0x119C, 0x110E, 0x0C62, 0x02F6, 0xFCBD, 0xFB6B, 0xFCD6, 0xFA61,
    0xF58E, 0xEEF1, 0xE7E4, 0xE10B, 0xDDD9, 0xDB83, 0xDF41, 0xE6A6, 0xEDBB, 0xF57A, 0xF57C, 0xF51C, 0xF6DB, 0xFCCC, 0x02D0, 0x05E6,
    0x01E7, 0xFA59, 0xF4E0, 0xEE80, 0xE7C2, 0xE02D, 0xD734, 0xCE0B, 0xC9E0, 0xC5F1, 0xC455, 0xC43E, 0xC651, 0xCBA1, 0xCFE9, 0xD2F3,
    0xD395, 0xD190, 0xCC8F, 0xCC32, 0xD04F, 0xD3EC, 0xD60A, 0xD4CE, 0xD35B, 0xD227, 0xD31E, 0xD511, 0xD93D, 0xE3F8, 0xF130, 0x00B6,
    0x0D70, 0x142B, 0x17B2, 0x1A1E, 0x1C46, 0x1A6F, 0x15D4, 0x0BFC, 0x016F, 0xFA41, 0xF27E, 0xEC4E, 0xE4B8, 0xDB9E, 0xD3F5, 0xCF61,
    0xCC61, 0xCA92, 0xCCD0, 0xD11E, 0xD4B4, 0xD709, 0xD6D9, 0xD170, 0xC78D, 0xBDAF, 0xB8CE, 0xB776, 0xB66F, 0xB2D1, 0xAEC4, 0xAB8E,
    0xA951, 0xAA7F, 0xAE47, 0xB3AB, 0xBCFD, 0xC926, 0xD4DE, 0xDD9C, 0xE193, 0xE610, 0xE9AA, 0xEE0E, 0xF09C, 0xED86, 0xE72B, 0xE014,
    0xD8E1, 0xD3AD, 0xD186, 0xCD80, 0xCB3A, 0xCA81, 0xCB48, 0xCD05, 0xD0B1, 0xD808, 0xE087, 0xE8E7, 0xF087, 0xF610, 0xF441, 0xED3C,
    0xE7A5, 0xE663, 0xE86C, 0xEB35, 0xEC89, 0xEA9B, 0xE778, 0xE2B0, 0xDEC9, 0xDCF5, 0xDDA2, 0xE398, 0xECE6, 0xF702, 0xFDD3, 0x014B,
    0x02F2, 0x0656, 0x0894, 0x0593, 0x0113, 0xFA2E, 0xF1AE, 0xE9A7, 0xE294, 0xDC1C, 0xD247, 0xC73E, 0xBFE1, 0xBAA4, 0xB63A, 0xB3E2,
    0xB437, 0xB6D4, 0xB836, 0xB913, 0xB957, 0xB5D4, 0xB1D1, 0xB101, 0xB51D, 0xBAA6, 0xBE12, 0xC05C, 0xC130, 0xC0FF, 0xC296, 0xC5D8,
    0xC945, 0xD066, 0xDB3D, 0xE7FF, 0xF416, 0xFBD6, 0x0192, 0x0678, 0x0F0A, 0x1653, 0x19D4, 0x198D, 0x1355, 0x0DCC, 0x0964, 0x0590,
    0xFF32, 0xF884, 0xF177, 0xEB4A, 0xE78A, 0xE74B, 0xEAAB, 0xF066, 0xF825, 0xFF30, 0x072B, 0x0734, 0xFFA8, 0xF6C7, 0xEF63, 0xEE02,
    0xED5D, 0xECE6, 0xEB8C, 0xE6CE, 0xE31B, 0xE1D7, 0xE1FB, 0xE3BC, 0xE9BE, 0xF24A, 0xFCCE, 0x03F8, 0x0646, 0x07A8, 0x0650, 0x07C4,
    0x06EA, 0x02ED, 0xFA85, 0xEE99, 0xE4CB, 0xDB54, 0xD2CF, 0xCBBC, 0xC624, 0xC1C5, 0xC1A9, 0xC2E7, 0xC557, 0xCB27, 0xD4D0, 0xDF81,
    0xEB55, 0xF459, 0xF6F8, 0xF606, 0xF2F7, 0xF182, 0xF1C1, 0xF4A9, 0xF435, 0xF2F2, 0xF249, 0xF0E0, 0xF3EB, 0xF91E, 0x01D0, 0x0CA6,
    0x1B11, 0x2B85, 0x365F, 0x3D9B, 0x422E, 0x46B6, 0x4ACE, 0x4B48, 0x4953, 0x43A6, 0x3D6D, 0x383C, 0x3474, 0x2E32, 0x255C, 0x1C24,
    0x121E, 0x0A48, 0x022F, 0x0029, 0x0245, 0x07DE, 0x0DA8, 0x13F6, 0x1802, 0x144A, 0x0ED7, 0x07F8, 0x0640, 0x07DF, 0x0B4B, 0x0BCA,
    0x0A07, 0x0764, 0x0398, 0x029B, 0x02C8, 0x0667, 0x0DB9, 0x1854, 0x2176, 0x26D1, 0x2923, 0x2AC1, 0x2F2F, 0x3551, 0x3956, 0x393D,
    0x36AC, 0x31CE, 0x2E31, 0x2C31, 0x2850, 0x22E2, 0x1D1C, 0x1772, 0x1133, 0x0D0A, 0x0C15, 0x0D51, 0x1126, 0x1706, 0x1CDE, 0x1F5C,
    0x1D91, 0x18D5, 0x164E, 0x1805, 0x1B0B, 0x1F36, 0x1F8D, 0x1BFB, 0x1871, 0x13FE, 0x1183, 0x11BC, 0x1675, 0x20CE, 0x2E29, 0x3B04,
    0x43B5, 0x4917, 0x4C6B, 0x4E12, 0x4ED9, 0x4C74, 0x4814, 0x409B, 0x37DB, 0x31A4, 0x2A32, 0x2309, 0x1B6B, 0x153E, 0x110B, 0x0E37,
    0x0E30, 0x11FC, 0x17CC, 0x1E61, 0x2633, 0x2C1F, 0x2D6E, 0x29A1, 0x2429, 0x1ED7, 0x1A71, 0x1694, 0x11D6, 0x0A05, 0x0138, 0xF9F8,
    0xF4DC, 0xF2CC, 0xF360, 0xF82C, 0x02D7, 0x0FF0, 0x1A44, 0x212B, 0x2867, 0x2F3A, 0x3461, 0x398F, 0x39DC, 0x34CE, 0x2CF5, 0x2432,
    0x1CE1, 0x15B6, 0x0F0D, 0x0893, 0x02ED, 0xFE20, 0xFA48, 0xFB9D, 0xFF5E, 0x0575, 0x0DC2, 0x146C, 0x18D4, 0x189F, 0x13D2, 0x0E0B,
    0x0C74, 0x0D1C, 0x1057, 0x1283, 0x114F, 0x0FB5, 0x0C6F, 0x09BE, 0x0780, 0x08BC, 0x0E07, 0x1820, 0x219E, 0x28C0, 0x2EE0, 0x3250,
    0x36A2, 0x39A9, 0x3C52, 0x3B44, 0x372D, 0x31C7, 0x2B3A, 0x259E, 0x1E7E, 0x18F8, 0x1344, 0x0E1E, 0x0838, 0x029A, 0x007A, 0xFED7,
    0xFF42, 0x0051, 0x011E, 0xFFD2, 0xFA87, 0xF384, 0xED81, 0xEA24, 0xE887, 0xE892, 0xE941, 0xE889, 0xE759, 0xE63D, 0xE435, 0xE49D,
    0xE9BB, 0xF12B, 0xF9F8, 0x00BC, 0x05D9, 0x0A6C, 0x0EB1, 0x134F, 0x17CC, 0x1BA4, 0x1BB3, 0x1B0A, 0x1AF1, 0x1A69, 0x1859, 0x1350,
    0x0D8B, 0x06CF, 0xFFD0, 0xFA84, 0xF7C0, 0xFA1E, 0xFEEB, 0x081A, 0x11D9, 0x17DF, 0x18EF, 0x1594, 0x120C, 0x0DC8, 0x0C7A, 0x0B49,
    0x0C43, 0x04ED, 0xFDF9, 0xFC53, 0xFA9D, 0xFFA4, 0x0939, 0x1016, 0x1234, 0x1A61, 0x20CC, 0x263C, 0x2A53, 0x2D72, 0x300A, 0x2FE5,
    0x2C84, 0x258E, 0x1C66, 0x0E36, 0xFFE4, 0xEFBF, 0xE123, 0xD312, 0xC98E, 0xBEA7, 0xB42A, 0xB7ED, 0xBC7A, 0xC23B, 0xC43D, 0xC55A,
    0xC5AE, 0xC3E5, 0xC4AD, 0xC36C, 0xC835, 0xC800, 0xC555, 0xC477, 0xC57D, 0xC816, 0xCF09, 0xD802, 0xDC54, 0xE57F, 0xF292, 0x01E1,
    0x0EF7, 0x1C7B, 0x21B9, 0x2484, 0x2AC0, 0x2D88, 0x2E9F, 0x2BE9, 0x27C4, 0x254F, 0x1C4C, 0x0BA2, 0x079B, 0x02EE, 0xF422, 0xEFA4,
    0xF299, 0xF82A, 0xFDB3, 0x00AA, 0x0114, 0xFCDE, 0xFA87, 0xF43A, 0xF4B4, 0xF401, 0xEEAC, 0xEB53, 0xE84E, 0xE970, 0xEC1A, 0xF530,
    0xF79D, 0xF857, 0xFC0A, 0x0144, 0x070D, 0x0D39, 0x0DD5, 0x0695, 0x0201, 0xFD98, 0xF848, 0xF237, 0xE7CC, 0xE13B, 0xDBF5, 0xCB77,
    0xC1B4, 0xC1BC, 0xB912, 0xB400, 0xB745, 0xBDB3, 0xC79F, 0xCDC4, 0xD391, 0xD3B3, 0xD5C9, 0xD388, 0xD343, 0xD651, 0xD33D, 0xD061,
    0xCD5F, 0xCE53, 0xD0AD, 0xDD19, 0xEA16, 0xF2AD, 0xFA6B, 0x02C8, 0x090E, 0x1183, 0x1A66, 0x1DD6, 0x219D, 0x2873, 0x2ED9, 0x3365,
    0x33D3, 0x2FD9, 0x30A2, 0x27A1, 0x17D1, 0x1498, 0x0DA8, 0xFE62, 0xF46D, 0xF057, 0xF2B8, 0xF66A, 0xFBA5, 0xFBB7, 0xFB75, 0xF842,
    0xF408, 0xF5D9, 0xF58C, 0xF200, 0xED9D, 0xEBB7, 0xE808, 0xEAE6, 0xF340, 0xF835, 0xF8BD, 0xFB51, 0xFCBD, 0xFE2F, 0x0162, 0xFFC5,
    0xFBD6, 0xFB0C, 0xFC72, 0xFFD7, 0x01B6, 0xFDC4, 0x007B, 0xFF87, 0xF136, 0xE9E2, 0xE7FF, 0xE059, 0xD84E, 0xD409, 0xD5C1, 0xD8F2,
    0xDF2F, 0xE0E1, 0xE1FB, 0xE1C8, 0xDE73, 0xE02E, 0xE573, 0xEA4E, 0xEB9A, 0xEEC5, 0xEE4A, 0xEF71, 0xF6D5, 0xFF76, 0x03D7, 0x0934,
    0x0FA1, 0x1655, 0x201E, 0x27C2, 0x2941, 0x27A0, 0x2804, 0x2A1F, 0x2EB3, 0x2C2B, 0x28FA, 0x2A50, 0x1C3C, 0x0A4A, 0x0082, 0xF587,
    0xE96D, 0xDE0B, 0xDC51, 0xDE15, 0xE3CB, 0xE74E, 0xE888, 0xE9A9, 0xE7D1, 0xE72B, 0xEA2E, 0xEEA2, 0xED12, 0xED9F, 0xEBDB, 0xE6E9,
    0xE6D4, 0xED2D, 0xEFBF, 0xF080, 0xF226, 0xF202, 0xF505, 0xFC9C, 0x0101, 0x02B7, 0x0537, 0x0655, 0x0C9C, 0x0FBD, 0x0D7C, 0x1363,
    0x1437, 0x0915, 0x01E9, 0xFAED, 0xF0B0, 0xE240, 0xD93F, 0xD5B8, 0xD9C5, 0xE33B, 0xEAB0, 0xF19B, 0xF3A2, 0xF1F6, 0xF142, 0xF43E,
    0xF1F1, 0xEEE5, 0xEC3C, 0xE603, 0xE1DC, 0xE672, 0xED26, 0xF212, 0xF782, 0xFC46, 0x01F1, 0x0C07, 0x15FB, 0x1C08, 0x1FFA, 0x20BF,
    0x24ED, 0x29EA, 0x24C2, 0x2434, 0x27C2, 0x1FFA, 0x169C, 0x10FD, 0x0BD6, 0xFFB4, 0xF596, 0xED2A, 0xEC82, 0xF255, 0xF824, 0xFEE4,
    0x00FA, 0xFD71, 0xF4C2, 0xF0E3, 0xEB50, 0xE3BC, 0xDD83, 0xD56A, 0xCA60, 0xC5EA, 0xC7EB, 0xCAF6, 0xD026, 0xD3F0, 0xD74F, 0xDF5A,
    0xEA9E, 0xF378, 0xFB3D, 0x0009, 0x061B, 0x120B, 0x15BB, 0x1575, 0x1A14, 0x169F, 0x0B0B, 0x00BC, 0xFDAF, 0xF76B, 0xF17D, 0xEBDC,
    0xE948, 0xEEC0, 0xF4B7, 0xFB12, 0x0049, 0x03DA, 0x0242, 0x0298, 0x044B, 0x0251, 0x0142, 0x000A, 0xF97A, 0xF4FB, 0xF892, 0xFF65,
    0x059C, 0x0D76, 0x12E8, 0x17BE, 0x2101, 0x286C, 0x2F93, 0x3363, 0x322E, 0x394B, 0x3E15, 0x3A90, 0x3CA2, 0x3E9D, 0x380B, 0x2B52,
    0x2399, 0x1B43, 0x11BC, 0x0658, 0xFB01, 0xF72B, 0xF71C, 0xF77D, 0xF82A, 0xF7A1, 0xF094, 0xE719, 0xE16A, 0xDBE2, 0xD486, 0xD045,
    0xC800, 0xBEBA, 0xBBA9, 0xBE51, 0xC306, 0xC9BF, 0xD04E, 0xD616, 0xE046, 0xEAFB, 0xF49B, 0xFD06, 0xFC27, 0xFE15, 0x053F, 0x0412,
    0x055A, 0x0C77, 0x113A, 0x0D45, 0x0A92, 0x076B, 0x0139, 0xF879, 0xEF05, 0xEA90, 0xED4A, 0xF411, 0xFC2E, 0x063A, 0x09F6, 0x08DA,
    0x07B5, 0x0989, 0x08EF, 0x0BC0, 0x0CFC, 0x06E0, 0x010C, 0xFEA8, 0xFFF2, 0x03D5, 0x0A33, 0x0D43, 0x1115, 0x1794, 0x1F01, 0x2887,
    0x2AE7, 0x2AB2, 0x3213, 0x362F, 0x3511, 0x36CB, 0x3AAD, 0x36CF, 0x2E7B, 0x275C, 0x1F6F, 0x137D, 0x02D2, 0xF0C1, 0xE3C6, 0xDC3F,
    0xD7F9, 0xD7B0, 0xD744, 0xD35B, 0xCC43, 0xC91F, 0xC4D7, 0xC1FF, 0xC244, 0xC0EA, 0xBEB1, 0xBEF3, 0xC2F8, 0xC7C1, 0xCF23, 0xD3AD,
    0xD5AD, 0xDA7B, 0xE018, 0xEA96, 0xF426, 0xF77D, 0x0143, 0x0E13, 0x1380, 0x177B, 0x20B8, 0x2555, 0x22CC, 0x1D6D, 0x19A3, 0x1551,
    0x0F34, 0x0514, 0xFBB2, 0xF8A0, 0xF8D2, 0xFED0, 0x074F, 0x0DD7, 0x0E08, 0x0E26, 0x0D18, 0x08D1, 0x06C4, 0x0508, 0xFE8E, 0xF6F9,
    0xF428, 0xF3D5, 0xF7CC, 0xFB89, 0xFAA0, 0xFCE4, 0xFF2E, 0x0633, 0x1141, 0x1402, 0x1606, 0x1E4B, 0x23BA, 0x23B9, 0x28D6, 0x2DB0,
    0x2CFA, 0x2652, 0x1DB0, 0x144B, 0x0960, 0xFB6D, 0xEC25, 0xE2BE, 0xDDAF, 0xDC9F, 0xDF15, 0xE258, 0xE271, 0xE328, 0xE6E4, 0xEAAD,
    0xEE87, 0xF3EA, 0xF3E5, 0xECEC, 0xE676, 0xE131, 0xE198, 0xE804, 0xEC0F, 0xF178, 0xF5F2, 0xFB3B, 0x0750, 0x0FD2, 0x1276, 0x18BD,
    0x2139, 0x2358, 0x25B4, 0x2C4D, 0x3162, 0x2F3A, 0x2A5E, 0x25C6, 0x211D, 0x1A12, 0x0DAF, 0x0242, 0xFBBC, 0xF8F1, 0xFA16, 0x0086,
    0x03CE, 0x0229, 0x01A7, 0xFF97, 0xFC34, 0xFC5F, 0xFC00, 0xF668, 0xEFF6, 0xE9F5, 0xE716, 0xEB32, 0xF015, 0xF627, 0xFC67, 0x00EA,
    0x0AF8, 0x15B4, 0x1904, 0x1AAB, 0x20AB, 0x229E, 0x1FCA, 0x200A, 0x2263, 0x207D, 0x1AA3, 0x1216, 0x0943, 0x018A, 0xF51D, 0xE6C4,
    0xDBC7, 0xD654, 0xD653, 0xDE46, 0xE82A, 0xECBB, 0xEFE6, 0xEDFE, 0xE8C9, 0xE58C, 0xE4DD, 0xE3AB, 0xE0F3, 0xDF00, 0xDD7B, 0xE236,
    0xE81C, 0xEDEA, 0xF50E, 0xF91C, 0x00AD, 0x0EA7, 0x1881, 0x1B91, 0x208A, 0x2473, 0x24C3, 0x25CE, 0x2A5B, 0x2DA5, 0x2BED, 0x2702,
    0x2001, 0x19F8, 0x0FF0, 0x028B, 0xF6C3, 0xEDF3, 0xE9B5, 0xEA01, 0xEFE4, 0xF429, 0xF816, 0xFAB3, 0xF8FD, 0xF789, 0xF6BD, 0xF692,
    0xF2C0, 0xEE94, 0xEAE1, 0xEABF, 0xEFF2, 0xF61A, 0xFD02, 0xFF3E, 0x001F, 0x05B4, 0x0B64, 0x0D65, 0x0E74, 0x10D5, 0x0F1E, 0x0AD5,
    0x09C3, 0x09BD, 0x07B6, 0x0286, 0xFC89, 0xF8FD, 0xF654, 0xF046, 0xE90E, 0xE1DF, 0xDC1C, 0xD969, 0xDBB3, 0xDF33, 0xE05F, 0xE1A9,
    0xE0F6, 0xE165, 0xE368, 0xE490, 0xE3BA, 0xDFF5, 0xDB81, 0xD8F0, 0xDABA, 0xDFB5, 0xE6EE, 0xED30, 0xF016, 0xF6E0, 0x009D, 0x08E4,
    0x117B, 0x1B34, 0x2454, 0x2AA7, 0x2FEE, 0x3540, 0x3974, 0x3B2E, 0x3A5F, 0x3904, 0x3689, 0x3054, 0x2891, 0x1FA8, 0x1677, 0x10A8,
    0x10F4, 0x1505, 0x19BD, 0x1DA0, 0x1D8F, 0x1BE3, 0x1B31, 0x1BC7, 0x1D00, 0x1B11, 0x1534, 0x0CDE, 0x0512, 0xFFEE, 0xFDD4, 0xFDBD,
    0xFA84, 0xF9C9, 0xFCCE, 0xFD6A, 0xFC76, 0xFA18, 0xF7F4, 0xF64D, 0xF59C, 0xF8F9, 0xFD1C, 0xFF42, 0xFD9D, 0xFA4D, 0xF6B6, 0xEF85,
    0xE6B5, 0xDBAF, 0xD0AC, 0xC997, 0xC741, 0xC9B8, 0xCEB2, 0xD3D1, 0xD86E, 0xDCA1, 0xDF6A, 0xE1C6, 0xE4FB, 0xE732, 0xE863, 0xE72D,
    0xE68E, 0xE7C3, 0xECFF, 0xF499, 0xFA91, 0x043F, 0x1056, 0x1C21, 0x26F8, 0x303E, 0x3794, 0x3BD4, 0x3E44, 0x421F, 0x4608, 0x4905,
    0x48D1, 0x44F0, 0x4003, 0x37C0, 0x2E16, 0x22FF, 0x1664, 0x0BBE, 0x03B3, 0x02E8, 0x054E, 0x0A68, 0x0E92, 0x10FB, 0x11A2, 0x1043,
    0x0F0A, 0x09DF, 0x04C2, 0xF1B0, 0xE8DF, 0xEC68, 0xE9DA, 0xE8E8, 0xE56E, 0xE577, 0xE398, 0xDE91, 0xDC87, 0xE1CC, 0xE78D, 0xECE5,
    0xF3A4, 0xF6DC, 0xFA61, 0xFCAB, 0xFB85, 0xF95A, 0xF7A0, 0xF2C0, 0xEC8F, 0xE1EC, 0xD93D, 0xD0CA, 0xC608, 0xCDA3, 0xD543, 0xDBFA,
    0xE20D, 0xE57F, 0xE9F2, 0xEA7E, 0xF0DE, 0xE91F, 0xE138, 0xE4C4, 0xE9DF, 0xF07B, 0xF55B, 0xFF43, 0x0C0F, 0x1304, 0x15EC, 0x1B96,
    0x22FF, 0x2A9E, 0x3049, 0x3614, 0x39C9, 0x3F54, 0x400F, 0x3D7A, 0x3DD5, 0x39AC, 0x366C, 0x26CD, 0x1A88, 0x1242, 0xFE07, 0xF964,
    0xFD68, 0x00D8, 0x0382, 0x0299, 0x015E, 0xFCC9, 0xFD48, 0xF650, 0xE685, 0xDDC8, 0xDBC3, 0xDB42, 0xD963, 0xD8E0, 0xDDD1, 0xE1F0,
    0xE15A, 0xE6D0, 0xEF7F, 0xFA97, 0x0340, 0x0A01, 0x0E1A, 0x131F, 0x1754, 0x15CF, 0x1914, 0x1985, 0x1DD2, 0x177E, 0x0B99, 0x0857,
    0xF838, 0xED7C, 0xEFAD, 0xF857, 0xFF1C, 0x0108, 0x0422, 0x0103, 0x045A, 0x0725, 0xFF26, 0xF6DD, 0xF5CF, 0xFA53, 0xFEDC, 0x02CF,
    0x0AC4, 0x16A5, 0x1B66, 0x1E42, 0x224B, 0x271A, 0x2A59, 0x2D1D, 0x2ECD, 0x31F5, 0x34A6, 0x30CE, 0x2F07, 0x2932, 0x28EB, 0x246B,
    0x1355, 0x0C87, 0xFFB9, 0xEF73, 0xE7AD, 0xE90E, 0xED98, 0xED12, 0xEFB8, 0xECAF, 0xECF2, 0xF0CD, 0xEC0B, 0xDF21, 0xD437, 0xD0A9,
    0xCEED, 0xCCAA, 0xCD3A, 0xD660, 0xDD8C, 0xE352, 0xE9C3, 0xF2D7, 0xFBD5, 0x0590, 0x0C27, 0x115D, 0x1997, 0x19A8, 0x1BF6, 0x19E9,
    0x1B02, 0x1F58, 0x13CA, 0x0BB2, 0x0381, 0xF4D2, 0xE869, 0xE51D, 0xEB77, 0xEFA0, 0xF5FF, 0xF7B4, 0xF532, 0xF9BA, 0xFD36, 0xF6FE,
    0xEDE8, 0xEA56, 0xEC7F, 0xED78, 0xED47, 0xF441, 0xFDA1, 0x03E3, 0x0573, 0x08FB, 0x0CED, 0x1320, 0x178F, 0x1865, 0x1ECC, 0x2087,
    0x22AA, 0x208F, 0x1CEB, 0x2246, 0x1C0A, 0x1452, 0x11AD, 0x090B, 0xFC36, 0xF181, 0xF1FD, 0xF3C9, 0xF77E, 0xFAE9, 0xF81F, 0xFA03,
    0xFFA3, 0xFC82, 0xEF84, 0xDFAE, 0xD658, 0xD16B, 0xCBB4, 0xCD7B, 0xD406, 0xDBC2, 0xDEF8, 0xE333, 0xE6CC, 0xEC8E, 0xF59D, 0xF82B,
    0xFFC1, 0x0457, 0x0932, 0x0BCE, 0x06EB, 0x0D4C, 0x0FE7, 0x0B97, 0x09CD, 0x03EE, 0xF7CE, 0xE9BA, 0xE68E, 0xE8B9, 0xED72, 0xF52D,
    0xF5F7, 0xF648, 0xFD13, 0x013A, 0xFEA1, 0xF50C, 0xF006, 0xF29B, 0xF30D, 0xF602, 0xFBFC, 0x06F3, 0x0E11, 0x141B, 0x1A4F, 0x1F0F,
    0x2725, 0x2969, 0x2EA7, 0x3214, 0x33AD, 0x372D, 0x30A2, 0x31E0, 0x367E, 0x32C1, 0x3007, 0x2D66, 0x26D5, 0x1816, 0x0E28, 0x0B51,
    0x0AAE, 0x0FD2, 0x1364, 0x126E, 0x16B2, 0x1BC9, 0x18B6, 0x0B21, 0xF89C, 0xED0D, 0xE31B, 0xDBA1, 0xDA21, 0xE0C4, 0xE68C, 0xE9E6,
    0xECE8, 0xECF1, 0xF300, 0xF579, 0xF9A9, 0xFDF7, 0xFEC4, 0x02F2, 0xFC9E, 0xF962, 0xFD4C, 0xFCC4, 0xF8DD, 0xF55A, 0xF22C, 0xE4DC,
    0xD6CF, 0xD012, 0xCE93, 0xD3ED, 0xDBD6, 0xDE1F, 0xE101, 0xE8C5, 0xEFEB, 0xEFDC, 0xE98C, 0xE82B, 0xE9D1, 0xEA7F, 0xEB76, 0xF35D,
    0xFD4A, 0x0682, 0x0E2D, 0x12DE, 0x1D77, 0x24AA, 0x2AE5, 0x301F, 0x30F2, 0x3793, 0x3827, 0x3483, 0x3797, 0x3C01, 0x3B08, 0x3797,
    0x3653, 0x2CD2, 0x1D6F, 0x1051, 0x074D, 0x05E3, 0x0B8B, 0x0CDE, 0x0905, 0x085C, 0x0A84, 0x0851, 0xF8F6, 0xE750, 0xDCB4, 0xD52B,
    0xCE62, 0xCEB2, 0xD3E1, 0xDA11, 0xDE7A, 0xDDBF, 0xE078, 0xE265, 0xE459, 0xE739, 0xE64F, 0xEAE3, 0xEDA1, 0xE926, 0xE7BB, 0xECA1,
    0xF028, 0xF038, 0xF45D, 0xF2F1, 0xE855, 0xDC3C, 0xD36C, 0xD08C, 0xD602, 0xDD52, 0xDFEE, 0xE274, 0xEA2A, 0xF373, 0xF406, 0xEE78,
    0xEAF5, 0xEC69, 0xEA9C, 0xECAA, 0xF35F, 0xFA9C, 0x065B, 0x0D62, 0x160C, 0x1F0F, 0x2488, 0x2B68, 0x2C38, 0x2E90, 0x33A5, 0x32D6,
    0x30CC, 0x33BF, 0x38CE, 0x367D, 0x3473, 0x32F9, 0x28C6, 0x1A83, 0x0DAB, 0x02DF, 0x014F, 0x05A9, 0x06C1, 0x0311, 0xFFA4, 0x0162,
    0xFD6D, 0xEFFF, 0xE086, 0xD7D5, 0xCFDE, 0xC963, 0xCA58, 0xCEEC, 0xD99F, 0xE125, 0xE789, 0xF021, 0xF622, 0x0059, 0x06A6, 0x0B61,
    0x1429, 0x185A, 0x17AB, 0x188F, 0x1D7A, 0x1E50, 0x1D61, 0x1FA1, 0x1CAC, 0x1249, 0x050E, 0xF6CF, 0xEFD3, 0xF12C, 0xF631, 0xF7EB,
    0xF860, 0xFF52, 0x069D, 0x07C9, 0x00CF, 0xFBB2, 0xF78D, 0xF1CC, 0xF13E, 0xF2E1, 0xFC0C, 0x0582, 0x0BA2, 0x14C3, 0x1984, 0x20F2,
    0x25A0, 0x2575, 0x2A49, 0x2F4F, 0x3131, 0x30A9, 0x35E6, 0x398A, 0x3599, 0x34E2, 0x31E1, 0x285E, 0x1BFC, 0x0B77, 0xFFE3, 0xFB69,
    0xFC4E, 0xFAA9, 0xF1A7, 0xEC9B, 0xEB30, 0xE99C, 0xDFA1, 0xD451, 0xCDD2, 0xC546, 0xC24D, 0xC216, 0xC76D, 0xD034, 0xD55D, 0xDD85,
    0xE2C2, 0xE900, 0xF0B2, 0xF310, 0xF8D1, 0x027D, 0x0801, 0x0958, 0x0D75, 0x142A, 0x1652, 0x1835, 0x1C1A, 0x1A46, 0x1434, 0x077D,
    0xF88C, 0xEF5F, 0xEF60, 0xF42A, 0xF3EC, 0xF54C, 0xFC57, 0x068E, 0x074F, 0x0165, 0xFD3F, 0xF711, 0xF435, 0xF148, 0xF3A3, 0xFC41,
    0x0215, 0x0871, 0x0B42, 0x0D57, 0x1072, 0x100D, 0x0E75, 0x1226, 0x187E, 0x17F2, 0x179D, 0x1C36, 0x1F15, 0x1E68, 0x208A, 0x215E,
    0x1E93, 0x17F5, 0x0C09, 0x0125, 0xFC90, 0xFD82, 0xFAE1, 0xF46B, 0xEF00, 0xF0D2, 0xF084, 0xE814, 0xDFB2, 0xD5B4, 0xCEC1, 0xC7BD,
    0xC471, 0xC94A, 0xCEE3, 0xD771, 0xDDB8, 0xE18F, 0xE771, 0xECE7, 0xEE8E, 0xF284, 0xFC4D, 0x0153, 0x028A, 0x0740, 0x0CA2, 0x0EC4,
    0x1209, 0x15E7, 0x16FC, 0x1458, 0x0AD4, 0xFC96, 0xF263, 0xF115, 0xF510, 0xF67A, 0xF5BE, 0xFD3F, 0x05AC, 0x067D, 0x0305, 0xFC02,
    0xF701, 0xF23D, 0xF058, 0xF5F5, 0xFD4C, 0x059C, 0x0C3E, 0x10ED, 0x1596, 0x1CB4, 0x2121, 0x2353, 0x2C6D, 0x3411, 0x3651, 0x38BE,
    0x3CB1, 0x3DB5, 0x3D80, 0x4199, 0x44BF, 0x439D, 0x3E7D, 0x3298, 0x250E, 0x1C6A, 0x1910, 0x1689, 0x0CF1, 0x0690, 0x05AF, 0x0244,
    0xFCC6, 0xF1FE, 0xE716, 0xDC96, 0xD2C9, 0xCE77, 0xCE09, 0xD0E6, 0xD622, 0xD9FF, 0xDC77, 0xE19A, 0xE474, 0xE3F9, 0xE7B5, 0xF053,
    0xF439, 0xF5DC, 0xFB87, 0xFF3B, 0x01A9, 0x0410, 0x068E, 0x07B0, 0x055A, 0xFB79, 0xED3F, 0xE34F, 0xE05B, 0xE3BD, 0xE3B8, 0xE39C,
    0xEB15, 0xF2AF, 0xF678, 0xF461, 0xF081, 0xEED5, 0xEAF3, 0xE94C, 0xED80, 0xF329, 0xFA86, 0x006C, 0x03B0, 0x09EB, 0x10D4, 0x14D1,
    0x1923, 0x2313, 0x2A71, 0x2AF3, 0x2D7B, 0x304B, 0x32D7, 0x3601, 0x3952, 0x3D88, 0x3E93, 0x39FB, 0x2C3D, 0x1BCD, 0x0FF3, 0x0AC0,
    0x05B1, 0xFAB4, 0xF574, 0xF418, 0xF2A6, 0xEDE8, 0xE653, 0xE12E, 0xD8F5, 0xD125, 0xCE80, 0xD00B, 0xD55B, 0xDC00, 0xE095, 0xE4D8,
    0xEA72, 0xED5E, 0xEB43, 0xEDA8, 0xF39E, 0xF3FB, 0xF52E, 0xF79E, 0xFA73, 0xFC79, 0xFD69, 0x00D8, 0x01D0, 0x0198, 0xFB05, 0xEEA5,
    0xE417, 0xE0E7, 0xE433, 0xE19F, 0xE17C, 0xE673, 0xEDE8, 0xF4F7, 0xF4B9, 0xF478, 0xF305, 0xEE68, 0xEB46, 0xE9AD, 0xEC89, 0xF268,
    0xF6A1, 0xFBB5, 0x0373, 0x0D15, 0x12C9, 0x1826, 0x225F, 0x26F4, 0x27E5, 0x2914, 0x2A94, 0x2DE2, 0x3189, 0x37B0, 0x3D71, 0x418C,
    0x3E77, 0x31AD, 0x1F2F, 0x0F8E, 0x08DC, 0xFF7F, 0xF561, 0xEE2E, 0xEB75, 0xEB8A, 0xE76B, 0xE242, 0xDC30, 0xD3FE, 0xCCEA, 0xC841,
    0xC5C2, 0xC89B, 0xCDF8, 0xD206, 0xD839, 0xE1D3, 0xE680, 0xE858, 0xF10D, 0xFA45, 0x0182, 0x090D, 0x0FAE, 0x13BC, 0x1722, 0x19D4,
    0x1BAE, 0x1ED6, 0x1ED0, 0x1C0E, 0x1226, 0x079B, 0x0480, 0x02DB, 0xFF0A, 0xFACE, 0xFC7D, 0x037F, 0x0954, 0x0C95, 0x0E1F, 0x0AD0,
    0x0492, 0xFD42, 0xF655, 0xF437, 0xF748, 0xF996, 0xFB39, 0x017D, 0x06B3, 0x06FA, 0x09CC, 0x0FDD, 0x1302, 0x13E2, 0x1796, 0x1C4C,
    0x2128, 0x2651, 0x2A37, 0x2EC4, 0x3020, 0x2D8A, 0x2132, 0x0C03, 0xFC4D, 0xF25A, 0xE96C, 0xE039, 0xDA76, 0xDA7C, 0xDBBC, 0xDC0E,
    0xDBFB, 0xDAC1, 0xD58C, 0xD090, 0xCC77, 0xCAA8, 0xCF7D, 0xD4F7, 0xD87F, 0xDE6B, 0xE5BB, 0xE814, 0xE8C6, 0xEF11, 0xF6D9, 0xFB35,
    0x00CB, 0x0615, 0x0B1F, 0x0F9A, 0x1043, 0x1441, 0x18CF, 0x1E09, 0x1CF0, 0x10D7, 0x0654, 0xFDFB, 0xF7E4, 0xF0ED, 0xEB56, 0xEE67,
    0xF5C9, 0xFDA0, 0x031B, 0x0589, 0x03D1, 0xFE0C, 0xF6E1, 0xF0FE, 0xF20D, 0xF786, 0xFA69, 0x005A, 0x08F5, 0x0D52, 0x0CFB, 0x0DFA,
    0x128B, 0x156C, 0x1712, 0x1957, 0x1BF0, 0x204F, 0x2486, 0x2939, 0x2F25, 0x3363, 0x34ED, 0x298B, 0x1718, 0x07F8, 0xFC93, 0xF31B,
    0xE771, 0xE01F, 0xDDF8, 0xDD5D, 0xDD3A, 0xDCC2, 0xD979, 0xD4CA, 0xCF3F, 0xC89A, 0xC5E6, 0xC867, 0xCB7A, 0xCD6E, 0xD428, 0xDBDB,
    0xE00B, 0xE453, 0xEBEE, 0xF435, 0xFA85, 0x008B, 0x046B, 0x0817, 0x0B5D, 0x0E98, 0x13CD, 0x1A17, 0x2239, 0x2217, 0x178D, 0x0BFB,
    0x02F0, 0xFCD7, 0xF745, 0xF3F9, 0xF724, 0xFE74, 0x06D5, 0x0DA8, 0x0F7C, 0x0D2D, 0x06E7, 0xFF88, 0xF7F9, 0xF84A, 0xFF08, 0x036A,
    0x0C1D, 0x15F9, 0x1C6E, 0x1F5E, 0x2384, 0x2A62, 0x2FB1, 0x360A, 0x3AD0, 0x3F33, 0x43A6, 0x468B, 0x496C, 0x4AA0, 0x4E9C, 0x4F7F,
    0x44EE, 0x3584, 0x24CD, 0x17ED, 0x0D21, 0x00AA, 0xFA14, 0xF82D, 0xF885, 0xFB94, 0xFCFA, 0xFD20, 0xF88D, 0xF105, 0xE72B, 0xDF6E,
    0xDE7A, 0xDB87, 0xDB1D, 0xE01E, 0xE6AB, 0xEB0E, 0xEE76, 0xF3F1, 0xF7D2, 0xFA81, 0xFB79, 0xFC36, 0xFD64, 0xFEA3, 0xFFF9, 0x01B9,
    0x07E3, 0x0E1C, 0x0B36, 0xFEAA, 0xEFAB, 0xE52C, 0xDDFF, 0xD6BA, 0xD3D6, 0xD668, 0xDB38, 0xE305, 0xEB3F, 0xEF77, 0xEF9E, 0xECB6,
    0xE648, 0xE2F5, 0xE56F, 0xE8DC, 0xEC41, 0xF27F, 0xFB41, 0x00EA, 0x04D7, 0x0C38, 0x1565, 0x1EE8, 0x26B7, 0x2DBA, 0x34BD, 0x398F,
    0x3DCA, 0x4055, 0x4430, 0x4964, 0x4848, 0x3DB6, 0x2AC9, 0x1940, 0x0B33, 0xFC5D, 0xEFCA, 0xE780, 0xE40B, 0xE307, 0xE37A, 0xE48B,
    0xE3E4, 0xE212, 0xDD22, 0xD5E1, 0xD2E2, 0xD2AC, 0xD15E, 0xD29E, 0xD942, 0xDF2B, 0xE1C2, 0xE450, 0xE736, 0xEB0F, 0xEC7E, 0xED10,
    0xEE56, 0xEFE6, 0xF47A, 0xF7EB, 0xFB63, 0x0281, 0x090E, 0x0834, 0xFD2D, 0xF1BC, 0xEBE3, 0xE7EB, 0xE4B3, 0xE424, 0xE769, 0xEBFC,
    0xF23F, 0xF878, 0xFB29, 0xFD26, 0xFAD2, 0xF472, 0xF03C, 0xF06A, 0xF22A, 0xF2BF, 0xF9D8, 0x0246, 0x0780, 0x0BF4, 0x0FB7, 0x1724,
    0x1ECA, 0x26CC, 0x2EC6, 0x358D, 0x3CF5, 0x40BA, 0x421A, 0x44AC, 0x4842, 0x48D1, 0x3E87, 0x2DB3, 0x1D4E, 0x0E14, 0x0071, 0xF353,
    0xEAAC, 0xE84E, 0xE99E, 0xED49, 0xEDEE, 0xECDD, 0xE9A1, 0xDFAC, 0xD4EC, 0xCE49, 0xCB3A, 0xCA64, 0xCDC3, 0xD50F, 0xDC4C, 0xE36B,
    0xE923, 0xEEB3, 0xF40C, 0xF83A, 0xFE20, 0x02B2, 0x0890, 0x0FC2, 0x131E, 0x1676, 0x1D21, 0x243C, 0x245C, 0x1B89, 0x1116, 0x09F0,
    0x0411, 0xFDC6, 0xF935, 0xF758, 0xF882, 0xFDAB, 0x033C, 0x08D4, 0x0E04, 0x0CA7, 0x0683, 0x0214, 0xFFFC, 0xFD5F, 0xFCD7, 0x01BB,
    0x064C, 0x08A8, 0x09AE, 0x0BE7, 0x10AB, 0x1629, 0x1D7A, 0x245C, 0x2B9E, 0x32A4, 0x3599, 0x364C, 0x38D4, 0x3D3E, 0x3D60, 0x3323,
    0x2355, 0x1262, 0x0086, 0xEEDF, 0xDF89, 0xD688, 0xD295, 0xD31D, 0xD520, 0xD514, 0xD606, 0xD395, 0xCD05, 0xC85B, 0xC763, 0xC7E1,
    0xC94D, 0xCF2C, 0xD6EC, 0xDCBE, 0xE04C, 0xE3B1, 0xE9A5, 0xF00E, 0xF68A, 0xFD5B, 0x033C, 0x0CC6, 0x152E, 0x1934, 0x1E98, 0x269B,
    0x3015, 0x3207, 0x2C60, 0x276A, 0x21F0, 0x1C15, 0x16E6, 0x1316, 0x113E, 0x1099, 0x12A4, 0x1395, 0x1747, 0x1B0C, 0x15EB, 0x0E1E,
    0x0835, 0x032D, 0x0030, 0x0056, 0x04B0, 0x0951, 0x0B94, 0x0D53, 0x0E6C, 0x1160, 0x1517, 0x18C3, 0x1CB0, 0x2194, 0x263E, 0x268C,
    0x24D3, 0x25FA, 0x2A72, 0x2C74, 0x25C8, 0x19E4, 0x0D59, 0xFEB6, 0xF083, 0xE484, 0xDCE8, 0xDB6A, 0xDD91, 0xE053, 0xE36B, 0xE57D,
    0xE15E, 0xD7D3, 0xD098, 0xCC74, 0xC9B2, 0xC9B5, 0xCC48, 0xD050, 0xD3DB, 0xD650, 0xD9B2, 0xDDC0, 0xE3B8, 0xEBF2, 0xF3D0, 0xFC85,
    0x0487, 0x0985, 0x0A5F, 0x0BD7, 0x12AF, 0x1A18, 0x1B30, 0x15BC, 0x0EE6, 0x088C, 0x0243, 0xFD15, 0xF84F, 0xF5C1, 0xF7F2, 0xFC0E,
    0x0247, 0x0A7E, 0x0F6E, 0x0C7E, 0x067B, 0x0181, 0xFB17, 0xF5F1, 0xF4CA, 0xF7E5, 0xFC38, 0x0058, 0x0592, 0x0B02, 0x12C0, 0x1C79,
    0x2678, 0x30F8, 0x3B25, 0x42EF, 0x4514, 0x44E7, 0x47D0, 0x4C58, 0x4C2D, 0x43E2, 0x38A9, 0x2BA2, 0x1D41, 0x107C, 0x04AC, 0xFD5F,
    0xFB4F, 0xFC18, 0xFE67, 0x0247, 0x0567, 0x0042, 0xF89B, 0xF4D5, 0xF09B, 0xECC8, 0xE955, 0xE859, 0xE917, 0xE7E3, 0xE911, 0xEB18,
    0xEE7C, 0xF52E, 0xFAB0, 0xFFBF, 0x03CE, 0x0817, 0x0AE1, 0x0A1F, 0x0CDB, 0x1494, 0x1B9F, 0x1C53, 0x16DB, 0x0F03, 0x0531, 0xFB6C,
    0xF319, 0xEC47, 0xEB2E, 0xECAB, 0xEED1, 0xF4CF, 0xFCBA, 0x0110, 0xFF60, 0xFB0C, 0xF53A, 0xEDF2, 0xE732, 0xE4CB, 0xE6CB, 0xEAE6,
    0xEF93, 0xF526, 0xFC42, 0x0567, 0x0EF8, 0x16F8, 0x1EF7, 0x273F, 0x2D83, 0x2F1B, 0x2F99, 0x33CB, 0x3805, 0x3690, 0x2F6A, 0x255D,
    0x1B0C, 0x10BE, 0x06C7, 0xFE20, 0xF831, 0xF572, 0xF2A8, 0xF21A, 0xF67A, 0xF7B3, 0xF3B1, 0xEED9, 0xEAB2, 0xE658, 0xE06B, 0xDD2D,
    0xDD1D, 0xDDC5, 0xDED7, 0xE0B5, 0xE3D8, 0xE7EA, 0xEC25, 0xEF75, 0xF289, 0xF5A7, 0xF690, 0xF3A0, 0xEF7B, 0xF0DA, 0xF805, 0xFDF7,
    0xFEA8, 0xFBB1, 0xF700, 0xF186, 0xECB2, 0xE7FE, 0xE501, 0xE65C, 0xE9C8, 0xEF2F, 0xF8ED, 0x0233, 0x058D, 0x0388, 0x00E5, 0xFCC1,
    0xF54B, 0xEF52, 0xED3B, 0xEF87, 0xF476, 0xFA78, 0x00E9, 0x07E4, 0x1151, 0x1AB3, 0x23A0, 0x2E0E, 0x375C, 0x3DC4, 0x3E86, 0x3E84,
    0x423A, 0x4318, 0x4041, 0x3880, 0x2DCA, 0x231A, 0x179F, 0x0CD7, 0x00BC, 0xF80F, 0xF2EC, 0xEE22, 0xEEC1, 0xF1D2, 0xF324, 0xF0DB,
    0xEB9D, 0xE5DE, 0xDD14, 0xD56A, 0xD112, 0xCEF2, 0xD104, 0xD44B, 0xD8EA, 0xDF2F, 0xE6CD, 0xEEC5, 0xF436, 0xFA4F, 0x007A, 0x04E5,
    0x06F8, 0x08BA, 0x1025, 0x1A53, 0x223E, 0x25D5, 0x242D, 0x1F35, 0x17BF, 0x0F3A, 0x0705, 0x026D, 0x00FC, 0xFFFA, 0x025B, 0x07E8,
    0x0D23, 0x0E0F, 0x0BCC, 0x0850, 0x0176, 0xF94B, 0xF358, 0xF140, 0xF231, 0xF407, 0xF6C8, 0xFBA2, 0x023D, 0x0A58, 0x11CB, 0x184E,
    0x205F, 0x2742, 0x2941, 0x2803, 0x28FD, 0x2BD0, 0x2D0D, 0x2B83, 0x269E, 0x1F8A, 0x169B, 0x0C63, 0x0003, 0xF4A3, 0xEBC0, 0xE26B,
    0xDD11, 0xDDE0, 0xE103, 0xE277, 0xE0EC, 0xDDCF, 0xD7B0, 0xCF9F, 0xC97F, 0xC6CD, 0xC834, 0xCC0E, 0xD06E, 0xD623, 0xDCBC, 0xE38C,
    0xE856, 0xEB46, 0xF0BA, 0xF8BF, 0xFE82, 0xFFCE, 0x0260, 0x0AB5, 0x13C3, 0x1B75, 0x1FC7, 0x1ED1, 0x1C9A, 0x180F, 0x114F, 0x0C15,
    0x09D3, 0x096E, 0x0A6E, 0x107F, 0x191D, 0x1DB9, 0x1DAE, 0x19C5, 0x142A, 0x0C4F, 0x044B, 0xFFD8, 0xFE8F, 0x0145, 0x04DF, 0x0848,
    0x0E48, 0x1496, 0x1B7D, 0x2146, 0x26FD, 0x2E5D, 0x30FA, 0x2D75, 0x2811, 0x2630, 0x2758, 0x276D, 0x2590, 0x1F4A, 0x161F, 0x0C67,
    0xFDF4, 0xEEB2, 0xE1CF, 0xD665, 0xCE8F, 0xCD32, 0xD2A5, 0xD8B5, 0xDBDE, 0xDC0F, 0xD7FA, 0xD0A8, 0xC880, 0xC1FF, 0xBF93, 0xC07E,
    0xC37B, 0xC6A4, 0xC9F2, 0xCE43, 0xD2DF, 0xD682, 0xDADF, 0xE38E, 0xED66, 0xF33A, 0xF61C, 0xFAE2, 0x031D, 0x0BDE, 0x135E, 0x170F,
    0x16ED, 0x147A, 0x0E4A, 0x06D8, 0x0115, 0xFCB8, 0xFA8F, 0xFBCA, 0x015F, 0x080A, 0x0AED, 0x0C01, 0x0A32, 0x04E5, 0xFD4E, 0xF6F7,
    0xF359, 0xF278, 0xF2BC, 0xF418, 0xF875, 0xFFF7, 0x0A73, 0x13FA, 0x1D52, 0x27F1, 0x31D1, 0x356C, 0x33C2, 0x3265, 0x3448, 0x3874,
    0x3C5F, 0x3CB6, 0x38D9, 0x32E8, 0x28A0, 0x1C3A, 0x1242, 0x08D8, 0x00AE, 0xFAF6, 0xFAD2, 0xFFBF, 0x02A7, 0x03B0, 0x0181, 0xFBB5,
    0xF2E8, 0xE907, 0xE272, 0xE09D, 0xE170, 0xE335, 0xE42E, 0xE6EE, 0xEAEC, 0xECDC, 0xEDE4, 0xF04A, 0xF7A1, 0xFDEE, 0xFEAA, 0xFEC5,
    0x0061, 0x05E2, 0x0B7D, 0x0E0B, 0x0DEC, 0x0B30, 0x0660, 0xFD98, 0xF544, 0xEF57, 0xEA99, 0xE87A, 0xEB34, 0xF2A9, 0xFA31, 0xFDEB,
    0xFECA, 0xFC58, 0xF625, 0xEE49, 0xE606, 0xE085, 0xDEFD, 0xDFAE, 0xE32C, 0xE8C9, 0xF31C, 0xFF47, 0x08C3, 0x1301, 0x1DDF, 0x276F,
    0x2984, 0x270C, 0x258B, 0x276B, 0x2BEA, 0x2D55, 0x2927, 0x2259, 0x1815, 0x0A14, 0xFC12, 0xF03D, 0xE6B1, 0xDE63, 0xDBDF, 0xDEF2,
    0xE36A, 0xE67F, 0xE7B4, 0xE66E, 0xE205, 0xDB84, 0xD528, 0xD089, 0xCFF4, 0xD1CB, 0xD3F5, 0xD6D9, 0xDA59, 0xDE02, 0xDFA3, 0xE1E6,
    0xE879, 0xF158, 0xF5EA, 0xF699, 0xF75E, 0xF978, 0xFEA6, 0x03DA, 0x0484, 0x0441, 0x02A8, 0xFE08, 0xF76B, 0xF13A, 0xECC0, 0xE762,
    0xE5EB, 0xEA45, 0xF230, 0xF98B, 0xFE4F, 0x015D, 0x001A, 0xFB85, 0xF444, 0xEDEA, 0xEBA2, 0xEBFC, 0xEEB4, 0xF356, 0xFA8D, 0x04E3,
    0x0D56, 0x1385, 0x1ABF, 0x223E, 0x290E, 0x2B78, 0x2AFD, 0x2BD5, 0x3052, 0x3656, 0x3805, 0x366E, 0x30C1, 0x25B0, 0x18FF, 0x0C4D,
    0x0385, 0xFAB9, 0xF364, 0xF14B, 0xF10C, 0xF256, 0xF227, 0xF1C9, 0xEF9D, 0xE9CD, 0xE293, 0xDC52, 0xD8C6, 0xD80A, 0xD800, 0xD98F,
    0xDCBF, 0xE2E6, 0xE994, 0xEDA2, 0xF2A6, 0xF977, 0x0057, 0x03A9, 0x043D, 0x067F, 0x0B20, 0x1214, 0x1739, 0x1970, 0x1B5A, 0x19F1,
    0x1614, 0x10F4, 0x0D44, 0x0956, 0x0405, 0x020E, 0x04D3, 0x0994, 0x0D06, 0x0ECD, 0x0EBA, 0x0BA8, 0x04CA, 0xFC2D, 0xF5F1, 0xF431,
    0xF611, 0xF90F, 0xFDE7, 0x05B8, 0x0DD6, 0x12D9, 0x15F4, 0x1C03, 0x21E0, 0x2447, 0x2366, 0x20E3, 0x20C4, 0x2363, 0x245C, 0x21DC,
    0x1D21, 0x1507, 0x0992, 0xFCEC, 0xF26B, 0xE971, 0xDF8E, 0xD8F3, 0xD623, 0xD602, 0xD63C, 0xD5F7, 0xD5E1, 0xD406, 0xD04B, 0xCB7E,
    0xC83B, 0xC6E5, 0xC823, 0xC990, 0xCBAC, 0xD01B, 0xD592, 0xD9C7, 0xDDA2, 0xE503, 0xEE42, 0xF6B4, 0xFCCE, 0xFFAA, 0x046C, 0x0C8E,
    0x152C, 0x1B82, 0x1EF9, 0x215A, 0x2002, 0x1CBF, 0x19AC, 0x14F5, 0x0EF4, 0x09F8, 0x08F0, 0x0C71, 0x1136, 0x15CF, 0x1743, 0x151C,
    0x0F29, 0x05DB, 0xFC94, 0xF6FB, 0xF751, 0xF9ED, 0xFDD3, 0x0509, 0x0D6B, 0x1357, 0x15CB, 0x18A4, 0x1E49, 0x2367, 0x26C4, 0x2614,
    0x2427, 0x248A, 0x2515, 0x2495, 0x22B9, 0x1EEA, 0x1827, 0x0E09, 0x03D1, 0xF92E, 0xEE10, 0xE43A, 0xDD49, 0xDA56, 0xD932, 0xD9C2,
    0xDA8C, 0xDA8F, 0xD7D4, 0xD288, 0xCC85, 0xC813, 0xC6F5, 0xC65F, 0xC564, 0xC57D, 0xC869, 0xCB97, 0xCD34, 0xD061, 0xD6C6, 0xDF25,
    0xE58F, 0xE94C, 0xEC0C, 0xF170, 0xF8DB, 0x00E1, 0x084D, 0x0DBA, 0x0FB6, 0x0CF6, 0x0A06, 0x0705, 0x0299, 0xFD29, 0xFA65, 0xFBAB,
    0xFF19, 0x0276, 0x0543, 0x063B, 0x0347, 0xFD3C, 0xF493, 0xEE3A, 0xEC52, 0xEDB3, 0xF018, 0xF439, 0xFC69, 0x04D6, 0x0A84, 0x0F71,
    0x1706, 0x21A1, 0x2B7D, 0x31EF, 0x353D, 0x3857, 0x3C96, 0x3EEC, 0x3F9A, 0x3F31, 0x3C44, 0x35E9, 0x2DDA, 0x2627, 0x1C09, 0x1037,
    0x061C, 0xFF69, 0xFD49, 0xFDA1, 0xFF11, 0xFFEC, 0xFE4A, 0xFACA, 0xF3C0, 0xEB95, 0xE67F, 0xE3AE, 0xE24F, 0xE0A6, 0xE1DB, 0xE4A9,
    0xE5F9, 0xE79F, 0xEAE9, 0xF27B, 0xFB9F, 0x0144, 0x035F, 0x051B, 0x0ADE, 0x11DA, 0x1807, 0x1D73, 0x1EEB, 0x1C5E, 0x1710, 0x10F3,
    0x0976, 0xFFF8, 0xF8BA, 0xF42A, 0xF301, 0xF480, 0xF6DB, 0xF928, 0xF806, 0xF3C0, 0xECA2, 0xE47E, 0xDEED, 0xDC85, 0xDC43, 0xDD9F,
    0xE1A1, 0xE75B, 0xEB79, 0xEF5F, 0xF49C, 0xFD56, 0x0937, 0x135E, 0x19F6, 0x1DB6, 0x21D7, 0x2551, 0x280A, 0x2B88, 0x2B8A, 0x292E,
    0x2575, 0x1E94, 0x15BD, 0x0A0C, 0xFE3D, 0xF4D2, 0xEF98, 0xEDAE, 0xED8F, 0xEECE, 0xEFDE, 0xEE78, 0xE9D2, 0xE34B, 0xDD9E, 0xDA7F,
    0xD857, 0xD643, 0xD5BD, 0xD81A, 0xD982, 0xDAC7, 0xDCB1, 0xE16F, 0xE991, 0xEFD9, 0xF282, 0xF261, 0xF443, 0xF777, 0xFBB3, 0x01C3,
    0x0749, 0x08A8, 0x05FC, 0x0267, 0xFEAA, 0xF9DC, 0xF4CF, 0xF1F5, 0xF1DC, 0xF39F, 0xF5B7, 0xF788, 0xF864, 0xF7AB, 0xF48B, 0xF005,
    0xEC18, 0xEB5B, 0xED9B, 0xEF76, 0xF35F, 0xF935, 0xFFCB, 0x0632, 0x0B6E, 0x1275, 0x1C08, 0x2505, 0x298E, 0x2B3B, 0x2C8A, 0x2DC8,
    0x2F2E, 0x315A, 0x3337, 0x3250, 0x2E66, 0x28E0, 0x221A, 0x18E3, 0x0D6F, 0x0226, 0xFA60, 0xF676, 0xF56E, 0xF615, 0xF743, 0xF7A8,
    0xF411, 0xECAF, 0xE3D0, 0xDC5C, 0xD6B8, 0xD1EF, 0xD034, 0xD196, 0xD49A, 0xD8AC, 0xDBD1, 0xE14C, 0xEA2E, 0xF3C3, 0xFB62, 0xFECF,
    0x01BF, 0x0620, 0x0C06, 0x13CB, 0x1B97, 0x2050, 0x209F, 0x1F83, 0x1EAE, 0x1C27, 0x1854, 0x14E2, 0x12B3, 0x12D7, 0x1307, 0x1358,
    0x1381, 0x12E3, 0x1172, 0x0D3E, 0x084A, 0x0474, 0x01EE, 0xFF32, 0xFD8D, 0xFEE0, 0x0180, 0x04A5, 0x083E, 0x0C10, 0x12AF, 0x1AC6,
    0x201F, 0x21A5, 0x2067, 0x1FBE, 0x1FDF, 0x20D0, 0x2181, 0x20A8, 0x1D75, 0x1821, 0x1160, 0x08A0, 0xFD46, 0xF021, 0xE4DC, 0xDDA5,
    0xD9A9, 0xD8EA, 0xDA8D, 0xDD09, 0xDDE7, 0xDA6F, 0xD460, 0xCECC, 0xCA68, 0xC62A, 0xC37B, 0xC46F, 0xC70F, 0xC9BB, 0xCB96, 0xCCF6,
    0xD1FB, 0xD8E4, 0xDF7E, 0xE4A7, 0xE941, 0xEE90, 0xF394, 0xFB74, 0x05D2, 0x0F47, 0x157B, 0x18BC, 0x1B6A, 0x1CF4, 0x1BE3, 0x19C0,
    0x17F8, 0x1713, 0x172E, 0x17BA, 0x18BE, 0x1A92, 0x1D4E, 0x1C9C, 0x1952, 0x1715, 0x158B, 0x14A9, 0x12DD, 0x137F, 0x16E8, 0x1B2E,
    0x1FCA, 0x23E6, 0x2A16, 0x3152, 0x3650, 0x3731, 0x3432, 0x3039, 0x2C6C, 0x2A40, 0x2A08, 0x2937, 0x268B, 0x214E, 0x1A59, 0x117C,
    0x0677, 0xF911, 0xEC4B, 0xE1DD, 0xD9CD, 0xD4C3, 0xD305, 0xD43E, 0xD64A, 0xD661, 0xD23F, 0xCD51, 0xC97A, 0xC6D4, 0xC476, 0xC3D1,
    0xC61D, 0xC90D, 0xCBAF, 0xCCF8, 0xCFCA, 0xD597, 0xDC71, 0xE1ED, 0xE68D, 0xEB0B, 0xEE96, 0xF39A, 0xFA6B, 0x00DF, 0x05E5, 0x0850,
    0x0A45, 0x0C01, 0x0B98, 0x089E, 0x044C, 0x0059, 0xFCAB, 0xFABB, 0xFAA7, 0xFC09, 0xFEC8, 0x0094, 0xFEDB, 0xFC76, 0xFA93, 0xF7E6,
    0xF554, 0xF34B, 0xF507, 0xFA35, 0xFFFD, 0x04E0, 0x0AD3, 0x13A7, 0x1CC9, 0x236D, 0x26DF, 0x2831, 0x2976, 0x2B3D, 0x2F46, 0x3507,
    0x389A, 0x3879, 0x3626, 0x323F, 0x2AE2, 0x2064, 0x141A, 0x0910, 0x000C, 0xFB20, 0xF9B3, 0xFB5A, 0x0038, 0x02D2, 0x01E3, 0xFDDD,
    0xF96D, 0xF55B, 0xF053, 0xECE3, 0xECA0, 0xEF5E, 0xF1D4, 0xF2BA, 0xF30C, 0xF534, 0xFA89, 0xFEDF, 0x0298, 0x06A3, 0x08CA, 0x0A4C,
    0x0D7F, 0x1233, 0x1656, 0x18BF, 0x1A5A, 0x1BEC, 0x1BDC, 0x17EF, 0x0F8B, 0x0624, 0xFD64, 0xF580, 0xEF2E, 0xEBE3, 0xEED6, 0xF342,
    0xF417, 0xF2E4, 0xF077, 0xEE29, 0xEB65, 0xE9AD, 0xEADB, 0xEEC9, 0xF437, 0xF7EA, 0xFAAF, 0x004E, 0x0920, 0x1094, 0x1553, 0x182A,
    0x1955, 0x1A36, 0x1BAB, 0x1FA8, 0x2420, 0x25AE, 0x247B, 0x217C, 0x1CAD, 0x1432, 0x089A, 0xFCD2, 0xF3BF, 0xEDD0, 0xEA7C, 0xE990,
    0xEB89, 0xEDEB, 0xED2E, 0xEA45, 0xE648, 0xE2B9, 0xDF7B, 0xDCC8, 0xDC1F, 0xDDB4, 0xE0B7, 0xE2C1, 0xE45E, 0xE842, 0xEEAD, 0xF722,
    0xFE28, 0x03A9, 0x071F, 0x08CB, 0x0AD2, 0x0E68, 0x12AE, 0x14FC, 0x171A, 0x18A4, 0x18AD, 0x15C5, 0x0E8C, 0x0454, 0xF9E8, 0xF11B,
    0xEABE, 0xE892, 0xEAA4, 0xEF68, 0xF1F3, 0xF078, 0xED97, 0xEA22, 0xE68D, 0xE3B5, 0xE40C, 0xE805, 0xEF1B, 0xF660, 0xFC0D, 0x02F3,
    0x0B73, 0x145E, 0x1B7E, 0x20B1, 0x23CE, 0x24F4, 0x2626, 0x291D, 0x2DA0, 0x3196, 0x3393, 0x32C4, 0x2F49, 0x27DF, 0x1CB0, 0x109B,
    0x0578, 0xFE0E, 0xF965, 0xF7A3, 0xF9F4, 0xFE40, 0x006A, 0xFE11, 0xFAF6, 0xF6CB, 0xF13E, 0xEB1B, 0xE483, 0xE027, 0xDE38, 0xDCB7,
    0xDBF6, 0xDD3E, 0xE27B, 0xEA68, 0xF1D4, 0xF850, 0xFC55, 0xFDE4, 0xFF0A, 0x02AF, 0x09B1, 0x1099, 0x1662, 0x1C77, 0x2101, 0x236F,
    0x2243, 0x1C18, 0x13EA, 0x0BCB, 0x05A3, 0x021E, 0x03A0, 0x0948, 0x0E37, 0x104B, 0x0EB0, 0x0BAA, 0x0893, 0x0524, 0x02AF, 0x03F2,
    0x0969, 0x102C, 0x145E, 0x172C, 0x1A29, 0x1E12, 0x224F, 0x259C, 0x27B5, 0x2760, 0x25CD, 0x25CC, 0x27A2, 0x28DB, 0x2960, 0x286F,
    0x253C, 0x1F79, 0x1609, 0x08BA, 0xFAA2, 0xEEFB, 0xE68C, 0xE0A0, 0xDEDC, 0xE037, 0xE140, 0xE008, 0xDC63, 0xD8F0, 0xD4B3, 0xD010,
    0xCC34, 0xC8A8, 0xC7C3, 0xC85A, 0xC84E, 0xC9B9, 0xCDB8, 0xD4B3, 0xDBF7, 0xE221, 0xE5BB, 0xE5C8, 0xE6B9, 0xE938, 0xEFCC, 0xF933,
    0x01ED, 0x0B1F, 0x12E1, 0x1829, 0x1997, 0x16E7, 0x10E7, 0x0A98, 0x066E, 0x03BD, 0x044B, 0x09C6, 0x0F4F, 0x1295, 0x13AD, 0x120A,
    0x0FB8, 0x0C27, 0x09C5, 0x098F, 0x0DE9, 0x1585, 0x1B36, 0x207F, 0x2601, 0x2C43, 0x32E8, 0x37C6, 0x3B33, 0x3BBF, 0x3A1B, 0x38EB,
    0x3880, 0x385F, 0x36D3, 0x34D4, 0x3272, 0x2E2B, 0x269A, 0x1A50, 0x0B44, 0xFDB8, 0xF204, 0xE85B, 0xE2F8, 0xE194, 0xE2B6, 0xE257,
    0xDF97, 0xDC7A, 0xD96C, 0xD565, 0xD0D2, 0xCCEE, 0xCB44, 0xCB9F, 0xCB85, 0xCC28, 0xCEF5, 0xD516, 0xDBDF, 0xE0B1, 0xE4AB, 0xE49C,
    0xE25B, 0xE171, 0xE39E, 0xEA31, 0xF243, 0xFAB0, 0x0131, 0x0482, 0x0524, 0x017C, 0xFAEE, 0xF3D4, 0xEE5E, 0xEA8E, 0xE8F4, 0xEBED,
    0xF179, 0xF70D, 0xFAC2, 0xFB5C, 0xFAAD, 0xF9E3, 0xF89E, 0xF8C2, 0xFADE, 0x007D, 0x063C, 0x0BB9, 0x11B3, 0x172D, 0x1D71, 0x22DC,
    0x27F4, 0x2AD8, 0x2AD1, 0x2AF3, 0x2CD2, 0x2F95, 0x30F5, 0x3193, 0x31F6, 0x30BD, 0x2E00, 0x2836, 0x1E81, 0x13B6, 0x08F4, 0xFDEA,
    0xF6E3, 0xF4EE, 0xF6CD, 0xFA9C, 0xFDA4, 0xFF4A, 0xFE4B, 0xFBDB, 0xF74A, 0xF1D8, 0xEFA8, 0xF092, 0xF2AA, 0xF4F5, 0xF863, 0xFE08,
    0x042E, 0x09FA, 0x0EB0, 0x1027, 0x0E78, 0x0C4B, 0x0D30, 0x1205, 0x18DC, 0x1FF8, 0x2592, 0x29FA, 0x2BB0, 0x2839, 0x20CF, 0x17B3,
    0x0E29, 0x03BA, 0xFAF4, 0xF686, 0xF500, 0xF462, 0xF380, 0xF18E, 0xEFAE, 0xED0B, 0xE9DB, 0xE7B6, 0xE7AD, 0xEB2B, 0xEF7C, 0xF272,
    0xF629, 0xF9E4, 0xFE3E, 0x0302, 0x0727, 0x0A19, 0x0B40, 0x0C8A, 0x0FAE, 0x13F7, 0x185A, 0x1A97, 0x1B50, 0x1D19, 0x1C7C, 0x1912,
    0x116C, 0x073B, 0xFC88, 0xF17C, 0xE969, 0xE554, 0xE5DF, 0xE85F, 0xEABA, 0xEBE6, 0xEA70, 0xE6B1, 0xE0E5, 0xD920, 0xD439, 0xD39D,
    0xD46D, 0xD70B, 0xDAA2, 0xDF48, 0xE4E6, 0xEAC7, 0xF073, 0xF477, 0xF62E, 0xF687, 0xF913, 0xFF98, 0x07F1, 0x1197, 0x19ED, 0x1FD1,
    0x2443, 0x2431, 0x1EF9, 0x165D, 0x0C47, 0x01A7, 0xF769, 0xF0A5, 0xEEB9, 0xEF3E, 0xF023, 0xEFB8, 0xEEAE, 0xED77, 0xEA2F, 0xE732,
    0xE62E, 0xE7A4, 0xEAE0, 0xEDFD, 0xF1EC, 0xF794, 0xFDFC, 0x05BC, 0x0E7B, 0x16B2, 0x1BC8, 0x1EBB, 0x2212, 0x251A, 0x290A, 0x2CDD,
    0x2F59, 0x310A, 0x311F, 0x2E99, 0x2832, 0x1E67, 0x137C, 0x06D9, 0xF9C6, 0xEF84, 0xEAB0, 0xEB0E, 0xECD1, 0xEF98, 0xF0E9, 0xEFF9,
    0xEB63, 0xE364, 0xDCA7, 0xD816, 0xD6EB, 0xD735, 0xD896, 0xDB58, 0xDE64, 0xE1CE, 0xE610, 0xEA23, 0xEDD6, 0xF13E, 0xF608, 0xFF2D,
    0x099A, 0x1440, 0x1DB4, 0x2559, 0x2C7E, 0x30AF, 0x3077, 0x2D58, 0x276E, 0x1FC3, 0x1687, 0x0F5F, 0x0BFF, 0x0B3D, 0x0C3B, 0x0BCB,
    0x09E4, 0x0860, 0x05C8, 0x0134, 0xFCE6, 0xFBE1, 0xFECA, 0x0147, 0x03E4, 0x06E8, 0x0A60, 0x0F71, 0x15D1, 0x1CDF, 0x2215, 0x2385,
    0x241A, 0x25E4, 0x2846, 0x2BA5, 0x2D22, 0x2E67, 0x2FBC, 0x2F37, 0x2BA6, 0x23C0, 0x18D8, 0x0B37, 0xFD5F, 0xF126, 0xE94F, 0xE822,
    0xE973, 0xE9DA, 0xE8A0, 0xE5A3, 0xE0E2, 0xD8A8, 0xD01B, 0xCAFE, 0xC8AC, 0xC8F4, 0xC9B0, 0xCB68, 0xCDED, 0xCF96, 0xD27A, 0xD591,
    0xD77B, 0xD950, 0xDB75, 0xDF90, 0xE5CC, 0xEE34, 0xF6E4, 0xFE8D, 0x076C, 0x0E11, 0x1241, 0x138F, 0x1119, 0x0C8C, 0x0603, 0xFF57,
    0xFC05, 0xFC95, 0x001E, 0x0497, 0x07D9, 0x0985, 0x0965, 0x076C, 0x0474, 0x03CF, 0x057E, 0x08BA, 0x0C5D, 0x0F6D, 0x12ED, 0x1788,
    0x1F1A, 0x286C, 0x30CC, 0x3680, 0x37FA, 0x38B0, 0x39DF, 0x3A7B, 0x3B21, 0x3B17, 0x3B97, 0x3B60, 0x3782, 0x3016, 0x2597, 0x17AE,
    0x07F6, 0xF9C4, 0xEF7E, 0xEAC7, 0xE9FC, 0xE959, 0xE6A7, 0xE266, 0xDCCA, 0xD4FF, 0xCC88, 0xC6DC, 0xC4CB, 0xC476, 0xC5ED, 0xC761,
    0xCA4D, 0xCD06, 0xCF8C, 0xD4AA, 0xD8AD, 0xDBD8, 0xDE2B, 0xE206, 0xE86A, 0xEFCD, 0xF7C6, 0xFEA7, 0x05A2, 0x0C31, 0x0FAD, 0x1102,
    0x0F29, 0x0A66, 0x02EA, 0xF8BC, 0xF09F, 0xEBCC, 0xEA97, 0xEB58, 0xEC1C, 0xEE41, 0xEF8B, 0xEF45, 0xED97, 0xEBA3, 0xECAF, 0xEE7A,
    0xF0D8, 0xF458, 0xF72A, 0xFB1E, 0x0134, 0x09D5, 0x1297, 0x1926, 0x1D84, 0x1F66, 0x216E, 0x2478, 0x2774, 0x2A8E, 0x2DFA, 0x3126,
    0x32FD, 0x3153, 0x2C3F, 0x2461, 0x19AF, 0x0E5C, 0x04CB, 0x003C, 0xFF74, 0x00A7, 0x0177, 0x0069, 0xFE8A, 0xFAB2, 0xF4ED, 0xF04A,
    0xEE52, 0xEEA0, 0xF093, 0xF208, 0xF284, 0xF2D1, 0xF491, 0xF892, 0xFD84, 0x01E9, 0x044D, 0x0648, 0x090F, 0x0D8F, 0x12F1, 0x17CF,
    0x1D9B, 0x2373, 0x2792, 0x296E, 0x29F2, 0x27EB, 0x21BB, 0x1929, 0x0FAE, 0x0822, 0x0361, 0x005E, 0xFDCC, 0xFBF4, 0xFAE0, 0xF84C,
    0xF44A, 0xF044, 0xEDE5, 0xED9E, 0xEE9E, 0xF07F, 0xF2C9, 0xF5C4, 0xF8E8, 0xFEC9, 0x0590, 0x0AEB, 0x0E4C, 0x0E71, 0x0E6B, 0x0FDE,
    0x111D, 0x1382, 0x16C5, 0x1A1B, 0x1C0F, 0x1A45, 0x158F, 0x0D6A, 0x0379, 0xF8FA, 0xEEFE, 0xE994, 0xE880, 0xE967, 0xEA31, 0xEA88,
    0xEA4F, 0xE723, 0xE1CC, 0xDCC3, 0xD9FF, 0xD8F3, 0xD8C3, 0xD8BA, 0xD80A, 0xD6A8, 0xD647, 0xD8C7, 0xDD00, 0xE30A, 0xE72A, 0xEB00,
    0xF06B, 0xF64E, 0xFDC0, 0x0579, 0x0DED, 0x1714, 0x1F18, 0x248E, 0x26DA, 0x25FE, 0x225C, 0x1A28, 0x0F85, 0x0547, 0xFD43, 0xF84D,
    0xF4AB, 0xF382, 0xF3A7, 0xF38C, 0xF1D3, 0xEE3D, 0xEACF, 0xE834, 0xE680, 0xE5EA, 0xE664, 0xE760, 0xEA4C, 0xEF88, 0xF787, 0xFF01,
    0x0465, 0x089A, 0x0C02, 0x112C, 0x1750, 0x1D69, 0x23A1, 0x29A0, 0x2DF3, 0x2F41, 0x2DE3, 0x2A28, 0x23DC, 0x1B65, 0x1152, 0x0871,
    0x0220, 0xFE24, 0xFB0B, 0xF7CC, 0xF635, 0xF4B5, 0xF29E, 0xEFEA, 0xEE26, 0xEE78, 0xEE2E, 0xED10, 0xEB6F, 0xE7BB, 0xE389, 0xE126,
    0xE188, 0xE37A, 0xE525, 0xE6B5, 0xE794, 0xEAAB, 0xEFB2, 0xF545, 0xFD32, 0x0612, 0x0EED, 0x1651, 0x1B4B, 0x1E45, 0x1E3C, 0x196D,
    0x133B, 0x0D15, 0x06C5, 0x03F8, 0x03BB, 0x050F, 0x0849, 0x0C18, 0x0E0F, 0x0D12, 0x0C0F, 0x0BCC, 0x0B73, 0x0D07, 0x0F5E, 0x1229,
    0x14FC, 0x1845, 0x1DAA, 0x2383, 0x2762, 0x2906, 0x29C0, 0x2BA0, 0x2E12, 0x2FC4, 0x3149, 0x3238, 0x330A, 0x3150, 0x2C9A, 0x278D,
    0x2032, 0x173A, 0x0C51, 0x0117, 0xF894, 0xF1D0, 0xEC62, 0xE7BC, 0xE52F, 0xE3CF, 0xE13D, 0xDE08, 0xDAB1, 0xD8ED, 0xD8A7, 0xD7E5,
    0xD6E4, 0xD4EF, 0xD246, 0xD12F, 0xD1BD, 0xD53A, 0xD931, 0xDC0B, 0xDEE8, 0xE170, 0xE5E6, 0xE98C, 0xEDB0, 0xF36E, 0xFA34, 0x019C,
    0x0731, 0x0B46, 0x0BCA, 0x0945, 0x02E5, 0xFA8A, 0xF404, 0xEF59, 0xEDED, 0xEFB2, 0xF362, 0xF7FB, 0xFC02, 0xFDE9, 0xFE01, 0xFDDF,
    0xFEAB, 0x00DE, 0x0488, 0x080A, 0x0AE5, 0x0ED2, 0x150D, 0x1D2F, 0x24F4, 0x2A17, 0x2E04, 0x328F, 0x383B, 0x3D66, 0x40EC, 0x4269,
    0x428F, 0x4141, 0x3D99, 0x3864, 0x3209, 0x2A3A, 0x1FD2, 0x1408, 0x08E3, 0xFF62, 0xF7C5, 0xF147, 0xEC71, 0xE9F4, 0xE762, 0xE377,
    0xDF03, 0xDA3C, 0xD60F, 0xD2B3, 0xCFC8, 0xCCE5, 0xCA31, 0xC8CD, 0xC9F7, 0xCDD8, 0xD2A1, 0xD6E5, 0xDB48, 0xDEED, 0xE389, 0xE880,
    0xEDCB, 0xF4AA, 0xFC91, 0x04C8, 0x0B92, 0x1015, 0x11C4, 0x0F64, 0x08DE, 0xFEFC, 0xF3C6, 0xEB7F, 0xE5B8, 0xE2F5, 0xE357, 0xE61B,
    0xE9BD, 0xE9DF, 0xE8FE, 0xE899, 0xE8CD, 0xEA94, 0xEDCD, 0xF1E1, 0xF512, 0xF7E6, 0xFC0D, 0x01BC, 0x08E4, 0x1033, 0x161B, 0x1C8B,
    0x23B3, 0x29E9, 0x2DF3, 0x304E, 0x3228, 0x32FB, 0x32BC, 0x319B, 0x2FCC, 0x2C85, 0x25F0, 0x1B42, 0x1007, 0x0654, 0xFDE6, 0xF73D,
    0xF333, 0xF26B, 0xF2F9, 0xF2C9, 0xF190, 0xEFBB, 0xEDA7, 0xEC19, 0xEB3C, 0xEAC2, 0xEA13, 0xE943, 0xE9CC, 0xED41, 0xF366, 0xF992,
    0xFE8C, 0x038B, 0x098C, 0x0FC7, 0x1631, 0x1CAD, 0x2372, 0x2A83, 0x3053, 0x353C, 0x389F, 0x392F, 0x358E, 0x2D04, 0x222F, 0x181F,
    0x1089, 0x0A83, 0x0693, 0x04EA, 0x0403, 0x017F, 0xFCCD, 0xF62B, 0xEF94, 0xEC3F, 0xEB12, 0xEBC2, 0xECC3, 0xEC95, 0xED2A, 0xEFA2,
    0xF515, 0xFBF7, 0x021C, 0x074F, 0x0C0B, 0x1070, 0x1390, 0x150D, 0x1609, 0x15E9, 0x15B0, 0x164F, 0x15DA, 0x14EB, 0x1101, 0x0901,
    0xFE59, 0xF36A, 0xEAA5, 0xE346, 0xDE81, 0xDCF6, 0xDDB6, 0xDEFD, 0xDF76, 0xDF19, 0xDE19, 0xDC51, 0xDB08, 0xDA0D, 0xD7E1, 0xD536,
    0xD381, 0xD4A3, 0xD8C1, 0xDDC7, 0xE208, 0xE584, 0xE968, 0xEE2E, 0xF367, 0xFA32, 0x0244, 0x0BBC, 0x15A0, 0x1DDB, 0x24C6, 0x290E,
    0x2863, 0x2283, 0x189D, 0x0E7D, 0x065F, 0xFFCB, 0xFBB7, 0xFA8C, 0xFB83, 0xFB38, 0xF8E6, 0xF618, 0xF2E2, 0xF13C, 0xF17A, 0xF2A0,
    0xF3DA, 0xF354, 0xF1D3, 0xF1BA, 0xF47B, 0xF9DD, 0xFFF0, 0x0596, 0x0B2C, 0x102F, 0x1385, 0x155A, 0x1741, 0x197B, 0x1BE6, 0x1EA2,
    0x219E, 0x243C, 0x23DF, 0x1ECE, 0x14CC, 0x0887, 0xFD42, 0xF342, 0xEC33, 0xE87F, 0xE730, 0xE76E, 0xE76E, 0xE675, 0xE4C7, 0xE2F8,
    0xE1EA, 0xE17B, 0xE154, 0xE0FF, 0xE02D, 0xE0B1, 0xE2CF, 0xE6D8, 0xEA53, 0xEC41, 0xEDCB, 0xEF69, 0xF1FF, 0xF5D1, 0xFBF2, 0x035D,
    0x0BEB, 0x13EB, 0x1B1F, 0x20D9, 0x2300, 0x2122, 0x1A0F, 0x109F, 0x077E, 0xFF84, 0xFA37, 0xF748, 0xF76E, 0xF8EB, 0xFA11, 0xFB32,
    0xFAD3, 0xF9FF, 0xFAF8, 0xFCE4, 0xFF5D, 0x017A, 0x0262, 0x03E6, 0x07FE, 0x0FEF, 0x187B, 0x206A, 0x27EC, 0x2C9C, 0x2F52, 0x302F,
    0x30CE, 0x31BE, 0x3216, 0x32D6, 0x3344, 0x33E4, 0x332B, 0x2E11, 0x24E1, 0x1851, 0x0AEE, 0xFEB3, 0xF3E1, 0xECCD, 0xE8D8, 0xE687,
    0xE5DB, 0xE454, 0xE102, 0xDC9C, 0xD88F, 0xD621, 0xD36D, 0xD11C, 0xCE5C, 0xCC01, 0xCC6F, 0xCEC4, 0xD227, 0xD510, 0xD744, 0xDA07,
    0xDCDD, 0xE0C7, 0xE60A, 0xED01, 0xF4CD, 0xFBCA, 0x01B6, 0x05F8, 0x0903, 0x0809, 0x0224, 0xF9BB, 0xF0DF, 0xE8DD, 0xE22D, 0xDE87,
    0xDDF7, 0xDF63, 0xE1E0, 0xE450, 0xE690, 0xE8F9, 0xEACA, 0xEE3E, 0xF2D0, 0xF648, 0xF8FC, 0xFB70, 0xFFD9, 0x0773, 0x10AF, 0x1AA3,
    0x2301, 0x2B1C, 0x3342, 0x3788, 0x39C2, 0x3CA8, 0x40EC, 0x44CF, 0x4759, 0x4978, 0x49F9, 0x45B2, 0x3D32, 0x309D, 0x20EC, 0x11D2,
    0x03C0, 0xF942, 0xF37C, 0xF03D, 0xEEE2, 0xED51, 0xEAF6, 0xE6AE, 0xE02C, 0xDB17, 0xD605, 0xD19E, 0xCD0E, 0xC8A8, 0xC7C1, 0xC8AD,
    0xCB1E, 0xCE02, 0xD0B5, 0xD42F, 0xD80A, 0xDC74, 0xE2C9, 0xEA73, 0xF440, 0xFDBB, 0x061C, 0x0DAE, 0x1326, 0x1680, 0x1510, 0x1011,
    0x08AC, 0xFFA5, 0xF67C, 0xEDEC, 0xE877, 0xE5F8, 0xE532, 0xE546, 0xE56B, 0xE4F8, 0xE322, 0xE17C, 0xE11D, 0xE0E5, 0xE05C, 0xE047,
    0xE281, 0xE947, 0xF279, 0xFC2A, 0x055B, 0x0CB9, 0x12D1, 0x16C1, 0x19C4, 0x1DE4, 0x22AD, 0x27BA, 0x2BFA, 0x2F62, 0x32CB, 0x3412,
    0x3179, 0x2B0F, 0x21A1, 0x16DE, 0x0B97, 0x0179, 0xFB66, 0xF869, 0xF7FB, 0xF92D, 0xF9CC, 0xF8D5, 0xF5C7, 0xF20C, 0xEED1, 0xECCF,
    0xEAC4, 0xE7AB, 0xE632, 0xE757, 0xEA12, 0xEDE7, 0xF170, 0xF53A, 0xF9DB, 0xFEEB, 0x0450, 0x0B53, 0x1483, 0x1E36, 0x2636, 0x2C3F,
    0x31E2, 0x3601, 0x36AF, 0x32DF, 0x2D35, 0x256E, 0x1C0B, 0x13A4, 0x0D17, 0x0A48, 0x0A3A, 0x0BB3, 0x0D1E, 0x0C8E, 0x0B3A, 0x075C,
    0x02CF, 0xFEDB, 0xF9CE, 0xF613, 0xF346, 0xF479, 0xF9C8, 0xFFA2, 0x0696, 0x0CE9, 0x121F, 0x1556, 0x1659, 0x17B3, 0x1941, 0x1C44,
    0x1F81, 0x21EC, 0x24FA, 0x25CA, 0x22EA, 0x1BA1, 0x105A, 0x02EA, 0xF4C2, 0xE869, 0xDF1B, 0xDA68, 0xD9EF, 0xDACA, 0xDBE5, 0xDBE8,
    0xDAAA, 0xD8B3, 0xD748, 0xD724, 0xD71D, 0xD64C, 0xD4E7, 0xD51A, 0xD68E, 0xD870, 0xDA80, 0xDC2C, 0xDF45, 0xE416, 0xE989, 0xF001,
    0xF795, 0x00D1, 0x0991, 0x1283, 0x1C08, 0x244B, 0x2A90, 0x2B96, 0x288D, 0x2272, 0x19A2, 0x1081, 0x07C4, 0x02CA, 0x00D1, 0x0181,
    0x04B4, 0x0508, 0x03EE, 0x0064, 0xFC1B, 0xF97D, 0xF5F3, 0xF347, 0xF10B, 0xF11A, 0xF515, 0xFAC6, 0x01E6, 0x0764, 0x0B74, 0x0E4E,
    0x0EA1, 0x0FA5, 0x119B, 0x156F, 0x1A6B, 0x1F7D, 0x2503, 0x299E, 0x2BD2, 0x293D, 0x2338, 0x1ADA, 0x1082, 0x065D, 0xFD13, 0xF69B,
    0xF2C8, 0xF0EC, 0xF054, 0xEE78, 0xEB41, 0xE6F7, 0xE26B, 0xDF44, 0xDCEA, 0xDBFC, 0xDA17, 0xD8CB, 0xDA23, 0xDCB5, 0xDFE5, 0xE26F,
    0xE67E, 0xEB46, 0xF055, 0xF4A7, 0xF85F, 0xFD8E, 0x0200, 0x0779, 0x0EA2, 0x1610, 0x1D75, 0x215B, 0x20D4, 0x1C09, 0x1339, 0x08ED,
    0xFDF1, 0xF6D8, 0xF47E, 0xF59C, 0xFA2D, 0xFD86, 0xFFB2, 0xFFEF, 0xFE57, 0xFE45, 0xFE63, 0xFEE0, 0xFEB5, 0xFFAC, 0x04B9, 0x0ABB,
    0x12F2, 0x1A69, 0x20A3, 0x26E6, 0x2AE7, 0x2E8E, 0x316B, 0x3561, 0x3A07, 0x3DDC, 0x423D, 0x4595, 0x4756, 0x44F1, 0x3D6F, 0x339C,
    0x2606, 0x1714, 0x0916, 0xFD32, 0xF575, 0xF02C, 0xED9F, 0xEBC6, 0xE933, 0xE5C2, 0xE14B, 0xDE96, 0xDC0D, 0xD983, 0xD6CC, 0xD292,
    0xCF67, 0xCE1B, 0xCE50, 0xCFAA, 0xD224, 0xD649, 0xDAF6, 0xDFFF, 0xE54C, 0xEB1A, 0xF1CE, 0xF8B4, 0x0133, 0x0AF1, 0x14EC, 0x1C04,
    0x1E67, 0x1B33, 0x125F, 0x0766, 0xFB65, 0xF168, 0xEBAF, 0xE8FD, 0xE99E, 0xEB02, 0xEADC, 0xE921, 0xE59A, 0xE356, 0xE289, 0xE3E5,
    0xE607, 0xE812, 0xEC20, 0xF18A, 0xF942, 0x0169, 0x0817, 0x0EB8, 0x13FC, 0x1845, 0x1C9D, 0x219E, 0x285D, 0x2F51, 0x372A, 0x3EA3,
    0x44EB, 0x4963, 0x48E9, 0x450C, 0x3DD1, 0x33F1, 0x2941, 0x1EEB, 0x15C3, 0x0E2A, 0x08FA, 0x057F, 0x0237, 0xFE59, 0xF8DF, 0xF411,
    0xF084, 0xEBF9, 0xE59F, 0xDDD5, 0xD65A, 0xD0E9, 0xCE1A, 0xCCDF, 0xCD77, 0xCFCD, 0xD228, 0xD4D4, 0xD833, 0xDC09, 0xE101, 0xE6A8,
    0xEDA5, 0xF6B6, 0x016D, 0x0A56, 0x0F60, 0x109D, 0x0CB8, 0x05A3, 0xFD12, 0xF56A, 0xF126, 0xEFE1, 0xF10A, 0xF357, 0xF574, 0xF4AC,
    0xF0DF, 0xED07, 0xE9F5, 0xE8D2, 0xE866, 0xE73F, 0xE732, 0xE89F, 0xEC10, 0xF0D0, 0xF59E, 0xFB04, 0xFFEB, 0x0531, 0x0906, 0x0CFF,
    0x12AB, 0x176E, 0x1C8E, 0x21C2, 0x263E, 0x29A1, 0x2A5D, 0x2785, 0x20CF, 0x1783, 0x0D6B, 0x0348, 0xFB33, 0xF4F6, 0xF1B8, 0xF0CD,
    0xF07F, 0xF16E, 0xF1EC, 0xF1BA, 0xF1FD, 0xF227, 0xF047, 0xEC5A, 0xE836, 0xE477, 0xE2FB, 0xE3FC, 0xE67C, 0xEA91, 0xEF5D, 0xF46B,
    0xF8F5, 0xFE89, 0x055F, 0x0D3C, 0x1678, 0x2006, 0x2A3E, 0x3351, 0x38C7, 0x3A44, 0x36DF, 0x2EDB, 0x2507, 0x1B7E, 0x13AF, 0x0E6C,
    0x0D61, 0x0E1A, 0x0FBD, 0x110E, 0x0F20, 0x0C56, 0x09EA, 0x0828, 0x0761, 0x05BC, 0x03CD, 0x01DC, 0x0098, 0x0099, 0x0164, 0x0454,
    0x06AB, 0x08BC, 0x0AB5, 0x0BDD, 0x0F21, 0x125D, 0x14C2, 0x176B, 0x1AC5, 0x1D5A, 0x1D9E, 0x1C3B, 0x17C7, 0x1008, 0x0698, 0xFB3C,
    0xF0A1, 0xE7BB, 0xE023, 0xDBB3, 0xD980, 0xD909, 0xD8DE, 0xD7DB, 0xD6BB, 0xD648, 0xD62E, 0xD43A, 0xD121, 0xCEBB, 0xCDC0, 0xCEE9,
    0xD1E6, 0xD565, 0xD933, 0xDCCF, 0xDF0A, 0xE184, 0xE5CF, 0xEBCC, 0xF28B, 0xF9D3, 0x01F9, 0x0AE5, 0x1219, 0x15A1, 0x15C5, 0x1297,
    0x0BF5, 0x04D7, 0xFEA2, 0xF910, 0xF691, 0xF62A, 0xF663, 0xF7CA, 0xF81D, 0xF6E4, 0xF5C9, 0xF5FF, 0xF7D8, 0xF8F0, 0xFA94, 0xFB17,
    0xFC8C, 0xFF47, 0x02A0, 0x05F1, 0x0A8A, 0x0C96, 0x142B, 0x2154, 0x2192, 0x2234, 0x23E2, 0x2415, 0x2453, 0x26AC, 0x2715, 0x27F3,
    0x27EC, 0x2277, 0x1CC2, 0x10E7, 0x06E5, 0xFC63, 0xF4FE, 0xEDA0, 0xEE81, 0xEDEC, 0xEE8E, 0xEC78, 0xDDB6, 0xEA33, 0xF10F, 0xEC79,
    0xE9CF, 0xE629, 0xE533, 0xE3CB, 0xE4E1, 0xE4DF, 0xEB3C, 0xEC8F, 0xEDC7, 0xF08C, 0xF970, 0x027B, 0x060A, 0x090C, 0x0B96, 0x10AD,
    0x13BB, 0x19D4, 0x1243, 0x0A74, 0x0897, 0x006D, 0xFC62, 0xF895, 0xF629, 0xF4CA, 0xF333, 0xF139, 0xF0F0, 0xF5BD, 0xF6E2, 0xF8BD,
    0xFDE5, 0x02C0, 0x087F, 0x0D48, 0x11DA, 0x15F4, 0x1A66, 0x1D1A, 0x1F53, 0x2226, 0x25BB, 0x2760, 0x2A6B, 0x2D1C, 0x2CFF, 0x2D62,
    0x2C0B, 0x2BE5, 0x2ACA, 0x299B, 0x280A, 0x2512, 0x22B9, 0x1D78, 0x1731, 0x10F2, 0x0AB9, 0x058A, 0xFF68, 0xFC8B, 0xFBA0, 0xFACF,
    0xFAFF, 0xFA96, 0xF989, 0xF8B4, 0xF694, 0xF512, 0xF53A, 0xF58A, 0xF452, 0xF201, 0xF0DA, 0xEEA0, 0xEE25, 0xED60, 0xED2F, 0xEED6,
    0xF14C, 0xF33A, 0xF495, 0xF69F, 0xF6E6, 0xF6BF, 0xF5BF, 0xF414, 0xF376, 0xF28D, 0xF1A9, 0xF1B3, 0xF1C9, 0xF1C3, 0xF07C, 0xEF11,
    0xED96, 0xECE0, 0xED93, 0xEE3C, 0xF174, 0xF65A, 0xFB3B, 0x01C6, 0x0752, 0x0D8B, 0x135C, 0x178D, 0x1B7F, 0x1F04, 0x2351, 0x2618,
    0x28F3, 0x2B9D, 0x2D16, 0x2E69, 0x2DC0, 0x2C07, 0x2B1B, 0x292F, 0x2733, 0x257C, 0x2309, 0x1F5B, 0x1AF1, 0x15E3, 0x0F2C, 0x0A37,
    0x06E7, 0x0396, 0x0205, 0x00C2, 0xFF1F, 0xFD54, 0xFB2D, 0xF932, 0xF79B, 0xF68E, 0xF4BE, 0xF422, 0xF29A, 0xEF12, 0xEBA2, 0xE743,
    0xE387, 0xE17C, 0xE176, 0xE2A3, 0xE51C, 0xE892, 0xEAFA, 0xEC80, 0xED71, 0xED45, 0xECBD, 0xEB93, 0xEAA6, 0xEB1D, 0xEAE5, 0xEB4D,
    0xEC72, 0xED57, 0xEDE1, 0xEED2, 0xF036, 0xF0AD, 0xF1BB, 0xF2E5, 0xF506, 0xF8DB, 0xFCB8, 0x009B, 0x03BA, 0x0684, 0x07C1, 0x087D,
    0x0925, 0x094E, 0x0B13, 0x0C64, 0x0D90, 0x0F96, 0x1094, 0x112F, 0x1204, 0x129C, 0x12A4, 0x127C, 0x11F9, 0x0FB1, 0x0D06, 0x098B,
    0x04AB, 0x00D6, 0xFD6A, 0xFA9C, 0xF95F, 0xF8CB, 0xF8E3, 0xF924, 0xF948, 0xF8B3, 0xF7EA, 0xF7C1, 0xF772, 0xF8AA, 0xFA59, 0xFBAB,
    0xFD82, 0xFD18, 0xFA8C, 0xF76B, 0xF505, 0xF351, 0xF38E, 0xF57B, 0xF7A1, 0xFB82, 0xFF2E, 0x01BD, 0x03D2, 0x054C, 0x05D0, 0x062B,
    0x0697, 0x06BB, 0x06B2, 0x063F, 0x0505, 0x0466, 0x03DA, 0x02E8, 0x0370, 0x03B1, 0x049C, 0x06F4, 0x0A16, 0x0E64, 0x143A, 0x1A63,
    0x1E76, 0x218A, 0x234B, 0x22E0, 0x2274, 0x21CD, 0x20DB, 0x208B, 0x1FBE, 0x1E83, 0x1CD0, 0x1A03, 0x16A2, 0x13C6, 0x10B0, 0x0CDA,
    0x0983, 0x0576, 0xFFDD, 0xF9A2, 0xF2BD, 0xEBAE, 0xE5E6, 0xE101, 0xDD02, 0xDA97, 0xD918, 0xD75F, 0xD685, 0xD529, 0xD341, 0xD29D,
    0xD193, 0xD1CF, 0xD38F, 0xD4D6, 0xD56A, 0xD589, 0xD5BA, 0xD53B, 0xD59D, 0xD6E1, 0xD8A4, 0xDC97, 0xE089, 0xE452, 0xE878, 0xEB82,
    0xED58, 0xEE75, 0xEE9A, 0xEE96, 0xEF93, 0xF02B, 0xF01A, 0xF101, 0xF191, 0xF160, 0xF1BA, 0xF0DF, 0xEFBE, 0xEF5C, 0xEF1B, 0xEF59,
    0xF0CF, 0xF383, 0xF600, 0xF9C8, 0xFD2C, 0xFFDE, 0x0241, 0x0332, 0x03EF, 0x04E8, 0x0600, 0x06B8, 0x07F9, 0x085B, 0x07A4, 0x06BE,
    0x04E8, 0x032A, 0x02C9, 0x0237, 0x00CC, 0xFE6B, 0xFA7F, 0xF5A2, 0xF03F, 0xEAB8, 0xE638, 0xE42B, 0xE3B8, 0xE3EC, 0xE640, 0xE866,
    0xE9E4, 0xEB4D, 0xEB9D, 0xEC61, 0xED65, 0xEE32, 0xEEBC, 0xEEF1, 0xEE23, 0xEBCB, 0xE977, 0xE653, 0xE39B, 0xE2E4, 0xE33D, 0xE55B,
    0xE905, 0xEC95, 0xEF62, 0xF21A, 0xF3E1, 0xF468, 0xF4D2, 0xF425, 0xF312, 0xF30A, 0xF2A9, 0xF23B, 0xF25F, 0xF1B0, 0xF0F5, 0xF00B,
    0xEE84, 0xED6C, 0xED94, 0xEEF3, 0xF0CF, 0xF3F8, 0xF719, 0xFA3C, 0xFE31, 0x0190, 0x04CC, 0x08F6, 0x0CED, 0x10D1, 0x14AD, 0x170D,
    0x18E3, 0x1AA5, 0x1AA3, 0x19C6, 0x19D5, 0x19FE, 0x196A, 0x18BB, 0x1780, 0x1530, 0x12DC, 0x0F2B, 0x0A1C, 0x05B3, 0x00C6, 0xFC6F,
    0xFA11, 0xF7A2, 0xF5E2, 0xF42B, 0xF19B, 0xEF5A, 0xED9A, 0xEC6C, 0xEB08, 0xEAB9, 0xEA19, 0xE8C7, 0xE835, 0xE635, 0xE41B, 0xE26A,
    0xE061, 0xDF58, 0xDF7D, 0xE0E0, 0xE2B5, 0xE54E, 0xE713, 0xE794, 0xE904, 0xE96A, 0xE926, 0xE949, 0xE8CE, 0xE8E7, 0xE9B5, 0xE9BD,
    0xE9DD, 0xEA7B, 0xEAC5, 0xE9DF, 0xE8F5, 0xE8D3, 0xE920, 0xEACE, 0xEC00, 0xEE19, 0xF127, 0xF2E6, 0xF3A6, 0xF49D, 0xF57E, 0xF759,
    0xFA6F, 0xFD62, 0x0173, 0x0681, 0x0A58, 0x0D2E, 0x103A, 0x1306, 0x15A9, 0x1856, 0x1B96, 0x1D97, 0x1FB8, 0x1F68, 0x1E00, 0x1C10,
    0x18E0, 0x1DF7, 0x209E, 0x1B25, 0x1971, 0x1B6E, 0x20BC, 0x189C, 0x11B6, 0x17AA, 0x195F, 0x11C8, 0x0DD1, 0x101F, 0x1321, 0x1219,
    0x0B97, 0x07C1, 0x028D, 0x034E, 0xFB0F, 0xF4F8, 0xF350, 0xF1A5, 0xF18C, 0xF03E, 0xEEA1, 0xEB63, 0xE8B6, 0xE906, 0xE968, 0xE6D0,
    0xE296, 0xE2AE, 0xE65B, 0xE633, 0xE396, 0xE008, 0xE07A, 0xDDDB, 0xE122, 0xDD7E, 0xDD71, 0xDEE3, 0xE663, 0xEF94, 0xF207, 0xF529,
    0xFBA2, 0x0692, 0x08AF, 0x0A00, 0x0C6B, 0x1291, 0x1A55, 0x1C0B, 0x18AC, 0x1C83, 0x1C5A, 0x1A8C, 0x1923, 0x186D, 0x1C88, 0x1EF2,
    0x19C1, 0x1A8C, 0x197D, 0x17A1, 0x123E, 0x0B81, 0x0EAE, 0x0F30, 0x0A2D, 0x0822, 0x05C0, 0x016C, 0x0506, 0xFDD7, 0x0099, 0xFFA8,
    0x0294, 0x04B0, 0x030F, 0x0409, 0x00A8, 0x04A1, 0x00D9, 0x0270, 0x0267, 0x0146, 0x04A3, 0x078D, 0x02C2, 0x0E7C, 0x12DB, 0x0FD6,
    0x0E0A, 0x1186, 0x1B4D, 0x0B21, 0x1278, 0x11EC, 0x19A1, 0x12EE, 0x1148, 0x1865, 0x0EE3, 0x0F35, 0x104F, 0x117A, 0x05DF, 0x146A,
    0x0613, 0x0E81, 0x0C83, 0x0DBF, 0x1835, 0x05DD, 0x18A2, 0x1D37, 0x1DC8, 0x264F, 0x2EC1, 0x1A5B, 0x23C9, 0x292C, 0x2344, 0x3712,
    0x189D, 0x261A, 0x3159, 0x1AA0, 0x2B5B, 0x1E08, 0x264A, 0x23D7, 0xFBCD, 0x1BE4, 0x19F6, 0xF795, 0xF8F1, 0xFF82, 0x00BE, 0xF83A,
    0xE823, 0xF72E, 0xFC66, 0xDFAE, 0xF2D0, 0xF068, 0xEF55, 0xDBC2, 0xE8F2, 0x081F, 0xD4E1, 0xCC65, 0xDF3D, 0xDB52, 0xD91E, 0xD416,
    0xD61C, 0xE445, 0xE2F0, 0xE50B, 0xEAA6, 0xE996, 0xEED8, 0xE6EC, 0xF7C8, 0xFE62, 0xF2F6, 0xF6FC, 0xFCF4, 0xF872, 0xF60F, 0xFE4B,
    0xFB30, 0xE92E, 0xE45B, 0x09EE, 0xF34B, 0x014E, 0xF309, 0xFDEA, 0x1B41, 0x0133, 0x0CCA, 0x0A3F, 0x22D4, 0x14E0, 0x0E61, 0x1E23,
    0x2EB2, 0x1150, 0x15AB, 0x289D, 0x26F4, 0x1CFF, 0x10CB, 0x33EA, 0x1A6E, 0x16FA, 0x23CA, 0x15CE, 0x1EB2, 0x08E5, 0x0934, 0x1219,
    0x0308, 0x0009, 0xFAA2, 0xEF79, 0xE82A, 0xE907, 0xD4C5, 0x059A, 0xFA5D, 0xEA88, 0xF52A, 0xE8C3, 0x05E8, 0xEF5B, 0xE9C7, 0xF392,
    0xED2C, 0xD271, 0xFA22, 0xF7C9, 0xE7A7, 0xE641, 0xEAC8, 0x101D, 0xD531, 0xFEFF, 0xFDDA, 0xF4FA, 0x0993, 0xF95B, 0x0EC5, 0x0B27,
    0x099F, 0x02BC, 0x266C, 0xFF23, 0xFDB6, 0x11A5, 0x0E3F, 0x049C, 0x093D, 0x0F13, 0xFE62, 0x1F6F, 0x18E2, 0x0A95, 0x0A01, 0x1DED,
    0x0815, 0x1DFF, 0x22E9, 0x093E, 0x1B96, 0x2094, 0x15D6, 0x207A, 0x3558, 0x1682, 0x215E, 0x36B4, 0x29B0, 0x2CE5, 0x1FDB, 0x2B74,
    0x21D4, 0x2153, 0x246E, 0x224C, 0x24FC, 0xFF52, 0x237A, 0x176B, 0x03F7, 0x016D, 0x0F7C, 0x117B, 0x0729, 0x1D75, 0x0D16, 0x0635,
    0x09C4, 0x1482, 0xF2C9, 0xF3F8, 0x00D8, 0xDF23, 0xFAEC, 0xEE6E, 0xE504, 0xEEE3, 0xF5B3, 0xE4ED, 0xEEE0, 0xFD4E, 0xD371, 0xEF90,
    0xF065, 0xF23A, 0xEADD, 0xE741, 0xE430, 0x0169, 0xF003, 0xD6AE, 0xEF0E, 0xE5FB, 0xE308, 0xE596, 0xE7A5, 0xF17E, 0xEC28, 0xF263,
    0x0710, 0xF8E6, 0xF6D3, 0x0EFD, 0x085F, 0xF73D, 0x1042, 0x0171, 0xFB9E, 0xFDDB, 0x1598, 0x0348, 0x1F62, 0x17D9, 0x0AF4, 0x13FA,
    0x317E, 0x212C, 0x0893, 0x29D3, 0x1301, 0x190A, 0x0AC2, 0x2B41, 0x08C9, 0x09DF, 0x0A13, 0x18E1, 0x0C64, 0x0224, 0x165D, 0x05B5,
    0xF867, 0x06B0, 0x2C5B, 0x05C2, 0xF51C, 0x0A1D, 0x09F5, 0x0023, 0xF62C, 0xEAA2, 0xEE12, 0xEF55, 0xE97B, 0xDEEF, 0xF08F, 0xE127,
    0xEA85, 0xEAEA, 0xE1CF, 0xD7FA, 0xF87B, 0xD9E9, 0xE48E, 0xECB9, 0xD797, 0xFC20, 0xD92E, 0xE0FE, 0xDF9C, 0xEAFD, 0xE64F, 0xE37C,
    0xDADA, 0xE970, 0xF274, 0xDE5E, 0xE28F, 0x0608, 0xF657, 0xF086, 0x0C3B, 0xFFC7, 0xFB09, 0x0DA7, 0x1182, 0x0580, 0xFA7C, 0x09D4,
    0x0935, 0x0ADA, 0x1F01, 0xF993, 0x0703, 0x0678, 0x0D62, 0x13ED, 0xEBB4, 0xFDAA, 0x08EE, 0xE508, 0xFFA6, 0xF0C8, 0xE886, 0xF7E5,
    0xE553, 0xDDDC, 0xFD0C, 0xEBD9, 0xDF02, 0xF07F, 0xEB0D, 0x065D, 0xEF13, 0xF963, 0x00FE, 0xED01, 0xFBE0, 0xFC38, 0xEB76, 0xF6C1,
    0xF4B9, 0xFEBE, 0xF1CD, 0xF849, 0x12AF, 0xF825, 0x0071, 0x17D2, 0x02FF, 0x1BE8, 0x1132, 0x1BC0, 0x1CB0, 0x0B2A, 0x2F22, 0x0F8B,
    0x1D6E, 0x2013, 0x2083, 0x1FCE, 0x0A96, 0x1A87, 0x1D82, 0x11D3, 0x1D11, 0x1413, 0x2613, 0x1E40, 0x131C, 0x42FA, 0x2F9C, 0x1CF8,
    0x368E, 0x26FF, 0x330D, 0x370D, 0x2472, 0x288F, 0x3CF0, 0x2361, 0x2F8A, 0x3D82, 0x0871, 0x2A71, 0x20AB, 0x1D69, 0x13C6, 0x0860,
    0x03C5, 0x0A47, 0xF2A9, 0xDC2A, 0xF261, 0xD9BE, 0xD61B, 0xD639, 0xDEAF, 0xDC46, 0xCB9D, 0xE5FE, 0xDCCE, 0xD36A, 0xDDED, 0xDC91,
    0xD019, 0xC5AE, 0xD9DB, 0xCE10, 0xD8FC, 0xC6B7, 0xE877, 0xCAF2, 0xCD1A, 0xE3B6, 0xCAD8, 0xEE81, 0xE093, 0xE79C, 0xDCB1, 0xFEF9,
    0x00AE, 0xEE9A, 0xF5B2, 0x0959, 0xF397, 0xEA8E, 0x0DDF, 0xF260, 0xF5CB, 0xFD4D, 0xFCDA, 0xF5B2, 0xFE11, 0xF63D, 0x00C5, 0x01C9,
    0xF570, 0x13B7, 0xFBA9, 0x0CC9, 0x026B, 0xFB33, 0x1219, 0x032F, 0x1BB4, 0x105B, 0x1639, 0x1BF7, 0x1070, 0x22D8, 0x201A, 0x1443,
    0x18F1, 0x1BF8, 0x0F36, 0x2253, 0x0F61, 0x1694, 0x1383, 0x0BAA, 0x1D1A, 0xEE55, 0x0C50, 0xFDB9, 0x0408, 0x07EB, 0x02D9, 0x1235,
    0xFD26, 0x0E0E, 0x01A9, 0x0531, 0x0253, 0xFBDA, 0xF259, 0xF8C1, 0xF8D2, 0xF1B6, 0xFB2F, 0xEFC8, 0xE7F2, 0x034F, 0xED4A, 0xECED,
    0xFBAE, 0xF45A, 0xFCB6, 0xE37D, 0x04D8, 0xF908, 0xED42, 0x064C, 0xF3C9, 0xE346, 0x0833, 0xF750, 0xE4AE, 0xF484, 0xE3D5, 0xF8C1,
    0xE57E, 0xF8CF, 0xF822, 0xF75A, 0x0287, 0xEDA5, 0xF324, 0xF250, 0xF178, 0x0189, 0x0B5C, 0x0F4B, 0x0998, 0x0570, 0x0F2B, 0x0A82,
    0x1187, 0xFE2E, 0x074C, 0x16B9, 0x15DA, 0xF63E, 0x2199, 0x3BC6, 0x1C66, 0x16E9, 0x1652, 0x1784, 0x1097, 0x1640, 0xF24F, 0x0FCF,
    0x04F8, 0xF799, 0x13B0, 0x1DED, 0x1D14, 0x230F, 0x132A, 0x18BE, 0x1DFF, 0xFF8F, 0x0FA3, 0x020F, 0xEE0A, 0xF605, 0xE229, 0xF5E2,
    0x0A74, 0xFCEC, 0x14A7, 0x0BC3, 0x198C, 0x0D62, 0x015B, 0xE0B6, 0xC35A, 0xB429, 0xB316, 0xB359, 0xBB2F, 0xC56B, 0xB732, 0xBA33,
    0xD300, 0xCE00, 0xBD9C, 0xE607, 0xE4F4, 0xF9DE, 0xE56A, 0x0986, 0xF357, 0xE64E, 0x02EA, 0xF166, 0x1088, 0x2C92, 0x3B8A, 0x3E15,
    0x5745, 0x4CE8, 0x4AC6, 0x5B46, 0x63F9, 0x40E1, 0x4FE1, 0x45D9, 0x3E94, 0x2483, 0xED45, 0xE520, 0xD798, 0xD567, 0xD776, 0xD964,
    0xD18F, 0xD4A7, 0xE451, 0xF630, 0xD9DA, 0xFA8C, 0x11DA, 0x1B52, 0x0F5D, 0x12EF, 0x243F, 0xF8FF, 0xFD48, 0x064B, 0x0BFF, 0x1E9B,
    0x3122, 0x31F4, 0x34EC, 0x348D, 0x3EC7, 0x35AD, 0x2DB3, 0x3AC9, 0x2B09, 0x1F89, 0x23ED, 0xFEE0, 0xE0EE, 0xC338, 0xB3CC, 0xB408,
    0xB974, 0xC2DE, 0xB419, 0xBE30, 0xC444, 0xC839, 0xBB15, 0xCBA7, 0xD6F4, 0xE61F, 0xE2D1, 0xE4D7, 0xF435, 0xE07E, 0xE401, 0xD75D,
    0xE96C, 0x01C4, 0x1A42, 0x2CBB, 0x2B0D, 0x40BE, 0x482B, 0x4B21, 0x5015, 0x541A, 0x4F53, 0x3CC4, 0x527F, 0x4230, 0x0B48, 0xF83F,
    0xE9BE, 0xD594, 0xD776, 0xDFCA, 0xD4F7, 0xD92C, 0xDBC5, 0xEAAD, 0xE38E, 0xE546, 0xFF30, 0x038D, 0xFBF4, 0x0770, 0x0D7F, 0xF633,
    0x0314, 0xEA24, 0xF027, 0x02F5, 0x0430, 0x265A, 0x20AE, 0x20FE, 0x27F8, 0x341A, 0x33F2, 0x3563, 0x32C3, 0x2D7F, 0x4058, 0x32B2,
    0x0ABB, 0xFD6C, 0xEE8D, 0xE48F, 0xE1CF, 0xD5DA, 0xED92, 0xED97, 0xE42C, 0xEF11, 0xF9DB, 0xF25E, 0x06EC, 0x12EA, 0x0D27, 0x1301,
    0x1917, 0x1B99, 0xFC46, 0xFACE, 0x0237, 0x0EBA, 0x1A90, 0x2D11, 0x3FA9, 0x487F, 0x48FD, 0x50A7, 0x5BBE, 0x4E44, 0x5E44, 0x50E7,
    0x4DA2, 0x5BE8, 0x359B, 0x1DC8, 0x01CE, 0xF180, 0xE576, 0xE011, 0xE67A, 0xDE4E, 0xDD2C, 0xD7F9, 0xE519, 0xDA94, 0xDF0E, 0xF110,
    0xEDE6, 0xE7A1, 0xF342, 0xFC61, 0xDA5F, 0xE023, 0xD78F, 0xD103, 0xE065, 0xE978, 0xF48F, 0xF6BD, 0xF770, 0x0104, 0x0751, 0xFF8E,
    0x09E5, 0xFD42, 0x08CD, 0x0CA2, 0xF52E, 0xE684, 0xD055, 0xC892, 0xCA6A, 0xBEA8, 0xC53E, 0xD2D7, 0xCBF8, 0xCED3, 0xDD3D, 0xDB80,
    0xD719, 0xF24A, 0xEF06, 0xF6AE, 0x015B, 0x11D1, 0x0CCE, 0xF64E, 0x0467, 0x090C, 0x1938, 0x1EFE, 0x3B5B, 0x4C4E, 0x450A, 0x537D,
    0x543D, 0x5DD4, 0x62E0, 0x5223, 0x561A, 0x5C0E, 0x5694, 0x4123, 0x23C4, 0x0FED, 0x0283, 0xF575, 0xE8BF, 0xF5D4, 0xF01F, 0xE51C,
    0xF8DE, 0xF003, 0xE676, 0xF124, 0xFE4B, 0xFEB5, 0xFB93, 0x07B5, 0x0480, 0xFA2D, 0xEED7, 0xEB4F, 0xF136, 0xF521, 0xFFEB, 0x1012,
    0x1261, 0x16EA, 0x1B4B, 0x2583, 0x27FE, 0x1C3E, 0x20D3, 0x2B26, 0x2520, 0x1BE3, 0xFEB3, 0xF581, 0xE896, 0xDEA2, 0xDFD5, 0xD7D4,
    0xE754, 0xDAC6, 0xE9DD, 0xE4FC, 0xE2A0, 0xE51A, 0xF585, 0xF9D3, 0xF1C1, 0x02BB, 0x0479, 0x0476, 0xF441, 0xF809, 0xFC22, 0x0245,
    0x1718, 0x2414, 0x227C, 0x27CD, 0x3618, 0x342F, 0x3408, 0x3BD3, 0x2D4B, 0x3498, 0x3299, 0x2A3C, 0x169A, 0xF99D, 0xE640, 0xDDE2,
    0xCDAA, 0xD29D, 0xD684, 0xCC80, 0xE75B, 0xDE70, 0xDDD3, 0xE2BF, 0xF606, 0xFD33, 0xFA6F, 0xFE48, 0x0E2E, 0x0B20, 0xFD04, 0xF563,
    0xF659, 0x038B, 0x04B9, 0x1F30, 0x1971, 0x2863, 0x2E6F, 0x2D0B, 0x35FB, 0x2C77, 0x3043, 0x2ED6, 0x32D0, 0x3165, 0x22A6, 0x069B,
    0xEB72, 0xE610, 0xD82E, 0xD1A6, 0xD723, 0xCD5F, 0xD980, 0xD851, 0xD540, 0xD851, 0xDC24, 0xE7FD, 0xE3CE, 0xF04B, 0xF73E, 0x0247,
    0xF80E, 0xEE4F, 0xF6B3, 0xF371, 0x0CB4, 0x1169, 0x25B2, 0x33B7, 0x30BF, 0x39B7, 0x437E, 0x4A13, 0x3DAF, 0x4111, 0x44D1, 0x3F01,
    0x2BBB, 0x1834, 0xFD39, 0xE7A4, 0xD81B, 0xD5EE, 0xD746, 0xCD4A, 0xD276, 0xDB0E, 0xD56B, 0xD491, 0xE03C, 0xDCB1, 0xE357, 0xEB10,
    0xF37A, 0xFCA7, 0xF5DD, 0xF016, 0xE6EC, 0xE3FA, 0xF273, 0xFC75, 0x01D4, 0x0C51, 0x0FA7, 0x1ADA, 0x243A, 0x242D, 0x2211, 0x1DDC,
    0x27B2, 0x29AC, 0x2021, 0x0E8F, 0xFE0D, 0xE798, 0xD1D8, 0xD123, 0xC877, 0xBEBA, 0xC6D1, 0xC905, 0xC668, 0xC099, 0xC400, 0xCB37,
    0xC882, 0xCAF5, 0xD293, 0xD7EB, 0xD435, 0xD5F0, 0xCE94, 0xCAF0, 0xD0DC, 0xE612, 0xEF24, 0xF67C, 0x0559, 0x0DA3, 0x1C1B, 0x24E1,
    0x28AF, 0x2287, 0x2C28, 0x36F1, 0x309A, 0x1EA9, 0x0881, 0xF660, 0xE282, 0xDB23, 0xD954, 0xCE16, 0xD0EB, 0xE09D, 0xD8D3, 0xD44D,
    0xE235, 0xE035, 0xEB73, 0xE70E, 0xEF1C, 0x01F2, 0xFC09, 0xF834, 0xF87C, 0xEDCD, 0xED1C, 0xFE98, 0xFBE2, 0x10E8, 0x1435, 0x17B0,
    0x1E3F, 0x224F, 0x2B44, 0x26DB, 0x2824, 0x2CBF, 0x35AC, 0x28E6, 0x1CDF, 0x04FD, 0xEFF0, 0xE9B9, 0xE871, 0xDF9E, 0xDF7C, 0xE94E,
    0xE6AF, 0xE57E, 0xE18E, 0xED51, 0xF1ED, 0xF178, 0xF552, 0x01D8, 0x0C41, 0x01EB, 0xFBD8, 0xFEDD, 0xF88A, 0xFDBD, 0x1131, 0x1E3F,
    0x2997, 0x31D4, 0x3E57, 0x4834, 0x4733, 0x4981, 0x4A83, 0x47CC, 0x53C2, 0x47FE, 0x3639, 0x2483, 0x057F, 0xF356, 0xED9C, 0xDE6E,
    0xD74F, 0xDB53, 0xD74F, 0xDA43, 0xCED6, 0xD26D, 0xDC85, 0xD374, 0xCDFA, 0xDD29, 0xDFBA, 0xDCB1, 0xD5CE, 0xCBB2, 0xCB63, 0xC72E,
    0xD142, 0xD8D6, 0xDD11, 0xE02A, 0xE51E, 0xECD8, 0xF023, 0xE9D0, 0xF2C7, 0xEFF5, 0xF87F, 0xF980, 0xEBF3, 0xE641, 0xC94D, 0xC027,
    0xBC42, 0xBB24, 0xB559, 0xBB29, 0xC742, 0xC776, 0xC3CD, 0xC98D, 0xD3C6, 0xD3E6, 0xD98B, 0xE719, 0xF2E3, 0xF786, 0xF5AF, 0xF694,
    0xF689, 0xF82A, 0x04F0, 0x0D5B, 0x1F31, 0x2633, 0x2947, 0x38C5, 0x442E, 0x44E0, 0x464F, 0x4590, 0x4894, 0x4D0F, 0x4504, 0x3668,
    0x1916, 0x06F4, 0x0238, 0xEFC7, 0xEAED, 0xEC1D, 0xE944, 0xF14F, 0xE85F, 0xEE47, 0xF337, 0xF5EF, 0xFA20, 0xF875, 0x06DB, 0x07EC,
    0x0657, 0x0273, 0xF75C, 0xF3B3, 0xF600, 0xF805, 0x0BE6, 0x0CAC, 0x041C, 0x1376, 0x13AE, 0x1503, 0x1258, 0x1252, 0x1664, 0x11D6,
    0x1420, 0x09F2, 0xEDF2, 0xD9F7, 0xD312, 0xC302, 0xC11B, 0xBF26, 0xC2C4, 0xC698, 0xC35B, 0xC813, 0xC724, 0xD0BF, 0xD0E7, 0xD7FE,
    0xD8FB, 0xE7B0, 0xF2C5, 0xEC4A, 0xEC84, 0xE5E2, 0xEBB3, 0xF7A4, 0x0690, 0x0E21, 0x14D9, 0x23E0, 0x2D0B, 0x3263, 0x3405, 0x2F40,
    0x37D2, 0x37D4, 0x2E83, 0x270F, 0x12CC, 0xF8DB, 0xE383, 0xD6B3, 0xCE0B, 0xC65F, 0xCB58, 0xCCB2, 0xCB37, 0xCC49, 0xD500, 0xD87B,
    0xD7A9, 0xE295, 0xEA0E, 0xF157, 0xF781, 0xFB5B, 0xF2E7, 0xEFA2, 0xE910, 0xEB5F, 0xF4B4, 0x0585, 0x07B4, 0x0B40, 0x1B01, 0x26A7,
    0x28AD, 0x1FF1, 0x2D15, 0x2E9F, 0x35D3, 0x2E7C, 0x2427, 0x1306, 0xFBFE, 0xF489, 0xDF42, 0xD828, 0xD77B, 0xDC2A, 0xDDFD, 0xD982,
    0xE40D, 0xE4CD, 0xE8B7, 0xEE29, 0xEE9C, 0xF7DC, 0x03BB, 0x0251, 0xFF68, 0xFF26, 0xF467, 0xF913, 0x02F7, 0x107B, 0x153E, 0x2205,
    0x2FDC, 0x37EE, 0x3B02, 0x38E4, 0x3EE4, 0x3C8F, 0x3F68, 0x3A1B, 0x2D1A, 0x16EC, 0x00E6, 0xEE81, 0xDEE7, 0xD222, 0xCCA2, 0xD281,
    0xD25D, 0xCB2A, 0xD427, 0xD868, 0xD741, 0xDEC1, 0xE0A8, 0xED26, 0xF2AD, 0xFA23, 0xF81A, 0xF86A, 0xF1F9, 0xED0A, 0xF19D, 0xFA57,
    0x056E, 0x01EA, 0x0EB5, 0x174A, 0x1DA1, 0x199F, 0x1CAF, 0x2404, 0x2383, 0x2850, 0x269A, 0x11B0, 0xF9A9, 0xE988, 0xE01B, 0xD0CA,
    0xC79A, 0xCAE0, 0xC7E9, 0xCA18, 0xC5D6, 0xCC7F, 0xC8D3, 0xCBFD, 0xCCEE, 0xD01F, 0xDB0D, 0xE1DE, 0xE4F5, 0xDE71, 0xDBF9, 0xD2CF,
    0xDDEA, 0xE8D6, 0xF439, 0xFFC4, 0x0AD9, 0x1CF1, 0x26B8, 0x28EB, 0x285D, 0x2ECB, 0x30F7, 0x3537, 0x35EB, 0x298A, 0x1A2F, 0x02B6,
    0xF29D, 0xE29F, 0xD7D9, 0xDA3B, 0xD78A, 0xD5D6, 0xD546, 0xD80C, 0xDBD1, 0xDA56, 0xDE72, 0xDE07, 0xE780, 0xEF05, 0xF3E7, 0xF27D,
    0xEA21, 0xE78A, 0xE4CE, 0xF305, 0xF6C8, 0x029D, 0x0634, 0x136F, 0x217C, 0x2530, 0x26F3, 0x274F, 0x2FD0, 0x33A6, 0x3ADB, 0x318D,
    0x2626, 0x13ED, 0x0635, 0xFA02, 0xF0DD, 0xEF4C, 0xF272, 0xF53F, 0xF001, 0xF2A1, 0xFA19, 0xF948, 0xFD89, 0x0355, 0x06DD, 0x13F4,
    0x14AA, 0x1902, 0x144D, 0x0924, 0x0360, 0x08EC, 0x14F4, 0x19EE, 0x27B1, 0x3200, 0x4023, 0x4701, 0x46EE, 0x4410, 0x47D9, 0x4ADE,
    0x4A0D, 0x480C, 0x36C3, 0x2578, 0x124A, 0x012F, 0xF001, 0xE357, 0xE559, 0xE267, 0xDD75, 0xDD5A, 0xDC46, 0xE07E, 0xDEF8, 0xE073,
    0xE4BB, 0xE7B1, 0xEA0D, 0xEDED, 0xE864, 0xDA4E, 0xD517, 0xD808, 0xDC34, 0xDFD7, 0xE39A, 0xE6E2, 0xF1B3, 0xF315, 0xF392, 0xEF6D,
    0xEE40, 0xF426, 0xF61D, 0xF3AF, 0xE92C, 0xDA5E, 0xC999, 0xC0F2, 0xB56F, 0xAE99, 0xB26E, 0xB42E, 0xB2FD, 0xB65B, 0xB9FF, 0xBE2B,
    0xC0D5, 0xC79A, 0xCD4C, 0xD813, 0xE1D5, 0xE65B, 0xF04C, 0xE6B9, 0xE712, 0xEBF4, 0xF6C0, 0x062E, 0x0FDA, 0x1DF6, 0x2ACF, 0x38DF,
    0x3B39, 0x3F49, 0x4200, 0x4549, 0x4B5F, 0x4D35, 0x47E4, 0x379F, 0x2A3E, 0x1D41, 0x0988, 0xFB24, 0xF869, 0xF952, 0xF61D, 0xF637,
    0xF7BB, 0xFAC4, 0xFB8A, 0xFABE, 0xFCD8, 0x0376, 0x0CF8, 0x0FBA, 0x1434, 0x09E0, 0x02A5, 0xFA0E, 0xFA5B, 0x02F2, 0x0395, 0x0B1F,
    0x127E, 0x1FAB, 0x2128, 0x2446, 0x20C7, 0x1E5A, 0x24D7, 0x25FB, 0x23C0, 0x19DF, 0x0906, 0xFD37, 0xEA5A, 0xDB9E, 0xD69E, 0xD1EA,
    0xD602, 0xCD45, 0xD0E7, 0xD647, 0xDB24, 0xDC5A, 0xDA86, 0xE404, 0xE427, 0xEAFA, 0xF0A4, 0xE946, 0xE596, 0xDEAE, 0xE22D, 0xEC1A,
    0xF701, 0x0115, 0x0A50, 0x1DBF, 0x21E8, 0x27F2, 0x28EE, 0x2347, 0x25A9, 0x28B0, 0x283D, 0x1BE5, 0x0AA7, 0xFBF5, 0xE8A8, 0xD7B5,
    0xCE2B, 0xCB6E, 0xCC43, 0xC71A, 0xC9F5, 0xCBF6, 0xD2C2, 0xD491, 0xD801, 0xE1FA, 0xE6FF, 0xF1E5, 0xFA9F, 0x01C7, 0xFBDA, 0xF199,
    0xEE53, 0xF42A, 0xFA20, 0xFCC6, 0x0799, 0x1497, 0x1BDB, 0x23D6, 0x240F, 0x263A, 0x2AAF, 0x2F7D, 0x36A7, 0x2F99, 0x2593, 0x1918,
    0x0A6C, 0xF6DD, 0xEB04, 0xE4FB, 0xDFFC, 0xDF07, 0xDDFC, 0xDDFD, 0xE470, 0xE6DD, 0xE8C0, 0xEF99, 0xF50C, 0xFC1F, 0x0434, 0x09EC,
    0x04B2, 0x0011, 0xFDB9, 0x0620, 0x1053, 0x1910, 0x2443, 0x3324, 0x3D93, 0x4546, 0x476F, 0x43B5, 0x43EA, 0x485A, 0x4C93, 0x479E,
    0x3BD5, 0x2CAD, 0x1CF6, 0x022B, 0xF190, 0xE5BE, 0xDF6B, 0xDA0B, 0xD4A7, 0xD496, 0xD4C9, 0xD6F6, 0xD4C2, 0xD866, 0xDB2F, 0xE28D,
    0xE862, 0xEEC2, 0xEDB0, 0xE6BD, 0xE2B7, 0xE23E, 0xEA3F, 0xEF2D, 0xF8A1, 0x01CE, 0x0D6A, 0x156E, 0x1AE3, 0x1BB9, 0x1982, 0x1D87,
    0x24EE, 0x27FF, 0x2135, 0x18DE, 0x098E, 0xF5AA, 0xE2D3, 0xDABA, 0xD4DB, 0xD202, 0xD03E, 0xCE85, 0xD369, 0xD5CF, 0xD6C5, 0xD8F2,
    0xDA14, 0xDBBB, 0xDF59, 0xE7E5, 0xE74D, 0xE337, 0xDC54, 0xDA1C, 0xE310, 0xE578, 0xEC75, 0xF93D, 0x07C5, 0x13B0, 0x1DC3, 0x1F64,
    0x20CE, 0x206A, 0x285B, 0x2B29, 0x254A, 0x1C3D, 0x1156, 0xFEA7, 0xECEA, 0xE337, 0xD9D9, 0xDAE9, 0xD595, 0xD6A0, 0xD929, 0xDE38,
    0xE2E5, 0xE652, 0xE9E1, 0xF116, 0xF7C7, 0xFDE0, 0x0036, 0xFB9A, 0xF360, 0xF187, 0xF602, 0xFBF5, 0x0285, 0x0CAB, 0x1924, 0x2194,
    0x2B4E, 0x2CA3, 0x2C96, 0x2ADE, 0x3268, 0x361B, 0x3616, 0x2E4B, 0x25FC, 0x160E, 0x01B8, 0xF410, 0xE893, 0xE90C, 0xE672, 0xE7B4,
    0xEA1E, 0xF0EA, 0xF46C, 0xF7EA, 0xFBED, 0xFE49, 0x06AB, 0x100E, 0x1887, 0x17F2, 0x1083, 0x0CD6, 0x0F4E, 0x145E, 0x1837, 0x1FC5,
    0x2C06, 0x389A, 0x4232, 0x497C, 0x4B4E, 0x4898, 0x4C31, 0x506E, 0x4FC8, 0x4A25, 0x422F, 0x3264, 0x1F10, 0x0C04, 0xFD3A, 0xF70A,
    0xF033, 0xEA92, 0xE820, 0xE839, 0xE879, 0xE828, 0xE717, 0xE7D1, 0xEA46, 0xEFD4, 0xF5A5, 0xF1DF, 0xE92A, 0xDEE8, 0xDBCB, 0xDC89,
    0xDD22, 0xE2FC, 0xE9A2, 0xF349, 0xFB7C, 0x021E, 0x0068, 0xFCB9, 0xFF62, 0x04C3, 0x0888, 0x0558, 0xFFF2, 0xF4D6, 0xE468, 0xD38F,
    0xC781, 0xC1A7, 0xBFFE, 0xBD7D, 0xBF55, 0xC373, 0xC670, 0xCB2C, 0xCCA9, 0xCFD0, 0xD375, 0xDA84, 0xE61C, 0xEAB7, 0xE87B, 0xE300,
    0xE5D1, 0xE9A6, 0xEEFF, 0xF914, 0x046D, 0x147E, 0x21F7, 0x2CB5, 0x3212, 0x3157, 0x353D, 0x3EB9, 0x42AB, 0x43C3, 0x3F37, 0x373C,
    0x2862, 0x16FF, 0x08ED, 0x0064, 0xF8FF, 0xF4ED, 0xF559, 0xF78B, 0xFB9C, 0xFDD1, 0x0350, 0x03B1, 0x058F, 0x0B0F, 0x1500, 0x1C40,
    0x17F4, 0x101D, 0x09C9, 0x0896, 0x07FD, 0x0840, 0x0E3A, 0x1450, 0x1959, 0x20E8, 0x2405, 0x212B, 0x21C9, 0x261F, 0x2BA5, 0x2972,
    0x2758, 0x1EBB, 0x0DD1, 0xFD8F, 0xE9CC, 0xE182, 0xDA0F, 0xD72F, 0xD663, 0xD5E6, 0xD8E4, 0xDA86, 0xDD9A, 0xDED7, 0xE22F, 0xE6C4,
    0xEFC5, 0xF87A, 0xF959, 0xF154, 0xECF3, 0xEE0F, 0xEFE7, 0xF7D7, 0x000B, 0x0D23, 0x1A14, 0x259B, 0x2CBF, 0x2B68, 0x2A07, 0x2DCF,
    0x31E9, 0x34E4, 0x347D, 0x2F88, 0x233C, 0x0DDA, 0xFA87, 0xEA10, 0xDFD2, 0xD56E, 0xD3A3, 0xD174, 0xD01D, 0xD123, 0xD34F, 0xD65B,
    0xD63D, 0xDB67, 0xE0FA, 0xEB62, 0xEDDD, 0xE950, 0xE6E9, 0xE4B7, 0xE63C, 0xE998, 0xEAC3, 0xF35D, 0xFB8F, 0x0819, 0x11EC, 0x13CB,
    0x16B8, 0x1B21, 0x2474, 0x29C1, 0x2E29, 0x2BAE, 0x247F, 0x15A1, 0x03E6, 0xF87D, 0xF03F, 0xECC1, 0xE9EC, 0xEA39, 0xEC88, 0xEF09,
    0xF377, 0xF615, 0xF8C1, 0xFB18, 0xFFDF, 0x0A3D, 0x1147, 0x0F7E, 0x0A15, 0x07C0, 0x08BD, 0x0B2A, 0x10AD, 0x1948, 0x238A, 0x315D,
    0x3D8D, 0x4131, 0x406E, 0x42F2, 0x45AF, 0x488D, 0x4877, 0x4515, 0x3D5C, 0x2C8D, 0x1A06, 0x0649, 0xF7FB, 0xEC28, 0xE52D, 0xE0A0,
    0xDD5A, 0xE02A, 0xE0C4, 0xE334, 0xE552, 0xE53C, 0xE71E, 0xEFE1, 0xF55A, 0xF4D1, 0xEE22, 0xEAF3, 0xEAD6, 0xED29, 0xF117, 0xF5AA,
    0xFE08, 0x0817, 0x14AD, 0x18AF, 0x19C2, 0x1C5B, 0x2100, 0x227B, 0x2529, 0x24AB, 0x20CC, 0x1404, 0x0274, 0xF0EF, 0xE076, 0xD805,
    0xCFE1, 0xCBB1, 0xCB8A, 0xCCA4, 0xCE92, 0xD2AE, 0xD667, 0xD796, 0xD91E, 0xE258, 0xE96D, 0xEC15, 0xE84F, 0xE5AF, 0xE640, 0xE6CD,
    0xEB8F, 0xEF9E, 0xF5E6, 0xFFBD, 0x0C97, 0x15C2, 0x1977, 0x1AD8, 0x1FC8, 0x23EB, 0x27C7, 0x2A3B, 0x2711, 0x1F22, 0x0E02, 0xF9DF,
    0xE9FB, 0xDE11, 0xD503, 0xD21D, 0xD12E, 0xD20B, 0xD539, 0xD737, 0xDAD5, 0xDCBD, 0xDDD3, 0xE5D8, 0xF0B8, 0xF641, 0xF4B1, 0xF15F,
    0xEFEC, 0xEF70, 0xF169, 0xF419, 0xF9D2, 0x0609, 0x1590, 0x21C4, 0x272F, 0x2A2D, 0x2F4B, 0x3453, 0x37FF, 0x3C3C, 0x3DE1, 0x3BCF,
    0x3079, 0x21BF, 0x1554, 0x0950, 0xFFC8, 0xF8F3, 0xF670, 0xF6A4, 0xF8E3, 0xFD19, 0x012C, 0x02DC, 0x0314, 0x06FC, 0x111F, 0x187C,
    0x1A10, 0x16D6, 0x1424, 0x1250, 0x13C2, 0x16CB, 0x18A5, 0x1F7C, 0x293D, 0x337A, 0x35E3, 0x35DF, 0x3705, 0x39AD, 0x3E10, 0x3F1A,
    0x415C, 0x3DFA, 0x334A, 0x24CF, 0x1380, 0x04E8, 0xF7D2, 0xF048, 0xEA20, 0xE83B, 0xE7A3, 0xE88A, 0xEBA5, 0xE8F0, 0xE578, 0xE643,
    0xEDCD, 0xF410, 0xF627, 0xF12D, 0xEB91, 0xE5AC, 0xE15C, 0xE1B2, 0xE1B0, 0xE4B4, 0xEE05, 0xFA97, 0x01E0, 0x03FA, 0x0581, 0x0796,
    0x08D4, 0x0AFD, 0x0ADC, 0x08B9, 0x0034, 0xF06F, 0xE148, 0xD2D1, 0xC8B5, 0xC1BF, 0xBE0A, 0xBDA7, 0xBD09, 0xBFA9, 0xC1F8, 0xC314,
    0xC3B8, 0xC59F, 0xCE1F, 0xD827, 0xDDDF, 0xE044, 0xDFD0, 0xDF3B, 0xE24B, 0xE7B3, 0xEDF7, 0xF69D, 0x0627, 0x1731, 0x240E, 0x2AD8,
    0x2E01, 0x3363, 0x38A8, 0x3D91, 0x43B1, 0x46A0, 0x451D, 0x3C3A, 0x2F1E, 0x21E4, 0x1421, 0x0AB2, 0x02E7, 0xFDBA, 0xFB5C, 0xFA9D,
    0xFD1D, 0xFE55, 0xFBD5, 0xFAC6, 0xFF3A, 0x0709, 0x0C5C, 0x0CD1, 0x0AB0, 0x06B1, 0x0382, 0x0278, 0x01E0, 0x02F0, 0x0A41, 0x15B9,
    0x1F0C, 0x241F, 0x2432, 0x244B, 0x2566, 0x274A, 0x2BC2, 0x2DA0, 0x292B, 0x1E93, 0x0F58, 0xFEB6, 0xF051, 0xE4CA, 0xDCEA, 0xD7E6,
    0xD600, 0xD5BF, 0xD842, 0xDB23, 0xD93F, 0xD740, 0xD95E, 0xE162, 0xE931, 0xEC9D, 0xEE6E, 0xED01, 0xEAE1, 0xEC6D, 0xED9A, 0xEF22,
    0xF7A9, 0x050A, 0x12BD, 0x1CCF, 0x20E7, 0x23E7, 0x2851, 0x29E4, 0x2D57, 0x30F0, 0x30DB, 0x2B52, 0x1E2F, 0x0F84, 0xFFD1, 0xF2CA,
    0xE8BF, 0xE108, 0xDCCA, 0xDA83, 0xDA63, 0xDC0D, 0xDC5C, 0xDAA7, 0xDC6C, 0xE4A6, 0xEBC6, 0xF0F5, 0xF303, 0xF011, 0xEDD5, 0xEDA2,
    0xEFF0, 0xF0C4, 0xF533, 0xFF50, 0x0B96, 0x144C, 0x1861, 0x1B25, 0x1BD6, 0x1D77, 0x2219, 0x26D7, 0x28E2, 0x25F1, 0x1C21, 0x0ECA,
    0xFFBA, 0xF272, 0xE7FB, 0xE204, 0xDF1C, 0xDDBB, 0xDF08, 0xE3E9, 0xE498, 0xE33C, 0xE5B5, 0xEC5A, 0xF750, 0xFED5, 0x031C, 0x0373,
    0x0283, 0x0358, 0x0691, 0x072F, 0x09E7, 0x144A, 0x225F, 0x2E6A, 0x3664, 0x3B10, 0x3E0E, 0x42E2, 0x453F, 0x49D1, 0x4C37, 0x4953,
    0x4071, 0x31DA, 0x20C4, 0x0F22, 0x0113, 0xF579, 0xEDD1, 0xE7AC, 0xE4AE, 0xE4D1, 0xE3CE, 0xDFF7, 0xDCEF, 0xDFCD, 0xE5A4, 0xEA89,
    0xED63, 0xEC6C, 0xE79F, 0xE52A, 0xE36A, 0xE21F, 0xE3A4, 0xE9F5, 0xF602, 0x0349, 0x0BE6, 0x10C4, 0x158E, 0x16DD, 0x19C3, 0x1FFE,
    0x2510, 0x2725, 0x24BB, 0x1CD8, 0x115A, 0x038D, 0xF68B, 0xED22, 0xE559, 0xDFE8, 0xDD8A, 0xDEAE, 0xE0FB, 0xE016, 0xDE30, 0xE0E4,
    0xE822, 0xF093, 0xF663, 0xF880, 0xF519, 0xF1E0, 0xF04C, 0xEE3B, 0xED96, 0xF0DB, 0xFA18, 0x0465, 0x0B25, 0x0DF2, 0x10CA, 0x11AB,
    0x12E7, 0x15E6, 0x19F5, 0x1B4B, 0x17E8, 0x1004, 0x035C, 0xF545, 0xE689, 0xDC2C, 0xD470, 0xCF3E, 0xCE27, 0xD060, 0xD395, 0xD437,
    0xD215, 0xD331, 0xD94A, 0xE101, 0xE8BB, 0xEBF3, 0xEAFD, 0xE8E1, 0xE8D2, 0xE956, 0xE861, 0xEC43, 0xF5A9, 0x0213, 0x0E26, 0x1639,
    0x1D44, 0x21FF, 0x2577, 0x29D5, 0x3000, 0x34AD, 0x34D5, 0x303E, 0x28DA, 0x1DBA, 0x11F3, 0x091C, 0x0319, 0xFEBE, 0xFA5F, 0xFB13,
    0xFF45, 0x0144, 0x0057, 0x0174, 0x0819, 0x118F, 0x1B7B, 0x225E, 0x2321, 0x217A, 0x207B, 0x2083, 0x1F15, 0x20B0, 0x27FA, 0x32DD,
    0x3C3D, 0x42FA, 0x4753, 0x46F6, 0x45F4, 0x464D, 0x48DB, 0x4B34, 0x4A3C, 0x44C7, 0x3B2D, 0x2E49, 0x1EC3, 0x0FF3, 0x0555, 0xF9E3,
    0xF0A3, 0xEBA4, 0xEA96, 0xEA5C, 0xE69A, 0xE361, 0xE350, 0xE559, 0xE9EF, 0xEC5F, 0xE9BC, 0xE568, 0xE0D6, 0xDE29, 0xD8F8, 0xD51D,
    0xD7F2, 0xDFCE, 0xE9A7, 0xF19C, 0xF710, 0xFB75, 0xFCB7, 0xFEB7, 0x0346, 0x079C, 0x0A22, 0x0712, 0xFF68, 0xF552, 0xE753, 0xDA39,
    0xD03A, 0xC7FD, 0xC265, 0xBF4B, 0xC1E7, 0xC4C2, 0xC4AF, 0xC3E4, 0xC559, 0xCA1E, 0xD227, 0xDAEB, 0xDFE6, 0xE247, 0xE400, 0xE51F,
    0xE53E, 0xE4E2, 0xE8FB, 0xF3D9, 0x012D, 0x0E6E, 0x1A5F, 0x227F, 0x26D2, 0x29DB, 0x2F98, 0x35AD, 0x3A6D, 0x3C12, 0x38FF, 0x33C4,
    0x2A28, 0x1EFC, 0x14D4, 0x0BF9, 0x02C4, 0xFBC7, 0xF958, 0xFAEA, 0xFA0C, 0xF832, 0xF79B, 0xFB36, 0x03C7, 0x0C5A, 0x110E, 0x1041,
    0x0F86, 0x0F5A, 0x0E9E, 0x0B89, 0x0C27, 0x11E2, 0x1B96, 0x250C, 0x2C3B, 0x305A, 0x30A7, 0x2EC4, 0x2CAE, 0x2E3A, 0x2F9C, 0x2E91,
    0x29BA, 0x2005, 0x10DC, 0xFFB2, 0xF093, 0xE31B, 0xD74D, 0xCDE8, 0xCA69, 0xCB05, 0xCA4F, 0xC8FC, 0xC916, 0xCB49, 0xD24E, 0xDB51,
    0xE2F8, 0xE6F1, 0xE91B, 0xEC4D, 0xECAF, 0xEBFB, 0xEB7E, 0xF0CE, 0xFABF, 0x0689, 0x12ED, 0x1C16, 0x2106, 0x2325, 0x2489, 0x28EF,
    0x2DDD, 0x3006, 0x2EA9, 0x2895, 0x1DA4, 0x0D89, 0xFE81, 0xF0DB, 0xE4CA, 0xDACA, 0xD518, 0xD46E, 0xD3F6, 0xD0CF, 0xCE38, 0xCC53,
    0xCF31, 0xD5DB, 0xDC7A, 0xDF9B, 0xE030, 0xE2A3, 0xE39A, 0xE2AF, 0xE134, 0xE5D2, 0xF028, 0xFC71, 0x0999, 0x149A, 0x1ADF, 0x1DF2,
    0x1F49, 0x22AC, 0x284A, 0x2CE8, 0x2F5F, 0x2E0C, 0x27C6, 0x1C7D, 0x0F01, 0x026F, 0xF553, 0xE946, 0xE2BE, 0xE20D, 0xE39D, 0xE3F4,
    0xE2F6, 0xE34B, 0xE7F6, 0xF174, 0xFC34, 0x0318, 0x05D3, 0x0747, 0x080D, 0x05D3, 0x01D6, 0x0194, 0x082B, 0x11A3, 0x1C96, 0x266C,
    0x2D71, 0x30B5, 0x315A, 0x3339, 0x372D, 0x3B6E, 0x3E04, 0x3D5D, 0x3784, 0x2BEC, 0x1CC0, 0x0D5C, 0xFD9B, 0xEF0B, 0xE3D9, 0xDF94,
    0xDE6F, 0xDB02, 0xD704, 0xD345, 0xD15C, 0xD4C0, 0xDACF, 0xDED8, 0xDEFA, 0xDE1F, 0xDE20, 0xDC7F, 0xD899, 0xD778, 0xDC06, 0xE3FF,
    0xEE40, 0xF95B, 0x02CC, 0x0974, 0x0D8D, 0x10CA, 0x16B2, 0x1C49, 0x2126, 0x232D, 0x2095, 0x184E, 0x0C39, 0x001A, 0xF4E6, 0xE9D6,
    0xE07E, 0xDC3D, 0xDA75, 0xD8E4, 0xD609, 0xD2BB, 0xD27D, 0xD71A, 0xE08D, 0xE976, 0xEE16, 0xF05B, 0xF1F2, 0xF2AD, 0xEEC0, 0xEC1B,
    0xEF08, 0xF67E, 0x019C, 0x0C83, 0x14E3, 0x19A9, 0x1A37, 0x1A2A, 0x1CEE, 0x2063, 0x2405, 0x2539, 0x2278, 0x19E9, 0x0C5E, 0xFE67,
    0xF073, 0xE1F5, 0xD487, 0xCD35, 0xCAB2, 0xC94A, 0xC838, 0xC54A, 0xC357, 0xC41C, 0xC94B, 0xCF11, 0xD1AB, 0xD308, 0xD417, 0xD494,
    0xD209, 0xCF9B, 0xD1AE, 0xD85B, 0xE2E4, 0xEF71, 0xFBEA, 0x05C8, 0x0D11, 0x1312, 0x19F3, 0x22B6, 0x2A8F, 0x3019, 0x3215, 0x2F59,
    0x26AF, 0x1C5F, 0x1287, 0x0668, 0xFB32, 0xF556, 0xF428, 0xF5BF, 0xF7CB, 0xF853, 0xF7CD, 0xF9E1, 0x00F5, 0x0B64, 0x132E, 0x16E4,
    0x1A87, 0x1CB3, 0x1CAF, 0x19DB, 0x195D, 0x1D46, 0x2561, 0x2F4A, 0x38E1, 0x3FDE, 0x42BE, 0x4387, 0x43C8, 0x4557, 0x4704, 0x4946,
    0x491C, 0x4468, 0x3B2B, 0x2E4E, 0x2216, 0x145D, 0x0442, 0xF75F, 0xEF55, 0xEBFF, 0xE938, 0xE5D7, 0xE1A3, 0xDF95, 0xE1F0, 0xE6E7,
    0xEAF1, 0xEAE0, 0xEB02, 0xEB0D, 0xE95B, 0xE485, 0xE091, 0xE13E, 0xE60C, 0xEE0C, 0xF77E, 0xFFEC, 0x044E, 0x0519, 0x0532, 0x0670,
    0x08F1, 0x0BF6, 0x0D26, 0x0AC6, 0x0238, 0xF4F1, 0xE79A, 0xDA16, 0xCBBE, 0xC032, 0xB9BB, 0xB703, 0xB64C, 0xB5C4, 0xB57D, 0xB5A4,
    0xB8E1, 0xBF60, 0xC629, 0xCAF8, 0xD008, 0xD5B9, 0xD9DF, 0xDBA8, 0xDBF3, 0xDF4B, 0xE5B6, 0xF138, 0xFEB7, 0x0B3B, 0x14D1, 0x1B07,
    0x202E, 0x2564, 0x2BB7, 0x3274, 0x3871, 0x3AA9, 0x36B9, 0x2E4A, 0x258F, 0x1C2E, 0x10D6, 0x05D9, 0xFEFF, 0xFBAF, 0xFA63, 0xF81E,
    0xF4B1, 0xEFFC, 0xEE34, 0xF2A9, 0xF8AF, 0xFD9E, 0x018F, 0x0612, 0x0941, 0x093E, 0x0762, 0x0764, 0x0B03, 0x12DE, 0x1E2E, 0x2A30,
    0x336F, 0x3813, 0x3A6B, 0x3BF2, 0x3DEE, 0x3FE9, 0x41E6, 0x42F6, 0x3E7E, 0x357D, 0x2A11, 0x1CA7, 0x0BEA, 0xF9BC, 0xEB8C, 0xE1CD,
    0xDCD3, 0xDA3D, 0xD692, 0xD2AE, 0xD1C7, 0xD5D1, 0xDD3B, 0xE306, 0xE72D, 0xEC39, 0xEF2A, 0xF039, 0xEECB, 0xED75, 0xEEE8, 0xF262,
    0xF996, 0x0201, 0x0A19, 0x0F73, 0x125B, 0x153F, 0x18CE, 0x1C33, 0x20B6, 0x2597, 0x2561, 0x1EC5, 0x1510, 0x0A64, 0xFC7F, 0xED61,
    0xE180, 0xDA62, 0xD73F, 0xD60D, 0xD3D2, 0xCFE0, 0xCC79, 0xCD62, 0xD1BD, 0xD618, 0xD92B, 0xDCCE, 0xE119, 0xE3CF, 0xE4A5, 0xE4AE,
    0xE6A7, 0xEB6D, 0xF399, 0xFF6C, 0x0A49, 0x11F2, 0x17CE, 0x1C2D, 0x2109, 0x2598, 0x2B8B, 0x32B2, 0x350E, 0x31F1, 0x2B51, 0x229B,
    0x17B5, 0x08F2, 0xFA7C, 0xF092, 0xEB88, 0xEA02, 0xE885, 0xE5F2, 0xE399, 0xE624, 0xEE85, 0xF732, 0xFEDD, 0x0701, 0x0EF9, 0x1411,
    0x14A6, 0x13A3, 0x12F6, 0x1481, 0x19A9, 0x2275, 0x2C3B, 0x3394, 0x3734, 0x3928, 0x3BF9, 0x3E09, 0x41AE, 0x466E, 0x4974, 0x46D5,
    0x3FFF, 0x3885, 0x2DAD, 0x1E73, 0x0DB1, 0xFEAF, 0xF365, 0xECC0, 0xE7C6, 0xE17D, 0xD9B4, 0xD42D, 0xD3C6, 0xD561, 0xD6A1, 0xD840,
    0xDAAD, 0xDAA4, 0xD817, 0xD458, 0xD10E, 0xD0A3, 0xD330, 0xDA16, 0xE385, 0xECC4, 0xF418, 0xFA66, 0x017B, 0x0907, 0x0FD9, 0x1908,
    0x213C, 0x23E8, 0x2161, 0x1B9B, 0x1403, 0x083D, 0xFA9B, 0xEEDF, 0xE81F, 0xE65A, 0xE70F, 0xE565, 0xE1C8, 0xDEED, 0xE09F, 0xE557,
    0xE9AB, 0xEF73, 0xF70F, 0xFDD0, 0x00E3, 0x001A, 0xFDC0, 0xFCD9, 0xFD03, 0x00DC, 0x0937, 0x11BB, 0x17E0, 0x1C33, 0x1ED8, 0x21B5,
    0x23D2, 0x27AB, 0x2BF0, 0x2B91, 0x26FC, 0x201E, 0x16CA, 0x0993, 0xF9FD, 0xE9F0, 0xDD69, 0xD5A4, 0xD1B4, 0xCE8E, 0xC9F2, 0xC668,
    0xC728, 0xCAE6, 0xCF37, 0xD2CC, 0xD7E2, 0xDD0F, 0xDFEE, 0xE0C1, 0xDF83, 0xDEDE, 0xDFB6, 0xE494, 0xEED3, 0xFA7F, 0x04A1, 0x0C12,
    0x1261, 0x187A, 0x1DC8, 0x2569, 0x2E51, 0x3363, 0x3306, 0x2EB0, 0x2770, 0x1D54, 0x1024, 0x0231, 0xF63F, 0xEFC0, 0xEE4E, 0xEFB6,
    0xEF34, 0xED32, 0xEFB6, 0xF5E0, 0xFD45, 0x04D5, 0x0DEB, 0x1839, 0x1FD3, 0x2302, 0x23DA, 0x2362, 0x2372, 0x2686, 0x2DB3, 0x3784,
    0x3F2E, 0x43ED, 0x4664, 0x4773, 0x482C, 0x4A75, 0x4E6A, 0x503E, 0x4E34, 0x4877, 0x3FF9, 0x3487, 0x25BD, 0x156A, 0x066C, 0xFA75,
    0xF460, 0xF123, 0xEC0D, 0xE51A, 0xE09E, 0xDF90, 0xE1F0, 0xE507, 0xE8B6, 0xEF64, 0xF3D1, 0xF53B, 0xF38E, 0xF08A, 0xED91, 0xECBF,
    0xF08C, 0xF920, 0x01C0, 0x0885, 0x0DAC, 0x1105, 0x1369, 0x157E, 0x19FD, 0x1E7D, 0x1ED0, 0x1AE2, 0x1416, 0x09C3, 0xFBE6, 0xEB7E,
    0xDBFA, 0xCF94, 0xC8A5, 0xC5D6, 0xC29B, 0xBE4F, 0xBC05, 0xBD6F, 0xC24F, 0xC74F, 0xCD1B, 0xD4B4, 0xDB5E, 0xE004, 0xE1E0, 0xE1EA,
    0xE1B0, 0xE241, 0xE610, 0xEE20, 0xF84F, 0x0149, 0x0877, 0x0DB4, 0x1151, 0x1582, 0x1C55, 0x243B, 0x293F, 0x2ADF, 0x2890, 0x235A,
    0x1A8D, 0x0F77, 0x03B5, 0xF9D0, 0xF434, 0xF355, 0xF32A, 0xEF85, 0xEB32, 0xE9CC, 0xEC20, 0xF045, 0xF43A, 0xF9E2, 0x015F, 0x06F6,
    0x0AA9, 0x0C57, 0x0D23, 0x0E11, 0x117E, 0x18E5, 0x233C, 0x2C93, 0x349F, 0x3A39, 0x3DE1, 0x413E, 0x45CF, 0x4AD6, 0x4C8F, 0x4A66,
    0x44AB, 0x3C67, 0x307D, 0x21DB, 0x1180, 0x00CF, 0xF35A, 0xEAAF, 0xE39F, 0xDBD5, 0xD3FB, 0xCFDF, 0xCFDE, 0xD31B, 0xD78E, 0xDE6B,
    0xE654, 0xEC3C, 0xF063, 0xF132, 0xF04D, 0xEFA7, 0xF1A5, 0xF7EE, 0x00EA, 0x091F, 0x0FDD, 0x14E2, 0x185B, 0x1AC0, 0x1EB7, 0x24F7,
    0x2A16, 0x2C06, 0x2AD8, 0x26D8, 0x20AC, 0x1690, 0x08C4, 0xFA8C, 0xEDE7, 0xE668, 0xE2C6, 0xDDA9, 0xD65E, 0xD004, 0xCDB9, 0xCE54,
    0xCFDA, 0xD2C8, 0xD73E, 0xDB30, 0xDD28, 0xDD25, 0xDB9B, 0xDA29, 0xDAC2, 0xDF57, 0xE7A6, 0xF1F4, 0xFC23, 0x065B, 0x0D30, 0x12D4,
    0x1A19, 0x22EC, 0x2B86, 0x30CA, 0x32B5, 0x321E, 0x2DD9, 0x2566, 0x1A39, 0x0CC9, 0x0030, 0xF7FA, 0xF511, 0xF2F0, 0xEE87, 0xE9DA,
    0xE894, 0xEAF3, 0xEFA3, 0xF59B, 0xFDBE, 0x05E3, 0x0D8F, 0x1253, 0x13B5, 0x134E, 0x11D4, 0x12E5, 0x17A2, 0x1E94, 0x257C, 0x2C9E,
    0x31EB, 0x3525, 0x37B5, 0x3C66, 0x420A, 0x45A1, 0x4641, 0x44AC, 0x40B1, 0x3ACF, 0x320C, 0x25AA, 0x1770, 0x0B13, 0x02BD, 0xFBFF,
    0xF353, 0xEA24, 0xE4ED, 0xE28E, 0xE236, 0xE34E, 0xE5E3, 0xE986, 0xEBA4, 0xEB36, 0xE7E7, 0xE240, 0xDC87, 0xD9EF, 0xDB97, 0xE081,
    0xE720, 0xEEB6, 0xF560, 0xF8CE, 0xFCF0, 0x0427, 0x0CE0, 0x147E, 0x18E1, 0x19DD, 0x1842, 0x13C2, 0x0B8C, 0xFFFE, 0xF317, 0xE7D5,
    0xE22C, 0xE01A, 0xDD6F, 0xDA7E, 0xD804, 0xD889, 0xDBA5, 0xDFEB, 0xE542, 0xED26, 0xF53B, 0xFB75, 0xFED1, 0xFEE4, 0xFCD1, 0xFB59,
    0xFD8F, 0x026E, 0x07EB, 0x0ED5, 0x1552, 0x191A, 0x1B15, 0x1EF4, 0x25FC, 0x2BE4, 0x2EE9, 0x2F35, 0x2CE7, 0x2792, 0x1F39, 0x1276,
    0x0322, 0xF3CC, 0xE966, 0xE272, 0xDAD5, 0xD2D8, 0xCBE2, 0xC79D, 0xC62C, 0xC6EB, 0xCA6E, 0xCFCB, 0xD515, 0xDA2D, 0xDC95, 0xDC7F,
    0xD9CD, 0xD6BB, 0xD7B4, 0xDCF1, 0xE428, 0xEE2B, 0xF8B6, 0x0186, 0x07F6, 0x0DBB, 0x1652, 0x1FE6, 0x2738, 0x2CC0, 0x2EB9, 0x2E3C,
    0x2AE8, 0x2296, 0x17A6, 0x0ACC, 0x01C1, 0xFD7B, 0xF9EB, 0xF630, 0xF353, 0xF34F, 0xF6B1, 0xFBA8, 0x0368, 0x0C6D, 0x1603, 0x1F32,
    0x2530, 0x2886, 0x276D, 0x2420, 0x2287, 0x2406, 0x2880, 0x2F47, 0x36A2, 0x3C14, 0x3D6F, 0x3DD5, 0x4046, 0x43BD, 0x46CF, 0x4841,
    0x475D, 0x43A2, 0x3D50, 0x3379, 0x258B, 0x1636, 0x086A, 0xFF13, 0xF7C8, 0xF026, 0xE92F, 0xE339, 0xE013, 0xDEF4, 0xDF0C, 0xE1C9,
    0xE5BF, 0xE966, 0xED31, 0xEF1B, 0xED52, 0xE957, 0xE631, 0xE74E, 0xEB08, 0xF0F0, 0xF8F9, 0x0059, 0x0537, 0x0851, 0x0D3E, 0x1419,
    0x1AAE, 0x1E8F, 0x1F95, 0x1C7F, 0x1703, 0x0E79, 0x0104, 0xF12D, 0xE288, 0xD8A2, 0xD274, 0xCC60, 0xC644, 0xC1C0, 0xBF57, 0xBFD0,
    0xC25F, 0xC7A5, 0xCE95, 0xD57A, 0xDB84, 0xDF0C, 0xDF9C, 0xDDA4, 0xDBEC, 0xDE2B, 0xE2A8, 0xE921, 0xF2BA, 0xFBA2, 0x0203, 0x06B2,
    0x0B35, 0x120B, 0x1A1F, 0x213B, 0x26C5, 0x29B4, 0x2B26, 0x29B6, 0x22B7, 0x177C, 0x0B52, 0x02ED, 0xFF47, 0xFB3A, 0xF67E, 0xF1D2,
    0xEE28, 0xECB3, 0xEC68, 0xEECE, 0xF397, 0xF734, 0xFAA7, 0xFCFF, 0xFD7B, 0xFB55, 0xF7DF, 0xF820, 0xFBFF, 0x030C, 0x0CE0, 0x17D8,
    0x216B, 0x2836, 0x2E3D, 0x35BC, 0x3D43, 0x447F, 0x4912, 0x4996, 0x4829, 0x4407, 0x3B66, 0x2D35, 0x1C17, 0x0D3A, 0x02A2, 0xFA14,
    0xF086, 0xE7C1, 0xE0A4, 0xDB3B, 0xD895, 0xD7C0, 0xDA55, 0xDEA9, 0xE3A9, 0xE873, 0xEB0E, 0xEAB3, 0xE7D1, 0xE5F8, 0xE77D, 0xEAFB,
    0xF16B, 0xFA55, 0x0237, 0x0705, 0x0A53, 0x0EED, 0x1513, 0x1B23, 0x20C8, 0x2477, 0x250D, 0x2424, 0x1F95, 0x165C, 0x095D, 0xFC52,
    0xF2E2, 0xEC11, 0xE4DE, 0xDE93, 0xD9BF, 0xD639, 0xD4D9, 0xD4FB, 0xD80B, 0xDC6A, 0xE092, 0xE526, 0xE754, 0xE548, 0xE0F2, 0xDDAC,
    0xDDA2, 0xE19A, 0xE957, 0xF448, 0xFEB9, 0x0722, 0x0DC2, 0x142E, 0x1CF1, 0x2570, 0x2CB4, 0x31A5, 0x32FD, 0x3241, 0x2F44, 0x2680,
    0x18E9, 0x0A53, 0xFF46, 0xF7E6, 0xF133, 0xEB74, 0xE6DF, 0xE40B, 0xE339, 0xE40D, 0xE89B, 0xF002, 0xF810, 0x0022, 0x077A, 0x0BC4,
    0x0BF7, 0x0B61, 0x0C0B, 0x0F7E, 0x1508, 0x1C8B, 0x2397, 0x2880, 0x2B12, 0x2D4E, 0x3162, 0x379A, 0x3E0A, 0x4253, 0x43C4, 0x42E5,
    0x3F9B, 0x3868, 0x2CCE, 0x1D8C, 0x111A, 0x083F, 0x006E, 0xF8A3, 0xF0E9, 0xE9C9, 0xE42F, 0xE0DC, 0xE059, 0xE213, 0xE55B, 0xE947,
    0xED10, 0xEDA0, 0xEA25, 0xE584, 0xE1D4, 0xE050, 0xE1CB, 0xE72D, 0xEE4A, 0xF4A1, 0xF8D5, 0xFBD3, 0xFECC, 0x0481, 0x0B53, 0x117E,
    0x160F, 0x183F, 0x1948, 0x1615, 0x0D5D, 0x018C, 0xF678, 0xEF01, 0xE970, 0xE49A, 0xE0A8, 0xDDDF, 0xDDE2, 0xDF57, 0xE223, 0xE76C,
    0xED86, 0xF4FB, 0xFCE6, 0x02BF, 0x0588, 0x045A, 0x0230, 0x01D8, 0x040F, 0x08CE, 0x0EA6, 0x1427, 0x1706, 0x1801, 0x18DD, 0x1AF4,
    0x1F66, 0x2423, 0x277E, 0x2792, 0x2699, 0x2356, 0x1A15, 0x0C44, 0xFD4A, 0xF0C6, 0xE720, 0xDDE7, 0xD570, 0xCE4B, 0xC8E2, 0xC612,
    0xC455, 0xC4A3, 0xC623, 0xC91F, 0xCE20, 0xD1F7, 0xD37B, 0xD2F3, 0xD1F6, 0xD288, 0xD456, 0xD9BB, 0xE289, 0xEBB8, 0xF33D, 0xF9B9,
    0x000A, 0x06A0, 0x0F30, 0x175B, 0x1DDB, 0x2215, 0x24E2, 0x2565, 0x20C1, 0x16FD, 0x0B34, 0x012A, 0xF9F8, 0xF492, 0xF059, 0xEC63,
    0xE9CE, 0xE990, 0xEB73, 0xF089, 0xF7D7, 0x00E5, 0x0B9F, 0x1542, 0x1C05, 0x1EB0, 0x1F7A, 0x1F18, 0x1F3E, 0x22A8, 0x28C6, 0x30DB,
    0x378B, 0x3C90, 0x40D8, 0x43E6, 0x47A7, 0x4B7D, 0x4DBB, 0x4EEC, 0x4E92, 0x4D6C, 0x4810, 0x3C90, 0x2DE1, 0x1FD5, 0x1583, 0x0CBF,
    0x027C, 0xF80F, 0xEEB2, 0xE835, 0xE527, 0xE327, 0xE2EE, 0xE371, 0xE5AC, 0xE89E, 0xE995, 0xE8E7, 0xE62A, 0xE38B, 0xE257, 0xE2B8,
    0xE789, 0xEEBF, 0xF586, 0xFB5D, 0x001A, 0x04F1, 0x0AB5, 0x1189, 0x183B, 0x1C74, 0x1F0B, 0x1FC2, 0x1C25, 0x11D7, 0x01FA, 0xF22F,
    0xE522, 0xDB52, 0xD2BA, 0xCB8D, 0xC5D7, 0xC17C, 0xBF47, 0xBE92, 0xBF8D, 0xC1FE, 0xC680, 0xCCDF, 0xD2DC, 0xD6A6, 0xD90E, 0xD969,
    0xD903, 0xDA4A, 0xDE22, 0xE55C, 0xEC5E, 0xF31A, 0xF8FC, 0xFDE8, 0x04F1, 0x0C5E, 0x13D7, 0x1A3C, 0x1E95, 0x232D, 0x25A9, 0x22FC,
    0x1B6B, 0x1072, 0x0622, 0xFDDF, 0xF6E8, 0xF10C, 0xECA5, 0xEA10, 0xE8EE, 0xE961, 0xEB84, 0xEE51, 0xF371, 0xF96F, 0xFE0B, 0x0097,
    0xFFCA, 0xFE01, 0xFC8E, 0xFC7D, 0x003D, 0x08D6, 0x125A, 0x1B6E, 0x2357, 0x2A85, 0x315B, 0x38CD, 0x4099, 0x4607, 0x49C0, 0x4C36,
    0x4C69, 0x47C8, 0x3D84, 0x2FC7, 0x20EA, 0x1317, 0x07AA, 0xFCDD, 0xF38B, 0xEAD7, 0xE330, 0xDDD4, 0xD9E2, 0xD819, 0xD8D4, 0xDC6A,
    0xE132, 0xE3E1, 0xE40B, 0xE39E, 0xE17E, 0xE0C2, 0xE200, 0xE6C1, 0xED84, 0xF3BA, 0xF936, 0xFD13, 0x016D, 0x07BB, 0x0F07, 0x1646,
    0x1BDD, 0x2039, 0x239A, 0x2239, 0x1AFB, 0x0ECA, 0x01F7, 0xF76F, 0xEE54, 0xE724, 0xE138, 0xDC1A, 0xD819, 0xD4ED, 0xD427, 0xD46B,
    0xD56A, 0xDA1E, 0xDF9B, 0xE411, 0xE5E7, 0xE58D, 0xE331, 0xE091, 0xE07D, 0xE468, 0xEBDC, 0xF42F, 0xFC4F, 0x0281, 0x0841, 0x0EE0,
    0x1771, 0x1F9F, 0x2684, 0x2B83, 0x3045, 0x3250, 0x2E6C, 0x261E, 0x1B1F, 0x1118, 0x0855, 0x003A, 0xF94E, 0xF309, 0xED4F, 0xEA06,
    0xE905, 0xE9C1, 0xEC1F, 0xF27A, 0xFB0F, 0x039F, 0x09A2, 0x0CDB, 0x0DCC, 0x0C87, 0x0C61, 0x0EFA, 0x14CC, 0x1B7B, 0x213C, 0x2432,
    0x25BD, 0x280B, 0x2C7C, 0x3166, 0x35D6, 0x3932, 0x3C26, 0x3D00, 0x38F0, 0x3001, 0x23DC, 0x1798, 0x0C71, 0x02E0, 0xFA79, 0xF2F4,
    0xEB75, 0xE550, 0xE0E6, 0xDDFE, 0xDBA7, 0xDBC1, 0xDEA2, 0xE26F, 0xE4D6, 0xE557, 0xE409, 0xE09D, 0xDD0A, 0xDE95, 0xE60F, 0xE91E,
    0xEAA3, 0xEC83, 0xEF75, 0xF2B5, 0xF801, 0xFE11, 0x0402, 0x0A32, 0x0DA0, 0x1277, 0x1052, 0x0BB4, 0x024B, 0xF872, 0xEF0F, 0xE954,
    0xE3FB, 0xDFF1, 0xDC7C, 0xD41A, 0xD3E9, 0xD884, 0xDF04, 0xE464, 0xEC83, 0xF427, 0x0E78, 0x1965, 0x11A1, 0x116F, 0x0D50, 0x0C1D,
    0x0E3F, 0x1113, 0x1362, 0x1994, 0x1964, 0x1D4B, 0x1EE4, 0x2611, 0x2B5E, 0x2CC9, 0x308C, 0x3330, 0x3616, 0x2C89, 0x2936, 0x0E56,
    0xF49D, 0xEFE8, 0xE5EE, 0xE21D, 0xD89B, 0xD4AD, 0xCB71, 0xD008, 0xE15C, 0xE669, 0xEB72, 0xE704, 0xE40B, 0xE2C9, 0xE375, 0xDF62,
    0xDAD5, 0xD483, 0xD1AF, 0xD2D1, 0xD88E, 0xE3B5, 0xE615, 0xED8D, 0xEEF5, 0xF952, 0xFE3F, 0x0357, 0x0AEF, 0xFF9C, 0xFC18, 0xF464,
    0xF2CE, 0xF0FF, 0xECC4, 0xED44, 0xEAE9, 0xEC32, 0xECCF, 0xF166, 0xF4A5, 0xF8A7, 0x00F1, 0x0811, 0x0F12, 0x15A8, 0x1A09, 0x1F1E,
    0x24D3, 0x28AD, 0x29D3, 0x291B, 0x2A53, 0x29CD, 0x2D08, 0x3242, 0x3425, 0x362C, 0x34F4, 0x35EB, 0x356C, 0x3508, 0x3450, 0x300E,
    0x2D1E, 0x2926, 0x2561, 0x2300, 0x210B, 0x1D21, 0x1924, 0x1348, 0x0D81, 0x08B7, 0x0499, 0x039E, 0x024B, 0x02BC, 0x02E4, 0x02C4,
    0x0443, 0x03E4, 0x0420, 0x0380, 0x0186, 0xFF1A, 0xFE28, 0xFEB6, 0xFF70, 0x0240, 0x04A4, 0x06B7, 0x0874, 0x0A1E, 0x0A2B, 0x09ED,
    0x08A9, 0x06C3, 0x044B, 0x0070, 0xFBF5, 0xF737, 0xF424, 0xEF39, 0xEB02, 0xE5F3, 0xE049, 0xDC47, 0xD879, 0xD6E7, 0xD6EC, 0xD7FB,
    0xD974, 0xDB27, 0xDDBE, 0xE07F, 0xE291, 0xE4D3, 0xE694, 0xE83D, 0xE9D8, 0xEC35, 0xEE94, 0xF058, 0xF2B0, 0xF4AA, 0xF582, 0xF6B3,
    0xF701, 0xF526, 0xF4F9, 0xF500, 0xF511, 0xF3AA, 0xEFD5, 0xEB68, 0xEB54, 0xED5D, 0xEBEA, 0xEB8D, 0xEB4E, 0xE9C3, 0xE9B5, 0xEA21,
    0xEB22, 0xEC2A, 0xED25, 0xECF3, 0xED84, 0xE8CF, 0xE7B9, 0xEEDE, 0xF04E, 0xEEDE, 0xEBA1, 0xEC11, 0xED54, 0xF2C5, 0xF718, 0xF77E,
    0xF6FE, 0xF857, 0xF9E5, 0xFCC5, 0x0119, 0x004C, 0x0017, 0xFFFB, 0x02A4, 0x032E, 0x0676, 0x0702, 0x0896, 0x09CC, 0x0799, 0x07A8,
    0x04DE, 0x028F, 0x0068, 0xFF55, 0xFCBE, 0xFBDA, 0xFB54, 0xFC6B, 0xFFFD, 0x017D, 0x0130, 0x0054, 0x00A8, 0xFF4E, 0xFF6E, 0x00B5,
    0x01DC, 0x03F2, 0x01E3, 0x0025, 0x0301, 0x0301, 0x02D3, 0x0323, 0x03CD, 0x04CF, 0x021A, 0xFC5D, 0xF813, 0xF68D, 0xF538, 0xFACF,
    0xFA06, 0xF718, 0xF3E4, 0xF16D, 0xF4E0, 0xF61C, 0xF51B, 0xF220, 0xF0F2, 0xECC2, 0xEC7A, 0xF009, 0xF6B9, 0xF5A6, 0xF00E, 0xEE9F,
    0xEF84, 0xF045, 0xF122, 0xEEE4, 0xE79B, 0xE3E2, 0xDF87, 0xDDDA, 0xDC2A, 0xDC72, 0xD953, 0xD63F, 0xD63B, 0xD5E5, 0xD7E6, 0xD663,
    0xD998, 0xDD51, 0xDF48, 0xE21A, 0xE52B, 0xE961, 0xEC88, 0xEFFC, 0xF290, 0xF691, 0xF9F6, 0xFE1E, 0x02AF, 0x07CE, 0x0D58, 0x114A,
    0x14EC, 0x1966, 0x1BDD, 0x1E3E, 0x2466, 0x2ABC, 0x2EF5, 0x2F9B, 0x3395, 0x33D1, 0x3068, 0x2DE3, 0x2CE0, 0x2AF5, 0x2943, 0x2597,
    0x22DD, 0x2127, 0x1FF0, 0x269C, 0x290E, 0x2815, 0x21F4, 0x1F4F, 0x1D62, 0x1C04, 0x1A90, 0x16AB, 0x13E5, 0x0E2C, 0x09DF, 0x093F,
    0x0C07, 0x0CE3, 0x0B40, 0x04E7, 0x0069, 0xFCDF, 0xFCE5, 0xF9E1, 0xF2DF, 0xED97, 0xE4ED, 0xDC00, 0xD46E, 0xD1BF, 0xCA82, 0xC3CB,
    0xC1CA, 0xC097, 0xC027, 0xBF34, 0xC0EF, 0xC331, 0xC4E3, 0xC7B4, 0xCB5E, 0xCD33, 0xD26B, 0xDB31, 0xE138, 0xE5E4, 0xEB29, 0xF198,
    0xF6CA, 0xFBAE, 0x004C, 0x0433, 0x05FE, 0x0818, 0x0C20, 0x0E57, 0x1063, 0x15D0, 0x1A81, 0x1D7C, 0x207E, 0x21D9, 0x2190, 0x1F82,
    0x1FB8, 0x205E, 0x22D5, 0x223C, 0x2109, 0x1E46, 0x1B47, 0x1B18, 0x1CD6, 0x1DC2, 0x195C, 0x15D2, 0x10A1, 0x0D13, 0x0C29, 0x05E2,
    0xFEF5, 0xF617, 0xF00C, 0xF3CE, 0xEED3, 0xECE0, 0xEFF7, 0xECAA, 0xE8F3, 0xE88E, 0xE829, 0xE904, 0xE595, 0xE3F1, 0xDF4F, 0xDBF0,
    0xE046, 0xDE9B, 0xDF01, 0xDC23, 0xDA09, 0xD575, 0xD2C1, 0xCF97, 0xCFC7, 0xD45A, 0xD4A1, 0xD5D2, 0xE16B, 0xEE8D, 0xF342, 0xF4B0,
    0xF54E, 0xF4DC, 0xF28F, 0xF2D8, 0xF1D8, 0xF3EF, 0xF72D, 0xFB12, 0xFE70, 0x0D86, 0x1A25, 0x1EBA, 0x20EB, 0x229D, 0x28B7, 0x2965,
    0x2BA5, 0x2E52, 0x2EE1, 0x32F3, 0x31D8, 0x3667, 0x44FF, 0x48DA, 0x499E, 0x451B, 0x4267, 0x3DD1, 0x3E9A, 0x4059, 0x3F96, 0x3E5A,
    0x384F, 0x3376, 0x32E4, 0x3917, 0x3723, 0x34DD, 0x2D9E, 0x2066, 0x0328, 0xEC33, 0xE033, 0xCD16, 0xC1F7, 0xC10B, 0xBF11, 0xC472,
    0xCCAF, 0xD522, 0xE025, 0xE15F, 0xE3E8, 0xDE26, 0xDF43, 0xD45A, 0xBDC5, 0xB6EB, 0xB5A8, 0xBB58, 0xC264, 0xD2D2, 0xEC75, 0x01C5,
    0x11B5, 0x1DDB, 0x2118, 0x17E8, 0x14D6, 0x15D5, 0x17DB, 0x123E, 0x0E43, 0x06D5, 0xED7B, 0xD792, 0xC8D2, 0xBF03, 0xB7DD, 0xBC19,
    0xB8CB, 0xB84E, 0xBC68, 0xC65C, 0xCE4F, 0xD456, 0xE094, 0xE580, 0xF262, 0xF536, 0xE900, 0xDFA1, 0xDD5C, 0xDFC3, 0xE1E3, 0xEA4B,
    0x021F, 0x1A06, 0x2A76, 0x368D, 0x391D, 0x2E91, 0x2A1D, 0x2D12, 0x3590, 0x35FC, 0x35E9, 0x3300, 0x1D8D, 0x08BE, 0xFC59, 0xF4A8,
    0xEDA9, 0xF058, 0xEEC5, 0xF1AC, 0xF5B4, 0xFC80, 0x00DD, 0x02B5, 0x085A, 0x08AF, 0x149C, 0x1C0C, 0x1409, 0x0876, 0x00A9, 0xFFB6,
    0xFD6E, 0x00AD, 0x10FE, 0x2474, 0x321D, 0x4045, 0x477E, 0x42D0, 0x3D9F, 0x39AC, 0x3BE9, 0x34FF, 0x2E5F, 0x23D6, 0x0BF1, 0xED07,
    0xD697, 0xC470, 0xB9E6, 0xBD66, 0xBE38, 0xC0B1, 0xC2D0, 0xCD6A, 0xD2EA, 0xDAA1, 0xE2BE, 0xE781, 0xF435, 0xFE3A, 0xFF0A, 0xF862,
    0xF564, 0xF663, 0xF663, 0xF85C, 0x03B1, 0x16A6, 0x252B, 0x35EB, 0x3F8B, 0x3B68, 0x3274, 0x2BAC, 0x2F04, 0x2B2C, 0x28C8, 0x2542,
    0x11FC, 0xF551, 0xE074, 0xCF23, 0xC52D, 0xC1DB, 0xBDE4, 0xBC28, 0xBC12, 0xC304, 0xC7E1, 0xD0B0, 0xD57C, 0xD479, 0xDB61, 0xE4B1,
    0xE67D, 0xDDBA, 0xD6B0, 0xD714, 0xD813, 0xD8E2, 0xE534, 0xF9BB, 0x0755, 0x19EA, 0x273A, 0x2A0C, 0x23BB, 0x2009, 0x237B, 0x24C7,
    0x2761, 0x2782, 0x1FB0, 0x0A86, 0xF798, 0xE2C2, 0xD4E6, 0xCD86, 0xCEDA, 0xCF05, 0xD072, 0xDCA6, 0xE294, 0xED3C, 0xF51A, 0xFC5B,
    0x08C1, 0x141D, 0x155C, 0x08C2, 0xFA51, 0xF27E, 0xF07B, 0xED36, 0xF60B, 0x0A7E, 0x1D07, 0x3452, 0x4839, 0x5105, 0x4A53, 0x4288,
    0x4278, 0x412D, 0x41BE, 0x4689, 0x4179, 0x2E28, 0x17BA, 0x00FE, 0xF213, 0xEAB9, 0xE87F, 0xE3CE, 0xE0FE, 0xE3CC, 0xE64B, 0xEF30,
    0xF69E, 0xF522, 0xF39A, 0xF6CD, 0xFA9D, 0xF232, 0xE2AA, 0xD9CE, 0xD416, 0xCAB9, 0xCC37, 0xD357, 0xD976, 0xE70B, 0xF5C3, 0x0144,
    0x001B, 0xFCE7, 0xFD32, 0x00E6, 0x02FA, 0x0B2D, 0x0FB5, 0x0971, 0xFFA1, 0xEFF6, 0xE069, 0xD505, 0xD836, 0xD79A, 0xDA6B, 0xE340,
    0xE8CA, 0xF1F1, 0xF807, 0xFAD9, 0x018D, 0x101E, 0x1CB9, 0x1EED, 0x1B4B, 0x1A35, 0x1B00, 0x15DC, 0x159A, 0x1B89, 0x231E, 0x316B,
    0x454D, 0x5710, 0x58EC, 0x53EA, 0x5452, 0x51D0, 0x4AA4, 0x4918, 0x4170, 0x2F31, 0x157E, 0xFB2A, 0xE758, 0xDB68, 0xD892, 0xD4B6,
    0xD344, 0xD42B, 0xD55A, 0xDC7D, 0xE539, 0xE6B0, 0xE5F6, 0xEC01, 0xF5DB, 0xF90E, 0xF143, 0xEBC1, 0xE99E, 0xE131, 0xE074, 0xE667,
    0xEE24, 0xF843, 0x07D2, 0x1875, 0x1FF5, 0x1FEE, 0x206E, 0x219F, 0x1E02, 0x2088, 0x2305, 0x21D0, 0x172A, 0x0808, 0xF3C6, 0xDFED,
    0xDA13, 0xD4DF, 0xD2F9, 0xD5F6, 0xDB61, 0xE394, 0xECE3, 0xF19B, 0xF6DE, 0x04BE, 0x14D9, 0x2066, 0x20BB, 0x1F6D, 0x2299, 0x2313,
    0x2601, 0x2E8D, 0x3817, 0x4226, 0x50AF, 0x5FEA, 0x63E2, 0x5C65, 0x5838, 0x540C, 0x4EC4, 0x5057, 0x54C5, 0x52B1, 0x47A6, 0x384D,
    0x2534, 0x14C5, 0x0C82, 0x06BB, 0x03CD, 0x0573, 0x05B3, 0x0B8B, 0x1739, 0x1E4E, 0x2091, 0x2227, 0x252F, 0x2794, 0x1D86, 0x1183,
    0x07D5, 0xF94D, 0xEFAF, 0xEE89, 0xF24B, 0xF8FA, 0x0556, 0x15DD, 0x227D, 0x2185, 0x1ED0, 0x1AA9, 0x1531, 0x1425, 0x162A, 0x173D,
    0x0EDE, 0x05FE, 0xF4CC, 0xDE17, 0xCEF3, 0xC35D, 0xBC7E, 0xB8C5, 0xB7FF, 0xBB69, 0xC1CC, 0xC426, 0xC349, 0xC5BB, 0xCD68, 0xD79D,
    0xDA15, 0xD8EC, 0xD872, 0xD449, 0xD0AA, 0xD2D5, 0xD655, 0xD9CF, 0xDFDE, 0xF17A, 0x03AD, 0x099B, 0x0C71, 0x0C26, 0x0AAC, 0x0A96,
    0x10E1, 0x16E0, 0x1606, 0x0FFF, 0x0484, 0xFB22, 0xF743, 0xF54A, 0xF6BD, 0xFA1F, 0xFA8C, 0xFBA2, 0x029F, 0x0A26, 0x0E1F, 0x0F68,
    0x146A, 0x1F19, 0x22E7, 0x2143, 0x1ED4, 0x193D, 0x116D, 0x0D63, 0x0E53, 0x1316, 0x1B73, 0x2B3E, 0x3D8A, 0x4881, 0x5087, 0x535E,
    0x5505, 0x5543, 0x560A, 0x5596, 0x4C48, 0x4337, 0x323D, 0x190B, 0x036D, 0xF2A2, 0xE70D, 0xE0FB, 0xDDC9, 0xDD46, 0xE0BA, 0xE2E0,
    0xE194, 0xDF76, 0xE45A, 0xEF48, 0xF653, 0xF5E7, 0xF511, 0xF25B, 0xED50, 0xEB69, 0xECAC, 0xEF29, 0xF0AC, 0xFD41, 0x102D, 0x1BC5,
    0x2008, 0x1E5C, 0x1824, 0x1053, 0x0E9A, 0x11D7, 0x1152, 0x0C0A, 0xFD53, 0xEA3D, 0xDD32, 0xD249, 0xCB09, 0xC864, 0xC373, 0xBFC3,
    0xC27F, 0xC822, 0xCD6C, 0xCDFA, 0xD094, 0xD97E, 0xE097, 0xE317, 0xE55D, 0xE5BE, 0xE297, 0xE12D, 0xE32D, 0xE84B, 0xEF41, 0xFDDE,
    0x110A, 0x1FA6, 0x28A1, 0x2B07, 0x2BCD, 0x2A62, 0x2BEB, 0x323F, 0x34BC, 0x3714, 0x3322, 0x2573, 0x140A, 0x017C, 0xF11A, 0xE864,
    0xE40E, 0xE404, 0xEB15, 0xF6B8, 0x00C1, 0x0325, 0x0869, 0x150A, 0x2037, 0x237D, 0x2389, 0x20DA, 0x1AC5, 0x1351, 0x126E, 0x154B,
    0x142E, 0x1A94, 0x2B29, 0x3C42, 0x455F, 0x48E1, 0x4890, 0x43A1, 0x410A, 0x41CC, 0x429C, 0x4343, 0x3BCB, 0x2CD8, 0x1E2D, 0x0E12,
    0xFF65, 0xF800, 0xF144, 0xE9C1, 0xE4AD, 0xE445, 0xE83B, 0xE755, 0xE403, 0xE58B, 0xE97C, 0xE95C, 0xE599, 0xDFE5, 0xD725, 0xCC4C,
    0xC4EB, 0xC0F1, 0xBCC3, 0xBE5F, 0xC4CF, 0xCEEC, 0xD7EF, 0xDB30, 0xDC7F, 0xD8BB, 0xD82C, 0xDC32, 0xDE9E, 0xE1CF, 0xE3EF, 0xE027,
    0xD8C1, 0xD078, 0xC816, 0xC4F6, 0xC593, 0xC718, 0xCA45, 0xD134, 0xD831, 0xD993, 0xD8B9, 0xE0B5, 0xEDF5, 0xF865, 0x00EE, 0x06DD,
    0x06F2, 0xFFCE, 0xFD3F, 0xFF4F, 0xFDC0, 0xFF08, 0x0A4D, 0x1D7F, 0x2E38, 0x3A7F, 0x424E, 0x4205, 0x415F, 0x4112, 0x40E5, 0x4152,
    0x3B6A, 0x2CD3, 0x1BD0, 0x0751, 0xF373, 0xE91C, 0xE46D, 0xE126, 0xDE89, 0xE01D, 0xE50E, 0xE6F1, 0xE441, 0xE501, 0xEA29, 0xEDD0,
    0xF031, 0xF182, 0xEFBF, 0xE87C, 0xE19D, 0xDDB5, 0xD8FB, 0xD8E0, 0xDF4A, 0xECF7, 0xFA9C, 0x03ED, 0x09FF, 0x07E8, 0x04FF, 0x0432,
    0x0406, 0x04EF, 0x05E7, 0x02B0, 0xFB2F, 0xEF64, 0xDFA8, 0xD1B3, 0xC878, 0xC21A, 0xBD9A, 0xBF19, 0xC4FB, 0xC7A9, 0xC502, 0xC661,
    0xCE2B, 0xD8E7, 0xE158, 0xE7A1, 0xED01, 0xEBBA, 0xEC2F, 0xF328, 0xF9A4, 0xFEDD, 0x086C, 0x1A79, 0x2C62, 0x399B, 0x4143, 0x4170,
    0x3FDD, 0x3E23, 0x3D13, 0x409B, 0x4428, 0x40B5, 0x3A4D, 0x2E0D, 0x1D48, 0x100E, 0x0743, 0x00CD, 0xFAB6, 0xF889, 0xFE24, 0x0697,
    0x0BA0, 0x0F50, 0x15DC, 0x1B4A, 0x1B93, 0x197A, 0x14E9, 0x0A28, 0xFF36, 0xF629, 0xED78, 0xE8CB, 0xE9DA, 0xF440, 0x014E, 0x0E3B,
    0x19EE, 0x1EAD, 0x1FA4, 0x229A, 0x251D, 0x26E6, 0x2938, 0x28D3, 0x24AD, 0x1B83, 0x0D0D, 0xFC66, 0xEF78, 0xE4CE, 0xDB8F, 0xD5C9,
    0xD64B, 0xD6BF, 0xD1D2, 0xCC8F, 0xCBFA, 0xD02E, 0xD370, 0xD6FA, 0xD923, 0xD3FB, 0xCD57, 0xC999, 0xC89E, 0xC61F, 0xC3D6, 0xC9D4,
    0xD3BB, 0xE05E, 0xEBBE, 0xEF71, 0xEFD8, 0xEF0D, 0xEBF2, 0xEEB7, 0xF464, 0xF5A7, 0xF5BE, 0xF2AE, 0xEA9A, 0xE1F7, 0xDE86, 0xDFE4,
    0xE12F, 0xE1F8, 0xE6B1, 0xEC8E, 0xEF00, 0xEF33, 0xF2A1, 0xF951, 0xFE47, 0x0347, 0x0967, 0x0A55, 0x0724, 0x0147, 0xFB26, 0xF5AF,
    0xF233, 0xF80B, 0x0432, 0x15FE, 0x2A39, 0x3935, 0x4144, 0x4666, 0x4975, 0x4BFF, 0x4E56, 0x4EFE, 0x4C50, 0x459A, 0x3A04, 0x28A7,
    0x1647, 0x073F, 0xFA75, 0xEF56, 0xEB75, 0xEC5A, 0xEC23, 0xE718, 0xE371, 0xE641, 0xE936, 0xECA7, 0xF1EF, 0xF429, 0xF1F9, 0xEEC8,
    0xEEDA, 0xEEFD, 0xED4F, 0xEF89, 0xF7A6, 0x04C0, 0x1356, 0x1C2A, 0x1FD3, 0x2157, 0x1D3E, 0x194F, 0x19FE, 0x1922, 0x16D6, 0x12AE,
    0x087C, 0xF81D, 0xE791, 0xDC62, 0xD211, 0xC890, 0xC42D, 0xC34D, 0xC395, 0xC0F4, 0xBFC0, 0xC37C, 0xC5DC, 0xC80B, 0xCAFA, 0xCB1E,
    0xC9AB, 0xC79E, 0xC6D1, 0xC4F8, 0xC384, 0xC752, 0xCFFD, 0xDD23, 0xEE26, 0xFD6E, 0x068E, 0x0C6C, 0x110F, 0x1434, 0x1814, 0x1C93,
    0x2025, 0x2309, 0x2096, 0x168F, 0x06A5, 0xF844, 0xEC23, 0xE016, 0xDAC0, 0xDE9E, 0xE758, 0xEB25, 0xEC9B, 0xF3B6, 0xFB6A, 0x03A5,
    0x0C74, 0x124C, 0x11B4, 0x0B4F, 0x07BB, 0x0602, 0x041E, 0x04D1, 0x09F9, 0x14A0, 0x238E, 0x303D, 0x3903, 0x3FA4, 0x3FE3, 0x3C99,
    0x3DAC, 0x3FD8, 0x405C, 0x419A, 0x3FD7, 0x3595, 0x2565, 0x18C5, 0x0FC2, 0x06F4, 0x00F4, 0xFF60, 0x003B, 0xFD64, 0xF731, 0xF6D0,
    0xF6BE, 0xF59E, 0xF5C3, 0xF593, 0xF3D2, 0xED67, 0xE650, 0xDCFC, 0xD18C, 0xC966, 0xC6BC, 0xCA9F, 0xD43F, 0xDE76, 0xE56C, 0xE7D9,
    0xE76C, 0xE4D0, 0xE1DB, 0xE019, 0xDF16, 0xDFBA, 0xE116, 0xDF57, 0xD8B2, 0xD15F, 0xCACB, 0xC454, 0xBFB0, 0xC14A, 0xC845, 0xCCC9,
    0xCCE9, 0xCEF6, 0xD3F0, 0xD9CD, 0xE1D3, 0xED35, 0xF63C, 0xF986, 0xFA99, 0xF99B, 0xF72D, 0xF588, 0xF672, 0xFC2C, 0x0A68, 0x1CD0,
    0x2EA0, 0x3E52, 0x4735, 0x49EE, 0x4BCD, 0x4D5C, 0x4C6E, 0x4A49, 0x4932, 0x41F7, 0x3270, 0x218B, 0x125D, 0x0457, 0xF79F, 0xF099,
    0xF088, 0xF051, 0xED96, 0xED72, 0xEEEC, 0xEFD2, 0xF0AF, 0xF3EA, 0xF59B, 0xF359, 0xEFA9, 0xE9F4, 0xE283, 0xDC3C, 0xDA2C, 0xDD9E,
    0xE776, 0xF5D7, 0x03AA, 0x0D61, 0x1360, 0x164D, 0x1745, 0x17EC, 0x1846, 0x1839, 0x1A08, 0x1827, 0x0E20, 0x001D, 0xF120, 0xE321,
    0xD4FD, 0xCC08, 0xCC69, 0xCD99, 0xCC12, 0xCAA3, 0xCBCE, 0xCE34, 0xD0B1, 0xD651, 0xDC31, 0xDF53, 0xE105, 0xE24E, 0xE3F4, 0xE702,
    0xEAE7, 0xF1A8, 0x004E, 0x13A9, 0x247E, 0x33AD, 0x3D57, 0x3FA5, 0x4017, 0x40AD, 0x4125, 0x40E7, 0x43E3, 0x4646, 0x3E85, 0x2FE8,
    0x207B, 0x1269, 0x048C, 0xF8D6, 0xF681, 0xF7F7, 0xF951, 0xFCAF, 0x0178, 0x064B, 0x0AB6, 0x0FC7, 0x136A, 0x1247, 0x0F4B, 0x0AC7,
    0x0187, 0xF774, 0xEEFB, 0xEAB4, 0xEE41, 0xF9B0, 0x08EE, 0x15FA, 0x1E47, 0x2378, 0x250E, 0x24E9, 0x2541, 0x25F6, 0x2897, 0x2A9D,
    0x26B8, 0x1CE1, 0x1053, 0x0342, 0xF403, 0xE4EC, 0xDDD1, 0xDC37, 0xDA73, 0xD680, 0xD266, 0xCF0E, 0xCC2B, 0xCC7C, 0xD083, 0xD404,
    0xD602, 0xD6A5, 0xD3BD, 0xD180, 0xCF4F, 0xCC82, 0xCEAE, 0xD659, 0xE036, 0xEC2A, 0xF768, 0xFE61, 0xFFFA, 0xFF18, 0xFC2F, 0xF656,
    0xF4EE, 0xF93A, 0xFAD8, 0xF3FC, 0xEA58, 0xE33A, 0xDC30, 0xD554, 0xD591, 0xDAA7, 0xDD7F, 0xDE8F, 0xE15C, 0xE64E, 0xEB85, 0xF284,
    0xFA5A, 0xFFE3, 0x03A0, 0x0634, 0x03CE, 0xFD37, 0xF565, 0xEE7A, 0xEDBE, 0xF545, 0x0426, 0x16AC, 0x27F4, 0x3708, 0x404F, 0x4547,
    0x4952, 0x4B5D, 0x4D4D, 0x4EE6, 0x4DBE, 0x46CE, 0x3A70, 0x2DC1, 0x1F75, 0x0E2F, 0x008C, 0xFA19, 0xF757, 0xF35A, 0xEF86, 0xED73,
    0xEB5B, 0xEB60, 0xEEB4, 0xF3A1, 0xF7C2, 0xF892, 0xF59D, 0xF2A7, 0xF16F, 0xEFEC, 0xF15E, 0xF8DA, 0x0353, 0x0F03, 0x1B90, 0x251C,
    0x2874, 0x27BD, 0x261A, 0x2185, 0x1C6F, 0x1D55, 0x1FE8, 0x1B4C, 0x0E57, 0x007C, 0xF2C7, 0xE2B3, 0xD693, 0xD278, 0xD205, 0xD1DB,
    0xD1A3, 0xD22D, 0xD225, 0xD29B, 0xD4A3, 0xD5D4, 0xD6E3, 0xD973, 0xDA67, 0xD838, 0xD516, 0xD256, 0xD1D6, 0xD62A, 0xE121, 0xEF6A,
    0xFDAA, 0x0A1C, 0x1388, 0x1A61, 0x1EAC, 0x1FEB, 0x20F7, 0x23DB, 0x2894, 0x29D0, 0x2320, 0x192D, 0x0CA9, 0xFB95, 0xEA62, 0xE0F1,
    0xDEBE, 0xDF63, 0xE298, 0xE72B, 0xEB45, 0xEF40, 0xF5EF, 0xFEE8, 0x0701, 0x0D47, 0x0E97, 0x0D70, 0x0C72, 0x08D2, 0x05B6, 0x06A4,
    0x0CCF, 0x157F, 0x21B5, 0x2F55, 0x3810, 0x3D56, 0x413B, 0x409E, 0x3BB1, 0x38CC, 0x3D02, 0x4016, 0x3A43, 0x322A, 0x296C, 0x1D07,
    0x0D6F, 0x0351, 0x0007, 0xFDB3, 0xFC5A, 0xFC0E, 0xFB82, 0xF9EF, 0xFA30, 0xFB58, 0xFA29, 0xF935, 0xF826, 0xF42A, 0xED2F, 0xE2E2,
    0xD85F, 0xD140, 0xD00B, 0xD44F, 0xDB3B, 0xE476, 0xEBA4, 0xF021, 0xF2C2, 0xF13D, 0xED96, 0xEA6F, 0xEA9E, 0xEB95, 0xE7A1, 0xE14C,
    0xDC24, 0xD5DD, 0xCD52, 0xC705, 0xC621, 0xC801, 0xCB0D, 0xCF04, 0xD282, 0xD620, 0xDACD, 0xE167, 0xEA30, 0xF534, 0xFE06, 0x0185,
    0x01B4, 0xFE3B, 0xF8C5, 0xF631, 0xF89F, 0xFEC6, 0x08F4, 0x1807, 0x269E, 0x31F0, 0x3B69, 0x40F2, 0x40E9, 0x3D73, 0x3EA4, 0x43F4,
    0x426A, 0x3A9F, 0x3160, 0x2490, 0x115C, 0xFF4B, 0xF627, 0xF0F3, 0xEE53, 0xEDC3, 0xED38, 0xECCC, 0xED39, 0xEF0E, 0xEFEB, 0xF09B,
    0xF26D, 0xF3E8, 0xF1C5, 0xEC7E, 0xE586, 0xDDE4, 0xDA52, 0xDD29, 0xE4BF, 0xF0B2, 0xFC23, 0x0489, 0x0AA7, 0x0C6F, 0x0B96, 0x0A69,
    0x0BED, 0x1106, 0x123A, 0x0E5A, 0x0903, 0x0002, 0xF286, 0xE292, 0xD706, 0xD0B4, 0xCE34, 0xCFBC, 0xD141, 0xD128, 0xD127, 0xD220,
    0xD3E4, 0xD8C4, 0xDEB8, 0xE2DF, 0xE62D, 0xE953, 0xEBBD, 0xEE92, 0xF59D, 0xFED6, 0x08C9, 0x17CA, 0x2815, 0x352B, 0x3F41, 0x46A6,
    0x49F3, 0x47C4, 0x465D, 0x4C0C, 0x5188, 0x4EF0, 0x47F1, 0x3ECD, 0x30DD, 0x1EAC, 0x10CF, 0x07D2, 0x0237, 0x013C, 0x023E, 0x04AE,
    0x0736, 0x0A65, 0x0DEA, 0x112C, 0x140D, 0x164E, 0x1657, 0x1316, 0x0CB3, 0x0264, 0xF7F5, 0xF281, 0xF3AA, 0xFAF6, 0x052F, 0x0F57,
    0x18A4, 0x1EEF, 0x2209, 0x20F9, 0x1F11, 0x20EB, 0x22ED, 0x2204, 0x1E3A, 0x18B1, 0x108C, 0x0414, 0xF787, 0xED6B, 0xE660, 0xE35E,
    0xE0D2, 0xDC40, 0xD817, 0xD526, 0xD336, 0xD4D3, 0xD98A, 0xDD06, 0xDDFB, 0xDCDF, 0xD99D, 0xD535, 0xD2E8, 0xD3BB, 0xD625, 0xDCEE,
    0xE7C3, 0xF22F, 0xFAA4, 0x00F9, 0x04C4, 0x01B3, 0xFA50, 0xF7F1, 0xFB30, 0xFC96, 0xF948, 0xF5BD, 0xEFBA, 0xE42F, 0xDB29, 0xD7DD,
    0xD7CC, 0xDBE0, 0xE167, 0xE55F, 0xE7FE, 0xEBBE, 0xF15C, 0xF85D, 0x00D4, 0x0953, 0x10D1, 0x14C7, 0x1418, 0x0E76, 0x0584, 0xFE17,
    0xFB5F, 0xFF20, 0x0A22, 0x187F, 0x274B, 0x3454, 0x3D16, 0x4039, 0x3F5C, 0x4152, 0x4626, 0x4807, 0x4610, 0x4282, 0x3C65, 0x30ED,
    0x2273, 0x13D5, 0x06D7, 0xFEB9, 0xFA40, 0xF68E, 0xF2C2, 0xEF47, 0xEB9B, 0xE96C, 0xEB6C, 0xEEB2, 0xF141, 0xF2D5, 0xF253, 0xEE43,
    0xEB09, 0xEADF, 0xEC41, 0xF030, 0xF8E2, 0x042D, 0x0D1C, 0x14ED, 0x1D78, 0x228B, 0x1F9A, 0x1B26, 0x1C4C, 0x1FAB, 0x1ECE, 0x1AF0,
    0x15B5, 0x09EC, 0xF8D5, 0xE942, 0xDE7C, 0xD96A, 0xD88C, 0xD869, 0xD825, 0xD6D6, 0xD5C4, 0xD542, 0xD5B0, 0xD714, 0xD7F5, 0xD8E4,
    0xD967, 0xD835, 0xD4EF, 0xD125, 0xCF97, 0xD20A, 0xD9A1, 0xE52F, 0xF2BF, 0x00D7, 0x0D6A, 0x177C, 0x1D26, 0x2233, 0x2B11, 0x32F3,
    0x364A, 0x3641, 0x33AE, 0x2C61, 0x2084, 0x129D, 0x030C, 0xF713, 0xF20D, 0xF0BC, 0xF1AC, 0xF367, 0xF3ED, 0xF432, 0xF81F, 0x001B,
    0x079F, 0x0E32, 0x1196, 0x0F66, 0x0BE3, 0x08CA, 0x063C, 0x055C, 0x093F, 0x12EF, 0x1D67, 0x2616, 0x303C, 0x3A1D, 0x3CA9, 0x38D8,
    0x367A, 0x3896, 0x3A6E, 0x3995, 0x3860, 0x3368, 0x2903, 0x1BE3, 0x0F7B, 0x06D1, 0x0162, 0xFE44, 0xFAA8, 0xF509, 0xF0F7, 0xEEE0,
    0xEE6C, 0xF089, 0xF2E3, 0xF561, 0xF789, 0xF667, 0xF08C, 0xE64B, 0xDB03, 0xD34B, 0xD224, 0xD7EC, 0xE11F, 0xEAE8, 0xF40A, 0xFAE3,
    0xFB6B, 0xF779, 0xF57A, 0xF4F4, 0xF368, 0xF03D, 0xEE06, 0xEAE9, 0xE56C, 0xDE54, 0xD3FC, 0xCA84, 0xC6E4, 0xC726, 0xC96A, 0xCCB6,
    0xCF1F, 0xD0A6, 0xD449, 0xDC3C, 0xE622, 0xF1A8, 0xFD4C, 0x054A, 0x099B, 0x0BB5, 0x0D03, 0x0CB4, 0x0DF8, 0x14E7, 0x1FE8, 0x2BCC,
    0x3828, 0x46D7, 0x5127, 0x52DC, 0x51E8, 0x533F, 0x5655, 0x568F, 0x541B, 0x4FED, 0x47EC, 0x3B42, 0x2967, 0x17FE, 0x0B6C, 0x03BF,
    0xFF55, 0xF987, 0xF48A, 0xF171, 0xEF77, 0xEF29, 0xEE1F, 0xED5B, 0xED31, 0xED4A, 0xEC97, 0xE890, 0xE1FC, 0xDB5F, 0xD873, 0xDA39,
    0xDF75, 0xE78A, 0xF085, 0xFAAE, 0x0172, 0x02B1, 0x0383, 0x05E0, 0x08C3, 0x09BF, 0x09A4, 0x072F, 0x0145, 0xFA34, 0xEF47, 0xE265,
    0xD8C1, 0xD31C, 0xD0E9, 0xCFDD, 0xCFC7, 0xCEC2, 0xCC87, 0xCD0A, 0xCE80, 0xD0F4, 0xD583, 0xD9EA, 0xDC81, 0xDF03, 0xE283, 0xE4D9,
    0xE782, 0xEEC1, 0xFB5C, 0x0946, 0x166E, 0x2627, 0x363F, 0x3FFF, 0x438D, 0x4609, 0x4A1E, 0x4DFC, 0x502E, 0x5034, 0x4CDE, 0x45E0,
    0x392A, 0x29C0, 0x1D37, 0x15CA, 0x1382, 0x12C9, 0x1218, 0x114A, 0x113C, 0x138D, 0x16FA, 0x1A8B, 0x1D42, 0x1EF1, 0x1FBA, 0x1DA4,
    0x1781, 0x0DE6, 0x030E, 0xFB55, 0xFA1F, 0xFEF1, 0x06A3, 0x10E3, 0x1A55, 0x1E40, 0x1E2B, 0x1D2E, 0x1BFA, 0x1A0C, 0x1874, 0x1728,
    0x14B6, 0x1213, 0x0C91, 0x026A, 0xF765, 0xEE7C, 0xE7E9, 0xE2E1, 0xE042, 0xDC73, 0xD655, 0xD1AC, 0xCF49, 0xCEEE, 0xD112, 0xD495,
    0xD676, 0xD53F, 0xD2D4, 0xCF65, 0xCA4B, 0xC754, 0xC9C2, 0xD06B, 0xD863, 0xE225, 0xEF4F, 0xFAEB, 0xFDF0, 0xFA57, 0xF5F3, 0xF264,
    0xF1C8, 0xF360, 0xF550, 0xF6A2, 0xF2BF, 0xE97B, 0xDE75, 0xD742, 0xD5D9, 0xD700, 0xD8EB, 0xDB19, 0xDE83, 0xE3DF, 0xEB6E, 0xF3C8,
    0xFACB, 0x015F, 0x07B4, 0x0D1C, 0x0F54, 0x0B80, 0x036C, 0xFBD7, 0xF84A, 0xFB70, 0x0325, 0x0EC1, 0x1E35, 0x2B97, 0x34BF, 0x3C67,
    0x43E6, 0x494F, 0x4D7F, 0x4FFE, 0x4FD1, 0x4F71, 0x4D55, 0x46E3, 0x3BCB, 0x2FDE, 0x2666, 0x1FEF, 0x1BE3, 0x1811, 0x11C1, 0x0ABC,
    0x048B, 0xFEFC, 0xFBA0, 0xFB76, 0xFC76, 0xFB63, 0xF8D0, 0xF5B9, 0xF007, 0xE9BC, 0xE780, 0xEB8F, 0xF123, 0xF5E8, 0xFEEE, 0x0A70,
    0x1243, 0x1422, 0x12F0, 0x1213, 0x127F, 0x1473, 0x1661, 0x1715, 0x1403, 0x0A96, 0xFBC1, 0xECC6, 0xE3DD, 0xE08A, 0xE003, 0xDFC3,
    0xDD4F, 0xDA5C, 0xD77A, 0xD454, 0xD1D0, 0xD03A, 0xD0FF, 0xD32B, 0xD55B, 0xD5A3, 0xD1B6, 0xCBFE, 0xC841, 0xC992, 0xCF0E, 0xD735,
    0xE3A1, 0xF187, 0xFD29, 0x06D5, 0x101C, 0x18B2, 0x2054, 0x284D, 0x2E0F, 0x3188, 0x341A, 0x321C, 0x29B6, 0x1DA8, 0x1200, 0x0836,
    0x01E0, 0xFF59, 0xFCDF, 0xFA8F, 0xF992, 0xF93C, 0xFB0B, 0xFF4F, 0x05EA, 0x0BEF, 0x0FF1, 0x136E, 0x1316, 0x0DE5, 0x080E, 0x07CB,
    0x0EC8, 0x1702, 0x1FBF, 0x2AA8, 0x340D, 0x3A08, 0x3B61, 0x39CC, 0x3822, 0x37C7, 0x3A55, 0x3D72, 0x3FE5, 0x3E9C, 0x372C, 0x2A47,
    0x1D84, 0x14F5, 0x0EAE, 0x099E, 0x0427, 0xFE5A, 0xF906, 0xF54F, 0xF3C6, 0xF2F5, 0xF2B3, 0xF2C6, 0xF2E9, 0xF21C, 0xEC6C, 0xE1DB,
    0xD640, 0xCE5E, 0xCCAD, 0xCED8, 0xD5ED, 0xE05A, 0xE8CE, 0xEE28, 0xF145, 0xF1DC, 0xF054, 0xEF17, 0xEDE5, 0xEBFB, 0xEAEF, 0xEB37,
    0xE890, 0xE313, 0xDB71, 0xD302, 0xCC88, 0xC8E1, 0xC6DB, 0xC525, 0xC649, 0xC96E, 0xCDE8, 0xD432, 0xDD94, 0xE7D2, 0xF044, 0xF719,
    0xFBC1, 0xFC3C, 0xF8B1, 0xF807, 0xFD8C, 0x0479, 0x0BBD, 0x16BA, 0x24DF, 0x32FB, 0x3D5D, 0x43DA, 0x480C, 0x4C71, 0x5102, 0x55D0,
    0x58FB, 0x591C, 0x5408, 0x4709, 0x3742, 0x29D5, 0x2158, 0x1CFE, 0x187A, 0x11D4, 0x0B1E, 0x05A3, 0x024B, 0xFF65, 0xFB83, 0xF836,
    0xF792, 0xF98F, 0xFA5B, 0xF70C, 0xEEB4, 0xE5DC, 0xE121, 0xDF08, 0xE131, 0xE878, 0xF18E, 0xF942, 0xFEDB, 0x0282, 0x0369, 0x04E8,
    0x06A0, 0x061B, 0x0558, 0x04D1, 0x02CB, 0xFCCC, 0xF34C, 0xE84F, 0xDD87, 0xD6CC, 0xD2C9, 0xCF4A, 0xCC89, 0xCA1C, 0xC827, 0xC5CE,
    0xC588, 0xC7A6, 0xC9B4, 0xCCC0, 0xD0FC, 0xD43F, 0xD40D, 0xD30E, 0xD668, 0xDC38, 0xE2DE, 0xEC8F, 0xFABE, 0x0C72, 0x1DEF, 0x2CA8,
    0x368C, 0x3D4A, 0x43CA, 0x4A61, 0x50AD, 0x556C, 0x574E, 0x5300, 0x481A, 0x3A83, 0x2DCE, 0x258C, 0x1FDA, 0x1A7B, 0x162C, 0x1354,
    0x1323, 0x14C4, 0x16A7, 0x184C, 0x1AC0, 0x1E62, 0x21EC, 0x2278, 0x1CA6, 0x123C, 0x095D, 0x033A, 0xFFE8, 0x02F0, 0x0A30, 0x12EB,
    0x1B78, 0x21D9, 0x252D, 0x25DA, 0x25D5, 0x24C7, 0x243D, 0x264D, 0x28DB, 0x28CB, 0x2431, 0x1B97, 0x1070, 0x0575, 0xFCE8, 0xF4F5,
    0xEE72, 0xEA0C, 0xE680, 0xE244, 0xDEDA, 0xDE9F, 0xDF0D, 0xDEA6, 0xDE2B, 0xDE19, 0xDA9C, 0xD32B, 0xCD86, 0xCC96, 0xCE6D, 0xD243,
    0xD8D4, 0xE287, 0xED50, 0xF599, 0xFA44, 0xFA23, 0xF7A6, 0xF4DD, 0xF3AA, 0xF5CC, 0xF930, 0xFA22, 0xF51F, 0xEABB, 0xDECA, 0xD55B,
    0xD070, 0xCE58, 0xCC8D, 0xCB49, 0xCB79, 0xCE98, 0xD412, 0xD9BC, 0xE074, 0xE961, 0xF411, 0xFD5E, 0x00C8, 0xFD72, 0xF854, 0xF37B,
    0xF02A, 0xF257, 0xFACF, 0x0690, 0x1308, 0x1FBD, 0x2A06, 0x3159, 0x3823, 0x3E59, 0x4335, 0x4763, 0x4BCD, 0x4E09, 0x4C3C, 0x4629,
    0x3C6E, 0x31C7, 0x2962, 0x229F, 0x1C98, 0x1878, 0x1475, 0x0E85, 0x061B, 0xFE9B, 0xF96E, 0xF641, 0xF6B3, 0xFB4C, 0xFFC1, 0xFDF5,
    0xF98B, 0xF75F, 0xF80C, 0xFA50, 0xFD82, 0x0315, 0x0B71, 0x15F8, 0x1EED, 0x2395, 0x24D0, 0x2442, 0x23E2, 0x24AD, 0x2657, 0x27E4,
    0x257E, 0x1C5E, 0x0E28, 0xFF3E, 0xF489, 0xED81, 0xE7D1, 0xE1F9, 0xDBDE, 0xD6E4, 0xD30C, 0xCFCE, 0xCC38, 0xC93F, 0xC93F, 0xCCA7,
    0xCFA8, 0xCDF3, 0xCA04, 0xC562, 0xC09D, 0xBECC, 0xC1FC, 0xC971, 0xD2F5, 0xDE7E, 0xEA94, 0xF452, 0xFDD4, 0x07AD, 0x1079, 0x1895,
    0x2027, 0x2695, 0x2A11, 0x298F, 0x242A, 0x19E2, 0x0EE0, 0x048A, 0xFB28, 0xF475, 0xF200, 0xF1B6, 0xF06E, 0xF056, 0xF23C, 0xF67E,
    0xFBD1, 0x0280, 0x0A73, 0x0E28, 0x0BFD, 0x08B5, 0x078C, 0x0993, 0x0DB9, 0x1440, 0x1E23, 0x295A, 0x3426, 0x3ACE, 0x3CDB, 0x3C5B,
    0x3A6B, 0x3A16, 0x3C06, 0x4014, 0x4366, 0x4116, 0x38C8, 0x2D4D, 0x229B, 0x19CD, 0x12FC, 0x0D67, 0x0840, 0x03F7, 0x019F, 0x00C1,
    0xFF8B, 0xFE65, 0xFE08, 0x0096, 0x03E8, 0x0318, 0xFE3C, 0xF70A, 0xEDBE, 0xE550, 0xE2AB, 0xE5A0, 0xEB84, 0xF2E2, 0xFA9D, 0xFF4C,
    0x00BA, 0x00E4, 0xFF5B, 0xFC2C, 0xF880, 0xF60B, 0xF474, 0xF1A1, 0xEBFB, 0xE25C, 0xD6BD, 0xCCAC, 0xC433, 0xBDBA, 0xBA8A, 0xB9C2,
    0xB934, 0xB868, 0xBA76, 0xBF41, 0xC4F0, 0xCD5D, 0xD994, 0xE5B6, 0xECDA, 0xEEDF, 0xEF34, 0xF002, 0xF191, 0xF55F, 0xFC90, 0x07F2,
    0x16AC, 0x2536, 0x308C, 0x3875, 0x3E05, 0x425E, 0x4767, 0x4D95, 0x534A, 0x5614, 0x52AB, 0x4927, 0x3CC9, 0x30AB, 0x26E7, 0x1F6D,
    0x1931, 0x1261, 0x0C8B, 0x07D7, 0x0376, 0xFE95, 0xF96C, 0xF70D, 0xF93C, 0xFC0C, 0xFC50, 0xFA45, 0xF5E3, 0xEF55, 0xE8FE, 0xE66A,
    0xE638, 0xE949, 0xF07C, 0xF898, 0xFF25, 0x047A, 0x0907, 0x0C41, 0x0EF5, 0x10BC, 0x110D, 0x1093, 0x0E09, 0x0844, 0xFF9A, 0xF5DE,
    0xED88, 0xE63D, 0xDFF7, 0xDC26, 0xD8DA, 0xD40B, 0xCF27, 0xCC11, 0xCA3E, 0xCA05, 0xCDCF, 0xD462, 0xD945, 0xD97F, 0xD688, 0xD41E,
    0xD415, 0xD59E, 0xD971, 0xE04D, 0xEAB6, 0xF7C9, 0x054A, 0x115F, 0x1C60, 0x2587, 0x2CA5, 0x34A9, 0x3E1E, 0x46C2, 0x4B4D, 0x48EC,
    0x40B6, 0x3574, 0x2A46, 0x2149, 0x1A41, 0x141A, 0x0E4F, 0x0A94, 0x0947, 0x09D5, 0x0B00, 0x0CCB, 0x11CC, 0x1806, 0x1B45, 0x1B65,
    0x194D, 0x1368, 0x0BCA, 0x0685, 0x054C, 0x071F, 0x0C4E, 0x1391, 0x1988, 0x1D91, 0x1FB7, 0x2105, 0x2189, 0x21DC, 0x221A, 0x2329,
    0x2597, 0x252B, 0x20F9, 0x1A37, 0x11CC, 0x082B, 0xFDE8, 0xF68E, 0xF309, 0xEFE1, 0xEB2E, 0xE6C4, 0xE349, 0xE06F, 0xE02D, 0xE341,
    0xE670, 0xE69B, 0xE355, 0xDE12, 0xDA22, 0xD83F, 0xD8D3, 0xDC5B, 0xE350, 0xECB0, 0xF5AE, 0xFCCB, 0x0156, 0x02AB, 0x012C, 0xFF63,
    0xFF54, 0x0256, 0x064F, 0x06E4, 0x01BE, 0xF755, 0xEAB7, 0xDF13, 0xD5BA, 0xCE5B, 0xC8E7, 0xC4DD, 0xC36C, 0xC511, 0xC765, 0xC978,
    0xCE0B, 0xD692, 0xE017, 0xE8B2, 0xEF06, 0xF0C5, 0xED4A, 0xE80B, 0xE403, 0xE24F, 0xE4E8, 0xEC9A, 0xF7E6, 0x0424, 0x117A, 0x1F14,
    0x2A8E, 0x3340, 0x38AA, 0x3B88, 0x3EA6, 0x413B, 0x4109, 0x3E2A, 0x3943, 0x32F5, 0x2AE5, 0x2375, 0x1EB8, 0x1B1B, 0x1643, 0x1053,
    0x0A74, 0x0489, 0xFF22, 0xFCEE, 0xFEE1, 0x01C8, 0x02FD, 0x00EC, 0xFCC7, 0xF943, 0xF6A4, 0xF57B, 0xF714, 0xFCA5, 0x05DD, 0x0FDA,
    0x186C, 0x1EE0, 0x229C, 0x24F3, 0x25DF, 0x26B6, 0x2944, 0x2A13, 0x273B, 0x1FD9, 0x144F, 0x084C, 0xFEED, 0xF8AA, 0xF46C, 0xEFF3,
    0xEAB1, 0xE702, 0xE3F6, 0xDE6F, 0xD932, 0xD832, 0xD9C1, 0xDC47, 0xDF75, 0xE096, 0xDCF7, 0xD63B, 0xCF59, 0xC9D5, 0xC76F, 0xC995,
    0xCFD0, 0xD835, 0xE116, 0xEA5C, 0xF3AB, 0xFC21, 0x03E0, 0x0A39, 0x1187, 0x19D5, 0x2045, 0x21EC, 0x1EB5, 0x1883, 0x0E34, 0x0172,
    0xF6A2, 0xEFB5, 0xEB67, 0xE84B, 0xE6A7, 0xE6C0, 0xE74F, 0xE8D5, 0xEDF0, 0xF5F4, 0xFDC1, 0x0223, 0x027F, 0x006F, 0xFE18, 0xFD5A,
    0xFF1C, 0x05C4, 0x1015, 0x1B79, 0x258B, 0x2CCF, 0x315E, 0x3298, 0x326F, 0x327A, 0x35D4, 0x3C4D, 0x415E, 0x41D4, 0x3C93, 0x3218,
    0x2696, 0x1D97, 0x179D, 0x13B7, 0x0FD6, 0x0D3F, 0x0AEC, 0x0653, 0xFEF4, 0xF9FE, 0xFAFD, 0xFD3B, 0xFF6C, 0x0204, 0x0143, 0xFC4F,
    0xF4B9, 0xEBD6, 0xE4D8, 0xE2ED, 0xE5F3, 0xEBC8, 0xF1EE, 0xF762, 0xFBB2, 0xFEE1, 0x0067, 0xFFDA, 0xFEC9, 0xFFB8, 0x01A0, 0x0159,
    0xFD79, 0xF671, 0xED8A, 0xE0AF, 0xD3E1, 0xCADC, 0xC4D4, 0xC147, 0xBECD, 0xBDD5, 0xBDBD, 0xBF13, 0xC3D2, 0xCC50, 0xD700, 0xE0FE,
    0xE6B2, 0xE881, 0xE7C7, 0xE610, 0xE55C, 0xE671, 0xEB90, 0xF466, 0xFFF8, 0x0C8F, 0x194D, 0x24DF, 0x2D5B, 0x33C4, 0x3A08, 0x4230,
    0x4A31, 0x4E7E, 0x4D80, 0x471A, 0x3DE3, 0x3554, 0x2F27, 0x2A44, 0x23EC, 0x1C34, 0x1487, 0x0C76, 0x0423, 0xFCC1, 0xF909, 0xF8BA,
    0xF9E8, 0xFCFF, 0xFF08, 0xFC7C, 0xF5BF, 0xECB1, 0xE412, 0xDF34, 0xDF49, 0xE313, 0xE980, 0xF0BA, 0xF766, 0xFDFC, 0x040F, 0x0835,
    0x094E, 0x09BE, 0x0B78, 0x0D7C, 0x0D60, 0x0AF9, 0x0672, 0xFF16, 0xF5CC, 0xEE22, 0xE9D7, 0xE5E5, 0xE0C6, 0xDB95, 0xD63F, 0xD0EB,
    0xCCBE, 0xCB7F, 0xCEC2, 0xD470, 0xD8EB, 0xDABF, 0xD9D2, 0xD75C, 0xD4E9, 0xD447, 0xD693, 0xDC55, 0xE52F, 0xEF3F, 0xFAA8, 0x0721,
    0x1268, 0x1C2E, 0x2548, 0x2F07, 0x3AB0, 0x4607, 0x4CFD, 0x4DF6, 0x4915, 0x40CC, 0x37CF, 0x2FED, 0x27D8, 0x1EF1, 0x17D0, 0x12D3,
    0x0E6F, 0x0A4F, 0x088A, 0x097C, 0x0BC4, 0x0EE0, 0x12CE, 0x1441, 0x1138, 0x0B7C, 0x0402, 0xFEC4, 0xFCD4, 0xFE72, 0x033F, 0x08F8,
    0x0ECC, 0x1394, 0x1895, 0x1C95, 0x1D5D, 0x1CAC, 0x1DD5, 0x2084, 0x22F8, 0x2316, 0x20F7, 0x1C81, 0x143F, 0x0A27, 0x0116, 0xFABB,
    0xF60D, 0xF2DD, 0xF116, 0xEEDB, 0xEB80, 0xE7BB, 0xE5F2, 0xE65F, 0xE78F, 0xE6F3, 0xE438, 0xE096, 0xDBC6, 0xD7C1, 0xD6FD, 0xDA26,
    0xE0C2, 0xE87B, 0xEF25, 0xF5F4, 0xFD04, 0x024C, 0x0445, 0x0428, 0x04DA, 0x0811, 0x0BE8, 0x0CAC, 0x08BD, 0x0071, 0xF601, 0xEC75,
    0xE450, 0xDB5F, 0xD30F, 0xCDC7, 0xCA27, 0xC73C, 0xC644, 0xC8A9, 0xCE0F, 0xD58D, 0xDEE4, 0xE7F1, 0xEDED, 0xEF24, 0xEC1F, 0xE6F0,
    0xE259, 0xE0ED, 0xE3C0, 0xEA3A, 0xF2CF, 0xFC84, 0x07D7, 0x13E6, 0x1EDB, 0x2633, 0x2B2B, 0x3132, 0x36CB, 0x39FC, 0x3B28, 0x3A3D,
    0x36EE, 0x30E8, 0x29C1, 0x23F8, 0x1E78, 0x190D, 0x13E0, 0x0E64, 0x0793, 0xFF9C, 0xF913, 0xF6E0, 0xF9E5, 0xFEBD, 0x0184, 0x009B,
    0xFC76, 0xF578, 0xEF08, 0xEB91, 0xECB4, 0xF2BF, 0xFB20, 0x0520, 0x106E, 0x1A13, 0x1F8E, 0x2127, 0x212A, 0x227B, 0x25C2, 0x29E8,
    0x2B6F, 0x2827, 0x1FBC, 0x1550, 0x0D1A, 0x04BD, 0xFAE9, 0xF2AA, 0xEBF6, 0xE60C, 0xE0E6, 0xDD7E, 0xDAC5, 0xD861, 0xD8BE, 0xDBC4,
    0xDF05, 0xE041, 0xDD4D, 0xD784, 0xD0CE, 0xCA81, 0xC7A1, 0xC826, 0xCBD3, 0xD0A0, 0xD6A8, 0xDF32, 0xE97A, 0xF349, 0xFB43, 0x0492,
    0x0FAD, 0x1A2E, 0x2267, 0x27B5, 0x28E7, 0x245D, 0x1B96, 0x11C1, 0x0859, 0x0074, 0xFAD7, 0xF7B1, 0xF5F0, 0xF331, 0xF027, 0xEFA1,
    0xF260, 0xF805, 0xFD36, 0xFFC7, 0xFF45, 0xFC3F, 0xF8B5, 0xF679, 0xF7C9, 0xFD00, 0x057E, 0x0E83, 0x17C3, 0x2135, 0x27FF, 0x2AAC,
    0x2A6F, 0x2AD9, 0x2E63, 0x3420, 0x3A17, 0x3C51, 0x38BA, 0x30EA, 0x28B9, 0x20A7, 0x17C9, 0x0EAE, 0x07FC, 0x03C3, 0xFFE3, 0xFCD0,
    0xF9C0, 0xF70F, 0xF5D3, 0xF680, 0xF7F5, 0xF8A3, 0xF725, 0xF2C7, 0xEC70, 0xE62B, 0xE224, 0xE133, 0xE423, 0xE7DE, 0xEB1C, 0xF002,
    0xF60B, 0xFBE4, 0xFE68, 0xFE87, 0x00CA, 0x04DB, 0x07E1, 0x08A4, 0x0656, 0x00AA, 0xF770, 0xEC75, 0xE182, 0xD76A, 0xCFE9, 0xC96E,
    0xC469, 0xC0B6, 0xBCB7, 0xBA96, 0xBC60, 0xC2C1, 0xCC2E, 0xD577, 0xDC78, 0xDF0F, 0xDE01, 0xDB05, 0xD90F, 0xDBE1, 0xE2C5, 0xEC0A,
    0xF764, 0x0434, 0x11CD, 0x1D96, 0x25CE, 0x2C16, 0x331D, 0x3C33, 0x46A3, 0x4FC2, 0x53AE, 0x51F1, 0x4D5E, 0x4800, 0x4106, 0x3871,
    0x3045, 0x2927, 0x21B5, 0x19A2, 0x113A, 0x0921, 0x0229, 0xFE0F, 0xFD7F, 0xFEC4, 0xFF55, 0xFC3A, 0xF529, 0xEBD8, 0xE281, 0xDB51,
    0xD8FF, 0xDB6E, 0xDFB8, 0xE5E8, 0xEEA1, 0xF7C9, 0xFE35, 0x00A8, 0x01C7, 0x0381, 0x050E, 0x0623, 0x0732, 0x0726, 0x0438, 0xFEF7,
    0xF8A3, 0xF17C, 0xEAE6, 0xE514, 0xE015, 0xDC47, 0xD7EB, 0xD252, 0xCD59, 0xCBAE, 0xCE0D, 0xD2AB, 0xD671, 0xD709, 0xD442, 0xCF94,
    0xCB32, 0xC9E4, 0xCC33, 0xD0CF, 0xD613, 0xDCD7, 0xE5EB, 0xF0BF, 0xFB9A, 0x04B4, 0x0E85, 0x1A6C, 0x27E2, 0x3643, 0x4106, 0x441B,
    0x41C8, 0x3CA4, 0x35EC, 0x2E10, 0x2661, 0x2101, 0x1D32, 0x1A08, 0x1762, 0x14C6, 0x127B, 0x10D4, 0x1148, 0x1434, 0x17C9, 0x19F9,
    0x1988, 0x15E5, 0x1061, 0x0B05, 0x0815, 0x09D2, 0x0D92, 0x11A1, 0x1601, 0x1B9F, 0x20B9, 0x22BB, 0x233A, 0x23EE, 0x255C, 0x26E1,
    0x2727, 0x2652, 0x22A1, 0x1BDA, 0x1362, 0x09A8, 0x00AC, 0xF9D5, 0xF55C, 0xF339, 0xF110, 0xED0D, 0xE759, 0xE2B3, 0xE1AF, 0xE307,
    0xE53C, 0xE5B7, 0xE3A4, 0xDF5C, 0xD959, 0xD47D, 0xD380, 0xD6F0, 0xDCAE, 0xE2CC, 0xE9ED, 0xF1D9, 0xF8BE, 0xFD0C, 0xFF4A, 0x0107,
    0x048B, 0x0ADC, 0x11DE, 0x1488, 0x0FE5, 0x07B4, 0xFEBF, 0xF3EA, 0xE736, 0xDBB6, 0xD294, 0xCBE8, 0xC6D0, 0xC313, 0xC07E, 0xBF55,
    0xC115, 0xC6F5, 0xD012, 0xD9E2, 0xE1B8, 0xE5A0, 0xE4F3, 0xE096, 0xDB47, 0xD8DF, 0xDABC, 0xDF2F, 0xE575, 0xEF9F, 0xFD5C, 0x0A54,
    0x140D, 0x1C04, 0x23E1, 0x2B78, 0x3290, 0x3860, 0x3D22, 0x3F82, 0x3ED5, 0x3BCA, 0x371E, 0x3147, 0x2B1C, 0x25B4, 0x2168, 0x1D19,
    0x1696, 0x0F64, 0x0A65, 0x0913, 0x0A68, 0x0C3E, 0x0C77, 0x0A8E, 0x059F, 0xFE8F, 0xF889, 0xF63E, 0xF805, 0xFBC7, 0x0191, 0x09CF,
    0x12FA, 0x1B61, 0x217A, 0x2531, 0x26E1, 0x281A, 0x2B14, 0x2D74, 0x2BC2, 0x26DD, 0x20C7, 0x19D0, 0x1098, 0x0619, 0xFCA0, 0xF388,
    0xEB20, 0xE395, 0xDC98, 0xD696, 0xD1CE, 0xCF7E, 0xCFF6, 0xD30C, 0xD626, 0xD72A, 0xD5C6, 0xD213, 0xCCE9, 0xC857, 0xC658, 0xC66F,
    0xC813, 0xCB78, 0xD26A, 0xDACA, 0xE265, 0xE982, 0xF15B, 0xFAC4, 0x0496, 0x0DD9, 0x15B0, 0x1B09, 0x1C93, 0x1A09, 0x1419, 0x0C8D,
    0x04A0, 0xFD94, 0xF920, 0xF739, 0xF523, 0xF14E, 0xEC79, 0xE9A6, 0xEACD, 0xEF26, 0xF3F0, 0xF8BC, 0xFBF0, 0xFCEE, 0xFCE6, 0xFDFB,
    0x0243, 0x08B1, 0x0FB9, 0x17E3, 0x225B, 0x2C88, 0x355D, 0x3C12, 0x403E, 0x42B7, 0x4617, 0x4B0E, 0x4DD1, 0x4C25, 0x46EA, 0x3F85,
    0x3614, 0x2B0B, 0x1FE9, 0x16A1, 0x0F4A, 0x0988, 0x04AF, 0xFFA3, 0xF9FC, 0xF4C7, 0xF19A, 0xF12A, 0xF292, 0xF3E9, 0xF415, 0xF2F2,
    0xEECC, 0xE839, 0xE30B, 0xE13B, 0xE21B, 0xE473, 0xE9AA, 0xF19D, 0xF986, 0xFE9B, 0x0130, 0x02D9, 0x041B, 0x0590, 0x079D, 0x08ED,
    0x088E, 0x04A0, 0xFC1E, 0xF0AD, 0xE283, 0xD489, 0xC9A6, 0xC36B, 0xBF79, 0xBB03, 0xB6EF, 0xB478, 0xB5A6, 0xBA4F, 0xC0EB, 0xC8A0,
    0xCF6D, 0xD3AF, 0xD47C, 0xD2DB, 0xD236, 0xD406, 0xD7D5, 0xDED3, 0xE983, 0xF68A, 0x04FD, 0x1308, 0x1EB0, 0x266F, 0x2D36, 0x3631,
    0x3F56, 0x460D, 0x492A, 0x49EE, 0x491E, 0x449F, 0x3CE0, 0x3574, 0x2E6B, 0x2869, 0x2268, 0x1CDF, 0x1694, 0x10A4, 0x0CAA, 0x0B5B,
    0x0D45, 0x0D5A, 0x0CE9, 0x0B2F, 0x062F, 0xFD4E, 0xF3B2, 0xED74, 0xEB39, 0xEC03, 0xEF3A, 0xF62E, 0xFE5B, 0x0615, 0x0CBE, 0x10DF,
    0x1348, 0x1445, 0x1430, 0x1442, 0x1405, 0x1217, 0x0DB6, 0x0627, 0xFCA5, 0xF341, 0xEAAD, 0xE4C4, 0xE069, 0xDB9A, 0xD564, 0xCE65,
    0xC87F, 0xC65E, 0xC70D, 0xCAD2, 0xD107, 0xD5A9, 0xD7D5, 0xD38E, 0xCD4E, 0xC8DC, 0xC729, 0xC7A0, 0xCA4C, 0xD070, 0xD7FC, 0xE1D5,
    0xEB93, 0xF577, 0xFF5E, 0x0AD6, 0x1A3F, 0x28FA, 0x3460, 0x3B7A, 0x3DB6, 0x3B58, 0x3536, 0x2C87, 0x24F9, 0x1F3A, 0x1A43, 0x165D,
    0x126F, 0x0E1C, 0x099F, 0x06B0, 0x06AD, 0x09C0, 0x0D87, 0x1206, 0x1514, 0x1443, 0x10EB, 0x0D25, 0x0D27, 0x0D46, 0x0CEF, 0x0EDE,
    0x1389, 0x1AB4, 0x2140, 0x26E1, 0x2AE4, 0x2EEB, 0x3267, 0x3555, 0x3742, 0x35BE, 0x323F, 0x2CBA, 0x2582, 0x1D28, 0x1463, 0x0CE5,
    0x0968, 0x0783, 0x0517, 0x0027, 0xF8F7, 0xF2E5, 0xEEE3, 0xEDB0, 0xEE6E, 0xF05D, 0xF0A2, 0xED0D, 0xE552, 0xDEAB, 0xDA70, 0xD993,
    0xDC5A, 0xE0E9, 0xE908, 0xF1A6, 0xFA80, 0x00E6, 0x042C, 0x0654, 0x099E, 0x0EED, 0x1289, 0x149F, 0x13AF, 0x1000, 0x0987, 0xFE36,
    0xF0EF, 0xE342, 0xD7BD, 0xCE87, 0xC658, 0xBFFA, 0xBAFB, 0xB8C3, 0xBA4C, 0xBE92, 0xC43B, 0xC95F, 0xCE67, 0xD1E2, 0xD0EA, 0xCDC7,
    0xCA49, 0xCA3C, 0xCB7A, 0xCF1C, 0xD64E, 0xDF6D, 0xEB5C, 0xF5E3, 0x00A5, 0x0C07, 0x156E, 0x1CC0, 0x2306, 0x28A4, 0x2D66, 0x3091,
    0x3249, 0x323C, 0x2F8B, 0x2BC6, 0x292C, 0x277C, 0x2513, 0x20BE, 0x1A90, 0x1502, 0x11C9, 0x10ED, 0x123F, 0x1520, 0x176D, 0x1675,
    0x112A, 0x08BC, 0x00E3, 0xFC5B, 0xFC07, 0x00EA, 0x07CC, 0x1175, 0x1C27, 0x260F, 0x2D75, 0x304B, 0x3314, 0x35E3, 0x3959, 0x3CE6,
    0x3E2D, 0x3C02, 0x3671, 0x2DF8, 0x237E, 0x1807, 0x0D07, 0x03A3, 0xFA79, 0xF1CD, 0xE9FA, 0xE298, 0xDBB7, 0xD6FD, 0xD5CA, 0xD775,
    0xDB71, 0xDF73, 0xE067, 0xDCEF, 0xD636, 0xCF9B, 0xCAD3, 0xC6C8, 0xC51E, 0xC669, 0xCA14, 0xD040, 0xD64A, 0xDD8F, 0xE4C8, 0xEBBA,
    0xF318, 0xFA26, 0x020F, 0x0768, 0x0998, 0x0967, 0x06E1, 0x020D, 0xFB30, 0xF61C, 0xF335, 0xF162, 0xEE2E, 0xEA12, 0xE73D, 0xE5CD,
    0xE688, 0xEA4D, 0xEFE5, 0xF54D, 0xF879, 0xF8C2, 0xF877, 0xF860, 0xF9BB, 0xFDFE, 0x04DA, 0x0D1E, 0x1795, 0x2434, 0x3041, 0x38CE,
    0x3E78, 0x43D1, 0x47E6, 0x4B40, 0x4BC7, 0x49EC, 0x4666, 0x3F6F, 0x3784, 0x2DF3, 0x238F, 0x1B30, 0x1540, 0x123C, 0x0ECF, 0x0AB6,
    0x04FB, 0x0009, 0xFE3B, 0xFD33, 0xFEEE, 0x01FC, 0x0439, 0x0478, 0x00DD, 0xFC6B, 0xF8D2, 0xF62D, 0xF677, 0xF884, 0xFD36, 0x03C5,
    0x0A9A, 0x10C6, 0x1510, 0x16F7, 0x16EF, 0x1677, 0x15C6, 0x14DC, 0x1153, 0x0C91, 0x05D4, 0xFBC1, 0xEF1C, 0xE0EB, 0xD424, 0xCA71,
    0xC21B, 0xBA1C, 0xB448, 0xB293, 0xB38E, 0xB664, 0xBB8E, 0xC22E, 0xC8EF, 0xCB7B, 0xCA90, 0xC821, 0xC595, 0xC6AD, 0xCBB1, 0xD3B7,
    0xDC93, 0xE64B, 0xF2F1, 0xFF3E, 0x09E8, 0x12E4, 0x1B75, 0x2517, 0x2F04, 0x383D, 0x3FD6, 0x444B, 0x4513, 0x42C1, 0x3D50, 0x368B,
    0x2FE9, 0x29AB, 0x2530, 0x202B, 0x1A64, 0x14B4, 0x10D6, 0x0DE6, 0x0CDC, 0x0EF5, 0x1204, 0x1344, 0x0EB2, 0x0689, 0xFDC5, 0xF623,
    0xF02E, 0xEEAB, 0xEFD3, 0xF5F7, 0xFD46, 0x0624, 0x0CDA, 0x1071, 0x11E2, 0x12CB, 0x1424, 0x15DE, 0x1800, 0x1819, 0x15E2, 0x0B09,
    0x13A7, 0x080C, 0xFD0A, 0xEEF3, 0xEFD1, 0xF34A, 0xD6B4, 0xDEF6, 0xCFB0, 0xD523, 0xCA90, 0xCBCD, 0xDE28, 0xDAC3, 0xDED2, 0xDD48,
    0xD3B2, 0xD30D, 0xD9A4, 0xC412, 0xD425, 0xC900, 0xD346, 0xDBE7, 0xD46C, 0xEE7E, 0xF672, 0xF9CB, 0x1106, 0x1B42, 0x083F, 0x1E2D,
    0x2477, 0x1D94, 0x3985, 0x0689, 0x0EA3, 0x285E, 0xFB6D, 0x1DFA, 0xFD50, 0x0896, 0x0E85, 0xEEF8, 0x0AD7, 0xEF82, 0x04D4, 0x0859,
    0xED6B, 0x1405, 0x2AA3, 0xF66C, 0xF210, 0x15DA, 0x0098, 0x11C2, 0xF9C2, 0x1986, 0x2B2A, 0x1E8B, 0x32AE, 0x26E3, 0x393C, 0x194A,
    0x2E1F, 0x483E, 0x3E5D, 0x1C30, 0x2659, 0x1D8D, 0x24FA, 0x27F4, 0x1164, 0x27C2, 0xF1DE, 0xBB13, 0xA34C, 0xBE44, 0xCCBD, 0xC268,
    0xBFD9, 0xE495, 0xF4BF, 0x1FB1, 0x3C0C, 0x32BE, 0x0EB6, 0xAA12, 0x940E, 0x8126, 0x942A, 0xBBBA, 0xCC7F, 0x0AED, 0x4998, 0x711D,
    0x7D4B, 0x70EB, 0x4359, 0x1CC2, 0x2502, 0x5505, 0x6DA0, 0x775E, 0x7E10, 0x6749, 0x6402, 0x62CE, 0x6AE7, 0x644C, 0x4FB0, 0x2CDB,
    0xF7F6, 0xFB06, 0x06C2, 0x136B, 0x08CC, 0xCB7D, 0xAA7C, 0x9B5E, 0x9474, 0x892F, 0x9BD3, 0x9602, 0x8F66, 0x9259, 0x9171, 0xA768,
    0xA1A0, 0xC4BE, 0xC9F8, 0xBFD8, 0xC0E9, 0xEFEF, 0xF875, 0x09FD, 0x0BD0, 0x0BB4, 0x1E84, 0xD176, 0xED66, 0x0037, 0x36F1, 0x50E5,
    0x2B96, 0x3FBF, 0x41F2, 0x1893, 0x0027, 0xDF6E, 0xAB8F, 0xB91C, 0xC808, 0xCCD0, 0xDCAE, 0x07A5, 0xF4FC, 0xE688, 0xEE81, 0xD134,
    0xBC3D, 0xCAD2, 0xDB03, 0xDDD3, 0xFA08, 0x0CEB, 0x0644, 0x1398, 0x1D62, 0x319E, 0x4032, 0x4F05, 0x52BD, 0x591B, 0x603F, 0x5C5B,
    0x74DB, 0x5B4A, 0x614C, 0x4CD9, 0x44B9, 0x283E, 0x0DDB, 0xF516, 0xD907, 0xF57F, 0xE60E, 0xD439, 0xB846, 0xD51F, 0xDF34, 0xD8F8,
    0xD84E, 0xCBB3, 0xCEA7, 0xD348, 0x0FC0, 0xF8B3, 0xFD1F, 0x173D, 0x0263, 0x3179, 0x4175, 0x3435, 0x253E, 0x3844, 0x2B9D, 0x304E,
    0x1C49, 0xF1DA, 0xEFBA, 0xF668, 0xFCC4, 0x06C8, 0xFB55, 0xFBA8, 0x1758, 0xF9D5, 0xEF11, 0xF181, 0xD433, 0xE113, 0xE4C6, 0xD7A2,
    0x07D4, 0x10D9, 0x13E5, 0x0410, 0x18AE, 0x0D80, 0x13E3, 0xF8E7, 0x03E8, 0x128A, 0x12C0, 0x3E0B, 0x2CF2, 0x396A, 0x223B, 0x23A1,
    0x1B1D, 0x2C98, 0x2FE5, 0x2D93, 0xFCCF, 0x0445, 0xE8B3, 0xD31B, 0xE427, 0xB5E6, 0xB231, 0xB69A, 0xC735, 0xC7E9, 0xD07D, 0xDE86,
    0xD6C0, 0xC7E0, 0xCBD5, 0xBB2C, 0xD1F3, 0xE5B2, 0x0C13, 0x1922, 0x2ECB, 0x455E, 0x5FC4, 0x4CD2, 0x411A, 0x4CC6, 0x246E, 0x0826,
    0xDE5F, 0xDD4C, 0xE86D, 0xEAF1, 0xD123, 0xD512, 0xCEC8, 0xCB0E, 0xA97E, 0xC2B6, 0xBB95, 0xB100, 0xD5D1, 0x94D8, 0xB8D8, 0xDFD1,
    0xC347, 0xC9AD, 0xCE35, 0xB948, 0xAFAC, 0xCA34, 0xB550, 0xBAA8, 0xD347, 0xC813, 0xEBF1, 0x0890, 0x00F7, 0x1ADF, 0x30F6, 0x02AA,
    0x175A, 0x1933, 0x1090, 0x03EC, 0x1AB1, 0x1CB8, 0xF9E0, 0x2406, 0x2E76, 0x3E4E, 0x606A, 0x47C3, 0x4CE9, 0x57DC, 0x2600, 0x1EFF,
    0xF7DC, 0x0198, 0x0332, 0xF5E4, 0x1024, 0x2D0C, 0x0551, 0x14F2, 0x19E7, 0x0B2D, 0x1F54, 0x0199, 0x20BD, 0x0E63, 0x0CF1, 0x3377,
    0x42DD, 0x1340, 0x1F94, 0x2D78, 0x2072, 0x0C59, 0xFD03, 0x20D1, 0x0C3F, 0x24E1, 0x407A, 0x22B5, 0x3E08, 0x445C, 0x385E, 0x2937,
    0x1C1F, 0x32BC, 0x1383, 0x159B, 0xFD4F, 0xE995, 0xF90D, 0xD80C, 0xE3A9, 0xE81F, 0xD46A, 0xDAA6, 0xC8D4, 0xCF17, 0xB636, 0xAC95,
    0xD833, 0xD3F2, 0xDCE1, 0x0DD0, 0x286B, 0x45AD, 0x5324, 0x50D9, 0x5B95, 0x596F, 0x5341, 0x487F, 0x1DB3, 0xFF73, 0x2688, 0xF9F5,
    0xEA68, 0xFA6B, 0xF7F5, 0xDB6E, 0xDC73, 0xEAA1, 0xDA07, 0xF290, 0xE8EB, 0x00D8, 0xC83A, 0xB4B8, 0xF137, 0xE54B, 0xD4C4, 0xCEB0,
    0x0425, 0x079F, 0xFE92, 0x1AC5, 0x2744, 0x266A, 0x0365, 0x0EBE, 0x0257, 0x1687, 0xF05A, 0xF670, 0xF933, 0xD5D9, 0xF12A, 0xD32F,
    0xE38F, 0xDC90, 0x09FD, 0x02FF, 0xFCEC, 0x065C, 0x1126, 0x0CDB, 0xE8D3, 0x0325, 0x0735, 0x081E, 0xDE4D, 0xD175, 0xD55E, 0xDC40,
    0xD8AC, 0xF4E2, 0xF62B, 0x0038, 0x1056, 0x041C, 0xFFBB, 0xFA73, 0xFF9D, 0x1955, 0x1C38, 0x1BC9, 0x20FF, 0x0388, 0x207B, 0x170D,
    0x2519, 0xF9FC, 0xF187, 0xF81F, 0xF100, 0xF3AC, 0xF562, 0xD038, 0xC8E0, 0xD338, 0xC7AB, 0xDFF9, 0xC302, 0xE362, 0xB4F9, 0xD6DD,
    0xD829, 0xBE99, 0xC713, 0xC7D5, 0xD7DE, 0xC2D3, 0xE920, 0x005A, 0xEEE5, 0xF238, 0x0BF2, 0x207D, 0x2645, 0x2ED5, 0x14E4, 0xE6E7,
    0x0B69, 0xFA1A, 0x0FF5, 0x1796, 0x0BC3, 0x1AEB, 0x0175, 0x0D10, 0x0293, 0x15D5, 0x139F, 0xE592, 0xF4C3, 0x1CB1, 0x09DE, 0x0DE3,
    0x1C4D, 0x04EF, 0x1464, 0x0925, 0x14E7, 0xFC10, 0x0274, 0x190A, 0xF5B9, 0x1334, 0x2057, 0x052C, 0x1108, 0x1B4F, 0x1B04, 0x1AE0,
    0x0CD3, 0x0EAF, 0x005A, 0x19F2, 0xF05D, 0xE4CC, 0xE969, 0xD849, 0xCD69, 0xDC63, 0xE5E0, 0xD3BB, 0xDC74, 0xCE37, 0xDFDA, 0xD490,
    0xD1E6, 0xC8F9, 0xDE99, 0xF324, 0x106C, 0x1F35, 0x014C, 0xF782, 0x04A5, 0xE785, 0xEC51, 0x0450, 0xF406, 0x0AE0, 0x0F05, 0x0CAC,
    0x1396, 0x08C2, 0x32C3, 0x295D, 0x0A21, 0x2189, 0x19E5, 0x28EB, 0x0C85, 0x0DCB, 0x0B70, 0x0F71, 0xEC0C, 0xE7BD, 0xE3D2, 0xEAF1,
    0xF822, 0xD9C3, 0xE0CB, 0x0576, 0xEC87, 0xEA4B, 0x234A, 0xF657, 0xF946, 0xE147, 0x0DE6, 0xF9EA, 0xFFD2, 0x10F3, 0x03E5, 0x2CB9,
    0x2397, 0x3626, 0x57B1, 0x5B5F, 0x22F1, 0x1436, 0x1E4D, 0x2C16, 0x3001, 0x3F37, 0x20BF, 0x0FE5, 0x2430, 0x119D, 0x116A, 0x350D,
    0x42FD, 0x2855, 0x060B, 0x1B4B, 0x0F88, 0x005A, 0xFA23, 0xFEAC, 0x1954, 0x0675, 0x1843, 0xFB03, 0xDDA6, 0xE7AB, 0x05E6, 0xFDA9,
    0x09AB, 0x0F7E, 0x0CF4, 0x04A6, 0x0ACA, 0x28EC, 0x0EC3, 0x078C, 0x0680, 0x0D7F, 0xFDF9, 0x1245, 0x067D, 0xE0D5, 0xDF97, 0xF84B,
    0xD69A, 0xB2B0, 0xB9A1, 0xC7FE, 0xBDB7, 0xB270, 0xC66C, 0xC22F, 0xBFDB, 0xC404, 0xB738, 0xA3C0, 0xC74A, 0xC4CE, 0xBEC8, 0xD522,
    0xE20A, 0xDFAB, 0xEFA4, 0xF8E9, 0x01AF, 0x0FAA, 0x2A4E, 0x208C, 0x1296, 0x2512, 0x20AB, 0x1217, 0x21B7, 0x472D, 0x2482, 0x19AE,
    0x20D7, 0x01B4, 0xF21E, 0xF1F0, 0xF0E6, 0xFFD2, 0xFF30, 0xFEF3, 0xFD06, 0xE83E, 0xEF87, 0x0542, 0xF55B, 0xF9EA, 0xF3F4, 0xFE02,
    0x06FB, 0xE562, 0xE475, 0xF4CD, 0xF003, 0xF5B9, 0xFCBA, 0xFE52, 0x205A, 0x1749, 0x19DC, 0x0A07, 0xFB4D, 0xF562, 0xF3E9, 0xFFC5,
    0xF814, 0x019F, 0x0EF7, 0xFF2A, 0xEFF5, 0xE1BA, 0xE84D, 0xE7DF, 0xC7A7, 0xE1FF, 0xF5A5, 0xE1A5, 0xCA53, 0xD0EB, 0xEA9E, 0xE521,
    0xC87F, 0xDA36, 0xCB4F, 0xCF74, 0xD964, 0xDC9D, 0xEBF7, 0xE1CC, 0xE848, 0xE343, 0xF26A, 0xEBE6, 0xFF05, 0x0107, 0x0501, 0x209A,
    0x0B6B, 0x107A, 0x0995, 0x0D5A, 0x1B10, 0xF82B, 0xF604, 0xF037, 0xF9F4, 0xE73F, 0xD50A, 0xE121, 0xE673, 0xEAA3, 0xCBFF, 0xF277,
    0x0CA3, 0x01FD, 0xF765, 0x0F09, 0x0FE9, 0x0898, 0x1614, 0x10E3, 0x20E0, 0xFF55, 0x0622, 0x1E45, 0x1816, 0x23F4, 0x28A8, 0x2318,
    0x2E94, 0x4049, 0x47D3, 0x35B5, 0x08BF, 0x1E63, 0x31DF, 0x226E, 0x0DDA, 0x08EC, 0x054A, 0xF978, 0xF2D1, 0xEA9B, 0xF43C, 0xE56E,
    0xF13B, 0xEC1C, 0xECF0, 0xF3FD, 0xEDDF, 0xF897, 0x001D, 0xFD5F, 0xF5F1, 0xF720, 0xF70D, 0x0D64, 0x0931, 0x0A3D, 0xFA85, 0xFA13,
    0xFEF5, 0xFC8B, 0x0F9C, 0xFE6C, 0x0B4E, 0x1865, 0x1B06, 0x2B82, 0x236E, 0x1835, 0x0F12, 0x06AA, 0xE26D, 0xEB4C, 0x0BF9, 0xEC19,
    0xD461, 0xD437, 0xD7BC, 0xD739, 0xDCE1, 0xDEA8, 0xE835, 0xEED1, 0xF366, 0xE3C9, 0xD8E4, 0xE605, 0xDEA6, 0xCB74, 0xC885, 0xE6AD,
    0xF3D1, 0xE4EC, 0xE981, 0xF596, 0x079D, 0x0F58, 0xF795, 0xE359, 0xDF6C, 0xFC52, 0x0854, 0xF7C4, 0xF9CC, 0xF4E3, 0x0386, 0x0A78,
    0x10B1, 0x082E, 0xEBF9, 0x0AAC, 0x1C4C, 0x141C, 0x188A, 0x1ADF, 0x1092, 0x1FA4, 0x127D, 0x13FA, 0x14E4, 0x05FA, 0xF683, 0xF586,
    0x0BE5, 0x162E, 0x1106, 0x0F45, 0x178E, 0x1A86, 0x23CF, 0x1197, 0x2916, 0x2651, 0x0DD0, 0x0583, 0x2ACF, 0x2B7C, 0x28E3, 0x3460,
    0x14CD, 0xFF53, 0x0362, 0x08DE, 0x0161, 0xF870, 0xF48E, 0xF9AB, 0xDC59, 0xE3C0, 0xEFB4, 0x14E7, 0x1688, 0x0462, 0xF77A, 0xF1A9,
    0xF210, 0xE731, 0xD416, 0xE19B, 0xF6DE, 0xE8DB, 0xFB7F, 0xE91F, 0xFDD3, 0x1106, 0x0F71, 0x1157, 0x0CB1, 0x0F11, 0x0AA6, 0x0C61,
    0x122F, 0x1EE5, 0x1BC1, 0x10CE, 0x1344, 0x19FE, 0x0A09, 0x00F2, 0xFD21, 0x0494, 0x0070, 0x01AE, 0x0CB2, 0x0412, 0x061E, 0xF362,
    0xE6E7, 0xD988, 0xDC46, 0xE1B7, 0xF1F5, 0x0A60, 0x0383, 0x0EAB, 0x0DFE, 0x1537, 0x15EE, 0x1CE4, 0x362B, 0x3FD3, 0x3F41, 0x3B28,
    0x3FB8, 0x3D4B, 0x3D8A, 0x3652, 0x2F9B, 0x27B9, 0x2CC1, 0x27AA, 0x04D9, 0x1052, 0x1608, 0xFFC6, 0xF692, 0xE8E0, 0xF84D, 0x0438,
    0xE8EB, 0xE2D3, 0xE5C7, 0xE9EF, 0xE440, 0xDCD7, 0xD9D1, 0xD25A, 0xDCC4, 0xE075, 0xCFDF, 0xD079, 0xEC35, 0xEC29, 0xF81C, 0x0879,
    0x0C4D, 0x11C6, 0x1D36, 0x1BCA, 0x04F5, 0xFF14, 0xF91E, 0xF17D, 0xE5FB, 0xE8C2, 0xEFA3, 0xDF96, 0xC4BA, 0xB1BB, 0xA54E, 0xB8AF,
    0xC947, 0xC60F, 0xC09C, 0xB9E9, 0xBE12, 0xC995, 0xC088, 0xB983, 0xD302, 0xEBC7, 0x0193, 0xFC0F, 0x0362, 0xFCE0, 0x0062, 0x1249,
    0x08BB, 0x19EF, 0x304D, 0x3E1F, 0x40A3, 0x3414, 0x284D, 0x238D, 0x281C, 0x2A2A, 0x21EB, 0x1A56, 0x072F, 0x1062, 0x12B8, 0x0EDF,
    0x25BA, 0x24C9, 0x2F15, 0x2B49, 0x1A58, 0x2F9F, 0x1927, 0x00E1, 0x0C12, 0x11E2, 0x187C, 0x01A3, 0xF592, 0x0746, 0x1E30, 0x19D2,
    0x2182, 0x1567, 0x0D4D, 0x21B8, 0x224F, 0x2B7B, 0x2CB9, 0x2C22, 0x28C0, 0x218A, 0x1D3E, 0x16B9, 0xF524, 0xEED3, 0xED84, 0xE7A5,
    0xDCE7, 0xD26D, 0xD110, 0xD087, 0xD56D, 0xC9CA, 0xD05D, 0xDCEC, 0xDD78, 0xC500, 0xCC45, 0xE161, 0xE01C, 0xE263, 0xE499, 0xD3BB,
    0xD705, 0xDAEC, 0xD192, 0xDC4B, 0xDD35, 0xE0C3, 0xF097, 0xF7CE, 0xFF74, 0x0380, 0x0107, 0x104E, 0x1104, 0x1943, 0x0E56, 0xEEC1,
    0xEDA9, 0xFF0E, 0xEB76, 0xD72F, 0xDF3D, 0xDE51, 0xE7F3, 0xF46E, 0xFFC4, 0xF9EC, 0xF0DF, 0xEAB2, 0xE5B9, 0xE785, 0xF788, 0xDBC4,
    0xD1E2, 0xE9E0, 0xE7C8, 0x0061, 0x11DB, 0x1D36, 0x17C5, 0x1B0C, 0x2C51, 0x25E7, 0x1C42, 0x38E7, 0x4175, 0x3996, 0x2E6E, 0x2A45,
    0x3A56, 0x2215, 0x18B7, 0x0123, 0xEC19, 0xEBD6, 0xF418, 0xFCC5, 0x0160, 0x103C, 0x0531, 0xF5F2, 0x03EB, 0x07D2, 0xFA8F, 0xFDFD,
    0x03F6, 0x0670, 0x0464, 0x0115, 0x02F6, 0x0450, 0x06AC, 0x14C7, 0x1646, 0x15AE, 0x1972, 0x1E31, 0x34C1, 0x4116, 0x3AC2, 0x3A6A,
    0x35F1, 0x14FB, 0x1658, 0x23A2, 0x1E68, 0x2378, 0x0729, 0xF8F7, 0xDE32, 0xD10E, 0xD6F3, 0xBE22, 0xC016, 0xC565, 0xCCC6, 0xD1DE,
    0xCA40, 0xBDB2, 0xBB4E, 0xC601, 0xE3D6, 0xDDA2, 0xD5CD, 0xDD45, 0xD78C, 0xF864, 0x0857, 0x050A, 0x0849, 0xF90D, 0xFF38, 0xFAF1,
    0xF383, 0xF6B8, 0xF54F, 0xFF7B, 0xF636, 0x00BD, 0xFFC9, 0xFD7D, 0xE861, 0xF4F1, 0xF33B, 0xF4EE, 0xF102, 0xDD3F, 0xF22D, 0xFB64,
    0x052B, 0xE9AE, 0xFAE7, 0x013E, 0xFC1A, 0xF247, 0xF847, 0xF411, 0xEDED, 0x0076, 0x0628, 0x12B3, 0x23AF, 0x331C, 0x38AD, 0x2769,
    0x128F, 0x15E5, 0x2310, 0x42D5, 0x42ED, 0x3800, 0x2200, 0x0FE7, 0x1426, 0x0C43, 0xF8DE, 0xFD40, 0xF6D1, 0xF18D, 0xE419, 0xD322,
    0xCC8B, 0xD10C, 0xD0CB, 0xC870, 0xD074, 0xD508, 0xC5E2, 0xBE7F, 0xD279, 0xD05C, 0xD9CD, 0xE372, 0xE2B2, 0xCA0D, 0xD30A, 0xDC2E,
    0xDF8D, 0xE1CC, 0xECD5, 0xFB38, 0xFB39, 0xF4C8, 0xEC09, 0x0CB3, 0xFEC5, 0xF90D, 0xF8A9, 0xF3E4, 0xFDAD, 0xEDCE, 0xDFD6, 0xD702,
    0xD741, 0xE81F, 0xE6F7, 0xEA6E, 0xF068, 0xF56E, 0xF9ED, 0xF935, 0x0548, 0x0E1B, 0x02ED, 0xFF05, 0xFB6D, 0xF422, 0x0AFB, 0x19A1,
    0x22BF, 0x20A9, 0x3449, 0x3433, 0x37DC, 0x4A27, 0x54D3, 0x5BEB, 0x4876, 0x463B, 0x4434, 0x42CB, 0x41B2, 0x3819, 0x24D5, 0x224C,
    0x217B, 0x1258, 0xFF2E, 0xFB70, 0xFEFA, 0x1589, 0x085F, 0xF65F, 0x0589, 0x0D8E, 0x0F57, 0xF1F0, 0xF0B6, 0xF56C, 0xFE64, 0xF6CE,
    0xF43D, 0xF4D9, 0xFD72, 0x0B91, 0xF2AE, 0xF364, 0xFDA1, 0x1224, 0x1AAE, 0x17DE, 0x27BA, 0x2AB2, 0x1EF0, 0x1303, 0xFF13, 0xEFDA,
    0xE6A0, 0xE726, 0xD6D8, 0xCC2D, 0xC955, 0xBED8, 0xC253, 0xB537, 0xB9AC, 0xB76B, 0xC3F6, 0xD050, 0xC872, 0xC536, 0xC50E, 0xC150,
    0xBE0D, 0xCED4, 0xD51E, 0xDAA0, 0xDE79, 0xE83F, 0xF32D, 0x0A78, 0x196D, 0x13B6, 0x15CD, 0x13BD, 0x1218, 0x1BAD, 0x2658, 0x1BE1,
    0x11D9, 0x11D0, 0x0A28, 0x11E6, 0x107F, 0x016D, 0xF8A0, 0xF172, 0x1117, 0x1E0B, 0x1477, 0x1B74, 0x1F17, 0x261B, 0x26B2, 0x2525,
    0x09A7, 0x02A6, 0x02F5, 0x08FA, 0x1240, 0x0D9D, 0x1DDD, 0x22F5, 0x2A76, 0x28EA, 0x310A, 0x32DA, 0x2CAC, 0x29CB, 0x2708, 0x24C4,
    0x2483, 0x222A, 0x12EE, 0x1713, 0x1A39, 0x1050, 0x0648, 0x0223, 0xFBD4, 0xEB06, 0xE5D1, 0xDF2B, 0xDDC9, 0xDC72, 0xE26D, 0xFAEA,
    0xF3B5, 0xF228, 0xF551, 0xE8B6, 0xE58D, 0xEC39, 0xF053, 0xE935, 0xE425, 0xE6A5, 0xE715, 0xEF0A, 0xED67, 0xED48, 0xEF0B, 0xEEF5,
    0xF61B, 0x022B, 0x022C, 0x01B2, 0x1546, 0x0CBD, 0xFFD5, 0xFB2B, 0x0104, 0xFF7F, 0xF11A, 0xEC6A, 0xE376, 0xE720, 0xF94B, 0xF8D3,
    0xF42E, 0x014D, 0x072C, 0xFCD6, 0x0143, 0x0C26, 0x0B5D, 0x0A80, 0x0B9E, 0x0D29, 0x13A1, 0x1835, 0x17F2, 0x15AE, 0x12DD, 0x151A,
    0x13BC, 0x1B4E, 0x1AED, 0x20FB, 0x2B20, 0x2ADF, 0x2B2C, 0x2179, 0x1E18, 0x1C7C, 0x19CD, 0x168D, 0x03E1, 0xF7B8, 0xF44E, 0xF9F0,
    0x03F4, 0xF810, 0xFC55, 0x02AD, 0x07F0, 0xFF71, 0xFF60, 0x0CD0, 0x0F07, 0x0D5B, 0xFCDE, 0x05BB, 0x012E, 0xFDB9, 0x00B1, 0x07BB,
    0x1041, 0x108C, 0x1D32, 0x2284, 0x268D, 0x29E9, 0x2ABC, 0x26D1, 0x2403, 0x1E09, 0x15AB, 0x128D, 0x0EEE, 0x07AD, 0xFFA2, 0xF4D9,
    0xF2E2, 0xF0BB, 0xEEF7, 0xEE0F, 0xEB7E, 0xE4A6, 0xE34D, 0xDDE1, 0xD5FC, 0xD2F4, 0xD285, 0xE02D, 0xD896, 0xDAC9, 0xD494, 0xD0B0,
    0xC715, 0xC50E, 0xD579, 0xD455, 0xDAE5, 0xD336, 0xE1B9, 0xF1A1, 0xF0E3, 0xE7D1, 0xDEA7, 0xE3E9, 0xE5FD, 0xDA9C, 0xDA88, 0xD3D1,
    0xD71B, 0xE152, 0xDD16, 0xE502, 0xD9FA, 0xE915, 0x02D8, 0x120B, 0x1A33, 0x13AA, 0x0E9C, 0x047F, 0xFFA3, 0xFA47, 0xF3B4, 0xFAB1,
    0xFFE8, 0x0B94, 0x0F04, 0x1C9F, 0x30CD, 0x338F, 0x2E89, 0x1D56, 0x27E4, 0x2DDF, 0x32C5, 0x39D1, 0x35A9, 0x32F8, 0x31B7, 0x2774,
    0x1C96, 0x164E, 0x1515, 0x0F01, 0x05E2, 0x04C6, 0xF9F5, 0x0236, 0x0394, 0x06CA, 0xFED3, 0xFB10, 0xF830, 0xE82D, 0xED4D, 0xEE28,
    0xEBEA, 0xE0EB, 0xE370, 0xE5CE, 0xE5A2, 0xED0F, 0xF20D, 0xF091, 0xE3E6, 0xE0BC, 0xEC6C, 0xEBAF, 0xEDF7, 0xE6DA, 0xE179, 0xEAB7,
    0xF06C, 0xFE28, 0xFCAB, 0xF94A, 0xF056, 0xF02C, 0xEC79, 0xE12C, 0xE0D1, 0xE318, 0xECF9, 0xFD6B, 0xFB54, 0xF1E0, 0xF503, 0xF4C6,
    0xE6F2, 0xE03E, 0xE114, 0xE284, 0xF0E9, 0xFF8A, 0x0BAD, 0x09CE, 0x1686, 0x19B0, 0x1B6F, 0x251E, 0x2CEC, 0x2E15, 0x3194, 0x42E3,
    0x4A29, 0x4367, 0x3B3B, 0x3ADA, 0x339F, 0x2E3B, 0x2606, 0x2AF6, 0x1D30, 0x134D, 0x110D, 0x0EF4, 0x14C1, 0x0CB0, 0x0712, 0x005D,
    0xF8C2, 0xF81B, 0x0254, 0xF8FD, 0xF51F, 0xF4C5, 0xF3D3, 0xEB6C, 0xD94E, 0xDA0B, 0xDF7D, 0xE4FD, 0xE993, 0xEC1C, 0xE30E, 0xE982,
    0xEFAB, 0xFB89, 0x08D9, 0x0C59, 0x0FA5, 0x0C14, 0x0373, 0xF3F9, 0xF240, 0xEEFB, 0xE9D5, 0xDF2A, 0xD94C, 0xD22D, 0xC895, 0xCC4A,
    0xCDBA, 0xCC91, 0xCF03, 0xCD9A, 0xCDB7, 0xCB39, 0xCBED, 0xC993, 0xD101, 0xDD53, 0xDC6B, 0xE2AD, 0xE463, 0xDCA7, 0xDCB2, 0xE62C,
    0xEEC1, 0xFEFE, 0x02D1, 0x0CA9, 0x15FB, 0x1D29, 0x204C, 0x1CB4, 0x1BA4, 0x2319, 0x2290, 0x2529, 0x1F84, 0x1665, 0x195E, 0x0EE0,
    0x0EB3, 0x0AF0, 0x1593, 0x1B36, 0x1C6C, 0x1C3A, 0x1BEF, 0x1A77, 0x1445, 0x0E88, 0x06AE, 0xFF3F, 0x0088, 0x026C, 0x02B5, 0x0494,
    0x1070, 0x1628, 0x161C, 0x1E09, 0x19A4, 0x1D56, 0x1FF8, 0x2E75, 0x3559, 0x3383, 0x29A2, 0x2459, 0x1FFA, 0x19D5, 0x0AE6, 0xFF5C,
    0x02B1, 0xF8CD, 0xECB9, 0xDF2E, 0xE998, 0xF16B, 0xF11F, 0xEE9D, 0xE97A, 0xE7E9, 0xE30E, 0xE0B3, 0xDF53, 0xDD2D, 0xDC6D, 0xE156,
    0xE1BF, 0xD808, 0xD84E, 0xE2AC, 0xEC91, 0xEF91, 0xEECC, 0xEE7C, 0xF246, 0xFABB, 0xFEBE, 0x0130, 0xFF7D, 0x014C, 0x00FC, 0xFF60,
    0xFA25, 0xF227, 0xF324, 0xF93A, 0xF914, 0xF2E7, 0xF0F7, 0xFB7E, 0x08BA, 0x033B, 0xFA4C, 0xF3B0, 0xF398, 0xEFEC, 0xE9FC, 0xEBC9,
    0xE6ED, 0xEDCF, 0xF5E0, 0xF9B7, 0x0151, 0x0755, 0x0BDD, 0x0968, 0x14BB, 0x2195, 0x25AC, 0x276B, 0x277B, 0x28AE, 0x283F, 0x28AB,
    0x22E0, 0x1D98, 0x1A63, 0x1748, 0x1552, 0x1358, 0x0F51, 0x050D, 0xFF5D, 0x0353, 0x0818, 0x04CA, 0x0015, 0x0044, 0xFFA5, 0xFD9A,
    0xF696, 0xF94D, 0xFD94, 0x053B, 0x0653, 0x0632, 0x0A3F, 0x0CC3, 0x1832, 0x1F84, 0x2531, 0x28A6, 0x2C11, 0x2FE9, 0x3319, 0x31F7,
    0x3679, 0x347F, 0x32B8, 0x2973, 0x238C, 0x2745, 0x1E56, 0x1328, 0x056C, 0xF93A, 0xED28, 0xE2B1, 0xDBAD, 0xDB86, 0xE02B, 0xE5A7,
    0xE9F9, 0xE115, 0xDA5C, 0xE2DF, 0xE4A0, 0xE418, 0xE058, 0xD8DE, 0xD586, 0xD712, 0xD7D9, 0xD991, 0xDE48, 0xE455, 0xEABC, 0xF3C5,
    0x0127, 0x0722, 0x04E2, 0x0072, 0xF9BF, 0xF22A, 0xF138, 0xED13, 0xE518, 0xE203, 0xE56C, 0xECB4, 0xED4D, 0xEC5F, 0xE9C8, 0xEFC7,
    0xF64F, 0x0086, 0x1326, 0x0D9B, 0x0C30, 0x16D3, 0x1538, 0x123D, 0x12EB, 0x0BD2, 0x0E65, 0x1366, 0x16D6, 0x1A54, 0x1C9D, 0x262C,
    0x2C48, 0x372B, 0x3F4B, 0x40A4, 0x4058, 0x3809, 0x3C9D, 0x3AA5, 0x2F76, 0x2A18, 0x20F2, 0x1C2B, 0x0C49, 0x0847, 0xFF5B, 0xFE6F,
    0xFD8B, 0xFD43, 0x1247, 0x14C5, 0x1174, 0x0A7E, 0x07DD, 0x04F2, 0x01DC, 0xFFE1, 0xF856, 0xF3D3, 0xEB2D, 0xE506, 0xE346, 0xDBCF,
    0xD8CB, 0xDD9A, 0xE4AF, 0xEC26, 0xF314, 0xF80D, 0x01B1, 0xF8B3, 0xEF19, 0xED4E, 0xE11C, 0xDAE9, 0xD70A, 0xD997, 0xD2DB, 0xD0EA,
    0xD52A, 0xDF66, 0xF258, 0xFB1C, 0x03A8, 0x0B94, 0x0F82, 0x0DBC, 0x0C07, 0x0242, 0xF55B, 0xF1B7, 0xF485, 0xF8D4, 0xF988, 0x0251,
    0x0DE1, 0x1D18, 0x23DC, 0x2597, 0x283A, 0x24F3, 0x2B9C, 0x2564, 0x2486, 0x2432, 0x2531, 0x2F50, 0x311B, 0x3418, 0x2DB0, 0x291A,
    0x209F, 0x1FB5, 0x157F, 0x11B6, 0x1CBE, 0x195D, 0x13A4, 0x13B1, 0x18CA, 0x167C, 0x158A, 0x1573, 0x1266, 0x0350, 0xFBD1, 0xF463,
    0xF0A8, 0xF1C8, 0xF34D, 0xF49F, 0xF05C, 0xEE67, 0xE9F4, 0xE785, 0xE776, 0xF10F, 0xF719, 0xFD6D, 0xFD94, 0xFD6C, 0xFA9A, 0xF9B7,
    0xF68F, 0xED0A, 0xED4B, 0xEDE4, 0xE983, 0xDE8C, 0xDC03, 0xDDA4, 0xDF2B, 0xE5FC, 0xE604, 0xD6E6, 0xCC1B, 0xCDCA, 0xD16C, 0xCD3A,
    0xCF55, 0xD602, 0xDA77, 0xE030, 0xE301, 0xE94B, 0xF058, 0xF012, 0xE8E3, 0xE633, 0xE8C7, 0xEC5E, 0xF035, 0xF852, 0x0060, 0x0532,
    0x076F, 0x0CAA, 0x0DAC, 0x07C3, 0x09AF, 0x0609, 0x08F9, 0x1111, 0x14F3, 0x1D8C, 0x1E62, 0x2108, 0x2152, 0x1F9E, 0x1FE9, 0x1AB7,
    0x133E, 0x0F01, 0x1376, 0x14C6, 0x1065, 0x0F40, 0x0CA8, 0x0628, 0x034F, 0x03DD, 0x0753, 0x07BF, 0x01FF, 0xFE5D, 0xFF04, 0x0293,
    0x06A9, 0x04F5, 0xFF71, 0xFB6A, 0xFD9E, 0xFDDE, 0xFEE1, 0x0402, 0x00C6, 0xFD0C, 0xF8B2, 0xF454, 0xEDCA, 0xEC4F, 0xF652, 0xF72F,
    0xF01C, 0xEA33, 0xEC09, 0xEF6B, 0xEA50, 0xE84E, 0xE5F6, 0xE917, 0xF025, 0xECEA, 0xE907, 0xE935, 0xEB53, 0xE87E, 0xE301, 0xDFA7,
    0xDF2A, 0xE2F1, 0xE3EA, 0xE8E9, 0xEAD6, 0xED74, 0xF1D9, 0xEDA7, 0xECA0, 0xECC8, 0xEFE0, 0xF154, 0xF45B, 0xF941, 0xFEC6, 0xFFF1,
    0xFFB4, 0x00B9, 0xFF39, 0x0062, 0x006C, 0x0300, 0x0518, 0x0616, 0xFF8D, 0xFBF9, 0xFDAE, 0x0047, 0x0648, 0x0CA3, 0x1533, 0x178A,
    0x1654, 0x15CF, 0x130A, 0x10D7, 0x0DE7, 0x0934, 0x0A0A, 0x0E15, 0x0E69, 0x0F2F, 0x1141, 0x1178, 0x1371, 0x12C4, 0x0EDB, 0x06D6,
    0x02FB, 0x0391, 0x06A8, 0x0CC7, 0x0A10, 0x0CCE, 0x1028, 0x1185, 0x178E, 0x16A6, 0x1368, 0x0FE4, 0x0CBE, 0x0AD3, 0x07BC, 0x03FD,
    0xFCFB, 0xFE89, 0x055F, 0x0C00, 0x15D8, 0x192D, 0x1606, 0x169D, 0x1E96, 0x244A, 0x23B6, 0x23E8, 0x2201, 0x1656, 0x0C59, 0x04D8,
    0xFBBD, 0xF157, 0xEA53, 0xE85A, 0xE802, 0xE9C7, 0xEB08, 0xED36, 0xE9EA, 0xE87C, 0xE69B, 0xE234, 0xE00A, 0xD70A, 0xD399, 0xD68D,
    0xD4EB, 0xD1D7, 0xCF04, 0xCCBC, 0xCBD5, 0xC937, 0xC955, 0xC89B, 0xC3F0, 0xC67F, 0xCF15, 0xD328, 0xD124, 0xCFB2, 0xD115, 0xD65B,
    0xD6D5, 0xDDD3, 0xE54D, 0xE9EC, 0xEF6A, 0xF145, 0xFA5D, 0x035B, 0x0F62, 0x0FA1, 0x0D57, 0x0B8C, 0x0513, 0x0A00, 0x0FD4, 0x16BC,
    0x183E, 0x1599, 0x1713, 0x18BF, 0x1B6D, 0x20C3, 0x2478, 0x1D19, 0x1A94, 0x2431, 0x2A79, 0x2D07, 0x2975, 0x2585, 0x24F4, 0x22C4,
    0x24B6, 0x255A, 0x1E90, 0x1A53, 0x1C94, 0x23B6, 0x2548, 0x20BC, 0x1CB9, 0x19B2, 0x1918, 0x15E7, 0x1000, 0x050D, 0x0554, 0x0987,
    0x0A7D, 0x0A6F, 0x04A4, 0x015E, 0xFDB5, 0xF966, 0xF1F7, 0xF0F8, 0xEFFC, 0xE981, 0xE4DF, 0xDE16, 0xD760, 0xD590, 0xDA14, 0xE0D2,
    0xE0CC, 0xE3E0, 0xE4BE, 0xDEAD, 0xDD80, 0xE2ED, 0xE65A, 0xE77B, 0xE918, 0xE86A, 0xECD4, 0xEBFE, 0xEF8E, 0xF5E3, 0xF50B, 0xF1DD,
    0xF87D, 0x01F9, 0xFE9B, 0xFDB6, 0x03FE, 0x0595, 0x016A, 0x023B, 0x05F9, 0x074A, 0x034E, 0x09E7, 0x14FF, 0x1C70, 0x2326, 0x23A5,
    0x243F, 0x2667, 0x2A16, 0x2A4E, 0x2D2F, 0x2DF0, 0x2CA4, 0x2AFD, 0x24FE, 0x24DD, 0x253E, 0x26CF, 0x2629, 0x22F9, 0x211D, 0x193F,
    0x1158, 0x0C86, 0x09B1, 0x07BE, 0x0AB2, 0x1005, 0x0D3B, 0x0402, 0xFCEA, 0xFB76, 0xFA0C, 0xF911, 0xF731, 0xF20A, 0xED8E, 0xEA45,
    0xE5B3, 0xE76F, 0xEAED, 0xEC56, 0xF402, 0xFA58, 0xFC5C, 0xFAAC, 0xF5AB, 0xF32F, 0xF45C, 0xF367, 0xF45C, 0xF609, 0xF2EF, 0xEE22,
    0xEAB8, 0xE63C, 0xE464, 0xE7FB, 0xE699, 0xE4D9, 0xE175, 0xDDDC, 0xDA4C, 0xD18F, 0xD44C, 0xDD02, 0xE2CF, 0xE695, 0xE621, 0xE778,
    0xEE56, 0xF551, 0xF149, 0xEF75, 0xF2AB, 0xF70E, 0xFA7A, 0xFE4D, 0x0357, 0xFF69, 0xFD09, 0x0242, 0x0B87, 0x13F8, 0x1A58, 0x1C54,
    0x1ED2, 0x246F, 0x2634, 0x29C0, 0x2B9E, 0x2AA8, 0x2C6A, 0x2FD8, 0x2FF8, 0x2D92, 0x29C9, 0x2374, 0x1DB8, 0x1834, 0x16FD, 0x1B4B,
    0x1CD3, 0x17EA, 0x1179, 0x0CED, 0x0A42, 0x09F1, 0x06F1, 0x0786, 0x0B37, 0x0940, 0x0580, 0x0195, 0xFEA9, 0xF8F9, 0xF8EF, 0xFBD4,
    0xFBE4, 0xFB4E, 0xF87B, 0xF6CA, 0xF5A5, 0xF24B, 0xEFEE, 0xF6B2, 0xFE77, 0x00E3, 0xFE2E, 0xFEFE, 0xFF97, 0xFA4E, 0xF553, 0xEC6E,
    0xE5D0, 0xE636, 0xE935, 0xECCC, 0xE69E, 0xDDEA, 0xD9E9, 0xDB04, 0xDF31, 0xE025, 0xE334, 0xE51D, 0xE938, 0xEBD6, 0xEADB, 0xE7FB,
    0xEA65, 0xEE9E, 0xEB84, 0xED64, 0xF243, 0xF42A, 0xF719, 0xFC93, 0x01DF, 0x0630, 0x0E62, 0x1628, 0x153D, 0x14A1, 0x15A0, 0x1324,
    0x1067, 0x0BF2, 0x0852, 0x0A0D, 0x0BB6, 0x0EAA, 0x0FE3, 0x0DB5, 0x0F30, 0x0F37, 0x0B8D, 0x0937, 0x0CCA, 0x12E4, 0x17B2, 0x1D49,
    0x20AF, 0x1C3C, 0x1AA5, 0x1A14, 0x1605, 0x15D3, 0x13D0, 0x130D, 0x1474, 0x1966, 0x18FB, 0x1371, 0x1189, 0x119B, 0x11DB, 0x1259,
    0x1572, 0x1212, 0x1085, 0x11AC, 0x10DD, 0x0E18, 0x0C07, 0x08E8, 0x013B, 0xFBA1, 0xF9E0, 0xFBB5, 0x00E4, 0x0A3B, 0x0A90, 0x0C73,
    0x1078, 0x0FD1, 0x1442, 0x178A, 0x1656, 0x1161, 0x0C7A, 0x0A4D, 0x0A06, 0x07DB, 0x0441, 0xFE85, 0xF7B9, 0xEDC7, 0xECDD, 0xEC0E,
    0xE3AC, 0xDFD7, 0xDB71, 0xDC71, 0xD7AE, 0xD189, 0xD038, 0xCF40, 0xCE09, 0xCD54, 0xCF77, 0xCCD9, 0xCA07, 0xCB25, 0xCC3A, 0xCAD1,
    0xC7D8, 0xC948, 0xCE6D, 0xD2A6, 0xD7C9, 0xD8F8, 0xD8A6, 0xD7A7, 0xD807, 0xDC35, 0xE0ED, 0xE4C8, 0xECE1, 0xF8B2, 0x0091, 0x04A3,
    0x05D2, 0x0B16, 0x0FB4, 0x14F1, 0x1914, 0x1BC5, 0x1EA0, 0x2284, 0x26E1, 0x226C, 0x2109, 0x2064, 0x1BDA, 0x1AE6, 0x1EFD, 0x1E7B,
    0x1F94, 0x227F, 0x24FD, 0x2B92, 0x307D, 0x389A, 0x3C2D, 0x391C, 0x37EB, 0x359B, 0x313B, 0x3195, 0x31DD, 0x2E81, 0x2808, 0x2116,
    0x1E67, 0x1AFF, 0x181A, 0x1955, 0x18FD, 0x18A6, 0x1692, 0x10FE, 0x0C57, 0x089A, 0x0567, 0xFE7E, 0xFAAD, 0xF4EE, 0xED2F, 0xE5BF,
    0xDD77, 0xD82E, 0xD2AA, 0xD258, 0xD123, 0xD3BA, 0xDA01, 0xDC77, 0xDE71, 0xDE61, 0xDDEA, 0xDD75, 0xD98F, 0xD330, 0xCE98, 0xCDDE,
    0xCFDD, 0xD22C, 0xD87D, 0xDEA8, 0xE786, 0xF015, 0xF4CF, 0xF716, 0xF521, 0xF319, 0xEFAC, 0xF252, 0xF60A, 0xF2E1, 0xF458, 0xF8BD,
    0xFA1A, 0xFF81, 0x08BA, 0x0FE0, 0x1346, 0x1272, 0x1243, 0x13C1, 0x1449, 0x16F3, 0x1C27, 0x22D4, 0x27B4, 0x2BB9, 0x2D64, 0x2B5A,
    0x2735, 0x26B7, 0x2A40, 0x29D8, 0x237E, 0x1C5E, 0x19F8, 0x1A3E, 0x1E3A, 0x22C8, 0x2463, 0x24EB, 0x1FC0, 0x1743, 0x12D5, 0x0F50,
    0x0A62, 0x0669, 0x06B6, 0x058F, 0x025A, 0xFEC6, 0xFCEE, 0xF738, 0xEE0B, 0xEA09, 0xE634, 0xE7B0, 0xF122, 0xFCD4, 0x03BE, 0x025F,
    0xFCCD, 0xF92A, 0xF654, 0xF2E6, 0xF5C7, 0xFC19, 0xFE7E, 0xFC53, 0xF6A7, 0xF129, 0xEBF8, 0xE8DC, 0xE9E7, 0xE780, 0xDEC3, 0xD950,
    0xD741, 0xD6AE, 0xD8C9, 0xDB75, 0xDC34, 0xDA7E, 0xD4A6, 0xCEAA, 0xD025, 0xD382, 0xD958, 0xE14A, 0xE7FA, 0xECB3, 0xF0EC, 0xF782,
    0xFC7B, 0xFF93, 0xFEE4, 0xFA33, 0xF989, 0xFB60, 0xFF1C, 0x034E, 0x0BC1, 0x1284, 0x12BD, 0x1638, 0x19B7, 0x1FE9, 0x230D, 0x2193,
    0x224C, 0x2552, 0x27EC, 0x26B5, 0x2294, 0x1F82, 0x2114, 0x20C1, 0x1EA9, 0x1C94, 0x1902, 0x15F7, 0x0E4E, 0x038C, 0xFEC4, 0xFD28,
    0x0035, 0x047B, 0x0784, 0x0796, 0x045A, 0x0184, 0xFFE8, 0x00B8, 0x015B, 0x02E7, 0x0367, 0x0453, 0x031E, 0x022B, 0x0213, 0x00B2,
    0x0566, 0x08FB, 0x0804, 0x05F2, 0x057A, 0x077D, 0x072E, 0x0448, 0xFFEC, 0xF88E, 0xF35F, 0xF27E, 0xF01F, 0xEB03, 0xE408, 0xE13A,
    0xDFB3, 0xDDC1, 0xDD87, 0xDE7C, 0xE0DD, 0xE243, 0xE288, 0xE46B, 0xE531, 0xE3D4, 0xE751, 0xE9C6, 0xE9B7, 0xE94A, 0xEBD9, 0xEF22,
    0xF172, 0xF8BD, 0xFF35, 0x0409, 0x0778, 0x094E, 0x08AC, 0x07A8, 0x04E6, 0x0070, 0xFE9A, 0xFFF8, 0x081E, 0x0F6C, 0x0F24, 0x0AEC,
    0x0CD5, 0x0DFB, 0x08A1, 0x0664, 0x099D, 0x102E, 0x1290, 0x1268, 0x141E, 0x166B, 0x1940, 0x1B0B, 0x1A8F, 0x1ABB, 0x1DD8, 0x1AF1,
    0x113B, 0x0ED6, 0x0E5F, 0x1029, 0x13E7, 0x15AA, 0x17D1, 0x1782, 0x14E0, 0x11FA, 0x1175, 0x1241, 0x11B8, 0x0D2F, 0x0BE8, 0x0970,
    0x0961, 0x0C88, 0x0B1C, 0x0B5C, 0x0B4B, 0x0D85, 0x1128, 0x1390, 0x1A85, 0x1E56, 0x1F07, 0x20B3, 0x20A3, 0x21B8, 0x210D, 0x1CD9,
    0x1968, 0x1796, 0x1269, 0x0DD0, 0x0912, 0x02F9, 0xFD22, 0xF659, 0xF0C6, 0xEC66, 0xEA75, 0xE925, 0xE671, 0xDE62, 0xD449, 0xCCA3,
    0xC95D, 0xC9A7, 0xCAB6, 0xCA8D, 0xC707, 0xC4F1, 0xC396, 0xC3A1, 0xC3E2, 0xC622, 0xCA1C, 0xCDFE, 0xD30C, 0xD667, 0xD716, 0xD591,
    0xD45D, 0xD8EF, 0xE2B7, 0xE860, 0xEC0E, 0xEDAF, 0xF1B8, 0xF438, 0xF3F0, 0xF66E, 0xF852, 0xFC25, 0x0413, 0x0FE2, 0x157C, 0x1447,
    0x12A4, 0x162D, 0x1A4F, 0x1BFA, 0x1D6E, 0x1D22, 0x1BBC, 0x1811, 0x1954, 0x1EE8, 0x2337, 0x2AC8, 0x31D3, 0x33FA, 0x348D, 0x3457,
    0x3466, 0x37A0, 0x3C37, 0x3FC9, 0x416C, 0x3CDE, 0x3788, 0x3521, 0x3129, 0x2B76, 0x268D, 0x2062, 0x1C51, 0x1D1F, 0x1D6F, 0x1BAB,
    0x1807, 0x169E, 0x1541, 0x1297, 0x0DD8, 0x083C, 0x0160, 0xF7FA, 0xF10D, 0xEC08, 0xE86B, 0xE1A4, 0xDAC1, 0xD799, 0xD738, 0xD99D,
    0xDDB9, 0xE113, 0xE192, 0xE0AA, 0xDE6F, 0xDBC6, 0xD94C, 0xD6C9, 0xD585, 0xD74F, 0xDB2C, 0xDE64, 0xE0E1, 0xE64E, 0xEBEB, 0xEE2E,
    0xEBCC, 0xEA60, 0xEBB0, 0xEBD5, 0xE90E, 0xE4F4, 0xE6D1, 0xED5E, 0xF33C, 0xF63F, 0xF9E1, 0xFB7D, 0xFBE8, 0xFECC, 0x0428, 0x0E29,
    0x1744, 0x1C2E, 0x21EB, 0x24D9, 0x285F, 0x30F3, 0x35BB, 0x3640, 0x3678, 0x3A45, 0x3F53, 0x3FA7, 0x3856, 0x2FDA, 0x2898, 0x2307,
    0x20E6, 0x204F, 0x2335, 0x23D4, 0x20B9, 0x1C23, 0x1856, 0x18B1, 0x16F2, 0x108E, 0x0964, 0x0304, 0xFC20, 0xF89F, 0xFA02, 0xFA75,
    0xF7E0, 0xF563, 0xF90B, 0xF855, 0xF475, 0xF64C, 0xFC7F, 0x003F, 0xFDD0, 0xFC98, 0xFC08, 0xFD48, 0x0011, 0x009E, 0xFF7B, 0x0267,
    0x0565, 0x04D5, 0x03A7, 0x020D, 0xFE68, 0xF8B6, 0xF2F6, 0xEFE5, 0xECC3, 0xE7FF, 0xE3E2, 0xE001, 0xDC3E, 0xD5EC, 0xD109, 0xD163,
    0xD527, 0xD8E4, 0xDECC, 0xE42E, 0xE69A, 0xE920, 0xE970, 0xE9DB, 0xEAEA, 0xED13, 0xF2B0, 0xF761, 0xF735, 0xF844, 0xFE63, 0x0265,
    0x0473, 0x0645, 0x0655, 0x051D, 0x01F9, 0x05F8, 0x0D52, 0x1372, 0x1915, 0x1D09, 0x1E97, 0x19F7, 0x1674, 0x15BE, 0x1591, 0x1207,
    0x0F14, 0x0EB1, 0x0BB5, 0x0682, 0x03A1, 0x05E2, 0x0711, 0x06B3, 0x04E6, 0x0726, 0x0CA6, 0x0F69, 0x0E97, 0x0BF3, 0x0925, 0x0883,
    0x0C6B, 0x0D92, 0x0A8C, 0x0470, 0xFF24, 0xFEC3, 0xFD4B, 0xFCAD, 0x00AB, 0x0676, 0x0818, 0x092D, 0x0BCA, 0x0B81, 0x0B45, 0x082F,
    0x03C3, 0x00B9, 0xFF6C, 0xFDC8, 0xF774, 0xF0A8, 0xED56, 0xEE1D, 0xEC90, 0xE981, 0xEA6A, 0xEC2B, 0xECEA, 0xEE79, 0xEE9F, 0xEB8A,
    0xEA7D, 0xE994, 0xE70A, 0xE6A6, 0xE6FB, 0xE891, 0xE9EA, 0xEC17, 0xEE66, 0xF1D7, 0xF207, 0xF132, 0xF44C, 0xF68D, 0xF84B, 0xF763,
    0xF9A8, 0xFAB1, 0xF91A, 0xF601, 0xF222, 0xF278, 0xF72C, 0xFBB4, 0xFDF4, 0x0010, 0x008D, 0x02CF, 0x05FA, 0x08C1, 0x0C00, 0x0DD8,
    0x0D54, 0x0CB5, 0x0ED8, 0x1202, 0x118D, 0x0FB1, 0x0D4C, 0x0CE8, 0x0DDA, 0x0BE9, 0x09B5, 0x0CC9, 0x0F94, 0x10B2, 0x127A, 0x123B,
    0x11F0, 0x0F99, 0x0E51, 0x0ED0, 0x0EF6, 0x0EE9, 0x0DD2, 0x0E58, 0x1030, 0x11A6, 0x10C7, 0x0C0F, 0x0A05, 0x0C5C, 0x0F4F, 0x115B,
    0x14B3, 0x1A4C, 0x2141, 0x2627, 0x25DE, 0x2235, 0x1C9D, 0x19BC, 0x19FC, 0x1A2E, 0x18B7, 0x13A2, 0x0C23, 0x0541, 0xFF3F, 0xF9F4,
    0xF723, 0xF546, 0xF328, 0xF1C6, 0xF08A, 0xEE35, 0xE75E, 0xDE83, 0xD7A3, 0xD101, 0xCC5D, 0xCD64, 0xCE63, 0xCEEC, 0xD0AD, 0xD097,
    0xD001, 0xD034, 0xCFFD, 0xD11C, 0xD278, 0xD321, 0xD3C2, 0xD486, 0xD3BE, 0xD0A6, 0xCF24, 0xCED0, 0xCF42, 0xCE7D, 0xD010, 0xD4E1,
    0xDB2E, 0xE0A0, 0xE773, 0xEF27, 0xF531, 0xFC6A, 0xFE61, 0xFF35, 0x0117, 0x04BA, 0x0AF2, 0x1041, 0x160D, 0x1B5D, 0x1D1D, 0x1C24,
    0x1912, 0x18C2, 0x19B5, 0x1AFC, 0x20D7, 0x2760, 0x2D44, 0x32D2, 0x388A, 0x39AD, 0x37E7, 0x363E, 0x34A7, 0x3036, 0x28B9, 0x231F,
    0x20AB, 0x2128, 0x2143, 0x246B, 0x2659, 0x2553, 0x24A2, 0x226F, 0x2071, 0x1B77, 0x145C, 0x11D5, 0x12EA, 0x1385, 0x11C9, 0x0D30,
    0x0553, 0xFB93, 0xF6F0, 0xF430, 0xEFFF, 0xEB8C, 0xE92D, 0xE7D2, 0xE74B, 0xE5D8, 0xE094, 0xD9D8, 0xCFB5, 0xCA69, 0xCB7D, 0xCE93,
    0xD113, 0xD2B0, 0xD4DB, 0xD693, 0xD8DE, 0xDB08, 0xDF6F, 0xE36E, 0xE579, 0xE673, 0xE5BB, 0xE5EB, 0xE7DD, 0xEA2A, 0xECE1, 0xF1B4,
    0xF753, 0xF9D9, 0xFAC4, 0xFEC5, 0x03BE, 0x066A, 0x06BC, 0x07BC, 0x0C65, 0x1021, 0x1553, 0x1D3F, 0x2393, 0x264D, 0x28FE, 0x2C54,
    0x2E47, 0x2E26, 0x2CF8, 0x2CA4, 0x29CF, 0x26AF, 0x2137, 0x1D3B, 0x1A59, 0x166D, 0x1511, 0x1555, 0x143E, 0x107F, 0x0F42, 0x0F45,
    0x1093, 0x0F49, 0x0CBA, 0x096C, 0x02DA, 0xFD96, 0xF95A, 0xF5CF, 0xF154, 0xECB5, 0xEAE3, 0xE8C1, 0xE7B6, 0xECDA, 0xF475, 0xF9DF,
    0xFD64, 0x0148, 0x0415, 0x062B, 0x06D0, 0x062B, 0x023A, 0xFBBC, 0xF829, 0xF5B0, 0xF267, 0xEED2, 0xEE1C, 0xEF83, 0xF133, 0xF1C1,
    0xF009, 0xEA93, 0xE37E, 0xDE20, 0xDA31, 0xD9B6, 0xDC8E, 0xDFBA, 0xE20D, 0xE44C, 0xE6BF, 0xE875, 0xE938, 0xE7D2, 0xE7E9, 0xEA16,
    0xEB81, 0xF029, 0xF4BA, 0xF86A, 0xFBEC, 0xFEEA, 0x046A, 0x0867, 0x0AFC, 0x0CCA, 0x0C0E, 0x0829, 0x0509, 0x056A, 0x076D, 0x097F,
    0x0C51, 0x103C, 0x112F, 0x11E3, 0x1300, 0x12C7, 0x1103, 0x0E59, 0x0EDC, 0x1047, 0x0D8B, 0x0A53, 0x0874, 0x05D9, 0x0402, 0x033F,
    0x0409, 0x0718, 0x0D05, 0x11C2, 0x137E, 0x12E2, 0x0F06, 0x0B70, 0x090B, 0x0855, 0x065E, 0x0196, 0x000D, 0xFE82, 0xFD67, 0xFF88,
    0x009E, 0x03A9, 0x05C6, 0x06A5, 0x0677, 0x086E, 0x0B21, 0x0AD4, 0x0A6A, 0x08F4, 0x07B3, 0x032B, 0xFE2B, 0xF91A, 0xF851, 0xFBE0,
    0xFD6E, 0xFB3A, 0xF6D7, 0xF54C, 0xF43E, 0xF3F1, 0xF4B2, 0xF174, 0xEC02, 0xE966, 0xE68F, 0xE1FF, 0xDF95, 0xE281, 0xE4A7, 0xE7D3,
    0xEE0C, 0xF554, 0xF78E, 0xF659, 0xF648, 0xF6FC, 0xF6EF, 0xF69C, 0xFA0A, 0xFAD4, 0xF9F4, 0xFAD2, 0xFD9B, 0xFC4A, 0xFB90, 0xFE8A,
    0x0125, 0x0155, 0x0002, 0x0095, 0x0194, 0x042E, 0x0A0E, 0x10F7, 0x1374, 0x1264, 0x110F, 0x11A0, 0x0FF3, 0x108D, 0x15FB, 0x1724,
    0x14FB, 0x1368, 0x13BB, 0x11A4, 0x0D16, 0x0CAE, 0x0F33, 0x1032, 0x1119, 0x14A7, 0x189E, 0x18ED, 0x16BD, 0x15A0, 0x1398, 0x0F91,
    0x0AB9, 0x0841, 0x076B, 0x0523, 0x03C8, 0x0360, 0x047C, 0x0552, 0x085B, 0x0E71, 0x12C0, 0x167F, 0x1AFF, 0x20A8, 0x22AF, 0x1F81,
    0x1C04, 0x17EC, 0x1354, 0x0F6D, 0x0D15, 0x08AF, 0x0501, 0x0508, 0x07D9, 0x0AEC, 0x0A9F, 0x0AA2, 0x09C8, 0x04FA, 0xFB17, 0xF111,
    0xE7FC, 0xDDC1, 0xD536, 0xD0CC, 0xD031, 0xCD39, 0xC993, 0xC866, 0xC868, 0xC7A9, 0xC8C1, 0xCD28, 0xCD9C, 0xCBDC, 0xCAFC, 0xCB84,
    0xCBA8, 0xCCBB, 0xD38A, 0xDA41, 0xDD1C, 0xDCD5, 0xDC26, 0xDC1E, 0xDEA3, 0xE5D8, 0xEDC8, 0xF4F8, 0xF94A, 0xFD41, 0x020C, 0x05F6,
    0x0B5C, 0x0EE6, 0x115E, 0x1211, 0x133E, 0x12AD, 0x0E79, 0x0AAC, 0x0862, 0x09D7, 0x0B7B, 0x0F96, 0x1597, 0x1D23, 0x24C1, 0x2AA0,
    0x30B0, 0x3434, 0x3697, 0x35D8, 0x331C, 0x30F3, 0x2EC3, 0x2F9C, 0x2D48, 0x27ED, 0x2347, 0x210E, 0x1F44, 0x1C60, 0x1BF4, 0x1C41,
    0x1ED3, 0x21BD, 0x23C3, 0x205B, 0x1B24, 0x17AB, 0x119B, 0x0B05, 0x02ED, 0xFAC1, 0xF4EB, 0xF1F6, 0xEE05, 0xE88E, 0xE57A, 0xE45A,
    0xE452, 0xE45B, 0xE2B6, 0xDFB8, 0xDBF9, 0xD86A, 0xD646, 0xD55B, 0xD4AD, 0xD336, 0xD3AA, 0xD4D5, 0xD4E6, 0xD45B, 0xD604, 0xDBFB,
    0xE0B2, 0xE2DB, 0xE35D, 0xE401, 0xE50E, 0xE512, 0xE5DD, 0xE8ED, 0xEDB6, 0xF341, 0xF76C, 0xF947, 0xF978, 0xF798, 0xF905, 0xFD22,
    0x01D6, 0x0951, 0x1203, 0x1AE5, 0x22B1, 0x291A, 0x2D91, 0x2F03, 0x2F36, 0x2E5E, 0x2EC5, 0x2DBB, 0x2BB3, 0x2AC6, 0x2B1C, 0x2CB5,
    0x2CBF, 0x2D3F, 0x2B44, 0x2772, 0x22BC, 0x1C51, 0x17E7, 0x173F, 0x16B9, 0x1467, 0x1194, 0x0BBB, 0x04FF, 0xFD19, 0xF4CA, 0xEE71,
    0xEA8A, 0xE7E2, 0xE63A, 0xE8BF, 0xEDFB, 0xF300, 0xF505, 0xF5D7, 0xF80B, 0xFA37, 0xFCAB, 0xFE4D, 0xFFC1, 0x0109, 0xFFB5, 0xFD34,
    0xF97C, 0xF597, 0xF4F4, 0xF900, 0xFE7C, 0xFE79, 0xFAB6, 0xF8CD, 0xF67A, 0xF347, 0xF0B2, 0xEC50, 0xE67C, 0xDF3B, 0xDD07, 0xDDDF,
    0xDD26, 0xDF4B, 0xE359, 0xE8A7, 0xEB2B, 0xEBA5, 0xED0D, 0xEEBC, 0xF126, 0xF48C, 0xF749, 0xF789, 0xF69C, 0xF704, 0xF6E5, 0xF770,
    0xFCD1, 0x034C, 0x056A, 0x03C5, 0x03B4, 0x0564, 0x06E8, 0x08D1, 0x0A68, 0x0B78, 0x0D03, 0x1151, 0x168D, 0x1A0E, 0x1930, 0x15CC,
    0x1301, 0x0FFB, 0x0D4F, 0x0B06, 0x0A29, 0x09E6, 0x0C3D, 0x0D50, 0x0CB7, 0x0C37, 0x0D5B, 0x1076, 0x0F5B, 0x0F58, 0x0F44, 0x0FA4,
    0x1172, 0x1230, 0x1213, 0x0B99, 0x02D7, 0xFE9B, 0xFF5E, 0xFF87, 0xFDCB, 0xFCCA, 0xFE3A, 0x0221, 0x0418, 0x0535, 0x05F3, 0x05CC,
    0x0443, 0x01DE, 0x01A9, 0xFDDD, 0xF9A6, 0xF86C, 0xF7B6, 0xF940, 0xF8F9, 0xF801, 0xF6EB, 0xF613, 0xF5C7, 0xF812, 0xF9D9, 0xF873,
    0xF691, 0xF3F5, 0xF225, 0xEF30, 0xEDA1, 0xEB77, 0xEA8A, 0xEBD8, 0xEB7C, 0xED19, 0xEF14, 0xF05E, 0xF130, 0xF19C, 0xF1CF, 0xF2F6,
    0xF624, 0xF73A, 0xF61E, 0xF39E, 0xF1A9, 0xEEAB, 0xECA8, 0xEE12, 0xF0AA, 0xF454, 0xF488, 0xF324, 0xF414, 0xF89D, 0xFFFC, 0x06F8,
    0x0C07, 0x0E74, 0x0FD8, 0x12D0, 0x15CB, 0x181A, 0x193C, 0x1A3B, 0x1AFB, 0x1AAE, 0x186B, 0x16A0, 0x161F, 0x1447, 0x1341, 0x132F,
    0x1523, 0x18AC, 0x1BFB, 0x1E4C, 0x1F94, 0x1CE4, 0x1973, 0x169A, 0x1252, 0x0F46, 0x0CF6, 0x0ABE, 0x07CE, 0x054C, 0x078D, 0x0B39,
    0x0F23, 0x133C, 0x17AA, 0x1CC6, 0x1EF6, 0x213D, 0x207E, 0x1E45, 0x1C11, 0x1A7A, 0x19BE, 0x1700, 0x1667, 0x1682, 0x1435, 0x117E,
    0x0CC5, 0x0647, 0x01A3, 0xFF54, 0xFD01, 0xF855, 0xF161, 0xE95A, 0xE2B9, 0xDD0C, 0xD727, 0xD17B, 0xCF14, 0xCE55, 0xCF7A, 0xCF8D,
    0xCC9F, 0xCA36, 0xCA93, 0xCCEA, 0xCD97, 0xCE75, 0xCE04, 0xCF16, 0xD1B0, 0xD426, 0xD846, 0xD9E9, 0xD811, 0xD5D6, 0xD5D1, 0xD81E,
    0xDA5F, 0xDC93, 0xE004, 0xE553, 0xEAB7, 0xF03B, 0xF5F6, 0xF87A, 0xFA3B, 0xFD7E, 0x0182, 0x03FF, 0x0590, 0x070E, 0x0811, 0x099E,
    0x0C17, 0x122C, 0x187F, 0x1C5E, 0x2129, 0x26C5, 0x2BE8, 0x303E, 0x35CF, 0x3A77, 0x3C2C, 0x3C15, 0x3E49, 0x407A, 0x3E66, 0x3AE7,
    0x3639, 0x32E7, 0x2DA3, 0x27FA, 0x2563, 0x2524, 0x252F, 0x2600, 0x280F, 0x2710, 0x2403, 0x1F27, 0x1A59, 0x155C, 0x0F21, 0x0940,
    0x03D8, 0x0035, 0xFCE8, 0xF955, 0xF5F1, 0xF3DB, 0xF384, 0xF2FB, 0xF2A9, 0xF0B6, 0xEC09, 0xE419, 0xDC24, 0xD699, 0xD322, 0xD19F,
    0xD098, 0xCFE4, 0xCEDA, 0xD0FF, 0xD423, 0xD618, 0xD75D, 0xD8BC, 0xDAF5, 0xDB06, 0xDA4C, 0xDA4D, 0xDA80, 0xDCAE, 0xE05A, 0xE332,
    0xE5F2, 0xE999, 0xED06, 0xEF92, 0xF225, 0xF4A2, 0xF78E, 0xF98B, 0xFD5E, 0x0376, 0x08A1, 0x104F, 0x17F3, 0x1E1B, 0x23FC, 0x2979,
    0x2CB5, 0x2E64, 0x310B, 0x319B, 0x30F5, 0x2E6C, 0x2AAB, 0x2747, 0x2544, 0x23C5, 0x2186, 0x2063, 0x1F97, 0x1FE8, 0x1F93, 0x1F14,
    0x1DAF, 0x1ABE, 0x17D7, 0x130E, 0x0F45, 0x0BDC, 0x07AF, 0x0351, 0xFD83, 0xF83E, 0xF345, 0xF038, 0xEEAE, 0xF121, 0xF51C, 0xF7BC,
    0xFA8F, 0xFBEE, 0xFD5C, 0xFC76, 0xFB73, 0xF99F, 0xF7F7, 0xF765, 0xF5BF, 0xF49B, 0xF3C9, 0xF5F8, 0xF7D7, 0xF857, 0xF72A, 0xF5C6,
    0xF5D3, 0xF36C, 0xEEF8, 0xE8B8, 0xE493, 0xE0F6, 0xDD93, 0xDCDC, 0xDBCC, 0xDA96, 0xDA49, 0xDA7C, 0xD994, 0xDA96, 0xDEDD, 0xE396,
    0xE586, 0xE68E, 0xE9DA, 0xEE62, 0xF31C, 0xF70F, 0xF8CB, 0xF911, 0xF836, 0xF879, 0xF957, 0xF9DB, 0xFB91, 0xFE97, 0x02F6, 0x0605,
    0x0843, 0x08B0, 0x0890, 0x0970, 0x0CED, 0x0FB9, 0x0FA9, 0x0FE9, 0x0FB3, 0x0F45, 0x0BCA, 0x0856, 0x0737, 0x0613, 0x0413, 0x02C0,
    0x0229, 0x024E, 0x04B8, 0x06CF, 0x0915, 0x0B3D, 0x0D02, 0x1068, 0x1361, 0x1674, 0x1867, 0x1887, 0x1534, 0x0F08, 0x0C1B, 0x0A44,
    0x08D6, 0x06B7, 0x05A1, 0x060C, 0x06F1, 0x09A2, 0x0DCC, 0x1102, 0x1121, 0x10D4, 0x0F78, 0x0B87, 0x063A, 0x038A, 0x02D9, 0x0167,
    0x023B, 0x045A, 0x049C, 0x03B0, 0x0373, 0x01FD, 0xFFA7, 0xFDA6, 0xFA00, 0xF666, 0xF3C5, 0xF13F, 0xECD8, 0xE8D4, 0xE71A, 0xE5B4,
    0xE5F9, 0xE64F, 0xE59D, 0xE3E9, 0xE316, 0xE493, 0xE6AF, 0xE8B3, 0xE98A, 0xE97D, 0xE84E, 0xE84A, 0xEA25, 0xE9B1, 0xE7F3, 0xE7A9,
    0xE7A8, 0xE84A, 0xE9E8, 0xEB36, 0xEC6E, 0xEE1E, 0xF24B, 0xF8AB, 0xFE55, 0x023C, 0x05B8, 0x0ACF, 0x119C, 0x16B8, 0x19B2, 0x1C2B,
    0x1C59, 0x1C6B, 0x1C2A, 0x1BC5, 0x1A8A, 0x1834, 0x1684, 0x146F, 0x132D, 0x13BB, 0x15F2, 0x15EE, 0x14DE, 0x15D9, 0x1758, 0x175B,
    0x1552, 0x1419, 0x11BD, 0x0EBF, 0x0D06, 0x0CE7, 0x0ECB, 0x10AF, 0x1425, 0x182C, 0x1C45, 0x1F7E, 0x223F, 0x24EA, 0x26DC, 0x26E6,
    0x2591, 0x2496, 0x2215, 0x20C5, 0x1EFB, 0x1CC0, 0x1BA4, 0x1BE7, 0x1BFF, 0x1829, 0x129E, 0x0C04, 0x04D1, 0xFDDA, 0xF77A, 0xF195,
    0xEAFA, 0xE4FD, 0xE16C, 0xE0A5, 0xE1DC, 0xE3AA, 0xE41C, 0xE2E7, 0xE0E3, 0xDE32, 0xDB4C, 0xD83F, 0xD5A7, 0xD25A, 0xCF76, 0xCCC8,
    0xC9F1, 0xC8B6, 0xC9A4, 0xCAFB, 0xCC8F, 0xCEB9, 0xD04D, 0xD13C, 0xD113, 0xD0CC, 0xD1A8, 0xD1D6, 0xD122, 0xD0D2, 0xD16A, 0xD2A4,
    0xD510, 0xD87F, 0xDBA7, 0xDE77, 0xE09C, 0xE35B, 0xE732, 0xED67, 0xF553, 0xFCD6, 0x03C7, 0x0A9F, 0x0E08, 0x0F7D, 0x1162, 0x14D1,
    0x1BEF, 0x248A, 0x2C04, 0x30F5, 0x32E8, 0x3242, 0x30CE, 0x2DAF, 0x2A0B, 0x287A, 0x2AE5, 0x2F73, 0x34E6, 0x3A32, 0x3E9E, 0x419C,
    0x4425, 0x461D, 0x46F2, 0x469D, 0x4835, 0x4A91, 0x4908, 0x44DC, 0x3F89, 0x3C2D, 0x37B7, 0x30E3, 0x2899, 0x1CF6, 0x10D8, 0x0666,
    0xFD47, 0xF4BB, 0xEC57, 0xE725, 0xE120, 0xDA7F, 0xD5F4, 0xD300, 0xD0F9, 0xCF31, 0xD02B, 0xD179, 0xD2A7, 0xD38E, 0xD37E, 0xD292,
    0xD04B, 0xCE45, 0xCC70, 0xCB1E, 0xCA3A, 0xCAFF, 0xCE2B, 0xD0C5, 0xD305, 0xD577, 0xD923, 0xDEFA, 0xE50B, 0xEADD, 0xF00A, 0xF40E,
    0xF890, 0xFDE5, 0x0347, 0x0732, 0x0B80, 0x1381, 0x1C47, 0x232A, 0x2764, 0x292D, 0x28AC, 0x249D, 0x2003, 0x1AD7, 0x16C9, 0x1445,
    0x12C3, 0x154C, 0x164F, 0x16A8, 0x16C5, 0x153A, 0x13C2, 0x12CF, 0x1553, 0x1A83, 0x1EC8, 0x2124, 0x22A6, 0x2350, 0x225B, 0x1D8F,
    0x15DC, 0x0C4D, 0x0305, 0xFBE5, 0xF740, 0xF3C8, 0xF09A, 0xEFBB, 0xEFBD, 0xF06E, 0xF06C, 0xF1C2, 0xF548, 0xF8F6, 0xFCE1, 0x00CC,
    0x071A, 0x0C18, 0x0E04, 0x1008, 0x0FCC, 0x0B07, 0x0358, 0xFC3A, 0xF6CD, 0xF12C, 0xEBC6, 0xE8A3, 0xE6DF, 0xE57D, 0xE59C, 0xE60B,
    0xE596, 0xE59D, 0xE7FE, 0xEB52, 0xEE86, 0xF0FE, 0xF27B, 0xF2ED, 0xF442, 0xF805, 0xFA88, 0xFC4C, 0xFB66, 0xF87E, 0xF57C, 0xF11A,
    0xED10, 0xEB89, 0xECB6, 0xF091, 0xF6CF, 0xFBF7, 0xFF76, 0xFF6D, 0xFD36, 0xFAE9, 0xFA0E, 0xFB3B, 0xFE43, 0x03E4, 0x0A60, 0x10BF,
    0x141B, 0x1676, 0x1844, 0x18F7, 0x1834, 0x1435, 0x0F27, 0x0910, 0x0472, 0x025B, 0x00AD, 0xFE12, 0xFCB5, 0xFE17, 0xFECA, 0xFFE5,
    0x0292, 0x08A5, 0x0F11, 0x1467, 0x18D9, 0x1994, 0x16E4, 0x111F, 0x0B39, 0x04BA, 0xFE27, 0xF7B2, 0xF35C, 0xF21F, 0xF1C0, 0xF33E,
    0xF5AB, 0xF72B, 0xF798, 0xFA65, 0xFE8F, 0x0363, 0x08A1, 0x0D34, 0x11A4, 0x13C4, 0x14F5, 0x16EC, 0x18B8, 0x1A53, 0x1B1C, 0x19FD,
    0x1715, 0x12B4, 0x0D3B, 0x0592, 0xFCC7, 0xF6B2, 0xF4DC, 0xF514, 0xF60D, 0xF6D0, 0xF87A, 0xF9AA, 0xF7DF, 0xF48F, 0xF100, 0xEDF6,
    0xEA85, 0xE7FA, 0xE70C, 0xE889, 0xEB77, 0xECDA, 0xEE2B, 0xF07A, 0xF1AA, 0xF0F1, 0xEDEC, 0xE98A, 0xE565, 0xE1F9, 0xE07C, 0xE0E2,
    0xE0AD, 0xDFF3, 0xE0C6, 0xE251, 0xE66B, 0xEF82, 0xFA31, 0x032D, 0x0A5A, 0x1090, 0x12C2, 0x108C, 0x0C90, 0x0907, 0x0645, 0x02F9,
    0x0056, 0xFDE0, 0xFBDB, 0xFA65, 0xFB2A, 0xFE29, 0x0065, 0x030A, 0x0754, 0x0AE9, 0x0B92, 0x0C34, 0x0C99, 0x0C3C, 0x0AED, 0x0C8F,
    0x129F, 0x1860, 0x1F08, 0x24B9, 0x2840, 0x27FD, 0x23A9, 0x1EF4, 0x1ADB, 0x18C5, 0x1850, 0x1B3D, 0x1FCD, 0x23F7, 0x2841, 0x29AD,
    0x27D7, 0x2366, 0x1EED, 0x1B3D, 0x177D, 0x1274, 0x0C7B, 0x07AC, 0x0445, 0x013D, 0xFDD0, 0xFA93, 0xF7B4, 0xF45B, 0xEFC5, 0xED42,
    0xEAAD, 0xE771, 0xE57D, 0xE328, 0xDFDD, 0xDA3E, 0xD57F, 0xD215, 0xCED7, 0xCF2A, 0xD179, 0xD424, 0xD4FA, 0xD44F, 0xD29E, 0xCF68,
    0xCB0E, 0xC74F, 0xC3DE, 0xC1F1, 0xC2C5, 0xC4C1, 0xC679, 0xC8D5, 0xCC96, 0xD157, 0xD66E, 0xDCF0, 0xE575, 0xECD2, 0xF34C, 0xF5EF,
    0xF6CD, 0xF517, 0xF510, 0xF5EE, 0xF869, 0xFCF2, 0x0812, 0x0A97, 0x13B0, 0x34D4, 0x3901, 0x382B, 0x3C8C, 0x3D5F, 0x4275, 0x4083,
    0x404B, 0x3B2D, 0x3F6A, 0x3519, 0x352B, 0x4B0E, 0x4603, 0x3BE0, 0x2AAA, 0x1B6D, 0x16AB, 0x12E8, 0x0BF9, 0x01F5, 0xFA4B, 0xF32E,
    0xF129, 0xFC95, 0xF8A9, 0xE5AE, 0xDEE6, 0xDC6B, 0xD765, 0xD759, 0xD82A, 0xD4DD, 0xD27B, 0xCCB8, 0xD023, 0xCE22, 0xC9D3, 0xC90B,
    0xCAA9, 0xCF67, 0xD3A4, 0xDAFD, 0xDBC1, 0xDA55, 0xDE2B, 0xE302, 0xEC48, 0xE969, 0xDEAE, 0xF71F, 0x0206, 0xF49E, 0xFB16, 0xFCCB,
    0x08BB, 0x0D5B, 0x092E, 0x042B, 0xF892, 0xF503, 0xEB88, 0xF613, 0xF4B5, 0xE5A0, 0xDCE1, 0xD94B, 0xD927, 0xDC65, 0xE00C, 0xE375,
    0xE8FE, 0xEAD7, 0xF7DE, 0x0247, 0x09AA, 0x0DB2, 0x12C2, 0x18AA, 0x1EF9, 0x255A, 0x247D, 0x1E87, 0x1C0B, 0x1CE4, 0x2848, 0x2B64,
    0x1DC3, 0x363B, 0x4802, 0x3C17, 0x38F7, 0x30FA, 0x366F, 0x35AB, 0x31D8, 0x28B5, 0x1CAA, 0x1400, 0x04BA, 0x0B2D, 0x07DA, 0xF5E7,
    0xE4CB, 0xDAE9, 0xD378, 0xD348, 0xD5CB, 0xD83F, 0xD660, 0xD04D, 0xD294, 0xD338, 0xD601, 0xD660, 0xD664, 0xD5E1, 0xD714, 0xDE16,
    0xE055, 0xDFA3, 0xE2C5, 0xE653, 0xF824, 0x018C, 0xF3F7, 0x03E2, 0x145E, 0x0E88, 0x0A15, 0xFF7E, 0x02E9, 0x06A3, 0x0A90, 0x0389,
    0xFC6C, 0xF87C, 0xEAEE, 0xF0BC, 0xF6D8, 0xF169, 0xE9DD, 0xE49D, 0xE19F, 0xE4F9, 0xE6CB, 0xEA5C, 0xE926, 0xE41D, 0xE2D2, 0xE222,
    0xE30C, 0xE174, 0xE024, 0xE017, 0xE40D, 0xF00F, 0xFA8F, 0x0147, 0x0947, 0x08F5, 0x1945, 0x2954, 0x1CD5, 0x283C, 0x38A8, 0x398B,
    0x31E5, 0x203F, 0x1931, 0x1424, 0x16F5, 0x10F0, 0x0F84, 0x1080, 0x0679, 0x0965, 0x1148, 0x0B64, 0xFB5C, 0xEAD1, 0xDD26, 0xD72F,
    0xD1B2, 0xD12F, 0xD027, 0xCE8B, 0xCF5C, 0xD426, 0xDCD1, 0xE3BA, 0xEB00, 0xF0D4, 0xF2A1, 0xF828, 0xFCE6, 0x006C, 0x05F4, 0xFF68,
    0x0C23, 0x1FC0, 0x16D9, 0x1EE2, 0x30BD, 0x3C51, 0x3B1B, 0x316A, 0x2C46, 0x27C6, 0x2AF8, 0x23B8, 0x215D, 0x1F44, 0x128F, 0x0EE4,
    0x16BA, 0x155D, 0x099B, 0xF935, 0xE8F3, 0xDE10, 0xD699, 0xD5D3, 0xD56D, 0xD5AD, 0xD778, 0xDCB3, 0xE473, 0xE9F7, 0xEE4F, 0xF288,
    0xF41B, 0xFD44, 0x05C8, 0x09FD, 0x0E46, 0x0140, 0x0743, 0x18C7, 0x0FC2, 0x1105, 0x1F52, 0x3238, 0x385B, 0x3624, 0x3296, 0x2E7E,
    0x335E, 0x2EC1, 0x2A4C, 0x246C, 0x1450, 0x09AA, 0x0BE0, 0x0ABA, 0x0437, 0xFB48, 0xF630, 0xF438, 0xF5AB, 0xFC60, 0x0281, 0x0341,
    0xFE38, 0xFC6A, 0xFD07, 0xFD35, 0xFF4E, 0x023E, 0xFED6, 0x0182, 0x04B7, 0x084D, 0x1344, 0x0B41, 0x11C0, 0x27A9, 0x2BDA, 0x2E78,
    0x38DE, 0x4E09, 0x58FF, 0x5C96, 0x563E, 0x4F59, 0x4FFA, 0x4A48, 0x46E0, 0x46A8, 0x3D62, 0x327C, 0x3306, 0x34A5, 0x31C9, 0x261C,
    0x191D, 0x0C47, 0x02A6, 0xFEA8, 0xFCCB, 0xFA95, 0xF589, 0xEF1A, 0xE8FD, 0xE2BE, 0xDE73, 0xDC8F, 0xD652, 0xD8DF, 0xDB73, 0xDD5A,
    0xE74E, 0xDC84, 0xDA6C, 0xE817, 0xEAC7, 0xE5E3, 0xE3E4, 0xEE55, 0xF3A2, 0xF526, 0xED36, 0xE81D, 0xEEE3, 0xF1F9, 0xF593, 0xFDDD,
    0xFD50, 0xF786, 0xF9E4, 0x00A3, 0x0513, 0x0134, 0xFB23, 0xF48C, 0xEF0F, 0xED17, 0xEDA4, 0xED27, 0xE88A, 0xE40C, 0xE48E, 0xE63D,
    0xEBD0, 0xF5C0, 0xFC15, 0x09D0, 0x14D2, 0x222D, 0x3A9D, 0x3B4C, 0x3931, 0x42F5, 0x47E8, 0x412A, 0x3B96, 0x4374, 0x4C19, 0x52DE,
    0x4ED2, 0x471C, 0x4536, 0x41B6, 0x3D51, 0x4007, 0x3D86, 0x34F5, 0x316B, 0x34A0, 0x3759, 0x3202, 0x2703, 0x1781, 0x0791, 0xFBD6,
    0xF75B, 0xF6B6, 0xF3B6, 0xEF7E, 0xECE4, 0xE6DA, 0xE34D, 0xE3D4, 0xDE65, 0xDEAC, 0xD953, 0xD59C, 0xDF4E, 0xD90F, 0xCF2C, 0xD102,
    0xD9E8, 0xD913, 0xD7A6, 0xE042, 0xEC28, 0xFA8F, 0xFE73, 0xFB57, 0xFC6C, 0xFD0E, 0xFBC3, 0xFFA1, 0xFE30, 0xF5B7, 0xED1E, 0xEC06,
    0xEE76, 0xED1F, 0xE838, 0xE034, 0xDA16, 0xD75D, 0xDC58, 0xE5FC, 0xECF8, 0xF29B, 0xFB7B, 0x02F4, 0x0AD6, 0x13D4, 0x12E2, 0x16EB,
    0x158A, 0x14C9, 0x22A6, 0x24A3, 0x1DEE, 0x1DC5, 0x27CC, 0x27B9, 0x23ED, 0x2885, 0x3334, 0x423A, 0x4736, 0x428F, 0x3EFA, 0x38F8,
    0x2D40, 0x268B, 0x2012, 0x133A, 0x0514, 0xFFB1, 0x02FE, 0x051B, 0x0191, 0xF7BE, 0xEB86, 0xDF9D, 0xD6C9, 0xD40C, 0xD042, 0xCAB6,
    0xC991, 0xC680, 0xC6C8, 0xCAD5, 0xCC04, 0xD76E, 0xDC21, 0xDEB6, 0xED58, 0xF74B, 0xF528, 0xF301, 0xFDF2, 0x02B0, 0xFFC7, 0xFF8A,
    0x04EE, 0x11C1, 0x18EA, 0x142F, 0x0F94, 0x080E, 0xFDB7, 0xFA14, 0xFC0B, 0xF921, 0xF0CF, 0xED28, 0xF14F, 0xF917, 0xFCAA, 0xFB0E,
    0xF34C, 0xE847, 0xDE96, 0xDB51, 0xDAEA, 0xD819, 0xD90D, 0xD49C, 0xD461, 0xD8B7, 0xD518, 0xDA9B, 0xDBC3, 0xDBB7, 0xE87F, 0xF912,
    0xFD85, 0xFE08, 0x091A, 0x10B3, 0x10AA, 0x0D24, 0x0CC2, 0x15A4, 0x1F22, 0x1E3E, 0x1DCE, 0x1DF2, 0x1B3D, 0x19B8, 0x1DF3, 0x1EF5,
    0x17A2, 0x1140, 0x0F7C, 0x11AA, 0x0E2D, 0x0395, 0xF5E7, 0xE772, 0xDBE1, 0xD9B1, 0xDC59, 0xDC44, 0xE15C, 0xE1D1, 0xE499, 0xE9B2,
    0xE7BE, 0xEEFA, 0xF24F, 0xEF42, 0xF4EA, 0x03D8, 0x067F, 0x007E, 0x0485, 0x0A76, 0x0A99, 0x0668, 0x03ED, 0x0D73, 0x1D81, 0x24E0,
    0x2A49, 0x2E53, 0x2C96, 0x2935, 0x2B9E, 0x2C7A, 0x23A9, 0x17C6, 0x0F80, 0x0D30, 0x0BDF, 0x0595, 0xFB36, 0xED37, 0xDCF0, 0xD451,
    0xD08D, 0xCE59, 0xD383, 0xD32F, 0xD511, 0xD949, 0xD69A, 0xD96D, 0xDA12, 0xD44C, 0xD2F9, 0xDD90, 0xE22B, 0xDDF3, 0xE12B, 0xE7CD,
    0xED49, 0xEF38, 0xEEDB, 0xF97B, 0x0BDC, 0x17D5, 0x1DB7, 0x1FEE, 0x1B98, 0x13B9, 0x1276, 0x14BA, 0x1202, 0x0ACF, 0x0680, 0x079B,
    0x0C94, 0x0FF3, 0x0EC0, 0x08DE, 0xFD91, 0xFA73, 0xFC29, 0xFD86, 0x03B8, 0x01BE, 0x00CC, 0xFFB1, 0xF879, 0xF652, 0xF3AB, 0xE8B4,
    0xDF3C, 0xE82C, 0xF303, 0xF5A7, 0xFDBA, 0x0A60, 0x1749, 0x1E4D, 0x1D10, 0x2114, 0x2E34, 0x38FE, 0x3E1E, 0x41F9, 0x41D8, 0x3D22,
    0x3A11, 0x37B0, 0x316B, 0x25DB, 0x19A2, 0x13FC, 0x14FE, 0x1643, 0x14E9, 0x0F19, 0xFEA6, 0xF1C5, 0xE985, 0xE2F5, 0xE163, 0xD984,
    0xD44C, 0xD09F, 0xC907, 0xC5A8, 0xC795, 0xC364, 0xBD6E, 0xC50D, 0xCF20, 0xCDDB, 0xCA5B, 0xC9B9, 0xCB83, 0xCBA1, 0xC4CF, 0xC41A,
    0xCDD7, 0xD9A9, 0xE1A8, 0xE82E, 0xEB43, 0xE7D4, 0xE739, 0xEAA7, 0xED32, 0xEC77, 0xEA78, 0xEC86, 0xF440, 0xFC5C, 0x027A, 0x0479,
    0xF8E3, 0xED16, 0xE198, 0xD840, 0xD75B, 0xD427, 0xD544, 0xDA1C, 0xDFB7, 0xE7D8, 0xF74B, 0x0094, 0x007E, 0x0B02, 0x1BE2, 0x2450,
    0x2735, 0x2A89, 0x30BF, 0x36CF, 0x324B, 0x2BC2, 0x2F50, 0x3833, 0x3E92, 0x43C7, 0x473D, 0x4213, 0x38E8, 0x3434, 0x316A, 0x2B24,
    0x2211, 0x1C42, 0x206B, 0x26F3, 0x2B0B, 0x2994, 0x1C70, 0x1073, 0x0310, 0xF942, 0xF702, 0xF0B8, 0xEA75, 0xE63F, 0xE000, 0xD75C,
    0xD581, 0xD0DD, 0xC339, 0xBE44, 0xC305, 0xC616, 0xC710, 0xC75D, 0xCCDB, 0xD416, 0xD44E, 0xD185, 0xD6A3, 0xE36F, 0xEE43, 0xF911,
    0x0172, 0x0353, 0x0222, 0x0376, 0x0743, 0x0511, 0xFA96, 0xEDE4, 0xE8BE, 0xE76D, 0xEB1A, 0xF286, 0xF2BF, 0xF2DF, 0xEFD3, 0xEC84,
    0xEF60, 0xF26C, 0xF56A, 0xFD09, 0x02C1, 0x0404, 0x0B92, 0x127C, 0x0B1F, 0x03E5, 0x077D, 0x0B61, 0x0DFB, 0x0E7E, 0x1486, 0x20ED,
    0x27F8, 0x2721, 0x277C, 0x2F22, 0x35DF, 0x3CD0, 0x42BC, 0x41EF, 0x3B18, 0x323E, 0x2D33, 0x28D8, 0x200E, 0x13A4, 0x0E3B, 0x0C17,
    0x0E91, 0x10C5, 0x0915, 0xFE44, 0xEDA0, 0xDD0E, 0xD36F, 0xCD6A, 0xC6F5, 0xC6FF, 0xC8A8, 0xC670, 0xCC84, 0xD6AB, 0xD79B, 0xD578,
    0xD9F8, 0xE2B8, 0xE9E1, 0xED6B, 0xF314, 0xFFFA, 0x0A12, 0x0791, 0x02D4, 0x04B6, 0x068E, 0x068B, 0x078B, 0x074E, 0x040D, 0x0164,
    0x03FE, 0x0AF5, 0x0E06, 0x09C1, 0x089D, 0x0776, 0x0DCA, 0x18CF, 0x1BE6, 0x191C, 0x0E97, 0x00CA, 0xF541, 0xED3A, 0xE549, 0xE292,
    0xE2F6, 0xDEB9, 0xDFE1, 0xE7FF, 0xE7CD, 0xE2CF, 0xE44E, 0xED88, 0xF83A, 0xFD6D, 0x0013, 0x06FD, 0x0EF0, 0x0C03, 0x036E, 0xFFB5,
    0x01AA, 0x074D, 0x0F8F, 0x16C4, 0x18BC, 0x1745, 0x1536, 0x162A, 0x13D1, 0x0AB6, 0x030E, 0xFAC1, 0xF7CF, 0xFB28, 0xFBAB, 0xFB08,
    0xF5ED, 0xEC03, 0xE68B, 0xE4C6, 0xE13E, 0xE1F6, 0xE908, 0xEB50, 0xF011, 0xFD52, 0x02E9, 0xFFC1, 0xFC30, 0xFDF3, 0x013E, 0xFFAB,
    0xFC00, 0xFF47, 0x0A65, 0x0FA1, 0x0F37, 0x1209, 0x1867, 0x21CF, 0x2E87, 0x39E3, 0x3EA7, 0x3FB7, 0x4032, 0x447A, 0x4426, 0x39CA,
    0x2D7D, 0x1D0C, 0x1156, 0x0DAC, 0x0C81, 0x0AB7, 0x0359, 0xF590, 0xE941, 0xE2D5, 0xDB87, 0xD7FE, 0xD9CB, 0xD6B9, 0xD2C5, 0xD635,
    0xD855, 0xD33A, 0xCC96, 0xCAA8, 0xCECA, 0xD201, 0xD11C, 0xD41D, 0xDF0B, 0xE53E, 0xE14F, 0xDD9C, 0xDE09, 0xE2C2, 0xEBD6, 0xF5D1,
    0xFC14, 0xFD51, 0xFD38, 0x02B1, 0x0782, 0x062B, 0x0280, 0xFC40, 0xF964, 0xFD4E, 0x046C, 0x0C38, 0x1133, 0x1017, 0x0D18, 0x0DA1,
    0x09A3, 0x02E7, 0x00BA, 0xF931, 0xEFEB, 0xF09B, 0xF5BB, 0xF4D1, 0xF084, 0xF14A, 0xF989, 0x0436, 0x0978, 0x105A, 0x1F74, 0x2D70,
    0x341B, 0x36D6, 0x3981, 0x3ACE, 0x3F4C, 0x45F0, 0x4A82, 0x4C2E, 0x4840, 0x4838, 0x4954, 0x467E, 0x413F, 0x3740, 0x2D84, 0x282B,
    0x25FC, 0x24E2, 0x219C, 0x1673, 0x062C, 0xF9DA, 0xEC97, 0xDEE7, 0xD9FB, 0xD4A8, 0xCD53, 0xCB32, 0xCD46, 0xCBB5, 0xC38C, 0xBC96,
    0xBB15, 0xBBE2, 0xB7A6, 0xB283, 0xB56E, 0xBAC8, 0xBBE1, 0xBAC1, 0xBBA6, 0xBE5D, 0xC4D2, 0xCE8B, 0xD94E, 0xE15F, 0xE43F, 0xEB2E,
    0xF473, 0xFC20, 0x0105, 0xFFC8, 0xFB4E, 0xF8E9, 0xF8ED, 0xFB87, 0xFF3A, 0xFBE7, 0xF310, 0xECCB, 0xE634, 0xDE16, 0xDE53, 0xE1BF,
    0xE328, 0xEA84, 0xF90B, 0x0665, 0x0CDA, 0x0F57, 0x13A9, 0x1BCA, 0x1FCF, 0x1EC4, 0x22DE, 0x2BBC, 0x3086, 0x309A, 0x304B, 0x310B,
    0x35B0, 0x3BD1, 0x4475, 0x4B75, 0x4AEC, 0x4A2D, 0x4A65, 0x49AE, 0x4736, 0x3FF5, 0x357B, 0x2E00, 0x2A9E, 0x29EF, 0x2CC8, 0x2ABA,
    0x2046, 0x1745, 0x0C43, 0xFD5A, 0xF2C3, 0xEADC, 0xDECC, 0xD3C3, 0xD1B9, 0xD314, 0xD041, 0xC863, 0xC25A, 0xC3A6, 0xC4E9, 0xC142,
    0xC0E3, 0xC83A, 0xD040, 0xD705, 0xDC7B, 0xDFDD, 0xE5F7, 0xEC9A, 0xF6A7, 0xFF47, 0xFF8E, 0xFD86, 0xFCF0, 0xFE6A, 0xFF74, 0xFC1E,
    0xF3B6, 0xEBCD, 0xE795, 0xE836, 0xF03C, 0xF91D, 0xFC0E, 0xFF20, 0xFFED, 0xFC6D, 0xFC83, 0x0032, 0x00E0, 0xFE08, 0x010D, 0x07DA,
    0x0B43, 0x07F3, 0x01C7, 0x043F, 0x091F, 0x095C, 0x0B12, 0x15A7, 0x21E2, 0x2916, 0x2D08, 0x2D38, 0x2E16, 0x2EFB, 0x3441, 0x3BAF,
    0x3C27, 0x38F8, 0x3675, 0x362C, 0x37EE, 0x35D8, 0x2D7F, 0x21E4, 0x161F, 0x0B54, 0x0636, 0x01C7, 0xF59E, 0xEB15, 0xE2B6, 0xD790,
    0xD088, 0xCFFC, 0xCD52, 0xC862, 0xC763, 0xCDD5, 0xD6AB, 0xDC47, 0xDEE4, 0xE56E, 0xEED1, 0xF160, 0xF13B, 0xF50B, 0xFA95, 0xFE3E,
    0xFED8, 0xFCD5, 0xFA94, 0xF9DB, 0xFDCC, 0x04ED, 0x0893, 0x096B, 0x0C75, 0x11D6, 0x1AAA, 0x2237, 0x2219, 0x1D88, 0x173A, 0x1113,
    0x11F7, 0x1688, 0x154C, 0x1256, 0x0BC2, 0xFD84, 0xF02A, 0xE9BB, 0xE462, 0xDBF5, 0xD71C, 0xD940, 0xDF7A, 0xE229, 0xDF3A, 0xDF4B,
    0xE48C, 0xE7AC, 0xE7F0, 0xEC8F, 0xF498, 0xFE00, 0x04E6, 0x06D9, 0x07C9, 0x06CE, 0x07B8, 0x0DBB, 0x116C, 0x100F, 0x0C63, 0x0978,
    0x0AD4, 0x0E37, 0x0C85, 0x063E, 0x001A, 0xF84C, 0xF51C, 0xF783, 0xF7D5, 0xF862, 0xFA15, 0xF815, 0xF504, 0xF747, 0xF977, 0xF7A3,
    0xF4E2, 0xF40F, 0xF8E1, 0xFBB6, 0xF80C, 0xF3B7, 0xF594, 0xF726, 0xF3B7, 0xF44F, 0xF9DE, 0x049F, 0x0EB2, 0x168D, 0x1E3C, 0x2419,
    0x2BFC, 0x37BD, 0x4281, 0x4730, 0x47E6, 0x4693, 0x45EA, 0x4661, 0x4271, 0x3A13, 0x2F5B, 0x219C, 0x1913, 0x19C0, 0x18A8, 0x145B,
    0x0F15, 0x046E, 0xF680, 0xEC20, 0xE539, 0xDC71, 0xD361, 0xCEE0, 0xD1A1, 0xD581, 0xD29A, 0xCE49, 0xD0AF, 0xD3C5, 0xD12C, 0xCE05,
    0xCCE7, 0xCDBD, 0xCE0B, 0xCD61, 0xCDE4, 0xCD5F, 0xCF5B, 0xD7B7, 0xE16A, 0xE8C9, 0xEC77, 0xEF05, 0xF31C, 0xFC15, 0x05F8, 0x0C8A,
    0x1030, 0x0E0F, 0x0E0E, 0x142C, 0x19DD, 0x1DB1, 0x2311, 0x23E7, 0x1C68, 0x1639, 0x12BF, 0x0CEF, 0x0210, 0xF7E7, 0xF704, 0xFC37,
    0xFD71, 0xFB9C, 0x0170, 0x0B07, 0x11F0, 0x1652, 0x1A94, 0x2228, 0x297B, 0x2E7D, 0x319F, 0x30F2, 0x2F69, 0x322C, 0x38A0, 0x3F07,
    0x43CB, 0x456A, 0x45CF, 0x4929, 0x4C05, 0x4B1B, 0x46FF, 0x3D66, 0x328E, 0x2D4B, 0x29BD, 0x24A8, 0x2142, 0x1B37, 0x0E80, 0x026E,
    0xFB06, 0xF409, 0xE923, 0xDBED, 0xD254, 0xCEE6, 0xCA25, 0xC1A2, 0xBCE9, 0xBBCE, 0xBB44, 0xB946, 0xB681, 0xB6A5, 0xB80D, 0xB957,
    0xBC14, 0xBE56, 0xC0D3, 0xC65F, 0xD01F, 0xDB3E, 0xE435, 0xE8FB, 0xEBCF, 0xF31F, 0xFB58, 0x00EA, 0x0543, 0x0336, 0xFC0A, 0xF85F,
    0xF7B1, 0xF5EF, 0xF50E, 0xF51C, 0xEF92, 0xE9AD, 0xE89B, 0xEAE8, 0xEE46, 0xECC7, 0xEDB1, 0xF757, 0x02A9, 0x0799, 0x0A71, 0x0F9A,
    0x13C9, 0x1433, 0x134F, 0x180C, 0x1FCB, 0x26D1, 0x2E1F, 0x32F4, 0x335C, 0x344B, 0x3910, 0x3EE5, 0x4443, 0x458A, 0x4414, 0x4451,
    0x44FA, 0x4607, 0x47DE, 0x44C1, 0x3C4F, 0x36A6, 0x33DA, 0x2EB2, 0x2931, 0x235E, 0x17F3, 0x0897, 0xFC54, 0xF540, 0xEF96, 0xE501,
    0xD83B, 0xD23C, 0xD012, 0xCAEF, 0xC5EB, 0xC60B, 0xCA51, 0xCDDA, 0xCF42, 0xD3A6, 0xDB2F, 0xE180, 0xE7BF, 0xED06, 0xEE7A, 0xEE87,
    0xF1C6, 0xF895, 0xFF10, 0x001C, 0xFCFF, 0xFC9B, 0xFDB2, 0xFF5A, 0x03C9, 0x0485, 0xFE21, 0xF912, 0xF9DF, 0xFC5C, 0x0131, 0x0963,
    0x0E4D, 0x0C41, 0x0797, 0x069B, 0x069F, 0x01EA, 0xFABF, 0xFBFF, 0x02E8, 0x052C, 0x047A, 0x04D6, 0x0879, 0x0A17, 0x0896, 0x086B,
    0x0AAC, 0x0D9E, 0x1154, 0x15CD, 0x1669, 0x16EC, 0x1C13, 0x24B7, 0x2FFB, 0x3730, 0x3683, 0x33F7, 0x30E6, 0x2DFC, 0x2CFA, 0x2939,
    0x1E8D, 0x115A, 0x08F8, 0xFFC0, 0xF7AC, 0xF2D6, 0xEC2B, 0xE291, 0xD88E, 0xD3EA, 0xD480, 0xD4D1, 0xD176, 0xD191, 0xD886, 0xDF35,
    0xE264, 0xE558, 0xEB70, 0xF2A3, 0xF475, 0xF2B0, 0xF20C, 0xF22C, 0xF30E, 0xF543, 0xF69E, 0xF5DE, 0xF646, 0xF9CD, 0x01EB, 0x0BF2,
    0x12E5, 0x1A1E, 0x22DD, 0x2911, 0x2F93, 0x34C1, 0x314C, 0x2921, 0x2333, 0x1E4A, 0x1AF8, 0x1BE0, 0x1D9A, 0x19BF, 0x118E, 0x09DB,
    0x0520, 0x003B, 0xF462, 0xE8AD, 0xE416, 0xE0F2, 0xDBF6, 0xD656, 0xD591, 0xDA2F, 0xDF3D, 0xE3DD, 0xE8B3, 0xEE04, 0xF26F, 0xF4FC,
    0xF329, 0xEE60, 0xEAAA, 0xE904, 0xEDBE, 0xF548, 0xF870, 0xF802, 0xF650, 0xF3C2, 0xF39E, 0xF79E, 0xF79A, 0xF394, 0xF0AC, 0xEF9C,
    0xF153, 0xF727, 0xFEC5, 0x0327, 0x037E, 0x0198, 0x0353, 0x05F3, 0x00CD, 0xF7F1, 0xF4D1, 0xF5F4, 0xF4CF, 0xF160, 0xEFA1, 0xF14A,
    0xF33D, 0xF46B, 0xF7F3, 0xFD16, 0x04C4, 0x114A, 0x1E2C, 0x277E, 0x2D30, 0x30B0, 0x364F, 0x3D68, 0x4068, 0x3FC6, 0x3F86, 0x3EE2,
    0x3EEE, 0x4265, 0x41A9, 0x3BE2, 0x3562, 0x2D54, 0x248D, 0x1CDE, 0x185C, 0x11AB, 0x05C3, 0xF7E9, 0xEEC5, 0xEC4F, 0xE6E9, 0xDF36,
    0xDBFD, 0xDC85, 0xDB29, 0xD4D3, 0xCE4E, 0xCBCB, 0xCA66, 0xC845, 0xC61C, 0xC3AE, 0xC24F, 0xC2F9, 0xC440, 0xC3B9, 0xC270, 0xC1FA,
    0xC675, 0xD0DB, 0xDB4F, 0xE35D, 0xEB1A, 0xF11D, 0xF7A4, 0x0318, 0x0E77, 0x1319, 0x1365, 0x136F, 0x1357, 0x14DA, 0x1838, 0x1AF1,
    0x196F, 0x11BD, 0x0A20, 0x086C, 0x0461, 0xFBB5, 0xF665, 0xF88F, 0xFE49, 0x008C, 0x0268, 0x07A0, 0x0E51, 0x128E, 0x15B4, 0x1851,
    0x1A67, 0x1FED, 0x25BD, 0x28CF, 0x2A18, 0x2993, 0x2C7C, 0x34F9, 0x3E96, 0x451A, 0x486E, 0x4858, 0x4511, 0x4533, 0x45DB, 0x414F,
    0x3B8B, 0x3712, 0x325F, 0x2DFB, 0x2B1F, 0x286A, 0x233A, 0x16F9, 0x0855, 0xFE26, 0xF4BF, 0xE726, 0xD9A8, 0xD1C0, 0xCCAE, 0xC526,
    0xBB34, 0xB531, 0xB1BF, 0xAE9F, 0xAC4E, 0xABB6, 0xAD05, 0xB07C, 0xB6BB, 0xBD8C, 0xC412, 0xC879, 0xCD72, 0xD6EE, 0xE141, 0xE790,
    0xED94, 0xF159, 0xF355, 0xF8D8, 0xFFAE, 0x03C3, 0x02F4, 0x01A8, 0xFF97, 0xFCD9, 0xFCEB, 0x000A, 0x0480, 0x034F, 0xFE79, 0xFEB1,
    0x0084, 0xFF2E, 0xFA83, 0xF8C4, 0xFBA3, 0xFD51, 0xFD66, 0xFE58, 0x0293, 0x0744, 0x0C66, 0x11E4, 0x1578, 0x1B14, 0x2158, 0x25AA,
    0x2785, 0x237C, 0x1EDC, 0x2000, 0x270B, 0x2F03, 0x362E, 0x3AF3, 0x3A89, 0x3C33, 0x3FED, 0x4101, 0x3E62, 0x3976, 0x3391, 0x2D96,
    0x2825, 0x24B1, 0x2195, 0x17FC, 0x08A4, 0xFB0B, 0xF0DA, 0xE55F, 0xD82C, 0xCE21, 0xCB26, 0xCB01, 0xC93D, 0xC881, 0xCAA6, 0xCEBB,
    0xD2D3, 0xD6E4, 0xD875, 0xDA41, 0xDCF0, 0xDFC1, 0xE316, 0xE29E, 0xDFD3, 0xE067, 0xE48E, 0xE8EC, 0xEE07, 0xF2EA, 0xF476, 0xF6D7,
    0xFFE8, 0x0920, 0x0D41, 0x0D4F, 0x0BF5, 0x0ABA, 0x0969, 0x0B5E, 0x10D8, 0x1387, 0x0F77, 0x0C39, 0x0E30, 0x1047, 0x0ED6, 0x0D7D,
    0x0FF9, 0x1334, 0x11B6, 0x0D8E, 0x09E7, 0x058A, 0x0281, 0x00F2, 0xFFCF, 0x01AA, 0x0717, 0x0EE3, 0x15E1, 0x181E, 0x160C, 0x14DD,
    0x1727, 0x1AFF, 0x2190, 0x2778, 0x2804, 0x2522, 0x234A, 0x217C, 0x1AAA, 0x1180, 0x0609, 0xF9E4, 0xEE7E, 0xE68F, 0xE5A6, 0xE4EB,
    0xDF10, 0xD7A4, 0xD66F, 0xD81C, 0xD7F2, 0xD697, 0xD86B, 0xDE35, 0xE134, 0xE165, 0xE0EC, 0xE0B8, 0xE231, 0xE3CB, 0xE38E, 0xE317,
    0xE41E, 0xE7B7, 0xED91, 0xF2D0, 0xF45E, 0xF565, 0xFB2E, 0x03CD, 0x0E92, 0x19CD, 0x202D, 0x2374, 0x2844, 0x2DA4, 0x3105, 0x3099,
    0x2D9F, 0x29DD, 0x26B1, 0x2605, 0x2AD2, 0x302E, 0x2CE1, 0x235F, 0x199C, 0x10EF, 0x05AF, 0xF76B, 0xED55, 0xEA46, 0xE8AC, 0xE6DE,
    0xE586, 0xE38F, 0xE27E, 0xE2A6, 0xE3D7, 0xE517, 0xE6DA, 0xE9A8, 0xEE5C, 0xF1CB, 0xEE88, 0xE8E5, 0xE619, 0xE494, 0xE4BB, 0xE848,
    0xEA59, 0xE8DC, 0xE8AD, 0xEC43, 0xF102, 0xF48C, 0xF62F, 0xF75C, 0xF7E8, 0xF810, 0xFDEB, 0x06F1, 0x0AC5, 0x07D2, 0x04B6, 0x0464,
    0x00C9, 0xF83C, 0xEEDD, 0xEA15, 0xE724, 0xE37D, 0xE1AE, 0xE184, 0xE47C, 0xEA86, 0xF0A9, 0xF64A, 0xFC6E, 0x0455, 0x1020, 0x1CC5,
    0x23CB, 0x2561, 0x2695, 0x28E0, 0x2E99, 0x3923, 0x42DD, 0x47B9, 0x4B42, 0x4EE0, 0x51B4, 0x5167, 0x4CC1, 0x4532, 0x3A87, 0x2F35,
    0x2837, 0x2754, 0x2565, 0x1C7E, 0x11B5, 0x096D, 0x01F4, 0xF783, 0xEC47, 0xE5ED, 0xE236, 0xDEE1, 0xDAD6, 0xD4E3, 0xCE54, 0xC7BE,
    0xC1FC, 0xBB36, 0xB582, 0xB2FE, 0xB26A, 0xB4E2, 0xB6F2, 0xB7CA, 0xBAD0, 0xBEEB, 0xC70E, 0xD3EE, 0xE1FD, 0xED5B, 0xF58E, 0xFF24,
    0x0945, 0x11EA, 0x1721, 0x1A01, 0x1977, 0x14C8, 0x128B, 0x15FA, 0x1A16, 0x18B8, 0x13BD, 0x115E, 0x1210, 0x1161, 0x0E9E, 0x0CA8,
    0x0DB6, 0x0FF7, 0x11F7, 0x1128, 0x0EEF, 0x0ED6, 0x0FFA, 0x1022, 0x104D, 0x1156, 0x15B0, 0x1FBA, 0x28A0, 0x2CA7, 0x2CFB, 0x2C4B,
    0x2BA0, 0x2F2F, 0x3570, 0x387E, 0x3A24, 0x3B3A, 0x3DE6, 0x409C, 0x3FB2, 0x3BE1, 0x361D, 0x2DD6, 0x26B4, 0x24FE, 0x2686, 0x24B2,
    0x1BD8, 0x1180, 0x09B4, 0xFF5C, 0xEFE1, 0xE14D, 0xD5C2, 0xCB21, 0xC16C, 0xB903, 0xB33F, 0xAFBD, 0xAE29, 0xAE92, 0xB083, 0xB2F3,
    0xB686, 0xBD32, 0xC5B3, 0xCC08, 0xD0FA, 0xD49B, 0xD691, 0xDA5B, 0xE024, 0xE4E3, 0xE671, 0xE831, 0xECD2, 0xF297, 0xF811, 0xFCA8,
    0x0009, 0xFEC4, 0xFB49, 0xFD30, 0x0410, 0x0A5C, 0x0B49, 0x0984, 0x09BE, 0x0862, 0x0328, 0xFD60, 0xFB08, 0xFCE3, 0x0156, 0x0714,
    0x0C04, 0x108C, 0x148B, 0x15E4, 0x1610, 0x153E, 0x1480, 0x19A9, 0x212A, 0x2600, 0x27D0, 0x274A, 0x2459, 0x22C3, 0x26C9, 0x2B80,
    0x2F6E, 0x31DE, 0x34C7, 0x3942, 0x3B06, 0x3B0D, 0x3883, 0x3225, 0x2829, 0x1ED2, 0x1A87, 0x174C, 0x0F4C, 0x0424, 0xFB5F, 0xF402,
    0xEA7F, 0xE041, 0xD8B7, 0xD3E0, 0xD1A6, 0xD0E2, 0xD097, 0xD2A4, 0xD5DC, 0xD9AB, 0xDCF9, 0xDE28, 0xDD8D, 0xDE57, 0xE165, 0xE2BD,
    0xE2FA, 0xE224, 0xDFA3, 0xDEDD, 0xE3F9, 0xEC80, 0xF4A6, 0xFBDB, 0x0398, 0x0D4C, 0x14FA, 0x1984, 0x1C32, 0x1B3B, 0x14BF, 0x0D5B,
    0x0CC9, 0x122F, 0x1717, 0x189F, 0x1AB5, 0x1EB7, 0x1DB6, 0x178E, 0x108B, 0x0BDC, 0x09C8, 0x0790, 0x059E, 0x0429, 0x028E, 0x0021,
    0xFEA5, 0xFD7F, 0xFB7B, 0xFC7C, 0x02F3, 0x0A56, 0x0F09, 0x1194, 0x1109, 0x0F99, 0x108E, 0x1481, 0x191C, 0x1A13, 0x1834, 0x17A1,
    0x178B, 0x1526, 0x110B, 0x0B3B, 0x0086, 0xF43C, 0xEDFB, 0xEE87, 0xEF39, 0xEC39, 0xEA19, 0xECA0, 0xEF1A, 0xED05, 0xE8FE, 0xE4B4,
    0xE17F, 0xE017, 0xDE94, 0xDD07, 0xDB76, 0xD9EB, 0xD9F9, 0xDA6D, 0xD96C, 0xD8BB, 0xDD9B, 0xE657, 0xEFC3, 0xF96D, 0xFE0D, 0xFED9,
    0x0079, 0x0584, 0x0CE6, 0x1238, 0x16B9, 0x1DCD, 0x2773, 0x30C4, 0x386E, 0x3D75, 0x3BCF, 0x33FC, 0x2D8C, 0x2CA2, 0x2DCB, 0x2AC3,
    0x24FD, 0x206A, 0x1A1A, 0x1016, 0x035A, 0xF680, 0xEDD1, 0xE91C, 0xE5EA, 0xE2F2, 0xE0CA, 0xE02A, 0xE03B, 0xE070, 0xDE30, 0xDBBC,
    0xDCDF, 0xDE21, 0xDFC6, 0xE04E, 0xDD40, 0xD770, 0xD240, 0xD18B, 0xD4E0, 0xD88B, 0xDB2F, 0xDFB0, 0xE688, 0xEEB6, 0xF797, 0x0121,
    0x06C2, 0x06C0, 0x058A, 0x07A8, 0x0C84, 0x0CE6, 0x0A1A, 0x0797, 0x04EF, 0xFFC8, 0xF72D, 0xEDEC, 0xE6E2, 0xE53B, 0xE629, 0xE7FA,
    0xEAC1, 0xEE00, 0xF27E, 0xF6A1, 0xF772, 0xF626, 0xF7E0, 0xFDC6, 0x0661, 0x1156, 0x1B03, 0x2097, 0x2400, 0x2848, 0x2EF8, 0x357A,
    0x3940, 0x3D23, 0x41D2, 0x457E, 0x4855, 0x49F0, 0x4705, 0x3D9A, 0x30B3, 0x2692, 0x20F2, 0x1B73, 0x13FF, 0x0D99, 0x08E1, 0x036F,
    0xFBEB, 0xF23C, 0xE942, 0xE217, 0xDC92, 0xD6CF, 0xCF63, 0xC7C5, 0xC0AE, 0xBBD8, 0xB691, 0xB080, 0xAD6E, 0xAC5E, 0xAE76, 0xB323,
    0xB8C0, 0xBD49, 0xC0D8, 0xC86A, 0xD49E, 0xE16A, 0xEACC, 0xF240, 0xF9EA, 0xFFCB, 0x04C7, 0x0A91, 0x0E74, 0x0D05, 0x0672, 0x0215,
    0x0401, 0x065E, 0x0729, 0x08B4, 0x0C12, 0x1019, 0x10F4, 0x0F4A, 0x0AED, 0x05EC, 0x02FB, 0x01AE, 0x02EB, 0x04CB, 0x0816, 0x0D39,
    0x1060, 0x0FAF, 0x0E8C, 0x1035, 0x1541, 0x1D0E, 0x23E4, 0x266A, 0x260B, 0x2684, 0x2962, 0x2E40, 0x32C1, 0x34B3, 0x3623, 0x37AA,
    0x38E6, 0x3B2E, 0x3CFF, 0x3B85, 0x33B9, 0x299B, 0x243E, 0x21BE, 0x1CE7, 0x150B, 0x0D0B, 0x053B, 0xFAD6, 0xECAD, 0xDC7B, 0xCE6C,
    0xC31E, 0xBA8D, 0xB577, 0xB0F8, 0xAD97, 0xAE24, 0xB131, 0xB383, 0xB54D, 0xB860, 0xBCB9, 0xC292, 0xC98F, 0xCE9F, 0xCF5C, 0xCDCF,
    0xCD7E, 0xCFF8, 0xD285, 0xD3F5, 0xD7EA, 0xDE5C, 0xE6C6, 0xF13F, 0xFDDA, 0x0929, 0x0C85, 0x0945, 0x0710, 0x07D6, 0x0864, 0x0841,
    0x095D, 0x0CFA, 0x1118, 0x12BC, 0x10DC, 0x0D7D, 0x0A80, 0x080A, 0x080A, 0x0819, 0x07CA, 0x09CB, 0x0C93, 0x0C9F, 0x0A57, 0x092E,
    0x0987, 0x0BBE, 0x1014, 0x13CA, 0x13EB, 0x10D1, 0x0EB0, 0x110B, 0x152D, 0x185C, 0x1CAF, 0x2194, 0x248B, 0x2622, 0x2882, 0x2A54,
    0x263D, 0x1CDC, 0x141D, 0x0EB5, 0x0A15, 0x037E, 0xFD3B, 0xF850, 0xF429, 0xEFBC, 0xEA78, 0xE652, 0xE213, 0xDE92, 0xDDA1, 0xDDC6,
    0xDDB7, 0xDE06, 0xDF05, 0xDDD2, 0xD906, 0xD327, 0xCEAA, 0xCD3C, 0xD052, 0xD65F, 0xDC8D, 0xE14D, 0xE598, 0xEC45, 0xF485, 0xFB73,
    0x004F, 0x0458, 0x07D0, 0x0B28, 0x12D6, 0x1D24, 0x22B3, 0x2065, 0x1B8E, 0x1B60, 0x1DFC, 0x2097, 0x224D, 0x2409, 0x2706, 0x289E,
    0x25BF, 0x1F2A, 0x17FA, 0x1109, 0x0BB8, 0x076E, 0x0269, 0xFE2D, 0xFC1C, 0xFACD, 0xF7A9, 0xF4F7, 0xF3CD, 0xF48F, 0xF85A, 0xFDD4,
    0x02E9, 0x03B7, 0x01D9, 0x010D, 0x01E6, 0x0255, 0x0168, 0x002B, 0xFE15, 0xFBDA, 0xFB63, 0xFE63, 0x00A3, 0xFC58, 0xF4C6, 0xF0C5,
    0xF148, 0xF2A0, 0xF3DF, 0xF606, 0xF890, 0xFA00, 0xF810, 0xF410, 0xEDFD, 0xE5F3, 0xDFF4, 0xDCD8, 0xDB9E, 0xDB9F, 0xDF83, 0xE5D8,
    0xE9EC, 0xEC3B, 0xEDE9, 0xEECE, 0xF0AC, 0xF5E6, 0xFD33, 0x021A, 0x0457, 0x085D, 0x0E83, 0x1453, 0x180F, 0x1BDB, 0x2126, 0x24BB,
    0x2994, 0x32B3, 0x3CEB, 0x4092, 0x3C7D, 0x3843, 0x35E6, 0x334A, 0x2EBF, 0x2879, 0x218F, 0x1A4E, 0x1239, 0x0850, 0xFDC3, 0xF40F,
    0xEC1A, 0xE7BF, 0xE41F, 0xE0C4, 0xE089, 0xE12B, 0xE026, 0xDDDB, 0xDAEC, 0xD791, 0xD47F, 0xD309, 0xD3DC, 0xD2E8, 0xCEE1, 0xCBA2,
    0xCC0B, 0xCDD5, 0xCFCB, 0xD58C, 0xDE0E, 0xE573, 0xEC7C, 0xF7EF, 0x06E8, 0x105B, 0x0FD1, 0x0B5F, 0x077D, 0x035C, 0xFC78, 0xF4A8,
    0xF0D4, 0xF1D8, 0xF40C, 0xF510, 0xF471, 0xF2B3, 0xF168, 0xF21A, 0xF219, 0xEF32, 0xEF7C, 0xF312, 0xF6AB, 0xFA6F, 0xFE00, 0x00E2,
    0x04A1, 0x0BE3, 0x1607, 0x1F8A, 0x25D9, 0x2ADE, 0x2F3A, 0x3378, 0x376D, 0x3C5D, 0x4106, 0x438D, 0x4542, 0x47FF, 0x4C48, 0x4E02,
    0x49F2, 0x411E, 0x37EE, 0x30DC, 0x2A45, 0x22D6, 0x1C5C, 0x1780, 0x1158, 0x095B, 0x00E8, 0xF7B3, 0xED6E, 0xE37F, 0xD993, 0xCF12,
    0xC56B, 0xBEAE, 0xB949, 0xB529, 0xB1E7, 0xAF17, 0xAD72, 0xAE6B, 0xB322, 0xB9E7, 0xC027, 0xC4EB, 0xCB69, 0xD363, 0xDA6C, 0xE0C0,
    0xE671, 0xEACE, 0xED28, 0xF012, 0xF83D, 0x02EB, 0x09D6, 0x0C16, 0x0CB7, 0x0EBD, 0x1058, 0x1093, 0x1040, 0x11AE, 0x14D1, 0x160C,
    0x1662, 0x1581, 0x12BA, 0x111C, 0x1036, 0x0FA3, 0x0F17, 0x0F26, 0x1134, 0x1276, 0x1324, 0x130E, 0x132A, 0x1505, 0x1975, 0x1FE1,
    0x23E1, 0x2397, 0x2251, 0x2309, 0x2497, 0x26B1, 0x2993, 0x2D49, 0x2FD4, 0x3137, 0x3612, 0x3E0B, 0x4260, 0x4018, 0x39D7, 0x32FD,
    0x2C68, 0x2466, 0x1A19, 0x106C, 0x0828, 0xFF76, 0xF60D, 0xEAAC, 0xDD5C, 0xD126, 0xC73C, 0xBFBE, 0xBB27, 0xBAA6, 0xBD2A, 0xC0BC,
    0xC490, 0xC7AE, 0xC8A6, 0xC73C, 0xC652, 0xC6F4, 0xC7AD, 0xC6A8, 0xC633, 0xC793, 0xCAFF, 0xD081, 0xD7AD, 0xDF9A, 0xE51F, 0xE963,
    0xF0CF, 0xFC84, 0x079D, 0x0D9B, 0x0EC1, 0x0E32, 0x0E15, 0x0D8C, 0x0C7C, 0x0CE4, 0x0F6A, 0x12BA, 0x14B6, 0x14DC, 0x126D, 0x0FE1,
    0x0DBB, 0x0C52, 0x0B6F, 0x0AC6, 0x0B8C, 0x0B8C, 0x0BBA, 0x0AF6, 0x08DC, 0x067A, 0x05F8, 0x09FA, 0x0EC1, 0x1109, 0x118E, 0x1238,
    0x13D0, 0x1644, 0x18F2, 0x1C49, 0x1D49, 0x1B29, 0x1976, 0x1A9E, 0x1CCF, 0x1AB6, 0x14F0, 0x0E2F, 0x08D6, 0x0470, 0xFE8F, 0xF8F2,
    0xF5F3, 0xF5C9, 0xF828, 0xFA90, 0xFB32, 0xF917, 0xF58B, 0xF0EB, 0xE9D1, 0xE2D1, 0xDE32, 0xDD7E, 0xDE5A, 0xDF0F, 0xDF7C, 0xDE46,
    0xDD23, 0xDF4D, 0xE47D, 0xE953, 0xECB9, 0xEFD8, 0xF53B, 0xFB88, 0x017B, 0x074D, 0x0BD9, 0x0D49, 0x0DA5, 0x1336, 0x1D4C, 0x250E,
    0x2733, 0x25E4, 0x24E3, 0x2586, 0x25CC, 0x256B, 0x261A, 0x26D0, 0x275A, 0x26C1, 0x234E, 0x1CCB, 0x159D, 0x0FCE, 0x09C8, 0x0372,
    0xFE19, 0xFA49, 0xF7A2, 0xF570, 0xF38B, 0xF163, 0xEE4F, 0xEDA9, 0xF079, 0xF2A9, 0xF167, 0xEE55, 0xEC2B, 0xEAE7, 0xE9F2, 0xEB03,
    0xEC9E, 0xEB8D, 0xE7C7, 0xE687, 0xEBAE, 0xF35A, 0xF993, 0xFD24, 0xFFA8, 0x019C, 0x018D, 0xFECD, 0xFAB9, 0xF6F3, 0xF574, 0xF55A,
    0xF3AD, 0xF089, 0xECF1, 0xEA17, 0xE79B, 0xE4A9, 0xE2E6, 0xE30C, 0xE4A4, 0xE6A4, 0xE8CA, 0xEA0F, 0xE945, 0xEA70, 0xF01B, 0xF7A6,
    0xFDEC, 0x02B8, 0x074A, 0x0AAD, 0x0DC8, 0x1286, 0x18F0, 0x1ED9, 0x221F, 0x2791, 0x317F, 0x3CEC, 0x44E3, 0x4670, 0x448A, 0x423B,
    0x3EBC, 0x3A89, 0x35AC, 0x304E, 0x2AA4, 0x2486, 0x1DB6, 0x152C, 0x0C8E, 0x0472, 0xFBDC, 0xF25D, 0xE99A, 0xE251, 0xDB44, 0xD515,
    0xD117, 0xCCDF, 0xC755, 0xC1E4, 0xBEF9, 0xBE19, 0xBD68, 0xBCD9, 0xBD8E, 0xC13D, 0xC66D, 0xCD76, 0xD6EC, 0xDF34, 0xE34E, 0xE53D,
    0xE941, 0xF104, 0xF98A, 0xFF25, 0x0208, 0x0414, 0x05DE, 0x06EB, 0x073B, 0x0738, 0x078C, 0x090D, 0x09D6, 0x0810, 0x0465, 0xFFD8,
    0xFB86, 0xF6C3, 0xF2F1, 0xF280, 0xF4D4, 0xF874, 0xFD0C, 0x0132, 0x03FC, 0x062B, 0x09B1, 0x1095, 0x1893, 0x1FE0, 0x25A9, 0x2A35,
    0x2E2A, 0x3227, 0x37CE, 0x3D83, 0x3F73, 0x3EAD, 0x3F6A, 0x4337, 0x47AA, 0x48BA, 0x45FA, 0x41D7, 0x3E17, 0x3884, 0x31CA, 0x2BAD,
    0x241D, 0x1C4E, 0x15A2, 0x0E8E, 0x05FF, 0xFC11, 0xF0CC, 0xE4C2, 0xD7B4, 0xCB77, 0xC1B5, 0xBB20, 0xB882, 0xB8A4, 0xB94D, 0xB993,
    0xBB56, 0xBFEA, 0xC447, 0xC70A, 0xC8C9, 0xCA9E, 0xCCDE, 0xCEAF, 0xD3B5, 0xDBE3, 0xE248, 0xE56F, 0xE8E8, 0xF0D1, 0xFB9B, 0x0582,
    0x0C0A, 0x0F1E, 0x1127, 0x1206, 0x134C, 0x14ED, 0x15D6, 0x17FF, 0x1B35, 0x1D73, 0x1D5C, 0x1C0A, 0x1B4B, 0x1A71, 0x1875, 0x16D0,
    0x15DE, 0x15E7, 0x15F9, 0x1782, 0x197A, 0x188A, 0x1707, 0x17DF, 0x1AF4, 0x1C57, 0x1BDF, 0x1CC9, 0x1D7C, 0x1D7F, 0x1FF9, 0x2664,
    0x2C2D, 0x2EA3, 0x2F88, 0x30E6, 0x34EE, 0x37FA, 0x370C, 0x33C6, 0x2FF0, 0x2BAC, 0x25C4, 0x1E16, 0x1306, 0x0701, 0xFCAE, 0xF391,
    0xEB65, 0xE41B, 0xDFA1, 0xDC56, 0xD8C5, 0xD4BB, 0xD147, 0xCE0B, 0xCB2C, 0xCA0A, 0xC9B2, 0xC7EE, 0xC52A, 0xC49E, 0xC649, 0xC903,
    0xCADA, 0xCC2B, 0xCD9E, 0xCFBA, 0xD420, 0xDAA8, 0xE183, 0xE6ED, 0xEAAE, 0xEFAD, 0xF8E0, 0x047A, 0x0DF0, 0x1363, 0x16AE, 0x18C0,
    0x198E, 0x1A11, 0x1A6D, 0x1B49, 0x1DAD, 0x1FBE, 0x200D, 0x1E9B, 0x1CD6, 0x1B1D, 0x18D0, 0x163E, 0x1325, 0x0EF3, 0x0A82, 0x07F0,
    0x07C7, 0x06D2, 0x03E5, 0x0197, 0x0321, 0x0583, 0x05A7, 0x04A9, 0x0201, 0xFD8B, 0xFA4E, 0xFB7F, 0xFFB8, 0x01D9, 0xFFA6, 0xFC1B,
    0xFA65, 0xFBB4, 0xFD50, 0xFE10, 0xFFB1, 0x012B, 0x0378, 0x065D, 0x0875, 0x08EF, 0x0906, 0x09F2, 0x09B7, 0x075F, 0x0444, 0x0061,
    0xFBF2, 0xF74C, 0xF306, 0xEEF9, 0xEADB, 0xE869, 0xE75D, 0xE596, 0xE198, 0xDD24, 0xDC69, 0xDF04, 0xE2FC, 0xE776, 0xEBF2, 0xF040,
    0xF3BD, 0xF910, 0x00DB, 0x07B3, 0x0BA5, 0x0DC2, 0x1217, 0x1B28, 0x253C, 0x2C6D, 0x30BA, 0x332F, 0x3599, 0x3842, 0x395D, 0x3904,
    0x380E, 0x3718, 0x3557, 0x3162, 0x2C43, 0x2720, 0x21F9, 0x1CFF, 0x17D6, 0x1229, 0x0B7D, 0x049B, 0xFEF4, 0xF9A9, 0xF39D, 0xEC28,
    0xE74D, 0xE5C8, 0xE345, 0xDF9F, 0xDB29, 0xD58D, 0xCF7A, 0xCCBC, 0xCFF3, 0xD63B, 0xDAF1, 0xDD22, 0xE0B0, 0xE7F7, 0xF0F6, 0xF843,
    0xFCE8, 0xFEA1, 0xFE0B, 0xFCB7, 0xFA98, 0xF73E, 0xF4A8, 0xF51D, 0xF703, 0xF85D, 0xF88D, 0xF787, 0xF56A, 0xF227, 0xEEF0, 0xEC30,
    0xEA07, 0xE93F, 0xEB66, 0xEF72, 0xF25F, 0xF282, 0xF2C7, 0xF5E7, 0xFA79, 0x0035, 0x06A8, 0x0BCF, 0x0DDB, 0x0ED7, 0x12DF, 0x1A36,
    0x20D1, 0x24DE, 0x2853, 0x2E97, 0x36EE, 0x3D5E, 0x4094, 0x40A7, 0x3FD7, 0x3ECA, 0x3D47, 0x3A2C, 0x35A0, 0x312C, 0x2C63, 0x25B2,
    0x1E1A, 0x16B3, 0x0F29, 0x0750, 0xFEE0, 0xF58D, 0xEAB3, 0xDE44, 0xD35A, 0xCBAC, 0xC51A, 0xBEF3, 0xBAF6, 0xBA91, 0xBD16, 0xC089,
    0xC478, 0xC838, 0xC99E, 0xCA29, 0xCCAD, 0xD1AE, 0xD751, 0xDA52, 0xDC0B, 0xDE55, 0xE3FC, 0xEC99, 0xF4EB, 0xFB55, 0xFFC2, 0x02F0,
    0x0564, 0x0636, 0x0582, 0x04F5, 0x05FF, 0x079C, 0x0805, 0x071D, 0x04FA, 0x0260, 0xFF09, 0xFB0A, 0xF7B6, 0xF5AA, 0xF5BE, 0xF8FD,
    0xFD45, 0xFF77, 0x00A6, 0x0360, 0x083F, 0x0DED, 0x13CC, 0x1942, 0x1D20, 0x1E29, 0x1F17, 0x2384, 0x29FE, 0x2ECD, 0x3083, 0x331D,
    0x37A4, 0x3C41, 0x3F36, 0x3F07, 0x3CB8, 0x39F1, 0x37FB, 0x35A5, 0x30A4, 0x2A15, 0x22D7, 0x197C, 0x0E4E, 0x014B, 0xF4E7, 0xE94E,
    0xDEDA, 0xD6C9, 0xCF5F, 0xC90A, 0xC3FF, 0xC1B2, 0xC0EE, 0xBEF7, 0xBC66, 0xBAF7, 0xBB2C, 0xBC09, 0xBD92, 0xC059, 0xC28C, 0xC395,
    0xC509, 0xC8EF, 0xD03B, 0xD739, 0xDBA3, 0xDF03, 0xE4F2, 0xEDC4, 0xF755, 0x00E4, 0x08B7, 0x0ECB, 0x141B, 0x17DA, 0x19F2, 0x1B71,
    0x1DFC, 0x20A2, 0x228D, 0x2401, 0x24E0, 0x248C, 0x2232, 0x202D, 0x1F33, 0x1D5F, 0x19BE, 0x1684, 0x1479, 0x11D8, 0x0CE5, 0x0710,
    0x0396, 0x0328, 0x0500, 0x08CB, 0x0CEE, 0x0EB8, 0x0D97, 0x0C87, 0x0F54, 0x1344, 0x161C, 0x17E4, 0x19E5, 0x1D2E, 0x1F84, 0x207C,
    0x1E63, 0x199F, 0x1541, 0x11BD, 0x0DD7, 0x0994, 0x0556, 0x01FE, 0xFED4, 0xFA91, 0xF598, 0xEFBE, 0xE9AA, 0xE349, 0xDDB9, 0xD801,
    0xD195, 0xCD35, 0xCB9A, 0xCA84, 0xC811, 0xC537, 0xC351, 0xC281, 0xC268, 0xC3A3, 0xC5FA, 0xC7CA, 0xC809, 0xC9CA, 0xCEAE, 0xD5F5,
    0xDCCF, 0xE195, 0xE6C7, 0xEE6D, 0xF844, 0x0263, 0x0AF9, 0x1200, 0x17E4, 0x1CE4, 0x20D6, 0x23B8, 0x26A4, 0x293B, 0x2A99, 0x2A66,
    0x27FF, 0x249E, 0x2084, 0x1CD7, 0x1974, 0x1604, 0x1260, 0x0EA4, 0x0C7F, 0x0AD7, 0x07D2, 0x02E8, 0xFF19, 0xFD6F, 0xFD99, 0xFF12,
    0x00B0, 0x0056, 0xFA98, 0xF157, 0xE9A9, 0xE591, 0xE2AF, 0xDF0A, 0xDD11, 0xDE86, 0xE35D, 0xEAF2, 0xF2C7, 0xF8AD, 0xFDA8, 0x01CF,
    0x0439, 0x0496, 0x036E, 0x0283, 0x01B0, 0x0014, 0xFE7E, 0xFE2E, 0xFD2B, 0xFA97, 0xF824, 0xF57F, 0xF156, 0xEB8B, 0xE797, 0xE64B,
    0xE4F8, 0xE29B, 0xE065, 0xDF3E, 0xE003, 0xE30F, 0xE878, 0xEDB0, 0xF1CF, 0xF3AD, 0xF584, 0xFAD0, 0x0158, 0x06D7, 0x0A79, 0x0F1A,
    0x165A, 0x1F62, 0x2781, 0x2BD4, 0x2D09, 0x2DC3, 0x2E30, 0x2E6A, 0x2F1B, 0x2FBA, 0x2FB7, 0x2ECC, 0x2C4B, 0x298C, 0x2578, 0x2112,
    0x1CC7, 0x192C, 0x1588, 0x10A0, 0x0C03, 0x076C, 0x00E0, 0xF724, 0xEBCD, 0xE102, 0xD87A, 0xD29C, 0xD0B7, 0xD0F7, 0xD0E6, 0xCF49,
    0xCF2E, 0xD1EA, 0xD821, 0xDCBD, 0xDF8D, 0xE0E9, 0xE44A, 0xE94D, 0xEF7E, 0xF4AA, 0xF765, 0xF795, 0xF5BC, 0xF5C4, 0xFA3E, 0xFAC3,
    0xF155, 0xF481, 0xFD10, 0xFC8C, 0xF71F, 0xF7E7, 0xF910, 0xFB4C, 0xF7F8, 0xF46D, 0xF226, 0xF6A5, 0xFB70, 0xF747, 0xF86B, 0xF7C5,
    0xF956, 0xFBEE, 0xFF9A, 0x0362, 0x07C7, 0x08B9, 0x0AC8, 0x0A4E, 0x0955, 0x0A18, 0x107F, 0x1526, 0x195C, 0x1D5F, 0x26D9, 0x2C93,
    0x334E, 0x35FE, 0x31CB, 0x33E1, 0x314F, 0x35DE, 0x3394, 0x2E73, 0x29A1, 0x2B79, 0x2709, 0x1A07, 0x0B55, 0xFD56, 0xF3CA, 0xE9DF,
    0xD8E2, 0xD00C, 0xCE4B, 0xC99B, 0xC5D6, 0xC1C3, 0xC0DF, 0xC2EA, 0xC052, 0xBF58, 0xC551, 0xC671, 0xC592, 0xBB82, 0xC8EE, 0xD046,
    0xD0FC, 0xCD5A, 0xD500, 0xDDAD, 0xDA91, 0xECA0, 0xEC8F, 0xFD04, 0xFAE4, 0x00FD, 0x0B1A, 0x0898, 0x0AC7, 0x1162, 0x1256, 0x11E8,
    0x1FC8, 0x0B60, 0x13FA, 0x0CBE, 0x0BF8, 0x0B58, 0xFEBC, 0x0D43, 0x105C, 0x1024, 0x1690, 0x1791, 0xFC9E, 0x0338, 0x0836, 0x0584,
    0x21B1, 0x09F3, 0x0C72, 0x2474, 0x07DB, 0x2F64, 0x1EF1, 0x1C1B, 0x39BB, 0x20C7, 0x408E, 0x2E81, 0x3D29, 0x4305, 0x2EEA, 0x3A7C,
    0x37B2, 0x2D46, 0x2359, 0x11D6, 0x01CF, 0x2924, 0xF8EF, 0xE612, 0xFF1A, 0xFEDA, 0xEEF5, 0xD32B, 0xE105, 0xD90B, 0xCCB9, 0xBF1C,
    0xD69F, 0xCC22, 0xB514, 0xAF34, 0xD05D, 0xD409, 0xA0DA, 0xCA45, 0xCB8A, 0xCB8C, 0xC834, 0xC3CF, 0xD93C, 0xDD40, 0xD772, 0xD97A,
    0xF095, 0xF61C, 0xEA0E, 0xF18B, 0x278A, 0x06FF, 0x0D03, 0x133D, 0x1F21, 0x2548, 0x1AED, 0x3DF4, 0x27DB, 0x2CD6, 0x35AF, 0x316A,
    0x2848, 0x2B11, 0x146D, 0x2D44, 0x29C3, 0x10D3, 0x1882, 0x177B, 0x1F28, 0xF5AA, 0x05E6, 0x1CAD, 0x05D3, 0x09A0, 0x112F, 0x26B3,
    0x1CB3, 0x0BC1, 0x22E6, 0x1E9E, 0x10BC, 0x0D06, 0x132E, 0xFB36, 0x1798, 0x11B5, 0x06B3, 0x113F, 0xF692, 0x2720, 0x1005, 0x0844,
    0x07C7, 0xF7BC, 0x0502, 0x0502, 0xFDFA, 0xF9A3, 0xDDC9, 0xE071, 0xFD0B, 0xB735, 0xD91C, 0xDAF9, 0xC05C, 0xDAB7, 0xD06A, 0xC627,
    0xCA81, 0xC1E7, 0xC131, 0xD86D, 0xBEC3, 0xD018, 0xD1F7, 0xD2CB, 0xCD8B, 0xE9D2, 0xDBBB, 0xD565, 0xF330, 0xFBAB, 0x02EF, 0xF761,
    0x2011, 0x1286, 0x2DDF, 0x2B0C, 0x1803, 0x246C, 0x2B23, 0x30E0, 0x27E7, 0x3000, 0x2168, 0x24BA, 0x2EF7, 0x1E73, 0x16D9, 0x0FF8,
    0x2100, 0x0740, 0x1015, 0x22F7, 0x0F3F, 0x1021, 0xFC55, 0x1B16, 0xFB5C, 0xF96F, 0xEE3A, 0xF9F4, 0xF1FF, 0xD510, 0xEEAD, 0xE155,
    0xE129, 0xD4E4, 0xFFE7, 0xDC83, 0xE0E4, 0x06B8, 0xE1BE, 0x0D7A, 0x14DE, 0x09F3, 0xFF5F, 0x1F49, 0x05EE, 0x0194, 0x19F3, 0xF982,
    0x1828, 0x1548, 0x094B, 0x020D, 0x0C81, 0xF8F3, 0x052E, 0xF216, 0xF7B5, 0xF847, 0xE39D, 0xF7FA, 0xEED9, 0xE3A3, 0xE77D, 0xE949,
    0xF8E5, 0x04AF, 0xFB0F, 0xF3C6, 0x193F, 0x0E36, 0xF7AD, 0x1CB5, 0x062B, 0x1750, 0x026D, 0x3BBD, 0x2699, 0x1D2C, 0x3BCB, 0x30C0,
    0x2793, 0x419F, 0x3AC1, 0x278B, 0x34E5, 0x2E00, 0x3EDD, 0x3297, 0x4F2D, 0x243A, 0x3132, 0x32F0, 0x3E45, 0x0CC0, 0x0AE0, 0x0F77,
    0xF39E, 0xEAC2, 0xEB5B, 0xF06B, 0xD3E5, 0xCF74, 0xDC7F, 0xEA4E, 0xCEC7, 0xE458, 0xE2C3, 0xD949, 0xD943, 0xF1E0, 0xE375, 0xE66B,
    0xE5A5, 0xEFFE, 0xF9A0, 0x0668, 0xFB09, 0xFFC7, 0xFD58, 0x0873, 0x0AC6, 0xFD37, 0x1883, 0x01EC, 0x1CA4, 0x15C2, 0xFF2C, 0x202C,
    0x1A88, 0xF844, 0x0C2F, 0x0F27, 0xFEFC, 0xFF97, 0x1CE8, 0x0201, 0x156F, 0x200B, 0x0321, 0x032C, 0x17E1, 0x09F9, 0x0745, 0x09DA,
    0x0B7E, 0x0E4C, 0xFCE1, 0x1795, 0x0214, 0x0E17, 0x07D8, 0x1A73, 0x2D97, 0x0703, 0x1511, 0x3E82, 0x28AC, 0x3977, 0x244A, 0x2025,
    0x2A97, 0x22A9, 0x1A53, 0x10EA, 0x011F, 0xF4E5, 0xECF4, 0xDA77, 0xFB34, 0xC48B, 0xDAE9, 0xDFC5, 0xC734, 0xD54D, 0xD40D, 0xC580,
    0xBF19, 0xBF51, 0xC549, 0xCE8F, 0xBF13, 0xD516, 0xBA6C, 0xC5E6, 0xE05F, 0xBF7B, 0xD768, 0xD1F1, 0xE257, 0xE223, 0xDFC5, 0xFDEC,
    0xEE80, 0x09CA, 0x0E74, 0x0B40, 0x1F58, 0x098F, 0x113B, 0x221D, 0x0087, 0x20F5, 0x1589, 0x1867, 0x236A, 0x11CC, 0x2018, 0x0925,
    0x02DD, 0x13EF, 0x0E0A, 0x08BC, 0x1383, 0x0EB7, 0xF749, 0x0312, 0x0AA1, 0x0BFD, 0x0FC0, 0x0550, 0x13FA, 0x22AE, 0x246B, 0x1EE9,
    0x316D, 0x27DD, 0x2FC5, 0x2FAF, 0x43BF, 0x31F6, 0x1B32, 0x355E, 0x2E76, 0x1CB2, 0x0F06, 0x08E2, 0x144E, 0xFE54, 0xF027, 0xFE6B,
    0xFDCC, 0xED5B, 0xDCA0, 0x0115, 0xE79B, 0xDAFD, 0xC4DB, 0xE101, 0xC1A2, 0xBB36, 0xD372, 0xAF55, 0xC60B, 0xAE2D, 0xB7D2, 0xAB3B,
    0xB9BB, 0xBF09, 0xB64A, 0xB988, 0xC730, 0xC9CB, 0xC1C4, 0xDBD3, 0xCFB3, 0xCD7D, 0xE061, 0xF55B, 0xEAA5, 0xFA79, 0x1372, 0x1974,
    0x083C, 0x1FB8, 0x29DF, 0x1139, 0x2AC7, 0x2006, 0x2E72, 0x3A0E, 0x2F6B, 0x2E7B, 0x3ABA, 0x18E2, 0x2ADE, 0x2780, 0x16BF, 0x2B32,
    0x0F9F, 0x1C73, 0x179D, 0x18FC, 0x1CAF, 0x1D44, 0x2CE5, 0x2168, 0x1E1D, 0x3BC7, 0x07B7, 0x1A15, 0x134A, 0x05AE, 0x14E7, 0xF782,
    0x08BF, 0xFA3C, 0x0EC5, 0x0DFB, 0x04B0, 0x0CA5, 0x14A4, 0x149F, 0x0862, 0x0228, 0x0485, 0xFF45, 0xF9CA, 0xE82A, 0x01B4, 0xEFB0,
    0xE529, 0xEA98, 0xCFAB, 0xDCD3, 0xC2E0, 0xD31E, 0xC75D, 0xC890, 0xD6DB, 0xC317, 0xB7AC, 0xC75B, 0xC23C, 0xB39D, 0xBBC9, 0xBDBA,
    0xCC6F, 0xBC19, 0xDC75, 0xD54F, 0xC8E8, 0xE957, 0xDB0E, 0xE4E0, 0xF7EB, 0xEE1F, 0x0B13, 0x124A, 0x0418, 0x1732, 0x18B4, 0x169C,
    0x05BB, 0x25A4, 0x1508, 0x12E1, 0x2566, 0x13E7, 0x18EF, 0x1B36, 0x1E50, 0x0D43, 0x246A, 0x1D0E, 0x0903, 0x18E6, 0x19B4, 0x07C8,
    0xF962, 0xEE2F, 0xF5E1, 0xF383, 0xE092, 0xD1DD, 0xE1BC, 0xDE10, 0xDF01, 0xDB68, 0xCF4C, 0xE62F, 0xDFC6, 0xDE53, 0xEAEE, 0xDE5B,
    0xF219, 0xF31B, 0xEFD6, 0x0E66, 0xF43B, 0x0B53, 0xF8BD, 0xFFE1, 0x08DC, 0x01F8, 0x0416, 0x1985, 0x1179, 0x065E, 0x1ABB, 0xF448,
    0xF176, 0x0301, 0xF478, 0xDE8E, 0x008A, 0xE932, 0xF4A6, 0xEA12, 0xFA4D, 0xF02F, 0xE949, 0x03BF, 0xF063, 0xFEB6, 0x0168, 0x0575,
    0x0115, 0x0C38, 0x09D3, 0xFCE9, 0xFEF0, 0x1CE4, 0x124E, 0x140E, 0x115D, 0x22A9, 0x2133, 0x1A57, 0x2BCC, 0x20D0, 0x2833, 0x3912,
    0x2B66, 0x218C, 0x2328, 0x19AF, 0x1908, 0xF62F, 0xF607, 0xF108, 0xF383, 0xDA6C, 0xDB58, 0xD9E9, 0xC35F, 0xCD46, 0xDB48, 0xD241,
    0xC695, 0xD7CA, 0xC808, 0xD87A, 0xD6B8, 0xE740, 0xDB26, 0xD7D3, 0xF304, 0xE7CA, 0xE410, 0xEEF1, 0xF5FF, 0xFBBF, 0xFB1D, 0x0FB6,
    0x10C1, 0x046E, 0x1C70, 0x17C8, 0x0E28, 0x0DD8, 0x1652, 0x0CDB, 0x24BC, 0x103B, 0x0A8E, 0x13AA, 0x1747, 0x0B49, 0xF7EA, 0x16A3,
    0x177D, 0x1596, 0x013B, 0x1527, 0x1F43, 0x0986, 0x032C, 0x176F, 0x087B, 0x00BF, 0x10CF, 0x0380, 0xFCD7, 0x1306, 0x1521, 0xFB57,
    0x1D49, 0x2C9E, 0x1D17, 0x3226, 0x407F, 0x34CC, 0x334B, 0x2684, 0x32E1, 0x1FE4, 0x0BD4, 0x11D4, 0x0442, 0xFA5B, 0x000F, 0xF72F,
    0xDE7F, 0xEC92, 0xE4FF, 0xD769, 0xD2AD, 0xD34E, 0xD861, 0xCB98, 0xC915, 0xD564, 0xC7FC, 0xC79C, 0xCAD1, 0xC506, 0xC318, 0xC046,
    0xCE1B, 0xC501, 0xC985, 0xD0A6, 0xD4F3, 0xDC9C, 0xD9D3, 0xE367, 0xE8E3, 0xFA4D, 0xFBA2, 0xFD69, 0x0A82, 0x1C7C, 0x19C3, 0x1C15,
    0x1421, 0x1C56, 0x31FD, 0x14C7, 0x22EB, 0x25EB, 0x25F9, 0x1DB2, 0x252A, 0x1BF9, 0x1888, 0x1F18, 0x101F, 0x19AA, 0xF971, 0x0F7F,
    0x0B8F, 0xFE37, 0x12E3, 0x05CE, 0x18DA, 0x18F2, 0x2239, 0x2F0E, 0x257A, 0x39B4, 0x33DF, 0x33F8, 0x2DFD, 0x2AA6, 0x2D6B, 0x24AF,
    0x29FE, 0x1FB5, 0x20C0, 0x2460, 0x24E0, 0x0C3E, 0x1681, 0x1B65, 0x074E, 0x0B68, 0x0AE6, 0x02F2, 0xFE00, 0xF264, 0xFA6E, 0xE92B,
    0xD351, 0xE41F, 0xCBC1, 0xCEB3, 0xC3E3, 0xC3DF, 0xC0B9, 0xBC75, 0xC338, 0xC529, 0xBD7B, 0xB3E1, 0xCA12, 0xC343, 0xC9A2, 0xCA66,
    0xCA5F, 0xD5BF, 0xDB59, 0xE0E3, 0xE8CD, 0xF18D, 0x01A3, 0x0388, 0x0154, 0x1CFC, 0x20E2, 0x1AC1, 0x24CB, 0x285B, 0x253C, 0x244A,
    0x36B1, 0x2D82, 0x24F8, 0x2790, 0x20EE, 0x2B43, 0x19E3, 0x1D30, 0x2994, 0x271C, 0x206D, 0x2039, 0x254C, 0x2D03, 0x365F, 0x265A,
    0x24B4, 0x26F6, 0x2146, 0x1511, 0x106D, 0x18D5, 0x1079, 0x09B9, 0x0D42, 0x1970, 0x09E3, 0x092A, 0x1C9D, 0x16AF, 0x1871, 0x1D7C,
    0x284E, 0x18B4, 0x187D, 0x11BB, 0x0AAC, 0x0CBF, 0xFD0B, 0xFB91, 0xFABD, 0xED95, 0xEFD4, 0xE4E3, 0xE244, 0xDD16, 0xD7BE, 0xDCF6,
    0xCE21, 0xD641, 0xCBD6, 0xCF3F, 0xCA06, 0xCDC0, 0xC332, 0xCAA7, 0xCE55, 0xCFB2, 0xD3C3, 0xD88A, 0xDD95, 0xE08E, 0xF21D, 0xECB2,
    0xFC9D, 0x06DD, 0x189B, 0x0EC8, 0x1679, 0x1E75, 0x1D6D, 0x1B4C, 0x152C, 0x142A, 0x1D63, 0x2082, 0x21DE, 0x2DBC, 0x25A1, 0x2DE3,
    0x3BE2, 0x1EC5, 0x3116, 0x3377, 0x1416, 0x23B8, 0x122D, 0x0F1D, 0xFED9, 0x01D7, 0xFDAA, 0xF678, 0xEC62, 0xEB5E, 0xE9AD, 0xE015,
    0xE77A, 0xE273, 0xE6FA, 0xE4EF, 0xF718, 0xE9DA, 0xE82D, 0xF108, 0xF1EE, 0xF80E, 0xF0CA, 0xF035, 0xFA8C, 0xFB3E, 0x0052, 0xFD59,
    0x00AA, 0x0D4D, 0x06F9, 0x09BA, 0x0864, 0x1563, 0x1006, 0x0F90, 0x11FB, 0x113B, 0x0DA2, 0xFA7F, 0x0906, 0x0658, 0x004B, 0xFE0F,
    0xFF10, 0x0200, 0x0090, 0x0917, 0x04E9, 0x1043, 0x07AE, 0x0DE1, 0x0F4A, 0x066E, 0x0AF1, 0x09DA, 0x07EC, 0x0347, 0x0DC3, 0x0D14,
    0x146E, 0x138F, 0x1FFE, 0x25D0, 0x260A, 0x2732, 0x3037, 0x390B, 0x292D, 0x2851, 0x2C9A, 0x1E07, 0x17AD, 0x1FED, 0x0E7A, 0x0E6C,
    0x0E36, 0x03E9, 0xF686, 0xEA52, 0xE611, 0xE008, 0xDF7B, 0xDFD7, 0xD9EE, 0xD429, 0xD665, 0xCA67, 0xCE30, 0xD281, 0xCF8B, 0xD4F2,
    0xD220, 0xDBBB, 0xDF63, 0xD947, 0xDD17, 0xE739, 0xE54A, 0xE80E, 0xF32B, 0xF0CB, 0xF6CD, 0x05C4, 0x05F5, 0x0AE1, 0x0E85, 0x136A,
    0x17B3, 0x16D4, 0x1D69, 0x2303, 0x246B, 0x1FBE, 0x2DB9, 0x2F63, 0x2EEE, 0x2DA4, 0x3406, 0x2FD8, 0x2608, 0x2713, 0x132C, 0x08DD,
    0x0A55, 0x0692, 0xF791, 0xF386, 0xFDB4, 0x0368, 0xFA9A, 0x01AB, 0x0F20, 0x0E43, 0x0BD1, 0x157B, 0x1468, 0x05F4, 0x1800, 0x111A,
    0x0B75, 0x1145, 0xFFE7, 0x0D11, 0x059B, 0xFAE4, 0xF587, 0xEE61, 0xF038, 0xF027, 0xEB3B, 0xF00E, 0xFEEF, 0xF157, 0xF0F3, 0xECDB,
    0xEA66, 0xE2BF, 0xD73E, 0xDED6, 0xD903, 0xCFFD, 0xD34C, 0xC91A, 0xC18D, 0xCD37, 0xC663, 0xBFB0, 0xC0C0, 0xCB6E, 0xCE3B, 0xD10E,
    0xCE37, 0xD0D8, 0xE334, 0xE20F, 0xE981, 0xED3C, 0xF8E8, 0xFD6B, 0x0238, 0x0BC1, 0x104E, 0x1899, 0x1F97, 0x2082, 0x234C, 0x2CFB,
    0x2299, 0x21C6, 0x1D6F, 0x1BEE, 0x1CDC, 0x0FEC, 0x173D, 0x19BA, 0x0BC9, 0x15D7, 0x15CB, 0x1689, 0x2044, 0x217C, 0x1DF6, 0x2024,
    0x1BF2, 0x16CB, 0x19B1, 0x1003, 0x15ED, 0x0F39, 0x0AB0, 0x0C25, 0x06FB, 0xFE48, 0x0144, 0xFB53, 0xF9D6, 0xF7DC, 0xFCF0, 0x06B9,
    0xFD69, 0x0AB2, 0x0406, 0xFB9F, 0xF9F1, 0xFB2B, 0xFC73, 0xF40D, 0xEDA9, 0xF6C0, 0xEC63, 0xEC5E, 0xEE35, 0xE417, 0xE5BA, 0xDDA4,
    0xE017, 0xD77B, 0xD6D1, 0xD955, 0xD58A, 0xD5B4, 0xD713, 0xD2F2, 0xD49E, 0xD3B0, 0xD02C, 0xD565, 0xDD68, 0xE10A, 0xE6E2, 0xEDC1,
    0xF889, 0xFB56, 0xFEBE, 0x102F, 0x10B6, 0x0DA9, 0x111F, 0x1801, 0x17BB, 0x1BBD, 0x1AB7, 0x2053, 0x23E2, 0x25C8, 0x2F93, 0x3588,
    0x3EF4, 0x3DE7, 0x3DCB, 0x47F8, 0x3BAF, 0x40DC, 0x41AB, 0x39A3, 0x416A, 0x32F6, 0x382C, 0x267D, 0x1EBB, 0x1A70, 0x0AF4, 0x0362,
    0xFB48, 0xF8F2, 0xF352, 0xF234, 0xF270, 0xF5BB, 0xE6D5, 0xF448, 0xEB09, 0xDB14, 0xEA2E, 0xDE20, 0xDF88, 0xDEDF, 0xDD6B, 0xDDCF,
    0xD630, 0xE28E, 0xE245, 0xD9F3, 0xDBA7, 0xE714, 0xDD7D, 0xE280, 0xE94E, 0xE636, 0xE6F6, 0xE4AE, 0xF161, 0xE54B, 0xE931, 0xE9D9,
    0xECAC, 0xE412, 0xE841, 0xED34, 0xE91D, 0xF290, 0xE9F3, 0xEFBC, 0xEFA9, 0xF2CB, 0xF2BA, 0xEAE9, 0xEBCA, 0xF375, 0xEEE7, 0xEA52,
    0xECCD, 0xF790, 0x0180, 0x0960, 0x0DD7, 0x15E5, 0x2243, 0x219D, 0x272F, 0x2E2E, 0x3098, 0x386F, 0x37B6, 0x33DA, 0x38BB, 0x3C4E,
    0x32A7, 0x2C89, 0x288E, 0x23ED, 0x219A, 0x1C73, 0x20AD, 0x123A, 0x1349, 0x0AC5, 0x03D0, 0xFA49, 0xF6C4, 0xF510, 0xE77D, 0xE4CD,
    0xDCFD, 0xDE9D, 0xD83C, 0xD7ED, 0xD009, 0xD05D, 0xCE4E, 0xD384, 0xD424, 0xD159, 0xDF70, 0xDF39, 0xE06B, 0xE94F, 0xF35C, 0xF649,
    0xF7EF, 0xFBC4, 0xF84F, 0x0161, 0x0A3C, 0x08C2, 0x0C2F, 0x16AB, 0x18BF, 0x1F98, 0x2722, 0x21CD, 0x2C7A, 0x27D5, 0x2DAA, 0x257D,
    0x23EC, 0x229B, 0x1759, 0x11C8, 0x0BA0, 0x151D, 0x0AEA, 0x0F09, 0x0F78, 0x0F8B, 0x0F13, 0x0D2A, 0x0DBA, 0x0B8A, 0x0BA1, 0x0EFD,
    0x11B3, 0x1320, 0x0A99, 0x0BA5, 0x0828, 0x016D, 0x07C9, 0xFEB4, 0x03A0, 0xFD20, 0x04BC, 0x0293, 0xFEBC, 0xFF77, 0xFE07, 0xF8BE,
    0xF560, 0xF92F, 0xEBBC, 0xF354, 0xF1AC, 0xF39E, 0xF4BB, 0xF72E, 0xF9D6, 0xF746, 0xF562, 0xF9ED, 0xF6C0, 0xF2A7, 0xF1DB, 0xF2CB,
    0xECB1, 0xEB90, 0xF1BD, 0xE81B, 0xF0D8, 0xECEA, 0xF272, 0xEF60, 0xF5FE, 0xFE37, 0xFEC2, 0x05E5, 0x0AEB, 0x0E57, 0x13F1, 0x20E0,
    0x1D54, 0x24E3, 0x242C, 0x25B4, 0x1F13, 0x1B8F, 0x18A7, 0x15AF, 0x17A8, 0x10B7, 0x1888, 0x181A, 0x1D54, 0x1C15, 0x1F3F, 0x2679,
    0x1FAF, 0x2604, 0x22C8, 0x2327, 0x2516, 0x19B5, 0x16FD, 0x0E6E, 0x01A4, 0xFC35, 0xEFFD, 0xEC15, 0xE25D, 0xDE02, 0xD83E, 0xD7EF,
    0xD019, 0xCA00, 0xCD54, 0xC388, 0xCC58, 0xC6C8, 0xCC93, 0xC85E, 0xCD22, 0xD09E, 0xD053, 0xD2CA, 0xD4C2, 0xDB2B, 0xD779, 0xDF44,
    0xDB5C, 0xE0EC, 0xE186, 0xE255, 0xE681, 0xEC40, 0xEBB0, 0xEACD, 0xF755, 0xF554, 0xF6F6, 0x0056, 0xFD02, 0x062A, 0x0976, 0x0823,
    0x0FF1, 0x0DA8, 0x14A6, 0x16D0, 0x1435, 0x13EC, 0x182C, 0x12B7, 0x0D4F, 0x0F90, 0x073F, 0x0443, 0x0366, 0x076B, 0x0927, 0x1031,
    0x1245, 0x1101, 0x18B0, 0x1C69, 0x23B7, 0x26A9, 0x2C88, 0x3432, 0x3131, 0x359E, 0x340E, 0x2BBD, 0x27DB, 0x1FAA, 0x1D1A, 0x1719,
    0x145C, 0x116A, 0x0C0C, 0x04C1, 0xFFC5, 0xFCF0, 0xF63C, 0xEFA7, 0xEEDA, 0xE7F7, 0xE53D, 0xE782, 0xDDEB, 0xDB22, 0xD880, 0xD8CB,
    0xD1B1, 0xD033, 0xD13A, 0xCE64, 0xCBBA, 0xC935, 0xCC51, 0xC911, 0xCAC0, 0xCF44, 0xCC65, 0xCD62, 0xD249, 0xD1C5, 0xD63C, 0xD87A,
    0xDDEC, 0xDE4E, 0xE4ED, 0xE83C, 0xED51, 0xF684, 0xF8E0, 0x092B, 0x0668, 0x10C2, 0x1754, 0x140E, 0x14DD, 0x11BC, 0x123F, 0x103C,
    0x12E2, 0x127B, 0x153A, 0x1757, 0x19FE, 0x196F, 0x1A7C, 0x1DCB, 0x217E, 0x2610, 0x2B09, 0x2BA7, 0x2AED, 0x2DDE, 0x2B32, 0x2675,
    0x23C1, 0x1DF3, 0x1B83, 0x1A7F, 0x1C1E, 0x198A, 0x1641, 0x1729, 0x0EA0, 0x0F35, 0x0A11, 0x0D83, 0x07D7, 0x08BD, 0x093B, 0x0262,
    0x0596, 0xFE19, 0x0203, 0xF705, 0xF755, 0xF2D8, 0xEC43, 0xE7B1, 0xDC97, 0xD886, 0xD4D6, 0xCFE6, 0xCEB4, 0xCE57, 0xCD97, 0xCACB,
    0xC535, 0xCDBB, 0xC50C, 0xC6D3, 0xC7A3, 0xCA1D, 0xCE3D, 0xCB06, 0xD2A9, 0xD2BF, 0xDA5D, 0xE3C1, 0xE3D5, 0xE9E3, 0xEAD0, 0xEEA1,
    0xF055, 0xF1A8, 0xF469, 0xF184, 0xFE5C, 0xFE99, 0x0624, 0x0C65, 0x0D8B, 0x1419, 0x1691, 0x1BB4, 0x2158, 0x2660, 0x2981, 0x2CC3,
    0x2DB3, 0x29C7, 0x243C, 0x22A6, 0x180C, 0x16CF, 0x108D, 0x0D32, 0x0938, 0x082E, 0x08E2, 0x0192, 0x01FF, 0xF9D0, 0xFB10, 0xF704,
    0xF20D, 0xF195, 0xF30C, 0xF29F, 0xEF48, 0xF388, 0xF1AE, 0xEDBB, 0xF10B, 0xEC5F, 0xEE8E, 0xEEDE, 0xEC71, 0xF033, 0xED92, 0xF0B8,
    0xF077, 0xF675, 0xF619, 0xF8EB, 0xFB2B, 0xF912, 0xFBAF, 0xFA8E, 0xF69A, 0xF6F8, 0xF587, 0xF16F, 0xF247, 0xF528, 0xF714, 0xF970,
    0xFE52, 0xFDF0, 0xFFCA, 0xFDD1, 0xFCD8, 0xFAD6, 0xFC4E, 0xFB3E, 0xFE28, 0xFEB9, 0x006F, 0x034B, 0x035B, 0x0645, 0x09E9, 0x1055,
    0x14E4, 0x1E2C, 0x23B7, 0x2D01, 0x29CC, 0x2CFA, 0x2B11, 0x2602, 0x24C3, 0x2275, 0x2391, 0x1BDB, 0x1A88, 0x1624, 0x1213, 0x0BCD,
    0x08DD, 0x01A6, 0xFB00, 0xF363, 0xEDC7, 0xE9A8, 0xE10B, 0xE01D, 0xDC92, 0xDCE6, 0xD85C, 0xD8ED, 0xD623, 0xD6C0, 0xD95D, 0xDA3E,
    0xDA42, 0xD74D, 0xDAE5, 0xDCF3, 0xE1C6, 0xE38B, 0xE757, 0xE97F, 0xF100, 0xF47E, 0xF822, 0xFACB, 0xF968, 0xFC0C, 0xFDFD, 0x0223,
    0x09B0, 0x1320, 0x1C02, 0x23A1, 0x2E50, 0x2F4F, 0x31E3, 0x316A, 0x2C19, 0x2F24, 0x28C1, 0x24E7, 0x2176, 0x1E6C, 0x190F, 0x1526,
    0x0D5D, 0x0B35, 0x05E3, 0x04A5, 0x0553, 0x085A, 0x0B71, 0x0E95, 0x0E00, 0x0E63, 0x108B, 0x0A7E, 0x0E08, 0x0767, 0x072D, 0x0280,
    0x01BE, 0x0207, 0xFDEB, 0xFA79, 0xFA46, 0xF762, 0xF312, 0xEE7C, 0xE96B, 0xE495, 0xE1FC, 0xE1A7, 0xE20D, 0xE16A, 0xE081, 0xE0F4,
    0xDCA5, 0xDD39, 0xD8C9, 0xD957, 0xD6B0, 0xD5B7, 0xD1B1, 0xD22A, 0xCEC0, 0xCEED, 0xCD74, 0xCC92, 0xCEFA, 0xCC17, 0xD0E2, 0xCFB8,
    0xD2FE, 0xD22F, 0xD856, 0xDD69, 0xE5F3, 0xF1CA, 0xFA78, 0x06B5, 0x0F33, 0x1803, 0x1DEB, 0x2083, 0x2260, 0x24CE, 0x2937, 0x2B5E,
    0x2C62, 0x2E6B, 0x2E52, 0x2ABD, 0x2A3D, 0x2B9D, 0x2B01, 0x2CFB, 0x2E38, 0x3085, 0x3237, 0x3389, 0x3150, 0x305E, 0x2D3A, 0x2865,
    0x25D1, 0x2044, 0x1AB6, 0x1406, 0x1027, 0x0C69, 0x085B, 0x0479, 0x0271, 0xFEBD, 0xFB92, 0xF977, 0xF3CA, 0xF35F, 0xEFF7, 0xEF4F,
    0xF23D, 0xF22C, 0xF3FB, 0xF29B, 0xF2A8, 0xF1B3, 0xF23C, 0xF09F, 0xF09B, 0xEF7C, 0xEB6B, 0xEACE, 0xE90F, 0xE851, 0xE5ED, 0xE4AB,
    0xE2F9, 0xE150, 0xDE90, 0xDC7D, 0xD50E, 0xD04B, 0xCF50, 0xCE5C, 0xD204, 0xD338, 0xDA03, 0xDF4B, 0xE411, 0xE97E, 0xE97C, 0xEBCA,
    0xEB4B, 0xF003, 0xF4AA, 0xF862, 0xFD64, 0xFFAE, 0x0502, 0x08B4, 0x0B87, 0x1265, 0x18FA, 0x203D, 0x2971, 0x2EB2, 0x372E, 0x3BE3,
    0x4154, 0x4376, 0x42C9, 0x42CC, 0x446E, 0x4310, 0x40F3, 0x3DA4, 0x3794, 0x337A, 0x2C28, 0x2A3B, 0x2454, 0x1F53, 0x19DE, 0x1439,
    0x0E00, 0x06CF, 0x0374, 0xFF59, 0xFF1E, 0xFDB7, 0xFA1D, 0xF982, 0xF7B8, 0xF361, 0xF0C9, 0xEF0B, 0xED35, 0xECBB, 0xE9EE, 0xEA2E,
    0xE683, 0xE6DC, 0xE6A6, 0xE47D, 0xE7B8, 0xE3EE, 0xE6C5, 0xE447, 0xE327, 0xE100, 0xDC74, 0xDECB, 0xE02F, 0xE507, 0xE9B0, 0xF06B,
    0xF45D, 0xF583, 0xF526, 0xF5F2, 0xF267, 0xEE7C, 0xED83, 0xE943, 0xE94B, 0xE3B1, 0xE03E, 0xDE93, 0xDD2B, 0xDF47, 0xE21A, 0xE7A2,
    0xEE7A, 0xF43B, 0xFB23, 0x005B, 0x06FA, 0x0DC4, 0x1012, 0x14C2, 0x15BD, 0x1930, 0x181E, 0x1CA9, 0x1C59, 0x1BD0, 0x1E06, 0x1EEF,
    0x2032, 0x1DEE, 0x20F4, 0x1D60, 0x1C47, 0x1A55, 0x1815, 0x1804, 0x1400, 0x115D, 0x1148, 0x0A6D, 0x0822, 0x01B7, 0xFB18, 0xF3D4,
    0xEBE9, 0xE820, 0xE058, 0xDE15, 0xD98C, 0xD76E, 0xD50C, 0xD5E6, 0xD74B, 0xD7F3, 0xD9C8, 0xD95B, 0xDB9B, 0xDB19, 0xDD41, 0xE164,
    0xE706, 0xF028, 0xF703, 0xFF53, 0x06A7, 0x0B2D, 0x0F6B, 0x1448, 0x17EF, 0x19BC, 0x1B74, 0x1EBF, 0x221D, 0x22A4, 0x21B2, 0x1F49,
    0x1DB7, 0x1C0E, 0x1C10, 0x1DA0, 0x1F3F, 0x1F50, 0x20D7, 0x2171, 0x1DFD, 0x1C8C, 0x19E3, 0x1882, 0x1381, 0x1111, 0x0DC9, 0x0A65,
    0x0623, 0xFF4A, 0x00EA, 0xFD04, 0xFB0A, 0xF958, 0xFA99, 0xFC6F, 0xF938, 0xF55F, 0xF30B, 0xEF6B, 0xEE17, 0xEC6A, 0xEC37, 0xEC2E,
    0xEB14, 0xEE25, 0xECA3, 0xEB18, 0xE9DB, 0xEBD8, 0xEC41, 0xEDF1, 0xED97, 0xF154, 0xF30C, 0xF543, 0xF4F6, 0xF639, 0xF5B0, 0xF086,
    0xF3E5, 0xF279, 0xEFF5, 0xEFD8, 0xEC83, 0xECDA, 0xEF26, 0xEE57, 0xFA98, 0xFFE8, 0x06B0, 0x0BC7, 0x1022, 0x13FA, 0x180A, 0x2102,
    0x20AA, 0x227C, 0x2147, 0x1F29, 0x1FF2, 0x1F6E, 0x1F35, 0x2145, 0x2129, 0x2382, 0x2478, 0x22D0, 0x1CB1, 0x1F6A, 0x28F0, 0x27A6,
    0x2512, 0x2639, 0x2733, 0x2492, 0x2591, 0x1FC8, 0x18AD, 0x16CB, 0x10CF, 0x0BF4, 0x0707, 0x002E, 0xFC63, 0xF8DE, 0xF15B, 0xEBAE,
    0xE22E, 0xD8FC, 0xD786, 0xD843, 0xD612, 0xD3BA, 0xD458, 0xD12F, 0xCDD8, 0xCD9C, 0xCBFB, 0xCC35, 0xCEA7, 0xCFE3, 0xD36B, 0xD649,
    0xDA2A, 0xDB76, 0xD860, 0xD540, 0xD29A, 0xD08C, 0xCF81, 0xD294, 0xD6CB, 0xDC69, 0xE47C, 0xEB8F, 0xF31A, 0xF9F5, 0x0129, 0x08DB,
    0x0D70, 0x14EA, 0x1900, 0x1CD0, 0x1DA7, 0x1E6A, 0x2052, 0x1DBA, 0x1D5B, 0x1B34, 0x1A2A, 0x1962, 0x1BA7, 0x1DCE, 0x1FED, 0x24A6,
    0x2616, 0x298F, 0x2A8F, 0x2A92, 0x2B0A, 0x2874, 0x2846, 0x2788, 0x2883, 0x271F, 0x2627, 0x2339, 0x2031, 0x1DA4, 0x17CF, 0x1452,
    0x114D, 0x0F97, 0x0B95, 0x097B, 0x0490, 0x00F3, 0xFE54, 0xFAFB, 0xF9C6, 0xF7A0, 0xF5BF, 0xF2AF, 0xEF8E, 0xEB55, 0xE81A, 0xE71F,
    0xE708, 0xE73C, 0xE991, 0xE9D8, 0xE90F, 0xE764, 0xE2D1, 0xDF55, 0xDB0F, 0xD87F, 0xD6F6, 0xD61A, 0xD672, 0xD63E, 0xDA17, 0xDAC5,
    0xDC73, 0xE116, 0xE345, 0xE839, 0xEC4E, 0xEE7F, 0xF0E4, 0xF1C5, 0xF291, 0xF4C5, 0xF479, 0xF56D, 0xF7A6, 0xF9CC, 0xFB21, 0xFDCF,
    0x02D4, 0x076C, 0x0EA3, 0x1464, 0x1970, 0x1F9C, 0x241E, 0x294C, 0x2BA4, 0x2C8B, 0x2D97, 0x2D29, 0x2FB4, 0x3115, 0x3201, 0x31E5,
    0x2E66, 0x2A95, 0x2663, 0x21F0, 0x1E65, 0x1BC7, 0x1924, 0x165A, 0x1250, 0x0E35, 0x0C3A, 0x0B9F, 0x0B17, 0x0B58, 0x0B2A, 0x09F3,
    0x06E4, 0x01AD, 0xFF03, 0xFCAE, 0xFBE3, 0xFC2D, 0xFC1B, 0xFD30, 0xFBA9, 0xF7EC, 0xF2CD, 0xEBB6, 0xE57B, 0xE1DD, 0xDF8A, 0xDF7B,
    0xDF7C, 0xE091, 0xE118, 0xE17A, 0xE2C0, 0xE2E8, 0xE510, 0xE687, 0xE9C4, 0xEE39, 0xEFB8, 0xF18F, 0xF23D, 0xF1BD, 0xF1A6, 0xEEE7,
    0xECD6, 0xEC15, 0xE9F1, 0xE888, 0xE9E5, 0xEC46, 0xEFCE, 0xF6D9, 0xFC45, 0x0220, 0x06A1, 0x0A00, 0x0DD0, 0x0FEB, 0x12CC, 0x14CA,
    0x1727, 0x17E1, 0x17CE, 0x17A9, 0x1711, 0x1527, 0x1380, 0x120C, 0x0F43, 0x0D99, 0x0CA0, 0x09C2, 0x081B, 0x05B0, 0x023C, 0x024A,
    0x01EC, 0x0225, 0x00C6, 0xFFF2, 0xFCC6, 0xF96B, 0xF5C8, 0xF177, 0xF0DC, 0xF020, 0xF08F, 0xF274, 0xF0B9, 0xEE99, 0xEAF2, 0xE5BD,
    0xE2E9, 0xE107, 0xE2C3, 0xE3DE, 0xE68B, 0xE9B9, 0xEC62, 0xEECC, 0xF38F, 0xF626, 0xFAE1, 0x0145, 0x0482, 0x0936, 0x0B58, 0x0D8C,
    0x0DE4, 0x0E1A, 0x0CF2, 0x0DEF, 0x0DE2, 0x0D16, 0x0E8A, 0x0ECC, 0x0EA8, 0x1133, 0x146C, 0x15CB, 0x1A03, 0x1ADA, 0x1C94, 0x1E7D,
    0x200E, 0x210A, 0x2125, 0x216B, 0x20AB, 0x2135, 0x1F58, 0x1D7F, 0x1ABC, 0x1776, 0x13BF, 0x0FEC, 0x0D5D, 0x09F3, 0x0840, 0x0573,
    0x015F, 0xFE5D, 0xFB23, 0xF7B7, 0xF4C3, 0xF0E2, 0xED1C, 0xE981, 0xE450, 0xDEC0, 0xDB85, 0xD970, 0xD9FA, 0xDEA1, 0xE0DF, 0xE43D,
    0xE6AB, 0xE622, 0xE5A9, 0xE463, 0xE294, 0xE13F, 0xE0CA, 0xE23E, 0xE3A9, 0xE655, 0xEABD, 0xEED7, 0xF2F3, 0xF566, 0xF8E8, 0xFB82,
    0xFEAB, 0x0336, 0x06CF, 0x092C, 0x0B6F, 0x0D3A, 0x0FAA, 0x119A, 0x14CC, 0x1769, 0x17F3, 0x1A1A, 0x1BF7, 0x1EAC, 0x20E4, 0x234D,
    0x24BA, 0x2572, 0x25B8, 0x25A8, 0x2555, 0x2541, 0x24B3, 0x22B3, 0x204B, 0x1D80, 0x1BAE, 0x1833, 0x14ED, 0x12D8, 0x1052, 0x0D28,
    0x0939, 0x0499, 0xFF37, 0xFAEE, 0xF6FE, 0xF352, 0xF02F, 0xEE33, 0xEBB0, 0xE822, 0xE400, 0xDD9F, 0xD7A6, 0xD1FA, 0xCDA1, 0xCB38,
    0xC94C, 0xC987, 0xCC13, 0xCEE7, 0xD0FF, 0xD391, 0xD448, 0xD3A2, 0xD422, 0xD4A5, 0xD50E, 0xD5F4, 0xD7B6, 0xD93C, 0xDB5D, 0xDD0D,
    0xDF28, 0xE311, 0xE78E, 0xED18, 0xF201, 0xF8BA, 0xFEF1, 0x0452, 0x08AC, 0x0C11, 0x0FA0, 0x1133, 0x12AF, 0x140A, 0x160D, 0x1850,
    0x1A89, 0x1BC5, 0x1DB0, 0x1F7F, 0x1FDD, 0x209B, 0x203E, 0x1F36, 0x1F90, 0x20C9, 0x228C, 0x2305, 0x2368, 0x2286, 0x221C, 0x23BE,
    0x2264, 0x2256, 0x21ED, 0x2052, 0x1E02, 0x1A18, 0x1584, 0x1060, 0x0CF8, 0x0AD8, 0x0896, 0x073B, 0x0523, 0x00C7, 0xFD10, 0xF77D,
    0xF278, 0xEF32, 0xEBDB, 0xE9E3, 0xE924, 0xE949, 0xEAA3, 0xEA68, 0xE995, 0xE8CA, 0xE6F1, 0xE543, 0xE39F, 0xE154, 0xDFB6, 0xDD28,
    0xDB2C, 0xDAD3, 0xD8FE, 0xD947, 0xD93B, 0xDA4E, 0xDC1D, 0xDDBE, 0xE06D, 0xE3B2, 0xE7C3, 0xEC7C, 0xF06F, 0xF1F0, 0xF36E, 0xF35C,
    0xF377, 0xF435, 0xF62C, 0xF7E3, 0xFA54, 0xFD0D, 0xFFF9, 0x0418, 0x081B, 0x0BF9, 0x0FAA, 0x14AD, 0x181A, 0x1CBE, 0x2160, 0x247D,
    0x27CD, 0x2A59, 0x2B76, 0x2B4B, 0x2B8D, 0x2B8D, 0x2C43, 0x2BE2, 0x29EC, 0x2575, 0x1FCC, 0x1929, 0x13D9, 0x1085, 0x0DBC, 0x0BA9,
    0x08B4, 0x050C, 0xFFF7, 0xFBD6, 0xF841, 0xF7D9, 0xF7AB, 0xF982, 0xFD1D, 0xFFBE, 0x01EB, 0x0334, 0x03F0, 0x027B, 0x0177, 0xFF45,
    0xFC77, 0xF9E0, 0xF745, 0xF305, 0xEEED, 0xEC7A, 0xE9BD, 0xE7DA, 0xE6B9, 0xE65B, 0xE6A6, 0xE7C3, 0xE8E5, 0xEA72, 0xEB62, 0xEBD7,
    0xEC45, 0xEB8B, 0xEA86, 0xE90C, 0xE860, 0xE6D4, 0xE67A, 0xE7E4, 0xE89F, 0xE969, 0xE9BA, 0xE9F3, 0xEA83, 0xEC25, 0xEEE6, 0xF28B,
    0xF7DD, 0xFDE0, 0x02C8, 0x0705, 0x0B1A, 0x0D83, 0x106F, 0x1397, 0x1561, 0x1820, 0x18ED, 0x184D, 0x16B7, 0x14AE, 0x121C, 0x0FE0,
    0x0E48, 0x0DBD, 0x0E45, 0x0E7F, 0x0D2A, 0x0A26, 0x0615, 0x0063, 0xFC2C, 0xF7E9, 0xF696, 0xF6F3, 0xF772, 0xF988, 0xFA06, 0xF901,
    0xF6B5, 0xF48B, 0xF1A1, 0xEF66, 0xEDFF, 0xECAF, 0xEAE0, 0xE825, 0xE5ED, 0xE489, 0xE447, 0xE3F4, 0xE474, 0xE663, 0xE8FB, 0xEC53,
    0xF130, 0xF482, 0xF8A3, 0xFD79, 0x0127, 0x0448, 0x05F1, 0x05A6, 0x04E1, 0x0500, 0x056B, 0x06EB, 0x0959, 0x0C2F, 0x0E25, 0x1012,
    0x118B, 0x13AA, 0x16AD, 0x195E, 0x1BB6, 0x1DBF, 0x1F4F, 0x20AF, 0x21A5, 0x21B3, 0x2217, 0x2319, 0x2391, 0x22BA, 0x2206, 0x1F6B,
    0x1B60, 0x172D, 0x10D4, 0x0B29, 0x08F9, 0x0774, 0x07C0, 0x0898, 0x0753, 0x056B, 0x00ED, 0xFB73, 0xF5A3, 0xF06C, 0xECDD, 0xEB29,
    0xEA38, 0xE929, 0xE86B, 0xE713, 0xE690, 0xE6BD, 0xE6E8, 0xE719, 0xE726, 0xE7BB, 0xE804, 0xE82C, 0xE824, 0xE856, 0xE8BF, 0xE8B7,
    0xE8B1, 0xE9C9, 0xECB5, 0xEFDA, 0xF377, 0xF794, 0xFAAA, 0xFE18, 0x00BB, 0x0261, 0x0368, 0x03C0, 0x03D2, 0x0456, 0x06D1, 0x09A5,
    0x0EB6, 0x149A, 0x1992, 0x1EB8, 0x2313, 0x2719, 0x2BA0, 0x2FA9, 0x321C, 0x3435, 0x3467, 0x33C8, 0x333E, 0x32BC, 0x3244, 0x3193,
    0x321F, 0x30BC, 0x2D7C, 0x287D, 0x21E8, 0x1B76, 0x156F, 0x107E, 0x0CC8, 0x0ACE, 0x0884, 0x06E1, 0x03CF, 0xFEA3, 0xF8E3, 0xF1D6,
    0xEC1C, 0xE72D, 0xE40E, 0xE223, 0xE068, 0xDEE5, 0xDCE2, 0xDAFA, 0xD7AE, 0xD53D, 0xD2F5, 0xD0DB, 0xD137, 0xD1EE, 0xD2ED, 0xD334,
    0xD42C, 0xD4CA, 0xD4F5, 0xD68E, 0xD734, 0xD894, 0xDAE6, 0xDD6E, 0xE081, 0xE4A1, 0xE8E5, 0xEDE7, 0xF26D, 0xF618, 0xFA21, 0xFC4D,
    0xFE9E, 0x0201, 0x05D0, 0x0BAC, 0x11D6, 0x16E2, 0x1A00, 0x1D8A, 0x2291, 0x278D, 0x2B9E, 0x2F21, 0x31F3, 0x32E8, 0x32D6, 0x31CE,
    0x31B0, 0x310C, 0x311F, 0x3294, 0x322B, 0x3282, 0x3191, 0x2E88, 0x2AE6, 0x2674, 0x23CE, 0x211B, 0x1F87, 0x1F42, 0x1EA9, 0x1CA7,
    0x18D9, 0x1527, 0x0F46, 0x0927, 0x039E, 0xFE41, 0xF9C9, 0xF75F, 0xF61D, 0xF5EA, 0xF605, 0xF4E5, 0xF3D6, 0xF254, 0xF10A, 0xF001,
    0xEE43, 0xED25, 0xEC63, 0xEAB8, 0xE96E, 0xE820, 0xE691, 0xE4F4, 0xE37D, 0xE1AC, 0xE07A, 0xE07E, 0xE1E5, 0xE3FD, 0xE540, 0xE744,
    0xE818, 0xE9B1, 0xEBBA, 0xECEA, 0xEED8, 0xF16F, 0xF27D, 0xF38F, 0xF4FF, 0xF5FA, 0xF8BC, 0xFA49, 0xFCD0, 0xFFB7, 0x0397, 0x07F9,
    0x0BE0, 0x1034, 0x12C8, 0x1598, 0x1853, 0x1B32, 0x1FD9, 0x24D5, 0x29A7, 0x2DEC, 0x30B5, 0x31CA, 0x3097, 0x2E98, 0x2D03, 0x2D68,
    0x2E08, 0x2EC6, 0x2EDC, 0x2D9B, 0x2BE5, 0x27F6, 0x22FF, 0x1D23, 0x16E6, 0x116F, 0x0D0B, 0x090B, 0x06D0, 0x0652, 0x05FA, 0x069C,
    0x072A, 0x0884, 0x0A36, 0x0B35, 0x0BBA, 0x0BE5, 0x0B8B, 0x0ADD, 0x09D2, 0x0668, 0x027E, 0xFE49, 0xFA31, 0xF6CF, 0xF2FE, 0xF0B5,
    0xF01C, 0xEFEE, 0xEFDF, 0xEF8F, 0xEF34, 0xEEA7, 0xEE9A, 0xEF8D, 0xEF88, 0xEF1D, 0xEF4A, 0xEE80, 0xEE71, 0xEED3, 0xEF4D, 0xF182,
    0xF451, 0xF808, 0xFA71, 0xFC15, 0xFC04, 0xFA89, 0xF9B9, 0xF923, 0xFA56, 0xFD84, 0x01E5, 0x068C, 0x0AE1, 0x0D9E, 0x0F53, 0x0F69,
    0x0D6F, 0x0B68, 0x0A79, 0x0A0F, 0x0A72, 0x0B59, 0x0C46, 0x0CA4, 0x0CA6, 0x0BB1, 0x0A3B, 0x07BF, 0x046D, 0x01F3, 0xFFD9, 0xFF24,
    0xFF04, 0x004A, 0x0166, 0x02C0, 0x0470, 0x04C2, 0x057B, 0x04D7, 0x031A, 0x0175, 0xFF5B, 0xFD5C, 0xFB84, 0xF8D3, 0xF5FB, 0xF2C9,
    0xEF8B, 0xEE33, 0xED8A, 0xEE04, 0xEFF7, 0xF2F0, 0xF4DB, 0xF6F1, 0xF989, 0xFAEF, 0xFC92, 0xFEFF, 0x0091, 0x0203, 0x03E3, 0x04C4,
    0x047F, 0x04A0, 0x065F, 0x08F4, 0x0D33, 0x1131, 0x14CC, 0x16F7, 0x1821, 0x1811, 0x179E, 0x17EF, 0x1864, 0x1B11, 0x1D87, 0x206F,
    0x2346, 0x247D, 0x2503, 0x2463, 0x21EB, 0x1E22, 0x1B11, 0x1856, 0x166E, 0x147C, 0x1229, 0x0FB8, 0x0C2D, 0x091C, 0x068A, 0x03B3,
    0x00DB, 0xFE76, 0xFB95, 0xF8E1, 0xF66D, 0xF4B3, 0xF35E, 0xF1E1, 0xF0B9, 0xEE4B, 0xEBE1, 0xE935, 0xE6AC, 0xE51B, 0xE4C3, 0xE431,
    0xE33B, 0xE19A, 0xDFB2, 0xDE6F, 0xDDEC, 0xDF6A, 0xE203, 0xE568, 0xE8D5, 0xECB2, 0xF0A7, 0xF4B5, 0xF782, 0xFA89, 0xFD58, 0x0059,
    0x042E, 0x0646, 0x0791, 0x0815, 0x0830, 0x088B, 0x0A40, 0x0D7E, 0x12A8, 0x188C, 0x1E83, 0x239C, 0x2737, 0x2A29, 0x2CF4, 0x2F42,
    0x3202, 0x355F, 0x38D6, 0x3B5E, 0x3BF0, 0x3B9F, 0x396E, 0x36D8, 0x3368, 0x2FBE, 0x2BCD, 0x281F, 0x2496, 0x206D, 0x1C9E, 0x17ED,
    0x12ED, 0x0DB8, 0x0903, 0x0493, 0xFFD5, 0xFB03, 0xF609, 0xF177, 0xED23, 0xE954, 0xE6FB, 0xE517, 0xE323, 0xE133, 0xDE7A, 0xDBD7,
    0xD93A, 0xD667, 0xD389, 0xD11E, 0xCF7A, 0xCE79, 0xCD8E, 0xCC51, 0xCB4A, 0xCBAA, 0xCD33, 0xCF65, 0xD25C, 0xD502, 0xD7D7, 0xDA99,
    0xDD9A, 0xE081, 0xE3E9, 0xE7CB, 0xEB10, 0xEE67, 0xF034, 0xF1D0, 0xF32D, 0xF595, 0xF93C, 0xFF1D, 0x06CF, 0x0ECA, 0x160D, 0x1C12,
    0x2056, 0x22E3, 0x25C5, 0x2854, 0x2B67, 0x2EAF, 0x3236, 0x34FA, 0x366B, 0x3667, 0x355C, 0x339B, 0x31B5, 0x2F90, 0x2DAA, 0x2C54,
    0x2B2B, 0x2A3D, 0x28DA, 0x2796, 0x24DC, 0x22E4, 0x2002, 0x1CE9, 0x1962, 0x1489, 0x10CF, 0x0CC0, 0x08DE, 0x055E, 0x0277, 0xFF81,
    0xFCFC, 0xFA2D, 0xF7D2, 0xF52E, 0xF2BF, 0xF0B4, 0xEE2A, 0xEC7D, 0xEAD4, 0xE8B5, 0xE664, 0xE355, 0xE162, 0xE10E, 0xE25B, 0xE408,
    0xE4FF, 0xE614, 0xE58A, 0xE4C9, 0xE4EA, 0xE4BE, 0xE565, 0xE6A9, 0xE671, 0xE6E8, 0xE736, 0xE735, 0xE7AC, 0xE92F, 0xEBE6, 0xEF1B,
    0xF3DC, 0xF7BD, 0xFB11, 0xFD70, 0xFDA8, 0xFDDB, 0xFE79, 0xFFBE, 0x0270, 0x067E, 0x0B91, 0x1082, 0x1409, 0x15F0, 0x1727, 0x17B1,
    0x1969, 0x1B95, 0x1EBA, 0x2266, 0x259E, 0x2859, 0x299D, 0x29ED, 0x2979, 0x2892, 0x26D0, 0x2457, 0x213D, 0x1DAD, 0x19A7, 0x1626,
    0x1280, 0x0F5D, 0x0C83, 0x0963, 0x06EE, 0x045B, 0x0270, 0x01C3, 0x015B, 0x01EB, 0x01DE, 0x0184, 0x0184, 0x006D, 0xFFCC, 0xFEDA,
    0xFD9D, 0xFD3A, 0xFD65, 0xFDC1, 0xFDE6, 0xFE45, 0xFDB7, 0xFD09, 0xFC78, 0xFAF5, 0xF9EF, 0xF8A7, 0xF712, 0xF4D3, 0xF241, 0xEF4E,
    0xED1C, 0xEBC6, 0xEBE8, 0xEDDC, 0xEFF7, 0xF258, 0xF3AD, 0xF414, 0xF3CF, 0xF24E, 0xF17D, 0xF163, 0xF13C, 0xF1AE, 0xF27F, 0xF325,
    0xF3FB, 0xF43F, 0xF45F, 0xF4FC, 0xF5B6, 0xF78E, 0xF9C9, 0xFB5E, 0xFD71, 0xFF56, 0x00F3, 0x0248, 0x031E, 0x0314, 0x0253, 0x016A,
    0x005C, 0xFFD1, 0xFEAA, 0xFDEA, 0xFD07, 0xFBE3, 0xFB7E, 0xFB05, 0xFAA2, 0xFA8D, 0xFB0A, 0xFBBC, 0xFD66, 0xFE35, 0xFE80, 0xFD73,
    0xFB02, 0xF862, 0xF526, 0xF233, 0xEFDE, 0xEDD4, 0xEC50, 0xEC47, 0xEC25, 0xEC58, 0xED0B, 0xEE15, 0xF012, 0xF299, 0xF57B, 0xF790,
    0xF8AB, 0xF8FF, 0xF875, 0xF77A, 0xF6DD, 0xF7D2, 0xFA48, 0xFE98, 0x02A1, 0x0648, 0x09E2, 0x0BD7, 0x0DFA, 0x0F6F, 0x10F1, 0x134C,
    0x15F1, 0x1879, 0x1B08, 0x1DAB, 0x1F17, 0x2007, 0x2080, 0x1FE5, 0x1F32, 0x1F62, 0x2025, 0x2111, 0x216D, 0x211B, 0x1FEF, 0x1D88,
    0x1A86, 0x16E0, 0x1233, 0x0D52, 0x0851, 0x03E5, 0xFFAA, 0xFC6E, 0xF9F7, 0xF744, 0xF4BA, 0xF121, 0xEDDC, 0xEAEF, 0xE999, 0xE8AB,
    0xE828, 0xE7B0, 0xE5C8, 0xE3B0, 0xDFB5, 0xDC4C, 0xDA2E, 0xD8B2, 0xD82E, 0xD85E, 0xD83A, 0xD8AD, 0xDA1C, 0xDCAE, 0xDFCF, 0xE456,
    0xE978, 0xEEA5, 0xF3CD, 0xF6F6, 0xF8B6, 0xF890, 0xF748, 0xF657, 0xF6AA, 0xF820, 0xFB32, 0xFE9C, 0x0193, 0x043B, 0x0696, 0x0841,
    0x0944, 0x0AC7, 0x0D9B, 0x11CC, 0x16DA, 0x1C12, 0x21A4, 0x26B5, 0x2AEA, 0x2EB4, 0x319D, 0x3357, 0x3417, 0x354D, 0x35FE, 0x3644,
    0x3680, 0x3652, 0x3595, 0x33E6, 0x3169, 0x2CE7, 0x2743, 0x2063, 0x18BE, 0x11D5, 0x0BF6, 0x073C, 0x033E, 0xFF1A, 0xFABC, 0xF67B,
    0xF321, 0xEFC8, 0xEC87, 0xE9D6, 0xE6F1, 0xE3AF, 0xE035, 0xDB75, 0xD624, 0xD0B7, 0xCC11, 0xC923, 0xC772, 0xC6A4, 0xC637, 0xC5C1,
    0xC62B, 0xC748, 0xC8A9, 0xCB83, 0xCEF3, 0xD2C3, 0xD618, 0xD7DF, 0xD8CA, 0xD81F, 0xD74F, 0xD71F, 0xD7A3, 0xD9FD, 0xDD0C, 0xE182,
    0xE63B, 0xEA63, 0xEEC4, 0xF2DF, 0xF747, 0xFC25, 0x0258, 0x099D, 0x100E, 0x1611, 0x1C73, 0x212F, 0x25BA, 0x2953, 0x2B0A, 0x2CA4,
    0x2CB3, 0x2C5A, 0x2CAA, 0x2CD2, 0x2D3B, 0x2D86, 0x2DC2, 0x2D78, 0x2BFF, 0x2A10, 0x26CB, 0x2304, 0x1FA2, 0x1C20, 0x1928, 0x1669,
    0x1330, 0x10AA, 0x0D36, 0x0A57, 0x082C, 0x056C, 0x049B, 0x037D, 0x02AE, 0x018C, 0xFF8E, 0xFCA7, 0xF86F, 0xF3BD, 0xEFB3, 0xEC39,
    0xEA9C, 0xE9E1, 0xE820, 0xE6D6, 0xE57D, 0xE59A, 0xE7FD, 0xEAE6, 0xEEB4, 0xF29E, 0xF441, 0xF490, 0xF2E0, 0xEED5, 0xEA01, 0xE5A0,
    0xE2C8, 0xE1BB, 0xE221, 0xE343, 0xE521, 0xE6F4, 0xE833, 0xE9D0, 0xEB92, 0xED1F, 0xEFB6, 0xF2EB, 0xF60A, 0xF97E, 0xFCA1, 0xFEF5,
    0x0055, 0x0124, 0x0235, 0x039A, 0x0504, 0x05DC, 0x0691, 0x0836, 0x0AF4, 0x0E8E, 0x12BD, 0x1684, 0x19F9, 0x1CC9, 0x1DA3, 0x1E0C,
    0x1E1D, 0x1D73, 0x1CD9, 0x1B2C, 0x18B6, 0x15EF, 0x128D, 0x0F87, 0x0CAB, 0x0B08, 0x0A35, 0x0909, 0x07C8, 0x0614, 0x0432, 0x01B1,
    0xFEDF, 0xFC0D, 0xF9D5, 0xF871, 0xF79E, 0xF700, 0xF71E, 0xF718, 0xF73E, 0xF99C, 0xFC35, 0x0018, 0x04BD, 0x08F4, 0x0C01, 0x0CC7,
    0x0BBD, 0x086C, 0x0407, 0xFF94, 0xFBA9, 0xF931, 0xF77B, 0xF68F, 0xF688, 0xF674, 0xF638, 0xF62F, 0xF716, 0xF7F8, 0xF942, 0xFAB6,
    0xFBE7, 0xFCAB, 0xFD77, 0xFE8F, 0xFE35, 0xFDBE, 0xFCC8, 0xFBCC, 0xFA32, 0xF854, 0xF70D, 0xF659, 0xF70C, 0xF82C, 0xF8F0, 0xF9F5,
    0xFA05, 0xF8CB, 0xF863, 0xF73A, 0xF617, 0xF59F, 0xF479, 0xF36B, 0xF1E1, 0xF0C0, 0xEF72, 0xEE60, 0xEE72, 0xEF0E, 0xF02F, 0xF1D0,
    0xF35A, 0xF40E, 0xF41A, 0xF3E2, 0xF3F4, 0xF38B, 0xF32D, 0xF287, 0xF17A, 0xF0F4, 0xEFC5, 0xEDD1, 0xECA1, 0xEBF7, 0xEC30, 0xEE4E,
    0xF0D4, 0xF389, 0xF5B1, 0xF6CF, 0xF69D, 0xF515, 0xF3E9, 0xF2D6, 0xF292, 0xF3A9, 0xF535, 0xF746, 0xF90D, 0xFA53, 0xFB24, 0xFCB6,
    0xFEB2, 0x00E5, 0x0535, 0x0A40, 0x0F71, 0x1521, 0x1985, 0x1C45, 0x1E12, 0x1F08, 0x1F24, 0x1EA1, 0x1E93, 0x1E8B, 0x1EDB, 0x1F71,
    0x206D, 0x2217, 0x23CE, 0x253B, 0x2502, 0x23E0, 0x21F4, 0x1F34, 0x1BBE, 0x175C, 0x12D9, 0x0DEA, 0x08EA, 0x03B9, 0xFF59, 0xFC70,
    0xFABD, 0xFA6B, 0xFACA, 0xFA2E, 0xF8DA, 0xF731, 0xF495, 0xF241, 0xF075, 0xEE9F, 0xEC43, 0xE924, 0xE55D, 0xE097, 0xDC54, 0xD937,
    0xD698, 0xD58B, 0xD5DB, 0xD765, 0xDAC3, 0xDE9E, 0xE1B9, 0xE34E, 0xE39D, 0xE411, 0xE462, 0xE486, 0xE4E7, 0xE5AA, 0xE7A8, 0xE9BE,
    0xEB31, 0xEC8C, 0xEDDD, 0xEEF1, 0xF0F3, 0xF4A8, 0xF935, 0xFDC8, 0x0332, 0x0907, 0x0E0F, 0x1347, 0x18B0, 0x1D15, 0x1FE3, 0x2214,
    0x2470, 0x274E, 0x2A6A, 0x2D66, 0x3050, 0x3390, 0x367B, 0x384A, 0x3A01, 0x3A33, 0x3855, 0x369E, 0x3411, 0x2FE9, 0x2A0C, 0x23BC,
    0x1C17, 0x1330, 0x0B04, 0x0492, 0x0096, 0xFE25, 0xFC69, 0xFB44, 0xFA7F, 0xF8F9, 0xF7CE, 0xF56C, 0xF227, 0xEEE3, 0xEAC6, 0xE5E5,
    0xE023, 0xDA4B, 0xD49C, 0xD060, 0xCDE7, 0xCD17, 0xCE7B, 0xD102, 0xD437, 0xD769, 0xD9CB, 0xDB13, 0xDB81, 0xDB16, 0xDA45, 0xD984,
    0xD8A1, 0xD811, 0xD7D7, 0xD7BF, 0xD779, 0xD810, 0xD97A, 0xDA8A, 0xDC84, 0xDF5E, 0xE31C, 0xE7DF, 0xED9F, 0xF4ED, 0xFCDB, 0x047B,
    0x0B93, 0x1119, 0x159F, 0x1984, 0x1CF3, 0x20EB, 0x241E, 0x26B3, 0x2960, 0x2B1E, 0x2C72, 0x2D72, 0x2DA4, 0x2D8C, 0x2DBB, 0x2DA6,
    0x2C9D, 0x2A6C, 0x271E, 0x2286, 0x1D20, 0x1851, 0x13BF, 0x103C, 0x0E15, 0x0C4D, 0x0B2C, 0x09E3, 0x093D, 0x08B4, 0x0803, 0x0793,
    0x06AE, 0x062D, 0x059C, 0x02DE, 0xFE1B, 0xF816, 0xF17D, 0xEC1A, 0xE880, 0xE752, 0xE843, 0xEAEB, 0xEDEE, 0xF0EF, 0xF38B, 0xF5AF,
    0xF622, 0xF626, 0xF636, 0xF46A, 0xF2BE, 0xF04B, 0xED8E, 0xEB3A, 0xE8E0, 0xE74C, 0xE63D, 0xE557, 0xE511, 0xE584, 0xE787, 0xEB2A,
    0xEF3D, 0xF428, 0xF9CC, 0xFE96, 0x034A, 0x067A, 0x08A7, 0x0A12, 0x0A06, 0x0ADF, 0x0B8D, 0x0C4C, 0x0D85, 0x0EBE, 0x0FF1, 0x10C4,
    0x117F, 0x12BE, 0x1348, 0x1437, 0x1508, 0x14B1, 0x13B9, 0x1211, 0x10A0, 0x0EDE, 0x0DCB, 0x0D47, 0x0C5F, 0x0C31, 0x0B37, 0x09A0,
    0x0896, 0x070F, 0x06A4, 0x0702, 0x0733, 0x06D5, 0x065F, 0x04C6, 0x0121, 0xFC70, 0xF760, 0xF342, 0xF0DF, 0xF03C, 0xF152, 0xF416,
    0xF81F, 0xFCDF, 0x006D, 0x03C4, 0x067F, 0x07C3, 0x08EC, 0x0999, 0x094C, 0x07B4, 0x0534, 0x02B3, 0xFFC0, 0xFC55, 0xF918, 0xF613,
    0xF3AA, 0xF2A0, 0xF341, 0xF540, 0xF91F, 0xFE19, 0x0357, 0x07FE, 0x0A98, 0x0B79, 0x0B13, 0x0983, 0x07FE, 0x0688, 0x05C2, 0x0595,
    0x0517, 0x043B, 0x0342, 0x0231, 0x01BF, 0x0175, 0x015F, 0x0161, 0x009A, 0xFED4, 0xFBE2, 0xF894, 0xF4E4, 0xF232, 0xEFFE, 0xEF00,
    0xEFB1, 0xEFDC, 0xEFE8, 0xEF9D, 0xF008, 0xF1E6, 0xF47A, 0xF75D, 0xFAB9, 0xFC81, 0xFD6D, 0xFDAE, 0xFB9B, 0xF868, 0xF3A0, 0xEF54,
    0xEC71, 0xEBA2, 0xEC79, 0xEDE6, 0xEF86, 0xF0CB, 0xF1B1, 0xF252, 0xF2C2, 0xF2F4, 0xF30F, 0xF329, 0xF402, 0xF316, 0xF1C9, 0xF188,
    0xF0F0, 0xF0E8, 0xF0CD, 0xF0DE, 0xF18E, 0xF288, 0xF424, 0xF7A1, 0xFCB3, 0x0364, 0x09F5, 0x10A1, 0x1652, 0x1A73, 0x1E41, 0x209D,
    0x2209, 0x2196, 0x2109, 0x20DE, 0x2026, 0x1F7A, 0x1F0C, 0x1FC2, 0x2023, 0x2250, 0x24F7, 0x2693, 0x2737, 0x2623, 0x2359, 0x1EB9,
    0x1AA2, 0x15A1, 0x11DC, 0x0E4D, 0x0B43, 0x0819, 0x04E3, 0x025C, 0x0083, 0x0087, 0x016A, 0x03C1, 0x04D5, 0x055E, 0x04A1, 0x0150,
    0xFD15, 0xF7D7, 0xF1C3, 0xEDB5, 0xE9CC, 0xE79E, 0xE5DD, 0xE5C4, 0xE42C, 0xE3BF, 0xE26A, 0xE1E1, 0xE129, 0xDEAA, 0xDF45, 0xDEC4,
    0xDC1B, 0xD9F4, 0xE13C, 0xE127, 0xF5D8, 0x01C0, 0xF51F, 0xF7C6, 0xEF45, 0xEA18, 0xE51A, 0xDE16, 0xDB40, 0xDAFB, 0xDF70, 0xE4B6,
    0xF031, 0xE17F, 0xDA6D, 0xD9C3, 0xD830, 0xE927, 0xEB49, 0xEDA5, 0xF796, 0xFC47, 0xFE94, 0x0B3B, 0x119F, 0x1182, 0x18FF, 0x1EF5,
    0x1DBC, 0x2645, 0x1379, 0xFCE6, 0x009E, 0xFD0D, 0x04A7, 0x082E, 0x0655, 0x0BDB, 0x11B0, 0x0F68, 0x1554, 0x14D3, 0x1283, 0x2C6D,
    0x3BD2, 0x410A, 0x487F, 0x3A1E, 0x29C5, 0x1E43, 0x0C78, 0xFAA3, 0xEE5D, 0xE04F, 0xDDF4, 0xD744, 0xC616, 0xC397, 0xBDEE, 0xC26A,
    0xCC9A, 0xCA5F, 0xCECE, 0xDA14, 0xD8FE, 0xDB1D, 0xE0A3, 0xE048, 0xDCC3, 0xDDE0, 0xD5A2, 0xD779, 0xD7E3, 0xC158, 0xBBE7, 0xB9E2,
    0xBE3B, 0xC900, 0xCF26, 0xD7EE, 0xE7B7, 0xF12E, 0xFCC2, 0x0D38, 0x0DAE, 0x1BC3, 0x367E, 0x421A, 0x4FC9, 0x5348, 0x4ABE, 0x4654,
    0x4172, 0x37CC, 0x32E3, 0x2B74, 0x26B3, 0x2B25, 0x1D1D, 0x110F, 0x0704, 0xFC70, 0x02EB, 0x05ED, 0xFF07, 0x03F4, 0x0615, 0x0264,
    0x035F, 0x075F, 0x02F1, 0x0422, 0x02FE, 0xFC7D, 0x0806, 0xFD6F, 0xEB6E, 0xDFF4, 0xD5C3, 0xD58D, 0xD648, 0xD27A, 0xD444, 0xD6B4,
    0xD1E2, 0xD764, 0xD5FD, 0xCEB1, 0xDB78, 0xE573, 0xEC55, 0xF628, 0xF11B, 0xE36B, 0xD86A, 0xC879, 0xBA27, 0xB0B3, 0xA36B, 0xA32D,
    0x9EDE, 0x96CF, 0x948E, 0x910A, 0x92BF, 0x9A88, 0x9C43, 0x9F91, 0xA74B, 0xAB81, 0xAFD8, 0xB7C9, 0xBBD4, 0xBFC5, 0xCA68, 0xC7ED,
    0xD10A, 0xDA6E, 0xD501, 0xD1CF, 0xD0E4, 0xD78B, 0xE67F, 0xF3D1, 0x000A, 0x14FE, 0x2257, 0x2F16, 0x425D, 0x4475, 0x4952, 0x590E,
    0x62BF, 0x6D39, 0x74C9, 0x736D, 0x7132, 0x6F69, 0x6957, 0x6895, 0x6310, 0x601E, 0x64C7, 0x61AF, 0x5DA9, 0x5813, 0x4CF3, 0x4D8C,
    0x5030, 0x4A25, 0x4A55, 0x4F2E, 0x4F04, 0x500F, 0x5610, 0x5481, 0x59E8, 0x5921, 0x5581, 0x5E0C, 0x6031, 0x5D5F, 0x58C1, 0x53EF,
    0x543C, 0x57BF, 0x557E, 0x55E7, 0x5851, 0x5416, 0x58EC, 0x5B11, 0x546E, 0x55D9, 0x5A8C, 0x5FAC, 0x6675, 0x6A1A, 0x6661, 0x642D,
    0x5D35, 0x574C, 0x50C8, 0x4415, 0x3EE7, 0x3A53, 0x3291, 0x2E38, 0x244B, 0x1B1E, 0x1C57, 0x1B3A, 0x1763, 0x16E5, 0x1800, 0x1293,
    0x13B3, 0x1027, 0x0B1B, 0x0A5B, 0xFCF9, 0xF434, 0xF0B9, 0xE9B2, 0xDF63, 0xD25A, 0xC806, 0xC698, 0xC69C, 0xC494, 0xC8C2, 0xC876,
    0xC7B4, 0xCD0F, 0xCB20, 0xC690, 0xC655, 0xC7D1, 0xCB51, 0xD25C, 0xD258, 0xD0A4, 0xCD2B, 0xC6ED, 0xC56B, 0xBEE3, 0xB8ED, 0xB8E9,
    0xB7E1, 0xB823, 0xB6BA, 0xAFDF, 0xADF9, 0xAF83, 0xAFBF, 0xAEF9, 0xB2A1, 0xB329, 0xB503, 0xB932, 0xB8A5, 0xBDC3, 0xBF74, 0xBD25,
    0xC044, 0xC595, 0xC822, 0xC7CA, 0xC304, 0xBF76, 0xC283, 0xC24B, 0xC489, 0xCA18, 0xCA2E, 0xD03F, 0xD805, 0xD932, 0xDA27, 0xDE98,
    0xE32B, 0xEDEB, 0xF991, 0xFFFE, 0x0504, 0x0201, 0xFF23, 0xFB5D, 0xF061, 0xE89D, 0xE4F9, 0xE1FF, 0xE36D, 0xE022, 0xD96B, 0xD91C,
    0xDE08, 0xDFFB, 0xE572, 0xEBA0, 0xED46, 0xF472, 0xF59A, 0xF69C, 0xFC72, 0xFB1E, 0xF772, 0xF91B, 0xFCAE, 0xFE12, 0xFADA, 0xF0FF,
    0xECE0, 0xEDCA, 0xED09, 0xF53C, 0xFBAB, 0x00B0, 0x0CBB, 0x17B4, 0x1BFD, 0x1F4B, 0x22B8, 0x28B4, 0x35B9, 0x3F5E, 0x4826, 0x4B59,
    0x494D, 0x4A91, 0x4821, 0x4200, 0x4200, 0x4302, 0x4735, 0x4C68, 0x4AAA, 0x46CD, 0x48F7, 0x4C11, 0x4C32, 0x526E, 0x54F0, 0x5939,
    0x603F, 0x6139, 0x6505, 0x68AB, 0x65E7, 0x6490, 0x679C, 0x69F3, 0x6AC8, 0x6442, 0x5976, 0x5544, 0x4E58, 0x4953, 0x499B, 0x45D3,
    0x43F4, 0x4821, 0x49A5, 0x4765, 0x46F7, 0x451D, 0x4929, 0x4ECC, 0x52E8, 0x55CF, 0x5008, 0x492F, 0x4454, 0x3950, 0x2F79, 0x27FD,
    0x2154, 0x1EE0, 0x1BD1, 0x11FF, 0x065C, 0x036E, 0xFED7, 0xFEB9, 0x01BB, 0x014C, 0x0617, 0x0788, 0x054A, 0x0728, 0x0676, 0xFFEF,
    0xFA96, 0xF7D8, 0xF73D, 0xF602, 0xEA77, 0xE0C0, 0xDB8D, 0xD54E, 0xD6FB, 0xDAEC, 0xDCF0, 0xE2AE, 0xEB7A, 0xF012, 0xF495, 0xF68C,
    0xF962, 0x02D6, 0x0ECC, 0x1CCD, 0x2687, 0x274D, 0x2895, 0x2722, 0x1FD5, 0x19DC, 0x13F1, 0x10AC, 0x1130, 0x0FEA, 0x0444, 0xFAC9,
    0xF397, 0xEA87, 0xE763, 0xE28D, 0xDFD4, 0xE13D, 0xDFA7, 0xDF68, 0xE364, 0xE3F4, 0xE065, 0xDE08, 0xDBE8, 0xDE65, 0xDB6E, 0xCFB4,
    0xC84F, 0xC030, 0xBA86, 0xBACE, 0xBAC0, 0xB8FA, 0xBB17, 0xBDA3, 0xBEB9, 0xBF6E, 0xBDB8, 0xC011, 0xC6A5, 0xCF24, 0xDAEE, 0xE079,
    0xDFF4, 0xDF36, 0xD98D, 0xD1B9, 0xC9F1, 0xC2E2, 0xBDDF, 0xBE61, 0xBAE5, 0xB3D6, 0xB19A, 0xAECB, 0xAF6C, 0xB19C, 0xB276, 0xB5E9,
    0xB953, 0xB9BA, 0xBCAF, 0xC1EF, 0xC382, 0xC4A1, 0xC6C5, 0xCD15, 0xD5CE, 0xD4FB, 0xD08B, 0xCC8D, 0xC669, 0xC41B, 0xC725, 0xC819,
    0xCA24, 0xCFA4, 0xD3E1, 0xD839, 0xD889, 0xD5F7, 0xD6D5, 0xD988, 0xE0CF, 0xEB60, 0xEFBB, 0xF352, 0xF5C1, 0xF4F4, 0xF1E7, 0xEDF8,
    0xE83C, 0xE5E8, 0xE7D0, 0xE17D, 0xDAC9, 0xD589, 0xD025, 0xCFB7, 0xCF27, 0xCE4A, 0xD13E, 0xD2F6, 0xD2B2, 0xD71A, 0xDC1B, 0xDF04,
    0xE155, 0xE151, 0xE894, 0xF124, 0xF186, 0xEFE6, 0xECF6, 0xE754, 0xE6F5, 0xEA3B, 0xEA8C, 0xEDAB, 0xF21C, 0xF7C7, 0xFDE2, 0xFFA1,
    0x0116, 0x04FD, 0x0AFA, 0x17D2, 0x2274, 0x2712, 0x2A41, 0x2B51, 0x297B, 0x2636, 0x21A1, 0x1A8D, 0x1BD0, 0x1DD8, 0x19A4, 0x1637,
    0x0FDC, 0x0C93, 0x0DCE, 0x0D9F, 0x0FC8, 0x141B, 0x15A8, 0x165E, 0x1A47, 0x1BD6, 0x1C5A, 0x189A, 0x1483, 0x1875, 0x1C09, 0x1AB8,
    0x18CC, 0x1413, 0x0DA4, 0x0E0C, 0x0F3E, 0x1041, 0x13A3, 0x1780, 0x1E23, 0x237B, 0x242E, 0x25EB, 0x26E8, 0x2C7E, 0x373E, 0x3F04,
    0x4385, 0x462D, 0x469E, 0x4400, 0x4256, 0x3BA6, 0x35D7, 0x38AD, 0x388A, 0x35F7, 0x323E, 0x2BDE, 0x28D1, 0x2757, 0x2476, 0x2452,
    0x2659, 0x25AD, 0x27F4, 0x2C2B, 0x31BD, 0x3763, 0x3695, 0x383B, 0x3F7A, 0x4348, 0x43E4, 0x437D, 0x3E4B, 0x3ADD, 0x3C13, 0x3DC6,
    0x401E, 0x42E6, 0x475F, 0x4EB1, 0x51D4, 0x5302, 0x5408, 0x53CC, 0x592B, 0x6159, 0x661C, 0x6727, 0x6726, 0x62F4, 0x5D74, 0x5666,
    0x4A84, 0x42EA, 0x3EC5, 0x3A60, 0x35DA, 0x2D8F, 0x24D0, 0x20DF, 0x1E57, 0x1B24, 0x1C5D, 0x1CA0, 0x1B2E, 0x1C3A, 0x1C95, 0x1F71,
    0x1EF2, 0x18A8, 0x16A7, 0x190D, 0x18CF, 0x17CD, 0x1356, 0x09C6, 0x037C, 0x0045, 0xFE26, 0xFD87, 0xFD10, 0x003E, 0x0519, 0x06DF,
    0x081D, 0x0510, 0x0220, 0x04A8, 0x0A84, 0x0F2D, 0x134A, 0x1693, 0x1620, 0x170E, 0x1316, 0x0B04, 0x0807, 0x0780, 0x06E6, 0x05EE,
    0x01BE, 0xFDD9, 0xFDD5, 0xFCE8, 0xFD50, 0x01A1, 0x044D, 0x07B7, 0x0AFB, 0x0FAA, 0x1759, 0x18B9, 0x157C, 0x16AF, 0x1957, 0x19AF,
    0x1931, 0x125F, 0x0740, 0xFE21, 0xF71B, 0xF276, 0xEF4E, 0xED6F, 0xF090, 0xF426, 0xF669, 0xF6F9, 0xF39B, 0xF146, 0xF45F, 0xF9C6,
    0xFCD0, 0xFFE5, 0xFDD6, 0xF92B, 0xF455, 0xE89B, 0xDC10, 0xD3AE, 0xCDFC, 0xCAD5, 0xC6B6, 0xBF89, 0xBA62, 0xB738, 0xB344, 0xB29F,
    0xB371, 0xB412, 0xB4D3, 0xB4D0, 0xB6D8, 0xB94D, 0xB615, 0xB1B1, 0xB12A, 0xB0A2, 0xB12D, 0xB145, 0xAD55, 0xA92E, 0xA64C, 0xA511,
    0xA5ED, 0xA567, 0xA7A6, 0xAC35, 0xB0CE, 0xB5D0, 0xB8AE, 0xB9BC, 0xBBDC, 0xC294, 0xCA2B, 0xD2A6, 0xDB42, 0xDF2E, 0xE406, 0xE6AF,
    0xE383, 0xE00C, 0xDE03, 0xDDA4, 0xDD8E, 0xD9DA, 0xD29C, 0xCD6D, 0xC837, 0xC3B0, 0xC2B5, 0xC2AA, 0xC3EE, 0xC525, 0xC5BA, 0xCA64,
    0xCDB1, 0xCB9C, 0xCA89, 0xCB42, 0xCC69, 0xCE7B, 0xCE4A, 0xC927, 0xC317, 0xBD9C, 0xBADA, 0xB93E, 0xB780, 0xB8E8, 0xBBDE, 0xBF9D,
    0xC2D6, 0xC432, 0xC2CA, 0xC435, 0xCA31, 0xD0F8, 0xDAEB, 0xE182, 0xE3CD, 0xE679, 0xE445, 0xDCE6, 0xD621, 0xD175, 0xCF9E, 0xD017,
    0xCDAF, 0xCABC, 0xC8FF, 0xC639, 0xC53D, 0xC632, 0xC859, 0xCB31, 0xCC9D, 0xCF05, 0xD613, 0xDB2A, 0xDB90, 0xDD14, 0xDF86, 0xE43A,
    0xEAEC, 0xEDD2, 0xECB5, 0xE876, 0xE48F, 0xE411, 0xE24E, 0xE111, 0xE1FC, 0xE3EF, 0xE68B, 0xE939, 0xE9AA, 0xE6A5, 0xE88E, 0xEDD3,
    0xF613, 0x00EF, 0x075F, 0x0C3F, 0x1102, 0x1147, 0x0D95, 0x0962, 0x05EE, 0x0615, 0x0632, 0x0202, 0xFD6C, 0xF7FF, 0xF23C, 0xEEEC,
    0xED82, 0xEED1, 0xF13B, 0xF0C0, 0xF1F1, 0xF76D, 0xF9C7, 0xF9A2, 0xFA88, 0xFC1F, 0x009E, 0x05D8, 0x06FF, 0x040D, 0xFD32, 0xF802,
    0xF596, 0xF365, 0xF379, 0xF61A, 0xFB6C, 0x02CE, 0x0AE3, 0x0D33, 0x0DBA, 0x11D9, 0x17D1, 0x2230, 0x2C96, 0x328A, 0x3755, 0x3B1D,
    0x3A5B, 0x368D, 0x3186, 0x2E0C, 0x2FE6, 0x3102, 0x2F48, 0x2DA3, 0x2A9B, 0x2725, 0x243E, 0x2200, 0x2201, 0x20F4, 0x1BD4, 0x19E8,
    0x1BE0, 0x1ACB, 0x184F, 0x1578, 0x13C9, 0x161A, 0x187C, 0x199B, 0x15A9, 0x0E8E, 0x09D2, 0x0683, 0x03FE, 0x0217, 0x0250, 0x03B8,
    0x07F0, 0x0C33, 0x0B12, 0x0A9F, 0x0C56, 0x1127, 0x1B73, 0x24E9, 0x2B2E, 0x3149, 0x362F, 0x3708, 0x351B, 0x309A, 0x2F03, 0x30F6,
    0x301E, 0x2D8A, 0x29F1, 0x248D, 0x2043, 0x1D26, 0x1C89, 0x1FDB, 0x2107, 0x201A, 0x23FC, 0x29CC, 0x2CBF, 0x2ED0, 0x2F69, 0x321F,
    0x373D, 0x3CF5, 0x4120, 0x3F73, 0x3BAD, 0x3989, 0x386F, 0x37EF, 0x39DF, 0x3D4D, 0x424B, 0x4AEE, 0x50D8, 0x529B, 0x53F2, 0x53E0,
    0x5676, 0x5BDB, 0x5EDE, 0x5F79, 0x60DF, 0x604D, 0x5CD7, 0x5730, 0x4F8D, 0x4B08, 0x487D, 0x44E9, 0x41B3, 0x3D9C, 0x38AF, 0x34DB,
    0x30A1, 0x2F4E, 0x3053, 0x2D46, 0x2992, 0x2A36, 0x2B8D, 0x2C79, 0x2B50, 0x2841, 0x27AE, 0x28B5, 0x2B4A, 0x2B87, 0x26BE, 0x20B4,
    0x1C25, 0x1860, 0x157B, 0x1468, 0x129A, 0x1340, 0x1724, 0x1843, 0x176E, 0x15D8, 0x13D1, 0x16A4, 0x1D76, 0x226D, 0x2719, 0x2C4B,
    0x2F07, 0x2FA4, 0x2C1B, 0x276B, 0x262E, 0x267F, 0x2696, 0x2601, 0x23C1, 0x2173, 0x1EF6, 0x1C75, 0x1E77, 0x2330, 0x2500, 0x2782,
    0x2CE9, 0x3256, 0x3624, 0x35D3, 0x33F3, 0x325A, 0x3217, 0x3379, 0x322E, 0x2C1F, 0x2527, 0x1F8A, 0x1997, 0x158F, 0x1296, 0x0FCD,
    0x11F0, 0x171D, 0x1A36, 0x1B85, 0x1A68, 0x18DD, 0x1B5B, 0x1F9C, 0x2251, 0x24EC, 0x2684, 0x26CC, 0x2418, 0x1BE7, 0x12CE, 0x0CBE,
    0x07D2, 0x0463, 0x0049, 0xFB18, 0xF7C0, 0xF2B8, 0xEDFB, 0xEDD0, 0xED1B, 0xE966, 0xE716, 0xE6BC, 0xE7C6, 0xE765, 0xE4F5, 0xE1E0,
    0xDF67, 0xE03E, 0xE220, 0xE1C2, 0xDDA0, 0xD88D, 0xD445, 0xD05A, 0xCE41, 0xCBB8, 0xCA63, 0xCDEA, 0xD29C, 0xD6CB, 0xD9D0, 0xDA5C,
    0xDC6C, 0xE3BF, 0xED7A, 0xF83B, 0x02E7, 0x0C0B, 0x13D9, 0x163A, 0x1203, 0x0CC1, 0x090B, 0x061C, 0x03BD, 0xFFCF, 0xFB31, 0xF6B7,
    0xF043, 0xEB3C, 0xEADB, 0xE924, 0xE6E0, 0xE63A, 0xE7F0, 0xEAAA, 0xEAED, 0xE977, 0xE65C, 0xE3E2, 0xE3F2, 0xE58A, 0xE439, 0xDF3D,
    0xD9E0, 0xD355, 0xCDC3, 0xC9C8, 0xC531, 0xC38E, 0xC5F3, 0xC9D7, 0xCE12, 0xCFF5, 0xCE74, 0xCE3D, 0xD15C, 0xD58E, 0xDA13, 0xDE65,
    0xE206, 0xE593, 0xE4DF, 0xDF20, 0xD8EE, 0xD36D, 0xD049, 0xCDDD, 0xCA62, 0xC7A7, 0xC49E, 0xBFD1, 0xBDFE, 0xBED1, 0xBE9F, 0xBDE4,
    0xBD42, 0xBF26, 0xC1B3, 0xC30D, 0xC392, 0xC3A4, 0xC4E4, 0xC9DC, 0xCFFD, 0xD272, 0xD223, 0xD002, 0xCB82, 0xC7F2, 0xC45C, 0xBF90,
    0xBD73, 0xBE14, 0xBFDA, 0xC1D5, 0xC15F, 0xBE9F, 0xBE6A, 0xC102, 0xC58E, 0xCB58, 0xD0D1, 0xD6D3, 0xDC12, 0xDC59, 0xD886, 0xD383,
    0xCFA3, 0xCE15, 0xCC28, 0xC8E9, 0xC67A, 0xC1EC, 0xBB96, 0xB8A5, 0xB801, 0xB7C4, 0xB6EB, 0xB6F6, 0xB927, 0xBBC5, 0xBDF2, 0xBE21,
    0xBCC0, 0xBC31, 0xBF2E, 0xC2F2, 0xC3E3, 0xC385, 0xC101, 0xBE0F, 0xBCB0, 0xBA80, 0xB833, 0xB917, 0xBCAF, 0xC20F, 0xC837, 0xCB41,
    0xCCFD, 0xD042, 0xD5BC, 0xDCEB, 0xE390, 0xE96E, 0xF083, 0xF67C, 0xF742, 0xF49B, 0xF102, 0xEF54, 0xF051, 0xEFE6, 0xEECF, 0xEE09,
    0xE96F, 0xE32F, 0xDF89, 0xDD90, 0xDB8D, 0xD7D1, 0xD50A, 0xD473, 0xD4B3, 0xD501, 0xD3FC, 0xD17F, 0xD0A4, 0xD456, 0xD836, 0xDA19,
    0xD9F9, 0xD679, 0xD335, 0xD125, 0xCE11, 0xCB36, 0xCACB, 0xCC20, 0xCFA0, 0xD30A, 0xD2C6, 0xD1AD, 0xD1FD, 0xD5B1, 0xDC90, 0xE33E,
    0xEAC9, 0xF475, 0xFC54, 0xFFCC, 0xFE79, 0xFAA8, 0xF88A, 0xF800, 0xF620, 0xF4FD, 0xF37E, 0xEECD, 0xEA60, 0xE82F, 0xE87A, 0xE83F,
    0xE79F, 0xE88A, 0xEBCD, 0xF0BB, 0xF5FA, 0xF968, 0xF9AA, 0xFBDA, 0x016F, 0x072D, 0x0C1D, 0x0EAC, 0x0E2B, 0x0E65, 0x1015, 0x110E,
    0x12D0, 0x1644, 0x1B1A, 0x2331, 0x2A71, 0x2D04, 0x2DCD, 0x2E79, 0x3124, 0x356C, 0x3861, 0x3BE2, 0x40D3, 0x43FB, 0x4414, 0x4069,
    0x3A8F, 0x373F, 0x3475, 0x3099, 0x2E04, 0x2A82, 0x24EB, 0x1F3B, 0x1C86, 0x1C85, 0x1B57, 0x189F, 0x1698, 0x165B, 0x1799, 0x191C,
    0x18D2, 0x16D1, 0x18B6, 0x1DDA, 0x22C7, 0x26CF, 0x2735, 0x23DC, 0x210F, 0x1DEB, 0x1941, 0x1595, 0x12BC, 0x130E, 0x174A, 0x1A20,
    0x1AB4, 0x1975, 0x181F, 0x1A8F, 0x1F34, 0x23C7, 0x2A3B, 0x32A6, 0x39B8, 0x3D62, 0x3B8D, 0x37D3, 0x3632, 0x33BE, 0x3165, 0x31AE,
    0x3187, 0x3011, 0x2ED1, 0x30CF, 0x3534, 0x3810, 0x3A2B, 0x3D2C, 0x40B5, 0x44F2, 0x4910, 0x4926, 0x4742, 0x4731, 0x48AE, 0x4A4A,
    0x4B4F, 0x48D7, 0x44DC, 0x41F2, 0x3E9B, 0x3A33, 0x3636, 0x3330, 0x32ED, 0x3678, 0x398D, 0x3B01, 0x3A3D, 0x3A08, 0x3C03, 0x3E15,
    0x3FB2, 0x429A, 0x4681, 0x496B, 0x4919, 0x44C1, 0x40F2, 0x3E2C, 0x3ADB, 0x3876, 0x3707, 0x347F, 0x2F6B, 0x2A60, 0x281F, 0x26EF,
    0x2489, 0x2133, 0x1ECA, 0x1DAF, 0x1EB0, 0x1FD8, 0x1D46, 0x19C3, 0x1890, 0x19C6, 0x1D27, 0x1FCF, 0x1F37, 0x1DAA, 0x1BC3, 0x17EB,
    0x1358, 0x0DC1, 0x08B2, 0x0866, 0x0C72, 0x11C7, 0x1535, 0x1712, 0x1ACB, 0x21B1, 0x295B, 0x319C, 0x3B0D, 0x44D9, 0x4DC8, 0x51C1,
    0x50AB, 0x4E9C, 0x4BFE, 0x48C1, 0x4636, 0x44B3, 0x4253, 0x3DAD, 0x3981, 0x3751, 0x3628, 0x3459, 0x3226, 0x30AA, 0x3062, 0x32CE,
    0x351A, 0x3361, 0x311C, 0x2F64, 0x2E6B, 0x2F11, 0x2E4D, 0x2AC3, 0x2653, 0x21DA, 0x1DC1, 0x19B8, 0x148F, 0x1097, 0x10FD, 0x148C,
    0x18B0, 0x1A14, 0x18F7, 0x192A, 0x1B3F, 0x1D60, 0x2041, 0x2410, 0x2971, 0x2F14, 0x2FBF, 0x2C77, 0x2885, 0x2451, 0x207A, 0x1DC0,
    0x1CC2, 0x1B21, 0x1669, 0x11A4, 0x0E3F, 0x0B74, 0x0800, 0x0522, 0x02C9, 0x0339, 0x0734, 0x0A40, 0x0B19, 0x0B4F, 0x0C26, 0x0F16,
    0x1423, 0x171B, 0x1690, 0x1439, 0x0FCA, 0x0A54, 0x03B2, 0xFB4B, 0xF4C1, 0xF22C, 0xF33F, 0xF59D, 0xF621, 0xF43F, 0xF294, 0xF30B,
    0xF4BD, 0xF825, 0xFD25, 0x05FB, 0x0EDC, 0x1201, 0x10BE, 0x0D41, 0x083F, 0x0222, 0xFD7E, 0xFACF, 0xF6EF, 0xF09A, 0xEB63, 0xE8FF,
    0xE6F8, 0xE50C, 0xE2B3, 0xE00F, 0xDF41, 0xE0F1, 0xE178, 0xDF7D, 0xDC9B, 0xD9EF, 0xDA66, 0xDC78, 0xDCD3, 0xDBB3, 0xD8EC, 0xD51F,
    0xD14F, 0xCC7A, 0xC7A4, 0xC503, 0xC5D0, 0xCA56, 0xCFDC, 0xD261, 0xD335, 0xD565, 0xD817, 0xDBE4, 0xE05B, 0xE715, 0xF196, 0xFB26,
    0x00B1, 0x020A, 0x017A, 0xFFC5, 0xFCA6, 0xFB52, 0xFA4B, 0xF65D, 0xEF1E, 0xE79E, 0xE1CB, 0xDBF9, 0xD692, 0xD144, 0xCB87, 0xC8E6,
    0xC8A3, 0xC71C, 0xC3D2, 0xBFBE, 0xBC97, 0xBC5C, 0xBDF0, 0xBEA8, 0xBE8A, 0xBC89, 0xB991, 0xB6A8, 0xB1CD, 0xAC80, 0xA8A6, 0xA7E9,
    0xAA31, 0xABFE, 0xABFC, 0xABAD, 0xAC4D, 0xAE09, 0xB0BD, 0xB364, 0xB80A, 0xBF31, 0xC5AE, 0xC8DD, 0xC909, 0xC7D3, 0xC525, 0xC2AC,
    0xC123, 0xBFF6, 0xBD5D, 0xB98D, 0xB6A6, 0xB4D7, 0xB420, 0xB468, 0xB396, 0xB2D8, 0xB4EC, 0xB7A0, 0xB95B, 0xB979, 0xB7E5, 0xB73A,
    0xB946, 0xBC9E, 0xBFD1, 0xC207, 0xC2F7, 0xC41C, 0xC554, 0xC585, 0xC4FF, 0xC541, 0xC7B6, 0xCC9D, 0xD0B5, 0xD245, 0xD25D, 0xD2A4,
    0xD417, 0xD56F, 0xD658, 0xD999, 0xDFB1, 0xE543, 0xE6FE, 0xE595, 0xE29C, 0xDEC4, 0xDB70, 0xD953, 0xD84B, 0xD52A, 0xD059, 0xCC85,
    0xC92E, 0xC67E, 0xC3DF, 0xBFE6, 0xBCD5, 0xBCEB, 0xBE15, 0xBF53, 0xBFA3, 0xBE54, 0xBEA1, 0xC1AD, 0xC509, 0xC7EF, 0xC8A1, 0xC823,
    0xC76A, 0xC5B2, 0xC32B, 0xBF23, 0xBB96, 0xBAD3, 0xBCE0, 0xBF12, 0xBFAE, 0xBFAC, 0xC041, 0xC27C, 0xC54A, 0xC805, 0xCD7E, 0xD590,
    0xDCEC, 0xE1AA, 0xE3B2, 0xE335, 0xE0C9, 0xDE80, 0xDED0, 0xE010, 0xDF90, 0xDF58, 0xE057, 0xE271, 0xE670, 0xEA07, 0xEB35, 0xECE7,
    0xF01E, 0xF3C5, 0xF777, 0xF897, 0xF7A7, 0xF832, 0xF9FD, 0xFC73, 0xFF0F, 0x0019, 0xFF08, 0xFD2A, 0xFB2C, 0xF87C, 0xF4A2, 0xF137,
    0xF18F, 0xF5A9, 0xF9BB, 0xFC4B, 0xFCD3, 0xFDA2, 0xFF58, 0x0063, 0x01E6, 0x05F8, 0x0D25, 0x13FF, 0x1846, 0x1A4B, 0x19C9, 0x1679,
    0x134F, 0x122E, 0x1132, 0x0E3C, 0x0A84, 0x068D, 0x0374, 0x0208, 0xFF5D, 0xFABC, 0xF692, 0xF52A, 0xF5ED, 0xF767, 0xF723, 0xF618,
    0xF62F, 0xF818, 0xFBB4, 0xFEEA, 0x0058, 0x009C, 0x00A7, 0xFFC5, 0xFD1B, 0xF854, 0xF40F, 0xF45E, 0xF840, 0xFD78, 0x0269, 0x05B6,
    0x0AA6, 0x1103, 0x161F, 0x1B99, 0x239D, 0x2DE8, 0x3744, 0x3E1E, 0x4211, 0x4365, 0x41BB, 0x3FCC, 0x3FA4, 0x3EE7, 0x3D3F, 0x3A5B,
    0x3799, 0x367C, 0x3786, 0x37E8, 0x3671, 0x35FC, 0x371B, 0x39D0, 0x3C46, 0x3C4E, 0x3A93, 0x38C8, 0x38A8, 0x3A04, 0x3ADE, 0x3A6A,
    0x3A09, 0x3983, 0x3883, 0x35FB, 0x30A5, 0x2C17, 0x2AA4, 0x2C7B, 0x2F81, 0x30CE, 0x3136, 0x3286, 0x33B8, 0x3331, 0x3295, 0x352C,
    0x3B36, 0x40DB, 0x447D, 0x46AF, 0x4614, 0x429A, 0x3F84, 0x3E30, 0x3C9E, 0x3A43, 0x3708, 0x33B0, 0x31B5, 0x30B3, 0x2ECA, 0x2C70,
    0x2B1E, 0x2C61, 0x310F, 0x3610, 0x393B, 0x3B1D, 0x3CC2, 0x3F83, 0x4320, 0x45D1, 0x46A0, 0x4632, 0x44E5, 0x42C5, 0x3E6F, 0x3731,
    0x2FEF, 0x2BDD, 0x2BB1, 0x2D12, 0x2CE3, 0x2C98, 0x2D58, 0x2E67, 0x2E8F, 0x2F12, 0x333A, 0x3A5C, 0x4126, 0x462D, 0x48A7, 0x471E,
    0x42BF, 0x3EC4, 0x3C26, 0x39B7, 0x36D4, 0x3332, 0x2FB2, 0x2E1C, 0x2DE8, 0x2C93, 0x2A98, 0x28CE, 0x28D5, 0x2AE1, 0x2C2B, 0x2B0D,
    0x27AB, 0x240D, 0x2242, 0x2205, 0x2226, 0x2257, 0x21E0, 0x218C, 0x2145, 0x1E23, 0x1803, 0x1246, 0x0FAD, 0x1155, 0x1460, 0x1652,
    0x1819, 0x1A58, 0x1CBF, 0x1DEB, 0x2025, 0x271F, 0x318F, 0x3BEB, 0x447F, 0x4ACA, 0x4C62, 0x4ADC, 0x4939, 0x47F8, 0x4605, 0x4329,
    0x3E3B, 0x3878, 0x33CB, 0x2F41, 0x29CF, 0x228A, 0x1BF1, 0x1802, 0x16C3, 0x15EB, 0x1389, 0x0FFA, 0x0CCF, 0x0B79, 0x0B73, 0x0B6D,
    0x0AA9, 0x08C2, 0x06D6, 0x0435, 0xFE7A, 0xF670, 0xEE40, 0xE9DF, 0xE919, 0xE9B2, 0xE9CF, 0xE95A, 0xEA7C, 0xEBD2, 0xEC11, 0xED5A,
    0xF261, 0xFAA2, 0x02D8, 0x097D, 0x0D8B, 0x0D0F, 0x09D4, 0x0657, 0x03CF, 0x0244, 0xFFB6, 0xFBB3, 0xF81D, 0xF61A, 0xF498, 0xF2D8,
    0xEFD5, 0xED54, 0xED91, 0xF02E, 0xF30C, 0xF413, 0xF34F, 0xF2E1, 0xF464, 0xF7E2, 0xFC49, 0x002C, 0x03A1, 0x0731, 0x09A4, 0x095E,
    0x0611, 0x015A, 0xFFDF, 0x01AD, 0x0432, 0x04F3, 0x0547, 0x05E6, 0x0533, 0x0305, 0x0138, 0x0387, 0x0828, 0x0D2B, 0x11FA, 0x1432,
    0x1236, 0x0E2E, 0x0A28, 0x0694, 0x0363, 0xFEF3, 0xF8F3, 0xF2FD, 0xEE3A, 0xE9ED, 0xE4F7, 0xDEB2, 0xD93F, 0xD67B, 0xD64D, 0xD71C,
    0xD6BC, 0xD518, 0xD43A, 0xD58B, 0xD861, 0xDB65, 0xDD1E, 0xDD07, 0xDCBF, 0xDB7F, 0xD7C2, 0xD110, 0xCA31, 0xC6A3, 0xC691, 0xC74E,
    0xC726, 0xC72D, 0xC808, 0xC86E, 0xC792, 0xC82C, 0xCBD0, 0xD147, 0xD87C, 0xE03D, 0xE56B, 0xE75A, 0xE6E0, 0xE64D, 0xE6D6, 0xE832,
    0xE913, 0xE825, 0xE78B, 0xE865, 0xE9B7, 0xEA2B, 0xE90F, 0xE7FB, 0xE911, 0xEAF5, 0xEC81, 0xEC69, 0xEA1D, 0xE78B, 0xE5CA, 0xE62D,
    0xE71D, 0xE6E2, 0xE688, 0xE68F, 0xE654, 0xE3D8, 0xDE1D, 0xD7D9, 0xD476, 0xD477, 0xD58C, 0xD56E, 0xD5D7, 0xD6B3, 0xD676, 0xD577,
    0xD50B, 0xD75F, 0xDBF7, 0xE20F, 0xE917, 0xEE33, 0xF018, 0xEFD4, 0xEE7F, 0xED63, 0xEC0A, 0xE945, 0xE3E5, 0xDDDD, 0xD935, 0xD55A,
    0xD0B2, 0xCB22, 0xC663, 0xC462, 0xC471, 0xC4F5, 0xC434, 0xC230, 0xC0C5, 0xC06B, 0xC150, 0xC202, 0xC1EB, 0xC206, 0xC29B, 0xC338,
    0xC209, 0xBE89, 0xBB4C, 0xBABE, 0xBD57, 0xC050, 0xC274, 0xC53D, 0xC922, 0xCBFD, 0xCD18, 0xCF8A, 0xD438, 0xDA66, 0xE1F3, 0xEA7A,
    0xF086, 0xF2C8, 0xF27D, 0xF0C3, 0xEFE7, 0xEF88, 0xEE5D, 0xEC10, 0xEA70, 0xE9FD, 0xEA90, 0xEA58, 0xE802, 0xE5C9, 0xE511, 0xE654,
    0xE85E, 0xE899, 0xE77C, 0xE59F, 0xE4D1, 0xE56D, 0xE5D3, 0xE5D1, 0xE5B1, 0xE6DE, 0xE8A2, 0xE801, 0xE436, 0xE005, 0xDE09, 0xDE65,
    0xDE97, 0xDE4A, 0xDF1B, 0xE102, 0xE190, 0xE0B4, 0xE0F4, 0xE35E, 0xE822, 0xEF01, 0xF6EB, 0xFCCC, 0xFF7D, 0xFF20, 0xFD34, 0xFBEA,
    0xFAEE, 0xF8FE, 0xF610, 0xF328, 0xF1B8, 0xF17D, 0xF066, 0xEE3B, 0xEBCA, 0xEB75, 0xEDB6, 0xF0F4, 0xF36D, 0xF4AA, 0xF56B, 0xF73F,
    0xF9D3, 0xFC8A, 0xFD70, 0xFD7B, 0xFE2D, 0xFDE5, 0xFAA2, 0xF3A8, 0xEC0C, 0xE73B, 0xE626, 0xE5FD, 0xE610, 0xE7BA, 0xEA5F, 0xEBE4,
    0xEBB7, 0xEBD1, 0xEE50, 0xF335, 0xFB34, 0x048F, 0x0B73, 0x0F4F, 0x0F60, 0x0E73, 0x0D7D, 0x0C5D, 0x0A7A, 0x0799, 0x0589, 0x0561,
    0x0683, 0x0621, 0x043C, 0x017F, 0x0031, 0x008B, 0x01DB, 0x01F4, 0xFFC1, 0xFCD6, 0xFB1E, 0xFB51, 0xFBBB, 0xFBAD, 0xFC1D, 0xFDD9,
    0xFF89, 0xFEDB, 0xF9F7, 0xF3B0, 0xEFD9, 0xEF56, 0xF041, 0xF27C, 0xF6FF, 0xFC5A, 0xFFF6, 0x023A, 0x05A6, 0x0B41, 0x1395, 0x1DFE,
    0x294A, 0x32A7, 0x3821, 0x3A6C, 0x3B51, 0x3B96, 0x3AE4, 0x3805, 0x3371, 0x2EC2, 0x2AE9, 0x2773, 0x2241, 0x1BDF, 0x1519, 0x103D,
    0x0E5D, 0x0E2E, 0x0CCF, 0x09B9, 0x0677, 0x03E4, 0x030C, 0x028A, 0x01B9, 0x0124, 0x01F7, 0x02B0, 0x003D, 0xFA3D, 0xF2CA, 0xED3B,
    0xEC1F, 0xEBED, 0xEBB5, 0xED51, 0xF028, 0xF1C2, 0xF270, 0xF3F5, 0xF6BA, 0xFB9E, 0x0349, 0x0C10, 0x130F, 0x16CD, 0x16E9, 0x162B,
    0x1603, 0x1595, 0x1457, 0x1274, 0x1048, 0x0F71, 0x0E1A, 0x0B1C, 0x06CE, 0x0278, 0x00C1, 0x01F7, 0x0597, 0x088C, 0x0A18, 0x0AFB,
    0x0D12, 0x10C0, 0x14B6, 0x1839, 0x1C08, 0x2113, 0x2671, 0x28DE, 0x26C1, 0x231B, 0x2154, 0x2157, 0x2134, 0x21C6, 0x240B, 0x261F,
    0x260C, 0x24EF, 0x2451, 0x2519, 0x28A8, 0x2F06, 0x35ED, 0x3B5E, 0x3D63, 0x3BE2, 0x3953, 0x36B1, 0x33F8, 0x308C, 0x2BDF, 0x2719,
    0x22F9, 0x1EF9, 0x1A00, 0x1329, 0x0CCD, 0x084F, 0x06F9, 0x0766, 0x07A9, 0x06B5, 0x0501, 0x04A3, 0x05AB, 0x0620, 0x05F0, 0x05D7,
    0x06AB, 0x0812, 0x0640, 0x0062, 0xF98A, 0xF560, 0xF363, 0xF1F4, 0xF1F6, 0xF316, 0xF42B, 0xF359, 0xF1C4, 0xF076, 0xF069, 0xF430,
    0xFC04, 0x0541, 0x0ED6, 0x154C, 0x18BD, 0x1AFA, 0x1C92, 0x1F10, 0x1FCF, 0x1F61, 0x1F54, 0x201C, 0x2189, 0x226C, 0x210E, 0x1EC0,
    0x1D5C, 0x1DAE, 0x1EF6, 0x1EFA, 0x1D4D, 0x1B20, 0x19E3, 0x19AD, 0x1A2F, 0x1A2C, 0x1A82, 0x1BFB, 0x1D84, 0x1C7C, 0x1725, 0x1061,
    0x0C0E, 0x0989, 0x0781, 0x06EC, 0x07B5, 0x089D, 0x07F2, 0x06C2, 0x0587, 0x053F, 0x07BB, 0x0CFA, 0x1427, 0x1B25, 0x1EF9, 0x1FBE,
    0x1F5B, 0x1EBE, 0x1DEB, 0x1B2B, 0x1698, 0x11C3, 0x0D7F, 0x0A3C, 0x068C, 0x011C, 0xFBCF, 0xF826, 0xF681, 0xF604, 0xF4B7, 0xF23E,
    0xEF3C, 0xED5A, 0xECB5, 0xEC98, 0xECAA, 0xEDEE, 0xF12D, 0xF4FA, 0xF613, 0xF376, 0xEFDA, 0xEE0A, 0xED3F, 0xECD7, 0xEE53, 0xF17B,
    0xF4AC, 0xF73D, 0xF8A3, 0xF8F9, 0xFA09, 0xFCEF, 0x0257, 0x09E2, 0x10C6, 0x14A5, 0x15F1, 0x155E, 0x1463, 0x13B3, 0x11AC, 0x0F43,
    0x0D27, 0x0B51, 0x0AD1, 0x097F, 0x0671, 0x02B7, 0x0000, 0xFFD8, 0x009E, 0x012E, 0xFFC9, 0xFDE4, 0xFD16, 0xFD67, 0xFE00, 0xFE09,
    0xFEC8, 0x016F, 0x04DC, 0x0599, 0x0242, 0xFE1D, 0xFB39, 0xF7FA, 0xF512, 0xF3FD, 0xF4E5, 0xF667, 0xF7A6, 0xF81C, 0xF7AD, 0xF823,
    0xFA6D, 0xFF97, 0x06A0, 0x0CE7, 0x10FA, 0x118B, 0x108C, 0x0FD1, 0x0F27, 0x0DC5, 0x0B8F, 0x0975, 0x08B6, 0x0896, 0x07FC, 0x0600,
    0x032C, 0x01A3, 0x017B, 0x03BF, 0x05AE, 0x0621, 0x064A, 0x06B6, 0x07E6, 0x0838, 0x0756, 0x065C, 0x0772, 0x0954, 0x0845, 0x033B,
    0xFC9A, 0xF71F, 0xF23D, 0xED9C, 0xEB21, 0xEAF1, 0xEB68, 0xEBC3, 0xEA91, 0xE8B2, 0xE777, 0xE860, 0xECE5, 0xF408, 0xFBAD, 0x0079,
    0x02DE, 0x03C6, 0x045F, 0x0470, 0x031A, 0x00D1, 0xFE89, 0xFDF1, 0xFE6B, 0xFE08, 0xFB7F, 0xF7C9, 0xF464, 0xF32D, 0xF382, 0xF3B7,
    0xF2CC, 0xF0EF, 0xF005, 0xF072, 0xF095, 0xEF8B, 0xEEC6, 0xEFE8, 0xF220, 0xF219, 0xEE55, 0xE998, 0xE5FD, 0xE300, 0xE18B, 0xE2B7,
    0xE68A, 0xEB52, 0xEFEC, 0xF37B, 0xF614, 0xF8CA, 0xFD4C, 0x055D, 0x0F79, 0x19AE, 0x2167, 0x2591, 0x26DC, 0x272D, 0x2625, 0x236F,
    0x1F71, 0x1B43, 0x17C2, 0x14EB, 0x1174, 0x0BB7, 0x0501, 0xFF1B, 0xFBBD, 0xFA63, 0xF931, 0xF6C2, 0xF3A3, 0xF0D2, 0xEF3D, 0xED91,
    0xEAFB, 0xE986, 0xEA7C, 0xECCC, 0xEC71, 0xE8DC, 0xE463, 0xDFF8, 0xDBD2, 0xD927, 0xD909, 0xDAB1, 0xDD3F, 0xDFE0, 0xE0D8, 0xE080,
    0xDFFE, 0xE118, 0xE553, 0xEC43, 0xF451, 0xFAD8, 0xFE03, 0xFF5A, 0x00B3, 0x00DB, 0xFF23, 0xFBC4, 0xF809, 0xF577, 0xF3E4, 0xF173,
    0xED4C, 0xE868, 0xE4C1, 0xE41D, 0xE5DD, 0xE840, 0xE993, 0xEAEA, 0xED2E, 0xF036, 0xF377, 0xF597, 0xF8AB, 0xFE46, 0x0505, 0x08D0,
    0x08A3, 0x06DB, 0x045E, 0x01AD, 0xFFD5, 0x000B, 0x0202, 0x04DB, 0x06CF, 0x077B, 0x072A, 0x063C, 0x06E7, 0x0ABD, 0x1159, 0x18D8,
    0x1DD5, 0x1F75, 0x1F4E, 0x1DC4, 0x1B51, 0x1788, 0x1296, 0x0DDA, 0x0A2B, 0x0768, 0x0420, 0xFF09, 0xF905, 0xF47C, 0xF26D, 0xF269,
    0xF2BF, 0xF1EB, 0xF0B2, 0xF019, 0xF021, 0xEFAF, 0xEE7D, 0xEE76, 0xF19E, 0xF60E, 0xF796, 0xF593, 0xF22D, 0xEDBE, 0xE8F8, 0xE4FB,
    0xE239, 0xE1B9, 0xE21D, 0xE226, 0xE168, 0xDF99, 0xDE22, 0xDF0E, 0xE381, 0xEB79, 0xF4BB, 0xFC8F, 0x01EF, 0x05A1, 0x0926, 0x0C11,
    0x0D92, 0x0D90, 0x0CE4, 0x0D2E, 0x0E39, 0x0EDF, 0x0E05, 0x0B96, 0x09A3, 0x096D, 0x0A6C, 0x0A55, 0x0933, 0x084C, 0x07F0, 0x08A2,
    0x08C0, 0x0793, 0x072E, 0x09F0, 0x0D5F, 0x0D4E, 0x0A11, 0x05A6, 0x006E, 0xFB77, 0xF737, 0xF500, 0xF53A, 0xF644, 0xF7C5, 0xF897,
    0xF816, 0xF730, 0xF7B2, 0xFB70, 0x026F, 0x0A2C, 0x0FBA, 0x1276, 0x1338, 0x137B, 0x133B, 0x1193, 0x0E6B, 0x0AF9, 0x0897, 0x06A0,
    0x0456, 0x0030, 0xFA35, 0xF4AC, 0xF100, 0xEF6C, 0xEE01, 0xEB81, 0xE83B, 0xE59F, 0xE4AF, 0xE40D, 0xE2CB, 0xE3AD, 0xE896, 0xEDF3,
    0xF118, 0xF16E, 0xF0C6, 0xEF5D, 0xEDA2, 0xEC50, 0xEBF3, 0xED7F, 0xEFE3, 0xF420, 0xF7E0, 0xFA44, 0xFAEE, 0xFB4E, 0xFDEE, 0x02E6,
    0x0949, 0x0E1F, 0x1118, 0x12A5, 0x134A, 0x13B8, 0x1345, 0x1183, 0x0F04, 0x0C3D, 0x0975, 0x0708, 0x0569, 0x03B0, 0x01C1, 0x0053,
    0xFF3D, 0xFE55, 0xFD90, 0xFC53, 0xFB9B, 0xFCB1, 0xFE57, 0xFED4, 0xFE63, 0xFD6C, 0xFC07, 0xF9F0, 0xF7E7, 0xF6D3, 0xF650, 0xF648,
    0xF6A6, 0xF7AD, 0xF844, 0xF890, 0xF834, 0xF8D3, 0xFB0D, 0xFE1A, 0x0100, 0x034E, 0x04C0, 0x04F8, 0x04FF, 0x049A, 0x04BD, 0x0427,
    0x046A, 0x04D9, 0x0565, 0x0684, 0x0774, 0x08ED, 0x0B04, 0x0D64, 0x0FA3, 0x11B5, 0x12DB, 0x1350, 0x13F3, 0x14F0, 0x14F7, 0x13FC,
    0x1315, 0x11CF, 0x102A, 0x0DB6, 0x0AFF, 0x08B1, 0x065D, 0x0524, 0x0488, 0x041B, 0x02A3, 0x0060, 0xFE21, 0xFD6E, 0xFCF5, 0xFD50,
    0xFD62, 0xFD73, 0xFD49, 0xFE13, 0xFE8E, 0x050C, 0x0A5B, 0x030C, 0x024E, 0x00E5, 0x002A, 0x0112, 0x0115, 0x01CA, 0x002E, 0x0102,
    0x018F, 0x027A, 0x0361, 0x0558, 0x0741, 0x087F, 0x098C, 0x0923, 0x099E, 0x08A2, 0x05C5, 0x04A1, 0x0260, 0x0072, 0x010E, 0xFF2B,
    0xFB0B, 0xF706, 0xF35A, 0xF1CE, 0xF24B, 0xF3B9, 0xF590, 0xF80F, 0xFAE9, 0xFE37, 0x0244, 0x0742, 0x0C45, 0x105A, 0x13C8, 0x168C,
    0x182E, 0x1A57, 0x1B8F, 0x1CB7, 0x1DD6, 0x1DE5, 0x1F4F, 0x208B, 0x215D, 0x20F2, 0x209E, 0x1FB7, 0x1F4A, 0x1EBC, 0x1CE6, 0x1AC3,
    0x1740, 0x13B1, 0x0F7E, 0x0B68, 0x0839, 0x046A, 0x0023, 0xFBE8, 0xF707, 0xF35A, 0xF0DB, 0xEF93, 0xF0D1, 0xF236, 0xF266, 0xF4CE,
    0xF8AA, 0xFA67, 0xF9F5, 0xF8D4, 0xF8A7, 0xF807, 0xF77A, 0xF739, 0xF6DD, 0xF709, 0xF7A0, 0xF7C9, 0xF887, 0xF972, 0xF9E4, 0xFA7C,
    0xFA5B, 0xF9FE, 0xF9E7, 0xFA6E, 0xFA93, 0xFAE3, 0xFAE1, 0xFAA4, 0xFADC, 0xFBD5, 0xFC19, 0xFD00, 0xFB9C, 0xFB7A, 0x00A5, 0x032C,
    0x0444, 0x038D, 0x041B, 0x0568, 0x0617, 0x07E3, 0x0946, 0x0B20, 0x0D94, 0x1009, 0x11D5, 0x1387, 0x14D2, 0x158D, 0x1600, 0x15F4,
    0x15C3, 0x1644, 0x159A, 0x14FE, 0x13DA, 0x11AC, 0x1065, 0x100A, 0x0FC5, 0x0F14, 0x0D0A, 0x0AC1, 0x08F6, 0x0776, 0x05DE, 0x0507,
    0x0510, 0x0537, 0x0630, 0x05AD, 0x085C, 0x09E0, 0x0777, 0x0564, 0x02A4, 0x002F, 0xFEB9, 0xFDBB, 0xFDA9, 0xFD46, 0xFC29, 0xFB66,
    0xFC1D, 0xFDE7, 0xFE5F, 0xFE97, 0xFE2D, 0xFD74, 0xFC63, 0xFB12, 0xF930, 0xF739, 0xF58B, 0xF382, 0xF21E, 0xF13E, 0xF034, 0xEE54,
    0xEEEB, 0xF008, 0xF0E1, 0xF45D, 0xF85E, 0xFA4D, 0xFBF7, 0xFE84, 0x01FC, 0x0403, 0x0538, 0x0809, 0x09EA, 0x0AE1, 0x0C50, 0x0D15,
    0x0E48, 0x0F59, 0x101C, 0x1198, 0x1248, 0x1318, 0x1362, 0x1361, 0x1316, 0x1215, 0x10AC, 0x0F48, 0x0DF4, 0x0C0E, 0x0A08, 0x075C,
    0x04B4, 0x026C, 0x00F8, 0x008B, 0x00DD, 0x01FF, 0x0321, 0x03D6, 0x03FD, 0x0366, 0x026B, 0x0107, 0xFFB6, 0xFF1D, 0xFE3A, 0xFE0C,
    0xFDE9, 0xFDA0, 0xFDCB, 0xFD79, 0xFD07, 0xFD42, 0xFDEA, 0xFE85, 0xFED1, 0xFE6C, 0xFDDC, 0xFCE3, 0xFB95, 0xF9F3, 0xF812, 0xF60D,
    0xF3D5, 0xF141, 0xEEFE, 0xED4C, 0xEBF5, 0xEC01, 0xED1A, 0xEEFA, 0xF1A6, 0xF436, 0xF6D5, 0xF93D, 0xFB7F, 0xFC97, 0xFCB7, 0xFCF6,
    0xFC76, 0xFC33, 0xFBC3, 0xFB0E, 0xFA3E, 0xFA11, 0xFABB, 0xFB4D, 0xFBB7, 0xFBD7, 0xFC60, 0xFC99, 0xFCA9, 0xFCC0, 0xFCDF, 0xFD9B,
    0xFE81, 0xFF23, 0xFFAB, 0xFFD1, 0xFFFC, 0x0047, 0x005D, 0x00F0, 0x01E8, 0x0307, 0x03D7, 0x0449, 0x0459, 0x03BF, 0x02B4, 0x0180,
    0x00A0, 0xFFEB, 0xFF14, 0xFEA6, 0xFE4A, 0xFEAE, 0xFEFF, 0xFF26, 0xFFAF, 0xFFBD, 0x001F, 0x0031, 0x0019, 0xFF54, 0xFDA9, 0xFC49,
    0xFAE0, 0xF9AD, 0xF8B8, 0xF725, 0xF5F7, 0xF507, 0xF434, 0xF473, 0xF503, 0xF659, 0xF885, 0xFB11, 0xFE7C, 0x020C, 0x0545, 0x086D,
    0x0B9E, 0x0DD7, 0x0ED7, 0x0F70, 0x0FB8, 0x0F7E, 0x0EFA, 0x0E6D, 0x0E08, 0x0D78, 0x0CFB, 0x0CA6, 0x0C16, 0x0ABF, 0x08E7, 0x0763,
    0x05EC, 0x04EE, 0x038A, 0x01EE, 0x002D, 0xFD63, 0xFA72, 0xF759, 0xF3D8, 0xF052, 0xED79, 0xEC24, 0xEB77, 0xEB1D, 0xEB32, 0xEBD8,
    0xEC89, 0xED8B, 0xEE6E, 0xEF27, 0xF028, 0xF0F0, 0xF20A, 0xF3EC, 0xF633, 0xF8B9, 0xFB9B, 0xFE81, 0x0162, 0x0434, 0x068B, 0x07E5,
    0x084A, 0x07D1, 0x069E, 0x04CD, 0x0272, 0xFFD6, 0xFD23, 0xFA9B, 0xF880, 0xF68C, 0xF493, 0xF3C4, 0xF3BC, 0xF402, 0xF547, 0xF72A,
    0xF9A0, 0xFCB1, 0xFF65, 0x01C9, 0x03EB, 0x0543, 0x0679, 0x0738, 0x0784, 0x079E, 0x07E9, 0x087F, 0x09C7, 0x0B54, 0x0C50, 0x0D53,
    0x0DFE, 0x0EF9, 0x0FC1, 0x1023, 0x10A7, 0x1117, 0x10F2, 0x100F, 0x0E38, 0x0B73, 0x078C, 0x02BA, 0xFD74, 0xF81A, 0xF342, 0xEF22,
    0xEC08, 0xE9AF, 0xE7F6, 0xE700, 0xE671, 0xE610, 0xE625, 0xE5D3, 0xE562, 0xE486, 0xE333, 0xE27F, 0xE1F8, 0xE1B5, 0xE1F3, 0xE25C,
    0xE2DB, 0xE3D1, 0xE4C3, 0xE5B0, 0xE685, 0xE71F, 0xE7BD, 0xE850, 0xE86D, 0xE8C1, 0xE908, 0xE920, 0xE977, 0xEA31, 0xEB2D, 0xEC33,
    0xED6B, 0xEECB, 0xF0C8, 0xF2C8, 0xF51B, 0xF7B1, 0xF9E2, 0xFC55, 0xFE50, 0xFF82, 0xFFF9, 0xFFFC, 0x0012, 0xFFC7, 0xFFA6, 0xFFF2,
    0x00ED, 0x022C, 0x0362, 0x04E2, 0x05FD, 0x06AC, 0x07DF, 0x097A, 0x0B13, 0x0C7A, 0x0CFE, 0x0D06, 0x0C3C, 0x0A2E, 0x079C, 0x050D,
    0x028F, 0xFFF9, 0xFE07, 0xFC65, 0xFB3F, 0xFA9A, 0xFA06, 0xFA58, 0xFAF0, 0xFB25, 0xFB88, 0xFC07, 0xFC05, 0xFB6F, 0xFA52, 0xF87F,
    0xF6D1, 0xF55D, 0xF44C, 0xF384, 0xF2B5, 0xF1E3, 0xF140, 0xF12C, 0xF10F, 0xF0D2, 0xF0B8, 0xF0EC, 0xF119, 0xF104, 0xF088, 0xEF84,
    0xEE29, 0xED01, 0xEBA2, 0xEA71, 0xE956, 0xE80F, 0xE78B, 0xE7A0, 0xE839, 0xE967, 0xEB49, 0xEDB9, 0xF078, 0xF32D, 0xF4E7, 0xF639,
    0xF74B, 0xF838, 0xF9E2, 0xFBBC, 0xFE0F, 0x012D, 0x03D1, 0x0676, 0x08BC, 0x0A36, 0x0BC8, 0x0D2D, 0x0E79, 0x0FA5, 0x1042, 0x0FE8,
    0x0EDE, 0x0D34, 0x0ABC, 0x0843, 0x0568, 0x02A1, 0x00AA, 0xFF57, 0xFE78, 0xFDC3, 0xFCD4, 0xFC6C, 0xFCD5, 0xFDC1, 0xFEC8, 0xFF30,
    0xFE99, 0xFE22, 0xFD4F, 0xFBC7, 0xFA3E, 0xF90B, 0xF87B, 0xF8D8, 0xF970, 0xFA20, 0xFB2B, 0xFC0A, 0xFC9C, 0xFCD7, 0xFD02, 0xFD36,
    0xFD61, 0xFD49, 0xFCE3, 0xFB97, 0xF9B6, 0xF7E6, 0xF603, 0xF3C8, 0xF0F9, 0xEE24, 0xEBAC, 0xE9B9, 0xE8AB, 0xE8C5, 0xE9D4, 0xEB11,
    0xECB5, 0xEEC8, 0xF0C7, 0xF27B, 0xF37E, 0xF3C1, 0xF3A7, 0xF3B5, 0xF3F2, 0xF452, 0xF3FE, 0xF366, 0xF32A, 0xF2E9, 0xF3E7, 0xF503,
    0xF61F, 0xF7E9, 0xF8E0, 0xF98E, 0xF9C6, 0xF8F8, 0xF82B, 0xF744, 0xF65B, 0xF5F0, 0xF5BF, 0xF67E, 0xF7AA, 0xF8AB, 0xF9E6, 0xFB0A,
    0xFC8F, 0xFE82, 0x004F, 0x0166, 0x01A7, 0x015D, 0x0068, 0xFF20, 0xFDF4, 0xFD01, 0xFC99, 0xFC94, 0xFD74, 0xFE90, 0xFFDB, 0x010B,
    0x01C1, 0x02CA, 0x033E, 0x03DD, 0x0408, 0x02E3, 0x0160, 0xFFB8, 0xFD90, 0xFB33, 0xF8D0, 0xF6B2, 0xF4EA, 0xF403, 0xF3C3, 0xF464,
    0xF5CE, 0xF7B9, 0xFAE7, 0xFE9B, 0x025F, 0x0627, 0x09C8, 0x0D03, 0x0F62, 0x10F9, 0x1217, 0x12F2, 0x1369, 0x1346, 0x12FA, 0x11CB,
    0x10AB, 0x0FCD, 0x0F0A, 0x0EE3, 0x0E89, 0x0E62, 0x0E57, 0x0DF7, 0x0D5E, 0x0BC3, 0x0925, 0x0649, 0x0280, 0xFF24, 0xFC11, 0xF8F2,
    0xF597, 0xF20D, 0xEF8E, 0xEDB5, 0xECB2, 0xEC01, 0xEBC1, 0xEC2F, 0xEC83, 0xED1B, 0xED72, 0xEDA1, 0xEDFD, 0xEEA1, 0xF00F, 0xF256,
    0xF531, 0xF8E6, 0xFD0C, 0x015E, 0x04FE, 0x082B, 0x0AE7, 0x0CFA, 0x0DDF, 0x0DB4, 0x0CB8, 0x0AF5, 0x0847, 0x0552, 0x0296, 0xFF39,
    0xFC64, 0xFA22, 0xF88A, 0xF7E5, 0xF804, 0xF902, 0xFAC7, 0xFD6F, 0x00EA, 0x044A, 0x070F, 0x0940, 0x0B4F, 0x0D5B, 0x0EBB, 0x0F98,
    0x1026, 0x10C0, 0x114D, 0x124A, 0x135B, 0x1489, 0x160A, 0x1819, 0x1AAB, 0x1D50, 0x1FB8, 0x219E, 0x22CA, 0x235E, 0x2300, 0x2178,
    0x1F38, 0x1C1E, 0x18C0, 0x1490, 0x0FD0, 0x0AFF, 0x05CF, 0x00E4, 0xFD04, 0xF9D6, 0xF745, 0xF51D, 0xF3B4, 0xF2C6, 0xF1D5, 0xF112,
    0xF044, 0xEF52, 0xEE65, 0xEE46, 0xEE71, 0xEE92, 0xEE93, 0xEEC5, 0xEF78, 0xEFF5, 0xF046, 0xF07A, 0xF094, 0xF0BF, 0xF0BB, 0xF083,
    0xEFD0, 0xEEB9, 0xEDE5, 0xED70, 0xED9D, 0xEE03, 0xEEDA, 0xF0E2, 0xF389, 0xF6C0, 0xFA6A, 0xFD97, 0x00E5, 0x0392, 0x05E4, 0x07FF,
    0x091A, 0x09EE, 0x09EF, 0x0A2B, 0x09D1, 0x0908, 0x0891, 0x07F8, 0x0855, 0x0932, 0x0ABF, 0x0CF8, 0x0F3A, 0x11AA, 0x1415, 0x1618,
    0x1744, 0x174C, 0x169C, 0x15BB, 0x1459, 0x125A, 0x0FD9, 0x0D91, 0x0B66, 0x09D5, 0x0932, 0x08C4, 0x0899, 0x0874, 0x0951, 0x0A82,
    0x0B33, 0x0C2E, 0x0D44, 0x0E1A, 0x0EE2, 0x0F10, 0x0EC0, 0x0E3F, 0x0D17, 0x0C15, 0x0BDB, 0x0B03, 0x09FE, 0x08AF, 0x075A, 0x0658,
    0x04B2, 0x0303, 0x0179, 0x0026, 0xFECA, 0xFD79, 0xFBB9, 0xF992, 0xF732, 0xF557, 0xF3F4, 0xF2AF, 0xF1D8, 0xF171, 0xF1AE, 0xF270,
    0xF2D7, 0xF40C, 0xF55A, 0xF662, 0xF830, 0xF9D6, 0xFBC9, 0xFD4A, 0xFE7D, 0xFFAE, 0x008A, 0x01AC, 0x039D, 0x0688, 0x0A0F, 0x0DD2,
    0x11CA, 0x158C, 0x18BA, 0x1B04, 0x1C0A, 0x1C36, 0x1B31, 0x195B, 0x1701, 0x1447, 0x1126, 0x0D83, 0x09E8, 0x073E, 0x04F2, 0x03AD,
    0x0372, 0x0444, 0x0681, 0x0B8A, 0x1182, 0x1341, 0x11E8, 0x1158, 0x1199, 0x1157, 0x0FEA, 0x0D95, 0x0AF7, 0x082B, 0x0665, 0x05F6,
    0x06B5, 0x077B, 0x06F2, 0x0498, 0x0119, 0x00A2, 0x0333, 0x059D, 0x0839, 0x0A06, 0x0985, 0x074F, 0x052D, 0x0392, 0x015C, 0xFFFF,
    0xFEBE, 0xFD23, 0xFBFB, 0xFAE4, 0xFA93, 0xFA4D, 0xFAAC, 0xFB4E, 0xFC82, 0xFEA8, 0x0085, 0x029B, 0x035A, 0x032B, 0x02B1, 0x01D1,
    0x00FD, 0x003E, 0xFFCC, 0xFFDA, 0x0046, 0x00BD, 0x00C5, 0x008B, 0x004D, 0x0067, 0x0034, 0xFFB5, 0xFEA3, 0xFD05, 0xFB68, 0xF9D4,
    0xF809, 0xF669, 0xF5F7, 0xF69D, 0xF80C, 0xF995, 0xFAF8, 0xFC88, 0xFE26, 0xFF0D, 0xFFEC, 0x00C4, 0x00E6, 0x013C, 0x01A5, 0x0160,
    0x00E0, 0x0032, 0xFFEE, 0x0050, 0x0141, 0x0329, 0x052C, 0x068A, 0x07CF, 0x0994, 0x0B3D, 0x0C88, 0x0CA9, 0x0C1F, 0x0AAD, 0x089C,
    0x0685, 0x03C2, 0x0197, 0xFFB5, 0xFEE4, 0xFF90, 0x0080, 0x0186, 0x02D6, 0x04A4, 0x06B5, 0x094A, 0x0C6F, 0x1009, 0x13D5, 0x1744,
    0x19BB, 0x1B29, 0x1BA7, 0x1BB9, 0x1B27, 0x1B07, 0x1AB6, 0x1A8C, 0x1A7C, 0x19B0, 0x19C6, 0x1A28, 0x19C1, 0x19D4, 0x19B5, 0x18D9,
    0x1808, 0x15E1, 0x12EC, 0x0F98, 0x0BD5, 0x085F, 0x04FB, 0x01C7, 0xFE9F, 0xFBFC, 0xF9A4, 0xF784, 0xF5E0, 0xF40E, 0xF25F, 0xF150,
    0xF0CA, 0xF08E, 0xF00A, 0xEF96, 0xEF1B, 0xEED9, 0xEF17, 0xEFDE, 0xF181, 0xF3CC, 0xF697, 0xF9F5, 0xFD40, 0x00B1, 0x038C, 0x0590,
    0x071E, 0x07AA, 0x073E, 0x059D, 0x039E, 0x012D, 0xFE83, 0xFCB0, 0xFB33, 0xFA69, 0xFA3A, 0xFA33, 0xFABA, 0xFB68, 0xFCB7, 0xFEB9,
    0x0193, 0x04F0, 0x0823, 0x0AF4, 0x0D34, 0x0F02, 0x0FC3, 0x1008, 0x0FC2, 0x0F73, 0x1067, 0x11CE, 0x13D6, 0x156E, 0x16E6, 0x1931,
    0x1B9F, 0x1DC5, 0x1F9E, 0x2155, 0x2294, 0x232D, 0x22A2, 0x2178, 0x1FA8, 0x1D44, 0x1A5F, 0x17DA, 0x1503, 0x1185, 0x0E67, 0x0AE6,
    0x0790, 0x0451, 0x015F, 0xFF62, 0xFD6F, 0xFC52, 0xFB44, 0xFA81, 0xF96F, 0xF83F, 0xF73C, 0xF5FB, 0xF525, 0xF454, 0xF406, 0xF42C,
    0xF480, 0xF4BF, 0xF4B9, 0xF3F1, 0xF321, 0xF1E9, 0xF129, 0xEFA0, 0xED8E, 0xEC1F, 0xEB87, 0xEAB2, 0xEA79, 0xEA52, 0xEBFF, 0xEE2D,
    0xF0BC, 0xF2D8, 0xF580, 0xF852, 0xFB17, 0xFDD8, 0xFFCB, 0x016E, 0x01F8, 0x0321, 0x02E7, 0x0355, 0x021F, 0x0402, 0x0552, 0x08E0,
    0x0BA1, 0x1204, 0x1359, 0x15A5, 0x1343, 0x1179, 0x096E, 0x0ECD, 0x2904, 0x27AA, 0x2B53, 0x26CC, 0x250D, 0x1F40, 0x1750, 0x0D52,
    0xF333, 0xE04D, 0xD225, 0xC07C, 0xA50E, 0xA6DC, 0xB40D, 0xB5AF, 0xC063, 0xC2E8, 0xCD76, 0xDDC2, 0xEA6E, 0xEB45, 0xF8C6, 0xF278,
    0xF36D, 0xF306, 0xC8AE, 0xD025, 0xD58F, 0xDDC5, 0xE4BC, 0xED19, 0xF2A5, 0xFD64, 0x0AEC, 0x1F41, 0x2439, 0x23D7, 0x59A6, 0x6C52,
    0x636F, 0x56BE, 0x4DD1, 0x45DD, 0x4335, 0x3195, 0x0D08, 0xF465, 0xE2A6, 0xD648, 0xC612, 0xBD63, 0xC824, 0xD718, 0xDDB4, 0xDF46,
    0xDE45, 0xE7F8, 0xF794, 0xF58F, 0x0683, 0xFDC6, 0x03A7, 0x09D8, 0xE819, 0xE58F, 0xE596, 0xEEAE, 0xF29E, 0xF9A8, 0xFAB4, 0x0086,
    0x0360, 0x191A, 0x1D87, 0x1439, 0x3BA9, 0x5B71, 0x6100, 0x59A5, 0x5462, 0x4ADA, 0x48A8, 0x3E2A, 0x2066, 0x0368, 0xEE60, 0xE0EE,
    0xCF2E, 0xC07C, 0xC294, 0xCF5A, 0xD88A, 0xDBDC, 0xD957, 0xE279, 0xF31C, 0xF2E4, 0x0661, 0xFBF6, 0x01D1, 0x0A32, 0xEDA6, 0xDEEC,
    0xD7C0, 0xDDBF, 0xE0E6, 0xE771, 0xE981, 0xEE39, 0xEB71, 0x02B4, 0x0C48, 0x0175, 0x1BD5, 0x443B, 0x57F7, 0x5855, 0x55B8, 0x4B37,
    0x4A6C, 0x469D, 0x3265, 0x15B9, 0xFAE4, 0xEC29, 0xD7DB, 0xC5FE, 0xBF0E, 0xC925, 0xCB19, 0xDAF0, 0xDE85, 0xE0CD, 0xEF00, 0xE9FF,
    0x10B4, 0xF504, 0xFCBD, 0x075F, 0xF28D, 0xE04E, 0xC802, 0xD50D, 0xD2B6, 0xD607, 0xD9DB, 0xE20A, 0xD63E, 0xFC4C, 0xFC9A, 0xF900,
    0x09AE, 0x27A7, 0x529C, 0x4824, 0x5340, 0x52A3, 0x492E, 0x4A7A, 0x42DC, 0x1675, 0xF7AD, 0xF105, 0xD014, 0xD984, 0xBF8C, 0xB151,
    0xDE85, 0xC902, 0xE218, 0xE924, 0xD013, 0xF218, 0x0163, 0x05CA, 0xE968, 0xFCD6, 0x1347, 0xD63F, 0xD7A0, 0xE732, 0xE4FB, 0xD525,
    0xE045, 0xEDFD, 0xFDFB, 0xEE1A, 0xF264, 0x2468, 0x1EC9, 0x2EED, 0x44D6, 0x6668, 0x5BF5, 0x5214, 0x4604, 0x4D37, 0x5195, 0x286D,
    0x008F, 0xFAD3, 0x0331, 0xC777, 0xC55E, 0xD46F, 0xC4A0, 0xCDCD, 0xD340, 0xE731, 0xDD70, 0xE203, 0x1309, 0x13D2, 0xFD5C, 0x1A98,
    0x1B06, 0x1F11, 0x1026, 0xFD6B, 0x15BD, 0x07B4, 0x1D32, 0x185D, 0x2B98, 0x2426, 0x2715, 0x3762, 0x3235, 0x38A4, 0x40C7, 0x4F70,
    0x5900, 0x5432, 0x2083, 0x2A11, 0x2AEE, 0x176C, 0xE2D3, 0xCC5A, 0xCF7D, 0xA4DF, 0x97A3, 0x9AA1, 0xA010, 0x9FA2, 0xA154, 0xAAAE,
    0x98B9, 0xA410, 0xB6EB, 0xD3A3, 0xB5C3, 0xC3AF, 0xEFFA, 0xCAF6, 0xDB61, 0xC866, 0xD600, 0xCDA8, 0xDEE3, 0xE52A, 0xF633, 0x0734,
    0x07EC, 0x30D6, 0x2700, 0x37D5, 0x4D39, 0x7FFF, 0x6E9D, 0x71EF, 0x7FFD, 0x75E2, 0x7FFC, 0x78BA, 0x79F5, 0x711F, 0x725D, 0x61D6,
    0x6442, 0x5142, 0x50CE, 0x6CB2, 0x632B, 0x5DD1, 0x6C69, 0x7427, 0x65FB, 0x73F3, 0x67AB, 0x609D, 0x5DBA, 0x6732, 0x5048, 0x34E5,
    0x53E6, 0x360F, 0x2C33, 0x3EC6, 0x424E, 0x2BAC, 0x3226, 0x44CD, 0x378F, 0x3FAC, 0x3CC9, 0x4EF5, 0x56EC, 0x612A, 0x518E, 0x43B6,
    0x4EB7, 0x3D35, 0x3D65, 0x1637, 0x1730, 0x0267, 0xF14D, 0xE6E7, 0xDA61, 0xEF2B, 0xD5BE, 0xE1D7, 0xE703, 0xE2FE, 0xD9A2, 0xEE06,
    0xE3D6, 0xD908, 0xFB10, 0xD480, 0xCE6C, 0xD751, 0xC353, 0xB6B1, 0xC4FB, 0xC333, 0xB482, 0xCB1A, 0xC325, 0xDBAF, 0xD65F, 0xC9A0,
    0xD9DE, 0xE6EB, 0xF79F, 0xFCAA, 0xF2D7, 0xE8A7, 0xE5DE, 0xD511, 0xE07D, 0xCF80, 0xBF5B, 0xB7D6, 0xB3B9, 0xA767, 0x96A3, 0xA94F,
    0xA255, 0xA4EA, 0xACBB, 0x9F9D, 0xAA54, 0xA37E, 0xB37E, 0xAA1E, 0xB800, 0xBD84, 0xAED9, 0xB63D, 0xB5DD, 0xB520, 0xAE36, 0xBAB6,
    0xBDC9, 0xC326, 0xB3E4, 0xD3D2, 0xC286, 0xC9FD, 0xC94D, 0xC7AA, 0xE2CC, 0xE89F, 0xF986, 0xF043, 0xE8F0, 0xEC75, 0x009E, 0xEF52,
    0xED29, 0xE512, 0xD55B, 0xDE8C, 0xDBE0, 0xCFFC, 0xD1C4, 0xDDE8, 0xF4D9, 0xEE28, 0xF4D2, 0xEFDF, 0x0568, 0x1590, 0x14ED, 0x0968,
    0x240E, 0x1CF1, 0x09BC, 0x14BE, 0xF440, 0x081D, 0xF719, 0x153D, 0x0522, 0x1C07, 0x374F, 0x2055, 0x2E7F, 0x3B77, 0x3FEC, 0x4727,
    0x6069, 0x4E67, 0x4B66, 0x5DEF, 0x5CAE, 0x56CD, 0x5299, 0x39E2, 0x3D42, 0x4218, 0x1DAE, 0x191D, 0x22C4, 0x1CC3, 0x2684, 0x2309,
    0x2E90, 0x2450, 0x3B19, 0x5112, 0x3AE5, 0x4EF4, 0x4FDC, 0x3DD6, 0x526A, 0x4686, 0x3A8A, 0x3D97, 0x531D, 0x542D, 0x4846, 0x4A66,
    0x6011, 0x632F, 0x3F27, 0x4928, 0x4B85, 0x6F12, 0x6CA4, 0x6DB3, 0x7628, 0x649C, 0x5A03, 0x6989, 0x5BD6, 0x4FF8, 0x3A15, 0x28FA,
    0x2BC1, 0x12D5, 0x1CDE, 0x0E0E, 0x1C97, 0x3DC3, 0x1C3F, 0x280B, 0x4398, 0x3032, 0x4167, 0x3496, 0x4BF9, 0x3F36, 0x37BF, 0x35E4,
    0x0A46, 0x1AAD, 0x1C00, 0x0DDB, 0x0CD7, 0xF248, 0x127D, 0x2762, 0x1623, 0x28B5, 0x1883, 0x2904, 0x41C9, 0x2EA6, 0x3674, 0x4078,
    0x1C5E, 0x24F4, 0x2E83, 0x09F3, 0x0026, 0x0AB3, 0xE09C, 0xD1BC, 0xC646, 0xDFBF, 0xE8A2, 0xC4F1, 0xD025, 0xC9F8, 0xC6E1, 0xD9CC,
    0xD989, 0xC521, 0xC82B, 0xC886, 0xE505, 0xDCD1, 0xBF9F, 0xD2A3, 0xCAE1, 0xC5D4, 0xCB71, 0xCC2B, 0xD2D4, 0xC4FF, 0xC717, 0xC0FA,
    0xCFE2, 0xC39D, 0xDC9F, 0xE1FD, 0xEC94, 0xF67D, 0xE21D, 0xF91F, 0xD030, 0xDF81, 0xC251, 0xB901, 0xB367, 0xA90B, 0xADD1, 0x9F86,
    0x9EDA, 0x9EB7, 0xB160, 0xA27A, 0xA328, 0xA35B, 0xAD67, 0xAB48, 0xBBA1, 0xC034, 0xAD37, 0xAC42, 0xA942, 0xA0F3, 0x9DF1, 0xA4FD,
    0xA123, 0x9F12, 0xA9F3, 0xADB7, 0xB070, 0xA285, 0xAD05, 0xC148, 0xB255, 0xD2FE, 0xDB2D, 0xCFC9, 0xCEF2, 0xDC0E, 0xD6E9, 0xD398,
    0xCB1A, 0xC805, 0xBA88, 0xB2FA, 0xC135, 0xA0A8, 0xB7F5, 0xAD33, 0xB880, 0xAF69, 0xAA42, 0xC83A, 0xB2F6, 0xBECF, 0xC311, 0xCAD7,
    0xC8FD, 0xCE7B, 0xD515, 0xCC9E, 0xD26C, 0xE0B2, 0xDFBE, 0xD357, 0xDDBB, 0xE958, 0xD862, 0xE420, 0xE0C7, 0xDB6B, 0x0016, 0x0350,
    0x1A5B, 0x1B0A, 0x1C41, 0x2BB0, 0x22AC, 0x16DB, 0x0E3E, 0x085F, 0x0B1B, 0x02FE, 0xDA25, 0xED31, 0xE127, 0xD710, 0xE4D7, 0xEFD2,
    0xECB7, 0xE254, 0x0186, 0xF6E2, 0xF92F, 0x0D76, 0x0763, 0x0AB2, 0x07A3, 0xF65B, 0xF58C, 0xF917, 0x0117, 0xDFE3, 0xF3B3, 0x0C2E,
    0x0E7B, 0x0ECF, 0x09D1, 0x1604, 0x20DB, 0x381C, 0x301B, 0x3F36, 0x3E61, 0x415B, 0x3477, 0x3BF8, 0x3E64, 0x2B25, 0x2865, 0x1D56,
    0x0F32, 0x0BB1, 0x07E7, 0x0C6A, 0x138E, 0x0159, 0x17BF, 0x134F, 0x12BA, 0x232F, 0x0F11, 0x1998, 0x2184, 0x241F, 0x3445, 0x20EC,
    0x29AF, 0x2AB8, 0x3C69, 0x3616, 0x284E, 0x342F, 0x3DF0, 0x31BF, 0x30D8, 0x336D, 0x2D33, 0x4FD2, 0x54AB, 0x5C27, 0x60CC, 0x6781,
    0x5C7B, 0x6A86, 0x5578, 0x5E2D, 0x490E, 0x469E, 0x4DF8, 0x2B74, 0x31AA, 0x1EE6, 0x344C, 0x29B0, 0x27E2, 0x30DC, 0x42A0, 0x3E60,
    0x44DE, 0x4BEB, 0x4EAA, 0x5107, 0x50C0, 0x4F6A, 0x36CF, 0x3F50, 0x37B4, 0x3005, 0x2B28, 0x34D3, 0x3984, 0x3359, 0x3910, 0x3A0D,
    0x35C1, 0x3F71, 0x44A5, 0x4D9E, 0x4D0C, 0x56BC, 0x5F61, 0x4A09, 0x47B4, 0x475E, 0x3A58, 0x2DCD, 0x26F7, 0x137A, 0x0198, 0xF95A,
    0x030E, 0xF54F, 0xF2DD, 0xFF8B, 0xFB69, 0xF84D, 0xF6FF, 0xFFF1, 0xFAB4, 0xFBE0, 0x120B, 0x0655, 0xFC7D, 0x0F73, 0x06A7, 0x0537,
    0x04AA, 0x02D4, 0x0128, 0xF98B, 0xFAD1, 0xF8D0, 0xEEC4, 0xF8D7, 0x0A1E, 0x0D68, 0x1CB0, 0x1830, 0x1376, 0x1BE3, 0x20FC, 0x16DC,
    0xF798, 0x0D61, 0x0883, 0xE119, 0xE7CF, 0xE0D3, 0xD229, 0xD305, 0xDB6A, 0xDC99, 0xD8B6, 0xE6E1, 0xECE0, 0xEA67, 0xF3D7, 0xFA2F,
    0xF87A, 0xF484, 0xEC86, 0xEA39, 0xD725, 0xD337, 0xE8B8, 0xD372, 0xD53E, 0xDCC3, 0xDF8D, 0xDD36, 0xE056, 0xDB45, 0xE1C2, 0xF741,
    0xF2CB, 0x037B, 0xF585, 0xF900, 0xF0F3, 0xDF2E, 0xE089, 0xD7DA, 0xC994, 0xB5E7, 0xB2C4, 0xA1B6, 0x96BD, 0xA694, 0xA086, 0x97B7,
    0x9C37, 0x9906, 0x9CF9, 0x9BAB, 0x98B3, 0x9A2E, 0xA432, 0xA1C2, 0xA27A, 0xA1E8, 0xA36D, 0xA5EB, 0xA715, 0xA4A3, 0x9F7A, 0xA9A0,
    0xA5F8, 0xA8DD, 0xA952, 0xAE80, 0xAD1D, 0xB951, 0xC5FD, 0xC443, 0xCAA8, 0xC0EE, 0xD4E4, 0xCB7E, 0xC299, 0xCE3E, 0xB7E7, 0xB9D6,
    0xADAB, 0xA92D, 0xA1EA, 0xA141, 0xA822, 0xA241, 0xA8AF, 0xA8F4, 0xB75E, 0xAE86, 0xB1AE, 0xBC57, 0xBB0B, 0xBB43, 0xBA56, 0xBD21,
    0xB062, 0xB5DC, 0xB5DC, 0xB720, 0xB4C0, 0xB414, 0xC7A6, 0xC7C1, 0xC418, 0xCD98, 0xD4C9, 0xD818, 0xECEC, 0xED21, 0xF6FD, 0xFDEE,
    0xFFD5, 0xFEA8, 0xF449, 0xF56C, 0xEF56, 0xE21E, 0xDA52, 0xD6AC, 0xBECF, 0xC914, 0xCA15, 0xC55F, 0xC34D, 0xC750, 0xCA5D, 0xC1BE,
    0xC24C, 0xCED1, 0xD354, 0xD3A5, 0xE77A, 0xDDFF, 0xE99E, 0xE5D6, 0xE3FA, 0xEE1F, 0xE27C, 0xE618, 0xE5EF, 0xEAD5, 0xF149, 0xEE82,
    0xF18A, 0xF2A5, 0x0452, 0x0EAB, 0x08CD, 0x0F67, 0x1DDE, 0x1F86, 0x11BD, 0x1B3E, 0x1D61, 0x0D8D, 0x02CB, 0xFEE4, 0xEF34, 0xE96D,
    0xEE72, 0xEE0E, 0xEFCD, 0xF8D9, 0x022E, 0x0671, 0x0D90, 0x1585, 0x13CC, 0x1B87, 0x22E6, 0x1DDB, 0x18A0, 0x187E, 0x1A27, 0x1A1A,
    0x172C, 0x19AF, 0x2443, 0x2133, 0x2B26, 0x2DB6, 0x26C8, 0x3896, 0x46CD, 0x52D4, 0x5C6C, 0x5643, 0x68BE, 0x6089, 0x6384, 0x6766,
    0x5B3B, 0x5808, 0x5699, 0x4B4B, 0x39D5, 0x3956, 0x32F6, 0x3216, 0x246A, 0x2137, 0x21D3, 0x1E4C, 0x1CEF, 0x1ED6, 0x1B46, 0x27B2,
    0x3822, 0x3D10, 0x3339, 0x3838, 0x3D9F, 0x3CEB, 0x3307, 0x3489, 0x38D6, 0x2FE9, 0x407F, 0x40C3, 0x364C, 0x3A6F, 0x4137, 0x425A,
    0x4EAA, 0x4B59, 0x5993, 0x52B3, 0x5369, 0x5660, 0x509F, 0x4CDE, 0x485E, 0x3ED5, 0x2B5F, 0x2657, 0x1B21, 0x1C90, 0x1806, 0x2B5B,
    0x21E5, 0x2941, 0x3769, 0x3432, 0x3734, 0x3305, 0x40A0, 0x3A5C, 0x340C, 0x3344, 0x3213, 0x2E7A, 0x2507, 0x24C6, 0x2877, 0x2623,
    0x3091, 0x2C5A, 0x2999, 0x2D80, 0x3660, 0x4570, 0x4834, 0x514B, 0x4D55, 0x53A9, 0x5190, 0x4CF2, 0x4B92, 0x3F4A, 0x39EE, 0x2BD1,
    0x2594, 0x1381, 0x0FD9, 0x0992, 0x03C8, 0x0403, 0xF84C, 0x0026, 0xFB60, 0xFA3E, 0xF899, 0x0302, 0x0E6A, 0x1664, 0x1A82, 0x16E7,
    0x187F, 0x1A36, 0x1744, 0x0D8E, 0x1022, 0x0F16, 0x10F9, 0x1940, 0x1511, 0x08FD, 0x127B, 0x18EF, 0x1C10, 0x242D, 0x2BC2, 0x3106,
    0x33D6, 0x36FE, 0x32E9, 0x3072, 0x2AE4, 0x2257, 0x126D, 0x076C, 0xFC59, 0xF6B9, 0xF487, 0xF275, 0xF813, 0xF9FD, 0x018D, 0x0580,
    0x03F4, 0x033A, 0x0D55, 0x112C, 0x0D9B, 0x0BB8, 0xFF35, 0xFD4A, 0x0071, 0xF1AF, 0xE94F, 0xEB50, 0xEC7E, 0xECF9, 0xE97F, 0xE543,
    0xE23E, 0xED43, 0xF18D, 0xF80C, 0xFE3A, 0x083B, 0x0C6E, 0x06D7, 0x03E8, 0xFFE7, 0xFF4F, 0xF673, 0xEB48, 0xDAAC, 0xD390, 0xCF2D,
    0xC57C, 0xBF57, 0xBB77, 0xB5AA, 0xB59E, 0xB803, 0xB8D3, 0xB2D5, 0xBD3B, 0xCEE0, 0xCBF8, 0xD224, 0xD5D2, 0xD1A9, 0xD760, 0xC8F7,
    0xCB75, 0xD3D1, 0xCD73, 0xD7C6, 0xD7E9, 0xD16D, 0xCFFC, 0xD9F2, 0xD698, 0xE40A, 0xE8B9, 0xF019, 0xF7CC, 0xF5FB, 0xFEAC, 0xF4C6,
    0xF132, 0xE56C, 0xDD16, 0xD450, 0xC821, 0xB96B, 0xBBB9, 0xB9DA, 0xB6DA, 0xBDBC, 0xBCA9, 0xBF0D, 0xBE6C, 0xBDDC, 0xBCFD, 0xC8D2,
    0xC9E1, 0xC674, 0xBD01, 0xBA53, 0xBD08, 0xB51B, 0xB17D, 0xAEFB, 0xAE73, 0xB312, 0xB67E, 0xB267, 0xB304, 0xB563, 0xBEEF, 0xC4A4,
    0xC7EF, 0xD3D8, 0xD54A, 0xD2A7, 0xD71B, 0xCF9D, 0xCFAF, 0xCEAD, 0xC6D2, 0xC06A, 0xB4FE, 0xB026, 0xB06F, 0xAA5B, 0xA1F8, 0xA98C,
    0xA3B7, 0xA778, 0xAE99, 0xAB2C, 0xACA6, 0xB531, 0xBFBF, 0xC5A7, 0xC304, 0xC2AB, 0xC516, 0xBD55, 0xC53D, 0xC185, 0xC37F, 0xC5E3,
    0xCCEB, 0xCFA5, 0xCA09, 0xD00D, 0xD7F2, 0xD93D, 0xE483, 0xF101, 0xF4D0, 0x0422, 0x04E8, 0x092C, 0xFECA, 0x03F1, 0xFFF2, 0xEEF2,
    0xE9DB, 0xE089, 0xDC76, 0xD949, 0xDA0D, 0xDC68, 0xDCC7, 0xE070, 0xED6F, 0xEB44, 0xEA7D, 0xF169, 0xF776, 0xFD1A, 0xFD0C, 0xF1A5,
    0xF490, 0xF1B9, 0xE8BD, 0xE572, 0xE213, 0xE3DD, 0xE6FA, 0xE9D5, 0xE76B, 0xE8FE, 0xED0D, 0xFB1B, 0xFF47, 0x06D7, 0x147B, 0x175B,
    0x1FCC, 0x1BFD, 0x188E, 0x1946, 0x1625, 0x1A62, 0x082A, 0x0115, 0xFEEF, 0xEE28, 0xE6B8, 0xE03A, 0xDEA0, 0xDBF5, 0xDC48, 0xE19D,
    0xDFDD, 0xE45E, 0xF81E, 0xF958, 0xFCE6, 0x03E9, 0xFC01, 0x047A, 0x00E2, 0xFF37, 0x007F, 0xFBBC, 0x09A9, 0x0B38, 0x0CE7, 0x0A98,
    0x0B0C, 0x0EA8, 0x1E60, 0x2656, 0x32DA, 0x4194, 0x4672, 0x50D0, 0x47AD, 0x50FC, 0x4E24, 0x49F0, 0x3DE6, 0x3848, 0x3479, 0x2A75,
    0x2876, 0x266F, 0x2D7E, 0x2A66, 0x32A7, 0x34DB, 0x3206, 0x3BAF, 0x3FC3, 0x43A4, 0x49B0, 0x46CC, 0x462E, 0x4252, 0x3FF7, 0x3DB0,
    0x3819, 0x333C, 0x374E, 0x3B34, 0x3A0B, 0x3616, 0x377A, 0x3962, 0x4149, 0x4912, 0x4965, 0x4E9E, 0x53CD, 0x5648, 0x5033, 0x50CE,
    0x4EF9, 0x4B98, 0x43D5, 0x448D, 0x3730, 0x2E19, 0x2319, 0x1BDA, 0x14ED, 0x0A42, 0x10F3, 0x0F4F, 0x1320, 0x0F8E, 0x1B2B, 0x2614,
    0x2DDA, 0x2CEE, 0x2C10, 0x2855, 0x2776, 0x2FDE, 0x2325, 0x2424, 0x2889, 0x29F9, 0x2D1B, 0x2774, 0x27D5, 0x27E2, 0x2F41, 0x3826,
    0x4165, 0x4BAB, 0x5489, 0x5A7B, 0x56E0, 0x54E0, 0x55BB, 0x57D9, 0x488E, 0x45EC, 0x3D19, 0x341A, 0x30BC, 0x3244, 0x339E, 0x2CED,
    0x338F, 0x362E, 0x3D2D, 0x38DF, 0x3AC9, 0x40B9, 0x431A, 0x45CB, 0x4383, 0x3FCF, 0x3DA8, 0x3846, 0x3042, 0x29BB, 0x2B93, 0x2BB3,
    0x2BD6, 0x2C9C, 0x2637, 0x2CE4, 0x2E42, 0x37ED, 0x3A2A, 0x3FEF, 0x4709, 0x4804, 0x4996, 0x45D5, 0x4700, 0x4313, 0x47E5, 0x3C9F,
    0x36A6, 0x2D0C, 0x1E8A, 0x13E7, 0x02EE, 0xFD57, 0xF907, 0xF692, 0xF8C7, 0xF6D7, 0xF66C, 0x005B, 0x0A83, 0x0D84, 0x0A5F, 0x113A,
    0x0D69, 0x12DB, 0x0D32, 0x07C9, 0x0590, 0x04E5, 0x0DD2, 0x03A6, 0x0343, 0x01C6, 0x00D4, 0x04DC, 0x1412, 0x1A2D, 0x247A, 0x2F80,
    0x348B, 0x312C, 0x2F12, 0x3302, 0x2927, 0x2230, 0x1587, 0x0C8A, 0x0267, 0xF849, 0xF29F, 0xEC64, 0xEBD0, 0xEBB8, 0xED09, 0xEBEF,
    0xEB46, 0xF26A, 0xF528, 0xFB60, 0xFF9B, 0xFB9F, 0xFCCA, 0xF82A, 0xF8C3, 0xF1DE, 0xEBB1, 0xECA7, 0xEDC5, 0xF2AD, 0xED40, 0xF291,
    0xEF1F, 0xF67C, 0xFC8B, 0x02CD, 0x082E, 0x0C79, 0x1585, 0x0FB5, 0x1046, 0x12AF, 0x168C, 0x0BDB, 0x0A17, 0xFCB2, 0xED28, 0xE420,
    0xD4CE, 0xCAA2, 0xC246, 0xC1CE, 0xC0AF, 0xC3E0, 0xC2C4, 0xC40F, 0xC9EE, 0xCDD8, 0xD30D, 0xD300, 0xCEE4, 0xD240, 0xCEE7, 0xCA30,
    0xC843, 0xC451, 0xC5CE, 0xC5A7, 0xC6BA, 0xBE7E, 0xC04E, 0xC47D, 0xC8B5, 0xCE8D, 0xD705, 0xE240, 0xE733, 0xEBDD, 0xE59A, 0xE63C,
    0xE0C7, 0xDAD4, 0xD516, 0xCA60, 0xC2B8, 0xBB23, 0xB8B5, 0xB606, 0xB0F7, 0xB292, 0xB3DF, 0xB4B5, 0xB460, 0xB31C, 0xB73F, 0xBC77,
    0xBEF1, 0xBC3E, 0xBD7D, 0xBD86, 0xBC67, 0xB967, 0xB34A, 0xB196, 0xB8BE, 0xBA7A, 0xBE91, 0xBFC7, 0xC00A, 0xC66F, 0xCA39, 0xD0CF,
    0xD59C, 0xDBD1, 0xDF8E, 0xE41A, 0xE4D0, 0xE866, 0xEE3C, 0xEBE7, 0xEADF, 0xE4C1, 0xD7B9, 0xCF37, 0xC435, 0xB87A, 0xAF2E, 0xAD4B,
    0xAF86, 0xAFCB, 0xB1DF, 0xAE44, 0xB4B1, 0xB6BA, 0xBB75, 0xC1A4, 0xBE56, 0xC245, 0xC42F, 0xC52B, 0xBEB3, 0xBD7D, 0xBF37, 0xBE2F,
    0xBF1C, 0xBE7E, 0xBD43, 0xBD76, 0xC5B6, 0xCC4C, 0xD367, 0xE197, 0xEEFB, 0xF700, 0xF9B8, 0xFC2E, 0xFBDC, 0xF909, 0xF6D5, 0xF0B7,
    0xE6AA, 0xDECB, 0xD89F, 0xD10A, 0xCEE3, 0xCA62, 0xCDDF, 0xD054, 0xD102, 0xD163, 0xD12B, 0xDB72, 0xE0A6, 0xE7CF, 0xE875, 0xEC8E,
    0xEAA3, 0xE9E2, 0xE772, 0xDCC6, 0xDE00, 0xDFB4, 0xE36A, 0xE84C, 0xE78E, 0xE8DF, 0xED22, 0xF07D, 0xF90E, 0xF950, 0x05A5, 0x09FA,
    0x0C1B, 0x1200, 0x140E, 0x1C43, 0x1640, 0x13CA, 0x0948, 0xF9B1, 0xF039, 0xE04E, 0xD83E, 0xCF2E, 0xCA7A, 0xCE53, 0xCF3C, 0xD14E,
    0xCE32, 0xD7CF, 0xDD84, 0xE203, 0xE985, 0xEAEB, 0xEFA1, 0xF2FF, 0xF1EC, 0xECB2, 0xEABD, 0xED5B, 0xF1BC, 0xF2C1, 0xF149, 0xEFCD,
    0xF9BE, 0xFF7D, 0x09AA, 0x1536, 0x20A6, 0x2C55, 0x3115, 0x36EB, 0x3405, 0x3845, 0x365A, 0x3418, 0x2F96, 0x26BC, 0x2171, 0x1C04,
    0x170B, 0x0E21, 0x0D1C, 0x1165, 0x10B6, 0x1106, 0x0C0A, 0x0C25, 0x1439, 0x167C, 0x1BAA, 0x1900, 0x19C4, 0x186A, 0x1585, 0x0CF7,
    0x0433, 0x0632, 0x0A4E, 0x0FAB, 0x1241, 0x11A8, 0x13EE, 0x1798, 0x1582, 0x179C, 0x1C17, 0x22D6, 0x263B, 0x2AE8, 0x2D12, 0x322C,
    0x351B, 0x31CE, 0x298B, 0x1F14, 0x12B2, 0x073A, 0xFC7A, 0xEF26, 0xE7D3, 0xE5A2, 0xE7CC, 0xE600, 0xE445, 0xE3D3, 0xEC72, 0xF318,
    0xFE21, 0x00FA, 0x05ED, 0x0E2A, 0x0DDE, 0x0E99, 0x0938, 0x098E, 0x0C20, 0x1232, 0x12A2, 0x13A1, 0x1520, 0x1BAF, 0x22C7, 0x2A73,
    0x3736, 0x43E0, 0x4E8E, 0x4EFB, 0x5282, 0x5454, 0x5767, 0x54D9, 0x5180, 0x4B82, 0x424B, 0x3CD6, 0x343A, 0x2CE0, 0x2487, 0x21EC,
    0x2292, 0x2457, 0x222D, 0x233A, 0x2639, 0x2F29, 0x3663, 0x37FF, 0x3A56, 0x3A2D, 0x3A1C, 0x3307, 0x292A, 0x2497, 0x2632, 0x2AF1,
    0x2C1F, 0x2E33, 0x2DC9, 0x2CFD, 0x3035, 0x2BC1, 0x31C1, 0x3725, 0x3CC6, 0x42F9, 0x48FD, 0x4CE5, 0x5044, 0x4FAF, 0x4DA3, 0x458E,
    0x38D4, 0x2E30, 0x208C, 0x1387, 0x07E2, 0x02A5, 0xFF97, 0x02FB, 0xFC56, 0xFE05, 0xFFB7, 0x079B, 0x1245, 0x17DF, 0x1ED2, 0x23E7,
    0x28A0, 0x29CA, 0x258D, 0x1DED, 0x1AA8, 0x1A57, 0x1BAE, 0x1A6C, 0x1990, 0x1A89, 0x1EE6, 0x2179, 0x2A45, 0x3269, 0x3EAE, 0x42FC,
    0x4709, 0x4A3D, 0x4B14, 0x4A2E, 0x4975, 0x450C, 0x3D00, 0x3826, 0x3025, 0x2C08, 0x1EA6, 0x1B07, 0x1A43, 0x1C2D, 0x1A64, 0x18A7,
    0x1AE7, 0x1E19, 0x2649, 0x291B, 0x2B80, 0x2B87, 0x2C20, 0x2965, 0x219E, 0x1AB4, 0x172A, 0x1A16, 0x1DEF, 0x1F1D, 0x1FC0, 0x1F4E,
    0x1EF3, 0x1C26, 0x1C45, 0x1F65, 0x27B3, 0x2FE8, 0x3533, 0x3A3F, 0x3E42, 0x402B, 0x4045, 0x3C4D, 0x2F55, 0x2352, 0x162B, 0x06C0,
    0xF6BC, 0xEA9A, 0xE519, 0xE1AC, 0xDCF8, 0xD7A3, 0xD4BB, 0xD4CD, 0xDB3B, 0xE0D3, 0xE3D2, 0xE793, 0xEC3C, 0xF0D8, 0xEDC4, 0xE973,
    0xE3CD, 0xE169, 0xE33B, 0xE564, 0xE5C4, 0xE56B, 0xE930, 0xEA86, 0xEE3D, 0xF4BF, 0xFF2C, 0x06DF, 0x0CB6, 0x1048, 0x1320, 0x14DD,
    0x154D, 0x1313, 0x0BBC, 0x06A3, 0xFFEF, 0xFA34, 0xEF95, 0xE696, 0xE391, 0xE13E, 0xE26B, 0xDF9C, 0xDD23, 0xDCCD, 0xE200, 0xEAFD,
    0xEE64, 0xF027, 0xEF6E, 0xEFCD, 0xED53, 0xE497, 0xDEEF, 0xDDE8, 0xDF70, 0xE458, 0xE2ED, 0xE196, 0xE0DA, 0xDEC7, 0xDC2C, 0xDBD1,
    0xE1D7, 0xEB9F, 0xF386, 0xF9A8, 0x011E, 0x0315, 0x0621, 0x03DB, 0xFDC0, 0xF0C2, 0xE411, 0xD9BE, 0xCC32, 0xBFFD, 0xB62F, 0xB352,
    0xB08F, 0xADB5, 0xAB10, 0xA8E1, 0xAC94, 0xB1C6, 0xB39E, 0xB58E, 0xBB86, 0xC259, 0xC5B9, 0xC2D0, 0xBF7D, 0xBBA1, 0xBAEE, 0xBF68,
    0xBD78, 0xBFD7, 0xC0B4, 0xC5FF, 0xC9D1, 0xCDF4, 0xD893, 0xE056, 0xEC8D, 0xF2FE, 0xF807, 0xFBC8, 0xFEE0, 0x01E9, 0x006B, 0xFA0D,
    0xF52D, 0xF1B6, 0xE91E, 0xE12C, 0xD8AE, 0xD7AD, 0xD82C, 0xD7B1, 0xD7D4, 0xD6C8, 0xDA28, 0xDFB6, 0xE3F6, 0xE5F4, 0xE5DE, 0xE52F,
    0xE35C, 0xDD1B, 0xD6F3, 0xD018, 0xCFFD, 0xD221, 0xD46E, 0xD16A, 0xD0CB, 0xD0C2, 0xCBB1, 0xCBA9, 0xCE87, 0xD6C1, 0xDDC3, 0xE8D5,
    0xF040, 0xF67B, 0xFC27, 0xFDC7, 0xFD98, 0xF82C, 0xEE11, 0xE7E8, 0xDD82, 0xD1AA, 0xC6ED, 0xBEBF, 0xBCFD, 0xB863, 0xB7F5, 0xB422,
    0xB4CD, 0xBA29, 0xC0C1, 0xC5CC, 0xCA4A, 0xD127, 0xD4D8, 0xD6A8, 0xD388, 0xCF8B, 0xCC4A, 0xCD22, 0xD042, 0xD015, 0xD22F, 0xD5D0,
    0xD9BE, 0xDD82, 0xE1C2, 0xE8D1, 0xF1B6, 0xF858, 0xFA91, 0xFB6E, 0xFD05, 0x0051, 0x022C, 0x0039, 0xFAF9, 0xF667, 0xF0E7, 0xE818,
    0xDDCF, 0xD720, 0xD4AB, 0xD578, 0xD56B, 0xD3D3, 0xD68D, 0xD9C5, 0xE04C, 0xE2AA, 0xE224, 0xE3EF, 0xE62F, 0xE74F, 0xE202, 0xDEAE,
    0xDAB7, 0xDC0C, 0xE067, 0xE092, 0xDE42, 0xDDE2, 0xDB44, 0xD7F7, 0xD779, 0xDCD3, 0xE602, 0xF0EB, 0xFCD7, 0x027D, 0x0AEE, 0x1074,
    0x15A6, 0x134D, 0x0B7E, 0x045B, 0xFDF7, 0xF287, 0xE580, 0xDA14, 0xD2A6, 0xCFFF, 0xCDED, 0xCC35, 0xC681, 0xCABE, 0xD23B, 0xD90C,
    0xE095, 0xE85F, 0xEEE0, 0xF3F7, 0xF43D, 0xF079, 0xE98E, 0xE834, 0xEA07, 0xEAC0, 0xEBDF, 0xED83, 0xF380, 0xF5B5, 0xF9E4, 0x0041,
    0x089D, 0x12E6, 0x1B47, 0x1EF6, 0x2251, 0x2460, 0x277E, 0x295C, 0x2579, 0x21B5, 0x1C31, 0x1539, 0x0B93, 0x012B, 0xFB35, 0xFB4C,
    0xFC7C, 0xFE31, 0xFF57, 0x021D, 0x0B2A, 0x1007, 0x1114, 0x137A, 0x14A0, 0x1757, 0x192B, 0x1563, 0x0F88, 0x0ECF, 0x131A, 0x15EA,
    0x15E0, 0x14EF, 0x13D7, 0x1296, 0x1158, 0x14AC, 0x1D29, 0x285D, 0x3491, 0x3DC0, 0x432A, 0x4987, 0x4EA8, 0x5035, 0x4CFD, 0x46A7,
    0x4228, 0x39EC, 0x2C6F, 0x1C6B, 0x0EBD, 0x0462, 0xFD79, 0xF810, 0xF058, 0xEC15, 0xEDA4, 0xF164, 0xF815, 0xFD74, 0x040D, 0x0A65,
    0x0ECD, 0x0E4F, 0x07C2, 0x03FF, 0x0170, 0x04A1, 0x0697, 0x0A24, 0x0FAF, 0x13F7, 0x188E, 0x1B7D, 0x2397, 0x2B27, 0x33B9, 0x3AF6,
    0x3DE9, 0x42DB, 0x4791, 0x4CF5, 0x4DAC, 0x4CDF, 0x4B2B, 0x4713, 0x4014, 0x3479, 0x2C73, 0x2686, 0x25F4, 0x27B4, 0x27C9, 0x2640,
    0x29FA, 0x2FAC, 0x325D, 0x33C3, 0x3493, 0x395C, 0x3D0E, 0x3EA6, 0x3BF0, 0x390B, 0x38FE, 0x3866, 0x3691, 0x32E1, 0x2E0D, 0x2A73,
    0x2646, 0x231B, 0x25DB, 0x2C2E, 0x367E, 0x3FFF, 0x4559, 0x47A7, 0x495E, 0x4C6C, 0x4A58, 0x48D3, 0x44EE, 0x3CBF, 0x33A4, 0x24D7,
    0x1404, 0x05A6, 0xFBFB, 0xF63D, 0xEF0E, 0xE897, 0xE881, 0xEB92, 0xEFA8, 0xF4D7, 0xFBAD, 0x01C9, 0x076F, 0x0B11, 0x0658, 0xFDDF,
    0xF8CD, 0xF741, 0xF812, 0xF911, 0xFC52, 0x00B8, 0x04AA, 0x0823, 0x0B3A, 0x1367, 0x1CFD, 0x24DA, 0x2C71, 0x31F8, 0x3712, 0x3E6F,
    0x429C, 0x4093, 0x3E8D, 0x3BB0, 0x3589, 0x2BCA, 0x1F26, 0x1621, 0x13B4, 0x1517, 0x15B7, 0x1614, 0x168C, 0x1904, 0x1BE2, 0x1F83,
    0x2105, 0x222E, 0x2701, 0x2AB2, 0x2AB5, 0x2574, 0x2195, 0x1F41, 0x1C42, 0x17D6, 0x1505, 0x1246, 0x1054, 0x0D91, 0x0B19, 0x102A,
    0x1769, 0x21AE, 0x2AD2, 0x30DB, 0x3616, 0x3B2A, 0x404F, 0x4094, 0x3EAA, 0x3B56, 0x3474, 0x2B66, 0x1B32, 0x080A, 0xFB3B, 0xF335,
    0xEC9B, 0xE559, 0xE01C, 0xDF19, 0xE3FE, 0xE87A, 0xECC8, 0xF3A3, 0xFB0F, 0x0201, 0x011F, 0xFB5B, 0xF47A, 0xF1D7, 0xF19D, 0xF219,
    0xF3C9, 0xF7BC, 0xFC1F, 0xFD83, 0xFF92, 0x0285, 0x07F6, 0x0F79, 0x1728, 0x1CD8, 0x219F, 0x2728, 0x2D03, 0x2F2A, 0x2E7A, 0x2B38,
    0x2656, 0x1D12, 0x0EFA, 0x00F5, 0xF6D7, 0xF458, 0xF46C, 0xF1BC, 0xEE7D, 0xECA9, 0xEE1A, 0xF007, 0xEFB0, 0xF21F, 0xF5FB, 0xFF3F,
    0x05AF, 0x05B9, 0x02D3, 0xFFE3, 0xFC19, 0xF95F, 0xF6B1, 0xF291, 0xF2DF, 0xEEB3, 0xEC3E, 0xED4B, 0xF25F, 0xFC04, 0x07B8, 0x0FBE,
    0x14A9, 0x1B7E, 0x218A, 0x26C4, 0x27B4, 0x2530, 0x2148, 0x19AD, 0x0A3F, 0xF8DF, 0xE717, 0xDA16, 0xD303, 0xCBA8, 0xC52A, 0xC1E8,
    0xC394, 0xC5FC, 0xCA22, 0xCDBE, 0xD20D, 0xD75D, 0xDA5C, 0xD79F, 0xCF99, 0xCA0E, 0xC604, 0xC374, 0xC33F, 0xC447, 0xC710, 0xC8ED,
    0xC8DA, 0xCB0C, 0xCDEE, 0xD39F, 0xDBFB, 0xE2C3, 0xE83B, 0xEE56, 0xF589, 0xFA5D, 0xFC65, 0xF927, 0xF461, 0xEE52, 0xE341, 0xD63E,
    0xCA30, 0xC388, 0xC39F, 0xC275, 0xBFDB, 0xBD98, 0xBC8C, 0xBD8B, 0xBE25, 0xBEEF, 0xC0F2, 0xC965, 0xD1BC, 0xD4D4, 0xD534, 0xD2F2,
    0xD033, 0xCEDD, 0xCC36, 0xCB34, 0xCC1B, 0xCCAE, 0xCD3E, 0xCC1D, 0xCDD2, 0xD42B, 0xDBB2, 0xE2E2, 0xE988, 0xF01C, 0xF8FC, 0x010D,
    0x0488, 0x0488, 0x0259, 0xFD48, 0xF370, 0xE43F, 0xD160, 0xC38C, 0xBB72, 0xB512, 0xAF7B, 0xAAB5, 0xAA2C, 0xACB7, 0xAFA6, 0xB254,
    0xB54A, 0xBA36, 0xBFB5, 0xC222, 0xC03C, 0xBBB3, 0xB885, 0xB746, 0xB7D9, 0xBABF, 0xBF9A, 0xC3E6, 0xC653, 0xC727, 0xC8E1, 0xCE0F,
    0xD63F, 0xDFFB, 0xE7E8, 0xEECA, 0xF5EA, 0xFD56, 0x01F8, 0x0284, 0x0015, 0xFD87, 0xF742, 0xEE04, 0xE412, 0xDA99, 0xD752, 0xD687,
    0xD657, 0xD389, 0xD057, 0xD03B, 0xD223, 0xD4BE, 0xD71E, 0xDDC0, 0xE944, 0xF381, 0xF6BD, 0xF5E4, 0xF43C, 0xF1FB, 0xEE56, 0xEC15,
    0xEB72, 0xEA91, 0xE9C9, 0xE8A0, 0xE764, 0xE8BD, 0xED2E, 0xF431, 0xFB25, 0x00FE, 0x082E, 0x0F3F, 0x172B, 0x19B8, 0x1ABD, 0x19D9,
    0x146D, 0x0B72, 0xFA61, 0xE8A6, 0xDB63, 0xD46F, 0xCEA0, 0xC78A, 0xC365, 0xC369, 0xC7A5, 0xCC60, 0xD07D, 0xD53E, 0xDD35, 0xE609,
    0xE725, 0xE4DB, 0xE1AF, 0xDF6D, 0xDF4C, 0xDFC7, 0xE4DF, 0xE9F9, 0xEE3A, 0xF091, 0xF079, 0xF278, 0xF7ED, 0x00F3, 0x0AB6, 0x13A3,
    0x1D1F, 0x2709, 0x2EF9, 0x3326, 0x344F, 0x32E8, 0x3104, 0x2CF3, 0x24BD, 0x19E5, 0x1196, 0x0EBF, 0x0ACD, 0x064B, 0x0088, 0xFBE6,
    0xF9E6, 0xF8C9, 0xF856, 0xFA11, 0x019B, 0x0A13, 0x1083, 0x1099, 0x0DD1, 0x0A88, 0x065D, 0x02B7, 0xFE8C, 0xFEEF, 0xFEEA, 0xFCB9,
    0xFB02, 0xFABC, 0xFC7B, 0x02AE, 0x0B2F, 0x11FC, 0x18D7, 0x2159, 0x297E, 0x2F7B, 0x336E, 0x3509, 0x349D, 0x2EEE, 0x23E6, 0x12FC,
    0x02E8, 0xF67A, 0xEEDB, 0xE867, 0xE1D1, 0xDFB0, 0xDFB1, 0xE3CD, 0xE805, 0xEC76, 0xF1D7, 0xFA1F, 0x005D, 0x0046, 0xFD6A, 0xFA45,
    0xF7FB, 0xF57F, 0xF786, 0xFBB1, 0x007F, 0x03AE, 0x05AB, 0x06A7, 0x07E1, 0x0E91, 0x17E0, 0x205B, 0x293B, 0x3461, 0x3DC8, 0x4404,
    0x46A3, 0x464F, 0x44FF, 0x432E, 0x3F7E, 0x36CB, 0x2D17, 0x2704, 0x2364, 0x20A8, 0x1B61, 0x155B, 0x110A, 0x0FED, 0x113F, 0x1271,
    0x16C0, 0x208E, 0x2ACE, 0x302A, 0x31F7, 0x2FDB, 0x2C8F, 0x28EE, 0x26E0, 0x26AC, 0x2680, 0x2636, 0x2442, 0x2130, 0x1F30, 0x21C1,
    0x2946, 0x3081, 0x36EB, 0x3F18, 0x47D4, 0x5101, 0x560C, 0x586D, 0x592E, 0x56A7, 0x51C8, 0x4773, 0x37E7, 0x28E1, 0x1DC2, 0x13F9,
    0x0B3E, 0x041A, 0x0084, 0x01E0, 0x0566, 0x0820, 0x0AE9, 0x1166, 0x1867, 0x1A9C, 0x18E1, 0x149E, 0x0FA7, 0x0C5E, 0x093C, 0x0993,
    0x0B93, 0x0C22, 0x0B6E, 0x0923, 0x07A1, 0x091F, 0x0F89, 0x17EB, 0x207B, 0x2828, 0x3134, 0x3A65, 0x3FBC, 0x4141, 0x40A2, 0x4056,
    0x3FE3, 0x3BBB, 0x33C2, 0x2C06, 0x26B4, 0x22A9, 0x1D2A, 0x164C, 0x10B3, 0x0E7E, 0x0F25, 0x1102, 0x144A, 0x1BC2, 0x272D, 0x3009,
    0x3380, 0x34CE, 0x3346, 0x2F56, 0x2C4E, 0x2A83, 0x2ADD, 0x2B91, 0x2AEB, 0x28D7, 0x2509, 0x2426, 0x28B4, 0x2F4A, 0x352C, 0x3B52,
    0x41C2, 0x48BD, 0x4E53, 0x5063, 0x5038, 0x4D99, 0x4905, 0x3F99, 0x2FE5, 0x1CFF, 0x0B87, 0xFDB3, 0xF177, 0xE737, 0xE063, 0xDE04,
    0xDF35, 0xE079, 0xE193, 0xE3B2, 0xE831, 0xEC57, 0xED20, 0xEC0C, 0xE97B, 0xE719, 0xE51A, 0xE507, 0xE62C, 0xE724, 0xE7AC, 0xE65C,
    0xE4C6, 0xE3B0, 0xE668, 0xECC0, 0xF3CE, 0xFAA2, 0x0226, 0x0930, 0x0EBC, 0x123A, 0x12BF, 0x12A8, 0x136B, 0x1368, 0x0E48, 0x057A,
    0xFE11, 0xF97E, 0xF528, 0xEEA6, 0xE7E9, 0xE39B, 0xE36B, 0xE524, 0xE6ED, 0xEA9A, 0xF165, 0xFC3A, 0x0368, 0x0634, 0x06CA, 0x04A7,
    0x0117, 0xFD51, 0xFC78, 0xFC3D, 0xFD68, 0xFD32, 0xFA51, 0xF74F, 0xF716, 0xFB8F, 0x015C, 0x063E, 0x0B6C, 0x139A, 0x1C48, 0x228B,
    0x269E, 0x27D6, 0x27A6, 0x24B7, 0x1A21, 0x08F8, 0xF73E, 0xE850, 0xDD85, 0xD4D5, 0xCD63, 0xC97D, 0xC9BD, 0xCB01, 0xCA52, 0xCB52,
    0xCEC7, 0xD416, 0xD875, 0xDA2D, 0xD9A8, 0xD7C7, 0xD527, 0xD1E2, 0xD0C1, 0xD1CD, 0xD342, 0xD4A3, 0xD3C5, 0xD276, 0xD4B5, 0xDA52,
    0xE3D4, 0xECB7, 0xF58D, 0xFFCA, 0x08C9, 0x1048, 0x13C5, 0x165A, 0x1996, 0x1CEF, 0x1D84, 0x1891, 0x1175, 0x0A40, 0x0552, 0xFF3A,
    0xF730, 0xF056, 0xECA8, 0xEBBE, 0xEB55, 0xEB58, 0xEEAB, 0xF5F5, 0xFCBB, 0x0124, 0x01EA, 0x0012, 0xFC83, 0xF7B7, 0xF461, 0xF2E4,
    0xF275, 0xF323, 0xF2EC, 0xF078, 0xEF60, 0xF2B9, 0xF89D, 0xFFAD, 0x0786, 0x10C7, 0x1C3B, 0x26D4, 0x2F7D, 0x3467, 0x3802, 0x3A42,
    0x36C8, 0x2C39, 0x1CEF, 0x0D4B, 0x00AE, 0xF737, 0xEE23, 0xE7DC, 0xE428, 0xE3C9, 0xE3C7, 0xE208, 0xE1B4, 0xE404, 0xE88B, 0xEAD8,
    0xEBA3, 0xEB15, 0xE8C0, 0xE689, 0xE4A8, 0xE364, 0xE348, 0xE445, 0xE45E, 0xE23C, 0xE0B8, 0xE2C2, 0xE86C, 0xEF3D, 0xF631, 0xFD25,
    0x03A0, 0x0A6C, 0x0EC8, 0x0FEF, 0x124B, 0x166B, 0x19C9, 0x194B, 0x1375, 0x0B8E, 0x0509, 0xFE95, 0xF6D4, 0xEE09, 0xE778, 0xE4E4,
    0xE405, 0xE31C, 0xE3B3, 0xE810, 0xEE90, 0xF489, 0xF783, 0xF840, 0xF608, 0xF1BB, 0xED8C, 0xE9AD, 0xE780, 0xE79A, 0xE764, 0xE549,
    0xE288, 0xE268, 0xE5F1, 0xEB5C, 0xF27C, 0xFA8A, 0x0490, 0x1182, 0x1D20, 0x252E, 0x2B61, 0x3013, 0x318F, 0x2C87, 0x20F8, 0x115E,
    0x0275, 0xF6D2, 0xED0C, 0xE500, 0xDF0B, 0xDCD3, 0xDC4E, 0xDA72, 0xD81B, 0xD852, 0xDB60, 0xDF43, 0xE2BA, 0xE4B9, 0xE4B2, 0xE2B6,
    0xDF94, 0xDC2B, 0xD95F, 0xD89F, 0xD8EE, 0xD813, 0xD68B, 0xD713, 0xDBA3, 0xE2B7, 0xEAED, 0xF225, 0xF94A, 0x014B, 0x08CB, 0x0DFF,
    0x119C, 0x174D, 0x1D53, 0x212A, 0x1FA5, 0x1916, 0x11D4, 0x0B52, 0x051E, 0xFE3C, 0xF6E1, 0xF2AD, 0xF19F, 0xEFE0, 0xEF12, 0xF0CC,
    0xF61C, 0xFDBB, 0x04E5, 0x08DC, 0x0A00, 0x08AA, 0x04F2, 0x00A6, 0xFDF4, 0xFD6F, 0xFE1F, 0xFE59, 0xFC66, 0xFA2E, 0xFA92, 0xFE97,
    0x041B, 0x0BA4, 0x146E, 0x2061, 0x2D4E, 0x3759, 0x3E08, 0x41EA, 0x44AB, 0x4288, 0x3A7B, 0x2C3C, 0x1BA0, 0x0D30, 0x00E0, 0xF623,
    0xECD0, 0xE666, 0xE332, 0xE0CB, 0xDD0A, 0xDA8C, 0xDB1A, 0xDDCC, 0xE1DA, 0xE530, 0xE73D, 0xE77D, 0xE55B, 0xE19A, 0xDE66, 0xDD10,
    0xDDFD, 0xDF56, 0xDFAD, 0xE07C, 0xE3D8, 0xEAE2, 0xF2E7, 0xFB3D, 0x0216, 0x08F2, 0x1173, 0x18B6, 0x1DB6, 0x22FB, 0x29E3, 0x301E,
    0x3325, 0x2FAA, 0x2826, 0x20B6, 0x1B00, 0x1470, 0x0CDC, 0x0674, 0x03D8, 0x032F, 0x01AF, 0x01EE, 0x0493, 0x0B29, 0x127E, 0x1864,
    0x1C0D, 0x1BE9, 0x18C8, 0x13AE, 0x0D32, 0x08C5, 0x06F9, 0x05AF, 0x0311, 0xFD93, 0xF8E9, 0xF72D, 0xF84D, 0xFBB8, 0x0104, 0x09B8,
    0x1666, 0x22B7, 0x2B20, 0x3033, 0x3372, 0x3403, 0x3010, 0x2572, 0x15FE, 0x062D, 0xF887, 0xEDC4, 0xE356, 0xDA60, 0xD50F, 0xD180,
    0xCDCE, 0xC99D, 0xC7A6, 0xC8FB, 0xCBE3, 0xD00E, 0xD3A0, 0xD603, 0xD615, 0xD3D0, 0xD05C, 0xCD61, 0xCDA7, 0xD011, 0xD225, 0xD33F,
    0xD55A, 0xD9CC, 0xE04C, 0xE7F6, 0xEE92, 0xF4BD, 0xFC68, 0x04E6, 0x0B3B, 0x107E, 0x171E, 0x1E98, 0x2466, 0x25B6, 0x20F0, 0x1816,
    0x107D, 0x08F3, 0x010F, 0xF8DB, 0xF3C3, 0xF1B2, 0xEF7D, 0xED6A, 0xED04, 0xEFE8, 0xF4C7, 0xFB2E, 0x00DB, 0x042B, 0x0420, 0x01A8,
    0xFCDC, 0xF793, 0xF4B9, 0xF498, 0xF445, 0xF1C7, 0xEE40, 0xEC40, 0xED11, 0xF091, 0xF606, 0xFD33, 0x0938, 0x177B, 0x242C, 0x2D44,
    0x33E6, 0x3880, 0x3A93, 0x36BC, 0x2C2C, 0x1F12, 0x11E9, 0x084B, 0xFEE7, 0xF575, 0xEE15, 0xE905, 0xE41F, 0xDE9A, 0xDA46, 0xD953,
    0xDBCB, 0xE0EF, 0xE7BF, 0xECE4, 0xEFFD, 0xEFE5, 0xEC38, 0xE76C, 0xE450, 0xE50F, 0xE7E2, 0xEA53, 0xEC2C, 0xEEA3, 0xF37F, 0xF930,
    0xFDF5, 0x0258, 0x07BF, 0x0EFA, 0x1633, 0x1AD9, 0x1F8F, 0x2583, 0x2B97, 0x2EF6, 0x2C8E, 0x25BC, 0x1CDC, 0x1521, 0x0D06, 0x03A3,
    0xFC38, 0xF815, 0xF5B4, 0xF2D1, 0xF0A1, 0xF150, 0xF506, 0xFB45, 0x0224, 0x07B2, 0x0ADA, 0x0C16, 0x09F6, 0x04FA, 0x00F0, 0xFFC6,
    0x0049, 0xFF0B, 0xFC09, 0xF8DE, 0xF807, 0xF9F3, 0xFE9C, 0x0500, 0x0E39, 0x1C1C, 0x2A55, 0x35CB, 0x3E1F, 0x4383, 0x4740, 0x4844,
    0x43B0, 0x3A5B, 0x2F7A, 0x25AC, 0x1D39, 0x1321, 0x0971, 0x01E8, 0xFB21, 0xF445, 0xEBE9, 0xE5C0, 0xE368, 0xE47C, 0xE8AA, 0xEDA2,
    0xEFEA, 0xEF04, 0xEAA1, 0xE289, 0xDAC3, 0xD737, 0xD743, 0xD923, 0xDA9B, 0xDB8D, 0xDD7B, 0xE0AA, 0xE3F9, 0xE691, 0xEA9A, 0xF15B,
    0xFA33, 0x01D6, 0x07F1, 0x0E94, 0x159D, 0x1CB4, 0x1F99, 0x1C19, 0x152C, 0x0D67, 0x05FD, 0xFD57, 0xF3DC, 0xED2D, 0xE991, 0xE65F,
    0xE3A1, 0xE2B4, 0xE4AC, 0xE9F2, 0xEFE4, 0xF690, 0xFBEC, 0xFF73, 0x00A3, 0xFDDD, 0xF9EB, 0xF711, 0xF696, 0xF58D, 0xF2D0, 0xEE21,
    0xEA2B, 0xE9C8, 0xEBE8, 0xEFF0, 0xF6E8, 0x0235, 0x1064, 0x1E43, 0x27AC, 0x2EC5, 0x3442, 0x382C, 0x38DE, 0x335F, 0x2A47, 0x202A,
    0x1779, 0x0E39, 0x0323, 0xF911, 0xF17B, 0xE9F6, 0xE1F0, 0xDB28, 0xD720, 0xD704, 0xDA32, 0xDF2D, 0xE352, 0xE545, 0xE4E3, 0xDFFF,
    0xD8AB, 0xD2EE, 0xD1C0, 0xD383, 0xD672, 0xD8BA, 0xDA29, 0xDE04, 0xE2CA, 0xE744, 0xEABF, 0xEFD4, 0xF845, 0x0233, 0x0A95, 0x11FA,
    0x1A78, 0x2296, 0x2960, 0x2AC3, 0x2674, 0x1FB3, 0x1931, 0x12DE, 0x0B0D, 0x03C1, 0xFF23, 0xFC88, 0xFA33, 0xF8A3, 0xF8DE, 0xFB7F,
    0x0159, 0x0854, 0x0EC3, 0x1432, 0x1824, 0x18AD, 0x14B0, 0x0FDF, 0x0CC0, 0x0AEC, 0x077A, 0x0239, 0xFBA6, 0xF685, 0xF5D2, 0xF78A,
    0xFBEC, 0x02B9, 0x0D4A, 0x1A4E, 0x2481, 0x2B1A, 0x301A, 0x3365, 0x35B9, 0x3415, 0x2CF5, 0x234D, 0x1A4D, 0x1189, 0x0722, 0xFCFE,
    0xF3D3, 0xECF6, 0xE661, 0xDFDE, 0xDB73, 0xDA71, 0xDD57, 0xE378, 0xE9E7, 0xEF02, 0xF275, 0xF22F, 0xED7D, 0xE712, 0xE3C1, 0xE467,
    0xE732, 0xE9F2, 0xEB28, 0xED1D, 0xF0AC, 0xF4B0, 0xF889, 0xFC84, 0x035F, 0x0D47, 0x1758, 0x1F4F, 0x2623, 0x2D91, 0x353B, 0x397D,
    0x3753, 0x3092, 0x2823, 0x1F23, 0x150A, 0x099F, 0x001E, 0xF9BB, 0xF46C, 0xEF87, 0xEB7A, 0xE967, 0xEAF2, 0xEFFD, 0xF647, 0xFCA7,
    0x0292, 0x0678, 0x05FA, 0x01E7, 0xFDAF, 0xFAC1, 0xF8AA, 0xF498, 0xEE14, 0xE839, 0xE5DC, 0xE67B, 0xE907, 0xEE09, 0xF68F, 0x01DA,
    0x0D49, 0x15C2, 0x1A8E, 0x1EAF, 0x2317, 0x25D5, 0x234D, 0x1BC5, 0x12C2, 0x0A2B, 0x0117, 0xF5A5, 0xEADE, 0xE26C, 0xDB1C, 0xD522,
    0xD00A, 0xCD66, 0xCE2B, 0xD27D, 0xD883, 0xDDD9, 0xE1BF, 0xE472, 0xE34D, 0xDE83, 0xDA53, 0xD845, 0xDA08, 0xDCCC, 0xDDE5, 0xDE34,
    0xDF5E, 0xE216, 0xE524, 0xE7FA, 0xECAC, 0xF468, 0xFEA2, 0x07BF, 0x0EF7, 0x15C7, 0x1DA6, 0x2552, 0x28F9, 0x2639, 0x2036, 0x1A1E,
    0x122B, 0x0980, 0xFF72, 0xF844, 0xF353, 0xEF56, 0xEC83, 0xEA04, 0xEA41, 0xEE50, 0xF4A7, 0xFC03, 0x041F, 0x0BA9, 0x10BA, 0x111E,
    0x0ECD, 0x0BAB, 0x0893, 0x059B, 0x0027, 0xF864, 0xF37C, 0xF263, 0xF4A8, 0xF909, 0xFFA7, 0x09E1, 0x1613, 0x2126, 0x2954, 0x2F03,
    0x34C5, 0x3B94, 0x3F7A, 0x3DDC, 0x388C, 0x3290, 0x2AE2, 0x209B, 0x14E1, 0x09AF, 0x00F5, 0xF967, 0xF302, 0xEDA2, 0xEA71, 0xEB30,
    0xEE1E, 0xF189, 0xF413, 0xF542, 0xF38C, 0xEE37, 0xE6DC, 0xE052, 0xDD39, 0xDCF1, 0xDD55, 0xDB9B, 0xD9B3, 0xDA09, 0xDB93, 0xDD59,
    0xDF7A, 0xE487, 0xEDA3, 0xF82B, 0x023D, 0x0B42, 0x14E9, 0x206A, 0x2A18, 0x2DC4, 0x2C4D, 0x28AC, 0x2367, 0x1C45, 0x138A, 0x0B54,
    0x0609, 0x029A, 0xFFB4, 0xFD6C, 0xFBD7, 0xFCB9, 0x01BE, 0x07FA, 0x0EAA, 0x16B1, 0x1D68, 0x2087, 0x1F70, 0x1C53, 0x1844, 0x14C3,
    0x100D, 0x0867, 0x00F5, 0xFC8E, 0xFC82, 0xFF5C, 0x03E1, 0x0AB2, 0x145D, 0x1F38, 0x272D, 0x2C17, 0x305E, 0x35DC, 0x3B5C, 0x3CCB,
    0x3966, 0x32BF, 0x2A83, 0x1FBA, 0x1275, 0x0468, 0xF85E, 0xEEEB, 0xE70A, 0xDFE9, 0xDA05, 0xD6FA, 0xD7A3, 0xDA09, 0xDBA3, 0xDE04,
    0xDFB1, 0xDE48, 0xDA02, 0xD467, 0xD075, 0xCEF8, 0xCF06, 0xCE19, 0xCB50, 0xC96E, 0xC9A4, 0xCAA2, 0xCB2B, 0xCD39, 0xD26F, 0xDAB5,
    0xE4B9, 0xEE56, 0xF77E, 0x025F, 0x0E97, 0x1753, 0x1A77, 0x1950, 0x15AD, 0x107D, 0x0923, 0x009A, 0xF9DC, 0xF532, 0xF1E4, 0xEF0C,
    0xEBED, 0xEA21, 0xEB55, 0xEF44, 0xF495, 0xFBC5, 0x0463, 0x0AB8, 0x0CD0, 0x0B47, 0x083F, 0x04A2, 0x0117, 0xFC6D, 0xF4E8, 0xEE6A,
    0xEBD2, 0xEC8B, 0xEF9B, 0xF48E, 0xFC2E, 0x06BE, 0x1169, 0x19EA, 0x1EE8, 0x2482, 0x2C06, 0x3229, 0x342A, 0x3114, 0x2B96, 0x23B0,
    0x1903, 0x0C00, 0xFFB0, 0xF58A, 0xEE69, 0xE98B, 0xE4F8, 0xE1D7, 0xE19C, 0xE40F, 0xE664, 0xE96B, 0xED2D, 0xEF81, 0xEEA8, 0xEB2F,
    0xE68D, 0xE2FF, 0xE255, 0xE178, 0xDF9C, 0xDE11, 0xDD93, 0xDF72, 0xE1A1, 0xE41B, 0xE8D0, 0xF139, 0xFC26, 0x0672, 0x0FB3, 0x185F,
    0x2374, 0x2EA7, 0x3493, 0x353A, 0x32A2, 0x2D8E, 0x264F, 0x1D6B, 0x1450, 0x0C83, 0x060C, 0x0154, 0xFB50, 0xF517, 0xF153, 0xF155,
    0xF3A6, 0xF81B, 0x007E, 0x0896, 0x0DA4, 0x0E75, 0x0AFA, 0x05EB, 0x012B, 0xFCAD, 0xF733, 0xF0CE, 0xED14, 0xED92, 0xF06B, 0xF4CF,
    0xFB60, 0x0424, 0x0EEA, 0x1971, 0x20C7, 0x26B3, 0x2ED7, 0x3800, 0x3EF6, 0x410F, 0x3FB8, 0x3B84, 0x345B, 0x2A73, 0x1EAF, 0x137B,
    0x0A03, 0x03AF, 0xFEF0, 0xFA43, 0xF6B4, 0xF603, 0xF656, 0xF7BF, 0xFA9E, 0xFE17, 0x0093, 0xFFEC, 0xFCAB, 0xF86D, 0xF67C, 0xF5F8,
    0xF437, 0xF0B2, 0xEC94, 0xEAA2, 0xE966, 0xE843, 0xE83D, 0xEB13, 0xF12C, 0xF8D4, 0xFFE9, 0x066A, 0x0F0E, 0x19C5, 0x2373, 0x2781,
    0x26A5, 0x23A3, 0x1E22, 0x1691, 0x0DE3, 0x04D2, 0xFD21, 0xF6EB, 0xF046, 0xE88C, 0xE1F7, 0xDEF4, 0xDEF9, 0xE202, 0xE837, 0xF0BC,
    0xF93A, 0xFDCE, 0xFD99, 0xF900, 0xF2DA, 0xEDAE, 0xE86D, 0xE267, 0xDD38, 0xDB49, 0xDCB1, 0xDFE7, 0xE400, 0xEA76, 0xF388, 0xFEA3,
    0x0876, 0x0F3F, 0x16BA, 0x205B, 0x2A3E, 0x310D, 0x32EA, 0x3199, 0x2C81, 0x241B, 0x193A, 0x0D32, 0x0227, 0xF977, 0xF33F, 0xEDC7,
    0xE891, 0xE4EC, 0xE3AB, 0xE314, 0xE48D, 0xE73C, 0xEAC1, 0xEC04, 0xE9CC, 0xE5B7, 0xE1B0, 0xDFCB, 0xDF43, 0xDDE0, 0xDAE8, 0xD9C9,
    0xD989, 0xDA15, 0xDA8E, 0xDC53, 0xE1EE, 0xEAC5, 0xF4C9, 0xFD2C, 0x058B, 0x1062, 0x1C03, 0x2528, 0x29AE, 0x2A9A, 0x28D0, 0x255F,
    0x1F92, 0x1889, 0x11B6, 0x0BF0, 0x0723, 0x0083, 0xF982, 0xF3F2, 0xF170, 0xF199, 0xF550, 0xFC65, 0x0503, 0x0C13, 0x0F06, 0x0CCD,
    0x075A, 0x0289, 0xFE7F, 0xFA42, 0xF53D, 0xF29C, 0xF29E, 0xF543, 0xF930, 0xFD2C, 0x0455, 0x0E67, 0x1872, 0x212A, 0x27D9, 0x2F49,
    0x3932, 0x413D, 0x4417, 0x4391, 0x3F79, 0x3785, 0x2C7B, 0x1F4B, 0x119B, 0x0623, 0xFDAD, 0xF5C6, 0xEE0E, 0xE70B, 0xE2DB, 0xDF6D,
    0xDD9A, 0xDE9A, 0xE19E, 0xE52C, 0xE659, 0xE490, 0xE0A5, 0xDE09, 0xDD94, 0xDDA5, 0xDC95, 0xDAC3, 0xD9BD, 0xD9E9, 0xDAB3, 0xDB81,
    0xDEAE, 0xE5F4, 0xF0FB, 0xFC51, 0x070E, 0x11DC, 0x1E2F, 0x2AA7, 0x32E6, 0x3782, 0x3945, 0x38BD, 0x3583, 0x30ED, 0x2A87, 0x229B,
    0x1BCF, 0x1522, 0x0D3D, 0x057E, 0x0073, 0xFE7D, 0xFFF6, 0x0476, 0x0CC4, 0x15AC, 0x1B80, 0x1BCD, 0x1669, 0x0FA5, 0x087D, 0x0229,
    0xFAFB, 0xF390, 0xEF41, 0xEE2A, 0xEE7C, 0xEF5D, 0xF14C, 0xF66A, 0xFF54, 0x07DC, 0x0F74, 0x1661, 0x1F89, 0x2A19, 0x3189, 0x3543,
    0x3488, 0x302B, 0x2831, 0x1D15, 0x0F91, 0x0207, 0xF737, 0xEF1B, 0xE6BC, 0xDEB1, 0xD7B7, 0xD214, 0xCEBB, 0xCCDE, 0xCE49, 0xD24C,
    0xD571, 0xD615, 0xD398, 0xD0BB, 0xCF93, 0xCFD4, 0xCFA9, 0xCE28, 0xCD3B, 0xCD11, 0xCCCF, 0xCCA6, 0xCDD0, 0xD19A, 0xDA0F, 0xE47A,
    0xEE98, 0xF78C, 0x01BC, 0x0DF0, 0x17D9, 0x1EB6, 0x22FC, 0x2414, 0x22E6, 0x1FFA, 0x1A8D, 0x1322, 0x0B7D, 0x0525, 0xFDC0, 0xF5A5,
    0xEEB5, 0xEB05, 0xEAAA, 0xED3C, 0xF492, 0xFE61, 0x07BC, 0x0D17, 0x0C21, 0x071B, 0x0148, 0xFCC1, 0xF7C7, 0xF2EF, 0xEF72, 0xEDC4,
    0xEE85, 0xEF60, 0xF09E, 0xF446, 0xFC68, 0x0700, 0x109B, 0x1897, 0x215B, 0x2BF5, 0x3583, 0x3BF8, 0x3E5F, 0x3DB5, 0x396F, 0x3146,
    0x26C8, 0x1A4D, 0x0F13, 0x055E, 0xFC86, 0xF410, 0xEC30, 0xE639, 0xE1A6, 0xDF2F, 0xDF86, 0xE33F, 0xE8D9, 0xED96, 0xEEF4, 0xED00,
    0xEB84, 0xEC1D, 0xEDE1, 0xEE90, 0xECD7, 0xEA1E, 0xE71B, 0xE49E, 0xE304, 0xE207, 0xE4DD, 0xEBC4, 0xF38A, 0xFA52, 0x0168, 0x0A13,
    0x1345, 0x1B42, 0x2147, 0x2575, 0x2628, 0x242A, 0x1F38, 0x16D9, 0x0DFD, 0x0587, 0xFD0A, 0xF551, 0xEE2B, 0xE8DD, 0xE69F, 0xE7C7,
    0xEDA0, 0xF653, 0x014A, 0x0AFF, 0x1016, 0x0F8A, 0x0B96, 0x08A9, 0x067D, 0x03C7, 0x0197, 0x009B, 0x0106, 0x01D5, 0x0198, 0x0235,
    0x067C, 0x0EF7, 0x1976, 0x22D5, 0x2B2B, 0x3557, 0x3FFC, 0x482B, 0x4D2E, 0x4F0E, 0x4D58, 0x48AE, 0x414F, 0x3668, 0x2A84, 0x1F82,
    0x154B, 0x0A89, 0xFFF2, 0xF682, 0xEE34, 0xE743, 0xE2E6, 0xE150, 0xE33E, 0xE74C, 0xE950, 0xE85F, 0xE5A4, 0xE337, 0xE1F6, 0xE077,
    0xDDC8, 0xDA3D, 0xD718, 0xD50A, 0xD207, 0xCFAE, 0xD0BB, 0xD637, 0xDDF1, 0xE549, 0xEBB1, 0xF17B, 0xF931, 0x0154, 0x08CA, 0x0F15,
    0x12EC, 0x14F5, 0x140E, 0x0EAA, 0x0685, 0xFE35, 0xF59F, 0xED1F, 0xE552, 0xDEAF, 0xDB3C, 0xDB1F, 0xDD71, 0xE388, 0xED9B, 0xF8F4,
    0x01BC, 0x04D8, 0x024D, 0xFE0D, 0xFB18, 0xF8DE, 0xF61B, 0xF3D2, 0xF2AB, 0xF238, 0xF19D, 0xF004, 0xEFFC, 0xF46C, 0xFCCE, 0x0616,
    0x0EB8, 0x17D7, 0x2309, 0x2DD2, 0x3661, 0x3CCE, 0x3F36, 0x3E74, 0x3A02, 0x3244, 0x27DF, 0x1D94, 0x1495, 0x0B72, 0x01C5, 0xF7FC,
    0xEF5B, 0xE7D1, 0xE1BA, 0xDDEF, 0xDDF7, 0xE0DE, 0xE44D, 0xE581, 0xE35B, 0xE097, 0xDF28, 0xDEA4, 0xDD55, 0xD9F2, 0xD761, 0xD5E5,
    0xD3FF, 0xD229, 0xD165, 0xD430, 0xDB78, 0xE4B3, 0xECCA, 0xF38E, 0xFB84, 0x0501, 0x0E42, 0x1752, 0x1EDF, 0x2537, 0x28FB, 0x2912,
    0x24F8, 0x1DA6, 0x1638, 0x0E41, 0x0628, 0xFECF, 0xF981, 0xF73F, 0xF723, 0xF9AC, 0xFFCB, 0x0915, 0x126A, 0x182E, 0x17F6, 0x138B,
    0x0E80, 0x09FA, 0x04DC, 0xFF23, 0xFA01, 0xF59D, 0xF278, 0xEE73, 0xEA9A, 0xEAAB, 0xEFBD, 0xF7D7, 0x009C, 0x090A, 0x12B6, 0x1DEC,
    0x288E, 0x31BB, 0x382C, 0x3B8F, 0x3C13, 0x38AB, 0x3198, 0x287A, 0x1FBE, 0x177E, 0x0F00, 0x05E9, 0xFCA8, 0xF493, 0xED65, 0xE7C2,
    0xE55E, 0xE7C5, 0xED99, 0xF3C4, 0xF5E2, 0xF528, 0xF444, 0xF395, 0xF284, 0xF00C, 0xED13, 0xEA40, 0xE848, 0xE667, 0xE454, 0xE3C1,
    0xE83F, 0xF09D, 0xF9B7, 0x010A, 0x082A, 0x1085, 0x1975, 0x22EB, 0x2AC9, 0x31A1, 0x367E, 0x37A7, 0x33C4, 0x2B35, 0x20DD, 0x1605,
    0x0B78, 0x00FB, 0xF89D, 0xF354, 0xF051, 0xEF75, 0xF082, 0xF53B, 0xFD0E, 0x0462, 0x072C, 0x04D0, 0xFFD6, 0xFBB4, 0xF81F, 0xF3F8,
    0xEF17, 0xEACF, 0xE753, 0xE3E6, 0xE0AF, 0xDDD2, 0xDF7C, 0xE634, 0xEE99, 0xF6E2, 0xFEA2, 0x07A8, 0x1140, 0x1AA0, 0x2270, 0x27BA,
    0x2AAE, 0x2A3D, 0x25F5, 0x1E00, 0x1531, 0x0D08, 0x05D1, 0xFDFC, 0xF5E7, 0xEE4C, 0xE747, 0xE059, 0xDB40, 0xDA61, 0xDD36, 0xE3A3,
    0xE87C, 0xE9D7, 0xE8B8, 0xE761, 0xE64E, 0xE456, 0xE142, 0xDE14, 0xDC83, 0xDBDD, 0xDAF5, 0xDA08, 0xDBE3, 0xE1D8, 0xE960, 0xEFEB,
    0xF521, 0xFB55, 0x03C2, 0x0DB4, 0x178C, 0x2094, 0x2839, 0x2D05, 0x2CDB, 0x2743, 0x1DF1, 0x1320, 0x0882, 0xFDF7, 0xF4A6, 0xEE31,
    0xEA95, 0xE99B, 0xE9EA, 0xED24, 0xF451, 0xFE07, 0x071B, 0x0B9B, 0x0B8D, 0x0A57, 0x09A6, 0x0790, 0x0451, 0x0072, 0xFD02, 0xF9EE,
    0xF62E, 0xF20D, 0xEF4F, 0xF274, 0xF9D2, 0x0210, 0x0AB4, 0x1439, 0x1EE0, 0x29A9, 0x343A, 0x3C66, 0x4240, 0x4570, 0x4476, 0x3F6F,
    0x36DC, 0x2D91, 0x2525, 0x1C7E, 0x12C8, 0x0954, 0x004B, 0xF74A, 0xEE91, 0xE7FC, 0xE584, 0xE7C7, 0xECF7, 0xF05E, 0xF011, 0xEDF5,
    0xEC19, 0xE917, 0xE495, 0xDF40, 0xDAF8, 0xD921, 0xD7FB, 0xD5F2, 0xD4B7, 0xD6FD, 0xDCAC, 0xE308, 0xE8C7, 0xEE99, 0xF62D, 0x0114,
    0x0D8D, 0x19F0, 0x2572, 0x2EC6, 0x33A5, 0x3340, 0x2D98, 0x24B8, 0x1BF0, 0x13B7, 0x0C14, 0x0641, 0x02E7, 0x0124, 0x0061, 0x0128,
    0x04C6, 0x0C26, 0x1583, 0x1D12, 0x2045, 0x1FD7, 0x1EBB, 0x1D29, 0x19FA, 0x1593, 0x10EB, 0x0D6E, 0x0A61, 0x05DB, 0x00DC, 0xFF49,
    0x02DB, 0x0922, 0x1000, 0x1706, 0x1E1B, 0x2613, 0x2E8C, 0x35DF, 0x3BCF, 0x4031, 0x4170, 0x3E9F, 0x37CC, 0x2E52, 0x2460, 0x1B0F,
    0x112D, 0x06B6, 0xFC2D, 0xF217, 0xE7BB, 0xDE6D, 0xD82E, 0xD632, 0xD940, 0xDD3C, 0xDF91, 0xDF13, 0xDCF3, 0xDB02, 0xD7AF, 0xD32D,
    0xCF07, 0xCCE0, 0xCC4C, 0xCB14, 0xC962, 0xC947, 0xCC8D, 0xD16E, 0xD65C, 0xDB8F, 0xE229, 0xEC6B, 0xF7F1, 0x0494, 0x11B1, 0x1D46,
    0x269A, 0x2AE7, 0x2944, 0x232D, 0x1BDA, 0x1363, 0x0B9F, 0x0548, 0xFF28, 0xFA78, 0xF67D, 0xF2E9, 0xF124, 0xF331, 0xF98C, 0x0162,
    0x0833, 0x0B33, 0x0BB9, 0x0BEA, 0x09AA, 0x04CD, 0xFECB, 0xFADB, 0xF75D, 0xF4B9, 0xF153, 0xEE4D, 0xEF2E, 0xF36D, 0xFA91, 0x008B,
    0x0793, 0x0FD2, 0x183D, 0x20D2, 0x2820, 0x2EC5, 0x33B9, 0x3690, 0x34F8, 0x2DED, 0x27E7, 0x21E6, 0x19A3, 0x114A, 0x0775, 0xFDD3,
    0xF4A8, 0xE9AC, 0xDFD9, 0xD9A8, 0xD97B, 0xDD8B, 0xE212, 0xE3A3, 0xE0DB, 0xDF48, 0xDCAE, 0xD80E, 0xD25A, 0xCE3A, 0xCCF9, 0xCCA0,
    0xCC53, 0xCB8C, 0xCBCF, 0xCEE0, 0xD4BD, 0xDA69, 0xE022, 0xE7CF, 0xF275, 0x0079, 0x0F69, 0x1C23, 0x267D, 0x2CEE, 0x2DF1, 0x2973,
    0x2135, 0x1774, 0x0CD9, 0x0411, 0xFBFF, 0xF434, 0xEE13, 0xE821, 0xE388, 0xE1A0, 0xE429, 0xEA99, 0xF2E1, 0xF8AE, 0xFB4C, 0xFDD6,
    0xFED2, 0xFD63, 0xF9A4, 0xF572, 0xF221, 0xF012, 0xEE31, 0xEB51, 0xE9BD, 0xEC4A, 0xF2A3, 0xFBC5, 0x051F, 0x0DC9, 0x188B, 0x23D1,
    0x2EF5, 0x395B, 0x42B3, 0x4A45, 0x4DAA, 0x4CAD, 0x4824, 0x41E2, 0x3A8C, 0x3345, 0x2B5A, 0x226F, 0x18AD, 0x0E63, 0x040D, 0xFBCA,
    0xF889, 0xFA22, 0xFF69, 0x03AE, 0x050D, 0x0350, 0xFE58, 0xF79E, 0xEEF2, 0xE658, 0xE144, 0xDE5A, 0xDB34, 0xD7B2, 0xD523, 0xD417,
    0xD52F, 0xD865, 0xDC47, 0xE0AF, 0xE823, 0xF410, 0x0153, 0x0DE8, 0x184A, 0x2047, 0x24F0, 0x24BB, 0x2066, 0x1969, 0x10D1, 0x086E,
    0x010C, 0xF99F, 0xF1B8, 0xEB04, 0xE4D2, 0xDEC8, 0xDC95, 0xDE3D, 0xE3B6, 0xE973, 0xED47, 0xF017, 0xF220, 0xF26F, 0xEFC1, 0xEC2B,
    0xE9CD, 0xE8AC, 0xE7E1, 0xE609, 0xE47D, 0xE54D, 0xE897, 0xEEF7, 0xF620, 0xFED4, 0x0908, 0x140E, 0x1F7B, 0x29C6, 0x32A0, 0x39E7,
    0x3EBD, 0x3EB1, 0x3B5D, 0x351D, 0x2C8E, 0x23C8, 0x1A84, 0x108A, 0x05E7, 0xFB6D, 0xF11A, 0xE716, 0xE02E, 0xDDF2, 0xE140, 0xE6C6,
    0xEA5E, 0xEC0D, 0xED16, 0xEBC9, 0xE824, 0xE3DD, 0xE06B, 0xDEFD, 0xDE3C, 0xDC43, 0xD896, 0xD59D, 0xD521, 0xD7AB, 0xDB5D, 0xE099,
    0xE7F5, 0xF31F, 0x0083, 0x0EE7, 0x1D11, 0x29B0, 0x347D, 0x38E9, 0x37B9, 0x32F5, 0x2BDA, 0x23CC, 0x1BE1, 0x1493, 0x0DB5, 0x07FC,
    0x0256, 0xFCB7, 0xF80D, 0xF7A0, 0xFE1D, 0x08B1, 0x1211, 0x17E4, 0x1C04, 0x1D8B, 0x1B30, 0x15CD, 0x1034, 0x0BB3, 0x086F, 0x05DA,
    0x0391, 0x0231, 0x02E8, 0x065F, 0x0AF9, 0x1247, 0x1B0C, 0x2325, 0x2A58, 0x315D, 0x37C1, 0x3D71, 0x42AB, 0x44E4, 0x4460, 0x40C8,
    0x3A27, 0x322C, 0x2961, 0x1F67, 0x1411, 0x0A20, 0x003E, 0xF5DC, 0xEBC5, 0xE42C, 0xE322, 0xE692, 0xEA55, 0xEC2B, 0xECEC, 0xEDA1,
    0xECD3, 0xE9E9, 0xE5C1, 0xE305, 0xE2AF, 0xE26B, 0xE062, 0xDD20, 0xDA97, 0xDA9F, 0xDD84, 0xE290, 0xE9F1, 0xF3B5, 0x0083, 0x0F6E,
    0x1DF6, 0x2B97, 0x370C, 0x3DD0, 0x3FCC, 0x3E04, 0x389C, 0x3148, 0x29B5, 0x21D0, 0x195B, 0x1208, 0x0B47, 0x03D8, 0xFBF8, 0xF600,
    0xF529, 0xFA26, 0x00F0, 0x060F, 0x09D7, 0x0C70, 0x0DAF, 0x0BD7, 0x0757, 0x0275, 0xFE7F, 0xFB60, 0xF7ED, 0xF3F1, 0xF072, 0xF04D,
    0xF3ED, 0xF98E, 0xFFC9, 0x06B4, 0x0F00, 0x1819, 0x20D6, 0x2991, 0x32DA, 0x3A41, 0x3F43, 0x4038, 0x3D16, 0x3649, 0x2D5C, 0x2403,
    0x1926, 0x0E09, 0x0343, 0xF88E, 0xEDA2, 0xE4C2, 0xE142, 0xE355, 0xE7EE, 0xEBC1, 0xED35, 0xED63, 0xED05, 0xE9E5, 0xE452, 0xDED3,
    0xDB9A, 0xDA62, 0xD886, 0xD4EA, 0xD0CB, 0xCEDA, 0xD02E, 0xD368, 0xD835, 0xDF02, 0xE7AF, 0xF28D, 0xFEF1, 0x0B8D, 0x186D, 0x2407,
    0x2C7A, 0x3149, 0x31D7, 0x2DC1, 0x27C7, 0x2174, 0x1B15, 0x14DE, 0x0EA9, 0x08FD, 0x01D3, 0xFA5B, 0xF52F, 0xF440, 0xF838, 0xFD59,
    0x016C, 0x0440, 0x05C6, 0x04AA, 0x010E, 0xFBBA, 0xF825, 0xF5F0, 0xF32D, 0xEFFF, 0xEB62, 0xE8F4, 0xE9E5, 0xED6D, 0xF2DB, 0xFA28,
    0x021F, 0x0ABD, 0x14F2, 0x1E20, 0x26F3, 0x2F31, 0x35D3, 0x39D0, 0x39F6, 0x35F5, 0x2E7A, 0x257A, 0x1B39, 0x1141, 0x082C, 0xFF38,
    0xF4A2, 0xEA5D, 0xE304, 0xDFD4, 0xE131, 0xE3CC, 0xE601, 0xE825, 0xEA27, 0xEBE1, 0xEB8A, 0xE97A, 0xE78F, 0xE559, 0xE34B, 0xDF84,
    0xDA40, 0xD5FC, 0xD3A9, 0xD349, 0xD4F7, 0xD8CE, 0xDDFB, 0xE52E, 0xEF65, 0xFB53, 0x075C, 0x153D, 0x218D, 0x29FF, 0x2F23, 0x2EFD,
    0x2BD1, 0x2649, 0x207A, 0x1B2C, 0x154A, 0x1053, 0x0B27, 0x04CA, 0xFEB7, 0xFC9E, 0xFF60, 0x0689, 0x0DB6, 0x1430, 0x197C, 0x1BA5,
    0x1B80, 0x1836, 0x1379, 0x0F66, 0x0BF4, 0x09A4, 0x0626, 0x028F, 0x020B, 0x04F9, 0x0B36, 0x11AD, 0x191D, 0x1F69, 0x25AF, 0x2E17,
    0x3449, 0x3CD3, 0x46FB, 0x4D71, 0x518C, 0x50EF, 0x4CAD, 0x4634, 0x3D40, 0x32A5, 0x2704, 0x1CA3, 0x10F9, 0x03C0, 0xF766, 0xED5C,
    0xE7A6, 0xE684, 0xE4E2, 0xE1DA, 0xDF50, 0xDD4C, 0xDB4C, 0xD858, 0xD3C7, 0xCBDA, 0xC88D, 0xC5CF, 0xBF38, 0xBB0D, 0xB950, 0xB71C,
    0xB622, 0xBBDC, 0xBEFD, 0xC330, 0xCF4D, 0xD97D, 0xDFDA, 0xE7F5, 0xF0DB, 0xF9B9, 0x0269, 0x048F, 0x024D, 0xFE4D, 0xF8AA, 0xF1D7,
    0xEC25, 0xE8B6, 0xE682, 0xE44E, 0xDFF3, 0xDAE1, 0xD895, 0xDD2A, 0xE3FF, 0xE918, 0xEF3E, 0xF5DF, 0xFA7D, 0xFC74, 0xFB56, 0xF91A,
    0xF79E, 0xF6D5, 0xF4DD, 0xF204, 0xEFFE, 0xF10C, 0xF52F, 0xFAFB, 0x0237, 0x07E2, 0x0E92, 0x1638, 0x1F22, 0x29C0, 0x345E, 0x3DE5,
    0x4545, 0x48D0, 0x4830, 0x44A9, 0x3DEC, 0x3442, 0x2A44, 0x2166, 0x17EF, 0x0E53, 0x0375, 0xF842, 0xF1D8, 0xF04C, 0xF12F, 0xF32D,
    0xF3B6, 0xF50F, 0xF6B5, 0xF5C0, 0xF2D8, 0xED7C, 0xE800, 0xE356, 0xDE2B, 0xD7D0, 0xD13E, 0xCD27, 0xCC6F, 0xCDA3, 0xD1B5, 0xD65A,
    0xDBFE, 0xE467, 0xEE26, 0xF8F6, 0x043A, 0x111F, 0x1C0F, 0x22E4, 0x2725, 0x26BF, 0x22C8, 0x1CCE, 0x1616, 0x10D5, 0x0C10, 0x06CC,
    0x0083, 0xF8E1, 0xF323, 0xF1F2, 0xF4DA, 0xF9A0, 0xFDCA, 0x01B3, 0x0502, 0x05BC, 0x0302, 0xFE87, 0xFA73, 0xF7BA, 0xF48A, 0xF0EF,
    0xEDCE, 0xEB3F, 0xEB38, 0xEED7, 0xF80C, 0x014E, 0x08E8, 0x14F8, 0x211A, 0x2A73, 0x351B, 0x3F33, 0x4595, 0x4BFD, 0x50A2, 0x4E43,
    0x45B8, 0x3B35, 0x30BA, 0x274D, 0x1F27, 0x16B7, 0x0D18, 0x02F8, 0xF9E2, 0xF379, 0xF147, 0xF1E6, 0xF3F7, 0xF752, 0xFA83, 0xFC39,
    0xFDA6, 0xFB64, 0xF518, 0xF0E1, 0xE9BE, 0xE09D, 0xDAED, 0xD5CA, 0xD161, 0xD292, 0xD657, 0xD73C, 0xDB2D, 0xE43C, 0xF03E, 0xFC96,
    0x07A7, 0x111F, 0x1C18, 0x2726, 0x2DF7, 0x304B, 0x2E60, 0x28AF, 0x20C8, 0x195B, 0x117F, 0x0AD3, 0x05F8, 0x0071, 0xF91A, 0xF446,
    0xF4B6, 0xF76A, 0xFB3D, 0xFEB2, 0x0423, 0x091A, 0x090C, 0x0584, 0x00CC, 0xFBB2, 0xF6B1, 0xF271, 0xED51, 0xE96D, 0xE755, 0xE769,
    0xEA7F, 0xEE37, 0xF2C9, 0xF718, 0xFCC8, 0x03F2, 0x0C71, 0x16CD, 0x2284, 0x2E00, 0x35FA, 0x3A46, 0x3A3C, 0x3622, 0x2F5F, 0x27BE,
    0x2015, 0x19AF, 0x12B3, 0x08CF, 0xFD7D, 0xF26C, 0xEB2D, 0xE785, 0xE55F, 0xE4A9, 0xE5ED, 0xE816, 0xE9BE, 0xEA3C, 0xE914, 0xE679,
    0xE2FD, 0xDF07, 0xD95C, 0xD365, 0xCF01, 0xCC61, 0xCBA2, 0xCDB6, 0xD125, 0xD624, 0xDDA5, 0xE565, 0xEDFC, 0xF8D0, 0x0445, 0x0EE1,
    0x1698, 0x1ADC, 0x1C28, 0x18EC, 0x1213, 0x0A7E, 0x0351, 0xFD95, 0xF91F, 0xF347, 0xEC28, 0xE4F0, 0xE0D1, 0xE152, 0xE4DD, 0xE9B1,
    0xEF17, 0xF4F3, 0xF94F, 0xF9E2, 0xF770, 0xF54D, 0xF4CF, 0xF3B1, 0xF21C, 0xF28F, 0xF27E, 0xF0C5, 0xF27F, 0xF6F3, 0xFC4F, 0x03CF,
    0x0D61, 0x177D, 0x2331, 0x3151, 0x3D2A, 0x45D9, 0x4DBF, 0x5419, 0x5710, 0x54FB, 0x4E45, 0x451F, 0x3B6F, 0x335C, 0x2C43, 0x2374,
    0x1853, 0x0C80, 0x0343, 0xFD49, 0xF984, 0xF900, 0xF9F2, 0xFAD1, 0xFCA3, 0xFB89, 0xF6F2, 0xF222, 0xEC2C, 0xE366, 0xDA78, 0xD2C8,
    0xCAA3, 0xC4C0, 0xC3FF, 0xC60B, 0xC8A0, 0xCB2A, 0xCF6F, 0xD710, 0xE1A8, 0xED2B, 0xF7BC, 0x0276, 0x0D91, 0x1768, 0x1EFF, 0x22FD,
    0x21F4, 0x1F10, 0x1AFC, 0x15D3, 0x1248, 0x0F6E, 0x0B5F, 0x05EE, 0x00F0, 0xFF6C, 0x008A, 0x0330, 0x0667, 0x0A14, 0x0D42, 0x0EEE,
    0x0E8D, 0x0C15, 0x08FF, 0x0643, 0x0333, 0xFFB8, 0xFC5E, 0xF8C7, 0xF65A, 0xF657, 0xF7F2, 0xFA98, 0xFEA3, 0x0438, 0x0B9C, 0x1436,
    0x1E16, 0x29CB, 0x3545, 0x3DAB, 0x425E, 0x42B4, 0x3EBE, 0x3838, 0x2F41, 0x260B, 0x1E6B, 0x1656, 0x0B52, 0xFD25, 0xEDD3, 0xE1EB,
    0xD9CB, 0xD498, 0xD2C7, 0xD406, 0xD744, 0xD9A8, 0xDA7F, 0xD86F, 0xD4AB, 0xD190, 0xCD9D, 0xC97D, 0xC55D, 0xC1DC, 0xBF2B, 0xBEEF,
    0xC0B0, 0xC394, 0xC7F0, 0xCDC4, 0xD5C1, 0xDEA8, 0xE9BC, 0xF666, 0x0403, 0x10B5, 0x1B2E, 0x22BA, 0x2617, 0x254C, 0x20B1, 0x1AAA,
    0x145B, 0x0EBD, 0x089D, 0x015A, 0xF985, 0xF44B, 0xF21D, 0xF36F, 0xF6E2, 0xFAFF, 0xFFEF, 0x0502, 0x0707, 0x035B, 0xFFA8, 0xFE73,
    0xFE55, 0xFDE7, 0xFDA5, 0xFC0B, 0xFA13, 0xF888, 0xF7D3, 0xF85A, 0xFB89, 0x0068, 0x063D, 0x101A, 0x1BED, 0x2777, 0x3006, 0x3635,
    0x3B90, 0x3F82, 0x4113, 0x3E07, 0x376C, 0x2E9B, 0x259C, 0x1E7D, 0x15E4, 0x0A6E, 0xFE0B, 0xF1FD, 0xE7B4, 0xE155, 0xDD96, 0xDC60,
    0xDF02, 0xE251, 0xE3D5, 0xE374, 0xE284, 0xE03F, 0xDBE9, 0xD676, 0xD0AB, 0xC996, 0xC21F, 0xBDF3, 0xBD2A, 0xBF42, 0xC26C, 0xC5B2,
    0xCB2F, 0xD33E, 0xDDFD, 0xE9E7, 0xF5E6, 0x0063, 0x0990, 0x10E4, 0x13C8, 0x12AF, 0x0E24, 0x07BD, 0x004E, 0xF9A6, 0xF3DA, 0xEDD4,
    0xE69C, 0xDF20, 0xDA33, 0xD913, 0xDADF, 0xDE6E, 0xE387, 0xE867, 0xEB9F, 0xECC2, 0xEBF5, 0xEB5D, 0xEB6B, 0xEBC7, 0xEC90, 0xEC88,
    0xEBE1, 0xEA46, 0xE91A, 0xE9C0, 0xECE3, 0xF24E, 0xF9C9, 0x0386, 0x0F00, 0x1C13, 0x2A29, 0x384A, 0x444D, 0x4E46, 0x550F, 0x57E0,
    0x579A, 0x53F5, 0x4DEA, 0x47E6, 0x4282, 0x3B50, 0x3070, 0x2359, 0x17A4, 0x0EDB, 0x08E0, 0x05C3, 0x050B, 0x0674, 0x08DA, 0x093C,
    0x06D8, 0x0331, 0xFD7B, 0xF6FB, 0xF070, 0xE9BB, 0xE2BD, 0xDC87, 0xD8D8, 0xD6EF, 0xD757, 0xD8E9, 0xDC22, 0xE077, 0xE5CD, 0xECDB,
    0xF5CA, 0xFFFD, 0x095F, 0x125A, 0x193C, 0x1D5C, 0x1D16, 0x18B4, 0x1242, 0x0BB9, 0x06C8, 0x016E, 0xFAA7, 0xF1DD, 0xE92B, 0xE307,
    0xE01D, 0xDECE, 0xDDED, 0xDF89, 0xE3D6, 0xE6CF, 0xE72F, 0xE585, 0xE4BF, 0xE829, 0xECC8, 0xEF88, 0xF02C, 0xEFF3, 0xEEC3, 0xED05,
    0xECE4, 0xEF89, 0xF37D, 0xF8C2, 0x00A0, 0x0CF1, 0x1C03, 0x280C, 0x2FAD, 0x355D, 0x3A75, 0x3DA9, 0x3ED1, 0x3C17, 0x3505, 0x2D99,
    0x2607, 0x1D51, 0x1200, 0x0423, 0xF5DC, 0xEAD0, 0xE3EA, 0xDF31, 0xDD24, 0xDEA0, 0xE270, 0xE499, 0xE491, 0xE316, 0xE080, 0xDD7D,
    0xD9A6, 0xD5FC, 0xD14C, 0xCA88, 0xC2EB, 0xBD77, 0xBBBD, 0xBC57, 0xBEA3, 0xC1E2, 0xC656, 0xCCF6, 0xD6B4, 0xE30F, 0xEFFE, 0xFD58,
    0x098A, 0x1408, 0x1A90, 0x1B9D, 0x1995, 0x1486, 0x0F6E, 0x0B63, 0x0690, 0x002C, 0xF975, 0xF529, 0xF390, 0xF37D, 0xF5B0, 0xFA10,
    0xFE43, 0x02D0, 0x0465, 0x040A, 0x02EC, 0x01B6, 0x00E6, 0x0039, 0xFF8C, 0xFD42, 0xFAB0, 0xF77F, 0xF65C, 0xF697, 0xF852, 0xFB7A,
    0xFF76, 0x0508, 0x0B1F, 0x12B7, 0x1ADD, 0x2387, 0x2B1B, 0x326E, 0x3768, 0x393E, 0x3811, 0x32E5, 0x2D7B, 0x27F3, 0x21F7, 0x1852,
    0x0B90, 0xFE8E, 0xF330, 0xEB33, 0xE59D, 0xE2CF, 0xE2A5, 0xE43C, 0xE58B, 0xE5FF, 0xE548, 0xE409, 0xE29F, 0xE0B2, 0xDDED, 0xDAEB,
    0xD7C6, 0xD56F, 0xD462, 0xD4AD, 0xD742, 0xDB1D, 0xE0F3, 0xE7B4, 0xEF46, 0xF8E7, 0x03A5, 0x0E7D, 0x1953, 0x2235, 0x28F7, 0x2BDE,
    0x2A14, 0x25C8, 0x2009, 0x1AE1, 0x15E7, 0x0FC5, 0x07D6, 0xFEF0, 0xF728, 0xF2AB, 0xEFD3, 0xEE10, 0xEDE6, 0xEFA5, 0xF2C6, 0xF502,
    0xF567, 0xF374, 0xF526, 0xFB4E, 0x00CB, 0x02F8, 0x0312, 0x016D, 0xFE7B, 0xFC26, 0xFC52, 0xFE95, 0x00A2, 0x0312, 0x0755, 0x1041,
    0x1B02, 0x24B0, 0x2B89, 0x30F4, 0x36B7, 0x3B0C, 0x3C27, 0x37DE, 0x30F6, 0x2946, 0x20D8, 0x16E1, 0x0A38, 0xFD0A, 0xF22B, 0xEAE0,
    0xE59D, 0xE343, 0xE464, 0xE7E8, 0xEB9E, 0xEDD0, 0xEED8, 0xEDF1, 0xEBB9, 0xE892, 0xE588, 0xE2F1, 0xDF56, 0xDA10, 0xD39A, 0xCE91,
    0xCD27, 0xCE12, 0xCFDB, 0xD1AC, 0xD3D9, 0xD958, 0xE193, 0xEB0B, 0xF6BF, 0x02B6, 0x0E52, 0x177E, 0x198F, 0x16FB, 0x135C, 0x0FB0,
    0x0D31, 0x0ACD, 0x0689, 0xFF5D, 0xF7A5, 0xF194, 0xEDAD, 0xEADE, 0xE921, 0xE9DE, 0xEBFC, 0xEE51, 0xEFBA, 0xF09B, 0xF13F, 0xF1D9,
    0xF261, 0xF20B, 0xF0BD, 0xEE35, 0xEABB, 0xE7D5, 0xE751, 0xE98C, 0xED0E, 0xF12E, 0xF620, 0xFC74, 0x0429, 0x0D74, 0x177E, 0x2106,
    0x2A62, 0x321B, 0x3766, 0x38B9, 0x35DB, 0x30A9, 0x2B3B, 0x250C, 0x1C57, 0x10F6, 0x03F2, 0xF8CF, 0xEFDF, 0xE9AD, 0xE5C3, 0xE487,
    0xE5A6, 0xE6DE, 0xE7D2, 0xE7B6, 0xE72E, 0xE59F, 0xE35D, 0xE01F, 0xDC27, 0xD7AE, 0xD23C, 0xCE8C, 0xCC8A, 0xCCA8, 0xCE48, 0xD0CF,
    0xD457, 0xD8D6, 0xDF09, 0xE732, 0xF1BF, 0xFDA0, 0x09DA, 0x14BF, 0x1D0B, 0x20C4, 0x1FEC, 0x1CE2, 0x1A2E, 0x1885, 0x160D, 0x120F,
    0x0C4B, 0x068E, 0x02EE, 0x004A, 0xFF57, 0x0056, 0x024E, 0x069B, 0x0C9D, 0x10BA, 0x109A, 0x0F87, 0x11DF, 0x16DD, 0x1ABD, 0x1CD6,
    0x1CB7, 0x1B4D, 0x19E4, 0x1A2F, 0x1D34, 0x2029, 0x215D, 0x214B, 0x24B7, 0x2C6E, 0x34B2, 0x3ADA, 0x3FA9, 0x4454, 0x4846, 0x4A5A,
    0x48F7, 0x4477, 0x3E65, 0x3820, 0x3053, 0x2563, 0x1811, 0x0ABE, 0xFF3E, 0xF547, 0xEC4F, 0xE6B7, 0xE564, 0xE699, 0xE825, 0xE87A,
    0xE7DA, 0xE5F7, 0xE293, 0xDE82, 0xDA50, 0xD667, 0xD1A7, 0xCB4E, 0xC514, 0xC08F, 0xBE8C, 0xBE2F, 0xBEB0, 0xC011, 0xC309, 0xC882,
    0xD08B, 0xD98E, 0xE2BB, 0xECA7, 0xF5FD, 0xFD28, 0xFFBB, 0xFE26, 0xFBC1, 0xF9E6, 0xF87F, 0xF60B, 0xF15C, 0xEB59, 0xE635, 0xE1E6,
    0xDE3A, 0xDC99, 0xDE18, 0xE135, 0xE576, 0xE9B5, 0xECFE, 0xF019, 0xF1F3, 0xF284, 0xF22C, 0xF125, 0xEF62, 0xECC6, 0xEA69, 0xE9E7,
    0xEBD3, 0xEEB8, 0xF230, 0xF5F9, 0xFA1A, 0xFFF9, 0x0868, 0x13FE, 0x205A, 0x2CDD, 0x3896, 0x4189, 0x465F, 0x4673, 0x42ED, 0x3D57,
    0x3783, 0x30EB, 0x286E, 0x1D11, 0x1221, 0x08DD, 0x00A2, 0xFB60, 0xF95C, 0xFA30, 0xFB48, 0xFBB1, 0xFB26, 0xF9FC, 0xF7F0, 0xF4DC,
    0xF0D6, 0xEC11, 0xE724, 0xE1ED, 0xDD68, 0xDA00, 0xD911, 0xD973, 0xDAB0, 0xDCF5, 0xDFDE, 0xE48D, 0xEB72, 0xF423, 0xFCE8, 0x0673,
    0x0FFB, 0x18EF, 0x1E8E, 0x1FD6, 0x1E56, 0x1C4C, 0x1B1D, 0x1A5E, 0x18D7, 0x14EC, 0x0F09, 0x073B, 0xFF29, 0xF904, 0xF52C, 0xF1BB,
    0xF028, 0xF1FB, 0xF552, 0xF67B, 0xF345, 0xF0DD, 0xF1A6, 0xF415, 0xF5FF, 0xF6D2, 0xF6AA, 0xF53E, 0xF42B, 0xF60C, 0xFA60, 0xFE33,
    0x0089, 0x0318, 0x0A96, 0x155A, 0x1F3E, 0x278E, 0x2F2D, 0x3656, 0x3C61, 0x3EA3, 0x3C7F, 0x386B, 0x3408, 0x2F88, 0x28A9, 0x1ECC,
    0x13C7, 0x0A57, 0x0255, 0xFA0D, 0xF384, 0xF1B2, 0xF36B, 0xF6C1, 0xF9F7, 0xFCD4, 0xFECA, 0xFE9C, 0xFC40, 0xF876, 0xF47D, 0xF133,
    0xEDC6, 0xE8F5, 0xE429, 0xE0CE, 0xDECB, 0xDD64, 0xDC37, 0xDCAD, 0xE020, 0xE674, 0xEF53, 0xF99E, 0x0571, 0x116D, 0x1B99, 0x21CA,
    0x223D, 0x1F87, 0x1C99, 0x1AE3, 0x191A, 0x14B3, 0x0D81, 0x0490, 0xFC06, 0xF4E9, 0xEF78, 0xED68, 0xEE1C, 0xF08D, 0xF323, 0xF4C9,
    0xF4C2, 0xF378, 0xF17A, 0xEE08, 0xEA7D, 0xE6DC, 0xE397, 0xDFE6, 0xDD0A, 0xDC8B, 0xDDA8, 0xE046, 0xE337, 0xE6B4, 0xEB41, 0xF25E,
    0xFB63, 0x0617, 0x11B9, 0x1DB2, 0x2904, 0x3153, 0x352D, 0x3464, 0x3206, 0x2F56, 0x2C31, 0x26E0, 0x1F12, 0x153E, 0x0A66, 0xFFE7,
    0xF667, 0xF039, 0xECBE, 0xEBB0, 0xEBF6, 0xEBE2, 0xEB82, 0xEA67, 0xE8C0, 0xE67F, 0xE3F3, 0xE12B, 0xDD62, 0xD8D1, 0xD492, 0xD1E1,
    0xD12C, 0xD29E, 0xD4A9, 0xD744, 0xDB8B, 0xE1BC, 0xE903, 0xF003, 0xF7C3, 0x000F, 0x0850, 0x0F0C, 0x1286, 0x123E, 0x1004, 0x0E1A,
    0x0CC5, 0x0A75, 0x071B, 0x0241, 0xFAC7, 0xF2B6, 0xEC5D, 0xE93C, 0xE75D, 0xE580, 0xE67F, 0xEA8A, 0xEE89, 0xF052, 0xEE2B, 0xECF4,
    0xEEFB, 0xF250, 0xF69F, 0xF97F, 0xFB33, 0xFB11, 0xFB04, 0xFDE8, 0x01EC, 0x04FA, 0x076D, 0x0B9C, 0x14C3, 0x202B, 0x2AB8, 0x349E,
    0x3E11, 0x4689, 0x4B4B, 0x4BA2, 0x48DD, 0x44E2, 0x4084, 0x3AC1, 0x31F9, 0x2737, 0x1C33, 0x1220, 0x08A2, 0xFFE3, 0xF99A, 0xF6D1,
    0xF694, 0xF71E, 0xF82B, 0xF88E, 0xF864, 0xF63C, 0xF258, 0xED7F, 0xE95A, 0xE634, 0xE235, 0xDF09, 0xDCA6, 0xDC08, 0xDCB9, 0xDDC6,
    0xDECE, 0xE092, 0xE4CE, 0xEAA9, 0xF28A, 0xFBD2, 0x069A, 0x124C, 0x1C7E, 0x225D, 0x24E7, 0x2648, 0x280E, 0x2A4E, 0x2AD6, 0x284E,
    0x22F6, 0x1BFC, 0x134A, 0x0BB0, 0x064B, 0x03FA, 0x04A6, 0x0644, 0x07E8, 0x0941, 0x09D7, 0x096C, 0x07ED, 0x0577, 0x03A7, 0x00D0,
    0xFCA1, 0xF75A, 0xF2B2, 0xF101, 0xF169, 0xF32F, 0xF5E1, 0xF9BD, 0xFFAE, 0x0710, 0x0FA2, 0x1951, 0x243A, 0x2F0E, 0x3818, 0x3D1E,
    0x3D15, 0x3987, 0x33F9, 0x2DD5, 0x26E3, 0x1D8E, 0x11FD, 0x0599, 0xF8B2, 0xECEE, 0xE31F, 0xDC44, 0xD89E, 0xD740, 0xD6F0, 0xD64F,
    0xD556, 0xD367, 0xD17B, 0xCFA0, 0xCE69, 0xCCD6, 0xCA4E, 0xC7AB, 0xC4F2, 0xC40E, 0xC530, 0xC723, 0xC95D, 0xCCDB, 0xD2C5, 0xDAC8,
    0xE43D, 0xEE14, 0xF8E3, 0x04DE, 0x10CA, 0x1A5B, 0x1F3F, 0x2145, 0x221D, 0x222F, 0x2132, 0x1EAF, 0x1BE3, 0x16D1, 0x0F0E, 0x077B,
    0x02D7, 0x0181, 0x0118, 0x00B9, 0x01DA, 0x050D, 0x0705, 0x0655, 0x021A, 0xFEE3, 0xFF88, 0x0219, 0x0532, 0x0659, 0x04FD, 0x0243,
    0x00F0, 0x027B, 0x0503, 0x0613, 0x07BE, 0x0BC1, 0x131C, 0x1CE2, 0x24EA, 0x2B81, 0x3241, 0x3857, 0x3B94, 0x3B61, 0x3957, 0x375C,
    0x34D3, 0x30B5, 0x298E, 0x1FA1, 0x14CF, 0x0983, 0xFE82, 0xF47F, 0xED07, 0xE831, 0xE509, 0xE35A, 0xE264, 0xE2B6, 0xE39B, 0xE359,
    0xE191, 0xDEDE, 0xDBC5, 0xD7EC, 0xD397, 0xD016, 0xCF1D, 0xD10F, 0xD417, 0xD692, 0xD94C, 0xDCA0, 0xE026, 0xE485, 0xE985, 0xF0CF,
    0xFA5D, 0x03B2, 0x0B21, 0x0E6F, 0x0EFD, 0x0DD3, 0x0C19, 0x0A42, 0x0748, 0x02AB, 0xFC55, 0xF446, 0xEC17, 0xE59F, 0xE20C, 0xE218,
    0xE436, 0xE771, 0xEAAD, 0xED9D, 0xF038, 0xF25B, 0xF450, 0xF55A, 0xF5C7, 0xF550, 0xF368, 0xF1BB, 0xF09D, 0xF121, 0xF34E, 0xF6A9,
    0xFBED, 0x030D, 0x0C96, 0x179C, 0x23F1, 0x3204, 0x4086, 0x4DA7, 0x572A, 0x5B9A, 0x5BCB, 0x599E, 0x561B, 0x5160, 0x4AE6, 0x42AF,
    0x3922, 0x2ECD, 0x23E1, 0x19FD, 0x1329, 0x0F13, 0x0D31, 0x0C26, 0x0B88, 0x09E1, 0x06F2, 0x0338, 0xFEED, 0xFACC, 0xF62F, 0xF10E,
    0xEAFA, 0xE4C4, 0xDFDB, 0xDD71, 0xDD02, 0xDD58, 0xDE76, 0xE13A, 0xE56E, 0xEA41, 0xEF44, 0xF4E1, 0xFC34, 0x045A, 0x0BB4, 0x1022,
    0x11C9, 0x12AD, 0x12B1, 0x10DC, 0x0E02, 0x0A5A, 0x0589, 0xFE13, 0xF3D3, 0xEBC3, 0xE7B9, 0xE58C, 0xE39D, 0xE271, 0xE316, 0xE688,
    0xE9C8, 0xEA97, 0xEA29, 0xE8D4, 0xE940, 0xEC95, 0xF113, 0xF394, 0xF381, 0xF374, 0xF55A, 0xF939, 0xFD7B, 0x0143, 0x050C, 0x0BAB,
    0x14EB, 0x1F7A, 0x2AF0, 0x343F, 0x3B09, 0x3F23, 0x3F9B, 0x3D06, 0x3916, 0x3595, 0x3173, 0x2B76, 0x2329, 0x1863, 0x0CBB, 0x017F,
    0xF890, 0xF259, 0xED33, 0xE957, 0xE5DE, 0xE375, 0xE22F, 0xE139, 0xE0B6, 0xDF69, 0xDDA2, 0xDB40, 0xD829, 0xD447, 0xD0B9, 0xCDFD,
    0xCD51, 0xCF0E, 0xD14A, 0xD438, 0xD7A6, 0xDB67, 0xDFB7, 0xE53B, 0xECAC, 0xF6EA, 0x02E2, 0x0E04, 0x16A3, 0x1BE8, 0x1E2D, 0x1E68,
    0x1DA8, 0x1B58, 0x187A, 0x13AA, 0x0D40, 0x061E, 0xFFAD, 0xFC00, 0xFACA, 0xFB9D, 0xFD70, 0x004B, 0x0311, 0x0553, 0x072C, 0x088A,
    0x093A, 0x08E8, 0x06EA, 0x0332, 0xFE4D, 0xF988, 0xF698, 0xF55F, 0xF516, 0xF5AC, 0xF893, 0xFD42, 0x0303, 0x0A1C, 0x12AF, 0x1DA3,
    0x2A28, 0x34E0, 0x3BAA, 0x3F4C, 0x3FEE, 0x3E98, 0x3BD0, 0x377D, 0x31E4, 0x2AD3, 0x21EE, 0x17C0, 0x0DBB, 0x0546, 0xFECB, 0xFA4C,
    0xF831, 0xF7DA, 0xF8FE, 0xFA44, 0xFAF5, 0xFAD9, 0xF9C3, 0xF782, 0xF40A, 0xEFC5, 0xEB90, 0xE832, 0xE6E9, 0xE7F1, 0xEA62, 0xED5A,
    0xF07C, 0xF4D4, 0xFA01, 0xFFC8, 0x06A4, 0x0F60, 0x1A8B, 0x2502, 0x2B97, 0x2E1F, 0x2E65, 0x2E35, 0x2C35, 0x284F, 0x23DC, 0x1F5C,
    0x18F8, 0x0ED1, 0x03A9, 0xFB28, 0xF710, 0xF516, 0xF324, 0xF21E, 0xF2C2, 0xF522, 0xF777, 0xF839, 0xF6B0, 0xF42A, 0xF25E, 0xF1B6,
    0xF2EB, 0xF48A, 0xF457, 0xF303, 0xF245, 0xF22D, 0xF304, 0xF534, 0xF84D, 0xFD63, 0x069C, 0x138D, 0x2112, 0x2D86, 0x35EB, 0x3893,
    0x3723, 0x33FA, 0x309A, 0x2D56, 0x2A6F, 0x25E2, 0x1EDA, 0x15A6, 0x0C44, 0x04C7, 0xFF8B, 0xFD29, 0xFBDD, 0xFB81, 0xFB37, 0xFA64,
    0xF9B9, 0xF8DF, 0xF885, 0xF730, 0xF3EA, 0xEF5B, 0xEA26, 0xE4D0, 0xE079, 0xDE19, 0xDD61, 0xDDBD, 0xDF36, 0xE1AC, 0xE44B, 0xE6A0,
    0xE913, 0xECEC, 0xF31F, 0xFB37, 0x038F, 0x0B9F, 0x11B7, 0x165A, 0x194E, 0x19F8, 0x197C, 0x17D7, 0x14EA, 0x0F69, 0x0780, 0xFEEE,
    0xF73E, 0xF146, 0xED60, 0xEB4D, 0xEB6F, 0xED03, 0xEF0D, 0xF120, 0xF2A4, 0xF3D9, 0xF403, 0xF2B9, 0xEF84, 0xEAD2, 0xE653, 0xE312,
    0xE106, 0xDFBB, 0xDFCE, 0xE1DF, 0xE5DE, 0xEBFF, 0xF415, 0xFED8, 0x0B8B, 0x1A0C, 0x274F, 0x312A, 0x3791, 0x3A8C, 0x3B5F, 0x3A13,
    0x3747, 0x33A2, 0x2E9E, 0x26EA, 0x1CCF, 0x11AE, 0x0818, 0x0153, 0xFCC1, 0xF9FC, 0xF865, 0xF7BE, 0xF6CC, 0xF539, 0xF3B3, 0xF0F7,
    0xEC85, 0xE7EC, 0xE1FE, 0xDBC6, 0xD669, 0xD287, 0xD09C, 0xD035, 0xD013, 0xD10F, 0xD35C, 0xD6C2, 0xDBC0, 0xE25E, 0xEBC8, 0xF82B,
    0x071F, 0x13A3, 0x1C31, 0x21AF, 0x2595, 0x25AB, 0x2423, 0x227E, 0x2230, 0x2239, 0x2025, 0x1A9C, 0x0E8F, 0x0A31, 0x0A2A, 0x0B4A,
    0x0D38, 0x0EE2, 0x1232, 0x1590, 0x199A, 0x1B76, 0x1BD3, 0x1822, 0x1358, 0x107C, 0x0F47, 0x0FD5, 0x10AB, 0x1107, 0x11FE, 0x14B1,
    0x18B7, 0x1C22, 0x1F97, 0x2525, 0x2D38, 0x37E0, 0x43EF, 0x4C4A, 0x5158, 0x5034, 0x4B07, 0x46A5, 0x4125, 0x3E96, 0x3D12, 0x3923,
    0x3362, 0x2D1A, 0x21B4, 0x15C1, 0x0C33, 0x04A5, 0xFDF0, 0xF89D, 0xF691, 0xF2B2, 0xEED1, 0xEA8D, 0xE6F5, 0xE309, 0xDDA4, 0xD730,
    0xD0AC, 0xCC10, 0xC996, 0xC8A9, 0xC785, 0xC6EE, 0xC892, 0xCB79, 0xCEDF, 0xD340, 0xD84C, 0xDF70, 0xE7A0, 0xF0D9, 0xF6DC, 0xF7A5,
    0xF9A5, 0xFB9C, 0xFDA6, 0x001E, 0x01B3, 0x0413, 0x03C5, 0x032E, 0xFFE7, 0xFA2B, 0xF30E, 0xED8B, 0xE8AE, 0xE3DC, 0xE3D1, 0xE498,
    0xE6DA, 0xE8FC, 0xEC7F, 0xEFB6, 0xF2E4, 0xF461, 0xF50B, 0xF1D4, 0xEF96, 0xEA17, 0xE1E2, 0xE1EF, 0xE271, 0xE64C, 0xEC33, 0xF42B,
    0xFE46, 0x0A2B, 0x1933, 0x26AE, 0x2DC6, 0x328E, 0x35FF, 0x3714, 0x36DA, 0x3650, 0x3511, 0x341C, 0x31DD, 0x2EB2, 0x2B6F, 0x2692,
    0x20BB, 0x19FF, 0x1481, 0x0DCE, 0x08A1, 0x04A2, 0x01E3, 0xFF7A, 0xFD0B, 0xFA2A, 0xF71C, 0xF2DF, 0xEE9B, 0xEAD3, 0xE763, 0xE592,
    0xDF8C, 0xDC18, 0xDAE3, 0xDA8C, 0xDBFC, 0xDAF1, 0xDED3, 0xE5D9, 0xEBF5, 0xF469, 0xFC67, 0x0177, 0x04F4, 0x08C9, 0x0C40, 0x100C,
    0x1255, 0x152B, 0x1978, 0x1C0E, 0x1CFA, 0x1AF5, 0x1600, 0x1054, 0x0C2C, 0x0749, 0x014B, 0xFBD1, 0xF7F6, 0xF6D6, 0xF837, 0xF981,
    0xF84E, 0xF3F1, 0xEFFF, 0xEE3E, 0xEEC1, 0xF273, 0xF3DF, 0xF34D, 0xF48A, 0xF7A2, 0xFCE7, 0x0090, 0x02DD, 0x0970, 0x11AF, 0x1B7F,
    0x2585, 0x2CF1, 0x31A7, 0x3396, 0x32E9, 0x306F, 0x2E85, 0x2D79, 0x2E3D, 0x2EAD, 0x2DCC, 0x2D09, 0x2B63, 0x28D3, 0x258E, 0x21CB,
    0x1D44, 0x1775, 0x0FEA, 0x074D, 0xFFCE, 0xF9C8, 0xF5BA, 0xF275, 0xEF66, 0xED55, 0xEB07, 0xE9A8, 0xE834, 0xE497, 0xE09A, 0xDD2A,
    0xDBED, 0xDC63, 0xDC8C, 0xDE58, 0xE198, 0xE573, 0xEA48, 0xEF3F, 0xF338, 0xF6EC, 0xFA77, 0xFD6E, 0x0128, 0x0466, 0x07BE, 0x0AA9,
    0x0C06, 0x0C94, 0x0D55, 0x0D4B, 0x0BD6, 0x0911, 0x04E1, 0x003F, 0xFB80, 0xF7AB, 0xF479, 0xF26B, 0xF169, 0xF10E, 0xF092, 0xEFDF,
    0xEEEA, 0xED4B, 0xED01, 0xEC09, 0xEAA3, 0xE920, 0xE82F, 0xE9A1, 0xEB86, 0xEDA0, 0xF0B3, 0xF558, 0xFB2B, 0x01BF, 0x0847, 0x0E22,
    0x1343, 0x16D5, 0x19D2, 0x1CD6, 0x1F07, 0x2079, 0x205C, 0x1ED2, 0x1D58, 0x1BB7, 0x19E1, 0x169C, 0x124F, 0x0D4A, 0x0716, 0x004A,
    0xF880, 0xF158, 0xEB13, 0xE650, 0xE258, 0xDFE6, 0xDEAE, 0xDD78, 0xDD17, 0xDCB4, 0xDCBD, 0xDC5E, 0xDAF8, 0xD9A4, 0xD9F5, 0xDA82,
    0xDA91, 0xDAF8, 0xDC12, 0xDF17, 0xE273, 0xE5B1, 0xE892, 0xEBEF, 0xEF59, 0xF179, 0xF367, 0xF5A4, 0xF90B, 0xFB9D, 0xFCD2, 0xFC92,
    0xFC99, 0xFC90, 0xFC88, 0xFC4A, 0xFA89, 0xF768, 0xF393, 0xF24E, 0xF354, 0xF57E, 0xF640, 0xF3CF, 0xF0D9, 0xEF7E, 0xF103, 0xF48E,
    0xF87D, 0xFD28, 0x0297, 0x07F4, 0x0D1E, 0x11B9, 0x14D8, 0x1713, 0x1A0C, 0x1DFF, 0x22EF, 0x2720, 0x2A0B, 0x2A57, 0x2744, 0x21CD,
    0x1BBB, 0x169C, 0x12ED, 0x10B0, 0x0EEC, 0x0E56, 0x0EA6, 0x0F6C, 0x1036, 0x103A, 0x0F5C, 0x0CC0, 0x07D7, 0x011B, 0xFA71, 0xF4A6,
    0xF060, 0xECDF, 0xEA21, 0xE898, 0xE7A4, 0xE806, 0xE90B, 0xEA65, 0xEBEC, 0xED07, 0xEE03, 0xEF4F, 0xF098, 0xF16E, 0xF206, 0xF1AE,
    0xF093, 0xEF8B, 0xEFB3, 0xF146, 0xF396, 0xF6F8, 0xFB0D, 0x0015, 0x04EB, 0x08C8, 0x0B61, 0x0CBB, 0x0DC8, 0x0EB6, 0x0F61, 0x0F9B,
    0x0F6B, 0x0E4E, 0x0C4E, 0x094D, 0x06BB, 0x04B3, 0x0344, 0x0202, 0x00C5, 0xFFB2, 0xFEBE, 0xFE2A, 0xFD82, 0xFCFE, 0xFC92, 0xFD29,
    0xFDEB, 0xFE54, 0xFEEB, 0xFF58, 0xFF5A, 0xFF9F, 0x0015, 0x007C, 0x010D, 0x00E7, 0x0090, 0xFF3A, 0xFD72, 0xFBAC, 0xFA02, 0xF8A1,
    0xF6EA, 0xF58B, 0xF4D0, 0xF478, 0xF485, 0xF43F, 0xF29E, 0xF069, 0xECE4, 0xE89A, 0xE462, 0xE0F7, 0xDE78, 0xDCA1, 0xDB75, 0xDA27,
    0xD9C7, 0xD983, 0xD94B, 0xD9A3, 0xDAD1, 0xDC8D, 0xDDBF, 0xDEB6, 0xDF96, 0xE06E, 0xE0D8, 0xE182, 0xE333, 0xE570, 0xE7C0, 0xEA0C,
    0xEC54, 0xEF54, 0xF249, 0xF4CD, 0xF6A1, 0xF82E, 0xFAE6, 0xFDCD, 0x0026, 0x023D, 0x036C, 0x055D, 0x0868, 0x0BD9, 0x0E02, 0x0DEC,
    0x0CC6, 0x0C53, 0x0DBE, 0x0F11, 0x0DEB, 0x08F8, 0x028A, 0xFDBC, 0xFBB4, 0xFC97, 0xFF33, 0x034A, 0x0867, 0x0E24, 0x138F, 0x172C,
    0x18EF, 0x1988, 0x1994, 0x19BA, 0x1AC1, 0x1C27, 0x1D0F, 0x1C6A, 0x19CA, 0x15AD, 0x116B, 0x0E13, 0x0B76, 0x098B, 0x083E, 0x0829,
    0x082F, 0x07F8, 0x079A, 0x071D, 0x06B8, 0x050F, 0x0152, 0xFB7E, 0xF561, 0xF07D, 0xEC67, 0xE95C, 0xE702, 0xE571, 0xE54B, 0xE5CA,
    0xE6F7, 0xE906, 0xEB2F, 0xECE7, 0xEE43, 0xEF11, 0xEFB6, 0xF074, 0xF07E, 0xEF17, 0xEC60, 0xE93A, 0xE604, 0xE333, 0xE0D2, 0xDF82,
    0xDF50, 0xE01F, 0xE115, 0xE194, 0xE267, 0xE36D, 0xE537, 0xE732, 0xE908, 0xEAB7, 0xEBBD, 0xEC75, 0xED30, 0xEE0C, 0xEF7E, 0xF1C6,
    0xF4A9, 0xF751, 0xF993, 0xFBE1, 0xFE3F, 0x0172, 0x0511, 0x0895, 0x0C14, 0x0F93, 0x131F, 0x16CA, 0x1A89, 0x1E8B, 0x22FB, 0x274D,
    0x2B14, 0x2E78, 0x30D4, 0x31C4, 0x307B, 0x2D65, 0x2A0F, 0x270C, 0x2490, 0x2298, 0x2135, 0x2074, 0x204D, 0x206F, 0x2050, 0x1FBB,
    0x1E80, 0x1CE6, 0x1AC0, 0x1817, 0x157A, 0x133D, 0x109F, 0x0CE6, 0x08BE, 0x0521, 0x021D, 0xFF76, 0xFD59, 0xFC63, 0xFC25, 0xFB87,
    0xFA4D, 0xF905, 0xF74B, 0xF48C, 0xF124, 0xEE2E, 0xEBFB, 0xEA3D, 0xE84B, 0xE699, 0xE59E, 0xE604, 0xE6CE, 0xE6D8, 0xE669, 0xE569,
    0xE54F, 0xE625, 0xE726, 0xE76C, 0xE73D, 0xE7E6, 0xEA6A, 0xEE03, 0xF0E5, 0xF1C2, 0xF184, 0xF340, 0xF745, 0xFC07, 0xFE51, 0xFD3C,
    0xFAA3, 0xF824, 0xF76A, 0xF88F, 0xFBB0, 0x0007, 0x05C9, 0x0D33, 0x14A1, 0x1B4B, 0x20DA, 0x24AB, 0x2730, 0x2973, 0x2B04, 0x2C74,
    0x2CC3, 0x2AC6, 0x26E5, 0x2192, 0x1BB9, 0x15D3, 0x110A, 0x0DD5, 0x0C74, 0x0BB6, 0x0A52, 0x0842, 0x057A, 0x030B, 0x010C, 0xFF21,
    0xFCAB, 0xF9D3, 0xF6DE, 0xF3E0, 0xF105, 0xEDFA, 0xEB93, 0xEA4E, 0xEA18, 0xEAA9, 0xEBB3, 0xEC76, 0xECC1, 0xECE9, 0xEC99, 0xEC5A,
    0xECDE, 0xEE60, 0xF0DD, 0xF33E, 0xF4EA, 0xF5EF, 0xF585, 0xF3F0, 0xF1B8, 0xF010, 0xEF6F, 0xEFA7, 0xF037, 0xF0FD, 0xF24F, 0xF481,
    0xF725, 0xF9BC, 0xFCA8, 0xFFAF, 0x02E2, 0x05CD, 0x07F4, 0x0966, 0x0A45, 0x0A4A, 0x09C8, 0x0959, 0x08BC, 0x081F, 0x0808, 0x0871,
    0x093A, 0x0A33, 0x0B09, 0x0B6C, 0x0BCD, 0x0C24, 0x0D5E, 0x0F44, 0x10F0, 0x1251, 0x1319, 0x143E, 0x1556, 0x15B0, 0x1587, 0x148F,
    0x13E8, 0x13A7, 0x13B3, 0x13E8, 0x1422, 0x145A, 0x149A, 0x14F8, 0x14F3, 0x146A, 0x1348, 0x118E, 0x0F8E, 0x0DB8, 0x0CA9, 0x0BA9,
    0x0A4F, 0x0882, 0x06D2, 0x05D5, 0x0575, 0x0547, 0x05DA, 0x06D4, 0x07E8, 0x08BF, 0x0946, 0x094B, 0x08B7, 0x0824, 0x0738, 0x0695,
    0x06D1, 0x06F0, 0x06D7, 0x05F7, 0x052B, 0x0464, 0x038B, 0x0288, 0x0019, 0xFD7A, 0xFBF2, 0xFB80, 0xFAFE, 0xF982, 0xF717, 0xF539,
    0xF53F, 0xF708, 0xF81C, 0xF749, 0xF5D5, 0xF5B4, 0xF7C5, 0xFAEE, 0xFD9A, 0xFDF1, 0xFC42, 0xF9C1, 0xF7AB, 0xF6BB, 0xF6C0, 0xF875,
    0xFBAE, 0x00C6, 0x076A, 0x0E8D, 0x1585, 0x1B46, 0x200E, 0x2379, 0x2645, 0x286E, 0x2985, 0x296B, 0x278C, 0x244A, 0x2000, 0x1B4A,
    0x16BD, 0x1328, 0x10C2, 0x0F69, 0x0DC9, 0x0BD7, 0x0A98, 0x0A7C, 0x0ABA, 0x0ABD, 0x09EF, 0x07FA, 0x059C, 0x027E, 0xFF0A, 0xFBAC,
    0xF94C, 0xF8A8, 0xF92C, 0xFA29, 0xFB0C, 0xFB6A, 0xFB05, 0xFA18, 0xF8D5, 0xF749, 0xF669, 0xF613, 0xF69A, 0xF78A, 0xF8BE, 0xF9C9,
    0xF93D, 0xF80D, 0xF6BD, 0xF5C3, 0xF4D3, 0xF36F, 0xF1A9, 0xF053, 0xEF8C, 0xEF2B, 0xEF99, 0xEFEB, 0xF087, 0xF140, 0xF27A, 0xF35A,
    0xF43B, 0xF558, 0xF5FC, 0xF6CD, 0xF799, 0xF884, 0xF960, 0xFA3D, 0xFB79, 0xFD34, 0xFF9C, 0x0205, 0x04AF, 0x0765, 0x0A2D, 0x0D10,
    0x1059, 0x13E2, 0x16A7, 0x1932, 0x1AD2, 0x1B9E, 0x1C0B, 0x1B50, 0x1970, 0x1751, 0x1553, 0x13B0, 0x123B, 0x10E1, 0x0F54, 0x0D96,
    0x0B7E, 0x08AD, 0x05D4, 0x02AB, 0xFF65, 0xFB52, 0xF704, 0xF394, 0xF0D3, 0xEE22, 0xEB58, 0xE923, 0xE81B, 0xE7C6, 0xE7BB, 0xE7EB,
    0xE866, 0xE8FF, 0xE90D, 0xE893, 0xE809, 0xE865, 0xE9A0, 0xEB38, 0xED20, 0xF03F, 0xF477, 0xF873, 0xFBE8, 0xFE46, 0x00A4, 0x03C0,
    0x0734, 0x0A06, 0x0B4D, 0x0BBE, 0x0C83, 0x0E4B, 0x10B9, 0x1287, 0x13E5, 0x159C, 0x1907, 0x1D54, 0x205D, 0x2198, 0x213D, 0x2075,
    0x214A, 0x233B, 0x2534, 0x25EE, 0x2497, 0x220B, 0x1EBB, 0x1BDB, 0x19D6, 0x1973, 0x1B48, 0x1F18, 0x247F, 0x2A59, 0x2F5D, 0x3279,
    0x33E5, 0x342E, 0x343E, 0x34E2, 0x35A9, 0x3686, 0x3641, 0x3476, 0x30A4, 0x2AD0, 0x2462, 0x1DF4, 0x1896, 0x1369, 0x0DC4, 0x07E0,
    0x023D, 0xFCF1, 0xF86C, 0xF432, 0xF07E, 0xECA2, 0xE8AF, 0xE4DD, 0xE0A0, 0xDD15, 0xD9DD, 0xD80C, 0xD754, 0xD71E, 0xD77D, 0xD828,
    0xD8F3, 0xD961, 0xDA32, 0xDB60, 0xDCC8, 0xDEFC, 0xE1BB, 0xE595, 0xE97A, 0xECC7, 0xEE80, 0xEE9E, 0xEE0E, 0xED5B, 0xECCD, 0xEBDC,
    0xEB27, 0xEA7A, 0xE9D4, 0xE958, 0xE942, 0xE952, 0xE9CA, 0xEA37, 0xEA45, 0xEAE7, 0xEBD1, 0xED3A, 0xEE53, 0xEF48, 0xEFBD, 0xF01C,
    0xF111, 0xF1CE, 0xF319, 0xF4C3, 0xF670, 0xF880, 0xFAFA, 0xFDBC, 0x0135, 0x0539, 0x097F, 0x0E06, 0x11EC, 0x1513, 0x1760, 0x1907,
    0x1A15, 0x1A3B, 0x1A08, 0x1991, 0x18F0, 0x17AF, 0x1668, 0x154A, 0x1462, 0x13A0, 0x12FC, 0x1231, 0x1167, 0x1085, 0x0E82, 0x0B71,
    0x0782, 0x03E5, 0x009F, 0xFDBC, 0xFB79, 0xF98B, 0xF8BF, 0xF816, 0xF798, 0xF77A, 0xF78C, 0xF78C, 0xF6E8, 0xF5F3, 0xF561, 0xF55E,
    0xF50E, 0xF398, 0xF227, 0xF1C4, 0xF305, 0xF5B0, 0xF804, 0xF9BD, 0xFB5F, 0xFD89, 0xFFCC, 0x00F4, 0x0076, 0xFF2D, 0xFE41, 0xFE32,
    0xFE2F, 0xFCB7, 0xF9C0, 0xF6DE, 0xF574, 0xF571, 0xF5C6, 0xF48A, 0xF275, 0xF08A, 0xF05B, 0xF1F5, 0xF404, 0xF5DD, 0xF648, 0xF5AA,
    0xF45C, 0xF337, 0xF349, 0xF4ED, 0xF88C, 0xFE42, 0x063F, 0x0F8D, 0x18AB, 0x2087, 0x2670, 0x2AB4, 0x2D82, 0x2F72, 0x3179, 0x342F,
    0x36D2, 0x37E9, 0x36E7, 0x33F0, 0x2F9B, 0x2B7C, 0x27D2, 0x2442, 0x204D, 0x1B1E, 0x15A3, 0x0FD8, 0x0AD2, 0x06BB, 0x0398, 0x0156,
    0xFF2B, 0xFDAF, 0xFBF0, 0xFA24, 0xF801, 0xF602, 0xF4B2, 0xF34B, 0xF29D, 0xF1AF, 0xF0A2, 0xEFE8, 0xEF89, 0xEFD4, 0xF0B7, 0xF287,
    0xF587, 0xF98A, 0xFDC1, 0x0102, 0x02A0, 0x0227, 0x003B, 0xFD29, 0xF99F, 0xF5C6, 0xF1BC, 0xEEC0, 0xECB1, 0xEB67, 0xEB3F, 0xEBBF,
    0xEC47, 0xEC7F, 0xEC04, 0xEBD1, 0xEBDA, 0xEC05, 0xEC1B, 0xEBFF, 0xEC25, 0xEC1E, 0xEC59, 0xEC6F, 0xECD2, 0xEE59, 0xF10D, 0xF546,
    0xF95D, 0xFD68, 0x0112, 0x040B, 0x0692, 0x08C6, 0x0AEE, 0x0C87, 0x0DD3, 0x0F07, 0x101F, 0x10EE, 0x11CD, 0x1249, 0x1200, 0x1136,
    0x108A, 0x1012, 0x0F98, 0x0EC6, 0x0CEB, 0x0A83, 0x07F2, 0x04FD, 0x0108, 0xFC18, 0xF7D8, 0xF4B0, 0xF282, 0xF0BB, 0xEF69, 0xEE6B,
    0xED88, 0xEC5C, 0xEBA0, 0xEB3E, 0xEB01, 0xEA84, 0xE93B, 0xE7B2, 0xE70B, 0xE767, 0xE859, 0xE919, 0xE969, 0xEA95, 0xECBE, 0xEED7,
    0xEFC2, 0xEFDE, 0xEFEA, 0xF0AF, 0xF194, 0xF167, 0xEFCB, 0xED83, 0xEC24, 0xEBC3, 0xEB8A, 0xEA5A, 0xE819, 0xE57C, 0xE442, 0xE49D,
    0xE631, 0xE76F, 0xE7D4, 0xE837, 0xE95E, 0xEC0E, 0xEF61, 0xF2BB, 0xF548, 0xF6FC, 0xF75F, 0xF7ED, 0xF8B9, 0xF956, 0xFBD0, 0x0049,
    0x0702, 0x0F39, 0x17CA, 0x1FDB, 0x266D, 0x2B51, 0x2E07, 0x2EBA, 0x2ED7, 0x2F71, 0x3067, 0x30AA, 0x2EA2, 0x2AC9, 0x25F1, 0x2150,
    0x1DAE, 0x1A8C, 0x1779, 0x13A4, 0x0F46, 0x0AB2, 0x0720, 0x04CF, 0x0363, 0x02DF, 0x02DB, 0x02BF, 0x023C, 0x00BE, 0xFF20, 0xFD97,
    0xFD19, 0xFDE1, 0xFEDC, 0xFFB9, 0xFFD1, 0xFF92, 0xFEBD, 0xFDAC, 0xFD37, 0xFD96, 0xFF6C, 0x0306, 0x0732, 0x0A8F, 0x0D0A, 0x0DF8,
    0x0DD1, 0x0C6C, 0x0A8A, 0x0850, 0x05CC, 0x039E, 0x0144, 0xFF4C, 0xFD6A, 0xFBD0, 0xFA46, 0xF91A, 0xF8BA, 0xF923, 0xF9FC, 0xFAC6,
    0xFB20, 0xFAA5, 0xF9B5, 0xF827, 0xF6E7, 0xF616, 0xF5DD, 0xF6D9, 0xF8C1, 0xFB78, 0xFE61, 0x01BF, 0x0600, 0x0982, 0x0B85, 0x0D82,
    0x0ED1, 0x0F88, 0x0FBA, 0x0F6D, 0x0EF9, 0x0E4F, 0x0D56, 0x0B88, 0x0968, 0x0711, 0x056F, 0x0439, 0x031C, 0x0169, 0xFEDC, 0xFC29,
    0xF8F4, 0xF4CE, 0xF034, 0xEC01, 0xE8AD, 0xE646, 0xE4C8, 0xE479, 0xE47B, 0xE51C, 0xE57D, 0xE5C9, 0xE5E5, 0xE62B, 0xE64C, 0xE58A,
    0xE444, 0xE347, 0xE2EC, 0xE3EC, 0xE54C, 0xE72B, 0xE9E7, 0xEDBA, 0xF1D6, 0xF5C8, 0xF852, 0xF942, 0xF9EE, 0xFB2A, 0xFC1F, 0xFCEB,
    0xFC53, 0xFB06, 0xFB30, 0xFCE9, 0xFFB7, 0x00B6, 0x0154, 0x005E, 0x0062, 0x01C9, 0x047B, 0x0578, 0x0600, 0x04F0, 0x03D0, 0x02E5,
    0x03B3, 0x048B, 0x05D5, 0x0868, 0x0A4E, 0x0B0A, 0x0466, 0x0E8D, 0x0CCB, 0x0AC5, 0x06A0, 0x0DBE, 0x1B5C, 0x107B, 0x21E5, 0x20FA,
    0x2894, 0x21B5, 0x1E18, 0x2878, 0x2211, 0x2516, 0x26AA, 0x2429, 0x211D, 0x2AB6, 0x18CF, 0x21D7, 0x17E5, 0x10F3, 0x05DA, 0xF59E,
    0x0140, 0xF76E, 0xED85, 0xE951, 0xF78C, 0xE02A, 0xD3F1, 0xD377, 0xE721, 0x02C5, 0xBD4E, 0xDB8E, 0x00FE, 0xC59F, 0xE348, 0xD892,
    0xEBBF, 0xE798, 0xBB83, 0xE7B5, 0xDEA0, 0xCDB7, 0xC8A4, 0xD8C0, 0xFBB2, 0xD387, 0xC880, 0xE6FC, 0xD67F, 0xC9AD, 0xC7A8, 0xB426,
    0xC6A0, 0xB989, 0xA899, 0xB73A, 0xAAC5, 0xACE0, 0xA8B0, 0xC5EE, 0xB62F, 0xB7DB, 0xC504, 0xCFBC, 0xCBAF, 0xE0D6, 0x0519, 0xF2AF,
    0x0109, 0x11CA, 0x2E84, 0x27F9, 0x3E71, 0x3ED9, 0x4AA3, 0x51AB, 0x54A0, 0x5CB0, 0x63D3, 0x630B, 0x48C9, 0x60AF, 0x5C9C, 0x5DAA,
    0x3570, 0x385F, 0x3F99, 0x1F53, 0x065F, 0xF001, 0x092A, 0xECEA, 0xDCF6, 0xDF58, 0xD968, 0xC381, 0xB1D5, 0xB5DF, 0xB51A, 0xA575,
    0xA51B, 0xAB74, 0x918D, 0xA8A6, 0xAD4B, 0xBAD2, 0xBB32, 0xAAD1, 0xBD53, 0xBC83, 0xCA24, 0xCDB5, 0xB4AC, 0xB43D, 0xCBB4, 0xC2DF,
    0xC3C7, 0x0367, 0xED31, 0xE378, 0xF94E, 0xF865, 0x2181, 0x0E36, 0x22C3, 0x26A4, 0x295A, 0x2C65, 0x4FB4, 0x564D, 0x4ED5, 0x4EF6,
    0x59D5, 0x7F61, 0x41DD, 0x70CC, 0x6F01, 0x751D, 0x7674, 0x6759, 0x7BB8, 0x79CE, 0x7870, 0x6CBE, 0x73FE, 0x5E58, 0x6A7F, 0x6CBC,
    0x68B4, 0x51DD, 0x675B, 0x608E, 0x53D7, 0x5FB5, 0x5FCA, 0x511E, 0x452F, 0x5B94, 0x49F6, 0x4ABD, 0x4F8B, 0x39E0, 0x47EB, 0x501F,
    0x3ED9, 0x4345, 0x42D5, 0x311D, 0x2503, 0x3108, 0x1BB0, 0x0AD5, 0x06C9, 0x09C2, 0xEFD5, 0xEF6D, 0xE84F, 0xDD5E, 0xE1B4, 0xCFBB,
    0xDBA6, 0xCA50, 0xC914, 0xC2B0, 0xCD84, 0xC3AE, 0xAB76, 0xBF81, 0xB4B6, 0xAEA7, 0xADFD, 0xBCC3, 0xA647, 0xA810, 0xB61D, 0xA557,
    0xB760, 0xAEB8, 0xAE14, 0xACBE, 0xC79A, 0xAC02, 0xAF0A, 0xBBAC, 0xA420, 0xAE7A, 0xB137, 0xB297, 0xB793, 0xAAF1, 0xB116, 0xBE92,
    0xA324, 0xB3D9, 0xB5C3, 0xAD43, 0xB0C3, 0xB380, 0xA888, 0xB003, 0xB4A6, 0xB4EE, 0xAFFE, 0xBEB9, 0xA9AC, 0xB94A, 0xBCF5, 0xBE58,
    0xBCF1, 0xB36D, 0xCCD5, 0xBD11, 0xCCB8, 0xCA05, 0xD2FD, 0xCBC5, 0xD171, 0xC84D, 0xE75F, 0xCF48, 0xE260, 0xEB15, 0xD153, 0xDD05,
    0xE370, 0xFCCA, 0xDC3D, 0xE516, 0xE6C7, 0xF6C9, 0xEBC5, 0xE214, 0xDBF5, 0xE069, 0xE31A, 0xE0FD, 0xED09, 0xDF33, 0xD881, 0xF5EF,
    0xF1AC, 0xD8E7, 0xE675, 0xF3F3, 0xEE9E, 0xFA4A, 0xEFB0, 0xF144, 0x0684, 0x0121, 0x0767, 0x0E32, 0x232B, 0x1561, 0x23FB, 0x259C,
    0x374F, 0x36F2, 0x3403, 0x48AB, 0x4475, 0x452E, 0x4D1C, 0x5313, 0x4EC2, 0x49A8, 0x4B7A, 0x5B65, 0x50D6, 0x4049, 0x4CF6, 0x5C00,
    0x4E40, 0x5557, 0x5215, 0x4DF5, 0x5352, 0x60FB, 0x471A, 0x51DA, 0x5DE8, 0x517C, 0x47BD, 0x56A4, 0x5B38, 0x4921, 0x5F2E, 0x51C2,
    0x59D4, 0x6294, 0x5751, 0x6035, 0x6EEC, 0x5DAB, 0x6CDD, 0x660E, 0x6DF8, 0x726B, 0x6A3A, 0x6F0C, 0x7414, 0x69D0, 0x67E9, 0x720D,
    0x612A, 0x693C, 0x4F03, 0x55D9, 0x525D, 0x47B6, 0x44D2, 0x45D3, 0x41F0, 0x4000, 0x3C4B, 0x339D, 0x38AA, 0x31DE, 0x378F, 0x220F,
    0x272B, 0x29DA, 0x0993, 0x196B, 0x13E0, 0x0FDA, 0x1543, 0x0470, 0x1624, 0x02C9, 0x0716, 0x1363, 0x144E, 0x123B, 0x0B6D, 0x10BA,
    0x14D1, 0x1003, 0x018E, 0xFC5E, 0x0592, 0xFD5B, 0xE977, 0x119D, 0xF502, 0xE1A6, 0xF4FA, 0xECC4, 0xED97, 0xE1D8, 0xDEB6, 0xDEF9,
    0xE384, 0xD229, 0xD4BC, 0xE281, 0xD100, 0xD37C, 0xDCEB, 0xDEC1, 0xD8FB, 0xD9B7, 0xD5C2, 0xD722, 0xCD3C, 0xCA92, 0xD36A, 0xBACF,
    0xC796, 0xC2A2, 0xBB0A, 0xC0A0, 0xB9F9, 0xC48E, 0xBB3E, 0xBB5E, 0xBC80, 0xB843, 0xB3A2, 0xB46C, 0xADF2, 0xA569, 0xAC95, 0x9A39,
    0xA663, 0xA02C, 0x9FF6, 0x9DF5, 0x99D5, 0xAC11, 0x9600, 0x9D7D, 0x981D, 0x9EFC, 0xA374, 0x9E24, 0x96C8, 0xA1E4, 0x9C33, 0x9768,
    0xA7ED, 0x9969, 0xA6CC, 0x9B35, 0xA77C, 0xA512, 0xAA12, 0xA946, 0xB05F, 0xB101, 0xAC32, 0xBADF, 0xBB15, 0xBC22, 0xB3B6, 0xC68D,
    0xC126, 0xC524, 0xCC99, 0xD103, 0xC9B4, 0xDAD2, 0xD8E2, 0xD16A, 0xD480, 0xDCAF, 0xDE2E, 0xD6E8, 0xD821, 0xE652, 0xDBCA, 0xE2AC,
    0xEB83, 0xE489, 0xFB61, 0xE6D0, 0xF7AD, 0xE6CE, 0xF72B, 0xF7B6, 0xEEB6, 0xF744, 0xF365, 0x0334, 0xFFE1, 0x0199, 0x0763, 0x0984,
    0x0D5D, 0x087D, 0x0908, 0x157E, 0x12D0, 0x1475, 0x0E04, 0x1466, 0x0969, 0x11F6, 0x0C6E, 0x0484, 0xFDC2, 0xF4B9, 0xFE60, 0xECDA,
    0xEF56, 0xFA30, 0xF3D8, 0xE85A, 0xF5BC, 0xF1A5, 0xEBBE, 0xFFBF, 0xEEBA, 0xF3B7, 0xEED9, 0xF752, 0xF6F1, 0xFE7E, 0x0EBF, 0xEE91,
    0xFB47, 0x01E0, 0x0645, 0x0776, 0x0369, 0x0CEB, 0x156C, 0x123F, 0x18BA, 0x2033, 0x3196, 0x292C, 0x1C44, 0x2759, 0x3240, 0x20EF,
    0x2A7A, 0x2FF6, 0x1650, 0x2991, 0x2710, 0x26F6, 0x2EA5, 0x2A89, 0x2AAE, 0x3943, 0x332A, 0x39A0, 0x360A, 0x3B8A, 0x3A84, 0x3FA0,
    0x4122, 0x4396, 0x4CE5, 0x3F28, 0x4DBE, 0x51AF, 0x469D, 0x5407, 0x54A8, 0x558F, 0x5A8D, 0x4E33, 0x5CFB, 0x52D0, 0x5CEB, 0x592B,
    0x587E, 0x5850, 0x5F30, 0x5997, 0x5D72, 0x6051, 0x59D4, 0x5C15, 0x5264, 0x5AAD, 0x5D3B, 0x4DD3, 0x50F7, 0x5BDD, 0x4619, 0x56C4,
    0x4812, 0x4F42, 0x4B60, 0x4E24, 0x4A55, 0x40FA, 0x46A8, 0x423F, 0x38C1, 0x2CE7, 0x3A00, 0x2E99, 0x2832, 0x2DD8, 0x33DB, 0x2170,
    0x2EED, 0x37EE, 0x32EC, 0x2DCC, 0x340B, 0x309D, 0x2B30, 0x351B, 0x36C7, 0x2A89, 0x257A, 0x319A, 0x2FA1, 0x29ED, 0x237B, 0x2A27,
    0x17B2, 0x1F38, 0x1DA9, 0x168C, 0x154F, 0x1688, 0x1833, 0x0CE5, 0x09E9, 0x0F4B, 0x0756, 0x07F6, 0x12AD, 0x0251, 0x10AE, 0x18F9,
    0x144D, 0x0993, 0x149A, 0x18EE, 0x1328, 0x075B, 0x1A55, 0x12B7, 0x0E85, 0x1816, 0x1404, 0x1B52, 0x18EB, 0x2204, 0x188E, 0x1C0F,
    0x224E, 0x27B7, 0x04F7, 0x117A, 0x129A, 0xFB83, 0x0021, 0xFAFB, 0xF4C1, 0xEAD0, 0xEC9B, 0xF069, 0xE2A2, 0xE697, 0xE3D3, 0xDA57,
    0xE40D, 0xE0C9, 0xDD6C, 0xD8CA, 0xDAF8, 0xD43A, 0xD3B2, 0xCD56, 0xD4C5, 0xCEBE, 0xCEDC, 0xCB95, 0xD264, 0xD1DC, 0xCA57, 0xD61F,
    0xCB51, 0xD3F6, 0xD482, 0xD1E6, 0xD604, 0xD016, 0xCA15, 0xCAAD, 0xCCCF, 0xCA86, 0xCEED, 0xC3FA, 0xC54F, 0xC52A, 0xB085, 0xC1C9,
    0xBD79, 0xBB40, 0xBA84, 0xB3B7, 0xB4B7, 0xBC66, 0xBA79, 0xB437, 0xBABF, 0xB7FD, 0xB327, 0xB6BC, 0xB5B1, 0xB44C, 0xB905, 0xB165,
    0xB77B, 0xB43E, 0xBAEE, 0xBA87, 0xBBBE, 0xB956, 0xBBA7, 0xBE0F, 0xC086, 0xBD07, 0xBFC1, 0xBE67, 0xB95E, 0xC492, 0xB846, 0xBEA7,
    0xB4C8, 0xB613, 0xB23F, 0xB564, 0xAF80, 0xABB5, 0xB761, 0xAC7A, 0xAEE5, 0xA7E3, 0xABD0, 0xAD52, 0xA4FE, 0xAABB, 0xA8C6, 0xA711,
    0xA5A8, 0xAC8F, 0xA90B, 0xA2E9, 0xAEEF, 0xA346, 0xA6E4, 0xA77D, 0xAA5A, 0xA849, 0xA7BD, 0xAD05, 0xAF19, 0xB01A, 0xAC4C, 0xB911,
    0xB403, 0xB878, 0xBE51, 0xBA60, 0xBA66, 0xC0DD, 0xC06C, 0xBDEE, 0xC158, 0xC416, 0xC439, 0xC2A0, 0xCA59, 0xCD8A, 0xCBFA, 0xD114,
    0xD6A1, 0xD357, 0xDB04, 0xE377, 0xE081, 0xE867, 0xEC34, 0xF3A0, 0xFE9A, 0xFB13, 0xFD42, 0x0587, 0x0291, 0x06F7, 0x0714, 0x0648,
    0x12A0, 0x1158, 0x164C, 0x1060, 0x1A2A, 0x1F67, 0x1890, 0x1DD2, 0x21AD, 0x28AF, 0x226B, 0x24A1, 0x2F2C, 0x2330, 0x22BB, 0x2B32,
    0x1ED1, 0x1B62, 0x1F11, 0x1ED7, 0x1573, 0x1542, 0x1502, 0x1508, 0x1758, 0x1D6B, 0x1BEA, 0x1DC6, 0x1D15, 0x1823, 0x1B07, 0x1259,
    0x121A, 0x1015, 0x0CCC, 0x0FFE, 0x111A, 0x10F5, 0x18A5, 0x15B4, 0x158E, 0x1F70, 0x23AF, 0x2B65, 0x2C79, 0x2B71, 0x33C3, 0x33E0,
    0x377A, 0x3FA2, 0x3A6F, 0x3DE1, 0x3918, 0x4180, 0x3BC9, 0x37B5, 0x3FDF, 0x3697, 0x3BD2, 0x3599, 0x3C2C, 0x3A77, 0x3EBB, 0x39EA,
    0x39FB, 0x39FD, 0x3D60, 0x48D5, 0x39C5, 0x419F, 0x49BE, 0x4512, 0x4286, 0x4792, 0x429C, 0x3E98, 0x3EF3, 0x413E, 0x3DF5, 0x3AE6,
    0x3C49, 0x3DFF, 0x395F, 0x42A2, 0x40C6, 0x3C7C, 0x451E, 0x3EF2, 0x39A2, 0x3952, 0x3423, 0x3763, 0x3574, 0x2DDF, 0x351E, 0x337F,
    0x3885, 0x35F4, 0x34EA, 0x32AB, 0x3B74, 0x3855, 0x39B5, 0x3A2C, 0x380F, 0x3810, 0x34EA, 0x3B3D, 0x34D9, 0x3B21, 0x2C14, 0x2FDC,
    0x38E8, 0x323E, 0x368C, 0x33C5, 0x34C3, 0x364B, 0x3632, 0x39CD, 0x39A2, 0x39FE, 0x3708, 0x38EE, 0x3B10, 0x37E5, 0x401C, 0x3B2E,
    0x397D, 0x3D51, 0x3D09, 0x3ED1, 0x3763, 0x39E1, 0x36CC, 0x31B8, 0x2D13, 0x312C, 0x30DE, 0x297F, 0x2B97, 0x266F, 0x2979, 0x224B,
    0x2912, 0x2448, 0x1DA3, 0x2115, 0x1B3A, 0x1A5A, 0x1535, 0x1505, 0x10AE, 0x1019, 0x10A4, 0x11D8, 0x109F, 0x1775, 0x1755, 0x155C,
    0x1D3A, 0x183B, 0x1976, 0x1DC3, 0x19C4, 0x1AF9, 0x1809, 0x0E11, 0x0E77, 0x0CEF, 0x0AA1, 0x0406, 0xFEE1, 0xFC13, 0xF45F, 0xF35D,
    0xF09E, 0xEB98, 0xE883, 0xE83C, 0xE458, 0xE59C, 0xE2C8, 0xDFFA, 0xD9D6, 0xD9B6, 0xDBC2, 0xD3AD, 0xD080, 0xCEE2, 0xD2AD, 0xCC2C,
    0xCC2B, 0xCA98, 0xC2FB, 0xC762, 0xCBF8, 0xC7F5, 0xCCD7, 0xD416, 0xD993, 0xD48A, 0xD1BD, 0xD7B1, 0xD4F8, 0xD409, 0xCF6C, 0xCE6C,
    0xCA00, 0xCF30, 0xCDE7, 0xCEBE, 0xCF39, 0xCB90, 0xCFFF, 0xD2A4, 0xD7B9, 0xD2A2, 0xD3A1, 0xD7D6, 0xDA26, 0xDBBB, 0xDF60, 0xDFC6,
    0xDEA5, 0xDD69, 0xDCAE, 0xE060, 0xE2CF, 0xDF50, 0xDC5A, 0xE40C, 0xDD1C, 0xE39C, 0xE49F, 0xDA14, 0xE375, 0xDF7F, 0xDAAF, 0xDC1B,
    0xDC21, 0xDBA4, 0xDD77, 0xD487, 0xD25A, 0xDACA, 0xD33E, 0xD181, 0xCDC7, 0xCBFF, 0xC9C1, 0xC71F, 0xC654, 0xC217, 0xC38B, 0xC1B7,
    0xBF15, 0xBD65, 0xC27E, 0xB96F, 0xB2B4, 0xB05E, 0xB070, 0xAE40, 0xA831, 0xAA45, 0xA9B3, 0xA888, 0xA7F4, 0xAE30, 0xA980, 0xACD7,
    0xAF3A, 0xAFE8, 0xB1F3, 0xB2A5, 0xB573, 0xB6FE, 0xB671, 0xB823, 0xBC4F, 0xB94F, 0xBBF4, 0xBB7A, 0xBB91, 0xBD56, 0xBCC6, 0xBEB8,
    0xBC22, 0xBC69, 0xBF61, 0xBA9D, 0xC0F5, 0xC1D7, 0xBA07, 0xB925, 0xC0B2, 0xBFA2, 0xC0A5, 0xC9DB, 0xC735, 0xCA65, 0xCB8F, 0xCE5E,
    0xD100, 0xCD71, 0xCCF2, 0xCEB2, 0xC99E, 0xCFDD, 0xD285, 0xD39A, 0xDB4D, 0xDB73, 0xE06A, 0xE107, 0xE812, 0xE8F6, 0xE530, 0xEC0C,
    0xE960, 0xE154, 0xE95F, 0xE5C8, 0xE32D, 0xE36E, 0xE22A, 0xE4F0, 0xDBE9, 0xE0F5, 0xE256, 0xE037, 0xE1E4, 0xE169, 0xE64A, 0xE894,
    0xE928, 0xE89E, 0xE6EE, 0xEA9A, 0xEB9B, 0xE982, 0xED89, 0xEE61, 0xE9FB, 0xEEB9, 0xEDF5, 0xED3A, 0xF3D7, 0xF3CF, 0xF22E, 0xF3BB,
    0xF861, 0xFAD8, 0xFC08, 0xFFF4, 0x0674, 0x0322, 0x071C, 0x0E5D, 0x0C1B, 0x0A3C, 0x0B2B, 0x07B4, 0x068B, 0x0378, 0x055A, 0x0354,
    0x01EF, 0x0A29, 0x01F4, 0x0821, 0x099B, 0x0C35, 0x0BA6, 0x097E, 0x0CCD, 0x09A2, 0x0710, 0x0BBD, 0x089F, 0x0588, 0x0A9B, 0x077C,
    0x1238, 0x12E2, 0x1573, 0x1CA0, 0x196F, 0x1E19, 0x2239, 0x2194, 0x28F0, 0x2773, 0x2BAA, 0x2E86, 0x2E8B, 0x2F6B, 0x306D, 0x28BF,
    0x30CC, 0x3129, 0x2BE4, 0x305A, 0x2BBE, 0x3020, 0x2A36, 0x2D1C, 0x27FF, 0x2FC5, 0x28C5, 0x24CA, 0x2380, 0x23AD, 0x26D5, 0x214B,
    0x2351, 0x1FCA, 0x220D, 0x21EB, 0x206D, 0x1E18, 0x1E8D, 0x1B98, 0x1ADA, 0x1A0A, 0x1E9E, 0x2193, 0x2263, 0x2337, 0x27E9, 0x2AB4,
    0x2C6A, 0x2C5F, 0x2C4A, 0x2802, 0x2B15, 0x2BF7, 0x2A27, 0x2C8B, 0x2A8C, 0x2A80, 0x2DE9, 0x2EB8, 0x2EAE, 0x3101, 0x30CC, 0x3176,
    0x2E52, 0x3A72, 0x3981, 0x3E78, 0x3D1D, 0x3F29, 0x4586, 0x494A, 0x4CFC, 0x4BE5, 0x4F14, 0x4C71, 0x51A4, 0x50AB, 0x5566, 0x531B,
    0x5603, 0x5ADE, 0x5AB3, 0x5D49, 0x5E17, 0x5E7A, 0x5DF7, 0x609E, 0x666C, 0x65C7, 0x66D5, 0x64F1, 0x639B, 0x60CB, 0x5E52, 0x5E53,
    0x59BD, 0x5470, 0x5150, 0x5019, 0x4859, 0x4A95, 0x4445, 0x4233, 0x3C75, 0x3DA2, 0x3ABF, 0x33BC, 0x2F8F, 0x2958, 0x27CD, 0x1EFF,
    0x204B, 0x1E25, 0x1B5E, 0x1967, 0x1A4D, 0x1A73, 0x1C58, 0x1A07, 0x1949, 0x1A04, 0x1CEB, 0x1A69, 0x2065, 0x21D2, 0x20FC, 0x2251,
    0x1E98, 0x22C6, 0x1D5E, 0x1E3B, 0x1787, 0x17B7, 0x132B, 0x12B5, 0x10D6, 0x0F00, 0x0E3C, 0x0581, 0x0951, 0x0788, 0x0948, 0x095C,
    0x0AEC, 0x0F2E, 0x0FBC, 0x126C, 0x15CF, 0x13F9, 0x1305, 0x116B, 0x1559, 0x1167, 0x1309, 0x1619, 0x1035, 0x1589, 0x12DE, 0x1934,
    0x1701, 0x195A, 0x1CFA, 0x171E, 0x1A3B, 0x1915, 0x12F4, 0x0F43, 0x0CE4, 0x050F, 0x0707, 0x02A3, 0x0261, 0x0001, 0xFD48, 0xFE09,
    0xFB0E, 0xFC42, 0xFC1D, 0xFCC3, 0xF84E, 0xF868, 0xF68E, 0xF892, 0xF931, 0xF602, 0xF6B3, 0xF60D, 0xF762, 0xF8E0, 0xF42A, 0xF6BA,
    0xF7AC, 0xF72A, 0xF9E5, 0xF6EC, 0xFE48, 0xFB49, 0xFBBF, 0xFB05, 0xFF0A, 0xFDAE, 0xFCBE, 0x03AA, 0x0084, 0x0328, 0x0315, 0x0623,
    0x0047, 0x0255, 0x00A1, 0xFEA9, 0xFC0D, 0xF8D6, 0xF792, 0xF1FB, 0xF4A5, 0xF354, 0xF0AE, 0xF0A1, 0xF114, 0xED84, 0xEB01, 0xE6B9,
    0xE336, 0xE363, 0xE01D, 0xDE4D, 0xE050, 0xDDDD, 0xE178, 0xDF1D, 0xDCA4, 0xDECA, 0xDAD1, 0xDA20, 0xD988, 0xDA7A, 0xD92B, 0xDB37,
    0xDB7F, 0xD856, 0xDA5B, 0xD6E4, 0xD57A, 0xD358, 0xCF4E, 0xCC0F, 0xCAE1, 0xC98C, 0xC415, 0xC269, 0xBCC5, 0xBA5A, 0xB714, 0xB33E,
    0xB04E, 0xADB3, 0xAF2F, 0xAC27, 0xAD02, 0xAF7E, 0xAF69, 0xAF82, 0xADDB, 0xAE93, 0xAE1C, 0xAC30, 0xAD01, 0xAD94, 0xABC2, 0xAB9B,
    0xAC61, 0xAEAB, 0xB00B, 0xB322, 0xB4C8, 0xB4DF, 0xB9D6, 0xBAE7, 0xBD0F, 0xBB99, 0xBBDD, 0xBCDD, 0xBBE9, 0xBCC6, 0xBCE1, 0xBD76,
    0xBB24, 0xBCBD, 0xBEA4, 0xBE2E, 0xC063, 0xC0FF, 0xC128, 0xC617, 0xC909, 0xCD4F, 0xCF7C, 0xD48E, 0xD58F, 0xD6FB, 0xD84E, 0xD703,
    0xDC2C, 0xD636, 0xDAAF, 0xDD6F, 0xDD57, 0xE01C, 0xE266, 0xE422, 0xE15A, 0xE3B9, 0xE3B7, 0xE4CD, 0xE6B2, 0xE918, 0xEA82, 0xEA11,
    0xEBAE, 0xEAEA, 0xE938, 0xEA90, 0xE821, 0xE824, 0xE859, 0xE862, 0xE664, 0xE507, 0xE490, 0xE48D, 0xE441, 0xE3D5, 0xE421, 0xE0BA,
    0xE096, 0xDCB2, 0xD944, 0xD3A1, 0xD2EC, 0xCCAB, 0xCAA9, 0xCACD, 0xC9A2, 0xCCB8, 0xCB1D, 0xCD13, 0xC8FE, 0xCD37, 0xCECC, 0xD00B,
    0xD1BA, 0xD2BF, 0xD6A6, 0xDA4F, 0xDB30, 0xDF19, 0xDD1D, 0xDCCD, 0xDD0D, 0xD8BE, 0xDED3, 0xDBE7, 0xE0C1, 0xE048, 0xE140, 0xE3C5,
    0xE205, 0xE516, 0xE30F, 0xE632, 0xE99E, 0xEA0C, 0xEF1B, 0xF0DE, 0xF25E, 0xF512, 0xF915, 0xFCF8, 0xFEED, 0x05EA, 0x050B, 0x07BF,
    0x0768, 0x0534, 0x04E1, 0x03FD, 0x055B, 0x07E3, 0x0B31, 0x0EB9, 0x1461, 0x17AD, 0x1675, 0x170F, 0x1912, 0x15BD, 0x1879, 0x1700,
    0x181A, 0x16BC, 0x1854, 0x1A55, 0x1931, 0x1C26, 0x19AF, 0x1B4C, 0x18CE, 0x17E1, 0x1699, 0x16FD, 0x180C, 0x1782, 0x1AB1, 0x1BEC,
    0x1C34, 0x1E56, 0x19D2, 0x1A44, 0x1B93, 0x1923, 0x19CB, 0x187D, 0x1B14, 0x19EC, 0x1B23, 0x1A4F, 0x1A68, 0x1A6A, 0x1AF4, 0x1E88,
    0x211B, 0x22E1, 0x28F0, 0x2CA1, 0x2E55, 0x321F, 0x3336, 0x3486, 0x34C9, 0x3519, 0x319A, 0x32B1, 0x3132, 0x2F17, 0x2E45, 0x308F,
    0x32DB, 0x357F, 0x375B, 0x3811, 0x377B, 0x3449, 0x319D, 0x2FA0, 0x2E04, 0x2B77, 0x2BCA, 0x2AD0, 0x2D58, 0x2B64, 0x2D2E, 0x2B1F,
    0x2A62, 0x2C77, 0x2C1F, 0x2E8C, 0x2ED1, 0x30C3, 0x301A, 0x30F9, 0x3058, 0x3054, 0x2DA4, 0x2D4A, 0x2B58, 0x2A5F, 0x2A33, 0x27C3,
    0x2838, 0x262B, 0x26B5, 0x2387, 0x22BB, 0x2091, 0x1E73, 0x1D04, 0x1BC8, 0x1B47, 0x193E, 0x18CF, 0x1941, 0x199E, 0x17A5, 0x1683,
    0x14D7, 0x1647, 0x1346, 0x11A1, 0x101A, 0x0CCC, 0x0D23, 0x0E4B, 0x1097, 0x12EE, 0x154E, 0x1811, 0x1994, 0x1D68, 0x1BA7, 0x1C9A,
    0x1E35, 0x1C94, 0x1EFE, 0x1CC3, 0x1C86, 0x1DD3, 0x1FE4, 0x2186, 0x2392, 0x22E7, 0x24F6, 0x24F1, 0x288C, 0x2BB0, 0x2E82, 0x30AD,
    0x33B8, 0x354E, 0x36BB, 0x380F, 0x370A, 0x3B5B, 0x3928, 0x3C4D, 0x3E02, 0x40D1, 0x41F6, 0x401A, 0x3D8D, 0x3D17, 0x3B8D, 0x3A84,
    0x3BF6, 0x3CE8, 0x3DD2, 0x3F99, 0x3FB1, 0x4026, 0x40FA, 0x415F, 0x4338, 0x43F3, 0x465F, 0x461B, 0x46CC, 0x44F5, 0x44A1, 0x41A7,
    0x41D4, 0x3EFC, 0x3E2F, 0x3BA5, 0x37A5, 0x3579, 0x30B0, 0x2EA2, 0x28CE, 0x2496, 0x1DD3, 0x1B21, 0x1710, 0x1402, 0x10E1, 0x0BB6,
    0x0A77, 0x078F, 0x058A, 0x038A, 0x0195, 0xFFAE, 0xFDE0, 0xFE34, 0xFC73, 0xFC1B, 0xFCE9, 0xFD53, 0xFE76, 0x00FD, 0x0293, 0x016A,
    0x00FF, 0xFDAA, 0xFCDF, 0xFC57, 0xFA36, 0xF6E1, 0xF471, 0xF0FE, 0xEF18, 0xEF20, 0xECF9, 0xED4B, 0xEBCD, 0xECE9, 0xEF71, 0xF0BA,
    0xF1A4, 0xF389, 0xF41D, 0xF413, 0xF529, 0xF34C, 0xF208, 0xEE10, 0xEB67, 0xEB06, 0xEB61, 0xEE14, 0xEF4A, 0xF0DC, 0xF225, 0xF37C,
    0xF32D, 0xF320, 0xF018, 0xED08, 0xEB5F, 0xE927, 0xE86A, 0xE757, 0xE70F, 0xE689, 0xE818, 0xE902, 0xEAA9, 0xE9BB, 0xE7F1, 0xE781,
    0xE787, 0xE96F, 0xEA37, 0xEC52, 0xEB85, 0xEADC, 0xEC2E, 0xE9F1, 0xE8D4, 0xE6A2, 0xE642, 0xE581, 0xE4E2, 0xE5A0, 0xE4E3, 0xE4E6,
    0xE342, 0xE1BC, 0xE1CE, 0xE0ED, 0xE077, 0xE0AE, 0xDFA4, 0xE158, 0xE20B, 0xE539, 0xE6BC, 0xE617, 0xE5DC, 0xE5DF, 0xE3EC, 0xE34E,
    0xE2B0, 0xE0CD, 0xDFFC, 0xDD86, 0xDE85, 0xDE65, 0xE00B, 0xE1D5, 0xE2FA, 0xE225, 0xDFB0, 0xDDB0, 0xD9E5, 0xD753, 0xD46D, 0xD24E,
    0xD2D0, 0xD3CC, 0xD434, 0xD5A8, 0xD6B1, 0xD5E4, 0xD590, 0xD3D5, 0xD43B, 0xD250, 0xD3E5, 0xD53F, 0xD490, 0xD6E6, 0xD466, 0xD564,
    0xD436, 0xD425, 0xD3EE, 0xD3FE, 0xD5F8, 0xD464, 0xD3EA, 0xD370, 0xD469, 0xD350, 0xD05B, 0xCD71, 0xCACC, 0xC5B2, 0xC173, 0xBF8C,
    0xBCA6, 0xBBE8, 0xB9A1, 0xB93F, 0xB95F, 0xBA00, 0xBA20, 0xB82E, 0xB624, 0xB41A, 0xB251, 0xB1A3, 0xB0A8, 0xB1D7, 0xB388, 0xB362,
    0xB55E, 0xB5D3, 0xB79B, 0xB822, 0xBBB2, 0xBCD0, 0xBDC2, 0xC09E, 0xC1CA, 0xC160, 0xC20A, 0xC514, 0xC55D, 0xC6ED, 0xC80D, 0xC8E7,
    0xCAFF, 0xCB4E, 0xCBB7, 0xCF10, 0xD03F, 0xD4E4, 0xD765, 0xDBBD, 0xDF91, 0xE1AE, 0xE70A, 0xE95A, 0xEC61, 0xEDF1, 0xF053, 0xF231,
    0xF4D4, 0xF695, 0xF78E, 0xF8F3, 0xFA47, 0xFCC5, 0xFC95, 0xFE34, 0xFF6F, 0x002B, 0x0148, 0x006D, 0x0175, 0x0211, 0x01B5, 0x0183,
    0x01B8, 0x012C, 0xFDE8, 0xFB1C, 0xF9EE, 0xF805, 0xF515, 0xF315, 0xF2DA, 0xF21E, 0xF01B, 0xEE90, 0xEB3F, 0xE767, 0xE35C, 0xDFC8,
    0xDBA7, 0xD78E, 0xD41D, 0xD120, 0xD10E, 0xCDDF, 0xCC84, 0xCBFF, 0xCC94, 0xCB92, 0xCB2F, 0xCE4F, 0xCD18, 0xCE60, 0xD0E1, 0xD1C5,
    0xD3ED, 0xD764, 0xD9C8, 0xDE83, 0xDEB3, 0xDFA8, 0xE014, 0xE098, 0xE0E1, 0xE11E, 0xE3E3, 0xE545, 0xE7E1, 0xE692, 0xE5F4, 0xE5BC,
    0xE5FB, 0xE54F, 0xE872, 0xEA9A, 0xED53, 0xEF3A, 0xF2A7, 0xF5FA, 0xF730, 0xFACD, 0xFB76, 0xFD31, 0xFF9E, 0x0233, 0x0507, 0x078D,
    0x08FB, 0x0A96, 0x0A2F, 0x0DB0, 0x1063, 0x12B6, 0x12DA, 0x12AE, 0x126D, 0x10C3, 0x1108, 0x0EDE, 0x0F02, 0x0F93, 0x102E, 0x11B5,
    0x14A7, 0x14EF, 0x1638, 0x16F8, 0x1739, 0x17DE, 0x1760, 0x1793, 0x15ED, 0x1526, 0x1423, 0x1482, 0x130D, 0x1316, 0x1366, 0x1407,
    0x16F7, 0x1828, 0x19FE, 0x1B02, 0x1B25, 0x1BB1, 0x1CA9, 0x1DBB, 0x1DDD, 0x1DCF, 0x1F33, 0x1F1A, 0x2010, 0x22AE, 0x26B8, 0x2B98,
    0x2E02, 0x3086, 0x33DA, 0x359A, 0x361D, 0x3633, 0x3680, 0x3709, 0x3485, 0x32E2, 0x3180, 0x30EB, 0x3027, 0x2DC1, 0x2D5E, 0x2D7A,
    0x2CD7, 0x2B33, 0x2AEF, 0x2AD0, 0x292E, 0x286C, 0x26A5, 0x2688, 0x2803, 0x2837, 0x29A6, 0x295D, 0x2AA1, 0x2B4A, 0x2C5D, 0x2E12,
    0x2F4C, 0x31AB, 0x319F, 0x31CE, 0x311E, 0x30FB, 0x2F66, 0x2DF0, 0x2DC0, 0x2B49, 0x2C1B, 0x2C6D, 0x2D52, 0x2E1E, 0x2B8F, 0x2A79,
    0x2800, 0x2683, 0x23A8, 0x211A, 0x1E40, 0x1B7F, 0x1B5F, 0x1B53, 0x1ACA, 0x1A5A, 0x1B73, 0x1AEB, 0x1B2F, 0x18E6, 0x1802, 0x16CD,
    0x1470, 0x13B8, 0x134A, 0x12FD, 0x127D, 0x12F1, 0x14A1, 0x16F5, 0x18C8, 0x1A1F, 0x1AE9, 0x1CCD, 0x1B8B, 0x1ACE, 0x19FC, 0x17A4,
    0x15C2, 0x14CD, 0x15D8, 0x16EE, 0x18A0, 0x1974, 0x191F, 0x1BED, 0x1D7F, 0x1DF0, 0x1F78, 0x2173, 0x2621, 0x29D1, 0x2CF6, 0x3035,
    0x3237, 0x326B, 0x3258, 0x32C7, 0x351D, 0x38CB, 0x3D04, 0x3FA3, 0x4385, 0x4653, 0x4605, 0x46D8, 0x4602, 0x44E8, 0x44A4, 0x4509,
    0x44DB, 0x4569, 0x45BE, 0x44E0, 0x44AB, 0x470B, 0x4746, 0x471E, 0x46C2, 0x4510, 0x4527, 0x449E, 0x43F0, 0x44C0, 0x44B1, 0x42A4,
    0x40FD, 0x3E6A, 0x39D3, 0x342A, 0x2DAD, 0x265F, 0x1FBE, 0x193E, 0x15D5, 0x1251, 0x0ECB, 0x0DFF, 0x0BAD, 0x0866, 0x05B7, 0x039D,
    0x009A, 0xFF4C, 0xFED6, 0xFDFF, 0xFE5F, 0xFECB, 0xFFC7, 0x0124, 0x020B, 0x02C7, 0x0425, 0x037F, 0x02A6, 0x04B2, 0x057D, 0x0561,
    0x063D, 0x070F, 0x0706, 0x0532, 0x02A6, 0xFED6, 0xFBB3, 0xFA3A, 0xF7C6, 0xF8F3, 0xFC9B, 0xFE9F, 0xFFDF, 0x01AE, 0x0226, 0x028B,
    0x03DA, 0x0328, 0x0375, 0x0278, 0x0305, 0x03A5, 0x02F6, 0x0400, 0x0488, 0x0577, 0x0742, 0x0991, 0x0990, 0x0945, 0x0654, 0x029C,
    0x00A7, 0xFD59, 0xFAB4, 0xF96C, 0xF6E9, 0xF5C3, 0xF519, 0xF323, 0xF302, 0xF32D, 0xF29D, 0xF21A, 0xF3AA, 0xF50B, 0xF69D, 0xF852,
    0xF92E, 0xFAB2, 0xFA92, 0xFA76, 0xFC7D, 0xFD4D, 0xFEE3, 0x00B9, 0x02B3, 0x0497, 0x0602, 0x076D, 0x0591, 0x053D, 0x05A1, 0x0705,
    0x0937, 0x0B3A, 0x09C3, 0x09B7, 0x0B22, 0x0B8C, 0x0D1E, 0x0CD5, 0x0D37, 0x0C0D, 0x0A9A, 0x07FF, 0x06D4, 0x0494, 0x032A, 0x04E8,
    0x04F8, 0x03A9, 0x02C6, 0x00B6, 0xFE5D, 0xFF47, 0xFDD7, 0xFB91, 0xF8AA, 0xF550, 0xF16B, 0xEDB8, 0xEA48, 0xE5F9, 0xE3A2, 0xE181,
    0xE121, 0xE17A, 0xE159, 0xE21E, 0xE0AD, 0xDEFF, 0xDD09, 0xDB2A, 0xD9F7, 0xD7E9, 0xD62E, 0xD463, 0xD255, 0xD094, 0xCF0D, 0xCE1F,
    0xCD3B, 0xCD14, 0xCD6A, 0xCDDC, 0xCF24, 0xCED0, 0xCEA0, 0xCD2C, 0xCCB3, 0xCC85, 0xCB8A, 0xCABE, 0xC904, 0xC8BB, 0xC7C1, 0xC48B,
    0xC36A, 0xC26F, 0xC137, 0xC220, 0xC1D0, 0xC08D, 0xBF24, 0xBE32, 0xBC6B, 0xBAEB, 0xBA79, 0xBC1E, 0xBCE7, 0xBE2F, 0xBFFF, 0xC0EE,
    0xC195, 0xC210, 0xC0F4, 0xBEFD, 0xBEEA, 0xBEAE, 0xBFBE, 0xC081, 0xC145, 0xC2AE, 0xC456, 0xC57B, 0xC689, 0xC641, 0xC6AC, 0xC827,
    0xC87A, 0xC9E7, 0xCC43, 0xCF22, 0xD033, 0xD1CB, 0xD4C0, 0xD613, 0xD76C, 0xD8AC, 0xDBC9, 0xDF72, 0xE362, 0xE72D, 0xE968, 0xEA2A,
    0xEA5C, 0xEB77, 0xEC48, 0xEE68, 0xEF5C, 0xEFC5, 0xF0AC, 0xF20B, 0xF358, 0xF439, 0xF507, 0xF761, 0xF760, 0xF517, 0xF4C0, 0xF378,
    0xF24E, 0xF14B, 0xF250, 0xF3C9, 0xF330, 0xF300, 0xF38C, 0xF388, 0xF1B5, 0xEE7D, 0xEBA9, 0xE7F0, 0xE364, 0xE027, 0xDE55, 0xDC4D,
    0xDA90, 0xD931, 0xD6B0, 0xD3ED, 0xD103, 0xCED6, 0xCCD5, 0xCB70, 0xCA7D, 0xC9B3, 0xCA31, 0xCBD3, 0xCCB3, 0xCC5E, 0xCD3E, 0xCD0B,
    0xCD3F, 0xCDDA, 0xCE31, 0xD00C, 0xD088, 0xD1A7, 0xD274, 0xD426, 0xD5B2, 0xD414, 0xD423, 0xD470, 0xD60C, 0xD738, 0xD915, 0xDD77,
    0xE129, 0xE719, 0xEAAA, 0xEE0F, 0xF19D, 0xF21C, 0xF2E1, 0xF2B5, 0xF29C, 0xF2FE, 0xF567, 0xF7DF, 0xFA45, 0xFDFC, 0x01C3, 0x0690,
    0x0817, 0x0A42, 0x0B58, 0x0987, 0x082E, 0x06A6, 0x0694, 0x057A, 0x04DD, 0x05B2, 0x06C4, 0x065A, 0x087E, 0x0B03, 0x0BBA, 0x0E1E,
    0x1114, 0x1507, 0x18C3, 0x1A88, 0x1C34, 0x1D82, 0x1DEE, 0x1C36, 0x18F6, 0x163F, 0x12BA, 0x1189, 0x1189, 0x1235, 0x11A4, 0x1223,
    0x1278, 0x0F4C, 0x0D04, 0x0BE4, 0x0B4A, 0x0A7B, 0x0C08, 0x0D8C, 0x0E96, 0x1061, 0x11D8, 0x13DA, 0x15BE, 0x1857, 0x19F0, 0x19B6,
    0x1968, 0x19F1, 0x1C22, 0x1E5B, 0x200F, 0x230C, 0x24DE, 0x2730, 0x2829, 0x28AE, 0x28B8, 0x271E, 0x25FA, 0x23CE, 0x2306, 0x208C,
    0x1EF8, 0x1DC2, 0x1C36, 0x1B01, 0x1ACC, 0x1BE5, 0x1D76, 0x1F8A, 0x209E, 0x2204, 0x228D, 0x2396, 0x239F, 0x2301, 0x2423, 0x258F,
    0x2609, 0x25AD, 0x25D5, 0x24FD, 0x23B9, 0x2366, 0x2344, 0x22B9, 0x2174, 0x2062, 0x1E0B, 0x1C7F, 0x1B1F, 0x19AA, 0x173B, 0x14CA,
    0x13D3, 0x134C, 0x1309, 0x11EE, 0x118D, 0x1142, 0x1133, 0x10D8, 0x0F48, 0x0E06, 0x0D52, 0x0ACF, 0x07C0, 0x055C, 0x02E1, 0x01E2,
    0x0289, 0x03A8, 0x072A, 0x093A, 0x0A6E, 0x0C0B, 0x0CD3, 0x0E05, 0x0D7D, 0x0D3C, 0x0DB0, 0x0E27, 0x0ECD, 0x1052, 0x116D, 0x11F8,
    0x11F6, 0x121F, 0x1286, 0x1488, 0x168D, 0x1852, 0x1BEF, 0x1F2E, 0x2255, 0x25B9, 0x2A2D, 0x2CD7, 0x2F0A, 0x30BE, 0x3220, 0x3474,
    0x3535, 0x364F, 0x3781, 0x386C, 0x3935, 0x3A77, 0x3D55, 0x4023, 0x424D, 0x43C7, 0x448D, 0x44BF, 0x4468, 0x45A3, 0x4729, 0x4745,
    0x4695, 0x45B1, 0x4505, 0x445F, 0x43BF, 0x439F, 0x444A, 0x455F, 0x477D, 0x4A4F, 0x4D2E, 0x4E7D, 0x4E5D, 0x4D43, 0x4B31, 0x481C,
    0x435E, 0x3E07, 0x37E5, 0x31F8, 0x2C45, 0x25F7, 0x2008, 0x1B7F, 0x176A, 0x13E2, 0x105D, 0x0C24, 0x08EE, 0x06FB, 0x05A4, 0x04E3,
    0x043D, 0x03D9, 0x040A, 0x037A, 0x0361, 0x02E2, 0x0286, 0x01E2, 0x0162, 0x017A, 0x01CA, 0x02EE, 0x0323, 0x0344, 0x0271, 0x0110,
    0x0064, 0xFEFA, 0xFCFC, 0xFBF0, 0xFBC8, 0xFC79, 0xFCAF, 0xFD0D, 0xFD34, 0xFC92, 0xFB02, 0xF97A, 0xF7CA, 0xF6C2, 0xF6AE, 0xF645,
    0xF67A, 0xF6F5, 0xF97D, 0xFC11, 0xFE0B, 0xFFD8, 0x0095, 0x01C0, 0x0239, 0x01C6, 0x00E9, 0x0009, 0x0001, 0xFF7E, 0xFEF3, 0xFE9A,
    0xFD79, 0xFBDB, 0xFADC, 0xF9CF, 0xF94D, 0xF960, 0xF9AA, 0xFAD1, 0xFB54, 0xFC6A, 0xFCB7, 0xFC41, 0xFB6F, 0xFB42, 0xFB1A, 0xFA12,
    0xFA3B, 0xFB02, 0xFBEB, 0xFBE6, 0xFC55, 0xFB68, 0xF9F3, 0xF93F, 0xF87F, 0xF899, 0xF8E8, 0xF929, 0xF9AF, 0xFAB8, 0xFCDF, 0x0023,
    0x02F5, 0x0422, 0x0614, 0x06DF, 0x0649, 0x0638, 0x059F, 0x0478, 0x036F, 0x0383, 0x0344, 0x0377, 0x0502, 0x0534, 0x05AF, 0x0617,
    0x0321, 0x0218, 0x01CE, 0x00D7, 0x002D, 0xFEBD, 0xFD45, 0xFC55, 0xFA6E, 0xF761, 0xF65A, 0xF667, 0xF687, 0xF56A, 0xF50A, 0xF536,
    0xF5D7, 0xF6C8, 0xF846, 0xF8F6, 0xF908, 0xF8F5, 0xF6D0, 0xF423, 0xF15B, 0xEF53, 0xECEA, 0xEA9C, 0xE950, 0xE745, 0xE630, 0xE5CE,
    0xE577, 0xE59F, 0xE521, 0xE50A, 0xE471, 0xE4B2, 0xE503, 0xE4D7, 0xE52C, 0xE4BA, 0xE467, 0xE2FA, 0xE117, 0xDE4D, 0xDB03, 0xD6F9,
    0xD338, 0xCFCF, 0xCCFC, 0xCB3A, 0xCA77, 0xCB5B, 0xCCD5, 0xCEF9, 0xD14D, 0xD3AF, 0xD6A4, 0xD975, 0xDC00, 0xDEEB, 0xE171, 0xE380,
    0xE586, 0xE767, 0xE8D4, 0xEA5A, 0xEB7B, 0xEC9E, 0xEE26, 0xF03D, 0xF3D4, 0xF6A3, 0xF97B, 0xFBE3, 0xFDB2, 0xFFC5, 0x0214, 0x0379,
    0x04B1, 0x05D0, 0x06D3, 0x08C3, 0x0946, 0x09CD, 0x0A46, 0x0B9A, 0x0DFB, 0x107E, 0x1387, 0x15CC, 0x17DC, 0x1943, 0x1A9D, 0x1BD8,
    0x1C81, 0x1CBF, 0x1C34, 0x1B53, 0x1A75, 0x193C, 0x1793, 0x14E1, 0x11D8, 0x0E9C, 0x0C0D, 0x0A88, 0x09A9, 0x0A16, 0x09F7, 0x09C3,
    0x0921, 0x07BF, 0x060D, 0x03F8, 0x0134, 0xFED8, 0xFCC5, 0xFA52, 0xF828, 0xF57F, 0xF2F5, 0xF014, 0xED44, 0xEADB, 0xE8C8, 0xE68E,
    0xE497, 0xE395, 0xE29E, 0xE23F, 0xE1BA, 0xE142, 0xE124, 0xE114, 0xE1BB, 0xE2C1, 0xE3BD, 0xE4B7, 0xE51E, 0xE564, 0xE582, 0xE5BB,
    0xE664, 0xE6BC, 0xE705, 0xE71F, 0xE660, 0xE5E7, 0xE55E, 0xE4D0, 0xE4A1, 0xE4C1, 0xE5A2, 0xE61E, 0xE6B1, 0xE723, 0xE78B, 0xE806,
    0xE813, 0xE7B6, 0xE7BE, 0xE83D, 0xE901, 0xE994, 0xE971, 0xE94B, 0xE92E, 0xE9BE, 0xEB1E, 0xEDAE, 0xF09D, 0xF391, 0xF5FF, 0xF705,
    0xF6EC, 0xF65A, 0xF542, 0xF402, 0xF233, 0xF03F, 0xEEBD, 0xEDE5, 0xEE8A, 0xEFA2, 0xF19D, 0xF3AF, 0xF5CB, 0xF86B, 0xF9E8, 0xFBFB,
    0xFE12, 0x003C, 0x02E7, 0x0538, 0x0794, 0x0985, 0x0985, 0x0875, 0x0602, 0x02B9, 0x0058, 0xFD92, 0xFB93, 0xFB0C, 0xFB80, 0xFBD5,
    0xFC91, 0xFCE2, 0xFC62, 0xFC2B, 0xFCD2, 0xFD87, 0xFE96, 0x0031, 0x0147, 0x014B, 0x00B2, 0x0008, 0xFEFA, 0xFE49, 0xFDB9, 0xFDC1,
    0xFE0A, 0xFF68, 0x00D1, 0x01E3, 0x0315, 0x030C, 0x037E, 0x034C, 0x0304, 0x02B8, 0x013E, 0xFFBE, 0xFD8E, 0xFAA1, 0xF7F5, 0xF5F8,
    0xF52E, 0xF59E, 0xF693, 0xF7D9, 0xF92E, 0xF9DB, 0xFA7E, 0xFB8E, 0xFCC0, 0xFE11, 0xFF95, 0x004F, 0x0067, 0xFF97, 0xFE65, 0xFC84,
    0xFA63, 0xF86F, 0xF6AE, 0xF5B9, 0xF4FD, 0xF494, 0xF454, 0xF419, 0xF2F9, 0xF214, 0xF0B8, 0xEF6F, 0xEE64, 0xED19, 0xEC62, 0xEBA9,
    0xEB33, 0xEA8C, 0xE9A8, 0xE83F, 0xE70F, 0xE56A, 0xE3BF, 0xE221, 0xE0DA, 0xE064, 0xDFA4, 0xDF72, 0xDFC3, 0xDFF6, 0xE01C, 0xE021,
    0xE064, 0xE0E4, 0xE17E, 0xE297, 0xE431, 0xE4F9, 0xE572, 0xE576, 0xE447, 0xE35C, 0xE26B, 0xE1CF, 0xE18A, 0xE15E, 0xE199, 0xE198,
    0xE1E2, 0xE248, 0xE363, 0xE48B, 0xE6A8, 0xE941, 0xEC30, 0xEFAE, 0xF232, 0xF432, 0xF5F6, 0xF8B9, 0xFC79, 0x00CF, 0x05DB, 0x0A34,
    0x0D3B, 0x0F48, 0x1031, 0x114A, 0x1271, 0x1472, 0x17F7, 0x1B67, 0x1E3B, 0x1F5B, 0x1EF9, 0x1D69, 0x1AB2, 0x17A6, 0x14EF, 0x12E3,
    0x118A, 0x1125, 0x1196, 0x12D3, 0x1409, 0x151D, 0x15A7, 0x15C6, 0x1600, 0x16E2, 0x17C7, 0x18AC, 0x19F4, 0x1A53, 0x19E6, 0x17CA,
    0x14EC, 0x1097, 0x0B96, 0x05B3, 0xFFDC, 0xFAA2, 0xF5A3, 0xF1C1, 0xEE95, 0xEBC6, 0xE8DF, 0xE67A, 0xE447, 0xE287, 0xE163, 0xE0EA,
    0xE074, 0xE010, 0xDF96, 0xDF1F, 0xDEA5, 0xDE37, 0xDD90, 0xDCAD, 0xDBE4, 0xDB2B, 0xDB19, 0xDB10, 0xDBA5, 0xDC6E, 0xDDA5, 0xDF26,
    0xE17E, 0xE2E8, 0xE406, 0xE592, 0xE604, 0xE5BE, 0xE4EC, 0xE429, 0xE35E, 0xE325, 0xE362, 0xE4DE, 0xE615, 0xE797, 0xE957, 0xEB42,
    0xEEA7, 0xF20A, 0xF58C, 0xF903, 0xFBA4, 0xFD1F, 0xFDB7, 0xFD1D, 0xFBD1, 0xFA06, 0xF86E, 0xF6EB, 0xF58F, 0xF558, 0xF4C9, 0xF4F9,
    0xF58F, 0xF56E, 0xF5CB, 0xF572, 0xF569, 0xF5FB, 0xF76A, 0xF9E5, 0xFC68, 0xFF37, 0x0115, 0x02D7, 0x0446, 0x0539, 0x0625, 0x06C0,
    0x07A9, 0x0913, 0x0A91, 0x0C46, 0x0DA3, 0x0E24, 0x0E33, 0x0DB9, 0x0D3B, 0x0D61, 0x0D53, 0x0D4B, 0x0D65, 0x0DC9, 0x0E5E, 0x0EF8,
    0x0F5E, 0x0F39, 0x0EBA, 0x0DD6, 0x0D7A, 0x0DDA, 0x0E11, 0x0EBB, 0x0F19, 0x0E90, 0x0E93, 0x0EBB, 0x0EC9, 0x0F56, 0x1014, 0x10F3,
    0x11C6, 0x1146, 0x107A, 0x0EDD, 0x0D85, 0x0D0C, 0x0D3C, 0x0EB3, 0x0F8E, 0x0F8F, 0x0EA6, 0x0CD4, 0x0A50, 0x07F7, 0x0727, 0x0713,
    0x0838, 0x0953, 0x0942, 0x0866, 0x0632, 0x0317, 0x0008, 0xFD5A, 0xFAEA, 0xF96A, 0xF7D2, 0xF685, 0xF598, 0xF3E2, 0xF286, 0xF165,
    0xF0C1, 0xF0DB, 0xF112, 0xF24B, 0xF429, 0xF5E3, 0xF7BB, 0xF913, 0xFA0D, 0xFABA, 0xFA7F, 0xF911, 0xF64E, 0xF249, 0xEE22, 0xE9CA,
    0xE5DC, 0xE39C, 0xE24D, 0xE153, 0xE0A2, 0xE0B0, 0xE126, 0xE1ED, 0xE2E1, 0xE41D, 0xE5E6, 0xE76E, 0xE974, 0xEAEB, 0xEB1E, 0xEB08,
    0xEABA, 0xEA6F, 0xEA93, 0xEB0D, 0xEB7C, 0xEC75, 0xEDB2, 0xEFDA, 0xF214, 0xF4D7, 0xF849, 0xFB8E, 0xFEF3, 0x021D, 0x045B, 0x060A,
    0x0783, 0x083B, 0x0986, 0x0B5E, 0x0DCA, 0x1067, 0x1279, 0x1489, 0x1679, 0x18C3, 0x1BF8, 0x1FDB, 0x234F, 0x260C, 0x27E9, 0x2871,
    0x283A, 0x265B, 0x2404, 0x21FF, 0x1FFC, 0x1EE3, 0x1E58, 0x1E89, 0x1EA0, 0x1E51, 0x1D35, 0x1BCA, 0x1AAF, 0x193A, 0x1837, 0x17BA,
    0x1785, 0x1712, 0x15F2, 0x140D, 0x1159, 0x0E67, 0x0BB9, 0x08C4, 0x0567, 0x0247, 0xFF04, 0xFBA9, 0xF87E, 0xF533, 0xF203, 0xEEB4,
    0xEBC0, 0xE92E, 0xE702, 0xE587, 0xE404, 0xE2E6, 0xE1D3, 0xE1B8, 0xE26A, 0xE389, 0xE4EF, 0xE5BF, 0xE673, 0xE699, 0xE751, 0xE884,
    0xE94E, 0xEAB4, 0xECA8, 0xEE67, 0xF02E, 0xF1CC, 0xF2DA, 0xF44C, 0xF634, 0xF84F, 0xFB3C, 0xFDC2, 0xFF7E, 0x00DB, 0x0125, 0x01B6,
    0x02A8, 0x03EC, 0x052E, 0x06AB, 0x07C8, 0x0878, 0x09A9, 0x0AE5, 0x0BF6, 0x0D19, 0x0ED1, 0x10E7, 0x12AC, 0x13C2, 0x13D4, 0x1345,
    0x11F1, 0x108B, 0x0F6F, 0x0E93, 0x0D9D, 0x0C60, 0x0B34, 0x098C, 0x083E, 0x077A, 0x0793, 0x0808, 0x0969, 0x0BA0, 0x0D89, 0x0FDC,
    0x120C, 0x13C4, 0x1547, 0x16CB, 0x17FC, 0x1880, 0x17B0, 0x15C3, 0x12E5, 0x0F9C, 0x0C02, 0x08A7, 0x05D1, 0x03B3, 0x01E0, 0x00D5,
    0x003C, 0xFFC2, 0xFFDB, 0xFFDD, 0x004A, 0x0113, 0x01DA, 0x02A6, 0x0320, 0x0401, 0x050C, 0x0579, 0x063F, 0x071B, 0x0890, 0x0A54,
    0x0BF8, 0x0DED, 0x0F8F, 0x1174, 0x1350, 0x148C, 0x162A, 0x16A0, 0x167B, 0x15B7, 0x1441, 0x12A6, 0x10A8, 0x0E9C, 0x0C1A, 0x0981,
    0x0778, 0x05B9, 0x0484, 0x04F5, 0x0584, 0x068A, 0x0765, 0x06DD, 0x0607, 0x041D, 0x0251, 0x00A2, 0xFEB6, 0xFD00, 0xFB7C, 0xFA90,
    0xF96A, 0xF7BB, 0xF623, 0xF3F5, 0xF21B, 0xF05C, 0xEEC2, 0xED44, 0xEC0A, 0xEB36, 0xEB03, 0xEA40, 0xE9C5, 0xE94E, 0xE85F, 0xE810,
    0xE72F, 0xE676, 0xE506, 0xE307, 0xE0EB, 0xDF78, 0xDE9C, 0xDE87, 0xDEA4, 0xDEC3, 0xDF35, 0xDF43, 0xE05F, 0xE1BE, 0xE35D, 0xE59E,
    0xE78C, 0xE9BE, 0xEC6C, 0xEE5C, 0xEFE9, 0xF0DA, 0xF10F, 0xF116, 0xF0EB, 0xF145, 0xF284, 0xF43F, 0xF5B8, 0xF702, 0xF7E2, 0xF844,
    0xF92C, 0xFAA2, 0xFCA4, 0xFF69, 0x0232, 0x04B6, 0x06C5, 0x0860, 0x0972, 0x0AB8, 0x0C1E, 0x0DD2, 0x1020, 0x12D1, 0x15DB, 0x18A8,
    0x1AEF, 0x1C54, 0x1CD2, 0x1D14, 0x1D20, 0x1DB7, 0x1F1E, 0x1FFE, 0x20EF, 0x21B1, 0x21FB, 0x22AE, 0x22C6, 0x22E5, 0x2280, 0x21A9,
    0x20CF, 0x1FCD, 0x1FE0, 0x2004, 0x2088, 0x218E, 0x22A5, 0x239D, 0x23C9, 0x23CB, 0x233F, 0x22ED, 0x234B, 0x2367, 0x22CB, 0x220D,
    0x1FF9, 0x1C84, 0x18CA, 0x137F, 0x0E2A, 0x0939, 0x04DF, 0x00EE, 0xFDE6, 0xFBBF, 0xF961, 0xF7A0, 0xF6B6, 0xF6E4, 0xF7D6, 0xF8CC,
    0xF922, 0xF91A, 0xF8B2, 0xF7A6, 0xF66B, 0xF57B, 0xF441, 0xF352, 0xF2C3, 0xF1E6, 0xF058, 0xEE49, 0xECC8, 0xEB90, 0xEB5E, 0xEC06,
    0xED45, 0xEE39, 0xEEE6, 0xEEA9, 0xECE2, 0xEA94, 0xE7F7, 0xE59C, 0xE3EE, 0xE337, 0xE35C, 0xE4A7, 0xE669, 0xE859, 0xEB1C, 0xEDDE,
    0xF097, 0xF36E, 0xF637, 0xF8A4, 0xFA96, 0xFC17, 0xFD2F, 0xFD82, 0xFDC1, 0xFDEF, 0xFDB0, 0xFD7C, 0xFD57, 0xFD07, 0xFC76, 0xFC57,
    0xFC7A, 0xFCA4, 0xFD7A, 0xFECA, 0x0020, 0x01B1, 0x02C4, 0x0398, 0x0494, 0x05C8, 0x06E8, 0x07CC, 0x0873, 0x0898, 0x08CF, 0x0973,
    0x0A33, 0x0B12, 0x0BB8, 0x0BBA, 0x0BA6, 0x0BCE, 0x0C21, 0x0C02, 0x0C89, 0x0D0F, 0x0D0A, 0x0DA0, 0x0DE3, 0x0E06, 0x0E4A, 0x0DA3,
    0x0CBC, 0x0BF1, 0x0B87, 0x0BBD, 0x0C3F, 0x0D90, 0x0E49, 0x0EA1, 0x0E7E, 0x0E02, 0x0D6A, 0x0D3C, 0x0DC8, 0x0E4B, 0x0F55, 0x0FA2,
    0x0F3B, 0x0E0D, 0x0BCF, 0x097A, 0x0756, 0x0645, 0x0691, 0x07DC, 0x09FE, 0x0B72, 0x0C3F, 0x0B9F, 0x0935, 0x0669, 0x0449, 0x0349,
    0x030C, 0x03DA, 0x04DE, 0x0572, 0x059D, 0x0524, 0x03E4, 0x0263, 0x00D4, 0xFED6, 0xFCC2, 0xFA7D, 0xF84E, 0xF636, 0xF4BA, 0xF3C8,
    0xF378, 0xF2F3, 0xF2D2, 0xF31A, 0xF3E8, 0xF539, 0xF688, 0xF779, 0xF7FD, 0xF884, 0xF903, 0xF900, 0xF7F2, 0xF659, 0xF3EA, 0xF0EC,
    0xEE69, 0xECF0, 0xEC99, 0xED67, 0xEE84, 0xF0AB, 0xF367, 0xF5CD, 0xF839, 0xF9A5, 0xFAA9, 0xFB94, 0xFC06, 0xFC66, 0xFCCB, 0xFD4E,
    0xFD59, 0xFD7E, 0xFD18, 0xFBEC, 0xFB27, 0xFAE5, 0xFBB0, 0xFD7C, 0x0123, 0x057B, 0x0A2C, 0x0E9E, 0x122F, 0x1488, 0x1625, 0x16F9,
    0x1784, 0x18AE, 0x1A29, 0x1CA0, 0x1E82, 0x20D2, 0x22FF, 0x2495, 0x2603, 0x2705, 0x2784, 0x26B0, 0x2613, 0x2580, 0x24B8, 0x242A,
    0x2305, 0x21AB, 0x2099, 0x1F1D, 0x1D59, 0x1B40, 0x18C6, 0x16E4, 0x15C1, 0x1530, 0x14D3, 0x1464, 0x13F7, 0x1421, 0x153F, 0x1681,
    0x1590, 0x136B, 0x1194, 0x0FEA, 0x0EF1, 0x0CF4, 0x09DE, 0x06B7, 0x038F, 0x00E7, 0xFE50, 0xFBE1, 0xF9BB, 0xF75E, 0xF526, 0xF309,
    0xF124, 0xF0A5, 0xF05E, 0xF0B6, 0xF10F, 0xF0BA, 0xF015, 0xEF15, 0xEE16, 0xED50, 0xECE1, 0xECD3, 0xECB5, 0xECAF, 0xECF8, 0xEC50,
    0xEB7D, 0xEA43, 0xE934, 0xE91C, 0xE992, 0xEB97, 0xEDD9, 0xF01D, 0xF1C4, 0xF235, 0xF2AF, 0xF2BB, 0xF272, 0xF2B5, 0xF375, 0xF49D,
    0xF6B1, 0xF9D9, 0xFD96, 0x00BA, 0x0352, 0x0503, 0x05CA, 0x064E, 0x0728, 0x07CC, 0x0900, 0x0B3A, 0x0CC1, 0x0E2F, 0x0F55, 0x0FDA,
    0x0FE8, 0x0F65, 0x0E87, 0x0D11, 0x0B94, 0x09F7, 0x0874, 0x07D8, 0x07BF, 0x07D3, 0x087D, 0x0A0D, 0x0B7F, 0x0DA8, 0x0F9D, 0x11C4,
    0x1437, 0x163F, 0x1941, 0x1C29, 0x1EB8, 0x2034, 0x201E, 0x1EE6, 0x1C92, 0x193F, 0x1622, 0x12D4, 0x1072, 0x0EED, 0x0D92, 0x0C94,
    0x0BE8, 0x0B76, 0x0A30, 0x08F4, 0x0815, 0x06E0, 0x0677, 0x05AD, 0x04C8, 0x0483, 0x0377, 0x02B4, 0x0194, 0xFFA2, 0xFE14, 0xFD98,
    0xFE62, 0x005F, 0x0353, 0x069A, 0x0965, 0x0C24, 0x0E75, 0x0FA2, 0x0FE9, 0x0FE0, 0x10A2, 0x116D, 0x12E0, 0x14B3, 0x15E1, 0x16E3,
    0x1784, 0x179E, 0x17B5, 0x17F1, 0x18A0, 0x19A4, 0x1AA2, 0x1B31, 0x1B36, 0x1A9F, 0x1922, 0x176A, 0x15A7, 0x13D4, 0x1222, 0x107F,
    0x0EB4, 0x0C78, 0x0AB7, 0x08B1, 0x06BC, 0x0548, 0x03BC, 0x0297, 0x0188, 0x0074, 0xFEDC, 0xFD25, 0xFB72, 0xF9E0, 0xF847, 0xF692,
    0xF51A, 0xF377, 0xF0CA, 0xEDE7, 0xEBAC, 0xE91F, 0xE89C, 0xE7F0, 0xE785, 0xE859, 0xE88A, 0xE992, 0xEA15, 0xE9F5, 0xE9A5, 0xE924,
    0xE87F, 0xE80D, 0xE839, 0xE7BA, 0xE756, 0xE6D8, 0xE64A, 0xE5EB, 0xE52F, 0xE46F, 0xE44F, 0xE4F7, 0xE66B, 0xE97D, 0xED5C, 0xF138,
    0xF521, 0xF8AA, 0xFB97, 0xFEF3, 0x0194, 0x04B5, 0x08A9, 0x0C6C, 0x10E4, 0x148E, 0x18F4, 0x1E2E, 0x231D, 0x278B, 0x2B0C, 0x2D1A,
    0x2DC0, 0x2E6E, 0x2DF8, 0x2CD1, 0x2C8F, 0x2BB9, 0x2AFA, 0x2AD6, 0x2A22, 0x2919, 0x27DF, 0x2624, 0x248F, 0x2281, 0x1FC7, 0x1DEE,
    0x1BDE, 0x19DC, 0x18AD, 0x173A, 0x1674, 0x1634, 0x158C, 0x14BF, 0x1442, 0x13B7, 0x126E, 0x11A3, 0x1073, 0x108C, 0x105C, 0x0E9C,
    0x0CC2, 0x0955, 0x0530, 0x0070, 0xFBEB, 0xF7CB, 0xF4FC, 0xF307, 0xF16E, 0xF0B9, 0xEF26, 0xEE1C, 0xEE12, 0xED80, 0xED99, 0xED86,
    0xEDC3, 0xEE25, 0xEDF3, 0xED35, 0xEC32, 0xEA64, 0xE83F, 0xE692, 0xE4E6, 0xE529, 0xE669, 0xE813, 0xEA78, 0xEC61, 0xED9E, 0xEF57,
    0xF12B, 0xF2CB, 0xF4E5, 0xF6B4, 0xF78F, 0xF8AD, 0xF980, 0xFA34, 0xFB33, 0xFB0A, 0xFA82, 0xFA84, 0xFAF0, 0xFBBF, 0xFD15, 0xFDA8,
    0xFE4F, 0xFF53, 0xFF78, 0xFFA5, 0xFFA3, 0xFF1B, 0xFEDC, 0xFECF, 0xFE40, 0xFDA0, 0xFCC1, 0xFBF7, 0xFB8F, 0xFB9C, 0xFC51, 0xFD04,
    0xFDBD, 0xFF43, 0x00A6, 0x021F, 0x03FE, 0x0559, 0x0779, 0x0A6C, 0x0CD9, 0x0F87, 0x11AB, 0x12F3, 0x1315, 0x12D7, 0x12B1, 0x1281,
    0x1357, 0x133F, 0x13BE, 0x1451, 0x13CE, 0x12CE, 0x11C1, 0x113E, 0x11B2, 0x123B, 0x1240, 0x1319, 0x139D, 0x141E, 0x1501, 0x14F4,
    0x145C, 0x1425, 0x13A4, 0x1385, 0x13F0, 0x14C4, 0x1590, 0x16E2, 0x1763, 0x175B, 0x16C5, 0x15A5, 0x1406, 0x1239, 0x115B, 0x1074,
    0x0EB4, 0x0DC7, 0x0D0E, 0x0B77, 0x0A79, 0x09F8, 0x099C, 0x09AE, 0x0B10, 0x0AE4, 0x0AC8, 0x0927, 0x0850, 0x0664, 0x0506, 0x03BE,
    0x025E, 0x0107, 0x040B, 0x0416, 0x039A, 0xFD6A, 0xF765, 0x06E9, 0x0A28, 0x0740, 0x063D, 0xFF1B, 0xF4B7, 0xF44F, 0xEECD, 0xE181,
    0xD17C, 0xCF53, 0xCD59, 0xC1FC, 0xBDF1, 0xBCB3, 0xC75B, 0xC59B, 0xC621, 0xC681, 0xCAFC, 0xD337, 0xD1A4, 0xD646, 0xD7A3, 0xD63C,
    0xD99E, 0xD6EA, 0xD527, 0xD2BA, 0xD33A, 0xD360, 0xD7D1, 0xDB86, 0xE1C3, 0xE163, 0xE375, 0xE638, 0xD77B, 0xEE12, 0xFD8F, 0xF188,
    0xE689, 0xE4C1, 0xE40A, 0xE8EE, 0xF34C, 0xFD33, 0x0404, 0x0667, 0x1698, 0x24A4, 0x2829, 0x3468, 0x44EC, 0x48F2, 0x445F, 0x495C,
    0x4D10, 0x514D, 0x56FB, 0x4F69, 0x4814, 0x3EA9, 0x4023, 0x33E3, 0x25D0, 0x189B, 0x1314, 0x0FF7, 0x0068, 0xFEC9, 0xFBE4, 0x0118,
    0xFDFF, 0xF2CA, 0xF5A1, 0xF0DC, 0xF1B3, 0xF6DB, 0xF78B, 0xF0C8, 0xF1DE, 0xF3B9, 0xECE1, 0xEE90, 0xE877, 0xEC75, 0xE43E, 0xE942,
    0xE9C4, 0xE283, 0xF19F, 0xF041, 0xE1AC, 0xE359, 0xF2DF, 0xF231, 0xEC50, 0xE320, 0xDCE6, 0xD985, 0xD92D, 0xE2ED, 0xE639, 0xE3DC,
    0xECB3, 0xFA22, 0xFD6D, 0x02BC, 0x14A1, 0x1B49, 0x203E, 0x2003, 0x219B, 0x255D, 0x2C39, 0x3077, 0x24BD, 0x1F36, 0x19A6, 0x1A9E,
    0x1068, 0xFFF6, 0xF97A, 0xF023, 0xE9C2, 0xDC62, 0xD6F5, 0xDC23, 0xDB3D, 0xDAA6, 0xDAE9, 0xDB53, 0xD6EE, 0xE233, 0xE5D1, 0xE867,
    0xE7B3, 0xE896, 0xECDF, 0xE684, 0xEF15, 0xEB96, 0xE705, 0xED33, 0xEB08, 0xE3B8, 0xF0F7, 0xFCE7, 0xF6AD, 0xF2A5, 0xF986, 0x0697,
    0x0AAB, 0x07CB, 0x0630, 0xFDB3, 0xF71A, 0xFCC4, 0x040F, 0xFD9A, 0x0256, 0x0F20, 0x12A9, 0x1874, 0x2118, 0x2F6A, 0x3551, 0x3BAD,
    0x3B35, 0x3A40, 0x4246, 0x4A36, 0x4F8A, 0x4758, 0x42DD, 0x42B6, 0x3AC1, 0x3033, 0x1DDE, 0x14CB, 0x0BDF, 0xFEED, 0xF2DD, 0xF308,
    0xF372, 0xF248, 0xF8B0, 0xF4BB, 0xF66B, 0xF52A, 0xFEE1, 0x0245, 0xFE91, 0x0221, 0xFB71, 0xF32B, 0xF4CF, 0xEEEF, 0xE4E6, 0xEAA7,
    0xE763, 0xDCDB, 0xDE89, 0xE904, 0xEF08, 0xE991, 0xE754, 0xEF52, 0xF8A7, 0xFC61, 0x01E4, 0x0046, 0xF196, 0xF404, 0xF970, 0xF8F5,
    0xFA3E, 0x03D5, 0x0EC7, 0x12E7, 0x1B59, 0x2348, 0x2DB5, 0x3484, 0x3415, 0x2ECA, 0x2415, 0x25DF, 0x2690, 0x1F46, 0x1521, 0x0D9E,
    0x0AC8, 0x03AE, 0xF797, 0xEA88, 0xE7A4, 0xDAB5, 0xD2C9, 0xCE5B, 0xCACF, 0xCBA6, 0xCCCA, 0xD1BE, 0xCE62, 0xCD79, 0xD3D5, 0xD80B,
    0xDAE4, 0xE41E, 0xE37A, 0xE035, 0xE402, 0xDDE3, 0xD55F, 0xD744, 0xDCC1, 0xD9B2, 0xD6DB, 0xE0ED, 0xF09B, 0xF9DA, 0xF7A3, 0xFF3F,
    0x0674, 0x0BA1, 0x1A0C, 0x1EEF, 0x165D, 0x0BE3, 0x0B30, 0x05C2, 0xFD79, 0xFCE5, 0xFBEC, 0xFE6A, 0xFD27, 0xFE1C, 0x03F5, 0x0BA5,
    0x1839, 0x1B2E, 0x1954, 0x1924, 0x2260, 0x285B, 0x2AA4, 0x281F, 0x2AAB, 0x3202, 0x2DDB, 0x2D99, 0x2C34, 0x2A35, 0x2479, 0x1B86,
    0x13D5, 0x074B, 0xFE1E, 0xFB9C, 0xF119, 0xEC01, 0xF02D, 0xED51, 0xEF59, 0xF644, 0xF8C7, 0xFC41, 0x0269, 0x0717, 0xFD50, 0xF463,
    0xF436, 0xF195, 0xE405, 0xD7BE, 0xDF33, 0xE402, 0xE26F, 0xE0B1, 0xE2F7, 0xE55D, 0xF02F, 0x05A8, 0x0D1B, 0x0D59, 0x0F86, 0x0F9C,
    0x0D09, 0x04BA, 0x018A, 0xFF03, 0xFF0E, 0xFDC5, 0xF9A1, 0xFB0B, 0x03E7, 0x0DC0, 0x0DCF, 0x0E0E, 0x0E76, 0x178F, 0x1C5F, 0x190B,
    0x1A8B, 0x1D4E, 0x1EC7, 0x215A, 0x1EBD, 0x19EE, 0x12AE, 0x0905, 0x0557, 0xFAC9, 0xF2BE, 0xF36D, 0xEC5D, 0xE45E, 0xE703, 0xE618,
    0xE645, 0xF0C0, 0xF53F, 0xF6B4, 0xFB85, 0xFC1C, 0xFF98, 0xFA79, 0xF3D6, 0xF8BE, 0xF06B, 0xE0C6, 0xD9B8, 0xD568, 0xD4D5, 0xD8E6,
    0xD7E8, 0xCF68, 0xD013, 0xD873, 0xE3BC, 0xE933, 0xE7B2, 0xE95A, 0xE67C, 0xE2BE, 0xDDEB, 0xDB46, 0xD9E4, 0xE012, 0xE356, 0xE6FD,
    0xF5F7, 0x087F, 0x1F55, 0x273B, 0x2945, 0x32BD, 0x3BB4, 0x3E03, 0x3C27, 0x3EE0, 0x414C, 0x3EDB, 0x4080, 0x4255, 0x376F, 0x3133,
    0x2B83, 0x1DBF, 0x17D0, 0x15AD, 0x149E, 0x1182, 0x0D39, 0x04A5, 0xFB6E, 0xF95D, 0xFD6F, 0xFD0B, 0xF8FD, 0x0005, 0x02E1, 0xFE85,
    0xFD60, 0x01A5, 0x0448, 0xFAEB, 0xF1C5, 0xE8A4, 0xDA26, 0xD38E, 0xD39A, 0xCC04, 0xBD7E, 0xB9F4, 0xBE83, 0xC3B6, 0xC636, 0xC8C7,
    0xCAC7, 0xC962, 0xCAED, 0xCA8E, 0xCD96, 0xD432, 0xDD46, 0xE688, 0xE8F3, 0xF1E7, 0x065E, 0x16F2, 0x1BDE, 0x1C96, 0x2459, 0x2FCF,
    0x3529, 0x3821, 0x3CD8, 0x3BF0, 0x3D2F, 0x419C, 0x4003, 0x3D7A, 0x3C92, 0x32E4, 0x23F2, 0x1D3B, 0x1463, 0x1081, 0x12C4, 0x0D94,
    0x02DF, 0xFA73, 0xF8DD, 0xF883, 0xF1B6, 0xEDE4, 0xF78A, 0xF9C2, 0xF008, 0xEF4A, 0xF22A, 0xF13B, 0xED27, 0xE51F, 0xDCEE, 0xD5EA,
    0xD3C7, 0xD599, 0xD335, 0xCC97, 0xCE12, 0xD33F, 0xDC19, 0xE784, 0xEF74, 0xF869, 0xFD6C, 0xFB0A, 0xF834, 0xF600, 0xF53D, 0xF8AC,
    0xF603, 0xF456, 0xFB94, 0x0AF0, 0x1A3E, 0x20AA, 0x289F, 0x36B1, 0x4311, 0x51BA, 0x5D6B, 0x5FCC, 0x648F, 0x6699, 0x62DA, 0x62E2,
    0x6357, 0x5D3A, 0x55A8, 0x4CA4, 0x4298, 0x39FF, 0x3300, 0x3388, 0x2EF7, 0x2181, 0x18CD, 0x1377, 0x0B49, 0x015D, 0xFED1, 0xFFC4,
    0xF9A7, 0xED0B, 0xE3D8, 0xDDAE, 0xD965, 0xD67E, 0xCF7A, 0xC809, 0xC32C, 0xC3A0, 0xC35D, 0xC168, 0xBF94, 0xBDA5, 0xC079, 0xC564,
    0xC91B, 0xCECF, 0xD4B2, 0xDAFC, 0xDDB6, 0xD8D0, 0xD867, 0xDD84, 0xE00B, 0xDDAA, 0xDAD3, 0xE498, 0xF321, 0xFF3D, 0x0C39, 0x15B8,
    0x1B8F, 0x24D7, 0x3268, 0x38CE, 0x3D4E, 0x451B, 0x45EC, 0x4138, 0x4155, 0x40C6, 0x3BC5, 0x365B, 0x2E1D, 0x2027, 0x1364, 0x0BF1,
    0x0990, 0x04AF, 0xFB9B, 0xFB21, 0xF753, 0xEE35, 0xEB25, 0xEB49, 0xEAAB, 0xEBAC, 0xEA4C, 0xE6AF, 0xE648, 0xE8C9, 0xEEE1, 0xEE1D,
    0xE90B, 0xE945, 0xE954, 0xE6FD, 0xE1A2, 0xDB08, 0xD66A, 0xD41D, 0xD562, 0xD900, 0xDCA3, 0xE590, 0xEF4E, 0xF33B, 0xF18A, 0xF1B6,
    0xFAD1, 0xFEBC, 0xF818, 0xF40E, 0xF80C, 0xFC01, 0x0214, 0x0923, 0x089D, 0x0A60, 0x11B8, 0x1A68, 0x268B, 0x319B, 0x3A89, 0x4067,
    0x411A, 0x41D3, 0x4253, 0x3F56, 0x3CC6, 0x353B, 0x240D, 0x1437, 0x089F, 0xFDED, 0xF3D5, 0xED73, 0xEB7D, 0xE699, 0xDDEC, 0xDB48,
    0xDD3C, 0xDE63, 0xE159, 0xE57E, 0xE420, 0xE23D, 0xE63F, 0xE9FA, 0xE9A6, 0xE44E, 0xE239, 0xE51F, 0xE13D, 0xDA68, 0xD609, 0xD1CA,
    0xD2BC, 0xD792, 0xDBC6, 0xE0D6, 0xE9F2, 0xF5F3, 0xFD3D, 0xFD85, 0x0290, 0x0ECC, 0x14E6, 0x1575, 0x1616, 0x1680, 0x1C7F, 0x261A,
    0x2952, 0x2A44, 0x2BFC, 0x2BB7, 0x2B8A, 0x328D, 0x3B29, 0x40D0, 0x463E, 0x4782, 0x45B5, 0x4101, 0x3C9C, 0x39F6, 0x315B, 0x21E3,
    0x1954, 0x147B, 0x0BA5, 0x0504, 0x0240, 0x03A5, 0x027F, 0xFC5F, 0xF7E5, 0xF49D, 0xF1BE, 0xF198, 0xEE9B, 0xE989, 0xE5C4, 0xE260,
    0xE16E, 0xDE68, 0xD96A, 0xD765, 0xD9DA, 0xDC78, 0xDAD0, 0xD701, 0xD4F1, 0xD541, 0xD61D, 0xD492, 0xD190, 0xD376, 0xD60B, 0xD29D,
    0xCF4A, 0xD184, 0xD4E8, 0xD9C0, 0xDB6E, 0xD740, 0xD719, 0xDC6E, 0xE38D, 0xE946, 0xEF16, 0xF3E3, 0xF543, 0xF3AE, 0xF7E4, 0xFF93,
    0x0393, 0x0AD2, 0x12D6, 0x14A7, 0x14CA, 0x1983, 0x1DBE, 0x1BE5, 0x1651, 0x141C, 0x132A, 0x0D29, 0x07BD, 0x0686, 0x0619, 0x05DF,
    0x02F3, 0xFD1C, 0xFBDF, 0xFF1C, 0x025C, 0x0541, 0x0597, 0x07FF, 0x0A71, 0x0924, 0x080E, 0x049E, 0x00E9, 0x01FC, 0x0500, 0x026F,
    0xF934, 0xEFEC, 0xED68, 0xECEE, 0xE891, 0xE815, 0xEEB3, 0xEFEF, 0xEE47, 0xEB9F, 0xE828, 0xE915, 0xEE09, 0xF27C, 0xF0F4, 0xF1A4,
    0xF631, 0xFB12, 0xFF54, 0x058E, 0x09D7, 0x0B0D, 0x0D46, 0x13C7, 0x1AE3, 0x1F9E, 0x2A74, 0x33A0, 0x36A4, 0x3B57, 0x40A0, 0x3FDA,
    0x3A8F, 0x3539, 0x2C01, 0x2116, 0x155E, 0x03AA, 0xFB38, 0xF205, 0xEA14, 0xEEBE, 0xE984, 0xE116, 0xE256, 0xE0AB, 0xDDF5, 0xE055,
    0xDEB6, 0xE383, 0xE199, 0xD7D8, 0xD0F7, 0xC8AC, 0xC667, 0xC95B, 0xC9AE, 0xC17D, 0xBAE9, 0xB95F, 0xB726, 0xB29A, 0xB628, 0xBDA7,
    0xC1D4, 0xC327, 0xBF33, 0xBA9C, 0xBA21, 0xBBD7, 0xBB91, 0xBA08, 0xB9E3, 0xBE06, 0xC1A9, 0xC9FC, 0xD53F, 0xDBD6, 0xE591, 0xEFF6,
    0xF908, 0x03DA, 0x103F, 0x1E80, 0x2A38, 0x303B, 0x3769, 0x3F96, 0x412D, 0x402E, 0x43AC, 0x4579, 0x42A0, 0x4375, 0x3DCB, 0x3887,
    0x38AE, 0x3634, 0x3847, 0x3D58, 0x3B25, 0x36B4, 0x3956, 0x3423, 0x339C, 0x3A8E, 0x3964, 0x3C53, 0x37B7, 0x2BAB, 0x2358, 0x17DB,
    0x1455, 0x1725, 0x09BC, 0xFF29, 0xFB27, 0xF020, 0xEE52, 0xE9F0, 0xE2ED, 0xE049, 0xDA5E, 0xD1AC, 0xCC75, 0xCCAD, 0xD20A, 0xD756,
    0xD77C, 0xD983, 0xDA87, 0xDD8C, 0xE649, 0xEE4A, 0xF114, 0xF7B2, 0xFFEC, 0x0062, 0xFFEC, 0x0623, 0x100B, 0x154A, 0x182E, 0x1C59,
    0x22F5, 0x283A, 0x2A81, 0x2D46, 0x2CF2, 0x2A9C, 0x2757, 0x1E9B, 0x1306, 0x071B, 0xFABA, 0xF3E5, 0xEEA5, 0xE9F1, 0xE867, 0xE8E8,
    0xE88F, 0xE475, 0xE