#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/clocks.h"
#include "bsp_st7262.h"
#include "pio_rgb.h"
#include "rp_pico_alloc.h"

#include "img_1.h"
#include "img_2.h"
#include "img_3.h"

#define LCD_WIDTH 800
#define LCD_HEIGHT 480

void set_cpu_clock(uint32_t freq_Mhz)
{
    set_sys_clock_khz(freq_Mhz * 1000, true);
    clock_configure(
        clk_peri,
        0,
        CLOCKS_CLK_PERI_CTRL_AUXSRC_VALUE_CLKSRC_PLL_SYS,
        freq_Mhz * 1000 * 1000,
        freq_Mhz * 1000 * 1000);
}

extern uint16_t test_count;

int main()
{
    set_cpu_clock(250);
    stdio_init_all();
    
    bsp_display_interface_t *display_if;
    pio_rgb_info_t rgb_info;
    rgb_info.width = LCD_WIDTH;
    rgb_info.height = LCD_HEIGHT;
    rgb_info.transfer_size = LCD_WIDTH * 120;
    rgb_info.pclk_freq = 20 * 1000 * 1000;
    rgb_info.mode.double_buffer = true;
    rgb_info.mode.enabled_transfer = true;
    rgb_info.mode.enabled_psram = true;
    rgb_info.framebuffer1 = rp_mem_malloc(LCD_WIDTH * LCD_HEIGHT * sizeof(uint16_t));
    rgb_info.framebuffer2 = rp_mem_malloc(LCD_WIDTH * LCD_HEIGHT * sizeof(uint16_t));
    rgb_info.transfer_buffer1 = malloc(rgb_info.transfer_size * sizeof(uint16_t));
    rgb_info.transfer_buffer2 = malloc(rgb_info.transfer_size * sizeof(uint16_t));
    rgb_info.dma_flush_done_cb = NULL;

    bsp_display_info_t display_info;
    display_info.width = LCD_WIDTH;
    display_info.height = LCD_HEIGHT;
    display_info.brightness = 100;
    display_info.dma_flush_done_cb = NULL;
    display_info.user_data = &rgb_info;

    bsp_display_new_st7262(&display_if, &display_info);
    display_if->init();
    uint16_t *buffer = rgb_info.framebuffer1;
    while (true)
    {
        buffer = pio_rgb_get_free_framebuffer();
        memcpy(buffer, gImage_img_1, display_info.width * display_info.height * sizeof(uint16_t));
        display_if->flush_dma(NULL, NULL);
        sleep_ms(200);

        buffer = pio_rgb_get_free_framebuffer();
        memcpy(buffer, gImage_img_2, display_info.width * display_info.height * sizeof(uint16_t));
        display_if->flush_dma(NULL, NULL);
        sleep_ms(200);

        buffer = pio_rgb_get_free_framebuffer();
        memcpy(buffer, gImage_img_3, display_info.width * display_info.height * sizeof(uint16_t));
        display_if->flush_dma(NULL, NULL);
        sleep_ms(200);
    }
}
