# -*- coding: utf-8 -*-
import serial
import binascii
import time

# Configure the serial port
ser = serial.Serial(
    port="/dev/ttySC0",
#  port="/dev/ttySC1",
    baudrate=9600,
    timeout=1
)

# Data to be sent (010400000003b00b)
sent_data = bytes.fromhex('01 04 00 00 00 03 B0 0B')
ser.write(sent_data)

print("Wait to receive data (press Ctrl+C to exit)")
while True:
    # Clear the input buffer
    ser.flushInput()

    # Wait for data to arrive
    while ser.inWaiting() == 0:
        time.sleep(0.01)  # 10ms delay

    # Read the data
    received_data = ser.readline()

    # Filter out the data you sent
    if received_data and received_data != sent_data:
        hex_str = binascii.hexlify(received_data).decode('utf-8')
        print(f"Received: {hex_str}")
    