#!/usr/bin/env python
# -*- coding: utf-8 -*-

import serial
import threading
import sys

def read_serial(ser):
    while True:
        if ser.in_waiting:
            data = ser.read(ser.in_waiting)
            if sys.version_info[0] < 3:
                sys.stdout.write(data)
            else:
                sys.stdout.write(data.decode('utf-8', errors='replace'))
            sys.stdout.flush()

ser = serial.Serial("/dev/ttyUSB2", 115200, timeout=0.1)
thread = threading.Thread(target=read_serial, args=(ser,))
thread.daemon = True
thread.start()

print("AT Command Terminal (type 'exit' to quit)")
while True:
    if sys.version_info[0] < 3:
        cmd = raw_input()
    else:
        cmd = input()
    if cmd.lower() == 'exit':
        break
    ser.write((cmd + '\r\n').encode('utf-8') if sys.version_info[0] >= 3 else cmd + '\r\n')

ser.close()