#pragma once
#include <cstdint>

//====================== SX1262 引脚（按你的实际接线改） ======================
#define LORA_CS_PIN     21
#define LORA_DIO1_PIN   16
#define LORA_RST_PIN    18
#define LORA_BUSY_PIN   20

#define LORA_SPI_BUS    0
#define LORA_SPI_HZ     2000000

//====================== ChirpStack (EU868 / OTAA / MSB) ======================
// Device EUI (EU64): 3e00ccc619639e9e
static const uint8_t LORAWAN_DEV_EUI[8]  = { 0x3E,0x00,0xCC,0xC6,0x19,0x63,0x9E,0x9E };

// Join EUI (EU64): 39f2438b570461e0
static const uint8_t LORAWAN_JOIN_EUI[8] = { 0x39,0xF2,0x43,0x8B,0x57,0x04,0x61,0xE0 };

// Application key (AppKey): 99bd2c10174f707ba7d41c0e1c2cb6fe  (ChirpStack 右侧选择的是 MSB)
static const uint8_t LORAWAN_APP_KEY[16] = {
  0x99,0xBD,0x2C,0x10, 0x17,0x4F,0x70,0x7B,
  0xA7,0xD4,0x1C,0x0E, 0x1C,0x2C,0xB6,0xFE
};

// 你当前 Device Profile 是 LoRaWAN 1.0.4（截图里显示），不需要 NwkKey。
// 若你的库硬要填，先跟 AppKey 填一样用于排查也行。
static const uint8_t LORAWAN_NWK_KEY[16] = {
  0x99,0xBD,0x2C,0x10, 0x17,0x4F,0x70,0x7B,
  0xA7,0xD4,0x1C,0x0E, 0x1C,0x2C,0xB6,0xFE
};

#define UPLINK_FPORT        10
#define UPLINK_CONFIRMED    0
